/*
 * Copyright (c) 2011-2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SOC_MEMORY_MAP_H
#define _SOC_MEMORY_MAP_H

#define BAAD_STATUS		0xbaadbaad
#define GOOD_STATUS		0x900d900d

// CPU Memory Map
//#define MMDC1_BASE_ADDR           0x10000000
//#define MMDC1_END_ADDR            0x7FFFFFFF
//#define MMDC0_BASE_ADDR           0x80000000
//#define MMDC0_END_ADDR            0xFFFFFFFF
#define OCRAM_BASE_ADDR			0x00900000
#define OCRAM_END_ADDR			0x009FFFFF
#define IRAM_BASE_ADDR          OCRAM_BASE_ADDR
#define PCIE_BASE_ADDR			0x01000000
#define PCIE_END_ADDR			0x01FFFFFF

#define ROMCP_ARB_BASE_ADDR     0x00000000
#define ROMCP_ARB_END_ADDR      0x000FFFFF
#define BOOT_ROM_BASE_ADDR      ROMCP_ARB_BASE_ADDR
#define CAAM_SEC_RAM_START_ADDR	0x00100000
#define CAAM_SEC_RAM_END_ADDR	0x00103FFF
#define GPMI_BASE_ADDR          0x00112000
#define APBH_DMA_BASE_ADDR		0x00110000
#define APBH_DMA_END_ADDR		0x00117FFF
#define HDMI_BASE_ADDR			0x00120000
#define HDMI_END_ADDR			0x00128FFF
#define GPU_3D_BASE_ADDR		0x00130000
#define GPU_3D_END_ADDR			0x00133FFF
#define GPU_2D_BASE_ADDR		0x00134000
#define GPU_2D_END_ADDR			0x00137FFF
#define DTCP_BASE_ADDR			0x00138000
#define DTCP_END_ADDR			0x0013BFFF
#define GPU_MEM_BASE_ADDR       GPU_3D_BASE_ADDR

#define GPV0_BASE_ADDR          0x00B00000
#define GPV1_BASE_ADDR          0x00C00000
#define GPV2_BASE_ADDR          0x00200000
#define GPV3_BASE_ADDR          0x00300000
#define GPV4_BASE_ADDR          0x00800000

#define AIPS1_ARB_BASE_ADDR     0x02000000
#define AIPS1_ARB_END_ADDR      0x020FFFFF
#define AIPS2_ARB_BASE_ADDR     0x02100000
#define AIPS2_ARB_END_ADDR      0x021FFFFF
#define OPENVG_BASE_ADDR        0x02204000
#define OPENVG_END_ADDR         0x02207FFF
#define HSI_BASE_ADDR           0x02208000
#define HSI_END_ADDR            0x0220BFFF
#define IPU1_BASE_ADDR          0x02400000
#define IPU1_END_ADDR           0x027FFFFF
#define IPU2_BASE_ADDR          0x02800000
#define IPU2_END_ADDR           0x02BFFFFF
#define WEIM_CS_BASE_ADDR       0x08000000
#define WEIM_CS_END_ADDR        0x0FFFFFFF

// CoreSight (ARM Debug)
#define DEBUG_ROM_BASE_ADDR     0x02140000
#define ETB_BASE_ADDR           0x02141000
#define EXT_CTI_BASE_ADDR       0x02142000
#define TPIU_BASE_ADDR          0x02143000
#define FUNNEL_BASE_ADDR        0x02144000
#define CORTEX_ROM_TABLE        0x0214F000
#define CORTEX_DEBUG_UNIT       0x02150000
#define CORE0_DEBUG_UNIT		0x02150000
#define PMU0_BASE_ADDR			0x02151000
#define CORE1_DEBUG_UNIT		0x02152000
#define PMU1_BASE_ADDR			0x02153000
#define CORE2_DEBUG_UNIT		0x02154000
#define PMU2_BASE_ADDR			0x02155000
#define CORE3_DEBUG_UNIT		0x02156000
#define PMU3_BASE_ADDR			0x02157000
#define CTI0_BASE_ADDR			0x02158000
#define CTI1_BASE_ADDR			0x02159000
#define CTI2_BASE_ADDR			0x0215A000
#define CTI3_BASE_ADDR			0x0215B000
#define PTM0_BASE_ADDR			0x0215C000
#define PTM_BASE_ADDR			0x0215C000
#define PTM1_BASE_ADDR			0x0215D000
#define PTM2_BASE_ADDR			0x0215E000
#define PTM3_BASE_ADDR			0x0215F000

#define AIPS_TZ1_BASE_ADDR		AIPS1_ARB_BASE_ADDR
#define AIPS_TZ2_BASE_ADDR		AIPS2_ARB_BASE_ADDR

#define SPDIF_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x04000)    //slot 1
#define ECSPI1_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x08000)    //slot 2
#define ECSPI2_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x0C000)    //slot 3
#define ECSPI3_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x10000)    //slot 4
#define ECSPI4_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x14000)    //slot 5
#define ECSPI5_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x18000)    //slot 6
#define UART1_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x20000)    //slot 8
#define ESAI1_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x24000)    //slot 9
#define SSI1_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x28000)    //slot 10
#define SSI2_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x2C000)    //slot 11
#define SSI3_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x30000)    //slot 12
#define ASRC_BASE_ADDR          (AIPS_TZ1_BASE_ADDR+0x34000)    //slot 13
#define SPBA_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x3C000)    //slot 15
#define VPU_BASE_ADDR			(AIPS_TZ1_BASE_ADDR+0x40000)    //slot 33, global en[1], til 0x7BFFF

#define AIPS1_ON_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x7C000)
#define AIPS1_OFF_BASE_ADDR		(AIPS_TZ1_BASE_ADDR+0x80000)

#define PWM1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x0000)
#define PWM2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x4000)
#define PWM3_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x8000)
#define PWM4_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0xC000)
#define CAN1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x10000)
#define CAN2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x14000)
#define GPT_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x18000)
#define GPIO1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x1C000)
#define GPIO2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x20000)
#define GPIO3_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x24000)
#define GPIO4_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x28000)
#define GPIO5_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x2C000)
#define GPIO6_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x30000)
#define GPIO7_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x34000)
#define KPP_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x38000)
#define WDOG1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x3C000)
#define WDOG2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x40000)
#define CCM_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x44000)
#define IP2APB_USBPHY1_BASE_ADDR    (AIPS1_OFF_BASE_ADDR+0x49000)
#define IP2APB_USBPHY2_BASE_ADDR    (AIPS1_OFF_BASE_ADDR+0x4A000)
#define SNVS_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x4C000)
#define EPIT1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x50000)
#define EPIT2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x54000)
#define SRC_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x58000)
#define GPC_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x5C000)
#define IOMUXC_BASE_ADDR		(AIPS1_OFF_BASE_ADDR+0x60000)
#define DCIC1_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x64000)
#define DCIC2_BASE_ADDR			(AIPS1_OFF_BASE_ADDR+0x68000)
#define SDMA_BASE_ADDR          (AIPS1_OFF_BASE_ADDR+0x6C000)
#define SDMA_IPS_HOST_BASE_ADDR SDMA_BASE_ADDR
#define EPDC_BASE_ADDR          (AIPS1_OFF_BASE_ADDR+0x74000)

#define AIPS2_ON_BASE_ADDR      (AIPS_TZ2_BASE_ADDR+0x7C000)
#define AIPS2_OFF_BASE_ADDR     (AIPS_TZ2_BASE_ADDR+0x80000)

#define AIPS1_BASE_ADDR			AIPS1_ON_BASE_ADDR
#define AIPS2_BASE_ADDR			AIPS2_ON_BASE_ADDR

#define CAAM_BASE_ADDR			AIPS_TZ2_BASE_ADDR
#define ARM_IPS_BASE_ADDR		(AIPS_TZ2_BASE_ADDR+0x40000)

#define USBOH3_PL301_BASE_ADDR	(AIPS2_OFF_BASE_ADDR+0x0000)
#define USBOH3_USB_BASE_ADDR	(AIPS2_OFF_BASE_ADDR+0x4000)
#define ENET_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x8000)
#define MLB_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0xC000)
#define USDHC1_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x10000)
#define USDHC2_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x14000)
#define USDHC3_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x18000)
#define USDHC4_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x1C000)
#define I2C1_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x20000)
#define I2C2_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x24000)
#define I2C3_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x28000)
#define ROMCP_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x2C000)
#define MMDC_P0_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x30000)
#define MMDC_P1_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x34000)
#define WEIM_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x38000)
#define OCOTP_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x3C000)
#define CSU_BASE_ADDR			(AIPS2_OFF_BASE_ADDR+0x40000)
#define PERFMON1_BASE_ADDR      (AIPS2_OFF_BASE_ADDR+0x44000)
#define PERFMON2_BASE_ADDR      (AIPS2_OFF_BASE_ADDR+0x48000)
#define PERFMON3_BASE_ADDR      (AIPS2_OFF_BASE_ADDR+0x4C000)
#define IP2APB_TZASC1_BASE_ADDR (AIPS2_OFF_BASE_ADDR+0x50000)
#define IP2APB_TZASC2_BASE_ADDR (AIPS2_OFF_BASE_ADDR+0x54000)
#define AUDMUX_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x58000)
#define MIPI_CSI2_BASE_ADDR		(AIPS2_OFF_BASE_ADDR+0x5C000)
#define MIPI_DSI_BASE_ADDR	    (AIPS2_OFF_BASE_ADDR+0x60000)
#define VDOA_BASE_ADDR		    (AIPS2_OFF_BASE_ADDR+0x64000)
#define UART2_BASE_ADDR	    	(AIPS2_OFF_BASE_ADDR+0x68000)
#define UART3_BASE_ADDR	    	(AIPS2_OFF_BASE_ADDR+0x6C000)
#define UART4_BASE_ADDR	    	(AIPS2_OFF_BASE_ADDR+0x70000)
#define UART5_BASE_ADDR	    	(AIPS2_OFF_BASE_ADDR+0x74000)

// Cortex-A9 MPCore private memory region
#define ARM_PERIPHBASE			    	0x00A00000
#define SCU_BASE_ADDR			    	ARM_PERIPHBASE
#define IC_INTERFACES_BASE_ADDR		    (ARM_PERIPHBASE+0x0100)
#define GLOBAL_TIMER_BASE_ADDR		    (ARM_PERIPHBASE+0x0200)
#define PRIVATE_TIMERS_WD_BASE_ADDR	    (ARM_PERIPHBASE+0x0600)
#define IC_DISTRIBUTOR_BASE_ADDR		(ARM_PERIPHBASE+0x1000)

//Add from mx53 for ds90ur124.c
#define GPR_BASE_ADDR      (IOMUXC_BASE_ADDR + 0x0)
#define OBSRV_BASE_ADDR    (GPR_BASE_ADDR + 0x38)
#define SW_MUX_BASE_ADDR   (OBSRV_BASE_ADDR + 0x14)

#endif //_SOC_MEMORY_MAP_H
