/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SNVS_REGISTERS_H__
#define __HW_SNVS_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL SNVS
 *
 * SNVS
 *
 * Registers defined in this header file:
 * - HW_SNVS_HPLR - SNVS _HP Lock Register
 * - HW_SNVS_HPCOMR - SNVS _HP Command Register
 * - HW_SNVS_HPCR - SNVS_HP Control Register
 * - HW_SNVS_HPSICR - SNVS _HP Security Interrupt Control Register
 * - HW_SNVS_HPSVCR - SNVS _HP Security Violation Control Register
 * - HW_SNVS_HPSR - SNVS _HP Status Register
 * - HW_SNVS_HPSVSR - SNVS _HP Security Violation Status Register
 * - HW_SNVS_HPHACIVR - SNVS _HP High Assurance Counter IV Register
 * - HW_SNVS_HPHACR - SNVS _HP High Assurance Counter Register
 * - HW_SNVS_HPRTCMR - SNVS_HP Real Time Counter MSB Register
 * - HW_SNVS_HPRTCLR - SNVS_HP Real Time Counter LSB Register
 * - HW_SNVS_HPTAMR - SNVS_HP Time Alarm MSB Register
 * - HW_SNVS_HPTALR - SNVS_HP Time Alarm LSB Register
 * - HW_SNVS_LPLR - SNVS _LP Lock Register
 * - HW_SNVS_LPCR - SNVS_LP Control Register
 * - HW_SNVS_LPMKCR - SNVS_LP Master Key Control Register
 * - HW_SNVS_LPSVCR - SNVS_LP Security Violation Control Register
 * - HW_SNVS_LPTGFCR - SNVS_LP Tamper Glitch Filters Configuration Register
 * - HW_SNVS_LPTDCR - SNVS_LP Tamper Detectors Configuration Register
 * - HW_SNVS_LPSR - SNVS _LP Status Register
 * - HW_SNVS_LPSRTCMR - SNVS_LP Secure Real Time Counter MSB Register
 * - HW_SNVS_LPSRTCLR - SNVS_LP Secure Real Time Counter LSB Register
 * - HW_SNVS_LPTAR - SNVS_LP Time Alarm Register
 * - HW_SNVS_LPSMCMR - SNVS_LP Secure Monotonic Counter MSB Register
 * - HW_SNVS_LPSMCLR - SNVS_LP Secure Monotonic Counter LSB Register
 * - HW_SNVS_LPPGDR - SNVS _LP Power Glitch Detector Register
 * - HW_SNVS_LPGPR - SNVS_LP General Purpose Register
 * - HW_SNVS_LPZMKRn - SNVS_LP Zeroizable Master Key Register n
 * - HW_SNVS_HPVIDR1 - SNVS _HP Version ID Register 1
 * - HW_SNVS_HPVIDR2 - SNVS _HP Version ID Register 2
 *
 * - hw_snvs_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_SNVS_BASE
#define HW_SNVS_INSTANCE_COUNT (1) //!< Number of instances of the SNVS module.
#define REGS_SNVS_BASE (0x020cc000) //!< Base address for SNVS.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPLR - SNVS _HP Lock Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPLR - SNVS _HP Lock Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Lock Register contains lock bits for the SNVS registers. This is a privileged write
 * register.
 */
typedef union _hw_snvs_hplr
{
    reg32_t U;
    struct _hw_snvs_hplr_bitfields
    {
        unsigned ZMK_WSL : 1; //!< [0] Zeroizable Master Key Write Soft Lock
        unsigned ZMK_RSL : 1; //!< [1] Zeroizable Master Key Read Soft Lock
        unsigned SRTC_SL : 1; //!< [2] Secure Real Time Counter Soft Lock
        unsigned LPCALB_SL : 1; //!< [3] LP Calibration Soft Lock
        unsigned MC_SL : 1; //!< [4] Monotonic Counter Soft Lock
        unsigned GPR_SL : 1; //!< [5] General Purpose Register Soft Lock
        unsigned LPSVCR_SL : 1; //!< [6] LP Security Violation Control Register Soft Lock
        unsigned LPTGFCR_SL : 1; //!< [7] LP Tamper Glitch Filter Configuration Register Soft Lock
        unsigned LPTDCR_SL : 1; //!< [8] LP Tamper Detectors Configuration Register Soft Lock
        unsigned MKS_SL : 1; //!< [9] Master Key Select Soft Lock
        unsigned RESERVED0 : 6; //!< [15:10] Reserved
        unsigned HPSVCR_L : 1; //!< [16] HP Security Violation Control Register Lock
        unsigned HPSICR_L : 1; //!< [17] HP Security Interrupt Control Register Lock
        unsigned HAC_L : 1; //!< [18] High Assurance Configuration Lock
        unsigned RESERVED1 : 13; //!< [31:19] Reserved
    } B;
} hw_snvs_hplr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPLR register
 */
//@{
#define HW_SNVS_HPLR_ADDR      (REGS_SNVS_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPLR           (*(volatile hw_snvs_hplr_t *) HW_SNVS_HPLR_ADDR)
#define HW_SNVS_HPLR_RD()      (HW_SNVS_HPLR.U)
#define HW_SNVS_HPLR_WR(v)     (HW_SNVS_HPLR.U = (v))
#define HW_SNVS_HPLR_SET(v)    (HW_SNVS_HPLR_WR(HW_SNVS_HPLR_RD() |  (v)))
#define HW_SNVS_HPLR_CLR(v)    (HW_SNVS_HPLR_WR(HW_SNVS_HPLR_RD() & ~(v)))
#define HW_SNVS_HPLR_TOG(v)    (HW_SNVS_HPLR_WR(HW_SNVS_HPLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPLR bitfields
 */

/*! @name Register SNVS_HPLR, field ZMK_WSL[0] (RW)
 *
 * Zeroizable Master Key Write Soft Lock When set, prevents any writes (software and hardware) to
 * the ZMK registers and MASTER_KEY_SEL, ZMK_HWP, ZMK_VAL, and ZMK_ECC_EN fields of the LPMKCR. Once
 * set, this bit can only be cleared by system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_ZMK_WSL      (0)      //!< Bit position for SNVS_HPLR_ZMK_WSL.
#define BM_SNVS_HPLR_ZMK_WSL      (0x00000001)  //!< Bit mask for SNVS_HPLR_ZMK_WSL.

//! @brief Get value of SNVS_HPLR_ZMK_WSL from a register value.
#define BG_SNVS_HPLR_ZMK_WSL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_ZMK_WSL) >> BP_SNVS_HPLR_ZMK_WSL)

//! @brief Format value for bitfield SNVS_HPLR_ZMK_WSL.
#define BF_SNVS_HPLR_ZMK_WSL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_ZMK_WSL) & BM_SNVS_HPLR_ZMK_WSL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_WSL field to a new value.
#define BW_SNVS_HPLR_ZMK_WSL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_ZMK_WSL) | BF_SNVS_HPLR_ZMK_WSL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field ZMK_RSL[1] (RW)
 *
 * Zeroizable Master Key Read Soft Lock When set, prevents any software reads to the ZMK Registers
 * and ZMK_ECC_VALUE field of the LPMKCR. In ZMK hardware programming mode (ZMK_HWP is set), the ZMK
 * and ZMK_ECC_VALUE cannot be read by software. Regardless of the bit setting, hardware can use the
 * ZMK value when ZMK is selected. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Read access is allowed (only in software Programming mode)
 * - 1 - Read access is not allowed
 */
//@{
#define BP_SNVS_HPLR_ZMK_RSL      (1)      //!< Bit position for SNVS_HPLR_ZMK_RSL.
#define BM_SNVS_HPLR_ZMK_RSL      (0x00000002)  //!< Bit mask for SNVS_HPLR_ZMK_RSL.

//! @brief Get value of SNVS_HPLR_ZMK_RSL from a register value.
#define BG_SNVS_HPLR_ZMK_RSL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_ZMK_RSL) >> BP_SNVS_HPLR_ZMK_RSL)

//! @brief Format value for bitfield SNVS_HPLR_ZMK_RSL.
#define BF_SNVS_HPLR_ZMK_RSL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_ZMK_RSL) & BM_SNVS_HPLR_ZMK_RSL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_RSL field to a new value.
#define BW_SNVS_HPLR_ZMK_RSL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_ZMK_RSL) | BF_SNVS_HPLR_ZMK_RSL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field SRTC_SL[2] (RW)
 *
 * Secure Real Time Counter Soft Lock When set, prevents any writes to the SRTC Registers, SRTC_ENV,
 * and SRTC_INV_EN bits. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_SRTC_SL      (2)      //!< Bit position for SNVS_HPLR_SRTC_SL.
#define BM_SNVS_HPLR_SRTC_SL      (0x00000004)  //!< Bit mask for SNVS_HPLR_SRTC_SL.

//! @brief Get value of SNVS_HPLR_SRTC_SL from a register value.
#define BG_SNVS_HPLR_SRTC_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_SRTC_SL) >> BP_SNVS_HPLR_SRTC_SL)

//! @brief Format value for bitfield SNVS_HPLR_SRTC_SL.
#define BF_SNVS_HPLR_SRTC_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_SRTC_SL) & BM_SNVS_HPLR_SRTC_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC_SL field to a new value.
#define BW_SNVS_HPLR_SRTC_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_SRTC_SL) | BF_SNVS_HPLR_SRTC_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field LPCALB_SL[3] (RW)
 *
 * LP Calibration Soft Lock When set, prevents any writes to the LP Calibration Value (LPCALB_VAL)
 * and LP Calibration Enable (LPCALB_EN). Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_LPCALB_SL      (3)      //!< Bit position for SNVS_HPLR_LPCALB_SL.
#define BM_SNVS_HPLR_LPCALB_SL      (0x00000008)  //!< Bit mask for SNVS_HPLR_LPCALB_SL.

//! @brief Get value of SNVS_HPLR_LPCALB_SL from a register value.
#define BG_SNVS_HPLR_LPCALB_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_LPCALB_SL) >> BP_SNVS_HPLR_LPCALB_SL)

//! @brief Format value for bitfield SNVS_HPLR_LPCALB_SL.
#define BF_SNVS_HPLR_LPCALB_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_LPCALB_SL) & BM_SNVS_HPLR_LPCALB_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPCALB_SL field to a new value.
#define BW_SNVS_HPLR_LPCALB_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_LPCALB_SL) | BF_SNVS_HPLR_LPCALB_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field MC_SL[4] (RW)
 *
 * Monotonic Counter Soft Lock When set, prevents any writes (increments) to the MC Registers and
 * MC_ENV bit. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access (increment) is allowed
 * - 1 - Write access (increment) is not allowed
 */
//@{
#define BP_SNVS_HPLR_MC_SL      (4)      //!< Bit position for SNVS_HPLR_MC_SL.
#define BM_SNVS_HPLR_MC_SL      (0x00000010)  //!< Bit mask for SNVS_HPLR_MC_SL.

//! @brief Get value of SNVS_HPLR_MC_SL from a register value.
#define BG_SNVS_HPLR_MC_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_MC_SL) >> BP_SNVS_HPLR_MC_SL)

//! @brief Format value for bitfield SNVS_HPLR_MC_SL.
#define BF_SNVS_HPLR_MC_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_MC_SL) & BM_SNVS_HPLR_MC_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MC_SL field to a new value.
#define BW_SNVS_HPLR_MC_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_MC_SL) | BF_SNVS_HPLR_MC_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field GPR_SL[5] (RW)
 *
 * General Purpose Register Soft Lock When set, prevents any writes to the GPR. Once set, this bit
 * can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_GPR_SL      (5)      //!< Bit position for SNVS_HPLR_GPR_SL.
#define BM_SNVS_HPLR_GPR_SL      (0x00000020)  //!< Bit mask for SNVS_HPLR_GPR_SL.

//! @brief Get value of SNVS_HPLR_GPR_SL from a register value.
#define BG_SNVS_HPLR_GPR_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_GPR_SL) >> BP_SNVS_HPLR_GPR_SL)

//! @brief Format value for bitfield SNVS_HPLR_GPR_SL.
#define BF_SNVS_HPLR_GPR_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_GPR_SL) & BM_SNVS_HPLR_GPR_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GPR_SL field to a new value.
#define BW_SNVS_HPLR_GPR_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_GPR_SL) | BF_SNVS_HPLR_GPR_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field LPSVCR_SL[6] (RW)
 *
 * LP Security Violation Control Register Soft Lock When set, prevents any writes to the LPSVCR.
 * Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_LPSVCR_SL      (6)      //!< Bit position for SNVS_HPLR_LPSVCR_SL.
#define BM_SNVS_HPLR_LPSVCR_SL      (0x00000040)  //!< Bit mask for SNVS_HPLR_LPSVCR_SL.

//! @brief Get value of SNVS_HPLR_LPSVCR_SL from a register value.
#define BG_SNVS_HPLR_LPSVCR_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_LPSVCR_SL) >> BP_SNVS_HPLR_LPSVCR_SL)

//! @brief Format value for bitfield SNVS_HPLR_LPSVCR_SL.
#define BF_SNVS_HPLR_LPSVCR_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_LPSVCR_SL) & BM_SNVS_HPLR_LPSVCR_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPSVCR_SL field to a new value.
#define BW_SNVS_HPLR_LPSVCR_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_LPSVCR_SL) | BF_SNVS_HPLR_LPSVCR_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field LPTGFCR_SL[7] (RW)
 *
 * LP Tamper Glitch Filter Configuration Register Soft Lock When set, prevents any writes to the
 * LPTGFCR. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_LPTGFCR_SL      (7)      //!< Bit position for SNVS_HPLR_LPTGFCR_SL.
#define BM_SNVS_HPLR_LPTGFCR_SL      (0x00000080)  //!< Bit mask for SNVS_HPLR_LPTGFCR_SL.

//! @brief Get value of SNVS_HPLR_LPTGFCR_SL from a register value.
#define BG_SNVS_HPLR_LPTGFCR_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_LPTGFCR_SL) >> BP_SNVS_HPLR_LPTGFCR_SL)

//! @brief Format value for bitfield SNVS_HPLR_LPTGFCR_SL.
#define BF_SNVS_HPLR_LPTGFCR_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_LPTGFCR_SL) & BM_SNVS_HPLR_LPTGFCR_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTGFCR_SL field to a new value.
#define BW_SNVS_HPLR_LPTGFCR_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_LPTGFCR_SL) | BF_SNVS_HPLR_LPTGFCR_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field LPTDCR_SL[8] (RW)
 *
 * LP Tamper Detectors Configuration Register Soft Lock When set, prevents any writes to the LPTDCR.
 * Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_LPTDCR_SL      (8)      //!< Bit position for SNVS_HPLR_LPTDCR_SL.
#define BM_SNVS_HPLR_LPTDCR_SL      (0x00000100)  //!< Bit mask for SNVS_HPLR_LPTDCR_SL.

//! @brief Get value of SNVS_HPLR_LPTDCR_SL from a register value.
#define BG_SNVS_HPLR_LPTDCR_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_LPTDCR_SL) >> BP_SNVS_HPLR_LPTDCR_SL)

//! @brief Format value for bitfield SNVS_HPLR_LPTDCR_SL.
#define BF_SNVS_HPLR_LPTDCR_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_LPTDCR_SL) & BM_SNVS_HPLR_LPTDCR_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTDCR_SL field to a new value.
#define BW_SNVS_HPLR_LPTDCR_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_LPTDCR_SL) | BF_SNVS_HPLR_LPTDCR_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field MKS_SL[9] (RW)
 *
 * Master Key Select Soft Lock When set, prevents any writes to the MASTER_KEY_SEL field of the
 * LPMKCR. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_MKS_SL      (9)      //!< Bit position for SNVS_HPLR_MKS_SL.
#define BM_SNVS_HPLR_MKS_SL      (0x00000200)  //!< Bit mask for SNVS_HPLR_MKS_SL.

//! @brief Get value of SNVS_HPLR_MKS_SL from a register value.
#define BG_SNVS_HPLR_MKS_SL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_MKS_SL) >> BP_SNVS_HPLR_MKS_SL)

//! @brief Format value for bitfield SNVS_HPLR_MKS_SL.
#define BF_SNVS_HPLR_MKS_SL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_MKS_SL) & BM_SNVS_HPLR_MKS_SL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MKS_SL field to a new value.
#define BW_SNVS_HPLR_MKS_SL(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_MKS_SL) | BF_SNVS_HPLR_MKS_SL(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field HPSVCR_L[16] (RW)
 *
 * HP Security Violation Control Register Lock When set, prevents any writes to the HPSVCR. Once
 * set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_HPSVCR_L      (16)      //!< Bit position for SNVS_HPLR_HPSVCR_L.
#define BM_SNVS_HPLR_HPSVCR_L      (0x00010000)  //!< Bit mask for SNVS_HPLR_HPSVCR_L.

//! @brief Get value of SNVS_HPLR_HPSVCR_L from a register value.
#define BG_SNVS_HPLR_HPSVCR_L(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_HPSVCR_L) >> BP_SNVS_HPLR_HPSVCR_L)

//! @brief Format value for bitfield SNVS_HPLR_HPSVCR_L.
#define BF_SNVS_HPLR_HPSVCR_L(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_HPSVCR_L) & BM_SNVS_HPLR_HPSVCR_L)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPSVCR_L field to a new value.
#define BW_SNVS_HPLR_HPSVCR_L(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_HPSVCR_L) | BF_SNVS_HPLR_HPSVCR_L(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field HPSICR_L[17] (RW)
 *
 * HP Security Interrupt Control Register Lock When set, prevents any writes to the HPSICR. Once
 * set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_HPSICR_L      (17)      //!< Bit position for SNVS_HPLR_HPSICR_L.
#define BM_SNVS_HPLR_HPSICR_L      (0x00020000)  //!< Bit mask for SNVS_HPLR_HPSICR_L.

//! @brief Get value of SNVS_HPLR_HPSICR_L from a register value.
#define BG_SNVS_HPLR_HPSICR_L(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_HPSICR_L) >> BP_SNVS_HPLR_HPSICR_L)

//! @brief Format value for bitfield SNVS_HPLR_HPSICR_L.
#define BF_SNVS_HPLR_HPSICR_L(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_HPSICR_L) & BM_SNVS_HPLR_HPSICR_L)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPSICR_L field to a new value.
#define BW_SNVS_HPLR_HPSICR_L(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_HPSICR_L) | BF_SNVS_HPLR_HPSICR_L(v)))
#endif
//@}

/*! @name Register SNVS_HPLR, field HAC_L[18] (RW)
 *
 * High Assurance Configuration Lock When set, prevents any writes to HPHACIVR, HPHACR, and HAC_EN
 * bit of HPCOMR. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - Write access is allowed
 * - 1 - Write access is not allowed
 */
//@{
#define BP_SNVS_HPLR_HAC_L      (18)      //!< Bit position for SNVS_HPLR_HAC_L.
#define BM_SNVS_HPLR_HAC_L      (0x00040000)  //!< Bit mask for SNVS_HPLR_HAC_L.

//! @brief Get value of SNVS_HPLR_HAC_L from a register value.
#define BG_SNVS_HPLR_HAC_L(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPLR_HAC_L) >> BP_SNVS_HPLR_HAC_L)

//! @brief Format value for bitfield SNVS_HPLR_HAC_L.
#define BF_SNVS_HPLR_HAC_L(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPLR_HAC_L) & BM_SNVS_HPLR_HAC_L)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAC_L field to a new value.
#define BW_SNVS_HPLR_HAC_L(v)   (HW_SNVS_HPLR_WR((HW_SNVS_HPLR_RD() & ~BM_SNVS_HPLR_HAC_L) | BF_SNVS_HPLR_HAC_L(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPCOMR - SNVS _HP Command Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPCOMR - SNVS _HP Command Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Command Register contains the command, configuration, and control bits for the SNVS
 * block. Some fields of this register can be written to in check and soft fail states in addition
 * to the standard write access in functional states. This is a privileged write register.
 */
typedef union _hw_snvs_hpcomr
{
    reg32_t U;
    struct _hw_snvs_hpcomr_bitfields
    {
        unsigned SSM_ST : 1; //!< [0] SSM State Transition
        unsigned SSM_ST_DIS : 1; //!< [1] SSM Secure to Trusted State Transition Disable
        unsigned SSM_SFNS_DIS : 1; //!< [2] SSM Soft Fail to Non-Secure State Transition Disable
        unsigned RESERVED0 : 1; //!< [3] Reserved
        unsigned LP_SWR : 1; //!< [4] LP Software Reset
        unsigned LP_SWR_DIS : 1; //!< [5] LP Software Reset Disable
        unsigned RESERVED1 : 2; //!< [7:6] Reserved
        unsigned SW_SV : 1; //!< [8] Software Security Violation
        unsigned SW_FSV : 1; //!< [9] Software Fatal Security Violation
        unsigned SW_LPSV : 1; //!< [10] LP Software Security Violation
        unsigned RESERVED2 : 1; //!< [11] Reserved
        unsigned PROG_ZMK : 1; //!< [12] Program Zeroizable Master Key
        unsigned MKS_EN : 1; //!< [13] Master Key Select Enable
        unsigned RESERVED3 : 2; //!< [15:14] Reserved
        unsigned HAC_EN : 1; //!< [16] High Assurance Configuration Enable
        unsigned HAC_LOAD : 1; //!< [17] High Assurance Counter Load
        unsigned HAC_CLEAR : 1; //!< [18] High Assurance Counter Clear
        unsigned HAC_STOP : 1; //!< [19] High Assurance Counter Stop
        unsigned RESERVED4 : 11; //!< [30:20] Reserved
        unsigned NPSWA_EN : 1; //!< [31] Non-Privileged Software Access Enable
    } B;
} hw_snvs_hpcomr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPCOMR register
 */
//@{
#define HW_SNVS_HPCOMR_ADDR      (REGS_SNVS_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPCOMR           (*(volatile hw_snvs_hpcomr_t *) HW_SNVS_HPCOMR_ADDR)
#define HW_SNVS_HPCOMR_RD()      (HW_SNVS_HPCOMR.U)
#define HW_SNVS_HPCOMR_WR(v)     (HW_SNVS_HPCOMR.U = (v))
#define HW_SNVS_HPCOMR_SET(v)    (HW_SNVS_HPCOMR_WR(HW_SNVS_HPCOMR_RD() |  (v)))
#define HW_SNVS_HPCOMR_CLR(v)    (HW_SNVS_HPCOMR_WR(HW_SNVS_HPCOMR_RD() & ~(v)))
#define HW_SNVS_HPCOMR_TOG(v)    (HW_SNVS_HPCOMR_WR(HW_SNVS_HPCOMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPCOMR bitfields
 */

/*! @name Register SNVS_HPCOMR, field SSM_ST[0] (WO)
 *
 * SSM State Transition Transition state of the system security monitor. This self-clearing bit is
 * always read as zero. This command results only in the following transitions of the SSM: Check
 * State → Non-Secure (when Non-Secure Boot and not in Fab Configuration ) Check State → Trusted
 * (when Secure Boot or in Fab Configuration ) Trusted State → Secure Secure State → Trusted (if not
 * disabled by SSM_ST_DIS bit) Soft Fail → Non-Secure (if not disabled by SSM_SFNS_DIS bit)
 */
//@{
#define BP_SNVS_HPCOMR_SSM_ST      (0)      //!< Bit position for SNVS_HPCOMR_SSM_ST.
#define BM_SNVS_HPCOMR_SSM_ST      (0x00000001)  //!< Bit mask for SNVS_HPCOMR_SSM_ST.

//! @brief Get value of SNVS_HPCOMR_SSM_ST from a register value.
#define BG_SNVS_HPCOMR_SSM_ST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SSM_ST) >> BP_SNVS_HPCOMR_SSM_ST)

//! @brief Format value for bitfield SNVS_HPCOMR_SSM_ST.
#define BF_SNVS_HPCOMR_SSM_ST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SSM_ST) & BM_SNVS_HPCOMR_SSM_ST)
//@}

/*! @name Register SNVS_HPCOMR, field SSM_ST_DIS[1] (RW)
 *
 * SSM Secure to Trusted State Transition Disable When set, disables the SSM transition from secure
 * to trusted state. Once set after the reset, this bit cannot be changed.
 *
 * Values:
 * - 0 - Secure to Trusted State transition is enabled
 * - 1 - Secure to Trusted State transition is disabled
 */
//@{
#define BP_SNVS_HPCOMR_SSM_ST_DIS      (1)      //!< Bit position for SNVS_HPCOMR_SSM_ST_DIS.
#define BM_SNVS_HPCOMR_SSM_ST_DIS      (0x00000002)  //!< Bit mask for SNVS_HPCOMR_SSM_ST_DIS.

//! @brief Get value of SNVS_HPCOMR_SSM_ST_DIS from a register value.
#define BG_SNVS_HPCOMR_SSM_ST_DIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SSM_ST_DIS) >> BP_SNVS_HPCOMR_SSM_ST_DIS)

//! @brief Format value for bitfield SNVS_HPCOMR_SSM_ST_DIS.
#define BF_SNVS_HPCOMR_SSM_ST_DIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SSM_ST_DIS) & BM_SNVS_HPCOMR_SSM_ST_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSM_ST_DIS field to a new value.
#define BW_SNVS_HPCOMR_SSM_ST_DIS(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_SSM_ST_DIS) | BF_SNVS_HPCOMR_SSM_ST_DIS(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field SSM_SFNS_DIS[2] (RW)
 *
 * SSM Soft Fail to Non-Secure State Transition Disable When set, it disables the SSM transition
 * from soft fail to non-secure state. Once set after the reset this bit cannot be changed
 *
 * Values:
 * - 0 - Soft Fail to Non-Secure State transition is enabled
 * - 1 - Soft Fail to Non-Secure State transition is disabled
 */
//@{
#define BP_SNVS_HPCOMR_SSM_SFNS_DIS      (2)      //!< Bit position for SNVS_HPCOMR_SSM_SFNS_DIS.
#define BM_SNVS_HPCOMR_SSM_SFNS_DIS      (0x00000004)  //!< Bit mask for SNVS_HPCOMR_SSM_SFNS_DIS.

//! @brief Get value of SNVS_HPCOMR_SSM_SFNS_DIS from a register value.
#define BG_SNVS_HPCOMR_SSM_SFNS_DIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SSM_SFNS_DIS) >> BP_SNVS_HPCOMR_SSM_SFNS_DIS)

//! @brief Format value for bitfield SNVS_HPCOMR_SSM_SFNS_DIS.
#define BF_SNVS_HPCOMR_SSM_SFNS_DIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SSM_SFNS_DIS) & BM_SNVS_HPCOMR_SSM_SFNS_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSM_SFNS_DIS field to a new value.
#define BW_SNVS_HPCOMR_SSM_SFNS_DIS(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_SSM_SFNS_DIS) | BF_SNVS_HPCOMR_SSM_SFNS_DIS(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field LP_SWR[4] (WO)
 *
 * LP Software Reset When set, it resets the SNVS _LP section. This bit cannot be set when the
 * LP_SWR_DIS bit is set. This self-clearing bit is always read as zero.
 *
 * Values:
 * - 0 - No Action
 * - 1 - Reset LP section
 */
//@{
#define BP_SNVS_HPCOMR_LP_SWR      (4)      //!< Bit position for SNVS_HPCOMR_LP_SWR.
#define BM_SNVS_HPCOMR_LP_SWR      (0x00000010)  //!< Bit mask for SNVS_HPCOMR_LP_SWR.

//! @brief Get value of SNVS_HPCOMR_LP_SWR from a register value.
#define BG_SNVS_HPCOMR_LP_SWR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_LP_SWR) >> BP_SNVS_HPCOMR_LP_SWR)

//! @brief Format value for bitfield SNVS_HPCOMR_LP_SWR.
#define BF_SNVS_HPCOMR_LP_SWR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_LP_SWR) & BM_SNVS_HPCOMR_LP_SWR)
//@}

/*! @name Register SNVS_HPCOMR, field LP_SWR_DIS[5] (RW)
 *
 * LP Software Reset Disable When set, disables the LP software reset. Once set, this bit can only
 * be reset by the system reset.
 *
 * Values:
 * - 0 - LP software reset is enabled
 * - 1 - LP software reset is disabled
 */
//@{
#define BP_SNVS_HPCOMR_LP_SWR_DIS      (5)      //!< Bit position for SNVS_HPCOMR_LP_SWR_DIS.
#define BM_SNVS_HPCOMR_LP_SWR_DIS      (0x00000020)  //!< Bit mask for SNVS_HPCOMR_LP_SWR_DIS.

//! @brief Get value of SNVS_HPCOMR_LP_SWR_DIS from a register value.
#define BG_SNVS_HPCOMR_LP_SWR_DIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_LP_SWR_DIS) >> BP_SNVS_HPCOMR_LP_SWR_DIS)

//! @brief Format value for bitfield SNVS_HPCOMR_LP_SWR_DIS.
#define BF_SNVS_HPCOMR_LP_SWR_DIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_LP_SWR_DIS) & BM_SNVS_HPCOMR_LP_SWR_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LP_SWR_DIS field to a new value.
#define BW_SNVS_HPCOMR_LP_SWR_DIS(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_LP_SWR_DIS) | BF_SNVS_HPCOMR_LP_SWR_DIS(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field SW_SV[8] (RW)
 *
 * Software Security Violation When set, the system security monitor treats this bit as a non-fatal
 * security violation. This security violation has no effect on the LP section. This command results
 * only in the following transitions of the SSM: Check → Non-Secure Trusted → Soft Fail Secure →
 * Soft Fail
 */
//@{
#define BP_SNVS_HPCOMR_SW_SV      (8)      //!< Bit position for SNVS_HPCOMR_SW_SV.
#define BM_SNVS_HPCOMR_SW_SV      (0x00000100)  //!< Bit mask for SNVS_HPCOMR_SW_SV.

//! @brief Get value of SNVS_HPCOMR_SW_SV from a register value.
#define BG_SNVS_HPCOMR_SW_SV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SW_SV) >> BP_SNVS_HPCOMR_SW_SV)

//! @brief Format value for bitfield SNVS_HPCOMR_SW_SV.
#define BF_SNVS_HPCOMR_SW_SV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SW_SV) & BM_SNVS_HPCOMR_SW_SV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SW_SV field to a new value.
#define BW_SNVS_HPCOMR_SW_SV(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_SW_SV) | BF_SNVS_HPCOMR_SW_SV(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field SW_FSV[9] (RW)
 *
 * Software Fatal Security Violation When set, the system security monitor treats this bit as a
 * fatal security violation. This security violation has no effect on the LP section. This command
 * results only in the following transitions of the SSM: Check State → Soft Fail Non-Secure State →
 * Soft Fail Trusted State → Soft Fail Secure State → Soft Fail
 */
//@{
#define BP_SNVS_HPCOMR_SW_FSV      (9)      //!< Bit position for SNVS_HPCOMR_SW_FSV.
#define BM_SNVS_HPCOMR_SW_FSV      (0x00000200)  //!< Bit mask for SNVS_HPCOMR_SW_FSV.

//! @brief Get value of SNVS_HPCOMR_SW_FSV from a register value.
#define BG_SNVS_HPCOMR_SW_FSV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SW_FSV) >> BP_SNVS_HPCOMR_SW_FSV)

//! @brief Format value for bitfield SNVS_HPCOMR_SW_FSV.
#define BF_SNVS_HPCOMR_SW_FSV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SW_FSV) & BM_SNVS_HPCOMR_SW_FSV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SW_FSV field to a new value.
#define BW_SNVS_HPCOMR_SW_FSV(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_SW_FSV) | BF_SNVS_HPCOMR_SW_FSV(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field SW_LPSV[10] (RW)
 *
 * LP Software Security Violation When set, SNVS _LP treats this bit as a security violation. The LP
 * secure data is zeroized or invalidated according to the configuration. This security violation
 * may result in a system security monitor transition if the LP Security Violation is enabled in the
 * SNVS _HP Security Violation Control Register.
 */
//@{
#define BP_SNVS_HPCOMR_SW_LPSV      (10)      //!< Bit position for SNVS_HPCOMR_SW_LPSV.
#define BM_SNVS_HPCOMR_SW_LPSV      (0x00000400)  //!< Bit mask for SNVS_HPCOMR_SW_LPSV.

//! @brief Get value of SNVS_HPCOMR_SW_LPSV from a register value.
#define BG_SNVS_HPCOMR_SW_LPSV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_SW_LPSV) >> BP_SNVS_HPCOMR_SW_LPSV)

//! @brief Format value for bitfield SNVS_HPCOMR_SW_LPSV.
#define BF_SNVS_HPCOMR_SW_LPSV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_SW_LPSV) & BM_SNVS_HPCOMR_SW_LPSV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SW_LPSV field to a new value.
#define BW_SNVS_HPCOMR_SW_LPSV(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_SW_LPSV) | BF_SNVS_HPCOMR_SW_LPSV(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field PROG_ZMK[12] (WO)
 *
 * Program Zeroizable Master Key This bit activates ZMK hardware programming mechanism. This
 * mechanism is activated only if the ZMK is configured to the hardware programming mode and ZMK in
 * not locked for writes. This self-clearing bit is always read as zero.
 *
 * Values:
 * - 0 - No Action
 * - 1 - Activate hardware key programming mechanism
 */
//@{
#define BP_SNVS_HPCOMR_PROG_ZMK      (12)      //!< Bit position for SNVS_HPCOMR_PROG_ZMK.
#define BM_SNVS_HPCOMR_PROG_ZMK      (0x00001000)  //!< Bit mask for SNVS_HPCOMR_PROG_ZMK.

//! @brief Get value of SNVS_HPCOMR_PROG_ZMK from a register value.
#define BG_SNVS_HPCOMR_PROG_ZMK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_PROG_ZMK) >> BP_SNVS_HPCOMR_PROG_ZMK)

//! @brief Format value for bitfield SNVS_HPCOMR_PROG_ZMK.
#define BF_SNVS_HPCOMR_PROG_ZMK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_PROG_ZMK) & BM_SNVS_HPCOMR_PROG_ZMK)
//@}

/*! @name Register SNVS_HPCOMR, field MKS_EN[13] (RW)
 *
 * Master Key Select Enable When not set, the one time programmable (OTP) master key is selected by
 * default. When set, the master key is selected according to the setting of the master key select
 * field (MASTER_KEY_SEL) of LPMKCR. Once set, this bit can only be reset by the system reset.
 *
 * Values:
 * - 0 - OTP master key is selected as an SNVS master key
 * - 1 - SNVS master key is selected according to the setting of the MASTER_KEY_SEL field of LPMKCR
 */
//@{
#define BP_SNVS_HPCOMR_MKS_EN      (13)      //!< Bit position for SNVS_HPCOMR_MKS_EN.
#define BM_SNVS_HPCOMR_MKS_EN      (0x00002000)  //!< Bit mask for SNVS_HPCOMR_MKS_EN.

//! @brief Get value of SNVS_HPCOMR_MKS_EN from a register value.
#define BG_SNVS_HPCOMR_MKS_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_MKS_EN) >> BP_SNVS_HPCOMR_MKS_EN)

//! @brief Format value for bitfield SNVS_HPCOMR_MKS_EN.
#define BF_SNVS_HPCOMR_MKS_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_MKS_EN) & BM_SNVS_HPCOMR_MKS_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MKS_EN field to a new value.
#define BW_SNVS_HPCOMR_MKS_EN(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_MKS_EN) | BF_SNVS_HPCOMR_MKS_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field HAC_EN[16] (RW)
 *
 * High Assurance Configuration Enable This bit controls the SSM transition from the soft fail to
 * the hard fail state. When this bit is set and software fails to stop the HAC before it expires,
 * the SSM transitions to the hard fail state. This bit cannot be changed once HAC_L bit is set.
 *
 * Values:
 * - 0 - High Assurance Configuration is disabled
 * - 1 - High Assurance Configuration is enabled
 */
//@{
#define BP_SNVS_HPCOMR_HAC_EN      (16)      //!< Bit position for SNVS_HPCOMR_HAC_EN.
#define BM_SNVS_HPCOMR_HAC_EN      (0x00010000)  //!< Bit mask for SNVS_HPCOMR_HAC_EN.

//! @brief Get value of SNVS_HPCOMR_HAC_EN from a register value.
#define BG_SNVS_HPCOMR_HAC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_HAC_EN) >> BP_SNVS_HPCOMR_HAC_EN)

//! @brief Format value for bitfield SNVS_HPCOMR_HAC_EN.
#define BF_SNVS_HPCOMR_HAC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_HAC_EN) & BM_SNVS_HPCOMR_HAC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAC_EN field to a new value.
#define BW_SNVS_HPCOMR_HAC_EN(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_HAC_EN) | BF_SNVS_HPCOMR_HAC_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field HAC_LOAD[17] (WO)
 *
 * High Assurance Counter Load When set, it loads the High Assurance Counter Register with the value
 * of the High Assurance Counter Load Register. It can be done in a functional or soft fail state.
 * This self-clearing bit is always read as zero.
 *
 * Values:
 * - 0 - No Action
 * - 1 - Load the HAC
 */
//@{
#define BP_SNVS_HPCOMR_HAC_LOAD      (17)      //!< Bit position for SNVS_HPCOMR_HAC_LOAD.
#define BM_SNVS_HPCOMR_HAC_LOAD      (0x00020000)  //!< Bit mask for SNVS_HPCOMR_HAC_LOAD.

//! @brief Get value of SNVS_HPCOMR_HAC_LOAD from a register value.
#define BG_SNVS_HPCOMR_HAC_LOAD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_HAC_LOAD) >> BP_SNVS_HPCOMR_HAC_LOAD)

//! @brief Format value for bitfield SNVS_HPCOMR_HAC_LOAD.
#define BF_SNVS_HPCOMR_HAC_LOAD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_HAC_LOAD) & BM_SNVS_HPCOMR_HAC_LOAD)
//@}

/*! @name Register SNVS_HPCOMR, field HAC_CLEAR[18] (WO)
 *
 * High Assurance Counter Clear When set, it clears the High Assurance Counter Register. It can be
 * cleared in a functional or soft fail state. If the HAC counter is cleared in the soft fail state,
 * the SSM transitions to the hard fail state if high assurance configuration is enabled (HAC_EN is
 * set). This self-clearing bit is always read as zero.
 *
 * Values:
 * - 0 - No Action
 * - 1 - Clear the HAC
 */
//@{
#define BP_SNVS_HPCOMR_HAC_CLEAR      (18)      //!< Bit position for SNVS_HPCOMR_HAC_CLEAR.
#define BM_SNVS_HPCOMR_HAC_CLEAR      (0x00040000)  //!< Bit mask for SNVS_HPCOMR_HAC_CLEAR.

//! @brief Get value of SNVS_HPCOMR_HAC_CLEAR from a register value.
#define BG_SNVS_HPCOMR_HAC_CLEAR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_HAC_CLEAR) >> BP_SNVS_HPCOMR_HAC_CLEAR)

//! @brief Format value for bitfield SNVS_HPCOMR_HAC_CLEAR.
#define BF_SNVS_HPCOMR_HAC_CLEAR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_HAC_CLEAR) & BM_SNVS_HPCOMR_HAC_CLEAR)
//@}

/*! @name Register SNVS_HPCOMR, field HAC_STOP[19] (RW)
 *
 * High Assurance Counter Stop This bit can be set only when SSM is in soft fail state. When set, it
 * stops the high assurance counter and prevents transition to the hard fail state. This bit can be
 * cleared in a functional or soft fail state. If the bit is cleared in the soft fail state, the
 * high assurance counter counts down from the place where it was stopped. 0 HAC counter can count
 * down 1 HAC counter is stopped
 */
//@{
#define BP_SNVS_HPCOMR_HAC_STOP      (19)      //!< Bit position for SNVS_HPCOMR_HAC_STOP.
#define BM_SNVS_HPCOMR_HAC_STOP      (0x00080000)  //!< Bit mask for SNVS_HPCOMR_HAC_STOP.

//! @brief Get value of SNVS_HPCOMR_HAC_STOP from a register value.
#define BG_SNVS_HPCOMR_HAC_STOP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_HAC_STOP) >> BP_SNVS_HPCOMR_HAC_STOP)

//! @brief Format value for bitfield SNVS_HPCOMR_HAC_STOP.
#define BF_SNVS_HPCOMR_HAC_STOP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_HAC_STOP) & BM_SNVS_HPCOMR_HAC_STOP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAC_STOP field to a new value.
#define BW_SNVS_HPCOMR_HAC_STOP(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_HAC_STOP) | BF_SNVS_HPCOMR_HAC_STOP(v)))
#endif
//@}

/*! @name Register SNVS_HPCOMR, field NPSWA_EN[31] (RW)
 *
 * Non-Privileged Software Access Enable When set, allows non-privileged software to access all SNVS
 * registers, including those that are privileged software read/write access only. 0 Only privileged
 * software can access privileged registers 1 Any software can access privileged registers
 */
//@{
#define BP_SNVS_HPCOMR_NPSWA_EN      (31)      //!< Bit position for SNVS_HPCOMR_NPSWA_EN.
#define BM_SNVS_HPCOMR_NPSWA_EN      (0x80000000)  //!< Bit mask for SNVS_HPCOMR_NPSWA_EN.

//! @brief Get value of SNVS_HPCOMR_NPSWA_EN from a register value.
#define BG_SNVS_HPCOMR_NPSWA_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCOMR_NPSWA_EN) >> BP_SNVS_HPCOMR_NPSWA_EN)

//! @brief Format value for bitfield SNVS_HPCOMR_NPSWA_EN.
#define BF_SNVS_HPCOMR_NPSWA_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCOMR_NPSWA_EN) & BM_SNVS_HPCOMR_NPSWA_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NPSWA_EN field to a new value.
#define BW_SNVS_HPCOMR_NPSWA_EN(v)   (HW_SNVS_HPCOMR_WR((HW_SNVS_HPCOMR_RD() & ~BM_SNVS_HPCOMR_NPSWA_EN) | BF_SNVS_HPCOMR_NPSWA_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPCR - SNVS_HP Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPCR - SNVS_HP Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Control Register contains various control bits of the HP section of SNVS .
 */
typedef union _hw_snvs_hpcr
{
    reg32_t U;
    struct _hw_snvs_hpcr_bitfields
    {
        unsigned RTC_EN : 1; //!< [0] HP Real Time Counter Enable
        unsigned HPTA_EN : 1; //!< [1] HP Time Alarm Enable
        unsigned RESERVED0 : 1; //!< [2] Reserved
        unsigned PI_EN : 1; //!< [3] HP Periodic Interrupt Enable
        unsigned PI_FREQ : 4; //!< [7:4] Periodic Interrupt Frequency
        unsigned HPCALB_EN : 1; //!< [8] HP Real Time Counter Calibration Enabled
        unsigned RESERVED1 : 1; //!< [9] Reserved
        unsigned HPCALB_VAL : 5; //!< [14:10] HP Calibration Value
        unsigned RESERVED2 : 1; //!< [15] Reserved
        unsigned HP_TS : 1; //!< [16] HP Time Synchronize
        unsigned RESERVED3 : 15; //!< [31:17] Reserved
    } B;
} hw_snvs_hpcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPCR register
 */
//@{
#define HW_SNVS_HPCR_ADDR      (REGS_SNVS_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPCR           (*(volatile hw_snvs_hpcr_t *) HW_SNVS_HPCR_ADDR)
#define HW_SNVS_HPCR_RD()      (HW_SNVS_HPCR.U)
#define HW_SNVS_HPCR_WR(v)     (HW_SNVS_HPCR.U = (v))
#define HW_SNVS_HPCR_SET(v)    (HW_SNVS_HPCR_WR(HW_SNVS_HPCR_RD() |  (v)))
#define HW_SNVS_HPCR_CLR(v)    (HW_SNVS_HPCR_WR(HW_SNVS_HPCR_RD() & ~(v)))
#define HW_SNVS_HPCR_TOG(v)    (HW_SNVS_HPCR_WR(HW_SNVS_HPCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPCR bitfields
 */

/*! @name Register SNVS_HPCR, field RTC_EN[0] (RW)
 *
 * HP Real Time Counter Enable
 *
 * Values:
 * - 0 - RTC is disabled
 * - 1 - RTC is enabled
 */
//@{
#define BP_SNVS_HPCR_RTC_EN      (0)      //!< Bit position for SNVS_HPCR_RTC_EN.
#define BM_SNVS_HPCR_RTC_EN      (0x00000001)  //!< Bit mask for SNVS_HPCR_RTC_EN.

//! @brief Get value of SNVS_HPCR_RTC_EN from a register value.
#define BG_SNVS_HPCR_RTC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_RTC_EN) >> BP_SNVS_HPCR_RTC_EN)

//! @brief Format value for bitfield SNVS_HPCR_RTC_EN.
#define BF_SNVS_HPCR_RTC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_RTC_EN) & BM_SNVS_HPCR_RTC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTC_EN field to a new value.
#define BW_SNVS_HPCR_RTC_EN(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_RTC_EN) | BF_SNVS_HPCR_RTC_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field HPTA_EN[1] (RW)
 *
 * HP Time Alarm Enable When set, the time alarm interrupt is generated if the value in the HP Time
 * Alarm Registers is equal to the value of the HP Real Time Counter.
 *
 * Values:
 * - 0 - HP Time Alarm Interrupt is disabled
 * - 1 - HP Time Alarm Interrupt is enabled
 */
//@{
#define BP_SNVS_HPCR_HPTA_EN      (1)      //!< Bit position for SNVS_HPCR_HPTA_EN.
#define BM_SNVS_HPCR_HPTA_EN      (0x00000002)  //!< Bit mask for SNVS_HPCR_HPTA_EN.

//! @brief Get value of SNVS_HPCR_HPTA_EN from a register value.
#define BG_SNVS_HPCR_HPTA_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_HPTA_EN) >> BP_SNVS_HPCR_HPTA_EN)

//! @brief Format value for bitfield SNVS_HPCR_HPTA_EN.
#define BF_SNVS_HPCR_HPTA_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_HPTA_EN) & BM_SNVS_HPCR_HPTA_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPTA_EN field to a new value.
#define BW_SNVS_HPCR_HPTA_EN(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_HPTA_EN) | BF_SNVS_HPCR_HPTA_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field PI_EN[3] (RW)
 *
 * HP Periodic Interrupt Enable The periodic interrupt can be generated only if the HP Real Time
 * Counter is enabled.
 *
 * Values:
 * - 0 - HP Periodic Interrupt is disabled
 * - 1 - HP Periodic Interrupt is enabled
 */
//@{
#define BP_SNVS_HPCR_PI_EN      (3)      //!< Bit position for SNVS_HPCR_PI_EN.
#define BM_SNVS_HPCR_PI_EN      (0x00000008)  //!< Bit mask for SNVS_HPCR_PI_EN.

//! @brief Get value of SNVS_HPCR_PI_EN from a register value.
#define BG_SNVS_HPCR_PI_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_PI_EN) >> BP_SNVS_HPCR_PI_EN)

//! @brief Format value for bitfield SNVS_HPCR_PI_EN.
#define BF_SNVS_HPCR_PI_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_PI_EN) & BM_SNVS_HPCR_PI_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PI_EN field to a new value.
#define BW_SNVS_HPCR_PI_EN(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_PI_EN) | BF_SNVS_HPCR_PI_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field PI_FREQ[7:4] (RW)
 *
 * Periodic Interrupt Frequency Defines frequency of the periodic interrupt. The interrupt is
 * generated when a zero-to-one or one-to-zero transition occurs on the selected bit of the HP Real
 * Time Counter and Real Time Counter and Periodic Interrupt are both enabled (RTC_EN and PI_EN are
 * set). It is recommended to program this field when Periodic Interrupt is disabled (PI_EN is not
 * set). The possible frequencies are:
 *
 * Values:
 * - 0000 - - bit 0 of the RTC is selected as a source of the periodic interrupt
 * - 0001 - - bit 1 of the RTC is selected as a source of the periodic interrupt
 * - 0010 - - bit 2 of the RTC is selected as a source of the periodic interrupt
 * - 0011 - - bit 3 of the RTC is selected as a source of the periodic interrupt
 * - 0100 - - bit 4 of the RTC is selected as a source of the periodic interrupt
 * - 0101 - - bit 5 of the RTC is selected as a source of the periodic interrupt
 * - 0110 - - bit 6 of the RTC is selected as a source of the periodic interrupt
 * - 0111 - - bit 7 of the RTC is selected as a source of the periodic interrupt
 * - 1000 - - bit 8 of the RTC is selected as a source of the periodic interrupt
 * - 1001 - - bit 9 of the RTC is selected as a source of the periodic interrupt
 * - 1010 - - bit 10 of the RTC is selected as a source of the periodic interrupt
 * - 1011 - - bit 11 of the RTC is selected as a source of the periodic interrupt
 * - 1100 - - bit 12 of the RTC is selected as a source of the periodic interrupt
 * - 1101 - - bit 13 of the RTC is selected as a source of the periodic interrupt
 * - 1110 - - bit 14 of the RTC is selected as a source of the periodic interrupt
 * - 1111 - - bit 15 of the RTC is selected as a source of the periodic interrupt
 */
//@{
#define BP_SNVS_HPCR_PI_FREQ      (4)      //!< Bit position for SNVS_HPCR_PI_FREQ.
#define BM_SNVS_HPCR_PI_FREQ      (0x000000f0)  //!< Bit mask for SNVS_HPCR_PI_FREQ.

//! @brief Get value of SNVS_HPCR_PI_FREQ from a register value.
#define BG_SNVS_HPCR_PI_FREQ(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_PI_FREQ) >> BP_SNVS_HPCR_PI_FREQ)

//! @brief Format value for bitfield SNVS_HPCR_PI_FREQ.
#define BF_SNVS_HPCR_PI_FREQ(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_PI_FREQ) & BM_SNVS_HPCR_PI_FREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PI_FREQ field to a new value.
#define BW_SNVS_HPCR_PI_FREQ(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_PI_FREQ) | BF_SNVS_HPCR_PI_FREQ(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field HPCALB_EN[8] (RW)
 *
 * HP Real Time Counter Calibration Enabled Indicates that the time calibration mechanism is
 * enabled.
 *
 * Values:
 * - 0 - HP Timer calibration disabled
 * - 1 - HP Timer calibration enabled
 */
//@{
#define BP_SNVS_HPCR_HPCALB_EN      (8)      //!< Bit position for SNVS_HPCR_HPCALB_EN.
#define BM_SNVS_HPCR_HPCALB_EN      (0x00000100)  //!< Bit mask for SNVS_HPCR_HPCALB_EN.

//! @brief Get value of SNVS_HPCR_HPCALB_EN from a register value.
#define BG_SNVS_HPCR_HPCALB_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_HPCALB_EN) >> BP_SNVS_HPCR_HPCALB_EN)

//! @brief Format value for bitfield SNVS_HPCR_HPCALB_EN.
#define BF_SNVS_HPCR_HPCALB_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_HPCALB_EN) & BM_SNVS_HPCR_HPCALB_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPCALB_EN field to a new value.
#define BW_SNVS_HPCR_HPCALB_EN(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_HPCALB_EN) | BF_SNVS_HPCR_HPCALB_EN(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field HPCALB_VAL[14:10] (RW)
 *
 * HP Calibration Value Defines signed calibration value for the HP Real Time Counter. This field
 * can be programmed only when RTC Calibration is disabled (HPCALB_EN is not set). This is a 5-bit
 * 2's complement value. Hence, the allowable calibration values are in the range from -16 to +15
 * counts per 32768 ticks of the counter.
 *
 * Values:
 * - 00000 - +0 counts per each 32768 ticks of the counter
 * - 00001 - +1 counts per each 32768 ticks of the counter
 * - 00010 - +2 counts per each 32768 ticks of the counter
 * - 01111 - +15 counts per each 32768 ticks of the counter
 * - 10000 - -16 counts per each 32768 ticks of the counter
 * - 10001 - -15 counts per each 32768 ticks of the counter
 * - 11110 - -2 counts per each 32768 ticks of the counter
 * - 11111 - -1 counts per each 32768 ticks of the counter
 */
//@{
#define BP_SNVS_HPCR_HPCALB_VAL      (10)      //!< Bit position for SNVS_HPCR_HPCALB_VAL.
#define BM_SNVS_HPCR_HPCALB_VAL      (0x00007c00)  //!< Bit mask for SNVS_HPCR_HPCALB_VAL.

//! @brief Get value of SNVS_HPCR_HPCALB_VAL from a register value.
#define BG_SNVS_HPCR_HPCALB_VAL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_HPCALB_VAL) >> BP_SNVS_HPCR_HPCALB_VAL)

//! @brief Format value for bitfield SNVS_HPCR_HPCALB_VAL.
#define BF_SNVS_HPCR_HPCALB_VAL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_HPCALB_VAL) & BM_SNVS_HPCR_HPCALB_VAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPCALB_VAL field to a new value.
#define BW_SNVS_HPCR_HPCALB_VAL(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_HPCALB_VAL) | BF_SNVS_HPCR_HPCALB_VAL(v)))
#endif
//@}

/*! @name Register SNVS_HPCR, field HP_TS[16] (RW)
 *
 * HP Time Synchronize When set, this updates the HP Time Counter with the LP Time Counter value.
 * This self-clearing bit is always read as zero.
 *
 * Values:
 * - 0 - No Action
 * - 1 - Synchronize the HP Time Counter to the LP Time Counter
 */
//@{
#define BP_SNVS_HPCR_HP_TS      (16)      //!< Bit position for SNVS_HPCR_HP_TS.
#define BM_SNVS_HPCR_HP_TS      (0x00010000)  //!< Bit mask for SNVS_HPCR_HP_TS.

//! @brief Get value of SNVS_HPCR_HP_TS from a register value.
#define BG_SNVS_HPCR_HP_TS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPCR_HP_TS) >> BP_SNVS_HPCR_HP_TS)

//! @brief Format value for bitfield SNVS_HPCR_HP_TS.
#define BF_SNVS_HPCR_HP_TS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPCR_HP_TS) & BM_SNVS_HPCR_HP_TS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_TS field to a new value.
#define BW_SNVS_HPCR_HP_TS(v)   (HW_SNVS_HPCR_WR((HW_SNVS_HPCR_RD() & ~BM_SNVS_HPCR_HP_TS) | BF_SNVS_HPCR_HP_TS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPSICR - SNVS _HP Security Interrupt Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPSICR - SNVS _HP Security Interrupt Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HP Security Interrupt Control Register defines the SNVS security interrupt generation policy.
 * This is a privileged write register.
 */
typedef union _hw_snvs_hpsicr
{
    reg32_t U;
    struct _hw_snvs_hpsicr_bitfields
    {
        unsigned SVI_EN0 : 1; //!< [0] Security Violation Interrupt 0 Enable
        unsigned SVI_EN1 : 1; //!< [1] Security Violation Interrupt 1 Enable
        unsigned SVI_EN2 : 1; //!< [2] Security Violation Interrupt 2 Enable
        unsigned SVI_EN3 : 1; //!< [3] Security Violation Interrupt 3 Enable
        unsigned SVI_EN4 : 1; //!< [4] Security Violation Interrupt 4 Enable
        unsigned SVI_EN5 : 1; //!< [5] Security Violation Interrupt 5 Enable
        unsigned RESERVED0 : 25; //!< [30:6] Reserved
        unsigned LPSVI_EN : 1; //!< [31] LP Security Violation Interrupt Enable
    } B;
} hw_snvs_hpsicr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPSICR register
 */
//@{
#define HW_SNVS_HPSICR_ADDR      (REGS_SNVS_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPSICR           (*(volatile hw_snvs_hpsicr_t *) HW_SNVS_HPSICR_ADDR)
#define HW_SNVS_HPSICR_RD()      (HW_SNVS_HPSICR.U)
#define HW_SNVS_HPSICR_WR(v)     (HW_SNVS_HPSICR.U = (v))
#define HW_SNVS_HPSICR_SET(v)    (HW_SNVS_HPSICR_WR(HW_SNVS_HPSICR_RD() |  (v)))
#define HW_SNVS_HPSICR_CLR(v)    (HW_SNVS_HPSICR_WR(HW_SNVS_HPSICR_RD() & ~(v)))
#define HW_SNVS_HPSICR_TOG(v)    (HW_SNVS_HPSICR_WR(HW_SNVS_HPSICR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPSICR bitfields
 */

/*! @name Register SNVS_HPSICR, field SVI_EN0[0] (RW)
 *
 * Security Violation Interrupt 0 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 0.
 *
 * Values:
 * - 0 - Security Violation Interrupt 0 is Disabled
 * - 1 - Security Violation Interrupt 0 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN0      (0)      //!< Bit position for SNVS_HPSICR_SVI_EN0.
#define BM_SNVS_HPSICR_SVI_EN0      (0x00000001)  //!< Bit mask for SNVS_HPSICR_SVI_EN0.

//! @brief Get value of SNVS_HPSICR_SVI_EN0 from a register value.
#define BG_SNVS_HPSICR_SVI_EN0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN0) >> BP_SNVS_HPSICR_SVI_EN0)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN0.
#define BF_SNVS_HPSICR_SVI_EN0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN0) & BM_SNVS_HPSICR_SVI_EN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN0 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN0(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN0) | BF_SNVS_HPSICR_SVI_EN0(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field SVI_EN1[1] (RW)
 *
 * Security Violation Interrupt 1 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 1.
 *
 * Values:
 * - 0 - Security Violation Interrupt 1 is Disabled
 * - 1 - Security Violation Interrupt 1 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN1      (1)      //!< Bit position for SNVS_HPSICR_SVI_EN1.
#define BM_SNVS_HPSICR_SVI_EN1      (0x00000002)  //!< Bit mask for SNVS_HPSICR_SVI_EN1.

//! @brief Get value of SNVS_HPSICR_SVI_EN1 from a register value.
#define BG_SNVS_HPSICR_SVI_EN1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN1) >> BP_SNVS_HPSICR_SVI_EN1)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN1.
#define BF_SNVS_HPSICR_SVI_EN1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN1) & BM_SNVS_HPSICR_SVI_EN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN1 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN1(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN1) | BF_SNVS_HPSICR_SVI_EN1(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field SVI_EN2[2] (RW)
 *
 * Security Violation Interrupt 2 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 2.
 *
 * Values:
 * - 0 - Security Violation Interrupt 2 is Disabled
 * - 1 - Security Violation Interrupt 2 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN2      (2)      //!< Bit position for SNVS_HPSICR_SVI_EN2.
#define BM_SNVS_HPSICR_SVI_EN2      (0x00000004)  //!< Bit mask for SNVS_HPSICR_SVI_EN2.

//! @brief Get value of SNVS_HPSICR_SVI_EN2 from a register value.
#define BG_SNVS_HPSICR_SVI_EN2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN2) >> BP_SNVS_HPSICR_SVI_EN2)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN2.
#define BF_SNVS_HPSICR_SVI_EN2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN2) & BM_SNVS_HPSICR_SVI_EN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN2 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN2(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN2) | BF_SNVS_HPSICR_SVI_EN2(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field SVI_EN3[3] (RW)
 *
 * Security Violation Interrupt 3 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 3.
 *
 * Values:
 * - 0 - Security Violation Interrupt 3 is Disabled
 * - 1 - Security Violation Interrupt 3 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN3      (3)      //!< Bit position for SNVS_HPSICR_SVI_EN3.
#define BM_SNVS_HPSICR_SVI_EN3      (0x00000008)  //!< Bit mask for SNVS_HPSICR_SVI_EN3.

//! @brief Get value of SNVS_HPSICR_SVI_EN3 from a register value.
#define BG_SNVS_HPSICR_SVI_EN3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN3) >> BP_SNVS_HPSICR_SVI_EN3)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN3.
#define BF_SNVS_HPSICR_SVI_EN3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN3) & BM_SNVS_HPSICR_SVI_EN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN3 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN3(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN3) | BF_SNVS_HPSICR_SVI_EN3(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field SVI_EN4[4] (RW)
 *
 * Security Violation Interrupt 4 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 4.
 *
 * Values:
 * - 0 - Security Violation Interrupt 4 is Disabled
 * - 1 - Security Violation Interrupt 4 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN4      (4)      //!< Bit position for SNVS_HPSICR_SVI_EN4.
#define BM_SNVS_HPSICR_SVI_EN4      (0x00000010)  //!< Bit mask for SNVS_HPSICR_SVI_EN4.

//! @brief Get value of SNVS_HPSICR_SVI_EN4 from a register value.
#define BG_SNVS_HPSICR_SVI_EN4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN4) >> BP_SNVS_HPSICR_SVI_EN4)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN4.
#define BF_SNVS_HPSICR_SVI_EN4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN4) & BM_SNVS_HPSICR_SVI_EN4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN4 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN4(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN4) | BF_SNVS_HPSICR_SVI_EN4(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field SVI_EN5[5] (RW)
 *
 * Security Violation Interrupt 5 Enable This bit enables generation of the security interrupt to
 * the host processor upon security violation detection on input port 5.
 *
 * Values:
 * - 0 - Security Violation Interrupt 5 is Disabled
 * - 1 - Security Violation Interrupt 5 is Enabled
 */
//@{
#define BP_SNVS_HPSICR_SVI_EN5      (5)      //!< Bit position for SNVS_HPSICR_SVI_EN5.
#define BM_SNVS_HPSICR_SVI_EN5      (0x00000020)  //!< Bit mask for SNVS_HPSICR_SVI_EN5.

//! @brief Get value of SNVS_HPSICR_SVI_EN5 from a register value.
#define BG_SNVS_HPSICR_SVI_EN5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_SVI_EN5) >> BP_SNVS_HPSICR_SVI_EN5)

//! @brief Format value for bitfield SNVS_HPSICR_SVI_EN5.
#define BF_SNVS_HPSICR_SVI_EN5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_SVI_EN5) & BM_SNVS_HPSICR_SVI_EN5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SVI_EN5 field to a new value.
#define BW_SNVS_HPSICR_SVI_EN5(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_SVI_EN5) | BF_SNVS_HPSICR_SVI_EN5(v)))
#endif
//@}

/*! @name Register SNVS_HPSICR, field LPSVI_EN[31] (RW)
 *
 * LP Security Violation Interrupt Enable This bit enables generating of the security interrupt to
 * the host processor upon security violation signal from the LP section.
 *
 * Values:
 * - 0 - LP Security Violation Interrupt is Disabled
 * - 1 - LP Security Violation Interrupt is Enabled
 */
//@{
#define BP_SNVS_HPSICR_LPSVI_EN      (31)      //!< Bit position for SNVS_HPSICR_LPSVI_EN.
#define BM_SNVS_HPSICR_LPSVI_EN      (0x80000000)  //!< Bit mask for SNVS_HPSICR_LPSVI_EN.

//! @brief Get value of SNVS_HPSICR_LPSVI_EN from a register value.
#define BG_SNVS_HPSICR_LPSVI_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSICR_LPSVI_EN) >> BP_SNVS_HPSICR_LPSVI_EN)

//! @brief Format value for bitfield SNVS_HPSICR_LPSVI_EN.
#define BF_SNVS_HPSICR_LPSVI_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSICR_LPSVI_EN) & BM_SNVS_HPSICR_LPSVI_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPSVI_EN field to a new value.
#define BW_SNVS_HPSICR_LPSVI_EN(v)   (HW_SNVS_HPSICR_WR((HW_SNVS_HPSICR_RD() & ~BM_SNVS_HPSICR_LPSVI_EN) | BF_SNVS_HPSICR_LPSVI_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPSVCR - SNVS _HP Security Violation Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPSVCR - SNVS _HP Security Violation Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HP Security Violation Control Register defines types for each security violation input. This
 * is a privileged write register.
 */
typedef union _hw_snvs_hpsvcr
{
    reg32_t U;
    struct _hw_snvs_hpsvcr_bitfields
    {
        unsigned SV_CFG0 : 1; //!< [0] Security Violation Input 0 Configuration
        unsigned SV_CFG1 : 1; //!< [1] Security Violation Input 1 Configuration
        unsigned SV_CFG2 : 1; //!< [2] Security Violation Input 2 Configuration
        unsigned SV_CFG3 : 1; //!< [3] Security Violation Input 3 Configuration
        unsigned SV_CFG4 : 1; //!< [4] Security Violation Input 4 Configuration
        unsigned SV_CFG5 : 2; //!< [6:5] Security Violation Input 5 Configuration
        unsigned RESERVED0 : 23; //!< [29:7] Reserved
        unsigned LPSV_CFG : 2; //!< [31:30] LP Security Violation Configuration
    } B;
} hw_snvs_hpsvcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPSVCR register
 */
//@{
#define HW_SNVS_HPSVCR_ADDR      (REGS_SNVS_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPSVCR           (*(volatile hw_snvs_hpsvcr_t *) HW_SNVS_HPSVCR_ADDR)
#define HW_SNVS_HPSVCR_RD()      (HW_SNVS_HPSVCR.U)
#define HW_SNVS_HPSVCR_WR(v)     (HW_SNVS_HPSVCR.U = (v))
#define HW_SNVS_HPSVCR_SET(v)    (HW_SNVS_HPSVCR_WR(HW_SNVS_HPSVCR_RD() |  (v)))
#define HW_SNVS_HPSVCR_CLR(v)    (HW_SNVS_HPSVCR_WR(HW_SNVS_HPSVCR_RD() & ~(v)))
#define HW_SNVS_HPSVCR_TOG(v)    (HW_SNVS_HPSVCR_WR(HW_SNVS_HPSVCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPSVCR bitfields
 */

/*! @name Register SNVS_HPSVCR, field SV_CFG0[0] (RW)
 *
 * Security Violation Input 0 Configuration This field configures the security violation input 0.
 * This setting instructs the SSM how to respond when a security violation on port 0 is detected.
 *
 * Values:
 * - 0 - Security Violation 0 is a non-fatal violation
 * - 1 - Security Violation 0 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG0      (0)      //!< Bit position for SNVS_HPSVCR_SV_CFG0.
#define BM_SNVS_HPSVCR_SV_CFG0      (0x00000001)  //!< Bit mask for SNVS_HPSVCR_SV_CFG0.

//! @brief Get value of SNVS_HPSVCR_SV_CFG0 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG0) >> BP_SNVS_HPSVCR_SV_CFG0)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG0.
#define BF_SNVS_HPSVCR_SV_CFG0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG0) & BM_SNVS_HPSVCR_SV_CFG0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG0 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG0(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG0) | BF_SNVS_HPSVCR_SV_CFG0(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field SV_CFG1[1] (RW)
 *
 * Security Violation Input 1 Configuration This field configures the Security Violation Input 1.
 * This setting instructs the SSM how to respond when a security violation on port 1 is detected.
 *
 * Values:
 * - 0 - Security Violation 1 is a non-fatal violation
 * - 1 - Security Violation 1 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG1      (1)      //!< Bit position for SNVS_HPSVCR_SV_CFG1.
#define BM_SNVS_HPSVCR_SV_CFG1      (0x00000002)  //!< Bit mask for SNVS_HPSVCR_SV_CFG1.

//! @brief Get value of SNVS_HPSVCR_SV_CFG1 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG1) >> BP_SNVS_HPSVCR_SV_CFG1)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG1.
#define BF_SNVS_HPSVCR_SV_CFG1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG1) & BM_SNVS_HPSVCR_SV_CFG1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG1 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG1(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG1) | BF_SNVS_HPSVCR_SV_CFG1(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field SV_CFG2[2] (RW)
 *
 * Security Violation Input 2 Configuration This field configures the security violation input 2.
 * This setting instructs the SSM how to respond when a security violation on port 2 is detected.
 *
 * Values:
 * - 0 - Security Violation 2 is a non-fatal violation
 * - 1 - Security Violation 2 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG2      (2)      //!< Bit position for SNVS_HPSVCR_SV_CFG2.
#define BM_SNVS_HPSVCR_SV_CFG2      (0x00000004)  //!< Bit mask for SNVS_HPSVCR_SV_CFG2.

//! @brief Get value of SNVS_HPSVCR_SV_CFG2 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG2) >> BP_SNVS_HPSVCR_SV_CFG2)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG2.
#define BF_SNVS_HPSVCR_SV_CFG2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG2) & BM_SNVS_HPSVCR_SV_CFG2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG2 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG2(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG2) | BF_SNVS_HPSVCR_SV_CFG2(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field SV_CFG3[3] (RW)
 *
 * Security Violation Input 3 Configuration This field configures the security violation input 3.
 * This setting instructs the SSM how to respond when a security violation on port 3 is detected.
 *
 * Values:
 * - 0 - Security Violation 3 is a non-fatal violation
 * - 1 - Security Violation 3 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG3      (3)      //!< Bit position for SNVS_HPSVCR_SV_CFG3.
#define BM_SNVS_HPSVCR_SV_CFG3      (0x00000008)  //!< Bit mask for SNVS_HPSVCR_SV_CFG3.

//! @brief Get value of SNVS_HPSVCR_SV_CFG3 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG3) >> BP_SNVS_HPSVCR_SV_CFG3)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG3.
#define BF_SNVS_HPSVCR_SV_CFG3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG3) & BM_SNVS_HPSVCR_SV_CFG3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG3 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG3(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG3) | BF_SNVS_HPSVCR_SV_CFG3(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field SV_CFG4[4] (RW)
 *
 * Security Violation Input 4 Configuration This field configures the security violation Input 4.
 * This setting instructs the SSM how to respond when a security violation on port 4 is detected.
 *
 * Values:
 * - 0 - Security Violation 4 is a non-fatal violation
 * - 1 - Security Violation 4 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG4      (4)      //!< Bit position for SNVS_HPSVCR_SV_CFG4.
#define BM_SNVS_HPSVCR_SV_CFG4      (0x00000010)  //!< Bit mask for SNVS_HPSVCR_SV_CFG4.

//! @brief Get value of SNVS_HPSVCR_SV_CFG4 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG4) >> BP_SNVS_HPSVCR_SV_CFG4)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG4.
#define BF_SNVS_HPSVCR_SV_CFG4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG4) & BM_SNVS_HPSVCR_SV_CFG4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG4 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG4(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG4) | BF_SNVS_HPSVCR_SV_CFG4(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field SV_CFG5[6:5] (RW)
 *
 * Security Violation Input 5 Configuration This field configures the Security Violation Input 5.
 * This setting instructs the SSM how to respond when a security violation on port 5 is detected.
 *
 * Values:
 * - 00 - Security Violation 5 is disabled
 * - 01 - Security Violation 5 is a non-fatal violation
 * - 1x - Security Violation 5 is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_SV_CFG5      (5)      //!< Bit position for SNVS_HPSVCR_SV_CFG5.
#define BM_SNVS_HPSVCR_SV_CFG5      (0x00000060)  //!< Bit mask for SNVS_HPSVCR_SV_CFG5.

//! @brief Get value of SNVS_HPSVCR_SV_CFG5 from a register value.
#define BG_SNVS_HPSVCR_SV_CFG5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_SV_CFG5) >> BP_SNVS_HPSVCR_SV_CFG5)

//! @brief Format value for bitfield SNVS_HPSVCR_SV_CFG5.
#define BF_SNVS_HPSVCR_SV_CFG5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_SV_CFG5) & BM_SNVS_HPSVCR_SV_CFG5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_CFG5 field to a new value.
#define BW_SNVS_HPSVCR_SV_CFG5(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_SV_CFG5) | BF_SNVS_HPSVCR_SV_CFG5(v)))
#endif
//@}

/*! @name Register SNVS_HPSVCR, field LPSV_CFG[31:30] (RW)
 *
 * LP Security Violation Configuration This field configures the LP security violation source.
 *
 * Values:
 * - 00 - LP security violation is disabled
 * - 01 - LP security violation is a non-fatal violation
 * - 1x - LP security violation is a fatal violation
 */
//@{
#define BP_SNVS_HPSVCR_LPSV_CFG      (30)      //!< Bit position for SNVS_HPSVCR_LPSV_CFG.
#define BM_SNVS_HPSVCR_LPSV_CFG      (0xc0000000)  //!< Bit mask for SNVS_HPSVCR_LPSV_CFG.

//! @brief Get value of SNVS_HPSVCR_LPSV_CFG from a register value.
#define BG_SNVS_HPSVCR_LPSV_CFG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVCR_LPSV_CFG) >> BP_SNVS_HPSVCR_LPSV_CFG)

//! @brief Format value for bitfield SNVS_HPSVCR_LPSV_CFG.
#define BF_SNVS_HPSVCR_LPSV_CFG(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVCR_LPSV_CFG) & BM_SNVS_HPSVCR_LPSV_CFG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPSV_CFG field to a new value.
#define BW_SNVS_HPSVCR_LPSV_CFG(v)   (HW_SNVS_HPSVCR_WR((HW_SNVS_HPSVCR_RD() & ~BM_SNVS_HPSVCR_LPSV_CFG) | BF_SNVS_HPSVCR_LPSV_CFG(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPSR - SNVS _HP Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPSR - SNVS _HP Status Register (RW)
 *
 * Reset value: 0x80000000eeeaedeedeaefeeeadeaefeaedfe
 *
 * The HP Status Register reflects the internal state of the SNVS .
 */
typedef union _hw_snvs_hpsr
{
    reg32_t U;
    struct _hw_snvs_hpsr_bitfields
    {
        unsigned HPTA : 1; //!< [0] HP Time Alarm Indicates that the HP Time Alarm has occurred since this bit was last cleared.
        unsigned PI : 1; //!< [1] Periodic Interrupt
        unsigned RESERVED0 : 2; //!< [3:2] Reserved
        unsigned LPDIS : 1; //!< [4] Low Power Disable
        unsigned RESERVED1 : 3; //!< [7:5] Reserved
        unsigned SSM_ST : 4; //!< [11:8] System Security Monitor State
        unsigned SYS_SECURITY_CFG : 3; //!< [14:12] This field reflects the value of the sys_security_cfg input signal, which is defined as follows:
        unsigned SYS_SECURE_BOOT : 1; //!< [15] This bit reflects the value of the sys_secure_boot input signal to SNVS .
        unsigned OTPMK_SYNDROME : 9; //!< [24:16] One Time Programmable Master Key Syndrome Value
        unsigned RESERVED2 : 2; //!< [26:25] Reserved
        unsigned OTPMK_ZERO : 1; //!< [27] One Time Programmable Master Key is Equal to Zero.
        unsigned RESERVED3 : 3; //!< [30:28] Reserved
        unsigned ZMK_ZERO : 1; //!< [31] Zeroizable Master Key is Equal to Zero.
    } B;
} hw_snvs_hpsr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPSR register
 */
//@{
#define HW_SNVS_HPSR_ADDR      (REGS_SNVS_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPSR           (*(volatile hw_snvs_hpsr_t *) HW_SNVS_HPSR_ADDR)
#define HW_SNVS_HPSR_RD()      (HW_SNVS_HPSR.U)
#define HW_SNVS_HPSR_WR(v)     (HW_SNVS_HPSR.U = (v))
#define HW_SNVS_HPSR_SET(v)    (HW_SNVS_HPSR_WR(HW_SNVS_HPSR_RD() |  (v)))
#define HW_SNVS_HPSR_CLR(v)    (HW_SNVS_HPSR_WR(HW_SNVS_HPSR_RD() & ~(v)))
#define HW_SNVS_HPSR_TOG(v)    (HW_SNVS_HPSR_WR(HW_SNVS_HPSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPSR bitfields
 */

/*! @name Register SNVS_HPSR, field HPTA[0] (RW)
 *
 * HP Time Alarm Indicates that the HP Time Alarm has occurred since this bit was last cleared.
 *
 * Values:
 * - 0 - No time alarm interrupt occurred.
 * - 1 - A time alarm interrupt occurred.
 */
//@{
#define BP_SNVS_HPSR_HPTA      (0)      //!< Bit position for SNVS_HPSR_HPTA.
#define BM_SNVS_HPSR_HPTA      (0x00000001)  //!< Bit mask for SNVS_HPSR_HPTA.

//! @brief Get value of SNVS_HPSR_HPTA from a register value.
#define BG_SNVS_HPSR_HPTA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_HPTA) >> BP_SNVS_HPSR_HPTA)

//! @brief Format value for bitfield SNVS_HPSR_HPTA.
#define BF_SNVS_HPSR_HPTA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_HPTA) & BM_SNVS_HPSR_HPTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPTA field to a new value.
#define BW_SNVS_HPSR_HPTA(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_HPTA) | BF_SNVS_HPSR_HPTA(v)))
#endif
//@}

/*! @name Register SNVS_HPSR, field PI[1] (RW)
 *
 * Periodic Interrupt Indicates that periodic interrupt has occurred since this bit was last
 * cleared.
 *
 * Values:
 * - 0 - No periodic interrupt occurred.
 * - 1 - A periodic interrupt occurred.
 */
//@{
#define BP_SNVS_HPSR_PI      (1)      //!< Bit position for SNVS_HPSR_PI.
#define BM_SNVS_HPSR_PI      (0x00000002)  //!< Bit mask for SNVS_HPSR_PI.

//! @brief Get value of SNVS_HPSR_PI from a register value.
#define BG_SNVS_HPSR_PI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_PI) >> BP_SNVS_HPSR_PI)

//! @brief Format value for bitfield SNVS_HPSR_PI.
#define BF_SNVS_HPSR_PI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_PI) & BM_SNVS_HPSR_PI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PI field to a new value.
#define BW_SNVS_HPSR_PI(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_PI) | BF_SNVS_HPSR_PI(v)))
#endif
//@}

/*! @name Register SNVS_HPSR, field LPDIS[4] (RW)
 *
 * Low Power Disable If 1, the SNVS low power section has been disabled by means of an input signal
 * to the SNVS .
 */
//@{
#define BP_SNVS_HPSR_LPDIS      (4)      //!< Bit position for SNVS_HPSR_LPDIS.
#define BM_SNVS_HPSR_LPDIS      (0x00000010)  //!< Bit mask for SNVS_HPSR_LPDIS.

//! @brief Get value of SNVS_HPSR_LPDIS from a register value.
#define BG_SNVS_HPSR_LPDIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_LPDIS) >> BP_SNVS_HPSR_LPDIS)

//! @brief Format value for bitfield SNVS_HPSR_LPDIS.
#define BF_SNVS_HPSR_LPDIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_LPDIS) & BM_SNVS_HPSR_LPDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPDIS field to a new value.
#define BW_SNVS_HPSR_LPDIS(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_LPDIS) | BF_SNVS_HPSR_LPDIS(v)))
#endif
//@}

/*! @name Register SNVS_HPSR, field SSM_ST[11:8] (RW)
 *
 * System Security Monitor State This field contains the encoded state of the SSM's state machine.
 * The encoding of the possible states are:
 *
 * Values:
 * - INIT = 0000 - Init
 * - HARD_FAIL = 0001 - Hard Fail
 * - SOFT_FAIL = 0011 - Soft Fail
 * - INIT_INTERMEDIATE = 1000 - Init Intermediate (transition state between Init and Check - SSM stays in this state only one clock
 *     cycle)
 * - CHECK = 1001 - Check
 * - NON_SECURE = 1011 - Non-Secure
 * - TRUSTED = 1101 - Trusted
 * - SECURE = 1111 - Secure
 */
//@{
#define BP_SNVS_HPSR_SSM_ST      (8)      //!< Bit position for SNVS_HPSR_SSM_ST.
#define BM_SNVS_HPSR_SSM_ST      (0x00000f00)  //!< Bit mask for SNVS_HPSR_SSM_ST.

//! @brief Get value of SNVS_HPSR_SSM_ST from a register value.
#define BG_SNVS_HPSR_SSM_ST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_SSM_ST) >> BP_SNVS_HPSR_SSM_ST)

//! @brief Format value for bitfield SNVS_HPSR_SSM_ST.
#define BF_SNVS_HPSR_SSM_ST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_SSM_ST) & BM_SNVS_HPSR_SSM_ST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSM_ST field to a new value.
#define BW_SNVS_HPSR_SSM_ST(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_SSM_ST) | BF_SNVS_HPSR_SSM_ST(v)))
#endif

//! @brief Macro to simplify usage of value macros.
#define BF_SNVS_HPSR_SSM_ST_V(v) BF_SNVS_HPSR_SSM_ST(BV_SNVS_HPSR_SSM_ST__##v)

#define BV_SNVS_HPSR_SSM_ST__INIT (0x0) //!< Init
#define BV_SNVS_HPSR_SSM_ST__HARD_FAIL (0x1) //!< Hard Fail
#define BV_SNVS_HPSR_SSM_ST__SOFT_FAIL (0x3) //!< Soft Fail
#define BV_SNVS_HPSR_SSM_ST__INIT_INTERMEDIATE (0x8) //!< Init Intermediate (transition state between Init and Check - SSM stays in this state only one clock cycle)
#define BV_SNVS_HPSR_SSM_ST__CHECK (0x9) //!< Check
#define BV_SNVS_HPSR_SSM_ST__NON_SECURE (0xb) //!< Non-Secure
#define BV_SNVS_HPSR_SSM_ST__TRUSTED (0xd) //!< Trusted
#define BV_SNVS_HPSR_SSM_ST__SECURE (0xf) //!< Secure
//@}

/*! @name Register SNVS_HPSR, field SYS_SECURITY_CFG[14:12] (RW)
 *
 * This field reflects the value of the sys_security_cfg input signal, which is defined as follows:
 *
 * Values:
 * - FAB = 000 - Fab Configuration - the default configuration of newly fabricated chips
 * - OPEN = 001 - Open Configuration - the configuration after Freescale- programmable fuses have been blown
 * - CLOSED = 01x - Closed Configuration - the configuration after OEM-programmable fuses have been blown
 * - FIELD_RETURN = 1xx - Field Return Configuration - the configuration of chips that are returned to Freescale for analysis
 */
//@{
#define BP_SNVS_HPSR_SYS_SECURITY_CFG      (12)      //!< Bit position for SNVS_HPSR_SYS_SECURITY_CFG.
#define BM_SNVS_HPSR_SYS_SECURITY_CFG      (0x00007000)  //!< Bit mask for SNVS_HPSR_SYS_SECURITY_CFG.

//! @brief Get value of SNVS_HPSR_SYS_SECURITY_CFG from a register value.
#define BG_SNVS_HPSR_SYS_SECURITY_CFG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_SYS_SECURITY_CFG) >> BP_SNVS_HPSR_SYS_SECURITY_CFG)

//! @brief Format value for bitfield SNVS_HPSR_SYS_SECURITY_CFG.
#define BF_SNVS_HPSR_SYS_SECURITY_CFG(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_SYS_SECURITY_CFG) & BM_SNVS_HPSR_SYS_SECURITY_CFG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYS_SECURITY_CFG field to a new value.
#define BW_SNVS_HPSR_SYS_SECURITY_CFG(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_SYS_SECURITY_CFG) | BF_SNVS_HPSR_SYS_SECURITY_CFG(v)))
#endif

//! @brief Macro to simplify usage of value macros.
#define BF_SNVS_HPSR_SYS_SECURITY_CFG_V(v) BF_SNVS_HPSR_SYS_SECURITY_CFG(BV_SNVS_HPSR_SYS_SECURITY_CFG__##v)

#define BV_SNVS_HPSR_SYS_SECURITY_CFG__FAB (0x0) //!< Fab Configuration - the default configuration of newly fabricated chips
#define BV_SNVS_HPSR_SYS_SECURITY_CFG__OPEN (0x1) //!< Open Configuration - the configuration after Freescale- programmable fuses have been blown
#define BV_SNVS_HPSR_SYS_SECURITY_CFG__CLOSED (0x2) //!< Closed Configuration - the configuration after OEM-programmable fuses have been blown
#define BV_SNVS_HPSR_SYS_SECURITY_CFG__FIELD_RETURN (0x4) //!< Field Return Configuration - the configuration of chips that are returned to Freescale for analysis
//@}

/*! @name Register SNVS_HPSR, field SYS_SECURE_BOOT[15] (RW)
 *
 * This bit reflects the value of the sys_secure_boot input signal to SNVS . If this bit is 1, the
 * chip boots from internal ROM.
 */
//@{
#define BP_SNVS_HPSR_SYS_SECURE_BOOT      (15)      //!< Bit position for SNVS_HPSR_SYS_SECURE_BOOT.
#define BM_SNVS_HPSR_SYS_SECURE_BOOT      (0x00008000)  //!< Bit mask for SNVS_HPSR_SYS_SECURE_BOOT.

//! @brief Get value of SNVS_HPSR_SYS_SECURE_BOOT from a register value.
#define BG_SNVS_HPSR_SYS_SECURE_BOOT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_SYS_SECURE_BOOT) >> BP_SNVS_HPSR_SYS_SECURE_BOOT)

//! @brief Format value for bitfield SNVS_HPSR_SYS_SECURE_BOOT.
#define BF_SNVS_HPSR_SYS_SECURE_BOOT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_SYS_SECURE_BOOT) & BM_SNVS_HPSR_SYS_SECURE_BOOT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYS_SECURE_BOOT field to a new value.
#define BW_SNVS_HPSR_SYS_SECURE_BOOT(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_SYS_SECURE_BOOT) | BF_SNVS_HPSR_SYS_SECURE_BOOT(v)))
#endif
//@}

/*! @name Register SNVS_HPSR, field OTPMK_SYNDROME[24:16] (RW)
 *
 * One Time Programmable Master Key Syndrome Value The eight lower bits of this value indicate error
 * location in case of a single-bit error. For example, syndrome word 10010110 indicates that key
 * bit 150 has an error. The ninth bit of the syndrome word checks parity of the whole key value.
 * This bit is 1 when the odd number of errors are occurred and it is 0 when the number of errors is
 * even. For example, if one of the eight bits indicates a failure and the ninth bit is zero then
 * the number of errors in the one time programmable master key is at least 2 and it cannot be
 * corrected. when one of the syndrome bits is set, the bad key violation is always generated
 */
//@{
#define BP_SNVS_HPSR_OTPMK_SYNDROME      (16)      //!< Bit position for SNVS_HPSR_OTPMK_SYNDROME.
#define BM_SNVS_HPSR_OTPMK_SYNDROME      (0x01ff0000)  //!< Bit mask for SNVS_HPSR_OTPMK_SYNDROME.

//! @brief Get value of SNVS_HPSR_OTPMK_SYNDROME from a register value.
#define BG_SNVS_HPSR_OTPMK_SYNDROME(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_OTPMK_SYNDROME) >> BP_SNVS_HPSR_OTPMK_SYNDROME)

//! @brief Format value for bitfield SNVS_HPSR_OTPMK_SYNDROME.
#define BF_SNVS_HPSR_OTPMK_SYNDROME(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_OTPMK_SYNDROME) & BM_SNVS_HPSR_OTPMK_SYNDROME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OTPMK_SYNDROME field to a new value.
#define BW_SNVS_HPSR_OTPMK_SYNDROME(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_OTPMK_SYNDROME) | BF_SNVS_HPSR_OTPMK_SYNDROME(v)))
#endif
//@}

/*! @name Register SNVS_HPSR, field OTPMK_ZERO[27] (RW)
 *
 * One Time Programmable Master Key is Equal to Zero. When set, this bit always triggers "bad key"
 * violation
 *
 * Values:
 * - NOT_ZERO = 0 - The OTPMK is not zero.
 * - IS_ZERO = 1 - The OTPMK is zero.
 */
//@{
#define BP_SNVS_HPSR_OTPMK_ZERO      (27)      //!< Bit position for SNVS_HPSR_OTPMK_ZERO.
#define BM_SNVS_HPSR_OTPMK_ZERO      (0x08000000)  //!< Bit mask for SNVS_HPSR_OTPMK_ZERO.

//! @brief Get value of SNVS_HPSR_OTPMK_ZERO from a register value.
#define BG_SNVS_HPSR_OTPMK_ZERO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_OTPMK_ZERO) >> BP_SNVS_HPSR_OTPMK_ZERO)

//! @brief Format value for bitfield SNVS_HPSR_OTPMK_ZERO.
#define BF_SNVS_HPSR_OTPMK_ZERO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_OTPMK_ZERO) & BM_SNVS_HPSR_OTPMK_ZERO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OTPMK_ZERO field to a new value.
#define BW_SNVS_HPSR_OTPMK_ZERO(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_OTPMK_ZERO) | BF_SNVS_HPSR_OTPMK_ZERO(v)))
#endif

//! @brief Macro to simplify usage of value macros.
#define BF_SNVS_HPSR_OTPMK_ZERO_V(v) BF_SNVS_HPSR_OTPMK_ZERO(BV_SNVS_HPSR_OTPMK_ZERO__##v)

#define BV_SNVS_HPSR_OTPMK_ZERO__NOT_ZERO (0x0) //!< The OTPMK is not zero.
#define BV_SNVS_HPSR_OTPMK_ZERO__IS_ZERO (0x1) //!< The OTPMK is zero.
//@}

/*! @name Register SNVS_HPSR, field ZMK_ZERO[31] (RW)
 *
 * Zeroizable Master Key is Equal to Zero. When set, this bit triggers "bad key" violation if the
 * ZMK is selected for use
 *
 * Values:
 * - NOT_ZERO = 0 - The ZMK is not zero.
 * - IS_ZERO = 1 - The ZMK is zero.
 */
//@{
#define BP_SNVS_HPSR_ZMK_ZERO      (31)      //!< Bit position for SNVS_HPSR_ZMK_ZERO.
#define BM_SNVS_HPSR_ZMK_ZERO      (0x80000000)  //!< Bit mask for SNVS_HPSR_ZMK_ZERO.

//! @brief Get value of SNVS_HPSR_ZMK_ZERO from a register value.
#define BG_SNVS_HPSR_ZMK_ZERO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSR_ZMK_ZERO) >> BP_SNVS_HPSR_ZMK_ZERO)

//! @brief Format value for bitfield SNVS_HPSR_ZMK_ZERO.
#define BF_SNVS_HPSR_ZMK_ZERO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSR_ZMK_ZERO) & BM_SNVS_HPSR_ZMK_ZERO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_ZERO field to a new value.
#define BW_SNVS_HPSR_ZMK_ZERO(v)   (HW_SNVS_HPSR_WR((HW_SNVS_HPSR_RD() & ~BM_SNVS_HPSR_ZMK_ZERO) | BF_SNVS_HPSR_ZMK_ZERO(v)))
#endif

//! @brief Macro to simplify usage of value macros.
#define BF_SNVS_HPSR_ZMK_ZERO_V(v) BF_SNVS_HPSR_ZMK_ZERO(BV_SNVS_HPSR_ZMK_ZERO__##v)

#define BV_SNVS_HPSR_ZMK_ZERO__NOT_ZERO (0x0) //!< The ZMK is not zero.
#define BV_SNVS_HPSR_ZMK_ZERO__IS_ZERO (0x1) //!< The ZMK is zero.
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPSVSR - SNVS _HP Security Violation Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPSVSR - SNVS _HP Security Violation Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HP Security Violation Status Register reflects the HP domain security violation records.
 * Write a 1 to SEC_VIO5-0 to clear the corresponding security violation detection flag. Note that
 * this does not automatically clear the security violation signal that is connected to the input,
 * so the security violation may immediately be detected again
 */
typedef union _hw_snvs_hpsvsr
{
    reg32_t U;
    struct _hw_snvs_hpsvsr_bitfields
    {
        unsigned SEC_VIO0 : 1; //!< [0] Security violation on input 0 is detected.
        unsigned SEC_VIO1 : 1; //!< [1] Security violation on input 1 is detected.
        unsigned SEC_VIO2 : 1; //!< [2] Security violation on input 2 is detected.
        unsigned SEC_VIO3 : 1; //!< [3] Security violation on input 3 is detected.
        unsigned SEC_VIO4 : 1; //!< [4] Security violation on input 4 is detected.
        unsigned SEC_VIO5 : 1; //!< [5] Security volation on input 5 is detected.
        unsigned RESERVED0 : 10; //!< [15:6] Reserved
        unsigned ZMK_SYNDROME : 9; //!< [24:16] Zeroizable Master Key Syndrome Value
        unsigned RESERVED1 : 2; //!< [26:25] Reserved
        unsigned ZMK_ECC_FAIL : 1; //!< [27] Zeroizable Master Key Error Correcting Code Check Failure
        unsigned RESERVED2 : 4; //!< [31:28] Reserved
    } B;
} hw_snvs_hpsvsr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPSVSR register
 */
//@{
#define HW_SNVS_HPSVSR_ADDR      (REGS_SNVS_BASE + 0x18)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPSVSR           (*(volatile hw_snvs_hpsvsr_t *) HW_SNVS_HPSVSR_ADDR)
#define HW_SNVS_HPSVSR_RD()      (HW_SNVS_HPSVSR.U)
#define HW_SNVS_HPSVSR_WR(v)     (HW_SNVS_HPSVSR.U = (v))
#define HW_SNVS_HPSVSR_SET(v)    (HW_SNVS_HPSVSR_WR(HW_SNVS_HPSVSR_RD() |  (v)))
#define HW_SNVS_HPSVSR_CLR(v)    (HW_SNVS_HPSVSR_WR(HW_SNVS_HPSVSR_RD() & ~(v)))
#define HW_SNVS_HPSVSR_TOG(v)    (HW_SNVS_HPSVSR_WR(HW_SNVS_HPSVSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPSVSR bitfields
 */

/*! @name Register SNVS_HPSVSR, field SEC_VIO0[0] (W1C)
 *
 * Security violation on input 0 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 0.
 * - 1 - Security violation occurred on port 0.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO0      (0)      //!< Bit position for SNVS_HPSVSR_SEC_VIO0.
#define BM_SNVS_HPSVSR_SEC_VIO0      (0x00000001)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO0.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO0 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO0) >> BP_SNVS_HPSVSR_SEC_VIO0)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO0.
#define BF_SNVS_HPSVSR_SEC_VIO0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO0) & BM_SNVS_HPSVSR_SEC_VIO0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO0 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO0(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO0) | BF_SNVS_HPSVSR_SEC_VIO0(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field SEC_VIO1[1] (W1C)
 *
 * Security violation on input 1 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 1.
 * - 1 - Security violation occurred on port 1.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO1      (1)      //!< Bit position for SNVS_HPSVSR_SEC_VIO1.
#define BM_SNVS_HPSVSR_SEC_VIO1      (0x00000002)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO1.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO1 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO1) >> BP_SNVS_HPSVSR_SEC_VIO1)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO1.
#define BF_SNVS_HPSVSR_SEC_VIO1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO1) & BM_SNVS_HPSVSR_SEC_VIO1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO1 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO1(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO1) | BF_SNVS_HPSVSR_SEC_VIO1(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field SEC_VIO2[2] (W1C)
 *
 * Security violation on input 2 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 2.
 * - 1 - Security violation occurred on port 2.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO2      (2)      //!< Bit position for SNVS_HPSVSR_SEC_VIO2.
#define BM_SNVS_HPSVSR_SEC_VIO2      (0x00000004)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO2.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO2 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO2) >> BP_SNVS_HPSVSR_SEC_VIO2)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO2.
#define BF_SNVS_HPSVSR_SEC_VIO2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO2) & BM_SNVS_HPSVSR_SEC_VIO2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO2 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO2(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO2) | BF_SNVS_HPSVSR_SEC_VIO2(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field SEC_VIO3[3] (W1C)
 *
 * Security violation on input 3 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 3.
 * - 1 - Security violation occurred on port 3.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO3      (3)      //!< Bit position for SNVS_HPSVSR_SEC_VIO3.
#define BM_SNVS_HPSVSR_SEC_VIO3      (0x00000008)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO3.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO3 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO3) >> BP_SNVS_HPSVSR_SEC_VIO3)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO3.
#define BF_SNVS_HPSVSR_SEC_VIO3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO3) & BM_SNVS_HPSVSR_SEC_VIO3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO3 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO3(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO3) | BF_SNVS_HPSVSR_SEC_VIO3(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field SEC_VIO4[4] (W1C)
 *
 * Security violation on input 4 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 4.
 * - 1 - Security violation occurred on port 4.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO4      (4)      //!< Bit position for SNVS_HPSVSR_SEC_VIO4.
#define BM_SNVS_HPSVSR_SEC_VIO4      (0x00000010)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO4.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO4 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO4) >> BP_SNVS_HPSVSR_SEC_VIO4)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO4.
#define BF_SNVS_HPSVSR_SEC_VIO4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO4) & BM_SNVS_HPSVSR_SEC_VIO4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO4 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO4(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO4) | BF_SNVS_HPSVSR_SEC_VIO4(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field SEC_VIO5[5] (W1C)
 *
 * Security volation on input 5 is detected.
 *
 * Values:
 * - 0 - No security violation occurred on port 5.
 * - 1 - Security violation occurred on port 5.
 */
//@{
#define BP_SNVS_HPSVSR_SEC_VIO5      (5)      //!< Bit position for SNVS_HPSVSR_SEC_VIO5.
#define BM_SNVS_HPSVSR_SEC_VIO5      (0x00000020)  //!< Bit mask for SNVS_HPSVSR_SEC_VIO5.

//! @brief Get value of SNVS_HPSVSR_SEC_VIO5 from a register value.
#define BG_SNVS_HPSVSR_SEC_VIO5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_SEC_VIO5) >> BP_SNVS_HPSVSR_SEC_VIO5)

//! @brief Format value for bitfield SNVS_HPSVSR_SEC_VIO5.
#define BF_SNVS_HPSVSR_SEC_VIO5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_SEC_VIO5) & BM_SNVS_HPSVSR_SEC_VIO5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEC_VIO5 field to a new value.
#define BW_SNVS_HPSVSR_SEC_VIO5(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_SEC_VIO5) | BF_SNVS_HPSVSR_SEC_VIO5(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field ZMK_SYNDROME[24:16] (RW)
 *
 * Zeroizable Master Key Syndrome Value The ZMK syndrome indicates error location and parity similar
 * to the OTPMK syndrome . This value is set and locked when a ZMK ECC failure is detected. It is
 * cleared by writing one into ZMK_ECC_FAIL bit.
 */
//@{
#define BP_SNVS_HPSVSR_ZMK_SYNDROME      (16)      //!< Bit position for SNVS_HPSVSR_ZMK_SYNDROME.
#define BM_SNVS_HPSVSR_ZMK_SYNDROME      (0x01ff0000)  //!< Bit mask for SNVS_HPSVSR_ZMK_SYNDROME.

//! @brief Get value of SNVS_HPSVSR_ZMK_SYNDROME from a register value.
#define BG_SNVS_HPSVSR_ZMK_SYNDROME(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_ZMK_SYNDROME) >> BP_SNVS_HPSVSR_ZMK_SYNDROME)

//! @brief Format value for bitfield SNVS_HPSVSR_ZMK_SYNDROME.
#define BF_SNVS_HPSVSR_ZMK_SYNDROME(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_ZMK_SYNDROME) & BM_SNVS_HPSVSR_ZMK_SYNDROME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_SYNDROME field to a new value.
#define BW_SNVS_HPSVSR_ZMK_SYNDROME(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_ZMK_SYNDROME) | BF_SNVS_HPSVSR_ZMK_SYNDROME(v)))
#endif
//@}

/*! @name Register SNVS_HPSVSR, field ZMK_ECC_FAIL[27] (RW)
 *
 * Zeroizable Master Key Error Correcting Code Check Failure When set, this bit triggers a bad key
 * violation to the SSM and a security violation to the SNVS _LP section, which clears security
 * sensitive data. Writing a one to this bit clears the record of this failure. It also clears this
 * register's ZMK_SYNDROME field.
 *
 * Values:
 * - 0 - ZMK ECC Failure was not detected.
 * - 1 - ZMK ECC Failure was detected.
 */
//@{
#define BP_SNVS_HPSVSR_ZMK_ECC_FAIL      (27)      //!< Bit position for SNVS_HPSVSR_ZMK_ECC_FAIL.
#define BM_SNVS_HPSVSR_ZMK_ECC_FAIL      (0x08000000)  //!< Bit mask for SNVS_HPSVSR_ZMK_ECC_FAIL.

//! @brief Get value of SNVS_HPSVSR_ZMK_ECC_FAIL from a register value.
#define BG_SNVS_HPSVSR_ZMK_ECC_FAIL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPSVSR_ZMK_ECC_FAIL) >> BP_SNVS_HPSVSR_ZMK_ECC_FAIL)

//! @brief Format value for bitfield SNVS_HPSVSR_ZMK_ECC_FAIL.
#define BF_SNVS_HPSVSR_ZMK_ECC_FAIL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPSVSR_ZMK_ECC_FAIL) & BM_SNVS_HPSVSR_ZMK_ECC_FAIL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_ECC_FAIL field to a new value.
#define BW_SNVS_HPSVSR_ZMK_ECC_FAIL(v)   (HW_SNVS_HPSVSR_WR((HW_SNVS_HPSVSR_RD() & ~BM_SNVS_HPSVSR_ZMK_ECC_FAIL) | BF_SNVS_HPSVSR_ZMK_ECC_FAIL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPHACIVR - SNVS _HP High Assurance Counter IV Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPHACIVR - SNVS _HP High Assurance Counter IV Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP High Assurance Counter IV Register contains the initial value for the high assurance
 * counter.
 */
typedef union _hw_snvs_hphacivr
{
    reg32_t U;
    struct _hw_snvs_hphacivr_bitfields
    {
        unsigned HAC_COUNTER_IV : 32; //!< [31:0] High Assurance Counter Initial Value
    } B;
} hw_snvs_hphacivr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPHACIVR register
 */
//@{
#define HW_SNVS_HPHACIVR_ADDR      (REGS_SNVS_BASE + 0x1c)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPHACIVR           (*(volatile hw_snvs_hphacivr_t *) HW_SNVS_HPHACIVR_ADDR)
#define HW_SNVS_HPHACIVR_RD()      (HW_SNVS_HPHACIVR.U)
#define HW_SNVS_HPHACIVR_WR(v)     (HW_SNVS_HPHACIVR.U = (v))
#define HW_SNVS_HPHACIVR_SET(v)    (HW_SNVS_HPHACIVR_WR(HW_SNVS_HPHACIVR_RD() |  (v)))
#define HW_SNVS_HPHACIVR_CLR(v)    (HW_SNVS_HPHACIVR_WR(HW_SNVS_HPHACIVR_RD() & ~(v)))
#define HW_SNVS_HPHACIVR_TOG(v)    (HW_SNVS_HPHACIVR_WR(HW_SNVS_HPHACIVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPHACIVR bitfields
 */

/*! @name Register SNVS_HPHACIVR, field HAC_COUNTER_IV[31:0] (RW)
 *
 * High Assurance Counter Initial Value This register is used to set the starting count value to the
 * high assurance counter. This register cannot be programmed when HAC_L bit is set.
 */
//@{
#define BP_SNVS_HPHACIVR_HAC_COUNTER_IV      (0)      //!< Bit position for SNVS_HPHACIVR_HAC_COUNTER_IV.
#define BM_SNVS_HPHACIVR_HAC_COUNTER_IV      (0xffffffff)  //!< Bit mask for SNVS_HPHACIVR_HAC_COUNTER_IV.

//! @brief Get value of SNVS_HPHACIVR_HAC_COUNTER_IV from a register value.
#define BG_SNVS_HPHACIVR_HAC_COUNTER_IV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPHACIVR_HAC_COUNTER_IV) >> BP_SNVS_HPHACIVR_HAC_COUNTER_IV)

//! @brief Format value for bitfield SNVS_HPHACIVR_HAC_COUNTER_IV.
#define BF_SNVS_HPHACIVR_HAC_COUNTER_IV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPHACIVR_HAC_COUNTER_IV) & BM_SNVS_HPHACIVR_HAC_COUNTER_IV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAC_COUNTER_IV field to a new value.
#define BW_SNVS_HPHACIVR_HAC_COUNTER_IV(v)   (HW_SNVS_HPHACIVR_WR((HW_SNVS_HPHACIVR_RD() & ~BM_SNVS_HPHACIVR_HAC_COUNTER_IV) | BF_SNVS_HPHACIVR_HAC_COUNTER_IV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPHACR - SNVS _HP High Assurance Counter Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPHACR - SNVS _HP High Assurance Counter Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP High Assurance Counter Register contains the value of the high assurance counter.
 * The high assurance counter is a delay introduced before the system security monitor transitions
 * from soft fail to hard fail state if this transition is enabled.
 */
typedef union _hw_snvs_hphacr
{
    reg32_t U;
    struct _hw_snvs_hphacr_bitfields
    {
        unsigned HAC_COUNTER : 32; //!< [31:0] High Assurance Counter
    } B;
} hw_snvs_hphacr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPHACR register
 */
//@{
#define HW_SNVS_HPHACR_ADDR      (REGS_SNVS_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPHACR           (*(volatile hw_snvs_hphacr_t *) HW_SNVS_HPHACR_ADDR)
#define HW_SNVS_HPHACR_RD()      (HW_SNVS_HPHACR.U)
#define HW_SNVS_HPHACR_WR(v)     (HW_SNVS_HPHACR.U = (v))
#define HW_SNVS_HPHACR_SET(v)    (HW_SNVS_HPHACR_WR(HW_SNVS_HPHACR_RD() |  (v)))
#define HW_SNVS_HPHACR_CLR(v)    (HW_SNVS_HPHACR_WR(HW_SNVS_HPHACR_RD() & ~(v)))
#define HW_SNVS_HPHACR_TOG(v)    (HW_SNVS_HPHACR_WR(HW_SNVS_HPHACR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPHACR bitfields
 */

/*! @name Register SNVS_HPHACR, field HAC_COUNTER[31:0] (RW)
 *
 * High Assurance Counter When the HAC_EN bit is set and the SSM is in the soft fail state, this
 * counter starts to count down with the system clock. When the counter reaches zero, the SSM
 * transitions to the Hard Fail State. When HAC_STOP bit is set, the HAC Counter is stopped. When
 * HAC_CLEAR bit is set, the HAC Counter is cleared. When HAC_LOAD bit is set, the HAC Counter is
 * loaded with the value of the HPHACIVR.
 */
//@{
#define BP_SNVS_HPHACR_HAC_COUNTER      (0)      //!< Bit position for SNVS_HPHACR_HAC_COUNTER.
#define BM_SNVS_HPHACR_HAC_COUNTER      (0xffffffff)  //!< Bit mask for SNVS_HPHACR_HAC_COUNTER.

//! @brief Get value of SNVS_HPHACR_HAC_COUNTER from a register value.
#define BG_SNVS_HPHACR_HAC_COUNTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPHACR_HAC_COUNTER) >> BP_SNVS_HPHACR_HAC_COUNTER)

//! @brief Format value for bitfield SNVS_HPHACR_HAC_COUNTER.
#define BF_SNVS_HPHACR_HAC_COUNTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPHACR_HAC_COUNTER) & BM_SNVS_HPHACR_HAC_COUNTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAC_COUNTER field to a new value.
#define BW_SNVS_HPHACR_HAC_COUNTER(v)   (HW_SNVS_HPHACR_WR((HW_SNVS_HPHACR_RD() & ~BM_SNVS_HPHACR_HAC_COUNTER) | BF_SNVS_HPHACR_HAC_COUNTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPRTCMR - SNVS_HP Real Time Counter MSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPRTCMR - SNVS_HP Real Time Counter MSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Real Time Counter MSB register contains the most significant bits of the HP Real
 * Time Counter.
 */
typedef union _hw_snvs_hprtcmr
{
    reg32_t U;
    struct _hw_snvs_hprtcmr_bitfields
    {
        unsigned RTC : 15; //!< [14:0] HP Real Time Counter
        unsigned RESERVED0 : 17; //!< [31:15] Reserved
    } B;
} hw_snvs_hprtcmr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPRTCMR register
 */
//@{
#define HW_SNVS_HPRTCMR_ADDR      (REGS_SNVS_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPRTCMR           (*(volatile hw_snvs_hprtcmr_t *) HW_SNVS_HPRTCMR_ADDR)
#define HW_SNVS_HPRTCMR_RD()      (HW_SNVS_HPRTCMR.U)
#define HW_SNVS_HPRTCMR_WR(v)     (HW_SNVS_HPRTCMR.U = (v))
#define HW_SNVS_HPRTCMR_SET(v)    (HW_SNVS_HPRTCMR_WR(HW_SNVS_HPRTCMR_RD() |  (v)))
#define HW_SNVS_HPRTCMR_CLR(v)    (HW_SNVS_HPRTCMR_WR(HW_SNVS_HPRTCMR_RD() & ~(v)))
#define HW_SNVS_HPRTCMR_TOG(v)    (HW_SNVS_HPRTCMR_WR(HW_SNVS_HPRTCMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPRTCMR bitfields
 */

/*! @name Register SNVS_HPRTCMR, field RTC[14:0] (RW)
 *
 * HP Real Time Counter Most significant 15 bits. This register can be programmed only when RTC is
 * not active (RTC_EN bit is not set).
 */
//@{
#define BP_SNVS_HPRTCMR_RTC      (0)      //!< Bit position for SNVS_HPRTCMR_RTC.
#define BM_SNVS_HPRTCMR_RTC      (0x00007fff)  //!< Bit mask for SNVS_HPRTCMR_RTC.

//! @brief Get value of SNVS_HPRTCMR_RTC from a register value.
#define BG_SNVS_HPRTCMR_RTC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPRTCMR_RTC) >> BP_SNVS_HPRTCMR_RTC)

//! @brief Format value for bitfield SNVS_HPRTCMR_RTC.
#define BF_SNVS_HPRTCMR_RTC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPRTCMR_RTC) & BM_SNVS_HPRTCMR_RTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTC field to a new value.
#define BW_SNVS_HPRTCMR_RTC(v)   (HW_SNVS_HPRTCMR_WR((HW_SNVS_HPRTCMR_RD() & ~BM_SNVS_HPRTCMR_RTC) | BF_SNVS_HPRTCMR_RTC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPRTCLR - SNVS_HP Real Time Counter LSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPRTCLR - SNVS_HP Real Time Counter LSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Real Time Counter LSB register contains the 32 least significant bits of the HP real
 * time counter.
 */
typedef union _hw_snvs_hprtclr
{
    reg32_t U;
    struct _hw_snvs_hprtclr_bitfields
    {
        unsigned RTC : 32; //!< [31:0] HP Real Time Counter
    } B;
} hw_snvs_hprtclr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPRTCLR register
 */
//@{
#define HW_SNVS_HPRTCLR_ADDR      (REGS_SNVS_BASE + 0x28)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPRTCLR           (*(volatile hw_snvs_hprtclr_t *) HW_SNVS_HPRTCLR_ADDR)
#define HW_SNVS_HPRTCLR_RD()      (HW_SNVS_HPRTCLR.U)
#define HW_SNVS_HPRTCLR_WR(v)     (HW_SNVS_HPRTCLR.U = (v))
#define HW_SNVS_HPRTCLR_SET(v)    (HW_SNVS_HPRTCLR_WR(HW_SNVS_HPRTCLR_RD() |  (v)))
#define HW_SNVS_HPRTCLR_CLR(v)    (HW_SNVS_HPRTCLR_WR(HW_SNVS_HPRTCLR_RD() & ~(v)))
#define HW_SNVS_HPRTCLR_TOG(v)    (HW_SNVS_HPRTCLR_WR(HW_SNVS_HPRTCLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPRTCLR bitfields
 */

/*! @name Register SNVS_HPRTCLR, field RTC[31:0] (RW)
 *
 * HP Real Time Counter Least significant 32 bits. This register can be programmed only when RTC is
 * not active (RTC_EN bit is not set).
 */
//@{
#define BP_SNVS_HPRTCLR_RTC      (0)      //!< Bit position for SNVS_HPRTCLR_RTC.
#define BM_SNVS_HPRTCLR_RTC      (0xffffffff)  //!< Bit mask for SNVS_HPRTCLR_RTC.

//! @brief Get value of SNVS_HPRTCLR_RTC from a register value.
#define BG_SNVS_HPRTCLR_RTC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPRTCLR_RTC) >> BP_SNVS_HPRTCLR_RTC)

//! @brief Format value for bitfield SNVS_HPRTCLR_RTC.
#define BF_SNVS_HPRTCLR_RTC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPRTCLR_RTC) & BM_SNVS_HPRTCLR_RTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTC field to a new value.
#define BW_SNVS_HPRTCLR_RTC(v)   (HW_SNVS_HPRTCLR_WR((HW_SNVS_HPRTCLR_RD() & ~BM_SNVS_HPRTCLR_RTC) | BF_SNVS_HPRTCLR_RTC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPTAMR - SNVS_HP Time Alarm MSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPTAMR - SNVS_HP Time Alarm MSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Time Alarm MSB register contains the most significant bits of the SNVS _HP Time
 * Alarm value.
 */
typedef union _hw_snvs_hptamr
{
    reg32_t U;
    struct _hw_snvs_hptamr_bitfields
    {
        unsigned HPTA : 15; //!< [14:0] HP Time Alarm
        unsigned RESERVED0 : 17; //!< [31:15] Reserved
    } B;
} hw_snvs_hptamr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPTAMR register
 */
//@{
#define HW_SNVS_HPTAMR_ADDR      (REGS_SNVS_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPTAMR           (*(volatile hw_snvs_hptamr_t *) HW_SNVS_HPTAMR_ADDR)
#define HW_SNVS_HPTAMR_RD()      (HW_SNVS_HPTAMR.U)
#define HW_SNVS_HPTAMR_WR(v)     (HW_SNVS_HPTAMR.U = (v))
#define HW_SNVS_HPTAMR_SET(v)    (HW_SNVS_HPTAMR_WR(HW_SNVS_HPTAMR_RD() |  (v)))
#define HW_SNVS_HPTAMR_CLR(v)    (HW_SNVS_HPTAMR_WR(HW_SNVS_HPTAMR_RD() & ~(v)))
#define HW_SNVS_HPTAMR_TOG(v)    (HW_SNVS_HPTAMR_WR(HW_SNVS_HPTAMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPTAMR bitfields
 */

/*! @name Register SNVS_HPTAMR, field HPTA[14:0] (RW)
 *
 * HP Time Alarm Most significant 15 bits. This register can be programmed only when HP time alarm
 * is disabled (HPTA_EN bit is not set).
 */
//@{
#define BP_SNVS_HPTAMR_HPTA      (0)      //!< Bit position for SNVS_HPTAMR_HPTA.
#define BM_SNVS_HPTAMR_HPTA      (0x00007fff)  //!< Bit mask for SNVS_HPTAMR_HPTA.

//! @brief Get value of SNVS_HPTAMR_HPTA from a register value.
#define BG_SNVS_HPTAMR_HPTA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPTAMR_HPTA) >> BP_SNVS_HPTAMR_HPTA)

//! @brief Format value for bitfield SNVS_HPTAMR_HPTA.
#define BF_SNVS_HPTAMR_HPTA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPTAMR_HPTA) & BM_SNVS_HPTAMR_HPTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPTA field to a new value.
#define BW_SNVS_HPTAMR_HPTA(v)   (HW_SNVS_HPTAMR_WR((HW_SNVS_HPTAMR_RD() & ~BM_SNVS_HPTAMR_HPTA) | BF_SNVS_HPTAMR_HPTA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPTALR - SNVS_HP Time Alarm LSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPTALR - SNVS_HP Time Alarm LSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Time Alarm LSB register contains the 32 least significant bits of the SNVS _HP Time
 * Alarm value.
 */
typedef union _hw_snvs_hptalr
{
    reg32_t U;
    struct _hw_snvs_hptalr_bitfields
    {
        unsigned HPTA : 32; //!< [31:0] HP Time Alarm
    } B;
} hw_snvs_hptalr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPTALR register
 */
//@{
#define HW_SNVS_HPTALR_ADDR      (REGS_SNVS_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPTALR           (*(volatile hw_snvs_hptalr_t *) HW_SNVS_HPTALR_ADDR)
#define HW_SNVS_HPTALR_RD()      (HW_SNVS_HPTALR.U)
#define HW_SNVS_HPTALR_WR(v)     (HW_SNVS_HPTALR.U = (v))
#define HW_SNVS_HPTALR_SET(v)    (HW_SNVS_HPTALR_WR(HW_SNVS_HPTALR_RD() |  (v)))
#define HW_SNVS_HPTALR_CLR(v)    (HW_SNVS_HPTALR_WR(HW_SNVS_HPTALR_RD() & ~(v)))
#define HW_SNVS_HPTALR_TOG(v)    (HW_SNVS_HPTALR_WR(HW_SNVS_HPTALR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_HPTALR bitfields
 */

/*! @name Register SNVS_HPTALR, field HPTA[31:0] (RW)
 *
 * HP Time Alarm Least significant bits. This register can be programmed only when HP time alarm is
 * disabled (HPTA_EN bit is not set).
 */
//@{
#define BP_SNVS_HPTALR_HPTA      (0)      //!< Bit position for SNVS_HPTALR_HPTA.
#define BM_SNVS_HPTALR_HPTA      (0xffffffff)  //!< Bit mask for SNVS_HPTALR_HPTA.

//! @brief Get value of SNVS_HPTALR_HPTA from a register value.
#define BG_SNVS_HPTALR_HPTA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPTALR_HPTA) >> BP_SNVS_HPTALR_HPTA)

//! @brief Format value for bitfield SNVS_HPTALR_HPTA.
#define BF_SNVS_HPTALR_HPTA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_HPTALR_HPTA) & BM_SNVS_HPTALR_HPTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPTA field to a new value.
#define BW_SNVS_HPTALR_HPTA(v)   (HW_SNVS_HPTALR_WR((HW_SNVS_HPTALR_RD() & ~BM_SNVS_HPTALR_HPTA) | BF_SNVS_HPTALR_HPTA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPLR - SNVS _LP Lock Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPLR - SNVS _LP Lock Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Lock Register contains lock bits for the SNVS _LP registers.
 */
typedef union _hw_snvs_lplr
{
    reg32_t U;
    struct _hw_snvs_lplr_bitfields
    {
        unsigned ZMK_WHL : 1; //!< [0] Zeroizable Master Key Write Hard Lock
        unsigned ZMK_RHL : 1; //!< [1] Zeroizable Master Key Read Hard Lock
        unsigned SRTC_HL : 1; //!< [2] Secure Real Time Counter Hard Lock
        unsigned LPCALB_HL : 1; //!< [3] LP Calibration Hard Lock
        unsigned MC_HL : 1; //!< [4] Monotonic Counter Hard Lock
        unsigned GPR_HL : 1; //!< [5] General Purpose Register Hard Lock
        unsigned LPSVCR_HL : 1; //!< [6] LP Security Violation Control Register Hard Lock
        unsigned LPTGFCR_HL : 1; //!< [7] LP Tamper Glitch Filter Configuration Register Hard Lock
        unsigned LPTDCR_HL : 1; //!< [8] LP Tamper Detectors Configuration Register Hard Lock
        unsigned MKS_HL : 1; //!< [9] Master Key Select Hard Lock
        unsigned RESERVED0 : 22; //!< [31:10] Reserved
    } B;
} hw_snvs_lplr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPLR register
 */
//@{
#define HW_SNVS_LPLR_ADDR      (REGS_SNVS_BASE + 0x34)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPLR           (*(volatile hw_snvs_lplr_t *) HW_SNVS_LPLR_ADDR)
#define HW_SNVS_LPLR_RD()      (HW_SNVS_LPLR.U)
#define HW_SNVS_LPLR_WR(v)     (HW_SNVS_LPLR.U = (v))
#define HW_SNVS_LPLR_SET(v)    (HW_SNVS_LPLR_WR(HW_SNVS_LPLR_RD() |  (v)))
#define HW_SNVS_LPLR_CLR(v)    (HW_SNVS_LPLR_WR(HW_SNVS_LPLR_RD() & ~(v)))
#define HW_SNVS_LPLR_TOG(v)    (HW_SNVS_LPLR_WR(HW_SNVS_LPLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPLR bitfields
 */

/*! @name Register SNVS_LPLR, field ZMK_WHL[0] (RW)
 *
 * Zeroizable Master Key Write Hard Lock When set, prevents any writes (software and hardware) to
 * the ZMK registers and ZMK_HWP, ZMK_VAL, and ZMK_ECC_EN fields of the LPMKCR. Once set, this bit
 * can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_ZMK_WHL      (0)      //!< Bit position for SNVS_LPLR_ZMK_WHL.
#define BM_SNVS_LPLR_ZMK_WHL      (0x00000001)  //!< Bit mask for SNVS_LPLR_ZMK_WHL.

//! @brief Get value of SNVS_LPLR_ZMK_WHL from a register value.
#define BG_SNVS_LPLR_ZMK_WHL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_ZMK_WHL) >> BP_SNVS_LPLR_ZMK_WHL)

//! @brief Format value for bitfield SNVS_LPLR_ZMK_WHL.
#define BF_SNVS_LPLR_ZMK_WHL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_ZMK_WHL) & BM_SNVS_LPLR_ZMK_WHL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_WHL field to a new value.
#define BW_SNVS_LPLR_ZMK_WHL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_ZMK_WHL) | BF_SNVS_LPLR_ZMK_WHL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field ZMK_RHL[1] (RW)
 *
 * Zeroizable Master Key Read Hard Lock When set, prevents any software reads to the ZMK registers
 * and ZMK_ECC_VALUE field of the LPMKCR. In ZMK hardware programming mode (ZMK_HWP is set),
 * software cannot read the ZMK or ZMK_ECC_VALUE. Regardless of the setting of this bit, hardware
 * can use the ZMK value when ZMK is selected. Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Read access is allowed (only in software programming mode).
 * - 1 - Read access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_ZMK_RHL      (1)      //!< Bit position for SNVS_LPLR_ZMK_RHL.
#define BM_SNVS_LPLR_ZMK_RHL      (0x00000002)  //!< Bit mask for SNVS_LPLR_ZMK_RHL.

//! @brief Get value of SNVS_LPLR_ZMK_RHL from a register value.
#define BG_SNVS_LPLR_ZMK_RHL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_ZMK_RHL) >> BP_SNVS_LPLR_ZMK_RHL)

//! @brief Format value for bitfield SNVS_LPLR_ZMK_RHL.
#define BF_SNVS_LPLR_ZMK_RHL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_ZMK_RHL) & BM_SNVS_LPLR_ZMK_RHL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_RHL field to a new value.
#define BW_SNVS_LPLR_ZMK_RHL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_ZMK_RHL) | BF_SNVS_LPLR_ZMK_RHL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field SRTC_HL[2] (RW)
 *
 * Secure Real Time Counter Hard Lock When set, prevents any writes to the SRTC registers, SRTC_ENV,
 * and SRTC_INV_EN bits. Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_SRTC_HL      (2)      //!< Bit position for SNVS_LPLR_SRTC_HL.
#define BM_SNVS_LPLR_SRTC_HL      (0x00000004)  //!< Bit mask for SNVS_LPLR_SRTC_HL.

//! @brief Get value of SNVS_LPLR_SRTC_HL from a register value.
#define BG_SNVS_LPLR_SRTC_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_SRTC_HL) >> BP_SNVS_LPLR_SRTC_HL)

//! @brief Format value for bitfield SNVS_LPLR_SRTC_HL.
#define BF_SNVS_LPLR_SRTC_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_SRTC_HL) & BM_SNVS_LPLR_SRTC_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC_HL field to a new value.
#define BW_SNVS_LPLR_SRTC_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_SRTC_HL) | BF_SNVS_LPLR_SRTC_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field LPCALB_HL[3] (RW)
 *
 * LP Calibration Hard Lock When set, prevents any writes to the LP Calibration Value (LPCALB_VAL)
 * and LP Calibration Enable (LPCALB_EN). Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_LPCALB_HL      (3)      //!< Bit position for SNVS_LPLR_LPCALB_HL.
#define BM_SNVS_LPLR_LPCALB_HL      (0x00000008)  //!< Bit mask for SNVS_LPLR_LPCALB_HL.

//! @brief Get value of SNVS_LPLR_LPCALB_HL from a register value.
#define BG_SNVS_LPLR_LPCALB_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_LPCALB_HL) >> BP_SNVS_LPLR_LPCALB_HL)

//! @brief Format value for bitfield SNVS_LPLR_LPCALB_HL.
#define BF_SNVS_LPLR_LPCALB_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_LPCALB_HL) & BM_SNVS_LPLR_LPCALB_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPCALB_HL field to a new value.
#define BW_SNVS_LPLR_LPCALB_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_LPCALB_HL) | BF_SNVS_LPLR_LPCALB_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field MC_HL[4] (RW)
 *
 * Monotonic Counter Hard Lock When set, prevents any writes (increments) to the MC Registers and
 * MC_ENV bit. Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access (increment) is allowed.
 * - 1 - Write access (increment) is not allowed.
 */
//@{
#define BP_SNVS_LPLR_MC_HL      (4)      //!< Bit position for SNVS_LPLR_MC_HL.
#define BM_SNVS_LPLR_MC_HL      (0x00000010)  //!< Bit mask for SNVS_LPLR_MC_HL.

//! @brief Get value of SNVS_LPLR_MC_HL from a register value.
#define BG_SNVS_LPLR_MC_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_MC_HL) >> BP_SNVS_LPLR_MC_HL)

//! @brief Format value for bitfield SNVS_LPLR_MC_HL.
#define BF_SNVS_LPLR_MC_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_MC_HL) & BM_SNVS_LPLR_MC_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MC_HL field to a new value.
#define BW_SNVS_LPLR_MC_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_MC_HL) | BF_SNVS_LPLR_MC_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field GPR_HL[5] (RW)
 *
 * General Purpose Register Hard Lock When set, prevents any writes to the GPR. Once set, this bit
 * can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_GPR_HL      (5)      //!< Bit position for SNVS_LPLR_GPR_HL.
#define BM_SNVS_LPLR_GPR_HL      (0x00000020)  //!< Bit mask for SNVS_LPLR_GPR_HL.

//! @brief Get value of SNVS_LPLR_GPR_HL from a register value.
#define BG_SNVS_LPLR_GPR_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_GPR_HL) >> BP_SNVS_LPLR_GPR_HL)

//! @brief Format value for bitfield SNVS_LPLR_GPR_HL.
#define BF_SNVS_LPLR_GPR_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_GPR_HL) & BM_SNVS_LPLR_GPR_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GPR_HL field to a new value.
#define BW_SNVS_LPLR_GPR_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_GPR_HL) | BF_SNVS_LPLR_GPR_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field LPSVCR_HL[6] (RW)
 *
 * LP Security Violation Control Register Hard Lock When set, prevents any writes to the LPSVCR.
 * Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_LPSVCR_HL      (6)      //!< Bit position for SNVS_LPLR_LPSVCR_HL.
#define BM_SNVS_LPLR_LPSVCR_HL      (0x00000040)  //!< Bit mask for SNVS_LPLR_LPSVCR_HL.

//! @brief Get value of SNVS_LPLR_LPSVCR_HL from a register value.
#define BG_SNVS_LPLR_LPSVCR_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_LPSVCR_HL) >> BP_SNVS_LPLR_LPSVCR_HL)

//! @brief Format value for bitfield SNVS_LPLR_LPSVCR_HL.
#define BF_SNVS_LPLR_LPSVCR_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_LPSVCR_HL) & BM_SNVS_LPLR_LPSVCR_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPSVCR_HL field to a new value.
#define BW_SNVS_LPLR_LPSVCR_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_LPSVCR_HL) | BF_SNVS_LPLR_LPSVCR_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field LPTGFCR_HL[7] (RW)
 *
 * LP Tamper Glitch Filter Configuration Register Hard Lock When set, prevents any writes to the
 * LPTGFCR. Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_LPTGFCR_HL      (7)      //!< Bit position for SNVS_LPLR_LPTGFCR_HL.
#define BM_SNVS_LPLR_LPTGFCR_HL      (0x00000080)  //!< Bit mask for SNVS_LPLR_LPTGFCR_HL.

//! @brief Get value of SNVS_LPLR_LPTGFCR_HL from a register value.
#define BG_SNVS_LPLR_LPTGFCR_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_LPTGFCR_HL) >> BP_SNVS_LPLR_LPTGFCR_HL)

//! @brief Format value for bitfield SNVS_LPLR_LPTGFCR_HL.
#define BF_SNVS_LPLR_LPTGFCR_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_LPTGFCR_HL) & BM_SNVS_LPLR_LPTGFCR_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTGFCR_HL field to a new value.
#define BW_SNVS_LPLR_LPTGFCR_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_LPTGFCR_HL) | BF_SNVS_LPLR_LPTGFCR_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field LPTDCR_HL[8] (RW)
 *
 * LP Tamper Detectors Configuration Register Hard Lock When set, prevents any writes to the LPTDCR.
 * Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_LPTDCR_HL      (8)      //!< Bit position for SNVS_LPLR_LPTDCR_HL.
#define BM_SNVS_LPLR_LPTDCR_HL      (0x00000100)  //!< Bit mask for SNVS_LPLR_LPTDCR_HL.

//! @brief Get value of SNVS_LPLR_LPTDCR_HL from a register value.
#define BG_SNVS_LPLR_LPTDCR_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_LPTDCR_HL) >> BP_SNVS_LPLR_LPTDCR_HL)

//! @brief Format value for bitfield SNVS_LPLR_LPTDCR_HL.
#define BF_SNVS_LPLR_LPTDCR_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_LPTDCR_HL) & BM_SNVS_LPLR_LPTDCR_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTDCR_HL field to a new value.
#define BW_SNVS_LPLR_LPTDCR_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_LPTDCR_HL) | BF_SNVS_LPLR_LPTDCR_HL(v)))
#endif
//@}

/*! @name Register SNVS_LPLR, field MKS_HL[9] (RW)
 *
 * Master Key Select Hard Lock When set, prevents any writes to the MASTER_KEY_SEL field of the LP
 * Master Key Control Register. Once set, this bit can only be reset by the LP POR.
 *
 * Values:
 * - 0 - Write access is allowed.
 * - 1 - Write access is not allowed.
 */
//@{
#define BP_SNVS_LPLR_MKS_HL      (9)      //!< Bit position for SNVS_LPLR_MKS_HL.
#define BM_SNVS_LPLR_MKS_HL      (0x00000200)  //!< Bit mask for SNVS_LPLR_MKS_HL.

//! @brief Get value of SNVS_LPLR_MKS_HL from a register value.
#define BG_SNVS_LPLR_MKS_HL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPLR_MKS_HL) >> BP_SNVS_LPLR_MKS_HL)

//! @brief Format value for bitfield SNVS_LPLR_MKS_HL.
#define BF_SNVS_LPLR_MKS_HL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPLR_MKS_HL) & BM_SNVS_LPLR_MKS_HL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MKS_HL field to a new value.
#define BW_SNVS_LPLR_MKS_HL(v)   (HW_SNVS_LPLR_WR((HW_SNVS_LPLR_RD() & ~BM_SNVS_LPLR_MKS_HL) | BF_SNVS_LPLR_MKS_HL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPCR - SNVS_LP Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPCR - SNVS_LP Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Control Register contains various control bits of the LP section of SNVS .
 */
typedef union _hw_snvs_lpcr
{
    reg32_t U;
    struct _hw_snvs_lpcr_bitfields
    {
        unsigned SRTC_ENV : 1; //!< [0] Secure Real Time Counter Enable and Valid
        unsigned LPTA_EN : 1; //!< [1] LP Time Alarm Enable
        unsigned MC_ENV : 1; //!< [2] Monotonic Counter Enable and Valid
        unsigned LPWUI_EN : 1; //!< [3] LP Wake-Up Interrupt Enable
        unsigned SRTC_INV_EN : 1; //!< [4] Secure Real Time Counter Invalidation Enable
        unsigned DP_EN : 1; //!< [5] Dumb PMIC Enabled
        unsigned TOP : 1; //!< [6] Turn of System Power
        unsigned RESERVED0 : 1; //!< [7] Reserved
        unsigned LPCALB_EN : 1; //!< [8] LP Calibration Enable
        unsigned RESERVED1 : 1; //!< [9] Reserved
        unsigned LPCALB_VAL : 5; //!< [14:10] LP Calibration Value
        unsigned RESERVED2 : 17; //!< [31:15] Reserved
    } B;
} hw_snvs_lpcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPCR register
 */
//@{
#define HW_SNVS_LPCR_ADDR      (REGS_SNVS_BASE + 0x38)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPCR           (*(volatile hw_snvs_lpcr_t *) HW_SNVS_LPCR_ADDR)
#define HW_SNVS_LPCR_RD()      (HW_SNVS_LPCR.U)
#define HW_SNVS_LPCR_WR(v)     (HW_SNVS_LPCR.U = (v))
#define HW_SNVS_LPCR_SET(v)    (HW_SNVS_LPCR_WR(HW_SNVS_LPCR_RD() |  (v)))
#define HW_SNVS_LPCR_CLR(v)    (HW_SNVS_LPCR_WR(HW_SNVS_LPCR_RD() & ~(v)))
#define HW_SNVS_LPCR_TOG(v)    (HW_SNVS_LPCR_WR(HW_SNVS_LPCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPCR bitfields
 */

/*! @name Register SNVS_LPCR, field SRTC_ENV[0] (RW)
 *
 * Secure Real Time Counter Enable and Valid When set, the SRTC becomes operational. This bit cannot
 * be changed once SRTC_SL or SRTC_HL bit is set.
 *
 * Values:
 * - 0 - SRTC is disabled or invalid.
 * - 1 - SRTC is enabled and valid.
 */
//@{
#define BP_SNVS_LPCR_SRTC_ENV      (0)      //!< Bit position for SNVS_LPCR_SRTC_ENV.
#define BM_SNVS_LPCR_SRTC_ENV      (0x00000001)  //!< Bit mask for SNVS_LPCR_SRTC_ENV.

//! @brief Get value of SNVS_LPCR_SRTC_ENV from a register value.
#define BG_SNVS_LPCR_SRTC_ENV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_SRTC_ENV) >> BP_SNVS_LPCR_SRTC_ENV)

//! @brief Format value for bitfield SNVS_LPCR_SRTC_ENV.
#define BF_SNVS_LPCR_SRTC_ENV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_SRTC_ENV) & BM_SNVS_LPCR_SRTC_ENV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC_ENV field to a new value.
#define BW_SNVS_LPCR_SRTC_ENV(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_SRTC_ENV) | BF_SNVS_LPCR_SRTC_ENV(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field LPTA_EN[1] (RW)
 *
 * LP Time Alarm Enable When set, the SNVS functional interrupt is asserted if the LP Time Alarm
 * Register is equal to the 32 MSBs of the secure real time counter.
 *
 * Values:
 * - 0 - LP time alarm interrupt is disabled.
 * - 1 - LP time alarm interrupt is enabled.
 */
//@{
#define BP_SNVS_LPCR_LPTA_EN      (1)      //!< Bit position for SNVS_LPCR_LPTA_EN.
#define BM_SNVS_LPCR_LPTA_EN      (0x00000002)  //!< Bit mask for SNVS_LPCR_LPTA_EN.

//! @brief Get value of SNVS_LPCR_LPTA_EN from a register value.
#define BG_SNVS_LPCR_LPTA_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_LPTA_EN) >> BP_SNVS_LPCR_LPTA_EN)

//! @brief Format value for bitfield SNVS_LPCR_LPTA_EN.
#define BF_SNVS_LPCR_LPTA_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_LPTA_EN) & BM_SNVS_LPCR_LPTA_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTA_EN field to a new value.
#define BW_SNVS_LPCR_LPTA_EN(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_LPTA_EN) | BF_SNVS_LPCR_LPTA_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field MC_ENV[2] (RW)
 *
 * Monotonic Counter Enable and Valid When set, the MC can be incremented (by write transaction to
 * the LPSMCMR or LPSMCLR). This bit cannot be changed once MC_SL or MC_HL bit is set.
 *
 * Values:
 * - 0 - MC is disabled or invalid.
 * - 1 - MC is enabled and valid.
 */
//@{
#define BP_SNVS_LPCR_MC_ENV      (2)      //!< Bit position for SNVS_LPCR_MC_ENV.
#define BM_SNVS_LPCR_MC_ENV      (0x00000004)  //!< Bit mask for SNVS_LPCR_MC_ENV.

//! @brief Get value of SNVS_LPCR_MC_ENV from a register value.
#define BG_SNVS_LPCR_MC_ENV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_MC_ENV) >> BP_SNVS_LPCR_MC_ENV)

//! @brief Format value for bitfield SNVS_LPCR_MC_ENV.
#define BF_SNVS_LPCR_MC_ENV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_MC_ENV) & BM_SNVS_LPCR_MC_ENV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MC_ENV field to a new value.
#define BW_SNVS_LPCR_MC_ENV(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_MC_ENV) | BF_SNVS_LPCR_MC_ENV(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field LPWUI_EN[3] (RW)
 *
 * LP Wake-Up Interrupt Enable This interrupt line should be connected to the external pin and is
 * intended to inform the external chip about an SNVS _LP event (tamper event, MC rollover, SRTC
 * rollover, or time alarm ). This wake-up signal can be asserted only when the chip (HP section) is
 * powered down, and the LP section is isolated. 0 LP wake-up interrupt is disabled. 1 LP wake-up
 * interrupt is enabled.
 */
//@{
#define BP_SNVS_LPCR_LPWUI_EN      (3)      //!< Bit position for SNVS_LPCR_LPWUI_EN.
#define BM_SNVS_LPCR_LPWUI_EN      (0x00000008)  //!< Bit mask for SNVS_LPCR_LPWUI_EN.

//! @brief Get value of SNVS_LPCR_LPWUI_EN from a register value.
#define BG_SNVS_LPCR_LPWUI_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_LPWUI_EN) >> BP_SNVS_LPCR_LPWUI_EN)

//! @brief Format value for bitfield SNVS_LPCR_LPWUI_EN.
#define BF_SNVS_LPCR_LPWUI_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_LPWUI_EN) & BM_SNVS_LPCR_LPWUI_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPWUI_EN field to a new value.
#define BW_SNVS_LPCR_LPWUI_EN(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_LPWUI_EN) | BF_SNVS_LPCR_LPWUI_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field SRTC_INV_EN[4] (RW)
 *
 * Secure Real Time Counter Invalidation Enable When set, the SRTC is invalidated (SRTC_ENV bit is
 * cleared) in the case of security violation. This field cannot be changed once SRTC_SL or SRTC_HL
 * bit is set.
 *
 * Values:
 * - 0 - SRTC stays valid in the case of security violation.
 * - 1 - SRTC is invalidated in the case of security violation.
 */
//@{
#define BP_SNVS_LPCR_SRTC_INV_EN      (4)      //!< Bit position for SNVS_LPCR_SRTC_INV_EN.
#define BM_SNVS_LPCR_SRTC_INV_EN      (0x00000010)  //!< Bit mask for SNVS_LPCR_SRTC_INV_EN.

//! @brief Get value of SNVS_LPCR_SRTC_INV_EN from a register value.
#define BG_SNVS_LPCR_SRTC_INV_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_SRTC_INV_EN) >> BP_SNVS_LPCR_SRTC_INV_EN)

//! @brief Format value for bitfield SNVS_LPCR_SRTC_INV_EN.
#define BF_SNVS_LPCR_SRTC_INV_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_SRTC_INV_EN) & BM_SNVS_LPCR_SRTC_INV_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC_INV_EN field to a new value.
#define BW_SNVS_LPCR_SRTC_INV_EN(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_SRTC_INV_EN) | BF_SNVS_LPCR_SRTC_INV_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field DP_EN[5] (RW)
 *
 * Dumb PMIC Enabled
 *
 * Values:
 * - 0 - 
 * - 1 - Dumb PMIC enabled.
 */
//@{
#define BP_SNVS_LPCR_DP_EN      (5)      //!< Bit position for SNVS_LPCR_DP_EN.
#define BM_SNVS_LPCR_DP_EN      (0x00000020)  //!< Bit mask for SNVS_LPCR_DP_EN.

//! @brief Get value of SNVS_LPCR_DP_EN from a register value.
#define BG_SNVS_LPCR_DP_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_DP_EN) >> BP_SNVS_LPCR_DP_EN)

//! @brief Format value for bitfield SNVS_LPCR_DP_EN.
#define BF_SNVS_LPCR_DP_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_DP_EN) & BM_SNVS_LPCR_DP_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_EN field to a new value.
#define BW_SNVS_LPCR_DP_EN(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_DP_EN) | BF_SNVS_LPCR_DP_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field TOP[6] (RW)
 *
 * Turn of System Power Asserting this bit causes a signal to be sent to the Power Management IC to
 * turn off the system power. This bit will clear once power is off.
 *
 * Values:
 * - 0 - Leave system power on.
 * - 1 - Turn off system power.
 */
//@{
#define BP_SNVS_LPCR_TOP      (6)      //!< Bit position for SNVS_LPCR_TOP.
#define BM_SNVS_LPCR_TOP      (0x00000040)  //!< Bit mask for SNVS_LPCR_TOP.

//! @brief Get value of SNVS_LPCR_TOP from a register value.
#define BG_SNVS_LPCR_TOP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_TOP) >> BP_SNVS_LPCR_TOP)

//! @brief Format value for bitfield SNVS_LPCR_TOP.
#define BF_SNVS_LPCR_TOP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_TOP) & BM_SNVS_LPCR_TOP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOP field to a new value.
#define BW_SNVS_LPCR_TOP(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_TOP) | BF_SNVS_LPCR_TOP(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field LPCALB_EN[8] (RW)
 *
 * LP Calibration Enable When set, enables the SRTC calibration mechanism. This bit cannot be
 * changed once LPCALB_SL or LPCALB_HL bit is set.
 *
 * Values:
 * - 0 - SRTC Time calibration is disabled.
 * - 1 - SRTC Time calibration is enabled.
 */
//@{
#define BP_SNVS_LPCR_LPCALB_EN      (8)      //!< Bit position for SNVS_LPCR_LPCALB_EN.
#define BM_SNVS_LPCR_LPCALB_EN      (0x00000100)  //!< Bit mask for SNVS_LPCR_LPCALB_EN.

//! @brief Get value of SNVS_LPCR_LPCALB_EN from a register value.
#define BG_SNVS_LPCR_LPCALB_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_LPCALB_EN) >> BP_SNVS_LPCR_LPCALB_EN)

//! @brief Format value for bitfield SNVS_LPCR_LPCALB_EN.
#define BF_SNVS_LPCR_LPCALB_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_LPCALB_EN) & BM_SNVS_LPCR_LPCALB_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPCALB_EN field to a new value.
#define BW_SNVS_LPCR_LPCALB_EN(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_LPCALB_EN) | BF_SNVS_LPCR_LPCALB_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPCR, field LPCALB_VAL[14:10] (RW)
 *
 * LP Calibration Value Defines signed calibration value for SRTC. This field can be programmed only
 * when SRTC calibration is disabled and not locked, i.e. when LPCALB_EN, LPCALB_SL, and LPCALB_HL
 * bits are not set. This is a 5-bit 2's complement value. Hence, the allowable calibration values
 * are in the range from -16 to +15 counts per 32768 ticks of the counter clock
 *
 * Values:
 * - 00000 - +0 counts per each 32768 ticks of the counter clock
 * - 00001 - +1 counts per each 32768 ticks of the counter clock
 * - 00010 - +2 counts per each 32768 ticks of the counter clock
 * - 01111 - +15 counts per each 32768 ticks of the counter clock
 * - 10000 - -16 counts per each 32768 ticks of the counter clock
 * - 10001 - -15 counts per each 32768 ticks of the counter clock
 * - 11110 - -2 counts per each 32768 ticks of the counter clock
 * - 11111 - -1 counts per each 32768 ticks of the counter clock
 */
//@{
#define BP_SNVS_LPCR_LPCALB_VAL      (10)      //!< Bit position for SNVS_LPCR_LPCALB_VAL.
#define BM_SNVS_LPCR_LPCALB_VAL      (0x00007c00)  //!< Bit mask for SNVS_LPCR_LPCALB_VAL.

//! @brief Get value of SNVS_LPCR_LPCALB_VAL from a register value.
#define BG_SNVS_LPCR_LPCALB_VAL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPCR_LPCALB_VAL) >> BP_SNVS_LPCR_LPCALB_VAL)

//! @brief Format value for bitfield SNVS_LPCR_LPCALB_VAL.
#define BF_SNVS_LPCR_LPCALB_VAL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPCR_LPCALB_VAL) & BM_SNVS_LPCR_LPCALB_VAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPCALB_VAL field to a new value.
#define BW_SNVS_LPCR_LPCALB_VAL(v)   (HW_SNVS_LPCR_WR((HW_SNVS_LPCR_RD() & ~BM_SNVS_LPCR_LPCALB_VAL) | BF_SNVS_LPCR_LPCALB_VAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPMKCR - SNVS_LP Master Key Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPMKCR - SNVS_LP Master Key Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Master Key Control Register contains the master keys configuration.
 */
typedef union _hw_snvs_lpmkcr
{
    reg32_t U;
    struct _hw_snvs_lpmkcr_bitfields
    {
        unsigned MASTER_KEY_SEL : 2; //!< [1:0] Master Key Select
        unsigned ZMK_HWP : 1; //!< [2] Zeroizable Master Key hardware Programming mode
        unsigned ZMK_VAL : 1; //!< [3] Zeroizable Master Key Valid
        unsigned ZMK_ECC_EN : 1; //!< [4] Zeroizable Master Key Error Correcting Code Check Enable
        unsigned RESERVED0 : 2; //!< [6:5] Reserved
        unsigned ZMK_ECC_VALUE : 9; //!< [15:7] Zeroizable Master Key Error Correcting Code Value
        unsigned RESERVED1 : 16; //!< [31:16] Reserved
    } B;
} hw_snvs_lpmkcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPMKCR register
 */
//@{
#define HW_SNVS_LPMKCR_ADDR      (REGS_SNVS_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPMKCR           (*(volatile hw_snvs_lpmkcr_t *) HW_SNVS_LPMKCR_ADDR)
#define HW_SNVS_LPMKCR_RD()      (HW_SNVS_LPMKCR.U)
#define HW_SNVS_LPMKCR_WR(v)     (HW_SNVS_LPMKCR.U = (v))
#define HW_SNVS_LPMKCR_SET(v)    (HW_SNVS_LPMKCR_WR(HW_SNVS_LPMKCR_RD() |  (v)))
#define HW_SNVS_LPMKCR_CLR(v)    (HW_SNVS_LPMKCR_WR(HW_SNVS_LPMKCR_RD() & ~(v)))
#define HW_SNVS_LPMKCR_TOG(v)    (HW_SNVS_LPMKCR_WR(HW_SNVS_LPMKCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPMKCR bitfields
 */

/*! @name Register SNVS_LPMKCR, field MASTER_KEY_SEL[1:0] (RW)
 *
 * Master Key Select These bits select the SNVS Master Key output when Master Key Select bits are
 * enabled by MKS_EN bit in the HPCOMR . When MKS_EN bit is not set, the one time programmable
 * master key is selected by default. This field cannot be programmed when MKS_SL (or the hard lock)
 * bit is set.
 *
 * Values:
 * - 0x - Select one time programmable master key.
 * - 10 - Select zeroizable master key when MKS_EN bit is set .
 * - 11 - Select combined master key when MKS_EN bit is set .
 */
//@{
#define BP_SNVS_LPMKCR_MASTER_KEY_SEL      (0)      //!< Bit position for SNVS_LPMKCR_MASTER_KEY_SEL.
#define BM_SNVS_LPMKCR_MASTER_KEY_SEL      (0x00000003)  //!< Bit mask for SNVS_LPMKCR_MASTER_KEY_SEL.

//! @brief Get value of SNVS_LPMKCR_MASTER_KEY_SEL from a register value.
#define BG_SNVS_LPMKCR_MASTER_KEY_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPMKCR_MASTER_KEY_SEL) >> BP_SNVS_LPMKCR_MASTER_KEY_SEL)

//! @brief Format value for bitfield SNVS_LPMKCR_MASTER_KEY_SEL.
#define BF_SNVS_LPMKCR_MASTER_KEY_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPMKCR_MASTER_KEY_SEL) & BM_SNVS_LPMKCR_MASTER_KEY_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASTER_KEY_SEL field to a new value.
#define BW_SNVS_LPMKCR_MASTER_KEY_SEL(v)   (HW_SNVS_LPMKCR_WR((HW_SNVS_LPMKCR_RD() & ~BM_SNVS_LPMKCR_MASTER_KEY_SEL) | BF_SNVS_LPMKCR_MASTER_KEY_SEL(v)))
#endif
//@}

/*! @name Register SNVS_LPMKCR, field ZMK_HWP[2] (RW)
 *
 * Zeroizable Master Key hardware Programming mode When set, only the hardware key programming
 * mechanism can set the ZMK and software cannot read it. When not set, the ZMK can be programmed
 * only by software. See ZMK hardware programming mechanism for details. This bit cannot be
 * programmed when ZMK_WSL or ZMK_WHL bit is set.
 *
 * Values:
 * - 0 - ZMK is in the software programming mode.
 * - 1 - ZMK is in the hardware programming mode.
 */
//@{
#define BP_SNVS_LPMKCR_ZMK_HWP      (2)      //!< Bit position for SNVS_LPMKCR_ZMK_HWP.
#define BM_SNVS_LPMKCR_ZMK_HWP      (0x00000004)  //!< Bit mask for SNVS_LPMKCR_ZMK_HWP.

//! @brief Get value of SNVS_LPMKCR_ZMK_HWP from a register value.
#define BG_SNVS_LPMKCR_ZMK_HWP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPMKCR_ZMK_HWP) >> BP_SNVS_LPMKCR_ZMK_HWP)

//! @brief Format value for bitfield SNVS_LPMKCR_ZMK_HWP.
#define BF_SNVS_LPMKCR_ZMK_HWP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPMKCR_ZMK_HWP) & BM_SNVS_LPMKCR_ZMK_HWP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_HWP field to a new value.
#define BW_SNVS_LPMKCR_ZMK_HWP(v)   (HW_SNVS_LPMKCR_WR((HW_SNVS_LPMKCR_RD() & ~BM_SNVS_LPMKCR_ZMK_HWP) | BF_SNVS_LPMKCR_ZMK_HWP(v)))
#endif
//@}

/*! @name Register SNVS_LPMKCR, field ZMK_VAL[3] (RW)
 *
 * Zeroizable Master Key Valid When set, the ZMK value can be selected by the master key control
 * block for use by cryptographic modules. In hardware programming mode, hardware sets this bit when
 * the ZMK provisioning is complete. In software programming mode, software should set this bit.
 * This bit cannot be programmed when ZMK_WSL or ZMK_WHL bit is set.
 *
 * Values:
 * - 0 - ZMK is not valid.
 * - 1 - ZMK is valid.
 */
//@{
#define BP_SNVS_LPMKCR_ZMK_VAL      (3)      //!< Bit position for SNVS_LPMKCR_ZMK_VAL.
#define BM_SNVS_LPMKCR_ZMK_VAL      (0x00000008)  //!< Bit mask for SNVS_LPMKCR_ZMK_VAL.

//! @brief Get value of SNVS_LPMKCR_ZMK_VAL from a register value.
#define BG_SNVS_LPMKCR_ZMK_VAL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPMKCR_ZMK_VAL) >> BP_SNVS_LPMKCR_ZMK_VAL)

//! @brief Format value for bitfield SNVS_LPMKCR_ZMK_VAL.
#define BF_SNVS_LPMKCR_ZMK_VAL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPMKCR_ZMK_VAL) & BM_SNVS_LPMKCR_ZMK_VAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_VAL field to a new value.
#define BW_SNVS_LPMKCR_ZMK_VAL(v)   (HW_SNVS_LPMKCR_WR((HW_SNVS_LPMKCR_RD() & ~BM_SNVS_LPMKCR_ZMK_VAL) | BF_SNVS_LPMKCR_ZMK_VAL(v)))
#endif
//@}

/*! @name Register SNVS_LPMKCR, field ZMK_ECC_EN[4] (RW)
 *
 * Zeroizable Master Key Error Correcting Code Check Enable Writing one to this field automatically
 * calculates and sets the ZMK ECC value in the ZMK_ECC_VALUE field of this register. When both ZMK
 * value is valid (ZMK_VAL is set) and ZMK ECC check is enabled (ZMK_ECC_EN is set), the ZMK value
 * is continuously checked for the valid ECC word. If the ZMK ECC word calculated every clock cycle
 * does not match the one recorded in this register, the ZMK ECC Check Fail Violation is generated.
 * This bit cannot be programmed when ZMK_WSL or ZMK_WHL bit is set.
 *
 * Values:
 * - 0 - ZMK ECC check is disabled.
 * - 1 - ZMK ECC check is enabled.
 */
//@{
#define BP_SNVS_LPMKCR_ZMK_ECC_EN      (4)      //!< Bit position for SNVS_LPMKCR_ZMK_ECC_EN.
#define BM_SNVS_LPMKCR_ZMK_ECC_EN      (0x00000010)  //!< Bit mask for SNVS_LPMKCR_ZMK_ECC_EN.

//! @brief Get value of SNVS_LPMKCR_ZMK_ECC_EN from a register value.
#define BG_SNVS_LPMKCR_ZMK_ECC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPMKCR_ZMK_ECC_EN) >> BP_SNVS_LPMKCR_ZMK_ECC_EN)

//! @brief Format value for bitfield SNVS_LPMKCR_ZMK_ECC_EN.
#define BF_SNVS_LPMKCR_ZMK_ECC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPMKCR_ZMK_ECC_EN) & BM_SNVS_LPMKCR_ZMK_ECC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK_ECC_EN field to a new value.
#define BW_SNVS_LPMKCR_ZMK_ECC_EN(v)   (HW_SNVS_LPMKCR_WR((HW_SNVS_LPMKCR_RD() & ~BM_SNVS_LPMKCR_ZMK_ECC_EN) | BF_SNVS_LPMKCR_ZMK_ECC_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPMKCR, field ZMK_ECC_VALUE[15:7] (RO)
 *
 * Zeroizable Master Key Error Correcting Code Value This field is automatically calculated and set
 * when one is written into ZMK_ECC_EN bit of this register. This field cannot be programmed by
 * software. It keeps the ECC value of the zeroizable master key, which allows checking that ZMK has
 * not been corrupted/altered with time. Note that this ZMK ECC code is equivalent to the ECC bits
 * encoded into the OTPMK value but for the ZMK, the ECC value is kept separate from the ZMK value.
 * See Error code for the ZMK for details. Read restrictions similar to the ZMK Registers are
 * applied to this field (see LPZMKR SNVS_LP Zeroizable Master Key Register n ).
 */
//@{
#define BP_SNVS_LPMKCR_ZMK_ECC_VALUE      (7)      //!< Bit position for SNVS_LPMKCR_ZMK_ECC_VALUE.
#define BM_SNVS_LPMKCR_ZMK_ECC_VALUE      (0x0000ff80)  //!< Bit mask for SNVS_LPMKCR_ZMK_ECC_VALUE.

//! @brief Get value of SNVS_LPMKCR_ZMK_ECC_VALUE from a register value.
#define BG_SNVS_LPMKCR_ZMK_ECC_VALUE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPMKCR_ZMK_ECC_VALUE) >> BP_SNVS_LPMKCR_ZMK_ECC_VALUE)
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSVCR - SNVS_LP Security Violation Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSVCR - SNVS_LP Security Violation Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The LP Security Violation Control Register configures security violation inputs. This register
 * cannot be programmed when the LPSVCR Lock bit is set. Note that configurations of the security
 * violation inputs in the HP section (HPSVCR) and LP section (LPSVCR Register) are independent and
 * have different functionality.
 */
typedef union _hw_snvs_lpsvcr
{
    reg32_t U;
    struct _hw_snvs_lpsvcr_bitfields
    {
        unsigned SV_EN0 : 1; //!< [0] Security Violation 0 Enable
        unsigned SV_EN1 : 1; //!< [1] Security Violation 1 Enable
        unsigned SV_EN2 : 1; //!< [2] Security Violation 2 Enable
        unsigned SV_EN3 : 1; //!< [3] Security Violation 3 Enable
        unsigned SV_EN4 : 1; //!< [4] Security Violation 4 Enable
        unsigned SV_EN5 : 1; //!< [5] Security Violation 5 Enable
        unsigned RESERVED0 : 26; //!< [31:6] Reserved
    } B;
} hw_snvs_lpsvcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSVCR register
 */
//@{
#define HW_SNVS_LPSVCR_ADDR      (REGS_SNVS_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSVCR           (*(volatile hw_snvs_lpsvcr_t *) HW_SNVS_LPSVCR_ADDR)
#define HW_SNVS_LPSVCR_RD()      (HW_SNVS_LPSVCR.U)
#define HW_SNVS_LPSVCR_WR(v)     (HW_SNVS_LPSVCR.U = (v))
#define HW_SNVS_LPSVCR_SET(v)    (HW_SNVS_LPSVCR_WR(HW_SNVS_LPSVCR_RD() |  (v)))
#define HW_SNVS_LPSVCR_CLR(v)    (HW_SNVS_LPSVCR_WR(HW_SNVS_LPSVCR_RD() & ~(v)))
#define HW_SNVS_LPSVCR_TOG(v)    (HW_SNVS_LPSVCR_WR(HW_SNVS_LPSVCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSVCR bitfields
 */

/*! @name Register SNVS_LPSVCR, field SV_EN0[0] (RW)
 *
 * Security Violation 0 Enable This bit enables security violation input 0. When set, a security
 * violation 0 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 0 is disabled in the LP domain.
 * - 1 - Security Violation 0 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN0      (0)      //!< Bit position for SNVS_LPSVCR_SV_EN0.
#define BM_SNVS_LPSVCR_SV_EN0      (0x00000001)  //!< Bit mask for SNVS_LPSVCR_SV_EN0.

//! @brief Get value of SNVS_LPSVCR_SV_EN0 from a register value.
#define BG_SNVS_LPSVCR_SV_EN0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN0) >> BP_SNVS_LPSVCR_SV_EN0)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN0.
#define BF_SNVS_LPSVCR_SV_EN0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN0) & BM_SNVS_LPSVCR_SV_EN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN0 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN0(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN0) | BF_SNVS_LPSVCR_SV_EN0(v)))
#endif
//@}

/*! @name Register SNVS_LPSVCR, field SV_EN1[1] (RW)
 *
 * Security Violation 1 Enable This bit enables security violation input 1. When set, a security
 * violation 1 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 1 is disabled in the LP domain.
 * - 1 - Security Violation 1 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN1      (1)      //!< Bit position for SNVS_LPSVCR_SV_EN1.
#define BM_SNVS_LPSVCR_SV_EN1      (0x00000002)  //!< Bit mask for SNVS_LPSVCR_SV_EN1.

//! @brief Get value of SNVS_LPSVCR_SV_EN1 from a register value.
#define BG_SNVS_LPSVCR_SV_EN1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN1) >> BP_SNVS_LPSVCR_SV_EN1)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN1.
#define BF_SNVS_LPSVCR_SV_EN1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN1) & BM_SNVS_LPSVCR_SV_EN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN1 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN1(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN1) | BF_SNVS_LPSVCR_SV_EN1(v)))
#endif
//@}

/*! @name Register SNVS_LPSVCR, field SV_EN2[2] (RW)
 *
 * Security Violation 2 Enable This bit enables security violation input 2. When set, a security
 * violation 2 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 2 is disabled in the LP domain.
 * - 1 - Security Violation 2 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN2      (2)      //!< Bit position for SNVS_LPSVCR_SV_EN2.
#define BM_SNVS_LPSVCR_SV_EN2      (0x00000004)  //!< Bit mask for SNVS_LPSVCR_SV_EN2.

//! @brief Get value of SNVS_LPSVCR_SV_EN2 from a register value.
#define BG_SNVS_LPSVCR_SV_EN2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN2) >> BP_SNVS_LPSVCR_SV_EN2)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN2.
#define BF_SNVS_LPSVCR_SV_EN2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN2) & BM_SNVS_LPSVCR_SV_EN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN2 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN2(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN2) | BF_SNVS_LPSVCR_SV_EN2(v)))
#endif
//@}

/*! @name Register SNVS_LPSVCR, field SV_EN3[3] (RW)
 *
 * Security Violation 3 Enable This bit enables security violation input 3. When set, a security
 * violation 3 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 3 is disabled in the LP domain.
 * - 1 - Security Violation 3 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN3      (3)      //!< Bit position for SNVS_LPSVCR_SV_EN3.
#define BM_SNVS_LPSVCR_SV_EN3      (0x00000008)  //!< Bit mask for SNVS_LPSVCR_SV_EN3.

//! @brief Get value of SNVS_LPSVCR_SV_EN3 from a register value.
#define BG_SNVS_LPSVCR_SV_EN3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN3) >> BP_SNVS_LPSVCR_SV_EN3)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN3.
#define BF_SNVS_LPSVCR_SV_EN3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN3) & BM_SNVS_LPSVCR_SV_EN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN3 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN3(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN3) | BF_SNVS_LPSVCR_SV_EN3(v)))
#endif
//@}

/*! @name Register SNVS_LPSVCR, field SV_EN4[4] (RW)
 *
 * Security Violation 4 Enable This bit enables security violation input 4. When set, a security
 * violation 4 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 4 is disabled in the LP domain.
 * - 1 - Security Violation 4 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN4      (4)      //!< Bit position for SNVS_LPSVCR_SV_EN4.
#define BM_SNVS_LPSVCR_SV_EN4      (0x00000010)  //!< Bit mask for SNVS_LPSVCR_SV_EN4.

//! @brief Get value of SNVS_LPSVCR_SV_EN4 from a register value.
#define BG_SNVS_LPSVCR_SV_EN4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN4) >> BP_SNVS_LPSVCR_SV_EN4)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN4.
#define BF_SNVS_LPSVCR_SV_EN4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN4) & BM_SNVS_LPSVCR_SV_EN4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN4 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN4(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN4) | BF_SNVS_LPSVCR_SV_EN4(v)))
#endif
//@}

/*! @name Register SNVS_LPSVCR, field SV_EN5[5] (RW)
 *
 * Security Violation 5 Enable This bit enables security violation input 5. When set, a security
 * violation 5 causes an LP security violation, which clears LP sensitive data.
 *
 * Values:
 * - 0 - Security Violation 5 is disabled in the LP domain.
 * - 1 - Security Violation 5 is enabled in the LP domain.
 */
//@{
#define BP_SNVS_LPSVCR_SV_EN5      (5)      //!< Bit position for SNVS_LPSVCR_SV_EN5.
#define BM_SNVS_LPSVCR_SV_EN5      (0x00000020)  //!< Bit mask for SNVS_LPSVCR_SV_EN5.

//! @brief Get value of SNVS_LPSVCR_SV_EN5 from a register value.
#define BG_SNVS_LPSVCR_SV_EN5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSVCR_SV_EN5) >> BP_SNVS_LPSVCR_SV_EN5)

//! @brief Format value for bitfield SNVS_LPSVCR_SV_EN5.
#define BF_SNVS_LPSVCR_SV_EN5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSVCR_SV_EN5) & BM_SNVS_LPSVCR_SV_EN5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SV_EN5 field to a new value.
#define BW_SNVS_LPSVCR_SV_EN5(v)   (HW_SNVS_LPSVCR_WR((HW_SNVS_LPSVCR_RD() & ~BM_SNVS_LPSVCR_SV_EN5) | BF_SNVS_LPSVCR_SV_EN5(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPTGFCR - SNVS_LP Tamper Glitch Filters Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPTGFCR - SNVS_LP Tamper Glitch Filters Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Tamper Glitch Filters Configuration Register is used to configure the glitch filters
 * for the SNVS _LP tamper inputs. This register cannot be programmed when the LPTGFCR_SL or
 * LPTGFCR_HL bit is set.
 */
typedef union _hw_snvs_lptgfcr
{
    reg32_t U;
    struct _hw_snvs_lptgfcr_bitfields
    {
        unsigned RESERVED0 : 16; //!< [15:0] Reserved.
        unsigned ETGF1 : 5; //!< [20:16] External Tamper Glitch Filter 1
        unsigned RESERVED1 : 2; //!< [22:21] Reserved
        unsigned ETGF1_EN : 1; //!< [23] External Tamper Glitch Filter 1 Enable
        unsigned RESERVED2 : 8; //!< [31:24] Reserved.
    } B;
} hw_snvs_lptgfcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPTGFCR register
 */
//@{
#define HW_SNVS_LPTGFCR_ADDR      (REGS_SNVS_BASE + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPTGFCR           (*(volatile hw_snvs_lptgfcr_t *) HW_SNVS_LPTGFCR_ADDR)
#define HW_SNVS_LPTGFCR_RD()      (HW_SNVS_LPTGFCR.U)
#define HW_SNVS_LPTGFCR_WR(v)     (HW_SNVS_LPTGFCR.U = (v))
#define HW_SNVS_LPTGFCR_SET(v)    (HW_SNVS_LPTGFCR_WR(HW_SNVS_LPTGFCR_RD() |  (v)))
#define HW_SNVS_LPTGFCR_CLR(v)    (HW_SNVS_LPTGFCR_WR(HW_SNVS_LPTGFCR_RD() & ~(v)))
#define HW_SNVS_LPTGFCR_TOG(v)    (HW_SNVS_LPTGFCR_WR(HW_SNVS_LPTGFCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPTGFCR bitfields
 */

/*! @name Register SNVS_LPTGFCR, field ETGF1[20:16] (RW)
 *
 * External Tamper Glitch Filter 1 Configures the length of the digital glitch filter for the
 * external tamper 1 pin between 128 and 8064 SRTC clock cycles. Any assertion on external tamper 1
 * that is equal to or less than the value of the digital glitch filter is ignored. The length of
 * the glitches filtered out is: 128 + (ETGF1 x 256), where ETGF1 = 0, ... , 31
 */
//@{
#define BP_SNVS_LPTGFCR_ETGF1      (16)      //!< Bit position for SNVS_LPTGFCR_ETGF1.
#define BM_SNVS_LPTGFCR_ETGF1      (0x001f0000)  //!< Bit mask for SNVS_LPTGFCR_ETGF1.

//! @brief Get value of SNVS_LPTGFCR_ETGF1 from a register value.
#define BG_SNVS_LPTGFCR_ETGF1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTGFCR_ETGF1) >> BP_SNVS_LPTGFCR_ETGF1)

//! @brief Format value for bitfield SNVS_LPTGFCR_ETGF1.
#define BF_SNVS_LPTGFCR_ETGF1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTGFCR_ETGF1) & BM_SNVS_LPTGFCR_ETGF1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ETGF1 field to a new value.
#define BW_SNVS_LPTGFCR_ETGF1(v)   (HW_SNVS_LPTGFCR_WR((HW_SNVS_LPTGFCR_RD() & ~BM_SNVS_LPTGFCR_ETGF1) | BF_SNVS_LPTGFCR_ETGF1(v)))
#endif
//@}

/*! @name Register SNVS_LPTGFCR, field ETGF1_EN[23] (RW)
 *
 * External Tamper Glitch Filter 1 Enable When set, enables the external tamper glitch filter 1.
 *
 * Values:
 * - 0 - External tamper glitch filter 1 is bypassed.
 * - 1 - External tamper glitch filter 1 is enabled.
 */
//@{
#define BP_SNVS_LPTGFCR_ETGF1_EN      (23)      //!< Bit position for SNVS_LPTGFCR_ETGF1_EN.
#define BM_SNVS_LPTGFCR_ETGF1_EN      (0x00800000)  //!< Bit mask for SNVS_LPTGFCR_ETGF1_EN.

//! @brief Get value of SNVS_LPTGFCR_ETGF1_EN from a register value.
#define BG_SNVS_LPTGFCR_ETGF1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTGFCR_ETGF1_EN) >> BP_SNVS_LPTGFCR_ETGF1_EN)

//! @brief Format value for bitfield SNVS_LPTGFCR_ETGF1_EN.
#define BF_SNVS_LPTGFCR_ETGF1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTGFCR_ETGF1_EN) & BM_SNVS_LPTGFCR_ETGF1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ETGF1_EN field to a new value.
#define BW_SNVS_LPTGFCR_ETGF1_EN(v)   (HW_SNVS_LPTGFCR_WR((HW_SNVS_LPTGFCR_RD() & ~BM_SNVS_LPTGFCR_ETGF1_EN) | BF_SNVS_LPTGFCR_ETGF1_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPTDCR - SNVS_LP Tamper Detectors Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPTDCR - SNVS_LP Tamper Detectors Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Tamper Detectors Configuration Register is used to configure analog and digital
 * tamper detector sources. This register cannot be programmed when LPTDCR is locked for write.
 */
typedef union _hw_snvs_lptdcr
{
    reg32_t U;
    struct _hw_snvs_lptdcr_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved
        unsigned SRTCR_EN : 1; //!< [1] SRTC Rollover Enable
        unsigned MCR_EN : 1; //!< [2] MC Rollover Enable
        unsigned RESERVED1 : 6; //!< [8:3] Reserved.
        unsigned ET1_EN : 1; //!< [9] External Tampering 1 Enable
        unsigned RESERVED2 : 4; //!< [13:10] Reserved.
        unsigned PFD_OBSERV : 1; //!< [14] System Power Fail Detector (PFD) Observability Flop
        unsigned POR_OBSERV : 1; //!< [15] Power On Reset (POR) Observability Flop
        unsigned RESERVED3 : 16; //!< [31:16] Reserved.
    } B;
} hw_snvs_lptdcr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPTDCR register
 */
//@{
#define HW_SNVS_LPTDCR_ADDR      (REGS_SNVS_BASE + 0x48)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPTDCR           (*(volatile hw_snvs_lptdcr_t *) HW_SNVS_LPTDCR_ADDR)
#define HW_SNVS_LPTDCR_RD()      (HW_SNVS_LPTDCR.U)
#define HW_SNVS_LPTDCR_WR(v)     (HW_SNVS_LPTDCR.U = (v))
#define HW_SNVS_LPTDCR_SET(v)    (HW_SNVS_LPTDCR_WR(HW_SNVS_LPTDCR_RD() |  (v)))
#define HW_SNVS_LPTDCR_CLR(v)    (HW_SNVS_LPTDCR_WR(HW_SNVS_LPTDCR_RD() & ~(v)))
#define HW_SNVS_LPTDCR_TOG(v)    (HW_SNVS_LPTDCR_WR(HW_SNVS_LPTDCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPTDCR bitfields
 */

/*! @name Register SNVS_LPTDCR, field SRTCR_EN[1] (RW)
 *
 * SRTC Rollover Enable When set, an SRTC rollover event generates an LP security violation.
 *
 * Values:
 * - 0 - SRTC rollover is disabled.
 * - 1 - SRTC rollover is enabled.
 */
//@{
#define BP_SNVS_LPTDCR_SRTCR_EN      (1)      //!< Bit position for SNVS_LPTDCR_SRTCR_EN.
#define BM_SNVS_LPTDCR_SRTCR_EN      (0x00000002)  //!< Bit mask for SNVS_LPTDCR_SRTCR_EN.

//! @brief Get value of SNVS_LPTDCR_SRTCR_EN from a register value.
#define BG_SNVS_LPTDCR_SRTCR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTDCR_SRTCR_EN) >> BP_SNVS_LPTDCR_SRTCR_EN)

//! @brief Format value for bitfield SNVS_LPTDCR_SRTCR_EN.
#define BF_SNVS_LPTDCR_SRTCR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTDCR_SRTCR_EN) & BM_SNVS_LPTDCR_SRTCR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTCR_EN field to a new value.
#define BW_SNVS_LPTDCR_SRTCR_EN(v)   (HW_SNVS_LPTDCR_WR((HW_SNVS_LPTDCR_RD() & ~BM_SNVS_LPTDCR_SRTCR_EN) | BF_SNVS_LPTDCR_SRTCR_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPTDCR, field MCR_EN[2] (RW)
 *
 * MC Rollover Enable When set, an MC Rollover event generates an LP security violation.
 *
 * Values:
 * - 0 - MC rollover is disabled.
 * - 1 - MC rollover is enabled.
 */
//@{
#define BP_SNVS_LPTDCR_MCR_EN      (2)      //!< Bit position for SNVS_LPTDCR_MCR_EN.
#define BM_SNVS_LPTDCR_MCR_EN      (0x00000004)  //!< Bit mask for SNVS_LPTDCR_MCR_EN.

//! @brief Get value of SNVS_LPTDCR_MCR_EN from a register value.
#define BG_SNVS_LPTDCR_MCR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTDCR_MCR_EN) >> BP_SNVS_LPTDCR_MCR_EN)

//! @brief Format value for bitfield SNVS_LPTDCR_MCR_EN.
#define BF_SNVS_LPTDCR_MCR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTDCR_MCR_EN) & BM_SNVS_LPTDCR_MCR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCR_EN field to a new value.
#define BW_SNVS_LPTDCR_MCR_EN(v)   (HW_SNVS_LPTDCR_WR((HW_SNVS_LPTDCR_RD() & ~BM_SNVS_LPTDCR_MCR_EN) | BF_SNVS_LPTDCR_MCR_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPTDCR, field ET1_EN[9] (RW)
 *
 * External Tampering 1 Enable When set, external tampering 1 detection generates an LP security
 * violation.
 *
 * Values:
 * - 0 - External tamper 1 is disabled.
 * - 1 - External tamper 1 is enabled.
 */
//@{
#define BP_SNVS_LPTDCR_ET1_EN      (9)      //!< Bit position for SNVS_LPTDCR_ET1_EN.
#define BM_SNVS_LPTDCR_ET1_EN      (0x00000200)  //!< Bit mask for SNVS_LPTDCR_ET1_EN.

//! @brief Get value of SNVS_LPTDCR_ET1_EN from a register value.
#define BG_SNVS_LPTDCR_ET1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTDCR_ET1_EN) >> BP_SNVS_LPTDCR_ET1_EN)

//! @brief Format value for bitfield SNVS_LPTDCR_ET1_EN.
#define BF_SNVS_LPTDCR_ET1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTDCR_ET1_EN) & BM_SNVS_LPTDCR_ET1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ET1_EN field to a new value.
#define BW_SNVS_LPTDCR_ET1_EN(v)   (HW_SNVS_LPTDCR_WR((HW_SNVS_LPTDCR_RD() & ~BM_SNVS_LPTDCR_ET1_EN) | BF_SNVS_LPTDCR_ET1_EN(v)))
#endif
//@}

/*! @name Register SNVS_LPTDCR, field PFD_OBSERV[14] (RW)
 *
 * System Power Fail Detector (PFD) Observability Flop The asynchronous reset input of this flop is
 * connected directly to the inverted output of the PFD analog circuitry (external to the SNVS
 * block). This flop can be used to detect brown-out voltage of the PFD circuitry.
 */
//@{
#define BP_SNVS_LPTDCR_PFD_OBSERV      (14)      //!< Bit position for SNVS_LPTDCR_PFD_OBSERV.
#define BM_SNVS_LPTDCR_PFD_OBSERV      (0x00004000)  //!< Bit mask for SNVS_LPTDCR_PFD_OBSERV.

//! @brief Get value of SNVS_LPTDCR_PFD_OBSERV from a register value.
#define BG_SNVS_LPTDCR_PFD_OBSERV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTDCR_PFD_OBSERV) >> BP_SNVS_LPTDCR_PFD_OBSERV)

//! @brief Format value for bitfield SNVS_LPTDCR_PFD_OBSERV.
#define BF_SNVS_LPTDCR_PFD_OBSERV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTDCR_PFD_OBSERV) & BM_SNVS_LPTDCR_PFD_OBSERV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PFD_OBSERV field to a new value.
#define BW_SNVS_LPTDCR_PFD_OBSERV(v)   (HW_SNVS_LPTDCR_WR((HW_SNVS_LPTDCR_RD() & ~BM_SNVS_LPTDCR_PFD_OBSERV) | BF_SNVS_LPTDCR_PFD_OBSERV(v)))
#endif
//@}

/*! @name Register SNVS_LPTDCR, field POR_OBSERV[15] (RW)
 *
 * Power On Reset (POR) Observability Flop The asynchronous reset input of this flop is connected
 * directly to the output of the POR analog circuitry (external to the SNVS block). This flop can be
 * used to detect brown-out voltage of the POR circuitry.
 */
//@{
#define BP_SNVS_LPTDCR_POR_OBSERV      (15)      //!< Bit position for SNVS_LPTDCR_POR_OBSERV.
#define BM_SNVS_LPTDCR_POR_OBSERV      (0x00008000)  //!< Bit mask for SNVS_LPTDCR_POR_OBSERV.

//! @brief Get value of SNVS_LPTDCR_POR_OBSERV from a register value.
#define BG_SNVS_LPTDCR_POR_OBSERV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTDCR_POR_OBSERV) >> BP_SNVS_LPTDCR_POR_OBSERV)

//! @brief Format value for bitfield SNVS_LPTDCR_POR_OBSERV.
#define BF_SNVS_LPTDCR_POR_OBSERV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTDCR_POR_OBSERV) & BM_SNVS_LPTDCR_POR_OBSERV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POR_OBSERV field to a new value.
#define BW_SNVS_LPTDCR_POR_OBSERV(v)   (HW_SNVS_LPTDCR_WR((HW_SNVS_LPTDCR_RD() & ~BM_SNVS_LPTDCR_POR_OBSERV) | BF_SNVS_LPTDCR_POR_OBSERV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSR - SNVS _LP Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSR - SNVS _LP Status Register (RW)
 *
 * Reset value: 0x00000008
 *
 * The SNVS _LP Status Register reflects the internal state and behavior of the SNVS _LP.
 */
typedef union _hw_snvs_lpsr
{
    reg32_t U;
    struct _hw_snvs_lpsr_bitfields
    {
        unsigned LPTA : 1; //!< [0] LP Time Alarm.
        unsigned SRTCR : 1; //!< [1] Secure Real Time Counter Rollover.
        unsigned MCR : 1; //!< [2] Monotonic Counter Rollover.
        unsigned PGD : 1; //!< [3] Power Supply Glitch Detected.
        unsigned RESERVED0 : 5; //!< [8:4] Reserved.
        unsigned ET1D : 1; //!< [9] External Tampering 1 Detected.
        unsigned RESERVED1 : 6; //!< [15:10] Reserved.
        unsigned ESVD : 1; //!< [16] External Security Violation Detected
        unsigned EO : 1; //!< [17] Emergency Off
        unsigned SPO : 1; //!< [18] Set Power Off
        unsigned RESERVED2 : 1; //!< [19] Reserved
        unsigned SED : 1; //!< [20] Scan Exit Detected
        unsigned RESERVED3 : 9; //!< [29:21] Reserved
        unsigned LPNS : 1; //!< [30] LP Section is Non-Secured
        unsigned LPS : 1; //!< [31] LP Section is Secured
    } B;
} hw_snvs_lpsr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSR register
 */
//@{
#define HW_SNVS_LPSR_ADDR      (REGS_SNVS_BASE + 0x4c)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSR           (*(volatile hw_snvs_lpsr_t *) HW_SNVS_LPSR_ADDR)
#define HW_SNVS_LPSR_RD()      (HW_SNVS_LPSR.U)
#define HW_SNVS_LPSR_WR(v)     (HW_SNVS_LPSR.U = (v))
#define HW_SNVS_LPSR_SET(v)    (HW_SNVS_LPSR_WR(HW_SNVS_LPSR_RD() |  (v)))
#define HW_SNVS_LPSR_CLR(v)    (HW_SNVS_LPSR_WR(HW_SNVS_LPSR_RD() & ~(v)))
#define HW_SNVS_LPSR_TOG(v)    (HW_SNVS_LPSR_WR(HW_SNVS_LPSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSR bitfields
 */

/*! @name Register SNVS_LPSR, field LPTA[0] (W1C)
 *
 * LP Time Alarm.
 *
 * Values:
 * - 0 - No time alarm interrupt occurred.
 * - 1 - A time alarm interrupt occurred.
 */
//@{
#define BP_SNVS_LPSR_LPTA      (0)      //!< Bit position for SNVS_LPSR_LPTA.
#define BM_SNVS_LPSR_LPTA      (0x00000001)  //!< Bit mask for SNVS_LPSR_LPTA.

//! @brief Get value of SNVS_LPSR_LPTA from a register value.
#define BG_SNVS_LPSR_LPTA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_LPTA) >> BP_SNVS_LPSR_LPTA)

//! @brief Format value for bitfield SNVS_LPSR_LPTA.
#define BF_SNVS_LPSR_LPTA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_LPTA) & BM_SNVS_LPSR_LPTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTA field to a new value.
#define BW_SNVS_LPSR_LPTA(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_LPTA) | BF_SNVS_LPSR_LPTA(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field SRTCR[1] (W1C)
 *
 * Secure Real Time Counter Rollover.
 *
 * Values:
 * - 0 - SRTC has not reached its maximum value.
 * - 1 - SRTC has reached its maximum value.
 */
//@{
#define BP_SNVS_LPSR_SRTCR      (1)      //!< Bit position for SNVS_LPSR_SRTCR.
#define BM_SNVS_LPSR_SRTCR      (0x00000002)  //!< Bit mask for SNVS_LPSR_SRTCR.

//! @brief Get value of SNVS_LPSR_SRTCR from a register value.
#define BG_SNVS_LPSR_SRTCR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_SRTCR) >> BP_SNVS_LPSR_SRTCR)

//! @brief Format value for bitfield SNVS_LPSR_SRTCR.
#define BF_SNVS_LPSR_SRTCR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_SRTCR) & BM_SNVS_LPSR_SRTCR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTCR field to a new value.
#define BW_SNVS_LPSR_SRTCR(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_SRTCR) | BF_SNVS_LPSR_SRTCR(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field MCR[2] (W1C)
 *
 * Monotonic Counter Rollover.
 *
 * Values:
 * - 0 - MC has not reached its maximum value.
 * - 1 - MC has reached its maximum value.
 */
//@{
#define BP_SNVS_LPSR_MCR      (2)      //!< Bit position for SNVS_LPSR_MCR.
#define BM_SNVS_LPSR_MCR      (0x00000004)  //!< Bit mask for SNVS_LPSR_MCR.

//! @brief Get value of SNVS_LPSR_MCR from a register value.
#define BG_SNVS_LPSR_MCR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_MCR) >> BP_SNVS_LPSR_MCR)

//! @brief Format value for bitfield SNVS_LPSR_MCR.
#define BF_SNVS_LPSR_MCR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_MCR) & BM_SNVS_LPSR_MCR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCR field to a new value.
#define BW_SNVS_LPSR_MCR(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_MCR) | BF_SNVS_LPSR_MCR(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field PGD[3] (W1C)
 *
 * Power Supply Glitch Detected. 0 No power supply glitch. 1 Power supply glitch is detected.
 */
//@{
#define BP_SNVS_LPSR_PGD      (3)      //!< Bit position for SNVS_LPSR_PGD.
#define BM_SNVS_LPSR_PGD      (0x00000008)  //!< Bit mask for SNVS_LPSR_PGD.

//! @brief Get value of SNVS_LPSR_PGD from a register value.
#define BG_SNVS_LPSR_PGD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_PGD) >> BP_SNVS_LPSR_PGD)

//! @brief Format value for bitfield SNVS_LPSR_PGD.
#define BF_SNVS_LPSR_PGD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_PGD) & BM_SNVS_LPSR_PGD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PGD field to a new value.
#define BW_SNVS_LPSR_PGD(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_PGD) | BF_SNVS_LPSR_PGD(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field ET1D[9] (W1C)
 *
 * External Tampering 1 Detected.
 *
 * Values:
 * - 0 - External tampering 1 not detected.
 * - 1 - External tampering 1 detected.
 */
//@{
#define BP_SNVS_LPSR_ET1D      (9)      //!< Bit position for SNVS_LPSR_ET1D.
#define BM_SNVS_LPSR_ET1D      (0x00000200)  //!< Bit mask for SNVS_LPSR_ET1D.

//! @brief Get value of SNVS_LPSR_ET1D from a register value.
#define BG_SNVS_LPSR_ET1D(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_ET1D) >> BP_SNVS_LPSR_ET1D)

//! @brief Format value for bitfield SNVS_LPSR_ET1D.
#define BF_SNVS_LPSR_ET1D(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_ET1D) & BM_SNVS_LPSR_ET1D)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ET1D field to a new value.
#define BW_SNVS_LPSR_ET1D(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_ET1D) | BF_SNVS_LPSR_ET1D(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field ESVD[16] (W1C)
 *
 * External Security Violation Detected Indicates that a security violation is detected on one of
 * the HP security violation ports. The record of the port on which the violation has occurred can
 * be found in the HP Security Violation Status Register.
 *
 * Values:
 * - 0 - No external security violation.
 * - 1 - External security violation is detected.
 */
//@{
#define BP_SNVS_LPSR_ESVD      (16)      //!< Bit position for SNVS_LPSR_ESVD.
#define BM_SNVS_LPSR_ESVD      (0x00010000)  //!< Bit mask for SNVS_LPSR_ESVD.

//! @brief Get value of SNVS_LPSR_ESVD from a register value.
#define BG_SNVS_LPSR_ESVD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_ESVD) >> BP_SNVS_LPSR_ESVD)

//! @brief Format value for bitfield SNVS_LPSR_ESVD.
#define BF_SNVS_LPSR_ESVD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_ESVD) & BM_SNVS_LPSR_ESVD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ESVD field to a new value.
#define BW_SNVS_LPSR_ESVD(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_ESVD) | BF_SNVS_LPSR_ESVD(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field EO[17] (W1C)
 *
 * Emergency Off This bit is set when a power off is requested.
 *
 * Values:
 * - 0 - Emergency off was not detected.
 * - 1 - Emergency off was detected.
 */
//@{
#define BP_SNVS_LPSR_EO      (17)      //!< Bit position for SNVS_LPSR_EO.
#define BM_SNVS_LPSR_EO      (0x00020000)  //!< Bit mask for SNVS_LPSR_EO.

//! @brief Get value of SNVS_LPSR_EO from a register value.
#define BG_SNVS_LPSR_EO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_EO) >> BP_SNVS_LPSR_EO)

//! @brief Format value for bitfield SNVS_LPSR_EO.
#define BF_SNVS_LPSR_EO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_EO) & BM_SNVS_LPSR_EO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EO field to a new value.
#define BW_SNVS_LPSR_EO(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_EO) | BF_SNVS_LPSR_EO(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field SPO[18] (W1C)
 *
 * Set Power Off This bit is set when power off was requested by a button press, but the button was
 * not pressed for 5 seconds.
 *
 * Values:
 * - 0 - Emergency Off was not detected.
 * - 1 - Emergency Off was detected..
 */
//@{
#define BP_SNVS_LPSR_SPO      (18)      //!< Bit position for SNVS_LPSR_SPO.
#define BM_SNVS_LPSR_SPO      (0x00040000)  //!< Bit mask for SNVS_LPSR_SPO.

//! @brief Get value of SNVS_LPSR_SPO from a register value.
#define BG_SNVS_LPSR_SPO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_SPO) >> BP_SNVS_LPSR_SPO)

//! @brief Format value for bitfield SNVS_LPSR_SPO.
#define BF_SNVS_LPSR_SPO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_SPO) & BM_SNVS_LPSR_SPO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPO field to a new value.
#define BW_SNVS_LPSR_SPO(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_SPO) | BF_SNVS_LPSR_SPO(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field SED[20] (W1C)
 *
 * Scan Exit Detected
 *
 * Values:
 * - 0 - Scan exit was not detected.
 * - 1 - Scan exit was detected.
 */
//@{
#define BP_SNVS_LPSR_SED      (20)      //!< Bit position for SNVS_LPSR_SED.
#define BM_SNVS_LPSR_SED      (0x00100000)  //!< Bit mask for SNVS_LPSR_SED.

//! @brief Get value of SNVS_LPSR_SED from a register value.
#define BG_SNVS_LPSR_SED(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_SED) >> BP_SNVS_LPSR_SED)

//! @brief Format value for bitfield SNVS_LPSR_SED.
#define BF_SNVS_LPSR_SED(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSR_SED) & BM_SNVS_LPSR_SED)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SED field to a new value.
#define BW_SNVS_LPSR_SED(v)   (HW_SNVS_LPSR_WR((HW_SNVS_LPSR_RD() & ~BM_SNVS_LPSR_SED) | BF_SNVS_LPSR_SED(v)))
#endif
//@}

/*! @name Register SNVS_LPSR, field LPNS[30] (RO)
 *
 * LP Section is Non-Secured Indicates that LP section was provisioned/programmed in the non-secure
 * state. The first successful write to the LP Registers in non-secure state sets this bit. This bit
 * can never be set together with the LPS bit. When set, the entire SNVS _LP section (all LP
 * registers) are cleared upon an SSM transition from check to trusted state.
 *
 * Values:
 * - 0 - LP section was not programmed in the non-secure state.
 * - 1 - LP section was programmed in the non-secure state.
 */
//@{
#define BP_SNVS_LPSR_LPNS      (30)      //!< Bit position for SNVS_LPSR_LPNS.
#define BM_SNVS_LPSR_LPNS      (0x40000000)  //!< Bit mask for SNVS_LPSR_LPNS.

//! @brief Get value of SNVS_LPSR_LPNS from a register value.
#define BG_SNVS_LPSR_LPNS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_LPNS) >> BP_SNVS_LPSR_LPNS)
//@}

/*! @name Register SNVS_LPSR, field LPS[31] (RO)
 *
 * LP Section is Secured Indicates that the LP section is provisioned/programmed in the secure or
 * trusted state. The first write to the LP registers in secure or trusted state sets this bit. This
 * bit can never be set together with the LPNS bit. When set the SNVS _LP section cannot be
 * programmed , and ZMK cannot be read in the non-secure state of the SSM .
 *
 * Values:
 * - 0 - LP section was not programmed in secure or trusted state.
 * - 1 - LP section was programmed in secure or trusted state.
 */
//@{
#define BP_SNVS_LPSR_LPS      (31)      //!< Bit position for SNVS_LPSR_LPS.
#define BM_SNVS_LPSR_LPS      (0x80000000)  //!< Bit mask for SNVS_LPSR_LPS.

//! @brief Get value of SNVS_LPSR_LPS from a register value.
#define BG_SNVS_LPSR_LPS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSR_LPS) >> BP_SNVS_LPSR_LPS)
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSRTCMR - SNVS_LP Secure Real Time Counter MSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSRTCMR - SNVS_LP Secure Real Time Counter MSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Secure Real Time Counter MSB register contains the most-significant bits of the
 * secure real time counter.
 */
typedef union _hw_snvs_lpsrtcmr
{
    reg32_t U;
    struct _hw_snvs_lpsrtcmr_bitfields
    {
        unsigned SRTC : 15; //!< [14:0] LP Secure Real Time Counter most significant 15 bits
        unsigned RESERVED0 : 17; //!< [31:15] Reserved
    } B;
} hw_snvs_lpsrtcmr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSRTCMR register
 */
//@{
#define HW_SNVS_LPSRTCMR_ADDR      (REGS_SNVS_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSRTCMR           (*(volatile hw_snvs_lpsrtcmr_t *) HW_SNVS_LPSRTCMR_ADDR)
#define HW_SNVS_LPSRTCMR_RD()      (HW_SNVS_LPSRTCMR.U)
#define HW_SNVS_LPSRTCMR_WR(v)     (HW_SNVS_LPSRTCMR.U = (v))
#define HW_SNVS_LPSRTCMR_SET(v)    (HW_SNVS_LPSRTCMR_WR(HW_SNVS_LPSRTCMR_RD() |  (v)))
#define HW_SNVS_LPSRTCMR_CLR(v)    (HW_SNVS_LPSRTCMR_WR(HW_SNVS_LPSRTCMR_RD() & ~(v)))
#define HW_SNVS_LPSRTCMR_TOG(v)    (HW_SNVS_LPSRTCMR_WR(HW_SNVS_LPSRTCMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSRTCMR bitfields
 */

/*! @name Register SNVS_LPSRTCMR, field SRTC[14:0] (RW)
 *
 * LP Secure Real Time Counter most significant 15 bits This register can be programmed only when
 * SRTC is not active and not locked, meaning the SRTC_ENV, SRTC_SL, and SRTC_HL bits are not set.
 */
//@{
#define BP_SNVS_LPSRTCMR_SRTC      (0)      //!< Bit position for SNVS_LPSRTCMR_SRTC.
#define BM_SNVS_LPSRTCMR_SRTC      (0x00007fff)  //!< Bit mask for SNVS_LPSRTCMR_SRTC.

//! @brief Get value of SNVS_LPSRTCMR_SRTC from a register value.
#define BG_SNVS_LPSRTCMR_SRTC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSRTCMR_SRTC) >> BP_SNVS_LPSRTCMR_SRTC)

//! @brief Format value for bitfield SNVS_LPSRTCMR_SRTC.
#define BF_SNVS_LPSRTCMR_SRTC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSRTCMR_SRTC) & BM_SNVS_LPSRTCMR_SRTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC field to a new value.
#define BW_SNVS_LPSRTCMR_SRTC(v)   (HW_SNVS_LPSRTCMR_WR((HW_SNVS_LPSRTCMR_RD() & ~BM_SNVS_LPSRTCMR_SRTC) | BF_SNVS_LPSRTCMR_SRTC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSRTCLR - SNVS_LP Secure Real Time Counter LSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSRTCLR - SNVS_LP Secure Real Time Counter LSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Secure Real Time Counter LSB register contains the 32 least-significant bits of the
 * secure real time counter.
 */
typedef union _hw_snvs_lpsrtclr
{
    reg32_t U;
    struct _hw_snvs_lpsrtclr_bitfields
    {
        unsigned SRTC : 32; //!< [31:0] LP Secure Real Time Counter least significant 32 bits
    } B;
} hw_snvs_lpsrtclr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSRTCLR register
 */
//@{
#define HW_SNVS_LPSRTCLR_ADDR      (REGS_SNVS_BASE + 0x54)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSRTCLR           (*(volatile hw_snvs_lpsrtclr_t *) HW_SNVS_LPSRTCLR_ADDR)
#define HW_SNVS_LPSRTCLR_RD()      (HW_SNVS_LPSRTCLR.U)
#define HW_SNVS_LPSRTCLR_WR(v)     (HW_SNVS_LPSRTCLR.U = (v))
#define HW_SNVS_LPSRTCLR_SET(v)    (HW_SNVS_LPSRTCLR_WR(HW_SNVS_LPSRTCLR_RD() |  (v)))
#define HW_SNVS_LPSRTCLR_CLR(v)    (HW_SNVS_LPSRTCLR_WR(HW_SNVS_LPSRTCLR_RD() & ~(v)))
#define HW_SNVS_LPSRTCLR_TOG(v)    (HW_SNVS_LPSRTCLR_WR(HW_SNVS_LPSRTCLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSRTCLR bitfields
 */

/*! @name Register SNVS_LPSRTCLR, field SRTC[31:0] (RW)
 *
 * LP Secure Real Time Counter least significant 32 bits This register can be programmed only when
 * SRTC is not active and not locked, meaning the SRTC_ENV, SRTC_SL, and SRTC_HL bits are not set.
 */
//@{
#define BP_SNVS_LPSRTCLR_SRTC      (0)      //!< Bit position for SNVS_LPSRTCLR_SRTC.
#define BM_SNVS_LPSRTCLR_SRTC      (0xffffffff)  //!< Bit mask for SNVS_LPSRTCLR_SRTC.

//! @brief Get value of SNVS_LPSRTCLR_SRTC from a register value.
#define BG_SNVS_LPSRTCLR_SRTC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSRTCLR_SRTC) >> BP_SNVS_LPSRTCLR_SRTC)

//! @brief Format value for bitfield SNVS_LPSRTCLR_SRTC.
#define BF_SNVS_LPSRTCLR_SRTC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSRTCLR_SRTC) & BM_SNVS_LPSRTCLR_SRTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTC field to a new value.
#define BW_SNVS_LPSRTCLR_SRTC(v)   (HW_SNVS_LPSRTCLR_WR((HW_SNVS_LPSRTCLR_RD() & ~BM_SNVS_LPSRTCLR_SRTC) | BF_SNVS_LPSRTCLR_SRTC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPTAR - SNVS_LP Time Alarm Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPTAR - SNVS_LP Time Alarm Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Time Alarm register contains the 32-bit LP Time Alarm value.
 */
typedef union _hw_snvs_lptar
{
    reg32_t U;
    struct _hw_snvs_lptar_bitfields
    {
        unsigned LPTA : 32; //!< [31:0] LP Time Alarm
    } B;
} hw_snvs_lptar_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPTAR register
 */
//@{
#define HW_SNVS_LPTAR_ADDR      (REGS_SNVS_BASE + 0x58)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPTAR           (*(volatile hw_snvs_lptar_t *) HW_SNVS_LPTAR_ADDR)
#define HW_SNVS_LPTAR_RD()      (HW_SNVS_LPTAR.U)
#define HW_SNVS_LPTAR_WR(v)     (HW_SNVS_LPTAR.U = (v))
#define HW_SNVS_LPTAR_SET(v)    (HW_SNVS_LPTAR_WR(HW_SNVS_LPTAR_RD() |  (v)))
#define HW_SNVS_LPTAR_CLR(v)    (HW_SNVS_LPTAR_WR(HW_SNVS_LPTAR_RD() & ~(v)))
#define HW_SNVS_LPTAR_TOG(v)    (HW_SNVS_LPTAR_WR(HW_SNVS_LPTAR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPTAR bitfields
 */

/*! @name Register SNVS_LPTAR, field LPTA[31:0] (RW)
 *
 * LP Time Alarm This register can be programmed only when the LP time alarm is disabled (LPTA_EN
 * bit is not set).
 */
//@{
#define BP_SNVS_LPTAR_LPTA      (0)      //!< Bit position for SNVS_LPTAR_LPTA.
#define BM_SNVS_LPTAR_LPTA      (0xffffffff)  //!< Bit mask for SNVS_LPTAR_LPTA.

//! @brief Get value of SNVS_LPTAR_LPTA from a register value.
#define BG_SNVS_LPTAR_LPTA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPTAR_LPTA) >> BP_SNVS_LPTAR_LPTA)

//! @brief Format value for bitfield SNVS_LPTAR_LPTA.
#define BF_SNVS_LPTAR_LPTA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPTAR_LPTA) & BM_SNVS_LPTAR_LPTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTA field to a new value.
#define BW_SNVS_LPTAR_LPTA(v)   (HW_SNVS_LPTAR_WR((HW_SNVS_LPTAR_RD() & ~BM_SNVS_LPTAR_LPTA) | BF_SNVS_LPTAR_LPTA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSMCMR - SNVS_LP Secure Monotonic Counter MSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSMCMR - SNVS_LP Secure Monotonic Counter MSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Secure Monotonic Counter MSB Register contains the monotonic counter era bits and
 * the most significant 16 bits of the monotonic counter. The monotonic counter is incremented by
 * one if there is a write command to the LPSMCMR or LPSMCLR register.
 */
typedef union _hw_snvs_lpsmcmr
{
    reg32_t U;
    struct _hw_snvs_lpsmcmr_bitfields
    {
        unsigned MON_COUNTER : 16; //!< [15:0] Monotonic Counter Most Significant 16 Bits
        unsigned MC_ERA_BITS : 16; //!< [31:16] Monotonic Counter Era Bits
    } B;
} hw_snvs_lpsmcmr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSMCMR register
 */
//@{
#define HW_SNVS_LPSMCMR_ADDR      (REGS_SNVS_BASE + 0x5c)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSMCMR           (*(volatile hw_snvs_lpsmcmr_t *) HW_SNVS_LPSMCMR_ADDR)
#define HW_SNVS_LPSMCMR_RD()      (HW_SNVS_LPSMCMR.U)
#define HW_SNVS_LPSMCMR_WR(v)     (HW_SNVS_LPSMCMR.U = (v))
#define HW_SNVS_LPSMCMR_SET(v)    (HW_SNVS_LPSMCMR_WR(HW_SNVS_LPSMCMR_RD() |  (v)))
#define HW_SNVS_LPSMCMR_CLR(v)    (HW_SNVS_LPSMCMR_WR(HW_SNVS_LPSMCMR_RD() & ~(v)))
#define HW_SNVS_LPSMCMR_TOG(v)    (HW_SNVS_LPSMCMR_WR(HW_SNVS_LPSMCMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSMCMR bitfields
 */

/*! @name Register SNVS_LPSMCMR, field MON_COUNTER[15:0] (RW)
 *
 * Monotonic Counter Most Significant 16 Bits The MC is incremented by one when: A write transaction
 * to the LPSMCMR or LPSMCLR register is detected. The MC_ENV bit is set. MC_SL and MC_HL bits are
 * not set.
 */
//@{
#define BP_SNVS_LPSMCMR_MON_COUNTER      (0)      //!< Bit position for SNVS_LPSMCMR_MON_COUNTER.
#define BM_SNVS_LPSMCMR_MON_COUNTER      (0x0000ffff)  //!< Bit mask for SNVS_LPSMCMR_MON_COUNTER.

//! @brief Get value of SNVS_LPSMCMR_MON_COUNTER from a register value.
#define BG_SNVS_LPSMCMR_MON_COUNTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSMCMR_MON_COUNTER) >> BP_SNVS_LPSMCMR_MON_COUNTER)

//! @brief Format value for bitfield SNVS_LPSMCMR_MON_COUNTER.
#define BF_SNVS_LPSMCMR_MON_COUNTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSMCMR_MON_COUNTER) & BM_SNVS_LPSMCMR_MON_COUNTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MON_COUNTER field to a new value.
#define BW_SNVS_LPSMCMR_MON_COUNTER(v)   (HW_SNVS_LPSMCMR_WR((HW_SNVS_LPSMCMR_RD() & ~BM_SNVS_LPSMCMR_MON_COUNTER) | BF_SNVS_LPSMCMR_MON_COUNTER(v)))
#endif
//@}

/*! @name Register SNVS_LPSMCMR, field MC_ERA_BITS[31:16] (RW)
 *
 * Monotonic Counter Era Bits These bits are inputs to the module and typically connect to fuses.
 */
//@{
#define BP_SNVS_LPSMCMR_MC_ERA_BITS      (16)      //!< Bit position for SNVS_LPSMCMR_MC_ERA_BITS.
#define BM_SNVS_LPSMCMR_MC_ERA_BITS      (0xffff0000)  //!< Bit mask for SNVS_LPSMCMR_MC_ERA_BITS.

//! @brief Get value of SNVS_LPSMCMR_MC_ERA_BITS from a register value.
#define BG_SNVS_LPSMCMR_MC_ERA_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSMCMR_MC_ERA_BITS) >> BP_SNVS_LPSMCMR_MC_ERA_BITS)

//! @brief Format value for bitfield SNVS_LPSMCMR_MC_ERA_BITS.
#define BF_SNVS_LPSMCMR_MC_ERA_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSMCMR_MC_ERA_BITS) & BM_SNVS_LPSMCMR_MC_ERA_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MC_ERA_BITS field to a new value.
#define BW_SNVS_LPSMCMR_MC_ERA_BITS(v)   (HW_SNVS_LPSMCMR_WR((HW_SNVS_LPSMCMR_RD() & ~BM_SNVS_LPSMCMR_MC_ERA_BITS) | BF_SNVS_LPSMCMR_MC_ERA_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPSMCLR - SNVS_LP Secure Monotonic Counter LSB Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPSMCLR - SNVS_LP Secure Monotonic Counter LSB Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Secure Monotonic Counter LSB Register contains the 32 least significant bits of the
 * monotonic counter. The MC is incremented by one if there is a write command to the LPSMCMR or
 * LPSMCLR register.
 */
typedef union _hw_snvs_lpsmclr
{
    reg32_t U;
    struct _hw_snvs_lpsmclr_bitfields
    {
        unsigned MON_COUNTER : 32; //!< [31:0] Monotonic Counter bits
    } B;
} hw_snvs_lpsmclr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPSMCLR register
 */
//@{
#define HW_SNVS_LPSMCLR_ADDR      (REGS_SNVS_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPSMCLR           (*(volatile hw_snvs_lpsmclr_t *) HW_SNVS_LPSMCLR_ADDR)
#define HW_SNVS_LPSMCLR_RD()      (HW_SNVS_LPSMCLR.U)
#define HW_SNVS_LPSMCLR_WR(v)     (HW_SNVS_LPSMCLR.U = (v))
#define HW_SNVS_LPSMCLR_SET(v)    (HW_SNVS_LPSMCLR_WR(HW_SNVS_LPSMCLR_RD() |  (v)))
#define HW_SNVS_LPSMCLR_CLR(v)    (HW_SNVS_LPSMCLR_WR(HW_SNVS_LPSMCLR_RD() & ~(v)))
#define HW_SNVS_LPSMCLR_TOG(v)    (HW_SNVS_LPSMCLR_WR(HW_SNVS_LPSMCLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPSMCLR bitfields
 */

/*! @name Register SNVS_LPSMCLR, field MON_COUNTER[31:0] (RW)
 *
 * Monotonic Counter bits The MC is incremented by one when: A write transaction to the LPSMCMR or
 * LPSMCLR Register is detected. The MC_ENV bit is set. MC_SL and MC_HL bits are not set.
 */
//@{
#define BP_SNVS_LPSMCLR_MON_COUNTER      (0)      //!< Bit position for SNVS_LPSMCLR_MON_COUNTER.
#define BM_SNVS_LPSMCLR_MON_COUNTER      (0xffffffff)  //!< Bit mask for SNVS_LPSMCLR_MON_COUNTER.

//! @brief Get value of SNVS_LPSMCLR_MON_COUNTER from a register value.
#define BG_SNVS_LPSMCLR_MON_COUNTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPSMCLR_MON_COUNTER) >> BP_SNVS_LPSMCLR_MON_COUNTER)

//! @brief Format value for bitfield SNVS_LPSMCLR_MON_COUNTER.
#define BF_SNVS_LPSMCLR_MON_COUNTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPSMCLR_MON_COUNTER) & BM_SNVS_LPSMCLR_MON_COUNTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MON_COUNTER field to a new value.
#define BW_SNVS_LPSMCLR_MON_COUNTER(v)   (HW_SNVS_LPSMCLR_WR((HW_SNVS_LPSMCLR_RD() & ~BM_SNVS_LPSMCLR_MON_COUNTER) | BF_SNVS_LPSMCLR_MON_COUNTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPPGDR - SNVS _LP Power Glitch Detector Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPPGDR - SNVS _LP Power Glitch Detector Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Power Glitch Detector Register provides a 32 bit read write register, which is used
 * for storing power glitch detector value as described in Power glitch detector (PGD) .
 */
typedef union _hw_snvs_lppgdr
{
    reg32_t U;
    struct _hw_snvs_lppgdr_bitfields
    {
        unsigned PGD : 32; //!< [31:0] Power Glitch Detector Value
    } B;
} hw_snvs_lppgdr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPPGDR register
 */
//@{
#define HW_SNVS_LPPGDR_ADDR      (REGS_SNVS_BASE + 0x64)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPPGDR           (*(volatile hw_snvs_lppgdr_t *) HW_SNVS_LPPGDR_ADDR)
#define HW_SNVS_LPPGDR_RD()      (HW_SNVS_LPPGDR.U)
#define HW_SNVS_LPPGDR_WR(v)     (HW_SNVS_LPPGDR.U = (v))
#define HW_SNVS_LPPGDR_SET(v)    (HW_SNVS_LPPGDR_WR(HW_SNVS_LPPGDR_RD() |  (v)))
#define HW_SNVS_LPPGDR_CLR(v)    (HW_SNVS_LPPGDR_WR(HW_SNVS_LPPGDR_RD() & ~(v)))
#define HW_SNVS_LPPGDR_TOG(v)    (HW_SNVS_LPPGDR_WR(HW_SNVS_LPPGDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPPGDR bitfields
 */

/*! @name Register SNVS_LPPGDR, field PGD[31:0] (RW)
 *
 * Power Glitch Detector Value
 */
//@{
#define BP_SNVS_LPPGDR_PGD      (0)      //!< Bit position for SNVS_LPPGDR_PGD.
#define BM_SNVS_LPPGDR_PGD      (0xffffffff)  //!< Bit mask for SNVS_LPPGDR_PGD.

//! @brief Get value of SNVS_LPPGDR_PGD from a register value.
#define BG_SNVS_LPPGDR_PGD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPPGDR_PGD) >> BP_SNVS_LPPGDR_PGD)

//! @brief Format value for bitfield SNVS_LPPGDR_PGD.
#define BF_SNVS_LPPGDR_PGD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPPGDR_PGD) & BM_SNVS_LPPGDR_PGD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PGD field to a new value.
#define BW_SNVS_LPPGDR_PGD(v)   (HW_SNVS_LPPGDR_WR((HW_SNVS_LPPGDR_RD() & ~BM_SNVS_LPPGDR_PGD) | BF_SNVS_LPPGDR_PGD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPGPR - SNVS_LP General Purpose Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPGPR - SNVS_LP General Purpose Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP General Purpose Register provides a 32 bit read write register, which can be used by
 * any application for retaining 32 bit data during a power-down mode.
 */
typedef union _hw_snvs_lpgpr
{
    reg32_t U;
    struct _hw_snvs_lpgpr_bitfields
    {
        unsigned GPR : 32; //!< [31:0] General Purpose Register
    } B;
} hw_snvs_lpgpr_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPGPR register
 */
//@{
#define HW_SNVS_LPGPR_ADDR      (REGS_SNVS_BASE + 0x68)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPGPR           (*(volatile hw_snvs_lpgpr_t *) HW_SNVS_LPGPR_ADDR)
#define HW_SNVS_LPGPR_RD()      (HW_SNVS_LPGPR.U)
#define HW_SNVS_LPGPR_WR(v)     (HW_SNVS_LPGPR.U = (v))
#define HW_SNVS_LPGPR_SET(v)    (HW_SNVS_LPGPR_WR(HW_SNVS_LPGPR_RD() |  (v)))
#define HW_SNVS_LPGPR_CLR(v)    (HW_SNVS_LPGPR_WR(HW_SNVS_LPGPR_RD() & ~(v)))
#define HW_SNVS_LPGPR_TOG(v)    (HW_SNVS_LPGPR_WR(HW_SNVS_LPGPR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPGPR bitfields
 */

/*! @name Register SNVS_LPGPR, field GPR[31:0] (RW)
 *
 * General Purpose Register When GPR_SL or GPR_HL bit is set, the register cannot be programmed.
 */
//@{
#define BP_SNVS_LPGPR_GPR      (0)      //!< Bit position for SNVS_LPGPR_GPR.
#define BM_SNVS_LPGPR_GPR      (0xffffffff)  //!< Bit mask for SNVS_LPGPR_GPR.

//! @brief Get value of SNVS_LPGPR_GPR from a register value.
#define BG_SNVS_LPGPR_GPR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPGPR_GPR) >> BP_SNVS_LPGPR_GPR)

//! @brief Format value for bitfield SNVS_LPGPR_GPR.
#define BF_SNVS_LPGPR_GPR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPGPR_GPR) & BM_SNVS_LPGPR_GPR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GPR field to a new value.
#define BW_SNVS_LPGPR_GPR(v)   (HW_SNVS_LPGPR_WR((HW_SNVS_LPGPR_RD() & ~BM_SNVS_LPGPR_GPR) | BF_SNVS_LPGPR_GPR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_LPZMKRn - SNVS_LP Zeroizable Master Key Register n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_LPZMKRn - SNVS_LP Zeroizable Master Key Register n (RW)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _LP Zeroizable Master Key Registers contain the 256-bit zeroizable master key value.
 * These registers are programmable as follows: When ZMK write lock bit is set, they cannot be
 * programmed. When ZMK_HWP is not set, they are in software programming mode and can be programmed
 * only by software. When ZMK_HWP is set, they are in hardware programming mode and can be
 * programmed only by hardware. These registers cannot be read by software when the ZMK_HWP or ZMK
 * read lock bit is set.
 */
typedef union _hw_snvs_lpzmkrn
{
    reg32_t U;
    struct _hw_snvs_lpzmkrn_bitfields
    {
        unsigned ZMK : 32; //!< [31:0] Zeroizable Master Key
    } B;
} hw_snvs_lpzmkrn_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_LPZMKRn register
 */
//@{
//! @brief Number of instances of the SNVS_LPZMKRn register.
#define HW_SNVS_LPZMKRn_COUNT     (8)

#define HW_SNVS_LPZMKRn_ADDR(n)   (REGS_SNVS_BASE + 0x6c + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_LPZMKRn(n)        (*(volatile hw_snvs_lpzmkrn_t *) HW_SNVS_LPZMKRn_ADDR(n))
#define HW_SNVS_LPZMKRn_RD(n)     (HW_SNVS_LPZMKRn(n).U)
#define HW_SNVS_LPZMKRn_WR(n, v)  (HW_SNVS_LPZMKRn(n).U = (v))
#define HW_SNVS_LPZMKRn_SET(n, v) (HW_SNVS_LPZMKRn_WR(n, HW_SNVS_LPZMKRn_RD(n) |  (v)))
#define HW_SNVS_LPZMKRn_CLR(n, v) (HW_SNVS_LPZMKRn_WR(n, HW_SNVS_LPZMKRn_RD(n) & ~(v)))
#define HW_SNVS_LPZMKRn_TOG(n, v) (HW_SNVS_LPZMKRn_WR(n, HW_SNVS_LPZMKRn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual SNVS_LPZMKRn bitfields
 */

/*! @name Register SNVS_LPZMKRn, field ZMK[31:0] (RW)
 *
 * Zeroizable Master Key Each of these registers contains part of the 256-bit ZMK value: LPZMKR0 -
 * ZMK[ 31-0 ] LPZMKR1 - ZMK[ 63-32 ] LPZMKR2 - ZMK[ 95-64 ] LPZMKR3 - ZMK[ 127-96 ] LPZMKR4 - ZMK[
 * 159-128 ] LPZMKR5 - ZMK[ 191-160 ] LPZMKR6 - ZMK[ 223-192 ] LPZMKR7 - ZMK[ 255-224 ]
 */
//@{
#define BP_SNVS_LPZMKRn_ZMK      (0)      //!< Bit position for SNVS_LPZMKRn_ZMK.
#define BM_SNVS_LPZMKRn_ZMK      (0xffffffff)  //!< Bit mask for SNVS_LPZMKRn_ZMK.

//! @brief Get value of SNVS_LPZMKRn_ZMK from a register value.
#define BG_SNVS_LPZMKRn_ZMK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_LPZMKRn_ZMK) >> BP_SNVS_LPZMKRn_ZMK)

//! @brief Format value for bitfield SNVS_LPZMKRn_ZMK.
#define BF_SNVS_LPZMKRn_ZMK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_SNVS_LPZMKRn_ZMK) & BM_SNVS_LPZMKRn_ZMK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ZMK field to a new value.
#define BW_SNVS_LPZMKRn_ZMK(n, v)   (HW_SNVS_LPZMKRn_WR(n, (HW_SNVS_LPZMKRn_RD(n) & ~BM_SNVS_LPZMKRn_ZMK) | BF_SNVS_LPZMKRn_ZMK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPVIDR1 - SNVS _HP Version ID Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPVIDR1 - SNVS _HP Version ID Register 1 (RO)
 *
 * Reset value: 0x00380000
 *
 * The SNVS _HP Version ID Register 1 is a read-only register that contains the current version of
 * the SNVS . The version consists of a module ID, a major version number, and a minor version
 * number.
 */
typedef union _hw_snvs_hpvidr1
{
    reg32_t U;
    struct _hw_snvs_hpvidr1_bitfields
    {
        unsigned MINOR_REV : 8; //!< [7:0] SNVS block minor version number
        unsigned MAJOR_REV : 8; //!< [15:8] SNVS block major version number
        unsigned IP_ID : 16; //!< [31:16] SNVS block ID
    } B;
} hw_snvs_hpvidr1_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPVIDR1 register
 */
//@{
#define HW_SNVS_HPVIDR1_ADDR      (REGS_SNVS_BASE + 0xbf8)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPVIDR1           (*(volatile hw_snvs_hpvidr1_t *) HW_SNVS_HPVIDR1_ADDR)
#define HW_SNVS_HPVIDR1_RD()      (HW_SNVS_HPVIDR1.U)
#endif
//@}

/*
 * constants & macros for individual SNVS_HPVIDR1 bitfields
 */

/*! @name Register SNVS_HPVIDR1, field MINOR_REV[7:0] (RO)
 *
 * SNVS block minor version number
 */
//@{
#define BP_SNVS_HPVIDR1_MINOR_REV      (0)      //!< Bit position for SNVS_HPVIDR1_MINOR_REV.
#define BM_SNVS_HPVIDR1_MINOR_REV      (0x000000ff)  //!< Bit mask for SNVS_HPVIDR1_MINOR_REV.

//! @brief Get value of SNVS_HPVIDR1_MINOR_REV from a register value.
#define BG_SNVS_HPVIDR1_MINOR_REV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR1_MINOR_REV) >> BP_SNVS_HPVIDR1_MINOR_REV)
//@}

/*! @name Register SNVS_HPVIDR1, field MAJOR_REV[15:8] (RO)
 *
 * SNVS block major version number
 */
//@{
#define BP_SNVS_HPVIDR1_MAJOR_REV      (8)      //!< Bit position for SNVS_HPVIDR1_MAJOR_REV.
#define BM_SNVS_HPVIDR1_MAJOR_REV      (0x0000ff00)  //!< Bit mask for SNVS_HPVIDR1_MAJOR_REV.

//! @brief Get value of SNVS_HPVIDR1_MAJOR_REV from a register value.
#define BG_SNVS_HPVIDR1_MAJOR_REV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR1_MAJOR_REV) >> BP_SNVS_HPVIDR1_MAJOR_REV)
//@}

/*! @name Register SNVS_HPVIDR1, field IP_ID[31:16] (RO)
 *
 * SNVS block ID
 */
//@{
#define BP_SNVS_HPVIDR1_IP_ID      (16)      //!< Bit position for SNVS_HPVIDR1_IP_ID.
#define BM_SNVS_HPVIDR1_IP_ID      (0xffff0000)  //!< Bit mask for SNVS_HPVIDR1_IP_ID.

//! @brief Get value of SNVS_HPVIDR1_IP_ID from a register value.
#define BG_SNVS_HPVIDR1_IP_ID(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR1_IP_ID) >> BP_SNVS_HPVIDR1_IP_ID)
//@}

//-------------------------------------------------------------------------------------------
// HW_SNVS_HPVIDR2 - SNVS _HP Version ID Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SNVS_HPVIDR2 - SNVS _HP Version ID Register 2 (RO)
 *
 * Reset value: 0x00000000
 *
 * The SNVS _HP Version ID Register 2 is a read-only register that indicates the current version of
 * the SNVS . The version consists of the following fields: integration options, ECO revision, and
 * configuration options.
 */
typedef union _hw_snvs_hpvidr2
{
    reg32_t U;
    struct _hw_snvs_hpvidr2_bitfields
    {
        unsigned CONFIG_OPT : 8; //!< [7:0] SNVS Configuration Option
        unsigned ECO_REV : 8; //!< [15:8] SNVS ECO Revision
        unsigned INTG_OPT : 8; //!< [23:16] SNVS Integration Option
        unsigned RESERVED0 : 8; //!< [31:24] Reserved
    } B;
} hw_snvs_hpvidr2_t;
#endif

/*!
 * @name Constants and macros for entire SNVS_HPVIDR2 register
 */
//@{
#define HW_SNVS_HPVIDR2_ADDR      (REGS_SNVS_BASE + 0xbfc)

#ifndef __LANGUAGE_ASM__
#define HW_SNVS_HPVIDR2           (*(volatile hw_snvs_hpvidr2_t *) HW_SNVS_HPVIDR2_ADDR)
#define HW_SNVS_HPVIDR2_RD()      (HW_SNVS_HPVIDR2.U)
#endif
//@}

/*
 * constants & macros for individual SNVS_HPVIDR2 bitfields
 */

/*! @name Register SNVS_HPVIDR2, field CONFIG_OPT[7:0] (RO)
 *
 * SNVS Configuration Option
 */
//@{
#define BP_SNVS_HPVIDR2_CONFIG_OPT      (0)      //!< Bit position for SNVS_HPVIDR2_CONFIG_OPT.
#define BM_SNVS_HPVIDR2_CONFIG_OPT      (0x000000ff)  //!< Bit mask for SNVS_HPVIDR2_CONFIG_OPT.

//! @brief Get value of SNVS_HPVIDR2_CONFIG_OPT from a register value.
#define BG_SNVS_HPVIDR2_CONFIG_OPT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR2_CONFIG_OPT) >> BP_SNVS_HPVIDR2_CONFIG_OPT)
//@}

/*! @name Register SNVS_HPVIDR2, field ECO_REV[15:8] (RO)
 *
 * SNVS ECO Revision
 */
//@{
#define BP_SNVS_HPVIDR2_ECO_REV      (8)      //!< Bit position for SNVS_HPVIDR2_ECO_REV.
#define BM_SNVS_HPVIDR2_ECO_REV      (0x0000ff00)  //!< Bit mask for SNVS_HPVIDR2_ECO_REV.

//! @brief Get value of SNVS_HPVIDR2_ECO_REV from a register value.
#define BG_SNVS_HPVIDR2_ECO_REV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR2_ECO_REV) >> BP_SNVS_HPVIDR2_ECO_REV)
//@}

/*! @name Register SNVS_HPVIDR2, field INTG_OPT[23:16] (RO)
 *
 * SNVS Integration Option
 */
//@{
#define BP_SNVS_HPVIDR2_INTG_OPT      (16)      //!< Bit position for SNVS_HPVIDR2_INTG_OPT.
#define BM_SNVS_HPVIDR2_INTG_OPT      (0x00ff0000)  //!< Bit mask for SNVS_HPVIDR2_INTG_OPT.

//! @brief Get value of SNVS_HPVIDR2_INTG_OPT from a register value.
#define BG_SNVS_HPVIDR2_INTG_OPT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_SNVS_HPVIDR2_INTG_OPT) >> BP_SNVS_HPVIDR2_INTG_OPT)
//@}

//-------------------------------------------------------------------------------------------
// hw_snvs_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All SNVS module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_snvs
{
    volatile hw_snvs_hplr_t HPLR; //!< SNVS _HP Lock Register
    volatile hw_snvs_hpcomr_t HPCOMR; //!< SNVS _HP Command Register
    volatile hw_snvs_hpcr_t HPCR; //!< SNVS_HP Control Register
    volatile hw_snvs_hpsicr_t HPSICR; //!< SNVS _HP Security Interrupt Control Register
    volatile hw_snvs_hpsvcr_t HPSVCR; //!< SNVS _HP Security Violation Control Register
    volatile hw_snvs_hpsr_t HPSR; //!< SNVS _HP Status Register
    volatile hw_snvs_hpsvsr_t HPSVSR; //!< SNVS _HP Security Violation Status Register
    volatile hw_snvs_hphacivr_t HPHACIVR; //!< SNVS _HP High Assurance Counter IV Register
    volatile hw_snvs_hphacr_t HPHACR; //!< SNVS _HP High Assurance Counter Register
    volatile hw_snvs_hprtcmr_t HPRTCMR; //!< SNVS_HP Real Time Counter MSB Register
    volatile hw_snvs_hprtclr_t HPRTCLR; //!< SNVS_HP Real Time Counter LSB Register
    volatile hw_snvs_hptamr_t HPTAMR; //!< SNVS_HP Time Alarm MSB Register
    volatile hw_snvs_hptalr_t HPTALR; //!< SNVS_HP Time Alarm LSB Register
    volatile hw_snvs_lplr_t LPLR; //!< SNVS _LP Lock Register
    volatile hw_snvs_lpcr_t LPCR; //!< SNVS_LP Control Register
    volatile hw_snvs_lpmkcr_t LPMKCR; //!< SNVS_LP Master Key Control Register
    volatile hw_snvs_lpsvcr_t LPSVCR; //!< SNVS_LP Security Violation Control Register
    volatile hw_snvs_lptgfcr_t LPTGFCR; //!< SNVS_LP Tamper Glitch Filters Configuration Register
    volatile hw_snvs_lptdcr_t LPTDCR; //!< SNVS_LP Tamper Detectors Configuration Register
    volatile hw_snvs_lpsr_t LPSR; //!< SNVS _LP Status Register
    volatile hw_snvs_lpsrtcmr_t LPSRTCMR; //!< SNVS_LP Secure Real Time Counter MSB Register
    volatile hw_snvs_lpsrtclr_t LPSRTCLR; //!< SNVS_LP Secure Real Time Counter LSB Register
    volatile hw_snvs_lptar_t LPTAR; //!< SNVS_LP Time Alarm Register
    volatile hw_snvs_lpsmcmr_t LPSMCMR; //!< SNVS_LP Secure Monotonic Counter MSB Register
    volatile hw_snvs_lpsmclr_t LPSMCLR; //!< SNVS_LP Secure Monotonic Counter LSB Register
    volatile hw_snvs_lppgdr_t LPPGDR; //!< SNVS _LP Power Glitch Detector Register
    volatile hw_snvs_lpgpr_t LPGPR; //!< SNVS_LP General Purpose Register
    volatile hw_snvs_lpzmkrn_t LPZMKRn[8]; //!< SNVS_LP Zeroizable Master Key Register n
    reg32_t _reserved0[731];
    volatile hw_snvs_hpvidr1_t HPVIDR1; //!< SNVS _HP Version ID Register 1
    volatile hw_snvs_hpvidr2_t HPVIDR2; //!< SNVS _HP Version ID Register 2
} hw_snvs_t;
#pragma pack()

//! @brief Macro to access all SNVS registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_SNVS</code>.
#define HW_SNVS     (*(hw_snvs_t *) REGS_SNVS_BASE)
#endif

#endif // __HW_SNVS_REGISTERS_H__
// v18/121106/1.2.2
// EOF
