/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_PCIE_PL_REGISTERS_H__
#define __HW_PCIE_PL_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL PCIE_PL
 *
 * PCIE_PL
 *
 * Registers defined in this header file:
 * - HW_PCIE_PL_ALTRTR - Ack Latency Timer and Replay Timer Register
 * - HW_PCIE_PL_VSDR - Vendor Specific DLLP Register
 * - HW_PCIE_PL_PFLR - Port Force Link Register
 * - HW_PCIE_PL_AFLACR - Ack Frequency and L0-L1 ASPM Control Register
 * - HW_PCIE_PL_PLCR - Port Link Control Register
 * - HW_PCIE_PL_LSR - Lane Skew Register
 * - HW_PCIE_PL_SNR - Symbol Number Register
 * - HW_PCIE_PL_STRFM1 - Symbol Timer Register and Filter Mask Register 1
 * - HW_PCIE_PL_STRFM2 - Filter Mask Register 2
 * - HW_PCIE_PL_AMODNPSR - AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register
 * - HW_PCIE_PL_DEBUG0 - Debug Register 0
 * - HW_PCIE_PL_DEBUG1 - Debug Register 1
 * - HW_PCIE_PL_TPFCSR - Transmit Posted FC Credit Status Register
 * - HW_PCIE_PL_TNFCSR - Transmit Non-Posted FC Credit Status Register
 * - HW_PCIE_PL_TCFCSR - Transmit Completion FC Credit Status Register
 * - HW_PCIE_PL_QSR - Queue Status Register
 * - HW_PCIE_PL_VCTAR1 - VC Transmit Arbitration Register 1
 * - HW_PCIE_PL_VCTAR2 - VC Transmit Arbitration Register 2
 * - HW_PCIE_PL_VC0PRQC - VC0 Posted Receive Queue Control
 * - HW_PCIE_PL_VC0NRQC - VC0 Non-Posted Receive Queue Control
 * - HW_PCIE_PL_VC0CRQC - VC0 Completion Receive Queue Control
 * - HW_PCIE_PL_VCNPRQC - VCn Posted Receive Queue Control
 * - HW_PCIE_PL_VCNNRQC - VCn Non-Posted Receive Queue Control
 * - HW_PCIE_PL_VCNCRQC - VCn Completion Receive Queue Control
 * - HW_PCIE_PL_VC0PBD - VC0 Posted Buffer Depth
 * - HW_PCIE_PL_VC0NPBD - VC0 Non-Posted Buffer Depth
 * - HW_PCIE_PL_VC0CBD - VC0 Completion Buffer Depth
 * - HW_PCIE_PL_VC1PBD - VCn Posted Buffer Depth
 * - HW_PCIE_PL_VC1NPBD - VCn Non-Posted Buffer Depth
 * - HW_PCIE_PL_VC1CBD - VCnCompletion Buffer Depth
 * - HW_PCIE_PL_G2CR - Gen2 Control Register
 * - HW_PCIE_PL_PHY_STATUS - PHY Status
 * - HW_PCIE_PL_PHY_CTRL - PHY Control
 * - HW_PCIE_PL_MRCCR0 - Master Response Composer Control Register 0
 * - HW_PCIE_PL_MRCCR1 - Master Response Composer Control Register 1
 * - HW_PCIE_PL_MSICA - MSI Controller Address
 * - HW_PCIE_PL_MSICUA - MSI Controller Upper Address
 * - HW_PCIE_PL_MSICIN_ENB - MSI Controller Interrupt n Enable
 * - HW_PCIE_PL_MSICIN_MASK - MSI Controller Interrupt n Mask
 * - HW_PCIE_PL_MSICIN_STATUS - MSI Controller Interrupt nStatus
 * - HW_PCIE_PL_MSICGPIO - MSI Controller General Purpose IO Register
 * - HW_PCIE_PL_IATUVR - iATU Viewport Register
 * - HW_PCIE_PL_IATURC1 - iATU Region Control 1 Register
 * - HW_PCIE_PL_IATURC2 - iATU Region Control 2 Register
 * - HW_PCIE_PL_IATURLBA - iATU Region Lower Base Address Register
 * - HW_PCIE_PL_IATURUBA - iATU Region Upper Base Address Register
 * - HW_PCIE_PL_IATURLA - iATU Region Limit Address Register
 * - HW_PCIE_PL_IATURLTA - iATU Region Lower Target Address Register
 * - HW_PCIE_PL_IATURUTA - iATU Region Upper Target Address Register
 *
 * - hw_pcie_pl_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_PCIE_PL_BASE
#define HW_PCIE_PL_INSTANCE_COUNT (1) //!< Number of instances of the PCIE_PL module.
#define REGS_PCIE_PL_BASE (0x01ffc000) //!< Base address for PCIE_PL.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_ALTRTR - Ack Latency Timer and Replay Timer Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_ALTRTR - Ack Latency Timer and Replay Timer Register (RW)
 *
 * Reset value: 0x03b43677
 *
 * Offset: 0x700
 */
typedef union _hw_pcie_pl_altrtr
{
    reg32_t U;
    struct _hw_pcie_pl_altrtr_bitfields
    {
        unsigned ROUND_TRIP_LATENCY_TIME_LIMIT : 16; //!< [15:0] Round Trip Latency Time Limit
        unsigned REPLAY_TIME_LIMIT : 16; //!< [31:16] Replay Time Limit
    } B;
} hw_pcie_pl_altrtr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_ALTRTR register
 */
//@{
#define HW_PCIE_PL_ALTRTR_ADDR      (REGS_PCIE_PL_BASE + 0x700)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_ALTRTR           (*(volatile hw_pcie_pl_altrtr_t *) HW_PCIE_PL_ALTRTR_ADDR)
#define HW_PCIE_PL_ALTRTR_RD()      (HW_PCIE_PL_ALTRTR.U)
#define HW_PCIE_PL_ALTRTR_WR(v)     (HW_PCIE_PL_ALTRTR.U = (v))
#define HW_PCIE_PL_ALTRTR_SET(v)    (HW_PCIE_PL_ALTRTR_WR(HW_PCIE_PL_ALTRTR_RD() |  (v)))
#define HW_PCIE_PL_ALTRTR_CLR(v)    (HW_PCIE_PL_ALTRTR_WR(HW_PCIE_PL_ALTRTR_RD() & ~(v)))
#define HW_PCIE_PL_ALTRTR_TOG(v)    (HW_PCIE_PL_ALTRTR_WR(HW_PCIE_PL_ALTRTR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_ALTRTR bitfields
 */

/*! @name Register PCIE_PL_ALTRTR, field ROUND_TRIP_LATENCY_TIME_LIMIT[15:0] (RW)
 *
 * Round Trip Latency Time Limit The Ack/Nak latency timer expires when it reaches this limit. The
 * default value is 12429 / 2 = 5215. The default is then updated based on the Negotiated Link Width
 * and Max_Payload_Size. Note : If operating at 5 Gb/s, then an additional 153 / 2 = 76 is added.
 * This is for additional internal processing for received TLPs and transmitted DLLPs.
 */
//@{
#define BP_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT      (0)      //!< Bit position for PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT.
#define BM_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT      (0x0000ffff)  //!< Bit mask for PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT.

//! @brief Get value of PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT from a register value.
#define BG_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT) >> BP_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT)

//! @brief Format value for bitfield PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT.
#define BF_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT) & BM_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ROUND_TRIP_LATENCY_TIME_LIMIT field to a new value.
#define BW_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT(v)   (HW_PCIE_PL_ALTRTR_WR((HW_PCIE_PL_ALTRTR_RD() & ~BM_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT) | BF_PCIE_PL_ALTRTR_ROUND_TRIP_LATENCY_TIME_LIMIT(v)))
#endif
//@}

/*! @name Register PCIE_PL_ALTRTR, field REPLAY_TIME_LIMIT[31:16] (RW)
 *
 * Replay Time Limit The replay timer expires when it reaches this limit. The core initiates a
 * replay upon reception of a Nak or when the replay timer expires. The default value is 4143 / 2 =
 * 2071.. The default is then updated based on the Negotiated Link Width and Max_Payload_Size. If
 * operating at 5 Gb/s, then an additional 51 / 2 = 26 is added. This is for additional internal
 * processing for received TLPs and transmitted DLLPs.
 */
//@{
#define BP_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT      (16)      //!< Bit position for PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT.
#define BM_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT      (0xffff0000)  //!< Bit mask for PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT.

//! @brief Get value of PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT from a register value.
#define BG_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT) >> BP_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT)

//! @brief Format value for bitfield PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT.
#define BF_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT) & BM_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REPLAY_TIME_LIMIT field to a new value.
#define BW_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT(v)   (HW_PCIE_PL_ALTRTR_WR((HW_PCIE_PL_ALTRTR_RD() & ~BM_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT) | BF_PCIE_PL_ALTRTR_REPLAY_TIME_LIMIT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VSDR - Vendor Specific DLLP Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VSDR - Vendor Specific DLLP Register (RW)
 *
 * Reset value: 0xffffffff
 *
 * Offset: 0x700 + 0x4
 */
typedef union _hw_pcie_pl_vsdr
{
    reg32_t U;
    struct _hw_pcie_pl_vsdr_bitfields
    {
        unsigned VENDOR_SPECIFIC_DLLP : 32; //!< [31:0] Vendor Specific DLLP Register
    } B;
} hw_pcie_pl_vsdr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VSDR register
 */
//@{
#define HW_PCIE_PL_VSDR_ADDR      (REGS_PCIE_PL_BASE + 0x704)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VSDR           (*(volatile hw_pcie_pl_vsdr_t *) HW_PCIE_PL_VSDR_ADDR)
#define HW_PCIE_PL_VSDR_RD()      (HW_PCIE_PL_VSDR.U)
#define HW_PCIE_PL_VSDR_WR(v)     (HW_PCIE_PL_VSDR.U = (v))
#define HW_PCIE_PL_VSDR_SET(v)    (HW_PCIE_PL_VSDR_WR(HW_PCIE_PL_VSDR_RD() |  (v)))
#define HW_PCIE_PL_VSDR_CLR(v)    (HW_PCIE_PL_VSDR_WR(HW_PCIE_PL_VSDR_RD() & ~(v)))
#define HW_PCIE_PL_VSDR_TOG(v)    (HW_PCIE_PL_VSDR_WR(HW_PCIE_PL_VSDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VSDR bitfields
 */

/*! @name Register PCIE_PL_VSDR, field VENDOR_SPECIFIC_DLLP[31:0] (RW)
 *
 * Vendor Specific DLLP Register Used to send a specific PCI Express DLLP. The application writes
 * the 8-bit DLLP Type and 24-bits of Payload data into this register, then sets bit 0 of to send
 * the DLLP.
 */
//@{
#define BP_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP      (0)      //!< Bit position for PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP.
#define BM_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP      (0xffffffff)  //!< Bit mask for PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP.

//! @brief Get value of PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP from a register value.
#define BG_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP) >> BP_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP)

//! @brief Format value for bitfield PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP.
#define BF_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP) & BM_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VENDOR_SPECIFIC_DLLP field to a new value.
#define BW_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP(v)   (HW_PCIE_PL_VSDR_WR((HW_PCIE_PL_VSDR_RD() & ~BM_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP) | BF_PCIE_PL_VSDR_VENDOR_SPECIFIC_DLLP(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_PFLR - Port Force Link Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_PFLR - Port Force Link Register (RW)
 *
 * Reset value: 0x07000004
 *
 * Offset: 0x700 + 0x8
 */
typedef union _hw_pcie_pl_pflr
{
    reg32_t U;
    struct _hw_pcie_pl_pflr_bitfields
    {
        unsigned LINK_NUMBER : 8; //!< [7:0] Link Number
        unsigned RESERVED0 : 7; //!< [14:8] Reserved
        unsigned FORCE_LINK : 1; //!< [15] Force Link
        unsigned LINK_STATE : 6; //!< [21:16] Link State
        unsigned RESERVED1 : 2; //!< [23:22] Reserved
        unsigned LOW_POWER_ENTRANCE_COUNT : 8; //!< [31:24] Low Power Entrance Count
    } B;
} hw_pcie_pl_pflr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_PFLR register
 */
//@{
#define HW_PCIE_PL_PFLR_ADDR      (REGS_PCIE_PL_BASE + 0x708)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_PFLR           (*(volatile hw_pcie_pl_pflr_t *) HW_PCIE_PL_PFLR_ADDR)
#define HW_PCIE_PL_PFLR_RD()      (HW_PCIE_PL_PFLR.U)
#define HW_PCIE_PL_PFLR_WR(v)     (HW_PCIE_PL_PFLR.U = (v))
#define HW_PCIE_PL_PFLR_SET(v)    (HW_PCIE_PL_PFLR_WR(HW_PCIE_PL_PFLR_RD() |  (v)))
#define HW_PCIE_PL_PFLR_CLR(v)    (HW_PCIE_PL_PFLR_WR(HW_PCIE_PL_PFLR_RD() & ~(v)))
#define HW_PCIE_PL_PFLR_TOG(v)    (HW_PCIE_PL_PFLR_WR(HW_PCIE_PL_PFLR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_PFLR bitfields
 */

/*! @name Register PCIE_PL_PFLR, field LINK_NUMBER[7:0] (RW)
 *
 * Link Number Not used for Endpoint
 */
//@{
#define BP_PCIE_PL_PFLR_LINK_NUMBER      (0)      //!< Bit position for PCIE_PL_PFLR_LINK_NUMBER.
#define BM_PCIE_PL_PFLR_LINK_NUMBER      (0x000000ff)  //!< Bit mask for PCIE_PL_PFLR_LINK_NUMBER.

//! @brief Get value of PCIE_PL_PFLR_LINK_NUMBER from a register value.
#define BG_PCIE_PL_PFLR_LINK_NUMBER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PFLR_LINK_NUMBER) >> BP_PCIE_PL_PFLR_LINK_NUMBER)

//! @brief Format value for bitfield PCIE_PL_PFLR_LINK_NUMBER.
#define BF_PCIE_PL_PFLR_LINK_NUMBER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PFLR_LINK_NUMBER) & BM_PCIE_PL_PFLR_LINK_NUMBER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINK_NUMBER field to a new value.
#define BW_PCIE_PL_PFLR_LINK_NUMBER(v)   (HW_PCIE_PL_PFLR_WR((HW_PCIE_PL_PFLR_RD() & ~BM_PCIE_PL_PFLR_LINK_NUMBER) | BF_PCIE_PL_PFLR_LINK_NUMBER(v)))
#endif
//@}

/*! @name Register PCIE_PL_PFLR, field FORCE_LINK[15] (RW)
 *
 * Force Link Forces the Link to the state specified by the Link State field. The Force Link pulse
 * will trigger Link re-negotiation. * Reading from this self-clearing register field always returns
 * a 0.
 */
//@{
#define BP_PCIE_PL_PFLR_FORCE_LINK      (15)      //!< Bit position for PCIE_PL_PFLR_FORCE_LINK.
#define BM_PCIE_PL_PFLR_FORCE_LINK      (0x00008000)  //!< Bit mask for PCIE_PL_PFLR_FORCE_LINK.

//! @brief Get value of PCIE_PL_PFLR_FORCE_LINK from a register value.
#define BG_PCIE_PL_PFLR_FORCE_LINK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PFLR_FORCE_LINK) >> BP_PCIE_PL_PFLR_FORCE_LINK)

//! @brief Format value for bitfield PCIE_PL_PFLR_FORCE_LINK.
#define BF_PCIE_PL_PFLR_FORCE_LINK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PFLR_FORCE_LINK) & BM_PCIE_PL_PFLR_FORCE_LINK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FORCE_LINK field to a new value.
#define BW_PCIE_PL_PFLR_FORCE_LINK(v)   (HW_PCIE_PL_PFLR_WR((HW_PCIE_PL_PFLR_RD() & ~BM_PCIE_PL_PFLR_FORCE_LINK) | BF_PCIE_PL_PFLR_FORCE_LINK(v)))
#endif
//@}

/*! @name Register PCIE_PL_PFLR, field LINK_STATE[21:16] (RW)
 *
 * Link State The Link state that the core will be forced to when bit 15 (Force Link) is set. State
 * encoding is defined in xmlh_ltssm.v.
 */
//@{
#define BP_PCIE_PL_PFLR_LINK_STATE      (16)      //!< Bit position for PCIE_PL_PFLR_LINK_STATE.
#define BM_PCIE_PL_PFLR_LINK_STATE      (0x003f0000)  //!< Bit mask for PCIE_PL_PFLR_LINK_STATE.

//! @brief Get value of PCIE_PL_PFLR_LINK_STATE from a register value.
#define BG_PCIE_PL_PFLR_LINK_STATE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PFLR_LINK_STATE) >> BP_PCIE_PL_PFLR_LINK_STATE)

//! @brief Format value for bitfield PCIE_PL_PFLR_LINK_STATE.
#define BF_PCIE_PL_PFLR_LINK_STATE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PFLR_LINK_STATE) & BM_PCIE_PL_PFLR_LINK_STATE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINK_STATE field to a new value.
#define BW_PCIE_PL_PFLR_LINK_STATE(v)   (HW_PCIE_PL_PFLR_WR((HW_PCIE_PL_PFLR_RD() & ~BM_PCIE_PL_PFLR_LINK_STATE) | BF_PCIE_PL_PFLR_LINK_STATE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PFLR, field LOW_POWER_ENTRANCE_COUNT[31:24] (RW)
 *
 * Low Power Entrance Count The Power Management state will wait for this many clock cycles for the
 * associated completion of a CfgWr to D-state register to go low-power. This register is intended
 * for applications that do not let the core handle a completion for configuration request to the
 * PMCSCR register. Note : Only used in the DM core (in EP mode), EP core, and the upstream port of
 * a Switch.
 */
//@{
#define BP_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT      (24)      //!< Bit position for PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT.
#define BM_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT      (0xff000000)  //!< Bit mask for PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT.

//! @brief Get value of PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT from a register value.
#define BG_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT) >> BP_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT)

//! @brief Format value for bitfield PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT.
#define BF_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT) & BM_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOW_POWER_ENTRANCE_COUNT field to a new value.
#define BW_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT(v)   (HW_PCIE_PL_PFLR_WR((HW_PCIE_PL_PFLR_RD() & ~BM_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT) | BF_PCIE_PL_PFLR_LOW_POWER_ENTRANCE_COUNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_AFLACR - Ack Frequency and L0-L1 ASPM Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_AFLACR - Ack Frequency and L0-L1 ASPM Control Register (RW)
 *
 * Reset value: 0x1b2c2c00
 *
 * Offset: 0x700 + 0xC
 */
typedef union _hw_pcie_pl_aflacr
{
    reg32_t U;
    struct _hw_pcie_pl_aflacr_bitfields
    {
        unsigned ACK_FREQUENCY : 8; //!< [7:0] Ack Frequency
        unsigned N_FTS : 8; //!< [15:8] N_FTS
        unsigned COMMON_CLOCK_N_FTS : 8; //!< [23:16] Common Clock N_FTS
        unsigned L0S_ENTRANCE_LATENCY : 3; //!< [26:24] L0s Entrance Latency
        unsigned L1_ENTRANCE_LATENCY : 3; //!< [29:27] L1 Entrance Latency
        unsigned ENTER_ASPM_L1 : 1; //!< [30] Enter ASPM L1 without receive in L0s.
        unsigned RESERVED0 : 1; //!< [31] Reserved
    } B;
} hw_pcie_pl_aflacr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_AFLACR register
 */
//@{
#define HW_PCIE_PL_AFLACR_ADDR      (REGS_PCIE_PL_BASE + 0x70c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_AFLACR           (*(volatile hw_pcie_pl_aflacr_t *) HW_PCIE_PL_AFLACR_ADDR)
#define HW_PCIE_PL_AFLACR_RD()      (HW_PCIE_PL_AFLACR.U)
#define HW_PCIE_PL_AFLACR_WR(v)     (HW_PCIE_PL_AFLACR.U = (v))
#define HW_PCIE_PL_AFLACR_SET(v)    (HW_PCIE_PL_AFLACR_WR(HW_PCIE_PL_AFLACR_RD() |  (v)))
#define HW_PCIE_PL_AFLACR_CLR(v)    (HW_PCIE_PL_AFLACR_WR(HW_PCIE_PL_AFLACR_RD() & ~(v)))
#define HW_PCIE_PL_AFLACR_TOG(v)    (HW_PCIE_PL_AFLACR_WR(HW_PCIE_PL_AFLACR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_AFLACR bitfields
 */

/*! @name Register PCIE_PL_AFLACR, field ACK_FREQUENCY[7:0] (RW)
 *
 * Ack Frequency The core accumulates the number of pending Ack's specified here (up to 255) before
 * sending an Ack DLLP see for more details.
 */
//@{
#define BP_PCIE_PL_AFLACR_ACK_FREQUENCY      (0)      //!< Bit position for PCIE_PL_AFLACR_ACK_FREQUENCY.
#define BM_PCIE_PL_AFLACR_ACK_FREQUENCY      (0x000000ff)  //!< Bit mask for PCIE_PL_AFLACR_ACK_FREQUENCY.

//! @brief Get value of PCIE_PL_AFLACR_ACK_FREQUENCY from a register value.
#define BG_PCIE_PL_AFLACR_ACK_FREQUENCY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_ACK_FREQUENCY) >> BP_PCIE_PL_AFLACR_ACK_FREQUENCY)

//! @brief Format value for bitfield PCIE_PL_AFLACR_ACK_FREQUENCY.
#define BF_PCIE_PL_AFLACR_ACK_FREQUENCY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_ACK_FREQUENCY) & BM_PCIE_PL_AFLACR_ACK_FREQUENCY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACK_FREQUENCY field to a new value.
#define BW_PCIE_PL_AFLACR_ACK_FREQUENCY(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_ACK_FREQUENCY) | BF_PCIE_PL_AFLACR_ACK_FREQUENCY(v)))
#endif
//@}

/*! @name Register PCIE_PL_AFLACR, field N_FTS[15:8] (RW)
 *
 * N_FTS The number of Fast Training Sequence ordered sets to be transmitted when transitioning from
 * L0s to L0. The maximum number of FTS ordered-sets that a component can request is 255. Note : The
 * core does not support a value of zero; a value of zero can cause the LTSSM to go into the
 * recovery state when exiting from L0s.
 */
//@{
#define BP_PCIE_PL_AFLACR_N_FTS      (8)      //!< Bit position for PCIE_PL_AFLACR_N_FTS.
#define BM_PCIE_PL_AFLACR_N_FTS      (0x0000ff00)  //!< Bit mask for PCIE_PL_AFLACR_N_FTS.

//! @brief Get value of PCIE_PL_AFLACR_N_FTS from a register value.
#define BG_PCIE_PL_AFLACR_N_FTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_N_FTS) >> BP_PCIE_PL_AFLACR_N_FTS)

//! @brief Format value for bitfield PCIE_PL_AFLACR_N_FTS.
#define BF_PCIE_PL_AFLACR_N_FTS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_N_FTS) & BM_PCIE_PL_AFLACR_N_FTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the N_FTS field to a new value.
#define BW_PCIE_PL_AFLACR_N_FTS(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_N_FTS) | BF_PCIE_PL_AFLACR_N_FTS(v)))
#endif
//@}

/*! @name Register PCIE_PL_AFLACR, field COMMON_CLOCK_N_FTS[23:16] (RW)
 *
 * Common Clock N_FTS This is the N_FTS when common clock is used. The number of Fast Training
 * Sequence ordered sets to be transmitted when transitioning from L0s to L0. The maximum number of
 * FTS ordered-sets that a component can request is 255. This field is writable only if the
 * parameters are selected as follows during configuration of the core; CX_NFTS != CX_COMM_NFTS
 * DEFAULT_L0S_EXIT_LATENCY != DEFAULT_COMM_L0S_EXIT_LATENCY DEFAULT_L1_EXIT_LATENCY !=
 * DEFAULT_COMM_L1_EXIT_LATENCY otherwise, it will be hard coded to the value of the CX_COMM_NFTS
 * configuration parameter. Note : The core does not support a value of zero; a value of zero can
 * cause the LTSSM to go into the recovery state when exiting from L0s.
 */
//@{
#define BP_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS      (16)      //!< Bit position for PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS.
#define BM_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS      (0x00ff0000)  //!< Bit mask for PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS.

//! @brief Get value of PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS from a register value.
#define BG_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS) >> BP_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS)

//! @brief Format value for bitfield PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS.
#define BF_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS) & BM_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMMON_CLOCK_N_FTS field to a new value.
#define BW_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS) | BF_PCIE_PL_AFLACR_COMMON_CLOCK_N_FTS(v)))
#endif
//@}

/*! @name Register PCIE_PL_AFLACR, field L0S_ENTRANCE_LATENCY[26:24] (RW)
 *
 * L0s Entrance Latency Values correspond to:
 *
 * Values:
 * - 000 - 1 ìs
 * - 001 - 2 ìs
 * - 010 - 3 ìs
 * - 011 - 4 ìs
 * - 100 - 5 ìs
 * - 101 - 6 ìs
 * - 110 - 7 ìs
 * - 111 - 7 ìs
 */
//@{
#define BP_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY      (24)      //!< Bit position for PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY.
#define BM_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY      (0x07000000)  //!< Bit mask for PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY.

//! @brief Get value of PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY from a register value.
#define BG_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY) >> BP_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY)

//! @brief Format value for bitfield PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY.
#define BF_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY) & BM_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L0S_ENTRANCE_LATENCY field to a new value.
#define BW_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY) | BF_PCIE_PL_AFLACR_L0S_ENTRANCE_LATENCY(v)))
#endif
//@}

/*! @name Register PCIE_PL_AFLACR, field L1_ENTRANCE_LATENCY[29:27] (RW)
 *
 * L1 Entrance Latency Values correspond to:
 *
 * Values:
 * - 000 - 1 ìs
 * - 001 - 2 ìs
 * - 010 - 4 ìs
 * - 011 - 8 ìs
 * - 100 - 16 ìs
 * - 101 - 32 ìs
 * - 110 - 64 ìs
 * - 111 - 64 ìs
 */
//@{
#define BP_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY      (27)      //!< Bit position for PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY.
#define BM_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY      (0x38000000)  //!< Bit mask for PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY.

//! @brief Get value of PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY from a register value.
#define BG_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY) >> BP_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY)

//! @brief Format value for bitfield PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY.
#define BF_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY) & BM_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L1_ENTRANCE_LATENCY field to a new value.
#define BW_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY) | BF_PCIE_PL_AFLACR_L1_ENTRANCE_LATENCY(v)))
#endif
//@}

/*! @name Register PCIE_PL_AFLACR, field ENTER_ASPM_L1[30] (RW)
 *
 * Enter ASPM L1 without receive in L0s. Allow core to enter ASPM L1 even when link partner did not
 * go to L0s (receive is not in L0s). When not set, core goes to ASPM L1 only after idle period
 * during which both receive and transmit are in L0s.
 */
//@{
#define BP_PCIE_PL_AFLACR_ENTER_ASPM_L1      (30)      //!< Bit position for PCIE_PL_AFLACR_ENTER_ASPM_L1.
#define BM_PCIE_PL_AFLACR_ENTER_ASPM_L1      (0x40000000)  //!< Bit mask for PCIE_PL_AFLACR_ENTER_ASPM_L1.

//! @brief Get value of PCIE_PL_AFLACR_ENTER_ASPM_L1 from a register value.
#define BG_PCIE_PL_AFLACR_ENTER_ASPM_L1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AFLACR_ENTER_ASPM_L1) >> BP_PCIE_PL_AFLACR_ENTER_ASPM_L1)

//! @brief Format value for bitfield PCIE_PL_AFLACR_ENTER_ASPM_L1.
#define BF_PCIE_PL_AFLACR_ENTER_ASPM_L1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AFLACR_ENTER_ASPM_L1) & BM_PCIE_PL_AFLACR_ENTER_ASPM_L1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENTER_ASPM_L1 field to a new value.
#define BW_PCIE_PL_AFLACR_ENTER_ASPM_L1(v)   (HW_PCIE_PL_AFLACR_WR((HW_PCIE_PL_AFLACR_RD() & ~BM_PCIE_PL_AFLACR_ENTER_ASPM_L1) | BF_PCIE_PL_AFLACR_ENTER_ASPM_L1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_PLCR - Port Link Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_PLCR - Port Link Control Register (RW)
 *
 * Reset value: 0x00010020
 *
 * Offset: 0x700 + 0x10
 */
typedef union _hw_pcie_pl_plcr
{
    reg32_t U;
    struct _hw_pcie_pl_plcr_bitfields
    {
        unsigned VENDOR_SPECIFIC_DLLP_REQUEST : 1; //!< [0] Vendor Specific DLLP Request
        unsigned SCRAMBLE_DISABLE : 1; //!< [1] Scramble Disable
        unsigned LOOPBACK_ENABLE : 1; //!< [2] Loopback Enable
        unsigned RESET_ASSERT : 1; //!< [3] Reset Assert
        unsigned RESERVED0 : 1; //!< [4] Reserved
        unsigned DLL_LINK_ENABLE : 1; //!< [5] DLL Link Enable
        unsigned RESERVED1 : 1; //!< [6] Reserved
        unsigned FAST_LINK_MODE : 1; //!< [7] Fast Link Mode
        unsigned RESERVED2 : 8; //!< [15:8] Reserved
        unsigned LINK_MODE_ENABLE : 6; //!< [21:16] Link Mode Enable
        unsigned CROSSLINK_ENABLE : 1; //!< [22] Crosslink Enable
        unsigned CROSSLINK_ACTIVE : 1; //!< [23] Crosslink Active.
        unsigned RESERVED3 : 8; //!< [31:24] Reserved
    } B;
} hw_pcie_pl_plcr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_PLCR register
 */
//@{
#define HW_PCIE_PL_PLCR_ADDR      (REGS_PCIE_PL_BASE + 0x710)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_PLCR           (*(volatile hw_pcie_pl_plcr_t *) HW_PCIE_PL_PLCR_ADDR)
#define HW_PCIE_PL_PLCR_RD()      (HW_PCIE_PL_PLCR.U)
#define HW_PCIE_PL_PLCR_WR(v)     (HW_PCIE_PL_PLCR.U = (v))
#define HW_PCIE_PL_PLCR_SET(v)    (HW_PCIE_PL_PLCR_WR(HW_PCIE_PL_PLCR_RD() |  (v)))
#define HW_PCIE_PL_PLCR_CLR(v)    (HW_PCIE_PL_PLCR_WR(HW_PCIE_PL_PLCR_RD() & ~(v)))
#define HW_PCIE_PL_PLCR_TOG(v)    (HW_PCIE_PL_PLCR_WR(HW_PCIE_PL_PLCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_PLCR bitfields
 */

/*! @name Register PCIE_PL_PLCR, field VENDOR_SPECIFIC_DLLP_REQUEST[0] (RW)
 *
 * Vendor Specific DLLP Request When software writes a '1' to this bit, the core transmits the DLLP
 * contained in the . * Reading from this self-clearing register field always returns a 0.
 */
//@{
#define BP_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST      (0)      //!< Bit position for PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST.
#define BM_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST      (0x00000001)  //!< Bit mask for PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST.

//! @brief Get value of PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST from a register value.
#define BG_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST) >> BP_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST)

//! @brief Format value for bitfield PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST.
#define BF_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST) & BM_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VENDOR_SPECIFIC_DLLP_REQUEST field to a new value.
#define BW_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST) | BF_PCIE_PL_PLCR_VENDOR_SPECIFIC_DLLP_REQUEST(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field SCRAMBLE_DISABLE[1] (RW)
 *
 * Scramble Disable Turns off data scrambling.
 */
//@{
#define BP_PCIE_PL_PLCR_SCRAMBLE_DISABLE      (1)      //!< Bit position for PCIE_PL_PLCR_SCRAMBLE_DISABLE.
#define BM_PCIE_PL_PLCR_SCRAMBLE_DISABLE      (0x00000002)  //!< Bit mask for PCIE_PL_PLCR_SCRAMBLE_DISABLE.

//! @brief Get value of PCIE_PL_PLCR_SCRAMBLE_DISABLE from a register value.
#define BG_PCIE_PL_PLCR_SCRAMBLE_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_SCRAMBLE_DISABLE) >> BP_PCIE_PL_PLCR_SCRAMBLE_DISABLE)

//! @brief Format value for bitfield PCIE_PL_PLCR_SCRAMBLE_DISABLE.
#define BF_PCIE_PL_PLCR_SCRAMBLE_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_SCRAMBLE_DISABLE) & BM_PCIE_PL_PLCR_SCRAMBLE_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SCRAMBLE_DISABLE field to a new value.
#define BW_PCIE_PL_PLCR_SCRAMBLE_DISABLE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_SCRAMBLE_DISABLE) | BF_PCIE_PL_PLCR_SCRAMBLE_DISABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field LOOPBACK_ENABLE[2] (RW)
 *
 * Loopback Enable Turns on loopback.
 */
//@{
#define BP_PCIE_PL_PLCR_LOOPBACK_ENABLE      (2)      //!< Bit position for PCIE_PL_PLCR_LOOPBACK_ENABLE.
#define BM_PCIE_PL_PLCR_LOOPBACK_ENABLE      (0x00000004)  //!< Bit mask for PCIE_PL_PLCR_LOOPBACK_ENABLE.

//! @brief Get value of PCIE_PL_PLCR_LOOPBACK_ENABLE from a register value.
#define BG_PCIE_PL_PLCR_LOOPBACK_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_LOOPBACK_ENABLE) >> BP_PCIE_PL_PLCR_LOOPBACK_ENABLE)

//! @brief Format value for bitfield PCIE_PL_PLCR_LOOPBACK_ENABLE.
#define BF_PCIE_PL_PLCR_LOOPBACK_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_LOOPBACK_ENABLE) & BM_PCIE_PL_PLCR_LOOPBACK_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOOPBACK_ENABLE field to a new value.
#define BW_PCIE_PL_PLCR_LOOPBACK_ENABLE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_LOOPBACK_ENABLE) | BF_PCIE_PL_PLCR_LOOPBACK_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field RESET_ASSERT[3] (RW)
 *
 * Reset Assert Triggers a recovery and forces the LTSSM to the Hot Reset state (downstream port
 * only).
 */
//@{
#define BP_PCIE_PL_PLCR_RESET_ASSERT      (3)      //!< Bit position for PCIE_PL_PLCR_RESET_ASSERT.
#define BM_PCIE_PL_PLCR_RESET_ASSERT      (0x00000008)  //!< Bit mask for PCIE_PL_PLCR_RESET_ASSERT.

//! @brief Get value of PCIE_PL_PLCR_RESET_ASSERT from a register value.
#define BG_PCIE_PL_PLCR_RESET_ASSERT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_RESET_ASSERT) >> BP_PCIE_PL_PLCR_RESET_ASSERT)

//! @brief Format value for bitfield PCIE_PL_PLCR_RESET_ASSERT.
#define BF_PCIE_PL_PLCR_RESET_ASSERT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_RESET_ASSERT) & BM_PCIE_PL_PLCR_RESET_ASSERT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESET_ASSERT field to a new value.
#define BW_PCIE_PL_PLCR_RESET_ASSERT(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_RESET_ASSERT) | BF_PCIE_PL_PLCR_RESET_ASSERT(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field DLL_LINK_ENABLE[5] (RW)
 *
 * DLL Link Enable Enables Link initialization. If DLL Link Enable = 0, the core does not transmit
 * InitFC DLLPs and does not establish a Link.
 */
//@{
#define BP_PCIE_PL_PLCR_DLL_LINK_ENABLE      (5)      //!< Bit position for PCIE_PL_PLCR_DLL_LINK_ENABLE.
#define BM_PCIE_PL_PLCR_DLL_LINK_ENABLE      (0x00000020)  //!< Bit mask for PCIE_PL_PLCR_DLL_LINK_ENABLE.

//! @brief Get value of PCIE_PL_PLCR_DLL_LINK_ENABLE from a register value.
#define BG_PCIE_PL_PLCR_DLL_LINK_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_DLL_LINK_ENABLE) >> BP_PCIE_PL_PLCR_DLL_LINK_ENABLE)

//! @brief Format value for bitfield PCIE_PL_PLCR_DLL_LINK_ENABLE.
#define BF_PCIE_PL_PLCR_DLL_LINK_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_DLL_LINK_ENABLE) & BM_PCIE_PL_PLCR_DLL_LINK_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DLL_LINK_ENABLE field to a new value.
#define BW_PCIE_PL_PLCR_DLL_LINK_ENABLE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_DLL_LINK_ENABLE) | BF_PCIE_PL_PLCR_DLL_LINK_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field FAST_LINK_MODE[7] (RW)
 *
 * Fast Link Mode Sets all internal timers to Fast Mode for speeding up simulation. Forces the LTSSM
 * training (link initialization) to use shorter time-outs and to link up faster. The scaling factor
 * is 1024 for all internal timers. Note : Fast Link Mode can also be activated by setting the
 * diag_ctrl_bus[2] pin to '1'.
 */
//@{
#define BP_PCIE_PL_PLCR_FAST_LINK_MODE      (7)      //!< Bit position for PCIE_PL_PLCR_FAST_LINK_MODE.
#define BM_PCIE_PL_PLCR_FAST_LINK_MODE      (0x00000080)  //!< Bit mask for PCIE_PL_PLCR_FAST_LINK_MODE.

//! @brief Get value of PCIE_PL_PLCR_FAST_LINK_MODE from a register value.
#define BG_PCIE_PL_PLCR_FAST_LINK_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_FAST_LINK_MODE) >> BP_PCIE_PL_PLCR_FAST_LINK_MODE)

//! @brief Format value for bitfield PCIE_PL_PLCR_FAST_LINK_MODE.
#define BF_PCIE_PL_PLCR_FAST_LINK_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_FAST_LINK_MODE) & BM_PCIE_PL_PLCR_FAST_LINK_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAST_LINK_MODE field to a new value.
#define BW_PCIE_PL_PLCR_FAST_LINK_MODE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_FAST_LINK_MODE) | BF_PCIE_PL_PLCR_FAST_LINK_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field LINK_MODE_ENABLE[21:16] (RW)
 *
 * Link Mode Enable The default value is the number of Lanes supported in the version of the core
 * you are using.
 *
 * Values:
 * - 000001 - x1
 * - 000011 - x2
 * - 000111 - x4
 * - 001111 - x8
 * - 011111 - x16
 * - 111111 - x32 (not supported)
 */
//@{
#define BP_PCIE_PL_PLCR_LINK_MODE_ENABLE      (16)      //!< Bit position for PCIE_PL_PLCR_LINK_MODE_ENABLE.
#define BM_PCIE_PL_PLCR_LINK_MODE_ENABLE      (0x003f0000)  //!< Bit mask for PCIE_PL_PLCR_LINK_MODE_ENABLE.

//! @brief Get value of PCIE_PL_PLCR_LINK_MODE_ENABLE from a register value.
#define BG_PCIE_PL_PLCR_LINK_MODE_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_LINK_MODE_ENABLE) >> BP_PCIE_PL_PLCR_LINK_MODE_ENABLE)

//! @brief Format value for bitfield PCIE_PL_PLCR_LINK_MODE_ENABLE.
#define BF_PCIE_PL_PLCR_LINK_MODE_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_LINK_MODE_ENABLE) & BM_PCIE_PL_PLCR_LINK_MODE_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINK_MODE_ENABLE field to a new value.
#define BW_PCIE_PL_PLCR_LINK_MODE_ENABLE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_LINK_MODE_ENABLE) | BF_PCIE_PL_PLCR_LINK_MODE_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field CROSSLINK_ENABLE[22] (RW)
 *
 * Crosslink Enable
 */
//@{
#define BP_PCIE_PL_PLCR_CROSSLINK_ENABLE      (22)      //!< Bit position for PCIE_PL_PLCR_CROSSLINK_ENABLE.
#define BM_PCIE_PL_PLCR_CROSSLINK_ENABLE      (0x00400000)  //!< Bit mask for PCIE_PL_PLCR_CROSSLINK_ENABLE.

//! @brief Get value of PCIE_PL_PLCR_CROSSLINK_ENABLE from a register value.
#define BG_PCIE_PL_PLCR_CROSSLINK_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_CROSSLINK_ENABLE) >> BP_PCIE_PL_PLCR_CROSSLINK_ENABLE)

//! @brief Format value for bitfield PCIE_PL_PLCR_CROSSLINK_ENABLE.
#define BF_PCIE_PL_PLCR_CROSSLINK_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_CROSSLINK_ENABLE) & BM_PCIE_PL_PLCR_CROSSLINK_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CROSSLINK_ENABLE field to a new value.
#define BW_PCIE_PL_PLCR_CROSSLINK_ENABLE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_CROSSLINK_ENABLE) | BF_PCIE_PL_PLCR_CROSSLINK_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_PLCR, field CROSSLINK_ACTIVE[23] (RW)
 *
 * Crosslink Active. Indicates a change from upstream to downstream or downstream to upstream. Same
 * as the xmlh_crosslink_active output.
 */
//@{
#define BP_PCIE_PL_PLCR_CROSSLINK_ACTIVE      (23)      //!< Bit position for PCIE_PL_PLCR_CROSSLINK_ACTIVE.
#define BM_PCIE_PL_PLCR_CROSSLINK_ACTIVE      (0x00800000)  //!< Bit mask for PCIE_PL_PLCR_CROSSLINK_ACTIVE.

//! @brief Get value of PCIE_PL_PLCR_CROSSLINK_ACTIVE from a register value.
#define BG_PCIE_PL_PLCR_CROSSLINK_ACTIVE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PLCR_CROSSLINK_ACTIVE) >> BP_PCIE_PL_PLCR_CROSSLINK_ACTIVE)

//! @brief Format value for bitfield PCIE_PL_PLCR_CROSSLINK_ACTIVE.
#define BF_PCIE_PL_PLCR_CROSSLINK_ACTIVE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PLCR_CROSSLINK_ACTIVE) & BM_PCIE_PL_PLCR_CROSSLINK_ACTIVE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CROSSLINK_ACTIVE field to a new value.
#define BW_PCIE_PL_PLCR_CROSSLINK_ACTIVE(v)   (HW_PCIE_PL_PLCR_WR((HW_PCIE_PL_PLCR_RD() & ~BM_PCIE_PL_PLCR_CROSSLINK_ACTIVE) | BF_PCIE_PL_PLCR_CROSSLINK_ACTIVE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_LSR - Lane Skew Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_LSR - Lane Skew Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x14
 */
typedef union _hw_pcie_pl_lsr
{
    reg32_t U;
    struct _hw_pcie_pl_lsr_bitfields
    {
        unsigned INSERT_LANE_SKEW_FOR_TRANSMIT : 24; //!< [23:0] Insert Lane Skew for Transmit (not supported for x16)
        unsigned FLOW_CONTROL_DISABLE : 1; //!< [24] Flow Control Disable
        unsigned ACK_NAK_DISABLE : 1; //!< [25] Ack/Nak Disable
        unsigned RESERVED0 : 5; //!< [30:26] Reserved
        unsigned DISABLE_LANE_TO_LANE_DESKEW : 1; //!< [31] Disable Lane-to-Lane Deskew
    } B;
} hw_pcie_pl_lsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_LSR register
 */
//@{
#define HW_PCIE_PL_LSR_ADDR      (REGS_PCIE_PL_BASE + 0x714)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_LSR           (*(volatile hw_pcie_pl_lsr_t *) HW_PCIE_PL_LSR_ADDR)
#define HW_PCIE_PL_LSR_RD()      (HW_PCIE_PL_LSR.U)
#define HW_PCIE_PL_LSR_WR(v)     (HW_PCIE_PL_LSR.U = (v))
#define HW_PCIE_PL_LSR_SET(v)    (HW_PCIE_PL_LSR_WR(HW_PCIE_PL_LSR_RD() |  (v)))
#define HW_PCIE_PL_LSR_CLR(v)    (HW_PCIE_PL_LSR_WR(HW_PCIE_PL_LSR_RD() & ~(v)))
#define HW_PCIE_PL_LSR_TOG(v)    (HW_PCIE_PL_LSR_WR(HW_PCIE_PL_LSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_LSR bitfields
 */

/*! @name Register PCIE_PL_LSR, field INSERT_LANE_SKEW_FOR_TRANSMIT[23:0] (RW)
 *
 * Insert Lane Skew for Transmit (not supported for x16) Optional feature that causes the core to
 * insert skew between Lanes for test purposes. There are three bits per Lane. The value is in units
 * of one symbol time. For example, the value 010b for a Lane forces a skew of two symbol times for
 * that Lane. The maximum skew value for any Lane is 5 symbol times.
 */
//@{
#define BP_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT      (0)      //!< Bit position for PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT.
#define BM_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT      (0x00ffffff)  //!< Bit mask for PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT.

//! @brief Get value of PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT from a register value.
#define BG_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT) >> BP_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT)

//! @brief Format value for bitfield PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT.
#define BF_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT) & BM_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INSERT_LANE_SKEW_FOR_TRANSMIT field to a new value.
#define BW_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT(v)   (HW_PCIE_PL_LSR_WR((HW_PCIE_PL_LSR_RD() & ~BM_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT) | BF_PCIE_PL_LSR_INSERT_LANE_SKEW_FOR_TRANSMIT(v)))
#endif
//@}

/*! @name Register PCIE_PL_LSR, field FLOW_CONTROL_DISABLE[24] (RW)
 *
 * Flow Control Disable Prevents the core from sending FC DLLPs.
 */
//@{
#define BP_PCIE_PL_LSR_FLOW_CONTROL_DISABLE      (24)      //!< Bit position for PCIE_PL_LSR_FLOW_CONTROL_DISABLE.
#define BM_PCIE_PL_LSR_FLOW_CONTROL_DISABLE      (0x01000000)  //!< Bit mask for PCIE_PL_LSR_FLOW_CONTROL_DISABLE.

//! @brief Get value of PCIE_PL_LSR_FLOW_CONTROL_DISABLE from a register value.
#define BG_PCIE_PL_LSR_FLOW_CONTROL_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_LSR_FLOW_CONTROL_DISABLE) >> BP_PCIE_PL_LSR_FLOW_CONTROL_DISABLE)

//! @brief Format value for bitfield PCIE_PL_LSR_FLOW_CONTROL_DISABLE.
#define BF_PCIE_PL_LSR_FLOW_CONTROL_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_LSR_FLOW_CONTROL_DISABLE) & BM_PCIE_PL_LSR_FLOW_CONTROL_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLOW_CONTROL_DISABLE field to a new value.
#define BW_PCIE_PL_LSR_FLOW_CONTROL_DISABLE(v)   (HW_PCIE_PL_LSR_WR((HW_PCIE_PL_LSR_RD() & ~BM_PCIE_PL_LSR_FLOW_CONTROL_DISABLE) | BF_PCIE_PL_LSR_FLOW_CONTROL_DISABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_LSR, field ACK_NAK_DISABLE[25] (RW)
 *
 * Ack/Nak Disable Prevents the core from sending Ack and Nak DLLPs.
 */
//@{
#define BP_PCIE_PL_LSR_ACK_NAK_DISABLE      (25)      //!< Bit position for PCIE_PL_LSR_ACK_NAK_DISABLE.
#define BM_PCIE_PL_LSR_ACK_NAK_DISABLE      (0x02000000)  //!< Bit mask for PCIE_PL_LSR_ACK_NAK_DISABLE.

//! @brief Get value of PCIE_PL_LSR_ACK_NAK_DISABLE from a register value.
#define BG_PCIE_PL_LSR_ACK_NAK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_LSR_ACK_NAK_DISABLE) >> BP_PCIE_PL_LSR_ACK_NAK_DISABLE)

//! @brief Format value for bitfield PCIE_PL_LSR_ACK_NAK_DISABLE.
#define BF_PCIE_PL_LSR_ACK_NAK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_LSR_ACK_NAK_DISABLE) & BM_PCIE_PL_LSR_ACK_NAK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACK_NAK_DISABLE field to a new value.
#define BW_PCIE_PL_LSR_ACK_NAK_DISABLE(v)   (HW_PCIE_PL_LSR_WR((HW_PCIE_PL_LSR_RD() & ~BM_PCIE_PL_LSR_ACK_NAK_DISABLE) | BF_PCIE_PL_LSR_ACK_NAK_DISABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_LSR, field DISABLE_LANE_TO_LANE_DESKEW[31] (RW)
 *
 * Disable Lane-to-Lane Deskew Causes the core to disable the internal Lane-to-Lane deskew logic.
 */
//@{
#define BP_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW      (31)      //!< Bit position for PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW.
#define BM_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW      (0x80000000)  //!< Bit mask for PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW.

//! @brief Get value of PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW from a register value.
#define BG_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW) >> BP_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW)

//! @brief Format value for bitfield PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW.
#define BF_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW) & BM_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DISABLE_LANE_TO_LANE_DESKEW field to a new value.
#define BW_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW(v)   (HW_PCIE_PL_LSR_WR((HW_PCIE_PL_LSR_RD() & ~BM_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW) | BF_PCIE_PL_LSR_DISABLE_LANE_TO_LANE_DESKEW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_SNR - Symbol Number Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_SNR - Symbol Number Register (RW)
 *
 * Reset value: 0x0000830a
 *
 * Offset: 0x700 + 0x18
 */
typedef union _hw_pcie_pl_snr
{
    reg32_t U;
    struct _hw_pcie_pl_snr_bitfields
    {
        unsigned NUMBER_OF_TS_SYMBOLS : 4; //!< [3:0] Number of TS Symbols
        unsigned RESERVED0 : 4; //!< [7:4] Reserved
        unsigned NUMBER_OF_SKP_SYMBOLS : 3; //!< [10:8] Number of SKP Symbols
        unsigned RESERVED1 : 3; //!< [13:11] Reserved
        unsigned TIMER_MODIFIER_FOR_REPLAY_TIMER : 5; //!< [18:14] Timer Modifier for Replay Timer
        unsigned TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER : 5; //!< [23:19] Timer Modifier for Ack/Nak Latency Timer
        unsigned TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER : 5; //!< [28:24] Timer Modifier for Flow Control Watchdog Timer
        unsigned CONFIGURATION_REQUESTS : 3; //!< [31:29] Configuration Requests targeted at function numbers above this value will be returned with UR (unsupported request).
    } B;
} hw_pcie_pl_snr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_SNR register
 */
//@{
#define HW_PCIE_PL_SNR_ADDR      (REGS_PCIE_PL_BASE + 0x718)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_SNR           (*(volatile hw_pcie_pl_snr_t *) HW_PCIE_PL_SNR_ADDR)
#define HW_PCIE_PL_SNR_RD()      (HW_PCIE_PL_SNR.U)
#define HW_PCIE_PL_SNR_WR(v)     (HW_PCIE_PL_SNR.U = (v))
#define HW_PCIE_PL_SNR_SET(v)    (HW_PCIE_PL_SNR_WR(HW_PCIE_PL_SNR_RD() |  (v)))
#define HW_PCIE_PL_SNR_CLR(v)    (HW_PCIE_PL_SNR_WR(HW_PCIE_PL_SNR_RD() & ~(v)))
#define HW_PCIE_PL_SNR_TOG(v)    (HW_PCIE_PL_SNR_WR(HW_PCIE_PL_SNR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_SNR bitfields
 */

/*! @name Register PCIE_PL_SNR, field NUMBER_OF_TS_SYMBOLS[3:0] (RW)
 *
 * Number of TS Symbols Sets the number of TS identifier symbols that are sent in TS1 and TS2
 * ordered sets.
 */
//@{
#define BP_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS      (0)      //!< Bit position for PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS.
#define BM_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS      (0x0000000f)  //!< Bit mask for PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS.

//! @brief Get value of PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS from a register value.
#define BG_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS) >> BP_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS)

//! @brief Format value for bitfield PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS.
#define BF_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS) & BM_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUMBER_OF_TS_SYMBOLS field to a new value.
#define BW_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS) | BF_PCIE_PL_SNR_NUMBER_OF_TS_SYMBOLS(v)))
#endif
//@}

/*! @name Register PCIE_PL_SNR, field NUMBER_OF_SKP_SYMBOLS[10:8] (RW)
 *
 * Number of SKP Symbols
 */
//@{
#define BP_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS      (8)      //!< Bit position for PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS.
#define BM_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS      (0x00000700)  //!< Bit mask for PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS.

//! @brief Get value of PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS from a register value.
#define BG_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS) >> BP_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS)

//! @brief Format value for bitfield PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS.
#define BF_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS) & BM_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUMBER_OF_SKP_SYMBOLS field to a new value.
#define BW_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS) | BF_PCIE_PL_SNR_NUMBER_OF_SKP_SYMBOLS(v)))
#endif
//@}

/*! @name Register PCIE_PL_SNR, field TIMER_MODIFIER_FOR_REPLAY_TIMER[18:14] (RW)
 *
 * Timer Modifier for Replay Timer Increases the timer value for the replay timer, in increments of
 * 64 clock cycles.
 */
//@{
#define BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER      (14)      //!< Bit position for PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER.
#define BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER      (0x0007c000)  //!< Bit mask for PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER.

//! @brief Get value of PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER from a register value.
#define BG_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER) >> BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER)

//! @brief Format value for bitfield PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER.
#define BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMER_MODIFIER_FOR_REPLAY_TIMER field to a new value.
#define BW_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER) | BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_REPLAY_TIMER(v)))
#endif
//@}

/*! @name Register PCIE_PL_SNR, field TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER[23:19] (RW)
 *
 * Timer Modifier for Ack/Nak Latency Timer Increases the timer value for the Ack/Nak latency timer,
 * in increments of 64 clock cycles.
 */
//@{
#define BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER      (19)      //!< Bit position for PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER.
#define BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER      (0x00f80000)  //!< Bit mask for PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER.

//! @brief Get value of PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER from a register value.
#define BG_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER) >> BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER)

//! @brief Format value for bitfield PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER.
#define BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER field to a new value.
#define BW_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER) | BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_ACK_NAK_LATENCY_TIMER(v)))
#endif
//@}

/*! @name Register PCIE_PL_SNR, field TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER[28:24] (RW)
 *
 * Timer Modifier for Flow Control Watchdog Timer Increases the timer value for the Flow Control
 * watchdog timer, in increments of 16 clock cycles.
 */
//@{
#define BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER      (24)      //!< Bit position for PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER.
#define BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER      (0x1f000000)  //!< Bit mask for PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER.

//! @brief Get value of PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER from a register value.
#define BG_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER) >> BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER)

//! @brief Format value for bitfield PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER.
#define BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER) & BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER field to a new value.
#define BW_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER) | BF_PCIE_PL_SNR_TIMER_MODIFIER_FOR_FLOW_CONTROL_WATCHDOG_TIMER(v)))
#endif
//@}

/*! @name Register PCIE_PL_SNR, field CONFIGURATION_REQUESTS[31:29] (RW)
 *
 * Configuration Requests targeted at function numbers above this value will be returned with UR
 * (unsupported request).
 */
//@{
#define BP_PCIE_PL_SNR_CONFIGURATION_REQUESTS      (29)      //!< Bit position for PCIE_PL_SNR_CONFIGURATION_REQUESTS.
#define BM_PCIE_PL_SNR_CONFIGURATION_REQUESTS      (0xe0000000)  //!< Bit mask for PCIE_PL_SNR_CONFIGURATION_REQUESTS.

//! @brief Get value of PCIE_PL_SNR_CONFIGURATION_REQUESTS from a register value.
#define BG_PCIE_PL_SNR_CONFIGURATION_REQUESTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_SNR_CONFIGURATION_REQUESTS) >> BP_PCIE_PL_SNR_CONFIGURATION_REQUESTS)

//! @brief Format value for bitfield PCIE_PL_SNR_CONFIGURATION_REQUESTS.
#define BF_PCIE_PL_SNR_CONFIGURATION_REQUESTS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_SNR_CONFIGURATION_REQUESTS) & BM_PCIE_PL_SNR_CONFIGURATION_REQUESTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CONFIGURATION_REQUESTS field to a new value.
#define BW_PCIE_PL_SNR_CONFIGURATION_REQUESTS(v)   (HW_PCIE_PL_SNR_WR((HW_PCIE_PL_SNR_RD() & ~BM_PCIE_PL_SNR_CONFIGURATION_REQUESTS) | BF_PCIE_PL_SNR_CONFIGURATION_REQUESTS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_STRFM1 - Symbol Timer Register and Filter Mask Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_STRFM1 - Symbol Timer Register and Filter Mask Register 1 (RW)
 *
 * Reset value: 0x00000640
 *
 * Offset: 0x700 + 0x1C Filter Mask 1: Mask RADM Filtering and Error Handling Rules Bits Name Name
 * 31 CX_FLT_MASK_RC_CFG_DISCARD CX_FLT_MASK_RC_CFG_DISCARD 0 For RADM RC filter to not allow CFG
 * transaction being received 1 For RADM RC filter to allow CFG transaction being received 30
 * CX_FLT_MASK_RC_IO_DISCARD CX_FLT_MASK_RC_IO_DISCARD 0 For RADM RC filter to not allow IO
 * transaction being received 1 For RADM RC filter to allow IO transaction being received 29
 * CX_FLT_MASK_MSG_DROP CX_FLT_MASK_MSG_DROP 0 Drop MSG TLP (except for Vendor MSG) 1 Do not Drop
 * MSG (except for Vendor MSG) 28 CX_FLT_MASK_CPL_ECRC_DISCARD CX_FLT_MASK_CPL_ECRC_DISCARD 0
 * Discard TLPs with ECRC errors for CPL type 1 Allow TLPs with ECRC errors to be passed up for CPL
 * type 27 CX_FLT_MASK_ECRC_DISCARD CX_FLT_MASK_ECRC_DISCARD 0 Discard TLPs with ECRC errors 1 Allow
 * TLPs with ECRC errors to be passed up 26 CX_FLT_MASK_CPL_LEN_MATCH CX_FLT_MASK_CPL_LEN_MATCH 0
 * Enforce length match for received CPL TLPs; a violation results in cpl_abort, and possibly AER of
 * unexp_cpl_err 1 MASK length match for received CPL TLPs 25 CX_FLT_MASK_CPL_ATTR_MATCH
 * CX_FLT_MASK_CPL_ATTR_MATCH 0 Enforce attribute match for received CPL TLPs; a violation results
 * in a malformed TLP error, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca 1 Mask
 * attribute match for received CPL TLPs 24 CX_FLT_MASK_CPL_TC_MATCH CX_FLT_MASK_CPL_TC_MATCH 0
 * Enforce Traffic Class match for received CPL TLPs; a violation results in a malformed TLP error,
 * and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca 1 Mask Traffic Class match for
 * received CPL TLPs 23 CX_FLT_MASK_CPL_FUNC_MATCH CX_FLT_MASK_CPL_FUNC_MATCH 0 Enforce function
 * match for received CPL TLPs; a violation results in cpl_abort, and possibly AER of unexp_cpl_err,
 * cpl_rcvd_ur, cpl_rcvd_ca 1 Mask function match for received CPL TLPs 22
 * CX_FLT_MASK_CPL_REQID_MATCH CX_FLT_MASK_CPL_REQID_MATCH 0 Enforce Req. Id match for received CPL
 * TLPs; a violation result in cpl_abort, and possibly AER of unexp_cpl_err, cpl_rcvd_ur,
 * cpl_rcvd_ca 1 Mask Req. Id match for received CPL TLPs 21 CX_FLT_MASK_CPL_TAGERR_MATCH
 * CX_FLT_MASK_CPL_TAGERR_MATCH 0 Enforce Tag Error Rules for received CPL TLPs; a violation result
 * in cpl_abort, and possibly AER of unexp_cpl_err, cpl_rcvd_ur, cpl_rcvd_ca 1 Mask Tag Error Rules
 * for received CPL TLPs 20 CX_FLT_MASK_LOCKED_RD_AS_UR CX_FLT_MASK_LOCKED_RD_AS_UR 0 Treat locked
 * Read TLPs as UR for EP; Supported for RC 1 Treat locked Read TLPs as Supported for EP; UR for RC
 * 19 CX_FLT_MASK_CFG_TYPE1_RE_AS_UR CX_FLT_MASK_CFG_TYPE1_RE_AS_UR 0 Treat CFG type1 TLPs as UR for
 * EP; Supported for RC 1 Treat CFG type1 TLPs as Supported for EP; UR for RC If CX_SRIOV_ENABLE is
 * set then this bit is set to allow the filter to process Type 1 Config requests if the EP consumes
 * more than one bus number. 18 CX_FLT_MASK_UR_OUTSIDE_BAR CX_FLT_MASK_UR_OUTSIDE_BAR 0 Treat out-
 * of-bar TLPs as UR 1 Treat out-of-bar TLPs as Supported Requests 17 CX_FLT_MASK_UR_POIS
 * CX_FLT_MASK_UR_POIS 0 Treat poisoned TLPs as UR 1 Treat poisoned TLPs as Supported Requests 16
 * CX_FLT_MASK_UR_FUNC_MISMATCH CX_FLT_MASK_UR_FUNC_MISMATCH 0 Treat Function MisMatched TLPs as UR
 * 1 Treat Function MisMatched TLPs as Supported
 */
typedef union _hw_pcie_pl_strfm1
{
    reg32_t U;
    struct _hw_pcie_pl_strfm1_bitfields
    {
        unsigned SKP_INTERVAL_VALUE : 11; //!< [10:0] SKP Interval Value
        unsigned RESERVED0 : 4; //!< [14:11] Reserved
        unsigned DISABLE_FC_WATCHDOG_TIMER : 1; //!< [15] Disable FC Watchdog Timer
        unsigned MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES : 16; //!< [31:16] Mask RADM Filtering and Error Handling Rules: Mask 1
    } B;
} hw_pcie_pl_strfm1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_STRFM1 register
 */
//@{
#define HW_PCIE_PL_STRFM1_ADDR      (REGS_PCIE_PL_BASE + 0x71c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_STRFM1           (*(volatile hw_pcie_pl_strfm1_t *) HW_PCIE_PL_STRFM1_ADDR)
#define HW_PCIE_PL_STRFM1_RD()      (HW_PCIE_PL_STRFM1.U)
#define HW_PCIE_PL_STRFM1_WR(v)     (HW_PCIE_PL_STRFM1.U = (v))
#define HW_PCIE_PL_STRFM1_SET(v)    (HW_PCIE_PL_STRFM1_WR(HW_PCIE_PL_STRFM1_RD() |  (v)))
#define HW_PCIE_PL_STRFM1_CLR(v)    (HW_PCIE_PL_STRFM1_WR(HW_PCIE_PL_STRFM1_RD() & ~(v)))
#define HW_PCIE_PL_STRFM1_TOG(v)    (HW_PCIE_PL_STRFM1_WR(HW_PCIE_PL_STRFM1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_STRFM1 bitfields
 */

/*! @name Register PCIE_PL_STRFM1, field SKP_INTERVAL_VALUE[10:0] (RW)
 *
 * SKP Interval Value The number of symbol times to wait between transmitting SKP ordered sets. Note
 * that the core actually waits the number of symbol times in this register plus 1 between
 * transmitting SKP ordered sets. The application must program this register accordingly. For
 * example, if 1536 we're programmed into this register (in a 250MHz core), then the core will
 * actually transmit Skp ordered sets once every 1537 symbol times. Also, the value programmed to
 * this register is actually clock ticks and not symbol times. In a 125MHz core, programming the
 * value programmed to this register should be scaled down by a factor of 2 (since 1 clock tick=2
 * symbol times in this case).
 */
//@{
#define BP_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE      (0)      //!< Bit position for PCIE_PL_STRFM1_SKP_INTERVAL_VALUE.
#define BM_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE      (0x000007ff)  //!< Bit mask for PCIE_PL_STRFM1_SKP_INTERVAL_VALUE.

//! @brief Get value of PCIE_PL_STRFM1_SKP_INTERVAL_VALUE from a register value.
#define BG_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE) >> BP_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE)

//! @brief Format value for bitfield PCIE_PL_STRFM1_SKP_INTERVAL_VALUE.
#define BF_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE) & BM_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SKP_INTERVAL_VALUE field to a new value.
#define BW_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE(v)   (HW_PCIE_PL_STRFM1_WR((HW_PCIE_PL_STRFM1_RD() & ~BM_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE) | BF_PCIE_PL_STRFM1_SKP_INTERVAL_VALUE(v)))
#endif
//@}

/*! @name Register PCIE_PL_STRFM1, field DISABLE_FC_WATCHDOG_TIMER[15] (RW)
 *
 * Disable FC Watchdog Timer
 */
//@{
#define BP_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER      (15)      //!< Bit position for PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER.
#define BM_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER      (0x00008000)  //!< Bit mask for PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER.

//! @brief Get value of PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER from a register value.
#define BG_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER) >> BP_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER)

//! @brief Format value for bitfield PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER.
#define BF_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER) & BM_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DISABLE_FC_WATCHDOG_TIMER field to a new value.
#define BW_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER(v)   (HW_PCIE_PL_STRFM1_WR((HW_PCIE_PL_STRFM1_RD() & ~BM_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER) | BF_PCIE_PL_STRFM1_DISABLE_FC_WATCHDOG_TIMER(v)))
#endif
//@}

/*! @name Register PCIE_PL_STRFM1, field MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES[31:16] (RW)
 *
 * Mask RADM Filtering and Error Handling Rules: Mask 1 There are several mask bits to turn off the
 * filtering and error handling rules In each case, 0 applies the associated filtering rule and 1
 * masks the associated filtering rule. A more detailed description for these bits is provided in
 * Table 5-348. [31]: Mask filtering of received Configuration Requests (RC mode only) [30]: Mask
 * filtering of received I/O Requests (RC mode only) [29]: Send Message TLPs to the application on
 * RTRGT1 and send decoded Message on the SII (1) or send decoded Message on the SII, then drop the
 * Message TLPs (0). The default value for this bit is the inverse of `FLT_DROP_MSG. That is, if
 * `FLT_DROP_MSG = 1, then the default value of this bit is 0 (drop Message TLPs). Note that this
 * bit only controls message TLPs other than Vendor MSGs. Vendor MSGs are controlled by , bits
 * [1:0]. [28]: Mask ECRC error filtering for Completions [27]: Mask ECRC error filtering [26]: Mask
 * Length mismatch error for received Completions [25]: Mask Attributes mismatch error for received
 * Completions [24]: Mask Traffic Class mismatch error for received Completions [23]: Mask function
 * mismatch error for received Completions [23]: Mask Requester ID mismatch error for received
 * Completions [21]: Mask Tag error rules for received Completions [20]: Mask Locked Request
 * filtering [19]: Mask Type 1 Configuration Request filtering [18]: Mask BAR match filtering [17]:
 * Mask poisoned TLP filtering [16]: Mask function mismatch filtering for incoming Requests
 */
//@{
#define BP_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES      (16)      //!< Bit position for PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.
#define BM_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES      (0xffff0000)  //!< Bit mask for PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.

//! @brief Get value of PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES from a register value.
#define BG_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) >> BP_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES)

//! @brief Format value for bitfield PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.
#define BF_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) & BM_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES field to a new value.
#define BW_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)   (HW_PCIE_PL_STRFM1_WR((HW_PCIE_PL_STRFM1_RD() & ~BM_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) | BF_PCIE_PL_STRFM1_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_STRFM2 - Filter Mask Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_STRFM2 - Filter Mask Register 2 (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x20
 */
typedef union _hw_pcie_pl_strfm2
{
    reg32_t U;
    struct _hw_pcie_pl_strfm2_bitfields
    {
        unsigned MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES : 32; //!< [31:0] Mask RADM Filtering and Error Handling Rules: Mask 2
    } B;
} hw_pcie_pl_strfm2_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_STRFM2 register
 */
//@{
#define HW_PCIE_PL_STRFM2_ADDR      (REGS_PCIE_PL_BASE + 0x720)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_STRFM2           (*(volatile hw_pcie_pl_strfm2_t *) HW_PCIE_PL_STRFM2_ADDR)
#define HW_PCIE_PL_STRFM2_RD()      (HW_PCIE_PL_STRFM2.U)
#define HW_PCIE_PL_STRFM2_WR(v)     (HW_PCIE_PL_STRFM2.U = (v))
#define HW_PCIE_PL_STRFM2_SET(v)    (HW_PCIE_PL_STRFM2_WR(HW_PCIE_PL_STRFM2_RD() |  (v)))
#define HW_PCIE_PL_STRFM2_CLR(v)    (HW_PCIE_PL_STRFM2_WR(HW_PCIE_PL_STRFM2_RD() & ~(v)))
#define HW_PCIE_PL_STRFM2_TOG(v)    (HW_PCIE_PL_STRFM2_WR(HW_PCIE_PL_STRFM2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_STRFM2 bitfields
 */

/*! @name Register PCIE_PL_STRFM2, field MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES[31:0] (RW)
 *
 * Mask RADM Filtering and Error Handling Rules: Mask 2 It defaults to 0x0 There are several mask
 * bits used to turn off the filtering and error handling rules . •[31:4]: Reserved •[3]:
 * `CX_FLT_MASK_HANDLE_FLUSH - 0: Disable Core Filter to handle flush request - 1: Enable Core
 * Filter to handle flush request •[2]: `CX_FLT_MASK_DABORT_4UCPL - 0: Enable DLLP abort for
 * unexpected CPL - 1: Do not enable DLLP abort for unexpected CPL •[1]: `CX_FLT_MASK_VENMSG1_DROP -
 * 0: Vendor MSG Type 1 dropped silently - 1: Vendor MSG Type 1 not dropped •[0]:
 * `CX_FLT_MASK_VENMSG0_DROP - 0: Vendor MSG Type 0 dropped with UR error reporting - 1: Vendor MSG
 * Type 0 not dropped
 */
//@{
#define BP_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES      (0)      //!< Bit position for PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.
#define BM_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES      (0xffffffff)  //!< Bit mask for PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.

//! @brief Get value of PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES from a register value.
#define BG_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) >> BP_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES)

//! @brief Format value for bitfield PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES.
#define BF_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) & BM_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES field to a new value.
#define BW_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)   (HW_PCIE_PL_STRFM2_WR((HW_PCIE_PL_STRFM2_RD() & ~BM_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES) | BF_PCIE_PL_STRFM2_MASK_RADM_FILTERING_AND_ERROR_HANDLING_RULES(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_AMODNPSR - AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_AMODNPSR - AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register (RW)
 *
 * Reset value: 0x00000001
 *
 * Offset: 0x700 + 0x24
 */
typedef union _hw_pcie_pl_amodnpsr
{
    reg32_t U;
    struct _hw_pcie_pl_amodnpsr_bitfields
    {
        unsigned ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS : 1; //!< [0] Enable AMBA Multiple Outbound Decomposed NP Sub- Requests.
        unsigned RESERVED0 : 31; //!< [31:1] Reserved
    } B;
} hw_pcie_pl_amodnpsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_AMODNPSR register
 */
//@{
#define HW_PCIE_PL_AMODNPSR_ADDR      (REGS_PCIE_PL_BASE + 0x724)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_AMODNPSR           (*(volatile hw_pcie_pl_amodnpsr_t *) HW_PCIE_PL_AMODNPSR_ADDR)
#define HW_PCIE_PL_AMODNPSR_RD()      (HW_PCIE_PL_AMODNPSR.U)
#define HW_PCIE_PL_AMODNPSR_WR(v)     (HW_PCIE_PL_AMODNPSR.U = (v))
#define HW_PCIE_PL_AMODNPSR_SET(v)    (HW_PCIE_PL_AMODNPSR_WR(HW_PCIE_PL_AMODNPSR_RD() |  (v)))
#define HW_PCIE_PL_AMODNPSR_CLR(v)    (HW_PCIE_PL_AMODNPSR_WR(HW_PCIE_PL_AMODNPSR_RD() & ~(v)))
#define HW_PCIE_PL_AMODNPSR_TOG(v)    (HW_PCIE_PL_AMODNPSR_WR(HW_PCIE_PL_AMODNPSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_AMODNPSR bitfields
 */

/*! @name Register PCIE_PL_AMODNPSR, field ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS[0] (RW)
 *
 * Enable AMBA Multiple Outbound Decomposed NP Sub- Requests. This bit when set to '0' disables the
 * possibility of having multiple outstanding non-posted requests that were derived from
 * decomposition of an outbound AMBA request. See for more details. You should not clear this
 * register unless your application master is requesting an amount of read data greater than
 * Max_Read_Request_Size, and the remote device (or switch) is reordering completions that have
 * different tags
 */
//@{
#define BP_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS      (0)      //!< Bit position for PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS.
#define BM_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS      (0x00000001)  //!< Bit mask for PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS.

//! @brief Get value of PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS from a register value.
#define BG_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS) >> BP_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS)

//! @brief Format value for bitfield PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS.
#define BF_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS) & BM_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS field to a new value.
#define BW_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS(v)   (HW_PCIE_PL_AMODNPSR_WR((HW_PCIE_PL_AMODNPSR_RD() & ~BM_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS) | BF_PCIE_PL_AMODNPSR_ENABLE_AMBA_MULTIPLE_OUTBOUND_DECOMPOSED_NP_SUBREQUESTS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_DEBUG0 - Debug Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_DEBUG0 - Debug Register 0 (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x28 [31:28]: rmlh_ts_link_ctrl Link control bits advertised by link partner
 * [27]: rmlh_ts_lane_num_is_k23 Currently receiving k237 (PAD) in place of lane number [26]:
 * rmlh_ts_link_num_is_k23 Currently receiving k237 (PAD) in place of link number [25]:
 * rmlh_rcvd_idle[0] Receiver is receiving logical idle [24]: rmlh_rcvd_idle[1] 2nd symbol is also
 * idle (16bit PHY interface only) [23:8]: mac_phy_txdata PIPE Transmit data [7:6]: mac_phy_txdatak
 * PIPE transmit K indication [5:0]: xmlh_ltssm_state LTSSM current state. See source for encodings
 */
typedef union _hw_pcie_pl_debug0
{
    reg32_t U;
    struct _hw_pcie_pl_debug0_bitfields
    {
        unsigned VALUE : 32; //!< [31:0] The value on cxpl_debug_info[31:0].
    } B;
} hw_pcie_pl_debug0_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_DEBUG0 register
 */
//@{
#define HW_PCIE_PL_DEBUG0_ADDR      (REGS_PCIE_PL_BASE + 0x728)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_DEBUG0           (*(volatile hw_pcie_pl_debug0_t *) HW_PCIE_PL_DEBUG0_ADDR)
#define HW_PCIE_PL_DEBUG0_RD()      (HW_PCIE_PL_DEBUG0.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_DEBUG0 bitfields
 */

/*! @name Register PCIE_PL_DEBUG0, field VALUE[31:0] (RO)
 *
 * The value on cxpl_debug_info[31:0].
 */
//@{
#define BP_PCIE_PL_DEBUG0_VALUE      (0)      //!< Bit position for PCIE_PL_DEBUG0_VALUE.
#define BM_PCIE_PL_DEBUG0_VALUE      (0xffffffff)  //!< Bit mask for PCIE_PL_DEBUG0_VALUE.

//! @brief Get value of PCIE_PL_DEBUG0_VALUE from a register value.
#define BG_PCIE_PL_DEBUG0_VALUE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_DEBUG0_VALUE) >> BP_PCIE_PL_DEBUG0_VALUE)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_DEBUG1 - Debug Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_DEBUG1 - Debug Register 1 (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x2C [63]: xmlh_scrambler_disable Scrambling disabled for the link [62]:
 * xmlh_link_disable LTSSM in DISABLE state. Link inoperable [61]: xmlh_link_in_training LTSSM
 * performing link training [60]: xmlh_rcvr_revrs_pol_en LTSSM testing for polarity reversal [59]:
 * xmlh_training_rst_n LTSSM-negotiated link reset [58:55]: 0000b Constant/reserved [54]:
 * mac_phy_txdetectrx_loop PIPE receiver detect/loopback request [53]: mac_phy_txelecidle[0] PIPE
 * transmit electrical idle request [52]: mac_phy_txcompliance[0] PIPE transmit compliance request
 * [51]: app_init_rst Application request to initiate training reset [50:48]: 000b Constant/reserved
 * [47:40]: rmlh_ts_link_num Link number advertised/confirmed by link partner [39:38]: 00b
 * Constant/reserved [37]: xmtbyte_skip_sent A skip ordered set has been transmitted [36]:
 * xmlh_link_up LTSSM reports PHY link up [35]: rmlh_inskip_rcv Receiver reports skip reception
 * [34]: rmlh_ts1_rcvd TS1 training sequence received (pulse) [33]: rmlh_ts2_rcvd TS2 training
 * sequence received (pulse) [32]: rmlh_rcvd_lane_rev Receiver detected lane reversal
 */
typedef union _hw_pcie_pl_debug1
{
    reg32_t U;
    struct _hw_pcie_pl_debug1_bitfields
    {
        unsigned VALUE : 32; //!< [31:0] The value on cxpl_debug_info[63:32].
    } B;
} hw_pcie_pl_debug1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_DEBUG1 register
 */
//@{
#define HW_PCIE_PL_DEBUG1_ADDR      (REGS_PCIE_PL_BASE + 0x72c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_DEBUG1           (*(volatile hw_pcie_pl_debug1_t *) HW_PCIE_PL_DEBUG1_ADDR)
#define HW_PCIE_PL_DEBUG1_RD()      (HW_PCIE_PL_DEBUG1.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_DEBUG1 bitfields
 */

/*! @name Register PCIE_PL_DEBUG1, field VALUE[31:0] (RO)
 *
 * The value on cxpl_debug_info[63:32].
 */
//@{
#define BP_PCIE_PL_DEBUG1_VALUE      (0)      //!< Bit position for PCIE_PL_DEBUG1_VALUE.
#define BM_PCIE_PL_DEBUG1_VALUE      (0xffffffff)  //!< Bit mask for PCIE_PL_DEBUG1_VALUE.

//! @brief Get value of PCIE_PL_DEBUG1_VALUE from a register value.
#define BG_PCIE_PL_DEBUG1_VALUE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_DEBUG1_VALUE) >> BP_PCIE_PL_DEBUG1_VALUE)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_TPFCSR - Transmit Posted FC Credit Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_TPFCSR - Transmit Posted FC Credit Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x30 *Default value depends on the number of advertised credits for header and
 * data {12'b0, xtlh_xadm_ph_cdts, xtlh_xadm_pd_cdts}; If the number of advertised completion
 * credits (both header and data) are infinite, then the default would be {12'b0, 8'hFF, 12'hFFF}.
 */
typedef union _hw_pcie_pl_tpfcsr
{
    reg32_t U;
    struct _hw_pcie_pl_tpfcsr_bitfields
    {
        unsigned TRANSMIT_POSTED_DATA_FC_CREDITS : 12; //!< [11:0] Transmit Posted Data FC Credits
        unsigned TRANSMIT_POSTED_HEADER_FC_CREDITS : 8; //!< [19:12] Transmit Posted Header FC Credits
        unsigned RESERVED0 : 12; //!< [31:20] Reserved
    } B;
} hw_pcie_pl_tpfcsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_TPFCSR register
 */
//@{
#define HW_PCIE_PL_TPFCSR_ADDR      (REGS_PCIE_PL_BASE + 0x730)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_TPFCSR           (*(volatile hw_pcie_pl_tpfcsr_t *) HW_PCIE_PL_TPFCSR_ADDR)
#define HW_PCIE_PL_TPFCSR_RD()      (HW_PCIE_PL_TPFCSR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_TPFCSR bitfields
 */

/*! @name Register PCIE_PL_TPFCSR, field TRANSMIT_POSTED_DATA_FC_CREDITS[11:0] (RO)
 *
 * Transmit Posted Data FC Credits The Posted Data credits advertised by the receiver at the other
 * end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS      (0)      //!< Bit position for PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS.
#define BM_PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS.

//! @brief Get value of PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS from a register value.
#define BG_PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS) >> BP_PCIE_PL_TPFCSR_TRANSMIT_POSTED_DATA_FC_CREDITS)
//@}

/*! @name Register PCIE_PL_TPFCSR, field TRANSMIT_POSTED_HEADER_FC_CREDITS[19:12] (RO)
 *
 * Transmit Posted Header FC Credits The Posted Header credits advertised by the receiver at the
 * other end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS      (12)      //!< Bit position for PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS.
#define BM_PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS.

//! @brief Get value of PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS from a register value.
#define BG_PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS) >> BP_PCIE_PL_TPFCSR_TRANSMIT_POSTED_HEADER_FC_CREDITS)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_TNFCSR - Transmit Non-Posted FC Credit Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_TNFCSR - Transmit Non-Posted FC Credit Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x34 *Default value depends on the number of advertised credits for header and
 * data {12'b0, xtlh_xadm_nph_cdts, xtlh_xadm_npd_cdts}; If the number of advertised completion
 * credits (both header and data) are infinite, then the default would be {12'b0, 8'hFF, 12'hFFF}.
 */
typedef union _hw_pcie_pl_tnfcsr
{
    reg32_t U;
    struct _hw_pcie_pl_tnfcsr_bitfields
    {
        unsigned TRANSMIT_NON_POSTED_DATA_FC_CREDITS : 12; //!< [11:0] Transmit Non-Posted Data FC Credits
        unsigned TRANSMIT_NON_POSTED_HEADER_FC_CREDITS : 8; //!< [19:12] Transmit Non-Posted Header FC Credits
        unsigned RESERVED0 : 12; //!< [31:20] Reserved
    } B;
} hw_pcie_pl_tnfcsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_TNFCSR register
 */
//@{
#define HW_PCIE_PL_TNFCSR_ADDR      (REGS_PCIE_PL_BASE + 0x734)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_TNFCSR           (*(volatile hw_pcie_pl_tnfcsr_t *) HW_PCIE_PL_TNFCSR_ADDR)
#define HW_PCIE_PL_TNFCSR_RD()      (HW_PCIE_PL_TNFCSR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_TNFCSR bitfields
 */

/*! @name Register PCIE_PL_TNFCSR, field TRANSMIT_NON_POSTED_DATA_FC_CREDITS[11:0] (RO)
 *
 * Transmit Non-Posted Data FC Credits The Non-Posted Data credits advertised by the receiver at the
 * other end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS      (0)      //!< Bit position for PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS.
#define BM_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS.

//! @brief Get value of PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS from a register value.
#define BG_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS) >> BP_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_DATA_FC_CREDITS)
//@}

/*! @name Register PCIE_PL_TNFCSR, field TRANSMIT_NON_POSTED_HEADER_FC_CREDITS[19:12] (RO)
 *
 * Transmit Non-Posted Header FC Credits The Non-Posted Header credits advertised by the receiver at
 * the other end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS      (12)      //!< Bit position for PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS.
#define BM_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS.

//! @brief Get value of PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS from a register value.
#define BG_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS) >> BP_PCIE_PL_TNFCSR_TRANSMIT_NON_POSTED_HEADER_FC_CREDITS)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_TCFCSR - Transmit Completion FC Credit Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_TCFCSR - Transmit Completion FC Credit Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x38 *Default value depends on the number of advertised credits for header and
 * data {12'b0, xtlh_xadm_cplh_cdts, xtlh_xadm_cpld_cdts}; If the number of advertised completion
 * credits (both header and data) are infinite, then the default would be {12'b0, 8'hFF, 12'hFFF}.
 */
typedef union _hw_pcie_pl_tcfcsr
{
    reg32_t U;
    struct _hw_pcie_pl_tcfcsr_bitfields
    {
        unsigned TRANSMIT_COMPLETION_DATA_FC_CREDITS : 12; //!< [11:0] Transmit Completion Data FC Credits
        unsigned TRANSMIT_COMPLETION_HEADER_FC_CREDITS : 8; //!< [19:12] Transmit Completion Header FC Credits
        unsigned RESERVED0 : 12; //!< [31:20] Reserved
    } B;
} hw_pcie_pl_tcfcsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_TCFCSR register
 */
//@{
#define HW_PCIE_PL_TCFCSR_ADDR      (REGS_PCIE_PL_BASE + 0x738)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_TCFCSR           (*(volatile hw_pcie_pl_tcfcsr_t *) HW_PCIE_PL_TCFCSR_ADDR)
#define HW_PCIE_PL_TCFCSR_RD()      (HW_PCIE_PL_TCFCSR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_TCFCSR bitfields
 */

/*! @name Register PCIE_PL_TCFCSR, field TRANSMIT_COMPLETION_DATA_FC_CREDITS[11:0] (RO)
 *
 * Transmit Completion Data FC Credits The Completion Data credits advertised by the receiver at the
 * other end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS      (0)      //!< Bit position for PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS.
#define BM_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS.

//! @brief Get value of PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS from a register value.
#define BG_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS) >> BP_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_DATA_FC_CREDITS)
//@}

/*! @name Register PCIE_PL_TCFCSR, field TRANSMIT_COMPLETION_HEADER_FC_CREDITS[19:12] (RO)
 *
 * Transmit Completion Header FC Credits The Completion Header credits advertised by the receiver at
 * the other end of the Link, updated with each UpdateFC DLLP.
 */
//@{
#define BP_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS      (12)      //!< Bit position for PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS.
#define BM_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS.

//! @brief Get value of PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS from a register value.
#define BG_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS) >> BP_PCIE_PL_TCFCSR_TRANSMIT_COMPLETION_HEADER_FC_CREDITS)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_QSR - Queue Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_QSR - Queue Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x3C
 */
typedef union _hw_pcie_pl_qsr
{
    reg32_t U;
    struct _hw_pcie_pl_qsr_bitfields
    {
        unsigned RECEIVED_TLP_FC_CREDITS_NOT_RETURNED : 1; //!< [0] Received TLP FC Credits Not Returned
        unsigned TRANSMIT_RETRY_BUFFER_NOT_EMPTY : 1; //!< [1] Transmit Retry Buffer Not Empty
        unsigned RECEIVED_QUEUE_NOT_EMPTY : 1; //!< [2] Received Queue Not Empty
        unsigned RESERVED0 : 29; //!< [31:3] Reserved
    } B;
} hw_pcie_pl_qsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_QSR register
 */
//@{
#define HW_PCIE_PL_QSR_ADDR      (REGS_PCIE_PL_BASE + 0x73c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_QSR           (*(volatile hw_pcie_pl_qsr_t *) HW_PCIE_PL_QSR_ADDR)
#define HW_PCIE_PL_QSR_RD()      (HW_PCIE_PL_QSR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_QSR bitfields
 */

/*! @name Register PCIE_PL_QSR, field RECEIVED_TLP_FC_CREDITS_NOT_RETURNED[0] (RO)
 *
 * Received TLP FC Credits Not Returned Indicates that the core has sent a TLP but has not yet
 * received an UpdateFC DLLP indicating that the credits for that TLP have been restored by the
 * receiver at the other end of the Link. Note : This bit is for simulation only and will always be
 * synthesized as 0.
 */
//@{
#define BP_PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED      (0)      //!< Bit position for PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED.
#define BM_PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED      (0x00000001)  //!< Bit mask for PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED.

//! @brief Get value of PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED from a register value.
#define BG_PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED) >> BP_PCIE_PL_QSR_RECEIVED_TLP_FC_CREDITS_NOT_RETURNED)
//@}

/*! @name Register PCIE_PL_QSR, field TRANSMIT_RETRY_BUFFER_NOT_EMPTY[1] (RO)
 *
 * Transmit Retry Buffer Not Empty Indicates that there is data in the transmit retry buffer.
 */
//@{
#define BP_PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY      (1)      //!< Bit position for PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY.
#define BM_PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY      (0x00000002)  //!< Bit mask for PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY.

//! @brief Get value of PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY from a register value.
#define BG_PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY) >> BP_PCIE_PL_QSR_TRANSMIT_RETRY_BUFFER_NOT_EMPTY)
//@}

/*! @name Register PCIE_PL_QSR, field RECEIVED_QUEUE_NOT_EMPTY[2] (RO)
 *
 * Received Queue Not Empty Indicates there is data in one or more of the receive buffers.
 */
//@{
#define BP_PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY      (2)      //!< Bit position for PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY.
#define BM_PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY      (0x00000004)  //!< Bit mask for PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY.

//! @brief Get value of PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY from a register value.
#define BG_PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY) >> BP_PCIE_PL_QSR_RECEIVED_QUEUE_NOT_EMPTY)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VCTAR1 - VC Transmit Arbitration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VCTAR1 - VC Transmit Arbitration Register 1 (RO)
 *
 * Reset value: 0x0000000f
 *
 * Offset: 0x700 + 0x40 VC Transmit Arbitration Registers 1 and 2 specify the weights assigned to
 * VC0-VC7 to be used for WRR transmit arbitration for VCs in the LPVC group. The following rules
 * and restrictions apply regarding the values programmed in VC Transmit Arbitration Registers 1 and
 * 2: There are 8 bits allocated for each weight value. No weight value for a VC in the LPVC group
 * can be less than 1. No weight value can be greater than the number of phases in the selected
 * arbitration scheme. The sum of the weights assigned to all VCs in the LPVC group must equal the
 * number of phases in the selected arbitration scheme. For example, if 64-phase WRR arbitration is
 * selected, the total of all WRR Weight values for all VCs in the LPVC group must equal 64. Each of
 * the VC numbers listed in the bit field table is a VC ID, not the VC structure number. VC Transmit
 * Arbitration Registers 1 and 2 are hardwired to the default values set by the configuration
 * parameters listed in the Default columns of the bit field table.
 */
typedef union _hw_pcie_pl_vctar1
{
    reg32_t U;
    struct _hw_pcie_pl_vctar1_bitfields
    {
        unsigned WRR_WEIGHT_FOR_VC0 : 8; //!< [7:0] WRR Weight for VC0
        unsigned WRR_WEIGHT_FOR_VC1 : 8; //!< [15:8] WRR Weight for VC1
        unsigned WRR_WEIGHT_FOR_VC2 : 8; //!< [23:16] WRR Weight for VC2
        unsigned WRR_WEIGHT_FOR_VC3 : 8; //!< [31:24] WRR Weight for VC3
    } B;
} hw_pcie_pl_vctar1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VCTAR1 register
 */
//@{
#define HW_PCIE_PL_VCTAR1_ADDR      (REGS_PCIE_PL_BASE + 0x740)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VCTAR1           (*(volatile hw_pcie_pl_vctar1_t *) HW_PCIE_PL_VCTAR1_ADDR)
#define HW_PCIE_PL_VCTAR1_RD()      (HW_PCIE_PL_VCTAR1.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VCTAR1 bitfields
 */

/*! @name Register PCIE_PL_VCTAR1, field WRR_WEIGHT_FOR_VC0[7:0] (RO)
 *
 * WRR Weight for VC0
 */
//@{
#define BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0      (0)      //!< Bit position for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0.
#define BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0      (0x000000ff)  //!< Bit mask for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0.

//! @brief Get value of PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0 from a register value.
#define BG_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0) >> BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC0)
//@}

/*! @name Register PCIE_PL_VCTAR1, field WRR_WEIGHT_FOR_VC1[15:8] (RO)
 *
 * WRR Weight for VC1
 */
//@{
#define BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1      (8)      //!< Bit position for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1.
#define BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1      (0x0000ff00)  //!< Bit mask for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1.

//! @brief Get value of PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1 from a register value.
#define BG_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1) >> BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC1)
//@}

/*! @name Register PCIE_PL_VCTAR1, field WRR_WEIGHT_FOR_VC2[23:16] (RO)
 *
 * WRR Weight for VC2
 */
//@{
#define BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2      (16)      //!< Bit position for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2.
#define BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2      (0x00ff0000)  //!< Bit mask for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2.

//! @brief Get value of PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2 from a register value.
#define BG_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2) >> BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC2)
//@}

/*! @name Register PCIE_PL_VCTAR1, field WRR_WEIGHT_FOR_VC3[31:24] (RO)
 *
 * WRR Weight for VC3
 */
//@{
#define BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3      (24)      //!< Bit position for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3.
#define BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3      (0xff000000)  //!< Bit mask for PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3.

//! @brief Get value of PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3 from a register value.
#define BG_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3) >> BP_PCIE_PL_VCTAR1_WRR_WEIGHT_FOR_VC3)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VCTAR2 - VC Transmit Arbitration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VCTAR2 - VC Transmit Arbitration Register 2 (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x44 VC Transmit Arbitration Registers 1 and 2 specify the weights assigned to
 * VC0-VC7 to be used for WRR transmit arbitration for VCs in the LPVC group. The following rules
 * and restrictions apply regarding the values programmed in VC Transmit Arbitration Registers 1 and
 * 2: There are 8 bits allocated for each weight value. No weight value for a VC in the LPVC group
 * can be less than 1. No weight value can be greater than the number of phases in the selected
 * arbitration scheme. The sum of the weights assigned to all VCs in the LPVC group must equal the
 * number of phases in the selected arbitration scheme. For example, if 64-phase WRR arbitration is
 * selected, the total of all WRR Weight values for all VCs in the LPVC group must equal 64. Each of
 * the VC numbers listed in the bit field table is a VC ID, not the VC structure number. VC Transmit
 * Arbitration Registers 1 and 2 are hardwired to the default values set by the configuration
 * parameters listed in the Default columns of the bit field table.
 */
typedef union _hw_pcie_pl_vctar2
{
    reg32_t U;
    struct _hw_pcie_pl_vctar2_bitfields
    {
        unsigned WRR_WEIGHT_FOR_VC4 : 8; //!< [7:0] WRR Weight for VC4
        unsigned WRR_WEIGHT_FOR_VC5 : 8; //!< [15:8] WRR Weight for VC5
        unsigned WRR_WEIGHT_FOR_VC6 : 8; //!< [23:16] WRR Weight for VC6
        unsigned WRR_WEIGHT_FOR_VC7 : 8; //!< [31:24] WRR Weight for VC7
    } B;
} hw_pcie_pl_vctar2_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VCTAR2 register
 */
//@{
#define HW_PCIE_PL_VCTAR2_ADDR      (REGS_PCIE_PL_BASE + 0x744)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VCTAR2           (*(volatile hw_pcie_pl_vctar2_t *) HW_PCIE_PL_VCTAR2_ADDR)
#define HW_PCIE_PL_VCTAR2_RD()      (HW_PCIE_PL_VCTAR2.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VCTAR2 bitfields
 */

/*! @name Register PCIE_PL_VCTAR2, field WRR_WEIGHT_FOR_VC4[7:0] (RO)
 *
 * WRR Weight for VC4
 */
//@{
#define BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4      (0)      //!< Bit position for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4.
#define BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4      (0x000000ff)  //!< Bit mask for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4.

//! @brief Get value of PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4 from a register value.
#define BG_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4) >> BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC4)
//@}

/*! @name Register PCIE_PL_VCTAR2, field WRR_WEIGHT_FOR_VC5[15:8] (RO)
 *
 * WRR Weight for VC5
 */
//@{
#define BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5      (8)      //!< Bit position for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5.
#define BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5      (0x0000ff00)  //!< Bit mask for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5.

//! @brief Get value of PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5 from a register value.
#define BG_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5) >> BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC5)
//@}

/*! @name Register PCIE_PL_VCTAR2, field WRR_WEIGHT_FOR_VC6[23:16] (RO)
 *
 * WRR Weight for VC6
 */
//@{
#define BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6      (16)      //!< Bit position for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6.
#define BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6      (0x00ff0000)  //!< Bit mask for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6.

//! @brief Get value of PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6 from a register value.
#define BG_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6) >> BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC6)
//@}

/*! @name Register PCIE_PL_VCTAR2, field WRR_WEIGHT_FOR_VC7[31:24] (RO)
 *
 * WRR Weight for VC7
 */
//@{
#define BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7      (24)      //!< Bit position for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7.
#define BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7      (0xff000000)  //!< Bit mask for PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7.

//! @brief Get value of PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7 from a register value.
#define BG_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7) >> BP_PCIE_PL_VCTAR2_WRR_WEIGHT_FOR_VC7)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0PRQC - VC0 Posted Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0PRQC - VC0 Posted Receive Queue Control (RW)
 *
 * Reset value: 0x0010c019
 *
 * The data and header credits fields of the Receive Queue Control registers are used in all receive
 * buffer configurations. All other fields of the Receive Queue Control and Depth registers are used
 * only in the segmented- buffer configuration. Offset: 0x700 + 0x48
 */
typedef union _hw_pcie_pl_vc0prqc
{
    reg32_t U;
    struct _hw_pcie_pl_vc0prqc_bitfields
    {
        unsigned VC0_POSTED_DATA_CREDITS : 12; //!< [11:0] VC0 Posted Data Credits
        unsigned VC0_POSTED_HEADER_CREDITS : 8; //!< [19:12] VC0 Posted Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC0_POSTED_TLP_QUEUE_MODE : 3; //!< [23:21] VC0 Posted TLP Queue Mode
        unsigned RESERVED1 : 6; //!< [29:24] Reserved
        unsigned TLP_TYPE_ORDERING_FOR_VC0 : 1; //!< [30] TLP Type Ordering for VC0
        unsigned VC_ORDERING_FOR_RECEIVE_QUEUES : 1; //!< [31] VC Ordering for Receive Queues
    } B;
} hw_pcie_pl_vc0prqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0PRQC register
 */
//@{
#define HW_PCIE_PL_VC0PRQC_ADDR      (REGS_PCIE_PL_BASE + 0x748)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0PRQC           (*(volatile hw_pcie_pl_vc0prqc_t *) HW_PCIE_PL_VC0PRQC_ADDR)
#define HW_PCIE_PL_VC0PRQC_RD()      (HW_PCIE_PL_VC0PRQC.U)
#define HW_PCIE_PL_VC0PRQC_WR(v)     (HW_PCIE_PL_VC0PRQC.U = (v))
#define HW_PCIE_PL_VC0PRQC_SET(v)    (HW_PCIE_PL_VC0PRQC_WR(HW_PCIE_PL_VC0PRQC_RD() |  (v)))
#define HW_PCIE_PL_VC0PRQC_CLR(v)    (HW_PCIE_PL_VC0PRQC_WR(HW_PCIE_PL_VC0PRQC_RD() & ~(v)))
#define HW_PCIE_PL_VC0PRQC_TOG(v)    (HW_PCIE_PL_VC0PRQC_WR(HW_PCIE_PL_VC0PRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0PRQC bitfields
 */

/*! @name Register PCIE_PL_VC0PRQC, field VC0_POSTED_DATA_CREDITS[11:0] (RW)
 *
 * VC0 Posted Data Credits The number of initial Posted data credits for VC0, used for all receive
 * queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS.
#define BM_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS) >> BP_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS.
#define BF_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_POSTED_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS(v)   (HW_PCIE_PL_VC0PRQC_WR((HW_PCIE_PL_VC0PRQC_RD() & ~BM_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS) | BF_PCIE_PL_VC0PRQC_VC0_POSTED_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0PRQC, field VC0_POSTED_HEADER_CREDITS[19:12] (RW)
 *
 * VC0 Posted Header Credits The number of initial Posted header credits for VC0, used for all
 * receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS.
#define BM_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS) >> BP_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS.
#define BF_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_POSTED_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS(v)   (HW_PCIE_PL_VC0PRQC_WR((HW_PCIE_PL_VC0PRQC_RD() & ~BM_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS) | BF_PCIE_PL_VC0PRQC_VC0_POSTED_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0PRQC, field VC0_POSTED_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC0 Posted TLP Queue Mode The operating mode of the Posted receive queue for VC0, used only in
 * the segmented-buffer configuration, writable through the DBI. Only one bit can be set at a time:
 * Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE) >> BP_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE) & BM_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_POSTED_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VC0PRQC_WR((HW_PCIE_PL_VC0PRQC_RD() & ~BM_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE) | BF_PCIE_PL_VC0PRQC_VC0_POSTED_TLP_QUEUE_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0PRQC, field TLP_TYPE_ORDERING_FOR_VC0[30] (RW)
 *
 * TLP Type Ordering for VC0 Determines the TLP type ordering rule for VC0 receive queues, used only
 * in the segmented-buffer configuration, writable through the DBI:
 *
 * Values:
 * - 0 - Strict ordering for received TLPs: Posted, then Completion, then Non-Posted
 * - 1 - Ordering of received TLPs follows the rules in PCI Express 3.0 Specification.
 */
//@{
#define BP_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0      (30)      //!< Bit position for PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0.
#define BM_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0      (0x40000000)  //!< Bit mask for PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0.

//! @brief Get value of PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0 from a register value.
#define BG_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0) >> BP_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0)

//! @brief Format value for bitfield PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0.
#define BF_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0) & BM_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TLP_TYPE_ORDERING_FOR_VC0 field to a new value.
#define BW_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0(v)   (HW_PCIE_PL_VC0PRQC_WR((HW_PCIE_PL_VC0PRQC_RD() & ~BM_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0) | BF_PCIE_PL_VC0PRQC_TLP_TYPE_ORDERING_FOR_VC0(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0PRQC, field VC_ORDERING_FOR_RECEIVE_QUEUES[31] (RW)
 *
 * VC Ordering for Receive Queues Determines the VC ordering rule for the receive queues, used only
 * in the segmented-buffer configuration, writable through the DBI:
 *
 * Values:
 * - 0 - Round robin
 * - 1 - Strict ordering, higher numbered VCs have higher priority
 */
//@{
#define BP_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES      (31)      //!< Bit position for PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES.
#define BM_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES      (0x80000000)  //!< Bit mask for PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES.

//! @brief Get value of PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES from a register value.
#define BG_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES) >> BP_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES)

//! @brief Format value for bitfield PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES.
#define BF_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES) & BM_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC_ORDERING_FOR_RECEIVE_QUEUES field to a new value.
#define BW_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES(v)   (HW_PCIE_PL_VC0PRQC_WR((HW_PCIE_PL_VC0PRQC_RD() & ~BM_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES) | BF_PCIE_PL_VC0PRQC_VC_ORDERING_FOR_RECEIVE_QUEUES(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0NRQC - VC0 Non-Posted Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0NRQC - VC0 Non-Posted Receive Queue Control (RW)
 *
 * Reset value: 0x00200000
 *
 * Offset: 0x700 + 0x4C
 */
typedef union _hw_pcie_pl_vc0nrqc
{
    reg32_t U;
    struct _hw_pcie_pl_vc0nrqc_bitfields
    {
        unsigned VC0_NON_POSTED_DATA_CREDITS : 12; //!< [11:0] VC0 Non-Posted Data Credits
        unsigned VC0_NON_POSTED_HEADER_CREDITS : 8; //!< [19:12] VC0 Non-Posted Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC0_NON_POSTED_TLP_QUEUE_MODE : 3; //!< [23:21] VC0 Non-Posted TLP Queue Mode
        unsigned RESERVED1 : 8; //!< [31:24] Reserved
    } B;
} hw_pcie_pl_vc0nrqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0NRQC register
 */
//@{
#define HW_PCIE_PL_VC0NRQC_ADDR      (REGS_PCIE_PL_BASE + 0x74c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0NRQC           (*(volatile hw_pcie_pl_vc0nrqc_t *) HW_PCIE_PL_VC0NRQC_ADDR)
#define HW_PCIE_PL_VC0NRQC_RD()      (HW_PCIE_PL_VC0NRQC.U)
#define HW_PCIE_PL_VC0NRQC_WR(v)     (HW_PCIE_PL_VC0NRQC.U = (v))
#define HW_PCIE_PL_VC0NRQC_SET(v)    (HW_PCIE_PL_VC0NRQC_WR(HW_PCIE_PL_VC0NRQC_RD() |  (v)))
#define HW_PCIE_PL_VC0NRQC_CLR(v)    (HW_PCIE_PL_VC0NRQC_WR(HW_PCIE_PL_VC0NRQC_RD() & ~(v)))
#define HW_PCIE_PL_VC0NRQC_TOG(v)    (HW_PCIE_PL_VC0NRQC_WR(HW_PCIE_PL_VC0NRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0NRQC bitfields
 */

/*! @name Register PCIE_PL_VC0NRQC, field VC0_NON_POSTED_DATA_CREDITS[11:0] (RW)
 *
 * VC0 Non-Posted Data Credits The number of initial Non-Posted data credits for VC0, used for all
 * receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS.
#define BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS) >> BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS.
#define BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_NON_POSTED_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS(v)   (HW_PCIE_PL_VC0NRQC_WR((HW_PCIE_PL_VC0NRQC_RD() & ~BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS) | BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0NRQC, field VC0_NON_POSTED_HEADER_CREDITS[19:12] (RW)
 *
 * VC0 Non-Posted Header Credits The number of initial Non-Posted header credits for VC0, used for
 * all receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS.
#define BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS) >> BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS.
#define BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_NON_POSTED_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS(v)   (HW_PCIE_PL_VC0NRQC_WR((HW_PCIE_PL_VC0NRQC_RD() & ~BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS) | BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0NRQC, field VC0_NON_POSTED_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC0 Non-Posted TLP Queue Mode The operating mode of the Non-Posted receive queue for VC0, used
 * only in the segmented-buffer configuration, writable through the DBI. Only one bit can be set at
 * a time: Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE) >> BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE) & BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_NON_POSTED_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VC0NRQC_WR((HW_PCIE_PL_VC0NRQC_RD() & ~BM_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE) | BF_PCIE_PL_VC0NRQC_VC0_NON_POSTED_TLP_QUEUE_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0CRQC - VC0 Completion Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0CRQC - VC0 Completion Receive Queue Control (RW)
 *
 * Reset value: 0x00800000
 *
 * Offset: 0x700 + 0x50
 */
typedef union _hw_pcie_pl_vc0crqc
{
    reg32_t U;
    struct _hw_pcie_pl_vc0crqc_bitfields
    {
        unsigned VC0_COMPLETION_DATA_CREDITS : 12; //!< [11:0] VC0 Completion Data Credits
        unsigned VC0_COMPLETION_HEADER_CREDITS : 8; //!< [19:12] VC0 Completion Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC0_COMPLETION_TLP_QUEUE_MODE : 3; //!< [23:21] VC0 Completion TLP Queue Mode
        unsigned RESERVED1 : 8; //!< [31:24] Reserved
    } B;
} hw_pcie_pl_vc0crqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0CRQC register
 */
//@{
#define HW_PCIE_PL_VC0CRQC_ADDR      (REGS_PCIE_PL_BASE + 0x750)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0CRQC           (*(volatile hw_pcie_pl_vc0crqc_t *) HW_PCIE_PL_VC0CRQC_ADDR)
#define HW_PCIE_PL_VC0CRQC_RD()      (HW_PCIE_PL_VC0CRQC.U)
#define HW_PCIE_PL_VC0CRQC_WR(v)     (HW_PCIE_PL_VC0CRQC.U = (v))
#define HW_PCIE_PL_VC0CRQC_SET(v)    (HW_PCIE_PL_VC0CRQC_WR(HW_PCIE_PL_VC0CRQC_RD() |  (v)))
#define HW_PCIE_PL_VC0CRQC_CLR(v)    (HW_PCIE_PL_VC0CRQC_WR(HW_PCIE_PL_VC0CRQC_RD() & ~(v)))
#define HW_PCIE_PL_VC0CRQC_TOG(v)    (HW_PCIE_PL_VC0CRQC_WR(HW_PCIE_PL_VC0CRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0CRQC bitfields
 */

/*! @name Register PCIE_PL_VC0CRQC, field VC0_COMPLETION_DATA_CREDITS[11:0] (RW)
 *
 * VC0 Completion Data Credits The number of initial Completion data credits for VC0, used for all
 * receive queue buffer configurations. This field is not writable through the DBI.
 */
//@{
#define BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS.
#define BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS) >> BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS.
#define BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_COMPLETION_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS(v)   (HW_PCIE_PL_VC0CRQC_WR((HW_PCIE_PL_VC0CRQC_RD() & ~BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS) | BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0CRQC, field VC0_COMPLETION_HEADER_CREDITS[19:12] (RW)
 *
 * VC0 Completion Header Credits The number of initial Completion header credits for VC0, used for
 * all receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS.
#define BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS) >> BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS.
#define BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_COMPLETION_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS(v)   (HW_PCIE_PL_VC0CRQC_WR((HW_PCIE_PL_VC0CRQC_RD() & ~BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS) | BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VC0CRQC, field VC0_COMPLETION_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC0 Completion TLP Queue Mode The operating mode of the Completion receive queue for VC0, used
 * only in the segmented-buffer configuration, writable through the DBI. Only one bit can be set at
 * a time: Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE) >> BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE) & BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC0_COMPLETION_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VC0CRQC_WR((HW_PCIE_PL_VC0CRQC_RD() & ~BM_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE) | BF_PCIE_PL_VC0CRQC_VC0_COMPLETION_TLP_QUEUE_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VCNPRQC - VCn Posted Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VCNPRQC - VCn Posted Receive Queue Control (RW)
 *
 * Reset value: 0x00200000
 *
 * Offset: 0x700 + 0x48 + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vcnprqc
{
    reg32_t U;
    struct _hw_pcie_pl_vcnprqc_bitfields
    {
        unsigned VC1_POSTED_DATA_CREDITS : 12; //!< [11:0] VC1 Posted Data Credits
        unsigned VC1_POSTED_HEADER_CREDITS : 8; //!< [19:12] VC1 Posted Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC1_POSTED_TLP_QUEUE_MODE : 3; //!< [23:21] VC1 Posted TLP Queue Mode
        unsigned RESERVED1 : 6; //!< [29:24] Reserved
        unsigned TLP_TYPE_ORDERING_FOR_VC1 : 1; //!< [30] TLP Type Ordering for VC1
        unsigned RESERVED2 : 1; //!< [31] Reserved
    } B;
} hw_pcie_pl_vcnprqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VCNPRQC register
 */
//@{
#define HW_PCIE_PL_VCNPRQC_ADDR      (REGS_PCIE_PL_BASE + 0x754)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VCNPRQC           (*(volatile hw_pcie_pl_vcnprqc_t *) HW_PCIE_PL_VCNPRQC_ADDR)
#define HW_PCIE_PL_VCNPRQC_RD()      (HW_PCIE_PL_VCNPRQC.U)
#define HW_PCIE_PL_VCNPRQC_WR(v)     (HW_PCIE_PL_VCNPRQC.U = (v))
#define HW_PCIE_PL_VCNPRQC_SET(v)    (HW_PCIE_PL_VCNPRQC_WR(HW_PCIE_PL_VCNPRQC_RD() |  (v)))
#define HW_PCIE_PL_VCNPRQC_CLR(v)    (HW_PCIE_PL_VCNPRQC_WR(HW_PCIE_PL_VCNPRQC_RD() & ~(v)))
#define HW_PCIE_PL_VCNPRQC_TOG(v)    (HW_PCIE_PL_VCNPRQC_WR(HW_PCIE_PL_VCNPRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VCNPRQC bitfields
 */

/*! @name Register PCIE_PL_VCNPRQC, field VC1_POSTED_DATA_CREDITS[11:0] (RW)
 *
 * VC1 Posted Data Credits The number of initial Posted data credits for VC1, used for all receive
 * queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS.
#define BM_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS) >> BP_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS.
#define BF_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_POSTED_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS(v)   (HW_PCIE_PL_VCNPRQC_WR((HW_PCIE_PL_VCNPRQC_RD() & ~BM_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS) | BF_PCIE_PL_VCNPRQC_VC1_POSTED_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNPRQC, field VC1_POSTED_HEADER_CREDITS[19:12] (RW)
 *
 * VC1 Posted Header Credits The number of initial Posted header credits for VC1, used for all
 * receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS.
#define BM_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS) >> BP_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS.
#define BF_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_POSTED_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS(v)   (HW_PCIE_PL_VCNPRQC_WR((HW_PCIE_PL_VCNPRQC_RD() & ~BM_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS) | BF_PCIE_PL_VCNPRQC_VC1_POSTED_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNPRQC, field VC1_POSTED_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC1 Posted TLP Queue Mode The operating mode of the Posted receive queue for VC1, used only in
 * the segmented-buffer configuration, writable through the DBI. Only one bit can be set at a time:
 * Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE) >> BP_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE) & BM_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_POSTED_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VCNPRQC_WR((HW_PCIE_PL_VCNPRQC_RD() & ~BM_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE) | BF_PCIE_PL_VCNPRQC_VC1_POSTED_TLP_QUEUE_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNPRQC, field TLP_TYPE_ORDERING_FOR_VC1[30] (RW)
 *
 * TLP Type Ordering for VC1 Determines the TLP type ordering rule for VC1 receive queues, used only
 * in the segmented-buffer configuration, writable through the DBI: 1: Ordering of received TLPs
 * follows the rules in PCI Express Base 3.0 Specification 0: Strict ordering for received TLPs:
 * Posted, then Completion, then Non-Posted
 */
//@{
#define BP_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1      (30)      //!< Bit position for PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1.
#define BM_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1      (0x40000000)  //!< Bit mask for PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1.

//! @brief Get value of PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1 from a register value.
#define BG_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1) >> BP_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1)

//! @brief Format value for bitfield PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1.
#define BF_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1) & BM_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TLP_TYPE_ORDERING_FOR_VC1 field to a new value.
#define BW_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1(v)   (HW_PCIE_PL_VCNPRQC_WR((HW_PCIE_PL_VCNPRQC_RD() & ~BM_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1) | BF_PCIE_PL_VCNPRQC_TLP_TYPE_ORDERING_FOR_VC1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VCNNRQC - VCn Non-Posted Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VCNNRQC - VCn Non-Posted Receive Queue Control (RW)
 *
 * Reset value: 0x00200000
 *
 * Offset: 0x700 + 0x4C + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vcnnrqc
{
    reg32_t U;
    struct _hw_pcie_pl_vcnnrqc_bitfields
    {
        unsigned VC1_NON_POSTED_DATA_CREDITS : 12; //!< [11:0] VC1 Non-Posted Data Credits
        unsigned VC1_NON_POSTED_HEADER_CREDITS : 8; //!< [19:12] VC1 Non-Posted Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC1_NON_POSTED_TLP_QUEUE_MODE : 3; //!< [23:21] VC1 Non-Posted TLP Queue Mode
        unsigned RESERVED1 : 8; //!< [31:24] Reserved
    } B;
} hw_pcie_pl_vcnnrqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VCNNRQC register
 */
//@{
#define HW_PCIE_PL_VCNNRQC_ADDR      (REGS_PCIE_PL_BASE + 0x758)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VCNNRQC           (*(volatile hw_pcie_pl_vcnnrqc_t *) HW_PCIE_PL_VCNNRQC_ADDR)
#define HW_PCIE_PL_VCNNRQC_RD()      (HW_PCIE_PL_VCNNRQC.U)
#define HW_PCIE_PL_VCNNRQC_WR(v)     (HW_PCIE_PL_VCNNRQC.U = (v))
#define HW_PCIE_PL_VCNNRQC_SET(v)    (HW_PCIE_PL_VCNNRQC_WR(HW_PCIE_PL_VCNNRQC_RD() |  (v)))
#define HW_PCIE_PL_VCNNRQC_CLR(v)    (HW_PCIE_PL_VCNNRQC_WR(HW_PCIE_PL_VCNNRQC_RD() & ~(v)))
#define HW_PCIE_PL_VCNNRQC_TOG(v)    (HW_PCIE_PL_VCNNRQC_WR(HW_PCIE_PL_VCNNRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VCNNRQC bitfields
 */

/*! @name Register PCIE_PL_VCNNRQC, field VC1_NON_POSTED_DATA_CREDITS[11:0] (RW)
 *
 * VC1 Non-Posted Data Credits The number of initial Non-Posted data credits for VC1, used for all
 * receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS.
#define BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS) >> BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS.
#define BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_NON_POSTED_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS(v)   (HW_PCIE_PL_VCNNRQC_WR((HW_PCIE_PL_VCNNRQC_RD() & ~BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS) | BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNNRQC, field VC1_NON_POSTED_HEADER_CREDITS[19:12] (RW)
 *
 * VC1 Non-Posted Header Credits The number of initial Non-Posted header credits for VC1, used for
 * all receive queue buffer configurations. This field is not writable through the DBId.
 */
//@{
#define BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS.
#define BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS) >> BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS.
#define BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_NON_POSTED_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS(v)   (HW_PCIE_PL_VCNNRQC_WR((HW_PCIE_PL_VCNNRQC_RD() & ~BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS) | BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNNRQC, field VC1_NON_POSTED_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC1 Non-Posted TLP Queue Mode The operating mode of the Non-Posted receive queue for VC1, used
 * only in the segmented-buffer configuration, writable through the DBI. Only one bit can be set at
 * a time: Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE) >> BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE) & BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_NON_POSTED_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VCNNRQC_WR((HW_PCIE_PL_VCNNRQC_RD() & ~BM_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE) | BF_PCIE_PL_VCNNRQC_VC1_NON_POSTED_TLP_QUEUE_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VCNCRQC - VCn Completion Receive Queue Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VCNCRQC - VCn Completion Receive Queue Control (RW)
 *
 * Reset value: 0x00800000
 *
 * Offset: 0x700 + 0x50 + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vcncrqc
{
    reg32_t U;
    struct _hw_pcie_pl_vcncrqc_bitfields
    {
        unsigned VC1_COMPLETION_DATA_CREDITS : 12; //!< [11:0] VC1 Completion Data Credits
        unsigned VC1_COMPLETION_HEADER_CREDITS : 8; //!< [19:12] VC1 Completion Header Credits
        unsigned RESERVED0 : 1; //!< [20] Reserved
        unsigned VC1_COMPLETION_TLP_QUEUE_MODE : 3; //!< [23:21] VC1 Completion TLP Queue Mode
        unsigned RESERVED1 : 8; //!< [31:24] Reserved
    } B;
} hw_pcie_pl_vcncrqc_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VCNCRQC register
 */
//@{
#define HW_PCIE_PL_VCNCRQC_ADDR      (REGS_PCIE_PL_BASE + 0x75c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VCNCRQC           (*(volatile hw_pcie_pl_vcncrqc_t *) HW_PCIE_PL_VCNCRQC_ADDR)
#define HW_PCIE_PL_VCNCRQC_RD()      (HW_PCIE_PL_VCNCRQC.U)
#define HW_PCIE_PL_VCNCRQC_WR(v)     (HW_PCIE_PL_VCNCRQC.U = (v))
#define HW_PCIE_PL_VCNCRQC_SET(v)    (HW_PCIE_PL_VCNCRQC_WR(HW_PCIE_PL_VCNCRQC_RD() |  (v)))
#define HW_PCIE_PL_VCNCRQC_CLR(v)    (HW_PCIE_PL_VCNCRQC_WR(HW_PCIE_PL_VCNCRQC_RD() & ~(v)))
#define HW_PCIE_PL_VCNCRQC_TOG(v)    (HW_PCIE_PL_VCNCRQC_WR(HW_PCIE_PL_VCNCRQC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VCNCRQC bitfields
 */

/*! @name Register PCIE_PL_VCNCRQC, field VC1_COMPLETION_DATA_CREDITS[11:0] (RW)
 *
 * VC1 Completion Data Credits The number of initial Completion data credits for VC1, used for all
 * receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS      (0)      //!< Bit position for PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS.
#define BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS      (0x00000fff)  //!< Bit mask for PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS.

//! @brief Get value of PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS from a register value.
#define BG_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS) >> BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS.
#define BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_COMPLETION_DATA_CREDITS field to a new value.
#define BW_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS(v)   (HW_PCIE_PL_VCNCRQC_WR((HW_PCIE_PL_VCNCRQC_RD() & ~BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS) | BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_DATA_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNCRQC, field VC1_COMPLETION_HEADER_CREDITS[19:12] (RW)
 *
 * VC1 Completion Header Credits The number of initial Completion header credits for VC1, used for
 * all receive queue buffer configurations. This field is not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS      (12)      //!< Bit position for PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS.
#define BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS      (0x000ff000)  //!< Bit mask for PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS.

//! @brief Get value of PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS from a register value.
#define BG_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS) >> BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS)

//! @brief Format value for bitfield PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS.
#define BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_COMPLETION_HEADER_CREDITS field to a new value.
#define BW_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS(v)   (HW_PCIE_PL_VCNCRQC_WR((HW_PCIE_PL_VCNCRQC_RD() & ~BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS) | BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_HEADER_CREDITS(v)))
#endif
//@}

/*! @name Register PCIE_PL_VCNCRQC, field VC1_COMPLETION_TLP_QUEUE_MODE[23:21] (RW)
 *
 * VC1 Completion TLP Queue Mode The operating mode of the Completion receive queue for VC1, used
 * only in the segmented-buffer configuration, writable through the DBI. Only one bit can be set at
 * a time: Bit 23: Bypass Bit 22: Cut-through Bit 21: Store-and-forward
 */
//@{
#define BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE      (21)      //!< Bit position for PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE.
#define BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE      (0x00e00000)  //!< Bit mask for PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE.

//! @brief Get value of PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE from a register value.
#define BG_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE) >> BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE)

//! @brief Format value for bitfield PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE.
#define BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE) & BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC1_COMPLETION_TLP_QUEUE_MODE field to a new value.
#define BW_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE(v)   (HW_PCIE_PL_VCNCRQC_WR((HW_PCIE_PL_VCNCRQC_RD() & ~BM_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE) | BF_PCIE_PL_VCNCRQC_VC1_COMPLETION_TLP_QUEUE_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0PBD - VC0 Posted Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0PBD - VC0 Posted Buffer Depth (RO)
 *
 * Reset value: 0x000d0065
 *
 * The Buffer Depth registers are used only in the segmented-buffer configuration. Writing to these
 * registers is not possible (through the DBI) Offset: 0x700 + 0xA8
 */
typedef union _hw_pcie_pl_vc0pbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc0pbd_bitfields
    {
        unsigned VC0_POSTED_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC0 Posted Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC0_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC0 Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc0pbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0PBD register
 */
//@{
#define HW_PCIE_PL_VC0PBD_ADDR      (REGS_PCIE_PL_BASE + 0x7a8)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0PBD           (*(volatile hw_pcie_pl_vc0pbd_t *) HW_PCIE_PL_VC0PBD_ADDR)
#define HW_PCIE_PL_VC0PBD_RD()      (HW_PCIE_PL_VC0PBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0PBD bitfields
 */

/*! @name Register PCIE_PL_VC0PBD, field VC0_POSTED_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC0 Posted Data Queue Depth Sets the number of entries in the Posted data queue for VC0 when
 * using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC0PBD_VC0_POSTED_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC0PBD, field VC0_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC0 Posted Header Queue Depth Sets the number of entries in the Posted header queue for VC0 when
 * using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC0PBD_VC0_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0NPBD - VC0 Non-Posted Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0NPBD - VC0 Non-Posted Buffer Depth (RO)
 *
 * Reset value: 0x000d000d
 *
 * Offset: 0x700 + 0xAC
 */
typedef union _hw_pcie_pl_vc0npbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc0npbd_bitfields
    {
        unsigned VC0_NON_POSTED_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC0 Non-Posted Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC0_NON_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC0 Non-Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc0npbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0NPBD register
 */
//@{
#define HW_PCIE_PL_VC0NPBD_ADDR      (REGS_PCIE_PL_BASE + 0x7ac)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0NPBD           (*(volatile hw_pcie_pl_vc0npbd_t *) HW_PCIE_PL_VC0NPBD_ADDR)
#define HW_PCIE_PL_VC0NPBD_RD()      (HW_PCIE_PL_VC0NPBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0NPBD bitfields
 */

/*! @name Register PCIE_PL_VC0NPBD, field VC0_NON_POSTED_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC0 Non-Posted Data Queue Depth Sets the number of entries in the Non-Posted data queue for VC0
 * when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC0NPBD_VC0_NON_POSTED_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC0NPBD, field VC0_NON_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC0 Non-Posted Header Queue Depth Sets the number of entries in the Non-Posted header queue for
 * VC0 when using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC0NPBD_VC0_NON_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC0CBD - VC0 Completion Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC0CBD - VC0 Completion Buffer Depth (RO)
 *
 * Reset value: 0x00030003
 *
 * Offset: 0x700 + 0xB0
 */
typedef union _hw_pcie_pl_vc0cbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc0cbd_bitfields
    {
        unsigned VC0_COMPLETION_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC0 Completion Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC0_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC0 Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc0cbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC0CBD register
 */
//@{
#define HW_PCIE_PL_VC0CBD_ADDR      (REGS_PCIE_PL_BASE + 0x7b0)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC0CBD           (*(volatile hw_pcie_pl_vc0cbd_t *) HW_PCIE_PL_VC0CBD_ADDR)
#define HW_PCIE_PL_VC0CBD_RD()      (HW_PCIE_PL_VC0CBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC0CBD bitfields
 */

/*! @name Register PCIE_PL_VC0CBD, field VC0_COMPLETION_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC0 Completion Data Queue Depth Sets the number of entries in the Completion data queue for VC0
 * when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC0CBD_VC0_COMPLETION_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC0CBD, field VC0_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC0 Posted Header Queue Depth Sets the number of entries in the Completion header queue for VC0
 * when using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC0CBD_VC0_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC1PBD - VCn Posted Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC1PBD - VCn Posted Buffer Depth (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0xA8 + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vc1pbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc1pbd_bitfields
    {
        unsigned VC1_POSTED_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC1 Posted Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC1_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC1 Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc1pbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC1PBD register
 */
//@{
#define HW_PCIE_PL_VC1PBD_ADDR      (REGS_PCIE_PL_BASE + 0x7b4)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC1PBD           (*(volatile hw_pcie_pl_vc1pbd_t *) HW_PCIE_PL_VC1PBD_ADDR)
#define HW_PCIE_PL_VC1PBD_RD()      (HW_PCIE_PL_VC1PBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC1PBD bitfields
 */

/*! @name Register PCIE_PL_VC1PBD, field VC1_POSTED_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC1 Posted Data Queue Depth Sets the number of entries in the Posted data queue for VC1 when
 * using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC1PBD_VC1_POSTED_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC1PBD, field VC1_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC1 Posted Header Queue Depth Sets the number of entries in the Posted header queue for VC1 when
 * using the segmented-buffer configuration.Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC1PBD_VC1_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC1NPBD - VCn Non-Posted Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC1NPBD - VCn Non-Posted Buffer Depth (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0xAC + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vc1npbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc1npbd_bitfields
    {
        unsigned VC1_NON_POSTED_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC1 Non-Posted Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC1_NON_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC1 Non-Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc1npbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC1NPBD register
 */
//@{
#define HW_PCIE_PL_VC1NPBD_ADDR      (REGS_PCIE_PL_BASE + 0x7b8)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC1NPBD           (*(volatile hw_pcie_pl_vc1npbd_t *) HW_PCIE_PL_VC1NPBD_ADDR)
#define HW_PCIE_PL_VC1NPBD_RD()      (HW_PCIE_PL_VC1NPBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC1NPBD bitfields
 */

/*! @name Register PCIE_PL_VC1NPBD, field VC1_NON_POSTED_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC1 Non-Posted Data Queue Depth Sets the number of entries in the Non-Posted data queue for VC1
 * when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC1NPBD_VC1_NON_POSTED_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC1NPBD, field VC1_NON_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC1 Non-Posted Header Queue Depth Sets the number of entries in the Non-Posted header queue for
 * VC1 when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC1NPBD_VC1_NON_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_VC1CBD - VCnCompletion Buffer Depth
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_VC1CBD - VCnCompletion Buffer Depth (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0xB0 + C*n (n=[1:7])
 */
typedef union _hw_pcie_pl_vc1cbd
{
    reg32_t U;
    struct _hw_pcie_pl_vc1cbd_bitfields
    {
        unsigned VC1_COMPLETION_DATA_QUEUE_DEPTH : 14; //!< [13:0] VC1 Completion Data Queue Depth
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VC1_POSTED_HEADER_QUEUE_DEPTH : 10; //!< [25:16] VC1 Posted Header Queue Depth
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_pcie_pl_vc1cbd_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_VC1CBD register
 */
//@{
#define HW_PCIE_PL_VC1CBD_ADDR      (REGS_PCIE_PL_BASE + 0x7bc)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_VC1CBD           (*(volatile hw_pcie_pl_vc1cbd_t *) HW_PCIE_PL_VC1CBD_ADDR)
#define HW_PCIE_PL_VC1CBD_RD()      (HW_PCIE_PL_VC1CBD.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_VC1CBD bitfields
 */

/*! @name Register PCIE_PL_VC1CBD, field VC1_COMPLETION_DATA_QUEUE_DEPTH[13:0] (RO)
 *
 * VC1 Completion Data Queue Depth Sets the number of entries in the Completion data queue for VC1
 * when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH      (0)      //!< Bit position for PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH      (0x00003fff)  //!< Bit mask for PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH) >> BP_PCIE_PL_VC1CBD_VC1_COMPLETION_DATA_QUEUE_DEPTH)
//@}

/*! @name Register PCIE_PL_VC1CBD, field VC1_POSTED_HEADER_QUEUE_DEPTH[25:16] (RO)
 *
 * VC1 Posted Header Queue Depth Sets the number of entries in the Completion header queue for VC1
 * when using the segmented-buffer configuration. Not writable through the DBI
 */
//@{
#define BP_PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH      (16)      //!< Bit position for PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH.
#define BM_PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH      (0x03ff0000)  //!< Bit mask for PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH.

//! @brief Get value of PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH from a register value.
#define BG_PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH) >> BP_PCIE_PL_VC1CBD_VC1_POSTED_HEADER_QUEUE_DEPTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_G2CR - Gen2 Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_G2CR - Gen2 Control Register (RW)
 *
 * Reset value: 0x00000001
 *
 * The Port Logic Gen2 Control Register controls features specific to data rates greater than 2.5
 * GT/s. The "Lane Enable" field is an exception in that it applies regardless of the data rate.
 * Offset: 0x700 + 0x10C
 */
typedef union _hw_pcie_pl_g2cr
{
    reg32_t U;
    struct _hw_pcie_pl_g2cr_bitfields
    {
        unsigned N_FTS : 8; //!< [7:0] Sets the Number of Fast Training Sequences (N_FTS) that the core advertises as its N_FTS during Gen2 Link training.
        unsigned PREDETERMINED_NUMBER_OF_LANES : 9; //!< [16:8] Predetermined Number of Lanes
        unsigned DIRECTED_SPEED_CHANGE : 1; //!< [17] Directed Speed Change
        unsigned CONFIG_PHY_TX_SWING : 1; //!< [18] Config PHY Tx Swing
        unsigned CONFIG_TX_COMPLIANCE_RECEIVE_BIT : 1; //!< [19] Config Tx Compliance Receive Bit
        unsigned DE_EMPHASIS_LEVEL : 1; //!< [20] Used to set the de-emphasis level for upstream ports.
        unsigned RESERVED0 : 11; //!< [31:21] Reserved
    } B;
} hw_pcie_pl_g2cr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_G2CR register
 */
//@{
#define HW_PCIE_PL_G2CR_ADDR      (REGS_PCIE_PL_BASE + 0x80c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_G2CR           (*(volatile hw_pcie_pl_g2cr_t *) HW_PCIE_PL_G2CR_ADDR)
#define HW_PCIE_PL_G2CR_RD()      (HW_PCIE_PL_G2CR.U)
#define HW_PCIE_PL_G2CR_WR(v)     (HW_PCIE_PL_G2CR.U = (v))
#define HW_PCIE_PL_G2CR_SET(v)    (HW_PCIE_PL_G2CR_WR(HW_PCIE_PL_G2CR_RD() |  (v)))
#define HW_PCIE_PL_G2CR_CLR(v)    (HW_PCIE_PL_G2CR_WR(HW_PCIE_PL_G2CR_RD() & ~(v)))
#define HW_PCIE_PL_G2CR_TOG(v)    (HW_PCIE_PL_G2CR_WR(HW_PCIE_PL_G2CR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_G2CR bitfields
 */

/*! @name Register PCIE_PL_G2CR, field N_FTS[7:0] (RW)
 *
 * Sets the Number of Fast Training Sequences (N_FTS) that the core advertises as its N_FTS during
 * Gen2 Link training. This value is used to inform the Link partner about the PHY's ability to
 * recover synchronization after a low power state. The number should be provided by the PHY vendor.
 * Note : Do not set N_FTS to zero; doing so can cause the LTSSM to go into the recovery state when
 * exiting from L0s.
 */
//@{
#define BP_PCIE_PL_G2CR_N_FTS      (0)      //!< Bit position for PCIE_PL_G2CR_N_FTS.
#define BM_PCIE_PL_G2CR_N_FTS      (0x000000ff)  //!< Bit mask for PCIE_PL_G2CR_N_FTS.

//! @brief Get value of PCIE_PL_G2CR_N_FTS from a register value.
#define BG_PCIE_PL_G2CR_N_FTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_N_FTS) >> BP_PCIE_PL_G2CR_N_FTS)

//! @brief Format value for bitfield PCIE_PL_G2CR_N_FTS.
#define BF_PCIE_PL_G2CR_N_FTS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_N_FTS) & BM_PCIE_PL_G2CR_N_FTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the N_FTS field to a new value.
#define BW_PCIE_PL_G2CR_N_FTS(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_N_FTS) | BF_PCIE_PL_G2CR_N_FTS(v)))
#endif
//@}

/*! @name Register PCIE_PL_G2CR, field PREDETERMINED_NUMBER_OF_LANES[16:8] (RW)
 *
 * Predetermined Number of Lanes Used to limit the effective link width to ignore "broken" lanes
 * that detect a receiver. Indicates the number of lanes to check for exit from Electrical Idle in
 * POLLING.ACTIVE and L2.IDLE. It is possible that the LTSSM may detect a Receiver on a 'bad' or
 * 'broken' lane during the Detect Sub-state. However, it is also possible that such a lane may also
 * fail to exit Electrical Idle and therefore prevent a valid link from being configured. Encoding
 * is as follows: 0x01 = 1 lane
 */
//@{
#define BP_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES      (8)      //!< Bit position for PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES.
#define BM_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES      (0x0001ff00)  //!< Bit mask for PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES.

//! @brief Get value of PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES from a register value.
#define BG_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES) >> BP_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES)

//! @brief Format value for bitfield PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES.
#define BF_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES) & BM_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PREDETERMINED_NUMBER_OF_LANES field to a new value.
#define BW_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES) | BF_PCIE_PL_G2CR_PREDETERMINED_NUMBER_OF_LANES(v)))
#endif
//@}

/*! @name Register PCIE_PL_G2CR, field DIRECTED_SPEED_CHANGE[17] (RW)
 *
 * Directed Speed Change Indicates to the LTSSM whether or not to initiate a speed change to Gen2
 */
//@{
#define BP_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE      (17)      //!< Bit position for PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE.
#define BM_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE      (0x00020000)  //!< Bit mask for PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE.

//! @brief Get value of PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE from a register value.
#define BG_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE) >> BP_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE)

//! @brief Format value for bitfield PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE.
#define BF_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE) & BM_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIRECTED_SPEED_CHANGE field to a new value.
#define BW_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE) | BF_PCIE_PL_G2CR_DIRECTED_SPEED_CHANGE(v)))
#endif
//@}

/*! @name Register PCIE_PL_G2CR, field CONFIG_PHY_TX_SWING[18] (RW)
 *
 * Config PHY Tx Swing Indicates the voltage level the PHY should drive. When set to 1, indicates
 * Full Swing. When set to 0, indicates Low Swing
 */
//@{
#define BP_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING      (18)      //!< Bit position for PCIE_PL_G2CR_CONFIG_PHY_TX_SWING.
#define BM_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING      (0x00040000)  //!< Bit mask for PCIE_PL_G2CR_CONFIG_PHY_TX_SWING.

//! @brief Get value of PCIE_PL_G2CR_CONFIG_PHY_TX_SWING from a register value.
#define BG_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING) >> BP_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING)

//! @brief Format value for bitfield PCIE_PL_G2CR_CONFIG_PHY_TX_SWING.
#define BF_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING) & BM_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CONFIG_PHY_TX_SWING field to a new value.
#define BW_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING) | BF_PCIE_PL_G2CR_CONFIG_PHY_TX_SWING(v)))
#endif
//@}

/*! @name Register PCIE_PL_G2CR, field CONFIG_TX_COMPLIANCE_RECEIVE_BIT[19] (RW)
 *
 * Config Tx Compliance Receive Bit When set to 1, signals LTSSM to transmit TS ordered sets with
 * the compliance receive bit assert (equal to 1).
 */
//@{
#define BP_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT      (19)      //!< Bit position for PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT.
#define BM_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT      (0x00080000)  //!< Bit mask for PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT.

//! @brief Get value of PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT from a register value.
#define BG_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT) >> BP_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT)

//! @brief Format value for bitfield PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT.
#define BF_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT) & BM_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CONFIG_TX_COMPLIANCE_RECEIVE_BIT field to a new value.
#define BW_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT) | BF_PCIE_PL_G2CR_CONFIG_TX_COMPLIANCE_RECEIVE_BIT(v)))
#endif
//@}

/*! @name Register PCIE_PL_G2CR, field DE_EMPHASIS_LEVEL[20] (RW)
 *
 * Used to set the de-emphasis level for upstream ports.
 */
//@{
#define BP_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL      (20)      //!< Bit position for PCIE_PL_G2CR_DE_EMPHASIS_LEVEL.
#define BM_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL      (0x00100000)  //!< Bit mask for PCIE_PL_G2CR_DE_EMPHASIS_LEVEL.

//! @brief Get value of PCIE_PL_G2CR_DE_EMPHASIS_LEVEL from a register value.
#define BG_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL) >> BP_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL)

//! @brief Format value for bitfield PCIE_PL_G2CR_DE_EMPHASIS_LEVEL.
#define BF_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL) & BM_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DE_EMPHASIS_LEVEL field to a new value.
#define BW_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL(v)   (HW_PCIE_PL_G2CR_WR((HW_PCIE_PL_G2CR_RD() & ~BM_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL) | BF_PCIE_PL_G2CR_DE_EMPHASIS_LEVEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_PHY_STATUS - PHY Status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_PHY_STATUS - PHY Status (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x110
 */
typedef union _hw_pcie_pl_phy_status
{
    reg32_t U;
    struct _hw_pcie_pl_phy_status_bitfields
    {
        unsigned PHY_STATUS : 32; //!< [31:0] PHY Status
    } B;
} hw_pcie_pl_phy_status_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_PHY_STATUS register
 */
//@{
#define HW_PCIE_PL_PHY_STATUS_ADDR      (REGS_PCIE_PL_BASE + 0x810)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_PHY_STATUS           (*(volatile hw_pcie_pl_phy_status_t *) HW_PCIE_PL_PHY_STATUS_ADDR)
#define HW_PCIE_PL_PHY_STATUS_RD()      (HW_PCIE_PL_PHY_STATUS.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_PHY_STATUS bitfields
 */

/*! @name Register PCIE_PL_PHY_STATUS, field PHY_STATUS[31:0] (RO)
 *
 * PHY Status Data received directly from the phy_cfg_status bus.
 */
//@{
#define BP_PCIE_PL_PHY_STATUS_PHY_STATUS      (0)      //!< Bit position for PCIE_PL_PHY_STATUS_PHY_STATUS.
#define BM_PCIE_PL_PHY_STATUS_PHY_STATUS      (0xffffffff)  //!< Bit mask for PCIE_PL_PHY_STATUS_PHY_STATUS.

//! @brief Get value of PCIE_PL_PHY_STATUS_PHY_STATUS from a register value.
#define BG_PCIE_PL_PHY_STATUS_PHY_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PHY_STATUS_PHY_STATUS) >> BP_PCIE_PL_PHY_STATUS_PHY_STATUS)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_PHY_CTRL - PHY Control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_PHY_CTRL - PHY Control (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x114
 */
typedef union _hw_pcie_pl_phy_ctrl
{
    reg32_t U;
    struct _hw_pcie_pl_phy_ctrl_bitfields
    {
        unsigned PHY_CONTROL : 32; //!< [31:0] PHY Control
    } B;
} hw_pcie_pl_phy_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_PHY_CTRL register
 */
//@{
#define HW_PCIE_PL_PHY_CTRL_ADDR      (REGS_PCIE_PL_BASE + 0x814)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_PHY_CTRL           (*(volatile hw_pcie_pl_phy_ctrl_t *) HW_PCIE_PL_PHY_CTRL_ADDR)
#define HW_PCIE_PL_PHY_CTRL_RD()      (HW_PCIE_PL_PHY_CTRL.U)
#define HW_PCIE_PL_PHY_CTRL_WR(v)     (HW_PCIE_PL_PHY_CTRL.U = (v))
#define HW_PCIE_PL_PHY_CTRL_SET(v)    (HW_PCIE_PL_PHY_CTRL_WR(HW_PCIE_PL_PHY_CTRL_RD() |  (v)))
#define HW_PCIE_PL_PHY_CTRL_CLR(v)    (HW_PCIE_PL_PHY_CTRL_WR(HW_PCIE_PL_PHY_CTRL_RD() & ~(v)))
#define HW_PCIE_PL_PHY_CTRL_TOG(v)    (HW_PCIE_PL_PHY_CTRL_WR(HW_PCIE_PL_PHY_CTRL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_PHY_CTRL bitfields
 */

/*! @name Register PCIE_PL_PHY_CTRL, field PHY_CONTROL[31:0] (RW)
 *
 * PHY Control Data sent directly to the cfg_phy_control bus.
 */
//@{
#define BP_PCIE_PL_PHY_CTRL_PHY_CONTROL      (0)      //!< Bit position for PCIE_PL_PHY_CTRL_PHY_CONTROL.
#define BM_PCIE_PL_PHY_CTRL_PHY_CONTROL      (0xffffffff)  //!< Bit mask for PCIE_PL_PHY_CTRL_PHY_CONTROL.

//! @brief Get value of PCIE_PL_PHY_CTRL_PHY_CONTROL from a register value.
#define BG_PCIE_PL_PHY_CTRL_PHY_CONTROL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_PHY_CTRL_PHY_CONTROL) >> BP_PCIE_PL_PHY_CTRL_PHY_CONTROL)

//! @brief Format value for bitfield PCIE_PL_PHY_CTRL_PHY_CONTROL.
#define BF_PCIE_PL_PHY_CTRL_PHY_CONTROL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_PHY_CTRL_PHY_CONTROL) & BM_PCIE_PL_PHY_CTRL_PHY_CONTROL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHY_CONTROL field to a new value.
#define BW_PCIE_PL_PHY_CTRL_PHY_CONTROL(v)   (HW_PCIE_PL_PHY_CTRL_WR((HW_PCIE_PL_PHY_CTRL_RD() & ~BM_PCIE_PL_PHY_CTRL_PHY_CONTROL) | BF_PCIE_PL_PHY_CTRL_PHY_CONTROL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MRCCR0 - Master Response Composer Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MRCCR0 - Master Response Composer Control Register 0 (RW)
 *
 * Reset value: 0x00000302
 *
 * You must not modify these registers for AHB configurations, as this feature is only supported for
 * AXI. Offset: 0x700 + 0x118
 */
typedef union _hw_pcie_pl_mrccr0
{
    reg32_t U;
    struct _hw_pcie_pl_mrccr0_bitfields
    {
        unsigned REMOTE_READ_REQUEST_SIZE : 3; //!< [2:0] Remote Read Request Size
        unsigned RESERVED0 : 5; //!< [7:3] Reserved
        unsigned REMOTE_MAX_BRIDGE_TAG : 8; //!< [15:8] Remote Max Bridge Tag
        unsigned RESERVED1 : 16; //!< [31:16] Reserved
    } B;
} hw_pcie_pl_mrccr0_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MRCCR0 register
 */
//@{
#define HW_PCIE_PL_MRCCR0_ADDR      (REGS_PCIE_PL_BASE + 0x818)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MRCCR0           (*(volatile hw_pcie_pl_mrccr0_t *) HW_PCIE_PL_MRCCR0_ADDR)
#define HW_PCIE_PL_MRCCR0_RD()      (HW_PCIE_PL_MRCCR0.U)
#define HW_PCIE_PL_MRCCR0_WR(v)     (HW_PCIE_PL_MRCCR0.U = (v))
#define HW_PCIE_PL_MRCCR0_SET(v)    (HW_PCIE_PL_MRCCR0_WR(HW_PCIE_PL_MRCCR0_RD() |  (v)))
#define HW_PCIE_PL_MRCCR0_CLR(v)    (HW_PCIE_PL_MRCCR0_WR(HW_PCIE_PL_MRCCR0_RD() & ~(v)))
#define HW_PCIE_PL_MRCCR0_TOG(v)    (HW_PCIE_PL_MRCCR0_WR(HW_PCIE_PL_MRCCR0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MRCCR0 bitfields
 */

/*! @name Register PCIE_PL_MRCCR0, field REMOTE_READ_REQUEST_SIZE[2:0] (RW)
 *
 * Remote Read Request Size Specifies the largest amount of data (bytes) that will ever be requested
 * (via an inbound MemRd TLP) by a remote device. Must never be programmed with a value that exceeds
 * the value represented by the configuration parameter CX_REMOTE_RD_REQ_SIZE as the Master Response
 * Composer RAM in the AXI bridge is sized using CX_REMOTE_RD_REQ_SIZE. Must only be programmed with
 * the values 3'b000 to 3'b101. Any other value has the same effect as writing a value of 3'b000.
 * Encoding is as follows:
 *
 * Values:
 * - 000 - 128
 * - 001 - 256
 * - 010 - 512
 * - 011 - 1024
 * - 100 - 2048
 * - 101 - 4096 default: 128
 */
//@{
#define BP_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE      (0)      //!< Bit position for PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE.
#define BM_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE      (0x00000007)  //!< Bit mask for PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE.

//! @brief Get value of PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE from a register value.
#define BG_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE) >> BP_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE)

//! @brief Format value for bitfield PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE.
#define BF_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE) & BM_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REMOTE_READ_REQUEST_SIZE field to a new value.
#define BW_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE(v)   (HW_PCIE_PL_MRCCR0_WR((HW_PCIE_PL_MRCCR0_RD() & ~BM_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE) | BF_PCIE_PL_MRCCR0_REMOTE_READ_REQUEST_SIZE(v)))
#endif
//@}

/*! @name Register PCIE_PL_MRCCR0, field REMOTE_MAX_BRIDGE_TAG[15:8] (RW)
 *
 * Remote Max Bridge Tag Specifies the maximum number (-1) of Non-Posted AMBA requests outstanding
 * at one time issued from the bridge master. Excludes any internally created TLP's as a result of
 * decomposition. The core will automatically derive this when bits[2:0] (Remote Read Request Size)
 * are written to. It is s saturated in core at CX_REMOTE_MAX_TAG since the TRGT_CPL_LUT has only
 * this many entries. Therefore it is important that the core is initially sized (at configuration
 * time pre-silicon) with the true maximum value of CX_REMOTE_MAX_TAG to take advantage of the
 * ability to dynamically increase remote_max_bridge_tag from CX_REMOTE_MAX_BRIDGE_TAG to any new
 * value up to a maximum of CX_REMOTE_MAX_TAG
 */
//@{
#define BP_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG      (8)      //!< Bit position for PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG.
#define BM_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG      (0x0000ff00)  //!< Bit mask for PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG.

//! @brief Get value of PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG from a register value.
#define BG_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG) >> BP_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG)

//! @brief Format value for bitfield PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG.
#define BF_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG) & BM_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REMOTE_MAX_BRIDGE_TAG field to a new value.
#define BW_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG(v)   (HW_PCIE_PL_MRCCR0_WR((HW_PCIE_PL_MRCCR0_RD() & ~BM_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG) | BF_PCIE_PL_MRCCR0_REMOTE_MAX_BRIDGE_TAG(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MRCCR1 - Master Response Composer Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MRCCR1 - Master Response Composer Control Register 1 (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x11C
 */
typedef union _hw_pcie_pl_mrccr1
{
    reg32_t U;
    struct _hw_pcie_pl_mrccr1_bitfields
    {
        unsigned SEGMENTED_BUFFER_CONTROLLER_INITIALIZE : 1; //!< [0] Segmented Buffer Controller Initialize.
        unsigned RESERVED0 : 31; //!< [31:1] Reserved
    } B;
} hw_pcie_pl_mrccr1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MRCCR1 register
 */
//@{
#define HW_PCIE_PL_MRCCR1_ADDR      (REGS_PCIE_PL_BASE + 0x81c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MRCCR1           (*(volatile hw_pcie_pl_mrccr1_t *) HW_PCIE_PL_MRCCR1_ADDR)
#define HW_PCIE_PL_MRCCR1_RD()      (HW_PCIE_PL_MRCCR1.U)
#define HW_PCIE_PL_MRCCR1_WR(v)     (HW_PCIE_PL_MRCCR1.U = (v))
#define HW_PCIE_PL_MRCCR1_SET(v)    (HW_PCIE_PL_MRCCR1_WR(HW_PCIE_PL_MRCCR1_RD() |  (v)))
#define HW_PCIE_PL_MRCCR1_CLR(v)    (HW_PCIE_PL_MRCCR1_WR(HW_PCIE_PL_MRCCR1_RD() & ~(v)))
#define HW_PCIE_PL_MRCCR1_TOG(v)    (HW_PCIE_PL_MRCCR1_WR(HW_PCIE_PL_MRCCR1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MRCCR1 bitfields
 */

/*! @name Register PCIE_PL_MRCCR1, field SEGMENTED_BUFFER_CONTROLLER_INITIALIZE[0] (RW)
 *
 * Segmented Buffer Controller Initialize. Writing '1' to this (self-clearing register) causes any
 * changes in the Master Response Composer Control Register 0 to take place in the bridge hardware.
 * The sbc_init register triggers the initialization of the segmented buffer controller (DWC_sbc).
 * When sbc_init is written to, the segmented buffer controller (DWC_sbc) samples
 * cfg_remote_max_bridge_tag and starts the internal finite state machine (FSM). * Reading from this
 * self-clearing register field always returns a 0.
 */
//@{
#define BP_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE      (0)      //!< Bit position for PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE.
#define BM_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE      (0x00000001)  //!< Bit mask for PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE.

//! @brief Get value of PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE from a register value.
#define BG_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE) >> BP_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE)

//! @brief Format value for bitfield PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE.
#define BF_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE) & BM_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEGMENTED_BUFFER_CONTROLLER_INITIALIZE field to a new value.
#define BW_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE(v)   (HW_PCIE_PL_MRCCR1_WR((HW_PCIE_PL_MRCCR1_RD() & ~BM_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE) | BF_PCIE_PL_MRCCR1_SEGMENTED_BUFFER_CONTROLLER_INITIALIZE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICA - MSI Controller Address
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICA - MSI Controller Address (RW)
 *
 * Reset value: 0x00000000
 *
 * See . These registers are not part of the PCI Express MSI Capability Register structure which is
 * detailed at MSI Capability Register Details. Offset: 0x700 + 0x120
 */
typedef union _hw_pcie_pl_msica
{
    reg32_t U;
    struct _hw_pcie_pl_msica_bitfields
    {
        unsigned MSI_CONTROLLER_ADDRESS : 32; //!< [31:0] MSI Controller Address
    } B;
} hw_pcie_pl_msica_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICA register
 */
//@{
#define HW_PCIE_PL_MSICA_ADDR      (REGS_PCIE_PL_BASE + 0x820)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICA           (*(volatile hw_pcie_pl_msica_t *) HW_PCIE_PL_MSICA_ADDR)
#define HW_PCIE_PL_MSICA_RD()      (HW_PCIE_PL_MSICA.U)
#define HW_PCIE_PL_MSICA_WR(v)     (HW_PCIE_PL_MSICA.U = (v))
#define HW_PCIE_PL_MSICA_SET(v)    (HW_PCIE_PL_MSICA_WR(HW_PCIE_PL_MSICA_RD() |  (v)))
#define HW_PCIE_PL_MSICA_CLR(v)    (HW_PCIE_PL_MSICA_WR(HW_PCIE_PL_MSICA_RD() & ~(v)))
#define HW_PCIE_PL_MSICA_TOG(v)    (HW_PCIE_PL_MSICA_WR(HW_PCIE_PL_MSICA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICA bitfields
 */

/*! @name Register PCIE_PL_MSICA, field MSI_CONTROLLER_ADDRESS[31:0] (RW)
 *
 * MSI Controller Address System specified address for MSI memory write transaction termination.
 * Within the AHB/AXI Bridge, every received Memory Write Request is examined to see if it targets
 * the MSI Address that has been specified in the MSI Controller Address Register and also to see if
 * it satisfies the definition of an MSI Interrupt Request. If these conditions are satisfied the
 * Memory Write Request is marked as an MSI Request.
 */
//@{
#define BP_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS      (0)      //!< Bit position for PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS.
#define BM_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS.

//! @brief Get value of PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS from a register value.
#define BG_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS) >> BP_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS)

//! @brief Format value for bitfield PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS.
#define BF_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS) & BM_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_CONTROLLER_ADDRESS field to a new value.
#define BW_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS(v)   (HW_PCIE_PL_MSICA_WR((HW_PCIE_PL_MSICA_RD() & ~BM_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS) | BF_PCIE_PL_MSICA_MSI_CONTROLLER_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICUA - MSI Controller Upper Address
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICUA - MSI Controller Upper Address (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x124
 */
typedef union _hw_pcie_pl_msicua
{
    reg32_t U;
    struct _hw_pcie_pl_msicua_bitfields
    {
        unsigned MSI_CONTROLLER_UPPER_ADDRESS : 32; //!< [31:0] MSI Controller Upper Address
    } B;
} hw_pcie_pl_msicua_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICUA register
 */
//@{
#define HW_PCIE_PL_MSICUA_ADDR      (REGS_PCIE_PL_BASE + 0x824)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICUA           (*(volatile hw_pcie_pl_msicua_t *) HW_PCIE_PL_MSICUA_ADDR)
#define HW_PCIE_PL_MSICUA_RD()      (HW_PCIE_PL_MSICUA.U)
#define HW_PCIE_PL_MSICUA_WR(v)     (HW_PCIE_PL_MSICUA.U = (v))
#define HW_PCIE_PL_MSICUA_SET(v)    (HW_PCIE_PL_MSICUA_WR(HW_PCIE_PL_MSICUA_RD() |  (v)))
#define HW_PCIE_PL_MSICUA_CLR(v)    (HW_PCIE_PL_MSICUA_WR(HW_PCIE_PL_MSICUA_RD() & ~(v)))
#define HW_PCIE_PL_MSICUA_TOG(v)    (HW_PCIE_PL_MSICUA_WR(HW_PCIE_PL_MSICUA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICUA bitfields
 */

/*! @name Register PCIE_PL_MSICUA, field MSI_CONTROLLER_UPPER_ADDRESS[31:0] (RW)
 *
 * MSI Controller Upper Address System specified upper address for MSI memory write transaction
 * termination. Allows functions to support a 64- bit MSI address.
 */
//@{
#define BP_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS      (0)      //!< Bit position for PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS.
#define BM_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS.

//! @brief Get value of PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS from a register value.
#define BG_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS) >> BP_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS)

//! @brief Format value for bitfield PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS.
#define BF_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS) & BM_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_CONTROLLER_UPPER_ADDRESS field to a new value.
#define BW_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS(v)   (HW_PCIE_PL_MSICUA_WR((HW_PCIE_PL_MSICUA_RD() & ~BM_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS) | BF_PCIE_PL_MSICUA_MSI_CONTROLLER_UPPER_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICIN_ENB - MSI Controller Interrupt n Enable
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICIN_ENB - MSI Controller Interrupt n Enable (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x128 + C*n (n=[0:7])
 */
typedef union _hw_pcie_pl_msicin_enb
{
    reg32_t U;
    struct _hw_pcie_pl_msicin_enb_bitfields
    {
        unsigned MSI_INTERRUPT0_ENABLE : 32; //!< [31:0] MSI Interrupt#0 Enable
    } B;
} hw_pcie_pl_msicin_enb_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICIN_ENB register
 */
//@{
#define HW_PCIE_PL_MSICIN_ENB_ADDR      (REGS_PCIE_PL_BASE + 0x828)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICIN_ENB           (*(volatile hw_pcie_pl_msicin_enb_t *) HW_PCIE_PL_MSICIN_ENB_ADDR)
#define HW_PCIE_PL_MSICIN_ENB_RD()      (HW_PCIE_PL_MSICIN_ENB.U)
#define HW_PCIE_PL_MSICIN_ENB_WR(v)     (HW_PCIE_PL_MSICIN_ENB.U = (v))
#define HW_PCIE_PL_MSICIN_ENB_SET(v)    (HW_PCIE_PL_MSICIN_ENB_WR(HW_PCIE_PL_MSICIN_ENB_RD() |  (v)))
#define HW_PCIE_PL_MSICIN_ENB_CLR(v)    (HW_PCIE_PL_MSICIN_ENB_WR(HW_PCIE_PL_MSICIN_ENB_RD() & ~(v)))
#define HW_PCIE_PL_MSICIN_ENB_TOG(v)    (HW_PCIE_PL_MSICIN_ENB_WR(HW_PCIE_PL_MSICIN_ENB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICIN_ENB bitfields
 */

/*! @name Register PCIE_PL_MSICIN_ENB, field MSI_INTERRUPT0_ENABLE[31:0] (RW)
 *
 * MSI Interrupt#0 Enable Specifies which interrupts are enabled. If an MSI is received from a
 * disabled interrupt, no status bit gets set in MSI Controller Interrupt Status Register. Each bit
 * corresponds to a single MSI Interrupt Vector.
 */
//@{
#define BP_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE      (0)      //!< Bit position for PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE.
#define BM_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE.

//! @brief Get value of PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE from a register value.
#define BG_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE) >> BP_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE)

//! @brief Format value for bitfield PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE.
#define BF_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE) & BM_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_INTERRUPT0_ENABLE field to a new value.
#define BW_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE(v)   (HW_PCIE_PL_MSICIN_ENB_WR((HW_PCIE_PL_MSICIN_ENB_RD() & ~BM_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE) | BF_PCIE_PL_MSICIN_ENB_MSI_INTERRUPT0_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICIN_MASK - MSI Controller Interrupt n Mask
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICIN_MASK - MSI Controller Interrupt n Mask (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x12C + C*n (n=[0:7])
 */
typedef union _hw_pcie_pl_msicin_mask
{
    reg32_t U;
    struct _hw_pcie_pl_msicin_mask_bitfields
    {
        unsigned MSI_INTERRUPT0_MASK : 32; //!< [31:0] MSI Interrupt#0 Mask
    } B;
} hw_pcie_pl_msicin_mask_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICIN_MASK register
 */
//@{
#define HW_PCIE_PL_MSICIN_MASK_ADDR      (REGS_PCIE_PL_BASE + 0x82c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICIN_MASK           (*(volatile hw_pcie_pl_msicin_mask_t *) HW_PCIE_PL_MSICIN_MASK_ADDR)
#define HW_PCIE_PL_MSICIN_MASK_RD()      (HW_PCIE_PL_MSICIN_MASK.U)
#define HW_PCIE_PL_MSICIN_MASK_WR(v)     (HW_PCIE_PL_MSICIN_MASK.U = (v))
#define HW_PCIE_PL_MSICIN_MASK_SET(v)    (HW_PCIE_PL_MSICIN_MASK_WR(HW_PCIE_PL_MSICIN_MASK_RD() |  (v)))
#define HW_PCIE_PL_MSICIN_MASK_CLR(v)    (HW_PCIE_PL_MSICIN_MASK_WR(HW_PCIE_PL_MSICIN_MASK_RD() & ~(v)))
#define HW_PCIE_PL_MSICIN_MASK_TOG(v)    (HW_PCIE_PL_MSICIN_MASK_WR(HW_PCIE_PL_MSICIN_MASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICIN_MASK bitfields
 */

/*! @name Register PCIE_PL_MSICIN_MASK, field MSI_INTERRUPT0_MASK[31:0] (RW)
 *
 * MSI Interrupt#0 Mask Allows enabled interrupts to be masked. If an MSI is received for a masked
 * interrupt, the corresponding status bit gets set in the Interrupt Status Register but the
 * msi_ctrl_int output is not set HIGH. Each bit corresponds to a single MSI Interrupt Vector.
 */
//@{
#define BP_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK      (0)      //!< Bit position for PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK.
#define BM_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK.

//! @brief Get value of PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK from a register value.
#define BG_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK) >> BP_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK)

//! @brief Format value for bitfield PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK.
#define BF_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK) & BM_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_INTERRUPT0_MASK field to a new value.
#define BW_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK(v)   (HW_PCIE_PL_MSICIN_MASK_WR((HW_PCIE_PL_MSICIN_MASK_RD() & ~BM_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK) | BF_PCIE_PL_MSICIN_MASK_MSI_INTERRUPT0_MASK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICIN_STATUS - MSI Controller Interrupt nStatus
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICIN_STATUS - MSI Controller Interrupt nStatus (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x130 + C*n (n=[0:7])
 */
typedef union _hw_pcie_pl_msicin_status
{
    reg32_t U;
    struct _hw_pcie_pl_msicin_status_bitfields
    {
        unsigned MSI_INTERRUPT0_STATUS : 32; //!< [31:0] MSI Interrupt#0 Status
    } B;
} hw_pcie_pl_msicin_status_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICIN_STATUS register
 */
//@{
#define HW_PCIE_PL_MSICIN_STATUS_ADDR      (REGS_PCIE_PL_BASE + 0x830)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICIN_STATUS           (*(volatile hw_pcie_pl_msicin_status_t *) HW_PCIE_PL_MSICIN_STATUS_ADDR)
#define HW_PCIE_PL_MSICIN_STATUS_RD()      (HW_PCIE_PL_MSICIN_STATUS.U)
#define HW_PCIE_PL_MSICIN_STATUS_WR(v)     (HW_PCIE_PL_MSICIN_STATUS.U = (v))
#define HW_PCIE_PL_MSICIN_STATUS_SET(v)    (HW_PCIE_PL_MSICIN_STATUS_WR(HW_PCIE_PL_MSICIN_STATUS_RD() |  (v)))
#define HW_PCIE_PL_MSICIN_STATUS_CLR(v)    (HW_PCIE_PL_MSICIN_STATUS_WR(HW_PCIE_PL_MSICIN_STATUS_RD() & ~(v)))
#define HW_PCIE_PL_MSICIN_STATUS_TOG(v)    (HW_PCIE_PL_MSICIN_STATUS_WR(HW_PCIE_PL_MSICIN_STATUS_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICIN_STATUS bitfields
 */

/*! @name Register PCIE_PL_MSICIN_STATUS, field MSI_INTERRUPT0_STATUS[31:0] (RW)
 *
 * MSI Interrupt#0 Status If an MSI is detected for EP#0, one bit in this register is set. The
 * decoding of the data payload of the MSI Memory Write Request determines which bit gets set. A
 * status is bit is cleared by writing a 1 to the bit. Each bit corresponds to a single MSI
 * Interrupt Vector.
 */
//@{
#define BP_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS      (0)      //!< Bit position for PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS.
#define BM_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS.

//! @brief Get value of PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS from a register value.
#define BG_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS) >> BP_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS)

//! @brief Format value for bitfield PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS.
#define BF_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS) & BM_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_INTERRUPT0_STATUS field to a new value.
#define BW_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS(v)   (HW_PCIE_PL_MSICIN_STATUS_WR((HW_PCIE_PL_MSICIN_STATUS_RD() & ~BM_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS) | BF_PCIE_PL_MSICIN_STATUS_MSI_INTERRUPT0_STATUS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_MSICGPIO - MSI Controller General Purpose IO Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_MSICGPIO - MSI Controller General Purpose IO Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x188
 */
typedef union _hw_pcie_pl_msicgpio
{
    reg32_t U;
    struct _hw_pcie_pl_msicgpio_bitfields
    {
        unsigned MSI_GPIO_REGISTER : 32; //!< [31:0] MSI GPIO Register
    } B;
} hw_pcie_pl_msicgpio_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_MSICGPIO register
 */
//@{
#define HW_PCIE_PL_MSICGPIO_ADDR      (REGS_PCIE_PL_BASE + 0x888)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_MSICGPIO           (*(volatile hw_pcie_pl_msicgpio_t *) HW_PCIE_PL_MSICGPIO_ADDR)
#define HW_PCIE_PL_MSICGPIO_RD()      (HW_PCIE_PL_MSICGPIO.U)
#define HW_PCIE_PL_MSICGPIO_WR(v)     (HW_PCIE_PL_MSICGPIO.U = (v))
#define HW_PCIE_PL_MSICGPIO_SET(v)    (HW_PCIE_PL_MSICGPIO_WR(HW_PCIE_PL_MSICGPIO_RD() |  (v)))
#define HW_PCIE_PL_MSICGPIO_CLR(v)    (HW_PCIE_PL_MSICGPIO_WR(HW_PCIE_PL_MSICGPIO_RD() & ~(v)))
#define HW_PCIE_PL_MSICGPIO_TOG(v)    (HW_PCIE_PL_MSICGPIO_WR(HW_PCIE_PL_MSICGPIO_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_MSICGPIO bitfields
 */

/*! @name Register PCIE_PL_MSICGPIO, field MSI_GPIO_REGISTER[31:0] (RW)
 *
 * MSI GPIO Register The contents of this register drives the top-level output msi_ctrl_io[31:0]
 */
//@{
#define BP_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER      (0)      //!< Bit position for PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER.
#define BM_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER      (0xffffffff)  //!< Bit mask for PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER.

//! @brief Get value of PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER from a register value.
#define BG_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER) >> BP_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER)

//! @brief Format value for bitfield PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER.
#define BF_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER) & BM_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSI_GPIO_REGISTER field to a new value.
#define BW_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER(v)   (HW_PCIE_PL_MSICGPIO_WR((HW_PCIE_PL_MSICGPIO_RD() & ~BM_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER) | BF_PCIE_PL_MSICGPIO_MSI_GPIO_REGISTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATUVR - iATU Viewport Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATUVR - iATU Viewport Register (RW)
 *
 * Reset value: 0x00000000
 *
 * See for more information on iATU operation. The iATU registers are programmed through an index
 * (Viewport) register to reduce the footprint in the PCI Express Extended Configuration Space. The
 * size of the required port logic space does not depend on the number of regions defined as the
 * Viewport register is used to select which memory region is being accessed. There are 28 bytes of
 * register space implemented per address region per direction. The number of address regions that
 * are remapped by the iATU is 4 for inbound and 4 for outbound. However, only 32 bytes of the PCIe
 * Extended Configuration Space Address Map is used. Offset: 0x700 + 0x200 The viewport register has
 * a "Region Direction" bit to determine whether an inbound or outbound region is being accessed and
 * a "Region Index" field to determine which region to program/read when accessing the other address
 * translation registers in the iATU Register Map below.. As an example, to access the Control,
 * Base, Limit and Target registers for Outbound region number 4: Write 0x00000004 to Address {0x700
 * + 0x200} to index the Outbound Address Region #4 Then proceed to write to any of the other
 * registers in the iATU Register Map below. iATU Register Map Byte Offset Description +0x200 iATU
 * Viewport Register +0x204 iATU Region Control 1 Register +0x208 iATU Region Control 2 Register
 * +0x20C iATU Region Lower Base Address Register +0x210 iATU Region Upper Base Address Register
 * +0x214 iATU Region Limit Address Register +0x218 iATU Region Lower Target Address Register +0x21C
 * iATU Region Upper Target Address Register Since AXI core is async to the core_clk, the iATU
 * registers may not be updated while operations are in progress on the AXI Bridge Slave interface.
 */
typedef union _hw_pcie_pl_iatuvr
{
    reg32_t U;
    struct _hw_pcie_pl_iatuvr_bitfields
    {
        unsigned REGION_INDEX : 4; //!< [3:0] Region Index
        unsigned RESERVED0 : 27; //!< [30:4] Reserved
        unsigned REGION_DIRECTION : 1; //!< [31] Region Direction
    } B;
} hw_pcie_pl_iatuvr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATUVR register
 */
//@{
#define HW_PCIE_PL_IATUVR_ADDR      (REGS_PCIE_PL_BASE + 0x900)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATUVR           (*(volatile hw_pcie_pl_iatuvr_t *) HW_PCIE_PL_IATUVR_ADDR)
#define HW_PCIE_PL_IATUVR_RD()      (HW_PCIE_PL_IATUVR.U)
#define HW_PCIE_PL_IATUVR_WR(v)     (HW_PCIE_PL_IATUVR.U = (v))
#define HW_PCIE_PL_IATUVR_SET(v)    (HW_PCIE_PL_IATUVR_WR(HW_PCIE_PL_IATUVR_RD() |  (v)))
#define HW_PCIE_PL_IATUVR_CLR(v)    (HW_PCIE_PL_IATUVR_WR(HW_PCIE_PL_IATUVR_RD() & ~(v)))
#define HW_PCIE_PL_IATUVR_TOG(v)    (HW_PCIE_PL_IATUVR_WR(HW_PCIE_PL_IATUVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATUVR bitfields
 */

/*! @name Register PCIE_PL_IATUVR, field REGION_INDEX[3:0] (RW)
 *
 * Region Index Defines which region is being accessed when writing to the control, base, limit and
 * target registers. Must not be set to a number greater than CX_ATU_NUM_OUTBOUND_REGIONS - 1 when
 * an outbound region is being accessed. Must not be set to a value greater than 3 since there are 4
 * regions for both inbound or outbound (4 each).
 */
//@{
#define BP_PCIE_PL_IATUVR_REGION_INDEX      (0)      //!< Bit position for PCIE_PL_IATUVR_REGION_INDEX.
#define BM_PCIE_PL_IATUVR_REGION_INDEX      (0x0000000f)  //!< Bit mask for PCIE_PL_IATUVR_REGION_INDEX.

//! @brief Get value of PCIE_PL_IATUVR_REGION_INDEX from a register value.
#define BG_PCIE_PL_IATUVR_REGION_INDEX(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATUVR_REGION_INDEX) >> BP_PCIE_PL_IATUVR_REGION_INDEX)

//! @brief Format value for bitfield PCIE_PL_IATUVR_REGION_INDEX.
#define BF_PCIE_PL_IATUVR_REGION_INDEX(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATUVR_REGION_INDEX) & BM_PCIE_PL_IATUVR_REGION_INDEX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REGION_INDEX field to a new value.
#define BW_PCIE_PL_IATUVR_REGION_INDEX(v)   (HW_PCIE_PL_IATUVR_WR((HW_PCIE_PL_IATUVR_RD() & ~BM_PCIE_PL_IATUVR_REGION_INDEX) | BF_PCIE_PL_IATUVR_REGION_INDEX(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATUVR, field REGION_DIRECTION[31] (RW)
 *
 * Region Direction Defines the region being accessed as either
 *
 * Values:
 * - 0 - Outbound
 * - 1 - Inbound
 */
//@{
#define BP_PCIE_PL_IATUVR_REGION_DIRECTION      (31)      //!< Bit position for PCIE_PL_IATUVR_REGION_DIRECTION.
#define BM_PCIE_PL_IATUVR_REGION_DIRECTION      (0x80000000)  //!< Bit mask for PCIE_PL_IATUVR_REGION_DIRECTION.

//! @brief Get value of PCIE_PL_IATUVR_REGION_DIRECTION from a register value.
#define BG_PCIE_PL_IATUVR_REGION_DIRECTION(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATUVR_REGION_DIRECTION) >> BP_PCIE_PL_IATUVR_REGION_DIRECTION)

//! @brief Format value for bitfield PCIE_PL_IATUVR_REGION_DIRECTION.
#define BF_PCIE_PL_IATUVR_REGION_DIRECTION(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATUVR_REGION_DIRECTION) & BM_PCIE_PL_IATUVR_REGION_DIRECTION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REGION_DIRECTION field to a new value.
#define BW_PCIE_PL_IATUVR_REGION_DIRECTION(v)   (HW_PCIE_PL_IATUVR_WR((HW_PCIE_PL_IATUVR_RD() & ~BM_PCIE_PL_IATUVR_REGION_DIRECTION) | BF_PCIE_PL_IATUVR_REGION_DIRECTION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURC1 - iATU Region Control 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURC1 - iATU Region Control 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x204 footnote 1 - If all other enabled field-matches are successful
 */
typedef union _hw_pcie_pl_iaturc1
{
    reg32_t U;
    struct _hw_pcie_pl_iaturc1_bitfields
    {
        unsigned TYPE : 5; //!< [4:0] TYPE
        unsigned TC : 3; //!< [7:5] TC
        unsigned TD : 1; //!< [8] TD
        unsigned ATTR : 2; //!< [10:9] ATTR
        unsigned RESERVED0 : 5; //!< [15:11] Reserved
        unsigned AT : 2; //!< [17:16] AT
        unsigned RESERVED1 : 2; //!< [19:18] Reserved
        unsigned FUNCTION_NUMBER : 3; //!< [22:20] Function Number
        unsigned RESERVED2 : 9; //!< [31:23] Reserved
    } B;
} hw_pcie_pl_iaturc1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURC1 register
 */
//@{
#define HW_PCIE_PL_IATURC1_ADDR      (REGS_PCIE_PL_BASE + 0x904)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURC1           (*(volatile hw_pcie_pl_iaturc1_t *) HW_PCIE_PL_IATURC1_ADDR)
#define HW_PCIE_PL_IATURC1_RD()      (HW_PCIE_PL_IATURC1.U)
#define HW_PCIE_PL_IATURC1_WR(v)     (HW_PCIE_PL_IATURC1.U = (v))
#define HW_PCIE_PL_IATURC1_SET(v)    (HW_PCIE_PL_IATURC1_WR(HW_PCIE_PL_IATURC1_RD() |  (v)))
#define HW_PCIE_PL_IATURC1_CLR(v)    (HW_PCIE_PL_IATURC1_WR(HW_PCIE_PL_IATURC1_RD() & ~(v)))
#define HW_PCIE_PL_IATURC1_TOG(v)    (HW_PCIE_PL_IATURC1_WR(HW_PCIE_PL_IATURC1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURC1 bitfields
 */

/*! @name Register PCIE_PL_IATURC1, field TYPE[4:0] (RW)
 *
 * TYPE Outbound : When the address of an outbound TLP is matched to this region, then the TYPE
 * field of the TLP is changed to the value in this register. Inbound : When the TYPE field of an
 * inbound TLP is matched to this value, then address translation will proceed 1 .
 */
//@{
#define BP_PCIE_PL_IATURC1_TYPE      (0)      //!< Bit position for PCIE_PL_IATURC1_TYPE.
#define BM_PCIE_PL_IATURC1_TYPE      (0x0000001f)  //!< Bit mask for PCIE_PL_IATURC1_TYPE.

//! @brief Get value of PCIE_PL_IATURC1_TYPE from a register value.
#define BG_PCIE_PL_IATURC1_TYPE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_TYPE) >> BP_PCIE_PL_IATURC1_TYPE)

//! @brief Format value for bitfield PCIE_PL_IATURC1_TYPE.
#define BF_PCIE_PL_IATURC1_TYPE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_TYPE) & BM_PCIE_PL_IATURC1_TYPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TYPE field to a new value.
#define BW_PCIE_PL_IATURC1_TYPE(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_TYPE) | BF_PCIE_PL_IATURC1_TYPE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC1, field TC[7:5] (RW)
 *
 * TC Outbound : When the address of an outbound TLP is matched to this region, then the TC field of
 * the TLP is changed to the value in this register. Inbound : When the TC field of an inbound TLP
 * is matched to this value, then address translation will proceed 1 . This check is only performed
 * if the ìTC Match Enable bit of the ìiATU Control 2 Register is set.
 */
//@{
#define BP_PCIE_PL_IATURC1_TC      (5)      //!< Bit position for PCIE_PL_IATURC1_TC.
#define BM_PCIE_PL_IATURC1_TC      (0x000000e0)  //!< Bit mask for PCIE_PL_IATURC1_TC.

//! @brief Get value of PCIE_PL_IATURC1_TC from a register value.
#define BG_PCIE_PL_IATURC1_TC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_TC) >> BP_PCIE_PL_IATURC1_TC)

//! @brief Format value for bitfield PCIE_PL_IATURC1_TC.
#define BF_PCIE_PL_IATURC1_TC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_TC) & BM_PCIE_PL_IATURC1_TC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TC field to a new value.
#define BW_PCIE_PL_IATURC1_TC(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_TC) | BF_PCIE_PL_IATURC1_TC(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC1, field TD[8] (RW)
 *
 * TD Outbound : When the address of an outbound TLP is matched to this region, then the TD field of
 * the TLP is changed to the value in this register. Inbound : When the TD field of an inbound TLP
 * is matched to this value, then address translation will proceed1. This check is only performed if
 * the ìTD Match Enable bit of the ìiATU Control 2 Register is set.
 */
//@{
#define BP_PCIE_PL_IATURC1_TD      (8)      //!< Bit position for PCIE_PL_IATURC1_TD.
#define BM_PCIE_PL_IATURC1_TD      (0x00000100)  //!< Bit mask for PCIE_PL_IATURC1_TD.

//! @brief Get value of PCIE_PL_IATURC1_TD from a register value.
#define BG_PCIE_PL_IATURC1_TD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_TD) >> BP_PCIE_PL_IATURC1_TD)

//! @brief Format value for bitfield PCIE_PL_IATURC1_TD.
#define BF_PCIE_PL_IATURC1_TD(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_TD) & BM_PCIE_PL_IATURC1_TD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TD field to a new value.
#define BW_PCIE_PL_IATURC1_TD(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_TD) | BF_PCIE_PL_IATURC1_TD(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC1, field ATTR[10:9] (RW)
 *
 * ATTR Outbound : When the address of an outbound TLP is matched to this region, then the ATTR
 * field of the TLP is changed to the value in this register. Inbound : When the ATTR field of an
 * inbound TLP is matched to this value, then address translation will proceed 1 . This check is
 * only performed if the ìATTR Match Enable bit of the ìiATU Control 2 Register is set.
 */
//@{
#define BP_PCIE_PL_IATURC1_ATTR      (9)      //!< Bit position for PCIE_PL_IATURC1_ATTR.
#define BM_PCIE_PL_IATURC1_ATTR      (0x00000600)  //!< Bit mask for PCIE_PL_IATURC1_ATTR.

//! @brief Get value of PCIE_PL_IATURC1_ATTR from a register value.
#define BG_PCIE_PL_IATURC1_ATTR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_ATTR) >> BP_PCIE_PL_IATURC1_ATTR)

//! @brief Format value for bitfield PCIE_PL_IATURC1_ATTR.
#define BF_PCIE_PL_IATURC1_ATTR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_ATTR) & BM_PCIE_PL_IATURC1_ATTR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATTR field to a new value.
#define BW_PCIE_PL_IATURC1_ATTR(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_ATTR) | BF_PCIE_PL_IATURC1_ATTR(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC1, field AT[17:16] (RW)
 *
 * AT NA
 */
//@{
#define BP_PCIE_PL_IATURC1_AT      (16)      //!< Bit position for PCIE_PL_IATURC1_AT.
#define BM_PCIE_PL_IATURC1_AT      (0x00030000)  //!< Bit mask for PCIE_PL_IATURC1_AT.

//! @brief Get value of PCIE_PL_IATURC1_AT from a register value.
#define BG_PCIE_PL_IATURC1_AT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_AT) >> BP_PCIE_PL_IATURC1_AT)

//! @brief Format value for bitfield PCIE_PL_IATURC1_AT.
#define BF_PCIE_PL_IATURC1_AT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_AT) & BM_PCIE_PL_IATURC1_AT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AT field to a new value.
#define BW_PCIE_PL_IATURC1_AT(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_AT) | BF_PCIE_PL_IATURC1_AT(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC1, field FUNCTION_NUMBER[22:20] (RW)
 *
 * Function Number Outbound : When the address of an outbound TLP is matched to this region, then
 * the function number used in generating the 'Function' part of the Requester ID (RID) field of the
 * TLP is taken from this 3-bit register. The value in this register must be 0x0 Inbound MEM/IO :
 * When the Address and BAR matching logic in the core indicate that a MEM/IO transaction matches a
 * BAR in the function corresponding to this value, then address translation will proceed 1 . This
 * check is only performed if the ìFunction Number Match Enable bit of the ìiATU Control 2 Register
 * is set. Inbound CFG0/CFG1 : When the destination function number as specified in the routing ID
 * of the TLP header matches the function, then address translation will proceed1. This check is
 * only performed if the ìFunction Number Match Enable bit of the ìiATU Control 2 Register is set.
 */
//@{
#define BP_PCIE_PL_IATURC1_FUNCTION_NUMBER      (20)      //!< Bit position for PCIE_PL_IATURC1_FUNCTION_NUMBER.
#define BM_PCIE_PL_IATURC1_FUNCTION_NUMBER      (0x00700000)  //!< Bit mask for PCIE_PL_IATURC1_FUNCTION_NUMBER.

//! @brief Get value of PCIE_PL_IATURC1_FUNCTION_NUMBER from a register value.
#define BG_PCIE_PL_IATURC1_FUNCTION_NUMBER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC1_FUNCTION_NUMBER) >> BP_PCIE_PL_IATURC1_FUNCTION_NUMBER)

//! @brief Format value for bitfield PCIE_PL_IATURC1_FUNCTION_NUMBER.
#define BF_PCIE_PL_IATURC1_FUNCTION_NUMBER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC1_FUNCTION_NUMBER) & BM_PCIE_PL_IATURC1_FUNCTION_NUMBER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FUNCTION_NUMBER field to a new value.
#define BW_PCIE_PL_IATURC1_FUNCTION_NUMBER(v)   (HW_PCIE_PL_IATURC1_WR((HW_PCIE_PL_IATURC1_RD() & ~BM_PCIE_PL_IATURC1_FUNCTION_NUMBER) | BF_PCIE_PL_IATURC1_FUNCTION_NUMBER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURC2 - iATU Region Control 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURC2 - iATU Region Control 2 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x208
 */
typedef union _hw_pcie_pl_iaturc2
{
    reg32_t U;
    struct _hw_pcie_pl_iaturc2_bitfields
    {
        unsigned MESSAGE_CODE : 8; //!< [7:0] Message Code
        unsigned BAR_NUMBER : 3; //!< [10:8] BAR Number
        unsigned RESERVED0 : 3; //!< [13:11] Reserved
        unsigned TC_MATCH_ENABLE : 1; //!< [14] TC Match Enable
        unsigned TD_MATCH_ENABLE : 1; //!< [15] TD Match Enable
        unsigned ATTR_MATCH_ENABLE : 1; //!< [16] ATTR Match Enable
        unsigned RESERVED1 : 1; //!< [17] Reserved
        unsigned AT_MATCH_ENABLE : 1; //!< [18] AT Match Enable
        unsigned FUNCTION_NUMBER_MATCH_ENABLE : 1; //!< [19] Function Number Match Enable
        unsigned VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE : 1; //!< [20] Virtual Function Number Match Enable
        unsigned MESSAGE_CODE_MATCH_ENABLE : 1; //!< [21] Message Code Match Enable
        unsigned RESERVED2 : 2; //!< [23:22] Reserved
        unsigned RESPONSE_CODE : 2; //!< [25:24] Response Code
        unsigned RESERVED3 : 1; //!< [26] Reserved
        unsigned FUZZY_TYPE_MATCH_MODE : 1; //!< [27] Fuzzy Type Match Mode
        unsigned CFG_SHIFT_MODE : 1; //!< [28] CFG Shift Mode
        unsigned INVERT_MODE : 1; //!< [29] Invert Mode
        unsigned MATCH_MODE : 1; //!< [30] Match Mode
        unsigned REGION_ENABLE : 1; //!< [31] Region Enable
    } B;
} hw_pcie_pl_iaturc2_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURC2 register
 */
//@{
#define HW_PCIE_PL_IATURC2_ADDR      (REGS_PCIE_PL_BASE + 0x908)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURC2           (*(volatile hw_pcie_pl_iaturc2_t *) HW_PCIE_PL_IATURC2_ADDR)
#define HW_PCIE_PL_IATURC2_RD()      (HW_PCIE_PL_IATURC2.U)
#define HW_PCIE_PL_IATURC2_WR(v)     (HW_PCIE_PL_IATURC2.U = (v))
#define HW_PCIE_PL_IATURC2_SET(v)    (HW_PCIE_PL_IATURC2_WR(HW_PCIE_PL_IATURC2_RD() |  (v)))
#define HW_PCIE_PL_IATURC2_CLR(v)    (HW_PCIE_PL_IATURC2_WR(HW_PCIE_PL_IATURC2_RD() & ~(v)))
#define HW_PCIE_PL_IATURC2_TOG(v)    (HW_PCIE_PL_IATURC2_WR(HW_PCIE_PL_IATURC2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURC2 bitfields
 */

/*! @name Register PCIE_PL_IATURC2, field MESSAGE_CODE[7:0] (RW)
 *
 * Message Code Outbound : When the address of an outbound TLP is matched to this region, and the
 * translated TLP TYPE field is Msg or MsgD; then the Message field of the TLP is changed to the
 * value in this register. Inbound : When the TYPE field of an inbound Msg/MsgD TLP is matched to
 * this value, then address translation will proceed 1 . This check is only performed if the
 * ìFunction Message Code Match Enable bit of the is set.
 */
//@{
#define BP_PCIE_PL_IATURC2_MESSAGE_CODE      (0)      //!< Bit position for PCIE_PL_IATURC2_MESSAGE_CODE.
#define BM_PCIE_PL_IATURC2_MESSAGE_CODE      (0x000000ff)  //!< Bit mask for PCIE_PL_IATURC2_MESSAGE_CODE.

//! @brief Get value of PCIE_PL_IATURC2_MESSAGE_CODE from a register value.
#define BG_PCIE_PL_IATURC2_MESSAGE_CODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_MESSAGE_CODE) >> BP_PCIE_PL_IATURC2_MESSAGE_CODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_MESSAGE_CODE.
#define BF_PCIE_PL_IATURC2_MESSAGE_CODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_MESSAGE_CODE) & BM_PCIE_PL_IATURC2_MESSAGE_CODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MESSAGE_CODE field to a new value.
#define BW_PCIE_PL_IATURC2_MESSAGE_CODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_MESSAGE_CODE) | BF_PCIE_PL_IATURC2_MESSAGE_CODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field BAR_NUMBER[10:8] (RW)
 *
 * BAR Number Outbound : Not used. Inbound : When the BAR number of an inbound MEM or IO TLP - that
 * is matched by the normal internal BAR address matching mechanism - is the same as this field,
 * address translation will proceed 1 .This check is only performed if the ìMatch Mode bit of the is
 * set. IO translation would require either 00100b or 00101b in the inbound TLP TYPE; the BAR Number
 * set in the range 000b - 101b and that BAR configured as an IO BAR.
 *
 * Values:
 * - 000b - - BAR#0
 * - 001b - - BAR#1
 * - 010b - - BAR#2
 * - 011b - - BAR#3
 * - 100b - - BAR#4
 * - 101b - - BAR#5
 * - 110b - - ROM
 * - 111b - - reserved
 */
//@{
#define BP_PCIE_PL_IATURC2_BAR_NUMBER      (8)      //!< Bit position for PCIE_PL_IATURC2_BAR_NUMBER.
#define BM_PCIE_PL_IATURC2_BAR_NUMBER      (0x00000700)  //!< Bit mask for PCIE_PL_IATURC2_BAR_NUMBER.

//! @brief Get value of PCIE_PL_IATURC2_BAR_NUMBER from a register value.
#define BG_PCIE_PL_IATURC2_BAR_NUMBER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_BAR_NUMBER) >> BP_PCIE_PL_IATURC2_BAR_NUMBER)

//! @brief Format value for bitfield PCIE_PL_IATURC2_BAR_NUMBER.
#define BF_PCIE_PL_IATURC2_BAR_NUMBER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_BAR_NUMBER) & BM_PCIE_PL_IATURC2_BAR_NUMBER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BAR_NUMBER field to a new value.
#define BW_PCIE_PL_IATURC2_BAR_NUMBER(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_BAR_NUMBER) | BF_PCIE_PL_IATURC2_BAR_NUMBER(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field TC_MATCH_ENABLE[14] (RW)
 *
 * TC Match Enable Outbound : Not used. Inbound : Ensures that a successful TC TLP field comparison
 * match (see TC field of the ) occurs for address translation to proceed.
 */
//@{
#define BP_PCIE_PL_IATURC2_TC_MATCH_ENABLE      (14)      //!< Bit position for PCIE_PL_IATURC2_TC_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_TC_MATCH_ENABLE      (0x00004000)  //!< Bit mask for PCIE_PL_IATURC2_TC_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_TC_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_TC_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_TC_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_TC_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_TC_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_TC_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_TC_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_TC_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TC_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_TC_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_TC_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_TC_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field TD_MATCH_ENABLE[15] (RW)
 *
 * TD Match Enable Outbound : Not used. Inbound : Ensures that a successful TD TLP field comparison
 * match (see TD field of the ) occurs for address translation to proceed.
 */
//@{
#define BP_PCIE_PL_IATURC2_TD_MATCH_ENABLE      (15)      //!< Bit position for PCIE_PL_IATURC2_TD_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_TD_MATCH_ENABLE      (0x00008000)  //!< Bit mask for PCIE_PL_IATURC2_TD_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_TD_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_TD_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_TD_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_TD_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_TD_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_TD_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_TD_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_TD_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TD_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_TD_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_TD_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_TD_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field ATTR_MATCH_ENABLE[16] (RW)
 *
 * ATTR Match Enable Outbound : Not used. Inbound : Ensures that a successful ATTR TLP field
 * comparison match (see ATTR field of the ) occurs for address translation to proceed.
 */
//@{
#define BP_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE      (16)      //!< Bit position for PCIE_PL_IATURC2_ATTR_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE      (0x00010000)  //!< Bit mask for PCIE_PL_IATURC2_ATTR_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_ATTR_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_ATTR_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATTR_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_ATTR_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field AT_MATCH_ENABLE[18] (RW)
 *
 * AT Match Enable Outbound : Not used. Inbound : Ensures that a successful AT TLP field comparison
 * match (see AT field of the iATU Control 1 Register in ) occurs for address translation to
 * proceed. Only valid when the ATS_RX_ENABLE configuration parameter is 1.
 */
//@{
#define BP_PCIE_PL_IATURC2_AT_MATCH_ENABLE      (18)      //!< Bit position for PCIE_PL_IATURC2_AT_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_AT_MATCH_ENABLE      (0x00040000)  //!< Bit mask for PCIE_PL_IATURC2_AT_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_AT_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_AT_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_AT_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_AT_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_AT_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_AT_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_AT_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_AT_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AT_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_AT_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_AT_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_AT_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field FUNCTION_NUMBER_MATCH_ENABLE[19] (RW)
 *
 * Function Number Match Enable Outbound : Not used. Inbound : Ensures that a successful Function
 * Number TLP field comparison match (see Function Number field of the iATU Control 1 Register in )
 * occurs (in MEM/IO and CFG0/CFG1 transactions) for address translation to proceed. Note : This bit
 * must not be set at the same time as 'Virtual Function Number Match Enable'.
 */
//@{
#define BP_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE      (19)      //!< Bit position for PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE      (0x00080000)  //!< Bit mask for PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FUNCTION_NUMBER_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_FUNCTION_NUMBER_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE[20] (RW)
 *
 * Virtual Function Number Match Enable Outbound : Not used. Inbound : Ensures that a successful
 * Virtual Function Number TLP field comparison match (see Virtual Function Number field of the iATU
 * Control 1 Register in occurs (in MEM/IO transactions) for address translation to proceed. Note :
 * This bit must not be set at the same time as 'Function Number Match Enable'.
 */
//@{
#define BP_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE      (20)      //!< Bit position for PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE      (0x00100000)  //!< Bit mask for PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_VIRTUAL_FUNCTION_NUMBER_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field MESSAGE_CODE_MATCH_ENABLE[21] (RW)
 *
 * Message Code Match Enable Outbound : Not used. Inbound : Ensures that a successful Message Code
 * TLP field comparison match occurs in MSG transactions (see Message Code field of the iATU Control
 * 1 Register in ) for address translation to proceed.
 */
//@{
#define BP_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE      (21)      //!< Bit position for PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE.
#define BM_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE      (0x00200000)  //!< Bit mask for PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE) >> BP_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE.
#define BF_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE) & BM_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MESSAGE_CODE_MATCH_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE) | BF_PCIE_PL_IATURC2_MESSAGE_CODE_MATCH_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field RESPONSE_CODE[25:24] (RW)
 *
 * Response Code Outbound : Not used. Inbound : Defines the type of response to give for accesses
 * matching this region. This overrides the normal RADM filter response.
 *
 * Values:
 * - 00 - - Normal RADM filter response is used.
 * - 01 - - Unsupported Request (UR)
 * - 10 - - Completer Abort (CA)
 * - 11 - - Not used / undefined / reserved.
 */
//@{
#define BP_PCIE_PL_IATURC2_RESPONSE_CODE      (24)      //!< Bit position for PCIE_PL_IATURC2_RESPONSE_CODE.
#define BM_PCIE_PL_IATURC2_RESPONSE_CODE      (0x03000000)  //!< Bit mask for PCIE_PL_IATURC2_RESPONSE_CODE.

//! @brief Get value of PCIE_PL_IATURC2_RESPONSE_CODE from a register value.
#define BG_PCIE_PL_IATURC2_RESPONSE_CODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_RESPONSE_CODE) >> BP_PCIE_PL_IATURC2_RESPONSE_CODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_RESPONSE_CODE.
#define BF_PCIE_PL_IATURC2_RESPONSE_CODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_RESPONSE_CODE) & BM_PCIE_PL_IATURC2_RESPONSE_CODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESPONSE_CODE field to a new value.
#define BW_PCIE_PL_IATURC2_RESPONSE_CODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_RESPONSE_CODE) | BF_PCIE_PL_IATURC2_RESPONSE_CODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field FUZZY_TYPE_MATCH_MODE[27] (RW)
 *
 * Fuzzy Type Match Mode Outbound : Not used. Inbound : When enabled, the iATU relaxes the matching
 * of the TLP TYPE field against the expected TYPE field so that CfgRd0 and CfgRd1 TLPs are seen as
 * identical. Similarly with CfgWr0 and CfgWr1. MRd and MRdLk TLPs are seen as identical The Routing
 * field of Msg/MsgD TLPs is ignored For example, CFG0 in the TYPE field in the will match against
 * an inbound CfgRd0, CfgRd1, CfgWr0 or CfgWr1 TLP.
 */
//@{
#define BP_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE      (27)      //!< Bit position for PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE.
#define BM_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE      (0x08000000)  //!< Bit mask for PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE.

//! @brief Get value of PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE from a register value.
#define BG_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE) >> BP_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE.
#define BF_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE) & BM_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FUZZY_TYPE_MATCH_MODE field to a new value.
#define BW_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE) | BF_PCIE_PL_IATURC2_FUZZY_TYPE_MATCH_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field CFG_SHIFT_MODE[28] (RW)
 *
 * CFG Shift Mode This is useful for CFG transactions where the PCIe configuration mechanism maps
 * bits [27:12] of the address to the bus/device and function number. This allows a CFG
 * configuration space to be located in any 256MB window of the application memory space using a
 * 28-bit effective address. Outbound : Shifts bits [27:12] of the untranslated address to form bits
 * [31:16] of the translated address. Inbound : Shifts bits [31:16] of the untranslated address to
 * form bits [27:12] of the translated address.
 */
//@{
#define BP_PCIE_PL_IATURC2_CFG_SHIFT_MODE      (28)      //!< Bit position for PCIE_PL_IATURC2_CFG_SHIFT_MODE.
#define BM_PCIE_PL_IATURC2_CFG_SHIFT_MODE      (0x10000000)  //!< Bit mask for PCIE_PL_IATURC2_CFG_SHIFT_MODE.

//! @brief Get value of PCIE_PL_IATURC2_CFG_SHIFT_MODE from a register value.
#define BG_PCIE_PL_IATURC2_CFG_SHIFT_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_CFG_SHIFT_MODE) >> BP_PCIE_PL_IATURC2_CFG_SHIFT_MODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_CFG_SHIFT_MODE.
#define BF_PCIE_PL_IATURC2_CFG_SHIFT_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_CFG_SHIFT_MODE) & BM_PCIE_PL_IATURC2_CFG_SHIFT_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CFG_SHIFT_MODE field to a new value.
#define BW_PCIE_PL_IATURC2_CFG_SHIFT_MODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_CFG_SHIFT_MODE) | BF_PCIE_PL_IATURC2_CFG_SHIFT_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field INVERT_MODE[29] (RW)
 *
 * Invert Mode Outbound / Inbound : When set the address matching region is inverted. Therefore, an
 * address match occurs when the untranslated address is in the region outside the defined range
 * (Base Address to Limit Address).
 */
//@{
#define BP_PCIE_PL_IATURC2_INVERT_MODE      (29)      //!< Bit position for PCIE_PL_IATURC2_INVERT_MODE.
#define BM_PCIE_PL_IATURC2_INVERT_MODE      (0x20000000)  //!< Bit mask for PCIE_PL_IATURC2_INVERT_MODE.

//! @brief Get value of PCIE_PL_IATURC2_INVERT_MODE from a register value.
#define BG_PCIE_PL_IATURC2_INVERT_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_INVERT_MODE) >> BP_PCIE_PL_IATURC2_INVERT_MODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_INVERT_MODE.
#define BF_PCIE_PL_IATURC2_INVERT_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_INVERT_MODE) & BM_PCIE_PL_IATURC2_INVERT_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INVERT_MODE field to a new value.
#define BW_PCIE_PL_IATURC2_INVERT_MODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_INVERT_MODE) | BF_PCIE_PL_IATURC2_INVERT_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field MATCH_MODE[30] (RW)
 *
 * Match Mode Outbound : Not used. Inbound MEM/IO : Determines Inbound matching mode for MEM/IO
 * TLPs. 0 : Address Mode. The iATU operates using addresses as in the Outbound direction. The
 * Region Base and Limit Registers must be setup. 1 : BAR Mode. BAR matching is used. The 'BAR
 * Number' field is relevant. Inbound CFG0 : Determines Inbound matching mode for CFG0 TLPs. 0 :
 * Routing ID match mode. The iATU interprets the Routing ID (Bytes 8 to 11 of TLP header) as an
 * address. This corresponds to the upper 16 bits of the address in MEM/IO transactions. The Routing
 * ID of the TLP must be within the base and limit of the iATU region for matching to proceed. 1 :
 * Accept Mode. The iATU accepts all CFG0 transactions as address matches. The routing ID in the
 * CFG0 TLP is ignored. This is useful as all received CFG0 TLPs should be processed regardless of
 * the Bus number. Inbound MSG/MSGD : Determines Inbound matching mode for MSG/MSGD TLPs. 0 :
 * Address Mode. The iATU treats the 3rd DWORD and 4th DWORD of the inbound MSG/MSGD TLP as an
 * address and it is matched against the Region Base and Limit Registers. 1 : Vendor ID match mode.
 * This mode is relevant for ID-routed Vendor Defined Messages. The iATU ignores the Routing ID(Bus,
 * Device, Function) in bits [31:16] of the 3rd DWORD of the TLP header, but matches against the
 * Vendor ID in bits [15:0] of the 3rd DWORD of the TLP header. Bits [15:0] of the Region Upper Base
 * register should be programmed with the required Vendor ID. The lower Base and Limit Register
 * should be programmed to translate TLPs based on vendor specific information in the 4th DWORD of
 * the TLP header.
 */
//@{
#define BP_PCIE_PL_IATURC2_MATCH_MODE      (30)      //!< Bit position for PCIE_PL_IATURC2_MATCH_MODE.
#define BM_PCIE_PL_IATURC2_MATCH_MODE      (0x40000000)  //!< Bit mask for PCIE_PL_IATURC2_MATCH_MODE.

//! @brief Get value of PCIE_PL_IATURC2_MATCH_MODE from a register value.
#define BG_PCIE_PL_IATURC2_MATCH_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_MATCH_MODE) >> BP_PCIE_PL_IATURC2_MATCH_MODE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_MATCH_MODE.
#define BF_PCIE_PL_IATURC2_MATCH_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_MATCH_MODE) & BM_PCIE_PL_IATURC2_MATCH_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MATCH_MODE field to a new value.
#define BW_PCIE_PL_IATURC2_MATCH_MODE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_MATCH_MODE) | BF_PCIE_PL_IATURC2_MATCH_MODE(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURC2, field REGION_ENABLE[31] (RW)
 *
 * Region Enable Outbound / Inbound : This bit must be set to '1' for address translation to take
 * place.
 */
//@{
#define BP_PCIE_PL_IATURC2_REGION_ENABLE      (31)      //!< Bit position for PCIE_PL_IATURC2_REGION_ENABLE.
#define BM_PCIE_PL_IATURC2_REGION_ENABLE      (0x80000000)  //!< Bit mask for PCIE_PL_IATURC2_REGION_ENABLE.

//! @brief Get value of PCIE_PL_IATURC2_REGION_ENABLE from a register value.
#define BG_PCIE_PL_IATURC2_REGION_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURC2_REGION_ENABLE) >> BP_PCIE_PL_IATURC2_REGION_ENABLE)

//! @brief Format value for bitfield PCIE_PL_IATURC2_REGION_ENABLE.
#define BF_PCIE_PL_IATURC2_REGION_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURC2_REGION_ENABLE) & BM_PCIE_PL_IATURC2_REGION_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REGION_ENABLE field to a new value.
#define BW_PCIE_PL_IATURC2_REGION_ENABLE(v)   (HW_PCIE_PL_IATURC2_WR((HW_PCIE_PL_IATURC2_RD() & ~BM_PCIE_PL_IATURC2_REGION_ENABLE) | BF_PCIE_PL_IATURC2_REGION_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURLBA - iATU Region Lower Base Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURLBA - iATU Region Lower Base Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The CX_ATU_MIN_REGION_SIZE configuration parameter (Value Range: 4 kB, 8 kB, 16 kB, 32 kB, 64 kB
 * defaults to 64 kB) specifies the minimum size of an address translation region. For example, if
 * set to 64 kB; the lower 16 bits of the Base, Limit and Target registers are zero and all address
 * regions are aligned on 64 kB boundaries. More precisely, the lower log2(CX_ATU_MIN_REGION_SIZE)
 * bits are zero. Offset: 0x700 + 0x20C
 */
typedef union _hw_pcie_pl_iaturlba
{
    reg32_t U;
    struct _hw_pcie_pl_iaturlba_bitfields
    {
        unsigned ADDRESS_LOWER : 16; //!< [15:0] Forms bits [15:0] of the start address of the address region to be translated.
        unsigned ADDRESS_UPPER : 16; //!< [31:16] Forms bits [31:16] of the start address of the address region to be translated.
    } B;
} hw_pcie_pl_iaturlba_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURLBA register
 */
//@{
#define HW_PCIE_PL_IATURLBA_ADDR      (REGS_PCIE_PL_BASE + 0x90c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURLBA           (*(volatile hw_pcie_pl_iaturlba_t *) HW_PCIE_PL_IATURLBA_ADDR)
#define HW_PCIE_PL_IATURLBA_RD()      (HW_PCIE_PL_IATURLBA.U)
#define HW_PCIE_PL_IATURLBA_WR(v)     (HW_PCIE_PL_IATURLBA.U = (v))
#define HW_PCIE_PL_IATURLBA_SET(v)    (HW_PCIE_PL_IATURLBA_WR(HW_PCIE_PL_IATURLBA_RD() |  (v)))
#define HW_PCIE_PL_IATURLBA_CLR(v)    (HW_PCIE_PL_IATURLBA_WR(HW_PCIE_PL_IATURLBA_RD() & ~(v)))
#define HW_PCIE_PL_IATURLBA_TOG(v)    (HW_PCIE_PL_IATURLBA_WR(HW_PCIE_PL_IATURLBA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURLBA bitfields
 */

/*! @name Register PCIE_PL_IATURLBA, field ADDRESS_LOWER[15:0] (RW)
 *
 * Forms bits [15:0] of the start address of the address region to be translated. The start address
 * must be aligned to a CX_ATU_MIN_REGION_SIZE kB boundary, so these bits are always 0. A write to
 * this location is ignored by the PCIe core.
 */
//@{
#define BP_PCIE_PL_IATURLBA_ADDRESS_LOWER      (0)      //!< Bit position for PCIE_PL_IATURLBA_ADDRESS_LOWER.
#define BM_PCIE_PL_IATURLBA_ADDRESS_LOWER      (0x0000ffff)  //!< Bit mask for PCIE_PL_IATURLBA_ADDRESS_LOWER.

//! @brief Get value of PCIE_PL_IATURLBA_ADDRESS_LOWER from a register value.
#define BG_PCIE_PL_IATURLBA_ADDRESS_LOWER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLBA_ADDRESS_LOWER) >> BP_PCIE_PL_IATURLBA_ADDRESS_LOWER)

//! @brief Format value for bitfield PCIE_PL_IATURLBA_ADDRESS_LOWER.
#define BF_PCIE_PL_IATURLBA_ADDRESS_LOWER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLBA_ADDRESS_LOWER) & BM_PCIE_PL_IATURLBA_ADDRESS_LOWER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_LOWER field to a new value.
#define BW_PCIE_PL_IATURLBA_ADDRESS_LOWER(v)   (HW_PCIE_PL_IATURLBA_WR((HW_PCIE_PL_IATURLBA_RD() & ~BM_PCIE_PL_IATURLBA_ADDRESS_LOWER) | BF_PCIE_PL_IATURLBA_ADDRESS_LOWER(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURLBA, field ADDRESS_UPPER[31:16] (RW)
 *
 * Forms bits [31:16] of the start address of the address region to be translated.
 */
//@{
#define BP_PCIE_PL_IATURLBA_ADDRESS_UPPER      (16)      //!< Bit position for PCIE_PL_IATURLBA_ADDRESS_UPPER.
#define BM_PCIE_PL_IATURLBA_ADDRESS_UPPER      (0xffff0000)  //!< Bit mask for PCIE_PL_IATURLBA_ADDRESS_UPPER.

//! @brief Get value of PCIE_PL_IATURLBA_ADDRESS_UPPER from a register value.
#define BG_PCIE_PL_IATURLBA_ADDRESS_UPPER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLBA_ADDRESS_UPPER) >> BP_PCIE_PL_IATURLBA_ADDRESS_UPPER)

//! @brief Format value for bitfield PCIE_PL_IATURLBA_ADDRESS_UPPER.
#define BF_PCIE_PL_IATURLBA_ADDRESS_UPPER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLBA_ADDRESS_UPPER) & BM_PCIE_PL_IATURLBA_ADDRESS_UPPER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_UPPER field to a new value.
#define BW_PCIE_PL_IATURLBA_ADDRESS_UPPER(v)   (HW_PCIE_PL_IATURLBA_WR((HW_PCIE_PL_IATURLBA_RD() & ~BM_PCIE_PL_IATURLBA_ADDRESS_UPPER) | BF_PCIE_PL_IATURLBA_ADDRESS_UPPER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURUBA - iATU Region Upper Base Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURUBA - iATU Region Upper Base Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x210
 */
typedef union _hw_pcie_pl_iaturuba
{
    reg32_t U;
    struct _hw_pcie_pl_iaturuba_bitfields
    {
        unsigned ADDRESS : 32; //!< [31:0] Outbound / Inbound : Forms bits [63:32] of the start (and end) address of the address region to be translated.
    } B;
} hw_pcie_pl_iaturuba_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURUBA register
 */
//@{
#define HW_PCIE_PL_IATURUBA_ADDR      (REGS_PCIE_PL_BASE + 0x910)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURUBA           (*(volatile hw_pcie_pl_iaturuba_t *) HW_PCIE_PL_IATURUBA_ADDR)
#define HW_PCIE_PL_IATURUBA_RD()      (HW_PCIE_PL_IATURUBA.U)
#define HW_PCIE_PL_IATURUBA_WR(v)     (HW_PCIE_PL_IATURUBA.U = (v))
#define HW_PCIE_PL_IATURUBA_SET(v)    (HW_PCIE_PL_IATURUBA_WR(HW_PCIE_PL_IATURUBA_RD() |  (v)))
#define HW_PCIE_PL_IATURUBA_CLR(v)    (HW_PCIE_PL_IATURUBA_WR(HW_PCIE_PL_IATURUBA_RD() & ~(v)))
#define HW_PCIE_PL_IATURUBA_TOG(v)    (HW_PCIE_PL_IATURUBA_WR(HW_PCIE_PL_IATURUBA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURUBA bitfields
 */

/*! @name Register PCIE_PL_IATURUBA, field ADDRESS[31:0] (RW)
 *
 * Outbound / Inbound : Forms bits [63:32] of the start (and end) address of the address region to
 * be translated. Outbound : In systems with a 32-bit address space, this register is not used and
 * therefore writing to this register has no effect.
 */
//@{
#define BP_PCIE_PL_IATURUBA_ADDRESS      (0)      //!< Bit position for PCIE_PL_IATURUBA_ADDRESS.
#define BM_PCIE_PL_IATURUBA_ADDRESS      (0xffffffff)  //!< Bit mask for PCIE_PL_IATURUBA_ADDRESS.

//! @brief Get value of PCIE_PL_IATURUBA_ADDRESS from a register value.
#define BG_PCIE_PL_IATURUBA_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURUBA_ADDRESS) >> BP_PCIE_PL_IATURUBA_ADDRESS)

//! @brief Format value for bitfield PCIE_PL_IATURUBA_ADDRESS.
#define BF_PCIE_PL_IATURUBA_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURUBA_ADDRESS) & BM_PCIE_PL_IATURUBA_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS field to a new value.
#define BW_PCIE_PL_IATURUBA_ADDRESS(v)   (HW_PCIE_PL_IATURUBA_WR((HW_PCIE_PL_IATURUBA_RD() & ~BM_PCIE_PL_IATURUBA_ADDRESS) | BF_PCIE_PL_IATURUBA_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURLA - iATU Region Limit Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURLA - iATU Region Limit Address Register (RW)
 *
 * Reset value: 0x0000ffff
 *
 * Offset: 0x700 + 0x214
 */
typedef union _hw_pcie_pl_iaturla
{
    reg32_t U;
    struct _hw_pcie_pl_iaturla_bitfields
    {
        unsigned ADDRESS_LOWER : 16; //!< [15:0] Forms bits [15:0] of the end address of the address region to be translated.
        unsigned ADDRESS_UPPER : 16; //!< [31:16] Forms bits [31:16] of the end address of the address region to be translated.
    } B;
} hw_pcie_pl_iaturla_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURLA register
 */
//@{
#define HW_PCIE_PL_IATURLA_ADDR      (REGS_PCIE_PL_BASE + 0x914)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURLA           (*(volatile hw_pcie_pl_iaturla_t *) HW_PCIE_PL_IATURLA_ADDR)
#define HW_PCIE_PL_IATURLA_RD()      (HW_PCIE_PL_IATURLA.U)
#define HW_PCIE_PL_IATURLA_WR(v)     (HW_PCIE_PL_IATURLA.U = (v))
#define HW_PCIE_PL_IATURLA_SET(v)    (HW_PCIE_PL_IATURLA_WR(HW_PCIE_PL_IATURLA_RD() |  (v)))
#define HW_PCIE_PL_IATURLA_CLR(v)    (HW_PCIE_PL_IATURLA_WR(HW_PCIE_PL_IATURLA_RD() & ~(v)))
#define HW_PCIE_PL_IATURLA_TOG(v)    (HW_PCIE_PL_IATURLA_WR(HW_PCIE_PL_IATURLA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURLA bitfields
 */

/*! @name Register PCIE_PL_IATURLA, field ADDRESS_LOWER[15:0] (RW)
 *
 * Forms bits [15:0] of the end address of the address region to be translated. The end address must
 * be aligned to a CX_ATU_MIN_REGION_SIZE kB boundary, so these bits are always 0. A write to this
 * location is ignored by the PCIe core.
 */
//@{
#define BP_PCIE_PL_IATURLA_ADDRESS_LOWER      (0)      //!< Bit position for PCIE_PL_IATURLA_ADDRESS_LOWER.
#define BM_PCIE_PL_IATURLA_ADDRESS_LOWER      (0x0000ffff)  //!< Bit mask for PCIE_PL_IATURLA_ADDRESS_LOWER.

//! @brief Get value of PCIE_PL_IATURLA_ADDRESS_LOWER from a register value.
#define BG_PCIE_PL_IATURLA_ADDRESS_LOWER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLA_ADDRESS_LOWER) >> BP_PCIE_PL_IATURLA_ADDRESS_LOWER)

//! @brief Format value for bitfield PCIE_PL_IATURLA_ADDRESS_LOWER.
#define BF_PCIE_PL_IATURLA_ADDRESS_LOWER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLA_ADDRESS_LOWER) & BM_PCIE_PL_IATURLA_ADDRESS_LOWER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_LOWER field to a new value.
#define BW_PCIE_PL_IATURLA_ADDRESS_LOWER(v)   (HW_PCIE_PL_IATURLA_WR((HW_PCIE_PL_IATURLA_RD() & ~BM_PCIE_PL_IATURLA_ADDRESS_LOWER) | BF_PCIE_PL_IATURLA_ADDRESS_LOWER(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURLA, field ADDRESS_UPPER[31:16] (RW)
 *
 * Forms bits [31:16] of the end address of the address region to be translated.
 */
//@{
#define BP_PCIE_PL_IATURLA_ADDRESS_UPPER      (16)      //!< Bit position for PCIE_PL_IATURLA_ADDRESS_UPPER.
#define BM_PCIE_PL_IATURLA_ADDRESS_UPPER      (0xffff0000)  //!< Bit mask for PCIE_PL_IATURLA_ADDRESS_UPPER.

//! @brief Get value of PCIE_PL_IATURLA_ADDRESS_UPPER from a register value.
#define BG_PCIE_PL_IATURLA_ADDRESS_UPPER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLA_ADDRESS_UPPER) >> BP_PCIE_PL_IATURLA_ADDRESS_UPPER)

//! @brief Format value for bitfield PCIE_PL_IATURLA_ADDRESS_UPPER.
#define BF_PCIE_PL_IATURLA_ADDRESS_UPPER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLA_ADDRESS_UPPER) & BM_PCIE_PL_IATURLA_ADDRESS_UPPER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_UPPER field to a new value.
#define BW_PCIE_PL_IATURLA_ADDRESS_UPPER(v)   (HW_PCIE_PL_IATURLA_WR((HW_PCIE_PL_IATURLA_RD() & ~BM_PCIE_PL_IATURLA_ADDRESS_UPPER) | BF_PCIE_PL_IATURLA_ADDRESS_UPPER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURLTA - iATU Region Lower Target Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURLTA - iATU Region Lower Target Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x218
 */
typedef union _hw_pcie_pl_iaturlta
{
    reg32_t U;
    struct _hw_pcie_pl_iaturlta_bitfields
    {
        unsigned ADDRESS_LOWER : 16; //!< [15:0] Forms bits [15:0] of the start address of the new address of the translated region.
        unsigned ADDRESS_UPPER : 16; //!< [31:16] Forms bits [31:16] of the of the new address of the translated region.
    } B;
} hw_pcie_pl_iaturlta_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURLTA register
 */
//@{
#define HW_PCIE_PL_IATURLTA_ADDR      (REGS_PCIE_PL_BASE + 0x918)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURLTA           (*(volatile hw_pcie_pl_iaturlta_t *) HW_PCIE_PL_IATURLTA_ADDR)
#define HW_PCIE_PL_IATURLTA_RD()      (HW_PCIE_PL_IATURLTA.U)
#define HW_PCIE_PL_IATURLTA_WR(v)     (HW_PCIE_PL_IATURLTA.U = (v))
#define HW_PCIE_PL_IATURLTA_SET(v)    (HW_PCIE_PL_IATURLTA_WR(HW_PCIE_PL_IATURLTA_RD() |  (v)))
#define HW_PCIE_PL_IATURLTA_CLR(v)    (HW_PCIE_PL_IATURLTA_WR(HW_PCIE_PL_IATURLTA_RD() & ~(v)))
#define HW_PCIE_PL_IATURLTA_TOG(v)    (HW_PCIE_PL_IATURLTA_WR(HW_PCIE_PL_IATURLTA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURLTA bitfields
 */

/*! @name Register PCIE_PL_IATURLTA, field ADDRESS_LOWER[15:0] (RW)
 *
 * Forms bits [15:0] of the start address of the new address of the translated region. The start
 * address must be aligned to a CX_ATU_MIN_REGION_SIZE kB boundary, so these bits are always 0. A
 * write to this location is ignored by the PCIe core.
 */
//@{
#define BP_PCIE_PL_IATURLTA_ADDRESS_LOWER      (0)      //!< Bit position for PCIE_PL_IATURLTA_ADDRESS_LOWER.
#define BM_PCIE_PL_IATURLTA_ADDRESS_LOWER      (0x0000ffff)  //!< Bit mask for PCIE_PL_IATURLTA_ADDRESS_LOWER.

//! @brief Get value of PCIE_PL_IATURLTA_ADDRESS_LOWER from a register value.
#define BG_PCIE_PL_IATURLTA_ADDRESS_LOWER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLTA_ADDRESS_LOWER) >> BP_PCIE_PL_IATURLTA_ADDRESS_LOWER)

//! @brief Format value for bitfield PCIE_PL_IATURLTA_ADDRESS_LOWER.
#define BF_PCIE_PL_IATURLTA_ADDRESS_LOWER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLTA_ADDRESS_LOWER) & BM_PCIE_PL_IATURLTA_ADDRESS_LOWER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_LOWER field to a new value.
#define BW_PCIE_PL_IATURLTA_ADDRESS_LOWER(v)   (HW_PCIE_PL_IATURLTA_WR((HW_PCIE_PL_IATURLTA_RD() & ~BM_PCIE_PL_IATURLTA_ADDRESS_LOWER) | BF_PCIE_PL_IATURLTA_ADDRESS_LOWER(v)))
#endif
//@}

/*! @name Register PCIE_PL_IATURLTA, field ADDRESS_UPPER[31:16] (RW)
 *
 * Forms bits [31:16] of the of the new address of the translated region.
 */
//@{
#define BP_PCIE_PL_IATURLTA_ADDRESS_UPPER      (16)      //!< Bit position for PCIE_PL_IATURLTA_ADDRESS_UPPER.
#define BM_PCIE_PL_IATURLTA_ADDRESS_UPPER      (0xffff0000)  //!< Bit mask for PCIE_PL_IATURLTA_ADDRESS_UPPER.

//! @brief Get value of PCIE_PL_IATURLTA_ADDRESS_UPPER from a register value.
#define BG_PCIE_PL_IATURLTA_ADDRESS_UPPER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURLTA_ADDRESS_UPPER) >> BP_PCIE_PL_IATURLTA_ADDRESS_UPPER)

//! @brief Format value for bitfield PCIE_PL_IATURLTA_ADDRESS_UPPER.
#define BF_PCIE_PL_IATURLTA_ADDRESS_UPPER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURLTA_ADDRESS_UPPER) & BM_PCIE_PL_IATURLTA_ADDRESS_UPPER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS_UPPER field to a new value.
#define BW_PCIE_PL_IATURLTA_ADDRESS_UPPER(v)   (HW_PCIE_PL_IATURLTA_WR((HW_PCIE_PL_IATURLTA_RD() & ~BM_PCIE_PL_IATURLTA_ADDRESS_UPPER) | BF_PCIE_PL_IATURLTA_ADDRESS_UPPER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_PL_IATURUTA - iATU Region Upper Target Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_PL_IATURUTA - iATU Region Upper Target Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x700 + 0x21C
 */
typedef union _hw_pcie_pl_iaturuta
{
    reg32_t U;
    struct _hw_pcie_pl_iaturuta_bitfields
    {
        unsigned ADDRESS : 32; //!< [31:0] Outbound / Inbound : Forms bits [63:32] of the start address of the new address of the translated region.
    } B;
} hw_pcie_pl_iaturuta_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_PL_IATURUTA register
 */
//@{
#define HW_PCIE_PL_IATURUTA_ADDR      (REGS_PCIE_PL_BASE + 0x91c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_PL_IATURUTA           (*(volatile hw_pcie_pl_iaturuta_t *) HW_PCIE_PL_IATURUTA_ADDR)
#define HW_PCIE_PL_IATURUTA_RD()      (HW_PCIE_PL_IATURUTA.U)
#define HW_PCIE_PL_IATURUTA_WR(v)     (HW_PCIE_PL_IATURUTA.U = (v))
#define HW_PCIE_PL_IATURUTA_SET(v)    (HW_PCIE_PL_IATURUTA_WR(HW_PCIE_PL_IATURUTA_RD() |  (v)))
#define HW_PCIE_PL_IATURUTA_CLR(v)    (HW_PCIE_PL_IATURUTA_WR(HW_PCIE_PL_IATURUTA_RD() & ~(v)))
#define HW_PCIE_PL_IATURUTA_TOG(v)    (HW_PCIE_PL_IATURUTA_WR(HW_PCIE_PL_IATURUTA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_PL_IATURUTA bitfields
 */

/*! @name Register PCIE_PL_IATURUTA, field ADDRESS[31:0] (RW)
 *
 * Outbound / Inbound : Forms bits [63:32] of the start address of the new address of the translated
 * region. Inbound : In systems with a 32-bit address space, this register is not used and therefore
 * writing to this register has no effect.
 */
//@{
#define BP_PCIE_PL_IATURUTA_ADDRESS      (0)      //!< Bit position for PCIE_PL_IATURUTA_ADDRESS.
#define BM_PCIE_PL_IATURUTA_ADDRESS      (0xffffffff)  //!< Bit mask for PCIE_PL_IATURUTA_ADDRESS.

//! @brief Get value of PCIE_PL_IATURUTA_ADDRESS from a register value.
#define BG_PCIE_PL_IATURUTA_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_PL_IATURUTA_ADDRESS) >> BP_PCIE_PL_IATURUTA_ADDRESS)

//! @brief Format value for bitfield PCIE_PL_IATURUTA_ADDRESS.
#define BF_PCIE_PL_IATURUTA_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_PL_IATURUTA_ADDRESS) & BM_PCIE_PL_IATURUTA_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS field to a new value.
#define BW_PCIE_PL_IATURUTA_ADDRESS(v)   (HW_PCIE_PL_IATURUTA_WR((HW_PCIE_PL_IATURUTA_RD() & ~BM_PCIE_PL_IATURUTA_ADDRESS) | BF_PCIE_PL_IATURUTA_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_pcie_pl_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All PCIE_PL module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_pcie_pl
{
    reg32_t _reserved0[448];
    volatile hw_pcie_pl_altrtr_t ALTRTR; //!< Ack Latency Timer and Replay Timer Register
    volatile hw_pcie_pl_vsdr_t VSDR; //!< Vendor Specific DLLP Register
    volatile hw_pcie_pl_pflr_t PFLR; //!< Port Force Link Register
    volatile hw_pcie_pl_aflacr_t AFLACR; //!< Ack Frequency and L0-L1 ASPM Control Register
    volatile hw_pcie_pl_plcr_t PLCR; //!< Port Link Control Register
    volatile hw_pcie_pl_lsr_t LSR; //!< Lane Skew Register
    volatile hw_pcie_pl_snr_t SNR; //!< Symbol Number Register
    volatile hw_pcie_pl_strfm1_t STRFM1; //!< Symbol Timer Register and Filter Mask Register 1
    volatile hw_pcie_pl_strfm2_t STRFM2; //!< Filter Mask Register 2
    volatile hw_pcie_pl_amodnpsr_t AMODNPSR; //!< AMBA Multiple Outbound Decomposed NP Sub-Requests Control Register
    volatile hw_pcie_pl_debug0_t DEBUG0; //!< Debug Register 0
    volatile hw_pcie_pl_debug1_t DEBUG1; //!< Debug Register 1
    volatile hw_pcie_pl_tpfcsr_t TPFCSR; //!< Transmit Posted FC Credit Status Register
    volatile hw_pcie_pl_tnfcsr_t TNFCSR; //!< Transmit Non-Posted FC Credit Status Register
    volatile hw_pcie_pl_tcfcsr_t TCFCSR; //!< Transmit Completion FC Credit Status Register
    volatile hw_pcie_pl_qsr_t QSR; //!< Queue Status Register
    volatile hw_pcie_pl_vctar1_t VCTAR1; //!< VC Transmit Arbitration Register 1
    volatile hw_pcie_pl_vctar2_t VCTAR2; //!< VC Transmit Arbitration Register 2
    volatile hw_pcie_pl_vc0prqc_t VC0PRQC; //!< VC0 Posted Receive Queue Control
    volatile hw_pcie_pl_vc0nrqc_t VC0NRQC; //!< VC0 Non-Posted Receive Queue Control
    volatile hw_pcie_pl_vc0crqc_t VC0CRQC; //!< VC0 Completion Receive Queue Control
    volatile hw_pcie_pl_vcnprqc_t VCNPRQC; //!< VCn Posted Receive Queue Control
    volatile hw_pcie_pl_vcnnrqc_t VCNNRQC; //!< VCn Non-Posted Receive Queue Control
    volatile hw_pcie_pl_vcncrqc_t VCNCRQC; //!< VCn Completion Receive Queue Control
    reg32_t _reserved1[18];
    volatile hw_pcie_pl_vc0pbd_t VC0PBD; //!< VC0 Posted Buffer Depth
    volatile hw_pcie_pl_vc0npbd_t VC0NPBD; //!< VC0 Non-Posted Buffer Depth
    volatile hw_pcie_pl_vc0cbd_t VC0CBD; //!< VC0 Completion Buffer Depth
    volatile hw_pcie_pl_vc1pbd_t VC1PBD; //!< VCn Posted Buffer Depth
    volatile hw_pcie_pl_vc1npbd_t VC1NPBD; //!< VCn Non-Posted Buffer Depth
    volatile hw_pcie_pl_vc1cbd_t VC1CBD; //!< VCnCompletion Buffer Depth
    reg32_t _reserved2[19];
    volatile hw_pcie_pl_g2cr_t G2CR; //!< Gen2 Control Register
    volatile hw_pcie_pl_phy_status_t PHY_STATUS; //!< PHY Status
    volatile hw_pcie_pl_phy_ctrl_t PHY_CTRL; //!< PHY Control
    volatile hw_pcie_pl_mrccr0_t MRCCR0; //!< Master Response Composer Control Register 0
    volatile hw_pcie_pl_mrccr1_t MRCCR1; //!< Master Response Composer Control Register 1
    volatile hw_pcie_pl_msica_t MSICA; //!< MSI Controller Address
    volatile hw_pcie_pl_msicua_t MSICUA; //!< MSI Controller Upper Address
    volatile hw_pcie_pl_msicin_enb_t MSICIN_ENB; //!< MSI Controller Interrupt n Enable
    volatile hw_pcie_pl_msicin_mask_t MSICIN_MASK; //!< MSI Controller Interrupt n Mask
    volatile hw_pcie_pl_msicin_status_t MSICIN_STATUS; //!< MSI Controller Interrupt nStatus
    reg32_t _reserved3[21];
    volatile hw_pcie_pl_msicgpio_t MSICGPIO; //!< MSI Controller General Purpose IO Register
    reg32_t _reserved4[29];
    volatile hw_pcie_pl_iatuvr_t IATUVR; //!< iATU Viewport Register
    volatile hw_pcie_pl_iaturc1_t IATURC1; //!< iATU Region Control 1 Register
    volatile hw_pcie_pl_iaturc2_t IATURC2; //!< iATU Region Control 2 Register
    volatile hw_pcie_pl_iaturlba_t IATURLBA; //!< iATU Region Lower Base Address Register
    volatile hw_pcie_pl_iaturuba_t IATURUBA; //!< iATU Region Upper Base Address Register
    volatile hw_pcie_pl_iaturla_t IATURLA; //!< iATU Region Limit Address Register
    volatile hw_pcie_pl_iaturlta_t IATURLTA; //!< iATU Region Lower Target Address Register
    volatile hw_pcie_pl_iaturuta_t IATURUTA; //!< iATU Region Upper Target Address Register
} hw_pcie_pl_t;
#pragma pack()

//! @brief Macro to access all PCIE_PL registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_PCIE_PL</code>.
#define HW_PCIE_PL     (*(hw_pcie_pl_t *) REGS_PCIE_PL_BASE)
#endif

#endif // __HW_PCIE_PL_REGISTERS_H__
// v18/121106/1.2.2
// EOF
