/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_OCOTP_REGISTERS_H__
#define __HW_OCOTP_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL OCOTP
 *
 * OCOTP Register Reference Index
 *
 * Registers defined in this header file:
 * - HW_OCOTP_CTRL - OTP Controller Control Register
 * - HW_OCOTP_TIMING - OTP Controller Timing Register
 * - HW_OCOTP_DATA - OTP Controller Write Data Register
 * - HW_OCOTP_READ_CTRL - OTP Controller Write Data Register
 * - HW_OCOTP_READ_FUSE_DATA - OTP Controller Read Data Register
 * - HW_OCOTP_SW_STICKY - Sticky bit Register
 * - HW_OCOTP_SCS - Software Controllable Signals Register
 * - HW_OCOTP_VERSION - OTP Controller Version Register
 * - HW_OCOTP_LOCK - Value of OTP Bank0 Word0 (Lock controls)
 * - HW_OCOTP_CFG0 - Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG1 - Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG2 - Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG3 - Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG4 - Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG5 - Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_CFG6 - Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.)
 * - HW_OCOTP_MEM0 - Value of OTP Bank1 Word0 (Memory Related Info.)
 * - HW_OCOTP_MEM1 - Value of OTP Bank1 Word1 (Memory Related Info.)
 * - HW_OCOTP_MEM2 - Value of OTP Bank1 Word2 (Memory Related Info.)
 * - HW_OCOTP_MEM3 - Value of OTP Bank1 Word3 (Memory Related Info.)
 * - HW_OCOTP_MEM4 - Value of OTP Bank1 Word4 (Memory Related Info.)
 * - HW_OCOTP_ANA0 - Value of OTP Bank1 Word5 (Memory Related Info.)
 * - HW_OCOTP_ANA1 - Value of OTP Bank1 Word6 (General Purpose Customer Defined Info.)
 * - HW_OCOTP_ANA2 - Value of OTP Bank1 Word7 (General Purpose Customer Defined Info.)
 * - HW_OCOTP_SRK0 - Shadow Register for OTP Bank3 Word0 (SRK Hash)
 * - HW_OCOTP_SRK1 - Shadow Register for OTP Bank3 Word1 (SRK Hash)
 * - HW_OCOTP_SRK2 - Shadow Register for OTP Bank3 Word2 (SRK Hash)
 * - HW_OCOTP_SRK3 - Shadow Register for OTP Bank3 Word3 (SRK Hash)
 * - HW_OCOTP_SRK4 - Shadow Register for OTP Bank3 Word4 (SRK Hash)
 * - HW_OCOTP_SRK5 - Shadow Register for OTP Bank3 Word5 (SRK Hash)
 * - HW_OCOTP_SRK6 - Shadow Register for OTP Bank3 Word6 (SRK Hash)
 * - HW_OCOTP_SRK7 - Shadow Register for OTP Bank3 Word7 (SRK Hash)
 * - HW_OCOTP_RESP0 - Value of OTP Bank4 Word0 (Secure JTAG Response Field)
 * - HW_OCOTP_HSJC_RESP1 - Value of OTP Bank4 Word1 (Secure JTAG Response Field)
 * - HW_OCOTP_MAC0 - Value of OTP Bank4 Word2 (MAC Address)
 * - HW_OCOTP_MAC1 - Value of OTP Bank4 Word3 (MAC Address)
 * - HW_OCOTP_GP1 - Value of OTP Bank4 Word6 (HW Capabilities)
 * - HW_OCOTP_GP2 - Value of OTP Bank4 Word7 (HW Capabilities)
 * - HW_OCOTP_MISC_CONF - Value of OTP Bank5 Word5 (HW Capabilities)
 * - HW_OCOTP_FIELD_RETURN - Value of OTP Bank5 Word6 (HW Capabilities)
 * - HW_OCOTP_SRK_REVOKE - Value of OTP Bank5 Word7 (HW Capabilities)
 *
 * - hw_ocotp_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_OCOTP_BASE
#define HW_OCOTP_INSTANCE_COUNT (1) //!< Number of instances of the OCOTP module.
#define REGS_OCOTP_BASE (0x021bc000) //!< Base address for OCOTP.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CTRL - OTP Controller Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CTRL - OTP Controller Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The OCOTP Control and Status Register specifies the copy state, as well as the control required
 * for random access of the OTP memory OCOTP_CTRL: 0x000 The OCOTP Control and Status Register
 * provides the necessary software interface for performing read and write operations to the On-Chip
 * OTP (One-Time Programmable ROM). The control fields such as WR_UNLOCK, ADDR and BUSY/ERROR may be
 * used in conjuction with the HW_OCOTP_DATA register to perform write operations. Read operations
 * to the On-Chip OTP are involving ADDR, BUSY/ERROR bit field and HW_OCOTP_READ_CTRL register. Read
 * value is saved in HW_OCOTP_READ_FUSE_DATA register. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_ctrl
{
    reg32_t U;
    struct _hw_ocotp_ctrl_bitfields
    {
        unsigned ADDR : 7; //!< [6:0] OTP write and read access address register.
        unsigned RESERVED0 : 1; //!< [7] Reserved
        unsigned BUSY : 1; //!< [8] OTP controller status bit.
        unsigned ERROR : 1; //!< [9] Set by the controller when an access to a locked region(OTP or shadow register) is requested.
        unsigned RELOAD_SHADOWS : 1; //!< [10] Set to force re-loading the shadow registers (HW/SW capability and LOCK).
        unsigned RESERVED1 : 5; //!< [15:11] Reserved.
        unsigned WR_UNLOCK : 16; //!< [31:16] Write 0x3E77 to enable OTP write accesses.
    } B;
} hw_ocotp_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CTRL register
 */
//@{
#define HW_OCOTP_CTRL_ADDR      (REGS_OCOTP_BASE + 0x0)
#define HW_OCOTP_CTRL_SET_ADDR  (HW_OCOTP_CTRL_ADDR + 0x4)
#define HW_OCOTP_CTRL_CLR_ADDR  (HW_OCOTP_CTRL_ADDR + 0x8)
#define HW_OCOTP_CTRL_TOG_ADDR  (HW_OCOTP_CTRL_ADDR + 0xC)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CTRL           (*(volatile hw_ocotp_ctrl_t *) HW_OCOTP_CTRL_ADDR)
#define HW_OCOTP_CTRL_RD()      (HW_OCOTP_CTRL.U)
#define HW_OCOTP_CTRL_WR(v)     (HW_OCOTP_CTRL.U = (v))
#define HW_OCOTP_CTRL_SET(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_SET_ADDR) = (v))
#define HW_OCOTP_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_CLR_ADDR) = (v))
#define HW_OCOTP_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_OCOTP_CTRL_TOG_ADDR) = (v))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CTRL bitfields
 */

/*! @name Register OCOTP_CTRL, field ADDR[6:0] (RW)
 *
 * OTP write and read access address register. Specifies one of 128 word address locations (0x00 -
 * 0x7f). If a valid access is accepted by the controller, the controller makes an internal copy of
 * this value. This internal copy will not update until the access is complete.
 */
//@{
#define BP_OCOTP_CTRL_ADDR      (0)      //!< Bit position for OCOTP_CTRL_ADDR.
#define BM_OCOTP_CTRL_ADDR      (0x0000007f)  //!< Bit mask for OCOTP_CTRL_ADDR.

//! @brief Get value of OCOTP_CTRL_ADDR from a register value.
#define BG_OCOTP_CTRL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CTRL_ADDR) >> BP_OCOTP_CTRL_ADDR)

//! @brief Format value for bitfield OCOTP_CTRL_ADDR.
#define BF_OCOTP_CTRL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CTRL_ADDR) & BM_OCOTP_CTRL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDR field to a new value.
#define BW_OCOTP_CTRL_ADDR(v)   BF_CS1(OCOTP_CTRL, ADDR, v)
#endif
//@}

/*! @name Register OCOTP_CTRL, field BUSY[8] (RO)
 *
 * OTP controller status bit. When active, no new write access or read access to OTP(including
 * RELOAD_SHADOWS) can be performed. Cleared by controller when access complete. After reset (or
 * after setting RELOAD_SHADOWS), this bit is set by the controller until the HW/SW and LOCK
 * registers are successfully copied, after which time it is automatically cleared by the
 * controller.
 */
//@{
#define BP_OCOTP_CTRL_BUSY      (8)      //!< Bit position for OCOTP_CTRL_BUSY.
#define BM_OCOTP_CTRL_BUSY      (0x00000100)  //!< Bit mask for OCOTP_CTRL_BUSY.

//! @brief Get value of OCOTP_CTRL_BUSY from a register value.
#define BG_OCOTP_CTRL_BUSY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CTRL_BUSY) >> BP_OCOTP_CTRL_BUSY)
//@}

/*! @name Register OCOTP_CTRL, field ERROR[9] (RW)
 *
 * Set by the controller when an access to a locked region(OTP or shadow register) is requested.
 * Must be cleared before any further access can be performed. This bit can only be set by the
 * controller. This bit is also set if the Pin interface is active and software requests an access
 * to the OTP. In this instance, the ERROR bit cannot be cleared until the Pin interface access has
 * completed. Reset this bit by writing a one to the SCT clear address space and not by a general
 * write.
 */
//@{
#define BP_OCOTP_CTRL_ERROR      (9)      //!< Bit position for OCOTP_CTRL_ERROR.
#define BM_OCOTP_CTRL_ERROR      (0x00000200)  //!< Bit mask for OCOTP_CTRL_ERROR.

//! @brief Get value of OCOTP_CTRL_ERROR from a register value.
#define BG_OCOTP_CTRL_ERROR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CTRL_ERROR) >> BP_OCOTP_CTRL_ERROR)

//! @brief Format value for bitfield OCOTP_CTRL_ERROR.
#define BF_OCOTP_CTRL_ERROR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CTRL_ERROR) & BM_OCOTP_CTRL_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR field to a new value.
#define BW_OCOTP_CTRL_ERROR(v)   BF_CS1(OCOTP_CTRL, ERROR, v)
#endif
//@}

/*! @name Register OCOTP_CTRL, field RELOAD_SHADOWS[10] (RW)
 *
 * Set to force re-loading the shadow registers (HW/SW capability and LOCK). This operation will
 * automatically set BUSY. Once the shadow registers have been re-loaded, BUSY and RELOAD_SHADOWS
 * are automatically cleared by the controller.
 */
//@{
#define BP_OCOTP_CTRL_RELOAD_SHADOWS      (10)      //!< Bit position for OCOTP_CTRL_RELOAD_SHADOWS.
#define BM_OCOTP_CTRL_RELOAD_SHADOWS      (0x00000400)  //!< Bit mask for OCOTP_CTRL_RELOAD_SHADOWS.

//! @brief Get value of OCOTP_CTRL_RELOAD_SHADOWS from a register value.
#define BG_OCOTP_CTRL_RELOAD_SHADOWS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CTRL_RELOAD_SHADOWS) >> BP_OCOTP_CTRL_RELOAD_SHADOWS)

//! @brief Format value for bitfield OCOTP_CTRL_RELOAD_SHADOWS.
#define BF_OCOTP_CTRL_RELOAD_SHADOWS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CTRL_RELOAD_SHADOWS) & BM_OCOTP_CTRL_RELOAD_SHADOWS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RELOAD_SHADOWS field to a new value.
#define BW_OCOTP_CTRL_RELOAD_SHADOWS(v)   BF_CS1(OCOTP_CTRL, RELOAD_SHADOWS, v)
#endif
//@}

/*! @name Register OCOTP_CTRL, field WR_UNLOCK[31:16] (RW)
 *
 * Write 0x3E77 to enable OTP write accesses. NOTE: This register must be unlocked on a write-by-
 * write basis (a write is initiated when HW_OCOTP_DATA is written), so the UNLOCK bitfield must
 * contain the correct key value during all writes to HW_OCOTP_DATA, otherwise a write shall not be
 * initiated. This field is automatically cleared after a successful write completion (clearing of
 * BUSY).
 *
 * Values:
 * - KEY = 0x3E77 - Key needed to unlock HW_OCOTP_DATA register.
 */
//@{
#define BP_OCOTP_CTRL_WR_UNLOCK      (16)      //!< Bit position for OCOTP_CTRL_WR_UNLOCK.
#define BM_OCOTP_CTRL_WR_UNLOCK      (0xffff0000)  //!< Bit mask for OCOTP_CTRL_WR_UNLOCK.

//! @brief Get value of OCOTP_CTRL_WR_UNLOCK from a register value.
#define BG_OCOTP_CTRL_WR_UNLOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CTRL_WR_UNLOCK) >> BP_OCOTP_CTRL_WR_UNLOCK)

//! @brief Format value for bitfield OCOTP_CTRL_WR_UNLOCK.
#define BF_OCOTP_CTRL_WR_UNLOCK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CTRL_WR_UNLOCK) & BM_OCOTP_CTRL_WR_UNLOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WR_UNLOCK field to a new value.
#define BW_OCOTP_CTRL_WR_UNLOCK(v)   BF_CS1(OCOTP_CTRL, WR_UNLOCK, v)
#endif

//! @brief Macro to simplify usage of value macros.
#define BF_OCOTP_CTRL_WR_UNLOCK_V(v) BF_OCOTP_CTRL_WR_UNLOCK(BV_OCOTP_CTRL_WR_UNLOCK__##v)

#define BV_OCOTP_CTRL_WR_UNLOCK__KEY (0x3e77) //!< Key needed to unlock HW_OCOTP_DATA register.
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_TIMING - OTP Controller Timing Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_TIMING - OTP Controller Timing Register (RW)
 *
 * Reset value: 0x01461299
 *
 * The OCOTP Data Register is used for OTP Programming This register specifies timing parameters for
 * programming and reading the OCOTP fuse array. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_timing
{
    reg32_t U;
    struct _hw_ocotp_timing_bitfields
    {
        unsigned STROBE_PROG : 12; //!< [11:0] This count value specifies the strobe period in one time write OTP.
        unsigned RELAX : 4; //!< [15:12] This count value specifies the time to add to all default timing parameters other than the Tpgm and Trd.
        unsigned STROBE_READ : 6; //!< [21:16] This count value specifies the strobe period in one time read OTP.
        unsigned WAIT : 6; //!< [27:22] This count value specifies time interval between auto read and write access in one time program.
        unsigned RESERVED0 : 4; //!< [31:28] These bits always read back zero.
    } B;
} hw_ocotp_timing_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_TIMING register
 */
//@{
#define HW_OCOTP_TIMING_ADDR      (REGS_OCOTP_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_TIMING           (*(volatile hw_ocotp_timing_t *) HW_OCOTP_TIMING_ADDR)
#define HW_OCOTP_TIMING_RD()      (HW_OCOTP_TIMING.U)
#define HW_OCOTP_TIMING_WR(v)     (HW_OCOTP_TIMING.U = (v))
#define HW_OCOTP_TIMING_SET(v)    (HW_OCOTP_TIMING_WR(HW_OCOTP_TIMING_RD() |  (v)))
#define HW_OCOTP_TIMING_CLR(v)    (HW_OCOTP_TIMING_WR(HW_OCOTP_TIMING_RD() & ~(v)))
#define HW_OCOTP_TIMING_TOG(v)    (HW_OCOTP_TIMING_WR(HW_OCOTP_TIMING_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_TIMING bitfields
 */

/*! @name Register OCOTP_TIMING, field STROBE_PROG[11:0] (RW)
 *
 * This count value specifies the strobe period in one time write OTP. Tpgm = ((STROBE_PROG+1)-
 * 2*(RELAX+1)) /ipg_clk_freq. It is given in number of ipg_clk periods.
 */
//@{
#define BP_OCOTP_TIMING_STROBE_PROG      (0)      //!< Bit position for OCOTP_TIMING_STROBE_PROG.
#define BM_OCOTP_TIMING_STROBE_PROG      (0x00000fff)  //!< Bit mask for OCOTP_TIMING_STROBE_PROG.

//! @brief Get value of OCOTP_TIMING_STROBE_PROG from a register value.
#define BG_OCOTP_TIMING_STROBE_PROG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_TIMING_STROBE_PROG) >> BP_OCOTP_TIMING_STROBE_PROG)

//! @brief Format value for bitfield OCOTP_TIMING_STROBE_PROG.
#define BF_OCOTP_TIMING_STROBE_PROG(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_TIMING_STROBE_PROG) & BM_OCOTP_TIMING_STROBE_PROG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STROBE_PROG field to a new value.
#define BW_OCOTP_TIMING_STROBE_PROG(v)   (HW_OCOTP_TIMING_WR((HW_OCOTP_TIMING_RD() & ~BM_OCOTP_TIMING_STROBE_PROG) | BF_OCOTP_TIMING_STROBE_PROG(v)))
#endif
//@}

/*! @name Register OCOTP_TIMING, field RELAX[15:12] (RW)
 *
 * This count value specifies the time to add to all default timing parameters other than the Tpgm
 * and Trd. It is given in number of ipg_clk periods.
 */
//@{
#define BP_OCOTP_TIMING_RELAX      (12)      //!< Bit position for OCOTP_TIMING_RELAX.
#define BM_OCOTP_TIMING_RELAX      (0x0000f000)  //!< Bit mask for OCOTP_TIMING_RELAX.

//! @brief Get value of OCOTP_TIMING_RELAX from a register value.
#define BG_OCOTP_TIMING_RELAX(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_TIMING_RELAX) >> BP_OCOTP_TIMING_RELAX)

//! @brief Format value for bitfield OCOTP_TIMING_RELAX.
#define BF_OCOTP_TIMING_RELAX(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_TIMING_RELAX) & BM_OCOTP_TIMING_RELAX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RELAX field to a new value.
#define BW_OCOTP_TIMING_RELAX(v)   (HW_OCOTP_TIMING_WR((HW_OCOTP_TIMING_RD() & ~BM_OCOTP_TIMING_RELAX) | BF_OCOTP_TIMING_RELAX(v)))
#endif
//@}

/*! @name Register OCOTP_TIMING, field STROBE_READ[21:16] (RW)
 *
 * This count value specifies the strobe period in one time read OTP. Trd = ((STROBE_READ+1)-
 * 2*(RELAX+1)) /ipg_clk_freq. It is given in number of ipg_clk periods.
 */
//@{
#define BP_OCOTP_TIMING_STROBE_READ      (16)      //!< Bit position for OCOTP_TIMING_STROBE_READ.
#define BM_OCOTP_TIMING_STROBE_READ      (0x003f0000)  //!< Bit mask for OCOTP_TIMING_STROBE_READ.

//! @brief Get value of OCOTP_TIMING_STROBE_READ from a register value.
#define BG_OCOTP_TIMING_STROBE_READ(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_TIMING_STROBE_READ) >> BP_OCOTP_TIMING_STROBE_READ)

//! @brief Format value for bitfield OCOTP_TIMING_STROBE_READ.
#define BF_OCOTP_TIMING_STROBE_READ(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_TIMING_STROBE_READ) & BM_OCOTP_TIMING_STROBE_READ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STROBE_READ field to a new value.
#define BW_OCOTP_TIMING_STROBE_READ(v)   (HW_OCOTP_TIMING_WR((HW_OCOTP_TIMING_RD() & ~BM_OCOTP_TIMING_STROBE_READ) | BF_OCOTP_TIMING_STROBE_READ(v)))
#endif
//@}

/*! @name Register OCOTP_TIMING, field WAIT[27:22] (RW)
 *
 * This count value specifies time interval between auto read and write access in one time program.
 * It is given in number of ipg_clk periods.
 */
//@{
#define BP_OCOTP_TIMING_WAIT      (22)      //!< Bit position for OCOTP_TIMING_WAIT.
#define BM_OCOTP_TIMING_WAIT      (0x0fc00000)  //!< Bit mask for OCOTP_TIMING_WAIT.

//! @brief Get value of OCOTP_TIMING_WAIT from a register value.
#define BG_OCOTP_TIMING_WAIT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_TIMING_WAIT) >> BP_OCOTP_TIMING_WAIT)

//! @brief Format value for bitfield OCOTP_TIMING_WAIT.
#define BF_OCOTP_TIMING_WAIT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_TIMING_WAIT) & BM_OCOTP_TIMING_WAIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAIT field to a new value.
#define BW_OCOTP_TIMING_WAIT(v)   (HW_OCOTP_TIMING_WR((HW_OCOTP_TIMING_RD() & ~BM_OCOTP_TIMING_WAIT) | BF_OCOTP_TIMING_WAIT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_DATA - OTP Controller Write Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_DATA - OTP Controller Write Data Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The OCOTP Data Register is used for OTP Programming This register is used in conjuction with
 * HW_OCOTP_CTRL to perform one-time writes to the OTP. Please see the "Software Write Sequence"
 * section for operating details. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_data
{
    reg32_t U;
    struct _hw_ocotp_data_bitfields
    {
        unsigned DATA : 32; //!< [31:0] Used to initiate a write to OTP.
    } B;
} hw_ocotp_data_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_DATA register
 */
//@{
#define HW_OCOTP_DATA_ADDR      (REGS_OCOTP_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_DATA           (*(volatile hw_ocotp_data_t *) HW_OCOTP_DATA_ADDR)
#define HW_OCOTP_DATA_RD()      (HW_OCOTP_DATA.U)
#define HW_OCOTP_DATA_WR(v)     (HW_OCOTP_DATA.U = (v))
#define HW_OCOTP_DATA_SET(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() |  (v)))
#define HW_OCOTP_DATA_CLR(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() & ~(v)))
#define HW_OCOTP_DATA_TOG(v)    (HW_OCOTP_DATA_WR(HW_OCOTP_DATA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_DATA bitfields
 */

/*! @name Register OCOTP_DATA, field DATA[31:0] (RW)
 *
 * Used to initiate a write to OTP. Please see the "Software Write Sequence" section for operating
 * details.
 */
//@{
#define BP_OCOTP_DATA_DATA      (0)      //!< Bit position for OCOTP_DATA_DATA.
#define BM_OCOTP_DATA_DATA      (0xffffffff)  //!< Bit mask for OCOTP_DATA_DATA.

//! @brief Get value of OCOTP_DATA_DATA from a register value.
#define BG_OCOTP_DATA_DATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_DATA_DATA) >> BP_OCOTP_DATA_DATA)

//! @brief Format value for bitfield OCOTP_DATA_DATA.
#define BF_OCOTP_DATA_DATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_DATA_DATA) & BM_OCOTP_DATA_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_OCOTP_DATA_DATA(v)   (HW_OCOTP_DATA_WR((HW_OCOTP_DATA_RD() & ~BM_OCOTP_DATA_DATA) | BF_OCOTP_DATA_DATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_READ_CTRL - OTP Controller Write Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_READ_CTRL - OTP Controller Write Data Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The OCOTP Register is used for OTP Read This register is used in conjuction with HW_OCOTP_CTRL to
 * perform one time read to the OTP. Please see the "Software read Sequence" section for operating
 * details. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_read_ctrl
{
    reg32_t U;
    struct _hw_ocotp_read_ctrl_bitfields
    {
        unsigned READ_FUSE : 1; //!< [0] Used to initiate a read to OTP.
        unsigned RESERVED0 : 31; //!< [31:1] Reserved
    } B;
} hw_ocotp_read_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_READ_CTRL register
 */
//@{
#define HW_OCOTP_READ_CTRL_ADDR      (REGS_OCOTP_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_READ_CTRL           (*(volatile hw_ocotp_read_ctrl_t *) HW_OCOTP_READ_CTRL_ADDR)
#define HW_OCOTP_READ_CTRL_RD()      (HW_OCOTP_READ_CTRL.U)
#define HW_OCOTP_READ_CTRL_WR(v)     (HW_OCOTP_READ_CTRL.U = (v))
#define HW_OCOTP_READ_CTRL_SET(v)    (HW_OCOTP_READ_CTRL_WR(HW_OCOTP_READ_CTRL_RD() |  (v)))
#define HW_OCOTP_READ_CTRL_CLR(v)    (HW_OCOTP_READ_CTRL_WR(HW_OCOTP_READ_CTRL_RD() & ~(v)))
#define HW_OCOTP_READ_CTRL_TOG(v)    (HW_OCOTP_READ_CTRL_WR(HW_OCOTP_READ_CTRL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_READ_CTRL bitfields
 */

/*! @name Register OCOTP_READ_CTRL, field READ_FUSE[0] (RW)
 *
 * Used to initiate a read to OTP. Please see the "Software read Sequence" section for operating
 * details.
 */
//@{
#define BP_OCOTP_READ_CTRL_READ_FUSE      (0)      //!< Bit position for OCOTP_READ_CTRL_READ_FUSE.
#define BM_OCOTP_READ_CTRL_READ_FUSE      (0x00000001)  //!< Bit mask for OCOTP_READ_CTRL_READ_FUSE.

//! @brief Get value of OCOTP_READ_CTRL_READ_FUSE from a register value.
#define BG_OCOTP_READ_CTRL_READ_FUSE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_READ_CTRL_READ_FUSE) >> BP_OCOTP_READ_CTRL_READ_FUSE)

//! @brief Format value for bitfield OCOTP_READ_CTRL_READ_FUSE.
#define BF_OCOTP_READ_CTRL_READ_FUSE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_READ_CTRL_READ_FUSE) & BM_OCOTP_READ_CTRL_READ_FUSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the READ_FUSE field to a new value.
#define BW_OCOTP_READ_CTRL_READ_FUSE(v)   (HW_OCOTP_READ_CTRL_WR((HW_OCOTP_READ_CTRL_RD() & ~BM_OCOTP_READ_CTRL_READ_FUSE) | BF_OCOTP_READ_CTRL_READ_FUSE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_READ_FUSE_DATA - OTP Controller Read Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_READ_FUSE_DATA - OTP Controller Read Data Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The OCOTP Data Register is used for OTP Read The data read from OTP EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_read_fuse_data
{
    reg32_t U;
    struct _hw_ocotp_read_fuse_data_bitfields
    {
        unsigned DATA : 32; //!< [31:0] The data read from OTP
    } B;
} hw_ocotp_read_fuse_data_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_READ_FUSE_DATA register
 */
//@{
#define HW_OCOTP_READ_FUSE_DATA_ADDR      (REGS_OCOTP_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_READ_FUSE_DATA           (*(volatile hw_ocotp_read_fuse_data_t *) HW_OCOTP_READ_FUSE_DATA_ADDR)
#define HW_OCOTP_READ_FUSE_DATA_RD()      (HW_OCOTP_READ_FUSE_DATA.U)
#define HW_OCOTP_READ_FUSE_DATA_WR(v)     (HW_OCOTP_READ_FUSE_DATA.U = (v))
#define HW_OCOTP_READ_FUSE_DATA_SET(v)    (HW_OCOTP_READ_FUSE_DATA_WR(HW_OCOTP_READ_FUSE_DATA_RD() |  (v)))
#define HW_OCOTP_READ_FUSE_DATA_CLR(v)    (HW_OCOTP_READ_FUSE_DATA_WR(HW_OCOTP_READ_FUSE_DATA_RD() & ~(v)))
#define HW_OCOTP_READ_FUSE_DATA_TOG(v)    (HW_OCOTP_READ_FUSE_DATA_WR(HW_OCOTP_READ_FUSE_DATA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_READ_FUSE_DATA bitfields
 */

/*! @name Register OCOTP_READ_FUSE_DATA, field DATA[31:0] (RW)
 *
 * The data read from OTP
 */
//@{
#define BP_OCOTP_READ_FUSE_DATA_DATA      (0)      //!< Bit position for OCOTP_READ_FUSE_DATA_DATA.
#define BM_OCOTP_READ_FUSE_DATA_DATA      (0xffffffff)  //!< Bit mask for OCOTP_READ_FUSE_DATA_DATA.

//! @brief Get value of OCOTP_READ_FUSE_DATA_DATA from a register value.
#define BG_OCOTP_READ_FUSE_DATA_DATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_READ_FUSE_DATA_DATA) >> BP_OCOTP_READ_FUSE_DATA_DATA)

//! @brief Format value for bitfield OCOTP_READ_FUSE_DATA_DATA.
#define BF_OCOTP_READ_FUSE_DATA_DATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_READ_FUSE_DATA_DATA) & BM_OCOTP_READ_FUSE_DATA_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_OCOTP_READ_FUSE_DATA_DATA(v)   (HW_OCOTP_READ_FUSE_DATA_WR((HW_OCOTP_READ_FUSE_DATA_RD() & ~BM_OCOTP_READ_FUSE_DATA_DATA) | BF_OCOTP_READ_FUSE_DATA_DATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SW_STICKY - Sticky bit Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SW_STICKY - Sticky bit Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Some SW sticky bits . Some sticky bits are used by SW to lock some fuse area , shadow registers
 * and other features. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_sw_sticky
{
    reg32_t U;
    struct _hw_ocotp_sw_sticky_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned SRK_REVOKE_LOCK : 1; //!< [1] Shadow register write and OTP write lock for SRK_REVOKE, MC_ERA and AP_BI_VER regions.
        unsigned FIELD_RETURN_LOCK : 1; //!< [2] Shadow register write and OTP write lock for FIELD_RETURN region.
        unsigned RESERVED1 : 29; //!< [31:3] Reserved
    } B;
} hw_ocotp_sw_sticky_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SW_STICKY register
 */
//@{
#define HW_OCOTP_SW_STICKY_ADDR      (REGS_OCOTP_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SW_STICKY           (*(volatile hw_ocotp_sw_sticky_t *) HW_OCOTP_SW_STICKY_ADDR)
#define HW_OCOTP_SW_STICKY_RD()      (HW_OCOTP_SW_STICKY.U)
#define HW_OCOTP_SW_STICKY_WR(v)     (HW_OCOTP_SW_STICKY.U = (v))
#define HW_OCOTP_SW_STICKY_SET(v)    (HW_OCOTP_SW_STICKY_WR(HW_OCOTP_SW_STICKY_RD() |  (v)))
#define HW_OCOTP_SW_STICKY_CLR(v)    (HW_OCOTP_SW_STICKY_WR(HW_OCOTP_SW_STICKY_RD() & ~(v)))
#define HW_OCOTP_SW_STICKY_TOG(v)    (HW_OCOTP_SW_STICKY_WR(HW_OCOTP_SW_STICKY_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SW_STICKY bitfields
 */

/*! @name Register OCOTP_SW_STICKY, field SRK_REVOKE_LOCK[1] (RW)
 *
 * Shadow register write and OTP write lock for SRK_REVOKE, MC_ERA and AP_BI_VER regions. When set,
 * the writing of these region's shadow register and OTP fuse word are blocked. Once this bit is
 * set, it is always high unless a POR is issued.
 */
//@{
#define BP_OCOTP_SW_STICKY_SRK_REVOKE_LOCK      (1)      //!< Bit position for OCOTP_SW_STICKY_SRK_REVOKE_LOCK.
#define BM_OCOTP_SW_STICKY_SRK_REVOKE_LOCK      (0x00000002)  //!< Bit mask for OCOTP_SW_STICKY_SRK_REVOKE_LOCK.

//! @brief Get value of OCOTP_SW_STICKY_SRK_REVOKE_LOCK from a register value.
#define BG_OCOTP_SW_STICKY_SRK_REVOKE_LOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SW_STICKY_SRK_REVOKE_LOCK) >> BP_OCOTP_SW_STICKY_SRK_REVOKE_LOCK)

//! @brief Format value for bitfield OCOTP_SW_STICKY_SRK_REVOKE_LOCK.
#define BF_OCOTP_SW_STICKY_SRK_REVOKE_LOCK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SW_STICKY_SRK_REVOKE_LOCK) & BM_OCOTP_SW_STICKY_SRK_REVOKE_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRK_REVOKE_LOCK field to a new value.
#define BW_OCOTP_SW_STICKY_SRK_REVOKE_LOCK(v)   (HW_OCOTP_SW_STICKY_WR((HW_OCOTP_SW_STICKY_RD() & ~BM_OCOTP_SW_STICKY_SRK_REVOKE_LOCK) | BF_OCOTP_SW_STICKY_SRK_REVOKE_LOCK(v)))
#endif
//@}

/*! @name Register OCOTP_SW_STICKY, field FIELD_RETURN_LOCK[2] (RW)
 *
 * Shadow register write and OTP write lock for FIELD_RETURN region. When set, the writing of this
 * region's shadow register and OTP fuse word are blocked.Once this bit is set, it is always high
 * unless a POR is issued.
 */
//@{
#define BP_OCOTP_SW_STICKY_FIELD_RETURN_LOCK      (2)      //!< Bit position for OCOTP_SW_STICKY_FIELD_RETURN_LOCK.
#define BM_OCOTP_SW_STICKY_FIELD_RETURN_LOCK      (0x00000004)  //!< Bit mask for OCOTP_SW_STICKY_FIELD_RETURN_LOCK.

//! @brief Get value of OCOTP_SW_STICKY_FIELD_RETURN_LOCK from a register value.
#define BG_OCOTP_SW_STICKY_FIELD_RETURN_LOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SW_STICKY_FIELD_RETURN_LOCK) >> BP_OCOTP_SW_STICKY_FIELD_RETURN_LOCK)

//! @brief Format value for bitfield OCOTP_SW_STICKY_FIELD_RETURN_LOCK.
#define BF_OCOTP_SW_STICKY_FIELD_RETURN_LOCK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SW_STICKY_FIELD_RETURN_LOCK) & BM_OCOTP_SW_STICKY_FIELD_RETURN_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIELD_RETURN_LOCK field to a new value.
#define BW_OCOTP_SW_STICKY_FIELD_RETURN_LOCK(v)   (HW_OCOTP_SW_STICKY_WR((HW_OCOTP_SW_STICKY_RD() & ~BM_OCOTP_SW_STICKY_FIELD_RETURN_LOCK) | BF_OCOTP_SW_STICKY_FIELD_RETURN_LOCK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SCS - Software Controllable Signals Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SCS - Software Controllable Signals Register (RW)
 *
 * Reset value: 0x00000000
 *
 * HW_OCOTP_SCS: 0x060 This register holds volatile configuration values that can be set and locked
 * by trusted software. All values are returned to their defualt values after POR. EXAMPLE Empty
 * Example.
 */
typedef union _hw_ocotp_scs
{
    reg32_t U;
    struct _hw_ocotp_scs_bitfields
    {
        unsigned HAB_JDE : 1; //!< [0] HAB JTAG Debug Enable.
        unsigned SPARE : 30; //!< [30:1] Unallocated read/write bits for implementation specific software use.
        unsigned LOCK : 1; //!< [31] When set, all of the bits in this register are locked and can not be changed through SW programming.
    } B;
} hw_ocotp_scs_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SCS register
 */
//@{
#define HW_OCOTP_SCS_ADDR      (REGS_OCOTP_BASE + 0x60)
#define HW_OCOTP_SCS_SET_ADDR  (HW_OCOTP_SCS_ADDR + 0x4)
#define HW_OCOTP_SCS_CLR_ADDR  (HW_OCOTP_SCS_ADDR + 0x8)
#define HW_OCOTP_SCS_TOG_ADDR  (HW_OCOTP_SCS_ADDR + 0xC)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SCS           (*(volatile hw_ocotp_scs_t *) HW_OCOTP_SCS_ADDR)
#define HW_OCOTP_SCS_RD()      (HW_OCOTP_SCS.U)
#define HW_OCOTP_SCS_WR(v)     (HW_OCOTP_SCS.U = (v))
#define HW_OCOTP_SCS_SET(v)    ((*(volatile reg32_t *) HW_OCOTP_SCS_SET_ADDR) = (v))
#define HW_OCOTP_SCS_CLR(v)    ((*(volatile reg32_t *) HW_OCOTP_SCS_CLR_ADDR) = (v))
#define HW_OCOTP_SCS_TOG(v)    ((*(volatile reg32_t *) HW_OCOTP_SCS_TOG_ADDR) = (v))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SCS bitfields
 */

/*! @name Register OCOTP_SCS, field HAB_JDE[0] (RW)
 *
 * HAB JTAG Debug Enable. This bit is used by the HAB to enable JTAG debugging, assuming that a
 * properlay signed command to do so is found and validated by the HAB. The HAB must lock the
 * register before passing control to the OS whether or not JTAG debugging has been enabled. Once
 * JTAG is enabled by this bit, it can not be disabled unless the system is reset by POR. 0: JTAG
 * debugging is not enabled by the HAB (it may still be enabled by other mechanisms). 1: JTAG
 * debugging is enabled by the HAB (though this signal may be gated off).
 *
 * Values:
 * - 1 - JTAG debugging is enabled by the HAB (though this signal may be gated off)
 */
//@{
#define BP_OCOTP_SCS_HAB_JDE      (0)      //!< Bit position for OCOTP_SCS_HAB_JDE.
#define BM_OCOTP_SCS_HAB_JDE      (0x00000001)  //!< Bit mask for OCOTP_SCS_HAB_JDE.

//! @brief Get value of OCOTP_SCS_HAB_JDE from a register value.
#define BG_OCOTP_SCS_HAB_JDE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SCS_HAB_JDE) >> BP_OCOTP_SCS_HAB_JDE)

//! @brief Format value for bitfield OCOTP_SCS_HAB_JDE.
#define BF_OCOTP_SCS_HAB_JDE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SCS_HAB_JDE) & BM_OCOTP_SCS_HAB_JDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HAB_JDE field to a new value.
#define BW_OCOTP_SCS_HAB_JDE(v)   BF_CS1(OCOTP_SCS, HAB_JDE, v)
#endif
//@}

/*! @name Register OCOTP_SCS, field SPARE[30:1] (RW)
 *
 * Unallocated read/write bits for implementation specific software use.
 */
//@{
#define BP_OCOTP_SCS_SPARE      (1)      //!< Bit position for OCOTP_SCS_SPARE.
#define BM_OCOTP_SCS_SPARE      (0x7ffffffe)  //!< Bit mask for OCOTP_SCS_SPARE.

//! @brief Get value of OCOTP_SCS_SPARE from a register value.
#define BG_OCOTP_SCS_SPARE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SCS_SPARE) >> BP_OCOTP_SCS_SPARE)

//! @brief Format value for bitfield OCOTP_SCS_SPARE.
#define BF_OCOTP_SCS_SPARE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SCS_SPARE) & BM_OCOTP_SCS_SPARE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPARE field to a new value.
#define BW_OCOTP_SCS_SPARE(v)   BF_CS1(OCOTP_SCS, SPARE, v)
#endif
//@}

/*! @name Register OCOTP_SCS, field LOCK[31] (RW)
 *
 * When set, all of the bits in this register are locked and can not be changed through SW
 * programming. This bit is only reset after a POR is issued.
 */
//@{
#define BP_OCOTP_SCS_LOCK      (31)      //!< Bit position for OCOTP_SCS_LOCK.
#define BM_OCOTP_SCS_LOCK      (0x80000000)  //!< Bit mask for OCOTP_SCS_LOCK.

//! @brief Get value of OCOTP_SCS_LOCK from a register value.
#define BG_OCOTP_SCS_LOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SCS_LOCK) >> BP_OCOTP_SCS_LOCK)

//! @brief Format value for bitfield OCOTP_SCS_LOCK.
#define BF_OCOTP_SCS_LOCK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SCS_LOCK) & BM_OCOTP_SCS_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK field to a new value.
#define BW_OCOTP_SCS_LOCK(v)   BF_CS1(OCOTP_SCS, LOCK, v)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_VERSION - OTP Controller Version Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_VERSION - OTP Controller Version Register (RO)
 *
 * Reset value: 0x02000000
 *
 * This register always returns a known read value for debug purposes it indicates the version of
 * the block. This register indicates the RTL version in use. EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_version
{
    reg32_t U;
    struct _hw_ocotp_version_bitfields
    {
        unsigned STEP : 16; //!< [15:0] Fixed read-only value reflecting the stepping of the RTL version.
        unsigned MINOR : 8; //!< [23:16] Fixed read-only value reflecting the MINOR field of the RTL version.
        unsigned MAJOR : 8; //!< [31:24] Fixed read-only value reflecting the MAJOR field of the RTL version.
    } B;
} hw_ocotp_version_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_VERSION register
 */
//@{
#define HW_OCOTP_VERSION_ADDR      (REGS_OCOTP_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_VERSION           (*(volatile hw_ocotp_version_t *) HW_OCOTP_VERSION_ADDR)
#define HW_OCOTP_VERSION_RD()      (HW_OCOTP_VERSION.U)
#endif
//@}

/*
 * constants & macros for individual OCOTP_VERSION bitfields
 */

/*! @name Register OCOTP_VERSION, field STEP[15:0] (RO)
 *
 * Fixed read-only value reflecting the stepping of the RTL version.
 */
//@{
#define BP_OCOTP_VERSION_STEP      (0)      //!< Bit position for OCOTP_VERSION_STEP.
#define BM_OCOTP_VERSION_STEP      (0x0000ffff)  //!< Bit mask for OCOTP_VERSION_STEP.

//! @brief Get value of OCOTP_VERSION_STEP from a register value.
#define BG_OCOTP_VERSION_STEP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_VERSION_STEP) >> BP_OCOTP_VERSION_STEP)
//@}

/*! @name Register OCOTP_VERSION, field MINOR[23:16] (RO)
 *
 * Fixed read-only value reflecting the MINOR field of the RTL version.
 */
//@{
#define BP_OCOTP_VERSION_MINOR      (16)      //!< Bit position for OCOTP_VERSION_MINOR.
#define BM_OCOTP_VERSION_MINOR      (0x00ff0000)  //!< Bit mask for OCOTP_VERSION_MINOR.

//! @brief Get value of OCOTP_VERSION_MINOR from a register value.
#define BG_OCOTP_VERSION_MINOR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_VERSION_MINOR) >> BP_OCOTP_VERSION_MINOR)
//@}

/*! @name Register OCOTP_VERSION, field MAJOR[31:24] (RO)
 *
 * Fixed read-only value reflecting the MAJOR field of the RTL version.
 */
//@{
#define BP_OCOTP_VERSION_MAJOR      (24)      //!< Bit position for OCOTP_VERSION_MAJOR.
#define BM_OCOTP_VERSION_MAJOR      (0xff000000)  //!< Bit mask for OCOTP_VERSION_MAJOR.

//! @brief Get value of OCOTP_VERSION_MAJOR from a register value.
#define BG_OCOTP_VERSION_MAJOR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_VERSION_MAJOR) >> BP_OCOTP_VERSION_MAJOR)
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_LOCK - Value of OTP Bank0 Word0 (Lock controls)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_LOCK - Value of OTP Bank0 Word0 (Lock controls) (RO)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 0 (ADDR = 0x00).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_lock
{
    reg32_t U;
    struct _hw_ocotp_lock_bitfields
    {
        unsigned TESTER : 2; //!< [1:0] Status of shadow register and OTP write lock for tester region.
        unsigned BOOT_CFG : 2; //!< [3:2] Status of shadow register and OTP write lock for boot_cfg region.
        unsigned MEM_TRIM : 2; //!< [5:4] Status of shadow register and OTP write lock for mem_trim region.
        unsigned SJC_RESP : 1; //!< [6] Status of shadow register read and write, OTP read and write lock for sjc_resp region.
        unsigned RESERVED0 : 1; //!< [7] Reserved
        unsigned MAC_ADDR : 2; //!< [9:8] Status of shadow register and OTP write lock for mac_addr region.
        unsigned GP1 : 2; //!< [11:10] Status of shadow register and OTP write lock for gp2 region.
        unsigned GP2 : 2; //!< [13:12] Status of shadow register and OTP write lock for gp2 region.
        unsigned SRK : 1; //!< [14] Status of shadow register and OTP write lock for srk region.
        unsigned RESERVED1 : 3; //!< [17:15] Reserved.
        unsigned ANALOG : 2; //!< [19:18] Status of shadow register and OTP write lock for analog region.
        unsigned RESERVED2 : 2; //!< [21:20] Reserved
        unsigned MISC_CONF : 1; //!< [22] Status of shadow register and OTP write lock for misc_conf region.
        unsigned RESERVED3 : 7; //!< [29:23] Reserved
        unsigned UNALLOCATED : 2; //!< [31:30] Value of un-used portion of LOCK word
    } B;
} hw_ocotp_lock_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_LOCK register
 */
//@{
#define HW_OCOTP_LOCK_ADDR      (REGS_OCOTP_BASE + 0x400)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_LOCK           (*(volatile hw_ocotp_lock_t *) HW_OCOTP_LOCK_ADDR)
#define HW_OCOTP_LOCK_RD()      (HW_OCOTP_LOCK.U)
#endif
//@}

/*
 * constants & macros for individual OCOTP_LOCK bitfields
 */

/*! @name Register OCOTP_LOCK, field TESTER[1:0] (RO)
 *
 * Status of shadow register and OTP write lock for tester region. When bit 1 is set, the writing of
 * this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_TESTER      (0)      //!< Bit position for OCOTP_LOCK_TESTER.
#define BM_OCOTP_LOCK_TESTER      (0x00000003)  //!< Bit mask for OCOTP_LOCK_TESTER.

//! @brief Get value of OCOTP_LOCK_TESTER from a register value.
#define BG_OCOTP_LOCK_TESTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_TESTER) >> BP_OCOTP_LOCK_TESTER)
//@}

/*! @name Register OCOTP_LOCK, field BOOT_CFG[3:2] (RO)
 *
 * Status of shadow register and OTP write lock for boot_cfg region. When bit 1 is set, the writing
 * of this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_BOOT_CFG      (2)      //!< Bit position for OCOTP_LOCK_BOOT_CFG.
#define BM_OCOTP_LOCK_BOOT_CFG      (0x0000000c)  //!< Bit mask for OCOTP_LOCK_BOOT_CFG.

//! @brief Get value of OCOTP_LOCK_BOOT_CFG from a register value.
#define BG_OCOTP_LOCK_BOOT_CFG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_BOOT_CFG) >> BP_OCOTP_LOCK_BOOT_CFG)
//@}

/*! @name Register OCOTP_LOCK, field MEM_TRIM[5:4] (RO)
 *
 * Status of shadow register and OTP write lock for mem_trim region. When bit 1 is set, the writing
 * of this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_MEM_TRIM      (4)      //!< Bit position for OCOTP_LOCK_MEM_TRIM.
#define BM_OCOTP_LOCK_MEM_TRIM      (0x00000030)  //!< Bit mask for OCOTP_LOCK_MEM_TRIM.

//! @brief Get value of OCOTP_LOCK_MEM_TRIM from a register value.
#define BG_OCOTP_LOCK_MEM_TRIM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_MEM_TRIM) >> BP_OCOTP_LOCK_MEM_TRIM)
//@}

/*! @name Register OCOTP_LOCK, field SJC_RESP[6] (RO)
 *
 * Status of shadow register read and write, OTP read and write lock for sjc_resp region. When set,
 * the writing of this region's shadow register and OTP fuse word are blocked. The read of this
 * region's shadow register and OTP fuse word are also blocked.
 */
//@{
#define BP_OCOTP_LOCK_SJC_RESP      (6)      //!< Bit position for OCOTP_LOCK_SJC_RESP.
#define BM_OCOTP_LOCK_SJC_RESP      (0x00000040)  //!< Bit mask for OCOTP_LOCK_SJC_RESP.

//! @brief Get value of OCOTP_LOCK_SJC_RESP from a register value.
#define BG_OCOTP_LOCK_SJC_RESP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_SJC_RESP) >> BP_OCOTP_LOCK_SJC_RESP)
//@}

/*! @name Register OCOTP_LOCK, field MAC_ADDR[9:8] (RO)
 *
 * Status of shadow register and OTP write lock for mac_addr region. When bit 1 is set, the writing
 * of this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_MAC_ADDR      (8)      //!< Bit position for OCOTP_LOCK_MAC_ADDR.
#define BM_OCOTP_LOCK_MAC_ADDR      (0x00000300)  //!< Bit mask for OCOTP_LOCK_MAC_ADDR.

//! @brief Get value of OCOTP_LOCK_MAC_ADDR from a register value.
#define BG_OCOTP_LOCK_MAC_ADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_MAC_ADDR) >> BP_OCOTP_LOCK_MAC_ADDR)
//@}

/*! @name Register OCOTP_LOCK, field GP1[11:10] (RO)
 *
 * Status of shadow register and OTP write lock for gp2 region. When bit 1 is set, the writing of
 * this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_GP1      (10)      //!< Bit position for OCOTP_LOCK_GP1.
#define BM_OCOTP_LOCK_GP1      (0x00000c00)  //!< Bit mask for OCOTP_LOCK_GP1.

//! @brief Get value of OCOTP_LOCK_GP1 from a register value.
#define BG_OCOTP_LOCK_GP1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_GP1) >> BP_OCOTP_LOCK_GP1)
//@}

/*! @name Register OCOTP_LOCK, field GP2[13:12] (RO)
 *
 * Status of shadow register and OTP write lock for gp2 region. When bit 1 is set, the writing of
 * this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_GP2      (12)      //!< Bit position for OCOTP_LOCK_GP2.
#define BM_OCOTP_LOCK_GP2      (0x00003000)  //!< Bit mask for OCOTP_LOCK_GP2.

//! @brief Get value of OCOTP_LOCK_GP2 from a register value.
#define BG_OCOTP_LOCK_GP2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_GP2) >> BP_OCOTP_LOCK_GP2)
//@}

/*! @name Register OCOTP_LOCK, field SRK[14] (RO)
 *
 * Status of shadow register and OTP write lock for srk region. When set, the writing of this
 * region's shadow register and OTP fuse word are blocked.
 */
//@{
#define BP_OCOTP_LOCK_SRK      (14)      //!< Bit position for OCOTP_LOCK_SRK.
#define BM_OCOTP_LOCK_SRK      (0x00004000)  //!< Bit mask for OCOTP_LOCK_SRK.

//! @brief Get value of OCOTP_LOCK_SRK from a register value.
#define BG_OCOTP_LOCK_SRK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_SRK) >> BP_OCOTP_LOCK_SRK)
//@}

/*! @name Register OCOTP_LOCK, field ANALOG[19:18] (RO)
 *
 * Status of shadow register and OTP write lock for analog region. When bit 1 is set, the writing of
 * this region's shadow register is blocked. When bit 0 is set, the writing of this region's OTP
 * fuse word is blocked.
 */
//@{
#define BP_OCOTP_LOCK_ANALOG      (18)      //!< Bit position for OCOTP_LOCK_ANALOG.
#define BM_OCOTP_LOCK_ANALOG      (0x000c0000)  //!< Bit mask for OCOTP_LOCK_ANALOG.

//! @brief Get value of OCOTP_LOCK_ANALOG from a register value.
#define BG_OCOTP_LOCK_ANALOG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_ANALOG) >> BP_OCOTP_LOCK_ANALOG)
//@}

/*! @name Register OCOTP_LOCK, field MISC_CONF[22] (RO)
 *
 * Status of shadow register and OTP write lock for misc_conf region. When set, the writing of this
 * region's shadow register and OTP fuse word are blocked.
 */
//@{
#define BP_OCOTP_LOCK_MISC_CONF      (22)      //!< Bit position for OCOTP_LOCK_MISC_CONF.
#define BM_OCOTP_LOCK_MISC_CONF      (0x00400000)  //!< Bit mask for OCOTP_LOCK_MISC_CONF.

//! @brief Get value of OCOTP_LOCK_MISC_CONF from a register value.
#define BG_OCOTP_LOCK_MISC_CONF(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_MISC_CONF) >> BP_OCOTP_LOCK_MISC_CONF)
//@}

/*! @name Register OCOTP_LOCK, field UNALLOCATED[31:30] (RO)
 *
 * Value of un-used portion of LOCK word
 */
//@{
#define BP_OCOTP_LOCK_UNALLOCATED      (30)      //!< Bit position for OCOTP_LOCK_UNALLOCATED.
#define BM_OCOTP_LOCK_UNALLOCATED      (0xc0000000)  //!< Bit mask for OCOTP_LOCK_UNALLOCATED.

//! @brief Get value of OCOTP_LOCK_UNALLOCATED from a register value.
#define BG_OCOTP_LOCK_UNALLOCATED(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_LOCK_UNALLOCATED) >> BP_OCOTP_LOCK_UNALLOCATED)
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG0 - Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG0 - Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 1 (ADDR = 0x01).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg0
{
    reg32_t U;
    struct _hw_ocotp_cfg0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] This register contains 32 bits of the Unique ID and SJC_CHALLENGE field.
    } B;
} hw_ocotp_cfg0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG0 register
 */
//@{
#define HW_OCOTP_CFG0_ADDR      (REGS_OCOTP_BASE + 0x410)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG0           (*(volatile hw_ocotp_cfg0_t *) HW_OCOTP_CFG0_ADDR)
#define HW_OCOTP_CFG0_RD()      (HW_OCOTP_CFG0.U)
#define HW_OCOTP_CFG0_WR(v)     (HW_OCOTP_CFG0.U = (v))
#define HW_OCOTP_CFG0_SET(v)    (HW_OCOTP_CFG0_WR(HW_OCOTP_CFG0_RD() |  (v)))
#define HW_OCOTP_CFG0_CLR(v)    (HW_OCOTP_CFG0_WR(HW_OCOTP_CFG0_RD() & ~(v)))
#define HW_OCOTP_CFG0_TOG(v)    (HW_OCOTP_CFG0_WR(HW_OCOTP_CFG0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG0 bitfields
 */

/*! @name Register OCOTP_CFG0, field BITS[31:0] (RW)
 *
 * This register contains 32 bits of the Unique ID and SJC_CHALLENGE field. Reflects value of OTP
 * Bank 0, word 1 (ADDR = 0x01). These bits become read-only after the HW_OCOTP_LOCK_TESTER[1] bit
 * is set.
 */
//@{
#define BP_OCOTP_CFG0_BITS      (0)      //!< Bit position for OCOTP_CFG0_BITS.
#define BM_OCOTP_CFG0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG0_BITS.

//! @brief Get value of OCOTP_CFG0_BITS from a register value.
#define BG_OCOTP_CFG0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG0_BITS) >> BP_OCOTP_CFG0_BITS)

//! @brief Format value for bitfield OCOTP_CFG0_BITS.
#define BF_OCOTP_CFG0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG0_BITS) & BM_OCOTP_CFG0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG0_BITS(v)   (HW_OCOTP_CFG0_WR((HW_OCOTP_CFG0_RD() & ~BM_OCOTP_CFG0_BITS) | BF_OCOTP_CFG0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG1 - Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG1 - Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] shadowed memory mapped access to OTP Bank 0, word 2 (ADDR = 0x02).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg1
{
    reg32_t U;
    struct _hw_ocotp_cfg1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] This register contains 32 bits of the Unique ID and SJC_CHALLENGE field.
    } B;
} hw_ocotp_cfg1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG1 register
 */
//@{
#define HW_OCOTP_CFG1_ADDR      (REGS_OCOTP_BASE + 0x420)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG1           (*(volatile hw_ocotp_cfg1_t *) HW_OCOTP_CFG1_ADDR)
#define HW_OCOTP_CFG1_RD()      (HW_OCOTP_CFG1.U)
#define HW_OCOTP_CFG1_WR(v)     (HW_OCOTP_CFG1.U = (v))
#define HW_OCOTP_CFG1_SET(v)    (HW_OCOTP_CFG1_WR(HW_OCOTP_CFG1_RD() |  (v)))
#define HW_OCOTP_CFG1_CLR(v)    (HW_OCOTP_CFG1_WR(HW_OCOTP_CFG1_RD() & ~(v)))
#define HW_OCOTP_CFG1_TOG(v)    (HW_OCOTP_CFG1_WR(HW_OCOTP_CFG1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG1 bitfields
 */

/*! @name Register OCOTP_CFG1, field BITS[31:0] (RW)
 *
 * This register contains 32 bits of the Unique ID and SJC_CHALLENGE field. Reflects value of OTP
 * Bank 0, word 2 (ADDR = 0x02). These bits become read-only after the HW_OCOTP_LOCK_TESTER[1] bit
 * is set.
 */
//@{
#define BP_OCOTP_CFG1_BITS      (0)      //!< Bit position for OCOTP_CFG1_BITS.
#define BM_OCOTP_CFG1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG1_BITS.

//! @brief Get value of OCOTP_CFG1_BITS from a register value.
#define BG_OCOTP_CFG1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG1_BITS) >> BP_OCOTP_CFG1_BITS)

//! @brief Format value for bitfield OCOTP_CFG1_BITS.
#define BF_OCOTP_CFG1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG1_BITS) & BM_OCOTP_CFG1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG1_BITS(v)   (HW_OCOTP_CFG1_WR((HW_OCOTP_CFG1_RD() & ~BM_OCOTP_CFG1_BITS) | BF_OCOTP_CFG1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG2 - Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG2 - Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 3 (ADDR = 0x03).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg2
{
    reg32_t U;
    struct _hw_ocotp_cfg2_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 0, word 3 (ADDR = 0x03).
    } B;
} hw_ocotp_cfg2_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG2 register
 */
//@{
#define HW_OCOTP_CFG2_ADDR      (REGS_OCOTP_BASE + 0x430)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG2           (*(volatile hw_ocotp_cfg2_t *) HW_OCOTP_CFG2_ADDR)
#define HW_OCOTP_CFG2_RD()      (HW_OCOTP_CFG2.U)
#define HW_OCOTP_CFG2_WR(v)     (HW_OCOTP_CFG2.U = (v))
#define HW_OCOTP_CFG2_SET(v)    (HW_OCOTP_CFG2_WR(HW_OCOTP_CFG2_RD() |  (v)))
#define HW_OCOTP_CFG2_CLR(v)    (HW_OCOTP_CFG2_WR(HW_OCOTP_CFG2_RD() & ~(v)))
#define HW_OCOTP_CFG2_TOG(v)    (HW_OCOTP_CFG2_WR(HW_OCOTP_CFG2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG2 bitfields
 */

/*! @name Register OCOTP_CFG2, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 0, word 3 (ADDR = 0x03). These bits become read-only after the
 * HW_OCOTP_LOCK_TESTER[1] bit is set.
 */
//@{
#define BP_OCOTP_CFG2_BITS      (0)      //!< Bit position for OCOTP_CFG2_BITS.
#define BM_OCOTP_CFG2_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG2_BITS.

//! @brief Get value of OCOTP_CFG2_BITS from a register value.
#define BG_OCOTP_CFG2_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG2_BITS) >> BP_OCOTP_CFG2_BITS)

//! @brief Format value for bitfield OCOTP_CFG2_BITS.
#define BF_OCOTP_CFG2_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG2_BITS) & BM_OCOTP_CFG2_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG2_BITS(v)   (HW_OCOTP_CFG2_WR((HW_OCOTP_CFG2_RD() & ~BM_OCOTP_CFG2_BITS) | BF_OCOTP_CFG2_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG3 - Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG3 - Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Non-shadowed memory mapped access to OTP Bank 0, word 4 (ADDR =
 * 0x04). EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg3
{
    reg32_t U;
    struct _hw_ocotp_cfg3_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 0, word 4 (ADDR = 0x04).
    } B;
} hw_ocotp_cfg3_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG3 register
 */
//@{
#define HW_OCOTP_CFG3_ADDR      (REGS_OCOTP_BASE + 0x440)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG3           (*(volatile hw_ocotp_cfg3_t *) HW_OCOTP_CFG3_ADDR)
#define HW_OCOTP_CFG3_RD()      (HW_OCOTP_CFG3.U)
#define HW_OCOTP_CFG3_WR(v)     (HW_OCOTP_CFG3.U = (v))
#define HW_OCOTP_CFG3_SET(v)    (HW_OCOTP_CFG3_WR(HW_OCOTP_CFG3_RD() |  (v)))
#define HW_OCOTP_CFG3_CLR(v)    (HW_OCOTP_CFG3_WR(HW_OCOTP_CFG3_RD() & ~(v)))
#define HW_OCOTP_CFG3_TOG(v)    (HW_OCOTP_CFG3_WR(HW_OCOTP_CFG3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG3 bitfields
 */

/*! @name Register OCOTP_CFG3, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 0, word 4 (ADDR = 0x04). These bits become read-only after the
 * HW_OCOTP_LOCK_TESTER[1] bit is set.
 */
//@{
#define BP_OCOTP_CFG3_BITS      (0)      //!< Bit position for OCOTP_CFG3_BITS.
#define BM_OCOTP_CFG3_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG3_BITS.

//! @brief Get value of OCOTP_CFG3_BITS from a register value.
#define BG_OCOTP_CFG3_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG3_BITS) >> BP_OCOTP_CFG3_BITS)

//! @brief Format value for bitfield OCOTP_CFG3_BITS.
#define BF_OCOTP_CFG3_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG3_BITS) & BM_OCOTP_CFG3_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG3_BITS(v)   (HW_OCOTP_CFG3_WR((HW_OCOTP_CFG3_RD() & ~BM_OCOTP_CFG3_BITS) | BF_OCOTP_CFG3_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG4 - Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG4 - Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 5 (ADDR = 0x05).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg4
{
    reg32_t U;
    struct _hw_ocotp_cfg4_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 0, word 5 (ADDR = 0x05).
    } B;
} hw_ocotp_cfg4_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG4 register
 */
//@{
#define HW_OCOTP_CFG4_ADDR      (REGS_OCOTP_BASE + 0x450)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG4           (*(volatile hw_ocotp_cfg4_t *) HW_OCOTP_CFG4_ADDR)
#define HW_OCOTP_CFG4_RD()      (HW_OCOTP_CFG4.U)
#define HW_OCOTP_CFG4_WR(v)     (HW_OCOTP_CFG4.U = (v))
#define HW_OCOTP_CFG4_SET(v)    (HW_OCOTP_CFG4_WR(HW_OCOTP_CFG4_RD() |  (v)))
#define HW_OCOTP_CFG4_CLR(v)    (HW_OCOTP_CFG4_WR(HW_OCOTP_CFG4_RD() & ~(v)))
#define HW_OCOTP_CFG4_TOG(v)    (HW_OCOTP_CFG4_WR(HW_OCOTP_CFG4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG4 bitfields
 */

/*! @name Register OCOTP_CFG4, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 0, word 5 (ADDR = 0x05). These bits become read-only after the
 * HW_OCOTP_LOCK_BOOT_CFG[1] bit is set.
 */
//@{
#define BP_OCOTP_CFG4_BITS      (0)      //!< Bit position for OCOTP_CFG4_BITS.
#define BM_OCOTP_CFG4_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG4_BITS.

//! @brief Get value of OCOTP_CFG4_BITS from a register value.
#define BG_OCOTP_CFG4_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG4_BITS) >> BP_OCOTP_CFG4_BITS)

//! @brief Format value for bitfield OCOTP_CFG4_BITS.
#define BF_OCOTP_CFG4_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG4_BITS) & BM_OCOTP_CFG4_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG4_BITS(v)   (HW_OCOTP_CFG4_WR((HW_OCOTP_CFG4_RD() & ~BM_OCOTP_CFG4_BITS) | BF_OCOTP_CFG4_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG5 - Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG5 - Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 6 (ADDR = 0x06).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg5
{
    reg32_t U;
    struct _hw_ocotp_cfg5_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 0, word 6 (ADDR = 0x06).
    } B;
} hw_ocotp_cfg5_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG5 register
 */
//@{
#define HW_OCOTP_CFG5_ADDR      (REGS_OCOTP_BASE + 0x460)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG5           (*(volatile hw_ocotp_cfg5_t *) HW_OCOTP_CFG5_ADDR)
#define HW_OCOTP_CFG5_RD()      (HW_OCOTP_CFG5.U)
#define HW_OCOTP_CFG5_WR(v)     (HW_OCOTP_CFG5.U = (v))
#define HW_OCOTP_CFG5_SET(v)    (HW_OCOTP_CFG5_WR(HW_OCOTP_CFG5_RD() |  (v)))
#define HW_OCOTP_CFG5_CLR(v)    (HW_OCOTP_CFG5_WR(HW_OCOTP_CFG5_RD() & ~(v)))
#define HW_OCOTP_CFG5_TOG(v)    (HW_OCOTP_CFG5_WR(HW_OCOTP_CFG5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG5 bitfields
 */

/*! @name Register OCOTP_CFG5, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 0, word 6 (ADDR = 0x06). These bits become read-only after the
 * HW_OCOTP_LOCK_BOOT_CFG[1] bit is set.
 */
//@{
#define BP_OCOTP_CFG5_BITS      (0)      //!< Bit position for OCOTP_CFG5_BITS.
#define BM_OCOTP_CFG5_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG5_BITS.

//! @brief Get value of OCOTP_CFG5_BITS from a register value.
#define BG_OCOTP_CFG5_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG5_BITS) >> BP_OCOTP_CFG5_BITS)

//! @brief Format value for bitfield OCOTP_CFG5_BITS.
#define BF_OCOTP_CFG5_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG5_BITS) & BM_OCOTP_CFG5_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG5_BITS(v)   (HW_OCOTP_CFG5_WR((HW_OCOTP_CFG5_RD() & ~BM_OCOTP_CFG5_BITS) | BF_OCOTP_CFG5_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_CFG6 - Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_CFG6 - Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 0, word 7 (ADDR = 0x07).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_cfg6
{
    reg32_t U;
    struct _hw_ocotp_cfg6_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 0, word 7 (ADDR = 0x07).
    } B;
} hw_ocotp_cfg6_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_CFG6 register
 */
//@{
#define HW_OCOTP_CFG6_ADDR      (REGS_OCOTP_BASE + 0x470)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_CFG6           (*(volatile hw_ocotp_cfg6_t *) HW_OCOTP_CFG6_ADDR)
#define HW_OCOTP_CFG6_RD()      (HW_OCOTP_CFG6.U)
#define HW_OCOTP_CFG6_WR(v)     (HW_OCOTP_CFG6.U = (v))
#define HW_OCOTP_CFG6_SET(v)    (HW_OCOTP_CFG6_WR(HW_OCOTP_CFG6_RD() |  (v)))
#define HW_OCOTP_CFG6_CLR(v)    (HW_OCOTP_CFG6_WR(HW_OCOTP_CFG6_RD() & ~(v)))
#define HW_OCOTP_CFG6_TOG(v)    (HW_OCOTP_CFG6_WR(HW_OCOTP_CFG6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_CFG6 bitfields
 */

/*! @name Register OCOTP_CFG6, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 0, word 7 (ADDR = 0x07). These bits become read-only after the
 * HW_OCOTP_LOCK_BOOT_CFG[1] bit is set.
 */
//@{
#define BP_OCOTP_CFG6_BITS      (0)      //!< Bit position for OCOTP_CFG6_BITS.
#define BM_OCOTP_CFG6_BITS      (0xffffffff)  //!< Bit mask for OCOTP_CFG6_BITS.

//! @brief Get value of OCOTP_CFG6_BITS from a register value.
#define BG_OCOTP_CFG6_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_CFG6_BITS) >> BP_OCOTP_CFG6_BITS)

//! @brief Format value for bitfield OCOTP_CFG6_BITS.
#define BF_OCOTP_CFG6_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_CFG6_BITS) & BM_OCOTP_CFG6_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_CFG6_BITS(v)   (HW_OCOTP_CFG6_WR((HW_OCOTP_CFG6_RD() & ~BM_OCOTP_CFG6_BITS) | BF_OCOTP_CFG6_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MEM0 - Value of OTP Bank1 Word0 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MEM0 - Value of OTP Bank1 Word0 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 0 (ADDR = 0x08).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mem0
{
    reg32_t U;
    struct _hw_ocotp_mem0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 0 (ADDR = 0x08).
    } B;
} hw_ocotp_mem0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MEM0 register
 */
//@{
#define HW_OCOTP_MEM0_ADDR      (REGS_OCOTP_BASE + 0x480)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MEM0           (*(volatile hw_ocotp_mem0_t *) HW_OCOTP_MEM0_ADDR)
#define HW_OCOTP_MEM0_RD()      (HW_OCOTP_MEM0.U)
#define HW_OCOTP_MEM0_WR(v)     (HW_OCOTP_MEM0.U = (v))
#define HW_OCOTP_MEM0_SET(v)    (HW_OCOTP_MEM0_WR(HW_OCOTP_MEM0_RD() |  (v)))
#define HW_OCOTP_MEM0_CLR(v)    (HW_OCOTP_MEM0_WR(HW_OCOTP_MEM0_RD() & ~(v)))
#define HW_OCOTP_MEM0_TOG(v)    (HW_OCOTP_MEM0_WR(HW_OCOTP_MEM0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MEM0 bitfields
 */

/*! @name Register OCOTP_MEM0, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 0 (ADDR = 0x08). These bits become read-only after the
 * HW_OCOTP_LOCK_MEM_TRIM[1] bit is set.
 */
//@{
#define BP_OCOTP_MEM0_BITS      (0)      //!< Bit position for OCOTP_MEM0_BITS.
#define BM_OCOTP_MEM0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MEM0_BITS.

//! @brief Get value of OCOTP_MEM0_BITS from a register value.
#define BG_OCOTP_MEM0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MEM0_BITS) >> BP_OCOTP_MEM0_BITS)

//! @brief Format value for bitfield OCOTP_MEM0_BITS.
#define BF_OCOTP_MEM0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MEM0_BITS) & BM_OCOTP_MEM0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MEM0_BITS(v)   (HW_OCOTP_MEM0_WR((HW_OCOTP_MEM0_RD() & ~BM_OCOTP_MEM0_BITS) | BF_OCOTP_MEM0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MEM1 - Value of OTP Bank1 Word1 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MEM1 - Value of OTP Bank1 Word1 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 1 (ADDR = 0x09).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mem1
{
    reg32_t U;
    struct _hw_ocotp_mem1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 1 (ADDR = 0x09).
    } B;
} hw_ocotp_mem1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MEM1 register
 */
//@{
#define HW_OCOTP_MEM1_ADDR      (REGS_OCOTP_BASE + 0x490)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MEM1           (*(volatile hw_ocotp_mem1_t *) HW_OCOTP_MEM1_ADDR)
#define HW_OCOTP_MEM1_RD()      (HW_OCOTP_MEM1.U)
#define HW_OCOTP_MEM1_WR(v)     (HW_OCOTP_MEM1.U = (v))
#define HW_OCOTP_MEM1_SET(v)    (HW_OCOTP_MEM1_WR(HW_OCOTP_MEM1_RD() |  (v)))
#define HW_OCOTP_MEM1_CLR(v)    (HW_OCOTP_MEM1_WR(HW_OCOTP_MEM1_RD() & ~(v)))
#define HW_OCOTP_MEM1_TOG(v)    (HW_OCOTP_MEM1_WR(HW_OCOTP_MEM1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MEM1 bitfields
 */

/*! @name Register OCOTP_MEM1, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 1 (ADDR = 0x09). These bits become read-only after the
 * HW_OCOTP_LOCK_MEM_TRIM[1] bit is set.
 */
//@{
#define BP_OCOTP_MEM1_BITS      (0)      //!< Bit position for OCOTP_MEM1_BITS.
#define BM_OCOTP_MEM1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MEM1_BITS.

//! @brief Get value of OCOTP_MEM1_BITS from a register value.
#define BG_OCOTP_MEM1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MEM1_BITS) >> BP_OCOTP_MEM1_BITS)

//! @brief Format value for bitfield OCOTP_MEM1_BITS.
#define BF_OCOTP_MEM1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MEM1_BITS) & BM_OCOTP_MEM1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MEM1_BITS(v)   (HW_OCOTP_MEM1_WR((HW_OCOTP_MEM1_RD() & ~BM_OCOTP_MEM1_BITS) | BF_OCOTP_MEM1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MEM2 - Value of OTP Bank1 Word2 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MEM2 - Value of OTP Bank1 Word2 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 2 (ADDR = 0x0A).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mem2
{
    reg32_t U;
    struct _hw_ocotp_mem2_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 2 (ADDR = 0x0A).
    } B;
} hw_ocotp_mem2_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MEM2 register
 */
//@{
#define HW_OCOTP_MEM2_ADDR      (REGS_OCOTP_BASE + 0x4a0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MEM2           (*(volatile hw_ocotp_mem2_t *) HW_OCOTP_MEM2_ADDR)
#define HW_OCOTP_MEM2_RD()      (HW_OCOTP_MEM2.U)
#define HW_OCOTP_MEM2_WR(v)     (HW_OCOTP_MEM2.U = (v))
#define HW_OCOTP_MEM2_SET(v)    (HW_OCOTP_MEM2_WR(HW_OCOTP_MEM2_RD() |  (v)))
#define HW_OCOTP_MEM2_CLR(v)    (HW_OCOTP_MEM2_WR(HW_OCOTP_MEM2_RD() & ~(v)))
#define HW_OCOTP_MEM2_TOG(v)    (HW_OCOTP_MEM2_WR(HW_OCOTP_MEM2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MEM2 bitfields
 */

/*! @name Register OCOTP_MEM2, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 2 (ADDR = 0x0A). These bits become read-only after the
 * HW_OCOTP_LOCK_MEM_TRIM[1] bit is set.
 */
//@{
#define BP_OCOTP_MEM2_BITS      (0)      //!< Bit position for OCOTP_MEM2_BITS.
#define BM_OCOTP_MEM2_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MEM2_BITS.

//! @brief Get value of OCOTP_MEM2_BITS from a register value.
#define BG_OCOTP_MEM2_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MEM2_BITS) >> BP_OCOTP_MEM2_BITS)

//! @brief Format value for bitfield OCOTP_MEM2_BITS.
#define BF_OCOTP_MEM2_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MEM2_BITS) & BM_OCOTP_MEM2_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MEM2_BITS(v)   (HW_OCOTP_MEM2_WR((HW_OCOTP_MEM2_RD() & ~BM_OCOTP_MEM2_BITS) | BF_OCOTP_MEM2_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MEM3 - Value of OTP Bank1 Word3 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MEM3 - Value of OTP Bank1 Word3 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 3 (ADDR = 0x0B).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mem3
{
    reg32_t U;
    struct _hw_ocotp_mem3_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 3 (ADDR = 0x0B).
    } B;
} hw_ocotp_mem3_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MEM3 register
 */
//@{
#define HW_OCOTP_MEM3_ADDR      (REGS_OCOTP_BASE + 0x4b0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MEM3           (*(volatile hw_ocotp_mem3_t *) HW_OCOTP_MEM3_ADDR)
#define HW_OCOTP_MEM3_RD()      (HW_OCOTP_MEM3.U)
#define HW_OCOTP_MEM3_WR(v)     (HW_OCOTP_MEM3.U = (v))
#define HW_OCOTP_MEM3_SET(v)    (HW_OCOTP_MEM3_WR(HW_OCOTP_MEM3_RD() |  (v)))
#define HW_OCOTP_MEM3_CLR(v)    (HW_OCOTP_MEM3_WR(HW_OCOTP_MEM3_RD() & ~(v)))
#define HW_OCOTP_MEM3_TOG(v)    (HW_OCOTP_MEM3_WR(HW_OCOTP_MEM3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MEM3 bitfields
 */

/*! @name Register OCOTP_MEM3, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 3 (ADDR = 0x0B). These bits become read-only after the
 * HW_OCOTP_LOCK_MEM_TRIM[1] bit is set.
 */
//@{
#define BP_OCOTP_MEM3_BITS      (0)      //!< Bit position for OCOTP_MEM3_BITS.
#define BM_OCOTP_MEM3_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MEM3_BITS.

//! @brief Get value of OCOTP_MEM3_BITS from a register value.
#define BG_OCOTP_MEM3_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MEM3_BITS) >> BP_OCOTP_MEM3_BITS)

//! @brief Format value for bitfield OCOTP_MEM3_BITS.
#define BF_OCOTP_MEM3_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MEM3_BITS) & BM_OCOTP_MEM3_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MEM3_BITS(v)   (HW_OCOTP_MEM3_WR((HW_OCOTP_MEM3_RD() & ~BM_OCOTP_MEM3_BITS) | BF_OCOTP_MEM3_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MEM4 - Value of OTP Bank1 Word4 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MEM4 - Value of OTP Bank1 Word4 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 4 (ADDR = 0x0C).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mem4
{
    reg32_t U;
    struct _hw_ocotp_mem4_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 4 (ADDR = 0x0C).
    } B;
} hw_ocotp_mem4_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MEM4 register
 */
//@{
#define HW_OCOTP_MEM4_ADDR      (REGS_OCOTP_BASE + 0x4c0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MEM4           (*(volatile hw_ocotp_mem4_t *) HW_OCOTP_MEM4_ADDR)
#define HW_OCOTP_MEM4_RD()      (HW_OCOTP_MEM4.U)
#define HW_OCOTP_MEM4_WR(v)     (HW_OCOTP_MEM4.U = (v))
#define HW_OCOTP_MEM4_SET(v)    (HW_OCOTP_MEM4_WR(HW_OCOTP_MEM4_RD() |  (v)))
#define HW_OCOTP_MEM4_CLR(v)    (HW_OCOTP_MEM4_WR(HW_OCOTP_MEM4_RD() & ~(v)))
#define HW_OCOTP_MEM4_TOG(v)    (HW_OCOTP_MEM4_WR(HW_OCOTP_MEM4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MEM4 bitfields
 */

/*! @name Register OCOTP_MEM4, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 4 (ADDR = 0x0C). These bits become read-only after the
 * HW_OCOTP_LOCK_MEM_TRIM[1] bit is set.
 */
//@{
#define BP_OCOTP_MEM4_BITS      (0)      //!< Bit position for OCOTP_MEM4_BITS.
#define BM_OCOTP_MEM4_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MEM4_BITS.

//! @brief Get value of OCOTP_MEM4_BITS from a register value.
#define BG_OCOTP_MEM4_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MEM4_BITS) >> BP_OCOTP_MEM4_BITS)

//! @brief Format value for bitfield OCOTP_MEM4_BITS.
#define BF_OCOTP_MEM4_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MEM4_BITS) & BM_OCOTP_MEM4_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MEM4_BITS(v)   (HW_OCOTP_MEM4_WR((HW_OCOTP_MEM4_RD() & ~BM_OCOTP_MEM4_BITS) | BF_OCOTP_MEM4_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_ANA0 - Value of OTP Bank1 Word5 (Memory Related Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_ANA0 - Value of OTP Bank1 Word5 (Memory Related Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 5 (ADDR = 0x0D).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_ana0
{
    reg32_t U;
    struct _hw_ocotp_ana0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 5 (ADDR = 0x0D).
    } B;
} hw_ocotp_ana0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_ANA0 register
 */
//@{
#define HW_OCOTP_ANA0_ADDR      (REGS_OCOTP_BASE + 0x4d0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_ANA0           (*(volatile hw_ocotp_ana0_t *) HW_OCOTP_ANA0_ADDR)
#define HW_OCOTP_ANA0_RD()      (HW_OCOTP_ANA0.U)
#define HW_OCOTP_ANA0_WR(v)     (HW_OCOTP_ANA0.U = (v))
#define HW_OCOTP_ANA0_SET(v)    (HW_OCOTP_ANA0_WR(HW_OCOTP_ANA0_RD() |  (v)))
#define HW_OCOTP_ANA0_CLR(v)    (HW_OCOTP_ANA0_WR(HW_OCOTP_ANA0_RD() & ~(v)))
#define HW_OCOTP_ANA0_TOG(v)    (HW_OCOTP_ANA0_WR(HW_OCOTP_ANA0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_ANA0 bitfields
 */

/*! @name Register OCOTP_ANA0, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 5 (ADDR = 0x0D). These bits become read-only after the
 * HW_OCOTP_LOCK_ANALOG[1] bit is set.
 */
//@{
#define BP_OCOTP_ANA0_BITS      (0)      //!< Bit position for OCOTP_ANA0_BITS.
#define BM_OCOTP_ANA0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_ANA0_BITS.

//! @brief Get value of OCOTP_ANA0_BITS from a register value.
#define BG_OCOTP_ANA0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_ANA0_BITS) >> BP_OCOTP_ANA0_BITS)

//! @brief Format value for bitfield OCOTP_ANA0_BITS.
#define BF_OCOTP_ANA0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_ANA0_BITS) & BM_OCOTP_ANA0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_ANA0_BITS(v)   (HW_OCOTP_ANA0_WR((HW_OCOTP_ANA0_RD() & ~BM_OCOTP_ANA0_BITS) | BF_OCOTP_ANA0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_ANA1 - Value of OTP Bank1 Word6 (General Purpose Customer Defined Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_ANA1 - Value of OTP Bank1 Word6 (General Purpose Customer Defined Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 6 (ADDR = 0x0E).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_ana1
{
    reg32_t U;
    struct _hw_ocotp_ana1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 6 (ADDR = 0x0E).
    } B;
} hw_ocotp_ana1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_ANA1 register
 */
//@{
#define HW_OCOTP_ANA1_ADDR      (REGS_OCOTP_BASE + 0x4e0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_ANA1           (*(volatile hw_ocotp_ana1_t *) HW_OCOTP_ANA1_ADDR)
#define HW_OCOTP_ANA1_RD()      (HW_OCOTP_ANA1.U)
#define HW_OCOTP_ANA1_WR(v)     (HW_OCOTP_ANA1.U = (v))
#define HW_OCOTP_ANA1_SET(v)    (HW_OCOTP_ANA1_WR(HW_OCOTP_ANA1_RD() |  (v)))
#define HW_OCOTP_ANA1_CLR(v)    (HW_OCOTP_ANA1_WR(HW_OCOTP_ANA1_RD() & ~(v)))
#define HW_OCOTP_ANA1_TOG(v)    (HW_OCOTP_ANA1_WR(HW_OCOTP_ANA1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_ANA1 bitfields
 */

/*! @name Register OCOTP_ANA1, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 6 (ADDR = 0x0E). These bits become read-only after the
 * HW_OCOTP_LOCK_ANALOG[1] bit is set.
 */
//@{
#define BP_OCOTP_ANA1_BITS      (0)      //!< Bit position for OCOTP_ANA1_BITS.
#define BM_OCOTP_ANA1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_ANA1_BITS.

//! @brief Get value of OCOTP_ANA1_BITS from a register value.
#define BG_OCOTP_ANA1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_ANA1_BITS) >> BP_OCOTP_ANA1_BITS)

//! @brief Format value for bitfield OCOTP_ANA1_BITS.
#define BF_OCOTP_ANA1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_ANA1_BITS) & BM_OCOTP_ANA1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_ANA1_BITS(v)   (HW_OCOTP_ANA1_WR((HW_OCOTP_ANA1_RD() & ~BM_OCOTP_ANA1_BITS) | BF_OCOTP_ANA1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_ANA2 - Value of OTP Bank1 Word7 (General Purpose Customer Defined Info.)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_ANA2 - Value of OTP Bank1 Word7 (General Purpose Customer Defined Info.) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP bank 1, word 7 (ADDR = 0x0F).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_ana2
{
    reg32_t U;
    struct _hw_ocotp_ana2_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP bank 1, word 7 (ADDR = 0x0F).
    } B;
} hw_ocotp_ana2_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_ANA2 register
 */
//@{
#define HW_OCOTP_ANA2_ADDR      (REGS_OCOTP_BASE + 0x4f0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_ANA2           (*(volatile hw_ocotp_ana2_t *) HW_OCOTP_ANA2_ADDR)
#define HW_OCOTP_ANA2_RD()      (HW_OCOTP_ANA2.U)
#define HW_OCOTP_ANA2_WR(v)     (HW_OCOTP_ANA2.U = (v))
#define HW_OCOTP_ANA2_SET(v)    (HW_OCOTP_ANA2_WR(HW_OCOTP_ANA2_RD() |  (v)))
#define HW_OCOTP_ANA2_CLR(v)    (HW_OCOTP_ANA2_WR(HW_OCOTP_ANA2_RD() & ~(v)))
#define HW_OCOTP_ANA2_TOG(v)    (HW_OCOTP_ANA2_WR(HW_OCOTP_ANA2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_ANA2 bitfields
 */

/*! @name Register OCOTP_ANA2, field BITS[31:0] (RW)
 *
 * Reflects value of OTP bank 1, word 7 (ADDR = 0x0F). These bits become read-only after the
 * HW_OCOTP_LOCK_ANALOG[1] bit is set.
 */
//@{
#define BP_OCOTP_ANA2_BITS      (0)      //!< Bit position for OCOTP_ANA2_BITS.
#define BM_OCOTP_ANA2_BITS      (0xffffffff)  //!< Bit mask for OCOTP_ANA2_BITS.

//! @brief Get value of OCOTP_ANA2_BITS from a register value.
#define BG_OCOTP_ANA2_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_ANA2_BITS) >> BP_OCOTP_ANA2_BITS)

//! @brief Format value for bitfield OCOTP_ANA2_BITS.
#define BF_OCOTP_ANA2_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_ANA2_BITS) & BM_OCOTP_ANA2_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_ANA2_BITS(v)   (HW_OCOTP_ANA2_WR((HW_OCOTP_ANA2_RD() & ~BM_OCOTP_ANA2_BITS) | BF_OCOTP_ANA2_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK0 - Shadow Register for OTP Bank3 Word0 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK0 - Shadow Register for OTP Bank3 Word0 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 0 (ADDR = 0x18).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk0
{
    reg32_t U;
    struct _hw_ocotp_srk0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word0 (Copy of OTP Bank 3, word 0 (ADDR = 0x1C)).
    } B;
} hw_ocotp_srk0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK0 register
 */
//@{
#define HW_OCOTP_SRK0_ADDR      (REGS_OCOTP_BASE + 0x580)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK0           (*(volatile hw_ocotp_srk0_t *) HW_OCOTP_SRK0_ADDR)
#define HW_OCOTP_SRK0_RD()      (HW_OCOTP_SRK0.U)
#define HW_OCOTP_SRK0_WR(v)     (HW_OCOTP_SRK0.U = (v))
#define HW_OCOTP_SRK0_SET(v)    (HW_OCOTP_SRK0_WR(HW_OCOTP_SRK0_RD() |  (v)))
#define HW_OCOTP_SRK0_CLR(v)    (HW_OCOTP_SRK0_WR(HW_OCOTP_SRK0_RD() & ~(v)))
#define HW_OCOTP_SRK0_TOG(v)    (HW_OCOTP_SRK0_WR(HW_OCOTP_SRK0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK0 bitfields
 */

/*! @name Register OCOTP_SRK0, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word0 (Copy of OTP Bank 3, word 0 (ADDR =
 * 0x1C)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK0_BITS      (0)      //!< Bit position for OCOTP_SRK0_BITS.
#define BM_OCOTP_SRK0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK0_BITS.

//! @brief Get value of OCOTP_SRK0_BITS from a register value.
#define BG_OCOTP_SRK0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK0_BITS) >> BP_OCOTP_SRK0_BITS)

//! @brief Format value for bitfield OCOTP_SRK0_BITS.
#define BF_OCOTP_SRK0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK0_BITS) & BM_OCOTP_SRK0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK0_BITS(v)   (HW_OCOTP_SRK0_WR((HW_OCOTP_SRK0_RD() & ~BM_OCOTP_SRK0_BITS) | BF_OCOTP_SRK0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK1 - Shadow Register for OTP Bank3 Word1 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK1 - Shadow Register for OTP Bank3 Word1 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 1 (ADDR = 0x19).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk1
{
    reg32_t U;
    struct _hw_ocotp_srk1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word1 (Copy of OTP Bank 3, word 1 (ADDR = 0x1D)).
    } B;
} hw_ocotp_srk1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK1 register
 */
//@{
#define HW_OCOTP_SRK1_ADDR      (REGS_OCOTP_BASE + 0x590)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK1           (*(volatile hw_ocotp_srk1_t *) HW_OCOTP_SRK1_ADDR)
#define HW_OCOTP_SRK1_RD()      (HW_OCOTP_SRK1.U)
#define HW_OCOTP_SRK1_WR(v)     (HW_OCOTP_SRK1.U = (v))
#define HW_OCOTP_SRK1_SET(v)    (HW_OCOTP_SRK1_WR(HW_OCOTP_SRK1_RD() |  (v)))
#define HW_OCOTP_SRK1_CLR(v)    (HW_OCOTP_SRK1_WR(HW_OCOTP_SRK1_RD() & ~(v)))
#define HW_OCOTP_SRK1_TOG(v)    (HW_OCOTP_SRK1_WR(HW_OCOTP_SRK1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK1 bitfields
 */

/*! @name Register OCOTP_SRK1, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word1 (Copy of OTP Bank 3, word 1 (ADDR =
 * 0x1D)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK1_BITS      (0)      //!< Bit position for OCOTP_SRK1_BITS.
#define BM_OCOTP_SRK1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK1_BITS.

//! @brief Get value of OCOTP_SRK1_BITS from a register value.
#define BG_OCOTP_SRK1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK1_BITS) >> BP_OCOTP_SRK1_BITS)

//! @brief Format value for bitfield OCOTP_SRK1_BITS.
#define BF_OCOTP_SRK1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK1_BITS) & BM_OCOTP_SRK1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK1_BITS(v)   (HW_OCOTP_SRK1_WR((HW_OCOTP_SRK1_RD() & ~BM_OCOTP_SRK1_BITS) | BF_OCOTP_SRK1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK2 - Shadow Register for OTP Bank3 Word2 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK2 - Shadow Register for OTP Bank3 Word2 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 2 (ADDR = 0x1A).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk2
{
    reg32_t U;
    struct _hw_ocotp_srk2_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word2 (Copy of OTP Bank 3, word 2 (ADDR = 0x1E)).
    } B;
} hw_ocotp_srk2_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK2 register
 */
//@{
#define HW_OCOTP_SRK2_ADDR      (REGS_OCOTP_BASE + 0x5a0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK2           (*(volatile hw_ocotp_srk2_t *) HW_OCOTP_SRK2_ADDR)
#define HW_OCOTP_SRK2_RD()      (HW_OCOTP_SRK2.U)
#define HW_OCOTP_SRK2_WR(v)     (HW_OCOTP_SRK2.U = (v))
#define HW_OCOTP_SRK2_SET(v)    (HW_OCOTP_SRK2_WR(HW_OCOTP_SRK2_RD() |  (v)))
#define HW_OCOTP_SRK2_CLR(v)    (HW_OCOTP_SRK2_WR(HW_OCOTP_SRK2_RD() & ~(v)))
#define HW_OCOTP_SRK2_TOG(v)    (HW_OCOTP_SRK2_WR(HW_OCOTP_SRK2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK2 bitfields
 */

/*! @name Register OCOTP_SRK2, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word2 (Copy of OTP Bank 3, word 2 (ADDR =
 * 0x1E)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK2_BITS      (0)      //!< Bit position for OCOTP_SRK2_BITS.
#define BM_OCOTP_SRK2_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK2_BITS.

//! @brief Get value of OCOTP_SRK2_BITS from a register value.
#define BG_OCOTP_SRK2_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK2_BITS) >> BP_OCOTP_SRK2_BITS)

//! @brief Format value for bitfield OCOTP_SRK2_BITS.
#define BF_OCOTP_SRK2_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK2_BITS) & BM_OCOTP_SRK2_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK2_BITS(v)   (HW_OCOTP_SRK2_WR((HW_OCOTP_SRK2_RD() & ~BM_OCOTP_SRK2_BITS) | BF_OCOTP_SRK2_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK3 - Shadow Register for OTP Bank3 Word3 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK3 - Shadow Register for OTP Bank3 Word3 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 3 (ADDR = 0x1B).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk3
{
    reg32_t U;
    struct _hw_ocotp_srk3_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word3 (Copy of OTP Bank 3, word 3 (ADDR = 0x1F)).
    } B;
} hw_ocotp_srk3_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK3 register
 */
//@{
#define HW_OCOTP_SRK3_ADDR      (REGS_OCOTP_BASE + 0x5b0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK3           (*(volatile hw_ocotp_srk3_t *) HW_OCOTP_SRK3_ADDR)
#define HW_OCOTP_SRK3_RD()      (HW_OCOTP_SRK3.U)
#define HW_OCOTP_SRK3_WR(v)     (HW_OCOTP_SRK3.U = (v))
#define HW_OCOTP_SRK3_SET(v)    (HW_OCOTP_SRK3_WR(HW_OCOTP_SRK3_RD() |  (v)))
#define HW_OCOTP_SRK3_CLR(v)    (HW_OCOTP_SRK3_WR(HW_OCOTP_SRK3_RD() & ~(v)))
#define HW_OCOTP_SRK3_TOG(v)    (HW_OCOTP_SRK3_WR(HW_OCOTP_SRK3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK3 bitfields
 */

/*! @name Register OCOTP_SRK3, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word3 (Copy of OTP Bank 3, word 3 (ADDR =
 * 0x1F)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK3_BITS      (0)      //!< Bit position for OCOTP_SRK3_BITS.
#define BM_OCOTP_SRK3_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK3_BITS.

//! @brief Get value of OCOTP_SRK3_BITS from a register value.
#define BG_OCOTP_SRK3_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK3_BITS) >> BP_OCOTP_SRK3_BITS)

//! @brief Format value for bitfield OCOTP_SRK3_BITS.
#define BF_OCOTP_SRK3_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK3_BITS) & BM_OCOTP_SRK3_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK3_BITS(v)   (HW_OCOTP_SRK3_WR((HW_OCOTP_SRK3_RD() & ~BM_OCOTP_SRK3_BITS) | BF_OCOTP_SRK3_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK4 - Shadow Register for OTP Bank3 Word4 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK4 - Shadow Register for OTP Bank3 Word4 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 4 (ADDR = 0x1C).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk4
{
    reg32_t U;
    struct _hw_ocotp_srk4_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word4 (Copy of OTP Bank 3, word 4 (ADDR = 0x20)).
    } B;
} hw_ocotp_srk4_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK4 register
 */
//@{
#define HW_OCOTP_SRK4_ADDR      (REGS_OCOTP_BASE + 0x5c0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK4           (*(volatile hw_ocotp_srk4_t *) HW_OCOTP_SRK4_ADDR)
#define HW_OCOTP_SRK4_RD()      (HW_OCOTP_SRK4.U)
#define HW_OCOTP_SRK4_WR(v)     (HW_OCOTP_SRK4.U = (v))
#define HW_OCOTP_SRK4_SET(v)    (HW_OCOTP_SRK4_WR(HW_OCOTP_SRK4_RD() |  (v)))
#define HW_OCOTP_SRK4_CLR(v)    (HW_OCOTP_SRK4_WR(HW_OCOTP_SRK4_RD() & ~(v)))
#define HW_OCOTP_SRK4_TOG(v)    (HW_OCOTP_SRK4_WR(HW_OCOTP_SRK4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK4 bitfields
 */

/*! @name Register OCOTP_SRK4, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word4 (Copy of OTP Bank 3, word 4 (ADDR =
 * 0x20)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK4_BITS      (0)      //!< Bit position for OCOTP_SRK4_BITS.
#define BM_OCOTP_SRK4_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK4_BITS.

//! @brief Get value of OCOTP_SRK4_BITS from a register value.
#define BG_OCOTP_SRK4_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK4_BITS) >> BP_OCOTP_SRK4_BITS)

//! @brief Format value for bitfield OCOTP_SRK4_BITS.
#define BF_OCOTP_SRK4_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK4_BITS) & BM_OCOTP_SRK4_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK4_BITS(v)   (HW_OCOTP_SRK4_WR((HW_OCOTP_SRK4_RD() & ~BM_OCOTP_SRK4_BITS) | BF_OCOTP_SRK4_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK5 - Shadow Register for OTP Bank3 Word5 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK5 - Shadow Register for OTP Bank3 Word5 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 5 (ADDR = 0x1D).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk5
{
    reg32_t U;
    struct _hw_ocotp_srk5_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word5 (Copy of OTP Bank 3, word 5 (ADDR = 0x21)).
    } B;
} hw_ocotp_srk5_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK5 register
 */
//@{
#define HW_OCOTP_SRK5_ADDR      (REGS_OCOTP_BASE + 0x5d0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK5           (*(volatile hw_ocotp_srk5_t *) HW_OCOTP_SRK5_ADDR)
#define HW_OCOTP_SRK5_RD()      (HW_OCOTP_SRK5.U)
#define HW_OCOTP_SRK5_WR(v)     (HW_OCOTP_SRK5.U = (v))
#define HW_OCOTP_SRK5_SET(v)    (HW_OCOTP_SRK5_WR(HW_OCOTP_SRK5_RD() |  (v)))
#define HW_OCOTP_SRK5_CLR(v)    (HW_OCOTP_SRK5_WR(HW_OCOTP_SRK5_RD() & ~(v)))
#define HW_OCOTP_SRK5_TOG(v)    (HW_OCOTP_SRK5_WR(HW_OCOTP_SRK5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK5 bitfields
 */

/*! @name Register OCOTP_SRK5, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word5 (Copy of OTP Bank 3, word 5 (ADDR =
 * 0x21)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK5_BITS      (0)      //!< Bit position for OCOTP_SRK5_BITS.
#define BM_OCOTP_SRK5_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK5_BITS.

//! @brief Get value of OCOTP_SRK5_BITS from a register value.
#define BG_OCOTP_SRK5_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK5_BITS) >> BP_OCOTP_SRK5_BITS)

//! @brief Format value for bitfield OCOTP_SRK5_BITS.
#define BF_OCOTP_SRK5_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK5_BITS) & BM_OCOTP_SRK5_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK5_BITS(v)   (HW_OCOTP_SRK5_WR((HW_OCOTP_SRK5_RD() & ~BM_OCOTP_SRK5_BITS) | BF_OCOTP_SRK5_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK6 - Shadow Register for OTP Bank3 Word6 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK6 - Shadow Register for OTP Bank3 Word6 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 6 (ADDR = 0x1E).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk6
{
    reg32_t U;
    struct _hw_ocotp_srk6_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word6 (Copy of OTP Bank 3, word 6 (ADDR = 0x22)).
    } B;
} hw_ocotp_srk6_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK6 register
 */
//@{
#define HW_OCOTP_SRK6_ADDR      (REGS_OCOTP_BASE + 0x5e0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK6           (*(volatile hw_ocotp_srk6_t *) HW_OCOTP_SRK6_ADDR)
#define HW_OCOTP_SRK6_RD()      (HW_OCOTP_SRK6.U)
#define HW_OCOTP_SRK6_WR(v)     (HW_OCOTP_SRK6.U = (v))
#define HW_OCOTP_SRK6_SET(v)    (HW_OCOTP_SRK6_WR(HW_OCOTP_SRK6_RD() |  (v)))
#define HW_OCOTP_SRK6_CLR(v)    (HW_OCOTP_SRK6_WR(HW_OCOTP_SRK6_RD() & ~(v)))
#define HW_OCOTP_SRK6_TOG(v)    (HW_OCOTP_SRK6_WR(HW_OCOTP_SRK6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK6 bitfields
 */

/*! @name Register OCOTP_SRK6, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word6 (Copy of OTP Bank 3, word 6 (ADDR =
 * 0x22)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK6_BITS      (0)      //!< Bit position for OCOTP_SRK6_BITS.
#define BM_OCOTP_SRK6_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK6_BITS.

//! @brief Get value of OCOTP_SRK6_BITS from a register value.
#define BG_OCOTP_SRK6_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK6_BITS) >> BP_OCOTP_SRK6_BITS)

//! @brief Format value for bitfield OCOTP_SRK6_BITS.
#define BF_OCOTP_SRK6_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK6_BITS) & BM_OCOTP_SRK6_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK6_BITS(v)   (HW_OCOTP_SRK6_WR((HW_OCOTP_SRK6_RD() & ~BM_OCOTP_SRK6_BITS) | BF_OCOTP_SRK6_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK7 - Shadow Register for OTP Bank3 Word7 (SRK Hash)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK7 - Shadow Register for OTP Bank3 Word7 (SRK Hash) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS]. Shadowed memory mapped access to OTP Bank 3, word 7 (ADDR = 0x1F).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk7
{
    reg32_t U;
    struct _hw_ocotp_srk7_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the hash of the Super Root Key word7 (Copy of OTP Bank 3, word 7 (ADDR = 0x23)).
    } B;
} hw_ocotp_srk7_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK7 register
 */
//@{
#define HW_OCOTP_SRK7_ADDR      (REGS_OCOTP_BASE + 0x5f0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK7           (*(volatile hw_ocotp_srk7_t *) HW_OCOTP_SRK7_ADDR)
#define HW_OCOTP_SRK7_RD()      (HW_OCOTP_SRK7.U)
#define HW_OCOTP_SRK7_WR(v)     (HW_OCOTP_SRK7.U = (v))
#define HW_OCOTP_SRK7_SET(v)    (HW_OCOTP_SRK7_WR(HW_OCOTP_SRK7_RD() |  (v)))
#define HW_OCOTP_SRK7_CLR(v)    (HW_OCOTP_SRK7_WR(HW_OCOTP_SRK7_RD() & ~(v)))
#define HW_OCOTP_SRK7_TOG(v)    (HW_OCOTP_SRK7_WR(HW_OCOTP_SRK7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK7 bitfields
 */

/*! @name Register OCOTP_SRK7, field BITS[31:0] (RW)
 *
 * Shadow register for the hash of the Super Root Key word7 (Copy of OTP Bank 3, word 7 (ADDR =
 * 0x23)). These bits become read-only after the HW_OCOTP_LOCK_SRK bit is set.
 */
//@{
#define BP_OCOTP_SRK7_BITS      (0)      //!< Bit position for OCOTP_SRK7_BITS.
#define BM_OCOTP_SRK7_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK7_BITS.

//! @brief Get value of OCOTP_SRK7_BITS from a register value.
#define BG_OCOTP_SRK7_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK7_BITS) >> BP_OCOTP_SRK7_BITS)

//! @brief Format value for bitfield OCOTP_SRK7_BITS.
#define BF_OCOTP_SRK7_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK7_BITS) & BM_OCOTP_SRK7_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK7_BITS(v)   (HW_OCOTP_SRK7_WR((HW_OCOTP_SRK7_RD() & ~BM_OCOTP_SRK7_BITS) | BF_OCOTP_SRK7_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_RESP0 - Value of OTP Bank4 Word0 (Secure JTAG Response Field)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_RESP0 - Value of OTP Bank4 Word0 (Secure JTAG Response Field) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 0 (ADDR = 0x20).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_resp0
{
    reg32_t U;
    struct _hw_ocotp_resp0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the SJC_RESP Key word0 (Copy of OTP Bank 4, word 0 (ADDR = 0x20)).
    } B;
} hw_ocotp_resp0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_RESP0 register
 */
//@{
#define HW_OCOTP_RESP0_ADDR      (REGS_OCOTP_BASE + 0x600)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_RESP0           (*(volatile hw_ocotp_resp0_t *) HW_OCOTP_RESP0_ADDR)
#define HW_OCOTP_RESP0_RD()      (HW_OCOTP_RESP0.U)
#define HW_OCOTP_RESP0_WR(v)     (HW_OCOTP_RESP0.U = (v))
#define HW_OCOTP_RESP0_SET(v)    (HW_OCOTP_RESP0_WR(HW_OCOTP_RESP0_RD() |  (v)))
#define HW_OCOTP_RESP0_CLR(v)    (HW_OCOTP_RESP0_WR(HW_OCOTP_RESP0_RD() & ~(v)))
#define HW_OCOTP_RESP0_TOG(v)    (HW_OCOTP_RESP0_WR(HW_OCOTP_RESP0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_RESP0 bitfields
 */

/*! @name Register OCOTP_RESP0, field BITS[31:0] (RW)
 *
 * Shadow register for the SJC_RESP Key word0 (Copy of OTP Bank 4, word 0 (ADDR = 0x20)). These bits
 * can be not read and wrotten after the HW_OCOTP_LOCK_SJC_RESP bit is set. If read, returns
 * 0xBADA_BADA and sets HW_OCOTP_CTRL[ERROR].
 */
//@{
#define BP_OCOTP_RESP0_BITS      (0)      //!< Bit position for OCOTP_RESP0_BITS.
#define BM_OCOTP_RESP0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_RESP0_BITS.

//! @brief Get value of OCOTP_RESP0_BITS from a register value.
#define BG_OCOTP_RESP0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_RESP0_BITS) >> BP_OCOTP_RESP0_BITS)

//! @brief Format value for bitfield OCOTP_RESP0_BITS.
#define BF_OCOTP_RESP0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_RESP0_BITS) & BM_OCOTP_RESP0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_RESP0_BITS(v)   (HW_OCOTP_RESP0_WR((HW_OCOTP_RESP0_RD() & ~BM_OCOTP_RESP0_BITS) | BF_OCOTP_RESP0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_HSJC_RESP1 - Value of OTP Bank4 Word1 (Secure JTAG Response Field)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_HSJC_RESP1 - Value of OTP Bank4 Word1 (Secure JTAG Response Field) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 1 (ADDR = 0x21).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_hsjc_resp1
{
    reg32_t U;
    struct _hw_ocotp_hsjc_resp1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Shadow register for the SJC_RESP Key word1 (Copy of OTP Bank 4, word 1 (ADDR = 0x21)).
    } B;
} hw_ocotp_hsjc_resp1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_HSJC_RESP1 register
 */
//@{
#define HW_OCOTP_HSJC_RESP1_ADDR      (REGS_OCOTP_BASE + 0x610)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_HSJC_RESP1           (*(volatile hw_ocotp_hsjc_resp1_t *) HW_OCOTP_HSJC_RESP1_ADDR)
#define HW_OCOTP_HSJC_RESP1_RD()      (HW_OCOTP_HSJC_RESP1.U)
#define HW_OCOTP_HSJC_RESP1_WR(v)     (HW_OCOTP_HSJC_RESP1.U = (v))
#define HW_OCOTP_HSJC_RESP1_SET(v)    (HW_OCOTP_HSJC_RESP1_WR(HW_OCOTP_HSJC_RESP1_RD() |  (v)))
#define HW_OCOTP_HSJC_RESP1_CLR(v)    (HW_OCOTP_HSJC_RESP1_WR(HW_OCOTP_HSJC_RESP1_RD() & ~(v)))
#define HW_OCOTP_HSJC_RESP1_TOG(v)    (HW_OCOTP_HSJC_RESP1_WR(HW_OCOTP_HSJC_RESP1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_HSJC_RESP1 bitfields
 */

/*! @name Register OCOTP_HSJC_RESP1, field BITS[31:0] (RW)
 *
 * Shadow register for the SJC_RESP Key word1 (Copy of OTP Bank 4, word 1 (ADDR = 0x21)). These bits
 * can be not read and wrotten after the HW_OCOTP_LOCK_SJC_RESP bit is set. If read, returns
 * 0xBADA_BADA and sets HW_OCOTP_CTRL[ERROR].
 */
//@{
#define BP_OCOTP_HSJC_RESP1_BITS      (0)      //!< Bit position for OCOTP_HSJC_RESP1_BITS.
#define BM_OCOTP_HSJC_RESP1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_HSJC_RESP1_BITS.

//! @brief Get value of OCOTP_HSJC_RESP1_BITS from a register value.
#define BG_OCOTP_HSJC_RESP1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_HSJC_RESP1_BITS) >> BP_OCOTP_HSJC_RESP1_BITS)

//! @brief Format value for bitfield OCOTP_HSJC_RESP1_BITS.
#define BF_OCOTP_HSJC_RESP1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_HSJC_RESP1_BITS) & BM_OCOTP_HSJC_RESP1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_HSJC_RESP1_BITS(v)   (HW_OCOTP_HSJC_RESP1_WR((HW_OCOTP_HSJC_RESP1_RD() & ~BM_OCOTP_HSJC_RESP1_BITS) | BF_OCOTP_HSJC_RESP1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MAC0 - Value of OTP Bank4 Word2 (MAC Address)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MAC0 - Value of OTP Bank4 Word2 (MAC Address) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 2 (ADDR = 0x22).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mac0
{
    reg32_t U;
    struct _hw_ocotp_mac0_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 4, word 2 (ADDR = 0x22).
    } B;
} hw_ocotp_mac0_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MAC0 register
 */
//@{
#define HW_OCOTP_MAC0_ADDR      (REGS_OCOTP_BASE + 0x620)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MAC0           (*(volatile hw_ocotp_mac0_t *) HW_OCOTP_MAC0_ADDR)
#define HW_OCOTP_MAC0_RD()      (HW_OCOTP_MAC0.U)
#define HW_OCOTP_MAC0_WR(v)     (HW_OCOTP_MAC0.U = (v))
#define HW_OCOTP_MAC0_SET(v)    (HW_OCOTP_MAC0_WR(HW_OCOTP_MAC0_RD() |  (v)))
#define HW_OCOTP_MAC0_CLR(v)    (HW_OCOTP_MAC0_WR(HW_OCOTP_MAC0_RD() & ~(v)))
#define HW_OCOTP_MAC0_TOG(v)    (HW_OCOTP_MAC0_WR(HW_OCOTP_MAC0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MAC0 bitfields
 */

/*! @name Register OCOTP_MAC0, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 4, word 2 (ADDR = 0x22).
 */
//@{
#define BP_OCOTP_MAC0_BITS      (0)      //!< Bit position for OCOTP_MAC0_BITS.
#define BM_OCOTP_MAC0_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MAC0_BITS.

//! @brief Get value of OCOTP_MAC0_BITS from a register value.
#define BG_OCOTP_MAC0_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MAC0_BITS) >> BP_OCOTP_MAC0_BITS)

//! @brief Format value for bitfield OCOTP_MAC0_BITS.
#define BF_OCOTP_MAC0_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MAC0_BITS) & BM_OCOTP_MAC0_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MAC0_BITS(v)   (HW_OCOTP_MAC0_WR((HW_OCOTP_MAC0_RD() & ~BM_OCOTP_MAC0_BITS) | BF_OCOTP_MAC0_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MAC1 - Value of OTP Bank4 Word3 (MAC Address)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MAC1 - Value of OTP Bank4 Word3 (MAC Address) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 3 (ADDR = 0x23).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_mac1
{
    reg32_t U;
    struct _hw_ocotp_mac1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 4, word 3 (ADDR = 0x23).
    } B;
} hw_ocotp_mac1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MAC1 register
 */
//@{
#define HW_OCOTP_MAC1_ADDR      (REGS_OCOTP_BASE + 0x630)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MAC1           (*(volatile hw_ocotp_mac1_t *) HW_OCOTP_MAC1_ADDR)
#define HW_OCOTP_MAC1_RD()      (HW_OCOTP_MAC1.U)
#define HW_OCOTP_MAC1_WR(v)     (HW_OCOTP_MAC1.U = (v))
#define HW_OCOTP_MAC1_SET(v)    (HW_OCOTP_MAC1_WR(HW_OCOTP_MAC1_RD() |  (v)))
#define HW_OCOTP_MAC1_CLR(v)    (HW_OCOTP_MAC1_WR(HW_OCOTP_MAC1_RD() & ~(v)))
#define HW_OCOTP_MAC1_TOG(v)    (HW_OCOTP_MAC1_WR(HW_OCOTP_MAC1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MAC1 bitfields
 */

/*! @name Register OCOTP_MAC1, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 4, word 3 (ADDR = 0x23).
 */
//@{
#define BP_OCOTP_MAC1_BITS      (0)      //!< Bit position for OCOTP_MAC1_BITS.
#define BM_OCOTP_MAC1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MAC1_BITS.

//! @brief Get value of OCOTP_MAC1_BITS from a register value.
#define BG_OCOTP_MAC1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MAC1_BITS) >> BP_OCOTP_MAC1_BITS)

//! @brief Format value for bitfield OCOTP_MAC1_BITS.
#define BF_OCOTP_MAC1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MAC1_BITS) & BM_OCOTP_MAC1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MAC1_BITS(v)   (HW_OCOTP_MAC1_WR((HW_OCOTP_MAC1_RD() & ~BM_OCOTP_MAC1_BITS) | BF_OCOTP_MAC1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_GP1 - Value of OTP Bank4 Word6 (HW Capabilities)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_GP1 - Value of OTP Bank4 Word6 (HW Capabilities) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 6 (ADDR = 0x26).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_gp1
{
    reg32_t U;
    struct _hw_ocotp_gp1_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 4, word 6 (ADDR = 0x26).
    } B;
} hw_ocotp_gp1_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_GP1 register
 */
//@{
#define HW_OCOTP_GP1_ADDR      (REGS_OCOTP_BASE + 0x660)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_GP1           (*(volatile hw_ocotp_gp1_t *) HW_OCOTP_GP1_ADDR)
#define HW_OCOTP_GP1_RD()      (HW_OCOTP_GP1.U)
#define HW_OCOTP_GP1_WR(v)     (HW_OCOTP_GP1.U = (v))
#define HW_OCOTP_GP1_SET(v)    (HW_OCOTP_GP1_WR(HW_OCOTP_GP1_RD() |  (v)))
#define HW_OCOTP_GP1_CLR(v)    (HW_OCOTP_GP1_WR(HW_OCOTP_GP1_RD() & ~(v)))
#define HW_OCOTP_GP1_TOG(v)    (HW_OCOTP_GP1_WR(HW_OCOTP_GP1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_GP1 bitfields
 */

/*! @name Register OCOTP_GP1, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 4, word 6 (ADDR = 0x26).
 */
//@{
#define BP_OCOTP_GP1_BITS      (0)      //!< Bit position for OCOTP_GP1_BITS.
#define BM_OCOTP_GP1_BITS      (0xffffffff)  //!< Bit mask for OCOTP_GP1_BITS.

//! @brief Get value of OCOTP_GP1_BITS from a register value.
#define BG_OCOTP_GP1_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_GP1_BITS) >> BP_OCOTP_GP1_BITS)

//! @brief Format value for bitfield OCOTP_GP1_BITS.
#define BF_OCOTP_GP1_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_GP1_BITS) & BM_OCOTP_GP1_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_GP1_BITS(v)   (HW_OCOTP_GP1_WR((HW_OCOTP_GP1_RD() & ~BM_OCOTP_GP1_BITS) | BF_OCOTP_GP1_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_GP2 - Value of OTP Bank4 Word7 (HW Capabilities)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_GP2 - Value of OTP Bank4 Word7 (HW Capabilities) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 4, word 7 (ADDR = 0x27).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_gp2
{
    reg32_t U;
    struct _hw_ocotp_gp2_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 4, word 7 (ADDR = 0x27).
    } B;
} hw_ocotp_gp2_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_GP2 register
 */
//@{
#define HW_OCOTP_GP2_ADDR      (REGS_OCOTP_BASE + 0x670)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_GP2           (*(volatile hw_ocotp_gp2_t *) HW_OCOTP_GP2_ADDR)
#define HW_OCOTP_GP2_RD()      (HW_OCOTP_GP2.U)
#define HW_OCOTP_GP2_WR(v)     (HW_OCOTP_GP2.U = (v))
#define HW_OCOTP_GP2_SET(v)    (HW_OCOTP_GP2_WR(HW_OCOTP_GP2_RD() |  (v)))
#define HW_OCOTP_GP2_CLR(v)    (HW_OCOTP_GP2_WR(HW_OCOTP_GP2_RD() & ~(v)))
#define HW_OCOTP_GP2_TOG(v)    (HW_OCOTP_GP2_WR(HW_OCOTP_GP2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_GP2 bitfields
 */

/*! @name Register OCOTP_GP2, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 4, word 7 (ADDR = 0x27).
 */
//@{
#define BP_OCOTP_GP2_BITS      (0)      //!< Bit position for OCOTP_GP2_BITS.
#define BM_OCOTP_GP2_BITS      (0xffffffff)  //!< Bit mask for OCOTP_GP2_BITS.

//! @brief Get value of OCOTP_GP2_BITS from a register value.
#define BG_OCOTP_GP2_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_GP2_BITS) >> BP_OCOTP_GP2_BITS)

//! @brief Format value for bitfield OCOTP_GP2_BITS.
#define BF_OCOTP_GP2_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_GP2_BITS) & BM_OCOTP_GP2_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_GP2_BITS(v)   (HW_OCOTP_GP2_WR((HW_OCOTP_GP2_RD() & ~BM_OCOTP_GP2_BITS) | BF_OCOTP_GP2_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_MISC_CONF - Value of OTP Bank5 Word5 (HW Capabilities)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_MISC_CONF - Value of OTP Bank5 Word5 (HW Capabilities) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 5, word 5 (ADDR = 0x2d).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_misc_conf
{
    reg32_t U;
    struct _hw_ocotp_misc_conf_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 5, word 5 (ADDR = 0x2d).
    } B;
} hw_ocotp_misc_conf_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_MISC_CONF register
 */
//@{
#define HW_OCOTP_MISC_CONF_ADDR      (REGS_OCOTP_BASE + 0x6d0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_MISC_CONF           (*(volatile hw_ocotp_misc_conf_t *) HW_OCOTP_MISC_CONF_ADDR)
#define HW_OCOTP_MISC_CONF_RD()      (HW_OCOTP_MISC_CONF.U)
#define HW_OCOTP_MISC_CONF_WR(v)     (HW_OCOTP_MISC_CONF.U = (v))
#define HW_OCOTP_MISC_CONF_SET(v)    (HW_OCOTP_MISC_CONF_WR(HW_OCOTP_MISC_CONF_RD() |  (v)))
#define HW_OCOTP_MISC_CONF_CLR(v)    (HW_OCOTP_MISC_CONF_WR(HW_OCOTP_MISC_CONF_RD() & ~(v)))
#define HW_OCOTP_MISC_CONF_TOG(v)    (HW_OCOTP_MISC_CONF_WR(HW_OCOTP_MISC_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_MISC_CONF bitfields
 */

/*! @name Register OCOTP_MISC_CONF, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 5, word 5 (ADDR = 0x2d).
 */
//@{
#define BP_OCOTP_MISC_CONF_BITS      (0)      //!< Bit position for OCOTP_MISC_CONF_BITS.
#define BM_OCOTP_MISC_CONF_BITS      (0xffffffff)  //!< Bit mask for OCOTP_MISC_CONF_BITS.

//! @brief Get value of OCOTP_MISC_CONF_BITS from a register value.
#define BG_OCOTP_MISC_CONF_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_MISC_CONF_BITS) >> BP_OCOTP_MISC_CONF_BITS)

//! @brief Format value for bitfield OCOTP_MISC_CONF_BITS.
#define BF_OCOTP_MISC_CONF_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_MISC_CONF_BITS) & BM_OCOTP_MISC_CONF_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_MISC_CONF_BITS(v)   (HW_OCOTP_MISC_CONF_WR((HW_OCOTP_MISC_CONF_RD() & ~BM_OCOTP_MISC_CONF_BITS) | BF_OCOTP_MISC_CONF_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_FIELD_RETURN - Value of OTP Bank5 Word6 (HW Capabilities)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_FIELD_RETURN - Value of OTP Bank5 Word6 (HW Capabilities) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 5, word 6 (ADDR = 0x2e).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_field_return
{
    reg32_t U;
    struct _hw_ocotp_field_return_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 5, word 6 (ADDR = 0x2e).
    } B;
} hw_ocotp_field_return_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_FIELD_RETURN register
 */
//@{
#define HW_OCOTP_FIELD_RETURN_ADDR      (REGS_OCOTP_BASE + 0x6e0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_FIELD_RETURN           (*(volatile hw_ocotp_field_return_t *) HW_OCOTP_FIELD_RETURN_ADDR)
#define HW_OCOTP_FIELD_RETURN_RD()      (HW_OCOTP_FIELD_RETURN.U)
#define HW_OCOTP_FIELD_RETURN_WR(v)     (HW_OCOTP_FIELD_RETURN.U = (v))
#define HW_OCOTP_FIELD_RETURN_SET(v)    (HW_OCOTP_FIELD_RETURN_WR(HW_OCOTP_FIELD_RETURN_RD() |  (v)))
#define HW_OCOTP_FIELD_RETURN_CLR(v)    (HW_OCOTP_FIELD_RETURN_WR(HW_OCOTP_FIELD_RETURN_RD() & ~(v)))
#define HW_OCOTP_FIELD_RETURN_TOG(v)    (HW_OCOTP_FIELD_RETURN_WR(HW_OCOTP_FIELD_RETURN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_FIELD_RETURN bitfields
 */

/*! @name Register OCOTP_FIELD_RETURN, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 5, word 6 (ADDR = 0x2e).
 */
//@{
#define BP_OCOTP_FIELD_RETURN_BITS      (0)      //!< Bit position for OCOTP_FIELD_RETURN_BITS.
#define BM_OCOTP_FIELD_RETURN_BITS      (0xffffffff)  //!< Bit mask for OCOTP_FIELD_RETURN_BITS.

//! @brief Get value of OCOTP_FIELD_RETURN_BITS from a register value.
#define BG_OCOTP_FIELD_RETURN_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_FIELD_RETURN_BITS) >> BP_OCOTP_FIELD_RETURN_BITS)

//! @brief Format value for bitfield OCOTP_FIELD_RETURN_BITS.
#define BF_OCOTP_FIELD_RETURN_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_FIELD_RETURN_BITS) & BM_OCOTP_FIELD_RETURN_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_FIELD_RETURN_BITS(v)   (HW_OCOTP_FIELD_RETURN_WR((HW_OCOTP_FIELD_RETURN_RD() & ~BM_OCOTP_FIELD_RETURN_BITS) | BF_OCOTP_FIELD_RETURN_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_OCOTP_SRK_REVOKE - Value of OTP Bank5 Word7 (HW Capabilities)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_OCOTP_SRK_REVOKE - Value of OTP Bank5 Word7 (HW Capabilities) (RW)
 *
 * Reset value: 0x00000000
 *
 * Copied from the OTP automatically after reset. Can be re-loaded by setting
 * HW_OCOTP_CTRL[RELOAD_SHADOWS] Shadowed memory mapped access to OTP Bank 5, word 7 (ADDR = 0x2f).
 * EXAMPLE Empty Example.
 */
typedef union _hw_ocotp_srk_revoke
{
    reg32_t U;
    struct _hw_ocotp_srk_revoke_bitfields
    {
        unsigned BITS : 32; //!< [31:0] Reflects value of OTP Bank 5, word 7 (ADDR = 0x2f).
    } B;
} hw_ocotp_srk_revoke_t;
#endif

/*!
 * @name Constants and macros for entire OCOTP_SRK_REVOKE register
 */
//@{
#define HW_OCOTP_SRK_REVOKE_ADDR      (REGS_OCOTP_BASE + 0x6f0)

#ifndef __LANGUAGE_ASM__
#define HW_OCOTP_SRK_REVOKE           (*(volatile hw_ocotp_srk_revoke_t *) HW_OCOTP_SRK_REVOKE_ADDR)
#define HW_OCOTP_SRK_REVOKE_RD()      (HW_OCOTP_SRK_REVOKE.U)
#define HW_OCOTP_SRK_REVOKE_WR(v)     (HW_OCOTP_SRK_REVOKE.U = (v))
#define HW_OCOTP_SRK_REVOKE_SET(v)    (HW_OCOTP_SRK_REVOKE_WR(HW_OCOTP_SRK_REVOKE_RD() |  (v)))
#define HW_OCOTP_SRK_REVOKE_CLR(v)    (HW_OCOTP_SRK_REVOKE_WR(HW_OCOTP_SRK_REVOKE_RD() & ~(v)))
#define HW_OCOTP_SRK_REVOKE_TOG(v)    (HW_OCOTP_SRK_REVOKE_WR(HW_OCOTP_SRK_REVOKE_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual OCOTP_SRK_REVOKE bitfields
 */

/*! @name Register OCOTP_SRK_REVOKE, field BITS[31:0] (RW)
 *
 * Reflects value of OTP Bank 5, word 7 (ADDR = 0x2f).
 */
//@{
#define BP_OCOTP_SRK_REVOKE_BITS      (0)      //!< Bit position for OCOTP_SRK_REVOKE_BITS.
#define BM_OCOTP_SRK_REVOKE_BITS      (0xffffffff)  //!< Bit mask for OCOTP_SRK_REVOKE_BITS.

//! @brief Get value of OCOTP_SRK_REVOKE_BITS from a register value.
#define BG_OCOTP_SRK_REVOKE_BITS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_OCOTP_SRK_REVOKE_BITS) >> BP_OCOTP_SRK_REVOKE_BITS)

//! @brief Format value for bitfield OCOTP_SRK_REVOKE_BITS.
#define BF_OCOTP_SRK_REVOKE_BITS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_OCOTP_SRK_REVOKE_BITS) & BM_OCOTP_SRK_REVOKE_BITS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BITS field to a new value.
#define BW_OCOTP_SRK_REVOKE_BITS(v)   (HW_OCOTP_SRK_REVOKE_WR((HW_OCOTP_SRK_REVOKE_RD() & ~BM_OCOTP_SRK_REVOKE_BITS) | BF_OCOTP_SRK_REVOKE_BITS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_ocotp_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All OCOTP module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_ocotp
{
    volatile hw_ocotp_ctrl_t CTRL; //!< OTP Controller Control Register
    volatile reg32_t CTRL_SET; //!< OTP Controller Control Register Set
    volatile reg32_t CTRL_CLR; //!< OTP Controller Control Register Clear
    volatile reg32_t CTRL_TOG; //!< OTP Controller Control Register Toggle
    volatile hw_ocotp_timing_t TIMING; //!< OTP Controller Timing Register
    reg32_t _reserved0[3];
    volatile hw_ocotp_data_t DATA; //!< OTP Controller Write Data Register
    reg32_t _reserved1[3];
    volatile hw_ocotp_read_ctrl_t READ_CTRL; //!< OTP Controller Write Data Register
    reg32_t _reserved2[3];
    volatile hw_ocotp_read_fuse_data_t READ_FUSE_DATA; //!< OTP Controller Read Data Register
    reg32_t _reserved3[3];
    volatile hw_ocotp_sw_sticky_t SW_STICKY; //!< Sticky bit Register
    reg32_t _reserved4[3];
    volatile hw_ocotp_scs_t SCS; //!< Software Controllable Signals Register
    volatile reg32_t SCS_SET; //!< Software Controllable Signals Register Set
    volatile reg32_t SCS_CLR; //!< Software Controllable Signals Register Clear
    volatile reg32_t SCS_TOG; //!< Software Controllable Signals Register Toggle
    reg32_t _reserved5[8];
    volatile hw_ocotp_version_t VERSION; //!< OTP Controller Version Register
    reg32_t _reserved6[219];
    volatile hw_ocotp_lock_t LOCK; //!< Value of OTP Bank0 Word0 (Lock controls)
    reg32_t _reserved7[3];
    volatile hw_ocotp_cfg0_t CFG0; //!< Value of OTP Bank0 Word1 (Configuration and Manufacturing Info.)
    reg32_t _reserved8[3];
    volatile hw_ocotp_cfg1_t CFG1; //!< Value of OTP Bank0 Word2 (Configuration and Manufacturing Info.)
    reg32_t _reserved9[3];
    volatile hw_ocotp_cfg2_t CFG2; //!< Value of OTP Bank0 Word3 (Configuration and Manufacturing Info.)
    reg32_t _reserved10[3];
    volatile hw_ocotp_cfg3_t CFG3; //!< Value of OTP Bank0 Word4 (Configuration and Manufacturing Info.)
    reg32_t _reserved11[3];
    volatile hw_ocotp_cfg4_t CFG4; //!< Value of OTP Bank0 Word5 (Configuration and Manufacturing Info.)
    reg32_t _reserved12[3];
    volatile hw_ocotp_cfg5_t CFG5; //!< Value of OTP Bank0 Word6 (Configuration and Manufacturing Info.)
    reg32_t _reserved13[3];
    volatile hw_ocotp_cfg6_t CFG6; //!< Value of OTP Bank0 Word7 (Configuration and Manufacturing Info.)
    reg32_t _reserved14[3];
    volatile hw_ocotp_mem0_t MEM0; //!< Value of OTP Bank1 Word0 (Memory Related Info.)
    reg32_t _reserved15[3];
    volatile hw_ocotp_mem1_t MEM1; //!< Value of OTP Bank1 Word1 (Memory Related Info.)
    reg32_t _reserved16[3];
    volatile hw_ocotp_mem2_t MEM2; //!< Value of OTP Bank1 Word2 (Memory Related Info.)
    reg32_t _reserved17[3];
    volatile hw_ocotp_mem3_t MEM3; //!< Value of OTP Bank1 Word3 (Memory Related Info.)
    reg32_t _reserved18[3];
    volatile hw_ocotp_mem4_t MEM4; //!< Value of OTP Bank1 Word4 (Memory Related Info.)
    reg32_t _reserved19[3];
    volatile hw_ocotp_ana0_t ANA0; //!< Value of OTP Bank1 Word5 (Memory Related Info.)
    reg32_t _reserved20[3];
    volatile hw_ocotp_ana1_t ANA1; //!< Value of OTP Bank1 Word6 (General Purpose Customer Defined Info.)
    reg32_t _reserved21[3];
    volatile hw_ocotp_ana2_t ANA2; //!< Value of OTP Bank1 Word7 (General Purpose Customer Defined Info.)
    reg32_t _reserved22[35];
    volatile hw_ocotp_srk0_t SRK0; //!< Shadow Register for OTP Bank3 Word0 (SRK Hash)
    reg32_t _reserved23[3];
    volatile hw_ocotp_srk1_t SRK1; //!< Shadow Register for OTP Bank3 Word1 (SRK Hash)
    reg32_t _reserved24[3];
    volatile hw_ocotp_srk2_t SRK2; //!< Shadow Register for OTP Bank3 Word2 (SRK Hash)
    reg32_t _reserved25[3];
    volatile hw_ocotp_srk3_t SRK3; //!< Shadow Register for OTP Bank3 Word3 (SRK Hash)
    reg32_t _reserved26[3];
    volatile hw_ocotp_srk4_t SRK4; //!< Shadow Register for OTP Bank3 Word4 (SRK Hash)
    reg32_t _reserved27[3];
    volatile hw_ocotp_srk5_t SRK5; //!< Shadow Register for OTP Bank3 Word5 (SRK Hash)
    reg32_t _reserved28[3];
    volatile hw_ocotp_srk6_t SRK6; //!< Shadow Register for OTP Bank3 Word6 (SRK Hash)
    reg32_t _reserved29[3];
    volatile hw_ocotp_srk7_t SRK7; //!< Shadow Register for OTP Bank3 Word7 (SRK Hash)
    reg32_t _reserved30[3];
    volatile hw_ocotp_resp0_t RESP0; //!< Value of OTP Bank4 Word0 (Secure JTAG Response Field)
    reg32_t _reserved31[3];
    volatile hw_ocotp_hsjc_resp1_t HSJC_RESP1; //!< Value of OTP Bank4 Word1 (Secure JTAG Response Field)
    reg32_t _reserved32[3];
    volatile hw_ocotp_mac0_t MAC0; //!< Value of OTP Bank4 Word2 (MAC Address)
    reg32_t _reserved33[3];
    volatile hw_ocotp_mac1_t MAC1; //!< Value of OTP Bank4 Word3 (MAC Address)
    reg32_t _reserved34[11];
    volatile hw_ocotp_gp1_t GP1; //!< Value of OTP Bank4 Word6 (HW Capabilities)
    reg32_t _reserved35[3];
    volatile hw_ocotp_gp2_t GP2; //!< Value of OTP Bank4 Word7 (HW Capabilities)
    reg32_t _reserved36[23];
    volatile hw_ocotp_misc_conf_t MISC_CONF; //!< Value of OTP Bank5 Word5 (HW Capabilities)
    reg32_t _reserved37[3];
    volatile hw_ocotp_field_return_t FIELD_RETURN; //!< Value of OTP Bank5 Word6 (HW Capabilities)
    reg32_t _reserved38[3];
    volatile hw_ocotp_srk_revoke_t SRK_REVOKE; //!< Value of OTP Bank5 Word7 (HW Capabilities)
} hw_ocotp_t;
#pragma pack()

//! @brief Macro to access all OCOTP registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_OCOTP</code>.
#define HW_OCOTP     (*(hw_ocotp_t *) REGS_OCOTP_BASE)
#endif

#endif // __HW_OCOTP_REGISTERS_H__
// v18/121106/1.2.2
// EOF
