/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MIPI_HSI_REGISTERS_H__
#define __HW_MIPI_HSI_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL MIPI_HSI
 *
 * MIPI HSI Registers
 *
 * Registers defined in this header file:
 * - HW_MIPI_HSI_CTRL - HSI Control Register
 * - HW_MIPI_HSI_TX_CONF - HSI Tx Config Register
 * - HW_MIPI_HSI_RX_CONF - HSI Rx Config Register
 * - HW_MIPI_HSI_CAP - HSI Capability Register
 * - HW_MIPI_HSI_TX_WML0 - HSI Tx Water Mark Level 0 Register
 * - HW_MIPI_HSI_TX_TML1 - HSI Tx Water Mark Level 1 Register
 * - HW_MIPI_HSI_TX_ARB_PRI0 - HSI Tx Arbiter Priority 0 Register
 * - HW_MIPI_HSI_TX_ARB_PRI1 - HSI Tx Arbiter Priority 1 Register
 * - HW_MIPI_HSI_LINE_ST - HSI Line Status Register
 * - HW_MIPI_HSI_ID_BIT - HSI ID Bits Register
 * - HW_MIPI_HSI_FIFO_THR_CONF - Tx and Rx Fif0 Threshold Configuration Register
 * - HW_MIPI_HSI_CH_SFTRST - Tx and Rx Channel Soft Reset Register
 * - HW_MIPI_HSI_IRQSTAT - HSI Interrupt Status Register
 * - HW_MIPI_HSI_IRQSTAT_EN - HSI Interrupt Status Enable Register
 * - HW_MIPI_HSI_IRQSIG_EN - HSI Interrupt Signal Enable Register
 * - HW_MIPI_HSI_FIFO_THR_IRQSTAT - HSI FIFO Threshold Interrupt Status Register
 * - HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN - HSI FIFO Threshold Interrupt Status Enable Register
 * - HW_MIPI_HSI_FIFO_THR_IRQSIG_EN - HSI FIFO Threshold Interrupt Signal Enable Register
 * - HW_MIPI_HSI_TX_CHn_DP - Tx Channel n Data Port Register
 * - HW_MIPI_HSI_RX_CHn_DP - Rx Channel n Data Port Register
 * - HW_MIPI_HSI_ERR_IRQSTAT - HSI Error Interrupt Status Register
 * - HW_MIPI_HSI_ERR_IRQSTAT_EN - HSI Error Interrupt Status Enable Register
 * - HW_MIPI_HSI_ERR_IRQSIG_EN - HSI Error Interrupt Signal Enable Register
 * - HW_MIPI_HSI_TDMAn_CONF - Tx DMA Channel n Configuration Register
 * - HW_MIPI_HSI_RDMAn_CONF - Rx DMA Channel n Configuration Register
 * - HW_MIPI_HSI_TDMAn_STA_ADDR - Tx DMA Channel n Start Address Register
 * - HW_MIPI_HSI_RDMAn_STA_ADDR - Rx DMA Channel n Start Address Register
 * - HW_MIPI_HSI_DMA_IRQSTAT - DMA Interrupt Status Register
 * - HW_MIPI_HSI_DMA_IRQSTAT_EN - DMA Interrupt Enable Register
 * - HW_MIPI_HSI_DMA_IRQSIG_EN - DMA Interrupt Status Signal Enable Register
 * - HW_MIPI_HSI_DMA_ERR_IRQSTAT - DMA Error Interrupt Status Register
 * - HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN - DMA Error Interrupt Enable Register
 * - HW_MIPI_HSI_DMA_ERR_IRQSIG_EN - DMA Error Interrupt Signal Enable Register
 * - HW_MIPI_HSI_DMA_SINGLE_REQ_EN - DMA Single Request Enable Register
 * - HW_MIPI_HSI_TX_FIFO_SIZE_CONF0 - Tx Fifo Size Configuration Register 0
 * - HW_MIPI_HSI_TX_FIFO_SIZE_CONF1 - Tx Fifo Size Configuration Register 1
 * - HW_MIPI_HSI_RX_FIFO_SIZE_CONF0 - Rx Fifo Size Configuration Register 0
 * - HW_MIPI_HSI_RX_FIFO_SIZE_CONF1 - Rx Fifo Size Configuration Register 1
 * - HW_MIPI_HSI_TX_FIFO_STAT - Tx Fifo Status Register
 * - HW_MIPI_HSI_RX_FIFO_STAT - Rx Fifo Status Register
 * - HW_MIPI_HSI_AHB_MASTER_CONF - Ahb Master Config Register
 * - HW_MIPI_HSI_TX_BREAK_LEN - TX Break Length Register
 *
 * - hw_mipi_hsi_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_MIPI_HSI_BASE
#define HW_MIPI_HSI_INSTANCE_COUNT (1) //!< Number of instances of the MIPI_HSI module.
#define REGS_MIPI_HSI_BASE (0x02208000) //!< Base address for MIPI_HSI.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_CTRL - HSI Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_CTRL - HSI Control Register (RW)
 *
 * Reset value: 0xc8000000
 *
 * This register contains module soft reset, clock gating, clock divisor and so on.
 */
typedef union _hw_mipi_hsi_ctrl
{
    reg32_t U;
    struct _hw_mipi_hsi_ctrl_bitfields
    {
        unsigned TX_CLK_DIVISOR : 4; //!< [3:0] This register holds the divisor of the base clock (tx_refclk) frequency for HSI Tx clock (internal clock used to drive Transmitter interface).
        unsigned TX_BREAK : 1; //!< [4] Seeting this bit to one trigger a transmission break at HSI Tx.
        unsigned RESERVED0 : 3; //!< [7:5] Reserved.
        unsigned DATA_TIMEOUT_CNT : 4; //!< [11:8] This value determines the interval by which DATA timeouts are detected.
        unsigned RX_TAIL_BIT_CNT : 2; //!< [13:12] The value determines the length of the Tailing bit counter.
        unsigned RESERVED1 : 2; //!< [15:14] Reserved.
        unsigned RX_FRAME_BRST_CNT : 8; //!< [23:16] This value is to limit the continous Frame transmission count in Pipelined Data flow.
        unsigned RX_DLY_SEL : 3; //!< [26:24] These values denote the tap delay values for reception of data and flag.
        unsigned DMA_DISABLE : 1; //!< [27] This bit must be set to zero for any DMA operation.
        unsigned RESERVED2 : 2; //!< [29:28] Reserved, always set to zero.
        unsigned CLKGATE : 1; //!< [30] This bit must be set to zero for normal operation.
        unsigned SFTRST : 1; //!< [31] Set this bit to zero to enable normal HSI operation.
    } B;
} hw_mipi_hsi_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_CTRL register
 */
//@{
#define HW_MIPI_HSI_CTRL_ADDR      (REGS_MIPI_HSI_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_CTRL           (*(volatile hw_mipi_hsi_ctrl_t *) HW_MIPI_HSI_CTRL_ADDR)
#define HW_MIPI_HSI_CTRL_RD()      (HW_MIPI_HSI_CTRL.U)
#define HW_MIPI_HSI_CTRL_WR(v)     (HW_MIPI_HSI_CTRL.U = (v))
#define HW_MIPI_HSI_CTRL_SET(v)    (HW_MIPI_HSI_CTRL_WR(HW_MIPI_HSI_CTRL_RD() |  (v)))
#define HW_MIPI_HSI_CTRL_CLR(v)    (HW_MIPI_HSI_CTRL_WR(HW_MIPI_HSI_CTRL_RD() & ~(v)))
#define HW_MIPI_HSI_CTRL_TOG(v)    (HW_MIPI_HSI_CTRL_WR(HW_MIPI_HSI_CTRL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_CTRL bitfields
 */

/*! @name Register MIPI_HSI_CTRL, field TX_CLK_DIVISOR[3:0] (RW)
 *
 * This register holds the divisor of the base clock (tx_refclk) frequency for HSI Tx clock
 * (internal clock used to drive Transmitter interface).
 *
 * Values:
 * - 0000 - tx_refclk divided by 1
 * - 0001 - tx_refclk divided by 2
 * - 0010 - tx_refclk divided by 4
 * - 0011 - tx_refclk divided by 8
 * - 0100 - tx_refclk divided by 16
 * - 0101 - tx_refclkdivided by 32
 * - 0110 - tx_refclk divided by 64
 * - 0111 - tx_refclk divided by 128
 * - 1000 - tx_refclk divided by 256
 */
//@{
#define BP_MIPI_HSI_CTRL_TX_CLK_DIVISOR      (0)      //!< Bit position for MIPI_HSI_CTRL_TX_CLK_DIVISOR.
#define BM_MIPI_HSI_CTRL_TX_CLK_DIVISOR      (0x0000000f)  //!< Bit mask for MIPI_HSI_CTRL_TX_CLK_DIVISOR.

//! @brief Get value of MIPI_HSI_CTRL_TX_CLK_DIVISOR from a register value.
#define BG_MIPI_HSI_CTRL_TX_CLK_DIVISOR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_TX_CLK_DIVISOR) >> BP_MIPI_HSI_CTRL_TX_CLK_DIVISOR)

//! @brief Format value for bitfield MIPI_HSI_CTRL_TX_CLK_DIVISOR.
#define BF_MIPI_HSI_CTRL_TX_CLK_DIVISOR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_TX_CLK_DIVISOR) & BM_MIPI_HSI_CTRL_TX_CLK_DIVISOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CLK_DIVISOR field to a new value.
#define BW_MIPI_HSI_CTRL_TX_CLK_DIVISOR(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_TX_CLK_DIVISOR) | BF_MIPI_HSI_CTRL_TX_CLK_DIVISOR(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field TX_BREAK[4] (RW)
 *
 * Seeting this bit to one trigger a transmission break at HSI Tx. Once this bit is set to one, the
 * HSI controller will send a serise zeros on HSI_TX_DATA port according to the tx break co unt. It
 * will be automatically cleared, when the send is finished.
 */
//@{
#define BP_MIPI_HSI_CTRL_TX_BREAK      (4)      //!< Bit position for MIPI_HSI_CTRL_TX_BREAK.
#define BM_MIPI_HSI_CTRL_TX_BREAK      (0x00000010)  //!< Bit mask for MIPI_HSI_CTRL_TX_BREAK.

//! @brief Get value of MIPI_HSI_CTRL_TX_BREAK from a register value.
#define BG_MIPI_HSI_CTRL_TX_BREAK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_TX_BREAK) >> BP_MIPI_HSI_CTRL_TX_BREAK)

//! @brief Format value for bitfield MIPI_HSI_CTRL_TX_BREAK.
#define BF_MIPI_HSI_CTRL_TX_BREAK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_TX_BREAK) & BM_MIPI_HSI_CTRL_TX_BREAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_BREAK field to a new value.
#define BW_MIPI_HSI_CTRL_TX_BREAK(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_TX_BREAK) | BF_MIPI_HSI_CTRL_TX_BREAK(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field DATA_TIMEOUT_CNT[11:8] (RW)
 *
 * This value determines the interval by which DATA timeouts are detected. This data timeout counter
 * logic is used only for Receive operations. The counter should start counting when data in any of
 * the RX channel fifo is less than the threshold value and resets to zero when there is a threshold
 * reached interrupt from any of the RX buffers. The counter value should be zero, when RX fifo is
 * empty. An interrupt will be asserted to the host driver, when the counter value reaches the data
 * timeout counter value.
 *
 * Values:
 * - 0000 - HSI Tx Clock x 2 ^ 13
 * - 0001 - HSI Tx Clock x 2 ^ 14
 * - 1110 - HSI Tx Clock x 2 ^ 27
 */
//@{
#define BP_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT      (8)      //!< Bit position for MIPI_HSI_CTRL_DATA_TIMEOUT_CNT.
#define BM_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT      (0x00000f00)  //!< Bit mask for MIPI_HSI_CTRL_DATA_TIMEOUT_CNT.

//! @brief Get value of MIPI_HSI_CTRL_DATA_TIMEOUT_CNT from a register value.
#define BG_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT) >> BP_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT)

//! @brief Format value for bitfield MIPI_HSI_CTRL_DATA_TIMEOUT_CNT.
#define BF_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT) & BM_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_TIMEOUT_CNT field to a new value.
#define BW_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT) | BF_MIPI_HSI_CTRL_DATA_TIMEOUT_CNT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field RX_TAIL_BIT_CNT[13:12] (RW)
 *
 * The value determines the length of the Tailing bit counter. The receiver shall start Receiver
 * Tailing bit counter after the nth frame programmed in Rx Frame Burst counter is received. The
 * receiver shall then drive ready to logic one if the receiver Tailing-bit counter has completed
 * with no errors detected, and the receiver has enough room for at least one new frame.
 *
 * Values:
 * - 00 - 800-> tx_refclk
 * - 01 - 400-> tx_refclk
 * - 10 - 200-> tx_refclk
 * - 11 - 100-> tx_refclk
 */
//@{
#define BP_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT      (12)      //!< Bit position for MIPI_HSI_CTRL_RX_TAIL_BIT_CNT.
#define BM_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT      (0x00003000)  //!< Bit mask for MIPI_HSI_CTRL_RX_TAIL_BIT_CNT.

//! @brief Get value of MIPI_HSI_CTRL_RX_TAIL_BIT_CNT from a register value.
#define BG_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT) >> BP_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT)

//! @brief Format value for bitfield MIPI_HSI_CTRL_RX_TAIL_BIT_CNT.
#define BF_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT) & BM_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_TAIL_BIT_CNT field to a new value.
#define BW_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT) | BF_MIPI_HSI_CTRL_RX_TAIL_BIT_CNT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field RX_FRAME_BRST_CNT[23:16] (RW)
 *
 * This value is to limit the continous Frame transmission count in Pipelined Data flow. The
 * Receiver Frame Burst counter shall be able to support upto 256 frames of continous transfer.
 * 7'h00 256 frames transmission count is set. 7'h01 1 frames transmission count is set. 7'h02 2
 * frames transmission count is set. 7'hff 255 frames transmission count is set.
 */
//@{
#define BP_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT      (16)      //!< Bit position for MIPI_HSI_CTRL_RX_FRAME_BRST_CNT.
#define BM_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT      (0x00ff0000)  //!< Bit mask for MIPI_HSI_CTRL_RX_FRAME_BRST_CNT.

//! @brief Get value of MIPI_HSI_CTRL_RX_FRAME_BRST_CNT from a register value.
#define BG_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT) >> BP_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT)

//! @brief Format value for bitfield MIPI_HSI_CTRL_RX_FRAME_BRST_CNT.
#define BF_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT) & BM_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_FRAME_BRST_CNT field to a new value.
#define BW_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT) | BF_MIPI_HSI_CTRL_RX_FRAME_BRST_CNT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field RX_DLY_SEL[26:24] (RW)
 *
 * These values denote the tap delay values for reception of data and flag.
 *
 * Values:
 * - 000 - 0ns ;
 * - 001 - 1ns ;
 * - 010 - 2ns ;
 * - 011 - 3ns ;
 * - 100 - 4ns ;
 * - 101 - 5ns ;
 * - 110 - 6ns ;
 * - 111 - 7ns ;
 */
//@{
#define BP_MIPI_HSI_CTRL_RX_DLY_SEL      (24)      //!< Bit position for MIPI_HSI_CTRL_RX_DLY_SEL.
#define BM_MIPI_HSI_CTRL_RX_DLY_SEL      (0x07000000)  //!< Bit mask for MIPI_HSI_CTRL_RX_DLY_SEL.

//! @brief Get value of MIPI_HSI_CTRL_RX_DLY_SEL from a register value.
#define BG_MIPI_HSI_CTRL_RX_DLY_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_RX_DLY_SEL) >> BP_MIPI_HSI_CTRL_RX_DLY_SEL)

//! @brief Format value for bitfield MIPI_HSI_CTRL_RX_DLY_SEL.
#define BF_MIPI_HSI_CTRL_RX_DLY_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_RX_DLY_SEL) & BM_MIPI_HSI_CTRL_RX_DLY_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_DLY_SEL field to a new value.
#define BW_MIPI_HSI_CTRL_RX_DLY_SEL(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_RX_DLY_SEL) | BF_MIPI_HSI_CTRL_RX_DLY_SEL(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field DMA_DISABLE[27] (RW)
 *
 * This bit must be set to zero for any DMA operation. When set to one it disabel all the DMA
 * channels.
 */
//@{
#define BP_MIPI_HSI_CTRL_DMA_DISABLE      (27)      //!< Bit position for MIPI_HSI_CTRL_DMA_DISABLE.
#define BM_MIPI_HSI_CTRL_DMA_DISABLE      (0x08000000)  //!< Bit mask for MIPI_HSI_CTRL_DMA_DISABLE.

//! @brief Get value of MIPI_HSI_CTRL_DMA_DISABLE from a register value.
#define BG_MIPI_HSI_CTRL_DMA_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_DMA_DISABLE) >> BP_MIPI_HSI_CTRL_DMA_DISABLE)

//! @brief Format value for bitfield MIPI_HSI_CTRL_DMA_DISABLE.
#define BF_MIPI_HSI_CTRL_DMA_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_DMA_DISABLE) & BM_MIPI_HSI_CTRL_DMA_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_DISABLE field to a new value.
#define BW_MIPI_HSI_CTRL_DMA_DISABLE(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_DMA_DISABLE) | BF_MIPI_HSI_CTRL_DMA_DISABLE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field CLKGATE[30] (RW)
 *
 * This bit must be set to zero for normal operation. When set to one it gates off the clocks to the
 * block.
 */
//@{
#define BP_MIPI_HSI_CTRL_CLKGATE      (30)      //!< Bit position for MIPI_HSI_CTRL_CLKGATE.
#define BM_MIPI_HSI_CTRL_CLKGATE      (0x40000000)  //!< Bit mask for MIPI_HSI_CTRL_CLKGATE.

//! @brief Get value of MIPI_HSI_CTRL_CLKGATE from a register value.
#define BG_MIPI_HSI_CTRL_CLKGATE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_CLKGATE) >> BP_MIPI_HSI_CTRL_CLKGATE)

//! @brief Format value for bitfield MIPI_HSI_CTRL_CLKGATE.
#define BF_MIPI_HSI_CTRL_CLKGATE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_CLKGATE) & BM_MIPI_HSI_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLKGATE field to a new value.
#define BW_MIPI_HSI_CTRL_CLKGATE(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_CLKGATE) | BF_MIPI_HSI_CTRL_CLKGATE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_CTRL, field SFTRST[31] (RW)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one (default) to disable
 * clocking with the HSI and hold it in its reset (lowest power) state. This bit can be turned on
 * and then off to reset the HSI block to its default state.
 */
//@{
#define BP_MIPI_HSI_CTRL_SFTRST      (31)      //!< Bit position for MIPI_HSI_CTRL_SFTRST.
#define BM_MIPI_HSI_CTRL_SFTRST      (0x80000000)  //!< Bit mask for MIPI_HSI_CTRL_SFTRST.

//! @brief Get value of MIPI_HSI_CTRL_SFTRST from a register value.
#define BG_MIPI_HSI_CTRL_SFTRST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CTRL_SFTRST) >> BP_MIPI_HSI_CTRL_SFTRST)

//! @brief Format value for bitfield MIPI_HSI_CTRL_SFTRST.
#define BF_MIPI_HSI_CTRL_SFTRST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CTRL_SFTRST) & BM_MIPI_HSI_CTRL_SFTRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SFTRST field to a new value.
#define BW_MIPI_HSI_CTRL_SFTRST(v)   (HW_MIPI_HSI_CTRL_WR((HW_MIPI_HSI_CTRL_RD() & ~BM_MIPI_HSI_CTRL_SFTRST) | BF_MIPI_HSI_CTRL_SFTRST(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_CONF - HSI Tx Config Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_CONF - HSI Tx Config Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the configurations of tx channel enable/disable, tx wakup and tx trans
 * mode.
 */
typedef union _hw_mipi_hsi_tx_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_conf_bitfields
    {
        unsigned TRANS_MODE : 1; //!< [0] 
        unsigned WAKEUP : 1; //!< [1] When this bit gets set to one, HSI transmitter sends HSI_TX_WAKE signal to Rx of other device.
        unsigned RESERVED0 : 6; //!< [7:2] Reserved.
        unsigned TIMEOUT_CNT : 4; //!< [11:8] 
        unsigned RESERVED1 : 4; //!< [15:12] Reserved.
        unsigned CH0_EN : 1; //!< [16] 
        unsigned CH1_EN : 1; //!< [17] 
        unsigned CH2_EN : 1; //!< [18] 
        unsigned CH3_EN : 1; //!< [19] 
        unsigned CH4_EN : 1; //!< [20] 
        unsigned CH5_EN : 1; //!< [21] 
        unsigned CH6_EN : 1; //!< [22] 
        unsigned CH7_EN : 1; //!< [23] 
        unsigned CH8_EN : 1; //!< [24] 
        unsigned CH9_EN : 1; //!< [25] 
        unsigned CH10_EN : 1; //!< [26] 
        unsigned CH11_EN : 1; //!< [27] 
        unsigned CH12_EN : 1; //!< [28] 
        unsigned CH13_EN : 1; //!< [29] 
        unsigned CH14_EN : 1; //!< [30] 
        unsigned CH15_EN : 1; //!< [31] 
    } B;
} hw_mipi_hsi_tx_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_CONF register
 */
//@{
#define HW_MIPI_HSI_TX_CONF_ADDR      (REGS_MIPI_HSI_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_CONF           (*(volatile hw_mipi_hsi_tx_conf_t *) HW_MIPI_HSI_TX_CONF_ADDR)
#define HW_MIPI_HSI_TX_CONF_RD()      (HW_MIPI_HSI_TX_CONF.U)
#define HW_MIPI_HSI_TX_CONF_WR(v)     (HW_MIPI_HSI_TX_CONF.U = (v))
#define HW_MIPI_HSI_TX_CONF_SET(v)    (HW_MIPI_HSI_TX_CONF_WR(HW_MIPI_HSI_TX_CONF_RD() |  (v)))
#define HW_MIPI_HSI_TX_CONF_CLR(v)    (HW_MIPI_HSI_TX_CONF_WR(HW_MIPI_HSI_TX_CONF_RD() & ~(v)))
#define HW_MIPI_HSI_TX_CONF_TOG(v)    (HW_MIPI_HSI_TX_CONF_WR(HW_MIPI_HSI_TX_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_CONF bitfields
 */

/*! @name Register MIPI_HSI_TX_CONF, field TRANS_MODE[0] (RW)
 *
 * Values:
 * - 0 - Stream Transmission Mode
 * - 1 - Frame Transmission Mode
 */
//@{
#define BP_MIPI_HSI_TX_CONF_TRANS_MODE      (0)      //!< Bit position for MIPI_HSI_TX_CONF_TRANS_MODE.
#define BM_MIPI_HSI_TX_CONF_TRANS_MODE      (0x00000001)  //!< Bit mask for MIPI_HSI_TX_CONF_TRANS_MODE.

//! @brief Get value of MIPI_HSI_TX_CONF_TRANS_MODE from a register value.
#define BG_MIPI_HSI_TX_CONF_TRANS_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_TRANS_MODE) >> BP_MIPI_HSI_TX_CONF_TRANS_MODE)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_TRANS_MODE.
#define BF_MIPI_HSI_TX_CONF_TRANS_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_TRANS_MODE) & BM_MIPI_HSI_TX_CONF_TRANS_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRANS_MODE field to a new value.
#define BW_MIPI_HSI_TX_CONF_TRANS_MODE(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_TRANS_MODE) | BF_MIPI_HSI_TX_CONF_TRANS_MODE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field WAKEUP[1] (RW)
 *
 * When this bit gets set to one, HSI transmitter sends HSI_TX_WAKE signal to Rx of other device.
 * For a transmit operation this bit should be one.
 *
 * Values:
 * - 0 - Transmitter is in Sleep State
 * - 1 - Transmitter is in Wakeup State.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_WAKEUP      (1)      //!< Bit position for MIPI_HSI_TX_CONF_WAKEUP.
#define BM_MIPI_HSI_TX_CONF_WAKEUP      (0x00000002)  //!< Bit mask for MIPI_HSI_TX_CONF_WAKEUP.

//! @brief Get value of MIPI_HSI_TX_CONF_WAKEUP from a register value.
#define BG_MIPI_HSI_TX_CONF_WAKEUP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_WAKEUP) >> BP_MIPI_HSI_TX_CONF_WAKEUP)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_WAKEUP.
#define BF_MIPI_HSI_TX_CONF_WAKEUP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_WAKEUP) & BM_MIPI_HSI_TX_CONF_WAKEUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKEUP field to a new value.
#define BW_MIPI_HSI_TX_CONF_WAKEUP(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_WAKEUP) | BF_MIPI_HSI_TX_CONF_WAKEUP(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field TIMEOUT_CNT[11:8] (RW)
 *
 * Values:
 * - 0000 - tx timeout value 2^14 tx_refclk
 * - 0001 - tx timeout value 2^15 tx_refclk
 * - 0010 - tx timeout value 2^16 tx_refclk
 * - 0011 - tx timeout value 2^17 tx_refclk
 * - 1110 - tx timeout value 2^28 tx_refclk
 * - 1111 - tx timeout value 2^29 tx_refclk
 */
//@{
#define BP_MIPI_HSI_TX_CONF_TIMEOUT_CNT      (8)      //!< Bit position for MIPI_HSI_TX_CONF_TIMEOUT_CNT.
#define BM_MIPI_HSI_TX_CONF_TIMEOUT_CNT      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_CONF_TIMEOUT_CNT.

//! @brief Get value of MIPI_HSI_TX_CONF_TIMEOUT_CNT from a register value.
#define BG_MIPI_HSI_TX_CONF_TIMEOUT_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_TIMEOUT_CNT) >> BP_MIPI_HSI_TX_CONF_TIMEOUT_CNT)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_TIMEOUT_CNT.
#define BF_MIPI_HSI_TX_CONF_TIMEOUT_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_TIMEOUT_CNT) & BM_MIPI_HSI_TX_CONF_TIMEOUT_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMEOUT_CNT field to a new value.
#define BW_MIPI_HSI_TX_CONF_TIMEOUT_CNT(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_TIMEOUT_CNT) | BF_MIPI_HSI_TX_CONF_TIMEOUT_CNT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH0_EN[16] (RW)
 *
 * Values:
 * - 0 - Tx Ch0 is Disabled.
 * - 1 - Tx Ch0 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH0_EN      (16)      //!< Bit position for MIPI_HSI_TX_CONF_CH0_EN.
#define BM_MIPI_HSI_TX_CONF_CH0_EN      (0x00010000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH0_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH0_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH0_EN) >> BP_MIPI_HSI_TX_CONF_CH0_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH0_EN.
#define BF_MIPI_HSI_TX_CONF_CH0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH0_EN) & BM_MIPI_HSI_TX_CONF_CH0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH0_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH0_EN) | BF_MIPI_HSI_TX_CONF_CH0_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH1_EN[17] (RW)
 *
 * Values:
 * - 0 - Tx Ch1 is Disabled.
 * - 1 - Tx Ch1 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH1_EN      (17)      //!< Bit position for MIPI_HSI_TX_CONF_CH1_EN.
#define BM_MIPI_HSI_TX_CONF_CH1_EN      (0x00020000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH1_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH1_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH1_EN) >> BP_MIPI_HSI_TX_CONF_CH1_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH1_EN.
#define BF_MIPI_HSI_TX_CONF_CH1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH1_EN) & BM_MIPI_HSI_TX_CONF_CH1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH1_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH1_EN) | BF_MIPI_HSI_TX_CONF_CH1_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH2_EN[18] (RW)
 *
 * Values:
 * - 0 - Tx Ch2 is Disabled.
 * - 1 - Tx Ch2 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH2_EN      (18)      //!< Bit position for MIPI_HSI_TX_CONF_CH2_EN.
#define BM_MIPI_HSI_TX_CONF_CH2_EN      (0x00040000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH2_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH2_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH2_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH2_EN) >> BP_MIPI_HSI_TX_CONF_CH2_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH2_EN.
#define BF_MIPI_HSI_TX_CONF_CH2_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH2_EN) & BM_MIPI_HSI_TX_CONF_CH2_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH2_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH2_EN) | BF_MIPI_HSI_TX_CONF_CH2_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH3_EN[19] (RW)
 *
 * Values:
 * - 0 - Tx Ch3 is Disabled.
 * - 1 - Tx Ch3 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH3_EN      (19)      //!< Bit position for MIPI_HSI_TX_CONF_CH3_EN.
#define BM_MIPI_HSI_TX_CONF_CH3_EN      (0x00080000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH3_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH3_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH3_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH3_EN) >> BP_MIPI_HSI_TX_CONF_CH3_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH3_EN.
#define BF_MIPI_HSI_TX_CONF_CH3_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH3_EN) & BM_MIPI_HSI_TX_CONF_CH3_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH3_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH3_EN) | BF_MIPI_HSI_TX_CONF_CH3_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH4_EN[20] (RW)
 *
 * Values:
 * - 0 - Tx Ch4 is Disabled.
 * - 1 - Tx Ch4 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH4_EN      (20)      //!< Bit position for MIPI_HSI_TX_CONF_CH4_EN.
#define BM_MIPI_HSI_TX_CONF_CH4_EN      (0x00100000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH4_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH4_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH4_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH4_EN) >> BP_MIPI_HSI_TX_CONF_CH4_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH4_EN.
#define BF_MIPI_HSI_TX_CONF_CH4_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH4_EN) & BM_MIPI_HSI_TX_CONF_CH4_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH4_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH4_EN) | BF_MIPI_HSI_TX_CONF_CH4_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH5_EN[21] (RW)
 *
 * Values:
 * - 0 - Tx Ch5 is Disabled.
 * - 1 - Tx Ch5 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH5_EN      (21)      //!< Bit position for MIPI_HSI_TX_CONF_CH5_EN.
#define BM_MIPI_HSI_TX_CONF_CH5_EN      (0x00200000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH5_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH5_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH5_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH5_EN) >> BP_MIPI_HSI_TX_CONF_CH5_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH5_EN.
#define BF_MIPI_HSI_TX_CONF_CH5_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH5_EN) & BM_MIPI_HSI_TX_CONF_CH5_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH5_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH5_EN) | BF_MIPI_HSI_TX_CONF_CH5_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH6_EN[22] (RW)
 *
 * Values:
 * - 0 - Tx Ch6 is Disabled.
 * - 1 - Tx Ch6 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH6_EN      (22)      //!< Bit position for MIPI_HSI_TX_CONF_CH6_EN.
#define BM_MIPI_HSI_TX_CONF_CH6_EN      (0x00400000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH6_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH6_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH6_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH6_EN) >> BP_MIPI_HSI_TX_CONF_CH6_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH6_EN.
#define BF_MIPI_HSI_TX_CONF_CH6_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH6_EN) & BM_MIPI_HSI_TX_CONF_CH6_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH6_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH6_EN) | BF_MIPI_HSI_TX_CONF_CH6_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH7_EN[23] (RW)
 *
 * Values:
 * - 0 - Tx Ch7 is Disabled.
 * - 1 - Tx Ch7 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH7_EN      (23)      //!< Bit position for MIPI_HSI_TX_CONF_CH7_EN.
#define BM_MIPI_HSI_TX_CONF_CH7_EN      (0x00800000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH7_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH7_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH7_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH7_EN) >> BP_MIPI_HSI_TX_CONF_CH7_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH7_EN.
#define BF_MIPI_HSI_TX_CONF_CH7_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH7_EN) & BM_MIPI_HSI_TX_CONF_CH7_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH7_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH7_EN) | BF_MIPI_HSI_TX_CONF_CH7_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH8_EN[24] (RW)
 *
 * Values:
 * - 0 - Tx Ch8 is Disabled.
 * - 1 - Tx Ch8 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH8_EN      (24)      //!< Bit position for MIPI_HSI_TX_CONF_CH8_EN.
#define BM_MIPI_HSI_TX_CONF_CH8_EN      (0x01000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH8_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH8_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH8_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH8_EN) >> BP_MIPI_HSI_TX_CONF_CH8_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH8_EN.
#define BF_MIPI_HSI_TX_CONF_CH8_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH8_EN) & BM_MIPI_HSI_TX_CONF_CH8_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH8_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH8_EN) | BF_MIPI_HSI_TX_CONF_CH8_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH9_EN[25] (RW)
 *
 * Values:
 * - 0 - Tx Ch9 is Disabled.
 * - 1 - Tx Ch9 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH9_EN      (25)      //!< Bit position for MIPI_HSI_TX_CONF_CH9_EN.
#define BM_MIPI_HSI_TX_CONF_CH9_EN      (0x02000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH9_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH9_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH9_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH9_EN) >> BP_MIPI_HSI_TX_CONF_CH9_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH9_EN.
#define BF_MIPI_HSI_TX_CONF_CH9_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH9_EN) & BM_MIPI_HSI_TX_CONF_CH9_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH9_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH9_EN) | BF_MIPI_HSI_TX_CONF_CH9_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH10_EN[26] (RW)
 *
 * Values:
 * - 0 - Tx Ch10 is Disabled.
 * - 1 - Tx Ch10 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH10_EN      (26)      //!< Bit position for MIPI_HSI_TX_CONF_CH10_EN.
#define BM_MIPI_HSI_TX_CONF_CH10_EN      (0x04000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH10_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH10_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH10_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH10_EN) >> BP_MIPI_HSI_TX_CONF_CH10_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH10_EN.
#define BF_MIPI_HSI_TX_CONF_CH10_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH10_EN) & BM_MIPI_HSI_TX_CONF_CH10_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH10_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH10_EN) | BF_MIPI_HSI_TX_CONF_CH10_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH11_EN[27] (RW)
 *
 * Values:
 * - 0 - Tx Ch11 is Disabled.
 * - 1 - Tx Ch11 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH11_EN      (27)      //!< Bit position for MIPI_HSI_TX_CONF_CH11_EN.
#define BM_MIPI_HSI_TX_CONF_CH11_EN      (0x08000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH11_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH11_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH11_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH11_EN) >> BP_MIPI_HSI_TX_CONF_CH11_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH11_EN.
#define BF_MIPI_HSI_TX_CONF_CH11_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH11_EN) & BM_MIPI_HSI_TX_CONF_CH11_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH11_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH11_EN) | BF_MIPI_HSI_TX_CONF_CH11_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH12_EN[28] (RW)
 *
 * Values:
 * - 0 - Tx Ch12 is Disabled.
 * - 1 - Tx Ch12 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH12_EN      (28)      //!< Bit position for MIPI_HSI_TX_CONF_CH12_EN.
#define BM_MIPI_HSI_TX_CONF_CH12_EN      (0x10000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH12_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH12_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH12_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH12_EN) >> BP_MIPI_HSI_TX_CONF_CH12_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH12_EN.
#define BF_MIPI_HSI_TX_CONF_CH12_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH12_EN) & BM_MIPI_HSI_TX_CONF_CH12_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH12_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH12_EN) | BF_MIPI_HSI_TX_CONF_CH12_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH13_EN[29] (RW)
 *
 * Values:
 * - 0 - Tx Ch13 is Disabled.
 * - 1 - Tx Ch13 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH13_EN      (29)      //!< Bit position for MIPI_HSI_TX_CONF_CH13_EN.
#define BM_MIPI_HSI_TX_CONF_CH13_EN      (0x20000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH13_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH13_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH13_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH13_EN) >> BP_MIPI_HSI_TX_CONF_CH13_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH13_EN.
#define BF_MIPI_HSI_TX_CONF_CH13_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH13_EN) & BM_MIPI_HSI_TX_CONF_CH13_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH13_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH13_EN) | BF_MIPI_HSI_TX_CONF_CH13_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH14_EN[30] (RW)
 *
 * Values:
 * - 0 - Tx Ch14 is Disabled.
 * - 1 - Tx Ch14 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH14_EN      (30)      //!< Bit position for MIPI_HSI_TX_CONF_CH14_EN.
#define BM_MIPI_HSI_TX_CONF_CH14_EN      (0x40000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH14_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH14_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH14_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH14_EN) >> BP_MIPI_HSI_TX_CONF_CH14_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH14_EN.
#define BF_MIPI_HSI_TX_CONF_CH14_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH14_EN) & BM_MIPI_HSI_TX_CONF_CH14_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH14_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH14_EN) | BF_MIPI_HSI_TX_CONF_CH14_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_CONF, field CH15_EN[31] (RW)
 *
 * Values:
 * - 0 - Tx Ch15 is Disabled.
 * - 1 - Tx Ch15 is Enabled.
 */
//@{
#define BP_MIPI_HSI_TX_CONF_CH15_EN      (31)      //!< Bit position for MIPI_HSI_TX_CONF_CH15_EN.
#define BM_MIPI_HSI_TX_CONF_CH15_EN      (0x80000000)  //!< Bit mask for MIPI_HSI_TX_CONF_CH15_EN.

//! @brief Get value of MIPI_HSI_TX_CONF_CH15_EN from a register value.
#define BG_MIPI_HSI_TX_CONF_CH15_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CONF_CH15_EN) >> BP_MIPI_HSI_TX_CONF_CH15_EN)

//! @brief Format value for bitfield MIPI_HSI_TX_CONF_CH15_EN.
#define BF_MIPI_HSI_TX_CONF_CH15_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CONF_CH15_EN) & BM_MIPI_HSI_TX_CONF_CH15_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15_EN field to a new value.
#define BW_MIPI_HSI_TX_CONF_CH15_EN(v)   (HW_MIPI_HSI_TX_CONF_WR((HW_MIPI_HSI_TX_CONF_RD() & ~BM_MIPI_HSI_TX_CONF_CH15_EN) | BF_MIPI_HSI_TX_CONF_CH15_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RX_CONF - HSI Rx Config Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RX_CONF - HSI Rx Config Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the configurations of rx channel enable/disable, rx wakup and rx trans
 * mode, rx data flow.
 */
typedef union _hw_mipi_hsi_rx_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_rx_conf_bitfields
    {
        unsigned DATA_FLOW : 2; //!< [1:0] 
        unsigned WAKE : 1; //!< [2] 
        unsigned REC_MODE : 1; //!< [3] 
        unsigned TAIL_BIT_CNT_EN : 1; //!< [4] 
        unsigned RESERVED0 : 3; //!< [7:5] Reserved.
        unsigned TIMEOUT_CNT : 7; //!< [14:8] Receive Frame Timeout Counter:
        unsigned RESERVED1 : 1; //!< [15] Reserved.
        unsigned CH0_EN : 1; //!< [16] 
        unsigned CH1_EN : 1; //!< [17] 
        unsigned CH2_EN : 1; //!< [18] 
        unsigned CH3_EN : 1; //!< [19] 
        unsigned CH4_EN : 1; //!< [20] 
        unsigned CH5_EN : 1; //!< [21] 
        unsigned CH6_EN : 1; //!< [22] 
        unsigned CH7_EN : 1; //!< [23] 
        unsigned CH8_EN : 1; //!< [24] 
        unsigned CH9_EN : 1; //!< [25] 
        unsigned CH10_EN : 1; //!< [26] 
        unsigned CH11_EN : 1; //!< [27] 
        unsigned CH12_EN : 1; //!< [28] 
        unsigned CH13_EN : 1; //!< [29] 
        unsigned CH14_EN : 1; //!< [30] 
        unsigned CH15_EN : 1; //!< [31] 
    } B;
} hw_mipi_hsi_rx_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RX_CONF register
 */
//@{
#define HW_MIPI_HSI_RX_CONF_ADDR      (REGS_MIPI_HSI_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RX_CONF           (*(volatile hw_mipi_hsi_rx_conf_t *) HW_MIPI_HSI_RX_CONF_ADDR)
#define HW_MIPI_HSI_RX_CONF_RD()      (HW_MIPI_HSI_RX_CONF.U)
#define HW_MIPI_HSI_RX_CONF_WR(v)     (HW_MIPI_HSI_RX_CONF.U = (v))
#define HW_MIPI_HSI_RX_CONF_SET(v)    (HW_MIPI_HSI_RX_CONF_WR(HW_MIPI_HSI_RX_CONF_RD() |  (v)))
#define HW_MIPI_HSI_RX_CONF_CLR(v)    (HW_MIPI_HSI_RX_CONF_WR(HW_MIPI_HSI_RX_CONF_RD() & ~(v)))
#define HW_MIPI_HSI_RX_CONF_TOG(v)    (HW_MIPI_HSI_RX_CONF_WR(HW_MIPI_HSI_RX_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RX_CONF bitfields
 */

/*! @name Register MIPI_HSI_RX_CONF, field DATA_FLOW[1:0] (RW)
 *
 * Values:
 * - 00 - Synchronized Data Flow
 * - 01 - Pipelined Data Flow
 * - 10 - Receiver Real-time Data Flow
 * - 11 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_CONF_DATA_FLOW      (0)      //!< Bit position for MIPI_HSI_RX_CONF_DATA_FLOW.
#define BM_MIPI_HSI_RX_CONF_DATA_FLOW      (0x00000003)  //!< Bit mask for MIPI_HSI_RX_CONF_DATA_FLOW.

//! @brief Get value of MIPI_HSI_RX_CONF_DATA_FLOW from a register value.
#define BG_MIPI_HSI_RX_CONF_DATA_FLOW(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_DATA_FLOW) >> BP_MIPI_HSI_RX_CONF_DATA_FLOW)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_DATA_FLOW.
#define BF_MIPI_HSI_RX_CONF_DATA_FLOW(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_DATA_FLOW) & BM_MIPI_HSI_RX_CONF_DATA_FLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_FLOW field to a new value.
#define BW_MIPI_HSI_RX_CONF_DATA_FLOW(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_DATA_FLOW) | BF_MIPI_HSI_RX_CONF_DATA_FLOW(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field WAKE[2] (RW)
 *
 * Values:
 * - 0 - Receiver is in Sleep State
 * - 1 - Receiver is in Wakeup State
 */
//@{
#define BP_MIPI_HSI_RX_CONF_WAKE      (2)      //!< Bit position for MIPI_HSI_RX_CONF_WAKE.
#define BM_MIPI_HSI_RX_CONF_WAKE      (0x00000004)  //!< Bit mask for MIPI_HSI_RX_CONF_WAKE.

//! @brief Get value of MIPI_HSI_RX_CONF_WAKE from a register value.
#define BG_MIPI_HSI_RX_CONF_WAKE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_WAKE) >> BP_MIPI_HSI_RX_CONF_WAKE)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_WAKE.
#define BF_MIPI_HSI_RX_CONF_WAKE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_WAKE) & BM_MIPI_HSI_RX_CONF_WAKE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKE field to a new value.
#define BW_MIPI_HSI_RX_CONF_WAKE(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_WAKE) | BF_MIPI_HSI_RX_CONF_WAKE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field REC_MODE[3] (RW)
 *
 * Values:
 * - 0 - Stream Receive Mode
 * - 1 - Frame Receive Mode
 */
//@{
#define BP_MIPI_HSI_RX_CONF_REC_MODE      (3)      //!< Bit position for MIPI_HSI_RX_CONF_REC_MODE.
#define BM_MIPI_HSI_RX_CONF_REC_MODE      (0x00000008)  //!< Bit mask for MIPI_HSI_RX_CONF_REC_MODE.

//! @brief Get value of MIPI_HSI_RX_CONF_REC_MODE from a register value.
#define BG_MIPI_HSI_RX_CONF_REC_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_REC_MODE) >> BP_MIPI_HSI_RX_CONF_REC_MODE)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_REC_MODE.
#define BF_MIPI_HSI_RX_CONF_REC_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_REC_MODE) & BM_MIPI_HSI_RX_CONF_REC_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REC_MODE field to a new value.
#define BW_MIPI_HSI_RX_CONF_REC_MODE(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_REC_MODE) | BF_MIPI_HSI_RX_CONF_REC_MODE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field TAIL_BIT_CNT_EN[4] (RW)
 *
 * Values:
 * - 0 - Tailing bit counter disable
 * - 1 - Tailing bit counter Enable
 */
//@{
#define BP_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN      (4)      //!< Bit position for MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN.
#define BM_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN      (0x00000010)  //!< Bit mask for MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN) >> BP_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN.
#define BF_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN) & BM_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TAIL_BIT_CNT_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN) | BF_MIPI_HSI_RX_CONF_TAIL_BIT_CNT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field TIMEOUT_CNT[14:8] (RW)
 *
 * Receive Frame Timeout Counter: The counter shall be started when the first bit of the Frame has
 * been found. The counter shall be stopped once the receiver has received the correct number of
 * bits for a Frame. If the counter expires before Frame reception is completed, the receiver will
 * signal to the protocol layer that it has found an incomplete Frame and asserts Rx Error
 * Interrupt. 7'h0 14800 ---> tx_refclk 7'h1 16400 ---> tx_refclk 7'h2 18000 ---> tx_refclk 7'h4
 * 19600 ---> tx_refclk 7'h8 21200 ---> tx_refclk 7'h10 22800 ---> tx_refclk 7'h20 24400 --->
 * tx_refclk 7'h40 26000 ---> tx_refclk
 */
//@{
#define BP_MIPI_HSI_RX_CONF_TIMEOUT_CNT      (8)      //!< Bit position for MIPI_HSI_RX_CONF_TIMEOUT_CNT.
#define BM_MIPI_HSI_RX_CONF_TIMEOUT_CNT      (0x00007f00)  //!< Bit mask for MIPI_HSI_RX_CONF_TIMEOUT_CNT.

//! @brief Get value of MIPI_HSI_RX_CONF_TIMEOUT_CNT from a register value.
#define BG_MIPI_HSI_RX_CONF_TIMEOUT_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_TIMEOUT_CNT) >> BP_MIPI_HSI_RX_CONF_TIMEOUT_CNT)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_TIMEOUT_CNT.
#define BF_MIPI_HSI_RX_CONF_TIMEOUT_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_TIMEOUT_CNT) & BM_MIPI_HSI_RX_CONF_TIMEOUT_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMEOUT_CNT field to a new value.
#define BW_MIPI_HSI_RX_CONF_TIMEOUT_CNT(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_TIMEOUT_CNT) | BF_MIPI_HSI_RX_CONF_TIMEOUT_CNT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH0_EN[16] (RW)
 *
 * Values:
 * - 0 - Rx Ch0 is Disabled.
 * - 1 - Rx Ch0 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH0_EN      (16)      //!< Bit position for MIPI_HSI_RX_CONF_CH0_EN.
#define BM_MIPI_HSI_RX_CONF_CH0_EN      (0x00010000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH0_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH0_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH0_EN) >> BP_MIPI_HSI_RX_CONF_CH0_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH0_EN.
#define BF_MIPI_HSI_RX_CONF_CH0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH0_EN) & BM_MIPI_HSI_RX_CONF_CH0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH0_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH0_EN) | BF_MIPI_HSI_RX_CONF_CH0_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH1_EN[17] (RW)
 *
 * Values:
 * - 0 - Rx Ch1 is Disabled.
 * - 1 - Rx Ch1 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH1_EN      (17)      //!< Bit position for MIPI_HSI_RX_CONF_CH1_EN.
#define BM_MIPI_HSI_RX_CONF_CH1_EN      (0x00020000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH1_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH1_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH1_EN) >> BP_MIPI_HSI_RX_CONF_CH1_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH1_EN.
#define BF_MIPI_HSI_RX_CONF_CH1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH1_EN) & BM_MIPI_HSI_RX_CONF_CH1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH1_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH1_EN) | BF_MIPI_HSI_RX_CONF_CH1_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH2_EN[18] (RW)
 *
 * Values:
 * - 0 - Rx Ch2 is Disabled.
 * - 1 - Rx Ch2 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH2_EN      (18)      //!< Bit position for MIPI_HSI_RX_CONF_CH2_EN.
#define BM_MIPI_HSI_RX_CONF_CH2_EN      (0x00040000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH2_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH2_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH2_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH2_EN) >> BP_MIPI_HSI_RX_CONF_CH2_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH2_EN.
#define BF_MIPI_HSI_RX_CONF_CH2_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH2_EN) & BM_MIPI_HSI_RX_CONF_CH2_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH2_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH2_EN) | BF_MIPI_HSI_RX_CONF_CH2_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH3_EN[19] (RW)
 *
 * Values:
 * - 0 - Rx Ch3 is Disabled.
 * - 1 - Rx Ch3 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH3_EN      (19)      //!< Bit position for MIPI_HSI_RX_CONF_CH3_EN.
#define BM_MIPI_HSI_RX_CONF_CH3_EN      (0x00080000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH3_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH3_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH3_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH3_EN) >> BP_MIPI_HSI_RX_CONF_CH3_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH3_EN.
#define BF_MIPI_HSI_RX_CONF_CH3_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH3_EN) & BM_MIPI_HSI_RX_CONF_CH3_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH3_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH3_EN) | BF_MIPI_HSI_RX_CONF_CH3_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH4_EN[20] (RW)
 *
 * Values:
 * - 0 - Rx Ch4 is Disabled.
 * - 1 - Rx Ch4 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH4_EN      (20)      //!< Bit position for MIPI_HSI_RX_CONF_CH4_EN.
#define BM_MIPI_HSI_RX_CONF_CH4_EN      (0x00100000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH4_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH4_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH4_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH4_EN) >> BP_MIPI_HSI_RX_CONF_CH4_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH4_EN.
#define BF_MIPI_HSI_RX_CONF_CH4_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH4_EN) & BM_MIPI_HSI_RX_CONF_CH4_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH4_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH4_EN) | BF_MIPI_HSI_RX_CONF_CH4_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH5_EN[21] (RW)
 *
 * Values:
 * - 0 - Rx Ch5 is Disabled.
 * - 1 - Rx Ch5 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH5_EN      (21)      //!< Bit position for MIPI_HSI_RX_CONF_CH5_EN.
#define BM_MIPI_HSI_RX_CONF_CH5_EN      (0x00200000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH5_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH5_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH5_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH5_EN) >> BP_MIPI_HSI_RX_CONF_CH5_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH5_EN.
#define BF_MIPI_HSI_RX_CONF_CH5_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH5_EN) & BM_MIPI_HSI_RX_CONF_CH5_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH5_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH5_EN) | BF_MIPI_HSI_RX_CONF_CH5_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH6_EN[22] (RW)
 *
 * Values:
 * - 0 - Rx Ch6 is Disabled.
 * - 1 - Rx Ch6 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH6_EN      (22)      //!< Bit position for MIPI_HSI_RX_CONF_CH6_EN.
#define BM_MIPI_HSI_RX_CONF_CH6_EN      (0x00400000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH6_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH6_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH6_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH6_EN) >> BP_MIPI_HSI_RX_CONF_CH6_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH6_EN.
#define BF_MIPI_HSI_RX_CONF_CH6_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH6_EN) & BM_MIPI_HSI_RX_CONF_CH6_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH6_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH6_EN) | BF_MIPI_HSI_RX_CONF_CH6_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH7_EN[23] (RW)
 *
 * Values:
 * - 0 - Rx Ch7 is Disabled.
 * - 1 - Rx Ch7 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH7_EN      (23)      //!< Bit position for MIPI_HSI_RX_CONF_CH7_EN.
#define BM_MIPI_HSI_RX_CONF_CH7_EN      (0x00800000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH7_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH7_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH7_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH7_EN) >> BP_MIPI_HSI_RX_CONF_CH7_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH7_EN.
#define BF_MIPI_HSI_RX_CONF_CH7_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH7_EN) & BM_MIPI_HSI_RX_CONF_CH7_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH7_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH7_EN) | BF_MIPI_HSI_RX_CONF_CH7_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH8_EN[24] (RW)
 *
 * Values:
 * - 0 - Rx Ch8 is Disabled.
 * - 1 - Rx Ch8 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH8_EN      (24)      //!< Bit position for MIPI_HSI_RX_CONF_CH8_EN.
#define BM_MIPI_HSI_RX_CONF_CH8_EN      (0x01000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH8_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH8_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH8_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH8_EN) >> BP_MIPI_HSI_RX_CONF_CH8_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH8_EN.
#define BF_MIPI_HSI_RX_CONF_CH8_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH8_EN) & BM_MIPI_HSI_RX_CONF_CH8_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH8_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH8_EN) | BF_MIPI_HSI_RX_CONF_CH8_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH9_EN[25] (RW)
 *
 * Values:
 * - 0 - Rx Ch9 is Disabled.
 * - 1 - Rx Ch9 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH9_EN      (25)      //!< Bit position for MIPI_HSI_RX_CONF_CH9_EN.
#define BM_MIPI_HSI_RX_CONF_CH9_EN      (0x02000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH9_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH9_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH9_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH9_EN) >> BP_MIPI_HSI_RX_CONF_CH9_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH9_EN.
#define BF_MIPI_HSI_RX_CONF_CH9_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH9_EN) & BM_MIPI_HSI_RX_CONF_CH9_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH9_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH9_EN) | BF_MIPI_HSI_RX_CONF_CH9_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH10_EN[26] (RW)
 *
 * Values:
 * - 0 - Rx Ch10 is Disabled.
 * - 1 - Rx Ch10 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH10_EN      (26)      //!< Bit position for MIPI_HSI_RX_CONF_CH10_EN.
#define BM_MIPI_HSI_RX_CONF_CH10_EN      (0x04000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH10_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH10_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH10_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH10_EN) >> BP_MIPI_HSI_RX_CONF_CH10_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH10_EN.
#define BF_MIPI_HSI_RX_CONF_CH10_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH10_EN) & BM_MIPI_HSI_RX_CONF_CH10_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH10_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH10_EN) | BF_MIPI_HSI_RX_CONF_CH10_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH11_EN[27] (RW)
 *
 * Values:
 * - 0 - Rx Ch11 is Disabled.
 * - 1 - Rx Ch11 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH11_EN      (27)      //!< Bit position for MIPI_HSI_RX_CONF_CH11_EN.
#define BM_MIPI_HSI_RX_CONF_CH11_EN      (0x08000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH11_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH11_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH11_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH11_EN) >> BP_MIPI_HSI_RX_CONF_CH11_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH11_EN.
#define BF_MIPI_HSI_RX_CONF_CH11_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH11_EN) & BM_MIPI_HSI_RX_CONF_CH11_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH11_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH11_EN) | BF_MIPI_HSI_RX_CONF_CH11_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH12_EN[28] (RW)
 *
 * Values:
 * - 0 - Rx Ch12 is Disabled.
 * - 1 - Rx Ch12 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH12_EN      (28)      //!< Bit position for MIPI_HSI_RX_CONF_CH12_EN.
#define BM_MIPI_HSI_RX_CONF_CH12_EN      (0x10000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH12_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH12_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH12_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH12_EN) >> BP_MIPI_HSI_RX_CONF_CH12_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH12_EN.
#define BF_MIPI_HSI_RX_CONF_CH12_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH12_EN) & BM_MIPI_HSI_RX_CONF_CH12_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH12_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH12_EN) | BF_MIPI_HSI_RX_CONF_CH12_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH13_EN[29] (RW)
 *
 * Values:
 * - 0 - Rx Ch13 is Disabled.
 * - 1 - Rx Ch13 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH13_EN      (29)      //!< Bit position for MIPI_HSI_RX_CONF_CH13_EN.
#define BM_MIPI_HSI_RX_CONF_CH13_EN      (0x20000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH13_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH13_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH13_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH13_EN) >> BP_MIPI_HSI_RX_CONF_CH13_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH13_EN.
#define BF_MIPI_HSI_RX_CONF_CH13_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH13_EN) & BM_MIPI_HSI_RX_CONF_CH13_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH13_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH13_EN) | BF_MIPI_HSI_RX_CONF_CH13_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH14_EN[30] (RW)
 *
 * Values:
 * - 0 - Rx Ch14 is Disabled.
 * - 1 - Rx Ch14 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH14_EN      (30)      //!< Bit position for MIPI_HSI_RX_CONF_CH14_EN.
#define BM_MIPI_HSI_RX_CONF_CH14_EN      (0x40000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH14_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH14_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH14_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH14_EN) >> BP_MIPI_HSI_RX_CONF_CH14_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH14_EN.
#define BF_MIPI_HSI_RX_CONF_CH14_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH14_EN) & BM_MIPI_HSI_RX_CONF_CH14_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH14_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH14_EN) | BF_MIPI_HSI_RX_CONF_CH14_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_CONF, field CH15_EN[31] (RW)
 *
 * Values:
 * - 0 - Rx Ch15 is Disabled.
 * - 1 - Rx Ch15 is Enabled.
 */
//@{
#define BP_MIPI_HSI_RX_CONF_CH15_EN      (31)      //!< Bit position for MIPI_HSI_RX_CONF_CH15_EN.
#define BM_MIPI_HSI_RX_CONF_CH15_EN      (0x80000000)  //!< Bit mask for MIPI_HSI_RX_CONF_CH15_EN.

//! @brief Get value of MIPI_HSI_RX_CONF_CH15_EN from a register value.
#define BG_MIPI_HSI_RX_CONF_CH15_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CONF_CH15_EN) >> BP_MIPI_HSI_RX_CONF_CH15_EN)

//! @brief Format value for bitfield MIPI_HSI_RX_CONF_CH15_EN.
#define BF_MIPI_HSI_RX_CONF_CH15_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CONF_CH15_EN) & BM_MIPI_HSI_RX_CONF_CH15_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15_EN field to a new value.
#define BW_MIPI_HSI_RX_CONF_CH15_EN(v)   (HW_MIPI_HSI_RX_CONF_WR((HW_MIPI_HSI_RX_CONF_RD() & ~BM_MIPI_HSI_RX_CONF_CH15_EN) | BF_MIPI_HSI_RX_CONF_CH15_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_CAP - HSI Capability Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_CAP - HSI Capability Register (RO)
 *
 * Reset value: 0x00071fff
 *
 * This register contains the HSI controller Capability information.
 */
typedef union _hw_mipi_hsi_cap
{
    reg32_t U;
    struct _hw_mipi_hsi_cap_bitfields
    {
        unsigned TX_CH_NU_SUPPORTE : 4; //!< [3:0] 
        unsigned RX_CH_NU_SUPPORTE : 4; //!< [7:4] 
        unsigned DMA_CH_NU_SUPPORT : 5; //!< [12:8] 
        unsigned RESERVED0 : 3; //!< [15:13] Reserved.
        unsigned TX_DMA_SUPPORT : 1; //!< [16] 
        unsigned RX_DMA_SUPPORT : 1; //!< [17] 
        unsigned WAKEUP_EVENT : 1; //!< [18] 
        unsigned RESERVED1 : 13; //!< [31:19] Reserved.
    } B;
} hw_mipi_hsi_cap_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_CAP register
 */
//@{
#define HW_MIPI_HSI_CAP_ADDR      (REGS_MIPI_HSI_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_CAP           (*(volatile hw_mipi_hsi_cap_t *) HW_MIPI_HSI_CAP_ADDR)
#define HW_MIPI_HSI_CAP_RD()      (HW_MIPI_HSI_CAP.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_CAP bitfields
 */

/*! @name Register MIPI_HSI_CAP, field TX_CH_NU_SUPPORTE[3:0] (RO)
 *
 * Values:
 * - 0000 - 1 Tx channel supported
 * - 0001 - 2 Tx channels supported
 * - 1111 - 16 Tx channels supported
 */
//@{
#define BP_MIPI_HSI_CAP_TX_CH_NU_SUPPORTE      (0)      //!< Bit position for MIPI_HSI_CAP_TX_CH_NU_SUPPORTE.
#define BM_MIPI_HSI_CAP_TX_CH_NU_SUPPORTE      (0x0000000f)  //!< Bit mask for MIPI_HSI_CAP_TX_CH_NU_SUPPORTE.

//! @brief Get value of MIPI_HSI_CAP_TX_CH_NU_SUPPORTE from a register value.
#define BG_MIPI_HSI_CAP_TX_CH_NU_SUPPORTE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_TX_CH_NU_SUPPORTE) >> BP_MIPI_HSI_CAP_TX_CH_NU_SUPPORTE)
//@}

/*! @name Register MIPI_HSI_CAP, field RX_CH_NU_SUPPORTE[7:4] (RO)
 *
 * Values:
 * - 0000 - 1 Rx channel supported
 * - 0001 - 2 Rx channels supported
 * - 1111 - 16 Rx channels supported
 */
//@{
#define BP_MIPI_HSI_CAP_RX_CH_NU_SUPPORTE      (4)      //!< Bit position for MIPI_HSI_CAP_RX_CH_NU_SUPPORTE.
#define BM_MIPI_HSI_CAP_RX_CH_NU_SUPPORTE      (0x000000f0)  //!< Bit mask for MIPI_HSI_CAP_RX_CH_NU_SUPPORTE.

//! @brief Get value of MIPI_HSI_CAP_RX_CH_NU_SUPPORTE from a register value.
#define BG_MIPI_HSI_CAP_RX_CH_NU_SUPPORTE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_RX_CH_NU_SUPPORTE) >> BP_MIPI_HSI_CAP_RX_CH_NU_SUPPORTE)
//@}

/*! @name Register MIPI_HSI_CAP, field DMA_CH_NU_SUPPORT[12:8] (RO)
 *
 * Values:
 * - 00000 - 1 DMA supported
 * - 00001 - 2 DMA supported
 * - 00010 - 3 DMA supported
 * - 00011 - 4 DMA supported
 * - 00100 - 5 DMA supported
 * - 00101 - 6 DMA supported
 * - 11110 - 31 DMA supported
 * - 11111 - 32 DMA supported
 */
//@{
#define BP_MIPI_HSI_CAP_DMA_CH_NU_SUPPORT      (8)      //!< Bit position for MIPI_HSI_CAP_DMA_CH_NU_SUPPORT.
#define BM_MIPI_HSI_CAP_DMA_CH_NU_SUPPORT      (0x00001f00)  //!< Bit mask for MIPI_HSI_CAP_DMA_CH_NU_SUPPORT.

//! @brief Get value of MIPI_HSI_CAP_DMA_CH_NU_SUPPORT from a register value.
#define BG_MIPI_HSI_CAP_DMA_CH_NU_SUPPORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_DMA_CH_NU_SUPPORT) >> BP_MIPI_HSI_CAP_DMA_CH_NU_SUPPORT)
//@}

/*! @name Register MIPI_HSI_CAP, field TX_DMA_SUPPORT[16] (RO)
 *
 * Values:
 * - 0 - Not supported
 * - 1 - DMA is supported.
 */
//@{
#define BP_MIPI_HSI_CAP_TX_DMA_SUPPORT      (16)      //!< Bit position for MIPI_HSI_CAP_TX_DMA_SUPPORT.
#define BM_MIPI_HSI_CAP_TX_DMA_SUPPORT      (0x00010000)  //!< Bit mask for MIPI_HSI_CAP_TX_DMA_SUPPORT.

//! @brief Get value of MIPI_HSI_CAP_TX_DMA_SUPPORT from a register value.
#define BG_MIPI_HSI_CAP_TX_DMA_SUPPORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_TX_DMA_SUPPORT) >> BP_MIPI_HSI_CAP_TX_DMA_SUPPORT)
//@}

/*! @name Register MIPI_HSI_CAP, field RX_DMA_SUPPORT[17] (RO)
 *
 * Values:
 * - 0 - Not supported
 * - 1 - DMA is supported.
 */
//@{
#define BP_MIPI_HSI_CAP_RX_DMA_SUPPORT      (17)      //!< Bit position for MIPI_HSI_CAP_RX_DMA_SUPPORT.
#define BM_MIPI_HSI_CAP_RX_DMA_SUPPORT      (0x00020000)  //!< Bit mask for MIPI_HSI_CAP_RX_DMA_SUPPORT.

//! @brief Get value of MIPI_HSI_CAP_RX_DMA_SUPPORT from a register value.
#define BG_MIPI_HSI_CAP_RX_DMA_SUPPORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_RX_DMA_SUPPORT) >> BP_MIPI_HSI_CAP_RX_DMA_SUPPORT)
//@}

/*! @name Register MIPI_HSI_CAP, field WAKEUP_EVENT[18] (RO)
 *
 * Values:
 * - 0 - Wakeup Event is supported
 * - 1 - Wakeup Event is not supported.
 */
//@{
#define BP_MIPI_HSI_CAP_WAKEUP_EVENT      (18)      //!< Bit position for MIPI_HSI_CAP_WAKEUP_EVENT.
#define BM_MIPI_HSI_CAP_WAKEUP_EVENT      (0x00040000)  //!< Bit mask for MIPI_HSI_CAP_WAKEUP_EVENT.

//! @brief Get value of MIPI_HSI_CAP_WAKEUP_EVENT from a register value.
#define BG_MIPI_HSI_CAP_WAKEUP_EVENT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CAP_WAKEUP_EVENT) >> BP_MIPI_HSI_CAP_WAKEUP_EVENT)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_WML0 - HSI Tx Water Mark Level 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_WML0 - HSI Tx Water Mark Level 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains HSI controller Tx channel Water Mark Level information.
 */
typedef union _hw_mipi_hsi_tx_wml0
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_wml0_bitfields
    {
        unsigned CH8 : 4; //!< [3:0] This value denotes the WML of Tx Channel 8.
        unsigned CH9 : 4; //!< [7:4] This value denotes the WML of Tx Channel 9.
        unsigned CH10 : 4; //!< [11:8] This value denotes the WML of Tx Channel 10.
        unsigned CH11 : 4; //!< [15:12] This value denotes the WML of Tx Channel 11.
        unsigned CH12 : 4; //!< [19:16] This value denotes the WML of Tx Channel 12.
        unsigned CH13 : 4; //!< [23:20] This value denotes the WML of Tx Channel 13.
        unsigned CH14 : 4; //!< [27:24] This value denotes the WML of Tx Channel 14.
        unsigned CH15 : 4; //!< [31:28] This value denotes the WML of Tx Channel 15.
    } B;
} hw_mipi_hsi_tx_wml0_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_WML0 register
 */
//@{
#define HW_MIPI_HSI_TX_WML0_ADDR      (REGS_MIPI_HSI_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_WML0           (*(volatile hw_mipi_hsi_tx_wml0_t *) HW_MIPI_HSI_TX_WML0_ADDR)
#define HW_MIPI_HSI_TX_WML0_RD()      (HW_MIPI_HSI_TX_WML0.U)
#define HW_MIPI_HSI_TX_WML0_WR(v)     (HW_MIPI_HSI_TX_WML0.U = (v))
#define HW_MIPI_HSI_TX_WML0_SET(v)    (HW_MIPI_HSI_TX_WML0_WR(HW_MIPI_HSI_TX_WML0_RD() |  (v)))
#define HW_MIPI_HSI_TX_WML0_CLR(v)    (HW_MIPI_HSI_TX_WML0_WR(HW_MIPI_HSI_TX_WML0_RD() & ~(v)))
#define HW_MIPI_HSI_TX_WML0_TOG(v)    (HW_MIPI_HSI_TX_WML0_WR(HW_MIPI_HSI_TX_WML0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_WML0 bitfields
 */

/*! @name Register MIPI_HSI_TX_WML0, field CH8[3:0] (RW)
 *
 * This value denotes the WML of Tx Channel 8. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH8      (0)      //!< Bit position for MIPI_HSI_TX_WML0_CH8.
#define BM_MIPI_HSI_TX_WML0_CH8      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_WML0_CH8.

//! @brief Get value of MIPI_HSI_TX_WML0_CH8 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH8) >> BP_MIPI_HSI_TX_WML0_CH8)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH8.
#define BF_MIPI_HSI_TX_WML0_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH8) & BM_MIPI_HSI_TX_WML0_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH8(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH8) | BF_MIPI_HSI_TX_WML0_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH9[7:4] (RW)
 *
 * This value denotes the WML of Tx Channel 9. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH9      (4)      //!< Bit position for MIPI_HSI_TX_WML0_CH9.
#define BM_MIPI_HSI_TX_WML0_CH9      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_WML0_CH9.

//! @brief Get value of MIPI_HSI_TX_WML0_CH9 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH9) >> BP_MIPI_HSI_TX_WML0_CH9)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH9.
#define BF_MIPI_HSI_TX_WML0_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH9) & BM_MIPI_HSI_TX_WML0_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH9(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH9) | BF_MIPI_HSI_TX_WML0_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH10[11:8] (RW)
 *
 * This value denotes the WML of Tx Channel 10. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH10      (8)      //!< Bit position for MIPI_HSI_TX_WML0_CH10.
#define BM_MIPI_HSI_TX_WML0_CH10      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_WML0_CH10.

//! @brief Get value of MIPI_HSI_TX_WML0_CH10 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH10) >> BP_MIPI_HSI_TX_WML0_CH10)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH10.
#define BF_MIPI_HSI_TX_WML0_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH10) & BM_MIPI_HSI_TX_WML0_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH10(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH10) | BF_MIPI_HSI_TX_WML0_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH11[15:12] (RW)
 *
 * This value denotes the WML of Tx Channel 11. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH11      (12)      //!< Bit position for MIPI_HSI_TX_WML0_CH11.
#define BM_MIPI_HSI_TX_WML0_CH11      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_WML0_CH11.

//! @brief Get value of MIPI_HSI_TX_WML0_CH11 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH11) >> BP_MIPI_HSI_TX_WML0_CH11)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH11.
#define BF_MIPI_HSI_TX_WML0_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH11) & BM_MIPI_HSI_TX_WML0_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH11(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH11) | BF_MIPI_HSI_TX_WML0_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH12[19:16] (RW)
 *
 * This value denotes the WML of Tx Channel 12. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH12      (16)      //!< Bit position for MIPI_HSI_TX_WML0_CH12.
#define BM_MIPI_HSI_TX_WML0_CH12      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_WML0_CH12.

//! @brief Get value of MIPI_HSI_TX_WML0_CH12 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH12) >> BP_MIPI_HSI_TX_WML0_CH12)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH12.
#define BF_MIPI_HSI_TX_WML0_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH12) & BM_MIPI_HSI_TX_WML0_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH12(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH12) | BF_MIPI_HSI_TX_WML0_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH13[23:20] (RW)
 *
 * This value denotes the WML of Tx Channel 13. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH13      (20)      //!< Bit position for MIPI_HSI_TX_WML0_CH13.
#define BM_MIPI_HSI_TX_WML0_CH13      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_WML0_CH13.

//! @brief Get value of MIPI_HSI_TX_WML0_CH13 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH13) >> BP_MIPI_HSI_TX_WML0_CH13)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH13.
#define BF_MIPI_HSI_TX_WML0_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH13) & BM_MIPI_HSI_TX_WML0_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH13(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH13) | BF_MIPI_HSI_TX_WML0_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH14[27:24] (RW)
 *
 * This value denotes the WML of Tx Channel 14. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH14      (24)      //!< Bit position for MIPI_HSI_TX_WML0_CH14.
#define BM_MIPI_HSI_TX_WML0_CH14      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_WML0_CH14.

//! @brief Get value of MIPI_HSI_TX_WML0_CH14 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH14) >> BP_MIPI_HSI_TX_WML0_CH14)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH14.
#define BF_MIPI_HSI_TX_WML0_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH14) & BM_MIPI_HSI_TX_WML0_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH14(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH14) | BF_MIPI_HSI_TX_WML0_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_WML0, field CH15[31:28] (RW)
 *
 * This value denotes the WML of Tx Channel 15. When > 1010 Reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_WML0_CH15      (28)      //!< Bit position for MIPI_HSI_TX_WML0_CH15.
#define BM_MIPI_HSI_TX_WML0_CH15      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_WML0_CH15.

//! @brief Get value of MIPI_HSI_TX_WML0_CH15 from a register value.
#define BG_MIPI_HSI_TX_WML0_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_WML0_CH15) >> BP_MIPI_HSI_TX_WML0_CH15)

//! @brief Format value for bitfield MIPI_HSI_TX_WML0_CH15.
#define BF_MIPI_HSI_TX_WML0_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_WML0_CH15) & BM_MIPI_HSI_TX_WML0_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15 field to a new value.
#define BW_MIPI_HSI_TX_WML0_CH15(v)   (HW_MIPI_HSI_TX_WML0_WR((HW_MIPI_HSI_TX_WML0_RD() & ~BM_MIPI_HSI_TX_WML0_CH15) | BF_MIPI_HSI_TX_WML0_CH15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_TML1 - HSI Tx Water Mark Level 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_TML1 - HSI Tx Water Mark Level 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains HSI controller Tx channel Water Mark Level information. This register
 * contains HSI controller Tx channel bandwidth information.
 */
typedef union _hw_mipi_hsi_tx_tml1
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_tml1_bitfields
    {
        unsigned CH0 : 4; //!< [3:0] This value denotes the WML of Tx Channel 0.
        unsigned CH1 : 4; //!< [7:4] This value denotes the WML of Tx Channel 1.
        unsigned CH2 : 4; //!< [11:8] This value denotes the WML of Tx Channel 2.
        unsigned CH3 : 4; //!< [15:12] This value denotes the WML of Tx Channel 3.
        unsigned CH4 : 4; //!< [19:16] This value denotes the WML of Tx Channel 4.
        unsigned CH5 : 4; //!< [23:20] This value denotes the WML of Tx Channel 5.
        unsigned CH6 : 4; //!< [27:24] This value denotes the WML of Tx Channel 6.
        unsigned CH7 : 4; //!< [31:28] This value denotes the WML of Tx Channel 7.
    } B;
} hw_mipi_hsi_tx_tml1_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_TML1 register
 */
//@{
#define HW_MIPI_HSI_TX_TML1_ADDR      (REGS_MIPI_HSI_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_TML1           (*(volatile hw_mipi_hsi_tx_tml1_t *) HW_MIPI_HSI_TX_TML1_ADDR)
#define HW_MIPI_HSI_TX_TML1_RD()      (HW_MIPI_HSI_TX_TML1.U)
#define HW_MIPI_HSI_TX_TML1_WR(v)     (HW_MIPI_HSI_TX_TML1.U = (v))
#define HW_MIPI_HSI_TX_TML1_SET(v)    (HW_MIPI_HSI_TX_TML1_WR(HW_MIPI_HSI_TX_TML1_RD() |  (v)))
#define HW_MIPI_HSI_TX_TML1_CLR(v)    (HW_MIPI_HSI_TX_TML1_WR(HW_MIPI_HSI_TX_TML1_RD() & ~(v)))
#define HW_MIPI_HSI_TX_TML1_TOG(v)    (HW_MIPI_HSI_TX_TML1_WR(HW_MIPI_HSI_TX_TML1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_TML1 bitfields
 */

/*! @name Register MIPI_HSI_TX_TML1, field CH0[3:0] (RW)
 *
 * This value denotes the WML of Tx Channel 0. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH0      (0)      //!< Bit position for MIPI_HSI_TX_TML1_CH0.
#define BM_MIPI_HSI_TX_TML1_CH0      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_TML1_CH0.

//! @brief Get value of MIPI_HSI_TX_TML1_CH0 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH0) >> BP_MIPI_HSI_TX_TML1_CH0)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH0.
#define BF_MIPI_HSI_TX_TML1_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH0) & BM_MIPI_HSI_TX_TML1_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH0(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH0) | BF_MIPI_HSI_TX_TML1_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH1[7:4] (RW)
 *
 * This value denotes the WML of Tx Channel 1. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH1      (4)      //!< Bit position for MIPI_HSI_TX_TML1_CH1.
#define BM_MIPI_HSI_TX_TML1_CH1      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_TML1_CH1.

//! @brief Get value of MIPI_HSI_TX_TML1_CH1 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH1) >> BP_MIPI_HSI_TX_TML1_CH1)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH1.
#define BF_MIPI_HSI_TX_TML1_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH1) & BM_MIPI_HSI_TX_TML1_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH1(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH1) | BF_MIPI_HSI_TX_TML1_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH2[11:8] (RW)
 *
 * This value denotes the WML of Tx Channel 2. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH2      (8)      //!< Bit position for MIPI_HSI_TX_TML1_CH2.
#define BM_MIPI_HSI_TX_TML1_CH2      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_TML1_CH2.

//! @brief Get value of MIPI_HSI_TX_TML1_CH2 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH2) >> BP_MIPI_HSI_TX_TML1_CH2)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH2.
#define BF_MIPI_HSI_TX_TML1_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH2) & BM_MIPI_HSI_TX_TML1_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH2(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH2) | BF_MIPI_HSI_TX_TML1_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH3[15:12] (RW)
 *
 * This value denotes the WML of Tx Channel 3. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH3      (12)      //!< Bit position for MIPI_HSI_TX_TML1_CH3.
#define BM_MIPI_HSI_TX_TML1_CH3      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_TML1_CH3.

//! @brief Get value of MIPI_HSI_TX_TML1_CH3 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH3) >> BP_MIPI_HSI_TX_TML1_CH3)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH3.
#define BF_MIPI_HSI_TX_TML1_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH3) & BM_MIPI_HSI_TX_TML1_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH3(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH3) | BF_MIPI_HSI_TX_TML1_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH4[19:16] (RW)
 *
 * This value denotes the WML of Tx Channel 4. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH4      (16)      //!< Bit position for MIPI_HSI_TX_TML1_CH4.
#define BM_MIPI_HSI_TX_TML1_CH4      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_TML1_CH4.

//! @brief Get value of MIPI_HSI_TX_TML1_CH4 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH4) >> BP_MIPI_HSI_TX_TML1_CH4)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH4.
#define BF_MIPI_HSI_TX_TML1_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH4) & BM_MIPI_HSI_TX_TML1_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH4(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH4) | BF_MIPI_HSI_TX_TML1_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH5[23:20] (RW)
 *
 * This value denotes the WML of Tx Channel 5. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH5      (20)      //!< Bit position for MIPI_HSI_TX_TML1_CH5.
#define BM_MIPI_HSI_TX_TML1_CH5      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_TML1_CH5.

//! @brief Get value of MIPI_HSI_TX_TML1_CH5 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH5) >> BP_MIPI_HSI_TX_TML1_CH5)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH5.
#define BF_MIPI_HSI_TX_TML1_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH5) & BM_MIPI_HSI_TX_TML1_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH5(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH5) | BF_MIPI_HSI_TX_TML1_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH6[27:24] (RW)
 *
 * This value denotes the WML of Tx Channel 6. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH6      (24)      //!< Bit position for MIPI_HSI_TX_TML1_CH6.
#define BM_MIPI_HSI_TX_TML1_CH6      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_TML1_CH6.

//! @brief Get value of MIPI_HSI_TX_TML1_CH6 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH6) >> BP_MIPI_HSI_TX_TML1_CH6)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH6.
#define BF_MIPI_HSI_TX_TML1_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH6) & BM_MIPI_HSI_TX_TML1_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH6(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH6) | BF_MIPI_HSI_TX_TML1_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_TML1, field CH7[31:28] (RW)
 *
 * This value denotes the WML of Tx Channel 7. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1
 * - 0001 - 2
 * - 0010 - 4
 * - 1000 - 256
 * - 1001 - 512
 * - 1010 - 1024
 */
//@{
#define BP_MIPI_HSI_TX_TML1_CH7      (28)      //!< Bit position for MIPI_HSI_TX_TML1_CH7.
#define BM_MIPI_HSI_TX_TML1_CH7      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_TML1_CH7.

//! @brief Get value of MIPI_HSI_TX_TML1_CH7 from a register value.
#define BG_MIPI_HSI_TX_TML1_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_TML1_CH7) >> BP_MIPI_HSI_TX_TML1_CH7)

//! @brief Format value for bitfield MIPI_HSI_TX_TML1_CH7.
#define BF_MIPI_HSI_TX_TML1_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_TML1_CH7) & BM_MIPI_HSI_TX_TML1_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7 field to a new value.
#define BW_MIPI_HSI_TX_TML1_CH7(v)   (HW_MIPI_HSI_TX_TML1_WR((HW_MIPI_HSI_TX_TML1_RD() & ~BM_MIPI_HSI_TX_TML1_CH7) | BF_MIPI_HSI_TX_TML1_CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_ARB_PRI0 - HSI Tx Arbiter Priority 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_ARB_PRI0 - HSI Tx Arbiter Priority 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This is HSI Tx Arbiter Priority Register.
 */
typedef union _hw_mipi_hsi_tx_arb_pri0
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_arb_pri0_bitfields
    {
        unsigned CH0 : 4; //!< [3:0] This value denotes the priority of Tx Channel 0.
        unsigned CH1 : 4; //!< [7:4] This value denotes the priority of Tx Channel 1.
        unsigned CH2 : 4; //!< [11:8] This value denotes the priority of Tx Channel 2.
        unsigned CH3 : 4; //!< [15:12] This value denotes the priority of Tx Channel 3.
        unsigned CH4 : 4; //!< [19:16] This value denotes the priority of Tx Channel 4.
        unsigned CH5 : 4; //!< [23:20] This value denotes the priority of Tx Channel 5.
        unsigned CH6 : 4; //!< [27:24] This value denotes the priority of Tx Channel 6.
        unsigned CH7 : 4; //!< [31:28] This value denotes the priority of Tx Channel 7.
    } B;
} hw_mipi_hsi_tx_arb_pri0_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_ARB_PRI0 register
 */
//@{
#define HW_MIPI_HSI_TX_ARB_PRI0_ADDR      (REGS_MIPI_HSI_BASE + 0x18)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_ARB_PRI0           (*(volatile hw_mipi_hsi_tx_arb_pri0_t *) HW_MIPI_HSI_TX_ARB_PRI0_ADDR)
#define HW_MIPI_HSI_TX_ARB_PRI0_RD()      (HW_MIPI_HSI_TX_ARB_PRI0.U)
#define HW_MIPI_HSI_TX_ARB_PRI0_WR(v)     (HW_MIPI_HSI_TX_ARB_PRI0.U = (v))
#define HW_MIPI_HSI_TX_ARB_PRI0_SET(v)    (HW_MIPI_HSI_TX_ARB_PRI0_WR(HW_MIPI_HSI_TX_ARB_PRI0_RD() |  (v)))
#define HW_MIPI_HSI_TX_ARB_PRI0_CLR(v)    (HW_MIPI_HSI_TX_ARB_PRI0_WR(HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~(v)))
#define HW_MIPI_HSI_TX_ARB_PRI0_TOG(v)    (HW_MIPI_HSI_TX_ARB_PRI0_WR(HW_MIPI_HSI_TX_ARB_PRI0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_ARB_PRI0 bitfields
 */

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH0[3:0] (RW)
 *
 * This value denotes the priority of Tx Channel 0. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH0      (0)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH0.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH0      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH0.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH0 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH0) >> BP_MIPI_HSI_TX_ARB_PRI0_CH0)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH0.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH0) & BM_MIPI_HSI_TX_ARB_PRI0_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH0(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH0) | BF_MIPI_HSI_TX_ARB_PRI0_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH1[7:4] (RW)
 *
 * This value denotes the priority of Tx Channel 1. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH1      (4)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH1.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH1      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH1.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH1 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH1) >> BP_MIPI_HSI_TX_ARB_PRI0_CH1)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH1.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH1) & BM_MIPI_HSI_TX_ARB_PRI0_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH1(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH1) | BF_MIPI_HSI_TX_ARB_PRI0_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH2[11:8] (RW)
 *
 * This value denotes the priority of Tx Channel 2. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH2      (8)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH2.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH2      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH2.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH2 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH2) >> BP_MIPI_HSI_TX_ARB_PRI0_CH2)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH2.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH2) & BM_MIPI_HSI_TX_ARB_PRI0_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH2(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH2) | BF_MIPI_HSI_TX_ARB_PRI0_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH3[15:12] (RW)
 *
 * This value denotes the priority of Tx Channel 3. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH3      (12)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH3.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH3      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH3.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH3 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH3) >> BP_MIPI_HSI_TX_ARB_PRI0_CH3)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH3.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH3) & BM_MIPI_HSI_TX_ARB_PRI0_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH3(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH3) | BF_MIPI_HSI_TX_ARB_PRI0_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH4[19:16] (RW)
 *
 * This value denotes the priority of Tx Channel 4. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH4      (16)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH4.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH4      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH4.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH4 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH4) >> BP_MIPI_HSI_TX_ARB_PRI0_CH4)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH4.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH4) & BM_MIPI_HSI_TX_ARB_PRI0_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH4(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH4) | BF_MIPI_HSI_TX_ARB_PRI0_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH5[23:20] (RW)
 *
 * This value denotes the priority of Tx Channel 5. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH5      (20)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH5.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH5      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH5.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH5 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH5) >> BP_MIPI_HSI_TX_ARB_PRI0_CH5)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH5.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH5) & BM_MIPI_HSI_TX_ARB_PRI0_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH5(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH5) | BF_MIPI_HSI_TX_ARB_PRI0_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH6[27:24] (RW)
 *
 * This value denotes the priority of Tx Channel 6. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH6      (24)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH6.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH6      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH6.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH6 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH6) >> BP_MIPI_HSI_TX_ARB_PRI0_CH6)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH6.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH6) & BM_MIPI_HSI_TX_ARB_PRI0_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH6(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH6) | BF_MIPI_HSI_TX_ARB_PRI0_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI0, field CH7[31:28] (RW)
 *
 * This value denotes the priority of Tx Channel 7. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI0_CH7      (28)      //!< Bit position for MIPI_HSI_TX_ARB_PRI0_CH7.
#define BM_MIPI_HSI_TX_ARB_PRI0_CH7      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI0_CH7.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI0_CH7 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI0_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI0_CH7) >> BP_MIPI_HSI_TX_ARB_PRI0_CH7)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI0_CH7.
#define BF_MIPI_HSI_TX_ARB_PRI0_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI0_CH7) & BM_MIPI_HSI_TX_ARB_PRI0_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI0_CH7(v)   (HW_MIPI_HSI_TX_ARB_PRI0_WR((HW_MIPI_HSI_TX_ARB_PRI0_RD() & ~BM_MIPI_HSI_TX_ARB_PRI0_CH7) | BF_MIPI_HSI_TX_ARB_PRI0_CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_ARB_PRI1 - HSI Tx Arbiter Priority 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_ARB_PRI1 - HSI Tx Arbiter Priority 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mipi_hsi_tx_arb_pri1
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_arb_pri1_bitfields
    {
        unsigned CH8 : 4; //!< [3:0] This value denotes the priority of Tx Channel 8.
        unsigned CH9 : 4; //!< [7:4] This value denotes the priority of Tx Channel 9.
        unsigned CH10 : 4; //!< [11:8] This value denotes the priority of Tx Channel 10.
        unsigned CH11 : 4; //!< [15:12] This value denotes the priority of Tx Channel 11.
        unsigned CH12 : 4; //!< [19:16] This value denotes the priority of Tx Channel 12.
        unsigned CH13 : 4; //!< [23:20] This value denotes the priority of Tx Channel 13.
        unsigned CH14 : 4; //!< [27:24] This value denotes the priority of Tx Channel 14.
        unsigned CH15 : 4; //!< [31:28] This value denotes the priority of Tx Channel 15.
    } B;
} hw_mipi_hsi_tx_arb_pri1_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_ARB_PRI1 register
 */
//@{
#define HW_MIPI_HSI_TX_ARB_PRI1_ADDR      (REGS_MIPI_HSI_BASE + 0x1c)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_ARB_PRI1           (*(volatile hw_mipi_hsi_tx_arb_pri1_t *) HW_MIPI_HSI_TX_ARB_PRI1_ADDR)
#define HW_MIPI_HSI_TX_ARB_PRI1_RD()      (HW_MIPI_HSI_TX_ARB_PRI1.U)
#define HW_MIPI_HSI_TX_ARB_PRI1_WR(v)     (HW_MIPI_HSI_TX_ARB_PRI1.U = (v))
#define HW_MIPI_HSI_TX_ARB_PRI1_SET(v)    (HW_MIPI_HSI_TX_ARB_PRI1_WR(HW_MIPI_HSI_TX_ARB_PRI1_RD() |  (v)))
#define HW_MIPI_HSI_TX_ARB_PRI1_CLR(v)    (HW_MIPI_HSI_TX_ARB_PRI1_WR(HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~(v)))
#define HW_MIPI_HSI_TX_ARB_PRI1_TOG(v)    (HW_MIPI_HSI_TX_ARB_PRI1_WR(HW_MIPI_HSI_TX_ARB_PRI1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_ARB_PRI1 bitfields
 */

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH8[3:0] (RW)
 *
 * This value denotes the priority of Tx Channel 8. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH8      (0)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH8.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH8      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH8.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH8 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH8) >> BP_MIPI_HSI_TX_ARB_PRI1_CH8)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH8.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH8) & BM_MIPI_HSI_TX_ARB_PRI1_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH8(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH8) | BF_MIPI_HSI_TX_ARB_PRI1_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH9[7:4] (RW)
 *
 * This value denotes the priority of Tx Channel 9. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH9      (4)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH9.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH9      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH9.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH9 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH9) >> BP_MIPI_HSI_TX_ARB_PRI1_CH9)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH9.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH9) & BM_MIPI_HSI_TX_ARB_PRI1_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH9(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH9) | BF_MIPI_HSI_TX_ARB_PRI1_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH10[11:8] (RW)
 *
 * This value denotes the priority of Tx Channel 10. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH10      (8)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH10.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH10      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH10.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH10 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH10) >> BP_MIPI_HSI_TX_ARB_PRI1_CH10)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH10.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH10) & BM_MIPI_HSI_TX_ARB_PRI1_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH10(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH10) | BF_MIPI_HSI_TX_ARB_PRI1_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH11[15:12] (RW)
 *
 * This value denotes the priority of Tx Channel 11. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH11      (12)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH11.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH11      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH11.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH11 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH11) >> BP_MIPI_HSI_TX_ARB_PRI1_CH11)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH11.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH11) & BM_MIPI_HSI_TX_ARB_PRI1_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH11(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH11) | BF_MIPI_HSI_TX_ARB_PRI1_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH12[19:16] (RW)
 *
 * This value denotes the priority of Tx Channel 12. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH12      (16)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH12.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH12      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH12.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH12 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH12) >> BP_MIPI_HSI_TX_ARB_PRI1_CH12)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH12.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH12) & BM_MIPI_HSI_TX_ARB_PRI1_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH12(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH12) | BF_MIPI_HSI_TX_ARB_PRI1_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH13[23:20] (RW)
 *
 * This value denotes the priority of Tx Channel 13. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH13      (20)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH13.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH13      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH13.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH13 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH13) >> BP_MIPI_HSI_TX_ARB_PRI1_CH13)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH13.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH13) & BM_MIPI_HSI_TX_ARB_PRI1_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH13(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH13) | BF_MIPI_HSI_TX_ARB_PRI1_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH14[27:24] (RW)
 *
 * This value denotes the priority of Tx Channel 14. When > 1010 reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH14      (24)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH14.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH14      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH14.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH14 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH14) >> BP_MIPI_HSI_TX_ARB_PRI1_CH14)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH14.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH14) & BM_MIPI_HSI_TX_ARB_PRI1_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH14(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH14) | BF_MIPI_HSI_TX_ARB_PRI1_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_ARB_PRI1, field CH15[31:28] (RW)
 *
 * This value denotes the priority of Tx Channel 15. When > 1010 Reserved
 *
 * Values:
 * - 0000 - 1st prioirity
 * - 0001 - 2nd priority
 * - 0010 - 3rd priority
 * - 1101 - 14th priority
 * - 1110 - 15th priority
 * - 1111 - 16th priority
 */
//@{
#define BP_MIPI_HSI_TX_ARB_PRI1_CH15      (28)      //!< Bit position for MIPI_HSI_TX_ARB_PRI1_CH15.
#define BM_MIPI_HSI_TX_ARB_PRI1_CH15      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_ARB_PRI1_CH15.

//! @brief Get value of MIPI_HSI_TX_ARB_PRI1_CH15 from a register value.
#define BG_MIPI_HSI_TX_ARB_PRI1_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_ARB_PRI1_CH15) >> BP_MIPI_HSI_TX_ARB_PRI1_CH15)

//! @brief Format value for bitfield MIPI_HSI_TX_ARB_PRI1_CH15.
#define BF_MIPI_HSI_TX_ARB_PRI1_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_ARB_PRI1_CH15) & BM_MIPI_HSI_TX_ARB_PRI1_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15 field to a new value.
#define BW_MIPI_HSI_TX_ARB_PRI1_CH15(v)   (HW_MIPI_HSI_TX_ARB_PRI1_WR((HW_MIPI_HSI_TX_ARB_PRI1_RD() & ~BM_MIPI_HSI_TX_ARB_PRI1_CH15) | BF_MIPI_HSI_TX_ARB_PRI1_CH15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_LINE_ST - HSI Line Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_LINE_ST - HSI Line Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller line status for debug.
 */
typedef union _hw_mipi_hsi_line_st
{
    reg32_t U;
    struct _hw_mipi_hsi_line_st_bitfields
    {
        unsigned TX_DATA_STATUS : 1; //!< [0] This field reflects the tx_data pin(only for debug).
        unsigned TX_FLAG_STATUS : 1; //!< [1] This field reflects the tx_flag pin(only for debug).
        unsigned TX_READY_STATUS : 1; //!< [2] This field reflects the tx_ready pin(only for debug).
        unsigned TX_WAKEUP_STATUS : 1; //!< [3] This field reflects the tx_wake pin(only for debug).
        unsigned RX_DATA_STATUS : 1; //!< [4] This field reflects the rx_data pin(only for debug).
        unsigned RX_FLAG_STATUS : 1; //!< [5] This field reflects the rx_flag pin(only for debug).
        unsigned RX_READY_STATUS : 1; //!< [6] This field reflects the rx_rdy pin(only for debug).
        unsigned RX_WAKEUP_STATUS : 1; //!< [7] This field reflects the rx_wake pin(only for debug).
        unsigned RESERVED0 : 24; //!< [31:8] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_line_st_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_LINE_ST register
 */
//@{
#define HW_MIPI_HSI_LINE_ST_ADDR      (REGS_MIPI_HSI_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_LINE_ST           (*(volatile hw_mipi_hsi_line_st_t *) HW_MIPI_HSI_LINE_ST_ADDR)
#define HW_MIPI_HSI_LINE_ST_RD()      (HW_MIPI_HSI_LINE_ST.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_LINE_ST bitfields
 */

/*! @name Register MIPI_HSI_LINE_ST, field TX_DATA_STATUS[0] (RO)
 *
 * This field reflects the tx_data pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_TX_DATA_STATUS      (0)      //!< Bit position for MIPI_HSI_LINE_ST_TX_DATA_STATUS.
#define BM_MIPI_HSI_LINE_ST_TX_DATA_STATUS      (0x00000001)  //!< Bit mask for MIPI_HSI_LINE_ST_TX_DATA_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_TX_DATA_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_TX_DATA_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_TX_DATA_STATUS) >> BP_MIPI_HSI_LINE_ST_TX_DATA_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field TX_FLAG_STATUS[1] (RO)
 *
 * This field reflects the tx_flag pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_TX_FLAG_STATUS      (1)      //!< Bit position for MIPI_HSI_LINE_ST_TX_FLAG_STATUS.
#define BM_MIPI_HSI_LINE_ST_TX_FLAG_STATUS      (0x00000002)  //!< Bit mask for MIPI_HSI_LINE_ST_TX_FLAG_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_TX_FLAG_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_TX_FLAG_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_TX_FLAG_STATUS) >> BP_MIPI_HSI_LINE_ST_TX_FLAG_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field TX_READY_STATUS[2] (RO)
 *
 * This field reflects the tx_ready pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_TX_READY_STATUS      (2)      //!< Bit position for MIPI_HSI_LINE_ST_TX_READY_STATUS.
#define BM_MIPI_HSI_LINE_ST_TX_READY_STATUS      (0x00000004)  //!< Bit mask for MIPI_HSI_LINE_ST_TX_READY_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_TX_READY_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_TX_READY_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_TX_READY_STATUS) >> BP_MIPI_HSI_LINE_ST_TX_READY_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field TX_WAKEUP_STATUS[3] (RO)
 *
 * This field reflects the tx_wake pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS      (3)      //!< Bit position for MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS.
#define BM_MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS      (0x00000008)  //!< Bit mask for MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS) >> BP_MIPI_HSI_LINE_ST_TX_WAKEUP_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field RX_DATA_STATUS[4] (RO)
 *
 * This field reflects the rx_data pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_RX_DATA_STATUS      (4)      //!< Bit position for MIPI_HSI_LINE_ST_RX_DATA_STATUS.
#define BM_MIPI_HSI_LINE_ST_RX_DATA_STATUS      (0x00000010)  //!< Bit mask for MIPI_HSI_LINE_ST_RX_DATA_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_RX_DATA_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_RX_DATA_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_RX_DATA_STATUS) >> BP_MIPI_HSI_LINE_ST_RX_DATA_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field RX_FLAG_STATUS[5] (RO)
 *
 * This field reflects the rx_flag pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_RX_FLAG_STATUS      (5)      //!< Bit position for MIPI_HSI_LINE_ST_RX_FLAG_STATUS.
#define BM_MIPI_HSI_LINE_ST_RX_FLAG_STATUS      (0x00000020)  //!< Bit mask for MIPI_HSI_LINE_ST_RX_FLAG_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_RX_FLAG_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_RX_FLAG_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_RX_FLAG_STATUS) >> BP_MIPI_HSI_LINE_ST_RX_FLAG_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field RX_READY_STATUS[6] (RO)
 *
 * This field reflects the rx_rdy pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_RX_READY_STATUS      (6)      //!< Bit position for MIPI_HSI_LINE_ST_RX_READY_STATUS.
#define BM_MIPI_HSI_LINE_ST_RX_READY_STATUS      (0x00000040)  //!< Bit mask for MIPI_HSI_LINE_ST_RX_READY_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_RX_READY_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_RX_READY_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_RX_READY_STATUS) >> BP_MIPI_HSI_LINE_ST_RX_READY_STATUS)
//@}

/*! @name Register MIPI_HSI_LINE_ST, field RX_WAKEUP_STATUS[7] (RO)
 *
 * This field reflects the rx_wake pin(only for debug).
 */
//@{
#define BP_MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS      (7)      //!< Bit position for MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS.
#define BM_MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS      (0x00000080)  //!< Bit mask for MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS.

//! @brief Get value of MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS from a register value.
#define BG_MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS) >> BP_MIPI_HSI_LINE_ST_RX_WAKEUP_STATUS)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_ID_BIT - HSI ID Bits Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_ID_BIT - HSI ID Bits Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the configurations of tx channel enable/disable, , tx wakup and tx trans
 * mode.
 */
typedef union _hw_mipi_hsi_id_bit
{
    reg32_t U;
    struct _hw_mipi_hsi_id_bit_bitfields
    {
        unsigned TX_CH : 3; //!< [2:0] This bit sets the number of channel ID bits per frame or stream for a transmit operation.
        unsigned RESERVED0 : 1; //!< [3] Reserved, always set to zero.
        unsigned RX_CH : 3; //!< [6:4] This bit sets the number of channel ID bits per frame or stream for a Receive operation.
        unsigned RESERVED1 : 25; //!< [31:7] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_id_bit_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_ID_BIT register
 */
//@{
#define HW_MIPI_HSI_ID_BIT_ADDR      (REGS_MIPI_HSI_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_ID_BIT           (*(volatile hw_mipi_hsi_id_bit_t *) HW_MIPI_HSI_ID_BIT_ADDR)
#define HW_MIPI_HSI_ID_BIT_RD()      (HW_MIPI_HSI_ID_BIT.U)
#define HW_MIPI_HSI_ID_BIT_WR(v)     (HW_MIPI_HSI_ID_BIT.U = (v))
#define HW_MIPI_HSI_ID_BIT_SET(v)    (HW_MIPI_HSI_ID_BIT_WR(HW_MIPI_HSI_ID_BIT_RD() |  (v)))
#define HW_MIPI_HSI_ID_BIT_CLR(v)    (HW_MIPI_HSI_ID_BIT_WR(HW_MIPI_HSI_ID_BIT_RD() & ~(v)))
#define HW_MIPI_HSI_ID_BIT_TOG(v)    (HW_MIPI_HSI_ID_BIT_WR(HW_MIPI_HSI_ID_BIT_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_ID_BIT bitfields
 */

/*! @name Register MIPI_HSI_ID_BIT, field TX_CH[2:0] (RW)
 *
 * This bit sets the number of channel ID bits per frame or stream for a transmit operation.
 *
 * Values:
 * - 0 - 0 bit
 * - 1 - 1 bit
 * - 2 - 2 bits
 * - 3 - 3 bits
 * - 4 - 4 bits
 */
//@{
#define BP_MIPI_HSI_ID_BIT_TX_CH      (0)      //!< Bit position for MIPI_HSI_ID_BIT_TX_CH.
#define BM_MIPI_HSI_ID_BIT_TX_CH      (0x00000007)  //!< Bit mask for MIPI_HSI_ID_BIT_TX_CH.

//! @brief Get value of MIPI_HSI_ID_BIT_TX_CH from a register value.
#define BG_MIPI_HSI_ID_BIT_TX_CH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ID_BIT_TX_CH) >> BP_MIPI_HSI_ID_BIT_TX_CH)

//! @brief Format value for bitfield MIPI_HSI_ID_BIT_TX_CH.
#define BF_MIPI_HSI_ID_BIT_TX_CH(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ID_BIT_TX_CH) & BM_MIPI_HSI_ID_BIT_TX_CH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH field to a new value.
#define BW_MIPI_HSI_ID_BIT_TX_CH(v)   (HW_MIPI_HSI_ID_BIT_WR((HW_MIPI_HSI_ID_BIT_RD() & ~BM_MIPI_HSI_ID_BIT_TX_CH) | BF_MIPI_HSI_ID_BIT_TX_CH(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ID_BIT, field RX_CH[6:4] (RW)
 *
 * This bit sets the number of channel ID bits per frame or stream for a Receive operation.
 *
 * Values:
 * - 0 - 0 bit
 * - 1 - 1 bit
 * - 2 - 2 bits
 * - 3 - 3 bits
 * - 4 - 4 bits
 */
//@{
#define BP_MIPI_HSI_ID_BIT_RX_CH      (4)      //!< Bit position for MIPI_HSI_ID_BIT_RX_CH.
#define BM_MIPI_HSI_ID_BIT_RX_CH      (0x00000070)  //!< Bit mask for MIPI_HSI_ID_BIT_RX_CH.

//! @brief Get value of MIPI_HSI_ID_BIT_RX_CH from a register value.
#define BG_MIPI_HSI_ID_BIT_RX_CH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ID_BIT_RX_CH) >> BP_MIPI_HSI_ID_BIT_RX_CH)

//! @brief Format value for bitfield MIPI_HSI_ID_BIT_RX_CH.
#define BF_MIPI_HSI_ID_BIT_RX_CH(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ID_BIT_RX_CH) & BM_MIPI_HSI_ID_BIT_RX_CH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH field to a new value.
#define BW_MIPI_HSI_ID_BIT_RX_CH(v)   (HW_MIPI_HSI_ID_BIT_WR((HW_MIPI_HSI_ID_BIT_RD() & ~BM_MIPI_HSI_ID_BIT_RX_CH) | BF_MIPI_HSI_ID_BIT_RX_CH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_FIFO_THR_CONF - Tx and Rx Fif0 Threshold Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_FIFO_THR_CONF - Tx and Rx Fif0 Threshold Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register sets the threshold level for each Tx and Rx channel fifo
 */
typedef union _hw_mipi_hsi_fifo_thr_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_fifo_thr_conf_bitfields
    {
        unsigned RX_CH0 : 1; //!< [0] 
        unsigned RX_CH1 : 1; //!< [1] 
        unsigned RX_CH2 : 1; //!< [2] 
        unsigned RX_CH3 : 1; //!< [3] 
        unsigned RX_CH4 : 1; //!< [4] 
        unsigned RX_CH5 : 1; //!< [5] 
        unsigned RX_CH6 : 1; //!< [6] 
        unsigned RX_CH7 : 1; //!< [7] 
        unsigned RX_CH8 : 1; //!< [8] 
        unsigned RX_CH9 : 1; //!< [9] 
        unsigned RX_CH10 : 1; //!< [10] 
        unsigned RX_CH11 : 1; //!< [11] 
        unsigned RX_CH12 : 1; //!< [12] 
        unsigned RX_CH13 : 1; //!< [13] 
        unsigned RX_CH14 : 1; //!< [14] 
        unsigned RX_CH15 : 1; //!< [15] 
        unsigned TX_CH0 : 1; //!< [16] 
        unsigned TX_CH1 : 1; //!< [17] 
        unsigned TX_CH2 : 1; //!< [18] 
        unsigned TX_CH3 : 1; //!< [19] 
        unsigned TX_CH4 : 1; //!< [20] 
        unsigned TX_CH5 : 1; //!< [21] 
        unsigned TX_CH6 : 1; //!< [22] 
        unsigned TX_CH7 : 1; //!< [23] 
        unsigned TX_CH8 : 1; //!< [24] 
        unsigned TX_CH9 : 1; //!< [25] 
        unsigned TX_CH10 : 1; //!< [26] 
        unsigned TX_CH11 : 1; //!< [27] 
        unsigned TX_CH12 : 1; //!< [28] 
        unsigned TX_CH13 : 1; //!< [29] 
        unsigned TX_CH14 : 1; //!< [30] 
        unsigned TX_CH15 : 1; //!< [31] 
    } B;
} hw_mipi_hsi_fifo_thr_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_FIFO_THR_CONF register
 */
//@{
#define HW_MIPI_HSI_FIFO_THR_CONF_ADDR      (REGS_MIPI_HSI_BASE + 0x28)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_FIFO_THR_CONF           (*(volatile hw_mipi_hsi_fifo_thr_conf_t *) HW_MIPI_HSI_FIFO_THR_CONF_ADDR)
#define HW_MIPI_HSI_FIFO_THR_CONF_RD()      (HW_MIPI_HSI_FIFO_THR_CONF.U)
#define HW_MIPI_HSI_FIFO_THR_CONF_WR(v)     (HW_MIPI_HSI_FIFO_THR_CONF.U = (v))
#define HW_MIPI_HSI_FIFO_THR_CONF_SET(v)    (HW_MIPI_HSI_FIFO_THR_CONF_WR(HW_MIPI_HSI_FIFO_THR_CONF_RD() |  (v)))
#define HW_MIPI_HSI_FIFO_THR_CONF_CLR(v)    (HW_MIPI_HSI_FIFO_THR_CONF_WR(HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~(v)))
#define HW_MIPI_HSI_FIFO_THR_CONF_TOG(v)    (HW_MIPI_HSI_FIFO_THR_CONF_WR(HW_MIPI_HSI_FIFO_THR_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_FIFO_THR_CONF bitfields
 */

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH0[0] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH0      (0)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH0.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH0      (0x00000001)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH0.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH0 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH0) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH0)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH0.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH0) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH0 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH0(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH0) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH1[1] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH1      (1)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH1.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH1      (0x00000002)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH1.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH1 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH1) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH1)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH1.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH1) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH1 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH1(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH1) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH2[2] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH2      (2)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH2.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH2      (0x00000004)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH2.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH2 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH2) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH2)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH2.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH2) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH2 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH2(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH2) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH3[3] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH3      (3)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH3.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH3      (0x00000008)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH3.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH3 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH3) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH3)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH3.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH3) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH3 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH3(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH3) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH4[4] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH4      (4)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH4.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH4      (0x00000010)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH4.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH4 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH4) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH4)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH4.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH4) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH4 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH4(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH4) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH5[5] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH5      (5)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH5.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH5      (0x00000020)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH5.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH5 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH5) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH5)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH5.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH5) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH5 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH5(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH5) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH6[6] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH6      (6)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH6.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH6      (0x00000040)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH6.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH6 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH6) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH6)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH6.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH6) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH6 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH6(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH6) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH7[7] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH7      (7)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH7.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH7      (0x00000080)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH7.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH7 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH7) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH7)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH7.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH7) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH7 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH7(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH7) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH8[8] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH8      (8)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH8.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH8      (0x00000100)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH8.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH8 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH8) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH8)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH8.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH8) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH8 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH8(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH8) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH9[9] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH9      (9)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH9.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH9      (0x00000200)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH9.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH9 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH9) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH9)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH9.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH9) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH9 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH9(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH9) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH10[10] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH10      (10)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH10.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH10      (0x00000400)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH10.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH10 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH10) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH10)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH10.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH10) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH10 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH10(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH10) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH11[11] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH11      (11)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH11.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH11      (0x00000800)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH11.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH11 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH11) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH11)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH11.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH11) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH11 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH11(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH11) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH12[12] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH12      (12)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH12.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH12      (0x00001000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH12.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH12 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH12) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH12)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH12.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH12) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH12 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH12(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH12) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH13[13] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH13      (13)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH13.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH13      (0x00002000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH13.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH13 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH13) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH13)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH13.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH13) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH13 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH13(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH13) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH14[14] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH14      (14)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH14.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH14      (0x00004000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH14.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH14 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH14) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH14)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH14.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH14) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH14 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH14(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH14) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field RX_CH15[15] (RW)
 *
 * Values:
 * - 0 - Half Full (fifo size / 2)
 * - 1 - Almost Full (3/4th of fifo size)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_RX_CH15      (15)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_RX_CH15.
#define BM_MIPI_HSI_FIFO_THR_CONF_RX_CH15      (0x00008000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_RX_CH15.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_RX_CH15 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_RX_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH15) >> BP_MIPI_HSI_FIFO_THR_CONF_RX_CH15)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_RX_CH15.
#define BF_MIPI_HSI_FIFO_THR_CONF_RX_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_RX_CH15) & BM_MIPI_HSI_FIFO_THR_CONF_RX_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH15 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_RX_CH15(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_RX_CH15) | BF_MIPI_HSI_FIFO_THR_CONF_RX_CH15(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH0[16] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH0      (16)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH0.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH0      (0x00010000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH0.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH0 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH0) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH0)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH0.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH0) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH0 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH0(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH0) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH1[17] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH1      (17)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH1.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH1      (0x00020000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH1.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH1 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH1) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH1)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH1.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH1) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH1 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH1(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH1) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH2[18] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH2      (18)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH2.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH2      (0x00040000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH2.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH2 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH2) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH2)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH2.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH2) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH2 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH2(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH2) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH3[19] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH3      (19)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH3.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH3      (0x00080000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH3.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH3 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH3) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH3)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH3.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH3) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH3 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH3(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH3) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH4[20] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH4      (20)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH4.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH4      (0x00100000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH4.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH4 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH4) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH4)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH4.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH4) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH4 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH4(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH4) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH5[21] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH5      (21)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH5.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH5      (0x00200000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH5.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH5 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH5) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH5)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH5.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH5) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH5 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH5(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH5) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH6[22] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH6      (22)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH6.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH6      (0x00400000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH6.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH6 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH6) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH6)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH6.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH6) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH6 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH6(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH6) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH7[23] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH7      (23)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH7.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH7      (0x00800000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH7.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH7 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH7) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH7)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH7.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH7) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH7 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH7(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH7) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH8[24] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH8      (24)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH8.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH8      (0x01000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH8.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH8 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH8) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH8)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH8.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH8) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH8 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH8(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH8) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH9[25] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH9      (25)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH9.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH9      (0x02000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH9.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH9 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH9) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH9)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH9.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH9) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH9 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH9(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH9) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH10[26] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH10      (26)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH10.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH10      (0x04000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH10.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH10 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH10) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH10)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH10.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH10) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH10 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH10(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH10) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH11[27] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH11      (27)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH11.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH11      (0x08000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH11.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH11 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH11) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH11)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH11.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH11) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH11 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH11(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH11) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH12[28] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH12      (28)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH12.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH12      (0x10000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH12.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH12 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH12) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH12)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH12.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH12) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH12 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH12(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH12) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH13[29] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH13      (29)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH13.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH13      (0x20000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH13.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH13 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH13) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH13)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH13.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH13) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH13 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH13(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH13) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH14[30] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH14      (30)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH14.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH14      (0x40000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH14.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH14 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH14) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH14)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH14.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH14) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH14 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH14(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH14) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_CONF, field TX_CH15[31] (RW)
 *
 * Values:
 * - 0 - Half Empty (fifo size / 2)
 * - 1 - Almost Empty (fifo size / 4)
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_CONF_TX_CH15      (31)      //!< Bit position for MIPI_HSI_FIFO_THR_CONF_TX_CH15.
#define BM_MIPI_HSI_FIFO_THR_CONF_TX_CH15      (0x80000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_CONF_TX_CH15.

//! @brief Get value of MIPI_HSI_FIFO_THR_CONF_TX_CH15 from a register value.
#define BG_MIPI_HSI_FIFO_THR_CONF_TX_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH15) >> BP_MIPI_HSI_FIFO_THR_CONF_TX_CH15)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_CONF_TX_CH15.
#define BF_MIPI_HSI_FIFO_THR_CONF_TX_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_CONF_TX_CH15) & BM_MIPI_HSI_FIFO_THR_CONF_TX_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH15 field to a new value.
#define BW_MIPI_HSI_FIFO_THR_CONF_TX_CH15(v)   (HW_MIPI_HSI_FIFO_THR_CONF_WR((HW_MIPI_HSI_FIFO_THR_CONF_RD() & ~BM_MIPI_HSI_FIFO_THR_CONF_TX_CH15) | BF_MIPI_HSI_FIFO_THR_CONF_TX_CH15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_CH_SFTRST - Tx and Rx Channel Soft Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_CH_SFTRST - Tx and Rx Channel Soft Reset Register (WO)
 *
 * Reset value: 0x00000000
 *
 * This register is used to reset each Tx and Rx Channel
 */
typedef union _hw_mipi_hsi_ch_sftrst
{
    reg32_t U;
    struct _hw_mipi_hsi_ch_sftrst_bitfields
    {
        unsigned RX_CH0 : 1; //!< [0] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH1 : 1; //!< [1] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH2 : 1; //!< [2] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH3 : 1; //!< [3] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH4 : 1; //!< [4] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH5 : 1; //!< [5] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH6 : 1; //!< [6] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH7 : 1; //!< [7] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH8 : 1; //!< [8] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH9 : 1; //!< [9] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH10 : 1; //!< [10] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH11 : 1; //!< [11] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH12 : 1; //!< [12] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH13 : 1; //!< [13] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH14 : 1; //!< [14] Set this bit to zero to enable normal HSI operation.
        unsigned RX_CH15 : 1; //!< [15] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH0 : 1; //!< [16] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH1 : 1; //!< [17] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH2 : 1; //!< [18] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH3 : 1; //!< [19] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH4 : 1; //!< [20] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH5 : 1; //!< [21] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH6 : 1; //!< [22] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH7 : 1; //!< [23] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH8 : 1; //!< [24] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH9 : 1; //!< [25] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH10 : 1; //!< [26] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH11 : 1; //!< [27] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH12 : 1; //!< [28] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH13 : 1; //!< [29] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH14 : 1; //!< [30] Set this bit to zero to enable normal HSI operation.
        unsigned TX_CH15 : 1; //!< [31] Set this bit to zero to enable normal HSI operation.
    } B;
} hw_mipi_hsi_ch_sftrst_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_CH_SFTRST register
 */
//@{
#define HW_MIPI_HSI_CH_SFTRST_ADDR      (REGS_MIPI_HSI_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_CH_SFTRST           (*(volatile hw_mipi_hsi_ch_sftrst_t *) HW_MIPI_HSI_CH_SFTRST_ADDR)
#define HW_MIPI_HSI_CH_SFTRST_WR(v)     (HW_MIPI_HSI_CH_SFTRST.U = (v))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_CH_SFTRST bitfields
 */

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH0[0] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 0
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH0      (0)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH0.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH0      (0x00000001)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH0.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH0 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH0) >> BP_MIPI_HSI_CH_SFTRST_RX_CH0)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH0.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH0) & BM_MIPI_HSI_CH_SFTRST_RX_CH0)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH1[1] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 1
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH1      (1)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH1.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH1      (0x00000002)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH1.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH1 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH1) >> BP_MIPI_HSI_CH_SFTRST_RX_CH1)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH1.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH1) & BM_MIPI_HSI_CH_SFTRST_RX_CH1)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH2[2] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 2
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH2      (2)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH2.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH2      (0x00000004)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH2.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH2 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH2) >> BP_MIPI_HSI_CH_SFTRST_RX_CH2)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH2.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH2) & BM_MIPI_HSI_CH_SFTRST_RX_CH2)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH3[3] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 3
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH3      (3)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH3.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH3      (0x00000008)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH3.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH3 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH3) >> BP_MIPI_HSI_CH_SFTRST_RX_CH3)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH3.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH3) & BM_MIPI_HSI_CH_SFTRST_RX_CH3)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH4[4] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 4
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH4      (4)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH4.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH4      (0x00000010)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH4.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH4 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH4) >> BP_MIPI_HSI_CH_SFTRST_RX_CH4)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH4.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH4) & BM_MIPI_HSI_CH_SFTRST_RX_CH4)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH5[5] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 5
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH5      (5)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH5.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH5      (0x00000020)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH5.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH5 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH5) >> BP_MIPI_HSI_CH_SFTRST_RX_CH5)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH5.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH5) & BM_MIPI_HSI_CH_SFTRST_RX_CH5)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH6[6] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 6
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH6      (6)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH6.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH6      (0x00000040)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH6.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH6 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH6) >> BP_MIPI_HSI_CH_SFTRST_RX_CH6)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH6.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH6) & BM_MIPI_HSI_CH_SFTRST_RX_CH6)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH7[7] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 7
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH7      (7)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH7.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH7      (0x00000080)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH7.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH7 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH7) >> BP_MIPI_HSI_CH_SFTRST_RX_CH7)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH7.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH7) & BM_MIPI_HSI_CH_SFTRST_RX_CH7)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH8[8] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 8
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH8      (8)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH8.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH8      (0x00000100)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH8.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH8 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH8) >> BP_MIPI_HSI_CH_SFTRST_RX_CH8)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH8.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH8) & BM_MIPI_HSI_CH_SFTRST_RX_CH8)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH9[9] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 9
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH9      (9)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH9.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH9      (0x00000200)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH9.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH9 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH9) >> BP_MIPI_HSI_CH_SFTRST_RX_CH9)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH9.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH9) & BM_MIPI_HSI_CH_SFTRST_RX_CH9)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH10[10] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 10
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH10      (10)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH10.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH10      (0x00000400)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH10.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH10 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH10) >> BP_MIPI_HSI_CH_SFTRST_RX_CH10)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH10.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH10) & BM_MIPI_HSI_CH_SFTRST_RX_CH10)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH11[11] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 11
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH11      (11)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH11.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH11      (0x00000800)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH11.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH11 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH11) >> BP_MIPI_HSI_CH_SFTRST_RX_CH11)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH11.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH11) & BM_MIPI_HSI_CH_SFTRST_RX_CH11)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH12[12] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 12
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH12      (12)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH12.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH12      (0x00001000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH12.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH12 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH12) >> BP_MIPI_HSI_CH_SFTRST_RX_CH12)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH12.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH12) & BM_MIPI_HSI_CH_SFTRST_RX_CH12)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH13[13] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 13
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH13      (13)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH13.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH13      (0x00002000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH13.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH13 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH13) >> BP_MIPI_HSI_CH_SFTRST_RX_CH13)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH13.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH13) & BM_MIPI_HSI_CH_SFTRST_RX_CH13)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH14[14] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 14
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH14      (14)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH14.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH14      (0x00004000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH14.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH14 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH14) >> BP_MIPI_HSI_CH_SFTRST_RX_CH14)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH14.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH14) & BM_MIPI_HSI_CH_SFTRST_RX_CH14)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field RX_CH15[15] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Rx Channel 15
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_RX_CH15      (15)      //!< Bit position for MIPI_HSI_CH_SFTRST_RX_CH15.
#define BM_MIPI_HSI_CH_SFTRST_RX_CH15      (0x00008000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_RX_CH15.

//! @brief Get value of MIPI_HSI_CH_SFTRST_RX_CH15 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_RX_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_RX_CH15) >> BP_MIPI_HSI_CH_SFTRST_RX_CH15)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_RX_CH15.
#define BF_MIPI_HSI_CH_SFTRST_RX_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_RX_CH15) & BM_MIPI_HSI_CH_SFTRST_RX_CH15)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH0[16] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 0
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH0      (16)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH0.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH0      (0x00010000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH0.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH0 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH0) >> BP_MIPI_HSI_CH_SFTRST_TX_CH0)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH0.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH0) & BM_MIPI_HSI_CH_SFTRST_TX_CH0)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH1[17] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 1
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH1      (17)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH1.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH1      (0x00020000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH1.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH1 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH1) >> BP_MIPI_HSI_CH_SFTRST_TX_CH1)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH1.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH1) & BM_MIPI_HSI_CH_SFTRST_TX_CH1)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH2[18] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 2
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH2      (18)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH2.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH2      (0x00040000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH2.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH2 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH2) >> BP_MIPI_HSI_CH_SFTRST_TX_CH2)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH2.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH2) & BM_MIPI_HSI_CH_SFTRST_TX_CH2)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH3[19] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 3
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH3      (19)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH3.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH3      (0x00080000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH3.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH3 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH3) >> BP_MIPI_HSI_CH_SFTRST_TX_CH3)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH3.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH3) & BM_MIPI_HSI_CH_SFTRST_TX_CH3)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH4[20] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 4
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH4      (20)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH4.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH4      (0x00100000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH4.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH4 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH4) >> BP_MIPI_HSI_CH_SFTRST_TX_CH4)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH4.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH4) & BM_MIPI_HSI_CH_SFTRST_TX_CH4)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH5[21] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 5
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH5      (21)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH5.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH5      (0x00200000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH5.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH5 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH5) >> BP_MIPI_HSI_CH_SFTRST_TX_CH5)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH5.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH5) & BM_MIPI_HSI_CH_SFTRST_TX_CH5)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH6[22] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 6
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH6      (22)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH6.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH6      (0x00400000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH6.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH6 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH6) >> BP_MIPI_HSI_CH_SFTRST_TX_CH6)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH6.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH6) & BM_MIPI_HSI_CH_SFTRST_TX_CH6)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH7[23] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 7
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH7      (23)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH7.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH7      (0x00800000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH7.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH7 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH7) >> BP_MIPI_HSI_CH_SFTRST_TX_CH7)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH7.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH7) & BM_MIPI_HSI_CH_SFTRST_TX_CH7)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH8[24] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 8
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH8      (24)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH8.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH8      (0x01000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH8.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH8 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH8) >> BP_MIPI_HSI_CH_SFTRST_TX_CH8)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH8.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH8) & BM_MIPI_HSI_CH_SFTRST_TX_CH8)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH9[25] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 9
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH9      (25)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH9.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH9      (0x02000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH9.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH9 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH9) >> BP_MIPI_HSI_CH_SFTRST_TX_CH9)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH9.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH9) & BM_MIPI_HSI_CH_SFTRST_TX_CH9)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH10[26] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 10
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH10      (26)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH10.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH10      (0x04000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH10.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH10 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH10) >> BP_MIPI_HSI_CH_SFTRST_TX_CH10)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH10.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH10) & BM_MIPI_HSI_CH_SFTRST_TX_CH10)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH11[27] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 11
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH11      (27)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH11.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH11      (0x08000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH11.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH11 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH11) >> BP_MIPI_HSI_CH_SFTRST_TX_CH11)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH11.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH11) & BM_MIPI_HSI_CH_SFTRST_TX_CH11)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH12[28] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 12
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH12      (28)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH12.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH12      (0x10000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH12.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH12 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH12) >> BP_MIPI_HSI_CH_SFTRST_TX_CH12)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH12.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH12) & BM_MIPI_HSI_CH_SFTRST_TX_CH12)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH13[29] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 13
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH13      (29)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH13.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH13      (0x20000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH13.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH13 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH13) >> BP_MIPI_HSI_CH_SFTRST_TX_CH13)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH13.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH13) & BM_MIPI_HSI_CH_SFTRST_TX_CH13)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH14[30] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 14
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH14      (30)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH14.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH14      (0x40000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH14.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH14 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH14) >> BP_MIPI_HSI_CH_SFTRST_TX_CH14)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH14.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH14) & BM_MIPI_HSI_CH_SFTRST_TX_CH14)
//@}

/*! @name Register MIPI_HSI_CH_SFTRST, field TX_CH15[31] (WO)
 *
 * Set this bit to zero to enable normal HSI operation. Set this bit to one to reset Tx Channel 15
 * (DMA and Fifo). When the reset operation complete, this bit will turn to zero automatically.
 */
//@{
#define BP_MIPI_HSI_CH_SFTRST_TX_CH15      (31)      //!< Bit position for MIPI_HSI_CH_SFTRST_TX_CH15.
#define BM_MIPI_HSI_CH_SFTRST_TX_CH15      (0x80000000)  //!< Bit mask for MIPI_HSI_CH_SFTRST_TX_CH15.

//! @brief Get value of MIPI_HSI_CH_SFTRST_TX_CH15 from a register value.
#define BG_MIPI_HSI_CH_SFTRST_TX_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_CH_SFTRST_TX_CH15) >> BP_MIPI_HSI_CH_SFTRST_TX_CH15)

//! @brief Format value for bitfield MIPI_HSI_CH_SFTRST_TX_CH15.
#define BF_MIPI_HSI_CH_SFTRST_TX_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_CH_SFTRST_TX_CH15) & BM_MIPI_HSI_CH_SFTRST_TX_CH15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_IRQSTAT - HSI Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_IRQSTAT - HSI Interrupt Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This is HSI controller Interrupt Status Register. This register contains the HSI controller
 * Interrupt Status.
 */
typedef union _hw_mipi_hsi_irqstat
{
    reg32_t U;
    struct _hw_mipi_hsi_irqstat_bitfields
    {
        unsigned FIFO_THRESHOLD_INT : 1; //!< [0] 
        unsigned RX_WAKEUP_INT : 1; //!< [1] 
        unsigned RX_TIMEOUT_INT : 1; //!< [2] If any bit in the HSI Error Interrupt Status Register is set, then this bit is set.
        unsigned DMA_INT : 1; //!< [3] This bit is set when a Transmit or Receive Operation is completed for DMA.
        unsigned DMA_ERR_INT : 1; //!< [4] If any bit in the DMA Error Interrupt Status Register is set, then this bit is set.
        unsigned TX_TIMEOUT_ERR_INT : 1; //!< [5] 
        unsigned RX_ERROR_INT : 1; //!< [6] 
        unsigned RX_BREAK_INT : 1; //!< [7] 
        unsigned TX_EMPTY_INT : 1; //!< [8] 
        unsigned RESERVED0 : 23; //!< [31:9] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_IRQSTAT register
 */
//@{
#define HW_MIPI_HSI_IRQSTAT_ADDR      (REGS_MIPI_HSI_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_IRQSTAT           (*(volatile hw_mipi_hsi_irqstat_t *) HW_MIPI_HSI_IRQSTAT_ADDR)
#define HW_MIPI_HSI_IRQSTAT_RD()      (HW_MIPI_HSI_IRQSTAT.U)
#define HW_MIPI_HSI_IRQSTAT_WR(v)     (HW_MIPI_HSI_IRQSTAT.U = (v))
#define HW_MIPI_HSI_IRQSTAT_SET(v)    (HW_MIPI_HSI_IRQSTAT_WR(HW_MIPI_HSI_IRQSTAT_RD() |  (v)))
#define HW_MIPI_HSI_IRQSTAT_CLR(v)    (HW_MIPI_HSI_IRQSTAT_WR(HW_MIPI_HSI_IRQSTAT_RD() & ~(v)))
#define HW_MIPI_HSI_IRQSTAT_TOG(v)    (HW_MIPI_HSI_IRQSTAT_WR(HW_MIPI_HSI_IRQSTAT_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_IRQSTAT bitfields
 */

/*! @name Register MIPI_HSI_IRQSTAT, field FIFO_THRESHOLD_INT[0] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in TX/Rx FIFO Interrupt Status
 * - 1 - Threshold amount of data reached in TX/Rx FIFO Interrupt Status
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT      (0)      //!< Bit position for MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT.
#define BM_MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT) >> BP_MIPI_HSI_IRQSTAT_FIFO_THRESHOLD_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field RX_WAKEUP_INT[1] (WO)
 *
 * Values:
 * - 0 - Receiver Wakeup event is not occurred
 * - 1 - Receiver Wakeup event is occurred
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT      (1)      //!< Bit position for MIPI_HSI_IRQSTAT_RX_WAKEUP_INT.
#define BM_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_IRQSTAT_RX_WAKEUP_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_RX_WAKEUP_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT) >> BP_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_RX_WAKEUP_INT.
#define BF_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT) & BM_MIPI_HSI_IRQSTAT_RX_WAKEUP_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field RX_TIMEOUT_INT[2] (RO)
 *
 * If any bit in the HSI Error Interrupt Status Register is set, then this bit is set. on seeing
 * this bit set, the ocp driver will read the Error Interrupt Staus Register.
 *
 * Values:
 * - 0 - No Error.
 * - 1 - Error.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT      (2)      //!< Bit position for MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT.
#define BM_MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT) >> BP_MIPI_HSI_IRQSTAT_RX_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field DMA_INT[3] (RO)
 *
 * This bit is set when a Transmit or Receive Operation is completed for DMA.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_DMA_INT      (3)      //!< Bit position for MIPI_HSI_IRQSTAT_DMA_INT.
#define BM_MIPI_HSI_IRQSTAT_DMA_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_IRQSTAT_DMA_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_DMA_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_DMA_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_DMA_INT) >> BP_MIPI_HSI_IRQSTAT_DMA_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field DMA_ERR_INT[4] (RO)
 *
 * If any bit in the DMA Error Interrupt Status Register is set, then this bit is set. on seeing
 * this bit set, the ocp driver will read the Error Interrupt Staus Register.
 *
 * Values:
 * - 0 - No Error.
 * - 1 - Error.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_DMA_ERR_INT      (4)      //!< Bit position for MIPI_HSI_IRQSTAT_DMA_ERR_INT.
#define BM_MIPI_HSI_IRQSTAT_DMA_ERR_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_IRQSTAT_DMA_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_DMA_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_DMA_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_DMA_ERR_INT) >> BP_MIPI_HSI_IRQSTAT_DMA_ERR_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field TX_TIMEOUT_ERR_INT[5] (WO)
 *
 * Values:
 * - 0 - No Error.
 * - 1 - Error.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT      (5)      //!< Bit position for MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT.
#define BM_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT) >> BP_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT.
#define BF_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT) & BM_MIPI_HSI_IRQSTAT_TX_TIMEOUT_ERR_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field RX_ERROR_INT[6] (WO)
 *
 * Values:
 * - 0 - No Error.
 * - 1 - Error.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_RX_ERROR_INT      (6)      //!< Bit position for MIPI_HSI_IRQSTAT_RX_ERROR_INT.
#define BM_MIPI_HSI_IRQSTAT_RX_ERROR_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_IRQSTAT_RX_ERROR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_RX_ERROR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_RX_ERROR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_RX_ERROR_INT) >> BP_MIPI_HSI_IRQSTAT_RX_ERROR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_RX_ERROR_INT.
#define BF_MIPI_HSI_IRQSTAT_RX_ERROR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_RX_ERROR_INT) & BM_MIPI_HSI_IRQSTAT_RX_ERROR_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field RX_BREAK_INT[7] (WO)
 *
 * Values:
 * - 0 - No Error.
 * - 1 - Error.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_RX_BREAK_INT      (7)      //!< Bit position for MIPI_HSI_IRQSTAT_RX_BREAK_INT.
#define BM_MIPI_HSI_IRQSTAT_RX_BREAK_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_IRQSTAT_RX_BREAK_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_RX_BREAK_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_RX_BREAK_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_RX_BREAK_INT) >> BP_MIPI_HSI_IRQSTAT_RX_BREAK_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_RX_BREAK_INT.
#define BF_MIPI_HSI_IRQSTAT_RX_BREAK_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_RX_BREAK_INT) & BM_MIPI_HSI_IRQSTAT_RX_BREAK_INT)
//@}

/*! @name Register MIPI_HSI_IRQSTAT, field TX_EMPTY_INT[8] (RO)
 *
 * Values:
 * - 0 - not All tx channel empty and tx state IDLE Interrupt Status
 * - 1 - All tx channel empty and tx state IDLE Interrupt Status
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_TX_EMPTY_INT      (8)      //!< Bit position for MIPI_HSI_IRQSTAT_TX_EMPTY_INT.
#define BM_MIPI_HSI_IRQSTAT_TX_EMPTY_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_IRQSTAT_TX_EMPTY_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_TX_EMPTY_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_TX_EMPTY_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_TX_EMPTY_INT) >> BP_MIPI_HSI_IRQSTAT_TX_EMPTY_INT)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_IRQSTAT_EN - HSI Interrupt Status Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_IRQSTAT_EN - HSI Interrupt Status Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller Interrupt Status Enable.
 */
typedef union _hw_mipi_hsi_irqstat_en
{
    reg32_t U;
    struct _hw_mipi_hsi_irqstat_en_bitfields
    {
        unsigned FIFO_THRESHOLD_INT : 1; //!< [0] 
        unsigned RX_WAKEUP_INT : 1; //!< [1] 
        unsigned RX_TIMEOUT_INT : 1; //!< [2] 
        unsigned DMA_INT : 1; //!< [3] 
        unsigned DMA_ERR_INT : 1; //!< [4] 
        unsigned TX_TIMEOUT_ERR_INT : 1; //!< [5] 
        unsigned RX_ERROR_INT : 1; //!< [6] 
        unsigned RX_BREAK_INT : 1; //!< [7] 
        unsigned TX_EMPTY_INT : 1; //!< [8] 
        unsigned RESERVED0 : 23; //!< [31:9] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_irqstat_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_IRQSTAT_EN register
 */
//@{
#define HW_MIPI_HSI_IRQSTAT_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x34)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_IRQSTAT_EN           (*(volatile hw_mipi_hsi_irqstat_en_t *) HW_MIPI_HSI_IRQSTAT_EN_ADDR)
#define HW_MIPI_HSI_IRQSTAT_EN_RD()      (HW_MIPI_HSI_IRQSTAT_EN.U)
#define HW_MIPI_HSI_IRQSTAT_EN_WR(v)     (HW_MIPI_HSI_IRQSTAT_EN.U = (v))
#define HW_MIPI_HSI_IRQSTAT_EN_SET(v)    (HW_MIPI_HSI_IRQSTAT_EN_WR(HW_MIPI_HSI_IRQSTAT_EN_RD() |  (v)))
#define HW_MIPI_HSI_IRQSTAT_EN_CLR(v)    (HW_MIPI_HSI_IRQSTAT_EN_WR(HW_MIPI_HSI_IRQSTAT_EN_RD() & ~(v)))
#define HW_MIPI_HSI_IRQSTAT_EN_TOG(v)    (HW_MIPI_HSI_IRQSTAT_EN_WR(HW_MIPI_HSI_IRQSTAT_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_IRQSTAT_EN bitfields
 */

/*! @name Register MIPI_HSI_IRQSTAT_EN, field FIFO_THRESHOLD_INT[0] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked FIFO_THRESHOLD_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for FIFO_THRESHOLD_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT      (0)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT) >> BP_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT) & BM_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_THRESHOLD_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT) | BF_MIPI_HSI_IRQSTAT_EN_FIFO_THRESHOLD_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field RX_WAKEUP_INT[1] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked RX_WAKEUP_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for RX_WAKEUP_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT      (1)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT) >> BP_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT) & BM_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_WAKEUP_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT) | BF_MIPI_HSI_IRQSTAT_EN_RX_WAKEUP_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field RX_TIMEOUT_INT[2] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked RX_TIMEOUT_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for RX_TIMEOUT_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT      (2)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT) >> BP_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT) & BM_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_TIMEOUT_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT) | BF_MIPI_HSI_IRQSTAT_EN_RX_TIMEOUT_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field DMA_INT[3] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked DMA_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for DMA_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_DMA_INT      (3)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_DMA_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_DMA_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_DMA_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_DMA_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_DMA_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_DMA_INT) >> BP_MIPI_HSI_IRQSTAT_EN_DMA_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_DMA_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_DMA_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_DMA_INT) & BM_MIPI_HSI_IRQSTAT_EN_DMA_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_DMA_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_DMA_INT) | BF_MIPI_HSI_IRQSTAT_EN_DMA_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field DMA_ERR_INT[4] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked DMA_ERROR_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for DMA_ERROR_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT      (4)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT) >> BP_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT) & BM_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_ERR_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT) | BF_MIPI_HSI_IRQSTAT_EN_DMA_ERR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field TX_TIMEOUT_ERR_INT[5] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked TX_TIMEOUT_ERR status interrupt.
 * - 1 - Interrupt status enabled for TX_TIMEOUT_ERR status interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT      (5)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT) >> BP_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT) & BM_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_TIMEOUT_ERR_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT) | BF_MIPI_HSI_IRQSTAT_EN_TX_TIMEOUT_ERR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field RX_ERROR_INT[6] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked RX_ERROR status interrupt.
 * - 1 - Interrupt status enabled for RX_ERROR status interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT      (6)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT) >> BP_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT) & BM_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_ERROR_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT) | BF_MIPI_HSI_IRQSTAT_EN_RX_ERROR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field RX_BREAK_INT[7] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked RX_BREAK status interrupt.
 * - 1 - Interrupt status enabled for RX_BREAK status interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT      (7)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT) >> BP_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT) & BM_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_BREAK_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT) | BF_MIPI_HSI_IRQSTAT_EN_RX_BREAK_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSTAT_EN, field TX_EMPTY_INT[8] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked TX_EMPTY_INT_STATUS interrupt.
 * - 1 - Interrupt status enabled for TX_EMPTY_INT_STATUS interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT      (8)      //!< Bit position for MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT.
#define BM_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT.

//! @brief Get value of MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT from a register value.
#define BG_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT) >> BP_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT.
#define BF_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT) & BM_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_EMPTY_INT field to a new value.
#define BW_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT(v)   (HW_MIPI_HSI_IRQSTAT_EN_WR((HW_MIPI_HSI_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT) | BF_MIPI_HSI_IRQSTAT_EN_TX_EMPTY_INT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_IRQSIG_EN - HSI Interrupt Signal Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_IRQSIG_EN - HSI Interrupt Signal Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller Interrupt Signal Enable.
 */
typedef union _hw_mipi_hsi_irqsig_en
{
    reg32_t U;
    struct _hw_mipi_hsi_irqsig_en_bitfields
    {
        unsigned FIFO_THRESHOLD_INT : 1; //!< [0] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_WAKEUP_INT : 1; //!< [1] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_TIMEOUT_INT : 1; //!< [2] Setting this bit will enable interrupt generation on interrupt line.
        unsigned DMA_INT : 1; //!< [3] Setting this bit will enable interrupt generation on interrupt line.
        unsigned DMA_ERR_INT : 1; //!< [4] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_TIMEOUT_ERR_INT : 1; //!< [5] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_ERROR_INT : 1; //!< [6] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_BREAK_INT : 1; //!< [7] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_EMPTY_INT : 1; //!< [8] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RESERVED0 : 23; //!< [31:9] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_irqsig_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_IRQSIG_EN register
 */
//@{
#define HW_MIPI_HSI_IRQSIG_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x38)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_IRQSIG_EN           (*(volatile hw_mipi_hsi_irqsig_en_t *) HW_MIPI_HSI_IRQSIG_EN_ADDR)
#define HW_MIPI_HSI_IRQSIG_EN_RD()      (HW_MIPI_HSI_IRQSIG_EN.U)
#define HW_MIPI_HSI_IRQSIG_EN_WR(v)     (HW_MIPI_HSI_IRQSIG_EN.U = (v))
#define HW_MIPI_HSI_IRQSIG_EN_SET(v)    (HW_MIPI_HSI_IRQSIG_EN_WR(HW_MIPI_HSI_IRQSIG_EN_RD() |  (v)))
#define HW_MIPI_HSI_IRQSIG_EN_CLR(v)    (HW_MIPI_HSI_IRQSIG_EN_WR(HW_MIPI_HSI_IRQSIG_EN_RD() & ~(v)))
#define HW_MIPI_HSI_IRQSIG_EN_TOG(v)    (HW_MIPI_HSI_IRQSIG_EN_WR(HW_MIPI_HSI_IRQSIG_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_IRQSIG_EN bitfields
 */

/*! @name Register MIPI_HSI_IRQSIG_EN, field FIFO_THRESHOLD_INT[0] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for HSI FIFO_THRESHOLD interrupt.
 * - 1 - Interrupt signal enabled for HSI FIFO_THRESHOLD interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT      (0)      //!< Bit position for MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT.
#define BM_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT) >> BP_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT.
#define BF_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT) & BM_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_THRESHOLD_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT) | BF_MIPI_HSI_IRQSIG_EN_FIFO_THRESHOLD_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field RX_WAKEUP_INT[1] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for HSI RX Wakeup interrupt.
 * - 1 - Interrupt signal enabled for HSI RX Wakeup interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT      (1)      //!< Bit position for MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT.
#define BM_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT) >> BP_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT.
#define BF_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT) & BM_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_WAKEUP_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT) | BF_MIPI_HSI_IRQSIG_EN_RX_WAKEUP_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field RX_TIMEOUT_INT[2] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for RX TIMEOUT interrupt.
 * - 1 - Interrupt signal enabled for RX TIMEOUT interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT      (2)      //!< Bit position for MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT.
#define BM_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT) >> BP_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT.
#define BF_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT) & BM_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_TIMEOUT_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT) | BF_MIPI_HSI_IRQSIG_EN_RX_TIMEOUT_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field DMA_INT[3] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for DMA Completed interrupt.
 * - 1 - Interrupt signal enabled for DMA Completed interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_DMA_INT      (3)      //!< Bit position for MIPI_HSI_IRQSIG_EN_DMA_INT.
#define BM_MIPI_HSI_IRQSIG_EN_DMA_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_DMA_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_DMA_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_DMA_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_DMA_INT) >> BP_MIPI_HSI_IRQSIG_EN_DMA_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_DMA_INT.
#define BF_MIPI_HSI_IRQSIG_EN_DMA_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_DMA_INT) & BM_MIPI_HSI_IRQSIG_EN_DMA_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_DMA_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_DMA_INT) | BF_MIPI_HSI_IRQSIG_EN_DMA_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field DMA_ERR_INT[4] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for DMA Error interrupt.
 * - 1 - Interrupt signal enabled for DMA Error interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT      (4)      //!< Bit position for MIPI_HSI_IRQSIG_EN_DMA_ERR_INT.
#define BM_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_DMA_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_DMA_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT) >> BP_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_DMA_ERR_INT.
#define BF_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT) & BM_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_ERR_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT) | BF_MIPI_HSI_IRQSIG_EN_DMA_ERR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field TX_TIMEOUT_ERR_INT[5] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for TX Timeout Error interrupt.
 * - 1 - Interrupt signal enabled for TX Timeout Error interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT      (5)      //!< Bit position for MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT.
#define BM_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT) >> BP_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT.
#define BF_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT) & BM_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_TIMEOUT_ERR_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT) | BF_MIPI_HSI_IRQSIG_EN_TX_TIMEOUT_ERR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field RX_ERROR_INT[6] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for RX Error interrupt.
 * - 1 - Interrupt signal enabled for RX Error interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT      (6)      //!< Bit position for MIPI_HSI_IRQSIG_EN_RX_ERROR_INT.
#define BM_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_RX_ERROR_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_RX_ERROR_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT) >> BP_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_RX_ERROR_INT.
#define BF_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT) & BM_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_ERROR_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT) | BF_MIPI_HSI_IRQSIG_EN_RX_ERROR_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field RX_BREAK_INT[7] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for RX_BREAK interrupt.
 * - 1 - Interrupt signal enabled for RX_BREAK interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT      (7)      //!< Bit position for MIPI_HSI_IRQSIG_EN_RX_BREAK_INT.
#define BM_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_RX_BREAK_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_RX_BREAK_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT) >> BP_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_RX_BREAK_INT.
#define BF_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT) & BM_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_BREAK_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT) | BF_MIPI_HSI_IRQSIG_EN_RX_BREAK_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_IRQSIG_EN, field TX_EMPTY_INT[8] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for HSI TX_EMPTY interrupt.
 * - 1 - Interrupt signal enabled for HSI TX_EMPTY interrupt.
 */
//@{
#define BP_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT      (8)      //!< Bit position for MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT.
#define BM_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT.

//! @brief Get value of MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT from a register value.
#define BG_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT) >> BP_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT)

//! @brief Format value for bitfield MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT.
#define BF_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT) & BM_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_EMPTY_INT field to a new value.
#define BW_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT(v)   (HW_MIPI_HSI_IRQSIG_EN_WR((HW_MIPI_HSI_IRQSIG_EN_RD() & ~BM_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT) | BF_MIPI_HSI_IRQSIG_EN_TX_EMPTY_INT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_FIFO_THR_IRQSTAT - HSI FIFO Threshold Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_FIFO_THR_IRQSTAT - HSI FIFO Threshold Interrupt Status Register (RO)
 *
 * Reset value: 0xffff0000
 *
 * This register contains the HSI controller FIFO Threshold Interrupt Status.
 */
typedef union _hw_mipi_hsi_fifo_thr_irqstat
{
    reg32_t U;
    struct _hw_mipi_hsi_fifo_thr_irqstat_bitfields
    {
        unsigned RX_CH0_INT : 1; //!< [0] 
        unsigned RX_CH1_INT : 1; //!< [1] 
        unsigned RX_CH2_INT : 1; //!< [2] 
        unsigned RX_CH3_INT : 1; //!< [3] 
        unsigned RX_CH4_INT : 1; //!< [4] 
        unsigned RX_CH5_INT : 1; //!< [5] 
        unsigned RX_CH6_INT : 1; //!< [6] 
        unsigned RX_CH7_INT : 1; //!< [7] 
        unsigned RX_CH8_INT : 1; //!< [8] 
        unsigned RX_CH9_INT : 1; //!< [9] 
        unsigned RX_CH10_INT : 1; //!< [10] 
        unsigned RX_CH11_INT : 1; //!< [11] 
        unsigned RX_CH12_INT : 1; //!< [12] 
        unsigned RX_CH13_INT : 1; //!< [13] 
        unsigned RX_CH14_INT : 1; //!< [14] 
        unsigned RX_CH15_INT : 1; //!< [15] 
        unsigned TX_CH0_INT : 1; //!< [16] 
        unsigned TX_CH1_INT : 1; //!< [17] 
        unsigned TX_CH2_INT : 1; //!< [18] 
        unsigned TX_CH3_INT : 1; //!< [19] 
        unsigned TX_CH4_INT : 1; //!< [20] 
        unsigned TX_CH5_INT : 1; //!< [21] 
        unsigned TX_CH6_INT : 1; //!< [22] 
        unsigned TX_CH7_INT : 1; //!< [23] 
        unsigned TX_CH8_INT : 1; //!< [24] 
        unsigned TX_CH9_INT : 1; //!< [25] 
        unsigned TX_CH10_INT : 1; //!< [26] 
        unsigned TX_CH11_INT : 1; //!< [27] 
        unsigned TX_CH12_INT : 1; //!< [28] 
        unsigned TX_CH13_INT : 1; //!< [29] 
        unsigned TX_CH14_INT : 1; //!< [30] 
        unsigned TX_CH15_INT : 1; //!< [31] 
    } B;
} hw_mipi_hsi_fifo_thr_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_FIFO_THR_IRQSTAT register
 */
//@{
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_ADDR      (REGS_MIPI_HSI_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT           (*(volatile hw_mipi_hsi_fifo_thr_irqstat_t *) HW_MIPI_HSI_FIFO_THR_IRQSTAT_ADDR)
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_RD()      (HW_MIPI_HSI_FIFO_THR_IRQSTAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_FIFO_THR_IRQSTAT bitfields
 */

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH0_INT[0] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 0 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 0 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT      (0)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH0_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH1_INT[1] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 1 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 1 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT      (1)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH1_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH2_INT[2] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 2 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 2 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT      (2)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH2_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH3_INT[3] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 3 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 3 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT      (3)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH3_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH4_INT[4] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 4 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 4 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT      (4)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH4_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH5_INT[5] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 5 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 5 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT      (5)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH5_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH6_INT[6] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 6 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 6 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT      (6)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH6_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH7_INT[7] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 7 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 7 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT      (7)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH7_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH8_INT[8] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 8 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 8 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT      (8)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH8_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH9_INT[9] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 9 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 9 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT      (9)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT      (0x00000200)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH9_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH10_INT[10] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 10 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 10 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT      (10)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT      (0x00000400)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH10_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH11_INT[11] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 11 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 11 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT      (11)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT      (0x00000800)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH11_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH12_INT[12] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 12 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 12 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT      (12)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT      (0x00001000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH12_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH13_INT[13] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 13 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 13 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT      (13)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT      (0x00002000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH13_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH14_INT[14] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 14 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 14 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT      (14)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT      (0x00004000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH14_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field RX_CH15_INT[15] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Rx Channel 15 FIFO
 * - 1 - Threshold amount of data reached in Rx Channel 15 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT      (15)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT      (0x00008000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_RX_CH15_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH0_INT[16] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 0 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 0 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT      (16)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT      (0x00010000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH0_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH1_INT[17] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 1 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 1 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT      (17)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT      (0x00020000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH1_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH2_INT[18] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 2 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 2 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT      (18)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT      (0x00040000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH2_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH3_INT[19] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 3 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 3 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT      (19)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT      (0x00080000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH3_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH4_INT[20] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 4 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 4 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT      (20)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT      (0x00100000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH4_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH5_INT[21] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 5 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 5 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT      (21)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT      (0x00200000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH5_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH6_INT[22] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 6 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 6 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT      (22)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT      (0x00400000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH6_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH7_INT[23] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 7 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 7 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT      (23)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT      (0x00800000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH7_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH8_INT[24] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 8 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 8 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT      (24)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT      (0x01000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH8_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH9_INT[25] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 9 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 9 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT      (25)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT      (0x02000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH9_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH10_INT[26] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 10 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 10 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT      (26)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT      (0x04000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH10_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH11_INT[27] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 11 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 11 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT      (27)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT      (0x08000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH11_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH12_INT[28] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 12 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 12 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT      (28)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT      (0x10000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH12_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH13_INT[29] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 13 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 13 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT      (29)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT      (0x20000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH13_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH14_INT[30] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 14 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 14 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT      (30)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT      (0x40000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH14_INT)
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT, field TX_CH15_INT[31] (RO)
 *
 * Values:
 * - 0 - Threshold amount of data not reached in Tx Channel 15 FIFO
 * - 1 - Threshold amount of data reached in Tx Channel 15 FIFO
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT      (31)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT      (0x80000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_TX_CH15_INT)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN - HSI FIFO Threshold Interrupt Status Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN - HSI FIFO Threshold Interrupt Status Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller FIFO Threshold Interrupt Status Enable.
 */
typedef union _hw_mipi_hsi_fifo_thr_irqstat_en
{
    reg32_t U;
    struct _hw_mipi_hsi_fifo_thr_irqstat_en_bitfields
    {
        unsigned RX_CH0_INT : 1; //!< [0] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH1_INT : 1; //!< [1] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH2_INT : 1; //!< [2] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH3_INT : 1; //!< [3] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH4_INT : 1; //!< [4] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH5_INT : 1; //!< [5] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH6_INT : 1; //!< [6] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH7_INT : 1; //!< [7] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH8_INT : 1; //!< [8] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH9_INT : 1; //!< [9] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH10_INT : 1; //!< [10] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH11_INT : 1; //!< [11] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH12_INT : 1; //!< [12] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH13_INT : 1; //!< [13] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH14_INT : 1; //!< [14] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH15_INT : 1; //!< [15] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH0_INT : 1; //!< [16] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH1_INT : 1; //!< [17] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH2_INT : 1; //!< [18] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH3_INT : 1; //!< [19] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH4_INT : 1; //!< [20] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH5_INT : 1; //!< [21] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH6_INT : 1; //!< [22] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH7_INT : 1; //!< [23] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH8_INT : 1; //!< [24] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH9_INT : 1; //!< [25] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH10_INT : 1; //!< [26] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH11_INT : 1; //!< [27] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH12_INT : 1; //!< [28] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH13_INT : 1; //!< [29] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH14_INT : 1; //!< [30] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH15_INT : 1; //!< [31] Setting this bit will enable interrupt generation on interrupt line.
    } B;
} hw_mipi_hsi_fifo_thr_irqstat_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_FIFO_THR_IRQSTAT_EN register
 */
//@{
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN           (*(volatile hw_mipi_hsi_fifo_thr_irqstat_en_t *) HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_ADDR)
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD()      (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN.U)
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR(v)     (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN.U = (v))
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_SET(v)    (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() |  (v)))
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_CLR(v)    (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~(v)))
#define HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TOG(v)    (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_FIFO_THR_IRQSTAT_EN bitfields
 */

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH0_INT[0] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch0 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch0 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT      (0)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH0_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH0_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH1_INT[1] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch1 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch1 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT      (1)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH1_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH1_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH2_INT[2] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch2 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch2 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT      (2)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH2_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH2_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH3_INT[3] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch3 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch3 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT      (3)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH3_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH3_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH4_INT[4] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch4 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch4 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT      (4)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH4_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH4_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH5_INT[5] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch5 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch5 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT      (5)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH5_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH5_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH6_INT[6] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch6 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch6 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT      (6)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH6_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH6_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH7_INT[7] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch7 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch7 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT      (7)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH7_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH7_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH8_INT[8] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch8 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch8 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT      (8)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH8_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH8_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH9_INT[9] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch9 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch9 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT      (9)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT      (0x00000200)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH9_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH9_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH10_INT[10] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch10 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch10 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT      (10)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT      (0x00000400)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH10_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH10_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH11_INT[11] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch11 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch11 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT      (11)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT      (0x00000800)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH11_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH11_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH12_INT[12] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch12 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch12 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT      (12)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT      (0x00001000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH12_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH12_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH13_INT[13] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch13 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch13 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT      (13)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT      (0x00002000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH13_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH13_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH14_INT[14] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch14 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch14 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT      (14)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT      (0x00004000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH14_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH14_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field RX_CH15_INT[15] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch15 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch15 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT      (15)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT      (0x00008000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH15_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RX_CH15_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH0_INT[16] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch0 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch0 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT      (16)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT      (0x00010000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH0_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH0_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH1_INT[17] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch1 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch1 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT      (17)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT      (0x00020000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH1_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH1_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH2_INT[18] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch2 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch2 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT      (18)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT      (0x00040000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH2_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH2_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH3_INT[19] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch3 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch3 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT      (19)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT      (0x00080000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH3_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH3_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH4_INT[20] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch4 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch4 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT      (20)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT      (0x00100000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH4_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH4_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH5_INT[21] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch5 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch5 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT      (21)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT      (0x00200000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH5_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH5_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH6_INT[22] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch6 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch6 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT      (22)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT      (0x00400000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH6_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH6_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH7_INT[23] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch7 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch7 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT      (23)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT      (0x00800000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH7_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH7_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH8_INT[24] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch8 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch8 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT      (24)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT      (0x01000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH8_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH8_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH9_INT[25] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch9 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch9 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT      (25)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT      (0x02000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH9_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH9_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH10_INT[26] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch10 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch10 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT      (26)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT      (0x04000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH10_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH10_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH11_INT[27] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch11 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch11 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT      (27)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT      (0x08000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH11_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH11_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH12_INT[28] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch12 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch12 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT      (28)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT      (0x10000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH12_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH12_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH13_INT[29] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch13 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch13 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT      (29)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT      (0x20000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH13_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH13_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH14_INT[30] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch14 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch14 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT      (30)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT      (0x40000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH14_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH14_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSTAT_EN, field TX_CH15_INT[31] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch15 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch15 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT      (31)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT      (0x80000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT) & BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH15_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT) | BF_MIPI_HSI_FIFO_THR_IRQSTAT_EN_TX_CH15_INT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_FIFO_THR_IRQSIG_EN - HSI FIFO Threshold Interrupt Signal Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_FIFO_THR_IRQSIG_EN - HSI FIFO Threshold Interrupt Signal Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller FIFO Threshold Interrupt Enable.
 */
typedef union _hw_mipi_hsi_fifo_thr_irqsig_en
{
    reg32_t U;
    struct _hw_mipi_hsi_fifo_thr_irqsig_en_bitfields
    {
        unsigned RX_CH0_INT : 1; //!< [0] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH1_INT : 1; //!< [1] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH2_INT : 1; //!< [2] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH3_INT : 1; //!< [3] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH4_INT : 1; //!< [4] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH5_INT : 1; //!< [5] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH6_INT : 1; //!< [6] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH7_INT : 1; //!< [7] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH8_INT : 1; //!< [8] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH9_INT : 1; //!< [9] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH10_INT : 1; //!< [10] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH11_INT : 1; //!< [11] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH12_INT : 1; //!< [12] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH13_INT : 1; //!< [13] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH14_INT : 1; //!< [14] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH15_INT : 1; //!< [15] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH0_INT : 1; //!< [16] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH1_INT : 1; //!< [17] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH2_INT : 1; //!< [18] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH3_INT : 1; //!< [19] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH4_INT : 1; //!< [20] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH5_INT : 1; //!< [21] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH6_INT : 1; //!< [22] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH7_INT : 1; //!< [23] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH8_INT : 1; //!< [24] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH9_INT : 1; //!< [25] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH10_INT : 1; //!< [26] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH11_INT : 1; //!< [27] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH12_INT : 1; //!< [28] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH13_INT : 1; //!< [29] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH14_INT : 1; //!< [30] Setting this bit will enable interrupt generation on interrupt line.
        unsigned TX_CH15_INT : 1; //!< [31] Setting this bit will enable interrupt generation on interrupt line.
    } B;
} hw_mipi_hsi_fifo_thr_irqsig_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_FIFO_THR_IRQSIG_EN register
 */
//@{
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN           (*(volatile hw_mipi_hsi_fifo_thr_irqsig_en_t *) HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_ADDR)
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD()      (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN.U)
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR(v)     (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN.U = (v))
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_SET(v)    (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() |  (v)))
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_CLR(v)    (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~(v)))
#define HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TOG(v)    (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR(HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_FIFO_THR_IRQSIG_EN bitfields
 */

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH0_INT[0] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch0 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch0 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT      (0)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT      (0x00000001)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH0_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH0_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH1_INT[1] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch1 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch1 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT      (1)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT      (0x00000002)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH1_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH1_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH2_INT[2] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch2 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch2 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT      (2)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT      (0x00000004)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH2_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH2_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH3_INT[3] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch3 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch3 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT      (3)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT      (0x00000008)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH3_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH3_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH4_INT[4] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch4 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch4 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT      (4)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT      (0x00000010)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH4_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH4_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH5_INT[5] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch5 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch5 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT      (5)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT      (0x00000020)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH5_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH5_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH6_INT[6] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch6 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch6 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT      (6)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT      (0x00000040)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH6_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH6_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH7_INT[7] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch7 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch7 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT      (7)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT      (0x00000080)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH7_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH7_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH8_INT[8] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch8 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch8 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT      (8)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT      (0x00000100)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH8_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH8_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH9_INT[9] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch9 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch9 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT      (9)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT      (0x00000200)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH9_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH9_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH10_INT[10] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch10 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch10 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT      (10)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT      (0x00000400)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH10_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH10_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH11_INT[11] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch11 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch11 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT      (11)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT      (0x00000800)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH11_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH11_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH12_INT[12] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch12 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch12 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT      (12)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT      (0x00001000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH12_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH12_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH13_INT[13] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch13 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch13 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT      (13)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT      (0x00002000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH13_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH13_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH14_INT[14] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch14 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch14 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT      (14)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT      (0x00004000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH14_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH14_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field RX_CH15_INT[15] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Rx Ch15 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Rx Ch15 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT      (15)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT      (0x00008000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH15_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_RX_CH15_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH0_INT[16] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch0 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch0 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT      (16)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT      (0x00010000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH0_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH0_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH1_INT[17] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch1 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch1 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT      (17)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT      (0x00020000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH1_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH1_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH2_INT[18] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch2 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch2 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT      (18)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT      (0x00040000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH2_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH2_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH3_INT[19] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch3 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch3 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT      (19)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT      (0x00080000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH3_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH3_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH4_INT[20] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch4 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch4 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT      (20)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT      (0x00100000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH4_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH4_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH5_INT[21] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch5 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch5 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT      (21)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT      (0x00200000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH5_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH5_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH6_INT[22] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch6 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch6 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT      (22)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT      (0x00400000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH6_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH6_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH7_INT[23] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch7 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch7 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT      (23)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT      (0x00800000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH7_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH7_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH8_INT[24] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch8 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch8 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT      (24)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT      (0x01000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH8_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH8_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH9_INT[25] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch9 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch9 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT      (25)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT      (0x02000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH9_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH9_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH10_INT[26] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch10 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch10 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT      (26)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT      (0x04000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH10_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH10_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH11_INT[27] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch11 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch11 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT      (27)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT      (0x08000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH11_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH11_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH12_INT[28] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch12 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch12 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT      (28)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT      (0x10000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH12_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH12_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH13_INT[29] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch13 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch13 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT      (29)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT      (0x20000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH13_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH13_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH14_INT[30] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch14 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch14 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT      (30)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT      (0x40000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH14_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH14_INT(v)))
#endif
//@}

/*! @name Register MIPI_HSI_FIFO_THR_IRQSIG_EN, field TX_CH15_INT[31] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for Tx Ch15 threshold Reached interrupt.
 * - 1 - Interrupt signal enabled for Tx Ch15 threshold Reached interrupt.
 */
//@{
#define BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT      (31)      //!< Bit position for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT.
#define BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT      (0x80000000)  //!< Bit mask for MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT.

//! @brief Get value of MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT from a register value.
#define BG_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT) >> BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT)

//! @brief Format value for bitfield MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT.
#define BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT) & BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_CH15_INT field to a new value.
#define BW_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT(v)   (HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_WR((HW_MIPI_HSI_FIFO_THR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT) | BF_MIPI_HSI_FIFO_THR_IRQSIG_EN_TX_CH15_INT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_CHn_DP - Tx Channel n Data Port Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_CHn_DP - Tx Channel n Data Port Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register is connected to fifo data port for Tx Channel n.
 */
typedef union _hw_mipi_hsi_tx_chn_dp
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_chn_dp_bitfields
    {
        unsigned DATA : 32; //!< [31:0] Software could Write/Read this bits to access Tx Channel n.
    } B;
} hw_mipi_hsi_tx_chn_dp_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_CHn_DP register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_TX_CHn_DP register.
#define HW_MIPI_HSI_TX_CHn_DP_COUNT     (16)

#define HW_MIPI_HSI_TX_CHn_DP_ADDR(n)   (REGS_MIPI_HSI_BASE + 0x50 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_CHn_DP(n)        (*(volatile hw_mipi_hsi_tx_chn_dp_t *) HW_MIPI_HSI_TX_CHn_DP_ADDR(n))
#define HW_MIPI_HSI_TX_CHn_DP_RD(n)     (HW_MIPI_HSI_TX_CHn_DP(n).U)
#define HW_MIPI_HSI_TX_CHn_DP_WR(n, v)  (HW_MIPI_HSI_TX_CHn_DP(n).U = (v))
#define HW_MIPI_HSI_TX_CHn_DP_SET(n, v) (HW_MIPI_HSI_TX_CHn_DP_WR(n, HW_MIPI_HSI_TX_CHn_DP_RD(n) |  (v)))
#define HW_MIPI_HSI_TX_CHn_DP_CLR(n, v) (HW_MIPI_HSI_TX_CHn_DP_WR(n, HW_MIPI_HSI_TX_CHn_DP_RD(n) & ~(v)))
#define HW_MIPI_HSI_TX_CHn_DP_TOG(n, v) (HW_MIPI_HSI_TX_CHn_DP_WR(n, HW_MIPI_HSI_TX_CHn_DP_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_CHn_DP bitfields
 */

/*! @name Register MIPI_HSI_TX_CHn_DP, field DATA[31:0] (RW)
 *
 * Software could Write/Read this bits to access Tx Channel n.
 */
//@{
#define BP_MIPI_HSI_TX_CHn_DP_DATA      (0)      //!< Bit position for MIPI_HSI_TX_CHn_DP_DATA.
#define BM_MIPI_HSI_TX_CHn_DP_DATA      (0xffffffff)  //!< Bit mask for MIPI_HSI_TX_CHn_DP_DATA.

//! @brief Get value of MIPI_HSI_TX_CHn_DP_DATA from a register value.
#define BG_MIPI_HSI_TX_CHn_DP_DATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_CHn_DP_DATA) >> BP_MIPI_HSI_TX_CHn_DP_DATA)

//! @brief Format value for bitfield MIPI_HSI_TX_CHn_DP_DATA.
#define BF_MIPI_HSI_TX_CHn_DP_DATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_CHn_DP_DATA) & BM_MIPI_HSI_TX_CHn_DP_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_MIPI_HSI_TX_CHn_DP_DATA(n, v)   (HW_MIPI_HSI_TX_CHn_DP_WR(n, (HW_MIPI_HSI_TX_CHn_DP_RD(n) & ~BM_MIPI_HSI_TX_CHn_DP_DATA) | BF_MIPI_HSI_TX_CHn_DP_DATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RX_CHn_DP - Rx Channel n Data Port Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RX_CHn_DP - Rx Channel n Data Port Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register is connected to fifo data port for Rx Channel n.
 */
typedef union _hw_mipi_hsi_rx_chn_dp
{
    reg32_t U;
    struct _hw_mipi_hsi_rx_chn_dp_bitfields
    {
        unsigned DATA : 32; //!< [31:0] Software could Write/Read this bits to access Rx Channel n.
    } B;
} hw_mipi_hsi_rx_chn_dp_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RX_CHn_DP register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_RX_CHn_DP register.
#define HW_MIPI_HSI_RX_CHn_DP_COUNT     (16)

#define HW_MIPI_HSI_RX_CHn_DP_ADDR(n)   (REGS_MIPI_HSI_BASE + 0x90 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RX_CHn_DP(n)        (*(volatile hw_mipi_hsi_rx_chn_dp_t *) HW_MIPI_HSI_RX_CHn_DP_ADDR(n))
#define HW_MIPI_HSI_RX_CHn_DP_RD(n)     (HW_MIPI_HSI_RX_CHn_DP(n).U)
#define HW_MIPI_HSI_RX_CHn_DP_WR(n, v)  (HW_MIPI_HSI_RX_CHn_DP(n).U = (v))
#define HW_MIPI_HSI_RX_CHn_DP_SET(n, v) (HW_MIPI_HSI_RX_CHn_DP_WR(n, HW_MIPI_HSI_RX_CHn_DP_RD(n) |  (v)))
#define HW_MIPI_HSI_RX_CHn_DP_CLR(n, v) (HW_MIPI_HSI_RX_CHn_DP_WR(n, HW_MIPI_HSI_RX_CHn_DP_RD(n) & ~(v)))
#define HW_MIPI_HSI_RX_CHn_DP_TOG(n, v) (HW_MIPI_HSI_RX_CHn_DP_WR(n, HW_MIPI_HSI_RX_CHn_DP_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RX_CHn_DP bitfields
 */

/*! @name Register MIPI_HSI_RX_CHn_DP, field DATA[31:0] (RW)
 *
 * Software could Write/Read this bits to access Rx Channel n.
 */
//@{
#define BP_MIPI_HSI_RX_CHn_DP_DATA      (0)      //!< Bit position for MIPI_HSI_RX_CHn_DP_DATA.
#define BM_MIPI_HSI_RX_CHn_DP_DATA      (0xffffffff)  //!< Bit mask for MIPI_HSI_RX_CHn_DP_DATA.

//! @brief Get value of MIPI_HSI_RX_CHn_DP_DATA from a register value.
#define BG_MIPI_HSI_RX_CHn_DP_DATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_CHn_DP_DATA) >> BP_MIPI_HSI_RX_CHn_DP_DATA)

//! @brief Format value for bitfield MIPI_HSI_RX_CHn_DP_DATA.
#define BF_MIPI_HSI_RX_CHn_DP_DATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_CHn_DP_DATA) & BM_MIPI_HSI_RX_CHn_DP_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_MIPI_HSI_RX_CHn_DP_DATA(n, v)   (HW_MIPI_HSI_RX_CHn_DP_WR(n, (HW_MIPI_HSI_RX_CHn_DP_RD(n) & ~BM_MIPI_HSI_RX_CHn_DP_DATA) | BF_MIPI_HSI_RX_CHn_DP_DATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_ERR_IRQSTAT - HSI Error Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_ERR_IRQSTAT - HSI Error Interrupt Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller Error Interrupt Status.
 */
typedef union _hw_mipi_hsi_err_irqstat
{
    reg32_t U;
    struct _hw_mipi_hsi_err_irqstat_bitfields
    {
        unsigned RESERVED0 : 16; //!< [15:0] Reserved, always set to zero.
        unsigned RX_CH0_TIMEOUT_INT : 1; //!< [16] This status bit is set when data timeout counter for ch0 reaches the data timeout counter value.
        unsigned RX_CH1_TIMEOUT_INT : 1; //!< [17] This status bit is set when data timeout counter for ch1 reaches the data timeout counter value.
        unsigned RX_CH2_TIMEOUT_INT : 1; //!< [18] This status bit is set when data timeout counter for ch2 reaches the data timeout counter value.
        unsigned RX_CH3_TIMEOUT_INT : 1; //!< [19] This status bit is set when data timeout counter for ch3 reaches the data timeout counter value.
        unsigned RX_CH4_TIMEOUT_INT : 1; //!< [20] This status bit is set when data timeout counter for ch4 reaches the data timeout counter value.
        unsigned RX_CH5_TIMEOUT_INT : 1; //!< [21] This status bit is set when data timeout counter for ch5 reaches the data timeout counter value.
        unsigned RX_CH6_TIMEOUT_INT : 1; //!< [22] This status bit is set when data timeout counter for ch6 reaches the data timeout counter value.
        unsigned RX_CH7_TIMEOUT_INT : 1; //!< [23] This status bit is set when data timeout counter for ch7 reaches the data timeout counter value.
        unsigned RX_CH8_TIMEOUT_INT : 1; //!< [24] This status bit is set when data timeout counter for ch8 reaches the data timeout counter value.
        unsigned RX_CH9_TIMEOUT_INT : 1; //!< [25] This status bit is set when data timeout counter for ch9 reaches the data timeout counter value.
        unsigned RX_CH10_TIMEOUT_INT : 1; //!< [26] This status bit is set when data timeout counter for ch10 reaches the data timeout counter value.
        unsigned RX_CH11_TIMEOUT_INT : 1; //!< [27] This status bit is set when data timeout counter for ch11 reaches the data timeout counter value.
        unsigned RX_CH12_TIMEOUT_INT : 1; //!< [28] This status bit is set when data timeout counter for ch12 reaches the data timeout counter value.
        unsigned RX_CH13_TIMEOUT_INT : 1; //!< [29] This status bit is set when data timeout counter for ch13 reaches the data timeout counter value.
        unsigned RX_CH14_TIMEOUT_INT : 1; //!< [30] This status bit is set when data timeout counter for ch14 reaches the data timeout counter value.
        unsigned RX_CH15_TIMEOUT_INT : 1; //!< [31] This status bit is set when data timeout counter for ch15 reaches thedata timeout counter value.
    } B;
} hw_mipi_hsi_err_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_ERR_IRQSTAT register
 */
//@{
#define HW_MIPI_HSI_ERR_IRQSTAT_ADDR      (REGS_MIPI_HSI_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_ERR_IRQSTAT           (*(volatile hw_mipi_hsi_err_irqstat_t *) HW_MIPI_HSI_ERR_IRQSTAT_ADDR)
#define HW_MIPI_HSI_ERR_IRQSTAT_RD()      (HW_MIPI_HSI_ERR_IRQSTAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_ERR_IRQSTAT bitfields
 */

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH0_TIMEOUT_INT[16] (RO)
 *
 * This status bit is set when data timeout counter for ch0 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch0 buffer and then
 * read HSI Status register to find the further status of the Rx ch0 Buffer. The host driver has to
 * read the Rx ch0 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT      (16)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT      (0x00010000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH0_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH1_TIMEOUT_INT[17] (RO)
 *
 * This status bit is set when data timeout counter for ch1 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch1 buffer and then
 * read HSI Status register to find the further status of the Rx ch1 Buffer. The host driver has to
 * read the Rx ch1 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT      (17)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT      (0x00020000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH1_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH2_TIMEOUT_INT[18] (RO)
 *
 * This status bit is set when data timeout counter for ch2 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch2 buffer and then
 * read HSI Status register to find the further status of the Rx ch2 Buffer. The host driver has to
 * read the Rx ch2 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT      (18)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT      (0x00040000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH2_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH3_TIMEOUT_INT[19] (RO)
 *
 * This status bit is set when data timeout counter for ch3 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch3 buffer and then
 * read HSI Status register to find the further status of the Rx ch3 Buffer. The host driver has to
 * read the Rx ch3 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT      (19)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT      (0x00080000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH3_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH4_TIMEOUT_INT[20] (RO)
 *
 * This status bit is set when data timeout counter for ch4 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch4 buffer and then
 * read HSI Status register to find the further status of the Rx ch4 Buffer. The host driver has to
 * read the Rx ch4 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT      (20)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT      (0x00100000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH4_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH5_TIMEOUT_INT[21] (RO)
 *
 * This status bit is set when data timeout counter for ch5 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch5 buffer and then
 * read HSI Status register to find the further status of the Rx ch5 Buffer. The host driver has to
 * read the Rx ch5 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT      (21)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT      (0x00200000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH5_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH6_TIMEOUT_INT[22] (RO)
 *
 * This status bit is set when data timeout counter for ch6 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch6 buffer and then
 * read HSI Status register to find the further status of the Rx ch6 Buffer. The host driver has to
 * read the Rx ch6 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT      (22)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT      (0x00400000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH6_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH7_TIMEOUT_INT[23] (RO)
 *
 * This status bit is set when data timeout counter for ch7 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch7 buffer and then
 * read HSI Status register to find the further status of the Rx ch7 Buffer. The host driver has to
 * read the Rx ch7 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT      (23)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT      (0x00800000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH7_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH8_TIMEOUT_INT[24] (RO)
 *
 * This status bit is set when data timeout counter for ch8 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch8 buffer and then
 * read HSI Status register to find the further status of the Rx ch8 Buffer. The host driver has to
 * read the Rx ch8 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT      (24)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT      (0x01000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH8_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH9_TIMEOUT_INT[25] (RO)
 *
 * This status bit is set when data timeout counter for ch9 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch9 buffer and then
 * read HSI Status register to find the further status of the Rx ch9 Buffer. The host driver has to
 * read the Rx ch9 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT      (25)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT      (0x02000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH9_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH10_TIMEOUT_INT[26] (RO)
 *
 * This status bit is set when data timeout counter for ch10 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch10 buffer and
 * then read HSI Status register to find the further status of the Rx ch10 Buffer. The host driver
 * has to read the Rx ch10 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT      (26)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT      (0x04000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH10_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH11_TIMEOUT_INT[27] (RO)
 *
 * This status bit is set when data timeout counter for ch11 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch11 buffer and
 * then read HSI Status register to find the further status of the Rx ch11 Buffer. The host driver
 * has to read the Rx ch11 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT      (27)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT      (0x08000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH11_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH12_TIMEOUT_INT[28] (RO)
 *
 * This status bit is set when data timeout counter for ch12 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch12 buffer and
 * then read HSI Status register to find the further status of the Rx ch12 Buffer. The host driver
 * has to read the Rx ch12 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT      (28)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT      (0x10000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH12_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH13_TIMEOUT_INT[29] (RO)
 *
 * This status bit is set when data timeout counter for ch13 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch13 buffer and
 * then read HSI Status register to find the further status of the Rx ch13 Buffer. The host driver
 * has to read the Rx ch13 fifo on Dword basis, till thefifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT      (29)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT      (0x20000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH13_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH14_TIMEOUT_INT[30] (RO)
 *
 * This status bit is set when data timeout counter for ch14 reaches the data timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch14 buffer and
 * then read HSI Status register to find the further status of the Rx ch14 Buffer. The host driver
 * has to read the Rx ch14 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT      (30)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT      (0x40000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH14_TIMEOUT_INT)
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT, field RX_CH15_TIMEOUT_INT[31] (RO)
 *
 * This status bit is set when data timeout counter for ch15 reaches thedata timeout counter value.
 * On receiving the interrupt the host driver should read 1Dword of data from Rx ch15 buffer and
 * then read HSI Status register to find the further status of the Rx ch15 Buffer. The host driver
 * has to read the Rx ch15 fifo on Dword basis, till the fifo is completely empty.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT      (31)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT.
#define BM_MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT      (0x80000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT) >> BP_MIPI_HSI_ERR_IRQSTAT_RX_CH15_TIMEOUT_INT)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_ERR_IRQSTAT_EN - HSI Error Interrupt Status Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_ERR_IRQSTAT_EN - HSI Error Interrupt Status Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller Error Interrupt Status Enable.
 */
typedef union _hw_mipi_hsi_err_irqstat_en
{
    reg32_t U;
    struct _hw_mipi_hsi_err_irqstat_en_bitfields
    {
        unsigned RESERVED0 : 16; //!< [15:0] Reserved, always set to zero.
        unsigned RX_CH0_TIMEOUT_INT_EN : 1; //!< [16] 
        unsigned RX_CH1_TIMEOUT_INT_EN : 1; //!< [17] 
        unsigned RX_CH2_TIMEOUT_INT_EN : 1; //!< [18] 
        unsigned RX_CH3_TIMEOUT_INT_EN : 1; //!< [19] 
        unsigned RX_CH4_TIMEOUT_INT_EN : 1; //!< [20] 
        unsigned RX_CH5_TIMEOUT_INT_EN : 1; //!< [21] 
        unsigned RX_CH6_TIMEOUT_INT_EN : 1; //!< [22] 
        unsigned RX_CH7_TIMEOUT_INT_EN : 1; //!< [23] 
        unsigned RX_CH8_TIMEOUT_INT_EN : 1; //!< [24] 
        unsigned RX_CH9_TIMEOUT_INT_EN : 1; //!< [25] 
        unsigned RX_CH10_TIMEOUT_INT_EN : 1; //!< [26] 
        unsigned RX_CH11_TIMEOUT_INT_EN : 1; //!< [27] 
        unsigned RX_CH12_TIMEOUT_INT_EN : 1; //!< [28] 
        unsigned RX_CH13_TIMEOUT_INT_EN : 1; //!< [29] 
        unsigned RX_CH14_TIMEOUT_INT_EN : 1; //!< [30] 
        unsigned RX_CH15_TIMEOUT_INT_EN : 1; //!< [31] 
    } B;
} hw_mipi_hsi_err_irqstat_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_ERR_IRQSTAT_EN register
 */
//@{
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_ADDR      (REGS_MIPI_HSI_BASE + 0xd4)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_ERR_IRQSTAT_EN           (*(volatile hw_mipi_hsi_err_irqstat_en_t *) HW_MIPI_HSI_ERR_IRQSTAT_EN_ADDR)
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_RD()      (HW_MIPI_HSI_ERR_IRQSTAT_EN.U)
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_WR(v)     (HW_MIPI_HSI_ERR_IRQSTAT_EN.U = (v))
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_SET(v)    (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() |  (v)))
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_CLR(v)    (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~(v)))
#define HW_MIPI_HSI_ERR_IRQSTAT_EN_TOG(v)    (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_ERR_IRQSTAT_EN bitfields
 */

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH0_TIMEOUT_INT_EN[16] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch0 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch0 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN      (16)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN      (0x00010000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH0_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH0_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH1_TIMEOUT_INT_EN[17] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch1 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch1 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN      (17)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN      (0x00020000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH1_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH1_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH2_TIMEOUT_INT_EN[18] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch2 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch2 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN      (18)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN      (0x00040000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH2_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH2_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH3_TIMEOUT_INT_EN[19] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch3 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch3 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN      (19)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN      (0x00080000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH3_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH3_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH4_TIMEOUT_INT_EN[20] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch4 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch4 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN      (20)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN      (0x00100000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH4_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH4_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH5_TIMEOUT_INT_EN[21] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch5 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch5 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN      (21)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN      (0x00200000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH5_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH5_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH6_TIMEOUT_INT_EN[22] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch6 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch6 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN      (22)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN      (0x00400000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH6_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH6_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH7_TIMEOUT_INT_EN[23] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch7 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch7 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN      (23)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN      (0x00800000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH7_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH7_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH8_TIMEOUT_INT_EN[24] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch8 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch8 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN      (24)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN      (0x01000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH8_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH8_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH9_TIMEOUT_INT_EN[25] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch9 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch9 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN      (25)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN      (0x02000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH9_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH9_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH10_TIMEOUT_INT_EN[26] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch10 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch10 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN      (26)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN      (0x04000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH10_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH10_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH11_TIMEOUT_INT_EN[27] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch11 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch11 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN      (27)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN      (0x08000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH11_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH11_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH12_TIMEOUT_INT_EN[28] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch12 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch12 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN      (28)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN      (0x10000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH12_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH12_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH13_TIMEOUT_INT_EN[29] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch13 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch13 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN      (29)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN      (0x20000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH13_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH13_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH14_TIMEOUT_INT_EN[30] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch14 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch14 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN      (30)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN      (0x40000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH14_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH14_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSTAT_EN, field RX_CH15_TIMEOUT_INT_EN[31] (RW)
 *
 * Values:
 * - 0 - Interrupt status masked for data timeout for ch15 interrupt.
 * - 1 - Interrupt status enabled for data timeout for ch15 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN      (31)      //!< Bit position for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN      (0x80000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH15_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSTAT_EN_RX_CH15_TIMEOUT_INT_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_ERR_IRQSIG_EN - HSI Error Interrupt Signal Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_ERR_IRQSIG_EN - HSI Error Interrupt Signal Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the HSI controller Error Interrupt Signal Enable.
 */
typedef union _hw_mipi_hsi_err_irqsig_en
{
    reg32_t U;
    struct _hw_mipi_hsi_err_irqsig_en_bitfields
    {
        unsigned RESERVED0 : 16; //!< [15:0] Reserved, always set to zero.
        unsigned RX_CH0_TIMEOUT_INT_EN : 1; //!< [16] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH1_TIMEOUT_INT_EN : 1; //!< [17] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH2_TIMEOUT_INT_EN : 1; //!< [18] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH3_TIMEOUT_INT_EN : 1; //!< [19] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH4_TIMEOUT_INT_EN : 1; //!< [20] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH5_TIMEOUT_INT_EN : 1; //!< [21] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH6_TIMEOUT_INT_EN : 1; //!< [22] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH7_TIMEOUT_INT_EN : 1; //!< [23] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH8_TIMEOUT_INT_EN : 1; //!< [24] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH9_TIMEOUT_INT_EN : 1; //!< [25] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH10_TIMEOUT_INT_EN : 1; //!< [26] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH11_TIMEOUT_INT_EN : 1; //!< [27] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH12_TIMEOUT_INT_EN : 1; //!< [28] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH13_TIMEOUT_INT_EN : 1; //!< [29] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH14_TIMEOUT_INT_EN : 1; //!< [30] Setting this bit will enable interrupt generation on interrupt line.
        unsigned RX_CH15_TIMEOUT_INT_EN : 1; //!< [31] Setting this bit will enable interrupt generation on interrupt line.
    } B;
} hw_mipi_hsi_err_irqsig_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_ERR_IRQSIG_EN register
 */
//@{
#define HW_MIPI_HSI_ERR_IRQSIG_EN_ADDR      (REGS_MIPI_HSI_BASE + 0xd8)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_ERR_IRQSIG_EN           (*(volatile hw_mipi_hsi_err_irqsig_en_t *) HW_MIPI_HSI_ERR_IRQSIG_EN_ADDR)
#define HW_MIPI_HSI_ERR_IRQSIG_EN_RD()      (HW_MIPI_HSI_ERR_IRQSIG_EN.U)
#define HW_MIPI_HSI_ERR_IRQSIG_EN_WR(v)     (HW_MIPI_HSI_ERR_IRQSIG_EN.U = (v))
#define HW_MIPI_HSI_ERR_IRQSIG_EN_SET(v)    (HW_MIPI_HSI_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_ERR_IRQSIG_EN_RD() |  (v)))
#define HW_MIPI_HSI_ERR_IRQSIG_EN_CLR(v)    (HW_MIPI_HSI_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~(v)))
#define HW_MIPI_HSI_ERR_IRQSIG_EN_TOG(v)    (HW_MIPI_HSI_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_ERR_IRQSIG_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_ERR_IRQSIG_EN bitfields
 */

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH0_TIMEOUT_INT_EN[16] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch0 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch0 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN      (16)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN      (0x00010000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH0_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH0_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH1_TIMEOUT_INT_EN[17] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch1interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch1 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN      (17)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN      (0x00020000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH1_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH1_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH2_TIMEOUT_INT_EN[18] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch2 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch2 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN      (18)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN      (0x00040000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH2_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH2_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH3_TIMEOUT_INT_EN[19] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch3 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch3 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN      (19)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN      (0x00080000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH3_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH3_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH4_TIMEOUT_INT_EN[20] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch4 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch4 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN      (20)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN      (0x00100000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH4_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH4_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH5_TIMEOUT_INT_EN[21] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch5 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch5 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN      (21)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN      (0x00200000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH5_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH5_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH6_TIMEOUT_INT_EN[22] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch6 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch6 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN      (22)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN      (0x00400000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH6_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH6_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH7_TIMEOUT_INT_EN[23] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch7 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch7 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN      (23)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN      (0x00800000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH7_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH7_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH8_TIMEOUT_INT_EN[24] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch8 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch8 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN      (24)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN      (0x01000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH8_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH8_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH9_TIMEOUT_INT_EN[25] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch9 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch9 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN      (25)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN      (0x02000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH9_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH9_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH10_TIMEOUT_INT_EN[26] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch10 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch10 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN      (26)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN      (0x04000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH10_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH10_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH11_TIMEOUT_INT_EN[27] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch11 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch11 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN      (27)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN      (0x08000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH11_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH11_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH12_TIMEOUT_INT_EN[28] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch12 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch12 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN      (28)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN      (0x10000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH12_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH12_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH13_TIMEOUT_INT_EN[29] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch13 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch13 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN      (29)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN      (0x20000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH13_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH13_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH14_TIMEOUT_INT_EN[30] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch14 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch14 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN      (30)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN      (0x40000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH14_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH14_TIMEOUT_INT_EN(v)))
#endif
//@}

/*! @name Register MIPI_HSI_ERR_IRQSIG_EN, field RX_CH15_TIMEOUT_INT_EN[31] (RW)
 *
 * Setting this bit will enable interrupt generation on interrupt line.
 *
 * Values:
 * - 0 - Interrupt signal masked for data timeout for ch15 interrupt.
 * - 1 - Interrupt signal enabled for data timeout for ch15 interrupt.
 */
//@{
#define BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN      (31)      //!< Bit position for MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN.
#define BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN      (0x80000000)  //!< Bit mask for MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN.

//! @brief Get value of MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN from a register value.
#define BG_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN) >> BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN)

//! @brief Format value for bitfield MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN.
#define BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN) & BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_CH15_TIMEOUT_INT_EN field to a new value.
#define BW_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN(v)   (HW_MIPI_HSI_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN) | BF_MIPI_HSI_ERR_IRQSIG_EN_RX_CH15_TIMEOUT_INT_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TDMAn_CONF - Tx DMA Channel n Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TDMAn_CONF - Tx DMA Channel n Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the configurations of enable/disable, burst size and transfer count for Tx
 * DMA channel n.
 */
typedef union _hw_mipi_hsi_tdman_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_tdman_conf_bitfields
    {
        unsigned RESERVED0 : 5; //!< [4:0] Reserved, always set to zero.
        unsigned TRANS_LENGTH : 20; //!< [24:5] Transfer data length for Tx DMA channel n.
        unsigned BURST_SIZE : 4; //!< [28:25] Burst size for Tx DMA channel n.
        unsigned RESERVED1 : 2; //!< [30:29] Reserved, always set to zero.
        unsigned ENABLE : 1; //!< [31] Setting this bit enables the inernal Tx DMA channel n.
    } B;
} hw_mipi_hsi_tdman_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TDMAn_CONF register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_TDMAn_CONF register.
#define HW_MIPI_HSI_TDMAn_CONF_COUNT     (16)

#define HW_MIPI_HSI_TDMAn_CONF_ADDR(n)   (REGS_MIPI_HSI_BASE + 0xdc + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TDMAn_CONF(n)        (*(volatile hw_mipi_hsi_tdman_conf_t *) HW_MIPI_HSI_TDMAn_CONF_ADDR(n))
#define HW_MIPI_HSI_TDMAn_CONF_RD(n)     (HW_MIPI_HSI_TDMAn_CONF(n).U)
#define HW_MIPI_HSI_TDMAn_CONF_WR(n, v)  (HW_MIPI_HSI_TDMAn_CONF(n).U = (v))
#define HW_MIPI_HSI_TDMAn_CONF_SET(n, v) (HW_MIPI_HSI_TDMAn_CONF_WR(n, HW_MIPI_HSI_TDMAn_CONF_RD(n) |  (v)))
#define HW_MIPI_HSI_TDMAn_CONF_CLR(n, v) (HW_MIPI_HSI_TDMAn_CONF_WR(n, HW_MIPI_HSI_TDMAn_CONF_RD(n) & ~(v)))
#define HW_MIPI_HSI_TDMAn_CONF_TOG(n, v) (HW_MIPI_HSI_TDMAn_CONF_WR(n, HW_MIPI_HSI_TDMAn_CONF_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TDMAn_CONF bitfields
 */

/*! @name Register MIPI_HSI_TDMAn_CONF, field TRANS_LENGTH[24:5] (RW)
 *
 * Transfer data length for Tx DMA channel n. The unit is Dword. h1 1Dword to transfer h2 2Dwords to
 * transfer hfffff 1048575Dwords to transfer
 */
//@{
#define BP_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH      (5)      //!< Bit position for MIPI_HSI_TDMAn_CONF_TRANS_LENGTH.
#define BM_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH      (0x01ffffe0)  //!< Bit mask for MIPI_HSI_TDMAn_CONF_TRANS_LENGTH.

//! @brief Get value of MIPI_HSI_TDMAn_CONF_TRANS_LENGTH from a register value.
#define BG_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH) >> BP_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH)

//! @brief Format value for bitfield MIPI_HSI_TDMAn_CONF_TRANS_LENGTH.
#define BF_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH) & BM_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRANS_LENGTH field to a new value.
#define BW_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH(n, v)   (HW_MIPI_HSI_TDMAn_CONF_WR(n, (HW_MIPI_HSI_TDMAn_CONF_RD(n) & ~BM_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH) | BF_MIPI_HSI_TDMAn_CONF_TRANS_LENGTH(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TDMAn_CONF, field BURST_SIZE[28:25] (RW)
 *
 * Burst size for Tx DMA channel n. The unit is Dword. The burst size should not be larger than
 * relevant TRANS_LENGTH and FIFO_SIZE. h0 1Dword to transfer for each burst h1 2Dword to transfer
 * for each burst h2 4Dword to transfer for each burst h10 1024Dword to transfer for each burst
 */
//@{
#define BP_MIPI_HSI_TDMAn_CONF_BURST_SIZE      (25)      //!< Bit position for MIPI_HSI_TDMAn_CONF_BURST_SIZE.
#define BM_MIPI_HSI_TDMAn_CONF_BURST_SIZE      (0x1e000000)  //!< Bit mask for MIPI_HSI_TDMAn_CONF_BURST_SIZE.

//! @brief Get value of MIPI_HSI_TDMAn_CONF_BURST_SIZE from a register value.
#define BG_MIPI_HSI_TDMAn_CONF_BURST_SIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TDMAn_CONF_BURST_SIZE) >> BP_MIPI_HSI_TDMAn_CONF_BURST_SIZE)

//! @brief Format value for bitfield MIPI_HSI_TDMAn_CONF_BURST_SIZE.
#define BF_MIPI_HSI_TDMAn_CONF_BURST_SIZE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TDMAn_CONF_BURST_SIZE) & BM_MIPI_HSI_TDMAn_CONF_BURST_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BURST_SIZE field to a new value.
#define BW_MIPI_HSI_TDMAn_CONF_BURST_SIZE(n, v)   (HW_MIPI_HSI_TDMAn_CONF_WR(n, (HW_MIPI_HSI_TDMAn_CONF_RD(n) & ~BM_MIPI_HSI_TDMAn_CONF_BURST_SIZE) | BF_MIPI_HSI_TDMAn_CONF_BURST_SIZE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TDMAn_CONF, field ENABLE[31] (RW)
 *
 * Setting this bit enables the inernal Tx DMA channel n.
 */
//@{
#define BP_MIPI_HSI_TDMAn_CONF_ENABLE      (31)      //!< Bit position for MIPI_HSI_TDMAn_CONF_ENABLE.
#define BM_MIPI_HSI_TDMAn_CONF_ENABLE      (0x80000000)  //!< Bit mask for MIPI_HSI_TDMAn_CONF_ENABLE.

//! @brief Get value of MIPI_HSI_TDMAn_CONF_ENABLE from a register value.
#define BG_MIPI_HSI_TDMAn_CONF_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TDMAn_CONF_ENABLE) >> BP_MIPI_HSI_TDMAn_CONF_ENABLE)

//! @brief Format value for bitfield MIPI_HSI_TDMAn_CONF_ENABLE.
#define BF_MIPI_HSI_TDMAn_CONF_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TDMAn_CONF_ENABLE) & BM_MIPI_HSI_TDMAn_CONF_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENABLE field to a new value.
#define BW_MIPI_HSI_TDMAn_CONF_ENABLE(n, v)   (HW_MIPI_HSI_TDMAn_CONF_WR(n, (HW_MIPI_HSI_TDMAn_CONF_RD(n) & ~BM_MIPI_HSI_TDMAn_CONF_ENABLE) | BF_MIPI_HSI_TDMAn_CONF_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RDMAn_CONF - Rx DMA Channel n Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RDMAn_CONF - Rx DMA Channel n Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains the configurations of enable/disable, burst size and transfer count for Rx
 * DMA channel n.
 */
typedef union _hw_mipi_hsi_rdman_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_rdman_conf_bitfields
    {
        unsigned RESERVED0 : 5; //!< [4:0] Reserved, always set to zero.
        unsigned TRANS_LENGTH : 20; //!< [24:5] Transfer data length for Rx DMA channel 0.
        unsigned BURST_SIZE : 4; //!< [28:25] Burst size for Rx DMA channel n.
        unsigned RESERVED1 : 2; //!< [30:29] Reserved, always set to zero.
        unsigned ENABLE : 1; //!< [31] Setting this bit enables the inernal Rx DMA channel n.
    } B;
} hw_mipi_hsi_rdman_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RDMAn_CONF register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_RDMAn_CONF register.
#define HW_MIPI_HSI_RDMAn_CONF_COUNT     (16)

#define HW_MIPI_HSI_RDMAn_CONF_ADDR(n)   (REGS_MIPI_HSI_BASE + 0x11c + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RDMAn_CONF(n)        (*(volatile hw_mipi_hsi_rdman_conf_t *) HW_MIPI_HSI_RDMAn_CONF_ADDR(n))
#define HW_MIPI_HSI_RDMAn_CONF_RD(n)     (HW_MIPI_HSI_RDMAn_CONF(n).U)
#define HW_MIPI_HSI_RDMAn_CONF_WR(n, v)  (HW_MIPI_HSI_RDMAn_CONF(n).U = (v))
#define HW_MIPI_HSI_RDMAn_CONF_SET(n, v) (HW_MIPI_HSI_RDMAn_CONF_WR(n, HW_MIPI_HSI_RDMAn_CONF_RD(n) |  (v)))
#define HW_MIPI_HSI_RDMAn_CONF_CLR(n, v) (HW_MIPI_HSI_RDMAn_CONF_WR(n, HW_MIPI_HSI_RDMAn_CONF_RD(n) & ~(v)))
#define HW_MIPI_HSI_RDMAn_CONF_TOG(n, v) (HW_MIPI_HSI_RDMAn_CONF_WR(n, HW_MIPI_HSI_RDMAn_CONF_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RDMAn_CONF bitfields
 */

/*! @name Register MIPI_HSI_RDMAn_CONF, field TRANS_LENGTH[24:5] (RW)
 *
 * Transfer data length for Rx DMA channel 0. The unit is Dword. h1 1Dword to transfer h2 2Dwords to
 * transfer hfffff 1048575Dwords to transfer
 */
//@{
#define BP_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH      (5)      //!< Bit position for MIPI_HSI_RDMAn_CONF_TRANS_LENGTH.
#define BM_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH      (0x01ffffe0)  //!< Bit mask for MIPI_HSI_RDMAn_CONF_TRANS_LENGTH.

//! @brief Get value of MIPI_HSI_RDMAn_CONF_TRANS_LENGTH from a register value.
#define BG_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH) >> BP_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH)

//! @brief Format value for bitfield MIPI_HSI_RDMAn_CONF_TRANS_LENGTH.
#define BF_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH) & BM_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRANS_LENGTH field to a new value.
#define BW_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH(n, v)   (HW_MIPI_HSI_RDMAn_CONF_WR(n, (HW_MIPI_HSI_RDMAn_CONF_RD(n) & ~BM_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH) | BF_MIPI_HSI_RDMAn_CONF_TRANS_LENGTH(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RDMAn_CONF, field BURST_SIZE[28:25] (RW)
 *
 * Burst size for Rx DMA channel n. The unit is Dword. The burst size should not be larger than
 * relevant TRANS_LENGTH and FIFO_SIZE. h0 1Dword to transfer for each burst h1 2Dword to transfer
 * for each burst h2 4Dword to transfer for each burst h10 1024Dword to transfer for each burst
 */
//@{
#define BP_MIPI_HSI_RDMAn_CONF_BURST_SIZE      (25)      //!< Bit position for MIPI_HSI_RDMAn_CONF_BURST_SIZE.
#define BM_MIPI_HSI_RDMAn_CONF_BURST_SIZE      (0x1e000000)  //!< Bit mask for MIPI_HSI_RDMAn_CONF_BURST_SIZE.

//! @brief Get value of MIPI_HSI_RDMAn_CONF_BURST_SIZE from a register value.
#define BG_MIPI_HSI_RDMAn_CONF_BURST_SIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RDMAn_CONF_BURST_SIZE) >> BP_MIPI_HSI_RDMAn_CONF_BURST_SIZE)

//! @brief Format value for bitfield MIPI_HSI_RDMAn_CONF_BURST_SIZE.
#define BF_MIPI_HSI_RDMAn_CONF_BURST_SIZE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RDMAn_CONF_BURST_SIZE) & BM_MIPI_HSI_RDMAn_CONF_BURST_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BURST_SIZE field to a new value.
#define BW_MIPI_HSI_RDMAn_CONF_BURST_SIZE(n, v)   (HW_MIPI_HSI_RDMAn_CONF_WR(n, (HW_MIPI_HSI_RDMAn_CONF_RD(n) & ~BM_MIPI_HSI_RDMAn_CONF_BURST_SIZE) | BF_MIPI_HSI_RDMAn_CONF_BURST_SIZE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RDMAn_CONF, field ENABLE[31] (RW)
 *
 * Setting this bit enables the inernal Rx DMA channel n.
 */
//@{
#define BP_MIPI_HSI_RDMAn_CONF_ENABLE      (31)      //!< Bit position for MIPI_HSI_RDMAn_CONF_ENABLE.
#define BM_MIPI_HSI_RDMAn_CONF_ENABLE      (0x80000000)  //!< Bit mask for MIPI_HSI_RDMAn_CONF_ENABLE.

//! @brief Get value of MIPI_HSI_RDMAn_CONF_ENABLE from a register value.
#define BG_MIPI_HSI_RDMAn_CONF_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RDMAn_CONF_ENABLE) >> BP_MIPI_HSI_RDMAn_CONF_ENABLE)

//! @brief Format value for bitfield MIPI_HSI_RDMAn_CONF_ENABLE.
#define BF_MIPI_HSI_RDMAn_CONF_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RDMAn_CONF_ENABLE) & BM_MIPI_HSI_RDMAn_CONF_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENABLE field to a new value.
#define BW_MIPI_HSI_RDMAn_CONF_ENABLE(n, v)   (HW_MIPI_HSI_RDMAn_CONF_WR(n, (HW_MIPI_HSI_RDMAn_CONF_RD(n) & ~BM_MIPI_HSI_RDMAn_CONF_ENABLE) | BF_MIPI_HSI_RDMAn_CONF_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TDMAn_STA_ADDR - Tx DMA Channel n Start Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TDMAn_STA_ADDR - Tx DMA Channel n Start Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register containts the physical Start Address HSI for Tx DMA Channel n.
 */
typedef union _hw_mipi_hsi_tdman_sta_addr
{
    reg32_t U;
    struct _hw_mipi_hsi_tdman_sta_addr_bitfields
    {
        unsigned RESERVED0 : 2; //!< [1:0] Reserved, always set to zero.
        unsigned DS_ADDR : 30; //!< [31:2] The Physical Start Address for Tx DMA Channel n.
    } B;
} hw_mipi_hsi_tdman_sta_addr_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TDMAn_STA_ADDR register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_TDMAn_STA_ADDR register.
#define HW_MIPI_HSI_TDMAn_STA_ADDR_COUNT     (16)

#define HW_MIPI_HSI_TDMAn_STA_ADDR_ADDR(n)   (REGS_MIPI_HSI_BASE + 0x15c + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TDMAn_STA_ADDR(n)        (*(volatile hw_mipi_hsi_tdman_sta_addr_t *) HW_MIPI_HSI_TDMAn_STA_ADDR_ADDR(n))
#define HW_MIPI_HSI_TDMAn_STA_ADDR_RD(n)     (HW_MIPI_HSI_TDMAn_STA_ADDR(n).U)
#define HW_MIPI_HSI_TDMAn_STA_ADDR_WR(n, v)  (HW_MIPI_HSI_TDMAn_STA_ADDR(n).U = (v))
#define HW_MIPI_HSI_TDMAn_STA_ADDR_SET(n, v) (HW_MIPI_HSI_TDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_TDMAn_STA_ADDR_RD(n) |  (v)))
#define HW_MIPI_HSI_TDMAn_STA_ADDR_CLR(n, v) (HW_MIPI_HSI_TDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_TDMAn_STA_ADDR_RD(n) & ~(v)))
#define HW_MIPI_HSI_TDMAn_STA_ADDR_TOG(n, v) (HW_MIPI_HSI_TDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_TDMAn_STA_ADDR_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TDMAn_STA_ADDR bitfields
 */

/*! @name Register MIPI_HSI_TDMAn_STA_ADDR, field DS_ADDR[31:2] (RW)
 *
 * The Physical Start Address for Tx DMA Channel n. DWord aligned
 */
//@{
#define BP_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR      (2)      //!< Bit position for MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR.
#define BM_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR      (0xfffffffc)  //!< Bit mask for MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR.

//! @brief Get value of MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR from a register value.
#define BG_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR) >> BP_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR)

//! @brief Format value for bitfield MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR.
#define BF_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR) & BM_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DS_ADDR field to a new value.
#define BW_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR(n, v)   (HW_MIPI_HSI_TDMAn_STA_ADDR_WR(n, (HW_MIPI_HSI_TDMAn_STA_ADDR_RD(n) & ~BM_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR) | BF_MIPI_HSI_TDMAn_STA_ADDR_DS_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RDMAn_STA_ADDR - Rx DMA Channel n Start Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RDMAn_STA_ADDR - Rx DMA Channel n Start Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register containts the physical Start Address HSI for Rx DMA Channel n.
 */
typedef union _hw_mipi_hsi_rdman_sta_addr
{
    reg32_t U;
    struct _hw_mipi_hsi_rdman_sta_addr_bitfields
    {
        unsigned RESERVED0 : 2; //!< [1:0] Reserved, always set to zero.
        unsigned DS_ADDR : 30; //!< [31:2] The Physical Start Address for Rx DMA Channel n.
    } B;
} hw_mipi_hsi_rdman_sta_addr_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RDMAn_STA_ADDR register
 */
//@{
//! @brief Number of instances of the MIPI_HSI_RDMAn_STA_ADDR register.
#define HW_MIPI_HSI_RDMAn_STA_ADDR_COUNT     (16)

#define HW_MIPI_HSI_RDMAn_STA_ADDR_ADDR(n)   (REGS_MIPI_HSI_BASE + 0x19c + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RDMAn_STA_ADDR(n)        (*(volatile hw_mipi_hsi_rdman_sta_addr_t *) HW_MIPI_HSI_RDMAn_STA_ADDR_ADDR(n))
#define HW_MIPI_HSI_RDMAn_STA_ADDR_RD(n)     (HW_MIPI_HSI_RDMAn_STA_ADDR(n).U)
#define HW_MIPI_HSI_RDMAn_STA_ADDR_WR(n, v)  (HW_MIPI_HSI_RDMAn_STA_ADDR(n).U = (v))
#define HW_MIPI_HSI_RDMAn_STA_ADDR_SET(n, v) (HW_MIPI_HSI_RDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_RDMAn_STA_ADDR_RD(n) |  (v)))
#define HW_MIPI_HSI_RDMAn_STA_ADDR_CLR(n, v) (HW_MIPI_HSI_RDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_RDMAn_STA_ADDR_RD(n) & ~(v)))
#define HW_MIPI_HSI_RDMAn_STA_ADDR_TOG(n, v) (HW_MIPI_HSI_RDMAn_STA_ADDR_WR(n, HW_MIPI_HSI_RDMAn_STA_ADDR_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RDMAn_STA_ADDR bitfields
 */

/*! @name Register MIPI_HSI_RDMAn_STA_ADDR, field DS_ADDR[31:2] (RW)
 *
 * The Physical Start Address for Rx DMA Channel n. DWord aligned
 */
//@{
#define BP_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR      (2)      //!< Bit position for MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR.
#define BM_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR      (0xfffffffc)  //!< Bit mask for MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR.

//! @brief Get value of MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR from a register value.
#define BG_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR) >> BP_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR)

//! @brief Format value for bitfield MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR.
#define BF_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR) & BM_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DS_ADDR field to a new value.
#define BW_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR(n, v)   (HW_MIPI_HSI_RDMAn_STA_ADDR_WR(n, (HW_MIPI_HSI_RDMAn_STA_ADDR_RD(n) & ~BM_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR) | BF_MIPI_HSI_RDMAn_STA_ADDR_DS_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_IRQSTAT - DMA Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_IRQSTAT - DMA Interrupt Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * This register contains all the interrupt status for HSI internal DMA
 */
typedef union _hw_mipi_hsi_dma_irqstat
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_irqstat_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 interrupt status
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 interrupt status
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 interrupt status
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 interrupt status
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 interrupt status
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 interrupt status
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 interrupt status
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 interrupt status
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 interrupt status
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 interrupt status
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 interrupt status
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 interrupt status
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 interrupt status
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 interrupt status
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 interrupt status
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 interrupt status
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 interrupt status
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 interrupt status
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 interrupt status
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 interrupt status
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 interrupt status
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 interrupt status
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 interrupt status
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 interrupt status
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 interrupt status
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 interrupt status
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 interrupt status
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 interrupt status
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 interrupt status
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 interrupt status
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 interrupt status
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 interrupt status
    } B;
} hw_mipi_hsi_dma_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_IRQSTAT register
 */
//@{
#define HW_MIPI_HSI_DMA_IRQSTAT_ADDR      (REGS_MIPI_HSI_BASE + 0x1dc)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_IRQSTAT           (*(volatile hw_mipi_hsi_dma_irqstat_t *) HW_MIPI_HSI_DMA_IRQSTAT_ADDR)
#define HW_MIPI_HSI_DMA_IRQSTAT_RD()      (HW_MIPI_HSI_DMA_IRQSTAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_IRQSTAT bitfields
 */

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA0[0] (RO)
 *
 * RDMA Channel 0 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA0.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA0) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA1[1] (RO)
 *
 * RDMA Channel 1 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA1.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA1) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA2[2] (RO)
 *
 * RDMA Channel 2 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA2.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA2) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA3[3] (RO)
 *
 * RDMA Channel 3 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA3.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA3) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA4[4] (RO)
 *
 * RDMA Channel 4 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA4.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA4) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA5[5] (RO)
 *
 * RDMA Channel 5 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA5.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA5) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA6[6] (RO)
 *
 * RDMA Channel 6 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA6.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA6) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA7[7] (RO)
 *
 * RDMA Channel 7 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA7.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA7) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA8[8] (RO)
 *
 * RDMA Channel 8 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA8.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA8) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA9[9] (RO)
 *
 * RDMA Channel 9 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA9.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA9) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA10[10] (RO)
 *
 * RDMA Channel 10 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA10.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA10) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA11[11] (RO)
 *
 * RDMA Channel 11 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA11.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA11) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA12[12] (RO)
 *
 * RDMA Channel 12 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA12.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA12) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA13[13] (RO)
 *
 * RDMA Channel 13 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA13.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA13) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA14[14] (RO)
 *
 * RDMA Channel 14 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA14.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA14) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field RDMA15[15] (RO)
 *
 * RDMA Channel 15 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_RDMA15.
#define BM_MIPI_HSI_DMA_IRQSTAT_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_RDMA15) >> BP_MIPI_HSI_DMA_IRQSTAT_RDMA15)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA0[16] (RO)
 *
 * TDMA Channel 0 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA0.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA0) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA1[17] (RO)
 *
 * TDMA Channel 1 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA1.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA1) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA2[18] (RO)
 *
 * TDMA Channel 2 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA2.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA2) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA3[19] (RO)
 *
 * TDMA Channel 3 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA3.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA3) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA4[20] (RO)
 *
 * TDMA Channel 4 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA4.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA4) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA5[21] (RO)
 *
 * TDMA Channel 5 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA5.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA5) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA6[22] (RO)
 *
 * TDMA Channel 6 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA6.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA6) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA7[23] (RO)
 *
 * TDMA Channel 7 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA7.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA7) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA8[24] (RO)
 *
 * TDMA Channel 8 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA8.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA8) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA9[25] (RO)
 *
 * TDMA Channel 9 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA9.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA9) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA10[26] (RO)
 *
 * TDMA Channel 10 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA10.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA10) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA11[27] (RO)
 *
 * TDMA Channel 11 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA11.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA11) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA12[28] (RO)
 *
 * TDMA Channel 12 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA12.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA12) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA13[29] (RO)
 *
 * TDMA Channel 13 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA13.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA13) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA14[30] (RO)
 *
 * TDMA Channel 14 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA14.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA14) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT, field TDMA15[31] (RO)
 *
 * TDMA Channel 15 interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_TDMA15.
#define BM_MIPI_HSI_DMA_IRQSTAT_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_TDMA15) >> BP_MIPI_HSI_DMA_IRQSTAT_TDMA15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_IRQSTAT_EN - DMA Interrupt Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_IRQSTAT_EN - DMA Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register is used to select which DMA interrupt could send to HIS Interrupt Status Register
 */
typedef union _hw_mipi_hsi_dma_irqstat_en
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_irqstat_en_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 interrupt Enable
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 interrupt Enable
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 interrupt Enable
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 interrupt Enable
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 interrupt Enable
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 interrupt Enable
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 interrupt Enable
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 interrupt Enable
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 interrupt Enable
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 interrupt Enable
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 interrupt Enable
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 interrupt Enable
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 interrupt Enable
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 interrupt Enable
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 interrupt Enable
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 interrupt Enable
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 interrupt Enable
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 interrupt Enable
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 interrupt Enable
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 interrupt Enable
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 interrupt Enable
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 interrupt Enable
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 interrupt Enable
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 interrupt Enable
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 interrupt Enable
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 interrupt Enable
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 interrupt Enable
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 interrupt Enable
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 interrupt Enable
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 interrupt Enable
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 interrupt Enable
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 interrupt Enable
    } B;
} hw_mipi_hsi_dma_irqstat_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_IRQSTAT_EN register
 */
//@{
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x1e0)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_IRQSTAT_EN           (*(volatile hw_mipi_hsi_dma_irqstat_en_t *) HW_MIPI_HSI_DMA_IRQSTAT_EN_ADDR)
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_RD()      (HW_MIPI_HSI_DMA_IRQSTAT_EN.U)
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_WR(v)     (HW_MIPI_HSI_DMA_IRQSTAT_EN.U = (v))
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_SET(v)    (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() |  (v)))
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_CLR(v)    (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~(v)))
#define HW_MIPI_HSI_DMA_IRQSTAT_EN_TOG(v)    (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_IRQSTAT_EN bitfields
 */

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA0[0] (RW)
 *
 * RDMA Channel 0 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA0.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA0.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA1[1] (RW)
 *
 * RDMA Channel 1 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA1.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA1.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA2[2] (RW)
 *
 * RDMA Channel 2 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA2.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA2.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA3[3] (RW)
 *
 * RDMA Channel 3 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA3.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA3.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA4[4] (RW)
 *
 * RDMA Channel 4 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA4.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA4.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA5[5] (RW)
 *
 * RDMA Channel 5 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA5.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA5.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA6[6] (RW)
 *
 * RDMA Channel 6 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA6.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA6.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA7[7] (RW)
 *
 * RDMA Channel 7 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA7.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA7.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA8[8] (RW)
 *
 * RDMA Channel 8 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA8.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA8.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA9[9] (RW)
 *
 * RDMA Channel 9 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA9.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA9.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA10[10] (RW)
 *
 * RDMA Channel 10 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA10.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA10.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA11[11] (RW)
 *
 * RDMA Channel 11 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA11.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA11.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA12[12] (RW)
 *
 * RDMA Channel 12 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA12.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA12.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA13[13] (RW)
 *
 * RDMA Channel 13 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA13.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA13.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA14[14] (RW)
 *
 * RDMA Channel 14 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA14.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA14.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field RDMA15[15] (RW)
 *
 * RDMA Channel 15 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_RDMA15.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_RDMA15.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15) & BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15) | BF_MIPI_HSI_DMA_IRQSTAT_EN_RDMA15(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA0[16] (RW)
 *
 * TDMA Channel 0 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA0.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA0.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA1[17] (RW)
 *
 * TDMA Channel 1 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA1.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA1.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA2[18] (RW)
 *
 * TDMA Channel 2 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA2.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA2.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA3[19] (RW)
 *
 * TDMA Channel 3 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA3.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA3.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA4[20] (RW)
 *
 * TDMA Channel 4 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA4.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA4.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA5[21] (RW)
 *
 * TDMA Channel 5 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA5.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA5.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA6[22] (RW)
 *
 * TDMA Channel 6 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA6.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA6.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA7[23] (RW)
 *
 * TDMA Channel 7 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA7.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA7.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA8[24] (RW)
 *
 * TDMA Channel 8 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA8.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA8.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA9[25] (RW)
 *
 * TDMA Channel 9 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA9.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA9.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA10[26] (RW)
 *
 * TDMA Channel 10 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA10.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA10.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA11[27] (RW)
 *
 * TDMA Channel 11 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA11.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA11.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA12[28] (RW)
 *
 * TDMA Channel 12 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA12.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA12.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA13[29] (RW)
 *
 * TDMA Channel 13 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA13.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA13.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA14[30] (RW)
 *
 * TDMA Channel 14 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA14.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA14.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSTAT_EN, field TDMA15[31] (RW)
 *
 * TDMA Channel 15 interrupt Enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_IRQSTAT_EN_TDMA15.
#define BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSTAT_EN_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSTAT_EN_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15) >> BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSTAT_EN_TDMA15.
#define BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15) & BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15(v)   (HW_MIPI_HSI_DMA_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15) | BF_MIPI_HSI_DMA_IRQSTAT_EN_TDMA15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_IRQSIG_EN - DMA Interrupt Status Signal Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_IRQSIG_EN - DMA Interrupt Status Signal Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register is used to select which DMA interrupt status could send to HIS Interrupt Status
 * Register
 */
typedef union _hw_mipi_hsi_dma_irqsig_en
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_irqsig_en_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 interrupt status enable
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 interrupt status enable
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 interrupt status enable
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 interrupt status enable
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 interrupt status enable
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 interrupt status enable
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 interrupt status enable
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 interrupt status enable
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 interrupt status enable
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 interrupt status enable
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 interrupt status enable
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 interrupt status enable
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 interrupt status enable
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 interrupt status enable
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 interrupt status enable
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 interrupt status enable
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 interrupt status enable
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 interrupt status enable
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 interrupt status enable
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 interrupt status enable
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 interrupt status enable
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 interrupt status enable
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 interrupt status enable
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 interrupt status enable
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 interrupt status enable
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 interrupt status enable
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 interrupt status enable
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 interrupt status enable
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 interrupt status enable
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 interrupt status enable
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 interrupt status enable
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 interrupt status enable
    } B;
} hw_mipi_hsi_dma_irqsig_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_IRQSIG_EN register
 */
//@{
#define HW_MIPI_HSI_DMA_IRQSIG_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x1e4)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_IRQSIG_EN           (*(volatile hw_mipi_hsi_dma_irqsig_en_t *) HW_MIPI_HSI_DMA_IRQSIG_EN_ADDR)
#define HW_MIPI_HSI_DMA_IRQSIG_EN_RD()      (HW_MIPI_HSI_DMA_IRQSIG_EN.U)
#define HW_MIPI_HSI_DMA_IRQSIG_EN_WR(v)     (HW_MIPI_HSI_DMA_IRQSIG_EN.U = (v))
#define HW_MIPI_HSI_DMA_IRQSIG_EN_SET(v)    (HW_MIPI_HSI_DMA_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_IRQSIG_EN_RD() |  (v)))
#define HW_MIPI_HSI_DMA_IRQSIG_EN_CLR(v)    (HW_MIPI_HSI_DMA_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~(v)))
#define HW_MIPI_HSI_DMA_IRQSIG_EN_TOG(v)    (HW_MIPI_HSI_DMA_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_IRQSIG_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_IRQSIG_EN bitfields
 */

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA0[0] (RW)
 *
 * RDMA Channel 0 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA0.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA0) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA0.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA0) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA0(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA0) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA1[1] (RW)
 *
 * RDMA Channel 1 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA1.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA1) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA1.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA1) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA1(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA1) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA2[2] (RW)
 *
 * RDMA Channel 2 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA2.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA2) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA2.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA2) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA2(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA2) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA3[3] (RW)
 *
 * RDMA Channel 3 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA3.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA3) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA3.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA3) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA3(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA3) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA4[4] (RW)
 *
 * RDMA Channel 4 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA4.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA4) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA4.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA4) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA4(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA4) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA5[5] (RW)
 *
 * RDMA Channel 5 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA5.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA5) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA5.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA5) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA5(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA5) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA6[6] (RW)
 *
 * RDMA Channel 6 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA6.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA6) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA6.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA6) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA6(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA6) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA7[7] (RW)
 *
 * RDMA Channel 7 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA7.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA7) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA7.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA7) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA7(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA7) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA8[8] (RW)
 *
 * RDMA Channel 8 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA8.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA8) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA8.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA8) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA8(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA8) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA9[9] (RW)
 *
 * RDMA Channel 9 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA9.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA9) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA9.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA9) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA9(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA9) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA10[10] (RW)
 *
 * RDMA Channel 10 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA10.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA10) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA10.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA10) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA10(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA10) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA11[11] (RW)
 *
 * RDMA Channel 11 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA11.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA11) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA11.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA11) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA11(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA11) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA12[12] (RW)
 *
 * RDMA Channel 12 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA12.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA12) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA12.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA12) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA12(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA12) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA13[13] (RW)
 *
 * RDMA Channel 13 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA13.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA13) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA13.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA13) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA13(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA13) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA14[14] (RW)
 *
 * RDMA Channel 14 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA14.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA14) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA14.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA14) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA14(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA14) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field RDMA15[15] (RW)
 *
 * RDMA Channel 15 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_RDMA15.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA15) >> BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_RDMA15.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_RDMA15) & BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_RDMA15(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_RDMA15) | BF_MIPI_HSI_DMA_IRQSIG_EN_RDMA15(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA0[16] (RW)
 *
 * TDMA Channel 0 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA0.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA0) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA0.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA0) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA0(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA0) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA1[17] (RW)
 *
 * TDMA Channel 1 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA1.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA1) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA1.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA1) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA1(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA1) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA2[18] (RW)
 *
 * TDMA Channel 2 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA2.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA2) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA2.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA2) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA2(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA2) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA3[19] (RW)
 *
 * TDMA Channel 3 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA3.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA3) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA3.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA3) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA3(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA3) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA4[20] (RW)
 *
 * TDMA Channel 4 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA4.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA4) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA4.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA4) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA4(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA4) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA5[21] (RW)
 *
 * TDMA Channel 5 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA5.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA5) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA5.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA5) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA5(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA5) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA6[22] (RW)
 *
 * TDMA Channel 6 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA6.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA6) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA6.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA6) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA6(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA6) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA7[23] (RW)
 *
 * TDMA Channel 7 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA7.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA7) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA7.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA7) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA7(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA7) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA8[24] (RW)
 *
 * TDMA Channel 8 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA8.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA8) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA8.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA8) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA8(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA8) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA9[25] (RW)
 *
 * TDMA Channel 9 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA9.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA9) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA9.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA9) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA9(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA9) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA10[26] (RW)
 *
 * TDMA Channel 10 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA10.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA10) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA10.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA10) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA10(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA10) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA11[27] (RW)
 *
 * TDMA Channel 11 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA11.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA11) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA11.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA11) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA11(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA11) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA12[28] (RW)
 *
 * TDMA Channel 12 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA12.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA12) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA12.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA12) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA12(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA12) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA13[29] (RW)
 *
 * TDMA Channel 13 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA13.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA13) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA13.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA13) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA13(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA13) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA14[30] (RW)
 *
 * TDMA Channel 14 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA14.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA14) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA14.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA14) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA14(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA14) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_IRQSIG_EN, field TDMA15[31] (RW)
 *
 * TDMA Channel 15 interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_IRQSIG_EN_TDMA15.
#define BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_IRQSIG_EN_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_IRQSIG_EN_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_IRQSIG_EN_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA15) >> BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_IRQSIG_EN_TDMA15.
#define BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_IRQSIG_EN_TDMA15) & BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_IRQSIG_EN_TDMA15(v)   (HW_MIPI_HSI_DMA_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_IRQSIG_EN_TDMA15) | BF_MIPI_HSI_DMA_IRQSIG_EN_TDMA15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_ERR_IRQSTAT - DMA Error Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_ERR_IRQSTAT - DMA Error Interrupt Status Register (RO)
 *
 * Reset value: 0x00000000
 *
 * This register contains all the error interrupt status for HSI internal DMA
 */
typedef union _hw_mipi_hsi_dma_err_irqstat
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_err_irqstat_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 error interrupt status
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 error interrupt status
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 error interrupt status
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 error interrupt status
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 error interrupt status
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 error interrupt status
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 error interrupt status
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 error interrupt status
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 error interrupt status
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 error interrupt status
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 error interrupt status
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 error interrupt status
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 error interrupt status
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 error interrupt status
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 error interrupt status
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 error interrupt status
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 error interrupt status
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 error interrupt status
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 error interrupt status
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 error interrupt status
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 error interrupt status
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 error interrupt status
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 error interrupt status
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 error interrupt status
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 error interrupt status
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 error interrupt status
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 error interrupt status
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 error interrupt status
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 error interrupt status
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 error interrupt status
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 error interrupt status
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 error interrupt status
    } B;
} hw_mipi_hsi_dma_err_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_ERR_IRQSTAT register
 */
//@{
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_ADDR      (REGS_MIPI_HSI_BASE + 0x1e8)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT           (*(volatile hw_mipi_hsi_dma_err_irqstat_t *) HW_MIPI_HSI_DMA_ERR_IRQSTAT_ADDR)
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_RD()      (HW_MIPI_HSI_DMA_ERR_IRQSTAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_ERR_IRQSTAT bitfields
 */

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA0[0] (RO)
 *
 * RDMA Channel 0 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA1[1] (RO)
 *
 * RDMA Channel 1 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA2[2] (RO)
 *
 * RDMA Channel 2 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA3[3] (RO)
 *
 * RDMA Channel 3 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA4[4] (RO)
 *
 * RDMA Channel 4 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA5[5] (RO)
 *
 * RDMA Channel 5 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA6[6] (RO)
 *
 * RDMA Channel 6 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA7[7] (RO)
 *
 * RDMA Channel 7 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA8[8] (RO)
 *
 * RDMA Channel 8 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA9[9] (RO)
 *
 * RDMA Channel 9 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA10[10] (RO)
 *
 * RDMA Channel 10 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA11[11] (RO)
 *
 * RDMA Channel 11 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA12[12] (RO)
 *
 * RDMA Channel 12 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA13[13] (RO)
 *
 * RDMA Channel 13 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA14[14] (RO)
 *
 * RDMA Channel 14 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field RDMA15[15] (RO)
 *
 * RDMA Channel 15 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_RDMA15)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA0[16] (RO)
 *
 * TDMA Channel 0 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA1[17] (RO)
 *
 * TDMA Channel 1 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA2[18] (RO)
 *
 * TDMA Channel 2 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA3[19] (RO)
 *
 * TDMA Channel 3 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA4[20] (RO)
 *
 * TDMA Channel 4 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA5[21] (RO)
 *
 * TDMA Channel 5 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA6[22] (RO)
 *
 * TDMA Channel 6 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA7[23] (RO)
 *
 * TDMA Channel 7 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA8[24] (RO)
 *
 * TDMA Channel 8 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA9[25] (RO)
 *
 * TDMA Channel 9 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA10[26] (RO)
 *
 * TDMA Channel 10 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA11[27] (RO)
 *
 * TDMA Channel 11 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA12[28] (RO)
 *
 * TDMA Channel 12 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA13[29] (RO)
 *
 * TDMA Channel 13 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA14[30] (RO)
 *
 * TDMA Channel 14 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT, field TDMA15[31] (RO)
 *
 * TDMA Channel 15 error interrupt status
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_TDMA15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN - DMA Error Interrupt Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN - DMA Error Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register is used to select which DMA error interrupt could send to HIS Interrupt Status
 * Register
 */
typedef union _hw_mipi_hsi_dma_err_irqstat_en
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_err_irqstat_en_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 error interrupt enable
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 error interrupt enable
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 error interrupt enable
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 error interrupt enable
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 error interrupt enable
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 error interrupt enable
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 error interrupt enable
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 error interrupt enable
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 error interrupt enable
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 error interrupt enable
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 error interrupt enable
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 error interrupt enable
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 error interrupt enable
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 error interrupt enable
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 error interrupt enable
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 error interrupt enable
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 error interrupt enable
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 error interrupt enable
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 error interrupt enable
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 error interrupt enable
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 error interrupt enable
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 error interrupt enable
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 error interrupt enable
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 error interrupt enable
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 error interrupt enable
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 error interrupt enable
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 error interrupt enable
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 error interrupt enable
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 error interrupt enable
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 error interrupt enable
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 error interrupt enable
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 error interrupt enable
    } B;
} hw_mipi_hsi_dma_err_irqstat_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_ERR_IRQSTAT_EN register
 */
//@{
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x1ec)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN           (*(volatile hw_mipi_hsi_dma_err_irqstat_en_t *) HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_ADDR)
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD()      (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN.U)
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR(v)     (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN.U = (v))
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_SET(v)    (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() |  (v)))
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_CLR(v)    (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~(v)))
#define HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TOG(v)    (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_ERR_IRQSTAT_EN bitfields
 */

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA0[0] (RW)
 *
 * RDMA Channel 0 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA1[1] (RW)
 *
 * RDMA Channel 1 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA2[2] (RW)
 *
 * RDMA Channel 2 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA3[3] (RW)
 *
 * RDMA Channel 3 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA4[4] (RW)
 *
 * RDMA Channel 4 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA5[5] (RW)
 *
 * RDMA Channel 5 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA6[6] (RW)
 *
 * RDMA Channel 6 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA7[7] (RW)
 *
 * RDMA Channel 7 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA8[8] (RW)
 *
 * RDMA Channel 8 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA9[9] (RW)
 *
 * RDMA Channel 9 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA10[10] (RW)
 *
 * RDMA Channel 10 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA11[11] (RW)
 *
 * RDMA Channel 11 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA12[12] (RW)
 *
 * RDMA Channel 12 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA13[13] (RW)
 *
 * RDMA Channel 13 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA14[14] (RW)
 *
 * RDMA Channel 14 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field RDMA15[15] (RW)
 *
 * RDMA Channel 15 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RDMA15(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA0[16] (RW)
 *
 * TDMA Channel 0 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA1[17] (RW)
 *
 * TDMA Channel 1 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA2[18] (RW)
 *
 * TDMA Channel 2 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA3[19] (RW)
 *
 * TDMA Channel 3 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA4[20] (RW)
 *
 * TDMA Channel 4 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA5[21] (RW)
 *
 * TDMA Channel 5 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA6[22] (RW)
 *
 * TDMA Channel 6 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA7[23] (RW)
 *
 * TDMA Channel 7 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA8[24] (RW)
 *
 * TDMA Channel 8 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA9[25] (RW)
 *
 * TDMA Channel 9 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA10[26] (RW)
 *
 * TDMA Channel 10 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA11[27] (RW)
 *
 * TDMA Channel 11 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA12[28] (RW)
 *
 * TDMA Channel 12 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA13[29] (RW)
 *
 * TDMA Channel 13 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA14[30] (RW)
 *
 * TDMA Channel 14 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSTAT_EN, field TDMA15[31] (RW)
 *
 * TDMA Channel 15 error interrupt enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15.
#define BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15) & BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15(v)   (HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSTAT_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15) | BF_MIPI_HSI_DMA_ERR_IRQSTAT_EN_TDMA15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_ERR_IRQSIG_EN - DMA Error Interrupt Signal Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_ERR_IRQSIG_EN - DMA Error Interrupt Signal Enable Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This Register is used to select which DMA error interrupt status could send to HIS Interrupt
 * Status Register
 */
typedef union _hw_mipi_hsi_dma_err_irqsig_en
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_err_irqsig_en_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] RDMA Channel 0 error interrupt status enable
        unsigned RDMA1 : 1; //!< [1] RDMA Channel 1 error interrupt status enable
        unsigned RDMA2 : 1; //!< [2] RDMA Channel 2 error interrupt status enable
        unsigned RDMA3 : 1; //!< [3] RDMA Channel 3 error interrupt status enable
        unsigned RDMA4 : 1; //!< [4] RDMA Channel 4 error interrupt status enable
        unsigned RDMA5 : 1; //!< [5] RDMA Channel 5 error interrupt status enable
        unsigned RDMA6 : 1; //!< [6] RDMA Channel 6 error interrupt status enable
        unsigned RDMA7 : 1; //!< [7] RDMA Channel 7 error interrupt status enable
        unsigned RDMA8 : 1; //!< [8] RDMA Channel 8 error interrupt status enable
        unsigned RDMA9 : 1; //!< [9] RDMA Channel 9 error interrupt status enable
        unsigned RDMA10 : 1; //!< [10] RDMA Channel 10 error interrupt status enable
        unsigned RDMA11 : 1; //!< [11] RDMA Channel 11 error interrupt status enable
        unsigned RDMA12 : 1; //!< [12] RDMA Channel 12 error interrupt status enable
        unsigned RDMA13 : 1; //!< [13] RDMA Channel 13 error interrupt status enable
        unsigned RDMA14 : 1; //!< [14] RDMA Channel 14 error interrupt status enable
        unsigned RDMA15 : 1; //!< [15] RDMA Channel 15 error interrupt status enable
        unsigned TDMA0 : 1; //!< [16] TDMA Channel 0 error interrupt status enable
        unsigned TDMA1 : 1; //!< [17] TDMA Channel 1 error interrupt status enable
        unsigned TDMA2 : 1; //!< [18] TDMA Channel 2 error interrupt status enable
        unsigned TDMA3 : 1; //!< [19] TDMA Channel 3 error interrupt status enable
        unsigned TDMA4 : 1; //!< [20] TDMA Channel 4 error interrupt status enable
        unsigned TDMA5 : 1; //!< [21] TDMA Channel 5 error interrupt status enable
        unsigned TDMA6 : 1; //!< [22] TDMA Channel 6 error interrupt status enable
        unsigned TDMA7 : 1; //!< [23] TDMA Channel 7 error interrupt status enable
        unsigned TDMA8 : 1; //!< [24] TDMA Channel 8 error interrupt status enable
        unsigned TDMA9 : 1; //!< [25] TDMA Channel 9 error interrupt status enable
        unsigned TDMA10 : 1; //!< [26] TDMA Channel 10 error interrupt status enable
        unsigned TDMA11 : 1; //!< [27] TDMA Channel 11 error interrupt status enable
        unsigned TDMA12 : 1; //!< [28] TDMA Channel 12 error interrupt status enable
        unsigned TDMA13 : 1; //!< [29] TDMA Channel 13 error interrupt status enable
        unsigned TDMA14 : 1; //!< [30] TDMA Channel 14 error interrupt status enable
        unsigned TDMA15 : 1; //!< [31] TDMA Channel 15 error interrupt status enable
    } B;
} hw_mipi_hsi_dma_err_irqsig_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_ERR_IRQSIG_EN register
 */
//@{
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x1f0)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN           (*(volatile hw_mipi_hsi_dma_err_irqsig_en_t *) HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_ADDR)
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD()      (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN.U)
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR(v)     (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN.U = (v))
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_SET(v)    (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() |  (v)))
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_CLR(v)    (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~(v)))
#define HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TOG(v)    (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR(HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_ERR_IRQSIG_EN bitfields
 */

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA0[0] (RW)
 *
 * RDMA Channel 0 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA1[1] (RW)
 *
 * RDMA Channel 1 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA2[2] (RW)
 *
 * RDMA Channel 2 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA3[3] (RW)
 *
 * RDMA Channel 3 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA4[4] (RW)
 *
 * RDMA Channel 4 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA5[5] (RW)
 *
 * RDMA Channel 5 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA6[6] (RW)
 *
 * RDMA Channel 6 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA7[7] (RW)
 *
 * RDMA Channel 7 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA8[8] (RW)
 *
 * RDMA Channel 8 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA9[9] (RW)
 *
 * RDMA Channel 9 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA10[10] (RW)
 *
 * RDMA Channel 10 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA11[11] (RW)
 *
 * RDMA Channel 11 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA12[12] (RW)
 *
 * RDMA Channel 12 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA13[13] (RW)
 *
 * RDMA Channel 13 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA14[14] (RW)
 *
 * RDMA Channel 14 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field RDMA15[15] (RW)
 *
 * RDMA Channel 15 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_RDMA15(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA0[16] (RW)
 *
 * TDMA Channel 0 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA0 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA1[17] (RW)
 *
 * TDMA Channel 1 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA1 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA2[18] (RW)
 *
 * TDMA Channel 2 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA2 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA3[19] (RW)
 *
 * TDMA Channel 3 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA3 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA4[20] (RW)
 *
 * TDMA Channel 4 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA4 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA5[21] (RW)
 *
 * TDMA Channel 5 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA5 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA6[22] (RW)
 *
 * TDMA Channel 6 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA6 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA7[23] (RW)
 *
 * TDMA Channel 7 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA7 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA7(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA8[24] (RW)
 *
 * TDMA Channel 8 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA8 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA9[25] (RW)
 *
 * TDMA Channel 9 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA9 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA10[26] (RW)
 *
 * TDMA Channel 10 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA10 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA11[27] (RW)
 *
 * TDMA Channel 11 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA11 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA12[28] (RW)
 *
 * TDMA Channel 12 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA12 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA13[29] (RW)
 *
 * TDMA Channel 13 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA13 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA14[30] (RW)
 *
 * TDMA Channel 14 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA14 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_DMA_ERR_IRQSIG_EN, field TDMA15[31] (RW)
 *
 * TDMA Channel 15 error interrupt status enable
 */
//@{
#define BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15.
#define BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15) >> BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15)

//! @brief Format value for bitfield MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15.
#define BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15) & BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDMA15 field to a new value.
#define BW_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15(v)   (HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_WR((HW_MIPI_HSI_DMA_ERR_IRQSIG_EN_RD() & ~BM_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15) | BF_MIPI_HSI_DMA_ERR_IRQSIG_EN_TDMA15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_DMA_SINGLE_REQ_EN - DMA Single Request Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_DMA_SINGLE_REQ_EN - DMA Single Request Enable Register (RO)
 *
 * Reset value: 0x00000000
 *
 * This Register is used to debug
 */
typedef union _hw_mipi_hsi_dma_single_req_en
{
    reg32_t U;
    struct _hw_mipi_hsi_dma_single_req_en_bitfields
    {
        unsigned RDMA0 : 1; //!< [0] When the remain DMA data less than one DMA burst size in Rx Dma Channle 0, this bit will be set automatically
        unsigned RDMA1 : 1; //!< [1] When the remain DMA data less than one DMA burst size in Rx Dma Channle 1, this bit will be set automatically
        unsigned RDMA2 : 1; //!< [2] When the remain DMA data less than one DMA burst size in Rx Dma Channle 2, this bit will be set automatically
        unsigned RDMA3 : 1; //!< [3] When the remain DMA data less than one DMA burst size in Rx Dma Channle 3, this bit will be set automatically
        unsigned RDMA4 : 1; //!< [4] When the remain DMA data less than one DMA burst size in Rx Dma Channle 4, this bit will be set automatically
        unsigned RDMA5 : 1; //!< [5] When the remain DMA data less than one DMA burst size in Rx Dma Channle 5, this bit will be set automatically
        unsigned RDMA6 : 1; //!< [6] When the remain DMA data less than one DMA burst size in Rx Dma Channle 6, this bit will be set automatically
        unsigned RDMA7 : 1; //!< [7] When the remain DMA data less than one DMA burst size in Rx Dma Channle 7, this bit will be set automatically
        unsigned RDMA8 : 1; //!< [8] When the remain DMA data less than one DMA burst size in Rx Dma Channle 8, this bit will be set automatically
        unsigned RDMA9 : 1; //!< [9] When the remain DMA data less than one DMA burst size in Rx Dma Channle 9, this bit will be set automatically
        unsigned RDMA10 : 1; //!< [10] When the remain DMA data less than one DMA burst size in Rx Dma Channle 10, this bit will be set automatically
        unsigned RDMA11 : 1; //!< [11] When the remain DMA data less than one DMA burst size in Rx Dma Channle 11, this bit will be set automatically
        unsigned RDMA12 : 1; //!< [12] When the remain DMA data less than one DMA burst size in Rx Dma Channle 12, this bit will be set automatically
        unsigned RDMA13 : 1; //!< [13] When the remain DMA data less than one DMA burst size in Rx Dma Channle 13, this bit will be set automatically
        unsigned RDMA14 : 1; //!< [14] When the remain DMA data less than one DMA burst size in Rx Dma Channle 14, this bit will be set automatically
        unsigned RDMA15 : 1; //!< [15] When the remain DMA data less than one DMA burst size in Rx Dma Channle 15, this bit will be set automatically
        unsigned TDMA0 : 1; //!< [16] When the remain DMA data less than one DMA burst size in Tx Dma Channle 0, this bit will be set automatically
        unsigned TDMA1 : 1; //!< [17] When the remain DMA data less than one DMA burst size in Tx Dma Channle 1, this bit will be set automatically
        unsigned TDMA2 : 1; //!< [18] When the remain DMA data less than one DMA burst size in Tx Dma Channle 2, this bit will be set automatically
        unsigned TDMA3 : 1; //!< [19] When the remain DMA data less than one DMA burst size in Tx Dma Channle 3, this bit will be set automatically
        unsigned TDMA4 : 1; //!< [20] When the remain DMA data less than one DMA burst size in Tx Dma Channle 4, this bit will be set automatically
        unsigned TDMA5 : 1; //!< [21] When the remain DMA data less than one DMA burst size in Tx Dma Channle 5, this bit will be set automatically
        unsigned TDMA6 : 1; //!< [22] When the remain DMA data less than one DMA burst size in Tx Dma Channle 6, this bit will be set automatically
        unsigned TDMA7 : 1; //!< [23] When the remain DMA data less than one DMA burst size in Tx Dma Channle 7, this bit will be set automatically
        unsigned TDMA8 : 1; //!< [24] When the remain DMA data less than one DMA burst size in Tx Dma Channle 8, this bit will be set automatically
        unsigned TDMA9 : 1; //!< [25] When the remain DMA data less than one DMA burst size in Tx Dma Channle 9, this bit will be set automatically
        unsigned TDMA10 : 1; //!< [26] When the remain DMA data less than one DMA burst size in Tx Dma Channle 10, this bit will be set automatically
        unsigned TDMA11 : 1; //!< [27] When the remain DMA data less than one DMA burst size in Tx Dma Channle 11, this bit will be set automatically
        unsigned TDMA12 : 1; //!< [28] When the remain DMA data less than one DMA burst size in Tx Dma Channle 12, this bit will be set automatically
        unsigned TDMA13 : 1; //!< [29] When the remain DMA data less than one DMA burst size in Tx Dma Channle 13, this bit will be set automatically
        unsigned TDMA14 : 1; //!< [30] When the remain DMA data less than one DMA burst size in Tx Dma Channle 14, this bit will be set automatically
        unsigned TDMA15 : 1; //!< [31] When the remain DMA data less than one DMA burst size in Tx Dma Channle 15, this bit will be set automatically
    } B;
} hw_mipi_hsi_dma_single_req_en_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_DMA_SINGLE_REQ_EN register
 */
//@{
#define HW_MIPI_HSI_DMA_SINGLE_REQ_EN_ADDR      (REGS_MIPI_HSI_BASE + 0x1f4)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_DMA_SINGLE_REQ_EN           (*(volatile hw_mipi_hsi_dma_single_req_en_t *) HW_MIPI_HSI_DMA_SINGLE_REQ_EN_ADDR)
#define HW_MIPI_HSI_DMA_SINGLE_REQ_EN_RD()      (HW_MIPI_HSI_DMA_SINGLE_REQ_EN.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_DMA_SINGLE_REQ_EN bitfields
 */

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA0[0] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 0, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0      (0)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0      (0x00000001)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA1[1] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 1, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1      (1)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1      (0x00000002)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA2[2] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 2, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2      (2)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2      (0x00000004)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA3[3] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 3, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3      (3)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3      (0x00000008)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA4[4] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 4, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4      (4)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4      (0x00000010)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA5[5] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 5, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5      (5)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5      (0x00000020)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA6[6] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 6, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6      (6)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6      (0x00000040)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA7[7] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 7, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7      (7)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7      (0x00000080)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA8[8] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 8, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8      (8)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8      (0x00000100)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA9[9] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 9, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9      (9)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9      (0x00000200)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA10[10] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 10, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10      (10)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10      (0x00000400)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA11[11] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 11, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11      (11)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11      (0x00000800)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA12[12] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 12, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12      (12)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12      (0x00001000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA13[13] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 13, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13      (13)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13      (0x00002000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA14[14] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 14, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14      (14)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14      (0x00004000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field RDMA15[15] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Rx Dma Channle 15, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15      (15)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15      (0x00008000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_RDMA15)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA0[16] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 0, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0      (16)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0      (0x00010000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA0)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA1[17] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 1, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1      (17)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1      (0x00020000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA1)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA2[18] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 2, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2      (18)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2      (0x00040000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA2)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA3[19] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 3, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3      (19)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3      (0x00080000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA3)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA4[20] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 4, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4      (20)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4      (0x00100000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA4)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA5[21] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 5, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5      (21)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5      (0x00200000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA5)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA6[22] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 6, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6      (22)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6      (0x00400000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA6)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA7[23] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 7, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7      (23)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7      (0x00800000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA7)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA8[24] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 8, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8      (24)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8      (0x01000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA8)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA9[25] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 9, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9      (25)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9      (0x02000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA9)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA10[26] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 10, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10      (26)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10      (0x04000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA10)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA11[27] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 11, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11      (27)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11      (0x08000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA11)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA12[28] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 12, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12      (28)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12      (0x10000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA12)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA13[29] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 13, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13      (29)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13      (0x20000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA13)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA14[30] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 14, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14      (30)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14      (0x40000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA14)
//@}

/*! @name Register MIPI_HSI_DMA_SINGLE_REQ_EN, field TDMA15[31] (RO)
 *
 * When the remain DMA data less than one DMA burst size in Tx Dma Channle 15, this bit will be set
 * automatically
 */
//@{
#define BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15      (31)      //!< Bit position for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15.
#define BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15      (0x80000000)  //!< Bit mask for MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15.

//! @brief Get value of MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15 from a register value.
#define BG_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15) >> BP_MIPI_HSI_DMA_SINGLE_REQ_EN_TDMA15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_FIFO_SIZE_CONF0 - Tx Fifo Size Configuration Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_FIFO_SIZE_CONF0 - Tx Fifo Size Configuration Register 0 (RW)
 *
 * Reset value: 0x55555555
 *
 * This register is used to config each Tx fifo size
 */
typedef union _hw_mipi_hsi_tx_fifo_size_conf0
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_fifo_size_conf0_bitfields
    {
        unsigned CH8 : 4; //!< [3:0] This field is used to set the buffer size for channel 8.
        unsigned CH9 : 4; //!< [7:4] This field is used to set the buffer size for channel 9.
        unsigned CH10 : 4; //!< [11:8] This field is used to set the buffer size for channel 10.
        unsigned CH11 : 4; //!< [15:12] This field is used to set the buffer size for channel 11.
        unsigned CH12 : 4; //!< [19:16] This field is used to set the buffer size for channel 12.
        unsigned CH13 : 4; //!< [23:20] This field is used to set the buffer size for channel 13.
        unsigned CH14 : 4; //!< [27:24] This field is used to set the buffer size for channel 14.
        unsigned CH15 : 4; //!< [31:28] This field is used to set the buffer size for channel 15.
    } B;
} hw_mipi_hsi_tx_fifo_size_conf0_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_FIFO_SIZE_CONF0 register
 */
//@{
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_ADDR      (REGS_MIPI_HSI_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0           (*(volatile hw_mipi_hsi_tx_fifo_size_conf0_t *) HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_ADDR)
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD()      (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0.U)
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR(v)     (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0.U = (v))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_SET(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() |  (v)))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CLR(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~(v)))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_TOG(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_FIFO_SIZE_CONF0 bitfields
 */

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH8[3:0] (RW)
 *
 * This field is used to set the buffer size for channel 8. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 8 buffer size is 1Dword
 * - 0001 - channel 8 buffer size is 2Dwords
 * - 0010 - channel 8 buffer size is 4Dwords
 * - 0011 - channel 8 buffer size is 8Dwords
 * - 0100 - channel 8 buffer size is 16Dwords
 * - 0101 - channel 8 buffer size is 32Dwords
 * - 0110 - channel 8 buffer size is 64Dwords
 * - 0111 - channel 8 buffer size is 128Dwords
 * - 1000 - channel 8 buffer size is 256Dwords
 * - 1001 - channel 8 buffer size is 512Dwords
 * - 1010 - channel 8 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8      (0)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH9[7:4] (RW)
 *
 * This field is used to set the buffer size for channel 9. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 9 buffer size is 1Dword
 * - 0001 - channel 9 buffer size is 2Dwords
 * - 0010 - channel 9 buffer size is 4Dwords
 * - 0011 - channel 9 buffer size is 8Dwords
 * - 0100 - channel 9 buffer size is 16Dwords
 * - 0101 - channel 9 buffer size is 32Dwords
 * - 0110 - channel 9 buffer size is 64Dwords
 * - 0111 - channel 9 buffer size is 128Dwords
 * - 1000 - channel 9 buffer size is 256Dwords
 * - 1001 - channel 9 buffer size is 512Dwords
 * - 1010 - channel 9 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9      (4)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH10[11:8] (RW)
 *
 * This field is used to set the buffer size for channel 10. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 10 buffer size is 1Dword
 * - 0001 - channel 10 buffer size is 2Dwords
 * - 0010 - channel 10 buffer size is 4Dwords
 * - 0011 - channel 10 buffer size is 8Dwords
 * - 0100 - channel 10 buffer size is 16Dwords
 * - 0101 - channel 10 buffer size is 32Dwords
 * - 0110 - channel 10 buffer size is 64Dwords
 * - 0111 - channel 10 buffer size is 128Dwords
 * - 1000 - channel 10 buffer size is 256Dwords
 * - 1001 - channel 10 buffer size is 512Dwords
 * - 1010 - channel 10 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10      (8)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH11[15:12] (RW)
 *
 * This field is used to set the buffer size for channel 11. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 11 buffer size is 1Dword
 * - 0001 - channel 11 buffer size is 2Dwords
 * - 0010 - channel 11 buffer size is 4Dwords
 * - 0011 - channel 11 buffer size is 8Dwords
 * - 0100 - channel 11 buffer size is 16Dwords
 * - 0101 - channel 11 buffer size is 32Dwords
 * - 0110 - channel 11 buffer size is 64Dwords
 * - 0111 - channel 11 buffer size is 128Dwords
 * - 1000 - channel 11 buffer size is 256Dwords
 * - 1001 - channel 11 buffer size is 512Dwords
 * - 1010 - channel 11 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11      (12)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH12[19:16] (RW)
 *
 * This field is used to set the buffer size for channel 12. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 12 buffer size is 1Dword
 * - 0001 - channel 12 buffer size is 2Dwords
 * - 0010 - channel 12 buffer size is 4Dwords
 * - 0011 - channel 12 buffer size is 8Dwords
 * - 0100 - channel 12 buffer size is 16Dwords
 * - 0101 - channel 12 buffer size is 32Dwords
 * - 0110 - channel 12 buffer size is 64Dwords
 * - 0111 - channel 12 buffer size is 128Dwords
 * - 1000 - channel 12 buffer size is 256Dwords
 * - 1001 - channel 12 buffer size is 512Dwords
 * - 1010 - channel 12 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12      (16)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH13[23:20] (RW)
 *
 * This field is used to set the buffer size for channel 13. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 13 buffer size is 1Dword
 * - 0001 - channel 13 buffer size is 2Dwords
 * - 0010 - channel 13 buffer size is 4Dwords
 * - 0011 - channel 13 buffer size is 8Dwords
 * - 0100 - channel 13 buffer size is 16Dwords
 * - 0101 - channel 13 buffer size is 32Dwords
 * - 0110 - channel 13 buffer size is 64Dwords
 * - 0111 - channel 13 buffer size is 128Dwords
 * - 1000 - channel 13 buffer size is 256Dwords
 * - 1001 - channel 13 buffer size is 512Dwords
 * - 1010 - channel 13 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13      (20)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH14[27:24] (RW)
 *
 * This field is used to set the buffer size for channel 14. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 14 buffer size is 1Dword
 * - 0001 - channel 14 buffer size is 2Dwords
 * - 0010 - channel 14 buffer size is 4Dwords
 * - 0011 - channel 14 buffer size is 8Dwords
 * - 0100 - channel 14 buffer size is 16Dwords
 * - 0101 - channel 14 buffer size is 32Dwords
 * - 0110 - channel 14 buffer size is 64Dwords
 * - 0111 - channel 14 buffer size is 128Dwords
 * - 1000 - channel 14 buffer size is 256Dwords
 * - 1001 - channel 14 buffer size is 512Dwords
 * - 1010 - channel 14 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14      (24)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF0, field CH15[31:28] (RW)
 *
 * This field is used to set the buffer size for channel 15. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 15 buffer size is 1Dword
 * - 0001 - channel 15 buffer size is 2Dwords
 * - 0010 - channel 15 buffer size is 4Dwords
 * - 0011 - channel 15 buffer size is 8Dwords
 * - 0100 - channel 15 buffer size is 16Dwords
 * - 0101 - channel 15 buffer size is 32Dwords
 * - 0110 - channel 15 buffer size is 64Dwords
 * - 0111 - channel 15 buffer size is 128Dwords
 * - 1000 - channel 15 buffer size is 256Dwords
 * - 1001 - channel 15 buffer size is 512Dwords
 * - 1010 - channel 15 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15      (28)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF0_CH15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_FIFO_SIZE_CONF1 - Tx Fifo Size Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_FIFO_SIZE_CONF1 - Tx Fifo Size Configuration Register 1 (RW)
 *
 * Reset value: 0x55555555
 *
 * This register is used to config each Tx fifo size
 */
typedef union _hw_mipi_hsi_tx_fifo_size_conf1
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_fifo_size_conf1_bitfields
    {
        unsigned CH0 : 4; //!< [3:0] This field is used to set the buffer size for channel 0.
        unsigned CH1 : 4; //!< [7:4] This field is used to set the buffer size for channel 1.
        unsigned CH2 : 4; //!< [11:8] This field is used to set the buffer size for channel 2.
        unsigned CH3 : 4; //!< [15:12] This field is used to set the buffer size for channel 3.
        unsigned CH4 : 4; //!< [19:16] This field is used to set the buffer size for channel 4.
        unsigned CH5 : 4; //!< [23:20] This field is used to set the buffer size for channel 5.
        unsigned CH6 : 4; //!< [27:24] This field is used to set the buffer size for channel 6.
        unsigned CH7 : 4; //!< [31:28] This field is used to set the buffer size for channel 7.
    } B;
} hw_mipi_hsi_tx_fifo_size_conf1_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_FIFO_SIZE_CONF1 register
 */
//@{
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_ADDR      (REGS_MIPI_HSI_BASE + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1           (*(volatile hw_mipi_hsi_tx_fifo_size_conf1_t *) HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_ADDR)
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD()      (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1.U)
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR(v)     (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1.U = (v))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_SET(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() |  (v)))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CLR(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~(v)))
#define HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_TOG(v)    (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_FIFO_SIZE_CONF1 bitfields
 */

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH0[3:0] (RW)
 *
 * This field is used to set the buffer size for channel 0. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 0 buffer size is 1Dword
 * - 0001 - channel 0 buffer size is 2Dwords
 * - 0010 - channel 0 buffer size is 4Dwords
 * - 0011 - channel 0 buffer size is 8Dwords
 * - 0100 - channel 0 buffer size is 16Dwords
 * - 0101 - channel 0 buffer size is 32Dwords
 * - 0110 - channel 0 buffer size is 64Dwords
 * - 0111 - channel 0 buffer size is 128Dwords
 * - 1000 - channel 0 buffer size is 256Dwords
 * - 1001 - channel 0 buffer size is 512Dwords
 * - 1010 - channel 0 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0      (0)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0      (0x0000000f)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH1[7:4] (RW)
 *
 * This field is used to set the buffer size for channel 1. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 1 buffer size is 1Dword
 * - 0001 - channel 1 buffer size is 2Dwords
 * - 0010 - channel 1 buffer size is 4Dwords
 * - 0011 - channel 1 buffer size is 8Dwords
 * - 0100 - channel 1 buffer size is 16Dwords
 * - 0101 - channel 1 buffer size is 32Dwords
 * - 0110 - channel 1 buffer size is 64Dwords
 * - 0111 - channel 1 buffer size is 128Dwords
 * - 1000 - channel 1 buffer size is 256Dwords
 * - 1001 - channel 1 buffer size is 512Dwords
 * - 1010 - channel 1 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1      (4)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1      (0x000000f0)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH2[11:8] (RW)
 *
 * This field is used to set the buffer size for channel 2. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 2 buffer size is 1Dword
 * - 0001 - channel 2 buffer size is 2Dwords
 * - 0010 - channel 2 buffer size is 4Dwords
 * - 0011 - channel 2 buffer size is 8Dwords
 * - 0100 - channel 2 buffer size is 16Dwords
 * - 0101 - channel 2 buffer size is 32Dwords
 * - 0110 - channel 2 buffer size is 64Dwords
 * - 0111 - channel 2 buffer size is 128Dwords
 * - 1000 - channel 2 buffer size is 256Dwords
 * - 1001 - channel 2 buffer size is 512Dwords
 * - 1010 - channel 2 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2      (8)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2      (0x00000f00)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH3[15:12] (RW)
 *
 * This field is used to set the buffer size for channel 3. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 3 buffer size is 1Dword
 * - 0001 - channel 3 buffer size is 2Dwords
 * - 0010 - channel 3 buffer size is 4Dwords
 * - 0011 - channel 3 buffer size is 8Dwords
 * - 0100 - channel 3 buffer size is 16Dwords
 * - 0101 - channel 3 buffer size is 32Dwords
 * - 0110 - channel 3 buffer size is 64Dwords
 * - 0111 - channel 3 buffer size is 128Dwords
 * - 1000 - channel 3 buffer size is 256Dwords
 * - 1001 - channel 3 buffer size is 512Dwords
 * - 1010 - channel 3 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3      (12)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3      (0x0000f000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH4[19:16] (RW)
 *
 * This field is used to set the buffer size for channel 4. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 4 buffer size is 1Dword
 * - 0001 - channel 4 buffer size is 2Dwords
 * - 0010 - channel 4 buffer size is 4Dwords
 * - 0011 - channel 4 buffer size is 8Dwords
 * - 0100 - channel 4 buffer size is 16Dwords
 * - 0101 - channel 4 buffer size is 32Dwords
 * - 0110 - channel 4 buffer size is 64Dwords
 * - 0111 - channel 4 buffer size is 128Dwords
 * - 1000 - channel 4 buffer size is 256Dwords
 * - 1001 - channel 4 buffer size is 512Dwords
 * - 1010 - channel 4 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4      (16)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4      (0x000f0000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH5[23:20] (RW)
 *
 * This field is used to set the buffer size for channel 5. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 5 buffer size is 1Dword
 * - 0001 - channel 5 buffer size is 2Dwords
 * - 0010 - channel 5 buffer size is 4Dwords
 * - 0011 - channel 5 buffer size is 8Dwords
 * - 0100 - channel 5 buffer size is 16Dwords
 * - 0101 - channel 5 buffer size is 32Dwords
 * - 0110 - channel 5 buffer size is 64Dwords
 * - 0111 - channel 5 buffer size is 128Dwords
 * - 1000 - channel 5 buffer size is 256Dwords
 * - 1001 - channel 5 buffer size is 512Dwords
 * - 1010 - channel 5 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5      (20)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5      (0x00f00000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH6[27:24] (RW)
 *
 * This field is used to set the buffer size for channel 6. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 6 buffer size is 1Dword
 * - 0001 - channel 6 buffer size is 2Dwords
 * - 0010 - channel 6 buffer size is 4Dwords
 * - 0011 - channel 6 buffer size is 8Dwords
 * - 0100 - channel 6 buffer size is 16Dwords
 * - 0101 - channel 6 buffer size is 32Dwords
 * - 0110 - channel 6 buffer size is 64Dwords
 * - 0111 - channel 6 buffer size is 128Dwords
 * - 1000 - channel 6 buffer size is 256Dwords
 * - 1001 - channel 6 buffer size is 512Dwords
 * - 1010 - channel 6 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6      (24)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6      (0x0f000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_TX_FIFO_SIZE_CONF1, field CH7[31:28] (RW)
 *
 * This field is used to set the buffer size for channel 7. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 7 buffer size is 1Dword
 * - 0001 - channel 7 buffer size is 2Dwords
 * - 0010 - channel 7 buffer size is 4Dwords
 * - 0011 - channel 7 buffer size is 8Dwords
 * - 0100 - channel 7 buffer size is 16Dwords
 * - 0101 - channel 7 buffer size is 32Dwords
 * - 0110 - channel 7 buffer size is 64Dwords
 * - 0111 - channel 7 buffer size is 128Dwords
 * - 1000 - channel 7 buffer size is 256Dwords
 * - 1001 - channel 7 buffer size is 512Dwords
 * - 1010 - channel 7 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7      (28)      //!< Bit position for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7.
#define BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7      (0xf0000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7.

//! @brief Get value of MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7 from a register value.
#define BG_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7) >> BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7)

//! @brief Format value for bitfield MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7.
#define BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7) & BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7 field to a new value.
#define BW_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7(v)   (HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_TX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7) | BF_MIPI_HSI_TX_FIFO_SIZE_CONF1_CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RX_FIFO_SIZE_CONF0 - Rx Fifo Size Configuration Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RX_FIFO_SIZE_CONF0 - Rx Fifo Size Configuration Register 0 (RW)
 *
 * Reset value: 0x55555555
 *
 * This register is used to config each Rx fifo size
 */
typedef union _hw_mipi_hsi_rx_fifo_size_conf0
{
    reg32_t U;
    struct _hw_mipi_hsi_rx_fifo_size_conf0_bitfields
    {
        unsigned CH8 : 4; //!< [3:0] This field is used to set the buffer size for channel 8.
        unsigned CH9 : 4; //!< [7:4] This field is used to set the buffer size for channel 9.
        unsigned CH10 : 4; //!< [11:8] This field is used to set the buffer size for channel 10.
        unsigned CH11 : 4; //!< [15:12] This field is used to set the buffer size for channel 11.
        unsigned CH12 : 4; //!< [19:16] This field is used to set the buffer size for channel 12.
        unsigned CH13 : 4; //!< [23:20] This field is used to set the buffer size for channel 13.
        unsigned CH14 : 4; //!< [27:24] This field is used to set the buffer size for channel 14.
        unsigned CH15 : 4; //!< [31:28] This field is used to set the buffer size for channel 15.
    } B;
} hw_mipi_hsi_rx_fifo_size_conf0_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RX_FIFO_SIZE_CONF0 register
 */
//@{
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_ADDR      (REGS_MIPI_HSI_BASE + 0x208)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0           (*(volatile hw_mipi_hsi_rx_fifo_size_conf0_t *) HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_ADDR)
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD()      (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0.U)
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR(v)     (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0.U = (v))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_SET(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() |  (v)))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CLR(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~(v)))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_TOG(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RX_FIFO_SIZE_CONF0 bitfields
 */

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH8[3:0] (RW)
 *
 * This field is used to set the buffer size for channel 8. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 8 buffer size is 1Dword
 * - 0001 - channel 8 buffer size is 2Dwords
 * - 0010 - channel 8 buffer size is 4Dwords
 * - 0011 - channel 8 buffer size is 8Dwords
 * - 0100 - channel 8 buffer size is 16Dwords
 * - 0101 - channel 8 buffer size is 32Dwords
 * - 0110 - channel 8 buffer size is 64Dwords
 * - 0111 - channel 8 buffer size is 128Dwords
 * - 1000 - channel 8 buffer size is 256Dwords
 * - 1001 - channel 8 buffer size is 512Dwords
 * - 1010 - channel 8 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8      (0)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8      (0x0000000f)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH8 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH8(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH9[7:4] (RW)
 *
 * This field is used to set the buffer size for channel 9. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 9 buffer size is 1Dword
 * - 0001 - channel 9 buffer size is 2Dwords
 * - 0010 - channel 9 buffer size is 4Dwords
 * - 0011 - channel 9 buffer size is 8Dwords
 * - 0100 - channel 9 buffer size is 16Dwords
 * - 0101 - channel 9 buffer size is 32Dwords
 * - 0110 - channel 9 buffer size is 64Dwords
 * - 0111 - channel 9 buffer size is 128Dwords
 * - 1000 - channel 9 buffer size is 256Dwords
 * - 1001 - channel 9 buffer size is 512Dwords
 * - 1010 - channel 9 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9      (4)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9      (0x000000f0)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH9 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH9(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH10[11:8] (RW)
 *
 * This field is used to set the buffer size for channel 10. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 10 buffer size is 1Dword
 * - 0001 - channel 10 buffer size is 2Dwords
 * - 0010 - channel 10 buffer size is 4Dwords
 * - 0011 - channel 10 buffer size is 8Dwords
 * - 0100 - channel 10 buffer size is 16Dwords
 * - 0101 - channel 10 buffer size is 32Dwords
 * - 0110 - channel 10 buffer size is 64Dwords
 * - 0111 - channel 10 buffer size is 128Dwords
 * - 1000 - channel 10 buffer size is 256Dwords
 * - 1001 - channel 10 buffer size is 512Dwords
 * - 1010 - channel 10 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10      (8)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10      (0x00000f00)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH10 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH10(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH11[15:12] (RW)
 *
 * This field is used to set the buffer size for channel 11. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 11 buffer size is 1Dword
 * - 0001 - channel 11 buffer size is 2Dwords
 * - 0010 - channel 11 buffer size is 4Dwords
 * - 0011 - channel 11 buffer size is 8Dwords
 * - 0100 - channel 11 buffer size is 16Dwords
 * - 0101 - channel 11 buffer size is 32Dwords
 * - 0110 - channel 11 buffer size is 64Dwords
 * - 0111 - channel 11 buffer size is 128Dwords
 * - 1000 - channel 11 buffer size is 256Dwords
 * - 1001 - channel 11 buffer size is 512Dwords
 * - 1010 - channel 11 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11      (12)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11      (0x0000f000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH11 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH11(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH12[19:16] (RW)
 *
 * This field is used to set the buffer size for channel 12. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 12 buffer size is 1Dword
 * - 0001 - channel 12 buffer size is 2Dwords
 * - 0010 - channel 12 buffer size is 4Dwords
 * - 0011 - channel 12 buffer size is 8Dwords
 * - 0100 - channel 12 buffer size is 16Dwords
 * - 0101 - channel 12 buffer size is 32Dwords
 * - 0110 - channel 12 buffer size is 64Dwords
 * - 0111 - channel 12 buffer size is 128Dwords
 * - 1000 - channel 12 buffer size is 256Dwords
 * - 1001 - channel 12 buffer size is 512Dwords
 * - 1010 - channel 12 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12      (16)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12      (0x000f0000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH12 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH12(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH13[23:20] (RW)
 *
 * This field is used to set the buffer size for channel 13. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 13 buffer size is 1Dword
 * - 0001 - channel 13 buffer size is 2Dwords
 * - 0010 - channel 13 buffer size is 4Dwords
 * - 0011 - channel 13 buffer size is 8Dwords
 * - 0100 - channel 13 buffer size is 16Dwords
 * - 0101 - channel 13 buffer size is 32Dwords
 * - 0110 - channel 13 buffer size is 64Dwords
 * - 0111 - channel 13 buffer size is 128Dwords
 * - 1000 - channel 13 buffer size is 256Dwords
 * - 1001 - channel 13 buffer size is 512Dwords
 * - 1010 - channel 13 buffer size is 1024Dwords
 * - 1111 - b1011 Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13      (20)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13      (0x00f00000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH13 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH13(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH14[27:24] (RW)
 *
 * This field is used to set the buffer size for channel 14. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 14 buffer size is 1Dword
 * - 0001 - channel 14 buffer size is 2Dwords
 * - 0010 - channel 14 buffer size is 4Dwords
 * - 0011 - channel 14 buffer size is 8Dwords
 * - 0100 - channel 14 buffer size is 16Dwords
 * - 0101 - channel 14 buffer size is 32Dwords
 * - 0110 - channel 14 buffer size is 64Dwords
 * - 0111 - channel 14 buffer size is 128Dwords
 * - 1000 - channel 14 buffer size is 256Dwords
 * - 1001 - channel 14 buffer size is 512Dwords
 * - 1010 - channel 14 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14      (24)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14      (0x0f000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH14 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH14(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF0, field CH15[31:28] (RW)
 *
 * This field is used to set the buffer size for channel 15. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 15 buffer size is 1Dword
 * - 0001 - channel 15 buffer size is 2Dwords
 * - 0010 - channel 15 buffer size is 4Dwords
 * - 0011 - channel 15 buffer size is 8Dwords
 * - 0100 - channel 15 buffer size is 16Dwords
 * - 0101 - channel 15 buffer size is 32Dwords
 * - 0110 - channel 15 buffer size is 64Dwords
 * - 0111 - channel 15 buffer size is 128Dwords
 * - 1000 - channel 15 buffer size is 256Dwords
 * - 1001 - channel 15 buffer size is 512Dwords
 * - 1010 - channel 15 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15      (28)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15      (0xf0000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH15 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF0_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF0_CH15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RX_FIFO_SIZE_CONF1 - Rx Fifo Size Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RX_FIFO_SIZE_CONF1 - Rx Fifo Size Configuration Register 1 (RW)
 *
 * Reset value: 0x55555555
 *
 * This register is used to config each Rx fifo size
 */
typedef union _hw_mipi_hsi_rx_fifo_size_conf1
{
    reg32_t U;
    struct _hw_mipi_hsi_rx_fifo_size_conf1_bitfields
    {
        unsigned CH0 : 4; //!< [3:0] This field is used to set the buffer size for channel 0.
        unsigned CH1 : 4; //!< [7:4] This field is used to set the buffer size for channel 1.
        unsigned CH2 : 4; //!< [11:8] This field is used to set the buffer size for channel 2.
        unsigned CH3 : 4; //!< [15:12] This field is used to set the buffer size for channel 3.
        unsigned CH4 : 4; //!< [19:16] This field is used to set the buffer size for channel 4.
        unsigned CH5 : 4; //!< [23:20] This field is used to set the buffer size for channel 5.
        unsigned CH6 : 4; //!< [27:24] This field is used to set the buffer size for channel 6.
        unsigned CH7 : 4; //!< [31:28] This field is used to set the buffer size for channel 7.
    } B;
} hw_mipi_hsi_rx_fifo_size_conf1_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RX_FIFO_SIZE_CONF1 register
 */
//@{
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_ADDR      (REGS_MIPI_HSI_BASE + 0x20c)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1           (*(volatile hw_mipi_hsi_rx_fifo_size_conf1_t *) HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_ADDR)
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD()      (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1.U)
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR(v)     (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1.U = (v))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_SET(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() |  (v)))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CLR(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~(v)))
#define HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_TOG(v)    (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR(HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RX_FIFO_SIZE_CONF1 bitfields
 */

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH0[3:0] (RW)
 *
 * This field is used to set the buffer size for channel 0. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 0 buffer size is 1Dword
 * - 0001 - channel 0 buffer size is 2Dwords
 * - 0010 - channel 0 buffer size is 4Dwords
 * - 0011 - channel 0 buffer size is 8Dwords
 * - 0100 - channel 0 buffer size is 16Dwords
 * - 0101 - channel 0 buffer size is 32Dwords
 * - 0110 - channel 0 buffer size is 64Dwords
 * - 0111 - channel 0 buffer size is 128Dwords
 * - 1000 - channel 0 buffer size is 256Dwords
 * - 1001 - channel 0 buffer size is 512Dwords
 * - 1010 - channel 0 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0      (0)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0      (0x0000000f)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH0(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH1[7:4] (RW)
 *
 * This field is used to set the buffer size for channel 1. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 1 buffer size is 1Dword
 * - 0001 - channel 1 buffer size is 2Dwords
 * - 0010 - channel 1 buffer size is 4Dwords
 * - 0011 - channel 1 buffer size is 8Dwords
 * - 0100 - channel 1 buffer size is 16Dwords
 * - 0101 - channel 1 buffer size is 32Dwords
 * - 0110 - channel 1 buffer size is 64Dwords
 * - 0111 - channel 1 buffer size is 128Dwords
 * - 1000 - channel 1 buffer size is 256Dwords
 * - 1001 - channel 1 buffer size is 512Dwords
 * - 1010 - channel 1 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1      (4)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1      (0x000000f0)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH1(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH2[11:8] (RW)
 *
 * This field is used to set the buffer size for channel 2. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 2 buffer size is 1Dword
 * - 0001 - channel 2 buffer size is 2Dwords
 * - 0010 - channel 2 buffer size is 4Dwords
 * - 0011 - channel 2 buffer size is 8Dwords
 * - 0100 - channel 2 buffer size is 16Dwords
 * - 0101 - channel 2 buffer size is 32Dwords
 * - 0110 - channel 2 buffer size is 64Dwords
 * - 0111 - channel 2 buffer size is 128Dwords
 * - 1000 - channel 2 buffer size is 256Dwords
 * - 1001 - channel 2 buffer size is 512Dwords
 * - 1010 - channel 2 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2      (8)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2      (0x00000f00)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH2(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH3[15:12] (RW)
 *
 * This field is used to set the buffer size for channel 3. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 3 buffer size is 1Dword
 * - 0001 - channel 3 buffer size is 2Dwords
 * - 0010 - channel 3 buffer size is 4Dwords
 * - 0011 - channel 3 buffer size is 8Dwords
 * - 0100 - channel 3 buffer size is 16Dwords
 * - 0101 - channel 3 buffer size is 32Dwords
 * - 0110 - channel 3 buffer size is 64Dwords
 * - 0111 - channel 3 buffer size is 128Dwords
 * - 1000 - channel 3 buffer size is 256Dwords
 * - 1001 - channel 3 buffer size is 512Dwords
 * - 1010 - channel 3 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3      (12)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3      (0x0000f000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH3 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH3(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH4[19:16] (RW)
 *
 * This field is used to set the buffer size for channel 4. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 4 buffer size is 1Dword
 * - 0001 - channel 4 buffer size is 2Dwords
 * - 0010 - channel 4 buffer size is 4Dwords
 * - 0011 - channel 4 buffer size is 8Dwords
 * - 0100 - channel 4 buffer size is 16Dwords
 * - 0101 - channel 4 buffer size is 32Dwords
 * - 0110 - channel 4 buffer size is 64Dwords
 * - 0111 - channel 4 buffer size is 128Dwords
 * - 1000 - channel 4 buffer size is 256Dwords
 * - 1001 - channel 4 buffer size is 512Dwords
 * - 1010 - channel 4 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4      (16)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4      (0x000f0000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH4 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH4(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH5[23:20] (RW)
 *
 * This field is used to set the buffer size for channel 5. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 5 buffer size is 1Dword
 * - 0001 - channel 5 buffer size is 2Dwords
 * - 0010 - channel 5 buffer size is 4Dwords
 * - 0011 - channel 5 buffer size is 8Dwords
 * - 0100 - channel 5 buffer size is 16Dwords
 * - 0101 - channel 5 buffer size is 32Dwords
 * - 0110 - channel 5 buffer size is 64Dwords
 * - 0111 - channel 5 buffer size is 128Dwords
 * - 1000 - channel 5 buffer size is 256Dwords
 * - 1001 - channel 5 buffer size is 512Dwords
 * - 1010 - channel 5 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5      (20)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5      (0x00f00000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH5 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH5(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH6[27:24] (RW)
 *
 * This field is used to set the buffer size for channel 6. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 6 buffer size is 1Dword
 * - 0001 - channel 6 buffer size is 2Dwords
 * - 0010 - channel 6 buffer size is 4Dwords
 * - 0011 - channel 6 buffer size is 8Dwords
 * - 0100 - channel 6 buffer size is 16Dwords
 * - 0101 - channel 6 buffer size is 32Dwords
 * - 0110 - channel 6 buffer size is 64Dwords
 * - 0111 - channel 6 buffer size is 128Dwords
 * - 1000 - channel 6 buffer size is 256Dwords
 * - 1001 - channel 6 buffer size is 512Dwords
 * - 1010 - channel 6 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6      (24)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6      (0x0f000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH6 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH6(v)))
#endif
//@}

/*! @name Register MIPI_HSI_RX_FIFO_SIZE_CONF1, field CH7[31:28] (RW)
 *
 * This field is used to set the buffer size for channel 7. All the allowed combinations of bit
 * setting are listed here .
 *
 * Values:
 * - 0000 - channel 7 buffer size is 1Dword
 * - 0001 - channel 7 buffer size is 2Dwords
 * - 0010 - channel 7 buffer size is 4Dwords
 * - 0011 - channel 7 buffer size is 8Dwords
 * - 0100 - channel 7 buffer size is 16Dwords
 * - 0101 - channel 7 buffer size is 32Dwords
 * - 0110 - channel 7 buffer size is 64Dwords
 * - 0111 - channel 7 buffer size is 128Dwords
 * - 1000 - channel 7 buffer size is 256Dwords
 * - 1001 - channel 7 buffer size is 512Dwords
 * - 1010 - channel 7 buffer size is 1024Dwords
 * - 1111-1011 - Reserved
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7      (28)      //!< Bit position for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7.
#define BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7      (0xf0000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7.

//! @brief Get value of MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7 from a register value.
#define BG_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7) >> BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7)

//! @brief Format value for bitfield MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7.
#define BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7) & BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH7 field to a new value.
#define BW_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7(v)   (HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_WR((HW_MIPI_HSI_RX_FIFO_SIZE_CONF1_RD() & ~BM_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7) | BF_MIPI_HSI_RX_FIFO_SIZE_CONF1_CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_FIFO_STAT - Tx Fifo Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_FIFO_STAT - Tx Fifo Status Register (RO)
 *
 * Reset value: 0x55555555
 *
 * This register containts full and empty status for each Tx channel fifo
 */
typedef union _hw_mipi_hsi_tx_fifo_stat
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_fifo_stat_bitfields
    {
        unsigned CH0 : 2; //!< [1:0] 
        unsigned CH1 : 2; //!< [3:2] 
        unsigned CH2 : 2; //!< [5:4] 
        unsigned CH3 : 2; //!< [7:6] 
        unsigned CH4 : 2; //!< [9:8] 
        unsigned CH5 : 2; //!< [11:10] 
        unsigned CH6 : 2; //!< [13:12] 
        unsigned CH7 : 2; //!< [15:14] 
        unsigned CH8 : 2; //!< [17:16] 
        unsigned CH9 : 2; //!< [19:18] 
        unsigned CH10 : 2; //!< [21:20] 
        unsigned CH11 : 2; //!< [23:22] 
        unsigned CH12 : 2; //!< [25:24] 
        unsigned CH13 : 2; //!< [27:26] 
        unsigned CH14 : 2; //!< [29:28] 
        unsigned CH15 : 2; //!< [31:30] 
    } B;
} hw_mipi_hsi_tx_fifo_stat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_FIFO_STAT register
 */
//@{
#define HW_MIPI_HSI_TX_FIFO_STAT_ADDR      (REGS_MIPI_HSI_BASE + 0x210)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_FIFO_STAT           (*(volatile hw_mipi_hsi_tx_fifo_stat_t *) HW_MIPI_HSI_TX_FIFO_STAT_ADDR)
#define HW_MIPI_HSI_TX_FIFO_STAT_RD()      (HW_MIPI_HSI_TX_FIFO_STAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_FIFO_STAT bitfields
 */

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH0[1:0] (RO)
 *
 * Values:
 * - 00 - Tx channel 0 fifo not Empty and Full;
 * - 01 - Tx channel 0 fifo Empty;
 * - 10 - Tx channel 0 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH0      (0)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH0.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH0      (0x00000003)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH0.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH0 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH0) >> BP_MIPI_HSI_TX_FIFO_STAT_CH0)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH1[3:2] (RO)
 *
 * Values:
 * - 00 - Tx channel 1 fifo not Empty and Full;
 * - 01 - Tx channel 1 fifo Empty;
 * - 10 - Tx channel 1 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH1      (2)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH1.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH1      (0x0000000c)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH1.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH1 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH1) >> BP_MIPI_HSI_TX_FIFO_STAT_CH1)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH2[5:4] (RO)
 *
 * Values:
 * - 00 - Tx channel 2 fifo not Empty and Full;
 * - 01 - Tx channel 2 fifo Empty;
 * - 10 - Tx channel 2 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH2      (4)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH2.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH2      (0x00000030)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH2.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH2 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH2) >> BP_MIPI_HSI_TX_FIFO_STAT_CH2)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH3[7:6] (RO)
 *
 * Values:
 * - 00 - Tx channel 3 fifo not Empty and Full;
 * - 01 - Tx channel 3 fifo Empty;
 * - 10 - Tx channel 3 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH3      (6)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH3.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH3      (0x000000c0)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH3.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH3 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH3) >> BP_MIPI_HSI_TX_FIFO_STAT_CH3)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH4[9:8] (RO)
 *
 * Values:
 * - 00 - Tx channel 4 fifo not Empty and Full;
 * - 01 - Tx channel 4 fifo Empty;
 * - 10 - Tx channel 4 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH4      (8)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH4.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH4      (0x00000300)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH4.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH4 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH4) >> BP_MIPI_HSI_TX_FIFO_STAT_CH4)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH5[11:10] (RO)
 *
 * Values:
 * - 00 - Tx channel 5 fifo not Empty and Full;
 * - 01 - Tx channel 5 fifo Empty;
 * - 10 - Tx channel 5 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH5      (10)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH5.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH5      (0x00000c00)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH5.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH5 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH5) >> BP_MIPI_HSI_TX_FIFO_STAT_CH5)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH6[13:12] (RO)
 *
 * Values:
 * - 00 - Tx channel 6 fifo not Empty and Full;
 * - 01 - Tx channel 6 fifo Empty;
 * - 10 - Tx channel 6 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH6      (12)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH6.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH6      (0x00003000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH6.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH6 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH6) >> BP_MIPI_HSI_TX_FIFO_STAT_CH6)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH7[15:14] (RO)
 *
 * Values:
 * - 00 - Tx channel 7 fifo not Empty and Full;
 * - 01 - Tx channel 7 fifo Empty;
 * - 10 - Tx channel 7 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH7      (14)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH7.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH7      (0x0000c000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH7.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH7 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH7) >> BP_MIPI_HSI_TX_FIFO_STAT_CH7)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH8[17:16] (RO)
 *
 * Values:
 * - 00 - Tx channel 8 fifo not Empty and Full;
 * - 01 - Tx channel 8 fifo Empty;
 * - 10 - Tx channel 8 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH8      (16)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH8.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH8      (0x00030000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH8.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH8 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH8) >> BP_MIPI_HSI_TX_FIFO_STAT_CH8)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH9[19:18] (RO)
 *
 * Values:
 * - 00 - Tx channel 9 fifo not Empty and Full;
 * - 01 - Tx channel 9 fifo Empty;
 * - 10 - Tx channel 9 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH9      (18)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH9.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH9      (0x000c0000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH9.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH9 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH9) >> BP_MIPI_HSI_TX_FIFO_STAT_CH9)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH10[21:20] (RO)
 *
 * Values:
 * - 00 - Tx channel 10 fifo not Empty and Full;
 * - 01 - Tx channel 10 fifo Empty;
 * - 10 - Tx channel 10 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH10      (20)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH10.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH10      (0x00300000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH10.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH10 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH10) >> BP_MIPI_HSI_TX_FIFO_STAT_CH10)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH11[23:22] (RO)
 *
 * Values:
 * - 00 - Tx channel 11 fifo not Empty and Full;
 * - 01 - Tx channel 11 fifo Empty;
 * - 10 - Tx channel 11 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH11      (22)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH11.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH11      (0x00c00000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH11.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH11 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH11) >> BP_MIPI_HSI_TX_FIFO_STAT_CH11)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH12[25:24] (RO)
 *
 * Values:
 * - 00 - Tx channel 12 fifo not Empty and Full;
 * - 01 - Tx channel 12 fifo Empty;
 * - 10 - Tx channel 12 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH12      (24)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH12.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH12      (0x03000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH12.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH12 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH12) >> BP_MIPI_HSI_TX_FIFO_STAT_CH12)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH13[27:26] (RO)
 *
 * Values:
 * - 00 - Tx channel 13 fifo not Empty and Full;
 * - 01 - Tx channel 13 fifo Empty;
 * - 10 - Tx channel 13 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH13      (26)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH13.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH13      (0x0c000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH13.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH13 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH13) >> BP_MIPI_HSI_TX_FIFO_STAT_CH13)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH14[29:28] (RO)
 *
 * Values:
 * - 00 - Tx channel 14 fifo not Empty and Full;
 * - 01 - Tx channel 14 fifo Empty;
 * - 10 - Tx channel 14 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH14      (28)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH14.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH14      (0x30000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH14.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH14 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH14) >> BP_MIPI_HSI_TX_FIFO_STAT_CH14)
//@}

/*! @name Register MIPI_HSI_TX_FIFO_STAT, field CH15[31:30] (RO)
 *
 * Values:
 * - 00 - Tx channel 15 fifo not Empty and Full;
 * - 01 - Tx channel 15 fifo Empty;
 * - 10 - Tx channel 15 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_TX_FIFO_STAT_CH15      (30)      //!< Bit position for MIPI_HSI_TX_FIFO_STAT_CH15.
#define BM_MIPI_HSI_TX_FIFO_STAT_CH15      (0xc0000000)  //!< Bit mask for MIPI_HSI_TX_FIFO_STAT_CH15.

//! @brief Get value of MIPI_HSI_TX_FIFO_STAT_CH15 from a register value.
#define BG_MIPI_HSI_TX_FIFO_STAT_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_FIFO_STAT_CH15) >> BP_MIPI_HSI_TX_FIFO_STAT_CH15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_RX_FIFO_STAT - Rx Fifo Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_RX_FIFO_STAT - Rx Fifo Status Register (RO)
 *
 * Reset value: 0x55555555
 *
 * This register containts full and empty status for each Rx channel fifo
 */
typedef union _hw_mipi_hsi_rx_fifo_stat
{
    reg32_t U;
    struct _hw_mipi_hsi_rx_fifo_stat_bitfields
    {
        unsigned CH0 : 2; //!< [1:0] 
        unsigned CH1 : 2; //!< [3:2] 
        unsigned CH2 : 2; //!< [5:4] 
        unsigned CH3 : 2; //!< [7:6] 
        unsigned CH4 : 2; //!< [9:8] 
        unsigned CH5 : 2; //!< [11:10] 
        unsigned CH6 : 2; //!< [13:12] 
        unsigned CH7 : 2; //!< [15:14] 
        unsigned CH8 : 2; //!< [17:16] 
        unsigned CH9 : 2; //!< [19:18] 
        unsigned CH10 : 2; //!< [21:20] 
        unsigned CH11 : 2; //!< [23:22] 
        unsigned CH12 : 2; //!< [25:24] 
        unsigned CH13 : 2; //!< [27:26] 
        unsigned CH14 : 2; //!< [29:28] 
        unsigned CH15 : 2; //!< [31:30] 
    } B;
} hw_mipi_hsi_rx_fifo_stat_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_RX_FIFO_STAT register
 */
//@{
#define HW_MIPI_HSI_RX_FIFO_STAT_ADDR      (REGS_MIPI_HSI_BASE + 0x214)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_RX_FIFO_STAT           (*(volatile hw_mipi_hsi_rx_fifo_stat_t *) HW_MIPI_HSI_RX_FIFO_STAT_ADDR)
#define HW_MIPI_HSI_RX_FIFO_STAT_RD()      (HW_MIPI_HSI_RX_FIFO_STAT.U)
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_RX_FIFO_STAT bitfields
 */

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH0[1:0] (RO)
 *
 * Values:
 * - 00 - Rx channel 0 fifo not Empty and Full;
 * - 01 - Rx channel 0 fifo Empty;
 * - 10 - Rx channel 0 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH0      (0)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH0.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH0      (0x00000003)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH0.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH0 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH0) >> BP_MIPI_HSI_RX_FIFO_STAT_CH0)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH1[3:2] (RO)
 *
 * Values:
 * - 00 - Rx channel 1 fifo not Empty and Full;
 * - 01 - Rx channel 1 fifo Empty;
 * - 10 - Rx channel 1 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH1      (2)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH1.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH1      (0x0000000c)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH1.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH1 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH1) >> BP_MIPI_HSI_RX_FIFO_STAT_CH1)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH2[5:4] (RO)
 *
 * Values:
 * - 00 - Rx channel 2 fifo not Empty and Full;
 * - 01 - Rx channel 2 fifo Empty;
 * - 10 - Rx channel 2 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH2      (4)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH2.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH2      (0x00000030)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH2.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH2 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH2) >> BP_MIPI_HSI_RX_FIFO_STAT_CH2)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH3[7:6] (RO)
 *
 * Values:
 * - 00 - Rx channel 3 fifo not Empty and Full;
 * - 01 - Rx channel 3 fifo Empty;
 * - 10 - Rx channel 3 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH3      (6)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH3.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH3      (0x000000c0)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH3.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH3 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH3) >> BP_MIPI_HSI_RX_FIFO_STAT_CH3)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH4[9:8] (RO)
 *
 * Values:
 * - 00 - Rx channel 4 fifo not Empty and Full;
 * - 01 - Rx channel 4 fifo Empty;
 * - 10 - Rx channel 4 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH4      (8)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH4.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH4      (0x00000300)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH4.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH4 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH4) >> BP_MIPI_HSI_RX_FIFO_STAT_CH4)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH5[11:10] (RO)
 *
 * Values:
 * - 00 - Rx channel 5 fifo not Empty and Full;
 * - 01 - Rx channel 5 fifo Empty;
 * - 10 - Rx channel 5 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH5      (10)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH5.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH5      (0x00000c00)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH5.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH5 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH5) >> BP_MIPI_HSI_RX_FIFO_STAT_CH5)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH6[13:12] (RO)
 *
 * Values:
 * - 00 - Rx channel 6 fifo not Empty and Full;
 * - 01 - Rx channel 6 fifo Empty;
 * - 10 - Rx channel 6 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH6      (12)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH6.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH6      (0x00003000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH6.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH6 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH6) >> BP_MIPI_HSI_RX_FIFO_STAT_CH6)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH7[15:14] (RO)
 *
 * Values:
 * - 00 - Rx channel 7 fifo not Empty and Full;
 * - 01 - Rx channel 7 fifo Empty;
 * - 10 - Rx channel 7 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH7      (14)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH7.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH7      (0x0000c000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH7.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH7 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH7) >> BP_MIPI_HSI_RX_FIFO_STAT_CH7)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH8[17:16] (RO)
 *
 * Values:
 * - 00 - Rx channel 8 fifo not Empty and Full;
 * - 01 - Rx channel 8 fifo Empty;
 * - 10 - Rx channel 8 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH8      (16)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH8.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH8      (0x00030000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH8.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH8 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH8) >> BP_MIPI_HSI_RX_FIFO_STAT_CH8)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH9[19:18] (RO)
 *
 * Values:
 * - 00 - Rx channel 9 fifo not Empty and Full;
 * - 01 - Rx channel 9 fifo Empty;
 * - 10 - Rx channel 9 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH9      (18)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH9.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH9      (0x000c0000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH9.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH9 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH9) >> BP_MIPI_HSI_RX_FIFO_STAT_CH9)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH10[21:20] (RO)
 *
 * Values:
 * - 00 - Rx channel 10 fifo not Empty and Full;
 * - 01 - Rx channel 10 fifo Empty;
 * - 10 - Rx channel 10 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH10      (20)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH10.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH10      (0x00300000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH10.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH10 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH10) >> BP_MIPI_HSI_RX_FIFO_STAT_CH10)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH11[23:22] (RO)
 *
 * Values:
 * - 00 - Rx channel 11 fifo not Empty and Full;
 * - 01 - Rx channel 11 fifo Empty;
 * - 10 - Rx channel 11 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH11      (22)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH11.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH11      (0x00c00000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH11.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH11 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH11) >> BP_MIPI_HSI_RX_FIFO_STAT_CH11)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH12[25:24] (RO)
 *
 * Values:
 * - 00 - Rx channel 12 fifo not Empty and Full;
 * - 01 - Rx channel 12 fifo Empty;
 * - 10 - Rx channel 12 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH12      (24)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH12.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH12      (0x03000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH12.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH12 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH12) >> BP_MIPI_HSI_RX_FIFO_STAT_CH12)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH13[27:26] (RO)
 *
 * Values:
 * - 00 - Rx channel 13 fifo not Empty and Full;
 * - 01 - Rx channel 13 fifo Empty;
 * - 10 - Rx channel 13 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH13      (26)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH13.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH13      (0x0c000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH13.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH13 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH13) >> BP_MIPI_HSI_RX_FIFO_STAT_CH13)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH14[29:28] (RO)
 *
 * Values:
 * - 00 - Rx channel 14 fifo not Empty and Full;
 * - 01 - Rx channel 14 fifo Empty;
 * - 10 - Rx channel 14 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH14      (28)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH14.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH14      (0x30000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH14.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH14 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH14) >> BP_MIPI_HSI_RX_FIFO_STAT_CH14)
//@}

/*! @name Register MIPI_HSI_RX_FIFO_STAT, field CH15[31:30] (RO)
 *
 * Values:
 * - 00 - Rx channel 15 fifo not Empty and Full;
 * - 01 - Rx channel 15 fifo Empty;
 * - 10 - Rx channel 15 fifo Full;
 * - 11 - Reserved.
 */
//@{
#define BP_MIPI_HSI_RX_FIFO_STAT_CH15      (30)      //!< Bit position for MIPI_HSI_RX_FIFO_STAT_CH15.
#define BM_MIPI_HSI_RX_FIFO_STAT_CH15      (0xc0000000)  //!< Bit mask for MIPI_HSI_RX_FIFO_STAT_CH15.

//! @brief Get value of MIPI_HSI_RX_FIFO_STAT_CH15 from a register value.
#define BG_MIPI_HSI_RX_FIFO_STAT_CH15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_RX_FIFO_STAT_CH15) >> BP_MIPI_HSI_RX_FIFO_STAT_CH15)
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_AHB_MASTER_CONF - Ahb Master Config Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_AHB_MASTER_CONF - Ahb Master Config Register (RW)
 *
 * Reset value: 0x00000180
 *
 * This register used to config hsi internal ahb master
 */
typedef union _hw_mipi_hsi_ahb_master_conf
{
    reg32_t U;
    struct _hw_mipi_hsi_ahb_master_conf_bitfields
    {
        unsigned DMA_INSERT_IDLE_NUM : 4; //!< [3:0] These bits used to set the number of "IDLE" cycles when DMA_MODE == 2'b0x.
        unsigned DMA_MODE : 2; //!< [5:4] 
        unsigned DP_HOLD_CYCLE : 4; //!< [9:6] These bits used to set the number of cycles for DP access fifo.
        unsigned RESERVED0 : 22; //!< [31:10] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_ahb_master_conf_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_AHB_MASTER_CONF register
 */
//@{
#define HW_MIPI_HSI_AHB_MASTER_CONF_ADDR      (REGS_MIPI_HSI_BASE + 0x228)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_AHB_MASTER_CONF           (*(volatile hw_mipi_hsi_ahb_master_conf_t *) HW_MIPI_HSI_AHB_MASTER_CONF_ADDR)
#define HW_MIPI_HSI_AHB_MASTER_CONF_RD()      (HW_MIPI_HSI_AHB_MASTER_CONF.U)
#define HW_MIPI_HSI_AHB_MASTER_CONF_WR(v)     (HW_MIPI_HSI_AHB_MASTER_CONF.U = (v))
#define HW_MIPI_HSI_AHB_MASTER_CONF_SET(v)    (HW_MIPI_HSI_AHB_MASTER_CONF_WR(HW_MIPI_HSI_AHB_MASTER_CONF_RD() |  (v)))
#define HW_MIPI_HSI_AHB_MASTER_CONF_CLR(v)    (HW_MIPI_HSI_AHB_MASTER_CONF_WR(HW_MIPI_HSI_AHB_MASTER_CONF_RD() & ~(v)))
#define HW_MIPI_HSI_AHB_MASTER_CONF_TOG(v)    (HW_MIPI_HSI_AHB_MASTER_CONF_WR(HW_MIPI_HSI_AHB_MASTER_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_AHB_MASTER_CONF bitfields
 */

/*! @name Register MIPI_HSI_AHB_MASTER_CONF, field DMA_INSERT_IDLE_NUM[3:0] (RW)
 *
 * These bits used to set the number of "IDLE" cycles when DMA_MODE == 2'b0x.
 */
//@{
#define BP_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM      (0)      //!< Bit position for MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM.
#define BM_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM      (0x0000000f)  //!< Bit mask for MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM.

//! @brief Get value of MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM from a register value.
#define BG_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM) >> BP_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM)

//! @brief Format value for bitfield MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM.
#define BF_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM) & BM_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_INSERT_IDLE_NUM field to a new value.
#define BW_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM(v)   (HW_MIPI_HSI_AHB_MASTER_CONF_WR((HW_MIPI_HSI_AHB_MASTER_CONF_RD() & ~BM_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM) | BF_MIPI_HSI_AHB_MASTER_CONF_DMA_INSERT_IDLE_NUM(v)))
#endif
//@}

/*! @name Register MIPI_HSI_AHB_MASTER_CONF, field DMA_MODE[5:4] (RW)
 *
 * Values:
 * - 00 - Once AHB master get hgrant from bus, it will set htrans "IDLE" for serval ahb cycles.In the serval
 *     cycles, once it found dataport is accessing fifo, it will release bus.
 * - 01 - Once AHB master get hgrant from bus, it will set htrans "IDLE" for serval ahb cycles.After the
 *     serval cycles, once it found dataport is accessing fifo, it will keep on sending "IDLE" out
 *     untill dataport finish accessing fifo.
 * - 1x - Once AHB master get hgrant from bus, dataport can not access fifo untill a dma operation done.
 */
//@{
#define BP_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE      (4)      //!< Bit position for MIPI_HSI_AHB_MASTER_CONF_DMA_MODE.
#define BM_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE      (0x00000030)  //!< Bit mask for MIPI_HSI_AHB_MASTER_CONF_DMA_MODE.

//! @brief Get value of MIPI_HSI_AHB_MASTER_CONF_DMA_MODE from a register value.
#define BG_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE) >> BP_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE)

//! @brief Format value for bitfield MIPI_HSI_AHB_MASTER_CONF_DMA_MODE.
#define BF_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE) & BM_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_MODE field to a new value.
#define BW_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE(v)   (HW_MIPI_HSI_AHB_MASTER_CONF_WR((HW_MIPI_HSI_AHB_MASTER_CONF_RD() & ~BM_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE) | BF_MIPI_HSI_AHB_MASTER_CONF_DMA_MODE(v)))
#endif
//@}

/*! @name Register MIPI_HSI_AHB_MASTER_CONF, field DP_HOLD_CYCLE[9:6] (RW)
 *
 * These bits used to set the number of cycles for DP access fifo.
 */
//@{
#define BP_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE      (6)      //!< Bit position for MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE.
#define BM_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE      (0x000003c0)  //!< Bit mask for MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE.

//! @brief Get value of MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE from a register value.
#define BG_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE) >> BP_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE)

//! @brief Format value for bitfield MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE.
#define BF_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE) & BM_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_HOLD_CYCLE field to a new value.
#define BW_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE(v)   (HW_MIPI_HSI_AHB_MASTER_CONF_WR((HW_MIPI_HSI_AHB_MASTER_CONF_RD() & ~BM_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE) | BF_MIPI_HSI_AHB_MASTER_CONF_DP_HOLD_CYCLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MIPI_HSI_TX_BREAK_LEN - TX Break Length Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MIPI_HSI_TX_BREAK_LEN - TX Break Length Register (RW)
 *
 * Reset value: 0x00000025
 *
 * This register used to set tx break length
 */
typedef union _hw_mipi_hsi_tx_break_len
{
    reg32_t U;
    struct _hw_mipi_hsi_tx_break_len_bitfields
    {
        unsigned COUNT : 6; //!< [5:0] The tx break length count.
        unsigned RESERVED0 : 26; //!< [31:6] Reserved, always set to zero.
    } B;
} hw_mipi_hsi_tx_break_len_t;
#endif

/*!
 * @name Constants and macros for entire MIPI_HSI_TX_BREAK_LEN register
 */
//@{
#define HW_MIPI_HSI_TX_BREAK_LEN_ADDR      (REGS_MIPI_HSI_BASE + 0x22c)

#ifndef __LANGUAGE_ASM__
#define HW_MIPI_HSI_TX_BREAK_LEN           (*(volatile hw_mipi_hsi_tx_break_len_t *) HW_MIPI_HSI_TX_BREAK_LEN_ADDR)
#define HW_MIPI_HSI_TX_BREAK_LEN_RD()      (HW_MIPI_HSI_TX_BREAK_LEN.U)
#define HW_MIPI_HSI_TX_BREAK_LEN_WR(v)     (HW_MIPI_HSI_TX_BREAK_LEN.U = (v))
#define HW_MIPI_HSI_TX_BREAK_LEN_SET(v)    (HW_MIPI_HSI_TX_BREAK_LEN_WR(HW_MIPI_HSI_TX_BREAK_LEN_RD() |  (v)))
#define HW_MIPI_HSI_TX_BREAK_LEN_CLR(v)    (HW_MIPI_HSI_TX_BREAK_LEN_WR(HW_MIPI_HSI_TX_BREAK_LEN_RD() & ~(v)))
#define HW_MIPI_HSI_TX_BREAK_LEN_TOG(v)    (HW_MIPI_HSI_TX_BREAK_LEN_WR(HW_MIPI_HSI_TX_BREAK_LEN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MIPI_HSI_TX_BREAK_LEN bitfields
 */

/*! @name Register MIPI_HSI_TX_BREAK_LEN, field COUNT[5:0] (RW)
 *
 * The tx break length count. 6'h00 64 6'h01 1 6'h3f 63
 */
//@{
#define BP_MIPI_HSI_TX_BREAK_LEN_COUNT      (0)      //!< Bit position for MIPI_HSI_TX_BREAK_LEN_COUNT.
#define BM_MIPI_HSI_TX_BREAK_LEN_COUNT      (0x0000003f)  //!< Bit mask for MIPI_HSI_TX_BREAK_LEN_COUNT.

//! @brief Get value of MIPI_HSI_TX_BREAK_LEN_COUNT from a register value.
#define BG_MIPI_HSI_TX_BREAK_LEN_COUNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MIPI_HSI_TX_BREAK_LEN_COUNT) >> BP_MIPI_HSI_TX_BREAK_LEN_COUNT)

//! @brief Format value for bitfield MIPI_HSI_TX_BREAK_LEN_COUNT.
#define BF_MIPI_HSI_TX_BREAK_LEN_COUNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MIPI_HSI_TX_BREAK_LEN_COUNT) & BM_MIPI_HSI_TX_BREAK_LEN_COUNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COUNT field to a new value.
#define BW_MIPI_HSI_TX_BREAK_LEN_COUNT(v)   (HW_MIPI_HSI_TX_BREAK_LEN_WR((HW_MIPI_HSI_TX_BREAK_LEN_RD() & ~BM_MIPI_HSI_TX_BREAK_LEN_COUNT) | BF_MIPI_HSI_TX_BREAK_LEN_COUNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_mipi_hsi_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All MIPI_HSI module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_mipi_hsi
{
    volatile hw_mipi_hsi_ctrl_t CTRL; //!< HSI Control Register
    volatile hw_mipi_hsi_tx_conf_t TX_CONF; //!< HSI Tx Config Register
    volatile hw_mipi_hsi_rx_conf_t RX_CONF; //!< HSI Rx Config Register
    volatile hw_mipi_hsi_cap_t CAP; //!< HSI Capability Register
    volatile hw_mipi_hsi_tx_wml0_t TX_WML0; //!< HSI Tx Water Mark Level 0 Register
    volatile hw_mipi_hsi_tx_tml1_t TX_TML1; //!< HSI Tx Water Mark Level 1 Register
    volatile hw_mipi_hsi_tx_arb_pri0_t TX_ARB_PRI0; //!< HSI Tx Arbiter Priority 0 Register
    volatile hw_mipi_hsi_tx_arb_pri1_t TX_ARB_PRI1; //!< HSI Tx Arbiter Priority 1 Register
    volatile hw_mipi_hsi_line_st_t LINE_ST; //!< HSI Line Status Register
    volatile hw_mipi_hsi_id_bit_t ID_BIT; //!< HSI ID Bits Register
    volatile hw_mipi_hsi_fifo_thr_conf_t FIFO_THR_CONF; //!< Tx and Rx Fif0 Threshold Configuration Register
    volatile hw_mipi_hsi_ch_sftrst_t CH_SFTRST; //!< Tx and Rx Channel Soft Reset Register
    volatile hw_mipi_hsi_irqstat_t IRQSTAT; //!< HSI Interrupt Status Register
    volatile hw_mipi_hsi_irqstat_en_t IRQSTAT_EN; //!< HSI Interrupt Status Enable Register
    volatile hw_mipi_hsi_irqsig_en_t IRQSIG_EN; //!< HSI Interrupt Signal Enable Register
    volatile hw_mipi_hsi_fifo_thr_irqstat_t FIFO_THR_IRQSTAT; //!< HSI FIFO Threshold Interrupt Status Register
    volatile hw_mipi_hsi_fifo_thr_irqstat_en_t FIFO_THR_IRQSTAT_EN; //!< HSI FIFO Threshold Interrupt Status Enable Register
    volatile hw_mipi_hsi_fifo_thr_irqsig_en_t FIFO_THR_IRQSIG_EN; //!< HSI FIFO Threshold Interrupt Signal Enable Register
    reg32_t _reserved0[2];
    volatile hw_mipi_hsi_tx_chn_dp_t TX_CHn_DP[16]; //!< Tx Channel n Data Port Register
    volatile hw_mipi_hsi_rx_chn_dp_t RX_CHn_DP[16]; //!< Rx Channel n Data Port Register
    volatile hw_mipi_hsi_err_irqstat_t ERR_IRQSTAT; //!< HSI Error Interrupt Status Register
    volatile hw_mipi_hsi_err_irqstat_en_t ERR_IRQSTAT_EN; //!< HSI Error Interrupt Status Enable Register
    volatile hw_mipi_hsi_err_irqsig_en_t ERR_IRQSIG_EN; //!< HSI Error Interrupt Signal Enable Register
    volatile hw_mipi_hsi_tdman_conf_t TDMAn_CONF[16]; //!< Tx DMA Channel n Configuration Register
    volatile hw_mipi_hsi_rdman_conf_t RDMAn_CONF[16]; //!< Rx DMA Channel n Configuration Register
    volatile hw_mipi_hsi_tdman_sta_addr_t TDMAn_STA_ADDR[16]; //!< Tx DMA Channel n Start Address Register
    volatile hw_mipi_hsi_rdman_sta_addr_t RDMAn_STA_ADDR[16]; //!< Rx DMA Channel n Start Address Register
    volatile hw_mipi_hsi_dma_irqstat_t DMA_IRQSTAT; //!< DMA Interrupt Status Register
    volatile hw_mipi_hsi_dma_irqstat_en_t DMA_IRQSTAT_EN; //!< DMA Interrupt Enable Register
    volatile hw_mipi_hsi_dma_irqsig_en_t DMA_IRQSIG_EN; //!< DMA Interrupt Status Signal Enable Register
    volatile hw_mipi_hsi_dma_err_irqstat_t DMA_ERR_IRQSTAT; //!< DMA Error Interrupt Status Register
    volatile hw_mipi_hsi_dma_err_irqstat_en_t DMA_ERR_IRQSTAT_EN; //!< DMA Error Interrupt Enable Register
    volatile hw_mipi_hsi_dma_err_irqsig_en_t DMA_ERR_IRQSIG_EN; //!< DMA Error Interrupt Signal Enable Register
    volatile hw_mipi_hsi_dma_single_req_en_t DMA_SINGLE_REQ_EN; //!< DMA Single Request Enable Register
    reg32_t _reserved1[2];
    volatile hw_mipi_hsi_tx_fifo_size_conf0_t TX_FIFO_SIZE_CONF0; //!< Tx Fifo Size Configuration Register 0
    volatile hw_mipi_hsi_tx_fifo_size_conf1_t TX_FIFO_SIZE_CONF1; //!< Tx Fifo Size Configuration Register 1
    volatile hw_mipi_hsi_rx_fifo_size_conf0_t RX_FIFO_SIZE_CONF0; //!< Rx Fifo Size Configuration Register 0
    volatile hw_mipi_hsi_rx_fifo_size_conf1_t RX_FIFO_SIZE_CONF1; //!< Rx Fifo Size Configuration Register 1
    volatile hw_mipi_hsi_tx_fifo_stat_t TX_FIFO_STAT; //!< Tx Fifo Status Register
    volatile hw_mipi_hsi_rx_fifo_stat_t RX_FIFO_STAT; //!< Rx Fifo Status Register
    reg32_t _reserved2[4];
    volatile hw_mipi_hsi_ahb_master_conf_t AHB_MASTER_CONF; //!< Ahb Master Config Register
    volatile hw_mipi_hsi_tx_break_len_t TX_BREAK_LEN; //!< TX Break Length Register
} hw_mipi_hsi_t;
#pragma pack()

//! @brief Macro to access all MIPI_HSI registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_MIPI_HSI</code>.
#define HW_MIPI_HSI     (*(hw_mipi_hsi_t *) REGS_MIPI_HSI_BASE)
#endif

#endif // __HW_MIPI_HSI_REGISTERS_H__
// v18/121106/1.2.2
// EOF
