/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_LDB_REGISTERS_H__
#define __HW_LDB_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL LDB
 *
 * LDB
 *
 * Registers defined in this header file:
 * - HW_LDB_CTRL - LDB Control Register
 *
 * - hw_ldb_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_LDB_BASE
#define HW_LDB_INSTANCE_COUNT (1) //!< Number of instances of the LDB module.
#define REGS_LDB_BASE (0x020e0008) //!< Base address for LDB.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LDB_CTRL - LDB Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LDB_CTRL - LDB Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register is implemented in the IOMUX Controller block (IOMUXC), as the register IOMUXC_GPR2.
 */
typedef union _hw_ldb_ctrl
{
    reg32_t U;
    struct _hw_ldb_ctrl_bitfields
    {
        unsigned CH0_MODE : 2; //!< [1:0] LVDS channel 0 operation mode
        unsigned CH1_MODE : 2; //!< [3:2] LVDS channel 1 operation mode
        unsigned SPLIT_MODE_EN : 1; //!< [4] Enable split mode.
        unsigned DATA_WIDTH_CH0 : 1; //!< [5] Data width for LVDS channel 0.
        unsigned BIT_MAPPING_CH0 : 1; //!< [6] Data mapping for LVDS channel 0.
        unsigned DATA_WIDTH_CH1 : 1; //!< [7] Data width for LVDS channel 1.
        unsigned BIT_MAPPING_CH1 : 1; //!< [8] Data mapping for LVDS channel 1.
        unsigned DI0_VS_POLARITY : 1; //!< [9] Vsync polarity for IPU's DI0 interface.
        unsigned DI1_VS_POLARITY : 1; //!< [10] Vsync polarity for IPU's DI1 interface.
        unsigned RESERVED0 : 5; //!< [15:11] Reserved.
        unsigned LVDS_CLK_SHIFT : 3; //!< [18:16] Shifts the LVDS output clock in relation to the data.
        unsigned RESERVED1 : 1; //!< [19] Reserved
        unsigned COUNTER_RESET_VAL : 2; //!< [21:20] Reset value for the LDB counter which determines when the shift registers are loaded with data.
        unsigned RESERVED2 : 10; //!< [31:22] Reserved
    } B;
} hw_ldb_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire LDB_CTRL register
 */
//@{
#define HW_LDB_CTRL_ADDR      (REGS_LDB_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_LDB_CTRL           (*(volatile hw_ldb_ctrl_t *) HW_LDB_CTRL_ADDR)
#define HW_LDB_CTRL_RD()      (HW_LDB_CTRL.U)
#define HW_LDB_CTRL_WR(v)     (HW_LDB_CTRL.U = (v))
#define HW_LDB_CTRL_SET(v)    (HW_LDB_CTRL_WR(HW_LDB_CTRL_RD() |  (v)))
#define HW_LDB_CTRL_CLR(v)    (HW_LDB_CTRL_WR(HW_LDB_CTRL_RD() & ~(v)))
#define HW_LDB_CTRL_TOG(v)    (HW_LDB_CTRL_WR(HW_LDB_CTRL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual LDB_CTRL bitfields
 */

/*! @name Register LDB_CTRL, field CH0_MODE[1:0] (RW)
 *
 * LVDS channel 0 operation mode
 *
 * Values:
 * - 00 - Channel disabled.
 * - 01 - Channel enabled, routed to DI0
 * - 10 - Channel disabled.
 * - 11 - Channel enabled, routed to DI1.
 */
//@{
#define BP_LDB_CTRL_CH0_MODE      (0)      //!< Bit position for LDB_CTRL_CH0_MODE.
#define BM_LDB_CTRL_CH0_MODE      (0x00000003)  //!< Bit mask for LDB_CTRL_CH0_MODE.

//! @brief Get value of LDB_CTRL_CH0_MODE from a register value.
#define BG_LDB_CTRL_CH0_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_CH0_MODE) >> BP_LDB_CTRL_CH0_MODE)

//! @brief Format value for bitfield LDB_CTRL_CH0_MODE.
#define BF_LDB_CTRL_CH0_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_CH0_MODE) & BM_LDB_CTRL_CH0_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0_MODE field to a new value.
#define BW_LDB_CTRL_CH0_MODE(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_CH0_MODE) | BF_LDB_CTRL_CH0_MODE(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field CH1_MODE[3:2] (RW)
 *
 * LVDS channel 1 operation mode
 *
 * Values:
 * - 00 - Channel disabled.
 * - 01 - Channel enabled, routed to DI0
 * - 10 - Channel disabled.
 * - 11 - Channel enabled, routed to DI1.
 */
//@{
#define BP_LDB_CTRL_CH1_MODE      (2)      //!< Bit position for LDB_CTRL_CH1_MODE.
#define BM_LDB_CTRL_CH1_MODE      (0x0000000c)  //!< Bit mask for LDB_CTRL_CH1_MODE.

//! @brief Get value of LDB_CTRL_CH1_MODE from a register value.
#define BG_LDB_CTRL_CH1_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_CH1_MODE) >> BP_LDB_CTRL_CH1_MODE)

//! @brief Format value for bitfield LDB_CTRL_CH1_MODE.
#define BF_LDB_CTRL_CH1_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_CH1_MODE) & BM_LDB_CTRL_CH1_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1_MODE field to a new value.
#define BW_LDB_CTRL_CH1_MODE(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_CH1_MODE) | BF_LDB_CTRL_CH1_MODE(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field SPLIT_MODE_EN[4] (RW)
 *
 * Enable split mode. In this mode both channels should be enabled and working with the same DI
 * (ch0_mode and ch1_mode should both be either '01' or '11')
 *
 * Values:
 * - 0 - Split mode is disabled.
 * - 1 - Split mode is enabled.
 */
//@{
#define BP_LDB_CTRL_SPLIT_MODE_EN      (4)      //!< Bit position for LDB_CTRL_SPLIT_MODE_EN.
#define BM_LDB_CTRL_SPLIT_MODE_EN      (0x00000010)  //!< Bit mask for LDB_CTRL_SPLIT_MODE_EN.

//! @brief Get value of LDB_CTRL_SPLIT_MODE_EN from a register value.
#define BG_LDB_CTRL_SPLIT_MODE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_SPLIT_MODE_EN) >> BP_LDB_CTRL_SPLIT_MODE_EN)

//! @brief Format value for bitfield LDB_CTRL_SPLIT_MODE_EN.
#define BF_LDB_CTRL_SPLIT_MODE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_SPLIT_MODE_EN) & BM_LDB_CTRL_SPLIT_MODE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPLIT_MODE_EN field to a new value.
#define BW_LDB_CTRL_SPLIT_MODE_EN(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_SPLIT_MODE_EN) | BF_LDB_CTRL_SPLIT_MODE_EN(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field DATA_WIDTH_CH0[5] (RW)
 *
 * Data width for LVDS channel 0. This bit must be set when using JEIDA standard (bit_mapping_ch0 is
 * set)
 *
 * Values:
 * - 0 - Data width is 18 bits wide (lvds0_tx3 is not used)
 * - 1 - Data width is 24 bits wide.
 */
//@{
#define BP_LDB_CTRL_DATA_WIDTH_CH0      (5)      //!< Bit position for LDB_CTRL_DATA_WIDTH_CH0.
#define BM_LDB_CTRL_DATA_WIDTH_CH0      (0x00000020)  //!< Bit mask for LDB_CTRL_DATA_WIDTH_CH0.

//! @brief Get value of LDB_CTRL_DATA_WIDTH_CH0 from a register value.
#define BG_LDB_CTRL_DATA_WIDTH_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_DATA_WIDTH_CH0) >> BP_LDB_CTRL_DATA_WIDTH_CH0)

//! @brief Format value for bitfield LDB_CTRL_DATA_WIDTH_CH0.
#define BF_LDB_CTRL_DATA_WIDTH_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_DATA_WIDTH_CH0) & BM_LDB_CTRL_DATA_WIDTH_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_WIDTH_CH0 field to a new value.
#define BW_LDB_CTRL_DATA_WIDTH_CH0(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_DATA_WIDTH_CH0) | BF_LDB_CTRL_DATA_WIDTH_CH0(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field BIT_MAPPING_CH0[6] (RW)
 *
 * Data mapping for LVDS channel 0.
 *
 * Values:
 * - 0 - Use SPWG standard.
 * - 1 - Use JEIDA standard.
 */
//@{
#define BP_LDB_CTRL_BIT_MAPPING_CH0      (6)      //!< Bit position for LDB_CTRL_BIT_MAPPING_CH0.
#define BM_LDB_CTRL_BIT_MAPPING_CH0      (0x00000040)  //!< Bit mask for LDB_CTRL_BIT_MAPPING_CH0.

//! @brief Get value of LDB_CTRL_BIT_MAPPING_CH0 from a register value.
#define BG_LDB_CTRL_BIT_MAPPING_CH0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_BIT_MAPPING_CH0) >> BP_LDB_CTRL_BIT_MAPPING_CH0)

//! @brief Format value for bitfield LDB_CTRL_BIT_MAPPING_CH0.
#define BF_LDB_CTRL_BIT_MAPPING_CH0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_BIT_MAPPING_CH0) & BM_LDB_CTRL_BIT_MAPPING_CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BIT_MAPPING_CH0 field to a new value.
#define BW_LDB_CTRL_BIT_MAPPING_CH0(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_BIT_MAPPING_CH0) | BF_LDB_CTRL_BIT_MAPPING_CH0(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field DATA_WIDTH_CH1[7] (RW)
 *
 * Data width for LVDS channel 1. This bit must be set when using JEIDA standard (bit_mapping_ch1 is
 * set)
 *
 * Values:
 * - 0 - Data width is 18 bits wide (lvds1_tx3 is not used)
 * - 1 - Data width is 24 bits wide.
 */
//@{
#define BP_LDB_CTRL_DATA_WIDTH_CH1      (7)      //!< Bit position for LDB_CTRL_DATA_WIDTH_CH1.
#define BM_LDB_CTRL_DATA_WIDTH_CH1      (0x00000080)  //!< Bit mask for LDB_CTRL_DATA_WIDTH_CH1.

//! @brief Get value of LDB_CTRL_DATA_WIDTH_CH1 from a register value.
#define BG_LDB_CTRL_DATA_WIDTH_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_DATA_WIDTH_CH1) >> BP_LDB_CTRL_DATA_WIDTH_CH1)

//! @brief Format value for bitfield LDB_CTRL_DATA_WIDTH_CH1.
#define BF_LDB_CTRL_DATA_WIDTH_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_DATA_WIDTH_CH1) & BM_LDB_CTRL_DATA_WIDTH_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_WIDTH_CH1 field to a new value.
#define BW_LDB_CTRL_DATA_WIDTH_CH1(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_DATA_WIDTH_CH1) | BF_LDB_CTRL_DATA_WIDTH_CH1(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field BIT_MAPPING_CH1[8] (RW)
 *
 * Data mapping for LVDS channel 1.
 *
 * Values:
 * - 0 - Use SPWG standard.
 * - 1 - Use JEIDA standard.
 */
//@{
#define BP_LDB_CTRL_BIT_MAPPING_CH1      (8)      //!< Bit position for LDB_CTRL_BIT_MAPPING_CH1.
#define BM_LDB_CTRL_BIT_MAPPING_CH1      (0x00000100)  //!< Bit mask for LDB_CTRL_BIT_MAPPING_CH1.

//! @brief Get value of LDB_CTRL_BIT_MAPPING_CH1 from a register value.
#define BG_LDB_CTRL_BIT_MAPPING_CH1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_BIT_MAPPING_CH1) >> BP_LDB_CTRL_BIT_MAPPING_CH1)

//! @brief Format value for bitfield LDB_CTRL_BIT_MAPPING_CH1.
#define BF_LDB_CTRL_BIT_MAPPING_CH1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_BIT_MAPPING_CH1) & BM_LDB_CTRL_BIT_MAPPING_CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BIT_MAPPING_CH1 field to a new value.
#define BW_LDB_CTRL_BIT_MAPPING_CH1(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_BIT_MAPPING_CH1) | BF_LDB_CTRL_BIT_MAPPING_CH1(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field DI0_VS_POLARITY[9] (RW)
 *
 * Vsync polarity for IPU's DI0 interface.
 *
 * Values:
 * - 0 - ipu_di0_vsync is active high.
 * - 1 - ipu_di0_vsync is active low.
 */
//@{
#define BP_LDB_CTRL_DI0_VS_POLARITY      (9)      //!< Bit position for LDB_CTRL_DI0_VS_POLARITY.
#define BM_LDB_CTRL_DI0_VS_POLARITY      (0x00000200)  //!< Bit mask for LDB_CTRL_DI0_VS_POLARITY.

//! @brief Get value of LDB_CTRL_DI0_VS_POLARITY from a register value.
#define BG_LDB_CTRL_DI0_VS_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_DI0_VS_POLARITY) >> BP_LDB_CTRL_DI0_VS_POLARITY)

//! @brief Format value for bitfield LDB_CTRL_DI0_VS_POLARITY.
#define BF_LDB_CTRL_DI0_VS_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_DI0_VS_POLARITY) & BM_LDB_CTRL_DI0_VS_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_VS_POLARITY field to a new value.
#define BW_LDB_CTRL_DI0_VS_POLARITY(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_DI0_VS_POLARITY) | BF_LDB_CTRL_DI0_VS_POLARITY(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field DI1_VS_POLARITY[10] (RW)
 *
 * Vsync polarity for IPU's DI1 interface.
 *
 * Values:
 * - 0 - ipu_di1_vsync is active high.
 * - 1 - ipu_di1_vsync is active low.
 */
//@{
#define BP_LDB_CTRL_DI1_VS_POLARITY      (10)      //!< Bit position for LDB_CTRL_DI1_VS_POLARITY.
#define BM_LDB_CTRL_DI1_VS_POLARITY      (0x00000400)  //!< Bit mask for LDB_CTRL_DI1_VS_POLARITY.

//! @brief Get value of LDB_CTRL_DI1_VS_POLARITY from a register value.
#define BG_LDB_CTRL_DI1_VS_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_DI1_VS_POLARITY) >> BP_LDB_CTRL_DI1_VS_POLARITY)

//! @brief Format value for bitfield LDB_CTRL_DI1_VS_POLARITY.
#define BF_LDB_CTRL_DI1_VS_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_DI1_VS_POLARITY) & BM_LDB_CTRL_DI1_VS_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_VS_POLARITY field to a new value.
#define BW_LDB_CTRL_DI1_VS_POLARITY(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_DI1_VS_POLARITY) | BF_LDB_CTRL_DI1_VS_POLARITY(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field LVDS_CLK_SHIFT[18:16] (RW)
 *
 * Shifts the LVDS output clock in relation to the data. Used for debug purposes only. In normal
 * functional operation must be '000'
 *
 * Values:
 * - 000 - Output clock is '1100011' (normal operation)
 * - 001 - Output clock is '1110001'
 * - 010 - Output clock is '1111000'
 * - 011 - Output clock is '1000111'
 * - 100 - Output clock is '0001111'
 * - 101 - Output clock is '0011111'
 * - 110 - Output clock is '0111100'
 * - 111 - Output clock is '1100011'
 */
//@{
#define BP_LDB_CTRL_LVDS_CLK_SHIFT      (16)      //!< Bit position for LDB_CTRL_LVDS_CLK_SHIFT.
#define BM_LDB_CTRL_LVDS_CLK_SHIFT      (0x00070000)  //!< Bit mask for LDB_CTRL_LVDS_CLK_SHIFT.

//! @brief Get value of LDB_CTRL_LVDS_CLK_SHIFT from a register value.
#define BG_LDB_CTRL_LVDS_CLK_SHIFT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_LVDS_CLK_SHIFT) >> BP_LDB_CTRL_LVDS_CLK_SHIFT)

//! @brief Format value for bitfield LDB_CTRL_LVDS_CLK_SHIFT.
#define BF_LDB_CTRL_LVDS_CLK_SHIFT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_LVDS_CLK_SHIFT) & BM_LDB_CTRL_LVDS_CLK_SHIFT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LVDS_CLK_SHIFT field to a new value.
#define BW_LDB_CTRL_LVDS_CLK_SHIFT(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_LVDS_CLK_SHIFT) | BF_LDB_CTRL_LVDS_CLK_SHIFT(v)))
#endif
//@}

/*! @name Register LDB_CTRL, field COUNTER_RESET_VAL[21:20] (RW)
 *
 * Reset value for the LDB counter which determines when the shift registers are loaded with data.
 * Used for debug purposes only. In normal functional operation must be '00'
 *
 * Values:
 * - 00 - Reset value is 5
 * - 01 - Reset value is 3
 * - 10 - Reset value is 4
 * - 11 - Reset value is 6
 */
//@{
#define BP_LDB_CTRL_COUNTER_RESET_VAL      (20)      //!< Bit position for LDB_CTRL_COUNTER_RESET_VAL.
#define BM_LDB_CTRL_COUNTER_RESET_VAL      (0x00300000)  //!< Bit mask for LDB_CTRL_COUNTER_RESET_VAL.

//! @brief Get value of LDB_CTRL_COUNTER_RESET_VAL from a register value.
#define BG_LDB_CTRL_COUNTER_RESET_VAL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_LDB_CTRL_COUNTER_RESET_VAL) >> BP_LDB_CTRL_COUNTER_RESET_VAL)

//! @brief Format value for bitfield LDB_CTRL_COUNTER_RESET_VAL.
#define BF_LDB_CTRL_COUNTER_RESET_VAL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_LDB_CTRL_COUNTER_RESET_VAL) & BM_LDB_CTRL_COUNTER_RESET_VAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COUNTER_RESET_VAL field to a new value.
#define BW_LDB_CTRL_COUNTER_RESET_VAL(v)   (HW_LDB_CTRL_WR((HW_LDB_CTRL_RD() & ~BM_LDB_CTRL_COUNTER_RESET_VAL) | BF_LDB_CTRL_COUNTER_RESET_VAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_ldb_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All LDB module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_ldb
{
    volatile hw_ldb_ctrl_t CTRL; //!< LDB Control Register
} hw_ldb_t;
#pragma pack()

//! @brief Macro to access all LDB registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_LDB</code>.
#define HW_LDB     (*(hw_ldb_t *) REGS_LDB_BASE)
#endif

#endif // __HW_LDB_REGISTERS_H__
// v18/121106/1.2.2
// EOF
