/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_HDMI_REGISTERS_H__
#define __HW_HDMI_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL HDMI
 *
 * HDMI
 *
 * Registers defined in this header file:
 * - HW_HDMI_DESIGN_ID - Design Identification Register
 * - HW_HDMI_REVISION_ID - Revision Identification Register
 * - HW_HDMI_PRODUCT_ID0 - Product Identification Register 0
 * - HW_HDMI_PRODUCT_ID1 - Product Identification Register 1
 * - HW_HDMI_CONFIG0_ID - Configuration Identification Register 0
 * - HW_HDMI_CONFIG1_ID - Configuration Identification Register 1
 * - HW_HDMI_CONFIG2_ID - Configuration Identification Register 2
 * - HW_HDMI_CONFIG3_ID - Configuration Identification Register 3
 * - HW_HDMI_IH_FC_STAT0 - Frame Composer Interrupt Status Register 0
 * - HW_HDMI_IH_FC_STAT1 - Frame Composer Interrupt Status Register 1
 * - HW_HDMI_IH_FC_STAT2 - Frame Composer Interrupt Status Register 2
 * - HW_HDMI_IH_AS_STAT0 - Audio Sampler Interrupt Status Register
 * - HW_HDMI_IH_PHY_STAT0 - PHY Interface Interrupt Status Register
 * - HW_HDMI_IH_I2CM_STAT0 - E-DDC I2C Master Interrupt Status Register
 * - HW_HDMI_IH_CEC_STAT0 - CEC Interrupt Status Register
 * - HW_HDMI_IH_VP_STAT0 - Video Packetizer Interrupt Status Register
 * - HW_HDMI_IH_I2CMPHY_STAT0 - PHY GEN2 I2C Master Interrupt Status Register
 * - HW_HDMI_IH_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Status Register
 * - HW_HDMI_IH_MUTE_FC_STAT0 - Frame Composer Interrupt Mute Control Register 0
 * - HW_HDMI_IH_MUTE_FC_STAT1 - Frame Composer Interrupt Mute Control Register 1
 * - HW_HDMI_IH_MUTE_FC_STAT2 - Frame Composer Interrupt Mute Control Register 2
 * - HW_HDMI_IH_MUTE_AS_STAT0 - Audio Sampler Interrupt Mute Control Register 0
 * - HW_HDMI_IH_MUTE_PHY_STAT0 - PHY Interface Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE_I2CM_STAT0 - E-DDC I2C Master Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE_CEC_STAT0 - CEC Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE_VP_STAT0 - Video Packetizer Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE_I2CMPHY_STAT0 - PHY GEN 2 I2C Master Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Mute Control Register
 * - HW_HDMI_IH_MUTE - Global Interrupt Mute Control Register
 * - HW_HDMI_TX_INVID0 - Video Input Mapping and Internal Data Enable Configuration Register
 * - HW_HDMI_TX_INSTUFFING - Video Input Stuffing Enable Register
 * - HW_HDMI_TX_GYDATA0 - Video Input GY Data Channel Stuffing Register 0
 * - HW_HDMI_TX_GYDATA1 - Video Input GY Data Channel Stuffing Register 1
 * - HW_HDMI_TX_RCRDATA0 - Video Input RCR Data Channel Stuffing Register 0
 * - HW_HDMI_TX_RCRDATA1 - Video Input RCR Data Channel Stuffing Register 1
 * - HW_HDMI_TX_BCBDATA0 - Video Input RCB Data Channel Stuffing Register 0
 * - HW_HDMI_TX_BCBDATA1 - Video Input RCB Data Channel Stuffing Register 1
 * - HW_HDMI_VP_STATUS - Video Packetizer Packing Phase Status Register
 * - HW_HDMI_VP_PR_CD - Video Packetizer Pixel Repetition and Color Depth Register
 * - HW_HDMI_VP_STUFF - Video Packetizer Stuffing and Default Packing Phase Register
 * - HW_HDMI_VP_REMAP - Video Packetizer YCC422 Remapping Register
 * - HW_HDMI_VP_CONF - Video Packetizer Output, Bypass, and Enable Configuration Register
 * - HW_HDMI_VP_MASK - Video Packetizer Interrupt Mask Register
 * - HW_HDMI_FC_INVIDCONF - Frame Composer Input Video Configuration and HDCP Keepout Register
 * - HW_HDMI_FC_INHACTIV0 - Frame Composer Input Video HActive Pixels Register 0
 * - HW_HDMI_FC_INHACTIV1 - Frame Composer Input Video HActive Pixels Register 1
 * - HW_HDMI_FC_INHBLANK0 - Frame Composer Input Video HBlank Pixels Register 0
 * - HW_HDMI_FC_INHBLANK1 - Frame Composer Input Video HBlank Pixels Register 1
 * - HW_HDMI_FC_INVACTIV0 - Frame Composer Input Video VActive Pixels Register 0
 * - HW_HDMI_FC_INVACTIV1 - Frame Composer Input Video VActive Pixels Register 1
 * - HW_HDMI_FC_INVBLANK - Frame Composer Input Video VBlank Pixels Register
 * - HW_HDMI_FC_HSYNCINDELAY0 - Frame Composer Input Video HSync Front Porch Register 0
 * - HW_HDMI_FC_HSYNCINDELAY1 - Frame Composer Input Video HSync Front Porch Register 1
 * - HW_HDMI_FC_HSYNCINWIDTH0 - Frame Composer Input Video HSync Width Register 0
 * - HW_HDMI_FC_HSYNCINWIDTH1 - Frame Composer Input Video HSync Width Register 1
 * - HW_HDMI_FC_VSYNCINDELAY - Frame Composer Input Video VSync Front Porch Register
 * - HW_HDMI_FC_VSYNCINWIDTH - Frame Composer Input Video VSync Width Register
 * - HW_HDMI_FC_INFREQ0 - Frame Composer Input Video Refresh Rate Register 0
 * - HW_HDMI_FC_INFREQ1 - Frame Composer Input Video Refresh Rate Register 1
 * - HW_HDMI_FC_INFREQ2 - Frame Composer Input Video Refresh Rate Register 2
 * - HW_HDMI_FC_CTRLDUR - Frame Composer Control Period Duration Register
 * - HW_HDMI_FC_EXCTRLDUR - Frame Composer Extended Control Period Duration Register
 * - HW_HDMI_FC_EXCTRLSPAC - Frame Composer Extended Control Period Maximum Spacing Register
 * - HW_HDMI_FC_CH0PREAM - Frame Composer Channel 0 Non-Preamble Data Register
 * - HW_HDMI_FC_CH1PREAM - Frame Composer Channel 1 Non-Preamble Data Register
 * - HW_HDMI_FC_CH2PREAM - Frame Composer Channel 2 Non-Preamble Data Register
 * - HW_HDMI_FC_AVICONF3 - Frame Composer AVI Configuration Register 3
 * - HW_HDMI_FC_GCP - Frame Composer GCP Packet Configuration Register
 * - HW_HDMI_FC_AVICONF0 - Frame Composer AVI Packet Configuration Register 0
 * - HW_HDMI_FC_AVICONF1 - Frame Composer AVI Packet Configuration Register 1
 * - HW_HDMI_FC_AVICONF2 - FC_AVICONFFrame Composer AVI Packet Configuration Register 2
 * - HW_HDMI_FC_AVIVID - Frame Composer AVI Packet VIC Register
 * - HW_HDMI_FC_AVIETB0 - Frame Composer AVI Packet End of Top Bar Register 0
 * - HW_HDMI_FC_AVIETB1 - Frame Composer AVI Packet End of Top Bar Register 1
 * - HW_HDMI_FC_AVISBB0 - Frame Composer AVI Packet Start of Bottom Bar Register 0
 * - HW_HDMI_FC_AVISBB1 - Frame Composer AVI Packet Start of Bottom Bar Register 1
 * - HW_HDMI_FC_AVIELB0 - Frame Composer AVI Packet End of Left Bar Register 0
 * - HW_HDMI_FC_AVIELB1 - Frame Composer AVI Packet End of Left Bar Register 1
 * - HW_HDMI_FC_AVISRB0 - Frame Composer AVI Packet Start of Right Bar Register 0
 * - HW_HDMI_FC_AVISRB1 - Frame Composer AVI Packet Start of Right Bar Register 1
 * - HW_HDMI_FC_AUDICONF0 - Frame Composer AUD Packet Configuration Register 0
 * - HW_HDMI_FC_AUDICONF1 - Frame Composer AUD Packet Configuration Register 1
 * - HW_HDMI_FC_AUDICONF2 - Frame Composer AUD Packet Configuration Register 2
 * - HW_HDMI_FC_AUDICONF3 - Frame Composer AUD Packet Configuration Register 3
 * - HW_HDMI_FC_VSDIEEEID0 - Frame Composer VSI Packet Data IEEE Register 0
 * - HW_HDMI_FC_VSDSIZE - Frame Composer VSI Packet Data Size Register
 * - HW_HDMI_FC_VSDIEEEID1 - Frame Composer VSI Packet Data IEEE Register 1
 * - HW_HDMI_FC_VSDIEEEID2 - Frame Composer VSI Packet Data IEEE Register 2
 * - HW_HDMI_FC_VSDPAYLOAD0 - Frame Composer VSI Packet Data IEEE Register 0
 * - HW_HDMI_FC_VSDPAYLOAD1 - Frame Composer VSI Packet Data IEEE Register 1
 * - HW_HDMI_FC_VSDPAYLOAD2 - Frame Composer VSI Packet Data IEEE Register 2
 * - HW_HDMI_FC_VSDPAYLOAD3 - Frame Composer VSI Packet Data IEEE Register 3
 * - HW_HDMI_FC_VSDPAYLOAD4 - Frame Composer VSI Packet Data IEEE Register 4
 * - HW_HDMI_FC_VSDPAYLOAD5 - Frame Composer VSI Packet Data IEEE Register 5
 * - HW_HDMI_FC_VSDPAYLOAD6 - Frame Composer VSI Packet Data IEEE Register 6
 * - HW_HDMI_FC_VSDPAYLOAD7 - Frame Composer VSI Packet Data IEEE Register 7
 * - HW_HDMI_FC_VSDPAYLOAD8 - Frame Composer VSI Packet Data IEEE Register 8
 * - HW_HDMI_FC_VSDPAYLOAD9 - Frame Composer VSI Packet Data IEEE Register 9
 * - HW_HDMI_FC_VSDPAYLOAD10 - Frame Composer VSI Packet Data IEEE Register 10
 * - HW_HDMI_FC_VSDPAYLOAD11 - Frame Composer VSI Packet Data IEEE Register 11
 * - HW_HDMI_FC_VSDPAYLOAD12 - Frame Composer VSI Packet Data IEEE Register 12
 * - HW_HDMI_FC_VSDPAYLOAD13 - Frame Composer VSI Packet Data IEEE Register 13
 * - HW_HDMI_FC_VSDPAYLOAD14 - Frame Composer VSI Packet Data IEEE Register 14
 * - HW_HDMI_FC_VSDPAYLOAD15 - Frame Composer VSI Packet Data IEEE Register 15
 * - HW_HDMI_FC_VSDPAYLOAD16 - Frame Composer VSI Packet Data IEEE Register 16
 * - HW_HDMI_FC_VSDPAYLOAD17 - Frame Composer VSI Packet Data IEEE Register 17
 * - HW_HDMI_FC_VSDPAYLOAD18 - Frame Composer VSI Packet Data IEEE Register 18
 * - HW_HDMI_FC_VSDPAYLOAD19 - Frame Composer VSI Packet Data IEEE Register 19
 * - HW_HDMI_FC_VSDPAYLOAD20 - Frame Composer VSI Packet Data IEEE Register 20
 * - HW_HDMI_FC_VSDPAYLOAD21 - Frame Composer VSI Packet Data IEEE Register 21
 * - HW_HDMI_FC_VSDPAYLOAD22 - Frame Composer VSI Packet Data IEEE Register 22
 * - HW_HDMI_FC_VSDPAYLOAD23 - Frame Composer VSI Packet Data IEEE Register 23
 * - HW_HDMI_FC_SPDVENDORNAME0 - Frame Composer SPD Packet Data Vendor Name Register 0
 * - HW_HDMI_FC_SPDPRODUCTNAME0 - Frame Composer SPD Packet Data Product Name Register 0
 * - HW_HDMI_FC_SPDDEVICEINF - Frame Composer SPD Packet Data Source Product Descriptor Register
 * - HW_HDMI_FC_AUDSCONF - Frame Composer Audio Sample Flat and Layout Configuration Register
 * - HW_HDMI_FC_AUDSSTAT - Frame Composer Audio Packet Sample Present Status Register
 * - HW_HDMI_FC_CTRLQHIGH - Frame Composer Number of High Priority Packets Attended Configuration Register
 * - HW_HDMI_FC_CTRLQLOW - Frame Composer Number of Low Priority Packets Attended Configuration Register
 * - HW_HDMI_FC_ACP0 - Frame Composer ACP Packet Type Configuration Register 0
 * - HW_HDMI_FC_ACP1 - Frame Composer ACP Packet Type Configuration Register 1
 * - HW_HDMI_FC_ISCR1_0 - FC_ISCR1_Frame Composer Packet Status, Valid, and Continue Configuration Register
 * - HW_HDMI_FC_ISCR1_1 - Frame Composer ISCR1 Packet Body Register 1
 * - HW_HDMI_FC_ISCR2_0 - Frame Composer ISCR2 Packet Body Register 0
 * - HW_HDMI_FC_DATAUTO0 - Frame Composer Data Island Auto Packet Scheduling Register 0
 * - HW_HDMI_FC_DATAUTO1 - Frame Composer Data Island Auto Packet Scheduling Register 1
 * - HW_HDMI_FC_DATAUTO2 - Frame Composer Data Island Auto Packet Scheduling Register 2
 * - HW_HDMI_FC_DATMAN - Frame Composer Data Island Manual Packet Request Register
 * - HW_HDMI_FC_DATAUTO3 - Frame Composer Data Island Auto Packet Scheduling Register 3
 * - HW_HDMI_FC_RDRB0 - Frame Composer Round Robin ACR Packet Insertion Register 0
 * - HW_HDMI_FC_RDRB1 - Frame Composer Round Robin ACR Packet Insertion Register 1
 * - HW_HDMI_FC_RDRB2 - Frame Composer Round Robin ACR Packet Insertion Register 2
 * - HW_HDMI_FC_RDRB3 - Frame Composer Round Robin ACR Packet Insertion Register 3
 * - HW_HDMI_FC_RDRB4 - Frame Composer Round Robin ACR Packet Insertion Register 4
 * - HW_HDMI_FC_RDRB5 - Frame Composer Round Robin ACR Packet Insertion Register 5
 * - HW_HDMI_FC_RDRB6 - Frame Composer Round Robin ACR Packet Insertion Register 6
 * - HW_HDMI_FC_RDRB7 - Frame Composer Round Robin ACR Packet Insertion Register 7
 * - HW_HDMI_FC_MASK0 - Frame Composer Packet Interrupt Mask Register 0
 * - HW_HDMI_FC_MASK1 - Frame Composer Packet Interrupt Mask Register 1
 * - HW_HDMI_FC_MASK2 - Frame Composer High/Low Priority Overflow Interrupt Mask Register 2
 * - HW_HDMI_FC_PRCONF - Frame Composer Pixel Repetition Configuration Register
 * - HW_HDMI_FC_GMD_STAT - Frame Composer GMD Packet Status Register
 * - HW_HDMI_FC_GMD_EN - Frame Composer GMD Packet Enable Register
 * - HW_HDMI_FC_GMD_UP - Frame Composer GMD Packet Update Register
 * - HW_HDMI_FC_GMD_CONF - Frame Composer GMD Packet Schedule Configuration Register
 * - HW_HDMI_FC_GMD_HB - Frame Composer GMD Packet Profile and Gamut Sequence Configuration Register
 * - HW_HDMI_FC_GMD_PB0 - Frame Composer GMD Packet Body Register 0
 * - HW_HDMI_FC_GMD_PB1 - Frame Composer GMD Packet Body Register 1
 * - HW_HDMI_FC_GMD_PB2 - Frame Composer GMD Packet Body Register 2
 * - HW_HDMI_FC_GMD_PB3 - Frame Composer GMD Packet Body Register 3
 * - HW_HDMI_FC_GMD_PB4 - Frame Composer GMD Packet Body Register 4
 * - HW_HDMI_FC_GMD_PB5 - Frame Composer GMD Packet Body Register 5
 * - HW_HDMI_FC_GMD_PB6 - Frame Composer GMD Packet Body Register 6
 * - HW_HDMI_FC_GMD_PB7 - Frame Composer GMD Packet Body Register 7
 * - HW_HDMI_FC_GMD_PB8 - Frame Composer GMD Packet Body Register 8
 * - HW_HDMI_FC_GMD_PB9 - Frame Composer GMD Packet Body Register 9
 * - HW_HDMI_FC_GMD_PB10 - Frame Composer GMD Packet Body Register 10
 * - HW_HDMI_FC_GMD_PB11 - Frame Composer GMD Packet Body Register 11
 * - HW_HDMI_FC_GMD_PB12 - Frame Composer GMD Packet Body Register 12
 * - HW_HDMI_FC_GMD_PB13 - Frame Composer GMD Packet Body Register 13
 * - HW_HDMI_FC_GMD_PB14 - Frame Composer GMD Packet Body Register 14
 * - HW_HDMI_FC_GMD_PB15 - Frame Composer GMD Packet Body Register 15
 * - HW_HDMI_FC_GMD_PB16 - Frame Composer GMD Packet Body Register 16
 * - HW_HDMI_FC_GMD_PB17 - Frame Composer GMD Packet Body Register 17
 * - HW_HDMI_FC_GMD_PB18 - Frame Composer GMD Packet Body Register 18
 * - HW_HDMI_FC_GMD_PB19 - Frame Composer GMD Packet Body Register 19
 * - HW_HDMI_FC_GMD_PB20 - Frame Composer GMD Packet Body Register 20
 * - HW_HDMI_FC_GMD_PB21 - Frame Composer GMD Packet Body Register 21
 * - HW_HDMI_FC_GMD_PB22 - Frame Composer GMD Packet Body Register 22
 * - HW_HDMI_FC_GMD_PB23 - Frame Composer GMD Packet Body Register 23
 * - HW_HDMI_FC_GMD_PB24 - Frame Composer GMD Packet Body Register 24
 * - HW_HDMI_FC_GMD_PB25 - Frame Composer GMD Packet Body Register 25
 * - HW_HDMI_FC_GMD_PB26 - Frame Composer GMD Packet Body Register 26
 * - HW_HDMI_FC_GMD_PB27 - Frame Composer GMD Packet Body Register 27
 * - HW_HDMI_FC_DBGFORCE - Frame Composer Video/Audio Force Enable Register
 * - HW_HDMI_FC_DBGAUD0CH0 - Frame Composer Audio Channel 0 Register 0
 * - HW_HDMI_FC_DBGAUD1CH0 - Frame Composer Audio Channel 0 Register 1
 * - HW_HDMI_FC_DBGAUD2CH0 - Frame Composer Audio Channel 0 Register 2
 * - HW_HDMI_FC_DBGAUD0CH1 - Frame Composer Audio Channel 1 Register 0
 * - HW_HDMI_FC_DBGAUD1CH1 - Frame Composer Audio Channel 1 Register 1
 * - HW_HDMI_FC_DBGAUD2CH1 - Frame Composer Audio Channel 1 Register 2
 * - HW_HDMI_FC_DBGAUD0CH2 - Frame Composer Debug Audio Channel 2 Register 0
 * - HW_HDMI_FC_DBGAUD1CH2 - Frame Composer Debug Audio Channel 2 Register 1
 * - HW_HDMI_FC_DBGAUD2CH2 - Frame Composer Audio Channel 2 Register 2
 * - HW_HDMI_FC_DBGAUD0CH3 - Frame Composer Audio Channel 3 Register 0
 * - HW_HDMI_FC_DBGAUD1CH3 - Frame Composer Audio Channel 3 Register 1
 * - HW_HDMI_FC_DBGAUD2CH3 - Frame Composer Audio Channel 3 Register 2
 * - HW_HDMI_FC_DBGAUD0CH4 - Frame Composer Audio Channel 4 Register 0
 * - HW_HDMI_FC_DBGAUD1CH4 - Frame Composer Audio Channel 4 Register 1
 * - HW_HDMI_FC_DBGAUD2CH4 - Frame Composer Audio Channel 4 Register 2
 * - HW_HDMI_FC_DBGAUD0CH5 - Frame Composer Audio Channel 5 Register 0
 * - HW_HDMI_FC_DBGAUD1CH5 - Frame Composer Audio Channel 5 Register 1
 * - HW_HDMI_FC_DBGAUD2CH5 - Frame Composer Audio Channel 5 Register 2
 * - HW_HDMI_FC_DBGAUD0CH6 - Frame Composer Audio Channel 6 Register 0
 * - HW_HDMI_FC_DBGAUD1CH6 - Frame Composer Audio Channel 6 Register 1
 * - HW_HDMI_FC_DBGAUD2CH6 - Frame Composer Audio Channel 6 Register 2
 * - HW_HDMI_FC_DBGAUD0CH7 - Frame Composer Audio Channel 7 Register 1
 * - HW_HDMI_FC_DBGAUD1CH7 - Frame Composer Audio Channel 7 Register 0
 * - HW_HDMI_FC_DBGAUD2CH7 - Frame Composer Audio Channel 7 Register 2
 * - HW_HDMI_FC_DBGTMDS0 - Frame Composer TMDS Channel 0 Register
 * - HW_HDMI_FC_DBGTMDS1 - Frame Composer TMDS Channel 1 Register
 * - HW_HDMI_FC_DBGTMDS2 - Frame Composer TMDS Channel 2 Register
 * - HW_HDMI_PHY_CONF0 - PHY Configuration Register
 * - HW_HDMI_PHY_TST0 - PHY Test Interface Register 0
 * - HW_HDMI_PHY_TST1 - PHY Test Interface Register 1
 * - HW_HDMI_PHY_TST2 - PHY Test Interface Register 2
 * - HW_HDMI_PHY_STAT0 - PHY RXSENSE, PLL lock, and HPD Status Register
 * - HW_HDMI_PHY_INT0 - PHY RXSENSE, PLL lock, and HPD Interrupt Register
 * - HW_HDMI_PHY_MASK0 - PHY RXSENSE, PLL lock, and HPD Mask Register
 * - HW_HDMI_PHY_POL0 - PHY RXSENSE, PLL lock and HPD Polarity Register
 * - HW_HDMI_PHY_I2CM_SLAVE_ADDR - PHY I2C Slave Address Configuration Register
 * - HW_HDMI_PHY_I2CM_ADDRESS_ADDR - PHY I2C Address Configuration Register
 * - HW_HDMI_PHY_I2CM_DATAO_1_ADDR - PHY I2C Data Write Register 1
 * - HW_HDMI_PHY_I2CM_DATAO_0_ADDR - PHY I2C Data Write Register 0
 * - HW_HDMI_PHY_I2CM_DATAI_1_ADDR - PHY I2C Data Read Register 1
 * - HW_HDMI_PHY_I2CM_DATAI_0_ADDR - PHY I2C Data Read Register 0
 * - HW_HDMI_PHY_I2CM_OPERATION_ADDR - PHY I2C Read/Write Operation
 * - HW_HDMI_PHY_I2CM_INT_ADDR - PHY I2C Done Interrupt Register
 * - HW_HDMI_PHY_I2CM_CTLINT_ADDR - PHY I2C Done Interrupt Register
 * - HW_HDMI_PHY_I2CM_DIV_ADDR - PHY I2C Speed Control Register
 * - HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR - PHY I2C Software Reset Register
 * - HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR - PHY I2C Slow Speed SCL High Level Control Register 1
 * - HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR - PHY I2C Slow Speed SCL High Level Control Register 0
 * - HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 1
 * - HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 0
 * - HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR - PHY I2C Fast Speed SCL High Level Control Register 1
 * - HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR - PHY I2C Fast Speed SCL High Level Control Register 0
 * - HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 1
 * - HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 0
 * - HW_HDMI_AUD_N1 - Audio Clock Regenerator N Value Register 1
 * - HW_HDMI_AUD_N2 - Audio Clock Regenerator N Value Register 2
 * - HW_HDMI_AUD_N3 - Audio Clock Regenerator N Value Register 3
 * - HW_HDMI_AUD_CTS1 - AUD_CTS1
 * - HW_HDMI_AUD_CTS2 - AUD_CTS2
 * - HW_HDMI_AUD_CTS3 - AUD_CTS3
 * - HW_HDMI_AHB_DMA_CONF0 - Audio DMA Start Register
 * - HW_HDMI_AHB_DMA_START - AHB_DMA_START
 * - HW_HDMI_AHB_DMA_STOP - Audio DMA Stop Register
 * - HW_HDMI_AHB_DMA_THRSLD - Audio DMA FIFO Threshold Register
 * - HW_HDMI_AHB_DMA_STRADDR0 - Audio DMA Start Address Register 0
 * - HW_HDMI_AHB_DMA_STRADDR1 - Audio DMA Start Address Register 1
 * - HW_HDMI_AHB_DMA_STRADDR2 - Audio DMA Start Address Register 2
 * - HW_HDMI_AHB_DMA_STRADDR3 - Audio DMA Start Address Register 3
 * - HW_HDMI_AHB_DMA_STPADDR0 - Audio DMA Stop Address Register 0
 * - HW_HDMI_AHB_DMA_STPADDR1 - Audio DMA Stop Address Register 1
 * - HW_HDMI_AHB_DMA_STPADDR2 - Audio DMA Stop Address Register 2
 * - HW_HDMI_AHB_DMA_STPADDR3 - Audio DMA Stop Address Register 3
 * - HW_HDMI_AHB_DMA_BSTADDR0 - Audio DMA Burst Start Address Register 0
 * - HW_HDMI_AHB_DMA_BSTADDR1 - Audio DMA Burst Start Address Register 1
 * - HW_HDMI_AHB_DMA_BSTADDR2 - Audio DMA Burst Start Address Register 2
 * - HW_HDMI_AHB_DMA_BSTADDR3 - Audio DMA Burst Start Address Register 3
 * - HW_HDMI_AHB_DMA_MBLENGTH0 - Audio DMA Burst Length Register 0
 * - HW_HDMI_AHB_DMA_MBLENGTH1 - Audio DMA Burst Length Register 1
 * - HW_HDMI_AHB_DMA_STAT - Audio DMA Interrupt Status Register
 * - HW_HDMI_AHB_DMA_INT - Audio DMA Interrupt Register
 * - HW_HDMI_AHB_DMA_MASK - Audio DMA Mask Interrupt Register
 * - HW_HDMI_AHB_DMA_POL - Audio DMA Polarity Interrupt Register
 * - HW_HDMI_AHB_DMA_CONF1 - Audio DMA Channel Enable Configuration Register 1
 * - HW_HDMI_AHB_DMA_BUFFSTAT - Audio DMA Buffer Interrupt Status Register
 * - HW_HDMI_AHB_DMA_BUFFINT - Audio DMA Buffer Interrupt Register
 * - HW_HDMI_AHB_DMA_BUFFMASK - Audio DMA Buffer Mask Interrupt Register
 * - HW_HDMI_AHB_DMA_BUFFPOL - Audio DMA Buffer Polarity Interrupt Register
 * - HW_HDMI_MC_CLKDIS - Main Controller Synchronous Clock Domain Disable Register
 * - HW_HDMI_MC_SWRSTZREQ - Main Controller Software Reset Register
 * - HW_HDMI_MC_FLOWCTRL - Main Controller Feed Through Control Register
 * - HW_HDMI_MC_PHYRSTZ - Main Controller PHY Reset Register
 * - HW_HDMI_MC_LOCKONCLOCK - Main Controller Clock Present Register
 * - HW_HDMI_MC_HEACPHY_RST - Main Controller HEAC PHY Reset Register
 * - HW_HDMI_CSC_CFG - Color Space Converter Interpolation and Decimation Configuration Register
 * - HW_HDMI_CSC_SCALE - Color Space Converter Scale and Deep Color Configuration Register
 * - HW_HDMI_CSC_COEF_A1_MSB - CSC_COEF_A1_MSB
 * - HW_HDMI_CSC_COEF_A1_LSB - CSC_COEF_A1_LSB
 * - HW_HDMI_CSC_COEF_A2_MSB - CSC_COEF_A2_MSB
 * - HW_HDMI_CSC_COEF_A2_LSB - CSC_COEF_A2_LSB
 * - HW_HDMI_CSC_COEF_A3_MSB - CSC_COEF_A3_MSB
 * - HW_HDMI_CSC_COEF_A3_LSB - CSC_COEF_A3_LSB
 * - HW_HDMI_CSC_COEF_A4_MSB - CSC_COEF_A4_MSB
 * - HW_HDMI_CSC_COEF_A4_LSB - CSC_COEF_A4_LSB
 * - HW_HDMI_CSC_COEF_B1_MSB - CSC_COEF_B1_MSB
 * - HW_HDMI_CSC_COEF_B1_LSB - CSC_COEF_B1_LSB
 * - HW_HDMI_CSC_COEF_B2_MSB - CSC_COEF_B2_MSB
 * - HW_HDMI_CSC_COEF_B2_LSB - CSC_COEF_B2_LSB
 * - HW_HDMI_CSC_COEF_B3_MSB - CSC_COEF_B3_MSB
 * - HW_HDMI_CSC_COEF_B3_LSB - CSC_COEF_B3_LSB
 * - HW_HDMI_CSC_COEF_B4_MSB - CSC_COEF_B4_MSB
 * - HW_HDMI_CSC_COEF_B4_LSB - CSC_COEF_B4_LSB
 * - HW_HDMI_CSC_COEF_C1_MSB - CSC_COEF_C1_MSB
 * - HW_HDMI_CSC_COEF_C1_LSB - CSC_COEF_C1_LSB
 * - HW_HDMI_CSC_COEF_C2_MSB - CSC_COEF_C2_MSB
 * - HW_HDMI_CSC_COEF_C2_LSB - CSC_COEF_C2_LSB
 * - HW_HDMI_CSC_COEF_C3_MSB - CSC_COEF_C3_MSB
 * - HW_HDMI_CSC_COEF_C3_LSB - CSC_COEF_C3_LSB
 * - HW_HDMI_CSC_COEF_C4_MSB - CSC_COEF_C4_MSB
 * - HW_HDMI_CSC_COEF_C4_LSB - CSC_COEF_C4_LSB
 * - HW_HDMI_A_HDCPCFG0 - A_HDCPCFG0
 * - HW_HDMI_A_HDCPCFG1 - A_HDCPCFG1
 * - HW_HDMI_A_HDCPOBS0 - A_HDCPOBS0
 * - HW_HDMI_A_HDCPOBS1 - A_HDCPOBS1
 * - HW_HDMI_A_HDCPOBS2 - A_HDCPOBS2
 * - HW_HDMI_A_HDCPOBS3 - A_HDCPOBS3
 * - HW_HDMI_A_APIINTCLR - A_APIINTCLR
 * - HW_HDMI_A_APIINTSTAT - A_APIINTSTAT
 * - HW_HDMI_A_APIINTMSK - A_APIINTMSK
 * - HW_HDMI_A_VIDPOLCFG - A_VIDPOLCFG
 * - HW_HDMI_A_OESSWCFG - A_OESSWCFG
 * - HW_HDMI_A_COREVERLSB - A_COREVERLSB
 * - HW_HDMI_A_COREVERMSB - A_COREVERMSB
 * - HW_HDMI_A_KSVMEMCTRL - A_KSVMEMCTRL
 * - HW_HDMI_HDCPREG_BKSV0 - HDCPREG_BKSV0
 * - HW_HDMI_HDCPREG_BKSV1 - HDCPREG_BKSV1
 * - HW_HDMI_HDCPREG_BKSV2 - HDCPREG_BKSV2
 * - HW_HDMI_HDCPREG_BKSV3 - HDCPREG_BKSV3
 * - HW_HDMI_HDCPREG_BKSV4 - HDCPREG_BKSV4
 * - HW_HDMI_HDCPREG_ANCONF - HDCPREG_ANCONF
 * - HW_HDMI_HDCPREG_AN0 - HDCPREG_AN0
 * - HW_HDMI_HDCPREG_AN1 - HDCPREG_AN1
 * - HW_HDMI_HDCPREG_AN2 - HDCPREG_AN2
 * - HW_HDMI_HDCPREG_AN3 - HDCPREG_AN3
 * - HW_HDMI_HDCPREG_AN4 - HDCPREG_AN4
 * - HW_HDMI_HDCPREG_AN5 - HDCPREG_AN5
 * - HW_HDMI_HDCPREG_AN6 - HDCPREG_AN6
 * - HW_HDMI_HDCPREG_AN7 - HDCPREG_AN7
 * - HW_HDMI_CEC_CTRL - CEC_CTRL
 * - HW_HDMI_CEC_MASK - CEC_MASK
 * - HW_HDMI_CEC_ADDR_L - CEC_ADDR_L
 * - HW_HDMI_CEC_ADDR_H - CEC_ADDR_H
 * - HW_HDMI_CEC_TX_CNT - CEC_TX_CNT
 * - HW_HDMI_CEC_RX_CNT - CEC_RX_CNT
 * - HW_HDMI_CEC_TX_DATAn - CEC_TX_DATAn
 * - HW_HDMI_CEC_RX_DATAn - CEC_RX_DATAn
 * - HW_HDMI_CEC_LOCK - CEC_LOCK
 * - HW_HDMI_CEC_WKUPCTRL - CEC_WKUPCTRL
 * - HW_HDMI_I2CM_SLAVE - I2CM_SLAVE
 * - HW_HDMI_I2CM_ADDRESS - I2CM_ADDRESS
 * - HW_HDMI_I2CM_DATAO - I2CM_DATAO
 * - HW_HDMI_I2CM_DATAI - I2CM_DATAI
 * - HW_HDMI_I2CM_OPERATION - I2CM_OPERATION
 * - HW_HDMI_I2CM_INT - I2CM_INT
 * - HW_HDMI_I2CM_CTLINT - I2CM_CTLINT
 * - HW_HDMI_I2CM_DIV - I2CM_DIV
 * - HW_HDMI_I2CM_SEGADDR - I2CM_SEGADDR
 * - HW_HDMI_I2CM_SOFTRSTZ - I2CM_SOFTRSTZ
 * - HW_HDMI_I2CM_SEGPTR - I2CM_SEGPTR
 * - HW_HDMI_I2CM_SS_SCL_HCNT_1_ADDR - I2CM_SS_SCL_HCNT_1_ADDR
 * - HW_HDMI_I2CM_SS_SCL_HCNT_0_ADDR - I2CM_SS_SCL_HCNT_0_ADDR
 * - HW_HDMI_I2CM_SS_SCL_LCNT_1_ADDR - I2CM_SS_SCL_LCNT_1_ADDR
 * - HW_HDMI_I2CM_SS_SCL_LCNT_0_ADDR - I2CM_SS_SCL_LCNT_0_ADDR
 * - HW_HDMI_I2CM_FS_SCL_HCNT_1_ADDR - I2CM_FS_SCL_HCNT_1_ADDR
 * - HW_HDMI_I2CM_FS_SCL_HCNT_0_ADDR - I2CM_FS_SCL_HCNT_0_ADDR
 * - HW_HDMI_I2CM_FS_SCL_LCNT_1_ADDR - I2CM_FS_SCL_LCNT_1_ADDR
 * - HW_HDMI_I2CM_FS_SCL_LCNT_0_ADDR - I2CM_FS_SCL_LCNT_0_ADDR
 * - HW_HDMI_BASE_POINTER_ADDR - BASE_POINTER_ADDR
 *
 * - hw_hdmi_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_HDMI_BASE
#define HW_HDMI_INSTANCE_COUNT (1) //!< Number of instances of the HDMI module.
#define REGS_HDMI_BASE (0x00120000) //!< Base address for HDMI.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_DESIGN_ID - Design Identification Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_DESIGN_ID - Design Identification Register (RO)
 *
 * Reset value: 0x00
 *
 * The following are the registers used to identify the HDMI TX controller.
 */
typedef union _hw_hdmi_design_id
{
    reg8_t U;
    struct _hw_hdmi_design_id_bitfields
    {
        unsigned char DESIGN_ID : 8; //!< [7:0] This is a 1 byte design ID code fixed by Freescale that Identifies the main revision of the HDMI TX controller.
    } B;
} hw_hdmi_design_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_DESIGN_ID register
 */
//@{
#define HW_HDMI_DESIGN_ID_ADDR      (REGS_HDMI_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_DESIGN_ID           (*(volatile hw_hdmi_design_id_t *) HW_HDMI_DESIGN_ID_ADDR)
#define HW_HDMI_DESIGN_ID_RD()      (HW_HDMI_DESIGN_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_DESIGN_ID bitfields
 */

/*! @name Register HDMI_DESIGN_ID, field DESIGN_ID[7:0] (RO)
 *
 * This is a 1 byte design ID code fixed by Freescale that Identifies the main revision of the HDMI
 * TX controller. For example, HDMI TX 1.30a, DESIGN_ID = 11h; REVISION_ID = 0Ah
 */
//@{
#define BP_HDMI_DESIGN_ID_DESIGN_ID      (0)      //!< Bit position for HDMI_DESIGN_ID_DESIGN_ID.
#define BM_HDMI_DESIGN_ID_DESIGN_ID      (0x000000ff)  //!< Bit mask for HDMI_DESIGN_ID_DESIGN_ID.

//! @brief Get value of HDMI_DESIGN_ID_DESIGN_ID from a register value.
#define BG_HDMI_DESIGN_ID_DESIGN_ID(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_DESIGN_ID_DESIGN_ID) >> BP_HDMI_DESIGN_ID_DESIGN_ID)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_REVISION_ID - Revision Identification Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_REVISION_ID - Revision Identification Register (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_revision_id
{
    reg8_t U;
    struct _hw_hdmi_revision_id_bitfields
    {
        unsigned char REVISION_ID : 8; //!< [7:0] This is a one byte revision ID code fixed by Freescale that Identifies the main revision of the HDMI TX controller.
    } B;
} hw_hdmi_revision_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_REVISION_ID register
 */
//@{
#define HW_HDMI_REVISION_ID_ADDR      (REGS_HDMI_BASE + 0x1)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_REVISION_ID           (*(volatile hw_hdmi_revision_id_t *) HW_HDMI_REVISION_ID_ADDR)
#define HW_HDMI_REVISION_ID_RD()      (HW_HDMI_REVISION_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_REVISION_ID bitfields
 */

/*! @name Register HDMI_REVISION_ID, field REVISION_ID[7:0] (RO)
 *
 * This is a one byte revision ID code fixed by Freescale that Identifies the main revision of the
 * HDMI TX controller. For example, HDMI TX 1.30a, DESIGN_ID = 12h; REVISION_ID = 0Ah
 */
//@{
#define BP_HDMI_REVISION_ID_REVISION_ID      (0)      //!< Bit position for HDMI_REVISION_ID_REVISION_ID.
#define BM_HDMI_REVISION_ID_REVISION_ID      (0x000000ff)  //!< Bit mask for HDMI_REVISION_ID_REVISION_ID.

//! @brief Get value of HDMI_REVISION_ID_REVISION_ID from a register value.
#define BG_HDMI_REVISION_ID_REVISION_ID(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_REVISION_ID_REVISION_ID) >> BP_HDMI_REVISION_ID_REVISION_ID)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PRODUCT_ID0 - Product Identification Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PRODUCT_ID0 - Product Identification Register 0 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_product_id0
{
    reg8_t U;
    struct _hw_hdmi_product_id0_bitfields
    {
        unsigned char PRODUCT_ID0 : 8; //!< [7:0] This one byte fixed code Identifies Freescale's product line ("A0h" for HDMI TX products).
    } B;
} hw_hdmi_product_id0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PRODUCT_ID0 register
 */
//@{
#define HW_HDMI_PRODUCT_ID0_ADDR      (REGS_HDMI_BASE + 0x2)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PRODUCT_ID0           (*(volatile hw_hdmi_product_id0_t *) HW_HDMI_PRODUCT_ID0_ADDR)
#define HW_HDMI_PRODUCT_ID0_RD()      (HW_HDMI_PRODUCT_ID0.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PRODUCT_ID0 bitfields
 */

/*! @name Register HDMI_PRODUCT_ID0, field PRODUCT_ID0[7:0] (RO)
 *
 * This one byte fixed code Identifies Freescale's product line ("A0h" for HDMI TX products).
 */
//@{
#define BP_HDMI_PRODUCT_ID0_PRODUCT_ID0      (0)      //!< Bit position for HDMI_PRODUCT_ID0_PRODUCT_ID0.
#define BM_HDMI_PRODUCT_ID0_PRODUCT_ID0      (0x000000ff)  //!< Bit mask for HDMI_PRODUCT_ID0_PRODUCT_ID0.

//! @brief Get value of HDMI_PRODUCT_ID0_PRODUCT_ID0 from a register value.
#define BG_HDMI_PRODUCT_ID0_PRODUCT_ID0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PRODUCT_ID0_PRODUCT_ID0) >> BP_HDMI_PRODUCT_ID0_PRODUCT_ID0)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PRODUCT_ID1 - Product Identification Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PRODUCT_ID1 - Product Identification Register 1 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_product_id1
{
    reg8_t U;
    struct _hw_hdmi_product_id1_bitfields
    {
        unsigned char PRODUCT_ID1 : 8; //!< [7:0] This one byte fixed code identifies Freescale's product line according to:
    } B;
} hw_hdmi_product_id1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PRODUCT_ID1 register
 */
//@{
#define HW_HDMI_PRODUCT_ID1_ADDR      (REGS_HDMI_BASE + 0x3)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PRODUCT_ID1           (*(volatile hw_hdmi_product_id1_t *) HW_HDMI_PRODUCT_ID1_ADDR)
#define HW_HDMI_PRODUCT_ID1_RD()      (HW_HDMI_PRODUCT_ID1.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PRODUCT_ID1 bitfields
 */

/*! @name Register HDMI_PRODUCT_ID1, field PRODUCT_ID1[7:0] (RO)
 *
 * This one byte fixed code identifies Freescale's product line according to: 01h HDMI TX Controller
 * 02h DWC_hdmi_rx Controller C1h HDMI TX Controller with HDCP encryption engine C2h DWC_hdmi_rx
 * Controller with encryption engine
 */
//@{
#define BP_HDMI_PRODUCT_ID1_PRODUCT_ID1      (0)      //!< Bit position for HDMI_PRODUCT_ID1_PRODUCT_ID1.
#define BM_HDMI_PRODUCT_ID1_PRODUCT_ID1      (0x000000ff)  //!< Bit mask for HDMI_PRODUCT_ID1_PRODUCT_ID1.

//! @brief Get value of HDMI_PRODUCT_ID1_PRODUCT_ID1 from a register value.
#define BG_HDMI_PRODUCT_ID1_PRODUCT_ID1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PRODUCT_ID1_PRODUCT_ID1) >> BP_HDMI_PRODUCT_ID1_PRODUCT_ID1)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CONFIG0_ID - Configuration Identification Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CONFIG0_ID - Configuration Identification Register 0 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_config0_id
{
    reg8_t U;
    struct _hw_hdmi_config0_id_bitfields
    {
        unsigned char HDCP : 1; //!< [0] Indicates if HDCP is present
        unsigned char CEC : 1; //!< [1] Indicates if CEC is present
        unsigned char CSC : 1; //!< [2] Indicates if Color Space Conversion block is present
        unsigned char HDMI14 : 1; //!< [3] Indicates if HDMI 1.4 features are present
        unsigned char AUDI2S : 1; //!< [4] Indicates if I2S interface is present
        unsigned char AUDSPDIF : 1; //!< [5] Indicates if SPDIF interface is present
        unsigned char AUDHBR : 1; //!< [6] Indicates if HBR interface is present
        unsigned char PREPEN : 1; //!< [7] Indicates if it is possible to use internal pixel repetition
    } B;
} hw_hdmi_config0_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CONFIG0_ID register
 */
//@{
#define HW_HDMI_CONFIG0_ID_ADDR      (REGS_HDMI_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CONFIG0_ID           (*(volatile hw_hdmi_config0_id_t *) HW_HDMI_CONFIG0_ID_ADDR)
#define HW_HDMI_CONFIG0_ID_RD()      (HW_HDMI_CONFIG0_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_CONFIG0_ID bitfields
 */

/*! @name Register HDMI_CONFIG0_ID, field HDCP[0] (RO)
 *
 * Indicates if HDCP is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_HDCP      (0)      //!< Bit position for HDMI_CONFIG0_ID_HDCP.
#define BM_HDMI_CONFIG0_ID_HDCP      (0x00000001)  //!< Bit mask for HDMI_CONFIG0_ID_HDCP.

//! @brief Get value of HDMI_CONFIG0_ID_HDCP from a register value.
#define BG_HDMI_CONFIG0_ID_HDCP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_HDCP) >> BP_HDMI_CONFIG0_ID_HDCP)
//@}

/*! @name Register HDMI_CONFIG0_ID, field CEC[1] (RO)
 *
 * Indicates if CEC is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_CEC      (1)      //!< Bit position for HDMI_CONFIG0_ID_CEC.
#define BM_HDMI_CONFIG0_ID_CEC      (0x00000002)  //!< Bit mask for HDMI_CONFIG0_ID_CEC.

//! @brief Get value of HDMI_CONFIG0_ID_CEC from a register value.
#define BG_HDMI_CONFIG0_ID_CEC(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_CEC) >> BP_HDMI_CONFIG0_ID_CEC)
//@}

/*! @name Register HDMI_CONFIG0_ID, field CSC[2] (RO)
 *
 * Indicates if Color Space Conversion block is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_CSC      (2)      //!< Bit position for HDMI_CONFIG0_ID_CSC.
#define BM_HDMI_CONFIG0_ID_CSC      (0x00000004)  //!< Bit mask for HDMI_CONFIG0_ID_CSC.

//! @brief Get value of HDMI_CONFIG0_ID_CSC from a register value.
#define BG_HDMI_CONFIG0_ID_CSC(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_CSC) >> BP_HDMI_CONFIG0_ID_CSC)
//@}

/*! @name Register HDMI_CONFIG0_ID, field HDMI14[3] (RO)
 *
 * Indicates if HDMI 1.4 features are present
 */
//@{
#define BP_HDMI_CONFIG0_ID_HDMI14      (3)      //!< Bit position for HDMI_CONFIG0_ID_HDMI14.
#define BM_HDMI_CONFIG0_ID_HDMI14      (0x00000008)  //!< Bit mask for HDMI_CONFIG0_ID_HDMI14.

//! @brief Get value of HDMI_CONFIG0_ID_HDMI14 from a register value.
#define BG_HDMI_CONFIG0_ID_HDMI14(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_HDMI14) >> BP_HDMI_CONFIG0_ID_HDMI14)
//@}

/*! @name Register HDMI_CONFIG0_ID, field AUDI2S[4] (RO)
 *
 * Indicates if I2S interface is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_AUDI2S      (4)      //!< Bit position for HDMI_CONFIG0_ID_AUDI2S.
#define BM_HDMI_CONFIG0_ID_AUDI2S      (0x00000010)  //!< Bit mask for HDMI_CONFIG0_ID_AUDI2S.

//! @brief Get value of HDMI_CONFIG0_ID_AUDI2S from a register value.
#define BG_HDMI_CONFIG0_ID_AUDI2S(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_AUDI2S) >> BP_HDMI_CONFIG0_ID_AUDI2S)
//@}

/*! @name Register HDMI_CONFIG0_ID, field AUDSPDIF[5] (RO)
 *
 * Indicates if SPDIF interface is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_AUDSPDIF      (5)      //!< Bit position for HDMI_CONFIG0_ID_AUDSPDIF.
#define BM_HDMI_CONFIG0_ID_AUDSPDIF      (0x00000020)  //!< Bit mask for HDMI_CONFIG0_ID_AUDSPDIF.

//! @brief Get value of HDMI_CONFIG0_ID_AUDSPDIF from a register value.
#define BG_HDMI_CONFIG0_ID_AUDSPDIF(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_AUDSPDIF) >> BP_HDMI_CONFIG0_ID_AUDSPDIF)
//@}

/*! @name Register HDMI_CONFIG0_ID, field AUDHBR[6] (RO)
 *
 * Indicates if HBR interface is present
 */
//@{
#define BP_HDMI_CONFIG0_ID_AUDHBR      (6)      //!< Bit position for HDMI_CONFIG0_ID_AUDHBR.
#define BM_HDMI_CONFIG0_ID_AUDHBR      (0x00000040)  //!< Bit mask for HDMI_CONFIG0_ID_AUDHBR.

//! @brief Get value of HDMI_CONFIG0_ID_AUDHBR from a register value.
#define BG_HDMI_CONFIG0_ID_AUDHBR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_AUDHBR) >> BP_HDMI_CONFIG0_ID_AUDHBR)
//@}

/*! @name Register HDMI_CONFIG0_ID, field PREPEN[7] (RO)
 *
 * Indicates if it is possible to use internal pixel repetition
 */
//@{
#define BP_HDMI_CONFIG0_ID_PREPEN      (7)      //!< Bit position for HDMI_CONFIG0_ID_PREPEN.
#define BM_HDMI_CONFIG0_ID_PREPEN      (0x00000080)  //!< Bit mask for HDMI_CONFIG0_ID_PREPEN.

//! @brief Get value of HDMI_CONFIG0_ID_PREPEN from a register value.
#define BG_HDMI_CONFIG0_ID_PREPEN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG0_ID_PREPEN) >> BP_HDMI_CONFIG0_ID_PREPEN)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CONFIG1_ID - Configuration Identification Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CONFIG1_ID - Configuration Identification Register 1 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_config1_id
{
    reg8_t U;
    struct _hw_hdmi_config1_id_bitfields
    {
        unsigned char CONFAHB : 1; //!< [0] Indicates that configuration interface is AHB interface
        unsigned char CONFAPB : 1; //!< [1] Indicates that configuration interface is APB interface
        unsigned char CONFOCP : 1; //!< [2] Indicates that configuration interface is OCP interface
        unsigned char CONFI2C : 1; //!< [3] Indicates that configuration interface is I2C interface
        unsigned char CONFSFRDIR : 1; //!< [4] Indicates that configuration interface is SFR interface
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_config1_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CONFIG1_ID register
 */
//@{
#define HW_HDMI_CONFIG1_ID_ADDR      (REGS_HDMI_BASE + 0x5)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CONFIG1_ID           (*(volatile hw_hdmi_config1_id_t *) HW_HDMI_CONFIG1_ID_ADDR)
#define HW_HDMI_CONFIG1_ID_RD()      (HW_HDMI_CONFIG1_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_CONFIG1_ID bitfields
 */

/*! @name Register HDMI_CONFIG1_ID, field CONFAHB[0] (RO)
 *
 * Indicates that configuration interface is AHB interface
 */
//@{
#define BP_HDMI_CONFIG1_ID_CONFAHB      (0)      //!< Bit position for HDMI_CONFIG1_ID_CONFAHB.
#define BM_HDMI_CONFIG1_ID_CONFAHB      (0x00000001)  //!< Bit mask for HDMI_CONFIG1_ID_CONFAHB.

//! @brief Get value of HDMI_CONFIG1_ID_CONFAHB from a register value.
#define BG_HDMI_CONFIG1_ID_CONFAHB(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG1_ID_CONFAHB) >> BP_HDMI_CONFIG1_ID_CONFAHB)
//@}

/*! @name Register HDMI_CONFIG1_ID, field CONFAPB[1] (RO)
 *
 * Indicates that configuration interface is APB interface
 */
//@{
#define BP_HDMI_CONFIG1_ID_CONFAPB      (1)      //!< Bit position for HDMI_CONFIG1_ID_CONFAPB.
#define BM_HDMI_CONFIG1_ID_CONFAPB      (0x00000002)  //!< Bit mask for HDMI_CONFIG1_ID_CONFAPB.

//! @brief Get value of HDMI_CONFIG1_ID_CONFAPB from a register value.
#define BG_HDMI_CONFIG1_ID_CONFAPB(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG1_ID_CONFAPB) >> BP_HDMI_CONFIG1_ID_CONFAPB)
//@}

/*! @name Register HDMI_CONFIG1_ID, field CONFOCP[2] (RO)
 *
 * Indicates that configuration interface is OCP interface
 */
//@{
#define BP_HDMI_CONFIG1_ID_CONFOCP      (2)      //!< Bit position for HDMI_CONFIG1_ID_CONFOCP.
#define BM_HDMI_CONFIG1_ID_CONFOCP      (0x00000004)  //!< Bit mask for HDMI_CONFIG1_ID_CONFOCP.

//! @brief Get value of HDMI_CONFIG1_ID_CONFOCP from a register value.
#define BG_HDMI_CONFIG1_ID_CONFOCP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG1_ID_CONFOCP) >> BP_HDMI_CONFIG1_ID_CONFOCP)
//@}

/*! @name Register HDMI_CONFIG1_ID, field CONFI2C[3] (RO)
 *
 * Indicates that configuration interface is I2C interface
 */
//@{
#define BP_HDMI_CONFIG1_ID_CONFI2C      (3)      //!< Bit position for HDMI_CONFIG1_ID_CONFI2C.
#define BM_HDMI_CONFIG1_ID_CONFI2C      (0x00000008)  //!< Bit mask for HDMI_CONFIG1_ID_CONFI2C.

//! @brief Get value of HDMI_CONFIG1_ID_CONFI2C from a register value.
#define BG_HDMI_CONFIG1_ID_CONFI2C(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG1_ID_CONFI2C) >> BP_HDMI_CONFIG1_ID_CONFI2C)
//@}

/*! @name Register HDMI_CONFIG1_ID, field CONFSFRDIR[4] (RO)
 *
 * Indicates that configuration interface is SFR interface
 */
//@{
#define BP_HDMI_CONFIG1_ID_CONFSFRDIR      (4)      //!< Bit position for HDMI_CONFIG1_ID_CONFSFRDIR.
#define BM_HDMI_CONFIG1_ID_CONFSFRDIR      (0x00000010)  //!< Bit mask for HDMI_CONFIG1_ID_CONFSFRDIR.

//! @brief Get value of HDMI_CONFIG1_ID_CONFSFRDIR from a register value.
#define BG_HDMI_CONFIG1_ID_CONFSFRDIR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG1_ID_CONFSFRDIR) >> BP_HDMI_CONFIG1_ID_CONFSFRDIR)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CONFIG2_ID - Configuration Identification Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CONFIG2_ID - Configuration Identification Register 2 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_config2_id
{
    reg8_t U;
    struct _hw_hdmi_config2_id_bitfields
    {
        unsigned char PHYTYPE : 8; //!< [7:0] Indicates the type of PHY interface selected:
    } B;
} hw_hdmi_config2_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CONFIG2_ID register
 */
//@{
#define HW_HDMI_CONFIG2_ID_ADDR      (REGS_HDMI_BASE + 0x6)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CONFIG2_ID           (*(volatile hw_hdmi_config2_id_t *) HW_HDMI_CONFIG2_ID_ADDR)
#define HW_HDMI_CONFIG2_ID_RD()      (HW_HDMI_CONFIG2_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_CONFIG2_ID bitfields
 */

/*! @name Register HDMI_CONFIG2_ID, field PHYTYPE[7:0] (RO)
 *
 * Indicates the type of PHY interface selected: 00h Legacy PHY (HDMI TX PHY) F2h PHY_Gen2 (HDMI 3D
 * TX PHY) E2h PHY_Gen2 (HDMI 3D TX PHY) + HEAC PHY
 */
//@{
#define BP_HDMI_CONFIG2_ID_PHYTYPE      (0)      //!< Bit position for HDMI_CONFIG2_ID_PHYTYPE.
#define BM_HDMI_CONFIG2_ID_PHYTYPE      (0x000000ff)  //!< Bit mask for HDMI_CONFIG2_ID_PHYTYPE.

//! @brief Get value of HDMI_CONFIG2_ID_PHYTYPE from a register value.
#define BG_HDMI_CONFIG2_ID_PHYTYPE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG2_ID_PHYTYPE) >> BP_HDMI_CONFIG2_ID_PHYTYPE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CONFIG3_ID - Configuration Identification Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CONFIG3_ID - Configuration Identification Register 3 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_config3_id
{
    reg8_t U;
    struct _hw_hdmi_config3_id_bitfields
    {
        unsigned char CONFGPAUD : 1; //!< [0] Indicates that configuration interface is Generic Parallel Audio (GPAUD) interface
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_config3_id_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CONFIG3_ID register
 */
//@{
#define HW_HDMI_CONFIG3_ID_ADDR      (REGS_HDMI_BASE + 0x7)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CONFIG3_ID           (*(volatile hw_hdmi_config3_id_t *) HW_HDMI_CONFIG3_ID_ADDR)
#define HW_HDMI_CONFIG3_ID_RD()      (HW_HDMI_CONFIG3_ID.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_CONFIG3_ID bitfields
 */

/*! @name Register HDMI_CONFIG3_ID, field CONFGPAUD[0] (RO)
 *
 * Indicates that configuration interface is Generic Parallel Audio (GPAUD) interface
 */
//@{
#define BP_HDMI_CONFIG3_ID_CONFGPAUD      (0)      //!< Bit position for HDMI_CONFIG3_ID_CONFGPAUD.
#define BM_HDMI_CONFIG3_ID_CONFGPAUD      (0x00000001)  //!< Bit mask for HDMI_CONFIG3_ID_CONFGPAUD.

//! @brief Get value of HDMI_CONFIG3_ID_CONFGPAUD from a register value.
#define BG_HDMI_CONFIG3_ID_CONFGPAUD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CONFIG3_ID_CONFGPAUD) >> BP_HDMI_CONFIG3_ID_CONFGPAUD)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_FC_STAT0 - Frame Composer Interrupt Status Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_FC_STAT0 - Frame Composer Interrupt Status Register 0 (W1C)
 *
 * Reset value: 0x00
 *
 * This section describes clear on write (1 to corresponding bit) status registers, which contain
 * the following active-high, sticky bit interrupts. HDMI TX introduces a new set of sticky bit mute
 * control registers (IH_MUTE_FC_STAT0 to IH_MUTE_AHBDMAAUD_STAT0) that correspond to the interrupt
 * registers. You can ignore a sticky bit interrupt by setting the corresponding mute control
 * register bit to 1. This puts the global interrupt line on a higher priority than the sticky bit
 * interrupt.
 */
typedef union _hw_hdmi_ih_fc_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_fc_stat0_bitfields
    {
        unsigned char NULL_ : 1; //!< [0] Active after successful transmission of an Null packet.
        unsigned char ACR : 1; //!< [1] Active after successful transmission of an Audio Clock Regeneration (N/CTS transmission) packet.
        unsigned char AUDS : 1; //!< [2] Active after successful transmission of an Audio Sample packet.
        unsigned char OBA : 1; //!< [3] Reserved
        unsigned char DST : 1; //!< [4] Reserved
        unsigned char HBR : 1; //!< [5] Active after successful transmission of an Audio HBR packet.
        unsigned char ACP : 1; //!< [6] Active after successful transmission of an Audio Content Protection packet.
        unsigned char AUDI : 1; //!< [7] Active after successful transmission of an Audio InfoFrame packet.
    } B;
} hw_hdmi_ih_fc_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_FC_STAT0 register
 */
//@{
#define HW_HDMI_IH_FC_STAT0_ADDR      (REGS_HDMI_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_FC_STAT0           (*(volatile hw_hdmi_ih_fc_stat0_t *) HW_HDMI_IH_FC_STAT0_ADDR)
#define HW_HDMI_IH_FC_STAT0_RD()      (HW_HDMI_IH_FC_STAT0.U)
#define HW_HDMI_IH_FC_STAT0_WR(v)     (HW_HDMI_IH_FC_STAT0.U = (v))
#define HW_HDMI_IH_FC_STAT0_SET(v)    (HW_HDMI_IH_FC_STAT0_WR(HW_HDMI_IH_FC_STAT0_RD() |  (v)))
#define HW_HDMI_IH_FC_STAT0_CLR(v)    (HW_HDMI_IH_FC_STAT0_WR(HW_HDMI_IH_FC_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_FC_STAT0_TOG(v)    (HW_HDMI_IH_FC_STAT0_WR(HW_HDMI_IH_FC_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_FC_STAT0 bitfields
 */

/*! @name Register HDMI_IH_FC_STAT0, field NULL_[0] (W1C)
 *
 * Active after successful transmission of an Null packet. Due to high number of audio sample
 * packets transmitted, this interrupt is by default masked at frame composer.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_NULL_      (0)      //!< Bit position for HDMI_IH_FC_STAT0_NULL_.
#define BM_HDMI_IH_FC_STAT0_NULL_      (0x00000001)  //!< Bit mask for HDMI_IH_FC_STAT0_NULL_.

//! @brief Get value of HDMI_IH_FC_STAT0_NULL_ from a register value.
#define BG_HDMI_IH_FC_STAT0_NULL_(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_NULL_) >> BP_HDMI_IH_FC_STAT0_NULL_)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_NULL_.
#define BF_HDMI_IH_FC_STAT0_NULL_(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_NULL_) & BM_HDMI_IH_FC_STAT0_NULL_)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NULL_ field to a new value.
#define BW_HDMI_IH_FC_STAT0_NULL_(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_NULL_) | BF_HDMI_IH_FC_STAT0_NULL_(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field ACR[1] (W1C)
 *
 * Active after successful transmission of an Audio Clock Regeneration (N/CTS transmission) packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_ACR      (1)      //!< Bit position for HDMI_IH_FC_STAT0_ACR.
#define BM_HDMI_IH_FC_STAT0_ACR      (0x00000002)  //!< Bit mask for HDMI_IH_FC_STAT0_ACR.

//! @brief Get value of HDMI_IH_FC_STAT0_ACR from a register value.
#define BG_HDMI_IH_FC_STAT0_ACR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_ACR) >> BP_HDMI_IH_FC_STAT0_ACR)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_ACR.
#define BF_HDMI_IH_FC_STAT0_ACR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_ACR) & BM_HDMI_IH_FC_STAT0_ACR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACR field to a new value.
#define BW_HDMI_IH_FC_STAT0_ACR(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_ACR) | BF_HDMI_IH_FC_STAT0_ACR(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field AUDS[2] (W1C)
 *
 * Active after successful transmission of an Audio Sample packet. Due to high number of audio
 * sample packets transmitted, this interrupt is by default masked at frame composer.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_AUDS      (2)      //!< Bit position for HDMI_IH_FC_STAT0_AUDS.
#define BM_HDMI_IH_FC_STAT0_AUDS      (0x00000004)  //!< Bit mask for HDMI_IH_FC_STAT0_AUDS.

//! @brief Get value of HDMI_IH_FC_STAT0_AUDS from a register value.
#define BG_HDMI_IH_FC_STAT0_AUDS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_AUDS) >> BP_HDMI_IH_FC_STAT0_AUDS)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_AUDS.
#define BF_HDMI_IH_FC_STAT0_AUDS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_AUDS) & BM_HDMI_IH_FC_STAT0_AUDS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDS field to a new value.
#define BW_HDMI_IH_FC_STAT0_AUDS(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_AUDS) | BF_HDMI_IH_FC_STAT0_AUDS(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field OBA[3] (W1C)
 *
 * Reserved
 */
//@{
#define BP_HDMI_IH_FC_STAT0_OBA      (3)      //!< Bit position for HDMI_IH_FC_STAT0_OBA.
#define BM_HDMI_IH_FC_STAT0_OBA      (0x00000008)  //!< Bit mask for HDMI_IH_FC_STAT0_OBA.

//! @brief Get value of HDMI_IH_FC_STAT0_OBA from a register value.
#define BG_HDMI_IH_FC_STAT0_OBA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_OBA) >> BP_HDMI_IH_FC_STAT0_OBA)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_OBA.
#define BF_HDMI_IH_FC_STAT0_OBA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_OBA) & BM_HDMI_IH_FC_STAT0_OBA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OBA field to a new value.
#define BW_HDMI_IH_FC_STAT0_OBA(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_OBA) | BF_HDMI_IH_FC_STAT0_OBA(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field DST[4] (W1C)
 *
 * Reserved
 */
//@{
#define BP_HDMI_IH_FC_STAT0_DST      (4)      //!< Bit position for HDMI_IH_FC_STAT0_DST.
#define BM_HDMI_IH_FC_STAT0_DST      (0x00000010)  //!< Bit mask for HDMI_IH_FC_STAT0_DST.

//! @brief Get value of HDMI_IH_FC_STAT0_DST from a register value.
#define BG_HDMI_IH_FC_STAT0_DST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_DST) >> BP_HDMI_IH_FC_STAT0_DST)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_DST.
#define BF_HDMI_IH_FC_STAT0_DST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_DST) & BM_HDMI_IH_FC_STAT0_DST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DST field to a new value.
#define BW_HDMI_IH_FC_STAT0_DST(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_DST) | BF_HDMI_IH_FC_STAT0_DST(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field HBR[5] (W1C)
 *
 * Active after successful transmission of an Audio HBR packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_HBR      (5)      //!< Bit position for HDMI_IH_FC_STAT0_HBR.
#define BM_HDMI_IH_FC_STAT0_HBR      (0x00000020)  //!< Bit mask for HDMI_IH_FC_STAT0_HBR.

//! @brief Get value of HDMI_IH_FC_STAT0_HBR from a register value.
#define BG_HDMI_IH_FC_STAT0_HBR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_HBR) >> BP_HDMI_IH_FC_STAT0_HBR)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_HBR.
#define BF_HDMI_IH_FC_STAT0_HBR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_HBR) & BM_HDMI_IH_FC_STAT0_HBR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HBR field to a new value.
#define BW_HDMI_IH_FC_STAT0_HBR(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_HBR) | BF_HDMI_IH_FC_STAT0_HBR(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field ACP[6] (W1C)
 *
 * Active after successful transmission of an Audio Content Protection packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_ACP      (6)      //!< Bit position for HDMI_IH_FC_STAT0_ACP.
#define BM_HDMI_IH_FC_STAT0_ACP      (0x00000040)  //!< Bit mask for HDMI_IH_FC_STAT0_ACP.

//! @brief Get value of HDMI_IH_FC_STAT0_ACP from a register value.
#define BG_HDMI_IH_FC_STAT0_ACP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_ACP) >> BP_HDMI_IH_FC_STAT0_ACP)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_ACP.
#define BF_HDMI_IH_FC_STAT0_ACP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_ACP) & BM_HDMI_IH_FC_STAT0_ACP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACP field to a new value.
#define BW_HDMI_IH_FC_STAT0_ACP(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_ACP) | BF_HDMI_IH_FC_STAT0_ACP(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT0, field AUDI[7] (W1C)
 *
 * Active after successful transmission of an Audio InfoFrame packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT0_AUDI      (7)      //!< Bit position for HDMI_IH_FC_STAT0_AUDI.
#define BM_HDMI_IH_FC_STAT0_AUDI      (0x00000080)  //!< Bit mask for HDMI_IH_FC_STAT0_AUDI.

//! @brief Get value of HDMI_IH_FC_STAT0_AUDI from a register value.
#define BG_HDMI_IH_FC_STAT0_AUDI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT0_AUDI) >> BP_HDMI_IH_FC_STAT0_AUDI)

//! @brief Format value for bitfield HDMI_IH_FC_STAT0_AUDI.
#define BF_HDMI_IH_FC_STAT0_AUDI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT0_AUDI) & BM_HDMI_IH_FC_STAT0_AUDI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDI field to a new value.
#define BW_HDMI_IH_FC_STAT0_AUDI(v)   (HW_HDMI_IH_FC_STAT0_WR((HW_HDMI_IH_FC_STAT0_RD() & ~BM_HDMI_IH_FC_STAT0_AUDI) | BF_HDMI_IH_FC_STAT0_AUDI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_FC_STAT1 - Frame Composer Interrupt Status Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_FC_STAT1 - Frame Composer Interrupt Status Register 1 (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_fc_stat1
{
    reg8_t U;
    struct _hw_hdmi_ih_fc_stat1_bitfields
    {
        unsigned char GCP : 1; //!< [0] Active after successful transmission of an General Control Packet.
        unsigned char AVI : 1; //!< [1] Active after successful transmission of an AVI infoFrame packet.
        unsigned char MPEG : 1; //!< [2] Reserved
        unsigned char SPD : 1; //!< [3] Active after successful transmission of an Source Product Descriptor infoFrame packet.
        unsigned char VSD : 1; //!< [4] Active after successful transmission of an Vendor Specific Data infoFrame packet.
        unsigned char ISCR2 : 1; //!< [5] Active after successful transmission of an International Standard Recording Code 2 packet.
        unsigned char ISCR1 : 1; //!< [6] Active after successful transmission of an International Standard Recording Code 1 packet.
        unsigned char GMD : 1; //!< [7] Active after successful transmission of an Gamut metadata packet.
    } B;
} hw_hdmi_ih_fc_stat1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_FC_STAT1 register
 */
//@{
#define HW_HDMI_IH_FC_STAT1_ADDR      (REGS_HDMI_BASE + 0x101)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_FC_STAT1           (*(volatile hw_hdmi_ih_fc_stat1_t *) HW_HDMI_IH_FC_STAT1_ADDR)
#define HW_HDMI_IH_FC_STAT1_RD()      (HW_HDMI_IH_FC_STAT1.U)
#define HW_HDMI_IH_FC_STAT1_WR(v)     (HW_HDMI_IH_FC_STAT1.U = (v))
#define HW_HDMI_IH_FC_STAT1_SET(v)    (HW_HDMI_IH_FC_STAT1_WR(HW_HDMI_IH_FC_STAT1_RD() |  (v)))
#define HW_HDMI_IH_FC_STAT1_CLR(v)    (HW_HDMI_IH_FC_STAT1_WR(HW_HDMI_IH_FC_STAT1_RD() & ~(v)))
#define HW_HDMI_IH_FC_STAT1_TOG(v)    (HW_HDMI_IH_FC_STAT1_WR(HW_HDMI_IH_FC_STAT1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_FC_STAT1 bitfields
 */

/*! @name Register HDMI_IH_FC_STAT1, field GCP[0] (W1C)
 *
 * Active after successful transmission of an General Control Packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_GCP      (0)      //!< Bit position for HDMI_IH_FC_STAT1_GCP.
#define BM_HDMI_IH_FC_STAT1_GCP      (0x00000001)  //!< Bit mask for HDMI_IH_FC_STAT1_GCP.

//! @brief Get value of HDMI_IH_FC_STAT1_GCP from a register value.
#define BG_HDMI_IH_FC_STAT1_GCP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_GCP) >> BP_HDMI_IH_FC_STAT1_GCP)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_GCP.
#define BF_HDMI_IH_FC_STAT1_GCP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_GCP) & BM_HDMI_IH_FC_STAT1_GCP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCP field to a new value.
#define BW_HDMI_IH_FC_STAT1_GCP(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_GCP) | BF_HDMI_IH_FC_STAT1_GCP(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field AVI[1] (W1C)
 *
 * Active after successful transmission of an AVI infoFrame packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_AVI      (1)      //!< Bit position for HDMI_IH_FC_STAT1_AVI.
#define BM_HDMI_IH_FC_STAT1_AVI      (0x00000002)  //!< Bit mask for HDMI_IH_FC_STAT1_AVI.

//! @brief Get value of HDMI_IH_FC_STAT1_AVI from a register value.
#define BG_HDMI_IH_FC_STAT1_AVI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_AVI) >> BP_HDMI_IH_FC_STAT1_AVI)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_AVI.
#define BF_HDMI_IH_FC_STAT1_AVI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_AVI) & BM_HDMI_IH_FC_STAT1_AVI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVI field to a new value.
#define BW_HDMI_IH_FC_STAT1_AVI(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_AVI) | BF_HDMI_IH_FC_STAT1_AVI(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field MPEG[2] (W1C)
 *
 * Reserved
 */
//@{
#define BP_HDMI_IH_FC_STAT1_MPEG      (2)      //!< Bit position for HDMI_IH_FC_STAT1_MPEG.
#define BM_HDMI_IH_FC_STAT1_MPEG      (0x00000004)  //!< Bit mask for HDMI_IH_FC_STAT1_MPEG.

//! @brief Get value of HDMI_IH_FC_STAT1_MPEG from a register value.
#define BG_HDMI_IH_FC_STAT1_MPEG(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_MPEG) >> BP_HDMI_IH_FC_STAT1_MPEG)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_MPEG.
#define BF_HDMI_IH_FC_STAT1_MPEG(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_MPEG) & BM_HDMI_IH_FC_STAT1_MPEG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPEG field to a new value.
#define BW_HDMI_IH_FC_STAT1_MPEG(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_MPEG) | BF_HDMI_IH_FC_STAT1_MPEG(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field SPD[3] (W1C)
 *
 * Active after successful transmission of an Source Product Descriptor infoFrame packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_SPD      (3)      //!< Bit position for HDMI_IH_FC_STAT1_SPD.
#define BM_HDMI_IH_FC_STAT1_SPD      (0x00000008)  //!< Bit mask for HDMI_IH_FC_STAT1_SPD.

//! @brief Get value of HDMI_IH_FC_STAT1_SPD from a register value.
#define BG_HDMI_IH_FC_STAT1_SPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_SPD) >> BP_HDMI_IH_FC_STAT1_SPD)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_SPD.
#define BF_HDMI_IH_FC_STAT1_SPD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_SPD) & BM_HDMI_IH_FC_STAT1_SPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPD field to a new value.
#define BW_HDMI_IH_FC_STAT1_SPD(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_SPD) | BF_HDMI_IH_FC_STAT1_SPD(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field VSD[4] (W1C)
 *
 * Active after successful transmission of an Vendor Specific Data infoFrame packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_VSD      (4)      //!< Bit position for HDMI_IH_FC_STAT1_VSD.
#define BM_HDMI_IH_FC_STAT1_VSD      (0x00000010)  //!< Bit mask for HDMI_IH_FC_STAT1_VSD.

//! @brief Get value of HDMI_IH_FC_STAT1_VSD from a register value.
#define BG_HDMI_IH_FC_STAT1_VSD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_VSD) >> BP_HDMI_IH_FC_STAT1_VSD)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_VSD.
#define BF_HDMI_IH_FC_STAT1_VSD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_VSD) & BM_HDMI_IH_FC_STAT1_VSD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSD field to a new value.
#define BW_HDMI_IH_FC_STAT1_VSD(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_VSD) | BF_HDMI_IH_FC_STAT1_VSD(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field ISCR2[5] (W1C)
 *
 * Active after successful transmission of an International Standard Recording Code 2 packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_ISCR2      (5)      //!< Bit position for HDMI_IH_FC_STAT1_ISCR2.
#define BM_HDMI_IH_FC_STAT1_ISCR2      (0x00000020)  //!< Bit mask for HDMI_IH_FC_STAT1_ISCR2.

//! @brief Get value of HDMI_IH_FC_STAT1_ISCR2 from a register value.
#define BG_HDMI_IH_FC_STAT1_ISCR2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_ISCR2) >> BP_HDMI_IH_FC_STAT1_ISCR2)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_ISCR2.
#define BF_HDMI_IH_FC_STAT1_ISCR2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_ISCR2) & BM_HDMI_IH_FC_STAT1_ISCR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR2 field to a new value.
#define BW_HDMI_IH_FC_STAT1_ISCR2(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_ISCR2) | BF_HDMI_IH_FC_STAT1_ISCR2(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field ISCR1[6] (W1C)
 *
 * Active after successful transmission of an International Standard Recording Code 1 packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_ISCR1      (6)      //!< Bit position for HDMI_IH_FC_STAT1_ISCR1.
#define BM_HDMI_IH_FC_STAT1_ISCR1      (0x00000040)  //!< Bit mask for HDMI_IH_FC_STAT1_ISCR1.

//! @brief Get value of HDMI_IH_FC_STAT1_ISCR1 from a register value.
#define BG_HDMI_IH_FC_STAT1_ISCR1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_ISCR1) >> BP_HDMI_IH_FC_STAT1_ISCR1)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_ISCR1.
#define BF_HDMI_IH_FC_STAT1_ISCR1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_ISCR1) & BM_HDMI_IH_FC_STAT1_ISCR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR1 field to a new value.
#define BW_HDMI_IH_FC_STAT1_ISCR1(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_ISCR1) | BF_HDMI_IH_FC_STAT1_ISCR1(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT1, field GMD[7] (W1C)
 *
 * Active after successful transmission of an Gamut metadata packet.
 */
//@{
#define BP_HDMI_IH_FC_STAT1_GMD      (7)      //!< Bit position for HDMI_IH_FC_STAT1_GMD.
#define BM_HDMI_IH_FC_STAT1_GMD      (0x00000080)  //!< Bit mask for HDMI_IH_FC_STAT1_GMD.

//! @brief Get value of HDMI_IH_FC_STAT1_GMD from a register value.
#define BG_HDMI_IH_FC_STAT1_GMD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT1_GMD) >> BP_HDMI_IH_FC_STAT1_GMD)

//! @brief Format value for bitfield HDMI_IH_FC_STAT1_GMD.
#define BF_HDMI_IH_FC_STAT1_GMD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT1_GMD) & BM_HDMI_IH_FC_STAT1_GMD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMD field to a new value.
#define BW_HDMI_IH_FC_STAT1_GMD(v)   (HW_HDMI_IH_FC_STAT1_WR((HW_HDMI_IH_FC_STAT1_RD() & ~BM_HDMI_IH_FC_STAT1_GMD) | BF_HDMI_IH_FC_STAT1_GMD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_FC_STAT2 - Frame Composer Interrupt Status Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_FC_STAT2 - Frame Composer Interrupt Status Register 2 (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_fc_stat2
{
    reg8_t U;
    struct _hw_hdmi_ih_fc_stat2_bitfields
    {
        unsigned char HIGHPRIORITY_OVERFLOW : 1; //!< [0] Frame Composer high priority packet queue descriptor overflow indication.
        unsigned char LOWPRIORITY_OVERFLOW : 1; //!< [1] Frame Composer low priority packet queue descriptor overflow indication.
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_fc_stat2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_FC_STAT2 register
 */
//@{
#define HW_HDMI_IH_FC_STAT2_ADDR      (REGS_HDMI_BASE + 0x102)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_FC_STAT2           (*(volatile hw_hdmi_ih_fc_stat2_t *) HW_HDMI_IH_FC_STAT2_ADDR)
#define HW_HDMI_IH_FC_STAT2_RD()      (HW_HDMI_IH_FC_STAT2.U)
#define HW_HDMI_IH_FC_STAT2_WR(v)     (HW_HDMI_IH_FC_STAT2.U = (v))
#define HW_HDMI_IH_FC_STAT2_SET(v)    (HW_HDMI_IH_FC_STAT2_WR(HW_HDMI_IH_FC_STAT2_RD() |  (v)))
#define HW_HDMI_IH_FC_STAT2_CLR(v)    (HW_HDMI_IH_FC_STAT2_WR(HW_HDMI_IH_FC_STAT2_RD() & ~(v)))
#define HW_HDMI_IH_FC_STAT2_TOG(v)    (HW_HDMI_IH_FC_STAT2_WR(HW_HDMI_IH_FC_STAT2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_FC_STAT2 bitfields
 */

/*! @name Register HDMI_IH_FC_STAT2, field HIGHPRIORITY_OVERFLOW[0] (W1C)
 *
 * Frame Composer high priority packet queue descriptor overflow indication.
 */
//@{
#define BP_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW      (0)      //!< Bit position for HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW.
#define BM_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW      (0x00000001)  //!< Bit mask for HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW.

//! @brief Get value of HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW from a register value.
#define BG_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW) >> BP_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW.
#define BF_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW) & BM_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HIGHPRIORITY_OVERFLOW field to a new value.
#define BW_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)   (HW_HDMI_IH_FC_STAT2_WR((HW_HDMI_IH_FC_STAT2_RD() & ~BM_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW) | BF_HDMI_IH_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_FC_STAT2, field LOWPRIORITY_OVERFLOW[1] (W1C)
 *
 * Frame Composer low priority packet queue descriptor overflow indication.
 */
//@{
#define BP_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW      (1)      //!< Bit position for HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW.
#define BM_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW      (0x00000002)  //!< Bit mask for HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW.

//! @brief Get value of HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW from a register value.
#define BG_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW) >> BP_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW.
#define BF_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW) & BM_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOWPRIORITY_OVERFLOW field to a new value.
#define BW_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW(v)   (HW_HDMI_IH_FC_STAT2_WR((HW_HDMI_IH_FC_STAT2_RD() & ~BM_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW) | BF_HDMI_IH_FC_STAT2_LOWPRIORITY_OVERFLOW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_AS_STAT0 - Audio Sampler Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_AS_STAT0 - Audio Sampler Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_as_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_as_stat0_bitfields
    {
        unsigned char AUD_FIFO_OVERFLOW : 1; //!< [0] Audio Sampler audio FIFO full indication.
        unsigned char AUD_FIFO_UNDERFLOW : 1; //!< [1] Audio Sampler audio FIFO empty indication.
        unsigned char AUD_FIFO_UNDERFLOW_THR : 1; //!< [2] Audio Sampler audio FIFO empty threshold (four samples) indication.
        unsigned char RESERVED0 : 5; //!< [7:3] Reserved
    } B;
} hw_hdmi_ih_as_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_AS_STAT0 register
 */
//@{
#define HW_HDMI_IH_AS_STAT0_ADDR      (REGS_HDMI_BASE + 0x103)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_AS_STAT0           (*(volatile hw_hdmi_ih_as_stat0_t *) HW_HDMI_IH_AS_STAT0_ADDR)
#define HW_HDMI_IH_AS_STAT0_RD()      (HW_HDMI_IH_AS_STAT0.U)
#define HW_HDMI_IH_AS_STAT0_WR(v)     (HW_HDMI_IH_AS_STAT0.U = (v))
#define HW_HDMI_IH_AS_STAT0_SET(v)    (HW_HDMI_IH_AS_STAT0_WR(HW_HDMI_IH_AS_STAT0_RD() |  (v)))
#define HW_HDMI_IH_AS_STAT0_CLR(v)    (HW_HDMI_IH_AS_STAT0_WR(HW_HDMI_IH_AS_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_AS_STAT0_TOG(v)    (HW_HDMI_IH_AS_STAT0_WR(HW_HDMI_IH_AS_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_AS_STAT0 bitfields
 */

/*! @name Register HDMI_IH_AS_STAT0, field AUD_FIFO_OVERFLOW[0] (W1C)
 *
 * Audio Sampler audio FIFO full indication.
 */
//@{
#define BP_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW      (0)      //!< Bit position for HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW.
#define BM_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW      (0x00000001)  //!< Bit mask for HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW.

//! @brief Get value of HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW from a register value.
#define BG_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW) >> BP_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW.
#define BF_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_OVERFLOW field to a new value.
#define BW_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW(v)   (HW_HDMI_IH_AS_STAT0_WR((HW_HDMI_IH_AS_STAT0_RD() & ~BM_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW) | BF_HDMI_IH_AS_STAT0_AUD_FIFO_OVERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_AS_STAT0, field AUD_FIFO_UNDERFLOW[1] (W1C)
 *
 * Audio Sampler audio FIFO empty indication.
 */
//@{
#define BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW      (1)      //!< Bit position for HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW.
#define BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW      (0x00000002)  //!< Bit mask for HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW.

//! @brief Get value of HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW from a register value.
#define BG_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW) >> BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW)

//! @brief Format value for bitfield HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW.
#define BF_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_UNDERFLOW field to a new value.
#define BW_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW(v)   (HW_HDMI_IH_AS_STAT0_WR((HW_HDMI_IH_AS_STAT0_RD() & ~BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW) | BF_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_AS_STAT0, field AUD_FIFO_UNDERFLOW_THR[2] (W1C)
 *
 * Audio Sampler audio FIFO empty threshold (four samples) indication. Only valid in HBR audio.
 */
//@{
#define BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR      (2)      //!< Bit position for HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.
#define BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR      (0x00000004)  //!< Bit mask for HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.

//! @brief Get value of HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR from a register value.
#define BG_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) >> BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR)

//! @brief Format value for bitfield HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.
#define BF_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) & BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_UNDERFLOW_THR field to a new value.
#define BW_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)   (HW_HDMI_IH_AS_STAT0_WR((HW_HDMI_IH_AS_STAT0_RD() & ~BM_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) | BF_HDMI_IH_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_PHY_STAT0 - PHY Interface Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_PHY_STAT0 - PHY Interface Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_phy_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_phy_stat0_bitfields
    {
        unsigned char HDP : 1; //!< [0] HDMI Hot Plug Detect indication.
        unsigned char TX_PHY_LOCK : 1; //!< [1] TX PHY PLL lock indication.
        unsigned char RX_SENSE : 1; //!< [2] TX PHY RX_SENSE indication for driver 0.
        unsigned char RX_SENSE1 : 1; //!< [3] TX PHY RX_SENSE indication for driver 1.
        unsigned char RX_SENSE2 : 1; //!< [4] TX PHY RX_SENSE indication for driver 2.
        unsigned char RX_SENSE3 : 1; //!< [5] TX PHY RX_SENSE indication for driver 3.
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_ih_phy_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_PHY_STAT0 register
 */
//@{
#define HW_HDMI_IH_PHY_STAT0_ADDR      (REGS_HDMI_BASE + 0x104)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_PHY_STAT0           (*(volatile hw_hdmi_ih_phy_stat0_t *) HW_HDMI_IH_PHY_STAT0_ADDR)
#define HW_HDMI_IH_PHY_STAT0_RD()      (HW_HDMI_IH_PHY_STAT0.U)
#define HW_HDMI_IH_PHY_STAT0_WR(v)     (HW_HDMI_IH_PHY_STAT0.U = (v))
#define HW_HDMI_IH_PHY_STAT0_SET(v)    (HW_HDMI_IH_PHY_STAT0_WR(HW_HDMI_IH_PHY_STAT0_RD() |  (v)))
#define HW_HDMI_IH_PHY_STAT0_CLR(v)    (HW_HDMI_IH_PHY_STAT0_WR(HW_HDMI_IH_PHY_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_PHY_STAT0_TOG(v)    (HW_HDMI_IH_PHY_STAT0_WR(HW_HDMI_IH_PHY_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_PHY_STAT0 bitfields
 */

/*! @name Register HDMI_IH_PHY_STAT0, field HDP[0] (W1C)
 *
 * HDMI Hot Plug Detect indication. You may need to mask or change polarity of this interrupt after
 * it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_HDP      (0)      //!< Bit position for HDMI_IH_PHY_STAT0_HDP.
#define BM_HDMI_IH_PHY_STAT0_HDP      (0x00000001)  //!< Bit mask for HDMI_IH_PHY_STAT0_HDP.

//! @brief Get value of HDMI_IH_PHY_STAT0_HDP from a register value.
#define BG_HDMI_IH_PHY_STAT0_HDP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_HDP) >> BP_HDMI_IH_PHY_STAT0_HDP)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_HDP.
#define BF_HDMI_IH_PHY_STAT0_HDP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_HDP) & BM_HDMI_IH_PHY_STAT0_HDP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HDP field to a new value.
#define BW_HDMI_IH_PHY_STAT0_HDP(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_HDP) | BF_HDMI_IH_PHY_STAT0_HDP(v)))
#endif
//@}

/*! @name Register HDMI_IH_PHY_STAT0, field TX_PHY_LOCK[1] (W1C)
 *
 * TX PHY PLL lock indication. Please refer to PHY datasheet for more information. You may need to
 * mask or change polarity of this interrupt after it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_TX_PHY_LOCK      (1)      //!< Bit position for HDMI_IH_PHY_STAT0_TX_PHY_LOCK.
#define BM_HDMI_IH_PHY_STAT0_TX_PHY_LOCK      (0x00000002)  //!< Bit mask for HDMI_IH_PHY_STAT0_TX_PHY_LOCK.

//! @brief Get value of HDMI_IH_PHY_STAT0_TX_PHY_LOCK from a register value.
#define BG_HDMI_IH_PHY_STAT0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_TX_PHY_LOCK) >> BP_HDMI_IH_PHY_STAT0_TX_PHY_LOCK)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_TX_PHY_LOCK.
#define BF_HDMI_IH_PHY_STAT0_TX_PHY_LOCK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_TX_PHY_LOCK) & BM_HDMI_IH_PHY_STAT0_TX_PHY_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_PHY_LOCK field to a new value.
#define BW_HDMI_IH_PHY_STAT0_TX_PHY_LOCK(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_TX_PHY_LOCK) | BF_HDMI_IH_PHY_STAT0_TX_PHY_LOCK(v)))
#endif
//@}

/*! @name Register HDMI_IH_PHY_STAT0, field RX_SENSE[2] (W1C)
 *
 * TX PHY RX_SENSE indication for driver 0. You may need to mask or change polarity of this
 * interrupt after it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_RX_SENSE      (2)      //!< Bit position for HDMI_IH_PHY_STAT0_RX_SENSE.
#define BM_HDMI_IH_PHY_STAT0_RX_SENSE      (0x00000004)  //!< Bit mask for HDMI_IH_PHY_STAT0_RX_SENSE.

//! @brief Get value of HDMI_IH_PHY_STAT0_RX_SENSE from a register value.
#define BG_HDMI_IH_PHY_STAT0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_RX_SENSE) >> BP_HDMI_IH_PHY_STAT0_RX_SENSE)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_RX_SENSE.
#define BF_HDMI_IH_PHY_STAT0_RX_SENSE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_RX_SENSE) & BM_HDMI_IH_PHY_STAT0_RX_SENSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE field to a new value.
#define BW_HDMI_IH_PHY_STAT0_RX_SENSE(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_RX_SENSE) | BF_HDMI_IH_PHY_STAT0_RX_SENSE(v)))
#endif
//@}

/*! @name Register HDMI_IH_PHY_STAT0, field RX_SENSE1[3] (W1C)
 *
 * TX PHY RX_SENSE indication for driver 1. You may need to mask or change polarity of this
 * interrupt after it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_RX_SENSE1      (3)      //!< Bit position for HDMI_IH_PHY_STAT0_RX_SENSE1.
#define BM_HDMI_IH_PHY_STAT0_RX_SENSE1      (0x00000008)  //!< Bit mask for HDMI_IH_PHY_STAT0_RX_SENSE1.

//! @brief Get value of HDMI_IH_PHY_STAT0_RX_SENSE1 from a register value.
#define BG_HDMI_IH_PHY_STAT0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_RX_SENSE1) >> BP_HDMI_IH_PHY_STAT0_RX_SENSE1)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_RX_SENSE1.
#define BF_HDMI_IH_PHY_STAT0_RX_SENSE1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_RX_SENSE1) & BM_HDMI_IH_PHY_STAT0_RX_SENSE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE1 field to a new value.
#define BW_HDMI_IH_PHY_STAT0_RX_SENSE1(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_RX_SENSE1) | BF_HDMI_IH_PHY_STAT0_RX_SENSE1(v)))
#endif
//@}

/*! @name Register HDMI_IH_PHY_STAT0, field RX_SENSE2[4] (W1C)
 *
 * TX PHY RX_SENSE indication for driver 2. You may need to mask or change polarity of this
 * interrupt after it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_RX_SENSE2      (4)      //!< Bit position for HDMI_IH_PHY_STAT0_RX_SENSE2.
#define BM_HDMI_IH_PHY_STAT0_RX_SENSE2      (0x00000010)  //!< Bit mask for HDMI_IH_PHY_STAT0_RX_SENSE2.

//! @brief Get value of HDMI_IH_PHY_STAT0_RX_SENSE2 from a register value.
#define BG_HDMI_IH_PHY_STAT0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_RX_SENSE2) >> BP_HDMI_IH_PHY_STAT0_RX_SENSE2)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_RX_SENSE2.
#define BF_HDMI_IH_PHY_STAT0_RX_SENSE2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_RX_SENSE2) & BM_HDMI_IH_PHY_STAT0_RX_SENSE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE2 field to a new value.
#define BW_HDMI_IH_PHY_STAT0_RX_SENSE2(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_RX_SENSE2) | BF_HDMI_IH_PHY_STAT0_RX_SENSE2(v)))
#endif
//@}

/*! @name Register HDMI_IH_PHY_STAT0, field RX_SENSE3[5] (W1C)
 *
 * TX PHY RX_SENSE indication for driver 3. You may need to mask or change polarity of this
 * interrupt after it has become active.
 */
//@{
#define BP_HDMI_IH_PHY_STAT0_RX_SENSE3      (5)      //!< Bit position for HDMI_IH_PHY_STAT0_RX_SENSE3.
#define BM_HDMI_IH_PHY_STAT0_RX_SENSE3      (0x00000020)  //!< Bit mask for HDMI_IH_PHY_STAT0_RX_SENSE3.

//! @brief Get value of HDMI_IH_PHY_STAT0_RX_SENSE3 from a register value.
#define BG_HDMI_IH_PHY_STAT0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_PHY_STAT0_RX_SENSE3) >> BP_HDMI_IH_PHY_STAT0_RX_SENSE3)

//! @brief Format value for bitfield HDMI_IH_PHY_STAT0_RX_SENSE3.
#define BF_HDMI_IH_PHY_STAT0_RX_SENSE3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_PHY_STAT0_RX_SENSE3) & BM_HDMI_IH_PHY_STAT0_RX_SENSE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE3 field to a new value.
#define BW_HDMI_IH_PHY_STAT0_RX_SENSE3(v)   (HW_HDMI_IH_PHY_STAT0_WR((HW_HDMI_IH_PHY_STAT0_RD() & ~BM_HDMI_IH_PHY_STAT0_RX_SENSE3) | BF_HDMI_IH_PHY_STAT0_RX_SENSE3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_I2CM_STAT0 - E-DDC I2C Master Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_I2CM_STAT0 - E-DDC I2C Master Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_i2cm_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_i2cm_stat0_bitfields
    {
        unsigned char I2CMASTER_ERROR : 1; //!< [0] I2C Master error indication
        unsigned char I2CMASTERDONE : 1; //!< [1] I2C Master done indication
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_i2cm_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_I2CM_STAT0 register
 */
//@{
#define HW_HDMI_IH_I2CM_STAT0_ADDR      (REGS_HDMI_BASE + 0x105)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_I2CM_STAT0           (*(volatile hw_hdmi_ih_i2cm_stat0_t *) HW_HDMI_IH_I2CM_STAT0_ADDR)
#define HW_HDMI_IH_I2CM_STAT0_RD()      (HW_HDMI_IH_I2CM_STAT0.U)
#define HW_HDMI_IH_I2CM_STAT0_WR(v)     (HW_HDMI_IH_I2CM_STAT0.U = (v))
#define HW_HDMI_IH_I2CM_STAT0_SET(v)    (HW_HDMI_IH_I2CM_STAT0_WR(HW_HDMI_IH_I2CM_STAT0_RD() |  (v)))
#define HW_HDMI_IH_I2CM_STAT0_CLR(v)    (HW_HDMI_IH_I2CM_STAT0_WR(HW_HDMI_IH_I2CM_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_I2CM_STAT0_TOG(v)    (HW_HDMI_IH_I2CM_STAT0_WR(HW_HDMI_IH_I2CM_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_I2CM_STAT0 bitfields
 */

/*! @name Register HDMI_IH_I2CM_STAT0, field I2CMASTER_ERROR[0] (W1C)
 *
 * I2C Master error indication
 */
//@{
#define BP_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR      (0)      //!< Bit position for HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR.
#define BM_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR      (0x00000001)  //!< Bit mask for HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR.

//! @brief Get value of HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR from a register value.
#define BG_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR) >> BP_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR)

//! @brief Format value for bitfield HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR.
#define BF_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR) & BM_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMASTER_ERROR field to a new value.
#define BW_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR(v)   (HW_HDMI_IH_I2CM_STAT0_WR((HW_HDMI_IH_I2CM_STAT0_RD() & ~BM_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR) | BF_HDMI_IH_I2CM_STAT0_I2CMASTER_ERROR(v)))
#endif
//@}

/*! @name Register HDMI_IH_I2CM_STAT0, field I2CMASTERDONE[1] (W1C)
 *
 * I2C Master done indication
 */
//@{
#define BP_HDMI_IH_I2CM_STAT0_I2CMASTERDONE      (1)      //!< Bit position for HDMI_IH_I2CM_STAT0_I2CMASTERDONE.
#define BM_HDMI_IH_I2CM_STAT0_I2CMASTERDONE      (0x00000002)  //!< Bit mask for HDMI_IH_I2CM_STAT0_I2CMASTERDONE.

//! @brief Get value of HDMI_IH_I2CM_STAT0_I2CMASTERDONE from a register value.
#define BG_HDMI_IH_I2CM_STAT0_I2CMASTERDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_I2CM_STAT0_I2CMASTERDONE) >> BP_HDMI_IH_I2CM_STAT0_I2CMASTERDONE)

//! @brief Format value for bitfield HDMI_IH_I2CM_STAT0_I2CMASTERDONE.
#define BF_HDMI_IH_I2CM_STAT0_I2CMASTERDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_I2CM_STAT0_I2CMASTERDONE) & BM_HDMI_IH_I2CM_STAT0_I2CMASTERDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMASTERDONE field to a new value.
#define BW_HDMI_IH_I2CM_STAT0_I2CMASTERDONE(v)   (HW_HDMI_IH_I2CM_STAT0_WR((HW_HDMI_IH_I2CM_STAT0_RD() & ~BM_HDMI_IH_I2CM_STAT0_I2CMASTERDONE) | BF_HDMI_IH_I2CM_STAT0_I2CMASTERDONE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_CEC_STAT0 - CEC Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_CEC_STAT0 - CEC Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_cec_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_cec_stat0_bitfields
    {
        unsigned char DONE : 1; //!< [0] CEC Done Indication
        unsigned char EOM : 1; //!< [1] CEC End of Message Indication
        unsigned char NACK : 1; //!< [2] CEC Nack indication
        unsigned char ARB_LOST : 1; //!< [3] CEC Arb_Lost indication
        unsigned char ERROR_INITIATOR : 1; //!< [4] CEC Error_follow indication
        unsigned char ERROR_FOLLOW : 1; //!< [5] CEC Error_follow indication
        unsigned char WAKEUP : 1; //!< [6] CEC Wake-up indication
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_ih_cec_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_CEC_STAT0 register
 */
//@{
#define HW_HDMI_IH_CEC_STAT0_ADDR      (REGS_HDMI_BASE + 0x106)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_CEC_STAT0           (*(volatile hw_hdmi_ih_cec_stat0_t *) HW_HDMI_IH_CEC_STAT0_ADDR)
#define HW_HDMI_IH_CEC_STAT0_RD()      (HW_HDMI_IH_CEC_STAT0.U)
#define HW_HDMI_IH_CEC_STAT0_WR(v)     (HW_HDMI_IH_CEC_STAT0.U = (v))
#define HW_HDMI_IH_CEC_STAT0_SET(v)    (HW_HDMI_IH_CEC_STAT0_WR(HW_HDMI_IH_CEC_STAT0_RD() |  (v)))
#define HW_HDMI_IH_CEC_STAT0_CLR(v)    (HW_HDMI_IH_CEC_STAT0_WR(HW_HDMI_IH_CEC_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_CEC_STAT0_TOG(v)    (HW_HDMI_IH_CEC_STAT0_WR(HW_HDMI_IH_CEC_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_CEC_STAT0 bitfields
 */

/*! @name Register HDMI_IH_CEC_STAT0, field DONE[0] (W1C)
 *
 * CEC Done Indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_DONE      (0)      //!< Bit position for HDMI_IH_CEC_STAT0_DONE.
#define BM_HDMI_IH_CEC_STAT0_DONE      (0x00000001)  //!< Bit mask for HDMI_IH_CEC_STAT0_DONE.

//! @brief Get value of HDMI_IH_CEC_STAT0_DONE from a register value.
#define BG_HDMI_IH_CEC_STAT0_DONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_DONE) >> BP_HDMI_IH_CEC_STAT0_DONE)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_DONE.
#define BF_HDMI_IH_CEC_STAT0_DONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_DONE) & BM_HDMI_IH_CEC_STAT0_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE field to a new value.
#define BW_HDMI_IH_CEC_STAT0_DONE(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_DONE) | BF_HDMI_IH_CEC_STAT0_DONE(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field EOM[1] (W1C)
 *
 * CEC End of Message Indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_EOM      (1)      //!< Bit position for HDMI_IH_CEC_STAT0_EOM.
#define BM_HDMI_IH_CEC_STAT0_EOM      (0x00000002)  //!< Bit mask for HDMI_IH_CEC_STAT0_EOM.

//! @brief Get value of HDMI_IH_CEC_STAT0_EOM from a register value.
#define BG_HDMI_IH_CEC_STAT0_EOM(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_EOM) >> BP_HDMI_IH_CEC_STAT0_EOM)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_EOM.
#define BF_HDMI_IH_CEC_STAT0_EOM(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_EOM) & BM_HDMI_IH_CEC_STAT0_EOM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EOM field to a new value.
#define BW_HDMI_IH_CEC_STAT0_EOM(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_EOM) | BF_HDMI_IH_CEC_STAT0_EOM(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field NACK[2] (W1C)
 *
 * CEC Nack indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_NACK      (2)      //!< Bit position for HDMI_IH_CEC_STAT0_NACK.
#define BM_HDMI_IH_CEC_STAT0_NACK      (0x00000004)  //!< Bit mask for HDMI_IH_CEC_STAT0_NACK.

//! @brief Get value of HDMI_IH_CEC_STAT0_NACK from a register value.
#define BG_HDMI_IH_CEC_STAT0_NACK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_NACK) >> BP_HDMI_IH_CEC_STAT0_NACK)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_NACK.
#define BF_HDMI_IH_CEC_STAT0_NACK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_NACK) & BM_HDMI_IH_CEC_STAT0_NACK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK field to a new value.
#define BW_HDMI_IH_CEC_STAT0_NACK(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_NACK) | BF_HDMI_IH_CEC_STAT0_NACK(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field ARB_LOST[3] (W1C)
 *
 * CEC Arb_Lost indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_ARB_LOST      (3)      //!< Bit position for HDMI_IH_CEC_STAT0_ARB_LOST.
#define BM_HDMI_IH_CEC_STAT0_ARB_LOST      (0x00000008)  //!< Bit mask for HDMI_IH_CEC_STAT0_ARB_LOST.

//! @brief Get value of HDMI_IH_CEC_STAT0_ARB_LOST from a register value.
#define BG_HDMI_IH_CEC_STAT0_ARB_LOST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_ARB_LOST) >> BP_HDMI_IH_CEC_STAT0_ARB_LOST)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_ARB_LOST.
#define BF_HDMI_IH_CEC_STAT0_ARB_LOST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_ARB_LOST) & BM_HDMI_IH_CEC_STAT0_ARB_LOST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARB_LOST field to a new value.
#define BW_HDMI_IH_CEC_STAT0_ARB_LOST(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_ARB_LOST) | BF_HDMI_IH_CEC_STAT0_ARB_LOST(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field ERROR_INITIATOR[4] (W1C)
 *
 * CEC Error_follow indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_ERROR_INITIATOR      (4)      //!< Bit position for HDMI_IH_CEC_STAT0_ERROR_INITIATOR.
#define BM_HDMI_IH_CEC_STAT0_ERROR_INITIATOR      (0x00000010)  //!< Bit mask for HDMI_IH_CEC_STAT0_ERROR_INITIATOR.

//! @brief Get value of HDMI_IH_CEC_STAT0_ERROR_INITIATOR from a register value.
#define BG_HDMI_IH_CEC_STAT0_ERROR_INITIATOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_ERROR_INITIATOR) >> BP_HDMI_IH_CEC_STAT0_ERROR_INITIATOR)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_ERROR_INITIATOR.
#define BF_HDMI_IH_CEC_STAT0_ERROR_INITIATOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_ERROR_INITIATOR) & BM_HDMI_IH_CEC_STAT0_ERROR_INITIATOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_INITIATOR field to a new value.
#define BW_HDMI_IH_CEC_STAT0_ERROR_INITIATOR(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_ERROR_INITIATOR) | BF_HDMI_IH_CEC_STAT0_ERROR_INITIATOR(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field ERROR_FOLLOW[5] (W1C)
 *
 * CEC Error_follow indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_ERROR_FOLLOW      (5)      //!< Bit position for HDMI_IH_CEC_STAT0_ERROR_FOLLOW.
#define BM_HDMI_IH_CEC_STAT0_ERROR_FOLLOW      (0x00000020)  //!< Bit mask for HDMI_IH_CEC_STAT0_ERROR_FOLLOW.

//! @brief Get value of HDMI_IH_CEC_STAT0_ERROR_FOLLOW from a register value.
#define BG_HDMI_IH_CEC_STAT0_ERROR_FOLLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_ERROR_FOLLOW) >> BP_HDMI_IH_CEC_STAT0_ERROR_FOLLOW)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_ERROR_FOLLOW.
#define BF_HDMI_IH_CEC_STAT0_ERROR_FOLLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_ERROR_FOLLOW) & BM_HDMI_IH_CEC_STAT0_ERROR_FOLLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_FOLLOW field to a new value.
#define BW_HDMI_IH_CEC_STAT0_ERROR_FOLLOW(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_ERROR_FOLLOW) | BF_HDMI_IH_CEC_STAT0_ERROR_FOLLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_CEC_STAT0, field WAKEUP[6] (W1C)
 *
 * CEC Wake-up indication
 */
//@{
#define BP_HDMI_IH_CEC_STAT0_WAKEUP      (6)      //!< Bit position for HDMI_IH_CEC_STAT0_WAKEUP.
#define BM_HDMI_IH_CEC_STAT0_WAKEUP      (0x00000040)  //!< Bit mask for HDMI_IH_CEC_STAT0_WAKEUP.

//! @brief Get value of HDMI_IH_CEC_STAT0_WAKEUP from a register value.
#define BG_HDMI_IH_CEC_STAT0_WAKEUP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_CEC_STAT0_WAKEUP) >> BP_HDMI_IH_CEC_STAT0_WAKEUP)

//! @brief Format value for bitfield HDMI_IH_CEC_STAT0_WAKEUP.
#define BF_HDMI_IH_CEC_STAT0_WAKEUP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_CEC_STAT0_WAKEUP) & BM_HDMI_IH_CEC_STAT0_WAKEUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKEUP field to a new value.
#define BW_HDMI_IH_CEC_STAT0_WAKEUP(v)   (HW_HDMI_IH_CEC_STAT0_WR((HW_HDMI_IH_CEC_STAT0_RD() & ~BM_HDMI_IH_CEC_STAT0_WAKEUP) | BF_HDMI_IH_CEC_STAT0_WAKEUP(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_VP_STAT0 - Video Packetizer Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_VP_STAT0 - Video Packetizer Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_vp_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_vp_stat0_bitfields
    {
        unsigned char FIFOEMPTYBYP : 1; //!< [0] Video packetizer 8-bit bypass fifo empty interrupt
        unsigned char FIFOFULLBYP : 1; //!< [1] Video packetizer 8-bit bypass fifo full interrupt
        unsigned char FIFOEMPTYREMAP : 1; //!< [2] Video packetizer pixel YCC 422 re-mapper FIFO empty interrupt
        unsigned char FIFOFULLREMAP : 1; //!< [3] Video packetizer pixel YCC 422 re-mapper FIFO full interrupt
        unsigned char FIFOEMPTYPP : 1; //!< [4] Video packetizer pixel packing FIFO empty interrupt
        unsigned char FIFOFULLPP : 1; //!< [5] Video packetizer pixel packing FIFO full interrupt
        unsigned char FIFOEMPTYREPET : 1; //!< [6] Video packetizer pixel repeater FIFO empty interrupt
        unsigned char FIFOFULLREPET : 1; //!< [7] Video packetizer pixel repeater FIFO full interrupt
    } B;
} hw_hdmi_ih_vp_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_VP_STAT0 register
 */
//@{
#define HW_HDMI_IH_VP_STAT0_ADDR      (REGS_HDMI_BASE + 0x107)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_VP_STAT0           (*(volatile hw_hdmi_ih_vp_stat0_t *) HW_HDMI_IH_VP_STAT0_ADDR)
#define HW_HDMI_IH_VP_STAT0_RD()      (HW_HDMI_IH_VP_STAT0.U)
#define HW_HDMI_IH_VP_STAT0_WR(v)     (HW_HDMI_IH_VP_STAT0.U = (v))
#define HW_HDMI_IH_VP_STAT0_SET(v)    (HW_HDMI_IH_VP_STAT0_WR(HW_HDMI_IH_VP_STAT0_RD() |  (v)))
#define HW_HDMI_IH_VP_STAT0_CLR(v)    (HW_HDMI_IH_VP_STAT0_WR(HW_HDMI_IH_VP_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_VP_STAT0_TOG(v)    (HW_HDMI_IH_VP_STAT0_WR(HW_HDMI_IH_VP_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_VP_STAT0 bitfields
 */

/*! @name Register HDMI_IH_VP_STAT0, field FIFOEMPTYBYP[0] (W1C)
 *
 * Video packetizer 8-bit bypass fifo empty interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOEMPTYBYP      (0)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOEMPTYBYP.
#define BM_HDMI_IH_VP_STAT0_FIFOEMPTYBYP      (0x00000001)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOEMPTYBYP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOEMPTYBYP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOEMPTYBYP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYBYP) >> BP_HDMI_IH_VP_STAT0_FIFOEMPTYBYP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOEMPTYBYP.
#define BF_HDMI_IH_VP_STAT0_FIFOEMPTYBYP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOEMPTYBYP) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYBYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYBYP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOEMPTYBYP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOEMPTYBYP) | BF_HDMI_IH_VP_STAT0_FIFOEMPTYBYP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOFULLBYP[1] (W1C)
 *
 * Video packetizer 8-bit bypass fifo full interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOFULLBYP      (1)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOFULLBYP.
#define BM_HDMI_IH_VP_STAT0_FIFOFULLBYP      (0x00000002)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOFULLBYP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOFULLBYP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOFULLBYP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOFULLBYP) >> BP_HDMI_IH_VP_STAT0_FIFOFULLBYP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOFULLBYP.
#define BF_HDMI_IH_VP_STAT0_FIFOFULLBYP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOFULLBYP) & BM_HDMI_IH_VP_STAT0_FIFOFULLBYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLBYP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOFULLBYP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOFULLBYP) | BF_HDMI_IH_VP_STAT0_FIFOFULLBYP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOEMPTYREMAP[2] (W1C)
 *
 * Video packetizer pixel YCC 422 re-mapper FIFO empty interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP      (2)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOEMPTYREMAP.
#define BM_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP      (0x00000004)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOEMPTYREMAP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOEMPTYREMAP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP) >> BP_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOEMPTYREMAP.
#define BF_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYREMAP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP) | BF_HDMI_IH_VP_STAT0_FIFOEMPTYREMAP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOFULLREMAP[3] (W1C)
 *
 * Video packetizer pixel YCC 422 re-mapper FIFO full interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOFULLREMAP      (3)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOFULLREMAP.
#define BM_HDMI_IH_VP_STAT0_FIFOFULLREMAP      (0x00000008)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOFULLREMAP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOFULLREMAP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOFULLREMAP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOFULLREMAP) >> BP_HDMI_IH_VP_STAT0_FIFOFULLREMAP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOFULLREMAP.
#define BF_HDMI_IH_VP_STAT0_FIFOFULLREMAP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOFULLREMAP) & BM_HDMI_IH_VP_STAT0_FIFOFULLREMAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLREMAP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOFULLREMAP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOFULLREMAP) | BF_HDMI_IH_VP_STAT0_FIFOFULLREMAP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOEMPTYPP[4] (W1C)
 *
 * Video packetizer pixel packing FIFO empty interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOEMPTYPP      (4)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOEMPTYPP.
#define BM_HDMI_IH_VP_STAT0_FIFOEMPTYPP      (0x00000010)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOEMPTYPP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOEMPTYPP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOEMPTYPP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYPP) >> BP_HDMI_IH_VP_STAT0_FIFOEMPTYPP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOEMPTYPP.
#define BF_HDMI_IH_VP_STAT0_FIFOEMPTYPP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOEMPTYPP) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYPP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYPP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOEMPTYPP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOEMPTYPP) | BF_HDMI_IH_VP_STAT0_FIFOEMPTYPP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOFULLPP[5] (W1C)
 *
 * Video packetizer pixel packing FIFO full interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOFULLPP      (5)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOFULLPP.
#define BM_HDMI_IH_VP_STAT0_FIFOFULLPP      (0x00000020)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOFULLPP.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOFULLPP from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOFULLPP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOFULLPP) >> BP_HDMI_IH_VP_STAT0_FIFOFULLPP)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOFULLPP.
#define BF_HDMI_IH_VP_STAT0_FIFOFULLPP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOFULLPP) & BM_HDMI_IH_VP_STAT0_FIFOFULLPP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLPP field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOFULLPP(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOFULLPP) | BF_HDMI_IH_VP_STAT0_FIFOFULLPP(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOEMPTYREPET[6] (W1C)
 *
 * Video packetizer pixel repeater FIFO empty interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOEMPTYREPET      (6)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOEMPTYREPET.
#define BM_HDMI_IH_VP_STAT0_FIFOEMPTYREPET      (0x00000040)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOEMPTYREPET.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOEMPTYREPET from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOEMPTYREPET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYREPET) >> BP_HDMI_IH_VP_STAT0_FIFOEMPTYREPET)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOEMPTYREPET.
#define BF_HDMI_IH_VP_STAT0_FIFOEMPTYREPET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOEMPTYREPET) & BM_HDMI_IH_VP_STAT0_FIFOEMPTYREPET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYREPET field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOEMPTYREPET(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOEMPTYREPET) | BF_HDMI_IH_VP_STAT0_FIFOEMPTYREPET(v)))
#endif
//@}

/*! @name Register HDMI_IH_VP_STAT0, field FIFOFULLREPET[7] (W1C)
 *
 * Video packetizer pixel repeater FIFO full interrupt
 */
//@{
#define BP_HDMI_IH_VP_STAT0_FIFOFULLREPET      (7)      //!< Bit position for HDMI_IH_VP_STAT0_FIFOFULLREPET.
#define BM_HDMI_IH_VP_STAT0_FIFOFULLREPET      (0x00000080)  //!< Bit mask for HDMI_IH_VP_STAT0_FIFOFULLREPET.

//! @brief Get value of HDMI_IH_VP_STAT0_FIFOFULLREPET from a register value.
#define BG_HDMI_IH_VP_STAT0_FIFOFULLREPET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_VP_STAT0_FIFOFULLREPET) >> BP_HDMI_IH_VP_STAT0_FIFOFULLREPET)

//! @brief Format value for bitfield HDMI_IH_VP_STAT0_FIFOFULLREPET.
#define BF_HDMI_IH_VP_STAT0_FIFOFULLREPET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_VP_STAT0_FIFOFULLREPET) & BM_HDMI_IH_VP_STAT0_FIFOFULLREPET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLREPET field to a new value.
#define BW_HDMI_IH_VP_STAT0_FIFOFULLREPET(v)   (HW_HDMI_IH_VP_STAT0_WR((HW_HDMI_IH_VP_STAT0_RD() & ~BM_HDMI_IH_VP_STAT0_FIFOFULLREPET) | BF_HDMI_IH_VP_STAT0_FIFOFULLREPET(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_I2CMPHY_STAT0 - PHY GEN2 I2C Master Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_I2CMPHY_STAT0 - PHY GEN2 I2C Master Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 *
 * This clear on write (1 to corresponding bit) register contains the following active high sticky
 * bit interrupts. That I2C Master PHY is the I2C Master block used to access the PHY I2C Slave.
 */
typedef union _hw_hdmi_ih_i2cmphy_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_i2cmphy_stat0_bitfields
    {
        unsigned char I2CMPHYERROR : 1; //!< [0] I2C Master PHY error indication
        unsigned char I2CMPHYDONE : 1; //!< [1] I2C Master PHY done indication
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_i2cmphy_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_I2CMPHY_STAT0 register
 */
//@{
#define HW_HDMI_IH_I2CMPHY_STAT0_ADDR      (REGS_HDMI_BASE + 0x108)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_I2CMPHY_STAT0           (*(volatile hw_hdmi_ih_i2cmphy_stat0_t *) HW_HDMI_IH_I2CMPHY_STAT0_ADDR)
#define HW_HDMI_IH_I2CMPHY_STAT0_RD()      (HW_HDMI_IH_I2CMPHY_STAT0.U)
#define HW_HDMI_IH_I2CMPHY_STAT0_WR(v)     (HW_HDMI_IH_I2CMPHY_STAT0.U = (v))
#define HW_HDMI_IH_I2CMPHY_STAT0_SET(v)    (HW_HDMI_IH_I2CMPHY_STAT0_WR(HW_HDMI_IH_I2CMPHY_STAT0_RD() |  (v)))
#define HW_HDMI_IH_I2CMPHY_STAT0_CLR(v)    (HW_HDMI_IH_I2CMPHY_STAT0_WR(HW_HDMI_IH_I2CMPHY_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_I2CMPHY_STAT0_TOG(v)    (HW_HDMI_IH_I2CMPHY_STAT0_WR(HW_HDMI_IH_I2CMPHY_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_I2CMPHY_STAT0 bitfields
 */

/*! @name Register HDMI_IH_I2CMPHY_STAT0, field I2CMPHYERROR[0] (W1C)
 *
 * I2C Master PHY error indication
 */
//@{
#define BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR      (0)      //!< Bit position for HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR.
#define BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR      (0x00000001)  //!< Bit mask for HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR.

//! @brief Get value of HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR from a register value.
#define BG_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR) >> BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR)

//! @brief Format value for bitfield HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR.
#define BF_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR) & BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMPHYERROR field to a new value.
#define BW_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR(v)   (HW_HDMI_IH_I2CMPHY_STAT0_WR((HW_HDMI_IH_I2CMPHY_STAT0_RD() & ~BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR) | BF_HDMI_IH_I2CMPHY_STAT0_I2CMPHYERROR(v)))
#endif
//@}

/*! @name Register HDMI_IH_I2CMPHY_STAT0, field I2CMPHYDONE[1] (W1C)
 *
 * I2C Master PHY done indication
 */
//@{
#define BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE      (1)      //!< Bit position for HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE.
#define BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE      (0x00000002)  //!< Bit mask for HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE.

//! @brief Get value of HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE from a register value.
#define BG_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE) >> BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE)

//! @brief Format value for bitfield HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE.
#define BF_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE) & BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMPHYDONE field to a new value.
#define BW_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE(v)   (HW_HDMI_IH_I2CMPHY_STAT0_WR((HW_HDMI_IH_I2CMPHY_STAT0_RD() & ~BM_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE) | BF_HDMI_IH_I2CMPHY_STAT0_I2CMPHYDONE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Status Register (W1C)
 *
 * Reset value: 0x00
 *
 * Address Offset: 0x0109 Size: 8 bits Value after Reset: 0x00 Access: Read/Clear on Write
 */
typedef union _hw_hdmi_ih_ahbdmaaud_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_ahbdmaaud_stat0_bitfields
    {
        unsigned char AHBDMAAUD_INTBUFFEMPTY : 1; //!< [0] AHB audio DMA Buffer empty interrupt
        unsigned char AHBDMAAUD_INTBUFFFULL : 1; //!< [1] AHB audio DMA Buffer full interrupt
        unsigned char AHBDMAAUD_INTDONE : 1; //!< [2] AHB audio DMA done interrupt
        unsigned char AHBDMAAUD_INTRETRYSPLIT : 1; //!< [3] AHB audio DMA RETRY/SPLIT interrupt
        unsigned char AHBDMAAUD_INTLOSTOWNERSHIP : 1; //!< [4] AHB audio DMA lost ownership interrupt
        unsigned char AHBDMAAUD_INTERROR : 1; //!< [5] AHB audio DMA error interrupt
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_ih_ahbdmaaud_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_AHBDMAAUD_STAT0 register
 */
//@{
#define HW_HDMI_IH_AHBDMAAUD_STAT0_ADDR      (REGS_HDMI_BASE + 0x109)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_AHBDMAAUD_STAT0           (*(volatile hw_hdmi_ih_ahbdmaaud_stat0_t *) HW_HDMI_IH_AHBDMAAUD_STAT0_ADDR)
#define HW_HDMI_IH_AHBDMAAUD_STAT0_RD()      (HW_HDMI_IH_AHBDMAAUD_STAT0.U)
#define HW_HDMI_IH_AHBDMAAUD_STAT0_WR(v)     (HW_HDMI_IH_AHBDMAAUD_STAT0.U = (v))
#define HW_HDMI_IH_AHBDMAAUD_STAT0_SET(v)    (HW_HDMI_IH_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_AHBDMAAUD_STAT0_RD() |  (v)))
#define HW_HDMI_IH_AHBDMAAUD_STAT0_CLR(v)    (HW_HDMI_IH_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_AHBDMAAUD_STAT0_TOG(v)    (HW_HDMI_IH_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_AHBDMAAUD_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_AHBDMAAUD_STAT0 bitfields
 */

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTBUFFEMPTY[0] (W1C)
 *
 * AHB audio DMA Buffer empty interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY      (0)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY      (0x00000001)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFEMPTY field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)))
#endif
//@}

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTBUFFFULL[1] (W1C)
 *
 * AHB audio DMA Buffer full interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL      (1)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL      (0x00000002)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFFULL field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)))
#endif
//@}

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTDONE[2] (W1C)
 *
 * AHB audio DMA done interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE      (2)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE      (0x00000004)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTDONE field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)))
#endif
//@}

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTRETRYSPLIT[3] (W1C)
 *
 * AHB audio DMA RETRY/SPLIT interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT      (3)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT      (0x00000008)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTRETRYSPLIT field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)))
#endif
//@}

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTLOSTOWNERSHIP[4] (W1C)
 *
 * AHB audio DMA lost ownership interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP      (4)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP      (0x00000010)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTLOSTOWNERSHIP field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)))
#endif
//@}

/*! @name Register HDMI_IH_AHBDMAAUD_STAT0, field AHBDMAAUD_INTERROR[5] (W1C)
 *
 * AHB audio DMA error interrupt
 */
//@{
#define BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR      (5)      //!< Bit position for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.
#define BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR      (0x00000020)  //!< Bit mask for HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.

//! @brief Get value of HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR from a register value.
#define BG_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) >> BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR)

//! @brief Format value for bitfield HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.
#define BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) & BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTERROR field to a new value.
#define BW_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)   (HW_HDMI_IH_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) | BF_HDMI_IH_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_FC_STAT0 - Frame Composer Interrupt Mute Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_FC_STAT0 - Frame Composer Interrupt Mute Control Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_fc_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_fc_stat0_bitfields
    {
        unsigned char NULL_ : 1; //!< [0] When set to 1, mutes IH_ FC_STAT0[0]
        unsigned char ACR : 1; //!< [1] When set to 1, mutes IH_ FC_STAT0[1]
        unsigned char AUDS : 1; //!< [2] When set to 1, mutes IH_ FC_STAT0[2]
        unsigned char OBA : 1; //!< [3] When set to 1, mutes IH_ FC_STAT0[3]
        unsigned char DST : 1; //!< [4] When set to 1, mutes IH_ FC_STAT0[4]
        unsigned char HBR : 1; //!< [5] When set to 1, mutes IH_ FC_STAT0[5]
        unsigned char ACP : 1; //!< [6] When set to 1, mutes IH_ FC_STAT0[6]
        unsigned char AUDI : 1; //!< [7] When set to 1, mutes IH_ FC_STAT0[7]
    } B;
} hw_hdmi_ih_mute_fc_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_FC_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_FC_STAT0_ADDR      (REGS_HDMI_BASE + 0x180)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_FC_STAT0           (*(volatile hw_hdmi_ih_mute_fc_stat0_t *) HW_HDMI_IH_MUTE_FC_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_FC_STAT0_RD()      (HW_HDMI_IH_MUTE_FC_STAT0.U)
#define HW_HDMI_IH_MUTE_FC_STAT0_WR(v)     (HW_HDMI_IH_MUTE_FC_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_FC_STAT0_SET(v)    (HW_HDMI_IH_MUTE_FC_STAT0_WR(HW_HDMI_IH_MUTE_FC_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_FC_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_FC_STAT0_WR(HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_FC_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_FC_STAT0_WR(HW_HDMI_IH_MUTE_FC_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_FC_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field NULL_[0] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_NULL_      (0)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_NULL_.
#define BM_HDMI_IH_MUTE_FC_STAT0_NULL_      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_NULL_.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_NULL_ from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_NULL_(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_NULL_) >> BP_HDMI_IH_MUTE_FC_STAT0_NULL_)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_NULL_.
#define BF_HDMI_IH_MUTE_FC_STAT0_NULL_(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_NULL_) & BM_HDMI_IH_MUTE_FC_STAT0_NULL_)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NULL_ field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_NULL_(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_NULL_) | BF_HDMI_IH_MUTE_FC_STAT0_NULL_(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field ACR[1] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_ACR      (1)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_ACR.
#define BM_HDMI_IH_MUTE_FC_STAT0_ACR      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_ACR.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_ACR from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_ACR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_ACR) >> BP_HDMI_IH_MUTE_FC_STAT0_ACR)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_ACR.
#define BF_HDMI_IH_MUTE_FC_STAT0_ACR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_ACR) & BM_HDMI_IH_MUTE_FC_STAT0_ACR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACR field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_ACR(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_ACR) | BF_HDMI_IH_MUTE_FC_STAT0_ACR(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field AUDS[2] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_AUDS      (2)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_AUDS.
#define BM_HDMI_IH_MUTE_FC_STAT0_AUDS      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_AUDS.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_AUDS from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_AUDS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_AUDS) >> BP_HDMI_IH_MUTE_FC_STAT0_AUDS)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_AUDS.
#define BF_HDMI_IH_MUTE_FC_STAT0_AUDS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_AUDS) & BM_HDMI_IH_MUTE_FC_STAT0_AUDS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDS field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_AUDS(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_AUDS) | BF_HDMI_IH_MUTE_FC_STAT0_AUDS(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field OBA[3] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_OBA      (3)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_OBA.
#define BM_HDMI_IH_MUTE_FC_STAT0_OBA      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_OBA.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_OBA from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_OBA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_OBA) >> BP_HDMI_IH_MUTE_FC_STAT0_OBA)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_OBA.
#define BF_HDMI_IH_MUTE_FC_STAT0_OBA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_OBA) & BM_HDMI_IH_MUTE_FC_STAT0_OBA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OBA field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_OBA(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_OBA) | BF_HDMI_IH_MUTE_FC_STAT0_OBA(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field DST[4] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_DST      (4)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_DST.
#define BM_HDMI_IH_MUTE_FC_STAT0_DST      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_DST.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_DST from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_DST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_DST) >> BP_HDMI_IH_MUTE_FC_STAT0_DST)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_DST.
#define BF_HDMI_IH_MUTE_FC_STAT0_DST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_DST) & BM_HDMI_IH_MUTE_FC_STAT0_DST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DST field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_DST(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_DST) | BF_HDMI_IH_MUTE_FC_STAT0_DST(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field HBR[5] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_HBR      (5)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_HBR.
#define BM_HDMI_IH_MUTE_FC_STAT0_HBR      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_HBR.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_HBR from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_HBR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_HBR) >> BP_HDMI_IH_MUTE_FC_STAT0_HBR)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_HBR.
#define BF_HDMI_IH_MUTE_FC_STAT0_HBR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_HBR) & BM_HDMI_IH_MUTE_FC_STAT0_HBR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HBR field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_HBR(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_HBR) | BF_HDMI_IH_MUTE_FC_STAT0_HBR(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field ACP[6] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[6]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_ACP      (6)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_ACP.
#define BM_HDMI_IH_MUTE_FC_STAT0_ACP      (0x00000040)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_ACP.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_ACP from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_ACP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_ACP) >> BP_HDMI_IH_MUTE_FC_STAT0_ACP)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_ACP.
#define BF_HDMI_IH_MUTE_FC_STAT0_ACP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_ACP) & BM_HDMI_IH_MUTE_FC_STAT0_ACP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACP field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_ACP(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_ACP) | BF_HDMI_IH_MUTE_FC_STAT0_ACP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT0, field AUDI[7] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT0[7]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT0_AUDI      (7)      //!< Bit position for HDMI_IH_MUTE_FC_STAT0_AUDI.
#define BM_HDMI_IH_MUTE_FC_STAT0_AUDI      (0x00000080)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT0_AUDI.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT0_AUDI from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT0_AUDI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT0_AUDI) >> BP_HDMI_IH_MUTE_FC_STAT0_AUDI)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT0_AUDI.
#define BF_HDMI_IH_MUTE_FC_STAT0_AUDI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT0_AUDI) & BM_HDMI_IH_MUTE_FC_STAT0_AUDI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDI field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT0_AUDI(v)   (HW_HDMI_IH_MUTE_FC_STAT0_WR((HW_HDMI_IH_MUTE_FC_STAT0_RD() & ~BM_HDMI_IH_MUTE_FC_STAT0_AUDI) | BF_HDMI_IH_MUTE_FC_STAT0_AUDI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_FC_STAT1 - Frame Composer Interrupt Mute Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_FC_STAT1 - Frame Composer Interrupt Mute Control Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_fc_stat1
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_fc_stat1_bitfields
    {
        unsigned char GCP : 1; //!< [0] When set to 1, mutes IH_ FC_STAT1[0]
        unsigned char AVI : 1; //!< [1] When set to 1, mutes IH_ FC_STAT1[1]
        unsigned char MPEG : 1; //!< [2] When set to 1, mutes IH_ FC_STAT1[2]
        unsigned char SPD : 1; //!< [3] When set to 1, mutes IH_ FC_STAT1[3]
        unsigned char VSD : 1; //!< [4] When set to 1, mutes IH_ FC_STAT1[4]
        unsigned char ISCR2 : 1; //!< [5] When set to 1, mutes IH_ FC_STAT1[5]
        unsigned char ISCR1 : 1; //!< [6] When set to 1, mutes IH_ FC_STAT1[6]
        unsigned char GMD : 1; //!< [7] When set to 1, mutes IH_ FC_STAT1[7]
    } B;
} hw_hdmi_ih_mute_fc_stat1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_FC_STAT1 register
 */
//@{
#define HW_HDMI_IH_MUTE_FC_STAT1_ADDR      (REGS_HDMI_BASE + 0x181)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_FC_STAT1           (*(volatile hw_hdmi_ih_mute_fc_stat1_t *) HW_HDMI_IH_MUTE_FC_STAT1_ADDR)
#define HW_HDMI_IH_MUTE_FC_STAT1_RD()      (HW_HDMI_IH_MUTE_FC_STAT1.U)
#define HW_HDMI_IH_MUTE_FC_STAT1_WR(v)     (HW_HDMI_IH_MUTE_FC_STAT1.U = (v))
#define HW_HDMI_IH_MUTE_FC_STAT1_SET(v)    (HW_HDMI_IH_MUTE_FC_STAT1_WR(HW_HDMI_IH_MUTE_FC_STAT1_RD() |  (v)))
#define HW_HDMI_IH_MUTE_FC_STAT1_CLR(v)    (HW_HDMI_IH_MUTE_FC_STAT1_WR(HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_FC_STAT1_TOG(v)    (HW_HDMI_IH_MUTE_FC_STAT1_WR(HW_HDMI_IH_MUTE_FC_STAT1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_FC_STAT1 bitfields
 */

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field GCP[0] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[0]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_GCP      (0)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_GCP.
#define BM_HDMI_IH_MUTE_FC_STAT1_GCP      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_GCP.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_GCP from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_GCP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_GCP) >> BP_HDMI_IH_MUTE_FC_STAT1_GCP)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_GCP.
#define BF_HDMI_IH_MUTE_FC_STAT1_GCP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_GCP) & BM_HDMI_IH_MUTE_FC_STAT1_GCP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCP field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_GCP(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_GCP) | BF_HDMI_IH_MUTE_FC_STAT1_GCP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field AVI[1] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[1]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_AVI      (1)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_AVI.
#define BM_HDMI_IH_MUTE_FC_STAT1_AVI      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_AVI.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_AVI from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_AVI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_AVI) >> BP_HDMI_IH_MUTE_FC_STAT1_AVI)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_AVI.
#define BF_HDMI_IH_MUTE_FC_STAT1_AVI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_AVI) & BM_HDMI_IH_MUTE_FC_STAT1_AVI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVI field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_AVI(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_AVI) | BF_HDMI_IH_MUTE_FC_STAT1_AVI(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field MPEG[2] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[2]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_MPEG      (2)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_MPEG.
#define BM_HDMI_IH_MUTE_FC_STAT1_MPEG      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_MPEG.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_MPEG from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_MPEG(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_MPEG) >> BP_HDMI_IH_MUTE_FC_STAT1_MPEG)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_MPEG.
#define BF_HDMI_IH_MUTE_FC_STAT1_MPEG(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_MPEG) & BM_HDMI_IH_MUTE_FC_STAT1_MPEG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPEG field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_MPEG(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_MPEG) | BF_HDMI_IH_MUTE_FC_STAT1_MPEG(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field SPD[3] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[3]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_SPD      (3)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_SPD.
#define BM_HDMI_IH_MUTE_FC_STAT1_SPD      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_SPD.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_SPD from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_SPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_SPD) >> BP_HDMI_IH_MUTE_FC_STAT1_SPD)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_SPD.
#define BF_HDMI_IH_MUTE_FC_STAT1_SPD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_SPD) & BM_HDMI_IH_MUTE_FC_STAT1_SPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPD field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_SPD(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_SPD) | BF_HDMI_IH_MUTE_FC_STAT1_SPD(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field VSD[4] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[4]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_VSD      (4)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_VSD.
#define BM_HDMI_IH_MUTE_FC_STAT1_VSD      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_VSD.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_VSD from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_VSD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_VSD) >> BP_HDMI_IH_MUTE_FC_STAT1_VSD)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_VSD.
#define BF_HDMI_IH_MUTE_FC_STAT1_VSD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_VSD) & BM_HDMI_IH_MUTE_FC_STAT1_VSD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSD field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_VSD(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_VSD) | BF_HDMI_IH_MUTE_FC_STAT1_VSD(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field ISCR2[5] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[5]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_ISCR2      (5)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_ISCR2.
#define BM_HDMI_IH_MUTE_FC_STAT1_ISCR2      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_ISCR2.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_ISCR2 from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_ISCR2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_ISCR2) >> BP_HDMI_IH_MUTE_FC_STAT1_ISCR2)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_ISCR2.
#define BF_HDMI_IH_MUTE_FC_STAT1_ISCR2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_ISCR2) & BM_HDMI_IH_MUTE_FC_STAT1_ISCR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR2 field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_ISCR2(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_ISCR2) | BF_HDMI_IH_MUTE_FC_STAT1_ISCR2(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field ISCR1[6] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[6]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_ISCR1      (6)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_ISCR1.
#define BM_HDMI_IH_MUTE_FC_STAT1_ISCR1      (0x00000040)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_ISCR1.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_ISCR1 from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_ISCR1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_ISCR1) >> BP_HDMI_IH_MUTE_FC_STAT1_ISCR1)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_ISCR1.
#define BF_HDMI_IH_MUTE_FC_STAT1_ISCR1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_ISCR1) & BM_HDMI_IH_MUTE_FC_STAT1_ISCR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR1 field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_ISCR1(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_ISCR1) | BF_HDMI_IH_MUTE_FC_STAT1_ISCR1(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT1, field GMD[7] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT1[7]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT1_GMD      (7)      //!< Bit position for HDMI_IH_MUTE_FC_STAT1_GMD.
#define BM_HDMI_IH_MUTE_FC_STAT1_GMD      (0x00000080)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT1_GMD.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT1_GMD from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT1_GMD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT1_GMD) >> BP_HDMI_IH_MUTE_FC_STAT1_GMD)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT1_GMD.
#define BF_HDMI_IH_MUTE_FC_STAT1_GMD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT1_GMD) & BM_HDMI_IH_MUTE_FC_STAT1_GMD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMD field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT1_GMD(v)   (HW_HDMI_IH_MUTE_FC_STAT1_WR((HW_HDMI_IH_MUTE_FC_STAT1_RD() & ~BM_HDMI_IH_MUTE_FC_STAT1_GMD) | BF_HDMI_IH_MUTE_FC_STAT1_GMD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_FC_STAT2 - Frame Composer Interrupt Mute Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_FC_STAT2 - Frame Composer Interrupt Mute Control Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_fc_stat2
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_fc_stat2_bitfields
    {
        unsigned char HIGHPRIORITY_OVERFLOW : 1; //!< [0] When set to 1, mutes IH_ FC_STAT2[0]
        unsigned char LOWPRIORITY_OVERFLOW : 1; //!< [1] When set to 1, mutes IH_ FC_STAT2[1]
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_mute_fc_stat2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_FC_STAT2 register
 */
//@{
#define HW_HDMI_IH_MUTE_FC_STAT2_ADDR      (REGS_HDMI_BASE + 0x182)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_FC_STAT2           (*(volatile hw_hdmi_ih_mute_fc_stat2_t *) HW_HDMI_IH_MUTE_FC_STAT2_ADDR)
#define HW_HDMI_IH_MUTE_FC_STAT2_RD()      (HW_HDMI_IH_MUTE_FC_STAT2.U)
#define HW_HDMI_IH_MUTE_FC_STAT2_WR(v)     (HW_HDMI_IH_MUTE_FC_STAT2.U = (v))
#define HW_HDMI_IH_MUTE_FC_STAT2_SET(v)    (HW_HDMI_IH_MUTE_FC_STAT2_WR(HW_HDMI_IH_MUTE_FC_STAT2_RD() |  (v)))
#define HW_HDMI_IH_MUTE_FC_STAT2_CLR(v)    (HW_HDMI_IH_MUTE_FC_STAT2_WR(HW_HDMI_IH_MUTE_FC_STAT2_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_FC_STAT2_TOG(v)    (HW_HDMI_IH_MUTE_FC_STAT2_WR(HW_HDMI_IH_MUTE_FC_STAT2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_FC_STAT2 bitfields
 */

/*! @name Register HDMI_IH_MUTE_FC_STAT2, field HIGHPRIORITY_OVERFLOW[0] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT2[0]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW      (0)      //!< Bit position for HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW.
#define BM_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW) >> BP_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW.
#define BF_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW) & BM_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HIGHPRIORITY_OVERFLOW field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)   (HW_HDMI_IH_MUTE_FC_STAT2_WR((HW_HDMI_IH_MUTE_FC_STAT2_RD() & ~BM_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW) | BF_HDMI_IH_MUTE_FC_STAT2_HIGHPRIORITY_OVERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_FC_STAT2, field LOWPRIORITY_OVERFLOW[1] (RW)
 *
 * When set to 1, mutes IH_ FC_STAT2[1]
 */
//@{
#define BP_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW      (1)      //!< Bit position for HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW.
#define BM_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW.

//! @brief Get value of HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW from a register value.
#define BG_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW) >> BP_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW.
#define BF_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW) & BM_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOWPRIORITY_OVERFLOW field to a new value.
#define BW_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW(v)   (HW_HDMI_IH_MUTE_FC_STAT2_WR((HW_HDMI_IH_MUTE_FC_STAT2_RD() & ~BM_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW) | BF_HDMI_IH_MUTE_FC_STAT2_LOWPRIORITY_OVERFLOW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_AS_STAT0 - Audio Sampler Interrupt Mute Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_AS_STAT0 - Audio Sampler Interrupt Mute Control Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_as_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_as_stat0_bitfields
    {
        unsigned char AUD_FIFO_OVERFLOW : 1; //!< [0] When set to 1, mutes IH_ AS_STAT0[0]
        unsigned char AUD_FIFO_UNDERFLOW : 1; //!< [1] When set to 1, mutes IH_ AS_STAT0[1]
        unsigned char AUD_FIFO_UNDERFLOW_THR : 1; //!< [2] When set to 1, mutes IH_ AS_STAT0[2]
        unsigned char RESERVED0 : 5; //!< [7:3] Reserved
    } B;
} hw_hdmi_ih_mute_as_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_AS_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_AS_STAT0_ADDR      (REGS_HDMI_BASE + 0x183)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_AS_STAT0           (*(volatile hw_hdmi_ih_mute_as_stat0_t *) HW_HDMI_IH_MUTE_AS_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_AS_STAT0_RD()      (HW_HDMI_IH_MUTE_AS_STAT0.U)
#define HW_HDMI_IH_MUTE_AS_STAT0_WR(v)     (HW_HDMI_IH_MUTE_AS_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_AS_STAT0_SET(v)    (HW_HDMI_IH_MUTE_AS_STAT0_WR(HW_HDMI_IH_MUTE_AS_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_AS_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_AS_STAT0_WR(HW_HDMI_IH_MUTE_AS_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_AS_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_AS_STAT0_WR(HW_HDMI_IH_MUTE_AS_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_AS_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_AS_STAT0, field AUD_FIFO_OVERFLOW[0] (RW)
 *
 * When set to 1, mutes IH_ AS_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW      (0)      //!< Bit position for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW.
#define BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW.

//! @brief Get value of HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW from a register value.
#define BG_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW) >> BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW)

//! @brief Format value for bitfield HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW.
#define BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_OVERFLOW field to a new value.
#define BW_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW(v)   (HW_HDMI_IH_MUTE_AS_STAT0_WR((HW_HDMI_IH_MUTE_AS_STAT0_RD() & ~BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW) | BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_OVERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AS_STAT0, field AUD_FIFO_UNDERFLOW[1] (RW)
 *
 * When set to 1, mutes IH_ AS_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW      (1)      //!< Bit position for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW.
#define BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW.

//! @brief Get value of HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW from a register value.
#define BG_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW) >> BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW)

//! @brief Format value for bitfield HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW.
#define BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_UNDERFLOW field to a new value.
#define BW_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW(v)   (HW_HDMI_IH_MUTE_AS_STAT0_WR((HW_HDMI_IH_MUTE_AS_STAT0_RD() & ~BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW) | BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AS_STAT0, field AUD_FIFO_UNDERFLOW_THR[2] (RW)
 *
 * When set to 1, mutes IH_ AS_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR      (2)      //!< Bit position for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.
#define BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.

//! @brief Get value of HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR from a register value.
#define BG_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) >> BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR)

//! @brief Format value for bitfield HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR.
#define BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) & BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_FIFO_UNDERFLOW_THR field to a new value.
#define BW_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)   (HW_HDMI_IH_MUTE_AS_STAT0_WR((HW_HDMI_IH_MUTE_AS_STAT0_RD() & ~BM_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR) | BF_HDMI_IH_MUTE_AS_STAT0_AUD_FIFO_UNDERFLOW_THR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_PHY_STAT0 - PHY Interface Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_PHY_STAT0 - PHY Interface Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_phy_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_phy_stat0_bitfields
    {
        unsigned char HDP : 1; //!< [0] When set to 1, mutes IH_ PHY_STAT0[0]
        unsigned char TX_PHY_LOCK : 1; //!< [1] When set to 1, mutes IH_ PHY_STAT0[1]
        unsigned char RX_SENSE : 1; //!< [2] When set to 1, mutes IH_ PHY_STAT0[2]
        unsigned char RX_SENSE1 : 1; //!< [3] When set to 1, mutes IH_ PHY_STAT0[3]
        unsigned char RX_SENSE2 : 1; //!< [4] When set to 1, mutes IH_ PHY_STAT0[4]
        unsigned char RX_SENSE3 : 1; //!< [5] When set to 1, mutes IH_ PHY_STAT0[5]
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_ih_mute_phy_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_PHY_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_PHY_STAT0_ADDR      (REGS_HDMI_BASE + 0x184)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_PHY_STAT0           (*(volatile hw_hdmi_ih_mute_phy_stat0_t *) HW_HDMI_IH_MUTE_PHY_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_PHY_STAT0_RD()      (HW_HDMI_IH_MUTE_PHY_STAT0.U)
#define HW_HDMI_IH_MUTE_PHY_STAT0_WR(v)     (HW_HDMI_IH_MUTE_PHY_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_PHY_STAT0_SET(v)    (HW_HDMI_IH_MUTE_PHY_STAT0_WR(HW_HDMI_IH_MUTE_PHY_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_PHY_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_PHY_STAT0_WR(HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_PHY_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_PHY_STAT0_WR(HW_HDMI_IH_MUTE_PHY_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_PHY_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field HDP[0] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_HDP      (0)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_HDP.
#define BM_HDMI_IH_MUTE_PHY_STAT0_HDP      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_HDP.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_HDP from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_HDP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_HDP) >> BP_HDMI_IH_MUTE_PHY_STAT0_HDP)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_HDP.
#define BF_HDMI_IH_MUTE_PHY_STAT0_HDP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_HDP) & BM_HDMI_IH_MUTE_PHY_STAT0_HDP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HDP field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_HDP(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_HDP) | BF_HDMI_IH_MUTE_PHY_STAT0_HDP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field TX_PHY_LOCK[1] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK      (1)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK.
#define BM_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK) >> BP_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK.
#define BF_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK) & BM_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_PHY_LOCK field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK) | BF_HDMI_IH_MUTE_PHY_STAT0_TX_PHY_LOCK(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field RX_SENSE[2] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE      (2)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE.
#define BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_RX_SENSE from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE) >> BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_RX_SENSE.
#define BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE) | BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field RX_SENSE1[3] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1      (3)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1.
#define BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1 from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1) >> BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1.
#define BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE1 field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1) | BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE1(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field RX_SENSE2[4] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2      (4)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2.
#define BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2 from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2) >> BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2.
#define BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE2 field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2) | BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE2(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_PHY_STAT0, field RX_SENSE3[5] (RW)
 *
 * When set to 1, mutes IH_ PHY_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3      (5)      //!< Bit position for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3.
#define BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3.

//! @brief Get value of HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3 from a register value.
#define BG_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3) >> BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3)

//! @brief Format value for bitfield HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3.
#define BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3) & BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE3 field to a new value.
#define BW_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3(v)   (HW_HDMI_IH_MUTE_PHY_STAT0_WR((HW_HDMI_IH_MUTE_PHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3) | BF_HDMI_IH_MUTE_PHY_STAT0_RX_SENSE3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_I2CM_STAT0 - E-DDC I2C Master Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_I2CM_STAT0 - E-DDC I2C Master Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_i2cm_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_i2cm_stat0_bitfields
    {
        unsigned char I2CMASTER_ERROR : 1; //!< [0] When set to 1, mutes IH_ I2CM_STAT0[0]
        unsigned char I2CMASTERDONE : 1; //!< [1] When set to 1, mutes IH_ I2CM_STAT0[1]
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_mute_i2cm_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_I2CM_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_I2CM_STAT0_ADDR      (REGS_HDMI_BASE + 0x185)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_I2CM_STAT0           (*(volatile hw_hdmi_ih_mute_i2cm_stat0_t *) HW_HDMI_IH_MUTE_I2CM_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_I2CM_STAT0_RD()      (HW_HDMI_IH_MUTE_I2CM_STAT0.U)
#define HW_HDMI_IH_MUTE_I2CM_STAT0_WR(v)     (HW_HDMI_IH_MUTE_I2CM_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_I2CM_STAT0_SET(v)    (HW_HDMI_IH_MUTE_I2CM_STAT0_WR(HW_HDMI_IH_MUTE_I2CM_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_I2CM_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_I2CM_STAT0_WR(HW_HDMI_IH_MUTE_I2CM_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_I2CM_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_I2CM_STAT0_WR(HW_HDMI_IH_MUTE_I2CM_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_I2CM_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_I2CM_STAT0, field I2CMASTER_ERROR[0] (RW)
 *
 * When set to 1, mutes IH_ I2CM_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR      (0)      //!< Bit position for HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR.
#define BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR.

//! @brief Get value of HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR from a register value.
#define BG_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR) >> BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR)

//! @brief Format value for bitfield HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR.
#define BF_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR) & BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMASTER_ERROR field to a new value.
#define BW_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR(v)   (HW_HDMI_IH_MUTE_I2CM_STAT0_WR((HW_HDMI_IH_MUTE_I2CM_STAT0_RD() & ~BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR) | BF_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTER_ERROR(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_I2CM_STAT0, field I2CMASTERDONE[1] (RW)
 *
 * When set to 1, mutes IH_ I2CM_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE      (1)      //!< Bit position for HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE.
#define BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE.

//! @brief Get value of HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE from a register value.
#define BG_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE) >> BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE)

//! @brief Format value for bitfield HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE.
#define BF_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE) & BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMASTERDONE field to a new value.
#define BW_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE(v)   (HW_HDMI_IH_MUTE_I2CM_STAT0_WR((HW_HDMI_IH_MUTE_I2CM_STAT0_RD() & ~BM_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE) | BF_HDMI_IH_MUTE_I2CM_STAT0_I2CMASTERDONE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_CEC_STAT0 - CEC Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_CEC_STAT0 - CEC Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_cec_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_cec_stat0_bitfields
    {
        unsigned char DONE : 1; //!< [0] When set to 1, mutes IH_ CEC_STAT0[0]
        unsigned char EOM : 1; //!< [1] When set to 1, mutes IH_ CEC_STAT0[1]
        unsigned char NACK : 1; //!< [2] When set to 1, mutes IH_ CEC_STAT0[2]
        unsigned char ARB_LOST : 1; //!< [3] When set to 1, mutes IH_ CEC_STAT0[3]
        unsigned char ERROR_INITIATOR : 1; //!< [4] When set to 1, mutes IH_ CEC_STAT0[4]
        unsigned char ERROR_FOLLOW : 1; //!< [5] When set to 1, mutes IH_ CEC_STAT0[5]
        unsigned char WAKEUP : 1; //!< [6] When set to 1, mutes IH_ CEC_STAT0[6]
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_ih_mute_cec_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_CEC_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_CEC_STAT0_ADDR      (REGS_HDMI_BASE + 0x186)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_CEC_STAT0           (*(volatile hw_hdmi_ih_mute_cec_stat0_t *) HW_HDMI_IH_MUTE_CEC_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_CEC_STAT0_RD()      (HW_HDMI_IH_MUTE_CEC_STAT0.U)
#define HW_HDMI_IH_MUTE_CEC_STAT0_WR(v)     (HW_HDMI_IH_MUTE_CEC_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_CEC_STAT0_SET(v)    (HW_HDMI_IH_MUTE_CEC_STAT0_WR(HW_HDMI_IH_MUTE_CEC_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_CEC_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_CEC_STAT0_WR(HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_CEC_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_CEC_STAT0_WR(HW_HDMI_IH_MUTE_CEC_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_CEC_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field DONE[0] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_DONE      (0)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_DONE.
#define BM_HDMI_IH_MUTE_CEC_STAT0_DONE      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_DONE.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_DONE from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_DONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_DONE) >> BP_HDMI_IH_MUTE_CEC_STAT0_DONE)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_DONE.
#define BF_HDMI_IH_MUTE_CEC_STAT0_DONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_DONE) & BM_HDMI_IH_MUTE_CEC_STAT0_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_DONE(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_DONE) | BF_HDMI_IH_MUTE_CEC_STAT0_DONE(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field EOM[1] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_EOM      (1)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_EOM.
#define BM_HDMI_IH_MUTE_CEC_STAT0_EOM      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_EOM.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_EOM from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_EOM(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_EOM) >> BP_HDMI_IH_MUTE_CEC_STAT0_EOM)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_EOM.
#define BF_HDMI_IH_MUTE_CEC_STAT0_EOM(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_EOM) & BM_HDMI_IH_MUTE_CEC_STAT0_EOM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EOM field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_EOM(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_EOM) | BF_HDMI_IH_MUTE_CEC_STAT0_EOM(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field NACK[2] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_NACK      (2)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_NACK.
#define BM_HDMI_IH_MUTE_CEC_STAT0_NACK      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_NACK.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_NACK from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_NACK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_NACK) >> BP_HDMI_IH_MUTE_CEC_STAT0_NACK)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_NACK.
#define BF_HDMI_IH_MUTE_CEC_STAT0_NACK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_NACK) & BM_HDMI_IH_MUTE_CEC_STAT0_NACK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_NACK(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_NACK) | BF_HDMI_IH_MUTE_CEC_STAT0_NACK(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field ARB_LOST[3] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST      (3)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_ARB_LOST.
#define BM_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_ARB_LOST.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_ARB_LOST from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST) >> BP_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_ARB_LOST.
#define BF_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST) & BM_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARB_LOST field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST) | BF_HDMI_IH_MUTE_CEC_STAT0_ARB_LOST(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field ERROR_INITIATOR[4] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR      (4)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR.
#define BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR) >> BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR.
#define BF_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR) & BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_INITIATOR field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR) | BF_HDMI_IH_MUTE_CEC_STAT0_ERROR_INITIATOR(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field ERROR_FOLLOW[5] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW      (5)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW.
#define BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW) >> BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW.
#define BF_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW) & BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_FOLLOW field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW) | BF_HDMI_IH_MUTE_CEC_STAT0_ERROR_FOLLOW(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_CEC_STAT0, field WAKEUP[6] (RW)
 *
 * When set to 1, mutes IH_ CEC_STAT0[6]
 */
//@{
#define BP_HDMI_IH_MUTE_CEC_STAT0_WAKEUP      (6)      //!< Bit position for HDMI_IH_MUTE_CEC_STAT0_WAKEUP.
#define BM_HDMI_IH_MUTE_CEC_STAT0_WAKEUP      (0x00000040)  //!< Bit mask for HDMI_IH_MUTE_CEC_STAT0_WAKEUP.

//! @brief Get value of HDMI_IH_MUTE_CEC_STAT0_WAKEUP from a register value.
#define BG_HDMI_IH_MUTE_CEC_STAT0_WAKEUP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_CEC_STAT0_WAKEUP) >> BP_HDMI_IH_MUTE_CEC_STAT0_WAKEUP)

//! @brief Format value for bitfield HDMI_IH_MUTE_CEC_STAT0_WAKEUP.
#define BF_HDMI_IH_MUTE_CEC_STAT0_WAKEUP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_CEC_STAT0_WAKEUP) & BM_HDMI_IH_MUTE_CEC_STAT0_WAKEUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKEUP field to a new value.
#define BW_HDMI_IH_MUTE_CEC_STAT0_WAKEUP(v)   (HW_HDMI_IH_MUTE_CEC_STAT0_WR((HW_HDMI_IH_MUTE_CEC_STAT0_RD() & ~BM_HDMI_IH_MUTE_CEC_STAT0_WAKEUP) | BF_HDMI_IH_MUTE_CEC_STAT0_WAKEUP(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_VP_STAT0 - Video Packetizer Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_VP_STAT0 - Video Packetizer Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_vp_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_vp_stat0_bitfields
    {
        unsigned char FIFOEMPTYBYP : 1; //!< [0] When set to 1, mutes IH_ VP_STAT0[0]
        unsigned char FIFOFULLBYP : 1; //!< [1] When set to 1, mutes IH_ VP_STAT0[1]
        unsigned char FIFOEMPTYREMAP : 1; //!< [2] When set to 1, mutes IH_ VP_STAT0[2]
        unsigned char FIFOFULLREMAP : 1; //!< [3] When set to 1, mutes IH_ VP_STAT0[3]
        unsigned char FIFOEMPTYPP : 1; //!< [4] When set to 1, mutes IH_ VP_STAT0[4]
        unsigned char FIFOFULLPP : 1; //!< [5] When set to 1, mutes IH_ VP_STAT0[5]
        unsigned char FIFOEMPTYREPET : 1; //!< [6] When set to 1, mutes IH_ VP_STAT0[6]
        unsigned char FIFOFULLREPET : 1; //!< [7] When set to 1, mutes IH_ VP_STAT0[7]
    } B;
} hw_hdmi_ih_mute_vp_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_VP_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_VP_STAT0_ADDR      (REGS_HDMI_BASE + 0x187)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_VP_STAT0           (*(volatile hw_hdmi_ih_mute_vp_stat0_t *) HW_HDMI_IH_MUTE_VP_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_VP_STAT0_RD()      (HW_HDMI_IH_MUTE_VP_STAT0.U)
#define HW_HDMI_IH_MUTE_VP_STAT0_WR(v)     (HW_HDMI_IH_MUTE_VP_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_VP_STAT0_SET(v)    (HW_HDMI_IH_MUTE_VP_STAT0_WR(HW_HDMI_IH_MUTE_VP_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_VP_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_VP_STAT0_WR(HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_VP_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_VP_STAT0_WR(HW_HDMI_IH_MUTE_VP_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_VP_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOEMPTYBYP[0] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP      (0)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYBYP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYBYP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOFULLBYP[1] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP      (1)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLBYP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLBYP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOEMPTYREMAP[2] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP      (2)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYREMAP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREMAP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOFULLREMAP[3] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP      (3)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLREMAP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREMAP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOEMPTYPP[4] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP      (4)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYPP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYPP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOFULLPP[5] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP      (5)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLPP field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLPP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOEMPTYREPET[6] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[6]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET      (6)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET      (0x00000040)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOEMPTYREPET field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOEMPTYREPET(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_VP_STAT0, field FIFOFULLREPET[7] (RW)
 *
 * When set to 1, mutes IH_ VP_STAT0[7]
 */
//@{
#define BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET      (7)      //!< Bit position for HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET.
#define BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET      (0x00000080)  //!< Bit mask for HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET.

//! @brief Get value of HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET from a register value.
#define BG_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET) >> BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET)

//! @brief Format value for bitfield HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET.
#define BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET) & BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFOFULLREPET field to a new value.
#define BW_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET(v)   (HW_HDMI_IH_MUTE_VP_STAT0_WR((HW_HDMI_IH_MUTE_VP_STAT0_RD() & ~BM_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET) | BF_HDMI_IH_MUTE_VP_STAT0_FIFOFULLREPET(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_I2CMPHY_STAT0 - PHY GEN 2 I2C Master Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_I2CMPHY_STAT0 - PHY GEN 2 I2C Master Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_i2cmphy_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_i2cmphy_stat0_bitfields
    {
        unsigned char I2CMPHYERROR : 1; //!< [0] When set to 1, mutes IH_ I2CMPHY_STAT0[0]
        unsigned char I2CMPHYDONE : 1; //!< [1] When set to 1, mutes IH_ I2CMPHY_STAT0[1]
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ih_mute_i2cmphy_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_I2CMPHY_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_ADDR      (REGS_HDMI_BASE + 0x188)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0           (*(volatile hw_hdmi_ih_mute_i2cmphy_stat0_t *) HW_HDMI_IH_MUTE_I2CMPHY_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD()      (HW_HDMI_IH_MUTE_I2CMPHY_STAT0.U)
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR(v)     (HW_HDMI_IH_MUTE_I2CMPHY_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_SET(v)    (HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR(HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR(HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_I2CMPHY_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR(HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_I2CMPHY_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_I2CMPHY_STAT0, field I2CMPHYERROR[0] (RW)
 *
 * When set to 1, mutes IH_ I2CMPHY_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR      (0)      //!< Bit position for HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR.
#define BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR.

//! @brief Get value of HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR from a register value.
#define BG_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR) >> BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR)

//! @brief Format value for bitfield HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR.
#define BF_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR) & BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMPHYERROR field to a new value.
#define BW_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR(v)   (HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR((HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR) | BF_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_I2CMPHY_STAT0, field I2CMPHYDONE[1] (RW)
 *
 * When set to 1, mutes IH_ I2CMPHY_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE      (1)      //!< Bit position for HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE.
#define BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE.

//! @brief Get value of HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE from a register value.
#define BG_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE) >> BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE)

//! @brief Format value for bitfield HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE.
#define BF_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE) & BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMPHYDONE field to a new value.
#define BW_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE(v)   (HW_HDMI_IH_MUTE_I2CMPHY_STAT0_WR((HW_HDMI_IH_MUTE_I2CMPHY_STAT0_RD() & ~BM_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE) | BF_HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0 - AHB Audio DMA Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ih_mute_ahbdmaaud_stat0
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_ahbdmaaud_stat0_bitfields
    {
        unsigned char AHBDMAAUD_INTBUFFEMPTY : 1; //!< [0] When set to 1, mutes IH_AHBDMAAUD_STAT0[0]
        unsigned char AHBDMAAUD_INTBUFFFULL : 1; //!< [1] When set to 1, mutes IH_AHBDMAAUD_STAT0[1]
        unsigned char AHBDMAAUD_INTDONE : 1; //!< [2] When set to 1, mutes IH_AHBDMAAUD_STAT0[2]
        unsigned char AHBDMAAUD_INTRETRYSPLIT : 1; //!< [3] When set to 1, mutes IH_AHBDMAAUD_STAT0[3]
        unsigned char AHBDMAAUD_INTLOSTOWNERSHIP : 1; //!< [4] When set to 1, mutes IH_AHBDMAAUD_STAT0[4]
        unsigned char AHBDMAAUD_INTERROR : 1; //!< [5] When set to 1, mutes IH_AHBDMAAUD_STAT0[5]
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_ih_mute_ahbdmaaud_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE_AHBDMAAUD_STAT0 register
 */
//@{
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_ADDR      (REGS_HDMI_BASE + 0x189)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0           (*(volatile hw_hdmi_ih_mute_ahbdmaaud_stat0_t *) HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_ADDR)
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD()      (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0.U)
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR(v)     (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0.U = (v))
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_SET(v)    (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() |  (v)))
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_CLR(v)    (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_TOG(v)    (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR(HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE_AHBDMAAUD_STAT0 bitfields
 */

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTBUFFEMPTY[0] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY      (0)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFEMPTY field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFEMPTY(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTBUFFFULL[1] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL      (1)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFFULL field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTBUFFFULL(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTDONE[2] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE      (2)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTDONE field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTDONE(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTRETRYSPLIT[3] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT      (3)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTRETRYSPLIT field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTRETRYSPLIT(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTLOSTOWNERSHIP[4] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP      (4)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTLOSTOWNERSHIP field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTLOSTOWNERSHIP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE_AHBDMAAUD_STAT0, field AHBDMAAUD_INTERROR[5] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR      (5)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) >> BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) & BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTERROR field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)   (HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_WR((HW_HDMI_IH_MUTE_AHBDMAAUD_STAT0_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR) | BF_HDMI_IH_MUTE_AHBDMAAUD_STAT0_AHBDMAAUD_INTERROR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_IH_MUTE - Global Interrupt Mute Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_IH_MUTE - Global Interrupt Mute Control Register (RW)
 *
 * Reset value: 0x03
 */
typedef union _hw_hdmi_ih_mute
{
    reg8_t U;
    struct _hw_hdmi_ih_mute_bitfields
    {
        unsigned char AHBDMAAUD_INTBUFFEMPTY : 1; //!< [0] When set to 1, mutes IH_AHBDMAAUD_STAT0[0]
        unsigned char AHBDMAAUD_INTBUFFFULL : 1; //!< [1] When set to 1, mutes IH_AHBDMAAUD_STAT0[1]
        unsigned char AHBDMAAUD_INTDONE : 1; //!< [2] When set to 1, mutes IH_AHBDMAAUD_STAT0[2]
        unsigned char AHBDMAAUD_INTRETRYSPLIT : 1; //!< [3] When set to 1, mutes IH_AHBDMAAUD_STAT0[3]
        unsigned char AHBDMAAUD_INTLOSTOWNERSHIP : 1; //!< [4] When set to 1, mutes IH_AHBDMAAUD_STAT0[4]
        unsigned char AHBDMAAUD_INTERROR : 1; //!< [5] When set to 1, mutes IH_AHBDMAAUD_STAT0[5]
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_ih_mute_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_IH_MUTE register
 */
//@{
#define HW_HDMI_IH_MUTE_ADDR      (REGS_HDMI_BASE + 0x1ff)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_IH_MUTE           (*(volatile hw_hdmi_ih_mute_t *) HW_HDMI_IH_MUTE_ADDR)
#define HW_HDMI_IH_MUTE_RD()      (HW_HDMI_IH_MUTE.U)
#define HW_HDMI_IH_MUTE_WR(v)     (HW_HDMI_IH_MUTE.U = (v))
#define HW_HDMI_IH_MUTE_SET(v)    (HW_HDMI_IH_MUTE_WR(HW_HDMI_IH_MUTE_RD() |  (v)))
#define HW_HDMI_IH_MUTE_CLR(v)    (HW_HDMI_IH_MUTE_WR(HW_HDMI_IH_MUTE_RD() & ~(v)))
#define HW_HDMI_IH_MUTE_TOG(v)    (HW_HDMI_IH_MUTE_WR(HW_HDMI_IH_MUTE_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_IH_MUTE bitfields
 */

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTBUFFEMPTY[0] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[0]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY      (0)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY      (0x00000001)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFEMPTY field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFEMPTY(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTBUFFFULL[1] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[1]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL      (1)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL      (0x00000002)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTBUFFFULL field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTBUFFFULL(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTDONE[2] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[2]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTDONE      (2)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTDONE.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTDONE      (0x00000004)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTDONE.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTDONE from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTDONE) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTDONE)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTDONE.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTDONE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTDONE) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTDONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTDONE field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTDONE(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTDONE) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTDONE(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTRETRYSPLIT[3] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[3]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT      (3)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT      (0x00000008)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTRETRYSPLIT field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTRETRYSPLIT(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTLOSTOWNERSHIP[4] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[4]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP      (4)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP      (0x00000010)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTLOSTOWNERSHIP field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTLOSTOWNERSHIP(v)))
#endif
//@}

/*! @name Register HDMI_IH_MUTE, field AHBDMAAUD_INTERROR[5] (RW)
 *
 * When set to 1, mutes IH_AHBDMAAUD_STAT0[5]
 */
//@{
#define BP_HDMI_IH_MUTE_AHBDMAAUD_INTERROR      (5)      //!< Bit position for HDMI_IH_MUTE_AHBDMAAUD_INTERROR.
#define BM_HDMI_IH_MUTE_AHBDMAAUD_INTERROR      (0x00000020)  //!< Bit mask for HDMI_IH_MUTE_AHBDMAAUD_INTERROR.

//! @brief Get value of HDMI_IH_MUTE_AHBDMAAUD_INTERROR from a register value.
#define BG_HDMI_IH_MUTE_AHBDMAAUD_INTERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTERROR) >> BP_HDMI_IH_MUTE_AHBDMAAUD_INTERROR)

//! @brief Format value for bitfield HDMI_IH_MUTE_AHBDMAAUD_INTERROR.
#define BF_HDMI_IH_MUTE_AHBDMAAUD_INTERROR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_IH_MUTE_AHBDMAAUD_INTERROR) & BM_HDMI_IH_MUTE_AHBDMAAUD_INTERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AHBDMAAUD_INTERROR field to a new value.
#define BW_HDMI_IH_MUTE_AHBDMAAUD_INTERROR(v)   (HW_HDMI_IH_MUTE_WR((HW_HDMI_IH_MUTE_RD() & ~BM_HDMI_IH_MUTE_AHBDMAAUD_INTERROR) | BF_HDMI_IH_MUTE_AHBDMAAUD_INTERROR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_INVID0 - Video Input Mapping and Internal Data Enable Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_INVID0 - Video Input Mapping and Internal Data Enable Configuration Register (RW)
 *
 * Reset value: 0x01
 *
 * This registers contains the input video mapping code as defined in Table 2-1.
 */
typedef union _hw_hdmi_tx_invid0
{
    reg8_t U;
    struct _hw_hdmi_tx_invid0_bitfields
    {
        unsigned char VIDEO_MAPPING : 5; //!< [4:0] video_mapping
        unsigned char RESERVED0 : 2; //!< [6:5] Reserved
        unsigned char INTERNAL_DE_GENERATOR : 1; //!< [7] Internal data enable (DE) generator enable.
    } B;
} hw_hdmi_tx_invid0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_INVID0 register
 */
//@{
#define HW_HDMI_TX_INVID0_ADDR      (REGS_HDMI_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_INVID0           (*(volatile hw_hdmi_tx_invid0_t *) HW_HDMI_TX_INVID0_ADDR)
#define HW_HDMI_TX_INVID0_RD()      (HW_HDMI_TX_INVID0.U)
#define HW_HDMI_TX_INVID0_WR(v)     (HW_HDMI_TX_INVID0.U = (v))
#define HW_HDMI_TX_INVID0_SET(v)    (HW_HDMI_TX_INVID0_WR(HW_HDMI_TX_INVID0_RD() |  (v)))
#define HW_HDMI_TX_INVID0_CLR(v)    (HW_HDMI_TX_INVID0_WR(HW_HDMI_TX_INVID0_RD() & ~(v)))
#define HW_HDMI_TX_INVID0_TOG(v)    (HW_HDMI_TX_INVID0_WR(HW_HDMI_TX_INVID0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_INVID0 bitfields
 */

/*! @name Register HDMI_TX_INVID0, field VIDEO_MAPPING[4:0] (RW)
 *
 * video_mapping
 */
//@{
#define BP_HDMI_TX_INVID0_VIDEO_MAPPING      (0)      //!< Bit position for HDMI_TX_INVID0_VIDEO_MAPPING.
#define BM_HDMI_TX_INVID0_VIDEO_MAPPING      (0x0000001f)  //!< Bit mask for HDMI_TX_INVID0_VIDEO_MAPPING.

//! @brief Get value of HDMI_TX_INVID0_VIDEO_MAPPING from a register value.
#define BG_HDMI_TX_INVID0_VIDEO_MAPPING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_INVID0_VIDEO_MAPPING) >> BP_HDMI_TX_INVID0_VIDEO_MAPPING)

//! @brief Format value for bitfield HDMI_TX_INVID0_VIDEO_MAPPING.
#define BF_HDMI_TX_INVID0_VIDEO_MAPPING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_INVID0_VIDEO_MAPPING) & BM_HDMI_TX_INVID0_VIDEO_MAPPING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VIDEO_MAPPING field to a new value.
#define BW_HDMI_TX_INVID0_VIDEO_MAPPING(v)   (HW_HDMI_TX_INVID0_WR((HW_HDMI_TX_INVID0_RD() & ~BM_HDMI_TX_INVID0_VIDEO_MAPPING) | BF_HDMI_TX_INVID0_VIDEO_MAPPING(v)))
#endif
//@}

/*! @name Register HDMI_TX_INVID0, field INTERNAL_DE_GENERATOR[7] (RW)
 *
 * Internal data enable (DE) generator enable. If data enable is not available for the input video
 * the user may set this bit to one to activate the internal data enable generator. This feature
 * only works for input video modes that have native repetition (such as, all CEA videos). No
 * desired pixel repetition can be used with this feature because these configurations only affect
 * the Frame Composer and not this block.
 */
//@{
#define BP_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR      (7)      //!< Bit position for HDMI_TX_INVID0_INTERNAL_DE_GENERATOR.
#define BM_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR      (0x00000080)  //!< Bit mask for HDMI_TX_INVID0_INTERNAL_DE_GENERATOR.

//! @brief Get value of HDMI_TX_INVID0_INTERNAL_DE_GENERATOR from a register value.
#define BG_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR) >> BP_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR)

//! @brief Format value for bitfield HDMI_TX_INVID0_INTERNAL_DE_GENERATOR.
#define BF_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR) & BM_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTERNAL_DE_GENERATOR field to a new value.
#define BW_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR(v)   (HW_HDMI_TX_INVID0_WR((HW_HDMI_TX_INVID0_RD() & ~BM_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR) | BF_HDMI_TX_INVID0_INTERNAL_DE_GENERATOR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_INSTUFFING - Video Input Stuffing Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_INSTUFFING - Video Input Stuffing Enable Register (RW)
 *
 * Reset value: 0x00
 *
 * This register enables the stuffing mechanism of the Video Sampler module in order to correctly
 * perform Color Space Conversion of the ITU.601 standard YCC video. In this case, when "de" is low,
 * the output video components gydata[15:0], rcrdata[15:0], and bcbdata[15:0] can be configured.
 */
typedef union _hw_hdmi_tx_instuffing
{
    reg8_t U;
    struct _hw_hdmi_tx_instuffing_bitfields
    {
        unsigned char GYDATA_STUFFING : 1; //!< [0] 
        unsigned char RCRDATA_STUFFING : 1; //!< [1] 
        unsigned char BCBDATA_STUFFING : 1; //!< [2] 
        unsigned char RESERVED0 : 5; //!< [7:3] Reserved
    } B;
} hw_hdmi_tx_instuffing_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_INSTUFFING register
 */
//@{
#define HW_HDMI_TX_INSTUFFING_ADDR      (REGS_HDMI_BASE + 0x201)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_INSTUFFING           (*(volatile hw_hdmi_tx_instuffing_t *) HW_HDMI_TX_INSTUFFING_ADDR)
#define HW_HDMI_TX_INSTUFFING_RD()      (HW_HDMI_TX_INSTUFFING.U)
#define HW_HDMI_TX_INSTUFFING_WR(v)     (HW_HDMI_TX_INSTUFFING.U = (v))
#define HW_HDMI_TX_INSTUFFING_SET(v)    (HW_HDMI_TX_INSTUFFING_WR(HW_HDMI_TX_INSTUFFING_RD() |  (v)))
#define HW_HDMI_TX_INSTUFFING_CLR(v)    (HW_HDMI_TX_INSTUFFING_WR(HW_HDMI_TX_INSTUFFING_RD() & ~(v)))
#define HW_HDMI_TX_INSTUFFING_TOG(v)    (HW_HDMI_TX_INSTUFFING_WR(HW_HDMI_TX_INSTUFFING_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_INSTUFFING bitfields
 */

/*! @name Register HDMI_TX_INSTUFFING, field GYDATA_STUFFING[0] (RW)
 *
 * Values:
 * - 0 - when the dataen signal is low, the value in the gydata[15:0] output is the one sampled from the
 *     corresponding input data.
 * - 1 - When the dataen signal is low, the value in the gydata[15:0] output is given by the values in
 *     TX_GYDTA0 and TX_GYDATA1 registers.
 */
//@{
#define BP_HDMI_TX_INSTUFFING_GYDATA_STUFFING      (0)      //!< Bit position for HDMI_TX_INSTUFFING_GYDATA_STUFFING.
#define BM_HDMI_TX_INSTUFFING_GYDATA_STUFFING      (0x00000001)  //!< Bit mask for HDMI_TX_INSTUFFING_GYDATA_STUFFING.

//! @brief Get value of HDMI_TX_INSTUFFING_GYDATA_STUFFING from a register value.
#define BG_HDMI_TX_INSTUFFING_GYDATA_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_INSTUFFING_GYDATA_STUFFING) >> BP_HDMI_TX_INSTUFFING_GYDATA_STUFFING)

//! @brief Format value for bitfield HDMI_TX_INSTUFFING_GYDATA_STUFFING.
#define BF_HDMI_TX_INSTUFFING_GYDATA_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_INSTUFFING_GYDATA_STUFFING) & BM_HDMI_TX_INSTUFFING_GYDATA_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GYDATA_STUFFING field to a new value.
#define BW_HDMI_TX_INSTUFFING_GYDATA_STUFFING(v)   (HW_HDMI_TX_INSTUFFING_WR((HW_HDMI_TX_INSTUFFING_RD() & ~BM_HDMI_TX_INSTUFFING_GYDATA_STUFFING) | BF_HDMI_TX_INSTUFFING_GYDATA_STUFFING(v)))
#endif
//@}

/*! @name Register HDMI_TX_INSTUFFING, field RCRDATA_STUFFING[1] (RW)
 *
 * Values:
 * - 0 - When the dataen signal is low, the value in the rcrdata[15:0] output is the one sampled from the
 *     corresponding input data.
 * - 1 - When the dataen signal is low, the value in the rcrdata[15:0] output is given by the values in
 *     TX_RCRDTA0 and TX_RCRDATA1 registers.
 */
//@{
#define BP_HDMI_TX_INSTUFFING_RCRDATA_STUFFING      (1)      //!< Bit position for HDMI_TX_INSTUFFING_RCRDATA_STUFFING.
#define BM_HDMI_TX_INSTUFFING_RCRDATA_STUFFING      (0x00000002)  //!< Bit mask for HDMI_TX_INSTUFFING_RCRDATA_STUFFING.

//! @brief Get value of HDMI_TX_INSTUFFING_RCRDATA_STUFFING from a register value.
#define BG_HDMI_TX_INSTUFFING_RCRDATA_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_INSTUFFING_RCRDATA_STUFFING) >> BP_HDMI_TX_INSTUFFING_RCRDATA_STUFFING)

//! @brief Format value for bitfield HDMI_TX_INSTUFFING_RCRDATA_STUFFING.
#define BF_HDMI_TX_INSTUFFING_RCRDATA_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_INSTUFFING_RCRDATA_STUFFING) & BM_HDMI_TX_INSTUFFING_RCRDATA_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RCRDATA_STUFFING field to a new value.
#define BW_HDMI_TX_INSTUFFING_RCRDATA_STUFFING(v)   (HW_HDMI_TX_INSTUFFING_WR((HW_HDMI_TX_INSTUFFING_RD() & ~BM_HDMI_TX_INSTUFFING_RCRDATA_STUFFING) | BF_HDMI_TX_INSTUFFING_RCRDATA_STUFFING(v)))
#endif
//@}

/*! @name Register HDMI_TX_INSTUFFING, field BCBDATA_STUFFING[2] (RW)
 *
 * Values:
 * - 0 - When the dataen signal is low, the value in the bcbdata[15:0] output is the one sampled from the
 *     corresponding input data.
 * - 1 - When the dataen signal is low, the value in the bcbdata[15:0] output is given by the values in
 *     register TX_BCBDTA0 and TX_BCBDATA1.
 */
//@{
#define BP_HDMI_TX_INSTUFFING_BCBDATA_STUFFING      (2)      //!< Bit position for HDMI_TX_INSTUFFING_BCBDATA_STUFFING.
#define BM_HDMI_TX_INSTUFFING_BCBDATA_STUFFING      (0x00000004)  //!< Bit mask for HDMI_TX_INSTUFFING_BCBDATA_STUFFING.

//! @brief Get value of HDMI_TX_INSTUFFING_BCBDATA_STUFFING from a register value.
#define BG_HDMI_TX_INSTUFFING_BCBDATA_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_INSTUFFING_BCBDATA_STUFFING) >> BP_HDMI_TX_INSTUFFING_BCBDATA_STUFFING)

//! @brief Format value for bitfield HDMI_TX_INSTUFFING_BCBDATA_STUFFING.
#define BF_HDMI_TX_INSTUFFING_BCBDATA_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_INSTUFFING_BCBDATA_STUFFING) & BM_HDMI_TX_INSTUFFING_BCBDATA_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCBDATA_STUFFING field to a new value.
#define BW_HDMI_TX_INSTUFFING_BCBDATA_STUFFING(v)   (HW_HDMI_TX_INSTUFFING_WR((HW_HDMI_TX_INSTUFFING_RD() & ~BM_HDMI_TX_INSTUFFING_BCBDATA_STUFFING) | BF_HDMI_TX_INSTUFFING_BCBDATA_STUFFING(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_GYDATA0 - Video Input GY Data Channel Stuffing Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_GYDATA0 - Video Input GY Data Channel Stuffing Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_gydata0
{
    reg8_t U;
    struct _hw_hdmi_tx_gydata0_bitfields
    {
        unsigned char GYDATA : 8; //!< [7:0] gydata[7:0].This register defines the value of gydata[7:0] when TX_INSTUFFING[0] (gydata_stuffing) is set to 1b.
    } B;
} hw_hdmi_tx_gydata0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_GYDATA0 register
 */
//@{
#define HW_HDMI_TX_GYDATA0_ADDR      (REGS_HDMI_BASE + 0x202)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_GYDATA0           (*(volatile hw_hdmi_tx_gydata0_t *) HW_HDMI_TX_GYDATA0_ADDR)
#define HW_HDMI_TX_GYDATA0_RD()      (HW_HDMI_TX_GYDATA0.U)
#define HW_HDMI_TX_GYDATA0_WR(v)     (HW_HDMI_TX_GYDATA0.U = (v))
#define HW_HDMI_TX_GYDATA0_SET(v)    (HW_HDMI_TX_GYDATA0_WR(HW_HDMI_TX_GYDATA0_RD() |  (v)))
#define HW_HDMI_TX_GYDATA0_CLR(v)    (HW_HDMI_TX_GYDATA0_WR(HW_HDMI_TX_GYDATA0_RD() & ~(v)))
#define HW_HDMI_TX_GYDATA0_TOG(v)    (HW_HDMI_TX_GYDATA0_WR(HW_HDMI_TX_GYDATA0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_GYDATA0 bitfields
 */

/*! @name Register HDMI_TX_GYDATA0, field GYDATA[7:0] (RW)
 *
 * gydata[7:0].This register defines the value of gydata[7:0] when TX_INSTUFFING[0]
 * (gydata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_GYDATA0_GYDATA      (0)      //!< Bit position for HDMI_TX_GYDATA0_GYDATA.
#define BM_HDMI_TX_GYDATA0_GYDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_GYDATA0_GYDATA.

//! @brief Get value of HDMI_TX_GYDATA0_GYDATA from a register value.
#define BG_HDMI_TX_GYDATA0_GYDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_GYDATA0_GYDATA) >> BP_HDMI_TX_GYDATA0_GYDATA)

//! @brief Format value for bitfield HDMI_TX_GYDATA0_GYDATA.
#define BF_HDMI_TX_GYDATA0_GYDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_GYDATA0_GYDATA) & BM_HDMI_TX_GYDATA0_GYDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GYDATA field to a new value.
#define BW_HDMI_TX_GYDATA0_GYDATA(v)   (HW_HDMI_TX_GYDATA0_WR((HW_HDMI_TX_GYDATA0_RD() & ~BM_HDMI_TX_GYDATA0_GYDATA) | BF_HDMI_TX_GYDATA0_GYDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_GYDATA1 - Video Input GY Data Channel Stuffing Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_GYDATA1 - Video Input GY Data Channel Stuffing Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_gydata1
{
    reg8_t U;
    struct _hw_hdmi_tx_gydata1_bitfields
    {
        unsigned char GYDATA : 8; //!< [7:0] gydata[15:8].This register defines the value of gydata[15:8] when TX_INSTUFFING[0] (gydata_stuffing) is set to 1b.
    } B;
} hw_hdmi_tx_gydata1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_GYDATA1 register
 */
//@{
#define HW_HDMI_TX_GYDATA1_ADDR      (REGS_HDMI_BASE + 0x203)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_GYDATA1           (*(volatile hw_hdmi_tx_gydata1_t *) HW_HDMI_TX_GYDATA1_ADDR)
#define HW_HDMI_TX_GYDATA1_RD()      (HW_HDMI_TX_GYDATA1.U)
#define HW_HDMI_TX_GYDATA1_WR(v)     (HW_HDMI_TX_GYDATA1.U = (v))
#define HW_HDMI_TX_GYDATA1_SET(v)    (HW_HDMI_TX_GYDATA1_WR(HW_HDMI_TX_GYDATA1_RD() |  (v)))
#define HW_HDMI_TX_GYDATA1_CLR(v)    (HW_HDMI_TX_GYDATA1_WR(HW_HDMI_TX_GYDATA1_RD() & ~(v)))
#define HW_HDMI_TX_GYDATA1_TOG(v)    (HW_HDMI_TX_GYDATA1_WR(HW_HDMI_TX_GYDATA1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_GYDATA1 bitfields
 */

/*! @name Register HDMI_TX_GYDATA1, field GYDATA[7:0] (RW)
 *
 * gydata[15:8].This register defines the value of gydata[15:8] when TX_INSTUFFING[0]
 * (gydata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_GYDATA1_GYDATA      (0)      //!< Bit position for HDMI_TX_GYDATA1_GYDATA.
#define BM_HDMI_TX_GYDATA1_GYDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_GYDATA1_GYDATA.

//! @brief Get value of HDMI_TX_GYDATA1_GYDATA from a register value.
#define BG_HDMI_TX_GYDATA1_GYDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_GYDATA1_GYDATA) >> BP_HDMI_TX_GYDATA1_GYDATA)

//! @brief Format value for bitfield HDMI_TX_GYDATA1_GYDATA.
#define BF_HDMI_TX_GYDATA1_GYDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_GYDATA1_GYDATA) & BM_HDMI_TX_GYDATA1_GYDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GYDATA field to a new value.
#define BW_HDMI_TX_GYDATA1_GYDATA(v)   (HW_HDMI_TX_GYDATA1_WR((HW_HDMI_TX_GYDATA1_RD() & ~BM_HDMI_TX_GYDATA1_GYDATA) | BF_HDMI_TX_GYDATA1_GYDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_RCRDATA0 - Video Input RCR Data Channel Stuffing Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_RCRDATA0 - Video Input RCR Data Channel Stuffing Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_rcrdata0
{
    reg8_t U;
    struct _hw_hdmi_tx_rcrdata0_bitfields
    {
        unsigned char RCRDATA : 8; //!< [7:0] rcrdata[7:0].
    } B;
} hw_hdmi_tx_rcrdata0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_RCRDATA0 register
 */
//@{
#define HW_HDMI_TX_RCRDATA0_ADDR      (REGS_HDMI_BASE + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_RCRDATA0           (*(volatile hw_hdmi_tx_rcrdata0_t *) HW_HDMI_TX_RCRDATA0_ADDR)
#define HW_HDMI_TX_RCRDATA0_RD()      (HW_HDMI_TX_RCRDATA0.U)
#define HW_HDMI_TX_RCRDATA0_WR(v)     (HW_HDMI_TX_RCRDATA0.U = (v))
#define HW_HDMI_TX_RCRDATA0_SET(v)    (HW_HDMI_TX_RCRDATA0_WR(HW_HDMI_TX_RCRDATA0_RD() |  (v)))
#define HW_HDMI_TX_RCRDATA0_CLR(v)    (HW_HDMI_TX_RCRDATA0_WR(HW_HDMI_TX_RCRDATA0_RD() & ~(v)))
#define HW_HDMI_TX_RCRDATA0_TOG(v)    (HW_HDMI_TX_RCRDATA0_WR(HW_HDMI_TX_RCRDATA0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_RCRDATA0 bitfields
 */

/*! @name Register HDMI_TX_RCRDATA0, field RCRDATA[7:0] (RW)
 *
 * rcrdata[7:0]. This register defines the value of rcrydata[7:0] when TX_INSTUFFING[1]
 * (rcrdata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_RCRDATA0_RCRDATA      (0)      //!< Bit position for HDMI_TX_RCRDATA0_RCRDATA.
#define BM_HDMI_TX_RCRDATA0_RCRDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_RCRDATA0_RCRDATA.

//! @brief Get value of HDMI_TX_RCRDATA0_RCRDATA from a register value.
#define BG_HDMI_TX_RCRDATA0_RCRDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_RCRDATA0_RCRDATA) >> BP_HDMI_TX_RCRDATA0_RCRDATA)

//! @brief Format value for bitfield HDMI_TX_RCRDATA0_RCRDATA.
#define BF_HDMI_TX_RCRDATA0_RCRDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_RCRDATA0_RCRDATA) & BM_HDMI_TX_RCRDATA0_RCRDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RCRDATA field to a new value.
#define BW_HDMI_TX_RCRDATA0_RCRDATA(v)   (HW_HDMI_TX_RCRDATA0_WR((HW_HDMI_TX_RCRDATA0_RD() & ~BM_HDMI_TX_RCRDATA0_RCRDATA) | BF_HDMI_TX_RCRDATA0_RCRDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_RCRDATA1 - Video Input RCR Data Channel Stuffing Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_RCRDATA1 - Video Input RCR Data Channel Stuffing Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_rcrdata1
{
    reg8_t U;
    struct _hw_hdmi_tx_rcrdata1_bitfields
    {
        unsigned char RCRDATA : 8; //!< [7:0] rcrdata[15:8].
    } B;
} hw_hdmi_tx_rcrdata1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_RCRDATA1 register
 */
//@{
#define HW_HDMI_TX_RCRDATA1_ADDR      (REGS_HDMI_BASE + 0x205)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_RCRDATA1           (*(volatile hw_hdmi_tx_rcrdata1_t *) HW_HDMI_TX_RCRDATA1_ADDR)
#define HW_HDMI_TX_RCRDATA1_RD()      (HW_HDMI_TX_RCRDATA1.U)
#define HW_HDMI_TX_RCRDATA1_WR(v)     (HW_HDMI_TX_RCRDATA1.U = (v))
#define HW_HDMI_TX_RCRDATA1_SET(v)    (HW_HDMI_TX_RCRDATA1_WR(HW_HDMI_TX_RCRDATA1_RD() |  (v)))
#define HW_HDMI_TX_RCRDATA1_CLR(v)    (HW_HDMI_TX_RCRDATA1_WR(HW_HDMI_TX_RCRDATA1_RD() & ~(v)))
#define HW_HDMI_TX_RCRDATA1_TOG(v)    (HW_HDMI_TX_RCRDATA1_WR(HW_HDMI_TX_RCRDATA1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_RCRDATA1 bitfields
 */

/*! @name Register HDMI_TX_RCRDATA1, field RCRDATA[7:0] (RW)
 *
 * rcrdata[15:8]. This register defines the value of rcrydata[15:8] when TX_INSTUFFING[1]
 * (rcrdata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_RCRDATA1_RCRDATA      (0)      //!< Bit position for HDMI_TX_RCRDATA1_RCRDATA.
#define BM_HDMI_TX_RCRDATA1_RCRDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_RCRDATA1_RCRDATA.

//! @brief Get value of HDMI_TX_RCRDATA1_RCRDATA from a register value.
#define BG_HDMI_TX_RCRDATA1_RCRDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_RCRDATA1_RCRDATA) >> BP_HDMI_TX_RCRDATA1_RCRDATA)

//! @brief Format value for bitfield HDMI_TX_RCRDATA1_RCRDATA.
#define BF_HDMI_TX_RCRDATA1_RCRDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_RCRDATA1_RCRDATA) & BM_HDMI_TX_RCRDATA1_RCRDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RCRDATA field to a new value.
#define BW_HDMI_TX_RCRDATA1_RCRDATA(v)   (HW_HDMI_TX_RCRDATA1_WR((HW_HDMI_TX_RCRDATA1_RD() & ~BM_HDMI_TX_RCRDATA1_RCRDATA) | BF_HDMI_TX_RCRDATA1_RCRDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_BCBDATA0 - Video Input RCB Data Channel Stuffing Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_BCBDATA0 - Video Input RCB Data Channel Stuffing Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_bcbdata0
{
    reg8_t U;
    struct _hw_hdmi_tx_bcbdata0_bitfields
    {
        unsigned char BCBDATA : 8; //!< [7:0] bcbdata[7:0].
    } B;
} hw_hdmi_tx_bcbdata0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_BCBDATA0 register
 */
//@{
#define HW_HDMI_TX_BCBDATA0_ADDR      (REGS_HDMI_BASE + 0x206)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_BCBDATA0           (*(volatile hw_hdmi_tx_bcbdata0_t *) HW_HDMI_TX_BCBDATA0_ADDR)
#define HW_HDMI_TX_BCBDATA0_RD()      (HW_HDMI_TX_BCBDATA0.U)
#define HW_HDMI_TX_BCBDATA0_WR(v)     (HW_HDMI_TX_BCBDATA0.U = (v))
#define HW_HDMI_TX_BCBDATA0_SET(v)    (HW_HDMI_TX_BCBDATA0_WR(HW_HDMI_TX_BCBDATA0_RD() |  (v)))
#define HW_HDMI_TX_BCBDATA0_CLR(v)    (HW_HDMI_TX_BCBDATA0_WR(HW_HDMI_TX_BCBDATA0_RD() & ~(v)))
#define HW_HDMI_TX_BCBDATA0_TOG(v)    (HW_HDMI_TX_BCBDATA0_WR(HW_HDMI_TX_BCBDATA0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_BCBDATA0 bitfields
 */

/*! @name Register HDMI_TX_BCBDATA0, field BCBDATA[7:0] (RW)
 *
 * bcbdata[7:0]. This register defines the value of bcbdata[7:0] when TX_INSTUFFING[2]
 * (bcbdata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_BCBDATA0_BCBDATA      (0)      //!< Bit position for HDMI_TX_BCBDATA0_BCBDATA.
#define BM_HDMI_TX_BCBDATA0_BCBDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_BCBDATA0_BCBDATA.

//! @brief Get value of HDMI_TX_BCBDATA0_BCBDATA from a register value.
#define BG_HDMI_TX_BCBDATA0_BCBDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_BCBDATA0_BCBDATA) >> BP_HDMI_TX_BCBDATA0_BCBDATA)

//! @brief Format value for bitfield HDMI_TX_BCBDATA0_BCBDATA.
#define BF_HDMI_TX_BCBDATA0_BCBDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_BCBDATA0_BCBDATA) & BM_HDMI_TX_BCBDATA0_BCBDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCBDATA field to a new value.
#define BW_HDMI_TX_BCBDATA0_BCBDATA(v)   (HW_HDMI_TX_BCBDATA0_WR((HW_HDMI_TX_BCBDATA0_RD() & ~BM_HDMI_TX_BCBDATA0_BCBDATA) | BF_HDMI_TX_BCBDATA0_BCBDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_TX_BCBDATA1 - Video Input RCB Data Channel Stuffing Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_TX_BCBDATA1 - Video Input RCB Data Channel Stuffing Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_tx_bcbdata1
{
    reg8_t U;
    struct _hw_hdmi_tx_bcbdata1_bitfields
    {
        unsigned char BCBDATA : 8; //!< [7:0] bcbdata[15:8].
    } B;
} hw_hdmi_tx_bcbdata1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_TX_BCBDATA1 register
 */
//@{
#define HW_HDMI_TX_BCBDATA1_ADDR      (REGS_HDMI_BASE + 0x207)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_TX_BCBDATA1           (*(volatile hw_hdmi_tx_bcbdata1_t *) HW_HDMI_TX_BCBDATA1_ADDR)
#define HW_HDMI_TX_BCBDATA1_RD()      (HW_HDMI_TX_BCBDATA1.U)
#define HW_HDMI_TX_BCBDATA1_WR(v)     (HW_HDMI_TX_BCBDATA1.U = (v))
#define HW_HDMI_TX_BCBDATA1_SET(v)    (HW_HDMI_TX_BCBDATA1_WR(HW_HDMI_TX_BCBDATA1_RD() |  (v)))
#define HW_HDMI_TX_BCBDATA1_CLR(v)    (HW_HDMI_TX_BCBDATA1_WR(HW_HDMI_TX_BCBDATA1_RD() & ~(v)))
#define HW_HDMI_TX_BCBDATA1_TOG(v)    (HW_HDMI_TX_BCBDATA1_WR(HW_HDMI_TX_BCBDATA1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_TX_BCBDATA1 bitfields
 */

/*! @name Register HDMI_TX_BCBDATA1, field BCBDATA[7:0] (RW)
 *
 * bcbdata[15:8]. This register defines the value of bcbdata[15:8] when TX_INSTUFFING[2]
 * (bcbdata_stuffing) is set to 1b.
 */
//@{
#define BP_HDMI_TX_BCBDATA1_BCBDATA      (0)      //!< Bit position for HDMI_TX_BCBDATA1_BCBDATA.
#define BM_HDMI_TX_BCBDATA1_BCBDATA      (0x000000ff)  //!< Bit mask for HDMI_TX_BCBDATA1_BCBDATA.

//! @brief Get value of HDMI_TX_BCBDATA1_BCBDATA from a register value.
#define BG_HDMI_TX_BCBDATA1_BCBDATA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_TX_BCBDATA1_BCBDATA) >> BP_HDMI_TX_BCBDATA1_BCBDATA)

//! @brief Format value for bitfield HDMI_TX_BCBDATA1_BCBDATA.
#define BF_HDMI_TX_BCBDATA1_BCBDATA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_TX_BCBDATA1_BCBDATA) & BM_HDMI_TX_BCBDATA1_BCBDATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCBDATA field to a new value.
#define BW_HDMI_TX_BCBDATA1_BCBDATA(v)   (HW_HDMI_TX_BCBDATA1_WR((HW_HDMI_TX_BCBDATA1_RD() & ~BM_HDMI_TX_BCBDATA1_BCBDATA) | BF_HDMI_TX_BCBDATA1_BCBDATA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_STATUS - Video Packetizer Packing Phase Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_STATUS - Video Packetizer Packing Phase Status Register (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_vp_status
{
    reg8_t U;
    struct _hw_hdmi_vp_status_bitfields
    {
        unsigned char PACKING_PHASE : 4; //!< [3:0] Read only register that holds the "packing phase" output by the Video packetizer block.
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_vp_status_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_STATUS register
 */
//@{
#define HW_HDMI_VP_STATUS_ADDR      (REGS_HDMI_BASE + 0x800)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_STATUS           (*(volatile hw_hdmi_vp_status_t *) HW_HDMI_VP_STATUS_ADDR)
#define HW_HDMI_VP_STATUS_RD()      (HW_HDMI_VP_STATUS.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_STATUS bitfields
 */

/*! @name Register HDMI_VP_STATUS, field PACKING_PHASE[3:0] (RO)
 *
 * Read only register that holds the "packing phase" output by the Video packetizer block. For more
 * information about "packing" video data, refer to the HDMI1.4a specification. The register is
 * updated at tmds clock rate.
 */
//@{
#define BP_HDMI_VP_STATUS_PACKING_PHASE      (0)      //!< Bit position for HDMI_VP_STATUS_PACKING_PHASE.
#define BM_HDMI_VP_STATUS_PACKING_PHASE      (0x0000000f)  //!< Bit mask for HDMI_VP_STATUS_PACKING_PHASE.

//! @brief Get value of HDMI_VP_STATUS_PACKING_PHASE from a register value.
#define BG_HDMI_VP_STATUS_PACKING_PHASE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STATUS_PACKING_PHASE) >> BP_HDMI_VP_STATUS_PACKING_PHASE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_PR_CD - Video Packetizer Pixel Repetition and Color Depth Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_PR_CD - Video Packetizer Pixel Repetition and Color Depth Register (RW)
 *
 * Reset value: 0x00
 *
 * This register configures the Color Depth of the input video and Pixel repetition to apply to
 * video.
 */
typedef union _hw_hdmi_vp_pr_cd
{
    reg8_t U;
    struct _hw_hdmi_vp_pr_cd_bitfields
    {
        unsigned char DESIRED_PR_FACTOR : 4; //!< [3:0] Desired pixel repetition factor configuration.
        unsigned char COLOR_DEPTH : 4; //!< [7:4] Color depth configuration:
    } B;
} hw_hdmi_vp_pr_cd_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_PR_CD register
 */
//@{
#define HW_HDMI_VP_PR_CD_ADDR      (REGS_HDMI_BASE + 0x801)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_PR_CD           (*(volatile hw_hdmi_vp_pr_cd_t *) HW_HDMI_VP_PR_CD_ADDR)
#define HW_HDMI_VP_PR_CD_RD()      (HW_HDMI_VP_PR_CD.U)
#define HW_HDMI_VP_PR_CD_WR(v)     (HW_HDMI_VP_PR_CD.U = (v))
#define HW_HDMI_VP_PR_CD_SET(v)    (HW_HDMI_VP_PR_CD_WR(HW_HDMI_VP_PR_CD_RD() |  (v)))
#define HW_HDMI_VP_PR_CD_CLR(v)    (HW_HDMI_VP_PR_CD_WR(HW_HDMI_VP_PR_CD_RD() & ~(v)))
#define HW_HDMI_VP_PR_CD_TOG(v)    (HW_HDMI_VP_PR_CD_WR(HW_HDMI_VP_PR_CD_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_PR_CD bitfields
 */

/*! @name Register HDMI_VP_PR_CD, field DESIRED_PR_FACTOR[3:0] (RW)
 *
 * Desired pixel repetition factor configuration. The configured value sets H13T PHY PLL to multiply
 * pixel clock by the factor in order to obtain the desired repetition clock. For the CEA modes some
 * are already defined with pixel repetition in the input video. So for CEA modes this shall be
 * always 0. Shall only be used if the user wants to do pixel repetition using H13TCTRL core. other
 * Reserved. Not used.
 *
 * Values:
 * - 0000 - No pixel repetition (pixel sent only once)
 * - 0001 - Pixel sent 2 times (pixel repeated once)
 * - 0010 - Pixel sent 3 times
 * - 0011 - Pixel sent 4 times
 * - 0100 - Pixel sent 5 times
 * - 0101 - Pixel sent 6 times
 * - 0110 - Pixel sent 7 times
 * - 0111 - Pixel sent 8 times
 * - 1000 - Pixel sent 9 times
 * - 1001 - Pixel sent 10 times
 */
//@{
#define BP_HDMI_VP_PR_CD_DESIRED_PR_FACTOR      (0)      //!< Bit position for HDMI_VP_PR_CD_DESIRED_PR_FACTOR.
#define BM_HDMI_VP_PR_CD_DESIRED_PR_FACTOR      (0x0000000f)  //!< Bit mask for HDMI_VP_PR_CD_DESIRED_PR_FACTOR.

//! @brief Get value of HDMI_VP_PR_CD_DESIRED_PR_FACTOR from a register value.
#define BG_HDMI_VP_PR_CD_DESIRED_PR_FACTOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_PR_CD_DESIRED_PR_FACTOR) >> BP_HDMI_VP_PR_CD_DESIRED_PR_FACTOR)

//! @brief Format value for bitfield HDMI_VP_PR_CD_DESIRED_PR_FACTOR.
#define BF_HDMI_VP_PR_CD_DESIRED_PR_FACTOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_PR_CD_DESIRED_PR_FACTOR) & BM_HDMI_VP_PR_CD_DESIRED_PR_FACTOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DESIRED_PR_FACTOR field to a new value.
#define BW_HDMI_VP_PR_CD_DESIRED_PR_FACTOR(v)   (HW_HDMI_VP_PR_CD_WR((HW_HDMI_VP_PR_CD_RD() & ~BM_HDMI_VP_PR_CD_DESIRED_PR_FACTOR) | BF_HDMI_VP_PR_CD_DESIRED_PR_FACTOR(v)))
#endif
//@}

/*! @name Register HDMI_VP_PR_CD, field COLOR_DEPTH[7:4] (RW)
 *
 * Color depth configuration: other Reserved. Not used.
 *
 * Values:
 * - 0000 - 24 bits per pixel video (8 bit per component). 8-bit packing mode.
 * - 0100 - 24 bits per pixel video (8 bit per component). 8-bit packing mode.
 * - 0101 - 30 bits per pixel video (10 bit per component). 10-bit packing mode.
 * - 0110 - 36 bits per pixel video (12 bit per component). 12-bit packing mode.
 * - 0111 - 48 bits per pixel video (16 bit per component). 16-bit packing mode.
 */
//@{
#define BP_HDMI_VP_PR_CD_COLOR_DEPTH      (4)      //!< Bit position for HDMI_VP_PR_CD_COLOR_DEPTH.
#define BM_HDMI_VP_PR_CD_COLOR_DEPTH      (0x000000f0)  //!< Bit mask for HDMI_VP_PR_CD_COLOR_DEPTH.

//! @brief Get value of HDMI_VP_PR_CD_COLOR_DEPTH from a register value.
#define BG_HDMI_VP_PR_CD_COLOR_DEPTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_PR_CD_COLOR_DEPTH) >> BP_HDMI_VP_PR_CD_COLOR_DEPTH)

//! @brief Format value for bitfield HDMI_VP_PR_CD_COLOR_DEPTH.
#define BF_HDMI_VP_PR_CD_COLOR_DEPTH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_PR_CD_COLOR_DEPTH) & BM_HDMI_VP_PR_CD_COLOR_DEPTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COLOR_DEPTH field to a new value.
#define BW_HDMI_VP_PR_CD_COLOR_DEPTH(v)   (HW_HDMI_VP_PR_CD_WR((HW_HDMI_VP_PR_CD_RD() & ~BM_HDMI_VP_PR_CD_COLOR_DEPTH) | BF_HDMI_VP_PR_CD_COLOR_DEPTH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_STUFF - Video Packetizer Stuffing and Default Packing Phase Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_STUFF - Video Packetizer Stuffing and Default Packing Phase Register (RW)
 *
 * Reset value: 0x00
 *
 * This register controls the Pixel repetition, pixel packing and YCC422 stuffing.
 */
typedef union _hw_hdmi_vp_stuff
{
    reg8_t U;
    struct _hw_hdmi_vp_stuff_bitfields
    {
        unsigned char PR_STUFFING : 1; //!< [0] Pixel repeater stuffing control
        unsigned char PP_STUFFING : 1; //!< [1] Pixel packing stuffing control
        unsigned char YCC422_STUFFING : 1; //!< [2] YCC 422 remap stuffing control.
        unsigned char ICX_GOTO_P0_ST : 1; //!< [3] Reserved.
        unsigned char IFIX_PP_TO_LAST : 1; //!< [4] Reserved.
        unsigned char IDEFAULT_PHASE : 1; //!< [5] Controls the default phase packing machine used according to: "If the transmitted video format has timing such that the phase of the first pixel of every Video Data Period corresponds to pixel packing phase 0 (for example, 10P0, 12P0, 16P0), the Source may set the Default_Phase bit in the GCP.
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_vp_stuff_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_STUFF register
 */
//@{
#define HW_HDMI_VP_STUFF_ADDR      (REGS_HDMI_BASE + 0x802)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_STUFF           (*(volatile hw_hdmi_vp_stuff_t *) HW_HDMI_VP_STUFF_ADDR)
#define HW_HDMI_VP_STUFF_RD()      (HW_HDMI_VP_STUFF.U)
#define HW_HDMI_VP_STUFF_WR(v)     (HW_HDMI_VP_STUFF.U = (v))
#define HW_HDMI_VP_STUFF_SET(v)    (HW_HDMI_VP_STUFF_WR(HW_HDMI_VP_STUFF_RD() |  (v)))
#define HW_HDMI_VP_STUFF_CLR(v)    (HW_HDMI_VP_STUFF_WR(HW_HDMI_VP_STUFF_RD() & ~(v)))
#define HW_HDMI_VP_STUFF_TOG(v)    (HW_HDMI_VP_STUFF_WR(HW_HDMI_VP_STUFF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_STUFF bitfields
 */

/*! @name Register HDMI_VP_STUFF, field PR_STUFFING[0] (RW)
 *
 * Pixel repeater stuffing control
 *
 * Values:
 * - 0 - Pixel repeater block in direct mode (input blanking data goes directly to output).
 * - 1 - Pixel repeater block in stuffing mode. When "de" goes to low the outputs are fixed to 0x00.
 */
//@{
#define BP_HDMI_VP_STUFF_PR_STUFFING      (0)      //!< Bit position for HDMI_VP_STUFF_PR_STUFFING.
#define BM_HDMI_VP_STUFF_PR_STUFFING      (0x00000001)  //!< Bit mask for HDMI_VP_STUFF_PR_STUFFING.

//! @brief Get value of HDMI_VP_STUFF_PR_STUFFING from a register value.
#define BG_HDMI_VP_STUFF_PR_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_PR_STUFFING) >> BP_HDMI_VP_STUFF_PR_STUFFING)

//! @brief Format value for bitfield HDMI_VP_STUFF_PR_STUFFING.
#define BF_HDMI_VP_STUFF_PR_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_PR_STUFFING) & BM_HDMI_VP_STUFF_PR_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PR_STUFFING field to a new value.
#define BW_HDMI_VP_STUFF_PR_STUFFING(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_PR_STUFFING) | BF_HDMI_VP_STUFF_PR_STUFFING(v)))
#endif
//@}

/*! @name Register HDMI_VP_STUFF, field PP_STUFFING[1] (RW)
 *
 * Pixel packing stuffing control
 *
 * Values:
 * - 0 - Pixel packing block in direct mode (input blanking data goes directly to output).
 * - 1 - Pixel packing block in stuffing mode. When "de_rep" goes to low the outputs are fixed to 0x00.
 */
//@{
#define BP_HDMI_VP_STUFF_PP_STUFFING      (1)      //!< Bit position for HDMI_VP_STUFF_PP_STUFFING.
#define BM_HDMI_VP_STUFF_PP_STUFFING      (0x00000002)  //!< Bit mask for HDMI_VP_STUFF_PP_STUFFING.

//! @brief Get value of HDMI_VP_STUFF_PP_STUFFING from a register value.
#define BG_HDMI_VP_STUFF_PP_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_PP_STUFFING) >> BP_HDMI_VP_STUFF_PP_STUFFING)

//! @brief Format value for bitfield HDMI_VP_STUFF_PP_STUFFING.
#define BF_HDMI_VP_STUFF_PP_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_PP_STUFFING) & BM_HDMI_VP_STUFF_PP_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_STUFFING field to a new value.
#define BW_HDMI_VP_STUFF_PP_STUFFING(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_PP_STUFFING) | BF_HDMI_VP_STUFF_PP_STUFFING(v)))
#endif
//@}

/*! @name Register HDMI_VP_STUFF, field YCC422_STUFFING[2] (RW)
 *
 * YCC 422 remap stuffing control. For horizontal blanking:
 *
 * Values:
 * - 0 - YCC 422 remap block in direct mode (input blanking data goes directly to output).
 * - 1 - YCC 422 remap block in stuffing mode. When "de" goes to low the outputs are fixed to 0x00.
 */
//@{
#define BP_HDMI_VP_STUFF_YCC422_STUFFING      (2)      //!< Bit position for HDMI_VP_STUFF_YCC422_STUFFING.
#define BM_HDMI_VP_STUFF_YCC422_STUFFING      (0x00000004)  //!< Bit mask for HDMI_VP_STUFF_YCC422_STUFFING.

//! @brief Get value of HDMI_VP_STUFF_YCC422_STUFFING from a register value.
#define BG_HDMI_VP_STUFF_YCC422_STUFFING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_YCC422_STUFFING) >> BP_HDMI_VP_STUFF_YCC422_STUFFING)

//! @brief Format value for bitfield HDMI_VP_STUFF_YCC422_STUFFING.
#define BF_HDMI_VP_STUFF_YCC422_STUFFING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_YCC422_STUFFING) & BM_HDMI_VP_STUFF_YCC422_STUFFING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the YCC422_STUFFING field to a new value.
#define BW_HDMI_VP_STUFF_YCC422_STUFFING(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_YCC422_STUFFING) | BF_HDMI_VP_STUFF_YCC422_STUFFING(v)))
#endif
//@}

/*! @name Register HDMI_VP_STUFF, field ICX_GOTO_P0_ST[3] (RW)
 *
 * Reserved. Controls packing machine strategy.
 */
//@{
#define BP_HDMI_VP_STUFF_ICX_GOTO_P0_ST      (3)      //!< Bit position for HDMI_VP_STUFF_ICX_GOTO_P0_ST.
#define BM_HDMI_VP_STUFF_ICX_GOTO_P0_ST      (0x00000008)  //!< Bit mask for HDMI_VP_STUFF_ICX_GOTO_P0_ST.

//! @brief Get value of HDMI_VP_STUFF_ICX_GOTO_P0_ST from a register value.
#define BG_HDMI_VP_STUFF_ICX_GOTO_P0_ST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_ICX_GOTO_P0_ST) >> BP_HDMI_VP_STUFF_ICX_GOTO_P0_ST)

//! @brief Format value for bitfield HDMI_VP_STUFF_ICX_GOTO_P0_ST.
#define BF_HDMI_VP_STUFF_ICX_GOTO_P0_ST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_ICX_GOTO_P0_ST) & BM_HDMI_VP_STUFF_ICX_GOTO_P0_ST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ICX_GOTO_P0_ST field to a new value.
#define BW_HDMI_VP_STUFF_ICX_GOTO_P0_ST(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_ICX_GOTO_P0_ST) | BF_HDMI_VP_STUFF_ICX_GOTO_P0_ST(v)))
#endif
//@}

/*! @name Register HDMI_VP_STUFF, field IFIX_PP_TO_LAST[4] (RW)
 *
 * Reserved. Controls packing machine strategy.
 */
//@{
#define BP_HDMI_VP_STUFF_IFIX_PP_TO_LAST      (4)      //!< Bit position for HDMI_VP_STUFF_IFIX_PP_TO_LAST.
#define BM_HDMI_VP_STUFF_IFIX_PP_TO_LAST      (0x00000010)  //!< Bit mask for HDMI_VP_STUFF_IFIX_PP_TO_LAST.

//! @brief Get value of HDMI_VP_STUFF_IFIX_PP_TO_LAST from a register value.
#define BG_HDMI_VP_STUFF_IFIX_PP_TO_LAST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_IFIX_PP_TO_LAST) >> BP_HDMI_VP_STUFF_IFIX_PP_TO_LAST)

//! @brief Format value for bitfield HDMI_VP_STUFF_IFIX_PP_TO_LAST.
#define BF_HDMI_VP_STUFF_IFIX_PP_TO_LAST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_IFIX_PP_TO_LAST) & BM_HDMI_VP_STUFF_IFIX_PP_TO_LAST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IFIX_PP_TO_LAST field to a new value.
#define BW_HDMI_VP_STUFF_IFIX_PP_TO_LAST(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_IFIX_PP_TO_LAST) | BF_HDMI_VP_STUFF_IFIX_PP_TO_LAST(v)))
#endif
//@}

/*! @name Register HDMI_VP_STUFF, field IDEFAULT_PHASE[5] (RW)
 *
 * Controls the default phase packing machine used according to: "If the transmitted video format
 * has timing such that the phase of the first pixel of every Video Data Period corresponds to pixel
 * packing phase 0 (for example, 10P0, 12P0, 16P0), the Source may set the Default_Phase bit in the
 * GCP. The Sink may use this bit to optimize it's filtering or handling of the PP field." (HDMI
 * specification version 1.4a) This means that for10 bit mode the Htotal must be dividable by 4 and
 * for 12 bit mode the Htotal must be dividable by 2.
 */
//@{
#define BP_HDMI_VP_STUFF_IDEFAULT_PHASE      (5)      //!< Bit position for HDMI_VP_STUFF_IDEFAULT_PHASE.
#define BM_HDMI_VP_STUFF_IDEFAULT_PHASE      (0x00000020)  //!< Bit mask for HDMI_VP_STUFF_IDEFAULT_PHASE.

//! @brief Get value of HDMI_VP_STUFF_IDEFAULT_PHASE from a register value.
#define BG_HDMI_VP_STUFF_IDEFAULT_PHASE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_STUFF_IDEFAULT_PHASE) >> BP_HDMI_VP_STUFF_IDEFAULT_PHASE)

//! @brief Format value for bitfield HDMI_VP_STUFF_IDEFAULT_PHASE.
#define BF_HDMI_VP_STUFF_IDEFAULT_PHASE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_STUFF_IDEFAULT_PHASE) & BM_HDMI_VP_STUFF_IDEFAULT_PHASE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDEFAULT_PHASE field to a new value.
#define BW_HDMI_VP_STUFF_IDEFAULT_PHASE(v)   (HW_HDMI_VP_STUFF_WR((HW_HDMI_VP_STUFF_RD() & ~BM_HDMI_VP_STUFF_IDEFAULT_PHASE) | BF_HDMI_VP_STUFF_IDEFAULT_PHASE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_REMAP - Video Packetizer YCC422 Remapping Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_REMAP - Video Packetizer YCC422 Remapping Register (RW)
 *
 * Reset value: 0x00
 *
 * This register controls YCC422 remap of the Video Packetizer. For more information about YCC422
 * remap refer to HDMI 1.4a specification.
 */
typedef union _hw_hdmi_vp_remap
{
    reg8_t U;
    struct _hw_hdmi_vp_remap_bitfields
    {
        unsigned char YCC422_SIZE : 2; //!< [1:0] YCC 422 remap input video size:
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_vp_remap_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_REMAP register
 */
//@{
#define HW_HDMI_VP_REMAP_ADDR      (REGS_HDMI_BASE + 0x803)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_REMAP           (*(volatile hw_hdmi_vp_remap_t *) HW_HDMI_VP_REMAP_ADDR)
#define HW_HDMI_VP_REMAP_RD()      (HW_HDMI_VP_REMAP.U)
#define HW_HDMI_VP_REMAP_WR(v)     (HW_HDMI_VP_REMAP.U = (v))
#define HW_HDMI_VP_REMAP_SET(v)    (HW_HDMI_VP_REMAP_WR(HW_HDMI_VP_REMAP_RD() |  (v)))
#define HW_HDMI_VP_REMAP_CLR(v)    (HW_HDMI_VP_REMAP_WR(HW_HDMI_VP_REMAP_RD() & ~(v)))
#define HW_HDMI_VP_REMAP_TOG(v)    (HW_HDMI_VP_REMAP_WR(HW_HDMI_VP_REMAP_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_REMAP bitfields
 */

/*! @name Register HDMI_VP_REMAP, field YCC422_SIZE[1:0] (RW)
 *
 * YCC 422 remap input video size:
 *
 * Values:
 * - 00 - YCC 422 16-bit input video (8 bits per component).
 * - 01 - YCC 422 20-bit input video (10 bits per component).
 * - 10 - YCC 422 24-bit input video (12 bits per component).
 * - 11 - Reserved. Not used.
 */
//@{
#define BP_HDMI_VP_REMAP_YCC422_SIZE      (0)      //!< Bit position for HDMI_VP_REMAP_YCC422_SIZE.
#define BM_HDMI_VP_REMAP_YCC422_SIZE      (0x00000003)  //!< Bit mask for HDMI_VP_REMAP_YCC422_SIZE.

//! @brief Get value of HDMI_VP_REMAP_YCC422_SIZE from a register value.
#define BG_HDMI_VP_REMAP_YCC422_SIZE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_REMAP_YCC422_SIZE) >> BP_HDMI_VP_REMAP_YCC422_SIZE)

//! @brief Format value for bitfield HDMI_VP_REMAP_YCC422_SIZE.
#define BF_HDMI_VP_REMAP_YCC422_SIZE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_REMAP_YCC422_SIZE) & BM_HDMI_VP_REMAP_YCC422_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the YCC422_SIZE field to a new value.
#define BW_HDMI_VP_REMAP_YCC422_SIZE(v)   (HW_HDMI_VP_REMAP_WR((HW_HDMI_VP_REMAP_RD() & ~BM_HDMI_VP_REMAP_YCC422_SIZE) | BF_HDMI_VP_REMAP_YCC422_SIZE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_CONF - Video Packetizer Output, Bypass, and Enable Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_CONF - Video Packetizer Output, Bypass, and Enable Configuration Register (RW)
 *
 * Reset value: 0x46
 *
 * This register controls the Video Packetizer output selection, bypass select, YCC422 enable, Pixel
 * repeater, and pixel packing enabling.
 */
typedef union _hw_hdmi_vp_conf
{
    reg8_t U;
    struct _hw_hdmi_vp_conf_bitfields
    {
        unsigned char OUTPUT_SELECTOR : 2; //!< [1:0] Video packetizer output selection.
        unsigned char BYPASS_SELECT : 1; //!< [2] 
        unsigned char YCC422_EN : 1; //!< [3] YCC 422 select enable.
        unsigned char PR_EN : 1; //!< [4] Pixel repeater enable.
        unsigned char PP_EN : 1; //!< [5] Pixel packing enable.
        unsigned char BYPASS_EN : 1; //!< [6] Bypass enable.
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_vp_conf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_CONF register
 */
//@{
#define HW_HDMI_VP_CONF_ADDR      (REGS_HDMI_BASE + 0x804)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_CONF           (*(volatile hw_hdmi_vp_conf_t *) HW_HDMI_VP_CONF_ADDR)
#define HW_HDMI_VP_CONF_RD()      (HW_HDMI_VP_CONF.U)
#define HW_HDMI_VP_CONF_WR(v)     (HW_HDMI_VP_CONF.U = (v))
#define HW_HDMI_VP_CONF_SET(v)    (HW_HDMI_VP_CONF_WR(HW_HDMI_VP_CONF_RD() |  (v)))
#define HW_HDMI_VP_CONF_CLR(v)    (HW_HDMI_VP_CONF_WR(HW_HDMI_VP_CONF_RD() & ~(v)))
#define HW_HDMI_VP_CONF_TOG(v)    (HW_HDMI_VP_CONF_WR(HW_HDMI_VP_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_CONF bitfields
 */

/*! @name Register HDMI_VP_CONF, field OUTPUT_SELECTOR[1:0] (RW)
 *
 * Video packetizer output selection.
 *
 * Values:
 * - 00 - Data from pixel packing block.
 * - 01 - Data from YCC 422 remap block.
 * - 10 - Data from 8-bit bypass block.
 * - 11 - Data from 8-bit bypass block.
 */
//@{
#define BP_HDMI_VP_CONF_OUTPUT_SELECTOR      (0)      //!< Bit position for HDMI_VP_CONF_OUTPUT_SELECTOR.
#define BM_HDMI_VP_CONF_OUTPUT_SELECTOR      (0x00000003)  //!< Bit mask for HDMI_VP_CONF_OUTPUT_SELECTOR.

//! @brief Get value of HDMI_VP_CONF_OUTPUT_SELECTOR from a register value.
#define BG_HDMI_VP_CONF_OUTPUT_SELECTOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_OUTPUT_SELECTOR) >> BP_HDMI_VP_CONF_OUTPUT_SELECTOR)

//! @brief Format value for bitfield HDMI_VP_CONF_OUTPUT_SELECTOR.
#define BF_HDMI_VP_CONF_OUTPUT_SELECTOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_OUTPUT_SELECTOR) & BM_HDMI_VP_CONF_OUTPUT_SELECTOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTPUT_SELECTOR field to a new value.
#define BW_HDMI_VP_CONF_OUTPUT_SELECTOR(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_OUTPUT_SELECTOR) | BF_HDMI_VP_CONF_OUTPUT_SELECTOR(v)))
#endif
//@}

/*! @name Register HDMI_VP_CONF, field BYPASS_SELECT[2] (RW)
 *
 * Values:
 * - 0 - Data from pixel repeater block.
 * - 1 - Data from input of video packetizer block.
 */
//@{
#define BP_HDMI_VP_CONF_BYPASS_SELECT      (2)      //!< Bit position for HDMI_VP_CONF_BYPASS_SELECT.
#define BM_HDMI_VP_CONF_BYPASS_SELECT      (0x00000004)  //!< Bit mask for HDMI_VP_CONF_BYPASS_SELECT.

//! @brief Get value of HDMI_VP_CONF_BYPASS_SELECT from a register value.
#define BG_HDMI_VP_CONF_BYPASS_SELECT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_BYPASS_SELECT) >> BP_HDMI_VP_CONF_BYPASS_SELECT)

//! @brief Format value for bitfield HDMI_VP_CONF_BYPASS_SELECT.
#define BF_HDMI_VP_CONF_BYPASS_SELECT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_BYPASS_SELECT) & BM_HDMI_VP_CONF_BYPASS_SELECT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BYPASS_SELECT field to a new value.
#define BW_HDMI_VP_CONF_BYPASS_SELECT(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_BYPASS_SELECT) | BF_HDMI_VP_CONF_BYPASS_SELECT(v)))
#endif
//@}

/*! @name Register HDMI_VP_CONF, field YCC422_EN[3] (RW)
 *
 * YCC 422 select enable. Disabling forces bypass module to output always zeros.
 */
//@{
#define BP_HDMI_VP_CONF_YCC422_EN      (3)      //!< Bit position for HDMI_VP_CONF_YCC422_EN.
#define BM_HDMI_VP_CONF_YCC422_EN      (0x00000008)  //!< Bit mask for HDMI_VP_CONF_YCC422_EN.

//! @brief Get value of HDMI_VP_CONF_YCC422_EN from a register value.
#define BG_HDMI_VP_CONF_YCC422_EN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_YCC422_EN) >> BP_HDMI_VP_CONF_YCC422_EN)

//! @brief Format value for bitfield HDMI_VP_CONF_YCC422_EN.
#define BF_HDMI_VP_CONF_YCC422_EN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_YCC422_EN) & BM_HDMI_VP_CONF_YCC422_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the YCC422_EN field to a new value.
#define BW_HDMI_VP_CONF_YCC422_EN(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_YCC422_EN) | BF_HDMI_VP_CONF_YCC422_EN(v)))
#endif
//@}

/*! @name Register HDMI_VP_CONF, field PR_EN[4] (RW)
 *
 * Pixel repeater enable. Disabling forces bypass module to output always zeros.
 */
//@{
#define BP_HDMI_VP_CONF_PR_EN      (4)      //!< Bit position for HDMI_VP_CONF_PR_EN.
#define BM_HDMI_VP_CONF_PR_EN      (0x00000010)  //!< Bit mask for HDMI_VP_CONF_PR_EN.

//! @brief Get value of HDMI_VP_CONF_PR_EN from a register value.
#define BG_HDMI_VP_CONF_PR_EN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_PR_EN) >> BP_HDMI_VP_CONF_PR_EN)

//! @brief Format value for bitfield HDMI_VP_CONF_PR_EN.
#define BF_HDMI_VP_CONF_PR_EN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_PR_EN) & BM_HDMI_VP_CONF_PR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PR_EN field to a new value.
#define BW_HDMI_VP_CONF_PR_EN(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_PR_EN) | BF_HDMI_VP_CONF_PR_EN(v)))
#endif
//@}

/*! @name Register HDMI_VP_CONF, field PP_EN[5] (RW)
 *
 * Pixel packing enable. Disabling forces bypass module to output always zeros.
 */
//@{
#define BP_HDMI_VP_CONF_PP_EN      (5)      //!< Bit position for HDMI_VP_CONF_PP_EN.
#define BM_HDMI_VP_CONF_PP_EN      (0x00000020)  //!< Bit mask for HDMI_VP_CONF_PP_EN.

//! @brief Get value of HDMI_VP_CONF_PP_EN from a register value.
#define BG_HDMI_VP_CONF_PP_EN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_PP_EN) >> BP_HDMI_VP_CONF_PP_EN)

//! @brief Format value for bitfield HDMI_VP_CONF_PP_EN.
#define BF_HDMI_VP_CONF_PP_EN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_PP_EN) & BM_HDMI_VP_CONF_PP_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_EN field to a new value.
#define BW_HDMI_VP_CONF_PP_EN(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_PP_EN) | BF_HDMI_VP_CONF_PP_EN(v)))
#endif
//@}

/*! @name Register HDMI_VP_CONF, field BYPASS_EN[6] (RW)
 *
 * Bypass enable. Disabling forces bypass module to output always zeros.
 */
//@{
#define BP_HDMI_VP_CONF_BYPASS_EN      (6)      //!< Bit position for HDMI_VP_CONF_BYPASS_EN.
#define BM_HDMI_VP_CONF_BYPASS_EN      (0x00000040)  //!< Bit mask for HDMI_VP_CONF_BYPASS_EN.

//! @brief Get value of HDMI_VP_CONF_BYPASS_EN from a register value.
#define BG_HDMI_VP_CONF_BYPASS_EN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_CONF_BYPASS_EN) >> BP_HDMI_VP_CONF_BYPASS_EN)

//! @brief Format value for bitfield HDMI_VP_CONF_BYPASS_EN.
#define BF_HDMI_VP_CONF_BYPASS_EN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_CONF_BYPASS_EN) & BM_HDMI_VP_CONF_BYPASS_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BYPASS_EN field to a new value.
#define BW_HDMI_VP_CONF_BYPASS_EN(v)   (HW_HDMI_VP_CONF_WR((HW_HDMI_VP_CONF_RD() & ~BM_HDMI_VP_CONF_BYPASS_EN) | BF_HDMI_VP_CONF_BYPASS_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_VP_MASK - Video Packetizer Interrupt Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_VP_MASK - Video Packetizer Interrupt Mask Register (RW)
 *
 * Reset value: 0x00
 *
 * Mask register for generation of VP_INT interrupts.
 */
typedef union _hw_hdmi_vp_mask
{
    reg8_t U;
    struct _hw_hdmi_vp_mask_bitfields
    {
        unsigned char VPMASK : 1; //!< [0] Mask bit for VP_INT[0] interrupt bit.
        unsigned char VPMASK1 : 1; //!< [1] Mask bit for VP_INT[1] interrupt bit.
        unsigned char VPMASK2 : 1; //!< [2] Mask bit for VP_INT[2] interrupt bit.
        unsigned char VPMASK3 : 1; //!< [3] Mask bit for VP_INT[3] interrupt bit.
        unsigned char VPMASK4 : 1; //!< [4] Mask bit for VP_INT[4] interrupt bit.
        unsigned char VPMASK5 : 1; //!< [5] Mask bit for VP_INT[5] interrupt bit.
        unsigned char VPMASK6 : 1; //!< [6] Mask bit for VP_INT[6] interrupt bit.
        unsigned char VPMASK7 : 1; //!< [7] Mask bit for VP_INT[7] interrupt bit.
    } B;
} hw_hdmi_vp_mask_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_VP_MASK register
 */
//@{
#define HW_HDMI_VP_MASK_ADDR      (REGS_HDMI_BASE + 0x807)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_VP_MASK           (*(volatile hw_hdmi_vp_mask_t *) HW_HDMI_VP_MASK_ADDR)
#define HW_HDMI_VP_MASK_RD()      (HW_HDMI_VP_MASK.U)
#define HW_HDMI_VP_MASK_WR(v)     (HW_HDMI_VP_MASK.U = (v))
#define HW_HDMI_VP_MASK_SET(v)    (HW_HDMI_VP_MASK_WR(HW_HDMI_VP_MASK_RD() |  (v)))
#define HW_HDMI_VP_MASK_CLR(v)    (HW_HDMI_VP_MASK_WR(HW_HDMI_VP_MASK_RD() & ~(v)))
#define HW_HDMI_VP_MASK_TOG(v)    (HW_HDMI_VP_MASK_WR(HW_HDMI_VP_MASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_VP_MASK bitfields
 */

/*! @name Register HDMI_VP_MASK, field VPMASK[0] (RW)
 *
 * Mask bit for VP_INT[0] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK      (0)      //!< Bit position for HDMI_VP_MASK_VPMASK.
#define BM_HDMI_VP_MASK_VPMASK      (0x00000001)  //!< Bit mask for HDMI_VP_MASK_VPMASK.

//! @brief Get value of HDMI_VP_MASK_VPMASK from a register value.
#define BG_HDMI_VP_MASK_VPMASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK) >> BP_HDMI_VP_MASK_VPMASK)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK.
#define BF_HDMI_VP_MASK_VPMASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK) & BM_HDMI_VP_MASK_VPMASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK field to a new value.
#define BW_HDMI_VP_MASK_VPMASK(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK) | BF_HDMI_VP_MASK_VPMASK(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK1[1] (RW)
 *
 * Mask bit for VP_INT[1] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK1      (1)      //!< Bit position for HDMI_VP_MASK_VPMASK1.
#define BM_HDMI_VP_MASK_VPMASK1      (0x00000002)  //!< Bit mask for HDMI_VP_MASK_VPMASK1.

//! @brief Get value of HDMI_VP_MASK_VPMASK1 from a register value.
#define BG_HDMI_VP_MASK_VPMASK1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK1) >> BP_HDMI_VP_MASK_VPMASK1)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK1.
#define BF_HDMI_VP_MASK_VPMASK1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK1) & BM_HDMI_VP_MASK_VPMASK1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK1 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK1(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK1) | BF_HDMI_VP_MASK_VPMASK1(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK2[2] (RW)
 *
 * Mask bit for VP_INT[2] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK2      (2)      //!< Bit position for HDMI_VP_MASK_VPMASK2.
#define BM_HDMI_VP_MASK_VPMASK2      (0x00000004)  //!< Bit mask for HDMI_VP_MASK_VPMASK2.

//! @brief Get value of HDMI_VP_MASK_VPMASK2 from a register value.
#define BG_HDMI_VP_MASK_VPMASK2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK2) >> BP_HDMI_VP_MASK_VPMASK2)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK2.
#define BF_HDMI_VP_MASK_VPMASK2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK2) & BM_HDMI_VP_MASK_VPMASK2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK2 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK2(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK2) | BF_HDMI_VP_MASK_VPMASK2(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK3[3] (RW)
 *
 * Mask bit for VP_INT[3] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK3      (3)      //!< Bit position for HDMI_VP_MASK_VPMASK3.
#define BM_HDMI_VP_MASK_VPMASK3      (0x00000008)  //!< Bit mask for HDMI_VP_MASK_VPMASK3.

//! @brief Get value of HDMI_VP_MASK_VPMASK3 from a register value.
#define BG_HDMI_VP_MASK_VPMASK3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK3) >> BP_HDMI_VP_MASK_VPMASK3)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK3.
#define BF_HDMI_VP_MASK_VPMASK3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK3) & BM_HDMI_VP_MASK_VPMASK3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK3 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK3(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK3) | BF_HDMI_VP_MASK_VPMASK3(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK4[4] (RW)
 *
 * Mask bit for VP_INT[4] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK4      (4)      //!< Bit position for HDMI_VP_MASK_VPMASK4.
#define BM_HDMI_VP_MASK_VPMASK4      (0x00000010)  //!< Bit mask for HDMI_VP_MASK_VPMASK4.

//! @brief Get value of HDMI_VP_MASK_VPMASK4 from a register value.
#define BG_HDMI_VP_MASK_VPMASK4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK4) >> BP_HDMI_VP_MASK_VPMASK4)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK4.
#define BF_HDMI_VP_MASK_VPMASK4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK4) & BM_HDMI_VP_MASK_VPMASK4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK4 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK4(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK4) | BF_HDMI_VP_MASK_VPMASK4(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK5[5] (RW)
 *
 * Mask bit for VP_INT[5] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK5      (5)      //!< Bit position for HDMI_VP_MASK_VPMASK5.
#define BM_HDMI_VP_MASK_VPMASK5      (0x00000020)  //!< Bit mask for HDMI_VP_MASK_VPMASK5.

//! @brief Get value of HDMI_VP_MASK_VPMASK5 from a register value.
#define BG_HDMI_VP_MASK_VPMASK5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK5) >> BP_HDMI_VP_MASK_VPMASK5)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK5.
#define BF_HDMI_VP_MASK_VPMASK5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK5) & BM_HDMI_VP_MASK_VPMASK5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK5 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK5(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK5) | BF_HDMI_VP_MASK_VPMASK5(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK6[6] (RW)
 *
 * Mask bit for VP_INT[6] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK6      (6)      //!< Bit position for HDMI_VP_MASK_VPMASK6.
#define BM_HDMI_VP_MASK_VPMASK6      (0x00000040)  //!< Bit mask for HDMI_VP_MASK_VPMASK6.

//! @brief Get value of HDMI_VP_MASK_VPMASK6 from a register value.
#define BG_HDMI_VP_MASK_VPMASK6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK6) >> BP_HDMI_VP_MASK_VPMASK6)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK6.
#define BF_HDMI_VP_MASK_VPMASK6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK6) & BM_HDMI_VP_MASK_VPMASK6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK6 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK6(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK6) | BF_HDMI_VP_MASK_VPMASK6(v)))
#endif
//@}

/*! @name Register HDMI_VP_MASK, field VPMASK7[7] (RW)
 *
 * Mask bit for VP_INT[7] interrupt bit.
 */
//@{
#define BP_HDMI_VP_MASK_VPMASK7      (7)      //!< Bit position for HDMI_VP_MASK_VPMASK7.
#define BM_HDMI_VP_MASK_VPMASK7      (0x00000080)  //!< Bit mask for HDMI_VP_MASK_VPMASK7.

//! @brief Get value of HDMI_VP_MASK_VPMASK7 from a register value.
#define BG_HDMI_VP_MASK_VPMASK7(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_VP_MASK_VPMASK7) >> BP_HDMI_VP_MASK_VPMASK7)

//! @brief Format value for bitfield HDMI_VP_MASK_VPMASK7.
#define BF_HDMI_VP_MASK_VPMASK7(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_VP_MASK_VPMASK7) & BM_HDMI_VP_MASK_VPMASK7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPMASK7 field to a new value.
#define BW_HDMI_VP_MASK_VPMASK7(v)   (HW_HDMI_VP_MASK_WR((HW_HDMI_VP_MASK_RD() & ~BM_HDMI_VP_MASK_VPMASK7) | BF_HDMI_VP_MASK_VPMASK7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INVIDCONF - Frame Composer Input Video Configuration and HDCP Keepout Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INVIDCONF - Frame Composer Input Video Configuration and HDCP Keepout Register (RW)
 *
 * Reset value: 0x70
 *
 * This register configures the Interlaced/progressive, Vblank variation and polarity of all video
 * synchronism of the input video signal.
 */
typedef union _hw_hdmi_fc_invidconf
{
    reg8_t U;
    struct _hw_hdmi_fc_invidconf_bitfields
    {
        unsigned char IN_I_P : 1; //!< [0] Input video mode:
        unsigned char R_V_BLANK_IN_OSC : 1; //!< [1] Used for CEA861-D modes with fractional Vblank (for example, modes 5, 6, 7, 10, 11, 20, 21, and 22.
        unsigned char RESERVED0 : 1; //!< [2] Reserved
        unsigned char DVI_MODEZ : 1; //!< [3] Active low
        unsigned char DE_IN_POLARITY : 1; //!< [4] Data enable input polarity
        unsigned char HSYNC_IN_POLARITY : 1; //!< [5] Hsync input polarity
        unsigned char VSYNC_IN_POLARITY : 1; //!< [6] Vsync input polarity
        unsigned char HDCP_KEEPOUT : 1; //!< [7] Start/stop HDCP keepout window generation
    } B;
} hw_hdmi_fc_invidconf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INVIDCONF register
 */
//@{
#define HW_HDMI_FC_INVIDCONF_ADDR      (REGS_HDMI_BASE + 0x1000)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INVIDCONF           (*(volatile hw_hdmi_fc_invidconf_t *) HW_HDMI_FC_INVIDCONF_ADDR)
#define HW_HDMI_FC_INVIDCONF_RD()      (HW_HDMI_FC_INVIDCONF.U)
#define HW_HDMI_FC_INVIDCONF_WR(v)     (HW_HDMI_FC_INVIDCONF.U = (v))
#define HW_HDMI_FC_INVIDCONF_SET(v)    (HW_HDMI_FC_INVIDCONF_WR(HW_HDMI_FC_INVIDCONF_RD() |  (v)))
#define HW_HDMI_FC_INVIDCONF_CLR(v)    (HW_HDMI_FC_INVIDCONF_WR(HW_HDMI_FC_INVIDCONF_RD() & ~(v)))
#define HW_HDMI_FC_INVIDCONF_TOG(v)    (HW_HDMI_FC_INVIDCONF_WR(HW_HDMI_FC_INVIDCONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INVIDCONF bitfields
 */

/*! @name Register HDMI_FC_INVIDCONF, field IN_I_P[0] (RW)
 *
 * Input video mode:
 *
 * Values:
 * - 0 - Progressive
 * - 1 - Interlaced
 */
//@{
#define BP_HDMI_FC_INVIDCONF_IN_I_P      (0)      //!< Bit position for HDMI_FC_INVIDCONF_IN_I_P.
#define BM_HDMI_FC_INVIDCONF_IN_I_P      (0x00000001)  //!< Bit mask for HDMI_FC_INVIDCONF_IN_I_P.

//! @brief Get value of HDMI_FC_INVIDCONF_IN_I_P from a register value.
#define BG_HDMI_FC_INVIDCONF_IN_I_P(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_IN_I_P) >> BP_HDMI_FC_INVIDCONF_IN_I_P)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_IN_I_P.
#define BF_HDMI_FC_INVIDCONF_IN_I_P(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_IN_I_P) & BM_HDMI_FC_INVIDCONF_IN_I_P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IN_I_P field to a new value.
#define BW_HDMI_FC_INVIDCONF_IN_I_P(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_IN_I_P) | BF_HDMI_FC_INVIDCONF_IN_I_P(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field R_V_BLANK_IN_OSC[1] (RW)
 *
 * Used for CEA861-D modes with fractional Vblank (for example, modes 5, 6, 7, 10, 11, 20, 21, and
 * 22. For more modes, refer to CEA861-D specification.
 *
 * Values:
 * - 1 - Active high
 */
//@{
#define BP_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC      (1)      //!< Bit position for HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC.
#define BM_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC      (0x00000002)  //!< Bit mask for HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC.

//! @brief Get value of HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC from a register value.
#define BG_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC) >> BP_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC.
#define BF_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC) & BM_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the R_V_BLANK_IN_OSC field to a new value.
#define BW_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC) | BF_HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field DVI_MODEZ[3] (RW)
 *
 * Active low
 *
 * Values:
 * - 0 - DVI mode selected
 * - 1 - HDMI mode selected
 */
//@{
#define BP_HDMI_FC_INVIDCONF_DVI_MODEZ      (3)      //!< Bit position for HDMI_FC_INVIDCONF_DVI_MODEZ.
#define BM_HDMI_FC_INVIDCONF_DVI_MODEZ      (0x00000008)  //!< Bit mask for HDMI_FC_INVIDCONF_DVI_MODEZ.

//! @brief Get value of HDMI_FC_INVIDCONF_DVI_MODEZ from a register value.
#define BG_HDMI_FC_INVIDCONF_DVI_MODEZ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_DVI_MODEZ) >> BP_HDMI_FC_INVIDCONF_DVI_MODEZ)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_DVI_MODEZ.
#define BF_HDMI_FC_INVIDCONF_DVI_MODEZ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_DVI_MODEZ) & BM_HDMI_FC_INVIDCONF_DVI_MODEZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DVI_MODEZ field to a new value.
#define BW_HDMI_FC_INVIDCONF_DVI_MODEZ(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_DVI_MODEZ) | BF_HDMI_FC_INVIDCONF_DVI_MODEZ(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field DE_IN_POLARITY[4] (RW)
 *
 * Data enable input polarity
 *
 * Values:
 * - 0 - Active low
 * - 1 - Active high
 */
//@{
#define BP_HDMI_FC_INVIDCONF_DE_IN_POLARITY      (4)      //!< Bit position for HDMI_FC_INVIDCONF_DE_IN_POLARITY.
#define BM_HDMI_FC_INVIDCONF_DE_IN_POLARITY      (0x00000010)  //!< Bit mask for HDMI_FC_INVIDCONF_DE_IN_POLARITY.

//! @brief Get value of HDMI_FC_INVIDCONF_DE_IN_POLARITY from a register value.
#define BG_HDMI_FC_INVIDCONF_DE_IN_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_DE_IN_POLARITY) >> BP_HDMI_FC_INVIDCONF_DE_IN_POLARITY)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_DE_IN_POLARITY.
#define BF_HDMI_FC_INVIDCONF_DE_IN_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_DE_IN_POLARITY) & BM_HDMI_FC_INVIDCONF_DE_IN_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DE_IN_POLARITY field to a new value.
#define BW_HDMI_FC_INVIDCONF_DE_IN_POLARITY(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_DE_IN_POLARITY) | BF_HDMI_FC_INVIDCONF_DE_IN_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field HSYNC_IN_POLARITY[5] (RW)
 *
 * Hsync input polarity
 *
 * Values:
 * - 0 - Active low
 * - 1 - Active high
 */
//@{
#define BP_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY      (5)      //!< Bit position for HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY.
#define BM_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY      (0x00000020)  //!< Bit mask for HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY.

//! @brief Get value of HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY from a register value.
#define BG_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY) >> BP_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY.
#define BF_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY) & BM_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HSYNC_IN_POLARITY field to a new value.
#define BW_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY) | BF_HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field VSYNC_IN_POLARITY[6] (RW)
 *
 * Vsync input polarity
 *
 * Values:
 * - 0 - Active low
 * - 1 - Active high
 */
//@{
#define BP_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY      (6)      //!< Bit position for HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY.
#define BM_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY      (0x00000040)  //!< Bit mask for HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY.

//! @brief Get value of HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY from a register value.
#define BG_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY) >> BP_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY.
#define BF_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY) & BM_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSYNC_IN_POLARITY field to a new value.
#define BW_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY) | BF_HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_FC_INVIDCONF, field HDCP_KEEPOUT[7] (RW)
 *
 * Start/stop HDCP keepout window generation
 *
 * Values:
 * - 1b - Active
 */
//@{
#define BP_HDMI_FC_INVIDCONF_HDCP_KEEPOUT      (7)      //!< Bit position for HDMI_FC_INVIDCONF_HDCP_KEEPOUT.
#define BM_HDMI_FC_INVIDCONF_HDCP_KEEPOUT      (0x00000080)  //!< Bit mask for HDMI_FC_INVIDCONF_HDCP_KEEPOUT.

//! @brief Get value of HDMI_FC_INVIDCONF_HDCP_KEEPOUT from a register value.
#define BG_HDMI_FC_INVIDCONF_HDCP_KEEPOUT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVIDCONF_HDCP_KEEPOUT) >> BP_HDMI_FC_INVIDCONF_HDCP_KEEPOUT)

//! @brief Format value for bitfield HDMI_FC_INVIDCONF_HDCP_KEEPOUT.
#define BF_HDMI_FC_INVIDCONF_HDCP_KEEPOUT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVIDCONF_HDCP_KEEPOUT) & BM_HDMI_FC_INVIDCONF_HDCP_KEEPOUT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HDCP_KEEPOUT field to a new value.
#define BW_HDMI_FC_INVIDCONF_HDCP_KEEPOUT(v)   (HW_HDMI_FC_INVIDCONF_WR((HW_HDMI_FC_INVIDCONF_RD() & ~BM_HDMI_FC_INVIDCONF_HDCP_KEEPOUT) | BF_HDMI_FC_INVIDCONF_HDCP_KEEPOUT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INHACTIV0 - Frame Composer Input Video HActive Pixels Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INHACTIV0 - Frame Composer Input Video HActive Pixels Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_inhactiv0
{
    reg8_t U;
    struct _hw_hdmi_fc_inhactiv0_bitfields
    {
        unsigned char H_IN_ACTIV : 8; //!< [7:0] Input video Horizontal active pixel region width.
    } B;
} hw_hdmi_fc_inhactiv0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INHACTIV0 register
 */
//@{
#define HW_HDMI_FC_INHACTIV0_ADDR      (REGS_HDMI_BASE + 0x1001)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INHACTIV0           (*(volatile hw_hdmi_fc_inhactiv0_t *) HW_HDMI_FC_INHACTIV0_ADDR)
#define HW_HDMI_FC_INHACTIV0_RD()      (HW_HDMI_FC_INHACTIV0.U)
#define HW_HDMI_FC_INHACTIV0_WR(v)     (HW_HDMI_FC_INHACTIV0.U = (v))
#define HW_HDMI_FC_INHACTIV0_SET(v)    (HW_HDMI_FC_INHACTIV0_WR(HW_HDMI_FC_INHACTIV0_RD() |  (v)))
#define HW_HDMI_FC_INHACTIV0_CLR(v)    (HW_HDMI_FC_INHACTIV0_WR(HW_HDMI_FC_INHACTIV0_RD() & ~(v)))
#define HW_HDMI_FC_INHACTIV0_TOG(v)    (HW_HDMI_FC_INHACTIV0_WR(HW_HDMI_FC_INHACTIV0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INHACTIV0 bitfields
 */

/*! @name Register HDMI_FC_INHACTIV0, field H_IN_ACTIV[7:0] (RW)
 *
 * Input video Horizontal active pixel region width. Number of Horizontal active pixels [0...8191].
 */
//@{
#define BP_HDMI_FC_INHACTIV0_H_IN_ACTIV      (0)      //!< Bit position for HDMI_FC_INHACTIV0_H_IN_ACTIV.
#define BM_HDMI_FC_INHACTIV0_H_IN_ACTIV      (0x000000ff)  //!< Bit mask for HDMI_FC_INHACTIV0_H_IN_ACTIV.

//! @brief Get value of HDMI_FC_INHACTIV0_H_IN_ACTIV from a register value.
#define BG_HDMI_FC_INHACTIV0_H_IN_ACTIV(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INHACTIV0_H_IN_ACTIV) >> BP_HDMI_FC_INHACTIV0_H_IN_ACTIV)

//! @brief Format value for bitfield HDMI_FC_INHACTIV0_H_IN_ACTIV.
#define BF_HDMI_FC_INHACTIV0_H_IN_ACTIV(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INHACTIV0_H_IN_ACTIV) & BM_HDMI_FC_INHACTIV0_H_IN_ACTIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_ACTIV field to a new value.
#define BW_HDMI_FC_INHACTIV0_H_IN_ACTIV(v)   (HW_HDMI_FC_INHACTIV0_WR((HW_HDMI_FC_INHACTIV0_RD() & ~BM_HDMI_FC_INHACTIV0_H_IN_ACTIV) | BF_HDMI_FC_INHACTIV0_H_IN_ACTIV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INHACTIV1 - Frame Composer Input Video HActive Pixels Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INHACTIV1 - Frame Composer Input Video HActive Pixels Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_inhactiv1
{
    reg8_t U;
    struct _hw_hdmi_fc_inhactiv1_bitfields
    {
        unsigned char H_IN_ACTIV : 5; //!< [4:0] Input video Horizontal active pixel region width.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_inhactiv1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INHACTIV1 register
 */
//@{
#define HW_HDMI_FC_INHACTIV1_ADDR      (REGS_HDMI_BASE + 0x1002)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INHACTIV1           (*(volatile hw_hdmi_fc_inhactiv1_t *) HW_HDMI_FC_INHACTIV1_ADDR)
#define HW_HDMI_FC_INHACTIV1_RD()      (HW_HDMI_FC_INHACTIV1.U)
#define HW_HDMI_FC_INHACTIV1_WR(v)     (HW_HDMI_FC_INHACTIV1.U = (v))
#define HW_HDMI_FC_INHACTIV1_SET(v)    (HW_HDMI_FC_INHACTIV1_WR(HW_HDMI_FC_INHACTIV1_RD() |  (v)))
#define HW_HDMI_FC_INHACTIV1_CLR(v)    (HW_HDMI_FC_INHACTIV1_WR(HW_HDMI_FC_INHACTIV1_RD() & ~(v)))
#define HW_HDMI_FC_INHACTIV1_TOG(v)    (HW_HDMI_FC_INHACTIV1_WR(HW_HDMI_FC_INHACTIV1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INHACTIV1 bitfields
 */

/*! @name Register HDMI_FC_INHACTIV1, field H_IN_ACTIV[4:0] (RW)
 *
 * Input video Horizontal active pixel region width. Dependencies: Value after Reset: 0000b the
 * higher bit of Horizontal active pixels; Number of Horizontal active pixels [0...8191].
 */
//@{
#define BP_HDMI_FC_INHACTIV1_H_IN_ACTIV      (0)      //!< Bit position for HDMI_FC_INHACTIV1_H_IN_ACTIV.
#define BM_HDMI_FC_INHACTIV1_H_IN_ACTIV      (0x0000001f)  //!< Bit mask for HDMI_FC_INHACTIV1_H_IN_ACTIV.

//! @brief Get value of HDMI_FC_INHACTIV1_H_IN_ACTIV from a register value.
#define BG_HDMI_FC_INHACTIV1_H_IN_ACTIV(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INHACTIV1_H_IN_ACTIV) >> BP_HDMI_FC_INHACTIV1_H_IN_ACTIV)

//! @brief Format value for bitfield HDMI_FC_INHACTIV1_H_IN_ACTIV.
#define BF_HDMI_FC_INHACTIV1_H_IN_ACTIV(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INHACTIV1_H_IN_ACTIV) & BM_HDMI_FC_INHACTIV1_H_IN_ACTIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_ACTIV field to a new value.
#define BW_HDMI_FC_INHACTIV1_H_IN_ACTIV(v)   (HW_HDMI_FC_INHACTIV1_WR((HW_HDMI_FC_INHACTIV1_RD() & ~BM_HDMI_FC_INHACTIV1_H_IN_ACTIV) | BF_HDMI_FC_INHACTIV1_H_IN_ACTIV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INHBLANK0 - Frame Composer Input Video HBlank Pixels Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INHBLANK0 - Frame Composer Input Video HBlank Pixels Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_inhblank0
{
    reg8_t U;
    struct _hw_hdmi_fc_inhblank0_bitfields
    {
        unsigned char H_IN_BLANK : 8; //!< [7:0] Input video Horizontal blanking pixel region width.
    } B;
} hw_hdmi_fc_inhblank0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INHBLANK0 register
 */
//@{
#define HW_HDMI_FC_INHBLANK0_ADDR      (REGS_HDMI_BASE + 0x1003)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INHBLANK0           (*(volatile hw_hdmi_fc_inhblank0_t *) HW_HDMI_FC_INHBLANK0_ADDR)
#define HW_HDMI_FC_INHBLANK0_RD()      (HW_HDMI_FC_INHBLANK0.U)
#define HW_HDMI_FC_INHBLANK0_WR(v)     (HW_HDMI_FC_INHBLANK0.U = (v))
#define HW_HDMI_FC_INHBLANK0_SET(v)    (HW_HDMI_FC_INHBLANK0_WR(HW_HDMI_FC_INHBLANK0_RD() |  (v)))
#define HW_HDMI_FC_INHBLANK0_CLR(v)    (HW_HDMI_FC_INHBLANK0_WR(HW_HDMI_FC_INHBLANK0_RD() & ~(v)))
#define HW_HDMI_FC_INHBLANK0_TOG(v)    (HW_HDMI_FC_INHBLANK0_WR(HW_HDMI_FC_INHBLANK0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INHBLANK0 bitfields
 */

/*! @name Register HDMI_FC_INHBLANK0, field H_IN_BLANK[7:0] (RW)
 *
 * Input video Horizontal blanking pixel region width. Number of Horizontal blanking pixels
 * [0...4095].
 */
//@{
#define BP_HDMI_FC_INHBLANK0_H_IN_BLANK      (0)      //!< Bit position for HDMI_FC_INHBLANK0_H_IN_BLANK.
#define BM_HDMI_FC_INHBLANK0_H_IN_BLANK      (0x000000ff)  //!< Bit mask for HDMI_FC_INHBLANK0_H_IN_BLANK.

//! @brief Get value of HDMI_FC_INHBLANK0_H_IN_BLANK from a register value.
#define BG_HDMI_FC_INHBLANK0_H_IN_BLANK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INHBLANK0_H_IN_BLANK) >> BP_HDMI_FC_INHBLANK0_H_IN_BLANK)

//! @brief Format value for bitfield HDMI_FC_INHBLANK0_H_IN_BLANK.
#define BF_HDMI_FC_INHBLANK0_H_IN_BLANK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INHBLANK0_H_IN_BLANK) & BM_HDMI_FC_INHBLANK0_H_IN_BLANK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_BLANK field to a new value.
#define BW_HDMI_FC_INHBLANK0_H_IN_BLANK(v)   (HW_HDMI_FC_INHBLANK0_WR((HW_HDMI_FC_INHBLANK0_RD() & ~BM_HDMI_FC_INHBLANK0_H_IN_BLANK) | BF_HDMI_FC_INHBLANK0_H_IN_BLANK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INHBLANK1 - Frame Composer Input Video HBlank Pixels Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INHBLANK1 - Frame Composer Input Video HBlank Pixels Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_inhblank1
{
    reg8_t U;
    struct _hw_hdmi_fc_inhblank1_bitfields
    {
        unsigned char H_IN_BLANK : 5; //!< [4:0] Input video Horizontal blanking pixel region width.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_inhblank1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INHBLANK1 register
 */
//@{
#define HW_HDMI_FC_INHBLANK1_ADDR      (REGS_HDMI_BASE + 0x1004)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INHBLANK1           (*(volatile hw_hdmi_fc_inhblank1_t *) HW_HDMI_FC_INHBLANK1_ADDR)
#define HW_HDMI_FC_INHBLANK1_RD()      (HW_HDMI_FC_INHBLANK1.U)
#define HW_HDMI_FC_INHBLANK1_WR(v)     (HW_HDMI_FC_INHBLANK1.U = (v))
#define HW_HDMI_FC_INHBLANK1_SET(v)    (HW_HDMI_FC_INHBLANK1_WR(HW_HDMI_FC_INHBLANK1_RD() |  (v)))
#define HW_HDMI_FC_INHBLANK1_CLR(v)    (HW_HDMI_FC_INHBLANK1_WR(HW_HDMI_FC_INHBLANK1_RD() & ~(v)))
#define HW_HDMI_FC_INHBLANK1_TOG(v)    (HW_HDMI_FC_INHBLANK1_WR(HW_HDMI_FC_INHBLANK1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INHBLANK1 bitfields
 */

/*! @name Register HDMI_FC_INHBLANK1, field H_IN_BLANK[4:0] (RW)
 *
 * Input video Horizontal blanking pixel region width. Dependencies: Value after Reset: 0000b the
 * higher bits of Horizontal blanking pixels; Number of Horizontal blanking pixels [0...8191].
 */
//@{
#define BP_HDMI_FC_INHBLANK1_H_IN_BLANK      (0)      //!< Bit position for HDMI_FC_INHBLANK1_H_IN_BLANK.
#define BM_HDMI_FC_INHBLANK1_H_IN_BLANK      (0x0000001f)  //!< Bit mask for HDMI_FC_INHBLANK1_H_IN_BLANK.

//! @brief Get value of HDMI_FC_INHBLANK1_H_IN_BLANK from a register value.
#define BG_HDMI_FC_INHBLANK1_H_IN_BLANK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INHBLANK1_H_IN_BLANK) >> BP_HDMI_FC_INHBLANK1_H_IN_BLANK)

//! @brief Format value for bitfield HDMI_FC_INHBLANK1_H_IN_BLANK.
#define BF_HDMI_FC_INHBLANK1_H_IN_BLANK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INHBLANK1_H_IN_BLANK) & BM_HDMI_FC_INHBLANK1_H_IN_BLANK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_BLANK field to a new value.
#define BW_HDMI_FC_INHBLANK1_H_IN_BLANK(v)   (HW_HDMI_FC_INHBLANK1_WR((HW_HDMI_FC_INHBLANK1_RD() & ~BM_HDMI_FC_INHBLANK1_H_IN_BLANK) | BF_HDMI_FC_INHBLANK1_H_IN_BLANK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INVACTIV0 - Frame Composer Input Video VActive Pixels Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INVACTIV0 - Frame Composer Input Video VActive Pixels Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_invactiv0
{
    reg8_t U;
    struct _hw_hdmi_fc_invactiv0_bitfields
    {
        unsigned char V_IN_ACTIV : 8; //!< [7:0] Input video Vertical active pixel region width.
    } B;
} hw_hdmi_fc_invactiv0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INVACTIV0 register
 */
//@{
#define HW_HDMI_FC_INVACTIV0_ADDR      (REGS_HDMI_BASE + 0x1005)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INVACTIV0           (*(volatile hw_hdmi_fc_invactiv0_t *) HW_HDMI_FC_INVACTIV0_ADDR)
#define HW_HDMI_FC_INVACTIV0_RD()      (HW_HDMI_FC_INVACTIV0.U)
#define HW_HDMI_FC_INVACTIV0_WR(v)     (HW_HDMI_FC_INVACTIV0.U = (v))
#define HW_HDMI_FC_INVACTIV0_SET(v)    (HW_HDMI_FC_INVACTIV0_WR(HW_HDMI_FC_INVACTIV0_RD() |  (v)))
#define HW_HDMI_FC_INVACTIV0_CLR(v)    (HW_HDMI_FC_INVACTIV0_WR(HW_HDMI_FC_INVACTIV0_RD() & ~(v)))
#define HW_HDMI_FC_INVACTIV0_TOG(v)    (HW_HDMI_FC_INVACTIV0_WR(HW_HDMI_FC_INVACTIV0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INVACTIV0 bitfields
 */

/*! @name Register HDMI_FC_INVACTIV0, field V_IN_ACTIV[7:0] (RW)
 *
 * Input video Vertical active pixel region width. Number of Vertical active lines [0...4095].
 */
//@{
#define BP_HDMI_FC_INVACTIV0_V_IN_ACTIV      (0)      //!< Bit position for HDMI_FC_INVACTIV0_V_IN_ACTIV.
#define BM_HDMI_FC_INVACTIV0_V_IN_ACTIV      (0x000000ff)  //!< Bit mask for HDMI_FC_INVACTIV0_V_IN_ACTIV.

//! @brief Get value of HDMI_FC_INVACTIV0_V_IN_ACTIV from a register value.
#define BG_HDMI_FC_INVACTIV0_V_IN_ACTIV(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVACTIV0_V_IN_ACTIV) >> BP_HDMI_FC_INVACTIV0_V_IN_ACTIV)

//! @brief Format value for bitfield HDMI_FC_INVACTIV0_V_IN_ACTIV.
#define BF_HDMI_FC_INVACTIV0_V_IN_ACTIV(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVACTIV0_V_IN_ACTIV) & BM_HDMI_FC_INVACTIV0_V_IN_ACTIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the V_IN_ACTIV field to a new value.
#define BW_HDMI_FC_INVACTIV0_V_IN_ACTIV(v)   (HW_HDMI_FC_INVACTIV0_WR((HW_HDMI_FC_INVACTIV0_RD() & ~BM_HDMI_FC_INVACTIV0_V_IN_ACTIV) | BF_HDMI_FC_INVACTIV0_V_IN_ACTIV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INVACTIV1 - Frame Composer Input Video VActive Pixels Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INVACTIV1 - Frame Composer Input Video VActive Pixels Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_invactiv1
{
    reg8_t U;
    struct _hw_hdmi_fc_invactiv1_bitfields
    {
        unsigned char V_IN_ACTIV : 5; //!< [4:0] Input video Vertical active pixel region width.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_invactiv1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INVACTIV1 register
 */
//@{
#define HW_HDMI_FC_INVACTIV1_ADDR      (REGS_HDMI_BASE + 0x1006)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INVACTIV1           (*(volatile hw_hdmi_fc_invactiv1_t *) HW_HDMI_FC_INVACTIV1_ADDR)
#define HW_HDMI_FC_INVACTIV1_RD()      (HW_HDMI_FC_INVACTIV1.U)
#define HW_HDMI_FC_INVACTIV1_WR(v)     (HW_HDMI_FC_INVACTIV1.U = (v))
#define HW_HDMI_FC_INVACTIV1_SET(v)    (HW_HDMI_FC_INVACTIV1_WR(HW_HDMI_FC_INVACTIV1_RD() |  (v)))
#define HW_HDMI_FC_INVACTIV1_CLR(v)    (HW_HDMI_FC_INVACTIV1_WR(HW_HDMI_FC_INVACTIV1_RD() & ~(v)))
#define HW_HDMI_FC_INVACTIV1_TOG(v)    (HW_HDMI_FC_INVACTIV1_WR(HW_HDMI_FC_INVACTIV1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INVACTIV1 bitfields
 */

/*! @name Register HDMI_FC_INVACTIV1, field V_IN_ACTIV[4:0] (RW)
 *
 * Input video Vertical active pixel region width. Dependencies: Value after Reset: 0000b the higher
 * 5 bits of Vertical active line; Number of Vertical active lines [0...8191].
 */
//@{
#define BP_HDMI_FC_INVACTIV1_V_IN_ACTIV      (0)      //!< Bit position for HDMI_FC_INVACTIV1_V_IN_ACTIV.
#define BM_HDMI_FC_INVACTIV1_V_IN_ACTIV      (0x0000001f)  //!< Bit mask for HDMI_FC_INVACTIV1_V_IN_ACTIV.

//! @brief Get value of HDMI_FC_INVACTIV1_V_IN_ACTIV from a register value.
#define BG_HDMI_FC_INVACTIV1_V_IN_ACTIV(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVACTIV1_V_IN_ACTIV) >> BP_HDMI_FC_INVACTIV1_V_IN_ACTIV)

//! @brief Format value for bitfield HDMI_FC_INVACTIV1_V_IN_ACTIV.
#define BF_HDMI_FC_INVACTIV1_V_IN_ACTIV(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVACTIV1_V_IN_ACTIV) & BM_HDMI_FC_INVACTIV1_V_IN_ACTIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the V_IN_ACTIV field to a new value.
#define BW_HDMI_FC_INVACTIV1_V_IN_ACTIV(v)   (HW_HDMI_FC_INVACTIV1_WR((HW_HDMI_FC_INVACTIV1_RD() & ~BM_HDMI_FC_INVACTIV1_V_IN_ACTIV) | BF_HDMI_FC_INVACTIV1_V_IN_ACTIV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INVBLANK - Frame Composer Input Video VBlank Pixels Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INVBLANK - Frame Composer Input Video VBlank Pixels Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_invblank
{
    reg8_t U;
    struct _hw_hdmi_fc_invblank_bitfields
    {
        unsigned char V_IN_BLANK : 8; //!< [7:0] Input video Vertical blanking pixel region width.
    } B;
} hw_hdmi_fc_invblank_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INVBLANK register
 */
//@{
#define HW_HDMI_FC_INVBLANK_ADDR      (REGS_HDMI_BASE + 0x1007)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INVBLANK           (*(volatile hw_hdmi_fc_invblank_t *) HW_HDMI_FC_INVBLANK_ADDR)
#define HW_HDMI_FC_INVBLANK_RD()      (HW_HDMI_FC_INVBLANK.U)
#define HW_HDMI_FC_INVBLANK_WR(v)     (HW_HDMI_FC_INVBLANK.U = (v))
#define HW_HDMI_FC_INVBLANK_SET(v)    (HW_HDMI_FC_INVBLANK_WR(HW_HDMI_FC_INVBLANK_RD() |  (v)))
#define HW_HDMI_FC_INVBLANK_CLR(v)    (HW_HDMI_FC_INVBLANK_WR(HW_HDMI_FC_INVBLANK_RD() & ~(v)))
#define HW_HDMI_FC_INVBLANK_TOG(v)    (HW_HDMI_FC_INVBLANK_WR(HW_HDMI_FC_INVBLANK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INVBLANK bitfields
 */

/*! @name Register HDMI_FC_INVBLANK, field V_IN_BLANK[7:0] (RW)
 *
 * Input video Vertical blanking pixel region width. Number of Vertical blanking lines [0...255].
 * Value after Reset: 0x00
 */
//@{
#define BP_HDMI_FC_INVBLANK_V_IN_BLANK      (0)      //!< Bit position for HDMI_FC_INVBLANK_V_IN_BLANK.
#define BM_HDMI_FC_INVBLANK_V_IN_BLANK      (0x000000ff)  //!< Bit mask for HDMI_FC_INVBLANK_V_IN_BLANK.

//! @brief Get value of HDMI_FC_INVBLANK_V_IN_BLANK from a register value.
#define BG_HDMI_FC_INVBLANK_V_IN_BLANK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INVBLANK_V_IN_BLANK) >> BP_HDMI_FC_INVBLANK_V_IN_BLANK)

//! @brief Format value for bitfield HDMI_FC_INVBLANK_V_IN_BLANK.
#define BF_HDMI_FC_INVBLANK_V_IN_BLANK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INVBLANK_V_IN_BLANK) & BM_HDMI_FC_INVBLANK_V_IN_BLANK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the V_IN_BLANK field to a new value.
#define BW_HDMI_FC_INVBLANK_V_IN_BLANK(v)   (HW_HDMI_FC_INVBLANK_WR((HW_HDMI_FC_INVBLANK_RD() & ~BM_HDMI_FC_INVBLANK_V_IN_BLANK) | BF_HDMI_FC_INVBLANK_V_IN_BLANK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_HSYNCINDELAY0 - Frame Composer Input Video HSync Front Porch Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_HSYNCINDELAY0 - Frame Composer Input Video HSync Front Porch Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_hsyncindelay0
{
    reg8_t U;
    struct _hw_hdmi_fc_hsyncindelay0_bitfields
    {
        unsigned char H_IN_DELAY : 8; //!< [7:0] Input video Hsync active edge delay.
    } B;
} hw_hdmi_fc_hsyncindelay0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_HSYNCINDELAY0 register
 */
//@{
#define HW_HDMI_FC_HSYNCINDELAY0_ADDR      (REGS_HDMI_BASE + 0x1008)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_HSYNCINDELAY0           (*(volatile hw_hdmi_fc_hsyncindelay0_t *) HW_HDMI_FC_HSYNCINDELAY0_ADDR)
#define HW_HDMI_FC_HSYNCINDELAY0_RD()      (HW_HDMI_FC_HSYNCINDELAY0.U)
#define HW_HDMI_FC_HSYNCINDELAY0_WR(v)     (HW_HDMI_FC_HSYNCINDELAY0.U = (v))
#define HW_HDMI_FC_HSYNCINDELAY0_SET(v)    (HW_HDMI_FC_HSYNCINDELAY0_WR(HW_HDMI_FC_HSYNCINDELAY0_RD() |  (v)))
#define HW_HDMI_FC_HSYNCINDELAY0_CLR(v)    (HW_HDMI_FC_HSYNCINDELAY0_WR(HW_HDMI_FC_HSYNCINDELAY0_RD() & ~(v)))
#define HW_HDMI_FC_HSYNCINDELAY0_TOG(v)    (HW_HDMI_FC_HSYNCINDELAY0_WR(HW_HDMI_FC_HSYNCINDELAY0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_HSYNCINDELAY0 bitfields
 */

/*! @name Register HDMI_FC_HSYNCINDELAY0, field H_IN_DELAY[7:0] (RW)
 *
 * Input video Hsync active edge delay. Integer number of pixel clock cycles from "de" non active
 * edge of the last "de" valid period [0...4095].
 */
//@{
#define BP_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY      (0)      //!< Bit position for HDMI_FC_HSYNCINDELAY0_H_IN_DELAY.
#define BM_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY      (0x000000ff)  //!< Bit mask for HDMI_FC_HSYNCINDELAY0_H_IN_DELAY.

//! @brief Get value of HDMI_FC_HSYNCINDELAY0_H_IN_DELAY from a register value.
#define BG_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY) >> BP_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY)

//! @brief Format value for bitfield HDMI_FC_HSYNCINDELAY0_H_IN_DELAY.
#define BF_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY) & BM_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_DELAY field to a new value.
#define BW_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY(v)   (HW_HDMI_FC_HSYNCINDELAY0_WR((HW_HDMI_FC_HSYNCINDELAY0_RD() & ~BM_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY) | BF_HDMI_FC_HSYNCINDELAY0_H_IN_DELAY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_HSYNCINDELAY1 - Frame Composer Input Video HSync Front Porch Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_HSYNCINDELAY1 - Frame Composer Input Video HSync Front Porch Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_hsyncindelay1
{
    reg8_t U;
    struct _hw_hdmi_fc_hsyncindelay1_bitfields
    {
        unsigned char H_IN_DELAY : 5; //!< [4:0] Input video Hsync active edge delay.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_hsyncindelay1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_HSYNCINDELAY1 register
 */
//@{
#define HW_HDMI_FC_HSYNCINDELAY1_ADDR      (REGS_HDMI_BASE + 0x1009)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_HSYNCINDELAY1           (*(volatile hw_hdmi_fc_hsyncindelay1_t *) HW_HDMI_FC_HSYNCINDELAY1_ADDR)
#define HW_HDMI_FC_HSYNCINDELAY1_RD()      (HW_HDMI_FC_HSYNCINDELAY1.U)
#define HW_HDMI_FC_HSYNCINDELAY1_WR(v)     (HW_HDMI_FC_HSYNCINDELAY1.U = (v))
#define HW_HDMI_FC_HSYNCINDELAY1_SET(v)    (HW_HDMI_FC_HSYNCINDELAY1_WR(HW_HDMI_FC_HSYNCINDELAY1_RD() |  (v)))
#define HW_HDMI_FC_HSYNCINDELAY1_CLR(v)    (HW_HDMI_FC_HSYNCINDELAY1_WR(HW_HDMI_FC_HSYNCINDELAY1_RD() & ~(v)))
#define HW_HDMI_FC_HSYNCINDELAY1_TOG(v)    (HW_HDMI_FC_HSYNCINDELAY1_WR(HW_HDMI_FC_HSYNCINDELAY1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_HSYNCINDELAY1 bitfields
 */

/*! @name Register HDMI_FC_HSYNCINDELAY1, field H_IN_DELAY[4:0] (RW)
 *
 * Input video Hsync active edge delay. Dependencies: Value after Reset: 0000b the higher 5 bits of
 * delay; Integer number of pixel clock cycles from "de" non active edge of the last "de" valid
 * period [0...8191].
 */
//@{
#define BP_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY      (0)      //!< Bit position for HDMI_FC_HSYNCINDELAY1_H_IN_DELAY.
#define BM_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY      (0x0000001f)  //!< Bit mask for HDMI_FC_HSYNCINDELAY1_H_IN_DELAY.

//! @brief Get value of HDMI_FC_HSYNCINDELAY1_H_IN_DELAY from a register value.
#define BG_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY) >> BP_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY)

//! @brief Format value for bitfield HDMI_FC_HSYNCINDELAY1_H_IN_DELAY.
#define BF_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY) & BM_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_DELAY field to a new value.
#define BW_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY(v)   (HW_HDMI_FC_HSYNCINDELAY1_WR((HW_HDMI_FC_HSYNCINDELAY1_RD() & ~BM_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY) | BF_HDMI_FC_HSYNCINDELAY1_H_IN_DELAY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_HSYNCINWIDTH0 - Frame Composer Input Video HSync Width Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_HSYNCINWIDTH0 - Frame Composer Input Video HSync Width Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_hsyncinwidth0
{
    reg8_t U;
    struct _hw_hdmi_fc_hsyncinwidth0_bitfields
    {
        unsigned char H_IN_WIDTH : 8; //!< [7:0] Input video Hsync active pulse width.
    } B;
} hw_hdmi_fc_hsyncinwidth0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_HSYNCINWIDTH0 register
 */
//@{
#define HW_HDMI_FC_HSYNCINWIDTH0_ADDR      (REGS_HDMI_BASE + 0x100a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_HSYNCINWIDTH0           (*(volatile hw_hdmi_fc_hsyncinwidth0_t *) HW_HDMI_FC_HSYNCINWIDTH0_ADDR)
#define HW_HDMI_FC_HSYNCINWIDTH0_RD()      (HW_HDMI_FC_HSYNCINWIDTH0.U)
#define HW_HDMI_FC_HSYNCINWIDTH0_WR(v)     (HW_HDMI_FC_HSYNCINWIDTH0.U = (v))
#define HW_HDMI_FC_HSYNCINWIDTH0_SET(v)    (HW_HDMI_FC_HSYNCINWIDTH0_WR(HW_HDMI_FC_HSYNCINWIDTH0_RD() |  (v)))
#define HW_HDMI_FC_HSYNCINWIDTH0_CLR(v)    (HW_HDMI_FC_HSYNCINWIDTH0_WR(HW_HDMI_FC_HSYNCINWIDTH0_RD() & ~(v)))
#define HW_HDMI_FC_HSYNCINWIDTH0_TOG(v)    (HW_HDMI_FC_HSYNCINWIDTH0_WR(HW_HDMI_FC_HSYNCINWIDTH0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_HSYNCINWIDTH0 bitfields
 */

/*! @name Register HDMI_FC_HSYNCINWIDTH0, field H_IN_WIDTH[7:0] (RW)
 *
 * Input video Hsync active pulse width. Integer number of pixel clock cycles [0...511].
 */
//@{
#define BP_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH      (0)      //!< Bit position for HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH.
#define BM_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH      (0x000000ff)  //!< Bit mask for HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH.

//! @brief Get value of HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH from a register value.
#define BG_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH) >> BP_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH)

//! @brief Format value for bitfield HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH.
#define BF_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH) & BM_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_WIDTH field to a new value.
#define BW_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH(v)   (HW_HDMI_FC_HSYNCINWIDTH0_WR((HW_HDMI_FC_HSYNCINWIDTH0_RD() & ~BM_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH) | BF_HDMI_FC_HSYNCINWIDTH0_H_IN_WIDTH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_HSYNCINWIDTH1 - Frame Composer Input Video HSync Width Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_HSYNCINWIDTH1 - Frame Composer Input Video HSync Width Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_hsyncinwidth1
{
    reg8_t U;
    struct _hw_hdmi_fc_hsyncinwidth1_bitfields
    {
        unsigned char H_IN_WIDTH : 2; //!< [1:0] Input video Hsync active pulse width.
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_fc_hsyncinwidth1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_HSYNCINWIDTH1 register
 */
//@{
#define HW_HDMI_FC_HSYNCINWIDTH1_ADDR      (REGS_HDMI_BASE + 0x100b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_HSYNCINWIDTH1           (*(volatile hw_hdmi_fc_hsyncinwidth1_t *) HW_HDMI_FC_HSYNCINWIDTH1_ADDR)
#define HW_HDMI_FC_HSYNCINWIDTH1_RD()      (HW_HDMI_FC_HSYNCINWIDTH1.U)
#define HW_HDMI_FC_HSYNCINWIDTH1_WR(v)     (HW_HDMI_FC_HSYNCINWIDTH1.U = (v))
#define HW_HDMI_FC_HSYNCINWIDTH1_SET(v)    (HW_HDMI_FC_HSYNCINWIDTH1_WR(HW_HDMI_FC_HSYNCINWIDTH1_RD() |  (v)))
#define HW_HDMI_FC_HSYNCINWIDTH1_CLR(v)    (HW_HDMI_FC_HSYNCINWIDTH1_WR(HW_HDMI_FC_HSYNCINWIDTH1_RD() & ~(v)))
#define HW_HDMI_FC_HSYNCINWIDTH1_TOG(v)    (HW_HDMI_FC_HSYNCINWIDTH1_WR(HW_HDMI_FC_HSYNCINWIDTH1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_HSYNCINWIDTH1 bitfields
 */

/*! @name Register HDMI_FC_HSYNCINWIDTH1, field H_IN_WIDTH[1:0] (RW)
 *
 * Input video Hsync active pulse width. Dependencies: Value after Reset after Reset: 0b Integer
 * number of pixel clock cycles [0...1024].
 */
//@{
#define BP_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH      (0)      //!< Bit position for HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH.
#define BM_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH      (0x00000003)  //!< Bit mask for HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH.

//! @brief Get value of HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH from a register value.
#define BG_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH) >> BP_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH)

//! @brief Format value for bitfield HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH.
#define BF_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH) & BM_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the H_IN_WIDTH field to a new value.
#define BW_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH(v)   (HW_HDMI_FC_HSYNCINWIDTH1_WR((HW_HDMI_FC_HSYNCINWIDTH1_RD() & ~BM_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH) | BF_HDMI_FC_HSYNCINWIDTH1_H_IN_WIDTH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSYNCINDELAY - Frame Composer Input Video VSync Front Porch Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSYNCINDELAY - Frame Composer Input Video VSync Front Porch Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsyncindelay
{
    reg8_t U;
    struct _hw_hdmi_fc_vsyncindelay_bitfields
    {
        unsigned char V_IN_DELAY : 8; //!< [7:0] Input video Vsync active edge delay.
    } B;
} hw_hdmi_fc_vsyncindelay_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSYNCINDELAY register
 */
//@{
#define HW_HDMI_FC_VSYNCINDELAY_ADDR      (REGS_HDMI_BASE + 0x100c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSYNCINDELAY           (*(volatile hw_hdmi_fc_vsyncindelay_t *) HW_HDMI_FC_VSYNCINDELAY_ADDR)
#define HW_HDMI_FC_VSYNCINDELAY_RD()      (HW_HDMI_FC_VSYNCINDELAY.U)
#define HW_HDMI_FC_VSYNCINDELAY_WR(v)     (HW_HDMI_FC_VSYNCINDELAY.U = (v))
#define HW_HDMI_FC_VSYNCINDELAY_SET(v)    (HW_HDMI_FC_VSYNCINDELAY_WR(HW_HDMI_FC_VSYNCINDELAY_RD() |  (v)))
#define HW_HDMI_FC_VSYNCINDELAY_CLR(v)    (HW_HDMI_FC_VSYNCINDELAY_WR(HW_HDMI_FC_VSYNCINDELAY_RD() & ~(v)))
#define HW_HDMI_FC_VSYNCINDELAY_TOG(v)    (HW_HDMI_FC_VSYNCINDELAY_WR(HW_HDMI_FC_VSYNCINDELAY_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSYNCINDELAY bitfields
 */

/*! @name Register HDMI_FC_VSYNCINDELAY, field V_IN_DELAY[7:0] (RW)
 *
 * Input video Vsync active edge delay. Integer number of Hsync pulses from "de" non active edge of
 * the last "de" valid period. [0...255].
 */
//@{
#define BP_HDMI_FC_VSYNCINDELAY_V_IN_DELAY      (0)      //!< Bit position for HDMI_FC_VSYNCINDELAY_V_IN_DELAY.
#define BM_HDMI_FC_VSYNCINDELAY_V_IN_DELAY      (0x000000ff)  //!< Bit mask for HDMI_FC_VSYNCINDELAY_V_IN_DELAY.

//! @brief Get value of HDMI_FC_VSYNCINDELAY_V_IN_DELAY from a register value.
#define BG_HDMI_FC_VSYNCINDELAY_V_IN_DELAY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_VSYNCINDELAY_V_IN_DELAY) >> BP_HDMI_FC_VSYNCINDELAY_V_IN_DELAY)

//! @brief Format value for bitfield HDMI_FC_VSYNCINDELAY_V_IN_DELAY.
#define BF_HDMI_FC_VSYNCINDELAY_V_IN_DELAY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_VSYNCINDELAY_V_IN_DELAY) & BM_HDMI_FC_VSYNCINDELAY_V_IN_DELAY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the V_IN_DELAY field to a new value.
#define BW_HDMI_FC_VSYNCINDELAY_V_IN_DELAY(v)   (HW_HDMI_FC_VSYNCINDELAY_WR((HW_HDMI_FC_VSYNCINDELAY_RD() & ~BM_HDMI_FC_VSYNCINDELAY_V_IN_DELAY) | BF_HDMI_FC_VSYNCINDELAY_V_IN_DELAY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSYNCINWIDTH - Frame Composer Input Video VSync Width Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSYNCINWIDTH - Frame Composer Input Video VSync Width Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsyncinwidth
{
    reg8_t U;
    struct _hw_hdmi_fc_vsyncinwidth_bitfields
    {
        unsigned char V_IN_WIDTH : 6; //!< [5:0] Value after Reset: 000000b
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_fc_vsyncinwidth_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSYNCINWIDTH register
 */
//@{
#define HW_HDMI_FC_VSYNCINWIDTH_ADDR      (REGS_HDMI_BASE + 0x100d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSYNCINWIDTH           (*(volatile hw_hdmi_fc_vsyncinwidth_t *) HW_HDMI_FC_VSYNCINWIDTH_ADDR)
#define HW_HDMI_FC_VSYNCINWIDTH_RD()      (HW_HDMI_FC_VSYNCINWIDTH.U)
#define HW_HDMI_FC_VSYNCINWIDTH_WR(v)     (HW_HDMI_FC_VSYNCINWIDTH.U = (v))
#define HW_HDMI_FC_VSYNCINWIDTH_SET(v)    (HW_HDMI_FC_VSYNCINWIDTH_WR(HW_HDMI_FC_VSYNCINWIDTH_RD() |  (v)))
#define HW_HDMI_FC_VSYNCINWIDTH_CLR(v)    (HW_HDMI_FC_VSYNCINWIDTH_WR(HW_HDMI_FC_VSYNCINWIDTH_RD() & ~(v)))
#define HW_HDMI_FC_VSYNCINWIDTH_TOG(v)    (HW_HDMI_FC_VSYNCINWIDTH_WR(HW_HDMI_FC_VSYNCINWIDTH_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSYNCINWIDTH bitfields
 */

/*! @name Register HDMI_FC_VSYNCINWIDTH, field V_IN_WIDTH[5:0] (RW)
 *
 * Value after Reset: 000000b Input video Vsync active pulse width: Integer number of pixel clock
 * cycles [0...63].
 */
//@{
#define BP_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH      (0)      //!< Bit position for HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH.
#define BM_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH      (0x0000003f)  //!< Bit mask for HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH.

//! @brief Get value of HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH from a register value.
#define BG_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH) >> BP_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH)

//! @brief Format value for bitfield HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH.
#define BF_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH) & BM_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the V_IN_WIDTH field to a new value.
#define BW_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH(v)   (HW_HDMI_FC_VSYNCINWIDTH_WR((HW_HDMI_FC_VSYNCINWIDTH_RD() & ~BM_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH) | BF_HDMI_FC_VSYNCINWIDTH_V_IN_WIDTH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INFREQ0 - Frame Composer Input Video Refresh Rate Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INFREQ0 - Frame Composer Input Video Refresh Rate Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_infreq0
{
    reg8_t U;
    struct _hw_hdmi_fc_infreq0_bitfields
    {
        unsigned char INFREQ : 8; //!< [7:0] Video refresh rate in Hz*1E3 format.
    } B;
} hw_hdmi_fc_infreq0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INFREQ0 register
 */
//@{
#define HW_HDMI_FC_INFREQ0_ADDR      (REGS_HDMI_BASE + 0x100e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INFREQ0           (*(volatile hw_hdmi_fc_infreq0_t *) HW_HDMI_FC_INFREQ0_ADDR)
#define HW_HDMI_FC_INFREQ0_RD()      (HW_HDMI_FC_INFREQ0.U)
#define HW_HDMI_FC_INFREQ0_WR(v)     (HW_HDMI_FC_INFREQ0.U = (v))
#define HW_HDMI_FC_INFREQ0_SET(v)    (HW_HDMI_FC_INFREQ0_WR(HW_HDMI_FC_INFREQ0_RD() |  (v)))
#define HW_HDMI_FC_INFREQ0_CLR(v)    (HW_HDMI_FC_INFREQ0_WR(HW_HDMI_FC_INFREQ0_RD() & ~(v)))
#define HW_HDMI_FC_INFREQ0_TOG(v)    (HW_HDMI_FC_INFREQ0_WR(HW_HDMI_FC_INFREQ0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INFREQ0 bitfields
 */

/*! @name Register HDMI_FC_INFREQ0, field INFREQ[7:0] (RW)
 *
 * Video refresh rate in Hz*1E3 format. This registers are provided for debug and informative
 * purposes. No data is written to this registers by the H13TCTRL and the data here written by
 * software is not used in any way by the H13TCTRL.
 */
//@{
#define BP_HDMI_FC_INFREQ0_INFREQ      (0)      //!< Bit position for HDMI_FC_INFREQ0_INFREQ.
#define BM_HDMI_FC_INFREQ0_INFREQ      (0x000000ff)  //!< Bit mask for HDMI_FC_INFREQ0_INFREQ.

//! @brief Get value of HDMI_FC_INFREQ0_INFREQ from a register value.
#define BG_HDMI_FC_INFREQ0_INFREQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INFREQ0_INFREQ) >> BP_HDMI_FC_INFREQ0_INFREQ)

//! @brief Format value for bitfield HDMI_FC_INFREQ0_INFREQ.
#define BF_HDMI_FC_INFREQ0_INFREQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INFREQ0_INFREQ) & BM_HDMI_FC_INFREQ0_INFREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INFREQ field to a new value.
#define BW_HDMI_FC_INFREQ0_INFREQ(v)   (HW_HDMI_FC_INFREQ0_WR((HW_HDMI_FC_INFREQ0_RD() & ~BM_HDMI_FC_INFREQ0_INFREQ) | BF_HDMI_FC_INFREQ0_INFREQ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INFREQ1 - Frame Composer Input Video Refresh Rate Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INFREQ1 - Frame Composer Input Video Refresh Rate Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_infreq1
{
    reg8_t U;
    struct _hw_hdmi_fc_infreq1_bitfields
    {
        unsigned char INFREQ : 8; //!< [7:0] Video refresh rate in Hz*1E3 format.
    } B;
} hw_hdmi_fc_infreq1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INFREQ1 register
 */
//@{
#define HW_HDMI_FC_INFREQ1_ADDR      (REGS_HDMI_BASE + 0x100f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INFREQ1           (*(volatile hw_hdmi_fc_infreq1_t *) HW_HDMI_FC_INFREQ1_ADDR)
#define HW_HDMI_FC_INFREQ1_RD()      (HW_HDMI_FC_INFREQ1.U)
#define HW_HDMI_FC_INFREQ1_WR(v)     (HW_HDMI_FC_INFREQ1.U = (v))
#define HW_HDMI_FC_INFREQ1_SET(v)    (HW_HDMI_FC_INFREQ1_WR(HW_HDMI_FC_INFREQ1_RD() |  (v)))
#define HW_HDMI_FC_INFREQ1_CLR(v)    (HW_HDMI_FC_INFREQ1_WR(HW_HDMI_FC_INFREQ1_RD() & ~(v)))
#define HW_HDMI_FC_INFREQ1_TOG(v)    (HW_HDMI_FC_INFREQ1_WR(HW_HDMI_FC_INFREQ1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INFREQ1 bitfields
 */

/*! @name Register HDMI_FC_INFREQ1, field INFREQ[7:0] (RW)
 *
 * Video refresh rate in Hz*1E3 format. This registers are provided for debug and informative
 * purposes. No data is written to this registers by the H13TCTRL and the data here written by
 * software is not used in any way by the H13TCTRL.
 */
//@{
#define BP_HDMI_FC_INFREQ1_INFREQ      (0)      //!< Bit position for HDMI_FC_INFREQ1_INFREQ.
#define BM_HDMI_FC_INFREQ1_INFREQ      (0x000000ff)  //!< Bit mask for HDMI_FC_INFREQ1_INFREQ.

//! @brief Get value of HDMI_FC_INFREQ1_INFREQ from a register value.
#define BG_HDMI_FC_INFREQ1_INFREQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INFREQ1_INFREQ) >> BP_HDMI_FC_INFREQ1_INFREQ)

//! @brief Format value for bitfield HDMI_FC_INFREQ1_INFREQ.
#define BF_HDMI_FC_INFREQ1_INFREQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INFREQ1_INFREQ) & BM_HDMI_FC_INFREQ1_INFREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INFREQ field to a new value.
#define BW_HDMI_FC_INFREQ1_INFREQ(v)   (HW_HDMI_FC_INFREQ1_WR((HW_HDMI_FC_INFREQ1_RD() & ~BM_HDMI_FC_INFREQ1_INFREQ) | BF_HDMI_FC_INFREQ1_INFREQ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_INFREQ2 - Frame Composer Input Video Refresh Rate Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_INFREQ2 - Frame Composer Input Video Refresh Rate Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_infreq2
{
    reg8_t U;
    struct _hw_hdmi_fc_infreq2_bitfields
    {
        unsigned char INFREQ : 4; //!< [3:0] Video refresh rate in Hz*1E3 format.
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_infreq2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_INFREQ2 register
 */
//@{
#define HW_HDMI_FC_INFREQ2_ADDR      (REGS_HDMI_BASE + 0x1010)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_INFREQ2           (*(volatile hw_hdmi_fc_infreq2_t *) HW_HDMI_FC_INFREQ2_ADDR)
#define HW_HDMI_FC_INFREQ2_RD()      (HW_HDMI_FC_INFREQ2.U)
#define HW_HDMI_FC_INFREQ2_WR(v)     (HW_HDMI_FC_INFREQ2.U = (v))
#define HW_HDMI_FC_INFREQ2_SET(v)    (HW_HDMI_FC_INFREQ2_WR(HW_HDMI_FC_INFREQ2_RD() |  (v)))
#define HW_HDMI_FC_INFREQ2_CLR(v)    (HW_HDMI_FC_INFREQ2_WR(HW_HDMI_FC_INFREQ2_RD() & ~(v)))
#define HW_HDMI_FC_INFREQ2_TOG(v)    (HW_HDMI_FC_INFREQ2_WR(HW_HDMI_FC_INFREQ2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_INFREQ2 bitfields
 */

/*! @name Register HDMI_FC_INFREQ2, field INFREQ[3:0] (RW)
 *
 * Video refresh rate in Hz*1E3 format. This registers are provided for debug and informative
 * purposes. No data is written to this registers by the H13TCTRL and the data here written by
 * software is not used in any way by the H13TCTRL. Value after Reset: 0000b
 */
//@{
#define BP_HDMI_FC_INFREQ2_INFREQ      (0)      //!< Bit position for HDMI_FC_INFREQ2_INFREQ.
#define BM_HDMI_FC_INFREQ2_INFREQ      (0x0000000f)  //!< Bit mask for HDMI_FC_INFREQ2_INFREQ.

//! @brief Get value of HDMI_FC_INFREQ2_INFREQ from a register value.
#define BG_HDMI_FC_INFREQ2_INFREQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_INFREQ2_INFREQ) >> BP_HDMI_FC_INFREQ2_INFREQ)

//! @brief Format value for bitfield HDMI_FC_INFREQ2_INFREQ.
#define BF_HDMI_FC_INFREQ2_INFREQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_INFREQ2_INFREQ) & BM_HDMI_FC_INFREQ2_INFREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INFREQ field to a new value.
#define BW_HDMI_FC_INFREQ2_INFREQ(v)   (HW_HDMI_FC_INFREQ2_WR((HW_HDMI_FC_INFREQ2_RD() & ~BM_HDMI_FC_INFREQ2_INFREQ) | BF_HDMI_FC_INFREQ2_INFREQ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CTRLDUR - Frame Composer Control Period Duration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CTRLDUR - Frame Composer Control Period Duration Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_ctrldur
{
    reg8_t U;
    struct _hw_hdmi_fc_ctrldur_bitfields
    {
        unsigned char CTRLPERIODDURATION : 8; //!< [7:0] Configuration of the control period minimum duration (min.
    } B;
} hw_hdmi_fc_ctrldur_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CTRLDUR register
 */
//@{
#define HW_HDMI_FC_CTRLDUR_ADDR      (REGS_HDMI_BASE + 0x1011)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CTRLDUR           (*(volatile hw_hdmi_fc_ctrldur_t *) HW_HDMI_FC_CTRLDUR_ADDR)
#define HW_HDMI_FC_CTRLDUR_RD()      (HW_HDMI_FC_CTRLDUR.U)
#define HW_HDMI_FC_CTRLDUR_WR(v)     (HW_HDMI_FC_CTRLDUR.U = (v))
#define HW_HDMI_FC_CTRLDUR_SET(v)    (HW_HDMI_FC_CTRLDUR_WR(HW_HDMI_FC_CTRLDUR_RD() |  (v)))
#define HW_HDMI_FC_CTRLDUR_CLR(v)    (HW_HDMI_FC_CTRLDUR_WR(HW_HDMI_FC_CTRLDUR_RD() & ~(v)))
#define HW_HDMI_FC_CTRLDUR_TOG(v)    (HW_HDMI_FC_CTRLDUR_WR(HW_HDMI_FC_CTRLDUR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CTRLDUR bitfields
 */

/*! @name Register HDMI_FC_CTRLDUR, field CTRLPERIODDURATION[7:0] (RW)
 *
 * Configuration of the control period minimum duration (min. of 12 pixel clock cycles, refer to
 * HDMI 1.4a specification). Integer number of pixel clocks cycles [0..255].
 */
//@{
#define BP_HDMI_FC_CTRLDUR_CTRLPERIODDURATION      (0)      //!< Bit position for HDMI_FC_CTRLDUR_CTRLPERIODDURATION.
#define BM_HDMI_FC_CTRLDUR_CTRLPERIODDURATION      (0x000000ff)  //!< Bit mask for HDMI_FC_CTRLDUR_CTRLPERIODDURATION.

//! @brief Get value of HDMI_FC_CTRLDUR_CTRLPERIODDURATION from a register value.
#define BG_HDMI_FC_CTRLDUR_CTRLPERIODDURATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CTRLDUR_CTRLPERIODDURATION) >> BP_HDMI_FC_CTRLDUR_CTRLPERIODDURATION)

//! @brief Format value for bitfield HDMI_FC_CTRLDUR_CTRLPERIODDURATION.
#define BF_HDMI_FC_CTRLDUR_CTRLPERIODDURATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CTRLDUR_CTRLPERIODDURATION) & BM_HDMI_FC_CTRLDUR_CTRLPERIODDURATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTRLPERIODDURATION field to a new value.
#define BW_HDMI_FC_CTRLDUR_CTRLPERIODDURATION(v)   (HW_HDMI_FC_CTRLDUR_WR((HW_HDMI_FC_CTRLDUR_RD() & ~BM_HDMI_FC_CTRLDUR_CTRLPERIODDURATION) | BF_HDMI_FC_CTRLDUR_CTRLPERIODDURATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_EXCTRLDUR - Frame Composer Extended Control Period Duration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_EXCTRLDUR - Frame Composer Extended Control Period Duration Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_exctrldur
{
    reg8_t U;
    struct _hw_hdmi_fc_exctrldur_bitfields
    {
        unsigned char EXCTRLPERIODDURATION : 8; //!< [7:0] Configuration of the extended control period minimum duration (min.
    } B;
} hw_hdmi_fc_exctrldur_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_EXCTRLDUR register
 */
//@{
#define HW_HDMI_FC_EXCTRLDUR_ADDR      (REGS_HDMI_BASE + 0x1012)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_EXCTRLDUR           (*(volatile hw_hdmi_fc_exctrldur_t *) HW_HDMI_FC_EXCTRLDUR_ADDR)
#define HW_HDMI_FC_EXCTRLDUR_RD()      (HW_HDMI_FC_EXCTRLDUR.U)
#define HW_HDMI_FC_EXCTRLDUR_WR(v)     (HW_HDMI_FC_EXCTRLDUR.U = (v))
#define HW_HDMI_FC_EXCTRLDUR_SET(v)    (HW_HDMI_FC_EXCTRLDUR_WR(HW_HDMI_FC_EXCTRLDUR_RD() |  (v)))
#define HW_HDMI_FC_EXCTRLDUR_CLR(v)    (HW_HDMI_FC_EXCTRLDUR_WR(HW_HDMI_FC_EXCTRLDUR_RD() & ~(v)))
#define HW_HDMI_FC_EXCTRLDUR_TOG(v)    (HW_HDMI_FC_EXCTRLDUR_WR(HW_HDMI_FC_EXCTRLDUR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_EXCTRLDUR bitfields
 */

/*! @name Register HDMI_FC_EXCTRLDUR, field EXCTRLPERIODDURATION[7:0] (RW)
 *
 * Configuration of the extended control period minimum duration (min. of 32 pixel clock cycles, see
 * HDMI 1.4a specification). Integer number of pixel clocks cycles [0..255].
 */
//@{
#define BP_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION      (0)      //!< Bit position for HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION.
#define BM_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION      (0x000000ff)  //!< Bit mask for HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION.

//! @brief Get value of HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION from a register value.
#define BG_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION) >> BP_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION)

//! @brief Format value for bitfield HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION.
#define BF_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION) & BM_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXCTRLPERIODDURATION field to a new value.
#define BW_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION(v)   (HW_HDMI_FC_EXCTRLDUR_WR((HW_HDMI_FC_EXCTRLDUR_RD() & ~BM_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION) | BF_HDMI_FC_EXCTRLDUR_EXCTRLPERIODDURATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_EXCTRLSPAC - Frame Composer Extended Control Period Maximum Spacing Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_EXCTRLSPAC - Frame Composer Extended Control Period Maximum Spacing Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_exctrlspac
{
    reg8_t U;
    struct _hw_hdmi_fc_exctrlspac_bitfields
    {
        unsigned char EXCTRLPERIODSPACING : 8; //!< [7:0] Configuration of the maximum spacing between consecutive extended control periods (max of 50msec, see HDMI 1.4a specification):
    } B;
} hw_hdmi_fc_exctrlspac_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_EXCTRLSPAC register
 */
//@{
#define HW_HDMI_FC_EXCTRLSPAC_ADDR      (REGS_HDMI_BASE + 0x1013)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_EXCTRLSPAC           (*(volatile hw_hdmi_fc_exctrlspac_t *) HW_HDMI_FC_EXCTRLSPAC_ADDR)
#define HW_HDMI_FC_EXCTRLSPAC_RD()      (HW_HDMI_FC_EXCTRLSPAC.U)
#define HW_HDMI_FC_EXCTRLSPAC_WR(v)     (HW_HDMI_FC_EXCTRLSPAC.U = (v))
#define HW_HDMI_FC_EXCTRLSPAC_SET(v)    (HW_HDMI_FC_EXCTRLSPAC_WR(HW_HDMI_FC_EXCTRLSPAC_RD() |  (v)))
#define HW_HDMI_FC_EXCTRLSPAC_CLR(v)    (HW_HDMI_FC_EXCTRLSPAC_WR(HW_HDMI_FC_EXCTRLSPAC_RD() & ~(v)))
#define HW_HDMI_FC_EXCTRLSPAC_TOG(v)    (HW_HDMI_FC_EXCTRLSPAC_WR(HW_HDMI_FC_EXCTRLSPAC_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_EXCTRLSPAC bitfields
 */

/*! @name Register HDMI_FC_EXCTRLSPAC, field EXCTRLPERIODSPACING[7:0] (RW)
 *
 * Configuration of the maximum spacing between consecutive extended control periods (max of 50msec,
 * see HDMI 1.4a specification): generated spacing = (1/freq tmds
 * clock)*256*256*extctrlperiodspacing
 */
//@{
#define BP_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING      (0)      //!< Bit position for HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING.
#define BM_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING      (0x000000ff)  //!< Bit mask for HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING.

//! @brief Get value of HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING from a register value.
#define BG_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING) >> BP_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING)

//! @brief Format value for bitfield HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING.
#define BF_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING) & BM_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXCTRLPERIODSPACING field to a new value.
#define BW_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING(v)   (HW_HDMI_FC_EXCTRLSPAC_WR((HW_HDMI_FC_EXCTRLSPAC_RD() & ~BM_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING) | BF_HDMI_FC_EXCTRLSPAC_EXCTRLPERIODSPACING(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CH0PREAM - Frame Composer Channel 0 Non-Preamble Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CH0PREAM - Frame Composer Channel 0 Non-Preamble Data Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_ch0pream
{
    reg8_t U;
    struct _hw_hdmi_fc_ch0pream_bitfields
    {
        unsigned char CH0_PREAMBLE_FILTER : 8; //!< [7:0] When in control mode, configures 8-bits that are going to fill the channel 0 data lines not used to transmit the preamble (for more clarifications refer to HDMI 1.4a specification).
    } B;
} hw_hdmi_fc_ch0pream_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CH0PREAM register
 */
//@{
#define HW_HDMI_FC_CH0PREAM_ADDR      (REGS_HDMI_BASE + 0x1014)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CH0PREAM           (*(volatile hw_hdmi_fc_ch0pream_t *) HW_HDMI_FC_CH0PREAM_ADDR)
#define HW_HDMI_FC_CH0PREAM_RD()      (HW_HDMI_FC_CH0PREAM.U)
#define HW_HDMI_FC_CH0PREAM_WR(v)     (HW_HDMI_FC_CH0PREAM.U = (v))
#define HW_HDMI_FC_CH0PREAM_SET(v)    (HW_HDMI_FC_CH0PREAM_WR(HW_HDMI_FC_CH0PREAM_RD() |  (v)))
#define HW_HDMI_FC_CH0PREAM_CLR(v)    (HW_HDMI_FC_CH0PREAM_WR(HW_HDMI_FC_CH0PREAM_RD() & ~(v)))
#define HW_HDMI_FC_CH0PREAM_TOG(v)    (HW_HDMI_FC_CH0PREAM_WR(HW_HDMI_FC_CH0PREAM_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CH0PREAM bitfields
 */

/*! @name Register HDMI_FC_CH0PREAM, field CH0_PREAMBLE_FILTER[7:0] (RW)
 *
 * When in control mode, configures 8-bits that are going to fill the channel 0 data lines not used
 * to transmit the preamble (for more clarifications refer to HDMI 1.4a specification).
 */
//@{
#define BP_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER      (0)      //!< Bit position for HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER.
#define BM_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER      (0x000000ff)  //!< Bit mask for HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER.

//! @brief Get value of HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER from a register value.
#define BG_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER) >> BP_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER)

//! @brief Format value for bitfield HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER.
#define BF_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER) & BM_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH0_PREAMBLE_FILTER field to a new value.
#define BW_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER(v)   (HW_HDMI_FC_CH0PREAM_WR((HW_HDMI_FC_CH0PREAM_RD() & ~BM_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER) | BF_HDMI_FC_CH0PREAM_CH0_PREAMBLE_FILTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CH1PREAM - Frame Composer Channel 1 Non-Preamble Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CH1PREAM - Frame Composer Channel 1 Non-Preamble Data Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_ch1pream
{
    reg8_t U;
    struct _hw_hdmi_fc_ch1pream_bitfields
    {
        unsigned char CH1_PREAMBLE_FILTER : 6; //!< [5:0] When in control mode, configures 6-bits that are going to fill the channel 1 data lines not used to transmit the preamble (for more clarifications refer to HDMI 1.4a specification).
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_fc_ch1pream_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CH1PREAM register
 */
//@{
#define HW_HDMI_FC_CH1PREAM_ADDR      (REGS_HDMI_BASE + 0x1015)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CH1PREAM           (*(volatile hw_hdmi_fc_ch1pream_t *) HW_HDMI_FC_CH1PREAM_ADDR)
#define HW_HDMI_FC_CH1PREAM_RD()      (HW_HDMI_FC_CH1PREAM.U)
#define HW_HDMI_FC_CH1PREAM_WR(v)     (HW_HDMI_FC_CH1PREAM.U = (v))
#define HW_HDMI_FC_CH1PREAM_SET(v)    (HW_HDMI_FC_CH1PREAM_WR(HW_HDMI_FC_CH1PREAM_RD() |  (v)))
#define HW_HDMI_FC_CH1PREAM_CLR(v)    (HW_HDMI_FC_CH1PREAM_WR(HW_HDMI_FC_CH1PREAM_RD() & ~(v)))
#define HW_HDMI_FC_CH1PREAM_TOG(v)    (HW_HDMI_FC_CH1PREAM_WR(HW_HDMI_FC_CH1PREAM_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CH1PREAM bitfields
 */

/*! @name Register HDMI_FC_CH1PREAM, field CH1_PREAMBLE_FILTER[5:0] (RW)
 *
 * When in control mode, configures 6-bits that are going to fill the channel 1 data lines not used
 * to transmit the preamble (for more clarifications refer to HDMI 1.4a specification).
 */
//@{
#define BP_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER      (0)      //!< Bit position for HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER.
#define BM_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER      (0x0000003f)  //!< Bit mask for HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER.

//! @brief Get value of HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER from a register value.
#define BG_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER) >> BP_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER)

//! @brief Format value for bitfield HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER.
#define BF_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER) & BM_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH1_PREAMBLE_FILTER field to a new value.
#define BW_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER(v)   (HW_HDMI_FC_CH1PREAM_WR((HW_HDMI_FC_CH1PREAM_RD() & ~BM_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER) | BF_HDMI_FC_CH1PREAM_CH1_PREAMBLE_FILTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CH2PREAM - Frame Composer Channel 2 Non-Preamble Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CH2PREAM - Frame Composer Channel 2 Non-Preamble Data Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_ch2pream
{
    reg8_t U;
    struct _hw_hdmi_fc_ch2pream_bitfields
    {
        unsigned char CH2_PREAMBLE_FILTER : 6; //!< [5:0] When in control mode, configures 6-bits that are going to fill the channel 2 data lines not used to transmit the preamble (for more clarifications, see HDMI 1.4a specification).
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_fc_ch2pream_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CH2PREAM register
 */
//@{
#define HW_HDMI_FC_CH2PREAM_ADDR      (REGS_HDMI_BASE + 0x1016)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CH2PREAM           (*(volatile hw_hdmi_fc_ch2pream_t *) HW_HDMI_FC_CH2PREAM_ADDR)
#define HW_HDMI_FC_CH2PREAM_RD()      (HW_HDMI_FC_CH2PREAM.U)
#define HW_HDMI_FC_CH2PREAM_WR(v)     (HW_HDMI_FC_CH2PREAM.U = (v))
#define HW_HDMI_FC_CH2PREAM_SET(v)    (HW_HDMI_FC_CH2PREAM_WR(HW_HDMI_FC_CH2PREAM_RD() |  (v)))
#define HW_HDMI_FC_CH2PREAM_CLR(v)    (HW_HDMI_FC_CH2PREAM_WR(HW_HDMI_FC_CH2PREAM_RD() & ~(v)))
#define HW_HDMI_FC_CH2PREAM_TOG(v)    (HW_HDMI_FC_CH2PREAM_WR(HW_HDMI_FC_CH2PREAM_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CH2PREAM bitfields
 */

/*! @name Register HDMI_FC_CH2PREAM, field CH2_PREAMBLE_FILTER[5:0] (RW)
 *
 * When in control mode, configures 6-bits that are going to fill the channel 2 data lines not used
 * to transmit the preamble (for more clarifications, see HDMI 1.4a specification).
 */
//@{
#define BP_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER      (0)      //!< Bit position for HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER.
#define BM_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER      (0x0000003f)  //!< Bit mask for HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER.

//! @brief Get value of HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER from a register value.
#define BG_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER) >> BP_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER)

//! @brief Format value for bitfield HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER.
#define BF_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER) & BM_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH2_PREAMBLE_FILTER field to a new value.
#define BW_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER(v)   (HW_HDMI_FC_CH2PREAM_WR((HW_HDMI_FC_CH2PREAM_RD() & ~BM_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER) | BF_HDMI_FC_CH2PREAM_CH2_PREAMBLE_FILTER(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVICONF3 - Frame Composer AVI Configuration Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVICONF3 - Frame Composer AVI Configuration Register 3 (RW)
 *
 * Reset value: 0x00
 *
 * configuration of Quantization range and IT content type.
 */
typedef union _hw_hdmi_fc_aviconf3
{
    reg8_t U;
    struct _hw_hdmi_fc_aviconf3_bitfields
    {
        unsigned char CN1 : 2; //!< [1:0] IT content type according to CEA specification
        unsigned char YQ1 : 2; //!< [3:2] Quantization range according to CEA specification.
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_aviconf3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVICONF3 register
 */
//@{
#define HW_HDMI_FC_AVICONF3_ADDR      (REGS_HDMI_BASE + 0x1017)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVICONF3           (*(volatile hw_hdmi_fc_aviconf3_t *) HW_HDMI_FC_AVICONF3_ADDR)
#define HW_HDMI_FC_AVICONF3_RD()      (HW_HDMI_FC_AVICONF3.U)
#define HW_HDMI_FC_AVICONF3_WR(v)     (HW_HDMI_FC_AVICONF3.U = (v))
#define HW_HDMI_FC_AVICONF3_SET(v)    (HW_HDMI_FC_AVICONF3_WR(HW_HDMI_FC_AVICONF3_RD() |  (v)))
#define HW_HDMI_FC_AVICONF3_CLR(v)    (HW_HDMI_FC_AVICONF3_WR(HW_HDMI_FC_AVICONF3_RD() & ~(v)))
#define HW_HDMI_FC_AVICONF3_TOG(v)    (HW_HDMI_FC_AVICONF3_WR(HW_HDMI_FC_AVICONF3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVICONF3 bitfields
 */

/*! @name Register HDMI_FC_AVICONF3, field CN1[1:0] (RW)
 *
 * IT content type according to CEA specification
 */
//@{
#define BP_HDMI_FC_AVICONF3_CN1      (0)      //!< Bit position for HDMI_FC_AVICONF3_CN1.
#define BM_HDMI_FC_AVICONF3_CN1      (0x00000003)  //!< Bit mask for HDMI_FC_AVICONF3_CN1.

//! @brief Get value of HDMI_FC_AVICONF3_CN1 from a register value.
#define BG_HDMI_FC_AVICONF3_CN1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF3_CN1) >> BP_HDMI_FC_AVICONF3_CN1)

//! @brief Format value for bitfield HDMI_FC_AVICONF3_CN1.
#define BF_HDMI_FC_AVICONF3_CN1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF3_CN1) & BM_HDMI_FC_AVICONF3_CN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CN1 field to a new value.
#define BW_HDMI_FC_AVICONF3_CN1(v)   (HW_HDMI_FC_AVICONF3_WR((HW_HDMI_FC_AVICONF3_RD() & ~BM_HDMI_FC_AVICONF3_CN1) | BF_HDMI_FC_AVICONF3_CN1(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF3, field YQ1[3:2] (RW)
 *
 * Quantization range according to CEA specification.
 */
//@{
#define BP_HDMI_FC_AVICONF3_YQ1      (2)      //!< Bit position for HDMI_FC_AVICONF3_YQ1.
#define BM_HDMI_FC_AVICONF3_YQ1      (0x0000000c)  //!< Bit mask for HDMI_FC_AVICONF3_YQ1.

//! @brief Get value of HDMI_FC_AVICONF3_YQ1 from a register value.
#define BG_HDMI_FC_AVICONF3_YQ1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF3_YQ1) >> BP_HDMI_FC_AVICONF3_YQ1)

//! @brief Format value for bitfield HDMI_FC_AVICONF3_YQ1.
#define BF_HDMI_FC_AVICONF3_YQ1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF3_YQ1) & BM_HDMI_FC_AVICONF3_YQ1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the YQ1 field to a new value.
#define BW_HDMI_FC_AVICONF3_YQ1(v)   (HW_HDMI_FC_AVICONF3_WR((HW_HDMI_FC_AVICONF3_RD() & ~BM_HDMI_FC_AVICONF3_YQ1) | BF_HDMI_FC_AVICONF3_YQ1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GCP - Frame Composer GCP Packet Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GCP - Frame Composer GCP Packet Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the General Control Packet A/V mute indicators and the default phase.
 */
typedef union _hw_hdmi_fc_gcp
{
    reg8_t U;
    struct _hw_hdmi_fc_gcp_bitfields
    {
        unsigned char CLEAR_AVMUTE : 1; //!< [0] Value of "clear_avmute" in the GCP packet.
        unsigned char SET_AVMUTE : 1; //!< [1] Value of "set_avmute" in the GCP packet.
        unsigned char DEFAULT_PHASE : 1; //!< [2] Value of "default_phase" in the GCP packet.
        unsigned char RESERVED0 : 5; //!< [7:3] Reserved
    } B;
} hw_hdmi_fc_gcp_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GCP register
 */
//@{
#define HW_HDMI_FC_GCP_ADDR      (REGS_HDMI_BASE + 0x1018)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GCP           (*(volatile hw_hdmi_fc_gcp_t *) HW_HDMI_FC_GCP_ADDR)
#define HW_HDMI_FC_GCP_RD()      (HW_HDMI_FC_GCP.U)
#define HW_HDMI_FC_GCP_WR(v)     (HW_HDMI_FC_GCP.U = (v))
#define HW_HDMI_FC_GCP_SET(v)    (HW_HDMI_FC_GCP_WR(HW_HDMI_FC_GCP_RD() |  (v)))
#define HW_HDMI_FC_GCP_CLR(v)    (HW_HDMI_FC_GCP_WR(HW_HDMI_FC_GCP_RD() & ~(v)))
#define HW_HDMI_FC_GCP_TOG(v)    (HW_HDMI_FC_GCP_WR(HW_HDMI_FC_GCP_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GCP bitfields
 */

/*! @name Register HDMI_FC_GCP, field CLEAR_AVMUTE[0] (RW)
 *
 * Value of "clear_avmute" in the GCP packet. Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_GCP_CLEAR_AVMUTE      (0)      //!< Bit position for HDMI_FC_GCP_CLEAR_AVMUTE.
#define BM_HDMI_FC_GCP_CLEAR_AVMUTE      (0x00000001)  //!< Bit mask for HDMI_FC_GCP_CLEAR_AVMUTE.

//! @brief Get value of HDMI_FC_GCP_CLEAR_AVMUTE from a register value.
#define BG_HDMI_FC_GCP_CLEAR_AVMUTE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GCP_CLEAR_AVMUTE) >> BP_HDMI_FC_GCP_CLEAR_AVMUTE)

//! @brief Format value for bitfield HDMI_FC_GCP_CLEAR_AVMUTE.
#define BF_HDMI_FC_GCP_CLEAR_AVMUTE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GCP_CLEAR_AVMUTE) & BM_HDMI_FC_GCP_CLEAR_AVMUTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLEAR_AVMUTE field to a new value.
#define BW_HDMI_FC_GCP_CLEAR_AVMUTE(v)   (HW_HDMI_FC_GCP_WR((HW_HDMI_FC_GCP_RD() & ~BM_HDMI_FC_GCP_CLEAR_AVMUTE) | BF_HDMI_FC_GCP_CLEAR_AVMUTE(v)))
#endif
//@}

/*! @name Register HDMI_FC_GCP, field SET_AVMUTE[1] (RW)
 *
 * Value of "set_avmute" in the GCP packet. Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_GCP_SET_AVMUTE      (1)      //!< Bit position for HDMI_FC_GCP_SET_AVMUTE.
#define BM_HDMI_FC_GCP_SET_AVMUTE      (0x00000002)  //!< Bit mask for HDMI_FC_GCP_SET_AVMUTE.

//! @brief Get value of HDMI_FC_GCP_SET_AVMUTE from a register value.
#define BG_HDMI_FC_GCP_SET_AVMUTE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GCP_SET_AVMUTE) >> BP_HDMI_FC_GCP_SET_AVMUTE)

//! @brief Format value for bitfield HDMI_FC_GCP_SET_AVMUTE.
#define BF_HDMI_FC_GCP_SET_AVMUTE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GCP_SET_AVMUTE) & BM_HDMI_FC_GCP_SET_AVMUTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SET_AVMUTE field to a new value.
#define BW_HDMI_FC_GCP_SET_AVMUTE(v)   (HW_HDMI_FC_GCP_WR((HW_HDMI_FC_GCP_RD() & ~BM_HDMI_FC_GCP_SET_AVMUTE) | BF_HDMI_FC_GCP_SET_AVMUTE(v)))
#endif
//@}

/*! @name Register HDMI_FC_GCP, field DEFAULT_PHASE[2] (RW)
 *
 * Value of "default_phase" in the GCP packet. This data should be equal to the default phase used
 * at Video packetizer packing machine. Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_GCP_DEFAULT_PHASE      (2)      //!< Bit position for HDMI_FC_GCP_DEFAULT_PHASE.
#define BM_HDMI_FC_GCP_DEFAULT_PHASE      (0x00000004)  //!< Bit mask for HDMI_FC_GCP_DEFAULT_PHASE.

//! @brief Get value of HDMI_FC_GCP_DEFAULT_PHASE from a register value.
#define BG_HDMI_FC_GCP_DEFAULT_PHASE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GCP_DEFAULT_PHASE) >> BP_HDMI_FC_GCP_DEFAULT_PHASE)

//! @brief Format value for bitfield HDMI_FC_GCP_DEFAULT_PHASE.
#define BF_HDMI_FC_GCP_DEFAULT_PHASE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GCP_DEFAULT_PHASE) & BM_HDMI_FC_GCP_DEFAULT_PHASE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEFAULT_PHASE field to a new value.
#define BW_HDMI_FC_GCP_DEFAULT_PHASE(v)   (HW_HDMI_FC_GCP_WR((HW_HDMI_FC_GCP_RD() & ~BM_HDMI_FC_GCP_DEFAULT_PHASE) | BF_HDMI_FC_GCP_DEFAULT_PHASE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVICONF0 - Frame Composer AVI Packet Configuration Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVICONF0 - Frame Composer AVI Packet Configuration Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the AVI infoFrame: RGB/YCC indication Bar information Scan
 * information Active format present Progressive/Interlaced indicator Active aspect ratio Picture
 * aspect ratio Colorimetry IT content Extended colorimetry Quantization range Non-uniform picture
 * scaling For more information, refer to HDMI 1.4a and CEA - 861D specifications.
 */
typedef union _hw_hdmi_fc_aviconf0
{
    reg8_t U;
    struct _hw_hdmi_fc_aviconf0_bitfields
    {
        unsigned char FC_AVICONF0 : 2; //!< [1:0] RGB/YCC indication
        unsigned char FC_AVICONF01 : 2; //!< [3:2] Bar information
        unsigned char FC_AVICONF02 : 2; //!< [5:4] Scan information
        unsigned char FC_AVICONF03 : 1; //!< [6] Active format present
        unsigned char FC_AVICONF04 : 1; //!< [7] 
    } B;
} hw_hdmi_fc_aviconf0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVICONF0 register
 */
//@{
#define HW_HDMI_FC_AVICONF0_ADDR      (REGS_HDMI_BASE + 0x1019)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVICONF0           (*(volatile hw_hdmi_fc_aviconf0_t *) HW_HDMI_FC_AVICONF0_ADDR)
#define HW_HDMI_FC_AVICONF0_RD()      (HW_HDMI_FC_AVICONF0.U)
#define HW_HDMI_FC_AVICONF0_WR(v)     (HW_HDMI_FC_AVICONF0.U = (v))
#define HW_HDMI_FC_AVICONF0_SET(v)    (HW_HDMI_FC_AVICONF0_WR(HW_HDMI_FC_AVICONF0_RD() |  (v)))
#define HW_HDMI_FC_AVICONF0_CLR(v)    (HW_HDMI_FC_AVICONF0_WR(HW_HDMI_FC_AVICONF0_RD() & ~(v)))
#define HW_HDMI_FC_AVICONF0_TOG(v)    (HW_HDMI_FC_AVICONF0_WR(HW_HDMI_FC_AVICONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVICONF0 bitfields
 */

/*! @name Register HDMI_FC_AVICONF0, field FC_AVICONF0[1:0] (RW)
 *
 * RGB/YCC indication Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_AVICONF0_FC_AVICONF0      (0)      //!< Bit position for HDMI_FC_AVICONF0_FC_AVICONF0.
#define BM_HDMI_FC_AVICONF0_FC_AVICONF0      (0x00000003)  //!< Bit mask for HDMI_FC_AVICONF0_FC_AVICONF0.

//! @brief Get value of HDMI_FC_AVICONF0_FC_AVICONF0 from a register value.
#define BG_HDMI_FC_AVICONF0_FC_AVICONF0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF0_FC_AVICONF0) >> BP_HDMI_FC_AVICONF0_FC_AVICONF0)

//! @brief Format value for bitfield HDMI_FC_AVICONF0_FC_AVICONF0.
#define BF_HDMI_FC_AVICONF0_FC_AVICONF0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF0_FC_AVICONF0) & BM_HDMI_FC_AVICONF0_FC_AVICONF0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF0 field to a new value.
#define BW_HDMI_FC_AVICONF0_FC_AVICONF0(v)   (HW_HDMI_FC_AVICONF0_WR((HW_HDMI_FC_AVICONF0_RD() & ~BM_HDMI_FC_AVICONF0_FC_AVICONF0) | BF_HDMI_FC_AVICONF0_FC_AVICONF0(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF0, field FC_AVICONF01[3:2] (RW)
 *
 * Bar information
 */
//@{
#define BP_HDMI_FC_AVICONF0_FC_AVICONF01      (2)      //!< Bit position for HDMI_FC_AVICONF0_FC_AVICONF01.
#define BM_HDMI_FC_AVICONF0_FC_AVICONF01      (0x0000000c)  //!< Bit mask for HDMI_FC_AVICONF0_FC_AVICONF01.

//! @brief Get value of HDMI_FC_AVICONF0_FC_AVICONF01 from a register value.
#define BG_HDMI_FC_AVICONF0_FC_AVICONF01(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF0_FC_AVICONF01) >> BP_HDMI_FC_AVICONF0_FC_AVICONF01)

//! @brief Format value for bitfield HDMI_FC_AVICONF0_FC_AVICONF01.
#define BF_HDMI_FC_AVICONF0_FC_AVICONF01(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF0_FC_AVICONF01) & BM_HDMI_FC_AVICONF0_FC_AVICONF01)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF01 field to a new value.
#define BW_HDMI_FC_AVICONF0_FC_AVICONF01(v)   (HW_HDMI_FC_AVICONF0_WR((HW_HDMI_FC_AVICONF0_RD() & ~BM_HDMI_FC_AVICONF0_FC_AVICONF01) | BF_HDMI_FC_AVICONF0_FC_AVICONF01(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF0, field FC_AVICONF02[5:4] (RW)
 *
 * Scan information
 */
//@{
#define BP_HDMI_FC_AVICONF0_FC_AVICONF02      (4)      //!< Bit position for HDMI_FC_AVICONF0_FC_AVICONF02.
#define BM_HDMI_FC_AVICONF0_FC_AVICONF02      (0x00000030)  //!< Bit mask for HDMI_FC_AVICONF0_FC_AVICONF02.

//! @brief Get value of HDMI_FC_AVICONF0_FC_AVICONF02 from a register value.
#define BG_HDMI_FC_AVICONF0_FC_AVICONF02(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF0_FC_AVICONF02) >> BP_HDMI_FC_AVICONF0_FC_AVICONF02)

//! @brief Format value for bitfield HDMI_FC_AVICONF0_FC_AVICONF02.
#define BF_HDMI_FC_AVICONF0_FC_AVICONF02(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF0_FC_AVICONF02) & BM_HDMI_FC_AVICONF0_FC_AVICONF02)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF02 field to a new value.
#define BW_HDMI_FC_AVICONF0_FC_AVICONF02(v)   (HW_HDMI_FC_AVICONF0_WR((HW_HDMI_FC_AVICONF0_RD() & ~BM_HDMI_FC_AVICONF0_FC_AVICONF02) | BF_HDMI_FC_AVICONF0_FC_AVICONF02(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF0, field FC_AVICONF03[6] (RW)
 *
 * Active format present
 */
//@{
#define BP_HDMI_FC_AVICONF0_FC_AVICONF03      (6)      //!< Bit position for HDMI_FC_AVICONF0_FC_AVICONF03.
#define BM_HDMI_FC_AVICONF0_FC_AVICONF03      (0x00000040)  //!< Bit mask for HDMI_FC_AVICONF0_FC_AVICONF03.

//! @brief Get value of HDMI_FC_AVICONF0_FC_AVICONF03 from a register value.
#define BG_HDMI_FC_AVICONF0_FC_AVICONF03(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF0_FC_AVICONF03) >> BP_HDMI_FC_AVICONF0_FC_AVICONF03)

//! @brief Format value for bitfield HDMI_FC_AVICONF0_FC_AVICONF03.
#define BF_HDMI_FC_AVICONF0_FC_AVICONF03(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF0_FC_AVICONF03) & BM_HDMI_FC_AVICONF0_FC_AVICONF03)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF03 field to a new value.
#define BW_HDMI_FC_AVICONF0_FC_AVICONF03(v)   (HW_HDMI_FC_AVICONF0_WR((HW_HDMI_FC_AVICONF0_RD() & ~BM_HDMI_FC_AVICONF0_FC_AVICONF03) | BF_HDMI_FC_AVICONF0_FC_AVICONF03(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF0, field FC_AVICONF04[7] (RW)
 */
//@{
#define BP_HDMI_FC_AVICONF0_FC_AVICONF04      (7)      //!< Bit position for HDMI_FC_AVICONF0_FC_AVICONF04.
#define BM_HDMI_FC_AVICONF0_FC_AVICONF04      (0x00000080)  //!< Bit mask for HDMI_FC_AVICONF0_FC_AVICONF04.

//! @brief Get value of HDMI_FC_AVICONF0_FC_AVICONF04 from a register value.
#define BG_HDMI_FC_AVICONF0_FC_AVICONF04(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF0_FC_AVICONF04) >> BP_HDMI_FC_AVICONF0_FC_AVICONF04)

//! @brief Format value for bitfield HDMI_FC_AVICONF0_FC_AVICONF04.
#define BF_HDMI_FC_AVICONF0_FC_AVICONF04(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF0_FC_AVICONF04) & BM_HDMI_FC_AVICONF0_FC_AVICONF04)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF04 field to a new value.
#define BW_HDMI_FC_AVICONF0_FC_AVICONF04(v)   (HW_HDMI_FC_AVICONF0_WR((HW_HDMI_FC_AVICONF0_RD() & ~BM_HDMI_FC_AVICONF0_FC_AVICONF04) | BF_HDMI_FC_AVICONF0_FC_AVICONF04(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVICONF1 - Frame Composer AVI Packet Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVICONF1 - Frame Composer AVI Packet Configuration Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_aviconf1
{
    reg8_t U;
    struct _hw_hdmi_fc_aviconf1_bitfields
    {
        unsigned char FC_AVICONF1 : 4; //!< [3:0] Active aspect ratio
        unsigned char FC_AVICONF11 : 2; //!< [5:4] Picture aspect ratio
        unsigned char FC_AVICONF0 : 2; //!< [7:6] Colorimetry
    } B;
} hw_hdmi_fc_aviconf1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVICONF1 register
 */
//@{
#define HW_HDMI_FC_AVICONF1_ADDR      (REGS_HDMI_BASE + 0x101a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVICONF1           (*(volatile hw_hdmi_fc_aviconf1_t *) HW_HDMI_FC_AVICONF1_ADDR)
#define HW_HDMI_FC_AVICONF1_RD()      (HW_HDMI_FC_AVICONF1.U)
#define HW_HDMI_FC_AVICONF1_WR(v)     (HW_HDMI_FC_AVICONF1.U = (v))
#define HW_HDMI_FC_AVICONF1_SET(v)    (HW_HDMI_FC_AVICONF1_WR(HW_HDMI_FC_AVICONF1_RD() |  (v)))
#define HW_HDMI_FC_AVICONF1_CLR(v)    (HW_HDMI_FC_AVICONF1_WR(HW_HDMI_FC_AVICONF1_RD() & ~(v)))
#define HW_HDMI_FC_AVICONF1_TOG(v)    (HW_HDMI_FC_AVICONF1_WR(HW_HDMI_FC_AVICONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVICONF1 bitfields
 */

/*! @name Register HDMI_FC_AVICONF1, field FC_AVICONF1[3:0] (RW)
 *
 * Active aspect ratio Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_AVICONF1_FC_AVICONF1      (0)      //!< Bit position for HDMI_FC_AVICONF1_FC_AVICONF1.
#define BM_HDMI_FC_AVICONF1_FC_AVICONF1      (0x0000000f)  //!< Bit mask for HDMI_FC_AVICONF1_FC_AVICONF1.

//! @brief Get value of HDMI_FC_AVICONF1_FC_AVICONF1 from a register value.
#define BG_HDMI_FC_AVICONF1_FC_AVICONF1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF1_FC_AVICONF1) >> BP_HDMI_FC_AVICONF1_FC_AVICONF1)

//! @brief Format value for bitfield HDMI_FC_AVICONF1_FC_AVICONF1.
#define BF_HDMI_FC_AVICONF1_FC_AVICONF1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF1_FC_AVICONF1) & BM_HDMI_FC_AVICONF1_FC_AVICONF1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF1 field to a new value.
#define BW_HDMI_FC_AVICONF1_FC_AVICONF1(v)   (HW_HDMI_FC_AVICONF1_WR((HW_HDMI_FC_AVICONF1_RD() & ~BM_HDMI_FC_AVICONF1_FC_AVICONF1) | BF_HDMI_FC_AVICONF1_FC_AVICONF1(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF1, field FC_AVICONF11[5:4] (RW)
 *
 * Picture aspect ratio
 */
//@{
#define BP_HDMI_FC_AVICONF1_FC_AVICONF11      (4)      //!< Bit position for HDMI_FC_AVICONF1_FC_AVICONF11.
#define BM_HDMI_FC_AVICONF1_FC_AVICONF11      (0x00000030)  //!< Bit mask for HDMI_FC_AVICONF1_FC_AVICONF11.

//! @brief Get value of HDMI_FC_AVICONF1_FC_AVICONF11 from a register value.
#define BG_HDMI_FC_AVICONF1_FC_AVICONF11(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF1_FC_AVICONF11) >> BP_HDMI_FC_AVICONF1_FC_AVICONF11)

//! @brief Format value for bitfield HDMI_FC_AVICONF1_FC_AVICONF11.
#define BF_HDMI_FC_AVICONF1_FC_AVICONF11(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF1_FC_AVICONF11) & BM_HDMI_FC_AVICONF1_FC_AVICONF11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF11 field to a new value.
#define BW_HDMI_FC_AVICONF1_FC_AVICONF11(v)   (HW_HDMI_FC_AVICONF1_WR((HW_HDMI_FC_AVICONF1_RD() & ~BM_HDMI_FC_AVICONF1_FC_AVICONF11) | BF_HDMI_FC_AVICONF1_FC_AVICONF11(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF1, field FC_AVICONF0[7:6] (RW)
 *
 * Colorimetry
 */
//@{
#define BP_HDMI_FC_AVICONF1_FC_AVICONF0      (6)      //!< Bit position for HDMI_FC_AVICONF1_FC_AVICONF0.
#define BM_HDMI_FC_AVICONF1_FC_AVICONF0      (0x000000c0)  //!< Bit mask for HDMI_FC_AVICONF1_FC_AVICONF0.

//! @brief Get value of HDMI_FC_AVICONF1_FC_AVICONF0 from a register value.
#define BG_HDMI_FC_AVICONF1_FC_AVICONF0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF1_FC_AVICONF0) >> BP_HDMI_FC_AVICONF1_FC_AVICONF0)

//! @brief Format value for bitfield HDMI_FC_AVICONF1_FC_AVICONF0.
#define BF_HDMI_FC_AVICONF1_FC_AVICONF0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF1_FC_AVICONF0) & BM_HDMI_FC_AVICONF1_FC_AVICONF0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF0 field to a new value.
#define BW_HDMI_FC_AVICONF1_FC_AVICONF0(v)   (HW_HDMI_FC_AVICONF1_WR((HW_HDMI_FC_AVICONF1_RD() & ~BM_HDMI_FC_AVICONF1_FC_AVICONF0) | BF_HDMI_FC_AVICONF1_FC_AVICONF0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVICONF2 - FC_AVICONFFrame Composer AVI Packet Configuration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVICONF2 - FC_AVICONFFrame Composer AVI Packet Configuration Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_aviconf2
{
    reg8_t U;
    struct _hw_hdmi_fc_aviconf2_bitfields
    {
        unsigned char FC_AVICONF2 : 2; //!< [1:0] Non-uniform picture scaling
        unsigned char RESERVED0 : 2; //!< [3:2] Quantization range
        unsigned char FC_AVICONF21 : 3; //!< [6:4] Extended colorimetry
        unsigned char FC_AVICONF22 : 1; //!< [7] IT content
    } B;
} hw_hdmi_fc_aviconf2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVICONF2 register
 */
//@{
#define HW_HDMI_FC_AVICONF2_ADDR      (REGS_HDMI_BASE + 0x101b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVICONF2           (*(volatile hw_hdmi_fc_aviconf2_t *) HW_HDMI_FC_AVICONF2_ADDR)
#define HW_HDMI_FC_AVICONF2_RD()      (HW_HDMI_FC_AVICONF2.U)
#define HW_HDMI_FC_AVICONF2_WR(v)     (HW_HDMI_FC_AVICONF2.U = (v))
#define HW_HDMI_FC_AVICONF2_SET(v)    (HW_HDMI_FC_AVICONF2_WR(HW_HDMI_FC_AVICONF2_RD() |  (v)))
#define HW_HDMI_FC_AVICONF2_CLR(v)    (HW_HDMI_FC_AVICONF2_WR(HW_HDMI_FC_AVICONF2_RD() & ~(v)))
#define HW_HDMI_FC_AVICONF2_TOG(v)    (HW_HDMI_FC_AVICONF2_WR(HW_HDMI_FC_AVICONF2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVICONF2 bitfields
 */

/*! @name Register HDMI_FC_AVICONF2, field FC_AVICONF2[1:0] (RW)
 *
 * Non-uniform picture scaling Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_AVICONF2_FC_AVICONF2      (0)      //!< Bit position for HDMI_FC_AVICONF2_FC_AVICONF2.
#define BM_HDMI_FC_AVICONF2_FC_AVICONF2      (0x00000003)  //!< Bit mask for HDMI_FC_AVICONF2_FC_AVICONF2.

//! @brief Get value of HDMI_FC_AVICONF2_FC_AVICONF2 from a register value.
#define BG_HDMI_FC_AVICONF2_FC_AVICONF2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF2_FC_AVICONF2) >> BP_HDMI_FC_AVICONF2_FC_AVICONF2)

//! @brief Format value for bitfield HDMI_FC_AVICONF2_FC_AVICONF2.
#define BF_HDMI_FC_AVICONF2_FC_AVICONF2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF2_FC_AVICONF2) & BM_HDMI_FC_AVICONF2_FC_AVICONF2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF2 field to a new value.
#define BW_HDMI_FC_AVICONF2_FC_AVICONF2(v)   (HW_HDMI_FC_AVICONF2_WR((HW_HDMI_FC_AVICONF2_RD() & ~BM_HDMI_FC_AVICONF2_FC_AVICONF2) | BF_HDMI_FC_AVICONF2_FC_AVICONF2(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF2, field FC_AVICONF21[6:4] (RW)
 *
 * Extended colorimetry
 */
//@{
#define BP_HDMI_FC_AVICONF2_FC_AVICONF21      (4)      //!< Bit position for HDMI_FC_AVICONF2_FC_AVICONF21.
#define BM_HDMI_FC_AVICONF2_FC_AVICONF21      (0x00000070)  //!< Bit mask for HDMI_FC_AVICONF2_FC_AVICONF21.

//! @brief Get value of HDMI_FC_AVICONF2_FC_AVICONF21 from a register value.
#define BG_HDMI_FC_AVICONF2_FC_AVICONF21(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF2_FC_AVICONF21) >> BP_HDMI_FC_AVICONF2_FC_AVICONF21)

//! @brief Format value for bitfield HDMI_FC_AVICONF2_FC_AVICONF21.
#define BF_HDMI_FC_AVICONF2_FC_AVICONF21(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF2_FC_AVICONF21) & BM_HDMI_FC_AVICONF2_FC_AVICONF21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF21 field to a new value.
#define BW_HDMI_FC_AVICONF2_FC_AVICONF21(v)   (HW_HDMI_FC_AVICONF2_WR((HW_HDMI_FC_AVICONF2_RD() & ~BM_HDMI_FC_AVICONF2_FC_AVICONF21) | BF_HDMI_FC_AVICONF2_FC_AVICONF21(v)))
#endif
//@}

/*! @name Register HDMI_FC_AVICONF2, field FC_AVICONF22[7] (RW)
 *
 * IT content
 */
//@{
#define BP_HDMI_FC_AVICONF2_FC_AVICONF22      (7)      //!< Bit position for HDMI_FC_AVICONF2_FC_AVICONF22.
#define BM_HDMI_FC_AVICONF2_FC_AVICONF22      (0x00000080)  //!< Bit mask for HDMI_FC_AVICONF2_FC_AVICONF22.

//! @brief Get value of HDMI_FC_AVICONF2_FC_AVICONF22 from a register value.
#define BG_HDMI_FC_AVICONF2_FC_AVICONF22(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVICONF2_FC_AVICONF22) >> BP_HDMI_FC_AVICONF2_FC_AVICONF22)

//! @brief Format value for bitfield HDMI_FC_AVICONF2_FC_AVICONF22.
#define BF_HDMI_FC_AVICONF2_FC_AVICONF22(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVICONF2_FC_AVICONF22) & BM_HDMI_FC_AVICONF2_FC_AVICONF22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVICONF22 field to a new value.
#define BW_HDMI_FC_AVICONF2_FC_AVICONF22(v)   (HW_HDMI_FC_AVICONF2_WR((HW_HDMI_FC_AVICONF2_RD() & ~BM_HDMI_FC_AVICONF2_FC_AVICONF22) | BF_HDMI_FC_AVICONF2_FC_AVICONF22(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVIVID - Frame Composer AVI Packet VIC Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVIVID - Frame Composer AVI Packet VIC Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the AVI infoFrame Video Identification code. For more information, refer to the
 * CEA-861-E specification.
 */
typedef union _hw_hdmi_fc_avivid
{
    reg8_t U;
    struct _hw_hdmi_fc_avivid_bitfields
    {
        unsigned char FC_AVIVID : 8; //!< [7:0] the AVI infoFrame Video Identification code.
    } B;
} hw_hdmi_fc_avivid_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVIVID register
 */
//@{
#define HW_HDMI_FC_AVIVID_ADDR      (REGS_HDMI_BASE + 0x101c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVIVID           (*(volatile hw_hdmi_fc_avivid_t *) HW_HDMI_FC_AVIVID_ADDR)
#define HW_HDMI_FC_AVIVID_RD()      (HW_HDMI_FC_AVIVID.U)
#define HW_HDMI_FC_AVIVID_WR(v)     (HW_HDMI_FC_AVIVID.U = (v))
#define HW_HDMI_FC_AVIVID_SET(v)    (HW_HDMI_FC_AVIVID_WR(HW_HDMI_FC_AVIVID_RD() |  (v)))
#define HW_HDMI_FC_AVIVID_CLR(v)    (HW_HDMI_FC_AVIVID_WR(HW_HDMI_FC_AVIVID_RD() & ~(v)))
#define HW_HDMI_FC_AVIVID_TOG(v)    (HW_HDMI_FC_AVIVID_WR(HW_HDMI_FC_AVIVID_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVIVID bitfields
 */

/*! @name Register HDMI_FC_AVIVID, field FC_AVIVID[7:0] (RW)
 *
 * the AVI infoFrame Video Identification code.
 */
//@{
#define BP_HDMI_FC_AVIVID_FC_AVIVID      (0)      //!< Bit position for HDMI_FC_AVIVID_FC_AVIVID.
#define BM_HDMI_FC_AVIVID_FC_AVIVID      (0x000000ff)  //!< Bit mask for HDMI_FC_AVIVID_FC_AVIVID.

//! @brief Get value of HDMI_FC_AVIVID_FC_AVIVID from a register value.
#define BG_HDMI_FC_AVIVID_FC_AVIVID(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVIVID_FC_AVIVID) >> BP_HDMI_FC_AVIVID_FC_AVIVID)

//! @brief Format value for bitfield HDMI_FC_AVIVID_FC_AVIVID.
#define BF_HDMI_FC_AVIVID_FC_AVIVID(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVIVID_FC_AVIVID) & BM_HDMI_FC_AVIVID_FC_AVIVID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVIVID field to a new value.
#define BW_HDMI_FC_AVIVID_FC_AVIVID(v)   (HW_HDMI_FC_AVIVID_WR((HW_HDMI_FC_AVIVID_RD() & ~BM_HDMI_FC_AVIVID_FC_AVIVID) | BF_HDMI_FC_AVIVID_FC_AVIVID(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVIETB0 - Frame Composer AVI Packet End of Top Bar Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVIETB0 - Frame Composer AVI Packet End of Top Bar Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers define the AVI infoFrame End of Top Bar value. For more information, refer to
 * CEA-861-E specification.
 */
typedef union _hw_hdmi_fc_avietb0
{
    reg8_t U;
    struct _hw_hdmi_fc_avietb0_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] Line number of end of top bar (lower 8 bits)
    } B;
} hw_hdmi_fc_avietb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVIETB0 register
 */
//@{
#define HW_HDMI_FC_AVIETB0_ADDR      (REGS_HDMI_BASE + 0x101d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVIETB0           (*(volatile hw_hdmi_fc_avietb0_t *) HW_HDMI_FC_AVIETB0_ADDR)
#define HW_HDMI_FC_AVIETB0_RD()      (HW_HDMI_FC_AVIETB0.U)
#define HW_HDMI_FC_AVIETB0_WR(v)     (HW_HDMI_FC_AVIETB0.U = (v))
#define HW_HDMI_FC_AVIETB0_SET(v)    (HW_HDMI_FC_AVIETB0_WR(HW_HDMI_FC_AVIETB0_RD() |  (v)))
#define HW_HDMI_FC_AVIETB0_CLR(v)    (HW_HDMI_FC_AVIETB0_WR(HW_HDMI_FC_AVIETB0_RD() & ~(v)))
#define HW_HDMI_FC_AVIETB0_TOG(v)    (HW_HDMI_FC_AVIETB0_WR(HW_HDMI_FC_AVIETB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVIETB0 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVIETB1 - Frame Composer AVI Packet End of Top Bar Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVIETB1 - Frame Composer AVI Packet End of Top Bar Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_avietb1
{
    reg8_t U;
    struct _hw_hdmi_fc_avietb1_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] Line number of end of top bar (upper 8 bits)
    } B;
} hw_hdmi_fc_avietb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVIETB1 register
 */
//@{
#define HW_HDMI_FC_AVIETB1_ADDR      (REGS_HDMI_BASE + 0x101e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVIETB1           (*(volatile hw_hdmi_fc_avietb1_t *) HW_HDMI_FC_AVIETB1_ADDR)
#define HW_HDMI_FC_AVIETB1_RD()      (HW_HDMI_FC_AVIETB1.U)
#define HW_HDMI_FC_AVIETB1_WR(v)     (HW_HDMI_FC_AVIETB1.U = (v))
#define HW_HDMI_FC_AVIETB1_SET(v)    (HW_HDMI_FC_AVIETB1_WR(HW_HDMI_FC_AVIETB1_RD() |  (v)))
#define HW_HDMI_FC_AVIETB1_CLR(v)    (HW_HDMI_FC_AVIETB1_WR(HW_HDMI_FC_AVIETB1_RD() & ~(v)))
#define HW_HDMI_FC_AVIETB1_TOG(v)    (HW_HDMI_FC_AVIETB1_WR(HW_HDMI_FC_AVIETB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVIETB1 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVISBB0 - Frame Composer AVI Packet Start of Bottom Bar Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVISBB0 - Frame Composer AVI Packet Start of Bottom Bar Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers define the AVI infoFrame Start of Bottom Bar value. For more information, refer
 * to CEA-861D specification.
 */
typedef union _hw_hdmi_fc_avisbb0
{
    reg8_t U;
    struct _hw_hdmi_fc_avisbb0_bitfields
    {
        unsigned char FC_AVISBB0 : 8; //!< [7:0] Line number of Start of Bottom Bar (lower 8 bits)
    } B;
} hw_hdmi_fc_avisbb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVISBB0 register
 */
//@{
#define HW_HDMI_FC_AVISBB0_ADDR      (REGS_HDMI_BASE + 0x101f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVISBB0           (*(volatile hw_hdmi_fc_avisbb0_t *) HW_HDMI_FC_AVISBB0_ADDR)
#define HW_HDMI_FC_AVISBB0_RD()      (HW_HDMI_FC_AVISBB0.U)
#define HW_HDMI_FC_AVISBB0_WR(v)     (HW_HDMI_FC_AVISBB0.U = (v))
#define HW_HDMI_FC_AVISBB0_SET(v)    (HW_HDMI_FC_AVISBB0_WR(HW_HDMI_FC_AVISBB0_RD() |  (v)))
#define HW_HDMI_FC_AVISBB0_CLR(v)    (HW_HDMI_FC_AVISBB0_WR(HW_HDMI_FC_AVISBB0_RD() & ~(v)))
#define HW_HDMI_FC_AVISBB0_TOG(v)    (HW_HDMI_FC_AVISBB0_WR(HW_HDMI_FC_AVISBB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVISBB0 bitfields
 */

/*! @name Register HDMI_FC_AVISBB0, field FC_AVISBB0[7:0] (RW)
 *
 * Line number of Start of Bottom Bar (lower 8 bits)
 */
//@{
#define BP_HDMI_FC_AVISBB0_FC_AVISBB0      (0)      //!< Bit position for HDMI_FC_AVISBB0_FC_AVISBB0.
#define BM_HDMI_FC_AVISBB0_FC_AVISBB0      (0x000000ff)  //!< Bit mask for HDMI_FC_AVISBB0_FC_AVISBB0.

//! @brief Get value of HDMI_FC_AVISBB0_FC_AVISBB0 from a register value.
#define BG_HDMI_FC_AVISBB0_FC_AVISBB0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVISBB0_FC_AVISBB0) >> BP_HDMI_FC_AVISBB0_FC_AVISBB0)

//! @brief Format value for bitfield HDMI_FC_AVISBB0_FC_AVISBB0.
#define BF_HDMI_FC_AVISBB0_FC_AVISBB0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVISBB0_FC_AVISBB0) & BM_HDMI_FC_AVISBB0_FC_AVISBB0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVISBB0 field to a new value.
#define BW_HDMI_FC_AVISBB0_FC_AVISBB0(v)   (HW_HDMI_FC_AVISBB0_WR((HW_HDMI_FC_AVISBB0_RD() & ~BM_HDMI_FC_AVISBB0_FC_AVISBB0) | BF_HDMI_FC_AVISBB0_FC_AVISBB0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVISBB1 - Frame Composer AVI Packet Start of Bottom Bar Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVISBB1 - Frame Composer AVI Packet Start of Bottom Bar Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_avisbb1
{
    reg8_t U;
    struct _hw_hdmi_fc_avisbb1_bitfields
    {
        unsigned char FC_AVISBB1 : 8; //!< [7:0] Line number of Start of Bottom Bar (upper 8 bits)
    } B;
} hw_hdmi_fc_avisbb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVISBB1 register
 */
//@{
#define HW_HDMI_FC_AVISBB1_ADDR      (REGS_HDMI_BASE + 0x1020)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVISBB1           (*(volatile hw_hdmi_fc_avisbb1_t *) HW_HDMI_FC_AVISBB1_ADDR)
#define HW_HDMI_FC_AVISBB1_RD()      (HW_HDMI_FC_AVISBB1.U)
#define HW_HDMI_FC_AVISBB1_WR(v)     (HW_HDMI_FC_AVISBB1.U = (v))
#define HW_HDMI_FC_AVISBB1_SET(v)    (HW_HDMI_FC_AVISBB1_WR(HW_HDMI_FC_AVISBB1_RD() |  (v)))
#define HW_HDMI_FC_AVISBB1_CLR(v)    (HW_HDMI_FC_AVISBB1_WR(HW_HDMI_FC_AVISBB1_RD() & ~(v)))
#define HW_HDMI_FC_AVISBB1_TOG(v)    (HW_HDMI_FC_AVISBB1_WR(HW_HDMI_FC_AVISBB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVISBB1 bitfields
 */

/*! @name Register HDMI_FC_AVISBB1, field FC_AVISBB1[7:0] (RW)
 *
 * Line number of Start of Bottom Bar (upper 8 bits)
 */
//@{
#define BP_HDMI_FC_AVISBB1_FC_AVISBB1      (0)      //!< Bit position for HDMI_FC_AVISBB1_FC_AVISBB1.
#define BM_HDMI_FC_AVISBB1_FC_AVISBB1      (0x000000ff)  //!< Bit mask for HDMI_FC_AVISBB1_FC_AVISBB1.

//! @brief Get value of HDMI_FC_AVISBB1_FC_AVISBB1 from a register value.
#define BG_HDMI_FC_AVISBB1_FC_AVISBB1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVISBB1_FC_AVISBB1) >> BP_HDMI_FC_AVISBB1_FC_AVISBB1)

//! @brief Format value for bitfield HDMI_FC_AVISBB1_FC_AVISBB1.
#define BF_HDMI_FC_AVISBB1_FC_AVISBB1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVISBB1_FC_AVISBB1) & BM_HDMI_FC_AVISBB1_FC_AVISBB1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVISBB1 field to a new value.
#define BW_HDMI_FC_AVISBB1_FC_AVISBB1(v)   (HW_HDMI_FC_AVISBB1_WR((HW_HDMI_FC_AVISBB1_RD() & ~BM_HDMI_FC_AVISBB1_FC_AVISBB1) | BF_HDMI_FC_AVISBB1_FC_AVISBB1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVIELB0 - Frame Composer AVI Packet End of Left Bar Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVIELB0 - Frame Composer AVI Packet End of Left Bar Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers define the AVI infoFrame End of Left Bar value. For more information, refer to
 * CEA-861D specification.
 */
typedef union _hw_hdmi_fc_avielb0
{
    reg8_t U;
    struct _hw_hdmi_fc_avielb0_bitfields
    {
        unsigned char FC_AVIELB0 : 8; //!< [7:0] Pixel number of end of left Bar (lower 8 bits)
    } B;
} hw_hdmi_fc_avielb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVIELB0 register
 */
//@{
#define HW_HDMI_FC_AVIELB0_ADDR      (REGS_HDMI_BASE + 0x1021)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVIELB0           (*(volatile hw_hdmi_fc_avielb0_t *) HW_HDMI_FC_AVIELB0_ADDR)
#define HW_HDMI_FC_AVIELB0_RD()      (HW_HDMI_FC_AVIELB0.U)
#define HW_HDMI_FC_AVIELB0_WR(v)     (HW_HDMI_FC_AVIELB0.U = (v))
#define HW_HDMI_FC_AVIELB0_SET(v)    (HW_HDMI_FC_AVIELB0_WR(HW_HDMI_FC_AVIELB0_RD() |  (v)))
#define HW_HDMI_FC_AVIELB0_CLR(v)    (HW_HDMI_FC_AVIELB0_WR(HW_HDMI_FC_AVIELB0_RD() & ~(v)))
#define HW_HDMI_FC_AVIELB0_TOG(v)    (HW_HDMI_FC_AVIELB0_WR(HW_HDMI_FC_AVIELB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVIELB0 bitfields
 */

/*! @name Register HDMI_FC_AVIELB0, field FC_AVIELB0[7:0] (RW)
 *
 * Pixel number of end of left Bar (lower 8 bits)
 */
//@{
#define BP_HDMI_FC_AVIELB0_FC_AVIELB0      (0)      //!< Bit position for HDMI_FC_AVIELB0_FC_AVIELB0.
#define BM_HDMI_FC_AVIELB0_FC_AVIELB0      (0x000000ff)  //!< Bit mask for HDMI_FC_AVIELB0_FC_AVIELB0.

//! @brief Get value of HDMI_FC_AVIELB0_FC_AVIELB0 from a register value.
#define BG_HDMI_FC_AVIELB0_FC_AVIELB0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVIELB0_FC_AVIELB0) >> BP_HDMI_FC_AVIELB0_FC_AVIELB0)

//! @brief Format value for bitfield HDMI_FC_AVIELB0_FC_AVIELB0.
#define BF_HDMI_FC_AVIELB0_FC_AVIELB0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVIELB0_FC_AVIELB0) & BM_HDMI_FC_AVIELB0_FC_AVIELB0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVIELB0 field to a new value.
#define BW_HDMI_FC_AVIELB0_FC_AVIELB0(v)   (HW_HDMI_FC_AVIELB0_WR((HW_HDMI_FC_AVIELB0_RD() & ~BM_HDMI_FC_AVIELB0_FC_AVIELB0) | BF_HDMI_FC_AVIELB0_FC_AVIELB0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVIELB1 - Frame Composer AVI Packet End of Left Bar Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVIELB1 - Frame Composer AVI Packet End of Left Bar Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_avielb1
{
    reg8_t U;
    struct _hw_hdmi_fc_avielb1_bitfields
    {
        unsigned char FC_AVIELB1 : 8; //!< [7:0] Pixel number of end of left Bar (lower 8 bits)
    } B;
} hw_hdmi_fc_avielb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVIELB1 register
 */
//@{
#define HW_HDMI_FC_AVIELB1_ADDR      (REGS_HDMI_BASE + 0x1022)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVIELB1           (*(volatile hw_hdmi_fc_avielb1_t *) HW_HDMI_FC_AVIELB1_ADDR)
#define HW_HDMI_FC_AVIELB1_RD()      (HW_HDMI_FC_AVIELB1.U)
#define HW_HDMI_FC_AVIELB1_WR(v)     (HW_HDMI_FC_AVIELB1.U = (v))
#define HW_HDMI_FC_AVIELB1_SET(v)    (HW_HDMI_FC_AVIELB1_WR(HW_HDMI_FC_AVIELB1_RD() |  (v)))
#define HW_HDMI_FC_AVIELB1_CLR(v)    (HW_HDMI_FC_AVIELB1_WR(HW_HDMI_FC_AVIELB1_RD() & ~(v)))
#define HW_HDMI_FC_AVIELB1_TOG(v)    (HW_HDMI_FC_AVIELB1_WR(HW_HDMI_FC_AVIELB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVIELB1 bitfields
 */

/*! @name Register HDMI_FC_AVIELB1, field FC_AVIELB1[7:0] (RW)
 *
 * Pixel number of end of left Bar (lower 8 bits)
 */
//@{
#define BP_HDMI_FC_AVIELB1_FC_AVIELB1      (0)      //!< Bit position for HDMI_FC_AVIELB1_FC_AVIELB1.
#define BM_HDMI_FC_AVIELB1_FC_AVIELB1      (0x000000ff)  //!< Bit mask for HDMI_FC_AVIELB1_FC_AVIELB1.

//! @brief Get value of HDMI_FC_AVIELB1_FC_AVIELB1 from a register value.
#define BG_HDMI_FC_AVIELB1_FC_AVIELB1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVIELB1_FC_AVIELB1) >> BP_HDMI_FC_AVIELB1_FC_AVIELB1)

//! @brief Format value for bitfield HDMI_FC_AVIELB1_FC_AVIELB1.
#define BF_HDMI_FC_AVIELB1_FC_AVIELB1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVIELB1_FC_AVIELB1) & BM_HDMI_FC_AVIELB1_FC_AVIELB1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVIELB1 field to a new value.
#define BW_HDMI_FC_AVIELB1_FC_AVIELB1(v)   (HW_HDMI_FC_AVIELB1_WR((HW_HDMI_FC_AVIELB1_RD() & ~BM_HDMI_FC_AVIELB1_FC_AVIELB1) | BF_HDMI_FC_AVIELB1_FC_AVIELB1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVISRB0 - Frame Composer AVI Packet Start of Right Bar Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVISRB0 - Frame Composer AVI Packet Start of Right Bar Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers define the AVI infoFrame Start of Right Bar value. For more information, refer to
 * CEA-861D specification.
 */
typedef union _hw_hdmi_fc_avisrb0
{
    reg8_t U;
    struct _hw_hdmi_fc_avisrb0_bitfields
    {
        unsigned char FC_AVISRB0 : 8; //!< [7:0] Pixel number of start of right Bar (lower 8 bits)
    } B;
} hw_hdmi_fc_avisrb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVISRB0 register
 */
//@{
#define HW_HDMI_FC_AVISRB0_ADDR      (REGS_HDMI_BASE + 0x1023)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVISRB0           (*(volatile hw_hdmi_fc_avisrb0_t *) HW_HDMI_FC_AVISRB0_ADDR)
#define HW_HDMI_FC_AVISRB0_RD()      (HW_HDMI_FC_AVISRB0.U)
#define HW_HDMI_FC_AVISRB0_WR(v)     (HW_HDMI_FC_AVISRB0.U = (v))
#define HW_HDMI_FC_AVISRB0_SET(v)    (HW_HDMI_FC_AVISRB0_WR(HW_HDMI_FC_AVISRB0_RD() |  (v)))
#define HW_HDMI_FC_AVISRB0_CLR(v)    (HW_HDMI_FC_AVISRB0_WR(HW_HDMI_FC_AVISRB0_RD() & ~(v)))
#define HW_HDMI_FC_AVISRB0_TOG(v)    (HW_HDMI_FC_AVISRB0_WR(HW_HDMI_FC_AVISRB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVISRB0 bitfields
 */

/*! @name Register HDMI_FC_AVISRB0, field FC_AVISRB0[7:0] (RW)
 *
 * Pixel number of start of right Bar (lower 8 bits)
 */
//@{
#define BP_HDMI_FC_AVISRB0_FC_AVISRB0      (0)      //!< Bit position for HDMI_FC_AVISRB0_FC_AVISRB0.
#define BM_HDMI_FC_AVISRB0_FC_AVISRB0      (0x000000ff)  //!< Bit mask for HDMI_FC_AVISRB0_FC_AVISRB0.

//! @brief Get value of HDMI_FC_AVISRB0_FC_AVISRB0 from a register value.
#define BG_HDMI_FC_AVISRB0_FC_AVISRB0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVISRB0_FC_AVISRB0) >> BP_HDMI_FC_AVISRB0_FC_AVISRB0)

//! @brief Format value for bitfield HDMI_FC_AVISRB0_FC_AVISRB0.
#define BF_HDMI_FC_AVISRB0_FC_AVISRB0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVISRB0_FC_AVISRB0) & BM_HDMI_FC_AVISRB0_FC_AVISRB0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVISRB0 field to a new value.
#define BW_HDMI_FC_AVISRB0_FC_AVISRB0(v)   (HW_HDMI_FC_AVISRB0_WR((HW_HDMI_FC_AVISRB0_RD() & ~BM_HDMI_FC_AVISRB0_FC_AVISRB0) | BF_HDMI_FC_AVISRB0_FC_AVISRB0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AVISRB1 - Frame Composer AVI Packet Start of Right Bar Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AVISRB1 - Frame Composer AVI Packet Start of Right Bar Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_avisrb1
{
    reg8_t U;
    struct _hw_hdmi_fc_avisrb1_bitfields
    {
        unsigned char FC_AVISRB1 : 8; //!< [7:0] Pixel number of start of right Bar (upper 8 bits)
    } B;
} hw_hdmi_fc_avisrb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AVISRB1 register
 */
//@{
#define HW_HDMI_FC_AVISRB1_ADDR      (REGS_HDMI_BASE + 0x1024)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AVISRB1           (*(volatile hw_hdmi_fc_avisrb1_t *) HW_HDMI_FC_AVISRB1_ADDR)
#define HW_HDMI_FC_AVISRB1_RD()      (HW_HDMI_FC_AVISRB1.U)
#define HW_HDMI_FC_AVISRB1_WR(v)     (HW_HDMI_FC_AVISRB1.U = (v))
#define HW_HDMI_FC_AVISRB1_SET(v)    (HW_HDMI_FC_AVISRB1_WR(HW_HDMI_FC_AVISRB1_RD() |  (v)))
#define HW_HDMI_FC_AVISRB1_CLR(v)    (HW_HDMI_FC_AVISRB1_WR(HW_HDMI_FC_AVISRB1_RD() & ~(v)))
#define HW_HDMI_FC_AVISRB1_TOG(v)    (HW_HDMI_FC_AVISRB1_WR(HW_HDMI_FC_AVISRB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AVISRB1 bitfields
 */

/*! @name Register HDMI_FC_AVISRB1, field FC_AVISRB1[7:0] (RW)
 *
 * Pixel number of start of right Bar (upper 8 bits)
 */
//@{
#define BP_HDMI_FC_AVISRB1_FC_AVISRB1      (0)      //!< Bit position for HDMI_FC_AVISRB1_FC_AVISRB1.
#define BM_HDMI_FC_AVISRB1_FC_AVISRB1      (0x000000ff)  //!< Bit mask for HDMI_FC_AVISRB1_FC_AVISRB1.

//! @brief Get value of HDMI_FC_AVISRB1_FC_AVISRB1 from a register value.
#define BG_HDMI_FC_AVISRB1_FC_AVISRB1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AVISRB1_FC_AVISRB1) >> BP_HDMI_FC_AVISRB1_FC_AVISRB1)

//! @brief Format value for bitfield HDMI_FC_AVISRB1_FC_AVISRB1.
#define BF_HDMI_FC_AVISRB1_FC_AVISRB1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AVISRB1_FC_AVISRB1) & BM_HDMI_FC_AVISRB1_FC_AVISRB1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_AVISRB1 field to a new value.
#define BW_HDMI_FC_AVISRB1_FC_AVISRB1(v)   (HW_HDMI_FC_AVISRB1_WR((HW_HDMI_FC_AVISRB1_RD() & ~BM_HDMI_FC_AVISRB1_FC_AVISRB1) | BF_HDMI_FC_AVISRB1_FC_AVISRB1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDICONF0 - Frame Composer AUD Packet Configuration Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDICONF0 - Frame Composer AUD Packet Configuration Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers configure the following contents of the AUDIO infoFrame: Coding type Channel
 * count Sampling frequency Sampling size Channel allocation Audio level shift value Down mix enable
 * For more information, refer to CEA-861D specification. Address Offset: 0x1025 to 0x1028 Size: 8
 * bits Value after Reset: 0x00 Access: Read/Write For the FC_AUDICONF0 register, bits [6:5]
 * correspond to LFEPBL1, LFEPBL0 LFE playback level as compared to the other channels (from HDMI
 * 1.4a specification).
 */
typedef union _hw_hdmi_fc_audiconf0
{
    reg8_t U;
    struct _hw_hdmi_fc_audiconf0_bitfields
    {
        unsigned char CT : 4; //!< [3:0] Coding Type
        unsigned char CC : 3; //!< [6:4] Channel count
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_fc_audiconf0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDICONF0 register
 */
//@{
#define HW_HDMI_FC_AUDICONF0_ADDR      (REGS_HDMI_BASE + 0x1025)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDICONF0           (*(volatile hw_hdmi_fc_audiconf0_t *) HW_HDMI_FC_AUDICONF0_ADDR)
#define HW_HDMI_FC_AUDICONF0_RD()      (HW_HDMI_FC_AUDICONF0.U)
#define HW_HDMI_FC_AUDICONF0_WR(v)     (HW_HDMI_FC_AUDICONF0.U = (v))
#define HW_HDMI_FC_AUDICONF0_SET(v)    (HW_HDMI_FC_AUDICONF0_WR(HW_HDMI_FC_AUDICONF0_RD() |  (v)))
#define HW_HDMI_FC_AUDICONF0_CLR(v)    (HW_HDMI_FC_AUDICONF0_WR(HW_HDMI_FC_AUDICONF0_RD() & ~(v)))
#define HW_HDMI_FC_AUDICONF0_TOG(v)    (HW_HDMI_FC_AUDICONF0_WR(HW_HDMI_FC_AUDICONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDICONF0 bitfields
 */

/*! @name Register HDMI_FC_AUDICONF0, field CT[3:0] (RW)
 *
 * Coding Type
 */
//@{
#define BP_HDMI_FC_AUDICONF0_CT      (0)      //!< Bit position for HDMI_FC_AUDICONF0_CT.
#define BM_HDMI_FC_AUDICONF0_CT      (0x0000000f)  //!< Bit mask for HDMI_FC_AUDICONF0_CT.

//! @brief Get value of HDMI_FC_AUDICONF0_CT from a register value.
#define BG_HDMI_FC_AUDICONF0_CT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF0_CT) >> BP_HDMI_FC_AUDICONF0_CT)

//! @brief Format value for bitfield HDMI_FC_AUDICONF0_CT.
#define BF_HDMI_FC_AUDICONF0_CT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF0_CT) & BM_HDMI_FC_AUDICONF0_CT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CT field to a new value.
#define BW_HDMI_FC_AUDICONF0_CT(v)   (HW_HDMI_FC_AUDICONF0_WR((HW_HDMI_FC_AUDICONF0_RD() & ~BM_HDMI_FC_AUDICONF0_CT) | BF_HDMI_FC_AUDICONF0_CT(v)))
#endif
//@}

/*! @name Register HDMI_FC_AUDICONF0, field CC[6:4] (RW)
 *
 * Channel count
 */
//@{
#define BP_HDMI_FC_AUDICONF0_CC      (4)      //!< Bit position for HDMI_FC_AUDICONF0_CC.
#define BM_HDMI_FC_AUDICONF0_CC      (0x00000070)  //!< Bit mask for HDMI_FC_AUDICONF0_CC.

//! @brief Get value of HDMI_FC_AUDICONF0_CC from a register value.
#define BG_HDMI_FC_AUDICONF0_CC(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF0_CC) >> BP_HDMI_FC_AUDICONF0_CC)

//! @brief Format value for bitfield HDMI_FC_AUDICONF0_CC.
#define BF_HDMI_FC_AUDICONF0_CC(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF0_CC) & BM_HDMI_FC_AUDICONF0_CC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CC field to a new value.
#define BW_HDMI_FC_AUDICONF0_CC(v)   (HW_HDMI_FC_AUDICONF0_WR((HW_HDMI_FC_AUDICONF0_RD() & ~BM_HDMI_FC_AUDICONF0_CC) | BF_HDMI_FC_AUDICONF0_CC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDICONF1 - Frame Composer AUD Packet Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDICONF1 - Frame Composer AUD Packet Configuration Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_audiconf1
{
    reg8_t U;
    struct _hw_hdmi_fc_audiconf1_bitfields
    {
        unsigned char SF : 3; //!< [2:0] Sampling frequency
        unsigned char RESERVED0 : 1; //!< [3] Reserved
        unsigned char SS : 2; //!< [5:4] Sampling size
        unsigned char RESERVED1 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_fc_audiconf1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDICONF1 register
 */
//@{
#define HW_HDMI_FC_AUDICONF1_ADDR      (REGS_HDMI_BASE + 0x1026)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDICONF1           (*(volatile hw_hdmi_fc_audiconf1_t *) HW_HDMI_FC_AUDICONF1_ADDR)
#define HW_HDMI_FC_AUDICONF1_RD()      (HW_HDMI_FC_AUDICONF1.U)
#define HW_HDMI_FC_AUDICONF1_WR(v)     (HW_HDMI_FC_AUDICONF1.U = (v))
#define HW_HDMI_FC_AUDICONF1_SET(v)    (HW_HDMI_FC_AUDICONF1_WR(HW_HDMI_FC_AUDICONF1_RD() |  (v)))
#define HW_HDMI_FC_AUDICONF1_CLR(v)    (HW_HDMI_FC_AUDICONF1_WR(HW_HDMI_FC_AUDICONF1_RD() & ~(v)))
#define HW_HDMI_FC_AUDICONF1_TOG(v)    (HW_HDMI_FC_AUDICONF1_WR(HW_HDMI_FC_AUDICONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDICONF1 bitfields
 */

/*! @name Register HDMI_FC_AUDICONF1, field SF[2:0] (RW)
 *
 * Sampling frequency
 */
//@{
#define BP_HDMI_FC_AUDICONF1_SF      (0)      //!< Bit position for HDMI_FC_AUDICONF1_SF.
#define BM_HDMI_FC_AUDICONF1_SF      (0x00000007)  //!< Bit mask for HDMI_FC_AUDICONF1_SF.

//! @brief Get value of HDMI_FC_AUDICONF1_SF from a register value.
#define BG_HDMI_FC_AUDICONF1_SF(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF1_SF) >> BP_HDMI_FC_AUDICONF1_SF)

//! @brief Format value for bitfield HDMI_FC_AUDICONF1_SF.
#define BF_HDMI_FC_AUDICONF1_SF(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF1_SF) & BM_HDMI_FC_AUDICONF1_SF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SF field to a new value.
#define BW_HDMI_FC_AUDICONF1_SF(v)   (HW_HDMI_FC_AUDICONF1_WR((HW_HDMI_FC_AUDICONF1_RD() & ~BM_HDMI_FC_AUDICONF1_SF) | BF_HDMI_FC_AUDICONF1_SF(v)))
#endif
//@}

/*! @name Register HDMI_FC_AUDICONF1, field SS[5:4] (RW)
 *
 * Sampling size
 */
//@{
#define BP_HDMI_FC_AUDICONF1_SS      (4)      //!< Bit position for HDMI_FC_AUDICONF1_SS.
#define BM_HDMI_FC_AUDICONF1_SS      (0x00000030)  //!< Bit mask for HDMI_FC_AUDICONF1_SS.

//! @brief Get value of HDMI_FC_AUDICONF1_SS from a register value.
#define BG_HDMI_FC_AUDICONF1_SS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF1_SS) >> BP_HDMI_FC_AUDICONF1_SS)

//! @brief Format value for bitfield HDMI_FC_AUDICONF1_SS.
#define BF_HDMI_FC_AUDICONF1_SS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF1_SS) & BM_HDMI_FC_AUDICONF1_SS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SS field to a new value.
#define BW_HDMI_FC_AUDICONF1_SS(v)   (HW_HDMI_FC_AUDICONF1_WR((HW_HDMI_FC_AUDICONF1_RD() & ~BM_HDMI_FC_AUDICONF1_SS) | BF_HDMI_FC_AUDICONF1_SS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDICONF2 - Frame Composer AUD Packet Configuration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDICONF2 - Frame Composer AUD Packet Configuration Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_audiconf2
{
    reg8_t U;
    struct _hw_hdmi_fc_audiconf2_bitfields
    {
        unsigned char CA : 8; //!< [7:0] Channel allocation
    } B;
} hw_hdmi_fc_audiconf2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDICONF2 register
 */
//@{
#define HW_HDMI_FC_AUDICONF2_ADDR      (REGS_HDMI_BASE + 0x1027)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDICONF2           (*(volatile hw_hdmi_fc_audiconf2_t *) HW_HDMI_FC_AUDICONF2_ADDR)
#define HW_HDMI_FC_AUDICONF2_RD()      (HW_HDMI_FC_AUDICONF2.U)
#define HW_HDMI_FC_AUDICONF2_WR(v)     (HW_HDMI_FC_AUDICONF2.U = (v))
#define HW_HDMI_FC_AUDICONF2_SET(v)    (HW_HDMI_FC_AUDICONF2_WR(HW_HDMI_FC_AUDICONF2_RD() |  (v)))
#define HW_HDMI_FC_AUDICONF2_CLR(v)    (HW_HDMI_FC_AUDICONF2_WR(HW_HDMI_FC_AUDICONF2_RD() & ~(v)))
#define HW_HDMI_FC_AUDICONF2_TOG(v)    (HW_HDMI_FC_AUDICONF2_WR(HW_HDMI_FC_AUDICONF2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDICONF2 bitfields
 */

/*! @name Register HDMI_FC_AUDICONF2, field CA[7:0] (RW)
 *
 * Channel allocation
 */
//@{
#define BP_HDMI_FC_AUDICONF2_CA      (0)      //!< Bit position for HDMI_FC_AUDICONF2_CA.
#define BM_HDMI_FC_AUDICONF2_CA      (0x000000ff)  //!< Bit mask for HDMI_FC_AUDICONF2_CA.

//! @brief Get value of HDMI_FC_AUDICONF2_CA from a register value.
#define BG_HDMI_FC_AUDICONF2_CA(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF2_CA) >> BP_HDMI_FC_AUDICONF2_CA)

//! @brief Format value for bitfield HDMI_FC_AUDICONF2_CA.
#define BF_HDMI_FC_AUDICONF2_CA(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF2_CA) & BM_HDMI_FC_AUDICONF2_CA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CA field to a new value.
#define BW_HDMI_FC_AUDICONF2_CA(v)   (HW_HDMI_FC_AUDICONF2_WR((HW_HDMI_FC_AUDICONF2_RD() & ~BM_HDMI_FC_AUDICONF2_CA) | BF_HDMI_FC_AUDICONF2_CA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDICONF3 - Frame Composer AUD Packet Configuration Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDICONF3 - Frame Composer AUD Packet Configuration Register 3 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_audiconf3
{
    reg8_t U;
    struct _hw_hdmi_fc_audiconf3_bitfields
    {
        unsigned char LSV : 4; //!< [3:0] Level shift value (for down mixing)
        unsigned char DM_INH : 1; //!< [4] Down mix enable
        unsigned char LFEPBL : 2; //!< [6:5] LFE playback information
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_fc_audiconf3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDICONF3 register
 */
//@{
#define HW_HDMI_FC_AUDICONF3_ADDR      (REGS_HDMI_BASE + 0x1028)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDICONF3           (*(volatile hw_hdmi_fc_audiconf3_t *) HW_HDMI_FC_AUDICONF3_ADDR)
#define HW_HDMI_FC_AUDICONF3_RD()      (HW_HDMI_FC_AUDICONF3.U)
#define HW_HDMI_FC_AUDICONF3_WR(v)     (HW_HDMI_FC_AUDICONF3.U = (v))
#define HW_HDMI_FC_AUDICONF3_SET(v)    (HW_HDMI_FC_AUDICONF3_WR(HW_HDMI_FC_AUDICONF3_RD() |  (v)))
#define HW_HDMI_FC_AUDICONF3_CLR(v)    (HW_HDMI_FC_AUDICONF3_WR(HW_HDMI_FC_AUDICONF3_RD() & ~(v)))
#define HW_HDMI_FC_AUDICONF3_TOG(v)    (HW_HDMI_FC_AUDICONF3_WR(HW_HDMI_FC_AUDICONF3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDICONF3 bitfields
 */

/*! @name Register HDMI_FC_AUDICONF3, field LSV[3:0] (RW)
 *
 * Level shift value (for down mixing)
 */
//@{
#define BP_HDMI_FC_AUDICONF3_LSV      (0)      //!< Bit position for HDMI_FC_AUDICONF3_LSV.
#define BM_HDMI_FC_AUDICONF3_LSV      (0x0000000f)  //!< Bit mask for HDMI_FC_AUDICONF3_LSV.

//! @brief Get value of HDMI_FC_AUDICONF3_LSV from a register value.
#define BG_HDMI_FC_AUDICONF3_LSV(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF3_LSV) >> BP_HDMI_FC_AUDICONF3_LSV)

//! @brief Format value for bitfield HDMI_FC_AUDICONF3_LSV.
#define BF_HDMI_FC_AUDICONF3_LSV(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF3_LSV) & BM_HDMI_FC_AUDICONF3_LSV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LSV field to a new value.
#define BW_HDMI_FC_AUDICONF3_LSV(v)   (HW_HDMI_FC_AUDICONF3_WR((HW_HDMI_FC_AUDICONF3_RD() & ~BM_HDMI_FC_AUDICONF3_LSV) | BF_HDMI_FC_AUDICONF3_LSV(v)))
#endif
//@}

/*! @name Register HDMI_FC_AUDICONF3, field DM_INH[4] (RW)
 *
 * Down mix enable
 */
//@{
#define BP_HDMI_FC_AUDICONF3_DM_INH      (4)      //!< Bit position for HDMI_FC_AUDICONF3_DM_INH.
#define BM_HDMI_FC_AUDICONF3_DM_INH      (0x00000010)  //!< Bit mask for HDMI_FC_AUDICONF3_DM_INH.

//! @brief Get value of HDMI_FC_AUDICONF3_DM_INH from a register value.
#define BG_HDMI_FC_AUDICONF3_DM_INH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF3_DM_INH) >> BP_HDMI_FC_AUDICONF3_DM_INH)

//! @brief Format value for bitfield HDMI_FC_AUDICONF3_DM_INH.
#define BF_HDMI_FC_AUDICONF3_DM_INH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF3_DM_INH) & BM_HDMI_FC_AUDICONF3_DM_INH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DM_INH field to a new value.
#define BW_HDMI_FC_AUDICONF3_DM_INH(v)   (HW_HDMI_FC_AUDICONF3_WR((HW_HDMI_FC_AUDICONF3_RD() & ~BM_HDMI_FC_AUDICONF3_DM_INH) | BF_HDMI_FC_AUDICONF3_DM_INH(v)))
#endif
//@}

/*! @name Register HDMI_FC_AUDICONF3, field LFEPBL[6:5] (RW)
 *
 * LFE playback information
 */
//@{
#define BP_HDMI_FC_AUDICONF3_LFEPBL      (5)      //!< Bit position for HDMI_FC_AUDICONF3_LFEPBL.
#define BM_HDMI_FC_AUDICONF3_LFEPBL      (0x00000060)  //!< Bit mask for HDMI_FC_AUDICONF3_LFEPBL.

//! @brief Get value of HDMI_FC_AUDICONF3_LFEPBL from a register value.
#define BG_HDMI_FC_AUDICONF3_LFEPBL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDICONF3_LFEPBL) >> BP_HDMI_FC_AUDICONF3_LFEPBL)

//! @brief Format value for bitfield HDMI_FC_AUDICONF3_LFEPBL.
#define BF_HDMI_FC_AUDICONF3_LFEPBL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDICONF3_LFEPBL) & BM_HDMI_FC_AUDICONF3_LFEPBL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LFEPBL field to a new value.
#define BW_HDMI_FC_AUDICONF3_LFEPBL(v)   (HW_HDMI_FC_AUDICONF3_WR((HW_HDMI_FC_AUDICONF3_RD() & ~BM_HDMI_FC_AUDICONF3_LFEPBL) | BF_HDMI_FC_AUDICONF3_LFEPBL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDIEEEID0 - Frame Composer VSI Packet Data IEEE Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDIEEEID0 - Frame Composer VSI Packet Data IEEE Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers configure the Vendor Specific infoFrame IEEE registration identifier. For more
 * information, refer to CEA-861D specification.
 */
typedef union _hw_hdmi_fc_vsdieeeid0
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdieeeid0_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame IEEE registration identifier byte 0
    } B;
} hw_hdmi_fc_vsdieeeid0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDIEEEID0 register
 */
//@{
#define HW_HDMI_FC_VSDIEEEID0_ADDR      (REGS_HDMI_BASE + 0x1029)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDIEEEID0           (*(volatile hw_hdmi_fc_vsdieeeid0_t *) HW_HDMI_FC_VSDIEEEID0_ADDR)
#define HW_HDMI_FC_VSDIEEEID0_RD()      (HW_HDMI_FC_VSDIEEEID0.U)
#define HW_HDMI_FC_VSDIEEEID0_WR(v)     (HW_HDMI_FC_VSDIEEEID0.U = (v))
#define HW_HDMI_FC_VSDIEEEID0_SET(v)    (HW_HDMI_FC_VSDIEEEID0_WR(HW_HDMI_FC_VSDIEEEID0_RD() |  (v)))
#define HW_HDMI_FC_VSDIEEEID0_CLR(v)    (HW_HDMI_FC_VSDIEEEID0_WR(HW_HDMI_FC_VSDIEEEID0_RD() & ~(v)))
#define HW_HDMI_FC_VSDIEEEID0_TOG(v)    (HW_HDMI_FC_VSDIEEEID0_WR(HW_HDMI_FC_VSDIEEEID0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDIEEEID0 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDSIZE - Frame Composer VSI Packet Data Size Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDSIZE - Frame Composer VSI Packet Data Size Register (RW)
 *
 * Reset value: 0x1b
 *
 * configuration of Packet size.
 */
typedef union _hw_hdmi_fc_vsdsize
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdsize_bitfields
    {
        unsigned char VSDSIZE : 5; //!< [4:0] Packet size as described in HDMI Vendor Specific InfoFrame (from HDMI specification).
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_vsdsize_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDSIZE register
 */
//@{
#define HW_HDMI_FC_VSDSIZE_ADDR      (REGS_HDMI_BASE + 0x102a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDSIZE           (*(volatile hw_hdmi_fc_vsdsize_t *) HW_HDMI_FC_VSDSIZE_ADDR)
#define HW_HDMI_FC_VSDSIZE_RD()      (HW_HDMI_FC_VSDSIZE.U)
#define HW_HDMI_FC_VSDSIZE_WR(v)     (HW_HDMI_FC_VSDSIZE.U = (v))
#define HW_HDMI_FC_VSDSIZE_SET(v)    (HW_HDMI_FC_VSDSIZE_WR(HW_HDMI_FC_VSDSIZE_RD() |  (v)))
#define HW_HDMI_FC_VSDSIZE_CLR(v)    (HW_HDMI_FC_VSDSIZE_WR(HW_HDMI_FC_VSDSIZE_RD() & ~(v)))
#define HW_HDMI_FC_VSDSIZE_TOG(v)    (HW_HDMI_FC_VSDSIZE_WR(HW_HDMI_FC_VSDSIZE_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDSIZE bitfields
 */

/*! @name Register HDMI_FC_VSDSIZE, field VSDSIZE[4:0] (RW)
 *
 * Packet size as described in HDMI Vendor Specific InfoFrame (from HDMI specification).
 */
//@{
#define BP_HDMI_FC_VSDSIZE_VSDSIZE      (0)      //!< Bit position for HDMI_FC_VSDSIZE_VSDSIZE.
#define BM_HDMI_FC_VSDSIZE_VSDSIZE      (0x0000001f)  //!< Bit mask for HDMI_FC_VSDSIZE_VSDSIZE.

//! @brief Get value of HDMI_FC_VSDSIZE_VSDSIZE from a register value.
#define BG_HDMI_FC_VSDSIZE_VSDSIZE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_VSDSIZE_VSDSIZE) >> BP_HDMI_FC_VSDSIZE_VSDSIZE)

//! @brief Format value for bitfield HDMI_FC_VSDSIZE_VSDSIZE.
#define BF_HDMI_FC_VSDSIZE_VSDSIZE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_VSDSIZE_VSDSIZE) & BM_HDMI_FC_VSDSIZE_VSDSIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSDSIZE field to a new value.
#define BW_HDMI_FC_VSDSIZE_VSDSIZE(v)   (HW_HDMI_FC_VSDSIZE_WR((HW_HDMI_FC_VSDSIZE_RD() & ~BM_HDMI_FC_VSDSIZE_VSDSIZE) | BF_HDMI_FC_VSDSIZE_VSDSIZE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDIEEEID1 - Frame Composer VSI Packet Data IEEE Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDIEEEID1 - Frame Composer VSI Packet Data IEEE Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdieeeid1
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdieeeid1_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame IEEE registration identifier byte 1
    } B;
} hw_hdmi_fc_vsdieeeid1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDIEEEID1 register
 */
//@{
#define HW_HDMI_FC_VSDIEEEID1_ADDR      (REGS_HDMI_BASE + 0x1030)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDIEEEID1           (*(volatile hw_hdmi_fc_vsdieeeid1_t *) HW_HDMI_FC_VSDIEEEID1_ADDR)
#define HW_HDMI_FC_VSDIEEEID1_RD()      (HW_HDMI_FC_VSDIEEEID1.U)
#define HW_HDMI_FC_VSDIEEEID1_WR(v)     (HW_HDMI_FC_VSDIEEEID1.U = (v))
#define HW_HDMI_FC_VSDIEEEID1_SET(v)    (HW_HDMI_FC_VSDIEEEID1_WR(HW_HDMI_FC_VSDIEEEID1_RD() |  (v)))
#define HW_HDMI_FC_VSDIEEEID1_CLR(v)    (HW_HDMI_FC_VSDIEEEID1_WR(HW_HDMI_FC_VSDIEEEID1_RD() & ~(v)))
#define HW_HDMI_FC_VSDIEEEID1_TOG(v)    (HW_HDMI_FC_VSDIEEEID1_WR(HW_HDMI_FC_VSDIEEEID1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDIEEEID1 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDIEEEID2 - Frame Composer VSI Packet Data IEEE Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDIEEEID2 - Frame Composer VSI Packet Data IEEE Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdieeeid2
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdieeeid2_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame IEEE registration identifier byte 2
    } B;
} hw_hdmi_fc_vsdieeeid2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDIEEEID2 register
 */
//@{
#define HW_HDMI_FC_VSDIEEEID2_ADDR      (REGS_HDMI_BASE + 0x1031)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDIEEEID2           (*(volatile hw_hdmi_fc_vsdieeeid2_t *) HW_HDMI_FC_VSDIEEEID2_ADDR)
#define HW_HDMI_FC_VSDIEEEID2_RD()      (HW_HDMI_FC_VSDIEEEID2.U)
#define HW_HDMI_FC_VSDIEEEID2_WR(v)     (HW_HDMI_FC_VSDIEEEID2.U = (v))
#define HW_HDMI_FC_VSDIEEEID2_SET(v)    (HW_HDMI_FC_VSDIEEEID2_WR(HW_HDMI_FC_VSDIEEEID2_RD() |  (v)))
#define HW_HDMI_FC_VSDIEEEID2_CLR(v)    (HW_HDMI_FC_VSDIEEEID2_WR(HW_HDMI_FC_VSDIEEEID2_RD() & ~(v)))
#define HW_HDMI_FC_VSDIEEEID2_TOG(v)    (HW_HDMI_FC_VSDIEEEID2_WR(HW_HDMI_FC_VSDIEEEID2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDIEEEID2 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD0 - Frame Composer VSI Packet Data IEEE Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD0 - Frame Composer VSI Packet Data IEEE Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers configure the Vendor Specific infoFrame 24 bytes specific payload. For more
 * information, refer to CEA-861D specification.
 */
typedef union _hw_hdmi_fc_vsdpayload0
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload0_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte0
    } B;
} hw_hdmi_fc_vsdpayload0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD0 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD0_ADDR      (REGS_HDMI_BASE + 0x1032)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD0           (*(volatile hw_hdmi_fc_vsdpayload0_t *) HW_HDMI_FC_VSDPAYLOAD0_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD0_RD()      (HW_HDMI_FC_VSDPAYLOAD0.U)
#define HW_HDMI_FC_VSDPAYLOAD0_WR(v)     (HW_HDMI_FC_VSDPAYLOAD0.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD0_SET(v)    (HW_HDMI_FC_VSDPAYLOAD0_WR(HW_HDMI_FC_VSDPAYLOAD0_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD0_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD0_WR(HW_HDMI_FC_VSDPAYLOAD0_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD0_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD0_WR(HW_HDMI_FC_VSDPAYLOAD0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD0 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD1 - Frame Composer VSI Packet Data IEEE Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD1 - Frame Composer VSI Packet Data IEEE Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload1
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload1_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte1
    } B;
} hw_hdmi_fc_vsdpayload1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD1 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD1_ADDR      (REGS_HDMI_BASE + 0x1033)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD1           (*(volatile hw_hdmi_fc_vsdpayload1_t *) HW_HDMI_FC_VSDPAYLOAD1_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD1_RD()      (HW_HDMI_FC_VSDPAYLOAD1.U)
#define HW_HDMI_FC_VSDPAYLOAD1_WR(v)     (HW_HDMI_FC_VSDPAYLOAD1.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD1_SET(v)    (HW_HDMI_FC_VSDPAYLOAD1_WR(HW_HDMI_FC_VSDPAYLOAD1_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD1_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD1_WR(HW_HDMI_FC_VSDPAYLOAD1_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD1_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD1_WR(HW_HDMI_FC_VSDPAYLOAD1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD1 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD2 - Frame Composer VSI Packet Data IEEE Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD2 - Frame Composer VSI Packet Data IEEE Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload2
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload2_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte2
    } B;
} hw_hdmi_fc_vsdpayload2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD2 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD2_ADDR      (REGS_HDMI_BASE + 0x1034)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD2           (*(volatile hw_hdmi_fc_vsdpayload2_t *) HW_HDMI_FC_VSDPAYLOAD2_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD2_RD()      (HW_HDMI_FC_VSDPAYLOAD2.U)
#define HW_HDMI_FC_VSDPAYLOAD2_WR(v)     (HW_HDMI_FC_VSDPAYLOAD2.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD2_SET(v)    (HW_HDMI_FC_VSDPAYLOAD2_WR(HW_HDMI_FC_VSDPAYLOAD2_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD2_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD2_WR(HW_HDMI_FC_VSDPAYLOAD2_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD2_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD2_WR(HW_HDMI_FC_VSDPAYLOAD2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD2 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD3 - Frame Composer VSI Packet Data IEEE Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD3 - Frame Composer VSI Packet Data IEEE Register 3 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload3
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload3_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte3
    } B;
} hw_hdmi_fc_vsdpayload3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD3 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD3_ADDR      (REGS_HDMI_BASE + 0x1035)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD3           (*(volatile hw_hdmi_fc_vsdpayload3_t *) HW_HDMI_FC_VSDPAYLOAD3_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD3_RD()      (HW_HDMI_FC_VSDPAYLOAD3.U)
#define HW_HDMI_FC_VSDPAYLOAD3_WR(v)     (HW_HDMI_FC_VSDPAYLOAD3.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD3_SET(v)    (HW_HDMI_FC_VSDPAYLOAD3_WR(HW_HDMI_FC_VSDPAYLOAD3_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD3_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD3_WR(HW_HDMI_FC_VSDPAYLOAD3_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD3_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD3_WR(HW_HDMI_FC_VSDPAYLOAD3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD3 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD4 - Frame Composer VSI Packet Data IEEE Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD4 - Frame Composer VSI Packet Data IEEE Register 4 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload4
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload4_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte4
    } B;
} hw_hdmi_fc_vsdpayload4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD4 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD4_ADDR      (REGS_HDMI_BASE + 0x1036)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD4           (*(volatile hw_hdmi_fc_vsdpayload4_t *) HW_HDMI_FC_VSDPAYLOAD4_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD4_RD()      (HW_HDMI_FC_VSDPAYLOAD4.U)
#define HW_HDMI_FC_VSDPAYLOAD4_WR(v)     (HW_HDMI_FC_VSDPAYLOAD4.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD4_SET(v)    (HW_HDMI_FC_VSDPAYLOAD4_WR(HW_HDMI_FC_VSDPAYLOAD4_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD4_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD4_WR(HW_HDMI_FC_VSDPAYLOAD4_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD4_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD4_WR(HW_HDMI_FC_VSDPAYLOAD4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD4 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD5 - Frame Composer VSI Packet Data IEEE Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD5 - Frame Composer VSI Packet Data IEEE Register 5 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload5
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload5_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte5
    } B;
} hw_hdmi_fc_vsdpayload5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD5 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD5_ADDR      (REGS_HDMI_BASE + 0x1037)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD5           (*(volatile hw_hdmi_fc_vsdpayload5_t *) HW_HDMI_FC_VSDPAYLOAD5_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD5_RD()      (HW_HDMI_FC_VSDPAYLOAD5.U)
#define HW_HDMI_FC_VSDPAYLOAD5_WR(v)     (HW_HDMI_FC_VSDPAYLOAD5.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD5_SET(v)    (HW_HDMI_FC_VSDPAYLOAD5_WR(HW_HDMI_FC_VSDPAYLOAD5_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD5_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD5_WR(HW_HDMI_FC_VSDPAYLOAD5_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD5_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD5_WR(HW_HDMI_FC_VSDPAYLOAD5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD5 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD6 - Frame Composer VSI Packet Data IEEE Register 6
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD6 - Frame Composer VSI Packet Data IEEE Register 6 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload6
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload6_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte6
    } B;
} hw_hdmi_fc_vsdpayload6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD6 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD6_ADDR      (REGS_HDMI_BASE + 0x1038)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD6           (*(volatile hw_hdmi_fc_vsdpayload6_t *) HW_HDMI_FC_VSDPAYLOAD6_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD6_RD()      (HW_HDMI_FC_VSDPAYLOAD6.U)
#define HW_HDMI_FC_VSDPAYLOAD6_WR(v)     (HW_HDMI_FC_VSDPAYLOAD6.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD6_SET(v)    (HW_HDMI_FC_VSDPAYLOAD6_WR(HW_HDMI_FC_VSDPAYLOAD6_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD6_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD6_WR(HW_HDMI_FC_VSDPAYLOAD6_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD6_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD6_WR(HW_HDMI_FC_VSDPAYLOAD6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD6 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD7 - Frame Composer VSI Packet Data IEEE Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD7 - Frame Composer VSI Packet Data IEEE Register 7 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload7
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload7_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte7
    } B;
} hw_hdmi_fc_vsdpayload7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD7 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD7_ADDR      (REGS_HDMI_BASE + 0x1039)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD7           (*(volatile hw_hdmi_fc_vsdpayload7_t *) HW_HDMI_FC_VSDPAYLOAD7_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD7_RD()      (HW_HDMI_FC_VSDPAYLOAD7.U)
#define HW_HDMI_FC_VSDPAYLOAD7_WR(v)     (HW_HDMI_FC_VSDPAYLOAD7.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD7_SET(v)    (HW_HDMI_FC_VSDPAYLOAD7_WR(HW_HDMI_FC_VSDPAYLOAD7_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD7_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD7_WR(HW_HDMI_FC_VSDPAYLOAD7_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD7_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD7_WR(HW_HDMI_FC_VSDPAYLOAD7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD7 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD8 - Frame Composer VSI Packet Data IEEE Register 8
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD8 - Frame Composer VSI Packet Data IEEE Register 8 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload8
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload8_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte8
    } B;
} hw_hdmi_fc_vsdpayload8_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD8 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD8_ADDR      (REGS_HDMI_BASE + 0x103a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD8           (*(volatile hw_hdmi_fc_vsdpayload8_t *) HW_HDMI_FC_VSDPAYLOAD8_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD8_RD()      (HW_HDMI_FC_VSDPAYLOAD8.U)
#define HW_HDMI_FC_VSDPAYLOAD8_WR(v)     (HW_HDMI_FC_VSDPAYLOAD8.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD8_SET(v)    (HW_HDMI_FC_VSDPAYLOAD8_WR(HW_HDMI_FC_VSDPAYLOAD8_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD8_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD8_WR(HW_HDMI_FC_VSDPAYLOAD8_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD8_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD8_WR(HW_HDMI_FC_VSDPAYLOAD8_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD8 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD9 - Frame Composer VSI Packet Data IEEE Register 9
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD9 - Frame Composer VSI Packet Data IEEE Register 9 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload9
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload9_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte9
    } B;
} hw_hdmi_fc_vsdpayload9_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD9 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD9_ADDR      (REGS_HDMI_BASE + 0x103b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD9           (*(volatile hw_hdmi_fc_vsdpayload9_t *) HW_HDMI_FC_VSDPAYLOAD9_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD9_RD()      (HW_HDMI_FC_VSDPAYLOAD9.U)
#define HW_HDMI_FC_VSDPAYLOAD9_WR(v)     (HW_HDMI_FC_VSDPAYLOAD9.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD9_SET(v)    (HW_HDMI_FC_VSDPAYLOAD9_WR(HW_HDMI_FC_VSDPAYLOAD9_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD9_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD9_WR(HW_HDMI_FC_VSDPAYLOAD9_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD9_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD9_WR(HW_HDMI_FC_VSDPAYLOAD9_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD9 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD10 - Frame Composer VSI Packet Data IEEE Register 10
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD10 - Frame Composer VSI Packet Data IEEE Register 10 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload10
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload10_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte10
    } B;
} hw_hdmi_fc_vsdpayload10_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD10 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD10_ADDR      (REGS_HDMI_BASE + 0x103c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD10           (*(volatile hw_hdmi_fc_vsdpayload10_t *) HW_HDMI_FC_VSDPAYLOAD10_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD10_RD()      (HW_HDMI_FC_VSDPAYLOAD10.U)
#define HW_HDMI_FC_VSDPAYLOAD10_WR(v)     (HW_HDMI_FC_VSDPAYLOAD10.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD10_SET(v)    (HW_HDMI_FC_VSDPAYLOAD10_WR(HW_HDMI_FC_VSDPAYLOAD10_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD10_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD10_WR(HW_HDMI_FC_VSDPAYLOAD10_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD10_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD10_WR(HW_HDMI_FC_VSDPAYLOAD10_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD10 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD11 - Frame Composer VSI Packet Data IEEE Register 11
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD11 - Frame Composer VSI Packet Data IEEE Register 11 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload11
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload11_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte11
    } B;
} hw_hdmi_fc_vsdpayload11_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD11 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD11_ADDR      (REGS_HDMI_BASE + 0x103d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD11           (*(volatile hw_hdmi_fc_vsdpayload11_t *) HW_HDMI_FC_VSDPAYLOAD11_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD11_RD()      (HW_HDMI_FC_VSDPAYLOAD11.U)
#define HW_HDMI_FC_VSDPAYLOAD11_WR(v)     (HW_HDMI_FC_VSDPAYLOAD11.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD11_SET(v)    (HW_HDMI_FC_VSDPAYLOAD11_WR(HW_HDMI_FC_VSDPAYLOAD11_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD11_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD11_WR(HW_HDMI_FC_VSDPAYLOAD11_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD11_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD11_WR(HW_HDMI_FC_VSDPAYLOAD11_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD11 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD12 - Frame Composer VSI Packet Data IEEE Register 12
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD12 - Frame Composer VSI Packet Data IEEE Register 12 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload12
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload12_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte12
    } B;
} hw_hdmi_fc_vsdpayload12_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD12 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD12_ADDR      (REGS_HDMI_BASE + 0x103e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD12           (*(volatile hw_hdmi_fc_vsdpayload12_t *) HW_HDMI_FC_VSDPAYLOAD12_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD12_RD()      (HW_HDMI_FC_VSDPAYLOAD12.U)
#define HW_HDMI_FC_VSDPAYLOAD12_WR(v)     (HW_HDMI_FC_VSDPAYLOAD12.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD12_SET(v)    (HW_HDMI_FC_VSDPAYLOAD12_WR(HW_HDMI_FC_VSDPAYLOAD12_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD12_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD12_WR(HW_HDMI_FC_VSDPAYLOAD12_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD12_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD12_WR(HW_HDMI_FC_VSDPAYLOAD12_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD12 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD13 - Frame Composer VSI Packet Data IEEE Register 13
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD13 - Frame Composer VSI Packet Data IEEE Register 13 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload13
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload13_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte13
    } B;
} hw_hdmi_fc_vsdpayload13_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD13 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD13_ADDR      (REGS_HDMI_BASE + 0x103f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD13           (*(volatile hw_hdmi_fc_vsdpayload13_t *) HW_HDMI_FC_VSDPAYLOAD13_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD13_RD()      (HW_HDMI_FC_VSDPAYLOAD13.U)
#define HW_HDMI_FC_VSDPAYLOAD13_WR(v)     (HW_HDMI_FC_VSDPAYLOAD13.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD13_SET(v)    (HW_HDMI_FC_VSDPAYLOAD13_WR(HW_HDMI_FC_VSDPAYLOAD13_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD13_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD13_WR(HW_HDMI_FC_VSDPAYLOAD13_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD13_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD13_WR(HW_HDMI_FC_VSDPAYLOAD13_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD13 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD14 - Frame Composer VSI Packet Data IEEE Register 14
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD14 - Frame Composer VSI Packet Data IEEE Register 14 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload14
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload14_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte14
    } B;
} hw_hdmi_fc_vsdpayload14_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD14 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD14_ADDR      (REGS_HDMI_BASE + 0x1040)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD14           (*(volatile hw_hdmi_fc_vsdpayload14_t *) HW_HDMI_FC_VSDPAYLOAD14_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD14_RD()      (HW_HDMI_FC_VSDPAYLOAD14.U)
#define HW_HDMI_FC_VSDPAYLOAD14_WR(v)     (HW_HDMI_FC_VSDPAYLOAD14.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD14_SET(v)    (HW_HDMI_FC_VSDPAYLOAD14_WR(HW_HDMI_FC_VSDPAYLOAD14_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD14_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD14_WR(HW_HDMI_FC_VSDPAYLOAD14_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD14_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD14_WR(HW_HDMI_FC_VSDPAYLOAD14_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD14 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD15 - Frame Composer VSI Packet Data IEEE Register 15
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD15 - Frame Composer VSI Packet Data IEEE Register 15 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload15
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload15_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte15
    } B;
} hw_hdmi_fc_vsdpayload15_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD15 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD15_ADDR      (REGS_HDMI_BASE + 0x1041)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD15           (*(volatile hw_hdmi_fc_vsdpayload15_t *) HW_HDMI_FC_VSDPAYLOAD15_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD15_RD()      (HW_HDMI_FC_VSDPAYLOAD15.U)
#define HW_HDMI_FC_VSDPAYLOAD15_WR(v)     (HW_HDMI_FC_VSDPAYLOAD15.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD15_SET(v)    (HW_HDMI_FC_VSDPAYLOAD15_WR(HW_HDMI_FC_VSDPAYLOAD15_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD15_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD15_WR(HW_HDMI_FC_VSDPAYLOAD15_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD15_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD15_WR(HW_HDMI_FC_VSDPAYLOAD15_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD15 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD16 - Frame Composer VSI Packet Data IEEE Register 16
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD16 - Frame Composer VSI Packet Data IEEE Register 16 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload16
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload16_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte16
    } B;
} hw_hdmi_fc_vsdpayload16_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD16 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD16_ADDR      (REGS_HDMI_BASE + 0x1042)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD16           (*(volatile hw_hdmi_fc_vsdpayload16_t *) HW_HDMI_FC_VSDPAYLOAD16_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD16_RD()      (HW_HDMI_FC_VSDPAYLOAD16.U)
#define HW_HDMI_FC_VSDPAYLOAD16_WR(v)     (HW_HDMI_FC_VSDPAYLOAD16.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD16_SET(v)    (HW_HDMI_FC_VSDPAYLOAD16_WR(HW_HDMI_FC_VSDPAYLOAD16_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD16_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD16_WR(HW_HDMI_FC_VSDPAYLOAD16_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD16_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD16_WR(HW_HDMI_FC_VSDPAYLOAD16_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD16 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD17 - Frame Composer VSI Packet Data IEEE Register 17
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD17 - Frame Composer VSI Packet Data IEEE Register 17 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload17
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload17_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte17
    } B;
} hw_hdmi_fc_vsdpayload17_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD17 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD17_ADDR      (REGS_HDMI_BASE + 0x1043)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD17           (*(volatile hw_hdmi_fc_vsdpayload17_t *) HW_HDMI_FC_VSDPAYLOAD17_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD17_RD()      (HW_HDMI_FC_VSDPAYLOAD17.U)
#define HW_HDMI_FC_VSDPAYLOAD17_WR(v)     (HW_HDMI_FC_VSDPAYLOAD17.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD17_SET(v)    (HW_HDMI_FC_VSDPAYLOAD17_WR(HW_HDMI_FC_VSDPAYLOAD17_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD17_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD17_WR(HW_HDMI_FC_VSDPAYLOAD17_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD17_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD17_WR(HW_HDMI_FC_VSDPAYLOAD17_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD17 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD18 - Frame Composer VSI Packet Data IEEE Register 18
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD18 - Frame Composer VSI Packet Data IEEE Register 18 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload18
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload18_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte18
    } B;
} hw_hdmi_fc_vsdpayload18_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD18 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD18_ADDR      (REGS_HDMI_BASE + 0x1044)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD18           (*(volatile hw_hdmi_fc_vsdpayload18_t *) HW_HDMI_FC_VSDPAYLOAD18_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD18_RD()      (HW_HDMI_FC_VSDPAYLOAD18.U)
#define HW_HDMI_FC_VSDPAYLOAD18_WR(v)     (HW_HDMI_FC_VSDPAYLOAD18.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD18_SET(v)    (HW_HDMI_FC_VSDPAYLOAD18_WR(HW_HDMI_FC_VSDPAYLOAD18_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD18_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD18_WR(HW_HDMI_FC_VSDPAYLOAD18_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD18_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD18_WR(HW_HDMI_FC_VSDPAYLOAD18_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD18 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD19 - Frame Composer VSI Packet Data IEEE Register 19
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD19 - Frame Composer VSI Packet Data IEEE Register 19 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload19
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload19_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte19
    } B;
} hw_hdmi_fc_vsdpayload19_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD19 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD19_ADDR      (REGS_HDMI_BASE + 0x1045)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD19           (*(volatile hw_hdmi_fc_vsdpayload19_t *) HW_HDMI_FC_VSDPAYLOAD19_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD19_RD()      (HW_HDMI_FC_VSDPAYLOAD19.U)
#define HW_HDMI_FC_VSDPAYLOAD19_WR(v)     (HW_HDMI_FC_VSDPAYLOAD19.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD19_SET(v)    (HW_HDMI_FC_VSDPAYLOAD19_WR(HW_HDMI_FC_VSDPAYLOAD19_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD19_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD19_WR(HW_HDMI_FC_VSDPAYLOAD19_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD19_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD19_WR(HW_HDMI_FC_VSDPAYLOAD19_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD19 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD20 - Frame Composer VSI Packet Data IEEE Register 20
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD20 - Frame Composer VSI Packet Data IEEE Register 20 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload20
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload20_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte20
    } B;
} hw_hdmi_fc_vsdpayload20_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD20 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD20_ADDR      (REGS_HDMI_BASE + 0x1046)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD20           (*(volatile hw_hdmi_fc_vsdpayload20_t *) HW_HDMI_FC_VSDPAYLOAD20_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD20_RD()      (HW_HDMI_FC_VSDPAYLOAD20.U)
#define HW_HDMI_FC_VSDPAYLOAD20_WR(v)     (HW_HDMI_FC_VSDPAYLOAD20.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD20_SET(v)    (HW_HDMI_FC_VSDPAYLOAD20_WR(HW_HDMI_FC_VSDPAYLOAD20_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD20_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD20_WR(HW_HDMI_FC_VSDPAYLOAD20_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD20_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD20_WR(HW_HDMI_FC_VSDPAYLOAD20_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD20 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD21 - Frame Composer VSI Packet Data IEEE Register 21
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD21 - Frame Composer VSI Packet Data IEEE Register 21 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload21
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload21_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte21
    } B;
} hw_hdmi_fc_vsdpayload21_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD21 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD21_ADDR      (REGS_HDMI_BASE + 0x1047)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD21           (*(volatile hw_hdmi_fc_vsdpayload21_t *) HW_HDMI_FC_VSDPAYLOAD21_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD21_RD()      (HW_HDMI_FC_VSDPAYLOAD21.U)
#define HW_HDMI_FC_VSDPAYLOAD21_WR(v)     (HW_HDMI_FC_VSDPAYLOAD21.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD21_SET(v)    (HW_HDMI_FC_VSDPAYLOAD21_WR(HW_HDMI_FC_VSDPAYLOAD21_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD21_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD21_WR(HW_HDMI_FC_VSDPAYLOAD21_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD21_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD21_WR(HW_HDMI_FC_VSDPAYLOAD21_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD21 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD22 - Frame Composer VSI Packet Data IEEE Register 22
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD22 - Frame Composer VSI Packet Data IEEE Register 22 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload22
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload22_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte22
    } B;
} hw_hdmi_fc_vsdpayload22_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD22 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD22_ADDR      (REGS_HDMI_BASE + 0x1048)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD22           (*(volatile hw_hdmi_fc_vsdpayload22_t *) HW_HDMI_FC_VSDPAYLOAD22_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD22_RD()      (HW_HDMI_FC_VSDPAYLOAD22.U)
#define HW_HDMI_FC_VSDPAYLOAD22_WR(v)     (HW_HDMI_FC_VSDPAYLOAD22.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD22_SET(v)    (HW_HDMI_FC_VSDPAYLOAD22_WR(HW_HDMI_FC_VSDPAYLOAD22_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD22_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD22_WR(HW_HDMI_FC_VSDPAYLOAD22_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD22_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD22_WR(HW_HDMI_FC_VSDPAYLOAD22_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD22 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_VSDPAYLOAD23 - Frame Composer VSI Packet Data IEEE Register 23
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_VSDPAYLOAD23 - Frame Composer VSI Packet Data IEEE Register 23 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_vsdpayload23
{
    reg8_t U;
    struct _hw_hdmi_fc_vsdpayload23_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] the Vendor Specific infoFrame 24 bytes specific payload byte23
    } B;
} hw_hdmi_fc_vsdpayload23_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_VSDPAYLOAD23 register
 */
//@{
#define HW_HDMI_FC_VSDPAYLOAD23_ADDR      (REGS_HDMI_BASE + 0x1049)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_VSDPAYLOAD23           (*(volatile hw_hdmi_fc_vsdpayload23_t *) HW_HDMI_FC_VSDPAYLOAD23_ADDR)
#define HW_HDMI_FC_VSDPAYLOAD23_RD()      (HW_HDMI_FC_VSDPAYLOAD23.U)
#define HW_HDMI_FC_VSDPAYLOAD23_WR(v)     (HW_HDMI_FC_VSDPAYLOAD23.U = (v))
#define HW_HDMI_FC_VSDPAYLOAD23_SET(v)    (HW_HDMI_FC_VSDPAYLOAD23_WR(HW_HDMI_FC_VSDPAYLOAD23_RD() |  (v)))
#define HW_HDMI_FC_VSDPAYLOAD23_CLR(v)    (HW_HDMI_FC_VSDPAYLOAD23_WR(HW_HDMI_FC_VSDPAYLOAD23_RD() & ~(v)))
#define HW_HDMI_FC_VSDPAYLOAD23_TOG(v)    (HW_HDMI_FC_VSDPAYLOAD23_WR(HW_HDMI_FC_VSDPAYLOAD23_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_VSDPAYLOAD23 bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_SPDVENDORNAME0 - Frame Composer SPD Packet Data Vendor Name Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_SPDVENDORNAME0 - Frame Composer SPD Packet Data Vendor Name Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers configure the Source Product Descriptor infoFrame 8 bytes Vendor name. For more
 * information, refer to CEA-861D specification. Address Offset: 0x104A to 0x1051 Size: 8 bits Value
 * after Reset: 0x00 Access: Read/Write
 */
typedef union _hw_hdmi_fc_spdvendorname0
{
    reg8_t U;
    struct _hw_hdmi_fc_spdvendorname0_bitfields
    {
        unsigned char VENDOR_NAME : 8; //!< [7:0] Vendor name
    } B;
} hw_hdmi_fc_spdvendorname0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_SPDVENDORNAME0 register
 */
//@{
#define HW_HDMI_FC_SPDVENDORNAME0_ADDR      (REGS_HDMI_BASE + 0x104a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_SPDVENDORNAME0           (*(volatile hw_hdmi_fc_spdvendorname0_t *) HW_HDMI_FC_SPDVENDORNAME0_ADDR)
#define HW_HDMI_FC_SPDVENDORNAME0_RD()      (HW_HDMI_FC_SPDVENDORNAME0.U)
#define HW_HDMI_FC_SPDVENDORNAME0_WR(v)     (HW_HDMI_FC_SPDVENDORNAME0.U = (v))
#define HW_HDMI_FC_SPDVENDORNAME0_SET(v)    (HW_HDMI_FC_SPDVENDORNAME0_WR(HW_HDMI_FC_SPDVENDORNAME0_RD() |  (v)))
#define HW_HDMI_FC_SPDVENDORNAME0_CLR(v)    (HW_HDMI_FC_SPDVENDORNAME0_WR(HW_HDMI_FC_SPDVENDORNAME0_RD() & ~(v)))
#define HW_HDMI_FC_SPDVENDORNAME0_TOG(v)    (HW_HDMI_FC_SPDVENDORNAME0_WR(HW_HDMI_FC_SPDVENDORNAME0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_SPDVENDORNAME0 bitfields
 */

/*! @name Register HDMI_FC_SPDVENDORNAME0, field VENDOR_NAME[7:0] (RW)
 *
 * Vendor name
 */
//@{
#define BP_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME      (0)      //!< Bit position for HDMI_FC_SPDVENDORNAME0_VENDOR_NAME.
#define BM_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME      (0x000000ff)  //!< Bit mask for HDMI_FC_SPDVENDORNAME0_VENDOR_NAME.

//! @brief Get value of HDMI_FC_SPDVENDORNAME0_VENDOR_NAME from a register value.
#define BG_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME) >> BP_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME)

//! @brief Format value for bitfield HDMI_FC_SPDVENDORNAME0_VENDOR_NAME.
#define BF_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME) & BM_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VENDOR_NAME field to a new value.
#define BW_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME(v)   (HW_HDMI_FC_SPDVENDORNAME0_WR((HW_HDMI_FC_SPDVENDORNAME0_RD() & ~BM_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME) | BF_HDMI_FC_SPDVENDORNAME0_VENDOR_NAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_SPDPRODUCTNAME0 - Frame Composer SPD Packet Data Product Name Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_SPDPRODUCTNAME0 - Frame Composer SPD Packet Data Product Name Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers configure the Source Product Descriptor infoFrame 16 bytes Product name. For more
 * information, refer to CEA-861D specification. Address Offset: 0x1052 to 0x1061 Size: 8 bits Value
 * after Reset: 0x00 Access: Read/Write
 */
typedef union _hw_hdmi_fc_spdproductname0
{
    reg8_t U;
    struct _hw_hdmi_fc_spdproductname0_bitfields
    {
        unsigned char PRODUCT_NAME : 8; //!< [7:0] Product name
    } B;
} hw_hdmi_fc_spdproductname0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_SPDPRODUCTNAME0 register
 */
//@{
#define HW_HDMI_FC_SPDPRODUCTNAME0_ADDR      (REGS_HDMI_BASE + 0x1052)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_SPDPRODUCTNAME0           (*(volatile hw_hdmi_fc_spdproductname0_t *) HW_HDMI_FC_SPDPRODUCTNAME0_ADDR)
#define HW_HDMI_FC_SPDPRODUCTNAME0_RD()      (HW_HDMI_FC_SPDPRODUCTNAME0.U)
#define HW_HDMI_FC_SPDPRODUCTNAME0_WR(v)     (HW_HDMI_FC_SPDPRODUCTNAME0.U = (v))
#define HW_HDMI_FC_SPDPRODUCTNAME0_SET(v)    (HW_HDMI_FC_SPDPRODUCTNAME0_WR(HW_HDMI_FC_SPDPRODUCTNAME0_RD() |  (v)))
#define HW_HDMI_FC_SPDPRODUCTNAME0_CLR(v)    (HW_HDMI_FC_SPDPRODUCTNAME0_WR(HW_HDMI_FC_SPDPRODUCTNAME0_RD() & ~(v)))
#define HW_HDMI_FC_SPDPRODUCTNAME0_TOG(v)    (HW_HDMI_FC_SPDPRODUCTNAME0_WR(HW_HDMI_FC_SPDPRODUCTNAME0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_SPDPRODUCTNAME0 bitfields
 */

/*! @name Register HDMI_FC_SPDPRODUCTNAME0, field PRODUCT_NAME[7:0] (RW)
 *
 * Product name
 */
//@{
#define BP_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME      (0)      //!< Bit position for HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME.
#define BM_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME      (0x000000ff)  //!< Bit mask for HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME.

//! @brief Get value of HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME from a register value.
#define BG_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME) >> BP_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME)

//! @brief Format value for bitfield HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME.
#define BF_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME) & BM_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRODUCT_NAME field to a new value.
#define BW_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME(v)   (HW_HDMI_FC_SPDPRODUCTNAME0_WR((HW_HDMI_FC_SPDPRODUCTNAME0_RD() & ~BM_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME) | BF_HDMI_FC_SPDPRODUCTNAME0_PRODUCT_NAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_SPDDEVICEINF - Frame Composer SPD Packet Data Source Product Descriptor Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_SPDDEVICEINF - Frame Composer SPD Packet Data Source Product Descriptor Register (RW)
 *
 * Reset value: 0x00
 *
 * This register configures Source Product Descriptor infoFrame description device field. For more
 * information, refer to CEA-861D specification.
 */
typedef union _hw_hdmi_fc_spddeviceinf
{
    reg8_t U;
    struct _hw_hdmi_fc_spddeviceinf_bitfields
    {
        unsigned char PRODUCT_DESCRIPTOR : 8; //!< [7:0] Product descriptor
    } B;
} hw_hdmi_fc_spddeviceinf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_SPDDEVICEINF register
 */
//@{
#define HW_HDMI_FC_SPDDEVICEINF_ADDR      (REGS_HDMI_BASE + 0x1062)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_SPDDEVICEINF           (*(volatile hw_hdmi_fc_spddeviceinf_t *) HW_HDMI_FC_SPDDEVICEINF_ADDR)
#define HW_HDMI_FC_SPDDEVICEINF_RD()      (HW_HDMI_FC_SPDDEVICEINF.U)
#define HW_HDMI_FC_SPDDEVICEINF_WR(v)     (HW_HDMI_FC_SPDDEVICEINF.U = (v))
#define HW_HDMI_FC_SPDDEVICEINF_SET(v)    (HW_HDMI_FC_SPDDEVICEINF_WR(HW_HDMI_FC_SPDDEVICEINF_RD() |  (v)))
#define HW_HDMI_FC_SPDDEVICEINF_CLR(v)    (HW_HDMI_FC_SPDDEVICEINF_WR(HW_HDMI_FC_SPDDEVICEINF_RD() & ~(v)))
#define HW_HDMI_FC_SPDDEVICEINF_TOG(v)    (HW_HDMI_FC_SPDDEVICEINF_WR(HW_HDMI_FC_SPDDEVICEINF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_SPDDEVICEINF bitfields
 */

/*! @name Register HDMI_FC_SPDDEVICEINF, field PRODUCT_DESCRIPTOR[7:0] (RW)
 *
 * Product descriptor
 */
//@{
#define BP_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR      (0)      //!< Bit position for HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR.
#define BM_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR      (0x000000ff)  //!< Bit mask for HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR.

//! @brief Get value of HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR from a register value.
#define BG_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR) >> BP_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR)

//! @brief Format value for bitfield HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR.
#define BF_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR) & BM_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRODUCT_DESCRIPTOR field to a new value.
#define BW_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR(v)   (HW_HDMI_FC_SPDDEVICEINF_WR((HW_HDMI_FC_SPDDEVICEINF_RD() & ~BM_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR) | BF_HDMI_FC_SPDDEVICEINF_PRODUCT_DESCRIPTOR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDSCONF - Frame Composer Audio Sample Flat and Layout Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDSCONF - Frame Composer Audio Sample Flat and Layout Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Audio sample packet sample flat and layout configuration. For more information,
 * refer to HDMI 1.4a specification. Address Offset: 0x1063 Size: 8 bits Value after Reset: 0x00
 * AEccess: Read/Write
 */
typedef union _hw_hdmi_fc_audsconf
{
    reg8_t U;
    struct _hw_hdmi_fc_audsconf_bitfields
    {
        unsigned char AUD_PACKET_LAYOUT : 1; //!< [0] Set the audio packet layout to be sent in the packet:
        unsigned char RESERVED0 : 3; //!< [3:1] Reserved
        unsigned char AUD_PACKET_SAMPFIT : 4; //!< [7:4] Set the audio packet sample flat value to be sent on the packet.
    } B;
} hw_hdmi_fc_audsconf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDSCONF register
 */
//@{
#define HW_HDMI_FC_AUDSCONF_ADDR      (REGS_HDMI_BASE + 0x1063)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDSCONF           (*(volatile hw_hdmi_fc_audsconf_t *) HW_HDMI_FC_AUDSCONF_ADDR)
#define HW_HDMI_FC_AUDSCONF_RD()      (HW_HDMI_FC_AUDSCONF.U)
#define HW_HDMI_FC_AUDSCONF_WR(v)     (HW_HDMI_FC_AUDSCONF.U = (v))
#define HW_HDMI_FC_AUDSCONF_SET(v)    (HW_HDMI_FC_AUDSCONF_WR(HW_HDMI_FC_AUDSCONF_RD() |  (v)))
#define HW_HDMI_FC_AUDSCONF_CLR(v)    (HW_HDMI_FC_AUDSCONF_WR(HW_HDMI_FC_AUDSCONF_RD() & ~(v)))
#define HW_HDMI_FC_AUDSCONF_TOG(v)    (HW_HDMI_FC_AUDSCONF_WR(HW_HDMI_FC_AUDSCONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDSCONF bitfields
 */

/*! @name Register HDMI_FC_AUDSCONF, field AUD_PACKET_LAYOUT[0] (RW)
 *
 * Set the audio packet layout to be sent in the packet:
 *
 * Values:
 * - 0 - layout 0
 * - 1 - layout 1
 */
//@{
#define BP_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT      (0)      //!< Bit position for HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT.
#define BM_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT      (0x00000001)  //!< Bit mask for HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT.

//! @brief Get value of HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT from a register value.
#define BG_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT) >> BP_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT)

//! @brief Format value for bitfield HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT.
#define BF_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT) & BM_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_PACKET_LAYOUT field to a new value.
#define BW_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT(v)   (HW_HDMI_FC_AUDSCONF_WR((HW_HDMI_FC_AUDSCONF_RD() & ~BM_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT) | BF_HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT(v)))
#endif
//@}

/*! @name Register HDMI_FC_AUDSCONF, field AUD_PACKET_SAMPFIT[7:4] (RW)
 *
 * Set the audio packet sample flat value to be sent on the packet.
 */
//@{
#define BP_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT      (4)      //!< Bit position for HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT.
#define BM_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT      (0x000000f0)  //!< Bit mask for HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT.

//! @brief Get value of HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT from a register value.
#define BG_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT) >> BP_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT)

//! @brief Format value for bitfield HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT.
#define BF_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT) & BM_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUD_PACKET_SAMPFIT field to a new value.
#define BW_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT(v)   (HW_HDMI_FC_AUDSCONF_WR((HW_HDMI_FC_AUDSCONF_RD() & ~BM_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT) | BF_HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_AUDSSTAT - Frame Composer Audio Packet Sample Present Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_AUDSSTAT - Frame Composer Audio Packet Sample Present Status Register (RO)
 *
 * Reset value: 0x00
 *
 * Shows the data sample present indication of the last Audio sample packet sent by the HDMI TX
 * Controller. For more information, refer to HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_audsstat
{
    reg8_t U;
    struct _hw_hdmi_fc_audsstat_bitfields
    {
        unsigned char PACKET_SAMPPRS : 4; //!< [3:0] Shows the data sample present indication of the last Audio sample packet sent by the HDMI TX Controller.
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_audsstat_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_AUDSSTAT register
 */
//@{
#define HW_HDMI_FC_AUDSSTAT_ADDR      (REGS_HDMI_BASE + 0x1064)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_AUDSSTAT           (*(volatile hw_hdmi_fc_audsstat_t *) HW_HDMI_FC_AUDSSTAT_ADDR)
#define HW_HDMI_FC_AUDSSTAT_RD()      (HW_HDMI_FC_AUDSSTAT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_AUDSSTAT bitfields
 */

/*! @name Register HDMI_FC_AUDSSTAT, field PACKET_SAMPPRS[3:0] (RO)
 *
 * Shows the data sample present indication of the last Audio sample packet sent by the HDMI TX
 * Controller. This register information is at tmds clock rate.
 */
//@{
#define BP_HDMI_FC_AUDSSTAT_PACKET_SAMPPRS      (0)      //!< Bit position for HDMI_FC_AUDSSTAT_PACKET_SAMPPRS.
#define BM_HDMI_FC_AUDSSTAT_PACKET_SAMPPRS      (0x0000000f)  //!< Bit mask for HDMI_FC_AUDSSTAT_PACKET_SAMPPRS.

//! @brief Get value of HDMI_FC_AUDSSTAT_PACKET_SAMPPRS from a register value.
#define BG_HDMI_FC_AUDSSTAT_PACKET_SAMPPRS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_AUDSSTAT_PACKET_SAMPPRS) >> BP_HDMI_FC_AUDSSTAT_PACKET_SAMPPRS)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CTRLQHIGH - Frame Composer Number of High Priority Packets Attended Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CTRLQHIGH - Frame Composer Number of High Priority Packets Attended Configuration Register (RW)
 *
 * Reset value: 0x0f
 */
typedef union _hw_hdmi_fc_ctrlqhigh
{
    reg8_t U;
    struct _hw_hdmi_fc_ctrlqhigh_bitfields
    {
        unsigned char ONHIGHATTENDED : 5; //!< [4:0] Configures the number of high priority packets or audio sample packets consecutively attended before checking low priority queue status.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_ctrlqhigh_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CTRLQHIGH register
 */
//@{
#define HW_HDMI_FC_CTRLQHIGH_ADDR      (REGS_HDMI_BASE + 0x1073)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CTRLQHIGH           (*(volatile hw_hdmi_fc_ctrlqhigh_t *) HW_HDMI_FC_CTRLQHIGH_ADDR)
#define HW_HDMI_FC_CTRLQHIGH_RD()      (HW_HDMI_FC_CTRLQHIGH.U)
#define HW_HDMI_FC_CTRLQHIGH_WR(v)     (HW_HDMI_FC_CTRLQHIGH.U = (v))
#define HW_HDMI_FC_CTRLQHIGH_SET(v)    (HW_HDMI_FC_CTRLQHIGH_WR(HW_HDMI_FC_CTRLQHIGH_RD() |  (v)))
#define HW_HDMI_FC_CTRLQHIGH_CLR(v)    (HW_HDMI_FC_CTRLQHIGH_WR(HW_HDMI_FC_CTRLQHIGH_RD() & ~(v)))
#define HW_HDMI_FC_CTRLQHIGH_TOG(v)    (HW_HDMI_FC_CTRLQHIGH_WR(HW_HDMI_FC_CTRLQHIGH_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CTRLQHIGH bitfields
 */

/*! @name Register HDMI_FC_CTRLQHIGH, field ONHIGHATTENDED[4:0] (RW)
 *
 * Configures the number of high priority packets or audio sample packets consecutively attended
 * before checking low priority queue status. Integer number [0..31]
 */
//@{
#define BP_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED      (0)      //!< Bit position for HDMI_FC_CTRLQHIGH_ONHIGHATTENDED.
#define BM_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED      (0x0000001f)  //!< Bit mask for HDMI_FC_CTRLQHIGH_ONHIGHATTENDED.

//! @brief Get value of HDMI_FC_CTRLQHIGH_ONHIGHATTENDED from a register value.
#define BG_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED) >> BP_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED)

//! @brief Format value for bitfield HDMI_FC_CTRLQHIGH_ONHIGHATTENDED.
#define BF_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED) & BM_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ONHIGHATTENDED field to a new value.
#define BW_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED(v)   (HW_HDMI_FC_CTRLQHIGH_WR((HW_HDMI_FC_CTRLQHIGH_RD() & ~BM_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED) | BF_HDMI_FC_CTRLQHIGH_ONHIGHATTENDED(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_CTRLQLOW - Frame Composer Number of Low Priority Packets Attended Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_CTRLQLOW - Frame Composer Number of Low Priority Packets Attended Configuration Register (RW)
 *
 * Reset value: 0x03
 */
typedef union _hw_hdmi_fc_ctrlqlow
{
    reg8_t U;
    struct _hw_hdmi_fc_ctrlqlow_bitfields
    {
        unsigned char ONLOWATTENDED : 5; //!< [4:0] Configures the number of low priority packets or null packets consecutively attended before checking high priority queue status or audio sample availability.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_ctrlqlow_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_CTRLQLOW register
 */
//@{
#define HW_HDMI_FC_CTRLQLOW_ADDR      (REGS_HDMI_BASE + 0x1074)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_CTRLQLOW           (*(volatile hw_hdmi_fc_ctrlqlow_t *) HW_HDMI_FC_CTRLQLOW_ADDR)
#define HW_HDMI_FC_CTRLQLOW_RD()      (HW_HDMI_FC_CTRLQLOW.U)
#define HW_HDMI_FC_CTRLQLOW_WR(v)     (HW_HDMI_FC_CTRLQLOW.U = (v))
#define HW_HDMI_FC_CTRLQLOW_SET(v)    (HW_HDMI_FC_CTRLQLOW_WR(HW_HDMI_FC_CTRLQLOW_RD() |  (v)))
#define HW_HDMI_FC_CTRLQLOW_CLR(v)    (HW_HDMI_FC_CTRLQLOW_WR(HW_HDMI_FC_CTRLQLOW_RD() & ~(v)))
#define HW_HDMI_FC_CTRLQLOW_TOG(v)    (HW_HDMI_FC_CTRLQLOW_WR(HW_HDMI_FC_CTRLQLOW_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_CTRLQLOW bitfields
 */

/*! @name Register HDMI_FC_CTRLQLOW, field ONLOWATTENDED[4:0] (RW)
 *
 * Configures the number of low priority packets or null packets consecutively attended before
 * checking high priority queue status or audio sample availability. Integer number [0..31]
 */
//@{
#define BP_HDMI_FC_CTRLQLOW_ONLOWATTENDED      (0)      //!< Bit position for HDMI_FC_CTRLQLOW_ONLOWATTENDED.
#define BM_HDMI_FC_CTRLQLOW_ONLOWATTENDED      (0x0000001f)  //!< Bit mask for HDMI_FC_CTRLQLOW_ONLOWATTENDED.

//! @brief Get value of HDMI_FC_CTRLQLOW_ONLOWATTENDED from a register value.
#define BG_HDMI_FC_CTRLQLOW_ONLOWATTENDED(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_CTRLQLOW_ONLOWATTENDED) >> BP_HDMI_FC_CTRLQLOW_ONLOWATTENDED)

//! @brief Format value for bitfield HDMI_FC_CTRLQLOW_ONLOWATTENDED.
#define BF_HDMI_FC_CTRLQLOW_ONLOWATTENDED(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_CTRLQLOW_ONLOWATTENDED) & BM_HDMI_FC_CTRLQLOW_ONLOWATTENDED)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ONLOWATTENDED field to a new value.
#define BW_HDMI_FC_CTRLQLOW_ONLOWATTENDED(v)   (HW_HDMI_FC_CTRLQLOW_WR((HW_HDMI_FC_CTRLQLOW_RD() & ~BM_HDMI_FC_CTRLQLOW_ONLOWATTENDED) | BF_HDMI_FC_CTRLQLOW_ONLOWATTENDED(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_ACP0 - Frame Composer ACP Packet Type Configuration Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_ACP0 - Frame Composer ACP Packet Type Configuration Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the ACP packet. For more information, refer to the HDMI 1.4
 * specification.
 */
typedef union _hw_hdmi_fc_acp0
{
    reg8_t U;
    struct _hw_hdmi_fc_acp0_bitfields
    {
        unsigned char ACPTYPE : 8; //!< [7:0] Configures the ACP packet type.
    } B;
} hw_hdmi_fc_acp0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_ACP0 register
 */
//@{
#define HW_HDMI_FC_ACP0_ADDR      (REGS_HDMI_BASE + 0x1075)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_ACP0           (*(volatile hw_hdmi_fc_acp0_t *) HW_HDMI_FC_ACP0_ADDR)
#define HW_HDMI_FC_ACP0_RD()      (HW_HDMI_FC_ACP0.U)
#define HW_HDMI_FC_ACP0_WR(v)     (HW_HDMI_FC_ACP0.U = (v))
#define HW_HDMI_FC_ACP0_SET(v)    (HW_HDMI_FC_ACP0_WR(HW_HDMI_FC_ACP0_RD() |  (v)))
#define HW_HDMI_FC_ACP0_CLR(v)    (HW_HDMI_FC_ACP0_WR(HW_HDMI_FC_ACP0_RD() & ~(v)))
#define HW_HDMI_FC_ACP0_TOG(v)    (HW_HDMI_FC_ACP0_WR(HW_HDMI_FC_ACP0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_ACP0 bitfields
 */

/*! @name Register HDMI_FC_ACP0, field ACPTYPE[7:0] (RW)
 *
 * Configures the ACP packet type.
 */
//@{
#define BP_HDMI_FC_ACP0_ACPTYPE      (0)      //!< Bit position for HDMI_FC_ACP0_ACPTYPE.
#define BM_HDMI_FC_ACP0_ACPTYPE      (0x000000ff)  //!< Bit mask for HDMI_FC_ACP0_ACPTYPE.

//! @brief Get value of HDMI_FC_ACP0_ACPTYPE from a register value.
#define BG_HDMI_FC_ACP0_ACPTYPE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ACP0_ACPTYPE) >> BP_HDMI_FC_ACP0_ACPTYPE)

//! @brief Format value for bitfield HDMI_FC_ACP0_ACPTYPE.
#define BF_HDMI_FC_ACP0_ACPTYPE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ACP0_ACPTYPE) & BM_HDMI_FC_ACP0_ACPTYPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACPTYPE field to a new value.
#define BW_HDMI_FC_ACP0_ACPTYPE(v)   (HW_HDMI_FC_ACP0_WR((HW_HDMI_FC_ACP0_RD() & ~BM_HDMI_FC_ACP0_ACPTYPE) | BF_HDMI_FC_ACP0_ACPTYPE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_ACP1 - Frame Composer ACP Packet Type Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_ACP1 - Frame Composer ACP Packet Type Configuration Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the Audio Content Packet (ACP) body: Address Offset: 0x1091
 * to 0x1082 Size: 8 bits Value after Reset: 0x00 Access: Read/Write
 */
typedef union _hw_hdmi_fc_acp1
{
    reg8_t U;
    struct _hw_hdmi_fc_acp1_bitfields
    {
        unsigned char AUDIO_CONTENTPACKET : 8; //!< [7:0] Audio content packet
    } B;
} hw_hdmi_fc_acp1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_ACP1 register
 */
//@{
#define HW_HDMI_FC_ACP1_ADDR      (REGS_HDMI_BASE + 0x1091)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_ACP1           (*(volatile hw_hdmi_fc_acp1_t *) HW_HDMI_FC_ACP1_ADDR)
#define HW_HDMI_FC_ACP1_RD()      (HW_HDMI_FC_ACP1.U)
#define HW_HDMI_FC_ACP1_WR(v)     (HW_HDMI_FC_ACP1.U = (v))
#define HW_HDMI_FC_ACP1_SET(v)    (HW_HDMI_FC_ACP1_WR(HW_HDMI_FC_ACP1_RD() |  (v)))
#define HW_HDMI_FC_ACP1_CLR(v)    (HW_HDMI_FC_ACP1_WR(HW_HDMI_FC_ACP1_RD() & ~(v)))
#define HW_HDMI_FC_ACP1_TOG(v)    (HW_HDMI_FC_ACP1_WR(HW_HDMI_FC_ACP1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_ACP1 bitfields
 */

/*! @name Register HDMI_FC_ACP1, field AUDIO_CONTENTPACKET[7:0] (RW)
 *
 * Audio content packet
 */
//@{
#define BP_HDMI_FC_ACP1_AUDIO_CONTENTPACKET      (0)      //!< Bit position for HDMI_FC_ACP1_AUDIO_CONTENTPACKET.
#define BM_HDMI_FC_ACP1_AUDIO_CONTENTPACKET      (0x000000ff)  //!< Bit mask for HDMI_FC_ACP1_AUDIO_CONTENTPACKET.

//! @brief Get value of HDMI_FC_ACP1_AUDIO_CONTENTPACKET from a register value.
#define BG_HDMI_FC_ACP1_AUDIO_CONTENTPACKET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ACP1_AUDIO_CONTENTPACKET) >> BP_HDMI_FC_ACP1_AUDIO_CONTENTPACKET)

//! @brief Format value for bitfield HDMI_FC_ACP1_AUDIO_CONTENTPACKET.
#define BF_HDMI_FC_ACP1_AUDIO_CONTENTPACKET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ACP1_AUDIO_CONTENTPACKET) & BM_HDMI_FC_ACP1_AUDIO_CONTENTPACKET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDIO_CONTENTPACKET field to a new value.
#define BW_HDMI_FC_ACP1_AUDIO_CONTENTPACKET(v)   (HW_HDMI_FC_ACP1_WR((HW_HDMI_FC_ACP1_RD() & ~BM_HDMI_FC_ACP1_AUDIO_CONTENTPACKET) | BF_HDMI_FC_ACP1_AUDIO_CONTENTPACKET(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_ISCR1_0 - FC_ISCR1_Frame Composer Packet Status, Valid, and Continue Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_ISCR1_0 - FC_ISCR1_Frame Composer Packet Status, Valid, and Continue Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the ISRC1 packet: For more information, see the HDMI 1.4
 * specification.
 */
typedef union _hw_hdmi_fc_iscr1_0
{
    reg8_t U;
    struct _hw_hdmi_fc_iscr1_0_bitfields
    {
        unsigned char ISRC_CONT : 1; //!< [0] Indication of ISRC2.
        unsigned char ISRC_VALID : 1; //!< [1] Valid of ISRC1.
        unsigned char ISRC_STATUS : 3; //!< [4:2] Status of ISRC1.
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_iscr1_0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_ISCR1_0 register
 */
//@{
#define HW_HDMI_FC_ISCR1_0_ADDR      (REGS_HDMI_BASE + 0x1092)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_ISCR1_0           (*(volatile hw_hdmi_fc_iscr1_0_t *) HW_HDMI_FC_ISCR1_0_ADDR)
#define HW_HDMI_FC_ISCR1_0_RD()      (HW_HDMI_FC_ISCR1_0.U)
#define HW_HDMI_FC_ISCR1_0_WR(v)     (HW_HDMI_FC_ISCR1_0.U = (v))
#define HW_HDMI_FC_ISCR1_0_SET(v)    (HW_HDMI_FC_ISCR1_0_WR(HW_HDMI_FC_ISCR1_0_RD() |  (v)))
#define HW_HDMI_FC_ISCR1_0_CLR(v)    (HW_HDMI_FC_ISCR1_0_WR(HW_HDMI_FC_ISCR1_0_RD() & ~(v)))
#define HW_HDMI_FC_ISCR1_0_TOG(v)    (HW_HDMI_FC_ISCR1_0_WR(HW_HDMI_FC_ISCR1_0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_ISCR1_0 bitfields
 */

/*! @name Register HDMI_FC_ISCR1_0, field ISRC_CONT[0] (RW)
 *
 * Indication of ISRC2.
 */
//@{
#define BP_HDMI_FC_ISCR1_0_ISRC_CONT      (0)      //!< Bit position for HDMI_FC_ISCR1_0_ISRC_CONT.
#define BM_HDMI_FC_ISCR1_0_ISRC_CONT      (0x00000001)  //!< Bit mask for HDMI_FC_ISCR1_0_ISRC_CONT.

//! @brief Get value of HDMI_FC_ISCR1_0_ISRC_CONT from a register value.
#define BG_HDMI_FC_ISCR1_0_ISRC_CONT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ISCR1_0_ISRC_CONT) >> BP_HDMI_FC_ISCR1_0_ISRC_CONT)

//! @brief Format value for bitfield HDMI_FC_ISCR1_0_ISRC_CONT.
#define BF_HDMI_FC_ISCR1_0_ISRC_CONT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ISCR1_0_ISRC_CONT) & BM_HDMI_FC_ISCR1_0_ISRC_CONT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISRC_CONT field to a new value.
#define BW_HDMI_FC_ISCR1_0_ISRC_CONT(v)   (HW_HDMI_FC_ISCR1_0_WR((HW_HDMI_FC_ISCR1_0_RD() & ~BM_HDMI_FC_ISCR1_0_ISRC_CONT) | BF_HDMI_FC_ISCR1_0_ISRC_CONT(v)))
#endif
//@}

/*! @name Register HDMI_FC_ISCR1_0, field ISRC_VALID[1] (RW)
 *
 * Valid of ISRC1.
 */
//@{
#define BP_HDMI_FC_ISCR1_0_ISRC_VALID      (1)      //!< Bit position for HDMI_FC_ISCR1_0_ISRC_VALID.
#define BM_HDMI_FC_ISCR1_0_ISRC_VALID      (0x00000002)  //!< Bit mask for HDMI_FC_ISCR1_0_ISRC_VALID.

//! @brief Get value of HDMI_FC_ISCR1_0_ISRC_VALID from a register value.
#define BG_HDMI_FC_ISCR1_0_ISRC_VALID(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ISCR1_0_ISRC_VALID) >> BP_HDMI_FC_ISCR1_0_ISRC_VALID)

//! @brief Format value for bitfield HDMI_FC_ISCR1_0_ISRC_VALID.
#define BF_HDMI_FC_ISCR1_0_ISRC_VALID(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ISCR1_0_ISRC_VALID) & BM_HDMI_FC_ISCR1_0_ISRC_VALID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISRC_VALID field to a new value.
#define BW_HDMI_FC_ISCR1_0_ISRC_VALID(v)   (HW_HDMI_FC_ISCR1_0_WR((HW_HDMI_FC_ISCR1_0_RD() & ~BM_HDMI_FC_ISCR1_0_ISRC_VALID) | BF_HDMI_FC_ISCR1_0_ISRC_VALID(v)))
#endif
//@}

/*! @name Register HDMI_FC_ISCR1_0, field ISRC_STATUS[4:2] (RW)
 *
 * Status of ISRC1.
 */
//@{
#define BP_HDMI_FC_ISCR1_0_ISRC_STATUS      (2)      //!< Bit position for HDMI_FC_ISCR1_0_ISRC_STATUS.
#define BM_HDMI_FC_ISCR1_0_ISRC_STATUS      (0x0000001c)  //!< Bit mask for HDMI_FC_ISCR1_0_ISRC_STATUS.

//! @brief Get value of HDMI_FC_ISCR1_0_ISRC_STATUS from a register value.
#define BG_HDMI_FC_ISCR1_0_ISRC_STATUS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ISCR1_0_ISRC_STATUS) >> BP_HDMI_FC_ISCR1_0_ISRC_STATUS)

//! @brief Format value for bitfield HDMI_FC_ISCR1_0_ISRC_STATUS.
#define BF_HDMI_FC_ISCR1_0_ISRC_STATUS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ISCR1_0_ISRC_STATUS) & BM_HDMI_FC_ISCR1_0_ISRC_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISRC_STATUS field to a new value.
#define BW_HDMI_FC_ISCR1_0_ISRC_STATUS(v)   (HW_HDMI_FC_ISCR1_0_WR((HW_HDMI_FC_ISCR1_0_RD() & ~BM_HDMI_FC_ISCR1_0_ISRC_STATUS) | BF_HDMI_FC_ISCR1_0_ISRC_STATUS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_ISCR1_1 - Frame Composer ISCR1 Packet Body Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_ISCR1_1 - Frame Composer ISCR1 Packet Body Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the ISRC1 packet: ISRC1 packet body Address Offset: 0x10A2
 * to 0x1093 Size: 8 bits Value after Reset: 0x00 Access: Read/Write For more information, see the
 * HDMI 1.4 specification.
 */
typedef union _hw_hdmi_fc_iscr1_1
{
    reg8_t U;
    struct _hw_hdmi_fc_iscr1_1_bitfields
    {
        unsigned char ISRC1 : 8; //!< [7:0] Configures the contents of the ISRC1 packet:
    } B;
} hw_hdmi_fc_iscr1_1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_ISCR1_1 register
 */
//@{
#define HW_HDMI_FC_ISCR1_1_ADDR      (REGS_HDMI_BASE + 0x1093)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_ISCR1_1           (*(volatile hw_hdmi_fc_iscr1_1_t *) HW_HDMI_FC_ISCR1_1_ADDR)
#define HW_HDMI_FC_ISCR1_1_RD()      (HW_HDMI_FC_ISCR1_1.U)
#define HW_HDMI_FC_ISCR1_1_WR(v)     (HW_HDMI_FC_ISCR1_1.U = (v))
#define HW_HDMI_FC_ISCR1_1_SET(v)    (HW_HDMI_FC_ISCR1_1_WR(HW_HDMI_FC_ISCR1_1_RD() |  (v)))
#define HW_HDMI_FC_ISCR1_1_CLR(v)    (HW_HDMI_FC_ISCR1_1_WR(HW_HDMI_FC_ISCR1_1_RD() & ~(v)))
#define HW_HDMI_FC_ISCR1_1_TOG(v)    (HW_HDMI_FC_ISCR1_1_WR(HW_HDMI_FC_ISCR1_1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_ISCR1_1 bitfields
 */

/*! @name Register HDMI_FC_ISCR1_1, field ISRC1[7:0] (RW)
 *
 * Configures the contents of the ISRC1 packet:
 */
//@{
#define BP_HDMI_FC_ISCR1_1_ISRC1      (0)      //!< Bit position for HDMI_FC_ISCR1_1_ISRC1.
#define BM_HDMI_FC_ISCR1_1_ISRC1      (0x000000ff)  //!< Bit mask for HDMI_FC_ISCR1_1_ISRC1.

//! @brief Get value of HDMI_FC_ISCR1_1_ISRC1 from a register value.
#define BG_HDMI_FC_ISCR1_1_ISRC1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ISCR1_1_ISRC1) >> BP_HDMI_FC_ISCR1_1_ISRC1)

//! @brief Format value for bitfield HDMI_FC_ISCR1_1_ISRC1.
#define BF_HDMI_FC_ISCR1_1_ISRC1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ISCR1_1_ISRC1) & BM_HDMI_FC_ISCR1_1_ISRC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISRC1 field to a new value.
#define BW_HDMI_FC_ISCR1_1_ISRC1(v)   (HW_HDMI_FC_ISCR1_1_WR((HW_HDMI_FC_ISCR1_1_RD() & ~BM_HDMI_FC_ISCR1_1_ISRC1) | BF_HDMI_FC_ISCR1_1_ISRC1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_ISCR2_0 - Frame Composer ISCR2 Packet Body Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_ISCR2_0 - Frame Composer ISCR2 Packet Body Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the ISRC2 packet: ISRC2 packet body Address Offset: 0x10B2
 * to 0x10A3 Size: 8 bits Value after Reset: 0x00 Access: Read/Write For more information, see the
 * HDMI 1.4 specification.
 */
typedef union _hw_hdmi_fc_iscr2_0
{
    reg8_t U;
    struct _hw_hdmi_fc_iscr2_0_bitfields
    {
        unsigned char ISRC2 : 8; //!< [7:0] Configures the contents of the ISRC1 packet:
    } B;
} hw_hdmi_fc_iscr2_0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_ISCR2_0 register
 */
//@{
#define HW_HDMI_FC_ISCR2_0_ADDR      (REGS_HDMI_BASE + 0x10a3)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_ISCR2_0           (*(volatile hw_hdmi_fc_iscr2_0_t *) HW_HDMI_FC_ISCR2_0_ADDR)
#define HW_HDMI_FC_ISCR2_0_RD()      (HW_HDMI_FC_ISCR2_0.U)
#define HW_HDMI_FC_ISCR2_0_WR(v)     (HW_HDMI_FC_ISCR2_0.U = (v))
#define HW_HDMI_FC_ISCR2_0_SET(v)    (HW_HDMI_FC_ISCR2_0_WR(HW_HDMI_FC_ISCR2_0_RD() |  (v)))
#define HW_HDMI_FC_ISCR2_0_CLR(v)    (HW_HDMI_FC_ISCR2_0_WR(HW_HDMI_FC_ISCR2_0_RD() & ~(v)))
#define HW_HDMI_FC_ISCR2_0_TOG(v)    (HW_HDMI_FC_ISCR2_0_WR(HW_HDMI_FC_ISCR2_0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_ISCR2_0 bitfields
 */

/*! @name Register HDMI_FC_ISCR2_0, field ISRC2[7:0] (RW)
 *
 * Configures the contents of the ISRC1 packet:
 */
//@{
#define BP_HDMI_FC_ISCR2_0_ISRC2      (0)      //!< Bit position for HDMI_FC_ISCR2_0_ISRC2.
#define BM_HDMI_FC_ISCR2_0_ISRC2      (0x000000ff)  //!< Bit mask for HDMI_FC_ISCR2_0_ISRC2.

//! @brief Get value of HDMI_FC_ISCR2_0_ISRC2 from a register value.
#define BG_HDMI_FC_ISCR2_0_ISRC2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_ISCR2_0_ISRC2) >> BP_HDMI_FC_ISCR2_0_ISRC2)

//! @brief Format value for bitfield HDMI_FC_ISCR2_0_ISRC2.
#define BF_HDMI_FC_ISCR2_0_ISRC2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_ISCR2_0_ISRC2) & BM_HDMI_FC_ISCR2_0_ISRC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISRC2 field to a new value.
#define BW_HDMI_FC_ISCR2_0_ISRC2(v)   (HW_HDMI_FC_ISCR2_0_WR((HW_HDMI_FC_ISCR2_0_RD() & ~BM_HDMI_FC_ISCR2_0_ISRC2) | BF_HDMI_FC_ISCR2_0_ISRC2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DATAUTO0 - Frame Composer Data Island Auto Packet Scheduling Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DATAUTO0 - Frame Composer Data Island Auto Packet Scheduling Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer RDRB(1)/Manual(0) data island packet insertion for SPD, VSD, ISRC2,
 * ISRC1 and ACP packets. On RDRB mode the described packet scheduling is controlled by registers
 * FC_DATAUTO1 and FC_DATAUTO2, while in Manual mode register FC_DATMAN requests to FC the insertion
 * of the requested packet.
 */
typedef union _hw_hdmi_fc_datauto0
{
    reg8_t U;
    struct _hw_hdmi_fc_datauto0_bitfields
    {
        unsigned char ACP_AUTO : 1; //!< [0] Enables ACP automatic packet scheduling
        unsigned char ISCR1_AUTO : 1; //!< [1] Enables ISRC1 automatic packet scheduling
        unsigned char ISCR2_AUTO : 1; //!< [2] Enables ISRC2 automatic packet scheduling
        unsigned char VSD_AUTO : 1; //!< [3] Enables VSD automatic packet scheduling
        unsigned char SPD_AUTO : 1; //!< [4] Enables SPD automatic packet scheduling
        unsigned char RESERVED0 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_datauto0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DATAUTO0 register
 */
//@{
#define HW_HDMI_FC_DATAUTO0_ADDR      (REGS_HDMI_BASE + 0x10b3)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DATAUTO0           (*(volatile hw_hdmi_fc_datauto0_t *) HW_HDMI_FC_DATAUTO0_ADDR)
#define HW_HDMI_FC_DATAUTO0_RD()      (HW_HDMI_FC_DATAUTO0.U)
#define HW_HDMI_FC_DATAUTO0_WR(v)     (HW_HDMI_FC_DATAUTO0.U = (v))
#define HW_HDMI_FC_DATAUTO0_SET(v)    (HW_HDMI_FC_DATAUTO0_WR(HW_HDMI_FC_DATAUTO0_RD() |  (v)))
#define HW_HDMI_FC_DATAUTO0_CLR(v)    (HW_HDMI_FC_DATAUTO0_WR(HW_HDMI_FC_DATAUTO0_RD() & ~(v)))
#define HW_HDMI_FC_DATAUTO0_TOG(v)    (HW_HDMI_FC_DATAUTO0_WR(HW_HDMI_FC_DATAUTO0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DATAUTO0 bitfields
 */

/*! @name Register HDMI_FC_DATAUTO0, field ACP_AUTO[0] (RW)
 *
 * Enables ACP automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO0_ACP_AUTO      (0)      //!< Bit position for HDMI_FC_DATAUTO0_ACP_AUTO.
#define BM_HDMI_FC_DATAUTO0_ACP_AUTO      (0x00000001)  //!< Bit mask for HDMI_FC_DATAUTO0_ACP_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO0_ACP_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO0_ACP_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO0_ACP_AUTO) >> BP_HDMI_FC_DATAUTO0_ACP_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO0_ACP_AUTO.
#define BF_HDMI_FC_DATAUTO0_ACP_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO0_ACP_AUTO) & BM_HDMI_FC_DATAUTO0_ACP_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACP_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO0_ACP_AUTO(v)   (HW_HDMI_FC_DATAUTO0_WR((HW_HDMI_FC_DATAUTO0_RD() & ~BM_HDMI_FC_DATAUTO0_ACP_AUTO) | BF_HDMI_FC_DATAUTO0_ACP_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO0, field ISCR1_AUTO[1] (RW)
 *
 * Enables ISRC1 automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO0_ISCR1_AUTO      (1)      //!< Bit position for HDMI_FC_DATAUTO0_ISCR1_AUTO.
#define BM_HDMI_FC_DATAUTO0_ISCR1_AUTO      (0x00000002)  //!< Bit mask for HDMI_FC_DATAUTO0_ISCR1_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO0_ISCR1_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO0_ISCR1_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO0_ISCR1_AUTO) >> BP_HDMI_FC_DATAUTO0_ISCR1_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO0_ISCR1_AUTO.
#define BF_HDMI_FC_DATAUTO0_ISCR1_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO0_ISCR1_AUTO) & BM_HDMI_FC_DATAUTO0_ISCR1_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR1_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO0_ISCR1_AUTO(v)   (HW_HDMI_FC_DATAUTO0_WR((HW_HDMI_FC_DATAUTO0_RD() & ~BM_HDMI_FC_DATAUTO0_ISCR1_AUTO) | BF_HDMI_FC_DATAUTO0_ISCR1_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO0, field ISCR2_AUTO[2] (RW)
 *
 * Enables ISRC2 automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO0_ISCR2_AUTO      (2)      //!< Bit position for HDMI_FC_DATAUTO0_ISCR2_AUTO.
#define BM_HDMI_FC_DATAUTO0_ISCR2_AUTO      (0x00000004)  //!< Bit mask for HDMI_FC_DATAUTO0_ISCR2_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO0_ISCR2_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO0_ISCR2_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO0_ISCR2_AUTO) >> BP_HDMI_FC_DATAUTO0_ISCR2_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO0_ISCR2_AUTO.
#define BF_HDMI_FC_DATAUTO0_ISCR2_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO0_ISCR2_AUTO) & BM_HDMI_FC_DATAUTO0_ISCR2_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR2_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO0_ISCR2_AUTO(v)   (HW_HDMI_FC_DATAUTO0_WR((HW_HDMI_FC_DATAUTO0_RD() & ~BM_HDMI_FC_DATAUTO0_ISCR2_AUTO) | BF_HDMI_FC_DATAUTO0_ISCR2_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO0, field VSD_AUTO[3] (RW)
 *
 * Enables VSD automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO0_VSD_AUTO      (3)      //!< Bit position for HDMI_FC_DATAUTO0_VSD_AUTO.
#define BM_HDMI_FC_DATAUTO0_VSD_AUTO      (0x00000008)  //!< Bit mask for HDMI_FC_DATAUTO0_VSD_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO0_VSD_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO0_VSD_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO0_VSD_AUTO) >> BP_HDMI_FC_DATAUTO0_VSD_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO0_VSD_AUTO.
#define BF_HDMI_FC_DATAUTO0_VSD_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO0_VSD_AUTO) & BM_HDMI_FC_DATAUTO0_VSD_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSD_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO0_VSD_AUTO(v)   (HW_HDMI_FC_DATAUTO0_WR((HW_HDMI_FC_DATAUTO0_RD() & ~BM_HDMI_FC_DATAUTO0_VSD_AUTO) | BF_HDMI_FC_DATAUTO0_VSD_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO0, field SPD_AUTO[4] (RW)
 *
 * Enables SPD automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO0_SPD_AUTO      (4)      //!< Bit position for HDMI_FC_DATAUTO0_SPD_AUTO.
#define BM_HDMI_FC_DATAUTO0_SPD_AUTO      (0x00000010)  //!< Bit mask for HDMI_FC_DATAUTO0_SPD_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO0_SPD_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO0_SPD_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO0_SPD_AUTO) >> BP_HDMI_FC_DATAUTO0_SPD_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO0_SPD_AUTO.
#define BF_HDMI_FC_DATAUTO0_SPD_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO0_SPD_AUTO) & BM_HDMI_FC_DATAUTO0_SPD_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPD_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO0_SPD_AUTO(v)   (HW_HDMI_FC_DATAUTO0_WR((HW_HDMI_FC_DATAUTO0_RD() & ~BM_HDMI_FC_DATAUTO0_SPD_AUTO) | BF_HDMI_FC_DATAUTO0_SPD_AUTO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DATAUTO1 - Frame Composer Data Island Auto Packet Scheduling Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DATAUTO1 - Frame Composer Data Island Auto Packet Scheduling Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB frame interpolation for SPD, VSD, ISRC2, ISRC1 and ACP
 * packet insertion on data island when FC is on RDRB mode for the listed packets.
 */
typedef union _hw_hdmi_fc_datauto1
{
    reg8_t U;
    struct _hw_hdmi_fc_datauto1_bitfields
    {
        unsigned char AUTO_FRAME_INTERPOLATION : 4; //!< [3:0] Packet frame interpolation, for automatic packet scheduling
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_datauto1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DATAUTO1 register
 */
//@{
#define HW_HDMI_FC_DATAUTO1_ADDR      (REGS_HDMI_BASE + 0x10b4)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DATAUTO1           (*(volatile hw_hdmi_fc_datauto1_t *) HW_HDMI_FC_DATAUTO1_ADDR)
#define HW_HDMI_FC_DATAUTO1_RD()      (HW_HDMI_FC_DATAUTO1.U)
#define HW_HDMI_FC_DATAUTO1_WR(v)     (HW_HDMI_FC_DATAUTO1.U = (v))
#define HW_HDMI_FC_DATAUTO1_SET(v)    (HW_HDMI_FC_DATAUTO1_WR(HW_HDMI_FC_DATAUTO1_RD() |  (v)))
#define HW_HDMI_FC_DATAUTO1_CLR(v)    (HW_HDMI_FC_DATAUTO1_WR(HW_HDMI_FC_DATAUTO1_RD() & ~(v)))
#define HW_HDMI_FC_DATAUTO1_TOG(v)    (HW_HDMI_FC_DATAUTO1_WR(HW_HDMI_FC_DATAUTO1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DATAUTO1 bitfields
 */

/*! @name Register HDMI_FC_DATAUTO1, field AUTO_FRAME_INTERPOLATION[3:0] (RW)
 *
 * Packet frame interpolation, for automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION      (0)      //!< Bit position for HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION.
#define BM_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION      (0x0000000f)  //!< Bit mask for HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION.

//! @brief Get value of HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION from a register value.
#define BG_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION) >> BP_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION)

//! @brief Format value for bitfield HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION.
#define BF_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION) & BM_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUTO_FRAME_INTERPOLATION field to a new value.
#define BW_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION(v)   (HW_HDMI_FC_DATAUTO1_WR((HW_HDMI_FC_DATAUTO1_RD() & ~BM_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION) | BF_HDMI_FC_DATAUTO1_AUTO_FRAME_INTERPOLATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DATAUTO2 - Frame Composer Data Island Auto Packet Scheduling Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DATAUTO2 - Frame Composer Data Island Auto Packet Scheduling Register 2 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB line interpolation and number of packets in frame for
 * SPD, VSD, ISRC2, ISRC1 and ACP packet insertion on data island when FC is on RDRB mode for the
 * listed packets.
 */
typedef union _hw_hdmi_fc_datauto2
{
    reg8_t U;
    struct _hw_hdmi_fc_datauto2_bitfields
    {
        unsigned char AUTO_LINE_SPACING : 4; //!< [3:0] Packets line spacing, for automatic packet scheduling
        unsigned char AUTO_FRAME_PACKETS : 4; //!< [7:4] Packets per frame, for automatic packet scheduling
    } B;
} hw_hdmi_fc_datauto2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DATAUTO2 register
 */
//@{
#define HW_HDMI_FC_DATAUTO2_ADDR      (REGS_HDMI_BASE + 0x10b5)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DATAUTO2           (*(volatile hw_hdmi_fc_datauto2_t *) HW_HDMI_FC_DATAUTO2_ADDR)
#define HW_HDMI_FC_DATAUTO2_RD()      (HW_HDMI_FC_DATAUTO2.U)
#define HW_HDMI_FC_DATAUTO2_WR(v)     (HW_HDMI_FC_DATAUTO2.U = (v))
#define HW_HDMI_FC_DATAUTO2_SET(v)    (HW_HDMI_FC_DATAUTO2_WR(HW_HDMI_FC_DATAUTO2_RD() |  (v)))
#define HW_HDMI_FC_DATAUTO2_CLR(v)    (HW_HDMI_FC_DATAUTO2_WR(HW_HDMI_FC_DATAUTO2_RD() & ~(v)))
#define HW_HDMI_FC_DATAUTO2_TOG(v)    (HW_HDMI_FC_DATAUTO2_WR(HW_HDMI_FC_DATAUTO2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DATAUTO2 bitfields
 */

/*! @name Register HDMI_FC_DATAUTO2, field AUTO_LINE_SPACING[3:0] (RW)
 *
 * Packets line spacing, for automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING      (0)      //!< Bit position for HDMI_FC_DATAUTO2_AUTO_LINE_SPACING.
#define BM_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_DATAUTO2_AUTO_LINE_SPACING.

//! @brief Get value of HDMI_FC_DATAUTO2_AUTO_LINE_SPACING from a register value.
#define BG_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING) >> BP_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING)

//! @brief Format value for bitfield HDMI_FC_DATAUTO2_AUTO_LINE_SPACING.
#define BF_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING) & BM_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUTO_LINE_SPACING field to a new value.
#define BW_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING(v)   (HW_HDMI_FC_DATAUTO2_WR((HW_HDMI_FC_DATAUTO2_RD() & ~BM_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING) | BF_HDMI_FC_DATAUTO2_AUTO_LINE_SPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO2, field AUTO_FRAME_PACKETS[7:4] (RW)
 *
 * Packets per frame, for automatic packet scheduling
 */
//@{
#define BP_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS      (4)      //!< Bit position for HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS.
#define BM_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS      (0x000000f0)  //!< Bit mask for HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS.

//! @brief Get value of HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS from a register value.
#define BG_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS) >> BP_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS)

//! @brief Format value for bitfield HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS.
#define BF_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS) & BM_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUTO_FRAME_PACKETS field to a new value.
#define BW_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS(v)   (HW_HDMI_FC_DATAUTO2_WR((HW_HDMI_FC_DATAUTO2_RD() & ~BM_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS) | BF_HDMI_FC_DATAUTO2_AUTO_FRAME_PACKETS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DATMAN - Frame Composer Data Island Manual Packet Request Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DATMAN - Frame Composer Data Island Manual Packet Request Register (WO)
 *
 * Reset value: 0x00
 *
 * Requests to the Frame Composer the data island packet insertion for NULL, SPD, VSD, ISRC2, ISRC1
 * and ACP packets when FC_DATAUTO0 bit is in manual mode for the packet requested.
 */
typedef union _hw_hdmi_fc_datman
{
    reg8_t U;
    struct _hw_hdmi_fc_datman_bitfields
    {
        unsigned char ACP_TX : 1; //!< [0] ACP packet
        unsigned char ISR1_TX : 1; //!< [1] ISRC1 packet
        unsigned char ISCR2_TX : 1; //!< [2] ISRC2 packet
        unsigned char VSD_TX : 1; //!< [3] VSD packet
        unsigned char SPD_TX : 1; //!< [4] SPD packet
        unsigned char NULL_TX : 1; //!< [5] Null packet
        unsigned char RESERVED0 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_fc_datman_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DATMAN register
 */
//@{
#define HW_HDMI_FC_DATMAN_ADDR      (REGS_HDMI_BASE + 0x10b6)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DATMAN           (*(volatile hw_hdmi_fc_datman_t *) HW_HDMI_FC_DATMAN_ADDR)
#define HW_HDMI_FC_DATMAN_WR(v)     (HW_HDMI_FC_DATMAN.U = (v))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DATMAN bitfields
 */

/*! @name Register HDMI_FC_DATMAN, field ACP_TX[0] (WO)
 *
 * ACP packet
 */
//@{
#define BP_HDMI_FC_DATMAN_ACP_TX      (0)      //!< Bit position for HDMI_FC_DATMAN_ACP_TX.
#define BM_HDMI_FC_DATMAN_ACP_TX      (0x00000001)  //!< Bit mask for HDMI_FC_DATMAN_ACP_TX.

//! @brief Get value of HDMI_FC_DATMAN_ACP_TX from a register value.
#define BG_HDMI_FC_DATMAN_ACP_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_ACP_TX) >> BP_HDMI_FC_DATMAN_ACP_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_ACP_TX.
#define BF_HDMI_FC_DATMAN_ACP_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_ACP_TX) & BM_HDMI_FC_DATMAN_ACP_TX)
//@}

/*! @name Register HDMI_FC_DATMAN, field ISR1_TX[1] (WO)
 *
 * ISRC1 packet
 */
//@{
#define BP_HDMI_FC_DATMAN_ISR1_TX      (1)      //!< Bit position for HDMI_FC_DATMAN_ISR1_TX.
#define BM_HDMI_FC_DATMAN_ISR1_TX      (0x00000002)  //!< Bit mask for HDMI_FC_DATMAN_ISR1_TX.

//! @brief Get value of HDMI_FC_DATMAN_ISR1_TX from a register value.
#define BG_HDMI_FC_DATMAN_ISR1_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_ISR1_TX) >> BP_HDMI_FC_DATMAN_ISR1_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_ISR1_TX.
#define BF_HDMI_FC_DATMAN_ISR1_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_ISR1_TX) & BM_HDMI_FC_DATMAN_ISR1_TX)
//@}

/*! @name Register HDMI_FC_DATMAN, field ISCR2_TX[2] (WO)
 *
 * ISRC2 packet
 */
//@{
#define BP_HDMI_FC_DATMAN_ISCR2_TX      (2)      //!< Bit position for HDMI_FC_DATMAN_ISCR2_TX.
#define BM_HDMI_FC_DATMAN_ISCR2_TX      (0x00000004)  //!< Bit mask for HDMI_FC_DATMAN_ISCR2_TX.

//! @brief Get value of HDMI_FC_DATMAN_ISCR2_TX from a register value.
#define BG_HDMI_FC_DATMAN_ISCR2_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_ISCR2_TX) >> BP_HDMI_FC_DATMAN_ISCR2_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_ISCR2_TX.
#define BF_HDMI_FC_DATMAN_ISCR2_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_ISCR2_TX) & BM_HDMI_FC_DATMAN_ISCR2_TX)
//@}

/*! @name Register HDMI_FC_DATMAN, field VSD_TX[3] (WO)
 *
 * VSD packet
 */
//@{
#define BP_HDMI_FC_DATMAN_VSD_TX      (3)      //!< Bit position for HDMI_FC_DATMAN_VSD_TX.
#define BM_HDMI_FC_DATMAN_VSD_TX      (0x00000008)  //!< Bit mask for HDMI_FC_DATMAN_VSD_TX.

//! @brief Get value of HDMI_FC_DATMAN_VSD_TX from a register value.
#define BG_HDMI_FC_DATMAN_VSD_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_VSD_TX) >> BP_HDMI_FC_DATMAN_VSD_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_VSD_TX.
#define BF_HDMI_FC_DATMAN_VSD_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_VSD_TX) & BM_HDMI_FC_DATMAN_VSD_TX)
//@}

/*! @name Register HDMI_FC_DATMAN, field SPD_TX[4] (WO)
 *
 * SPD packet
 */
//@{
#define BP_HDMI_FC_DATMAN_SPD_TX      (4)      //!< Bit position for HDMI_FC_DATMAN_SPD_TX.
#define BM_HDMI_FC_DATMAN_SPD_TX      (0x00000010)  //!< Bit mask for HDMI_FC_DATMAN_SPD_TX.

//! @brief Get value of HDMI_FC_DATMAN_SPD_TX from a register value.
#define BG_HDMI_FC_DATMAN_SPD_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_SPD_TX) >> BP_HDMI_FC_DATMAN_SPD_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_SPD_TX.
#define BF_HDMI_FC_DATMAN_SPD_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_SPD_TX) & BM_HDMI_FC_DATMAN_SPD_TX)
//@}

/*! @name Register HDMI_FC_DATMAN, field NULL_TX[5] (WO)
 *
 * Null packet
 */
//@{
#define BP_HDMI_FC_DATMAN_NULL_TX      (5)      //!< Bit position for HDMI_FC_DATMAN_NULL_TX.
#define BM_HDMI_FC_DATMAN_NULL_TX      (0x00000020)  //!< Bit mask for HDMI_FC_DATMAN_NULL_TX.

//! @brief Get value of HDMI_FC_DATMAN_NULL_TX from a register value.
#define BG_HDMI_FC_DATMAN_NULL_TX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATMAN_NULL_TX) >> BP_HDMI_FC_DATMAN_NULL_TX)

//! @brief Format value for bitfield HDMI_FC_DATMAN_NULL_TX.
#define BF_HDMI_FC_DATMAN_NULL_TX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATMAN_NULL_TX) & BM_HDMI_FC_DATMAN_NULL_TX)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DATAUTO3 - Frame Composer Data Island Auto Packet Scheduling Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DATAUTO3 - Frame Composer Data Island Auto Packet Scheduling Register 3 (RW)
 *
 * Reset value: 0x0f
 *
 * Configures the Frame Composer Automatic(1)/RDRB(0) data island packet insertion for AVI, GCP,
 * AUDI and ACR packets. In Automatic mode, the packet will be inserted on Vblanking when first line
 * with active Vsync appears.
 */
typedef union _hw_hdmi_fc_datauto3
{
    reg8_t U;
    struct _hw_hdmi_fc_datauto3_bitfields
    {
        unsigned char ACR_AUTO : 1; //!< [0] Enable ACR packet insertion
        unsigned char AUDI_AUTO : 1; //!< [1] Enable AUDI packet insertion
        unsigned char GCP_AUTO : 1; //!< [2] Enable GCP packet insertion
        unsigned char AVI_AUTO : 1; //!< [3] Enable AVI packet insertion
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_datauto3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DATAUTO3 register
 */
//@{
#define HW_HDMI_FC_DATAUTO3_ADDR      (REGS_HDMI_BASE + 0x10b7)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DATAUTO3           (*(volatile hw_hdmi_fc_datauto3_t *) HW_HDMI_FC_DATAUTO3_ADDR)
#define HW_HDMI_FC_DATAUTO3_RD()      (HW_HDMI_FC_DATAUTO3.U)
#define HW_HDMI_FC_DATAUTO3_WR(v)     (HW_HDMI_FC_DATAUTO3.U = (v))
#define HW_HDMI_FC_DATAUTO3_SET(v)    (HW_HDMI_FC_DATAUTO3_WR(HW_HDMI_FC_DATAUTO3_RD() |  (v)))
#define HW_HDMI_FC_DATAUTO3_CLR(v)    (HW_HDMI_FC_DATAUTO3_WR(HW_HDMI_FC_DATAUTO3_RD() & ~(v)))
#define HW_HDMI_FC_DATAUTO3_TOG(v)    (HW_HDMI_FC_DATAUTO3_WR(HW_HDMI_FC_DATAUTO3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DATAUTO3 bitfields
 */

/*! @name Register HDMI_FC_DATAUTO3, field ACR_AUTO[0] (RW)
 *
 * Enable ACR packet insertion
 */
//@{
#define BP_HDMI_FC_DATAUTO3_ACR_AUTO      (0)      //!< Bit position for HDMI_FC_DATAUTO3_ACR_AUTO.
#define BM_HDMI_FC_DATAUTO3_ACR_AUTO      (0x00000001)  //!< Bit mask for HDMI_FC_DATAUTO3_ACR_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO3_ACR_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO3_ACR_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO3_ACR_AUTO) >> BP_HDMI_FC_DATAUTO3_ACR_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO3_ACR_AUTO.
#define BF_HDMI_FC_DATAUTO3_ACR_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO3_ACR_AUTO) & BM_HDMI_FC_DATAUTO3_ACR_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACR_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO3_ACR_AUTO(v)   (HW_HDMI_FC_DATAUTO3_WR((HW_HDMI_FC_DATAUTO3_RD() & ~BM_HDMI_FC_DATAUTO3_ACR_AUTO) | BF_HDMI_FC_DATAUTO3_ACR_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO3, field AUDI_AUTO[1] (RW)
 *
 * Enable AUDI packet insertion
 */
//@{
#define BP_HDMI_FC_DATAUTO3_AUDI_AUTO      (1)      //!< Bit position for HDMI_FC_DATAUTO3_AUDI_AUTO.
#define BM_HDMI_FC_DATAUTO3_AUDI_AUTO      (0x00000002)  //!< Bit mask for HDMI_FC_DATAUTO3_AUDI_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO3_AUDI_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO3_AUDI_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO3_AUDI_AUTO) >> BP_HDMI_FC_DATAUTO3_AUDI_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO3_AUDI_AUTO.
#define BF_HDMI_FC_DATAUTO3_AUDI_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO3_AUDI_AUTO) & BM_HDMI_FC_DATAUTO3_AUDI_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDI_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO3_AUDI_AUTO(v)   (HW_HDMI_FC_DATAUTO3_WR((HW_HDMI_FC_DATAUTO3_RD() & ~BM_HDMI_FC_DATAUTO3_AUDI_AUTO) | BF_HDMI_FC_DATAUTO3_AUDI_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO3, field GCP_AUTO[2] (RW)
 *
 * Enable GCP packet insertion
 */
//@{
#define BP_HDMI_FC_DATAUTO3_GCP_AUTO      (2)      //!< Bit position for HDMI_FC_DATAUTO3_GCP_AUTO.
#define BM_HDMI_FC_DATAUTO3_GCP_AUTO      (0x00000004)  //!< Bit mask for HDMI_FC_DATAUTO3_GCP_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO3_GCP_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO3_GCP_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO3_GCP_AUTO) >> BP_HDMI_FC_DATAUTO3_GCP_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO3_GCP_AUTO.
#define BF_HDMI_FC_DATAUTO3_GCP_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO3_GCP_AUTO) & BM_HDMI_FC_DATAUTO3_GCP_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCP_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO3_GCP_AUTO(v)   (HW_HDMI_FC_DATAUTO3_WR((HW_HDMI_FC_DATAUTO3_RD() & ~BM_HDMI_FC_DATAUTO3_GCP_AUTO) | BF_HDMI_FC_DATAUTO3_GCP_AUTO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DATAUTO3, field AVI_AUTO[3] (RW)
 *
 * Enable AVI packet insertion
 */
//@{
#define BP_HDMI_FC_DATAUTO3_AVI_AUTO      (3)      //!< Bit position for HDMI_FC_DATAUTO3_AVI_AUTO.
#define BM_HDMI_FC_DATAUTO3_AVI_AUTO      (0x00000008)  //!< Bit mask for HDMI_FC_DATAUTO3_AVI_AUTO.

//! @brief Get value of HDMI_FC_DATAUTO3_AVI_AUTO from a register value.
#define BG_HDMI_FC_DATAUTO3_AVI_AUTO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DATAUTO3_AVI_AUTO) >> BP_HDMI_FC_DATAUTO3_AVI_AUTO)

//! @brief Format value for bitfield HDMI_FC_DATAUTO3_AVI_AUTO.
#define BF_HDMI_FC_DATAUTO3_AVI_AUTO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DATAUTO3_AVI_AUTO) & BM_HDMI_FC_DATAUTO3_AVI_AUTO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVI_AUTO field to a new value.
#define BW_HDMI_FC_DATAUTO3_AVI_AUTO(v)   (HW_HDMI_FC_DATAUTO3_WR((HW_HDMI_FC_DATAUTO3_RD() & ~BM_HDMI_FC_DATAUTO3_AVI_AUTO) | BF_HDMI_FC_DATAUTO3_AVI_AUTO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB0 - Frame Composer Round Robin ACR Packet Insertion Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB0 - Frame Composer Round Robin ACR Packet Insertion Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB frame interpolation for ACR packet insertion on data
 * island when FC is on RDRB mode for this packet.
 */
typedef union _hw_hdmi_fc_rdrb0
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb0_bitfields
    {
        unsigned char ACRFRAMEINTERPOLATION : 4; //!< [3:0] ACR frame interpolation
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_rdrb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB0 register
 */
//@{
#define HW_HDMI_FC_RDRB0_ADDR      (REGS_HDMI_BASE + 0x10b8)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB0           (*(volatile hw_hdmi_fc_rdrb0_t *) HW_HDMI_FC_RDRB0_ADDR)
#define HW_HDMI_FC_RDRB0_RD()      (HW_HDMI_FC_RDRB0.U)
#define HW_HDMI_FC_RDRB0_WR(v)     (HW_HDMI_FC_RDRB0.U = (v))
#define HW_HDMI_FC_RDRB0_SET(v)    (HW_HDMI_FC_RDRB0_WR(HW_HDMI_FC_RDRB0_RD() |  (v)))
#define HW_HDMI_FC_RDRB0_CLR(v)    (HW_HDMI_FC_RDRB0_WR(HW_HDMI_FC_RDRB0_RD() & ~(v)))
#define HW_HDMI_FC_RDRB0_TOG(v)    (HW_HDMI_FC_RDRB0_WR(HW_HDMI_FC_RDRB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB0 bitfields
 */

/*! @name Register HDMI_FC_RDRB0, field ACRFRAMEINTERPOLATION[3:0] (RW)
 *
 * ACR frame interpolation
 */
//@{
#define BP_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION      (0)      //!< Bit position for HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION.
#define BM_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION.

//! @brief Get value of HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION from a register value.
#define BG_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION) >> BP_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION)

//! @brief Format value for bitfield HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION.
#define BF_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION) & BM_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACRFRAMEINTERPOLATION field to a new value.
#define BW_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION(v)   (HW_HDMI_FC_RDRB0_WR((HW_HDMI_FC_RDRB0_RD() & ~BM_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION) | BF_HDMI_FC_RDRB0_ACRFRAMEINTERPOLATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB1 - Frame Composer Round Robin ACR Packet Insertion Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB1 - Frame Composer Round Robin ACR Packet Insertion Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB line interpolation and number of packets in frame for the
 * ACR packet insertion on data island when FC is on RDRB mode this packet.
 */
typedef union _hw_hdmi_fc_rdrb1
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb1_bitfields
    {
        unsigned char ACRPACKETLINESPACING : 4; //!< [3:0] ACR packet line spacing
        unsigned char ACRPACKETSINFRAME : 4; //!< [7:4] ACR packets in frame
    } B;
} hw_hdmi_fc_rdrb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB1 register
 */
//@{
#define HW_HDMI_FC_RDRB1_ADDR      (REGS_HDMI_BASE + 0x10b9)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB1           (*(volatile hw_hdmi_fc_rdrb1_t *) HW_HDMI_FC_RDRB1_ADDR)
#define HW_HDMI_FC_RDRB1_RD()      (HW_HDMI_FC_RDRB1.U)
#define HW_HDMI_FC_RDRB1_WR(v)     (HW_HDMI_FC_RDRB1.U = (v))
#define HW_HDMI_FC_RDRB1_SET(v)    (HW_HDMI_FC_RDRB1_WR(HW_HDMI_FC_RDRB1_RD() |  (v)))
#define HW_HDMI_FC_RDRB1_CLR(v)    (HW_HDMI_FC_RDRB1_WR(HW_HDMI_FC_RDRB1_RD() & ~(v)))
#define HW_HDMI_FC_RDRB1_TOG(v)    (HW_HDMI_FC_RDRB1_WR(HW_HDMI_FC_RDRB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB1 bitfields
 */

/*! @name Register HDMI_FC_RDRB1, field ACRPACKETLINESPACING[3:0] (RW)
 *
 * ACR packet line spacing
 */
//@{
#define BP_HDMI_FC_RDRB1_ACRPACKETLINESPACING      (0)      //!< Bit position for HDMI_FC_RDRB1_ACRPACKETLINESPACING.
#define BM_HDMI_FC_RDRB1_ACRPACKETLINESPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB1_ACRPACKETLINESPACING.

//! @brief Get value of HDMI_FC_RDRB1_ACRPACKETLINESPACING from a register value.
#define BG_HDMI_FC_RDRB1_ACRPACKETLINESPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB1_ACRPACKETLINESPACING) >> BP_HDMI_FC_RDRB1_ACRPACKETLINESPACING)

//! @brief Format value for bitfield HDMI_FC_RDRB1_ACRPACKETLINESPACING.
#define BF_HDMI_FC_RDRB1_ACRPACKETLINESPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB1_ACRPACKETLINESPACING) & BM_HDMI_FC_RDRB1_ACRPACKETLINESPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACRPACKETLINESPACING field to a new value.
#define BW_HDMI_FC_RDRB1_ACRPACKETLINESPACING(v)   (HW_HDMI_FC_RDRB1_WR((HW_HDMI_FC_RDRB1_RD() & ~BM_HDMI_FC_RDRB1_ACRPACKETLINESPACING) | BF_HDMI_FC_RDRB1_ACRPACKETLINESPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_RDRB1, field ACRPACKETSINFRAME[7:4] (RW)
 *
 * ACR packets in frame
 */
//@{
#define BP_HDMI_FC_RDRB1_ACRPACKETSINFRAME      (4)      //!< Bit position for HDMI_FC_RDRB1_ACRPACKETSINFRAME.
#define BM_HDMI_FC_RDRB1_ACRPACKETSINFRAME      (0x000000f0)  //!< Bit mask for HDMI_FC_RDRB1_ACRPACKETSINFRAME.

//! @brief Get value of HDMI_FC_RDRB1_ACRPACKETSINFRAME from a register value.
#define BG_HDMI_FC_RDRB1_ACRPACKETSINFRAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB1_ACRPACKETSINFRAME) >> BP_HDMI_FC_RDRB1_ACRPACKETSINFRAME)

//! @brief Format value for bitfield HDMI_FC_RDRB1_ACRPACKETSINFRAME.
#define BF_HDMI_FC_RDRB1_ACRPACKETSINFRAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB1_ACRPACKETSINFRAME) & BM_HDMI_FC_RDRB1_ACRPACKETSINFRAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACRPACKETSINFRAME field to a new value.
#define BW_HDMI_FC_RDRB1_ACRPACKETSINFRAME(v)   (HW_HDMI_FC_RDRB1_WR((HW_HDMI_FC_RDRB1_RD() & ~BM_HDMI_FC_RDRB1_ACRPACKETSINFRAME) | BF_HDMI_FC_RDRB1_ACRPACKETSINFRAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB2 - Frame Composer Round Robin ACR Packet Insertion Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB2 - Frame Composer Round Robin ACR Packet Insertion Register 2 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB frame interpolation for AUDI packet insertion on data
 * island when FC is on RDRB mode for this packet.
 */
typedef union _hw_hdmi_fc_rdrb2
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb2_bitfields
    {
        unsigned char AUDIFRAMEINTERPOLATION : 4; //!< [3:0] Audio frame interpolation
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_rdrb2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB2 register
 */
//@{
#define HW_HDMI_FC_RDRB2_ADDR      (REGS_HDMI_BASE + 0x10ba)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB2           (*(volatile hw_hdmi_fc_rdrb2_t *) HW_HDMI_FC_RDRB2_ADDR)
#define HW_HDMI_FC_RDRB2_RD()      (HW_HDMI_FC_RDRB2.U)
#define HW_HDMI_FC_RDRB2_WR(v)     (HW_HDMI_FC_RDRB2.U = (v))
#define HW_HDMI_FC_RDRB2_SET(v)    (HW_HDMI_FC_RDRB2_WR(HW_HDMI_FC_RDRB2_RD() |  (v)))
#define HW_HDMI_FC_RDRB2_CLR(v)    (HW_HDMI_FC_RDRB2_WR(HW_HDMI_FC_RDRB2_RD() & ~(v)))
#define HW_HDMI_FC_RDRB2_TOG(v)    (HW_HDMI_FC_RDRB2_WR(HW_HDMI_FC_RDRB2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB2 bitfields
 */

/*! @name Register HDMI_FC_RDRB2, field AUDIFRAMEINTERPOLATION[3:0] (RW)
 *
 * Audio frame interpolation
 */
//@{
#define BP_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION      (0)      //!< Bit position for HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION.
#define BM_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION.

//! @brief Get value of HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION from a register value.
#define BG_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION) >> BP_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION)

//! @brief Format value for bitfield HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION.
#define BF_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION) & BM_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDIFRAMEINTERPOLATION field to a new value.
#define BW_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION(v)   (HW_HDMI_FC_RDRB2_WR((HW_HDMI_FC_RDRB2_RD() & ~BM_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION) | BF_HDMI_FC_RDRB2_AUDIFRAMEINTERPOLATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB3 - Frame Composer Round Robin ACR Packet Insertion Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB3 - Frame Composer Round Robin ACR Packet Insertion Register 3 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB line interpolation and number of packets in frame for the
 * AUDI packet insertion on data island when FC is on RDRB mode this packet.
 */
typedef union _hw_hdmi_fc_rdrb3
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb3_bitfields
    {
        unsigned char AUDIPACKETLINESPACING : 4; //!< [3:0] Audio packets line spacing
        unsigned char AUDIPACKETSINFRAME : 4; //!< [7:4] Audio packets per frame
    } B;
} hw_hdmi_fc_rdrb3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB3 register
 */
//@{
#define HW_HDMI_FC_RDRB3_ADDR      (REGS_HDMI_BASE + 0x10bb)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB3           (*(volatile hw_hdmi_fc_rdrb3_t *) HW_HDMI_FC_RDRB3_ADDR)
#define HW_HDMI_FC_RDRB3_RD()      (HW_HDMI_FC_RDRB3.U)
#define HW_HDMI_FC_RDRB3_WR(v)     (HW_HDMI_FC_RDRB3.U = (v))
#define HW_HDMI_FC_RDRB3_SET(v)    (HW_HDMI_FC_RDRB3_WR(HW_HDMI_FC_RDRB3_RD() |  (v)))
#define HW_HDMI_FC_RDRB3_CLR(v)    (HW_HDMI_FC_RDRB3_WR(HW_HDMI_FC_RDRB3_RD() & ~(v)))
#define HW_HDMI_FC_RDRB3_TOG(v)    (HW_HDMI_FC_RDRB3_WR(HW_HDMI_FC_RDRB3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB3 bitfields
 */

/*! @name Register HDMI_FC_RDRB3, field AUDIPACKETLINESPACING[3:0] (RW)
 *
 * Audio packets line spacing
 */
//@{
#define BP_HDMI_FC_RDRB3_AUDIPACKETLINESPACING      (0)      //!< Bit position for HDMI_FC_RDRB3_AUDIPACKETLINESPACING.
#define BM_HDMI_FC_RDRB3_AUDIPACKETLINESPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB3_AUDIPACKETLINESPACING.

//! @brief Get value of HDMI_FC_RDRB3_AUDIPACKETLINESPACING from a register value.
#define BG_HDMI_FC_RDRB3_AUDIPACKETLINESPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB3_AUDIPACKETLINESPACING) >> BP_HDMI_FC_RDRB3_AUDIPACKETLINESPACING)

//! @brief Format value for bitfield HDMI_FC_RDRB3_AUDIPACKETLINESPACING.
#define BF_HDMI_FC_RDRB3_AUDIPACKETLINESPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB3_AUDIPACKETLINESPACING) & BM_HDMI_FC_RDRB3_AUDIPACKETLINESPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDIPACKETLINESPACING field to a new value.
#define BW_HDMI_FC_RDRB3_AUDIPACKETLINESPACING(v)   (HW_HDMI_FC_RDRB3_WR((HW_HDMI_FC_RDRB3_RD() & ~BM_HDMI_FC_RDRB3_AUDIPACKETLINESPACING) | BF_HDMI_FC_RDRB3_AUDIPACKETLINESPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_RDRB3, field AUDIPACKETSINFRAME[7:4] (RW)
 *
 * Audio packets per frame
 */
//@{
#define BP_HDMI_FC_RDRB3_AUDIPACKETSINFRAME      (4)      //!< Bit position for HDMI_FC_RDRB3_AUDIPACKETSINFRAME.
#define BM_HDMI_FC_RDRB3_AUDIPACKETSINFRAME      (0x000000f0)  //!< Bit mask for HDMI_FC_RDRB3_AUDIPACKETSINFRAME.

//! @brief Get value of HDMI_FC_RDRB3_AUDIPACKETSINFRAME from a register value.
#define BG_HDMI_FC_RDRB3_AUDIPACKETSINFRAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB3_AUDIPACKETSINFRAME) >> BP_HDMI_FC_RDRB3_AUDIPACKETSINFRAME)

//! @brief Format value for bitfield HDMI_FC_RDRB3_AUDIPACKETSINFRAME.
#define BF_HDMI_FC_RDRB3_AUDIPACKETSINFRAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB3_AUDIPACKETSINFRAME) & BM_HDMI_FC_RDRB3_AUDIPACKETSINFRAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDIPACKETSINFRAME field to a new value.
#define BW_HDMI_FC_RDRB3_AUDIPACKETSINFRAME(v)   (HW_HDMI_FC_RDRB3_WR((HW_HDMI_FC_RDRB3_RD() & ~BM_HDMI_FC_RDRB3_AUDIPACKETSINFRAME) | BF_HDMI_FC_RDRB3_AUDIPACKETSINFRAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB4 - Frame Composer Round Robin ACR Packet Insertion Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB4 - Frame Composer Round Robin ACR Packet Insertion Register 4 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB frame interpolation for GCP packet insertion on data
 * island when FC is on RDRB mode for this packet.
 */
typedef union _hw_hdmi_fc_rdrb4
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb4_bitfields
    {
        unsigned char GCPFRAMEINTERPOLATION : 4; //!< [3:0] GCP packets line spacing
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_rdrb4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB4 register
 */
//@{
#define HW_HDMI_FC_RDRB4_ADDR      (REGS_HDMI_BASE + 0x10bc)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB4           (*(volatile hw_hdmi_fc_rdrb4_t *) HW_HDMI_FC_RDRB4_ADDR)
#define HW_HDMI_FC_RDRB4_RD()      (HW_HDMI_FC_RDRB4.U)
#define HW_HDMI_FC_RDRB4_WR(v)     (HW_HDMI_FC_RDRB4.U = (v))
#define HW_HDMI_FC_RDRB4_SET(v)    (HW_HDMI_FC_RDRB4_WR(HW_HDMI_FC_RDRB4_RD() |  (v)))
#define HW_HDMI_FC_RDRB4_CLR(v)    (HW_HDMI_FC_RDRB4_WR(HW_HDMI_FC_RDRB4_RD() & ~(v)))
#define HW_HDMI_FC_RDRB4_TOG(v)    (HW_HDMI_FC_RDRB4_WR(HW_HDMI_FC_RDRB4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB4 bitfields
 */

/*! @name Register HDMI_FC_RDRB4, field GCPFRAMEINTERPOLATION[3:0] (RW)
 *
 * GCP packets line spacing
 */
//@{
#define BP_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION      (0)      //!< Bit position for HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION.
#define BM_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION.

//! @brief Get value of HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION from a register value.
#define BG_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION) >> BP_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION)

//! @brief Format value for bitfield HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION.
#define BF_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION) & BM_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCPFRAMEINTERPOLATION field to a new value.
#define BW_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION(v)   (HW_HDMI_FC_RDRB4_WR((HW_HDMI_FC_RDRB4_RD() & ~BM_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION) | BF_HDMI_FC_RDRB4_GCPFRAMEINTERPOLATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB5 - Frame Composer Round Robin ACR Packet Insertion Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB5 - Frame Composer Round Robin ACR Packet Insertion Register 5 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB line interpolation and number of packets in frame for the
 * GCP packet insertion on data island when FC is on RDRB mode this packet.
 */
typedef union _hw_hdmi_fc_rdrb5
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb5_bitfields
    {
        unsigned char GCPPACKETLINESPACING : 4; //!< [3:0] GCP packets line spacing
        unsigned char GCPPACKETSINFRAME : 4; //!< [7:4] GCP packets per frame
    } B;
} hw_hdmi_fc_rdrb5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB5 register
 */
//@{
#define HW_HDMI_FC_RDRB5_ADDR      (REGS_HDMI_BASE + 0x10bd)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB5           (*(volatile hw_hdmi_fc_rdrb5_t *) HW_HDMI_FC_RDRB5_ADDR)
#define HW_HDMI_FC_RDRB5_RD()      (HW_HDMI_FC_RDRB5.U)
#define HW_HDMI_FC_RDRB5_WR(v)     (HW_HDMI_FC_RDRB5.U = (v))
#define HW_HDMI_FC_RDRB5_SET(v)    (HW_HDMI_FC_RDRB5_WR(HW_HDMI_FC_RDRB5_RD() |  (v)))
#define HW_HDMI_FC_RDRB5_CLR(v)    (HW_HDMI_FC_RDRB5_WR(HW_HDMI_FC_RDRB5_RD() & ~(v)))
#define HW_HDMI_FC_RDRB5_TOG(v)    (HW_HDMI_FC_RDRB5_WR(HW_HDMI_FC_RDRB5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB5 bitfields
 */

/*! @name Register HDMI_FC_RDRB5, field GCPPACKETLINESPACING[3:0] (RW)
 *
 * GCP packets line spacing
 */
//@{
#define BP_HDMI_FC_RDRB5_GCPPACKETLINESPACING      (0)      //!< Bit position for HDMI_FC_RDRB5_GCPPACKETLINESPACING.
#define BM_HDMI_FC_RDRB5_GCPPACKETLINESPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB5_GCPPACKETLINESPACING.

//! @brief Get value of HDMI_FC_RDRB5_GCPPACKETLINESPACING from a register value.
#define BG_HDMI_FC_RDRB5_GCPPACKETLINESPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB5_GCPPACKETLINESPACING) >> BP_HDMI_FC_RDRB5_GCPPACKETLINESPACING)

//! @brief Format value for bitfield HDMI_FC_RDRB5_GCPPACKETLINESPACING.
#define BF_HDMI_FC_RDRB5_GCPPACKETLINESPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB5_GCPPACKETLINESPACING) & BM_HDMI_FC_RDRB5_GCPPACKETLINESPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCPPACKETLINESPACING field to a new value.
#define BW_HDMI_FC_RDRB5_GCPPACKETLINESPACING(v)   (HW_HDMI_FC_RDRB5_WR((HW_HDMI_FC_RDRB5_RD() & ~BM_HDMI_FC_RDRB5_GCPPACKETLINESPACING) | BF_HDMI_FC_RDRB5_GCPPACKETLINESPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_RDRB5, field GCPPACKETSINFRAME[7:4] (RW)
 *
 * GCP packets per frame
 */
//@{
#define BP_HDMI_FC_RDRB5_GCPPACKETSINFRAME      (4)      //!< Bit position for HDMI_FC_RDRB5_GCPPACKETSINFRAME.
#define BM_HDMI_FC_RDRB5_GCPPACKETSINFRAME      (0x000000f0)  //!< Bit mask for HDMI_FC_RDRB5_GCPPACKETSINFRAME.

//! @brief Get value of HDMI_FC_RDRB5_GCPPACKETSINFRAME from a register value.
#define BG_HDMI_FC_RDRB5_GCPPACKETSINFRAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB5_GCPPACKETSINFRAME) >> BP_HDMI_FC_RDRB5_GCPPACKETSINFRAME)

//! @brief Format value for bitfield HDMI_FC_RDRB5_GCPPACKETSINFRAME.
#define BF_HDMI_FC_RDRB5_GCPPACKETSINFRAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB5_GCPPACKETSINFRAME) & BM_HDMI_FC_RDRB5_GCPPACKETSINFRAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCPPACKETSINFRAME field to a new value.
#define BW_HDMI_FC_RDRB5_GCPPACKETSINFRAME(v)   (HW_HDMI_FC_RDRB5_WR((HW_HDMI_FC_RDRB5_RD() & ~BM_HDMI_FC_RDRB5_GCPPACKETSINFRAME) | BF_HDMI_FC_RDRB5_GCPPACKETSINFRAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB6 - Frame Composer Round Robin ACR Packet Insertion Register 6
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB6 - Frame Composer Round Robin ACR Packet Insertion Register 6 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB frame interpolation for AVI packet insertion on data
 * island when FC is on RDRB mode for this packet.
 */
typedef union _hw_hdmi_fc_rdrb6
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb6_bitfields
    {
        unsigned char AVIFRAMEINTERPOLATION : 4; //!< [3:0] GCP packets line spacing
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_fc_rdrb6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB6 register
 */
//@{
#define HW_HDMI_FC_RDRB6_ADDR      (REGS_HDMI_BASE + 0x10be)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB6           (*(volatile hw_hdmi_fc_rdrb6_t *) HW_HDMI_FC_RDRB6_ADDR)
#define HW_HDMI_FC_RDRB6_RD()      (HW_HDMI_FC_RDRB6.U)
#define HW_HDMI_FC_RDRB6_WR(v)     (HW_HDMI_FC_RDRB6.U = (v))
#define HW_HDMI_FC_RDRB6_SET(v)    (HW_HDMI_FC_RDRB6_WR(HW_HDMI_FC_RDRB6_RD() |  (v)))
#define HW_HDMI_FC_RDRB6_CLR(v)    (HW_HDMI_FC_RDRB6_WR(HW_HDMI_FC_RDRB6_RD() & ~(v)))
#define HW_HDMI_FC_RDRB6_TOG(v)    (HW_HDMI_FC_RDRB6_WR(HW_HDMI_FC_RDRB6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB6 bitfields
 */

/*! @name Register HDMI_FC_RDRB6, field AVIFRAMEINTERPOLATION[3:0] (RW)
 *
 * GCP packets line spacing
 */
//@{
#define BP_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION      (0)      //!< Bit position for HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION.
#define BM_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION.

//! @brief Get value of HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION from a register value.
#define BG_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION) >> BP_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION)

//! @brief Format value for bitfield HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION.
#define BF_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION) & BM_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVIFRAMEINTERPOLATION field to a new value.
#define BW_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION(v)   (HW_HDMI_FC_RDRB6_WR((HW_HDMI_FC_RDRB6_RD() & ~BM_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION) | BF_HDMI_FC_RDRB6_AVIFRAMEINTERPOLATION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_RDRB7 - Frame Composer Round Robin ACR Packet Insertion Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_RDRB7 - Frame Composer Round Robin ACR Packet Insertion Register 7 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the Frame Composer (FC) RDRB line interpolation and number of packets in frame for the
 * AVI packet insertion on data island when FC is on RDRB mode this packet.
 */
typedef union _hw_hdmi_fc_rdrb7
{
    reg8_t U;
    struct _hw_hdmi_fc_rdrb7_bitfields
    {
        unsigned char AVIPACKETLINESPACING : 4; //!< [3:0] AVI packets line spacing
        unsigned char AVIPACKETSINFRAME : 4; //!< [7:4] AVI packets per frame
    } B;
} hw_hdmi_fc_rdrb7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_RDRB7 register
 */
//@{
#define HW_HDMI_FC_RDRB7_ADDR      (REGS_HDMI_BASE + 0x10bf)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_RDRB7           (*(volatile hw_hdmi_fc_rdrb7_t *) HW_HDMI_FC_RDRB7_ADDR)
#define HW_HDMI_FC_RDRB7_RD()      (HW_HDMI_FC_RDRB7.U)
#define HW_HDMI_FC_RDRB7_WR(v)     (HW_HDMI_FC_RDRB7.U = (v))
#define HW_HDMI_FC_RDRB7_SET(v)    (HW_HDMI_FC_RDRB7_WR(HW_HDMI_FC_RDRB7_RD() |  (v)))
#define HW_HDMI_FC_RDRB7_CLR(v)    (HW_HDMI_FC_RDRB7_WR(HW_HDMI_FC_RDRB7_RD() & ~(v)))
#define HW_HDMI_FC_RDRB7_TOG(v)    (HW_HDMI_FC_RDRB7_WR(HW_HDMI_FC_RDRB7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_RDRB7 bitfields
 */

/*! @name Register HDMI_FC_RDRB7, field AVIPACKETLINESPACING[3:0] (RW)
 *
 * AVI packets line spacing
 */
//@{
#define BP_HDMI_FC_RDRB7_AVIPACKETLINESPACING      (0)      //!< Bit position for HDMI_FC_RDRB7_AVIPACKETLINESPACING.
#define BM_HDMI_FC_RDRB7_AVIPACKETLINESPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_RDRB7_AVIPACKETLINESPACING.

//! @brief Get value of HDMI_FC_RDRB7_AVIPACKETLINESPACING from a register value.
#define BG_HDMI_FC_RDRB7_AVIPACKETLINESPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB7_AVIPACKETLINESPACING) >> BP_HDMI_FC_RDRB7_AVIPACKETLINESPACING)

//! @brief Format value for bitfield HDMI_FC_RDRB7_AVIPACKETLINESPACING.
#define BF_HDMI_FC_RDRB7_AVIPACKETLINESPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB7_AVIPACKETLINESPACING) & BM_HDMI_FC_RDRB7_AVIPACKETLINESPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVIPACKETLINESPACING field to a new value.
#define BW_HDMI_FC_RDRB7_AVIPACKETLINESPACING(v)   (HW_HDMI_FC_RDRB7_WR((HW_HDMI_FC_RDRB7_RD() & ~BM_HDMI_FC_RDRB7_AVIPACKETLINESPACING) | BF_HDMI_FC_RDRB7_AVIPACKETLINESPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_RDRB7, field AVIPACKETSINFRAME[7:4] (RW)
 *
 * AVI packets per frame
 */
//@{
#define BP_HDMI_FC_RDRB7_AVIPACKETSINFRAME      (4)      //!< Bit position for HDMI_FC_RDRB7_AVIPACKETSINFRAME.
#define BM_HDMI_FC_RDRB7_AVIPACKETSINFRAME      (0x000000f0)  //!< Bit mask for HDMI_FC_RDRB7_AVIPACKETSINFRAME.

//! @brief Get value of HDMI_FC_RDRB7_AVIPACKETSINFRAME from a register value.
#define BG_HDMI_FC_RDRB7_AVIPACKETSINFRAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_RDRB7_AVIPACKETSINFRAME) >> BP_HDMI_FC_RDRB7_AVIPACKETSINFRAME)

//! @brief Format value for bitfield HDMI_FC_RDRB7_AVIPACKETSINFRAME.
#define BF_HDMI_FC_RDRB7_AVIPACKETSINFRAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_RDRB7_AVIPACKETSINFRAME) & BM_HDMI_FC_RDRB7_AVIPACKETSINFRAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVIPACKETSINFRAME field to a new value.
#define BW_HDMI_FC_RDRB7_AVIPACKETSINFRAME(v)   (HW_HDMI_FC_RDRB7_WR((HW_HDMI_FC_RDRB7_RD() & ~BM_HDMI_FC_RDRB7_AVIPACKETSINFRAME) | BF_HDMI_FC_RDRB7_AVIPACKETSINFRAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_MASK0 - Frame Composer Packet Interrupt Mask Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_MASK0 - Frame Composer Packet Interrupt Mask Register 0 (RW)
 *
 * Reset value: 0x25
 *
 * Mask register for generation of FC_INT0 interrupts.
 */
typedef union _hw_hdmi_fc_mask0
{
    reg8_t U;
    struct _hw_hdmi_fc_mask0_bitfields
    {
        unsigned char NULL_ : 1; //!< [0] Mask bit for FC_INT0.NULL interrupt bit
        unsigned char ACR : 1; //!< [1] Mask bit for FC_INT0.ACR interrupt bit
        unsigned char AUDS : 1; //!< [2] Mask bit for FC_INT0.AUDS interrupt bit
        unsigned char RESERVED0 : 2; //!< [4:3] Reserved
        unsigned char HBR : 1; //!< [5] Mask bit for FC_INT0.HBR interrupt bit
        unsigned char ACP : 1; //!< [6] Mask bit for FC_INT0.ACP interrupt bit
        unsigned char AUDI : 1; //!< [7] Mask bit for FC_INT0.AUDI interrupt bit
    } B;
} hw_hdmi_fc_mask0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_MASK0 register
 */
//@{
#define HW_HDMI_FC_MASK0_ADDR      (REGS_HDMI_BASE + 0x10d2)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_MASK0           (*(volatile hw_hdmi_fc_mask0_t *) HW_HDMI_FC_MASK0_ADDR)
#define HW_HDMI_FC_MASK0_RD()      (HW_HDMI_FC_MASK0.U)
#define HW_HDMI_FC_MASK0_WR(v)     (HW_HDMI_FC_MASK0.U = (v))
#define HW_HDMI_FC_MASK0_SET(v)    (HW_HDMI_FC_MASK0_WR(HW_HDMI_FC_MASK0_RD() |  (v)))
#define HW_HDMI_FC_MASK0_CLR(v)    (HW_HDMI_FC_MASK0_WR(HW_HDMI_FC_MASK0_RD() & ~(v)))
#define HW_HDMI_FC_MASK0_TOG(v)    (HW_HDMI_FC_MASK0_WR(HW_HDMI_FC_MASK0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_MASK0 bitfields
 */

/*! @name Register HDMI_FC_MASK0, field NULL_[0] (RW)
 *
 * Mask bit for FC_INT0.NULL interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_NULL_      (0)      //!< Bit position for HDMI_FC_MASK0_NULL_.
#define BM_HDMI_FC_MASK0_NULL_      (0x00000001)  //!< Bit mask for HDMI_FC_MASK0_NULL_.

//! @brief Get value of HDMI_FC_MASK0_NULL_ from a register value.
#define BG_HDMI_FC_MASK0_NULL_(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_NULL_) >> BP_HDMI_FC_MASK0_NULL_)

//! @brief Format value for bitfield HDMI_FC_MASK0_NULL_.
#define BF_HDMI_FC_MASK0_NULL_(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_NULL_) & BM_HDMI_FC_MASK0_NULL_)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NULL_ field to a new value.
#define BW_HDMI_FC_MASK0_NULL_(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_NULL_) | BF_HDMI_FC_MASK0_NULL_(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK0, field ACR[1] (RW)
 *
 * Mask bit for FC_INT0.ACR interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_ACR      (1)      //!< Bit position for HDMI_FC_MASK0_ACR.
#define BM_HDMI_FC_MASK0_ACR      (0x00000002)  //!< Bit mask for HDMI_FC_MASK0_ACR.

//! @brief Get value of HDMI_FC_MASK0_ACR from a register value.
#define BG_HDMI_FC_MASK0_ACR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_ACR) >> BP_HDMI_FC_MASK0_ACR)

//! @brief Format value for bitfield HDMI_FC_MASK0_ACR.
#define BF_HDMI_FC_MASK0_ACR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_ACR) & BM_HDMI_FC_MASK0_ACR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACR field to a new value.
#define BW_HDMI_FC_MASK0_ACR(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_ACR) | BF_HDMI_FC_MASK0_ACR(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK0, field AUDS[2] (RW)
 *
 * Mask bit for FC_INT0.AUDS interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_AUDS      (2)      //!< Bit position for HDMI_FC_MASK0_AUDS.
#define BM_HDMI_FC_MASK0_AUDS      (0x00000004)  //!< Bit mask for HDMI_FC_MASK0_AUDS.

//! @brief Get value of HDMI_FC_MASK0_AUDS from a register value.
#define BG_HDMI_FC_MASK0_AUDS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_AUDS) >> BP_HDMI_FC_MASK0_AUDS)

//! @brief Format value for bitfield HDMI_FC_MASK0_AUDS.
#define BF_HDMI_FC_MASK0_AUDS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_AUDS) & BM_HDMI_FC_MASK0_AUDS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDS field to a new value.
#define BW_HDMI_FC_MASK0_AUDS(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_AUDS) | BF_HDMI_FC_MASK0_AUDS(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK0, field HBR[5] (RW)
 *
 * Mask bit for FC_INT0.HBR interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_HBR      (5)      //!< Bit position for HDMI_FC_MASK0_HBR.
#define BM_HDMI_FC_MASK0_HBR      (0x00000020)  //!< Bit mask for HDMI_FC_MASK0_HBR.

//! @brief Get value of HDMI_FC_MASK0_HBR from a register value.
#define BG_HDMI_FC_MASK0_HBR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_HBR) >> BP_HDMI_FC_MASK0_HBR)

//! @brief Format value for bitfield HDMI_FC_MASK0_HBR.
#define BF_HDMI_FC_MASK0_HBR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_HBR) & BM_HDMI_FC_MASK0_HBR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HBR field to a new value.
#define BW_HDMI_FC_MASK0_HBR(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_HBR) | BF_HDMI_FC_MASK0_HBR(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK0, field ACP[6] (RW)
 *
 * Mask bit for FC_INT0.ACP interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_ACP      (6)      //!< Bit position for HDMI_FC_MASK0_ACP.
#define BM_HDMI_FC_MASK0_ACP      (0x00000040)  //!< Bit mask for HDMI_FC_MASK0_ACP.

//! @brief Get value of HDMI_FC_MASK0_ACP from a register value.
#define BG_HDMI_FC_MASK0_ACP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_ACP) >> BP_HDMI_FC_MASK0_ACP)

//! @brief Format value for bitfield HDMI_FC_MASK0_ACP.
#define BF_HDMI_FC_MASK0_ACP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_ACP) & BM_HDMI_FC_MASK0_ACP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ACP field to a new value.
#define BW_HDMI_FC_MASK0_ACP(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_ACP) | BF_HDMI_FC_MASK0_ACP(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK0, field AUDI[7] (RW)
 *
 * Mask bit for FC_INT0.AUDI interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK0_AUDI      (7)      //!< Bit position for HDMI_FC_MASK0_AUDI.
#define BM_HDMI_FC_MASK0_AUDI      (0x00000080)  //!< Bit mask for HDMI_FC_MASK0_AUDI.

//! @brief Get value of HDMI_FC_MASK0_AUDI from a register value.
#define BG_HDMI_FC_MASK0_AUDI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK0_AUDI) >> BP_HDMI_FC_MASK0_AUDI)

//! @brief Format value for bitfield HDMI_FC_MASK0_AUDI.
#define BF_HDMI_FC_MASK0_AUDI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK0_AUDI) & BM_HDMI_FC_MASK0_AUDI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDI field to a new value.
#define BW_HDMI_FC_MASK0_AUDI(v)   (HW_HDMI_FC_MASK0_WR((HW_HDMI_FC_MASK0_RD() & ~BM_HDMI_FC_MASK0_AUDI) | BF_HDMI_FC_MASK0_AUDI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_MASK1 - Frame Composer Packet Interrupt Mask Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_MASK1 - Frame Composer Packet Interrupt Mask Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Mask register for generation of FC_INT1 interrupts.
 */
typedef union _hw_hdmi_fc_mask1
{
    reg8_t U;
    struct _hw_hdmi_fc_mask1_bitfields
    {
        unsigned char GCP : 1; //!< [0] Mask bit for FC_INT1.GCP interrupt bit
        unsigned char AVI : 1; //!< [1] Mask bit for FC_INT1.AVI interrupt bit
        unsigned char RESERVED0 : 1; //!< [2] Reserved
        unsigned char SPD : 1; //!< [3] Mask bit for FC_INT1.SPD interrupt bit
        unsigned char VSD : 1; //!< [4] Mask bit for FC_INT1.VSD interrupt bit
        unsigned char ISCR2 : 1; //!< [5] Mask bit for FC_INT1.ISRC2 interrupt bit
        unsigned char ISCR1 : 1; //!< [6] Mask bit for FC_INT1.ISRC1 interrupt bit
        unsigned char GMD : 1; //!< [7] Mask bit for FC_INT1.GMD interrupt bit
    } B;
} hw_hdmi_fc_mask1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_MASK1 register
 */
//@{
#define HW_HDMI_FC_MASK1_ADDR      (REGS_HDMI_BASE + 0x10d6)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_MASK1           (*(volatile hw_hdmi_fc_mask1_t *) HW_HDMI_FC_MASK1_ADDR)
#define HW_HDMI_FC_MASK1_RD()      (HW_HDMI_FC_MASK1.U)
#define HW_HDMI_FC_MASK1_WR(v)     (HW_HDMI_FC_MASK1.U = (v))
#define HW_HDMI_FC_MASK1_SET(v)    (HW_HDMI_FC_MASK1_WR(HW_HDMI_FC_MASK1_RD() |  (v)))
#define HW_HDMI_FC_MASK1_CLR(v)    (HW_HDMI_FC_MASK1_WR(HW_HDMI_FC_MASK1_RD() & ~(v)))
#define HW_HDMI_FC_MASK1_TOG(v)    (HW_HDMI_FC_MASK1_WR(HW_HDMI_FC_MASK1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_MASK1 bitfields
 */

/*! @name Register HDMI_FC_MASK1, field GCP[0] (RW)
 *
 * Mask bit for FC_INT1.GCP interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_GCP      (0)      //!< Bit position for HDMI_FC_MASK1_GCP.
#define BM_HDMI_FC_MASK1_GCP      (0x00000001)  //!< Bit mask for HDMI_FC_MASK1_GCP.

//! @brief Get value of HDMI_FC_MASK1_GCP from a register value.
#define BG_HDMI_FC_MASK1_GCP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_GCP) >> BP_HDMI_FC_MASK1_GCP)

//! @brief Format value for bitfield HDMI_FC_MASK1_GCP.
#define BF_HDMI_FC_MASK1_GCP(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_GCP) & BM_HDMI_FC_MASK1_GCP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCP field to a new value.
#define BW_HDMI_FC_MASK1_GCP(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_GCP) | BF_HDMI_FC_MASK1_GCP(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field AVI[1] (RW)
 *
 * Mask bit for FC_INT1.AVI interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_AVI      (1)      //!< Bit position for HDMI_FC_MASK1_AVI.
#define BM_HDMI_FC_MASK1_AVI      (0x00000002)  //!< Bit mask for HDMI_FC_MASK1_AVI.

//! @brief Get value of HDMI_FC_MASK1_AVI from a register value.
#define BG_HDMI_FC_MASK1_AVI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_AVI) >> BP_HDMI_FC_MASK1_AVI)

//! @brief Format value for bitfield HDMI_FC_MASK1_AVI.
#define BF_HDMI_FC_MASK1_AVI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_AVI) & BM_HDMI_FC_MASK1_AVI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVI field to a new value.
#define BW_HDMI_FC_MASK1_AVI(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_AVI) | BF_HDMI_FC_MASK1_AVI(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field SPD[3] (RW)
 *
 * Mask bit for FC_INT1.SPD interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_SPD      (3)      //!< Bit position for HDMI_FC_MASK1_SPD.
#define BM_HDMI_FC_MASK1_SPD      (0x00000008)  //!< Bit mask for HDMI_FC_MASK1_SPD.

//! @brief Get value of HDMI_FC_MASK1_SPD from a register value.
#define BG_HDMI_FC_MASK1_SPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_SPD) >> BP_HDMI_FC_MASK1_SPD)

//! @brief Format value for bitfield HDMI_FC_MASK1_SPD.
#define BF_HDMI_FC_MASK1_SPD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_SPD) & BM_HDMI_FC_MASK1_SPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPD field to a new value.
#define BW_HDMI_FC_MASK1_SPD(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_SPD) | BF_HDMI_FC_MASK1_SPD(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field VSD[4] (RW)
 *
 * Mask bit for FC_INT1.VSD interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_VSD      (4)      //!< Bit position for HDMI_FC_MASK1_VSD.
#define BM_HDMI_FC_MASK1_VSD      (0x00000010)  //!< Bit mask for HDMI_FC_MASK1_VSD.

//! @brief Get value of HDMI_FC_MASK1_VSD from a register value.
#define BG_HDMI_FC_MASK1_VSD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_VSD) >> BP_HDMI_FC_MASK1_VSD)

//! @brief Format value for bitfield HDMI_FC_MASK1_VSD.
#define BF_HDMI_FC_MASK1_VSD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_VSD) & BM_HDMI_FC_MASK1_VSD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSD field to a new value.
#define BW_HDMI_FC_MASK1_VSD(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_VSD) | BF_HDMI_FC_MASK1_VSD(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field ISCR2[5] (RW)
 *
 * Mask bit for FC_INT1.ISRC2 interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_ISCR2      (5)      //!< Bit position for HDMI_FC_MASK1_ISCR2.
#define BM_HDMI_FC_MASK1_ISCR2      (0x00000020)  //!< Bit mask for HDMI_FC_MASK1_ISCR2.

//! @brief Get value of HDMI_FC_MASK1_ISCR2 from a register value.
#define BG_HDMI_FC_MASK1_ISCR2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_ISCR2) >> BP_HDMI_FC_MASK1_ISCR2)

//! @brief Format value for bitfield HDMI_FC_MASK1_ISCR2.
#define BF_HDMI_FC_MASK1_ISCR2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_ISCR2) & BM_HDMI_FC_MASK1_ISCR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR2 field to a new value.
#define BW_HDMI_FC_MASK1_ISCR2(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_ISCR2) | BF_HDMI_FC_MASK1_ISCR2(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field ISCR1[6] (RW)
 *
 * Mask bit for FC_INT1.ISRC1 interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_ISCR1      (6)      //!< Bit position for HDMI_FC_MASK1_ISCR1.
#define BM_HDMI_FC_MASK1_ISCR1      (0x00000040)  //!< Bit mask for HDMI_FC_MASK1_ISCR1.

//! @brief Get value of HDMI_FC_MASK1_ISCR1 from a register value.
#define BG_HDMI_FC_MASK1_ISCR1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_ISCR1) >> BP_HDMI_FC_MASK1_ISCR1)

//! @brief Format value for bitfield HDMI_FC_MASK1_ISCR1.
#define BF_HDMI_FC_MASK1_ISCR1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_ISCR1) & BM_HDMI_FC_MASK1_ISCR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISCR1 field to a new value.
#define BW_HDMI_FC_MASK1_ISCR1(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_ISCR1) | BF_HDMI_FC_MASK1_ISCR1(v)))
#endif
//@}

/*! @name Register HDMI_FC_MASK1, field GMD[7] (RW)
 *
 * Mask bit for FC_INT1.GMD interrupt bit
 */
//@{
#define BP_HDMI_FC_MASK1_GMD      (7)      //!< Bit position for HDMI_FC_MASK1_GMD.
#define BM_HDMI_FC_MASK1_GMD      (0x00000080)  //!< Bit mask for HDMI_FC_MASK1_GMD.

//! @brief Get value of HDMI_FC_MASK1_GMD from a register value.
#define BG_HDMI_FC_MASK1_GMD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK1_GMD) >> BP_HDMI_FC_MASK1_GMD)

//! @brief Format value for bitfield HDMI_FC_MASK1_GMD.
#define BF_HDMI_FC_MASK1_GMD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK1_GMD) & BM_HDMI_FC_MASK1_GMD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMD field to a new value.
#define BW_HDMI_FC_MASK1_GMD(v)   (HW_HDMI_FC_MASK1_WR((HW_HDMI_FC_MASK1_RD() & ~BM_HDMI_FC_MASK1_GMD) | BF_HDMI_FC_MASK1_GMD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_MASK2 - Frame Composer High/Low Priority Overflow Interrupt Mask Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_MASK2 - Frame Composer High/Low Priority Overflow Interrupt Mask Register 2 (RW)
 *
 * Reset value: 0x00
 *
 * Mask register for generation of FC_INT2 interrupts.
 */
typedef union _hw_hdmi_fc_mask2
{
    reg8_t U;
    struct _hw_hdmi_fc_mask2_bitfields
    {
        unsigned char HIGHPRIORITY_OVERFLOW : 1; //!< [0] Mask bit for FC_INT1.HighPriority_overflow interrupt bit
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved.
    } B;
} hw_hdmi_fc_mask2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_MASK2 register
 */
//@{
#define HW_HDMI_FC_MASK2_ADDR      (REGS_HDMI_BASE + 0x10da)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_MASK2           (*(volatile hw_hdmi_fc_mask2_t *) HW_HDMI_FC_MASK2_ADDR)
#define HW_HDMI_FC_MASK2_RD()      (HW_HDMI_FC_MASK2.U)
#define HW_HDMI_FC_MASK2_WR(v)     (HW_HDMI_FC_MASK2.U = (v))
#define HW_HDMI_FC_MASK2_SET(v)    (HW_HDMI_FC_MASK2_WR(HW_HDMI_FC_MASK2_RD() |  (v)))
#define HW_HDMI_FC_MASK2_CLR(v)    (HW_HDMI_FC_MASK2_WR(HW_HDMI_FC_MASK2_RD() & ~(v)))
#define HW_HDMI_FC_MASK2_TOG(v)    (HW_HDMI_FC_MASK2_WR(HW_HDMI_FC_MASK2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_MASK2 bitfields
 */

/*! @name Register HDMI_FC_MASK2, field HIGHPRIORITY_OVERFLOW[0] (RW)
 *
 * Mask bit for FC_INT1.HighPriority_overflow interrupt bit Value after Reset: 0b
 */
//@{
#define BP_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW      (0)      //!< Bit position for HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW.
#define BM_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW      (0x00000001)  //!< Bit mask for HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW.

//! @brief Get value of HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW from a register value.
#define BG_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW) >> BP_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW)

//! @brief Format value for bitfield HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW.
#define BF_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW) & BM_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HIGHPRIORITY_OVERFLOW field to a new value.
#define BW_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW(v)   (HW_HDMI_FC_MASK2_WR((HW_HDMI_FC_MASK2_RD() & ~BM_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW) | BF_HDMI_FC_MASK2_HIGHPRIORITY_OVERFLOW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_PRCONF - Frame Composer Pixel Repetition Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_PRCONF - Frame Composer Pixel Repetition Configuration Register (RW)
 *
 * Reset value: 0x10
 *
 * Defines the Pixel Repetition ratio factor of the input and output video signal.
 */
typedef union _hw_hdmi_fc_prconf
{
    reg8_t U;
    struct _hw_hdmi_fc_prconf_bitfields
    {
        unsigned char OUTPUT_PR_FACTOR : 4; //!< [3:0] Configures the video pixel repetition ratio to be sent on the AVI infoFrame.
        unsigned char INCOMING_PR_FACTOR : 4; //!< [7:4] Configures the input video pixel repetition.
    } B;
} hw_hdmi_fc_prconf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_PRCONF register
 */
//@{
#define HW_HDMI_FC_PRCONF_ADDR      (REGS_HDMI_BASE + 0x10e0)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_PRCONF           (*(volatile hw_hdmi_fc_prconf_t *) HW_HDMI_FC_PRCONF_ADDR)
#define HW_HDMI_FC_PRCONF_RD()      (HW_HDMI_FC_PRCONF.U)
#define HW_HDMI_FC_PRCONF_WR(v)     (HW_HDMI_FC_PRCONF.U = (v))
#define HW_HDMI_FC_PRCONF_SET(v)    (HW_HDMI_FC_PRCONF_WR(HW_HDMI_FC_PRCONF_RD() |  (v)))
#define HW_HDMI_FC_PRCONF_CLR(v)    (HW_HDMI_FC_PRCONF_WR(HW_HDMI_FC_PRCONF_RD() & ~(v)))
#define HW_HDMI_FC_PRCONF_TOG(v)    (HW_HDMI_FC_PRCONF_WR(HW_HDMI_FC_PRCONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_PRCONF bitfields
 */

/*! @name Register HDMI_FC_PRCONF, field OUTPUT_PR_FACTOR[3:0] (RW)
 *
 * Configures the video pixel repetition ratio to be sent on the AVI infoFrame. This value must be
 * valid according to HDMI spec. The output_pr_factor = incoming_pr_factor(without the + 1 factor) *
 * desired_pr_factor. other: Reserved. Not used.
 *
 * Values:
 * - 0000 - No action. Shall not be used.
 * - 0001 - Pixel sent twice (pixel repeated once).
 * - 0010 - Pixel sent 3 times.
 * - 0011 - Pixel sent 4 times.
 * - 0100 - Pixel sent 5 times.
 * - 0101 - Pixel sent 6 times.
 * - 0110 - Pixel sent 7 times.
 * - 0111 - Pixel sent 8 times.
 * - 1000 - Pixel sent 9 times.
 * - 1001 - Pixel sent 10 times.
 */
//@{
#define BP_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR      (0)      //!< Bit position for HDMI_FC_PRCONF_OUTPUT_PR_FACTOR.
#define BM_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR      (0x0000000f)  //!< Bit mask for HDMI_FC_PRCONF_OUTPUT_PR_FACTOR.

//! @brief Get value of HDMI_FC_PRCONF_OUTPUT_PR_FACTOR from a register value.
#define BG_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR) >> BP_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR)

//! @brief Format value for bitfield HDMI_FC_PRCONF_OUTPUT_PR_FACTOR.
#define BF_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR) & BM_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTPUT_PR_FACTOR field to a new value.
#define BW_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR(v)   (HW_HDMI_FC_PRCONF_WR((HW_HDMI_FC_PRCONF_RD() & ~BM_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR) | BF_HDMI_FC_PRCONF_OUTPUT_PR_FACTOR(v)))
#endif
//@}

/*! @name Register HDMI_FC_PRCONF, field INCOMING_PR_FACTOR[7:4] (RW)
 *
 * Configures the input video pixel repetition. A plus 1 factor should be added in this register
 * configuration. For CEA modes this value should be extracted from the CEA spec for the video mode
 * being inputted. When working in YCC422 video the actual repetition of the stream will be
 * Incoming_pr_factor * (desired_pr_factor + 1). This calculation is done internally in the H13TCTRL
 * and no HW overflow protection is available. Care must be taken to avoid this result passes the
 * maximum number of 10 pixels repeated since no HDMI support is available for this in the spec and
 * the H13TPHY does not support this higher repetition values. other: Reserved. Not used.
 *
 * Values:
 * - 0000 - No action. Shall not be used.
 * - 0001 - No pixel repetition (pixel sent only once).
 * - 0010 - Pixel sent twice (pixel repeated once).
 * - 0011 - Pixel sent 3 times.
 * - 0100 - Pixel sent 4 times.
 * - 0101 - Pixel sent 5 times.
 * - 0110 - Pixel sent 6 times.
 * - 0111 - Pixel sent 7 times.
 * - 1000 - Pixel sent 8 times.
 * - 1001 - Pixel sent 9 times.
 * - 1010 - Pixel sent 10 times.
 */
//@{
#define BP_HDMI_FC_PRCONF_INCOMING_PR_FACTOR      (4)      //!< Bit position for HDMI_FC_PRCONF_INCOMING_PR_FACTOR.
#define BM_HDMI_FC_PRCONF_INCOMING_PR_FACTOR      (0x000000f0)  //!< Bit mask for HDMI_FC_PRCONF_INCOMING_PR_FACTOR.

//! @brief Get value of HDMI_FC_PRCONF_INCOMING_PR_FACTOR from a register value.
#define BG_HDMI_FC_PRCONF_INCOMING_PR_FACTOR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_PRCONF_INCOMING_PR_FACTOR) >> BP_HDMI_FC_PRCONF_INCOMING_PR_FACTOR)

//! @brief Format value for bitfield HDMI_FC_PRCONF_INCOMING_PR_FACTOR.
#define BF_HDMI_FC_PRCONF_INCOMING_PR_FACTOR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_PRCONF_INCOMING_PR_FACTOR) & BM_HDMI_FC_PRCONF_INCOMING_PR_FACTOR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INCOMING_PR_FACTOR field to a new value.
#define BW_HDMI_FC_PRCONF_INCOMING_PR_FACTOR(v)   (HW_HDMI_FC_PRCONF_WR((HW_HDMI_FC_PRCONF_RD() & ~BM_HDMI_FC_PRCONF_INCOMING_PR_FACTOR) | BF_HDMI_FC_PRCONF_INCOMING_PR_FACTOR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_STAT - Frame Composer GMD Packet Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_STAT - Frame Composer GMD Packet Status Register (RO)
 *
 * Reset value: 0x00
 *
 * Gamut metadata packet status bit information for no_current_gmd, next_gmd_field,
 * gmd_packet_sequence and current_gamut_seq_num. For more information, refer to the HDMI 1.4a
 * specification.
 */
typedef union _hw_hdmi_fc_gmd_stat
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_stat_bitfields
    {
        unsigned char IGMDCURRENT_GAMUT_SEQ_NUM : 4; //!< [3:0] Gamut scheduling: Current Gamut packet sequence number
        unsigned char IGMDPACKET_SEQ : 2; //!< [5:4] Gamut scheduling: Gamut packet sequence
        unsigned char IGMDDNEXT_FIELD : 1; //!< [6] Gamut scheduling: Gamut Next field
        unsigned char IGMDNO_CRNT_GBD : 1; //!< [7] Gamut scheduling: No current gamut data
    } B;
} hw_hdmi_fc_gmd_stat_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_STAT register
 */
//@{
#define HW_HDMI_FC_GMD_STAT_ADDR      (REGS_HDMI_BASE + 0x1100)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_STAT           (*(volatile hw_hdmi_fc_gmd_stat_t *) HW_HDMI_FC_GMD_STAT_ADDR)
#define HW_HDMI_FC_GMD_STAT_RD()      (HW_HDMI_FC_GMD_STAT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_STAT bitfields
 */

/*! @name Register HDMI_FC_GMD_STAT, field IGMDCURRENT_GAMUT_SEQ_NUM[3:0] (RO)
 *
 * Gamut scheduling: Current Gamut packet sequence number
 */
//@{
#define BP_HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM      (0)      //!< Bit position for HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM.
#define BM_HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM      (0x0000000f)  //!< Bit mask for HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM.

//! @brief Get value of HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM from a register value.
#define BG_HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM) >> BP_HDMI_FC_GMD_STAT_IGMDCURRENT_GAMUT_SEQ_NUM)
//@}

/*! @name Register HDMI_FC_GMD_STAT, field IGMDPACKET_SEQ[5:4] (RO)
 *
 * Gamut scheduling: Gamut packet sequence
 */
//@{
#define BP_HDMI_FC_GMD_STAT_IGMDPACKET_SEQ      (4)      //!< Bit position for HDMI_FC_GMD_STAT_IGMDPACKET_SEQ.
#define BM_HDMI_FC_GMD_STAT_IGMDPACKET_SEQ      (0x00000030)  //!< Bit mask for HDMI_FC_GMD_STAT_IGMDPACKET_SEQ.

//! @brief Get value of HDMI_FC_GMD_STAT_IGMDPACKET_SEQ from a register value.
#define BG_HDMI_FC_GMD_STAT_IGMDPACKET_SEQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_STAT_IGMDPACKET_SEQ) >> BP_HDMI_FC_GMD_STAT_IGMDPACKET_SEQ)
//@}

/*! @name Register HDMI_FC_GMD_STAT, field IGMDDNEXT_FIELD[6] (RO)
 *
 * Gamut scheduling: Gamut Next field
 */
//@{
#define BP_HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD      (6)      //!< Bit position for HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD.
#define BM_HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD      (0x00000040)  //!< Bit mask for HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD.

//! @brief Get value of HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD from a register value.
#define BG_HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD) >> BP_HDMI_FC_GMD_STAT_IGMDDNEXT_FIELD)
//@}

/*! @name Register HDMI_FC_GMD_STAT, field IGMDNO_CRNT_GBD[7] (RO)
 *
 * Gamut scheduling: No current gamut data
 */
//@{
#define BP_HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD      (7)      //!< Bit position for HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD.
#define BM_HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD      (0x00000080)  //!< Bit mask for HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD.

//! @brief Get value of HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD from a register value.
#define BG_HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD) >> BP_HDMI_FC_GMD_STAT_IGMDNO_CRNT_GBD)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_EN - Frame Composer GMD Packet Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_EN - Frame Composer GMD Packet Enable Register (RW)
 *
 * Reset value: 0x00
 *
 * This register enables Gamut metadata (GMD) packet transmission. Packets are inserted in the
 * incoming frame, starting in the line where active Vsync indication starts. After enable of GMD
 * packets the outgoing packet is sent with no_current_gmd active indication until update GMD
 * request is performed in the controller.
 */
typedef union _hw_hdmi_fc_gmd_en
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_en_bitfields
    {
        unsigned char GMDENABLETX : 1; //!< [0] Gamut Metadata packet transmission enable (1b).
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_fc_gmd_en_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_EN register
 */
//@{
#define HW_HDMI_FC_GMD_EN_ADDR      (REGS_HDMI_BASE + 0x1101)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_EN           (*(volatile hw_hdmi_fc_gmd_en_t *) HW_HDMI_FC_GMD_EN_ADDR)
#define HW_HDMI_FC_GMD_EN_RD()      (HW_HDMI_FC_GMD_EN.U)
#define HW_HDMI_FC_GMD_EN_WR(v)     (HW_HDMI_FC_GMD_EN.U = (v))
#define HW_HDMI_FC_GMD_EN_SET(v)    (HW_HDMI_FC_GMD_EN_WR(HW_HDMI_FC_GMD_EN_RD() |  (v)))
#define HW_HDMI_FC_GMD_EN_CLR(v)    (HW_HDMI_FC_GMD_EN_WR(HW_HDMI_FC_GMD_EN_RD() & ~(v)))
#define HW_HDMI_FC_GMD_EN_TOG(v)    (HW_HDMI_FC_GMD_EN_WR(HW_HDMI_FC_GMD_EN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_EN bitfields
 */

/*! @name Register HDMI_FC_GMD_EN, field GMDENABLETX[0] (RW)
 *
 * Gamut Metadata packet transmission enable (1b).
 */
//@{
#define BP_HDMI_FC_GMD_EN_GMDENABLETX      (0)      //!< Bit position for HDMI_FC_GMD_EN_GMDENABLETX.
#define BM_HDMI_FC_GMD_EN_GMDENABLETX      (0x00000001)  //!< Bit mask for HDMI_FC_GMD_EN_GMDENABLETX.

//! @brief Get value of HDMI_FC_GMD_EN_GMDENABLETX from a register value.
#define BG_HDMI_FC_GMD_EN_GMDENABLETX(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_EN_GMDENABLETX) >> BP_HDMI_FC_GMD_EN_GMDENABLETX)

//! @brief Format value for bitfield HDMI_FC_GMD_EN_GMDENABLETX.
#define BF_HDMI_FC_GMD_EN_GMDENABLETX(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_EN_GMDENABLETX) & BM_HDMI_FC_GMD_EN_GMDENABLETX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMDENABLETX field to a new value.
#define BW_HDMI_FC_GMD_EN_GMDENABLETX(v)   (HW_HDMI_FC_GMD_EN_WR((HW_HDMI_FC_GMD_EN_RD() & ~BM_HDMI_FC_GMD_EN_GMDENABLETX) | BF_HDMI_FC_GMD_EN_GMDENABLETX(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_UP - Frame Composer GMD Packet Update Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_UP - Frame Composer GMD Packet Update Register (WO)
 *
 * Reset value: 0x00
 *
 * This register performs an GMD packet content update according to the configured packet body
 * (FC_GMD_PB0 to FC_GMD_PB27) and packet header (FC_GMD_HB). This active high auto clear register
 * reflects the body and header configurations on the GMD packets sent arbitrating the
 * current_gamut_seq_num, gmd_packet_sequence and next_gmd_field bits on packet to correctly
 * indicate to source the Gamut change to be performed. After enable GMD packets the first update
 * request is also responsible for deactivating the no_current_gmd indication bit. Attention packet
 * update request must only be done after correct configuration of GMD packet body and header
 * registers. Correct affected_gamut_seq_num and gmd_profile configuration is user responsibility
 * and must convey with HDMI 1.4a standard gamut rules.
 */
typedef union _hw_hdmi_fc_gmd_up
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_up_bitfields
    {
        unsigned char GMDUPDATEPACKET : 1; //!< [0] Gamut Metadata packet update.
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_fc_gmd_up_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_UP register
 */
//@{
#define HW_HDMI_FC_GMD_UP_ADDR      (REGS_HDMI_BASE + 0x1102)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_UP           (*(volatile hw_hdmi_fc_gmd_up_t *) HW_HDMI_FC_GMD_UP_ADDR)
#define HW_HDMI_FC_GMD_UP_WR(v)     (HW_HDMI_FC_GMD_UP.U = (v))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_UP bitfields
 */

/*! @name Register HDMI_FC_GMD_UP, field GMDUPDATEPACKET[0] (WO)
 *
 * Gamut Metadata packet update.
 */
//@{
#define BP_HDMI_FC_GMD_UP_GMDUPDATEPACKET      (0)      //!< Bit position for HDMI_FC_GMD_UP_GMDUPDATEPACKET.
#define BM_HDMI_FC_GMD_UP_GMDUPDATEPACKET      (0x00000001)  //!< Bit mask for HDMI_FC_GMD_UP_GMDUPDATEPACKET.

//! @brief Get value of HDMI_FC_GMD_UP_GMDUPDATEPACKET from a register value.
#define BG_HDMI_FC_GMD_UP_GMDUPDATEPACKET(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_UP_GMDUPDATEPACKET) >> BP_HDMI_FC_GMD_UP_GMDUPDATEPACKET)

//! @brief Format value for bitfield HDMI_FC_GMD_UP_GMDUPDATEPACKET.
#define BF_HDMI_FC_GMD_UP_GMDUPDATEPACKET(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_UP_GMDUPDATEPACKET) & BM_HDMI_FC_GMD_UP_GMDUPDATEPACKET)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_CONF - Frame Composer GMD Packet Schedule Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_CONF - Frame Composer GMD Packet Schedule Configuration Register (RW)
 *
 * Reset value: 0x10
 *
 * This register configures the number of GMD packets to be inserted per frame (starting always in
 * the line where the active Vsync appears) and the line spacing between the transmitted GMD
 * packets. Note that for profile P0 (refer to HDMI 1.4a spec) this register should only indicate
 * one GMD packet to be inserted per video field.
 */
typedef union _hw_hdmi_fc_gmd_conf
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_conf_bitfields
    {
        unsigned char GMDPACKETLINESPACING : 4; //!< [3:0] Number of line spacing between the transmitted GMD packets
        unsigned char GMDPACKETSINFRAME : 4; //!< [7:4] Number of GMD packets per frame or video field (profile P0)
    } B;
} hw_hdmi_fc_gmd_conf_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_CONF register
 */
//@{
#define HW_HDMI_FC_GMD_CONF_ADDR      (REGS_HDMI_BASE + 0x1103)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_CONF           (*(volatile hw_hdmi_fc_gmd_conf_t *) HW_HDMI_FC_GMD_CONF_ADDR)
#define HW_HDMI_FC_GMD_CONF_RD()      (HW_HDMI_FC_GMD_CONF.U)
#define HW_HDMI_FC_GMD_CONF_WR(v)     (HW_HDMI_FC_GMD_CONF.U = (v))
#define HW_HDMI_FC_GMD_CONF_SET(v)    (HW_HDMI_FC_GMD_CONF_WR(HW_HDMI_FC_GMD_CONF_RD() |  (v)))
#define HW_HDMI_FC_GMD_CONF_CLR(v)    (HW_HDMI_FC_GMD_CONF_WR(HW_HDMI_FC_GMD_CONF_RD() & ~(v)))
#define HW_HDMI_FC_GMD_CONF_TOG(v)    (HW_HDMI_FC_GMD_CONF_WR(HW_HDMI_FC_GMD_CONF_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_CONF bitfields
 */

/*! @name Register HDMI_FC_GMD_CONF, field GMDPACKETLINESPACING[3:0] (RW)
 *
 * Number of line spacing between the transmitted GMD packets
 */
//@{
#define BP_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING      (0)      //!< Bit position for HDMI_FC_GMD_CONF_GMDPACKETLINESPACING.
#define BM_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING      (0x0000000f)  //!< Bit mask for HDMI_FC_GMD_CONF_GMDPACKETLINESPACING.

//! @brief Get value of HDMI_FC_GMD_CONF_GMDPACKETLINESPACING from a register value.
#define BG_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING) >> BP_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING)

//! @brief Format value for bitfield HDMI_FC_GMD_CONF_GMDPACKETLINESPACING.
#define BF_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING) & BM_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMDPACKETLINESPACING field to a new value.
#define BW_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING(v)   (HW_HDMI_FC_GMD_CONF_WR((HW_HDMI_FC_GMD_CONF_RD() & ~BM_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING) | BF_HDMI_FC_GMD_CONF_GMDPACKETLINESPACING(v)))
#endif
//@}

/*! @name Register HDMI_FC_GMD_CONF, field GMDPACKETSINFRAME[7:4] (RW)
 *
 * Number of GMD packets per frame or video field (profile P0)
 */
//@{
#define BP_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME      (4)      //!< Bit position for HDMI_FC_GMD_CONF_GMDPACKETSINFRAME.
#define BM_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME      (0x000000f0)  //!< Bit mask for HDMI_FC_GMD_CONF_GMDPACKETSINFRAME.

//! @brief Get value of HDMI_FC_GMD_CONF_GMDPACKETSINFRAME from a register value.
#define BG_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME) >> BP_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME)

//! @brief Format value for bitfield HDMI_FC_GMD_CONF_GMDPACKETSINFRAME.
#define BF_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME) & BM_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMDPACKETSINFRAME field to a new value.
#define BW_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME(v)   (HW_HDMI_FC_GMD_CONF_WR((HW_HDMI_FC_GMD_CONF_RD() & ~BM_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME) | BF_HDMI_FC_GMD_CONF_GMDPACKETSINFRAME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_HB - Frame Composer GMD Packet Profile and Gamut Sequence Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_HB - Frame Composer GMD Packet Profile and Gamut Sequence Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * This register configures the GMD packet header affected_gamut_seq_num and gmd_profile bits. For
 * more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_hb
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_hb_bitfields
    {
        unsigned char GMDAFFECTED_GAMUT_SEQ_NUM : 4; //!< [3:0] Affected gamut sequence number
        unsigned char GMDGBD_PROFILE : 3; //!< [6:4] GMD profile bits
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_fc_gmd_hb_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_HB register
 */
//@{
#define HW_HDMI_FC_GMD_HB_ADDR      (REGS_HDMI_BASE + 0x1104)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_HB           (*(volatile hw_hdmi_fc_gmd_hb_t *) HW_HDMI_FC_GMD_HB_ADDR)
#define HW_HDMI_FC_GMD_HB_RD()      (HW_HDMI_FC_GMD_HB.U)
#define HW_HDMI_FC_GMD_HB_WR(v)     (HW_HDMI_FC_GMD_HB.U = (v))
#define HW_HDMI_FC_GMD_HB_SET(v)    (HW_HDMI_FC_GMD_HB_WR(HW_HDMI_FC_GMD_HB_RD() |  (v)))
#define HW_HDMI_FC_GMD_HB_CLR(v)    (HW_HDMI_FC_GMD_HB_WR(HW_HDMI_FC_GMD_HB_RD() & ~(v)))
#define HW_HDMI_FC_GMD_HB_TOG(v)    (HW_HDMI_FC_GMD_HB_WR(HW_HDMI_FC_GMD_HB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_HB bitfields
 */

/*! @name Register HDMI_FC_GMD_HB, field GMDAFFECTED_GAMUT_SEQ_NUM[3:0] (RW)
 *
 * Affected gamut sequence number
 */
//@{
#define BP_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM      (0)      //!< Bit position for HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM.
#define BM_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM      (0x0000000f)  //!< Bit mask for HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM.

//! @brief Get value of HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM from a register value.
#define BG_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM) >> BP_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM)

//! @brief Format value for bitfield HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM.
#define BF_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM) & BM_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMDAFFECTED_GAMUT_SEQ_NUM field to a new value.
#define BW_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM(v)   (HW_HDMI_FC_GMD_HB_WR((HW_HDMI_FC_GMD_HB_RD() & ~BM_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM) | BF_HDMI_FC_GMD_HB_GMDAFFECTED_GAMUT_SEQ_NUM(v)))
#endif
//@}

/*! @name Register HDMI_FC_GMD_HB, field GMDGBD_PROFILE[6:4] (RW)
 *
 * GMD profile bits
 */
//@{
#define BP_HDMI_FC_GMD_HB_GMDGBD_PROFILE      (4)      //!< Bit position for HDMI_FC_GMD_HB_GMDGBD_PROFILE.
#define BM_HDMI_FC_GMD_HB_GMDGBD_PROFILE      (0x00000070)  //!< Bit mask for HDMI_FC_GMD_HB_GMDGBD_PROFILE.

//! @brief Get value of HDMI_FC_GMD_HB_GMDGBD_PROFILE from a register value.
#define BG_HDMI_FC_GMD_HB_GMDGBD_PROFILE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_HB_GMDGBD_PROFILE) >> BP_HDMI_FC_GMD_HB_GMDGBD_PROFILE)

//! @brief Format value for bitfield HDMI_FC_GMD_HB_GMDGBD_PROFILE.
#define BF_HDMI_FC_GMD_HB_GMDGBD_PROFILE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_HB_GMDGBD_PROFILE) & BM_HDMI_FC_GMD_HB_GMDGBD_PROFILE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GMDGBD_PROFILE field to a new value.
#define BW_HDMI_FC_GMD_HB_GMDGBD_PROFILE(v)   (HW_HDMI_FC_GMD_HB_WR((HW_HDMI_FC_GMD_HB_RD() & ~BM_HDMI_FC_GMD_HB_GMDGBD_PROFILE) | BF_HDMI_FC_GMD_HB_GMDGBD_PROFILE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB0 - Frame Composer GMD Packet Body Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB0 - Frame Composer GMD Packet Body Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the following contents of the GMD packet: GMD packet body byte0 Address Offset: 0x1105
 * Size: 8 bits Value after Reset: 0x00 Access: Read/Write For more information, refer to the HDMI
 * 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb0
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb0_bitfields
    {
        unsigned char FC_GMD_PB0 : 8; //!< [7:0] Gamut Metadata packet byte0
    } B;
} hw_hdmi_fc_gmd_pb0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB0 register
 */
//@{
#define HW_HDMI_FC_GMD_PB0_ADDR      (REGS_HDMI_BASE + 0x1105)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB0           (*(volatile hw_hdmi_fc_gmd_pb0_t *) HW_HDMI_FC_GMD_PB0_ADDR)
#define HW_HDMI_FC_GMD_PB0_RD()      (HW_HDMI_FC_GMD_PB0.U)
#define HW_HDMI_FC_GMD_PB0_WR(v)     (HW_HDMI_FC_GMD_PB0.U = (v))
#define HW_HDMI_FC_GMD_PB0_SET(v)    (HW_HDMI_FC_GMD_PB0_WR(HW_HDMI_FC_GMD_PB0_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB0_CLR(v)    (HW_HDMI_FC_GMD_PB0_WR(HW_HDMI_FC_GMD_PB0_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB0_TOG(v)    (HW_HDMI_FC_GMD_PB0_WR(HW_HDMI_FC_GMD_PB0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB0 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB0, field FC_GMD_PB0[7:0] (RW)
 *
 * Gamut Metadata packet byte0
 */
//@{
#define BP_HDMI_FC_GMD_PB0_FC_GMD_PB0      (0)      //!< Bit position for HDMI_FC_GMD_PB0_FC_GMD_PB0.
#define BM_HDMI_FC_GMD_PB0_FC_GMD_PB0      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB0_FC_GMD_PB0.

//! @brief Get value of HDMI_FC_GMD_PB0_FC_GMD_PB0 from a register value.
#define BG_HDMI_FC_GMD_PB0_FC_GMD_PB0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB0_FC_GMD_PB0) >> BP_HDMI_FC_GMD_PB0_FC_GMD_PB0)

//! @brief Format value for bitfield HDMI_FC_GMD_PB0_FC_GMD_PB0.
#define BF_HDMI_FC_GMD_PB0_FC_GMD_PB0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB0_FC_GMD_PB0) & BM_HDMI_FC_GMD_PB0_FC_GMD_PB0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB0 field to a new value.
#define BW_HDMI_FC_GMD_PB0_FC_GMD_PB0(v)   (HW_HDMI_FC_GMD_PB0_WR((HW_HDMI_FC_GMD_PB0_RD() & ~BM_HDMI_FC_GMD_PB0_FC_GMD_PB0) | BF_HDMI_FC_GMD_PB0_FC_GMD_PB0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB1 - Frame Composer GMD Packet Body Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB1 - Frame Composer GMD Packet Body Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte1 Address Offset: 0x1106 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb1
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb1_bitfields
    {
        unsigned char FC_GMD_PB1 : 8; //!< [7:0] Gamut Metadata packet byte1
    } B;
} hw_hdmi_fc_gmd_pb1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB1 register
 */
//@{
#define HW_HDMI_FC_GMD_PB1_ADDR      (REGS_HDMI_BASE + 0x1106)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB1           (*(volatile hw_hdmi_fc_gmd_pb1_t *) HW_HDMI_FC_GMD_PB1_ADDR)
#define HW_HDMI_FC_GMD_PB1_RD()      (HW_HDMI_FC_GMD_PB1.U)
#define HW_HDMI_FC_GMD_PB1_WR(v)     (HW_HDMI_FC_GMD_PB1.U = (v))
#define HW_HDMI_FC_GMD_PB1_SET(v)    (HW_HDMI_FC_GMD_PB1_WR(HW_HDMI_FC_GMD_PB1_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB1_CLR(v)    (HW_HDMI_FC_GMD_PB1_WR(HW_HDMI_FC_GMD_PB1_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB1_TOG(v)    (HW_HDMI_FC_GMD_PB1_WR(HW_HDMI_FC_GMD_PB1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB1 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB1, field FC_GMD_PB1[7:0] (RW)
 *
 * Gamut Metadata packet byte1
 */
//@{
#define BP_HDMI_FC_GMD_PB1_FC_GMD_PB1      (0)      //!< Bit position for HDMI_FC_GMD_PB1_FC_GMD_PB1.
#define BM_HDMI_FC_GMD_PB1_FC_GMD_PB1      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB1_FC_GMD_PB1.

//! @brief Get value of HDMI_FC_GMD_PB1_FC_GMD_PB1 from a register value.
#define BG_HDMI_FC_GMD_PB1_FC_GMD_PB1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB1_FC_GMD_PB1) >> BP_HDMI_FC_GMD_PB1_FC_GMD_PB1)

//! @brief Format value for bitfield HDMI_FC_GMD_PB1_FC_GMD_PB1.
#define BF_HDMI_FC_GMD_PB1_FC_GMD_PB1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB1_FC_GMD_PB1) & BM_HDMI_FC_GMD_PB1_FC_GMD_PB1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB1 field to a new value.
#define BW_HDMI_FC_GMD_PB1_FC_GMD_PB1(v)   (HW_HDMI_FC_GMD_PB1_WR((HW_HDMI_FC_GMD_PB1_RD() & ~BM_HDMI_FC_GMD_PB1_FC_GMD_PB1) | BF_HDMI_FC_GMD_PB1_FC_GMD_PB1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB2 - Frame Composer GMD Packet Body Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB2 - Frame Composer GMD Packet Body Register 2 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte2 Address Offset: 0x1107 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb2
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb2_bitfields
    {
        unsigned char FC_GMD_PB2 : 8; //!< [7:0] Gamut Metadata packet byte2
    } B;
} hw_hdmi_fc_gmd_pb2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB2 register
 */
//@{
#define HW_HDMI_FC_GMD_PB2_ADDR      (REGS_HDMI_BASE + 0x1107)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB2           (*(volatile hw_hdmi_fc_gmd_pb2_t *) HW_HDMI_FC_GMD_PB2_ADDR)
#define HW_HDMI_FC_GMD_PB2_RD()      (HW_HDMI_FC_GMD_PB2.U)
#define HW_HDMI_FC_GMD_PB2_WR(v)     (HW_HDMI_FC_GMD_PB2.U = (v))
#define HW_HDMI_FC_GMD_PB2_SET(v)    (HW_HDMI_FC_GMD_PB2_WR(HW_HDMI_FC_GMD_PB2_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB2_CLR(v)    (HW_HDMI_FC_GMD_PB2_WR(HW_HDMI_FC_GMD_PB2_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB2_TOG(v)    (HW_HDMI_FC_GMD_PB2_WR(HW_HDMI_FC_GMD_PB2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB2 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB2, field FC_GMD_PB2[7:0] (RW)
 *
 * Gamut Metadata packet byte2
 */
//@{
#define BP_HDMI_FC_GMD_PB2_FC_GMD_PB2      (0)      //!< Bit position for HDMI_FC_GMD_PB2_FC_GMD_PB2.
#define BM_HDMI_FC_GMD_PB2_FC_GMD_PB2      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB2_FC_GMD_PB2.

//! @brief Get value of HDMI_FC_GMD_PB2_FC_GMD_PB2 from a register value.
#define BG_HDMI_FC_GMD_PB2_FC_GMD_PB2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB2_FC_GMD_PB2) >> BP_HDMI_FC_GMD_PB2_FC_GMD_PB2)

//! @brief Format value for bitfield HDMI_FC_GMD_PB2_FC_GMD_PB2.
#define BF_HDMI_FC_GMD_PB2_FC_GMD_PB2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB2_FC_GMD_PB2) & BM_HDMI_FC_GMD_PB2_FC_GMD_PB2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB2 field to a new value.
#define BW_HDMI_FC_GMD_PB2_FC_GMD_PB2(v)   (HW_HDMI_FC_GMD_PB2_WR((HW_HDMI_FC_GMD_PB2_RD() & ~BM_HDMI_FC_GMD_PB2_FC_GMD_PB2) | BF_HDMI_FC_GMD_PB2_FC_GMD_PB2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB3 - Frame Composer GMD Packet Body Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB3 - Frame Composer GMD Packet Body Register 3 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte3 Address Offset: 0x1108 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb3
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb3_bitfields
    {
        unsigned char FC_GMD_PB3 : 8; //!< [7:0] Gamut Metadata packet byte3
    } B;
} hw_hdmi_fc_gmd_pb3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB3 register
 */
//@{
#define HW_HDMI_FC_GMD_PB3_ADDR      (REGS_HDMI_BASE + 0x1108)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB3           (*(volatile hw_hdmi_fc_gmd_pb3_t *) HW_HDMI_FC_GMD_PB3_ADDR)
#define HW_HDMI_FC_GMD_PB3_RD()      (HW_HDMI_FC_GMD_PB3.U)
#define HW_HDMI_FC_GMD_PB3_WR(v)     (HW_HDMI_FC_GMD_PB3.U = (v))
#define HW_HDMI_FC_GMD_PB3_SET(v)    (HW_HDMI_FC_GMD_PB3_WR(HW_HDMI_FC_GMD_PB3_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB3_CLR(v)    (HW_HDMI_FC_GMD_PB3_WR(HW_HDMI_FC_GMD_PB3_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB3_TOG(v)    (HW_HDMI_FC_GMD_PB3_WR(HW_HDMI_FC_GMD_PB3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB3 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB3, field FC_GMD_PB3[7:0] (RW)
 *
 * Gamut Metadata packet byte3
 */
//@{
#define BP_HDMI_FC_GMD_PB3_FC_GMD_PB3      (0)      //!< Bit position for HDMI_FC_GMD_PB3_FC_GMD_PB3.
#define BM_HDMI_FC_GMD_PB3_FC_GMD_PB3      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB3_FC_GMD_PB3.

//! @brief Get value of HDMI_FC_GMD_PB3_FC_GMD_PB3 from a register value.
#define BG_HDMI_FC_GMD_PB3_FC_GMD_PB3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB3_FC_GMD_PB3) >> BP_HDMI_FC_GMD_PB3_FC_GMD_PB3)

//! @brief Format value for bitfield HDMI_FC_GMD_PB3_FC_GMD_PB3.
#define BF_HDMI_FC_GMD_PB3_FC_GMD_PB3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB3_FC_GMD_PB3) & BM_HDMI_FC_GMD_PB3_FC_GMD_PB3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB3 field to a new value.
#define BW_HDMI_FC_GMD_PB3_FC_GMD_PB3(v)   (HW_HDMI_FC_GMD_PB3_WR((HW_HDMI_FC_GMD_PB3_RD() & ~BM_HDMI_FC_GMD_PB3_FC_GMD_PB3) | BF_HDMI_FC_GMD_PB3_FC_GMD_PB3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB4 - Frame Composer GMD Packet Body Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB4 - Frame Composer GMD Packet Body Register 4 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte4 Address Offset: 0x1109 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb4
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb4_bitfields
    {
        unsigned char FC_GMD_PB4 : 8; //!< [7:0] Gamut Metadata packet byte4
    } B;
} hw_hdmi_fc_gmd_pb4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB4 register
 */
//@{
#define HW_HDMI_FC_GMD_PB4_ADDR      (REGS_HDMI_BASE + 0x1109)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB4           (*(volatile hw_hdmi_fc_gmd_pb4_t *) HW_HDMI_FC_GMD_PB4_ADDR)
#define HW_HDMI_FC_GMD_PB4_RD()      (HW_HDMI_FC_GMD_PB4.U)
#define HW_HDMI_FC_GMD_PB4_WR(v)     (HW_HDMI_FC_GMD_PB4.U = (v))
#define HW_HDMI_FC_GMD_PB4_SET(v)    (HW_HDMI_FC_GMD_PB4_WR(HW_HDMI_FC_GMD_PB4_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB4_CLR(v)    (HW_HDMI_FC_GMD_PB4_WR(HW_HDMI_FC_GMD_PB4_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB4_TOG(v)    (HW_HDMI_FC_GMD_PB4_WR(HW_HDMI_FC_GMD_PB4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB4 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB4, field FC_GMD_PB4[7:0] (RW)
 *
 * Gamut Metadata packet byte4
 */
//@{
#define BP_HDMI_FC_GMD_PB4_FC_GMD_PB4      (0)      //!< Bit position for HDMI_FC_GMD_PB4_FC_GMD_PB4.
#define BM_HDMI_FC_GMD_PB4_FC_GMD_PB4      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB4_FC_GMD_PB4.

//! @brief Get value of HDMI_FC_GMD_PB4_FC_GMD_PB4 from a register value.
#define BG_HDMI_FC_GMD_PB4_FC_GMD_PB4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB4_FC_GMD_PB4) >> BP_HDMI_FC_GMD_PB4_FC_GMD_PB4)

//! @brief Format value for bitfield HDMI_FC_GMD_PB4_FC_GMD_PB4.
#define BF_HDMI_FC_GMD_PB4_FC_GMD_PB4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB4_FC_GMD_PB4) & BM_HDMI_FC_GMD_PB4_FC_GMD_PB4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB4 field to a new value.
#define BW_HDMI_FC_GMD_PB4_FC_GMD_PB4(v)   (HW_HDMI_FC_GMD_PB4_WR((HW_HDMI_FC_GMD_PB4_RD() & ~BM_HDMI_FC_GMD_PB4_FC_GMD_PB4) | BF_HDMI_FC_GMD_PB4_FC_GMD_PB4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB5 - Frame Composer GMD Packet Body Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB5 - Frame Composer GMD Packet Body Register 5 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte5 Address Offset: 0x110a Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb5
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb5_bitfields
    {
        unsigned char FC_GMD_PB5 : 8; //!< [7:0] Gamut Metadata packet byte5
    } B;
} hw_hdmi_fc_gmd_pb5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB5 register
 */
//@{
#define HW_HDMI_FC_GMD_PB5_ADDR      (REGS_HDMI_BASE + 0x110a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB5           (*(volatile hw_hdmi_fc_gmd_pb5_t *) HW_HDMI_FC_GMD_PB5_ADDR)
#define HW_HDMI_FC_GMD_PB5_RD()      (HW_HDMI_FC_GMD_PB5.U)
#define HW_HDMI_FC_GMD_PB5_WR(v)     (HW_HDMI_FC_GMD_PB5.U = (v))
#define HW_HDMI_FC_GMD_PB5_SET(v)    (HW_HDMI_FC_GMD_PB5_WR(HW_HDMI_FC_GMD_PB5_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB5_CLR(v)    (HW_HDMI_FC_GMD_PB5_WR(HW_HDMI_FC_GMD_PB5_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB5_TOG(v)    (HW_HDMI_FC_GMD_PB5_WR(HW_HDMI_FC_GMD_PB5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB5 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB5, field FC_GMD_PB5[7:0] (RW)
 *
 * Gamut Metadata packet byte5
 */
//@{
#define BP_HDMI_FC_GMD_PB5_FC_GMD_PB5      (0)      //!< Bit position for HDMI_FC_GMD_PB5_FC_GMD_PB5.
#define BM_HDMI_FC_GMD_PB5_FC_GMD_PB5      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB5_FC_GMD_PB5.

//! @brief Get value of HDMI_FC_GMD_PB5_FC_GMD_PB5 from a register value.
#define BG_HDMI_FC_GMD_PB5_FC_GMD_PB5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB5_FC_GMD_PB5) >> BP_HDMI_FC_GMD_PB5_FC_GMD_PB5)

//! @brief Format value for bitfield HDMI_FC_GMD_PB5_FC_GMD_PB5.
#define BF_HDMI_FC_GMD_PB5_FC_GMD_PB5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB5_FC_GMD_PB5) & BM_HDMI_FC_GMD_PB5_FC_GMD_PB5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB5 field to a new value.
#define BW_HDMI_FC_GMD_PB5_FC_GMD_PB5(v)   (HW_HDMI_FC_GMD_PB5_WR((HW_HDMI_FC_GMD_PB5_RD() & ~BM_HDMI_FC_GMD_PB5_FC_GMD_PB5) | BF_HDMI_FC_GMD_PB5_FC_GMD_PB5(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB6 - Frame Composer GMD Packet Body Register 6
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB6 - Frame Composer GMD Packet Body Register 6 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte6 Address Offset: 0x110b Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb6
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb6_bitfields
    {
        unsigned char FC_GMD_PB6 : 8; //!< [7:0] Gamut Metadata packet byte6
    } B;
} hw_hdmi_fc_gmd_pb6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB6 register
 */
//@{
#define HW_HDMI_FC_GMD_PB6_ADDR      (REGS_HDMI_BASE + 0x110b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB6           (*(volatile hw_hdmi_fc_gmd_pb6_t *) HW_HDMI_FC_GMD_PB6_ADDR)
#define HW_HDMI_FC_GMD_PB6_RD()      (HW_HDMI_FC_GMD_PB6.U)
#define HW_HDMI_FC_GMD_PB6_WR(v)     (HW_HDMI_FC_GMD_PB6.U = (v))
#define HW_HDMI_FC_GMD_PB6_SET(v)    (HW_HDMI_FC_GMD_PB6_WR(HW_HDMI_FC_GMD_PB6_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB6_CLR(v)    (HW_HDMI_FC_GMD_PB6_WR(HW_HDMI_FC_GMD_PB6_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB6_TOG(v)    (HW_HDMI_FC_GMD_PB6_WR(HW_HDMI_FC_GMD_PB6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB6 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB6, field FC_GMD_PB6[7:0] (RW)
 *
 * Gamut Metadata packet byte6
 */
//@{
#define BP_HDMI_FC_GMD_PB6_FC_GMD_PB6      (0)      //!< Bit position for HDMI_FC_GMD_PB6_FC_GMD_PB6.
#define BM_HDMI_FC_GMD_PB6_FC_GMD_PB6      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB6_FC_GMD_PB6.

//! @brief Get value of HDMI_FC_GMD_PB6_FC_GMD_PB6 from a register value.
#define BG_HDMI_FC_GMD_PB6_FC_GMD_PB6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB6_FC_GMD_PB6) >> BP_HDMI_FC_GMD_PB6_FC_GMD_PB6)

//! @brief Format value for bitfield HDMI_FC_GMD_PB6_FC_GMD_PB6.
#define BF_HDMI_FC_GMD_PB6_FC_GMD_PB6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB6_FC_GMD_PB6) & BM_HDMI_FC_GMD_PB6_FC_GMD_PB6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB6 field to a new value.
#define BW_HDMI_FC_GMD_PB6_FC_GMD_PB6(v)   (HW_HDMI_FC_GMD_PB6_WR((HW_HDMI_FC_GMD_PB6_RD() & ~BM_HDMI_FC_GMD_PB6_FC_GMD_PB6) | BF_HDMI_FC_GMD_PB6_FC_GMD_PB6(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB7 - Frame Composer GMD Packet Body Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB7 - Frame Composer GMD Packet Body Register 7 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte7 Address Offset: 0x110c Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb7
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb7_bitfields
    {
        unsigned char FC_GMD_PB2 : 8; //!< [7:0] Gamut Metadata packet byte7
    } B;
} hw_hdmi_fc_gmd_pb7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB7 register
 */
//@{
#define HW_HDMI_FC_GMD_PB7_ADDR      (REGS_HDMI_BASE + 0x110c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB7           (*(volatile hw_hdmi_fc_gmd_pb7_t *) HW_HDMI_FC_GMD_PB7_ADDR)
#define HW_HDMI_FC_GMD_PB7_RD()      (HW_HDMI_FC_GMD_PB7.U)
#define HW_HDMI_FC_GMD_PB7_WR(v)     (HW_HDMI_FC_GMD_PB7.U = (v))
#define HW_HDMI_FC_GMD_PB7_SET(v)    (HW_HDMI_FC_GMD_PB7_WR(HW_HDMI_FC_GMD_PB7_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB7_CLR(v)    (HW_HDMI_FC_GMD_PB7_WR(HW_HDMI_FC_GMD_PB7_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB7_TOG(v)    (HW_HDMI_FC_GMD_PB7_WR(HW_HDMI_FC_GMD_PB7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB7 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB7, field FC_GMD_PB2[7:0] (RW)
 *
 * Gamut Metadata packet byte7
 */
//@{
#define BP_HDMI_FC_GMD_PB7_FC_GMD_PB2      (0)      //!< Bit position for HDMI_FC_GMD_PB7_FC_GMD_PB2.
#define BM_HDMI_FC_GMD_PB7_FC_GMD_PB2      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB7_FC_GMD_PB2.

//! @brief Get value of HDMI_FC_GMD_PB7_FC_GMD_PB2 from a register value.
#define BG_HDMI_FC_GMD_PB7_FC_GMD_PB2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB7_FC_GMD_PB2) >> BP_HDMI_FC_GMD_PB7_FC_GMD_PB2)

//! @brief Format value for bitfield HDMI_FC_GMD_PB7_FC_GMD_PB2.
#define BF_HDMI_FC_GMD_PB7_FC_GMD_PB2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB7_FC_GMD_PB2) & BM_HDMI_FC_GMD_PB7_FC_GMD_PB2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB2 field to a new value.
#define BW_HDMI_FC_GMD_PB7_FC_GMD_PB2(v)   (HW_HDMI_FC_GMD_PB7_WR((HW_HDMI_FC_GMD_PB7_RD() & ~BM_HDMI_FC_GMD_PB7_FC_GMD_PB2) | BF_HDMI_FC_GMD_PB7_FC_GMD_PB2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB8 - Frame Composer GMD Packet Body Register 8
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB8 - Frame Composer GMD Packet Body Register 8 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte8 Address Offset: 0x110d Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb8
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb8_bitfields
    {
        unsigned char FC_GMD_PB8 : 8; //!< [7:0] Gamut Metadata packet byte8
    } B;
} hw_hdmi_fc_gmd_pb8_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB8 register
 */
//@{
#define HW_HDMI_FC_GMD_PB8_ADDR      (REGS_HDMI_BASE + 0x110d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB8           (*(volatile hw_hdmi_fc_gmd_pb8_t *) HW_HDMI_FC_GMD_PB8_ADDR)
#define HW_HDMI_FC_GMD_PB8_RD()      (HW_HDMI_FC_GMD_PB8.U)
#define HW_HDMI_FC_GMD_PB8_WR(v)     (HW_HDMI_FC_GMD_PB8.U = (v))
#define HW_HDMI_FC_GMD_PB8_SET(v)    (HW_HDMI_FC_GMD_PB8_WR(HW_HDMI_FC_GMD_PB8_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB8_CLR(v)    (HW_HDMI_FC_GMD_PB8_WR(HW_HDMI_FC_GMD_PB8_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB8_TOG(v)    (HW_HDMI_FC_GMD_PB8_WR(HW_HDMI_FC_GMD_PB8_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB8 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB8, field FC_GMD_PB8[7:0] (RW)
 *
 * Gamut Metadata packet byte8
 */
//@{
#define BP_HDMI_FC_GMD_PB8_FC_GMD_PB8      (0)      //!< Bit position for HDMI_FC_GMD_PB8_FC_GMD_PB8.
#define BM_HDMI_FC_GMD_PB8_FC_GMD_PB8      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB8_FC_GMD_PB8.

//! @brief Get value of HDMI_FC_GMD_PB8_FC_GMD_PB8 from a register value.
#define BG_HDMI_FC_GMD_PB8_FC_GMD_PB8(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB8_FC_GMD_PB8) >> BP_HDMI_FC_GMD_PB8_FC_GMD_PB8)

//! @brief Format value for bitfield HDMI_FC_GMD_PB8_FC_GMD_PB8.
#define BF_HDMI_FC_GMD_PB8_FC_GMD_PB8(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB8_FC_GMD_PB8) & BM_HDMI_FC_GMD_PB8_FC_GMD_PB8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB8 field to a new value.
#define BW_HDMI_FC_GMD_PB8_FC_GMD_PB8(v)   (HW_HDMI_FC_GMD_PB8_WR((HW_HDMI_FC_GMD_PB8_RD() & ~BM_HDMI_FC_GMD_PB8_FC_GMD_PB8) | BF_HDMI_FC_GMD_PB8_FC_GMD_PB8(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB9 - Frame Composer GMD Packet Body Register 9
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB9 - Frame Composer GMD Packet Body Register 9 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte9 Address Offset: 0x110e Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb9
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb9_bitfields
    {
        unsigned char FC_GMD_PB9 : 8; //!< [7:0] Gamut Metadata packet byte9
    } B;
} hw_hdmi_fc_gmd_pb9_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB9 register
 */
//@{
#define HW_HDMI_FC_GMD_PB9_ADDR      (REGS_HDMI_BASE + 0x110e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB9           (*(volatile hw_hdmi_fc_gmd_pb9_t *) HW_HDMI_FC_GMD_PB9_ADDR)
#define HW_HDMI_FC_GMD_PB9_RD()      (HW_HDMI_FC_GMD_PB9.U)
#define HW_HDMI_FC_GMD_PB9_WR(v)     (HW_HDMI_FC_GMD_PB9.U = (v))
#define HW_HDMI_FC_GMD_PB9_SET(v)    (HW_HDMI_FC_GMD_PB9_WR(HW_HDMI_FC_GMD_PB9_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB9_CLR(v)    (HW_HDMI_FC_GMD_PB9_WR(HW_HDMI_FC_GMD_PB9_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB9_TOG(v)    (HW_HDMI_FC_GMD_PB9_WR(HW_HDMI_FC_GMD_PB9_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB9 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB9, field FC_GMD_PB9[7:0] (RW)
 *
 * Gamut Metadata packet byte9
 */
//@{
#define BP_HDMI_FC_GMD_PB9_FC_GMD_PB9      (0)      //!< Bit position for HDMI_FC_GMD_PB9_FC_GMD_PB9.
#define BM_HDMI_FC_GMD_PB9_FC_GMD_PB9      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB9_FC_GMD_PB9.

//! @brief Get value of HDMI_FC_GMD_PB9_FC_GMD_PB9 from a register value.
#define BG_HDMI_FC_GMD_PB9_FC_GMD_PB9(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB9_FC_GMD_PB9) >> BP_HDMI_FC_GMD_PB9_FC_GMD_PB9)

//! @brief Format value for bitfield HDMI_FC_GMD_PB9_FC_GMD_PB9.
#define BF_HDMI_FC_GMD_PB9_FC_GMD_PB9(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB9_FC_GMD_PB9) & BM_HDMI_FC_GMD_PB9_FC_GMD_PB9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB9 field to a new value.
#define BW_HDMI_FC_GMD_PB9_FC_GMD_PB9(v)   (HW_HDMI_FC_GMD_PB9_WR((HW_HDMI_FC_GMD_PB9_RD() & ~BM_HDMI_FC_GMD_PB9_FC_GMD_PB9) | BF_HDMI_FC_GMD_PB9_FC_GMD_PB9(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB10 - Frame Composer GMD Packet Body Register 10
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB10 - Frame Composer GMD Packet Body Register 10 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte10 Address Offset: 0x110f Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb10
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb10_bitfields
    {
        unsigned char FC_GMD_PB10 : 8; //!< [7:0] Gamut Metadata packet byte10
    } B;
} hw_hdmi_fc_gmd_pb10_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB10 register
 */
//@{
#define HW_HDMI_FC_GMD_PB10_ADDR      (REGS_HDMI_BASE + 0x110f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB10           (*(volatile hw_hdmi_fc_gmd_pb10_t *) HW_HDMI_FC_GMD_PB10_ADDR)
#define HW_HDMI_FC_GMD_PB10_RD()      (HW_HDMI_FC_GMD_PB10.U)
#define HW_HDMI_FC_GMD_PB10_WR(v)     (HW_HDMI_FC_GMD_PB10.U = (v))
#define HW_HDMI_FC_GMD_PB10_SET(v)    (HW_HDMI_FC_GMD_PB10_WR(HW_HDMI_FC_GMD_PB10_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB10_CLR(v)    (HW_HDMI_FC_GMD_PB10_WR(HW_HDMI_FC_GMD_PB10_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB10_TOG(v)    (HW_HDMI_FC_GMD_PB10_WR(HW_HDMI_FC_GMD_PB10_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB10 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB10, field FC_GMD_PB10[7:0] (RW)
 *
 * Gamut Metadata packet byte10
 */
//@{
#define BP_HDMI_FC_GMD_PB10_FC_GMD_PB10      (0)      //!< Bit position for HDMI_FC_GMD_PB10_FC_GMD_PB10.
#define BM_HDMI_FC_GMD_PB10_FC_GMD_PB10      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB10_FC_GMD_PB10.

//! @brief Get value of HDMI_FC_GMD_PB10_FC_GMD_PB10 from a register value.
#define BG_HDMI_FC_GMD_PB10_FC_GMD_PB10(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB10_FC_GMD_PB10) >> BP_HDMI_FC_GMD_PB10_FC_GMD_PB10)

//! @brief Format value for bitfield HDMI_FC_GMD_PB10_FC_GMD_PB10.
#define BF_HDMI_FC_GMD_PB10_FC_GMD_PB10(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB10_FC_GMD_PB10) & BM_HDMI_FC_GMD_PB10_FC_GMD_PB10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB10 field to a new value.
#define BW_HDMI_FC_GMD_PB10_FC_GMD_PB10(v)   (HW_HDMI_FC_GMD_PB10_WR((HW_HDMI_FC_GMD_PB10_RD() & ~BM_HDMI_FC_GMD_PB10_FC_GMD_PB10) | BF_HDMI_FC_GMD_PB10_FC_GMD_PB10(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB11 - Frame Composer GMD Packet Body Register 11
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB11 - Frame Composer GMD Packet Body Register 11 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte11 Address Offset: 0x1110 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb11
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb11_bitfields
    {
        unsigned char FC_GMD_PB11 : 8; //!< [7:0] Gamut Metadata packet byte11
    } B;
} hw_hdmi_fc_gmd_pb11_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB11 register
 */
//@{
#define HW_HDMI_FC_GMD_PB11_ADDR      (REGS_HDMI_BASE + 0x1110)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB11           (*(volatile hw_hdmi_fc_gmd_pb11_t *) HW_HDMI_FC_GMD_PB11_ADDR)
#define HW_HDMI_FC_GMD_PB11_RD()      (HW_HDMI_FC_GMD_PB11.U)
#define HW_HDMI_FC_GMD_PB11_WR(v)     (HW_HDMI_FC_GMD_PB11.U = (v))
#define HW_HDMI_FC_GMD_PB11_SET(v)    (HW_HDMI_FC_GMD_PB11_WR(HW_HDMI_FC_GMD_PB11_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB11_CLR(v)    (HW_HDMI_FC_GMD_PB11_WR(HW_HDMI_FC_GMD_PB11_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB11_TOG(v)    (HW_HDMI_FC_GMD_PB11_WR(HW_HDMI_FC_GMD_PB11_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB11 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB11, field FC_GMD_PB11[7:0] (RW)
 *
 * Gamut Metadata packet byte11
 */
//@{
#define BP_HDMI_FC_GMD_PB11_FC_GMD_PB11      (0)      //!< Bit position for HDMI_FC_GMD_PB11_FC_GMD_PB11.
#define BM_HDMI_FC_GMD_PB11_FC_GMD_PB11      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB11_FC_GMD_PB11.

//! @brief Get value of HDMI_FC_GMD_PB11_FC_GMD_PB11 from a register value.
#define BG_HDMI_FC_GMD_PB11_FC_GMD_PB11(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB11_FC_GMD_PB11) >> BP_HDMI_FC_GMD_PB11_FC_GMD_PB11)

//! @brief Format value for bitfield HDMI_FC_GMD_PB11_FC_GMD_PB11.
#define BF_HDMI_FC_GMD_PB11_FC_GMD_PB11(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB11_FC_GMD_PB11) & BM_HDMI_FC_GMD_PB11_FC_GMD_PB11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB11 field to a new value.
#define BW_HDMI_FC_GMD_PB11_FC_GMD_PB11(v)   (HW_HDMI_FC_GMD_PB11_WR((HW_HDMI_FC_GMD_PB11_RD() & ~BM_HDMI_FC_GMD_PB11_FC_GMD_PB11) | BF_HDMI_FC_GMD_PB11_FC_GMD_PB11(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB12 - Frame Composer GMD Packet Body Register 12
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB12 - Frame Composer GMD Packet Body Register 12 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte12 Address Offset: 0x1111 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb12
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb12_bitfields
    {
        unsigned char FC_GMD_PB12 : 8; //!< [7:0] Gamut Metadata packet byte12
    } B;
} hw_hdmi_fc_gmd_pb12_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB12 register
 */
//@{
#define HW_HDMI_FC_GMD_PB12_ADDR      (REGS_HDMI_BASE + 0x1111)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB12           (*(volatile hw_hdmi_fc_gmd_pb12_t *) HW_HDMI_FC_GMD_PB12_ADDR)
#define HW_HDMI_FC_GMD_PB12_RD()      (HW_HDMI_FC_GMD_PB12.U)
#define HW_HDMI_FC_GMD_PB12_WR(v)     (HW_HDMI_FC_GMD_PB12.U = (v))
#define HW_HDMI_FC_GMD_PB12_SET(v)    (HW_HDMI_FC_GMD_PB12_WR(HW_HDMI_FC_GMD_PB12_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB12_CLR(v)    (HW_HDMI_FC_GMD_PB12_WR(HW_HDMI_FC_GMD_PB12_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB12_TOG(v)    (HW_HDMI_FC_GMD_PB12_WR(HW_HDMI_FC_GMD_PB12_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB12 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB12, field FC_GMD_PB12[7:0] (RW)
 *
 * Gamut Metadata packet byte12
 */
//@{
#define BP_HDMI_FC_GMD_PB12_FC_GMD_PB12      (0)      //!< Bit position for HDMI_FC_GMD_PB12_FC_GMD_PB12.
#define BM_HDMI_FC_GMD_PB12_FC_GMD_PB12      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB12_FC_GMD_PB12.

//! @brief Get value of HDMI_FC_GMD_PB12_FC_GMD_PB12 from a register value.
#define BG_HDMI_FC_GMD_PB12_FC_GMD_PB12(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB12_FC_GMD_PB12) >> BP_HDMI_FC_GMD_PB12_FC_GMD_PB12)

//! @brief Format value for bitfield HDMI_FC_GMD_PB12_FC_GMD_PB12.
#define BF_HDMI_FC_GMD_PB12_FC_GMD_PB12(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB12_FC_GMD_PB12) & BM_HDMI_FC_GMD_PB12_FC_GMD_PB12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB12 field to a new value.
#define BW_HDMI_FC_GMD_PB12_FC_GMD_PB12(v)   (HW_HDMI_FC_GMD_PB12_WR((HW_HDMI_FC_GMD_PB12_RD() & ~BM_HDMI_FC_GMD_PB12_FC_GMD_PB12) | BF_HDMI_FC_GMD_PB12_FC_GMD_PB12(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB13 - Frame Composer GMD Packet Body Register 13
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB13 - Frame Composer GMD Packet Body Register 13 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte13 Address Offset: 0x1112 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb13
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb13_bitfields
    {
        unsigned char FC_GMD_PB13 : 8; //!< [7:0] Gamut Metadata packet byte13
    } B;
} hw_hdmi_fc_gmd_pb13_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB13 register
 */
//@{
#define HW_HDMI_FC_GMD_PB13_ADDR      (REGS_HDMI_BASE + 0x1112)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB13           (*(volatile hw_hdmi_fc_gmd_pb13_t *) HW_HDMI_FC_GMD_PB13_ADDR)
#define HW_HDMI_FC_GMD_PB13_RD()      (HW_HDMI_FC_GMD_PB13.U)
#define HW_HDMI_FC_GMD_PB13_WR(v)     (HW_HDMI_FC_GMD_PB13.U = (v))
#define HW_HDMI_FC_GMD_PB13_SET(v)    (HW_HDMI_FC_GMD_PB13_WR(HW_HDMI_FC_GMD_PB13_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB13_CLR(v)    (HW_HDMI_FC_GMD_PB13_WR(HW_HDMI_FC_GMD_PB13_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB13_TOG(v)    (HW_HDMI_FC_GMD_PB13_WR(HW_HDMI_FC_GMD_PB13_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB13 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB13, field FC_GMD_PB13[7:0] (RW)
 *
 * Gamut Metadata packet byte13
 */
//@{
#define BP_HDMI_FC_GMD_PB13_FC_GMD_PB13      (0)      //!< Bit position for HDMI_FC_GMD_PB13_FC_GMD_PB13.
#define BM_HDMI_FC_GMD_PB13_FC_GMD_PB13      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB13_FC_GMD_PB13.

//! @brief Get value of HDMI_FC_GMD_PB13_FC_GMD_PB13 from a register value.
#define BG_HDMI_FC_GMD_PB13_FC_GMD_PB13(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB13_FC_GMD_PB13) >> BP_HDMI_FC_GMD_PB13_FC_GMD_PB13)

//! @brief Format value for bitfield HDMI_FC_GMD_PB13_FC_GMD_PB13.
#define BF_HDMI_FC_GMD_PB13_FC_GMD_PB13(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB13_FC_GMD_PB13) & BM_HDMI_FC_GMD_PB13_FC_GMD_PB13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB13 field to a new value.
#define BW_HDMI_FC_GMD_PB13_FC_GMD_PB13(v)   (HW_HDMI_FC_GMD_PB13_WR((HW_HDMI_FC_GMD_PB13_RD() & ~BM_HDMI_FC_GMD_PB13_FC_GMD_PB13) | BF_HDMI_FC_GMD_PB13_FC_GMD_PB13(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB14 - Frame Composer GMD Packet Body Register 14
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB14 - Frame Composer GMD Packet Body Register 14 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte14 Address Offset: 0x1113 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb14
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb14_bitfields
    {
        unsigned char FC_GMD_PB14 : 8; //!< [7:0] Gamut Metadata packet byte14
    } B;
} hw_hdmi_fc_gmd_pb14_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB14 register
 */
//@{
#define HW_HDMI_FC_GMD_PB14_ADDR      (REGS_HDMI_BASE + 0x1113)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB14           (*(volatile hw_hdmi_fc_gmd_pb14_t *) HW_HDMI_FC_GMD_PB14_ADDR)
#define HW_HDMI_FC_GMD_PB14_RD()      (HW_HDMI_FC_GMD_PB14.U)
#define HW_HDMI_FC_GMD_PB14_WR(v)     (HW_HDMI_FC_GMD_PB14.U = (v))
#define HW_HDMI_FC_GMD_PB14_SET(v)    (HW_HDMI_FC_GMD_PB14_WR(HW_HDMI_FC_GMD_PB14_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB14_CLR(v)    (HW_HDMI_FC_GMD_PB14_WR(HW_HDMI_FC_GMD_PB14_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB14_TOG(v)    (HW_HDMI_FC_GMD_PB14_WR(HW_HDMI_FC_GMD_PB14_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB14 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB14, field FC_GMD_PB14[7:0] (RW)
 *
 * Gamut Metadata packet byte14
 */
//@{
#define BP_HDMI_FC_GMD_PB14_FC_GMD_PB14      (0)      //!< Bit position for HDMI_FC_GMD_PB14_FC_GMD_PB14.
#define BM_HDMI_FC_GMD_PB14_FC_GMD_PB14      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB14_FC_GMD_PB14.

//! @brief Get value of HDMI_FC_GMD_PB14_FC_GMD_PB14 from a register value.
#define BG_HDMI_FC_GMD_PB14_FC_GMD_PB14(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB14_FC_GMD_PB14) >> BP_HDMI_FC_GMD_PB14_FC_GMD_PB14)

//! @brief Format value for bitfield HDMI_FC_GMD_PB14_FC_GMD_PB14.
#define BF_HDMI_FC_GMD_PB14_FC_GMD_PB14(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB14_FC_GMD_PB14) & BM_HDMI_FC_GMD_PB14_FC_GMD_PB14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB14 field to a new value.
#define BW_HDMI_FC_GMD_PB14_FC_GMD_PB14(v)   (HW_HDMI_FC_GMD_PB14_WR((HW_HDMI_FC_GMD_PB14_RD() & ~BM_HDMI_FC_GMD_PB14_FC_GMD_PB14) | BF_HDMI_FC_GMD_PB14_FC_GMD_PB14(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB15 - Frame Composer GMD Packet Body Register 15
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB15 - Frame Composer GMD Packet Body Register 15 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte15 Address Offset: 0x1114 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb15
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb15_bitfields
    {
        unsigned char FC_GMD_PB15 : 8; //!< [7:0] Gamut Metadata packet byte15
    } B;
} hw_hdmi_fc_gmd_pb15_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB15 register
 */
//@{
#define HW_HDMI_FC_GMD_PB15_ADDR      (REGS_HDMI_BASE + 0x1114)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB15           (*(volatile hw_hdmi_fc_gmd_pb15_t *) HW_HDMI_FC_GMD_PB15_ADDR)
#define HW_HDMI_FC_GMD_PB15_RD()      (HW_HDMI_FC_GMD_PB15.U)
#define HW_HDMI_FC_GMD_PB15_WR(v)     (HW_HDMI_FC_GMD_PB15.U = (v))
#define HW_HDMI_FC_GMD_PB15_SET(v)    (HW_HDMI_FC_GMD_PB15_WR(HW_HDMI_FC_GMD_PB15_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB15_CLR(v)    (HW_HDMI_FC_GMD_PB15_WR(HW_HDMI_FC_GMD_PB15_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB15_TOG(v)    (HW_HDMI_FC_GMD_PB15_WR(HW_HDMI_FC_GMD_PB15_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB15 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB15, field FC_GMD_PB15[7:0] (RW)
 *
 * Gamut Metadata packet byte15
 */
//@{
#define BP_HDMI_FC_GMD_PB15_FC_GMD_PB15      (0)      //!< Bit position for HDMI_FC_GMD_PB15_FC_GMD_PB15.
#define BM_HDMI_FC_GMD_PB15_FC_GMD_PB15      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB15_FC_GMD_PB15.

//! @brief Get value of HDMI_FC_GMD_PB15_FC_GMD_PB15 from a register value.
#define BG_HDMI_FC_GMD_PB15_FC_GMD_PB15(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB15_FC_GMD_PB15) >> BP_HDMI_FC_GMD_PB15_FC_GMD_PB15)

//! @brief Format value for bitfield HDMI_FC_GMD_PB15_FC_GMD_PB15.
#define BF_HDMI_FC_GMD_PB15_FC_GMD_PB15(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB15_FC_GMD_PB15) & BM_HDMI_FC_GMD_PB15_FC_GMD_PB15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB15 field to a new value.
#define BW_HDMI_FC_GMD_PB15_FC_GMD_PB15(v)   (HW_HDMI_FC_GMD_PB15_WR((HW_HDMI_FC_GMD_PB15_RD() & ~BM_HDMI_FC_GMD_PB15_FC_GMD_PB15) | BF_HDMI_FC_GMD_PB15_FC_GMD_PB15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB16 - Frame Composer GMD Packet Body Register 16
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB16 - Frame Composer GMD Packet Body Register 16 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte16 Address Offset: 0x1115 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb16
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb16_bitfields
    {
        unsigned char FC_GMD_PB16 : 8; //!< [7:0] Gamut Metadata packet byte16
    } B;
} hw_hdmi_fc_gmd_pb16_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB16 register
 */
//@{
#define HW_HDMI_FC_GMD_PB16_ADDR      (REGS_HDMI_BASE + 0x1115)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB16           (*(volatile hw_hdmi_fc_gmd_pb16_t *) HW_HDMI_FC_GMD_PB16_ADDR)
#define HW_HDMI_FC_GMD_PB16_RD()      (HW_HDMI_FC_GMD_PB16.U)
#define HW_HDMI_FC_GMD_PB16_WR(v)     (HW_HDMI_FC_GMD_PB16.U = (v))
#define HW_HDMI_FC_GMD_PB16_SET(v)    (HW_HDMI_FC_GMD_PB16_WR(HW_HDMI_FC_GMD_PB16_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB16_CLR(v)    (HW_HDMI_FC_GMD_PB16_WR(HW_HDMI_FC_GMD_PB16_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB16_TOG(v)    (HW_HDMI_FC_GMD_PB16_WR(HW_HDMI_FC_GMD_PB16_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB16 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB16, field FC_GMD_PB16[7:0] (RW)
 *
 * Gamut Metadata packet byte16
 */
//@{
#define BP_HDMI_FC_GMD_PB16_FC_GMD_PB16      (0)      //!< Bit position for HDMI_FC_GMD_PB16_FC_GMD_PB16.
#define BM_HDMI_FC_GMD_PB16_FC_GMD_PB16      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB16_FC_GMD_PB16.

//! @brief Get value of HDMI_FC_GMD_PB16_FC_GMD_PB16 from a register value.
#define BG_HDMI_FC_GMD_PB16_FC_GMD_PB16(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB16_FC_GMD_PB16) >> BP_HDMI_FC_GMD_PB16_FC_GMD_PB16)

//! @brief Format value for bitfield HDMI_FC_GMD_PB16_FC_GMD_PB16.
#define BF_HDMI_FC_GMD_PB16_FC_GMD_PB16(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB16_FC_GMD_PB16) & BM_HDMI_FC_GMD_PB16_FC_GMD_PB16)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB16 field to a new value.
#define BW_HDMI_FC_GMD_PB16_FC_GMD_PB16(v)   (HW_HDMI_FC_GMD_PB16_WR((HW_HDMI_FC_GMD_PB16_RD() & ~BM_HDMI_FC_GMD_PB16_FC_GMD_PB16) | BF_HDMI_FC_GMD_PB16_FC_GMD_PB16(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB17 - Frame Composer GMD Packet Body Register 17
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB17 - Frame Composer GMD Packet Body Register 17 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte17 Address Offset: 0x1116 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb17
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb17_bitfields
    {
        unsigned char FC_GMD_PB17 : 8; //!< [7:0] Gamut Metadata packet byte17
    } B;
} hw_hdmi_fc_gmd_pb17_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB17 register
 */
//@{
#define HW_HDMI_FC_GMD_PB17_ADDR      (REGS_HDMI_BASE + 0x1116)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB17           (*(volatile hw_hdmi_fc_gmd_pb17_t *) HW_HDMI_FC_GMD_PB17_ADDR)
#define HW_HDMI_FC_GMD_PB17_RD()      (HW_HDMI_FC_GMD_PB17.U)
#define HW_HDMI_FC_GMD_PB17_WR(v)     (HW_HDMI_FC_GMD_PB17.U = (v))
#define HW_HDMI_FC_GMD_PB17_SET(v)    (HW_HDMI_FC_GMD_PB17_WR(HW_HDMI_FC_GMD_PB17_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB17_CLR(v)    (HW_HDMI_FC_GMD_PB17_WR(HW_HDMI_FC_GMD_PB17_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB17_TOG(v)    (HW_HDMI_FC_GMD_PB17_WR(HW_HDMI_FC_GMD_PB17_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB17 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB17, field FC_GMD_PB17[7:0] (RW)
 *
 * Gamut Metadata packet byte17
 */
//@{
#define BP_HDMI_FC_GMD_PB17_FC_GMD_PB17      (0)      //!< Bit position for HDMI_FC_GMD_PB17_FC_GMD_PB17.
#define BM_HDMI_FC_GMD_PB17_FC_GMD_PB17      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB17_FC_GMD_PB17.

//! @brief Get value of HDMI_FC_GMD_PB17_FC_GMD_PB17 from a register value.
#define BG_HDMI_FC_GMD_PB17_FC_GMD_PB17(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB17_FC_GMD_PB17) >> BP_HDMI_FC_GMD_PB17_FC_GMD_PB17)

//! @brief Format value for bitfield HDMI_FC_GMD_PB17_FC_GMD_PB17.
#define BF_HDMI_FC_GMD_PB17_FC_GMD_PB17(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB17_FC_GMD_PB17) & BM_HDMI_FC_GMD_PB17_FC_GMD_PB17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB17 field to a new value.
#define BW_HDMI_FC_GMD_PB17_FC_GMD_PB17(v)   (HW_HDMI_FC_GMD_PB17_WR((HW_HDMI_FC_GMD_PB17_RD() & ~BM_HDMI_FC_GMD_PB17_FC_GMD_PB17) | BF_HDMI_FC_GMD_PB17_FC_GMD_PB17(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB18 - Frame Composer GMD Packet Body Register 18
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB18 - Frame Composer GMD Packet Body Register 18 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte18 Address Offset: 0x1117 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb18
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb18_bitfields
    {
        unsigned char FC_GMD_PB18 : 8; //!< [7:0] Gamut Metadata packet byte18
    } B;
} hw_hdmi_fc_gmd_pb18_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB18 register
 */
//@{
#define HW_HDMI_FC_GMD_PB18_ADDR      (REGS_HDMI_BASE + 0x1117)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB18           (*(volatile hw_hdmi_fc_gmd_pb18_t *) HW_HDMI_FC_GMD_PB18_ADDR)
#define HW_HDMI_FC_GMD_PB18_RD()      (HW_HDMI_FC_GMD_PB18.U)
#define HW_HDMI_FC_GMD_PB18_WR(v)     (HW_HDMI_FC_GMD_PB18.U = (v))
#define HW_HDMI_FC_GMD_PB18_SET(v)    (HW_HDMI_FC_GMD_PB18_WR(HW_HDMI_FC_GMD_PB18_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB18_CLR(v)    (HW_HDMI_FC_GMD_PB18_WR(HW_HDMI_FC_GMD_PB18_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB18_TOG(v)    (HW_HDMI_FC_GMD_PB18_WR(HW_HDMI_FC_GMD_PB18_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB18 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB18, field FC_GMD_PB18[7:0] (RW)
 *
 * Gamut Metadata packet byte18
 */
//@{
#define BP_HDMI_FC_GMD_PB18_FC_GMD_PB18      (0)      //!< Bit position for HDMI_FC_GMD_PB18_FC_GMD_PB18.
#define BM_HDMI_FC_GMD_PB18_FC_GMD_PB18      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB18_FC_GMD_PB18.

//! @brief Get value of HDMI_FC_GMD_PB18_FC_GMD_PB18 from a register value.
#define BG_HDMI_FC_GMD_PB18_FC_GMD_PB18(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB18_FC_GMD_PB18) >> BP_HDMI_FC_GMD_PB18_FC_GMD_PB18)

//! @brief Format value for bitfield HDMI_FC_GMD_PB18_FC_GMD_PB18.
#define BF_HDMI_FC_GMD_PB18_FC_GMD_PB18(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB18_FC_GMD_PB18) & BM_HDMI_FC_GMD_PB18_FC_GMD_PB18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB18 field to a new value.
#define BW_HDMI_FC_GMD_PB18_FC_GMD_PB18(v)   (HW_HDMI_FC_GMD_PB18_WR((HW_HDMI_FC_GMD_PB18_RD() & ~BM_HDMI_FC_GMD_PB18_FC_GMD_PB18) | BF_HDMI_FC_GMD_PB18_FC_GMD_PB18(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB19 - Frame Composer GMD Packet Body Register 19
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB19 - Frame Composer GMD Packet Body Register 19 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte19 Address Offset: 0x1118 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb19
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb19_bitfields
    {
        unsigned char FC_GMD_PB18 : 8; //!< [7:0] Gamut Metadata packet byte18
    } B;
} hw_hdmi_fc_gmd_pb19_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB19 register
 */
//@{
#define HW_HDMI_FC_GMD_PB19_ADDR      (REGS_HDMI_BASE + 0x1118)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB19           (*(volatile hw_hdmi_fc_gmd_pb19_t *) HW_HDMI_FC_GMD_PB19_ADDR)
#define HW_HDMI_FC_GMD_PB19_RD()      (HW_HDMI_FC_GMD_PB19.U)
#define HW_HDMI_FC_GMD_PB19_WR(v)     (HW_HDMI_FC_GMD_PB19.U = (v))
#define HW_HDMI_FC_GMD_PB19_SET(v)    (HW_HDMI_FC_GMD_PB19_WR(HW_HDMI_FC_GMD_PB19_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB19_CLR(v)    (HW_HDMI_FC_GMD_PB19_WR(HW_HDMI_FC_GMD_PB19_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB19_TOG(v)    (HW_HDMI_FC_GMD_PB19_WR(HW_HDMI_FC_GMD_PB19_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB19 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB19, field FC_GMD_PB18[7:0] (RW)
 *
 * Gamut Metadata packet byte18
 */
//@{
#define BP_HDMI_FC_GMD_PB19_FC_GMD_PB18      (0)      //!< Bit position for HDMI_FC_GMD_PB19_FC_GMD_PB18.
#define BM_HDMI_FC_GMD_PB19_FC_GMD_PB18      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB19_FC_GMD_PB18.

//! @brief Get value of HDMI_FC_GMD_PB19_FC_GMD_PB18 from a register value.
#define BG_HDMI_FC_GMD_PB19_FC_GMD_PB18(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB19_FC_GMD_PB18) >> BP_HDMI_FC_GMD_PB19_FC_GMD_PB18)

//! @brief Format value for bitfield HDMI_FC_GMD_PB19_FC_GMD_PB18.
#define BF_HDMI_FC_GMD_PB19_FC_GMD_PB18(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB19_FC_GMD_PB18) & BM_HDMI_FC_GMD_PB19_FC_GMD_PB18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB18 field to a new value.
#define BW_HDMI_FC_GMD_PB19_FC_GMD_PB18(v)   (HW_HDMI_FC_GMD_PB19_WR((HW_HDMI_FC_GMD_PB19_RD() & ~BM_HDMI_FC_GMD_PB19_FC_GMD_PB18) | BF_HDMI_FC_GMD_PB19_FC_GMD_PB18(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB20 - Frame Composer GMD Packet Body Register 20
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB20 - Frame Composer GMD Packet Body Register 20 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte20 Address Offset: 0x1119 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb20
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb20_bitfields
    {
        unsigned char FC_GMD_PB20 : 8; //!< [7:0] Gamut Metadata packet byte20
    } B;
} hw_hdmi_fc_gmd_pb20_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB20 register
 */
//@{
#define HW_HDMI_FC_GMD_PB20_ADDR      (REGS_HDMI_BASE + 0x1119)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB20           (*(volatile hw_hdmi_fc_gmd_pb20_t *) HW_HDMI_FC_GMD_PB20_ADDR)
#define HW_HDMI_FC_GMD_PB20_RD()      (HW_HDMI_FC_GMD_PB20.U)
#define HW_HDMI_FC_GMD_PB20_WR(v)     (HW_HDMI_FC_GMD_PB20.U = (v))
#define HW_HDMI_FC_GMD_PB20_SET(v)    (HW_HDMI_FC_GMD_PB20_WR(HW_HDMI_FC_GMD_PB20_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB20_CLR(v)    (HW_HDMI_FC_GMD_PB20_WR(HW_HDMI_FC_GMD_PB20_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB20_TOG(v)    (HW_HDMI_FC_GMD_PB20_WR(HW_HDMI_FC_GMD_PB20_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB20 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB20, field FC_GMD_PB20[7:0] (RW)
 *
 * Gamut Metadata packet byte20
 */
//@{
#define BP_HDMI_FC_GMD_PB20_FC_GMD_PB20      (0)      //!< Bit position for HDMI_FC_GMD_PB20_FC_GMD_PB20.
#define BM_HDMI_FC_GMD_PB20_FC_GMD_PB20      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB20_FC_GMD_PB20.

//! @brief Get value of HDMI_FC_GMD_PB20_FC_GMD_PB20 from a register value.
#define BG_HDMI_FC_GMD_PB20_FC_GMD_PB20(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB20_FC_GMD_PB20) >> BP_HDMI_FC_GMD_PB20_FC_GMD_PB20)

//! @brief Format value for bitfield HDMI_FC_GMD_PB20_FC_GMD_PB20.
#define BF_HDMI_FC_GMD_PB20_FC_GMD_PB20(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB20_FC_GMD_PB20) & BM_HDMI_FC_GMD_PB20_FC_GMD_PB20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB20 field to a new value.
#define BW_HDMI_FC_GMD_PB20_FC_GMD_PB20(v)   (HW_HDMI_FC_GMD_PB20_WR((HW_HDMI_FC_GMD_PB20_RD() & ~BM_HDMI_FC_GMD_PB20_FC_GMD_PB20) | BF_HDMI_FC_GMD_PB20_FC_GMD_PB20(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB21 - Frame Composer GMD Packet Body Register 21
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB21 - Frame Composer GMD Packet Body Register 21 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte21 Address Offset: 0x111a Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb21
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb21_bitfields
    {
        unsigned char FC_GMD_PB21 : 8; //!< [7:0] Gamut Metadata packet byte21
    } B;
} hw_hdmi_fc_gmd_pb21_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB21 register
 */
//@{
#define HW_HDMI_FC_GMD_PB21_ADDR      (REGS_HDMI_BASE + 0x111a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB21           (*(volatile hw_hdmi_fc_gmd_pb21_t *) HW_HDMI_FC_GMD_PB21_ADDR)
#define HW_HDMI_FC_GMD_PB21_RD()      (HW_HDMI_FC_GMD_PB21.U)
#define HW_HDMI_FC_GMD_PB21_WR(v)     (HW_HDMI_FC_GMD_PB21.U = (v))
#define HW_HDMI_FC_GMD_PB21_SET(v)    (HW_HDMI_FC_GMD_PB21_WR(HW_HDMI_FC_GMD_PB21_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB21_CLR(v)    (HW_HDMI_FC_GMD_PB21_WR(HW_HDMI_FC_GMD_PB21_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB21_TOG(v)    (HW_HDMI_FC_GMD_PB21_WR(HW_HDMI_FC_GMD_PB21_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB21 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB21, field FC_GMD_PB21[7:0] (RW)
 *
 * Gamut Metadata packet byte21
 */
//@{
#define BP_HDMI_FC_GMD_PB21_FC_GMD_PB21      (0)      //!< Bit position for HDMI_FC_GMD_PB21_FC_GMD_PB21.
#define BM_HDMI_FC_GMD_PB21_FC_GMD_PB21      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB21_FC_GMD_PB21.

//! @brief Get value of HDMI_FC_GMD_PB21_FC_GMD_PB21 from a register value.
#define BG_HDMI_FC_GMD_PB21_FC_GMD_PB21(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB21_FC_GMD_PB21) >> BP_HDMI_FC_GMD_PB21_FC_GMD_PB21)

//! @brief Format value for bitfield HDMI_FC_GMD_PB21_FC_GMD_PB21.
#define BF_HDMI_FC_GMD_PB21_FC_GMD_PB21(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB21_FC_GMD_PB21) & BM_HDMI_FC_GMD_PB21_FC_GMD_PB21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB21 field to a new value.
#define BW_HDMI_FC_GMD_PB21_FC_GMD_PB21(v)   (HW_HDMI_FC_GMD_PB21_WR((HW_HDMI_FC_GMD_PB21_RD() & ~BM_HDMI_FC_GMD_PB21_FC_GMD_PB21) | BF_HDMI_FC_GMD_PB21_FC_GMD_PB21(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB22 - Frame Composer GMD Packet Body Register 22
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB22 - Frame Composer GMD Packet Body Register 22 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte22 Address Offset: 0x111b Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb22
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb22_bitfields
    {
        unsigned char FC_GMD_PB22 : 8; //!< [7:0] Gamut Metadata packet byte22
    } B;
} hw_hdmi_fc_gmd_pb22_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB22 register
 */
//@{
#define HW_HDMI_FC_GMD_PB22_ADDR      (REGS_HDMI_BASE + 0x111b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB22           (*(volatile hw_hdmi_fc_gmd_pb22_t *) HW_HDMI_FC_GMD_PB22_ADDR)
#define HW_HDMI_FC_GMD_PB22_RD()      (HW_HDMI_FC_GMD_PB22.U)
#define HW_HDMI_FC_GMD_PB22_WR(v)     (HW_HDMI_FC_GMD_PB22.U = (v))
#define HW_HDMI_FC_GMD_PB22_SET(v)    (HW_HDMI_FC_GMD_PB22_WR(HW_HDMI_FC_GMD_PB22_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB22_CLR(v)    (HW_HDMI_FC_GMD_PB22_WR(HW_HDMI_FC_GMD_PB22_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB22_TOG(v)    (HW_HDMI_FC_GMD_PB22_WR(HW_HDMI_FC_GMD_PB22_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB22 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB22, field FC_GMD_PB22[7:0] (RW)
 *
 * Gamut Metadata packet byte22
 */
//@{
#define BP_HDMI_FC_GMD_PB22_FC_GMD_PB22      (0)      //!< Bit position for HDMI_FC_GMD_PB22_FC_GMD_PB22.
#define BM_HDMI_FC_GMD_PB22_FC_GMD_PB22      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB22_FC_GMD_PB22.

//! @brief Get value of HDMI_FC_GMD_PB22_FC_GMD_PB22 from a register value.
#define BG_HDMI_FC_GMD_PB22_FC_GMD_PB22(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB22_FC_GMD_PB22) >> BP_HDMI_FC_GMD_PB22_FC_GMD_PB22)

//! @brief Format value for bitfield HDMI_FC_GMD_PB22_FC_GMD_PB22.
#define BF_HDMI_FC_GMD_PB22_FC_GMD_PB22(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB22_FC_GMD_PB22) & BM_HDMI_FC_GMD_PB22_FC_GMD_PB22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB22 field to a new value.
#define BW_HDMI_FC_GMD_PB22_FC_GMD_PB22(v)   (HW_HDMI_FC_GMD_PB22_WR((HW_HDMI_FC_GMD_PB22_RD() & ~BM_HDMI_FC_GMD_PB22_FC_GMD_PB22) | BF_HDMI_FC_GMD_PB22_FC_GMD_PB22(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB23 - Frame Composer GMD Packet Body Register 23
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB23 - Frame Composer GMD Packet Body Register 23 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte23 Address Offset: 0x111c Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb23
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb23_bitfields
    {
        unsigned char FC_GMD_PB23 : 8; //!< [7:0] Gamut Metadata packet byte23
    } B;
} hw_hdmi_fc_gmd_pb23_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB23 register
 */
//@{
#define HW_HDMI_FC_GMD_PB23_ADDR      (REGS_HDMI_BASE + 0x111c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB23           (*(volatile hw_hdmi_fc_gmd_pb23_t *) HW_HDMI_FC_GMD_PB23_ADDR)
#define HW_HDMI_FC_GMD_PB23_RD()      (HW_HDMI_FC_GMD_PB23.U)
#define HW_HDMI_FC_GMD_PB23_WR(v)     (HW_HDMI_FC_GMD_PB23.U = (v))
#define HW_HDMI_FC_GMD_PB23_SET(v)    (HW_HDMI_FC_GMD_PB23_WR(HW_HDMI_FC_GMD_PB23_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB23_CLR(v)    (HW_HDMI_FC_GMD_PB23_WR(HW_HDMI_FC_GMD_PB23_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB23_TOG(v)    (HW_HDMI_FC_GMD_PB23_WR(HW_HDMI_FC_GMD_PB23_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB23 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB23, field FC_GMD_PB23[7:0] (RW)
 *
 * Gamut Metadata packet byte23
 */
//@{
#define BP_HDMI_FC_GMD_PB23_FC_GMD_PB23      (0)      //!< Bit position for HDMI_FC_GMD_PB23_FC_GMD_PB23.
#define BM_HDMI_FC_GMD_PB23_FC_GMD_PB23      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB23_FC_GMD_PB23.

//! @brief Get value of HDMI_FC_GMD_PB23_FC_GMD_PB23 from a register value.
#define BG_HDMI_FC_GMD_PB23_FC_GMD_PB23(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB23_FC_GMD_PB23) >> BP_HDMI_FC_GMD_PB23_FC_GMD_PB23)

//! @brief Format value for bitfield HDMI_FC_GMD_PB23_FC_GMD_PB23.
#define BF_HDMI_FC_GMD_PB23_FC_GMD_PB23(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB23_FC_GMD_PB23) & BM_HDMI_FC_GMD_PB23_FC_GMD_PB23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB23 field to a new value.
#define BW_HDMI_FC_GMD_PB23_FC_GMD_PB23(v)   (HW_HDMI_FC_GMD_PB23_WR((HW_HDMI_FC_GMD_PB23_RD() & ~BM_HDMI_FC_GMD_PB23_FC_GMD_PB23) | BF_HDMI_FC_GMD_PB23_FC_GMD_PB23(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB24 - Frame Composer GMD Packet Body Register 24
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB24 - Frame Composer GMD Packet Body Register 24 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte24 Address Offset: 0x111d Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb24
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb24_bitfields
    {
        unsigned char FC_GMD_PB24 : 8; //!< [7:0] Gamut Metadata packet byte24
    } B;
} hw_hdmi_fc_gmd_pb24_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB24 register
 */
//@{
#define HW_HDMI_FC_GMD_PB24_ADDR      (REGS_HDMI_BASE + 0x111d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB24           (*(volatile hw_hdmi_fc_gmd_pb24_t *) HW_HDMI_FC_GMD_PB24_ADDR)
#define HW_HDMI_FC_GMD_PB24_RD()      (HW_HDMI_FC_GMD_PB24.U)
#define HW_HDMI_FC_GMD_PB24_WR(v)     (HW_HDMI_FC_GMD_PB24.U = (v))
#define HW_HDMI_FC_GMD_PB24_SET(v)    (HW_HDMI_FC_GMD_PB24_WR(HW_HDMI_FC_GMD_PB24_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB24_CLR(v)    (HW_HDMI_FC_GMD_PB24_WR(HW_HDMI_FC_GMD_PB24_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB24_TOG(v)    (HW_HDMI_FC_GMD_PB24_WR(HW_HDMI_FC_GMD_PB24_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB24 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB24, field FC_GMD_PB24[7:0] (RW)
 *
 * Gamut Metadata packet byte24
 */
//@{
#define BP_HDMI_FC_GMD_PB24_FC_GMD_PB24      (0)      //!< Bit position for HDMI_FC_GMD_PB24_FC_GMD_PB24.
#define BM_HDMI_FC_GMD_PB24_FC_GMD_PB24      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB24_FC_GMD_PB24.

//! @brief Get value of HDMI_FC_GMD_PB24_FC_GMD_PB24 from a register value.
#define BG_HDMI_FC_GMD_PB24_FC_GMD_PB24(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB24_FC_GMD_PB24) >> BP_HDMI_FC_GMD_PB24_FC_GMD_PB24)

//! @brief Format value for bitfield HDMI_FC_GMD_PB24_FC_GMD_PB24.
#define BF_HDMI_FC_GMD_PB24_FC_GMD_PB24(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB24_FC_GMD_PB24) & BM_HDMI_FC_GMD_PB24_FC_GMD_PB24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB24 field to a new value.
#define BW_HDMI_FC_GMD_PB24_FC_GMD_PB24(v)   (HW_HDMI_FC_GMD_PB24_WR((HW_HDMI_FC_GMD_PB24_RD() & ~BM_HDMI_FC_GMD_PB24_FC_GMD_PB24) | BF_HDMI_FC_GMD_PB24_FC_GMD_PB24(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB25 - Frame Composer GMD Packet Body Register 25
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB25 - Frame Composer GMD Packet Body Register 25 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte25 Address Offset: 0x111e Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb25
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb25_bitfields
    {
        unsigned char FC_GMD_PB25 : 8; //!< [7:0] Gamut Metadata packet byte25
    } B;
} hw_hdmi_fc_gmd_pb25_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB25 register
 */
//@{
#define HW_HDMI_FC_GMD_PB25_ADDR      (REGS_HDMI_BASE + 0x111e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB25           (*(volatile hw_hdmi_fc_gmd_pb25_t *) HW_HDMI_FC_GMD_PB25_ADDR)
#define HW_HDMI_FC_GMD_PB25_RD()      (HW_HDMI_FC_GMD_PB25.U)
#define HW_HDMI_FC_GMD_PB25_WR(v)     (HW_HDMI_FC_GMD_PB25.U = (v))
#define HW_HDMI_FC_GMD_PB25_SET(v)    (HW_HDMI_FC_GMD_PB25_WR(HW_HDMI_FC_GMD_PB25_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB25_CLR(v)    (HW_HDMI_FC_GMD_PB25_WR(HW_HDMI_FC_GMD_PB25_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB25_TOG(v)    (HW_HDMI_FC_GMD_PB25_WR(HW_HDMI_FC_GMD_PB25_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB25 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB25, field FC_GMD_PB25[7:0] (RW)
 *
 * Gamut Metadata packet byte25
 */
//@{
#define BP_HDMI_FC_GMD_PB25_FC_GMD_PB25      (0)      //!< Bit position for HDMI_FC_GMD_PB25_FC_GMD_PB25.
#define BM_HDMI_FC_GMD_PB25_FC_GMD_PB25      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB25_FC_GMD_PB25.

//! @brief Get value of HDMI_FC_GMD_PB25_FC_GMD_PB25 from a register value.
#define BG_HDMI_FC_GMD_PB25_FC_GMD_PB25(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB25_FC_GMD_PB25) >> BP_HDMI_FC_GMD_PB25_FC_GMD_PB25)

//! @brief Format value for bitfield HDMI_FC_GMD_PB25_FC_GMD_PB25.
#define BF_HDMI_FC_GMD_PB25_FC_GMD_PB25(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB25_FC_GMD_PB25) & BM_HDMI_FC_GMD_PB25_FC_GMD_PB25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB25 field to a new value.
#define BW_HDMI_FC_GMD_PB25_FC_GMD_PB25(v)   (HW_HDMI_FC_GMD_PB25_WR((HW_HDMI_FC_GMD_PB25_RD() & ~BM_HDMI_FC_GMD_PB25_FC_GMD_PB25) | BF_HDMI_FC_GMD_PB25_FC_GMD_PB25(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB26 - Frame Composer GMD Packet Body Register 26
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB26 - Frame Composer GMD Packet Body Register 26 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte26 Address Offset: 0x111f Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb26
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb26_bitfields
    {
        unsigned char FC_GMD_PB26 : 8; //!< [7:0] Gamut Metadata packet byte26
    } B;
} hw_hdmi_fc_gmd_pb26_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB26 register
 */
//@{
#define HW_HDMI_FC_GMD_PB26_ADDR      (REGS_HDMI_BASE + 0x111f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB26           (*(volatile hw_hdmi_fc_gmd_pb26_t *) HW_HDMI_FC_GMD_PB26_ADDR)
#define HW_HDMI_FC_GMD_PB26_RD()      (HW_HDMI_FC_GMD_PB26.U)
#define HW_HDMI_FC_GMD_PB26_WR(v)     (HW_HDMI_FC_GMD_PB26.U = (v))
#define HW_HDMI_FC_GMD_PB26_SET(v)    (HW_HDMI_FC_GMD_PB26_WR(HW_HDMI_FC_GMD_PB26_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB26_CLR(v)    (HW_HDMI_FC_GMD_PB26_WR(HW_HDMI_FC_GMD_PB26_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB26_TOG(v)    (HW_HDMI_FC_GMD_PB26_WR(HW_HDMI_FC_GMD_PB26_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB26 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB26, field FC_GMD_PB26[7:0] (RW)
 *
 * Gamut Metadata packet byte26
 */
//@{
#define BP_HDMI_FC_GMD_PB26_FC_GMD_PB26      (0)      //!< Bit position for HDMI_FC_GMD_PB26_FC_GMD_PB26.
#define BM_HDMI_FC_GMD_PB26_FC_GMD_PB26      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB26_FC_GMD_PB26.

//! @brief Get value of HDMI_FC_GMD_PB26_FC_GMD_PB26 from a register value.
#define BG_HDMI_FC_GMD_PB26_FC_GMD_PB26(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB26_FC_GMD_PB26) >> BP_HDMI_FC_GMD_PB26_FC_GMD_PB26)

//! @brief Format value for bitfield HDMI_FC_GMD_PB26_FC_GMD_PB26.
#define BF_HDMI_FC_GMD_PB26_FC_GMD_PB26(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB26_FC_GMD_PB26) & BM_HDMI_FC_GMD_PB26_FC_GMD_PB26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB26 field to a new value.
#define BW_HDMI_FC_GMD_PB26_FC_GMD_PB26(v)   (HW_HDMI_FC_GMD_PB26_WR((HW_HDMI_FC_GMD_PB26_RD() & ~BM_HDMI_FC_GMD_PB26_FC_GMD_PB26) | BF_HDMI_FC_GMD_PB26_FC_GMD_PB26(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_GMD_PB27 - Frame Composer GMD Packet Body Register 27
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_GMD_PB27 - Frame Composer GMD Packet Body Register 27 (RW)
 *
 * Reset value: 0x00
 *
 * GMD packet body byte27 Address Offset: 0x1120 Size: 8 bits Value after Reset: 0x00 Access:
 * Read/Write For more information, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_fc_gmd_pb27
{
    reg8_t U;
    struct _hw_hdmi_fc_gmd_pb27_bitfields
    {
        unsigned char FC_GMD_PB27 : 8; //!< [7:0] Gamut Metadata packet byte27
    } B;
} hw_hdmi_fc_gmd_pb27_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_GMD_PB27 register
 */
//@{
#define HW_HDMI_FC_GMD_PB27_ADDR      (REGS_HDMI_BASE + 0x1120)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_GMD_PB27           (*(volatile hw_hdmi_fc_gmd_pb27_t *) HW_HDMI_FC_GMD_PB27_ADDR)
#define HW_HDMI_FC_GMD_PB27_RD()      (HW_HDMI_FC_GMD_PB27.U)
#define HW_HDMI_FC_GMD_PB27_WR(v)     (HW_HDMI_FC_GMD_PB27.U = (v))
#define HW_HDMI_FC_GMD_PB27_SET(v)    (HW_HDMI_FC_GMD_PB27_WR(HW_HDMI_FC_GMD_PB27_RD() |  (v)))
#define HW_HDMI_FC_GMD_PB27_CLR(v)    (HW_HDMI_FC_GMD_PB27_WR(HW_HDMI_FC_GMD_PB27_RD() & ~(v)))
#define HW_HDMI_FC_GMD_PB27_TOG(v)    (HW_HDMI_FC_GMD_PB27_WR(HW_HDMI_FC_GMD_PB27_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_GMD_PB27 bitfields
 */

/*! @name Register HDMI_FC_GMD_PB27, field FC_GMD_PB27[7:0] (RW)
 *
 * Gamut Metadata packet byte27
 */
//@{
#define BP_HDMI_FC_GMD_PB27_FC_GMD_PB27      (0)      //!< Bit position for HDMI_FC_GMD_PB27_FC_GMD_PB27.
#define BM_HDMI_FC_GMD_PB27_FC_GMD_PB27      (0x000000ff)  //!< Bit mask for HDMI_FC_GMD_PB27_FC_GMD_PB27.

//! @brief Get value of HDMI_FC_GMD_PB27_FC_GMD_PB27 from a register value.
#define BG_HDMI_FC_GMD_PB27_FC_GMD_PB27(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_GMD_PB27_FC_GMD_PB27) >> BP_HDMI_FC_GMD_PB27_FC_GMD_PB27)

//! @brief Format value for bitfield HDMI_FC_GMD_PB27_FC_GMD_PB27.
#define BF_HDMI_FC_GMD_PB27_FC_GMD_PB27(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_GMD_PB27_FC_GMD_PB27) & BM_HDMI_FC_GMD_PB27_FC_GMD_PB27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_GMD_PB27 field to a new value.
#define BW_HDMI_FC_GMD_PB27_FC_GMD_PB27(v)   (HW_HDMI_FC_GMD_PB27_WR((HW_HDMI_FC_GMD_PB27_RD() & ~BM_HDMI_FC_GMD_PB27_FC_GMD_PB27) | BF_HDMI_FC_GMD_PB27_FC_GMD_PB27(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGFORCE - Frame Composer Video/Audio Force Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGFORCE - Frame Composer Video/Audio Force Enable Register (RW)
 *
 * Reset value: 0x00
 *
 * This register allows to force the controller to output audio and video data the values configured
 * in the FC_DBGAUD and FC_DBGTMDS registers.
 */
typedef union _hw_hdmi_fc_dbgforce
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgforce_bitfields
    {
        unsigned char FORCEVIDEO : 1; //!< [0] Force fixed video output with FC_DBGTMDSx registers contain.
        unsigned char RESERVED0 : 3; //!< [3:1] Reserved
        unsigned char FORCEAUDIO : 1; //!< [4] Force fixed audio output with FC_DBGAUDxCHx registers contain.
        unsigned char RESERVED1 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_fc_dbgforce_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGFORCE register
 */
//@{
#define HW_HDMI_FC_DBGFORCE_ADDR      (REGS_HDMI_BASE + 0x1200)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGFORCE           (*(volatile hw_hdmi_fc_dbgforce_t *) HW_HDMI_FC_DBGFORCE_ADDR)
#define HW_HDMI_FC_DBGFORCE_RD()      (HW_HDMI_FC_DBGFORCE.U)
#define HW_HDMI_FC_DBGFORCE_WR(v)     (HW_HDMI_FC_DBGFORCE.U = (v))
#define HW_HDMI_FC_DBGFORCE_SET(v)    (HW_HDMI_FC_DBGFORCE_WR(HW_HDMI_FC_DBGFORCE_RD() |  (v)))
#define HW_HDMI_FC_DBGFORCE_CLR(v)    (HW_HDMI_FC_DBGFORCE_WR(HW_HDMI_FC_DBGFORCE_RD() & ~(v)))
#define HW_HDMI_FC_DBGFORCE_TOG(v)    (HW_HDMI_FC_DBGFORCE_WR(HW_HDMI_FC_DBGFORCE_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGFORCE bitfields
 */

/*! @name Register HDMI_FC_DBGFORCE, field FORCEVIDEO[0] (RW)
 *
 * Force fixed video output with FC_DBGTMDSx registers contain.
 */
//@{
#define BP_HDMI_FC_DBGFORCE_FORCEVIDEO      (0)      //!< Bit position for HDMI_FC_DBGFORCE_FORCEVIDEO.
#define BM_HDMI_FC_DBGFORCE_FORCEVIDEO      (0x00000001)  //!< Bit mask for HDMI_FC_DBGFORCE_FORCEVIDEO.

//! @brief Get value of HDMI_FC_DBGFORCE_FORCEVIDEO from a register value.
#define BG_HDMI_FC_DBGFORCE_FORCEVIDEO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGFORCE_FORCEVIDEO) >> BP_HDMI_FC_DBGFORCE_FORCEVIDEO)

//! @brief Format value for bitfield HDMI_FC_DBGFORCE_FORCEVIDEO.
#define BF_HDMI_FC_DBGFORCE_FORCEVIDEO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGFORCE_FORCEVIDEO) & BM_HDMI_FC_DBGFORCE_FORCEVIDEO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FORCEVIDEO field to a new value.
#define BW_HDMI_FC_DBGFORCE_FORCEVIDEO(v)   (HW_HDMI_FC_DBGFORCE_WR((HW_HDMI_FC_DBGFORCE_RD() & ~BM_HDMI_FC_DBGFORCE_FORCEVIDEO) | BF_HDMI_FC_DBGFORCE_FORCEVIDEO(v)))
#endif
//@}

/*! @name Register HDMI_FC_DBGFORCE, field FORCEAUDIO[4] (RW)
 *
 * Force fixed audio output with FC_DBGAUDxCHx registers contain.
 */
//@{
#define BP_HDMI_FC_DBGFORCE_FORCEAUDIO      (4)      //!< Bit position for HDMI_FC_DBGFORCE_FORCEAUDIO.
#define BM_HDMI_FC_DBGFORCE_FORCEAUDIO      (0x00000010)  //!< Bit mask for HDMI_FC_DBGFORCE_FORCEAUDIO.

//! @brief Get value of HDMI_FC_DBGFORCE_FORCEAUDIO from a register value.
#define BG_HDMI_FC_DBGFORCE_FORCEAUDIO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGFORCE_FORCEAUDIO) >> BP_HDMI_FC_DBGFORCE_FORCEAUDIO)

//! @brief Format value for bitfield HDMI_FC_DBGFORCE_FORCEAUDIO.
#define BF_HDMI_FC_DBGFORCE_FORCEAUDIO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGFORCE_FORCEAUDIO) & BM_HDMI_FC_DBGFORCE_FORCEAUDIO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FORCEAUDIO field to a new value.
#define BW_HDMI_FC_DBGFORCE_FORCEAUDIO(v)   (HW_HDMI_FC_DBGFORCE_WR((HW_HDMI_FC_DBGFORCE_RD() & ~BM_HDMI_FC_DBGFORCE_FORCEAUDIO) | BF_HDMI_FC_DBGFORCE_FORCEAUDIO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH0 - Frame Composer Audio Channel 0 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH0 - Frame Composer Audio Channel 0 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch0
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch0_bitfields
    {
        unsigned char FC_DBGAUD0CH0 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH0 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH0_ADDR      (REGS_HDMI_BASE + 0x1201)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH0           (*(volatile hw_hdmi_fc_dbgaud0ch0_t *) HW_HDMI_FC_DBGAUD0CH0_ADDR)
#define HW_HDMI_FC_DBGAUD0CH0_RD()      (HW_HDMI_FC_DBGAUD0CH0.U)
#define HW_HDMI_FC_DBGAUD0CH0_WR(v)     (HW_HDMI_FC_DBGAUD0CH0.U = (v))
#define HW_HDMI_FC_DBGAUD0CH0_SET(v)    (HW_HDMI_FC_DBGAUD0CH0_WR(HW_HDMI_FC_DBGAUD0CH0_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH0_CLR(v)    (HW_HDMI_FC_DBGAUD0CH0_WR(HW_HDMI_FC_DBGAUD0CH0_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH0_TOG(v)    (HW_HDMI_FC_DBGAUD0CH0_WR(HW_HDMI_FC_DBGAUD0CH0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH0 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH0, field FC_DBGAUD0CH0[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0.
#define BM_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0.

//! @brief Get value of HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0 from a register value.
#define BG_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0) >> BP_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0.
#define BF_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0) & BM_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH0 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0(v)   (HW_HDMI_FC_DBGAUD0CH0_WR((HW_HDMI_FC_DBGAUD0CH0_RD() & ~BM_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0) | BF_HDMI_FC_DBGAUD0CH0_FC_DBGAUD0CH0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH0 - Frame Composer Audio Channel 0 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH0 - Frame Composer Audio Channel 0 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch0
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch0_bitfields
    {
        unsigned char FC_DBGAUD1CH0 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH0 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH0_ADDR      (REGS_HDMI_BASE + 0x1202)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH0           (*(volatile hw_hdmi_fc_dbgaud1ch0_t *) HW_HDMI_FC_DBGAUD1CH0_ADDR)
#define HW_HDMI_FC_DBGAUD1CH0_RD()      (HW_HDMI_FC_DBGAUD1CH0.U)
#define HW_HDMI_FC_DBGAUD1CH0_WR(v)     (HW_HDMI_FC_DBGAUD1CH0.U = (v))
#define HW_HDMI_FC_DBGAUD1CH0_SET(v)    (HW_HDMI_FC_DBGAUD1CH0_WR(HW_HDMI_FC_DBGAUD1CH0_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH0_CLR(v)    (HW_HDMI_FC_DBGAUD1CH0_WR(HW_HDMI_FC_DBGAUD1CH0_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH0_TOG(v)    (HW_HDMI_FC_DBGAUD1CH0_WR(HW_HDMI_FC_DBGAUD1CH0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH0 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH0, field FC_DBGAUD1CH0[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0.
#define BM_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0.

//! @brief Get value of HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0 from a register value.
#define BG_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0) >> BP_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0.
#define BF_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0) & BM_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH0 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0(v)   (HW_HDMI_FC_DBGAUD1CH0_WR((HW_HDMI_FC_DBGAUD1CH0_RD() & ~BM_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0) | BF_HDMI_FC_DBGAUD1CH0_FC_DBGAUD1CH0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH0 - Frame Composer Audio Channel 0 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH0 - Frame Composer Audio Channel 0 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch0
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch0_bitfields
    {
        unsigned char FC_DBGAUD2CH0 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH0 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH0_ADDR      (REGS_HDMI_BASE + 0x1203)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH0           (*(volatile hw_hdmi_fc_dbgaud2ch0_t *) HW_HDMI_FC_DBGAUD2CH0_ADDR)
#define HW_HDMI_FC_DBGAUD2CH0_RD()      (HW_HDMI_FC_DBGAUD2CH0.U)
#define HW_HDMI_FC_DBGAUD2CH0_WR(v)     (HW_HDMI_FC_DBGAUD2CH0.U = (v))
#define HW_HDMI_FC_DBGAUD2CH0_SET(v)    (HW_HDMI_FC_DBGAUD2CH0_WR(HW_HDMI_FC_DBGAUD2CH0_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH0_CLR(v)    (HW_HDMI_FC_DBGAUD2CH0_WR(HW_HDMI_FC_DBGAUD2CH0_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH0_TOG(v)    (HW_HDMI_FC_DBGAUD2CH0_WR(HW_HDMI_FC_DBGAUD2CH0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH0 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH0, field FC_DBGAUD2CH0[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0.
#define BM_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0.

//! @brief Get value of HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0 from a register value.
#define BG_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0) >> BP_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0.
#define BF_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0) & BM_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH0 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0(v)   (HW_HDMI_FC_DBGAUD2CH0_WR((HW_HDMI_FC_DBGAUD2CH0_RD() & ~BM_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0) | BF_HDMI_FC_DBGAUD2CH0_FC_DBGAUD2CH0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH1 - Frame Composer Audio Channel 1 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH1 - Frame Composer Audio Channel 1 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch1
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch1_bitfields
    {
        unsigned char FC_DBGAUD0CH1 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH1 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH1_ADDR      (REGS_HDMI_BASE + 0x1204)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH1           (*(volatile hw_hdmi_fc_dbgaud0ch1_t *) HW_HDMI_FC_DBGAUD0CH1_ADDR)
#define HW_HDMI_FC_DBGAUD0CH1_RD()      (HW_HDMI_FC_DBGAUD0CH1.U)
#define HW_HDMI_FC_DBGAUD0CH1_WR(v)     (HW_HDMI_FC_DBGAUD0CH1.U = (v))
#define HW_HDMI_FC_DBGAUD0CH1_SET(v)    (HW_HDMI_FC_DBGAUD0CH1_WR(HW_HDMI_FC_DBGAUD0CH1_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH1_CLR(v)    (HW_HDMI_FC_DBGAUD0CH1_WR(HW_HDMI_FC_DBGAUD0CH1_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH1_TOG(v)    (HW_HDMI_FC_DBGAUD0CH1_WR(HW_HDMI_FC_DBGAUD0CH1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH1 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH1, field FC_DBGAUD0CH1[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1.
#define BM_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1.

//! @brief Get value of HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1 from a register value.
#define BG_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1) >> BP_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1.
#define BF_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1) & BM_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH1 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1(v)   (HW_HDMI_FC_DBGAUD0CH1_WR((HW_HDMI_FC_DBGAUD0CH1_RD() & ~BM_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1) | BF_HDMI_FC_DBGAUD0CH1_FC_DBGAUD0CH1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH1 - Frame Composer Audio Channel 1 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH1 - Frame Composer Audio Channel 1 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch1
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch1_bitfields
    {
        unsigned char FC_DBGAUD1CH1 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 1 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH1 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH1_ADDR      (REGS_HDMI_BASE + 0x1205)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH1           (*(volatile hw_hdmi_fc_dbgaud1ch1_t *) HW_HDMI_FC_DBGAUD1CH1_ADDR)
#define HW_HDMI_FC_DBGAUD1CH1_RD()      (HW_HDMI_FC_DBGAUD1CH1.U)
#define HW_HDMI_FC_DBGAUD1CH1_WR(v)     (HW_HDMI_FC_DBGAUD1CH1.U = (v))
#define HW_HDMI_FC_DBGAUD1CH1_SET(v)    (HW_HDMI_FC_DBGAUD1CH1_WR(HW_HDMI_FC_DBGAUD1CH1_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH1_CLR(v)    (HW_HDMI_FC_DBGAUD1CH1_WR(HW_HDMI_FC_DBGAUD1CH1_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH1_TOG(v)    (HW_HDMI_FC_DBGAUD1CH1_WR(HW_HDMI_FC_DBGAUD1CH1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH1 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH1, field FC_DBGAUD1CH1[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 1 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1.
#define BM_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1.

//! @brief Get value of HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1 from a register value.
#define BG_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1) >> BP_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1.
#define BF_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1) & BM_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH1 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1(v)   (HW_HDMI_FC_DBGAUD1CH1_WR((HW_HDMI_FC_DBGAUD1CH1_RD() & ~BM_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1) | BF_HDMI_FC_DBGAUD1CH1_FC_DBGAUD1CH1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH1 - Frame Composer Audio Channel 1 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH1 - Frame Composer Audio Channel 1 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch1
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch1_bitfields
    {
        unsigned char FC_DBGAUD2CH1 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 1 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH1 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH1_ADDR      (REGS_HDMI_BASE + 0x1206)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH1           (*(volatile hw_hdmi_fc_dbgaud2ch1_t *) HW_HDMI_FC_DBGAUD2CH1_ADDR)
#define HW_HDMI_FC_DBGAUD2CH1_RD()      (HW_HDMI_FC_DBGAUD2CH1.U)
#define HW_HDMI_FC_DBGAUD2CH1_WR(v)     (HW_HDMI_FC_DBGAUD2CH1.U = (v))
#define HW_HDMI_FC_DBGAUD2CH1_SET(v)    (HW_HDMI_FC_DBGAUD2CH1_WR(HW_HDMI_FC_DBGAUD2CH1_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH1_CLR(v)    (HW_HDMI_FC_DBGAUD2CH1_WR(HW_HDMI_FC_DBGAUD2CH1_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH1_TOG(v)    (HW_HDMI_FC_DBGAUD2CH1_WR(HW_HDMI_FC_DBGAUD2CH1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH1 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH1, field FC_DBGAUD2CH1[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 1 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1.
#define BM_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1.

//! @brief Get value of HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1 from a register value.
#define BG_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1) >> BP_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1.
#define BF_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1) & BM_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH1 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1(v)   (HW_HDMI_FC_DBGAUD2CH1_WR((HW_HDMI_FC_DBGAUD2CH1_RD() & ~BM_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1) | BF_HDMI_FC_DBGAUD2CH1_FC_DBGAUD2CH1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH2 - Frame Composer Debug Audio Channel 2 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH2 - Frame Composer Debug Audio Channel 2 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch2
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch2_bitfields
    {
        unsigned char FC_DBGAUD0CH2 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 2 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH2 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH2_ADDR      (REGS_HDMI_BASE + 0x1207)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH2           (*(volatile hw_hdmi_fc_dbgaud0ch2_t *) HW_HDMI_FC_DBGAUD0CH2_ADDR)
#define HW_HDMI_FC_DBGAUD0CH2_RD()      (HW_HDMI_FC_DBGAUD0CH2.U)
#define HW_HDMI_FC_DBGAUD0CH2_WR(v)     (HW_HDMI_FC_DBGAUD0CH2.U = (v))
#define HW_HDMI_FC_DBGAUD0CH2_SET(v)    (HW_HDMI_FC_DBGAUD0CH2_WR(HW_HDMI_FC_DBGAUD0CH2_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH2_CLR(v)    (HW_HDMI_FC_DBGAUD0CH2_WR(HW_HDMI_FC_DBGAUD0CH2_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH2_TOG(v)    (HW_HDMI_FC_DBGAUD0CH2_WR(HW_HDMI_FC_DBGAUD0CH2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH2 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH2, field FC_DBGAUD0CH2[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 2 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2.
#define BM_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2.

//! @brief Get value of HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2 from a register value.
#define BG_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2) >> BP_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2.
#define BF_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2) & BM_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH2 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2(v)   (HW_HDMI_FC_DBGAUD0CH2_WR((HW_HDMI_FC_DBGAUD0CH2_RD() & ~BM_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2) | BF_HDMI_FC_DBGAUD0CH2_FC_DBGAUD0CH2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH2 - Frame Composer Debug Audio Channel 2 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH2 - Frame Composer Debug Audio Channel 2 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch2
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch2_bitfields
    {
        unsigned char FC_DBGAUD1CH2 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 2 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH2 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH2_ADDR      (REGS_HDMI_BASE + 0x1208)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH2           (*(volatile hw_hdmi_fc_dbgaud1ch2_t *) HW_HDMI_FC_DBGAUD1CH2_ADDR)
#define HW_HDMI_FC_DBGAUD1CH2_RD()      (HW_HDMI_FC_DBGAUD1CH2.U)
#define HW_HDMI_FC_DBGAUD1CH2_WR(v)     (HW_HDMI_FC_DBGAUD1CH2.U = (v))
#define HW_HDMI_FC_DBGAUD1CH2_SET(v)    (HW_HDMI_FC_DBGAUD1CH2_WR(HW_HDMI_FC_DBGAUD1CH2_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH2_CLR(v)    (HW_HDMI_FC_DBGAUD1CH2_WR(HW_HDMI_FC_DBGAUD1CH2_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH2_TOG(v)    (HW_HDMI_FC_DBGAUD1CH2_WR(HW_HDMI_FC_DBGAUD1CH2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH2 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH2, field FC_DBGAUD1CH2[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 2 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2.
#define BM_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2.

//! @brief Get value of HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2 from a register value.
#define BG_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2) >> BP_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2.
#define BF_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2) & BM_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH2 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2(v)   (HW_HDMI_FC_DBGAUD1CH2_WR((HW_HDMI_FC_DBGAUD1CH2_RD() & ~BM_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2) | BF_HDMI_FC_DBGAUD1CH2_FC_DBGAUD1CH2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH2 - Frame Composer Audio Channel 2 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH2 - Frame Composer Audio Channel 2 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch2
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch2_bitfields
    {
        unsigned char FC_DBGAUD2CH2 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 2 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH2 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH2_ADDR      (REGS_HDMI_BASE + 0x1209)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH2           (*(volatile hw_hdmi_fc_dbgaud2ch2_t *) HW_HDMI_FC_DBGAUD2CH2_ADDR)
#define HW_HDMI_FC_DBGAUD2CH2_RD()      (HW_HDMI_FC_DBGAUD2CH2.U)
#define HW_HDMI_FC_DBGAUD2CH2_WR(v)     (HW_HDMI_FC_DBGAUD2CH2.U = (v))
#define HW_HDMI_FC_DBGAUD2CH2_SET(v)    (HW_HDMI_FC_DBGAUD2CH2_WR(HW_HDMI_FC_DBGAUD2CH2_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH2_CLR(v)    (HW_HDMI_FC_DBGAUD2CH2_WR(HW_HDMI_FC_DBGAUD2CH2_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH2_TOG(v)    (HW_HDMI_FC_DBGAUD2CH2_WR(HW_HDMI_FC_DBGAUD2CH2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH2 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH2, field FC_DBGAUD2CH2[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 2 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2.
#define BM_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2.

//! @brief Get value of HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2 from a register value.
#define BG_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2) >> BP_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2.
#define BF_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2) & BM_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH2 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2(v)   (HW_HDMI_FC_DBGAUD2CH2_WR((HW_HDMI_FC_DBGAUD2CH2_RD() & ~BM_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2) | BF_HDMI_FC_DBGAUD2CH2_FC_DBGAUD2CH2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH3 - Frame Composer Audio Channel 3 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH3 - Frame Composer Audio Channel 3 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch3
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch3_bitfields
    {
        unsigned char FC_DBGAUD0CH3 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 3 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH3 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH3_ADDR      (REGS_HDMI_BASE + 0x120a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH3           (*(volatile hw_hdmi_fc_dbgaud0ch3_t *) HW_HDMI_FC_DBGAUD0CH3_ADDR)
#define HW_HDMI_FC_DBGAUD0CH3_RD()      (HW_HDMI_FC_DBGAUD0CH3.U)
#define HW_HDMI_FC_DBGAUD0CH3_WR(v)     (HW_HDMI_FC_DBGAUD0CH3.U = (v))
#define HW_HDMI_FC_DBGAUD0CH3_SET(v)    (HW_HDMI_FC_DBGAUD0CH3_WR(HW_HDMI_FC_DBGAUD0CH3_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH3_CLR(v)    (HW_HDMI_FC_DBGAUD0CH3_WR(HW_HDMI_FC_DBGAUD0CH3_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH3_TOG(v)    (HW_HDMI_FC_DBGAUD0CH3_WR(HW_HDMI_FC_DBGAUD0CH3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH3 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH3, field FC_DBGAUD0CH3[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 3 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3.
#define BM_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3.

//! @brief Get value of HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3 from a register value.
#define BG_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3) >> BP_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3.
#define BF_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3) & BM_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH3 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3(v)   (HW_HDMI_FC_DBGAUD0CH3_WR((HW_HDMI_FC_DBGAUD0CH3_RD() & ~BM_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3) | BF_HDMI_FC_DBGAUD0CH3_FC_DBGAUD0CH3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH3 - Frame Composer Audio Channel 3 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH3 - Frame Composer Audio Channel 3 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch3
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch3_bitfields
    {
        unsigned char FC_DBGAUD1CH3 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 3 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH3 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH3_ADDR      (REGS_HDMI_BASE + 0x120b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH3           (*(volatile hw_hdmi_fc_dbgaud1ch3_t *) HW_HDMI_FC_DBGAUD1CH3_ADDR)
#define HW_HDMI_FC_DBGAUD1CH3_RD()      (HW_HDMI_FC_DBGAUD1CH3.U)
#define HW_HDMI_FC_DBGAUD1CH3_WR(v)     (HW_HDMI_FC_DBGAUD1CH3.U = (v))
#define HW_HDMI_FC_DBGAUD1CH3_SET(v)    (HW_HDMI_FC_DBGAUD1CH3_WR(HW_HDMI_FC_DBGAUD1CH3_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH3_CLR(v)    (HW_HDMI_FC_DBGAUD1CH3_WR(HW_HDMI_FC_DBGAUD1CH3_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH3_TOG(v)    (HW_HDMI_FC_DBGAUD1CH3_WR(HW_HDMI_FC_DBGAUD1CH3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH3 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH3, field FC_DBGAUD1CH3[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 3 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3.
#define BM_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3.

//! @brief Get value of HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3 from a register value.
#define BG_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3) >> BP_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3.
#define BF_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3) & BM_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH3 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3(v)   (HW_HDMI_FC_DBGAUD1CH3_WR((HW_HDMI_FC_DBGAUD1CH3_RD() & ~BM_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3) | BF_HDMI_FC_DBGAUD1CH3_FC_DBGAUD1CH3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH3 - Frame Composer Audio Channel 3 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH3 - Frame Composer Audio Channel 3 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch3
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch3_bitfields
    {
        unsigned char FC_DBGAUD2CH3 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 3 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH3 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH3_ADDR      (REGS_HDMI_BASE + 0x120c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH3           (*(volatile hw_hdmi_fc_dbgaud2ch3_t *) HW_HDMI_FC_DBGAUD2CH3_ADDR)
#define HW_HDMI_FC_DBGAUD2CH3_RD()      (HW_HDMI_FC_DBGAUD2CH3.U)
#define HW_HDMI_FC_DBGAUD2CH3_WR(v)     (HW_HDMI_FC_DBGAUD2CH3.U = (v))
#define HW_HDMI_FC_DBGAUD2CH3_SET(v)    (HW_HDMI_FC_DBGAUD2CH3_WR(HW_HDMI_FC_DBGAUD2CH3_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH3_CLR(v)    (HW_HDMI_FC_DBGAUD2CH3_WR(HW_HDMI_FC_DBGAUD2CH3_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH3_TOG(v)    (HW_HDMI_FC_DBGAUD2CH3_WR(HW_HDMI_FC_DBGAUD2CH3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH3 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH3, field FC_DBGAUD2CH3[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 3 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3.
#define BM_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3.

//! @brief Get value of HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3 from a register value.
#define BG_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3) >> BP_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3.
#define BF_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3) & BM_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH3 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3(v)   (HW_HDMI_FC_DBGAUD2CH3_WR((HW_HDMI_FC_DBGAUD2CH3_RD() & ~BM_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3) | BF_HDMI_FC_DBGAUD2CH3_FC_DBGAUD2CH3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH4 - Frame Composer Audio Channel 4 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH4 - Frame Composer Audio Channel 4 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch4
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch4_bitfields
    {
        unsigned char FC_DBGAUD0CH4 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 4 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH4 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH4_ADDR      (REGS_HDMI_BASE + 0x120d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH4           (*(volatile hw_hdmi_fc_dbgaud0ch4_t *) HW_HDMI_FC_DBGAUD0CH4_ADDR)
#define HW_HDMI_FC_DBGAUD0CH4_RD()      (HW_HDMI_FC_DBGAUD0CH4.U)
#define HW_HDMI_FC_DBGAUD0CH4_WR(v)     (HW_HDMI_FC_DBGAUD0CH4.U = (v))
#define HW_HDMI_FC_DBGAUD0CH4_SET(v)    (HW_HDMI_FC_DBGAUD0CH4_WR(HW_HDMI_FC_DBGAUD0CH4_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH4_CLR(v)    (HW_HDMI_FC_DBGAUD0CH4_WR(HW_HDMI_FC_DBGAUD0CH4_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH4_TOG(v)    (HW_HDMI_FC_DBGAUD0CH4_WR(HW_HDMI_FC_DBGAUD0CH4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH4 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH4, field FC_DBGAUD0CH4[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 4 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4.
#define BM_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4.

//! @brief Get value of HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4 from a register value.
#define BG_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4) >> BP_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4.
#define BF_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4) & BM_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH4 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4(v)   (HW_HDMI_FC_DBGAUD0CH4_WR((HW_HDMI_FC_DBGAUD0CH4_RD() & ~BM_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4) | BF_HDMI_FC_DBGAUD0CH4_FC_DBGAUD0CH4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH4 - Frame Composer Audio Channel 4 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH4 - Frame Composer Audio Channel 4 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch4
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch4_bitfields
    {
        unsigned char FC_DBGAUD1CH4 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 4 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH4 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH4_ADDR      (REGS_HDMI_BASE + 0x120e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH4           (*(volatile hw_hdmi_fc_dbgaud1ch4_t *) HW_HDMI_FC_DBGAUD1CH4_ADDR)
#define HW_HDMI_FC_DBGAUD1CH4_RD()      (HW_HDMI_FC_DBGAUD1CH4.U)
#define HW_HDMI_FC_DBGAUD1CH4_WR(v)     (HW_HDMI_FC_DBGAUD1CH4.U = (v))
#define HW_HDMI_FC_DBGAUD1CH4_SET(v)    (HW_HDMI_FC_DBGAUD1CH4_WR(HW_HDMI_FC_DBGAUD1CH4_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH4_CLR(v)    (HW_HDMI_FC_DBGAUD1CH4_WR(HW_HDMI_FC_DBGAUD1CH4_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH4_TOG(v)    (HW_HDMI_FC_DBGAUD1CH4_WR(HW_HDMI_FC_DBGAUD1CH4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH4 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH4, field FC_DBGAUD1CH4[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 4 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4.
#define BM_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4.

//! @brief Get value of HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4 from a register value.
#define BG_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4) >> BP_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4.
#define BF_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4) & BM_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH4 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4(v)   (HW_HDMI_FC_DBGAUD1CH4_WR((HW_HDMI_FC_DBGAUD1CH4_RD() & ~BM_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4) | BF_HDMI_FC_DBGAUD1CH4_FC_DBGAUD1CH4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH4 - Frame Composer Audio Channel 4 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH4 - Frame Composer Audio Channel 4 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch4
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch4_bitfields
    {
        unsigned char FC_DBGAUD2CH4 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 4 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch4_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH4 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH4_ADDR      (REGS_HDMI_BASE + 0x120f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH4           (*(volatile hw_hdmi_fc_dbgaud2ch4_t *) HW_HDMI_FC_DBGAUD2CH4_ADDR)
#define HW_HDMI_FC_DBGAUD2CH4_RD()      (HW_HDMI_FC_DBGAUD2CH4.U)
#define HW_HDMI_FC_DBGAUD2CH4_WR(v)     (HW_HDMI_FC_DBGAUD2CH4.U = (v))
#define HW_HDMI_FC_DBGAUD2CH4_SET(v)    (HW_HDMI_FC_DBGAUD2CH4_WR(HW_HDMI_FC_DBGAUD2CH4_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH4_CLR(v)    (HW_HDMI_FC_DBGAUD2CH4_WR(HW_HDMI_FC_DBGAUD2CH4_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH4_TOG(v)    (HW_HDMI_FC_DBGAUD2CH4_WR(HW_HDMI_FC_DBGAUD2CH4_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH4 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH4, field FC_DBGAUD2CH4[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 4 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4.
#define BM_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4.

//! @brief Get value of HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4 from a register value.
#define BG_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4) >> BP_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4.
#define BF_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4) & BM_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH4 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4(v)   (HW_HDMI_FC_DBGAUD2CH4_WR((HW_HDMI_FC_DBGAUD2CH4_RD() & ~BM_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4) | BF_HDMI_FC_DBGAUD2CH4_FC_DBGAUD2CH4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH5 - Frame Composer Audio Channel 5 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH5 - Frame Composer Audio Channel 5 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch5
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch5_bitfields
    {
        unsigned char FC_DBGAUD0CH5 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 5 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH5 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH5_ADDR      (REGS_HDMI_BASE + 0x1210)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH5           (*(volatile hw_hdmi_fc_dbgaud0ch5_t *) HW_HDMI_FC_DBGAUD0CH5_ADDR)
#define HW_HDMI_FC_DBGAUD0CH5_RD()      (HW_HDMI_FC_DBGAUD0CH5.U)
#define HW_HDMI_FC_DBGAUD0CH5_WR(v)     (HW_HDMI_FC_DBGAUD0CH5.U = (v))
#define HW_HDMI_FC_DBGAUD0CH5_SET(v)    (HW_HDMI_FC_DBGAUD0CH5_WR(HW_HDMI_FC_DBGAUD0CH5_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH5_CLR(v)    (HW_HDMI_FC_DBGAUD0CH5_WR(HW_HDMI_FC_DBGAUD0CH5_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH5_TOG(v)    (HW_HDMI_FC_DBGAUD0CH5_WR(HW_HDMI_FC_DBGAUD0CH5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH5 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH5, field FC_DBGAUD0CH5[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 5 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5.
#define BM_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5.

//! @brief Get value of HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5 from a register value.
#define BG_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5) >> BP_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5.
#define BF_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5) & BM_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH5 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5(v)   (HW_HDMI_FC_DBGAUD0CH5_WR((HW_HDMI_FC_DBGAUD0CH5_RD() & ~BM_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5) | BF_HDMI_FC_DBGAUD0CH5_FC_DBGAUD0CH5(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH5 - Frame Composer Audio Channel 5 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH5 - Frame Composer Audio Channel 5 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch5
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch5_bitfields
    {
        unsigned char FC_DBGAUD1CH5 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 5 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH5 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH5_ADDR      (REGS_HDMI_BASE + 0x1211)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH5           (*(volatile hw_hdmi_fc_dbgaud1ch5_t *) HW_HDMI_FC_DBGAUD1CH5_ADDR)
#define HW_HDMI_FC_DBGAUD1CH5_RD()      (HW_HDMI_FC_DBGAUD1CH5.U)
#define HW_HDMI_FC_DBGAUD1CH5_WR(v)     (HW_HDMI_FC_DBGAUD1CH5.U = (v))
#define HW_HDMI_FC_DBGAUD1CH5_SET(v)    (HW_HDMI_FC_DBGAUD1CH5_WR(HW_HDMI_FC_DBGAUD1CH5_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH5_CLR(v)    (HW_HDMI_FC_DBGAUD1CH5_WR(HW_HDMI_FC_DBGAUD1CH5_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH5_TOG(v)    (HW_HDMI_FC_DBGAUD1CH5_WR(HW_HDMI_FC_DBGAUD1CH5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH5 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH5, field FC_DBGAUD1CH5[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 5 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5.
#define BM_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5.

//! @brief Get value of HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5 from a register value.
#define BG_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5) >> BP_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5.
#define BF_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5) & BM_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH5 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5(v)   (HW_HDMI_FC_DBGAUD1CH5_WR((HW_HDMI_FC_DBGAUD1CH5_RD() & ~BM_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5) | BF_HDMI_FC_DBGAUD1CH5_FC_DBGAUD1CH5(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH5 - Frame Composer Audio Channel 5 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH5 - Frame Composer Audio Channel 5 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch5
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch5_bitfields
    {
        unsigned char FC_DBGAUD2CH5 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 5 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch5_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH5 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH5_ADDR      (REGS_HDMI_BASE + 0x1212)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH5           (*(volatile hw_hdmi_fc_dbgaud2ch5_t *) HW_HDMI_FC_DBGAUD2CH5_ADDR)
#define HW_HDMI_FC_DBGAUD2CH5_RD()      (HW_HDMI_FC_DBGAUD2CH5.U)
#define HW_HDMI_FC_DBGAUD2CH5_WR(v)     (HW_HDMI_FC_DBGAUD2CH5.U = (v))
#define HW_HDMI_FC_DBGAUD2CH5_SET(v)    (HW_HDMI_FC_DBGAUD2CH5_WR(HW_HDMI_FC_DBGAUD2CH5_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH5_CLR(v)    (HW_HDMI_FC_DBGAUD2CH5_WR(HW_HDMI_FC_DBGAUD2CH5_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH5_TOG(v)    (HW_HDMI_FC_DBGAUD2CH5_WR(HW_HDMI_FC_DBGAUD2CH5_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH5 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH5, field FC_DBGAUD2CH5[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 5 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5.
#define BM_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5.

//! @brief Get value of HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5 from a register value.
#define BG_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5) >> BP_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5.
#define BF_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5) & BM_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH5 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5(v)   (HW_HDMI_FC_DBGAUD2CH5_WR((HW_HDMI_FC_DBGAUD2CH5_RD() & ~BM_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5) | BF_HDMI_FC_DBGAUD2CH5_FC_DBGAUD2CH5(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH6 - Frame Composer Audio Channel 6 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH6 - Frame Composer Audio Channel 6 Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 0 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch6
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch6_bitfields
    {
        unsigned char FC_DBGAUD0CH6 : 8; //!< [7:0] The audio fixed data byte0 to be used in channel 6 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH6 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH6_ADDR      (REGS_HDMI_BASE + 0x1213)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH6           (*(volatile hw_hdmi_fc_dbgaud0ch6_t *) HW_HDMI_FC_DBGAUD0CH6_ADDR)
#define HW_HDMI_FC_DBGAUD0CH6_RD()      (HW_HDMI_FC_DBGAUD0CH6.U)
#define HW_HDMI_FC_DBGAUD0CH6_WR(v)     (HW_HDMI_FC_DBGAUD0CH6.U = (v))
#define HW_HDMI_FC_DBGAUD0CH6_SET(v)    (HW_HDMI_FC_DBGAUD0CH6_WR(HW_HDMI_FC_DBGAUD0CH6_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH6_CLR(v)    (HW_HDMI_FC_DBGAUD0CH6_WR(HW_HDMI_FC_DBGAUD0CH6_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH6_TOG(v)    (HW_HDMI_FC_DBGAUD0CH6_WR(HW_HDMI_FC_DBGAUD0CH6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH6 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH6, field FC_DBGAUD0CH6[7:0] (RW)
 *
 * The audio fixed data byte0 to be used in channel 6 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6.
#define BM_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6.

//! @brief Get value of HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6 from a register value.
#define BG_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6) >> BP_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6.
#define BF_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6) & BM_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH6 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6(v)   (HW_HDMI_FC_DBGAUD0CH6_WR((HW_HDMI_FC_DBGAUD0CH6_RD() & ~BM_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6) | BF_HDMI_FC_DBGAUD0CH6_FC_DBGAUD0CH6(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH6 - Frame Composer Audio Channel 6 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH6 - Frame Composer Audio Channel 6 Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch6
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch6_bitfields
    {
        unsigned char FC_DBGAUD1CH6 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 6 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH6 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH6_ADDR      (REGS_HDMI_BASE + 0x1214)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH6           (*(volatile hw_hdmi_fc_dbgaud1ch6_t *) HW_HDMI_FC_DBGAUD1CH6_ADDR)
#define HW_HDMI_FC_DBGAUD1CH6_RD()      (HW_HDMI_FC_DBGAUD1CH6.U)
#define HW_HDMI_FC_DBGAUD1CH6_WR(v)     (HW_HDMI_FC_DBGAUD1CH6.U = (v))
#define HW_HDMI_FC_DBGAUD1CH6_SET(v)    (HW_HDMI_FC_DBGAUD1CH6_WR(HW_HDMI_FC_DBGAUD1CH6_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH6_CLR(v)    (HW_HDMI_FC_DBGAUD1CH6_WR(HW_HDMI_FC_DBGAUD1CH6_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH6_TOG(v)    (HW_HDMI_FC_DBGAUD1CH6_WR(HW_HDMI_FC_DBGAUD1CH6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH6 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH6, field FC_DBGAUD1CH6[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 6 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6.
#define BM_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6.

//! @brief Get value of HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6 from a register value.
#define BG_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6) >> BP_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6.
#define BF_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6) & BM_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH6 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6(v)   (HW_HDMI_FC_DBGAUD1CH6_WR((HW_HDMI_FC_DBGAUD1CH6_RD() & ~BM_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6) | BF_HDMI_FC_DBGAUD1CH6_FC_DBGAUD1CH6(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH6 - Frame Composer Audio Channel 6 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH6 - Frame Composer Audio Channel 6 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch6
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch6_bitfields
    {
        unsigned char FC_DBGAUD2CH6 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 6 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch6_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH6 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH6_ADDR      (REGS_HDMI_BASE + 0x1215)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH6           (*(volatile hw_hdmi_fc_dbgaud2ch6_t *) HW_HDMI_FC_DBGAUD2CH6_ADDR)
#define HW_HDMI_FC_DBGAUD2CH6_RD()      (HW_HDMI_FC_DBGAUD2CH6.U)
#define HW_HDMI_FC_DBGAUD2CH6_WR(v)     (HW_HDMI_FC_DBGAUD2CH6.U = (v))
#define HW_HDMI_FC_DBGAUD2CH6_SET(v)    (HW_HDMI_FC_DBGAUD2CH6_WR(HW_HDMI_FC_DBGAUD2CH6_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH6_CLR(v)    (HW_HDMI_FC_DBGAUD2CH6_WR(HW_HDMI_FC_DBGAUD2CH6_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH6_TOG(v)    (HW_HDMI_FC_DBGAUD2CH6_WR(HW_HDMI_FC_DBGAUD2CH6_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH6 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH6, field FC_DBGAUD2CH6[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 6 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6.
#define BM_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6.

//! @brief Get value of HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6 from a register value.
#define BG_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6) >> BP_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6.
#define BF_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6) & BM_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH6 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6(v)   (HW_HDMI_FC_DBGAUD2CH6_WR((HW_HDMI_FC_DBGAUD2CH6_RD() & ~BM_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6) | BF_HDMI_FC_DBGAUD2CH6_FC_DBGAUD2CH6(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD0CH7 - Frame Composer Audio Channel 7 Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD0CH7 - Frame Composer Audio Channel 7 Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * Configures the audio fixed data to be used in channel 7 when in fixed audio selection.
 */
typedef union _hw_hdmi_fc_dbgaud0ch7
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud0ch7_bitfields
    {
        unsigned char FC_DBGAUD0CH7 : 8; //!< [7:0] the audio fixed data byte0 to be used in channel 7 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud0ch7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD0CH7 register
 */
//@{
#define HW_HDMI_FC_DBGAUD0CH7_ADDR      (REGS_HDMI_BASE + 0x1216)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD0CH7           (*(volatile hw_hdmi_fc_dbgaud0ch7_t *) HW_HDMI_FC_DBGAUD0CH7_ADDR)
#define HW_HDMI_FC_DBGAUD0CH7_RD()      (HW_HDMI_FC_DBGAUD0CH7.U)
#define HW_HDMI_FC_DBGAUD0CH7_WR(v)     (HW_HDMI_FC_DBGAUD0CH7.U = (v))
#define HW_HDMI_FC_DBGAUD0CH7_SET(v)    (HW_HDMI_FC_DBGAUD0CH7_WR(HW_HDMI_FC_DBGAUD0CH7_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD0CH7_CLR(v)    (HW_HDMI_FC_DBGAUD0CH7_WR(HW_HDMI_FC_DBGAUD0CH7_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD0CH7_TOG(v)    (HW_HDMI_FC_DBGAUD0CH7_WR(HW_HDMI_FC_DBGAUD0CH7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD0CH7 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD0CH7, field FC_DBGAUD0CH7[7:0] (RW)
 *
 * the audio fixed data byte0 to be used in channel 7 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7      (0)      //!< Bit position for HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7.
#define BM_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7.

//! @brief Get value of HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7 from a register value.
#define BG_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7) >> BP_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7)

//! @brief Format value for bitfield HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7.
#define BF_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7) & BM_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD0CH7 field to a new value.
#define BW_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7(v)   (HW_HDMI_FC_DBGAUD0CH7_WR((HW_HDMI_FC_DBGAUD0CH7_RD() & ~BM_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7) | BF_HDMI_FC_DBGAUD0CH7_FC_DBGAUD0CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD1CH7 - Frame Composer Audio Channel 7 Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD1CH7 - Frame Composer Audio Channel 7 Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud1ch7
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud1ch7_bitfields
    {
        unsigned char FC_DBGAUD1CH7 : 8; //!< [7:0] the audio fixed data byte1 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud1ch7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD1CH7 register
 */
//@{
#define HW_HDMI_FC_DBGAUD1CH7_ADDR      (REGS_HDMI_BASE + 0x1217)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD1CH7           (*(volatile hw_hdmi_fc_dbgaud1ch7_t *) HW_HDMI_FC_DBGAUD1CH7_ADDR)
#define HW_HDMI_FC_DBGAUD1CH7_RD()      (HW_HDMI_FC_DBGAUD1CH7.U)
#define HW_HDMI_FC_DBGAUD1CH7_WR(v)     (HW_HDMI_FC_DBGAUD1CH7.U = (v))
#define HW_HDMI_FC_DBGAUD1CH7_SET(v)    (HW_HDMI_FC_DBGAUD1CH7_WR(HW_HDMI_FC_DBGAUD1CH7_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD1CH7_CLR(v)    (HW_HDMI_FC_DBGAUD1CH7_WR(HW_HDMI_FC_DBGAUD1CH7_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD1CH7_TOG(v)    (HW_HDMI_FC_DBGAUD1CH7_WR(HW_HDMI_FC_DBGAUD1CH7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD1CH7 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD1CH7, field FC_DBGAUD1CH7[7:0] (RW)
 *
 * the audio fixed data byte1 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7      (0)      //!< Bit position for HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7.
#define BM_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7.

//! @brief Get value of HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7 from a register value.
#define BG_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7) >> BP_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7)

//! @brief Format value for bitfield HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7.
#define BF_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7) & BM_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD1CH7 field to a new value.
#define BW_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7(v)   (HW_HDMI_FC_DBGAUD1CH7_WR((HW_HDMI_FC_DBGAUD1CH7_RD() & ~BM_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7) | BF_HDMI_FC_DBGAUD1CH7_FC_DBGAUD1CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGAUD2CH7 - Frame Composer Audio Channel 7 Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGAUD2CH7 - Frame Composer Audio Channel 7 Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_fc_dbgaud2ch7
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgaud2ch7_bitfields
    {
        unsigned char FC_DBGAUD2CH7 : 8; //!< [7:0] the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
    } B;
} hw_hdmi_fc_dbgaud2ch7_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGAUD2CH7 register
 */
//@{
#define HW_HDMI_FC_DBGAUD2CH7_ADDR      (REGS_HDMI_BASE + 0x1218)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGAUD2CH7           (*(volatile hw_hdmi_fc_dbgaud2ch7_t *) HW_HDMI_FC_DBGAUD2CH7_ADDR)
#define HW_HDMI_FC_DBGAUD2CH7_RD()      (HW_HDMI_FC_DBGAUD2CH7.U)
#define HW_HDMI_FC_DBGAUD2CH7_WR(v)     (HW_HDMI_FC_DBGAUD2CH7.U = (v))
#define HW_HDMI_FC_DBGAUD2CH7_SET(v)    (HW_HDMI_FC_DBGAUD2CH7_WR(HW_HDMI_FC_DBGAUD2CH7_RD() |  (v)))
#define HW_HDMI_FC_DBGAUD2CH7_CLR(v)    (HW_HDMI_FC_DBGAUD2CH7_WR(HW_HDMI_FC_DBGAUD2CH7_RD() & ~(v)))
#define HW_HDMI_FC_DBGAUD2CH7_TOG(v)    (HW_HDMI_FC_DBGAUD2CH7_WR(HW_HDMI_FC_DBGAUD2CH7_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGAUD2CH7 bitfields
 */

/*! @name Register HDMI_FC_DBGAUD2CH7, field FC_DBGAUD2CH7[7:0] (RW)
 *
 * the audio fixed data byte2 to be used in channel 0 when in fixed audio selection
 */
//@{
#define BP_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7      (0)      //!< Bit position for HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7.
#define BM_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7.

//! @brief Get value of HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7 from a register value.
#define BG_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7) >> BP_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7)

//! @brief Format value for bitfield HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7.
#define BF_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7) & BM_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGAUD2CH7 field to a new value.
#define BW_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7(v)   (HW_HDMI_FC_DBGAUD2CH7_WR((HW_HDMI_FC_DBGAUD2CH7_RD() & ~BM_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7) | BF_HDMI_FC_DBGAUD2CH7_FC_DBGAUD2CH7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGTMDS0 - Frame Composer TMDS Channel 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGTMDS0 - Frame Composer TMDS Channel 0 Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the video fixed data to be used in tmds channel 0 when in fixed video selection. This
 * equals to set B pixel component value in RGB video or Cb pixel component value in YCbCr.
 */
typedef union _hw_hdmi_fc_dbgtmds0
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgtmds0_bitfields
    {
        unsigned char FC_DBGTMDS0 : 8; //!< [7:0] set B pixel component value in RGB video or Cb pixel component value in YCbCr
    } B;
} hw_hdmi_fc_dbgtmds0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGTMDS0 register
 */
//@{
#define HW_HDMI_FC_DBGTMDS0_ADDR      (REGS_HDMI_BASE + 0x1219)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGTMDS0           (*(volatile hw_hdmi_fc_dbgtmds0_t *) HW_HDMI_FC_DBGTMDS0_ADDR)
#define HW_HDMI_FC_DBGTMDS0_RD()      (HW_HDMI_FC_DBGTMDS0.U)
#define HW_HDMI_FC_DBGTMDS0_WR(v)     (HW_HDMI_FC_DBGTMDS0.U = (v))
#define HW_HDMI_FC_DBGTMDS0_SET(v)    (HW_HDMI_FC_DBGTMDS0_WR(HW_HDMI_FC_DBGTMDS0_RD() |  (v)))
#define HW_HDMI_FC_DBGTMDS0_CLR(v)    (HW_HDMI_FC_DBGTMDS0_WR(HW_HDMI_FC_DBGTMDS0_RD() & ~(v)))
#define HW_HDMI_FC_DBGTMDS0_TOG(v)    (HW_HDMI_FC_DBGTMDS0_WR(HW_HDMI_FC_DBGTMDS0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGTMDS0 bitfields
 */

/*! @name Register HDMI_FC_DBGTMDS0, field FC_DBGTMDS0[7:0] (RW)
 *
 * set B pixel component value in RGB video or Cb pixel component value in YCbCr
 */
//@{
#define BP_HDMI_FC_DBGTMDS0_FC_DBGTMDS0      (0)      //!< Bit position for HDMI_FC_DBGTMDS0_FC_DBGTMDS0.
#define BM_HDMI_FC_DBGTMDS0_FC_DBGTMDS0      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGTMDS0_FC_DBGTMDS0.

//! @brief Get value of HDMI_FC_DBGTMDS0_FC_DBGTMDS0 from a register value.
#define BG_HDMI_FC_DBGTMDS0_FC_DBGTMDS0(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGTMDS0_FC_DBGTMDS0) >> BP_HDMI_FC_DBGTMDS0_FC_DBGTMDS0)

//! @brief Format value for bitfield HDMI_FC_DBGTMDS0_FC_DBGTMDS0.
#define BF_HDMI_FC_DBGTMDS0_FC_DBGTMDS0(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGTMDS0_FC_DBGTMDS0) & BM_HDMI_FC_DBGTMDS0_FC_DBGTMDS0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGTMDS0 field to a new value.
#define BW_HDMI_FC_DBGTMDS0_FC_DBGTMDS0(v)   (HW_HDMI_FC_DBGTMDS0_WR((HW_HDMI_FC_DBGTMDS0_RD() & ~BM_HDMI_FC_DBGTMDS0_FC_DBGTMDS0) | BF_HDMI_FC_DBGTMDS0_FC_DBGTMDS0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGTMDS1 - Frame Composer TMDS Channel 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGTMDS1 - Frame Composer TMDS Channel 1 Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the video fixed data to be used in tmds channel 1 when in fixed video selection. This
 * equals to set G pixel component value in RGB video or Y pixel component value in YCbCr.
 */
typedef union _hw_hdmi_fc_dbgtmds1
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgtmds1_bitfields
    {
        unsigned char FC_DBGTMDS1 : 8; //!< [7:0] set G pixel component value in RGB video or Y pixel component value in YCbCr
    } B;
} hw_hdmi_fc_dbgtmds1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGTMDS1 register
 */
//@{
#define HW_HDMI_FC_DBGTMDS1_ADDR      (REGS_HDMI_BASE + 0x121a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGTMDS1           (*(volatile hw_hdmi_fc_dbgtmds1_t *) HW_HDMI_FC_DBGTMDS1_ADDR)
#define HW_HDMI_FC_DBGTMDS1_RD()      (HW_HDMI_FC_DBGTMDS1.U)
#define HW_HDMI_FC_DBGTMDS1_WR(v)     (HW_HDMI_FC_DBGTMDS1.U = (v))
#define HW_HDMI_FC_DBGTMDS1_SET(v)    (HW_HDMI_FC_DBGTMDS1_WR(HW_HDMI_FC_DBGTMDS1_RD() |  (v)))
#define HW_HDMI_FC_DBGTMDS1_CLR(v)    (HW_HDMI_FC_DBGTMDS1_WR(HW_HDMI_FC_DBGTMDS1_RD() & ~(v)))
#define HW_HDMI_FC_DBGTMDS1_TOG(v)    (HW_HDMI_FC_DBGTMDS1_WR(HW_HDMI_FC_DBGTMDS1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGTMDS1 bitfields
 */

/*! @name Register HDMI_FC_DBGTMDS1, field FC_DBGTMDS1[7:0] (RW)
 *
 * set G pixel component value in RGB video or Y pixel component value in YCbCr
 */
//@{
#define BP_HDMI_FC_DBGTMDS1_FC_DBGTMDS1      (0)      //!< Bit position for HDMI_FC_DBGTMDS1_FC_DBGTMDS1.
#define BM_HDMI_FC_DBGTMDS1_FC_DBGTMDS1      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGTMDS1_FC_DBGTMDS1.

//! @brief Get value of HDMI_FC_DBGTMDS1_FC_DBGTMDS1 from a register value.
#define BG_HDMI_FC_DBGTMDS1_FC_DBGTMDS1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGTMDS1_FC_DBGTMDS1) >> BP_HDMI_FC_DBGTMDS1_FC_DBGTMDS1)

//! @brief Format value for bitfield HDMI_FC_DBGTMDS1_FC_DBGTMDS1.
#define BF_HDMI_FC_DBGTMDS1_FC_DBGTMDS1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGTMDS1_FC_DBGTMDS1) & BM_HDMI_FC_DBGTMDS1_FC_DBGTMDS1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGTMDS1 field to a new value.
#define BW_HDMI_FC_DBGTMDS1_FC_DBGTMDS1(v)   (HW_HDMI_FC_DBGTMDS1_WR((HW_HDMI_FC_DBGTMDS1_RD() & ~BM_HDMI_FC_DBGTMDS1_FC_DBGTMDS1) | BF_HDMI_FC_DBGTMDS1_FC_DBGTMDS1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_FC_DBGTMDS2 - Frame Composer TMDS Channel 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_FC_DBGTMDS2 - Frame Composer TMDS Channel 2 Register (RW)
 *
 * Reset value: 0x00
 *
 * Configures the video fixed data to be used in tmds channel 2 when in fixed video selection. This
 * equals to set R pixel component value in RGB video or Cr pixel component value in YCbCr.
 */
typedef union _hw_hdmi_fc_dbgtmds2
{
    reg8_t U;
    struct _hw_hdmi_fc_dbgtmds2_bitfields
    {
        unsigned char FC_DBGTMDS2 : 8; //!< [7:0] set R pixel component value in RGB video or Cr pixel component value in YCbCr
    } B;
} hw_hdmi_fc_dbgtmds2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_FC_DBGTMDS2 register
 */
//@{
#define HW_HDMI_FC_DBGTMDS2_ADDR      (REGS_HDMI_BASE + 0x121b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_FC_DBGTMDS2           (*(volatile hw_hdmi_fc_dbgtmds2_t *) HW_HDMI_FC_DBGTMDS2_ADDR)
#define HW_HDMI_FC_DBGTMDS2_RD()      (HW_HDMI_FC_DBGTMDS2.U)
#define HW_HDMI_FC_DBGTMDS2_WR(v)     (HW_HDMI_FC_DBGTMDS2.U = (v))
#define HW_HDMI_FC_DBGTMDS2_SET(v)    (HW_HDMI_FC_DBGTMDS2_WR(HW_HDMI_FC_DBGTMDS2_RD() |  (v)))
#define HW_HDMI_FC_DBGTMDS2_CLR(v)    (HW_HDMI_FC_DBGTMDS2_WR(HW_HDMI_FC_DBGTMDS2_RD() & ~(v)))
#define HW_HDMI_FC_DBGTMDS2_TOG(v)    (HW_HDMI_FC_DBGTMDS2_WR(HW_HDMI_FC_DBGTMDS2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_FC_DBGTMDS2 bitfields
 */

/*! @name Register HDMI_FC_DBGTMDS2, field FC_DBGTMDS2[7:0] (RW)
 *
 * set R pixel component value in RGB video or Cr pixel component value in YCbCr
 */
//@{
#define BP_HDMI_FC_DBGTMDS2_FC_DBGTMDS2      (0)      //!< Bit position for HDMI_FC_DBGTMDS2_FC_DBGTMDS2.
#define BM_HDMI_FC_DBGTMDS2_FC_DBGTMDS2      (0x000000ff)  //!< Bit mask for HDMI_FC_DBGTMDS2_FC_DBGTMDS2.

//! @brief Get value of HDMI_FC_DBGTMDS2_FC_DBGTMDS2 from a register value.
#define BG_HDMI_FC_DBGTMDS2_FC_DBGTMDS2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_FC_DBGTMDS2_FC_DBGTMDS2) >> BP_HDMI_FC_DBGTMDS2_FC_DBGTMDS2)

//! @brief Format value for bitfield HDMI_FC_DBGTMDS2_FC_DBGTMDS2.
#define BF_HDMI_FC_DBGTMDS2_FC_DBGTMDS2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_FC_DBGTMDS2_FC_DBGTMDS2) & BM_HDMI_FC_DBGTMDS2_FC_DBGTMDS2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FC_DBGTMDS2 field to a new value.
#define BW_HDMI_FC_DBGTMDS2_FC_DBGTMDS2(v)   (HW_HDMI_FC_DBGTMDS2_WR((HW_HDMI_FC_DBGTMDS2_RD() & ~BM_HDMI_FC_DBGTMDS2_FC_DBGTMDS2) | BF_HDMI_FC_DBGTMDS2_FC_DBGTMDS2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_CONF0 - PHY Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_CONF0 - PHY Configuration Register (RW)
 *
 * Reset value: 0x06
 *
 * This register holds the power down, data enable polarity and interface control of the HDMI Source
 * PHY control. For more information, refer to the DesignWare Cores HDMI TX PHY Databook.
 */
typedef union _hw_hdmi_phy_conf0
{
    reg8_t U;
    struct _hw_hdmi_phy_conf0_bitfields
    {
        unsigned char SELDIPIF : 1; //!< [0] Select interface control.
        unsigned char SELDATAENPOL : 1; //!< [1] Select data enable polarity.
        unsigned char GEN2_ENHPDRXSENSE : 1; //!< [2] PHY_Gen2 ENHPDRXSENSE signal
        unsigned char GEN2_TXPWRON : 1; //!< [3] PHY_Gen2 TXPWRON signal
        unsigned char GEN2_PDDQ : 1; //!< [4] PHY_Gen2 PDDQ signal
        unsigned char SPARECTRL : 1; //!< [5] Reserved.
        unsigned char ENTMDS : 1; //!< [6] Enable TMDS drivers, bias, and TMDS digital logic.
        unsigned char PDZ : 1; //!< [7] Power-down enable (active low 0b).
    } B;
} hw_hdmi_phy_conf0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_CONF0 register
 */
//@{
#define HW_HDMI_PHY_CONF0_ADDR      (REGS_HDMI_BASE + 0x3000)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_CONF0           (*(volatile hw_hdmi_phy_conf0_t *) HW_HDMI_PHY_CONF0_ADDR)
#define HW_HDMI_PHY_CONF0_RD()      (HW_HDMI_PHY_CONF0.U)
#define HW_HDMI_PHY_CONF0_WR(v)     (HW_HDMI_PHY_CONF0.U = (v))
#define HW_HDMI_PHY_CONF0_SET(v)    (HW_HDMI_PHY_CONF0_WR(HW_HDMI_PHY_CONF0_RD() |  (v)))
#define HW_HDMI_PHY_CONF0_CLR(v)    (HW_HDMI_PHY_CONF0_WR(HW_HDMI_PHY_CONF0_RD() & ~(v)))
#define HW_HDMI_PHY_CONF0_TOG(v)    (HW_HDMI_PHY_CONF0_WR(HW_HDMI_PHY_CONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_CONF0 bitfields
 */

/*! @name Register HDMI_PHY_CONF0, field SELDIPIF[0] (RW)
 *
 * Select interface control. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_SELDIPIF      (0)      //!< Bit position for HDMI_PHY_CONF0_SELDIPIF.
#define BM_HDMI_PHY_CONF0_SELDIPIF      (0x00000001)  //!< Bit mask for HDMI_PHY_CONF0_SELDIPIF.

//! @brief Get value of HDMI_PHY_CONF0_SELDIPIF from a register value.
#define BG_HDMI_PHY_CONF0_SELDIPIF(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_SELDIPIF) >> BP_HDMI_PHY_CONF0_SELDIPIF)

//! @brief Format value for bitfield HDMI_PHY_CONF0_SELDIPIF.
#define BF_HDMI_PHY_CONF0_SELDIPIF(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_SELDIPIF) & BM_HDMI_PHY_CONF0_SELDIPIF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SELDIPIF field to a new value.
#define BW_HDMI_PHY_CONF0_SELDIPIF(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_SELDIPIF) | BF_HDMI_PHY_CONF0_SELDIPIF(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field SELDATAENPOL[1] (RW)
 *
 * Select data enable polarity. Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_CONF0_SELDATAENPOL      (1)      //!< Bit position for HDMI_PHY_CONF0_SELDATAENPOL.
#define BM_HDMI_PHY_CONF0_SELDATAENPOL      (0x00000002)  //!< Bit mask for HDMI_PHY_CONF0_SELDATAENPOL.

//! @brief Get value of HDMI_PHY_CONF0_SELDATAENPOL from a register value.
#define BG_HDMI_PHY_CONF0_SELDATAENPOL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_SELDATAENPOL) >> BP_HDMI_PHY_CONF0_SELDATAENPOL)

//! @brief Format value for bitfield HDMI_PHY_CONF0_SELDATAENPOL.
#define BF_HDMI_PHY_CONF0_SELDATAENPOL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_SELDATAENPOL) & BM_HDMI_PHY_CONF0_SELDATAENPOL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SELDATAENPOL field to a new value.
#define BW_HDMI_PHY_CONF0_SELDATAENPOL(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_SELDATAENPOL) | BF_HDMI_PHY_CONF0_SELDATAENPOL(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field GEN2_ENHPDRXSENSE[2] (RW)
 *
 * PHY_Gen2 ENHPDRXSENSE signal Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE      (2)      //!< Bit position for HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE.
#define BM_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE      (0x00000004)  //!< Bit mask for HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE.

//! @brief Get value of HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE from a register value.
#define BG_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE) >> BP_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE)

//! @brief Format value for bitfield HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE.
#define BF_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE) & BM_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GEN2_ENHPDRXSENSE field to a new value.
#define BW_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE) | BF_HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field GEN2_TXPWRON[3] (RW)
 *
 * PHY_Gen2 TXPWRON signal Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_GEN2_TXPWRON      (3)      //!< Bit position for HDMI_PHY_CONF0_GEN2_TXPWRON.
#define BM_HDMI_PHY_CONF0_GEN2_TXPWRON      (0x00000008)  //!< Bit mask for HDMI_PHY_CONF0_GEN2_TXPWRON.

//! @brief Get value of HDMI_PHY_CONF0_GEN2_TXPWRON from a register value.
#define BG_HDMI_PHY_CONF0_GEN2_TXPWRON(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_GEN2_TXPWRON) >> BP_HDMI_PHY_CONF0_GEN2_TXPWRON)

//! @brief Format value for bitfield HDMI_PHY_CONF0_GEN2_TXPWRON.
#define BF_HDMI_PHY_CONF0_GEN2_TXPWRON(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_GEN2_TXPWRON) & BM_HDMI_PHY_CONF0_GEN2_TXPWRON)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GEN2_TXPWRON field to a new value.
#define BW_HDMI_PHY_CONF0_GEN2_TXPWRON(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_GEN2_TXPWRON) | BF_HDMI_PHY_CONF0_GEN2_TXPWRON(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field GEN2_PDDQ[4] (RW)
 *
 * PHY_Gen2 PDDQ signal Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_GEN2_PDDQ      (4)      //!< Bit position for HDMI_PHY_CONF0_GEN2_PDDQ.
#define BM_HDMI_PHY_CONF0_GEN2_PDDQ      (0x00000010)  //!< Bit mask for HDMI_PHY_CONF0_GEN2_PDDQ.

//! @brief Get value of HDMI_PHY_CONF0_GEN2_PDDQ from a register value.
#define BG_HDMI_PHY_CONF0_GEN2_PDDQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_GEN2_PDDQ) >> BP_HDMI_PHY_CONF0_GEN2_PDDQ)

//! @brief Format value for bitfield HDMI_PHY_CONF0_GEN2_PDDQ.
#define BF_HDMI_PHY_CONF0_GEN2_PDDQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_GEN2_PDDQ) & BM_HDMI_PHY_CONF0_GEN2_PDDQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GEN2_PDDQ field to a new value.
#define BW_HDMI_PHY_CONF0_GEN2_PDDQ(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_GEN2_PDDQ) | BF_HDMI_PHY_CONF0_GEN2_PDDQ(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field SPARECTRL[5] (RW)
 *
 * Reserved. Spare pin control. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_SPARECTRL      (5)      //!< Bit position for HDMI_PHY_CONF0_SPARECTRL.
#define BM_HDMI_PHY_CONF0_SPARECTRL      (0x00000020)  //!< Bit mask for HDMI_PHY_CONF0_SPARECTRL.

//! @brief Get value of HDMI_PHY_CONF0_SPARECTRL from a register value.
#define BG_HDMI_PHY_CONF0_SPARECTRL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_SPARECTRL) >> BP_HDMI_PHY_CONF0_SPARECTRL)

//! @brief Format value for bitfield HDMI_PHY_CONF0_SPARECTRL.
#define BF_HDMI_PHY_CONF0_SPARECTRL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_SPARECTRL) & BM_HDMI_PHY_CONF0_SPARECTRL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPARECTRL field to a new value.
#define BW_HDMI_PHY_CONF0_SPARECTRL(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_SPARECTRL) | BF_HDMI_PHY_CONF0_SPARECTRL(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field ENTMDS[6] (RW)
 *
 * Enable TMDS drivers, bias, and TMDS digital logic. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_ENTMDS      (6)      //!< Bit position for HDMI_PHY_CONF0_ENTMDS.
#define BM_HDMI_PHY_CONF0_ENTMDS      (0x00000040)  //!< Bit mask for HDMI_PHY_CONF0_ENTMDS.

//! @brief Get value of HDMI_PHY_CONF0_ENTMDS from a register value.
#define BG_HDMI_PHY_CONF0_ENTMDS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_ENTMDS) >> BP_HDMI_PHY_CONF0_ENTMDS)

//! @brief Format value for bitfield HDMI_PHY_CONF0_ENTMDS.
#define BF_HDMI_PHY_CONF0_ENTMDS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_ENTMDS) & BM_HDMI_PHY_CONF0_ENTMDS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENTMDS field to a new value.
#define BW_HDMI_PHY_CONF0_ENTMDS(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_ENTMDS) | BF_HDMI_PHY_CONF0_ENTMDS(v)))
#endif
//@}

/*! @name Register HDMI_PHY_CONF0, field PDZ[7] (RW)
 *
 * Power-down enable (active low 0b). Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_CONF0_PDZ      (7)      //!< Bit position for HDMI_PHY_CONF0_PDZ.
#define BM_HDMI_PHY_CONF0_PDZ      (0x00000080)  //!< Bit mask for HDMI_PHY_CONF0_PDZ.

//! @brief Get value of HDMI_PHY_CONF0_PDZ from a register value.
#define BG_HDMI_PHY_CONF0_PDZ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_CONF0_PDZ) >> BP_HDMI_PHY_CONF0_PDZ)

//! @brief Format value for bitfield HDMI_PHY_CONF0_PDZ.
#define BF_HDMI_PHY_CONF0_PDZ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_CONF0_PDZ) & BM_HDMI_PHY_CONF0_PDZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDZ field to a new value.
#define BW_HDMI_PHY_CONF0_PDZ(v)   (HW_HDMI_PHY_CONF0_WR((HW_HDMI_PHY_CONF0_RD() & ~BM_HDMI_PHY_CONF0_PDZ) | BF_HDMI_PHY_CONF0_PDZ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_TST0 - PHY Test Interface Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_TST0 - PHY Test Interface Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * PHY TX mapped text interface (control). For more information, refer to the DesignWare Cores HDMI
 * TX PHY Databook.
 */
typedef union _hw_hdmi_phy_tst0
{
    reg8_t U;
    struct _hw_hdmi_phy_tst0_bitfields
    {
        unsigned char TESTCLK : 1; //!< [0] Test clock signal.
        unsigned char RESERVED0 : 3; //!< [3:1] Reserved
        unsigned char TESTEN : 1; //!< [4] Reserved.
        unsigned char TESTCLR : 1; //!< [5] Enable TMDS drivers, bias and tmds digital logic.
        unsigned char RESERVED1 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_phy_tst0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_TST0 register
 */
//@{
#define HW_HDMI_PHY_TST0_ADDR      (REGS_HDMI_BASE + 0x3001)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_TST0           (*(volatile hw_hdmi_phy_tst0_t *) HW_HDMI_PHY_TST0_ADDR)
#define HW_HDMI_PHY_TST0_RD()      (HW_HDMI_PHY_TST0.U)
#define HW_HDMI_PHY_TST0_WR(v)     (HW_HDMI_PHY_TST0.U = (v))
#define HW_HDMI_PHY_TST0_SET(v)    (HW_HDMI_PHY_TST0_WR(HW_HDMI_PHY_TST0_RD() |  (v)))
#define HW_HDMI_PHY_TST0_CLR(v)    (HW_HDMI_PHY_TST0_WR(HW_HDMI_PHY_TST0_RD() & ~(v)))
#define HW_HDMI_PHY_TST0_TOG(v)    (HW_HDMI_PHY_TST0_WR(HW_HDMI_PHY_TST0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_TST0 bitfields
 */

/*! @name Register HDMI_PHY_TST0, field TESTCLK[0] (RW)
 *
 * Test clock signal. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_TST0_TESTCLK      (0)      //!< Bit position for HDMI_PHY_TST0_TESTCLK.
#define BM_HDMI_PHY_TST0_TESTCLK      (0x00000001)  //!< Bit mask for HDMI_PHY_TST0_TESTCLK.

//! @brief Get value of HDMI_PHY_TST0_TESTCLK from a register value.
#define BG_HDMI_PHY_TST0_TESTCLK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_TST0_TESTCLK) >> BP_HDMI_PHY_TST0_TESTCLK)

//! @brief Format value for bitfield HDMI_PHY_TST0_TESTCLK.
#define BF_HDMI_PHY_TST0_TESTCLK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_TST0_TESTCLK) & BM_HDMI_PHY_TST0_TESTCLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTCLK field to a new value.
#define BW_HDMI_PHY_TST0_TESTCLK(v)   (HW_HDMI_PHY_TST0_WR((HW_HDMI_PHY_TST0_RD() & ~BM_HDMI_PHY_TST0_TESTCLK) | BF_HDMI_PHY_TST0_TESTCLK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_TST0, field TESTEN[4] (RW)
 *
 * Reserved. Spare control pins. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_TST0_TESTEN      (4)      //!< Bit position for HDMI_PHY_TST0_TESTEN.
#define BM_HDMI_PHY_TST0_TESTEN      (0x00000010)  //!< Bit mask for HDMI_PHY_TST0_TESTEN.

//! @brief Get value of HDMI_PHY_TST0_TESTEN from a register value.
#define BG_HDMI_PHY_TST0_TESTEN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_TST0_TESTEN) >> BP_HDMI_PHY_TST0_TESTEN)

//! @brief Format value for bitfield HDMI_PHY_TST0_TESTEN.
#define BF_HDMI_PHY_TST0_TESTEN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_TST0_TESTEN) & BM_HDMI_PHY_TST0_TESTEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTEN field to a new value.
#define BW_HDMI_PHY_TST0_TESTEN(v)   (HW_HDMI_PHY_TST0_WR((HW_HDMI_PHY_TST0_RD() & ~BM_HDMI_PHY_TST0_TESTEN) | BF_HDMI_PHY_TST0_TESTEN(v)))
#endif
//@}

/*! @name Register HDMI_PHY_TST0, field TESTCLR[5] (RW)
 *
 * Enable TMDS drivers, bias and tmds digital logic. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_TST0_TESTCLR      (5)      //!< Bit position for HDMI_PHY_TST0_TESTCLR.
#define BM_HDMI_PHY_TST0_TESTCLR      (0x00000020)  //!< Bit mask for HDMI_PHY_TST0_TESTCLR.

//! @brief Get value of HDMI_PHY_TST0_TESTCLR from a register value.
#define BG_HDMI_PHY_TST0_TESTCLR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_TST0_TESTCLR) >> BP_HDMI_PHY_TST0_TESTCLR)

//! @brief Format value for bitfield HDMI_PHY_TST0_TESTCLR.
#define BF_HDMI_PHY_TST0_TESTCLR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_TST0_TESTCLR) & BM_HDMI_PHY_TST0_TESTCLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTCLR field to a new value.
#define BW_HDMI_PHY_TST0_TESTCLR(v)   (HW_HDMI_PHY_TST0_WR((HW_HDMI_PHY_TST0_RD() & ~BM_HDMI_PHY_TST0_TESTCLR) | BF_HDMI_PHY_TST0_TESTCLR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_TST1 - PHY Test Interface Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_TST1 - PHY Test Interface Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * PHY TX mapped text interface (data in). For more information, refer to the DesignWare Cores HDMI
 * TX PHY Databook.
 */
typedef union _hw_hdmi_phy_tst1
{
    reg8_t U;
    struct _hw_hdmi_phy_tst1_bitfields
    {
        unsigned char TESTDIN : 8; //!< [7:0] Test data input.
    } B;
} hw_hdmi_phy_tst1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_TST1 register
 */
//@{
#define HW_HDMI_PHY_TST1_ADDR      (REGS_HDMI_BASE + 0x3002)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_TST1           (*(volatile hw_hdmi_phy_tst1_t *) HW_HDMI_PHY_TST1_ADDR)
#define HW_HDMI_PHY_TST1_RD()      (HW_HDMI_PHY_TST1.U)
#define HW_HDMI_PHY_TST1_WR(v)     (HW_HDMI_PHY_TST1.U = (v))
#define HW_HDMI_PHY_TST1_SET(v)    (HW_HDMI_PHY_TST1_WR(HW_HDMI_PHY_TST1_RD() |  (v)))
#define HW_HDMI_PHY_TST1_CLR(v)    (HW_HDMI_PHY_TST1_WR(HW_HDMI_PHY_TST1_RD() & ~(v)))
#define HW_HDMI_PHY_TST1_TOG(v)    (HW_HDMI_PHY_TST1_WR(HW_HDMI_PHY_TST1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_TST1 bitfields
 */

/*! @name Register HDMI_PHY_TST1, field TESTDIN[7:0] (RW)
 *
 * Test data input.
 */
//@{
#define BP_HDMI_PHY_TST1_TESTDIN      (0)      //!< Bit position for HDMI_PHY_TST1_TESTDIN.
#define BM_HDMI_PHY_TST1_TESTDIN      (0x000000ff)  //!< Bit mask for HDMI_PHY_TST1_TESTDIN.

//! @brief Get value of HDMI_PHY_TST1_TESTDIN from a register value.
#define BG_HDMI_PHY_TST1_TESTDIN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_TST1_TESTDIN) >> BP_HDMI_PHY_TST1_TESTDIN)

//! @brief Format value for bitfield HDMI_PHY_TST1_TESTDIN.
#define BF_HDMI_PHY_TST1_TESTDIN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_TST1_TESTDIN) & BM_HDMI_PHY_TST1_TESTDIN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTDIN field to a new value.
#define BW_HDMI_PHY_TST1_TESTDIN(v)   (HW_HDMI_PHY_TST1_WR((HW_HDMI_PHY_TST1_RD() & ~BM_HDMI_PHY_TST1_TESTDIN) | BF_HDMI_PHY_TST1_TESTDIN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_TST2 - PHY Test Interface Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_TST2 - PHY Test Interface Register 2 (RO)
 *
 * Reset value: 0x00
 *
 * PHY TX mapped text interface (data out). For more information, refer to the DesignWare Cores HDMI
 * TX PHY Databook.
 */
typedef union _hw_hdmi_phy_tst2
{
    reg8_t U;
    struct _hw_hdmi_phy_tst2_bitfields
    {
        unsigned char TESTDOUT : 8; //!< [7:0] Test data output.
    } B;
} hw_hdmi_phy_tst2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_TST2 register
 */
//@{
#define HW_HDMI_PHY_TST2_ADDR      (REGS_HDMI_BASE + 0x3003)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_TST2           (*(volatile hw_hdmi_phy_tst2_t *) HW_HDMI_PHY_TST2_ADDR)
#define HW_HDMI_PHY_TST2_RD()      (HW_HDMI_PHY_TST2.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_TST2 bitfields
 */

/*! @name Register HDMI_PHY_TST2, field TESTDOUT[7:0] (RO)
 *
 * Test data output.
 */
//@{
#define BP_HDMI_PHY_TST2_TESTDOUT      (0)      //!< Bit position for HDMI_PHY_TST2_TESTDOUT.
#define BM_HDMI_PHY_TST2_TESTDOUT      (0x000000ff)  //!< Bit mask for HDMI_PHY_TST2_TESTDOUT.

//! @brief Get value of HDMI_PHY_TST2_TESTDOUT from a register value.
#define BG_HDMI_PHY_TST2_TESTDOUT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_TST2_TESTDOUT) >> BP_HDMI_PHY_TST2_TESTDOUT)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_STAT0 - PHY RXSENSE, PLL lock, and HPD Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_STAT0 - PHY RXSENSE, PLL lock, and HPD Status Register (RO)
 *
 * Reset value: 0x00
 *
 * This register contains the following active high packet sent status indications. For more
 * information, see
 */
typedef union _hw_hdmi_phy_stat0
{
    reg8_t U;
    struct _hw_hdmi_phy_stat0_bitfields
    {
        unsigned char TX_PHY_LOCK : 1; //!< [0] Status bit.
        unsigned char HPD : 1; //!< [1] Status bit.
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char RX_SENSE : 1; //!< [4] Status bit.
        unsigned char RX_SENSE1 : 1; //!< [5] Status bit.
        unsigned char RX_SENSE2 : 1; //!< [6] Status bit.
        unsigned char RX_SENSE3 : 1; //!< [7] Status bit.
    } B;
} hw_hdmi_phy_stat0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_STAT0 register
 */
//@{
#define HW_HDMI_PHY_STAT0_ADDR      (REGS_HDMI_BASE + 0x3004)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_STAT0           (*(volatile hw_hdmi_phy_stat0_t *) HW_HDMI_PHY_STAT0_ADDR)
#define HW_HDMI_PHY_STAT0_RD()      (HW_HDMI_PHY_STAT0.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_STAT0 bitfields
 */

/*! @name Register HDMI_PHY_STAT0, field TX_PHY_LOCK[0] (RO)
 *
 * Status bit. TX PHY PLL lock indication. Please refer to PHY datasheet for more information. User
 * may need to mask or change polarity of this interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_TX_PHY_LOCK      (0)      //!< Bit position for HDMI_PHY_STAT0_TX_PHY_LOCK.
#define BM_HDMI_PHY_STAT0_TX_PHY_LOCK      (0x00000001)  //!< Bit mask for HDMI_PHY_STAT0_TX_PHY_LOCK.

//! @brief Get value of HDMI_PHY_STAT0_TX_PHY_LOCK from a register value.
#define BG_HDMI_PHY_STAT0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_TX_PHY_LOCK) >> BP_HDMI_PHY_STAT0_TX_PHY_LOCK)
//@}

/*! @name Register HDMI_PHY_STAT0, field HPD[1] (RO)
 *
 * Status bit. HDMI Hot Plug Detect indication. User may need to mask or change polarity of this
 * interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_HPD      (1)      //!< Bit position for HDMI_PHY_STAT0_HPD.
#define BM_HDMI_PHY_STAT0_HPD      (0x00000002)  //!< Bit mask for HDMI_PHY_STAT0_HPD.

//! @brief Get value of HDMI_PHY_STAT0_HPD from a register value.
#define BG_HDMI_PHY_STAT0_HPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_HPD) >> BP_HDMI_PHY_STAT0_HPD)
//@}

/*! @name Register HDMI_PHY_STAT0, field RX_SENSE[4] (RO)
 *
 * Status bit. TX PHY RX_SENSE indication for TMDS channel 0 driver. User may need to mask or change
 * polarity of this interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_RX_SENSE      (4)      //!< Bit position for HDMI_PHY_STAT0_RX_SENSE.
#define BM_HDMI_PHY_STAT0_RX_SENSE      (0x00000010)  //!< Bit mask for HDMI_PHY_STAT0_RX_SENSE.

//! @brief Get value of HDMI_PHY_STAT0_RX_SENSE from a register value.
#define BG_HDMI_PHY_STAT0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_RX_SENSE) >> BP_HDMI_PHY_STAT0_RX_SENSE)
//@}

/*! @name Register HDMI_PHY_STAT0, field RX_SENSE1[5] (RO)
 *
 * Status bit. TX PHY RX_SENSE indication for TMDS channel 1 driver. User may need to mask or change
 * polarity of this interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_RX_SENSE1      (5)      //!< Bit position for HDMI_PHY_STAT0_RX_SENSE1.
#define BM_HDMI_PHY_STAT0_RX_SENSE1      (0x00000020)  //!< Bit mask for HDMI_PHY_STAT0_RX_SENSE1.

//! @brief Get value of HDMI_PHY_STAT0_RX_SENSE1 from a register value.
#define BG_HDMI_PHY_STAT0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_RX_SENSE1) >> BP_HDMI_PHY_STAT0_RX_SENSE1)
//@}

/*! @name Register HDMI_PHY_STAT0, field RX_SENSE2[6] (RO)
 *
 * Status bit. TX PHY RX_SENSE indication for TMDS channel 2 driver. User may need to mask or change
 * polarity of this interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_RX_SENSE2      (6)      //!< Bit position for HDMI_PHY_STAT0_RX_SENSE2.
#define BM_HDMI_PHY_STAT0_RX_SENSE2      (0x00000040)  //!< Bit mask for HDMI_PHY_STAT0_RX_SENSE2.

//! @brief Get value of HDMI_PHY_STAT0_RX_SENSE2 from a register value.
#define BG_HDMI_PHY_STAT0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_RX_SENSE2) >> BP_HDMI_PHY_STAT0_RX_SENSE2)
//@}

/*! @name Register HDMI_PHY_STAT0, field RX_SENSE3[7] (RO)
 *
 * Status bit. TX PHY RX_SENSE indication for TMDS CLK driver. User may need to mask or change
 * polarity of this interrupt after it has became active.
 */
//@{
#define BP_HDMI_PHY_STAT0_RX_SENSE3      (7)      //!< Bit position for HDMI_PHY_STAT0_RX_SENSE3.
#define BM_HDMI_PHY_STAT0_RX_SENSE3      (0x00000080)  //!< Bit mask for HDMI_PHY_STAT0_RX_SENSE3.

//! @brief Get value of HDMI_PHY_STAT0_RX_SENSE3 from a register value.
#define BG_HDMI_PHY_STAT0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_STAT0_RX_SENSE3) >> BP_HDMI_PHY_STAT0_RX_SENSE3)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_INT0 - PHY RXSENSE, PLL lock, and HPD Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_INT0 - PHY RXSENSE, PLL lock, and HPD Interrupt Register (RO)
 *
 * Reset value: 0x00
 *
 * This register contains the interrupt indication of the PHY_STAT0 status interrupts. Interrupt
 * generation is accomplished in the following way: interrupt = (mask == 1'b0) && (polarity ==
 * status); All this interrupts are forwarded to the Interrupt Handler sticky bit registers and
 * after ORed to a single main interrupt line to micro controller. Assertion of this interrupt
 * implies that data related with the corresponding packet has been sent through the HDMI interface.
 */
typedef union _hw_hdmi_phy_int0
{
    reg8_t U;
    struct _hw_hdmi_phy_int0_bitfields
    {
        unsigned char TX_PHY_LOCK : 1; //!< [0] Interrupt indication bit
        unsigned char HPD : 1; //!< [1] Interrupt indication bit
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char RX_SENSE : 1; //!< [4] Interrupt indication bit
        unsigned char RX_SENSE1 : 1; //!< [5] Interrupt indication bit
        unsigned char RX_SENSE2 : 1; //!< [6] Interrupt indication bit
        unsigned char RX_SENSE3 : 1; //!< [7] Interrupt indication bit
    } B;
} hw_hdmi_phy_int0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_INT0 register
 */
//@{
#define HW_HDMI_PHY_INT0_ADDR      (REGS_HDMI_BASE + 0x3005)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_INT0           (*(volatile hw_hdmi_phy_int0_t *) HW_HDMI_PHY_INT0_ADDR)
#define HW_HDMI_PHY_INT0_RD()      (HW_HDMI_PHY_INT0.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_INT0 bitfields
 */

/*! @name Register HDMI_PHY_INT0, field TX_PHY_LOCK[0] (RO)
 *
 * Interrupt indication bit TX PHY PLL lock indication interrupt.
 */
//@{
#define BP_HDMI_PHY_INT0_TX_PHY_LOCK      (0)      //!< Bit position for HDMI_PHY_INT0_TX_PHY_LOCK.
#define BM_HDMI_PHY_INT0_TX_PHY_LOCK      (0x00000001)  //!< Bit mask for HDMI_PHY_INT0_TX_PHY_LOCK.

//! @brief Get value of HDMI_PHY_INT0_TX_PHY_LOCK from a register value.
#define BG_HDMI_PHY_INT0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_TX_PHY_LOCK) >> BP_HDMI_PHY_INT0_TX_PHY_LOCK)
//@}

/*! @name Register HDMI_PHY_INT0, field HPD[1] (RO)
 *
 * Interrupt indication bit HDMI Hot Plug Detect indication interrupt.
 */
//@{
#define BP_HDMI_PHY_INT0_HPD      (1)      //!< Bit position for HDMI_PHY_INT0_HPD.
#define BM_HDMI_PHY_INT0_HPD      (0x00000002)  //!< Bit mask for HDMI_PHY_INT0_HPD.

//! @brief Get value of HDMI_PHY_INT0_HPD from a register value.
#define BG_HDMI_PHY_INT0_HPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_HPD) >> BP_HDMI_PHY_INT0_HPD)
//@}

/*! @name Register HDMI_PHY_INT0, field RX_SENSE[4] (RO)
 *
 * Interrupt indication bit TX PHY RX_SENSE indication interrupt for TMDS channel 0 driver.
 */
//@{
#define BP_HDMI_PHY_INT0_RX_SENSE      (4)      //!< Bit position for HDMI_PHY_INT0_RX_SENSE.
#define BM_HDMI_PHY_INT0_RX_SENSE      (0x00000010)  //!< Bit mask for HDMI_PHY_INT0_RX_SENSE.

//! @brief Get value of HDMI_PHY_INT0_RX_SENSE from a register value.
#define BG_HDMI_PHY_INT0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_RX_SENSE) >> BP_HDMI_PHY_INT0_RX_SENSE)
//@}

/*! @name Register HDMI_PHY_INT0, field RX_SENSE1[5] (RO)
 *
 * Interrupt indication bit TX PHY RX_SENSE indication interrupt for TMDS channel 1 driver.
 */
//@{
#define BP_HDMI_PHY_INT0_RX_SENSE1      (5)      //!< Bit position for HDMI_PHY_INT0_RX_SENSE1.
#define BM_HDMI_PHY_INT0_RX_SENSE1      (0x00000020)  //!< Bit mask for HDMI_PHY_INT0_RX_SENSE1.

//! @brief Get value of HDMI_PHY_INT0_RX_SENSE1 from a register value.
#define BG_HDMI_PHY_INT0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_RX_SENSE1) >> BP_HDMI_PHY_INT0_RX_SENSE1)
//@}

/*! @name Register HDMI_PHY_INT0, field RX_SENSE2[6] (RO)
 *
 * Interrupt indication bit TX PHY RX_SENSE indication interrupt for TMDS channel 2 driver.
 */
//@{
#define BP_HDMI_PHY_INT0_RX_SENSE2      (6)      //!< Bit position for HDMI_PHY_INT0_RX_SENSE2.
#define BM_HDMI_PHY_INT0_RX_SENSE2      (0x00000040)  //!< Bit mask for HDMI_PHY_INT0_RX_SENSE2.

//! @brief Get value of HDMI_PHY_INT0_RX_SENSE2 from a register value.
#define BG_HDMI_PHY_INT0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_RX_SENSE2) >> BP_HDMI_PHY_INT0_RX_SENSE2)
//@}

/*! @name Register HDMI_PHY_INT0, field RX_SENSE3[7] (RO)
 *
 * Interrupt indication bit TX PHY RX_SENSE indication interrupt for TMDS CLK driver.
 */
//@{
#define BP_HDMI_PHY_INT0_RX_SENSE3      (7)      //!< Bit position for HDMI_PHY_INT0_RX_SENSE3.
#define BM_HDMI_PHY_INT0_RX_SENSE3      (0x00000080)  //!< Bit mask for HDMI_PHY_INT0_RX_SENSE3.

//! @brief Get value of HDMI_PHY_INT0_RX_SENSE3 from a register value.
#define BG_HDMI_PHY_INT0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_INT0_RX_SENSE3) >> BP_HDMI_PHY_INT0_RX_SENSE3)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_MASK0 - PHY RXSENSE, PLL lock, and HPD Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_MASK0 - PHY RXSENSE, PLL lock, and HPD Mask Register (RW)
 *
 * Reset value: 0x00
 *
 * Mask register for generation of PHY_INT0 interrupts.
 */
typedef union _hw_hdmi_phy_mask0
{
    reg8_t U;
    struct _hw_hdmi_phy_mask0_bitfields
    {
        unsigned char TX_PHY_LOCK : 1; //!< [0] Mask bit for PHY_INT0.TX_PHY_LOCK interrupt bit
        unsigned char HPD : 1; //!< [1] Mask bit for PHY_INT0.HPD interrupt bit
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char RX_SENSE : 1; //!< [4] Mask bit for PHY_INT0.RX_SENSE[0] interrupt bit
        unsigned char RX_SENSE1 : 1; //!< [5] Mask bit for PHY_INT0.RX_SENSE[1] interrupt bit
        unsigned char RX_SENSE2 : 1; //!< [6] Mask bit for PHY_INT0.RX_SENSE[2] interrupt bit
        unsigned char RX_SENSE3 : 1; //!< [7] Mask bit for PHY_INT0.RX_SENSE[3] interrupt bit
    } B;
} hw_hdmi_phy_mask0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_MASK0 register
 */
//@{
#define HW_HDMI_PHY_MASK0_ADDR      (REGS_HDMI_BASE + 0x3006)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_MASK0           (*(volatile hw_hdmi_phy_mask0_t *) HW_HDMI_PHY_MASK0_ADDR)
#define HW_HDMI_PHY_MASK0_RD()      (HW_HDMI_PHY_MASK0.U)
#define HW_HDMI_PHY_MASK0_WR(v)     (HW_HDMI_PHY_MASK0.U = (v))
#define HW_HDMI_PHY_MASK0_SET(v)    (HW_HDMI_PHY_MASK0_WR(HW_HDMI_PHY_MASK0_RD() |  (v)))
#define HW_HDMI_PHY_MASK0_CLR(v)    (HW_HDMI_PHY_MASK0_WR(HW_HDMI_PHY_MASK0_RD() & ~(v)))
#define HW_HDMI_PHY_MASK0_TOG(v)    (HW_HDMI_PHY_MASK0_WR(HW_HDMI_PHY_MASK0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_MASK0 bitfields
 */

/*! @name Register HDMI_PHY_MASK0, field TX_PHY_LOCK[0] (RW)
 *
 * Mask bit for PHY_INT0.TX_PHY_LOCK interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_TX_PHY_LOCK      (0)      //!< Bit position for HDMI_PHY_MASK0_TX_PHY_LOCK.
#define BM_HDMI_PHY_MASK0_TX_PHY_LOCK      (0x00000001)  //!< Bit mask for HDMI_PHY_MASK0_TX_PHY_LOCK.

//! @brief Get value of HDMI_PHY_MASK0_TX_PHY_LOCK from a register value.
#define BG_HDMI_PHY_MASK0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_TX_PHY_LOCK) >> BP_HDMI_PHY_MASK0_TX_PHY_LOCK)

//! @brief Format value for bitfield HDMI_PHY_MASK0_TX_PHY_LOCK.
#define BF_HDMI_PHY_MASK0_TX_PHY_LOCK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_TX_PHY_LOCK) & BM_HDMI_PHY_MASK0_TX_PHY_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_PHY_LOCK field to a new value.
#define BW_HDMI_PHY_MASK0_TX_PHY_LOCK(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_TX_PHY_LOCK) | BF_HDMI_PHY_MASK0_TX_PHY_LOCK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_MASK0, field HPD[1] (RW)
 *
 * Mask bit for PHY_INT0.HPD interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_HPD      (1)      //!< Bit position for HDMI_PHY_MASK0_HPD.
#define BM_HDMI_PHY_MASK0_HPD      (0x00000002)  //!< Bit mask for HDMI_PHY_MASK0_HPD.

//! @brief Get value of HDMI_PHY_MASK0_HPD from a register value.
#define BG_HDMI_PHY_MASK0_HPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_HPD) >> BP_HDMI_PHY_MASK0_HPD)

//! @brief Format value for bitfield HDMI_PHY_MASK0_HPD.
#define BF_HDMI_PHY_MASK0_HPD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_HPD) & BM_HDMI_PHY_MASK0_HPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPD field to a new value.
#define BW_HDMI_PHY_MASK0_HPD(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_HPD) | BF_HDMI_PHY_MASK0_HPD(v)))
#endif
//@}

/*! @name Register HDMI_PHY_MASK0, field RX_SENSE[4] (RW)
 *
 * Mask bit for PHY_INT0.RX_SENSE[0] interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_RX_SENSE      (4)      //!< Bit position for HDMI_PHY_MASK0_RX_SENSE.
#define BM_HDMI_PHY_MASK0_RX_SENSE      (0x00000010)  //!< Bit mask for HDMI_PHY_MASK0_RX_SENSE.

//! @brief Get value of HDMI_PHY_MASK0_RX_SENSE from a register value.
#define BG_HDMI_PHY_MASK0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_RX_SENSE) >> BP_HDMI_PHY_MASK0_RX_SENSE)

//! @brief Format value for bitfield HDMI_PHY_MASK0_RX_SENSE.
#define BF_HDMI_PHY_MASK0_RX_SENSE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_RX_SENSE) & BM_HDMI_PHY_MASK0_RX_SENSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE field to a new value.
#define BW_HDMI_PHY_MASK0_RX_SENSE(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_RX_SENSE) | BF_HDMI_PHY_MASK0_RX_SENSE(v)))
#endif
//@}

/*! @name Register HDMI_PHY_MASK0, field RX_SENSE1[5] (RW)
 *
 * Mask bit for PHY_INT0.RX_SENSE[1] interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_RX_SENSE1      (5)      //!< Bit position for HDMI_PHY_MASK0_RX_SENSE1.
#define BM_HDMI_PHY_MASK0_RX_SENSE1      (0x00000020)  //!< Bit mask for HDMI_PHY_MASK0_RX_SENSE1.

//! @brief Get value of HDMI_PHY_MASK0_RX_SENSE1 from a register value.
#define BG_HDMI_PHY_MASK0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_RX_SENSE1) >> BP_HDMI_PHY_MASK0_RX_SENSE1)

//! @brief Format value for bitfield HDMI_PHY_MASK0_RX_SENSE1.
#define BF_HDMI_PHY_MASK0_RX_SENSE1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_RX_SENSE1) & BM_HDMI_PHY_MASK0_RX_SENSE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE1 field to a new value.
#define BW_HDMI_PHY_MASK0_RX_SENSE1(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_RX_SENSE1) | BF_HDMI_PHY_MASK0_RX_SENSE1(v)))
#endif
//@}

/*! @name Register HDMI_PHY_MASK0, field RX_SENSE2[6] (RW)
 *
 * Mask bit for PHY_INT0.RX_SENSE[2] interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_RX_SENSE2      (6)      //!< Bit position for HDMI_PHY_MASK0_RX_SENSE2.
#define BM_HDMI_PHY_MASK0_RX_SENSE2      (0x00000040)  //!< Bit mask for HDMI_PHY_MASK0_RX_SENSE2.

//! @brief Get value of HDMI_PHY_MASK0_RX_SENSE2 from a register value.
#define BG_HDMI_PHY_MASK0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_RX_SENSE2) >> BP_HDMI_PHY_MASK0_RX_SENSE2)

//! @brief Format value for bitfield HDMI_PHY_MASK0_RX_SENSE2.
#define BF_HDMI_PHY_MASK0_RX_SENSE2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_RX_SENSE2) & BM_HDMI_PHY_MASK0_RX_SENSE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE2 field to a new value.
#define BW_HDMI_PHY_MASK0_RX_SENSE2(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_RX_SENSE2) | BF_HDMI_PHY_MASK0_RX_SENSE2(v)))
#endif
//@}

/*! @name Register HDMI_PHY_MASK0, field RX_SENSE3[7] (RW)
 *
 * Mask bit for PHY_INT0.RX_SENSE[3] interrupt bit
 */
//@{
#define BP_HDMI_PHY_MASK0_RX_SENSE3      (7)      //!< Bit position for HDMI_PHY_MASK0_RX_SENSE3.
#define BM_HDMI_PHY_MASK0_RX_SENSE3      (0x00000080)  //!< Bit mask for HDMI_PHY_MASK0_RX_SENSE3.

//! @brief Get value of HDMI_PHY_MASK0_RX_SENSE3 from a register value.
#define BG_HDMI_PHY_MASK0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_MASK0_RX_SENSE3) >> BP_HDMI_PHY_MASK0_RX_SENSE3)

//! @brief Format value for bitfield HDMI_PHY_MASK0_RX_SENSE3.
#define BF_HDMI_PHY_MASK0_RX_SENSE3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_MASK0_RX_SENSE3) & BM_HDMI_PHY_MASK0_RX_SENSE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE3 field to a new value.
#define BW_HDMI_PHY_MASK0_RX_SENSE3(v)   (HW_HDMI_PHY_MASK0_WR((HW_HDMI_PHY_MASK0_RD() & ~BM_HDMI_PHY_MASK0_RX_SENSE3) | BF_HDMI_PHY_MASK0_RX_SENSE3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_POL0 - PHY RXSENSE, PLL lock and HPD Polarity Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_POL0 - PHY RXSENSE, PLL lock and HPD Polarity Register (RW)
 *
 * Reset value: 0xf3
 *
 * Polarity register for generation of PHY_INT0 interrupts.
 */
typedef union _hw_hdmi_phy_pol0
{
    reg8_t U;
    struct _hw_hdmi_phy_pol0_bitfields
    {
        unsigned char TX_PHY_LOCK : 1; //!< [0] Polarity bit for PHY_INT0.TX_PHY_LOCK interrupt bit
        unsigned char HPD : 1; //!< [1] Polarity bit for PHY_INT0.HPD interrupt bit
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char RX_SENSE : 1; //!< [4] Polarity bit for PHY_INT0.RX_SENSE[0] interrupt bit
        unsigned char RX_SENSE1 : 1; //!< [5] Polarity bit for PHY_INT0.RX_SENSE[1] interrupt bit
        unsigned char RX_SENSE2 : 1; //!< [6] Polarity bit for PHY_INT0.RX_SENSE[2] interrupt bit
        unsigned char RX_SENSE3 : 1; //!< [7] Polarity bit for PHY_INT0.RX_SENSE[3] interrupt bit
    } B;
} hw_hdmi_phy_pol0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_POL0 register
 */
//@{
#define HW_HDMI_PHY_POL0_ADDR      (REGS_HDMI_BASE + 0x3007)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_POL0           (*(volatile hw_hdmi_phy_pol0_t *) HW_HDMI_PHY_POL0_ADDR)
#define HW_HDMI_PHY_POL0_RD()      (HW_HDMI_PHY_POL0.U)
#define HW_HDMI_PHY_POL0_WR(v)     (HW_HDMI_PHY_POL0.U = (v))
#define HW_HDMI_PHY_POL0_SET(v)    (HW_HDMI_PHY_POL0_WR(HW_HDMI_PHY_POL0_RD() |  (v)))
#define HW_HDMI_PHY_POL0_CLR(v)    (HW_HDMI_PHY_POL0_WR(HW_HDMI_PHY_POL0_RD() & ~(v)))
#define HW_HDMI_PHY_POL0_TOG(v)    (HW_HDMI_PHY_POL0_WR(HW_HDMI_PHY_POL0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_POL0 bitfields
 */

/*! @name Register HDMI_PHY_POL0, field TX_PHY_LOCK[0] (RW)
 *
 * Polarity bit for PHY_INT0.TX_PHY_LOCK interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_TX_PHY_LOCK      (0)      //!< Bit position for HDMI_PHY_POL0_TX_PHY_LOCK.
#define BM_HDMI_PHY_POL0_TX_PHY_LOCK      (0x00000001)  //!< Bit mask for HDMI_PHY_POL0_TX_PHY_LOCK.

//! @brief Get value of HDMI_PHY_POL0_TX_PHY_LOCK from a register value.
#define BG_HDMI_PHY_POL0_TX_PHY_LOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_TX_PHY_LOCK) >> BP_HDMI_PHY_POL0_TX_PHY_LOCK)

//! @brief Format value for bitfield HDMI_PHY_POL0_TX_PHY_LOCK.
#define BF_HDMI_PHY_POL0_TX_PHY_LOCK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_TX_PHY_LOCK) & BM_HDMI_PHY_POL0_TX_PHY_LOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_PHY_LOCK field to a new value.
#define BW_HDMI_PHY_POL0_TX_PHY_LOCK(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_TX_PHY_LOCK) | BF_HDMI_PHY_POL0_TX_PHY_LOCK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_POL0, field HPD[1] (RW)
 *
 * Polarity bit for PHY_INT0.HPD interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_HPD      (1)      //!< Bit position for HDMI_PHY_POL0_HPD.
#define BM_HDMI_PHY_POL0_HPD      (0x00000002)  //!< Bit mask for HDMI_PHY_POL0_HPD.

//! @brief Get value of HDMI_PHY_POL0_HPD from a register value.
#define BG_HDMI_PHY_POL0_HPD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_HPD) >> BP_HDMI_PHY_POL0_HPD)

//! @brief Format value for bitfield HDMI_PHY_POL0_HPD.
#define BF_HDMI_PHY_POL0_HPD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_HPD) & BM_HDMI_PHY_POL0_HPD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPD field to a new value.
#define BW_HDMI_PHY_POL0_HPD(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_HPD) | BF_HDMI_PHY_POL0_HPD(v)))
#endif
//@}

/*! @name Register HDMI_PHY_POL0, field RX_SENSE[4] (RW)
 *
 * Polarity bit for PHY_INT0.RX_SENSE[0] interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_RX_SENSE      (4)      //!< Bit position for HDMI_PHY_POL0_RX_SENSE.
#define BM_HDMI_PHY_POL0_RX_SENSE      (0x00000010)  //!< Bit mask for HDMI_PHY_POL0_RX_SENSE.

//! @brief Get value of HDMI_PHY_POL0_RX_SENSE from a register value.
#define BG_HDMI_PHY_POL0_RX_SENSE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_RX_SENSE) >> BP_HDMI_PHY_POL0_RX_SENSE)

//! @brief Format value for bitfield HDMI_PHY_POL0_RX_SENSE.
#define BF_HDMI_PHY_POL0_RX_SENSE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_RX_SENSE) & BM_HDMI_PHY_POL0_RX_SENSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE field to a new value.
#define BW_HDMI_PHY_POL0_RX_SENSE(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_RX_SENSE) | BF_HDMI_PHY_POL0_RX_SENSE(v)))
#endif
//@}

/*! @name Register HDMI_PHY_POL0, field RX_SENSE1[5] (RW)
 *
 * Polarity bit for PHY_INT0.RX_SENSE[1] interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_RX_SENSE1      (5)      //!< Bit position for HDMI_PHY_POL0_RX_SENSE1.
#define BM_HDMI_PHY_POL0_RX_SENSE1      (0x00000020)  //!< Bit mask for HDMI_PHY_POL0_RX_SENSE1.

//! @brief Get value of HDMI_PHY_POL0_RX_SENSE1 from a register value.
#define BG_HDMI_PHY_POL0_RX_SENSE1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_RX_SENSE1) >> BP_HDMI_PHY_POL0_RX_SENSE1)

//! @brief Format value for bitfield HDMI_PHY_POL0_RX_SENSE1.
#define BF_HDMI_PHY_POL0_RX_SENSE1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_RX_SENSE1) & BM_HDMI_PHY_POL0_RX_SENSE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE1 field to a new value.
#define BW_HDMI_PHY_POL0_RX_SENSE1(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_RX_SENSE1) | BF_HDMI_PHY_POL0_RX_SENSE1(v)))
#endif
//@}

/*! @name Register HDMI_PHY_POL0, field RX_SENSE2[6] (RW)
 *
 * Polarity bit for PHY_INT0.RX_SENSE[2] interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_RX_SENSE2      (6)      //!< Bit position for HDMI_PHY_POL0_RX_SENSE2.
#define BM_HDMI_PHY_POL0_RX_SENSE2      (0x00000040)  //!< Bit mask for HDMI_PHY_POL0_RX_SENSE2.

//! @brief Get value of HDMI_PHY_POL0_RX_SENSE2 from a register value.
#define BG_HDMI_PHY_POL0_RX_SENSE2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_RX_SENSE2) >> BP_HDMI_PHY_POL0_RX_SENSE2)

//! @brief Format value for bitfield HDMI_PHY_POL0_RX_SENSE2.
#define BF_HDMI_PHY_POL0_RX_SENSE2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_RX_SENSE2) & BM_HDMI_PHY_POL0_RX_SENSE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE2 field to a new value.
#define BW_HDMI_PHY_POL0_RX_SENSE2(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_RX_SENSE2) | BF_HDMI_PHY_POL0_RX_SENSE2(v)))
#endif
//@}

/*! @name Register HDMI_PHY_POL0, field RX_SENSE3[7] (RW)
 *
 * Polarity bit for PHY_INT0.RX_SENSE[3] interrupt bit
 */
//@{
#define BP_HDMI_PHY_POL0_RX_SENSE3      (7)      //!< Bit position for HDMI_PHY_POL0_RX_SENSE3.
#define BM_HDMI_PHY_POL0_RX_SENSE3      (0x00000080)  //!< Bit mask for HDMI_PHY_POL0_RX_SENSE3.

//! @brief Get value of HDMI_PHY_POL0_RX_SENSE3 from a register value.
#define BG_HDMI_PHY_POL0_RX_SENSE3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_POL0_RX_SENSE3) >> BP_HDMI_PHY_POL0_RX_SENSE3)

//! @brief Format value for bitfield HDMI_PHY_POL0_RX_SENSE3.
#define BF_HDMI_PHY_POL0_RX_SENSE3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_POL0_RX_SENSE3) & BM_HDMI_PHY_POL0_RX_SENSE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SENSE3 field to a new value.
#define BW_HDMI_PHY_POL0_RX_SENSE3(v)   (HW_HDMI_PHY_POL0_WR((HW_HDMI_PHY_POL0_RD() & ~BM_HDMI_PHY_POL0_RX_SENSE3) | BF_HDMI_PHY_POL0_RX_SENSE3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SLAVE_ADDR - PHY I2C Slave Address Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SLAVE_ADDR - PHY I2C Slave Address Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * This register writes the slave address of the I2C Master PHY.
 */
typedef union _hw_hdmi_phy_i2cm_slave_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_slave_addr_bitfields
    {
        unsigned char RESERVED0 : 8; //!< [7:0] Reserved.
    } B;
} hw_hdmi_phy_i2cm_slave_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SLAVE_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_ADDR      (REGS_HDMI_BASE + 0x3020)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR           (*(volatile hw_hdmi_phy_i2cm_slave_addr_t *) HW_HDMI_PHY_I2CM_SLAVE_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_RD()      (HW_HDMI_PHY_I2CM_SLAVE_ADDR.U)
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SLAVE_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SLAVE_ADDR_WR(HW_HDMI_PHY_I2CM_SLAVE_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SLAVE_ADDR_WR(HW_HDMI_PHY_I2CM_SLAVE_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SLAVE_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SLAVE_ADDR_WR(HW_HDMI_PHY_I2CM_SLAVE_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SLAVE_ADDR bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_ADDRESS_ADDR - PHY I2C Address Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_ADDRESS_ADDR - PHY I2C Address Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * This register writes the address for read and writer operations.
 */
typedef union _hw_hdmi_phy_i2cm_address_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_address_addr_bitfields
    {
        unsigned char ADDRESS : 8; //!< [7:0] Register address for read and write operations.
    } B;
} hw_hdmi_phy_i2cm_address_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_ADDRESS_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDR      (REGS_HDMI_BASE + 0x3021)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR           (*(volatile hw_hdmi_phy_i2cm_address_addr_t *) HW_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_RD()      (HW_HDMI_PHY_I2CM_ADDRESS_ADDR.U)
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_ADDRESS_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_ADDRESS_ADDR_WR(HW_HDMI_PHY_I2CM_ADDRESS_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_ADDRESS_ADDR_WR(HW_HDMI_PHY_I2CM_ADDRESS_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_ADDRESS_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_ADDRESS_ADDR_WR(HW_HDMI_PHY_I2CM_ADDRESS_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_ADDRESS_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_ADDRESS_ADDR, field ADDRESS[7:0] (RW)
 *
 * Register address for read and write operations.
 */
//@{
#define BP_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS      (0)      //!< Bit position for HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS.
#define BM_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS.

//! @brief Get value of HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS from a register value.
#define BG_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS) >> BP_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS)

//! @brief Format value for bitfield HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS.
#define BF_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS) & BM_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS field to a new value.
#define BW_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS(v)   (HW_HDMI_PHY_I2CM_ADDRESS_ADDR_WR((HW_HDMI_PHY_I2CM_ADDRESS_ADDR_RD() & ~BM_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS) | BF_HDMI_PHY_I2CM_ADDRESS_ADDR_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_DATAO_1_ADDR - PHY I2C Data Write Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_DATAO_1_ADDR - PHY I2C Data Write Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_datao_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_datao_1_addr_bitfields
    {
        unsigned char DATAO : 8; //!< [7:0] MSB's of data to be written on register pointed by address [7:0].
    } B;
} hw_hdmi_phy_i2cm_datao_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_DATAO_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x3022)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_datao_1_addr_t *) HW_HDMI_PHY_I2CM_DATAO_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_DATAO_1_ADDR.U)
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_DATAO_1_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_DATAO_1_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_1_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_DATAO_1_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_1_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_DATAO_1_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_DATAO_1_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_1_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_DATAO_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_DATAO_1_ADDR, field DATAO[7:0] (RW)
 *
 * MSB's of data to be written on register pointed by address [7:0].
 */
//@{
#define BP_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO      (0)      //!< Bit position for HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO.
#define BM_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO.

//! @brief Get value of HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO from a register value.
#define BG_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO) >> BP_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO)

//! @brief Format value for bitfield HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO.
#define BF_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO) & BM_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATAO field to a new value.
#define BW_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO(v)   (HW_HDMI_PHY_I2CM_DATAO_1_ADDR_WR((HW_HDMI_PHY_I2CM_DATAO_1_ADDR_RD() & ~BM_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO) | BF_HDMI_PHY_I2CM_DATAO_1_ADDR_DATAO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_DATAO_0_ADDR - PHY I2C Data Write Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_DATAO_0_ADDR - PHY I2C Data Write Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_datao_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_datao_0_addr_bitfields
    {
        unsigned char DATAO : 8; //!< [7:0] LSB's of data to be written on register pointed by address [7:0].
    } B;
} hw_hdmi_phy_i2cm_datao_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_DATAO_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x3023)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_datao_0_addr_t *) HW_HDMI_PHY_I2CM_DATAO_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_DATAO_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_DATAO_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_DATAO_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_DATAO_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_DATAO_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_DATAO_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAO_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_DATAO_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_DATAO_0_ADDR, field DATAO[7:0] (RW)
 *
 * LSB's of data to be written on register pointed by address [7:0].
 */
//@{
#define BP_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO      (0)      //!< Bit position for HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO.
#define BM_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO.

//! @brief Get value of HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO from a register value.
#define BG_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO) >> BP_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO)

//! @brief Format value for bitfield HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO.
#define BF_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO) & BM_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATAO field to a new value.
#define BW_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO(v)   (HW_HDMI_PHY_I2CM_DATAO_0_ADDR_WR((HW_HDMI_PHY_I2CM_DATAO_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO) | BF_HDMI_PHY_I2CM_DATAO_0_ADDR_DATAO(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_DATAI_1_ADDR - PHY I2C Data Read Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_DATAI_1_ADDR - PHY I2C Data Read Register 1 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_datai_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_datai_1_addr_bitfields
    {
        unsigned char DATAI : 8; //!< [7:0] MSB's of data read from the register pointed by address [7:0].
    } B;
} hw_hdmi_phy_i2cm_datai_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_DATAI_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_DATAI_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x3024)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_DATAI_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_datai_1_addr_t *) HW_HDMI_PHY_I2CM_DATAI_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_DATAI_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_DATAI_1_ADDR.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_DATAI_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_DATAI_1_ADDR, field DATAI[7:0] (RO)
 *
 * MSB's of data read from the register pointed by address [7:0].
 */
//@{
#define BP_HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI      (0)      //!< Bit position for HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI.
#define BM_HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI.

//! @brief Get value of HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI from a register value.
#define BG_HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI) >> BP_HDMI_PHY_I2CM_DATAI_1_ADDR_DATAI)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_DATAI_0_ADDR - PHY I2C Data Read Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_DATAI_0_ADDR - PHY I2C Data Read Register 0 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_datai_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_datai_0_addr_bitfields
    {
        unsigned char DATAI : 8; //!< [7:0] LSB's of data read from the register pointed by address [7:0].
    } B;
} hw_hdmi_phy_i2cm_datai_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_DATAI_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x3025)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_datai_0_addr_t *) HW_HDMI_PHY_I2CM_DATAI_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_DATAI_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_DATAI_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_DATAI_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAI_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_DATAI_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAI_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_DATAI_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_DATAI_0_ADDR_WR(HW_HDMI_PHY_I2CM_DATAI_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_DATAI_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_DATAI_0_ADDR, field DATAI[7:0] (RW)
 *
 * LSB's of data read from the register pointed by address [7:0].
 */
//@{
#define BP_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI      (0)      //!< Bit position for HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI.
#define BM_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI.

//! @brief Get value of HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI from a register value.
#define BG_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI) >> BP_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI)

//! @brief Format value for bitfield HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI.
#define BF_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI) & BM_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATAI field to a new value.
#define BW_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI(v)   (HW_HDMI_PHY_I2CM_DATAI_0_ADDR_WR((HW_HDMI_PHY_I2CM_DATAI_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI) | BF_HDMI_PHY_I2CM_DATAI_0_ADDR_DATAI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_OPERATION_ADDR - PHY I2C Read/Write Operation
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_OPERATION_ADDR - PHY I2C Read/Write Operation (WO)
 *
 * Reset value: 0x00
 *
 * This register requests read and write operations from the I2C Master PHY. This register can only
 * be written; reading this register always results in 00h. Writing 1'b1 simultaneously to read and
 * write requests is considered a read request.
 */
typedef union _hw_hdmi_phy_i2cm_operation_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_operation_addr_bitfields
    {
        unsigned char READ : 1; //!< [0] Read operation request.
        unsigned char RESERVED0 : 3; //!< [3:1] Reserved
        unsigned char WRITE : 1; //!< [4] Write operation request
        unsigned char RESERVED1 : 3; //!< [7:5] Reserved
    } B;
} hw_hdmi_phy_i2cm_operation_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_OPERATION_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_OPERATION_ADDR_ADDR      (REGS_HDMI_BASE + 0x3026)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_OPERATION_ADDR           (*(volatile hw_hdmi_phy_i2cm_operation_addr_t *) HW_HDMI_PHY_I2CM_OPERATION_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_OPERATION_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_OPERATION_ADDR.U = (v))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_OPERATION_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_OPERATION_ADDR, field READ[0] (WO)
 *
 * Read operation request.
 */
//@{
#define BP_HDMI_PHY_I2CM_OPERATION_ADDR_READ      (0)      //!< Bit position for HDMI_PHY_I2CM_OPERATION_ADDR_READ.
#define BM_HDMI_PHY_I2CM_OPERATION_ADDR_READ      (0x00000001)  //!< Bit mask for HDMI_PHY_I2CM_OPERATION_ADDR_READ.

//! @brief Get value of HDMI_PHY_I2CM_OPERATION_ADDR_READ from a register value.
#define BG_HDMI_PHY_I2CM_OPERATION_ADDR_READ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_OPERATION_ADDR_READ) >> BP_HDMI_PHY_I2CM_OPERATION_ADDR_READ)

//! @brief Format value for bitfield HDMI_PHY_I2CM_OPERATION_ADDR_READ.
#define BF_HDMI_PHY_I2CM_OPERATION_ADDR_READ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_OPERATION_ADDR_READ) & BM_HDMI_PHY_I2CM_OPERATION_ADDR_READ)
//@}

/*! @name Register HDMI_PHY_I2CM_OPERATION_ADDR, field WRITE[4] (WO)
 *
 * Write operation request
 */
//@{
#define BP_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE      (4)      //!< Bit position for HDMI_PHY_I2CM_OPERATION_ADDR_WRITE.
#define BM_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE      (0x00000010)  //!< Bit mask for HDMI_PHY_I2CM_OPERATION_ADDR_WRITE.

//! @brief Get value of HDMI_PHY_I2CM_OPERATION_ADDR_WRITE from a register value.
#define BG_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE) >> BP_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE)

//! @brief Format value for bitfield HDMI_PHY_I2CM_OPERATION_ADDR_WRITE.
#define BF_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE) & BM_HDMI_PHY_I2CM_OPERATION_ADDR_WRITE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_INT_ADDR - PHY I2C Done Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_INT_ADDR - PHY I2C Done Interrupt Register (RW)
 *
 * Reset value: 0x08
 *
 * This register contains and configures I2C master PHY done interrupt.
 */
typedef union _hw_hdmi_phy_i2cm_int_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_int_addr_bitfields
    {
        unsigned char DONE_STATUS : 1; //!< [0] Operation done status bit.Marks the end of a rd or write operation.
        unsigned char DONE_INTERRUPT : 1; //!< [1] Operation done interrupt bit.{done_interrupt =(done_mask==0b)&& (done_status==done_pol)}.
        unsigned char DONE_MASK : 1; //!< [2] Done interrupt mask signal
        unsigned char DONE_POL : 1; //!< [3] Done interrupt polarity configuration
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_phy_i2cm_int_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_INT_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_INT_ADDR_ADDR      (REGS_HDMI_BASE + 0x3027)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_INT_ADDR           (*(volatile hw_hdmi_phy_i2cm_int_addr_t *) HW_HDMI_PHY_I2CM_INT_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_INT_ADDR_RD()      (HW_HDMI_PHY_I2CM_INT_ADDR.U)
#define HW_HDMI_PHY_I2CM_INT_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_INT_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_INT_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_INT_ADDR_WR(HW_HDMI_PHY_I2CM_INT_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_INT_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_INT_ADDR_WR(HW_HDMI_PHY_I2CM_INT_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_INT_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_INT_ADDR_WR(HW_HDMI_PHY_I2CM_INT_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_INT_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_INT_ADDR, field DONE_STATUS[0] (RW)
 *
 * Operation done status bit.Marks the end of a rd or write operation. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS      (0)      //!< Bit position for HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS.
#define BM_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS      (0x00000001)  //!< Bit mask for HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS.

//! @brief Get value of HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS from a register value.
#define BG_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS) >> BP_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS)

//! @brief Format value for bitfield HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS.
#define BF_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_STATUS field to a new value.
#define BW_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS(v)   (HW_HDMI_PHY_I2CM_INT_ADDR_WR((HW_HDMI_PHY_I2CM_INT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS) | BF_HDMI_PHY_I2CM_INT_ADDR_DONE_STATUS(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_INT_ADDR, field DONE_INTERRUPT[1] (RW)
 *
 * Operation done interrupt bit.{done_interrupt =(done_mask==0b)&& (done_status==done_pol)}. Value
 * after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT      (1)      //!< Bit position for HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT.
#define BM_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT      (0x00000002)  //!< Bit mask for HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT.

//! @brief Get value of HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT from a register value.
#define BG_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT) >> BP_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT.
#define BF_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_INTERRUPT field to a new value.
#define BW_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT(v)   (HW_HDMI_PHY_I2CM_INT_ADDR_WR((HW_HDMI_PHY_I2CM_INT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT) | BF_HDMI_PHY_I2CM_INT_ADDR_DONE_INTERRUPT(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_INT_ADDR, field DONE_MASK[2] (RW)
 *
 * Done interrupt mask signal Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK      (2)      //!< Bit position for HDMI_PHY_I2CM_INT_ADDR_DONE_MASK.
#define BM_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK      (0x00000004)  //!< Bit mask for HDMI_PHY_I2CM_INT_ADDR_DONE_MASK.

//! @brief Get value of HDMI_PHY_I2CM_INT_ADDR_DONE_MASK from a register value.
#define BG_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK) >> BP_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK)

//! @brief Format value for bitfield HDMI_PHY_I2CM_INT_ADDR_DONE_MASK.
#define BF_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_MASK field to a new value.
#define BW_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK(v)   (HW_HDMI_PHY_I2CM_INT_ADDR_WR((HW_HDMI_PHY_I2CM_INT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK) | BF_HDMI_PHY_I2CM_INT_ADDR_DONE_MASK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_INT_ADDR, field DONE_POL[3] (RW)
 *
 * Done interrupt polarity configuration Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_I2CM_INT_ADDR_DONE_POL      (3)      //!< Bit position for HDMI_PHY_I2CM_INT_ADDR_DONE_POL.
#define BM_HDMI_PHY_I2CM_INT_ADDR_DONE_POL      (0x00000008)  //!< Bit mask for HDMI_PHY_I2CM_INT_ADDR_DONE_POL.

//! @brief Get value of HDMI_PHY_I2CM_INT_ADDR_DONE_POL from a register value.
#define BG_HDMI_PHY_I2CM_INT_ADDR_DONE_POL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_POL) >> BP_HDMI_PHY_I2CM_INT_ADDR_DONE_POL)

//! @brief Format value for bitfield HDMI_PHY_I2CM_INT_ADDR_DONE_POL.
#define BF_HDMI_PHY_I2CM_INT_ADDR_DONE_POL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_INT_ADDR_DONE_POL) & BM_HDMI_PHY_I2CM_INT_ADDR_DONE_POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_POL field to a new value.
#define BW_HDMI_PHY_I2CM_INT_ADDR_DONE_POL(v)   (HW_HDMI_PHY_I2CM_INT_ADDR_WR((HW_HDMI_PHY_I2CM_INT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_INT_ADDR_DONE_POL) | BF_HDMI_PHY_I2CM_INT_ADDR_DONE_POL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_CTLINT_ADDR - PHY I2C Done Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_CTLINT_ADDR - PHY I2C Done Interrupt Register (RW)
 *
 * Reset value: 0x88
 *
 * This register contains and configures the I2C master PHY error interrupts.
 */
typedef union _hw_hdmi_phy_i2cm_ctlint_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_ctlint_addr_bitfields
    {
        unsigned char ARBITRATION_STATUS : 1; //!< [0] Arbitration error status bit.
        unsigned char ARBITRATION_INTERRUPT : 1; //!< [1] Arbitration error interrupt bit.{arbitration_interrupt = (arbitration_mask==0b)&& (arbitration_status==arbitration_pol)}.
        unsigned char ARBITRATION_MASK : 1; //!< [2] Arbitration error interrupt mask signal.
        unsigned char ARBITRATION_POL : 1; //!< [3] Arbitration error interrupt polarity configuration.
        unsigned char NACK_STATUS : 1; //!< [4] Not acknowledge error status bit.Error on I2C not acknowledge.
        unsigned char NACK_INTERRUPT : 1; //!< [5] Not acknowledge error interrupt bit.{nack_interrupt = nack_mask==0b) && (nack_status==nack_pol)}.
        unsigned char NACK_MASK : 1; //!< [6] Not acknowledge error interrupt mask signal
        unsigned char NACK_POL : 1; //!< [7] Not acknowledge error interrupt polarity configuration.
    } B;
} hw_hdmi_phy_i2cm_ctlint_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_CTLINT_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_ADDR      (REGS_HDMI_BASE + 0x3028)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR           (*(volatile hw_hdmi_phy_i2cm_ctlint_addr_t *) HW_HDMI_PHY_I2CM_CTLINT_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD()      (HW_HDMI_PHY_I2CM_CTLINT_ADDR.U)
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_CTLINT_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR(HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR(HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_CTLINT_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR(HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_CTLINT_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field ARBITRATION_STATUS[0] (RW)
 *
 * Arbitration error status bit. Error on master I2C protocol arbitration. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS      (0)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS      (0x00000001)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBITRATION_STATUS field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_STATUS(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field ARBITRATION_INTERRUPT[1] (RW)
 *
 * Arbitration error interrupt bit.{arbitration_interrupt = (arbitration_mask==0b)&&
 * (arbitration_status==arbitration_pol)}. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT      (1)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT      (0x00000002)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBITRATION_INTERRUPT field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_INTERRUPT(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field ARBITRATION_MASK[2] (RW)
 *
 * Arbitration error interrupt mask signal. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK      (2)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK      (0x00000004)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBITRATION_MASK field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field ARBITRATION_POL[3] (RW)
 *
 * Arbitration error interrupt polarity configuration. Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL      (3)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL      (0x00000008)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBITRATION_POL field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field NACK_STATUS[4] (RW)
 *
 * Not acknowledge error status bit.Error on I2C not acknowledge. Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS      (4)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS      (0x00000010)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK_STATUS field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_STATUS(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field NACK_INTERRUPT[5] (RW)
 *
 * Not acknowledge error interrupt bit.{nack_interrupt = nack_mask==0b) && (nack_status==nack_pol)}.
 * Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT      (5)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT      (0x00000020)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK_INTERRUPT field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_INTERRUPT(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field NACK_MASK[6] (RW)
 *
 * Not acknowledge error interrupt mask signal Value after Reset: 0b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK      (6)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK      (0x00000040)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK_MASK field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_MASK(v)))
#endif
//@}

/*! @name Register HDMI_PHY_I2CM_CTLINT_ADDR, field NACK_POL[7] (RW)
 *
 * Not acknowledge error interrupt polarity configuration. Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL      (7)      //!< Bit position for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL.
#define BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL      (0x00000080)  //!< Bit mask for HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL.

//! @brief Get value of HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL from a register value.
#define BG_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL) >> BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL)

//! @brief Format value for bitfield HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL.
#define BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL) & BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NACK_POL field to a new value.
#define BW_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL(v)   (HW_HDMI_PHY_I2CM_CTLINT_ADDR_WR((HW_HDMI_PHY_I2CM_CTLINT_ADDR_RD() & ~BM_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL) | BF_HDMI_PHY_I2CM_CTLINT_ADDR_NACK_POL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_DIV_ADDR - PHY I2C Speed Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_DIV_ADDR - PHY I2C Speed Control Register (RW)
 *
 * Reset value: 0x0b
 *
 * This register wets the I2C Master PHY to work in either Fast or Standard mode.
 */
typedef union _hw_hdmi_phy_i2cm_div_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_div_addr_bitfields
    {
        unsigned char FAST_MODE : 4; //!< [3:0] Sets the I2C Master to work in Fast Mode or Standard Mode
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_phy_i2cm_div_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_DIV_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_DIV_ADDR_ADDR      (REGS_HDMI_BASE + 0x3029)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_DIV_ADDR           (*(volatile hw_hdmi_phy_i2cm_div_addr_t *) HW_HDMI_PHY_I2CM_DIV_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_DIV_ADDR_RD()      (HW_HDMI_PHY_I2CM_DIV_ADDR.U)
#define HW_HDMI_PHY_I2CM_DIV_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_DIV_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_DIV_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_DIV_ADDR_WR(HW_HDMI_PHY_I2CM_DIV_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_DIV_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_DIV_ADDR_WR(HW_HDMI_PHY_I2CM_DIV_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_DIV_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_DIV_ADDR_WR(HW_HDMI_PHY_I2CM_DIV_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_DIV_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_DIV_ADDR, field FAST_MODE[3:0] (RW)
 *
 * Sets the I2C Master to work in Fast Mode or Standard Mode (x implies that it can take any value)
 * Value after Reset: 1011b 1xxxb Fast Mode 0xxxb Standard Mode
 */
//@{
#define BP_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE      (0)      //!< Bit position for HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE.
#define BM_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE      (0x0000000f)  //!< Bit mask for HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE.

//! @brief Get value of HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE from a register value.
#define BG_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE) >> BP_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE)

//! @brief Format value for bitfield HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE.
#define BF_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE) & BM_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAST_MODE field to a new value.
#define BW_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE(v)   (HW_HDMI_PHY_I2CM_DIV_ADDR_WR((HW_HDMI_PHY_I2CM_DIV_ADDR_RD() & ~BM_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE) | BF_HDMI_PHY_I2CM_DIV_ADDR_FAST_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR - PHY I2C Software Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR - PHY I2C Software Reset Register (RW)
 *
 * Reset value: 0x01
 *
 * This register sets the I2C Master PHY software reset. The following *CNT registers must be set
 * before any I2C bus transaction can take place to ensure proper I/O timing. For more information
 * about the SFR_CLK frequency configuration, see ." The following are the I2C Master SCL clock
 * settings: SS: Standard Speed FS: Fast Speed HCNT: SCL High Level counter LCNT: SCL Low Level
 * counter
 */
typedef union _hw_hdmi_phy_i2cm_softrstz_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_softrstz_addr_bitfields
    {
        unsigned char I2C_SOFTRST : 1; //!< [0] I2C Master PHY Software Reset.
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_phy_i2cm_softrstz_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SOFTRSTZ_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_ADDR      (REGS_HDMI_BASE + 0x302a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR           (*(volatile hw_hdmi_phy_i2cm_softrstz_addr_t *) HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_RD()      (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR.U)
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_WR(HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_WR(HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_WR(HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SOFTRSTZ_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_SOFTRSTZ_ADDR, field I2C_SOFTRST[0] (RW)
 *
 * I2C Master PHY Software Reset. Active by writing a zero and auto cleared to one in the following
 * cycle. Value after Reset: 1b
 */
//@{
#define BP_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST      (0)      //!< Bit position for HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST.
#define BM_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST      (0x00000001)  //!< Bit mask for HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST.

//! @brief Get value of HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST from a register value.
#define BG_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST) >> BP_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST)

//! @brief Format value for bitfield HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST.
#define BF_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST) & BM_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2C_SOFTRST field to a new value.
#define BW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST(v)   (HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_WR((HW_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_RD() & ~BM_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST) | BF_HDMI_PHY_I2CM_SOFTRSTZ_ADDR_I2C_SOFTRST(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR - PHY I2C Slow Speed SCL High Level Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR - PHY I2C Slow Speed SCL High Level Control Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr_bitfields
    {
        unsigned char I2CMP_SS_SCL_HCNT : 8; //!< [7:0] Value after Reset: 8'h00
    } B;
} hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x302b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_ss_scl_hcnt_1_addr_t *) HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR.U)
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR, field I2CMP_SS_SCL_HCNT[7:0] (RW)
 *
 * Value after Reset: 8'h00
 */
//@{
#define BP_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT.
#define BM_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT.

//! @brief Get value of HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT from a register value.
#define BG_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT) >> BP_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT.
#define BF_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT) & BM_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_SS_SCL_HCNT field to a new value.
#define BW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT(v)   (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_WR((HW_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_RD() & ~BM_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT) | BF_HDMI_PHY_I2CM_SS_SCL_HCNT_1_ADDR_I2CMP_SS_SCL_HCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR - PHY I2C Slow Speed SCL High Level Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR - PHY I2C Slow Speed SCL High Level Control Register 0 (RW)
 *
 * Reset value: 0x6c
 */
typedef union _hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr_bitfields
    {
        unsigned char I2CMP_SS_SCL_HCNT : 8; //!< [7:0] Value after Reset: 8'h6C
    } B;
} hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x302c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_ss_scl_hcnt_0_addr_t *) HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR, field I2CMP_SS_SCL_HCNT[7:0] (RW)
 *
 * Value after Reset: 8'h6C
 */
//@{
#define BP_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT.
#define BM_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT.

//! @brief Get value of HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT from a register value.
#define BG_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT) >> BP_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT.
#define BF_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT) & BM_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_SS_SCL_HCNT field to a new value.
#define BW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT(v)   (HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_WR((HW_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT) | BF_HDMI_PHY_I2CM_SS_SCL_HCNT_0_ADDR_I2CMP_SS_SCL_HCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr_bitfields
    {
        unsigned char I2CMP_SS_SCL_LCNT : 8; //!< [7:0] Value after Reset: 8'h00
    } B;
} hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x302d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_ss_scl_lcnt_1_addr_t *) HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR.U)
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR, field I2CMP_SS_SCL_LCNT[7:0] (RW)
 *
 * Value after Reset: 8'h00
 */
//@{
#define BP_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT.
#define BM_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT.

//! @brief Get value of HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT from a register value.
#define BG_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT) >> BP_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT.
#define BF_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT) & BM_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_SS_SCL_LCNT field to a new value.
#define BW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT(v)   (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_WR((HW_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_RD() & ~BM_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT) | BF_HDMI_PHY_I2CM_SS_SCL_LCNT_1_ADDR_I2CMP_SS_SCL_LCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR - PHY I2C Slow Speed SCL Low Level Control Register 0 (RW)
 *
 * Reset value: 0x7f
 */
typedef union _hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr_bitfields
    {
        unsigned char I2CMP_SS_SCL_LCNT : 8; //!< [7:0] Value after Reset: 8'h7F
    } B;
} hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x302e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_ss_scl_lcnt_0_addr_t *) HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR, field I2CMP_SS_SCL_LCNT[7:0] (RW)
 *
 * Value after Reset: 8'h7F
 */
//@{
#define BP_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT.
#define BM_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT.

//! @brief Get value of HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT from a register value.
#define BG_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT) >> BP_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT.
#define BF_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT) & BM_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_SS_SCL_LCNT field to a new value.
#define BW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT(v)   (HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_WR((HW_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT) | BF_HDMI_PHY_I2CM_SS_SCL_LCNT_0_ADDR_I2CMP_SS_SCL_LCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR - PHY I2C Fast Speed SCL High Level Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR - PHY I2C Fast Speed SCL High Level Control Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr_bitfields
    {
        unsigned char I2CMP_FS_SCL_HCNT : 8; //!< [7:0] Value after Reset: 8'h00
    } B;
} hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x302f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_fs_scl_hcnt_1_addr_t *) HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR.U)
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR, field I2CMP_FS_SCL_HCNT[7:0] (RW)
 *
 * Value after Reset: 8'h00
 */
//@{
#define BP_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT.
#define BM_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT.

//! @brief Get value of HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT from a register value.
#define BG_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT) >> BP_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT.
#define BF_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT) & BM_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_FS_SCL_HCNT field to a new value.
#define BW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT(v)   (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_WR((HW_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_RD() & ~BM_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT) | BF_HDMI_PHY_I2CM_FS_SCL_HCNT_1_ADDR_I2CMP_FS_SCL_HCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR - PHY I2C Fast Speed SCL High Level Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR - PHY I2C Fast Speed SCL High Level Control Register 0 (RW)
 *
 * Reset value: 0x11
 */
typedef union _hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr_bitfields
    {
        unsigned char I2CMP_FS_SCL_HCNT : 8; //!< [7:0] Value after Reset: 8'h11
    } B;
} hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x3030)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_fs_scl_hcnt_0_addr_t *) HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR, field I2CMP_FS_SCL_HCNT[7:0] (RW)
 *
 * Value after Reset: 8'h11
 */
//@{
#define BP_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT.
#define BM_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT.

//! @brief Get value of HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT from a register value.
#define BG_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT) >> BP_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT.
#define BF_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT) & BM_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_FS_SCL_HCNT field to a new value.
#define BW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT(v)   (HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_WR((HW_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT) | BF_HDMI_PHY_I2CM_FS_SCL_HCNT_0_ADDR_I2CMP_FS_SCL_HCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr_bitfields
    {
        unsigned char I2CMP_FS_SCL_LCNT : 8; //!< [7:0] Value after Reset: 8'h00
    } B;
} hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_ADDR      (REGS_HDMI_BASE + 0x3031)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR           (*(volatile hw_hdmi_phy_i2cm_fs_scl_lcnt_1_addr_t *) HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_RD()      (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR.U)
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR, field I2CMP_FS_SCL_LCNT[7:0] (RW)
 *
 * Value after Reset: 8'h00
 */
//@{
#define BP_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT.
#define BM_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT.

//! @brief Get value of HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT from a register value.
#define BG_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT) >> BP_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT.
#define BF_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT) & BM_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_FS_SCL_LCNT field to a new value.
#define BW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT(v)   (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_WR((HW_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_RD() & ~BM_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT) | BF_HDMI_PHY_I2CM_FS_SCL_LCNT_1_ADDR_I2CMP_FS_SCL_LCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR - PHY I2C Fast Speed SCL Low Level Control Register 0 (RW)
 *
 * Reset value: 0x24
 */
typedef union _hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr
{
    reg8_t U;
    struct _hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr_bitfields
    {
        unsigned char I2CMP_FS_SCL_LCNT : 8; //!< [7:0] Value after Reset: 8'h24
    } B;
} hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR register
 */
//@{
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_ADDR      (REGS_HDMI_BASE + 0x3032)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR           (*(volatile hw_hdmi_phy_i2cm_fs_scl_lcnt_0_addr_t *) HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_ADDR)
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_RD()      (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR.U)
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_WR(v)     (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR.U = (v))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_SET(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_RD() |  (v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_CLR(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_RD() & ~(v)))
#define HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_TOG(v)    (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_WR(HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR bitfields
 */

/*! @name Register HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR, field I2CMP_FS_SCL_LCNT[7:0] (RW)
 *
 * Value after Reset: 8'h24
 */
//@{
#define BP_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT      (0)      //!< Bit position for HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT.
#define BM_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT      (0x000000ff)  //!< Bit mask for HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT.

//! @brief Get value of HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT from a register value.
#define BG_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT) >> BP_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT)

//! @brief Format value for bitfield HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT.
#define BF_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT) & BM_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2CMP_FS_SCL_LCNT field to a new value.
#define BW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT(v)   (HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_WR((HW_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_RD() & ~BM_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT) | BF_HDMI_PHY_I2CM_FS_SCL_LCNT_0_ADDR_I2CMP_FS_SCL_LCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_N1 - Audio Clock Regenerator N Value Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_N1 - Audio Clock Regenerator N Value Register 1 (RW)
 *
 * Reset value: 0x00
 *
 * For N expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_n1
{
    reg8_t U;
    struct _hw_hdmi_aud_n1_bitfields
    {
        unsigned char AUDN : 8; //!< [7:0] HDMI Audio Clock Regenerator N value
    } B;
} hw_hdmi_aud_n1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_N1 register
 */
//@{
#define HW_HDMI_AUD_N1_ADDR      (REGS_HDMI_BASE + 0x3200)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_N1           (*(volatile hw_hdmi_aud_n1_t *) HW_HDMI_AUD_N1_ADDR)
#define HW_HDMI_AUD_N1_RD()      (HW_HDMI_AUD_N1.U)
#define HW_HDMI_AUD_N1_WR(v)     (HW_HDMI_AUD_N1.U = (v))
#define HW_HDMI_AUD_N1_SET(v)    (HW_HDMI_AUD_N1_WR(HW_HDMI_AUD_N1_RD() |  (v)))
#define HW_HDMI_AUD_N1_CLR(v)    (HW_HDMI_AUD_N1_WR(HW_HDMI_AUD_N1_RD() & ~(v)))
#define HW_HDMI_AUD_N1_TOG(v)    (HW_HDMI_AUD_N1_WR(HW_HDMI_AUD_N1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_N1 bitfields
 */

/*! @name Register HDMI_AUD_N1, field AUDN[7:0] (RW)
 *
 * HDMI Audio Clock Regenerator N value
 */
//@{
#define BP_HDMI_AUD_N1_AUDN      (0)      //!< Bit position for HDMI_AUD_N1_AUDN.
#define BM_HDMI_AUD_N1_AUDN      (0x000000ff)  //!< Bit mask for HDMI_AUD_N1_AUDN.

//! @brief Get value of HDMI_AUD_N1_AUDN from a register value.
#define BG_HDMI_AUD_N1_AUDN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_N1_AUDN) >> BP_HDMI_AUD_N1_AUDN)

//! @brief Format value for bitfield HDMI_AUD_N1_AUDN.
#define BF_HDMI_AUD_N1_AUDN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_N1_AUDN) & BM_HDMI_AUD_N1_AUDN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDN field to a new value.
#define BW_HDMI_AUD_N1_AUDN(v)   (HW_HDMI_AUD_N1_WR((HW_HDMI_AUD_N1_RD() & ~BM_HDMI_AUD_N1_AUDN) | BF_HDMI_AUD_N1_AUDN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_N2 - Audio Clock Regenerator N Value Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_N2 - Audio Clock Regenerator N Value Register 2 (RW)
 *
 * Reset value: 0x00
 *
 * For N expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_n2
{
    reg8_t U;
    struct _hw_hdmi_aud_n2_bitfields
    {
        unsigned char AUDN : 8; //!< [7:0] HDMI Audio Clock Regenerator N value
    } B;
} hw_hdmi_aud_n2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_N2 register
 */
//@{
#define HW_HDMI_AUD_N2_ADDR      (REGS_HDMI_BASE + 0x3201)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_N2           (*(volatile hw_hdmi_aud_n2_t *) HW_HDMI_AUD_N2_ADDR)
#define HW_HDMI_AUD_N2_RD()      (HW_HDMI_AUD_N2.U)
#define HW_HDMI_AUD_N2_WR(v)     (HW_HDMI_AUD_N2.U = (v))
#define HW_HDMI_AUD_N2_SET(v)    (HW_HDMI_AUD_N2_WR(HW_HDMI_AUD_N2_RD() |  (v)))
#define HW_HDMI_AUD_N2_CLR(v)    (HW_HDMI_AUD_N2_WR(HW_HDMI_AUD_N2_RD() & ~(v)))
#define HW_HDMI_AUD_N2_TOG(v)    (HW_HDMI_AUD_N2_WR(HW_HDMI_AUD_N2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_N2 bitfields
 */

/*! @name Register HDMI_AUD_N2, field AUDN[7:0] (RW)
 *
 * HDMI Audio Clock Regenerator N value
 */
//@{
#define BP_HDMI_AUD_N2_AUDN      (0)      //!< Bit position for HDMI_AUD_N2_AUDN.
#define BM_HDMI_AUD_N2_AUDN      (0x000000ff)  //!< Bit mask for HDMI_AUD_N2_AUDN.

//! @brief Get value of HDMI_AUD_N2_AUDN from a register value.
#define BG_HDMI_AUD_N2_AUDN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_N2_AUDN) >> BP_HDMI_AUD_N2_AUDN)

//! @brief Format value for bitfield HDMI_AUD_N2_AUDN.
#define BF_HDMI_AUD_N2_AUDN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_N2_AUDN) & BM_HDMI_AUD_N2_AUDN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDN field to a new value.
#define BW_HDMI_AUD_N2_AUDN(v)   (HW_HDMI_AUD_N2_WR((HW_HDMI_AUD_N2_RD() & ~BM_HDMI_AUD_N2_AUDN) | BF_HDMI_AUD_N2_AUDN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_N3 - Audio Clock Regenerator N Value Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_N3 - Audio Clock Regenerator N Value Register 3 (RW)
 *
 * Reset value: 0x00
 *
 * For N expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_n3
{
    reg8_t U;
    struct _hw_hdmi_aud_n3_bitfields
    {
        unsigned char AUDN : 4; //!< [3:0] HDMI Audio Clock Regenerator N value
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_aud_n3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_N3 register
 */
//@{
#define HW_HDMI_AUD_N3_ADDR      (REGS_HDMI_BASE + 0x3202)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_N3           (*(volatile hw_hdmi_aud_n3_t *) HW_HDMI_AUD_N3_ADDR)
#define HW_HDMI_AUD_N3_RD()      (HW_HDMI_AUD_N3.U)
#define HW_HDMI_AUD_N3_WR(v)     (HW_HDMI_AUD_N3.U = (v))
#define HW_HDMI_AUD_N3_SET(v)    (HW_HDMI_AUD_N3_WR(HW_HDMI_AUD_N3_RD() |  (v)))
#define HW_HDMI_AUD_N3_CLR(v)    (HW_HDMI_AUD_N3_WR(HW_HDMI_AUD_N3_RD() & ~(v)))
#define HW_HDMI_AUD_N3_TOG(v)    (HW_HDMI_AUD_N3_WR(HW_HDMI_AUD_N3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_N3 bitfields
 */

/*! @name Register HDMI_AUD_N3, field AUDN[3:0] (RW)
 *
 * HDMI Audio Clock Regenerator N value
 */
//@{
#define BP_HDMI_AUD_N3_AUDN      (0)      //!< Bit position for HDMI_AUD_N3_AUDN.
#define BM_HDMI_AUD_N3_AUDN      (0x0000000f)  //!< Bit mask for HDMI_AUD_N3_AUDN.

//! @brief Get value of HDMI_AUD_N3_AUDN from a register value.
#define BG_HDMI_AUD_N3_AUDN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_N3_AUDN) >> BP_HDMI_AUD_N3_AUDN)

//! @brief Format value for bitfield HDMI_AUD_N3_AUDN.
#define BF_HDMI_AUD_N3_AUDN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_N3_AUDN) & BM_HDMI_AUD_N3_AUDN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDN field to a new value.
#define BW_HDMI_AUD_N3_AUDN(v)   (HW_HDMI_AUD_N3_WR((HW_HDMI_AUD_N3_RD() & ~BM_HDMI_AUD_N3_AUDN) | BF_HDMI_AUD_N3_AUDN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_CTS1 - AUD_CTS1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_CTS1 - AUD_CTS1 (RW)
 *
 * Reset value: 0x00
 *
 * For CTS expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_cts1
{
    reg8_t U;
    struct _hw_hdmi_aud_cts1_bitfields
    {
        unsigned char AUDCTS : 8; //!< [7:0] HDMI Audio Clock Regenerator CTS calculated value.
    } B;
} hw_hdmi_aud_cts1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_CTS1 register
 */
//@{
#define HW_HDMI_AUD_CTS1_ADDR      (REGS_HDMI_BASE + 0x3203)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_CTS1           (*(volatile hw_hdmi_aud_cts1_t *) HW_HDMI_AUD_CTS1_ADDR)
#define HW_HDMI_AUD_CTS1_RD()      (HW_HDMI_AUD_CTS1.U)
#define HW_HDMI_AUD_CTS1_WR(v)     (HW_HDMI_AUD_CTS1.U = (v))
#define HW_HDMI_AUD_CTS1_SET(v)    (HW_HDMI_AUD_CTS1_WR(HW_HDMI_AUD_CTS1_RD() |  (v)))
#define HW_HDMI_AUD_CTS1_CLR(v)    (HW_HDMI_AUD_CTS1_WR(HW_HDMI_AUD_CTS1_RD() & ~(v)))
#define HW_HDMI_AUD_CTS1_TOG(v)    (HW_HDMI_AUD_CTS1_WR(HW_HDMI_AUD_CTS1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_CTS1 bitfields
 */

/*! @name Register HDMI_AUD_CTS1, field AUDCTS[7:0] (RW)
 *
 * HDMI Audio Clock Regenerator CTS calculated value. This value can be manually set using the
 * CTS_manual (AUD_CTS3) mechanism.
 */
//@{
#define BP_HDMI_AUD_CTS1_AUDCTS      (0)      //!< Bit position for HDMI_AUD_CTS1_AUDCTS.
#define BM_HDMI_AUD_CTS1_AUDCTS      (0x000000ff)  //!< Bit mask for HDMI_AUD_CTS1_AUDCTS.

//! @brief Get value of HDMI_AUD_CTS1_AUDCTS from a register value.
#define BG_HDMI_AUD_CTS1_AUDCTS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_CTS1_AUDCTS) >> BP_HDMI_AUD_CTS1_AUDCTS)

//! @brief Format value for bitfield HDMI_AUD_CTS1_AUDCTS.
#define BF_HDMI_AUD_CTS1_AUDCTS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_CTS1_AUDCTS) & BM_HDMI_AUD_CTS1_AUDCTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDCTS field to a new value.
#define BW_HDMI_AUD_CTS1_AUDCTS(v)   (HW_HDMI_AUD_CTS1_WR((HW_HDMI_AUD_CTS1_RD() & ~BM_HDMI_AUD_CTS1_AUDCTS) | BF_HDMI_AUD_CTS1_AUDCTS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_CTS2 - AUD_CTS2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_CTS2 - AUD_CTS2 (RW)
 *
 * Reset value: 0x00
 *
 * For CTS expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_cts2
{
    reg8_t U;
    struct _hw_hdmi_aud_cts2_bitfields
    {
        unsigned char AUDCTS : 8; //!< [7:0] HDMI Audio Clock Regenerator CTS calculated value.
    } B;
} hw_hdmi_aud_cts2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_CTS2 register
 */
//@{
#define HW_HDMI_AUD_CTS2_ADDR      (REGS_HDMI_BASE + 0x3204)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_CTS2           (*(volatile hw_hdmi_aud_cts2_t *) HW_HDMI_AUD_CTS2_ADDR)
#define HW_HDMI_AUD_CTS2_RD()      (HW_HDMI_AUD_CTS2.U)
#define HW_HDMI_AUD_CTS2_WR(v)     (HW_HDMI_AUD_CTS2.U = (v))
#define HW_HDMI_AUD_CTS2_SET(v)    (HW_HDMI_AUD_CTS2_WR(HW_HDMI_AUD_CTS2_RD() |  (v)))
#define HW_HDMI_AUD_CTS2_CLR(v)    (HW_HDMI_AUD_CTS2_WR(HW_HDMI_AUD_CTS2_RD() & ~(v)))
#define HW_HDMI_AUD_CTS2_TOG(v)    (HW_HDMI_AUD_CTS2_WR(HW_HDMI_AUD_CTS2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_CTS2 bitfields
 */

/*! @name Register HDMI_AUD_CTS2, field AUDCTS[7:0] (RW)
 *
 * HDMI Audio Clock Regenerator CTS calculated value. This value can be manually set using the
 * CTS_manual (AUD_CTS3) mechanism.
 */
//@{
#define BP_HDMI_AUD_CTS2_AUDCTS      (0)      //!< Bit position for HDMI_AUD_CTS2_AUDCTS.
#define BM_HDMI_AUD_CTS2_AUDCTS      (0x000000ff)  //!< Bit mask for HDMI_AUD_CTS2_AUDCTS.

//! @brief Get value of HDMI_AUD_CTS2_AUDCTS from a register value.
#define BG_HDMI_AUD_CTS2_AUDCTS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_CTS2_AUDCTS) >> BP_HDMI_AUD_CTS2_AUDCTS)

//! @brief Format value for bitfield HDMI_AUD_CTS2_AUDCTS.
#define BF_HDMI_AUD_CTS2_AUDCTS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_CTS2_AUDCTS) & BM_HDMI_AUD_CTS2_AUDCTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDCTS field to a new value.
#define BW_HDMI_AUD_CTS2_AUDCTS(v)   (HW_HDMI_AUD_CTS2_WR((HW_HDMI_AUD_CTS2_RD() & ~BM_HDMI_AUD_CTS2_AUDCTS) | BF_HDMI_AUD_CTS2_AUDCTS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AUD_CTS3 - AUD_CTS3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AUD_CTS3 - AUD_CTS3 (RW)
 *
 * Reset value: 0x00
 *
 * For CTS expected values, refer to the HDMI 1.4a specification.
 */
typedef union _hw_hdmi_aud_cts3
{
    reg8_t U;
    struct _hw_hdmi_aud_cts3_bitfields
    {
        unsigned char AUDCTS : 4; //!< [3:0] HDMI Audio Clock Regenerator CTS calculated value.
        unsigned char RESERVED0 : 4; //!< [7:4] Reserved
    } B;
} hw_hdmi_aud_cts3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AUD_CTS3 register
 */
//@{
#define HW_HDMI_AUD_CTS3_ADDR      (REGS_HDMI_BASE + 0x3205)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AUD_CTS3           (*(volatile hw_hdmi_aud_cts3_t *) HW_HDMI_AUD_CTS3_ADDR)
#define HW_HDMI_AUD_CTS3_RD()      (HW_HDMI_AUD_CTS3.U)
#define HW_HDMI_AUD_CTS3_WR(v)     (HW_HDMI_AUD_CTS3.U = (v))
#define HW_HDMI_AUD_CTS3_SET(v)    (HW_HDMI_AUD_CTS3_WR(HW_HDMI_AUD_CTS3_RD() |  (v)))
#define HW_HDMI_AUD_CTS3_CLR(v)    (HW_HDMI_AUD_CTS3_WR(HW_HDMI_AUD_CTS3_RD() & ~(v)))
#define HW_HDMI_AUD_CTS3_TOG(v)    (HW_HDMI_AUD_CTS3_WR(HW_HDMI_AUD_CTS3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AUD_CTS3 bitfields
 */

/*! @name Register HDMI_AUD_CTS3, field AUDCTS[3:0] (RW)
 *
 * HDMI Audio Clock Regenerator CTS calculated value. This value can be manually set using the
 * CTS_manual (AUD_CTS3) mechanism.
 */
//@{
#define BP_HDMI_AUD_CTS3_AUDCTS      (0)      //!< Bit position for HDMI_AUD_CTS3_AUDCTS.
#define BM_HDMI_AUD_CTS3_AUDCTS      (0x0000000f)  //!< Bit mask for HDMI_AUD_CTS3_AUDCTS.

//! @brief Get value of HDMI_AUD_CTS3_AUDCTS from a register value.
#define BG_HDMI_AUD_CTS3_AUDCTS(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AUD_CTS3_AUDCTS) >> BP_HDMI_AUD_CTS3_AUDCTS)

//! @brief Format value for bitfield HDMI_AUD_CTS3_AUDCTS.
#define BF_HDMI_AUD_CTS3_AUDCTS(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AUD_CTS3_AUDCTS) & BM_HDMI_AUD_CTS3_AUDCTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDCTS field to a new value.
#define BW_HDMI_AUD_CTS3_AUDCTS(v)   (HW_HDMI_AUD_CTS3_WR((HW_HDMI_AUD_CTS3_RD() & ~BM_HDMI_AUD_CTS3_AUDCTS) | BF_HDMI_AUD_CTS3_AUDCTS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_CONF0 - Audio DMA Start Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_CONF0 - Audio DMA Start Register (RW)
 *
 * Reset value: 0x00
 *
 * This register contains the software reset bit for the audio FIFOs. It also configures operating
 * modes of the AHB master.
 */
typedef union _hw_hdmi_ahb_dma_conf0
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_conf0_bitfields
    {
        unsigned char BURST_MODE : 1; //!< [0] 
        unsigned char INCR_TYPE : 2; //!< [2:1] Forced size burst mode.
        unsigned char ENABLE_HLOCK : 1; //!< [3] Enable request of locked burst AHB mechanism.
        unsigned char HBR : 1; //!< [4] HBR packets enable.
        unsigned char RESERVED0 : 2; //!< [6:5] Reserved
        unsigned char SW_FIFO_RST : 1; //!< [7] This is the software reset bit for the audio and FIFOs clear.
    } B;
} hw_hdmi_ahb_dma_conf0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_CONF0 register
 */
//@{
#define HW_HDMI_AHB_DMA_CONF0_ADDR      (REGS_HDMI_BASE + 0x3600)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_CONF0           (*(volatile hw_hdmi_ahb_dma_conf0_t *) HW_HDMI_AHB_DMA_CONF0_ADDR)
#define HW_HDMI_AHB_DMA_CONF0_RD()      (HW_HDMI_AHB_DMA_CONF0.U)
#define HW_HDMI_AHB_DMA_CONF0_WR(v)     (HW_HDMI_AHB_DMA_CONF0.U = (v))
#define HW_HDMI_AHB_DMA_CONF0_SET(v)    (HW_HDMI_AHB_DMA_CONF0_WR(HW_HDMI_AHB_DMA_CONF0_RD() |  (v)))
#define HW_HDMI_AHB_DMA_CONF0_CLR(v)    (HW_HDMI_AHB_DMA_CONF0_WR(HW_HDMI_AHB_DMA_CONF0_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_CONF0_TOG(v)    (HW_HDMI_AHB_DMA_CONF0_WR(HW_HDMI_AHB_DMA_CONF0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_CONF0 bitfields
 */

/*! @name Register HDMI_AHB_DMA_CONF0, field BURST_MODE[0] (RW)
 *
 * Values:
 * - 0 - Normal operation is unspecified length incremental burst. It corresponds to INCR AHB burst mode.
 * - 1 - Forces the burst mode to be fixed beat incremental burst mode designated by the incr_type[1:0]
 *     signal.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF0_BURST_MODE      (0)      //!< Bit position for HDMI_AHB_DMA_CONF0_BURST_MODE.
#define BM_HDMI_AHB_DMA_CONF0_BURST_MODE      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_CONF0_BURST_MODE.

//! @brief Get value of HDMI_AHB_DMA_CONF0_BURST_MODE from a register value.
#define BG_HDMI_AHB_DMA_CONF0_BURST_MODE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF0_BURST_MODE) >> BP_HDMI_AHB_DMA_CONF0_BURST_MODE)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF0_BURST_MODE.
#define BF_HDMI_AHB_DMA_CONF0_BURST_MODE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF0_BURST_MODE) & BM_HDMI_AHB_DMA_CONF0_BURST_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BURST_MODE field to a new value.
#define BW_HDMI_AHB_DMA_CONF0_BURST_MODE(v)   (HW_HDMI_AHB_DMA_CONF0_WR((HW_HDMI_AHB_DMA_CONF0_RD() & ~BM_HDMI_AHB_DMA_CONF0_BURST_MODE) | BF_HDMI_AHB_DMA_CONF0_BURST_MODE(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF0, field INCR_TYPE[2:1] (RW)
 *
 * Forced size burst mode.
 *
 * Values:
 * - 00 - Corresponds to INCR4 fixed four beat incremental AHB burst mode. Only valid when burst_mode is high.
 * - 01 - Corresponds to INCR8 fixed eight beat incremental AHB burst mode. Only valid when burst_mode is
 *     high.
 * - 10 - Corresponds to INCR16 fixed 16 beat incremental AHB burst mode. Only valid when burst_mode is high.
 * - 11 - Corresponds to INCR16 fixed 16 beat incremental AHB burst mode. Only valid when burst_mode is high.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF0_INCR_TYPE      (1)      //!< Bit position for HDMI_AHB_DMA_CONF0_INCR_TYPE.
#define BM_HDMI_AHB_DMA_CONF0_INCR_TYPE      (0x00000006)  //!< Bit mask for HDMI_AHB_DMA_CONF0_INCR_TYPE.

//! @brief Get value of HDMI_AHB_DMA_CONF0_INCR_TYPE from a register value.
#define BG_HDMI_AHB_DMA_CONF0_INCR_TYPE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF0_INCR_TYPE) >> BP_HDMI_AHB_DMA_CONF0_INCR_TYPE)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF0_INCR_TYPE.
#define BF_HDMI_AHB_DMA_CONF0_INCR_TYPE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF0_INCR_TYPE) & BM_HDMI_AHB_DMA_CONF0_INCR_TYPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INCR_TYPE field to a new value.
#define BW_HDMI_AHB_DMA_CONF0_INCR_TYPE(v)   (HW_HDMI_AHB_DMA_CONF0_WR((HW_HDMI_AHB_DMA_CONF0_RD() & ~BM_HDMI_AHB_DMA_CONF0_INCR_TYPE) | BF_HDMI_AHB_DMA_CONF0_INCR_TYPE(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF0, field ENABLE_HLOCK[3] (RW)
 *
 * Enable request of locked burst AHB mechanism.
 *
 * Values:
 * - 0 - Disables request of locked burst AHB mechanism
 * - 1 - Enables the usage of ohlock for master request to arbiter of a locked complete burst.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK      (3)      //!< Bit position for HDMI_AHB_DMA_CONF0_ENABLE_HLOCK.
#define BM_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK      (0x00000008)  //!< Bit mask for HDMI_AHB_DMA_CONF0_ENABLE_HLOCK.

//! @brief Get value of HDMI_AHB_DMA_CONF0_ENABLE_HLOCK from a register value.
#define BG_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK) >> BP_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF0_ENABLE_HLOCK.
#define BF_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK) & BM_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENABLE_HLOCK field to a new value.
#define BW_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK(v)   (HW_HDMI_AHB_DMA_CONF0_WR((HW_HDMI_AHB_DMA_CONF0_RD() & ~BM_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK) | BF_HDMI_AHB_DMA_CONF0_ENABLE_HLOCK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF0, field HBR[4] (RW)
 *
 * HBR packets enable. The HDMI TX sends the HBR packets. This bit is enabled when the audio
 * frequency is higher than 192 KHz. If this bit is enabled, the number of channels configured in
 * AHB_DMA_CONF1 is always 8.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF0_HBR      (4)      //!< Bit position for HDMI_AHB_DMA_CONF0_HBR.
#define BM_HDMI_AHB_DMA_CONF0_HBR      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_CONF0_HBR.

//! @brief Get value of HDMI_AHB_DMA_CONF0_HBR from a register value.
#define BG_HDMI_AHB_DMA_CONF0_HBR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF0_HBR) >> BP_HDMI_AHB_DMA_CONF0_HBR)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF0_HBR.
#define BF_HDMI_AHB_DMA_CONF0_HBR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF0_HBR) & BM_HDMI_AHB_DMA_CONF0_HBR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HBR field to a new value.
#define BW_HDMI_AHB_DMA_CONF0_HBR(v)   (HW_HDMI_AHB_DMA_CONF0_WR((HW_HDMI_AHB_DMA_CONF0_RD() & ~BM_HDMI_AHB_DMA_CONF0_HBR) | BF_HDMI_AHB_DMA_CONF0_HBR(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF0, field SW_FIFO_RST[7] (RW)
 *
 * This is the software reset bit for the audio and FIFOs clear. Writing 0'b does not result in any
 * action. Writing 1'b to this register resets all audio FIFOs. Reading from this register always
 * returns 0'b.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF0_SW_FIFO_RST      (7)      //!< Bit position for HDMI_AHB_DMA_CONF0_SW_FIFO_RST.
#define BM_HDMI_AHB_DMA_CONF0_SW_FIFO_RST      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_CONF0_SW_FIFO_RST.

//! @brief Get value of HDMI_AHB_DMA_CONF0_SW_FIFO_RST from a register value.
#define BG_HDMI_AHB_DMA_CONF0_SW_FIFO_RST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF0_SW_FIFO_RST) >> BP_HDMI_AHB_DMA_CONF0_SW_FIFO_RST)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF0_SW_FIFO_RST.
#define BF_HDMI_AHB_DMA_CONF0_SW_FIFO_RST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF0_SW_FIFO_RST) & BM_HDMI_AHB_DMA_CONF0_SW_FIFO_RST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SW_FIFO_RST field to a new value.
#define BW_HDMI_AHB_DMA_CONF0_SW_FIFO_RST(v)   (HW_HDMI_AHB_DMA_CONF0_WR((HW_HDMI_AHB_DMA_CONF0_RD() & ~BM_HDMI_AHB_DMA_CONF0_SW_FIFO_RST) | BF_HDMI_AHB_DMA_CONF0_SW_FIFO_RST(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_START - AHB_DMA_START
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_START - AHB_DMA_START (RW)
 *
 * Reset value: 0x00
 *
 * The data_ buffer_ready bit field signals the AHB audio DMA to start accessing system memory in
 * order to fetch data samples to store in the FIFO. After the operation starts, a new request for a
 * DMA start is ignored until the DMA is stopped or it reaches the end address. Only in one of these
 * situations will a new start request be acknowledged. The first DMA burst request after
 * data_buffer_ready configuration uses the initial_addr[31:0] as the ohaddr[31:0] and the
 * mburstlength[10:0] = AUDIO_FIFO_DEPTH if AUDIO_FIFO_DEPTH < 1024 or mburstlength[10:0] = 1024 if
 * AUDIO_FIFO_DEPTH >= 1024.
 */
typedef union _hw_hdmi_ahb_dma_start
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_start_bitfields
    {
        unsigned char DATA_BUFFER_READY : 1; //!< [0] Data buffer ready
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_ahb_dma_start_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_START register
 */
//@{
#define HW_HDMI_AHB_DMA_START_ADDR      (REGS_HDMI_BASE + 0x3601)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_START           (*(volatile hw_hdmi_ahb_dma_start_t *) HW_HDMI_AHB_DMA_START_ADDR)
#define HW_HDMI_AHB_DMA_START_RD()      (HW_HDMI_AHB_DMA_START.U)
#define HW_HDMI_AHB_DMA_START_WR(v)     (HW_HDMI_AHB_DMA_START.U = (v))
#define HW_HDMI_AHB_DMA_START_SET(v)    (HW_HDMI_AHB_DMA_START_WR(HW_HDMI_AHB_DMA_START_RD() |  (v)))
#define HW_HDMI_AHB_DMA_START_CLR(v)    (HW_HDMI_AHB_DMA_START_WR(HW_HDMI_AHB_DMA_START_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_START_TOG(v)    (HW_HDMI_AHB_DMA_START_WR(HW_HDMI_AHB_DMA_START_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_START bitfields
 */

/*! @name Register HDMI_AHB_DMA_START, field DATA_BUFFER_READY[0] (RW)
 *
 * Data buffer ready
 */
//@{
#define BP_HDMI_AHB_DMA_START_DATA_BUFFER_READY      (0)      //!< Bit position for HDMI_AHB_DMA_START_DATA_BUFFER_READY.
#define BM_HDMI_AHB_DMA_START_DATA_BUFFER_READY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_START_DATA_BUFFER_READY.

//! @brief Get value of HDMI_AHB_DMA_START_DATA_BUFFER_READY from a register value.
#define BG_HDMI_AHB_DMA_START_DATA_BUFFER_READY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_START_DATA_BUFFER_READY) >> BP_HDMI_AHB_DMA_START_DATA_BUFFER_READY)

//! @brief Format value for bitfield HDMI_AHB_DMA_START_DATA_BUFFER_READY.
#define BF_HDMI_AHB_DMA_START_DATA_BUFFER_READY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_START_DATA_BUFFER_READY) & BM_HDMI_AHB_DMA_START_DATA_BUFFER_READY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_BUFFER_READY field to a new value.
#define BW_HDMI_AHB_DMA_START_DATA_BUFFER_READY(v)   (HW_HDMI_AHB_DMA_START_WR((HW_HDMI_AHB_DMA_START_RD() & ~BM_HDMI_AHB_DMA_START_DATA_BUFFER_READY) | BF_HDMI_AHB_DMA_START_DATA_BUFFER_READY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STOP - Audio DMA Stop Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STOP - Audio DMA Stop Register (RW)
 *
 * Reset value: 0x00
 *
 * The stop_dma_transaction bit field signals the AHB audio DMA to stop current memory access. After
 * it stops, if a new start DMA operation is requested, the DMA engine restarts the memory access
 * assuming the initial_addr[31:0] is programmed at AHB_DMA_STRADDR0 to AHB_DMA_STRADDR3.
 */
typedef union _hw_hdmi_ahb_dma_stop
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stop_bitfields
    {
        unsigned char STOP_DMA_TRANSACTION : 1; //!< [0] Stop DMA transaction
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_ahb_dma_stop_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STOP register
 */
//@{
#define HW_HDMI_AHB_DMA_STOP_ADDR      (REGS_HDMI_BASE + 0x3602)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STOP           (*(volatile hw_hdmi_ahb_dma_stop_t *) HW_HDMI_AHB_DMA_STOP_ADDR)
#define HW_HDMI_AHB_DMA_STOP_RD()      (HW_HDMI_AHB_DMA_STOP.U)
#define HW_HDMI_AHB_DMA_STOP_WR(v)     (HW_HDMI_AHB_DMA_STOP.U = (v))
#define HW_HDMI_AHB_DMA_STOP_SET(v)    (HW_HDMI_AHB_DMA_STOP_WR(HW_HDMI_AHB_DMA_STOP_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STOP_CLR(v)    (HW_HDMI_AHB_DMA_STOP_WR(HW_HDMI_AHB_DMA_STOP_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STOP_TOG(v)    (HW_HDMI_AHB_DMA_STOP_WR(HW_HDMI_AHB_DMA_STOP_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STOP bitfields
 */

/*! @name Register HDMI_AHB_DMA_STOP, field STOP_DMA_TRANSACTION[0] (RW)
 *
 * Stop DMA transaction
 */
//@{
#define BP_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION      (0)      //!< Bit position for HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION.
#define BM_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION.

//! @brief Get value of HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION from a register value.
#define BG_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION) >> BP_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION)

//! @brief Format value for bitfield HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION.
#define BF_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION) & BM_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOP_DMA_TRANSACTION field to a new value.
#define BW_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION(v)   (HW_HDMI_AHB_DMA_STOP_WR((HW_HDMI_AHB_DMA_STOP_RD() & ~BM_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION) | BF_HDMI_AHB_DMA_STOP_STOP_DMA_TRANSACTION(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_THRSLD - Audio DMA FIFO Threshold Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_THRSLD - Audio DMA FIFO Threshold Register (RW)
 *
 * Reset value: 0x00
 *
 * This register defines the FIFO medium threshold occupation value. After the AHB master
 * successfully completes a burst transaction, the FIFO may stay remain full until the data fetch
 * interface requests samples. The sample request from the FIFO using the data fetch mechanism drops
 * the number of samples stored in the audio FIFO. As soon as the number of samples in the FIFO
 * drops lower than the fifo_threshold[7:0], the DMA engine requests a new burst of samples to the
 * AHB master with a size (mburstlength[10:0]) equal to AUDIO_FIFO_DEPTH minus fifo_threshold[7:0].
 * Therefore, the fifo_threshold[7:0] is the medium number of samples that should be available in
 * the audio FIFO across the DMA operation.
 */
typedef union _hw_hdmi_ahb_dma_thrsld
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_thrsld_bitfields
    {
        unsigned char FIFO_THRESHOLD : 8; //!< [7:0] FIFO medium threshold occupation value
    } B;
} hw_hdmi_ahb_dma_thrsld_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_THRSLD register
 */
//@{
#define HW_HDMI_AHB_DMA_THRSLD_ADDR      (REGS_HDMI_BASE + 0x3603)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_THRSLD           (*(volatile hw_hdmi_ahb_dma_thrsld_t *) HW_HDMI_AHB_DMA_THRSLD_ADDR)
#define HW_HDMI_AHB_DMA_THRSLD_RD()      (HW_HDMI_AHB_DMA_THRSLD.U)
#define HW_HDMI_AHB_DMA_THRSLD_WR(v)     (HW_HDMI_AHB_DMA_THRSLD.U = (v))
#define HW_HDMI_AHB_DMA_THRSLD_SET(v)    (HW_HDMI_AHB_DMA_THRSLD_WR(HW_HDMI_AHB_DMA_THRSLD_RD() |  (v)))
#define HW_HDMI_AHB_DMA_THRSLD_CLR(v)    (HW_HDMI_AHB_DMA_THRSLD_WR(HW_HDMI_AHB_DMA_THRSLD_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_THRSLD_TOG(v)    (HW_HDMI_AHB_DMA_THRSLD_WR(HW_HDMI_AHB_DMA_THRSLD_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_THRSLD bitfields
 */

/*! @name Register HDMI_AHB_DMA_THRSLD, field FIFO_THRESHOLD[7:0] (RW)
 *
 * FIFO medium threshold occupation value
 */
//@{
#define BP_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD      (0)      //!< Bit position for HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD.
#define BM_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD.

//! @brief Get value of HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD from a register value.
#define BG_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD) >> BP_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD)

//! @brief Format value for bitfield HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD.
#define BF_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD) & BM_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_THRESHOLD field to a new value.
#define BW_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD(v)   (HW_HDMI_AHB_DMA_THRSLD_WR((HW_HDMI_AHB_DMA_THRSLD_RD() & ~BM_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD) | BF_HDMI_AHB_DMA_THRSLD_FIFO_THRESHOLD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STRADDR0 - Audio DMA Start Address Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STRADDR0 - Audio DMA Start Address Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * These registers define the initial_addr[31:0] used to initiate the DMA burst read transactions
 * upon data_buffer_ready configuration. Address Offset: 0x3604 to 0x3607 Size: 8 bits per register
 * Value after Reset: 0x00 Access: Read/Write
 */
typedef union _hw_hdmi_ahb_dma_straddr0
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_straddr0_bitfields
    {
        unsigned char INITIAL_ADDR : 8; //!< [7:0] Defines init_addr[7:0] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_straddr0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STRADDR0 register
 */
//@{
#define HW_HDMI_AHB_DMA_STRADDR0_ADDR      (REGS_HDMI_BASE + 0x3604)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STRADDR0           (*(volatile hw_hdmi_ahb_dma_straddr0_t *) HW_HDMI_AHB_DMA_STRADDR0_ADDR)
#define HW_HDMI_AHB_DMA_STRADDR0_RD()      (HW_HDMI_AHB_DMA_STRADDR0.U)
#define HW_HDMI_AHB_DMA_STRADDR0_WR(v)     (HW_HDMI_AHB_DMA_STRADDR0.U = (v))
#define HW_HDMI_AHB_DMA_STRADDR0_SET(v)    (HW_HDMI_AHB_DMA_STRADDR0_WR(HW_HDMI_AHB_DMA_STRADDR0_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STRADDR0_CLR(v)    (HW_HDMI_AHB_DMA_STRADDR0_WR(HW_HDMI_AHB_DMA_STRADDR0_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STRADDR0_TOG(v)    (HW_HDMI_AHB_DMA_STRADDR0_WR(HW_HDMI_AHB_DMA_STRADDR0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STRADDR0 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STRADDR0, field INITIAL_ADDR[7:0] (RW)
 *
 * Defines init_addr[7:0] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR.
#define BM_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR) >> BP_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR.
#define BF_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR) & BM_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITIAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR(v)   (HW_HDMI_AHB_DMA_STRADDR0_WR((HW_HDMI_AHB_DMA_STRADDR0_RD() & ~BM_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR) | BF_HDMI_AHB_DMA_STRADDR0_INITIAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STRADDR1 - Audio DMA Start Address Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STRADDR1 - Audio DMA Start Address Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_straddr1
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_straddr1_bitfields
    {
        unsigned char INITIAL_ADDR : 8; //!< [7:0] Defines init_addr[15:8] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_straddr1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STRADDR1 register
 */
//@{
#define HW_HDMI_AHB_DMA_STRADDR1_ADDR      (REGS_HDMI_BASE + 0x3605)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STRADDR1           (*(volatile hw_hdmi_ahb_dma_straddr1_t *) HW_HDMI_AHB_DMA_STRADDR1_ADDR)
#define HW_HDMI_AHB_DMA_STRADDR1_RD()      (HW_HDMI_AHB_DMA_STRADDR1.U)
#define HW_HDMI_AHB_DMA_STRADDR1_WR(v)     (HW_HDMI_AHB_DMA_STRADDR1.U = (v))
#define HW_HDMI_AHB_DMA_STRADDR1_SET(v)    (HW_HDMI_AHB_DMA_STRADDR1_WR(HW_HDMI_AHB_DMA_STRADDR1_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STRADDR1_CLR(v)    (HW_HDMI_AHB_DMA_STRADDR1_WR(HW_HDMI_AHB_DMA_STRADDR1_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STRADDR1_TOG(v)    (HW_HDMI_AHB_DMA_STRADDR1_WR(HW_HDMI_AHB_DMA_STRADDR1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STRADDR1 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STRADDR1, field INITIAL_ADDR[7:0] (RW)
 *
 * Defines init_addr[15:8] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR.
#define BM_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR) >> BP_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR.
#define BF_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR) & BM_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITIAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR(v)   (HW_HDMI_AHB_DMA_STRADDR1_WR((HW_HDMI_AHB_DMA_STRADDR1_RD() & ~BM_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR) | BF_HDMI_AHB_DMA_STRADDR1_INITIAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STRADDR2 - Audio DMA Start Address Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STRADDR2 - Audio DMA Start Address Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_straddr2
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_straddr2_bitfields
    {
        unsigned char INITIAL_ADDR : 8; //!< [7:0] Defines init_addr[23:16] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_straddr2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STRADDR2 register
 */
//@{
#define HW_HDMI_AHB_DMA_STRADDR2_ADDR      (REGS_HDMI_BASE + 0x3606)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STRADDR2           (*(volatile hw_hdmi_ahb_dma_straddr2_t *) HW_HDMI_AHB_DMA_STRADDR2_ADDR)
#define HW_HDMI_AHB_DMA_STRADDR2_RD()      (HW_HDMI_AHB_DMA_STRADDR2.U)
#define HW_HDMI_AHB_DMA_STRADDR2_WR(v)     (HW_HDMI_AHB_DMA_STRADDR2.U = (v))
#define HW_HDMI_AHB_DMA_STRADDR2_SET(v)    (HW_HDMI_AHB_DMA_STRADDR2_WR(HW_HDMI_AHB_DMA_STRADDR2_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STRADDR2_CLR(v)    (HW_HDMI_AHB_DMA_STRADDR2_WR(HW_HDMI_AHB_DMA_STRADDR2_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STRADDR2_TOG(v)    (HW_HDMI_AHB_DMA_STRADDR2_WR(HW_HDMI_AHB_DMA_STRADDR2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STRADDR2 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STRADDR2, field INITIAL_ADDR[7:0] (RW)
 *
 * Defines init_addr[23:16] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR.
#define BM_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR) >> BP_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR.
#define BF_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR) & BM_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITIAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR(v)   (HW_HDMI_AHB_DMA_STRADDR2_WR((HW_HDMI_AHB_DMA_STRADDR2_RD() & ~BM_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR) | BF_HDMI_AHB_DMA_STRADDR2_INITIAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STRADDR3 - Audio DMA Start Address Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STRADDR3 - Audio DMA Start Address Register 3 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_straddr3
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_straddr3_bitfields
    {
        unsigned char INITIAL_ADDR : 8; //!< [7:0] Defines init_addr[31:24] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_straddr3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STRADDR3 register
 */
//@{
#define HW_HDMI_AHB_DMA_STRADDR3_ADDR      (REGS_HDMI_BASE + 0x3607)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STRADDR3           (*(volatile hw_hdmi_ahb_dma_straddr3_t *) HW_HDMI_AHB_DMA_STRADDR3_ADDR)
#define HW_HDMI_AHB_DMA_STRADDR3_RD()      (HW_HDMI_AHB_DMA_STRADDR3.U)
#define HW_HDMI_AHB_DMA_STRADDR3_WR(v)     (HW_HDMI_AHB_DMA_STRADDR3.U = (v))
#define HW_HDMI_AHB_DMA_STRADDR3_SET(v)    (HW_HDMI_AHB_DMA_STRADDR3_WR(HW_HDMI_AHB_DMA_STRADDR3_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STRADDR3_CLR(v)    (HW_HDMI_AHB_DMA_STRADDR3_WR(HW_HDMI_AHB_DMA_STRADDR3_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STRADDR3_TOG(v)    (HW_HDMI_AHB_DMA_STRADDR3_WR(HW_HDMI_AHB_DMA_STRADDR3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STRADDR3 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STRADDR3, field INITIAL_ADDR[7:0] (RW)
 *
 * Defines init_addr[31:24] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR.
#define BM_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR) >> BP_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR.
#define BF_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR) & BM_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITIAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR(v)   (HW_HDMI_AHB_DMA_STRADDR3_WR((HW_HDMI_AHB_DMA_STRADDR3_RD() & ~BM_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR) | BF_HDMI_AHB_DMA_STRADDR3_INITIAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STPADDR0 - Audio DMA Stop Address Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STPADDR0 - Audio DMA Stop Address Register 0 (RW)
 *
 * Reset value: 0x00
 *
 * This registers define the final_addr[31:0] used as the final point to the DMA burst read
 * transactions. Upon data_buffer_ready configuration, the DMA engine starts requesting burst reads
 * from the external system memory. Each burst read can have a maximum theoretical length of 1024
 * words (due to the AMBA AHB specification restriction). As an example, if the first burst
 * transaction of the AHB audio DMA has a length of 16, then the second burst starts at address
 * ohaddr[31:0] = initial_addr[31:0] + 16 and has a length of mburstlength[10:0] = AUDIO_FIFO_DEPTH
 * - fifo_threshold[7:0]. The DMA engine is responsible for incrementing the burst starting address
 * and defining its corresponding burst length to reach the final_addr[31:0] address. The last burst
 * request issued by the DMA engine takes into account that it should only request data until the
 * final_addr[31:0] address (included) and for that should calculate the correct burst length. After
 * reaching the final_addr[31:0] address, the done interrupt is active to signal completion of DMA
 * operation. Address Offset: 0x3608 to 0x360B Size: 8 bits per register Value after Reset: 0x00
 * Access: Read/Write
 */
typedef union _hw_hdmi_ahb_dma_stpaddr0
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stpaddr0_bitfields
    {
        unsigned char FINAL_ADDR : 8; //!< [7:0] Defines final_addr[7:0] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_stpaddr0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STPADDR0 register
 */
//@{
#define HW_HDMI_AHB_DMA_STPADDR0_ADDR      (REGS_HDMI_BASE + 0x3608)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STPADDR0           (*(volatile hw_hdmi_ahb_dma_stpaddr0_t *) HW_HDMI_AHB_DMA_STPADDR0_ADDR)
#define HW_HDMI_AHB_DMA_STPADDR0_RD()      (HW_HDMI_AHB_DMA_STPADDR0.U)
#define HW_HDMI_AHB_DMA_STPADDR0_WR(v)     (HW_HDMI_AHB_DMA_STPADDR0.U = (v))
#define HW_HDMI_AHB_DMA_STPADDR0_SET(v)    (HW_HDMI_AHB_DMA_STPADDR0_WR(HW_HDMI_AHB_DMA_STPADDR0_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STPADDR0_CLR(v)    (HW_HDMI_AHB_DMA_STPADDR0_WR(HW_HDMI_AHB_DMA_STPADDR0_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STPADDR0_TOG(v)    (HW_HDMI_AHB_DMA_STPADDR0_WR(HW_HDMI_AHB_DMA_STPADDR0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STPADDR0 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STPADDR0, field FINAL_ADDR[7:0] (RW)
 *
 * Defines final_addr[7:0] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STPADDR0_FINAL_ADDR.
#define BM_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STPADDR0_FINAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STPADDR0_FINAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR) >> BP_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STPADDR0_FINAL_ADDR.
#define BF_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR) & BM_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FINAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR(v)   (HW_HDMI_AHB_DMA_STPADDR0_WR((HW_HDMI_AHB_DMA_STPADDR0_RD() & ~BM_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR) | BF_HDMI_AHB_DMA_STPADDR0_FINAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STPADDR1 - Audio DMA Stop Address Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STPADDR1 - Audio DMA Stop Address Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_stpaddr1
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stpaddr1_bitfields
    {
        unsigned char FINAL_ADDR : 8; //!< [7:0] Defines final_addr[15:8] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_stpaddr1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STPADDR1 register
 */
//@{
#define HW_HDMI_AHB_DMA_STPADDR1_ADDR      (REGS_HDMI_BASE + 0x3609)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STPADDR1           (*(volatile hw_hdmi_ahb_dma_stpaddr1_t *) HW_HDMI_AHB_DMA_STPADDR1_ADDR)
#define HW_HDMI_AHB_DMA_STPADDR1_RD()      (HW_HDMI_AHB_DMA_STPADDR1.U)
#define HW_HDMI_AHB_DMA_STPADDR1_WR(v)     (HW_HDMI_AHB_DMA_STPADDR1.U = (v))
#define HW_HDMI_AHB_DMA_STPADDR1_SET(v)    (HW_HDMI_AHB_DMA_STPADDR1_WR(HW_HDMI_AHB_DMA_STPADDR1_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STPADDR1_CLR(v)    (HW_HDMI_AHB_DMA_STPADDR1_WR(HW_HDMI_AHB_DMA_STPADDR1_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STPADDR1_TOG(v)    (HW_HDMI_AHB_DMA_STPADDR1_WR(HW_HDMI_AHB_DMA_STPADDR1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STPADDR1 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STPADDR1, field FINAL_ADDR[7:0] (RW)
 *
 * Defines final_addr[15:8] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STPADDR1_FINAL_ADDR.
#define BM_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STPADDR1_FINAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STPADDR1_FINAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR) >> BP_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STPADDR1_FINAL_ADDR.
#define BF_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR) & BM_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FINAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR(v)   (HW_HDMI_AHB_DMA_STPADDR1_WR((HW_HDMI_AHB_DMA_STPADDR1_RD() & ~BM_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR) | BF_HDMI_AHB_DMA_STPADDR1_FINAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STPADDR2 - Audio DMA Stop Address Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STPADDR2 - Audio DMA Stop Address Register 2 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_stpaddr2
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stpaddr2_bitfields
    {
        unsigned char FINAL_ADDR : 8; //!< [7:0] Defines final_addr[23:16] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_stpaddr2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STPADDR2 register
 */
//@{
#define HW_HDMI_AHB_DMA_STPADDR2_ADDR      (REGS_HDMI_BASE + 0x360a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STPADDR2           (*(volatile hw_hdmi_ahb_dma_stpaddr2_t *) HW_HDMI_AHB_DMA_STPADDR2_ADDR)
#define HW_HDMI_AHB_DMA_STPADDR2_RD()      (HW_HDMI_AHB_DMA_STPADDR2.U)
#define HW_HDMI_AHB_DMA_STPADDR2_WR(v)     (HW_HDMI_AHB_DMA_STPADDR2.U = (v))
#define HW_HDMI_AHB_DMA_STPADDR2_SET(v)    (HW_HDMI_AHB_DMA_STPADDR2_WR(HW_HDMI_AHB_DMA_STPADDR2_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STPADDR2_CLR(v)    (HW_HDMI_AHB_DMA_STPADDR2_WR(HW_HDMI_AHB_DMA_STPADDR2_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STPADDR2_TOG(v)    (HW_HDMI_AHB_DMA_STPADDR2_WR(HW_HDMI_AHB_DMA_STPADDR2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STPADDR2 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STPADDR2, field FINAL_ADDR[7:0] (RW)
 *
 * Defines final_addr[23:16] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STPADDR2_FINAL_ADDR.
#define BM_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STPADDR2_FINAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STPADDR2_FINAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR) >> BP_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STPADDR2_FINAL_ADDR.
#define BF_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR) & BM_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FINAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR(v)   (HW_HDMI_AHB_DMA_STPADDR2_WR((HW_HDMI_AHB_DMA_STPADDR2_RD() & ~BM_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR) | BF_HDMI_AHB_DMA_STPADDR2_FINAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STPADDR3 - Audio DMA Stop Address Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STPADDR3 - Audio DMA Stop Address Register 3 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_stpaddr3
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stpaddr3_bitfields
    {
        unsigned char FINAL_ADDR : 8; //!< [7:0] Defines final_addr[31:24] for bits 7-0 to initiate DMA burst transactions
    } B;
} hw_hdmi_ahb_dma_stpaddr3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STPADDR3 register
 */
//@{
#define HW_HDMI_AHB_DMA_STPADDR3_ADDR      (REGS_HDMI_BASE + 0x360b)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STPADDR3           (*(volatile hw_hdmi_ahb_dma_stpaddr3_t *) HW_HDMI_AHB_DMA_STPADDR3_ADDR)
#define HW_HDMI_AHB_DMA_STPADDR3_RD()      (HW_HDMI_AHB_DMA_STPADDR3.U)
#define HW_HDMI_AHB_DMA_STPADDR3_WR(v)     (HW_HDMI_AHB_DMA_STPADDR3.U = (v))
#define HW_HDMI_AHB_DMA_STPADDR3_SET(v)    (HW_HDMI_AHB_DMA_STPADDR3_WR(HW_HDMI_AHB_DMA_STPADDR3_RD() |  (v)))
#define HW_HDMI_AHB_DMA_STPADDR3_CLR(v)    (HW_HDMI_AHB_DMA_STPADDR3_WR(HW_HDMI_AHB_DMA_STPADDR3_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_STPADDR3_TOG(v)    (HW_HDMI_AHB_DMA_STPADDR3_WR(HW_HDMI_AHB_DMA_STPADDR3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STPADDR3 bitfields
 */

/*! @name Register HDMI_AHB_DMA_STPADDR3, field FINAL_ADDR[7:0] (RW)
 *
 * Defines final_addr[31:24] for bits 7-0 to initiate DMA burst transactions
 */
//@{
#define BP_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR      (0)      //!< Bit position for HDMI_AHB_DMA_STPADDR3_FINAL_ADDR.
#define BM_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_STPADDR3_FINAL_ADDR.

//! @brief Get value of HDMI_AHB_DMA_STPADDR3_FINAL_ADDR from a register value.
#define BG_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR) >> BP_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR)

//! @brief Format value for bitfield HDMI_AHB_DMA_STPADDR3_FINAL_ADDR.
#define BF_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR) & BM_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FINAL_ADDR field to a new value.
#define BW_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR(v)   (HW_HDMI_AHB_DMA_STPADDR3_WR((HW_HDMI_AHB_DMA_STPADDR3_RD() & ~BM_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR) | BF_HDMI_AHB_DMA_STPADDR3_FINAL_ADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BSTADDR0 - Audio DMA Burst Start Address Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BSTADDR0 - Audio DMA Burst Start Address Register 0 (RO)
 *
 * Reset value: 0x00
 *
 * This read-only register composes the start address of the current burst operation. As an example,
 * if the first burst transaction of the AHB audio DMA as a length of 16, then the second burst
 * should start at address ohaddr[31:0] = initial_addr[31:0] + 16. While this burst is being
 * executed, burst_start_addr[31:0] = haddr[31:0] = initial_addr[31:0] + 16. Address Offset: 0x360C
 * to 0x360F Size: 8 bits per register Value after Reset: 0x00 Access: Read
 */
typedef union _hw_hdmi_ahb_dma_bstaddr0
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_bstaddr0_bitfields
    {
        unsigned char BURST_START : 8; //!< [7:0] Start address for the current burst operation
    } B;
} hw_hdmi_ahb_dma_bstaddr0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BSTADDR0 register
 */
//@{
#define HW_HDMI_AHB_DMA_BSTADDR0_ADDR      (REGS_HDMI_BASE + 0x360c)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BSTADDR0           (*(volatile hw_hdmi_ahb_dma_bstaddr0_t *) HW_HDMI_AHB_DMA_BSTADDR0_ADDR)
#define HW_HDMI_AHB_DMA_BSTADDR0_RD()      (HW_HDMI_AHB_DMA_BSTADDR0.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BSTADDR0 bitfields
 */

/*! @name Register HDMI_AHB_DMA_BSTADDR0, field BURST_START[7:0] (RO)
 *
 * Start address for the current burst operation
 */
//@{
#define BP_HDMI_AHB_DMA_BSTADDR0_BURST_START      (0)      //!< Bit position for HDMI_AHB_DMA_BSTADDR0_BURST_START.
#define BM_HDMI_AHB_DMA_BSTADDR0_BURST_START      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_BSTADDR0_BURST_START.

//! @brief Get value of HDMI_AHB_DMA_BSTADDR0_BURST_START from a register value.
#define BG_HDMI_AHB_DMA_BSTADDR0_BURST_START(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BSTADDR0_BURST_START) >> BP_HDMI_AHB_DMA_BSTADDR0_BURST_START)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BSTADDR1 - Audio DMA Burst Start Address Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BSTADDR1 - Audio DMA Burst Start Address Register 1 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_bstaddr1
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_bstaddr1_bitfields
    {
        unsigned char BURST_START : 8; //!< [7:0] Start address for the current burst operation
    } B;
} hw_hdmi_ahb_dma_bstaddr1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BSTADDR1 register
 */
//@{
#define HW_HDMI_AHB_DMA_BSTADDR1_ADDR      (REGS_HDMI_BASE + 0x360d)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BSTADDR1           (*(volatile hw_hdmi_ahb_dma_bstaddr1_t *) HW_HDMI_AHB_DMA_BSTADDR1_ADDR)
#define HW_HDMI_AHB_DMA_BSTADDR1_RD()      (HW_HDMI_AHB_DMA_BSTADDR1.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BSTADDR1 bitfields
 */

/*! @name Register HDMI_AHB_DMA_BSTADDR1, field BURST_START[7:0] (RO)
 *
 * Start address for the current burst operation
 */
//@{
#define BP_HDMI_AHB_DMA_BSTADDR1_BURST_START      (0)      //!< Bit position for HDMI_AHB_DMA_BSTADDR1_BURST_START.
#define BM_HDMI_AHB_DMA_BSTADDR1_BURST_START      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_BSTADDR1_BURST_START.

//! @brief Get value of HDMI_AHB_DMA_BSTADDR1_BURST_START from a register value.
#define BG_HDMI_AHB_DMA_BSTADDR1_BURST_START(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BSTADDR1_BURST_START) >> BP_HDMI_AHB_DMA_BSTADDR1_BURST_START)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BSTADDR2 - Audio DMA Burst Start Address Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BSTADDR2 - Audio DMA Burst Start Address Register 2 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_bstaddr2
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_bstaddr2_bitfields
    {
        unsigned char BURST_START : 8; //!< [7:0] Start address for the current burst operation
    } B;
} hw_hdmi_ahb_dma_bstaddr2_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BSTADDR2 register
 */
//@{
#define HW_HDMI_AHB_DMA_BSTADDR2_ADDR      (REGS_HDMI_BASE + 0x360e)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BSTADDR2           (*(volatile hw_hdmi_ahb_dma_bstaddr2_t *) HW_HDMI_AHB_DMA_BSTADDR2_ADDR)
#define HW_HDMI_AHB_DMA_BSTADDR2_RD()      (HW_HDMI_AHB_DMA_BSTADDR2.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BSTADDR2 bitfields
 */

/*! @name Register HDMI_AHB_DMA_BSTADDR2, field BURST_START[7:0] (RO)
 *
 * Start address for the current burst operation
 */
//@{
#define BP_HDMI_AHB_DMA_BSTADDR2_BURST_START      (0)      //!< Bit position for HDMI_AHB_DMA_BSTADDR2_BURST_START.
#define BM_HDMI_AHB_DMA_BSTADDR2_BURST_START      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_BSTADDR2_BURST_START.

//! @brief Get value of HDMI_AHB_DMA_BSTADDR2_BURST_START from a register value.
#define BG_HDMI_AHB_DMA_BSTADDR2_BURST_START(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BSTADDR2_BURST_START) >> BP_HDMI_AHB_DMA_BSTADDR2_BURST_START)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BSTADDR3 - Audio DMA Burst Start Address Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BSTADDR3 - Audio DMA Burst Start Address Register 3 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_bstaddr3
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_bstaddr3_bitfields
    {
        unsigned char BURST_START : 8; //!< [7:0] Start address for the current burst operation
    } B;
} hw_hdmi_ahb_dma_bstaddr3_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BSTADDR3 register
 */
//@{
#define HW_HDMI_AHB_DMA_BSTADDR3_ADDR      (REGS_HDMI_BASE + 0x360f)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BSTADDR3           (*(volatile hw_hdmi_ahb_dma_bstaddr3_t *) HW_HDMI_AHB_DMA_BSTADDR3_ADDR)
#define HW_HDMI_AHB_DMA_BSTADDR3_RD()      (HW_HDMI_AHB_DMA_BSTADDR3.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BSTADDR3 bitfields
 */

/*! @name Register HDMI_AHB_DMA_BSTADDR3, field BURST_START[7:0] (RO)
 *
 * Start address for the current burst operation
 */
//@{
#define BP_HDMI_AHB_DMA_BSTADDR3_BURST_START      (0)      //!< Bit position for HDMI_AHB_DMA_BSTADDR3_BURST_START.
#define BM_HDMI_AHB_DMA_BSTADDR3_BURST_START      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_BSTADDR3_BURST_START.

//! @brief Get value of HDMI_AHB_DMA_BSTADDR3_BURST_START from a register value.
#define BG_HDMI_AHB_DMA_BSTADDR3_BURST_START(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BSTADDR3_BURST_START) >> BP_HDMI_AHB_DMA_BSTADDR3_BURST_START)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_MBLENGTH0 - Audio DMA Burst Length Register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_MBLENGTH0 - Audio DMA Burst Length Register 0 (RO)
 *
 * Reset value: 0x00
 *
 * These registers hold the length of the current burst operation. As an example, if the first burst
 * transaction of the AHB audio DMA is a length of 8, then the second burst should start at address
 * ohaddr[31:0] = initial_addr[31:0] + 8. It will also have length mburstlength[10:0] =
 * AUDIO_FIFO_DEPTH - fifo_threshold[7:0] while this burst is being executed, mburstlength[10:0] =
 * AUDIO_FIFO_DEPTH - fifo_threshold[7:0]. Address Offset: 0x3610 to 0x3611 Size: 8 bits per
 * register Value after Reset: 0x00 Access: Read
 */
typedef union _hw_hdmi_ahb_dma_mblength0
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_mblength0_bitfields
    {
        unsigned char MBURSTLENGTH : 8; //!< [7:0] Requested burst length
    } B;
} hw_hdmi_ahb_dma_mblength0_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_MBLENGTH0 register
 */
//@{
#define HW_HDMI_AHB_DMA_MBLENGTH0_ADDR      (REGS_HDMI_BASE + 0x3610)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_MBLENGTH0           (*(volatile hw_hdmi_ahb_dma_mblength0_t *) HW_HDMI_AHB_DMA_MBLENGTH0_ADDR)
#define HW_HDMI_AHB_DMA_MBLENGTH0_RD()      (HW_HDMI_AHB_DMA_MBLENGTH0.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_MBLENGTH0 bitfields
 */

/*! @name Register HDMI_AHB_DMA_MBLENGTH0, field MBURSTLENGTH[7:0] (RO)
 *
 * Requested burst length
 */
//@{
#define BP_HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH      (0)      //!< Bit position for HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH.
#define BM_HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH      (0x000000ff)  //!< Bit mask for HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH.

//! @brief Get value of HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH from a register value.
#define BG_HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH) >> BP_HDMI_AHB_DMA_MBLENGTH0_MBURSTLENGTH)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_MBLENGTH1 - Audio DMA Burst Length Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_MBLENGTH1 - Audio DMA Burst Length Register 1 (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_mblength1
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_mblength1_bitfields
    {
        unsigned char MBURSTLENGTH : 1; //!< [0] Requested burst length
        unsigned char MBURSTLENGTH1 : 1; //!< [1] Requested burst length
        unsigned char MBURSTLENGTH2 : 1; //!< [2] Requested burst length
        unsigned char RESERVED0 : 5; //!< [7:3] Reserved
    } B;
} hw_hdmi_ahb_dma_mblength1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_MBLENGTH1 register
 */
//@{
#define HW_HDMI_AHB_DMA_MBLENGTH1_ADDR      (REGS_HDMI_BASE + 0x3611)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_MBLENGTH1           (*(volatile hw_hdmi_ahb_dma_mblength1_t *) HW_HDMI_AHB_DMA_MBLENGTH1_ADDR)
#define HW_HDMI_AHB_DMA_MBLENGTH1_RD()      (HW_HDMI_AHB_DMA_MBLENGTH1.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_MBLENGTH1 bitfields
 */

/*! @name Register HDMI_AHB_DMA_MBLENGTH1, field MBURSTLENGTH[0] (RO)
 *
 * Requested burst length
 */
//@{
#define BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH      (0)      //!< Bit position for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH.
#define BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH.

//! @brief Get value of HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH from a register value.
#define BG_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH) >> BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH)
//@}

/*! @name Register HDMI_AHB_DMA_MBLENGTH1, field MBURSTLENGTH1[1] (RO)
 *
 * Requested burst length
 */
//@{
#define BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1      (1)      //!< Bit position for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1.
#define BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1.

//! @brief Get value of HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1 from a register value.
#define BG_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1) >> BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH1)
//@}

/*! @name Register HDMI_AHB_DMA_MBLENGTH1, field MBURSTLENGTH2[2] (RO)
 *
 * Requested burst length
 */
//@{
#define BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2      (2)      //!< Bit position for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2.
#define BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2.

//! @brief Get value of HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2 from a register value.
#define BG_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2) >> BP_HDMI_AHB_DMA_MBLENGTH1_MBURSTLENGTH2)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_STAT - Audio DMA Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_STAT - Audio DMA Interrupt Status Register (RO)
 *
 * Reset value: 0x00
 *
 * This register contains the status bits of the following interrupts: Address Offset: 0x3612 Size:
 * 8 bits per register Value after Reset: 0x00 Access: Read
 */
typedef union _hw_hdmi_ahb_dma_stat
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_stat_bitfields
    {
        unsigned char STATFIFOEMPTY : 1; //!< [0] Status of audio FIFO empty interrupt.
        unsigned char STATFIFOFULL : 1; //!< [1] Status of audio FIFO full interrupt.
        unsigned char STATTHRFIFOEMPTY : 1; //!< [2] Status of audio FIFO empty when audio FIFO has less than four samples.
        unsigned char RESERVED0 : 1; //!< [3] Reserved
        unsigned char STATERROR : 1; //!< [4] Status of error interrupt.
        unsigned char STATLOSTOWNERSHIP : 1; //!< [5] Status of master lost ownership when in burst transfer.
        unsigned char STATRETRYSPLIT : 1; //!< [6] Status of retry/split interrupt.
        unsigned char STATDONE : 1; //!< [7] Status of DMA end of operation interrupt.
    } B;
} hw_hdmi_ahb_dma_stat_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_STAT register
 */
//@{
#define HW_HDMI_AHB_DMA_STAT_ADDR      (REGS_HDMI_BASE + 0x3612)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_STAT           (*(volatile hw_hdmi_ahb_dma_stat_t *) HW_HDMI_AHB_DMA_STAT_ADDR)
#define HW_HDMI_AHB_DMA_STAT_RD()      (HW_HDMI_AHB_DMA_STAT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_STAT bitfields
 */

/*! @name Register HDMI_AHB_DMA_STAT, field STATFIFOEMPTY[0] (RO)
 *
 * Status of audio FIFO empty interrupt.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATFIFOEMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_STAT_STATFIFOEMPTY.
#define BM_HDMI_AHB_DMA_STAT_STATFIFOEMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATFIFOEMPTY.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATFIFOEMPTY from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATFIFOEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATFIFOEMPTY) >> BP_HDMI_AHB_DMA_STAT_STATFIFOEMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATFIFOFULL[1] (RO)
 *
 * Status of audio FIFO full interrupt.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATFIFOFULL      (1)      //!< Bit position for HDMI_AHB_DMA_STAT_STATFIFOFULL.
#define BM_HDMI_AHB_DMA_STAT_STATFIFOFULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATFIFOFULL.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATFIFOFULL from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATFIFOFULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATFIFOFULL) >> BP_HDMI_AHB_DMA_STAT_STATFIFOFULL)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATTHRFIFOEMPTY[2] (RO)
 *
 * Status of audio FIFO empty when audio FIFO has less than four samples.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY      (2)      //!< Bit position for HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY.
#define BM_HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY) >> BP_HDMI_AHB_DMA_STAT_STATTHRFIFOEMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATERROR[4] (RO)
 *
 * Status of error interrupt. Active when slave indicates error through the isresp[1:0].
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATERROR      (4)      //!< Bit position for HDMI_AHB_DMA_STAT_STATERROR.
#define BM_HDMI_AHB_DMA_STAT_STATERROR      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATERROR.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATERROR from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATERROR) >> BP_HDMI_AHB_DMA_STAT_STATERROR)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATLOSTOWNERSHIP[5] (RO)
 *
 * Status of master lost ownership when in burst transfer. Active when AHB master loses BUS
 * ownership within the course of a burst transfer.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP      (5)      //!< Bit position for HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP.
#define BM_HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP      (0x00000020)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP) >> BP_HDMI_AHB_DMA_STAT_STATLOSTOWNERSHIP)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATRETRYSPLIT[6] (RO)
 *
 * Status of retry/split interrupt. Active when AHB master receives a RETRY or SPLIT response from
 * slave.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATRETRYSPLIT      (6)      //!< Bit position for HDMI_AHB_DMA_STAT_STATRETRYSPLIT.
#define BM_HDMI_AHB_DMA_STAT_STATRETRYSPLIT      (0x00000040)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATRETRYSPLIT.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATRETRYSPLIT from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATRETRYSPLIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATRETRYSPLIT) >> BP_HDMI_AHB_DMA_STAT_STATRETRYSPLIT)
//@}

/*! @name Register HDMI_AHB_DMA_STAT, field STATDONE[7] (RO)
 *
 * Status of DMA end of operation interrupt. Active when DMA engine reaches final_addr[15:0] or when
 * stop DMA operation is activated.
 */
//@{
#define BP_HDMI_AHB_DMA_STAT_STATDONE      (7)      //!< Bit position for HDMI_AHB_DMA_STAT_STATDONE.
#define BM_HDMI_AHB_DMA_STAT_STATDONE      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_STAT_STATDONE.

//! @brief Get value of HDMI_AHB_DMA_STAT_STATDONE from a register value.
#define BG_HDMI_AHB_DMA_STAT_STATDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_STAT_STATDONE) >> BP_HDMI_AHB_DMA_STAT_STATDONE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_INT - Audio DMA Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_INT - Audio DMA Interrupt Register (RO)
 *
 * Reset value: 0x00
 *
 * This register contains the interrupt bits of the following interrupts: Address Offset: 0x3613
 * Size: 8 bits per register Value after Reset: 0x00 Access: Read
 */
typedef union _hw_hdmi_ahb_dma_int
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_int_bitfields
    {
        unsigned char INTFIFOEMPTY : 1; //!< [0] Audio FIFO empty interrupt.
        unsigned char INTFIFOFULL : 1; //!< [1] Audio FIFO full interrupt.
        unsigned char INTTHRFIFOEMPTY : 1; //!< [2] Audio FIFO empty interrupt when audio FIFO has less than four samples.
        unsigned char RESERVED0 : 1; //!< [3] Reserved
        unsigned char INTERROR : 1; //!< [4] Error interrupt.
        unsigned char INTLOSTOWNERSHIP : 1; //!< [5] Master lost ownership interrupt when in burst transfer.
        unsigned char INTRETRYSPLIT : 1; //!< [6] Retry/split interrupt.
        unsigned char INTDONE : 1; //!< [7] DMA end of operation interrupt.
    } B;
} hw_hdmi_ahb_dma_int_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_INT register
 */
//@{
#define HW_HDMI_AHB_DMA_INT_ADDR      (REGS_HDMI_BASE + 0x3613)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_INT           (*(volatile hw_hdmi_ahb_dma_int_t *) HW_HDMI_AHB_DMA_INT_ADDR)
#define HW_HDMI_AHB_DMA_INT_RD()      (HW_HDMI_AHB_DMA_INT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_INT bitfields
 */

/*! @name Register HDMI_AHB_DMA_INT, field INTFIFOEMPTY[0] (RO)
 *
 * Audio FIFO empty interrupt.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTFIFOEMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_INT_INTFIFOEMPTY.
#define BM_HDMI_AHB_DMA_INT_INTFIFOEMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_INT_INTFIFOEMPTY.

//! @brief Get value of HDMI_AHB_DMA_INT_INTFIFOEMPTY from a register value.
#define BG_HDMI_AHB_DMA_INT_INTFIFOEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTFIFOEMPTY) >> BP_HDMI_AHB_DMA_INT_INTFIFOEMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTFIFOFULL[1] (RO)
 *
 * Audio FIFO full interrupt.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTFIFOFULL      (1)      //!< Bit position for HDMI_AHB_DMA_INT_INTFIFOFULL.
#define BM_HDMI_AHB_DMA_INT_INTFIFOFULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_INT_INTFIFOFULL.

//! @brief Get value of HDMI_AHB_DMA_INT_INTFIFOFULL from a register value.
#define BG_HDMI_AHB_DMA_INT_INTFIFOFULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTFIFOFULL) >> BP_HDMI_AHB_DMA_INT_INTFIFOFULL)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTTHRFIFOEMPTY[2] (RO)
 *
 * Audio FIFO empty interrupt when audio FIFO has less than four samples.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY      (2)      //!< Bit position for HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY.
#define BM_HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY.

//! @brief Get value of HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY from a register value.
#define BG_HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY) >> BP_HDMI_AHB_DMA_INT_INTTHRFIFOEMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTERROR[4] (RO)
 *
 * Error interrupt. Active when slave indicates error through the isresp[1:0].
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTERROR      (4)      //!< Bit position for HDMI_AHB_DMA_INT_INTERROR.
#define BM_HDMI_AHB_DMA_INT_INTERROR      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_INT_INTERROR.

//! @brief Get value of HDMI_AHB_DMA_INT_INTERROR from a register value.
#define BG_HDMI_AHB_DMA_INT_INTERROR(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTERROR) >> BP_HDMI_AHB_DMA_INT_INTERROR)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTLOSTOWNERSHIP[5] (RO)
 *
 * Master lost ownership interrupt when in burst transfer. Active when AHB master loses BUS
 * ownership within the course of a burst transfer.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP      (5)      //!< Bit position for HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP.
#define BM_HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP      (0x00000020)  //!< Bit mask for HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP.

//! @brief Get value of HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP from a register value.
#define BG_HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP) >> BP_HDMI_AHB_DMA_INT_INTLOSTOWNERSHIP)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTRETRYSPLIT[6] (RO)
 *
 * Retry/split interrupt. Active when AHB master receives a RETRY or SPLIT response from slave.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTRETRYSPLIT      (6)      //!< Bit position for HDMI_AHB_DMA_INT_INTRETRYSPLIT.
#define BM_HDMI_AHB_DMA_INT_INTRETRYSPLIT      (0x00000040)  //!< Bit mask for HDMI_AHB_DMA_INT_INTRETRYSPLIT.

//! @brief Get value of HDMI_AHB_DMA_INT_INTRETRYSPLIT from a register value.
#define BG_HDMI_AHB_DMA_INT_INTRETRYSPLIT(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTRETRYSPLIT) >> BP_HDMI_AHB_DMA_INT_INTRETRYSPLIT)
//@}

/*! @name Register HDMI_AHB_DMA_INT, field INTDONE[7] (RO)
 *
 * DMA end of operation interrupt. Active when DMA engine reaches final_addr[15:0] or when stop DMA
 * operation is activated.
 */
//@{
#define BP_HDMI_AHB_DMA_INT_INTDONE      (7)      //!< Bit position for HDMI_AHB_DMA_INT_INTDONE.
#define BM_HDMI_AHB_DMA_INT_INTDONE      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_INT_INTDONE.

//! @brief Get value of HDMI_AHB_DMA_INT_INTDONE from a register value.
#define BG_HDMI_AHB_DMA_INT_INTDONE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_INT_INTDONE) >> BP_HDMI_AHB_DMA_INT_INTDONE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_MASK - Audio DMA Mask Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_MASK - Audio DMA Mask Interrupt Register (RW)
 *
 * Reset value: 0x00
 *
 * Mask for each of the interrupts present in the AHB audio DMA module. For usage information, see
 * ." Address Offset: 0x3614 Size: 8 bits per register Value after Reset: 0x00 Access: Read/Write
 */
typedef union _hw_hdmi_ahb_dma_mask
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_mask_bitfields
    {
        unsigned char FIFO_EMPTY_MASK : 1; //!< [0] Audio FIFO empty interrupt mask.
        unsigned char FIFO_FULL_MASK : 1; //!< [1] Audio FIFO full interrupt mask.
        unsigned char FIFO_THREMPTY_MASK : 1; //!< [2] Audio FIFO empty interrupt mask when audio FIFO has less than four samples.
        unsigned char RESERVED0 : 1; //!< [3] Reserved
        unsigned char ERROR_MASK : 1; //!< [4] Error interrupt mask.
        unsigned char LOSTOWNERSHIP_MASK : 1; //!< [5] Master lost ownership interrupt mask when in burst transfer.
        unsigned char RETRYSPLIT_MASK : 1; //!< [6] Retry/split interrupt mask.
        unsigned char DONE_MASK : 1; //!< [7] DMA end of operation interrupt mask.
    } B;
} hw_hdmi_ahb_dma_mask_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_MASK register
 */
//@{
#define HW_HDMI_AHB_DMA_MASK_ADDR      (REGS_HDMI_BASE + 0x3614)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_MASK           (*(volatile hw_hdmi_ahb_dma_mask_t *) HW_HDMI_AHB_DMA_MASK_ADDR)
#define HW_HDMI_AHB_DMA_MASK_RD()      (HW_HDMI_AHB_DMA_MASK.U)
#define HW_HDMI_AHB_DMA_MASK_WR(v)     (HW_HDMI_AHB_DMA_MASK.U = (v))
#define HW_HDMI_AHB_DMA_MASK_SET(v)    (HW_HDMI_AHB_DMA_MASK_WR(HW_HDMI_AHB_DMA_MASK_RD() |  (v)))
#define HW_HDMI_AHB_DMA_MASK_CLR(v)    (HW_HDMI_AHB_DMA_MASK_WR(HW_HDMI_AHB_DMA_MASK_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_MASK_TOG(v)    (HW_HDMI_AHB_DMA_MASK_WR(HW_HDMI_AHB_DMA_MASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_MASK bitfields
 */

/*! @name Register HDMI_AHB_DMA_MASK, field FIFO_EMPTY_MASK[0] (RW)
 *
 * Audio FIFO empty interrupt mask.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK      (0)      //!< Bit position for HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK.
#define BM_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK) >> BP_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK.
#define BF_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK) & BM_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_EMPTY_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK) | BF_HDMI_AHB_DMA_MASK_FIFO_EMPTY_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field FIFO_FULL_MASK[1] (RW)
 *
 * Audio FIFO full interrupt mask.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK      (1)      //!< Bit position for HDMI_AHB_DMA_MASK_FIFO_FULL_MASK.
#define BM_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_MASK_FIFO_FULL_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_FIFO_FULL_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK) >> BP_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_FIFO_FULL_MASK.
#define BF_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK) & BM_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_FULL_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK) | BF_HDMI_AHB_DMA_MASK_FIFO_FULL_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field FIFO_THREMPTY_MASK[2] (RW)
 *
 * Audio FIFO empty interrupt mask when audio FIFO has less than four samples.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK      (2)      //!< Bit position for HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK.
#define BM_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK) >> BP_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK.
#define BF_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK) & BM_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_THREMPTY_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK) | BF_HDMI_AHB_DMA_MASK_FIFO_THREMPTY_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field ERROR_MASK[4] (RW)
 *
 * Error interrupt mask. Active when slave indicates error through the isresp[1:0].
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_ERROR_MASK      (4)      //!< Bit position for HDMI_AHB_DMA_MASK_ERROR_MASK.
#define BM_HDMI_AHB_DMA_MASK_ERROR_MASK      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_MASK_ERROR_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_ERROR_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_ERROR_MASK) >> BP_HDMI_AHB_DMA_MASK_ERROR_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_ERROR_MASK.
#define BF_HDMI_AHB_DMA_MASK_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_ERROR_MASK) & BM_HDMI_AHB_DMA_MASK_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_ERROR_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_ERROR_MASK) | BF_HDMI_AHB_DMA_MASK_ERROR_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field LOSTOWNERSHIP_MASK[5] (RW)
 *
 * Master lost ownership interrupt mask when in burst transfer. Active when AHB master loses BUS
 * ownership within the course of a burst transfer.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK      (5)      //!< Bit position for HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK.
#define BM_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK      (0x00000020)  //!< Bit mask for HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK) >> BP_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK.
#define BF_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK) & BM_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOSTOWNERSHIP_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK) | BF_HDMI_AHB_DMA_MASK_LOSTOWNERSHIP_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field RETRYSPLIT_MASK[6] (RW)
 *
 * Retry/split interrupt mask. Active when AHB master receives a RETRY or SPLIT response from slave.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK      (6)      //!< Bit position for HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK.
#define BM_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK      (0x00000040)  //!< Bit mask for HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK) >> BP_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK.
#define BF_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK) & BM_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RETRYSPLIT_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK) | BF_HDMI_AHB_DMA_MASK_RETRYSPLIT_MASK(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_MASK, field DONE_MASK[7] (RW)
 *
 * DMA end of operation interrupt mask. Active when DMA engine reaches final_addr[15:0] or when stop
 * DMA operation is activated.
 */
//@{
#define BP_HDMI_AHB_DMA_MASK_DONE_MASK      (7)      //!< Bit position for HDMI_AHB_DMA_MASK_DONE_MASK.
#define BM_HDMI_AHB_DMA_MASK_DONE_MASK      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_MASK_DONE_MASK.

//! @brief Get value of HDMI_AHB_DMA_MASK_DONE_MASK from a register value.
#define BG_HDMI_AHB_DMA_MASK_DONE_MASK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_MASK_DONE_MASK) >> BP_HDMI_AHB_DMA_MASK_DONE_MASK)

//! @brief Format value for bitfield HDMI_AHB_DMA_MASK_DONE_MASK.
#define BF_HDMI_AHB_DMA_MASK_DONE_MASK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_MASK_DONE_MASK) & BM_HDMI_AHB_DMA_MASK_DONE_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_MASK field to a new value.
#define BW_HDMI_AHB_DMA_MASK_DONE_MASK(v)   (HW_HDMI_AHB_DMA_MASK_WR((HW_HDMI_AHB_DMA_MASK_RD() & ~BM_HDMI_AHB_DMA_MASK_DONE_MASK) | BF_HDMI_AHB_DMA_MASK_DONE_MASK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_POL - Audio DMA Polarity Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_POL - Audio DMA Polarity Interrupt Register (RW)
 *
 * Reset value: 0x00
 *
 * Polarity for each of the interrupts present in the AHB audio DMA module. For usage information,
 * see ." Address Offset: 0x3615 Size: 8 bits per register Value after Reset: 0x00 Access:
 * Read/Write
 */
typedef union _hw_hdmi_ahb_dma_pol
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_pol_bitfields
    {
        unsigned char FIFO_EMPTY_POLARITY : 1; //!< [0] Audio FIFO empty interrupt mask.
        unsigned char FIFO_FULL_POLARITY : 1; //!< [1] Audio FIFO full interrupt mask.
        unsigned char FIFO_THRFIFOEMPTY_POLARITY : 1; //!< [2] Audio FIFO empty interrupt mask when audio FIFO has less than four samples.
        unsigned char RESERVED0 : 1; //!< [3] Reserved
        unsigned char ERROR_POLARITY : 1; //!< [4] Error interrupt mask.
        unsigned char LOSTOWNERSHIP_POLARITY : 1; //!< [5] Master lost ownership interrupt mask when in burst transfer.
        unsigned char RETRYSPLIT_POLARITY : 1; //!< [6] Retry/split interrupt mask.
        unsigned char DONE_POLARITY : 1; //!< [7] DMA end of operation interrupt mask.
    } B;
} hw_hdmi_ahb_dma_pol_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_POL register
 */
//@{
#define HW_HDMI_AHB_DMA_POL_ADDR      (REGS_HDMI_BASE + 0x3615)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_POL           (*(volatile hw_hdmi_ahb_dma_pol_t *) HW_HDMI_AHB_DMA_POL_ADDR)
#define HW_HDMI_AHB_DMA_POL_RD()      (HW_HDMI_AHB_DMA_POL.U)
#define HW_HDMI_AHB_DMA_POL_WR(v)     (HW_HDMI_AHB_DMA_POL.U = (v))
#define HW_HDMI_AHB_DMA_POL_SET(v)    (HW_HDMI_AHB_DMA_POL_WR(HW_HDMI_AHB_DMA_POL_RD() |  (v)))
#define HW_HDMI_AHB_DMA_POL_CLR(v)    (HW_HDMI_AHB_DMA_POL_WR(HW_HDMI_AHB_DMA_POL_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_POL_TOG(v)    (HW_HDMI_AHB_DMA_POL_WR(HW_HDMI_AHB_DMA_POL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_POL bitfields
 */

/*! @name Register HDMI_AHB_DMA_POL, field FIFO_EMPTY_POLARITY[0] (RW)
 *
 * Audio FIFO empty interrupt mask.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY      (0)      //!< Bit position for HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY.
#define BM_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY) >> BP_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY.
#define BF_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY) & BM_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_EMPTY_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY) | BF_HDMI_AHB_DMA_POL_FIFO_EMPTY_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field FIFO_FULL_POLARITY[1] (RW)
 *
 * Audio FIFO full interrupt mask.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY      (1)      //!< Bit position for HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY.
#define BM_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY) >> BP_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY.
#define BF_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY) & BM_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_FULL_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY) | BF_HDMI_AHB_DMA_POL_FIFO_FULL_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field FIFO_THRFIFOEMPTY_POLARITY[2] (RW)
 *
 * Audio FIFO empty interrupt mask when audio FIFO has less than four samples.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY      (2)      //!< Bit position for HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY.
#define BM_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY) >> BP_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY.
#define BF_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY) & BM_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIFO_THRFIFOEMPTY_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY) | BF_HDMI_AHB_DMA_POL_FIFO_THRFIFOEMPTY_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field ERROR_POLARITY[4] (RW)
 *
 * Error interrupt mask. Active when slave indicates error through the isresp[1:0].
 */
//@{
#define BP_HDMI_AHB_DMA_POL_ERROR_POLARITY      (4)      //!< Bit position for HDMI_AHB_DMA_POL_ERROR_POLARITY.
#define BM_HDMI_AHB_DMA_POL_ERROR_POLARITY      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_POL_ERROR_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_ERROR_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_ERROR_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_ERROR_POLARITY) >> BP_HDMI_AHB_DMA_POL_ERROR_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_ERROR_POLARITY.
#define BF_HDMI_AHB_DMA_POL_ERROR_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_ERROR_POLARITY) & BM_HDMI_AHB_DMA_POL_ERROR_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_ERROR_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_ERROR_POLARITY) | BF_HDMI_AHB_DMA_POL_ERROR_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field LOSTOWNERSHIP_POLARITY[5] (RW)
 *
 * Master lost ownership interrupt mask when in burst transfer. Active when AHB master loses BUS
 * ownership within the course of a burst transfer.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY      (5)      //!< Bit position for HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY.
#define BM_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY      (0x00000020)  //!< Bit mask for HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY) >> BP_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY.
#define BF_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY) & BM_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOSTOWNERSHIP_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY) | BF_HDMI_AHB_DMA_POL_LOSTOWNERSHIP_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field RETRYSPLIT_POLARITY[6] (RW)
 *
 * Retry/split interrupt mask. Active when AHB master receives a RETRY or SPLIT response from slave.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY      (6)      //!< Bit position for HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY.
#define BM_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY      (0x00000040)  //!< Bit mask for HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY) >> BP_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY.
#define BF_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY) & BM_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RETRYSPLIT_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY) | BF_HDMI_AHB_DMA_POL_RETRYSPLIT_POLARITY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_POL, field DONE_POLARITY[7] (RW)
 *
 * DMA end of operation interrupt mask. Active when DMA engine reaches final_addr[15:0] or when stop
 * DMA operation is activated.
 */
//@{
#define BP_HDMI_AHB_DMA_POL_DONE_POLARITY      (7)      //!< Bit position for HDMI_AHB_DMA_POL_DONE_POLARITY.
#define BM_HDMI_AHB_DMA_POL_DONE_POLARITY      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_POL_DONE_POLARITY.

//! @brief Get value of HDMI_AHB_DMA_POL_DONE_POLARITY from a register value.
#define BG_HDMI_AHB_DMA_POL_DONE_POLARITY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_POL_DONE_POLARITY) >> BP_HDMI_AHB_DMA_POL_DONE_POLARITY)

//! @brief Format value for bitfield HDMI_AHB_DMA_POL_DONE_POLARITY.
#define BF_HDMI_AHB_DMA_POL_DONE_POLARITY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_POL_DONE_POLARITY) & BM_HDMI_AHB_DMA_POL_DONE_POLARITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DONE_POLARITY field to a new value.
#define BW_HDMI_AHB_DMA_POL_DONE_POLARITY(v)   (HW_HDMI_AHB_DMA_POL_WR((HW_HDMI_AHB_DMA_POL_RD() & ~BM_HDMI_AHB_DMA_POL_DONE_POLARITY) | BF_HDMI_AHB_DMA_POL_DONE_POLARITY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_CONF1 - Audio DMA Channel Enable Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_CONF1 - Audio DMA Channel Enable Configuration Register 1 (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_conf1
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_conf1_bitfields
    {
        unsigned char CH_IN_EN : 1; //!< [0] Channel 0 is always enabled.
        unsigned char CH_IN_EN1 : 1; //!< [1] Channel 1 is always enabled.
        unsigned char CH_IN_EN2 : 1; //!< [2] Channel 2 enable bit
        unsigned char CH_IN_EN3 : 1; //!< [3] Channel 3 enable bit
        unsigned char CH_IN_EN4 : 1; //!< [4] Channel 4 enable bit
        unsigned char CH_IN_EN5 : 1; //!< [5] Channel 5 enable bit
        unsigned char CH_IN_EN6 : 1; //!< [6] Channel 6 enable bit
        unsigned char CH_IN_EN7 : 1; //!< [7] Channel 7 enable bit
    } B;
} hw_hdmi_ahb_dma_conf1_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_CONF1 register
 */
//@{
#define HW_HDMI_AHB_DMA_CONF1_ADDR      (REGS_HDMI_BASE + 0x3616)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_CONF1           (*(volatile hw_hdmi_ahb_dma_conf1_t *) HW_HDMI_AHB_DMA_CONF1_ADDR)
#define HW_HDMI_AHB_DMA_CONF1_RD()      (HW_HDMI_AHB_DMA_CONF1.U)
#define HW_HDMI_AHB_DMA_CONF1_WR(v)     (HW_HDMI_AHB_DMA_CONF1.U = (v))
#define HW_HDMI_AHB_DMA_CONF1_SET(v)    (HW_HDMI_AHB_DMA_CONF1_WR(HW_HDMI_AHB_DMA_CONF1_RD() |  (v)))
#define HW_HDMI_AHB_DMA_CONF1_CLR(v)    (HW_HDMI_AHB_DMA_CONF1_WR(HW_HDMI_AHB_DMA_CONF1_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_CONF1_TOG(v)    (HW_HDMI_AHB_DMA_CONF1_WR(HW_HDMI_AHB_DMA_CONF1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_CONF1 bitfields
 */

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN[0] (RW)
 *
 * Channel 0 is always enabled.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN      (0)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN1[1] (RW)
 *
 * Channel 1 is always enabled.
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN1      (1)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN1.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN1      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN1.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN1 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN1(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN1) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN1)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN1.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN1(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN1) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN1 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN1(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN1) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN1(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN2[2] (RW)
 *
 * Channel 2 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN2      (2)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN2.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN2      (0x00000004)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN2.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN2 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN2(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN2) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN2)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN2.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN2(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN2) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN2 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN2(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN2) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN2(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN3[3] (RW)
 *
 * Channel 3 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN3      (3)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN3.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN3      (0x00000008)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN3.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN3 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN3(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN3) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN3)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN3.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN3(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN3) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN3 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN3(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN3) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN3(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN4[4] (RW)
 *
 * Channel 4 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN4      (4)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN4.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN4      (0x00000010)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN4.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN4 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN4(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN4) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN4)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN4.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN4(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN4) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN4 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN4(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN4) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN4(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN5[5] (RW)
 *
 * Channel 5 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN5      (5)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN5.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN5      (0x00000020)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN5.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN5 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN5(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN5) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN5)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN5.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN5(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN5) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN5 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN5(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN5) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN5(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN6[6] (RW)
 *
 * Channel 6 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN6      (6)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN6.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN6      (0x00000040)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN6.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN6 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN6(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN6) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN6)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN6.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN6(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN6) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN6 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN6(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN6) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN6(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_CONF1, field CH_IN_EN7[7] (RW)
 *
 * Channel 7 enable bit
 *
 * Values:
 * - 0 - Channel disabled
 * - 1 - Channel enabled
 */
//@{
#define BP_HDMI_AHB_DMA_CONF1_CH_IN_EN7      (7)      //!< Bit position for HDMI_AHB_DMA_CONF1_CH_IN_EN7.
#define BM_HDMI_AHB_DMA_CONF1_CH_IN_EN7      (0x00000080)  //!< Bit mask for HDMI_AHB_DMA_CONF1_CH_IN_EN7.

//! @brief Get value of HDMI_AHB_DMA_CONF1_CH_IN_EN7 from a register value.
#define BG_HDMI_AHB_DMA_CONF1_CH_IN_EN7(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN7) >> BP_HDMI_AHB_DMA_CONF1_CH_IN_EN7)

//! @brief Format value for bitfield HDMI_AHB_DMA_CONF1_CH_IN_EN7.
#define BF_HDMI_AHB_DMA_CONF1_CH_IN_EN7(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_CONF1_CH_IN_EN7) & BM_HDMI_AHB_DMA_CONF1_CH_IN_EN7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CH_IN_EN7 field to a new value.
#define BW_HDMI_AHB_DMA_CONF1_CH_IN_EN7(v)   (HW_HDMI_AHB_DMA_CONF1_WR((HW_HDMI_AHB_DMA_CONF1_RD() & ~BM_HDMI_AHB_DMA_CONF1_CH_IN_EN7) | BF_HDMI_AHB_DMA_CONF1_CH_IN_EN7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BUFFSTAT - Audio DMA Buffer Interrupt Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BUFFSTAT - Audio DMA Buffer Interrupt Status Register (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_buffstat
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_buffstat_bitfields
    {
        unsigned char BUFF_EMPTY : 1; //!< [0] Buffer empty flag status
        unsigned char BUFF_FULL : 1; //!< [1] Buffer full flag status
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ahb_dma_buffstat_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BUFFSTAT register
 */
//@{
#define HW_HDMI_AHB_DMA_BUFFSTAT_ADDR      (REGS_HDMI_BASE + 0x3617)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BUFFSTAT           (*(volatile hw_hdmi_ahb_dma_buffstat_t *) HW_HDMI_AHB_DMA_BUFFSTAT_ADDR)
#define HW_HDMI_AHB_DMA_BUFFSTAT_RD()      (HW_HDMI_AHB_DMA_BUFFSTAT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BUFFSTAT bitfields
 */

/*! @name Register HDMI_AHB_DMA_BUFFSTAT, field BUFF_EMPTY[0] (RO)
 *
 * Buffer empty flag status
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY.
#define BM_HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY.

//! @brief Get value of HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY from a register value.
#define BG_HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY) >> BP_HDMI_AHB_DMA_BUFFSTAT_BUFF_EMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_BUFFSTAT, field BUFF_FULL[1] (RO)
 *
 * Buffer full flag status
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL      (1)      //!< Bit position for HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL.
#define BM_HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL.

//! @brief Get value of HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL from a register value.
#define BG_HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL) >> BP_HDMI_AHB_DMA_BUFFSTAT_BUFF_FULL)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BUFFINT - Audio DMA Buffer Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BUFFINT - Audio DMA Buffer Interrupt Register (RO)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_buffint
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_buffint_bitfields
    {
        unsigned char INT_BUFF_EMPTY : 1; //!< [0] Buffer empty flag interrupt
        unsigned char INT_BUFF_FULL : 1; //!< [1] Buffer full flag interrupt
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ahb_dma_buffint_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BUFFINT register
 */
//@{
#define HW_HDMI_AHB_DMA_BUFFINT_ADDR      (REGS_HDMI_BASE + 0x3618)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BUFFINT           (*(volatile hw_hdmi_ahb_dma_buffint_t *) HW_HDMI_AHB_DMA_BUFFINT_ADDR)
#define HW_HDMI_AHB_DMA_BUFFINT_RD()      (HW_HDMI_AHB_DMA_BUFFINT.U)
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BUFFINT bitfields
 */

/*! @name Register HDMI_AHB_DMA_BUFFINT, field INT_BUFF_EMPTY[0] (RO)
 *
 * Buffer empty flag interrupt
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY.
#define BM_HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY.

//! @brief Get value of HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY from a register value.
#define BG_HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY) >> BP_HDMI_AHB_DMA_BUFFINT_INT_BUFF_EMPTY)
//@}

/*! @name Register HDMI_AHB_DMA_BUFFINT, field INT_BUFF_FULL[1] (RO)
 *
 * Buffer full flag interrupt
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL      (1)      //!< Bit position for HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL.
#define BM_HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL.

//! @brief Get value of HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL from a register value.
#define BG_HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL) >> BP_HDMI_AHB_DMA_BUFFINT_INT_BUFF_FULL)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BUFFMASK - Audio DMA Buffer Mask Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BUFFMASK - Audio DMA Buffer Mask Interrupt Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_buffmask
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_buffmask_bitfields
    {
        unsigned char INT_BUFF_EMPTY : 1; //!< [0] Buffer empty flag mask
        unsigned char INT_BUFF_FULL : 1; //!< [1] Buffer full flag mask
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ahb_dma_buffmask_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BUFFMASK register
 */
//@{
#define HW_HDMI_AHB_DMA_BUFFMASK_ADDR      (REGS_HDMI_BASE + 0x3619)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BUFFMASK           (*(volatile hw_hdmi_ahb_dma_buffmask_t *) HW_HDMI_AHB_DMA_BUFFMASK_ADDR)
#define HW_HDMI_AHB_DMA_BUFFMASK_RD()      (HW_HDMI_AHB_DMA_BUFFMASK.U)
#define HW_HDMI_AHB_DMA_BUFFMASK_WR(v)     (HW_HDMI_AHB_DMA_BUFFMASK.U = (v))
#define HW_HDMI_AHB_DMA_BUFFMASK_SET(v)    (HW_HDMI_AHB_DMA_BUFFMASK_WR(HW_HDMI_AHB_DMA_BUFFMASK_RD() |  (v)))
#define HW_HDMI_AHB_DMA_BUFFMASK_CLR(v)    (HW_HDMI_AHB_DMA_BUFFMASK_WR(HW_HDMI_AHB_DMA_BUFFMASK_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_BUFFMASK_TOG(v)    (HW_HDMI_AHB_DMA_BUFFMASK_WR(HW_HDMI_AHB_DMA_BUFFMASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BUFFMASK bitfields
 */

/*! @name Register HDMI_AHB_DMA_BUFFMASK, field INT_BUFF_EMPTY[0] (RW)
 *
 * Buffer empty flag mask
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY.
#define BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY.

//! @brief Get value of HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY from a register value.
#define BG_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY) >> BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY)

//! @brief Format value for bitfield HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY.
#define BF_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY) & BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT_BUFF_EMPTY field to a new value.
#define BW_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY(v)   (HW_HDMI_AHB_DMA_BUFFMASK_WR((HW_HDMI_AHB_DMA_BUFFMASK_RD() & ~BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY) | BF_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_EMPTY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_BUFFMASK, field INT_BUFF_FULL[1] (RW)
 *
 * Buffer full flag mask
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL      (1)      //!< Bit position for HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL.
#define BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL.

//! @brief Get value of HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL from a register value.
#define BG_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL) >> BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL)

//! @brief Format value for bitfield HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL.
#define BF_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL) & BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT_BUFF_FULL field to a new value.
#define BW_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL(v)   (HW_HDMI_AHB_DMA_BUFFMASK_WR((HW_HDMI_AHB_DMA_BUFFMASK_RD() & ~BM_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL) | BF_HDMI_AHB_DMA_BUFFMASK_INT_BUFF_FULL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_AHB_DMA_BUFFPOL - Audio DMA Buffer Polarity Interrupt Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_AHB_DMA_BUFFPOL - Audio DMA Buffer Polarity Interrupt Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_ahb_dma_buffpol
{
    reg8_t U;
    struct _hw_hdmi_ahb_dma_buffpol_bitfields
    {
        unsigned char INT_BUFF_EMPTY : 1; //!< [0] Buffer empty flag polarity
        unsigned char INT_BUFF_FULL : 1; //!< [1] Buffer full flag polarity
        unsigned char RESERVED0 : 6; //!< [7:2] Reserved
    } B;
} hw_hdmi_ahb_dma_buffpol_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_AHB_DMA_BUFFPOL register
 */
//@{
#define HW_HDMI_AHB_DMA_BUFFPOL_ADDR      (REGS_HDMI_BASE + 0x361a)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_AHB_DMA_BUFFPOL           (*(volatile hw_hdmi_ahb_dma_buffpol_t *) HW_HDMI_AHB_DMA_BUFFPOL_ADDR)
#define HW_HDMI_AHB_DMA_BUFFPOL_RD()      (HW_HDMI_AHB_DMA_BUFFPOL.U)
#define HW_HDMI_AHB_DMA_BUFFPOL_WR(v)     (HW_HDMI_AHB_DMA_BUFFPOL.U = (v))
#define HW_HDMI_AHB_DMA_BUFFPOL_SET(v)    (HW_HDMI_AHB_DMA_BUFFPOL_WR(HW_HDMI_AHB_DMA_BUFFPOL_RD() |  (v)))
#define HW_HDMI_AHB_DMA_BUFFPOL_CLR(v)    (HW_HDMI_AHB_DMA_BUFFPOL_WR(HW_HDMI_AHB_DMA_BUFFPOL_RD() & ~(v)))
#define HW_HDMI_AHB_DMA_BUFFPOL_TOG(v)    (HW_HDMI_AHB_DMA_BUFFPOL_WR(HW_HDMI_AHB_DMA_BUFFPOL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_AHB_DMA_BUFFPOL bitfields
 */

/*! @name Register HDMI_AHB_DMA_BUFFPOL, field INT_BUFF_EMPTY[0] (RW)
 *
 * Buffer empty flag polarity
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY      (0)      //!< Bit position for HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY.
#define BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY      (0x00000001)  //!< Bit mask for HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY.

//! @brief Get value of HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY from a register value.
#define BG_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY) >> BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY)

//! @brief Format value for bitfield HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY.
#define BF_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY) & BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT_BUFF_EMPTY field to a new value.
#define BW_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY(v)   (HW_HDMI_AHB_DMA_BUFFPOL_WR((HW_HDMI_AHB_DMA_BUFFPOL_RD() & ~BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY) | BF_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_EMPTY(v)))
#endif
//@}

/*! @name Register HDMI_AHB_DMA_BUFFPOL, field INT_BUFF_FULL[1] (RW)
 *
 * Buffer full flag polarity
 */
//@{
#define BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL      (1)      //!< Bit position for HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL.
#define BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL      (0x00000002)  //!< Bit mask for HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL.

//! @brief Get value of HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL from a register value.
#define BG_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL) >> BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL)

//! @brief Format value for bitfield HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL.
#define BF_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL) & BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT_BUFF_FULL field to a new value.
#define BW_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL(v)   (HW_HDMI_AHB_DMA_BUFFPOL_WR((HW_HDMI_AHB_DMA_BUFFPOL_RD() & ~BM_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL) | BF_HDMI_AHB_DMA_BUFFPOL_INT_BUFF_FULL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_CLKDIS - Main Controller Synchronous Clock Domain Disable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_CLKDIS - Main Controller Synchronous Clock Domain Disable Register (RW)
 *
 * Reset value: 0x00
 *
 * Main controller synchronous disable control per clock domain. Upon release of synchronous disable
 * the corresponding sw reset NRZ request signal, to that domain, is toggled asking to the output
 * for a synchronized active low reset to be generated to that domain.
 */
typedef union _hw_hdmi_mc_clkdis
{
    reg8_t U;
    struct _hw_hdmi_mc_clkdis_bitfields
    {
        unsigned char PIXELCLK_DISABLE : 1; //!< [0] Pixel clock synchronous disable signal.
        unsigned char TMDSCLK_DISABLE : 1; //!< [1] TMDS clock synchronous disable signal.
        unsigned char PREPCLK_DISABLE : 1; //!< [2] Pixel Repetition clock synchronous disable signal.
        unsigned char AUDCLK_DISABLE : 1; //!< [3] Audio Sampler clock synchronous disable signal.
        unsigned char CSCCLK_DISABLE : 1; //!< [4] Color Space Converter clock synchronous disable signal.
        unsigned char CECCLK_DISABLE : 1; //!< [5] CEC Engine clock synchronous disable signal.
        unsigned char HDCPCLK_DISABLE : 1; //!< [6] HDCP clock synchronous disable signal.
        unsigned char RESERVED0 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_mc_clkdis_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_CLKDIS register
 */
//@{
#define HW_HDMI_MC_CLKDIS_ADDR      (REGS_HDMI_BASE + 0x4001)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_CLKDIS           (*(volatile hw_hdmi_mc_clkdis_t *) HW_HDMI_MC_CLKDIS_ADDR)
#define HW_HDMI_MC_CLKDIS_RD()      (HW_HDMI_MC_CLKDIS.U)
#define HW_HDMI_MC_CLKDIS_WR(v)     (HW_HDMI_MC_CLKDIS.U = (v))
#define HW_HDMI_MC_CLKDIS_SET(v)    (HW_HDMI_MC_CLKDIS_WR(HW_HDMI_MC_CLKDIS_RD() |  (v)))
#define HW_HDMI_MC_CLKDIS_CLR(v)    (HW_HDMI_MC_CLKDIS_WR(HW_HDMI_MC_CLKDIS_RD() & ~(v)))
#define HW_HDMI_MC_CLKDIS_TOG(v)    (HW_HDMI_MC_CLKDIS_WR(HW_HDMI_MC_CLKDIS_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_CLKDIS bitfields
 */

/*! @name Register HDMI_MC_CLKDIS, field PIXELCLK_DISABLE[0] (RW)
 *
 * Pixel clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_PIXELCLK_DISABLE      (0)      //!< Bit position for HDMI_MC_CLKDIS_PIXELCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_PIXELCLK_DISABLE      (0x00000001)  //!< Bit mask for HDMI_MC_CLKDIS_PIXELCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_PIXELCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_PIXELCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_PIXELCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_PIXELCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_PIXELCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_PIXELCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_PIXELCLK_DISABLE) & BM_HDMI_MC_CLKDIS_PIXELCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIXELCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_PIXELCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_PIXELCLK_DISABLE) | BF_HDMI_MC_CLKDIS_PIXELCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field TMDSCLK_DISABLE[1] (RW)
 *
 * TMDS clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_TMDSCLK_DISABLE      (1)      //!< Bit position for HDMI_MC_CLKDIS_TMDSCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_TMDSCLK_DISABLE      (0x00000002)  //!< Bit mask for HDMI_MC_CLKDIS_TMDSCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_TMDSCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_TMDSCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_TMDSCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_TMDSCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_TMDSCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_TMDSCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_TMDSCLK_DISABLE) & BM_HDMI_MC_CLKDIS_TMDSCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TMDSCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_TMDSCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_TMDSCLK_DISABLE) | BF_HDMI_MC_CLKDIS_TMDSCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field PREPCLK_DISABLE[2] (RW)
 *
 * Pixel Repetition clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_PREPCLK_DISABLE      (2)      //!< Bit position for HDMI_MC_CLKDIS_PREPCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_PREPCLK_DISABLE      (0x00000004)  //!< Bit mask for HDMI_MC_CLKDIS_PREPCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_PREPCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_PREPCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_PREPCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_PREPCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_PREPCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_PREPCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_PREPCLK_DISABLE) & BM_HDMI_MC_CLKDIS_PREPCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PREPCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_PREPCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_PREPCLK_DISABLE) | BF_HDMI_MC_CLKDIS_PREPCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field AUDCLK_DISABLE[3] (RW)
 *
 * Audio Sampler clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_AUDCLK_DISABLE      (3)      //!< Bit position for HDMI_MC_CLKDIS_AUDCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_AUDCLK_DISABLE      (0x00000008)  //!< Bit mask for HDMI_MC_CLKDIS_AUDCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_AUDCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_AUDCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_AUDCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_AUDCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_AUDCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_AUDCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_AUDCLK_DISABLE) & BM_HDMI_MC_CLKDIS_AUDCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUDCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_AUDCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_AUDCLK_DISABLE) | BF_HDMI_MC_CLKDIS_AUDCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field CSCCLK_DISABLE[4] (RW)
 *
 * Color Space Converter clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_CSCCLK_DISABLE      (4)      //!< Bit position for HDMI_MC_CLKDIS_CSCCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_CSCCLK_DISABLE      (0x00000010)  //!< Bit mask for HDMI_MC_CLKDIS_CSCCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_CSCCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_CSCCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_CSCCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_CSCCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_CSCCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_CSCCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_CSCCLK_DISABLE) & BM_HDMI_MC_CLKDIS_CSCCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSCCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_CSCCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_CSCCLK_DISABLE) | BF_HDMI_MC_CLKDIS_CSCCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field CECCLK_DISABLE[5] (RW)
 *
 * CEC Engine clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_CLKDIS_CECCLK_DISABLE      (5)      //!< Bit position for HDMI_MC_CLKDIS_CECCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_CECCLK_DISABLE      (0x00000020)  //!< Bit mask for HDMI_MC_CLKDIS_CECCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_CECCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_CECCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_CECCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_CECCLK_DISABLE)

//! @brief Format value for bitfield HDMI_MC_CLKDIS_CECCLK_DISABLE.
#define BF_HDMI_MC_CLKDIS_CECCLK_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_CLKDIS_CECCLK_DISABLE) & BM_HDMI_MC_CLKDIS_CECCLK_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CECCLK_DISABLE field to a new value.
#define BW_HDMI_MC_CLKDIS_CECCLK_DISABLE(v)   (HW_HDMI_MC_CLKDIS_WR((HW_HDMI_MC_CLKDIS_RD() & ~BM_HDMI_MC_CLKDIS_CECCLK_DISABLE) | BF_HDMI_MC_CLKDIS_CECCLK_DISABLE(v)))
#endif
//@}

/*! @name Register HDMI_MC_CLKDIS, field HDCPCLK_DISABLE[6] (RU)
 *
 * HDCP clock synchronous disable signal. When active (1b) simultaneously bypasses HDCP. Reserved
 */
//@{
#define BP_HDMI_MC_CLKDIS_HDCPCLK_DISABLE      (6)      //!< Bit position for HDMI_MC_CLKDIS_HDCPCLK_DISABLE.
#define BM_HDMI_MC_CLKDIS_HDCPCLK_DISABLE      (0x00000040)  //!< Bit mask for HDMI_MC_CLKDIS_HDCPCLK_DISABLE.

//! @brief Get value of HDMI_MC_CLKDIS_HDCPCLK_DISABLE from a register value.
#define BG_HDMI_MC_CLKDIS_HDCPCLK_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_CLKDIS_HDCPCLK_DISABLE) >> BP_HDMI_MC_CLKDIS_HDCPCLK_DISABLE)
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_SWRSTZREQ - Main Controller Software Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_SWRSTZREQ - Main Controller Software Reset Register (RW)
 *
 * Reset value: 0xff
 *
 * Main controller software reset request per clock domain. Writing zero to a bit of this register
 * results in an NRZ signal toggle at sfrclk rate to an output signal that indicates a software
 * reset request. This toggle must be used to generate a synchronized reset to de corresponding
 * domain, with at least 1 clock cycle. Register defaults back to 0xFF.
 */
typedef union _hw_hdmi_mc_swrstzreq
{
    reg8_t U;
    struct _hw_hdmi_mc_swrstzreq_bitfields
    {
        unsigned char PIXELSWRST_REQ : 1; //!< [0] Pixel software reset request.
        unsigned char TMDSSWRST_REQ : 1; //!< [1] TMDS software reset request.
        unsigned char PREPSWRST_REQ : 1; //!< [2] Pixel Repetition clock synchronous disable signal.
        unsigned char RESERVED0 : 3; //!< [5:3] Reserved
        unsigned char CECSWRST_REQ : 1; //!< [6] CEC software reset request.
        unsigned char RESERVED1 : 1; //!< [7] Reserved
    } B;
} hw_hdmi_mc_swrstzreq_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_SWRSTZREQ register
 */
//@{
#define HW_HDMI_MC_SWRSTZREQ_ADDR      (REGS_HDMI_BASE + 0x4002)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_SWRSTZREQ           (*(volatile hw_hdmi_mc_swrstzreq_t *) HW_HDMI_MC_SWRSTZREQ_ADDR)
#define HW_HDMI_MC_SWRSTZREQ_RD()      (HW_HDMI_MC_SWRSTZREQ.U)
#define HW_HDMI_MC_SWRSTZREQ_WR(v)     (HW_HDMI_MC_SWRSTZREQ.U = (v))
#define HW_HDMI_MC_SWRSTZREQ_SET(v)    (HW_HDMI_MC_SWRSTZREQ_WR(HW_HDMI_MC_SWRSTZREQ_RD() |  (v)))
#define HW_HDMI_MC_SWRSTZREQ_CLR(v)    (HW_HDMI_MC_SWRSTZREQ_WR(HW_HDMI_MC_SWRSTZREQ_RD() & ~(v)))
#define HW_HDMI_MC_SWRSTZREQ_TOG(v)    (HW_HDMI_MC_SWRSTZREQ_WR(HW_HDMI_MC_SWRSTZREQ_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_SWRSTZREQ bitfields
 */

/*! @name Register HDMI_MC_SWRSTZREQ, field PIXELSWRST_REQ[0] (RW)
 *
 * Pixel software reset request. Defaults back to 1b after reset request.
 */
//@{
#define BP_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ      (0)      //!< Bit position for HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ.
#define BM_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ      (0x00000001)  //!< Bit mask for HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ.

//! @brief Get value of HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ from a register value.
#define BG_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ) >> BP_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ)

//! @brief Format value for bitfield HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ.
#define BF_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ) & BM_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIXELSWRST_REQ field to a new value.
#define BW_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ(v)   (HW_HDMI_MC_SWRSTZREQ_WR((HW_HDMI_MC_SWRSTZREQ_RD() & ~BM_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ) | BF_HDMI_MC_SWRSTZREQ_PIXELSWRST_REQ(v)))
#endif
//@}

/*! @name Register HDMI_MC_SWRSTZREQ, field TMDSSWRST_REQ[1] (RW)
 *
 * TMDS software reset request. Defaults back to 1b after reset request.
 */
//@{
#define BP_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ      (1)      //!< Bit position for HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ.
#define BM_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ      (0x00000002)  //!< Bit mask for HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ.

//! @brief Get value of HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ from a register value.
#define BG_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ) >> BP_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ)

//! @brief Format value for bitfield HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ.
#define BF_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ) & BM_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TMDSSWRST_REQ field to a new value.
#define BW_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ(v)   (HW_HDMI_MC_SWRSTZREQ_WR((HW_HDMI_MC_SWRSTZREQ_RD() & ~BM_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ) | BF_HDMI_MC_SWRSTZREQ_TMDSSWRST_REQ(v)))
#endif
//@}

/*! @name Register HDMI_MC_SWRSTZREQ, field PREPSWRST_REQ[2] (RW)
 *
 * Pixel Repetition clock synchronous disable signal.
 */
//@{
#define BP_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ      (2)      //!< Bit position for HDMI_MC_SWRSTZREQ_PREPSWRST_REQ.
#define BM_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ      (0x00000004)  //!< Bit mask for HDMI_MC_SWRSTZREQ_PREPSWRST_REQ.

//! @brief Get value of HDMI_MC_SWRSTZREQ_PREPSWRST_REQ from a register value.
#define BG_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ) >> BP_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ)

//! @brief Format value for bitfield HDMI_MC_SWRSTZREQ_PREPSWRST_REQ.
#define BF_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ) & BM_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PREPSWRST_REQ field to a new value.
#define BW_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ(v)   (HW_HDMI_MC_SWRSTZREQ_WR((HW_HDMI_MC_SWRSTZREQ_RD() & ~BM_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ) | BF_HDMI_MC_SWRSTZREQ_PREPSWRST_REQ(v)))
#endif
//@}

/*! @name Register HDMI_MC_SWRSTZREQ, field CECSWRST_REQ[6] (RW)
 *
 * CEC software reset request. Defaults back to 1b after reset request.
 */
//@{
#define BP_HDMI_MC_SWRSTZREQ_CECSWRST_REQ      (6)      //!< Bit position for HDMI_MC_SWRSTZREQ_CECSWRST_REQ.
#define BM_HDMI_MC_SWRSTZREQ_CECSWRST_REQ      (0x00000040)  //!< Bit mask for HDMI_MC_SWRSTZREQ_CECSWRST_REQ.

//! @brief Get value of HDMI_MC_SWRSTZREQ_CECSWRST_REQ from a register value.
#define BG_HDMI_MC_SWRSTZREQ_CECSWRST_REQ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_SWRSTZREQ_CECSWRST_REQ) >> BP_HDMI_MC_SWRSTZREQ_CECSWRST_REQ)

//! @brief Format value for bitfield HDMI_MC_SWRSTZREQ_CECSWRST_REQ.
#define BF_HDMI_MC_SWRSTZREQ_CECSWRST_REQ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_SWRSTZREQ_CECSWRST_REQ) & BM_HDMI_MC_SWRSTZREQ_CECSWRST_REQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CECSWRST_REQ field to a new value.
#define BW_HDMI_MC_SWRSTZREQ_CECSWRST_REQ(v)   (HW_HDMI_MC_SWRSTZREQ_WR((HW_HDMI_MC_SWRSTZREQ_RD() & ~BM_HDMI_MC_SWRSTZREQ_CECSWRST_REQ) | BF_HDMI_MC_SWRSTZREQ_CECSWRST_REQ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_FLOWCTRL - Main Controller Feed Through Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_FLOWCTRL - Main Controller Feed Through Control Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_mc_flowctrl
{
    reg8_t U;
    struct _hw_hdmi_mc_flowctrl_bitfields
    {
        unsigned char FEED_THROUGH_OFF : 1; //!< [0] Video path Feed Through enable bit:
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_mc_flowctrl_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_FLOWCTRL register
 */
//@{
#define HW_HDMI_MC_FLOWCTRL_ADDR      (REGS_HDMI_BASE + 0x4004)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_FLOWCTRL           (*(volatile hw_hdmi_mc_flowctrl_t *) HW_HDMI_MC_FLOWCTRL_ADDR)
#define HW_HDMI_MC_FLOWCTRL_RD()      (HW_HDMI_MC_FLOWCTRL.U)
#define HW_HDMI_MC_FLOWCTRL_WR(v)     (HW_HDMI_MC_FLOWCTRL.U = (v))
#define HW_HDMI_MC_FLOWCTRL_SET(v)    (HW_HDMI_MC_FLOWCTRL_WR(HW_HDMI_MC_FLOWCTRL_RD() |  (v)))
#define HW_HDMI_MC_FLOWCTRL_CLR(v)    (HW_HDMI_MC_FLOWCTRL_WR(HW_HDMI_MC_FLOWCTRL_RD() & ~(v)))
#define HW_HDMI_MC_FLOWCTRL_TOG(v)    (HW_HDMI_MC_FLOWCTRL_WR(HW_HDMI_MC_FLOWCTRL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_FLOWCTRL bitfields
 */

/*! @name Register HDMI_MC_FLOWCTRL, field FEED_THROUGH_OFF[0] (RW)
 *
 * Video path Feed Through enable bit:
 *
 * Values:
 * - 0 - Color Space Converter is bypassed (not in the video data path).
 * - 1 - Color Space Converter is in the video data path.
 */
//@{
#define BP_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF      (0)      //!< Bit position for HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF.
#define BM_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF      (0x00000001)  //!< Bit mask for HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF.

//! @brief Get value of HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF from a register value.
#define BG_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF) >> BP_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF)

//! @brief Format value for bitfield HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF.
#define BF_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF) & BM_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FEED_THROUGH_OFF field to a new value.
#define BW_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF(v)   (HW_HDMI_MC_FLOWCTRL_WR((HW_HDMI_MC_FLOWCTRL_RD() & ~BM_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF) | BF_HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_PHYRSTZ - Main Controller PHY Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_PHYRSTZ - Main Controller PHY Reset Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_mc_phyrstz
{
    reg8_t U;
    struct _hw_hdmi_mc_phyrstz_bitfields
    {
        unsigned char PHYRSTZ : 1; //!< [0] HDMI Source PHY active low reset control.
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_mc_phyrstz_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_PHYRSTZ register
 */
//@{
#define HW_HDMI_MC_PHYRSTZ_ADDR      (REGS_HDMI_BASE + 0x4005)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_PHYRSTZ           (*(volatile hw_hdmi_mc_phyrstz_t *) HW_HDMI_MC_PHYRSTZ_ADDR)
#define HW_HDMI_MC_PHYRSTZ_RD()      (HW_HDMI_MC_PHYRSTZ.U)
#define HW_HDMI_MC_PHYRSTZ_WR(v)     (HW_HDMI_MC_PHYRSTZ.U = (v))
#define HW_HDMI_MC_PHYRSTZ_SET(v)    (HW_HDMI_MC_PHYRSTZ_WR(HW_HDMI_MC_PHYRSTZ_RD() |  (v)))
#define HW_HDMI_MC_PHYRSTZ_CLR(v)    (HW_HDMI_MC_PHYRSTZ_WR(HW_HDMI_MC_PHYRSTZ_RD() & ~(v)))
#define HW_HDMI_MC_PHYRSTZ_TOG(v)    (HW_HDMI_MC_PHYRSTZ_WR(HW_HDMI_MC_PHYRSTZ_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_PHYRSTZ bitfields
 */

/*! @name Register HDMI_MC_PHYRSTZ, field PHYRSTZ[0] (RW)
 *
 * HDMI Source PHY active low reset control.
 */
//@{
#define BP_HDMI_MC_PHYRSTZ_PHYRSTZ      (0)      //!< Bit position for HDMI_MC_PHYRSTZ_PHYRSTZ.
#define BM_HDMI_MC_PHYRSTZ_PHYRSTZ      (0x00000001)  //!< Bit mask for HDMI_MC_PHYRSTZ_PHYRSTZ.

//! @brief Get value of HDMI_MC_PHYRSTZ_PHYRSTZ from a register value.
#define BG_HDMI_MC_PHYRSTZ_PHYRSTZ(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_PHYRSTZ_PHYRSTZ) >> BP_HDMI_MC_PHYRSTZ_PHYRSTZ)

//! @brief Format value for bitfield HDMI_MC_PHYRSTZ_PHYRSTZ.
#define BF_HDMI_MC_PHYRSTZ_PHYRSTZ(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_PHYRSTZ_PHYRSTZ) & BM_HDMI_MC_PHYRSTZ_PHYRSTZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PHYRSTZ field to a new value.
#define BW_HDMI_MC_PHYRSTZ_PHYRSTZ(v)   (HW_HDMI_MC_PHYRSTZ_WR((HW_HDMI_MC_PHYRSTZ_RD() & ~BM_HDMI_MC_PHYRSTZ_PHYRSTZ) | BF_HDMI_MC_PHYRSTZ_PHYRSTZ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_LOCKONCLOCK - Main Controller Clock Present Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_LOCKONCLOCK - Main Controller Clock Present Register (W1C)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_mc_lockonclock
{
    reg8_t U;
    struct _hw_hdmi_mc_lockonclock_bitfields
    {
        unsigned char CECCLK : 1; //!< [0] CEC clock status.
        unsigned char RESERVED0 : 3; //!< [3:1] Reserved.
        unsigned char PREPCLK : 1; //!< [4] Pixel repetition clock status.
        unsigned char TCLKTCLK : 1; //!< [5] TMDS clock status.
        unsigned char PCLK : 1; //!< [6] Pixel clock status.
        unsigned char RESERVED1 : 1; //!< [7] Reserved.
    } B;
} hw_hdmi_mc_lockonclock_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_LOCKONCLOCK register
 */
//@{
#define HW_HDMI_MC_LOCKONCLOCK_ADDR      (REGS_HDMI_BASE + 0x4006)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_LOCKONCLOCK           (*(volatile hw_hdmi_mc_lockonclock_t *) HW_HDMI_MC_LOCKONCLOCK_ADDR)
#define HW_HDMI_MC_LOCKONCLOCK_RD()      (HW_HDMI_MC_LOCKONCLOCK.U)
#define HW_HDMI_MC_LOCKONCLOCK_WR(v)     (HW_HDMI_MC_LOCKONCLOCK.U = (v))
#define HW_HDMI_MC_LOCKONCLOCK_SET(v)    (HW_HDMI_MC_LOCKONCLOCK_WR(HW_HDMI_MC_LOCKONCLOCK_RD() |  (v)))
#define HW_HDMI_MC_LOCKONCLOCK_CLR(v)    (HW_HDMI_MC_LOCKONCLOCK_WR(HW_HDMI_MC_LOCKONCLOCK_RD() & ~(v)))
#define HW_HDMI_MC_LOCKONCLOCK_TOG(v)    (HW_HDMI_MC_LOCKONCLOCK_WR(HW_HDMI_MC_LOCKONCLOCK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_LOCKONCLOCK bitfields
 */

/*! @name Register HDMI_MC_LOCKONCLOCK, field CECCLK[0] (W1C)
 *
 * CEC clock status. Indicates that the clock is present in the system. Cleared by WR 1 to this
 * position.
 */
//@{
#define BP_HDMI_MC_LOCKONCLOCK_CECCLK      (0)      //!< Bit position for HDMI_MC_LOCKONCLOCK_CECCLK.
#define BM_HDMI_MC_LOCKONCLOCK_CECCLK      (0x00000001)  //!< Bit mask for HDMI_MC_LOCKONCLOCK_CECCLK.

//! @brief Get value of HDMI_MC_LOCKONCLOCK_CECCLK from a register value.
#define BG_HDMI_MC_LOCKONCLOCK_CECCLK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_LOCKONCLOCK_CECCLK) >> BP_HDMI_MC_LOCKONCLOCK_CECCLK)

//! @brief Format value for bitfield HDMI_MC_LOCKONCLOCK_CECCLK.
#define BF_HDMI_MC_LOCKONCLOCK_CECCLK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_LOCKONCLOCK_CECCLK) & BM_HDMI_MC_LOCKONCLOCK_CECCLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CECCLK field to a new value.
#define BW_HDMI_MC_LOCKONCLOCK_CECCLK(v)   (HW_HDMI_MC_LOCKONCLOCK_WR((HW_HDMI_MC_LOCKONCLOCK_RD() & ~BM_HDMI_MC_LOCKONCLOCK_CECCLK) | BF_HDMI_MC_LOCKONCLOCK_CECCLK(v)))
#endif
//@}

/*! @name Register HDMI_MC_LOCKONCLOCK, field PREPCLK[4] (W1C)
 *
 * Pixel repetition clock status. Indicates that the clock is present in the system. Cleared by WR 1
 * to this position.
 */
//@{
#define BP_HDMI_MC_LOCKONCLOCK_PREPCLK      (4)      //!< Bit position for HDMI_MC_LOCKONCLOCK_PREPCLK.
#define BM_HDMI_MC_LOCKONCLOCK_PREPCLK      (0x00000010)  //!< Bit mask for HDMI_MC_LOCKONCLOCK_PREPCLK.

//! @brief Get value of HDMI_MC_LOCKONCLOCK_PREPCLK from a register value.
#define BG_HDMI_MC_LOCKONCLOCK_PREPCLK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_LOCKONCLOCK_PREPCLK) >> BP_HDMI_MC_LOCKONCLOCK_PREPCLK)

//! @brief Format value for bitfield HDMI_MC_LOCKONCLOCK_PREPCLK.
#define BF_HDMI_MC_LOCKONCLOCK_PREPCLK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_LOCKONCLOCK_PREPCLK) & BM_HDMI_MC_LOCKONCLOCK_PREPCLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PREPCLK field to a new value.
#define BW_HDMI_MC_LOCKONCLOCK_PREPCLK(v)   (HW_HDMI_MC_LOCKONCLOCK_WR((HW_HDMI_MC_LOCKONCLOCK_RD() & ~BM_HDMI_MC_LOCKONCLOCK_PREPCLK) | BF_HDMI_MC_LOCKONCLOCK_PREPCLK(v)))
#endif
//@}

/*! @name Register HDMI_MC_LOCKONCLOCK, field TCLKTCLK[5] (W1C)
 *
 * TMDS clock status. Indicates that the clock is present in the system. Cleared by WR 1 to this
 * position
 */
//@{
#define BP_HDMI_MC_LOCKONCLOCK_TCLKTCLK      (5)      //!< Bit position for HDMI_MC_LOCKONCLOCK_TCLKTCLK.
#define BM_HDMI_MC_LOCKONCLOCK_TCLKTCLK      (0x00000020)  //!< Bit mask for HDMI_MC_LOCKONCLOCK_TCLKTCLK.

//! @brief Get value of HDMI_MC_LOCKONCLOCK_TCLKTCLK from a register value.
#define BG_HDMI_MC_LOCKONCLOCK_TCLKTCLK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_LOCKONCLOCK_TCLKTCLK) >> BP_HDMI_MC_LOCKONCLOCK_TCLKTCLK)

//! @brief Format value for bitfield HDMI_MC_LOCKONCLOCK_TCLKTCLK.
#define BF_HDMI_MC_LOCKONCLOCK_TCLKTCLK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_LOCKONCLOCK_TCLKTCLK) & BM_HDMI_MC_LOCKONCLOCK_TCLKTCLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCLKTCLK field to a new value.
#define BW_HDMI_MC_LOCKONCLOCK_TCLKTCLK(v)   (HW_HDMI_MC_LOCKONCLOCK_WR((HW_HDMI_MC_LOCKONCLOCK_RD() & ~BM_HDMI_MC_LOCKONCLOCK_TCLKTCLK) | BF_HDMI_MC_LOCKONCLOCK_TCLKTCLK(v)))
#endif
//@}

/*! @name Register HDMI_MC_LOCKONCLOCK, field PCLK[6] (W1C)
 *
 * Pixel clock status. Indicates that the clock is present in the system. Cleared by WR 1 to this
 * position.
 */
//@{
#define BP_HDMI_MC_LOCKONCLOCK_PCLK      (6)      //!< Bit position for HDMI_MC_LOCKONCLOCK_PCLK.
#define BM_HDMI_MC_LOCKONCLOCK_PCLK      (0x00000040)  //!< Bit mask for HDMI_MC_LOCKONCLOCK_PCLK.

//! @brief Get value of HDMI_MC_LOCKONCLOCK_PCLK from a register value.
#define BG_HDMI_MC_LOCKONCLOCK_PCLK(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_LOCKONCLOCK_PCLK) >> BP_HDMI_MC_LOCKONCLOCK_PCLK)

//! @brief Format value for bitfield HDMI_MC_LOCKONCLOCK_PCLK.
#define BF_HDMI_MC_LOCKONCLOCK_PCLK(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_LOCKONCLOCK_PCLK) & BM_HDMI_MC_LOCKONCLOCK_PCLK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PCLK field to a new value.
#define BW_HDMI_MC_LOCKONCLOCK_PCLK(v)   (HW_HDMI_MC_LOCKONCLOCK_WR((HW_HDMI_MC_LOCKONCLOCK_RD() & ~BM_HDMI_MC_LOCKONCLOCK_PCLK) | BF_HDMI_MC_LOCKONCLOCK_PCLK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_MC_HEACPHY_RST - Main Controller HEAC PHY Reset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_MC_HEACPHY_RST - Main Controller HEAC PHY Reset Register (RW)
 *
 * Reset value: 0x00
 */
typedef union _hw_hdmi_mc_heacphy_rst
{
    reg8_t U;
    struct _hw_hdmi_mc_heacphy_rst_bitfields
    {
        unsigned char HEACPHYRST : 1; //!< [0] HEAC PHY reset (active high)
        unsigned char RESERVED0 : 7; //!< [7:1] Reserved
    } B;
} hw_hdmi_mc_heacphy_rst_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_MC_HEACPHY_RST register
 */
//@{
#define HW_HDMI_MC_HEACPHY_RST_ADDR      (REGS_HDMI_BASE + 0x4007)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_MC_HEACPHY_RST           (*(volatile hw_hdmi_mc_heacphy_rst_t *) HW_HDMI_MC_HEACPHY_RST_ADDR)
#define HW_HDMI_MC_HEACPHY_RST_RD()      (HW_HDMI_MC_HEACPHY_RST.U)
#define HW_HDMI_MC_HEACPHY_RST_WR(v)     (HW_HDMI_MC_HEACPHY_RST.U = (v))
#define HW_HDMI_MC_HEACPHY_RST_SET(v)    (HW_HDMI_MC_HEACPHY_RST_WR(HW_HDMI_MC_HEACPHY_RST_RD() |  (v)))
#define HW_HDMI_MC_HEACPHY_RST_CLR(v)    (HW_HDMI_MC_HEACPHY_RST_WR(HW_HDMI_MC_HEACPHY_RST_RD() & ~(v)))
#define HW_HDMI_MC_HEACPHY_RST_TOG(v)    (HW_HDMI_MC_HEACPHY_RST_WR(HW_HDMI_MC_HEACPHY_RST_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_MC_HEACPHY_RST bitfields
 */

/*! @name Register HDMI_MC_HEACPHY_RST, field HEACPHYRST[0] (RW)
 *
 * HEAC PHY reset (active high)
 */
//@{
#define BP_HDMI_MC_HEACPHY_RST_HEACPHYRST      (0)      //!< Bit position for HDMI_MC_HEACPHY_RST_HEACPHYRST.
#define BM_HDMI_MC_HEACPHY_RST_HEACPHYRST      (0x00000001)  //!< Bit mask for HDMI_MC_HEACPHY_RST_HEACPHYRST.

//! @brief Get value of HDMI_MC_HEACPHY_RST_HEACPHYRST from a register value.
#define BG_HDMI_MC_HEACPHY_RST_HEACPHYRST(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_MC_HEACPHY_RST_HEACPHYRST) >> BP_HDMI_MC_HEACPHY_RST_HEACPHYRST)

//! @brief Format value for bitfield HDMI_MC_HEACPHY_RST_HEACPHYRST.
#define BF_HDMI_MC_HEACPHY_RST_HEACPHYRST(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_MC_HEACPHY_RST_HEACPHYRST) & BM_HDMI_MC_HEACPHY_RST_HEACPHYRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HEACPHYRST field to a new value.
#define BW_HDMI_MC_HEACPHY_RST_HEACPHYRST(v)   (HW_HDMI_MC_HEACPHY_RST_WR((HW_HDMI_MC_HEACPHY_RST_RD() & ~BM_HDMI_MC_HEACPHY_RST_HEACPHYRST) | BF_HDMI_MC_HEACPHY_RST_HEACPHYRST(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_CFG - Color Space Converter Interpolation and Decimation Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_CFG - Color Space Converter Interpolation and Decimation Configuration Register (RW)
 *
 * Reset value: 0x00
 *
 * Color Space Conversion configuration register. Configures YCC422 to YCC444 interpolation mode and
 * YCC444 to YCC422 decimation mode.
 */
typedef union _hw_hdmi_csc_cfg
{
    reg8_t U;
    struct _hw_hdmi_csc_cfg_bitfields
    {
        unsigned char DECMODE : 2; //!< [1:0] Chroma decimation configuration: decmode[1:0] Chroma decimation 00 decimation disabled 01 H d?
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char INTMODE : 2; //!< [5:4] Chroma interpolation configuration:
        unsigned char RESERVED1 : 2; //!< [7:6] Reserved
    } B;
} hw_hdmi_csc_cfg_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_CFG register
 */
//@{
#define HW_HDMI_CSC_CFG_ADDR      (REGS_HDMI_BASE + 0x4100)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_CFG           (*(volatile hw_hdmi_csc_cfg_t *) HW_HDMI_CSC_CFG_ADDR)
#define HW_HDMI_CSC_CFG_RD()      (HW_HDMI_CSC_CFG.U)
#define HW_HDMI_CSC_CFG_WR(v)     (HW_HDMI_CSC_CFG.U = (v))
#define HW_HDMI_CSC_CFG_SET(v)    (HW_HDMI_CSC_CFG_WR(HW_HDMI_CSC_CFG_RD() |  (v)))
#define HW_HDMI_CSC_CFG_CLR(v)    (HW_HDMI_CSC_CFG_WR(HW_HDMI_CSC_CFG_RD() & ~(v)))
#define HW_HDMI_CSC_CFG_TOG(v)    (HW_HDMI_CSC_CFG_WR(HW_HDMI_CSC_CFG_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_CFG bitfields
 */

/*! @name Register HDMI_CSC_CFG, field DECMODE[1:0] (RW)
 *
 * Chroma decimation configuration: decmode[1:0] Chroma decimation 00 decimation disabled 01 H d?
 * z?=1 10 H d? z?=1/ 4?1/ 2 z?1?1/4 z?2 11 H d? z?Þ211=?5?12 z?2?22 z?4?39 z?6?65 z?8?109 z?10?204
 * z?12?648 z?14?1024 z?15?648 z?16?204 z?18?109 z?20?65 z?22?39 z?24?22 z?26?12 z?28?5 z?30 00
 * decimation disabled 01 H d (z) = 1 10 H d (Z)=1/4 + 1/2z -1 1+1/4z -2 11H d (z)x2 11 =-5+12z -2
 * +22z -4 +39z -8 +109z -10 -204z -12 +648z -14 +1024z -15 +648z -16 -204z -18 +109z -20 -65z -22
 * +39z -24 -22z -26 +12z -28 -5z -30
 */
//@{
#define BP_HDMI_CSC_CFG_DECMODE      (0)      //!< Bit position for HDMI_CSC_CFG_DECMODE.
#define BM_HDMI_CSC_CFG_DECMODE      (0x00000003)  //!< Bit mask for HDMI_CSC_CFG_DECMODE.

//! @brief Get value of HDMI_CSC_CFG_DECMODE from a register value.
#define BG_HDMI_CSC_CFG_DECMODE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_CFG_DECMODE) >> BP_HDMI_CSC_CFG_DECMODE)

//! @brief Format value for bitfield HDMI_CSC_CFG_DECMODE.
#define BF_HDMI_CSC_CFG_DECMODE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_CFG_DECMODE) & BM_HDMI_CSC_CFG_DECMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DECMODE field to a new value.
#define BW_HDMI_CSC_CFG_DECMODE(v)   (HW_HDMI_CSC_CFG_WR((HW_HDMI_CSC_CFG_RD() & ~BM_HDMI_CSC_CFG_DECMODE) | BF_HDMI_CSC_CFG_DECMODE(v)))
#endif
//@}

/*! @name Register HDMI_CSC_CFG, field INTMODE[5:4] (RW)
 *
 * Chroma interpolation configuration: 00 interpolation disabled 01 H u (z) = 1 + z -1 10 H u
 * (z)=1/2 + Z -1 +1/2 z -2 11 interpolation disabled.
 */
//@{
#define BP_HDMI_CSC_CFG_INTMODE      (4)      //!< Bit position for HDMI_CSC_CFG_INTMODE.
#define BM_HDMI_CSC_CFG_INTMODE      (0x00000030)  //!< Bit mask for HDMI_CSC_CFG_INTMODE.

//! @brief Get value of HDMI_CSC_CFG_INTMODE from a register value.
#define BG_HDMI_CSC_CFG_INTMODE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_CFG_INTMODE) >> BP_HDMI_CSC_CFG_INTMODE)

//! @brief Format value for bitfield HDMI_CSC_CFG_INTMODE.
#define BF_HDMI_CSC_CFG_INTMODE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_CFG_INTMODE) & BM_HDMI_CSC_CFG_INTMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTMODE field to a new value.
#define BW_HDMI_CSC_CFG_INTMODE(v)   (HW_HDMI_CSC_CFG_WR((HW_HDMI_CSC_CFG_RD() & ~BM_HDMI_CSC_CFG_INTMODE) | BF_HDMI_CSC_CFG_INTMODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_SCALE - Color Space Converter Scale and Deep Color Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_SCALE - Color Space Converter Scale and Deep Color Configuration Register (RW)
 *
 * Reset value: 0x01
 *
 * CSC Conversion Functions
 */
typedef union _hw_hdmi_csc_scale
{
    reg8_t U;
    struct _hw_hdmi_csc_scale_bitfields
    {
        unsigned char CSC_SCALE : 2; //!< [1:0] Defines the csc_scale[1:0] scale factor to apply to all coefficients in Color Space Conversion.
        unsigned char RESERVED0 : 2; //!< [3:2] Reserved
        unsigned char CSC_COLORDEPTH : 4; //!< [7:4] Color space converter color depth configuration:
    } B;
} hw_hdmi_csc_scale_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_SCALE register
 */
//@{
#define HW_HDMI_CSC_SCALE_ADDR      (REGS_HDMI_BASE + 0x4101)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_SCALE           (*(volatile hw_hdmi_csc_scale_t *) HW_HDMI_CSC_SCALE_ADDR)
#define HW_HDMI_CSC_SCALE_RD()      (HW_HDMI_CSC_SCALE.U)
#define HW_HDMI_CSC_SCALE_WR(v)     (HW_HDMI_CSC_SCALE.U = (v))
#define HW_HDMI_CSC_SCALE_SET(v)    (HW_HDMI_CSC_SCALE_WR(HW_HDMI_CSC_SCALE_RD() |  (v)))
#define HW_HDMI_CSC_SCALE_CLR(v)    (HW_HDMI_CSC_SCALE_WR(HW_HDMI_CSC_SCALE_RD() & ~(v)))
#define HW_HDMI_CSC_SCALE_TOG(v)    (HW_HDMI_CSC_SCALE_WR(HW_HDMI_CSC_SCALE_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_SCALE bitfields
 */

/*! @name Register HDMI_CSC_SCALE, field CSC_SCALE[1:0] (RW)
 *
 * Defines the csc_scale[1:0] scale factor to apply to all coefficients in Color Space Conversion.
 * This scale factor is expressed in the number of left shifts to apply to each of the coefficients,
 * ranging from 0 to 2.
 */
//@{
#define BP_HDMI_CSC_SCALE_CSC_SCALE      (0)      //!< Bit position for HDMI_CSC_SCALE_CSC_SCALE.
#define BM_HDMI_CSC_SCALE_CSC_SCALE      (0x00000003)  //!< Bit mask for HDMI_CSC_SCALE_CSC_SCALE.

//! @brief Get value of HDMI_CSC_SCALE_CSC_SCALE from a register value.
#define BG_HDMI_CSC_SCALE_CSC_SCALE(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_SCALE_CSC_SCALE) >> BP_HDMI_CSC_SCALE_CSC_SCALE)

//! @brief Format value for bitfield HDMI_CSC_SCALE_CSC_SCALE.
#define BF_HDMI_CSC_SCALE_CSC_SCALE(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_SCALE_CSC_SCALE) & BM_HDMI_CSC_SCALE_CSC_SCALE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSC_SCALE field to a new value.
#define BW_HDMI_CSC_SCALE_CSC_SCALE(v)   (HW_HDMI_CSC_SCALE_WR((HW_HDMI_CSC_SCALE_RD() & ~BM_HDMI_CSC_SCALE_CSC_SCALE) | BF_HDMI_CSC_SCALE_CSC_SCALE(v)))
#endif
//@}

/*! @name Register HDMI_CSC_SCALE, field CSC_COLORDEPTH[7:4] (RW)
 *
 * Color space converter color depth configuration: Other: Reserved.
 *
 * Values:
 * - 0000 - 24 bit per pixel video (8 bit per component).
 * - 0100 - 24 bit per pixel video (8 bit per component).
 * - 0101 - 30 bit per pixel video (10 bit per component).
 * - 0110 - 36 bit per pixel video (12 bit per component).
 * - 0111 - 48 bit per pixel video (16 bit per component).
 */
//@{
#define BP_HDMI_CSC_SCALE_CSC_COLORDEPTH      (4)      //!< Bit position for HDMI_CSC_SCALE_CSC_COLORDEPTH.
#define BM_HDMI_CSC_SCALE_CSC_COLORDEPTH      (0x000000f0)  //!< Bit mask for HDMI_CSC_SCALE_CSC_COLORDEPTH.

//! @brief Get value of HDMI_CSC_SCALE_CSC_COLORDEPTH from a register value.
#define BG_HDMI_CSC_SCALE_CSC_COLORDEPTH(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_SCALE_CSC_COLORDEPTH) >> BP_HDMI_CSC_SCALE_CSC_COLORDEPTH)

//! @brief Format value for bitfield HDMI_CSC_SCALE_CSC_COLORDEPTH.
#define BF_HDMI_CSC_SCALE_CSC_COLORDEPTH(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_SCALE_CSC_COLORDEPTH) & BM_HDMI_CSC_SCALE_CSC_COLORDEPTH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSC_COLORDEPTH field to a new value.
#define BW_HDMI_CSC_SCALE_CSC_COLORDEPTH(v)   (HW_HDMI_CSC_SCALE_WR((HW_HDMI_CSC_SCALE_RD() & ~BM_HDMI_CSC_SCALE_CSC_COLORDEPTH) | BF_HDMI_CSC_SCALE_CSC_COLORDEPTH(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_COEF_A1_MSB - CSC_COEF_A1_MSB
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_COEF_A1_MSB - CSC_COEF_A1_MSB (RW)
 *
 * Reset value: 0x20
 *
 * Color Space Conversion A1 coefficient.
 */
typedef union _hw_hdmi_csc_coef_a1_msb
{
    reg8_t U;
    struct _hw_hdmi_csc_coef_a1_msb_bitfields
    {
        unsigned char CSC_COEF_A1_MSB : 8; //!< [7:0] Color Space Conversion A1 MSB coefficient.
    } B;
} hw_hdmi_csc_coef_a1_msb_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_COEF_A1_MSB register
 */
//@{
#define HW_HDMI_CSC_COEF_A1_MSB_ADDR      (REGS_HDMI_BASE + 0x4102)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_COEF_A1_MSB           (*(volatile hw_hdmi_csc_coef_a1_msb_t *) HW_HDMI_CSC_COEF_A1_MSB_ADDR)
#define HW_HDMI_CSC_COEF_A1_MSB_RD()      (HW_HDMI_CSC_COEF_A1_MSB.U)
#define HW_HDMI_CSC_COEF_A1_MSB_WR(v)     (HW_HDMI_CSC_COEF_A1_MSB.U = (v))
#define HW_HDMI_CSC_COEF_A1_MSB_SET(v)    (HW_HDMI_CSC_COEF_A1_MSB_WR(HW_HDMI_CSC_COEF_A1_MSB_RD() |  (v)))
#define HW_HDMI_CSC_COEF_A1_MSB_CLR(v)    (HW_HDMI_CSC_COEF_A1_MSB_WR(HW_HDMI_CSC_COEF_A1_MSB_RD() & ~(v)))
#define HW_HDMI_CSC_COEF_A1_MSB_TOG(v)    (HW_HDMI_CSC_COEF_A1_MSB_WR(HW_HDMI_CSC_COEF_A1_MSB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_COEF_A1_MSB bitfields
 */

/*! @name Register HDMI_CSC_COEF_A1_MSB, field CSC_COEF_A1_MSB[7:0] (RW)
 *
 * Color Space Conversion A1 MSB coefficient.
 */
//@{
#define BP_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB      (0)      //!< Bit position for HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB.
#define BM_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB      (0x000000ff)  //!< Bit mask for HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB.

//! @brief Get value of HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB from a register value.
#define BG_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB) >> BP_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB)

//! @brief Format value for bitfield HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB.
#define BF_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB) & BM_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSC_COEF_A1_MSB field to a new value.
#define BW_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB(v)   (HW_HDMI_CSC_COEF_A1_MSB_WR((HW_HDMI_CSC_COEF_A1_MSB_RD() & ~BM_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB) | BF_HDMI_CSC_COEF_A1_MSB_CSC_COEF_A1_MSB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_COEF_A1_LSB - CSC_COEF_A1_LSB
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_COEF_A1_LSB - CSC_COEF_A1_LSB (RW)
 *
 * Reset value: 0x00
 *
 * Color Space Conversion A1 coefficient.
 */
typedef union _hw_hdmi_csc_coef_a1_lsb
{
    reg8_t U;
    struct _hw_hdmi_csc_coef_a1_lsb_bitfields
    {
        unsigned char CSC_COEF_A1_LSB : 8; //!< [7:0] Color Space Conversion A1 LSB coefficient
    } B;
} hw_hdmi_csc_coef_a1_lsb_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_COEF_A1_LSB register
 */
//@{
#define HW_HDMI_CSC_COEF_A1_LSB_ADDR      (REGS_HDMI_BASE + 0x4103)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_COEF_A1_LSB           (*(volatile hw_hdmi_csc_coef_a1_lsb_t *) HW_HDMI_CSC_COEF_A1_LSB_ADDR)
#define HW_HDMI_CSC_COEF_A1_LSB_RD()      (HW_HDMI_CSC_COEF_A1_LSB.U)
#define HW_HDMI_CSC_COEF_A1_LSB_WR(v)     (HW_HDMI_CSC_COEF_A1_LSB.U = (v))
#define HW_HDMI_CSC_COEF_A1_LSB_SET(v)    (HW_HDMI_CSC_COEF_A1_LSB_WR(HW_HDMI_CSC_COEF_A1_LSB_RD() |  (v)))
#define HW_HDMI_CSC_COEF_A1_LSB_CLR(v)    (HW_HDMI_CSC_COEF_A1_LSB_WR(HW_HDMI_CSC_COEF_A1_LSB_RD() & ~(v)))
#define HW_HDMI_CSC_COEF_A1_LSB_TOG(v)    (HW_HDMI_CSC_COEF_A1_LSB_WR(HW_HDMI_CSC_COEF_A1_LSB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_COEF_A1_LSB bitfields
 */

/*! @name Register HDMI_CSC_COEF_A1_LSB, field CSC_COEF_A1_LSB[7:0] (RW)
 *
 * Color Space Conversion A1 LSB coefficient
 */
//@{
#define BP_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB      (0)      //!< Bit position for HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB.
#define BM_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB      (0x000000ff)  //!< Bit mask for HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB.

//! @brief Get value of HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB from a register value.
#define BG_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB) >> BP_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB)

//! @brief Format value for bitfield HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB.
#define BF_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB) & BM_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSC_COEF_A1_LSB field to a new value.
#define BW_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB(v)   (HW_HDMI_CSC_COEF_A1_LSB_WR((HW_HDMI_CSC_COEF_A1_LSB_RD() & ~BM_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB) | BF_HDMI_CSC_COEF_A1_LSB_CSC_COEF_A1_LSB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_COEF_A2_MSB - CSC_COEF_A2_MSB
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_COEF_A2_MSB - CSC_COEF_A2_MSB (RW)
 *
 * Reset value: 0x00
 *
 * Color Space Conversion A2 coefficient.
 */
typedef union _hw_hdmi_csc_coef_a2_msb
{
    reg8_t U;
    struct _hw_hdmi_csc_coef_a2_msb_bitfields
    {
        unsigned char CSC_COEF_A2_MSB : 8; //!< [7:0] Color Space Conversion A2 MSB coefficient.
    } B;
} hw_hdmi_csc_coef_a2_msb_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_COEF_A2_MSB register
 */
//@{
#define HW_HDMI_CSC_COEF_A2_MSB_ADDR      (REGS_HDMI_BASE + 0x4104)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_COEF_A2_MSB           (*(volatile hw_hdmi_csc_coef_a2_msb_t *) HW_HDMI_CSC_COEF_A2_MSB_ADDR)
#define HW_HDMI_CSC_COEF_A2_MSB_RD()      (HW_HDMI_CSC_COEF_A2_MSB.U)
#define HW_HDMI_CSC_COEF_A2_MSB_WR(v)     (HW_HDMI_CSC_COEF_A2_MSB.U = (v))
#define HW_HDMI_CSC_COEF_A2_MSB_SET(v)    (HW_HDMI_CSC_COEF_A2_MSB_WR(HW_HDMI_CSC_COEF_A2_MSB_RD() |  (v)))
#define HW_HDMI_CSC_COEF_A2_MSB_CLR(v)    (HW_HDMI_CSC_COEF_A2_MSB_WR(HW_HDMI_CSC_COEF_A2_MSB_RD() & ~(v)))
#define HW_HDMI_CSC_COEF_A2_MSB_TOG(v)    (HW_HDMI_CSC_COEF_A2_MSB_WR(HW_HDMI_CSC_COEF_A2_MSB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_COEF_A2_MSB bitfields
 */

/*! @name Register HDMI_CSC_COEF_A2_MSB, field CSC_COEF_A2_MSB[7:0] (RW)
 *
 * Color Space Conversion A2 MSB coefficient.
 */
//@{
#define BP_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB      (0)      //!< Bit position for HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB.
#define BM_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB      (0x000000ff)  //!< Bit mask for HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB.

//! @brief Get value of HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB from a register value.
#define BG_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB(r)   ((__REG_VALUE_TYPE((r), reg8_t) & BM_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB) >> BP_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB)

//! @brief Format value for bitfield HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB.
#define BF_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB(v)   ((__REG_VALUE_TYPE((v), reg8_t) << BP_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB) & BM_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSC_COEF_A2_MSB field to a new value.
#define BW_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB(v)   (HW_HDMI_CSC_COEF_A2_MSB_WR((HW_HDMI_CSC_COEF_A2_MSB_RD() & ~BM_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB) | BF_HDMI_CSC_COEF_A2_MSB_CSC_COEF_A2_MSB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_HDMI_CSC_COEF_A2_LSB - CSC_COEF_A2_LSB
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_HDMI_CSC_COEF_A2_LSB - CSC_COEF_A2_LSB (RW)
 *
 * Reset value: 0x00
 *
 * Color Space Conversion A2 coefficient.
 */
typedef union _hw_hdmi_csc_coef_a2_lsb
{
    reg8_t U;
    struct _hw_hdmi_csc_coef_a2_lsb_bitfields
    {
        unsigned char CSC_COEF_A2_LSB : 8; //!< [7:0] Color Space Conversion A2 LSB coefficient.
    } B;
} hw_hdmi_csc_coef_a2_lsb_t;
#endif

/*!
 * @name Constants and macros for entire HDMI_CSC_COEF_A2_LSB register
 */
//@{
#define HW_HDMI_CSC_COEF_A2_LSB_ADDR      (REGS_HDMI_BASE + 0x4105)

#ifndef __LANGUAGE_ASM__
#define HW_HDMI_CSC_COEF_A2_LSB           (*(volatile hw_hdmi_csc_coef_a2_lsb_t *) HW_HDMI_CSC_COEF_A2_LSB_ADDR)
#define HW_HDMI_CSC_COEF_A2_LSB_RD()      (HW_HDMI_CSC_COEF_A2_LSB.U)
#define HW_HDMI_CSC_COEF_A2_LSB_WR(v)     (HW_HDMI_CSC_COEF_A2_LSB.U = (v))
#define HW_HDMI_CSC_COEF_A2_LSB_SET(v)    (HW_HDMI_CSC_COEF_A2_LSB_WR(HW_HDMI_CSC_COEF_A2_LSB_RD() |  (v)))
#define HW_HDMI_CSC_COEF_A2_LSB_CLR(v)    (HW_HDMI_CSC_COEF_A2_LSB_WR(HW_HDMI_CSC_COEF_A2_LSB_RD() & ~(v)))
#define HW_HDMI_CSC_COEF_A2_LSB_TOG(v)    (HW_HDMI_CSC_COEF_A2_LSB_WR(HW_HDMI_CSC_COEF_A2_LSB_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual HDMI_CSC_COEF_A2_LSB bitfields
 */

/*! @name Register HDMI_CSC_COEF_A2_LSB, field CSC_COEF_A2_LSB[7:0] (RW)
 *
 * Color Space Conversion A2 LSB coefficient.
 */
//@{
#define BP_HDMI_CSC_COEF_A2_LSB_C