/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CSU_REGISTERS_H__
#define __HW_CSU_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6SDL CSU
 *
 * CSU Registers
 *
 * Registers defined in this header file:
 * - HW_CSU_CSLn - Config security level register
 * - HW_CSU_HP0 - HP0 register
 * - HW_CSU_HP1 - HP1 register
 * - HW_CSU_SA - Secure access register
 * - HW_CSU_HPCONTROL0 - HPCONTROL0 register
 * - HW_CSU_HPCONTROL1 - HPCONTROL1 register
 *
 * - hw_csu_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_CSU_BASE
#define HW_CSU_INSTANCE_COUNT (1) //!< Number of instances of the CSU module.
#define REGS_CSU_BASE (0x021c0000) //!< Base address for CSU.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_CSLn - Config security level register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_CSLn - Config security level register (RW)
 *
 * Reset value: 0x00330033
 *
 * There are 40 Config Security Level (CSU_CSL0-CSU_CSL39) registers. Each CSU_CSL is comprised of
 * two fields, each field used to determine the read and write access permissions for a slave
 * peripheral. These 8-bit fields for the first and second slaves are in the locations b23-b16 and
 * bits b7-b0, respectively. Permission Access Table shows security levels and csu_sec_level signal
 * levels corresponding to different values of the 8-bit CSU_CSL field for a given slave. Most
 * slaves have unique CSL registers. Some slaves are grouped together in USB, Timers, PowerUp and
 * Audio groups. The following table shows allocation of CSL register per slave or group of slave
 * modules. CSL Slave Modules Mapping Slave Module Corresponding CSL register and bit field Comments
 * PWM1 PWM2 PWM3 PWM4 CSL0 [7:0] Audio group shared control CAN1 CSL0 [23:16] CAN2 CSL1 [7:0] GPT
 * EPIT1 EPIT2 CSL1 [23:16] Timers group GPIO1 GPIO2 CSL2 [7:0] GPIO1 and GPIO2 group GPIO3 GPIO4
 * CSL2 [23:16] GPIO3 and GPIO4 group GPIO5 GPIO6 CSL3 [7:0] GPIO5 and GPIO6 group GPIO7 CSL3
 * [23:16] KPP CSL4 [7:0] WDOG1 CSL4 [23:16] WDOG2 CSL5 [7:0] CCM SNVS_HP SRC GPC CSL5 [23:16] Power
 * group IP2APB_ANATOP CSL6 [7:0] IOMUXC CSL6 [23:16] DCIC1 DCIC2 CSL7 [7:0] SDMA (port IPS_HOST)
 * EPDC LCDIF PXP CSL7 [23:16] USBOH3 (port PL301) USBOH3 (port USB) CSL8 [7:0] ENET CSL8 [23:16]
 * MLB150 CSL9 [7:0] USDHC1 CSL9 [23:16] USDHC2 CSL10 [7:0] USDHC3 CSL10 [23:16] USDHC4 CSL11 [7:0]
 * I2C1 CSL11 [23:16] I2C2 CSL12 [7:0] I2C3 CSL12 [23:16] ROMCP CSL13[7:0] VPU MMDC_CORE (port
 * IPS_P0) MMDC_CORE (port IPS_P1) CSL13 [23:16] MMDC Group WEIM CSL14 [7:0] OCOTP_CTRL CSL14
 * [23:16] Reserved CSL15 [7:0] PERFMON1 PERFMON2 PERFMON3 CSL15 [23:16] PerfMon group TZASC1 CSL16
 * [7:0] TZASC2 CSL16 [23:16] AUDMUX CSL17 [7:0] CAAM CSL17 [23:16] SPDIF CSL18 [7:0] eCSPI1 CSL18
 * [23:16] eCSPI2 CSL19 [7:0] eCSPI3 CSL19 [23:16] eCSPI4 CSL20 [7:0] Reserved CSL20 [23:16] UART1
 * CSL21 [7:0] ESAI1 CSL21 [23:16] SSI1 CSL22 [7:0] SSI2 CSL22 [23:16] SSI3 CSL23 [7:0] ASRC (VIA
 * IPSYNC) CSL23 [23:16] Reserved CSL24 [7:0] ROMCP CSL24 [23:16] Reserved CSL25 [7:0] Reserved
 * CSL25 [23:16] OCRAM CSL26 [7:0] CAAM CSL26 [23:16] APBH_DMA CSL27 [7:0] HDMI CSL27 [23:16] GPU3D
 * CSL28[7:0] Reserved CSL28 [23:16] Reserved CSL29 [7:0] ARM core platform DAP and platform
 * controller CSL29 [23:16] HSI CSL30 [7:0] IPU1 CSL30 [23:16] Reserved CSL31 [7:0] WEIM CSL31
 * [23:16] PCIE CSL32 [7:0] GPU2D CSL32 [23:16] MIPI_CORE_CSI CSL33 [7:0] MIPI_CORE_HSI CSL33
 * [23:16] VDOA CSL34 [7:0] UART2 CSL34 [23:16] UART3 CSL35 [7:0] UART4 CSL35 [23:16] UART5 I2C4
 * CSL36 [7:0] DTCP CSL36 [23:16] Reserved CSL37 [7:0] Reserved CSL37 [23:16] Reserved CSL38 [7:0]
 * Reserved CSL38 [23:16] SPBA CSL39 [7:0] Reserved CSL39 [23:16] Do not modify the following
 * peripherals' CSL register bits while they are being accessed through the AHB/AXI slave bus: EIM,
 * IPU, DTCP, APBHDMA and PCIe.
 */
typedef union _hw_csu_csln
{
    reg32_t U;
    struct _hw_csu_csln_bitfields
    {
        unsigned SUR_S2 : 1; //!< [0] Secure user read access control for the second slave
        unsigned SSR_S2 : 1; //!< [1] Secure supervisor read access control for the second slave
        unsigned NUR_S2 : 1; //!< [2] Non-secure user read access control for the second slave
        unsigned NSR_S2 : 1; //!< [3] Non-secure supervisor read access control for the second slave
        unsigned SUW_S2 : 1; //!< [4] Secure user write access control for the second slave
        unsigned SSW_S2 : 1; //!< [5] Secure supervisor write access control for the second slave
        unsigned NUW_S2 : 1; //!< [6] Non-secure user write access control for the second slave
        unsigned NSW_S2 : 1; //!< [7] Non-secure supervisor write access control for the second slave
        unsigned LOCK_S2 : 1; //!< [8] Lock bit corresponding to the second slave.
        unsigned RESERVED0 : 7; //!< [15:9] Reserved
        unsigned SUR_S1 : 1; //!< [16] Secure user read access control for the first slave
        unsigned SSR_S1 : 1; //!< [17] Secure supervisor read access control for the first slave
        unsigned NUR_S1 : 1; //!< [18] Non-secure user read access control for the first slave
        unsigned NSR_S1 : 1; //!< [19] Non-secure supervisor read access control for the first slave
        unsigned SUW_S1 : 1; //!< [20] Secure user write access control for the first slave
        unsigned SSW_S1 : 1; //!< [21] Secure supervisor write access control for the first slave
        unsigned NUW_S1 : 1; //!< [22] Non-secure user write access control for the first slave
        unsigned NSW_S1 : 1; //!< [23] Non-secure supervisor write access control for the first slave
        unsigned LOCK_S1 : 1; //!< [24] Lock bit corresponding to the first slave.
        unsigned RESERVED1 : 7; //!< [31:25] Reserved
    } B;
} hw_csu_csln_t;
#endif

/*!
 * @name Constants and macros for entire CSU_CSLn register
 */
//@{
//! @brief Number of instances of the CSU_CSLn register.
#define HW_CSU_CSLn_COUNT     (40)

#define HW_CSU_CSLn_ADDR(n)   (REGS_CSU_BASE + 0x0 + (0x4 * (n)))

#ifndef __LANGUAGE_ASM__
#define HW_CSU_CSLn(n)        (*(volatile hw_csu_csln_t *) HW_CSU_CSLn_ADDR(n))
#define HW_CSU_CSLn_RD(n)     (HW_CSU_CSLn(n).U)
#define HW_CSU_CSLn_WR(n, v)  (HW_CSU_CSLn(n).U = (v))
#define HW_CSU_CSLn_SET(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) |  (v)))
#define HW_CSU_CSLn_CLR(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) & ~(v)))
#define HW_CSU_CSLn_TOG(n, v) (HW_CSU_CSLn_WR(n, HW_CSU_CSLn_RD(n) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_CSLn bitfields
 */

/*! @name Register CSU_CSLn, field SUR_S2[0] (RW)
 *
 * Secure user read access control for the second slave
 *
 * Values:
 * - 0 - Secure user read access disabled for the second slave.
 * - 1 - Secure user read access enabled for the second slave
 */
//@{
#define BP_CSU_CSLn_SUR_S2      (0)      //!< Bit position for CSU_CSLn_SUR_S2.
#define BM_CSU_CSLn_SUR_S2      (0x00000001)  //!< Bit mask for CSU_CSLn_SUR_S2.

//! @brief Get value of CSU_CSLn_SUR_S2 from a register value.
#define BG_CSU_CSLn_SUR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUR_S2) >> BP_CSU_CSLn_SUR_S2)

//! @brief Format value for bitfield CSU_CSLn_SUR_S2.
#define BF_CSU_CSLn_SUR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUR_S2) & BM_CSU_CSLn_SUR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUR_S2 field to a new value.
#define BW_CSU_CSLn_SUR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUR_S2) | BF_CSU_CSLn_SUR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSR_S2[1] (RW)
 *
 * Secure supervisor read access control for the second slave
 *
 * Values:
 * - 0 - Secure supervisor read access disabled for the second slave.
 * - 1 - Secure supervisor read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SSR_S2      (1)      //!< Bit position for CSU_CSLn_SSR_S2.
#define BM_CSU_CSLn_SSR_S2      (0x00000002)  //!< Bit mask for CSU_CSLn_SSR_S2.

//! @brief Get value of CSU_CSLn_SSR_S2 from a register value.
#define BG_CSU_CSLn_SSR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSR_S2) >> BP_CSU_CSLn_SSR_S2)

//! @brief Format value for bitfield CSU_CSLn_SSR_S2.
#define BF_CSU_CSLn_SSR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSR_S2) & BM_CSU_CSLn_SSR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSR_S2 field to a new value.
#define BW_CSU_CSLn_SSR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSR_S2) | BF_CSU_CSLn_SSR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUR_S2[2] (RW)
 *
 * Non-secure user read access control for the second slave
 *
 * Values:
 * - 0 - Non-secure user read access disabled for the second slave.
 * - 1 - Non-secure user read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NUR_S2      (2)      //!< Bit position for CSU_CSLn_NUR_S2.
#define BM_CSU_CSLn_NUR_S2      (0x00000004)  //!< Bit mask for CSU_CSLn_NUR_S2.

//! @brief Get value of CSU_CSLn_NUR_S2 from a register value.
#define BG_CSU_CSLn_NUR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUR_S2) >> BP_CSU_CSLn_NUR_S2)

//! @brief Format value for bitfield CSU_CSLn_NUR_S2.
#define BF_CSU_CSLn_NUR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUR_S2) & BM_CSU_CSLn_NUR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUR_S2 field to a new value.
#define BW_CSU_CSLn_NUR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUR_S2) | BF_CSU_CSLn_NUR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSR_S2[3] (RW)
 *
 * Non-secure supervisor read access control for the second slave
 *
 * Values:
 * - 0 - Non-secure supervisor read access disabled for the second slave.
 * - 1 - Non-secure supervisor read access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NSR_S2      (3)      //!< Bit position for CSU_CSLn_NSR_S2.
#define BM_CSU_CSLn_NSR_S2      (0x00000008)  //!< Bit mask for CSU_CSLn_NSR_S2.

//! @brief Get value of CSU_CSLn_NSR_S2 from a register value.
#define BG_CSU_CSLn_NSR_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSR_S2) >> BP_CSU_CSLn_NSR_S2)

//! @brief Format value for bitfield CSU_CSLn_NSR_S2.
#define BF_CSU_CSLn_NSR_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSR_S2) & BM_CSU_CSLn_NSR_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSR_S2 field to a new value.
#define BW_CSU_CSLn_NSR_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSR_S2) | BF_CSU_CSLn_NSR_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUW_S2[4] (RW)
 *
 * Secure user write access control for the second slave
 *
 * Values:
 * - 0 - Secure user write access disabled for the second slave.
 * - 1 - Secure user write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SUW_S2      (4)      //!< Bit position for CSU_CSLn_SUW_S2.
#define BM_CSU_CSLn_SUW_S2      (0x00000010)  //!< Bit mask for CSU_CSLn_SUW_S2.

//! @brief Get value of CSU_CSLn_SUW_S2 from a register value.
#define BG_CSU_CSLn_SUW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUW_S2) >> BP_CSU_CSLn_SUW_S2)

//! @brief Format value for bitfield CSU_CSLn_SUW_S2.
#define BF_CSU_CSLn_SUW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUW_S2) & BM_CSU_CSLn_SUW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUW_S2 field to a new value.
#define BW_CSU_CSLn_SUW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUW_S2) | BF_CSU_CSLn_SUW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSW_S2[5] (RW)
 *
 * Secure supervisor write access control for the second slave
 *
 * Values:
 * - 0 - Secure supervisor write access disabled for the second slave.
 * - 1 - Secure supervisor write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_SSW_S2      (5)      //!< Bit position for CSU_CSLn_SSW_S2.
#define BM_CSU_CSLn_SSW_S2      (0x00000020)  //!< Bit mask for CSU_CSLn_SSW_S2.

//! @brief Get value of CSU_CSLn_SSW_S2 from a register value.
#define BG_CSU_CSLn_SSW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSW_S2) >> BP_CSU_CSLn_SSW_S2)

//! @brief Format value for bitfield CSU_CSLn_SSW_S2.
#define BF_CSU_CSLn_SSW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSW_S2) & BM_CSU_CSLn_SSW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSW_S2 field to a new value.
#define BW_CSU_CSLn_SSW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSW_S2) | BF_CSU_CSLn_SSW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUW_S2[6] (RW)
 *
 * Non-secure user write access control for the second slave
 *
 * Values:
 * - 0 - Non-secure user write access disabled for the second slave.
 * - 1 - Non-secure user write access enabled for the second slave.
 */
//@{
#define BP_CSU_CSLn_NUW_S2      (6)      //!< Bit position for CSU_CSLn_NUW_S2.
#define BM_CSU_CSLn_NUW_S2      (0x00000040)  //!< Bit mask for CSU_CSLn_NUW_S2.

//! @brief Get value of CSU_CSLn_NUW_S2 from a register value.
#define BG_CSU_CSLn_NUW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUW_S2) >> BP_CSU_CSLn_NUW_S2)

//! @brief Format value for bitfield CSU_CSLn_NUW_S2.
#define BF_CSU_CSLn_NUW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUW_S2) & BM_CSU_CSLn_NUW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUW_S2 field to a new value.
#define BW_CSU_CSLn_NUW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUW_S2) | BF_CSU_CSLn_NUW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSW_S2[7] (RW)
 *
 * Non-secure supervisor write access control for the second slave
 *
 * Values:
 * - 0 - Non-secure supervisor write access disabled for the second slave.
 * - 1 - Non-secure supervisor write access enabled for the second slave
 */
//@{
#define BP_CSU_CSLn_NSW_S2      (7)      //!< Bit position for CSU_CSLn_NSW_S2.
#define BM_CSU_CSLn_NSW_S2      (0x00000080)  //!< Bit mask for CSU_CSLn_NSW_S2.

//! @brief Get value of CSU_CSLn_NSW_S2 from a register value.
#define BG_CSU_CSLn_NSW_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSW_S2) >> BP_CSU_CSLn_NSW_S2)

//! @brief Format value for bitfield CSU_CSLn_NSW_S2.
#define BF_CSU_CSLn_NSW_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSW_S2) & BM_CSU_CSLn_NSW_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSW_S2 field to a new value.
#define BW_CSU_CSLn_NSW_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSW_S2) | BF_CSU_CSLn_NSW_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field LOCK_S2[8] (RW)
 *
 * Lock bit corresponding to the second slave. Written by secure software.
 *
 * Values:
 * - 0 - Not locked. Bits 7-0 may be written by software
 * - 1 - Bits 7-0 locked and cannot be written by software
 */
//@{
#define BP_CSU_CSLn_LOCK_S2      (8)      //!< Bit position for CSU_CSLn_LOCK_S2.
#define BM_CSU_CSLn_LOCK_S2      (0x00000100)  //!< Bit mask for CSU_CSLn_LOCK_S2.

//! @brief Get value of CSU_CSLn_LOCK_S2 from a register value.
#define BG_CSU_CSLn_LOCK_S2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_LOCK_S2) >> BP_CSU_CSLn_LOCK_S2)

//! @brief Format value for bitfield CSU_CSLn_LOCK_S2.
#define BF_CSU_CSLn_LOCK_S2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_LOCK_S2) & BM_CSU_CSLn_LOCK_S2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK_S2 field to a new value.
#define BW_CSU_CSLn_LOCK_S2(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_LOCK_S2) | BF_CSU_CSLn_LOCK_S2(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUR_S1[16] (RW)
 *
 * Secure user read access control for the first slave
 *
 * Values:
 * - 0 - Secure user read access disabled for the first slave.
 * - 1 - Secure user read access enabled for the first slave
 */
//@{
#define BP_CSU_CSLn_SUR_S1      (16)      //!< Bit position for CSU_CSLn_SUR_S1.
#define BM_CSU_CSLn_SUR_S1      (0x00010000)  //!< Bit mask for CSU_CSLn_SUR_S1.

//! @brief Get value of CSU_CSLn_SUR_S1 from a register value.
#define BG_CSU_CSLn_SUR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUR_S1) >> BP_CSU_CSLn_SUR_S1)

//! @brief Format value for bitfield CSU_CSLn_SUR_S1.
#define BF_CSU_CSLn_SUR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUR_S1) & BM_CSU_CSLn_SUR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUR_S1 field to a new value.
#define BW_CSU_CSLn_SUR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUR_S1) | BF_CSU_CSLn_SUR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSR_S1[17] (RW)
 *
 * Secure supervisor read access control for the first slave
 *
 * Values:
 * - 0 - Secure supervisor read access disabled for the first slave.
 * - 1 - Secure supervisor read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SSR_S1      (17)      //!< Bit position for CSU_CSLn_SSR_S1.
#define BM_CSU_CSLn_SSR_S1      (0x00020000)  //!< Bit mask for CSU_CSLn_SSR_S1.

//! @brief Get value of CSU_CSLn_SSR_S1 from a register value.
#define BG_CSU_CSLn_SSR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSR_S1) >> BP_CSU_CSLn_SSR_S1)

//! @brief Format value for bitfield CSU_CSLn_SSR_S1.
#define BF_CSU_CSLn_SSR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSR_S1) & BM_CSU_CSLn_SSR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSR_S1 field to a new value.
#define BW_CSU_CSLn_SSR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSR_S1) | BF_CSU_CSLn_SSR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUR_S1[18] (RW)
 *
 * Non-secure user read access control for the first slave
 *
 * Values:
 * - 0 - Non-secure user read access disabled for the first slave.
 * - 1 - Non-secure user read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NUR_S1      (18)      //!< Bit position for CSU_CSLn_NUR_S1.
#define BM_CSU_CSLn_NUR_S1      (0x00040000)  //!< Bit mask for CSU_CSLn_NUR_S1.

//! @brief Get value of CSU_CSLn_NUR_S1 from a register value.
#define BG_CSU_CSLn_NUR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUR_S1) >> BP_CSU_CSLn_NUR_S1)

//! @brief Format value for bitfield CSU_CSLn_NUR_S1.
#define BF_CSU_CSLn_NUR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUR_S1) & BM_CSU_CSLn_NUR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUR_S1 field to a new value.
#define BW_CSU_CSLn_NUR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUR_S1) | BF_CSU_CSLn_NUR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSR_S1[19] (RW)
 *
 * Non-secure supervisor read access control for the first slave
 *
 * Values:
 * - 0 - Non-secure supervisor read access disabled for the first slave.
 * - 1 - Non-secure supervisor read access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NSR_S1      (19)      //!< Bit position for CSU_CSLn_NSR_S1.
#define BM_CSU_CSLn_NSR_S1      (0x00080000)  //!< Bit mask for CSU_CSLn_NSR_S1.

//! @brief Get value of CSU_CSLn_NSR_S1 from a register value.
#define BG_CSU_CSLn_NSR_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSR_S1) >> BP_CSU_CSLn_NSR_S1)

//! @brief Format value for bitfield CSU_CSLn_NSR_S1.
#define BF_CSU_CSLn_NSR_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSR_S1) & BM_CSU_CSLn_NSR_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSR_S1 field to a new value.
#define BW_CSU_CSLn_NSR_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSR_S1) | BF_CSU_CSLn_NSR_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SUW_S1[20] (RW)
 *
 * Secure user write access control for the first slave
 *
 * Values:
 * - 0 - Secure user write access disabled for the first slave.
 * - 1 - Secure user write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SUW_S1      (20)      //!< Bit position for CSU_CSLn_SUW_S1.
#define BM_CSU_CSLn_SUW_S1      (0x00100000)  //!< Bit mask for CSU_CSLn_SUW_S1.

//! @brief Get value of CSU_CSLn_SUW_S1 from a register value.
#define BG_CSU_CSLn_SUW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SUW_S1) >> BP_CSU_CSLn_SUW_S1)

//! @brief Format value for bitfield CSU_CSLn_SUW_S1.
#define BF_CSU_CSLn_SUW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SUW_S1) & BM_CSU_CSLn_SUW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUW_S1 field to a new value.
#define BW_CSU_CSLn_SUW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SUW_S1) | BF_CSU_CSLn_SUW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field SSW_S1[21] (RW)
 *
 * Secure supervisor write access control for the first slave
 *
 * Values:
 * - 0 - Secure supervisor write access disabled for the first slave.
 * - 1 - Secure supervisor write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_SSW_S1      (21)      //!< Bit position for CSU_CSLn_SSW_S1.
#define BM_CSU_CSLn_SSW_S1      (0x00200000)  //!< Bit mask for CSU_CSLn_SSW_S1.

//! @brief Get value of CSU_CSLn_SSW_S1 from a register value.
#define BG_CSU_CSLn_SSW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_SSW_S1) >> BP_CSU_CSLn_SSW_S1)

//! @brief Format value for bitfield CSU_CSLn_SSW_S1.
#define BF_CSU_CSLn_SSW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_SSW_S1) & BM_CSU_CSLn_SSW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSW_S1 field to a new value.
#define BW_CSU_CSLn_SSW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_SSW_S1) | BF_CSU_CSLn_SSW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NUW_S1[22] (RW)
 *
 * Non-secure user write access control for the first slave
 *
 * Values:
 * - 0 - Non-secure user write access disabled for the first slave.
 * - 1 - Non-secure user write access enabled for the first slave.
 */
//@{
#define BP_CSU_CSLn_NUW_S1      (22)      //!< Bit position for CSU_CSLn_NUW_S1.
#define BM_CSU_CSLn_NUW_S1      (0x00400000)  //!< Bit mask for CSU_CSLn_NUW_S1.

//! @brief Get value of CSU_CSLn_NUW_S1 from a register value.
#define BG_CSU_CSLn_NUW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NUW_S1) >> BP_CSU_CSLn_NUW_S1)

//! @brief Format value for bitfield CSU_CSLn_NUW_S1.
#define BF_CSU_CSLn_NUW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NUW_S1) & BM_CSU_CSLn_NUW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NUW_S1 field to a new value.
#define BW_CSU_CSLn_NUW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NUW_S1) | BF_CSU_CSLn_NUW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field NSW_S1[23] (RW)
 *
 * Non-secure supervisor write access control for the first slave
 *
 * Values:
 * - 0 - Non-secure supervisor write access disabled for the first slave.
 * - 1 - Non-secure supervisor write access enabled for the first slave
 */
//@{
#define BP_CSU_CSLn_NSW_S1      (23)      //!< Bit position for CSU_CSLn_NSW_S1.
#define BM_CSU_CSLn_NSW_S1      (0x00800000)  //!< Bit mask for CSU_CSLn_NSW_S1.

//! @brief Get value of CSU_CSLn_NSW_S1 from a register value.
#define BG_CSU_CSLn_NSW_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_NSW_S1) >> BP_CSU_CSLn_NSW_S1)

//! @brief Format value for bitfield CSU_CSLn_NSW_S1.
#define BF_CSU_CSLn_NSW_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_NSW_S1) & BM_CSU_CSLn_NSW_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSW_S1 field to a new value.
#define BW_CSU_CSLn_NSW_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_NSW_S1) | BF_CSU_CSLn_NSW_S1(v)))
#endif
//@}

/*! @name Register CSU_CSLn, field LOCK_S1[24] (RW)
 *
 * Lock bit corresponding to the first slave. Written by secure software.
 *
 * Values:
 * - 0 - Not locked. Bits 16-23 may be written by software
 * - 1 - Bits 16-23 locked and cannot be written by software
 */
//@{
#define BP_CSU_CSLn_LOCK_S1      (24)      //!< Bit position for CSU_CSLn_LOCK_S1.
#define BM_CSU_CSLn_LOCK_S1      (0x01000000)  //!< Bit mask for CSU_CSLn_LOCK_S1.

//! @brief Get value of CSU_CSLn_LOCK_S1 from a register value.
#define BG_CSU_CSLn_LOCK_S1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_CSLn_LOCK_S1) >> BP_CSU_CSLn_LOCK_S1)

//! @brief Format value for bitfield CSU_CSLn_LOCK_S1.
#define BF_CSU_CSLn_LOCK_S1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_CSLn_LOCK_S1) & BM_CSU_CSLn_LOCK_S1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOCK_S1 field to a new value.
#define BW_CSU_CSLn_LOCK_S1(n, v)   (HW_CSU_CSLn_WR(n, (HW_CSU_CSLn_RD(n) & ~BM_CSU_CSLn_LOCK_S1) | BF_CSU_CSLn_LOCK_S1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_HP0 - HP0 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_HP0 - HP0 register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SCU_HP0 and SCU_HP1 registers may be programmed to determine the privilege (either User Mode
 * or Supervisor Mode) for seventeen different master groups. The privilege of a particular master
 * group may be overridden by muxing it with the corresponding bit in this register. The even bit
 * positions (CSU_HP0[30,28,...0] and CSU_HP1[0]) in the registers hold the privilege indicator
 * bits; while the odd bit positions (CSU_HP0[31,29,...,1] and CSU_HP1[1]) contain lock bits which
 * enable/disable writing to the corresponding privilege indicator bits.
 */
typedef union _hw_csu_hp0
{
    reg32_t U;
    struct _hw_csu_hp0_bitfields
    {
        unsigned HP_PCIE : 1; //!< [0] Indicates the Privilege/User Mode for PCIE
        unsigned L_PCIE : 1; //!< [1] Lock bit set by TZ software for HP_PCIE.
        unsigned HP_SATA : 1; //!< [2] Indicates the Privilege/User Mode for SATA
        unsigned L_SATA : 1; //!< [3] Lock bit set by TZ software for HP_SATA.
        unsigned HP_SDMA : 1; //!< [4] Indicates the Privilege/User Mode for SDMA.
        unsigned L_SDMA : 1; //!< [5] Lock bit set by TZ software for HP_SDMA.
        unsigned HP_PU : 1; //!< [6] Indicates the Privilege/User Mode for GPU3D, GPU2D, VPU, IPU1, EPDC, PXP, LCDIF and VDOA.
        unsigned L_PU : 1; //!< [7] Lock bit set by TZ software for HP_PU.
        unsigned HP_USB : 1; //!< [8] Indicates the Privilege/User Mode for USB.
        unsigned L_USB : 1; //!< [9] Lock bit set by TZ software for HP_USB.
        unsigned HP_TEST : 1; //!< [10] Indicates the Privilege/User Mode for IOMUX Test Port.
        unsigned L_TEST : 1; //!< [11] Lock bit set by TZ software for HP_TEST.
        unsigned HP_MLB : 1; //!< [12] Indicate the mode Privilege/User Mode for MLB.
        unsigned L_MLB : 1; //!< [13] Lock bit set by TZ software for HP_MLB.
        unsigned HP_CAAM : 1; //!< [14] Indicates the Privilege/User Mode for CAAM
        unsigned L_CAAM : 1; //!< [15] Lock bit set by TZ software for HP_CAAM.
        unsigned HP_RAWNAND : 1; //!< [16] Indicates the Privilege/User Mode for RawNAND
        unsigned L_RAWNAND : 1; //!< [17] Lock bit set by TZ software for HP_RAWNAND.
        unsigned HP_APBHDMA : 1; //!< [18] Indicates the Privilege/User Mode for APBHDMA
        unsigned L_ABPHDMA : 1; //!< [19] Lock bit set by TZ software for HP_APBHDMA.
        unsigned HP_ENET : 1; //!< [20] Indicates the Privilege/User Mode for ENET
        unsigned L_ENET : 1; //!< [21] Lock bit set by TZ software for HP_ENET.
        unsigned HP_DAP : 1; //!< [22] Indicates the Privilege/User Mode for DAP
        unsigned L_DAP : 1; //!< [23] Lock bit set by TZ software for HP_DAP.
        unsigned HP_USDHC1 : 1; //!< [24] Indicates the Privilege/User Mode for USDHC1
        unsigned L_USDHC1 : 1; //!< [25] Lock bit set by TZ software for HP_USDHC1.
        unsigned HP_USDHC2 : 1; //!< [26] Indicates the Privilege/User Mode for USDHC2
        unsigned L_USDHC2 : 1; //!< [27] Lock bit set by TZ software for HP_USDHC2.
        unsigned HP_USDHC3 : 1; //!< [28] Indicates the Privilege/User Mode for USDHC3
        unsigned L_USDHC3 : 1; //!< [29] Lock bit set by TZ software for HP_USDHC3.
        unsigned HP_USDHC4 : 1; //!< [30] Indicates the Privilege/User Mode for USDHC4.
        unsigned L_USDHC4 : 1; //!< [31] Lock bit set by TZ software for HP_USDHC4.
    } B;
} hw_csu_hp0_t;
#endif

/*!
 * @name Constants and macros for entire CSU_HP0 register
 */
//@{
#define HW_CSU_HP0_ADDR      (REGS_CSU_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_HP0           (*(volatile hw_csu_hp0_t *) HW_CSU_HP0_ADDR)
#define HW_CSU_HP0_RD()      (HW_CSU_HP0.U)
#define HW_CSU_HP0_WR(v)     (HW_CSU_HP0.U = (v))
#define HW_CSU_HP0_SET(v)    (HW_CSU_HP0_WR(HW_CSU_HP0_RD() |  (v)))
#define HW_CSU_HP0_CLR(v)    (HW_CSU_HP0_WR(HW_CSU_HP0_RD() & ~(v)))
#define HW_CSU_HP0_TOG(v)    (HW_CSU_HP0_WR(HW_CSU_HP0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_HP0 bitfields
 */

/*! @name Register CSU_HP0, field HP_PCIE[0] (RW)
 *
 * Indicates the Privilege/User Mode for PCIE
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_PCIE      (0)      //!< Bit position for CSU_HP0_HP_PCIE.
#define BM_CSU_HP0_HP_PCIE      (0x00000001)  //!< Bit mask for CSU_HP0_HP_PCIE.

//! @brief Get value of CSU_HP0_HP_PCIE from a register value.
#define BG_CSU_HP0_HP_PCIE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_PCIE) >> BP_CSU_HP0_HP_PCIE)

//! @brief Format value for bitfield CSU_HP0_HP_PCIE.
#define BF_CSU_HP0_HP_PCIE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_PCIE) & BM_CSU_HP0_HP_PCIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_PCIE field to a new value.
#define BW_CSU_HP0_HP_PCIE(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_PCIE) | BF_CSU_HP0_HP_PCIE(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_PCIE[1] (RW)
 *
 * Lock bit set by TZ software for HP_PCIE.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_PCIE      (1)      //!< Bit position for CSU_HP0_L_PCIE.
#define BM_CSU_HP0_L_PCIE      (0x00000002)  //!< Bit mask for CSU_HP0_L_PCIE.

//! @brief Get value of CSU_HP0_L_PCIE from a register value.
#define BG_CSU_HP0_L_PCIE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_PCIE) >> BP_CSU_HP0_L_PCIE)

//! @brief Format value for bitfield CSU_HP0_L_PCIE.
#define BF_CSU_HP0_L_PCIE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_PCIE) & BM_CSU_HP0_L_PCIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PCIE field to a new value.
#define BW_CSU_HP0_L_PCIE(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_PCIE) | BF_CSU_HP0_L_PCIE(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_SATA[2] (RW)
 *
 * Indicates the Privilege/User Mode for SATA This bit field is Reserved for i.MX6SDL
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_SATA      (2)      //!< Bit position for CSU_HP0_HP_SATA.
#define BM_CSU_HP0_HP_SATA      (0x00000004)  //!< Bit mask for CSU_HP0_HP_SATA.

//! @brief Get value of CSU_HP0_HP_SATA from a register value.
#define BG_CSU_HP0_HP_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_SATA) >> BP_CSU_HP0_HP_SATA)

//! @brief Format value for bitfield CSU_HP0_HP_SATA.
#define BF_CSU_HP0_HP_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_SATA) & BM_CSU_HP0_HP_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_SATA field to a new value.
#define BW_CSU_HP0_HP_SATA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_SATA) | BF_CSU_HP0_HP_SATA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_SATA[3] (RW)
 *
 * Lock bit set by TZ software for HP_SATA. This bit field is Reserved for i.MX6SDL
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_SATA      (3)      //!< Bit position for CSU_HP0_L_SATA.
#define BM_CSU_HP0_L_SATA      (0x00000008)  //!< Bit mask for CSU_HP0_L_SATA.

//! @brief Get value of CSU_HP0_L_SATA from a register value.
#define BG_CSU_HP0_L_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_SATA) >> BP_CSU_HP0_L_SATA)

//! @brief Format value for bitfield CSU_HP0_L_SATA.
#define BF_CSU_HP0_L_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_SATA) & BM_CSU_HP0_L_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SATA field to a new value.
#define BW_CSU_HP0_L_SATA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_SATA) | BF_CSU_HP0_L_SATA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_SDMA[4] (RW)
 *
 * Indicates the Privilege/User Mode for SDMA.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_SDMA      (4)      //!< Bit position for CSU_HP0_HP_SDMA.
#define BM_CSU_HP0_HP_SDMA      (0x00000010)  //!< Bit mask for CSU_HP0_HP_SDMA.

//! @brief Get value of CSU_HP0_HP_SDMA from a register value.
#define BG_CSU_HP0_HP_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_SDMA) >> BP_CSU_HP0_HP_SDMA)

//! @brief Format value for bitfield CSU_HP0_HP_SDMA.
#define BF_CSU_HP0_HP_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_SDMA) & BM_CSU_HP0_HP_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_SDMA field to a new value.
#define BW_CSU_HP0_HP_SDMA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_SDMA) | BF_CSU_HP0_HP_SDMA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_SDMA[5] (RW)
 *
 * Lock bit set by TZ software for HP_SDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_SDMA      (5)      //!< Bit position for CSU_HP0_L_SDMA.
#define BM_CSU_HP0_L_SDMA      (0x00000020)  //!< Bit mask for CSU_HP0_L_SDMA.

//! @brief Get value of CSU_HP0_L_SDMA from a register value.
#define BG_CSU_HP0_L_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_SDMA) >> BP_CSU_HP0_L_SDMA)

//! @brief Format value for bitfield CSU_HP0_L_SDMA.
#define BF_CSU_HP0_L_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_SDMA) & BM_CSU_HP0_L_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SDMA field to a new value.
#define BW_CSU_HP0_L_SDMA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_SDMA) | BF_CSU_HP0_L_SDMA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_PU[6] (RW)
 *
 * Indicates the Privilege/User Mode for GPU3D, GPU2D, VPU, IPU1, EPDC, PXP, LCDIF and VDOA.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_PU      (6)      //!< Bit position for CSU_HP0_HP_PU.
#define BM_CSU_HP0_HP_PU      (0x00000040)  //!< Bit mask for CSU_HP0_HP_PU.

//! @brief Get value of CSU_HP0_HP_PU from a register value.
#define BG_CSU_HP0_HP_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_PU) >> BP_CSU_HP0_HP_PU)

//! @brief Format value for bitfield CSU_HP0_HP_PU.
#define BF_CSU_HP0_HP_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_PU) & BM_CSU_HP0_HP_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_PU field to a new value.
#define BW_CSU_HP0_HP_PU(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_PU) | BF_CSU_HP0_HP_PU(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_PU[7] (RW)
 *
 * Lock bit set by TZ software for HP_PU.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_PU      (7)      //!< Bit position for CSU_HP0_L_PU.
#define BM_CSU_HP0_L_PU      (0x00000080)  //!< Bit mask for CSU_HP0_L_PU.

//! @brief Get value of CSU_HP0_L_PU from a register value.
#define BG_CSU_HP0_L_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_PU) >> BP_CSU_HP0_L_PU)

//! @brief Format value for bitfield CSU_HP0_L_PU.
#define BF_CSU_HP0_L_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_PU) & BM_CSU_HP0_L_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PU field to a new value.
#define BW_CSU_HP0_L_PU(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_PU) | BF_CSU_HP0_L_PU(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_USB[8] (RW)
 *
 * Indicates the Privilege/User Mode for USB.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_USB      (8)      //!< Bit position for CSU_HP0_HP_USB.
#define BM_CSU_HP0_HP_USB      (0x00000100)  //!< Bit mask for CSU_HP0_HP_USB.

//! @brief Get value of CSU_HP0_HP_USB from a register value.
#define BG_CSU_HP0_HP_USB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_USB) >> BP_CSU_HP0_HP_USB)

//! @brief Format value for bitfield CSU_HP0_HP_USB.
#define BF_CSU_HP0_HP_USB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_USB) & BM_CSU_HP0_HP_USB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_USB field to a new value.
#define BW_CSU_HP0_HP_USB(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_USB) | BF_CSU_HP0_HP_USB(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_USB[9] (RW)
 *
 * Lock bit set by TZ software for HP_USB.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_USB      (9)      //!< Bit position for CSU_HP0_L_USB.
#define BM_CSU_HP0_L_USB      (0x00000200)  //!< Bit mask for CSU_HP0_L_USB.

//! @brief Get value of CSU_HP0_L_USB from a register value.
#define BG_CSU_HP0_L_USB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_USB) >> BP_CSU_HP0_L_USB)

//! @brief Format value for bitfield CSU_HP0_L_USB.
#define BF_CSU_HP0_L_USB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_USB) & BM_CSU_HP0_L_USB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USB field to a new value.
#define BW_CSU_HP0_L_USB(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_USB) | BF_CSU_HP0_L_USB(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_TEST[10] (RW)
 *
 * Indicates the Privilege/User Mode for IOMUX Test Port.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_TEST      (10)      //!< Bit position for CSU_HP0_HP_TEST.
#define BM_CSU_HP0_HP_TEST      (0x00000400)  //!< Bit mask for CSU_HP0_HP_TEST.

//! @brief Get value of CSU_HP0_HP_TEST from a register value.
#define BG_CSU_HP0_HP_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_TEST) >> BP_CSU_HP0_HP_TEST)

//! @brief Format value for bitfield CSU_HP0_HP_TEST.
#define BF_CSU_HP0_HP_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_TEST) & BM_CSU_HP0_HP_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_TEST field to a new value.
#define BW_CSU_HP0_HP_TEST(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_TEST) | BF_CSU_HP0_HP_TEST(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_TEST[11] (RW)
 *
 * Lock bit set by TZ software for HP_TEST.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_TEST      (11)      //!< Bit position for CSU_HP0_L_TEST.
#define BM_CSU_HP0_L_TEST      (0x00000800)  //!< Bit mask for CSU_HP0_L_TEST.

//! @brief Get value of CSU_HP0_L_TEST from a register value.
#define BG_CSU_HP0_L_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_TEST) >> BP_CSU_HP0_L_TEST)

//! @brief Format value for bitfield CSU_HP0_L_TEST.
#define BF_CSU_HP0_L_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_TEST) & BM_CSU_HP0_L_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_TEST field to a new value.
#define BW_CSU_HP0_L_TEST(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_TEST) | BF_CSU_HP0_L_TEST(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_MLB[12] (RW)
 *
 * Indicate the mode Privilege/User Mode for MLB.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_MLB      (12)      //!< Bit position for CSU_HP0_HP_MLB.
#define BM_CSU_HP0_HP_MLB      (0x00001000)  //!< Bit mask for CSU_HP0_HP_MLB.

//! @brief Get value of CSU_HP0_HP_MLB from a register value.
#define BG_CSU_HP0_HP_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_MLB) >> BP_CSU_HP0_HP_MLB)

//! @brief Format value for bitfield CSU_HP0_HP_MLB.
#define BF_CSU_HP0_HP_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_MLB) & BM_CSU_HP0_HP_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_MLB field to a new value.
#define BW_CSU_HP0_HP_MLB(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_MLB) | BF_CSU_HP0_HP_MLB(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_MLB[13] (RW)
 *
 * Lock bit set by TZ software for HP_MLB.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_MLB      (13)      //!< Bit position for CSU_HP0_L_MLB.
#define BM_CSU_HP0_L_MLB      (0x00002000)  //!< Bit mask for CSU_HP0_L_MLB.

//! @brief Get value of CSU_HP0_L_MLB from a register value.
#define BG_CSU_HP0_L_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_MLB) >> BP_CSU_HP0_L_MLB)

//! @brief Format value for bitfield CSU_HP0_L_MLB.
#define BF_CSU_HP0_L_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_MLB) & BM_CSU_HP0_L_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_MLB field to a new value.
#define BW_CSU_HP0_L_MLB(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_MLB) | BF_CSU_HP0_L_MLB(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_CAAM[14] (RW)
 *
 * Indicates the Privilege/User Mode for CAAM
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_CAAM      (14)      //!< Bit position for CSU_HP0_HP_CAAM.
#define BM_CSU_HP0_HP_CAAM      (0x00004000)  //!< Bit mask for CSU_HP0_HP_CAAM.

//! @brief Get value of CSU_HP0_HP_CAAM from a register value.
#define BG_CSU_HP0_HP_CAAM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_CAAM) >> BP_CSU_HP0_HP_CAAM)

//! @brief Format value for bitfield CSU_HP0_HP_CAAM.
#define BF_CSU_HP0_HP_CAAM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_CAAM) & BM_CSU_HP0_HP_CAAM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_CAAM field to a new value.
#define BW_CSU_HP0_HP_CAAM(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_CAAM) | BF_CSU_HP0_HP_CAAM(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_CAAM[15] (RW)
 *
 * Lock bit set by TZ software for HP_CAAM.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_CAAM      (15)      //!< Bit position for CSU_HP0_L_CAAM.
#define BM_CSU_HP0_L_CAAM      (0x00008000)  //!< Bit mask for CSU_HP0_L_CAAM.

//! @brief Get value of CSU_HP0_L_CAAM from a register value.
#define BG_CSU_HP0_L_CAAM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_CAAM) >> BP_CSU_HP0_L_CAAM)

//! @brief Format value for bitfield CSU_HP0_L_CAAM.
#define BF_CSU_HP0_L_CAAM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_CAAM) & BM_CSU_HP0_L_CAAM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_CAAM field to a new value.
#define BW_CSU_HP0_L_CAAM(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_CAAM) | BF_CSU_HP0_L_CAAM(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_RAWNAND[16] (RW)
 *
 * Indicates the Privilege/User Mode for RawNAND
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_RAWNAND      (16)      //!< Bit position for CSU_HP0_HP_RAWNAND.
#define BM_CSU_HP0_HP_RAWNAND      (0x00010000)  //!< Bit mask for CSU_HP0_HP_RAWNAND.

//! @brief Get value of CSU_HP0_HP_RAWNAND from a register value.
#define BG_CSU_HP0_HP_RAWNAND(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_RAWNAND) >> BP_CSU_HP0_HP_RAWNAND)

//! @brief Format value for bitfield CSU_HP0_HP_RAWNAND.
#define BF_CSU_HP0_HP_RAWNAND(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_RAWNAND) & BM_CSU_HP0_HP_RAWNAND)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_RAWNAND field to a new value.
#define BW_CSU_HP0_HP_RAWNAND(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_RAWNAND) | BF_CSU_HP0_HP_RAWNAND(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_RAWNAND[17] (RW)
 *
 * Lock bit set by TZ software for HP_RAWNAND.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_RAWNAND      (17)      //!< Bit position for CSU_HP0_L_RAWNAND.
#define BM_CSU_HP0_L_RAWNAND      (0x00020000)  //!< Bit mask for CSU_HP0_L_RAWNAND.

//! @brief Get value of CSU_HP0_L_RAWNAND from a register value.
#define BG_CSU_HP0_L_RAWNAND(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_RAWNAND) >> BP_CSU_HP0_L_RAWNAND)

//! @brief Format value for bitfield CSU_HP0_L_RAWNAND.
#define BF_CSU_HP0_L_RAWNAND(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_RAWNAND) & BM_CSU_HP0_L_RAWNAND)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_RAWNAND field to a new value.
#define BW_CSU_HP0_L_RAWNAND(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_RAWNAND) | BF_CSU_HP0_L_RAWNAND(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_APBHDMA[18] (RW)
 *
 * Indicates the Privilege/User Mode for APBHDMA
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_APBHDMA      (18)      //!< Bit position for CSU_HP0_HP_APBHDMA.
#define BM_CSU_HP0_HP_APBHDMA      (0x00040000)  //!< Bit mask for CSU_HP0_HP_APBHDMA.

//! @brief Get value of CSU_HP0_HP_APBHDMA from a register value.
#define BG_CSU_HP0_HP_APBHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_APBHDMA) >> BP_CSU_HP0_HP_APBHDMA)

//! @brief Format value for bitfield CSU_HP0_HP_APBHDMA.
#define BF_CSU_HP0_HP_APBHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_APBHDMA) & BM_CSU_HP0_HP_APBHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_APBHDMA field to a new value.
#define BW_CSU_HP0_HP_APBHDMA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_APBHDMA) | BF_CSU_HP0_HP_APBHDMA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_ABPHDMA[19] (RW)
 *
 * Lock bit set by TZ software for HP_APBHDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_ABPHDMA      (19)      //!< Bit position for CSU_HP0_L_ABPHDMA.
#define BM_CSU_HP0_L_ABPHDMA      (0x00080000)  //!< Bit mask for CSU_HP0_L_ABPHDMA.

//! @brief Get value of CSU_HP0_L_ABPHDMA from a register value.
#define BG_CSU_HP0_L_ABPHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_ABPHDMA) >> BP_CSU_HP0_L_ABPHDMA)

//! @brief Format value for bitfield CSU_HP0_L_ABPHDMA.
#define BF_CSU_HP0_L_ABPHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_ABPHDMA) & BM_CSU_HP0_L_ABPHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_ABPHDMA field to a new value.
#define BW_CSU_HP0_L_ABPHDMA(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_ABPHDMA) | BF_CSU_HP0_L_ABPHDMA(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_ENET[20] (RW)
 *
 * Indicates the Privilege/User Mode for ENET
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_ENET      (20)      //!< Bit position for CSU_HP0_HP_ENET.
#define BM_CSU_HP0_HP_ENET      (0x00100000)  //!< Bit mask for CSU_HP0_HP_ENET.

//! @brief Get value of CSU_HP0_HP_ENET from a register value.
#define BG_CSU_HP0_HP_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_ENET) >> BP_CSU_HP0_HP_ENET)

//! @brief Format value for bitfield CSU_HP0_HP_ENET.
#define BF_CSU_HP0_HP_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_ENET) & BM_CSU_HP0_HP_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_ENET field to a new value.
#define BW_CSU_HP0_HP_ENET(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_ENET) | BF_CSU_HP0_HP_ENET(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_ENET[21] (RW)
 *
 * Lock bit set by TZ software for HP_ENET.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_ENET      (21)      //!< Bit position for CSU_HP0_L_ENET.
#define BM_CSU_HP0_L_ENET      (0x00200000)  //!< Bit mask for CSU_HP0_L_ENET.

//! @brief Get value of CSU_HP0_L_ENET from a register value.
#define BG_CSU_HP0_L_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_ENET) >> BP_CSU_HP0_L_ENET)

//! @brief Format value for bitfield CSU_HP0_L_ENET.
#define BF_CSU_HP0_L_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_ENET) & BM_CSU_HP0_L_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_ENET field to a new value.
#define BW_CSU_HP0_L_ENET(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_ENET) | BF_CSU_HP0_L_ENET(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_DAP[22] (RW)
 *
 * Indicates the Privilege/User Mode for DAP
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_DAP      (22)      //!< Bit position for CSU_HP0_HP_DAP.
#define BM_CSU_HP0_HP_DAP      (0x00400000)  //!< Bit mask for CSU_HP0_HP_DAP.

//! @brief Get value of CSU_HP0_HP_DAP from a register value.
#define BG_CSU_HP0_HP_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_DAP) >> BP_CSU_HP0_HP_DAP)

//! @brief Format value for bitfield CSU_HP0_HP_DAP.
#define BF_CSU_HP0_HP_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_DAP) & BM_CSU_HP0_HP_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_DAP field to a new value.
#define BW_CSU_HP0_HP_DAP(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_DAP) | BF_CSU_HP0_HP_DAP(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_DAP[23] (RW)
 *
 * Lock bit set by TZ software for HP_DAP.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_DAP      (23)      //!< Bit position for CSU_HP0_L_DAP.
#define BM_CSU_HP0_L_DAP      (0x00800000)  //!< Bit mask for CSU_HP0_L_DAP.

//! @brief Get value of CSU_HP0_L_DAP from a register value.
#define BG_CSU_HP0_L_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_DAP) >> BP_CSU_HP0_L_DAP)

//! @brief Format value for bitfield CSU_HP0_L_DAP.
#define BF_CSU_HP0_L_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_DAP) & BM_CSU_HP0_L_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_DAP field to a new value.
#define BW_CSU_HP0_L_DAP(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_DAP) | BF_CSU_HP0_L_DAP(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_USDHC1[24] (RW)
 *
 * Indicates the Privilege/User Mode for USDHC1
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_USDHC1      (24)      //!< Bit position for CSU_HP0_HP_USDHC1.
#define BM_CSU_HP0_HP_USDHC1      (0x01000000)  //!< Bit mask for CSU_HP0_HP_USDHC1.

//! @brief Get value of CSU_HP0_HP_USDHC1 from a register value.
#define BG_CSU_HP0_HP_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_USDHC1) >> BP_CSU_HP0_HP_USDHC1)

//! @brief Format value for bitfield CSU_HP0_HP_USDHC1.
#define BF_CSU_HP0_HP_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_USDHC1) & BM_CSU_HP0_HP_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_USDHC1 field to a new value.
#define BW_CSU_HP0_HP_USDHC1(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_USDHC1) | BF_CSU_HP0_HP_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_USDHC1[25] (RW)
 *
 * Lock bit set by TZ software for HP_USDHC1.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_USDHC1      (25)      //!< Bit position for CSU_HP0_L_USDHC1.
#define BM_CSU_HP0_L_USDHC1      (0x02000000)  //!< Bit mask for CSU_HP0_L_USDHC1.

//! @brief Get value of CSU_HP0_L_USDHC1 from a register value.
#define BG_CSU_HP0_L_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_USDHC1) >> BP_CSU_HP0_L_USDHC1)

//! @brief Format value for bitfield CSU_HP0_L_USDHC1.
#define BF_CSU_HP0_L_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_USDHC1) & BM_CSU_HP0_L_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC1 field to a new value.
#define BW_CSU_HP0_L_USDHC1(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_USDHC1) | BF_CSU_HP0_L_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_USDHC2[26] (RW)
 *
 * Indicates the Privilege/User Mode for USDHC2
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_USDHC2      (26)      //!< Bit position for CSU_HP0_HP_USDHC2.
#define BM_CSU_HP0_HP_USDHC2      (0x04000000)  //!< Bit mask for CSU_HP0_HP_USDHC2.

//! @brief Get value of CSU_HP0_HP_USDHC2 from a register value.
#define BG_CSU_HP0_HP_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_USDHC2) >> BP_CSU_HP0_HP_USDHC2)

//! @brief Format value for bitfield CSU_HP0_HP_USDHC2.
#define BF_CSU_HP0_HP_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_USDHC2) & BM_CSU_HP0_HP_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_USDHC2 field to a new value.
#define BW_CSU_HP0_HP_USDHC2(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_USDHC2) | BF_CSU_HP0_HP_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_USDHC2[27] (RW)
 *
 * Lock bit set by TZ software for HP_USDHC2.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_USDHC2      (27)      //!< Bit position for CSU_HP0_L_USDHC2.
#define BM_CSU_HP0_L_USDHC2      (0x08000000)  //!< Bit mask for CSU_HP0_L_USDHC2.

//! @brief Get value of CSU_HP0_L_USDHC2 from a register value.
#define BG_CSU_HP0_L_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_USDHC2) >> BP_CSU_HP0_L_USDHC2)

//! @brief Format value for bitfield CSU_HP0_L_USDHC2.
#define BF_CSU_HP0_L_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_USDHC2) & BM_CSU_HP0_L_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC2 field to a new value.
#define BW_CSU_HP0_L_USDHC2(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_USDHC2) | BF_CSU_HP0_L_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_USDHC3[28] (RW)
 *
 * Indicates the Privilege/User Mode for USDHC3
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_USDHC3      (28)      //!< Bit position for CSU_HP0_HP_USDHC3.
#define BM_CSU_HP0_HP_USDHC3      (0x10000000)  //!< Bit mask for CSU_HP0_HP_USDHC3.

//! @brief Get value of CSU_HP0_HP_USDHC3 from a register value.
#define BG_CSU_HP0_HP_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_USDHC3) >> BP_CSU_HP0_HP_USDHC3)

//! @brief Format value for bitfield CSU_HP0_HP_USDHC3.
#define BF_CSU_HP0_HP_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_USDHC3) & BM_CSU_HP0_HP_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_USDHC3 field to a new value.
#define BW_CSU_HP0_HP_USDHC3(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_USDHC3) | BF_CSU_HP0_HP_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_USDHC3[29] (RW)
 *
 * Lock bit set by TZ software for HP_USDHC3.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_USDHC3      (29)      //!< Bit position for CSU_HP0_L_USDHC3.
#define BM_CSU_HP0_L_USDHC3      (0x20000000)  //!< Bit mask for CSU_HP0_L_USDHC3.

//! @brief Get value of CSU_HP0_L_USDHC3 from a register value.
#define BG_CSU_HP0_L_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_USDHC3) >> BP_CSU_HP0_L_USDHC3)

//! @brief Format value for bitfield CSU_HP0_L_USDHC3.
#define BF_CSU_HP0_L_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_USDHC3) & BM_CSU_HP0_L_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC3 field to a new value.
#define BW_CSU_HP0_L_USDHC3(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_USDHC3) | BF_CSU_HP0_L_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_HP0, field HP_USDHC4[30] (RW)
 *
 * Indicates the Privilege/User Mode for USDHC4.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP0_HP_USDHC4      (30)      //!< Bit position for CSU_HP0_HP_USDHC4.
#define BM_CSU_HP0_HP_USDHC4      (0x40000000)  //!< Bit mask for CSU_HP0_HP_USDHC4.

//! @brief Get value of CSU_HP0_HP_USDHC4 from a register value.
#define BG_CSU_HP0_HP_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_HP_USDHC4) >> BP_CSU_HP0_HP_USDHC4)

//! @brief Format value for bitfield CSU_HP0_HP_USDHC4.
#define BF_CSU_HP0_HP_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_HP_USDHC4) & BM_CSU_HP0_HP_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_USDHC4 field to a new value.
#define BW_CSU_HP0_HP_USDHC4(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_HP_USDHC4) | BF_CSU_HP0_HP_USDHC4(v)))
#endif
//@}

/*! @name Register CSU_HP0, field L_USDHC4[31] (RW)
 *
 * Lock bit set by TZ software for HP_USDHC4.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP0_L_USDHC4      (31)      //!< Bit position for CSU_HP0_L_USDHC4.
#define BM_CSU_HP0_L_USDHC4      (0x80000000)  //!< Bit mask for CSU_HP0_L_USDHC4.

//! @brief Get value of CSU_HP0_L_USDHC4 from a register value.
#define BG_CSU_HP0_L_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP0_L_USDHC4) >> BP_CSU_HP0_L_USDHC4)

//! @brief Format value for bitfield CSU_HP0_L_USDHC4.
#define BF_CSU_HP0_L_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP0_L_USDHC4) & BM_CSU_HP0_L_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC4 field to a new value.
#define BW_CSU_HP0_L_USDHC4(v)   (HW_CSU_HP0_WR((HW_CSU_HP0_RD() & ~BM_CSU_HP0_L_USDHC4) | BF_CSU_HP0_L_USDHC4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_HP1 - HP1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_HP1 - HP1 register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SCU_HP1 register is an expansion of the SCU_HP0 register. See SCU_HP0 register definition.
 */
typedef union _hw_csu_hp1
{
    reg32_t U;
    struct _hw_csu_hp1_bitfields
    {
        unsigned HP_HDMI_HSI : 1; //!< [0] Indicates the Privilege/User Mode for HDMI Tx and HSI.
        unsigned L_HDMI_HSI : 1; //!< [1] Lock bit set by TZ software for HP_HDMI_HSI.
        unsigned RESERVED0 : 30; //!< [31:2] Reserved.
    } B;
} hw_csu_hp1_t;
#endif

/*!
 * @name Constants and macros for entire CSU_HP1 register
 */
//@{
#define HW_CSU_HP1_ADDR      (REGS_CSU_BASE + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_HP1           (*(volatile hw_csu_hp1_t *) HW_CSU_HP1_ADDR)
#define HW_CSU_HP1_RD()      (HW_CSU_HP1.U)
#define HW_CSU_HP1_WR(v)     (HW_CSU_HP1.U = (v))
#define HW_CSU_HP1_SET(v)    (HW_CSU_HP1_WR(HW_CSU_HP1_RD() |  (v)))
#define HW_CSU_HP1_CLR(v)    (HW_CSU_HP1_WR(HW_CSU_HP1_RD() & ~(v)))
#define HW_CSU_HP1_TOG(v)    (HW_CSU_HP1_WR(HW_CSU_HP1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_HP1 bitfields
 */

/*! @name Register CSU_HP1, field HP_HDMI_HSI[0] (RW)
 *
 * Indicates the Privilege/User Mode for HDMI Tx and HSI.
 *
 * Values:
 * - 0 - User Mode for the corresponding master
 * - 1 - Supervisor Mode for the corresponding master
 */
//@{
#define BP_CSU_HP1_HP_HDMI_HSI      (0)      //!< Bit position for CSU_HP1_HP_HDMI_HSI.
#define BM_CSU_HP1_HP_HDMI_HSI      (0x00000001)  //!< Bit mask for CSU_HP1_HP_HDMI_HSI.

//! @brief Get value of CSU_HP1_HP_HDMI_HSI from a register value.
#define BG_CSU_HP1_HP_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP1_HP_HDMI_HSI) >> BP_CSU_HP1_HP_HDMI_HSI)

//! @brief Format value for bitfield CSU_HP1_HP_HDMI_HSI.
#define BF_CSU_HP1_HP_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP1_HP_HDMI_HSI) & BM_CSU_HP1_HP_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HP_HDMI_HSI field to a new value.
#define BW_CSU_HP1_HP_HDMI_HSI(v)   (HW_CSU_HP1_WR((HW_CSU_HP1_RD() & ~BM_CSU_HP1_HP_HDMI_HSI) | BF_CSU_HP1_HP_HDMI_HSI(v)))
#endif
//@}

/*! @name Register CSU_HP1, field L_HDMI_HSI[1] (RW)
 *
 * Lock bit set by TZ software for HP_HDMI_HSI.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HP1_L_HDMI_HSI      (1)      //!< Bit position for CSU_HP1_L_HDMI_HSI.
#define BM_CSU_HP1_L_HDMI_HSI      (0x00000002)  //!< Bit mask for CSU_HP1_L_HDMI_HSI.

//! @brief Get value of CSU_HP1_L_HDMI_HSI from a register value.
#define BG_CSU_HP1_L_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HP1_L_HDMI_HSI) >> BP_CSU_HP1_L_HDMI_HSI)

//! @brief Format value for bitfield CSU_HP1_L_HDMI_HSI.
#define BF_CSU_HP1_L_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HP1_L_HDMI_HSI) & BM_CSU_HP1_L_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_HDMI_HSI field to a new value.
#define BW_CSU_HP1_L_HDMI_HSI(v)   (HW_CSU_HP1_WR((HW_CSU_HP1_RD() & ~BM_CSU_HP1_L_HDMI_HSI) | BF_CSU_HP1_L_HDMI_HSI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_SA - Secure access register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_SA - Secure access register (RW)
 *
 * Reset value: 0x00000000
 *
 * The Secure Access register may be programmed to specify the access policy (either Secure or Non-
 * secure) for up to sixteen different masters. This register is used to set the access policy for
 * Type 1 masters which are incapable of setting the policy by themselves. The sixteen even bit
 * positions (CSU_SA[30,28,...,0]) in the register hold the policy indicator bits; while the odd bit
 * positions (CSU_SA[31,29,...,1]) contain lock bits which enable/disable writing to the
 * corresponding policy indicator bits.
 */
typedef union _hw_csu_sa
{
    reg32_t U;
    struct _hw_csu_sa_bitfields
    {
        unsigned NSA_CP15 : 1; //!< [0] Non-Secure Access Policy indicator bit
        unsigned L_CP15 : 1; //!< [1] Lock bit set by TZ software for NSA_CP15.
        unsigned NSA_SATA : 1; //!< [2] Non-Secure Access Policy indicator bit
        unsigned L_SATA : 1; //!< [3] Lock bit set by TZ software for NSA_SATA.
        unsigned NSA_SDMA : 1; //!< [4] Non-Secure Access Policy indicator bit
        unsigned L_SDMA : 1; //!< [5] Lock bit set by TZ software for NSA_SDMA.
        unsigned NSA_PU : 1; //!< [6] Non-Secure Access Policy indicator bit
        unsigned L_PU : 1; //!< [7] Lock bit set by TZ software for NSA_PU.
        unsigned NSA_USB_MLB : 1; //!< [8] Non-Secure Access Policy indicator bit
        unsigned L_USB_MLB : 1; //!< [9] Lock bit set by TZ software for NSA_USB_MLB.
        unsigned NSA_PCIE_TEST : 1; //!< [10] Non-Secure Access Policy indicator bit
        unsigned L_PCIE_TEST : 1; //!< [11] Lock bit set by TZ software for NSA_PCIE_TEST.
        unsigned RESERVED0 : 2; //!< [13:12] Reserved
        unsigned NSA_RAWNAND_APBHDMA : 1; //!< [14] Non-Secure Access Policy indicator bit
        unsigned L_RAWNAND_APBHDMA : 1; //!< [15] Lock bit set by TZ software for NSA_RAWNAND_APBHDMA.
        unsigned NSA_ENET : 1; //!< [16] Non-Secure Access Policy indicator bit
        unsigned L_ENET : 1; //!< [17] Lock bit set by TZ software for NSA_ENET.
        unsigned NSA_DAP : 1; //!< [18] Non-Secure Access Policy indicator bit ARM core platform DAP
        unsigned L_DAP : 1; //!< [19] Lock bit set by TZ software for NSA_DAP.
        unsigned NSA_USDHC1 : 1; //!< [20] Non-Secure Access Policy indicator bit
        unsigned L_USDHC1 : 1; //!< [21] Lock bit set by TZ software for NSA_USDHC1.
        unsigned NSA_USDHC2 : 1; //!< [22] Non-Secure Access Policy indicator bit
        unsigned L_USDHC2 : 1; //!< [23] Lock bit set by TZ software for NSA_USDHC2.
        unsigned NSA_USDHC3 : 1; //!< [24] Non-Secure Access Policy indicator bit
        unsigned L_USDHC3 : 1; //!< [25] Lock bit set by TZ software for NSA_USDHC3.
        unsigned NSA_USDHC4 : 1; //!< [26] Non-Secure Access Policy indicator bit
        unsigned L_USDHC4 : 1; //!< [27] Lock bit set by TZ software for NSA_USDHC14.
        unsigned NSA_HDMI_HSI : 1; //!< [28] Non-Secure Access Policy indicator bit
        unsigned L_HDMI_HSI : 1; //!< [29] Lock bit set by TZ software for NSA_HDMI_HSI.
        unsigned RESERVED1 : 2; //!< [31:30] Reserved
    } B;
} hw_csu_sa_t;
#endif

/*!
 * @name Constants and macros for entire CSU_SA register
 */
//@{
#define HW_CSU_SA_ADDR      (REGS_CSU_BASE + 0x218)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_SA           (*(volatile hw_csu_sa_t *) HW_CSU_SA_ADDR)
#define HW_CSU_SA_RD()      (HW_CSU_SA.U)
#define HW_CSU_SA_WR(v)     (HW_CSU_SA.U = (v))
#define HW_CSU_SA_SET(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() |  (v)))
#define HW_CSU_SA_CLR(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() & ~(v)))
#define HW_CSU_SA_TOG(v)    (HW_CSU_SA_WR(HW_CSU_SA_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_SA bitfields
 */

/*! @name Register CSU_SA, field NSA_CP15[0] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access to ARM CP15 register.
 *
 * Values:
 * - 0 - ARM CP15 register is accesible
 * - 1 - ARM CP15 register is not accesible
 */
//@{
#define BP_CSU_SA_NSA_CP15      (0)      //!< Bit position for CSU_SA_NSA_CP15.
#define BM_CSU_SA_NSA_CP15      (0x00000001)  //!< Bit mask for CSU_SA_NSA_CP15.

//! @brief Get value of CSU_SA_NSA_CP15 from a register value.
#define BG_CSU_SA_NSA_CP15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_CP15) >> BP_CSU_SA_NSA_CP15)

//! @brief Format value for bitfield CSU_SA_NSA_CP15.
#define BF_CSU_SA_NSA_CP15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_CP15) & BM_CSU_SA_NSA_CP15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_CP15 field to a new value.
#define BW_CSU_SA_NSA_CP15(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_CP15) | BF_CSU_SA_NSA_CP15(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_CP15[1] (RW)
 *
 * Lock bit set by TZ software for NSA_CP15.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_CP15      (1)      //!< Bit position for CSU_SA_L_CP15.
#define BM_CSU_SA_L_CP15      (0x00000002)  //!< Bit mask for CSU_SA_L_CP15.

//! @brief Get value of CSU_SA_L_CP15 from a register value.
#define BG_CSU_SA_L_CP15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_CP15) >> BP_CSU_SA_L_CP15)

//! @brief Format value for bitfield CSU_SA_L_CP15.
#define BF_CSU_SA_L_CP15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_CP15) & BM_CSU_SA_L_CP15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_CP15 field to a new value.
#define BW_CSU_SA_L_CP15(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_CP15) | BF_CSU_SA_L_CP15(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_SATA[2] (RW)
 *
 * Indicates the type of access (Secured/Non-Secured) for SATA This bit field is Reserved for
 * i.MX6SDL
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_SATA      (2)      //!< Bit position for CSU_SA_NSA_SATA.
#define BM_CSU_SA_NSA_SATA      (0x00000004)  //!< Bit mask for CSU_SA_NSA_SATA.

//! @brief Get value of CSU_SA_NSA_SATA from a register value.
#define BG_CSU_SA_NSA_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_SATA) >> BP_CSU_SA_NSA_SATA)

//! @brief Format value for bitfield CSU_SA_NSA_SATA.
#define BF_CSU_SA_NSA_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_SATA) & BM_CSU_SA_NSA_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_SATA field to a new value.
#define BW_CSU_SA_NSA_SATA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_SATA) | BF_CSU_SA_NSA_SATA(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_SATA[3] (RW)
 *
 * Lock bit set by TZ software for NSA_SATA. This bit field is Reserved for i.MX6SDL
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_SATA      (3)      //!< Bit position for CSU_SA_L_SATA.
#define BM_CSU_SA_L_SATA      (0x00000008)  //!< Bit mask for CSU_SA_L_SATA.

//! @brief Get value of CSU_SA_L_SATA from a register value.
#define BG_CSU_SA_L_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_SATA) >> BP_CSU_SA_L_SATA)

//! @brief Format value for bitfield CSU_SA_L_SATA.
#define BF_CSU_SA_L_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_SATA) & BM_CSU_SA_L_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SATA field to a new value.
#define BW_CSU_SA_L_SATA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_SATA) | BF_CSU_SA_L_SATA(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_SDMA[4] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for SDMA.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_SDMA      (4)      //!< Bit position for CSU_SA_NSA_SDMA.
#define BM_CSU_SA_NSA_SDMA      (0x00000010)  //!< Bit mask for CSU_SA_NSA_SDMA.

//! @brief Get value of CSU_SA_NSA_SDMA from a register value.
#define BG_CSU_SA_NSA_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_SDMA) >> BP_CSU_SA_NSA_SDMA)

//! @brief Format value for bitfield CSU_SA_NSA_SDMA.
#define BF_CSU_SA_NSA_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_SDMA) & BM_CSU_SA_NSA_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_SDMA field to a new value.
#define BW_CSU_SA_NSA_SDMA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_SDMA) | BF_CSU_SA_NSA_SDMA(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_SDMA[5] (RW)
 *
 * Lock bit set by TZ software for NSA_SDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_SDMA      (5)      //!< Bit position for CSU_SA_L_SDMA.
#define BM_CSU_SA_L_SDMA      (0x00000020)  //!< Bit mask for CSU_SA_L_SDMA.

//! @brief Get value of CSU_SA_L_SDMA from a register value.
#define BG_CSU_SA_L_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_SDMA) >> BP_CSU_SA_L_SDMA)

//! @brief Format value for bitfield CSU_SA_L_SDMA.
#define BF_CSU_SA_L_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_SDMA) & BM_CSU_SA_L_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SDMA field to a new value.
#define BW_CSU_SA_L_SDMA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_SDMA) | BF_CSU_SA_L_SDMA(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_PU[6] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for GPU3D, VDOA, GPU2D, IPU1, EPDC, PXP, LCDIF and
 * VPU.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_PU      (6)      //!< Bit position for CSU_SA_NSA_PU.
#define BM_CSU_SA_NSA_PU      (0x00000040)  //!< Bit mask for CSU_SA_NSA_PU.

//! @brief Get value of CSU_SA_NSA_PU from a register value.
#define BG_CSU_SA_NSA_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_PU) >> BP_CSU_SA_NSA_PU)

//! @brief Format value for bitfield CSU_SA_NSA_PU.
#define BF_CSU_SA_NSA_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_PU) & BM_CSU_SA_NSA_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_PU field to a new value.
#define BW_CSU_SA_NSA_PU(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_PU) | BF_CSU_SA_NSA_PU(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_PU[7] (RW)
 *
 * Lock bit set by TZ software for NSA_PU.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_PU      (7)      //!< Bit position for CSU_SA_L_PU.
#define BM_CSU_SA_L_PU      (0x00000080)  //!< Bit mask for CSU_SA_L_PU.

//! @brief Get value of CSU_SA_L_PU from a register value.
#define BG_CSU_SA_L_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_PU) >> BP_CSU_SA_L_PU)

//! @brief Format value for bitfield CSU_SA_L_PU.
#define BF_CSU_SA_L_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_PU) & BM_CSU_SA_L_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PU field to a new value.
#define BW_CSU_SA_L_PU(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_PU) | BF_CSU_SA_L_PU(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_USB_MLB[8] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for USB and MLB.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_USB_MLB      (8)      //!< Bit position for CSU_SA_NSA_USB_MLB.
#define BM_CSU_SA_NSA_USB_MLB      (0x00000100)  //!< Bit mask for CSU_SA_NSA_USB_MLB.

//! @brief Get value of CSU_SA_NSA_USB_MLB from a register value.
#define BG_CSU_SA_NSA_USB_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_USB_MLB) >> BP_CSU_SA_NSA_USB_MLB)

//! @brief Format value for bitfield CSU_SA_NSA_USB_MLB.
#define BF_CSU_SA_NSA_USB_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_USB_MLB) & BM_CSU_SA_NSA_USB_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_USB_MLB field to a new value.
#define BW_CSU_SA_NSA_USB_MLB(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_USB_MLB) | BF_CSU_SA_NSA_USB_MLB(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_USB_MLB[9] (RW)
 *
 * Lock bit set by TZ software for NSA_USB_MLB.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_USB_MLB      (9)      //!< Bit position for CSU_SA_L_USB_MLB.
#define BM_CSU_SA_L_USB_MLB      (0x00000200)  //!< Bit mask for CSU_SA_L_USB_MLB.

//! @brief Get value of CSU_SA_L_USB_MLB from a register value.
#define BG_CSU_SA_L_USB_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_USB_MLB) >> BP_CSU_SA_L_USB_MLB)

//! @brief Format value for bitfield CSU_SA_L_USB_MLB.
#define BF_CSU_SA_L_USB_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_USB_MLB) & BM_CSU_SA_L_USB_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USB_MLB field to a new value.
#define BW_CSU_SA_L_USB_MLB(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_USB_MLB) | BF_CSU_SA_L_USB_MLB(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_PCIE_TEST[10] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for PCIe and IOMUX Test Port.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_PCIE_TEST      (10)      //!< Bit position for CSU_SA_NSA_PCIE_TEST.
#define BM_CSU_SA_NSA_PCIE_TEST      (0x00000400)  //!< Bit mask for CSU_SA_NSA_PCIE_TEST.

//! @brief Get value of CSU_SA_NSA_PCIE_TEST from a register value.
#define BG_CSU_SA_NSA_PCIE_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_PCIE_TEST) >> BP_CSU_SA_NSA_PCIE_TEST)

//! @brief Format value for bitfield CSU_SA_NSA_PCIE_TEST.
#define BF_CSU_SA_NSA_PCIE_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_PCIE_TEST) & BM_CSU_SA_NSA_PCIE_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_PCIE_TEST field to a new value.
#define BW_CSU_SA_NSA_PCIE_TEST(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_PCIE_TEST) | BF_CSU_SA_NSA_PCIE_TEST(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_PCIE_TEST[11] (RW)
 *
 * Lock bit set by TZ software for NSA_PCIE_TEST.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_PCIE_TEST      (11)      //!< Bit position for CSU_SA_L_PCIE_TEST.
#define BM_CSU_SA_L_PCIE_TEST      (0x00000800)  //!< Bit mask for CSU_SA_L_PCIE_TEST.

//! @brief Get value of CSU_SA_L_PCIE_TEST from a register value.
#define BG_CSU_SA_L_PCIE_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_PCIE_TEST) >> BP_CSU_SA_L_PCIE_TEST)

//! @brief Format value for bitfield CSU_SA_L_PCIE_TEST.
#define BF_CSU_SA_L_PCIE_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_PCIE_TEST) & BM_CSU_SA_L_PCIE_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PCIE_TEST field to a new value.
#define BW_CSU_SA_L_PCIE_TEST(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_PCIE_TEST) | BF_CSU_SA_L_PCIE_TEST(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_RAWNAND_APBHDMA[14] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for RawNAND and apbhdmat.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_RAWNAND_APBHDMA      (14)      //!< Bit position for CSU_SA_NSA_RAWNAND_APBHDMA.
#define BM_CSU_SA_NSA_RAWNAND_APBHDMA      (0x00004000)  //!< Bit mask for CSU_SA_NSA_RAWNAND_APBHDMA.

//! @brief Get value of CSU_SA_NSA_RAWNAND_APBHDMA from a register value.
#define BG_CSU_SA_NSA_RAWNAND_APBHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_RAWNAND_APBHDMA) >> BP_CSU_SA_NSA_RAWNAND_APBHDMA)

//! @brief Format value for bitfield CSU_SA_NSA_RAWNAND_APBHDMA.
#define BF_CSU_SA_NSA_RAWNAND_APBHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_RAWNAND_APBHDMA) & BM_CSU_SA_NSA_RAWNAND_APBHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_RAWNAND_APBHDMA field to a new value.
#define BW_CSU_SA_NSA_RAWNAND_APBHDMA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_RAWNAND_APBHDMA) | BF_CSU_SA_NSA_RAWNAND_APBHDMA(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_RAWNAND_APBHDMA[15] (RW)
 *
 * Lock bit set by TZ software for NSA_RAWNAND_APBHDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_RAWNAND_APBHDMA      (15)      //!< Bit position for CSU_SA_L_RAWNAND_APBHDMA.
#define BM_CSU_SA_L_RAWNAND_APBHDMA      (0x00008000)  //!< Bit mask for CSU_SA_L_RAWNAND_APBHDMA.

//! @brief Get value of CSU_SA_L_RAWNAND_APBHDMA from a register value.
#define BG_CSU_SA_L_RAWNAND_APBHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_RAWNAND_APBHDMA) >> BP_CSU_SA_L_RAWNAND_APBHDMA)

//! @brief Format value for bitfield CSU_SA_L_RAWNAND_APBHDMA.
#define BF_CSU_SA_L_RAWNAND_APBHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_RAWNAND_APBHDMA) & BM_CSU_SA_L_RAWNAND_APBHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_RAWNAND_APBHDMA field to a new value.
#define BW_CSU_SA_L_RAWNAND_APBHDMA(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_RAWNAND_APBHDMA) | BF_CSU_SA_L_RAWNAND_APBHDMA(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_ENET[16] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for ENET.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_ENET      (16)      //!< Bit position for CSU_SA_NSA_ENET.
#define BM_CSU_SA_NSA_ENET      (0x00010000)  //!< Bit mask for CSU_SA_NSA_ENET.

//! @brief Get value of CSU_SA_NSA_ENET from a register value.
#define BG_CSU_SA_NSA_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_ENET) >> BP_CSU_SA_NSA_ENET)

//! @brief Format value for bitfield CSU_SA_NSA_ENET.
#define BF_CSU_SA_NSA_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_ENET) & BM_CSU_SA_NSA_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_ENET field to a new value.
#define BW_CSU_SA_NSA_ENET(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_ENET) | BF_CSU_SA_NSA_ENET(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_ENET[17] (RW)
 *
 * Lock bit set by TZ software for NSA_ENET.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_ENET      (17)      //!< Bit position for CSU_SA_L_ENET.
#define BM_CSU_SA_L_ENET      (0x00020000)  //!< Bit mask for CSU_SA_L_ENET.

//! @brief Get value of CSU_SA_L_ENET from a register value.
#define BG_CSU_SA_L_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_ENET) >> BP_CSU_SA_L_ENET)

//! @brief Format value for bitfield CSU_SA_L_ENET.
#define BF_CSU_SA_L_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_ENET) & BM_CSU_SA_L_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_ENET field to a new value.
#define BW_CSU_SA_L_ENET(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_ENET) | BF_CSU_SA_L_ENET(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_DAP[18] (RW)
 *
 * Access Policy indicator bits
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_DAP      (18)      //!< Bit position for CSU_SA_NSA_DAP.
#define BM_CSU_SA_NSA_DAP      (0x00040000)  //!< Bit mask for CSU_SA_NSA_DAP.

//! @brief Get value of CSU_SA_NSA_DAP from a register value.
#define BG_CSU_SA_NSA_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_DAP) >> BP_CSU_SA_NSA_DAP)

//! @brief Format value for bitfield CSU_SA_NSA_DAP.
#define BF_CSU_SA_NSA_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_DAP) & BM_CSU_SA_NSA_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_DAP field to a new value.
#define BW_CSU_SA_NSA_DAP(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_DAP) | BF_CSU_SA_NSA_DAP(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_DAP[19] (RW)
 *
 * Lock bit set by TZ software for NSA_DAP.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_DAP      (19)      //!< Bit position for CSU_SA_L_DAP.
#define BM_CSU_SA_L_DAP      (0x00080000)  //!< Bit mask for CSU_SA_L_DAP.

//! @brief Get value of CSU_SA_L_DAP from a register value.
#define BG_CSU_SA_L_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_DAP) >> BP_CSU_SA_L_DAP)

//! @brief Format value for bitfield CSU_SA_L_DAP.
#define BF_CSU_SA_L_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_DAP) & BM_CSU_SA_L_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_DAP field to a new value.
#define BW_CSU_SA_L_DAP(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_DAP) | BF_CSU_SA_L_DAP(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_USDHC1[20] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for USDHC1.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_USDHC1      (20)      //!< Bit position for CSU_SA_NSA_USDHC1.
#define BM_CSU_SA_NSA_USDHC1      (0x00100000)  //!< Bit mask for CSU_SA_NSA_USDHC1.

//! @brief Get value of CSU_SA_NSA_USDHC1 from a register value.
#define BG_CSU_SA_NSA_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_USDHC1) >> BP_CSU_SA_NSA_USDHC1)

//! @brief Format value for bitfield CSU_SA_NSA_USDHC1.
#define BF_CSU_SA_NSA_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_USDHC1) & BM_CSU_SA_NSA_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_USDHC1 field to a new value.
#define BW_CSU_SA_NSA_USDHC1(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_USDHC1) | BF_CSU_SA_NSA_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_USDHC1[21] (RW)
 *
 * Lock bit set by TZ software for NSA_USDHC1.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_USDHC1      (21)      //!< Bit position for CSU_SA_L_USDHC1.
#define BM_CSU_SA_L_USDHC1      (0x00200000)  //!< Bit mask for CSU_SA_L_USDHC1.

//! @brief Get value of CSU_SA_L_USDHC1 from a register value.
#define BG_CSU_SA_L_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_USDHC1) >> BP_CSU_SA_L_USDHC1)

//! @brief Format value for bitfield CSU_SA_L_USDHC1.
#define BF_CSU_SA_L_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_USDHC1) & BM_CSU_SA_L_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC1 field to a new value.
#define BW_CSU_SA_L_USDHC1(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_USDHC1) | BF_CSU_SA_L_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_USDHC2[22] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for USDHC2.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_USDHC2      (22)      //!< Bit position for CSU_SA_NSA_USDHC2.
#define BM_CSU_SA_NSA_USDHC2      (0x00400000)  //!< Bit mask for CSU_SA_NSA_USDHC2.

//! @brief Get value of CSU_SA_NSA_USDHC2 from a register value.
#define BG_CSU_SA_NSA_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_USDHC2) >> BP_CSU_SA_NSA_USDHC2)

//! @brief Format value for bitfield CSU_SA_NSA_USDHC2.
#define BF_CSU_SA_NSA_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_USDHC2) & BM_CSU_SA_NSA_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_USDHC2 field to a new value.
#define BW_CSU_SA_NSA_USDHC2(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_USDHC2) | BF_CSU_SA_NSA_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_USDHC2[23] (RW)
 *
 * Lock bit set by TZ software for NSA_USDHC2.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_USDHC2      (23)      //!< Bit position for CSU_SA_L_USDHC2.
#define BM_CSU_SA_L_USDHC2      (0x00800000)  //!< Bit mask for CSU_SA_L_USDHC2.

//! @brief Get value of CSU_SA_L_USDHC2 from a register value.
#define BG_CSU_SA_L_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_USDHC2) >> BP_CSU_SA_L_USDHC2)

//! @brief Format value for bitfield CSU_SA_L_USDHC2.
#define BF_CSU_SA_L_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_USDHC2) & BM_CSU_SA_L_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC2 field to a new value.
#define BW_CSU_SA_L_USDHC2(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_USDHC2) | BF_CSU_SA_L_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_USDHC3[24] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for USDHC3.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_USDHC3      (24)      //!< Bit position for CSU_SA_NSA_USDHC3.
#define BM_CSU_SA_NSA_USDHC3      (0x01000000)  //!< Bit mask for CSU_SA_NSA_USDHC3.

//! @brief Get value of CSU_SA_NSA_USDHC3 from a register value.
#define BG_CSU_SA_NSA_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_USDHC3) >> BP_CSU_SA_NSA_USDHC3)

//! @brief Format value for bitfield CSU_SA_NSA_USDHC3.
#define BF_CSU_SA_NSA_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_USDHC3) & BM_CSU_SA_NSA_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_USDHC3 field to a new value.
#define BW_CSU_SA_NSA_USDHC3(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_USDHC3) | BF_CSU_SA_NSA_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_USDHC3[25] (RW)
 *
 * Lock bit set by TZ software for NSA_USDHC3.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_USDHC3      (25)      //!< Bit position for CSU_SA_L_USDHC3.
#define BM_CSU_SA_L_USDHC3      (0x02000000)  //!< Bit mask for CSU_SA_L_USDHC3.

//! @brief Get value of CSU_SA_L_USDHC3 from a register value.
#define BG_CSU_SA_L_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_USDHC3) >> BP_CSU_SA_L_USDHC3)

//! @brief Format value for bitfield CSU_SA_L_USDHC3.
#define BF_CSU_SA_L_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_USDHC3) & BM_CSU_SA_L_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC3 field to a new value.
#define BW_CSU_SA_L_USDHC3(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_USDHC3) | BF_CSU_SA_L_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_USDHC4[26] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for USDHC4.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_USDHC4      (26)      //!< Bit position for CSU_SA_NSA_USDHC4.
#define BM_CSU_SA_NSA_USDHC4      (0x04000000)  //!< Bit mask for CSU_SA_NSA_USDHC4.

//! @brief Get value of CSU_SA_NSA_USDHC4 from a register value.
#define BG_CSU_SA_NSA_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_USDHC4) >> BP_CSU_SA_NSA_USDHC4)

//! @brief Format value for bitfield CSU_SA_NSA_USDHC4.
#define BF_CSU_SA_NSA_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_USDHC4) & BM_CSU_SA_NSA_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_USDHC4 field to a new value.
#define BW_CSU_SA_NSA_USDHC4(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_USDHC4) | BF_CSU_SA_NSA_USDHC4(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_USDHC4[27] (RW)
 *
 * Lock bit set by TZ software for NSA_USDHC14.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_USDHC4      (27)      //!< Bit position for CSU_SA_L_USDHC4.
#define BM_CSU_SA_L_USDHC4      (0x08000000)  //!< Bit mask for CSU_SA_L_USDHC4.

//! @brief Get value of CSU_SA_L_USDHC4 from a register value.
#define BG_CSU_SA_L_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_USDHC4) >> BP_CSU_SA_L_USDHC4)

//! @brief Format value for bitfield CSU_SA_L_USDHC4.
#define BF_CSU_SA_L_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_USDHC4) & BM_CSU_SA_L_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC4 field to a new value.
#define BW_CSU_SA_L_USDHC4(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_USDHC4) | BF_CSU_SA_L_USDHC4(v)))
#endif
//@}

/*! @name Register CSU_SA, field NSA_HDMI_HSI[28] (RW)
 *
 * Indicate the Type (Secured/Non-Secured) Access for HDMI Tx and HSI.
 *
 * Values:
 * - 0 - Secure access for the corresponding Type 1 master
 * - 1 - Non-secure access for the corresponding Type 1 master
 */
//@{
#define BP_CSU_SA_NSA_HDMI_HSI      (28)      //!< Bit position for CSU_SA_NSA_HDMI_HSI.
#define BM_CSU_SA_NSA_HDMI_HSI      (0x10000000)  //!< Bit mask for CSU_SA_NSA_HDMI_HSI.

//! @brief Get value of CSU_SA_NSA_HDMI_HSI from a register value.
#define BG_CSU_SA_NSA_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_NSA_HDMI_HSI) >> BP_CSU_SA_NSA_HDMI_HSI)

//! @brief Format value for bitfield CSU_SA_NSA_HDMI_HSI.
#define BF_CSU_SA_NSA_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_NSA_HDMI_HSI) & BM_CSU_SA_NSA_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NSA_HDMI_HSI field to a new value.
#define BW_CSU_SA_NSA_HDMI_HSI(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_NSA_HDMI_HSI) | BF_CSU_SA_NSA_HDMI_HSI(v)))
#endif
//@}

/*! @name Register CSU_SA, field L_HDMI_HSI[29] (RW)
 *
 * Lock bit set by TZ software for NSA_HDMI_HSI.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_SA_L_HDMI_HSI      (29)      //!< Bit position for CSU_SA_L_HDMI_HSI.
#define BM_CSU_SA_L_HDMI_HSI      (0x20000000)  //!< Bit mask for CSU_SA_L_HDMI_HSI.

//! @brief Get value of CSU_SA_L_HDMI_HSI from a register value.
#define BG_CSU_SA_L_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_SA_L_HDMI_HSI) >> BP_CSU_SA_L_HDMI_HSI)

//! @brief Format value for bitfield CSU_SA_L_HDMI_HSI.
#define BF_CSU_SA_L_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_SA_L_HDMI_HSI) & BM_CSU_SA_L_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_HDMI_HSI field to a new value.
#define BW_CSU_SA_L_HDMI_HSI(v)   (HW_CSU_SA_WR((HW_CSU_SA_RD() & ~BM_CSU_SA_L_HDMI_HSI) | BF_CSU_SA_L_HDMI_HSI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_HPCONTROL0 - HPCONTROL0 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_HPCONTROL0 - HPCONTROL0 register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HP Control registers CSU_HPCONTROL0 and CSU_HPCONTROL1 enable CSU to control the
 * USER/SUPERVISOR mode state for the specified masters. The register toggles the output signal
 * csu_hprot1 for system masters. The two possibilities sources for the csu_hprot1 output are: the
 * hprot1 input signal, or the corresponding bit in the HP register. The even bits in the registers
 * are used for locking the control bit values.
 */
typedef union _hw_csu_hpcontrol0
{
    reg32_t U;
    struct _hw_csu_hpcontrol0_bitfields
    {
        unsigned HPC_PCIE : 1; //!< [0] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of PCIE.
        unsigned L_PCIE : 1; //!< [1] Lock bit set by TZ software for HPC_PCIE.
        unsigned HPC_SATA : 1; //!< [2] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of SATA.
        unsigned L_SATA : 1; //!< [3] Lock bit set by TZ software for HPC_SATA.
        unsigned HPC_SDMA : 1; //!< [4] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of SDMA.
        unsigned L_SDMA : 1; //!< [5] Lock bit set by TZ software for HPC_SDMA.
        unsigned HPC_PU : 1; //!< [6] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of GPU3D, GPU2D, VPU, IPU1, EPDC, PXP, LCDIF and VDOA.
        unsigned L_PU : 1; //!< [7] Lock bit set by TZ software for HPC_PU.
        unsigned HPC_USB : 1; //!< [8] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of USB.
        unsigned L_USB : 1; //!< [9] Lock bit set by TZ software for HPC_USB.
        unsigned HPC_TEST : 1; //!< [10] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of IOMUX Test Port.
        unsigned L_TEST : 1; //!< [11] Lock bit set by TZ software for HPC_TEST.
        unsigned HPC_MLB : 1; //!< [12] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of MLB.
        unsigned L_MLB : 1; //!< [13] Lock bit set by TZ software for HPC_MLB.
        unsigned HPC_CAAM : 1; //!< [14] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of CAAM.
        unsigned L_CAAM : 1; //!< [15] Lock bit set by TZ software for HPC_CAAM.
        unsigned HPC_RAWNAND : 1; //!< [16] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of RawNAND.
        unsigned L_RAWNAND : 1; //!< [17] Lock bit set by TZ software for HPC_RAWNAND.
        unsigned HPC_APBHDMA : 1; //!< [18] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of apbhdma.
        unsigned L_ABPHDMA : 1; //!< [19] Lock bit set by TZ software for HPC_APBHDMA.
        unsigned HPC_ENET : 1; //!< [20] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of ENET.
        unsigned L_ENET : 1; //!< [21] Lock bit set by TZ software for HPC_ENET.
        unsigned HPC_DAP : 1; //!< [22] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of DAP.
        unsigned L_DAP : 1; //!< [23] Lock bit set by TZ software for HPC_DAP.
        unsigned HPC_USDHC1 : 1; //!< [24] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of USDHC1.
        unsigned L_USDHC1 : 1; //!< [25] Lock bit set by TZ software for HPC_USDHC1.
        unsigned HPC_USDHC2 : 1; //!< [26] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of USDHC2.
        unsigned L_USDHC2 : 1; //!< [27] Lock bit set by TZ software for HPC_USDHC2.
        unsigned HPC_USDHC3 : 1; //!< [28] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of USDHC3.
        unsigned L_USDHC3 : 1; //!< [29] Lock bit set by TZ software for HPC_USDHC3.
        unsigned HPC_USDHC4 : 1; //!< [30] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of USDHC4.
        unsigned L_USDHC4 : 1; //!< [31] Lock bit set by TZ software for HPC_USDHC4.
    } B;
} hw_csu_hpcontrol0_t;
#endif

/*!
 * @name Constants and macros for entire CSU_HPCONTROL0 register
 */
//@{
#define HW_CSU_HPCONTROL0_ADDR      (REGS_CSU_BASE + 0x358)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_HPCONTROL0           (*(volatile hw_csu_hpcontrol0_t *) HW_CSU_HPCONTROL0_ADDR)
#define HW_CSU_HPCONTROL0_RD()      (HW_CSU_HPCONTROL0.U)
#define HW_CSU_HPCONTROL0_WR(v)     (HW_CSU_HPCONTROL0.U = (v))
#define HW_CSU_HPCONTROL0_SET(v)    (HW_CSU_HPCONTROL0_WR(HW_CSU_HPCONTROL0_RD() |  (v)))
#define HW_CSU_HPCONTROL0_CLR(v)    (HW_CSU_HPCONTROL0_WR(HW_CSU_HPCONTROL0_RD() & ~(v)))
#define HW_CSU_HPCONTROL0_TOG(v)    (HW_CSU_HPCONTROL0_WR(HW_CSU_HPCONTROL0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_HPCONTROL0 bitfields
 */

/*! @name Register CSU_HPCONTROL0, field HPC_PCIE[0] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * PCIE.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_PCIE      (0)      //!< Bit position for CSU_HPCONTROL0_HPC_PCIE.
#define BM_CSU_HPCONTROL0_HPC_PCIE      (0x00000001)  //!< Bit mask for CSU_HPCONTROL0_HPC_PCIE.

//! @brief Get value of CSU_HPCONTROL0_HPC_PCIE from a register value.
#define BG_CSU_HPCONTROL0_HPC_PCIE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_PCIE) >> BP_CSU_HPCONTROL0_HPC_PCIE)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_PCIE.
#define BF_CSU_HPCONTROL0_HPC_PCIE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_PCIE) & BM_CSU_HPCONTROL0_HPC_PCIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_PCIE field to a new value.
#define BW_CSU_HPCONTROL0_HPC_PCIE(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_PCIE) | BF_CSU_HPCONTROL0_HPC_PCIE(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_PCIE[1] (RW)
 *
 * Lock bit set by TZ software for HPC_PCIE.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_PCIE      (1)      //!< Bit position for CSU_HPCONTROL0_L_PCIE.
#define BM_CSU_HPCONTROL0_L_PCIE      (0x00000002)  //!< Bit mask for CSU_HPCONTROL0_L_PCIE.

//! @brief Get value of CSU_HPCONTROL0_L_PCIE from a register value.
#define BG_CSU_HPCONTROL0_L_PCIE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_PCIE) >> BP_CSU_HPCONTROL0_L_PCIE)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_PCIE.
#define BF_CSU_HPCONTROL0_L_PCIE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_PCIE) & BM_CSU_HPCONTROL0_L_PCIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PCIE field to a new value.
#define BW_CSU_HPCONTROL0_L_PCIE(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_PCIE) | BF_CSU_HPCONTROL0_L_PCIE(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_SATA[2] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * SATA. This bit field is Reserved for i.MX6SDL
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_SATA      (2)      //!< Bit position for CSU_HPCONTROL0_HPC_SATA.
#define BM_CSU_HPCONTROL0_HPC_SATA      (0x00000004)  //!< Bit mask for CSU_HPCONTROL0_HPC_SATA.

//! @brief Get value of CSU_HPCONTROL0_HPC_SATA from a register value.
#define BG_CSU_HPCONTROL0_HPC_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_SATA) >> BP_CSU_HPCONTROL0_HPC_SATA)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_SATA.
#define BF_CSU_HPCONTROL0_HPC_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_SATA) & BM_CSU_HPCONTROL0_HPC_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_SATA field to a new value.
#define BW_CSU_HPCONTROL0_HPC_SATA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_SATA) | BF_CSU_HPCONTROL0_HPC_SATA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_SATA[3] (RW)
 *
 * Lock bit set by TZ software for HPC_SATA. This bit field is Reserved for i.MX6SDL
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_SATA      (3)      //!< Bit position for CSU_HPCONTROL0_L_SATA.
#define BM_CSU_HPCONTROL0_L_SATA      (0x00000008)  //!< Bit mask for CSU_HPCONTROL0_L_SATA.

//! @brief Get value of CSU_HPCONTROL0_L_SATA from a register value.
#define BG_CSU_HPCONTROL0_L_SATA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_SATA) >> BP_CSU_HPCONTROL0_L_SATA)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_SATA.
#define BF_CSU_HPCONTROL0_L_SATA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_SATA) & BM_CSU_HPCONTROL0_L_SATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SATA field to a new value.
#define BW_CSU_HPCONTROL0_L_SATA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_SATA) | BF_CSU_HPCONTROL0_L_SATA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_SDMA[4] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * SDMA.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_SDMA      (4)      //!< Bit position for CSU_HPCONTROL0_HPC_SDMA.
#define BM_CSU_HPCONTROL0_HPC_SDMA      (0x00000010)  //!< Bit mask for CSU_HPCONTROL0_HPC_SDMA.

//! @brief Get value of CSU_HPCONTROL0_HPC_SDMA from a register value.
#define BG_CSU_HPCONTROL0_HPC_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_SDMA) >> BP_CSU_HPCONTROL0_HPC_SDMA)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_SDMA.
#define BF_CSU_HPCONTROL0_HPC_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_SDMA) & BM_CSU_HPCONTROL0_HPC_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_SDMA field to a new value.
#define BW_CSU_HPCONTROL0_HPC_SDMA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_SDMA) | BF_CSU_HPCONTROL0_HPC_SDMA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_SDMA[5] (RW)
 *
 * Lock bit set by TZ software for HPC_SDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_SDMA      (5)      //!< Bit position for CSU_HPCONTROL0_L_SDMA.
#define BM_CSU_HPCONTROL0_L_SDMA      (0x00000020)  //!< Bit mask for CSU_HPCONTROL0_L_SDMA.

//! @brief Get value of CSU_HPCONTROL0_L_SDMA from a register value.
#define BG_CSU_HPCONTROL0_L_SDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_SDMA) >> BP_CSU_HPCONTROL0_L_SDMA)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_SDMA.
#define BF_CSU_HPCONTROL0_L_SDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_SDMA) & BM_CSU_HPCONTROL0_L_SDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_SDMA field to a new value.
#define BW_CSU_HPCONTROL0_L_SDMA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_SDMA) | BF_CSU_HPCONTROL0_L_SDMA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_PU[6] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * GPU3D, GPU2D, VPU, IPU1, EPDC, PXP, LCDIF and VDOA.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_PU      (6)      //!< Bit position for CSU_HPCONTROL0_HPC_PU.
#define BM_CSU_HPCONTROL0_HPC_PU      (0x00000040)  //!< Bit mask for CSU_HPCONTROL0_HPC_PU.

//! @brief Get value of CSU_HPCONTROL0_HPC_PU from a register value.
#define BG_CSU_HPCONTROL0_HPC_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_PU) >> BP_CSU_HPCONTROL0_HPC_PU)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_PU.
#define BF_CSU_HPCONTROL0_HPC_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_PU) & BM_CSU_HPCONTROL0_HPC_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_PU field to a new value.
#define BW_CSU_HPCONTROL0_HPC_PU(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_PU) | BF_CSU_HPCONTROL0_HPC_PU(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_PU[7] (RW)
 *
 * Lock bit set by TZ software for HPC_PU.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_PU      (7)      //!< Bit position for CSU_HPCONTROL0_L_PU.
#define BM_CSU_HPCONTROL0_L_PU      (0x00000080)  //!< Bit mask for CSU_HPCONTROL0_L_PU.

//! @brief Get value of CSU_HPCONTROL0_L_PU from a register value.
#define BG_CSU_HPCONTROL0_L_PU(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_PU) >> BP_CSU_HPCONTROL0_L_PU)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_PU.
#define BF_CSU_HPCONTROL0_L_PU(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_PU) & BM_CSU_HPCONTROL0_L_PU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_PU field to a new value.
#define BW_CSU_HPCONTROL0_L_PU(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_PU) | BF_CSU_HPCONTROL0_L_PU(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_USB[8] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * USB.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_USB      (8)      //!< Bit position for CSU_HPCONTROL0_HPC_USB.
#define BM_CSU_HPCONTROL0_HPC_USB      (0x00000100)  //!< Bit mask for CSU_HPCONTROL0_HPC_USB.

//! @brief Get value of CSU_HPCONTROL0_HPC_USB from a register value.
#define BG_CSU_HPCONTROL0_HPC_USB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_USB) >> BP_CSU_HPCONTROL0_HPC_USB)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_USB.
#define BF_CSU_HPCONTROL0_HPC_USB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_USB) & BM_CSU_HPCONTROL0_HPC_USB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_USB field to a new value.
#define BW_CSU_HPCONTROL0_HPC_USB(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_USB) | BF_CSU_HPCONTROL0_HPC_USB(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_USB[9] (RW)
 *
 * Lock bit set by TZ software for HPC_USB.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_USB      (9)      //!< Bit position for CSU_HPCONTROL0_L_USB.
#define BM_CSU_HPCONTROL0_L_USB      (0x00000200)  //!< Bit mask for CSU_HPCONTROL0_L_USB.

//! @brief Get value of CSU_HPCONTROL0_L_USB from a register value.
#define BG_CSU_HPCONTROL0_L_USB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_USB) >> BP_CSU_HPCONTROL0_L_USB)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_USB.
#define BF_CSU_HPCONTROL0_L_USB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_USB) & BM_CSU_HPCONTROL0_L_USB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USB field to a new value.
#define BW_CSU_HPCONTROL0_L_USB(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_USB) | BF_CSU_HPCONTROL0_L_USB(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_TEST[10] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * IOMUX Test Port.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_TEST      (10)      //!< Bit position for CSU_HPCONTROL0_HPC_TEST.
#define BM_CSU_HPCONTROL0_HPC_TEST      (0x00000400)  //!< Bit mask for CSU_HPCONTROL0_HPC_TEST.

//! @brief Get value of CSU_HPCONTROL0_HPC_TEST from a register value.
#define BG_CSU_HPCONTROL0_HPC_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_TEST) >> BP_CSU_HPCONTROL0_HPC_TEST)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_TEST.
#define BF_CSU_HPCONTROL0_HPC_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_TEST) & BM_CSU_HPCONTROL0_HPC_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_TEST field to a new value.
#define BW_CSU_HPCONTROL0_HPC_TEST(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_TEST) | BF_CSU_HPCONTROL0_HPC_TEST(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_TEST[11] (RW)
 *
 * Lock bit set by TZ software for HPC_TEST.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_TEST      (11)      //!< Bit position for CSU_HPCONTROL0_L_TEST.
#define BM_CSU_HPCONTROL0_L_TEST      (0x00000800)  //!< Bit mask for CSU_HPCONTROL0_L_TEST.

//! @brief Get value of CSU_HPCONTROL0_L_TEST from a register value.
#define BG_CSU_HPCONTROL0_L_TEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_TEST) >> BP_CSU_HPCONTROL0_L_TEST)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_TEST.
#define BF_CSU_HPCONTROL0_L_TEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_TEST) & BM_CSU_HPCONTROL0_L_TEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_TEST field to a new value.
#define BW_CSU_HPCONTROL0_L_TEST(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_TEST) | BF_CSU_HPCONTROL0_L_TEST(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_MLB[12] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * MLB.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_MLB      (12)      //!< Bit position for CSU_HPCONTROL0_HPC_MLB.
#define BM_CSU_HPCONTROL0_HPC_MLB      (0x00001000)  //!< Bit mask for CSU_HPCONTROL0_HPC_MLB.

//! @brief Get value of CSU_HPCONTROL0_HPC_MLB from a register value.
#define BG_CSU_HPCONTROL0_HPC_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_MLB) >> BP_CSU_HPCONTROL0_HPC_MLB)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_MLB.
#define BF_CSU_HPCONTROL0_HPC_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_MLB) & BM_CSU_HPCONTROL0_HPC_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_MLB field to a new value.
#define BW_CSU_HPCONTROL0_HPC_MLB(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_MLB) | BF_CSU_HPCONTROL0_HPC_MLB(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_MLB[13] (RW)
 *
 * Lock bit set by TZ software for HPC_MLB.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_MLB      (13)      //!< Bit position for CSU_HPCONTROL0_L_MLB.
#define BM_CSU_HPCONTROL0_L_MLB      (0x00002000)  //!< Bit mask for CSU_HPCONTROL0_L_MLB.

//! @brief Get value of CSU_HPCONTROL0_L_MLB from a register value.
#define BG_CSU_HPCONTROL0_L_MLB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_MLB) >> BP_CSU_HPCONTROL0_L_MLB)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_MLB.
#define BF_CSU_HPCONTROL0_L_MLB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_MLB) & BM_CSU_HPCONTROL0_L_MLB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_MLB field to a new value.
#define BW_CSU_HPCONTROL0_L_MLB(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_MLB) | BF_CSU_HPCONTROL0_L_MLB(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_CAAM[14] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * CAAM.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_CAAM      (14)      //!< Bit position for CSU_HPCONTROL0_HPC_CAAM.
#define BM_CSU_HPCONTROL0_HPC_CAAM      (0x00004000)  //!< Bit mask for CSU_HPCONTROL0_HPC_CAAM.

//! @brief Get value of CSU_HPCONTROL0_HPC_CAAM from a register value.
#define BG_CSU_HPCONTROL0_HPC_CAAM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_CAAM) >> BP_CSU_HPCONTROL0_HPC_CAAM)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_CAAM.
#define BF_CSU_HPCONTROL0_HPC_CAAM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_CAAM) & BM_CSU_HPCONTROL0_HPC_CAAM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_CAAM field to a new value.
#define BW_CSU_HPCONTROL0_HPC_CAAM(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_CAAM) | BF_CSU_HPCONTROL0_HPC_CAAM(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_CAAM[15] (RW)
 *
 * Lock bit set by TZ software for HPC_CAAM.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_CAAM      (15)      //!< Bit position for CSU_HPCONTROL0_L_CAAM.
#define BM_CSU_HPCONTROL0_L_CAAM      (0x00008000)  //!< Bit mask for CSU_HPCONTROL0_L_CAAM.

//! @brief Get value of CSU_HPCONTROL0_L_CAAM from a register value.
#define BG_CSU_HPCONTROL0_L_CAAM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_CAAM) >> BP_CSU_HPCONTROL0_L_CAAM)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_CAAM.
#define BF_CSU_HPCONTROL0_L_CAAM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_CAAM) & BM_CSU_HPCONTROL0_L_CAAM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_CAAM field to a new value.
#define BW_CSU_HPCONTROL0_L_CAAM(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_CAAM) | BF_CSU_HPCONTROL0_L_CAAM(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_RAWNAND[16] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * RawNAND.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_RAWNAND      (16)      //!< Bit position for CSU_HPCONTROL0_HPC_RAWNAND.
#define BM_CSU_HPCONTROL0_HPC_RAWNAND      (0x00010000)  //!< Bit mask for CSU_HPCONTROL0_HPC_RAWNAND.

//! @brief Get value of CSU_HPCONTROL0_HPC_RAWNAND from a register value.
#define BG_CSU_HPCONTROL0_HPC_RAWNAND(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_RAWNAND) >> BP_CSU_HPCONTROL0_HPC_RAWNAND)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_RAWNAND.
#define BF_CSU_HPCONTROL0_HPC_RAWNAND(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_RAWNAND) & BM_CSU_HPCONTROL0_HPC_RAWNAND)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_RAWNAND field to a new value.
#define BW_CSU_HPCONTROL0_HPC_RAWNAND(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_RAWNAND) | BF_CSU_HPCONTROL0_HPC_RAWNAND(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_RAWNAND[17] (RW)
 *
 * Lock bit set by TZ software for HPC_RAWNAND.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_RAWNAND      (17)      //!< Bit position for CSU_HPCONTROL0_L_RAWNAND.
#define BM_CSU_HPCONTROL0_L_RAWNAND      (0x00020000)  //!< Bit mask for CSU_HPCONTROL0_L_RAWNAND.

//! @brief Get value of CSU_HPCONTROL0_L_RAWNAND from a register value.
#define BG_CSU_HPCONTROL0_L_RAWNAND(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_RAWNAND) >> BP_CSU_HPCONTROL0_L_RAWNAND)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_RAWNAND.
#define BF_CSU_HPCONTROL0_L_RAWNAND(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_RAWNAND) & BM_CSU_HPCONTROL0_L_RAWNAND)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_RAWNAND field to a new value.
#define BW_CSU_HPCONTROL0_L_RAWNAND(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_RAWNAND) | BF_CSU_HPCONTROL0_L_RAWNAND(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_APBHDMA[18] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * apbhdma.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_APBHDMA      (18)      //!< Bit position for CSU_HPCONTROL0_HPC_APBHDMA.
#define BM_CSU_HPCONTROL0_HPC_APBHDMA      (0x00040000)  //!< Bit mask for CSU_HPCONTROL0_HPC_APBHDMA.

//! @brief Get value of CSU_HPCONTROL0_HPC_APBHDMA from a register value.
#define BG_CSU_HPCONTROL0_HPC_APBHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_APBHDMA) >> BP_CSU_HPCONTROL0_HPC_APBHDMA)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_APBHDMA.
#define BF_CSU_HPCONTROL0_HPC_APBHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_APBHDMA) & BM_CSU_HPCONTROL0_HPC_APBHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_APBHDMA field to a new value.
#define BW_CSU_HPCONTROL0_HPC_APBHDMA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_APBHDMA) | BF_CSU_HPCONTROL0_HPC_APBHDMA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_ABPHDMA[19] (RW)
 *
 * Lock bit set by TZ software for HPC_APBHDMA.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_ABPHDMA      (19)      //!< Bit position for CSU_HPCONTROL0_L_ABPHDMA.
#define BM_CSU_HPCONTROL0_L_ABPHDMA      (0x00080000)  //!< Bit mask for CSU_HPCONTROL0_L_ABPHDMA.

//! @brief Get value of CSU_HPCONTROL0_L_ABPHDMA from a register value.
#define BG_CSU_HPCONTROL0_L_ABPHDMA(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_ABPHDMA) >> BP_CSU_HPCONTROL0_L_ABPHDMA)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_ABPHDMA.
#define BF_CSU_HPCONTROL0_L_ABPHDMA(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_ABPHDMA) & BM_CSU_HPCONTROL0_L_ABPHDMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_ABPHDMA field to a new value.
#define BW_CSU_HPCONTROL0_L_ABPHDMA(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_ABPHDMA) | BF_CSU_HPCONTROL0_L_ABPHDMA(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_ENET[20] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * ENET.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_ENET      (20)      //!< Bit position for CSU_HPCONTROL0_HPC_ENET.
#define BM_CSU_HPCONTROL0_HPC_ENET      (0x00100000)  //!< Bit mask for CSU_HPCONTROL0_HPC_ENET.

//! @brief Get value of CSU_HPCONTROL0_HPC_ENET from a register value.
#define BG_CSU_HPCONTROL0_HPC_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_ENET) >> BP_CSU_HPCONTROL0_HPC_ENET)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_ENET.
#define BF_CSU_HPCONTROL0_HPC_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_ENET) & BM_CSU_HPCONTROL0_HPC_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_ENET field to a new value.
#define BW_CSU_HPCONTROL0_HPC_ENET(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_ENET) | BF_CSU_HPCONTROL0_HPC_ENET(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_ENET[21] (RW)
 *
 * Lock bit set by TZ software for HPC_ENET.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_ENET      (21)      //!< Bit position for CSU_HPCONTROL0_L_ENET.
#define BM_CSU_HPCONTROL0_L_ENET      (0x00200000)  //!< Bit mask for CSU_HPCONTROL0_L_ENET.

//! @brief Get value of CSU_HPCONTROL0_L_ENET from a register value.
#define BG_CSU_HPCONTROL0_L_ENET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_ENET) >> BP_CSU_HPCONTROL0_L_ENET)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_ENET.
#define BF_CSU_HPCONTROL0_L_ENET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_ENET) & BM_CSU_HPCONTROL0_L_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_ENET field to a new value.
#define BW_CSU_HPCONTROL0_L_ENET(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_ENET) | BF_CSU_HPCONTROL0_L_ENET(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_DAP[22] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * DAP.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_DAP      (22)      //!< Bit position for CSU_HPCONTROL0_HPC_DAP.
#define BM_CSU_HPCONTROL0_HPC_DAP      (0x00400000)  //!< Bit mask for CSU_HPCONTROL0_HPC_DAP.

//! @brief Get value of CSU_HPCONTROL0_HPC_DAP from a register value.
#define BG_CSU_HPCONTROL0_HPC_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_DAP) >> BP_CSU_HPCONTROL0_HPC_DAP)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_DAP.
#define BF_CSU_HPCONTROL0_HPC_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_DAP) & BM_CSU_HPCONTROL0_HPC_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_DAP field to a new value.
#define BW_CSU_HPCONTROL0_HPC_DAP(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_DAP) | BF_CSU_HPCONTROL0_HPC_DAP(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_DAP[23] (RW)
 *
 * Lock bit set by TZ software for HPC_DAP.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_DAP      (23)      //!< Bit position for CSU_HPCONTROL0_L_DAP.
#define BM_CSU_HPCONTROL0_L_DAP      (0x00800000)  //!< Bit mask for CSU_HPCONTROL0_L_DAP.

//! @brief Get value of CSU_HPCONTROL0_L_DAP from a register value.
#define BG_CSU_HPCONTROL0_L_DAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_DAP) >> BP_CSU_HPCONTROL0_L_DAP)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_DAP.
#define BF_CSU_HPCONTROL0_L_DAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_DAP) & BM_CSU_HPCONTROL0_L_DAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_DAP field to a new value.
#define BW_CSU_HPCONTROL0_L_DAP(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_DAP) | BF_CSU_HPCONTROL0_L_DAP(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_USDHC1[24] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * USDHC1.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_USDHC1      (24)      //!< Bit position for CSU_HPCONTROL0_HPC_USDHC1.
#define BM_CSU_HPCONTROL0_HPC_USDHC1      (0x01000000)  //!< Bit mask for CSU_HPCONTROL0_HPC_USDHC1.

//! @brief Get value of CSU_HPCONTROL0_HPC_USDHC1 from a register value.
#define BG_CSU_HPCONTROL0_HPC_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_USDHC1) >> BP_CSU_HPCONTROL0_HPC_USDHC1)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_USDHC1.
#define BF_CSU_HPCONTROL0_HPC_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_USDHC1) & BM_CSU_HPCONTROL0_HPC_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_USDHC1 field to a new value.
#define BW_CSU_HPCONTROL0_HPC_USDHC1(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_USDHC1) | BF_CSU_HPCONTROL0_HPC_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_USDHC1[25] (RW)
 *
 * Lock bit set by TZ software for HPC_USDHC1.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_USDHC1      (25)      //!< Bit position for CSU_HPCONTROL0_L_USDHC1.
#define BM_CSU_HPCONTROL0_L_USDHC1      (0x02000000)  //!< Bit mask for CSU_HPCONTROL0_L_USDHC1.

//! @brief Get value of CSU_HPCONTROL0_L_USDHC1 from a register value.
#define BG_CSU_HPCONTROL0_L_USDHC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_USDHC1) >> BP_CSU_HPCONTROL0_L_USDHC1)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_USDHC1.
#define BF_CSU_HPCONTROL0_L_USDHC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_USDHC1) & BM_CSU_HPCONTROL0_L_USDHC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC1 field to a new value.
#define BW_CSU_HPCONTROL0_L_USDHC1(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_USDHC1) | BF_CSU_HPCONTROL0_L_USDHC1(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_USDHC2[26] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * USDHC2.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_USDHC2      (26)      //!< Bit position for CSU_HPCONTROL0_HPC_USDHC2.
#define BM_CSU_HPCONTROL0_HPC_USDHC2      (0x04000000)  //!< Bit mask for CSU_HPCONTROL0_HPC_USDHC2.

//! @brief Get value of CSU_HPCONTROL0_HPC_USDHC2 from a register value.
#define BG_CSU_HPCONTROL0_HPC_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_USDHC2) >> BP_CSU_HPCONTROL0_HPC_USDHC2)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_USDHC2.
#define BF_CSU_HPCONTROL0_HPC_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_USDHC2) & BM_CSU_HPCONTROL0_HPC_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_USDHC2 field to a new value.
#define BW_CSU_HPCONTROL0_HPC_USDHC2(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_USDHC2) | BF_CSU_HPCONTROL0_HPC_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_USDHC2[27] (RW)
 *
 * Lock bit set by TZ software for HPC_USDHC2.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_USDHC2      (27)      //!< Bit position for CSU_HPCONTROL0_L_USDHC2.
#define BM_CSU_HPCONTROL0_L_USDHC2      (0x08000000)  //!< Bit mask for CSU_HPCONTROL0_L_USDHC2.

//! @brief Get value of CSU_HPCONTROL0_L_USDHC2 from a register value.
#define BG_CSU_HPCONTROL0_L_USDHC2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_USDHC2) >> BP_CSU_HPCONTROL0_L_USDHC2)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_USDHC2.
#define BF_CSU_HPCONTROL0_L_USDHC2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_USDHC2) & BM_CSU_HPCONTROL0_L_USDHC2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC2 field to a new value.
#define BW_CSU_HPCONTROL0_L_USDHC2(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_USDHC2) | BF_CSU_HPCONTROL0_L_USDHC2(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_USDHC3[28] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * USDHC3.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_USDHC3      (28)      //!< Bit position for CSU_HPCONTROL0_HPC_USDHC3.
#define BM_CSU_HPCONTROL0_HPC_USDHC3      (0x10000000)  //!< Bit mask for CSU_HPCONTROL0_HPC_USDHC3.

//! @brief Get value of CSU_HPCONTROL0_HPC_USDHC3 from a register value.
#define BG_CSU_HPCONTROL0_HPC_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_USDHC3) >> BP_CSU_HPCONTROL0_HPC_USDHC3)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_USDHC3.
#define BF_CSU_HPCONTROL0_HPC_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_USDHC3) & BM_CSU_HPCONTROL0_HPC_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_USDHC3 field to a new value.
#define BW_CSU_HPCONTROL0_HPC_USDHC3(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_USDHC3) | BF_CSU_HPCONTROL0_HPC_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_USDHC3[29] (RW)
 *
 * Lock bit set by TZ software for HPC_USDHC3.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_USDHC3      (29)      //!< Bit position for CSU_HPCONTROL0_L_USDHC3.
#define BM_CSU_HPCONTROL0_L_USDHC3      (0x20000000)  //!< Bit mask for CSU_HPCONTROL0_L_USDHC3.

//! @brief Get value of CSU_HPCONTROL0_L_USDHC3 from a register value.
#define BG_CSU_HPCONTROL0_L_USDHC3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_USDHC3) >> BP_CSU_HPCONTROL0_L_USDHC3)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_USDHC3.
#define BF_CSU_HPCONTROL0_L_USDHC3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_USDHC3) & BM_CSU_HPCONTROL0_L_USDHC3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC3 field to a new value.
#define BW_CSU_HPCONTROL0_L_USDHC3(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_USDHC3) | BF_CSU_HPCONTROL0_L_USDHC3(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field HPC_USDHC4[30] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * USDHC4.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL0_HPC_USDHC4      (30)      //!< Bit position for CSU_HPCONTROL0_HPC_USDHC4.
#define BM_CSU_HPCONTROL0_HPC_USDHC4      (0x40000000)  //!< Bit mask for CSU_HPCONTROL0_HPC_USDHC4.

//! @brief Get value of CSU_HPCONTROL0_HPC_USDHC4 from a register value.
#define BG_CSU_HPCONTROL0_HPC_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_HPC_USDHC4) >> BP_CSU_HPCONTROL0_HPC_USDHC4)

//! @brief Format value for bitfield CSU_HPCONTROL0_HPC_USDHC4.
#define BF_CSU_HPCONTROL0_HPC_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_HPC_USDHC4) & BM_CSU_HPCONTROL0_HPC_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_USDHC4 field to a new value.
#define BW_CSU_HPCONTROL0_HPC_USDHC4(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_HPC_USDHC4) | BF_CSU_HPCONTROL0_HPC_USDHC4(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL0, field L_USDHC4[31] (RW)
 *
 * Lock bit set by TZ software for HPC_USDHC4.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL0_L_USDHC4      (31)      //!< Bit position for CSU_HPCONTROL0_L_USDHC4.
#define BM_CSU_HPCONTROL0_L_USDHC4      (0x80000000)  //!< Bit mask for CSU_HPCONTROL0_L_USDHC4.

//! @brief Get value of CSU_HPCONTROL0_L_USDHC4 from a register value.
#define BG_CSU_HPCONTROL0_L_USDHC4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL0_L_USDHC4) >> BP_CSU_HPCONTROL0_L_USDHC4)

//! @brief Format value for bitfield CSU_HPCONTROL0_L_USDHC4.
#define BF_CSU_HPCONTROL0_L_USDHC4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL0_L_USDHC4) & BM_CSU_HPCONTROL0_L_USDHC4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_USDHC4 field to a new value.
#define BW_CSU_HPCONTROL0_L_USDHC4(v)   (HW_CSU_HPCONTROL0_WR((HW_CSU_HPCONTROL0_RD() & ~BM_CSU_HPCONTROL0_L_USDHC4) | BF_CSU_HPCONTROL0_L_USDHC4(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CSU_HPCONTROL1 - HPCONTROL1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CSU_HPCONTROL1 - HPCONTROL1 register (RW)
 *
 * Reset value: 0x00000000
 *
 * The SCU_HPCONTROL1 register is expansion of SCU_HPCONTROL0 register. See SCU_HPCONTROL0 register
 * definition.
 */
typedef union _hw_csu_hpcontrol1
{
    reg32_t U;
    struct _hw_csu_hpcontrol1_bitfields
    {
        unsigned HPC_HDMI_HSI : 1; //!< [0] Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of HDMI Tx and HSI.
        unsigned L_HDMI_HSI : 1; //!< [1] Lock bit set by TZ software for HPC_HDMI_HSI.
        unsigned RESERVED0 : 30; //!< [31:2] Reserved.
    } B;
} hw_csu_hpcontrol1_t;
#endif

/*!
 * @name Constants and macros for entire CSU_HPCONTROL1 register
 */
//@{
#define HW_CSU_HPCONTROL1_ADDR      (REGS_CSU_BASE + 0x35c)

#ifndef __LANGUAGE_ASM__
#define HW_CSU_HPCONTROL1           (*(volatile hw_csu_hpcontrol1_t *) HW_CSU_HPCONTROL1_ADDR)
#define HW_CSU_HPCONTROL1_RD()      (HW_CSU_HPCONTROL1.U)
#define HW_CSU_HPCONTROL1_WR(v)     (HW_CSU_HPCONTROL1.U = (v))
#define HW_CSU_HPCONTROL1_SET(v)    (HW_CSU_HPCONTROL1_WR(HW_CSU_HPCONTROL1_RD() |  (v)))
#define HW_CSU_HPCONTROL1_CLR(v)    (HW_CSU_HPCONTROL1_WR(HW_CSU_HPCONTROL1_RD() & ~(v)))
#define HW_CSU_HPCONTROL1_TOG(v)    (HW_CSU_HPCONTROL1_WR(HW_CSU_HPCONTROL1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual CSU_HPCONTROL1 bitfields
 */

/*! @name Register CSU_HPCONTROL1, field HPC_HDMI_HSI[0] (RW)
 *
 * Determines if the Register value of the HP field corresponding will be pass as the hprot[1] of
 * HDMI Tx and HSI.
 *
 * Values:
 * - 0 - Input signal hprot1 value is routed to csu_hprot1 output for the corresponding master
 * - 1 - HP register bit is routed to csu_hprot1 output for the corresponding master
 */
//@{
#define BP_CSU_HPCONTROL1_HPC_HDMI_HSI      (0)      //!< Bit position for CSU_HPCONTROL1_HPC_HDMI_HSI.
#define BM_CSU_HPCONTROL1_HPC_HDMI_HSI      (0x00000001)  //!< Bit mask for CSU_HPCONTROL1_HPC_HDMI_HSI.

//! @brief Get value of CSU_HPCONTROL1_HPC_HDMI_HSI from a register value.
#define BG_CSU_HPCONTROL1_HPC_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL1_HPC_HDMI_HSI) >> BP_CSU_HPCONTROL1_HPC_HDMI_HSI)

//! @brief Format value for bitfield CSU_HPCONTROL1_HPC_HDMI_HSI.
#define BF_CSU_HPCONTROL1_HPC_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL1_HPC_HDMI_HSI) & BM_CSU_HPCONTROL1_HPC_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HPC_HDMI_HSI field to a new value.
#define BW_CSU_HPCONTROL1_HPC_HDMI_HSI(v)   (HW_CSU_HPCONTROL1_WR((HW_CSU_HPCONTROL1_RD() & ~BM_CSU_HPCONTROL1_HPC_HDMI_HSI) | BF_CSU_HPCONTROL1_HPC_HDMI_HSI(v)))
#endif
//@}

/*! @name Register CSU_HPCONTROL1, field L_HDMI_HSI[1] (RW)
 *
 * Lock bit set by TZ software for HPC_HDMI_HSI.
 *
 * Values:
 * - 0 - No lock -- adjacent (next lower) bit can be written by software
 * - 1 - Lock -- adjacent (next lower) bit cannot be written by software
 */
//@{
#define BP_CSU_HPCONTROL1_L_HDMI_HSI      (1)      //!< Bit position for CSU_HPCONTROL1_L_HDMI_HSI.
#define BM_CSU_HPCONTROL1_L_HDMI_HSI      (0x00000002)  //!< Bit mask for CSU_HPCONTROL1_L_HDMI_HSI.

//! @brief Get value of CSU_HPCONTROL1_L_HDMI_HSI from a register value.
#define BG_CSU_HPCONTROL1_L_HDMI_HSI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_CSU_HPCONTROL1_L_HDMI_HSI) >> BP_CSU_HPCONTROL1_L_HDMI_HSI)

//! @brief Format value for bitfield CSU_HPCONTROL1_L_HDMI_HSI.
#define BF_CSU_HPCONTROL1_L_HDMI_HSI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_CSU_HPCONTROL1_L_HDMI_HSI) & BM_CSU_HPCONTROL1_L_HDMI_HSI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the L_HDMI_HSI field to a new value.
#define BW_CSU_HPCONTROL1_L_HDMI_HSI(v)   (HW_CSU_HPCONTROL1_WR((HW_CSU_HPCONTROL1_RD() & ~BM_CSU_HPCONTROL1_L_HDMI_HSI) | BF_CSU_HPCONTROL1_L_HDMI_HSI(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_csu_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All CSU module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_csu
{
    volatile hw_csu_csln_t CSLn[40]; //!< Config security level register
    reg32_t _reserved0[88];
    volatile hw_csu_hp0_t HP0; //!< HP0 register
    volatile hw_csu_hp1_t HP1; //!< HP1 register
    reg32_t _reserved1[4];
    volatile hw_csu_sa_t SA; //!< Secure access register
    reg32_t _reserved2[79];
    volatile hw_csu_hpcontrol0_t HPCONTROL0; //!< HPCONTROL0 register
    volatile hw_csu_hpcontrol1_t HPCONTROL1; //!< HPCONTROL1 register
} hw_csu_t;
#pragma pack()

//! @brief Macro to access all CSU registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_CSU</code>.
#define HW_CSU     (*(hw_csu_t *) REGS_CSU_BASE)
#endif

#endif // __HW_CSU_REGISTERS_H__
// v18/121106/1.2.2
// EOF
