/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_PCIE_EP_REGISTERS_H__
#define __HW_PCIE_EP_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6DQ PCIE_EP
 *
 * PCIeEP
 *
 * Registers defined in this header file:
 * - HW_PCIE_EP_DEVICEID - Device ID and Vendor ID Register
 * - HW_PCIE_EP_COMMAND - Command and Status Register
 * - HW_PCIE_EP_BIST - BIST Register
 * - HW_PCIE_EP_BAR0 - Base Address 0
 * - HW_PCIE_EP_MASK0 - BAR 0 Mask Register
 * - HW_PCIE_EP_MASK1 - BAR 1 Mask Register
 * - HW_PCIE_EP_MASK2 - BAR 2 Mask Register
 * - HW_PCIE_EP_MASK3 - BAR 3 Mask Register
 * - HW_PCIE_EP_CISP - CardBus CIS Pointer Register
 * - HW_PCIE_EP_SSID - Subsystem ID and Subsystem Vendor ID Register
 * - HW_PCIE_EP_EROMBAR - Expansion ROM Base Address Register
 * - HW_PCIE_EP_EROMMASK - Expansion ROM BAR Mask Register
 * - HW_PCIE_EP_CAPPR - Capability Pointer Register
 * - HW_PCIE_EP_ILR - Interrupt Line and Pin Register
 * - HW_PCIE_EP_AER - AER Capability Header
 * - HW_PCIE_EP_UESR - Uncorrectable Error Status Register
 * - HW_PCIE_EP_UEMR - Uncorrectable Error Mask Register
 * - HW_PCIE_EP_UESEVR - Uncorrectable Error Severity Register
 * - HW_PCIE_EP_CESR - Correctable Error Status Register
 * - HW_PCIE_EP_CEMR - Correctable Error Mask Register
 * - HW_PCIE_EP_ACCR - Advanced Capabilities and Control Register
 * - HW_PCIE_EP_HLR - Header Log Register
 * - HW_PCIE_EP_VCECHR - VC Extended Capability Header
 * - HW_PCIE_EP_PVCCR1 - Port VC Capability Register 1
 * - HW_PCIE_EP_PVCCR2 - Port VC Capability Register 2
 * - HW_PCIE_EP_PVCCSR - Port VC Control and Status Register
 * - HW_PCIE_EP_VCRCR - VC Resource Capability Register n
 * - HW_PCIE_EP_VCRCONR - VC Resource Control Register n
 * - HW_PCIE_EP_VCRSR - VC Resource Status Register n
 *
 * - hw_pcie_ep_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_PCIE_EP_BASE
#define HW_PCIE_EP_INSTANCE_COUNT (1) //!< Number of instances of the PCIE_EP module.
#define REGS_PCIE_EP_BASE (0x01ffc000) //!< Base address for PCIE_EP.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_DEVICEID - Device ID and Vendor ID Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_DEVICEID - Device ID and Vendor ID Register (RO)
 *
 * Reset value: 0xabcd16c3
 *
 * Offset : 0x00 The default values of both Device ID and Vendor ID are hardware configuration
 * parameters. The application can overwrite the default values of both Device ID and Vendor ID
 * through the DBI.
 */
typedef union _hw_pcie_ep_deviceid
{
    reg32_t U;
    struct _hw_pcie_ep_deviceid_bitfields
    {
        unsigned RESERVED0 : 32; //!< [31:0] Reserved.
    } B;
} hw_pcie_ep_deviceid_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_DEVICEID register
 */
//@{
#define HW_PCIE_EP_DEVICEID_ADDR      (REGS_PCIE_EP_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_DEVICEID           (*(volatile hw_pcie_ep_deviceid_t *) HW_PCIE_EP_DEVICEID_ADDR)
#define HW_PCIE_EP_DEVICEID_RD()      (HW_PCIE_EP_DEVICEID.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_DEVICEID bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_COMMAND - Command and Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_COMMAND - Command and Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset : 0x04 Bytes : 0-1
 */
typedef union _hw_pcie_ep_command
{
    reg32_t U;
    struct _hw_pcie_ep_command_bitfields
    {
        unsigned I_O_SPACE_ENABLE : 1; //!< [0] I/O Space Enable
        unsigned MEMORY_SPACE_ENABLE : 1; //!< [1] Memory Space Enable
        unsigned BUS_MASTER_ENABLE : 1; //!< [2] Bus Master Enable
        unsigned SPECIAL_CYCLE_ENABLE : 1; //!< [3] Special Cycle Enable
        unsigned MEMORY_WRITE_AND_INVALIDATE : 1; //!< [4] Memory Write and Invalidate
        unsigned VGA_PALETTE_SNOOP : 1; //!< [5] VGA Palette Snoop
        unsigned PARITY_ERROR_RESPONSE : 1; //!< [6] Parity Error Response
        unsigned IDSEL_STEPPING : 1; //!< [7] IDSEL Stepping/Wait Cycle Control
        unsigned SERR_ENABLE : 1; //!< [8] SERR# Enable
        unsigned FAST_BACK_TO_BACK_ENABLE : 1; //!< [9] Fast Back-to-Back Enable
        unsigned INTX_ASSERTION_DISABLE : 1; //!< [10] INTx Assertion Disable
        unsigned RESERVED0 : 8; //!< [18:11] Reserved.
        unsigned INTX_STATUS : 1; //!< [19] INTx Status
        unsigned CAPABILITIES_LIST : 1; //!< [20] Capabilities List
        unsigned SIXTYSIX_MHZ_CAPABLE : 1; //!< [21] 66 MHz Capable
        unsigned RESERVED1 : 1; //!< [22] Reserved
        unsigned FAST_BACK_TO_BACK_CAPABLE : 1; //!< [23] Fast Back-to-Back Capable
        unsigned MASTER_DATA_PARITY_ERROR : 1; //!< [24] Master Data Parity Error
        unsigned DEVSEL_TIMING : 2; //!< [26:25] DEVSEL Timing
        unsigned SIGNALED_TARGET_ABORT : 1; //!< [27] Signaled Target Abort
        unsigned RECEIVED_TARGET_ABORT : 1; //!< [28] Received Target Abort
        unsigned RECEIVED_MASTER_ABORT : 1; //!< [29] Received Master Abort
        unsigned DETECTED_PARITY_ERROR : 1; //!< [30] Detected Parity Error
        unsigned SIGNALED_SYSTEM_ERROR : 1; //!< [31] Signaled System Error
    } B;
} hw_pcie_ep_command_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_COMMAND register
 */
//@{
#define HW_PCIE_EP_COMMAND_ADDR      (REGS_PCIE_EP_BASE + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_COMMAND           (*(volatile hw_pcie_ep_command_t *) HW_PCIE_EP_COMMAND_ADDR)
#define HW_PCIE_EP_COMMAND_RD()      (HW_PCIE_EP_COMMAND.U)
#define HW_PCIE_EP_COMMAND_WR(v)     (HW_PCIE_EP_COMMAND.U = (v))
#define HW_PCIE_EP_COMMAND_SET(v)    (HW_PCIE_EP_COMMAND_WR(HW_PCIE_EP_COMMAND_RD() |  (v)))
#define HW_PCIE_EP_COMMAND_CLR(v)    (HW_PCIE_EP_COMMAND_WR(HW_PCIE_EP_COMMAND_RD() & ~(v)))
#define HW_PCIE_EP_COMMAND_TOG(v)    (HW_PCIE_EP_COMMAND_WR(HW_PCIE_EP_COMMAND_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_COMMAND bitfields
 */

/*! @name Register PCIE_EP_COMMAND, field I_O_SPACE_ENABLE[0] (RW)
 *
 * I/O Space Enable
 */
//@{
#define BP_PCIE_EP_COMMAND_I_O_SPACE_ENABLE      (0)      //!< Bit position for PCIE_EP_COMMAND_I_O_SPACE_ENABLE.
#define BM_PCIE_EP_COMMAND_I_O_SPACE_ENABLE      (0x00000001)  //!< Bit mask for PCIE_EP_COMMAND_I_O_SPACE_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_I_O_SPACE_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_I_O_SPACE_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_I_O_SPACE_ENABLE) >> BP_PCIE_EP_COMMAND_I_O_SPACE_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_I_O_SPACE_ENABLE.
#define BF_PCIE_EP_COMMAND_I_O_SPACE_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_I_O_SPACE_ENABLE) & BM_PCIE_EP_COMMAND_I_O_SPACE_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I_O_SPACE_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_I_O_SPACE_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_I_O_SPACE_ENABLE) | BF_PCIE_EP_COMMAND_I_O_SPACE_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field MEMORY_SPACE_ENABLE[1] (RW)
 *
 * Memory Space Enable
 */
//@{
#define BP_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE      (1)      //!< Bit position for PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE.
#define BM_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE      (0x00000002)  //!< Bit mask for PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE) >> BP_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE.
#define BF_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE) & BM_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MEMORY_SPACE_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE) | BF_PCIE_EP_COMMAND_MEMORY_SPACE_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field BUS_MASTER_ENABLE[2] (RW)
 *
 * Bus Master Enable
 */
//@{
#define BP_PCIE_EP_COMMAND_BUS_MASTER_ENABLE      (2)      //!< Bit position for PCIE_EP_COMMAND_BUS_MASTER_ENABLE.
#define BM_PCIE_EP_COMMAND_BUS_MASTER_ENABLE      (0x00000004)  //!< Bit mask for PCIE_EP_COMMAND_BUS_MASTER_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_BUS_MASTER_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_BUS_MASTER_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_BUS_MASTER_ENABLE) >> BP_PCIE_EP_COMMAND_BUS_MASTER_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_BUS_MASTER_ENABLE.
#define BF_PCIE_EP_COMMAND_BUS_MASTER_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_BUS_MASTER_ENABLE) & BM_PCIE_EP_COMMAND_BUS_MASTER_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BUS_MASTER_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_BUS_MASTER_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_BUS_MASTER_ENABLE) | BF_PCIE_EP_COMMAND_BUS_MASTER_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field SPECIAL_CYCLE_ENABLE[3] (RW)
 *
 * Special Cycle Enable Not applicable for PCI Express. Must be hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE      (3)      //!< Bit position for PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE.
#define BM_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE      (0x00000008)  //!< Bit mask for PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE) >> BP_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE.
#define BF_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE) & BM_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPECIAL_CYCLE_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE) | BF_PCIE_EP_COMMAND_SPECIAL_CYCLE_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field MEMORY_WRITE_AND_INVALIDATE[4] (RW)
 *
 * Memory Write and Invalidate Not applicable for PCI Express. Must be hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE      (4)      //!< Bit position for PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE.
#define BM_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE      (0x00000010)  //!< Bit mask for PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE.

//! @brief Get value of PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE from a register value.
#define BG_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE) >> BP_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE.
#define BF_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE) & BM_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MEMORY_WRITE_AND_INVALIDATE field to a new value.
#define BW_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE) | BF_PCIE_EP_COMMAND_MEMORY_WRITE_AND_INVALIDATE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field VGA_PALETTE_SNOOP[5] (RW)
 *
 * VGA Palette Snoop Not applicable for PCI Express. Must be hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP      (5)      //!< Bit position for PCIE_EP_COMMAND_VGA_PALETTE_SNOOP.
#define BM_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP      (0x00000020)  //!< Bit mask for PCIE_EP_COMMAND_VGA_PALETTE_SNOOP.

//! @brief Get value of PCIE_EP_COMMAND_VGA_PALETTE_SNOOP from a register value.
#define BG_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP) >> BP_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP)

//! @brief Format value for bitfield PCIE_EP_COMMAND_VGA_PALETTE_SNOOP.
#define BF_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP) & BM_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VGA_PALETTE_SNOOP field to a new value.
#define BW_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP) | BF_PCIE_EP_COMMAND_VGA_PALETTE_SNOOP(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field PARITY_ERROR_RESPONSE[6] (RW)
 *
 * Parity Error Response
 */
//@{
#define BP_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE      (6)      //!< Bit position for PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE.
#define BM_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE      (0x00000040)  //!< Bit mask for PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE.

//! @brief Get value of PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE from a register value.
#define BG_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE) >> BP_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE.
#define BF_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE) & BM_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PARITY_ERROR_RESPONSE field to a new value.
#define BW_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE) | BF_PCIE_EP_COMMAND_PARITY_ERROR_RESPONSE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field IDSEL_STEPPING[7] (RW)
 *
 * IDSEL Stepping/Wait Cycle Control Not applicable for PCI Express. Must be hardwired to 0
 */
//@{
#define BP_PCIE_EP_COMMAND_IDSEL_STEPPING      (7)      //!< Bit position for PCIE_EP_COMMAND_IDSEL_STEPPING.
#define BM_PCIE_EP_COMMAND_IDSEL_STEPPING      (0x00000080)  //!< Bit mask for PCIE_EP_COMMAND_IDSEL_STEPPING.

//! @brief Get value of PCIE_EP_COMMAND_IDSEL_STEPPING from a register value.
#define BG_PCIE_EP_COMMAND_IDSEL_STEPPING(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_IDSEL_STEPPING) >> BP_PCIE_EP_COMMAND_IDSEL_STEPPING)

//! @brief Format value for bitfield PCIE_EP_COMMAND_IDSEL_STEPPING.
#define BF_PCIE_EP_COMMAND_IDSEL_STEPPING(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_IDSEL_STEPPING) & BM_PCIE_EP_COMMAND_IDSEL_STEPPING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDSEL_STEPPING field to a new value.
#define BW_PCIE_EP_COMMAND_IDSEL_STEPPING(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_IDSEL_STEPPING) | BF_PCIE_EP_COMMAND_IDSEL_STEPPING(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field SERR_ENABLE[8] (RW)
 *
 * SERR# Enable
 */
//@{
#define BP_PCIE_EP_COMMAND_SERR_ENABLE      (8)      //!< Bit position for PCIE_EP_COMMAND_SERR_ENABLE.
#define BM_PCIE_EP_COMMAND_SERR_ENABLE      (0x00000100)  //!< Bit mask for PCIE_EP_COMMAND_SERR_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_SERR_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_SERR_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_SERR_ENABLE) >> BP_PCIE_EP_COMMAND_SERR_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_SERR_ENABLE.
#define BF_PCIE_EP_COMMAND_SERR_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_SERR_ENABLE) & BM_PCIE_EP_COMMAND_SERR_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SERR_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_SERR_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_SERR_ENABLE) | BF_PCIE_EP_COMMAND_SERR_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field FAST_BACK_TO_BACK_ENABLE[9] (RW)
 *
 * Fast Back-to-Back Enable Not applicable for PCI Express. Must be hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE      (9)      //!< Bit position for PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE.
#define BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE      (0x00000200)  //!< Bit mask for PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE.

//! @brief Get value of PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE from a register value.
#define BG_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE) >> BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE.
#define BF_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE) & BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAST_BACK_TO_BACK_ENABLE field to a new value.
#define BW_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE) | BF_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field INTX_ASSERTION_DISABLE[10] (RW)
 *
 * INTx Assertion Disable
 */
//@{
#define BP_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE      (10)      //!< Bit position for PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE.
#define BM_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE      (0x00000400)  //!< Bit mask for PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE.

//! @brief Get value of PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE from a register value.
#define BG_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE) >> BP_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE.
#define BF_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE) & BM_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTX_ASSERTION_DISABLE field to a new value.
#define BW_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE) | BF_PCIE_EP_COMMAND_INTX_ASSERTION_DISABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field INTX_STATUS[19] (RW)
 *
 * INTx Status
 */
//@{
#define BP_PCIE_EP_COMMAND_INTX_STATUS      (19)      //!< Bit position for PCIE_EP_COMMAND_INTX_STATUS.
#define BM_PCIE_EP_COMMAND_INTX_STATUS      (0x00080000)  //!< Bit mask for PCIE_EP_COMMAND_INTX_STATUS.

//! @brief Get value of PCIE_EP_COMMAND_INTX_STATUS from a register value.
#define BG_PCIE_EP_COMMAND_INTX_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_INTX_STATUS) >> BP_PCIE_EP_COMMAND_INTX_STATUS)

//! @brief Format value for bitfield PCIE_EP_COMMAND_INTX_STATUS.
#define BF_PCIE_EP_COMMAND_INTX_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_INTX_STATUS) & BM_PCIE_EP_COMMAND_INTX_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTX_STATUS field to a new value.
#define BW_PCIE_EP_COMMAND_INTX_STATUS(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_INTX_STATUS) | BF_PCIE_EP_COMMAND_INTX_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field CAPABILITIES_LIST[20] (RW)
 *
 * Capabilities List Indicates presence of an extended capability item. Hardwired to 1.
 */
//@{
#define BP_PCIE_EP_COMMAND_CAPABILITIES_LIST      (20)      //!< Bit position for PCIE_EP_COMMAND_CAPABILITIES_LIST.
#define BM_PCIE_EP_COMMAND_CAPABILITIES_LIST      (0x00100000)  //!< Bit mask for PCIE_EP_COMMAND_CAPABILITIES_LIST.

//! @brief Get value of PCIE_EP_COMMAND_CAPABILITIES_LIST from a register value.
#define BG_PCIE_EP_COMMAND_CAPABILITIES_LIST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_CAPABILITIES_LIST) >> BP_PCIE_EP_COMMAND_CAPABILITIES_LIST)

//! @brief Format value for bitfield PCIE_EP_COMMAND_CAPABILITIES_LIST.
#define BF_PCIE_EP_COMMAND_CAPABILITIES_LIST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_CAPABILITIES_LIST) & BM_PCIE_EP_COMMAND_CAPABILITIES_LIST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CAPABILITIES_LIST field to a new value.
#define BW_PCIE_EP_COMMAND_CAPABILITIES_LIST(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_CAPABILITIES_LIST) | BF_PCIE_EP_COMMAND_CAPABILITIES_LIST(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field SIXTYSIX_MHZ_CAPABLE[21] (RW)
 *
 * 66 MHz Capable Not applicable for PCI Express. Hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE      (21)      //!< Bit position for PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE.
#define BM_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE      (0x00200000)  //!< Bit mask for PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE.

//! @brief Get value of PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE from a register value.
#define BG_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE) >> BP_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE.
#define BF_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE) & BM_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SIXTYSIX_MHZ_CAPABLE field to a new value.
#define BW_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE) | BF_PCIE_EP_COMMAND_SIXTYSIX_MHZ_CAPABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field FAST_BACK_TO_BACK_CAPABLE[23] (RW)
 *
 * Fast Back-to-Back Capable Not applicable for PCI Express. Hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE      (23)      //!< Bit position for PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE.
#define BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE      (0x00800000)  //!< Bit mask for PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE.

//! @brief Get value of PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE from a register value.
#define BG_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE) >> BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE)

//! @brief Format value for bitfield PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE.
#define BF_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE) & BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FAST_BACK_TO_BACK_CAPABLE field to a new value.
#define BW_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE) | BF_PCIE_EP_COMMAND_FAST_BACK_TO_BACK_CAPABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field MASTER_DATA_PARITY_ERROR[24] (RW)
 *
 * Master Data Parity Error
 */
//@{
#define BP_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR      (24)      //!< Bit position for PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR.
#define BM_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR      (0x01000000)  //!< Bit mask for PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR.

//! @brief Get value of PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR from a register value.
#define BG_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR) >> BP_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR)

//! @brief Format value for bitfield PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR.
#define BF_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR) & BM_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASTER_DATA_PARITY_ERROR field to a new value.
#define BW_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR) | BF_PCIE_EP_COMMAND_MASTER_DATA_PARITY_ERROR(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field DEVSEL_TIMING[26:25] (RW)
 *
 * DEVSEL Timing Not applicable for PCI Express. Hardwired to 0.
 */
//@{
#define BP_PCIE_EP_COMMAND_DEVSEL_TIMING      (25)      //!< Bit position for PCIE_EP_COMMAND_DEVSEL_TIMING.
#define BM_PCIE_EP_COMMAND_DEVSEL_TIMING      (0x06000000)  //!< Bit mask for PCIE_EP_COMMAND_DEVSEL_TIMING.

//! @brief Get value of PCIE_EP_COMMAND_DEVSEL_TIMING from a register value.
#define BG_PCIE_EP_COMMAND_DEVSEL_TIMING(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_DEVSEL_TIMING) >> BP_PCIE_EP_COMMAND_DEVSEL_TIMING)

//! @brief Format value for bitfield PCIE_EP_COMMAND_DEVSEL_TIMING.
#define BF_PCIE_EP_COMMAND_DEVSEL_TIMING(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_DEVSEL_TIMING) & BM_PCIE_EP_COMMAND_DEVSEL_TIMING)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEVSEL_TIMING field to a new value.
#define BW_PCIE_EP_COMMAND_DEVSEL_TIMING(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_DEVSEL_TIMING) | BF_PCIE_EP_COMMAND_DEVSEL_TIMING(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field SIGNALED_TARGET_ABORT[27] (RW)
 *
 * Signaled Target Abort
 */
//@{
#define BP_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT      (27)      //!< Bit position for PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT.
#define BM_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT      (0x08000000)  //!< Bit mask for PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT.

//! @brief Get value of PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT from a register value.
#define BG_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT) >> BP_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT)

//! @brief Format value for bitfield PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT.
#define BF_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT) & BM_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SIGNALED_TARGET_ABORT field to a new value.
#define BW_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT) | BF_PCIE_EP_COMMAND_SIGNALED_TARGET_ABORT(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field RECEIVED_TARGET_ABORT[28] (RW)
 *
 * Received Target Abort
 */
//@{
#define BP_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT      (28)      //!< Bit position for PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT.
#define BM_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT      (0x10000000)  //!< Bit mask for PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT.

//! @brief Get value of PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT from a register value.
#define BG_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT) >> BP_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT)

//! @brief Format value for bitfield PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT.
#define BF_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT) & BM_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVED_TARGET_ABORT field to a new value.
#define BW_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT) | BF_PCIE_EP_COMMAND_RECEIVED_TARGET_ABORT(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field RECEIVED_MASTER_ABORT[29] (RW)
 *
 * Received Master Abort
 */
//@{
#define BP_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT      (29)      //!< Bit position for PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT.
#define BM_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT      (0x20000000)  //!< Bit mask for PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT.

//! @brief Get value of PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT from a register value.
#define BG_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT) >> BP_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT)

//! @brief Format value for bitfield PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT.
#define BF_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT) & BM_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVED_MASTER_ABORT field to a new value.
#define BW_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT) | BF_PCIE_EP_COMMAND_RECEIVED_MASTER_ABORT(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field DETECTED_PARITY_ERROR[30] (RW)
 *
 * Detected Parity Error
 */
//@{
#define BP_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR      (30)      //!< Bit position for PCIE_EP_COMMAND_DETECTED_PARITY_ERROR.
#define BM_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR      (0x40000000)  //!< Bit mask for PCIE_EP_COMMAND_DETECTED_PARITY_ERROR.

//! @brief Get value of PCIE_EP_COMMAND_DETECTED_PARITY_ERROR from a register value.
#define BG_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR) >> BP_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR)

//! @brief Format value for bitfield PCIE_EP_COMMAND_DETECTED_PARITY_ERROR.
#define BF_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR) & BM_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DETECTED_PARITY_ERROR field to a new value.
#define BW_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR) | BF_PCIE_EP_COMMAND_DETECTED_PARITY_ERROR(v)))
#endif
//@}

/*! @name Register PCIE_EP_COMMAND, field SIGNALED_SYSTEM_ERROR[31] (RW)
 *
 * Signaled System Error
 */
//@{
#define BP_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR      (31)      //!< Bit position for PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR.
#define BM_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR      (0x80000000)  //!< Bit mask for PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR.

//! @brief Get value of PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR from a register value.
#define BG_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR) >> BP_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR)

//! @brief Format value for bitfield PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR.
#define BF_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR) & BM_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SIGNALED_SYSTEM_ERROR field to a new value.
#define BW_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR(v)   (HW_PCIE_EP_COMMAND_WR((HW_PCIE_EP_COMMAND_RD() & ~BM_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR) | BF_PCIE_EP_COMMAND_SIGNALED_SYSTEM_ERROR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_BIST - BIST Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_BIST - BIST Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x0C Byte: 0
 */
typedef union _hw_pcie_ep_bist
{
    reg32_t U;
    struct _hw_pcie_ep_bist_bitfields
    {
        unsigned CACHE_LINE_SIZE : 8; //!< [7:0] Cache Line Size
        unsigned MASTER_LATENCY_TIMER : 8; //!< [15:8] Master Latency Timer
        unsigned CONFIGURATION_HEADER_FORMAT : 7; //!< [22:16] Configuration Header Format
        unsigned MULTI_FUNCTION_DEVICE : 1; //!< [23] Multi Function Device
        unsigned NOT_SUPPORTED_BY__CORE : 8; //!< [31:24] The BIST register functions are not supported by the core.
    } B;
} hw_pcie_ep_bist_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_BIST register
 */
//@{
#define HW_PCIE_EP_BIST_ADDR      (REGS_PCIE_EP_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_BIST           (*(volatile hw_pcie_ep_bist_t *) HW_PCIE_EP_BIST_ADDR)
#define HW_PCIE_EP_BIST_RD()      (HW_PCIE_EP_BIST.U)
#define HW_PCIE_EP_BIST_WR(v)     (HW_PCIE_EP_BIST.U = (v))
#define HW_PCIE_EP_BIST_SET(v)    (HW_PCIE_EP_BIST_WR(HW_PCIE_EP_BIST_RD() |  (v)))
#define HW_PCIE_EP_BIST_CLR(v)    (HW_PCIE_EP_BIST_WR(HW_PCIE_EP_BIST_RD() & ~(v)))
#define HW_PCIE_EP_BIST_TOG(v)    (HW_PCIE_EP_BIST_WR(HW_PCIE_EP_BIST_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_BIST bitfields
 */

/*! @name Register PCIE_EP_BIST, field CACHE_LINE_SIZE[7:0] (RW)
 *
 * Cache Line Size The Cache Line Size register is RW for legacy compatibility purposes and is not
 * applicable to PCI Express device functionality. Writing to the Cache Line Size register does not
 * impact functionality of the core.
 */
//@{
#define BP_PCIE_EP_BIST_CACHE_LINE_SIZE      (0)      //!< Bit position for PCIE_EP_BIST_CACHE_LINE_SIZE.
#define BM_PCIE_EP_BIST_CACHE_LINE_SIZE      (0x000000ff)  //!< Bit mask for PCIE_EP_BIST_CACHE_LINE_SIZE.

//! @brief Get value of PCIE_EP_BIST_CACHE_LINE_SIZE from a register value.
#define BG_PCIE_EP_BIST_CACHE_LINE_SIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BIST_CACHE_LINE_SIZE) >> BP_PCIE_EP_BIST_CACHE_LINE_SIZE)

//! @brief Format value for bitfield PCIE_EP_BIST_CACHE_LINE_SIZE.
#define BF_PCIE_EP_BIST_CACHE_LINE_SIZE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_BIST_CACHE_LINE_SIZE) & BM_PCIE_EP_BIST_CACHE_LINE_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CACHE_LINE_SIZE field to a new value.
#define BW_PCIE_EP_BIST_CACHE_LINE_SIZE(v)   (HW_PCIE_EP_BIST_WR((HW_PCIE_EP_BIST_RD() & ~BM_PCIE_EP_BIST_CACHE_LINE_SIZE) | BF_PCIE_EP_BIST_CACHE_LINE_SIZE(v)))
#endif
//@}

/*! @name Register PCIE_EP_BIST, field MASTER_LATENCY_TIMER[15:8] (RW)
 *
 * Master Latency Timer Not applicable for PCI Express, hardwired to 0.
 */
//@{
#define BP_PCIE_EP_BIST_MASTER_LATENCY_TIMER      (8)      //!< Bit position for PCIE_EP_BIST_MASTER_LATENCY_TIMER.
#define BM_PCIE_EP_BIST_MASTER_LATENCY_TIMER      (0x0000ff00)  //!< Bit mask for PCIE_EP_BIST_MASTER_LATENCY_TIMER.

//! @brief Get value of PCIE_EP_BIST_MASTER_LATENCY_TIMER from a register value.
#define BG_PCIE_EP_BIST_MASTER_LATENCY_TIMER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BIST_MASTER_LATENCY_TIMER) >> BP_PCIE_EP_BIST_MASTER_LATENCY_TIMER)

//! @brief Format value for bitfield PCIE_EP_BIST_MASTER_LATENCY_TIMER.
#define BF_PCIE_EP_BIST_MASTER_LATENCY_TIMER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_BIST_MASTER_LATENCY_TIMER) & BM_PCIE_EP_BIST_MASTER_LATENCY_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASTER_LATENCY_TIMER field to a new value.
#define BW_PCIE_EP_BIST_MASTER_LATENCY_TIMER(v)   (HW_PCIE_EP_BIST_WR((HW_PCIE_EP_BIST_RD() & ~BM_PCIE_EP_BIST_MASTER_LATENCY_TIMER) | BF_PCIE_EP_BIST_MASTER_LATENCY_TIMER(v)))
#endif
//@}

/*! @name Register PCIE_EP_BIST, field CONFIGURATION_HEADER_FORMAT[22:16] (RW)
 *
 * Configuration Header Format Hardwired to 0 for type 0.
 */
//@{
#define BP_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT      (16)      //!< Bit position for PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT.
#define BM_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT      (0x007f0000)  //!< Bit mask for PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT.

//! @brief Get value of PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT from a register value.
#define BG_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT) >> BP_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT)

//! @brief Format value for bitfield PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT.
#define BF_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT) & BM_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CONFIGURATION_HEADER_FORMAT field to a new value.
#define BW_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT(v)   (HW_PCIE_EP_BIST_WR((HW_PCIE_EP_BIST_RD() & ~BM_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT) | BF_PCIE_EP_BIST_CONFIGURATION_HEADER_FORMAT(v)))
#endif
//@}

/*! @name Register PCIE_EP_BIST, field MULTI_FUNCTION_DEVICE[23] (RW)
 *
 * Multi Function Device The default value is 0 for a single function device (`CX_NFUNC = 1) or 1
 * for a multi-function device (`CX_NFUNC != 1). The Multi Function Device bit is writable through
 * the DBI.
 */
//@{
#define BP_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE      (23)      //!< Bit position for PCIE_EP_BIST_MULTI_FUNCTION_DEVICE.
#define BM_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE      (0x00800000)  //!< Bit mask for PCIE_EP_BIST_MULTI_FUNCTION_DEVICE.

//! @brief Get value of PCIE_EP_BIST_MULTI_FUNCTION_DEVICE from a register value.
#define BG_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE) >> BP_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE)

//! @brief Format value for bitfield PCIE_EP_BIST_MULTI_FUNCTION_DEVICE.
#define BF_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE) & BM_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MULTI_FUNCTION_DEVICE field to a new value.
#define BW_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE(v)   (HW_PCIE_EP_BIST_WR((HW_PCIE_EP_BIST_RD() & ~BM_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE) | BF_PCIE_EP_BIST_MULTI_FUNCTION_DEVICE(v)))
#endif
//@}

/*! @name Register PCIE_EP_BIST, field NOT_SUPPORTED_BY__CORE[31:24] (RW)
 *
 * The BIST register functions are not supported by the core. All 8 bits of the BIST register are
 * hardwired to 0.
 */
//@{
#define BP_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE      (24)      //!< Bit position for PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE.
#define BM_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE      (0xff000000)  //!< Bit mask for PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE.

//! @brief Get value of PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE from a register value.
#define BG_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE) >> BP_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE)

//! @brief Format value for bitfield PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE.
#define BF_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE) & BM_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NOT_SUPPORTED_BY__CORE field to a new value.
#define BW_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE(v)   (HW_PCIE_EP_BIST_WR((HW_PCIE_EP_BIST_RD() & ~BM_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE) | BF_PCIE_EP_BIST_NOT_SUPPORTED_BY__CORE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_BAR0 - Base Address 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_BAR0 - Base Address 0 (RO)
 *
 * Reset value: 0x0000000c
 *
 * Offset: 0x10-0x24 The core provides three pairs of 32-bit BARs for each implemented function.
 * Each pair (BARs 0 and 1, BARs 2 and 3, BARs 4 and 5) can be configured as follows: One 64-bit
 * BAR: For example, BARs 0 and 1 are combined to form a single 64-bit BAR. Two 32-bit BARs: For
 * example, BARs 0 and 1 are two independent 32-bit BARs. One 32-bit BAR: For example, BAR 0 is a
 * 32-bit BAR and BAR 1 is either disabled or removed from the core altogether to reduce gate count.
 * In addition, you can configure each BAR to have its incoming Requests routed to either: RTRGT1
 * The following sections describe how to set up the BAR types and sizes by programming values into
 * the base address registers. For more information about routing Requests to either RTRGT1 on a
 * BAR-by- BAR basis, see . The contents of the six BARs determine the BAR configuration. The reset
 * values of the BARs are determined by hardware configuration options. At runtime, application
 * software can overwrite the BAR contents to reconfigure the BARs (unless the affected BAR is
 * removed during hardware configuration). Application software must observe the rules listed below
 * when writing to the BARs. The rules for BAR configuration are the same for all three pairs. Using
 * BARs 0 and 1 as the example pair, the rules for BAR configuration are: Any pair (for example,
 * BARs 0 and 1) can be configured as one 64-bit BAR, two 32-bit BARs, or one 32-bit BAR. BAR pairs
 * cannot overlap to form a 64-bit BAR. For example, you cannot combine BARs 1 and 2 to form a
 * 64-bit BAR. An I/O BAR must be a 32-bit BAR and cannot be prefetchable. If the device is
 * configured as a PCI Express Endpoint (not a Legacy Endpoint), then any memory that is configured
 * as prefetchable must be a 64-bit memory BAR. If BAR 0 is configured as a 64-bit BAR: BAR 1 is the
 * upper 32 bits of the combined 64-bit BAR formed by BARs 0 and 1. Therefore, BAR 1 must be
 * disabled and cannot be configured independently. BAR 0 must be a memory BAR and can be either
 * prefetchable or non-prefetchable. The contents of the BAR 0 Mask register determine the number of
 * writable bits in the 64-bit BAR, subject to the restrictions described in îBAR Mask Registersî on
 * page 536. The BAR 1 Mask register contains the upper 32 bits of the BAR 0 Mask value. BAR 0 can
 * be disabled by writing 0 to bit 0 of the BAR 0 Mask register If BAR 0 is configured as a 32-bit
 * BAR: You can configure BAR 1 as an independent 32-bit BAR BAR 0 can be configured as a memory BAR
 * or an I/O BAR. The contents of the BAR 0 Mask register determine the number of writable bits in
 * the 32-bit BAR 0, subject to the restrictions described in îBAR Mask Registersî on page 536. BAR
 * 0 can be disabled by writing 0 to bit 0 of the BAR 0 Mask register When BAR 0 is configured as a
 * 32-bit BAR, BAR 1 is available as an independent 32-bit BAR according to the following rules: BAR
 * 1 can be configured as a memory BAR or an I/O BAR. The contents of the BAR 1 Mask register
 * determine the number of writable bits in the 32-bit BAR 1, subject to the restrictions described
 * in îBAR Mask Registersî on page 536. The same rules apply for pairs 2/3 and 4/5. Offset: 0x10 (if
 * included in the core hardware configuration)
 */
typedef union _hw_pcie_ep_bar0
{
    reg32_t U;
    struct _hw_pcie_ep_bar0_bitfields
    {
        unsigned MEM_I_O : 1; //!< [0] Bits [3:0] are writable through the DBI.
        unsigned TYPE : 2; //!< [2:1] If BAR 0 is an I/O BAR, bit 2 the least significant bit of the base address and bit 1 is 0.
        unsigned PREF : 1; //!< [3] If BAR 0 is an I/O BAR, bit 3 is the second least significant bit of the base address.
        unsigned ADDRESS : 28; //!< [31:4] BAR 0 base address bits (for a 64-bit BAR, the remaining upper address bits are in BAR 1).
    } B;
} hw_pcie_ep_bar0_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_BAR0 register
 */
//@{
#define HW_PCIE_EP_BAR0_ADDR      (REGS_PCIE_EP_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_BAR0           (*(volatile hw_pcie_ep_bar0_t *) HW_PCIE_EP_BAR0_ADDR)
#define HW_PCIE_EP_BAR0_RD()      (HW_PCIE_EP_BAR0.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_BAR0 bitfields
 */

/*! @name Register PCIE_EP_BAR0, field MEM_I_O[0] (RO)
 *
 * Bits [3:0] are writable through the DBI.
 *
 * Values:
 * - 0 - = BAR 0 is a memory BAR
 * - 1 - = BAR 0 is an I/O BAR
 */
//@{
#define BP_PCIE_EP_BAR0_MEM_I_O      (0)      //!< Bit position for PCIE_EP_BAR0_MEM_I_O.
#define BM_PCIE_EP_BAR0_MEM_I_O      (0x00000001)  //!< Bit mask for PCIE_EP_BAR0_MEM_I_O.

//! @brief Get value of PCIE_EP_BAR0_MEM_I_O from a register value.
#define BG_PCIE_EP_BAR0_MEM_I_O(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BAR0_MEM_I_O) >> BP_PCIE_EP_BAR0_MEM_I_O)
//@}

/*! @name Register PCIE_EP_BAR0, field TYPE[2:1] (RO)
 *
 * If BAR 0 is an I/O BAR, bit 2 the least significant bit of the base address and bit 1 is 0. Bits
 * [3:0] are writable through the DBI. If BAR 0 is a memory BAR, bits [2:1] determine the BAR type:
 *
 * Values:
 * - 00 - = 32-bit BAR
 * - 10 - = 64-bit BAR
 */
//@{
#define BP_PCIE_EP_BAR0_TYPE      (1)      //!< Bit position for PCIE_EP_BAR0_TYPE.
#define BM_PCIE_EP_BAR0_TYPE      (0x00000006)  //!< Bit mask for PCIE_EP_BAR0_TYPE.

//! @brief Get value of PCIE_EP_BAR0_TYPE from a register value.
#define BG_PCIE_EP_BAR0_TYPE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BAR0_TYPE) >> BP_PCIE_EP_BAR0_TYPE)
//@}

/*! @name Register PCIE_EP_BAR0, field PREF[3] (RO)
 *
 * If BAR 0 is an I/O BAR, bit 3 is the second least significant bit of the base address. Bits [3:0]
 * are writable through the DBI. If BAR 0 is a memory BAR, bit 3 indicates if the memory region is
 * prefetchable:
 *
 * Values:
 * - 0 - = Non-prefetchable
 * - 1 - = Prefetchable
 */
//@{
#define BP_PCIE_EP_BAR0_PREF      (3)      //!< Bit position for PCIE_EP_BAR0_PREF.
#define BM_PCIE_EP_BAR0_PREF      (0x00000008)  //!< Bit mask for PCIE_EP_BAR0_PREF.

//! @brief Get value of PCIE_EP_BAR0_PREF from a register value.
#define BG_PCIE_EP_BAR0_PREF(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BAR0_PREF) >> BP_PCIE_EP_BAR0_PREF)
//@}

/*! @name Register PCIE_EP_BAR0, field ADDRESS[31:4] (RO)
 *
 * BAR 0 base address bits (for a 64-bit BAR, the remaining upper address bits are in BAR 1). The
 * BAR 0 Mask value determines which address bits are masked.
 */
//@{
#define BP_PCIE_EP_BAR0_ADDRESS      (4)      //!< Bit position for PCIE_EP_BAR0_ADDRESS.
#define BM_PCIE_EP_BAR0_ADDRESS      (0xfffffff0)  //!< Bit mask for PCIE_EP_BAR0_ADDRESS.

//! @brief Get value of PCIE_EP_BAR0_ADDRESS from a register value.
#define BG_PCIE_EP_BAR0_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_BAR0_ADDRESS) >> BP_PCIE_EP_BAR0_ADDRESS)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_MASK0 - BAR 0 Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_MASK0 - BAR 0 Mask Register (RO)
 *
 * Reset value: 0x0000000c
 *
 * The BAR masks are used for indicating the amount of memory each BAR requests from host software.
 * The application logic can overwrite the default values via the DBI. The BAR Mask registers
 * determine which bits in each BAR are non-writable by host software, which determines the size of
 * the address space claimed by each BAR. The BAR Mask values indicate the range of low-order bits
 * in each implemented BAR not to use for address matching. The BAR Mask value also indicates the
 * range of low-order bits in the BAR that cannot be written from the host. The application can
 * write to all BAR bits to allow setting of memory, I/O, and other standard BAR options. To disable
 * any BAR, the application can write a 0 to bit 0 of the corresponding BAR Mask register. To change
 * the BAR Mask value for a disabled BAR, the application must first enable the BAR by writing 1 to
 * bit 0. After enabling the BAR, the application can then write a new value to the BAR Mask
 * register. The BAR Mask registers are accessible through the same address as the corresponding BAR
 * registers, but requires dbi_cs2 assertions instead i.e. bit address 12 must be set. The BAR Mask
 * registers are writable only, not readable. If the BAR Mask value for a BAR is less than that
 * required for the BAR type, the core automatically uses the minimum value for the BAR type: BAR
 * bits [11:0] are always masked for a memory BAR. The core requires each memory BAR to claim at
 * least 4 KB. The PCI Express Base Specification states that the minimum memory address range
 * requested by a BAR is 128 bytes. In the PCI Local Bus Specification, Rev 3.0 it is recommended
 * that devices that need less than 4 KB of Address Space should still consume 4 KB of address space
 * in order to minimize the number of bits in the address decoder. A Memory BAR size of 256 bytes
 * can be achieved by using a DBI2 write to BAR Mask. BAR bits [7:0] are always masked for an I/O
 * BAR. The core requires each I/O BAR to claim at least 256 bytes. The PCI Local Bus Specification,
 * Rev 3.0 allows I/O BARs to consume between 4 bytes and 256 bytes of address space. The core only
 * permits I/O BARs to consume 256 bytes of address space. This restriction is used in order to
 * minimize the number of bits in the address decoder. The aperture of the BAR is actually the
 * larger of the written sizeor the system page size (set by the operating system). In the case
 * where the system page size is larger than the requested bar size, the BAR is actually sized to
 * the system page size . This means that when the OS writes all 1s then reads back to determine the
 * size of the BAR, the OS will see the BAR size to be the system page size. The application logic,
 * most likely, will only have the original requested amount of physical memory. A transaction will
 * receive a UR if the transaction is from the RC and it targets an address that is within the range
 * of the allocated system page size but above the implemented application memory. The figure below
 * shows an example configuration of the six BARs and their corresponding BAR Mask registers. The
 * example configuration includes: One 64-bit memory BAR (non-prefetchable) One 32-bit memory BAR
 * (non-prefetchable) One 32-bit I/O BAR Example Base Address Register Configuration Offset: 0x10
 * (same as Base Address Register 0, but requires dbi_cs2 for write access)
 */
typedef union _hw_pcie_ep_mask0
{
    reg32_t U;
    struct _hw_pcie_ep_mask0_bitfields
    {
        unsigned ENABLE : 1; //!< [0] Bit 0 is interpreted as BAR Enable when writing to the BAR Mask register rather than as a mask bit because bit 0 of a BAR is always masked from writing by host software.
        unsigned MASK : 31; //!< [31:1] Indicates which BAR 0 bits to mask (make non- writable) from host software, which, in turn, determines the size of the BAR.
    } B;
} hw_pcie_ep_mask0_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_MASK0 register
 */
//@{
#define HW_PCIE_EP_MASK0_ADDR      (REGS_PCIE_EP_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_MASK0           (*(volatile hw_pcie_ep_mask0_t *) HW_PCIE_EP_MASK0_ADDR)
#define HW_PCIE_EP_MASK0_RD()      (HW_PCIE_EP_MASK0.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_MASK0 bitfields
 */

/*! @name Register PCIE_EP_MASK0, field ENABLE[0] (RO)
 *
 * Bit 0 is interpreted as BAR Enable when writing to the BAR Mask register rather than as a mask
 * bit because bit 0 of a BAR is always masked from writing by host software. BAR 0 Enable
 *
 * Values:
 * - 0 - BAR 0 is disabled
 * - 1 - BAR 0 is enabled
 */
//@{
#define BP_PCIE_EP_MASK0_ENABLE      (0)      //!< Bit position for PCIE_EP_MASK0_ENABLE.
#define BM_PCIE_EP_MASK0_ENABLE      (0x00000001)  //!< Bit mask for PCIE_EP_MASK0_ENABLE.

//! @brief Get value of PCIE_EP_MASK0_ENABLE from a register value.
#define BG_PCIE_EP_MASK0_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK0_ENABLE) >> BP_PCIE_EP_MASK0_ENABLE)
//@}

/*! @name Register PCIE_EP_MASK0, field MASK[31:1] (RO)
 *
 * Indicates which BAR 0 bits to mask (make non- writable) from host software, which, in turn,
 * determines the size of the BAR. For example, writing 0xFFF to the BAR 0 Mask register claims a
 * 4096- byte BAR by masking bits 11:0 of the BAR from writing by host software. The BAR 1 Mask
 * register contains the upper bits of the BAR 0 Mask. The BAR 0 Mask register is invisible to host
 * software and not readable from the application. the BAR 0 Mask register is writable through the
 * DBI.
 */
//@{
#define BP_PCIE_EP_MASK0_MASK      (1)      //!< Bit position for PCIE_EP_MASK0_MASK.
#define BM_PCIE_EP_MASK0_MASK      (0xfffffffe)  //!< Bit mask for PCIE_EP_MASK0_MASK.

//! @brief Get value of PCIE_EP_MASK0_MASK from a register value.
#define BG_PCIE_EP_MASK0_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK0_MASK) >> BP_PCIE_EP_MASK0_MASK)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_MASK1 - BAR 1 Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_MASK1 - BAR 1 Mask Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x14 (same as Base Address Register 1, but requires dbi_cs2 for write access)
 */
typedef union _hw_pcie_ep_mask1
{
    reg32_t U;
    struct _hw_pcie_ep_mask1_bitfields
    {
        unsigned MASK : 32; //!< [31:0] Bits [31:1]: BAR 1 Mask value, interpreted the same way as BAR 0 Mask.
    } B;
} hw_pcie_ep_mask1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_MASK1 register
 */
//@{
#define HW_PCIE_EP_MASK1_ADDR      (REGS_PCIE_EP_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_MASK1           (*(volatile hw_pcie_ep_mask1_t *) HW_PCIE_EP_MASK1_ADDR)
#define HW_PCIE_EP_MASK1_RD()      (HW_PCIE_EP_MASK1.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_MASK1 bitfields
 */

/*! @name Register PCIE_EP_MASK1, field MASK[31:0] (RO)
 *
 * Bits [31:1]: BAR 1 Mask value, interpreted the same way as BAR 0 Mask. Default value is
 * `BAR1_MASK_N. Bit 0: BAR 1 Enable (0 = BAR 1 is disabled; 1= BAR 1 is enabled). Default value is
 * `BAR1_ENABLED_N. `BAR1_MASK_WRITABLE_N controls application write access to the BAR 1 Mask
 * register. Bits [31:0] are the upper bits of the BAR 0 Mask value. `BAR0_MASK_WRITABLE_N controls
 * application write access to the full 64-bit BAR 0 Mask register.
 */
//@{
#define BP_PCIE_EP_MASK1_MASK      (0)      //!< Bit position for PCIE_EP_MASK1_MASK.
#define BM_PCIE_EP_MASK1_MASK      (0xffffffff)  //!< Bit mask for PCIE_EP_MASK1_MASK.

//! @brief Get value of PCIE_EP_MASK1_MASK from a register value.
#define BG_PCIE_EP_MASK1_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK1_MASK) >> BP_PCIE_EP_MASK1_MASK)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_MASK2 - BAR 2 Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_MASK2 - BAR 2 Mask Register (RO)
 *
 * Reset value: 0x00000008
 *
 * Offset: 0x18 (same as Base Address Register 2, but requires dbi_cs2 for write access)
 */
typedef union _hw_pcie_ep_mask2
{
    reg32_t U;
    struct _hw_pcie_ep_mask2_bitfields
    {
        unsigned BAR2_ENABLED_N : 1; //!< [0] Bit 0 is interpreted as BAR Enable when writing to the BAR Mask register rather than as a mask bit because bit 0 of a BAR is always masked from writing by host software.
        unsigned BAR2_MASK_N : 31; //!< [31:1] Indicates which BAR 2 bits to mask (make non- writable) from host software, which, in turn, determines the size of the BAR.
    } B;
} hw_pcie_ep_mask2_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_MASK2 register
 */
//@{
#define HW_PCIE_EP_MASK2_ADDR      (REGS_PCIE_EP_BASE + 0x18)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_MASK2           (*(volatile hw_pcie_ep_mask2_t *) HW_PCIE_EP_MASK2_ADDR)
#define HW_PCIE_EP_MASK2_RD()      (HW_PCIE_EP_MASK2.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_MASK2 bitfields
 */

/*! @name Register PCIE_EP_MASK2, field BAR2_ENABLED_N[0] (RO)
 *
 * Bit 0 is interpreted as BAR Enable when writing to the BAR Mask register rather than as a mask
 * bit because bit 0 of a BAR is always masked from writing by host software. BAR 2 Enable
 *
 * Values:
 * - 0 - BAR 2 is disabled
 * - 1 - BAR 2 is enabled
 */
//@{
#define BP_PCIE_EP_MASK2_BAR2_ENABLED_N      (0)      //!< Bit position for PCIE_EP_MASK2_BAR2_ENABLED_N.
#define BM_PCIE_EP_MASK2_BAR2_ENABLED_N      (0x00000001)  //!< Bit mask for PCIE_EP_MASK2_BAR2_ENABLED_N.

//! @brief Get value of PCIE_EP_MASK2_BAR2_ENABLED_N from a register value.
#define BG_PCIE_EP_MASK2_BAR2_ENABLED_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK2_BAR2_ENABLED_N) >> BP_PCIE_EP_MASK2_BAR2_ENABLED_N)
//@}

/*! @name Register PCIE_EP_MASK2, field BAR2_MASK_N[31:1] (RO)
 *
 * Indicates which BAR 2 bits to mask (make non- writable) from host software, which, in turn,
 * determines the size of the BAR. For example, writing 0xFFF to the BAR 2 Mask register claims a
 * 4096-byte BAR by masking bits 11:0 of the BAR from writing by host software. The BAR 2 Mask
 * register is invisible to host software and not readable from the application. the BAR 2 Mask
 * register is writable through the DBI.
 */
//@{
#define BP_PCIE_EP_MASK2_BAR2_MASK_N      (1)      //!< Bit position for PCIE_EP_MASK2_BAR2_MASK_N.
#define BM_PCIE_EP_MASK2_BAR2_MASK_N      (0xfffffffe)  //!< Bit mask for PCIE_EP_MASK2_BAR2_MASK_N.

//! @brief Get value of PCIE_EP_MASK2_BAR2_MASK_N from a register value.
#define BG_PCIE_EP_MASK2_BAR2_MASK_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK2_BAR2_MASK_N) >> BP_PCIE_EP_MASK2_BAR2_MASK_N)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_MASK3 - BAR 3 Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_MASK3 - BAR 3 Mask Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x1C (same as Base Address Register 3, but requires dbi_cs2 for write access)
 */
typedef union _hw_pcie_ep_mask3
{
    reg32_t U;
    struct _hw_pcie_ep_mask3_bitfields
    {
        unsigned MASK : 32; //!< [31:0] Bits [31:1]: BAR 3 Mask value, interpreted the same way as BAR 2 Mask.
    } B;
} hw_pcie_ep_mask3_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_MASK3 register
 */
//@{
#define HW_PCIE_EP_MASK3_ADDR      (REGS_PCIE_EP_BASE + 0x1c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_MASK3           (*(volatile hw_pcie_ep_mask3_t *) HW_PCIE_EP_MASK3_ADDR)
#define HW_PCIE_EP_MASK3_RD()      (HW_PCIE_EP_MASK3.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_MASK3 bitfields
 */

/*! @name Register PCIE_EP_MASK3, field MASK[31:0] (RO)
 *
 * Bits [31:1]: BAR 3 Mask value, interpreted the same way as BAR 2 Mask. Default value is
 * `BAR3_MASK_N. Bit 0: BAR 3 Enable (0 = BAR 3 is disabled; 1= BAR 3 is enabled). Default value is
 * `BAR3_ENABLED_N. `BAR3_MASK_WRITABLE_N controls application can not write access to the BAR 3
 * Mask register. Bits [31:0] are the upper bits of the BAR 2 Mask value. `BAR2_MASK_WRITABLE_N
 * controls application write access to the full 64-bit BAR 2 Mask register.
 */
//@{
#define BP_PCIE_EP_MASK3_MASK      (0)      //!< Bit position for PCIE_EP_MASK3_MASK.
#define BM_PCIE_EP_MASK3_MASK      (0xffffffff)  //!< Bit mask for PCIE_EP_MASK3_MASK.

//! @brief Get value of PCIE_EP_MASK3_MASK from a register value.
#define BG_PCIE_EP_MASK3_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_MASK3_MASK) >> BP_PCIE_EP_MASK3_MASK)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_CISP - CardBus CIS Pointer Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_CISP - CardBus CIS Pointer Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x28
 */
typedef union _hw_pcie_ep_cisp
{
    reg32_t U;
    struct _hw_pcie_ep_cisp_bitfields
    {
        unsigned CARDBUS_CIS_PTR_N : 32; //!< [31:0] CardBus CIS Pointer
    } B;
} hw_pcie_ep_cisp_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_CISP register
 */
//@{
#define HW_PCIE_EP_CISP_ADDR      (REGS_PCIE_EP_BASE + 0x28)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_CISP           (*(volatile hw_pcie_ep_cisp_t *) HW_PCIE_EP_CISP_ADDR)
#define HW_PCIE_EP_CISP_RD()      (HW_PCIE_EP_CISP.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_CISP bitfields
 */

/*! @name Register PCIE_EP_CISP, field CARDBUS_CIS_PTR_N[31:0] (RO)
 *
 * CardBus CIS Pointer Optional, writable through the DBI.
 */
//@{
#define BP_PCIE_EP_CISP_CARDBUS_CIS_PTR_N      (0)      //!< Bit position for PCIE_EP_CISP_CARDBUS_CIS_PTR_N.
#define BM_PCIE_EP_CISP_CARDBUS_CIS_PTR_N      (0xffffffff)  //!< Bit mask for PCIE_EP_CISP_CARDBUS_CIS_PTR_N.

//! @brief Get value of PCIE_EP_CISP_CARDBUS_CIS_PTR_N from a register value.
#define BG_PCIE_EP_CISP_CARDBUS_CIS_PTR_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CISP_CARDBUS_CIS_PTR_N) >> BP_PCIE_EP_CISP_CARDBUS_CIS_PTR_N)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_SSID - Subsystem ID and Subsystem Vendor ID Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_SSID - Subsystem ID and Subsystem Vendor ID Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x2C
 */
typedef union _hw_pcie_ep_ssid
{
    reg32_t U;
    struct _hw_pcie_ep_ssid_bitfields
    {
        unsigned SUBSYS_VENDOR_ID_N : 16; //!< [15:0] Subsystem Vendor ID Writable through the DBI.
        unsigned SUBSYS_DEV_ID_N : 16; //!< [31:16] Subsystem ID
    } B;
} hw_pcie_ep_ssid_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_SSID register
 */
//@{
#define HW_PCIE_EP_SSID_ADDR      (REGS_PCIE_EP_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_SSID           (*(volatile hw_pcie_ep_ssid_t *) HW_PCIE_EP_SSID_ADDR)
#define HW_PCIE_EP_SSID_RD()      (HW_PCIE_EP_SSID.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_SSID bitfields
 */

/*! @name Register PCIE_EP_SSID, field SUBSYS_VENDOR_ID_N[15:0] (RO)
 *
 * Subsystem Vendor ID Writable through the DBI.
 */
//@{
#define BP_PCIE_EP_SSID_SUBSYS_VENDOR_ID_N      (0)      //!< Bit position for PCIE_EP_SSID_SUBSYS_VENDOR_ID_N.
#define BM_PCIE_EP_SSID_SUBSYS_VENDOR_ID_N      (0x0000ffff)  //!< Bit mask for PCIE_EP_SSID_SUBSYS_VENDOR_ID_N.

//! @brief Get value of PCIE_EP_SSID_SUBSYS_VENDOR_ID_N from a register value.
#define BG_PCIE_EP_SSID_SUBSYS_VENDOR_ID_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_SSID_SUBSYS_VENDOR_ID_N) >> BP_PCIE_EP_SSID_SUBSYS_VENDOR_ID_N)
//@}

/*! @name Register PCIE_EP_SSID, field SUBSYS_DEV_ID_N[31:16] (RO)
 *
 * Subsystem ID Writable through the DBI.
 */
//@{
#define BP_PCIE_EP_SSID_SUBSYS_DEV_ID_N      (16)      //!< Bit position for PCIE_EP_SSID_SUBSYS_DEV_ID_N.
#define BM_PCIE_EP_SSID_SUBSYS_DEV_ID_N      (0xffff0000)  //!< Bit mask for PCIE_EP_SSID_SUBSYS_DEV_ID_N.

//! @brief Get value of PCIE_EP_SSID_SUBSYS_DEV_ID_N from a register value.
#define BG_PCIE_EP_SSID_SUBSYS_DEV_ID_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_SSID_SUBSYS_DEV_ID_N) >> BP_PCIE_EP_SSID_SUBSYS_DEV_ID_N)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_EROMBAR - Expansion ROM Base Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_EROMBAR - Expansion ROM Base Address Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x30
 */
typedef union _hw_pcie_ep_erombar
{
    reg32_t U;
    struct _hw_pcie_ep_erombar_bitfields
    {
        unsigned ENABLE : 1; //!< [0] Expansion ROM Enable
        unsigned RESERVED0 : 10; //!< [10:1] Reserved
        unsigned ADDRESS : 21; //!< [31:11] Expansion ROM Address
    } B;
} hw_pcie_ep_erombar_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_EROMBAR register
 */
//@{
#define HW_PCIE_EP_EROMBAR_ADDR      (REGS_PCIE_EP_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_EROMBAR           (*(volatile hw_pcie_ep_erombar_t *) HW_PCIE_EP_EROMBAR_ADDR)
#define HW_PCIE_EP_EROMBAR_RD()      (HW_PCIE_EP_EROMBAR.U)
#define HW_PCIE_EP_EROMBAR_WR(v)     (HW_PCIE_EP_EROMBAR.U = (v))
#define HW_PCIE_EP_EROMBAR_SET(v)    (HW_PCIE_EP_EROMBAR_WR(HW_PCIE_EP_EROMBAR_RD() |  (v)))
#define HW_PCIE_EP_EROMBAR_CLR(v)    (HW_PCIE_EP_EROMBAR_WR(HW_PCIE_EP_EROMBAR_RD() & ~(v)))
#define HW_PCIE_EP_EROMBAR_TOG(v)    (HW_PCIE_EP_EROMBAR_WR(HW_PCIE_EP_EROMBAR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_EROMBAR bitfields
 */

/*! @name Register PCIE_EP_EROMBAR, field ENABLE[0] (RW)
 *
 * Expansion ROM Enable
 */
//@{
#define BP_PCIE_EP_EROMBAR_ENABLE      (0)      //!< Bit position for PCIE_EP_EROMBAR_ENABLE.
#define BM_PCIE_EP_EROMBAR_ENABLE      (0x00000001)  //!< Bit mask for PCIE_EP_EROMBAR_ENABLE.

//! @brief Get value of PCIE_EP_EROMBAR_ENABLE from a register value.
#define BG_PCIE_EP_EROMBAR_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_EROMBAR_ENABLE) >> BP_PCIE_EP_EROMBAR_ENABLE)

//! @brief Format value for bitfield PCIE_EP_EROMBAR_ENABLE.
#define BF_PCIE_EP_EROMBAR_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_EROMBAR_ENABLE) & BM_PCIE_EP_EROMBAR_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENABLE field to a new value.
#define BW_PCIE_EP_EROMBAR_ENABLE(v)   (HW_PCIE_EP_EROMBAR_WR((HW_PCIE_EP_EROMBAR_RD() & ~BM_PCIE_EP_EROMBAR_ENABLE) | BF_PCIE_EP_EROMBAR_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_EROMBAR, field ADDRESS[31:11] (RW)
 *
 * Expansion ROM Address
 */
//@{
#define BP_PCIE_EP_EROMBAR_ADDRESS      (11)      //!< Bit position for PCIE_EP_EROMBAR_ADDRESS.
#define BM_PCIE_EP_EROMBAR_ADDRESS      (0xfffff800)  //!< Bit mask for PCIE_EP_EROMBAR_ADDRESS.

//! @brief Get value of PCIE_EP_EROMBAR_ADDRESS from a register value.
#define BG_PCIE_EP_EROMBAR_ADDRESS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_EROMBAR_ADDRESS) >> BP_PCIE_EP_EROMBAR_ADDRESS)

//! @brief Format value for bitfield PCIE_EP_EROMBAR_ADDRESS.
#define BF_PCIE_EP_EROMBAR_ADDRESS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_EROMBAR_ADDRESS) & BM_PCIE_EP_EROMBAR_ADDRESS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDRESS field to a new value.
#define BW_PCIE_EP_EROMBAR_ADDRESS(v)   (HW_PCIE_EP_EROMBAR_WR((HW_PCIE_EP_EROMBAR_RD() & ~BM_PCIE_EP_EROMBAR_ADDRESS) | BF_PCIE_EP_EROMBAR_ADDRESS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_EROMMASK - Expansion ROM BAR Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_EROMMASK - Expansion ROM BAR Mask Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x30 (same as the Expansion ROM BAR, but requires dbi_cs2 for write access)
 */
typedef union _hw_pcie_ep_erommask
{
    reg32_t U;
    struct _hw_pcie_ep_erommask_bitfields
    {
        unsigned ROM_BAR_ENABLED_N : 1; //!< [0] Expansion ROM BAR Enable
        unsigned ROM_MASK_N : 31; //!< [31:1] Indicates which Expansion ROM BAR bits to mask (make non-writable) from host software, which, in turn, determines the size of the BAR.
    } B;
} hw_pcie_ep_erommask_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_EROMMASK register
 */
//@{
#define HW_PCIE_EP_EROMMASK_ADDR      (REGS_PCIE_EP_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_EROMMASK           (*(volatile hw_pcie_ep_erommask_t *) HW_PCIE_EP_EROMMASK_ADDR)
#define HW_PCIE_EP_EROMMASK_RD()      (HW_PCIE_EP_EROMMASK.U)
#define HW_PCIE_EP_EROMMASK_WR(v)     (HW_PCIE_EP_EROMMASK.U = (v))
#define HW_PCIE_EP_EROMMASK_SET(v)    (HW_PCIE_EP_EROMMASK_WR(HW_PCIE_EP_EROMMASK_RD() |  (v)))
#define HW_PCIE_EP_EROMMASK_CLR(v)    (HW_PCIE_EP_EROMMASK_WR(HW_PCIE_EP_EROMMASK_RD() & ~(v)))
#define HW_PCIE_EP_EROMMASK_TOG(v)    (HW_PCIE_EP_EROMMASK_WR(HW_PCIE_EP_EROMMASK_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_EROMMASK bitfields
 */

/*! @name Register PCIE_EP_EROMMASK, field ROM_BAR_ENABLED_N[0] (RW)
 *
 * Expansion ROM BAR Enable
 *
 * Values:
 * - 0 - Expansion ROM BAR is disabled
 * - 1 - Expansion ROM BAR is enabled
 */
//@{
#define BP_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N      (0)      //!< Bit position for PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N.
#define BM_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N      (0x00000001)  //!< Bit mask for PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N.

//! @brief Get value of PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N from a register value.
#define BG_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N) >> BP_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N)

//! @brief Format value for bitfield PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N.
#define BF_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N) & BM_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ROM_BAR_ENABLED_N field to a new value.
#define BW_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N(v)   (HW_PCIE_EP_EROMMASK_WR((HW_PCIE_EP_EROMMASK_RD() & ~BM_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N) | BF_PCIE_EP_EROMMASK_ROM_BAR_ENABLED_N(v)))
#endif
//@}

/*! @name Register PCIE_EP_EROMMASK, field ROM_MASK_N[31:1] (RW)
 *
 * Indicates which Expansion ROM BAR bits to mask (make non-writable) from host software, which, in
 * turn, determines the size of the BAR. For example, writing 0xFFF to the Expansion ROM BAR Mask
 * register claims a 4096-byte BAR by masking bits 11:0 of the BAR from writing by host software.
 * The maximum value is 0xFFFFFF because the maximum space that can be claimed by an Expansion ROM
 * BAR is 16 MB. The Expansion ROM BAR Mask register is invisible to host software and not readable
 * from the application. Application access depends on the value of the Expansion ROM BAR Mask
 * register is writable through the DBI.
 */
//@{
#define BP_PCIE_EP_EROMMASK_ROM_MASK_N      (1)      //!< Bit position for PCIE_EP_EROMMASK_ROM_MASK_N.
#define BM_PCIE_EP_EROMMASK_ROM_MASK_N      (0xfffffffe)  //!< Bit mask for PCIE_EP_EROMMASK_ROM_MASK_N.

//! @brief Get value of PCIE_EP_EROMMASK_ROM_MASK_N from a register value.
#define BG_PCIE_EP_EROMMASK_ROM_MASK_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_EROMMASK_ROM_MASK_N) >> BP_PCIE_EP_EROMMASK_ROM_MASK_N)

//! @brief Format value for bitfield PCIE_EP_EROMMASK_ROM_MASK_N.
#define BF_PCIE_EP_EROMMASK_ROM_MASK_N(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_EROMMASK_ROM_MASK_N) & BM_PCIE_EP_EROMMASK_ROM_MASK_N)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ROM_MASK_N field to a new value.
#define BW_PCIE_EP_EROMMASK_ROM_MASK_N(v)   (HW_PCIE_EP_EROMMASK_WR((HW_PCIE_EP_EROMMASK_RD() & ~BM_PCIE_EP_EROMMASK_ROM_MASK_N) | BF_PCIE_EP_EROMMASK_ROM_MASK_N(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_CAPPR - Capability Pointer Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_CAPPR - Capability Pointer Register (RO)
 *
 * Reset value: 0x00000040
 *
 * Offset: 0x34 Byte: 0
 */
typedef union _hw_pcie_ep_cappr
{
    reg32_t U;
    struct _hw_pcie_ep_cappr_bitfields
    {
        unsigned CFG_NEXT_PTR : 8; //!< [7:0] First Capability Pointer.
        unsigned RESERVED0 : 24; //!< [31:8] Reserved
    } B;
} hw_pcie_ep_cappr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_CAPPR register
 */
//@{
#define HW_PCIE_EP_CAPPR_ADDR      (REGS_PCIE_EP_BASE + 0x34)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_CAPPR           (*(volatile hw_pcie_ep_cappr_t *) HW_PCIE_EP_CAPPR_ADDR)
#define HW_PCIE_EP_CAPPR_RD()      (HW_PCIE_EP_CAPPR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_CAPPR bitfields
 */

/*! @name Register PCIE_EP_CAPPR, field CFG_NEXT_PTR[7:0] (RO)
 *
 * First Capability Pointer. See for more information.
 */
//@{
#define BP_PCIE_EP_CAPPR_CFG_NEXT_PTR      (0)      //!< Bit position for PCIE_EP_CAPPR_CFG_NEXT_PTR.
#define BM_PCIE_EP_CAPPR_CFG_NEXT_PTR      (0x000000ff)  //!< Bit mask for PCIE_EP_CAPPR_CFG_NEXT_PTR.

//! @brief Get value of PCIE_EP_CAPPR_CFG_NEXT_PTR from a register value.
#define BG_PCIE_EP_CAPPR_CFG_NEXT_PTR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CAPPR_CFG_NEXT_PTR) >> BP_PCIE_EP_CAPPR_CFG_NEXT_PTR)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_ILR - Interrupt Line and Pin Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_ILR - Interrupt Line and Pin Register (RW)
 *
 * Reset value: 0x000001ff
 *
 * Offset: 0x3C Byte: 0
 */
typedef union _hw_pcie_ep_ilr
{
    reg32_t U;
    struct _hw_pcie_ep_ilr_bitfields
    {
        unsigned INTERRUPT_LINE : 8; //!< [7:0] Interrupt Line
        unsigned INT_PIN_MAPPING_N : 8; //!< [15:8] Interrupt Pin
        unsigned RESERVED0 : 16; //!< [31:16] Reserved
    } B;
} hw_pcie_ep_ilr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_ILR register
 */
//@{
#define HW_PCIE_EP_ILR_ADDR      (REGS_PCIE_EP_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_ILR           (*(volatile hw_pcie_ep_ilr_t *) HW_PCIE_EP_ILR_ADDR)
#define HW_PCIE_EP_ILR_RD()      (HW_PCIE_EP_ILR.U)
#define HW_PCIE_EP_ILR_WR(v)     (HW_PCIE_EP_ILR.U = (v))
#define HW_PCIE_EP_ILR_SET(v)    (HW_PCIE_EP_ILR_WR(HW_PCIE_EP_ILR_RD() |  (v)))
#define HW_PCIE_EP_ILR_CLR(v)    (HW_PCIE_EP_ILR_WR(HW_PCIE_EP_ILR_RD() & ~(v)))
#define HW_PCIE_EP_ILR_TOG(v)    (HW_PCIE_EP_ILR_WR(HW_PCIE_EP_ILR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_ILR bitfields
 */

/*! @name Register PCIE_EP_ILR, field INTERRUPT_LINE[7:0] (RW)
 *
 * Interrupt Line Value in this register is system architecture specific. POST software will write
 * the routing information into this register as it initializes and configures the system.
 */
//@{
#define BP_PCIE_EP_ILR_INTERRUPT_LINE      (0)      //!< Bit position for PCIE_EP_ILR_INTERRUPT_LINE.
#define BM_PCIE_EP_ILR_INTERRUPT_LINE      (0x000000ff)  //!< Bit mask for PCIE_EP_ILR_INTERRUPT_LINE.

//! @brief Get value of PCIE_EP_ILR_INTERRUPT_LINE from a register value.
#define BG_PCIE_EP_ILR_INTERRUPT_LINE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ILR_INTERRUPT_LINE) >> BP_PCIE_EP_ILR_INTERRUPT_LINE)

//! @brief Format value for bitfield PCIE_EP_ILR_INTERRUPT_LINE.
#define BF_PCIE_EP_ILR_INTERRUPT_LINE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ILR_INTERRUPT_LINE) & BM_PCIE_EP_ILR_INTERRUPT_LINE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTERRUPT_LINE field to a new value.
#define BW_PCIE_EP_ILR_INTERRUPT_LINE(v)   (HW_PCIE_EP_ILR_WR((HW_PCIE_EP_ILR_RD() & ~BM_PCIE_EP_ILR_INTERRUPT_LINE) | BF_PCIE_EP_ILR_INTERRUPT_LINE(v)))
#endif
//@}

/*! @name Register PCIE_EP_ILR, field INT_PIN_MAPPING_N[15:8] (RW)
 *
 * Interrupt Pin Identifies the legacy interrupt Message that the device (or device function) uses.
 * In a single-function configuration, the core only uses INTA. The Interrupt Pin register is
 * writable through the DBI. Valid values are:
 *
 * Values:
 * - 0x00 - The device (or function) does not use legacy interrupt
 * - 0x01 - The device (or function) uses INTA
 * - 0x02 - The device (or function) uses INTB
 * - 0x03 - The device (or function) uses INTC
 * - 0x04 - The device (or function) uses INTD
 */
//@{
#define BP_PCIE_EP_ILR_INT_PIN_MAPPING_N      (8)      //!< Bit position for PCIE_EP_ILR_INT_PIN_MAPPING_N.
#define BM_PCIE_EP_ILR_INT_PIN_MAPPING_N      (0x0000ff00)  //!< Bit mask for PCIE_EP_ILR_INT_PIN_MAPPING_N.

//! @brief Get value of PCIE_EP_ILR_INT_PIN_MAPPING_N from a register value.
#define BG_PCIE_EP_ILR_INT_PIN_MAPPING_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ILR_INT_PIN_MAPPING_N) >> BP_PCIE_EP_ILR_INT_PIN_MAPPING_N)

//! @brief Format value for bitfield PCIE_EP_ILR_INT_PIN_MAPPING_N.
#define BF_PCIE_EP_ILR_INT_PIN_MAPPING_N(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ILR_INT_PIN_MAPPING_N) & BM_PCIE_EP_ILR_INT_PIN_MAPPING_N)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT_PIN_MAPPING_N field to a new value.
#define BW_PCIE_EP_ILR_INT_PIN_MAPPING_N(v)   (HW_PCIE_EP_ILR_WR((HW_PCIE_EP_ILR_RD() & ~BM_PCIE_EP_ILR_INT_PIN_MAPPING_N) | BF_PCIE_EP_ILR_INT_PIN_MAPPING_N(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_AER - AER Capability Header
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_AER - AER Capability Header (RW)
 *
 * Reset value: 0x00000000
 *
 * The core implements the following PCI Express Extended Capabilities registers: ? Advanced Error
 * Reporting Capability register set ? Virtual Channel Capability register set - Address: 0x100
 */
typedef union _hw_pcie_ep_aer
{
    reg32_t U;
    struct _hw_pcie_ep_aer_bitfields
    {
        unsigned PCI_EXPRESS_EXTENDED_CAPABILITY_ID : 16; //!< [15:0] PCI Express Extended Capability ID
        unsigned CAPABILITY_VERSION : 4; //!< [19:16] Capability Version
        unsigned NEXT_CAPABILITY_OFFSET : 12; //!< [31:20] Next Capability Offset
    } B;
} hw_pcie_ep_aer_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_AER register
 */
//@{
#define HW_PCIE_EP_AER_ADDR      (REGS_PCIE_EP_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_AER           (*(volatile hw_pcie_ep_aer_t *) HW_PCIE_EP_AER_ADDR)
#define HW_PCIE_EP_AER_RD()      (HW_PCIE_EP_AER.U)
#define HW_PCIE_EP_AER_WR(v)     (HW_PCIE_EP_AER.U = (v))
#define HW_PCIE_EP_AER_SET(v)    (HW_PCIE_EP_AER_WR(HW_PCIE_EP_AER_RD() |  (v)))
#define HW_PCIE_EP_AER_CLR(v)    (HW_PCIE_EP_AER_WR(HW_PCIE_EP_AER_RD() & ~(v)))
#define HW_PCIE_EP_AER_TOG(v)    (HW_PCIE_EP_AER_WR(HW_PCIE_EP_AER_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_AER bitfields
 */

/*! @name Register PCIE_EP_AER, field PCI_EXPRESS_EXTENDED_CAPABILITY_ID[15:0] (RW)
 *
 * PCI Express Extended Capability ID Value is 0x1 for Advanced Error Reporting.
 */
//@{
#define BP_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID      (0)      //!< Bit position for PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID.
#define BM_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID      (0x0000ffff)  //!< Bit mask for PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID.

//! @brief Get value of PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID from a register value.
#define BG_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID) >> BP_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID)

//! @brief Format value for bitfield PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID.
#define BF_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID) & BM_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PCI_EXPRESS_EXTENDED_CAPABILITY_ID field to a new value.
#define BW_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID(v)   (HW_PCIE_EP_AER_WR((HW_PCIE_EP_AER_RD() & ~BM_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID) | BF_PCIE_EP_AER_PCI_EXPRESS_EXTENDED_CAPABILITY_ID(v)))
#endif
//@}

/*! @name Register PCIE_EP_AER, field CAPABILITY_VERSION[19:16] (RW)
 *
 * Capability Version
 */
//@{
#define BP_PCIE_EP_AER_CAPABILITY_VERSION      (16)      //!< Bit position for PCIE_EP_AER_CAPABILITY_VERSION.
#define BM_PCIE_EP_AER_CAPABILITY_VERSION      (0x000f0000)  //!< Bit mask for PCIE_EP_AER_CAPABILITY_VERSION.

//! @brief Get value of PCIE_EP_AER_CAPABILITY_VERSION from a register value.
#define BG_PCIE_EP_AER_CAPABILITY_VERSION(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_AER_CAPABILITY_VERSION) >> BP_PCIE_EP_AER_CAPABILITY_VERSION)

//! @brief Format value for bitfield PCIE_EP_AER_CAPABILITY_VERSION.
#define BF_PCIE_EP_AER_CAPABILITY_VERSION(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_AER_CAPABILITY_VERSION) & BM_PCIE_EP_AER_CAPABILITY_VERSION)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CAPABILITY_VERSION field to a new value.
#define BW_PCIE_EP_AER_CAPABILITY_VERSION(v)   (HW_PCIE_EP_AER_WR((HW_PCIE_EP_AER_RD() & ~BM_PCIE_EP_AER_CAPABILITY_VERSION) | BF_PCIE_EP_AER_CAPABILITY_VERSION(v)))
#endif
//@}

/*! @name Register PCIE_EP_AER, field NEXT_CAPABILITY_OFFSET[31:20] (RW)
 *
 * Next Capability Offset
 */
//@{
#define BP_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET      (20)      //!< Bit position for PCIE_EP_AER_NEXT_CAPABILITY_OFFSET.
#define BM_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET      (0xfff00000)  //!< Bit mask for PCIE_EP_AER_NEXT_CAPABILITY_OFFSET.

//! @brief Get value of PCIE_EP_AER_NEXT_CAPABILITY_OFFSET from a register value.
#define BG_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET) >> BP_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET)

//! @brief Format value for bitfield PCIE_EP_AER_NEXT_CAPABILITY_OFFSET.
#define BF_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET) & BM_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NEXT_CAPABILITY_OFFSET field to a new value.
#define BW_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET(v)   (HW_PCIE_EP_AER_WR((HW_PCIE_EP_AER_RD() & ~BM_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET) | BF_PCIE_EP_AER_NEXT_CAPABILITY_OFFSET(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_UESR - Uncorrectable Error Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_UESR - Uncorrectable Error Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x04
 */
typedef union _hw_pcie_ep_uesr
{
    reg32_t U;
    struct _hw_pcie_ep_uesr_bitfields
    {
        unsigned RESERVED0 : 4; //!< [3:0] Reserved.
        unsigned DATA_LINK_PROTOCOL_ERROR_STATUS : 1; //!< [4] Data Link Protocol Error Status
        unsigned SURPRISE_DOWN_ERROR_STATUS : 1; //!< [5] Surprise Down Error Status (not supported)
        unsigned RESERVED1 : 6; //!< [11:6] Reserved
        unsigned POISONED_TLP_STATUS : 1; //!< [12] Poisoned TLP Status
        unsigned FLOW_CONTROL_PROTOCOL_ERROR_STATUS : 1; //!< [13] Flow Control Protocol Error Status
        unsigned COMPLETION_TIMEOUT_STATUS : 1; //!< [14] Completion Timeout Status
        unsigned COMPLETER_ABORT_STATUS : 1; //!< [15] Completer Abort Status
        unsigned UNEXPECTED_COMPLETION_STATUS : 1; //!< [16] Unexpected Completion Status
        unsigned RECEIVER_OVERFLOW_STATUS : 1; //!< [17] Receiver Overflow Status
        unsigned MALFORMED_TLP_STATUS : 1; //!< [18] Malformed TLP Status
        unsigned ECRC_ERROR_STATUS : 1; //!< [19] ECRC Error Status
        unsigned UNSUPPORTED_REQUEST_ERROR_STATUS : 1; //!< [20] Unsupported Request Error Status
        unsigned RESERVED2 : 11; //!< [31:21] Reserved
    } B;
} hw_pcie_ep_uesr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_UESR register
 */
//@{
#define HW_PCIE_EP_UESR_ADDR      (REGS_PCIE_EP_BASE + 0x104)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_UESR           (*(volatile hw_pcie_ep_uesr_t *) HW_PCIE_EP_UESR_ADDR)
#define HW_PCIE_EP_UESR_RD()      (HW_PCIE_EP_UESR.U)
#define HW_PCIE_EP_UESR_WR(v)     (HW_PCIE_EP_UESR.U = (v))
#define HW_PCIE_EP_UESR_SET(v)    (HW_PCIE_EP_UESR_WR(HW_PCIE_EP_UESR_RD() |  (v)))
#define HW_PCIE_EP_UESR_CLR(v)    (HW_PCIE_EP_UESR_WR(HW_PCIE_EP_UESR_RD() & ~(v)))
#define HW_PCIE_EP_UESR_TOG(v)    (HW_PCIE_EP_UESR_WR(HW_PCIE_EP_UESR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_UESR bitfields
 */

/*! @name Register PCIE_EP_UESR, field DATA_LINK_PROTOCOL_ERROR_STATUS[4] (RW)
 *
 * Data Link Protocol Error Status
 */
//@{
#define BP_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS      (4)      //!< Bit position for PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS.
#define BM_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS      (0x00000010)  //!< Bit mask for PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS.

//! @brief Get value of PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS from a register value.
#define BG_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS) >> BP_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS.
#define BF_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS) & BM_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_LINK_PROTOCOL_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS) | BF_PCIE_EP_UESR_DATA_LINK_PROTOCOL_ERROR_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field SURPRISE_DOWN_ERROR_STATUS[5] (RW)
 *
 * Surprise Down Error Status (not supported)
 */
//@{
#define BP_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS      (5)      //!< Bit position for PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS.
#define BM_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS      (0x00000020)  //!< Bit mask for PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS.

//! @brief Get value of PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS from a register value.
#define BG_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS) >> BP_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS.
#define BF_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS) & BM_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SURPRISE_DOWN_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS) | BF_PCIE_EP_UESR_SURPRISE_DOWN_ERROR_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field POISONED_TLP_STATUS[12] (RW)
 *
 * Poisoned TLP Status
 */
//@{
#define BP_PCIE_EP_UESR_POISONED_TLP_STATUS      (12)      //!< Bit position for PCIE_EP_UESR_POISONED_TLP_STATUS.
#define BM_PCIE_EP_UESR_POISONED_TLP_STATUS      (0x00001000)  //!< Bit mask for PCIE_EP_UESR_POISONED_TLP_STATUS.

//! @brief Get value of PCIE_EP_UESR_POISONED_TLP_STATUS from a register value.
#define BG_PCIE_EP_UESR_POISONED_TLP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_POISONED_TLP_STATUS) >> BP_PCIE_EP_UESR_POISONED_TLP_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_POISONED_TLP_STATUS.
#define BF_PCIE_EP_UESR_POISONED_TLP_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_POISONED_TLP_STATUS) & BM_PCIE_EP_UESR_POISONED_TLP_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POISONED_TLP_STATUS field to a new value.
#define BW_PCIE_EP_UESR_POISONED_TLP_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_POISONED_TLP_STATUS) | BF_PCIE_EP_UESR_POISONED_TLP_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field FLOW_CONTROL_PROTOCOL_ERROR_STATUS[13] (RW)
 *
 * Flow Control Protocol Error Status
 */
//@{
#define BP_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS      (13)      //!< Bit position for PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS.
#define BM_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS      (0x00002000)  //!< Bit mask for PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS.

//! @brief Get value of PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS from a register value.
#define BG_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS) >> BP_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS.
#define BF_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS) & BM_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLOW_CONTROL_PROTOCOL_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS) | BF_PCIE_EP_UESR_FLOW_CONTROL_PROTOCOL_ERROR_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field COMPLETION_TIMEOUT_STATUS[14] (RW)
 *
 * Completion Timeout Status
 */
//@{
#define BP_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS      (14)      //!< Bit position for PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS.
#define BM_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS      (0x00004000)  //!< Bit mask for PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS.

//! @brief Get value of PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS from a register value.
#define BG_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS) >> BP_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS.
#define BF_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS) & BM_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETION_TIMEOUT_STATUS field to a new value.
#define BW_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS) | BF_PCIE_EP_UESR_COMPLETION_TIMEOUT_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field COMPLETER_ABORT_STATUS[15] (RW)
 *
 * Completer Abort Status
 */
//@{
#define BP_PCIE_EP_UESR_COMPLETER_ABORT_STATUS      (15)      //!< Bit position for PCIE_EP_UESR_COMPLETER_ABORT_STATUS.
#define BM_PCIE_EP_UESR_COMPLETER_ABORT_STATUS      (0x00008000)  //!< Bit mask for PCIE_EP_UESR_COMPLETER_ABORT_STATUS.

//! @brief Get value of PCIE_EP_UESR_COMPLETER_ABORT_STATUS from a register value.
#define BG_PCIE_EP_UESR_COMPLETER_ABORT_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_COMPLETER_ABORT_STATUS) >> BP_PCIE_EP_UESR_COMPLETER_ABORT_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_COMPLETER_ABORT_STATUS.
#define BF_PCIE_EP_UESR_COMPLETER_ABORT_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_COMPLETER_ABORT_STATUS) & BM_PCIE_EP_UESR_COMPLETER_ABORT_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETER_ABORT_STATUS field to a new value.
#define BW_PCIE_EP_UESR_COMPLETER_ABORT_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_COMPLETER_ABORT_STATUS) | BF_PCIE_EP_UESR_COMPLETER_ABORT_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field UNEXPECTED_COMPLETION_STATUS[16] (RW)
 *
 * Unexpected Completion Status
 */
//@{
#define BP_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS      (16)      //!< Bit position for PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS.
#define BM_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS      (0x00010000)  //!< Bit mask for PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS.

//! @brief Get value of PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS from a register value.
#define BG_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS) >> BP_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS.
#define BF_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS) & BM_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNEXPECTED_COMPLETION_STATUS field to a new value.
#define BW_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS) | BF_PCIE_EP_UESR_UNEXPECTED_COMPLETION_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field RECEIVER_OVERFLOW_STATUS[17] (RW)
 *
 * Receiver Overflow Status
 */
//@{
#define BP_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS      (17)      //!< Bit position for PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS.
#define BM_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS      (0x00020000)  //!< Bit mask for PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS.

//! @brief Get value of PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS from a register value.
#define BG_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS) >> BP_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS.
#define BF_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS) & BM_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVER_OVERFLOW_STATUS field to a new value.
#define BW_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS) | BF_PCIE_EP_UESR_RECEIVER_OVERFLOW_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field MALFORMED_TLP_STATUS[18] (RW)
 *
 * Malformed TLP Status
 */
//@{
#define BP_PCIE_EP_UESR_MALFORMED_TLP_STATUS      (18)      //!< Bit position for PCIE_EP_UESR_MALFORMED_TLP_STATUS.
#define BM_PCIE_EP_UESR_MALFORMED_TLP_STATUS      (0x00040000)  //!< Bit mask for PCIE_EP_UESR_MALFORMED_TLP_STATUS.

//! @brief Get value of PCIE_EP_UESR_MALFORMED_TLP_STATUS from a register value.
#define BG_PCIE_EP_UESR_MALFORMED_TLP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_MALFORMED_TLP_STATUS) >> BP_PCIE_EP_UESR_MALFORMED_TLP_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_MALFORMED_TLP_STATUS.
#define BF_PCIE_EP_UESR_MALFORMED_TLP_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_MALFORMED_TLP_STATUS) & BM_PCIE_EP_UESR_MALFORMED_TLP_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MALFORMED_TLP_STATUS field to a new value.
#define BW_PCIE_EP_UESR_MALFORMED_TLP_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_MALFORMED_TLP_STATUS) | BF_PCIE_EP_UESR_MALFORMED_TLP_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field ECRC_ERROR_STATUS[19] (RW)
 *
 * ECRC Error Status
 */
//@{
#define BP_PCIE_EP_UESR_ECRC_ERROR_STATUS      (19)      //!< Bit position for PCIE_EP_UESR_ECRC_ERROR_STATUS.
#define BM_PCIE_EP_UESR_ECRC_ERROR_STATUS      (0x00080000)  //!< Bit mask for PCIE_EP_UESR_ECRC_ERROR_STATUS.

//! @brief Get value of PCIE_EP_UESR_ECRC_ERROR_STATUS from a register value.
#define BG_PCIE_EP_UESR_ECRC_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_ECRC_ERROR_STATUS) >> BP_PCIE_EP_UESR_ECRC_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_ECRC_ERROR_STATUS.
#define BF_PCIE_EP_UESR_ECRC_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_ECRC_ERROR_STATUS) & BM_PCIE_EP_UESR_ECRC_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_UESR_ECRC_ERROR_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_ECRC_ERROR_STATUS) | BF_PCIE_EP_UESR_ECRC_ERROR_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESR, field UNSUPPORTED_REQUEST_ERROR_STATUS[20] (RW)
 *
 * Unsupported Request Error Status
 */
//@{
#define BP_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS      (20)      //!< Bit position for PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS.
#define BM_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS      (0x00100000)  //!< Bit mask for PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS.

//! @brief Get value of PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS from a register value.
#define BG_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS) >> BP_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS.
#define BF_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS) & BM_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNSUPPORTED_REQUEST_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS(v)   (HW_PCIE_EP_UESR_WR((HW_PCIE_EP_UESR_RD() & ~BM_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS) | BF_PCIE_EP_UESR_UNSUPPORTED_REQUEST_ERROR_STATUS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_UEMR - Uncorrectable Error Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_UEMR - Uncorrectable Error Mask Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x08
 */
typedef union _hw_pcie_ep_uemr
{
    reg32_t U;
    struct _hw_pcie_ep_uemr_bitfields
    {
        unsigned RESERVED0 : 4; //!< [3:0] Reserved.
        unsigned DATA_LINK_PROTOCOL_ERROR_MASK : 1; //!< [4] Data Link Protocol Error Mask
        unsigned SURPRISE_DOWN_ERROR_MASK : 1; //!< [5] Surprise Down Error Mask (not supported)
        unsigned RESERVED1 : 6; //!< [11:6] Reserved
        unsigned POISONED_TLP_MASK : 1; //!< [12] Poisoned TLP Mask
        unsigned FLOW_CONTROL_PROTOCOL_ERROR_MASK : 1; //!< [13] Flow Control Protocol Error Mask
        unsigned COMPLETION_TIMEOUT_MASK : 1; //!< [14] Completion Timeout Mask
        unsigned COMPLETER_ABORT_MASK : 1; //!< [15] Completer Abort Mask
        unsigned UNEXPECTED_COMPLETION_MASK : 1; //!< [16] Unexpected Completion Mask
        unsigned RECEIVER_OVERFLOW_MASK : 1; //!< [17] Receiver Overflow Mask
        unsigned MALFORMED_TLP_MASK : 1; //!< [18] Malformed TLP Mask
        unsigned ECRC_ERROR_MASK : 1; //!< [19] ECRC Error Mask
        unsigned UNSUPPORTED_REQUEST_ERROR_MASK : 1; //!< [20] Unsupported Request Error Mask
        unsigned RESERVED2 : 11; //!< [31:21] Reserved
    } B;
} hw_pcie_ep_uemr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_UEMR register
 */
//@{
#define HW_PCIE_EP_UEMR_ADDR      (REGS_PCIE_EP_BASE + 0x108)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_UEMR           (*(volatile hw_pcie_ep_uemr_t *) HW_PCIE_EP_UEMR_ADDR)
#define HW_PCIE_EP_UEMR_RD()      (HW_PCIE_EP_UEMR.U)
#define HW_PCIE_EP_UEMR_WR(v)     (HW_PCIE_EP_UEMR.U = (v))
#define HW_PCIE_EP_UEMR_SET(v)    (HW_PCIE_EP_UEMR_WR(HW_PCIE_EP_UEMR_RD() |  (v)))
#define HW_PCIE_EP_UEMR_CLR(v)    (HW_PCIE_EP_UEMR_WR(HW_PCIE_EP_UEMR_RD() & ~(v)))
#define HW_PCIE_EP_UEMR_TOG(v)    (HW_PCIE_EP_UEMR_WR(HW_PCIE_EP_UEMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_UEMR bitfields
 */

/*! @name Register PCIE_EP_UEMR, field DATA_LINK_PROTOCOL_ERROR_MASK[4] (RW)
 *
 * Data Link Protocol Error Mask
 */
//@{
#define BP_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK      (4)      //!< Bit position for PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK.
#define BM_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK      (0x00000010)  //!< Bit mask for PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK.

//! @brief Get value of PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK from a register value.
#define BG_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK) >> BP_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK.
#define BF_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK) & BM_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_LINK_PROTOCOL_ERROR_MASK field to a new value.
#define BW_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK) | BF_PCIE_EP_UEMR_DATA_LINK_PROTOCOL_ERROR_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field SURPRISE_DOWN_ERROR_MASK[5] (RW)
 *
 * Surprise Down Error Mask (not supported)
 */
//@{
#define BP_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK      (5)      //!< Bit position for PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK.
#define BM_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK      (0x00000020)  //!< Bit mask for PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK.

//! @brief Get value of PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK from a register value.
#define BG_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK) >> BP_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK.
#define BF_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK) & BM_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SURPRISE_DOWN_ERROR_MASK field to a new value.
#define BW_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK) | BF_PCIE_EP_UEMR_SURPRISE_DOWN_ERROR_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field POISONED_TLP_MASK[12] (RW)
 *
 * Poisoned TLP Mask
 */
//@{
#define BP_PCIE_EP_UEMR_POISONED_TLP_MASK      (12)      //!< Bit position for PCIE_EP_UEMR_POISONED_TLP_MASK.
#define BM_PCIE_EP_UEMR_POISONED_TLP_MASK      (0x00001000)  //!< Bit mask for PCIE_EP_UEMR_POISONED_TLP_MASK.

//! @brief Get value of PCIE_EP_UEMR_POISONED_TLP_MASK from a register value.
#define BG_PCIE_EP_UEMR_POISONED_TLP_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_POISONED_TLP_MASK) >> BP_PCIE_EP_UEMR_POISONED_TLP_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_POISONED_TLP_MASK.
#define BF_PCIE_EP_UEMR_POISONED_TLP_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_POISONED_TLP_MASK) & BM_PCIE_EP_UEMR_POISONED_TLP_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POISONED_TLP_MASK field to a new value.
#define BW_PCIE_EP_UEMR_POISONED_TLP_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_POISONED_TLP_MASK) | BF_PCIE_EP_UEMR_POISONED_TLP_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field FLOW_CONTROL_PROTOCOL_ERROR_MASK[13] (RW)
 *
 * Flow Control Protocol Error Mask
 */
//@{
#define BP_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK      (13)      //!< Bit position for PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK.
#define BM_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK      (0x00002000)  //!< Bit mask for PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK.

//! @brief Get value of PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK from a register value.
#define BG_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK) >> BP_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK.
#define BF_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK) & BM_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLOW_CONTROL_PROTOCOL_ERROR_MASK field to a new value.
#define BW_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK) | BF_PCIE_EP_UEMR_FLOW_CONTROL_PROTOCOL_ERROR_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field COMPLETION_TIMEOUT_MASK[14] (RW)
 *
 * Completion Timeout Mask
 */
//@{
#define BP_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK      (14)      //!< Bit position for PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK.
#define BM_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK      (0x00004000)  //!< Bit mask for PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK.

//! @brief Get value of PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK from a register value.
#define BG_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK) >> BP_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK.
#define BF_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK) & BM_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETION_TIMEOUT_MASK field to a new value.
#define BW_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK) | BF_PCIE_EP_UEMR_COMPLETION_TIMEOUT_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field COMPLETER_ABORT_MASK[15] (RW)
 *
 * Completer Abort Mask
 */
//@{
#define BP_PCIE_EP_UEMR_COMPLETER_ABORT_MASK      (15)      //!< Bit position for PCIE_EP_UEMR_COMPLETER_ABORT_MASK.
#define BM_PCIE_EP_UEMR_COMPLETER_ABORT_MASK      (0x00008000)  //!< Bit mask for PCIE_EP_UEMR_COMPLETER_ABORT_MASK.

//! @brief Get value of PCIE_EP_UEMR_COMPLETER_ABORT_MASK from a register value.
#define BG_PCIE_EP_UEMR_COMPLETER_ABORT_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_COMPLETER_ABORT_MASK) >> BP_PCIE_EP_UEMR_COMPLETER_ABORT_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_COMPLETER_ABORT_MASK.
#define BF_PCIE_EP_UEMR_COMPLETER_ABORT_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_COMPLETER_ABORT_MASK) & BM_PCIE_EP_UEMR_COMPLETER_ABORT_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETER_ABORT_MASK field to a new value.
#define BW_PCIE_EP_UEMR_COMPLETER_ABORT_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_COMPLETER_ABORT_MASK) | BF_PCIE_EP_UEMR_COMPLETER_ABORT_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field UNEXPECTED_COMPLETION_MASK[16] (RW)
 *
 * Unexpected Completion Mask
 */
//@{
#define BP_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK      (16)      //!< Bit position for PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK.
#define BM_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK      (0x00010000)  //!< Bit mask for PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK.

//! @brief Get value of PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK from a register value.
#define BG_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK) >> BP_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK.
#define BF_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK) & BM_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNEXPECTED_COMPLETION_MASK field to a new value.
#define BW_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK) | BF_PCIE_EP_UEMR_UNEXPECTED_COMPLETION_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field RECEIVER_OVERFLOW_MASK[17] (RW)
 *
 * Receiver Overflow Mask
 */
//@{
#define BP_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK      (17)      //!< Bit position for PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK.
#define BM_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK      (0x00020000)  //!< Bit mask for PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK.

//! @brief Get value of PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK from a register value.
#define BG_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK) >> BP_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK.
#define BF_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK) & BM_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVER_OVERFLOW_MASK field to a new value.
#define BW_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK) | BF_PCIE_EP_UEMR_RECEIVER_OVERFLOW_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field MALFORMED_TLP_MASK[18] (RW)
 *
 * Malformed TLP Mask
 */
//@{
#define BP_PCIE_EP_UEMR_MALFORMED_TLP_MASK      (18)      //!< Bit position for PCIE_EP_UEMR_MALFORMED_TLP_MASK.
#define BM_PCIE_EP_UEMR_MALFORMED_TLP_MASK      (0x00040000)  //!< Bit mask for PCIE_EP_UEMR_MALFORMED_TLP_MASK.

//! @brief Get value of PCIE_EP_UEMR_MALFORMED_TLP_MASK from a register value.
#define BG_PCIE_EP_UEMR_MALFORMED_TLP_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_MALFORMED_TLP_MASK) >> BP_PCIE_EP_UEMR_MALFORMED_TLP_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_MALFORMED_TLP_MASK.
#define BF_PCIE_EP_UEMR_MALFORMED_TLP_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_MALFORMED_TLP_MASK) & BM_PCIE_EP_UEMR_MALFORMED_TLP_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MALFORMED_TLP_MASK field to a new value.
#define BW_PCIE_EP_UEMR_MALFORMED_TLP_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_MALFORMED_TLP_MASK) | BF_PCIE_EP_UEMR_MALFORMED_TLP_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field ECRC_ERROR_MASK[19] (RW)
 *
 * ECRC Error Mask
 */
//@{
#define BP_PCIE_EP_UEMR_ECRC_ERROR_MASK      (19)      //!< Bit position for PCIE_EP_UEMR_ECRC_ERROR_MASK.
#define BM_PCIE_EP_UEMR_ECRC_ERROR_MASK      (0x00080000)  //!< Bit mask for PCIE_EP_UEMR_ECRC_ERROR_MASK.

//! @brief Get value of PCIE_EP_UEMR_ECRC_ERROR_MASK from a register value.
#define BG_PCIE_EP_UEMR_ECRC_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_ECRC_ERROR_MASK) >> BP_PCIE_EP_UEMR_ECRC_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_ECRC_ERROR_MASK.
#define BF_PCIE_EP_UEMR_ECRC_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_ECRC_ERROR_MASK) & BM_PCIE_EP_UEMR_ECRC_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_ERROR_MASK field to a new value.
#define BW_PCIE_EP_UEMR_ECRC_ERROR_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_ECRC_ERROR_MASK) | BF_PCIE_EP_UEMR_ECRC_ERROR_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_UEMR, field UNSUPPORTED_REQUEST_ERROR_MASK[20] (RW)
 *
 * Unsupported Request Error Mask
 */
//@{
#define BP_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK      (20)      //!< Bit position for PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK.
#define BM_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK      (0x00100000)  //!< Bit mask for PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK.

//! @brief Get value of PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK from a register value.
#define BG_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK) >> BP_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK.
#define BF_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK) & BM_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNSUPPORTED_REQUEST_ERROR_MASK field to a new value.
#define BW_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK(v)   (HW_PCIE_EP_UEMR_WR((HW_PCIE_EP_UEMR_RD() & ~BM_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK) | BF_PCIE_EP_UEMR_UNSUPPORTED_REQUEST_ERROR_MASK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_UESEVR - Uncorrectable Error Severity Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_UESEVR - Uncorrectable Error Severity Register (RW)
 *
 * Reset value: 0x000c2031
 *
 * Offset: 0x0C
 */
typedef union _hw_pcie_ep_uesevr
{
    reg32_t U;
    struct _hw_pcie_ep_uesevr_bitfields
    {
        unsigned RESERVED0 : 4; //!< [3:0] Reserved.
        unsigned DATA_LINK_PROTOCOL_ERROR_SEVERITY : 1; //!< [4] Data Link Protocol Error Severity
        unsigned SURPRISE_DOWN_ERROR_SEVERITY : 1; //!< [5] Surprise Down Error Severity (not supported)
        unsigned RESERVED1 : 6; //!< [11:6] Reserved
        unsigned POISONED_TLP_SEVERITY : 1; //!< [12] Poisoned TLP Severity
        unsigned FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY : 1; //!< [13] Flow Control Protocol Error Severity
        unsigned COMPLETION_TIMEOUT_SEVERITY : 1; //!< [14] Completion Timeout Severity
        unsigned COMPLETER_ABORT_SEVERITY : 1; //!< [15] Completer Abort Severity
        unsigned UNEXPECTED_COMPLETION_SEVERITY : 1; //!< [16] Unexpected Completion Severity
        unsigned RECEIVER_OVERFLOW_SEVERITY : 1; //!< [17] Receiver Overflow Severity
        unsigned MALFORMED_TLP_SEVERITY : 1; //!< [18] Malformed TLP Severity
        unsigned ECRC_ERROR_SEVERITY : 1; //!< [19] ECRC Error Severity
        unsigned UNSUPPORTED_REQUEST_ERROR_SEVERITY : 1; //!< [20] Unsupported Request Error Severity
        unsigned RESERVED2 : 11; //!< [31:21] Reserved
    } B;
} hw_pcie_ep_uesevr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_UESEVR register
 */
//@{
#define HW_PCIE_EP_UESEVR_ADDR      (REGS_PCIE_EP_BASE + 0x10c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_UESEVR           (*(volatile hw_pcie_ep_uesevr_t *) HW_PCIE_EP_UESEVR_ADDR)
#define HW_PCIE_EP_UESEVR_RD()      (HW_PCIE_EP_UESEVR.U)
#define HW_PCIE_EP_UESEVR_WR(v)     (HW_PCIE_EP_UESEVR.U = (v))
#define HW_PCIE_EP_UESEVR_SET(v)    (HW_PCIE_EP_UESEVR_WR(HW_PCIE_EP_UESEVR_RD() |  (v)))
#define HW_PCIE_EP_UESEVR_CLR(v)    (HW_PCIE_EP_UESEVR_WR(HW_PCIE_EP_UESEVR_RD() & ~(v)))
#define HW_PCIE_EP_UESEVR_TOG(v)    (HW_PCIE_EP_UESEVR_WR(HW_PCIE_EP_UESEVR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_UESEVR bitfields
 */

/*! @name Register PCIE_EP_UESEVR, field DATA_LINK_PROTOCOL_ERROR_SEVERITY[4] (RW)
 *
 * Data Link Protocol Error Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY      (4)      //!< Bit position for PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY.
#define BM_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY      (0x00000010)  //!< Bit mask for PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY) >> BP_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY.
#define BF_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY) & BM_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_LINK_PROTOCOL_ERROR_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY) | BF_PCIE_EP_UESEVR_DATA_LINK_PROTOCOL_ERROR_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field SURPRISE_DOWN_ERROR_SEVERITY[5] (RW)
 *
 * Surprise Down Error Severity (not supported)
 */
//@{
#define BP_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY      (5)      //!< Bit position for PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY.
#define BM_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY      (0x00000020)  //!< Bit mask for PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY) >> BP_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY.
#define BF_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY) & BM_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SURPRISE_DOWN_ERROR_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY) | BF_PCIE_EP_UESEVR_SURPRISE_DOWN_ERROR_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field POISONED_TLP_SEVERITY[12] (RW)
 *
 * Poisoned TLP Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY      (12)      //!< Bit position for PCIE_EP_UESEVR_POISONED_TLP_SEVERITY.
#define BM_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY      (0x00001000)  //!< Bit mask for PCIE_EP_UESEVR_POISONED_TLP_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_POISONED_TLP_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY) >> BP_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_POISONED_TLP_SEVERITY.
#define BF_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY) & BM_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POISONED_TLP_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY) | BF_PCIE_EP_UESEVR_POISONED_TLP_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY[13] (RW)
 *
 * Flow Control Protocol Error Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY      (13)      //!< Bit position for PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY.
#define BM_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY      (0x00002000)  //!< Bit mask for PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY) >> BP_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY.
#define BF_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY) & BM_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY) | BF_PCIE_EP_UESEVR_FLOW_CONTROL_PROTOCOL_ERROR_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field COMPLETION_TIMEOUT_SEVERITY[14] (RW)
 *
 * Completion Timeout Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY      (14)      //!< Bit position for PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY.
#define BM_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY      (0x00004000)  //!< Bit mask for PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY) >> BP_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY.
#define BF_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY) & BM_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETION_TIMEOUT_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY) | BF_PCIE_EP_UESEVR_COMPLETION_TIMEOUT_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field COMPLETER_ABORT_SEVERITY[15] (RW)
 *
 * Completer Abort Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY      (15)      //!< Bit position for PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY.
#define BM_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY      (0x00008000)  //!< Bit mask for PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY) >> BP_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY.
#define BF_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY) & BM_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COMPLETER_ABORT_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY) | BF_PCIE_EP_UESEVR_COMPLETER_ABORT_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field UNEXPECTED_COMPLETION_SEVERITY[16] (RW)
 *
 * Unexpected Completion Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY      (16)      //!< Bit position for PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY.
#define BM_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY      (0x00010000)  //!< Bit mask for PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY) >> BP_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY.
#define BF_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY) & BM_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNEXPECTED_COMPLETION_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY) | BF_PCIE_EP_UESEVR_UNEXPECTED_COMPLETION_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field RECEIVER_OVERFLOW_SEVERITY[17] (RW)
 *
 * Receiver Overflow Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY      (17)      //!< Bit position for PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY.
#define BM_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY      (0x00020000)  //!< Bit mask for PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY) >> BP_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY.
#define BF_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY) & BM_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVER_OVERFLOW_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY) | BF_PCIE_EP_UESEVR_RECEIVER_OVERFLOW_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field MALFORMED_TLP_SEVERITY[18] (RW)
 *
 * Malformed TLP Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY      (18)      //!< Bit position for PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY.
#define BM_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY      (0x00040000)  //!< Bit mask for PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY) >> BP_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY.
#define BF_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY) & BM_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MALFORMED_TLP_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY) | BF_PCIE_EP_UESEVR_MALFORMED_TLP_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field ECRC_ERROR_SEVERITY[19] (RW)
 *
 * ECRC Error Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY      (19)      //!< Bit position for PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY.
#define BM_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY      (0x00080000)  //!< Bit mask for PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY) >> BP_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY.
#define BF_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY) & BM_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_ERROR_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY) | BF_PCIE_EP_UESEVR_ECRC_ERROR_SEVERITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_UESEVR, field UNSUPPORTED_REQUEST_ERROR_SEVERITY[20] (RW)
 *
 * Unsupported Request Error Severity
 */
//@{
#define BP_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY      (20)      //!< Bit position for PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY.
#define BM_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY      (0x00100000)  //!< Bit mask for PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY.

//! @brief Get value of PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY from a register value.
#define BG_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY) >> BP_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY)

//! @brief Format value for bitfield PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY.
#define BF_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY) & BM_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UNSUPPORTED_REQUEST_ERROR_SEVERITY field to a new value.
#define BW_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY(v)   (HW_PCIE_EP_UESEVR_WR((HW_PCIE_EP_UESEVR_RD() & ~BM_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY) | BF_PCIE_EP_UESEVR_UNSUPPORTED_REQUEST_ERROR_SEVERITY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_CESR - Correctable Error Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_CESR - Correctable Error Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x10
 */
typedef union _hw_pcie_ep_cesr
{
    reg32_t U;
    struct _hw_pcie_ep_cesr_bitfields
    {
        unsigned RECEIVER_ERROR_STATUS : 1; //!< [0] Receiver Error Status
        unsigned RESERVED0 : 5; //!< [5:1] Reserved
        unsigned BAD_TLP_STATUS : 1; //!< [6] Bad TLP Status
        unsigned BAD_DLLP_STATUS : 1; //!< [7] Bad DLLP Status
        unsigned REPLAY_NUM_ROLLOVER_STATUS : 1; //!< [8] REPLAY_NUM Rollover Status
        unsigned RESERVED1 : 3; //!< [11:9] Reserved
        unsigned REPLY_TIMER_TIMEOUT_STATUS : 1; //!< [12] Reply Timer Timeout Status
        unsigned ADVISORY_NON_FATAL_ERROR_STATUS : 1; //!< [13] Advisory Non-Fatal Error Status
        unsigned RESERVED2 : 18; //!< [31:14] Reserved
    } B;
} hw_pcie_ep_cesr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_CESR register
 */
//@{
#define HW_PCIE_EP_CESR_ADDR      (REGS_PCIE_EP_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_CESR           (*(volatile hw_pcie_ep_cesr_t *) HW_PCIE_EP_CESR_ADDR)
#define HW_PCIE_EP_CESR_RD()      (HW_PCIE_EP_CESR.U)
#define HW_PCIE_EP_CESR_WR(v)     (HW_PCIE_EP_CESR.U = (v))
#define HW_PCIE_EP_CESR_SET(v)    (HW_PCIE_EP_CESR_WR(HW_PCIE_EP_CESR_RD() |  (v)))
#define HW_PCIE_EP_CESR_CLR(v)    (HW_PCIE_EP_CESR_WR(HW_PCIE_EP_CESR_RD() & ~(v)))
#define HW_PCIE_EP_CESR_TOG(v)    (HW_PCIE_EP_CESR_WR(HW_PCIE_EP_CESR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_CESR bitfields
 */

/*! @name Register PCIE_EP_CESR, field RECEIVER_ERROR_STATUS[0] (RW)
 *
 * Receiver Error Status
 */
//@{
#define BP_PCIE_EP_CESR_RECEIVER_ERROR_STATUS      (0)      //!< Bit position for PCIE_EP_CESR_RECEIVER_ERROR_STATUS.
#define BM_PCIE_EP_CESR_RECEIVER_ERROR_STATUS      (0x00000001)  //!< Bit mask for PCIE_EP_CESR_RECEIVER_ERROR_STATUS.

//! @brief Get value of PCIE_EP_CESR_RECEIVER_ERROR_STATUS from a register value.
#define BG_PCIE_EP_CESR_RECEIVER_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_RECEIVER_ERROR_STATUS) >> BP_PCIE_EP_CESR_RECEIVER_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_RECEIVER_ERROR_STATUS.
#define BF_PCIE_EP_CESR_RECEIVER_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_RECEIVER_ERROR_STATUS) & BM_PCIE_EP_CESR_RECEIVER_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVER_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_CESR_RECEIVER_ERROR_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_RECEIVER_ERROR_STATUS) | BF_PCIE_EP_CESR_RECEIVER_ERROR_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_CESR, field BAD_TLP_STATUS[6] (RW)
 *
 * Bad TLP Status
 */
//@{
#define BP_PCIE_EP_CESR_BAD_TLP_STATUS      (6)      //!< Bit position for PCIE_EP_CESR_BAD_TLP_STATUS.
#define BM_PCIE_EP_CESR_BAD_TLP_STATUS      (0x00000040)  //!< Bit mask for PCIE_EP_CESR_BAD_TLP_STATUS.

//! @brief Get value of PCIE_EP_CESR_BAD_TLP_STATUS from a register value.
#define BG_PCIE_EP_CESR_BAD_TLP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_BAD_TLP_STATUS) >> BP_PCIE_EP_CESR_BAD_TLP_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_BAD_TLP_STATUS.
#define BF_PCIE_EP_CESR_BAD_TLP_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_BAD_TLP_STATUS) & BM_PCIE_EP_CESR_BAD_TLP_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BAD_TLP_STATUS field to a new value.
#define BW_PCIE_EP_CESR_BAD_TLP_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_BAD_TLP_STATUS) | BF_PCIE_EP_CESR_BAD_TLP_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_CESR, field BAD_DLLP_STATUS[7] (RW)
 *
 * Bad DLLP Status
 */
//@{
#define BP_PCIE_EP_CESR_BAD_DLLP_STATUS      (7)      //!< Bit position for PCIE_EP_CESR_BAD_DLLP_STATUS.
#define BM_PCIE_EP_CESR_BAD_DLLP_STATUS      (0x00000080)  //!< Bit mask for PCIE_EP_CESR_BAD_DLLP_STATUS.

//! @brief Get value of PCIE_EP_CESR_BAD_DLLP_STATUS from a register value.
#define BG_PCIE_EP_CESR_BAD_DLLP_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_BAD_DLLP_STATUS) >> BP_PCIE_EP_CESR_BAD_DLLP_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_BAD_DLLP_STATUS.
#define BF_PCIE_EP_CESR_BAD_DLLP_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_BAD_DLLP_STATUS) & BM_PCIE_EP_CESR_BAD_DLLP_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BAD_DLLP_STATUS field to a new value.
#define BW_PCIE_EP_CESR_BAD_DLLP_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_BAD_DLLP_STATUS) | BF_PCIE_EP_CESR_BAD_DLLP_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_CESR, field REPLAY_NUM_ROLLOVER_STATUS[8] (RW)
 *
 * REPLAY_NUM Rollover Status
 */
//@{
#define BP_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS      (8)      //!< Bit position for PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS.
#define BM_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS      (0x00000100)  //!< Bit mask for PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS.

//! @brief Get value of PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS from a register value.
#define BG_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS) >> BP_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS.
#define BF_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS) & BM_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REPLAY_NUM_ROLLOVER_STATUS field to a new value.
#define BW_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS) | BF_PCIE_EP_CESR_REPLAY_NUM_ROLLOVER_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_CESR, field REPLY_TIMER_TIMEOUT_STATUS[12] (RW)
 *
 * Reply Timer Timeout Status
 */
//@{
#define BP_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS      (12)      //!< Bit position for PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS.
#define BM_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS      (0x00001000)  //!< Bit mask for PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS.

//! @brief Get value of PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS from a register value.
#define BG_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS) >> BP_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS.
#define BF_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS) & BM_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REPLY_TIMER_TIMEOUT_STATUS field to a new value.
#define BW_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS) | BF_PCIE_EP_CESR_REPLY_TIMER_TIMEOUT_STATUS(v)))
#endif
//@}

/*! @name Register PCIE_EP_CESR, field ADVISORY_NON_FATAL_ERROR_STATUS[13] (RW)
 *
 * Advisory Non-Fatal Error Status
 */
//@{
#define BP_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS      (13)      //!< Bit position for PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS.
#define BM_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS      (0x00002000)  //!< Bit mask for PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS.

//! @brief Get value of PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS from a register value.
#define BG_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS) >> BP_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS)

//! @brief Format value for bitfield PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS.
#define BF_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS) & BM_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADVISORY_NON_FATAL_ERROR_STATUS field to a new value.
#define BW_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS(v)   (HW_PCIE_EP_CESR_WR((HW_PCIE_EP_CESR_RD() & ~BM_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS) | BF_PCIE_EP_CESR_ADVISORY_NON_FATAL_ERROR_STATUS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_CEMR - Correctable Error Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_CEMR - Correctable Error Mask Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x14
 */
typedef union _hw_pcie_ep_cemr
{
    reg32_t U;
    struct _hw_pcie_ep_cemr_bitfields
    {
        unsigned RECEIVER_ERROR_MASK : 1; //!< [0] Receiver Error Mask
        unsigned RESERVED0 : 5; //!< [5:1] Reserved
        unsigned BAD_TLP_MASK : 1; //!< [6] Bad TLP Mask
        unsigned BAD_DLLP_MASK : 1; //!< [7] Bad DLLP Mask
        unsigned REPLAY_NUM_ROLLOVER_MASK : 1; //!< [8] REPLAY_NUM Rollover Mask
        unsigned RESERVED1 : 3; //!< [11:9] Reserved
        unsigned REPLY_TIMER_TIMEOUT_MASK : 1; //!< [12] Reply Timer Timeout Mask
        unsigned ADVISORY_NON_FATAL_ERROR_MASK : 1; //!< [13] Advisory Non-Fatal Error Mask
        unsigned RESERVED2 : 18; //!< [31:14] Reserved
    } B;
} hw_pcie_ep_cemr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_CEMR register
 */
//@{
#define HW_PCIE_EP_CEMR_ADDR      (REGS_PCIE_EP_BASE + 0x114)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_CEMR           (*(volatile hw_pcie_ep_cemr_t *) HW_PCIE_EP_CEMR_ADDR)
#define HW_PCIE_EP_CEMR_RD()      (HW_PCIE_EP_CEMR.U)
#define HW_PCIE_EP_CEMR_WR(v)     (HW_PCIE_EP_CEMR.U = (v))
#define HW_PCIE_EP_CEMR_SET(v)    (HW_PCIE_EP_CEMR_WR(HW_PCIE_EP_CEMR_RD() |  (v)))
#define HW_PCIE_EP_CEMR_CLR(v)    (HW_PCIE_EP_CEMR_WR(HW_PCIE_EP_CEMR_RD() & ~(v)))
#define HW_PCIE_EP_CEMR_TOG(v)    (HW_PCIE_EP_CEMR_WR(HW_PCIE_EP_CEMR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_CEMR bitfields
 */

/*! @name Register PCIE_EP_CEMR, field RECEIVER_ERROR_MASK[0] (RW)
 *
 * Receiver Error Mask
 */
//@{
#define BP_PCIE_EP_CEMR_RECEIVER_ERROR_MASK      (0)      //!< Bit position for PCIE_EP_CEMR_RECEIVER_ERROR_MASK.
#define BM_PCIE_EP_CEMR_RECEIVER_ERROR_MASK      (0x00000001)  //!< Bit mask for PCIE_EP_CEMR_RECEIVER_ERROR_MASK.

//! @brief Get value of PCIE_EP_CEMR_RECEIVER_ERROR_MASK from a register value.
#define BG_PCIE_EP_CEMR_RECEIVER_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_RECEIVER_ERROR_MASK) >> BP_PCIE_EP_CEMR_RECEIVER_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_RECEIVER_ERROR_MASK.
#define BF_PCIE_EP_CEMR_RECEIVER_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_RECEIVER_ERROR_MASK) & BM_PCIE_EP_CEMR_RECEIVER_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RECEIVER_ERROR_MASK field to a new value.
#define BW_PCIE_EP_CEMR_RECEIVER_ERROR_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_RECEIVER_ERROR_MASK) | BF_PCIE_EP_CEMR_RECEIVER_ERROR_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_CEMR, field BAD_TLP_MASK[6] (RW)
 *
 * Bad TLP Mask
 */
//@{
#define BP_PCIE_EP_CEMR_BAD_TLP_MASK      (6)      //!< Bit position for PCIE_EP_CEMR_BAD_TLP_MASK.
#define BM_PCIE_EP_CEMR_BAD_TLP_MASK      (0x00000040)  //!< Bit mask for PCIE_EP_CEMR_BAD_TLP_MASK.

//! @brief Get value of PCIE_EP_CEMR_BAD_TLP_MASK from a register value.
#define BG_PCIE_EP_CEMR_BAD_TLP_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_BAD_TLP_MASK) >> BP_PCIE_EP_CEMR_BAD_TLP_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_BAD_TLP_MASK.
#define BF_PCIE_EP_CEMR_BAD_TLP_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_BAD_TLP_MASK) & BM_PCIE_EP_CEMR_BAD_TLP_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BAD_TLP_MASK field to a new value.
#define BW_PCIE_EP_CEMR_BAD_TLP_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_BAD_TLP_MASK) | BF_PCIE_EP_CEMR_BAD_TLP_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_CEMR, field BAD_DLLP_MASK[7] (RW)
 *
 * Bad DLLP Mask
 */
//@{
#define BP_PCIE_EP_CEMR_BAD_DLLP_MASK      (7)      //!< Bit position for PCIE_EP_CEMR_BAD_DLLP_MASK.
#define BM_PCIE_EP_CEMR_BAD_DLLP_MASK      (0x00000080)  //!< Bit mask for PCIE_EP_CEMR_BAD_DLLP_MASK.

//! @brief Get value of PCIE_EP_CEMR_BAD_DLLP_MASK from a register value.
#define BG_PCIE_EP_CEMR_BAD_DLLP_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_BAD_DLLP_MASK) >> BP_PCIE_EP_CEMR_BAD_DLLP_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_BAD_DLLP_MASK.
#define BF_PCIE_EP_CEMR_BAD_DLLP_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_BAD_DLLP_MASK) & BM_PCIE_EP_CEMR_BAD_DLLP_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BAD_DLLP_MASK field to a new value.
#define BW_PCIE_EP_CEMR_BAD_DLLP_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_BAD_DLLP_MASK) | BF_PCIE_EP_CEMR_BAD_DLLP_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_CEMR, field REPLAY_NUM_ROLLOVER_MASK[8] (RW)
 *
 * REPLAY_NUM Rollover Mask
 */
//@{
#define BP_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK      (8)      //!< Bit position for PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK.
#define BM_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK      (0x00000100)  //!< Bit mask for PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK.

//! @brief Get value of PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK from a register value.
#define BG_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK) >> BP_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK.
#define BF_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK) & BM_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REPLAY_NUM_ROLLOVER_MASK field to a new value.
#define BW_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK) | BF_PCIE_EP_CEMR_REPLAY_NUM_ROLLOVER_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_CEMR, field REPLY_TIMER_TIMEOUT_MASK[12] (RW)
 *
 * Reply Timer Timeout Mask
 */
//@{
#define BP_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK      (12)      //!< Bit position for PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK.
#define BM_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK      (0x00001000)  //!< Bit mask for PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK.

//! @brief Get value of PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK from a register value.
#define BG_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK) >> BP_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK.
#define BF_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK) & BM_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REPLY_TIMER_TIMEOUT_MASK field to a new value.
#define BW_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK) | BF_PCIE_EP_CEMR_REPLY_TIMER_TIMEOUT_MASK(v)))
#endif
//@}

/*! @name Register PCIE_EP_CEMR, field ADVISORY_NON_FATAL_ERROR_MASK[13] (RW)
 *
 * Advisory Non-Fatal Error Mask
 */
//@{
#define BP_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK      (13)      //!< Bit position for PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK.
#define BM_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK      (0x00002000)  //!< Bit mask for PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK.

//! @brief Get value of PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK from a register value.
#define BG_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK) >> BP_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK)

//! @brief Format value for bitfield PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK.
#define BF_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK) & BM_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADVISORY_NON_FATAL_ERROR_MASK field to a new value.
#define BW_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK(v)   (HW_PCIE_EP_CEMR_WR((HW_PCIE_EP_CEMR_RD() & ~BM_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK) | BF_PCIE_EP_CEMR_ADVISORY_NON_FATAL_ERROR_MASK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_ACCR - Advanced Capabilities and Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_ACCR - Advanced Capabilities and Control Register (RW)
 *
 * Reset value: 0x000000a0
 *
 * Offset: 0x18
 */
typedef union _hw_pcie_ep_accr
{
    reg32_t U;
    struct _hw_pcie_ep_accr_bitfields
    {
        unsigned FIRST_ERROR_POINTER : 5; //!< [4:0] First Error Pointer
        unsigned ECRC_GENERATION_CAPABILITY : 1; //!< [5] ECRC Generation Capability
        unsigned ECRC_GENERATION_ENABLE : 1; //!< [6] ECRC Generation Enable
        unsigned ECRC_CHECK_CAPABLE : 1; //!< [7] ECRC Check Capable
        unsigned ECRC_CHECK_ENABLE : 1; //!< [8] ECRC Check Enable
        unsigned RESERVED0 : 23; //!< [31:9] Reserved
    } B;
} hw_pcie_ep_accr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_ACCR register
 */
//@{
#define HW_PCIE_EP_ACCR_ADDR      (REGS_PCIE_EP_BASE + 0x118)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_ACCR           (*(volatile hw_pcie_ep_accr_t *) HW_PCIE_EP_ACCR_ADDR)
#define HW_PCIE_EP_ACCR_RD()      (HW_PCIE_EP_ACCR.U)
#define HW_PCIE_EP_ACCR_WR(v)     (HW_PCIE_EP_ACCR.U = (v))
#define HW_PCIE_EP_ACCR_SET(v)    (HW_PCIE_EP_ACCR_WR(HW_PCIE_EP_ACCR_RD() |  (v)))
#define HW_PCIE_EP_ACCR_CLR(v)    (HW_PCIE_EP_ACCR_WR(HW_PCIE_EP_ACCR_RD() & ~(v)))
#define HW_PCIE_EP_ACCR_TOG(v)    (HW_PCIE_EP_ACCR_WR(HW_PCIE_EP_ACCR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_ACCR bitfields
 */

/*! @name Register PCIE_EP_ACCR, field FIRST_ERROR_POINTER[4:0] (RW)
 *
 * First Error Pointer
 */
//@{
#define BP_PCIE_EP_ACCR_FIRST_ERROR_POINTER      (0)      //!< Bit position for PCIE_EP_ACCR_FIRST_ERROR_POINTER.
#define BM_PCIE_EP_ACCR_FIRST_ERROR_POINTER      (0x0000001f)  //!< Bit mask for PCIE_EP_ACCR_FIRST_ERROR_POINTER.

//! @brief Get value of PCIE_EP_ACCR_FIRST_ERROR_POINTER from a register value.
#define BG_PCIE_EP_ACCR_FIRST_ERROR_POINTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ACCR_FIRST_ERROR_POINTER) >> BP_PCIE_EP_ACCR_FIRST_ERROR_POINTER)

//! @brief Format value for bitfield PCIE_EP_ACCR_FIRST_ERROR_POINTER.
#define BF_PCIE_EP_ACCR_FIRST_ERROR_POINTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ACCR_FIRST_ERROR_POINTER) & BM_PCIE_EP_ACCR_FIRST_ERROR_POINTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FIRST_ERROR_POINTER field to a new value.
#define BW_PCIE_EP_ACCR_FIRST_ERROR_POINTER(v)   (HW_PCIE_EP_ACCR_WR((HW_PCIE_EP_ACCR_RD() & ~BM_PCIE_EP_ACCR_FIRST_ERROR_POINTER) | BF_PCIE_EP_ACCR_FIRST_ERROR_POINTER(v)))
#endif
//@}

/*! @name Register PCIE_EP_ACCR, field ECRC_GENERATION_CAPABILITY[5] (RW)
 *
 * ECRC Generation Capability
 */
//@{
#define BP_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY      (5)      //!< Bit position for PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY.
#define BM_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY      (0x00000020)  //!< Bit mask for PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY.

//! @brief Get value of PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY from a register value.
#define BG_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY) >> BP_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY)

//! @brief Format value for bitfield PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY.
#define BF_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY) & BM_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_GENERATION_CAPABILITY field to a new value.
#define BW_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY(v)   (HW_PCIE_EP_ACCR_WR((HW_PCIE_EP_ACCR_RD() & ~BM_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY) | BF_PCIE_EP_ACCR_ECRC_GENERATION_CAPABILITY(v)))
#endif
//@}

/*! @name Register PCIE_EP_ACCR, field ECRC_GENERATION_ENABLE[6] (RW)
 *
 * ECRC Generation Enable
 */
//@{
#define BP_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE      (6)      //!< Bit position for PCIE_EP_ACCR_ECRC_GENERATION_ENABLE.
#define BM_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE      (0x00000040)  //!< Bit mask for PCIE_EP_ACCR_ECRC_GENERATION_ENABLE.

//! @brief Get value of PCIE_EP_ACCR_ECRC_GENERATION_ENABLE from a register value.
#define BG_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE) >> BP_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE)

//! @brief Format value for bitfield PCIE_EP_ACCR_ECRC_GENERATION_ENABLE.
#define BF_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE) & BM_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_GENERATION_ENABLE field to a new value.
#define BW_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE(v)   (HW_PCIE_EP_ACCR_WR((HW_PCIE_EP_ACCR_RD() & ~BM_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE) | BF_PCIE_EP_ACCR_ECRC_GENERATION_ENABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_ACCR, field ECRC_CHECK_CAPABLE[7] (RW)
 *
 * ECRC Check Capable
 */
//@{
#define BP_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE      (7)      //!< Bit position for PCIE_EP_ACCR_ECRC_CHECK_CAPABLE.
#define BM_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE      (0x00000080)  //!< Bit mask for PCIE_EP_ACCR_ECRC_CHECK_CAPABLE.

//! @brief Get value of PCIE_EP_ACCR_ECRC_CHECK_CAPABLE from a register value.
#define BG_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE) >> BP_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE)

//! @brief Format value for bitfield PCIE_EP_ACCR_ECRC_CHECK_CAPABLE.
#define BF_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE) & BM_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_CHECK_CAPABLE field to a new value.
#define BW_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE(v)   (HW_PCIE_EP_ACCR_WR((HW_PCIE_EP_ACCR_RD() & ~BM_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE) | BF_PCIE_EP_ACCR_ECRC_CHECK_CAPABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_ACCR, field ECRC_CHECK_ENABLE[8] (RW)
 *
 * ECRC Check Enable
 */
//@{
#define BP_PCIE_EP_ACCR_ECRC_CHECK_ENABLE      (8)      //!< Bit position for PCIE_EP_ACCR_ECRC_CHECK_ENABLE.
#define BM_PCIE_EP_ACCR_ECRC_CHECK_ENABLE      (0x00000100)  //!< Bit mask for PCIE_EP_ACCR_ECRC_CHECK_ENABLE.

//! @brief Get value of PCIE_EP_ACCR_ECRC_CHECK_ENABLE from a register value.
#define BG_PCIE_EP_ACCR_ECRC_CHECK_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_ACCR_ECRC_CHECK_ENABLE) >> BP_PCIE_EP_ACCR_ECRC_CHECK_ENABLE)

//! @brief Format value for bitfield PCIE_EP_ACCR_ECRC_CHECK_ENABLE.
#define BF_PCIE_EP_ACCR_ECRC_CHECK_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_ACCR_ECRC_CHECK_ENABLE) & BM_PCIE_EP_ACCR_ECRC_CHECK_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ECRC_CHECK_ENABLE field to a new value.
#define BW_PCIE_EP_ACCR_ECRC_CHECK_ENABLE(v)   (HW_PCIE_EP_ACCR_WR((HW_PCIE_EP_ACCR_RD() & ~BM_PCIE_EP_ACCR_ECRC_CHECK_ENABLE) | BF_PCIE_EP_ACCR_ECRC_CHECK_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_HLR - Header Log Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_HLR - Header Log Register (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x1C The Header Log registers collect the header for the TLP corresponding to a detected
 * error. See the PCI Express 3.0 Specification for details. Each of the Header Log registers is
 * type ROS; the default reset value of each Header Log register is 0x00000000.
 */
typedef union _hw_pcie_ep_hlr
{
    reg32_t U;
    struct _hw_pcie_ep_hlr_bitfields
    {
        unsigned RESERVED0 : 32; //!< [31:0] Header Log Register (nth DWORD)
    } B;
} hw_pcie_ep_hlr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_HLR register
 */
//@{
#define HW_PCIE_EP_HLR_ADDR      (REGS_PCIE_EP_BASE + 0x11c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_HLR           (*(volatile hw_pcie_ep_hlr_t *) HW_PCIE_EP_HLR_ADDR)
#define HW_PCIE_EP_HLR_RD()      (HW_PCIE_EP_HLR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_HLR bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_VCECHR - VC Extended Capability Header
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_VCECHR - VC Extended Capability Header (RO)
 *
 * Reset value: 0x00000012
 *
 * Offset: 0x140
 */
typedef union _hw_pcie_ep_vcechr
{
    reg32_t U;
    struct _hw_pcie_ep_vcechr_bitfields
    {
        unsigned EXTENDED_CAPABILITY : 16; //!< [15:0] PCI Express Extended Capability
        unsigned CAPABILITY_VERSION : 4; //!< [19:16] Capability Version
        unsigned NEXT_CAPABILITY_OFFSET : 12; //!< [31:20] Next Capability Offset
    } B;
} hw_pcie_ep_vcechr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_VCECHR register
 */
//@{
#define HW_PCIE_EP_VCECHR_ADDR      (REGS_PCIE_EP_BASE + 0x140)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_VCECHR           (*(volatile hw_pcie_ep_vcechr_t *) HW_PCIE_EP_VCECHR_ADDR)
#define HW_PCIE_EP_VCECHR_RD()      (HW_PCIE_EP_VCECHR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_VCECHR bitfields
 */

/*! @name Register PCIE_EP_VCECHR, field EXTENDED_CAPABILITY[15:0] (RO)
 *
 * PCI Express Extended Capability The default value is 0x2 for VC Capability.
 */
//@{
#define BP_PCIE_EP_VCECHR_EXTENDED_CAPABILITY      (0)      //!< Bit position for PCIE_EP_VCECHR_EXTENDED_CAPABILITY.
#define BM_PCIE_EP_VCECHR_EXTENDED_CAPABILITY      (0x0000ffff)  //!< Bit mask for PCIE_EP_VCECHR_EXTENDED_CAPABILITY.

//! @brief Get value of PCIE_EP_VCECHR_EXTENDED_CAPABILITY from a register value.
#define BG_PCIE_EP_VCECHR_EXTENDED_CAPABILITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCECHR_EXTENDED_CAPABILITY) >> BP_PCIE_EP_VCECHR_EXTENDED_CAPABILITY)
//@}

/*! @name Register PCIE_EP_VCECHR, field CAPABILITY_VERSION[19:16] (RO)
 *
 * Capability Version
 */
//@{
#define BP_PCIE_EP_VCECHR_CAPABILITY_VERSION      (16)      //!< Bit position for PCIE_EP_VCECHR_CAPABILITY_VERSION.
#define BM_PCIE_EP_VCECHR_CAPABILITY_VERSION      (0x000f0000)  //!< Bit mask for PCIE_EP_VCECHR_CAPABILITY_VERSION.

//! @brief Get value of PCIE_EP_VCECHR_CAPABILITY_VERSION from a register value.
#define BG_PCIE_EP_VCECHR_CAPABILITY_VERSION(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCECHR_CAPABILITY_VERSION) >> BP_PCIE_EP_VCECHR_CAPABILITY_VERSION)
//@}

/*! @name Register PCIE_EP_VCECHR, field NEXT_CAPABILITY_OFFSET[31:20] (RO)
 *
 * Next Capability Offset
 */
//@{
#define BP_PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET      (20)      //!< Bit position for PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET.
#define BM_PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET      (0xfff00000)  //!< Bit mask for PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET.

//! @brief Get value of PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET from a register value.
#define BG_PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET) >> BP_PCIE_EP_VCECHR_NEXT_CAPABILITY_OFFSET)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_PVCCR1 - Port VC Capability Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_PVCCR1 - Port VC Capability Register 1 (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0x4
 */
typedef union _hw_pcie_ep_pvccr1
{
    reg32_t U;
    struct _hw_pcie_ep_pvccr1_bitfields
    {
        unsigned EXTENDED_VC_COUNT : 3; //!< [2:0] Extended VC Count
        unsigned RESERVED0 : 1; //!< [3] Reserved
        unsigned LOW_PRIORITY_EXTENDED_VC_COUNT : 3; //!< [6:4] Low Priority Extended VC Count, writable through the DBI
        unsigned RESERVED1 : 1; //!< [7] Reserved
        unsigned REFERENCE_CLOCK : 2; //!< [9:8] Reference Clock
        unsigned PORT_ARBITRATION_TABLE_ENTRY_SIZE : 2; //!< [11:10] Port Arbitration Table Entry Size
        unsigned RESERVED2 : 20; //!< [31:12] Reserved
    } B;
} hw_pcie_ep_pvccr1_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_PVCCR1 register
 */
//@{
#define HW_PCIE_EP_PVCCR1_ADDR      (REGS_PCIE_EP_BASE + 0x144)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_PVCCR1           (*(volatile hw_pcie_ep_pvccr1_t *) HW_PCIE_EP_PVCCR1_ADDR)
#define HW_PCIE_EP_PVCCR1_RD()      (HW_PCIE_EP_PVCCR1.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_PVCCR1 bitfields
 */

/*! @name Register PCIE_EP_PVCCR1, field EXTENDED_VC_COUNT[2:0] (RO)
 *
 * Extended VC Count The default value is the one less than the number of VCs that
 */
//@{
#define BP_PCIE_EP_PVCCR1_EXTENDED_VC_COUNT      (0)      //!< Bit position for PCIE_EP_PVCCR1_EXTENDED_VC_COUNT.
#define BM_PCIE_EP_PVCCR1_EXTENDED_VC_COUNT      (0x00000007)  //!< Bit mask for PCIE_EP_PVCCR1_EXTENDED_VC_COUNT.

//! @brief Get value of PCIE_EP_PVCCR1_EXTENDED_VC_COUNT from a register value.
#define BG_PCIE_EP_PVCCR1_EXTENDED_VC_COUNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR1_EXTENDED_VC_COUNT) >> BP_PCIE_EP_PVCCR1_EXTENDED_VC_COUNT)
//@}

/*! @name Register PCIE_EP_PVCCR1, field LOW_PRIORITY_EXTENDED_VC_COUNT[6:4] (RO)
 *
 * Low Priority Extended VC Count, writable through the DBI
 */
//@{
#define BP_PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT      (4)      //!< Bit position for PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT.
#define BM_PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT      (0x00000070)  //!< Bit mask for PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT.

//! @brief Get value of PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT from a register value.
#define BG_PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT) >> BP_PCIE_EP_PVCCR1_LOW_PRIORITY_EXTENDED_VC_COUNT)
//@}

/*! @name Register PCIE_EP_PVCCR1, field REFERENCE_CLOCK[9:8] (RO)
 *
 * Reference Clock
 */
//@{
#define BP_PCIE_EP_PVCCR1_REFERENCE_CLOCK      (8)      //!< Bit position for PCIE_EP_PVCCR1_REFERENCE_CLOCK.
#define BM_PCIE_EP_PVCCR1_REFERENCE_CLOCK      (0x00000300)  //!< Bit mask for PCIE_EP_PVCCR1_REFERENCE_CLOCK.

//! @brief Get value of PCIE_EP_PVCCR1_REFERENCE_CLOCK from a register value.
#define BG_PCIE_EP_PVCCR1_REFERENCE_CLOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR1_REFERENCE_CLOCK) >> BP_PCIE_EP_PVCCR1_REFERENCE_CLOCK)
//@}

/*! @name Register PCIE_EP_PVCCR1, field PORT_ARBITRATION_TABLE_ENTRY_SIZE[11:10] (RO)
 *
 * Port Arbitration Table Entry Size
 */
//@{
#define BP_PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE      (10)      //!< Bit position for PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE.
#define BM_PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE      (0x00000c00)  //!< Bit mask for PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE.

//! @brief Get value of PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE from a register value.
#define BG_PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE) >> BP_PCIE_EP_PVCCR1_PORT_ARBITRATION_TABLE_ENTRY_SIZE)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_PVCCR2 - Port VC Capability Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_PVCCR2 - Port VC Capability Register 2 (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0x8
 */
typedef union _hw_pcie_ep_pvccr2
{
    reg32_t U;
    struct _hw_pcie_ep_pvccr2_bitfields
    {
        unsigned VC_ARBITRATION_CAPABILITY : 8; //!< [7:0] VC Arbitration Capability
        unsigned RESERVED0 : 16; //!< [23:8] Reserved
        unsigned VC_ARBITRATION_TABLE_OFFSET : 8; //!< [31:24] VC Arbitration Table Offset (not supported) The default value is 0x00 (no arbitration table present).
    } B;
} hw_pcie_ep_pvccr2_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_PVCCR2 register
 */
//@{
#define HW_PCIE_EP_PVCCR2_ADDR      (REGS_PCIE_EP_BASE + 0x148)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_PVCCR2           (*(volatile hw_pcie_ep_pvccr2_t *) HW_PCIE_EP_PVCCR2_ADDR)
#define HW_PCIE_EP_PVCCR2_RD()      (HW_PCIE_EP_PVCCR2.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_PVCCR2 bitfields
 */

/*! @name Register PCIE_EP_PVCCR2, field VC_ARBITRATION_CAPABILITY[7:0] (RO)
 *
 * VC Arbitration Capability Indicates which VC arbitration mode(s) the device supports, writable
 * through the DBI: •Bit 0: Device supports hardware fixed arbitration scheme. For the core, the
 * scheme is 16-phase weighted round robin (WRR). •Bit 1: Device supports 32-phase WRR •Bit 2:
 * Device supports 64-phase WRR •Bit 3: Device supports 128-phase WRR •Bits 4-7: Reserved
 */
//@{
#define BP_PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY      (0)      //!< Bit position for PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY.
#define BM_PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY      (0x000000ff)  //!< Bit mask for PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY.

//! @brief Get value of PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY from a register value.
#define BG_PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY) >> BP_PCIE_EP_PVCCR2_VC_ARBITRATION_CAPABILITY)
//@}

/*! @name Register PCIE_EP_PVCCR2, field VC_ARBITRATION_TABLE_OFFSET[31:24] (RO)
 *
 * VC Arbitration Table Offset (not supported) The default value is 0x00 (no arbitration table
 * present).
 */
//@{
#define BP_PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET      (24)      //!< Bit position for PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET.
#define BM_PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET      (0xff000000)  //!< Bit mask for PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET.

//! @brief Get value of PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET from a register value.
#define BG_PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET) >> BP_PCIE_EP_PVCCR2_VC_ARBITRATION_TABLE_OFFSET)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_PVCCSR - Port VC Control and Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_PVCCSR - Port VC Control and Status Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0xC Bytes: 0-1
 */
typedef union _hw_pcie_ep_pvccsr
{
    reg32_t U;
    struct _hw_pcie_ep_pvccsr_bitfields
    {
        unsigned LOAD_VC_ARBITRATION_TABLE : 1; //!< [0] Load VC Arbitration Table
        unsigned VC_ARBITRATION_SELECT : 3; //!< [3:1] VC Arbitration Select
        unsigned RESERVED0 : 12; //!< [15:4] Reserved
        unsigned ARBITRATION_TABLE_STATUS : 1; //!< [16] Arbitration Table Status
        unsigned RESERVED1 : 15; //!< [31:17] Reserved
    } B;
} hw_pcie_ep_pvccsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_PVCCSR register
 */
//@{
#define HW_PCIE_EP_PVCCSR_ADDR      (REGS_PCIE_EP_BASE + 0x14c)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_PVCCSR           (*(volatile hw_pcie_ep_pvccsr_t *) HW_PCIE_EP_PVCCSR_ADDR)
#define HW_PCIE_EP_PVCCSR_RD()      (HW_PCIE_EP_PVCCSR.U)
#define HW_PCIE_EP_PVCCSR_WR(v)     (HW_PCIE_EP_PVCCSR.U = (v))
#define HW_PCIE_EP_PVCCSR_SET(v)    (HW_PCIE_EP_PVCCSR_WR(HW_PCIE_EP_PVCCSR_RD() |  (v)))
#define HW_PCIE_EP_PVCCSR_CLR(v)    (HW_PCIE_EP_PVCCSR_WR(HW_PCIE_EP_PVCCSR_RD() & ~(v)))
#define HW_PCIE_EP_PVCCSR_TOG(v)    (HW_PCIE_EP_PVCCSR_WR(HW_PCIE_EP_PVCCSR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_PVCCSR bitfields
 */

/*! @name Register PCIE_EP_PVCCSR, field LOAD_VC_ARBITRATION_TABLE[0] (RW)
 *
 * Load VC Arbitration Table
 */
//@{
#define BP_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE      (0)      //!< Bit position for PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE.
#define BM_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE      (0x00000001)  //!< Bit mask for PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE.

//! @brief Get value of PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE from a register value.
#define BG_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE) >> BP_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE)

//! @brief Format value for bitfield PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE.
#define BF_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE) & BM_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOAD_VC_ARBITRATION_TABLE field to a new value.
#define BW_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE(v)   (HW_PCIE_EP_PVCCSR_WR((HW_PCIE_EP_PVCCSR_RD() & ~BM_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE) | BF_PCIE_EP_PVCCSR_LOAD_VC_ARBITRATION_TABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_PVCCSR, field VC_ARBITRATION_SELECT[3:1] (RW)
 *
 * VC Arbitration Select
 */
//@{
#define BP_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT      (1)      //!< Bit position for PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT.
#define BM_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT      (0x0000000e)  //!< Bit mask for PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT.

//! @brief Get value of PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT from a register value.
#define BG_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT) >> BP_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT)

//! @brief Format value for bitfield PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT.
#define BF_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT) & BM_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC_ARBITRATION_SELECT field to a new value.
#define BW_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT(v)   (HW_PCIE_EP_PVCCSR_WR((HW_PCIE_EP_PVCCSR_RD() & ~BM_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT) | BF_PCIE_EP_PVCCSR_VC_ARBITRATION_SELECT(v)))
#endif
//@}

/*! @name Register PCIE_EP_PVCCSR, field ARBITRATION_TABLE_STATUS[16] (RW)
 *
 * Arbitration Table Status
 */
//@{
#define BP_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS      (16)      //!< Bit position for PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS.
#define BM_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS      (0x00010000)  //!< Bit mask for PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS.

//! @brief Get value of PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS from a register value.
#define BG_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS) >> BP_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS)

//! @brief Format value for bitfield PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS.
#define BF_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS) & BM_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBITRATION_TABLE_STATUS field to a new value.
#define BW_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS(v)   (HW_PCIE_EP_PVCCSR_WR((HW_PCIE_EP_PVCCSR_RD() & ~BM_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS) | BF_PCIE_EP_PVCCSR_ARBITRATION_TABLE_STATUS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_VCRCR - VC Resource Capability Register n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_VCRCR - VC Resource Capability Register n (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0x10
 */
typedef union _hw_pcie_ep_vcrcr
{
    reg32_t U;
    struct _hw_pcie_ep_vcrcr_bitfields
    {
        unsigned PORT_ARBITRATION_CAPABILITY : 8; //!< [7:0] Port Arbitration Capability
        unsigned RESERVED0 : 7; //!< [14:8] Reserved.
        unsigned REJECT_SNOOP_TRANSACTIONS : 1; //!< [15] Reject Snoop Transactions
        unsigned MAXIMUM_TIME_SLOTS : 7; //!< [22:16] Maximum Time Slots
        unsigned RESERVED1 : 1; //!< [23] Reserved
        unsigned PORT_ARBITRATION_TABLE_OFFSET : 8; //!< [31:24] Port Arbitration Table Offset
    } B;
} hw_pcie_ep_vcrcr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_VCRCR register
 */
//@{
#define HW_PCIE_EP_VCRCR_ADDR      (REGS_PCIE_EP_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_VCRCR           (*(volatile hw_pcie_ep_vcrcr_t *) HW_PCIE_EP_VCRCR_ADDR)
#define HW_PCIE_EP_VCRCR_RD()      (HW_PCIE_EP_VCRCR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_VCRCR bitfields
 */

/*! @name Register PCIE_EP_VCRCR, field PORT_ARBITRATION_CAPABILITY[7:0] (RO)
 *
 * Port Arbitration Capability
 */
//@{
#define BP_PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY      (0)      //!< Bit position for PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY.
#define BM_PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY      (0x000000ff)  //!< Bit mask for PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY.

//! @brief Get value of PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY from a register value.
#define BG_PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY) >> BP_PCIE_EP_VCRCR_PORT_ARBITRATION_CAPABILITY)
//@}

/*! @name Register PCIE_EP_VCRCR, field REJECT_SNOOP_TRANSACTIONS[15] (RO)
 *
 * Reject Snoop Transactions
 */
//@{
#define BP_PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS      (15)      //!< Bit position for PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS.
#define BM_PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS      (0x00008000)  //!< Bit mask for PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS.

//! @brief Get value of PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS from a register value.
#define BG_PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS) >> BP_PCIE_EP_VCRCR_REJECT_SNOOP_TRANSACTIONS)
//@}

/*! @name Register PCIE_EP_VCRCR, field MAXIMUM_TIME_SLOTS[22:16] (RO)
 *
 * Maximum Time Slots
 */
//@{
#define BP_PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS      (16)      //!< Bit position for PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS.
#define BM_PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS      (0x007f0000)  //!< Bit mask for PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS.

//! @brief Get value of PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS from a register value.
#define BG_PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS) >> BP_PCIE_EP_VCRCR_MAXIMUM_TIME_SLOTS)
//@}

/*! @name Register PCIE_EP_VCRCR, field PORT_ARBITRATION_TABLE_OFFSET[31:24] (RO)
 *
 * Port Arbitration Table Offset
 */
//@{
#define BP_PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET      (24)      //!< Bit position for PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET.
#define BM_PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET      (0xff000000)  //!< Bit mask for PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET.

//! @brief Get value of PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET from a register value.
#define BG_PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET) >> BP_PCIE_EP_VCRCR_PORT_ARBITRATION_TABLE_OFFSET)
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_VCRCONR - VC Resource Control Register n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_VCRCONR - VC Resource Control Register n (RW)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0x14
 */
typedef union _hw_pcie_ep_vcrconr
{
    reg32_t U;
    struct _hw_pcie_ep_vcrconr_bitfields
    {
        unsigned TC_VC_MAP : 8; //!< [7:0] TC/VC Map
        unsigned RESERVED0 : 8; //!< [15:8] Reserved
        unsigned LOAD_PORT_ARBITRATION_TABLE : 1; //!< [16] Load Port Arbitration Table
        unsigned PORT_ARBITRATION_SELECT : 3; //!< [19:17] Port Arbitration Select
        unsigned RESERVED1 : 4; //!< [23:20] Reserved
        unsigned VC_ID : 3; //!< [26:24] VC ID
        unsigned RESERVED2 : 4; //!< [30:27] Reserved
        unsigned VC_ENABLE : 1; //!< [31] VC Enable
    } B;
} hw_pcie_ep_vcrconr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_VCRCONR register
 */
//@{
#define HW_PCIE_EP_VCRCONR_ADDR      (REGS_PCIE_EP_BASE + 0x154)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_VCRCONR           (*(volatile hw_pcie_ep_vcrconr_t *) HW_PCIE_EP_VCRCONR_ADDR)
#define HW_PCIE_EP_VCRCONR_RD()      (HW_PCIE_EP_VCRCONR.U)
#define HW_PCIE_EP_VCRCONR_WR(v)     (HW_PCIE_EP_VCRCONR.U = (v))
#define HW_PCIE_EP_VCRCONR_SET(v)    (HW_PCIE_EP_VCRCONR_WR(HW_PCIE_EP_VCRCONR_RD() |  (v)))
#define HW_PCIE_EP_VCRCONR_CLR(v)    (HW_PCIE_EP_VCRCONR_WR(HW_PCIE_EP_VCRCONR_RD() & ~(v)))
#define HW_PCIE_EP_VCRCONR_TOG(v)    (HW_PCIE_EP_VCRCONR_WR(HW_PCIE_EP_VCRCONR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_VCRCONR bitfields
 */

/*! @name Register PCIE_EP_VCRCONR, field TC_VC_MAP[7:0] (RW)
 *
 * TC/VC Map Bit 0 is hardwired to 1; bits 7:1 are RW.
 */
//@{
#define BP_PCIE_EP_VCRCONR_TC_VC_MAP      (0)      //!< Bit position for PCIE_EP_VCRCONR_TC_VC_MAP.
#define BM_PCIE_EP_VCRCONR_TC_VC_MAP      (0x000000ff)  //!< Bit mask for PCIE_EP_VCRCONR_TC_VC_MAP.

//! @brief Get value of PCIE_EP_VCRCONR_TC_VC_MAP from a register value.
#define BG_PCIE_EP_VCRCONR_TC_VC_MAP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCONR_TC_VC_MAP) >> BP_PCIE_EP_VCRCONR_TC_VC_MAP)

//! @brief Format value for bitfield PCIE_EP_VCRCONR_TC_VC_MAP.
#define BF_PCIE_EP_VCRCONR_TC_VC_MAP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_VCRCONR_TC_VC_MAP) & BM_PCIE_EP_VCRCONR_TC_VC_MAP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TC_VC_MAP field to a new value.
#define BW_PCIE_EP_VCRCONR_TC_VC_MAP(v)   (HW_PCIE_EP_VCRCONR_WR((HW_PCIE_EP_VCRCONR_RD() & ~BM_PCIE_EP_VCRCONR_TC_VC_MAP) | BF_PCIE_EP_VCRCONR_TC_VC_MAP(v)))
#endif
//@}

/*! @name Register PCIE_EP_VCRCONR, field LOAD_PORT_ARBITRATION_TABLE[16] (RW)
 *
 * Load Port Arbitration Table
 */
//@{
#define BP_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE      (16)      //!< Bit position for PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE.
#define BM_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE      (0x00010000)  //!< Bit mask for PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE.

//! @brief Get value of PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE from a register value.
#define BG_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE) >> BP_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE)

//! @brief Format value for bitfield PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE.
#define BF_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE) & BM_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOAD_PORT_ARBITRATION_TABLE field to a new value.
#define BW_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE(v)   (HW_PCIE_EP_VCRCONR_WR((HW_PCIE_EP_VCRCONR_RD() & ~BM_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE) | BF_PCIE_EP_VCRCONR_LOAD_PORT_ARBITRATION_TABLE(v)))
#endif
//@}

/*! @name Register PCIE_EP_VCRCONR, field PORT_ARBITRATION_SELECT[19:17] (RW)
 *
 * Port Arbitration Select
 */
//@{
#define BP_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT      (17)      //!< Bit position for PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT.
#define BM_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT      (0x000e0000)  //!< Bit mask for PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT.

//! @brief Get value of PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT from a register value.
#define BG_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT) >> BP_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT)

//! @brief Format value for bitfield PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT.
#define BF_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT) & BM_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORT_ARBITRATION_SELECT field to a new value.
#define BW_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT(v)   (HW_PCIE_EP_VCRCONR_WR((HW_PCIE_EP_VCRCONR_RD() & ~BM_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT) | BF_PCIE_EP_VCRCONR_PORT_ARBITRATION_SELECT(v)))
#endif
//@}

/*! @name Register PCIE_EP_VCRCONR, field VC_ID[26:24] (RW)
 *
 * VC ID Hardwired to 0 for VC0.
 */
//@{
#define BP_PCIE_EP_VCRCONR_VC_ID      (24)      //!< Bit position for PCIE_EP_VCRCONR_VC_ID.
#define BM_PCIE_EP_VCRCONR_VC_ID      (0x07000000)  //!< Bit mask for PCIE_EP_VCRCONR_VC_ID.

//! @brief Get value of PCIE_EP_VCRCONR_VC_ID from a register value.
#define BG_PCIE_EP_VCRCONR_VC_ID(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCONR_VC_ID) >> BP_PCIE_EP_VCRCONR_VC_ID)

//! @brief Format value for bitfield PCIE_EP_VCRCONR_VC_ID.
#define BF_PCIE_EP_VCRCONR_VC_ID(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_VCRCONR_VC_ID) & BM_PCIE_EP_VCRCONR_VC_ID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC_ID field to a new value.
#define BW_PCIE_EP_VCRCONR_VC_ID(v)   (HW_PCIE_EP_VCRCONR_WR((HW_PCIE_EP_VCRCONR_RD() & ~BM_PCIE_EP_VCRCONR_VC_ID) | BF_PCIE_EP_VCRCONR_VC_ID(v)))
#endif
//@}

/*! @name Register PCIE_EP_VCRCONR, field VC_ENABLE[31] (RW)
 *
 * VC Enable Hardwired to 1 for the first VC.
 */
//@{
#define BP_PCIE_EP_VCRCONR_VC_ENABLE      (31)      //!< Bit position for PCIE_EP_VCRCONR_VC_ENABLE.
#define BM_PCIE_EP_VCRCONR_VC_ENABLE      (0x80000000)  //!< Bit mask for PCIE_EP_VCRCONR_VC_ENABLE.

//! @brief Get value of PCIE_EP_VCRCONR_VC_ENABLE from a register value.
#define BG_PCIE_EP_VCRCONR_VC_ENABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRCONR_VC_ENABLE) >> BP_PCIE_EP_VCRCONR_VC_ENABLE)

//! @brief Format value for bitfield PCIE_EP_VCRCONR_VC_ENABLE.
#define BF_PCIE_EP_VCRCONR_VC_ENABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_PCIE_EP_VCRCONR_VC_ENABLE) & BM_PCIE_EP_VCRCONR_VC_ENABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VC_ENABLE field to a new value.
#define BW_PCIE_EP_VCRCONR_VC_ENABLE(v)   (HW_PCIE_EP_VCRCONR_WR((HW_PCIE_EP_VCRCONR_RD() & ~BM_PCIE_EP_VCRCONR_VC_ENABLE) | BF_PCIE_EP_VCRCONR_VC_ENABLE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PCIE_EP_VCRSR - VC Resource Status Register n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PCIE_EP_VCRSR - VC Resource Status Register n (RO)
 *
 * Reset value: 0x00000000
 *
 * Offset: 0x140 + 0x18
 */
typedef union _hw_pcie_ep_vcrsr
{
    reg32_t U;
    struct _hw_pcie_ep_vcrsr_bitfields
    {
        unsigned RESERVED0 : 16; //!< [15:0] Reserved
        unsigned PORT_ARBITRATION_TABLE_STATUS : 1; //!< [16] Port Arbitration Table Status
        unsigned VC_NEGOTIATION_PENDING : 1; //!< [17] VC Negotiation Pending
        unsigned RESERVED1 : 14; //!< [31:18] Reserved
    } B;
} hw_pcie_ep_vcrsr_t;
#endif

/*!
 * @name Constants and macros for entire PCIE_EP_VCRSR register
 */
//@{
#define HW_PCIE_EP_VCRSR_ADDR      (REGS_PCIE_EP_BASE + 0x158)

#ifndef __LANGUAGE_ASM__
#define HW_PCIE_EP_VCRSR           (*(volatile hw_pcie_ep_vcrsr_t *) HW_PCIE_EP_VCRSR_ADDR)
#define HW_PCIE_EP_VCRSR_RD()      (HW_PCIE_EP_VCRSR.U)
#endif
//@}

/*
 * constants & macros for individual PCIE_EP_VCRSR bitfields
 */

/*! @name Register PCIE_EP_VCRSR, field PORT_ARBITRATION_TABLE_STATUS[16] (RO)
 *
 * Port Arbitration Table Status
 */
//@{
#define BP_PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS      (16)      //!< Bit position for PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS.
#define BM_PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS      (0x00010000)  //!< Bit mask for PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS.

//! @brief Get value of PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS from a register value.
#define BG_PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS) >> BP_PCIE_EP_VCRSR_PORT_ARBITRATION_TABLE_STATUS)
//@}

/*! @name Register PCIE_EP_VCRSR, field VC_NEGOTIATION_PENDING[17] (RO)
 *
 * VC Negotiation Pending
 */
//@{
#define BP_PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING      (17)      //!< Bit position for PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING.
#define BM_PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING      (0x00020000)  //!< Bit mask for PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING.

//! @brief Get value of PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING from a register value.
#define BG_PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING) >> BP_PCIE_EP_VCRSR_VC_NEGOTIATION_PENDING)
//@}

//-------------------------------------------------------------------------------------------
// hw_pcie_ep_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All PCIE_EP module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_pcie_ep
{
    volatile hw_pcie_ep_deviceid_t DEVICEID; //!< Device ID and Vendor ID Register
    volatile hw_pcie_ep_command_t COMMAND; //!< Command and Status Register
    reg32_t _reserved0;
    volatile hw_pcie_ep_bist_t BIST; //!< BIST Register
    volatile hw_pcie_ep_bar0_t BAR0; //!< Base Address 0
    volatile hw_pcie_ep_mask0_t MASK0; //!< BAR 0 Mask Register
    volatile hw_pcie_ep_mask1_t MASK1; //!< BAR 1 Mask Register
    volatile hw_pcie_ep_mask2_t MASK2; //!< BAR 2 Mask Register
    volatile hw_pcie_ep_mask3_t MASK3; //!< BAR 3 Mask Register
    reg32_t _reserved1;
    volatile hw_pcie_ep_cisp_t CISP; //!< CardBus CIS Pointer Register
    volatile hw_pcie_ep_ssid_t SSID; //!< Subsystem ID and Subsystem Vendor ID Register
    volatile hw_pcie_ep_erombar_t EROMBAR; //!< Expansion ROM Base Address Register
    volatile hw_pcie_ep_erommask_t EROMMASK; //!< Expansion ROM BAR Mask Register
    volatile hw_pcie_ep_cappr_t CAPPR; //!< Capability Pointer Register
    volatile hw_pcie_ep_ilr_t ILR; //!< Interrupt Line and Pin Register
    reg32_t _reserved2[48];
    volatile hw_pcie_ep_aer_t AER; //!< AER Capability Header
    volatile hw_pcie_ep_uesr_t UESR; //!< Uncorrectable Error Status Register
    volatile hw_pcie_ep_uemr_t UEMR; //!< Uncorrectable Error Mask Register
    volatile hw_pcie_ep_uesevr_t UESEVR; //!< Uncorrectable Error Severity Register
    volatile hw_pcie_ep_cesr_t CESR; //!< Correctable Error Status Register
    volatile hw_pcie_ep_cemr_t CEMR; //!< Correctable Error Mask Register
    volatile hw_pcie_ep_accr_t ACCR; //!< Advanced Capabilities and Control Register
    volatile hw_pcie_ep_hlr_t HLR; //!< Header Log Register
    reg32_t _reserved3[8];
    volatile hw_pcie_ep_vcechr_t VCECHR; //!< VC Extended Capability Header
    volatile hw_pcie_ep_pvccr1_t PVCCR1; //!< Port VC Capability Register 1
    volatile hw_pcie_ep_pvccr2_t PVCCR2; //!< Port VC Capability Register 2
    volatile hw_pcie_ep_pvccsr_t PVCCSR; //!< Port VC Control and Status Register
    volatile hw_pcie_ep_vcrcr_t VCRCR; //!< VC Resource Capability Register n
    volatile hw_pcie_ep_vcrconr_t VCRCONR; //!< VC Resource Control Register n
    volatile hw_pcie_ep_vcrsr_t VCRSR; //!< VC Resource Status Register n
} hw_pcie_ep_t;
#pragma pack()

//! @brief Macro to access all PCIE_EP registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_PCIE_EP</code>.
#define HW_PCIE_EP     (*(hw_pcie_ep_t *) REGS_PCIE_EP_BASE)
#endif

#endif // __HW_PCIE_EP_REGISTERS_H__
// v18/121106/1.2.2
// EOF
