/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MLB150_REGISTERS_H__
#define __HW_MLB150_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6DQ MLB150
 *
 * MLB150
 *
 * Registers defined in this header file:
 * - HW_MLB150_MLBC0 - MediaLB Control 0 Register
 * - HW_MLB150_MLBPC0 - MediaLB 6-pin Control 0 Register
 * - HW_MLB150_MS0 - MediaLB Channel Status 0 Register
 * - HW_MLB150_MLBPC2 - MediaLB 6-pin Control 2 Register
 * - HW_MLB150_MS1 - MediaLB Channel Status1 Register
 * - HW_MLB150_MSS - MediaLB System Status Register
 * - HW_MLB150_MSD - MediaLB System Data Register
 * - HW_MLB150_MIEN - MediaLB Interrupt Enable Register
 * - HW_MLB150_MLBPC1 - MediaLB 6-pin Control 1 Register
 * - HW_MLB150_MLBC1 - MediaLB Control 1 Register
 * - HW_MLB150_HCTL - HBI Control Register
 * - HW_MLB150_HCMR0 - HBI Channel Mask 0 Register
 * - HW_MLB150_HCMR1 - HBI Channel Mask 1 Register
 * - HW_MLB150_HCER0 - HBI Channel Error 0 Register
 * - HW_MLB150_HCER1 - HBI Channel Error 1 Register
 * - HW_MLB150_HCBR0 - HBI Channel Busy 0 Register
 * - HW_MLB150_HCBR1 - HBI Channel Busy 1 Register
 * - HW_MLB150_MDAT0 - MIF Data 0 Register
 * - HW_MLB150_MDAT1 - MIF Data 1 Register
 * - HW_MLB150_MDAT2 - MIF Data 2 Register
 * - HW_MLB150_MDAT3 - MIF Data 3 Register
 * - HW_MLB150_MDWE0 - MIF Data Write Enable 0 Register
 * - HW_MLB150_MDWE1 - MIF Data Write Enable 1 Register
 * - HW_MLB150_MDWE2 - MIF Data Write Enable 2 Register
 * - HW_MLB150_MDWE3 - MIF Data Write Enable 3 Register
 * - HW_MLB150_MCTL - MIF Control Register
 * - HW_MLB150_MADR - MIF Address Register
 * - HW_MLB150_ACTL - AHB Control Register
 * - HW_MLB150_ACSR0 - AHB Channel Status 0 Register
 * - HW_MLB150_ACSR1 - AHB Channel Status 1 Register
 * - HW_MLB150_ACMR0 - AHB Channel Mask 0 Register
 * - HW_MLB150_ACMR1 - AHB Channel Mask 1 Register
 *
 * - hw_mlb150_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_MLB150_BASE
#define HW_MLB150_INSTANCE_COUNT (1) //!< Number of instances of the MLB150 module.
#define REGS_MLB150_BASE (0x0218c000) //!< Base address for MLB150.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MLBC0 - MediaLB Control 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MLBC0 - MediaLB Control 0 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mlbc0
{
    reg32_t U;
    struct _hw_mlb150_mlbc0_bitfields
    {
        unsigned MLBEN : 1; //!< [0] MediaLB enable.
        unsigned RESERVED0 : 1; //!< [1] Reserved
        unsigned MLBCLK_2_0 : 3; //!< [4:2] MLB_CLK (MediaLB clock) speed select.
        unsigned MLBPEN : 1; //!< [5] MediaLB 6-pin enable.
        unsigned RESERVED1 : 1; //!< [6] Reserved
        unsigned MLBLK : 1; //!< [7] MediaLB lock status.
        unsigned RESERVED2 : 4; //!< [11:8] Reserved
        unsigned ASYRETRY : 1; //!< [12] Asynchronous Tx packet retry.
        unsigned RESERVED3 : 1; //!< [13] Reserved
        unsigned CTLRETRY : 1; //!< [14] Control Tx packet retry.
        unsigned FCNT : 3; //!< [17:15] The number of frames per sub-buffer for synchronous channels.
        unsigned RESERVED4 : 14; //!< [31:18] Reserved
    } B;
} hw_mlb150_mlbc0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MLBC0 register
 */
//@{
#define HW_MLB150_MLBC0_ADDR      (REGS_MLB150_BASE + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MLBC0           (*(volatile hw_mlb150_mlbc0_t *) HW_MLB150_MLBC0_ADDR)
#define HW_MLB150_MLBC0_RD()      (HW_MLB150_MLBC0.U)
#define HW_MLB150_MLBC0_WR(v)     (HW_MLB150_MLBC0.U = (v))
#define HW_MLB150_MLBC0_SET(v)    (HW_MLB150_MLBC0_WR(HW_MLB150_MLBC0_RD() |  (v)))
#define HW_MLB150_MLBC0_CLR(v)    (HW_MLB150_MLBC0_WR(HW_MLB150_MLBC0_RD() & ~(v)))
#define HW_MLB150_MLBC0_TOG(v)    (HW_MLB150_MLBC0_WR(HW_MLB150_MLBC0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MLBC0 bitfields
 */

/*! @name Register MLB150_MLBC0, field MLBEN[0] (RW)
 *
 * MediaLB enable. When set, MLB_CLK (MediaLB clock), MLB_SIG (signal), and MLB_DATA (data) are
 * received and transmitted on the appropriate MediaLB pins.
 */
//@{
#define BP_MLB150_MLBC0_MLBEN      (0)      //!< Bit position for MLB150_MLBC0_MLBEN.
#define BM_MLB150_MLBC0_MLBEN      (0x00000001)  //!< Bit mask for MLB150_MLBC0_MLBEN.

//! @brief Get value of MLB150_MLBC0_MLBEN from a register value.
#define BG_MLB150_MLBC0_MLBEN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_MLBEN) >> BP_MLB150_MLBC0_MLBEN)

//! @brief Format value for bitfield MLB150_MLBC0_MLBEN.
#define BF_MLB150_MLBC0_MLBEN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_MLBEN) & BM_MLB150_MLBC0_MLBEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MLBEN field to a new value.
#define BW_MLB150_MLBC0_MLBEN(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_MLBEN) | BF_MLB150_MLBC0_MLBEN(v)))
#endif
//@}

/*! @name Register MLB150_MLBC0, field MLBCLK_2_0[4:2] (RW)
 *
 * MLB_CLK (MediaLB clock) speed select.
 *
 * Values:
 * - 000 - 256xFs (for MLBPEN = 0)
 * - 001 - 512xFs (for MLBPEN = 0)
 * - 010 - 1024xFs (for MLBPEN = 0)
 * - 011 - 2048xFs (for MLBPEN = 1)
 * - 100 - 3072xFs (for MLBPEN = 1)
 * - 101 - 4096xFs (for MLBPEN = 1)
 * - 110 - 6144xFs (for MLBPEN = 1)
 * - 111 - reserved
 */
//@{
#define BP_MLB150_MLBC0_MLBCLK_2_0      (2)      //!< Bit position for MLB150_MLBC0_MLBCLK_2_0.
#define BM_MLB150_MLBC0_MLBCLK_2_0      (0x0000001c)  //!< Bit mask for MLB150_MLBC0_MLBCLK_2_0.

//! @brief Get value of MLB150_MLBC0_MLBCLK_2_0 from a register value.
#define BG_MLB150_MLBC0_MLBCLK_2_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_MLBCLK_2_0) >> BP_MLB150_MLBC0_MLBCLK_2_0)

//! @brief Format value for bitfield MLB150_MLBC0_MLBCLK_2_0.
#define BF_MLB150_MLBC0_MLBCLK_2_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_MLBCLK_2_0) & BM_MLB150_MLBC0_MLBCLK_2_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MLBCLK_2_0 field to a new value.
#define BW_MLB150_MLBC0_MLBCLK_2_0(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_MLBCLK_2_0) | BF_MLB150_MLBC0_MLBCLK_2_0(v)))
#endif
//@}

/*! @name Register MLB150_MLBC0, field MLBPEN[5] (RW)
 *
 * MediaLB 6-pin enable.
 *
 * Values:
 * - 0 - MediaLB 3-pin interface enabled
 * - 1 - MediaLB 6-pin interface enabled. MLB PLL and MLB PHY is enabled in this case.
 */
//@{
#define BP_MLB150_MLBC0_MLBPEN      (5)      //!< Bit position for MLB150_MLBC0_MLBPEN.
#define BM_MLB150_MLBC0_MLBPEN      (0x00000020)  //!< Bit mask for MLB150_MLBC0_MLBPEN.

//! @brief Get value of MLB150_MLBC0_MLBPEN from a register value.
#define BG_MLB150_MLBC0_MLBPEN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_MLBPEN) >> BP_MLB150_MLBC0_MLBPEN)

//! @brief Format value for bitfield MLB150_MLBC0_MLBPEN.
#define BF_MLB150_MLBC0_MLBPEN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_MLBPEN) & BM_MLB150_MLBC0_MLBPEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MLBPEN field to a new value.
#define BW_MLB150_MLBC0_MLBPEN(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_MLBPEN) | BF_MLB150_MLBC0_MLBPEN(v)))
#endif
//@}

/*! @name Register MLB150_MLBC0, field MLBLK[7] (RO)
 *
 * MediaLB lock status. When set, indicates that the MediaLB block is synchronized to the incoming
 * MediaLB frame. If MLBLK is clear (unlocked), MLBLK is set after FRAMESYNC is detected at the same
 * position for three consecutive frames. If MLBLK is set (locked), MLBLK is cleared after not
 * receiving FRAMESYNC at the expected time for two consecutive frames. While MLBLK is set,
 * FRAMESYNC patterns occurring at locations other than the expected one are ignored. (read-only)
 */
//@{
#define BP_MLB150_MLBC0_MLBLK      (7)      //!< Bit position for MLB150_MLBC0_MLBLK.
#define BM_MLB150_MLBC0_MLBLK      (0x00000080)  //!< Bit mask for MLB150_MLBC0_MLBLK.

//! @brief Get value of MLB150_MLBC0_MLBLK from a register value.
#define BG_MLB150_MLBC0_MLBLK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_MLBLK) >> BP_MLB150_MLBC0_MLBLK)
//@}

/*! @name Register MLB150_MLBC0, field ASYRETRY[12] (RW)
 *
 * Asynchronous Tx packet retry. When set, an asynchronous packet that is flagged with a Break or
 * ProtocolError by the receiver is retransmitted. When cleared, an asynchronous packet that is
 * flagged with a Break or ProtocolError by the receiver is skipped.
 */
//@{
#define BP_MLB150_MLBC0_ASYRETRY      (12)      //!< Bit position for MLB150_MLBC0_ASYRETRY.
#define BM_MLB150_MLBC0_ASYRETRY      (0x00001000)  //!< Bit mask for MLB150_MLBC0_ASYRETRY.

//! @brief Get value of MLB150_MLBC0_ASYRETRY from a register value.
#define BG_MLB150_MLBC0_ASYRETRY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_ASYRETRY) >> BP_MLB150_MLBC0_ASYRETRY)

//! @brief Format value for bitfield MLB150_MLBC0_ASYRETRY.
#define BF_MLB150_MLBC0_ASYRETRY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_ASYRETRY) & BM_MLB150_MLBC0_ASYRETRY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ASYRETRY field to a new value.
#define BW_MLB150_MLBC0_ASYRETRY(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_ASYRETRY) | BF_MLB150_MLBC0_ASYRETRY(v)))
#endif
//@}

/*! @name Register MLB150_MLBC0, field CTLRETRY[14] (RW)
 *
 * Control Tx packet retry. When set, a control packet that is flagged with a Break or ProtocolError
 * by the receiver is retransmitted. When cleared, a control packet that is flagged with a Break or
 * ProtocolError by the receiver is skipped.
 */
//@{
#define BP_MLB150_MLBC0_CTLRETRY      (14)      //!< Bit position for MLB150_MLBC0_CTLRETRY.
#define BM_MLB150_MLBC0_CTLRETRY      (0x00004000)  //!< Bit mask for MLB150_MLBC0_CTLRETRY.

//! @brief Get value of MLB150_MLBC0_CTLRETRY from a register value.
#define BG_MLB150_MLBC0_CTLRETRY(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_CTLRETRY) >> BP_MLB150_MLBC0_CTLRETRY)

//! @brief Format value for bitfield MLB150_MLBC0_CTLRETRY.
#define BF_MLB150_MLBC0_CTLRETRY(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_CTLRETRY) & BM_MLB150_MLBC0_CTLRETRY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTLRETRY field to a new value.
#define BW_MLB150_MLBC0_CTLRETRY(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_CTLRETRY) | BF_MLB150_MLBC0_CTLRETRY(v)))
#endif
//@}

/*! @name Register MLB150_MLBC0, field FCNT[17:15] (RW)
 *
 * The number of frames per sub-buffer for synchronous channels.
 *
 * Values:
 * - 000 - 1 frame per sub-buffer (Operation is the same as Standard mode.)
 * - 001 - 2 frames per sub-buffer
 * - 010 - 4 frames per sub-buffer
 * - 011 - 8 frames per sub-buffer
 * - 100 - 16 frames per sub-buffer
 * - 101 - 32 frames per sub-buffer
 * - 110 - 64 frames per sub-buffer
 * - 111 - Reserved
 */
//@{
#define BP_MLB150_MLBC0_FCNT      (15)      //!< Bit position for MLB150_MLBC0_FCNT.
#define BM_MLB150_MLBC0_FCNT      (0x00038000)  //!< Bit mask for MLB150_MLBC0_FCNT.

//! @brief Get value of MLB150_MLBC0_FCNT from a register value.
#define BG_MLB150_MLBC0_FCNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC0_FCNT) >> BP_MLB150_MLBC0_FCNT)

//! @brief Format value for bitfield MLB150_MLBC0_FCNT.
#define BF_MLB150_MLBC0_FCNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBC0_FCNT) & BM_MLB150_MLBC0_FCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FCNT field to a new value.
#define BW_MLB150_MLBC0_FCNT(v)   (HW_MLB150_MLBC0_WR((HW_MLB150_MLBC0_RD() & ~BM_MLB150_MLBC0_FCNT) | BF_MLB150_MLBC0_FCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MLBPC0 - MediaLB 6-pin Control 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MLBPC0 - MediaLB 6-pin Control 0 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mlbpc0
{
    reg32_t U;
    struct _hw_mlb150_mlbpc0_bitfields
    {
        unsigned RESERVED0 : 11; //!< [10:0] Reserved
        unsigned MCLKHYS : 1; //!< [11] MediaLB (6-pin) hysteresis enable.
        unsigned RESERVED1 : 20; //!< [31:12] Reserved
    } B;
} hw_mlb150_mlbpc0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MLBPC0 register
 */
//@{
#define HW_MLB150_MLBPC0_ADDR      (REGS_MLB150_BASE + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MLBPC0           (*(volatile hw_mlb150_mlbpc0_t *) HW_MLB150_MLBPC0_ADDR)
#define HW_MLB150_MLBPC0_RD()      (HW_MLB150_MLBPC0.U)
#define HW_MLB150_MLBPC0_WR(v)     (HW_MLB150_MLBPC0.U = (v))
#define HW_MLB150_MLBPC0_SET(v)    (HW_MLB150_MLBPC0_WR(HW_MLB150_MLBPC0_RD() |  (v)))
#define HW_MLB150_MLBPC0_CLR(v)    (HW_MLB150_MLBPC0_WR(HW_MLB150_MLBPC0_RD() & ~(v)))
#define HW_MLB150_MLBPC0_TOG(v)    (HW_MLB150_MLBPC0_WR(HW_MLB150_MLBPC0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MLBPC0 bitfields
 */

/*! @name Register MLB150_MLBPC0, field MCLKHYS[11] (RW)
 *
 * MediaLB (6-pin) hysteresis enable. When set, enables hysteresis on the MLB_CLK (MediaLB clock).
 * This value is driven on mlb_clk_hys_enable output pin and has no internal function.
 */
//@{
#define BP_MLB150_MLBPC0_MCLKHYS      (11)      //!< Bit position for MLB150_MLBPC0_MCLKHYS.
#define BM_MLB150_MLBPC0_MCLKHYS      (0x00000800)  //!< Bit mask for MLB150_MLBPC0_MCLKHYS.

//! @brief Get value of MLB150_MLBPC0_MCLKHYS from a register value.
#define BG_MLB150_MLBPC0_MCLKHYS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC0_MCLKHYS) >> BP_MLB150_MLBPC0_MCLKHYS)

//! @brief Format value for bitfield MLB150_MLBPC0_MCLKHYS.
#define BF_MLB150_MLBPC0_MCLKHYS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBPC0_MCLKHYS) & BM_MLB150_MLBPC0_MCLKHYS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCLKHYS field to a new value.
#define BW_MLB150_MLBPC0_MCLKHYS(v)   (HW_MLB150_MLBPC0_WR((HW_MLB150_MLBPC0_RD() & ~BM_MLB150_MLBPC0_MCLKHYS) | BF_MLB150_MLBPC0_MCLKHYS(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MS0 - MediaLB Channel Status 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MS0 - MediaLB Channel Status 0 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_ms0
{
    reg32_t U;
    struct _hw_mlb150_ms0_bitfields
    {
        unsigned MCS_31_0 : 32; //!< [31:0] MediaLB channel status.
    } B;
} hw_mlb150_ms0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MS0 register
 */
//@{
#define HW_MLB150_MS0_ADDR      (REGS_MLB150_BASE + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MS0           (*(volatile hw_mlb150_ms0_t *) HW_MLB150_MS0_ADDR)
#define HW_MLB150_MS0_RD()      (HW_MLB150_MS0.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MS0 bitfields
 */

/*! @name Register MLB150_MS0, field MCS_31_0[31:0] (RO)
 *
 * MediaLB channel status. Indicates the channel status for MediaLB channels 31 to 0. Channel status
 * bits are set by hardware and cleared by software. Status is only set if the appropriate bits in
 * the MIEN register are set.
 */
//@{
#define BP_MLB150_MS0_MCS_31_0      (0)      //!< Bit position for MLB150_MS0_MCS_31_0.
#define BM_MLB150_MS0_MCS_31_0      (0xffffffff)  //!< Bit mask for MLB150_MS0_MCS_31_0.

//! @brief Get value of MLB150_MS0_MCS_31_0 from a register value.
#define BG_MLB150_MS0_MCS_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MS0_MCS_31_0) >> BP_MLB150_MS0_MCS_31_0)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MLBPC2 - MediaLB 6-pin Control 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MLBPC2 - MediaLB 6-pin Control 2 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mlbpc2
{
    reg32_t U;
    struct _hw_mlb150_mlbpc2_bitfields
    {
        unsigned SDOPC : 1; //!< [0] MLB 3-pin interface: Signal/Data output phase control.
        unsigned SDRTO : 2; //!< [2:1] MLB 6-pin interface: Signal/Data receiver threshold offset control.
        unsigned RESERVED0 : 29; //!< [31:3] Reserved.
    } B;
} hw_mlb150_mlbpc2_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MLBPC2 register
 */
//@{
#define HW_MLB150_MLBPC2_ADDR      (REGS_MLB150_BASE + 0xd)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MLBPC2           (*(volatile hw_mlb150_mlbpc2_t *) HW_MLB150_MLBPC2_ADDR)
#define HW_MLB150_MLBPC2_RD()      (HW_MLB150_MLBPC2.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MLBPC2 bitfields
 */

/*! @name Register MLB150_MLBPC2, field SDOPC[0] (RW)
 *
 * MLB 3-pin interface: Signal/Data output phase control.
 *
 * Values:
 * - 0 - MLB_SIG / MLB_DATA launch at rising edge of MLB_CLK(default)
 * - 1 - MLB_SIG / MLB_DATA launch at falling edge of MLB_CLK
 */
//@{
#define BP_MLB150_MLBPC2_SDOPC      (0)      //!< Bit position for MLB150_MLBPC2_SDOPC.
#define BM_MLB150_MLBPC2_SDOPC      (0x00000001)  //!< Bit mask for MLB150_MLBPC2_SDOPC.

//! @brief Get value of MLB150_MLBPC2_SDOPC from a register value.
#define BG_MLB150_MLBPC2_SDOPC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC2_SDOPC) >> BP_MLB150_MLBPC2_SDOPC)
//@}

/*! @name Register MLB150_MLBPC2, field SDRTO[2:1] (RW)
 *
 * MLB 6-pin interface: Signal/Data receiver threshold offset control.
 */
//@{
#define BP_MLB150_MLBPC2_SDRTO      (1)      //!< Bit position for MLB150_MLBPC2_SDRTO.
#define BM_MLB150_MLBPC2_SDRTO      (0x00000006)  //!< Bit mask for MLB150_MLBPC2_SDRTO.

//! @brief Get value of MLB150_MLBPC2_SDRTO from a register value.
#define BG_MLB150_MLBPC2_SDRTO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC2_SDRTO) >> BP_MLB150_MLBPC2_SDRTO)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MS1 - MediaLB Channel Status1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MS1 - MediaLB Channel Status1 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_ms1
{
    reg32_t U;
    struct _hw_mlb150_ms1_bitfields
    {
        unsigned MCS_63_32 : 32; //!< [31:0] MediaLB channel status.
    } B;
} hw_mlb150_ms1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MS1 register
 */
//@{
#define HW_MLB150_MS1_ADDR      (REGS_MLB150_BASE + 0x14)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MS1           (*(volatile hw_mlb150_ms1_t *) HW_MLB150_MS1_ADDR)
#define HW_MLB150_MS1_RD()      (HW_MLB150_MS1.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MS1 bitfields
 */

/*! @name Register MLB150_MS1, field MCS_63_32[31:0] (RO)
 *
 * MediaLB channel status. Indicates the channel status for MediaLB channels 63 to 32. Channel
 * status bits are set by hardware and cleared by software. Status is only set if the appropriate
 * bits in the MIEN register are set.
 */
//@{
#define BP_MLB150_MS1_MCS_63_32      (0)      //!< Bit position for MLB150_MS1_MCS_63_32.
#define BM_MLB150_MS1_MCS_63_32      (0xffffffff)  //!< Bit mask for MLB150_MS1_MCS_63_32.

//! @brief Get value of MLB150_MS1_MCS_63_32 from a register value.
#define BG_MLB150_MS1_MCS_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MS1_MCS_63_32) >> BP_MLB150_MS1_MCS_63_32)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MSS - MediaLB System Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MSS - MediaLB System Status Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mss
{
    reg32_t U;
    struct _hw_mlb150_mss_bitfields
    {
        unsigned RSTSYSCMD : 1; //!< [0] Reset system command detected (in the system quadlet).
        unsigned LKSYSCMD : 1; //!< [1] Network lock system command detected (in the system quadlet).
        unsigned ULKSYSCMD : 1; //!< [2] Network unlock system command detected (in the system quadlet).
        unsigned CSSYSCMD : 1; //!< [3] Channel scan system command detected (in the system quadlet).
        unsigned SWSYSCMD : 1; //!< [4] Software system command detected (in the system quadlet).
        unsigned SERVREQ : 1; //!< [5] Service request enabled.
        unsigned RESERVED0 : 26; //!< [31:6] Reserved
    } B;
} hw_mlb150_mss_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MSS register
 */
//@{
#define HW_MLB150_MSS_ADDR      (REGS_MLB150_BASE + 0x20)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MSS           (*(volatile hw_mlb150_mss_t *) HW_MLB150_MSS_ADDR)
#define HW_MLB150_MSS_RD()      (HW_MLB150_MSS.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MSS bitfields
 */

/*! @name Register MLB150_MSS, field RSTSYSCMD[0] (RO)
 *
 * Reset system command detected (in the system quadlet). Set by hardware, cleared by software.
 */
//@{
#define BP_MLB150_MSS_RSTSYSCMD      (0)      //!< Bit position for MLB150_MSS_RSTSYSCMD.
#define BM_MLB150_MSS_RSTSYSCMD      (0x00000001)  //!< Bit mask for MLB150_MSS_RSTSYSCMD.

//! @brief Get value of MLB150_MSS_RSTSYSCMD from a register value.
#define BG_MLB150_MSS_RSTSYSCMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_RSTSYSCMD) >> BP_MLB150_MSS_RSTSYSCMD)
//@}

/*! @name Register MLB150_MSS, field LKSYSCMD[1] (RO)
 *
 * Network lock system command detected (in the system quadlet). Set by hardware, cleared by
 * software.
 */
//@{
#define BP_MLB150_MSS_LKSYSCMD      (1)      //!< Bit position for MLB150_MSS_LKSYSCMD.
#define BM_MLB150_MSS_LKSYSCMD      (0x00000002)  //!< Bit mask for MLB150_MSS_LKSYSCMD.

//! @brief Get value of MLB150_MSS_LKSYSCMD from a register value.
#define BG_MLB150_MSS_LKSYSCMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_LKSYSCMD) >> BP_MLB150_MSS_LKSYSCMD)
//@}

/*! @name Register MLB150_MSS, field ULKSYSCMD[2] (RO)
 *
 * Network unlock system command detected (in the system quadlet). Set by hardware, cleared by
 * software.
 */
//@{
#define BP_MLB150_MSS_ULKSYSCMD      (2)      //!< Bit position for MLB150_MSS_ULKSYSCMD.
#define BM_MLB150_MSS_ULKSYSCMD      (0x00000004)  //!< Bit mask for MLB150_MSS_ULKSYSCMD.

//! @brief Get value of MLB150_MSS_ULKSYSCMD from a register value.
#define BG_MLB150_MSS_ULKSYSCMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_ULKSYSCMD) >> BP_MLB150_MSS_ULKSYSCMD)
//@}

/*! @name Register MLB150_MSS, field CSSYSCMD[3] (RO)
 *
 * Channel scan system command detected (in the system quadlet). Set by hardware, cleared by
 * software. If the node address specified in Data quadlet matches the value in MLBC1.NDA , the
 * device responds either "device present" or "device present, request service" system response in
 * the next system quadlet.
 */
//@{
#define BP_MLB150_MSS_CSSYSCMD      (3)      //!< Bit position for MLB150_MSS_CSSYSCMD.
#define BM_MLB150_MSS_CSSYSCMD      (0x00000008)  //!< Bit mask for MLB150_MSS_CSSYSCMD.

//! @brief Get value of MLB150_MSS_CSSYSCMD from a register value.
#define BG_MLB150_MSS_CSSYSCMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_CSSYSCMD) >> BP_MLB150_MSS_CSSYSCMD)
//@}

/*! @name Register MLB150_MSS, field SWSYSCMD[4] (RO)
 *
 * Software system command detected (in the system quadlet). Set by hardware, cleared by software.
 * Data is stored in the MSD register for this command.
 */
//@{
#define BP_MLB150_MSS_SWSYSCMD      (4)      //!< Bit position for MLB150_MSS_SWSYSCMD.
#define BM_MLB150_MSS_SWSYSCMD      (0x00000010)  //!< Bit mask for MLB150_MSS_SWSYSCMD.

//! @brief Get value of MLB150_MSS_SWSYSCMD from a register value.
#define BG_MLB150_MSS_SWSYSCMD(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_SWSYSCMD) >> BP_MLB150_MSS_SWSYSCMD)
//@}

/*! @name Register MLB150_MSS, field SERVREQ[5] (RW)
 *
 * Service request enabled. When set, the MediaLB block responds with a "device present, request
 * service" system response if a matching channel scan system command is detected. When cleared, the
 * MediaLB block responds with a "device present" system response.
 */
//@{
#define BP_MLB150_MSS_SERVREQ      (5)      //!< Bit position for MLB150_MSS_SERVREQ.
#define BM_MLB150_MSS_SERVREQ      (0x00000020)  //!< Bit mask for MLB150_MSS_SERVREQ.

//! @brief Get value of MLB150_MSS_SERVREQ from a register value.
#define BG_MLB150_MSS_SERVREQ(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSS_SERVREQ) >> BP_MLB150_MSS_SERVREQ)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MSD - MediaLB System Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MSD - MediaLB System Data Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_msd
{
    reg32_t U;
    struct _hw_mlb150_msd_bitfields
    {
        unsigned SD0_7_0 : 8; //!< [7:0] System data (byte 0).
        unsigned SD1_7_0 : 8; //!< [15:8] System data (byte 1).
        unsigned SD2_7_0 : 8; //!< [23:16] System data (byte 2).
        unsigned SD3_7_0 : 8; //!< [31:24] System data (byte 3).
    } B;
} hw_mlb150_msd_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MSD register
 */
//@{
#define HW_MLB150_MSD_ADDR      (REGS_MLB150_BASE + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MSD           (*(volatile hw_mlb150_msd_t *) HW_MLB150_MSD_ADDR)
#define HW_MLB150_MSD_RD()      (HW_MLB150_MSD.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MSD bitfields
 */

/*! @name Register MLB150_MSD, field SD0_7_0[7:0] (RO)
 *
 * System data (byte 0). Updated with MediaLB Data[7:0] when a MediaLB software system command is
 * received in the system quadlet. If MSS.SWSYSCMD is already set, then SD0 is not updated. (read-
 * only)
 */
//@{
#define BP_MLB150_MSD_SD0_7_0      (0)      //!< Bit position for MLB150_MSD_SD0_7_0.
#define BM_MLB150_MSD_SD0_7_0      (0x000000ff)  //!< Bit mask for MLB150_MSD_SD0_7_0.

//! @brief Get value of MLB150_MSD_SD0_7_0 from a register value.
#define BG_MLB150_MSD_SD0_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSD_SD0_7_0) >> BP_MLB150_MSD_SD0_7_0)
//@}

/*! @name Register MLB150_MSD, field SD1_7_0[15:8] (RO)
 *
 * System data (byte 1). Updated with MediaLB Data[15:8] when a MediaLB software system command is
 * received in the system quadlet. If MSS.SWSYSCMD is already set, then SD1 is not updated. (read-
 * only)
 */
//@{
#define BP_MLB150_MSD_SD1_7_0      (8)      //!< Bit position for MLB150_MSD_SD1_7_0.
#define BM_MLB150_MSD_SD1_7_0      (0x0000ff00)  //!< Bit mask for MLB150_MSD_SD1_7_0.

//! @brief Get value of MLB150_MSD_SD1_7_0 from a register value.
#define BG_MLB150_MSD_SD1_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSD_SD1_7_0) >> BP_MLB150_MSD_SD1_7_0)
//@}

/*! @name Register MLB150_MSD, field SD2_7_0[23:16] (RO)
 *
 * System data (byte 2). Updated with MediaLB Data[23:16] when a MediaLB software system command is
 * received in the system quadlet. If MSS.SWSYSCMD is already set, then SD2 is not updated. (read-
 * only)
 */
//@{
#define BP_MLB150_MSD_SD2_7_0      (16)      //!< Bit position for MLB150_MSD_SD2_7_0.
#define BM_MLB150_MSD_SD2_7_0      (0x00ff0000)  //!< Bit mask for MLB150_MSD_SD2_7_0.

//! @brief Get value of MLB150_MSD_SD2_7_0 from a register value.
#define BG_MLB150_MSD_SD2_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSD_SD2_7_0) >> BP_MLB150_MSD_SD2_7_0)
//@}

/*! @name Register MLB150_MSD, field SD3_7_0[31:24] (RO)
 *
 * System data (byte 3). Updated with MediaLB Data[31:24] when a MediaLB software system command is
 * received in the system quadlet. If MSS.SWSYSCMD is already set, then SD3 is not updated. (read-
 * only)
 */
//@{
#define BP_MLB150_MSD_SD3_7_0      (24)      //!< Bit position for MLB150_MSD_SD3_7_0.
#define BM_MLB150_MSD_SD3_7_0      (0xff000000)  //!< Bit mask for MLB150_MSD_SD3_7_0.

//! @brief Get value of MLB150_MSD_SD3_7_0 from a register value.
#define BG_MLB150_MSD_SD3_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MSD_SD3_7_0) >> BP_MLB150_MSD_SD3_7_0)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MIEN - MediaLB Interrupt Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MIEN - MediaLB Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mien
{
    reg32_t U;
    struct _hw_mlb150_mien_bitfields
    {
        unsigned ISOC_PE : 1; //!< [0] Isochronous Rx protocol error enable.
        unsigned ISOC_BUFO : 1; //!< [1] Isochronous Rx buffer overflow enable.
        unsigned RESERVED0 : 14; //!< [15:2] Reserved
        unsigned SYNC_PE : 1; //!< [16] Synchronous protocol error enable.
        unsigned ARX_DONE : 1; //!< [17] Asynchronous Rx done enable.
        unsigned ARX_PE : 1; //!< [18] Asynchronous Rx protocol error enable.
        unsigned ARX_BREAK : 1; //!< [19] Asynchronous Rx break enable.
        unsigned ATX_DONE : 1; //!< [20] Asynchronous Tx packet done enable.
        unsigned ATX_PE : 1; //!< [21] Asynchronous Tx protocol error enable.
        unsigned ATX_BREAK : 1; //!< [22] Asynchronous Tx break enable.
        unsigned RESERVED1 : 1; //!< [23] Reserved
        unsigned CRX_DONE : 1; //!< [24] Control Rx packet done enable.
        unsigned CRX_PE : 1; //!< [25] Control Rx protocol error enable.
        unsigned CRX_BREAK : 1; //!< [26] Control Rx break enable.
        unsigned CTX_DONE : 1; //!< [27] Control Tx packet done enable.
        unsigned CTX_PE : 1; //!< [28] Control Tx protocol error enable.
        unsigned CTX_BREAK : 1; //!< [29] Control Tx break enable.
        unsigned RESERVED2 : 2; //!< [31:30] Reserved
    } B;
} hw_mlb150_mien_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MIEN register
 */
//@{
#define HW_MLB150_MIEN_ADDR      (REGS_MLB150_BASE + 0x2c)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MIEN           (*(volatile hw_mlb150_mien_t *) HW_MLB150_MIEN_ADDR)
#define HW_MLB150_MIEN_RD()      (HW_MLB150_MIEN.U)
#define HW_MLB150_MIEN_WR(v)     (HW_MLB150_MIEN.U = (v))
#define HW_MLB150_MIEN_SET(v)    (HW_MLB150_MIEN_WR(HW_MLB150_MIEN_RD() |  (v)))
#define HW_MLB150_MIEN_CLR(v)    (HW_MLB150_MIEN_WR(HW_MLB150_MIEN_RD() & ~(v)))
#define HW_MLB150_MIEN_TOG(v)    (HW_MLB150_MIEN_WR(HW_MLB150_MIEN_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MIEN bitfields
 */

/*! @name Register MLB150_MIEN, field ISOC_PE[0] (RW)
 *
 * Isochronous Rx protocol error enable. When set, a ProtocolError detected on an isochronous Rx
 * channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ISOC_PE      (0)      //!< Bit position for MLB150_MIEN_ISOC_PE.
#define BM_MLB150_MIEN_ISOC_PE      (0x00000001)  //!< Bit mask for MLB150_MIEN_ISOC_PE.

//! @brief Get value of MLB150_MIEN_ISOC_PE from a register value.
#define BG_MLB150_MIEN_ISOC_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ISOC_PE) >> BP_MLB150_MIEN_ISOC_PE)

//! @brief Format value for bitfield MLB150_MIEN_ISOC_PE.
#define BF_MLB150_MIEN_ISOC_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ISOC_PE) & BM_MLB150_MIEN_ISOC_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISOC_PE field to a new value.
#define BW_MLB150_MIEN_ISOC_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ISOC_PE) | BF_MLB150_MIEN_ISOC_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ISOC_BUFO[1] (RW)
 *
 * Isochronous Rx buffer overflow enable. When set, a buffer overflow on an isochronous Rx channel
 * causes the appropriate channel bit in the MS0 or MS1 registers to be set. This occurs only when
 * isochronous flow control is disabled.
 */
//@{
#define BP_MLB150_MIEN_ISOC_BUFO      (1)      //!< Bit position for MLB150_MIEN_ISOC_BUFO.
#define BM_MLB150_MIEN_ISOC_BUFO      (0x00000002)  //!< Bit mask for MLB150_MIEN_ISOC_BUFO.

//! @brief Get value of MLB150_MIEN_ISOC_BUFO from a register value.
#define BG_MLB150_MIEN_ISOC_BUFO(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ISOC_BUFO) >> BP_MLB150_MIEN_ISOC_BUFO)

//! @brief Format value for bitfield MLB150_MIEN_ISOC_BUFO.
#define BF_MLB150_MIEN_ISOC_BUFO(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ISOC_BUFO) & BM_MLB150_MIEN_ISOC_BUFO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ISOC_BUFO field to a new value.
#define BW_MLB150_MIEN_ISOC_BUFO(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ISOC_BUFO) | BF_MLB150_MIEN_ISOC_BUFO(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field SYNC_PE[16] (RW)
 *
 * Synchronous protocol error enable. When set, a ProtocolError detected on a synchronous Rx channel
 * causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_SYNC_PE      (16)      //!< Bit position for MLB150_MIEN_SYNC_PE.
#define BM_MLB150_MIEN_SYNC_PE      (0x00010000)  //!< Bit mask for MLB150_MIEN_SYNC_PE.

//! @brief Get value of MLB150_MIEN_SYNC_PE from a register value.
#define BG_MLB150_MIEN_SYNC_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_SYNC_PE) >> BP_MLB150_MIEN_SYNC_PE)

//! @brief Format value for bitfield MLB150_MIEN_SYNC_PE.
#define BF_MLB150_MIEN_SYNC_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_SYNC_PE) & BM_MLB150_MIEN_SYNC_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNC_PE field to a new value.
#define BW_MLB150_MIEN_SYNC_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_SYNC_PE) | BF_MLB150_MIEN_SYNC_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ARX_DONE[17] (RW)
 *
 * Asynchronous Rx done enable. When set, a packet received with no errors on an asynchronous Rx
 * channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ARX_DONE      (17)      //!< Bit position for MLB150_MIEN_ARX_DONE.
#define BM_MLB150_MIEN_ARX_DONE      (0x00020000)  //!< Bit mask for MLB150_MIEN_ARX_DONE.

//! @brief Get value of MLB150_MIEN_ARX_DONE from a register value.
#define BG_MLB150_MIEN_ARX_DONE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ARX_DONE) >> BP_MLB150_MIEN_ARX_DONE)

//! @brief Format value for bitfield MLB150_MIEN_ARX_DONE.
#define BF_MLB150_MIEN_ARX_DONE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ARX_DONE) & BM_MLB150_MIEN_ARX_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARX_DONE field to a new value.
#define BW_MLB150_MIEN_ARX_DONE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ARX_DONE) | BF_MLB150_MIEN_ARX_DONE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ARX_PE[18] (RW)
 *
 * Asynchronous Rx protocol error enable. When set, a ProtocolError detected on an asynchronous Rx
 * channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ARX_PE      (18)      //!< Bit position for MLB150_MIEN_ARX_PE.
#define BM_MLB150_MIEN_ARX_PE      (0x00040000)  //!< Bit mask for MLB150_MIEN_ARX_PE.

//! @brief Get value of MLB150_MIEN_ARX_PE from a register value.
#define BG_MLB150_MIEN_ARX_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ARX_PE) >> BP_MLB150_MIEN_ARX_PE)

//! @brief Format value for bitfield MLB150_MIEN_ARX_PE.
#define BF_MLB150_MIEN_ARX_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ARX_PE) & BM_MLB150_MIEN_ARX_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARX_PE field to a new value.
#define BW_MLB150_MIEN_ARX_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ARX_PE) | BF_MLB150_MIEN_ARX_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ARX_BREAK[19] (RW)
 *
 * Asynchronous Rx break enable. When set, a AsyncBreak command received from the transmitter on an
 * asynchronous Rx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ARX_BREAK      (19)      //!< Bit position for MLB150_MIEN_ARX_BREAK.
#define BM_MLB150_MIEN_ARX_BREAK      (0x00080000)  //!< Bit mask for MLB150_MIEN_ARX_BREAK.

//! @brief Get value of MLB150_MIEN_ARX_BREAK from a register value.
#define BG_MLB150_MIEN_ARX_BREAK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ARX_BREAK) >> BP_MLB150_MIEN_ARX_BREAK)

//! @brief Format value for bitfield MLB150_MIEN_ARX_BREAK.
#define BF_MLB150_MIEN_ARX_BREAK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ARX_BREAK) & BM_MLB150_MIEN_ARX_BREAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARX_BREAK field to a new value.
#define BW_MLB150_MIEN_ARX_BREAK(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ARX_BREAK) | BF_MLB150_MIEN_ARX_BREAK(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ATX_DONE[20] (RW)
 *
 * Asynchronous Tx packet done enable. When set, a packet transmitted with no errors on an
 * asynchronous Tx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ATX_DONE      (20)      //!< Bit position for MLB150_MIEN_ATX_DONE.
#define BM_MLB150_MIEN_ATX_DONE      (0x00100000)  //!< Bit mask for MLB150_MIEN_ATX_DONE.

//! @brief Get value of MLB150_MIEN_ATX_DONE from a register value.
#define BG_MLB150_MIEN_ATX_DONE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ATX_DONE) >> BP_MLB150_MIEN_ATX_DONE)

//! @brief Format value for bitfield MLB150_MIEN_ATX_DONE.
#define BF_MLB150_MIEN_ATX_DONE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ATX_DONE) & BM_MLB150_MIEN_ATX_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATX_DONE field to a new value.
#define BW_MLB150_MIEN_ATX_DONE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ATX_DONE) | BF_MLB150_MIEN_ATX_DONE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ATX_PE[21] (RW)
 *
 * Asynchronous Tx protocol error enable. When set, a ProtocolError generated by the receiver on an
 * asynchronous Tx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ATX_PE      (21)      //!< Bit position for MLB150_MIEN_ATX_PE.
#define BM_MLB150_MIEN_ATX_PE      (0x00200000)  //!< Bit mask for MLB150_MIEN_ATX_PE.

//! @brief Get value of MLB150_MIEN_ATX_PE from a register value.
#define BG_MLB150_MIEN_ATX_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ATX_PE) >> BP_MLB150_MIEN_ATX_PE)

//! @brief Format value for bitfield MLB150_MIEN_ATX_PE.
#define BF_MLB150_MIEN_ATX_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ATX_PE) & BM_MLB150_MIEN_ATX_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATX_PE field to a new value.
#define BW_MLB150_MIEN_ATX_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ATX_PE) | BF_MLB150_MIEN_ATX_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field ATX_BREAK[22] (RW)
 *
 * Asynchronous Tx break enable. When set, a ReceiverBreak response received from the receiver on an
 * asynchronous Tx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_ATX_BREAK      (22)      //!< Bit position for MLB150_MIEN_ATX_BREAK.
#define BM_MLB150_MIEN_ATX_BREAK      (0x00400000)  //!< Bit mask for MLB150_MIEN_ATX_BREAK.

//! @brief Get value of MLB150_MIEN_ATX_BREAK from a register value.
#define BG_MLB150_MIEN_ATX_BREAK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_ATX_BREAK) >> BP_MLB150_MIEN_ATX_BREAK)

//! @brief Format value for bitfield MLB150_MIEN_ATX_BREAK.
#define BF_MLB150_MIEN_ATX_BREAK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_ATX_BREAK) & BM_MLB150_MIEN_ATX_BREAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATX_BREAK field to a new value.
#define BW_MLB150_MIEN_ATX_BREAK(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_ATX_BREAK) | BF_MLB150_MIEN_ATX_BREAK(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CRX_DONE[24] (RW)
 *
 * Control Rx packet done enable. When set, a packet received with no errors on a control Rx channel
 * causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CRX_DONE      (24)      //!< Bit position for MLB150_MIEN_CRX_DONE.
#define BM_MLB150_MIEN_CRX_DONE      (0x01000000)  //!< Bit mask for MLB150_MIEN_CRX_DONE.

//! @brief Get value of MLB150_MIEN_CRX_DONE from a register value.
#define BG_MLB150_MIEN_CRX_DONE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CRX_DONE) >> BP_MLB150_MIEN_CRX_DONE)

//! @brief Format value for bitfield MLB150_MIEN_CRX_DONE.
#define BF_MLB150_MIEN_CRX_DONE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CRX_DONE) & BM_MLB150_MIEN_CRX_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRX_DONE field to a new value.
#define BW_MLB150_MIEN_CRX_DONE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CRX_DONE) | BF_MLB150_MIEN_CRX_DONE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CRX_PE[25] (RW)
 *
 * Control Rx protocol error enable. When set, a ProtocolError detected on a control Rx channel
 * causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CRX_PE      (25)      //!< Bit position for MLB150_MIEN_CRX_PE.
#define BM_MLB150_MIEN_CRX_PE      (0x02000000)  //!< Bit mask for MLB150_MIEN_CRX_PE.

//! @brief Get value of MLB150_MIEN_CRX_PE from a register value.
#define BG_MLB150_MIEN_CRX_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CRX_PE) >> BP_MLB150_MIEN_CRX_PE)

//! @brief Format value for bitfield MLB150_MIEN_CRX_PE.
#define BF_MLB150_MIEN_CRX_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CRX_PE) & BM_MLB150_MIEN_CRX_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRX_PE field to a new value.
#define BW_MLB150_MIEN_CRX_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CRX_PE) | BF_MLB150_MIEN_CRX_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CRX_BREAK[26] (RW)
 *
 * Control Rx break enable. When set, a ControlBreak command received from the transmitter on a
 * control Rx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CRX_BREAK      (26)      //!< Bit position for MLB150_MIEN_CRX_BREAK.
#define BM_MLB150_MIEN_CRX_BREAK      (0x04000000)  //!< Bit mask for MLB150_MIEN_CRX_BREAK.

//! @brief Get value of MLB150_MIEN_CRX_BREAK from a register value.
#define BG_MLB150_MIEN_CRX_BREAK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CRX_BREAK) >> BP_MLB150_MIEN_CRX_BREAK)

//! @brief Format value for bitfield MLB150_MIEN_CRX_BREAK.
#define BF_MLB150_MIEN_CRX_BREAK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CRX_BREAK) & BM_MLB150_MIEN_CRX_BREAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRX_BREAK field to a new value.
#define BW_MLB150_MIEN_CRX_BREAK(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CRX_BREAK) | BF_MLB150_MIEN_CRX_BREAK(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CTX_DONE[27] (RW)
 *
 * Control Tx packet done enable. When set, a packet transmitted with no errors on a control Tx
 * channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CTX_DONE      (27)      //!< Bit position for MLB150_MIEN_CTX_DONE.
#define BM_MLB150_MIEN_CTX_DONE      (0x08000000)  //!< Bit mask for MLB150_MIEN_CTX_DONE.

//! @brief Get value of MLB150_MIEN_CTX_DONE from a register value.
#define BG_MLB150_MIEN_CTX_DONE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CTX_DONE) >> BP_MLB150_MIEN_CTX_DONE)

//! @brief Format value for bitfield MLB150_MIEN_CTX_DONE.
#define BF_MLB150_MIEN_CTX_DONE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CTX_DONE) & BM_MLB150_MIEN_CTX_DONE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTX_DONE field to a new value.
#define BW_MLB150_MIEN_CTX_DONE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CTX_DONE) | BF_MLB150_MIEN_CTX_DONE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CTX_PE[28] (RW)
 *
 * Control Tx protocol error enable. When set, a ProtocolError generated by the receiver on a
 * control Tx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CTX_PE      (28)      //!< Bit position for MLB150_MIEN_CTX_PE.
#define BM_MLB150_MIEN_CTX_PE      (0x10000000)  //!< Bit mask for MLB150_MIEN_CTX_PE.

//! @brief Get value of MLB150_MIEN_CTX_PE from a register value.
#define BG_MLB150_MIEN_CTX_PE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CTX_PE) >> BP_MLB150_MIEN_CTX_PE)

//! @brief Format value for bitfield MLB150_MIEN_CTX_PE.
#define BF_MLB150_MIEN_CTX_PE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CTX_PE) & BM_MLB150_MIEN_CTX_PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTX_PE field to a new value.
#define BW_MLB150_MIEN_CTX_PE(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CTX_PE) | BF_MLB150_MIEN_CTX_PE(v)))
#endif
//@}

/*! @name Register MLB150_MIEN, field CTX_BREAK[29] (RW)
 *
 * Control Tx break enable. When set, a ReceiverBreak response received from the receiver on a
 * control Tx channel causes the appropriate channel bit in the MS0 or MS1 registers to be set.
 */
//@{
#define BP_MLB150_MIEN_CTX_BREAK      (29)      //!< Bit position for MLB150_MIEN_CTX_BREAK.
#define BM_MLB150_MIEN_CTX_BREAK      (0x20000000)  //!< Bit mask for MLB150_MIEN_CTX_BREAK.

//! @brief Get value of MLB150_MIEN_CTX_BREAK from a register value.
#define BG_MLB150_MIEN_CTX_BREAK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MIEN_CTX_BREAK) >> BP_MLB150_MIEN_CTX_BREAK)

//! @brief Format value for bitfield MLB150_MIEN_CTX_BREAK.
#define BF_MLB150_MIEN_CTX_BREAK(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MIEN_CTX_BREAK) & BM_MLB150_MIEN_CTX_BREAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTX_BREAK field to a new value.
#define BW_MLB150_MIEN_CTX_BREAK(v)   (HW_MLB150_MIEN_WR((HW_MLB150_MIEN_RD() & ~BM_MLB150_MIEN_CTX_BREAK) | BF_MLB150_MIEN_CTX_BREAK(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MLBPC1 - MediaLB 6-pin Control 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MLBPC1 - MediaLB 6-pin Control 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mlbpc1
{
    reg32_t U;
    struct _hw_mlb150_mlbpc1_bitfields
    {
        unsigned SDRCVBIAS_3_0 : 4; //!< [3:0] Signal/Data receiver bias control (for MediaLB 6-pin interface).
        unsigned SDXMTBIAS_3_0 : 4; //!< [7:4] Signal/Data transmitter bias control (for MediaLB 6-pin interface).
        unsigned CKRCVBIAS_3_0 : 4; //!< [11:8] Clock receiver bias control (for MediaLB 6-pin interface).
        unsigned RESERVED0 : 20; //!< [31:12] Reserved
    } B;
} hw_mlb150_mlbpc1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MLBPC1 register
 */
//@{
#define HW_MLB150_MLBPC1_ADDR      (REGS_MLB150_BASE + 0x38)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MLBPC1           (*(volatile hw_mlb150_mlbpc1_t *) HW_MLB150_MLBPC1_ADDR)
#define HW_MLB150_MLBPC1_RD()      (HW_MLB150_MLBPC1.U)
#define HW_MLB150_MLBPC1_WR(v)     (HW_MLB150_MLBPC1.U = (v))
#define HW_MLB150_MLBPC1_SET(v)    (HW_MLB150_MLBPC1_WR(HW_MLB150_MLBPC1_RD() |  (v)))
#define HW_MLB150_MLBPC1_CLR(v)    (HW_MLB150_MLBPC1_WR(HW_MLB150_MLBPC1_RD() & ~(v)))
#define HW_MLB150_MLBPC1_TOG(v)    (HW_MLB150_MLBPC1_WR(HW_MLB150_MLBPC1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MLBPC1 bitfields
 */

/*! @name Register MLB150_MLBPC1, field SDRCVBIAS_3_0[3:0] (RW)
 *
 * Signal/Data receiver bias control (for MediaLB 6-pin interface). Must be written to 0xC when
 * MediaLB 6-pin is initialized (final value needs to be determined through characterization). This
 * value is driven on MLB_SIG, MLB_SIG_N and MLB_SIG_P output pins and has no internal function.
 */
//@{
#define BP_MLB150_MLBPC1_SDRCVBIAS_3_0      (0)      //!< Bit position for MLB150_MLBPC1_SDRCVBIAS_3_0.
#define BM_MLB150_MLBPC1_SDRCVBIAS_3_0      (0x0000000f)  //!< Bit mask for MLB150_MLBPC1_SDRCVBIAS_3_0.

//! @brief Get value of MLB150_MLBPC1_SDRCVBIAS_3_0 from a register value.
#define BG_MLB150_MLBPC1_SDRCVBIAS_3_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC1_SDRCVBIAS_3_0) >> BP_MLB150_MLBPC1_SDRCVBIAS_3_0)

//! @brief Format value for bitfield MLB150_MLBPC1_SDRCVBIAS_3_0.
#define BF_MLB150_MLBPC1_SDRCVBIAS_3_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBPC1_SDRCVBIAS_3_0) & BM_MLB150_MLBPC1_SDRCVBIAS_3_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDRCVBIAS_3_0 field to a new value.
#define BW_MLB150_MLBPC1_SDRCVBIAS_3_0(v)   (HW_MLB150_MLBPC1_WR((HW_MLB150_MLBPC1_RD() & ~BM_MLB150_MLBPC1_SDRCVBIAS_3_0) | BF_MLB150_MLBPC1_SDRCVBIAS_3_0(v)))
#endif
//@}

/*! @name Register MLB150_MLBPC1, field SDXMTBIAS_3_0[7:4] (RW)
 *
 * Signal/Data transmitter bias control (for MediaLB 6-pin interface). Must be written to 0xC when
 * MediaLB 6-pin is initialized (final value needs to be determined through characterization). This
 * value is driven on MLB_DATA, MLB_DATA_N and MLB_DATA_P output pins and has no internal function.
 */
//@{
#define BP_MLB150_MLBPC1_SDXMTBIAS_3_0      (4)      //!< Bit position for MLB150_MLBPC1_SDXMTBIAS_3_0.
#define BM_MLB150_MLBPC1_SDXMTBIAS_3_0      (0x000000f0)  //!< Bit mask for MLB150_MLBPC1_SDXMTBIAS_3_0.

//! @brief Get value of MLB150_MLBPC1_SDXMTBIAS_3_0 from a register value.
#define BG_MLB150_MLBPC1_SDXMTBIAS_3_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC1_SDXMTBIAS_3_0) >> BP_MLB150_MLBPC1_SDXMTBIAS_3_0)

//! @brief Format value for bitfield MLB150_MLBPC1_SDXMTBIAS_3_0.
#define BF_MLB150_MLBPC1_SDXMTBIAS_3_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBPC1_SDXMTBIAS_3_0) & BM_MLB150_MLBPC1_SDXMTBIAS_3_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDXMTBIAS_3_0 field to a new value.
#define BW_MLB150_MLBPC1_SDXMTBIAS_3_0(v)   (HW_MLB150_MLBPC1_WR((HW_MLB150_MLBPC1_RD() & ~BM_MLB150_MLBPC1_SDXMTBIAS_3_0) | BF_MLB150_MLBPC1_SDXMTBIAS_3_0(v)))
#endif
//@}

/*! @name Register MLB150_MLBPC1, field CKRCVBIAS_3_0[11:8] (RW)
 *
 * Clock receiver bias control (for MediaLB 6-pin interface). Must be written to 0xC when MediaLB
 * 6-pin is initialized (final value needs to be determined through characterization). This value is
 * driven on MLB_CLK, MLB_CLK_N and MLB_CLK_P output pins and has no internal function.
 */
//@{
#define BP_MLB150_MLBPC1_CKRCVBIAS_3_0      (8)      //!< Bit position for MLB150_MLBPC1_CKRCVBIAS_3_0.
#define BM_MLB150_MLBPC1_CKRCVBIAS_3_0      (0x00000f00)  //!< Bit mask for MLB150_MLBPC1_CKRCVBIAS_3_0.

//! @brief Get value of MLB150_MLBPC1_CKRCVBIAS_3_0 from a register value.
#define BG_MLB150_MLBPC1_CKRCVBIAS_3_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBPC1_CKRCVBIAS_3_0) >> BP_MLB150_MLBPC1_CKRCVBIAS_3_0)

//! @brief Format value for bitfield MLB150_MLBPC1_CKRCVBIAS_3_0.
#define BF_MLB150_MLBPC1_CKRCVBIAS_3_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MLBPC1_CKRCVBIAS_3_0) & BM_MLB150_MLBPC1_CKRCVBIAS_3_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CKRCVBIAS_3_0 field to a new value.
#define BW_MLB150_MLBPC1_CKRCVBIAS_3_0(v)   (HW_MLB150_MLBPC1_WR((HW_MLB150_MLBPC1_RD() & ~BM_MLB150_MLBPC1_CKRCVBIAS_3_0) | BF_MLB150_MLBPC1_CKRCVBIAS_3_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MLBC1 - MediaLB Control 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MLBC1 - MediaLB Control 1 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mlbc1
{
    reg32_t U;
    struct _hw_mlb150_mlbc1_bitfields
    {
        unsigned RESERVED0 : 6; //!< [5:0] Reserved
        unsigned LOCK : 1; //!< [6] MediaLB lock error status.
        unsigned CLKM : 1; //!< [7] MediaLB clock missing status.
        unsigned NDA_7_0 : 8; //!< [15:8] Node device address.
        unsigned RESERVED1 : 16; //!< [31:16] Reserved
    } B;
} hw_mlb150_mlbc1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MLBC1 register
 */
//@{
#define HW_MLB150_MLBC1_ADDR      (REGS_MLB150_BASE + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MLBC1           (*(volatile hw_mlb150_mlbc1_t *) HW_MLB150_MLBC1_ADDR)
#define HW_MLB150_MLBC1_RD()      (HW_MLB150_MLBC1.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MLBC1 bitfields
 */

/*! @name Register MLB150_MLBC1, field LOCK[6] (RO)
 *
 * MediaLB lock error status. Set when MediaLB is unlocked; cleared by software.
 */
//@{
#define BP_MLB150_MLBC1_LOCK      (6)      //!< Bit position for MLB150_MLBC1_LOCK.
#define BM_MLB150_MLBC1_LOCK      (0x00000040)  //!< Bit mask for MLB150_MLBC1_LOCK.

//! @brief Get value of MLB150_MLBC1_LOCK from a register value.
#define BG_MLB150_MLBC1_LOCK(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC1_LOCK) >> BP_MLB150_MLBC1_LOCK)
//@}

/*! @name Register MLB150_MLBC1, field CLKM[7] (RO)
 *
 * MediaLB clock missing status. Set when MLB_CLK (MediaLB clock) is not toggling at the pin;
 * cleared by software.
 */
//@{
#define BP_MLB150_MLBC1_CLKM      (7)      //!< Bit position for MLB150_MLBC1_CLKM.
#define BM_MLB150_MLBC1_CLKM      (0x00000080)  //!< Bit mask for MLB150_MLBC1_CLKM.

//! @brief Get value of MLB150_MLBC1_CLKM from a register value.
#define BG_MLB150_MLBC1_CLKM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC1_CLKM) >> BP_MLB150_MLBC1_CLKM)
//@}

/*! @name Register MLB150_MLBC1, field NDA_7_0[15:8] (RW)
 *
 * Node device address. Used for system commands directed to individual MediaLB nodes.
 */
//@{
#define BP_MLB150_MLBC1_NDA_7_0      (8)      //!< Bit position for MLB150_MLBC1_NDA_7_0.
#define BM_MLB150_MLBC1_NDA_7_0      (0x0000ff00)  //!< Bit mask for MLB150_MLBC1_NDA_7_0.

//! @brief Get value of MLB150_MLBC1_NDA_7_0 from a register value.
#define BG_MLB150_MLBC1_NDA_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MLBC1_NDA_7_0) >> BP_MLB150_MLBC1_NDA_7_0)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCTL - HBI Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCTL - HBI Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HC can control and monitor general operation of the HBI block by reading and writing the HBI
 * Control Register (HCTL) through the I/O interface. Each bit of HCTL is read/write.
 */
typedef union _hw_mlb150_hctl
{
    reg32_t U;
    struct _hw_mlb150_hctl_bitfields
    {
        unsigned RST0 : 1; //!< [0] AGU0 software reset
        unsigned RST1 : 1; //!< [1] AGU1 software reset
        unsigned RESERVED0 : 13; //!< [14:2] Reserved
        unsigned EN : 1; //!< [15] HBI enable
        unsigned RESERVED1 : 16; //!< [31:16] Reserved
    } B;
} hw_mlb150_hctl_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCTL register
 */
//@{
#define HW_MLB150_HCTL_ADDR      (REGS_MLB150_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCTL           (*(volatile hw_mlb150_hctl_t *) HW_MLB150_HCTL_ADDR)
#define HW_MLB150_HCTL_RD()      (HW_MLB150_HCTL.U)
#define HW_MLB150_HCTL_WR(v)     (HW_MLB150_HCTL.U = (v))
#define HW_MLB150_HCTL_SET(v)    (HW_MLB150_HCTL_WR(HW_MLB150_HCTL_RD() |  (v)))
#define HW_MLB150_HCTL_CLR(v)    (HW_MLB150_HCTL_WR(HW_MLB150_HCTL_RD() & ~(v)))
#define HW_MLB150_HCTL_TOG(v)    (HW_MLB150_HCTL_WR(HW_MLB150_HCTL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_HCTL bitfields
 */

/*! @name Register MLB150_HCTL, field RST0[0] (RW)
 *
 * AGU0 software reset
 *
 * Values:
 * - 0 - active
 * - 1 - reset
 */
//@{
#define BP_MLB150_HCTL_RST0      (0)      //!< Bit position for MLB150_HCTL_RST0.
#define BM_MLB150_HCTL_RST0      (0x00000001)  //!< Bit mask for MLB150_HCTL_RST0.

//! @brief Get value of MLB150_HCTL_RST0 from a register value.
#define BG_MLB150_HCTL_RST0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCTL_RST0) >> BP_MLB150_HCTL_RST0)

//! @brief Format value for bitfield MLB150_HCTL_RST0.
#define BF_MLB150_HCTL_RST0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_HCTL_RST0) & BM_MLB150_HCTL_RST0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RST0 field to a new value.
#define BW_MLB150_HCTL_RST0(v)   (HW_MLB150_HCTL_WR((HW_MLB150_HCTL_RD() & ~BM_MLB150_HCTL_RST0) | BF_MLB150_HCTL_RST0(v)))
#endif
//@}

/*! @name Register MLB150_HCTL, field RST1[1] (RW)
 *
 * AGU1 software reset
 *
 * Values:
 * - 0 - active
 * - 1 - reset
 */
//@{
#define BP_MLB150_HCTL_RST1      (1)      //!< Bit position for MLB150_HCTL_RST1.
#define BM_MLB150_HCTL_RST1      (0x00000002)  //!< Bit mask for MLB150_HCTL_RST1.

//! @brief Get value of MLB150_HCTL_RST1 from a register value.
#define BG_MLB150_HCTL_RST1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCTL_RST1) >> BP_MLB150_HCTL_RST1)

//! @brief Format value for bitfield MLB150_HCTL_RST1.
#define BF_MLB150_HCTL_RST1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_HCTL_RST1) & BM_MLB150_HCTL_RST1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RST1 field to a new value.
#define BW_MLB150_HCTL_RST1(v)   (HW_MLB150_HCTL_WR((HW_MLB150_HCTL_RD() & ~BM_MLB150_HCTL_RST1) | BF_MLB150_HCTL_RST1(v)))
#endif
//@}

/*! @name Register MLB150_HCTL, field EN[15] (RW)
 *
 * HBI enable
 *
 * Values:
 * - 0 - disabled
 * - 1 - enabled
 */
//@{
#define BP_MLB150_HCTL_EN      (15)      //!< Bit position for MLB150_HCTL_EN.
#define BM_MLB150_HCTL_EN      (0x00008000)  //!< Bit mask for MLB150_HCTL_EN.

//! @brief Get value of MLB150_HCTL_EN from a register value.
#define BG_MLB150_HCTL_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCTL_EN) >> BP_MLB150_HCTL_EN)

//! @brief Format value for bitfield MLB150_HCTL_EN.
#define BF_MLB150_HCTL_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_HCTL_EN) & BM_MLB150_HCTL_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EN field to a new value.
#define BW_MLB150_HCTL_EN(v)   (HW_MLB150_HCTL_WR((HW_MLB150_HCTL_RD() & ~BM_MLB150_HCTL_EN) | BF_MLB150_HCTL_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCMR0 - HBI Channel Mask 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCMR0 - HBI Channel Mask 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The HC can control which channel(s) are able to generate an HBI interrupt by writing the HBI
 * Channel Mask Registers (HCMRn). The HCMRn registers mask the channel interrupt on the hbi_hintb
 * signal (i.e. hbi_hintb will not become active for any masked channel). Each bit of HCMRn is
 * read/write.
 */
typedef union _hw_mlb150_hcmr0
{
    reg32_t U;
    struct _hw_mlb150_hcmr0_bitfields
    {
        unsigned CHM_31_0_P : 32; //!< [31:0] Bitwise channel mask bit
    } B;
} hw_mlb150_hcmr0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCMR0 register
 */
//@{
#define HW_MLB150_HCMR0_ADDR      (REGS_MLB150_BASE + 0x88)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCMR0           (*(volatile hw_mlb150_hcmr0_t *) HW_MLB150_HCMR0_ADDR)
#define HW_MLB150_HCMR0_RD()      (HW_MLB150_HCMR0.U)
#define HW_MLB150_HCMR0_WR(v)     (HW_MLB150_HCMR0.U = (v))
#define HW_MLB150_HCMR0_SET(v)    (HW_MLB150_HCMR0_WR(HW_MLB150_HCMR0_RD() |  (v)))
#define HW_MLB150_HCMR0_CLR(v)    (HW_MLB150_HCMR0_WR(HW_MLB150_HCMR0_RD() & ~(v)))
#define HW_MLB150_HCMR0_TOG(v)    (HW_MLB150_HCMR0_WR(HW_MLB150_HCMR0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_HCMR0 bitfields
 */

/*! @name Register MLB150_HCMR0, field CHM_31_0_P[31:0] (RW)
 *
 * Bitwise channel mask bit
 *
 * Values:
 * - 0 - masked
 * - 1 - unmasked
 */
//@{
#define BP_MLB150_HCMR0_CHM_31_0_P      (0)      //!< Bit position for MLB150_HCMR0_CHM_31_0_P.
#define BM_MLB150_HCMR0_CHM_31_0_P      (0xffffffff)  //!< Bit mask for MLB150_HCMR0_CHM_31_0_P.

//! @brief Get value of MLB150_HCMR0_CHM_31_0_P from a register value.
#define BG_MLB150_HCMR0_CHM_31_0_P(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCMR0_CHM_31_0_P) >> BP_MLB150_HCMR0_CHM_31_0_P)

//! @brief Format value for bitfield MLB150_HCMR0_CHM_31_0_P.
#define BF_MLB150_HCMR0_CHM_31_0_P(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_HCMR0_CHM_31_0_P) & BM_MLB150_HCMR0_CHM_31_0_P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHM_31_0_P field to a new value.
#define BW_MLB150_HCMR0_CHM_31_0_P(v)   (HW_MLB150_HCMR0_WR((HW_MLB150_HCMR0_RD() & ~BM_MLB150_HCMR0_CHM_31_0_P) | BF_MLB150_HCMR0_CHM_31_0_P(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCMR1 - HBI Channel Mask 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCMR1 - HBI Channel Mask 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_hcmr1
{
    reg32_t U;
    struct _hw_mlb150_hcmr1_bitfields
    {
        unsigned CHM_63_32 : 32; //!< [31:0] Bitwise channel mask bit
    } B;
} hw_mlb150_hcmr1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCMR1 register
 */
//@{
#define HW_MLB150_HCMR1_ADDR      (REGS_MLB150_BASE + 0x8c)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCMR1           (*(volatile hw_mlb150_hcmr1_t *) HW_MLB150_HCMR1_ADDR)
#define HW_MLB150_HCMR1_RD()      (HW_MLB150_HCMR1.U)
#define HW_MLB150_HCMR1_WR(v)     (HW_MLB150_HCMR1.U = (v))
#define HW_MLB150_HCMR1_SET(v)    (HW_MLB150_HCMR1_WR(HW_MLB150_HCMR1_RD() |  (v)))
#define HW_MLB150_HCMR1_CLR(v)    (HW_MLB150_HCMR1_WR(HW_MLB150_HCMR1_RD() & ~(v)))
#define HW_MLB150_HCMR1_TOG(v)    (HW_MLB150_HCMR1_WR(HW_MLB150_HCMR1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_HCMR1 bitfields
 */

/*! @name Register MLB150_HCMR1, field CHM_63_32[31:0] (RW)
 *
 * Bitwise channel mask bit
 *
 * Values:
 * - 0 - masked
 * - 1 - unmasked
 */
//@{
#define BP_MLB150_HCMR1_CHM_63_32      (0)      //!< Bit position for MLB150_HCMR1_CHM_63_32.
#define BM_MLB150_HCMR1_CHM_63_32      (0xffffffff)  //!< Bit mask for MLB150_HCMR1_CHM_63_32.

//! @brief Get value of MLB150_HCMR1_CHM_63_32 from a register value.
#define BG_MLB150_HCMR1_CHM_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCMR1_CHM_63_32) >> BP_MLB150_HCMR1_CHM_63_32)

//! @brief Format value for bitfield MLB150_HCMR1_CHM_63_32.
#define BF_MLB150_HCMR1_CHM_63_32(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_HCMR1_CHM_63_32) & BM_MLB150_HCMR1_CHM_63_32)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHM_63_32 field to a new value.
#define BW_MLB150_HCMR1_CHM_63_32(v)   (HW_MLB150_HCMR1_WR((HW_MLB150_HCMR1_RD() & ~BM_MLB150_HCMR1_CHM_63_32) | BF_MLB150_HCMR1_CHM_63_32(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCER0 - HBI Channel Error 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCER0 - HBI Channel Error 0 Register (RO)
 *
 * Reset value: 0x00000000
 *
 * The HBI Channel Error Registers (HCERn) indicate which channel(s) have encountered fatal errors.
 */
typedef union _hw_mlb150_hcer0
{
    reg32_t U;
    struct _hw_mlb150_hcer0_bitfields
    {
        unsigned CERR_31_0 : 32; //!< [31:0] Bitwise channel error bit
    } B;
} hw_mlb150_hcer0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCER0 register
 */
//@{
#define HW_MLB150_HCER0_ADDR      (REGS_MLB150_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCER0           (*(volatile hw_mlb150_hcer0_t *) HW_MLB150_HCER0_ADDR)
#define HW_MLB150_HCER0_RD()      (HW_MLB150_HCER0.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_HCER0 bitfields
 */

/*! @name Register MLB150_HCER0, field CERR_31_0[31:0] (RO)
 *
 * Bitwise channel error bit
 */
//@{
#define BP_MLB150_HCER0_CERR_31_0      (0)      //!< Bit position for MLB150_HCER0_CERR_31_0.
#define BM_MLB150_HCER0_CERR_31_0      (0xffffffff)  //!< Bit mask for MLB150_HCER0_CERR_31_0.

//! @brief Get value of MLB150_HCER0_CERR_31_0 from a register value.
#define BG_MLB150_HCER0_CERR_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCER0_CERR_31_0) >> BP_MLB150_HCER0_CERR_31_0)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCER1 - HBI Channel Error 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCER1 - HBI Channel Error 1 Register (RO)
 *
 * Reset value: 0x00000000
 *
 * HCERn status bits are set when hardware detects hardware errors on the given logical channel,
 * including: Channel opened, but not enabled, Channel programmed with invalid channel type, or Out-
 * of-range PML for asynchronous or control Tx channels
 */
typedef union _hw_mlb150_hcer1
{
    reg32_t U;
    struct _hw_mlb150_hcer1_bitfields
    {
        unsigned CERR_63_32 : 32; //!< [31:0] Bitwise channel error bit
    } B;
} hw_mlb150_hcer1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCER1 register
 */
//@{
#define HW_MLB150_HCER1_ADDR      (REGS_MLB150_BASE + 0x94)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCER1           (*(volatile hw_mlb150_hcer1_t *) HW_MLB150_HCER1_ADDR)
#define HW_MLB150_HCER1_RD()      (HW_MLB150_HCER1.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_HCER1 bitfields
 */

/*! @name Register MLB150_HCER1, field CERR_63_32[31:0] (RO)
 *
 * Bitwise channel error bit
 */
//@{
#define BP_MLB150_HCER1_CERR_63_32      (0)      //!< Bit position for MLB150_HCER1_CERR_63_32.
#define BM_MLB150_HCER1_CERR_63_32      (0xffffffff)  //!< Bit mask for MLB150_HCER1_CERR_63_32.

//! @brief Get value of MLB150_HCER1_CERR_63_32 from a register value.
#define BG_MLB150_HCER1_CERR_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCER1_CERR_63_32) >> BP_MLB150_HCER1_CERR_63_32)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCBR0 - HBI Channel Busy 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCBR0 - HBI Channel Busy 0 Register (RO)
 *
 * Reset value: 0x00000000
 *
 * The HC can determine which channel(s) are busy by reading the HBI Channel Busy Registers (HCBRn).
 * An HBI channel is busy if: it is currently loaded into one of the two AGUs the channel is
 * enabled, CE = 1 from the Channel Allocation Table ( ), and the DMA is active When an HBI channel
 * is busy, hardware may write back its local copy of the channel descriptor at any time. System
 * software should not write a CDT descriptor for a channel that is busy. Only two HBI channels can
 * be busy at any given time. Each bit of HCBRn is read-only.
 */
typedef union _hw_mlb150_hcbr0
{
    reg32_t U;
    struct _hw_mlb150_hcbr0_bitfields
    {
        unsigned CHB_31_0 : 32; //!< [31:0] Bitwise channel busy bit
    } B;
} hw_mlb150_hcbr0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCBR0 register
 */
//@{
#define HW_MLB150_HCBR0_ADDR      (REGS_MLB150_BASE + 0x98)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCBR0           (*(volatile hw_mlb150_hcbr0_t *) HW_MLB150_HCBR0_ADDR)
#define HW_MLB150_HCBR0_RD()      (HW_MLB150_HCBR0.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_HCBR0 bitfields
 */

/*! @name Register MLB150_HCBR0, field CHB_31_0[31:0] (RO)
 *
 * Bitwise channel busy bit
 *
 * Values:
 * - 0 - idle
 * - 1 - busy
 */
//@{
#define BP_MLB150_HCBR0_CHB_31_0      (0)      //!< Bit position for MLB150_HCBR0_CHB_31_0.
#define BM_MLB150_HCBR0_CHB_31_0      (0xffffffff)  //!< Bit mask for MLB150_HCBR0_CHB_31_0.

//! @brief Get value of MLB150_HCBR0_CHB_31_0 from a register value.
#define BG_MLB150_HCBR0_CHB_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCBR0_CHB_31_0) >> BP_MLB150_HCBR0_CHB_31_0)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_HCBR1 - HBI Channel Busy 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_HCBR1 - HBI Channel Busy 1 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_hcbr1
{
    reg32_t U;
    struct _hw_mlb150_hcbr1_bitfields
    {
        unsigned CHB_63_32 : 32; //!< [31:0] Bitwise channel busy bit
    } B;
} hw_mlb150_hcbr1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_HCBR1 register
 */
//@{
#define HW_MLB150_HCBR1_ADDR      (REGS_MLB150_BASE + 0x9c)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_HCBR1           (*(volatile hw_mlb150_hcbr1_t *) HW_MLB150_HCBR1_ADDR)
#define HW_MLB150_HCBR1_RD()      (HW_MLB150_HCBR1.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_HCBR1 bitfields
 */

/*! @name Register MLB150_HCBR1, field CHB_63_32[31:0] (RO)
 *
 * Bitwise channel busy bit
 *
 * Values:
 * - 0 - idle
 * - 1 - busy
 */
//@{
#define BP_MLB150_HCBR1_CHB_63_32      (0)      //!< Bit position for MLB150_HCBR1_CHB_63_32.
#define BM_MLB150_HCBR1_CHB_63_32      (0xffffffff)  //!< Bit mask for MLB150_HCBR1_CHB_63_32.

//! @brief Get value of MLB150_HCBR1_CHB_63_32 from a register value.
#define BG_MLB150_HCBR1_CHB_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_HCBR1_CHB_63_32) >> BP_MLB150_HCBR1_CHB_63_32)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDAT0 - MIF Data 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDAT0 - MIF Data 0 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdat0
{
    reg32_t U;
    struct _hw_mlb150_mdat0_bitfields
    {
        unsigned DATA_31_0 : 32; //!< [31:0] CTR data - bits[31:0] of 128-bit entry or
    } B;
} hw_mlb150_mdat0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDAT0 register
 */
//@{
#define HW_MLB150_MDAT0_ADDR      (REGS_MLB150_BASE + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDAT0           (*(volatile hw_mlb150_mdat0_t *) HW_MLB150_MDAT0_ADDR)
#define HW_MLB150_MDAT0_RD()      (HW_MLB150_MDAT0.U)
#define HW_MLB150_MDAT0_WR(v)     (HW_MLB150_MDAT0.U = (v))
#define HW_MLB150_MDAT0_SET(v)    (HW_MLB150_MDAT0_WR(HW_MLB150_MDAT0_RD() |  (v)))
#define HW_MLB150_MDAT0_CLR(v)    (HW_MLB150_MDAT0_WR(HW_MLB150_MDAT0_RD() & ~(v)))
#define HW_MLB150_MDAT0_TOG(v)    (HW_MLB150_MDAT0_WR(HW_MLB150_MDAT0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDAT0 bitfields
 */

/*! @name Register MLB150_MDAT0, field DATA_31_0[31:0] (RW)
 *
 * CTR data - bits[31:0] of 128-bit entry or DBR data - bits[7:0] of 8-bit entry
 */
//@{
#define BP_MLB150_MDAT0_DATA_31_0      (0)      //!< Bit position for MLB150_MDAT0_DATA_31_0.
#define BM_MLB150_MDAT0_DATA_31_0      (0xffffffff)  //!< Bit mask for MLB150_MDAT0_DATA_31_0.

//! @brief Get value of MLB150_MDAT0_DATA_31_0 from a register value.
#define BG_MLB150_MDAT0_DATA_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDAT0_DATA_31_0) >> BP_MLB150_MDAT0_DATA_31_0)

//! @brief Format value for bitfield MLB150_MDAT0_DATA_31_0.
#define BF_MLB150_MDAT0_DATA_31_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDAT0_DATA_31_0) & BM_MLB150_MDAT0_DATA_31_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_31_0 field to a new value.
#define BW_MLB150_MDAT0_DATA_31_0(v)   (HW_MLB150_MDAT0_WR((HW_MLB150_MDAT0_RD() & ~BM_MLB150_MDAT0_DATA_31_0) | BF_MLB150_MDAT0_DATA_31_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDAT1 - MIF Data 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDAT1 - MIF Data 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdat1
{
    reg32_t U;
    struct _hw_mlb150_mdat1_bitfields
    {
        unsigned DATA_63_32 : 32; //!< [31:0] CTR data - bits[63:32] of 128-bit entry
    } B;
} hw_mlb150_mdat1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDAT1 register
 */
//@{
#define HW_MLB150_MDAT1_ADDR      (REGS_MLB150_BASE + 0xc4)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDAT1           (*(volatile hw_mlb150_mdat1_t *) HW_MLB150_MDAT1_ADDR)
#define HW_MLB150_MDAT1_RD()      (HW_MLB150_MDAT1.U)
#define HW_MLB150_MDAT1_WR(v)     (HW_MLB150_MDAT1.U = (v))
#define HW_MLB150_MDAT1_SET(v)    (HW_MLB150_MDAT1_WR(HW_MLB150_MDAT1_RD() |  (v)))
#define HW_MLB150_MDAT1_CLR(v)    (HW_MLB150_MDAT1_WR(HW_MLB150_MDAT1_RD() & ~(v)))
#define HW_MLB150_MDAT1_TOG(v)    (HW_MLB150_MDAT1_WR(HW_MLB150_MDAT1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDAT1 bitfields
 */

/*! @name Register MLB150_MDAT1, field DATA_63_32[31:0] (RW)
 *
 * CTR data - bits[63:32] of 128-bit entry
 */
//@{
#define BP_MLB150_MDAT1_DATA_63_32      (0)      //!< Bit position for MLB150_MDAT1_DATA_63_32.
#define BM_MLB150_MDAT1_DATA_63_32      (0xffffffff)  //!< Bit mask for MLB150_MDAT1_DATA_63_32.

//! @brief Get value of MLB150_MDAT1_DATA_63_32 from a register value.
#define BG_MLB150_MDAT1_DATA_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDAT1_DATA_63_32) >> BP_MLB150_MDAT1_DATA_63_32)

//! @brief Format value for bitfield MLB150_MDAT1_DATA_63_32.
#define BF_MLB150_MDAT1_DATA_63_32(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDAT1_DATA_63_32) & BM_MLB150_MDAT1_DATA_63_32)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_63_32 field to a new value.
#define BW_MLB150_MDAT1_DATA_63_32(v)   (HW_MLB150_MDAT1_WR((HW_MLB150_MDAT1_RD() & ~BM_MLB150_MDAT1_DATA_63_32) | BF_MLB150_MDAT1_DATA_63_32(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDAT2 - MIF Data 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDAT2 - MIF Data 2 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdat2
{
    reg32_t U;
    struct _hw_mlb150_mdat2_bitfields
    {
        unsigned DATA_95_64 : 32; //!< [31:0] CTR data - bits[95:64] of 128-bit entry
    } B;
} hw_mlb150_mdat2_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDAT2 register
 */
//@{
#define HW_MLB150_MDAT2_ADDR      (REGS_MLB150_BASE + 0xc8)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDAT2           (*(volatile hw_mlb150_mdat2_t *) HW_MLB150_MDAT2_ADDR)
#define HW_MLB150_MDAT2_RD()      (HW_MLB150_MDAT2.U)
#define HW_MLB150_MDAT2_WR(v)     (HW_MLB150_MDAT2.U = (v))
#define HW_MLB150_MDAT2_SET(v)    (HW_MLB150_MDAT2_WR(HW_MLB150_MDAT2_RD() |  (v)))
#define HW_MLB150_MDAT2_CLR(v)    (HW_MLB150_MDAT2_WR(HW_MLB150_MDAT2_RD() & ~(v)))
#define HW_MLB150_MDAT2_TOG(v)    (HW_MLB150_MDAT2_WR(HW_MLB150_MDAT2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDAT2 bitfields
 */

/*! @name Register MLB150_MDAT2, field DATA_95_64[31:0] (RW)
 *
 * CTR data - bits[95:64] of 128-bit entry
 */
//@{
#define BP_MLB150_MDAT2_DATA_95_64      (0)      //!< Bit position for MLB150_MDAT2_DATA_95_64.
#define BM_MLB150_MDAT2_DATA_95_64      (0xffffffff)  //!< Bit mask for MLB150_MDAT2_DATA_95_64.

//! @brief Get value of MLB150_MDAT2_DATA_95_64 from a register value.
#define BG_MLB150_MDAT2_DATA_95_64(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDAT2_DATA_95_64) >> BP_MLB150_MDAT2_DATA_95_64)

//! @brief Format value for bitfield MLB150_MDAT2_DATA_95_64.
#define BF_MLB150_MDAT2_DATA_95_64(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDAT2_DATA_95_64) & BM_MLB150_MDAT2_DATA_95_64)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_95_64 field to a new value.
#define BW_MLB150_MDAT2_DATA_95_64(v)   (HW_MLB150_MDAT2_WR((HW_MLB150_MDAT2_RD() & ~BM_MLB150_MDAT2_DATA_95_64) | BF_MLB150_MDAT2_DATA_95_64(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDAT3 - MIF Data 3 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDAT3 - MIF Data 3 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdat3
{
    reg32_t U;
    struct _hw_mlb150_mdat3_bitfields
    {
        unsigned DATA_127_96 : 32; //!< [31:0] CTR data - bits[127:96] of 128-bit entry
    } B;
} hw_mlb150_mdat3_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDAT3 register
 */
//@{
#define HW_MLB150_MDAT3_ADDR      (REGS_MLB150_BASE + 0xcc)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDAT3           (*(volatile hw_mlb150_mdat3_t *) HW_MLB150_MDAT3_ADDR)
#define HW_MLB150_MDAT3_RD()      (HW_MLB150_MDAT3.U)
#define HW_MLB150_MDAT3_WR(v)     (HW_MLB150_MDAT3.U = (v))
#define HW_MLB150_MDAT3_SET(v)    (HW_MLB150_MDAT3_WR(HW_MLB150_MDAT3_RD() |  (v)))
#define HW_MLB150_MDAT3_CLR(v)    (HW_MLB150_MDAT3_WR(HW_MLB150_MDAT3_RD() & ~(v)))
#define HW_MLB150_MDAT3_TOG(v)    (HW_MLB150_MDAT3_WR(HW_MLB150_MDAT3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDAT3 bitfields
 */

/*! @name Register MLB150_MDAT3, field DATA_127_96[31:0] (RW)
 *
 * CTR data - bits[127:96] of 128-bit entry
 */
//@{
#define BP_MLB150_MDAT3_DATA_127_96      (0)      //!< Bit position for MLB150_MDAT3_DATA_127_96.
#define BM_MLB150_MDAT3_DATA_127_96      (0xffffffff)  //!< Bit mask for MLB150_MDAT3_DATA_127_96.

//! @brief Get value of MLB150_MDAT3_DATA_127_96 from a register value.
#define BG_MLB150_MDAT3_DATA_127_96(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDAT3_DATA_127_96) >> BP_MLB150_MDAT3_DATA_127_96)

//! @brief Format value for bitfield MLB150_MDAT3_DATA_127_96.
#define BF_MLB150_MDAT3_DATA_127_96(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDAT3_DATA_127_96) & BM_MLB150_MDAT3_DATA_127_96)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA_127_96 field to a new value.
#define BW_MLB150_MDAT3_DATA_127_96(v)   (HW_MLB150_MDAT3_WR((HW_MLB150_MDAT3_RD() & ~BM_MLB150_MDAT3_DATA_127_96) | BF_MLB150_MDAT3_DATA_127_96(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDWE0 - MIF Data Write Enable 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDWE0 - MIF Data Write Enable 0 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdwe0
{
    reg32_t U;
    struct _hw_mlb150_mdwe0_bitfields
    {
        unsigned MASK_31_0 : 32; //!< [31:0] Bitwise write enable for CTR data - bits[31:0]
    } B;
} hw_mlb150_mdwe0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDWE0 register
 */
//@{
#define HW_MLB150_MDWE0_ADDR      (REGS_MLB150_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDWE0           (*(volatile hw_mlb150_mdwe0_t *) HW_MLB150_MDWE0_ADDR)
#define HW_MLB150_MDWE0_RD()      (HW_MLB150_MDWE0.U)
#define HW_MLB150_MDWE0_WR(v)     (HW_MLB150_MDWE0.U = (v))
#define HW_MLB150_MDWE0_SET(v)    (HW_MLB150_MDWE0_WR(HW_MLB150_MDWE0_RD() |  (v)))
#define HW_MLB150_MDWE0_CLR(v)    (HW_MLB150_MDWE0_WR(HW_MLB150_MDWE0_RD() & ~(v)))
#define HW_MLB150_MDWE0_TOG(v)    (HW_MLB150_MDWE0_WR(HW_MLB150_MDWE0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDWE0 bitfields
 */

/*! @name Register MLB150_MDWE0, field MASK_31_0[31:0] (RW)
 *
 * Bitwise write enable for CTR data - bits[31:0]
 *
 * Values:
 * - 0 - disabled
 * - 1 - enabled
 */
//@{
#define BP_MLB150_MDWE0_MASK_31_0      (0)      //!< Bit position for MLB150_MDWE0_MASK_31_0.
#define BM_MLB150_MDWE0_MASK_31_0      (0xffffffff)  //!< Bit mask for MLB150_MDWE0_MASK_31_0.

//! @brief Get value of MLB150_MDWE0_MASK_31_0 from a register value.
#define BG_MLB150_MDWE0_MASK_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDWE0_MASK_31_0) >> BP_MLB150_MDWE0_MASK_31_0)

//! @brief Format value for bitfield MLB150_MDWE0_MASK_31_0.
#define BF_MLB150_MDWE0_MASK_31_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDWE0_MASK_31_0) & BM_MLB150_MDWE0_MASK_31_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_31_0 field to a new value.
#define BW_MLB150_MDWE0_MASK_31_0(v)   (HW_MLB150_MDWE0_WR((HW_MLB150_MDWE0_RD() & ~BM_MLB150_MDWE0_MASK_31_0) | BF_MLB150_MDWE0_MASK_31_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDWE1 - MIF Data Write Enable 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDWE1 - MIF Data Write Enable 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdwe1
{
    reg32_t U;
    struct _hw_mlb150_mdwe1_bitfields
    {
        unsigned MASK_63_32 : 32; //!< [31:0] Bitwise write enable for CTR data - bits[63:32]
    } B;
} hw_mlb150_mdwe1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDWE1 register
 */
//@{
#define HW_MLB150_MDWE1_ADDR      (REGS_MLB150_BASE + 0xd4)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDWE1           (*(volatile hw_mlb150_mdwe1_t *) HW_MLB150_MDWE1_ADDR)
#define HW_MLB150_MDWE1_RD()      (HW_MLB150_MDWE1.U)
#define HW_MLB150_MDWE1_WR(v)     (HW_MLB150_MDWE1.U = (v))
#define HW_MLB150_MDWE1_SET(v)    (HW_MLB150_MDWE1_WR(HW_MLB150_MDWE1_RD() |  (v)))
#define HW_MLB150_MDWE1_CLR(v)    (HW_MLB150_MDWE1_WR(HW_MLB150_MDWE1_RD() & ~(v)))
#define HW_MLB150_MDWE1_TOG(v)    (HW_MLB150_MDWE1_WR(HW_MLB150_MDWE1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDWE1 bitfields
 */

/*! @name Register MLB150_MDWE1, field MASK_63_32[31:0] (RW)
 *
 * Bitwise write enable for CTR data - bits[63:32]
 *
 * Values:
 * - 0 - disabled
 * - 1 - enabled
 */
//@{
#define BP_MLB150_MDWE1_MASK_63_32      (0)      //!< Bit position for MLB150_MDWE1_MASK_63_32.
#define BM_MLB150_MDWE1_MASK_63_32      (0xffffffff)  //!< Bit mask for MLB150_MDWE1_MASK_63_32.

//! @brief Get value of MLB150_MDWE1_MASK_63_32 from a register value.
#define BG_MLB150_MDWE1_MASK_63_32(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDWE1_MASK_63_32) >> BP_MLB150_MDWE1_MASK_63_32)

//! @brief Format value for bitfield MLB150_MDWE1_MASK_63_32.
#define BF_MLB150_MDWE1_MASK_63_32(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDWE1_MASK_63_32) & BM_MLB150_MDWE1_MASK_63_32)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_63_32 field to a new value.
#define BW_MLB150_MDWE1_MASK_63_32(v)   (HW_MLB150_MDWE1_WR((HW_MLB150_MDWE1_RD() & ~BM_MLB150_MDWE1_MASK_63_32) | BF_MLB150_MDWE1_MASK_63_32(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDWE2 - MIF Data Write Enable 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDWE2 - MIF Data Write Enable 2 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdwe2
{
    reg32_t U;
    struct _hw_mlb150_mdwe2_bitfields
    {
        unsigned MASK_95_64 : 32; //!< [31:0] Bitwise write enable for CTR data - bits[95:64]
    } B;
} hw_mlb150_mdwe2_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDWE2 register
 */
//@{
#define HW_MLB150_MDWE2_ADDR      (REGS_MLB150_BASE + 0xd8)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDWE2           (*(volatile hw_mlb150_mdwe2_t *) HW_MLB150_MDWE2_ADDR)
#define HW_MLB150_MDWE2_RD()      (HW_MLB150_MDWE2.U)
#define HW_MLB150_MDWE2_WR(v)     (HW_MLB150_MDWE2.U = (v))
#define HW_MLB150_MDWE2_SET(v)    (HW_MLB150_MDWE2_WR(HW_MLB150_MDWE2_RD() |  (v)))
#define HW_MLB150_MDWE2_CLR(v)    (HW_MLB150_MDWE2_WR(HW_MLB150_MDWE2_RD() & ~(v)))
#define HW_MLB150_MDWE2_TOG(v)    (HW_MLB150_MDWE2_WR(HW_MLB150_MDWE2_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDWE2 bitfields
 */

/*! @name Register MLB150_MDWE2, field MASK_95_64[31:0] (RW)
 *
 * Bitwise write enable for CTR data - bits[95:64]
 *
 * Values:
 * - 0 - disabled
 * - 1 - enabled
 */
//@{
#define BP_MLB150_MDWE2_MASK_95_64      (0)      //!< Bit position for MLB150_MDWE2_MASK_95_64.
#define BM_MLB150_MDWE2_MASK_95_64      (0xffffffff)  //!< Bit mask for MLB150_MDWE2_MASK_95_64.

//! @brief Get value of MLB150_MDWE2_MASK_95_64 from a register value.
#define BG_MLB150_MDWE2_MASK_95_64(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDWE2_MASK_95_64) >> BP_MLB150_MDWE2_MASK_95_64)

//! @brief Format value for bitfield MLB150_MDWE2_MASK_95_64.
#define BF_MLB150_MDWE2_MASK_95_64(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDWE2_MASK_95_64) & BM_MLB150_MDWE2_MASK_95_64)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_95_64 field to a new value.
#define BW_MLB150_MDWE2_MASK_95_64(v)   (HW_MLB150_MDWE2_WR((HW_MLB150_MDWE2_RD() & ~BM_MLB150_MDWE2_MASK_95_64) | BF_MLB150_MDWE2_MASK_95_64(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MDWE3 - MIF Data Write Enable 3 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MDWE3 - MIF Data Write Enable 3 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mdwe3
{
    reg32_t U;
    struct _hw_mlb150_mdwe3_bitfields
    {
        unsigned MASK_127_96 : 32; //!< [31:0] Bitwise write enable for CTR data - bits[127:96]
    } B;
} hw_mlb150_mdwe3_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MDWE3 register
 */
//@{
#define HW_MLB150_MDWE3_ADDR      (REGS_MLB150_BASE + 0xdc)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MDWE3           (*(volatile hw_mlb150_mdwe3_t *) HW_MLB150_MDWE3_ADDR)
#define HW_MLB150_MDWE3_RD()      (HW_MLB150_MDWE3.U)
#define HW_MLB150_MDWE3_WR(v)     (HW_MLB150_MDWE3.U = (v))
#define HW_MLB150_MDWE3_SET(v)    (HW_MLB150_MDWE3_WR(HW_MLB150_MDWE3_RD() |  (v)))
#define HW_MLB150_MDWE3_CLR(v)    (HW_MLB150_MDWE3_WR(HW_MLB150_MDWE3_RD() & ~(v)))
#define HW_MLB150_MDWE3_TOG(v)    (HW_MLB150_MDWE3_WR(HW_MLB150_MDWE3_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MDWE3 bitfields
 */

/*! @name Register MLB150_MDWE3, field MASK_127_96[31:0] (RW)
 *
 * Bitwise write enable for CTR data - bits[127:96]
 *
 * Values:
 * - 0 - disabled
 * - 1 - enabled
 */
//@{
#define BP_MLB150_MDWE3_MASK_127_96      (0)      //!< Bit position for MLB150_MDWE3_MASK_127_96.
#define BM_MLB150_MDWE3_MASK_127_96      (0xffffffff)  //!< Bit mask for MLB150_MDWE3_MASK_127_96.

//! @brief Get value of MLB150_MDWE3_MASK_127_96 from a register value.
#define BG_MLB150_MDWE3_MASK_127_96(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MDWE3_MASK_127_96) >> BP_MLB150_MDWE3_MASK_127_96)

//! @brief Format value for bitfield MLB150_MDWE3_MASK_127_96.
#define BF_MLB150_MDWE3_MASK_127_96(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MDWE3_MASK_127_96) & BM_MLB150_MDWE3_MASK_127_96)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MASK_127_96 field to a new value.
#define BW_MLB150_MDWE3_MASK_127_96(v)   (HW_MLB150_MDWE3_WR((HW_MLB150_MDWE3_RD() & ~BM_MLB150_MDWE3_MASK_127_96) | BF_MLB150_MDWE3_MASK_127_96(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MCTL - MIF Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MCTL - MIF Control Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_mctl
{
    reg32_t U;
    struct _hw_mlb150_mctl_bitfields
    {
        unsigned XCMP : 1; //!< [0] Transfer complete (write 0 to clear)
        unsigned RESERVED0 : 31; //!< [31:1] Reserved
    } B;
} hw_mlb150_mctl_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MCTL register
 */
//@{
#define HW_MLB150_MCTL_ADDR      (REGS_MLB150_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MCTL           (*(volatile hw_mlb150_mctl_t *) HW_MLB150_MCTL_ADDR)
#define HW_MLB150_MCTL_RD()      (HW_MLB150_MCTL.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_MCTL bitfields
 */

/*! @name Register MLB150_MCTL, field XCMP[0] (RO)
 *
 * Transfer complete (write 0 to clear)
 */
//@{
#define BP_MLB150_MCTL_XCMP      (0)      //!< Bit position for MLB150_MCTL_XCMP.
#define BM_MLB150_MCTL_XCMP      (0x00000001)  //!< Bit mask for MLB150_MCTL_XCMP.

//! @brief Get value of MLB150_MCTL_XCMP from a register value.
#define BG_MLB150_MCTL_XCMP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MCTL_XCMP) >> BP_MLB150_MCTL_XCMP)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_MADR - MIF Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_MADR - MIF Address Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_madr
{
    reg32_t U;
    struct _hw_mlb150_madr_bitfields
    {
        unsigned ADDR_7_0 : 8; //!< [7:0] CTR address of 128-bit entry or
        unsigned ADDR_13_8 : 6; //!< [13:8] DBR address of 8-bit entry - bits[13:8]
        unsigned RESERVED0 : 16; //!< [29:14] Reserved
        unsigned TB : 1; //!< [30] Target location bit
        unsigned WNR : 1; //!< [31] Write-Not-Read selection
    } B;
} hw_mlb150_madr_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_MADR register
 */
//@{
#define HW_MLB150_MADR_ADDR      (REGS_MLB150_BASE + 0xe4)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_MADR           (*(volatile hw_mlb150_madr_t *) HW_MLB150_MADR_ADDR)
#define HW_MLB150_MADR_RD()      (HW_MLB150_MADR.U)
#define HW_MLB150_MADR_WR(v)     (HW_MLB150_MADR.U = (v))
#define HW_MLB150_MADR_SET(v)    (HW_MLB150_MADR_WR(HW_MLB150_MADR_RD() |  (v)))
#define HW_MLB150_MADR_CLR(v)    (HW_MLB150_MADR_WR(HW_MLB150_MADR_RD() & ~(v)))
#define HW_MLB150_MADR_TOG(v)    (HW_MLB150_MADR_WR(HW_MLB150_MADR_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_MADR bitfields
 */

/*! @name Register MLB150_MADR, field ADDR_7_0[7:0] (RW)
 *
 * CTR address of 128-bit entry or DBR address of 8-bit entry - bits[7:0]
 */
//@{
#define BP_MLB150_MADR_ADDR_7_0      (0)      //!< Bit position for MLB150_MADR_ADDR_7_0.
#define BM_MLB150_MADR_ADDR_7_0      (0x000000ff)  //!< Bit mask for MLB150_MADR_ADDR_7_0.

//! @brief Get value of MLB150_MADR_ADDR_7_0 from a register value.
#define BG_MLB150_MADR_ADDR_7_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MADR_ADDR_7_0) >> BP_MLB150_MADR_ADDR_7_0)

//! @brief Format value for bitfield MLB150_MADR_ADDR_7_0.
#define BF_MLB150_MADR_ADDR_7_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MADR_ADDR_7_0) & BM_MLB150_MADR_ADDR_7_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDR_7_0 field to a new value.
#define BW_MLB150_MADR_ADDR_7_0(v)   (HW_MLB150_MADR_WR((HW_MLB150_MADR_RD() & ~BM_MLB150_MADR_ADDR_7_0) | BF_MLB150_MADR_ADDR_7_0(v)))
#endif
//@}

/*! @name Register MLB150_MADR, field ADDR_13_8[13:8] (RW)
 *
 * DBR address of 8-bit entry - bits[13:8]
 */
//@{
#define BP_MLB150_MADR_ADDR_13_8      (8)      //!< Bit position for MLB150_MADR_ADDR_13_8.
#define BM_MLB150_MADR_ADDR_13_8      (0x00003f00)  //!< Bit mask for MLB150_MADR_ADDR_13_8.

//! @brief Get value of MLB150_MADR_ADDR_13_8 from a register value.
#define BG_MLB150_MADR_ADDR_13_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MADR_ADDR_13_8) >> BP_MLB150_MADR_ADDR_13_8)

//! @brief Format value for bitfield MLB150_MADR_ADDR_13_8.
#define BF_MLB150_MADR_ADDR_13_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MADR_ADDR_13_8) & BM_MLB150_MADR_ADDR_13_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDR_13_8 field to a new value.
#define BW_MLB150_MADR_ADDR_13_8(v)   (HW_MLB150_MADR_WR((HW_MLB150_MADR_RD() & ~BM_MLB150_MADR_ADDR_13_8) | BF_MLB150_MADR_ADDR_13_8(v)))
#endif
//@}

/*! @name Register MLB150_MADR, field TB[30] (RW)
 *
 * Target location bit
 *
 * Values:
 * - 0 - selects CTR
 * - 1 - selects DBR
 */
//@{
#define BP_MLB150_MADR_TB      (30)      //!< Bit position for MLB150_MADR_TB.
#define BM_MLB150_MADR_TB      (0x40000000)  //!< Bit mask for MLB150_MADR_TB.

//! @brief Get value of MLB150_MADR_TB from a register value.
#define BG_MLB150_MADR_TB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MADR_TB) >> BP_MLB150_MADR_TB)

//! @brief Format value for bitfield MLB150_MADR_TB.
#define BF_MLB150_MADR_TB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MADR_TB) & BM_MLB150_MADR_TB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TB field to a new value.
#define BW_MLB150_MADR_TB(v)   (HW_MLB150_MADR_WR((HW_MLB150_MADR_RD() & ~BM_MLB150_MADR_TB) | BF_MLB150_MADR_TB(v)))
#endif
//@}

/*! @name Register MLB150_MADR, field WNR[31] (RW)
 *
 * Write-Not-Read selection
 *
 * Values:
 * - 0 - read
 * - 1 - write
 */
//@{
#define BP_MLB150_MADR_WNR      (31)      //!< Bit position for MLB150_MADR_WNR.
#define BM_MLB150_MADR_WNR      (0x80000000)  //!< Bit mask for MLB150_MADR_WNR.

//! @brief Get value of MLB150_MADR_WNR from a register value.
#define BG_MLB150_MADR_WNR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_MADR_WNR) >> BP_MLB150_MADR_WNR)

//! @brief Format value for bitfield MLB150_MADR_WNR.
#define BF_MLB150_MADR_WNR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_MADR_WNR) & BM_MLB150_MADR_WNR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WNR field to a new value.
#define BW_MLB150_MADR_WNR(v)   (HW_MLB150_MADR_WR((HW_MLB150_MADR_RD() & ~BM_MLB150_MADR_WNR) | BF_MLB150_MADR_WNR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_ACTL - AHB Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_ACTL - AHB Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The AHB Control (ACTL) register is written by the HC to configure the AMBA AHB block for channel
 * interrupts. ACTL contains three configuration fields, one is used to select the DMA mode, one is
 * used to mux channel interrupts onto a single interrupt signal, and the last selects the method of
 * clearing channel interrupts (either software or hardware).
 */
typedef union _hw_mlb150_actl
{
    reg32_t U;
    struct _hw_mlb150_actl_bitfields
    {
        unsigned SCE : 1; //!< [0] Software clear enable:
        unsigned SMX : 1; //!< [1] AHB interrupt mux enable:
        unsigned DMA_MODE : 1; //!< [2] DMA Mode:
        unsigned RESERVED0 : 1; //!< [3] Reserved.
        unsigned MPB : 1; //!< [4] DMA Packet buffering mode.
        unsigned RESERVED1 : 27; //!< [31:5] Reserved
    } B;
} hw_mlb150_actl_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_ACTL register
 */
//@{
#define HW_MLB150_ACTL_ADDR      (REGS_MLB150_BASE + 0x3c0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_ACTL           (*(volatile hw_mlb150_actl_t *) HW_MLB150_ACTL_ADDR)
#define HW_MLB150_ACTL_RD()      (HW_MLB150_ACTL.U)
#define HW_MLB150_ACTL_WR(v)     (HW_MLB150_ACTL.U = (v))
#define HW_MLB150_ACTL_SET(v)    (HW_MLB150_ACTL_WR(HW_MLB150_ACTL_RD() |  (v)))
#define HW_MLB150_ACTL_CLR(v)    (HW_MLB150_ACTL_WR(HW_MLB150_ACTL_RD() & ~(v)))
#define HW_MLB150_ACTL_TOG(v)    (HW_MLB150_ACTL_WR(HW_MLB150_ACTL_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_ACTL bitfields
 */

/*! @name Register MLB150_ACTL, field SCE[0] (RW)
 *
 * Software clear enable:
 *
 * Values:
 * - 0 - Hardware clears interrupt after a ACSRn register read
 * - 1 - Software clears interrupt
 */
//@{
#define BP_MLB150_ACTL_SCE      (0)      //!< Bit position for MLB150_ACTL_SCE.
#define BM_MLB150_ACTL_SCE      (0x00000001)  //!< Bit mask for MLB150_ACTL_SCE.

//! @brief Get value of MLB150_ACTL_SCE from a register value.
#define BG_MLB150_ACTL_SCE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACTL_SCE) >> BP_MLB150_ACTL_SCE)

//! @brief Format value for bitfield MLB150_ACTL_SCE.
#define BF_MLB150_ACTL_SCE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACTL_SCE) & BM_MLB150_ACTL_SCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SCE field to a new value.
#define BW_MLB150_ACTL_SCE(v)   (HW_MLB150_ACTL_WR((HW_MLB150_ACTL_RD() & ~BM_MLB150_ACTL_SCE) | BF_MLB150_ACTL_SCE(v)))
#endif
//@}

/*! @name Register MLB150_ACTL, field SMX[1] (RW)
 *
 * AHB interrupt mux enable:
 *
 * Values:
 * - 0 - ACSR0 generates an interrupt on ahb_int[0] ; ACSR1 generates an interrupt on ahb_int[1]
 * - 1 - ACSR0 and ACSR1 generate an interrupts on ahb_int[0] only
 */
//@{
#define BP_MLB150_ACTL_SMX      (1)      //!< Bit position for MLB150_ACTL_SMX.
#define BM_MLB150_ACTL_SMX      (0x00000002)  //!< Bit mask for MLB150_ACTL_SMX.

//! @brief Get value of MLB150_ACTL_SMX from a register value.
#define BG_MLB150_ACTL_SMX(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACTL_SMX) >> BP_MLB150_ACTL_SMX)

//! @brief Format value for bitfield MLB150_ACTL_SMX.
#define BF_MLB150_ACTL_SMX(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACTL_SMX) & BM_MLB150_ACTL_SMX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMX field to a new value.
#define BW_MLB150_ACTL_SMX(v)   (HW_MLB150_ACTL_WR((HW_MLB150_ACTL_RD() & ~BM_MLB150_ACTL_SMX) | BF_MLB150_ACTL_SMX(v)))
#endif
//@}

/*! @name Register MLB150_ACTL, field DMA_MODE[2] (RW)
 *
 * DMA Mode:
 *
 * Values:
 * - 0 - DMA Mode 0
 * - 1 - DMA Mode 1
 */
//@{
#define BP_MLB150_ACTL_DMA_MODE      (2)      //!< Bit position for MLB150_ACTL_DMA_MODE.
#define BM_MLB150_ACTL_DMA_MODE      (0x00000004)  //!< Bit mask for MLB150_ACTL_DMA_MODE.

//! @brief Get value of MLB150_ACTL_DMA_MODE from a register value.
#define BG_MLB150_ACTL_DMA_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACTL_DMA_MODE) >> BP_MLB150_ACTL_DMA_MODE)

//! @brief Format value for bitfield MLB150_ACTL_DMA_MODE.
#define BF_MLB150_ACTL_DMA_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACTL_DMA_MODE) & BM_MLB150_ACTL_DMA_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_MODE field to a new value.
#define BW_MLB150_ACTL_DMA_MODE(v)   (HW_MLB150_ACTL_WR((HW_MLB150_ACTL_RD() & ~BM_MLB150_ACTL_DMA_MODE) | BF_MLB150_ACTL_DMA_MODE(v)))
#endif
//@}

/*! @name Register MLB150_ACTL, field MPB[4] (RW)
 *
 * DMA Packet buffering mode.
 *
 * Values:
 * - 0 - Single-packet mode
 * - 1 - Multiple-packet mode
 */
//@{
#define BP_MLB150_ACTL_MPB      (4)      //!< Bit position for MLB150_ACTL_MPB.
#define BM_MLB150_ACTL_MPB      (0x00000010)  //!< Bit mask for MLB150_ACTL_MPB.

//! @brief Get value of MLB150_ACTL_MPB from a register value.
#define BG_MLB150_ACTL_MPB(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACTL_MPB) >> BP_MLB150_ACTL_MPB)

//! @brief Format value for bitfield MLB150_ACTL_MPB.
#define BF_MLB150_ACTL_MPB(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACTL_MPB) & BM_MLB150_ACTL_MPB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPB field to a new value.
#define BW_MLB150_ACTL_MPB(v)   (HW_MLB150_ACTL_WR((HW_MLB150_ACTL_RD() & ~BM_MLB150_ACTL_MPB) | BF_MLB150_ACTL_MPB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_ACSR0 - AHB Channel Status 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_ACSR0 - AHB Channel Status 0 Register (RO)
 *
 * Reset value: 0x00000000
 *
 * The AHB Channel Status (ACSRn) registers contain interrupt bits for each of the 64 physical
 * channels. When an ACSRn register bit is set, it indicates that the corresponding physical channel
 * has an interrupt pending. An AHB interrupt is triggered when either DNEn or ERRn is set within
 * the AHB Channel Descriptor. The HC is notified of the channel interrupt via ahb_int[1:0] . When
 * an interrupt occurs in ACSR0 (for channels 31 to 0) ahb_int[0] is set. When an interrupt occurs
 * in ACSR1 (for channels 63 to 32) ahb_int[1] is set. Interrupts in ACSR0 and ACSR1 can be
 * optionally muxed onto a single interrupt signal, ahb_int[0] , if ACTL.SMX = 1. If ACTL.SCE = 0,
 * hardware automatically clears the interrupt bit(s) after the HC reads the ACSRn register.
 * Alternatively, if ACTL.SCE = 1, software must write a 1 to the appropriate bit(s) of ACSRn to
 * clear the interrupt(s).
 */
typedef union _hw_mlb150_acsr0
{
    reg32_t U;
    struct _hw_mlb150_acsr0_bitfields
    {
        unsigned CHS : 32; //!< [31:0] Interrupt status for logical channels 31 to 0:
    } B;
} hw_mlb150_acsr0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_ACSR0 register
 */
//@{
#define HW_MLB150_ACSR0_ADDR      (REGS_MLB150_BASE + 0x3d0)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_ACSR0           (*(volatile hw_mlb150_acsr0_t *) HW_MLB150_ACSR0_ADDR)
#define HW_MLB150_ACSR0_RD()      (HW_MLB150_ACSR0.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_ACSR0 bitfields
 */

/*! @name Register MLB150_ACSR0, field CHS[31:0] (RO)
 *
 * Interrupt status for logical channels 31 to 0:
 *
 * Values:
 * - 0 - None
 * - 1 - Interrupt
 */
//@{
#define BP_MLB150_ACSR0_CHS      (0)      //!< Bit position for MLB150_ACSR0_CHS.
#define BM_MLB150_ACSR0_CHS      (0xffffffff)  //!< Bit mask for MLB150_ACSR0_CHS.

//! @brief Get value of MLB150_ACSR0_CHS from a register value.
#define BG_MLB150_ACSR0_CHS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACSR0_CHS) >> BP_MLB150_ACSR0_CHS)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_ACSR1 - AHB Channel Status 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_ACSR1 - AHB Channel Status 1 Register (RO)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_acsr1
{
    reg32_t U;
    struct _hw_mlb150_acsr1_bitfields
    {
        unsigned CHS : 32; //!< [31:0] Interrupt status for logical channels 63 to 32:
    } B;
} hw_mlb150_acsr1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_ACSR1 register
 */
//@{
#define HW_MLB150_ACSR1_ADDR      (REGS_MLB150_BASE + 0x3d4)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_ACSR1           (*(volatile hw_mlb150_acsr1_t *) HW_MLB150_ACSR1_ADDR)
#define HW_MLB150_ACSR1_RD()      (HW_MLB150_ACSR1.U)
#endif
//@}

/*
 * constants & macros for individual MLB150_ACSR1 bitfields
 */

/*! @name Register MLB150_ACSR1, field CHS[31:0] (RO)
 *
 * Interrupt status for logical channels 63 to 32:
 *
 * Values:
 * - 0 - None
 * - 1 - Interrupt
 */
//@{
#define BP_MLB150_ACSR1_CHS      (0)      //!< Bit position for MLB150_ACSR1_CHS.
#define BM_MLB150_ACSR1_CHS      (0xffffffff)  //!< Bit mask for MLB150_ACSR1_CHS.

//! @brief Get value of MLB150_ACSR1_CHS from a register value.
#define BG_MLB150_ACSR1_CHS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACSR1_CHS) >> BP_MLB150_ACSR1_CHS)
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_ACMR0 - AHB Channel Mask 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_ACMR0 - AHB Channel Mask 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * Using the AHB Channel Mask (ACMRn) register, the HC can control which channel(s) generate
 * interrupts on ahb_int[1:0] . All ACMRn register bits default as '0' ("masked"); therefore, the HC
 * must initially write ACMRn to enable interrupts. Each bit of ACMRn is read/write accessible.
 */
typedef union _hw_mlb150_acmr0
{
    reg32_t U;
    struct _hw_mlb150_acmr0_bitfields
    {
        unsigned CHM_31_0 : 32; //!< [31:0] Bitwise channel mask bit:
    } B;
} hw_mlb150_acmr0_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_ACMR0 register
 */
//@{
#define HW_MLB150_ACMR0_ADDR      (REGS_MLB150_BASE + 0x3d8)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_ACMR0           (*(volatile hw_mlb150_acmr0_t *) HW_MLB150_ACMR0_ADDR)
#define HW_MLB150_ACMR0_RD()      (HW_MLB150_ACMR0.U)
#define HW_MLB150_ACMR0_WR(v)     (HW_MLB150_ACMR0.U = (v))
#define HW_MLB150_ACMR0_SET(v)    (HW_MLB150_ACMR0_WR(HW_MLB150_ACMR0_RD() |  (v)))
#define HW_MLB150_ACMR0_CLR(v)    (HW_MLB150_ACMR0_WR(HW_MLB150_ACMR0_RD() & ~(v)))
#define HW_MLB150_ACMR0_TOG(v)    (HW_MLB150_ACMR0_WR(HW_MLB150_ACMR0_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_ACMR0 bitfields
 */

/*! @name Register MLB150_ACMR0, field CHM_31_0[31:0] (RW)
 *
 * Bitwise channel mask bit:
 *
 * Values:
 * - 0 - Masked
 * - 1 - Unmasked
 */
//@{
#define BP_MLB150_ACMR0_CHM_31_0      (0)      //!< Bit position for MLB150_ACMR0_CHM_31_0.
#define BM_MLB150_ACMR0_CHM_31_0      (0xffffffff)  //!< Bit mask for MLB150_ACMR0_CHM_31_0.

//! @brief Get value of MLB150_ACMR0_CHM_31_0 from a register value.
#define BG_MLB150_ACMR0_CHM_31_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACMR0_CHM_31_0) >> BP_MLB150_ACMR0_CHM_31_0)

//! @brief Format value for bitfield MLB150_ACMR0_CHM_31_0.
#define BF_MLB150_ACMR0_CHM_31_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACMR0_CHM_31_0) & BM_MLB150_ACMR0_CHM_31_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHM_31_0 field to a new value.
#define BW_MLB150_ACMR0_CHM_31_0(v)   (HW_MLB150_ACMR0_WR((HW_MLB150_ACMR0_RD() & ~BM_MLB150_ACMR0_CHM_31_0) | BF_MLB150_ACMR0_CHM_31_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MLB150_ACMR1 - AHB Channel Mask 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MLB150_ACMR1 - AHB Channel Mask 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_mlb150_acmr1
{
    reg32_t U;
    struct _hw_mlb150_acmr1_bitfields
    {
        unsigned CHM : 32; //!< [31:0] Bitwise channel mask bit:
    } B;
} hw_mlb150_acmr1_t;
#endif

/*!
 * @name Constants and macros for entire MLB150_ACMR1 register
 */
//@{
#define HW_MLB150_ACMR1_ADDR      (REGS_MLB150_BASE + 0x3dc)

#ifndef __LANGUAGE_ASM__
#define HW_MLB150_ACMR1           (*(volatile hw_mlb150_acmr1_t *) HW_MLB150_ACMR1_ADDR)
#define HW_MLB150_ACMR1_RD()      (HW_MLB150_ACMR1.U)
#define HW_MLB150_ACMR1_WR(v)     (HW_MLB150_ACMR1.U = (v))
#define HW_MLB150_ACMR1_SET(v)    (HW_MLB150_ACMR1_WR(HW_MLB150_ACMR1_RD() |  (v)))
#define HW_MLB150_ACMR1_CLR(v)    (HW_MLB150_ACMR1_WR(HW_MLB150_ACMR1_RD() & ~(v)))
#define HW_MLB150_ACMR1_TOG(v)    (HW_MLB150_ACMR1_WR(HW_MLB150_ACMR1_RD() ^  (v)))
#endif
//@}

/*
 * constants & macros for individual MLB150_ACMR1 bitfields
 */

/*! @name Register MLB150_ACMR1, field CHM[31:0] (RW)
 *
 * Bitwise channel mask bit:
 *
 * Values:
 * - 0 - Masked
 * - 1 - Unmasked
 */
//@{
#define BP_MLB150_ACMR1_CHM      (0)      //!< Bit position for MLB150_ACMR1_CHM.
#define BM_MLB150_ACMR1_CHM      (0xffffffff)  //!< Bit mask for MLB150_ACMR1_CHM.

//! @brief Get value of MLB150_ACMR1_CHM from a register value.
#define BG_MLB150_ACMR1_CHM(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_MLB150_ACMR1_CHM) >> BP_MLB150_ACMR1_CHM)

//! @brief Format value for bitfield MLB150_ACMR1_CHM.
#define BF_MLB150_ACMR1_CHM(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_MLB150_ACMR1_CHM) & BM_MLB150_ACMR1_CHM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CHM field to a new value.
#define BW_MLB150_ACMR1_CHM(v)   (HW_MLB150_ACMR1_WR((HW_MLB150_ACMR1_RD() & ~BM_MLB150_ACMR1_CHM) | BF_MLB150_ACMR1_CHM(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_mlb150_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All MLB150 module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_mlb150
{
    volatile hw_mlb150_mlbc0_t MLBC0; //!< MediaLB Control 0 Register
    reg32_t _reserved0;
    volatile hw_mlb150_mlbpc0_t MLBPC0; //!< MediaLB 6-pin Control 0 Register
    volatile hw_mlb150_ms0_t MS0; //!< MediaLB Channel Status 0 Register
    volatile hw_mlb150_mlbpc2_t MLBPC2; //!< MediaLB 6-pin Control 2 Register
    volatile hw_mlb150_ms1_t MS1; //!< MediaLB Channel Status1 Register
    reg32_t _reserved1[2];
    volatile hw_mlb150_mss_t MSS; //!< MediaLB System Status Register
    volatile hw_mlb150_msd_t MSD; //!< MediaLB System Data Register
    reg32_t _reserved2;
    volatile hw_mlb150_mien_t MIEN; //!< MediaLB Interrupt Enable Register
    reg32_t _reserved3[2];
    volatile hw_mlb150_mlbpc1_t MLBPC1; //!< MediaLB 6-pin Control 1 Register
    volatile hw_mlb150_mlbc1_t MLBC1; //!< MediaLB Control 1 Register
    reg32_t _reserved4[16];
    volatile hw_mlb150_hctl_t HCTL; //!< HBI Control Register
    reg32_t _reserved5;
    volatile hw_mlb150_hcmr0_t HCMR0; //!< HBI Channel Mask 0 Register
    volatile hw_mlb150_hcmr1_t HCMR1; //!< HBI Channel Mask 1 Register
    volatile hw_mlb150_hcer0_t HCER0; //!< HBI Channel Error 0 Register
    volatile hw_mlb150_hcer1_t HCER1; //!< HBI Channel Error 1 Register
    volatile hw_mlb150_hcbr0_t HCBR0; //!< HBI Channel Busy 0 Register
    volatile hw_mlb150_hcbr1_t HCBR1; //!< HBI Channel Busy 1 Register
    reg32_t _reserved6[8];
    volatile hw_mlb150_mdat0_t MDAT0; //!< MIF Data 0 Register
    volatile hw_mlb150_mdat1_t MDAT1; //!< MIF Data 1 Register
    volatile hw_mlb150_mdat2_t MDAT2; //!< MIF Data 2 Register
    volatile hw_mlb150_mdat3_t MDAT3; //!< MIF Data 3 Register
    volatile hw_mlb150_mdwe0_t MDWE0; //!< MIF Data Write Enable 0 Register
    volatile hw_mlb150_mdwe1_t MDWE1; //!< MIF Data Write Enable 1 Register
    volatile hw_mlb150_mdwe2_t MDWE2; //!< MIF Data Write Enable 2 Register
    volatile hw_mlb150_mdwe3_t MDWE3; //!< MIF Data Write Enable 3 Register
    volatile hw_mlb150_mctl_t MCTL; //!< MIF Control Register
    volatile hw_mlb150_madr_t MADR; //!< MIF Address Register
    reg32_t _reserved7[182];
    volatile hw_mlb150_actl_t ACTL; //!< AHB Control Register
    reg32_t _reserved8[3];
    volatile hw_mlb150_acsr0_t ACSR0; //!< AHB Channel Status 0 Register
    volatile hw_mlb150_acsr1_t ACSR1; //!< AHB Channel Status 1 Register
    volatile hw_mlb150_acmr0_t ACMR0; //!< AHB Channel Mask 0 Register
    volatile hw_mlb150_acmr1_t ACMR1; //!< AHB Channel Mask 1 Register
} hw_mlb150_t;
#pragma pack()

//! @brief Macro to access all MLB150 registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_MLB150</code>.
#define HW_MLB150     (*(hw_mlb150_t *) REGS_MLB150_BASE)
#endif

#endif // __HW_MLB150_REGISTERS_H__
// v18/121106/1.2.2
// EOF
