/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_IPU_REGISTERS_H__
#define __HW_IPU_REGISTERS_H__

#include "regs.h"

/*
 * i.MX6DQ IPU
 *
 * IPU Registers
 *
 * Registers defined in this header file:
 * - HW_IPU_CONF - Configuration Register
 * - HW_IPU_SISG_CTRL0 - SISG Control 0 Register
 * - HW_IPU_SISG_CTRL1 - SISG Control 1 Register
 * - HW_IPU_SISG_SET_I - SISG Set<i> Register
 * - HW_IPU_SISG_CLR_I - SISG Clear <i> Register
 * - HW_IPU_INT_CTRL_1 - Interrupt Control Register 1
 * - HW_IPU_INT_CTRL_2 - Interrupt Control Register 2
 * - HW_IPU_INT_CTRL_3 - Interrupt Control Register 3
 * - HW_IPU_INT_CTRL_4 - Interrupt Control Register 4
 * - HW_IPU_INT_CTRL_5 - Interrupt Control Register 5
 * - HW_IPU_INT_CTRL_6 - Interrupt Control Register 6
 * - HW_IPU_INT_CTRL_7 - Interrupt Control Register 7
 * - HW_IPU_INT_CTRL_8 - Interrupt Control Register 8
 * - HW_IPU_INT_CTRL_9 - Interrupt Control Register 9
 * - HW_IPU_INT_CTRL_10 - Interrupt Control Register 10
 * - HW_IPU_INT_CTRL_11 - Interrupt Control Register 11
 * - HW_IPU_INT_CTRL_12 - Interrupt Control Register 12
 * - HW_IPU_INT_CTRL_13 - Interrupt Control Register 13
 * - HW_IPU_INT_CTRL_14 - Interrupt Control Register 14
 * - HW_IPU_INT_CTRL_15 - Interrupt Control Register15
 * - HW_IPU_SDMA_EVENT_1 - SDMA Event Control Register 1
 * - HW_IPU_SDMA_EVENT_2 - SDMA Event Control Register 2
 * - HW_IPU_SDMA_EVENT_3 - SDMA Event Control Register 3
 * - HW_IPU_SDMA_EVENT_4 - SDMA Event Control Register 4
 * - HW_IPU_SDMA_EVENT_7 - SDMA Event Control Register 7
 * - HW_IPU_SDMA_EVENT_8 - SDMA Event Control Register 8
 * - HW_IPU_SDMA_EVENT_11 - SDMA Event Control Register 11
 * - HW_IPU_SDMA_EVENT_12 - SDMA Event Control Register 12
 * - HW_IPU_SDMA_EVENT_13 - SDMA Event Control Register 13
 * - HW_IPU_SDMA_EVENT_14 - SDMA Event Control Register 14
 * - HW_IPU_SRM_PRI1 - Shadow Registers Memory Priority 1 Register
 * - HW_IPU_SRM_PRI2 - Shadow Registers Memory Priority 2 Register
 * - HW_IPU_FS_PROC_FLOW1 - FSU Processing Flow 1 Register
 * - HW_IPU_FS_PROC_FLOW2 - FSU Processing Flow 2 Register
 * - HW_IPU_FS_PROC_FLOW3 - FSU Processing Flow 3 Register
 * - HW_IPU_FS_DISP_FLOW1 - FSU Displaying Flow 1 Register
 * - HW_IPU_FS_DISP_FLOW2 - FSU Displaying Flow 2 Register
 * - HW_IPU_SKIP - SKIP Register
 * - HW_IPU_DISP_ALT_CONF - Display Alternate Configuration Register
 * - HW_IPU_DISP_GEN - Display General Control Register
 * - HW_IPU_DISP_ALT1 - Display Alternate Flow Control Register 1
 * - HW_IPU_DISP_ALT2 - Display Alternate Flow Control Register 2
 * - HW_IPU_DISP_ALT3 - Display Alternate Flow Control Register 3
 * - HW_IPU_DISP_ALT4 - Display Alternate Flow Control Register 4
 * - HW_IPU_MEM_RST - Memory Reset Control Register
 * - HW_IPU_PM - Power Modes Control Register
 * - HW_IPU_GPR - General Purpose Register
 * - HW_IPU_CH_DB_MODE_SEL1 - Channel Double Buffer Mode Select 1 Register
 * - HW_IPU_ALT_CH_DB_MODE_SEL0 - Alternate Channel Double Buffer Mode Select 0 Register
 * - HW_IPU_ALT_CH_DB_MODE_SEL1 - Alternate Channel Double Buffer Mode Select1 Register
 * - HW_IPU_ALT_CH_TRB_MODE_SEL0 - Alternate Channel Triple Buffer Mode Select 0 Register
 * - HW_IPU_ALT_CH_TRB_MODE_SEL1 - Alternate Channel Triple Buffer Mode Select 1 Register
 * - HW_IPU_INT_STAT_1 - Interrupt Status Register 1
 * - HW_IPU_INT_STAT_2 - Interrupt Status Register2
 * - HW_IPU_INT_STAT_3 - Interrupt Status Register 3
 * - HW_IPU_INT_STAT_4 - Interrupt Status Register 4
 * - HW_IPU_INT_STAT_5 - Interrupt Status Register 5
 * - HW_IPU_INT_STAT_6 - Interrupt Status Register 6
 * - HW_IPU_INT_STAT_7 - Interrupt Status Register7 1
 * - HW_IPU_INT_STAT_8 - Interrupt Status Register 8
 * - HW_IPU_INT_STAT_9 - Interrupt Status Register 9
 * - HW_IPU_INT_STAT_10 - Interrupt Status Register 10
 * - HW_IPU_INT_STAT_11 - Interrupt Status Register 11
 * - HW_IPU_INT_STAT_12 - Interrupt Status Register 12
 * - HW_IPU_INT_STAT_13 - Interrupt Status Register 13
 * - HW_IPU_INT_STAT_14 - Interrupt Status Register 14
 * - HW_IPU_INT_STAT_15 - Interrupt Status Register 15
 * - HW_IPU_CUR_BUF_0 - Current Buffer Register 0
 * - HW_IPU_CUR_BUF_1 - Current Buffer Register 1
 * - HW_IPU_ALT_CUR_0 - Alternate Current Buffer Register 0
 * - HW_IPU_ALT_CUR_1 - Alternate Current Buffer Register 1
 * - HW_IPU_SRM_STAT - Shadow Registers Memory Status Register
 * - HW_IPU_PROC_TASKS_STAT - Processing Status Tasks Register
 * - HW_IPU_DISP_TASKS_STAT - Display Tasks Status Register
 * - HW_IPU_TRIPLE_CUR_BUF_0 - Triple Current Buffer Register 0
 * - HW_IPU_TRIPLE_CUR_BUF_1 - Triple Current Buffer Register 1
 * - HW_IPU_TRIPLE_CUR_BUF_2 - Triple Current Buffer Register 2
 * - HW_IPU_TRIPLE_CUR_BUF_3 - Triple Current Buffer Register 3
 * - HW_IPU_CH_BUF0_RDY0 - IPU Channels Buffer 0 Ready 0 Register
 * - HW_IPU_CH_BUF0_RDY1 - IPU Channels Buffer 0 Ready 1 Register
 * - HW_IPU_CH_BUF1_RDY0 - IPU Channels Buffer 1 Ready 0 Register
 * - HW_IPU_CH_BUF1_RDY1 - IPU Channels Buffer 1 Ready 1Register
 * - HW_IPU_ALT_CH_BUF0_RDY0 - IPU Alternate Channels Buffer 0 Ready 0 Register
 * - HW_IPU_ALT_CH_BUF0_RDY1 - IPU Alternate Channels Buffer 0 Ready 1 Register
 * - HW_IPU_ALT_CH_BUF1_RDY0 - IPU Alternate Channels Buffer1 Ready 0 Register
 * - HW_IPU_ALT_CH_BUF1_RDY1 - IPU Alternate Channels Buffer 1 Ready 1 Register
 * - HW_IPU_CH_BUF2_RDY0 - IPU Channels Buffer 2 Ready 0 Register
 * - HW_IPU_CH_BUF2_RDY1 - IPU Channels Buffer 2 Ready 1 Register
 * - HW_IPU_IDMAC_CONF - IDMAC Configuration Register
 * - HW_IPU_IDMAC_CH_EN_1 - IDMAC Channel Enable 1 Register
 * - HW_IPU_IDMAC_CH_EN_2 - IDMAC Channel Enable 2 Register
 * - HW_IPU_IDMAC_ALT_SEP_ALPHA - IDMAC Alternate Separate Alpha Indication Register
 * - HW_IPU_IDMAC_CH_PRI_1 - IDMAC Channel Priority 1 Register
 * - HW_IPU_IDMAC_CH_PRI_2 - IDMAC Channel Priority 2 Register
 * - HW_IPU_IDMAC_WM_EN_2 - IDMAC Channel Watermark Enable 2 Register
 * - HW_IPU_IDMAC_LOCK_EN_1 - IDMAC Channel Lock Enable 1Register
 * - HW_IPU_IDMAC_LOCK_EN_2 - IDMAC Channel Lock Enable 2Register
 * - HW_IPU_IDMAC_SUB_ADDR_1 - IDMAC Channel Alternate Address 1 Register
 * - HW_IPU_IDMAC_SUB_ADDR_2 - IDMAC Channel Alternate Address 2 Register
 * - HW_IPU_IDMAC_SUB_ADDR_3 - IDMAC Channel Alternate Address 3 Register
 * - HW_IPU_IDMAC_BNDM_EN_1 - IDMAC Band Mode Enable 1 Register
 * - HW_IPU_IDMAC_BNDM_EN_2 - IDMAC Band Mode Enable 2 Register
 * - HW_IPU_IDMAC_SC_CORD - IDMAC Scroll Coordinations Register
 * - HW_IPU_IDMAC_CH_BUSY_1 - IDMAC Channel Busy 1 Register
 * - HW_IPU_IDMAC_CH_BUSY_2 - IDMAC Channel Busy 2 Register
 * - HW_IPU_IDMAC_SEP_ALPHA - IDMAC Separate Alpha Indication Register
 * - HW_IPU_IDMAC_WM_EN_1 - IDMAC Channel Watermark Enable 1 Register
 * - HW_IPU_IDMAC_SUB_ADDR_0 - IDMAC Channel Alternate Address 0 Register
 * - HW_IPU_IDMAC_SUB_ADDR_4 - IDMAC Channel Alternate Address 4 Register
 * - HW_IPU_IDMAC_SC_CORD_1 - IDMAC Scroll Coordinations Register 1
 * - HW_IPU_DP_COM_CONF_SYNC - DP Common Configuration Sync Flow Register
 * - HW_IPU_DP_GRAPH_WIND_CTRL_SYNC - DP Graphic Window Control Sync Flow Register
 * - HW_IPU_DP_FG_POS_SYNC - DP Partial Plane Window Position Sync Flow Register
 * - HW_IPU_DP_CUR_POS_SYNC - DP Cursor Position and Size Sync Flow Register
 * - HW_IPU_DP_CUR_MAP_SYNC - DP Color Cursor Mapping Sync Flow Register
 * - HW_IPU_DP_GAMMA_C_SYNC_I - DP Gamma Constants Sync Flow Register i
 * - HW_IPU_DP_GAMMA_S_SYNC_I - DP Gamma Correction Slope Sync Flow Register i
 * - HW_IPU_DP_CSCA_SYNC_I - DP Color Space Conversion Control Sync Flow Registers
 * - HW_IPU_DP_SCS_SYNC_0 - DP Color Conversion Control Sync Flow Register 0
 * - HW_IPU_DP_SCS_SYNC_1 - DP Color Conversion Control Sync Flow Register 1
 * - HW_IPU_DP_CUR_POS_ALT - DP Cursor Position and Size Alternate Register
 * - HW_IPU_DP_COM_CONF_ASYNC0 - DP Common Configuration Async 0 Flow Register
 * - HW_IPU_DP_GRAPH_WIND_CTRL_ASYNC0 - DP Graphic Window Control Async 0 Flow Register
 * - HW_IPU_DP_FG_POS_ASYNC0 - DP Partial Plane Window Position Async 0 Flow Register
 * - HW_IPU_DP_CUR_POS_ASYNC0 - DP Cursor Position and Size Async 0 Flow Register
 * - HW_IPU_DP_CUR_MAP_ASYNC0 - DP Color Cursor Mapping Async 0 Flow Register
 * - HW_IPU_DP_GAMMA_C_ASYNC0_I - DP Gamma Constant Async 0 Flow Register i
 * - HW_IPU_DP_GAMMA_S_ASYNC0_I - DP Gamma Correction Slope Async 0 Flow Register i
 * - HW_IPU_DP_CSCA_ASYNC0_I - DP Color Space Conversion Control Async 0 Flow Register i
 * - HW_IPU_DP_CSC_ASYNC0_0 - DP Color Conversion Control Async 0 Flow Register 0
 * - HW_IPU_DP_CSC_ASYNC_1 - DP Color Conversion Control Async 1 Flow Register
 * - HW_IPU_DP_COM_CONF_ASYNC1 - DP Common Configuration Async 1 Flow Register
 * - HW_IPU_DP_DEBUG_CNT - DP Debug Control Register
 * - HW_IPU_DP_GRAPH_WIND_CTRL_ASYNC1 - DP Graphic Window Control Async 1 Flow Register
 * - HW_IPU_DP_DEBUG_STAT - DP Debug Status Register
 * - HW_IPU_DP_FG_POS_ASYNC1 - DP Partial Plane Window Position Async 1 Flow Register
 * - HW_IPU_DP_CUR_POS_ASYNC1 - DP Cursor Postion and Size Async 1 Flow Register
 * - HW_IPU_DP_CUR_MAP_ASYNC1 - DP Color Cursor Mapping Async 1 Flow Register
 * - HW_IPU_DP_GAMMA_C_ASYNC1_I - DP Gamma Constants Async 1 Flow Register i
 * - HW_IPU_DP_GAMMA_S_ASYN1_I - DP Gamma Correction Slope Async 1 Flow Register i
 * - HW_IPU_DP_CSCA_ASYNC1_I - DP Color Space Converstion Control Async 1 Flow Register i
 * - HW_IPU_DP_CSC_ASYNC1_0 - DP Color Conversion Control Async 1 Flow Register 0
 * - HW_IPU_DP_CSC_ASYNC1_1 - DP Color Conversion Control Async 1 Flow Register 1
 * - HW_IPU_IC_CONF - IC Configuration Register
 * - HW_IPU_IC_PRP_ENC_RSC - IC Preprocessing Encoder Resizing Coefficients Register
 * - HW_IPU_IC_PRP_VF_RSC - IC Preprocessing View-Finder Resizing Coefficients Register
 * - HW_IPU_IC_PP_RSC - IC Postprocessing Encoder Resizing Coefficients Register
 * - HW_IPU_IC_CMBP_1 - IC Combining Parameters Register 1
 * - HW_IPU_IC_CMBP_2 - IC Combining Parameters Register 2
 * - HW_IPU_IC_IDMAC_1 - IC IDMAC Parameters 1 Register
 * - HW_IPU_IC_IDMAC_2 - IC IDMAC Parameters 2 Register
 * - HW_IPU_IC_IDMAC_3 - IC IDMAC Parameters 3Register
 * - HW_IPU_IC_IDMAC_4 - IC IDMAC Parameters 4 Register
 * - HW_IPU_CSI0_SENS_CONF - CSI0 Sensor Configuration Register
 * - HW_IPU_CSI0_SENS_FRM_SIZE - CSI0 Sense Frame Size Register
 * - HW_IPU_CSI0_ACT_FRM_SIZE - CSI0 Actual Frame Size Register
 * - HW_IPU_CSI0_OUT_FRM_CTRL - CSI0 Output Control Register
 * - HW_IPU_CSI0_TST_CTRL - CSIO Test Control Register
 * - HW_IPU_CSI0_CCIR_CODE_1 - CSIO CCIR Code Register 1
 * - HW_IPU_CSI0_CCIR_CODE_2 - CSIO CCIR Code Register 2
 * - HW_IPU_CSI0_CCIR_CODE_3 - CSIO CCIR Code Register 3
 * - HW_IPU_CSI0_DI - CSI0 Data Identifier Register
 * - HW_IPU_CSI0_SKIP - CSI0 SKIP Register
 * - HW_IPU_CSIO_CPD_CTRL - CSI0 Compander Control Register
 * - HW_IPU_CSIO_CPD_RC_I - CSI0 Red Component Compander Constants Register <i>
 * - HW_IPU_CSIO_CPD_RS_I - CSI0 Red Component Compander SLOPE Register <i>
 * - HW_IPU_CSIO_CPD_GRC_I - CSI0 GR Component Compander Constants Register <i>
 * - HW_IPU_CSIO_CPD_GRS_I - CSI0 GR Component Compander SLOPE Register <i>
 * - HW_IPU_CSIO_CPD_GBC_I - CSI0 GB Component Compander Constants Register <i>
 * - HW_IPU_CSIO_CPD_GBS_I - CSI0 GB Component Compander SLOPE Register <i>
 * - HW_IPU_CSIO_CPD_BC_I - CSI0 Blue Component Compander Constants Register <i>
 * - HW_IPU_CSIO_CPD_BS_I - CSI0 Blue Component Compander SLOPE Register <i>
 * - HW_IPU_CSI0_CPD_OFFSET1 - CSI0 Compander Offset Register 1
 * - HW_IPU_CSI0_CPD_OFFSET2 - CSI0 Compander Offset Register 2
 * - HW_IPU_CSI1_SENS_CONF - CSI1 Sensor Configuration Register
 * - HW_IPU_CSI1_SENS_FRM_SIZE - CSI1 Sense Frame Size Register
 * - HW_IPU_CSI1_ACT_FRM_SIZE - CSI1 Actual Frame Size Register
 * - HW_IPU_CSI1_OUT_FRM_CTRL - CSI1 Output Control Register
 * - HW_IPU_CSI1_TST_CTRL - CSI1 Test Control Register
 * - HW_IPU_CSI1_CCIR_CODE_1 - CSI1 CCIR Code Register 1
 * - HW_IPU_CSI1_CCIR_CODE_2 - CSI1 CCIR Code Register 2
 * - HW_IPU_CSI1_CCIR_CODE_3 - CSI1 CCIR Code Register 3
 * - HW_IPU_CSI1_DI - CSI1 Data Identifier Register
 * - HW_IPU_CSI1_SKIP - CSI1 SKIP Register
 * - HW_IPU_CSI1_CPD_CTRL - CSI1 Compander Control Register
 * - HW_IPU_CSI1_CPD_RC_I - CSI1 Red Component Compander Constants Register <i>
 * - HW_IPU_CSI1_CPD_RS_I - CSI1 Red Component Compander SLOPE Register <i>
 * - HW_IPU_CSI1_CPD_GRC_I - CSI1 GR Component Compander Constants Register <i>
 * - HW_IPU_CSI1_CPD_GRS_I - CSI1 GR Component Compander SLOPE Register <i>
 * - HW_IPU_CSI1_CPD_GBC_I - CSI1 GB Component Compander Constants Register <i>
 * - HW_IPU_CSI1_CPD_GBS_I - CSI1 GB Component Compander SLOPE Register <i>
 * - HW_IPU_CSI1_CPD_BC_I - CSI1 Blue Component Compander Constants Register <i>
 * - HW_IPU_CSI1_CPD_BS_I - CSI1 Blue Component Compander SLOPE Register <i>
 * - HW_IPU_CSI1_CPD_OFFSET1 - CSI1 Compander Offset Register 1
 * - HW_IPU_CSI1_CPD_OFFSET2 - CSI1 Compander Offset Register 2
 * - HW_IPU_DI0_GENERAL - DI0 General Register
 * - HW_IPU_DI0_BS_CLKGEN0 - DI0 Base Sync Clock Gen 0 Register
 * - HW_IPU_DI0_BS_CLKGEN1 - DI0 Base Sync Clock Gen 1 Register
 * - HW_IPU_DI0_SW_GEN0_1 - DI0 Sync Wave Gen 1 Register 0
 * - HW_IPU_DI0_SW_GEN0_2 - DI0 Sync Wave Gen 2 Register 0
 * - HW_IPU_DI0_SW_GEN0_3 - DI0 Sync Wave Gen 3 Register 0
 * - HW_IPU_DI0_SW_GEN0_4 - DI0 Sync Wave Gen 4 Register 0
 * - HW_IPU_DI0_SW_GEN0_5 - DI0 Sync Wave Gen 5 Register 0
 * - HW_IPU_DI0_SW_GEN0_6 - DI0 Sync Wave Gen 6 Register 0
 * - HW_IPU_DI0_SW_GEN0_7 - DI0 Sync Wave Gen 7 Register 0
 * - HW_IPU_DI0_SW_GEN0_8 - DI0 Sync Wave Gen 8 Register 0
 * - HW_IPU_DI0_SW_GEN0_9 - DI0 Sync Wave Gen 9 Register 0
 * - HW_IPU_DI0_SW_GEN1_1 - DI0 Sync Wave Gen 1 Register 1
 * - HW_IPU_DI0_SW_GEN1_2 - DI0 Sync Wave Gen 2 Register 1
 * - HW_IPU_DI0_SW_GEN1_3 - DI0 Sync Wave Gen 3 Register 1
 * - HW_IPU_DI0_SW_GEN1_4 - DI0 Sync Wave Gen 4 Register 1
 * - HW_IPU_DI0_SW_GEN1_5 - DI0 Sync Wave Gen 5 Register 1
 * - HW_IPU_DI0_SW_GEN1_6 - DI0 Sync Wave Gen 6 Register 1
 * - HW_IPU_DI0_SW_GEN1_7 - DI0 Sync Wave Gen 7 Register 1
 * - HW_IPU_DI0_SW_GEN1_8 - DI0 Sync Wave Gen 8 Register 1
 * - HW_IPU_DI0_SW_GEN1_9 - DI0 Sync Wave Gen 9 Register 1
 * - HW_IPU_DI0_SYNC_AS_GEN - DI0 Sync Assistance Gen Register
 * - HW_IPU_DI0_DW_GEN_I - DI0 Data Wave Gen <i> Register
 * - HW_IPU_DI0_DW_SET0_I - DI0 Data Wave Set 0 <i> Register
 * - HW_IPU_DI0_DW_SET1_I - DI0 Data Wave Set 1 <i> Register
 * - HW_IPU_DI0_DW_SET2_I - DI0 Data Wave Set 2 <i> Register
 * - HW_IPU_DI0_DW_SET3_I - DI0 Data Wave Set 3 <i> Register
 * - HW_IPU_DI0_STP_REP_I - DI0 Step Repeat <i> Registers
 * - HW_IPU_DI0_STP_REP_9 - DI0 Step Repeat 9 Registers
 * - HW_IPU_DI0_SER_CONF - DI0 Serial Display Control Register
 * - HW_IPU_DI0_SSC - DI0 Special Signals Control Register
 * - HW_IPU_DI0_POL - DI0 Polarity Register
 * - HW_IPU_DI0_AW0 - DI0 Active Window 0 Register
 * - HW_IPU_DI0_AW1 - DI0 Active Window 1 Register
 * - HW_IPU_DI0_SCR_CONF - DI0 Screen Configuration Register
 * - HW_IPU_DI0_STAT - DI0 Status Register
 * - HW_IPU_DI1_GENERAL - DI1General Register
 * - HW_IPU_DI1_BS_CLKGEN0 - DI1 Base Sync Clock Gen 0 Register
 * - HW_IPU_DI1_BS_CLKGEN1 - DI1 Base Sync Clock Gen 1 Register
 * - HW_IPU_DI1_SW_GEN0_1 - DI1 Sync Wave Gen 1 Register 0
 * - HW_IPU_DI1_SW_GEN0_2 - DI1 Sync Wave Gen 2 Register 0
 * - HW_IPU_DI1_SW_GEN0_3 - DI1 Sync Wave Gen 3 Register 0
 * - HW_IPU_DI1_SW_GEN0_4 - DI1 Sync Wave Gen 4 Register 0
 * - HW_IPU_DI1_SW_GEN0_5 - DI1 Sync Wave Gen 5 Register 0
 * - HW_IPU_DI1_SW_GEN0_6 - DI1 Sync Wave Gen 6 Register 0
 * - HW_IPU_DI1_SW_GEN0_7 - DI1 Sync Wave Gen 7 Register 0
 * - HW_IPU_DI1_SW_GEN0_8 - DI1 Sync Wave Gen 8 Register 0
 * - HW_IPU_DI1_SW_GEN0_9 - DI1Sync Wave Gen 9 Register 0
 * - HW_IPU_DI1_SW_GEN1_1 - DI1 Sync Wave Gen 1 Register 1
 * - HW_IPU_DI1_SW_GEN1_2 - DI1 Sync Wave Gen 2 Register 1
 * - HW_IPU_DI1_SW_GEN1_3 - DI1 Sync Wave Gen 3 Register 1
 * - HW_IPU_DI1_SW_GEN1_4 - DI1 Sync Wave Gen 4 Register 1
 * - HW_IPU_DI1_SW_GEN1_5 - DI1 Sync Wave Gen 5 Register 1
 * - HW_IPU_DI1_SW_GEN1_6 - DI1 Sync Wave Gen 6 Register 1
 * - HW_IPU_DI1_SW_GEN1_7 - DI1Sync Wave Gen 7 Register 1
 * - HW_IPU_DI1_SW_GEN1_8 - DI1 Sync Wave Gen 8 Register 1
 * - HW_IPU_DI1_SW_GEN1_9 - DI1 Sync Wave Gen 9 Register 1
 * - HW_IPU_DI1_SYNC_AS_GEN - DI1 Sync Assistance Gen Register
 * - HW_IPU_DI1_DW_GEN_I - DI1 Data Wave Gen <i> Register
 * - HW_IPU_DI1_DW_SET0_I - DI1 Data Wave Set 0 <i> Register
 * - HW_IPU_DI1_DW_SET1_I - DI1 Data Wave Set 1 <i> Register
 * - HW_IPU_DI1_DW_SET2_I - DI1 Data Wave Set 2 <i> Register
 * - HW_IPU_DI1_DW_SET3_I - DI1 Data Wave Set 3 <i> Register
 * - HW_IPU_D1_STP_REP_I - DI1 Step Repeat <i> Registers
 * - HW_IPU_DI1_STP_REP_9 - DI1Step Repeat 9 Registers
 * - HW_IPU_DI1_SER_CONF - DI1 Serial Display Control Register
 * - HW_IPU_DI1_SSC - DI1 Special Signals Control Register
 * - HW_IPU_DI1_POL - DI1 Polarity Register
 * - HW_IPU_DI1_AW0 - DI1Active Window 0 Register
 * - HW_IPU_DI1_AW1 - DI1 Active Window 1 Register
 * - HW_IPU_DI1_SCR_CONF - DI1 Screen Configuration Register
 * - HW_IPU_DI1_STAT - DI1 Status Register
 * - HW_IPU_SMFC_MAP - SMFC Mapping Register
 * - HW_IPU_SMFC_WMC - SMFC Watermark Control Register
 * - HW_IPU_SMFC_BS - SMFC Burst Size Register
 * - HW_IPU_DC_READ_CH_CONF - DC Read Channel Configuration Register
 * - HW_IPU_DC_READ_SH_ADDR - DC Read Channel Start Address Register
 * - HW_IPU_DC_RL0_CH_0 - DC Routine Link Register 0 Channel 0
 * - HW_IPU_DC_RL1_CH_0 - DC Routine Link Register 1 Channel 0
 * - HW_IPU_DC_RL2_CH_0 - DC Routine Link Register2 Channel 0
 * - HW_IPU_DC_RL3_CH_0 - DC Routine Link Registe3 Channel 0
 * - HW_IPU_DC_RL4_CH_0 - DC Routine Link Register 4 Channel 0
 * - HW_IPU_DC_WR_CH_CONF_1 - DC Write Channel 1 Configuration Register
 * - HW_IPU_DC_WR_CH_ADDR_1 - DC Write Channel 1 Address Configuration Register
 * - HW_IPU_DC_RL0_CH_1 - DC Routine Link Register 0 Channel 1
 * - HW_IPU_DC_RL1_CH_1 - DC Routine Link Register 1 Channel 1
 * - HW_IPU_DC_RL2_CH_1 - DC Routine Link Register 2 Channel 1
 * - HW_IPU_DC_RL3_CH_1 - DC Routine Link Register 3 Channel 1
 * - HW_IPU_DC_RL4_CH_1 - DC Routine Link Register 4 Channel 1
 * - HW_IPU_DC_WR_CH_CONF_2 - DC Write Channel 2 Configuration Register
 * - HW_IPU_DC_WR_CH_ADDR_2 - DC Write Channel 2 Address Configuration Register
 * - HW_IPU_DC_RL0_CH_2 - DC Routine Link Register 0 Channel 2
 * - HW_IPU_DC_RL1_CH_2 - DC Routine Link Register 1 Channel 2
 * - HW_IPU_DC_RL2_CH_2 - DC Routine Link Register 2 Channel 2
 * - HW_IPU_DC_RL3_CH_2 - DC Routine Link Register 3 Channel 2
 * - HW_IPU_DC_RL4_CH_2 - DC Routine Link Register 4 Channel 2
 * - HW_IPU_DC_CMD_CH_CONF_3 - DC Command Channel 3 Configuration Register
 * - HW_IPU_DC_CMD_CH_CONF_4 - DC Command Channel 4 Configuration Register
 * - HW_IPU_DC_WR_CH_CONF_5 - DC Write Channel 5Configuration Register
 * - HW_IPU_DC_WR_CH_ADDR_5 - DC Write Channel 5Address Configuration Register
 * - HW_IPU_DC_RL0_CH_5 - DC Routine Link Register 0 Channel 5
 * - HW_IPU_DC_RL1_CH_5 - DC Routine Link Register 1 Channel 5
 * - HW_IPU_DC_RL2_CH_5 - DC Routine Link Register 2 Channel 5
 * - HW_IPU_DC_RL3_CH_5 - DC Routine Link Register3 Channel 5
 * - HW_IPU_DC_RL4_CH_5 - DC Routine Link Register 4 Channel 5
 * - HW_IPU_DC_WR_CH_CONF_6 - DC Write Channel 6 Configuration Register
 * - HW_IPU_DC_WR_CH_ADDR_6 - DC Write Channel 6 Address Configuration Register
 * - HW_IPU_DC_RL0_CH_6 - DC Routine Link Register 0Channel 6
 * - HW_IPU_DC_RL1_CH_6 - DC Routine Link Register 1 Channel 6
 * - HW_IPU_DC_RL2_CH_6 - DC Routine Link Register 2 Channel 6
 * - HW_IPU_DC_RL3_CH_6 - DC Routine Link Register 3 Channel 6
 * - HW_IPU_DC_RL4_CH_6 - DC Routine Link Register 4 Channel 6
 * - HW_IPU_DC_WR_CH_CONF1_8 - DC Write Channel 8 Configuration 1Register
 * - HW_IPU_DC_WR_CH_CONF2_8 - DC Write Channel 8 Configuration 2 Register
 * - HW_IPU_DC_RL1_CH_8 - DC Routine Link Register 1 Channel 8
 * - HW_IPU_DC_RL2_CH_8 - DC Routine Link Register 2 Channel 8
 * - HW_IPU_DC_RL3_CH_8 - DC Routine Link Register 3 Channel 8
 * - HW_IPU_DC_RL4_CH_8 - DC Routine Link Register 4 Channel 8
 * - HW_IPU_DC_RL5_CH_8 - DC Routine Link Register 5 Channel 8
 * - HW_IPU_DC_RL6_CH_8 - DC Routine Link Register 6 Channel 8
 * - HW_IPU_DC_WR_CH_CONF1_9 - DC Write Channel 9 Configuration 1Register
 * - HW_IPU_DC_WR_CH_CONF2_9 - DC Write Channel 9Configuration 2Register
 * - HW_IPU_DC_RL1_CH_9 - DC Routine Link Register 1 Channel 9
 * - HW_IPU_DC_RL2_CH_9 - DC Routine Link Register 2 Channel 9
 * - HW_IPU_DC_RL3_CH_9 - DC Routine Link Register 3Channel 9
 * - HW_IPU_DC_RL4_CH_9 - DC Routine Link Register 4 Channel 9
 * - HW_IPU_DC_RL5_CH_9 - DC Routine Link Register 5 Channel 9
 * - HW_IPU_DC_RL6_CH_9 - DC Routine Link Register 6 Channel 9
 * - HW_IPU_DC_GEN - DC General Register
 * - HW_IPU_DC_DISP_CONF1_0 - DC Display Configuration 1 Register 0
 * - HW_IPU_DC_DISP_CONF1_1 - DC Display Configuration 1 Register 1
 * - HW_IPU_DC_DISP_CONF1_2 - DC Display Configuration 1 Register 2
 * - HW_IPU_DC_DISP_CONF1_3 - DC Display Configuration 1 Register 3
 * - HW_IPU_DC_DISP_CONF2_0 - DC Display Configuration 2 Register 0
 * - HW_IPU_DC_DISP_CONF2_1 - DC Display Configuration 2 Register 1
 * - HW_IPU_DC_DISP_CONF2_2 - DC Display Configuration 2 Register 2
 * - HW_IPU_DC_DISP_CONF2_3 - DC Display Configuration 2 Register 3
 * - HW_IPU_DC_DI0_CONF_1 - DC DI0Configuration Register 1
 * - HW_IPU_DC_DI0_CONF_2 - DC DI0Configuration Register 2
 * - HW_IPU_DC_DI1_CONF_1 - DC DI1Configuration Register 1
 * - HW_IPU_DC_DI1_CONF_2 - DC DI1Configuration Register 2
 * - HW_IPU_DC_MAP_CONF_0 - DC Mapping Configuration Register 0
 * - HW_IPU_DC_MAP_CONF_1 - DC Mapping Configuration Register 1
 * - HW_IPU_DC_MAP_CONF_2 - DC Mapping Configuration Register 2
 * - HW_IPU_DC_MAP_CONF_3 - DC Mapping Configuration Register 3
 * - HW_IPU_DC_MAP_CONF_4 - DC Mapping Configuration Register 4
 * - HW_IPU_DC_MAP_CONF_5 - DC Mapping Configuration Register 5
 * - HW_IPU_DC_MAP_CONF_6 - DC Mapping Configuration Register 6
 * - HW_IPU_DC_MAP_CONF_7 - DC Mapping Configuration Register 7
 * - HW_IPU_DC_MAP_CONF_8 - DC Mapping Configuration Register 8
 * - HW_IPU_DC_MAP_CONF_9 - DC Mapping Configuration Register 9
 * - HW_IPU_DC_MAP_CONF_10 - DC Mapping Configuration Register 10
 * - HW_IPU_DC_MAP_CONF_11 - DC Mapping Configuration Register 11
 * - HW_IPU_DC_MAP_CONF_12 - DC Mapping Configuration Register 12
 * - HW_IPU_DC_MAP_CONF_13 - DC Mapping Configuration Register 13
 * - HW_IPU_DC_MAP_CONF_14 - DC Mapping Configuration Register 14
 * - HW_IPU_DC_MAP_CONF_15 - DC Mapping Configuration Register 15
 * - HW_IPU_DC_MAP_CONF_16 - DC Mapping Configuration Register 16
 * - HW_IPU_DC_MAP_CONF_17 - DC Mapping Configuration Register 17
 * - HW_IPU_DC_MAP_CONF_18 - DC Mapping Configuration Register 18
 * - HW_IPU_DC_MAP_CONF_19 - DC Mapping Configuration Register 19
 * - HW_IPU_DC_MAP_CONF_20 - DC Mapping Configuration Register 20
 * - HW_IPU_DC_MAP_CONF_21 - DC Mapping Configuration Register 21
 * - HW_IPU_DC_MAP_CONF_22 - DC Mapping Configuration Register 22
 * - HW_IPU_DC_MAP_CONF_23 - DC Mapping Configuration Register 23
 * - HW_IPU_DC_MAP_CONF_24 - DC Mapping Configuration Register 24
 * - HW_IPU_DC_MAP_CONF_25 - DC Mapping Configuration Register 25
 * - HW_IPU_DC_MAP_CONF_26 - DC Mapping Configuration Register 26
 * - HW_IPU_DC_UGDE0_0 - DC User General Data Event 0 Register 0
 * - HW_IPU_DC_UGDE0_1 - DC User General Data Event 0 Register 1
 * - HW_IPU_DC_UGDE0_2 - DC User General Data Event 0 Register2
 * - HW_IPU_DC_UGDE0_3 - DC User General Data Event 0 Register 3
 * - HW_IPU_DC_UGDE1_0 - DC User General Data Event 1Register0
 * - HW_IPU_DC_UGDE1_1 - DC User General Data Event 1 Register 1
 * - HW_IPU_DC_UGDE1_2 - DC User General Data Event 1Register 2
 * - HW_IPU_DC_UGDE1_3 - DC User General Data Event 1Register 3
 * - HW_IPU_DC_UGDE2_0 - DC User General Data Event 2 Register 0
 * - HW_IPU_DC_UGDE2_1 - DC User General Data Event 2 Register 1
 * - HW_IPU_DC_UGDE2_2 - DC User General Data Event 2Register 2
 * - HW_IPU_DC_UGDE2_3 - DC User General Data Event 2Register 3
 * - HW_IPU_DC_UGDE3_0 - DC User General Data Event 3Register 0
 * - HW_IPU_DC_UGDE3_1 - DC User General Data Event 3Register 1
 * - HW_IPU_DC_UGDE3_2 - DC User General Data Event 3Register 2
 * - HW_IPU_DC_UGDE3_3 - DC User General Data Event 3Register 2
 * - HW_IPU_DC_LLA0 - DC Low Level Access Control Register 0
 * - HW_IPU_DC_LLA1 - DC Low Level Access Control Register 1
 * - HW_IPU_DC_R_LLA0 - DC Read Low Level Read Access Control Register 0
 * - HW_IPU_DC_R_LLA1 - DC Read Low Level Read Access Control Register1
 * - HW_IPU_DC_WR_CH_ADDR_5_ALT - DC Write Channel 5 Configuration Register
 * - HW_IPU_DC_STAT - DC Status Register
 * - HW_IPU_DMFC_RD_CHAN - DMFC Read Channel Register
 * - HW_IPU_DMFC_WR_CHAN - DMFC Write Channel Register
 * - HW_IPU_DMFC_WR_CHAN_DEF - DMFC Write Channel Definition Register
 * - HW_IPU_DMFC_DP_CHAN - DMFC Display Processor Channel Register
 * - HW_IPU_DMFC_DP_CHAN_DEF - DMFC Display Processor Channel Definition Register
 * - HW_IPU_DMFC_GENERAL_1 - DMFC General 1 Register
 * - HW_IPU_DMFC_GENERAL_2 - DMFC General 2 Register
 * - HW_IPU_DMFC_IC_CTRL - DMFC IC Interface Control Register
 * - HW_IPU_DMFC_WR_CHAN_ALT - DMFC Write Channel Alternate Register
 * - HW_IPU_DMFC_WR_CHAN_DEF_ALT - DMFC Write Channel Definition Alternate Register
 * - HW_IPU_DMFC_DP_CHAN_ALT - DMFC MFC Display Processor Channel Alternate Register
 * - HW_IPU_DMFC_DP_CHAN_DEF_ALT - DMFC Display Channel Definition Alternate Register
 * - HW_IPU_DMFC_GENERAL1_ALT - DMFC General 1 Alternate Register
 * - HW_IPU_DMFC_STAT - DMFC Status Register
 * - HW_IPU_VDI_FSIZE - VDI Field Size Register
 * - HW_IPU_VDI_C - VDI Control Register
 * - HW_IPU_VDI_C2 - VDI Control Register 2
 * - HW_IPU_VDI_CMDP_1 - VDI Combining Parameters Register 1
 * - HW_IPU_VDI_CMDP_2 - VDI Combining Parameters Register 2
 * - HW_IPU_VDI_PS_1 - VDI Plane Size Register 1
 * - HW_IPU_VDI_PS_2 - VDI Plane Size Register 2
 * - HW_IPU_VDI_PS_3 - VDI Plane Size Register 3
 * - HW_IPU_VDI_PS_4 - VDI Plane Size Register 4
 *
 * - hw_ipu_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_IPU_BASE
#define HW_IPU_INSTANCE_COUNT (2) //!< Number of instances of the IPU module.
#define HW_IPU1 (1) //!< Instance number for IPU1.
#define HW_IPU2 (2) //!< Instance number for IPU2.
#define REGS_IPU1_BASE (0x02400000) //!< Base address for IPU instance number 1.
#define REGS_IPU2_BASE (0x02800000) //!< Base address for IPU instance number 2.

//! @brief Get the base address of IPU by instance number.
//! @param x IPU instance number, from 1 through 2.
#define REGS_IPU_BASE(x) ( (x) == HW_IPU1 ? REGS_IPU1_BASE : (x) == HW_IPU2 ? REGS_IPU2_BASE : 0x00d00000)

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of IPU.
#define REGS_IPU_INSTANCE(b) ( (b) == REGS_IPU1_BASE ? HW_IPU1 : (b) == REGS_IPU2_BASE ? HW_IPU2 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_CONF - Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_CONF - Configuration Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_ipu_conf
{
    reg32_t U;
    struct _hw_ipu_conf_bitfields
    {
        unsigned CSI0_EN : 1; //!< [0] Camera Sensor Interface 0 Enable bit
        unsigned CSI1_EN : 1; //!< [1] Camera Sensor Interface 1 Enable bit
        unsigned IC_EN : 1; //!< [2] Image Conversion Sub-Block Enable bit
        unsigned IRT_EN : 1; //!< [3] Image Rotation Sub-Block Enable bit
        unsigned RESERVED0 : 1; //!< [4] Reserved
        unsigned DP_EN : 1; //!< [5] Display processor Sub-block Enable bit
        unsigned DI0_EN : 1; //!< [6] Display interface Sub-block 0 Enable bit
        unsigned DI1_EN : 1; //!< [7] Display Interface Sub-block 1 Enable bit
        unsigned SMFC_EN : 1; //!< [8] Sensor's Multi FIFO Controller Sub-block (SMFC) Enable bit
        unsigned DC_EN : 1; //!< [9] Display Controller sub-block (DC) Enable bit
        unsigned DMFC_EN : 1; //!< [10] Display's Multi FIFO Controller sub-block (DMFC) Enable bit
        unsigned SISG_EN : 1; //!< [11] Still Image Synchronization Generator (SISG) Enable bit
        unsigned VDI_EN : 1; //!< [12] VDI enable bit.
        unsigned RESERVED1 : 3; //!< [15:13] Reserved, should be cleared.
        unsigned IPU_DIAGBUS_MODE : 5; //!< [20:16] IPU diagnostic bus mode.
        unsigned IPU_DIAGBUS_ON : 1; //!< [21] IPU Diagnostics bus on
        unsigned IDMAC_DISABLE : 1; //!< [22] Image DMA controller (IDMAC) disable bit.
        unsigned RESERVED2 : 2; //!< [24:23] Reserved.
        unsigned IC_DMFC_SEL : 1; //!< [25] IC to DMFC select
        unsigned IC_DMFC_SYNC : 1; //!< [26] IC to DMFC Sync flow
        unsigned VDI_DMFC_SYNC : 1; //!< [27] This bit enables the direct path VDI C -> IC_VF -> DMFC for sync flow.
        unsigned CSI0_DATA_SOURCE : 1; //!< [28] CSI0 data Source
        unsigned CSI1_DATA_SOURCE : 1; //!< [29] CSI1 data Source
        unsigned IC_INPUT : 1; //!< [30] IC Input select bit.
        unsigned CSI_SEL : 1; //!< [31] CSI select bit; This bit selects manually between the 2 CSI's.
    } B;
} hw_ipu_conf_t;
#endif

/*!
 * @name Constants and macros for entire IPU_CONF register
 */
//@{
#define HW_IPU_CONF_ADDR(x)      (REGS_IPU_BASE(x) + 0x0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_CONF(x)           (*(volatile hw_ipu_conf_t *) HW_IPU_CONF_ADDR(x))
#define HW_IPU_CONF_RD(x)        (HW_IPU_CONF(x).U)
#define HW_IPU_CONF_WR(x, v)     (HW_IPU_CONF(x).U = (v))
#define HW_IPU_CONF_SET(x, v)    (HW_IPU_CONF_WR(x, HW_IPU_CONF_RD(x) |  (v)))
#define HW_IPU_CONF_CLR(x, v)    (HW_IPU_CONF_WR(x, HW_IPU_CONF_RD(x) & ~(v)))
#define HW_IPU_CONF_TOG(x, v)    (HW_IPU_CONF_WR(x, HW_IPU_CONF_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_CONF bitfields
 */

/*! @name Register IPU_CONF, field CSI0_EN[0] (RW)
 *
 * Camera Sensor Interface 0 Enable bit
 *
 * Values:
 * - 0 - CSI0 is disabled
 * - 1 - CSI0 is enabled
 */
//@{
#define BP_IPU_CONF_CSI0_EN      (0)      //!< Bit position for IPU_CONF_CSI0_EN.
#define BM_IPU_CONF_CSI0_EN      (0x00000001)  //!< Bit mask for IPU_CONF_CSI0_EN.

//! @brief Get value of IPU_CONF_CSI0_EN from a register value.
#define BG_IPU_CONF_CSI0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_CSI0_EN) >> BP_IPU_CONF_CSI0_EN)

//! @brief Format value for bitfield IPU_CONF_CSI0_EN.
#define BF_IPU_CONF_CSI0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_CSI0_EN) & BM_IPU_CONF_CSI0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI0_EN field to a new value.
#define BW_IPU_CONF_CSI0_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_CSI0_EN) | BF_IPU_CONF_CSI0_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field CSI1_EN[1] (RW)
 *
 * Camera Sensor Interface 1 Enable bit
 *
 * Values:
 * - 0 - CSI1 is disabled
 * - 1 - CSI1 is enabled
 */
//@{
#define BP_IPU_CONF_CSI1_EN      (1)      //!< Bit position for IPU_CONF_CSI1_EN.
#define BM_IPU_CONF_CSI1_EN      (0x00000002)  //!< Bit mask for IPU_CONF_CSI1_EN.

//! @brief Get value of IPU_CONF_CSI1_EN from a register value.
#define BG_IPU_CONF_CSI1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_CSI1_EN) >> BP_IPU_CONF_CSI1_EN)

//! @brief Format value for bitfield IPU_CONF_CSI1_EN.
#define BF_IPU_CONF_CSI1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_CSI1_EN) & BM_IPU_CONF_CSI1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI1_EN field to a new value.
#define BW_IPU_CONF_CSI1_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_CSI1_EN) | BF_IPU_CONF_CSI1_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IC_EN[2] (RW)
 *
 * Image Conversion Sub-Block Enable bit
 *
 * Values:
 * - 0 - IC is disabled
 * - 1 - IC is enabled
 */
//@{
#define BP_IPU_CONF_IC_EN      (2)      //!< Bit position for IPU_CONF_IC_EN.
#define BM_IPU_CONF_IC_EN      (0x00000004)  //!< Bit mask for IPU_CONF_IC_EN.

//! @brief Get value of IPU_CONF_IC_EN from a register value.
#define BG_IPU_CONF_IC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IC_EN) >> BP_IPU_CONF_IC_EN)

//! @brief Format value for bitfield IPU_CONF_IC_EN.
#define BF_IPU_CONF_IC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IC_EN) & BM_IPU_CONF_IC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_EN field to a new value.
#define BW_IPU_CONF_IC_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IC_EN) | BF_IPU_CONF_IC_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IRT_EN[3] (RW)
 *
 * Image Rotation Sub-Block Enable bit
 *
 * Values:
 * - 0 - IRT is disabled
 * - 1 - IRT is enabled
 */
//@{
#define BP_IPU_CONF_IRT_EN      (3)      //!< Bit position for IPU_CONF_IRT_EN.
#define BM_IPU_CONF_IRT_EN      (0x00000008)  //!< Bit mask for IPU_CONF_IRT_EN.

//! @brief Get value of IPU_CONF_IRT_EN from a register value.
#define BG_IPU_CONF_IRT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IRT_EN) >> BP_IPU_CONF_IRT_EN)

//! @brief Format value for bitfield IPU_CONF_IRT_EN.
#define BF_IPU_CONF_IRT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IRT_EN) & BM_IPU_CONF_IRT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IRT_EN field to a new value.
#define BW_IPU_CONF_IRT_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IRT_EN) | BF_IPU_CONF_IRT_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field DP_EN[5] (RW)
 *
 * Display processor Sub-block Enable bit
 *
 * Values:
 * - 0 - DP is disabled
 * - 1 - DP is enabled
 */
//@{
#define BP_IPU_CONF_DP_EN      (5)      //!< Bit position for IPU_CONF_DP_EN.
#define BM_IPU_CONF_DP_EN      (0x00000020)  //!< Bit mask for IPU_CONF_DP_EN.

//! @brief Get value of IPU_CONF_DP_EN from a register value.
#define BG_IPU_CONF_DP_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_DP_EN) >> BP_IPU_CONF_DP_EN)

//! @brief Format value for bitfield IPU_CONF_DP_EN.
#define BF_IPU_CONF_DP_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_DP_EN) & BM_IPU_CONF_DP_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_EN field to a new value.
#define BW_IPU_CONF_DP_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_DP_EN) | BF_IPU_CONF_DP_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field DI0_EN[6] (RW)
 *
 * Display interface Sub-block 0 Enable bit
 *
 * Values:
 * - 0 - DI0 is disabled
 * - 1 - DI0 is enabled
 */
//@{
#define BP_IPU_CONF_DI0_EN      (6)      //!< Bit position for IPU_CONF_DI0_EN.
#define BM_IPU_CONF_DI0_EN      (0x00000040)  //!< Bit mask for IPU_CONF_DI0_EN.

//! @brief Get value of IPU_CONF_DI0_EN from a register value.
#define BG_IPU_CONF_DI0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_DI0_EN) >> BP_IPU_CONF_DI0_EN)

//! @brief Format value for bitfield IPU_CONF_DI0_EN.
#define BF_IPU_CONF_DI0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_DI0_EN) & BM_IPU_CONF_DI0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_EN field to a new value.
#define BW_IPU_CONF_DI0_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_DI0_EN) | BF_IPU_CONF_DI0_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field DI1_EN[7] (RW)
 *
 * Display Interface Sub-block 1 Enable bit
 *
 * Values:
 * - 0 - DI1 is disabled
 * - 1 - DI1 is enabled
 */
//@{
#define BP_IPU_CONF_DI1_EN      (7)      //!< Bit position for IPU_CONF_DI1_EN.
#define BM_IPU_CONF_DI1_EN      (0x00000080)  //!< Bit mask for IPU_CONF_DI1_EN.

//! @brief Get value of IPU_CONF_DI1_EN from a register value.
#define BG_IPU_CONF_DI1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_DI1_EN) >> BP_IPU_CONF_DI1_EN)

//! @brief Format value for bitfield IPU_CONF_DI1_EN.
#define BF_IPU_CONF_DI1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_DI1_EN) & BM_IPU_CONF_DI1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_EN field to a new value.
#define BW_IPU_CONF_DI1_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_DI1_EN) | BF_IPU_CONF_DI1_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field SMFC_EN[8] (RW)
 *
 * Sensor's Multi FIFO Controller Sub-block (SMFC) Enable bit
 *
 * Values:
 * - 0 - SMFC is disabled
 * - 1 - SMFC is enabled
 */
//@{
#define BP_IPU_CONF_SMFC_EN      (8)      //!< Bit position for IPU_CONF_SMFC_EN.
#define BM_IPU_CONF_SMFC_EN      (0x00000100)  //!< Bit mask for IPU_CONF_SMFC_EN.

//! @brief Get value of IPU_CONF_SMFC_EN from a register value.
#define BG_IPU_CONF_SMFC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_SMFC_EN) >> BP_IPU_CONF_SMFC_EN)

//! @brief Format value for bitfield IPU_CONF_SMFC_EN.
#define BF_IPU_CONF_SMFC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_SMFC_EN) & BM_IPU_CONF_SMFC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC_EN field to a new value.
#define BW_IPU_CONF_SMFC_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_SMFC_EN) | BF_IPU_CONF_SMFC_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field DC_EN[9] (RW)
 *
 * Display Controller sub-block (DC) Enable bit
 *
 * Values:
 * - 0 - DC is disabled
 * - 1 - DC is enabled
 */
//@{
#define BP_IPU_CONF_DC_EN      (9)      //!< Bit position for IPU_CONF_DC_EN.
#define BM_IPU_CONF_DC_EN      (0x00000200)  //!< Bit mask for IPU_CONF_DC_EN.

//! @brief Get value of IPU_CONF_DC_EN from a register value.
#define BG_IPU_CONF_DC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_DC_EN) >> BP_IPU_CONF_DC_EN)

//! @brief Format value for bitfield IPU_CONF_DC_EN.
#define BF_IPU_CONF_DC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_DC_EN) & BM_IPU_CONF_DC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_EN field to a new value.
#define BW_IPU_CONF_DC_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_DC_EN) | BF_IPU_CONF_DC_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field DMFC_EN[10] (RW)
 *
 * Display's Multi FIFO Controller sub-block (DMFC) Enable bit
 *
 * Values:
 * - 0 - DMFC is disabled
 * - 1 - DMFC is enabled
 */
//@{
#define BP_IPU_CONF_DMFC_EN      (10)      //!< Bit position for IPU_CONF_DMFC_EN.
#define BM_IPU_CONF_DMFC_EN      (0x00000400)  //!< Bit mask for IPU_CONF_DMFC_EN.

//! @brief Get value of IPU_CONF_DMFC_EN from a register value.
#define BG_IPU_CONF_DMFC_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_DMFC_EN) >> BP_IPU_CONF_DMFC_EN)

//! @brief Format value for bitfield IPU_CONF_DMFC_EN.
#define BF_IPU_CONF_DMFC_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_DMFC_EN) & BM_IPU_CONF_DMFC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMFC_EN field to a new value.
#define BW_IPU_CONF_DMFC_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_DMFC_EN) | BF_IPU_CONF_DMFC_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field SISG_EN[11] (RW)
 *
 * Still Image Synchronization Generator (SISG) Enable bit
 *
 * Values:
 * - 0 - SISG is disabled
 * - 1 - SISG is enabled
 */
//@{
#define BP_IPU_CONF_SISG_EN      (11)      //!< Bit position for IPU_CONF_SISG_EN.
#define BM_IPU_CONF_SISG_EN      (0x00000800)  //!< Bit mask for IPU_CONF_SISG_EN.

//! @brief Get value of IPU_CONF_SISG_EN from a register value.
#define BG_IPU_CONF_SISG_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_SISG_EN) >> BP_IPU_CONF_SISG_EN)

//! @brief Format value for bitfield IPU_CONF_SISG_EN.
#define BF_IPU_CONF_SISG_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_SISG_EN) & BM_IPU_CONF_SISG_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SISG_EN field to a new value.
#define BW_IPU_CONF_SISG_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_SISG_EN) | BF_IPU_CONF_SISG_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field VDI_EN[12] (RW)
 *
 * VDI enable bit. This bit must be cleared if the ISP_EN bit is set.
 *
 * Values:
 * - 0 - VDI C is disabled
 * - 1 - VDI C is enabled
 */
//@{
#define BP_IPU_CONF_VDI_EN      (12)      //!< Bit position for IPU_CONF_VDI_EN.
#define BM_IPU_CONF_VDI_EN      (0x00001000)  //!< Bit mask for IPU_CONF_VDI_EN.

//! @brief Get value of IPU_CONF_VDI_EN from a register value.
#define BG_IPU_CONF_VDI_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_VDI_EN) >> BP_IPU_CONF_VDI_EN)

//! @brief Format value for bitfield IPU_CONF_VDI_EN.
#define BF_IPU_CONF_VDI_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_VDI_EN) & BM_IPU_CONF_VDI_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_EN field to a new value.
#define BW_IPU_CONF_VDI_EN(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_VDI_EN) | BF_IPU_CONF_VDI_EN(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IPU_DIAGBUS_MODE[20:16] (RW)
 *
 * IPU diagnostic bus mode. This 5 bits select one of 16 groups of signals to be routed to the IPU's
 * diagnostics bus 00000 Route group 0 to the IPU's diagnostics bus 00001 Route group 1 to the IPU's
 * diagnostics bus 01111 Route group 15 to the IPU's diagnostics bus 10000 Route group 16 to the
 * IPU's diagnostics bus 10001 Route group 17 to the IPU's diagnostics bus 10010-11111 Reserved
 */
//@{
#define BP_IPU_CONF_IPU_DIAGBUS_MODE      (16)      //!< Bit position for IPU_CONF_IPU_DIAGBUS_MODE.
#define BM_IPU_CONF_IPU_DIAGBUS_MODE      (0x001f0000)  //!< Bit mask for IPU_CONF_IPU_DIAGBUS_MODE.

//! @brief Get value of IPU_CONF_IPU_DIAGBUS_MODE from a register value.
#define BG_IPU_CONF_IPU_DIAGBUS_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IPU_DIAGBUS_MODE) >> BP_IPU_CONF_IPU_DIAGBUS_MODE)

//! @brief Format value for bitfield IPU_CONF_IPU_DIAGBUS_MODE.
#define BF_IPU_CONF_IPU_DIAGBUS_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IPU_DIAGBUS_MODE) & BM_IPU_CONF_IPU_DIAGBUS_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_DIAGBUS_MODE field to a new value.
#define BW_IPU_CONF_IPU_DIAGBUS_MODE(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IPU_DIAGBUS_MODE) | BF_IPU_CONF_IPU_DIAGBUS_MODE(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IPU_DIAGBUS_ON[21] (RW)
 *
 * IPU Diagnostics bus on This bit is connected to the IPU's output. it can be used by the SoC in
 * order to control the IOMUX and bring the IPU's diagnostics bus to the SoC's pins.
 *
 * Values:
 * - 0 - diagnostics bus is off
 * - 1 - diagnostics bus is on
 */
//@{
#define BP_IPU_CONF_IPU_DIAGBUS_ON      (21)      //!< Bit position for IPU_CONF_IPU_DIAGBUS_ON.
#define BM_IPU_CONF_IPU_DIAGBUS_ON      (0x00200000)  //!< Bit mask for IPU_CONF_IPU_DIAGBUS_ON.

//! @brief Get value of IPU_CONF_IPU_DIAGBUS_ON from a register value.
#define BG_IPU_CONF_IPU_DIAGBUS_ON(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IPU_DIAGBUS_ON) >> BP_IPU_CONF_IPU_DIAGBUS_ON)

//! @brief Format value for bitfield IPU_CONF_IPU_DIAGBUS_ON.
#define BF_IPU_CONF_IPU_DIAGBUS_ON(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IPU_DIAGBUS_ON) & BM_IPU_CONF_IPU_DIAGBUS_ON)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_DIAGBUS_ON field to a new value.
#define BW_IPU_CONF_IPU_DIAGBUS_ON(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IPU_DIAGBUS_ON) | BF_IPU_CONF_IPU_DIAGBUS_ON(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IDMAC_DISABLE[22] (RW)
 *
 * Image DMA controller (IDMAC) disable bit. This bit allows the user to turn off the clock of the
 * IDMAC if the use case permits it. By default the IDMAC is enabled.
 *
 * Values:
 * - 0 - IDMAC is enabled
 * - 1 - IDMAC is disabled
 */
//@{
#define BP_IPU_CONF_IDMAC_DISABLE      (22)      //!< Bit position for IPU_CONF_IDMAC_DISABLE.
#define BM_IPU_CONF_IDMAC_DISABLE      (0x00400000)  //!< Bit mask for IPU_CONF_IDMAC_DISABLE.

//! @brief Get value of IPU_CONF_IDMAC_DISABLE from a register value.
#define BG_IPU_CONF_IDMAC_DISABLE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IDMAC_DISABLE) >> BP_IPU_CONF_IDMAC_DISABLE)

//! @brief Format value for bitfield IPU_CONF_IDMAC_DISABLE.
#define BF_IPU_CONF_IDMAC_DISABLE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IDMAC_DISABLE) & BM_IPU_CONF_IDMAC_DISABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_DISABLE field to a new value.
#define BW_IPU_CONF_IDMAC_DISABLE(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IDMAC_DISABLE) | BF_IPU_CONF_IDMAC_DISABLE(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IC_DMFC_SEL[25] (RW)
 *
 * IC to DMFC select Selects the DMAIC_1 (channel 21) channel's connectivity between the IC and the
 * DMFC
 *
 * Values:
 * - 0 - DMAIC_1 (channel 21) is routed to the IDMAC
 * - 1 - DMAIC_1 (channel 21) is routed to DMFC In case DMFC was selected the IDMAC_CH_EN[21] must be clear.
 */
//@{
#define BP_IPU_CONF_IC_DMFC_SEL      (25)      //!< Bit position for IPU_CONF_IC_DMFC_SEL.
#define BM_IPU_CONF_IC_DMFC_SEL      (0x02000000)  //!< Bit mask for IPU_CONF_IC_DMFC_SEL.

//! @brief Get value of IPU_CONF_IC_DMFC_SEL from a register value.
#define BG_IPU_CONF_IC_DMFC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IC_DMFC_SEL) >> BP_IPU_CONF_IC_DMFC_SEL)

//! @brief Format value for bitfield IPU_CONF_IC_DMFC_SEL.
#define BF_IPU_CONF_IC_DMFC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IC_DMFC_SEL) & BM_IPU_CONF_IC_DMFC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_DMFC_SEL field to a new value.
#define BW_IPU_CONF_IC_DMFC_SEL(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IC_DMFC_SEL) | BF_IPU_CONF_IC_DMFC_SEL(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IC_DMFC_SYNC[26] (RW)
 *
 * IC to DMFC Sync flow This bit defines if the direct flow between IC to DMFC is synchronous or
 * asynchronous
 *
 * Values:
 * - 0 - async flow
 * - 1 - Sync flow
 */
//@{
#define BP_IPU_CONF_IC_DMFC_SYNC      (26)      //!< Bit position for IPU_CONF_IC_DMFC_SYNC.
#define BM_IPU_CONF_IC_DMFC_SYNC      (0x04000000)  //!< Bit mask for IPU_CONF_IC_DMFC_SYNC.

//! @brief Get value of IPU_CONF_IC_DMFC_SYNC from a register value.
#define BG_IPU_CONF_IC_DMFC_SYNC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IC_DMFC_SYNC) >> BP_IPU_CONF_IC_DMFC_SYNC)

//! @brief Format value for bitfield IPU_CONF_IC_DMFC_SYNC.
#define BF_IPU_CONF_IC_DMFC_SYNC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IC_DMFC_SYNC) & BM_IPU_CONF_IC_DMFC_SYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_DMFC_SYNC field to a new value.
#define BW_IPU_CONF_IC_DMFC_SYNC(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IC_DMFC_SYNC) | BF_IPU_CONF_IC_DMFC_SYNC(v)))
#endif
//@}

/*! @name Register IPU_CONF, field VDI_DMFC_SYNC[27] (RW)
 *
 * This bit enables the direct path VDI C -> IC_VF -> DMFC for sync flow. If this bit is set
 * IC_DMFC_SEL must be set.
 *
 * Values:
 * - 0 - the flow is disabled
 * - 1 - the flow is enabled
 */
//@{
#define BP_IPU_CONF_VDI_DMFC_SYNC      (27)      //!< Bit position for IPU_CONF_VDI_DMFC_SYNC.
#define BM_IPU_CONF_VDI_DMFC_SYNC      (0x08000000)  //!< Bit mask for IPU_CONF_VDI_DMFC_SYNC.

//! @brief Get value of IPU_CONF_VDI_DMFC_SYNC from a register value.
#define BG_IPU_CONF_VDI_DMFC_SYNC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_VDI_DMFC_SYNC) >> BP_IPU_CONF_VDI_DMFC_SYNC)

//! @brief Format value for bitfield IPU_CONF_VDI_DMFC_SYNC.
#define BF_IPU_CONF_VDI_DMFC_SYNC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_VDI_DMFC_SYNC) & BM_IPU_CONF_VDI_DMFC_SYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_DMFC_SYNC field to a new value.
#define BW_IPU_CONF_VDI_DMFC_SYNC(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_VDI_DMFC_SYNC) | BF_IPU_CONF_VDI_DMFC_SYNC(v)))
#endif
//@}

/*! @name Register IPU_CONF, field CSI0_DATA_SOURCE[28] (RW)
 *
 * CSI0 data Source This bit selects what is the data source for the CSI0. This is a static mux that
 * should not be changed while CSI0 is working. Data is handles differently if the source is MCT
 * (MIPI) or parallel interface.
 *
 * Values:
 * - 0 - Parallel interface is connected to CSI0
 * - 1 - MCT (MIPI) is connected to CSI0
 */
//@{
#define BP_IPU_CONF_CSI0_DATA_SOURCE      (28)      //!< Bit position for IPU_CONF_CSI0_DATA_SOURCE.
#define BM_IPU_CONF_CSI0_DATA_SOURCE      (0x10000000)  //!< Bit mask for IPU_CONF_CSI0_DATA_SOURCE.

//! @brief Get value of IPU_CONF_CSI0_DATA_SOURCE from a register value.
#define BG_IPU_CONF_CSI0_DATA_SOURCE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_CSI0_DATA_SOURCE) >> BP_IPU_CONF_CSI0_DATA_SOURCE)

//! @brief Format value for bitfield IPU_CONF_CSI0_DATA_SOURCE.
#define BF_IPU_CONF_CSI0_DATA_SOURCE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_CSI0_DATA_SOURCE) & BM_IPU_CONF_CSI0_DATA_SOURCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI0_DATA_SOURCE field to a new value.
#define BW_IPU_CONF_CSI0_DATA_SOURCE(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_CSI0_DATA_SOURCE) | BF_IPU_CONF_CSI0_DATA_SOURCE(v)))
#endif
//@}

/*! @name Register IPU_CONF, field CSI1_DATA_SOURCE[29] (RW)
 *
 * CSI1 data Source This bit selects what is the data source for the CSI1. This is a static mux that
 * should not be changed while CSI1 is working. Data is handles differently if the source is MCT
 * (MIPI) or parallel interface.
 *
 * Values:
 * - 0 - Parallel interface is connected to CSI1
 * - 1 - MCT (MIPI) is connected to CSI1
 */
//@{
#define BP_IPU_CONF_CSI1_DATA_SOURCE      (29)      //!< Bit position for IPU_CONF_CSI1_DATA_SOURCE.
#define BM_IPU_CONF_CSI1_DATA_SOURCE      (0x20000000)  //!< Bit mask for IPU_CONF_CSI1_DATA_SOURCE.

//! @brief Get value of IPU_CONF_CSI1_DATA_SOURCE from a register value.
#define BG_IPU_CONF_CSI1_DATA_SOURCE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_CSI1_DATA_SOURCE) >> BP_IPU_CONF_CSI1_DATA_SOURCE)

//! @brief Format value for bitfield IPU_CONF_CSI1_DATA_SOURCE.
#define BF_IPU_CONF_CSI1_DATA_SOURCE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_CSI1_DATA_SOURCE) & BM_IPU_CONF_CSI1_DATA_SOURCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI1_DATA_SOURCE field to a new value.
#define BW_IPU_CONF_CSI1_DATA_SOURCE(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_CSI1_DATA_SOURCE) | BF_IPU_CONF_CSI1_DATA_SOURCE(v)))
#endif
//@}

/*! @name Register IPU_CONF, field IC_INPUT[30] (RW)
 *
 * IC Input select bit. This bit selects manually between the 2 inputs to the IC
 *
 * Values:
 * - 1 - VDI
 */
//@{
#define BP_IPU_CONF_IC_INPUT      (30)      //!< Bit position for IPU_CONF_IC_INPUT.
#define BM_IPU_CONF_IC_INPUT      (0x40000000)  //!< Bit mask for IPU_CONF_IC_INPUT.

//! @brief Get value of IPU_CONF_IC_INPUT from a register value.
#define BG_IPU_CONF_IC_INPUT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_IC_INPUT) >> BP_IPU_CONF_IC_INPUT)

//! @brief Format value for bitfield IPU_CONF_IC_INPUT.
#define BF_IPU_CONF_IC_INPUT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_IC_INPUT) & BM_IPU_CONF_IC_INPUT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_INPUT field to a new value.
#define BW_IPU_CONF_IC_INPUT(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_IC_INPUT) | BF_IPU_CONF_IC_INPUT(v)))
#endif
//@}

/*! @name Register IPU_CONF, field CSI_SEL[31] (RW)
 *
 * CSI select bit; This bit selects manually between the 2 CSI's. This bit defines which CSI is the
 * input to the IC. This bit is effective only if IC_INPUT is bit cleared
 *
 * Values:
 * - 0 - CSI0 is selected
 * - 1 - CSI1 is selected
 */
//@{
#define BP_IPU_CONF_CSI_SEL      (31)      //!< Bit position for IPU_CONF_CSI_SEL.
#define BM_IPU_CONF_CSI_SEL      (0x80000000)  //!< Bit mask for IPU_CONF_CSI_SEL.

//! @brief Get value of IPU_CONF_CSI_SEL from a register value.
#define BG_IPU_CONF_CSI_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CONF_CSI_SEL) >> BP_IPU_CONF_CSI_SEL)

//! @brief Format value for bitfield IPU_CONF_CSI_SEL.
#define BF_IPU_CONF_CSI_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CONF_CSI_SEL) & BM_IPU_CONF_CSI_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_SEL field to a new value.
#define BW_IPU_CONF_CSI_SEL(x, v)   (HW_IPU_CONF_WR(x, (HW_IPU_CONF_RD(x) & ~BM_IPU_CONF_CSI_SEL) | BF_IPU_CONF_CSI_SEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SISG_CTRL0 - SISG Control 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SISG_CTRL0 - SISG Control 0 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_ipu_sisg_ctrl0
{
    reg32_t U;
    struct _hw_ipu_sisg_ctrl0_bitfields
    {
        unsigned VSYNC_RST_CNT : 1; //!< [0] VSYNC Resets counters
        unsigned NO_VSYNC_2_STRT_CNT : 3; //!< [3:1] VSYCs to Start Counter
        unsigned VAL_STOP_SISG_COUNTER : 25; //!< [28:4] SISG Stop Counters value.
        unsigned MCU_ACTV_TRIG : 1; //!< [29] Reserved, should be cleared.
        unsigned EXT_ACTV : 1; //!< [30] External Active
        unsigned RESERVED0 : 1; //!< [31] Reserved
    } B;
} hw_ipu_sisg_ctrl0_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SISG_CTRL0 register
 */
//@{
#define HW_IPU_SISG_CTRL0_ADDR(x)      (REGS_IPU_BASE(x) + 0x4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SISG_CTRL0(x)           (*(volatile hw_ipu_sisg_ctrl0_t *) HW_IPU_SISG_CTRL0_ADDR(x))
#define HW_IPU_SISG_CTRL0_RD(x)        (HW_IPU_SISG_CTRL0(x).U)
#define HW_IPU_SISG_CTRL0_WR(x, v)     (HW_IPU_SISG_CTRL0(x).U = (v))
#define HW_IPU_SISG_CTRL0_SET(x, v)    (HW_IPU_SISG_CTRL0_WR(x, HW_IPU_SISG_CTRL0_RD(x) |  (v)))
#define HW_IPU_SISG_CTRL0_CLR(x, v)    (HW_IPU_SISG_CTRL0_WR(x, HW_IPU_SISG_CTRL0_RD(x) & ~(v)))
#define HW_IPU_SISG_CTRL0_TOG(x, v)    (HW_IPU_SISG_CTRL0_WR(x, HW_IPU_SISG_CTRL0_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SISG_CTRL0 bitfields
 */

/*! @name Register IPU_SISG_CTRL0, field VSYNC_RST_CNT[0] (RW)
 *
 * VSYNC Resets counters Defines if the counters are stooped following VSYNC or when the counters
 * reach a pre defined value (VAL_STOP_SISG_COUNTER)
 *
 * Values:
 * - 0 - The counters are stooped when the counters reach the VAL_STOP_SISG_COUNTER value.
 * - 1 - The counters are stopped at VSYNC
 */
//@{
#define BP_IPU_SISG_CTRL0_VSYNC_RST_CNT      (0)      //!< Bit position for IPU_SISG_CTRL0_VSYNC_RST_CNT.
#define BM_IPU_SISG_CTRL0_VSYNC_RST_CNT      (0x00000001)  //!< Bit mask for IPU_SISG_CTRL0_VSYNC_RST_CNT.

//! @brief Get value of IPU_SISG_CTRL0_VSYNC_RST_CNT from a register value.
#define BG_IPU_SISG_CTRL0_VSYNC_RST_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL0_VSYNC_RST_CNT) >> BP_IPU_SISG_CTRL0_VSYNC_RST_CNT)

//! @brief Format value for bitfield IPU_SISG_CTRL0_VSYNC_RST_CNT.
#define BF_IPU_SISG_CTRL0_VSYNC_RST_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL0_VSYNC_RST_CNT) & BM_IPU_SISG_CTRL0_VSYNC_RST_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VSYNC_RST_CNT field to a new value.
#define BW_IPU_SISG_CTRL0_VSYNC_RST_CNT(x, v)   (HW_IPU_SISG_CTRL0_WR(x, (HW_IPU_SISG_CTRL0_RD(x) & ~BM_IPU_SISG_CTRL0_VSYNC_RST_CNT) | BF_IPU_SISG_CTRL0_VSYNC_RST_CNT(v)))
#endif
//@}

/*! @name Register IPU_SISG_CTRL0, field NO_VSYNC_2_STRT_CNT[3:1] (RW)
 *
 * VSYCs to Start Counter This bits define how many VSYNCs signals will be counter before activating
 * the SISG counters. If set to 0 starts immediately. If set to N (1..7) starts after N VSYNCs.
 */
//@{
#define BP_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT      (1)      //!< Bit position for IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT.
#define BM_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT      (0x0000000e)  //!< Bit mask for IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT.

//! @brief Get value of IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT from a register value.
#define BG_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT) >> BP_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT)

//! @brief Format value for bitfield IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT.
#define BF_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT) & BM_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NO_VSYNC_2_STRT_CNT field to a new value.
#define BW_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT(x, v)   (HW_IPU_SISG_CTRL0_WR(x, (HW_IPU_SISG_CTRL0_RD(x) & ~BM_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT) | BF_IPU_SISG_CTRL0_NO_VSYNC_2_STRT_CNT(v)))
#endif
//@}

/*! @name Register IPU_SISG_CTRL0, field VAL_STOP_SISG_COUNTER[28:4] (RW)
 *
 * SISG Stop Counters value. This is a predefined value that stops the SISG counters. The user
 * should write to this field the N-1 value of the desired value.
 */
//@{
#define BP_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER      (4)      //!< Bit position for IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER.
#define BM_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER      (0x1ffffff0)  //!< Bit mask for IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER.

//! @brief Get value of IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER from a register value.
#define BG_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER) >> BP_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER)

//! @brief Format value for bitfield IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER.
#define BF_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER) & BM_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VAL_STOP_SISG_COUNTER field to a new value.
#define BW_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER(x, v)   (HW_IPU_SISG_CTRL0_WR(x, (HW_IPU_SISG_CTRL0_RD(x) & ~BM_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER) | BF_IPU_SISG_CTRL0_VAL_STOP_SISG_COUNTER(v)))
#endif
//@}

/*! @name Register IPU_SISG_CTRL0, field MCU_ACTV_TRIG[29] (RW)
 *
 * Reserved, should be cleared.
 */
//@{
#define BP_IPU_SISG_CTRL0_MCU_ACTV_TRIG      (29)      //!< Bit position for IPU_SISG_CTRL0_MCU_ACTV_TRIG.
#define BM_IPU_SISG_CTRL0_MCU_ACTV_TRIG      (0x20000000)  //!< Bit mask for IPU_SISG_CTRL0_MCU_ACTV_TRIG.

//! @brief Get value of IPU_SISG_CTRL0_MCU_ACTV_TRIG from a register value.
#define BG_IPU_SISG_CTRL0_MCU_ACTV_TRIG(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL0_MCU_ACTV_TRIG) >> BP_IPU_SISG_CTRL0_MCU_ACTV_TRIG)

//! @brief Format value for bitfield IPU_SISG_CTRL0_MCU_ACTV_TRIG.
#define BF_IPU_SISG_CTRL0_MCU_ACTV_TRIG(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL0_MCU_ACTV_TRIG) & BM_IPU_SISG_CTRL0_MCU_ACTV_TRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCU_ACTV_TRIG field to a new value.
#define BW_IPU_SISG_CTRL0_MCU_ACTV_TRIG(x, v)   (HW_IPU_SISG_CTRL0_WR(x, (HW_IPU_SISG_CTRL0_RD(x) & ~BM_IPU_SISG_CTRL0_MCU_ACTV_TRIG) | BF_IPU_SISG_CTRL0_MCU_ACTV_TRIG(v)))
#endif
//@}

/*! @name Register IPU_SISG_CTRL0, field EXT_ACTV[30] (RW)
 *
 * External Active Define if an external active trigger will start the counters. The external active
 * trigger is an input signal to the IPU called ext_actv_trig
 */
//@{
#define BP_IPU_SISG_CTRL0_EXT_ACTV      (30)      //!< Bit position for IPU_SISG_CTRL0_EXT_ACTV.
#define BM_IPU_SISG_CTRL0_EXT_ACTV      (0x40000000)  //!< Bit mask for IPU_SISG_CTRL0_EXT_ACTV.

//! @brief Get value of IPU_SISG_CTRL0_EXT_ACTV from a register value.
#define BG_IPU_SISG_CTRL0_EXT_ACTV(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL0_EXT_ACTV) >> BP_IPU_SISG_CTRL0_EXT_ACTV)

//! @brief Format value for bitfield IPU_SISG_CTRL0_EXT_ACTV.
#define BF_IPU_SISG_CTRL0_EXT_ACTV(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL0_EXT_ACTV) & BM_IPU_SISG_CTRL0_EXT_ACTV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXT_ACTV field to a new value.
#define BW_IPU_SISG_CTRL0_EXT_ACTV(x, v)   (HW_IPU_SISG_CTRL0_WR(x, (HW_IPU_SISG_CTRL0_RD(x) & ~BM_IPU_SISG_CTRL0_EXT_ACTV) | BF_IPU_SISG_CTRL0_EXT_ACTV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SISG_CTRL1 - SISG Control 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SISG_CTRL1 - SISG Control 1 Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_ipu_sisg_ctrl1
{
    reg32_t U;
    struct _hw_ipu_sisg_ctrl1_bitfields
    {
        unsigned SISG_STROBE_CNT : 5; //!< [4:0] SISG Strobe Count
        unsigned RESERVED0 : 3; //!< [7:5] Reserved, should be cleared.
        unsigned SISG_OUT_POL : 6; //!< [13:8] SISG_OUT_POL
        unsigned RESERVED1 : 18; //!< [31:14] Reserved, should be cleared.
    } B;
} hw_ipu_sisg_ctrl1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SISG_CTRL1 register
 */
//@{
#define HW_IPU_SISG_CTRL1_ADDR(x)      (REGS_IPU_BASE(x) + 0x8)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SISG_CTRL1(x)           (*(volatile hw_ipu_sisg_ctrl1_t *) HW_IPU_SISG_CTRL1_ADDR(x))
#define HW_IPU_SISG_CTRL1_RD(x)        (HW_IPU_SISG_CTRL1(x).U)
#define HW_IPU_SISG_CTRL1_WR(x, v)     (HW_IPU_SISG_CTRL1(x).U = (v))
#define HW_IPU_SISG_CTRL1_SET(x, v)    (HW_IPU_SISG_CTRL1_WR(x, HW_IPU_SISG_CTRL1_RD(x) |  (v)))
#define HW_IPU_SISG_CTRL1_CLR(x, v)    (HW_IPU_SISG_CTRL1_WR(x, HW_IPU_SISG_CTRL1_RD(x) & ~(v)))
#define HW_IPU_SISG_CTRL1_TOG(x, v)    (HW_IPU_SISG_CTRL1_WR(x, HW_IPU_SISG_CTRL1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SISG_CTRL1 bitfields
 */

/*! @name Register IPU_SISG_CTRL1, field SISG_STROBE_CNT[4:0] (RW)
 *
 * SISG Strobe Count The SISG can repeat the sequence for up to 32 cycles; this is used for
 * generating a train of pulses.
 */
//@{
#define BP_IPU_SISG_CTRL1_SISG_STROBE_CNT      (0)      //!< Bit position for IPU_SISG_CTRL1_SISG_STROBE_CNT.
#define BM_IPU_SISG_CTRL1_SISG_STROBE_CNT      (0x0000001f)  //!< Bit mask for IPU_SISG_CTRL1_SISG_STROBE_CNT.

//! @brief Get value of IPU_SISG_CTRL1_SISG_STROBE_CNT from a register value.
#define BG_IPU_SISG_CTRL1_SISG_STROBE_CNT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL1_SISG_STROBE_CNT) >> BP_IPU_SISG_CTRL1_SISG_STROBE_CNT)

//! @brief Format value for bitfield IPU_SISG_CTRL1_SISG_STROBE_CNT.
#define BF_IPU_SISG_CTRL1_SISG_STROBE_CNT(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL1_SISG_STROBE_CNT) & BM_IPU_SISG_CTRL1_SISG_STROBE_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SISG_STROBE_CNT field to a new value.
#define BW_IPU_SISG_CTRL1_SISG_STROBE_CNT(x, v)   (HW_IPU_SISG_CTRL1_WR(x, (HW_IPU_SISG_CTRL1_RD(x) & ~BM_IPU_SISG_CTRL1_SISG_STROBE_CNT) | BF_IPU_SISG_CTRL1_SISG_STROBE_CNT(v)))
#endif
//@}

/*! @name Register IPU_SISG_CTRL1, field SISG_OUT_POL[13:8] (RW)
 *
 * SISG_OUT_POL This bits defines the polarity of the SISG output signals
 *
 * Values:
 * - 0 - active low
 * - 1 - active high
 */
//@{
#define BP_IPU_SISG_CTRL1_SISG_OUT_POL      (8)      //!< Bit position for IPU_SISG_CTRL1_SISG_OUT_POL.
#define BM_IPU_SISG_CTRL1_SISG_OUT_POL      (0x00003f00)  //!< Bit mask for IPU_SISG_CTRL1_SISG_OUT_POL.

//! @brief Get value of IPU_SISG_CTRL1_SISG_OUT_POL from a register value.
#define BG_IPU_SISG_CTRL1_SISG_OUT_POL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CTRL1_SISG_OUT_POL) >> BP_IPU_SISG_CTRL1_SISG_OUT_POL)

//! @brief Format value for bitfield IPU_SISG_CTRL1_SISG_OUT_POL.
#define BF_IPU_SISG_CTRL1_SISG_OUT_POL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CTRL1_SISG_OUT_POL) & BM_IPU_SISG_CTRL1_SISG_OUT_POL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SISG_OUT_POL field to a new value.
#define BW_IPU_SISG_CTRL1_SISG_OUT_POL(x, v)   (HW_IPU_SISG_CTRL1_WR(x, (HW_IPU_SISG_CTRL1_RD(x) & ~BM_IPU_SISG_CTRL1_SISG_OUT_POL) | BF_IPU_SISG_CTRL1_SISG_OUT_POL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SISG_SET_I - SISG Set<i> Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SISG_SET_I - SISG Set<i> Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_ipu_sisg_set_i
{
    reg32_t U;
    struct _hw_ipu_sisg_set_i_bitfields
    {
        unsigned SISG_SET_I : 25; //!< [24:0] SISG SET <i> value
        unsigned RESERVED0 : 7; //!< [31:25] Reserved, should be cleared.
    } B;
} hw_ipu_sisg_set_i_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SISG_SET_I register
 */
//@{
#define HW_IPU_SISG_SET_I_ADDR(x)      (REGS_IPU_BASE(x) + 0xc)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SISG_SET_I(x)           (*(volatile hw_ipu_sisg_set_i_t *) HW_IPU_SISG_SET_I_ADDR(x))
#define HW_IPU_SISG_SET_I_RD(x)        (HW_IPU_SISG_SET_I(x).U)
#define HW_IPU_SISG_SET_I_WR(x, v)     (HW_IPU_SISG_SET_I(x).U = (v))
#define HW_IPU_SISG_SET_I_SET(x, v)    (HW_IPU_SISG_SET_I_WR(x, HW_IPU_SISG_SET_I_RD(x) |  (v)))
#define HW_IPU_SISG_SET_I_CLR(x, v)    (HW_IPU_SISG_SET_I_WR(x, HW_IPU_SISG_SET_I_RD(x) & ~(v)))
#define HW_IPU_SISG_SET_I_TOG(x, v)    (HW_IPU_SISG_SET_I_WR(x, HW_IPU_SISG_SET_I_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SISG_SET_I bitfields
 */

/*! @name Register IPU_SISG_SET_I, field SISG_SET_I[24:0] (RW)
 *
 * SISG SET <i> value These bits define the set value of the SISG counter #<i>
 */
//@{
#define BP_IPU_SISG_SET_I_SISG_SET_I      (0)      //!< Bit position for IPU_SISG_SET_I_SISG_SET_I.
#define BM_IPU_SISG_SET_I_SISG_SET_I      (0x01ffffff)  //!< Bit mask for IPU_SISG_SET_I_SISG_SET_I.

//! @brief Get value of IPU_SISG_SET_I_SISG_SET_I from a register value.
#define BG_IPU_SISG_SET_I_SISG_SET_I(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_SET_I_SISG_SET_I) >> BP_IPU_SISG_SET_I_SISG_SET_I)

//! @brief Format value for bitfield IPU_SISG_SET_I_SISG_SET_I.
#define BF_IPU_SISG_SET_I_SISG_SET_I(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_SET_I_SISG_SET_I) & BM_IPU_SISG_SET_I_SISG_SET_I)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SISG_SET_I field to a new value.
#define BW_IPU_SISG_SET_I_SISG_SET_I(x, v)   (HW_IPU_SISG_SET_I_WR(x, (HW_IPU_SISG_SET_I_RD(x) & ~BM_IPU_SISG_SET_I_SISG_SET_I) | BF_IPU_SISG_SET_I_SISG_SET_I(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SISG_CLR_I - SISG Clear <i> Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SISG_CLR_I - SISG Clear <i> Register (RW)
 *
 * Reset value: 0x00000000
 */
typedef union _hw_ipu_sisg_clr_i
{
    reg32_t U;
    struct _hw_ipu_sisg_clr_i_bitfields
    {
        unsigned SISG_CLEAR_I : 25; //!< [24:0] SISG CLR <i> value
        unsigned RESERVED0 : 7; //!< [31:25] Reserved, should be cleared.
    } B;
} hw_ipu_sisg_clr_i_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SISG_CLR_I register
 */
//@{
#define HW_IPU_SISG_CLR_I_ADDR(x)      (REGS_IPU_BASE(x) + 0x24)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SISG_CLR_I(x)           (*(volatile hw_ipu_sisg_clr_i_t *) HW_IPU_SISG_CLR_I_ADDR(x))
#define HW_IPU_SISG_CLR_I_RD(x)        (HW_IPU_SISG_CLR_I(x).U)
#define HW_IPU_SISG_CLR_I_WR(x, v)     (HW_IPU_SISG_CLR_I(x).U = (v))
#define HW_IPU_SISG_CLR_I_SET(x, v)    (HW_IPU_SISG_CLR_I_WR(x, HW_IPU_SISG_CLR_I_RD(x) |  (v)))
#define HW_IPU_SISG_CLR_I_CLR(x, v)    (HW_IPU_SISG_CLR_I_WR(x, HW_IPU_SISG_CLR_I_RD(x) & ~(v)))
#define HW_IPU_SISG_CLR_I_TOG(x, v)    (HW_IPU_SISG_CLR_I_WR(x, HW_IPU_SISG_CLR_I_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SISG_CLR_I bitfields
 */

/*! @name Register IPU_SISG_CLR_I, field SISG_CLEAR_I[24:0] (RW)
 *
 * SISG CLR <i> value These bits define the clear value of the SISG counter #<i>
 */
//@{
#define BP_IPU_SISG_CLR_I_SISG_CLEAR_I      (0)      //!< Bit position for IPU_SISG_CLR_I_SISG_CLEAR_I.
#define BM_IPU_SISG_CLR_I_SISG_CLEAR_I      (0x01ffffff)  //!< Bit mask for IPU_SISG_CLR_I_SISG_CLEAR_I.

//! @brief Get value of IPU_SISG_CLR_I_SISG_CLEAR_I from a register value.
#define BG_IPU_SISG_CLR_I_SISG_CLEAR_I(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SISG_CLR_I_SISG_CLEAR_I) >> BP_IPU_SISG_CLR_I_SISG_CLEAR_I)

//! @brief Format value for bitfield IPU_SISG_CLR_I_SISG_CLEAR_I.
#define BF_IPU_SISG_CLR_I_SISG_CLEAR_I(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SISG_CLR_I_SISG_CLEAR_I) & BM_IPU_SISG_CLR_I_SISG_CLEAR_I)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SISG_CLEAR_I field to a new value.
#define BW_IPU_SISG_CLR_I_SISG_CLEAR_I(x, v)   (HW_IPU_SISG_CLR_I_WR(x, (HW_IPU_SISG_CLR_I_RD(x) & ~BM_IPU_SISG_CLR_I_SISG_CLEAR_I) | BF_IPU_SISG_CLR_I_SISG_CLEAR_I(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_1 - Interrupt Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_1 - Interrupt Control Register 1 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of EOF (end of frame) of DMA
 * Channels interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_1
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_1_bitfields
    {
        unsigned IDMAC_EOF_EN_0 : 1; //!< [0] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_1 : 1; //!< [1] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_2 : 1; //!< [2] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_3 : 1; //!< [3] Enable End of Frame of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_EOF_EN_5 : 1; //!< [5] Enable End of Frame of Channel interrupt.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_EOF_EN_8 : 1; //!< [8] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_9 : 1; //!< [9] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_10 : 1; //!< [10] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_11 : 1; //!< [11] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_12 : 1; //!< [12] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_13 : 1; //!< [13] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_14 : 1; //!< [14] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_15 : 1; //!< [15] Enable End of Frame of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_EOF_EN_17 : 1; //!< [17] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_18 : 1; //!< [18] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_19 : 1; //!< [19] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_20 : 1; //!< [20] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_21 : 1; //!< [21] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_22 : 1; //!< [22] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_23 : 1; //!< [23] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_24 : 1; //!< [24] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_25 : 1; //!< [25] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_26 : 1; //!< [26] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_27 : 1; //!< [27] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_28 : 1; //!< [28] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_29 : 1; //!< [29] Enable End of Frame of Channel interrupt.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_EOF_EN_31 : 1; //!< [31] Enable End of Frame of Channel interrupt.
    } B;
} hw_ipu_int_ctrl_1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_1 register
 */
//@{
#define HW_IPU_INT_CTRL_1_ADDR(x)      (REGS_IPU_BASE(x) + 0x3c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_1(x)           (*(volatile hw_ipu_int_ctrl_1_t *) HW_IPU_INT_CTRL_1_ADDR(x))
#define HW_IPU_INT_CTRL_1_RD(x)        (HW_IPU_INT_CTRL_1(x).U)
#define HW_IPU_INT_CTRL_1_WR(x, v)     (HW_IPU_INT_CTRL_1(x).U = (v))
#define HW_IPU_INT_CTRL_1_SET(x, v)    (HW_IPU_INT_CTRL_1_WR(x, HW_IPU_INT_CTRL_1_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_1_CLR(x, v)    (HW_IPU_INT_CTRL_1_WR(x, HW_IPU_INT_CTRL_1_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_1_TOG(x, v)    (HW_IPU_INT_CTRL_1_WR(x, HW_IPU_INT_CTRL_1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_1 bitfields
 */

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_0[0] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_0      (0)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_0.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_0      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_0.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_0 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_0) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_0)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_0.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_0) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_0 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_0(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_0) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_0(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_1[1] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_1      (1)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_1.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_1      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_1.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_1 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_1) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_1)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_1.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_1) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_1 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_1(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_1) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_1(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_2[2] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_2      (2)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_2.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_2      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_2.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_2 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_2) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_2)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_2.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_2) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_2 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_2(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_2) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_2(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_3[3] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_3      (3)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_3.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_3      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_3.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_3 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_3) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_3)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_3.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_3) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_3 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_3(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_3) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_3(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_5[5] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_5      (5)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_5.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_5      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_5.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_5 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_5) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_5)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_5.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_5) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_5 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_5(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_5) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_5(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_8[8] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_8      (8)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_8.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_8      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_8.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_8 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_8) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_8)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_8.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_8) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_8 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_8(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_8) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_8(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_9[9] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_9      (9)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_9.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_9      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_9.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_9 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_9) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_9)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_9.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_9) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_9 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_9(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_9) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_9(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_10[10] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_10      (10)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_10.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_10      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_10.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_10 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_10) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_10)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_10.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_10) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_10 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_10(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_10) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_10(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_11[11] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_11      (11)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_11.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_11      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_11.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_11 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_11) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_11)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_11.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_11) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_11 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_11(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_11) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_11(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_12[12] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_12      (12)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_12.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_12      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_12.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_12 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_12) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_12)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_12.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_12) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_12 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_12(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_12) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_12(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_13[13] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_13      (13)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_13.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_13      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_13.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_13 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_13) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_13)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_13.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_13) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_13 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_13(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_13) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_13(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_14[14] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_14      (14)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_14.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_14      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_14.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_14 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_14) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_14)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_14.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_14) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_14 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_14(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_14) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_14(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_15[15] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_15      (15)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_15.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_15      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_15.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_15 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_15) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_15)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_15.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_15) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_15 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_15(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_15) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_15(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_17[17] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_17      (17)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_17.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_17      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_17.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_17 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_17) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_17)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_17.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_17) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_17 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_17(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_17) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_17(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_18[18] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_18      (18)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_18.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_18      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_18.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_18 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_18) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_18)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_18.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_18) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_18 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_18(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_18) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_18(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_19[19] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_19      (19)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_19.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_19      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_19.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_19 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_19) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_19)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_19.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_19) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_19 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_19(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_19) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_19(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_20[20] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_20      (20)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_20.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_20      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_20.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_20 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_20) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_20)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_20.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_20) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_20 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_20(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_20) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_20(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_21[21] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_21      (21)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_21.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_21      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_21.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_21 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_21) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_21)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_21.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_21) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_21 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_21(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_21) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_21(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_22[22] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_22      (22)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_22.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_22      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_22.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_22 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_22) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_22)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_22.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_22) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_22 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_22(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_22) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_22(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_23[23] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_23      (23)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_23.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_23      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_23.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_23 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_23) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_23)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_23.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_23) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_23 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_23(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_23) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_23(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_24[24] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_24      (24)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_24.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_24      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_24.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_24 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_24) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_24)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_24.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_24) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_24 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_24(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_24) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_24(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_25[25] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_25.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_25.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_25 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_25) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_25.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_25) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_25(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_25) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_26[26] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_26.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_26.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_26 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_26) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_26.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_26) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_26(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_26) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_26(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_27[27] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_27      (27)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_27.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_27      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_27.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_27 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_27) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_27)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_27.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_27) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_27 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_27(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_27) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_27(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_28[28] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_28      (28)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_28.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_28      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_28.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_28 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_28) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_28)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_28.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_28) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_28 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_28(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_28) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_28(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_29[29] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_29      (29)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_29.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_29      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_29.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_29 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_29) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_29)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_29.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_29) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_29 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_29(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_29) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_29(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_1, field IDMAC_EOF_EN_31[31] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_31      (31)      //!< Bit position for IPU_INT_CTRL_1_IDMAC_EOF_EN_31.
#define BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_31      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_1_IDMAC_EOF_EN_31.

//! @brief Get value of IPU_INT_CTRL_1_IDMAC_EOF_EN_31 from a register value.
#define BG_IPU_INT_CTRL_1_IDMAC_EOF_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_31) >> BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_31)

//! @brief Format value for bitfield IPU_INT_CTRL_1_IDMAC_EOF_EN_31.
#define BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_1_IDMAC_EOF_EN_31) & BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_31 field to a new value.
#define BW_IPU_INT_CTRL_1_IDMAC_EOF_EN_31(x, v)   (HW_IPU_INT_CTRL_1_WR(x, (HW_IPU_INT_CTRL_1_RD(x) & ~BM_IPU_INT_CTRL_1_IDMAC_EOF_EN_31) | BF_IPU_INT_CTRL_1_IDMAC_EOF_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_2 - Interrupt Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_2 - Interrupt Control Register 2 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of EOF (end of frame) of DMA
 * Channels interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_2
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_2_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_EOF_EN_33 : 1; //!< [1] Enable End of Frame of Channel interrupt.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_EOF_EN_40 : 1; //!< [8] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_41 : 1; //!< [9] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_42 : 1; //!< [10] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_43 : 1; //!< [11] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_44 : 1; //!< [12] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_45 : 1; //!< [13] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_46 : 1; //!< [14] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_47 : 1; //!< [15] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_48 : 1; //!< [16] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_49 : 1; //!< [17] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_50 : 1; //!< [18] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_51 : 1; //!< [19] Enable End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_EN_52 : 1; //!< [20] Enable End of Frame of Channel interrupt.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_ctrl_2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_2 register
 */
//@{
#define HW_IPU_INT_CTRL_2_ADDR(x)      (REGS_IPU_BASE(x) + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_2(x)           (*(volatile hw_ipu_int_ctrl_2_t *) HW_IPU_INT_CTRL_2_ADDR(x))
#define HW_IPU_INT_CTRL_2_RD(x)        (HW_IPU_INT_CTRL_2(x).U)
#define HW_IPU_INT_CTRL_2_WR(x, v)     (HW_IPU_INT_CTRL_2(x).U = (v))
#define HW_IPU_INT_CTRL_2_SET(x, v)    (HW_IPU_INT_CTRL_2_WR(x, HW_IPU_INT_CTRL_2_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_2_CLR(x, v)    (HW_IPU_INT_CTRL_2_WR(x, HW_IPU_INT_CTRL_2_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_2_TOG(x, v)    (HW_IPU_INT_CTRL_2_WR(x, HW_IPU_INT_CTRL_2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_2 bitfields
 */

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_33[1] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_33      (1)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_33.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_33      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_33.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_33 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_33) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_33)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_33.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_33) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_33 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_33(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_33) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_33(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_40[8] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_40      (8)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_40.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_40      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_40.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_40 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_40) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_40)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_40.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_40) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_40 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_40(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_40) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_40(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_41[9] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_41      (9)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_41.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_41      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_41.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_41 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_41) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_41)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_41.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_41) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_41 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_41(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_41) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_41(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_42[10] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_42      (10)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_42.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_42      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_42.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_42 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_42) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_42)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_42.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_42) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_42 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_42(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_42) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_42(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_43[11] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_43      (11)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_43.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_43      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_43.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_43 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_43) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_43)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_43.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_43) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_43 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_43(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_43) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_43(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_44[12] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_44      (12)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_44.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_44      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_44.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_44 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_44) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_44)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_44.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_44) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_44 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_44(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_44) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_44(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_45[13] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_45      (13)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_45.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_45      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_45.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_45 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_45) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_45)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_45.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_45) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_45 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_45(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_45) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_45(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_46[14] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_46      (14)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_46.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_46      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_46.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_46 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_46) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_46)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_46.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_46) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_46 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_46(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_46) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_46(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_47[15] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_47      (15)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_47.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_47      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_47.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_47 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_47) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_47)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_47.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_47) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_47 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_47(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_47) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_47(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_48[16] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_48      (16)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_48.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_48      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_48.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_48 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_48) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_48)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_48.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_48) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_48 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_48(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_48) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_48(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_49[17] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_49      (17)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_49.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_49      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_49.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_49 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_49) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_49)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_49.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_49) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_49 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_49(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_49) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_49(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_50[18] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_50      (18)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_50.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_50      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_50.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_50 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_50) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_50)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_50.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_50) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_50 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_50(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_50) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_50(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_51[19] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_51      (19)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_51.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_51      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_51.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_51 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_51) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_51)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_51.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_51) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_51 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_51(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_51) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_51(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_2, field IDMAC_EOF_EN_52[20] (RW)
 *
 * Enable End of Frame of Channel interrupt. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_52      (20)      //!< Bit position for IPU_INT_CTRL_2_IDMAC_EOF_EN_52.
#define BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_52      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_2_IDMAC_EOF_EN_52.

//! @brief Get value of IPU_INT_CTRL_2_IDMAC_EOF_EN_52 from a register value.
#define BG_IPU_INT_CTRL_2_IDMAC_EOF_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_52) >> BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_52)

//! @brief Format value for bitfield IPU_INT_CTRL_2_IDMAC_EOF_EN_52.
#define BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_2_IDMAC_EOF_EN_52) & BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_EN_52 field to a new value.
#define BW_IPU_INT_CTRL_2_IDMAC_EOF_EN_52(x, v)   (HW_IPU_INT_CTRL_2_WR(x, (HW_IPU_INT_CTRL_2_RD(x) & ~BM_IPU_INT_CTRL_2_IDMAC_EOF_EN_52) | BF_IPU_INT_CTRL_2_IDMAC_EOF_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_3 - Interrupt Control Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_3 - Interrupt Control Register 3 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of NFACK (New Frame Ack) of
 * DMA Channels interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_3
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_3_bitfields
    {
        unsigned IDMAC_NFACK_EN_0 : 1; //!< [0] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_1 : 1; //!< [1] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_2 : 1; //!< [2] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_3 : 1; //!< [3] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_NFACK_EN_5 : 1; //!< [5] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_NFACK_EN_8 : 1; //!< [8] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_9 : 1; //!< [9] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_10 : 1; //!< [10] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_11 : 1; //!< [11] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_12 : 1; //!< [12] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_13 : 1; //!< [13] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_14 : 1; //!< [14] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_15 : 1; //!< [15] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_NFACK_EN_17 : 1; //!< [17] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_18 : 1; //!< [18] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_19 : 1; //!< [19] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_20 : 1; //!< [20] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_21 : 1; //!< [21] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_22 : 1; //!< [22] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_23 : 1; //!< [23] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_24 : 1; //!< [24] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_25 : 1; //!< [25] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_26 : 1; //!< [26] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_27 : 1; //!< [27] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_28 : 1; //!< [28] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_29 : 1; //!< [29] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_NFACK_EN_31 : 1; //!< [31] Enable New Frame Ack of Channel interrupt.
    } B;
} hw_ipu_int_ctrl_3_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_3 register
 */
//@{
#define HW_IPU_INT_CTRL_3_ADDR(x)      (REGS_IPU_BASE(x) + 0x44)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_3(x)           (*(volatile hw_ipu_int_ctrl_3_t *) HW_IPU_INT_CTRL_3_ADDR(x))
#define HW_IPU_INT_CTRL_3_RD(x)        (HW_IPU_INT_CTRL_3(x).U)
#define HW_IPU_INT_CTRL_3_WR(x, v)     (HW_IPU_INT_CTRL_3(x).U = (v))
#define HW_IPU_INT_CTRL_3_SET(x, v)    (HW_IPU_INT_CTRL_3_WR(x, HW_IPU_INT_CTRL_3_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_3_CLR(x, v)    (HW_IPU_INT_CTRL_3_WR(x, HW_IPU_INT_CTRL_3_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_3_TOG(x, v)    (HW_IPU_INT_CTRL_3_WR(x, HW_IPU_INT_CTRL_3_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_3 bitfields
 */

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_0[0] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0      (0)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_0.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_0.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_0 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_0.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_0 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_0(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_1[1] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1      (1)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_1.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_1.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_1 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_1.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_1 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_1(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_2[2] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2      (2)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_2.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_2.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_2 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_2.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_2 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_2(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_3[3] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3      (3)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_3.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_3.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_3 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_3.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_3 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_3(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_5[5] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5      (5)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_5.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_5.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_5 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_5.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_5 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_5(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_8[8] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8      (8)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_8.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_8.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_8 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_8.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_8 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_8(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_9[9] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9      (9)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_9.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_9.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_9 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_9.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_9 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_9(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_10[10] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10      (10)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_10.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_10.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_10 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_10.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_10 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_10(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_11[11] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11      (11)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_11.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_11.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_11 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_11.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_11 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_11(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_12[12] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12      (12)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_12.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_12.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_12 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_12.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_12 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_12(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_13[13] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13      (13)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_13.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_13.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_13 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_13.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_13 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_13(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_14[14] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14      (14)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_14.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_14.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_14 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_14.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_14 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_14(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_15[15] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15      (15)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_15.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_15.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_15 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_15.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_15 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_15(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_17[17] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17      (17)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_17.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_17.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_17 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_17.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_17 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_17(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_18[18] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18      (18)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_18.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_18.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_18 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_18.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_18 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_18(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_19[19] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19      (19)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_19.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_19.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_19 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_19.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_19 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_19(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_20[20] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20      (20)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_20.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_20.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_20 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_20.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_20 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_20(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_21[21] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21      (21)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_21.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_21.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_21 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_21.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_21 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_21(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_22[22] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22      (22)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_22.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_22.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_22 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_22.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_22 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_22(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_23[23] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23      (23)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_23.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_23.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_23 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_23.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_23 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_23(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_24[24] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24      (24)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_24.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_24.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_24 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_24.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_24 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_24(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_25[25] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_25.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_25.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_25 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_25.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_26[26] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_26.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_26.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_26 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_26.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_26(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_27[27] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27      (27)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_27.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_27.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_27 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_27.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_27 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_27(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_28[28] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28      (28)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_28.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_28.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_28 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_28.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_28 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_28(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_29[29] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29      (29)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_29.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_29.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_29 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_29.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_29 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_29(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_3, field IDMAC_NFACK_EN_31[31] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31      (31)      //!< Bit position for IPU_INT_CTRL_3_IDMAC_NFACK_EN_31.
#define BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_3_IDMAC_NFACK_EN_31.

//! @brief Get value of IPU_INT_CTRL_3_IDMAC_NFACK_EN_31 from a register value.
#define BG_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31) >> BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31)

//! @brief Format value for bitfield IPU_INT_CTRL_3_IDMAC_NFACK_EN_31.
#define BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31) & BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_31 field to a new value.
#define BW_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31(x, v)   (HW_IPU_INT_CTRL_3_WR(x, (HW_IPU_INT_CTRL_3_RD(x) & ~BM_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31) | BF_IPU_INT_CTRL_3_IDMAC_NFACK_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_4 - Interrupt Control Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_4 - Interrupt Control Register 4 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of NFACK (New Frame Ack) of
 * DMA Channels interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_4
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_4_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_NFACK_EN_33 : 1; //!< [1] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_NFACK_EN_40 : 1; //!< [8] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_41 : 1; //!< [9] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_42 : 1; //!< [10] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_43 : 1; //!< [11] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_44 : 1; //!< [12] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_45 : 1; //!< [13] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_46 : 1; //!< [14] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_47 : 1; //!< [15] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_48 : 1; //!< [16] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_49 : 1; //!< [17] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_50 : 1; //!< [18] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_51 : 1; //!< [19] Enable New Frame Ack of Channel interrupt.
        unsigned IDMAC_NFACK_EN_52 : 1; //!< [20] Enable New Frame Ack of Channel interrupt.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_ctrl_4_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_4 register
 */
//@{
#define HW_IPU_INT_CTRL_4_ADDR(x)      (REGS_IPU_BASE(x) + 0x48)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_4(x)           (*(volatile hw_ipu_int_ctrl_4_t *) HW_IPU_INT_CTRL_4_ADDR(x))
#define HW_IPU_INT_CTRL_4_RD(x)        (HW_IPU_INT_CTRL_4(x).U)
#define HW_IPU_INT_CTRL_4_WR(x, v)     (HW_IPU_INT_CTRL_4(x).U = (v))
#define HW_IPU_INT_CTRL_4_SET(x, v)    (HW_IPU_INT_CTRL_4_WR(x, HW_IPU_INT_CTRL_4_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_4_CLR(x, v)    (HW_IPU_INT_CTRL_4_WR(x, HW_IPU_INT_CTRL_4_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_4_TOG(x, v)    (HW_IPU_INT_CTRL_4_WR(x, HW_IPU_INT_CTRL_4_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_4 bitfields
 */

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_33[1] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33      (1)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_33.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_33.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_33 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_33.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_33 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_33(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_40[8] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40      (8)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_40.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_40.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_40 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_40.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_40 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_40(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_41[9] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41      (9)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_41.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_41.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_41 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_41.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_41 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_41(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_42[10] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42      (10)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_42.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_42.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_42 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_42.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_42 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_42(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_43[11] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43      (11)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_43.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_43.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_43 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_43.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_43 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_43(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_44[12] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44      (12)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_44.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_44.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_44 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_44.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_44 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_44(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_45[13] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45      (13)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_45.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_45.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_45 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_45.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_45 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_45(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_46[14] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46      (14)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_46.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_46.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_46 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_46.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_46 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_46(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_47[15] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47      (15)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_47.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_47.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_47 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_47.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_47 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_47(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_48[16] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48      (16)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_48.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_48.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_48 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_48.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_48 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_48(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_49[17] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49      (17)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_49.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_49.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_49 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_49.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_49 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_49(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_50[18] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50      (18)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_50.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_50.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_50 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_50.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_50 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_50(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_51[19] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51      (19)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_51.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_51.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_51 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_51.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_51 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_51(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_4, field IDMAC_NFACK_EN_52[20] (RW)
 *
 * Enable New Frame Ack of Channel interrupt. This bit is the control of New Frame Ack of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52      (20)      //!< Bit position for IPU_INT_CTRL_4_IDMAC_NFACK_EN_52.
#define BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_4_IDMAC_NFACK_EN_52.

//! @brief Get value of IPU_INT_CTRL_4_IDMAC_NFACK_EN_52 from a register value.
#define BG_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52) >> BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52)

//! @brief Format value for bitfield IPU_INT_CTRL_4_IDMAC_NFACK_EN_52.
#define BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52) & BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_EN_52 field to a new value.
#define BW_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52(x, v)   (HW_IPU_INT_CTRL_4_WR(x, (HW_IPU_INT_CTRL_4_RD(x) & ~BM_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52) | BF_IPU_INT_CTRL_4_IDMAC_NFACK_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_5 - Interrupt Control Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_5 - Interrupt Control Register 5 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the New-frame before end-
 * of-frame indication (NFB4EOF) of DMA Channels interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_5
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_5_bitfields
    {
        unsigned IDMAC_NFB4EOF_EN_0 : 1; //!< [0] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_1 : 1; //!< [1] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_2 : 1; //!< [2] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_3 : 1; //!< [3] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_NFB4EOF_EN_5 : 1; //!< [5] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_NFB4EOF_EN_8 : 1; //!< [8] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_9 : 1; //!< [9] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_10 : 1; //!< [10] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_11 : 1; //!< [11] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_12 : 1; //!< [12] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_13 : 1; //!< [13] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_14 : 1; //!< [14] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_15 : 1; //!< [15] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_NFB4EOF_EN_17 : 1; //!< [17] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_18 : 1; //!< [18] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_19 : 1; //!< [19] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_20 : 1; //!< [20] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_21 : 1; //!< [21] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_22 : 1; //!< [22] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_23 : 1; //!< [23] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_24 : 1; //!< [24] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_25 : 1; //!< [25] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_26 : 1; //!< [26] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_27 : 1; //!< [27] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_28 : 1; //!< [28] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_29 : 1; //!< [29] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_NFB4EOF_EN_31 : 1; //!< [31] New Frame before end-of-frame error indication of Channel interrupt.
    } B;
} hw_ipu_int_ctrl_5_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_5 register
 */
//@{
#define HW_IPU_INT_CTRL_5_ADDR(x)      (REGS_IPU_BASE(x) + 0x4c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_5(x)           (*(volatile hw_ipu_int_ctrl_5_t *) HW_IPU_INT_CTRL_5_ADDR(x))
#define HW_IPU_INT_CTRL_5_RD(x)        (HW_IPU_INT_CTRL_5(x).U)
#define HW_IPU_INT_CTRL_5_WR(x, v)     (HW_IPU_INT_CTRL_5(x).U = (v))
#define HW_IPU_INT_CTRL_5_SET(x, v)    (HW_IPU_INT_CTRL_5_WR(x, HW_IPU_INT_CTRL_5_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_5_CLR(x, v)    (HW_IPU_INT_CTRL_5_WR(x, HW_IPU_INT_CTRL_5_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_5_TOG(x, v)    (HW_IPU_INT_CTRL_5_WR(x, HW_IPU_INT_CTRL_5_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_5 bitfields
 */

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_0[0] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0      (0)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_0 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_0(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_1[1] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1      (1)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_1 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_1(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_2[2] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2      (2)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_2 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_2(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_3[3] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3      (3)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_3 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_3(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_5[5] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5      (5)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_5 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_5(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_8[8] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8      (8)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_8 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_8(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_9[9] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9      (9)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_9 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_9(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_10[10] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10      (10)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_10 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_10(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_11[11] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11      (11)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_11 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_11(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_12[12] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12      (12)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_12 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_12(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_13[13] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13      (13)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_13 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_13(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_14[14] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14      (14)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_14 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_14(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_15[15] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15      (15)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_15 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_15(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_17[17] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17      (17)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_17 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_17(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_18[18] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18      (18)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_18 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_18(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_19[19] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19      (19)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_19 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_19(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_20[20] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20      (20)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_20 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_20(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_21[21] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21      (21)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_21 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_21(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_22[22] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22      (22)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_22 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_22(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_23[23] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23      (23)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_23 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_23(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_24[24] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24      (24)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_24 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_24(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_25[25] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_26[26] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_26(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_27[27] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27      (27)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_27 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_27(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_28[28] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28      (28)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_28 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_28(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_29[29] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29      (29)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_29 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_29(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_5, field IDMAC_NFB4EOF_EN_31[31] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31      (31)      //!< Bit position for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31.
#define BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31.

//! @brief Get value of IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31 from a register value.
#define BG_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31) >> BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31)

//! @brief Format value for bitfield IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31.
#define BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31) & BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_31 field to a new value.
#define BW_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31(x, v)   (HW_IPU_INT_CTRL_5_WR(x, (HW_IPU_INT_CTRL_5_RD(x) & ~BM_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31) | BF_IPU_INT_CTRL_5_IDMAC_NFB4EOF_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_6 - Interrupt Control Register 6
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_6 - Interrupt Control Register 6 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the New-frame before end-
 * of-frame indication (NFB4EOF_ERR) of DMA Channels interrupts [63:32] can be found in this
 * register.
 */
typedef union _hw_ipu_int_ctrl_6
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_6_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_NFB4EOF_EN_33 : 1; //!< [1] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_NFB4EOF_EN_40 : 1; //!< [8] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_41 : 1; //!< [9] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_42 : 1; //!< [10] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_43 : 1; //!< [11] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_44 : 1; //!< [12] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_45 : 1; //!< [13] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_46 : 1; //!< [14] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_47 : 1; //!< [15] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_48 : 1; //!< [16] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_49 : 1; //!< [17] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_50 : 1; //!< [18] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_51 : 1; //!< [19] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned IDMAC_NFB4EOF_EN_52 : 1; //!< [20] New Frame before end-of-frame error indication of Channel interrupt.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_ctrl_6_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_6 register
 */
//@{
#define HW_IPU_INT_CTRL_6_ADDR(x)      (REGS_IPU_BASE(x) + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_6(x)           (*(volatile hw_ipu_int_ctrl_6_t *) HW_IPU_INT_CTRL_6_ADDR(x))
#define HW_IPU_INT_CTRL_6_RD(x)        (HW_IPU_INT_CTRL_6(x).U)
#define HW_IPU_INT_CTRL_6_WR(x, v)     (HW_IPU_INT_CTRL_6(x).U = (v))
#define HW_IPU_INT_CTRL_6_SET(x, v)    (HW_IPU_INT_CTRL_6_WR(x, HW_IPU_INT_CTRL_6_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_6_CLR(x, v)    (HW_IPU_INT_CTRL_6_WR(x, HW_IPU_INT_CTRL_6_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_6_TOG(x, v)    (HW_IPU_INT_CTRL_6_WR(x, HW_IPU_INT_CTRL_6_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_6 bitfields
 */

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_33[1] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33      (1)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_33 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_33(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_40[8] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40      (8)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_40 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_40(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_41[9] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41      (9)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_41 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_41(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_42[10] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42      (10)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_42 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_42(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_43[11] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43      (11)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_43 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_43(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_44[12] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44      (12)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_44 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_44(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_45[13] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45      (13)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_45 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_45(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_46[14] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46      (14)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_46 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_46(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_47[15] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47      (15)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_47 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_47(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_48[16] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48      (16)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_48 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_48(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_49[17] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49      (17)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_49 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_49(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_50[18] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50      (18)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_50 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_50(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_51[19] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51      (19)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_51 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_51(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_6, field IDMAC_NFB4EOF_EN_52[20] (RW)
 *
 * New Frame before end-of-frame error indication of Channel interrupt. This bit is the control of
 * New Frame before end-of-frame error interrupt of Channel #n. n Indicates the corresponding DMA
 * channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52      (20)      //!< Bit position for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52.
#define BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52.

//! @brief Get value of IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52 from a register value.
#define BG_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52) >> BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52)

//! @brief Format value for bitfield IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52.
#define BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52) & BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFB4EOF_EN_52 field to a new value.
#define BW_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52(x, v)   (HW_IPU_INT_CTRL_6_WR(x, (HW_IPU_INT_CTRL_6_RD(x) & ~BM_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52) | BF_IPU_INT_CTRL_6_IDMAC_NFB4EOF_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_7 - Interrupt Control Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_7 - Interrupt Control Register 7 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPUIPU interrupts controls. The controls of the End-of-Scroll
 * indication (EOS) of DMA Channels interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_7
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_7_bitfields
    {
        unsigned RESERVED0 : 19; //!< [18:0] Reserved.
        unsigned IDMAC_EOS_EN_19 : 1; //!< [19] End of Scroll indication of Channel interrupt.
        unsigned RESERVED1 : 3; //!< [22:20] Reserved.
        unsigned IDMAC_EOS_EN_23 : 1; //!< [23] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_24 : 1; //!< [24] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_25 : 1; //!< [25] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_26 : 1; //!< [26] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_27 : 1; //!< [27] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_28 : 1; //!< [28] End of Scroll indication of Channel interrupt.
        unsigned IDMAC_EOS_EN_29 : 1; //!< [29] End of Scroll indication of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [30] Reserved.
        unsigned IDMAC_EOS_EN_31 : 1; //!< [31] End of Scroll indication of Channel interrupt.
    } B;
} hw_ipu_int_ctrl_7_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_7 register
 */
//@{
#define HW_IPU_INT_CTRL_7_ADDR(x)      (REGS_IPU_BASE(x) + 0x54)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_7(x)           (*(volatile hw_ipu_int_ctrl_7_t *) HW_IPU_INT_CTRL_7_ADDR(x))
#define HW_IPU_INT_CTRL_7_RD(x)        (HW_IPU_INT_CTRL_7(x).U)
#define HW_IPU_INT_CTRL_7_WR(x, v)     (HW_IPU_INT_CTRL_7(x).U = (v))
#define HW_IPU_INT_CTRL_7_SET(x, v)    (HW_IPU_INT_CTRL_7_WR(x, HW_IPU_INT_CTRL_7_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_7_CLR(x, v)    (HW_IPU_INT_CTRL_7_WR(x, HW_IPU_INT_CTRL_7_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_7_TOG(x, v)    (HW_IPU_INT_CTRL_7_WR(x, HW_IPU_INT_CTRL_7_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_7 bitfields
 */

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_19[19] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_19      (19)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_19.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_19      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_19.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_19 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_19) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_19)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_19.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_19) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_19 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_19(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_19) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_19(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_23[23] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_23      (23)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_23.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_23      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_23.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_23 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_23) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_23)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_23.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_23) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_23 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_23(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_23) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_23(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_24[24] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_24      (24)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_24.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_24      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_24.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_24 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_24) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_24)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_24.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_24) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_24 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_24(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_24) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_24(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_25[25] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_25.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_25.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_25 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_25) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_25.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_25) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_25(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_25) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_26[26] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_26.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_26.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_26 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_26) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_26.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_26) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_26(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_26) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_26(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_27[27] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_27      (27)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_27.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_27      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_27.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_27 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_27) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_27)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_27.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_27) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_27 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_27(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_27) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_27(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_28[28] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_28      (28)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_28.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_28      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_28.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_28 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_28) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_28)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_28.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_28) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_28 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_28(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_28) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_28(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_29[29] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_29      (29)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_29.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_29      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_29.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_29 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_29) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_29)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_29.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_29) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_29 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_29(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_29) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_29(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_7, field IDMAC_EOS_EN_31[31] (RW)
 *
 * End of Scroll indication of Channel interrupt. This bit is the control of End of Scroll interrupt
 * of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_31      (31)      //!< Bit position for IPU_INT_CTRL_7_IDMAC_EOS_EN_31.
#define BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_31      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_7_IDMAC_EOS_EN_31.

//! @brief Get value of IPU_INT_CTRL_7_IDMAC_EOS_EN_31 from a register value.
#define BG_IPU_INT_CTRL_7_IDMAC_EOS_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_31) >> BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_31)

//! @brief Format value for bitfield IPU_INT_CTRL_7_IDMAC_EOS_EN_31.
#define BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_7_IDMAC_EOS_EN_31) & BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_31 field to a new value.
#define BW_IPU_INT_CTRL_7_IDMAC_EOS_EN_31(x, v)   (HW_IPU_INT_CTRL_7_WR(x, (HW_IPU_INT_CTRL_7_RD(x) & ~BM_IPU_INT_CTRL_7_IDMAC_EOS_EN_31) | BF_IPU_INT_CTRL_7_IDMAC_EOS_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_8 - Interrupt Control Register 8
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_8 - Interrupt Control Register 8 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the End of Scroll
 * indication (EOS) of DMA Channels interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_8
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_8_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_EOS_EN_33 : 1; //!< [1] End of Scroll of Channel interrupt.
        unsigned RESERVED1 : 7; //!< [8:2] Reserved.
        unsigned IDMAC_EOS_EN_41 : 1; //!< [9] End of Scroll of Channel interrupt.
        unsigned IDMAC_EOS_EN_42 : 1; //!< [10] End of Scroll of Channel interrupt.
        unsigned IDMAC_EOS_EN_43 : 1; //!< [11] End of Scroll of Channel interrupt.
        unsigned IDMAC_EOS_EN_44 : 1; //!< [12] End of Scroll of Channel interrupt.
        unsigned RESERVED2 : 6; //!< [18:13] Reserved.
        unsigned IDMAC_EOS_EN_51 : 1; //!< [19] End of Scroll of Channel interrupt.
        unsigned IDMAC_EOS_EN_52 : 1; //!< [20] End of Scroll of Channel interrupt.
        unsigned RESERVED3 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_ctrl_8_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_8 register
 */
//@{
#define HW_IPU_INT_CTRL_8_ADDR(x)      (REGS_IPU_BASE(x) + 0x58)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_8(x)           (*(volatile hw_ipu_int_ctrl_8_t *) HW_IPU_INT_CTRL_8_ADDR(x))
#define HW_IPU_INT_CTRL_8_RD(x)        (HW_IPU_INT_CTRL_8(x).U)
#define HW_IPU_INT_CTRL_8_WR(x, v)     (HW_IPU_INT_CTRL_8(x).U = (v))
#define HW_IPU_INT_CTRL_8_SET(x, v)    (HW_IPU_INT_CTRL_8_WR(x, HW_IPU_INT_CTRL_8_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_8_CLR(x, v)    (HW_IPU_INT_CTRL_8_WR(x, HW_IPU_INT_CTRL_8_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_8_TOG(x, v)    (HW_IPU_INT_CTRL_8_WR(x, HW_IPU_INT_CTRL_8_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_8 bitfields
 */

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_33[1] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_33      (1)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_33.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_33      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_33.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_33 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_33) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_33)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_33.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_33) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_33 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_33(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_33) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_33(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_41[9] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_41      (9)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_41.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_41      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_41.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_41 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_41) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_41)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_41.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_41) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_41 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_41(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_41) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_41(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_42[10] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_42      (10)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_42.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_42      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_42.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_42 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_42) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_42)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_42.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_42) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_42 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_42(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_42) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_42(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_43[11] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_43      (11)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_43.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_43      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_43.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_43 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_43) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_43)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_43.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_43) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_43 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_43(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_43) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_43(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_44[12] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_44      (12)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_44.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_44      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_44.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_44 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_44) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_44)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_44.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_44) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_44 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_44(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_44) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_44(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_51[19] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_51      (19)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_51.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_51      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_51.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_51 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_51) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_51)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_51.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_51) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_51 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_51(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_51) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_51(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_8, field IDMAC_EOS_EN_52[20] (RW)
 *
 * End of Scroll of Channel interrupt. This bit is the control of End Of Scroll interrupt of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_52      (20)      //!< Bit position for IPU_INT_CTRL_8_IDMAC_EOS_EN_52.
#define BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_52      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_8_IDMAC_EOS_EN_52.

//! @brief Get value of IPU_INT_CTRL_8_IDMAC_EOS_EN_52 from a register value.
#define BG_IPU_INT_CTRL_8_IDMAC_EOS_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_52) >> BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_52)

//! @brief Format value for bitfield IPU_INT_CTRL_8_IDMAC_EOS_EN_52.
#define BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_8_IDMAC_EOS_EN_52) & BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_EN_52 field to a new value.
#define BW_IPU_INT_CTRL_8_IDMAC_EOS_EN_52(x, v)   (HW_IPU_INT_CTRL_8_WR(x, (HW_IPU_INT_CTRL_8_RD(x) & ~BM_IPU_INT_CTRL_8_IDMAC_EOS_EN_52) | BF_IPU_INT_CTRL_8_IDMAC_EOS_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_9 - Interrupt Control Register 9
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_9 - Interrupt Control Register 9 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. This register controls error interrupt
 * signals coming from different sub-blocks within
 */
typedef union _hw_ipu_int_ctrl_9
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_9_bitfields
    {
        unsigned VDI_FIFO1_OVF_EN : 1; //!< [0] FIFO1 overflow Interrupt1 Enable
        unsigned RESERVED0 : 25; //!< [25:1] Reserved
        unsigned IC_BAYER_BUF_OVF_EN : 1; //!< [26] This bit enables an interrupt that is a result of the IC Buffer overflow for bayer coming from the IC.
        unsigned IC_ENC_BUF_OVF_EN : 1; //!< [27] This bit enables an interrupt that is a result of the IC Buffer overflow for encoding coming from the IC.
        unsigned IC_VF_BUF_OVF_EN : 1; //!< [28] This bit enables an interrupt that is a result of the IC Buffer overflow for view finder coming from the IC.
        unsigned RESERVED1 : 1; //!< [29] Reserved
        unsigned CSI0_PUPE_EN : 1; //!< [30] CSI0_PUPE_EN - CSI0 parameters update error interrupt enable.
        unsigned CSI1_PUPE_EN : 1; //!< [31] CSI1_PUPE_EN - CSI1 parameters update error interrupt enable.
    } B;
} hw_ipu_int_ctrl_9_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_9 register
 */
//@{
#define HW_IPU_INT_CTRL_9_ADDR(x)      (REGS_IPU_BASE(x) + 0x5c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_9(x)           (*(volatile hw_ipu_int_ctrl_9_t *) HW_IPU_INT_CTRL_9_ADDR(x))
#define HW_IPU_INT_CTRL_9_RD(x)        (HW_IPU_INT_CTRL_9(x).U)
#define HW_IPU_INT_CTRL_9_WR(x, v)     (HW_IPU_INT_CTRL_9(x).U = (v))
#define HW_IPU_INT_CTRL_9_SET(x, v)    (HW_IPU_INT_CTRL_9_WR(x, HW_IPU_INT_CTRL_9_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_9_CLR(x, v)    (HW_IPU_INT_CTRL_9_WR(x, HW_IPU_INT_CTRL_9_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_9_TOG(x, v)    (HW_IPU_INT_CTRL_9_WR(x, HW_IPU_INT_CTRL_9_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_9 bitfields
 */

/*! @name Register IPU_INT_CTRL_9, field VDI_FIFO1_OVF_EN[0] (RW)
 *
 * FIFO1 overflow Interrupt1 Enable The VDI C generates FIFO1 overflow interrupt1 when the write
 * pointer of FIFO1 overruns read pointer.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN      (0)      //!< Bit position for IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN.
#define BM_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN.

//! @brief Get value of IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN from a register value.
#define BG_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN) >> BP_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN.
#define BF_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN) & BM_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_FIFO1_OVF_EN field to a new value.
#define BW_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN) | BF_IPU_INT_CTRL_9_VDI_FIFO1_OVF_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_9, field IC_BAYER_BUF_OVF_EN[26] (RW)
 *
 * This bit enables an interrupt that is a result of the IC Buffer overflow for bayer coming from
 * the IC. The user needs to write 1 to this bit in order to clear it.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN      (26)      //!< Bit position for IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN.
#define BM_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN.

//! @brief Get value of IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN from a register value.
#define BG_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN) >> BP_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN.
#define BF_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN) & BM_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_BAYER_BUF_OVF_EN field to a new value.
#define BW_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN) | BF_IPU_INT_CTRL_9_IC_BAYER_BUF_OVF_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_9, field IC_ENC_BUF_OVF_EN[27] (RW)
 *
 * This bit enables an interrupt that is a result of the IC Buffer overflow for encoding coming from
 * the IC. The user needs to write 1 to this bit in order to clear it.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN      (27)      //!< Bit position for IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN.
#define BM_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN.

//! @brief Get value of IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN from a register value.
#define BG_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN) >> BP_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN.
#define BF_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN) & BM_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_ENC_BUF_OVF_EN field to a new value.
#define BW_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN) | BF_IPU_INT_CTRL_9_IC_ENC_BUF_OVF_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_9, field IC_VF_BUF_OVF_EN[28] (RW)
 *
 * This bit enables an interrupt that is a result of the IC Buffer overflow for view finder coming
 * from the IC. The user needs to write 1 to this bit in order to clear it.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN      (28)      //!< Bit position for IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN.
#define BM_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN.

//! @brief Get value of IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN from a register value.
#define BG_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN) >> BP_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN.
#define BF_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN) & BM_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_VF_BUF_OVF_EN field to a new value.
#define BW_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN) | BF_IPU_INT_CTRL_9_IC_VF_BUF_OVF_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_9, field CSI0_PUPE_EN[30] (RW)
 *
 * CSI0_PUPE_EN - CSI0 parameters update error interrupt enable. This bit enables an interrupt that
 * is a result of an error generated by the CSI0. The error is generated in case where new frame
 * arrived from the CSI0 before the completion of the CSI0's parameters update by the SRM
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_CSI0_PUPE_EN      (30)      //!< Bit position for IPU_INT_CTRL_9_CSI0_PUPE_EN.
#define BM_IPU_INT_CTRL_9_CSI0_PUPE_EN      (0x40000000)  //!< Bit mask for IPU_INT_CTRL_9_CSI0_PUPE_EN.

//! @brief Get value of IPU_INT_CTRL_9_CSI0_PUPE_EN from a register value.
#define BG_IPU_INT_CTRL_9_CSI0_PUPE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_CSI0_PUPE_EN) >> BP_IPU_INT_CTRL_9_CSI0_PUPE_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_CSI0_PUPE_EN.
#define BF_IPU_INT_CTRL_9_CSI0_PUPE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_CSI0_PUPE_EN) & BM_IPU_INT_CTRL_9_CSI0_PUPE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI0_PUPE_EN field to a new value.
#define BW_IPU_INT_CTRL_9_CSI0_PUPE_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_CSI0_PUPE_EN) | BF_IPU_INT_CTRL_9_CSI0_PUPE_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_9, field CSI1_PUPE_EN[31] (RW)
 *
 * CSI1_PUPE_EN - CSI1 parameters update error interrupt enable. This bit enables an interrupt that
 * is a result of an error generated by the CSI1. The error is generated in case where new frame
 * arrived from the CSI1 before the completion of the CSI1's parameters update by the SRM
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_9_CSI1_PUPE_EN      (31)      //!< Bit position for IPU_INT_CTRL_9_CSI1_PUPE_EN.
#define BM_IPU_INT_CTRL_9_CSI1_PUPE_EN      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_9_CSI1_PUPE_EN.

//! @brief Get value of IPU_INT_CTRL_9_CSI1_PUPE_EN from a register value.
#define BG_IPU_INT_CTRL_9_CSI1_PUPE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_9_CSI1_PUPE_EN) >> BP_IPU_INT_CTRL_9_CSI1_PUPE_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_9_CSI1_PUPE_EN.
#define BF_IPU_INT_CTRL_9_CSI1_PUPE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_9_CSI1_PUPE_EN) & BM_IPU_INT_CTRL_9_CSI1_PUPE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI1_PUPE_EN field to a new value.
#define BW_IPU_INT_CTRL_9_CSI1_PUPE_EN(x, v)   (HW_IPU_INT_CTRL_9_WR(x, (HW_IPU_INT_CTRL_9_RD(x) & ~BM_IPU_INT_CTRL_9_CSI1_PUPE_EN) | BF_IPU_INT_CTRL_9_CSI1_PUPE_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_10 - Interrupt Control Register 10
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_10 - Interrupt Control Register 10 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. This register controls error interrupt
 * signals coming from different modules within
 */
typedef union _hw_ipu_int_ctrl_10
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_10_bitfields
    {
        unsigned SMFC0_FRM_LOST_EN : 1; //!< [0] Frame Lost of SMFC channel 0 interrupt enable bit
        unsigned SMFC1_FRM_LOST_EN : 1; //!< [1] Frame Lost of SMFC channel 1 interrupt enable bit
        unsigned SMFC2_FRM_LOST_EN : 1; //!< [2] Frame Lost of SMFC channel 2 interrupt enable bit
        unsigned SMFC3_FRM_LOST_EN : 1; //!< [3] Frame Lost of SMFC channel 3 interrupt enable bit
        unsigned RESERVED0 : 12; //!< [15:4] Reserved
        unsigned DC_TEARING_ERR_1_EN : 1; //!< [16] Tearing Error #1 enable
        unsigned DC_TEARING_ERR_2_EN : 1; //!< [17] Tearing Error #2 enable
        unsigned DC_TEARING_ERR_6_EN : 1; //!< [18] Tearing Error #6 enable
        unsigned DI0_SYNC_DISP_ERR_EN : 1; //!< [19] DI0 Synchronous display error enable
        unsigned DI1_SYNC_DISP_ERR_EN : 1; //!< [20] DI1 Synchronous display error enable
        unsigned DI0_TIME_OUT_ERR_EN : 1; //!< [21] DI0 time outwore interrupt enable
        unsigned DI1_TIME_OUT_ERR_EN : 1; //!< [22] DI1 time out error interrupt enable
        unsigned RESERVED1 : 1; //!< [23] Reserved
        unsigned IC_VF_FRM_LOST_ERR_EN : 1; //!< [24] This bit enables an interrupt that is a result of IC's view finder frame lost.
        unsigned IC_ENC_FRM_LOST_ERR_EN : 1; //!< [25] This bit enables an interrupt that is a result of IC's encoding frame lost.
        unsigned IC_BAYER_FRM_LOST_ERR_EN : 1; //!< [26] This bit enables an interrupt that is a result of IC's Bayer frame lost.
        unsigned RESERVED2 : 1; //!< [27] Reserved
        unsigned NON_PRIVILEGED_ACC_ERR_EN : 1; //!< [28] Non Privileged Access Error interrupt enable.
        unsigned AXIW_ERR_EN : 1; //!< [29] This bit enables an interrupt that is a result of AXI write access resulted with error response.
        unsigned AXIR_ERR_EN : 1; //!< [30] This bit enables an interrupt that is a result of AXI read access resulted with error response.
        unsigned RESERVED3 : 1; //!< [31] Reserved
    } B;
} hw_ipu_int_ctrl_10_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_10 register
 */
//@{
#define HW_IPU_INT_CTRL_10_ADDR(x)      (REGS_IPU_BASE(x) + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_10(x)           (*(volatile hw_ipu_int_ctrl_10_t *) HW_IPU_INT_CTRL_10_ADDR(x))
#define HW_IPU_INT_CTRL_10_RD(x)        (HW_IPU_INT_CTRL_10(x).U)
#define HW_IPU_INT_CTRL_10_WR(x, v)     (HW_IPU_INT_CTRL_10(x).U = (v))
#define HW_IPU_INT_CTRL_10_SET(x, v)    (HW_IPU_INT_CTRL_10_WR(x, HW_IPU_INT_CTRL_10_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_10_CLR(x, v)    (HW_IPU_INT_CTRL_10_WR(x, HW_IPU_INT_CTRL_10_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_10_TOG(x, v)    (HW_IPU_INT_CTRL_10_WR(x, HW_IPU_INT_CTRL_10_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_10 bitfields
 */

/*! @name Register IPU_INT_CTRL_10, field SMFC0_FRM_LOST_EN[0] (RW)
 *
 * Frame Lost of SMFC channel 0 interrupt enable bit This bit enables an interrupt that is a result
 * of a Frame Lost of SMFC channel 0.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN      (0)      //!< Bit position for IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN.
#define BM_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN.

//! @brief Get value of IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN from a register value.
#define BG_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN) >> BP_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN.
#define BF_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN) & BM_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC0_FRM_LOST_EN field to a new value.
#define BW_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN) | BF_IPU_INT_CTRL_10_SMFC0_FRM_LOST_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field SMFC1_FRM_LOST_EN[1] (RW)
 *
 * Frame Lost of SMFC channel 1 interrupt enable bit This bit enables an interrupt that is a result
 * of a Frame Lost of SMFC channel 1.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN      (1)      //!< Bit position for IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN.
#define BM_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN.

//! @brief Get value of IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN from a register value.
#define BG_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN) >> BP_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN.
#define BF_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN) & BM_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC1_FRM_LOST_EN field to a new value.
#define BW_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN) | BF_IPU_INT_CTRL_10_SMFC1_FRM_LOST_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field SMFC2_FRM_LOST_EN[2] (RW)
 *
 * Frame Lost of SMFC channel 2 interrupt enable bit This bit enables an interrupt that is a result
 * of a Frame Lost of SMFC channel 2.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN      (2)      //!< Bit position for IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN.
#define BM_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN.

//! @brief Get value of IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN from a register value.
#define BG_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN) >> BP_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN.
#define BF_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN) & BM_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC2_FRM_LOST_EN field to a new value.
#define BW_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN) | BF_IPU_INT_CTRL_10_SMFC2_FRM_LOST_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field SMFC3_FRM_LOST_EN[3] (RW)
 *
 * Frame Lost of SMFC channel 3 interrupt enable bit This bit enables an interrupt that is a result
 * of a Frame Lost of SMFC channel 3.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN      (3)      //!< Bit position for IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN.
#define BM_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN.

//! @brief Get value of IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN from a register value.
#define BG_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN) >> BP_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN.
#define BF_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN) & BM_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC3_FRM_LOST_EN field to a new value.
#define BW_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN) | BF_IPU_INT_CTRL_10_SMFC3_FRM_LOST_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DC_TEARING_ERR_1_EN[16] (RW)
 *
 * Tearing Error #1 enable This bit enables the interrupt that is a result of tearing error while
 * the anti tearing mechanism is activated for DC channel 1
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN      (16)      //!< Bit position for IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN.
#define BM_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN.

//! @brief Get value of IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN from a register value.
#define BG_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN) >> BP_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN.
#define BF_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_TEARING_ERR_1_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN) | BF_IPU_INT_CTRL_10_DC_TEARING_ERR_1_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DC_TEARING_ERR_2_EN[17] (RW)
 *
 * Tearing Error #2 enable This bit enables the interrupt that is a result of tearing error while
 * the anti tearing mechanism is activated for DC channel 2
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN      (17)      //!< Bit position for IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN.
#define BM_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN.

//! @brief Get value of IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN from a register value.
#define BG_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN) >> BP_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN.
#define BF_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_TEARING_ERR_2_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN) | BF_IPU_INT_CTRL_10_DC_TEARING_ERR_2_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DC_TEARING_ERR_6_EN[18] (RW)
 *
 * Tearing Error #6 enable This bit enables the interrupt that is a result of tearing error while
 * the anti tearing mechanism is activated for DC channel 6
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN      (18)      //!< Bit position for IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN.
#define BM_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN.

//! @brief Get value of IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN from a register value.
#define BG_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN) >> BP_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN.
#define BF_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN) & BM_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_TEARING_ERR_6_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN) | BF_IPU_INT_CTRL_10_DC_TEARING_ERR_6_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DI0_SYNC_DISP_ERR_EN[19] (RW)
 *
 * DI0 Synchronous display error enable This bit enables the interrupt that is a result of an error
 * during access to a synchronous display via DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN      (19)      //!< Bit position for IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN.
#define BM_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN) >> BP_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN.
#define BF_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN) & BM_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_SYNC_DISP_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN) | BF_IPU_INT_CTRL_10_DI0_SYNC_DISP_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DI1_SYNC_DISP_ERR_EN[20] (RW)
 *
 * DI1 Synchronous display error enable This bit enables the interrupt that is a result of an error
 * during access to a synchronous display via DI1
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN      (20)      //!< Bit position for IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN.
#define BM_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN) >> BP_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN.
#define BF_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN) & BM_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_SYNC_DISP_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN) | BF_IPU_INT_CTRL_10_DI1_SYNC_DISP_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DI0_TIME_OUT_ERR_EN[21] (RW)
 *
 * DI0 time outwore interrupt enable This bit enables the interrupt that is a result of a time out
 * error during a read access via DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN      (21)      //!< Bit position for IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN.
#define BM_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN) >> BP_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN.
#define BF_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN) & BM_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_TIME_OUT_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN) | BF_IPU_INT_CTRL_10_DI0_TIME_OUT_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field DI1_TIME_OUT_ERR_EN[22] (RW)
 *
 * DI1 time out error interrupt enable This bit enables the interrupt that is a result of a time out
 * error during a read access via DI1
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN      (22)      //!< Bit position for IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN.
#define BM_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN) >> BP_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN.
#define BF_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN) & BM_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_TIME_OUT_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN) | BF_IPU_INT_CTRL_10_DI1_TIME_OUT_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field IC_VF_FRM_LOST_ERR_EN[24] (RW)
 *
 * This bit enables an interrupt that is a result of IC's view finder frame lost.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN      (24)      //!< Bit position for IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN.
#define BM_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN) >> BP_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN.
#define BF_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN) & BM_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_VF_FRM_LOST_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN) | BF_IPU_INT_CTRL_10_IC_VF_FRM_LOST_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field IC_ENC_FRM_LOST_ERR_EN[25] (RW)
 *
 * This bit enables an interrupt that is a result of IC's encoding frame lost.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN      (25)      //!< Bit position for IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN.
#define BM_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN) >> BP_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN.
#define BF_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN) & BM_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_ENC_FRM_LOST_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN) | BF_IPU_INT_CTRL_10_IC_ENC_FRM_LOST_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field IC_BAYER_FRM_LOST_ERR_EN[26] (RW)
 *
 * This bit enables an interrupt that is a result of IC's Bayer frame lost.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN      (26)      //!< Bit position for IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN.
#define BM_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN) >> BP_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN.
#define BF_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN) & BM_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IC_BAYER_FRM_LOST_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN) | BF_IPU_INT_CTRL_10_IC_BAYER_FRM_LOST_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field NON_PRIVILEGED_ACC_ERR_EN[28] (RW)
 *
 * Non Privileged Access Error interrupt enable. The CPMEM and the DP can be accessed by the ARM
 * platform in privileged mode only HPROT[1] =1. An attempt to access these regions in user mode
 * will issue an interrupt. This bit enables the interrupt.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN      (28)      //!< Bit position for IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN.
#define BM_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN) >> BP_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN.
#define BF_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN) & BM_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NON_PRIVILEGED_ACC_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN) | BF_IPU_INT_CTRL_10_NON_PRIVILEGED_ACC_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field AXIW_ERR_EN[29] (RW)
 *
 * This bit enables an interrupt that is a result of AXI write access resulted with error response.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_AXIW_ERR_EN      (29)      //!< Bit position for IPU_INT_CTRL_10_AXIW_ERR_EN.
#define BM_IPU_INT_CTRL_10_AXIW_ERR_EN      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_10_AXIW_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_AXIW_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_AXIW_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_AXIW_ERR_EN) >> BP_IPU_INT_CTRL_10_AXIW_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_AXIW_ERR_EN.
#define BF_IPU_INT_CTRL_10_AXIW_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_AXIW_ERR_EN) & BM_IPU_INT_CTRL_10_AXIW_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AXIW_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_AXIW_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_AXIW_ERR_EN) | BF_IPU_INT_CTRL_10_AXIW_ERR_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_10, field AXIR_ERR_EN[30] (RW)
 *
 * This bit enables an interrupt that is a result of AXI read access resulted with error response.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_10_AXIR_ERR_EN      (30)      //!< Bit position for IPU_INT_CTRL_10_AXIR_ERR_EN.
#define BM_IPU_INT_CTRL_10_AXIR_ERR_EN      (0x40000000)  //!< Bit mask for IPU_INT_CTRL_10_AXIR_ERR_EN.

//! @brief Get value of IPU_INT_CTRL_10_AXIR_ERR_EN from a register value.
#define BG_IPU_INT_CTRL_10_AXIR_ERR_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_10_AXIR_ERR_EN) >> BP_IPU_INT_CTRL_10_AXIR_ERR_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_10_AXIR_ERR_EN.
#define BF_IPU_INT_CTRL_10_AXIR_ERR_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_10_AXIR_ERR_EN) & BM_IPU_INT_CTRL_10_AXIR_ERR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AXIR_ERR_EN field to a new value.
#define BW_IPU_INT_CTRL_10_AXIR_ERR_EN(x, v)   (HW_IPU_INT_CTRL_10_WR(x, (HW_IPU_INT_CTRL_10_RD(x) & ~BM_IPU_INT_CTRL_10_AXIR_ERR_EN) | BF_IPU_INT_CTRL_10_AXIR_ERR_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_11 - Interrupt Control Register 11
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_11 - Interrupt Control Register 11 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the end-of-band
 * indication (EOBND) of DMA Channels interrupts [31:0] can be found in this register. Hide
 * VDOA_SYNC for all versions Show VDOA_SYNC for IPUv3H version. The table below tagged with other
 * settings (like IPU3M_only) should be hidden in IPUv3H version.
 */
typedef union _hw_ipu_int_ctrl_11
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_11_bitfields
    {
        unsigned IDMAC_EOBND_EN_0 : 1; //!< [0] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_1 : 1; //!< [1] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_2 : 1; //!< [2] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_3 : 1; //!< [3] end-of-band indication of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_EOBND_EN_5 : 1; //!< [5] end-of-band indication of Channel interrupt.
        unsigned RESERVED1 : 5; //!< [10:6] Reserved.
        unsigned IDMAC_EOBND_EN_11 : 1; //!< [11] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_12 : 1; //!< [12] end-of-band indication of Channel interrupt.
        unsigned RESERVED2 : 7; //!< [19:13] Reserved.
        unsigned IDMAC_EOBND_EN_20 : 1; //!< [20] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_21 : 1; //!< [21] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_22 : 1; //!< [22] end-of-band indication of Channel interrupt.
        unsigned RESERVED3 : 2; //!< [24:23] Reserved.
        unsigned IDMAC_EOBND_EN_25 : 1; //!< [25] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_26 : 1; //!< [26] end-of-band indication of Channel interrupt.
        unsigned RESERVED4 : 5; //!< [31:27] Reserved.
    } B;
} hw_ipu_int_ctrl_11_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_11 register
 */
//@{
#define HW_IPU_INT_CTRL_11_ADDR(x)      (REGS_IPU_BASE(x) + 0x64)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_11(x)           (*(volatile hw_ipu_int_ctrl_11_t *) HW_IPU_INT_CTRL_11_ADDR(x))
#define HW_IPU_INT_CTRL_11_RD(x)        (HW_IPU_INT_CTRL_11(x).U)
#define HW_IPU_INT_CTRL_11_WR(x, v)     (HW_IPU_INT_CTRL_11(x).U = (v))
#define HW_IPU_INT_CTRL_11_SET(x, v)    (HW_IPU_INT_CTRL_11_WR(x, HW_IPU_INT_CTRL_11_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_11_CLR(x, v)    (HW_IPU_INT_CTRL_11_WR(x, HW_IPU_INT_CTRL_11_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_11_TOG(x, v)    (HW_IPU_INT_CTRL_11_WR(x, HW_IPU_INT_CTRL_11_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_11 bitfields
 */

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_0[0] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0      (0)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_0.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_0.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_0 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_0.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_0 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_0(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_1[1] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1      (1)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_1.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_1.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_1 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_1.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_1 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_1(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_2[2] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2      (2)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_2.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_2.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_2 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_2.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_2 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_2(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_3[3] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3      (3)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_3.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_3.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_3 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_3.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_3 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_3(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_5[5] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5      (5)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_5.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_5.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_5 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_5.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_5 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_5(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_11[11] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11      (11)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_11.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_11.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_11 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_11.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_11 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_11(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_12[12] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12      (12)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_12.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_12.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_12 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_12.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_12 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_12(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_20[20] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20      (20)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_20.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_20.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_20 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_20.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_20 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_20(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_21[21] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21      (21)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_21.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_21.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_21 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_21.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_21 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_21(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_22[22] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22      (22)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_22.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_22.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_22 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_22.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_22 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_22(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_25[25] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_25.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_25.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_25 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_25.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_11, field IDMAC_EOBND_EN_26[26] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control of end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_11_IDMAC_EOBND_EN_26.
#define BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_11_IDMAC_EOBND_EN_26.

//! @brief Get value of IPU_INT_CTRL_11_IDMAC_EOBND_EN_26 from a register value.
#define BG_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26) >> BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_11_IDMAC_EOBND_EN_26.
#define BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26) & BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26(x, v)   (HW_IPU_INT_CTRL_11_WR(x, (HW_IPU_INT_CTRL_11_RD(x) & ~BM_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26) | BF_IPU_INT_CTRL_11_IDMAC_EOBND_EN_26(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_12 - Interrupt Control Register 12
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_12 - Interrupt Control Register 12 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the end-of-band
 * indication (EOBND) of DMA Channels interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_12
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_12_bitfields
    {
        unsigned RESERVED0 : 13; //!< [12:0] Reserved.
        unsigned IDMAC_EOBND_EN_45 : 1; //!< [13] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_46 : 1; //!< [14] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_47 : 1; //!< [15] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_48 : 1; //!< [16] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_49 : 1; //!< [17] end-of-band indication of Channel interrupt.
        unsigned IDMAC_EOBND_EN_50 : 1; //!< [18] end-of-band indication of Channel interrupt.
        unsigned RESERVED1 : 13; //!< [31:19] Reserved.
    } B;
} hw_ipu_int_ctrl_12_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_12 register
 */
//@{
#define HW_IPU_INT_CTRL_12_ADDR(x)      (REGS_IPU_BASE(x) + 0x68)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_12(x)           (*(volatile hw_ipu_int_ctrl_12_t *) HW_IPU_INT_CTRL_12_ADDR(x))
#define HW_IPU_INT_CTRL_12_RD(x)        (HW_IPU_INT_CTRL_12(x).U)
#define HW_IPU_INT_CTRL_12_WR(x, v)     (HW_IPU_INT_CTRL_12(x).U = (v))
#define HW_IPU_INT_CTRL_12_SET(x, v)    (HW_IPU_INT_CTRL_12_WR(x, HW_IPU_INT_CTRL_12_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_12_CLR(x, v)    (HW_IPU_INT_CTRL_12_WR(x, HW_IPU_INT_CTRL_12_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_12_TOG(x, v)    (HW_IPU_INT_CTRL_12_WR(x, HW_IPU_INT_CTRL_12_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_12 bitfields
 */

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_45[13] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45      (13)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_45.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_45.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_45 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_45.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_45 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_45(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_46[14] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46      (14)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_46.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_46.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_46 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_46.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_46 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_46(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_47[15] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47      (15)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_47.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_47.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_47 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_47.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_47 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_47(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_48[16] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48      (16)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_48.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_48.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_48 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_48.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_48 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_48(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_49[17] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49      (17)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_49.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_49.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_49 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_49.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_49 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_49(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_12, field IDMAC_EOBND_EN_50[18] (RW)
 *
 * end-of-band indication of Channel interrupt. This bit is the control end-of-band interrupt of
 * Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50      (18)      //!< Bit position for IPU_INT_CTRL_12_IDMAC_EOBND_EN_50.
#define BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_12_IDMAC_EOBND_EN_50.

//! @brief Get value of IPU_INT_CTRL_12_IDMAC_EOBND_EN_50 from a register value.
#define BG_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50) >> BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50)

//! @brief Format value for bitfield IPU_INT_CTRL_12_IDMAC_EOBND_EN_50.
#define BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50) & BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_EN_50 field to a new value.
#define BW_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50(x, v)   (HW_IPU_INT_CTRL_12_WR(x, (HW_IPU_INT_CTRL_12_RD(x) & ~BM_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50) | BF_IPU_INT_CTRL_12_IDMAC_EOBND_EN_50(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_13 - Interrupt Control Register 13
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_13 - Interrupt Control Register 13 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the threshold crossing
 * indication (TH) of DMA Channels interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_13
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_13_bitfields
    {
        unsigned IDMAC_TH_EN_0 : 1; //!< [0] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_1 : 1; //!< [1] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_2 : 1; //!< [2] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_3 : 1; //!< [3] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_TH_EN_5 : 1; //!< [5] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_TH_EN_8 : 1; //!< [8] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_9 : 1; //!< [9] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_10 : 1; //!< [10] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_11 : 1; //!< [11] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_12 : 1; //!< [12] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_13 : 1; //!< [13] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_14 : 1; //!< [14] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_15 : 1; //!< [15] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_TH_EN_17 : 1; //!< [17] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_18 : 1; //!< [18] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_19 : 1; //!< [19] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_20 : 1; //!< [20] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_21 : 1; //!< [21] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_22 : 1; //!< [22] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_23 : 1; //!< [23] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_24 : 1; //!< [24] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_25 : 1; //!< [25] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_26 : 1; //!< [26] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_27 : 1; //!< [27] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_28 : 1; //!< [28] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_29 : 1; //!< [29] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_TH_EN_31 : 1; //!< [31] Threshold crossing indication of Channel interrupt.
    } B;
} hw_ipu_int_ctrl_13_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_13 register
 */
//@{
#define HW_IPU_INT_CTRL_13_ADDR(x)      (REGS_IPU_BASE(x) + 0x6c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_13(x)           (*(volatile hw_ipu_int_ctrl_13_t *) HW_IPU_INT_CTRL_13_ADDR(x))
#define HW_IPU_INT_CTRL_13_RD(x)        (HW_IPU_INT_CTRL_13(x).U)
#define HW_IPU_INT_CTRL_13_WR(x, v)     (HW_IPU_INT_CTRL_13(x).U = (v))
#define HW_IPU_INT_CTRL_13_SET(x, v)    (HW_IPU_INT_CTRL_13_WR(x, HW_IPU_INT_CTRL_13_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_13_CLR(x, v)    (HW_IPU_INT_CTRL_13_WR(x, HW_IPU_INT_CTRL_13_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_13_TOG(x, v)    (HW_IPU_INT_CTRL_13_WR(x, HW_IPU_INT_CTRL_13_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_13 bitfields
 */

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_0[0] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_0      (0)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_0.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_0      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_0.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_0 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_0) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_0)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_0.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_0) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_0 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_0(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_0) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_0(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_1[1] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_1      (1)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_1.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_1      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_1.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_1 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_1) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_1)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_1.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_1) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_1 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_1(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_1) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_1(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_2[2] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_2      (2)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_2.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_2      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_2.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_2 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_2) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_2)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_2.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_2) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_2 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_2(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_2) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_2(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_3[3] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_3      (3)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_3.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_3      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_3.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_3 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_3) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_3)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_3.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_3) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_3 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_3(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_3) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_3(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_5[5] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_5      (5)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_5.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_5      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_5.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_5 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_5) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_5)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_5.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_5) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_5 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_5(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_5) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_5(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_8[8] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_8      (8)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_8.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_8      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_8.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_8 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_8) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_8)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_8.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_8) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_8 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_8(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_8) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_8(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_9[9] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_9      (9)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_9.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_9      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_9.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_9 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_9) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_9)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_9.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_9) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_9 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_9(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_9) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_9(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_10[10] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_10      (10)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_10.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_10      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_10.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_10 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_10) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_10)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_10.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_10) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_10 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_10(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_10) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_10(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_11[11] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_11      (11)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_11.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_11      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_11.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_11 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_11) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_11)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_11.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_11) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_11 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_11(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_11) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_11(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_12[12] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_12      (12)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_12.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_12      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_12.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_12 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_12) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_12)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_12.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_12) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_12 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_12(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_12) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_12(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_13[13] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_13      (13)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_13.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_13      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_13.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_13 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_13) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_13)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_13.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_13) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_13 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_13(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_13) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_13(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_14[14] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_14      (14)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_14.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_14      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_14.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_14 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_14) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_14)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_14.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_14) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_14 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_14(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_14) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_14(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_15[15] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_15      (15)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_15.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_15      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_15.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_15 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_15) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_15)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_15.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_15) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_15 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_15(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_15) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_15(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_17[17] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_17      (17)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_17.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_17      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_17.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_17 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_17) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_17)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_17.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_17) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_17 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_17(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_17) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_17(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_18[18] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_18      (18)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_18.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_18      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_18.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_18 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_18) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_18)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_18.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_18) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_18 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_18(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_18) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_18(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_19[19] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_19      (19)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_19.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_19      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_19.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_19 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_19) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_19)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_19.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_19) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_19 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_19(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_19) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_19(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_20[20] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_20      (20)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_20.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_20      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_20.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_20 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_20) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_20)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_20.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_20) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_20 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_20(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_20) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_20(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_21[21] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_21      (21)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_21.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_21      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_21.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_21 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_21) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_21)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_21.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_21) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_21 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_21(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_21) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_21(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_22[22] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_22      (22)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_22.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_22      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_22.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_22 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_22) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_22)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_22.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_22) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_22 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_22(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_22) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_22(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_23[23] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_23      (23)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_23.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_23      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_23.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_23 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_23) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_23)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_23.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_23) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_23 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_23(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_23) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_23(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_24[24] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_24      (24)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_24.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_24      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_24.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_24 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_24) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_24)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_24.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_24) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_24 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_24(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_24) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_24(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_25[25] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_25      (25)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_25.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_25      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_25.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_25 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_25) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_25)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_25.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_25) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_25 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_25(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_25) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_25(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_26[26] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_26      (26)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_26.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_26      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_26.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_26 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_26) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_26)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_26.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_26) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_26 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_26(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_26) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_26(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_27[27] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_27      (27)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_27.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_27      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_27.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_27 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_27) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_27)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_27.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_27) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_27 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_27(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_27) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_27(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_28[28] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_28      (28)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_28.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_28      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_28.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_28 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_28) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_28)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_28.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_28) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_28 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_28(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_28) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_28(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_29[29] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_29      (29)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_29.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_29      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_29.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_29 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_29) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_29)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_29.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_29) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_29 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_29(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_29) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_29(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_13, field IDMAC_TH_EN_31[31] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control of Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_13_IDMAC_TH_EN_31      (31)      //!< Bit position for IPU_INT_CTRL_13_IDMAC_TH_EN_31.
#define BM_IPU_INT_CTRL_13_IDMAC_TH_EN_31      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_13_IDMAC_TH_EN_31.

//! @brief Get value of IPU_INT_CTRL_13_IDMAC_TH_EN_31 from a register value.
#define BG_IPU_INT_CTRL_13_IDMAC_TH_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_31) >> BP_IPU_INT_CTRL_13_IDMAC_TH_EN_31)

//! @brief Format value for bitfield IPU_INT_CTRL_13_IDMAC_TH_EN_31.
#define BF_IPU_INT_CTRL_13_IDMAC_TH_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_13_IDMAC_TH_EN_31) & BM_IPU_INT_CTRL_13_IDMAC_TH_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_31 field to a new value.
#define BW_IPU_INT_CTRL_13_IDMAC_TH_EN_31(x, v)   (HW_IPU_INT_CTRL_13_WR(x, (HW_IPU_INT_CTRL_13_RD(x) & ~BM_IPU_INT_CTRL_13_IDMAC_TH_EN_31) | BF_IPU_INT_CTRL_13_IDMAC_TH_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_14 - Interrupt Control Register 14
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_14 - Interrupt Control Register 14 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of the Threshold crossing
 * indication (TH) of DMA Channels interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_14
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_14_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_TH_EN_33 : 1; //!< [1] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_TH_EN_40 : 1; //!< [8] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_41 : 1; //!< [9] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_42 : 1; //!< [10] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_43 : 1; //!< [11] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_44 : 1; //!< [12] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_45 : 1; //!< [13] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_46 : 1; //!< [14] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_47 : 1; //!< [15] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_48 : 1; //!< [16] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_49 : 1; //!< [17] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_50 : 1; //!< [18] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_51 : 1; //!< [19] Threshold crossing indication of Channel interrupt.
        unsigned IDMAC_TH_EN_52 : 1; //!< [20] Threshold crossing indication of Channel interrupt.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_ctrl_14_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_14 register
 */
//@{
#define HW_IPU_INT_CTRL_14_ADDR(x)      (REGS_IPU_BASE(x) + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_14(x)           (*(volatile hw_ipu_int_ctrl_14_t *) HW_IPU_INT_CTRL_14_ADDR(x))
#define HW_IPU_INT_CTRL_14_RD(x)        (HW_IPU_INT_CTRL_14(x).U)
#define HW_IPU_INT_CTRL_14_WR(x, v)     (HW_IPU_INT_CTRL_14(x).U = (v))
#define HW_IPU_INT_CTRL_14_SET(x, v)    (HW_IPU_INT_CTRL_14_WR(x, HW_IPU_INT_CTRL_14_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_14_CLR(x, v)    (HW_IPU_INT_CTRL_14_WR(x, HW_IPU_INT_CTRL_14_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_14_TOG(x, v)    (HW_IPU_INT_CTRL_14_WR(x, HW_IPU_INT_CTRL_14_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_14 bitfields
 */

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_33[1] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_33      (1)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_33.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_33      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_33.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_33 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_33) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_33)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_33.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_33) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_33 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_33(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_33) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_33(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_40[8] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_40      (8)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_40.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_40      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_40.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_40 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_40) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_40)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_40.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_40) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_40 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_40(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_40) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_40(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_41[9] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_41      (9)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_41.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_41      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_41.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_41 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_41) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_41)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_41.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_41) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_41 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_41(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_41) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_41(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_42[10] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_42      (10)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_42.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_42      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_42.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_42 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_42) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_42)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_42.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_42) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_42 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_42(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_42) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_42(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_43[11] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_43      (11)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_43.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_43      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_43.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_43 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_43) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_43)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_43.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_43) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_43 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_43(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_43) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_43(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_44[12] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_44      (12)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_44.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_44      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_44.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_44 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_44) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_44)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_44.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_44) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_44 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_44(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_44) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_44(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_45[13] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_45      (13)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_45.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_45      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_45.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_45 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_45) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_45)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_45.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_45) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_45 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_45(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_45) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_45(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_46[14] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_46      (14)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_46.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_46      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_46.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_46 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_46) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_46)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_46.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_46) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_46 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_46(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_46) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_46(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_47[15] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_47      (15)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_47.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_47      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_47.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_47 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_47) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_47)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_47.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_47) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_47 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_47(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_47) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_47(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_48[16] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_48      (16)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_48.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_48      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_48.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_48 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_48) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_48)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_48.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_48) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_48 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_48(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_48) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_48(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_49[17] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_49      (17)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_49.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_49      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_49.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_49 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_49) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_49)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_49.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_49) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_49 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_49(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_49) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_49(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_50[18] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_50      (18)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_50.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_50      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_50.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_50 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_50) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_50)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_50.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_50) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_50 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_50(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_50) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_50(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_51[19] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_51      (19)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_51.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_51      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_51.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_51 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_51) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_51)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_51.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_51) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_51 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_51(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_51) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_51(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_14, field IDMAC_TH_EN_52[20] (RW)
 *
 * Threshold crossing indication of Channel interrupt. This bit is the control Threshold crossing
 * interrupt of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_14_IDMAC_TH_EN_52      (20)      //!< Bit position for IPU_INT_CTRL_14_IDMAC_TH_EN_52.
#define BM_IPU_INT_CTRL_14_IDMAC_TH_EN_52      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_14_IDMAC_TH_EN_52.

//! @brief Get value of IPU_INT_CTRL_14_IDMAC_TH_EN_52 from a register value.
#define BG_IPU_INT_CTRL_14_IDMAC_TH_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_52) >> BP_IPU_INT_CTRL_14_IDMAC_TH_EN_52)

//! @brief Format value for bitfield IPU_INT_CTRL_14_IDMAC_TH_EN_52.
#define BF_IPU_INT_CTRL_14_IDMAC_TH_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_14_IDMAC_TH_EN_52) & BM_IPU_INT_CTRL_14_IDMAC_TH_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_EN_52 field to a new value.
#define BW_IPU_INT_CTRL_14_IDMAC_TH_EN_52(x, v)   (HW_IPU_INT_CTRL_14_WR(x, (HW_IPU_INT_CTRL_14_RD(x) & ~BM_IPU_INT_CTRL_14_IDMAC_TH_EN_52) | BF_IPU_INT_CTRL_14_IDMAC_TH_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_CTRL_15 - Interrupt Control Register15
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_CTRL_15 - Interrupt Control Register15 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU interrupts controls. The controls of general purpose
 * interrupts can be found in this register.
 */
typedef union _hw_ipu_int_ctrl_15
{
    reg32_t U;
    struct _hw_ipu_int_ctrl_15_bitfields
    {
        unsigned SNOOPING1_INT_EN : 1; //!< [0] IPU snooping 1 interrupt enable bit.
        unsigned SNOOPING2_INT_EN : 1; //!< [1] IPU snooping 2 interrupt enable bit.
        unsigned DP_SF_START_EN : 1; //!< [2] DP Sync Flow Start enable bit.
        unsigned DP_SF_END_EN : 1; //!< [3] DP Sync Flow End enable bit.
        unsigned DP_ASF_START_EN : 1; //!< [4] DP Async Flow Start enable bit.
        unsigned DP_ASF_END_EN : 1; //!< [5] DP Async Flow End enable bit.
        unsigned DP_SF_BRAKE_EN : 1; //!< [6] DP Sync Flow Brake enable bit.
        unsigned DP_ASF_BRAKE_EN : 1; //!< [7] DP Async Flow Brake enable bit.
        unsigned DC_FC_0_EN : 1; //!< [8] This bit enables they'd Frame Complete on channel #0 interrupt
        unsigned DC_FC_1_EN : 1; //!< [9] This bit enables they'd Frame Complete on channel #1 interrupt
        unsigned DC_FC_2_EN : 1; //!< [10] This bit enables the DC Frame Complete on channel #2 interrupt
        unsigned DC_FC_3_EN : 1; //!< [11] This bit enables the DC Frame Complete on channel #3 interrupt
        unsigned DC_FC_4_EN : 1; //!< [12] This bit enables the DC Frame Complete on channel #4 interrupt
        unsigned DC_FC_6_EN : 1; //!< [13] This bit enables the DC Frame Complete on channel #6 interrupt
        unsigned DI_VSYNC_PRE_0_EN : 1; //!< [14] This bit enables the DI0 interrupt indicating of a VSYNC signal asserted 2 rows before the VSYNC sent to the display
        unsigned DI_VSYNC_PRE_1_EN : 1; //!< [15] This bit enables the DI1 interrupt indicating of a VSYNC signal asserted 2 rows before the VSYNC sent to the display
        unsigned DC_DP_START_EN : 1; //!< [16] This bit enables the interrupt asserted anytime the DP start a new sync or async flow or when an async flow is interrupted by a sync flow
        unsigned DC_ASYNC_STOP_EN : 1; //!< [17] This bit enables the interrupt asserted anytime the DP stops an async flow and moves to a sync flow
        unsigned DI0_CNT_EN_PRE_0_EN : 1; //!< [18] This bit enables the interrupt that is a result of a trigger generated by counter #0 of DI0
        unsigned DI0_CNT_EN_PRE_1_EN : 1; //!< [19] This bit enables the interrupt that is a result of a trigger generated by counter #1 of DI0
        unsigned DI0_CNT_EN_PRE_2_EN : 1; //!< [20] This bit enables the interrupt that is a result of a trigger generated by counter #2 of DI0
        unsigned DI0_CNT_EN_PRE_3_EN : 1; //!< [21] This bit enables the interrupt that is a result of a trigger generated by counter #3 of DI0
        unsigned DI0_CNT_EN_PRE_4_EN : 1; //!< [22] This bit enables the interrupt that is a result of a trigger generated by counter #4 of DI0
        unsigned DI0_CNT_EN_PRE_5_EN : 1; //!< [23] This bit enables the interrupt that is a result of a trigger generated by counter #5 of DI0
        unsigned DI0_CNT_EN_PRE_6_EN : 1; //!< [24] This bit enables the interrupt that is a result of a trigger generated by counter #6 of DI0
        unsigned DI0_CNT_EN_PRE_7_EN : 1; //!< [25] This bit enables the interrupt that is a result of a trigger generated by counter #7 of DI0
        unsigned DI0_CNT_EN_PRE_8_EN : 1; //!< [26] This bit enables the interrupt that is a result of a trigger generated by counter #8 of DI0
        unsigned DI0_CNT_EN_PRE_9_EN : 1; //!< [27] This bit enables the interrupt that is a result of a trigger generated by counter #9 of DI0
        unsigned DI0_CNT_EN_PRE_10_EN : 1; //!< [28] This bit enables the interrupt that is a result of a trigger generated by counter #10 of DI0
        unsigned DI1_DISP_CLK_EN_PRE_EN : 1; //!< [29] DI1_DISP_CLK_EN_PRE_EN
        unsigned DI1_CNT_EN_PRE_3_EN : 1; //!< [30] This bit enables the interrupt that is a result of a trigger generated by counter #3 of DI1
        unsigned DI1_CNT_EN_PRE_8_EN : 1; //!< [31] This bit enables the interrupt that is a result of a trigger generated by counter #8 of DI1
    } B;
} hw_ipu_int_ctrl_15_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_CTRL_15 register
 */
//@{
#define HW_IPU_INT_CTRL_15_ADDR(x)      (REGS_IPU_BASE(x) + 0x74)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_CTRL_15(x)           (*(volatile hw_ipu_int_ctrl_15_t *) HW_IPU_INT_CTRL_15_ADDR(x))
#define HW_IPU_INT_CTRL_15_RD(x)        (HW_IPU_INT_CTRL_15(x).U)
#define HW_IPU_INT_CTRL_15_WR(x, v)     (HW_IPU_INT_CTRL_15(x).U = (v))
#define HW_IPU_INT_CTRL_15_SET(x, v)    (HW_IPU_INT_CTRL_15_WR(x, HW_IPU_INT_CTRL_15_RD(x) |  (v)))
#define HW_IPU_INT_CTRL_15_CLR(x, v)    (HW_IPU_INT_CTRL_15_WR(x, HW_IPU_INT_CTRL_15_RD(x) & ~(v)))
#define HW_IPU_INT_CTRL_15_TOG(x, v)    (HW_IPU_INT_CTRL_15_WR(x, HW_IPU_INT_CTRL_15_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_CTRL_15 bitfields
 */

/*! @name Register IPU_INT_CTRL_15, field SNOOPING1_INT_EN[0] (RW)
 *
 * IPU snooping 1 interrupt enable bit. This bit enables the interrupt that is a result of the
 * detection of a snooping 1 signal assertion coming to the IPU
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_SNOOPING1_INT_EN      (0)      //!< Bit position for IPU_INT_CTRL_15_SNOOPING1_INT_EN.
#define BM_IPU_INT_CTRL_15_SNOOPING1_INT_EN      (0x00000001)  //!< Bit mask for IPU_INT_CTRL_15_SNOOPING1_INT_EN.

//! @brief Get value of IPU_INT_CTRL_15_SNOOPING1_INT_EN from a register value.
#define BG_IPU_INT_CTRL_15_SNOOPING1_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_SNOOPING1_INT_EN) >> BP_IPU_INT_CTRL_15_SNOOPING1_INT_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_SNOOPING1_INT_EN.
#define BF_IPU_INT_CTRL_15_SNOOPING1_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_SNOOPING1_INT_EN) & BM_IPU_INT_CTRL_15_SNOOPING1_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SNOOPING1_INT_EN field to a new value.
#define BW_IPU_INT_CTRL_15_SNOOPING1_INT_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_SNOOPING1_INT_EN) | BF_IPU_INT_CTRL_15_SNOOPING1_INT_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field SNOOPING2_INT_EN[1] (RW)
 *
 * IPU snooping 2 interrupt enable bit. This bit enables the interrupt that is a result of the
 * detection of a snooping 2 signal assertion coming to the IPU
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_SNOOPING2_INT_EN      (1)      //!< Bit position for IPU_INT_CTRL_15_SNOOPING2_INT_EN.
#define BM_IPU_INT_CTRL_15_SNOOPING2_INT_EN      (0x00000002)  //!< Bit mask for IPU_INT_CTRL_15_SNOOPING2_INT_EN.

//! @brief Get value of IPU_INT_CTRL_15_SNOOPING2_INT_EN from a register value.
#define BG_IPU_INT_CTRL_15_SNOOPING2_INT_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_SNOOPING2_INT_EN) >> BP_IPU_INT_CTRL_15_SNOOPING2_INT_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_SNOOPING2_INT_EN.
#define BF_IPU_INT_CTRL_15_SNOOPING2_INT_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_SNOOPING2_INT_EN) & BM_IPU_INT_CTRL_15_SNOOPING2_INT_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SNOOPING2_INT_EN field to a new value.
#define BW_IPU_INT_CTRL_15_SNOOPING2_INT_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_SNOOPING2_INT_EN) | BF_IPU_INT_CTRL_15_SNOOPING2_INT_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_SF_START_EN[2] (RW)
 *
 * DP Sync Flow Start enable bit. This bit enables the interrupt that is a result of the Sync flow
 * start at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_SF_START_EN      (2)      //!< Bit position for IPU_INT_CTRL_15_DP_SF_START_EN.
#define BM_IPU_INT_CTRL_15_DP_SF_START_EN      (0x00000004)  //!< Bit mask for IPU_INT_CTRL_15_DP_SF_START_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_SF_START_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_SF_START_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_SF_START_EN) >> BP_IPU_INT_CTRL_15_DP_SF_START_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_SF_START_EN.
#define BF_IPU_INT_CTRL_15_DP_SF_START_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_SF_START_EN) & BM_IPU_INT_CTRL_15_DP_SF_START_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SF_START_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_SF_START_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_SF_START_EN) | BF_IPU_INT_CTRL_15_DP_SF_START_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_SF_END_EN[3] (RW)
 *
 * DP Sync Flow End enable bit. This bit enables the interrupt that is a result of the Sync flow end
 * at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_SF_END_EN      (3)      //!< Bit position for IPU_INT_CTRL_15_DP_SF_END_EN.
#define BM_IPU_INT_CTRL_15_DP_SF_END_EN      (0x00000008)  //!< Bit mask for IPU_INT_CTRL_15_DP_SF_END_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_SF_END_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_SF_END_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_SF_END_EN) >> BP_IPU_INT_CTRL_15_DP_SF_END_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_SF_END_EN.
#define BF_IPU_INT_CTRL_15_DP_SF_END_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_SF_END_EN) & BM_IPU_INT_CTRL_15_DP_SF_END_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SF_END_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_SF_END_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_SF_END_EN) | BF_IPU_INT_CTRL_15_DP_SF_END_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_ASF_START_EN[4] (RW)
 *
 * DP Async Flow Start enable bit. This bit enables the interrupt that is a result of the Async flow
 * start at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_ASF_START_EN      (4)      //!< Bit position for IPU_INT_CTRL_15_DP_ASF_START_EN.
#define BM_IPU_INT_CTRL_15_DP_ASF_START_EN      (0x00000010)  //!< Bit mask for IPU_INT_CTRL_15_DP_ASF_START_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_ASF_START_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_ASF_START_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_ASF_START_EN) >> BP_IPU_INT_CTRL_15_DP_ASF_START_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_ASF_START_EN.
#define BF_IPU_INT_CTRL_15_DP_ASF_START_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_ASF_START_EN) & BM_IPU_INT_CTRL_15_DP_ASF_START_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASF_START_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_ASF_START_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_ASF_START_EN) | BF_IPU_INT_CTRL_15_DP_ASF_START_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_ASF_END_EN[5] (RW)
 *
 * DP Async Flow End enable bit. This bit enables the interrupt that is a result of the Async flow
 * end at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_ASF_END_EN      (5)      //!< Bit position for IPU_INT_CTRL_15_DP_ASF_END_EN.
#define BM_IPU_INT_CTRL_15_DP_ASF_END_EN      (0x00000020)  //!< Bit mask for IPU_INT_CTRL_15_DP_ASF_END_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_ASF_END_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_ASF_END_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_ASF_END_EN) >> BP_IPU_INT_CTRL_15_DP_ASF_END_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_ASF_END_EN.
#define BF_IPU_INT_CTRL_15_DP_ASF_END_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_ASF_END_EN) & BM_IPU_INT_CTRL_15_DP_ASF_END_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASF_END_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_ASF_END_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_ASF_END_EN) | BF_IPU_INT_CTRL_15_DP_ASF_END_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_SF_BRAKE_EN[6] (RW)
 *
 * DP Sync Flow Brake enable bit. This bit enables the interrupt that is a result of the Sync flow
 * brake at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_SF_BRAKE_EN      (6)      //!< Bit position for IPU_INT_CTRL_15_DP_SF_BRAKE_EN.
#define BM_IPU_INT_CTRL_15_DP_SF_BRAKE_EN      (0x00000040)  //!< Bit mask for IPU_INT_CTRL_15_DP_SF_BRAKE_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_SF_BRAKE_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_SF_BRAKE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_SF_BRAKE_EN) >> BP_IPU_INT_CTRL_15_DP_SF_BRAKE_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_SF_BRAKE_EN.
#define BF_IPU_INT_CTRL_15_DP_SF_BRAKE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_SF_BRAKE_EN) & BM_IPU_INT_CTRL_15_DP_SF_BRAKE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SF_BRAKE_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_SF_BRAKE_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_SF_BRAKE_EN) | BF_IPU_INT_CTRL_15_DP_SF_BRAKE_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DP_ASF_BRAKE_EN[7] (RW)
 *
 * DP Async Flow Brake enable bit. This bit enables the interrupt that is a result of the async flow
 * brake at the DP
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN      (7)      //!< Bit position for IPU_INT_CTRL_15_DP_ASF_BRAKE_EN.
#define BM_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN      (0x00000080)  //!< Bit mask for IPU_INT_CTRL_15_DP_ASF_BRAKE_EN.

//! @brief Get value of IPU_INT_CTRL_15_DP_ASF_BRAKE_EN from a register value.
#define BG_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN) >> BP_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DP_ASF_BRAKE_EN.
#define BF_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN) & BM_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASF_BRAKE_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN) | BF_IPU_INT_CTRL_15_DP_ASF_BRAKE_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_0_EN[8] (RW)
 *
 * This bit enables they'd Frame Complete on channel #0 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_0_EN      (8)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_0_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_0_EN      (0x00000100)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_0_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_0_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_0_EN) >> BP_IPU_INT_CTRL_15_DC_FC_0_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_0_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_0_EN) & BM_IPU_INT_CTRL_15_DC_FC_0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_0_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_0_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_0_EN) | BF_IPU_INT_CTRL_15_DC_FC_0_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_1_EN[9] (RW)
 *
 * This bit enables they'd Frame Complete on channel #1 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_1_EN      (9)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_1_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_1_EN      (0x00000200)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_1_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_1_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_1_EN) >> BP_IPU_INT_CTRL_15_DC_FC_1_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_1_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_1_EN) & BM_IPU_INT_CTRL_15_DC_FC_1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_1_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_1_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_1_EN) | BF_IPU_INT_CTRL_15_DC_FC_1_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_2_EN[10] (RW)
 *
 * This bit enables the DC Frame Complete on channel #2 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_2_EN      (10)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_2_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_2_EN      (0x00000400)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_2_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_2_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_2_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_2_EN) >> BP_IPU_INT_CTRL_15_DC_FC_2_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_2_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_2_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_2_EN) & BM_IPU_INT_CTRL_15_DC_FC_2_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_2_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_2_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_2_EN) | BF_IPU_INT_CTRL_15_DC_FC_2_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_3_EN[11] (RW)
 *
 * This bit enables the DC Frame Complete on channel #3 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_3_EN      (11)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_3_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_3_EN      (0x00000800)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_3_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_3_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_3_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_3_EN) >> BP_IPU_INT_CTRL_15_DC_FC_3_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_3_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_3_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_3_EN) & BM_IPU_INT_CTRL_15_DC_FC_3_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_3_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_3_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_3_EN) | BF_IPU_INT_CTRL_15_DC_FC_3_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_4_EN[12] (RW)
 *
 * This bit enables the DC Frame Complete on channel #4 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_4_EN      (12)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_4_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_4_EN      (0x00001000)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_4_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_4_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_4_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_4_EN) >> BP_IPU_INT_CTRL_15_DC_FC_4_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_4_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_4_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_4_EN) & BM_IPU_INT_CTRL_15_DC_FC_4_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_4_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_4_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_4_EN) | BF_IPU_INT_CTRL_15_DC_FC_4_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_FC_6_EN[13] (RW)
 *
 * This bit enables the DC Frame Complete on channel #6 interrupt
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_FC_6_EN      (13)      //!< Bit position for IPU_INT_CTRL_15_DC_FC_6_EN.
#define BM_IPU_INT_CTRL_15_DC_FC_6_EN      (0x00002000)  //!< Bit mask for IPU_INT_CTRL_15_DC_FC_6_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_FC_6_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_FC_6_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_FC_6_EN) >> BP_IPU_INT_CTRL_15_DC_FC_6_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_FC_6_EN.
#define BF_IPU_INT_CTRL_15_DC_FC_6_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_FC_6_EN) & BM_IPU_INT_CTRL_15_DC_FC_6_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_FC_6_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_FC_6_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_FC_6_EN) | BF_IPU_INT_CTRL_15_DC_FC_6_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI_VSYNC_PRE_0_EN[14] (RW)
 *
 * This bit enables the DI0 interrupt indicating of a VSYNC signal asserted 2 rows before the VSYNC
 * sent to the display
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN      (14)      //!< Bit position for IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN.
#define BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN      (0x00004000)  //!< Bit mask for IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN) >> BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN.
#define BF_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN) & BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI_VSYNC_PRE_0_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN) | BF_IPU_INT_CTRL_15_DI_VSYNC_PRE_0_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI_VSYNC_PRE_1_EN[15] (RW)
 *
 * This bit enables the DI1 interrupt indicating of a VSYNC signal asserted 2 rows before the VSYNC
 * sent to the display
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN      (15)      //!< Bit position for IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN.
#define BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN      (0x00008000)  //!< Bit mask for IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN) >> BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN.
#define BF_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN) & BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI_VSYNC_PRE_1_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN) | BF_IPU_INT_CTRL_15_DI_VSYNC_PRE_1_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_DP_START_EN[16] (RW)
 *
 * This bit enables the interrupt asserted anytime the DP start a new sync or async flow or when an
 * async flow is interrupted by a sync flow
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_DP_START_EN      (16)      //!< Bit position for IPU_INT_CTRL_15_DC_DP_START_EN.
#define BM_IPU_INT_CTRL_15_DC_DP_START_EN      (0x00010000)  //!< Bit mask for IPU_INT_CTRL_15_DC_DP_START_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_DP_START_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_DP_START_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_DP_START_EN) >> BP_IPU_INT_CTRL_15_DC_DP_START_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_DP_START_EN.
#define BF_IPU_INT_CTRL_15_DC_DP_START_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_DP_START_EN) & BM_IPU_INT_CTRL_15_DC_DP_START_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_DP_START_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_DP_START_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_DP_START_EN) | BF_IPU_INT_CTRL_15_DC_DP_START_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DC_ASYNC_STOP_EN[17] (RW)
 *
 * This bit enables the interrupt asserted anytime the DP stops an async flow and moves to a sync
 * flow
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN      (17)      //!< Bit position for IPU_INT_CTRL_15_DC_ASYNC_STOP_EN.
#define BM_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN      (0x00020000)  //!< Bit mask for IPU_INT_CTRL_15_DC_ASYNC_STOP_EN.

//! @brief Get value of IPU_INT_CTRL_15_DC_ASYNC_STOP_EN from a register value.
#define BG_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN) >> BP_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DC_ASYNC_STOP_EN.
#define BF_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN) & BM_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_ASYNC_STOP_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN) | BF_IPU_INT_CTRL_15_DC_ASYNC_STOP_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_0_EN[18] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #0 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN      (18)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN      (0x00040000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_0_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_0_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_1_EN[19] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #1 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN      (19)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN      (0x00080000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_1_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_1_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_2_EN[20] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #2 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN      (20)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN      (0x00100000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_2_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_2_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_3_EN[21] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #3 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN      (21)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN      (0x00200000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_3_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_3_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_4_EN[22] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #4 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN      (22)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN      (0x00400000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_4_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_4_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_5_EN[23] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #5 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN      (23)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN      (0x00800000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_5_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_5_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_6_EN[24] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #6 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN      (24)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN      (0x01000000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_6_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_6_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_7_EN[25] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #7 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN      (25)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN      (0x02000000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_7_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_7_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_8_EN[26] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #8 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN      (26)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN      (0x04000000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_8_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_8_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_9_EN[27] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #9 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN      (27)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN      (0x08000000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_9_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_9_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI0_CNT_EN_PRE_10_EN[28] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #10 of DI0
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN      (28)      //!< Bit position for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN.
#define BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN      (0x10000000)  //!< Bit mask for IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN) >> BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN.
#define BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN) & BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CNT_EN_PRE_10_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN) | BF_IPU_INT_CTRL_15_DI0_CNT_EN_PRE_10_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI1_DISP_CLK_EN_PRE_EN[29] (RW)
 *
 * DI1_DISP_CLK_EN_PRE_EN
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN      (29)      //!< Bit position for IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN.
#define BM_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN      (0x20000000)  //!< Bit mask for IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN) >> BP_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN.
#define BF_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN) & BM_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_DISP_CLK_EN_PRE_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN) | BF_IPU_INT_CTRL_15_DI1_DISP_CLK_EN_PRE_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI1_CNT_EN_PRE_3_EN[30] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #3 of DI1
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN      (30)      //!< Bit position for IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN.
#define BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN      (0x40000000)  //!< Bit mask for IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN) >> BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN.
#define BF_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN) & BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_CNT_EN_PRE_3_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN) | BF_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_3_EN(v)))
#endif
//@}

/*! @name Register IPU_INT_CTRL_15, field DI1_CNT_EN_PRE_8_EN[31] (RW)
 *
 * This bit enables the interrupt that is a result of a trigger generated by counter #8 of DI1
 *
 * Values:
 * - 0 - Interrupt is disabled.
 * - 1 - Interrupt is enabled.
 */
//@{
#define BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN      (31)      //!< Bit position for IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN.
#define BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN      (0x80000000)  //!< Bit mask for IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN.

//! @brief Get value of IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN from a register value.
#define BG_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN) >> BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN)

//! @brief Format value for bitfield IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN.
#define BF_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN) & BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_CNT_EN_PRE_8_EN field to a new value.
#define BW_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN(x, v)   (HW_IPU_INT_CTRL_15_WR(x, (HW_IPU_INT_CTRL_15_RD(x) & ~BM_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN) | BF_IPU_INT_CTRL_15_DI1_CNT_EN_PRE_8_EN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_1 - SDMA Event Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_1 - SDMA Event Control Register 1 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOF (end of frame) of
 * DMA Channels SDMA events [31:0] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_1
{
    reg32_t U;
    struct _hw_ipu_sdma_event_1_bitfields
    {
        unsigned IDMAC_EOF_SDMA_EN_0 : 1; //!< [0] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_1 : 1; //!< [1] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_2 : 1; //!< [2] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_3 : 1; //!< [3] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_5 : 1; //!< [5] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_8 : 1; //!< [8] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_9 : 1; //!< [9] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_10 : 1; //!< [10] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_11 : 1; //!< [11] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_12 : 1; //!< [12] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_13 : 1; //!< [13] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_14 : 1; //!< [14] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_15 : 1; //!< [15] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_17 : 1; //!< [17] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_18 : 1; //!< [18] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_19 : 1; //!< [19] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_20 : 1; //!< [20] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_21 : 1; //!< [21] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_22 : 1; //!< [22] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_23 : 1; //!< [23] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_24 : 1; //!< [24] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_25 : 1; //!< [25] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_26 : 1; //!< [26] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_27 : 1; //!< [27] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_28 : 1; //!< [28] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_29 : 1; //!< [29] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_31 : 1; //!< [31] Enable End of Frame of Channel SDMA event.
    } B;
} hw_ipu_sdma_event_1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_1 register
 */
//@{
#define HW_IPU_SDMA_EVENT_1_ADDR(x)      (REGS_IPU_BASE(x) + 0x78)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_1(x)           (*(volatile hw_ipu_sdma_event_1_t *) HW_IPU_SDMA_EVENT_1_ADDR(x))
#define HW_IPU_SDMA_EVENT_1_RD(x)        (HW_IPU_SDMA_EVENT_1(x).U)
#define HW_IPU_SDMA_EVENT_1_WR(x, v)     (HW_IPU_SDMA_EVENT_1(x).U = (v))
#define HW_IPU_SDMA_EVENT_1_SET(x, v)    (HW_IPU_SDMA_EVENT_1_WR(x, HW_IPU_SDMA_EVENT_1_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_1_CLR(x, v)    (HW_IPU_SDMA_EVENT_1_WR(x, HW_IPU_SDMA_EVENT_1_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_1_TOG(x, v)    (HW_IPU_SDMA_EVENT_1_WR(x, HW_IPU_SDMA_EVENT_1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_1 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_0[0] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0      (0)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0      (0x00000001)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_0 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_0(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_1[1] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1      (1)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_1 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_1(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_2[2] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2      (2)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2      (0x00000004)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_2 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_2(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_3[3] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3      (3)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3      (0x00000008)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_3 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_3(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_5[5] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5      (5)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5      (0x00000020)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_5 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_5(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_8[8] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8      (8)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_8 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_8(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_9[9] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9      (9)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_9 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_9(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_10[10] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10      (10)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_10 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_10(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_11[11] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11      (11)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_11 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_11(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_12[12] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12      (12)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_12 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_12(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_13[13] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13      (13)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_13 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_13(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_14[14] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14      (14)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_14 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_14(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_15[15] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15      (15)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_15 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_15(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_17[17] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17      (17)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_17 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_17(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_18[18] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18      (18)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_18 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_18(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_19[19] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19      (19)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_19 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_19(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_20[20] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20      (20)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_20 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_20(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_21[21] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21      (21)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21      (0x00200000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_21 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_21(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_22[22] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22      (22)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22      (0x00400000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_22 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_22(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_23[23] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23      (23)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23      (0x00800000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_23 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_23(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_24[24] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24      (24)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24      (0x01000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_24 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_24(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_25[25] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25      (25)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25      (0x02000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_25 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_25(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_26[26] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26      (26)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26      (0x04000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_26 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_26(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_27[27] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27      (27)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27      (0x08000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_27 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_27(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_28[28] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28      (28)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28      (0x10000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_28 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_28(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_29[29] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29      (29)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29      (0x20000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_29 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_29(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_1, field IDMAC_EOF_SDMA_EN_31[31] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31      (31)      //!< Bit position for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31.
#define BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31      (0x80000000)  //!< Bit mask for IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31.

//! @brief Get value of IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31 from a register value.
#define BG_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31) >> BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31)

//! @brief Format value for bitfield IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31.
#define BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31) & BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_31 field to a new value.
#define BW_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31(x, v)   (HW_IPU_SDMA_EVENT_1_WR(x, (HW_IPU_SDMA_EVENT_1_RD(x) & ~BM_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31) | BF_IPU_SDMA_EVENT_1_IDMAC_EOF_SDMA_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_2 - SDMA Event Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_2 - SDMA Event Control Register 2 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOF (end of frame) of
 * DMA Channels SDMA events [63:32] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_2
{
    reg32_t U;
    struct _hw_ipu_sdma_event_2_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_33 : 1; //!< [1] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_EOF_SDMA_EN_40 : 1; //!< [8] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_41 : 1; //!< [9] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_42 : 1; //!< [10] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_43 : 1; //!< [11] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_44 : 1; //!< [12] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_45 : 1; //!< [13] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_46 : 1; //!< [14] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_47 : 1; //!< [15] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_48 : 1; //!< [16] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_49 : 1; //!< [17] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_50 : 1; //!< [18] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_51 : 1; //!< [19] Enable End of Frame of Channel SDMA event.
        unsigned IDMAC_EOF_SDMA_EN_52 : 1; //!< [20] Enable End of Frame of Channel SDMA event.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_sdma_event_2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_2 register
 */
//@{
#define HW_IPU_SDMA_EVENT_2_ADDR(x)      (REGS_IPU_BASE(x) + 0x7c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_2(x)           (*(volatile hw_ipu_sdma_event_2_t *) HW_IPU_SDMA_EVENT_2_ADDR(x))
#define HW_IPU_SDMA_EVENT_2_RD(x)        (HW_IPU_SDMA_EVENT_2(x).U)
#define HW_IPU_SDMA_EVENT_2_WR(x, v)     (HW_IPU_SDMA_EVENT_2(x).U = (v))
#define HW_IPU_SDMA_EVENT_2_SET(x, v)    (HW_IPU_SDMA_EVENT_2_WR(x, HW_IPU_SDMA_EVENT_2_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_2_CLR(x, v)    (HW_IPU_SDMA_EVENT_2_WR(x, HW_IPU_SDMA_EVENT_2_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_2_TOG(x, v)    (HW_IPU_SDMA_EVENT_2_WR(x, HW_IPU_SDMA_EVENT_2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_2 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_33[1] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33      (1)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_33 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_33(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_40[8] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40      (8)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_40 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_40(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_41[9] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41      (9)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_41 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_41(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_42[10] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42      (10)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_42 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_42(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_43[11] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43      (11)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_43 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_43(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_44[12] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44      (12)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_44 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_44(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_45[13] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45      (13)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_45 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_45(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_46[14] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46      (14)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_46 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_46(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_47[15] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47      (15)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_47 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_47(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_48[16] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48      (16)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48      (0x00010000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_48 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_48(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_49[17] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49      (17)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_49 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_49(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_50[18] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50      (18)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_50 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_50(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_51[19] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51      (19)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_51 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_51(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_2, field IDMAC_EOF_SDMA_EN_52[20] (RW)
 *
 * Enable End of Frame of Channel SDMA event. This bit is the control of End Of Frame of Channel #n.
 * n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52      (20)      //!< Bit position for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52.
#define BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52.

//! @brief Get value of IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52 from a register value.
#define BG_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52) >> BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52)

//! @brief Format value for bitfield IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52.
#define BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52) & BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_SDMA_EN_52 field to a new value.
#define BW_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52(x, v)   (HW_IPU_SDMA_EVENT_2_WR(x, (HW_IPU_SDMA_EVENT_2_RD(x) & ~BM_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52) | BF_IPU_SDMA_EVENT_2_IDMAC_EOF_SDMA_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_3 - SDMA Event Control Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_3 - SDMA Event Control Register 3 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of NFACK (New Frame
 * Acknowledge) of DMA Channels SDMA events [31:0] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_3
{
    reg32_t U;
    struct _hw_ipu_sdma_event_3_bitfields
    {
        unsigned IDMAC_NFACK_SDMA_EN_0 : 1; //!< [0] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_1 : 1; //!< [1] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_2 : 1; //!< [2] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_3 : 1; //!< [3] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_5 : 1; //!< [5] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_8 : 1; //!< [8] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_9 : 1; //!< [9] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_10 : 1; //!< [10] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_11 : 1; //!< [11] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_12 : 1; //!< [12] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_13 : 1; //!< [13] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_14 : 1; //!< [14] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_15 : 1; //!< [15] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_17 : 1; //!< [17] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_18 : 1; //!< [18] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_19 : 1; //!< [19] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_20 : 1; //!< [20] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_21 : 1; //!< [21] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_22 : 1; //!< [22] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_23 : 1; //!< [23] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_24 : 1; //!< [24] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_25 : 1; //!< [25] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_26 : 1; //!< [26] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_27 : 1; //!< [27] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_28 : 1; //!< [28] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_29 : 1; //!< [29] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_31 : 1; //!< [31] Enable New Frame Acknowledge of Channel SDMA event.
    } B;
} hw_ipu_sdma_event_3_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_3 register
 */
//@{
#define HW_IPU_SDMA_EVENT_3_ADDR(x)      (REGS_IPU_BASE(x) + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_3(x)           (*(volatile hw_ipu_sdma_event_3_t *) HW_IPU_SDMA_EVENT_3_ADDR(x))
#define HW_IPU_SDMA_EVENT_3_RD(x)        (HW_IPU_SDMA_EVENT_3(x).U)
#define HW_IPU_SDMA_EVENT_3_WR(x, v)     (HW_IPU_SDMA_EVENT_3(x).U = (v))
#define HW_IPU_SDMA_EVENT_3_SET(x, v)    (HW_IPU_SDMA_EVENT_3_WR(x, HW_IPU_SDMA_EVENT_3_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_3_CLR(x, v)    (HW_IPU_SDMA_EVENT_3_WR(x, HW_IPU_SDMA_EVENT_3_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_3_TOG(x, v)    (HW_IPU_SDMA_EVENT_3_WR(x, HW_IPU_SDMA_EVENT_3_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_3 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_0[0] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0      (0)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0      (0x00000001)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_0 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_0(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_1[1] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1      (1)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_1 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_1(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_2[2] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2      (2)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2      (0x00000004)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_2 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_2(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_3[3] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3      (3)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3      (0x00000008)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_3 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_3(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_5[5] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5      (5)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5      (0x00000020)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_5 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_5(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_8[8] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8      (8)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_8 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_8(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_9[9] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9      (9)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_9 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_9(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_10[10] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10      (10)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_10 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_10(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_11[11] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11      (11)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_11 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_11(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_12[12] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12      (12)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_12 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_12(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_13[13] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13      (13)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_13 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_13(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_14[14] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14      (14)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_14 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_14(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_15[15] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15      (15)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_15 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_15(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_17[17] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17      (17)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_17 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_17(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_18[18] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18      (18)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_18 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_18(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_19[19] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19      (19)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_19 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_19(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_20[20] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20      (20)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_20 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_20(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_21[21] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21      (21)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21      (0x00200000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_21 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_21(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_22[22] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22      (22)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22      (0x00400000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_22 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_22(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_23[23] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23      (23)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23      (0x00800000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_23 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_23(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_24[24] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24      (24)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24      (0x01000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_24 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_24(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_25[25] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25      (25)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25      (0x02000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_25 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_25(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_26[26] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26      (26)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26      (0x04000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_26 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_26(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_27[27] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27      (27)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27      (0x08000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_27 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_27(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_28[28] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28      (28)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28      (0x10000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_28 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_28(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_29[29] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29      (29)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29      (0x20000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_29 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_29(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_3, field IDMAC_NFACK_SDMA_EN_31[31] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31      (31)      //!< Bit position for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31.
#define BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31      (0x80000000)  //!< Bit mask for IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31.

//! @brief Get value of IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31 from a register value.
#define BG_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31) >> BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31)

//! @brief Format value for bitfield IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31.
#define BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31) & BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_31 field to a new value.
#define BW_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31(x, v)   (HW_IPU_SDMA_EVENT_3_WR(x, (HW_IPU_SDMA_EVENT_3_RD(x) & ~BM_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31) | BF_IPU_SDMA_EVENT_3_IDMAC_NFACK_SDMA_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_4 - SDMA Event Control Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_4 - SDMA Event Control Register 4 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of NFACK (New Frame
 * Acknowledge) of DMA Channels SDMA events [63:32] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_4
{
    reg32_t U;
    struct _hw_ipu_sdma_event_4_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_33 : 1; //!< [1] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_NFACK_SDMA_EN_40 : 1; //!< [8] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_41 : 1; //!< [9] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_42 : 1; //!< [10] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_43 : 1; //!< [11] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_44 : 1; //!< [12] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_45 : 1; //!< [13] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_46 : 1; //!< [14] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_47 : 1; //!< [15] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_48 : 1; //!< [16] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_49 : 1; //!< [17] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_50 : 1; //!< [18] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_51 : 1; //!< [19] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned IDMAC_NFACK_SDMA_EN_52 : 1; //!< [20] Enable New Frame Acknowledge of Channel SDMA event.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_sdma_event_4_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_4 register
 */
//@{
#define HW_IPU_SDMA_EVENT_4_ADDR(x)      (REGS_IPU_BASE(x) + 0x84)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_4(x)           (*(volatile hw_ipu_sdma_event_4_t *) HW_IPU_SDMA_EVENT_4_ADDR(x))
#define HW_IPU_SDMA_EVENT_4_RD(x)        (HW_IPU_SDMA_EVENT_4(x).U)
#define HW_IPU_SDMA_EVENT_4_WR(x, v)     (HW_IPU_SDMA_EVENT_4(x).U = (v))
#define HW_IPU_SDMA_EVENT_4_SET(x, v)    (HW_IPU_SDMA_EVENT_4_WR(x, HW_IPU_SDMA_EVENT_4_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_4_CLR(x, v)    (HW_IPU_SDMA_EVENT_4_WR(x, HW_IPU_SDMA_EVENT_4_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_4_TOG(x, v)    (HW_IPU_SDMA_EVENT_4_WR(x, HW_IPU_SDMA_EVENT_4_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_4 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_33[1] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33      (1)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_33 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_33(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_40[8] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40      (8)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_40 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_40(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_41[9] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41      (9)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_41 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_41(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_42[10] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42      (10)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_42 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_42(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_43[11] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43      (11)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_43 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_43(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_44[12] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44      (12)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_44 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_44(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_45[13] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45      (13)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_45 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_45(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_46[14] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46      (14)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_46 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_46(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_47[15] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47      (15)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_47 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_47(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_48[16] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48      (16)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48      (0x00010000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_48 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_48(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_49[17] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49      (17)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_49 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_49(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_50[18] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50      (18)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_50 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_50(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_51[19] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51      (19)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_51 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_51(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_4, field IDMAC_NFACK_SDMA_EN_52[20] (RW)
 *
 * Enable New Frame Acknowledge of Channel SDMA event. This bit is the control of New Frame
 * Acknowledge of Channel #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52      (20)      //!< Bit position for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52.
#define BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52.

//! @brief Get value of IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52 from a register value.
#define BG_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52) >> BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52)

//! @brief Format value for bitfield IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52.
#define BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52) & BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_NFACK_SDMA_EN_52 field to a new value.
#define BW_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52(x, v)   (HW_IPU_SDMA_EVENT_4_WR(x, (HW_IPU_SDMA_EVENT_4_RD(x) & ~BM_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52) | BF_IPU_SDMA_EVENT_4_IDMAC_NFACK_SDMA_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_7 - SDMA Event Control Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_7 - SDMA Event Control Register 7 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOS (End of Scroll) of
 * DMA Channels SDMA events [31:0] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_7
{
    reg32_t U;
    struct _hw_ipu_sdma_event_7_bitfields
    {
        unsigned RESERVED0 : 19; //!< [18:0] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_19 : 1; //!< [19] Enable End of Scroll of Channel SDMA event.
        unsigned RESERVED1 : 3; //!< [22:20] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_23 : 1; //!< [23] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_24 : 1; //!< [24] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_25 : 1; //!< [25] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_26 : 1; //!< [26] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_27 : 1; //!< [27] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_28 : 1; //!< [28] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_29 : 1; //!< [29] Enable End of Scroll of Channel SDMA event.
        unsigned RESERVED2 : 1; //!< [30] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_31 : 1; //!< [31] Enable End of Scroll of Channel SDMA event.
    } B;
} hw_ipu_sdma_event_7_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_7 register
 */
//@{
#define HW_IPU_SDMA_EVENT_7_ADDR(x)      (REGS_IPU_BASE(x) + 0x88)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_7(x)           (*(volatile hw_ipu_sdma_event_7_t *) HW_IPU_SDMA_EVENT_7_ADDR(x))
#define HW_IPU_SDMA_EVENT_7_RD(x)        (HW_IPU_SDMA_EVENT_7(x).U)
#define HW_IPU_SDMA_EVENT_7_WR(x, v)     (HW_IPU_SDMA_EVENT_7(x).U = (v))
#define HW_IPU_SDMA_EVENT_7_SET(x, v)    (HW_IPU_SDMA_EVENT_7_WR(x, HW_IPU_SDMA_EVENT_7_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_7_CLR(x, v)    (HW_IPU_SDMA_EVENT_7_WR(x, HW_IPU_SDMA_EVENT_7_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_7_TOG(x, v)    (HW_IPU_SDMA_EVENT_7_WR(x, HW_IPU_SDMA_EVENT_7_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_7 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_19[19] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19      (19)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_19 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_19(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_23[23] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23      (23)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23      (0x00800000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_23 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_23(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_24[24] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24      (24)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24      (0x01000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_24 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_24(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_25[25] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25      (25)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25      (0x02000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_25 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_25(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_26[26] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26      (26)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26      (0x04000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_26 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_26(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_27[27] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27      (27)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27      (0x08000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_27 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_27(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_28[28] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28      (28)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28      (0x10000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_28 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_28(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_29[29] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29      (29)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29      (0x20000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_29 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_29(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_7, field IDMAC_EOS_SDMA_EN_31[31] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31      (31)      //!< Bit position for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31.
#define BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31      (0x80000000)  //!< Bit mask for IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31.

//! @brief Get value of IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31 from a register value.
#define BG_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31) >> BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31)

//! @brief Format value for bitfield IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31.
#define BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31) & BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_31 field to a new value.
#define BW_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31(x, v)   (HW_IPU_SDMA_EVENT_7_WR(x, (HW_IPU_SDMA_EVENT_7_RD(x) & ~BM_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31) | BF_IPU_SDMA_EVENT_7_IDMAC_EOS_SDMA_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_8 - SDMA Event Control Register 8
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_8 - SDMA Event Control Register 8 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOS (End of Scroll) of
 * DMA Channels SDMA events [63:32] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_8
{
    reg32_t U;
    struct _hw_ipu_sdma_event_8_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_33 : 1; //!< [1] Enable End of Scroll of Channel SDMA event.
        unsigned RESERVED1 : 7; //!< [8:2] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_41 : 1; //!< [9] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_42 : 1; //!< [10] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_43 : 1; //!< [11] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_44 : 1; //!< [12] Enable End of Scroll of Channel SDMA event.
        unsigned RESERVED2 : 6; //!< [18:13] Reserved.
        unsigned IDMAC_EOS_SDMA_EN_51 : 1; //!< [19] Enable End of Scroll of Channel SDMA event.
        unsigned IDMAC_EOS_SDMA_EN_52 : 1; //!< [20] Enable End of Scroll of Channel SDMA event.
        unsigned RESERVED3 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_sdma_event_8_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_8 register
 */
//@{
#define HW_IPU_SDMA_EVENT_8_ADDR(x)      (REGS_IPU_BASE(x) + 0x8c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_8(x)           (*(volatile hw_ipu_sdma_event_8_t *) HW_IPU_SDMA_EVENT_8_ADDR(x))
#define HW_IPU_SDMA_EVENT_8_RD(x)        (HW_IPU_SDMA_EVENT_8(x).U)
#define HW_IPU_SDMA_EVENT_8_WR(x, v)     (HW_IPU_SDMA_EVENT_8(x).U = (v))
#define HW_IPU_SDMA_EVENT_8_SET(x, v)    (HW_IPU_SDMA_EVENT_8_WR(x, HW_IPU_SDMA_EVENT_8_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_8_CLR(x, v)    (HW_IPU_SDMA_EVENT_8_WR(x, HW_IPU_SDMA_EVENT_8_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_8_TOG(x, v)    (HW_IPU_SDMA_EVENT_8_WR(x, HW_IPU_SDMA_EVENT_8_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_8 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_33[1] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33      (1)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_33 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_33(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_41[9] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41      (9)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_41 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_41(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_42[10] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42      (10)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_42 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_42(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_43[11] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43      (11)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_43 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_43(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_44[12] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44      (12)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_44 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_44(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_51[19] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51      (19)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_51 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_51(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_8, field IDMAC_EOS_SDMA_EN_52[20] (RW)
 *
 * Enable End of Scroll of Channel SDMA event. This bit is the control of End Of Scroll of Channel
 * #n. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52      (20)      //!< Bit position for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52.
#define BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52.

//! @brief Get value of IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52 from a register value.
#define BG_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52) >> BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52)

//! @brief Format value for bitfield IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52.
#define BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52) & BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOS_SDMA_EN_52 field to a new value.
#define BW_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52(x, v)   (HW_IPU_SDMA_EVENT_8_WR(x, (HW_IPU_SDMA_EVENT_8_RD(x) & ~BM_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52) | BF_IPU_SDMA_EVENT_8_IDMAC_EOS_SDMA_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_11 - SDMA Event Control Register 11
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_11 - SDMA Event Control Register 11 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOBND (End of Band) of
 * DMA Channels SDMA events [31:0] can be found in this register. Hide VDOA_SYNC for all versions
 * Show VDOA_SYNC for IPUv3H version. The table below tagged with other settings (like IPU3M_only)
 * should be hidden in IPUv3H version.
 */
typedef union _hw_ipu_sdma_event_11
{
    reg32_t U;
    struct _hw_ipu_sdma_event_11_bitfields
    {
        unsigned IDMAC_EOBND_SDMA_EN_0 : 1; //!< [0] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_1 : 1; //!< [1] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_2 : 1; //!< [2] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_3 : 1; //!< [3] Enable End of Band of Channel SDMA event.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_EOBND_SDMA_EN_5 : 1; //!< [5] Enable End of Band of Channel SDMA event.
        unsigned RESERVED1 : 5; //!< [10:6] Reserved.
        unsigned IDMAC_EOBND_SDMA_EN_11 : 1; //!< [11] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_12 : 1; //!< [12] Enable End of Band of Channel SDMA event.
        unsigned RESERVED2 : 7; //!< [19:13] Reserved.
        unsigned IDMAC_EOBND_SDMA_EN_20 : 1; //!< [20] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_21 : 1; //!< [21] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_22 : 1; //!< [22] Enable End of Band of Channel SDMA event.
        unsigned RESERVED3 : 2; //!< [24:23] Reserved.
        unsigned IDMAC_EOBND_SDMA_EN_25 : 1; //!< [25] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_26 : 1; //!< [26] Enable End of Band of Channel SDMA event.
        unsigned RESERVED4 : 5; //!< [31:27] Reserved.
    } B;
} hw_ipu_sdma_event_11_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_11 register
 */
//@{
#define HW_IPU_SDMA_EVENT_11_ADDR(x)      (REGS_IPU_BASE(x) + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_11(x)           (*(volatile hw_ipu_sdma_event_11_t *) HW_IPU_SDMA_EVENT_11_ADDR(x))
#define HW_IPU_SDMA_EVENT_11_RD(x)        (HW_IPU_SDMA_EVENT_11(x).U)
#define HW_IPU_SDMA_EVENT_11_WR(x, v)     (HW_IPU_SDMA_EVENT_11(x).U = (v))
#define HW_IPU_SDMA_EVENT_11_SET(x, v)    (HW_IPU_SDMA_EVENT_11_WR(x, HW_IPU_SDMA_EVENT_11_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_11_CLR(x, v)    (HW_IPU_SDMA_EVENT_11_WR(x, HW_IPU_SDMA_EVENT_11_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_11_TOG(x, v)    (HW_IPU_SDMA_EVENT_11_WR(x, HW_IPU_SDMA_EVENT_11_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_11 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_0[0] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0      (0)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0      (0x00000001)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_0 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_0(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_1[1] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1      (1)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_1 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_1(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_2[2] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2      (2)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2      (0x00000004)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_2 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_2(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_3[3] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3      (3)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3      (0x00000008)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_3 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_3(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_5[5] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5      (5)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5      (0x00000020)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_5 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_5(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_11[11] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11      (11)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_11 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_11(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_12[12] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12      (12)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_12 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_12(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_20[20] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20      (20)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_20 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_20(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_21[21] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21      (21)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21      (0x00200000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_21 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_21(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_22[22] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22      (22)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22      (0x00400000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_22 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_22(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_25[25] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25      (25)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25      (0x02000000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_25 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_25(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_11, field IDMAC_EOBND_SDMA_EN_26[26] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26      (26)      //!< Bit position for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26.
#define BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26      (0x04000000)  //!< Bit mask for IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26.

//! @brief Get value of IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26 from a register value.
#define BG_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26) >> BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26)

//! @brief Format value for bitfield IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26.
#define BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26) & BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_26 field to a new value.
#define BW_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26(x, v)   (HW_IPU_SDMA_EVENT_11_WR(x, (HW_IPU_SDMA_EVENT_11_RD(x) & ~BM_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26) | BF_IPU_SDMA_EVENT_11_IDMAC_EOBND_SDMA_EN_26(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_12 - SDMA Event Control Register 12
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_12 - SDMA Event Control Register 12 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of EOBND (End of Band) of
 * DMA Channels SDMA events [63:32] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_12
{
    reg32_t U;
    struct _hw_ipu_sdma_event_12_bitfields
    {
        unsigned RESERVED0 : 13; //!< [12:0] Reserved.
        unsigned IDMAC_EOBND_SDMA_EN_45 : 1; //!< [13] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_46 : 1; //!< [14] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_47 : 1; //!< [15] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_48 : 1; //!< [16] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_49 : 1; //!< [17] Enable End of Band of Channel SDMA event.
        unsigned IDMAC_EOBND_SDMA_EN_50 : 1; //!< [18] Enable End of Band of Channel SDMA event.
        unsigned RESERVED1 : 13; //!< [31:19] Reserved.
    } B;
} hw_ipu_sdma_event_12_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_12 register
 */
//@{
#define HW_IPU_SDMA_EVENT_12_ADDR(x)      (REGS_IPU_BASE(x) + 0x94)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_12(x)           (*(volatile hw_ipu_sdma_event_12_t *) HW_IPU_SDMA_EVENT_12_ADDR(x))
#define HW_IPU_SDMA_EVENT_12_RD(x)        (HW_IPU_SDMA_EVENT_12(x).U)
#define HW_IPU_SDMA_EVENT_12_WR(x, v)     (HW_IPU_SDMA_EVENT_12(x).U = (v))
#define HW_IPU_SDMA_EVENT_12_SET(x, v)    (HW_IPU_SDMA_EVENT_12_WR(x, HW_IPU_SDMA_EVENT_12_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_12_CLR(x, v)    (HW_IPU_SDMA_EVENT_12_WR(x, HW_IPU_SDMA_EVENT_12_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_12_TOG(x, v)    (HW_IPU_SDMA_EVENT_12_WR(x, HW_IPU_SDMA_EVENT_12_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_12 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_45[13] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45      (13)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_45 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_45(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_46[14] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46      (14)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_46 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_46(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_47[15] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47      (15)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_47 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_47(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_48[16] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48      (16)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48      (0x00010000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_48 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_48(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_49[17] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49      (17)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_49 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_49(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_12, field IDMAC_EOBND_SDMA_EN_50[18] (RW)
 *
 * Enable End of Band of Channel SDMA event. This bit is the control of End Of Band of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50      (18)      //!< Bit position for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50.
#define BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50.

//! @brief Get value of IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50 from a register value.
#define BG_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50) >> BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50)

//! @brief Format value for bitfield IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50.
#define BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50) & BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOBND_SDMA_EN_50 field to a new value.
#define BW_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50(x, v)   (HW_IPU_SDMA_EVENT_12_WR(x, (HW_IPU_SDMA_EVENT_12_RD(x) & ~BM_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50) | BF_IPU_SDMA_EVENT_12_IDMAC_EOBND_SDMA_EN_50(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_13 - SDMA Event Control Register 13
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_13 - SDMA Event Control Register 13 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of TH (Threshold) of DMA
 * Channels SDMA events [31:0] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_13
{
    reg32_t U;
    struct _hw_ipu_sdma_event_13_bitfields
    {
        unsigned IDMAC_TH_SDMA_EN_0 : 1; //!< [0] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_1 : 1; //!< [1] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_2 : 1; //!< [2] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_3 : 1; //!< [3] Enable Threshold of Channel SDMA event.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_TH_SDMA_EN_5 : 1; //!< [5] Enable Threshold of Channel SDMA event.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_TH_SDMA_EN_8 : 1; //!< [8] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_9 : 1; //!< [9] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_10 : 1; //!< [10] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_11 : 1; //!< [11] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_12 : 1; //!< [12] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_13 : 1; //!< [13] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_14 : 1; //!< [14] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_15 : 1; //!< [15] Enable Threshold of Channel SDMA event.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_TH_SDMA_EN_17 : 1; //!< [17] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_18 : 1; //!< [18] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_19 : 1; //!< [19] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_20 : 1; //!< [20] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_21 : 1; //!< [21] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_22 : 1; //!< [22] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_23 : 1; //!< [23] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_24 : 1; //!< [24] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_25 : 1; //!< [25] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_26 : 1; //!< [26] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_27 : 1; //!< [27] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_28 : 1; //!< [28] Enable Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_29 : 1; //!< [29] Enable Threshold of Channel SDMA event.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_TH_SDMA_EN_31 : 1; //!< [31] Enable Threshold of Channel SDMA event.
    } B;
} hw_ipu_sdma_event_13_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_13 register
 */
//@{
#define HW_IPU_SDMA_EVENT_13_ADDR(x)      (REGS_IPU_BASE(x) + 0x98)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_13(x)           (*(volatile hw_ipu_sdma_event_13_t *) HW_IPU_SDMA_EVENT_13_ADDR(x))
#define HW_IPU_SDMA_EVENT_13_RD(x)        (HW_IPU_SDMA_EVENT_13(x).U)
#define HW_IPU_SDMA_EVENT_13_WR(x, v)     (HW_IPU_SDMA_EVENT_13(x).U = (v))
#define HW_IPU_SDMA_EVENT_13_SET(x, v)    (HW_IPU_SDMA_EVENT_13_WR(x, HW_IPU_SDMA_EVENT_13_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_13_CLR(x, v)    (HW_IPU_SDMA_EVENT_13_WR(x, HW_IPU_SDMA_EVENT_13_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_13_TOG(x, v)    (HW_IPU_SDMA_EVENT_13_WR(x, HW_IPU_SDMA_EVENT_13_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_13 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_0[0] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0      (0)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0      (0x00000001)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_0 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_0(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_1[1] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1      (1)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_1 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_1(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_2[2] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2      (2)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2      (0x00000004)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_2 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_2(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_3[3] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3      (3)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3      (0x00000008)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_3 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_3(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_5[5] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5      (5)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5      (0x00000020)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_5 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_5(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_8[8] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8      (8)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_8 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_8(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_9[9] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9      (9)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_9 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_9(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_10[10] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10      (10)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_10 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_10(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_11[11] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11      (11)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_11 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_11(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_12[12] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12      (12)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_12 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_12(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_13[13] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13      (13)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_13 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_13(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_14[14] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14      (14)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_14 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_14(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_15[15] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15      (15)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_15 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_15(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_17[17] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17      (17)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_17 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_17(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_18[18] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18      (18)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_18 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_18(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_19[19] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19      (19)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_19 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_19(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_20[20] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20      (20)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_20 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_20(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_21[21] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21      (21)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21      (0x00200000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_21 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_21(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_22[22] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22      (22)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22      (0x00400000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_22 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_22(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_23[23] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23      (23)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23      (0x00800000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_23 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_23(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_24[24] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24      (24)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24      (0x01000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_24 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_24(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_25[25] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25      (25)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25      (0x02000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_25 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_25(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_26[26] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26      (26)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26      (0x04000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_26 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_26(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_27[27] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27      (27)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27      (0x08000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_27 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_27(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_28[28] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28      (28)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28      (0x10000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_28 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_28(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_29[29] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29      (29)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29      (0x20000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_29 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_29(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_13, field IDMAC_TH_SDMA_EN_31[31] (RW)
 *
 * Enable Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31      (31)      //!< Bit position for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31.
#define BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31      (0x80000000)  //!< Bit mask for IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31.

//! @brief Get value of IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31 from a register value.
#define BG_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31) >> BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31)

//! @brief Format value for bitfield IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31.
#define BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31) & BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_31 field to a new value.
#define BW_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31(x, v)   (HW_IPU_SDMA_EVENT_13_WR(x, (HW_IPU_SDMA_EVENT_13_RD(x) & ~BM_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31) | BF_IPU_SDMA_EVENT_13_IDMAC_TH_SDMA_EN_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SDMA_EVENT_14 - SDMA Event Control Register 14
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SDMA_EVENT_14 - SDMA Event Control Register 14 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains part of IPU SDMA events controls. The controls of TH (Threshold) of DMA
 * Channels SDMA events [63:32] can be found in this register.
 */
typedef union _hw_ipu_sdma_event_14
{
    reg32_t U;
    struct _hw_ipu_sdma_event_14_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_TH_SDMA_EN_33 : 1; //!< [1] Threshold of Channel SDMA event.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_TH_SDMA_EN_40 : 1; //!< [8] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_41 : 1; //!< [9] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_42 : 1; //!< [10] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_43 : 1; //!< [11] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_44 : 1; //!< [12] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_45 : 1; //!< [13] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_46 : 1; //!< [14] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_47 : 1; //!< [15] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_48 : 1; //!< [16] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_49 : 1; //!< [17] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_50 : 1; //!< [18] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_51 : 1; //!< [19] Threshold of Channel SDMA event.
        unsigned IDMAC_TH_SDMA_EN_52 : 1; //!< [20] Threshold of Channel SDMA event.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_sdma_event_14_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SDMA_EVENT_14 register
 */
//@{
#define HW_IPU_SDMA_EVENT_14_ADDR(x)      (REGS_IPU_BASE(x) + 0x9c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SDMA_EVENT_14(x)           (*(volatile hw_ipu_sdma_event_14_t *) HW_IPU_SDMA_EVENT_14_ADDR(x))
#define HW_IPU_SDMA_EVENT_14_RD(x)        (HW_IPU_SDMA_EVENT_14(x).U)
#define HW_IPU_SDMA_EVENT_14_WR(x, v)     (HW_IPU_SDMA_EVENT_14(x).U = (v))
#define HW_IPU_SDMA_EVENT_14_SET(x, v)    (HW_IPU_SDMA_EVENT_14_WR(x, HW_IPU_SDMA_EVENT_14_RD(x) |  (v)))
#define HW_IPU_SDMA_EVENT_14_CLR(x, v)    (HW_IPU_SDMA_EVENT_14_WR(x, HW_IPU_SDMA_EVENT_14_RD(x) & ~(v)))
#define HW_IPU_SDMA_EVENT_14_TOG(x, v)    (HW_IPU_SDMA_EVENT_14_WR(x, HW_IPU_SDMA_EVENT_14_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SDMA_EVENT_14 bitfields
 */

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_33[1] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33      (1)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33      (0x00000002)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_33 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_33(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_40[8] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40      (8)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40      (0x00000100)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_40 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_40(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_41[9] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41      (9)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41      (0x00000200)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_41 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_41(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_42[10] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42      (10)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42      (0x00000400)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_42 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_42(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_43[11] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43      (11)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43      (0x00000800)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_43 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_43(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_44[12] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44      (12)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44      (0x00001000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_44 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_44(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_45[13] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45      (13)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45      (0x00002000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_45 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_45(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_46[14] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46      (14)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46      (0x00004000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_46 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_46(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_47[15] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47      (15)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47      (0x00008000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_47 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_47(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_48[16] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48      (16)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48      (0x00010000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_48 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_48(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_49[17] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49      (17)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49      (0x00020000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_49 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_49(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_50[18] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50      (18)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50      (0x00040000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_50 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_50(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_51[19] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51      (19)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51      (0x00080000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_51 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_51(v)))
#endif
//@}

/*! @name Register IPU_SDMA_EVENT_14, field IDMAC_TH_SDMA_EN_52[20] (RW)
 *
 * Threshold of Channel SDMA event. This bit is the control of Threshold of Channel #n. n Indicates
 * the corresponding DMA channel number. n Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - SDMA event is disabled.
 * - 1 - SDMA event is enabled.
 */
//@{
#define BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52      (20)      //!< Bit position for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52.
#define BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52      (0x00100000)  //!< Bit mask for IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52.

//! @brief Get value of IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52 from a register value.
#define BG_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52) >> BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52)

//! @brief Format value for bitfield IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52.
#define BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52) & BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_TH_SDMA_EN_52 field to a new value.
#define BW_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52(x, v)   (HW_IPU_SDMA_EVENT_14_WR(x, (HW_IPU_SDMA_EVENT_14_RD(x) & ~BM_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52) | BF_IPU_SDMA_EVENT_14_IDMAC_TH_SDMA_EN_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SRM_PRI1 - Shadow Registers Memory Priority 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SRM_PRI1 - Shadow Registers Memory Priority 1 Register (RW)
 *
 * Reset value: 0x00000100
 *
 * The register controls the priority of SRM updates. The priority level for each block that has a
 * shadow of its registers in the SRM should be unique. The priority level defines the order of SRM
 * updates. A block with priority set to 010 will be updated before a block with priority set to
 * 001.
 */
typedef union _hw_ipu_srm_pri1
{
    reg32_t U;
    struct _hw_ipu_srm_pri1_bitfields
    {
        unsigned CSI1_SRM_PRI : 3; //!< [2:0] CSI1 SRM priority
        unsigned CSI1_SRM_MODE : 2; //!< [4:3] CSI1 SRM Mode
        unsigned RESERVED0 : 3; //!< [7:5] Reserved
        unsigned CSI0_SRM_PRI : 3; //!< [10:8] CSI0 SRM priority
        unsigned CSI0_SRM_MODE : 2; //!< [12:11] CSI0 SRM Mode
        unsigned RESERVED1 : 19; //!< [31:13] Reserved
    } B;
} hw_ipu_srm_pri1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SRM_PRI1 register
 */
//@{
#define HW_IPU_SRM_PRI1_ADDR(x)      (REGS_IPU_BASE(x) + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SRM_PRI1(x)           (*(volatile hw_ipu_srm_pri1_t *) HW_IPU_SRM_PRI1_ADDR(x))
#define HW_IPU_SRM_PRI1_RD(x)        (HW_IPU_SRM_PRI1(x).U)
#define HW_IPU_SRM_PRI1_WR(x, v)     (HW_IPU_SRM_PRI1(x).U = (v))
#define HW_IPU_SRM_PRI1_SET(x, v)    (HW_IPU_SRM_PRI1_WR(x, HW_IPU_SRM_PRI1_RD(x) |  (v)))
#define HW_IPU_SRM_PRI1_CLR(x, v)    (HW_IPU_SRM_PRI1_WR(x, HW_IPU_SRM_PRI1_RD(x) & ~(v)))
#define HW_IPU_SRM_PRI1_TOG(x, v)    (HW_IPU_SRM_PRI1_WR(x, HW_IPU_SRM_PRI1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SRM_PRI1 bitfields
 */

/*! @name Register IPU_SRM_PRI1, field CSI1_SRM_PRI[2:0] (RW)
 *
 * CSI1 SRM priority This bits define the priority of the CSI0 module
 */
//@{
#define BP_IPU_SRM_PRI1_CSI1_SRM_PRI      (0)      //!< Bit position for IPU_SRM_PRI1_CSI1_SRM_PRI.
#define BM_IPU_SRM_PRI1_CSI1_SRM_PRI      (0x00000007)  //!< Bit mask for IPU_SRM_PRI1_CSI1_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI1_CSI1_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI1_CSI1_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI1_CSI1_SRM_PRI) >> BP_IPU_SRM_PRI1_CSI1_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI1_CSI1_SRM_PRI.
#define BF_IPU_SRM_PRI1_CSI1_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI1_CSI1_SRM_PRI) & BM_IPU_SRM_PRI1_CSI1_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI1_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI1_CSI1_SRM_PRI(x, v)   (HW_IPU_SRM_PRI1_WR(x, (HW_IPU_SRM_PRI1_RD(x) & ~BM_IPU_SRM_PRI1_CSI1_SRM_PRI) | BF_IPU_SRM_PRI1_CSI1_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI1, field CSI1_SRM_MODE[4:3] (RW)
 *
 * CSI1 SRM Mode This field controls the SRM logic that handles the CSI1 registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the CSI0's region in the RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI1_CSI1_SRM_MODE      (3)      //!< Bit position for IPU_SRM_PRI1_CSI1_SRM_MODE.
#define BM_IPU_SRM_PRI1_CSI1_SRM_MODE      (0x00000018)  //!< Bit mask for IPU_SRM_PRI1_CSI1_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI1_CSI1_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI1_CSI1_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI1_CSI1_SRM_MODE) >> BP_IPU_SRM_PRI1_CSI1_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI1_CSI1_SRM_MODE.
#define BF_IPU_SRM_PRI1_CSI1_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI1_CSI1_SRM_MODE) & BM_IPU_SRM_PRI1_CSI1_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI1_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI1_CSI1_SRM_MODE(x, v)   (HW_IPU_SRM_PRI1_WR(x, (HW_IPU_SRM_PRI1_RD(x) & ~BM_IPU_SRM_PRI1_CSI1_SRM_MODE) | BF_IPU_SRM_PRI1_CSI1_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI1, field CSI0_SRM_PRI[10:8] (RW)
 *
 * CSI0 SRM priority This bits define the priority of the CSI1 block
 */
//@{
#define BP_IPU_SRM_PRI1_CSI0_SRM_PRI      (8)      //!< Bit position for IPU_SRM_PRI1_CSI0_SRM_PRI.
#define BM_IPU_SRM_PRI1_CSI0_SRM_PRI      (0x00000700)  //!< Bit mask for IPU_SRM_PRI1_CSI0_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI1_CSI0_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI1_CSI0_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI1_CSI0_SRM_PRI) >> BP_IPU_SRM_PRI1_CSI0_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI1_CSI0_SRM_PRI.
#define BF_IPU_SRM_PRI1_CSI0_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI1_CSI0_SRM_PRI) & BM_IPU_SRM_PRI1_CSI0_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI0_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI1_CSI0_SRM_PRI(x, v)   (HW_IPU_SRM_PRI1_WR(x, (HW_IPU_SRM_PRI1_RD(x) & ~BM_IPU_SRM_PRI1_CSI0_SRM_PRI) | BF_IPU_SRM_PRI1_CSI0_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI1, field CSI0_SRM_MODE[12:11] (RW)
 *
 * CSI0 SRM Mode This field controls the SRM logic that handles the CSI0 registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the CSI1's region in the RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM Platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI1_CSI0_SRM_MODE      (11)      //!< Bit position for IPU_SRM_PRI1_CSI0_SRM_MODE.
#define BM_IPU_SRM_PRI1_CSI0_SRM_MODE      (0x00001800)  //!< Bit mask for IPU_SRM_PRI1_CSI0_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI1_CSI0_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI1_CSI0_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI1_CSI0_SRM_MODE) >> BP_IPU_SRM_PRI1_CSI0_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI1_CSI0_SRM_MODE.
#define BF_IPU_SRM_PRI1_CSI0_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI1_CSI0_SRM_MODE) & BM_IPU_SRM_PRI1_CSI0_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI0_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI1_CSI0_SRM_MODE(x, v)   (HW_IPU_SRM_PRI1_WR(x, (HW_IPU_SRM_PRI1_RD(x) & ~BM_IPU_SRM_PRI1_CSI0_SRM_MODE) | BF_IPU_SRM_PRI1_CSI0_SRM_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SRM_PRI2 - Shadow Registers Memory Priority 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SRM_PRI2 - Shadow Registers Memory Priority 2 Register (RW)
 *
 * Reset value: 0x06050803
 *
 * The register controls the priority of SRM updates. The priority level for each block that has a
 * shadow of its registers in the SRM should be unique. The priority level defines the order of SRM
 * updates. a block with priority set to 010 will be updated before a block with priority set to
 * 001.
 */
typedef union _hw_ipu_srm_pri2
{
    reg32_t U;
    struct _hw_ipu_srm_pri2_bitfields
    {
        unsigned DP_SRM_PRI : 3; //!< [2:0] DP SRM priority
        unsigned DP_S_SRM_MODE : 2; //!< [4:3] DP sync flow SRM Mode
        unsigned DP_A0_SRM_MODE : 2; //!< [6:5] DP Async flow #0 SRM Mode
        unsigned DP_A1_SRM_MODE : 2; //!< [8:7] DP Async flow #1 SRM Mode
        unsigned DC_SRM_PRI : 3; //!< [11:9] DC SRM priority
        unsigned DC_2_SRM_MODE : 2; //!< [13:12] DC Group #2 SRM Mode
        unsigned DC_6_SRM_MODE : 2; //!< [15:14] DC Group #6 SRM Mode
        unsigned DI0_SRM_PRI : 3; //!< [18:16] DI0 SRM priority
        unsigned DI0_SRM_MCU_USE : 2; //!< [20:19] DI0 SRM is used by ARM platform
        unsigned RESERVED0 : 3; //!< [23:21] Reserved
        unsigned DI1_SRM_PRI : 3; //!< [26:24] DI1 SRM priority
        unsigned DI1_SRM_MODE : 2; //!< [28:27] DCI1 SRM Mode
        unsigned RESERVED1 : 3; //!< [31:29] Reserved
    } B;
} hw_ipu_srm_pri2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SRM_PRI2 register
 */
//@{
#define HW_IPU_SRM_PRI2_ADDR(x)      (REGS_IPU_BASE(x) + 0xa4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SRM_PRI2(x)           (*(volatile hw_ipu_srm_pri2_t *) HW_IPU_SRM_PRI2_ADDR(x))
#define HW_IPU_SRM_PRI2_RD(x)        (HW_IPU_SRM_PRI2(x).U)
#define HW_IPU_SRM_PRI2_WR(x, v)     (HW_IPU_SRM_PRI2(x).U = (v))
#define HW_IPU_SRM_PRI2_SET(x, v)    (HW_IPU_SRM_PRI2_WR(x, HW_IPU_SRM_PRI2_RD(x) |  (v)))
#define HW_IPU_SRM_PRI2_CLR(x, v)    (HW_IPU_SRM_PRI2_WR(x, HW_IPU_SRM_PRI2_RD(x) & ~(v)))
#define HW_IPU_SRM_PRI2_TOG(x, v)    (HW_IPU_SRM_PRI2_WR(x, HW_IPU_SRM_PRI2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SRM_PRI2 bitfields
 */

/*! @name Register IPU_SRM_PRI2, field DP_SRM_PRI[2:0] (RW)
 *
 * DP SRM priority This bits define the priority of the DP module
 */
//@{
#define BP_IPU_SRM_PRI2_DP_SRM_PRI      (0)      //!< Bit position for IPU_SRM_PRI2_DP_SRM_PRI.
#define BM_IPU_SRM_PRI2_DP_SRM_PRI      (0x00000007)  //!< Bit mask for IPU_SRM_PRI2_DP_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI2_DP_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI2_DP_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DP_SRM_PRI) >> BP_IPU_SRM_PRI2_DP_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI2_DP_SRM_PRI.
#define BF_IPU_SRM_PRI2_DP_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DP_SRM_PRI) & BM_IPU_SRM_PRI2_DP_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI2_DP_SRM_PRI(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DP_SRM_PRI) | BF_IPU_SRM_PRI2_DP_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DP_S_SRM_MODE[4:3] (RW)
 *
 * DP sync flow SRM Mode This field controls the SRM logic that handles the DP sync flow registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DP sync flow region in the RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done on the next frame.
 * - 10 - Reserved
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DP_S_SRM_MODE      (3)      //!< Bit position for IPU_SRM_PRI2_DP_S_SRM_MODE.
#define BM_IPU_SRM_PRI2_DP_S_SRM_MODE      (0x00000018)  //!< Bit mask for IPU_SRM_PRI2_DP_S_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DP_S_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DP_S_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DP_S_SRM_MODE) >> BP_IPU_SRM_PRI2_DP_S_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DP_S_SRM_MODE.
#define BF_IPU_SRM_PRI2_DP_S_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DP_S_SRM_MODE) & BM_IPU_SRM_PRI2_DP_S_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_S_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DP_S_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DP_S_SRM_MODE) | BF_IPU_SRM_PRI2_DP_S_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DP_A0_SRM_MODE[6:5] (RW)
 *
 * DP Async flow #0 SRM Mode This field controls the SRM logic that handles the DP Async flow #0
 * registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DP Async flow #0 region in the
 *     RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DP_A0_SRM_MODE      (5)      //!< Bit position for IPU_SRM_PRI2_DP_A0_SRM_MODE.
#define BM_IPU_SRM_PRI2_DP_A0_SRM_MODE      (0x00000060)  //!< Bit mask for IPU_SRM_PRI2_DP_A0_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DP_A0_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DP_A0_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DP_A0_SRM_MODE) >> BP_IPU_SRM_PRI2_DP_A0_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DP_A0_SRM_MODE.
#define BF_IPU_SRM_PRI2_DP_A0_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DP_A0_SRM_MODE) & BM_IPU_SRM_PRI2_DP_A0_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_A0_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DP_A0_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DP_A0_SRM_MODE) | BF_IPU_SRM_PRI2_DP_A0_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DP_A1_SRM_MODE[8:7] (RW)
 *
 * DP Async flow #1 SRM Mode This field controls the SRM logic that handles the DP Async flow #1
 * registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DP Async flow #1 region in the
 *     RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DP_A1_SRM_MODE      (7)      //!< Bit position for IPU_SRM_PRI2_DP_A1_SRM_MODE.
#define BM_IPU_SRM_PRI2_DP_A1_SRM_MODE      (0x00000180)  //!< Bit mask for IPU_SRM_PRI2_DP_A1_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DP_A1_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DP_A1_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DP_A1_SRM_MODE) >> BP_IPU_SRM_PRI2_DP_A1_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DP_A1_SRM_MODE.
#define BF_IPU_SRM_PRI2_DP_A1_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DP_A1_SRM_MODE) & BM_IPU_SRM_PRI2_DP_A1_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_A1_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DP_A1_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DP_A1_SRM_MODE) | BF_IPU_SRM_PRI2_DP_A1_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DC_SRM_PRI[11:9] (RW)
 *
 * DC SRM priority This bits define the priority of the DC module
 */
//@{
#define BP_IPU_SRM_PRI2_DC_SRM_PRI      (9)      //!< Bit position for IPU_SRM_PRI2_DC_SRM_PRI.
#define BM_IPU_SRM_PRI2_DC_SRM_PRI      (0x00000e00)  //!< Bit mask for IPU_SRM_PRI2_DC_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI2_DC_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI2_DC_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DC_SRM_PRI) >> BP_IPU_SRM_PRI2_DC_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI2_DC_SRM_PRI.
#define BF_IPU_SRM_PRI2_DC_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DC_SRM_PRI) & BM_IPU_SRM_PRI2_DC_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI2_DC_SRM_PRI(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DC_SRM_PRI) | BF_IPU_SRM_PRI2_DC_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DC_2_SRM_MODE[13:12] (RW)
 *
 * DC Group #2 SRM Mode This field controls the SRM logic that handles the DC Group #2 registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DC Group #2's region in the
 *     RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DC_2_SRM_MODE      (12)      //!< Bit position for IPU_SRM_PRI2_DC_2_SRM_MODE.
#define BM_IPU_SRM_PRI2_DC_2_SRM_MODE      (0x00003000)  //!< Bit mask for IPU_SRM_PRI2_DC_2_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DC_2_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DC_2_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DC_2_SRM_MODE) >> BP_IPU_SRM_PRI2_DC_2_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DC_2_SRM_MODE.
#define BF_IPU_SRM_PRI2_DC_2_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DC_2_SRM_MODE) & BM_IPU_SRM_PRI2_DC_2_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_2_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DC_2_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DC_2_SRM_MODE) | BF_IPU_SRM_PRI2_DC_2_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DC_6_SRM_MODE[15:14] (RW)
 *
 * DC Group #6 SRM Mode This field controls the SRM logic that handles the DC Group #6 registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DC Group #6's region in the
 *     RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DC_6_SRM_MODE      (14)      //!< Bit position for IPU_SRM_PRI2_DC_6_SRM_MODE.
#define BM_IPU_SRM_PRI2_DC_6_SRM_MODE      (0x0000c000)  //!< Bit mask for IPU_SRM_PRI2_DC_6_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DC_6_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DC_6_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DC_6_SRM_MODE) >> BP_IPU_SRM_PRI2_DC_6_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DC_6_SRM_MODE.
#define BF_IPU_SRM_PRI2_DC_6_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DC_6_SRM_MODE) & BM_IPU_SRM_PRI2_DC_6_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC_6_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DC_6_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DC_6_SRM_MODE) | BF_IPU_SRM_PRI2_DC_6_SRM_MODE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DI0_SRM_PRI[18:16] (RW)
 *
 * DI0 SRM priority This bits define the priority of the DI0 module
 */
//@{
#define BP_IPU_SRM_PRI2_DI0_SRM_PRI      (16)      //!< Bit position for IPU_SRM_PRI2_DI0_SRM_PRI.
#define BM_IPU_SRM_PRI2_DI0_SRM_PRI      (0x00070000)  //!< Bit mask for IPU_SRM_PRI2_DI0_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI2_DI0_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI2_DI0_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DI0_SRM_PRI) >> BP_IPU_SRM_PRI2_DI0_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI2_DI0_SRM_PRI.
#define BF_IPU_SRM_PRI2_DI0_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DI0_SRM_PRI) & BM_IPU_SRM_PRI2_DI0_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI2_DI0_SRM_PRI(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DI0_SRM_PRI) | BF_IPU_SRM_PRI2_DI0_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DI0_SRM_MCU_USE[20:19] (RW)
 *
 * DI0 SRM is used by ARM platform This bit indicates that the registers of the DI0 are currently
 * being updated by the ARM platform. The ARM platform should set this bit before accessing the SRM
 * part that is relevant to the DI0. The ARM platform should clear this bit when the update
 * procedure is finished. When this bit is set the SRM mechanism will not update the DI0's registers
 * to avoid data coherency problems.
 *
 * Values:
 * - 0 - DI0 SRM s currently not updated by the ARM platform
 * - 1 - DI0 SRM is currently updated by the ARM platform
 */
//@{
#define BP_IPU_SRM_PRI2_DI0_SRM_MCU_USE      (19)      //!< Bit position for IPU_SRM_PRI2_DI0_SRM_MCU_USE.
#define BM_IPU_SRM_PRI2_DI0_SRM_MCU_USE      (0x00180000)  //!< Bit mask for IPU_SRM_PRI2_DI0_SRM_MCU_USE.

//! @brief Get value of IPU_SRM_PRI2_DI0_SRM_MCU_USE from a register value.
#define BG_IPU_SRM_PRI2_DI0_SRM_MCU_USE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DI0_SRM_MCU_USE) >> BP_IPU_SRM_PRI2_DI0_SRM_MCU_USE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DI0_SRM_MCU_USE.
#define BF_IPU_SRM_PRI2_DI0_SRM_MCU_USE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DI0_SRM_MCU_USE) & BM_IPU_SRM_PRI2_DI0_SRM_MCU_USE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_SRM_MCU_USE field to a new value.
#define BW_IPU_SRM_PRI2_DI0_SRM_MCU_USE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DI0_SRM_MCU_USE) | BF_IPU_SRM_PRI2_DI0_SRM_MCU_USE(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DI1_SRM_PRI[26:24] (RW)
 *
 * DI1 SRM priority This bits define the priority of the DI1 module
 */
//@{
#define BP_IPU_SRM_PRI2_DI1_SRM_PRI      (24)      //!< Bit position for IPU_SRM_PRI2_DI1_SRM_PRI.
#define BM_IPU_SRM_PRI2_DI1_SRM_PRI      (0x07000000)  //!< Bit mask for IPU_SRM_PRI2_DI1_SRM_PRI.

//! @brief Get value of IPU_SRM_PRI2_DI1_SRM_PRI from a register value.
#define BG_IPU_SRM_PRI2_DI1_SRM_PRI(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DI1_SRM_PRI) >> BP_IPU_SRM_PRI2_DI1_SRM_PRI)

//! @brief Format value for bitfield IPU_SRM_PRI2_DI1_SRM_PRI.
#define BF_IPU_SRM_PRI2_DI1_SRM_PRI(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DI1_SRM_PRI) & BM_IPU_SRM_PRI2_DI1_SRM_PRI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_SRM_PRI field to a new value.
#define BW_IPU_SRM_PRI2_DI1_SRM_PRI(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DI1_SRM_PRI) | BF_IPU_SRM_PRI2_DI1_SRM_PRI(v)))
#endif
//@}

/*! @name Register IPU_SRM_PRI2, field DI1_SRM_MODE[28:27] (RW)
 *
 * DCI1 SRM Mode This field controls the SRM logic that handles the DI1 registers
 *
 * Values:
 * - 00 - Automatic swapping is disabled; ARM platform is allowed to access the DI1 region in the RAM
 * - 01 - The SRM logic is controlled by the FSU. The update will be done of the next frame.
 * - 10 - The SRM logic is controlled by the FSU. Registers are swapped continuously frame by frame
 * - 11 - Update now. The SRM is controlled by the ARM platform. The Register will be update now
 */
//@{
#define BP_IPU_SRM_PRI2_DI1_SRM_MODE      (27)      //!< Bit position for IPU_SRM_PRI2_DI1_SRM_MODE.
#define BM_IPU_SRM_PRI2_DI1_SRM_MODE      (0x18000000)  //!< Bit mask for IPU_SRM_PRI2_DI1_SRM_MODE.

//! @brief Get value of IPU_SRM_PRI2_DI1_SRM_MODE from a register value.
#define BG_IPU_SRM_PRI2_DI1_SRM_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SRM_PRI2_DI1_SRM_MODE) >> BP_IPU_SRM_PRI2_DI1_SRM_MODE)

//! @brief Format value for bitfield IPU_SRM_PRI2_DI1_SRM_MODE.
#define BF_IPU_SRM_PRI2_DI1_SRM_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SRM_PRI2_DI1_SRM_MODE) & BM_IPU_SRM_PRI2_DI1_SRM_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_SRM_MODE field to a new value.
#define BW_IPU_SRM_PRI2_DI1_SRM_MODE(x, v)   (HW_IPU_SRM_PRI2_WR(x, (HW_IPU_SRM_PRI2_RD(x) & ~BM_IPU_SRM_PRI2_DI1_SRM_MODE) | BF_IPU_SRM_PRI2_DI1_SRM_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_FS_PROC_FLOW1 - FSU Processing Flow 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_FS_PROC_FLOW1 - FSU Processing Flow 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contain controls for IPU's tasks.
 */
typedef union _hw_ipu_fs_proc_flow1
{
    reg32_t U;
    struct _hw_ipu_fs_proc_flow1_bitfields
    {
        unsigned PRPENC_ROT_SRC_SEL : 4; //!< [3:0] Source select for the encoding task of the IRT
        unsigned RESERVED0 : 4; //!< [7:4] Reserved
        unsigned PRPVF_ROT_SRC_SEL : 4; //!< [11:8] Source select for the view finder task of the IRT
        unsigned PP_SRC_SEL : 4; //!< [15:12] Source select for the pre processing task of the IC
        unsigned PP_ROT_SRC_SEL : 4; //!< [19:16] Source select for the pre processing task of the IRT (CH 50)
        unsigned VDI1_SRC_SEL : 2; //!< [21:20] Source select for the VDIC plane #1 (IDMAC's CH26)
        unsigned VDI3_SRC_SEL : 2; //!< [23:22] Source select for the VDIC plane #3 (IDMAC's CH 25)
        unsigned PRP_SRC_SEL : 4; //!< [27:24] Source select for the Pre Processing Task
        unsigned VDI_SRC_SEL : 2; //!< [29:28] Source select for the VDI C
        unsigned ENC_IN_VALID : 1; //!< [30] Encoding Input valid.
        unsigned VF_IN_VALID : 1; //!< [31] View-finder Input valid.
    } B;
} hw_ipu_fs_proc_flow1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_FS_PROC_FLOW1 register
 */
//@{
#define HW_IPU_FS_PROC_FLOW1_ADDR(x)      (REGS_IPU_BASE(x) + 0xa8)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_FS_PROC_FLOW1(x)           (*(volatile hw_ipu_fs_proc_flow1_t *) HW_IPU_FS_PROC_FLOW1_ADDR(x))
#define HW_IPU_FS_PROC_FLOW1_RD(x)        (HW_IPU_FS_PROC_FLOW1(x).U)
#define HW_IPU_FS_PROC_FLOW1_WR(x, v)     (HW_IPU_FS_PROC_FLOW1(x).U = (v))
#define HW_IPU_FS_PROC_FLOW1_SET(x, v)    (HW_IPU_FS_PROC_FLOW1_WR(x, HW_IPU_FS_PROC_FLOW1_RD(x) |  (v)))
#define HW_IPU_FS_PROC_FLOW1_CLR(x, v)    (HW_IPU_FS_PROC_FLOW1_WR(x, HW_IPU_FS_PROC_FLOW1_RD(x) & ~(v)))
#define HW_IPU_FS_PROC_FLOW1_TOG(x, v)    (HW_IPU_FS_PROC_FLOW1_WR(x, HW_IPU_FS_PROC_FLOW1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_FS_PROC_FLOW1 bitfields
 */

/*! @name Register IPU_FS_PROC_FLOW1, field PRPENC_ROT_SRC_SEL[3:0] (RW)
 *
 * Source select for the encoding task of the IRT
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture1 (smfc1)
 * - 0011 - capture2 (smfc2)
 * - 0100 - capture3 (smfc3)
 * - 0101 - IC direct (cb7)
 * - 0110 - Reserved
 * - 0111 - encoding
 * - 1000 - Reserved
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL      (0)      //!< Bit position for IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL      (0x0000000f)  //!< Bit mask for IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRPENC_ROT_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_PRPENC_ROT_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field PRPVF_ROT_SRC_SEL[11:8] (RW)
 *
 * Source select for the view finder task of the IRT 0000 ARM platform
 *
 * Values:
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture1 (smfc1)
 * - 0011 - capture2 (smfc2)
 * - 0100 - capture3 (smfc3)
 * - 0101 - IC direct (cb7)
 * - 0110 - Reserved
 * - 0111 - Reserved
 * - 1000 - View-finder
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL      (8)      //!< Bit position for IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL      (0x00000f00)  //!< Bit mask for IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRPVF_ROT_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_PRPVF_ROT_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field PP_SRC_SEL[15:12] (RW)
 *
 * Source select for the pre processing task of the IC
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - Reserved
 * - 0011 - capture2 (smfc2)
 * - 0100 - Reserved
 * - 0101 - Reserved
 * - 0110 - Rotation for post-processing
 * - 0111 - Reserved
 * - 1000 - Reserved
 * - 1000 - VDOA
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_PP_SRC_SEL      (12)      //!< Bit position for IPU_FS_PROC_FLOW1_PP_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_PP_SRC_SEL      (0x0000f000)  //!< Bit mask for IPU_FS_PROC_FLOW1_PP_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_PP_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_PP_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_PP_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_PP_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_PP_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_PP_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_PP_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_PP_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_PP_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_PP_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_PP_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field PP_ROT_SRC_SEL[19:16] (RW)
 *
 * Source select for the pre processing task of the IRT (CH 50)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - Reserved
 * - 0011 - capture2 (smfc2)
 * - 0100 - Reserved
 * - 0101 - Post-processing
 * - 0110 - Reserved
 * - 0111 - Reserved
 * - 1000 - Reserved
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL      (16)      //!< Bit position for IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL      (0x000f0000)  //!< Bit mask for IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_ROT_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_PP_ROT_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field VDI1_SRC_SEL[21:20] (RW)
 *
 * Source select for the VDIC plane #1 (IDMAC's CH26) This field is relevant only if the VDIC works
 * in combining mode (VDI_CMB_EN bit is set)
 *
 * Values:
 * - 00 - ARM platform
 * - 01 - IRT viewfinder
 * - 10 - IRT playback
 * - 11 - post-processing
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL      (20)      //!< Bit position for IPU_FS_PROC_FLOW1_VDI1_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL      (0x00300000)  //!< Bit mask for IPU_FS_PROC_FLOW1_VDI1_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_VDI1_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_VDI1_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI1_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_VDI1_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field VDI3_SRC_SEL[23:22] (RW)
 *
 * Source select for the VDIC plane #3 (IDMAC's CH 25)
 *
 * Values:
 * - 00 - ARM platform This field is relevant only if the VDIC works in combining mode (VDI_CMB_EN bit is set)
 * - 01 - IRT viewfinder (ch 49)
 * - 10 - IRT playback (ch 50)
 * - 11 - post-processing (ch 22)
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL      (22)      //!< Bit position for IPU_FS_PROC_FLOW1_VDI3_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL      (0x00c00000)  //!< Bit mask for IPU_FS_PROC_FLOW1_VDI3_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_VDI3_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_VDI3_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI3_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_VDI3_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field PRP_SRC_SEL[27:24] (RW)
 *
 * Source select for the Pre Processing Task 0000 ARM platform
 *
 * Values:
 * - 0001 - capture0 (smfc0)
 * - 0011 - capture2 (smfc2)
 * - 0101 - IC direct (cb7)
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - Reserved
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_PRP_SRC_SEL      (24)      //!< Bit position for IPU_FS_PROC_FLOW1_PRP_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_PRP_SRC_SEL      (0x0f000000)  //!< Bit mask for IPU_FS_PROC_FLOW1_PRP_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_PRP_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_PRP_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_PRP_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_PRP_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_PRP_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_PRP_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_PRP_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_PRP_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRP_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_PRP_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_PRP_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_PRP_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field VDI_SRC_SEL[29:28] (RW)
 *
 * Source select for the VDI C This field is relevant if the VDIC works in de-interlacing mode (when
 * VDI_CMB_EN bit is clear)
 *
 * Values:
 * - 00 - ARM platform
 * - 01 - CSI direct (cb7)
 * - 10 - Reserved
 * - 10 - VDOA
 * - 11 - Reserved
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_VDI_SRC_SEL      (28)      //!< Bit position for IPU_FS_PROC_FLOW1_VDI_SRC_SEL.
#define BM_IPU_FS_PROC_FLOW1_VDI_SRC_SEL      (0x30000000)  //!< Bit mask for IPU_FS_PROC_FLOW1_VDI_SRC_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW1_VDI_SRC_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW1_VDI_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_VDI_SRC_SEL) >> BP_IPU_FS_PROC_FLOW1_VDI_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_VDI_SRC_SEL.
#define BF_IPU_FS_PROC_FLOW1_VDI_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_VDI_SRC_SEL) & BM_IPU_FS_PROC_FLOW1_VDI_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_SRC_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW1_VDI_SRC_SEL(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_VDI_SRC_SEL) | BF_IPU_FS_PROC_FLOW1_VDI_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field ENC_IN_VALID[30] (RW)
 *
 * Encoding Input valid. Setting this bit indicates that the buffer in memory for encoding is
 * validated by the ARM platform (valid only when RWS_EN is '1').
 *
 * Values:
 * - 0 - Encoding should skip buffer in memory.
 * - 1 - Encoding should use buffer in memory.
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_ENC_IN_VALID      (30)      //!< Bit position for IPU_FS_PROC_FLOW1_ENC_IN_VALID.
#define BM_IPU_FS_PROC_FLOW1_ENC_IN_VALID      (0x40000000)  //!< Bit mask for IPU_FS_PROC_FLOW1_ENC_IN_VALID.

//! @brief Get value of IPU_FS_PROC_FLOW1_ENC_IN_VALID from a register value.
#define BG_IPU_FS_PROC_FLOW1_ENC_IN_VALID(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_ENC_IN_VALID) >> BP_IPU_FS_PROC_FLOW1_ENC_IN_VALID)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_ENC_IN_VALID.
#define BF_IPU_FS_PROC_FLOW1_ENC_IN_VALID(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_ENC_IN_VALID) & BM_IPU_FS_PROC_FLOW1_ENC_IN_VALID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENC_IN_VALID field to a new value.
#define BW_IPU_FS_PROC_FLOW1_ENC_IN_VALID(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_ENC_IN_VALID) | BF_IPU_FS_PROC_FLOW1_ENC_IN_VALID(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW1, field VF_IN_VALID[31] (RW)
 *
 * View-finder Input valid. Setting this bit indicates that the buffer in memory for viewfinder is
 * validated by the ARM platform (valid only when RWS_EN is '1').
 *
 * Values:
 * - 0 - View-finder should skip buffer in memory.
 * - 1 - View-finder should use buffer in memory.
 */
//@{
#define BP_IPU_FS_PROC_FLOW1_VF_IN_VALID      (31)      //!< Bit position for IPU_FS_PROC_FLOW1_VF_IN_VALID.
#define BM_IPU_FS_PROC_FLOW1_VF_IN_VALID      (0x80000000)  //!< Bit mask for IPU_FS_PROC_FLOW1_VF_IN_VALID.

//! @brief Get value of IPU_FS_PROC_FLOW1_VF_IN_VALID from a register value.
#define BG_IPU_FS_PROC_FLOW1_VF_IN_VALID(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW1_VF_IN_VALID) >> BP_IPU_FS_PROC_FLOW1_VF_IN_VALID)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW1_VF_IN_VALID.
#define BF_IPU_FS_PROC_FLOW1_VF_IN_VALID(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW1_VF_IN_VALID) & BM_IPU_FS_PROC_FLOW1_VF_IN_VALID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VF_IN_VALID field to a new value.
#define BW_IPU_FS_PROC_FLOW1_VF_IN_VALID(x, v)   (HW_IPU_FS_PROC_FLOW1_WR(x, (HW_IPU_FS_PROC_FLOW1_RD(x) & ~BM_IPU_FS_PROC_FLOW1_VF_IN_VALID) | BF_IPU_FS_PROC_FLOW1_VF_IN_VALID(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_FS_PROC_FLOW2 - FSU Processing Flow 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_FS_PROC_FLOW2 - FSU Processing Flow 2 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains controls for IPU's tasks.
 */
typedef union _hw_ipu_fs_proc_flow2
{
    reg32_t U;
    struct _hw_ipu_fs_proc_flow2_bitfields
    {
        unsigned PRP_ENC_DEST_SEL : 4; //!< [3:0] Destination select for Encoding task
        unsigned PRPVF_DEST_SEL : 4; //!< [7:4] Destination select for View finder task
        unsigned PRPVF_ROT_DEST_SEL : 4; //!< [11:8] Destination select for Rotation task coming from the View finder input
        unsigned PP_DEST_SEL : 4; //!< [15:12] Destination select for post processing task
        unsigned PP_ROT_DEST_SEL : 4; //!< [19:16] Destination select for Rotation task coming from the Post Processing input
        unsigned PRPENC_ROT_DEST_SEL : 4; //!< [23:20] Destination select for Rotation task coming from the Encoding input
        unsigned PRP_DEST_SEL : 4; //!< [27:24] Pre processing destination select (for channel DMAIC_7)
        unsigned RESERVED0 : 4; //!< [31:28] Reserved
    } B;
} hw_ipu_fs_proc_flow2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_FS_PROC_FLOW2 register
 */
//@{
#define HW_IPU_FS_PROC_FLOW2_ADDR(x)      (REGS_IPU_BASE(x) + 0xac)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_FS_PROC_FLOW2(x)           (*(volatile hw_ipu_fs_proc_flow2_t *) HW_IPU_FS_PROC_FLOW2_ADDR(x))
#define HW_IPU_FS_PROC_FLOW2_RD(x)        (HW_IPU_FS_PROC_FLOW2(x).U)
#define HW_IPU_FS_PROC_FLOW2_WR(x, v)     (HW_IPU_FS_PROC_FLOW2(x).U = (v))
#define HW_IPU_FS_PROC_FLOW2_SET(x, v)    (HW_IPU_FS_PROC_FLOW2_WR(x, HW_IPU_FS_PROC_FLOW2_RD(x) |  (v)))
#define HW_IPU_FS_PROC_FLOW2_CLR(x, v)    (HW_IPU_FS_PROC_FLOW2_WR(x, HW_IPU_FS_PROC_FLOW2_RD(x) & ~(v)))
#define HW_IPU_FS_PROC_FLOW2_TOG(x, v)    (HW_IPU_FS_PROC_FLOW2_WR(x, HW_IPU_FS_PROC_FLOW2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_FS_PROC_FLOW2 bitfields
 */

/*! @name Register IPU_FS_PROC_FLOW2, field PRP_ENC_DEST_SEL[3:0] (RW)
 *
 * Destination select for Encoding task
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - IRT Encoding
 * - 0010 - Reserved
 * - 0011 - Reserved
 * - 0100 - Reserved
 * - 0101 - Reserved
 * - 0110 - Reserved
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL      (0)      //!< Bit position for IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL      (0x0000000f)  //!< Bit mask for IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRP_ENC_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PRP_ENC_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PRPVF_DEST_SEL[7:4] (RW)
 *
 * Destination select for View finder task
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - IRT viewfinder
 * - 0010 - Reserved
 * - 0011 - Reserved
 * - 0100 - Reserved
 * - 0101 - Reserved
 * - 0110 - Reserved
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL      (4)      //!< Bit position for IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL      (0x000000f0)  //!< Bit mask for IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRPVF_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PRPVF_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PRPVF_ROT_DEST_SEL[11:8] (RW)
 *
 * Destination select for Rotation task coming from the View finder input
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - Reserved
 * - 0010 - Reserved
 * - 0011 - VDI_PLANE3 (Ch 25)
 * - 0100 - VDI_PLANE1 (Ch 26)
 * - 0101 - IC Pre Processing
 * - 0110 - Reserved
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL      (8)      //!< Bit position for IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL      (0x00000f00)  //!< Bit mask for IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRPVF_ROT_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PRPVF_ROT_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PP_DEST_SEL[15:12] (RW)
 *
 * Destination select for post processing task
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - Reserved
 * - 0010 - Reserved
 * - 0011 - IRT playback
 * - 0100 - VDI_PLANE3 (Ch 25)
 * - 0101 - VDI_PLANE1 (Ch 26)
 * - 0110 - Reserved
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PP_DEST_SEL      (12)      //!< Bit position for IPU_FS_PROC_FLOW2_PP_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PP_DEST_SEL      (0x0000f000)  //!< Bit mask for IPU_FS_PROC_FLOW2_PP_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PP_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PP_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PP_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PP_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PP_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PP_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PP_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PP_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PP_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PP_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PP_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PP_ROT_DEST_SEL[19:16] (RW)
 *
 * Destination select for Rotation task coming from the Post Processing input
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - Reserved
 * - 0010 - Reserved
 * - 0011 - Reserved
 * - 0100 - IC Playback (Post Processing)
 * - 0101 - VDI_PLANE3 (Ch 25)
 * - 0110 - VDI_PLANE1 (Ch 26)
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL      (16)      //!< Bit position for IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL      (0x000f0000)  //!< Bit mask for IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PP_ROT_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PP_ROT_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PRPENC_ROT_DEST_SEL[23:20] (RW)
 *
 * Destination select for Rotation task coming from the Encoding input
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - Reserved
 * - 0010 - Reserved
 * - 0011 - Reserved
 * - 0100 - Reserved
 * - 0101 - IC Pre Processing
 * - 0110 - Reserved
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL      (20)      //!< Bit position for IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL      (0x00f00000)  //!< Bit mask for IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRPENC_ROT_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PRPENC_ROT_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW2, field PRP_DEST_SEL[27:24] (RW)
 *
 * Pre processing destination select (for channel DMAIC_7)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - IC input buffer (ch12)
 * - 0010 - PP (ch11)
 * - 0011 - PP_ROT (ch47)
 * - 0100 - DC1 (ch28)
 * - 0101 - DC2 (ch41)
 * - 0110 - DP_ASYNC1 (ch24)
 * - 0111 - DP_ASYNC0 (ch29)
 * - 1000 - DP_SYNC1 (ch27)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - Alt DC2 (ch41)
 * - 1011 - Alt DP_ASYNC1 (ch24)
 * - 1100 - Alt DP_ASYNC0 (ch29)
 * - 1111 - Reserved
 */
//@{
#define BP_IPU_FS_PROC_FLOW2_PRP_DEST_SEL      (24)      //!< Bit position for IPU_FS_PROC_FLOW2_PRP_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW2_PRP_DEST_SEL      (0x0f000000)  //!< Bit mask for IPU_FS_PROC_FLOW2_PRP_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW2_PRP_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW2_PRP_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW2_PRP_DEST_SEL) >> BP_IPU_FS_PROC_FLOW2_PRP_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW2_PRP_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW2_PRP_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW2_PRP_DEST_SEL) & BM_IPU_FS_PROC_FLOW2_PRP_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRP_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW2_PRP_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW2_WR(x, (HW_IPU_FS_PROC_FLOW2_RD(x) & ~BM_IPU_FS_PROC_FLOW2_PRP_DEST_SEL) | BF_IPU_FS_PROC_FLOW2_PRP_DEST_SEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_FS_PROC_FLOW3 - FSU Processing Flow 3 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_FS_PROC_FLOW3 - FSU Processing Flow 3 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains controls for IPU's tasks. Hide VPU_SUB_FRAME_SYNC for all versions Show
 * VPU_SUB_FRAME_SYNC for IPUv3H version. The table below tagged with other settings (like
 * IPU3M_only) should be hidden in IPUv3H version. This requires some sophisticated conditional tag
 * settings
 */
typedef union _hw_ipu_fs_proc_flow3
{
    reg32_t U;
    struct _hw_ipu_fs_proc_flow3_bitfields
    {
        unsigned SMFC0_DEST_SEL : 4; //!< [3:0] Destination select for SMFC0
        unsigned SMFC1_DEST_SEL : 3; //!< [6:4] Destination select for SMFC1
        unsigned SMFC2_DEST_SEL : 4; //!< [10:7] Destination select for SMFC2
        unsigned SMFC3_DEST_SEL : 3; //!< [13:11] Destination select for SMFC3
        unsigned RESERVED0 : 2; //!< [15:14] Reserved
        unsigned VDOA_DEST_SEL : 2; //!< [17:16] Destination select for VDOA
        unsigned RESERVED1 : 2; //!< [19:18] Reserved
        unsigned EXT_SRC1_DEST_SEL : 2; //!< [21:20] Destination select for External Source 1
        unsigned EXT_SRC2_DEST_SEL : 2; //!< [23:22] Destination select for External Source 2
        unsigned VPU_DEST_SEL : 2; //!< [25:24] This bits selects the corresponding IDMAC channel's EOL indication to be used for sub frame synchronization with the VPU.
        unsigned RESERVED2 : 6; //!< [31:26] Reserved
    } B;
} hw_ipu_fs_proc_flow3_t;
#endif

/*!
 * @name Constants and macros for entire IPU_FS_PROC_FLOW3 register
 */
//@{
#define HW_IPU_FS_PROC_FLOW3_ADDR(x)      (REGS_IPU_BASE(x) + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_FS_PROC_FLOW3(x)           (*(volatile hw_ipu_fs_proc_flow3_t *) HW_IPU_FS_PROC_FLOW3_ADDR(x))
#define HW_IPU_FS_PROC_FLOW3_RD(x)        (HW_IPU_FS_PROC_FLOW3(x).U)
#define HW_IPU_FS_PROC_FLOW3_WR(x, v)     (HW_IPU_FS_PROC_FLOW3(x).U = (v))
#define HW_IPU_FS_PROC_FLOW3_SET(x, v)    (HW_IPU_FS_PROC_FLOW3_WR(x, HW_IPU_FS_PROC_FLOW3_RD(x) |  (v)))
#define HW_IPU_FS_PROC_FLOW3_CLR(x, v)    (HW_IPU_FS_PROC_FLOW3_WR(x, HW_IPU_FS_PROC_FLOW3_RD(x) & ~(v)))
#define HW_IPU_FS_PROC_FLOW3_TOG(x, v)    (HW_IPU_FS_PROC_FLOW3_WR(x, HW_IPU_FS_PROC_FLOW3_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_FS_PROC_FLOW3 bitfields
 */

/*! @name Register IPU_FS_PROC_FLOW3, field SMFC0_DEST_SEL[3:0] (RW)
 *
 * Destination select for SMFC0
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - IRT Encoding
 * - 0010 - IRT viewfinder
 * - 0011 - IRT playback
 * - 0100 - IC Playback (Post Processing)
 * - 0101 - IC Pre Processing
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL      (0)      //!< Bit position for IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL      (0x0000000f)  //!< Bit mask for IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC0_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_SMFC0_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field SMFC1_DEST_SEL[6:4] (RW)
 *
 * Destination select for SMFC1
 *
 * Values:
 * - 000 - ARM platform
 * - 001 - IRT Encoding
 * - 010 - IRT viewfinder
 * - 011 - IRT playback
 * - 100 - IC Playback (Post Processing)
 * - 101 - IC Pre Processing
 * - 111 - Reserved
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL      (4)      //!< Bit position for IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL      (0x00000070)  //!< Bit mask for IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC1_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_SMFC1_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field SMFC2_DEST_SEL[10:7] (RW)
 *
 * Destination select for SMFC2
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - IRT Encoding
 * - 0010 - IRT viewfinder
 * - 0011 - IRT playback
 * - 0100 - IC Playback (Post Processing)
 * - 0101 - IC Pre Processing
 * - 0111 - DC1 (ch28)
 * - 1000 - DC2 (ch41)
 * - 1001 - DP_SYNC0 (ch23)
 * - 1010 - DP_SYNC1 (ch27)
 * - 1011 - DP_ASYNC1 (ch24)
 * - 1100 - DP_ASYNC0 (ch29)
 * - 1101 - Alt DC2 (ch41)
 * - 1110 - Alt DP_ASYNC1 (ch24)
 * - 1111 - Alt DP_ASYNC0 (ch29)
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL      (7)      //!< Bit position for IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL      (0x00000780)  //!< Bit mask for IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC2_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_SMFC2_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field SMFC3_DEST_SEL[13:11] (RW)
 *
 * Destination select for SMFC3
 *
 * Values:
 * - 000 - ARM platform
 * - 001 - IRT Encoding
 * - 010 - IRT viewfinder
 * - 011 - IRT playback
 * - 100 - IC Playback (Post Processing)
 * - 101 - IC Pre Processing
 * - 111 - Reserved
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL      (11)      //!< Bit position for IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL      (0x00003800)  //!< Bit mask for IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SMFC3_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_SMFC3_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field VDOA_DEST_SEL[17:16] (RW)
 *
 * Destination select for VDOA
 *
 * Values:
 * - 00 - disabled
 * - 01 - IC Playback (Post Processing)
 * - 10 - VDI (ch8,ch9 & ch10 or ch9 according to VDI_MOT_SEL settings)
 * - 11 - Reserved
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL      (16)      //!< Bit position for IPU_FS_PROC_FLOW3_VDOA_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL      (0x00030000)  //!< Bit mask for IPU_FS_PROC_FLOW3_VDOA_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_VDOA_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_VDOA_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDOA_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_VDOA_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field EXT_SRC1_DEST_SEL[21:20] (RW)
 *
 * Destination select for External Source 1
 *
 * Values:
 * - 00 - disabled
 * - 01 - DP_SYNC0 (ch23)
 * - 10 - DP_SYNC1 (ch27)
 * - 11 - DC1 (ch28)
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL      (20)      //!< Bit position for IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL      (0x00300000)  //!< Bit mask for IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXT_SRC1_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_EXT_SRC1_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field EXT_SRC2_DEST_SEL[23:22] (RW)
 *
 * Destination select for External Source 2
 *
 * Values:
 * - 00 - disabled
 * - 01 - DP_SYNC0 (ch23)
 * - 10 - DP_SYNC1 (ch27)
 * - 11 - DC1 (ch28)
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL      (22)      //!< Bit position for IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL      (0x00c00000)  //!< Bit mask for IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXT_SRC2_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_EXT_SRC2_DEST_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_PROC_FLOW3, field VPU_DEST_SEL[25:24] (RW)
 *
 * This bits selects the corresponding IDMAC channel's EOL indication to be used for sub frame
 * synchronization with the VPU. The corresponding IDMAC channel's EOLI bit at the CPMEM has to be
 * set as well.
 *
 * Values:
 * - 00 - disabled
 * - 01 - capture0 (smfc0) (ch0)
 * - 10 - capture2 (smfc2) (ch2)
 * - 11 - IC viewfinder (ch21)
 */
//@{
#define BP_IPU_FS_PROC_FLOW3_VPU_DEST_SEL      (24)      //!< Bit position for IPU_FS_PROC_FLOW3_VPU_DEST_SEL.
#define BM_IPU_FS_PROC_FLOW3_VPU_DEST_SEL      (0x03000000)  //!< Bit mask for IPU_FS_PROC_FLOW3_VPU_DEST_SEL.

//! @brief Get value of IPU_FS_PROC_FLOW3_VPU_DEST_SEL from a register value.
#define BG_IPU_FS_PROC_FLOW3_VPU_DEST_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_PROC_FLOW3_VPU_DEST_SEL) >> BP_IPU_FS_PROC_FLOW3_VPU_DEST_SEL)

//! @brief Format value for bitfield IPU_FS_PROC_FLOW3_VPU_DEST_SEL.
#define BF_IPU_FS_PROC_FLOW3_VPU_DEST_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_PROC_FLOW3_VPU_DEST_SEL) & BM_IPU_FS_PROC_FLOW3_VPU_DEST_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VPU_DEST_SEL field to a new value.
#define BW_IPU_FS_PROC_FLOW3_VPU_DEST_SEL(x, v)   (HW_IPU_FS_PROC_FLOW3_WR(x, (HW_IPU_FS_PROC_FLOW3_RD(x) & ~BM_IPU_FS_PROC_FLOW3_VPU_DEST_SEL) | BF_IPU_FS_PROC_FLOW3_VPU_DEST_SEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_FS_DISP_FLOW1 - FSU Displaying Flow 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_FS_DISP_FLOW1 - FSU Displaying Flow 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains controls for IPU's tasks.
 */
typedef union _hw_ipu_fs_disp_flow1
{
    reg32_t U;
    struct _hw_ipu_fs_disp_flow1_bitfields
    {
        unsigned DP_SYNC0_SRC_SEL : 4; //!< [3:0] Source select for DS2 - MG (graphics) plane (ch23)
        unsigned DP_SYNC1_SRC_SEL : 4; //!< [7:4] Source select for DS1/DS2 - Vx (video) plane (ch27)
        unsigned DP_ASYNC0_SRC_SEL : 4; //!< [11:8] Source select for DS2 - MG (graphics) plane (ch29)
        unsigned DP_ASYNC1_SRC_SEL : 4; //!< [15:12] Source select for DS1/DS2 - Vx (video) plane (ch24)
        unsigned DC2_SRC_SEL : 4; //!< [19:16] Source select for DS3 (ch41)
        unsigned DC1_SRC_SEL : 4; //!< [23:20] Source select for DS1/DS2 - MG (graphics) plane (ch28)
        unsigned RESERVED0 : 8; //!< [31:24] Reserved
    } B;
} hw_ipu_fs_disp_flow1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_FS_DISP_FLOW1 register
 */
//@{
#define HW_IPU_FS_DISP_FLOW1_ADDR(x)      (REGS_IPU_BASE(x) + 0xb4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_FS_DISP_FLOW1(x)           (*(volatile hw_ipu_fs_disp_flow1_t *) HW_IPU_FS_DISP_FLOW1_ADDR(x))
#define HW_IPU_FS_DISP_FLOW1_RD(x)        (HW_IPU_FS_DISP_FLOW1(x).U)
#define HW_IPU_FS_DISP_FLOW1_WR(x, v)     (HW_IPU_FS_DISP_FLOW1(x).U = (v))
#define HW_IPU_FS_DISP_FLOW1_SET(x, v)    (HW_IPU_FS_DISP_FLOW1_WR(x, HW_IPU_FS_DISP_FLOW1_RD(x) |  (v)))
#define HW_IPU_FS_DISP_FLOW1_CLR(x, v)    (HW_IPU_FS_DISP_FLOW1_WR(x, HW_IPU_FS_DISP_FLOW1_RD(x) & ~(v)))
#define HW_IPU_FS_DISP_FLOW1_TOG(x, v)    (HW_IPU_FS_DISP_FLOW1_WR(x, HW_IPU_FS_DISP_FLOW1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_FS_DISP_FLOW1 bitfields
 */

/*! @name Register IPU_FS_DISP_FLOW1, field DP_SYNC0_SRC_SEL[3:0] (RW)
 *
 * Source select for DS2 - MG (graphics) plane (ch23)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL      (0)      //!< Bit position for IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL      (0x0000000f)  //!< Bit mask for IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SYNC0_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DP_SYNC0_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW1, field DP_SYNC1_SRC_SEL[7:4] (RW)
 *
 * Source select for DS1/DS2 - Vx (video) plane (ch27)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL      (4)      //!< Bit position for IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL      (0x000000f0)  //!< Bit mask for IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_SYNC1_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DP_SYNC1_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW1, field DP_ASYNC0_SRC_SEL[11:8] (RW)
 *
 * Source select for DS2 - MG (graphics) plane (ch29)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL      (8)      //!< Bit position for IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL      (0x00000f00)  //!< Bit mask for IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASYNC0_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DP_ASYNC0_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW1, field DP_ASYNC1_SRC_SEL[15:12] (RW)
 *
 * Source select for DS1/DS2 - Vx (video) plane (ch24)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL      (12)      //!< Bit position for IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL      (0x0000f000)  //!< Bit mask for IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASYNC1_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DP_ASYNC1_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW1, field DC2_SRC_SEL[19:16] (RW)
 *
 * Source select for DS3 (ch41)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DC2_SRC_SEL      (16)      //!< Bit position for IPU_FS_DISP_FLOW1_DC2_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DC2_SRC_SEL      (0x000f0000)  //!< Bit mask for IPU_FS_DISP_FLOW1_DC2_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DC2_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DC2_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DC2_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DC2_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DC2_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DC2_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DC2_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DC2_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC2_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DC2_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DC2_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DC2_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW1, field DC1_SRC_SEL[23:20] (RW)
 *
 * Source select for DS1/DS2 - MG (graphics) plane (ch28)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - External source #1 (e.g. an external block like GPU)
 * - 1110 - snoop1
 * - 1111 - External source #2 (e.g. an external block like GPU)
 */
//@{
#define BP_IPU_FS_DISP_FLOW1_DC1_SRC_SEL      (20)      //!< Bit position for IPU_FS_DISP_FLOW1_DC1_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW1_DC1_SRC_SEL      (0x00f00000)  //!< Bit mask for IPU_FS_DISP_FLOW1_DC1_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW1_DC1_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW1_DC1_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW1_DC1_SRC_SEL) >> BP_IPU_FS_DISP_FLOW1_DC1_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW1_DC1_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW1_DC1_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW1_DC1_SRC_SEL) & BM_IPU_FS_DISP_FLOW1_DC1_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC1_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW1_DC1_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW1_WR(x, (HW_IPU_FS_DISP_FLOW1_RD(x) & ~BM_IPU_FS_DISP_FLOW1_DC1_SRC_SEL) | BF_IPU_FS_DISP_FLOW1_DC1_SRC_SEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_FS_DISP_FLOW2 - FSU Displaying Flow 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_FS_DISP_FLOW2 - FSU Displaying Flow 2 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register contains controls for IPU's tasks.
 */
typedef union _hw_ipu_fs_disp_flow2
{
    reg32_t U;
    struct _hw_ipu_fs_disp_flow2_bitfields
    {
        unsigned DP_ASYNC0_ALT_SRC_SEL : 4; //!< [3:0] Source select for alternate DS2 - MG (graphics) plane (ch29)
        unsigned DP_ASYNC1_ALT_SRC_SEL : 4; //!< [7:4] Source select for alternate DS1/DS2 - Vx (video) plane (ch24)
        unsigned RESERVED0 : 8; //!< [15:8] Reserved
        unsigned DC2_ALT_SRC_SEL : 4; //!< [19:16] Source select for Alternate DS3 (ch41)
        unsigned RESERVED1 : 12; //!< [31:20] Reserved
    } B;
} hw_ipu_fs_disp_flow2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_FS_DISP_FLOW2 register
 */
//@{
#define HW_IPU_FS_DISP_FLOW2_ADDR(x)      (REGS_IPU_BASE(x) + 0xb8)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_FS_DISP_FLOW2(x)           (*(volatile hw_ipu_fs_disp_flow2_t *) HW_IPU_FS_DISP_FLOW2_ADDR(x))
#define HW_IPU_FS_DISP_FLOW2_RD(x)        (HW_IPU_FS_DISP_FLOW2(x).U)
#define HW_IPU_FS_DISP_FLOW2_WR(x, v)     (HW_IPU_FS_DISP_FLOW2(x).U = (v))
#define HW_IPU_FS_DISP_FLOW2_SET(x, v)    (HW_IPU_FS_DISP_FLOW2_WR(x, HW_IPU_FS_DISP_FLOW2_RD(x) |  (v)))
#define HW_IPU_FS_DISP_FLOW2_CLR(x, v)    (HW_IPU_FS_DISP_FLOW2_WR(x, HW_IPU_FS_DISP_FLOW2_RD(x) & ~(v)))
#define HW_IPU_FS_DISP_FLOW2_TOG(x, v)    (HW_IPU_FS_DISP_FLOW2_WR(x, HW_IPU_FS_DISP_FLOW2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_FS_DISP_FLOW2 bitfields
 */

/*! @name Register IPU_FS_DISP_FLOW2, field DP_ASYNC0_ALT_SRC_SEL[3:0] (RW)
 *
 * Source select for alternate DS2 - MG (graphics) plane (ch29)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL      (0)      //!< Bit position for IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL      (0x0000000f)  //!< Bit mask for IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL) >> BP_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL) & BM_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASYNC0_ALT_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW2_WR(x, (HW_IPU_FS_DISP_FLOW2_RD(x) & ~BM_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL) | BF_IPU_FS_DISP_FLOW2_DP_ASYNC0_ALT_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW2, field DP_ASYNC1_ALT_SRC_SEL[7:4] (RW)
 *
 * Source select for alternate DS1/DS2 - Vx (video) plane (ch24)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL      (4)      //!< Bit position for IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL      (0x000000f0)  //!< Bit mask for IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL) >> BP_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL) & BM_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASYNC1_ALT_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW2_WR(x, (HW_IPU_FS_DISP_FLOW2_RD(x) & ~BM_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL) | BF_IPU_FS_DISP_FLOW2_DP_ASYNC1_ALT_SRC_SEL(v)))
#endif
//@}

/*! @name Register IPU_FS_DISP_FLOW2, field DC2_ALT_SRC_SEL[19:16] (RW)
 *
 * Source select for Alternate DS3 (ch41)
 *
 * Values:
 * - 0000 - ARM platform
 * - 0001 - capture0 (smfc0)
 * - 0010 - capture2 (smfc2)
 * - 0011 - IC encoding
 * - 0100 - IC viewfinder
 * - 0101 - IC playback
 * - 0110 - IRT Encoding
 * - 0111 - IRT viewfinder
 * - 1000 - IRT playback
 * - 1001 - Reserved
 * - 1010 - Reserved
 * - 1011 - autoref
 * - 1100 - autoref+snoop1
 * - 1101 - autoref+snoop2
 * - 1110 - snoop1
 * - 1111 - snoop2
 */
//@{
#define BP_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL      (16)      //!< Bit position for IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL.
#define BM_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL      (0x000f0000)  //!< Bit mask for IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL.

//! @brief Get value of IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL from a register value.
#define BG_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL) >> BP_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL)

//! @brief Format value for bitfield IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL.
#define BF_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL) & BM_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC2_ALT_SRC_SEL field to a new value.
#define BW_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL(x, v)   (HW_IPU_FS_DISP_FLOW2_WR(x, (HW_IPU_FS_DISP_FLOW2_RD(x) & ~BM_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL) | BF_IPU_FS_DISP_FLOW2_DC2_ALT_SRC_SEL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_SKIP - SKIP Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_SKIP - SKIP Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register controls the different frame skipping supported by the IPU.
 */
typedef union _hw_ipu_skip
{
    reg32_t U;
    struct _hw_ipu_skip_bitfields
    {
        unsigned CSI_MAX_RATIO_SKIP_IC_ENC : 3; //!< [2:0] CSI Maximum Ratio Skip for IC (encoding task)
        unsigned CSI_SKIP_IC_ENC : 5; //!< [7:3] CSI SKIP IC_ENC
        unsigned CSI_MAX_RATIO_SKIP_IC_VF : 3; //!< [10:8] CSI Maximum Ratio Skip for IC (view finder task)
        unsigned CSI_SKIP_IC_VF : 5; //!< [15:11] CSI SKIP IC_VF
        unsigned VDI_MAX_RATIO_SKIP : 4; //!< [19:16] Maximum Ratio Skip for VDI C
        unsigned VDI_SKIP : 12; //!< [31:20] VDI_SKIP
    } B;
} hw_ipu_skip_t;
#endif

/*!
 * @name Constants and macros for entire IPU_SKIP register
 */
//@{
#define HW_IPU_SKIP_ADDR(x)      (REGS_IPU_BASE(x) + 0xbc)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_SKIP(x)           (*(volatile hw_ipu_skip_t *) HW_IPU_SKIP_ADDR(x))
#define HW_IPU_SKIP_RD(x)        (HW_IPU_SKIP(x).U)
#define HW_IPU_SKIP_WR(x, v)     (HW_IPU_SKIP(x).U = (v))
#define HW_IPU_SKIP_SET(x, v)    (HW_IPU_SKIP_WR(x, HW_IPU_SKIP_RD(x) |  (v)))
#define HW_IPU_SKIP_CLR(x, v)    (HW_IPU_SKIP_WR(x, HW_IPU_SKIP_RD(x) & ~(v)))
#define HW_IPU_SKIP_TOG(x, v)    (HW_IPU_SKIP_WR(x, HW_IPU_SKIP_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_SKIP bitfields
 */

/*! @name Register IPU_SKIP, field CSI_MAX_RATIO_SKIP_IC_ENC[2:0] (RW)
 *
 * CSI Maximum Ratio Skip for IC (encoding task) These bits define the number of frames in a
 * skipping set. The maximum value of this bits is 4. When set to 0 the skipping is disabled.
 */
//@{
#define BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC      (0)      //!< Bit position for IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC.
#define BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC      (0x00000007)  //!< Bit mask for IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC.

//! @brief Get value of IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC from a register value.
#define BG_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC) >> BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC)

//! @brief Format value for bitfield IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC.
#define BF_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC) & BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_MAX_RATIO_SKIP_IC_ENC field to a new value.
#define BW_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC) | BF_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_ENC(v)))
#endif
//@}

/*! @name Register IPU_SKIP, field CSI_SKIP_IC_ENC[7:3] (RW)
 *
 * CSI SKIP IC_ENC These 5 bits define the skipping pattern of the frames send to the IC for
 * encoding task from one of the CSIs as defined on the CSI_SEL and IC_INPUT bits Skipping is done
 * for a set of frames. The number of frames in a set is defined at CSI_MAX_RATIO_SKIP_IC_ENC. when
 * CSI_MAX_RATIO_SKIP_IC_ENC = 1 => CSI_SKIP_IC_ENC[1:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_ENC = 2 => CSI_SKIP_IC_ENC[2:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_ENC = 3 => CSI_SKIP_IC_ENC[3:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_ENC = 4 => CSI_SKIP_IC_ENC[4:0] are used; Setting bit #n of CSI_SKIP_IC_ENC
 * means that the #n frame in the set is skipped. For example: if CSI_MAX_RATIO_SKIP_IC_ENC = 4 and
 * CSI_SKIP_IC_ENC = 11010 Frames #0 & Frame #2 will not be skipped as bit0 and bit2 are cleared
 * Frames #1 & Frame #3 will be skipped as bit1 and bit3 are set bit #4 is ignored as
 * CSI_MAX_RATIO_SKIP_IC_ENC is set to 4
 */
//@{
#define BP_IPU_SKIP_CSI_SKIP_IC_ENC      (3)      //!< Bit position for IPU_SKIP_CSI_SKIP_IC_ENC.
#define BM_IPU_SKIP_CSI_SKIP_IC_ENC      (0x000000f8)  //!< Bit mask for IPU_SKIP_CSI_SKIP_IC_ENC.

//! @brief Get value of IPU_SKIP_CSI_SKIP_IC_ENC from a register value.
#define BG_IPU_SKIP_CSI_SKIP_IC_ENC(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_CSI_SKIP_IC_ENC) >> BP_IPU_SKIP_CSI_SKIP_IC_ENC)

//! @brief Format value for bitfield IPU_SKIP_CSI_SKIP_IC_ENC.
#define BF_IPU_SKIP_CSI_SKIP_IC_ENC(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_CSI_SKIP_IC_ENC) & BM_IPU_SKIP_CSI_SKIP_IC_ENC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_SKIP_IC_ENC field to a new value.
#define BW_IPU_SKIP_CSI_SKIP_IC_ENC(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_CSI_SKIP_IC_ENC) | BF_IPU_SKIP_CSI_SKIP_IC_ENC(v)))
#endif
//@}

/*! @name Register IPU_SKIP, field CSI_MAX_RATIO_SKIP_IC_VF[10:8] (RW)
 *
 * CSI Maximum Ratio Skip for IC (view finder task) These bits define the number of frames in a
 * skipping set. The maximum value of this bits is 4. When set to 0 the skipping is disabled.
 */
//@{
#define BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF      (8)      //!< Bit position for IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF.
#define BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF      (0x00000700)  //!< Bit mask for IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF.

//! @brief Get value of IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF from a register value.
#define BG_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF) >> BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF)

//! @brief Format value for bitfield IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF.
#define BF_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF) & BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_MAX_RATIO_SKIP_IC_VF field to a new value.
#define BW_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF) | BF_IPU_SKIP_CSI_MAX_RATIO_SKIP_IC_VF(v)))
#endif
//@}

/*! @name Register IPU_SKIP, field CSI_SKIP_IC_VF[15:11] (RW)
 *
 * CSI SKIP IC_VF These 5 bits define the skipping pattern of the frames send to the IC for view
 * finder task from one of the CSIs as defined on the CSI_SEL and IC_INPUT bits Skipping is done for
 * a set of frames. The number of frames in a set is defined at CSI_MAX_RATIO_SKIP_IC_VF. when
 * CSI_MAX_RATIO_SKIP_IC_VF = 1 => CSI_SKIP_IC_VF[1:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_VF = 2 => CSI_SKIP_IC_VF[2:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_VF =3 => CSI_SKIP_IC_VF[3:0] are used; other bits are ignored when
 * CSI_MAX_RATIO_SKIP_IC_VF = 4 => CSI_SKIP_IC_VF[4:0] are used; Setting bit #n of CSI_SKIP_IC_VF
 * means that the #n frame in the set is skipped. For example: if CSI_MAX_RATIO_SKIP_IC_VF = 4 and
 * CSI_SKIP_IC_VF = 11010 Frames #0 & Frame #2 will not be skipped as bit0 and bit2 are cleared
 * Frames #1 & Frame #3 will be skipped as bit1 and bit3 are set bit #4 is ignored as
 * CSI_MAX_RATIO_SKIP_IC_VF is set to 4
 */
//@{
#define BP_IPU_SKIP_CSI_SKIP_IC_VF      (11)      //!< Bit position for IPU_SKIP_CSI_SKIP_IC_VF.
#define BM_IPU_SKIP_CSI_SKIP_IC_VF      (0x0000f800)  //!< Bit mask for IPU_SKIP_CSI_SKIP_IC_VF.

//! @brief Get value of IPU_SKIP_CSI_SKIP_IC_VF from a register value.
#define BG_IPU_SKIP_CSI_SKIP_IC_VF(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_CSI_SKIP_IC_VF) >> BP_IPU_SKIP_CSI_SKIP_IC_VF)

//! @brief Format value for bitfield IPU_SKIP_CSI_SKIP_IC_VF.
#define BF_IPU_SKIP_CSI_SKIP_IC_VF(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_CSI_SKIP_IC_VF) & BM_IPU_SKIP_CSI_SKIP_IC_VF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_SKIP_IC_VF field to a new value.
#define BW_IPU_SKIP_CSI_SKIP_IC_VF(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_CSI_SKIP_IC_VF) | BF_IPU_SKIP_CSI_SKIP_IC_VF(v)))
#endif
//@}

/*! @name Register IPU_SKIP, field VDI_MAX_RATIO_SKIP[19:16] (RW)
 *
 * Maximum Ratio Skip for VDI C These bits define the number of frames in a skipping set. The
 * maximum value of this bits is 11. When set to 0 the skipping is disabled.
 */
//@{
#define BP_IPU_SKIP_VDI_MAX_RATIO_SKIP      (16)      //!< Bit position for IPU_SKIP_VDI_MAX_RATIO_SKIP.
#define BM_IPU_SKIP_VDI_MAX_RATIO_SKIP      (0x000f0000)  //!< Bit mask for IPU_SKIP_VDI_MAX_RATIO_SKIP.

//! @brief Get value of IPU_SKIP_VDI_MAX_RATIO_SKIP from a register value.
#define BG_IPU_SKIP_VDI_MAX_RATIO_SKIP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_VDI_MAX_RATIO_SKIP) >> BP_IPU_SKIP_VDI_MAX_RATIO_SKIP)

//! @brief Format value for bitfield IPU_SKIP_VDI_MAX_RATIO_SKIP.
#define BF_IPU_SKIP_VDI_MAX_RATIO_SKIP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_VDI_MAX_RATIO_SKIP) & BM_IPU_SKIP_VDI_MAX_RATIO_SKIP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_MAX_RATIO_SKIP field to a new value.
#define BW_IPU_SKIP_VDI_MAX_RATIO_SKIP(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_VDI_MAX_RATIO_SKIP) | BF_IPU_SKIP_VDI_MAX_RATIO_SKIP(v)))
#endif
//@}

/*! @name Register IPU_SKIP, field VDI_SKIP[31:20] (RW)
 *
 * VDI_SKIP These 12 bits define the skipping pattern of the frames send from the VDI C . The VDI C
 * avoids reading fields from the memory if the output frame is skipped. Skipping is relevant only
 * if the source to the VDI C is coming from the CSI. Skipping is done for a set of frames. The
 * number of frames in a set is defined at VDI_MAX_RATIO_SKIP. when VDI_MAX_RATIO_SKIP = 1 =>
 * VDI_SKIP[1:0] is used; other bits are ignored when VDI_MAX_RATIO_SKIP = 2 => VDI_SKIP[2:0] are
 * used; other bits are ignored .. .. when VDI_MAX_RATIO_SKIP = 11 => VDI_SKIP[11:0] are used;
 */
//@{
#define BP_IPU_SKIP_VDI_SKIP      (20)      //!< Bit position for IPU_SKIP_VDI_SKIP.
#define BM_IPU_SKIP_VDI_SKIP      (0xfff00000)  //!< Bit mask for IPU_SKIP_VDI_SKIP.

//! @brief Get value of IPU_SKIP_VDI_SKIP from a register value.
#define BG_IPU_SKIP_VDI_SKIP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_SKIP_VDI_SKIP) >> BP_IPU_SKIP_VDI_SKIP)

//! @brief Format value for bitfield IPU_SKIP_VDI_SKIP.
#define BF_IPU_SKIP_VDI_SKIP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_SKIP_VDI_SKIP) & BM_IPU_SKIP_VDI_SKIP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VDI_SKIP field to a new value.
#define BW_IPU_SKIP_VDI_SKIP(x, v)   (HW_IPU_SKIP_WR(x, (HW_IPU_SKIP_RD(x) & ~BM_IPU_SKIP_VDI_SKIP) | BF_IPU_SKIP_VDI_SKIP(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_ALT_CONF - Display Alternate Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_ALT_CONF - Display Alternate Configuration Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register controls various parameters that are used for alternate flows related to the
 * display modules.
 */
typedef union _hw_ipu_disp_alt_conf
{
    reg32_t U;
    struct _hw_ipu_disp_alt_conf_bitfields
    {
        unsigned RESERVED0 : 32; //!< [31:0] Reserved
    } B;
} hw_ipu_disp_alt_conf_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_ALT_CONF register
 */
//@{
#define HW_IPU_DISP_ALT_CONF_ADDR(x)      (REGS_IPU_BASE(x) + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_ALT_CONF(x)           (*(volatile hw_ipu_disp_alt_conf_t *) HW_IPU_DISP_ALT_CONF_ADDR(x))
#define HW_IPU_DISP_ALT_CONF_RD(x)        (HW_IPU_DISP_ALT_CONF(x).U)
#define HW_IPU_DISP_ALT_CONF_WR(x, v)     (HW_IPU_DISP_ALT_CONF(x).U = (v))
#define HW_IPU_DISP_ALT_CONF_SET(x, v)    (HW_IPU_DISP_ALT_CONF_WR(x, HW_IPU_DISP_ALT_CONF_RD(x) |  (v)))
#define HW_IPU_DISP_ALT_CONF_CLR(x, v)    (HW_IPU_DISP_ALT_CONF_WR(x, HW_IPU_DISP_ALT_CONF_RD(x) & ~(v)))
#define HW_IPU_DISP_ALT_CONF_TOG(x, v)    (HW_IPU_DISP_ALT_CONF_WR(x, HW_IPU_DISP_ALT_CONF_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_ALT_CONF bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_GEN - Display General Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_GEN - Display General Control Register (RW)
 *
 * Reset value: 0x00400000
 *
 * This register controls various aspects of the display port.
 */
typedef union _hw_ipu_disp_gen
{
    reg32_t U;
    struct _hw_ipu_disp_gen_bitfields
    {
        unsigned DI0_DUAL_MODE : 1; //!< [0] DI0 dual mode control
        unsigned DI1_DUAL_MODE : 1; //!< [1] DI1 dual mode control
        unsigned DC2_DOUBLE_FLOW : 1; //!< [2] DC2 Double Flow.
        unsigned DP_ASYNC_DOUBLE_FLOW : 1; //!< [3] DP Async Double Flow.
        unsigned DP_FG_EN_ASYNC0 : 1; //!< [4] FG_EN - partial plane Enable for async flow 0.
        unsigned DP_FG_EN_ASYNC1 : 1; //!< [5] FG_EN - partial plane Enable for async flow 1.
        unsigned DP_PIPE_CLR : 1; //!< [6] DP Pipe Clear
        unsigned RESERVED0 : 9; //!< [15:7] Reserved
        unsigned MCU_DI_ID_8 : 1; //!< [16] MCU_DI_ID_8 - DI ID via DC channel 8.
        unsigned MCU_DI_ID_9 : 1; //!< [17] MCU_DI_ID_9 - DI ID via DC channel 9.
        unsigned MCU_T : 4; //!< [21:18] The address space for accesses through the AHB-lite slave port is MB and it is split internally (with 32MB resolution) according to bits [28:25] of the address.
        unsigned MCU_MAX_BURST_STOP : 1; //!< [22] ARM platform Maximal burst
        unsigned CSI_VSYNC_DEST : 1; //!< [23] CSI_VSYNC destination
        unsigned DI0_COUNTER_RELEASE : 1; //!< [24] DI1 Counter release
        unsigned DI1_COUNTER_RELEASE : 1; //!< [25] DI1 Counter release
        unsigned RESERVED1 : 6; //!< [31:26] Reserved
    } B;
} hw_ipu_disp_gen_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_GEN register
 */
//@{
#define HW_IPU_DISP_GEN_ADDR(x)      (REGS_IPU_BASE(x) + 0xc4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_GEN(x)           (*(volatile hw_ipu_disp_gen_t *) HW_IPU_DISP_GEN_ADDR(x))
#define HW_IPU_DISP_GEN_RD(x)        (HW_IPU_DISP_GEN(x).U)
#define HW_IPU_DISP_GEN_WR(x, v)     (HW_IPU_DISP_GEN(x).U = (v))
#define HW_IPU_DISP_GEN_SET(x, v)    (HW_IPU_DISP_GEN_WR(x, HW_IPU_DISP_GEN_RD(x) |  (v)))
#define HW_IPU_DISP_GEN_CLR(x, v)    (HW_IPU_DISP_GEN_WR(x, HW_IPU_DISP_GEN_RD(x) & ~(v)))
#define HW_IPU_DISP_GEN_TOG(x, v)    (HW_IPU_DISP_GEN_WR(x, HW_IPU_DISP_GEN_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_GEN bitfields
 */

/*! @name Register IPU_DISP_GEN, field DI0_DUAL_MODE[0] (RW)
 *
 * DI0 dual mode control
 *
 * Values:
 * - 0 - DI0 is not in dual mode
 * - 1 - DI0 operates in dual mode
 */
//@{
#define BP_IPU_DISP_GEN_DI0_DUAL_MODE      (0)      //!< Bit position for IPU_DISP_GEN_DI0_DUAL_MODE.
#define BM_IPU_DISP_GEN_DI0_DUAL_MODE      (0x00000001)  //!< Bit mask for IPU_DISP_GEN_DI0_DUAL_MODE.

//! @brief Get value of IPU_DISP_GEN_DI0_DUAL_MODE from a register value.
#define BG_IPU_DISP_GEN_DI0_DUAL_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DI0_DUAL_MODE) >> BP_IPU_DISP_GEN_DI0_DUAL_MODE)

//! @brief Format value for bitfield IPU_DISP_GEN_DI0_DUAL_MODE.
#define BF_IPU_DISP_GEN_DI0_DUAL_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DI0_DUAL_MODE) & BM_IPU_DISP_GEN_DI0_DUAL_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_DUAL_MODE field to a new value.
#define BW_IPU_DISP_GEN_DI0_DUAL_MODE(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DI0_DUAL_MODE) | BF_IPU_DISP_GEN_DI0_DUAL_MODE(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DI1_DUAL_MODE[1] (RW)
 *
 * DI1 dual mode control
 *
 * Values:
 * - 0 - DI1 is not in dual mode
 * - 1 - DI1 operates in dual mode
 */
//@{
#define BP_IPU_DISP_GEN_DI1_DUAL_MODE      (1)      //!< Bit position for IPU_DISP_GEN_DI1_DUAL_MODE.
#define BM_IPU_DISP_GEN_DI1_DUAL_MODE      (0x00000002)  //!< Bit mask for IPU_DISP_GEN_DI1_DUAL_MODE.

//! @brief Get value of IPU_DISP_GEN_DI1_DUAL_MODE from a register value.
#define BG_IPU_DISP_GEN_DI1_DUAL_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DI1_DUAL_MODE) >> BP_IPU_DISP_GEN_DI1_DUAL_MODE)

//! @brief Format value for bitfield IPU_DISP_GEN_DI1_DUAL_MODE.
#define BF_IPU_DISP_GEN_DI1_DUAL_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DI1_DUAL_MODE) & BM_IPU_DISP_GEN_DI1_DUAL_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_DUAL_MODE field to a new value.
#define BW_IPU_DISP_GEN_DI1_DUAL_MODE(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DI1_DUAL_MODE) | BF_IPU_DISP_GEN_DI1_DUAL_MODE(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DC2_DOUBLE_FLOW[2] (RW)
 *
 * DC2 Double Flow. This bit define how many flows are currently handles via DC2 channel (ch41)
 *
 * Values:
 * - 0 - single flow is handled via DC2
 * - 1 - 2 flows are handled via DC2
 */
//@{
#define BP_IPU_DISP_GEN_DC2_DOUBLE_FLOW      (2)      //!< Bit position for IPU_DISP_GEN_DC2_DOUBLE_FLOW.
#define BM_IPU_DISP_GEN_DC2_DOUBLE_FLOW      (0x00000004)  //!< Bit mask for IPU_DISP_GEN_DC2_DOUBLE_FLOW.

//! @brief Get value of IPU_DISP_GEN_DC2_DOUBLE_FLOW from a register value.
#define BG_IPU_DISP_GEN_DC2_DOUBLE_FLOW(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DC2_DOUBLE_FLOW) >> BP_IPU_DISP_GEN_DC2_DOUBLE_FLOW)

//! @brief Format value for bitfield IPU_DISP_GEN_DC2_DOUBLE_FLOW.
#define BF_IPU_DISP_GEN_DC2_DOUBLE_FLOW(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DC2_DOUBLE_FLOW) & BM_IPU_DISP_GEN_DC2_DOUBLE_FLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DC2_DOUBLE_FLOW field to a new value.
#define BW_IPU_DISP_GEN_DC2_DOUBLE_FLOW(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DC2_DOUBLE_FLOW) | BF_IPU_DISP_GEN_DC2_DOUBLE_FLOW(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DP_ASYNC_DOUBLE_FLOW[3] (RW)
 *
 * DP Async Double Flow. This bit define how many async flows are currently handles via DP channel
 * (ch24+29)
 *
 * Values:
 * - 0 - single flow is handled via DP
 * - 1 - 2 flows are handled via DP
 */
//@{
#define BP_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW      (3)      //!< Bit position for IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW.
#define BM_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW      (0x00000008)  //!< Bit mask for IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW.

//! @brief Get value of IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW from a register value.
#define BG_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW) >> BP_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW)

//! @brief Format value for bitfield IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW.
#define BF_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW) & BM_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_ASYNC_DOUBLE_FLOW field to a new value.
#define BW_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW) | BF_IPU_DISP_GEN_DP_ASYNC_DOUBLE_FLOW(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DP_FG_EN_ASYNC0[4] (RW)
 *
 * FG_EN - partial plane Enable for async flow 0. This bit enables the partial plane channel.
 *
 * Values:
 * - 0 - partial plane channel is disabled.
 * - 1 - partial plane channel is enabled.
 */
//@{
#define BP_IPU_DISP_GEN_DP_FG_EN_ASYNC0      (4)      //!< Bit position for IPU_DISP_GEN_DP_FG_EN_ASYNC0.
#define BM_IPU_DISP_GEN_DP_FG_EN_ASYNC0      (0x00000010)  //!< Bit mask for IPU_DISP_GEN_DP_FG_EN_ASYNC0.

//! @brief Get value of IPU_DISP_GEN_DP_FG_EN_ASYNC0 from a register value.
#define BG_IPU_DISP_GEN_DP_FG_EN_ASYNC0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DP_FG_EN_ASYNC0) >> BP_IPU_DISP_GEN_DP_FG_EN_ASYNC0)

//! @brief Format value for bitfield IPU_DISP_GEN_DP_FG_EN_ASYNC0.
#define BF_IPU_DISP_GEN_DP_FG_EN_ASYNC0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DP_FG_EN_ASYNC0) & BM_IPU_DISP_GEN_DP_FG_EN_ASYNC0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_FG_EN_ASYNC0 field to a new value.
#define BW_IPU_DISP_GEN_DP_FG_EN_ASYNC0(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DP_FG_EN_ASYNC0) | BF_IPU_DISP_GEN_DP_FG_EN_ASYNC0(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DP_FG_EN_ASYNC1[5] (RW)
 *
 * FG_EN - partial plane Enable for async flow 1. This bit enables the partial plane channel.
 *
 * Values:
 * - 0 - partial plane channel is disabled.
 * - 1 - partial plane channel is enabled.
 */
//@{
#define BP_IPU_DISP_GEN_DP_FG_EN_ASYNC1      (5)      //!< Bit position for IPU_DISP_GEN_DP_FG_EN_ASYNC1.
#define BM_IPU_DISP_GEN_DP_FG_EN_ASYNC1      (0x00000020)  //!< Bit mask for IPU_DISP_GEN_DP_FG_EN_ASYNC1.

//! @brief Get value of IPU_DISP_GEN_DP_FG_EN_ASYNC1 from a register value.
#define BG_IPU_DISP_GEN_DP_FG_EN_ASYNC1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DP_FG_EN_ASYNC1) >> BP_IPU_DISP_GEN_DP_FG_EN_ASYNC1)

//! @brief Format value for bitfield IPU_DISP_GEN_DP_FG_EN_ASYNC1.
#define BF_IPU_DISP_GEN_DP_FG_EN_ASYNC1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DP_FG_EN_ASYNC1) & BM_IPU_DISP_GEN_DP_FG_EN_ASYNC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DP_FG_EN_ASYNC1 field to a new value.
#define BW_IPU_DISP_GEN_DP_FG_EN_ASYNC1(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DP_FG_EN_ASYNC1) | BF_IPU_DISP_GEN_DP_FG_EN_ASYNC1(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DP_PIPE_CLR[6] (WORZ)
 *
 * DP Pipe Clear This bit clears the internal pipe of the DP. The user may use this bit in case of
 * an error condition This is a self clear bit
 *
 * Values:
 * - 0 - Idle - does nothing
 * - 1 - Clear the internal pipe of the DP
 */
//@{
#define BP_IPU_DISP_GEN_DP_PIPE_CLR      (6)      //!< Bit position for IPU_DISP_GEN_DP_PIPE_CLR.
#define BM_IPU_DISP_GEN_DP_PIPE_CLR      (0x00000040)  //!< Bit mask for IPU_DISP_GEN_DP_PIPE_CLR.

//! @brief Get value of IPU_DISP_GEN_DP_PIPE_CLR from a register value.
#define BG_IPU_DISP_GEN_DP_PIPE_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DP_PIPE_CLR) >> BP_IPU_DISP_GEN_DP_PIPE_CLR)

//! @brief Format value for bitfield IPU_DISP_GEN_DP_PIPE_CLR.
#define BF_IPU_DISP_GEN_DP_PIPE_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DP_PIPE_CLR) & BM_IPU_DISP_GEN_DP_PIPE_CLR)
//@}

/*! @name Register IPU_DISP_GEN, field MCU_DI_ID_8[16] (RW)
 *
 * MCU_DI_ID_8 - DI ID via DC channel 8. This bit defines the DI that the ARM platform DC's access
 * via channel #8
 *
 * Values:
 * - 0 - ARM platform accesses DC's channel #8 via DI0.
 * - 1 - ARM platform accesses DC's channel #8 via DI1.
 */
//@{
#define BP_IPU_DISP_GEN_MCU_DI_ID_8      (16)      //!< Bit position for IPU_DISP_GEN_MCU_DI_ID_8.
#define BM_IPU_DISP_GEN_MCU_DI_ID_8      (0x00010000)  //!< Bit mask for IPU_DISP_GEN_MCU_DI_ID_8.

//! @brief Get value of IPU_DISP_GEN_MCU_DI_ID_8 from a register value.
#define BG_IPU_DISP_GEN_MCU_DI_ID_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_MCU_DI_ID_8) >> BP_IPU_DISP_GEN_MCU_DI_ID_8)

//! @brief Format value for bitfield IPU_DISP_GEN_MCU_DI_ID_8.
#define BF_IPU_DISP_GEN_MCU_DI_ID_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_MCU_DI_ID_8) & BM_IPU_DISP_GEN_MCU_DI_ID_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCU_DI_ID_8 field to a new value.
#define BW_IPU_DISP_GEN_MCU_DI_ID_8(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_MCU_DI_ID_8) | BF_IPU_DISP_GEN_MCU_DI_ID_8(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field MCU_DI_ID_9[17] (RW)
 *
 * MCU_DI_ID_9 - DI ID via DC channel 9. This bit defines the DI that the ARM platform DC's access
 * via channel #9
 *
 * Values:
 * - 0 - ARM platform accesses DC's channel #9 via DI0.
 * - 1 - ARM platform accesses DC's channel #9 via DI1.
 */
//@{
#define BP_IPU_DISP_GEN_MCU_DI_ID_9      (17)      //!< Bit position for IPU_DISP_GEN_MCU_DI_ID_9.
#define BM_IPU_DISP_GEN_MCU_DI_ID_9      (0x00020000)  //!< Bit mask for IPU_DISP_GEN_MCU_DI_ID_9.

//! @brief Get value of IPU_DISP_GEN_MCU_DI_ID_9 from a register value.
#define BG_IPU_DISP_GEN_MCU_DI_ID_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_MCU_DI_ID_9) >> BP_IPU_DISP_GEN_MCU_DI_ID_9)

//! @brief Format value for bitfield IPU_DISP_GEN_MCU_DI_ID_9.
#define BF_IPU_DISP_GEN_MCU_DI_ID_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_MCU_DI_ID_9) & BM_IPU_DISP_GEN_MCU_DI_ID_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCU_DI_ID_9 field to a new value.
#define BW_IPU_DISP_GEN_MCU_DI_ID_9(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_MCU_DI_ID_9) | BF_IPU_DISP_GEN_MCU_DI_ID_9(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field MCU_T[21:18] (RW)
 *
 * The address space for accesses through the AHB-lite slave port is MB and it is split internally
 * (with 32MB resolution) according to bits [28:25] of the address. Using the following notation:
 * Address = (ID[31:29], MSB[28:25], LSB[24:0]) The address is used as follows ("T" is a
 * configurable integer between 0 and 13): MSB<T: access to an external device, with address = (MSB,
 * LSB) T<=MSB<14: access to an external device, with address (MSB-T, LSB)
 */
//@{
#define BP_IPU_DISP_GEN_MCU_T      (18)      //!< Bit position for IPU_DISP_GEN_MCU_T.
#define BM_IPU_DISP_GEN_MCU_T      (0x003c0000)  //!< Bit mask for IPU_DISP_GEN_MCU_T.

//! @brief Get value of IPU_DISP_GEN_MCU_T from a register value.
#define BG_IPU_DISP_GEN_MCU_T(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_MCU_T) >> BP_IPU_DISP_GEN_MCU_T)

//! @brief Format value for bitfield IPU_DISP_GEN_MCU_T.
#define BF_IPU_DISP_GEN_MCU_T(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_MCU_T) & BM_IPU_DISP_GEN_MCU_T)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCU_T field to a new value.
#define BW_IPU_DISP_GEN_MCU_T(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_MCU_T) | BF_IPU_DISP_GEN_MCU_T(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field MCU_MAX_BURST_STOP[22] (RW)
 *
 * ARM platform Maximal burst This bit limit the maximal unspecified length burst.
 *
 * Values:
 * - 0 - The unspecified burst length is unlimited
 * - 1 - The maximum unspecified burst length is 8-beat
 */
//@{
#define BP_IPU_DISP_GEN_MCU_MAX_BURST_STOP      (22)      //!< Bit position for IPU_DISP_GEN_MCU_MAX_BURST_STOP.
#define BM_IPU_DISP_GEN_MCU_MAX_BURST_STOP      (0x00400000)  //!< Bit mask for IPU_DISP_GEN_MCU_MAX_BURST_STOP.

//! @brief Get value of IPU_DISP_GEN_MCU_MAX_BURST_STOP from a register value.
#define BG_IPU_DISP_GEN_MCU_MAX_BURST_STOP(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_MCU_MAX_BURST_STOP) >> BP_IPU_DISP_GEN_MCU_MAX_BURST_STOP)

//! @brief Format value for bitfield IPU_DISP_GEN_MCU_MAX_BURST_STOP.
#define BF_IPU_DISP_GEN_MCU_MAX_BURST_STOP(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_MCU_MAX_BURST_STOP) & BM_IPU_DISP_GEN_MCU_MAX_BURST_STOP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MCU_MAX_BURST_STOP field to a new value.
#define BW_IPU_DISP_GEN_MCU_MAX_BURST_STOP(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_MCU_MAX_BURST_STOP) | BF_IPU_DISP_GEN_MCU_MAX_BURST_STOP(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field CSI_VSYNC_DEST[23] (RW)
 *
 * CSI_VSYNC destination This bit defines the destination of the VSYNC coming from the CSI's
 *
 * Values:
 * - 0 - csi0_vsync is connected to DI0; csi1_vsync is connected to DI1
 * - 1 - csi1_vsync is connected to DI0; csi0_vsync is connected to DI1
 */
//@{
#define BP_IPU_DISP_GEN_CSI_VSYNC_DEST      (23)      //!< Bit position for IPU_DISP_GEN_CSI_VSYNC_DEST.
#define BM_IPU_DISP_GEN_CSI_VSYNC_DEST      (0x00800000)  //!< Bit mask for IPU_DISP_GEN_CSI_VSYNC_DEST.

//! @brief Get value of IPU_DISP_GEN_CSI_VSYNC_DEST from a register value.
#define BG_IPU_DISP_GEN_CSI_VSYNC_DEST(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_CSI_VSYNC_DEST) >> BP_IPU_DISP_GEN_CSI_VSYNC_DEST)

//! @brief Format value for bitfield IPU_DISP_GEN_CSI_VSYNC_DEST.
#define BF_IPU_DISP_GEN_CSI_VSYNC_DEST(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_CSI_VSYNC_DEST) & BM_IPU_DISP_GEN_CSI_VSYNC_DEST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CSI_VSYNC_DEST field to a new value.
#define BW_IPU_DISP_GEN_CSI_VSYNC_DEST(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_CSI_VSYNC_DEST) | BF_IPU_DISP_GEN_CSI_VSYNC_DEST(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DI0_COUNTER_RELEASE[24] (RW)
 *
 * DI1 Counter release By default the DI0 counters responsible for waveform generation for sync flow
 * are frozen. For the first attempt to use the DI in sync flow the user should set this bit
 *
 * Values:
 * - 0 - counter is cleared and stopped
 * - 1 - counter is released and running
 */
//@{
#define BP_IPU_DISP_GEN_DI0_COUNTER_RELEASE      (24)      //!< Bit position for IPU_DISP_GEN_DI0_COUNTER_RELEASE.
#define BM_IPU_DISP_GEN_DI0_COUNTER_RELEASE      (0x01000000)  //!< Bit mask for IPU_DISP_GEN_DI0_COUNTER_RELEASE.

//! @brief Get value of IPU_DISP_GEN_DI0_COUNTER_RELEASE from a register value.
#define BG_IPU_DISP_GEN_DI0_COUNTER_RELEASE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DI0_COUNTER_RELEASE) >> BP_IPU_DISP_GEN_DI0_COUNTER_RELEASE)

//! @brief Format value for bitfield IPU_DISP_GEN_DI0_COUNTER_RELEASE.
#define BF_IPU_DISP_GEN_DI0_COUNTER_RELEASE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DI0_COUNTER_RELEASE) & BM_IPU_DISP_GEN_DI0_COUNTER_RELEASE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_COUNTER_RELEASE field to a new value.
#define BW_IPU_DISP_GEN_DI0_COUNTER_RELEASE(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DI0_COUNTER_RELEASE) | BF_IPU_DISP_GEN_DI0_COUNTER_RELEASE(v)))
#endif
//@}

/*! @name Register IPU_DISP_GEN, field DI1_COUNTER_RELEASE[25] (RW)
 *
 * DI1 Counter release By default the DI0 counters responsible for waveform generation for sync flow
 * are frozen. For the first attempt to use the DI in sync flow the user should set this bit
 *
 * Values:
 * - 0 - counter is cleared and stopped
 * - 1 - counter is released and running
 */
//@{
#define BP_IPU_DISP_GEN_DI1_COUNTER_RELEASE      (25)      //!< Bit position for IPU_DISP_GEN_DI1_COUNTER_RELEASE.
#define BM_IPU_DISP_GEN_DI1_COUNTER_RELEASE      (0x02000000)  //!< Bit mask for IPU_DISP_GEN_DI1_COUNTER_RELEASE.

//! @brief Get value of IPU_DISP_GEN_DI1_COUNTER_RELEASE from a register value.
#define BG_IPU_DISP_GEN_DI1_COUNTER_RELEASE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_GEN_DI1_COUNTER_RELEASE) >> BP_IPU_DISP_GEN_DI1_COUNTER_RELEASE)

//! @brief Format value for bitfield IPU_DISP_GEN_DI1_COUNTER_RELEASE.
#define BF_IPU_DISP_GEN_DI1_COUNTER_RELEASE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_GEN_DI1_COUNTER_RELEASE) & BM_IPU_DISP_GEN_DI1_COUNTER_RELEASE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_COUNTER_RELEASE field to a new value.
#define BW_IPU_DISP_GEN_DI1_COUNTER_RELEASE(x, v)   (HW_IPU_DISP_GEN_WR(x, (HW_IPU_DISP_GEN_RD(x) & ~BM_IPU_DISP_GEN_DI1_COUNTER_RELEASE) | BF_IPU_DISP_GEN_DI1_COUNTER_RELEASE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_ALT1 - Display Alternate Flow Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_ALT1 - Display Alternate Flow Control Register 1 (RW)
 *
 * Reset value: 0x00400000
 *
 * This register controls various aspects of the display port.
 */
typedef union _hw_ipu_disp_alt1
{
    reg32_t U;
    struct _hw_ipu_disp_alt1_bitfields
    {
        unsigned RUN_VALUE_M1_ALT_0 : 12; //!< [11:0] Counter pre defined value
        unsigned CNT_CLR_SEL_ALT_0 : 3; //!< [14:12] Counter Clear select
        unsigned CNT_AUTO_RELOAD_ALT_0 : 1; //!< [15] Counter auto reload mode
        unsigned STEP_REPEAT_ALT_0 : 12; //!< [27:16] This fields defines the amount of repetitions that will be performed by the counter
        unsigned SEL_ALT_0 : 4; //!< [31:28] Select alternative parameters instead of DI Sync Wave Gen counter#.
    } B;
} hw_ipu_disp_alt1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_ALT1 register
 */
//@{
#define HW_IPU_DISP_ALT1_ADDR(x)      (REGS_IPU_BASE(x) + 0xc8)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_ALT1(x)           (*(volatile hw_ipu_disp_alt1_t *) HW_IPU_DISP_ALT1_ADDR(x))
#define HW_IPU_DISP_ALT1_RD(x)        (HW_IPU_DISP_ALT1(x).U)
#define HW_IPU_DISP_ALT1_WR(x, v)     (HW_IPU_DISP_ALT1(x).U = (v))
#define HW_IPU_DISP_ALT1_SET(x, v)    (HW_IPU_DISP_ALT1_WR(x, HW_IPU_DISP_ALT1_RD(x) |  (v)))
#define HW_IPU_DISP_ALT1_CLR(x, v)    (HW_IPU_DISP_ALT1_WR(x, HW_IPU_DISP_ALT1_RD(x) & ~(v)))
#define HW_IPU_DISP_ALT1_TOG(x, v)    (HW_IPU_DISP_ALT1_WR(x, HW_IPU_DISP_ALT1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_ALT1 bitfields
 */

/*! @name Register IPU_DISP_ALT1, field RUN_VALUE_M1_ALT_0[11:0] (RW)
 *
 * Counter pre defined value This fields defines the counter pre defines value. real value- 1
 */
//@{
#define BP_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0      (0)      //!< Bit position for IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0.
#define BM_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0      (0x00000fff)  //!< Bit mask for IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0.

//! @brief Get value of IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0 from a register value.
#define BG_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0) >> BP_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0.
#define BF_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0) & BM_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RUN_VALUE_M1_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0(x, v)   (HW_IPU_DISP_ALT1_WR(x, (HW_IPU_DISP_ALT1_RD(x) & ~BM_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0) | BF_IPU_DISP_ALT1_RUN_VALUE_M1_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT1, field CNT_CLR_SEL_ALT_0[14:12] (RW)
 *
 * Counter Clear select This field defines the source of the signals that clears the counter.
 *
 * Values:
 * - 000 - Counter is disabled
 * - 001 - The counter is triggered by the same trigger that triggers the displays clock.
 * - 010 - Reserved
 * - 011 - Reserved
 * - 100 - Reserved
 * - 101 - CSI VSYNC. The VSYNC is a trigger coming from one of the CSI's according to the CSI_VSYNC_DEST bit.
 * - 110 - External VSYNC
 * - 111 - Counter is always on.
 */
//@{
#define BP_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0      (12)      //!< Bit position for IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0.
#define BM_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0      (0x00007000)  //!< Bit mask for IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0.

//! @brief Get value of IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0 from a register value.
#define BG_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0) >> BP_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0.
#define BF_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0) & BM_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNT_CLR_SEL_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0(x, v)   (HW_IPU_DISP_ALT1_WR(x, (HW_IPU_DISP_ALT1_RD(x) & ~BM_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0) | BF_IPU_DISP_ALT1_CNT_CLR_SEL_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT1, field CNT_AUTO_RELOAD_ALT_0[15] (RW)
 *
 * Counter auto reload mode
 *
 * Values:
 * - 0 - The counter will not be automatically reloaded, It will be reloaded for the amount of repeat times
 *     defined on the step_repeat_alt_0 field
 * - 1 - The counter will automatically be reloaded forever, ignoring the value of the step_repeat_alt_0
 *     field
 */
//@{
#define BP_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0      (15)      //!< Bit position for IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0.
#define BM_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0      (0x00008000)  //!< Bit mask for IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0.

//! @brief Get value of IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0 from a register value.
#define BG_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0) >> BP_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0.
#define BF_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0) & BM_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNT_AUTO_RELOAD_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0(x, v)   (HW_IPU_DISP_ALT1_WR(x, (HW_IPU_DISP_ALT1_RD(x) & ~BM_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0) | BF_IPU_DISP_ALT1_CNT_AUTO_RELOAD_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT1, field STEP_REPEAT_ALT_0[27:16] (RW)
 *
 * This fields defines the amount of repetitions that will be performed by the counter
 */
//@{
#define BP_IPU_DISP_ALT1_STEP_REPEAT_ALT_0      (16)      //!< Bit position for IPU_DISP_ALT1_STEP_REPEAT_ALT_0.
#define BM_IPU_DISP_ALT1_STEP_REPEAT_ALT_0      (0x0fff0000)  //!< Bit mask for IPU_DISP_ALT1_STEP_REPEAT_ALT_0.

//! @brief Get value of IPU_DISP_ALT1_STEP_REPEAT_ALT_0 from a register value.
#define BG_IPU_DISP_ALT1_STEP_REPEAT_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT1_STEP_REPEAT_ALT_0) >> BP_IPU_DISP_ALT1_STEP_REPEAT_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT1_STEP_REPEAT_ALT_0.
#define BF_IPU_DISP_ALT1_STEP_REPEAT_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT1_STEP_REPEAT_ALT_0) & BM_IPU_DISP_ALT1_STEP_REPEAT_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STEP_REPEAT_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT1_STEP_REPEAT_ALT_0(x, v)   (HW_IPU_DISP_ALT1_WR(x, (HW_IPU_DISP_ALT1_RD(x) & ~BM_IPU_DISP_ALT1_STEP_REPEAT_ALT_0) | BF_IPU_DISP_ALT1_STEP_REPEAT_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT1, field SEL_ALT_0[31:28] (RW)
 *
 * Select alternative parameters instead of DI Sync Wave Gen counter#. The DI is selected according
 * to DP's synchronous channel destination 0000-disable
 *
 * Values:
 * - 0001 - instead of counter 1
 * - 0010 - instead of counter 2
 * - 1000 - instead of counter 8
 */
//@{
#define BP_IPU_DISP_ALT1_SEL_ALT_0      (28)      //!< Bit position for IPU_DISP_ALT1_SEL_ALT_0.
#define BM_IPU_DISP_ALT1_SEL_ALT_0      (0xf0000000)  //!< Bit mask for IPU_DISP_ALT1_SEL_ALT_0.

//! @brief Get value of IPU_DISP_ALT1_SEL_ALT_0 from a register value.
#define BG_IPU_DISP_ALT1_SEL_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT1_SEL_ALT_0) >> BP_IPU_DISP_ALT1_SEL_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT1_SEL_ALT_0.
#define BF_IPU_DISP_ALT1_SEL_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT1_SEL_ALT_0) & BM_IPU_DISP_ALT1_SEL_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEL_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT1_SEL_ALT_0(x, v)   (HW_IPU_DISP_ALT1_WR(x, (HW_IPU_DISP_ALT1_RD(x) & ~BM_IPU_DISP_ALT1_SEL_ALT_0) | BF_IPU_DISP_ALT1_SEL_ALT_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_ALT2 - Display Alternate Flow Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_ALT2 - Display Alternate Flow Control Register 2 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register controls various aspects of the display port.
 */
typedef union _hw_ipu_disp_alt2
{
    reg32_t U;
    struct _hw_ipu_disp_alt2_bitfields
    {
        unsigned OFFSET_VALUE_ALT_0 : 12; //!< [11:0] Counter offset value
        unsigned OFFSET_RESOLUTION_ALT_0 : 3; //!< [14:12] Counter offset Resolution
        unsigned RESERVED0 : 1; //!< [15] Reserved
        unsigned RUN_RESOLUTION_ALT_0 : 3; //!< [18:16] Counter Run Resolution
        unsigned RESERVED1 : 13; //!< [31:19] Reserved
    } B;
} hw_ipu_disp_alt2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_ALT2 register
 */
//@{
#define HW_IPU_DISP_ALT2_ADDR(x)      (REGS_IPU_BASE(x) + 0xcc)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_ALT2(x)           (*(volatile hw_ipu_disp_alt2_t *) HW_IPU_DISP_ALT2_ADDR(x))
#define HW_IPU_DISP_ALT2_RD(x)        (HW_IPU_DISP_ALT2(x).U)
#define HW_IPU_DISP_ALT2_WR(x, v)     (HW_IPU_DISP_ALT2(x).U = (v))
#define HW_IPU_DISP_ALT2_SET(x, v)    (HW_IPU_DISP_ALT2_WR(x, HW_IPU_DISP_ALT2_RD(x) |  (v)))
#define HW_IPU_DISP_ALT2_CLR(x, v)    (HW_IPU_DISP_ALT2_WR(x, HW_IPU_DISP_ALT2_RD(x) & ~(v)))
#define HW_IPU_DISP_ALT2_TOG(x, v)    (HW_IPU_DISP_ALT2_WR(x, HW_IPU_DISP_ALT2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_ALT2 bitfields
 */

/*! @name Register IPU_DISP_ALT2, field OFFSET_VALUE_ALT_0[11:0] (RW)
 *
 * Counter offset value The counter can start counting after a pre defined delay This field defines
 * the amount of cycles that the counter will be delayed by
 */
//@{
#define BP_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0      (0)      //!< Bit position for IPU_DISP_ALT2_OFFSET_VALUE_ALT_0.
#define BM_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0      (0x00000fff)  //!< Bit mask for IPU_DISP_ALT2_OFFSET_VALUE_ALT_0.

//! @brief Get value of IPU_DISP_ALT2_OFFSET_VALUE_ALT_0 from a register value.
#define BG_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0) >> BP_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT2_OFFSET_VALUE_ALT_0.
#define BF_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0) & BM_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFSET_VALUE_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0(x, v)   (HW_IPU_DISP_ALT2_WR(x, (HW_IPU_DISP_ALT2_RD(x) & ~BM_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0) | BF_IPU_DISP_ALT2_OFFSET_VALUE_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT2, field OFFSET_RESOLUTION_ALT_0[14:12] (RW)
 *
 * Counter offset Resolution This field defines the trigger causing the offset counter to increment
 * The counter offset resolution should be defined in the same way as in original DI's counter#
 */
//@{
#define BP_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0      (12)      //!< Bit position for IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0.
#define BM_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0      (0x00007000)  //!< Bit mask for IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0.

//! @brief Get value of IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0 from a register value.
#define BG_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0) >> BP_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0.
#define BF_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0) & BM_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFSET_RESOLUTION_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0(x, v)   (HW_IPU_DISP_ALT2_WR(x, (HW_IPU_DISP_ALT2_RD(x) & ~BM_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0) | BF_IPU_DISP_ALT2_OFFSET_RESOLUTION_ALT_0(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT2, field RUN_RESOLUTION_ALT_0[18:16] (RW)
 *
 * Counter Run Resolution This field defines the trigger causing the counter to increment. The
 * counter run resolution should be defined in the same way as in original DI's counter#
 */
//@{
#define BP_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0      (16)      //!< Bit position for IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0.
#define BM_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0      (0x00070000)  //!< Bit mask for IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0.

//! @brief Get value of IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0 from a register value.
#define BG_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0) >> BP_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0)

//! @brief Format value for bitfield IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0.
#define BF_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0) & BM_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RUN_RESOLUTION_ALT_0 field to a new value.
#define BW_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0(x, v)   (HW_IPU_DISP_ALT2_WR(x, (HW_IPU_DISP_ALT2_RD(x) & ~BM_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0) | BF_IPU_DISP_ALT2_RUN_RESOLUTION_ALT_0(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_ALT3 - Display Alternate Flow Control Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_ALT3 - Display Alternate Flow Control Register 3 (RW)
 *
 * Reset value: 0x00400000
 *
 * This register controls various aspects of the display port.
 */
typedef union _hw_ipu_disp_alt3
{
    reg32_t U;
    struct _hw_ipu_disp_alt3_bitfields
    {
        unsigned RUN_VALUE_M1_ALT_1 : 12; //!< [11:0] Counter pre defined value
        unsigned CNT_CLR_SEL_ALT_1 : 3; //!< [14:12] Counter Clear select
        unsigned CNT_AUTO_RELOAD_ALT_1 : 1; //!< [15] Counter auto reload mode
        unsigned STEP_REPEAT_ALT_1 : 12; //!< [27:16] This fields defines the amount of repetitions that will be performed by the counter
        unsigned SEL_ALT_1 : 4; //!< [31:28] Select alternative parameters instead of DI Sync Wave Gen counter#.
    } B;
} hw_ipu_disp_alt3_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_ALT3 register
 */
//@{
#define HW_IPU_DISP_ALT3_ADDR(x)      (REGS_IPU_BASE(x) + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_ALT3(x)           (*(volatile hw_ipu_disp_alt3_t *) HW_IPU_DISP_ALT3_ADDR(x))
#define HW_IPU_DISP_ALT3_RD(x)        (HW_IPU_DISP_ALT3(x).U)
#define HW_IPU_DISP_ALT3_WR(x, v)     (HW_IPU_DISP_ALT3(x).U = (v))
#define HW_IPU_DISP_ALT3_SET(x, v)    (HW_IPU_DISP_ALT3_WR(x, HW_IPU_DISP_ALT3_RD(x) |  (v)))
#define HW_IPU_DISP_ALT3_CLR(x, v)    (HW_IPU_DISP_ALT3_WR(x, HW_IPU_DISP_ALT3_RD(x) & ~(v)))
#define HW_IPU_DISP_ALT3_TOG(x, v)    (HW_IPU_DISP_ALT3_WR(x, HW_IPU_DISP_ALT3_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_ALT3 bitfields
 */

/*! @name Register IPU_DISP_ALT3, field RUN_VALUE_M1_ALT_1[11:0] (RW)
 *
 * Counter pre defined value This fields defines the counter pre defines value. real value- 1
 */
//@{
#define BP_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1      (0)      //!< Bit position for IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1.
#define BM_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1      (0x00000fff)  //!< Bit mask for IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1.

//! @brief Get value of IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1 from a register value.
#define BG_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1) >> BP_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1.
#define BF_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1) & BM_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RUN_VALUE_M1_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1(x, v)   (HW_IPU_DISP_ALT3_WR(x, (HW_IPU_DISP_ALT3_RD(x) & ~BM_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1) | BF_IPU_DISP_ALT3_RUN_VALUE_M1_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT3, field CNT_CLR_SEL_ALT_1[14:12] (RW)
 *
 * Counter Clear select This field defines the source of the signals that clears the counter.
 *
 * Values:
 * - 000 - Counter is disabled
 * - 001 - The counter is triggered by the same trigger that triggers the displays clock.
 * - 010 - Reserved
 * - 011 - Reserved
 * - 100 - Reserved
 * - 101 - CSI VSYNC. The VSYNC is a trigger coming from one of the CSI's according to the CSI_VSYNC_DEST bit.
 * - 110 - External VSYNC
 * - 111 - Counter is always on.
 */
//@{
#define BP_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1      (12)      //!< Bit position for IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1.
#define BM_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1      (0x00007000)  //!< Bit mask for IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1.

//! @brief Get value of IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1 from a register value.
#define BG_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1) >> BP_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1.
#define BF_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1) & BM_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNT_CLR_SEL_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1(x, v)   (HW_IPU_DISP_ALT3_WR(x, (HW_IPU_DISP_ALT3_RD(x) & ~BM_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1) | BF_IPU_DISP_ALT3_CNT_CLR_SEL_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT3, field CNT_AUTO_RELOAD_ALT_1[15] (RW)
 *
 * Counter auto reload mode
 *
 * Values:
 * - 0 - The counter will not be automatically reloaded, It will be reloaded for the amount of repeat times
 *     defined on the step_repeat_alt_0 field
 * - 1 - The counter will automatically be reloaded forever, ignoring the value of the step_repeat_alt_0
 *     field
 */
//@{
#define BP_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1      (15)      //!< Bit position for IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1.
#define BM_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1      (0x00008000)  //!< Bit mask for IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1.

//! @brief Get value of IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1 from a register value.
#define BG_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1) >> BP_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1.
#define BF_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1) & BM_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNT_AUTO_RELOAD_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1(x, v)   (HW_IPU_DISP_ALT3_WR(x, (HW_IPU_DISP_ALT3_RD(x) & ~BM_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1) | BF_IPU_DISP_ALT3_CNT_AUTO_RELOAD_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT3, field STEP_REPEAT_ALT_1[27:16] (RW)
 *
 * This fields defines the amount of repetitions that will be performed by the counter
 */
//@{
#define BP_IPU_DISP_ALT3_STEP_REPEAT_ALT_1      (16)      //!< Bit position for IPU_DISP_ALT3_STEP_REPEAT_ALT_1.
#define BM_IPU_DISP_ALT3_STEP_REPEAT_ALT_1      (0x0fff0000)  //!< Bit mask for IPU_DISP_ALT3_STEP_REPEAT_ALT_1.

//! @brief Get value of IPU_DISP_ALT3_STEP_REPEAT_ALT_1 from a register value.
#define BG_IPU_DISP_ALT3_STEP_REPEAT_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT3_STEP_REPEAT_ALT_1) >> BP_IPU_DISP_ALT3_STEP_REPEAT_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT3_STEP_REPEAT_ALT_1.
#define BF_IPU_DISP_ALT3_STEP_REPEAT_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT3_STEP_REPEAT_ALT_1) & BM_IPU_DISP_ALT3_STEP_REPEAT_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STEP_REPEAT_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT3_STEP_REPEAT_ALT_1(x, v)   (HW_IPU_DISP_ALT3_WR(x, (HW_IPU_DISP_ALT3_RD(x) & ~BM_IPU_DISP_ALT3_STEP_REPEAT_ALT_1) | BF_IPU_DISP_ALT3_STEP_REPEAT_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT3, field SEL_ALT_1[31:28] (RW)
 *
 * Select alternative parameters instead of DI Sync Wave Gen counter#. The DI is selected according
 * to DP's synchronous channel destination
 *
 * Values:
 * - 0000 - disable
 * - 0001 - instead of counter 1
 * - 0010 - instead of counter 2
 * - 1000 - instead of counter 8
 */
//@{
#define BP_IPU_DISP_ALT3_SEL_ALT_1      (28)      //!< Bit position for IPU_DISP_ALT3_SEL_ALT_1.
#define BM_IPU_DISP_ALT3_SEL_ALT_1      (0xf0000000)  //!< Bit mask for IPU_DISP_ALT3_SEL_ALT_1.

//! @brief Get value of IPU_DISP_ALT3_SEL_ALT_1 from a register value.
#define BG_IPU_DISP_ALT3_SEL_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT3_SEL_ALT_1) >> BP_IPU_DISP_ALT3_SEL_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT3_SEL_ALT_1.
#define BF_IPU_DISP_ALT3_SEL_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT3_SEL_ALT_1) & BM_IPU_DISP_ALT3_SEL_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEL_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT3_SEL_ALT_1(x, v)   (HW_IPU_DISP_ALT3_WR(x, (HW_IPU_DISP_ALT3_RD(x) & ~BM_IPU_DISP_ALT3_SEL_ALT_1) | BF_IPU_DISP_ALT3_SEL_ALT_1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_DISP_ALT4 - Display Alternate Flow Control Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_DISP_ALT4 - Display Alternate Flow Control Register 4 (RW)
 *
 * Reset value: 0x00000000
 *
 * This register controls various aspects of the display port.
 */
typedef union _hw_ipu_disp_alt4
{
    reg32_t U;
    struct _hw_ipu_disp_alt4_bitfields
    {
        unsigned OFFSET_VALUE_ALT_1 : 12; //!< [11:0] Counter offset value
        unsigned OFFSET_RESOLUTION_ALT_1 : 3; //!< [14:12] Counter offset Resolution
        unsigned RESERVED0 : 1; //!< [15] Reserved
        unsigned RUN_RESOLUTION_ALT_1 : 3; //!< [18:16] Counter Run Resolution
        unsigned RESERVED1 : 13; //!< [31:19] Reserved
    } B;
} hw_ipu_disp_alt4_t;
#endif

/*!
 * @name Constants and macros for entire IPU_DISP_ALT4 register
 */
//@{
#define HW_IPU_DISP_ALT4_ADDR(x)      (REGS_IPU_BASE(x) + 0xd4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_DISP_ALT4(x)           (*(volatile hw_ipu_disp_alt4_t *) HW_IPU_DISP_ALT4_ADDR(x))
#define HW_IPU_DISP_ALT4_RD(x)        (HW_IPU_DISP_ALT4(x).U)
#define HW_IPU_DISP_ALT4_WR(x, v)     (HW_IPU_DISP_ALT4(x).U = (v))
#define HW_IPU_DISP_ALT4_SET(x, v)    (HW_IPU_DISP_ALT4_WR(x, HW_IPU_DISP_ALT4_RD(x) |  (v)))
#define HW_IPU_DISP_ALT4_CLR(x, v)    (HW_IPU_DISP_ALT4_WR(x, HW_IPU_DISP_ALT4_RD(x) & ~(v)))
#define HW_IPU_DISP_ALT4_TOG(x, v)    (HW_IPU_DISP_ALT4_WR(x, HW_IPU_DISP_ALT4_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_DISP_ALT4 bitfields
 */

/*! @name Register IPU_DISP_ALT4, field OFFSET_VALUE_ALT_1[11:0] (RW)
 *
 * Counter offset value The counter can start counting after a pre defined delay This field defines
 * the amount of cycles that the counter will be delayed by
 */
//@{
#define BP_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1      (0)      //!< Bit position for IPU_DISP_ALT4_OFFSET_VALUE_ALT_1.
#define BM_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1      (0x00000fff)  //!< Bit mask for IPU_DISP_ALT4_OFFSET_VALUE_ALT_1.

//! @brief Get value of IPU_DISP_ALT4_OFFSET_VALUE_ALT_1 from a register value.
#define BG_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1) >> BP_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT4_OFFSET_VALUE_ALT_1.
#define BF_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1) & BM_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFSET_VALUE_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1(x, v)   (HW_IPU_DISP_ALT4_WR(x, (HW_IPU_DISP_ALT4_RD(x) & ~BM_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1) | BF_IPU_DISP_ALT4_OFFSET_VALUE_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT4, field OFFSET_RESOLUTION_ALT_1[14:12] (RW)
 *
 * Counter offset Resolution This field defines the trigger causing the offset counter to increment
 * The counter offset resolution should be defined in the same way as in original DI's counter#
 */
//@{
#define BP_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1      (12)      //!< Bit position for IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1.
#define BM_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1      (0x00007000)  //!< Bit mask for IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1.

//! @brief Get value of IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1 from a register value.
#define BG_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1) >> BP_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1.
#define BF_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1) & BM_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFSET_RESOLUTION_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1(x, v)   (HW_IPU_DISP_ALT4_WR(x, (HW_IPU_DISP_ALT4_RD(x) & ~BM_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1) | BF_IPU_DISP_ALT4_OFFSET_RESOLUTION_ALT_1(v)))
#endif
//@}

/*! @name Register IPU_DISP_ALT4, field RUN_RESOLUTION_ALT_1[18:16] (RW)
 *
 * Counter Run Resolution This field defines the trigger causing the counter to increment. The
 * counter run resolution should be defined in the same way as in original DI's counter#
 */
//@{
#define BP_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1      (16)      //!< Bit position for IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1.
#define BM_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1      (0x00070000)  //!< Bit mask for IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1.

//! @brief Get value of IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1 from a register value.
#define BG_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1) >> BP_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1)

//! @brief Format value for bitfield IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1.
#define BF_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1) & BM_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RUN_RESOLUTION_ALT_1 field to a new value.
#define BW_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1(x, v)   (HW_IPU_DISP_ALT4_WR(x, (HW_IPU_DISP_ALT4_RD(x) & ~BM_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1) | BF_IPU_DISP_ALT4_RUN_RESOLUTION_ALT_1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_MEM_RST - Memory Reset Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_MEM_RST - Memory Reset Control Register (RW)
 *
 * Reset value: 0x00000000
 *
 * This register controls the memory reset mechanism. IPU has a hardware mechanism for clearing the
 * content of the internal memories. This allows the user to clear the content of or more of the
 * internal memories without the need to perform write accesses to the memories.
 */
typedef union _hw_ipu_mem_rst
{
    reg32_t U;
    struct _hw_ipu_mem_rst_bitfields
    {
        unsigned RST_MEM_EN : 23; //!< [22:0] Reset Memory Enable
        unsigned RESERVED0 : 8; //!< [30:23] Reserved
        unsigned RST_MEM_START : 1; //!< [31] Memory Reset Start
    } B;
} hw_ipu_mem_rst_t;
#endif

/*!
 * @name Constants and macros for entire IPU_MEM_RST register
 */
//@{
#define HW_IPU_MEM_RST_ADDR(x)      (REGS_IPU_BASE(x) + 0xdc)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_MEM_RST(x)           (*(volatile hw_ipu_mem_rst_t *) HW_IPU_MEM_RST_ADDR(x))
#define HW_IPU_MEM_RST_RD(x)        (HW_IPU_MEM_RST(x).U)
#define HW_IPU_MEM_RST_WR(x, v)     (HW_IPU_MEM_RST(x).U = (v))
#define HW_IPU_MEM_RST_SET(x, v)    (HW_IPU_MEM_RST_WR(x, HW_IPU_MEM_RST_RD(x) |  (v)))
#define HW_IPU_MEM_RST_CLR(x, v)    (HW_IPU_MEM_RST_WR(x, HW_IPU_MEM_RST_RD(x) & ~(v)))
#define HW_IPU_MEM_RST_TOG(x, v)    (HW_IPU_MEM_RST_WR(x, HW_IPU_MEM_RST_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_MEM_RST bitfields
 */

/*! @name Register IPU_MEM_RST, field RST_MEM_EN[22:0] (RW)
 *
 * Reset Memory Enable Each bit on this field enables the memory reset mechanism for a specific
 * memory. The user should set the relevant bits for the memories that need to be cleared. Below is
 * the list of memories and their corresponding bit. srm = rst_mem_en[0] alpha = rst_mem_en[1] cpmem
 * = rst_mem_en[2] tpm = rst_mem_en[3] mpm = rst_mem_en[4] bm = rst_mem_en[5] rm = rst_mem_en[6]
 * dstm = rst_mem_en[7] dsom = rst_mem_en[8] lut0 = rst_mem_en[9] lut1 = rst_mem_en[10] ram_smfc =
 * rst_mem_en[11] vdi_fifo2 = rst_mem_en[12] vdi_fifo3 = rst_mem_en[13] icb = rst_mem_en[14]
 * vdi_fifo1 = rst_mem_en[15] dc_template = rst_mem_en[20] dmfc_rd = rst_mem_en[21] dmfc_wr =
 * rst_mem_en[22]
 */
//@{
#define BP_IPU_MEM_RST_RST_MEM_EN      (0)      //!< Bit position for IPU_MEM_RST_RST_MEM_EN.
#define BM_IPU_MEM_RST_RST_MEM_EN      (0x007fffff)  //!< Bit mask for IPU_MEM_RST_RST_MEM_EN.

//! @brief Get value of IPU_MEM_RST_RST_MEM_EN from a register value.
#define BG_IPU_MEM_RST_RST_MEM_EN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_MEM_RST_RST_MEM_EN) >> BP_IPU_MEM_RST_RST_MEM_EN)

//! @brief Format value for bitfield IPU_MEM_RST_RST_MEM_EN.
#define BF_IPU_MEM_RST_RST_MEM_EN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_MEM_RST_RST_MEM_EN) & BM_IPU_MEM_RST_RST_MEM_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RST_MEM_EN field to a new value.
#define BW_IPU_MEM_RST_RST_MEM_EN(x, v)   (HW_IPU_MEM_RST_WR(x, (HW_IPU_MEM_RST_RD(x) & ~BM_IPU_MEM_RST_RST_MEM_EN) | BF_IPU_MEM_RST_RST_MEM_EN(v)))
#endif
//@}

/*! @name Register IPU_MEM_RST, field RST_MEM_START[31] (RW)
 *
 * Memory Reset Start Writing one to this bit activate the memory reset mechanism. The memories that
 * their corresponding RST_MEM_EN bit is set will be cleared. When the memory reset mechanism
 * completes the memory clearing procedure this bit will be automatically cleared.
 *
 * Values:
 * - 0 - Idle, the memory reset mechanism is not working.
 * - 1 - The memory reset mechanism is activated and busy
 */
//@{
#define BP_IPU_MEM_RST_RST_MEM_START      (31)      //!< Bit position for IPU_MEM_RST_RST_MEM_START.
#define BM_IPU_MEM_RST_RST_MEM_START      (0x80000000)  //!< Bit mask for IPU_MEM_RST_RST_MEM_START.

//! @brief Get value of IPU_MEM_RST_RST_MEM_START from a register value.
#define BG_IPU_MEM_RST_RST_MEM_START(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_MEM_RST_RST_MEM_START) >> BP_IPU_MEM_RST_RST_MEM_START)

//! @brief Format value for bitfield IPU_MEM_RST_RST_MEM_START.
#define BF_IPU_MEM_RST_RST_MEM_START(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_MEM_RST_RST_MEM_START) & BM_IPU_MEM_RST_RST_MEM_START)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RST_MEM_START field to a new value.
#define BW_IPU_MEM_RST_RST_MEM_START(x, v)   (HW_IPU_MEM_RST_WR(x, (HW_IPU_MEM_RST_RD(x) & ~BM_IPU_MEM_RST_RST_MEM_START) | BF_IPU_MEM_RST_RST_MEM_START(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_PM - Power Modes Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_PM - Power Modes Control Register (RW)
 *
 * Reset value: 0x08100810
 *
 * This register controls the automatic transitions of the IPU between different power modes of the
 * SoC and handles the clock change modes.
 */
typedef union _hw_ipu_pm
{
    reg32_t U;
    struct _hw_ipu_pm_bitfields
    {
        unsigned DI0_CLK_PERIOD_0 : 7; //!< [6:0] DI0_CLK period option 0.
        unsigned DI0_CLK_PERIOD_1 : 7; //!< [13:7] DI0_CLK period option 1.
        unsigned DI0_SRM_CLOCK_CHANGE_MODE : 1; //!< [14] SRM clock change mode
        unsigned CLCOK_MODE_STAT : 1; //!< [15] Clock mode status
        unsigned DI1_CLK_PERIOD_0 : 7; //!< [22:16] DI1_CLK period option 0.
        unsigned DI1_CLK_PERIOD_1 : 7; //!< [29:23] DI1_CLK period option 1.
        unsigned DI1_SRM_CLOCK_CHANGE_MODE : 1; //!< [30] SRM clock change mode
        unsigned LPSR_MODE : 1; //!< [31] LPSR Mode
    } B;
} hw_ipu_pm_t;
#endif

/*!
 * @name Constants and macros for entire IPU_PM register
 */
//@{
#define HW_IPU_PM_ADDR(x)      (REGS_IPU_BASE(x) + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_PM(x)           (*(volatile hw_ipu_pm_t *) HW_IPU_PM_ADDR(x))
#define HW_IPU_PM_RD(x)        (HW_IPU_PM(x).U)
#define HW_IPU_PM_WR(x, v)     (HW_IPU_PM(x).U = (v))
#define HW_IPU_PM_SET(x, v)    (HW_IPU_PM_WR(x, HW_IPU_PM_RD(x) |  (v)))
#define HW_IPU_PM_CLR(x, v)    (HW_IPU_PM_WR(x, HW_IPU_PM_RD(x) & ~(v)))
#define HW_IPU_PM_TOG(x, v)    (HW_IPU_PM_WR(x, HW_IPU_PM_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_PM bitfields
 */

/*! @name Register IPU_PM, field DI0_CLK_PERIOD_0[6:0] (RW)
 *
 * DI0_CLK period option 0. This parameter defines the period of the clock that the DI0 works with.
 * This parameter contains integer part (bits [6:4]) and fractional part (bits [3:0]). Setting this
 * value to 1.0 (default) means that the DI0 works on the fastest possible clock. Setting a value
 * smaller than 1.0 is not allowed. The value to be programmed to the DI0_CLK_PERIOD_1 field is
 * equal to: Fast_freq/Target_freq Where: Target_freq = The frequency that the DI clock works with
 * Fast_freq = fastest possible clock that the DI can work with
 */
//@{
#define BP_IPU_PM_DI0_CLK_PERIOD_0      (0)      //!< Bit position for IPU_PM_DI0_CLK_PERIOD_0.
#define BM_IPU_PM_DI0_CLK_PERIOD_0      (0x0000007f)  //!< Bit mask for IPU_PM_DI0_CLK_PERIOD_0.

//! @brief Get value of IPU_PM_DI0_CLK_PERIOD_0 from a register value.
#define BG_IPU_PM_DI0_CLK_PERIOD_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI0_CLK_PERIOD_0) >> BP_IPU_PM_DI0_CLK_PERIOD_0)

//! @brief Format value for bitfield IPU_PM_DI0_CLK_PERIOD_0.
#define BF_IPU_PM_DI0_CLK_PERIOD_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI0_CLK_PERIOD_0) & BM_IPU_PM_DI0_CLK_PERIOD_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CLK_PERIOD_0 field to a new value.
#define BW_IPU_PM_DI0_CLK_PERIOD_0(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI0_CLK_PERIOD_0) | BF_IPU_PM_DI0_CLK_PERIOD_0(v)))
#endif
//@}

/*! @name Register IPU_PM, field DI0_CLK_PERIOD_1[13:7] (RW)
 *
 * DI0_CLK period option 1. This parameter defines the period of the clock that the DI0 works with.
 * This parameter contains integer part (bits [6:4]) and fractional part (bits [3:0]). Setting this
 * value to 1.0 (default) means that the DI0 works on the fastest possible clock. Setting a value
 * smaller than 1.0 is not allowed. The value to be programmed to the DI0_CLK_PERIOD_1 field is
 * equal to: Fast_freq/Target_freq Where: Target_freq = The frequency that the DI clock works with
 * Fast_freq = fastest possible clock that the DI can work with
 */
//@{
#define BP_IPU_PM_DI0_CLK_PERIOD_1      (7)      //!< Bit position for IPU_PM_DI0_CLK_PERIOD_1.
#define BM_IPU_PM_DI0_CLK_PERIOD_1      (0x00003f80)  //!< Bit mask for IPU_PM_DI0_CLK_PERIOD_1.

//! @brief Get value of IPU_PM_DI0_CLK_PERIOD_1 from a register value.
#define BG_IPU_PM_DI0_CLK_PERIOD_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI0_CLK_PERIOD_1) >> BP_IPU_PM_DI0_CLK_PERIOD_1)

//! @brief Format value for bitfield IPU_PM_DI0_CLK_PERIOD_1.
#define BF_IPU_PM_DI0_CLK_PERIOD_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI0_CLK_PERIOD_1) & BM_IPU_PM_DI0_CLK_PERIOD_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_CLK_PERIOD_1 field to a new value.
#define BW_IPU_PM_DI0_CLK_PERIOD_1(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI0_CLK_PERIOD_1) | BF_IPU_PM_DI0_CLK_PERIOD_1(v)))
#endif
//@}

/*! @name Register IPU_PM, field DI0_SRM_CLOCK_CHANGE_MODE[14] (RW)
 *
 * SRM clock change mode When the clock is going to be changed to any new ratio other then 1:1, 1:2.
 * 1:4. The user needs to prepare an alternate set of DI setting in the SRM. This bit enable this
 * mode. This bit is self cleared.
 *
 * Values:
 * - 0 - SRM clock change mode is disabled.
 * - 1 - SRM clock change mode is enabled; the next clock change will be done by updating the DI settings
 *     from the SRM
 */
//@{
#define BP_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE      (14)      //!< Bit position for IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE.
#define BM_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE      (0x00004000)  //!< Bit mask for IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE.

//! @brief Get value of IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE from a register value.
#define BG_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE) >> BP_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE)

//! @brief Format value for bitfield IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE.
#define BF_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE) & BM_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI0_SRM_CLOCK_CHANGE_MODE field to a new value.
#define BW_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE) | BF_IPU_PM_DI0_SRM_CLOCK_CHANGE_MODE(v)))
#endif
//@}

/*! @name Register IPU_PM, field CLCOK_MODE_STAT[15] (RO)
 *
 * Clock mode status This is a read only bit indicating what is the current clock mode
 *
 * Values:
 * - 0 - current clock mode is 0
 * - 1 - current clock mode is 1
 */
//@{
#define BP_IPU_PM_CLCOK_MODE_STAT      (15)      //!< Bit position for IPU_PM_CLCOK_MODE_STAT.
#define BM_IPU_PM_CLCOK_MODE_STAT      (0x00008000)  //!< Bit mask for IPU_PM_CLCOK_MODE_STAT.

//! @brief Get value of IPU_PM_CLCOK_MODE_STAT from a register value.
#define BG_IPU_PM_CLCOK_MODE_STAT(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_CLCOK_MODE_STAT) >> BP_IPU_PM_CLCOK_MODE_STAT)
//@}

/*! @name Register IPU_PM, field DI1_CLK_PERIOD_0[22:16] (RW)
 *
 * DI1_CLK period option 0. This parameter defines the period of the clock that the DI1 works with.
 * This parameter contains integer part (bits [6:4]) and fractional part (bits [3:0]). Setting this
 * value to 1.0 (default) means that the DI1 works on the fastest possible clock. Setting a value
 * smaller than 1.0 is not allowed. The value to be programmed to the DI1_CLK_PERIOD_1 field is
 * equal to: Fast_freq/Target_freq Where: Target_freq = The frequency that the DI clock works with
 * Fast_freq = fastest possible clock that the DI can work with
 */
//@{
#define BP_IPU_PM_DI1_CLK_PERIOD_0      (16)      //!< Bit position for IPU_PM_DI1_CLK_PERIOD_0.
#define BM_IPU_PM_DI1_CLK_PERIOD_0      (0x007f0000)  //!< Bit mask for IPU_PM_DI1_CLK_PERIOD_0.

//! @brief Get value of IPU_PM_DI1_CLK_PERIOD_0 from a register value.
#define BG_IPU_PM_DI1_CLK_PERIOD_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI1_CLK_PERIOD_0) >> BP_IPU_PM_DI1_CLK_PERIOD_0)

//! @brief Format value for bitfield IPU_PM_DI1_CLK_PERIOD_0.
#define BF_IPU_PM_DI1_CLK_PERIOD_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI1_CLK_PERIOD_0) & BM_IPU_PM_DI1_CLK_PERIOD_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_CLK_PERIOD_0 field to a new value.
#define BW_IPU_PM_DI1_CLK_PERIOD_0(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI1_CLK_PERIOD_0) | BF_IPU_PM_DI1_CLK_PERIOD_0(v)))
#endif
//@}

/*! @name Register IPU_PM, field DI1_CLK_PERIOD_1[29:23] (RW)
 *
 * DI1_CLK period option 1. This parameter defines the period of the clock that the DI1 works with.
 * This parameter contains integer part (bits [6:4]) and fractional part (bits [3:0]). Setting this
 * value to 1.0 (default) means that the DI1 works on the fastest possible clock. Setting a value
 * smaller than 1.0 is not allowed. The value to be programmed to the DI1_CLK_PERIOD_1 field is
 * equal to: Fast_freq/Target_freq Where: Target_freq = The frequency that the DI clock works with
 * Fast_freq = fastest possible clock that the DI can work with
 */
//@{
#define BP_IPU_PM_DI1_CLK_PERIOD_1      (23)      //!< Bit position for IPU_PM_DI1_CLK_PERIOD_1.
#define BM_IPU_PM_DI1_CLK_PERIOD_1      (0x3f800000)  //!< Bit mask for IPU_PM_DI1_CLK_PERIOD_1.

//! @brief Get value of IPU_PM_DI1_CLK_PERIOD_1 from a register value.
#define BG_IPU_PM_DI1_CLK_PERIOD_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI1_CLK_PERIOD_1) >> BP_IPU_PM_DI1_CLK_PERIOD_1)

//! @brief Format value for bitfield IPU_PM_DI1_CLK_PERIOD_1.
#define BF_IPU_PM_DI1_CLK_PERIOD_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI1_CLK_PERIOD_1) & BM_IPU_PM_DI1_CLK_PERIOD_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_CLK_PERIOD_1 field to a new value.
#define BW_IPU_PM_DI1_CLK_PERIOD_1(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI1_CLK_PERIOD_1) | BF_IPU_PM_DI1_CLK_PERIOD_1(v)))
#endif
//@}

/*! @name Register IPU_PM, field DI1_SRM_CLOCK_CHANGE_MODE[30] (RW)
 *
 * SRM clock change mode When the clock is going to be changed to any new ratio other then 1:1, 1:2.
 * 1:4. The user needs to prepare an alternate set of DI setting in the SRM. This bit enable this
 * mode. This bit is self cleared.
 *
 * Values:
 * - 0 - SRM clock change mode is disabled.
 * - 1 - SRM clock change mode is enabled; the next clock change will be done by updating the DI settings
 *     from the SRM
 */
//@{
#define BP_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE      (30)      //!< Bit position for IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE.
#define BM_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE      (0x40000000)  //!< Bit mask for IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE.

//! @brief Get value of IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE from a register value.
#define BG_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE) >> BP_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE)

//! @brief Format value for bitfield IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE.
#define BF_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE) & BM_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DI1_SRM_CLOCK_CHANGE_MODE field to a new value.
#define BW_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE) | BF_IPU_PM_DI1_SRM_CLOCK_CHANGE_MODE(v)))
#endif
//@}

/*! @name Register IPU_PM, field LPSR_MODE[31] (RW)
 *
 * LPSR Mode This bit indicates that the next attempt for entering low power mode is an attempt to
 * move to LPST mode. Setting this bit by the user is essential in order to assure proper response
 * of the IPU to the assertion of the stop request from the CCM.
 *
 * Values:
 * - 0 - Next low power mode is not LPSR
 * - 1 - Next low power mode will be LPSR
 */
//@{
#define BP_IPU_PM_LPSR_MODE      (31)      //!< Bit position for IPU_PM_LPSR_MODE.
#define BM_IPU_PM_LPSR_MODE      (0x80000000)  //!< Bit mask for IPU_PM_LPSR_MODE.

//! @brief Get value of IPU_PM_LPSR_MODE from a register value.
#define BG_IPU_PM_LPSR_MODE(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_PM_LPSR_MODE) >> BP_IPU_PM_LPSR_MODE)

//! @brief Format value for bitfield IPU_PM_LPSR_MODE.
#define BF_IPU_PM_LPSR_MODE(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_PM_LPSR_MODE) & BM_IPU_PM_LPSR_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPSR_MODE field to a new value.
#define BW_IPU_PM_LPSR_MODE(x, v)   (HW_IPU_PM_WR(x, (HW_IPU_PM_RD(x) & ~BM_IPU_PM_LPSR_MODE) | BF_IPU_PM_LPSR_MODE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_GPR - General Purpose Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_GPR - General Purpose Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains general purpose bits.
 */
typedef union _hw_ipu_gpr
{
    reg32_t U;
    struct _hw_ipu_gpr_bitfields
    {
        unsigned IPU_GPN : 20; //!< [19:0] IPU General Purpose bit.
        unsigned IPU_CH_BUF2_RDY0_CLR : 1; //!< [20] This bit defines the IPU_CH_BUF2_RDY0 properties.
        unsigned IPU_CH_BUF2_RDY1_CLR : 1; //!< [21] This bit defines the IPU_CH_BUF2_RDY1 properties.
        unsigned IPU_DI0_CLK_CHANGE_ACK_DIS : 1; //!< [22] Disable DI0's clock change mechanism.
        unsigned IPU_DI1_CLK_CHANGE_ACK_DIS : 1; //!< [23] Disable DI1's clock change mechanism.
        unsigned IPU_ALT_CH_BUF0_RDY0_CLR : 1; //!< [24] This bit defines the IPU_ALT_CH_BUF0_RDY0 properties.
        unsigned IPU_ALT_CH_BUF0_RDY1_CLR : 1; //!< [25] This bit defines the IPU_ALT_CH_BUF0_RDY1 properties.
        unsigned IPU_ALT_CH_BUF1_RDY0_CLR : 1; //!< [26] This bit defines the IPU_ALT_CH_BUF1_RDY0 properties.
        unsigned IPU_ALT_CH_BUF1_RDY1_CLR : 1; //!< [27] This bit defines the IPU_ALT_CH_BUF1_RDY1 properties.
        unsigned IPU_CH_BUF0_RDY0_CLR : 1; //!< [28] This bit defines the IPU_CH_BUF0_RDY0 properties.
        unsigned IPU_CH_BUF0_RDY1_CLR : 1; //!< [29] This bit defines the IPU_CH_BUF0_RDY1 properties.
        unsigned IPU_CH_BUF1_RDY0_CLR : 1; //!< [30] This bit defines the IPU_CH_BUF1_RDY0 properties.
        unsigned IPU_CH_BUF1_RDY1_CLR : 1; //!< [31] This bit defines the IPU_CH_BUF1_RDY1 properties.
    } B;
} hw_ipu_gpr_t;
#endif

/*!
 * @name Constants and macros for entire IPU_GPR register
 */
//@{
#define HW_IPU_GPR_ADDR(x)      (REGS_IPU_BASE(x) + 0xe4)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_GPR(x)           (*(volatile hw_ipu_gpr_t *) HW_IPU_GPR_ADDR(x))
#define HW_IPU_GPR_RD(x)        (HW_IPU_GPR(x).U)
#define HW_IPU_GPR_WR(x, v)     (HW_IPU_GPR(x).U = (v))
#define HW_IPU_GPR_SET(x, v)    (HW_IPU_GPR_WR(x, HW_IPU_GPR_RD(x) |  (v)))
#define HW_IPU_GPR_CLR(x, v)    (HW_IPU_GPR_WR(x, HW_IPU_GPR_RD(x) & ~(v)))
#define HW_IPU_GPR_TOG(x, v)    (HW_IPU_GPR_WR(x, HW_IPU_GPR_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_GPR bitfields
 */

/*! @name Register IPU_GPR, field IPU_GPN[19:0] (RW)
 *
 * IPU General Purpose bit. n Indicates the corresponding DMA channel number. This bits are general
 * Read/Write bits, reserved for future use
 */
//@{
#define BP_IPU_GPR_IPU_GPN      (0)      //!< Bit position for IPU_GPR_IPU_GPN.
#define BM_IPU_GPR_IPU_GPN      (0x000fffff)  //!< Bit mask for IPU_GPR_IPU_GPN.

//! @brief Get value of IPU_GPR_IPU_GPN from a register value.
#define BG_IPU_GPR_IPU_GPN(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_GPN) >> BP_IPU_GPR_IPU_GPN)

//! @brief Format value for bitfield IPU_GPR_IPU_GPN.
#define BF_IPU_GPR_IPU_GPN(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_GPN) & BM_IPU_GPR_IPU_GPN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_GPN field to a new value.
#define BW_IPU_GPR_IPU_GPN(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_GPN) | BF_IPU_GPR_IPU_GPN(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF2_RDY0_CLR[20] (RW)
 *
 * This bit defines the IPU_CH_BUF2_RDY0 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF2_RDY0 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF2_RDY0 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF2_RDY0_CLR      (20)      //!< Bit position for IPU_GPR_IPU_CH_BUF2_RDY0_CLR.
#define BM_IPU_GPR_IPU_CH_BUF2_RDY0_CLR      (0x00100000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF2_RDY0_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF2_RDY0_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF2_RDY0_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF2_RDY0_CLR) >> BP_IPU_GPR_IPU_CH_BUF2_RDY0_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF2_RDY0_CLR.
#define BF_IPU_GPR_IPU_CH_BUF2_RDY0_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF2_RDY0_CLR) & BM_IPU_GPR_IPU_CH_BUF2_RDY0_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF2_RDY0_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF2_RDY0_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF2_RDY0_CLR) | BF_IPU_GPR_IPU_CH_BUF2_RDY0_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF2_RDY1_CLR[21] (RW)
 *
 * This bit defines the IPU_CH_BUF2_RDY1 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF2_RDY1 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF2_RDY1 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF2_RDY1_CLR      (21)      //!< Bit position for IPU_GPR_IPU_CH_BUF2_RDY1_CLR.
#define BM_IPU_GPR_IPU_CH_BUF2_RDY1_CLR      (0x00200000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF2_RDY1_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF2_RDY1_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF2_RDY1_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF2_RDY1_CLR) >> BP_IPU_GPR_IPU_CH_BUF2_RDY1_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF2_RDY1_CLR.
#define BF_IPU_GPR_IPU_CH_BUF2_RDY1_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF2_RDY1_CLR) & BM_IPU_GPR_IPU_CH_BUF2_RDY1_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF2_RDY1_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF2_RDY1_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF2_RDY1_CLR) | BF_IPU_GPR_IPU_CH_BUF2_RDY1_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_DI0_CLK_CHANGE_ACK_DIS[22] (RW)
 *
 * Disable DI0's clock change mechanism.
 *
 * Values:
 * - 0 - clock change mechanism is disabled. DI performs the clock change procedure
 * - 1 - clock change mechanism is disabled. DI automatically acknowledges a clock change request
 */
//@{
#define BP_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS      (22)      //!< Bit position for IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS.
#define BM_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS      (0x00400000)  //!< Bit mask for IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS.

//! @brief Get value of IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS from a register value.
#define BG_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS) >> BP_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS)

//! @brief Format value for bitfield IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS.
#define BF_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS) & BM_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_DI0_CLK_CHANGE_ACK_DIS field to a new value.
#define BW_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS) | BF_IPU_GPR_IPU_DI0_CLK_CHANGE_ACK_DIS(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_DI1_CLK_CHANGE_ACK_DIS[23] (RW)
 *
 * Disable DI1's clock change mechanism.
 *
 * Values:
 * - 0 - clock change mechanism is disabled. DI performs the clock change procedure
 * - 1 - clock change mechanism is disabled. DI automatically acknowledges a clock change request
 */
//@{
#define BP_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS      (23)      //!< Bit position for IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS.
#define BM_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS      (0x00800000)  //!< Bit mask for IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS.

//! @brief Get value of IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS from a register value.
#define BG_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS) >> BP_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS)

//! @brief Format value for bitfield IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS.
#define BF_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS) & BM_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_DI1_CLK_CHANGE_ACK_DIS field to a new value.
#define BW_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS) | BF_IPU_GPR_IPU_DI1_CLK_CHANGE_ACK_DIS(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_ALT_CH_BUF0_RDY0_CLR[24] (RW)
 *
 * This bit defines the IPU_ALT_CH_BUF0_RDY0 properties. This register can be a write one to clear
 * OR write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_ALT_CH_BUF0_RDY0 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_ALT_CH_BUF0_RDY0 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR      (24)      //!< Bit position for IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR.
#define BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR      (0x01000000)  //!< Bit mask for IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR.

//! @brief Get value of IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR from a register value.
#define BG_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR) >> BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR.
#define BF_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR) & BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_ALT_CH_BUF0_RDY0_CLR field to a new value.
#define BW_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR) | BF_IPU_GPR_IPU_ALT_CH_BUF0_RDY0_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_ALT_CH_BUF0_RDY1_CLR[25] (RW)
 *
 * This bit defines the IPU_ALT_CH_BUF0_RDY1 properties. This register can be a write one to clear
 * OR write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_ALT_CH_BUF0_RDY1 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_ALT_CH_BUF0_RDY1 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR      (25)      //!< Bit position for IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR.
#define BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR      (0x02000000)  //!< Bit mask for IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR.

//! @brief Get value of IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR from a register value.
#define BG_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR) >> BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR.
#define BF_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR) & BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_ALT_CH_BUF0_RDY1_CLR field to a new value.
#define BW_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR) | BF_IPU_GPR_IPU_ALT_CH_BUF0_RDY1_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_ALT_CH_BUF1_RDY0_CLR[26] (RW)
 *
 * This bit defines the IPU_ALT_CH_BUF1_RDY0 properties. This register can be a write one to clear
 * OR write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_ALT_CH_BUF1_RDY0 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_ALT_CH_BUF1_RDY0 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR      (26)      //!< Bit position for IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR.
#define BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR      (0x04000000)  //!< Bit mask for IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR.

//! @brief Get value of IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR from a register value.
#define BG_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR) >> BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR.
#define BF_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR) & BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_ALT_CH_BUF1_RDY0_CLR field to a new value.
#define BW_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR) | BF_IPU_GPR_IPU_ALT_CH_BUF1_RDY0_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_ALT_CH_BUF1_RDY1_CLR[27] (RW)
 *
 * This bit defines the IPU_ALT_CH_BUF1_RDY1 properties. This register can be a write one to clear
 * OR write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_ALT_CH_BUF1_RDY1 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_ALT_CH_BUF1_RDY1 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR      (27)      //!< Bit position for IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR.
#define BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR      (0x08000000)  //!< Bit mask for IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR.

//! @brief Get value of IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR from a register value.
#define BG_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR) >> BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR.
#define BF_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR) & BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_ALT_CH_BUF1_RDY1_CLR field to a new value.
#define BW_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR) | BF_IPU_GPR_IPU_ALT_CH_BUF1_RDY1_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF0_RDY0_CLR[28] (RW)
 *
 * This bit defines the IPU_CH_BUF0_RDY0 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF0_RDY0 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF0_RDY0 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF0_RDY0_CLR      (28)      //!< Bit position for IPU_GPR_IPU_CH_BUF0_RDY0_CLR.
#define BM_IPU_GPR_IPU_CH_BUF0_RDY0_CLR      (0x10000000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF0_RDY0_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF0_RDY0_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF0_RDY0_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF0_RDY0_CLR) >> BP_IPU_GPR_IPU_CH_BUF0_RDY0_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF0_RDY0_CLR.
#define BF_IPU_GPR_IPU_CH_BUF0_RDY0_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF0_RDY0_CLR) & BM_IPU_GPR_IPU_CH_BUF0_RDY0_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF0_RDY0_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF0_RDY0_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF0_RDY0_CLR) | BF_IPU_GPR_IPU_CH_BUF0_RDY0_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF0_RDY1_CLR[29] (RW)
 *
 * This bit defines the IPU_CH_BUF0_RDY1 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF0_RDY1 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF0_RDY1 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF0_RDY1_CLR      (29)      //!< Bit position for IPU_GPR_IPU_CH_BUF0_RDY1_CLR.
#define BM_IPU_GPR_IPU_CH_BUF0_RDY1_CLR      (0x20000000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF0_RDY1_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF0_RDY1_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF0_RDY1_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF0_RDY1_CLR) >> BP_IPU_GPR_IPU_CH_BUF0_RDY1_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF0_RDY1_CLR.
#define BF_IPU_GPR_IPU_CH_BUF0_RDY1_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF0_RDY1_CLR) & BM_IPU_GPR_IPU_CH_BUF0_RDY1_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF0_RDY1_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF0_RDY1_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF0_RDY1_CLR) | BF_IPU_GPR_IPU_CH_BUF0_RDY1_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF1_RDY0_CLR[30] (RW)
 *
 * This bit defines the IPU_CH_BUF1_RDY0 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF1_RDY0 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF1_RDY0 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF1_RDY0_CLR      (30)      //!< Bit position for IPU_GPR_IPU_CH_BUF1_RDY0_CLR.
#define BM_IPU_GPR_IPU_CH_BUF1_RDY0_CLR      (0x40000000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF1_RDY0_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF1_RDY0_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF1_RDY0_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF1_RDY0_CLR) >> BP_IPU_GPR_IPU_CH_BUF1_RDY0_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF1_RDY0_CLR.
#define BF_IPU_GPR_IPU_CH_BUF1_RDY0_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF1_RDY0_CLR) & BM_IPU_GPR_IPU_CH_BUF1_RDY0_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF1_RDY0_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF1_RDY0_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF1_RDY0_CLR) | BF_IPU_GPR_IPU_CH_BUF1_RDY0_CLR(v)))
#endif
//@}

/*! @name Register IPU_GPR, field IPU_CH_BUF1_RDY1_CLR[31] (RW)
 *
 * This bit defines the IPU_CH_BUF1_RDY1 properties. This register can be a write one to clear OR
 * write one to set.
 *
 * Values:
 * - 0 - writing one to a bit of this register sets this bit IPU_CH_BUF1_RDY1 is w1s register
 * - 1 - writing one to a bit of this register clears this bit; IPU_CH_BUF1_RDY1 is w1c register
 */
//@{
#define BP_IPU_GPR_IPU_CH_BUF1_RDY1_CLR      (31)      //!< Bit position for IPU_GPR_IPU_CH_BUF1_RDY1_CLR.
#define BM_IPU_GPR_IPU_CH_BUF1_RDY1_CLR      (0x80000000)  //!< Bit mask for IPU_GPR_IPU_CH_BUF1_RDY1_CLR.

//! @brief Get value of IPU_GPR_IPU_CH_BUF1_RDY1_CLR from a register value.
#define BG_IPU_GPR_IPU_CH_BUF1_RDY1_CLR(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_GPR_IPU_CH_BUF1_RDY1_CLR) >> BP_IPU_GPR_IPU_CH_BUF1_RDY1_CLR)

//! @brief Format value for bitfield IPU_GPR_IPU_CH_BUF1_RDY1_CLR.
#define BF_IPU_GPR_IPU_CH_BUF1_RDY1_CLR(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_GPR_IPU_CH_BUF1_RDY1_CLR) & BM_IPU_GPR_IPU_CH_BUF1_RDY1_CLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPU_CH_BUF1_RDY1_CLR field to a new value.
#define BW_IPU_GPR_IPU_CH_BUF1_RDY1_CLR(x, v)   (HW_IPU_GPR_WR(x, (HW_IPU_GPR_RD(x) & ~BM_IPU_GPR_IPU_CH_BUF1_RDY1_CLR) | BF_IPU_GPR_IPU_CH_BUF1_RDY1_CLR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_CH_DB_MODE_SEL1 - Channel Double Buffer Mode Select 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_CH_DB_MODE_SEL1 - Channel Double Buffer Mode Select 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains double buffer mode select control information for 32 IPU's DMA channels.
 */
typedef union _hw_ipu_ch_db_mode_sel1
{
    reg32_t U;
    struct _hw_ipu_ch_db_mode_sel1_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned DMA_CH_DB_MODE_SEL_33 : 1; //!< [1] Double Buffer Mode Select.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned DMA_CH_DB_MODE_SEL_40 : 1; //!< [8] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_41 : 1; //!< [9] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_42 : 1; //!< [10] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_43 : 1; //!< [11] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_44 : 1; //!< [12] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_45 : 1; //!< [13] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_46 : 1; //!< [14] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_47 : 1; //!< [15] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_48 : 1; //!< [16] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_49 : 1; //!< [17] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_50 : 1; //!< [18] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_51 : 1; //!< [19] Double Buffer Mode Select.
        unsigned DMA_CH_DB_MODE_SEL_52 : 1; //!< [20] Double Buffer Mode Select.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_ch_db_mode_sel1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_CH_DB_MODE_SEL1 register
 */
//@{
#define HW_IPU_CH_DB_MODE_SEL1_ADDR(x)      (REGS_IPU_BASE(x) + 0x154)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_CH_DB_MODE_SEL1(x)           (*(volatile hw_ipu_ch_db_mode_sel1_t *) HW_IPU_CH_DB_MODE_SEL1_ADDR(x))
#define HW_IPU_CH_DB_MODE_SEL1_RD(x)        (HW_IPU_CH_DB_MODE_SEL1(x).U)
#define HW_IPU_CH_DB_MODE_SEL1_WR(x, v)     (HW_IPU_CH_DB_MODE_SEL1(x).U = (v))
#define HW_IPU_CH_DB_MODE_SEL1_SET(x, v)    (HW_IPU_CH_DB_MODE_SEL1_WR(x, HW_IPU_CH_DB_MODE_SEL1_RD(x) |  (v)))
#define HW_IPU_CH_DB_MODE_SEL1_CLR(x, v)    (HW_IPU_CH_DB_MODE_SEL1_WR(x, HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~(v)))
#define HW_IPU_CH_DB_MODE_SEL1_TOG(x, v)    (HW_IPU_CH_DB_MODE_SEL1_WR(x, HW_IPU_CH_DB_MODE_SEL1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_CH_DB_MODE_SEL1 bitfields
 */

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_33[1] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33      (1)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33      (0x00000002)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_33 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_33(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_40[8] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40      (8)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40      (0x00000100)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_40 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_40(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_41[9] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41      (9)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41      (0x00000200)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_41 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_41(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_42[10] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42      (10)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42      (0x00000400)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_42 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_42(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_43[11] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43      (11)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43      (0x00000800)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_43 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_43(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_44[12] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44      (12)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44      (0x00001000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_44 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_44(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_45[13] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45      (13)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45      (0x00002000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_45 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_45(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_46[14] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46      (14)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46      (0x00004000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_46 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_46(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_47[15] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47      (15)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47      (0x00008000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_47 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_47(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_48[16] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48      (16)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48      (0x00010000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_48 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_48(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_49[17] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49      (17)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49      (0x00020000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_49 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_49(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_50[18] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50      (18)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50      (0x00040000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_50 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_50(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_51[19] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51      (19)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51      (0x00080000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_51 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_51(v)))
#endif
//@}

/*! @name Register IPU_CH_DB_MODE_SEL1, field DMA_CH_DB_MODE_SEL_52[20] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52      (20)      //!< Bit position for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52.
#define BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52      (0x00100000)  //!< Bit mask for IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52.

//! @brief Get value of IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52 from a register value.
#define BG_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52) >> BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52)

//! @brief Format value for bitfield IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52.
#define BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52) & BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_DB_MODE_SEL_52 field to a new value.
#define BW_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52(x, v)   (HW_IPU_CH_DB_MODE_SEL1_WR(x, (HW_IPU_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52) | BF_IPU_CH_DB_MODE_SEL1_DMA_CH_DB_MODE_SEL_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_ALT_CH_DB_MODE_SEL0 - Alternate Channel Double Buffer Mode Select 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_ALT_CH_DB_MODE_SEL0 - Alternate Channel Double Buffer Mode Select 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains double buffer mode select control information for 32 IPU's DMA channels.
 */
typedef union _hw_ipu_alt_ch_db_mode_sel0
{
    reg32_t U;
    struct _hw_ipu_alt_ch_db_mode_sel0_bitfields
    {
        unsigned RESERVED0 : 4; //!< [3:0] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_4 : 1; //!< [4] Double Buffer Mode Select.
        unsigned DMA_CH_ALT_DB_MODE_SEL_5 : 1; //!< [5] Double Buffer Mode Select.
        unsigned DMA_CH_ALT_DB_MODE_SEL_6 : 1; //!< [6] Double Buffer Mode Select.
        unsigned DMA_CH_ALT_DB_MODE_SEL_7 : 1; //!< [7] Double Buffer Mode Select.
        unsigned RESERVED1 : 16; //!< [23:8] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_24 : 1; //!< [24] Double Buffer Mode Select.
        unsigned RESERVED2 : 4; //!< [28:25] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_29 : 1; //!< [29] Double Buffer Mode Select.
        unsigned RESERVED3 : 2; //!< [31:30] Reserved.
    } B;
} hw_ipu_alt_ch_db_mode_sel0_t;
#endif

/*!
 * @name Constants and macros for entire IPU_ALT_CH_DB_MODE_SEL0 register
 */
//@{
#define HW_IPU_ALT_CH_DB_MODE_SEL0_ADDR(x)      (REGS_IPU_BASE(x) + 0x168)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_ALT_CH_DB_MODE_SEL0(x)           (*(volatile hw_ipu_alt_ch_db_mode_sel0_t *) HW_IPU_ALT_CH_DB_MODE_SEL0_ADDR(x))
#define HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x)        (HW_IPU_ALT_CH_DB_MODE_SEL0(x).U)
#define HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, v)     (HW_IPU_ALT_CH_DB_MODE_SEL0(x).U = (v))
#define HW_IPU_ALT_CH_DB_MODE_SEL0_SET(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) |  (v)))
#define HW_IPU_ALT_CH_DB_MODE_SEL0_CLR(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~(v)))
#define HW_IPU_ALT_CH_DB_MODE_SEL0_TOG(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_ALT_CH_DB_MODE_SEL0 bitfields
 */

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_4[4] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4      (4)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4      (0x00000010)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_4 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_4(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_5[5] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5      (5)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5      (0x00000020)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_5 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_5(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_6[6] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6      (6)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6      (0x00000040)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_6 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_6(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_7[7] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7      (7)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7      (0x00000080)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_7 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_7(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_24[24] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24      (24)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24      (0x01000000)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_24 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_24(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL0, field DMA_CH_ALT_DB_MODE_SEL_29[29] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29      (29)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29.
#define BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29      (0x20000000)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29) >> BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29.
#define BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29) & BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_29 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29) | BF_IPU_ALT_CH_DB_MODE_SEL0_DMA_CH_ALT_DB_MODE_SEL_29(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_ALT_CH_DB_MODE_SEL1 - Alternate Channel Double Buffer Mode Select1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_ALT_CH_DB_MODE_SEL1 - Alternate Channel Double Buffer Mode Select1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains double buffer mode select control information for 32 IPU's DMA channels.
 */
typedef union _hw_ipu_alt_ch_db_mode_sel1
{
    reg32_t U;
    struct _hw_ipu_alt_ch_db_mode_sel1_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_33 : 1; //!< [1] Double Buffer Mode Select.
        unsigned RESERVED1 : 7; //!< [8:2] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_41 : 1; //!< [9] Double Buffer Mode Select.
        unsigned RESERVED2 : 10; //!< [19:10] Reserved.
        unsigned DMA_CH_ALT_DB_MODE_SEL_52 : 1; //!< [20] Double Buffer Mode Select.
        unsigned RESERVED3 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_alt_ch_db_mode_sel1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_ALT_CH_DB_MODE_SEL1 register
 */
//@{
#define HW_IPU_ALT_CH_DB_MODE_SEL1_ADDR(x)      (REGS_IPU_BASE(x) + 0x16c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_ALT_CH_DB_MODE_SEL1(x)           (*(volatile hw_ipu_alt_ch_db_mode_sel1_t *) HW_IPU_ALT_CH_DB_MODE_SEL1_ADDR(x))
#define HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x)        (HW_IPU_ALT_CH_DB_MODE_SEL1(x).U)
#define HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, v)     (HW_IPU_ALT_CH_DB_MODE_SEL1(x).U = (v))
#define HW_IPU_ALT_CH_DB_MODE_SEL1_SET(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) |  (v)))
#define HW_IPU_ALT_CH_DB_MODE_SEL1_CLR(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) & ~(v)))
#define HW_IPU_ALT_CH_DB_MODE_SEL1_TOG(x, v)    (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_ALT_CH_DB_MODE_SEL1 bitfields
 */

/*! @name Register IPU_ALT_CH_DB_MODE_SEL1, field DMA_CH_ALT_DB_MODE_SEL_33[1] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33      (1)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33.
#define BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33      (0x00000002)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33) >> BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33.
#define BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_33 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33) | BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_33(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL1, field DMA_CH_ALT_DB_MODE_SEL_41[9] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41      (9)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41.
#define BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41      (0x00000200)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41) >> BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41.
#define BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_41 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41) | BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_41(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_DB_MODE_SEL1, field DMA_CH_ALT_DB_MODE_SEL_52[20] (RW)
 *
 * Double Buffer Mode Select. This bit indicates if a double buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Double buffer is not used for this channel.
 * - 1 - Double buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52      (20)      //!< Bit position for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52.
#define BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52      (0x00100000)  //!< Bit mask for IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52.

//! @brief Get value of IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52 from a register value.
#define BG_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52) >> BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52)

//! @brief Format value for bitfield IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52.
#define BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52) & BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_ALT_DB_MODE_SEL_52 field to a new value.
#define BW_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52(x, v)   (HW_IPU_ALT_CH_DB_MODE_SEL1_WR(x, (HW_IPU_ALT_CH_DB_MODE_SEL1_RD(x) & ~BM_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52) | BF_IPU_ALT_CH_DB_MODE_SEL1_DMA_CH_ALT_DB_MODE_SEL_52(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_ALT_CH_TRB_MODE_SEL0 - Alternate Channel Triple Buffer Mode Select 0 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_ALT_CH_TRB_MODE_SEL0 - Alternate Channel Triple Buffer Mode Select 0 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains triple buffer mode select control information for 32 IPU's DMA channels.
 * When the channel is configured for triple buffer mode. The double buffer mode settings configured
 * on the corresponding DB_MODE_SEL bit are overridden. Hide VPU_SUB_FRAME_SYNC for all versions
 * Show VPU_SUB_FRAME_SYNC for IPUv3H version. The table below tagged with other settings (like
 * IPU3M_only) should be hidden in IPUv3H version. This requires some sophisticated conditional tag
 * settings
 */
typedef union _hw_ipu_alt_ch_trb_mode_sel0
{
    reg32_t U;
    struct _hw_ipu_alt_ch_trb_mode_sel0_bitfields
    {
        unsigned RESERVED0 : 8; //!< [7:0] Reserved.
        unsigned DMA_CH_TRB_MODE_SEL_8 : 1; //!< [8] Triple Buffer Mode Select.
        unsigned DMA_CH_TRB_MODE_SEL_9 : 1; //!< [9] Triple Buffer Mode Select.
        unsigned DMA_CH_TRB_MODE_SEL_10 : 1; //!< [10] Triple Buffer Mode Select.
        unsigned RESERVED1 : 2; //!< [12:11] Reserved.
        unsigned DMA_CH_TRB_MODE_SEL_13 : 1; //!< [13] Triple Buffer Mode Select.
        unsigned RESERVED2 : 7; //!< [20:14] Reserved.
        unsigned DMA_CH_TRB_MODE_SEL_21 : 1; //!< [21] Triple Buffer Mode Select.
        unsigned RESERVED3 : 1; //!< [22] Reserved.
        unsigned DMA_CH_TRB_MODE_SEL_23 : 1; //!< [23] Triple Buffer Mode Select.
        unsigned RESERVED4 : 3; //!< [26:24] Reserved.
        unsigned DMA_CH_TRB_MODE_SEL_27 : 1; //!< [27] Triple Buffer Mode Select.
        unsigned DMA_CH_TRB_MODE_SEL_28 : 1; //!< [28] Triple Buffer Mode Select.
        unsigned RESERVED5 : 3; //!< [31:29] Reserved.
    } B;
} hw_ipu_alt_ch_trb_mode_sel0_t;
#endif

/*!
 * @name Constants and macros for entire IPU_ALT_CH_TRB_MODE_SEL0 register
 */
//@{
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_ADDR(x)      (REGS_IPU_BASE(x) + 0x178)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_ALT_CH_TRB_MODE_SEL0(x)           (*(volatile hw_ipu_alt_ch_trb_mode_sel0_t *) HW_IPU_ALT_CH_TRB_MODE_SEL0_ADDR(x))
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x)        (HW_IPU_ALT_CH_TRB_MODE_SEL0(x).U)
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, v)     (HW_IPU_ALT_CH_TRB_MODE_SEL0(x).U = (v))
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_SET(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) |  (v)))
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_CLR(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~(v)))
#define HW_IPU_ALT_CH_TRB_MODE_SEL0_TOG(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_ALT_CH_TRB_MODE_SEL0 bitfields
 */

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_8[8] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8      (8)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8      (0x00000100)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_8 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_8(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_9[9] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9      (9)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9      (0x00000200)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_9 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_9(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_10[10] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10      (10)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10      (0x00000400)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_10 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_10(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_13[13] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13      (13)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13      (0x00002000)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_13 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_13(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_21[21] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21      (21)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21      (0x00200000)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_21 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_21(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_23[23] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23      (23)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23      (0x00800000)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_23 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_23(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_27[27] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27      (27)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27      (0x08000000)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_27 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_27(v)))
#endif
//@}

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL0, field DMA_CH_TRB_MODE_SEL_28[28] (RW)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28      (28)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28.
#define BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28      (0x10000000)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28 from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28) >> BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28)

//! @brief Format value for bitfield IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28.
#define BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28) & BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA_CH_TRB_MODE_SEL_28 field to a new value.
#define BW_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28(x, v)   (HW_IPU_ALT_CH_TRB_MODE_SEL0_WR(x, (HW_IPU_ALT_CH_TRB_MODE_SEL0_RD(x) & ~BM_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28) | BF_IPU_ALT_CH_TRB_MODE_SEL0_DMA_CH_TRB_MODE_SEL_28(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_ALT_CH_TRB_MODE_SEL1 - Alternate Channel Triple Buffer Mode Select 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_ALT_CH_TRB_MODE_SEL1 - Alternate Channel Triple Buffer Mode Select 1 Register (RW)
 *
 * Reset value: 0x00000000
 *
 * The register contains triple buffer mode select control information for 32 IPU's DMA channels.
 * When the channel is configured for triple buffer mode. The double buffer mode settings configured
 * on the corresponding DB_MODE_SEL bit are overridden.
 */
typedef union _hw_ipu_alt_ch_trb_mode_sel1
{
    reg32_t U;
    struct _hw_ipu_alt_ch_trb_mode_sel1_bitfields
    {
        unsigned DMA_CH_TRB_MODE_SEL_N : 32; //!< [31:0] Triple Buffer Mode Select.
    } B;
} hw_ipu_alt_ch_trb_mode_sel1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_ALT_CH_TRB_MODE_SEL1 register
 */
//@{
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_ADDR(x)      (REGS_IPU_BASE(x) + 0x17c)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_ALT_CH_TRB_MODE_SEL1(x)           (*(volatile hw_ipu_alt_ch_trb_mode_sel1_t *) HW_IPU_ALT_CH_TRB_MODE_SEL1_ADDR(x))
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_RD(x)        (HW_IPU_ALT_CH_TRB_MODE_SEL1(x).U)
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_WR(x, v)     (HW_IPU_ALT_CH_TRB_MODE_SEL1(x).U = (v))
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_SET(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL1_RD(x) |  (v)))
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_CLR(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL1_RD(x) & ~(v)))
#define HW_IPU_ALT_CH_TRB_MODE_SEL1_TOG(x, v)    (HW_IPU_ALT_CH_TRB_MODE_SEL1_WR(x, HW_IPU_ALT_CH_TRB_MODE_SEL1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_ALT_CH_TRB_MODE_SEL1 bitfields
 */

/*! @name Register IPU_ALT_CH_TRB_MODE_SEL1, field DMA_CH_TRB_MODE_SEL_N[31:0] (ROZ)
 *
 * Triple Buffer Mode Select. This bit indicates if a triple buffer is used for this channel. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Triple buffer is not used for this channel.
 * - 1 - Triple buffer is used for this channel.
 */
//@{
#define BP_IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N      (0)      //!< Bit position for IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N.
#define BM_IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N      (0xffffffff)  //!< Bit mask for IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N.

//! @brief Get value of IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N from a register value.
#define BG_IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N) >> BP_IPU_ALT_CH_TRB_MODE_SEL1_DMA_CH_TRB_MODE_SEL_N)
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_STAT_1 - Interrupt Status Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_STAT_1 - Interrupt Status Register 1 (W1C)
 *
 * Reset value: 0x00000000
 *
 * IPU status registers are not stored in the SRM during power gating mode.This register contains
 * part of IPU interrupts status bits. The status bits of EOF (end of frame) of DMA Channels
 * interrupts [31:0] can be found in this register.
 */
typedef union _hw_ipu_int_stat_1
{
    reg32_t U;
    struct _hw_ipu_int_stat_1_bitfields
    {
        unsigned IDMAC_EOF_0 : 1; //!< [0] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_1 : 1; //!< [1] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_2 : 1; //!< [2] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_3 : 1; //!< [3] End of Frame of Channel interrupt.
        unsigned RESERVED0 : 1; //!< [4] Reserved.
        unsigned IDMAC_EOF_5 : 1; //!< [5] End of Frame of Channel interrupt.
        unsigned RESERVED1 : 2; //!< [7:6] Reserved.
        unsigned IDMAC_EOF_8 : 1; //!< [8] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_9 : 1; //!< [9] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_10 : 1; //!< [10] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_11 : 1; //!< [11] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_12 : 1; //!< [12] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_13 : 1; //!< [13] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_14 : 1; //!< [14] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_15 : 1; //!< [15] End of Frame of Channel interrupt.
        unsigned RESERVED2 : 1; //!< [16] Reserved.
        unsigned IDMAC_EOF_17 : 1; //!< [17] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_18 : 1; //!< [18] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_19 : 1; //!< [19] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_20 : 1; //!< [20] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_21 : 1; //!< [21] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_22 : 1; //!< [22] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_23 : 1; //!< [23] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_24 : 1; //!< [24] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_25 : 1; //!< [25] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_26 : 1; //!< [26] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_27 : 1; //!< [27] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_28 : 1; //!< [28] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_29 : 1; //!< [29] End of Frame of Channel interrupt.
        unsigned RESERVED3 : 1; //!< [30] Reserved.
        unsigned IDMAC_EOF_31 : 1; //!< [31] End of Frame of Channel interrupt.
    } B;
} hw_ipu_int_stat_1_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_STAT_1 register
 */
//@{
#define HW_IPU_INT_STAT_1_ADDR(x)      (REGS_IPU_BASE(x) + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_STAT_1(x)           (*(volatile hw_ipu_int_stat_1_t *) HW_IPU_INT_STAT_1_ADDR(x))
#define HW_IPU_INT_STAT_1_RD(x)        (HW_IPU_INT_STAT_1(x).U)
#define HW_IPU_INT_STAT_1_WR(x, v)     (HW_IPU_INT_STAT_1(x).U = (v))
#define HW_IPU_INT_STAT_1_SET(x, v)    (HW_IPU_INT_STAT_1_WR(x, HW_IPU_INT_STAT_1_RD(x) |  (v)))
#define HW_IPU_INT_STAT_1_CLR(x, v)    (HW_IPU_INT_STAT_1_WR(x, HW_IPU_INT_STAT_1_RD(x) & ~(v)))
#define HW_IPU_INT_STAT_1_TOG(x, v)    (HW_IPU_INT_STAT_1_WR(x, HW_IPU_INT_STAT_1_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_STAT_1 bitfields
 */

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_0[0] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_0      (0)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_0.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_0      (0x00000001)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_0.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_0 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_0(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_0) >> BP_IPU_INT_STAT_1_IDMAC_EOF_0)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_0.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_0(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_0) & BM_IPU_INT_STAT_1_IDMAC_EOF_0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_0 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_0(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_0) | BF_IPU_INT_STAT_1_IDMAC_EOF_0(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_1[1] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_1      (1)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_1.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_1      (0x00000002)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_1.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_1 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_1(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_1) >> BP_IPU_INT_STAT_1_IDMAC_EOF_1)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_1.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_1(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_1) & BM_IPU_INT_STAT_1_IDMAC_EOF_1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_1 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_1(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_1) | BF_IPU_INT_STAT_1_IDMAC_EOF_1(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_2[2] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_2      (2)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_2.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_2      (0x00000004)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_2.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_2 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_2(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_2) >> BP_IPU_INT_STAT_1_IDMAC_EOF_2)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_2.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_2(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_2) & BM_IPU_INT_STAT_1_IDMAC_EOF_2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_2 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_2(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_2) | BF_IPU_INT_STAT_1_IDMAC_EOF_2(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_3[3] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_3      (3)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_3.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_3      (0x00000008)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_3.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_3 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_3(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_3) >> BP_IPU_INT_STAT_1_IDMAC_EOF_3)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_3.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_3(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_3) & BM_IPU_INT_STAT_1_IDMAC_EOF_3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_3 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_3(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_3) | BF_IPU_INT_STAT_1_IDMAC_EOF_3(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_5[5] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_5      (5)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_5.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_5      (0x00000020)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_5.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_5 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_5(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_5) >> BP_IPU_INT_STAT_1_IDMAC_EOF_5)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_5.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_5(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_5) & BM_IPU_INT_STAT_1_IDMAC_EOF_5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_5 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_5(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_5) | BF_IPU_INT_STAT_1_IDMAC_EOF_5(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_8[8] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_8      (8)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_8.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_8      (0x00000100)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_8.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_8 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_8(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_8) >> BP_IPU_INT_STAT_1_IDMAC_EOF_8)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_8.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_8(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_8) & BM_IPU_INT_STAT_1_IDMAC_EOF_8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_8 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_8(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_8) | BF_IPU_INT_STAT_1_IDMAC_EOF_8(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_9[9] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_9      (9)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_9.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_9      (0x00000200)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_9.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_9 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_9(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_9) >> BP_IPU_INT_STAT_1_IDMAC_EOF_9)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_9.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_9(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_9) & BM_IPU_INT_STAT_1_IDMAC_EOF_9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_9 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_9(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_9) | BF_IPU_INT_STAT_1_IDMAC_EOF_9(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_10[10] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_10      (10)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_10.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_10      (0x00000400)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_10.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_10 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_10(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_10) >> BP_IPU_INT_STAT_1_IDMAC_EOF_10)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_10.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_10(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_10) & BM_IPU_INT_STAT_1_IDMAC_EOF_10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_10 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_10(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_10) | BF_IPU_INT_STAT_1_IDMAC_EOF_10(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_11[11] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_11      (11)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_11.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_11      (0x00000800)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_11.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_11 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_11(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_11) >> BP_IPU_INT_STAT_1_IDMAC_EOF_11)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_11.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_11(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_11) & BM_IPU_INT_STAT_1_IDMAC_EOF_11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_11 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_11(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_11) | BF_IPU_INT_STAT_1_IDMAC_EOF_11(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_12[12] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_12      (12)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_12.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_12      (0x00001000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_12.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_12 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_12(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_12) >> BP_IPU_INT_STAT_1_IDMAC_EOF_12)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_12.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_12(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_12) & BM_IPU_INT_STAT_1_IDMAC_EOF_12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_12 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_12(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_12) | BF_IPU_INT_STAT_1_IDMAC_EOF_12(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_13[13] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_13      (13)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_13.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_13      (0x00002000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_13.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_13 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_13(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_13) >> BP_IPU_INT_STAT_1_IDMAC_EOF_13)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_13.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_13(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_13) & BM_IPU_INT_STAT_1_IDMAC_EOF_13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_13 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_13(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_13) | BF_IPU_INT_STAT_1_IDMAC_EOF_13(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_14[14] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_14      (14)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_14.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_14      (0x00004000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_14.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_14 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_14(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_14) >> BP_IPU_INT_STAT_1_IDMAC_EOF_14)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_14.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_14(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_14) & BM_IPU_INT_STAT_1_IDMAC_EOF_14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_14 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_14(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_14) | BF_IPU_INT_STAT_1_IDMAC_EOF_14(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_15[15] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_15      (15)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_15.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_15      (0x00008000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_15.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_15 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_15(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_15) >> BP_IPU_INT_STAT_1_IDMAC_EOF_15)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_15.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_15(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_15) & BM_IPU_INT_STAT_1_IDMAC_EOF_15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_15 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_15(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_15) | BF_IPU_INT_STAT_1_IDMAC_EOF_15(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_17[17] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_17      (17)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_17.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_17      (0x00020000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_17.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_17 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_17(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_17) >> BP_IPU_INT_STAT_1_IDMAC_EOF_17)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_17.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_17(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_17) & BM_IPU_INT_STAT_1_IDMAC_EOF_17)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_17 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_17(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_17) | BF_IPU_INT_STAT_1_IDMAC_EOF_17(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_18[18] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_18      (18)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_18.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_18      (0x00040000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_18.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_18 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_18(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_18) >> BP_IPU_INT_STAT_1_IDMAC_EOF_18)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_18.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_18(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_18) & BM_IPU_INT_STAT_1_IDMAC_EOF_18)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_18 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_18(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_18) | BF_IPU_INT_STAT_1_IDMAC_EOF_18(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_19[19] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_19      (19)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_19.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_19      (0x00080000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_19.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_19 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_19(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_19) >> BP_IPU_INT_STAT_1_IDMAC_EOF_19)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_19.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_19(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_19) & BM_IPU_INT_STAT_1_IDMAC_EOF_19)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_19 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_19(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_19) | BF_IPU_INT_STAT_1_IDMAC_EOF_19(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_20[20] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_20      (20)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_20.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_20      (0x00100000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_20.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_20 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_20(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_20) >> BP_IPU_INT_STAT_1_IDMAC_EOF_20)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_20.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_20(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_20) & BM_IPU_INT_STAT_1_IDMAC_EOF_20)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_20 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_20(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_20) | BF_IPU_INT_STAT_1_IDMAC_EOF_20(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_21[21] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_21      (21)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_21.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_21      (0x00200000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_21.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_21 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_21(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_21) >> BP_IPU_INT_STAT_1_IDMAC_EOF_21)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_21.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_21(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_21) & BM_IPU_INT_STAT_1_IDMAC_EOF_21)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_21 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_21(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_21) | BF_IPU_INT_STAT_1_IDMAC_EOF_21(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_22[22] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_22      (22)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_22.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_22      (0x00400000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_22.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_22 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_22(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_22) >> BP_IPU_INT_STAT_1_IDMAC_EOF_22)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_22.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_22(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_22) & BM_IPU_INT_STAT_1_IDMAC_EOF_22)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_22 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_22(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_22) | BF_IPU_INT_STAT_1_IDMAC_EOF_22(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_23[23] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_23      (23)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_23.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_23      (0x00800000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_23.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_23 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_23(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_23) >> BP_IPU_INT_STAT_1_IDMAC_EOF_23)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_23.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_23(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_23) & BM_IPU_INT_STAT_1_IDMAC_EOF_23)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_23 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_23(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_23) | BF_IPU_INT_STAT_1_IDMAC_EOF_23(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_24[24] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_24      (24)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_24.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_24      (0x01000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_24.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_24 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_24(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_24) >> BP_IPU_INT_STAT_1_IDMAC_EOF_24)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_24.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_24(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_24) & BM_IPU_INT_STAT_1_IDMAC_EOF_24)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_24 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_24(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_24) | BF_IPU_INT_STAT_1_IDMAC_EOF_24(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_25[25] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_25      (25)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_25.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_25      (0x02000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_25.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_25 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_25(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_25) >> BP_IPU_INT_STAT_1_IDMAC_EOF_25)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_25.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_25(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_25) & BM_IPU_INT_STAT_1_IDMAC_EOF_25)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_25 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_25(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_25) | BF_IPU_INT_STAT_1_IDMAC_EOF_25(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_26[26] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_26      (26)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_26.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_26      (0x04000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_26.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_26 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_26(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_26) >> BP_IPU_INT_STAT_1_IDMAC_EOF_26)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_26.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_26(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_26) & BM_IPU_INT_STAT_1_IDMAC_EOF_26)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_26 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_26(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_26) | BF_IPU_INT_STAT_1_IDMAC_EOF_26(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_27[27] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_27      (27)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_27.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_27      (0x08000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_27.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_27 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_27(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_27) >> BP_IPU_INT_STAT_1_IDMAC_EOF_27)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_27.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_27(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_27) & BM_IPU_INT_STAT_1_IDMAC_EOF_27)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_27 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_27(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_27) | BF_IPU_INT_STAT_1_IDMAC_EOF_27(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_28[28] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_28      (28)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_28.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_28      (0x10000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_28.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_28 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_28(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_28) >> BP_IPU_INT_STAT_1_IDMAC_EOF_28)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_28.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_28(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_28) & BM_IPU_INT_STAT_1_IDMAC_EOF_28)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_28 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_28(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_28) | BF_IPU_INT_STAT_1_IDMAC_EOF_28(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_29[29] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_29      (29)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_29.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_29      (0x20000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_29.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_29 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_29(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_29) >> BP_IPU_INT_STAT_1_IDMAC_EOF_29)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_29.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_29(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_29) & BM_IPU_INT_STAT_1_IDMAC_EOF_29)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_29 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_29(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_29) | BF_IPU_INT_STAT_1_IDMAC_EOF_29(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_1, field IDMAC_EOF_31[31] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_1_IDMAC_EOF_31      (31)      //!< Bit position for IPU_INT_STAT_1_IDMAC_EOF_31.
#define BM_IPU_INT_STAT_1_IDMAC_EOF_31      (0x80000000)  //!< Bit mask for IPU_INT_STAT_1_IDMAC_EOF_31.

//! @brief Get value of IPU_INT_STAT_1_IDMAC_EOF_31 from a register value.
#define BG_IPU_INT_STAT_1_IDMAC_EOF_31(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_1_IDMAC_EOF_31) >> BP_IPU_INT_STAT_1_IDMAC_EOF_31)

//! @brief Format value for bitfield IPU_INT_STAT_1_IDMAC_EOF_31.
#define BF_IPU_INT_STAT_1_IDMAC_EOF_31(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_1_IDMAC_EOF_31) & BM_IPU_INT_STAT_1_IDMAC_EOF_31)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_31 field to a new value.
#define BW_IPU_INT_STAT_1_IDMAC_EOF_31(x, v)   (HW_IPU_INT_STAT_1_WR(x, (HW_IPU_INT_STAT_1_RD(x) & ~BM_IPU_INT_STAT_1_IDMAC_EOF_31) | BF_IPU_INT_STAT_1_IDMAC_EOF_31(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_IPU_INT_STAT_2 - Interrupt Status Register2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_IPU_INT_STAT_2 - Interrupt Status Register2 (W1C)
 *
 * Reset value: 0x00000000
 *
 * IPU status registers are not stored in the SRM during power gating mode.This register contains
 * part of IPU interrupts status bits. The status bits of EOF (end of frame) of DMA Channels
 * interrupts [63:32] can be found in this register.
 */
typedef union _hw_ipu_int_stat_2
{
    reg32_t U;
    struct _hw_ipu_int_stat_2_bitfields
    {
        unsigned RESERVED0 : 1; //!< [0] Reserved.
        unsigned IDMAC_EOF_33 : 1; //!< [1] End of Frame of Channel interrupt.
        unsigned RESERVED1 : 6; //!< [7:2] Reserved.
        unsigned IDMAC_EOF_40 : 1; //!< [8] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_41 : 1; //!< [9] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_42 : 1; //!< [10] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_43 : 1; //!< [11] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_44 : 1; //!< [12] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_45 : 1; //!< [13] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_46 : 1; //!< [14] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_47 : 1; //!< [15] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_48 : 1; //!< [16] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_49 : 1; //!< [17] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_50 : 1; //!< [18] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_51 : 1; //!< [19] End of Frame of Channel interrupt.
        unsigned IDMAC_EOF_52 : 1; //!< [20] End of Frame of Channel interrupt.
        unsigned RESERVED2 : 11; //!< [31:21] Reserved.
    } B;
} hw_ipu_int_stat_2_t;
#endif

/*!
 * @name Constants and macros for entire IPU_INT_STAT_2 register
 */
//@{
#define HW_IPU_INT_STAT_2_ADDR(x)      (REGS_IPU_BASE(x) + 0x204)

#ifndef __LANGUAGE_ASM__
#define HW_IPU_INT_STAT_2(x)           (*(volatile hw_ipu_int_stat_2_t *) HW_IPU_INT_STAT_2_ADDR(x))
#define HW_IPU_INT_STAT_2_RD(x)        (HW_IPU_INT_STAT_2(x).U)
#define HW_IPU_INT_STAT_2_WR(x, v)     (HW_IPU_INT_STAT_2(x).U = (v))
#define HW_IPU_INT_STAT_2_SET(x, v)    (HW_IPU_INT_STAT_2_WR(x, HW_IPU_INT_STAT_2_RD(x) |  (v)))
#define HW_IPU_INT_STAT_2_CLR(x, v)    (HW_IPU_INT_STAT_2_WR(x, HW_IPU_INT_STAT_2_RD(x) & ~(v)))
#define HW_IPU_INT_STAT_2_TOG(x, v)    (HW_IPU_INT_STAT_2_WR(x, HW_IPU_INT_STAT_2_RD(x) ^  (v)))
#endif
//@}

/*
 * constants & macros for individual IPU_INT_STAT_2 bitfields
 */

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_33[1] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_33      (1)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_33.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_33      (0x00000002)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_33.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_33 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_33(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_33) >> BP_IPU_INT_STAT_2_IDMAC_EOF_33)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_33.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_33(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_33) & BM_IPU_INT_STAT_2_IDMAC_EOF_33)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_33 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_33(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_33) | BF_IPU_INT_STAT_2_IDMAC_EOF_33(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_40[8] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_40      (8)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_40.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_40      (0x00000100)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_40.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_40 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_40(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_40) >> BP_IPU_INT_STAT_2_IDMAC_EOF_40)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_40.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_40(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_40) & BM_IPU_INT_STAT_2_IDMAC_EOF_40)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_40 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_40(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_40) | BF_IPU_INT_STAT_2_IDMAC_EOF_40(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_41[9] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_41      (9)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_41.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_41      (0x00000200)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_41.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_41 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_41(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_41) >> BP_IPU_INT_STAT_2_IDMAC_EOF_41)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_41.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_41(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_41) & BM_IPU_INT_STAT_2_IDMAC_EOF_41)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_41 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_41(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_41) | BF_IPU_INT_STAT_2_IDMAC_EOF_41(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_42[10] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_42      (10)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_42.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_42      (0x00000400)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_42.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_42 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_42(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_42) >> BP_IPU_INT_STAT_2_IDMAC_EOF_42)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_42.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_42(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_42) & BM_IPU_INT_STAT_2_IDMAC_EOF_42)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_42 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_42(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_42) | BF_IPU_INT_STAT_2_IDMAC_EOF_42(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_43[11] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_43      (11)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_43.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_43      (0x00000800)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_43.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_43 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_43(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_43) >> BP_IPU_INT_STAT_2_IDMAC_EOF_43)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_43.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_43(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_43) & BM_IPU_INT_STAT_2_IDMAC_EOF_43)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_43 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_43(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_43) | BF_IPU_INT_STAT_2_IDMAC_EOF_43(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_44[12] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_44      (12)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_44.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_44      (0x00001000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_44.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_44 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_44(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_44) >> BP_IPU_INT_STAT_2_IDMAC_EOF_44)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_44.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_44(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_44) & BM_IPU_INT_STAT_2_IDMAC_EOF_44)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_44 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_44(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_44) | BF_IPU_INT_STAT_2_IDMAC_EOF_44(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_45[13] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_45      (13)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_45.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_45      (0x00002000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_45.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_45 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_45(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_45) >> BP_IPU_INT_STAT_2_IDMAC_EOF_45)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_45.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_45(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_45) & BM_IPU_INT_STAT_2_IDMAC_EOF_45)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_45 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_45(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_45) | BF_IPU_INT_STAT_2_IDMAC_EOF_45(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_46[14] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_46      (14)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_46.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_46      (0x00004000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_46.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_46 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_46(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_46) >> BP_IPU_INT_STAT_2_IDMAC_EOF_46)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_46.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_46(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_46) & BM_IPU_INT_STAT_2_IDMAC_EOF_46)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_46 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_46(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_46) | BF_IPU_INT_STAT_2_IDMAC_EOF_46(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_47[15] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_47      (15)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_47.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_47      (0x00008000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_47.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_47 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_47(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_47) >> BP_IPU_INT_STAT_2_IDMAC_EOF_47)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_47.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_47(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_47) & BM_IPU_INT_STAT_2_IDMAC_EOF_47)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_47 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_47(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_47) | BF_IPU_INT_STAT_2_IDMAC_EOF_47(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_48[16] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_48      (16)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_48.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_48      (0x00010000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_48.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_48 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_48(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_48) >> BP_IPU_INT_STAT_2_IDMAC_EOF_48)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_48.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_48(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_48) & BM_IPU_INT_STAT_2_IDMAC_EOF_48)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_48 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_48(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_48) | BF_IPU_INT_STAT_2_IDMAC_EOF_48(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_49[17] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_49      (17)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_49.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_49      (0x00020000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_49.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_49 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_49(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_49) >> BP_IPU_INT_STAT_2_IDMAC_EOF_49)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_49.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_49(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_49) & BM_IPU_INT_STAT_2_IDMAC_EOF_49)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_49 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_49(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_49) | BF_IPU_INT_STAT_2_IDMAC_EOF_49(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_50[18] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_50      (18)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_50.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_50      (0x00040000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_50.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_50 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_50(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_50) >> BP_IPU_INT_STAT_2_IDMAC_EOF_50)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_50.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_50(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_50) & BM_IPU_INT_STAT_2_IDMAC_EOF_50)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_50 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_50(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_50) | BF_IPU_INT_STAT_2_IDMAC_EOF_50(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_51[19] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_51      (19)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_51.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_51      (0x00080000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_51.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_51 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_51(r)   ((__REG_VALUE_TYPE((r), reg32_t) & BM_IPU_INT_STAT_2_IDMAC_EOF_51) >> BP_IPU_INT_STAT_2_IDMAC_EOF_51)

//! @brief Format value for bitfield IPU_INT_STAT_2_IDMAC_EOF_51.
#define BF_IPU_INT_STAT_2_IDMAC_EOF_51(v)   ((__REG_VALUE_TYPE((v), reg32_t) << BP_IPU_INT_STAT_2_IDMAC_EOF_51) & BM_IPU_INT_STAT_2_IDMAC_EOF_51)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDMAC_EOF_51 field to a new value.
#define BW_IPU_INT_STAT_2_IDMAC_EOF_51(x, v)   (HW_IPU_INT_STAT_2_WR(x, (HW_IPU_INT_STAT_2_RD(x) & ~BM_IPU_INT_STAT_2_IDMAC_EOF_51) | BF_IPU_INT_STAT_2_IDMAC_EOF_51(v)))
#endif
//@}

/*! @name Register IPU_INT_STAT_2, field IDMAC_EOF_52[20] (W1C)
 *
 * End of Frame of Channel interrupt. This bit is the status bit of End Of Frame of Channel #n. n
 * Indicates the corresponding DMA channel number.
 *
 * Values:
 * - 0 - Interrupt is cleared.
 * - 1 - Interrupt is requested.
 */
//@{
#define BP_IPU_INT_STAT_2_IDMAC_EOF_52      (20)      //!< Bit position for IPU_INT_STAT_2_IDMAC_EOF_52.
#define BM_IPU_INT_STAT_2_IDMAC_EOF_52      (0x00100000)  //!< Bit mask for IPU_INT_STAT_2_IDMAC_EOF_52.

//! @brief Get value of IPU_INT_STAT_2_IDMAC_EOF_52 from a register value.
#define BG_IPU_INT_STAT_2_IDMAC_EOF_52