/*
 * Copyright (c) 2010-2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * @file ipu_reg_def.h
 * @brief IPU registers definition for MX6DQ(IPUv3m).
 * @ingroup diag_ipu
 */

#ifndef _IPU_REGS_DEF_H_
#define _IPU_REGS_DEF_H_

#define TPM_BASE_OFFSET	0x00360000

#define IPUV3H
#define IPU_REGISTERS_OFFSET							0x00200000
#define IPU_MEMORY_OFFSET 								IPU_REGISTERS_OFFSET + 0x00100000
#define IPU_IPU_CONF__ADDR         						IPU_REGISTERS_OFFSET+0x00000000
#define IPU_IPU_CONF__EMPTY           					IPU_REGISTERS_OFFSET+0x00000000,0x00000000
#define IPU_IPU_CONF__FULL            					IPU_REGISTERS_OFFSET+0x00000000,0xffffffff
#define IPU_IPU_CONF__CSI_SEL         					IPU_REGISTERS_OFFSET+0x00000000,0x80000000
#define IPU_IPU_CONF__IC_INPUT        					IPU_REGISTERS_OFFSET+0x00000000,0x40000000
#define IPU_IPU_CONF__CSI1_DATA_SOURCE					IPU_REGISTERS_OFFSET+0x00000000,0x20000000
#define IPU_IPU_CONF__CSI0_DATA_SOURCE					IPU_REGISTERS_OFFSET+0x00000000,0x10000000
#define IPU_IPU_CONF__VDI_DMFC_SYNC   					IPU_REGISTERS_OFFSET+0x00000000,0x08000000
#define IPU_IPU_CONF__IC_DMFC_SYNC    					IPU_REGISTERS_OFFSET+0x00000000,0x04000000
#define IPU_IPU_CONF__IC_DMFC_SEL     					IPU_REGISTERS_OFFSET+0x00000000,0x02000000
#define IPU_IPU_CONF__IDMAC_DISABLE   					IPU_REGISTERS_OFFSET+0x00000000,0x00400000
#define IPU_IPU_CONF__IPU_DIAGBUS_ON  					IPU_REGISTERS_OFFSET+0x00000000,0x00200000
#define IPU_IPU_CONF__IPU_DIAGBUS_MODE					IPU_REGISTERS_OFFSET+0x00000000,0x001F0000
#define IPU_IPU_CONF__VDI_EN          					IPU_REGISTERS_OFFSET+0x00000000,0x00001000
#define IPU_IPU_CONF__SISG_EN         					IPU_REGISTERS_OFFSET+0x00000000,0x00000800
#define IPU_IPU_CONF__DMFC_EN         					IPU_REGISTERS_OFFSET+0x00000000,0x00000400
#define IPU_IPU_CONF__DC_EN           					IPU_REGISTERS_OFFSET+0x00000000,0x00000200
#define IPU_IPU_CONF__SMFC_EN         					IPU_REGISTERS_OFFSET+0x00000000,0x00000100
#define IPU_IPU_CONF__DI1_EN          					IPU_REGISTERS_OFFSET+0x00000000,0x00000080
#define IPU_IPU_CONF__DI0_EN          					IPU_REGISTERS_OFFSET+0x00000000,0x00000040
#define IPU_IPU_CONF__DP_EN           					IPU_REGISTERS_OFFSET+0x00000000,0x00000020
#define IPU_IPU_CONF__IRT_EN          					IPU_REGISTERS_OFFSET+0x00000000,0x00000008
#define IPU_IPU_CONF__IC_EN           					IPU_REGISTERS_OFFSET+0x00000000,0x00000004
#define IPU_IPU_CONF__CSI1_EN         					IPU_REGISTERS_OFFSET+0x00000000,0x00000002
#define IPU_IPU_CONF__CSI0_EN         					IPU_REGISTERS_OFFSET+0x00000000,0x00000001

#define IPU_SISG_CTRL0__ADDR                  			IPU_REGISTERS_OFFSET+0x00000004
#define IPU_SISG_CTRL0__EMPTY                 			IPU_REGISTERS_OFFSET+0x00000004,0x00000000
#define IPU_SISG_CTRL0__FULL                  			IPU_REGISTERS_OFFSET+0x00000004,0xffffffff
#define IPU_SISG_CTRL0__EXT_ACTV              			IPU_REGISTERS_OFFSET+0x00000004,0x40000000
#define IPU_SISG_CTRL0__MCU_ACTV_TRIG         			IPU_REGISTERS_OFFSET+0x00000004,0x20000000
#define IPU_SISG_CTRL0__VAL_STOP_SISG_COUNTER 			IPU_REGISTERS_OFFSET+0x00000004,0x1FFFFFF0
#define IPU_SISG_CTRL0__NO_OF_VSYNC           			IPU_REGISTERS_OFFSET+0x00000004,0x0000000E
#define IPU_SISG_CTRL0__VSYNC_RESET_COUNTER   			IPU_REGISTERS_OFFSET+0x00000004,0x00000001

#define IPU_SISG_CTRL1__ADDR            				IPU_REGISTERS_OFFSET+0x00000008
#define IPU_SISG_CTRL1__EMPTY           				IPU_REGISTERS_OFFSET+0x00000008,0x00000000
#define IPU_SISG_CTRL1__FULL            				IPU_REGISTERS_OFFSET+0x00000008,0xffffffff
#define IPU_SISG_CTRL1__SISG_OUT_POL    				IPU_REGISTERS_OFFSET+0x00000008,0x00003F00
#define IPU_SISG_CTRL1__SISG_STROBE_CNT 				IPU_REGISTERS_OFFSET+0x00000008,0x0000001F

#define IPU_SISG_SET_1__ADDR       						IPU_REGISTERS_OFFSET+0x0000000C
#define IPU_SISG_SET_1__EMPTY      						IPU_REGISTERS_OFFSET+0x0000000C,0x00000000
#define IPU_SISG_SET_1__FULL       						IPU_REGISTERS_OFFSET+0x0000000C,0xffffffff
#define IPU_SISG_SET_1__SISG_SET_1 						IPU_REGISTERS_OFFSET+0x0000000C,0x01FFFFFF

#define IPU_SISG_SET_2__ADDR       						IPU_REGISTERS_OFFSET+0x00000010
#define IPU_SISG_SET_2__EMPTY      						IPU_REGISTERS_OFFSET+0x00000010,0x00000000
#define IPU_SISG_SET_2__FULL       						IPU_REGISTERS_OFFSET+0x00000010,0xffffffff
#define IPU_SISG_SET_2__SISG_SET_2 						IPU_REGISTERS_OFFSET+0x00000010,0x01FFFFFF

#define IPU_SISG_SET_3__ADDR       						IPU_REGISTERS_OFFSET+0x00000014
#define IPU_SISG_SET_3__EMPTY      						IPU_REGISTERS_OFFSET+0x00000014,0x00000000
#define IPU_SISG_SET_3__FULL       						IPU_REGISTERS_OFFSET+0x00000014,0xffffffff
#define IPU_SISG_SET_3__SISG_SET_3 						IPU_REGISTERS_OFFSET+0x00000014,0x01FFFFFF

#define IPU_SISG_SET_4__ADDR       						IPU_REGISTERS_OFFSET+0x00000018
#define IPU_SISG_SET_4__EMPTY      						IPU_REGISTERS_OFFSET+0x00000018,0x00000000
#define IPU_SISG_SET_4__FULL       						IPU_REGISTERS_OFFSET+0x00000018,0xffffffff
#define IPU_SISG_SET_4__SISG_SET_4 						IPU_REGISTERS_OFFSET+0x00000018,0x01FFFFFF

#define IPU_SISG_SET_5__ADDR       						IPU_REGISTERS_OFFSET+0x0000001C
#define IPU_SISG_SET_5__EMPTY      						IPU_REGISTERS_OFFSET+0x0000001C,0x00000000
#define IPU_SISG_SET_5__FULL       						IPU_REGISTERS_OFFSET+0x0000001C,0xffffffff
#define IPU_SISG_SET_5__SISG_SET_5 						IPU_REGISTERS_OFFSET+0x0000001C,0x01FFFFFF

#define IPU_SISG_SET_6__ADDR       						IPU_REGISTERS_OFFSET+0x00000020
#define IPU_SISG_SET_6__EMPTY      						IPU_REGISTERS_OFFSET+0x00000020,0x00000000
#define IPU_SISG_SET_6__FULL       						IPU_REGISTERS_OFFSET+0x00000020,0xffffffff
#define IPU_SISG_SET_6__SISG_SET_6 						IPU_REGISTERS_OFFSET+0x00000020,0x01FFFFFF

#define IPU_SISG_CLR_1__ADDR         					IPU_REGISTERS_OFFSET+0x00000024
#define IPU_SISG_CLR_1__EMPTY        					IPU_REGISTERS_OFFSET+0x00000024,0x00000000
#define IPU_SISG_CLR_1__FULL         					IPU_REGISTERS_OFFSET+0x00000024,0xffffffff
#define IPU_SISG_CLR_1__SISG_CLEAR_1 					IPU_REGISTERS_OFFSET+0x00000024,0x01FFFFFF

#define IPU_SISG_CLR_2__ADDR         					IPU_REGISTERS_OFFSET+0x00000028
#define IPU_SISG_CLR_2__EMPTY        					IPU_REGISTERS_OFFSET+0x00000028,0x00000000
#define IPU_SISG_CLR_2__FULL         					IPU_REGISTERS_OFFSET+0x00000028,0xffffffff
#define IPU_SISG_CLR_2__SISG_CLEAR_2 					IPU_REGISTERS_OFFSET+0x00000028,0x01FFFFFF

#define IPU_SISG_CLR_3__ADDR         					IPU_REGISTERS_OFFSET+0x0000002C
#define IPU_SISG_CLR_3__EMPTY        					IPU_REGISTERS_OFFSET+0x0000002C,0x00000000
#define IPU_SISG_CLR_3__FULL         					IPU_REGISTERS_OFFSET+0x0000002C,0xffffffff
#define IPU_SISG_CLR_3__SISG_CLEAR_3 					IPU_REGISTERS_OFFSET+0x0000002C,0x01FFFFFF

#define IPU_SISG_CLR_4__ADDR         					IPU_REGISTERS_OFFSET+0x00000030
#define IPU_SISG_CLR_4__EMPTY        					IPU_REGISTERS_OFFSET+0x00000030,0x00000000
#define IPU_SISG_CLR_4__FULL         					IPU_REGISTERS_OFFSET+0x00000030,0xffffffff
#define IPU_SISG_CLR_4__SISG_CLEAR_4 					IPU_REGISTERS_OFFSET+0x00000030,0x01FFFFFF

#define IPU_SISG_CLR_5__ADDR         					IPU_REGISTERS_OFFSET+0x00000034
#define IPU_SISG_CLR_5__EMPTY        					IPU_REGISTERS_OFFSET+0x00000034,0x00000000
#define IPU_SISG_CLR_5__FULL         					IPU_REGISTERS_OFFSET+0x00000034,0xffffffff
#define IPU_SISG_CLR_5__SISG_CLEAR_5 					IPU_REGISTERS_OFFSET+0x00000034,0x01FFFFFF

#define IPU_SISG_CLR_6__ADDR         					IPU_REGISTERS_OFFSET+0x00000038
#define IPU_SISG_CLR_6__EMPTY        					IPU_REGISTERS_OFFSET+0x00000038,0x00000000
#define IPU_SISG_CLR_6__FULL         					IPU_REGISTERS_OFFSET+0x00000038,0xffffffff
#define IPU_SISG_CLR_6__SISG_CLEAR_6 					IPU_REGISTERS_OFFSET+0x00000038,0x01FFFFFF

#define IPU_IPU_INT_CTRL_1__ADDR            			IPU_REGISTERS_OFFSET+0x0000003C
#define IPU_IPU_INT_CTRL_1__EMPTY           			IPU_REGISTERS_OFFSET+0x0000003C,0x00000000
#define IPU_IPU_INT_CTRL_1__FULL            			IPU_REGISTERS_OFFSET+0x0000003C,0xffffffff
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_31 			IPU_REGISTERS_OFFSET+0x0000003C,0x80000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_29 			IPU_REGISTERS_OFFSET+0x0000003C,0x20000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_28 			IPU_REGISTERS_OFFSET+0x0000003C,0x10000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_27 			IPU_REGISTERS_OFFSET+0x0000003C,0x08000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_26 			IPU_REGISTERS_OFFSET+0x0000003C,0x04000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_25 			IPU_REGISTERS_OFFSET+0x0000003C,0x02000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_24 			IPU_REGISTERS_OFFSET+0x0000003C,0x01000000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_23 			IPU_REGISTERS_OFFSET+0x0000003C,0x00800000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_22 			IPU_REGISTERS_OFFSET+0x0000003C,0x00400000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_21 			IPU_REGISTERS_OFFSET+0x0000003C,0x00200000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_20 			IPU_REGISTERS_OFFSET+0x0000003C,0x00100000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_19 			IPU_REGISTERS_OFFSET+0x0000003C,0x00080000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_18 			IPU_REGISTERS_OFFSET+0x0000003C,0x00040000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_17 			IPU_REGISTERS_OFFSET+0x0000003C,0x00020000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_15 			IPU_REGISTERS_OFFSET+0x0000003C,0x00008000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_14 			IPU_REGISTERS_OFFSET+0x0000003C,0x00004000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_13 			IPU_REGISTERS_OFFSET+0x0000003C,0x00002000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_12 			IPU_REGISTERS_OFFSET+0x0000003C,0x00001000
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_11 			IPU_REGISTERS_OFFSET+0x0000003C,0x00000800
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_10 			IPU_REGISTERS_OFFSET+0x0000003C,0x00000400
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_9  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000200
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_8  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000100
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_5  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000020
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_3  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000008
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_2  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000004
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_1  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000002
#define IPU_IPU_INT_CTRL_1__IDMAC_EOF_EN_0  			IPU_REGISTERS_OFFSET+0x0000003C,0x00000001

#define IPU_IPU_INT_CTRL_2__ADDR            			IPU_REGISTERS_OFFSET+0x00000040
#define IPU_IPU_INT_CTRL_2__EMPTY           			IPU_REGISTERS_OFFSET+0x00000040,0x00000000
#define IPU_IPU_INT_CTRL_2__FULL            			IPU_REGISTERS_OFFSET+0x00000040,0xffffffff
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_52 			IPU_REGISTERS_OFFSET+0x00000040,0x00100000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_51 			IPU_REGISTERS_OFFSET+0x00000040,0x00080000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_50 			IPU_REGISTERS_OFFSET+0x00000040,0x00040000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_49 			IPU_REGISTERS_OFFSET+0x00000040,0x00020000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_48 			IPU_REGISTERS_OFFSET+0x00000040,0x00010000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_47 			IPU_REGISTERS_OFFSET+0x00000040,0x00008000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_46 			IPU_REGISTERS_OFFSET+0x00000040,0x00004000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_45 			IPU_REGISTERS_OFFSET+0x00000040,0x00002000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_44 			IPU_REGISTERS_OFFSET+0x00000040,0x00001000
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_43 			IPU_REGISTERS_OFFSET+0x00000040,0x00000800
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_42 			IPU_REGISTERS_OFFSET+0x00000040,0x00000400
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_41 			IPU_REGISTERS_OFFSET+0x00000040,0x00000200
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_40 			IPU_REGISTERS_OFFSET+0x00000040,0x00000100
#define IPU_IPU_INT_CTRL_2__IDMAC_EOF_EN_33 			IPU_REGISTERS_OFFSET+0x00000040,0x00000002

#define IPU_IPU_INT_CTRL_3__ADDR              			IPU_REGISTERS_OFFSET+0x00000044
#define IPU_IPU_INT_CTRL_3__EMPTY             			IPU_REGISTERS_OFFSET+0x00000044,0x00000000
#define IPU_IPU_INT_CTRL_3__FULL              			IPU_REGISTERS_OFFSET+0x00000044,0xffffffff
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_31 			IPU_REGISTERS_OFFSET+0x00000044,0x80000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_29 			IPU_REGISTERS_OFFSET+0x00000044,0x20000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_28 			IPU_REGISTERS_OFFSET+0x00000044,0x10000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_27 			IPU_REGISTERS_OFFSET+0x00000044,0x08000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_26 			IPU_REGISTERS_OFFSET+0x00000044,0x04000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_25 			IPU_REGISTERS_OFFSET+0x00000044,0x02000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_24 			IPU_REGISTERS_OFFSET+0x00000044,0x01000000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_23 			IPU_REGISTERS_OFFSET+0x00000044,0x00800000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_22 			IPU_REGISTERS_OFFSET+0x00000044,0x00400000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_21 			IPU_REGISTERS_OFFSET+0x00000044,0x00200000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_20 			IPU_REGISTERS_OFFSET+0x00000044,0x00100000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_19 			IPU_REGISTERS_OFFSET+0x00000044,0x00080000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_18 			IPU_REGISTERS_OFFSET+0x00000044,0x00040000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_17 			IPU_REGISTERS_OFFSET+0x00000044,0x00020000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_15 			IPU_REGISTERS_OFFSET+0x00000044,0x00008000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_14 			IPU_REGISTERS_OFFSET+0x00000044,0x00004000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_13 			IPU_REGISTERS_OFFSET+0x00000044,0x00002000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_12 			IPU_REGISTERS_OFFSET+0x00000044,0x00001000
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_11 			IPU_REGISTERS_OFFSET+0x00000044,0x00000800
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_10 			IPU_REGISTERS_OFFSET+0x00000044,0x00000400
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_9  			IPU_REGISTERS_OFFSET+0x00000044,0x00000200
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_8  			IPU_REGISTERS_OFFSET+0x00000044,0x00000100
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_5  			IPU_REGISTERS_OFFSET+0x00000044,0x00000020
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_3  			IPU_REGISTERS_OFFSET+0x00000044,0x00000008
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_2  			IPU_REGISTERS_OFFSET+0x00000044,0x00000004
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_1  			IPU_REGISTERS_OFFSET+0x00000044,0x00000002
#define IPU_IPU_INT_CTRL_3__IDMAC_NFACK_EN_0  			IPU_REGISTERS_OFFSET+0x00000044,0x00000001

#define IPU_IPU_INT_CTRL_4__ADDR              			IPU_REGISTERS_OFFSET+0x00000048
#define IPU_IPU_INT_CTRL_4__EMPTY             			IPU_REGISTERS_OFFSET+0x00000048,0x00000000
#define IPU_IPU_INT_CTRL_4__FULL              			IPU_REGISTERS_OFFSET+0x00000048,0xffffffff
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_52 			IPU_REGISTERS_OFFSET+0x00000048,0x00100000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_51 			IPU_REGISTERS_OFFSET+0x00000048,0x00080000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_50 			IPU_REGISTERS_OFFSET+0x00000048,0x00040000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_49 			IPU_REGISTERS_OFFSET+0x00000048,0x00020000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_48 			IPU_REGISTERS_OFFSET+0x00000048,0x00010000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_47 			IPU_REGISTERS_OFFSET+0x00000048,0x00008000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_46 			IPU_REGISTERS_OFFSET+0x00000048,0x00004000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_45 			IPU_REGISTERS_OFFSET+0x00000048,0x00002000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_44 			IPU_REGISTERS_OFFSET+0x00000048,0x00001000
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_43 			IPU_REGISTERS_OFFSET+0x00000048,0x00000800
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_42 			IPU_REGISTERS_OFFSET+0x00000048,0x00000400
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_41 			IPU_REGISTERS_OFFSET+0x00000048,0x00000200
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_40 			IPU_REGISTERS_OFFSET+0x00000048,0x00000100
#define IPU_IPU_INT_CTRL_4__IDMAC_NFACK_EN_33 			IPU_REGISTERS_OFFSET+0x00000048,0x00000002

#define IPU_IPU_INT_CTRL_5__ADDR                		IPU_REGISTERS_OFFSET+0x0000004C
#define IPU_IPU_INT_CTRL_5__EMPTY               		IPU_REGISTERS_OFFSET+0x0000004C,0x00000000
#define IPU_IPU_INT_CTRL_5__FULL                		IPU_REGISTERS_OFFSET+0x0000004C,0xffffffff
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_31 		IPU_REGISTERS_OFFSET+0x0000004C,0x80000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_29 		IPU_REGISTERS_OFFSET+0x0000004C,0x20000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_28 		IPU_REGISTERS_OFFSET+0x0000004C,0x10000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_27 		IPU_REGISTERS_OFFSET+0x0000004C,0x08000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_26 		IPU_REGISTERS_OFFSET+0x0000004C,0x04000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_25 		IPU_REGISTERS_OFFSET+0x0000004C,0x02000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_24 		IPU_REGISTERS_OFFSET+0x0000004C,0x01000000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_23 		IPU_REGISTERS_OFFSET+0x0000004C,0x00800000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_22 		IPU_REGISTERS_OFFSET+0x0000004C,0x00400000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_21 		IPU_REGISTERS_OFFSET+0x0000004C,0x00200000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_20 		IPU_REGISTERS_OFFSET+0x0000004C,0x00100000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_19 		IPU_REGISTERS_OFFSET+0x0000004C,0x00080000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_18 		IPU_REGISTERS_OFFSET+0x0000004C,0x00040000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_17 		IPU_REGISTERS_OFFSET+0x0000004C,0x00020000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_15 		IPU_REGISTERS_OFFSET+0x0000004C,0x00008000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_14 		IPU_REGISTERS_OFFSET+0x0000004C,0x00004000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_13 		IPU_REGISTERS_OFFSET+0x0000004C,0x00002000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_12 		IPU_REGISTERS_OFFSET+0x0000004C,0x00001000
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_11 		IPU_REGISTERS_OFFSET+0x0000004C,0x00000800
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_10 		IPU_REGISTERS_OFFSET+0x0000004C,0x00000400
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_9  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000200
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_8  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000100
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_5  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000020
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_3  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000008
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_2  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000004
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_1  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000002
#define IPU_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_0  		IPU_REGISTERS_OFFSET+0x0000004C,0x00000001

#define IPU_IPU_INT_CTRL_6__ADDR                		IPU_REGISTERS_OFFSET+0x00000050
#define IPU_IPU_INT_CTRL_6__EMPTY               		IPU_REGISTERS_OFFSET+0x00000050,0x00000000
#define IPU_IPU_INT_CTRL_6__FULL                		IPU_REGISTERS_OFFSET+0x00000050,0xffffffff
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_52 		IPU_REGISTERS_OFFSET+0x00000050,0x00100000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_51 		IPU_REGISTERS_OFFSET+0x00000050,0x00080000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_50 		IPU_REGISTERS_OFFSET+0x00000050,0x00040000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_49 		IPU_REGISTERS_OFFSET+0x00000050,0x00020000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_48 		IPU_REGISTERS_OFFSET+0x00000050,0x00010000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_47 		IPU_REGISTERS_OFFSET+0x00000050,0x00008000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_46 		IPU_REGISTERS_OFFSET+0x00000050,0x00004000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_45 		IPU_REGISTERS_OFFSET+0x00000050,0x00002000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_44 		IPU_REGISTERS_OFFSET+0x00000050,0x00001000
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_43 		IPU_REGISTERS_OFFSET+0x00000050,0x00000800
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_42 		IPU_REGISTERS_OFFSET+0x00000050,0x00000400
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_41 		IPU_REGISTERS_OFFSET+0x00000050,0x00000200
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_40 		IPU_REGISTERS_OFFSET+0x00000050,0x00000100
#define IPU_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_33 		IPU_REGISTERS_OFFSET+0x00000050,0x00000002

#define IPU_IPU_INT_CTRL_7__ADDR            			IPU_REGISTERS_OFFSET+0x00000054
#define IPU_IPU_INT_CTRL_7__EMPTY           			IPU_REGISTERS_OFFSET+0x00000054,0x00000000
#define IPU_IPU_INT_CTRL_7__FULL            			IPU_REGISTERS_OFFSET+0x00000054,0xffffffff
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_31 			IPU_REGISTERS_OFFSET+0x00000054,0x80000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_29 			IPU_REGISTERS_OFFSET+0x00000054,0x20000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_28 			IPU_REGISTERS_OFFSET+0x00000054,0x10000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_27 			IPU_REGISTERS_OFFSET+0x00000054,0x08000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_26 			IPU_REGISTERS_OFFSET+0x00000054,0x04000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_25 			IPU_REGISTERS_OFFSET+0x00000054,0x02000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_24 			IPU_REGISTERS_OFFSET+0x00000054,0x01000000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_23 			IPU_REGISTERS_OFFSET+0x00000054,0x00800000
#define IPU_IPU_INT_CTRL_7__IDMAC_EOS_EN_19 			IPU_REGISTERS_OFFSET+0x00000054,0x00080000

#define IPU_IPU_INT_CTRL_8__ADDR            			IPU_REGISTERS_OFFSET+0x00000058
#define IPU_IPU_INT_CTRL_8__EMPTY           			IPU_REGISTERS_OFFSET+0x00000058,0x00000000
#define IPU_IPU_INT_CTRL_8__FULL            			IPU_REGISTERS_OFFSET+0x00000058,0xffffffff
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_52 			IPU_REGISTERS_OFFSET+0x00000058,0x00100000
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_51 			IPU_REGISTERS_OFFSET+0x00000058,0x00080000
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_44 			IPU_REGISTERS_OFFSET+0x00000058,0x00001000
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_43 			IPU_REGISTERS_OFFSET+0x00000058,0x00000800
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_42 			IPU_REGISTERS_OFFSET+0x00000058,0x00000400
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_41 			IPU_REGISTERS_OFFSET+0x00000058,0x00000200
#define IPU_IPU_INT_CTRL_8__IDMAC_EOS_EN_33 			IPU_REGISTERS_OFFSET+0x00000058,0x00000002

#define IPU_IPU_INT_CTRL_9__ADDR                		IPU_REGISTERS_OFFSET+0x0000005C
#define IPU_IPU_INT_CTRL_9__EMPTY               		IPU_REGISTERS_OFFSET+0x0000005C,0x00000000
#define IPU_IPU_INT_CTRL_9__FULL                		IPU_REGISTERS_OFFSET+0x0000005C,0xffffffff
#define IPU_IPU_INT_CTRL_9__CSI1_PUPE_EN        		IPU_REGISTERS_OFFSET+0x0000005C,0x80000000
#define IPU_IPU_INT_CTRL_9__CSI0_PUPE_EN        		IPU_REGISTERS_OFFSET+0x0000005C,0x40000000
#define IPU_IPU_INT_CTRL_9__IC_VF_BUF_OVF_EN    		IPU_REGISTERS_OFFSET+0x0000005C,0x10000000
#define IPU_IPU_INT_CTRL_9__IC_ENC_BUF_OVF_EN   		IPU_REGISTERS_OFFSET+0x0000005C,0x08000000
#define IPU_IPU_INT_CTRL_9__IC_BAYER_BUF_OVF_EN 		IPU_REGISTERS_OFFSET+0x0000005C,0x04000000
#define IPU_IPU_INT_CTRL_9__VDI_FIFO1_OVF_EN    		IPU_REGISTERS_OFFSET+0x0000005C,0x00000001

#define IPU_IPU_INT_CTRL_10__ADDR                      	IPU_REGISTERS_OFFSET+0x00000060
#define IPU_IPU_INT_CTRL_10__EMPTY                     	IPU_REGISTERS_OFFSET+0x00000060,0x00000000
#define IPU_IPU_INT_CTRL_10__FULL                      	IPU_REGISTERS_OFFSET+0x00000060,0xffffffff
#define IPU_IPU_INT_CTRL_10__AXIR_ERR_EN               	IPU_REGISTERS_OFFSET+0x00000060,0x40000000
#define IPU_IPU_INT_CTRL_10__AXIW_ERR_EN               	IPU_REGISTERS_OFFSET+0x00000060,0x20000000
#define IPU_IPU_INT_CTRL_10__NON_PRIVILEGED_ACC_ERR_EN 	IPU_REGISTERS_OFFSET+0x00000060,0x10000000
#define IPU_IPU_INT_CTRL_10__IC_BAYER_FRM_LOST_ERR_EN  	IPU_REGISTERS_OFFSET+0x00000060,0x04000000
#define IPU_IPU_INT_CTRL_10__IC_ENC_FRM_LOST_ERR_EN    	IPU_REGISTERS_OFFSET+0x00000060,0x02000000
#define IPU_IPU_INT_CTRL_10__IC_VF_FRM_LOST_ERR_EN     	IPU_REGISTERS_OFFSET+0x00000060,0x01000000
#define IPU_IPU_INT_CTRL_10__DI1_TIME_OUT_ERR_EN       	IPU_REGISTERS_OFFSET+0x00000060,0x00400000
#define IPU_IPU_INT_CTRL_10__DI0_TIME_OUT_ERR_EN       	IPU_REGISTERS_OFFSET+0x00000060,0x00200000
#define IPU_IPU_INT_CTRL_10__DI1_SYNC_DISP_ERR_EN      	IPU_REGISTERS_OFFSET+0x00000060,0x00100000
#define IPU_IPU_INT_CTRL_10__DI0_SYNC_DISP_ERR_EN      	IPU_REGISTERS_OFFSET+0x00000060,0x00080000
#define IPU_IPU_INT_CTRL_10__DC_TEARING_ERR_6_EN       	IPU_REGISTERS_OFFSET+0x00000060,0x00040000
#define IPU_IPU_INT_CTRL_10__DC_TEARING_ERR_2_EN       	IPU_REGISTERS_OFFSET+0x00000060,0x00020000
#define IPU_IPU_INT_CTRL_10__DC_TEARING_ERR_1_EN       	IPU_REGISTERS_OFFSET+0x00000060,0x00010000
#define IPU_IPU_INT_CTRL_10__SMFC3_FRM_LOST_EN         	IPU_REGISTERS_OFFSET+0x00000060,0x00000008
#define IPU_IPU_INT_CTRL_10__SMFC2_FRM_LOST_EN         	IPU_REGISTERS_OFFSET+0x00000060,0x00000004
#define IPU_IPU_INT_CTRL_10__SMFC1_FRM_LOST_EN         	IPU_REGISTERS_OFFSET+0x00000060,0x00000002
#define IPU_IPU_INT_CTRL_10__SMFC0_FRM_LOST_EN         	IPU_REGISTERS_OFFSET+0x00000060,0x00000001

#define IPU_IPU_INT_CTRL_11__ADDR              			IPU_REGISTERS_OFFSET+0x00000064
#define IPU_IPU_INT_CTRL_11__EMPTY             			IPU_REGISTERS_OFFSET+0x00000064,0x00000000
#define IPU_IPU_INT_CTRL_11__FULL              			IPU_REGISTERS_OFFSET+0x00000064,0xffffffff
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_26 			IPU_REGISTERS_OFFSET+0x00000064,0x04000000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_25 			IPU_REGISTERS_OFFSET+0x00000064,0x02000000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_22 			IPU_REGISTERS_OFFSET+0x00000064,0x00400000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_21 			IPU_REGISTERS_OFFSET+0x00000064,0x00200000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_20 			IPU_REGISTERS_OFFSET+0x00000064,0x00100000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_12 			IPU_REGISTERS_OFFSET+0x00000064,0x00001000
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_11 			IPU_REGISTERS_OFFSET+0x00000064,0x00000800
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_10 			IPU_REGISTERS_OFFSET+0x00000064,0x00000400
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_9  			IPU_REGISTERS_OFFSET+0x00000064,0x00000200
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_8  			IPU_REGISTERS_OFFSET+0x00000064,0x00000100
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_5  			IPU_REGISTERS_OFFSET+0x00000064,0x00000020
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_3  			IPU_REGISTERS_OFFSET+0x00000064,0x00000008
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_2  			IPU_REGISTERS_OFFSET+0x00000064,0x00000004
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_1  			IPU_REGISTERS_OFFSET+0x00000064,0x00000002
#define IPU_IPU_INT_CTRL_11__IDMAC_EOBND_EN_0  			IPU_REGISTERS_OFFSET+0x00000064,0x00000001

#define IPU_IPU_INT_CTRL_12__ADDR              			IPU_REGISTERS_OFFSET+0x00000068
#define IPU_IPU_INT_CTRL_12__EMPTY             			IPU_REGISTERS_OFFSET+0x00000068,0x00000000
#define IPU_IPU_INT_CTRL_12__FULL              			IPU_REGISTERS_OFFSET+0x00000068,0xffffffff
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_50 			IPU_REGISTERS_OFFSET+0x00000068,0x00040000
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_49 			IPU_REGISTERS_OFFSET+0x00000068,0x00020000
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_48 			IPU_REGISTERS_OFFSET+0x00000068,0x00010000
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_47 			IPU_REGISTERS_OFFSET+0x00000068,0x00008000
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_46 			IPU_REGISTERS_OFFSET+0x00000068,0x00004000
#define IPU_IPU_INT_CTRL_12__IDMAC_EOBND_EN_45 			IPU_REGISTERS_OFFSET+0x00000068,0x00002000

#define IPU_IPU_INT_CTRL_13__ADDR           			IPU_REGISTERS_OFFSET+0x0000006C
#define IPU_IPU_INT_CTRL_13__EMPTY          			IPU_REGISTERS_OFFSET+0x0000006C,0x00000000
#define IPU_IPU_INT_CTRL_13__FULL           			IPU_REGISTERS_OFFSET+0x0000006C,0xffffffff
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_31 			IPU_REGISTERS_OFFSET+0x0000006C,0x80000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_29 			IPU_REGISTERS_OFFSET+0x0000006C,0x20000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_28 			IPU_REGISTERS_OFFSET+0x0000006C,0x10000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_27 			IPU_REGISTERS_OFFSET+0x0000006C,0x08000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_26 			IPU_REGISTERS_OFFSET+0x0000006C,0x04000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_25 			IPU_REGISTERS_OFFSET+0x0000006C,0x02000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_24 			IPU_REGISTERS_OFFSET+0x0000006C,0x01000000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_23 			IPU_REGISTERS_OFFSET+0x0000006C,0x00800000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_22 			IPU_REGISTERS_OFFSET+0x0000006C,0x00400000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_21 			IPU_REGISTERS_OFFSET+0x0000006C,0x00200000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_20 			IPU_REGISTERS_OFFSET+0x0000006C,0x00100000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_19 			IPU_REGISTERS_OFFSET+0x0000006C,0x00080000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_18 			IPU_REGISTERS_OFFSET+0x0000006C,0x00040000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_17 			IPU_REGISTERS_OFFSET+0x0000006C,0x00020000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_15 			IPU_REGISTERS_OFFSET+0x0000006C,0x00008000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_14 			IPU_REGISTERS_OFFSET+0x0000006C,0x00004000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_13 			IPU_REGISTERS_OFFSET+0x0000006C,0x00002000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_12 			IPU_REGISTERS_OFFSET+0x0000006C,0x00001000
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_11 			IPU_REGISTERS_OFFSET+0x0000006C,0x00000800
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_10 			IPU_REGISTERS_OFFSET+0x0000006C,0x00000400
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_9  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000200
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_8  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000100
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_5  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000020
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_3  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000008
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_2  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000004
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_1  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000002
#define IPU_IPU_INT_CTRL_13__IDMAC_TH_EN_0  			IPU_REGISTERS_OFFSET+0x0000006C,0x00000001

#define IPU_IPU_INT_CTRL_14__ADDR           			IPU_REGISTERS_OFFSET+0x00000070
#define IPU_IPU_INT_CTRL_14__EMPTY          			IPU_REGISTERS_OFFSET+0x00000070,0x00000000
#define IPU_IPU_INT_CTRL_14__FULL           			IPU_REGISTERS_OFFSET+0x00000070,0xffffffff
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_52 			IPU_REGISTERS_OFFSET+0x00000070,0x00100000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_51 			IPU_REGISTERS_OFFSET+0x00000070,0x00080000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_50 			IPU_REGISTERS_OFFSET+0x00000070,0x00040000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_49 			IPU_REGISTERS_OFFSET+0x00000070,0x00020000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_48 			IPU_REGISTERS_OFFSET+0x00000070,0x00010000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_47 			IPU_REGISTERS_OFFSET+0x00000070,0x00008000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_46 			IPU_REGISTERS_OFFSET+0x00000070,0x00004000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_45 			IPU_REGISTERS_OFFSET+0x00000070,0x00002000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_44 			IPU_REGISTERS_OFFSET+0x00000070,0x00001000
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_43 			IPU_REGISTERS_OFFSET+0x00000070,0x00000800
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_42 			IPU_REGISTERS_OFFSET+0x00000070,0x00000400
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_41 			IPU_REGISTERS_OFFSET+0x00000070,0x00000200
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_40 			IPU_REGISTERS_OFFSET+0x00000070,0x00000100
#define IPU_IPU_INT_CTRL_14__IDMAC_TH_EN_33 			IPU_REGISTERS_OFFSET+0x00000070,0x00000002

#define IPU_IPU_INT_CTRL_15__ADDR                   	IPU_REGISTERS_OFFSET+0x00000074
#define IPU_IPU_INT_CTRL_15__EMPTY                  	IPU_REGISTERS_OFFSET+0x00000074,0x00000000
#define IPU_IPU_INT_CTRL_15__FULL                   	IPU_REGISTERS_OFFSET+0x00000074,0xffffffff
#define IPU_IPU_INT_CTRL_15__DI1_CNT_EN_PRE_8_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x80000000
#define IPU_IPU_INT_CTRL_15__DI1_CNT_EN_PRE_3_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x40000000
#define IPU_IPU_INT_CTRL_15__DI1_DISP_CLK_EN_PRE_EN 	IPU_REGISTERS_OFFSET+0x00000074,0x20000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_10_EN   	IPU_REGISTERS_OFFSET+0x00000074,0x10000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_9_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x08000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_8_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x04000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_7_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x02000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_6_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x01000000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_5_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x00800000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_4_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x00400000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_3_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x00200000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_2_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x00100000
#define IPU_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_1_EN    	IPU_REGISTERS_OFFSET+0x00000074,0x00080000
#define IPU_IPU_INT_CTRL_15__DI0_DISP_CLK_EN_PRE_EN 	IPU_REGISTERS_OFFSET+0x00000074,0x00040000
#define IPU_IPU_INT_CTRL_15__DC_ASYNC_STOP_EN       	IPU_REGISTERS_OFFSET+0x00000074,0x00020000
#define IPU_IPU_INT_CTRL_15__DC_DP_START_EN         	IPU_REGISTERS_OFFSET+0x00000074,0x00010000
#define IPU_IPU_INT_CTRL_15__DI_VSYNC_PRE_1_EN      	IPU_REGISTERS_OFFSET+0x00000074,0x00008000
#define IPU_IPU_INT_CTRL_15__DI_VSYNC_PRE_0_EN      	IPU_REGISTERS_OFFSET+0x00000074,0x00004000
#define IPU_IPU_INT_CTRL_15__DC_FC_6_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00002000
#define IPU_IPU_INT_CTRL_15__DC_FC_4_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00001000
#define IPU_IPU_INT_CTRL_15__DC_FC_3_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00000800
#define IPU_IPU_INT_CTRL_15__DC_FC_2_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00000400
#define IPU_IPU_INT_CTRL_15__DC_FC_1_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00000200
#define IPU_IPU_INT_CTRL_15__DC_FC_0_EN             	IPU_REGISTERS_OFFSET+0x00000074,0x00000100
#define IPU_IPU_INT_CTRL_15__DP_ASF_BRAKE_EN        	IPU_REGISTERS_OFFSET+0x00000074,0x00000080
#define IPU_IPU_INT_CTRL_15__DP_SF_BRAKE_EN         	IPU_REGISTERS_OFFSET+0x00000074,0x00000040
#define IPU_IPU_INT_CTRL_15__DP_ASF_END_EN          	IPU_REGISTERS_OFFSET+0x00000074,0x00000020
#define IPU_IPU_INT_CTRL_15__DP_ASF_START_EN        	IPU_REGISTERS_OFFSET+0x00000074,0x00000010
#define IPU_IPU_INT_CTRL_15__DP_SF_END_EN           	IPU_REGISTERS_OFFSET+0x00000074,0x00000008
#define IPU_IPU_INT_CTRL_15__DP_SF_START_EN         	IPU_REGISTERS_OFFSET+0x00000074,0x00000004
#define IPU_IPU_INT_CTRL_15__IPU_SNOOPING2_INT_EN   	IPU_REGISTERS_OFFSET+0x00000074,0x00000002
#define IPU_IPU_INT_CTRL_15__IPU_SNOOPING1_INT_EN   	IPU_REGISTERS_OFFSET+0x00000074,0x00000001

#define IPU_IPU_SDMA_EVENT_1__ADDR                 		IPU_REGISTERS_OFFSET+0x00000078
#define IPU_IPU_SDMA_EVENT_1__EMPTY                		IPU_REGISTERS_OFFSET+0x00000078,0x00000000
#define IPU_IPU_SDMA_EVENT_1__FULL                 		IPU_REGISTERS_OFFSET+0x00000078,0xffffffff
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_31 		IPU_REGISTERS_OFFSET+0x00000078,0x80000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_29 		IPU_REGISTERS_OFFSET+0x00000078,0x20000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_28 		IPU_REGISTERS_OFFSET+0x00000078,0x10000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_27 		IPU_REGISTERS_OFFSET+0x00000078,0x08000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_26 		IPU_REGISTERS_OFFSET+0x00000078,0x04000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_25 		IPU_REGISTERS_OFFSET+0x00000078,0x02000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_24 		IPU_REGISTERS_OFFSET+0x00000078,0x01000000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_23 		IPU_REGISTERS_OFFSET+0x00000078,0x00800000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_22 		IPU_REGISTERS_OFFSET+0x00000078,0x00400000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_21 		IPU_REGISTERS_OFFSET+0x00000078,0x00200000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_20 		IPU_REGISTERS_OFFSET+0x00000078,0x00100000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_19 		IPU_REGISTERS_OFFSET+0x00000078,0x00080000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_18 		IPU_REGISTERS_OFFSET+0x00000078,0x00040000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_17 		IPU_REGISTERS_OFFSET+0x00000078,0x00020000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_15 		IPU_REGISTERS_OFFSET+0x00000078,0x00008000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_14 		IPU_REGISTERS_OFFSET+0x00000078,0x00004000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_13 		IPU_REGISTERS_OFFSET+0x00000078,0x00002000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_12 		IPU_REGISTERS_OFFSET+0x00000078,0x00001000
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_11 		IPU_REGISTERS_OFFSET+0x00000078,0x00000800
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_10 		IPU_REGISTERS_OFFSET+0x00000078,0x00000400
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_9  		IPU_REGISTERS_OFFSET+0x00000078,0x00000200
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_8  		IPU_REGISTERS_OFFSET+0x00000078,0x00000100
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_5  		IPU_REGISTERS_OFFSET+0x00000078,0x00000020
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_3  		IPU_REGISTERS_OFFSET+0x00000078,0x00000008
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_2  		IPU_REGISTERS_OFFSET+0x00000078,0x00000004
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_1  		IPU_REGISTERS_OFFSET+0x00000078,0x00000002
#define IPU_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_0  		IPU_REGISTERS_OFFSET+0x00000078,0x00000001

#define IPU_IPU_SDMA_EVENT_2__ADDR                 		IPU_REGISTERS_OFFSET+0x0000007C
#define IPU_IPU_SDMA_EVENT_2__EMPTY                		IPU_REGISTERS_OFFSET+0x0000007C,0x00000000
#define IPU_IPU_SDMA_EVENT_2__FULL                 		IPU_REGISTERS_OFFSET+0x0000007C,0xffffffff
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_52 		IPU_REGISTERS_OFFSET+0x0000007C,0x00100000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_51 		IPU_REGISTERS_OFFSET+0x0000007C,0x00080000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_50 		IPU_REGISTERS_OFFSET+0x0000007C,0x00040000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_49 		IPU_REGISTERS_OFFSET+0x0000007C,0x00020000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_48 		IPU_REGISTERS_OFFSET+0x0000007C,0x00010000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_47 		IPU_REGISTERS_OFFSET+0x0000007C,0x00008000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_46 		IPU_REGISTERS_OFFSET+0x0000007C,0x00004000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_45 		IPU_REGISTERS_OFFSET+0x0000007C,0x00002000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_44 		IPU_REGISTERS_OFFSET+0x0000007C,0x00001000
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_43 		IPU_REGISTERS_OFFSET+0x0000007C,0x00000800
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_42 		IPU_REGISTERS_OFFSET+0x0000007C,0x00000400
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_41 		IPU_REGISTERS_OFFSET+0x0000007C,0x00000200
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_40 		IPU_REGISTERS_OFFSET+0x0000007C,0x00000100
#define IPU_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_33 		IPU_REGISTERS_OFFSET+0x0000007C,0x00000002

#define IPU_IPU_SDMA_EVENT_3__ADDR                   	IPU_REGISTERS_OFFSET+0x00000080
#define IPU_IPU_SDMA_EVENT_3__EMPTY                  	IPU_REGISTERS_OFFSET+0x00000080,0x00000000
#define IPU_IPU_SDMA_EVENT_3__FULL                   	IPU_REGISTERS_OFFSET+0x00000080,0xffffffff
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_31 	IPU_REGISTERS_OFFSET+0x00000080,0x80000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_29 	IPU_REGISTERS_OFFSET+0x00000080,0x20000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_28 	IPU_REGISTERS_OFFSET+0x00000080,0x10000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_27 	IPU_REGISTERS_OFFSET+0x00000080,0x08000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_26 	IPU_REGISTERS_OFFSET+0x00000080,0x04000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_25 	IPU_REGISTERS_OFFSET+0x00000080,0x02000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_24 	IPU_REGISTERS_OFFSET+0x00000080,0x01000000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_23 	IPU_REGISTERS_OFFSET+0x00000080,0x00800000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_22 	IPU_REGISTERS_OFFSET+0x00000080,0x00400000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_21 	IPU_REGISTERS_OFFSET+0x00000080,0x00200000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_20 	IPU_REGISTERS_OFFSET+0x00000080,0x00100000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_19 	IPU_REGISTERS_OFFSET+0x00000080,0x00080000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_18 	IPU_REGISTERS_OFFSET+0x00000080,0x00040000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_17 	IPU_REGISTERS_OFFSET+0x00000080,0x00020000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_15 	IPU_REGISTERS_OFFSET+0x00000080,0x00008000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_14 	IPU_REGISTERS_OFFSET+0x00000080,0x00004000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_13 	IPU_REGISTERS_OFFSET+0x00000080,0x00002000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_12 	IPU_REGISTERS_OFFSET+0x00000080,0x00001000
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_11 	IPU_REGISTERS_OFFSET+0x00000080,0x00000800
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_10 	IPU_REGISTERS_OFFSET+0x00000080,0x00000400
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_9  	IPU_REGISTERS_OFFSET+0x00000080,0x00000200
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_8  	IPU_REGISTERS_OFFSET+0x00000080,0x00000100
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_5  	IPU_REGISTERS_OFFSET+0x00000080,0x00000020
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_3  	IPU_REGISTERS_OFFSET+0x00000080,0x00000008
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_2  	IPU_REGISTERS_OFFSET+0x00000080,0x00000004
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_1  	IPU_REGISTERS_OFFSET+0x00000080,0x00000002
#define IPU_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_0  	IPU_REGISTERS_OFFSET+0x00000080,0x00000001

#define IPU_IPU_SDMA_EVENT_4__ADDR                   	IPU_REGISTERS_OFFSET+0x00000084
#define IPU_IPU_SDMA_EVENT_4__EMPTY                  	IPU_REGISTERS_OFFSET+0x00000084,0x00000000
#define IPU_IPU_SDMA_EVENT_4__FULL                   	IPU_REGISTERS_OFFSET+0x00000084,0xffffffff
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_52 	IPU_REGISTERS_OFFSET+0x00000084,0x00100000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_51 	IPU_REGISTERS_OFFSET+0x00000084,0x00080000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_50 	IPU_REGISTERS_OFFSET+0x00000084,0x00040000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_49 	IPU_REGISTERS_OFFSET+0x00000084,0x00020000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_48 	IPU_REGISTERS_OFFSET+0x00000084,0x00010000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_47 	IPU_REGISTERS_OFFSET+0x00000084,0x00008000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_46 	IPU_REGISTERS_OFFSET+0x00000084,0x00004000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_45 	IPU_REGISTERS_OFFSET+0x00000084,0x00002000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_44 	IPU_REGISTERS_OFFSET+0x00000084,0x00001000
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_43 	IPU_REGISTERS_OFFSET+0x00000084,0x00000800
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_42 	IPU_REGISTERS_OFFSET+0x00000084,0x00000400
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_41 	IPU_REGISTERS_OFFSET+0x00000084,0x00000200
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_40 	IPU_REGISTERS_OFFSET+0x00000084,0x00000100
#define IPU_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_33 	IPU_REGISTERS_OFFSET+0x00000084,0x00000002

#define IPU_IPU_SDMA_EVENT_7__ADDR                 		IPU_REGISTERS_OFFSET+0x00000088
#define IPU_IPU_SDMA_EVENT_7__EMPTY                		IPU_REGISTERS_OFFSET+0x00000088,0x00000000
#define IPU_IPU_SDMA_EVENT_7__FULL                 		IPU_REGISTERS_OFFSET+0x00000088,0xffffffff
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_31 		IPU_REGISTERS_OFFSET+0x00000088,0x80000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_29 		IPU_REGISTERS_OFFSET+0x00000088,0x20000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_28 		IPU_REGISTERS_OFFSET+0x00000088,0x10000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_27 		IPU_REGISTERS_OFFSET+0x00000088,0x08000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_26 		IPU_REGISTERS_OFFSET+0x00000088,0x04000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_25 		IPU_REGISTERS_OFFSET+0x00000088,0x02000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_24 		IPU_REGISTERS_OFFSET+0x00000088,0x01000000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_23 		IPU_REGISTERS_OFFSET+0x00000088,0x00800000
#define IPU_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_19 		IPU_REGISTERS_OFFSET+0x00000088,0x00080000

#define IPU_IPU_SDMA_EVENT_8__ADDR                 		IPU_REGISTERS_OFFSET+0x0000008C
#define IPU_IPU_SDMA_EVENT_8__EMPTY                		IPU_REGISTERS_OFFSET+0x0000008C,0x00000000
#define IPU_IPU_SDMA_EVENT_8__FULL                 		IPU_REGISTERS_OFFSET+0x0000008C,0xffffffff
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_52 		IPU_REGISTERS_OFFSET+0x0000008C,0x00100000
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_51 		IPU_REGISTERS_OFFSET+0x0000008C,0x00080000
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_44 		IPU_REGISTERS_OFFSET+0x0000008C,0x00001000
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_43 		IPU_REGISTERS_OFFSET+0x0000008C,0x00000800
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_42 		IPU_REGISTERS_OFFSET+0x0000008C,0x00000400
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_41 		IPU_REGISTERS_OFFSET+0x0000008C,0x00000200
#define IPU_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_32 		IPU_REGISTERS_OFFSET+0x0000008C,0x00000002

#define IPU_IPU_SDMA_EVENT_11__ADDR                   	IPU_REGISTERS_OFFSET+0x00000090
#define IPU_IPU_SDMA_EVENT_11__EMPTY                  	IPU_REGISTERS_OFFSET+0x00000090,0x00000000
#define IPU_IPU_SDMA_EVENT_11__FULL                   	IPU_REGISTERS_OFFSET+0x00000090,0xffffffff
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_26 	IPU_REGISTERS_OFFSET+0x00000090,0x04000000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_25 	IPU_REGISTERS_OFFSET+0x00000090,0x02000000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_22 	IPU_REGISTERS_OFFSET+0x00000090,0x00400000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_21 	IPU_REGISTERS_OFFSET+0x00000090,0x00200000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_20 	IPU_REGISTERS_OFFSET+0x00000090,0x00100000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_12 	IPU_REGISTERS_OFFSET+0x00000090,0x00001000
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_11 	IPU_REGISTERS_OFFSET+0x00000090,0x00000800
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_10 	IPU_REGISTERS_OFFSET+0x00000090,0x00000400
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_9  	IPU_REGISTERS_OFFSET+0x00000090,0x00000200
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_8  	IPU_REGISTERS_OFFSET+0x00000090,0x00000100
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_5  	IPU_REGISTERS_OFFSET+0x00000090,0x00000020
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_3  	IPU_REGISTERS_OFFSET+0x00000090,0x00000008
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_2  	IPU_REGISTERS_OFFSET+0x00000090,0x00000004
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_1  	IPU_REGISTERS_OFFSET+0x00000090,0x00000002
#define IPU_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_0  	IPU_REGISTERS_OFFSET+0x00000090,0x00000001

#define IPU_IPU_SDMA_EVENT_12__ADDR                   	IPU_REGISTERS_OFFSET+0x00000094
#define IPU_IPU_SDMA_EVENT_12__EMPTY                  	IPU_REGISTERS_OFFSET+0x00000094,0x00000000
#define IPU_IPU_SDMA_EVENT_12__FULL                   	IPU_REGISTERS_OFFSET+0x00000094,0xffffffff
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_50 	IPU_REGISTERS_OFFSET+0x00000094,0x00040000
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_49 	IPU_REGISTERS_OFFSET+0x00000094,0x00020000
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_48 	IPU_REGISTERS_OFFSET+0x00000094,0x00010000
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_47 	IPU_REGISTERS_OFFSET+0x00000094,0x00008000
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_46 	IPU_REGISTERS_OFFSET+0x00000094,0x00004000
#define IPU_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_45 	IPU_REGISTERS_OFFSET+0x00000094,0x00002000

#define IPU_IPU_SDMA_EVENT_13__ADDR                		IPU_REGISTERS_OFFSET+0x00000098
#define IPU_IPU_SDMA_EVENT_13__EMPTY               		IPU_REGISTERS_OFFSET+0x00000098,0x00000000
#define IPU_IPU_SDMA_EVENT_13__FULL                		IPU_REGISTERS_OFFSET+0x00000098,0xffffffff
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_31 		IPU_REGISTERS_OFFSET+0x00000098,0x80000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_29 		IPU_REGISTERS_OFFSET+0x00000098,0x20000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_28 		IPU_REGISTERS_OFFSET+0x00000098,0x10000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_27 		IPU_REGISTERS_OFFSET+0x00000098,0x08000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_26 		IPU_REGISTERS_OFFSET+0x00000098,0x04000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_25 		IPU_REGISTERS_OFFSET+0x00000098,0x02000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_24 		IPU_REGISTERS_OFFSET+0x00000098,0x01000000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_23 		IPU_REGISTERS_OFFSET+0x00000098,0x00800000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_22 		IPU_REGISTERS_OFFSET+0x00000098,0x00400000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_21 		IPU_REGISTERS_OFFSET+0x00000098,0x00200000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_20 		IPU_REGISTERS_OFFSET+0x00000098,0x00100000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_19 		IPU_REGISTERS_OFFSET+0x00000098,0x00080000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_18 		IPU_REGISTERS_OFFSET+0x00000098,0x00040000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_17 		IPU_REGISTERS_OFFSET+0x00000098,0x00020000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_15 		IPU_REGISTERS_OFFSET+0x00000098,0x00008000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_14 		IPU_REGISTERS_OFFSET+0x00000098,0x00004000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_13 		IPU_REGISTERS_OFFSET+0x00000098,0x00002000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_12 		IPU_REGISTERS_OFFSET+0x00000098,0x00001000
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_11 		IPU_REGISTERS_OFFSET+0x00000098,0x00000800
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_10 		IPU_REGISTERS_OFFSET+0x00000098,0x00000400
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_9  		IPU_REGISTERS_OFFSET+0x00000098,0x00000200
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_8  		IPU_REGISTERS_OFFSET+0x00000098,0x00000100
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_5  		IPU_REGISTERS_OFFSET+0x00000098,0x00000020
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_3  		IPU_REGISTERS_OFFSET+0x00000098,0x00000008
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_2  		IPU_REGISTERS_OFFSET+0x00000098,0x00000004
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_1  		IPU_REGISTERS_OFFSET+0x00000098,0x00000002
#define IPU_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_0  		IPU_REGISTERS_OFFSET+0x00000098,0x00000001

#define IPU_IPU_SDMA_EVENT_14__ADDR                		IPU_REGISTERS_OFFSET+0x0000009C
#define IPU_IPU_SDMA_EVENT_14__EMPTY               		IPU_REGISTERS_OFFSET+0x0000009C,0x00000000
#define IPU_IPU_SDMA_EVENT_14__FULL                		IPU_REGISTERS_OFFSET+0x0000009C,0xffffffff
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_52 		IPU_REGISTERS_OFFSET+0x0000009C,0x00100000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_51 		IPU_REGISTERS_OFFSET+0x0000009C,0x00080000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_50 		IPU_REGISTERS_OFFSET+0x0000009C,0x00040000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_49 		IPU_REGISTERS_OFFSET+0x0000009C,0x00020000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_48 		IPU_REGISTERS_OFFSET+0x0000009C,0x00010000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_47 		IPU_REGISTERS_OFFSET+0x0000009C,0x00008000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_46 		IPU_REGISTERS_OFFSET+0x0000009C,0x00004000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_45 		IPU_REGISTERS_OFFSET+0x0000009C,0x00002000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_44 		IPU_REGISTERS_OFFSET+0x0000009C,0x00001000
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_43 		IPU_REGISTERS_OFFSET+0x0000009C,0x00000800
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_42 		IPU_REGISTERS_OFFSET+0x0000009C,0x00000400
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_41 		IPU_REGISTERS_OFFSET+0x0000009C,0x00000200
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_40 		IPU_REGISTERS_OFFSET+0x0000009C,0x00000100
#define IPU_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_33 		IPU_REGISTERS_OFFSET+0x0000009C,0x00000002

#define IPU_IPU_SRM_PRI1__ADDR          				IPU_REGISTERS_OFFSET+0x000000A0
#define IPU_IPU_SRM_PRI1__EMPTY         				IPU_REGISTERS_OFFSET+0x000000A0,0x00000000
#define IPU_IPU_SRM_PRI1__FULL          				IPU_REGISTERS_OFFSET+0x000000A0,0xffffffff
#define IPU_IPU_SRM_PRI1__CSI0_SRM_MODE 				IPU_REGISTERS_OFFSET+0x000000A0,0x00001800
#define IPU_IPU_SRM_PRI1__CSI0_SRM_PRI  				IPU_REGISTERS_OFFSET+0x000000A0,0x00000700
#define IPU_IPU_SRM_PRI1__CSI1_SRM_MODE 				IPU_REGISTERS_OFFSET+0x000000A0,0x00000018
#define IPU_IPU_SRM_PRI1__CSI1_SRM_PRI  				IPU_REGISTERS_OFFSET+0x000000A0,0x00000007

#define IPU_IPU_SRM_PRI2__ADDR           				IPU_REGISTERS_OFFSET+0x000000A4
#define IPU_IPU_SRM_PRI2__EMPTY          				IPU_REGISTERS_OFFSET+0x000000A4,0x00000000
#define IPU_IPU_SRM_PRI2__FULL           				IPU_REGISTERS_OFFSET+0x000000A4,0xffffffff
#define IPU_IPU_SRM_PRI2__DI1_SRM_MODE   				IPU_REGISTERS_OFFSET+0x000000A4,0x18000000
#define IPU_IPU_SRM_PRI2__DI1_SRM_PRI    				IPU_REGISTERS_OFFSET+0x000000A4,0x07000000
#define IPU_IPU_SRM_PRI2__DI0_SRM_MODE   				IPU_REGISTERS_OFFSET+0x000000A4,0x00180000
#define IPU_IPU_SRM_PRI2__DI0_SRM_PRI    				IPU_REGISTERS_OFFSET+0x000000A4,0x00070000
#define IPU_IPU_SRM_PRI2__DC_6_SRM_MODE  				IPU_REGISTERS_OFFSET+0x000000A4,0x0000C000
#define IPU_IPU_SRM_PRI2__DC_2_SRM_MODE  				IPU_REGISTERS_OFFSET+0x000000A4,0x00003000
#define IPU_IPU_SRM_PRI2__DC_SRM_PRI     				IPU_REGISTERS_OFFSET+0x000000A4,0x00000E00
#define IPU_IPU_SRM_PRI2__DP_A1_SRM_MODE 				IPU_REGISTERS_OFFSET+0x000000A4,0x00000180
#define IPU_IPU_SRM_PRI2__DP_A0_SRM_MODE 				IPU_REGISTERS_OFFSET+0x000000A4,0x00000060
#define IPU_IPU_SRM_PRI2__DP_S_SRM_MODE  				IPU_REGISTERS_OFFSET+0x000000A4,0x00000018
#define IPU_IPU_SRM_PRI2__DP_SRM_PRI     				IPU_REGISTERS_OFFSET+0x000000A4,0x00000007

#define IPU_IPU_FS_PROC_FLOW1__ADDR               		IPU_REGISTERS_OFFSET+0x000000A8
#define IPU_IPU_FS_PROC_FLOW1__EMPTY              		IPU_REGISTERS_OFFSET+0x000000A8,0x00000000
#define IPU_IPU_FS_PROC_FLOW1__FULL               		IPU_REGISTERS_OFFSET+0x000000A8,0xffffffff
#define IPU_IPU_FS_PROC_FLOW1__VF_IN_VALID        		IPU_REGISTERS_OFFSET+0x000000A8,0x80000000
#define IPU_IPU_FS_PROC_FLOW1__ENC_IN_VALID       		IPU_REGISTERS_OFFSET+0x000000A8,0x40000000
#define IPU_IPU_FS_PROC_FLOW1__VDI_SRC_SEL        		IPU_REGISTERS_OFFSET+0x000000A8,0x30000000
#define IPU_IPU_FS_PROC_FLOW1__PRP_SRC_SEL        		IPU_REGISTERS_OFFSET+0x000000A8,0x0F000000
#define IPU_IPU_FS_PROC_FLOW1__VDI3_SRC_SEL       		IPU_REGISTERS_OFFSET+0x000000A8,0x00C00000
#define IPU_IPU_FS_PROC_FLOW1__VDI1_SRC_SEL       		IPU_REGISTERS_OFFSET+0x000000A8,0x00300000
#define IPU_IPU_FS_PROC_FLOW1__PP_ROT_SRC_SEL     		IPU_REGISTERS_OFFSET+0x000000A8,0x000F0000
#define IPU_IPU_FS_PROC_FLOW1__PP_SRC_SEL         		IPU_REGISTERS_OFFSET+0x000000A8,0x0000F000
#define IPU_IPU_FS_PROC_FLOW1__PRPVF_ROT_SRC_SEL  		IPU_REGISTERS_OFFSET+0x000000A8,0x00000F00
#define IPU_IPU_FS_PROC_FLOW1__PRPENC_ROT_SRC_SEL 		IPU_REGISTERS_OFFSET+0x000000A8,0x0000000F

#define IPU_IPU_FS_PROC_FLOW2__ADDR                		IPU_REGISTERS_OFFSET+0x000000AC
#define IPU_IPU_FS_PROC_FLOW2__EMPTY               		IPU_REGISTERS_OFFSET+0x000000AC,0x00000000
#define IPU_IPU_FS_PROC_FLOW2__FULL                		IPU_REGISTERS_OFFSET+0x000000AC,0xffffffff
#define IPU_IPU_FS_PROC_FLOW2__PRP_DEST_SEL        		IPU_REGISTERS_OFFSET+0x000000AC,0x0F000000
#define IPU_IPU_FS_PROC_FLOW2__PRPENC_ROT_DEST_SEL 		IPU_REGISTERS_OFFSET+0x000000AC,0x00F00000
#define IPU_IPU_FS_PROC_FLOW2__PP_ROT_DEST_SEL     		IPU_REGISTERS_OFFSET+0x000000AC,0x000F0000
#define IPU_IPU_FS_PROC_FLOW2__PP_DEST_SEL         		IPU_REGISTERS_OFFSET+0x000000AC,0x0000F000
#define IPU_IPU_FS_PROC_FLOW2__PRPVF_ROT_DEST_SEL  		IPU_REGISTERS_OFFSET+0x000000AC,0x00000F00
#define IPU_IPU_FS_PROC_FLOW2__PRPVF_DEST_SEL      		IPU_REGISTERS_OFFSET+0x000000AC,0x000000F0
#define IPU_IPU_FS_PROC_FLOW2__PRP_ENC_DEST_SEL    		IPU_REGISTERS_OFFSET+0x000000AC,0x0000000F

#define IPU_IPU_FS_PROC_FLOW3__ADDR              		IPU_REGISTERS_OFFSET+0x000000B0
#define IPU_IPU_FS_PROC_FLOW3__EMPTY             		IPU_REGISTERS_OFFSET+0x000000B0,0x00000000
#define IPU_IPU_FS_PROC_FLOW3__FULL              		IPU_REGISTERS_OFFSET+0x000000B0,0xffffffff
#define IPU_IPU_FS_PROC_FLOW3__IPU_VPU_DEST_SEL  		IPU_REGISTERS_OFFSET+0x000000B0,0x03000000
#define IPU_IPU_FS_PROC_FLOW3__EXT_SRC2_DEST_SEL 		IPU_REGISTERS_OFFSET+0x000000B0,0x00C00000
#define IPU_IPU_FS_PROC_FLOW3__EXT_SRC1_DEST_SEL 		IPU_REGISTERS_OFFSET+0x000000B0,0x00300000
#define IPU_IPU_FS_PROC_FLOW3__VDOA_DEST_SEL     		IPU_REGISTERS_OFFSET+0x000000B0,0x00030000
#define IPU_IPU_FS_PROC_FLOW3__SMFC3_DEST_SEL    		IPU_REGISTERS_OFFSET+0x000000B0,0x00003800
#define IPU_IPU_FS_PROC_FLOW3__SMFC2_DEST_SEL    		IPU_REGISTERS_OFFSET+0x000000B0,0x00000780
#define IPU_IPU_FS_PROC_FLOW3__SMFC1_DEST_SEL    		IPU_REGISTERS_OFFSET+0x000000B0,0x00000070
#define IPU_IPU_FS_PROC_FLOW3__SMFC0_DEST_SEL    		IPU_REGISTERS_OFFSET+0x000000B0,0x0000000F

#define IPU_IPU_FS_DISP_FLOW1__ADDR              		IPU_REGISTERS_OFFSET+0x000000B4
#define IPU_IPU_FS_DISP_FLOW1__EMPTY             		IPU_REGISTERS_OFFSET+0x000000B4,0x00000000
#define IPU_IPU_FS_DISP_FLOW1__FULL              		IPU_REGISTERS_OFFSET+0x000000B4,0xffffffff
#define IPU_IPU_FS_DISP_FLOW1__DC1_SRC_SEL       		IPU_REGISTERS_OFFSET+0x000000B4,0x00F00000
#define IPU_IPU_FS_DISP_FLOW1__DC2_SRC_SEL       		IPU_REGISTERS_OFFSET+0x000000B4,0x000F0000
#define IPU_IPU_FS_DISP_FLOW1__DP_ASYNC1_SRC_SEL 		IPU_REGISTERS_OFFSET+0x000000B4,0x0000F000
#define IPU_IPU_FS_DISP_FLOW1__DP_ASYNC0_SRC_SEL 		IPU_REGISTERS_OFFSET+0x000000B4,0x00000F00
#define IPU_IPU_FS_DISP_FLOW1__DP_SYNC1_SRC_SEL  		IPU_REGISTERS_OFFSET+0x000000B4,0x000000F0
#define IPU_IPU_FS_DISP_FLOW1__DP_SYNC0_SRC_SEL  		IPU_REGISTERS_OFFSET+0x000000B4,0x0000000F

#define IPU_IPU_FS_DISP_FLOW2__ADDR                  	IPU_REGISTERS_OFFSET+0x000000B8
#define IPU_IPU_FS_DISP_FLOW2__EMPTY                 	IPU_REGISTERS_OFFSET+0x000000B8,0x00000000
#define IPU_IPU_FS_DISP_FLOW2__FULL                  	IPU_REGISTERS_OFFSET+0x000000B8,0xffffffff
#define IPU_IPU_FS_DISP_FLOW2__DC2_ALT_SRC_SEL       	IPU_REGISTERS_OFFSET+0x000000B8,0x000F0000
#define IPU_IPU_FS_DISP_FLOW2__DP_ASYNC1_ALT_SRC_SEL 	IPU_REGISTERS_OFFSET+0x000000B8,0x000000F0
#define IPU_IPU_FS_DISP_FLOW2__DP_ASYNC0_ALT_SRC_SEL 	IPU_REGISTERS_OFFSET+0x000000B8,0x0000000F

#define IPU_IPU_SKIP__ADDR                      		IPU_REGISTERS_OFFSET+0x000000BC
#define IPU_IPU_SKIP__EMPTY                     		IPU_REGISTERS_OFFSET+0x000000BC,0x00000000
#define IPU_IPU_SKIP__FULL                      		IPU_REGISTERS_OFFSET+0x000000BC,0xffffffff
#define IPU_IPU_SKIP__VDI_SKIP                  		IPU_REGISTERS_OFFSET+0x000000BC,0xFFF00000
#define IPU_IPU_SKIP__VDI_MAX_RATIO_SKIP        		IPU_REGISTERS_OFFSET+0x000000BC,0x000F0000
#define IPU_IPU_SKIP__CSI_SKIP_IC_VF            		IPU_REGISTERS_OFFSET+0x000000BC,0x0000F800
#define IPU_IPU_SKIP__CSI_MAX_RATIO_SKIP_IC_VF  		IPU_REGISTERS_OFFSET+0x000000BC,0x00000700
#define IPU_IPU_SKIP__CSI_SKIP_IC_ENC           		IPU_REGISTERS_OFFSET+0x000000BC,0x000000F8
#define IPU_IPU_SKIP__CSI_MAX_RATIO_SKIP_IC_ENC 		IPU_REGISTERS_OFFSET+0x000000BC,0x00000007

#define IPU_IPU_DISP_ALT_CONF__ADDR  					IPU_REGISTERS_OFFSET+0x000000C0
#define IPU_IPU_DISP_ALT_CONF__EMPTY 					IPU_REGISTERS_OFFSET+0x000000C0,0x00000000
#define IPU_IPU_DISP_ALT_CONF__FULL  					IPU_REGISTERS_OFFSET+0x000000C0,0xffffffff

#define IPU_IPU_DISP_GEN__ADDR                 			IPU_REGISTERS_OFFSET+0x000000C4
#define IPU_IPU_DISP_GEN__EMPTY                			IPU_REGISTERS_OFFSET+0x000000C4,0x00000000
#define IPU_IPU_DISP_GEN__FULL                 			IPU_REGISTERS_OFFSET+0x000000C4,0xffffffff
#define IPU_IPU_DISP_GEN__DI1_COUNTER_RELEASE  			IPU_REGISTERS_OFFSET+0x000000C4,0x02000000
#define IPU_IPU_DISP_GEN__DI0_COUNTER_RELEASE  			IPU_REGISTERS_OFFSET+0x000000C4,0x01000000
#define IPU_IPU_DISP_GEN__CSI_VSYNC_DEST       			IPU_REGISTERS_OFFSET+0x000000C4,0x00800000
#define IPU_IPU_DISP_GEN__MCU_MAX_BURST_STOP   			IPU_REGISTERS_OFFSET+0x000000C4,0x00400000
#define IPU_IPU_DISP_GEN__MCU_T                			IPU_REGISTERS_OFFSET+0x000000C4,0x003C0000
#define IPU_IPU_DISP_GEN__MCU_DI_ID_9          			IPU_REGISTERS_OFFSET+0x000000C4,0x00020000
#define IPU_IPU_DISP_GEN__MCU_DI_ID_8          			IPU_REGISTERS_OFFSET+0x000000C4,0x00010000
#define IPU_IPU_DISP_GEN__DP_PIPE_CLR          			IPU_REGISTERS_OFFSET+0x000000C4,0x00000040
#define IPU_IPU_DISP_GEN__DP_FG_EN_ASYNC1      			IPU_REGISTERS_OFFSET+0x000000C4,0x00000020
#define IPU_IPU_DISP_GEN__DP_FG_EN_ASYNC0      			IPU_REGISTERS_OFFSET+0x000000C4,0x00000010
#define IPU_IPU_DISP_GEN__DP_ASYNC_DOUBLE_FLOW 			IPU_REGISTERS_OFFSET+0x000000C4,0x00000008
#define IPU_IPU_DISP_GEN__DC2_DOUBLE_FLOW      			IPU_REGISTERS_OFFSET+0x000000C4,0x00000004
#define IPU_IPU_DISP_GEN__DI1_DUAL_MODE        			IPU_REGISTERS_OFFSET+0x000000C4,0x00000002
#define IPU_IPU_DISP_GEN__DI0_DUAL_MODE        			IPU_REGISTERS_OFFSET+0x000000C4,0x00000001

#define IPU_IPU_DISP_ALT1__ADDR                  		IPU_REGISTERS_OFFSET+0x000000C8
#define IPU_IPU_DISP_ALT1__EMPTY                 		IPU_REGISTERS_OFFSET+0x000000C8,0x00000000
#define IPU_IPU_DISP_ALT1__FULL                  		IPU_REGISTERS_OFFSET+0x000000C8,0xffffffff
#define IPU_IPU_DISP_ALT1__SEL_ALT_0             		IPU_REGISTERS_OFFSET+0x000000C8,0xF0000000
#define IPU_IPU_DISP_ALT1__STEP_REPEAT_ALT_0     		IPU_REGISTERS_OFFSET+0x000000C8,0x0FFF0000
#define IPU_IPU_DISP_ALT1__CNT_AUTO_RELOAD_ALT_0 		IPU_REGISTERS_OFFSET+0x000000C8,0x00008000
#define IPU_IPU_DISP_ALT1__CNT_CLR_SEL_ALT_0     		IPU_REGISTERS_OFFSET+0x000000C8,0x00007000
#define IPU_IPU_DISP_ALT1__RUN_VALUE_M1_ALT_0    		IPU_REGISTERS_OFFSET+0x000000C8,0x00000FFF

#define IPU_IPU_DISP_ALT2__ADDR                    		IPU_REGISTERS_OFFSET+0x000000CC
#define IPU_IPU_DISP_ALT2__EMPTY                   		IPU_REGISTERS_OFFSET+0x000000CC,0x00000000
#define IPU_IPU_DISP_ALT2__FULL                    		IPU_REGISTERS_OFFSET+0x000000CC,0xffffffff
#define IPU_IPU_DISP_ALT2__RUN_RESOLUTION_ALT_0    		IPU_REGISTERS_OFFSET+0x000000CC,0x00070000
#define IPU_IPU_DISP_ALT2__OFFSET_RESOLUTION_ALT_0 		IPU_REGISTERS_OFFSET+0x000000CC,0x00007000
#define IPU_IPU_DISP_ALT2__OFFSET_VALUE_ALT_0      		IPU_REGISTERS_OFFSET+0x000000CC,0x00000FFF

#define IPU_IPU_DISP_ALT3__ADDR                  		IPU_REGISTERS_OFFSET+0x000000D0
#define IPU_IPU_DISP_ALT3__EMPTY                 		IPU_REGISTERS_OFFSET+0x000000D0,0x00000000
#define IPU_IPU_DISP_ALT3__FULL                  		IPU_REGISTERS_OFFSET+0x000000D0,0xffffffff
#define IPU_IPU_DISP_ALT3__SEL_ALT_1             		IPU_REGISTERS_OFFSET+0x000000D0,0xF0000000
#define IPU_IPU_DISP_ALT3__STEP_REPEAT_ALT_1     		IPU_REGISTERS_OFFSET+0x000000D0,0x0FFF0000
#define IPU_IPU_DISP_ALT3__CNT_AUTO_RELOAD_ALT_1 		IPU_REGISTERS_OFFSET+0x000000D0,0x00008000
#define IPU_IPU_DISP_ALT3__CNT_CLR_SEL_ALT_1     		IPU_REGISTERS_OFFSET+0x000000D0,0x00007000
#define IPU_IPU_DISP_ALT3__RUN_VALUE_M1_ALT_1    		IPU_REGISTERS_OFFSET+0x000000D0,0x00000FFF

#define IPU_IPU_DISP_ALT4__ADDR                    		IPU_REGISTERS_OFFSET+0x000000D4
#define IPU_IPU_DISP_ALT4__EMPTY                   		IPU_REGISTERS_OFFSET+0x000000D4,0x00000000
#define IPU_IPU_DISP_ALT4__FULL                    		IPU_REGISTERS_OFFSET+0x000000D4,0xffffffff
#define IPU_IPU_DISP_ALT4__RUN_RESOLUTION_ALT_1    		IPU_REGISTERS_OFFSET+0x000000D4,0x00070000
#define IPU_IPU_DISP_ALT4__OFFSET_RESOLUTION_ALT_1 		IPU_REGISTERS_OFFSET+0x000000D4,0x00007000
#define IPU_IPU_DISP_ALT4__OFFSET_VALUE_ALT_1      		IPU_REGISTERS_OFFSET+0x000000D4,0x00000FFF

#define IPU_IPU_SNOOP__ADDR            					IPU_REGISTERS_OFFSET+0x000000D8
#define IPU_IPU_SNOOP__EMPTY           					IPU_REGISTERS_OFFSET+0x000000D8,0x00000000
#define IPU_IPU_SNOOP__FULL            					IPU_REGISTERS_OFFSET+0x000000D8,0xffffffff
#define IPU_IPU_SNOOP__SNOOP2_SYNC_BYP 					IPU_REGISTERS_OFFSET+0x000000D8,0x00010000
#define IPU_IPU_SNOOP__AUTOREF_PER     					IPU_REGISTERS_OFFSET+0x000000D8,0x000003FF

#define IPU_IPU_MEM_RST__ADDR          					IPU_REGISTERS_OFFSET+0x000000DC
#define IPU_IPU_MEM_RST__EMPTY         					IPU_REGISTERS_OFFSET+0x000000DC,0x00000000
#define IPU_IPU_MEM_RST__FULL          					IPU_REGISTERS_OFFSET+0x000000DC,0xffffffff
#define IPU_IPU_MEM_RST__RST_MEM_START 					IPU_REGISTERS_OFFSET+0x000000DC,0x80000000
#define IPU_IPU_MEM_RST__RST_MEM_EN    					IPU_REGISTERS_OFFSET+0x000000DC,0x007FFFFF

#define IPU_IPU_PM__ADDR                      			IPU_REGISTERS_OFFSET+0x000000E0
#define IPU_IPU_PM__EMPTY                     			IPU_REGISTERS_OFFSET+0x000000E0,0x00000000
#define IPU_IPU_PM__FULL                      			IPU_REGISTERS_OFFSET+0x000000E0,0xffffffff
#define IPU_IPU_PM__LPSR_MODE                 			IPU_REGISTERS_OFFSET+0x000000E0,0x80000000
#define IPU_IPU_PM__DI1_SRM_CLOCK_CHANGE_MODE 			IPU_REGISTERS_OFFSET+0x000000E0,0x40000000
#define IPU_IPU_PM__DI1_CLK_PERIOD_1          			IPU_REGISTERS_OFFSET+0x000000E0,0x3F800000
#define IPU_IPU_PM__DI1_CLK_PERIOD_0          			IPU_REGISTERS_OFFSET+0x000000E0,0x007F0000
#define IPU_IPU_PM__CLOCK_MODE_STAT           			IPU_REGISTERS_OFFSET+0x000000E0,0x00008000
#define IPU_IPU_PM__DI0_SRM_CLOCK_CHANGE_MODE 			IPU_REGISTERS_OFFSET+0x000000E0,0x00004000
#define IPU_IPU_PM__DI0_CLK_PERIOD_1          			IPU_REGISTERS_OFFSET+0x000000E0,0x00003F80
#define IPU_IPU_PM__DI0_CLK_PERIOD_0          			IPU_REGISTERS_OFFSET+0x000000E0,0x0000007F

#define IPU_IPU_GPR__ADDR                       		IPU_REGISTERS_OFFSET+0x000000E4
#define IPU_IPU_GPR__EMPTY                      		IPU_REGISTERS_OFFSET+0x000000E4,0x00000000
#define IPU_IPU_GPR__FULL                       		IPU_REGISTERS_OFFSET+0x000000E4,0xffffffff
#define IPU_IPU_GPR__IPU_CH_BUF1_RDY1_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x80000000
#define IPU_IPU_GPR__IPU_CH_BUF1_RDY0_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x40000000
#define IPU_IPU_GPR__IPU_CH_BUF0_RDY1_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x20000000
#define IPU_IPU_GPR__IPU_CH_BUF0_RDY0_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x10000000
#define IPU_IPU_GPR__IPU_ALT_CH_BUF1_RDY1_CLR   		IPU_REGISTERS_OFFSET+0x000000E4,0x08000000
#define IPU_IPU_GPR__IPU_ALT_CH_BUF1_RDY0_CLR   		IPU_REGISTERS_OFFSET+0x000000E4,0x04000000
#define IPU_IPU_GPR__IPU_ALT_CH_BUF0_RDY1_CLR   		IPU_REGISTERS_OFFSET+0x000000E4,0x02000000
#define IPU_IPU_GPR__IPU_ALT_CH_BUF0_RDY0_CLR   		IPU_REGISTERS_OFFSET+0x000000E4,0x01000000
#define IPU_IPU_GPR__IPU_DI1_CLK_CHANGE_ACK_DIS 		IPU_REGISTERS_OFFSET+0x000000E4,0x00800000
#define IPU_IPU_GPR__IPU_DI0_CLK_CHANGE_ACK_DIS 		IPU_REGISTERS_OFFSET+0x000000E4,0x00400000
#define IPU_IPU_GPR__IPU_CH_BUF2_RDY1_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x00200000
#define IPU_IPU_GPR__IPU_CH_BUF2_RDY0_CLR       		IPU_REGISTERS_OFFSET+0x000000E4,0x00100000
#define IPU_IPU_GPR__CM_VF_TSTAT_CLR            		IPU_REGISTERS_OFFSET+0x000000E4,0x00080000
#define IPU_IPU_GPR__IPU_GP18                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00040000
#define IPU_IPU_GPR__IPU_GP17                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00020000
#define IPU_IPU_GPR__IPU_GP16                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00010000
#define IPU_IPU_GPR__IPU_GP15                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00008000
#define IPU_IPU_GPR__IPU_GP14                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00004000
#define IPU_IPU_GPR__IPU_GP13                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00002000
#define IPU_IPU_GPR__IPU_GP12                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00001000
#define IPU_IPU_GPR__IPU_GP11                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00000800
#define IPU_IPU_GPR__IPU_GP10                   		IPU_REGISTERS_OFFSET+0x000000E4,0x00000400
#define IPU_IPU_GPR__IPU_GP9                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000200
#define IPU_IPU_GPR__IPU_GP8                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000100
#define IPU_IPU_GPR__IPU_GP7                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000080
#define IPU_IPU_GPR__IPU_GP6                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000040
#define IPU_IPU_GPR__IPU_GP5                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000020
#define IPU_IPU_GPR__IPU_GP4                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000010
#define IPU_IPU_GPR__IPU_GP3                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000008
#define IPU_IPU_GPR__IPU_GP2                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000004
#define IPU_IPU_GPR__IPU_GP1                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000002
#define IPU_IPU_GPR__IPU_GP0                    		IPU_REGISTERS_OFFSET+0x000000E4,0x00000001

#define IPU_IPU_CH_DB_MODE_SEL_0__ADDR                  IPU_REGISTERS_OFFSET+0x00000150
#define IPU_IPU_CH_DB_MODE_SEL_0__EMPTY                 IPU_REGISTERS_OFFSET+0x00000150,0x00000000
#define IPU_IPU_CH_DB_MODE_SEL_0__FULL                  IPU_REGISTERS_OFFSET+0x00000150,0xffffffff
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_31 IPU_REGISTERS_OFFSET+0x00000150,0x80000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_29 IPU_REGISTERS_OFFSET+0x00000150,0x20000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_28 IPU_REGISTERS_OFFSET+0x00000150,0x10000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_27 IPU_REGISTERS_OFFSET+0x00000150,0x08000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_26 IPU_REGISTERS_OFFSET+0x00000150,0x04000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_25 IPU_REGISTERS_OFFSET+0x00000150,0x02000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_24 IPU_REGISTERS_OFFSET+0x00000150,0x01000000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_23 IPU_REGISTERS_OFFSET+0x00000150,0x00800000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_22 IPU_REGISTERS_OFFSET+0x00000150,0x00400000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_21 IPU_REGISTERS_OFFSET+0x00000150,0x00200000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_20 IPU_REGISTERS_OFFSET+0x00000150,0x00100000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_19 IPU_REGISTERS_OFFSET+0x00000150,0x00080000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_18 IPU_REGISTERS_OFFSET+0x00000150,0x00040000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_17 IPU_REGISTERS_OFFSET+0x00000150,0x00020000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_15 IPU_REGISTERS_OFFSET+0x00000150,0x00008000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_14 IPU_REGISTERS_OFFSET+0x00000150,0x00004000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_13 IPU_REGISTERS_OFFSET+0x00000150,0x00002000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_12 IPU_REGISTERS_OFFSET+0x00000150,0x00001000
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_11 IPU_REGISTERS_OFFSET+0x00000150,0x00000800
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_10 IPU_REGISTERS_OFFSET+0x00000150,0x00000400
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_9  IPU_REGISTERS_OFFSET+0x00000150,0x00000200
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_8  IPU_REGISTERS_OFFSET+0x00000150,0x00000100
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_5  IPU_REGISTERS_OFFSET+0x00000150,0x00000020
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_3  IPU_REGISTERS_OFFSET+0x00000150,0x00000008
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_2  IPU_REGISTERS_OFFSET+0x00000150,0x00000004
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_1  IPU_REGISTERS_OFFSET+0x00000150,0x00000002
#define IPU_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_0  IPU_REGISTERS_OFFSET+0x00000150,0x00000001

#define IPU_IPU_CH_DB_MODE_SEL_1__ADDR                  IPU_REGISTERS_OFFSET+0x00000154
#define IPU_IPU_CH_DB_MODE_SEL_1__EMPTY                 IPU_REGISTERS_OFFSET+0x00000154,0x00000000
#define IPU_IPU_CH_DB_MODE_SEL_1__FULL                  IPU_REGISTERS_OFFSET+0x00000154,0xffffffff
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_52 IPU_REGISTERS_OFFSET+0x00000154,0x00100000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_51 IPU_REGISTERS_OFFSET+0x00000154,0x00080000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_50 IPU_REGISTERS_OFFSET+0x00000154,0x00040000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_49 IPU_REGISTERS_OFFSET+0x00000154,0x00020000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_48 IPU_REGISTERS_OFFSET+0x00000154,0x00010000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_47 IPU_REGISTERS_OFFSET+0x00000154,0x00008000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_46 IPU_REGISTERS_OFFSET+0x00000154,0x00004000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_45 IPU_REGISTERS_OFFSET+0x00000154,0x00002000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_44 IPU_REGISTERS_OFFSET+0x00000154,0x00001000
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_43 IPU_REGISTERS_OFFSET+0x00000154,0x00000800
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_42 IPU_REGISTERS_OFFSET+0x00000154,0x00000400
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_41 IPU_REGISTERS_OFFSET+0x00000154,0x00000200
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_40 IPU_REGISTERS_OFFSET+0x00000154,0x00000100
#define IPU_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_33 IPU_REGISTERS_OFFSET+0x00000154,0x00000002

#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__ADDR                      IPU_REGISTERS_OFFSET+0x00000168
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__EMPTY                     IPU_REGISTERS_OFFSET+0x00000168,0x00000000
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__FULL                      IPU_REGISTERS_OFFSET+0x00000168,0xffffffff
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_29 IPU_REGISTERS_OFFSET+0x00000168,0x20000000
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_24 IPU_REGISTERS_OFFSET+0x00000168,0x01000000
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_7  IPU_REGISTERS_OFFSET+0x00000168,0x00000080
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_6  IPU_REGISTERS_OFFSET+0x00000168,0x00000040
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_5  IPU_REGISTERS_OFFSET+0x00000168,0x00000020
#define IPU_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_4  IPU_REGISTERS_OFFSET+0x00000168,0x00000010

#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__ADDR                      IPU_REGISTERS_OFFSET+0x0000016C
#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__EMPTY                     IPU_REGISTERS_OFFSET+0x0000016C,0x00000000
#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__FULL                      IPU_REGISTERS_OFFSET+0x0000016C,0xffffffff
#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_52 IPU_REGISTERS_OFFSET+0x0000016C,0x00100000
#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_41 IPU_REGISTERS_OFFSET+0x0000016C,0x00000200
#define IPU_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_33 IPU_REGISTERS_OFFSET+0x0000016C,0x00000002

#define IPU_IPU_CH_TRB_MODE_SEL_0__ADDR                   IPU_REGISTERS_OFFSET+0x00000178
#define IPU_IPU_CH_TRB_MODE_SEL_0__EMPTY                  IPU_REGISTERS_OFFSET+0x00000178,0x00000000
#define IPU_IPU_CH_TRB_MODE_SEL_0__FULL                   IPU_REGISTERS_OFFSET+0x00000178,0xffffffff
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_28 IPU_REGISTERS_OFFSET+0x00000178,0x10000000
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_27 IPU_REGISTERS_OFFSET+0x00000178,0x08000000
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_23 IPU_REGISTERS_OFFSET+0x00000178,0x00800000
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_21 IPU_REGISTERS_OFFSET+0x00000178,0x00200000
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_13 IPU_REGISTERS_OFFSET+0x00000178,0x00002000
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_10 IPU_REGISTERS_OFFSET+0x00000178,0x00000400
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_9  IPU_REGISTERS_OFFSET+0x00000178,0x00000200
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_8  IPU_REGISTERS_OFFSET+0x00000178,0x00000100
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_2  IPU_REGISTERS_OFFSET+0x00000178,0x00000004
#define IPU_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_0  IPU_REGISTERS_OFFSET+0x00000178,0x00000001

#define IPU_IPU_CH_TRB_MODE_SEL_1__ADDR  IPU_REGISTERS_OFFSET+0x0000017C
#define IPU_IPU_CH_TRB_MODE_SEL_1__EMPTY IPU_REGISTERS_OFFSET+0x0000017C,0x00000000
#define IPU_IPU_CH_TRB_MODE_SEL_1__FULL  IPU_REGISTERS_OFFSET+0x0000017C,0xffffffff

#define IPU_IPU_INT_STAT_1__ADDR         IPU_REGISTERS_OFFSET+0x00000200
#define IPU_IPU_INT_STAT_1__EMPTY        IPU_REGISTERS_OFFSET+0x00000200,0x00000000
#define IPU_IPU_INT_STAT_1__FULL         IPU_REGISTERS_OFFSET+0x00000200,0xffffffff
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_31 IPU_REGISTERS_OFFSET+0x00000200,0x80000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_29 IPU_REGISTERS_OFFSET+0x00000200,0x20000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_28 IPU_REGISTERS_OFFSET+0x00000200,0x10000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_27 IPU_REGISTERS_OFFSET+0x00000200,0x08000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_26 IPU_REGISTERS_OFFSET+0x00000200,0x04000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_25 IPU_REGISTERS_OFFSET+0x00000200,0x02000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_24 IPU_REGISTERS_OFFSET+0x00000200,0x01000000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_23 IPU_REGISTERS_OFFSET+0x00000200,0x00800000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_22 IPU_REGISTERS_OFFSET+0x00000200,0x00400000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_21 IPU_REGISTERS_OFFSET+0x00000200,0x00200000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_20 IPU_REGISTERS_OFFSET+0x00000200,0x00100000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_19 IPU_REGISTERS_OFFSET+0x00000200,0x00080000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_18 IPU_REGISTERS_OFFSET+0x00000200,0x00040000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_17 IPU_REGISTERS_OFFSET+0x00000200,0x00020000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_15 IPU_REGISTERS_OFFSET+0x00000200,0x00008000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_14 IPU_REGISTERS_OFFSET+0x00000200,0x00004000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_13 IPU_REGISTERS_OFFSET+0x00000200,0x00002000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_12 IPU_REGISTERS_OFFSET+0x00000200,0x00001000
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_11 IPU_REGISTERS_OFFSET+0x00000200,0x00000800
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_10 IPU_REGISTERS_OFFSET+0x00000200,0x00000400
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_9  IPU_REGISTERS_OFFSET+0x00000200,0x00000200
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_8  IPU_REGISTERS_OFFSET+0x00000200,0x00000100
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_5  IPU_REGISTERS_OFFSET+0x00000200,0x00000020
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_3  IPU_REGISTERS_OFFSET+0x00000200,0x00000008
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_2  IPU_REGISTERS_OFFSET+0x00000200,0x00000004
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_1  IPU_REGISTERS_OFFSET+0x00000200,0x00000002
#define IPU_IPU_INT_STAT_1__IDMAC_EOF_0  IPU_REGISTERS_OFFSET+0x00000200,0x00000001

#define IPU_IPU_INT_STAT_2__ADDR         IPU_REGISTERS_OFFSET+0x00000204
#define IPU_IPU_INT_STAT_2__EMPTY        IPU_REGISTERS_OFFSET+0x00000204,0x00000000
#define IPU_IPU_INT_STAT_2__FULL         IPU_REGISTERS_OFFSET+0x00000204,0xffffffff
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_52 IPU_REGISTERS_OFFSET+0x00000204,0x00100000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_51 IPU_REGISTERS_OFFSET+0x00000204,0x00080000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_50 IPU_REGISTERS_OFFSET+0x00000204,0x00040000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_49 IPU_REGISTERS_OFFSET+0x00000204,0x00020000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_48 IPU_REGISTERS_OFFSET+0x00000204,0x00010000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_47 IPU_REGISTERS_OFFSET+0x00000204,0x00008000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_46 IPU_REGISTERS_OFFSET+0x00000204,0x00004000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_45 IPU_REGISTERS_OFFSET+0x00000204,0x00002000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_44 IPU_REGISTERS_OFFSET+0x00000204,0x00001000
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_43 IPU_REGISTERS_OFFSET+0x00000204,0x00000800
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_42 IPU_REGISTERS_OFFSET+0x00000204,0x00000400
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_41 IPU_REGISTERS_OFFSET+0x00000204,0x00000200
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_40 IPU_REGISTERS_OFFSET+0x00000204,0x00000100
#define IPU_IPU_INT_STAT_2__IDMAC_EOF_33 IPU_REGISTERS_OFFSET+0x00000204,0x00000002

#define IPU_IPU_INT_STAT_3__ADDR           IPU_REGISTERS_OFFSET+0x00000208
#define IPU_IPU_INT_STAT_3__EMPTY          IPU_REGISTERS_OFFSET+0x00000208,0x00000000
#define IPU_IPU_INT_STAT_3__FULL           IPU_REGISTERS_OFFSET+0x00000208,0xffffffff
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_31 IPU_REGISTERS_OFFSET+0x00000208,0x80000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_29 IPU_REGISTERS_OFFSET+0x00000208,0x20000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_28 IPU_REGISTERS_OFFSET+0x00000208,0x10000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_27 IPU_REGISTERS_OFFSET+0x00000208,0x08000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_26 IPU_REGISTERS_OFFSET+0x00000208,0x04000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_25 IPU_REGISTERS_OFFSET+0x00000208,0x02000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_24 IPU_REGISTERS_OFFSET+0x00000208,0x01000000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_23 IPU_REGISTERS_OFFSET+0x00000208,0x00800000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_22 IPU_REGISTERS_OFFSET+0x00000208,0x00400000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_21 IPU_REGISTERS_OFFSET+0x00000208,0x00200000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_20 IPU_REGISTERS_OFFSET+0x00000208,0x00100000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_19 IPU_REGISTERS_OFFSET+0x00000208,0x00080000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_18 IPU_REGISTERS_OFFSET+0x00000208,0x00040000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_17 IPU_REGISTERS_OFFSET+0x00000208,0x00020000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_15 IPU_REGISTERS_OFFSET+0x00000208,0x00008000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_14 IPU_REGISTERS_OFFSET+0x00000208,0x00004000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_13 IPU_REGISTERS_OFFSET+0x00000208,0x00002000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_12 IPU_REGISTERS_OFFSET+0x00000208,0x00001000
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_11 IPU_REGISTERS_OFFSET+0x00000208,0x00000800
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_10 IPU_REGISTERS_OFFSET+0x00000208,0x00000400
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_9  IPU_REGISTERS_OFFSET+0x00000208,0x00000200
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_8  IPU_REGISTERS_OFFSET+0x00000208,0x00000100
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_5  IPU_REGISTERS_OFFSET+0x00000208,0x00000020
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_3  IPU_REGISTERS_OFFSET+0x00000208,0x00000008
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_2  IPU_REGISTERS_OFFSET+0x00000208,0x00000004
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_1  IPU_REGISTERS_OFFSET+0x00000208,0x00000002
#define IPU_IPU_INT_STAT_3__IDMAC_NFACK_0  IPU_REGISTERS_OFFSET+0x00000208,0x00000001

#define IPU_IPU_INT_STAT_4__ADDR           IPU_REGISTERS_OFFSET+0x0000020C
#define IPU_IPU_INT_STAT_4__EMPTY          IPU_REGISTERS_OFFSET+0x0000020C,0x00000000
#define IPU_IPU_INT_STAT_4__FULL           IPU_REGISTERS_OFFSET+0x0000020C,0xffffffff
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_52 IPU_REGISTERS_OFFSET+0x0000020C,0x00100000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_51 IPU_REGISTERS_OFFSET+0x0000020C,0x00080000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_50 IPU_REGISTERS_OFFSET+0x0000020C,0x00040000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_49 IPU_REGISTERS_OFFSET+0x0000020C,0x00020000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_48 IPU_REGISTERS_OFFSET+0x0000020C,0x00010000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_47 IPU_REGISTERS_OFFSET+0x0000020C,0x00008000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_46 IPU_REGISTERS_OFFSET+0x0000020C,0x00004000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_45 IPU_REGISTERS_OFFSET+0x0000020C,0x00002000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_44 IPU_REGISTERS_OFFSET+0x0000020C,0x00001000
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_43 IPU_REGISTERS_OFFSET+0x0000020C,0x00000800
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_42 IPU_REGISTERS_OFFSET+0x0000020C,0x00000400
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_41 IPU_REGISTERS_OFFSET+0x0000020C,0x00000200
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_40 IPU_REGISTERS_OFFSET+0x0000020C,0x00000100
#define IPU_IPU_INT_STAT_4__IDMAC_NFACK_33 IPU_REGISTERS_OFFSET+0x0000020C,0x00000002

#define IPU_IPU_INT_STAT_5__ADDR                 IPU_REGISTERS_OFFSET+0x00000210
#define IPU_IPU_INT_STAT_5__EMPTY                IPU_REGISTERS_OFFSET+0x00000210,0x00000000
#define IPU_IPU_INT_STAT_5__FULL                 IPU_REGISTERS_OFFSET+0x00000210,0xffffffff
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_31 IPU_REGISTERS_OFFSET+0x00000210,0x80000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_29 IPU_REGISTERS_OFFSET+0x00000210,0x20000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_28 IPU_REGISTERS_OFFSET+0x00000210,0x10000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_27 IPU_REGISTERS_OFFSET+0x00000210,0x08000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_26 IPU_REGISTERS_OFFSET+0x00000210,0x04000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_25 IPU_REGISTERS_OFFSET+0x00000210,0x02000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_24 IPU_REGISTERS_OFFSET+0x00000210,0x01000000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_23 IPU_REGISTERS_OFFSET+0x00000210,0x00800000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_22 IPU_REGISTERS_OFFSET+0x00000210,0x00400000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_21 IPU_REGISTERS_OFFSET+0x00000210,0x00200000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_20 IPU_REGISTERS_OFFSET+0x00000210,0x00100000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_19 IPU_REGISTERS_OFFSET+0x00000210,0x00080000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_18 IPU_REGISTERS_OFFSET+0x00000210,0x00040000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_17 IPU_REGISTERS_OFFSET+0x00000210,0x00020000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_15 IPU_REGISTERS_OFFSET+0x00000210,0x00008000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_14 IPU_REGISTERS_OFFSET+0x00000210,0x00004000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_13 IPU_REGISTERS_OFFSET+0x00000210,0x00002000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_12 IPU_REGISTERS_OFFSET+0x00000210,0x00001000
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_11 IPU_REGISTERS_OFFSET+0x00000210,0x00000800
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_10 IPU_REGISTERS_OFFSET+0x00000210,0x00000400
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_9  IPU_REGISTERS_OFFSET+0x00000210,0x00000200
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_8  IPU_REGISTERS_OFFSET+0x00000210,0x00000100
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_5  IPU_REGISTERS_OFFSET+0x00000210,0x00000020
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_3  IPU_REGISTERS_OFFSET+0x00000210,0x00000008
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_2  IPU_REGISTERS_OFFSET+0x00000210,0x00000004
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_1  IPU_REGISTERS_OFFSET+0x00000210,0x00000002
#define IPU_IPU_INT_STAT_5__IDMAC_NFB4EOF_ERR_0  IPU_REGISTERS_OFFSET+0x00000210,0x00000001

#define IPU_IPU_INT_STAT_6__ADDR                 IPU_REGISTERS_OFFSET+0x00000214
#define IPU_IPU_INT_STAT_6__EMPTY                IPU_REGISTERS_OFFSET+0x00000214,0x00000000
#define IPU_IPU_INT_STAT_6__FULL                 IPU_REGISTERS_OFFSET+0x00000214,0xffffffff
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_52 IPU_REGISTERS_OFFSET+0x00000214,0x00100000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_51 IPU_REGISTERS_OFFSET+0x00000214,0x00080000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_50 IPU_REGISTERS_OFFSET+0x00000214,0x00040000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_49 IPU_REGISTERS_OFFSET+0x00000214,0x00020000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_48 IPU_REGISTERS_OFFSET+0x00000214,0x00010000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_47 IPU_REGISTERS_OFFSET+0x00000214,0x00008000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_46 IPU_REGISTERS_OFFSET+0x00000214,0x00004000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_45 IPU_REGISTERS_OFFSET+0x00000214,0x00002000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_44 IPU_REGISTERS_OFFSET+0x00000214,0x00001000
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_43 IPU_REGISTERS_OFFSET+0x00000214,0x00000800
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_42 IPU_REGISTERS_OFFSET+0x00000214,0x00000400
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_41 IPU_REGISTERS_OFFSET+0x00000214,0x00000200
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_40 IPU_REGISTERS_OFFSET+0x00000214,0x00000100
#define IPU_IPU_INT_STAT_6__IDMAC_NFB4EOF_ERR_33 IPU_REGISTERS_OFFSET+0x00000214,0x00000002

#define IPU_IPU_INT_STAT_7__ADDR         IPU_REGISTERS_OFFSET+0x00000218
#define IPU_IPU_INT_STAT_7__EMPTY        IPU_REGISTERS_OFFSET+0x00000218,0x00000000
#define IPU_IPU_INT_STAT_7__FULL         IPU_REGISTERS_OFFSET+0x00000218,0xffffffff
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_31 IPU_REGISTERS_OFFSET+0x00000218,0x80000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_29 IPU_REGISTERS_OFFSET+0x00000218,0x20000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_28 IPU_REGISTERS_OFFSET+0x00000218,0x10000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_27 IPU_REGISTERS_OFFSET+0x00000218,0x08000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_26 IPU_REGISTERS_OFFSET+0x00000218,0x04000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_25 IPU_REGISTERS_OFFSET+0x00000218,0x02000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_24 IPU_REGISTERS_OFFSET+0x00000218,0x01000000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_23 IPU_REGISTERS_OFFSET+0x00000218,0x00800000
#define IPU_IPU_INT_STAT_7__IDMAC_EOS_19 IPU_REGISTERS_OFFSET+0x00000218,0x00080000

#define IPU_IPU_INT_STAT_8__ADDR         IPU_REGISTERS_OFFSET+0x0000021C
#define IPU_IPU_INT_STAT_8__EMPTY        IPU_REGISTERS_OFFSET+0x0000021C,0x00000000
#define IPU_IPU_INT_STAT_8__FULL         IPU_REGISTERS_OFFSET+0x0000021C,0xffffffff
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_52 IPU_REGISTERS_OFFSET+0x0000021C,0x00100000
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_51 IPU_REGISTERS_OFFSET+0x0000021C,0x00080000
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_44 IPU_REGISTERS_OFFSET+0x0000021C,0x00001000
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_43 IPU_REGISTERS_OFFSET+0x0000021C,0x00000800
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_42 IPU_REGISTERS_OFFSET+0x0000021C,0x00000400
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_41 IPU_REGISTERS_OFFSET+0x0000021C,0x00000200
#define IPU_IPU_INT_STAT_8__IDMAC_EOS_33 IPU_REGISTERS_OFFSET+0x0000021C,0x00000002

#define IPU_IPU_INT_STAT_9__ADDR             IPU_REGISTERS_OFFSET+0x00000220
#define IPU_IPU_INT_STAT_9__EMPTY            IPU_REGISTERS_OFFSET+0x00000220,0x00000000
#define IPU_IPU_INT_STAT_9__FULL             IPU_REGISTERS_OFFSET+0x00000220,0xffffffff
#define IPU_IPU_INT_STAT_9__CSI1_PUPE        IPU_REGISTERS_OFFSET+0x00000220,0x80000000
#define IPU_IPU_INT_STAT_9__CSI0_PUPE        IPU_REGISTERS_OFFSET+0x00000220,0x40000000
#define IPU_IPU_INT_STAT_9__IC_VF_BUF_OVF    IPU_REGISTERS_OFFSET+0x00000220,0x10000000
#define IPU_IPU_INT_STAT_9__IC_ENC_BUF_OVF   IPU_REGISTERS_OFFSET+0x00000220,0x08000000
#define IPU_IPU_INT_STAT_9__IC_BAYER_BUF_OVF IPU_REGISTERS_OFFSET+0x00000220,0x04000000
#define IPU_IPU_INT_STAT_9__VDI_FIFO1_OVF    IPU_REGISTERS_OFFSET+0x00000220,0x00000001

#define IPU_IPU_INT_STAT_10__ADDR                   IPU_REGISTERS_OFFSET+0x00000224
#define IPU_IPU_INT_STAT_10__EMPTY                  IPU_REGISTERS_OFFSET+0x00000224,0x00000000
#define IPU_IPU_INT_STAT_10__FULL                   IPU_REGISTERS_OFFSET+0x00000224,0xffffffff
#define IPU_IPU_INT_STAT_10__AXIR_ERR               IPU_REGISTERS_OFFSET+0x00000224,0x40000000
#define IPU_IPU_INT_STAT_10__AXIW_ERR               IPU_REGISTERS_OFFSET+0x00000224,0x20000000
#define IPU_IPU_INT_STAT_10__NON_PRIVILEGED_ACC_ERR IPU_REGISTERS_OFFSET+0x00000224,0x10000000
#define IPU_IPU_INT_STAT_10__IC_BAYER_FRM_LOST_ERR  IPU_REGISTERS_OFFSET+0x00000224,0x04000000
#define IPU_IPU_INT_STAT_10__IC_ENC_FRM_LOST_ERR    IPU_REGISTERS_OFFSET+0x00000224,0x02000000
#define IPU_IPU_INT_STAT_10__IC_VF_FRM_LOST_ERR     IPU_REGISTERS_OFFSET+0x00000224,0x01000000
#define IPU_IPU_INT_STAT_10__DI1_TIME_OUT_ERR       IPU_REGISTERS_OFFSET+0x00000224,0x00400000
#define IPU_IPU_INT_STAT_10__DI0_TIME_OUT_ERR       IPU_REGISTERS_OFFSET+0x00000224,0x00200000
#define IPU_IPU_INT_STAT_10__DI1_SYNC_DISP_ERR      IPU_REGISTERS_OFFSET+0x00000224,0x00100000
#define IPU_IPU_INT_STAT_10__DI0_SYNC_DISP_ERR      IPU_REGISTERS_OFFSET+0x00000224,0x00080000
#define IPU_IPU_INT_STAT_10__DC_TEARING_ERR_6       IPU_REGISTERS_OFFSET+0x00000224,0x00040000
#define IPU_IPU_INT_STAT_10__DC_TEARING_ERR_2       IPU_REGISTERS_OFFSET+0x00000224,0x00020000
#define IPU_IPU_INT_STAT_10__DC_TEARING_ERR_1       IPU_REGISTERS_OFFSET+0x00000224,0x00010000
#define IPU_IPU_INT_STAT_10__SMFC3_FRM_LOST         IPU_REGISTERS_OFFSET+0x00000224,0x00000008
#define IPU_IPU_INT_STAT_10__SMFC2_FRM_LOST         IPU_REGISTERS_OFFSET+0x00000224,0x00000004
#define IPU_IPU_INT_STAT_10__SMFC1_FRM_LOST         IPU_REGISTERS_OFFSET+0x00000224,0x00000002
#define IPU_IPU_INT_STAT_10__SMFC0_FRM_LOST         IPU_REGISTERS_OFFSET+0x00000224,0x00000001

#define IPU_IPU_INT_STAT_11__ADDR           IPU_REGISTERS_OFFSET+0x00000228
#define IPU_IPU_INT_STAT_11__EMPTY          IPU_REGISTERS_OFFSET+0x00000228,0x00000000
#define IPU_IPU_INT_STAT_11__FULL           IPU_REGISTERS_OFFSET+0x00000228,0xffffffff
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_26 IPU_REGISTERS_OFFSET+0x00000228,0x04000000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_25 IPU_REGISTERS_OFFSET+0x00000228,0x02000000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_22 IPU_REGISTERS_OFFSET+0x00000228,0x00400000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_21 IPU_REGISTERS_OFFSET+0x00000228,0x00200000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_20 IPU_REGISTERS_OFFSET+0x00000228,0x00100000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_12 IPU_REGISTERS_OFFSET+0x00000228,0x00001000
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_11 IPU_REGISTERS_OFFSET+0x00000228,0x00000800
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_10 IPU_REGISTERS_OFFSET+0x00000228,0x00000400
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_9  IPU_REGISTERS_OFFSET+0x00000228,0x00000200
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_8  IPU_REGISTERS_OFFSET+0x00000228,0x00000100
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_5  IPU_REGISTERS_OFFSET+0x00000228,0x00000020
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_3  IPU_REGISTERS_OFFSET+0x00000228,0x00000008
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_2  IPU_REGISTERS_OFFSET+0x00000228,0x00000004
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_1  IPU_REGISTERS_OFFSET+0x00000228,0x00000002
#define IPU_IPU_INT_STAT_11__IDMAC_EOBND_0  IPU_REGISTERS_OFFSET+0x00000228,0x00000001

#define IPU_IPU_INT_STAT_12__ADDR           IPU_REGISTERS_OFFSET+0x0000022C
#define IPU_IPU_INT_STAT_12__EMPTY          IPU_REGISTERS_OFFSET+0x0000022C,0x00000000
#define IPU_IPU_INT_STAT_12__FULL           IPU_REGISTERS_OFFSET+0x0000022C,0xffffffff
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_50 IPU_REGISTERS_OFFSET+0x0000022C,0x00040000
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_49 IPU_REGISTERS_OFFSET+0x0000022C,0x00020000
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_48 IPU_REGISTERS_OFFSET+0x0000022C,0x00010000
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_47 IPU_REGISTERS_OFFSET+0x0000022C,0x00008000
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_46 IPU_REGISTERS_OFFSET+0x0000022C,0x00004000
#define IPU_IPU_INT_STAT_12__IDMAC_EOBND_45 IPU_REGISTERS_OFFSET+0x0000022C,0x00002000

#define IPU_IPU_INT_STAT_13__ADDR        IPU_REGISTERS_OFFSET+0x00000230
#define IPU_IPU_INT_STAT_13__EMPTY       IPU_REGISTERS_OFFSET+0x00000230,0x00000000
#define IPU_IPU_INT_STAT_13__FULL        IPU_REGISTERS_OFFSET+0x00000230,0xffffffff
#define IPU_IPU_INT_STAT_13__IDMAC_TH_31 IPU_REGISTERS_OFFSET+0x00000230,0x80000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_29 IPU_REGISTERS_OFFSET+0x00000230,0x20000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_28 IPU_REGISTERS_OFFSET+0x00000230,0x10000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_27 IPU_REGISTERS_OFFSET+0x00000230,0x08000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_26 IPU_REGISTERS_OFFSET+0x00000230,0x04000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_25 IPU_REGISTERS_OFFSET+0x00000230,0x02000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_24 IPU_REGISTERS_OFFSET+0x00000230,0x01000000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_23 IPU_REGISTERS_OFFSET+0x00000230,0x00800000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_22 IPU_REGISTERS_OFFSET+0x00000230,0x00400000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_21 IPU_REGISTERS_OFFSET+0x00000230,0x00200000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_20 IPU_REGISTERS_OFFSET+0x00000230,0x00100000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_19 IPU_REGISTERS_OFFSET+0x00000230,0x00080000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_18 IPU_REGISTERS_OFFSET+0x00000230,0x00040000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_17 IPU_REGISTERS_OFFSET+0x00000230,0x00020000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_15 IPU_REGISTERS_OFFSET+0x00000230,0x00008000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_14 IPU_REGISTERS_OFFSET+0x00000230,0x00004000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_13 IPU_REGISTERS_OFFSET+0x00000230,0x00002000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_12 IPU_REGISTERS_OFFSET+0x00000230,0x00001000
#define IPU_IPU_INT_STAT_13__IDMAC_TH_11 IPU_REGISTERS_OFFSET+0x00000230,0x00000800
#define IPU_IPU_INT_STAT_13__IDMAC_TH_10 IPU_REGISTERS_OFFSET+0x00000230,0x00000400
#define IPU_IPU_INT_STAT_13__IDMAC_TH_9  IPU_REGISTERS_OFFSET+0x00000230,0x00000200
#define IPU_IPU_INT_STAT_13__IDMAC_TH_8  IPU_REGISTERS_OFFSET+0x00000230,0x00000100
#define IPU_IPU_INT_STAT_13__IDMAC_TH_5  IPU_REGISTERS_OFFSET+0x00000230,0x00000020
#define IPU_IPU_INT_STAT_13__IDMAC_TH_3  IPU_REGISTERS_OFFSET+0x00000230,0x00000008
#define IPU_IPU_INT_STAT_13__IDMAC_TH_2  IPU_REGISTERS_OFFSET+0x00000230,0x00000004
#define IPU_IPU_INT_STAT_13__IDMAC_TH_1  IPU_REGISTERS_OFFSET+0x00000230,0x00000002
#define IPU_IPU_INT_STAT_13__IDMAC_TH_0  IPU_REGISTERS_OFFSET+0x00000230,0x00000001

#define IPU_IPU_INT_STAT_14__ADDR        IPU_REGISTERS_OFFSET+0x00000234
#define IPU_IPU_INT_STAT_14__EMPTY       IPU_REGISTERS_OFFSET+0x00000234,0x00000000
#define IPU_IPU_INT_STAT_14__FULL        IPU_REGISTERS_OFFSET+0x00000234,0xffffffff
#define IPU_IPU_INT_STAT_14__IDMAC_TH_52 IPU_REGISTERS_OFFSET+0x00000234,0x00100000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_51 IPU_REGISTERS_OFFSET+0x00000234,0x00080000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_50 IPU_REGISTERS_OFFSET+0x00000234,0x00040000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_49 IPU_REGISTERS_OFFSET+0x00000234,0x00020000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_48 IPU_REGISTERS_OFFSET+0x00000234,0x00010000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_47 IPU_REGISTERS_OFFSET+0x00000234,0x00008000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_46 IPU_REGISTERS_OFFSET+0x00000234,0x00004000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_45 IPU_REGISTERS_OFFSET+0x00000234,0x00002000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_44 IPU_REGISTERS_OFFSET+0x00000234,0x00001000
#define IPU_IPU_INT_STAT_14__IDMAC_TH_43 IPU_REGISTERS_OFFSET+0x00000234,0x00000800
#define IPU_IPU_INT_STAT_14__IDMAC_TH_42 IPU_REGISTERS_OFFSET+0x00000234,0x00000400
#define IPU_IPU_INT_STAT_14__IDMAC_TH_41 IPU_REGISTERS_OFFSET+0x00000234,0x00000200
#define IPU_IPU_INT_STAT_14__IDMAC_TH_40 IPU_REGISTERS_OFFSET+0x00000234,0x00000100
#define IPU_IPU_INT_STAT_14__IDMAC_TH_33 IPU_REGISTERS_OFFSET+0x00000234,0x00000002

#define IPU_IPU_INT_STAT_15__ADDR                IPU_REGISTERS_OFFSET+0x00000238
#define IPU_IPU_INT_STAT_15__EMPTY               IPU_REGISTERS_OFFSET+0x00000238,0x00000000
#define IPU_IPU_INT_STAT_15__FULL                IPU_REGISTERS_OFFSET+0x00000238,0xffffffff
#define IPU_IPU_INT_STAT_15__DI1_CNT_EN_PRE_8    IPU_REGISTERS_OFFSET+0x00000238,0x80000000
#define IPU_IPU_INT_STAT_15__DI1_CNT_EN_PRE_3    IPU_REGISTERS_OFFSET+0x00000238,0x40000000
#define IPU_IPU_INT_STAT_15__DI1_DISP_CLK_EN_PRE IPU_REGISTERS_OFFSET+0x00000238,0x20000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_10   IPU_REGISTERS_OFFSET+0x00000238,0x10000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_9    IPU_REGISTERS_OFFSET+0x00000238,0x08000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_8    IPU_REGISTERS_OFFSET+0x00000238,0x04000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_7    IPU_REGISTERS_OFFSET+0x00000238,0x02000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_6    IPU_REGISTERS_OFFSET+0x00000238,0x01000000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_5    IPU_REGISTERS_OFFSET+0x00000238,0x00800000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_4    IPU_REGISTERS_OFFSET+0x00000238,0x00400000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_3    IPU_REGISTERS_OFFSET+0x00000238,0x00200000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_2    IPU_REGISTERS_OFFSET+0x00000238,0x00100000
#define IPU_IPU_INT_STAT_15__DI0_CNT_EN_PRE_1    IPU_REGISTERS_OFFSET+0x00000238,0x00080000
#define IPU_IPU_INT_STAT_15__DI0_DISP_CLK_EN_PRE IPU_REGISTERS_OFFSET+0x00000238,0x00040000
#define IPU_IPU_INT_STAT_15__DC_ASYNC_STOP       IPU_REGISTERS_OFFSET+0x00000238,0x00020000
#define IPU_IPU_INT_STAT_15__DC_DP_START         IPU_REGISTERS_OFFSET+0x00000238,0x00010000
#define IPU_IPU_INT_STAT_15__DI_VSYNC_PRE_1      IPU_REGISTERS_OFFSET+0x00000238,0x00008000
#define IPU_IPU_INT_STAT_15__DI_VSYNC_PRE_0      IPU_REGISTERS_OFFSET+0x00000238,0x00004000
#define IPU_IPU_INT_STAT_15__DC_FC_6             IPU_REGISTERS_OFFSET+0x00000238,0x00002000
#define IPU_IPU_INT_STAT_15__DC_FC_4             IPU_REGISTERS_OFFSET+0x00000238,0x00001000
#define IPU_IPU_INT_STAT_15__DC_FC_3             IPU_REGISTERS_OFFSET+0x00000238,0x00000800
#define IPU_IPU_INT_STAT_15__DC_FC_2             IPU_REGISTERS_OFFSET+0x00000238,0x00000400
#define IPU_IPU_INT_STAT_15__DC_FC_1             IPU_REGISTERS_OFFSET+0x00000238,0x00000200
#define IPU_IPU_INT_STAT_15__DC_FC_0             IPU_REGISTERS_OFFSET+0x00000238,0x00000100
#define IPU_IPU_INT_STAT_15__DP_ASF_BRAKE        IPU_REGISTERS_OFFSET+0x00000238,0x00000080
#define IPU_IPU_INT_STAT_15__DP_SF_BRAKE         IPU_REGISTERS_OFFSET+0x00000238,0x00000040
#define IPU_IPU_INT_STAT_15__DP_ASF_END          IPU_REGISTERS_OFFSET+0x00000238,0x00000020
#define IPU_IPU_INT_STAT_15__DP_ASF_START        IPU_REGISTERS_OFFSET+0x00000238,0x00000010
#define IPU_IPU_INT_STAT_15__DP_SF_END           IPU_REGISTERS_OFFSET+0x00000238,0x00000008
#define IPU_IPU_INT_STAT_15__DP_SF_START         IPU_REGISTERS_OFFSET+0x00000238,0x00000004
#define IPU_IPU_INT_STAT_15__IPU_SNOOPING2_INT   IPU_REGISTERS_OFFSET+0x00000238,0x00000002
#define IPU_IPU_INT_STAT_15__IPU_SNOOPING1_INT   IPU_REGISTERS_OFFSET+0x00000238,0x00000001

#define IPU_IPU_CUR_BUF_0__ADDR              IPU_REGISTERS_OFFSET+0x0000023C
#define IPU_IPU_CUR_BUF_0__EMPTY             IPU_REGISTERS_OFFSET+0x0000023C,0x00000000
#define IPU_IPU_CUR_BUF_0__FULL              IPU_REGISTERS_OFFSET+0x0000023C,0xffffffff
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_31 IPU_REGISTERS_OFFSET+0x0000023C,0x80000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_29 IPU_REGISTERS_OFFSET+0x0000023C,0x20000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_28 IPU_REGISTERS_OFFSET+0x0000023C,0x10000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_27 IPU_REGISTERS_OFFSET+0x0000023C,0x08000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_26 IPU_REGISTERS_OFFSET+0x0000023C,0x04000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_25 IPU_REGISTERS_OFFSET+0x0000023C,0x02000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_24 IPU_REGISTERS_OFFSET+0x0000023C,0x01000000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_23 IPU_REGISTERS_OFFSET+0x0000023C,0x00800000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_22 IPU_REGISTERS_OFFSET+0x0000023C,0x00400000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_21 IPU_REGISTERS_OFFSET+0x0000023C,0x00200000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_20 IPU_REGISTERS_OFFSET+0x0000023C,0x00100000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_19 IPU_REGISTERS_OFFSET+0x0000023C,0x00080000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_18 IPU_REGISTERS_OFFSET+0x0000023C,0x00040000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_17 IPU_REGISTERS_OFFSET+0x0000023C,0x00020000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_15 IPU_REGISTERS_OFFSET+0x0000023C,0x00008000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_14 IPU_REGISTERS_OFFSET+0x0000023C,0x00004000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_12 IPU_REGISTERS_OFFSET+0x0000023C,0x00001000
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_11 IPU_REGISTERS_OFFSET+0x0000023C,0x00000800
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_10 IPU_REGISTERS_OFFSET+0x0000023C,0x00000400
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_9  IPU_REGISTERS_OFFSET+0x0000023C,0x00000200
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_8  IPU_REGISTERS_OFFSET+0x0000023C,0x00000100
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_5  IPU_REGISTERS_OFFSET+0x0000023C,0x00000020
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_3  IPU_REGISTERS_OFFSET+0x0000023C,0x00000008
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_2  IPU_REGISTERS_OFFSET+0x0000023C,0x00000004
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_1  IPU_REGISTERS_OFFSET+0x0000023C,0x00000002
#define IPU_IPU_CUR_BUF_0__DMA_CH_CUR_BUF_0  IPU_REGISTERS_OFFSET+0x0000023C,0x00000001

#define IPU_IPU_CUR_BUF_1__ADDR              IPU_REGISTERS_OFFSET+0x00000240
#define IPU_IPU_CUR_BUF_1__EMPTY             IPU_REGISTERS_OFFSET+0x00000240,0x00000000
#define IPU_IPU_CUR_BUF_1__FULL              IPU_REGISTERS_OFFSET+0x00000240,0xffffffff
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_52 IPU_REGISTERS_OFFSET+0x00000240,0x00100000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_51 IPU_REGISTERS_OFFSET+0x00000240,0x00080000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_50 IPU_REGISTERS_OFFSET+0x00000240,0x00040000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_49 IPU_REGISTERS_OFFSET+0x00000240,0x00020000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_48 IPU_REGISTERS_OFFSET+0x00000240,0x00010000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_47 IPU_REGISTERS_OFFSET+0x00000240,0x00008000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_46 IPU_REGISTERS_OFFSET+0x00000240,0x00004000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_45 IPU_REGISTERS_OFFSET+0x00000240,0x00002000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_44 IPU_REGISTERS_OFFSET+0x00000240,0x00001000
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_43 IPU_REGISTERS_OFFSET+0x00000240,0x00000800
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_42 IPU_REGISTERS_OFFSET+0x00000240,0x00000400
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_41 IPU_REGISTERS_OFFSET+0x00000240,0x00000200
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_40 IPU_REGISTERS_OFFSET+0x00000240,0x00000100
#define IPU_IPU_CUR_BUF_1__DMA_CH_CUR_BUF_33 IPU_REGISTERS_OFFSET+0x00000240,0x00000002

#define IPU_IPU_ALT_CUR_BUF_0__ADDR                  IPU_REGISTERS_OFFSET+0x00000244
#define IPU_IPU_ALT_CUR_BUF_0__EMPTY                 IPU_REGISTERS_OFFSET+0x00000244,0x00000000
#define IPU_IPU_ALT_CUR_BUF_0__FULL                  IPU_REGISTERS_OFFSET+0x00000244,0xffffffff
#define IPU_IPU_ALT_CUR_BUF_0__DMA_CH_ALT_CUR_BUF_29 IPU_REGISTERS_OFFSET+0x00000244,0x20000000
#define IPU_IPU_ALT_CUR_BUF_0__DMA_CH_ALT_CUR_BUF_24 IPU_REGISTERS_OFFSET+0x00000244,0x01000000

#define IPU_IPU_ALT_CUR_BUF_1__ADDR                  IPU_REGISTERS_OFFSET+0x00000248
#define IPU_IPU_ALT_CUR_BUF_1__EMPTY                 IPU_REGISTERS_OFFSET+0x00000248,0x00000000
#define IPU_IPU_ALT_CUR_BUF_1__FULL                  IPU_REGISTERS_OFFSET+0x00000248,0xffffffff
#define IPU_IPU_ALT_CUR_BUF_1__DMA_CH_ALT_CUR_BUF_52 IPU_REGISTERS_OFFSET+0x00000248,0x00100000
#define IPU_IPU_ALT_CUR_BUF_1__DMA_CH_ALT_CUR_BUF_41 IPU_REGISTERS_OFFSET+0x00000248,0x00000200
#define IPU_IPU_ALT_CUR_BUF_1__DMA_CH_ALT_CUR_BUF_33 IPU_REGISTERS_OFFSET+0x00000248,0x00000002

#define IPU_IPU_SRM_STAT__ADDR           IPU_REGISTERS_OFFSET+0x0000024C
#define IPU_IPU_SRM_STAT__EMPTY          IPU_REGISTERS_OFFSET+0x0000024C,0x00000000
#define IPU_IPU_SRM_STAT__FULL           IPU_REGISTERS_OFFSET+0x0000024C,0xffffffff
#define IPU_IPU_SRM_STAT__DI1_SRM_STAT   IPU_REGISTERS_OFFSET+0x0000024C,0x00000200
#define IPU_IPU_SRM_STAT__DI0_SRM_STAT   IPU_REGISTERS_OFFSET+0x0000024C,0x00000100
#define IPU_IPU_SRM_STAT__CSI1_SRM_STAT  IPU_REGISTERS_OFFSET+0x0000024C,0x00000080
#define IPU_IPU_SRM_STAT__CSI0_SRM_STAT  IPU_REGISTERS_OFFSET+0x0000024C,0x00000040
#define IPU_IPU_SRM_STAT__DC_6_SRM_STAT  IPU_REGISTERS_OFFSET+0x0000024C,0x00000020
#define IPU_IPU_SRM_STAT__DC_2_SRM_STAT  IPU_REGISTERS_OFFSET+0x0000024C,0x00000010
#define IPU_IPU_SRM_STAT__DP_A1_SRM_STAT IPU_REGISTERS_OFFSET+0x0000024C,0x00000004
#define IPU_IPU_SRM_STAT__DP_A0_SRM_STAT IPU_REGISTERS_OFFSET+0x0000024C,0x00000002
#define IPU_IPU_SRM_STAT__DP_S_SRM_STAT  IPU_REGISTERS_OFFSET+0x0000024C,0x00000001

#define IPU_IPU_PROC_TASKS_STAT__ADDR                IPU_REGISTERS_OFFSET+0x00000250
#define IPU_IPU_PROC_TASKS_STAT__EMPTY               IPU_REGISTERS_OFFSET+0x00000250,0x00000000
#define IPU_IPU_PROC_TASKS_STAT__FULL                IPU_REGISTERS_OFFSET+0x00000250,0xffffffff
#define IPU_IPU_PROC_TASKS_STAT__CSI2MEM_SMFC3_TSTAT IPU_REGISTERS_OFFSET+0x00000250,0x00C00000
#define IPU_IPU_PROC_TASKS_STAT__CSI2MEM_SMFC2_TSTAT IPU_REGISTERS_OFFSET+0x00000250,0x00300000
#define IPU_IPU_PROC_TASKS_STAT__CSI2MEM_SMFC1_TSTAT IPU_REGISTERS_OFFSET+0x00000250,0x000C0000
#define IPU_IPU_PROC_TASKS_STAT__CSI2MEM_SMFC0_TSTAT IPU_REGISTERS_OFFSET+0x00000250,0x00030000
#define IPU_IPU_PROC_TASKS_STAT__MEM2PRP_TSTAT       IPU_REGISTERS_OFFSET+0x00000250,0x00007000
#define IPU_IPU_PROC_TASKS_STAT__PP_ROT_TSTAT        IPU_REGISTERS_OFFSET+0x00000250,0x00000C00
#define IPU_IPU_PROC_TASKS_STAT__VF_ROT_TSTAT        IPU_REGISTERS_OFFSET+0x00000250,0x00000300
#define IPU_IPU_PROC_TASKS_STAT__ENC_ROT_TSTAT       IPU_REGISTERS_OFFSET+0x00000250,0x000000C0
#define IPU_IPU_PROC_TASKS_STAT__PP_TSTAT            IPU_REGISTERS_OFFSET+0x00000250,0x00000030
#define IPU_IPU_PROC_TASKS_STAT__VF_TSTAT            IPU_REGISTERS_OFFSET+0x00000250,0x0000000C
#define IPU_IPU_PROC_TASKS_STAT__ENC_TSTAT           IPU_REGISTERS_OFFSET+0x00000250,0x00000003

#define IPU_IPU_DISP_TASKS_STAT__ADDR               IPU_REGISTERS_OFFSET+0x00000254
#define IPU_IPU_DISP_TASKS_STAT__EMPTY              IPU_REGISTERS_OFFSET+0x00000254,0x00000000
#define IPU_IPU_DISP_TASKS_STAT__FULL               IPU_REGISTERS_OFFSET+0x00000254,0xffffffff
#define IPU_IPU_DISP_TASKS_STAT__DC_ASYNC2_CUR_FLOW IPU_REGISTERS_OFFSET+0x00000254,0x00000800
#define IPU_IPU_DISP_TASKS_STAT__DC_ASYNC2_STAT     IPU_REGISTERS_OFFSET+0x00000254,0x00000700
#define IPU_IPU_DISP_TASKS_STAT__DC_ASYNC1_STAT     IPU_REGISTERS_OFFSET+0x00000254,0x00000030
#define IPU_IPU_DISP_TASKS_STAT__DP_ASYNC_CUR_FLOW  IPU_REGISTERS_OFFSET+0x00000254,0x00000008
#define IPU_IPU_DISP_TASKS_STAT__DP_ASYNC_STAT      IPU_REGISTERS_OFFSET+0x00000254,0x00000007

#define IPU_IPU_TRIPLE_CUR_BUF_0__ADDR                     IPU_REGISTERS_OFFSET+0x00000258
#define IPU_IPU_TRIPLE_CUR_BUF_0__EMPTY                    IPU_REGISTERS_OFFSET+0x00000258,0x00000000
#define IPU_IPU_TRIPLE_CUR_BUF_0__FULL                     IPU_REGISTERS_OFFSET+0x00000258,0xffffffff
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_13 IPU_REGISTERS_OFFSET+0x00000258,0x0C000000
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_10 IPU_REGISTERS_OFFSET+0x00000258,0x00300000
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_9  IPU_REGISTERS_OFFSET+0x00000258,0x000C0000
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_8  IPU_REGISTERS_OFFSET+0x00000258,0x00030000
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_2  IPU_REGISTERS_OFFSET+0x00000258,0x00000030
#define IPU_IPU_TRIPLE_CUR_BUF_0__DMA_CH_TRIPLE_CUR_BUF_0  IPU_REGISTERS_OFFSET+0x00000258,0x00000003

#define IPU_IPU_TRIPLE_CUR_BUF_1__ADDR                     IPU_REGISTERS_OFFSET+0x0000025C
#define IPU_IPU_TRIPLE_CUR_BUF_1__EMPTY                    IPU_REGISTERS_OFFSET+0x0000025C,0x00000000
#define IPU_IPU_TRIPLE_CUR_BUF_1__FULL                     IPU_REGISTERS_OFFSET+0x0000025C,0xffffffff
#define IPU_IPU_TRIPLE_CUR_BUF_1__DMA_CH_TRIPLE_CUR_BUF_28 IPU_REGISTERS_OFFSET+0x0000025C,0x03000000
#define IPU_IPU_TRIPLE_CUR_BUF_1__DMA_CH_TRIPLE_CUR_BUF_27 IPU_REGISTERS_OFFSET+0x0000025C,0x00C00000
#define IPU_IPU_TRIPLE_CUR_BUF_1__DMA_CH_TRIPLE_CUR_BUF_23 IPU_REGISTERS_OFFSET+0x0000025C,0x0000C000
#define IPU_IPU_TRIPLE_CUR_BUF_1__DMA_CH_TRIPLE_CUR_BUF_21 IPU_REGISTERS_OFFSET+0x0000025C,0x00000C00

#define IPU_IPU_TRIPLE_CUR_BUF_2__ADDR  IPU_REGISTERS_OFFSET+0x00000260
#define IPU_IPU_TRIPLE_CUR_BUF_2__EMPTY IPU_REGISTERS_OFFSET+0x00000260,0x00000000
#define IPU_IPU_TRIPLE_CUR_BUF_2__FULL  IPU_REGISTERS_OFFSET+0x00000260,0xffffffff

#define IPU_IPU_TRIPLE_CUR_BUF_3__ADDR  IPU_REGISTERS_OFFSET+0x00000264
#define IPU_IPU_TRIPLE_CUR_BUF_3__EMPTY IPU_REGISTERS_OFFSET+0x00000264,0x00000000
#define IPU_IPU_TRIPLE_CUR_BUF_3__FULL  IPU_REGISTERS_OFFSET+0x00000264,0xffffffff

#define IPU_IPU_CH_BUF0_RDY0__ADDR               IPU_REGISTERS_OFFSET+0x00000268
#define IPU_IPU_CH_BUF0_RDY0__EMPTY              IPU_REGISTERS_OFFSET+0x00000268,0x00000000
#define IPU_IPU_CH_BUF0_RDY0__FULL               IPU_REGISTERS_OFFSET+0x00000268,0xffffffff
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_31 IPU_REGISTERS_OFFSET+0x00000268,0x80000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_29 IPU_REGISTERS_OFFSET+0x00000268,0x20000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_28 IPU_REGISTERS_OFFSET+0x00000268,0x10000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_27 IPU_REGISTERS_OFFSET+0x00000268,0x08000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_26 IPU_REGISTERS_OFFSET+0x00000268,0x04000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_25 IPU_REGISTERS_OFFSET+0x00000268,0x02000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_24 IPU_REGISTERS_OFFSET+0x00000268,0x01000000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_23 IPU_REGISTERS_OFFSET+0x00000268,0x00800000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_22 IPU_REGISTERS_OFFSET+0x00000268,0x00400000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_21 IPU_REGISTERS_OFFSET+0x00000268,0x00200000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_20 IPU_REGISTERS_OFFSET+0x00000268,0x00100000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_19 IPU_REGISTERS_OFFSET+0x00000268,0x00080000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_18 IPU_REGISTERS_OFFSET+0x00000268,0x00040000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_17 IPU_REGISTERS_OFFSET+0x00000268,0x00020000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_15 IPU_REGISTERS_OFFSET+0x00000268,0x00008000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_14 IPU_REGISTERS_OFFSET+0x00000268,0x00004000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_13 IPU_REGISTERS_OFFSET+0x00000268,0x00002000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_12 IPU_REGISTERS_OFFSET+0x00000268,0x00001000
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_11 IPU_REGISTERS_OFFSET+0x00000268,0x00000800
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_10 IPU_REGISTERS_OFFSET+0x00000268,0x00000400
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_9  IPU_REGISTERS_OFFSET+0x00000268,0x00000200
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_8  IPU_REGISTERS_OFFSET+0x00000268,0x00000100
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_5  IPU_REGISTERS_OFFSET+0x00000268,0x00000020
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_3  IPU_REGISTERS_OFFSET+0x00000268,0x00000008
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_2  IPU_REGISTERS_OFFSET+0x00000268,0x00000004
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_1  IPU_REGISTERS_OFFSET+0x00000268,0x00000002
#define IPU_IPU_CH_BUF0_RDY0__DMA_CH_BUF0_RDY_0  IPU_REGISTERS_OFFSET+0x00000268,0x00000001

#define IPU_IPU_CH_BUF0_RDY1__ADDR               IPU_REGISTERS_OFFSET+0x0000026C
#define IPU_IPU_CH_BUF0_RDY1__EMPTY              IPU_REGISTERS_OFFSET+0x0000026C,0x00000000
#define IPU_IPU_CH_BUF0_RDY1__FULL               IPU_REGISTERS_OFFSET+0x0000026C,0xffffffff
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_52 IPU_REGISTERS_OFFSET+0x0000026C,0x00100000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_51 IPU_REGISTERS_OFFSET+0x0000026C,0x00080000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_50 IPU_REGISTERS_OFFSET+0x0000026C,0x00040000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_49 IPU_REGISTERS_OFFSET+0x0000026C,0x00020000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_48 IPU_REGISTERS_OFFSET+0x0000026C,0x00010000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_47 IPU_REGISTERS_OFFSET+0x0000026C,0x00008000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_46 IPU_REGISTERS_OFFSET+0x0000026C,0x00004000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_45 IPU_REGISTERS_OFFSET+0x0000026C,0x00002000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_44 IPU_REGISTERS_OFFSET+0x0000026C,0x00001000
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_43 IPU_REGISTERS_OFFSET+0x0000026C,0x00000800
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_42 IPU_REGISTERS_OFFSET+0x0000026C,0x00000400
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_41 IPU_REGISTERS_OFFSET+0x0000026C,0x00000200
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_40 IPU_REGISTERS_OFFSET+0x0000026C,0x00000100
#define IPU_IPU_CH_BUF0_RDY1__DMA_CH_BUF0_RDY_33 IPU_REGISTERS_OFFSET+0x0000026C,0x00000002

#define IPU_IPU_CH_BUF1_RDY0__ADDR               IPU_REGISTERS_OFFSET+0x00000270
#define IPU_IPU_CH_BUF1_RDY0__EMPTY              IPU_REGISTERS_OFFSET+0x00000270,0x00000000
#define IPU_IPU_CH_BUF1_RDY0__FULL               IPU_REGISTERS_OFFSET+0x00000270,0xffffffff
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_31 IPU_REGISTERS_OFFSET+0x00000270,0x80000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_29 IPU_REGISTERS_OFFSET+0x00000270,0x20000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_28 IPU_REGISTERS_OFFSET+0x00000270,0x10000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_27 IPU_REGISTERS_OFFSET+0x00000270,0x08000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_26 IPU_REGISTERS_OFFSET+0x00000270,0x04000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_25 IPU_REGISTERS_OFFSET+0x00000270,0x02000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_24 IPU_REGISTERS_OFFSET+0x00000270,0x01000000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_23 IPU_REGISTERS_OFFSET+0x00000270,0x00800000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_22 IPU_REGISTERS_OFFSET+0x00000270,0x00400000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_21 IPU_REGISTERS_OFFSET+0x00000270,0x00200000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_20 IPU_REGISTERS_OFFSET+0x00000270,0x00100000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_19 IPU_REGISTERS_OFFSET+0x00000270,0x00080000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_18 IPU_REGISTERS_OFFSET+0x00000270,0x00040000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_17 IPU_REGISTERS_OFFSET+0x00000270,0x00020000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_15 IPU_REGISTERS_OFFSET+0x00000270,0x00008000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_14 IPU_REGISTERS_OFFSET+0x00000270,0x00004000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_13 IPU_REGISTERS_OFFSET+0x00000270,0x00002000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_12 IPU_REGISTERS_OFFSET+0x00000270,0x00001000
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_11 IPU_REGISTERS_OFFSET+0x00000270,0x00000800
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_10 IPU_REGISTERS_OFFSET+0x00000270,0x00000400
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_9  IPU_REGISTERS_OFFSET+0x00000270,0x00000200
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_8  IPU_REGISTERS_OFFSET+0x00000270,0x00000100
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_5  IPU_REGISTERS_OFFSET+0x00000270,0x00000020
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_3  IPU_REGISTERS_OFFSET+0x00000270,0x00000008
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_2  IPU_REGISTERS_OFFSET+0x00000270,0x00000004
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_1  IPU_REGISTERS_OFFSET+0x00000270,0x00000002
#define IPU_IPU_CH_BUF1_RDY0__DMA_CH_BUF1_RDY_0  IPU_REGISTERS_OFFSET+0x00000270,0x00000001

#define IPU_IPU_CH_BUF1_RDY1__ADDR               IPU_REGISTERS_OFFSET+0x00000274
#define IPU_IPU_CH_BUF1_RDY1__EMPTY              IPU_REGISTERS_OFFSET+0x00000274,0x00000000
#define IPU_IPU_CH_BUF1_RDY1__FULL               IPU_REGISTERS_OFFSET+0x00000274,0xffffffff
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_52 IPU_REGISTERS_OFFSET+0x00000274,0x00100000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_51 IPU_REGISTERS_OFFSET+0x00000274,0x00080000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_50 IPU_REGISTERS_OFFSET+0x00000274,0x00040000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_49 IPU_REGISTERS_OFFSET+0x00000274,0x00020000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_48 IPU_REGISTERS_OFFSET+0x00000274,0x00010000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_47 IPU_REGISTERS_OFFSET+0x00000274,0x00008000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_46 IPU_REGISTERS_OFFSET+0x00000274,0x00004000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_45 IPU_REGISTERS_OFFSET+0x00000274,0x00002000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_44 IPU_REGISTERS_OFFSET+0x00000274,0x00001000
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_43 IPU_REGISTERS_OFFSET+0x00000274,0x00000800
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_42 IPU_REGISTERS_OFFSET+0x00000274,0x00000400
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_41 IPU_REGISTERS_OFFSET+0x00000274,0x00000200
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_40 IPU_REGISTERS_OFFSET+0x00000274,0x00000100
#define IPU_IPU_CH_BUF1_RDY1__DMA_CH_BUF1_RDY_33 IPU_REGISTERS_OFFSET+0x00000274,0x00000002

#define IPU_IPU_ALT_CH_BUF0_RDY0__ADDR                   IPU_REGISTERS_OFFSET+0x00000278
#define IPU_IPU_ALT_CH_BUF0_RDY0__EMPTY                  IPU_REGISTERS_OFFSET+0x00000278,0x00000000
#define IPU_IPU_ALT_CH_BUF0_RDY0__FULL                   IPU_REGISTERS_OFFSET+0x00000278,0xffffffff
#define IPU_IPU_ALT_CH_BUF0_RDY0__DMA_CH_ALT_BUF0_RDY_29 IPU_REGISTERS_OFFSET+0x00000278,0x20000000
#define IPU_IPU_ALT_CH_BUF0_RDY0__DMA_CH_ALT_BUF0_RDY_24 IPU_REGISTERS_OFFSET+0x00000278,0x01000000

#define IPU_IPU_ALT_CH_BUF0_RDY1__ADDR                   IPU_REGISTERS_OFFSET+0x0000027C
#define IPU_IPU_ALT_CH_BUF0_RDY1__EMPTY                  IPU_REGISTERS_OFFSET+0x0000027C,0x00000000
#define IPU_IPU_ALT_CH_BUF0_RDY1__FULL                   IPU_REGISTERS_OFFSET+0x0000027C,0xffffffff
#define IPU_IPU_ALT_CH_BUF0_RDY1__DMA_CH_ALT_BUF0_RDY_52 IPU_REGISTERS_OFFSET+0x0000027C,0x00100000
#define IPU_IPU_ALT_CH_BUF0_RDY1__DMA_CH_ALT_BUF0_RDY_41 IPU_REGISTERS_OFFSET+0x0000027C,0x00000200
#define IPU_IPU_ALT_CH_BUF0_RDY1__DMA_CH_ALT_BUF0_RDY_33 IPU_REGISTERS_OFFSET+0x0000027C,0x00000002

#define IPU_IPU_ALT_CH_BUF1_RDY0__ADDR                   IPU_REGISTERS_OFFSET+0x00000280
#define IPU_IPU_ALT_CH_BUF1_RDY0__EMPTY                  IPU_REGISTERS_OFFSET+0x00000280,0x00000000
#define IPU_IPU_ALT_CH_BUF1_RDY0__FULL                   IPU_REGISTERS_OFFSET+0x00000280,0xffffffff
#define IPU_IPU_ALT_CH_BUF1_RDY0__DMA_CH_ALT_BUF1_RDY_29 IPU_REGISTERS_OFFSET+0x00000280,0x20000000
#define IPU_IPU_ALT_CH_BUF1_RDY0__DMA_CH_ALT_BUF1_RDY_24 IPU_REGISTERS_OFFSET+0x00000280,0x01000000

#define IPU_IPU_ALT_CH_BUF1_RDY1__ADDR                   IPU_REGISTERS_OFFSET+0x00000284
#define IPU_IPU_ALT_CH_BUF1_RDY1__EMPTY                  IPU_REGISTERS_OFFSET+0x00000284,0x00000000
#define IPU_IPU_ALT_CH_BUF1_RDY1__FULL                   IPU_REGISTERS_OFFSET+0x00000284,0xffffffff
#define IPU_IPU_ALT_CH_BUF1_RDY1__DMA_CH_ALT_BUF1_RDY_52 IPU_REGISTERS_OFFSET+0x00000284,0x00100000
#define IPU_IPU_ALT_CH_BUF1_RDY1__DMA_CH_ALT_BUF1_RDY_41 IPU_REGISTERS_OFFSET+0x00000284,0x00000200
#define IPU_IPU_ALT_CH_BUF1_RDY1__DMA_CH_ALT_BUF1_RDY_33 IPU_REGISTERS_OFFSET+0x00000284,0x00000002

#define IPU_IPU_CH_BUF2_RDY0__ADDR               IPU_REGISTERS_OFFSET+0x00000288
#define IPU_IPU_CH_BUF2_RDY0__EMPTY              IPU_REGISTERS_OFFSET+0x00000288,0x00000000
#define IPU_IPU_CH_BUF2_RDY0__FULL               IPU_REGISTERS_OFFSET+0x00000288,0xffffffff
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_28 IPU_REGISTERS_OFFSET+0x00000288,0x10000000
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_27 IPU_REGISTERS_OFFSET+0x00000288,0x08000000
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_23 IPU_REGISTERS_OFFSET+0x00000288,0x00800000
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_21 IPU_REGISTERS_OFFSET+0x00000288,0x00200000
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_13 IPU_REGISTERS_OFFSET+0x00000288,0x00002000
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_10 IPU_REGISTERS_OFFSET+0x00000288,0x00000400
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_9  IPU_REGISTERS_OFFSET+0x00000288,0x00000200
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_8  IPU_REGISTERS_OFFSET+0x00000288,0x00000100
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_2  IPU_REGISTERS_OFFSET+0x00000288,0x00000004
#define IPU_IPU_CH_BUF2_RDY0__DMA_CH_BUF2_RDY_0  IPU_REGISTERS_OFFSET+0x00000288,0x00000001

#define IPU_IPU_CH_BUF2_RDY1__ADDR  IPU_REGISTERS_OFFSET+0x0000028C
#define IPU_IPU_CH_BUF2_RDY1__EMPTY IPU_REGISTERS_OFFSET+0x0000028C,0x00000000
#define IPU_IPU_CH_BUF2_RDY1__FULL  IPU_REGISTERS_OFFSET+0x0000028C,0xffffffff

#define IPU_IDMAC_CONF__ADDR            IPU_REGISTERS_OFFSET+0x00008000
#define IPU_IDMAC_CONF__EMPTY           IPU_REGISTERS_OFFSET+0x00008000,0x00000000
#define IPU_IDMAC_CONF__FULL            IPU_REGISTERS_OFFSET+0x00008000,0xffffffff
#define IPU_IDMAC_CONF__USED_BUFS_EN_R  IPU_REGISTERS_OFFSET+0x00008000,0x02000000
#define IPU_IDMAC_CONF__USED_BUFS_MAX_R IPU_REGISTERS_OFFSET+0x00008000,0x01E00000
#define IPU_IDMAC_CONF__USED_BUFS_EN_W  IPU_REGISTERS_OFFSET+0x00008000,0x00100000
#define IPU_IDMAC_CONF__USED_BUFS_MAX_W IPU_REGISTERS_OFFSET+0x00008000,0x000E0000
#define IPU_IDMAC_CONF__P_ENDIAN        IPU_REGISTERS_OFFSET+0x00008000,0x00010000
#define IPU_IDMAC_CONF__RDI             IPU_REGISTERS_OFFSET+0x00008000,0x00000020
#define IPU_IDMAC_CONF__WIDPT           IPU_REGISTERS_OFFSET+0x00008000,0x00000018
#define IPU_IDMAC_CONF__MAX_REQ_READ    IPU_REGISTERS_OFFSET+0x00008000,0x00000007

#define IPU_IDMAC_CH_EN_1__ADDR           IPU_REGISTERS_OFFSET+0x00008004
#define IPU_IDMAC_CH_EN_1__EMPTY          IPU_REGISTERS_OFFSET+0x00008004,0x00000000
#define IPU_IDMAC_CH_EN_1__FULL           IPU_REGISTERS_OFFSET+0x00008004,0xffffffff
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_31 IPU_REGISTERS_OFFSET+0x00008004,0x80000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_29 IPU_REGISTERS_OFFSET+0x00008004,0x20000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_28 IPU_REGISTERS_OFFSET+0x00008004,0x10000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_27 IPU_REGISTERS_OFFSET+0x00008004,0x08000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_26 IPU_REGISTERS_OFFSET+0x00008004,0x04000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_25 IPU_REGISTERS_OFFSET+0x00008004,0x02000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_24 IPU_REGISTERS_OFFSET+0x00008004,0x01000000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_23 IPU_REGISTERS_OFFSET+0x00008004,0x00800000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_22 IPU_REGISTERS_OFFSET+0x00008004,0x00400000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_21 IPU_REGISTERS_OFFSET+0x00008004,0x00200000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_20 IPU_REGISTERS_OFFSET+0x00008004,0x00100000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_19 IPU_REGISTERS_OFFSET+0x00008004,0x00080000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_18 IPU_REGISTERS_OFFSET+0x00008004,0x00040000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_17 IPU_REGISTERS_OFFSET+0x00008004,0x00020000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_15 IPU_REGISTERS_OFFSET+0x00008004,0x00008000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_14 IPU_REGISTERS_OFFSET+0x00008004,0x00004000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_13 IPU_REGISTERS_OFFSET+0x00008004,0x00002000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_12 IPU_REGISTERS_OFFSET+0x00008004,0x00001000
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_11 IPU_REGISTERS_OFFSET+0x00008004,0x00000800
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_10 IPU_REGISTERS_OFFSET+0x00008004,0x00000400
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_9  IPU_REGISTERS_OFFSET+0x00008004,0x00000200
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_8  IPU_REGISTERS_OFFSET+0x00008004,0x00000100
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_5  IPU_REGISTERS_OFFSET+0x00008004,0x00000020
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_3  IPU_REGISTERS_OFFSET+0x00008004,0x00000008
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_2  IPU_REGISTERS_OFFSET+0x00008004,0x00000004
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_1  IPU_REGISTERS_OFFSET+0x00008004,0x00000002
#define IPU_IDMAC_CH_EN_1__IDMAC_CH_EN_0  IPU_REGISTERS_OFFSET+0x00008004,0x00000001

#define IPU_IDMAC_CH_EN_2__ADDR           IPU_REGISTERS_OFFSET+0x00008008
#define IPU_IDMAC_CH_EN_2__EMPTY          IPU_REGISTERS_OFFSET+0x00008008,0x00000000
#define IPU_IDMAC_CH_EN_2__FULL           IPU_REGISTERS_OFFSET+0x00008008,0xffffffff
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_52 IPU_REGISTERS_OFFSET+0x00008008,0x00100000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_51 IPU_REGISTERS_OFFSET+0x00008008,0x00080000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_50 IPU_REGISTERS_OFFSET+0x00008008,0x00040000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_49 IPU_REGISTERS_OFFSET+0x00008008,0x00020000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_48 IPU_REGISTERS_OFFSET+0x00008008,0x00010000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_47 IPU_REGISTERS_OFFSET+0x00008008,0x00008000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_46 IPU_REGISTERS_OFFSET+0x00008008,0x00004000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_45 IPU_REGISTERS_OFFSET+0x00008008,0x00002000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_44 IPU_REGISTERS_OFFSET+0x00008008,0x00001000
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_43 IPU_REGISTERS_OFFSET+0x00008008,0x00000800
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_42 IPU_REGISTERS_OFFSET+0x00008008,0x00000400
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_41 IPU_REGISTERS_OFFSET+0x00008008,0x00000200
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_40 IPU_REGISTERS_OFFSET+0x00008008,0x00000100
#define IPU_IDMAC_CH_EN_2__IDMAC_CH_EN_33 IPU_REGISTERS_OFFSET+0x00008008,0x00000002

#define IPU_IDMAC_SEP_ALPHA__ADDR            IPU_REGISTERS_OFFSET+0x0000800C
#define IPU_IDMAC_SEP_ALPHA__EMPTY           IPU_REGISTERS_OFFSET+0x0000800C,0x00000000
#define IPU_IDMAC_SEP_ALPHA__FULL            IPU_REGISTERS_OFFSET+0x0000800C,0xffffffff
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_29 IPU_REGISTERS_OFFSET+0x0000800C,0x20000000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_27 IPU_REGISTERS_OFFSET+0x0000800C,0x08000000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_25 IPU_REGISTERS_OFFSET+0x0000800C,0x02000000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_24 IPU_REGISTERS_OFFSET+0x0000800C,0x01000000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_23 IPU_REGISTERS_OFFSET+0x0000800C,0x00800000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_15 IPU_REGISTERS_OFFSET+0x0000800C,0x00008000
#define IPU_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_14 IPU_REGISTERS_OFFSET+0x0000800C,0x00004000

#define IPU_IDMAC_ALT_SEP_ALPHA__ADDR                IPU_REGISTERS_OFFSET+0x00008010
#define IPU_IDMAC_ALT_SEP_ALPHA__EMPTY               IPU_REGISTERS_OFFSET+0x00008010,0x00000000
#define IPU_IDMAC_ALT_SEP_ALPHA__FULL                IPU_REGISTERS_OFFSET+0x00008010,0xffffffff
#define IPU_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_29 IPU_REGISTERS_OFFSET+0x00008010,0x20000000
#define IPU_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_24 IPU_REGISTERS_OFFSET+0x00008010,0x01000000
#define IPU_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_23 IPU_REGISTERS_OFFSET+0x00008010,0x00800000

#define IPU_IDMAC_CH_PRI_1__ADDR            IPU_REGISTERS_OFFSET+0x00008014
#define IPU_IDMAC_CH_PRI_1__EMPTY           IPU_REGISTERS_OFFSET+0x00008014,0x00000000
#define IPU_IDMAC_CH_PRI_1__FULL            IPU_REGISTERS_OFFSET+0x00008014,0xffffffff
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_29 IPU_REGISTERS_OFFSET+0x00008014,0x20000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_28 IPU_REGISTERS_OFFSET+0x00008014,0x10000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_27 IPU_REGISTERS_OFFSET+0x00008014,0x08000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_26 IPU_REGISTERS_OFFSET+0x00008014,0x04000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_25 IPU_REGISTERS_OFFSET+0x00008014,0x02000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_24 IPU_REGISTERS_OFFSET+0x00008014,0x01000000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_23 IPU_REGISTERS_OFFSET+0x00008014,0x00800000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_22 IPU_REGISTERS_OFFSET+0x00008014,0x00400000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_21 IPU_REGISTERS_OFFSET+0x00008014,0x00200000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_20 IPU_REGISTERS_OFFSET+0x00008014,0x00100000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_15 IPU_REGISTERS_OFFSET+0x00008014,0x00008000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_14 IPU_REGISTERS_OFFSET+0x00008014,0x00004000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_13 IPU_REGISTERS_OFFSET+0x00008014,0x00002000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_12 IPU_REGISTERS_OFFSET+0x00008014,0x00001000
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_11 IPU_REGISTERS_OFFSET+0x00008014,0x00000800
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_10 IPU_REGISTERS_OFFSET+0x00008014,0x00000400
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_9  IPU_REGISTERS_OFFSET+0x00008014,0x00000200
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_8  IPU_REGISTERS_OFFSET+0x00008014,0x00000100
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_5  IPU_REGISTERS_OFFSET+0x00008014,0x00000020
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_3  IPU_REGISTERS_OFFSET+0x00008014,0x00000008
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_2  IPU_REGISTERS_OFFSET+0x00008014,0x00000004
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_1  IPU_REGISTERS_OFFSET+0x00008014,0x00000002
#define IPU_IDMAC_CH_PRI_1__IDMAC_CH_PRI_0  IPU_REGISTERS_OFFSET+0x00008014,0x00000001

#define IPU_IDMAC_CH_PRI_2__ADDR            IPU_REGISTERS_OFFSET+0x00008018
#define IPU_IDMAC_CH_PRI_2__EMPTY           IPU_REGISTERS_OFFSET+0x00008018,0x00000000
#define IPU_IDMAC_CH_PRI_2__FULL            IPU_REGISTERS_OFFSET+0x00008018,0xffffffff
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_50 IPU_REGISTERS_OFFSET+0x00008018,0x00040000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_49 IPU_REGISTERS_OFFSET+0x00008018,0x00020000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_48 IPU_REGISTERS_OFFSET+0x00008018,0x00010000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_47 IPU_REGISTERS_OFFSET+0x00008018,0x00008000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_46 IPU_REGISTERS_OFFSET+0x00008018,0x00004000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_45 IPU_REGISTERS_OFFSET+0x00008018,0x00002000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_44 IPU_REGISTERS_OFFSET+0x00008018,0x00001000
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_43 IPU_REGISTERS_OFFSET+0x00008018,0x00000800
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_42 IPU_REGISTERS_OFFSET+0x00008018,0x00000400
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_41 IPU_REGISTERS_OFFSET+0x00008018,0x00000200
#define IPU_IDMAC_CH_PRI_2__IDMAC_CH_PRI_40 IPU_REGISTERS_OFFSET+0x00008018,0x00000100

#define IPU_IDMAC_WM_EN_1__ADDR           IPU_REGISTERS_OFFSET+0x0000801C
#define IPU_IDMAC_WM_EN_1__EMPTY          IPU_REGISTERS_OFFSET+0x0000801C,0x00000000
#define IPU_IDMAC_WM_EN_1__FULL           IPU_REGISTERS_OFFSET+0x0000801C,0xffffffff
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_29 IPU_REGISTERS_OFFSET+0x0000801C,0x20000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_28 IPU_REGISTERS_OFFSET+0x0000801C,0x10000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_27 IPU_REGISTERS_OFFSET+0x0000801C,0x08000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_26 IPU_REGISTERS_OFFSET+0x0000801C,0x04000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_25 IPU_REGISTERS_OFFSET+0x0000801C,0x02000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_24 IPU_REGISTERS_OFFSET+0x0000801C,0x01000000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_23 IPU_REGISTERS_OFFSET+0x0000801C,0x00800000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_14 IPU_REGISTERS_OFFSET+0x0000801C,0x00004000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_13 IPU_REGISTERS_OFFSET+0x0000801C,0x00002000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_12 IPU_REGISTERS_OFFSET+0x0000801C,0x00001000
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_10 IPU_REGISTERS_OFFSET+0x0000801C,0x00000400
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_8  IPU_REGISTERS_OFFSET+0x0000801C,0x00000100
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_3  IPU_REGISTERS_OFFSET+0x0000801C,0x00000008
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_2  IPU_REGISTERS_OFFSET+0x0000801C,0x00000004
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_1  IPU_REGISTERS_OFFSET+0x0000801C,0x00000002
#define IPU_IDMAC_WM_EN_1__IDMAC_WM_EN_0  IPU_REGISTERS_OFFSET+0x0000801C,0x00000001

#define IPU_IDMAC_WM_EN_2__ADDR           IPU_REGISTERS_OFFSET+0x00008020
#define IPU_IDMAC_WM_EN_2__EMPTY          IPU_REGISTERS_OFFSET+0x00008020,0x00000000
#define IPU_IDMAC_WM_EN_2__FULL           IPU_REGISTERS_OFFSET+0x00008020,0xffffffff
#define IPU_IDMAC_WM_EN_2__IDMAC_WM_EN_44 IPU_REGISTERS_OFFSET+0x00008020,0x00001000
#define IPU_IDMAC_WM_EN_2__IDMAC_WM_EN_43 IPU_REGISTERS_OFFSET+0x00008020,0x00000800
#define IPU_IDMAC_WM_EN_2__IDMAC_WM_EN_42 IPU_REGISTERS_OFFSET+0x00008020,0x00000400
#define IPU_IDMAC_WM_EN_2__IDMAC_WM_EN_41 IPU_REGISTERS_OFFSET+0x00008020,0x00000200
#define IPU_IDMAC_WM_EN_2__IDMAC_WM_EN_40 IPU_REGISTERS_OFFSET+0x00008020,0x00000100

#define IPU_IDMAC_LOCK_EN_1__ADDR             IPU_REGISTERS_OFFSET+0x00008024
#define IPU_IDMAC_LOCK_EN_1__EMPTY            IPU_REGISTERS_OFFSET+0x00008024,0x00000000
#define IPU_IDMAC_LOCK_EN_1__FULL             IPU_REGISTERS_OFFSET+0x00008024,0xffffffff
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_28 IPU_REGISTERS_OFFSET+0x00008024,0x00300000
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_27 IPU_REGISTERS_OFFSET+0x00008024,0x000C0000
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_23 IPU_REGISTERS_OFFSET+0x00008024,0x00030000
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_22 IPU_REGISTERS_OFFSET+0x00008024,0x0000C000
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_21 IPU_REGISTERS_OFFSET+0x00008024,0x00003000
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_20 IPU_REGISTERS_OFFSET+0x00008024,0x00000C00
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_15 IPU_REGISTERS_OFFSET+0x00008024,0x00000300
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_14 IPU_REGISTERS_OFFSET+0x00008024,0x000000C0
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_12 IPU_REGISTERS_OFFSET+0x00008024,0x00000030
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_11 IPU_REGISTERS_OFFSET+0x00008024,0x0000000C
#define IPU_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_5  IPU_REGISTERS_OFFSET+0x00008024,0x00000003

#define IPU_IDMAC_LOCK_EN_2__ADDR             IPU_REGISTERS_OFFSET+0x00008028
#define IPU_IDMAC_LOCK_EN_2__EMPTY            IPU_REGISTERS_OFFSET+0x00008028,0x00000000
#define IPU_IDMAC_LOCK_EN_2__FULL             IPU_REGISTERS_OFFSET+0x00008028,0xffffffff
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_50 IPU_REGISTERS_OFFSET+0x00008028,0x00000C00
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_49 IPU_REGISTERS_OFFSET+0x00008028,0x00000300
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_48 IPU_REGISTERS_OFFSET+0x00008028,0x000000C0
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_47 IPU_REGISTERS_OFFSET+0x00008028,0x00000030
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_46 IPU_REGISTERS_OFFSET+0x00008028,0x0000000C
#define IPU_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_45 IPU_REGISTERS_OFFSET+0x00008028,0x00000003

#define IPU_IDMAC_SUB_ADDR_0__ADDR  IPU_REGISTERS_OFFSET+0x0000802C
#define IPU_IDMAC_SUB_ADDR_0__EMPTY IPU_REGISTERS_OFFSET+0x0000802C,0x00000000
#define IPU_IDMAC_SUB_ADDR_0__FULL  IPU_REGISTERS_OFFSET+0x0000802C,0xffffffff
#define IPU_IDMAC_SUB_ADDR_0__IDMAC_SUB_ADDR_2  IPU_REGISTERS_OFFSET+0x0000802C,0x00007F00
#define IPU_IDMAC_SUB_ADDR_0__IDMAC_SUB_ADDR_0  IPU_REGISTERS_OFFSET+0x0000802C,0x0000007F

#define IPU_IDMAC_SUB_ADDR_1__ADDR              IPU_REGISTERS_OFFSET+0x00008030
#define IPU_IDMAC_SUB_ADDR_1__EMPTY             IPU_REGISTERS_OFFSET+0x00008030,0x00000000
#define IPU_IDMAC_SUB_ADDR_1__FULL              IPU_REGISTERS_OFFSET+0x00008030,0xffffffff
#define IPU_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_33 IPU_REGISTERS_OFFSET+0x00008030,0x7F000000
#define IPU_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_29 IPU_REGISTERS_OFFSET+0x00008030,0x007F0000
#define IPU_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_24 IPU_REGISTERS_OFFSET+0x00008030,0x00007F00
#define IPU_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_23 IPU_REGISTERS_OFFSET+0x00008030,0x0000007F

#define IPU_IDMAC_SUB_ADDR_2__ADDR              IPU_REGISTERS_OFFSET+0x00008034
#define IPU_IDMAC_SUB_ADDR_2__EMPTY             IPU_REGISTERS_OFFSET+0x00008034,0x00000000
#define IPU_IDMAC_SUB_ADDR_2__FULL              IPU_REGISTERS_OFFSET+0x00008034,0xffffffff
#define IPU_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_52 IPU_REGISTERS_OFFSET+0x00008034,0x007F0000
#define IPU_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_51 IPU_REGISTERS_OFFSET+0x00008034,0x00007F00
#define IPU_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_41 IPU_REGISTERS_OFFSET+0x00008034,0x0000007F

#define IPU_IDMAC_SUB_ADDR_3__ADDR              IPU_REGISTERS_OFFSET+0x00008038
#define IPU_IDMAC_SUB_ADDR_3__EMPTY             IPU_REGISTERS_OFFSET+0x00008038,0x00000000
#define IPU_IDMAC_SUB_ADDR_3__FULL              IPU_REGISTERS_OFFSET+0x00008038,0xffffffff
#define IPU_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_27 IPU_REGISTERS_OFFSET+0x00008038,0x7F000000
#define IPU_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_13 IPU_REGISTERS_OFFSET+0x00008038,0x007F0000
#define IPU_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_10 IPU_REGISTERS_OFFSET+0x00008038,0x00007F00
#define IPU_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_9  IPU_REGISTERS_OFFSET+0x00008038,0x0000007F

#define IPU_IDMAC_SUB_ADDR_4__ADDR              IPU_REGISTERS_OFFSET+0x0000803C
#define IPU_IDMAC_SUB_ADDR_4__EMPTY             IPU_REGISTERS_OFFSET+0x0000803C,0x00000000
#define IPU_IDMAC_SUB_ADDR_4__FULL              IPU_REGISTERS_OFFSET+0x0000803C,0xffffffff
#define IPU_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_21 IPU_REGISTERS_OFFSET+0x0000803C,0x007F0000
#define IPU_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_8  IPU_REGISTERS_OFFSET+0x0000803C,0x00007F00
#define IPU_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_28 IPU_REGISTERS_OFFSET+0x0000803C,0x0000007F

#define IPU_IDMAC_BNDM_EN_1__ADDR             IPU_REGISTERS_OFFSET+0x00008040
#define IPU_IDMAC_BNDM_EN_1__EMPTY            IPU_REGISTERS_OFFSET+0x00008040,0x00000000
#define IPU_IDMAC_BNDM_EN_1__FULL             IPU_REGISTERS_OFFSET+0x00008040,0xffffffff
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_26 IPU_REGISTERS_OFFSET+0x00008040,0x04000000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_25 IPU_REGISTERS_OFFSET+0x00008040,0x02000000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_22 IPU_REGISTERS_OFFSET+0x00008040,0x00400000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_21 IPU_REGISTERS_OFFSET+0x00008040,0x00200000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_20 IPU_REGISTERS_OFFSET+0x00008040,0x00100000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_12 IPU_REGISTERS_OFFSET+0x00008040,0x00001000
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_11 IPU_REGISTERS_OFFSET+0x00008040,0x00000800
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_10 IPU_REGISTERS_OFFSET+0x00008040,0x00000400
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_9  IPU_REGISTERS_OFFSET+0x00008040,0x00000200
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_8  IPU_REGISTERS_OFFSET+0x00008040,0x00000100
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_5  IPU_REGISTERS_OFFSET+0x00008040,0x00000020
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_3  IPU_REGISTERS_OFFSET+0x00008040,0x00000008
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_2  IPU_REGISTERS_OFFSET+0x00008040,0x00000004
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_1  IPU_REGISTERS_OFFSET+0x00008040,0x00000002
#define IPU_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_0  IPU_REGISTERS_OFFSET+0x00008040,0x00000001

#define IPU_IDMAC_BNDM_EN_2__ADDR             IPU_REGISTERS_OFFSET+0x00008044
#define IPU_IDMAC_BNDM_EN_2__EMPTY            IPU_REGISTERS_OFFSET+0x00008044,0x00000000
#define IPU_IDMAC_BNDM_EN_2__FULL             IPU_REGISTERS_OFFSET+0x00008044,0xffffffff
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_50 IPU_REGISTERS_OFFSET+0x00008044,0x00040000
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_49 IPU_REGISTERS_OFFSET+0x00008044,0x00020000
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_48 IPU_REGISTERS_OFFSET+0x00008044,0x00010000
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_47 IPU_REGISTERS_OFFSET+0x00008044,0x00008000
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_46 IPU_REGISTERS_OFFSET+0x00008044,0x00004000
#define IPU_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_45 IPU_REGISTERS_OFFSET+0x00008044,0x00002000

#define IPU_IDMAC_SC_CORD__ADDR  IPU_REGISTERS_OFFSET+0x00008048
#define IPU_IDMAC_SC_CORD__EMPTY IPU_REGISTERS_OFFSET+0x00008048,0x00000000
#define IPU_IDMAC_SC_CORD__FULL  IPU_REGISTERS_OFFSET+0x00008048,0xffffffff
#define IPU_IDMAC_SC_CORD__SX0   IPU_REGISTERS_OFFSET+0x00008048,0x0FFF0000
#define IPU_IDMAC_SC_CORD__SY0   IPU_REGISTERS_OFFSET+0x00008048,0x000007FF

#define IPU_IDMAC_SC_CORD1__ADDR  IPU_REGISTERS_OFFSET+0x0000804C
#define IPU_IDMAC_SC_CORD1__EMPTY IPU_REGISTERS_OFFSET+0x0000804C,0x00000000
#define IPU_IDMAC_SC_CORD1__FULL  IPU_REGISTERS_OFFSET+0x0000804C,0xffffffff
#define IPU_IDMAC_SC_CORD1__SX1   IPU_REGISTERS_OFFSET+0x0000804C,0x0FFF0000
#define IPU_IDMAC_SC_CORD1__SY1   IPU_REGISTERS_OFFSET+0x0000804C,0x000007FF

#define IPU_IDMAC_CH_BUSY_1__ADDR             IPU_REGISTERS_OFFSET+0x00008100
#define IPU_IDMAC_CH_BUSY_1__EMPTY            IPU_REGISTERS_OFFSET+0x00008100,0x00000000
#define IPU_IDMAC_CH_BUSY_1__FULL             IPU_REGISTERS_OFFSET+0x00008100,0xffffffff
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_31 IPU_REGISTERS_OFFSET+0x00008100,0x80000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_29 IPU_REGISTERS_OFFSET+0x00008100,0x20000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_28 IPU_REGISTERS_OFFSET+0x00008100,0x10000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_27 IPU_REGISTERS_OFFSET+0x00008100,0x08000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_26 IPU_REGISTERS_OFFSET+0x00008100,0x04000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_25 IPU_REGISTERS_OFFSET+0x00008100,0x02000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_24 IPU_REGISTERS_OFFSET+0x00008100,0x01000000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_23 IPU_REGISTERS_OFFSET+0x00008100,0x00800000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_22 IPU_REGISTERS_OFFSET+0x00008100,0x00400000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_21 IPU_REGISTERS_OFFSET+0x00008100,0x00200000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_20 IPU_REGISTERS_OFFSET+0x00008100,0x00100000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_18 IPU_REGISTERS_OFFSET+0x00008100,0x00040000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_17 IPU_REGISTERS_OFFSET+0x00008100,0x00020000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_15 IPU_REGISTERS_OFFSET+0x00008100,0x00008000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_14 IPU_REGISTERS_OFFSET+0x00008100,0x00004000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_13 IPU_REGISTERS_OFFSET+0x00008100,0x00002000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_12 IPU_REGISTERS_OFFSET+0x00008100,0x00001000
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_11 IPU_REGISTERS_OFFSET+0x00008100,0x00000800
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_10 IPU_REGISTERS_OFFSET+0x00008100,0x00000400
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_9  IPU_REGISTERS_OFFSET+0x00008100,0x00000200
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_8  IPU_REGISTERS_OFFSET+0x00008100,0x00000100
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_5  IPU_REGISTERS_OFFSET+0x00008100,0x00000020
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_3  IPU_REGISTERS_OFFSET+0x00008100,0x00000008
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_2  IPU_REGISTERS_OFFSET+0x00008100,0x00000004
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_1  IPU_REGISTERS_OFFSET+0x00008100,0x00000002
#define IPU_IDMAC_CH_BUSY_1__IDMAC_CH_BUSY_0  IPU_REGISTERS_OFFSET+0x00008100,0x00000001

#define IPU_IDMAC_CH_BUSY_2__ADDR             IPU_REGISTERS_OFFSET+0x00008104
#define IPU_IDMAC_CH_BUSY_2__EMPTY            IPU_REGISTERS_OFFSET+0x00008104,0x00000000
#define IPU_IDMAC_CH_BUSY_2__FULL             IPU_REGISTERS_OFFSET+0x00008104,0xffffffff
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_52 IPU_REGISTERS_OFFSET+0x00008104,0x00100000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_51 IPU_REGISTERS_OFFSET+0x00008104,0x00080000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_50 IPU_REGISTERS_OFFSET+0x00008104,0x00040000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_49 IPU_REGISTERS_OFFSET+0x00008104,0x00020000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_48 IPU_REGISTERS_OFFSET+0x00008104,0x00010000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_47 IPU_REGISTERS_OFFSET+0x00008104,0x00008000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_46 IPU_REGISTERS_OFFSET+0x00008104,0x00004000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_45 IPU_REGISTERS_OFFSET+0x00008104,0x00002000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_44 IPU_REGISTERS_OFFSET+0x00008104,0x00001000
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_43 IPU_REGISTERS_OFFSET+0x00008104,0x00000800
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_42 IPU_REGISTERS_OFFSET+0x00008104,0x00000400
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_41 IPU_REGISTERS_OFFSET+0x00008104,0x00000200
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_40 IPU_REGISTERS_OFFSET+0x00008104,0x00000100
#define IPU_IDMAC_CH_BUSY_2__IDMAC_CH_BUSY_33 IPU_REGISTERS_OFFSET+0x00008104,0x00000002

#define IPU_DP_COM_CONF_SYNC__ADDR                     IPU_MEMORY_OFFSET+0x0040000
#define IPU_DP_COM_CONF_SYNC__EMPTY                    IPU_MEMORY_OFFSET+0x0040000,0x00000000
#define IPU_DP_COM_CONF_SYNC__FULL                     IPU_MEMORY_OFFSET+0x0040000,0xffffffff
#define IPU_DP_COM_CONF_SYNC__DP_GAMMA_YUV_EN_SYNC     IPU_MEMORY_OFFSET+0x0040000,0x00002000
#define IPU_DP_COM_CONF_SYNC__DP_GAMMA_EN_SYNC         IPU_MEMORY_OFFSET+0x0040000,0x00001000
#define IPU_DP_COM_CONF_SYNC__DP_CSC_YUV_SAT_MODE_SYNC IPU_MEMORY_OFFSET+0x0040000,0x00000800
#define IPU_DP_COM_CONF_SYNC__DP_CSC_GAMUT_SAT_EN_SYNC IPU_MEMORY_OFFSET+0x0040000,0x00000400
#define IPU_DP_COM_CONF_SYNC__DP_CSC_DEF_SYNC          IPU_MEMORY_OFFSET+0x0040000,0x00000300
#define IPU_DP_COM_CONF_SYNC__DP_COC_SYNC              IPU_MEMORY_OFFSET+0x0040000,0x00000070
#define IPU_DP_COM_CONF_SYNC__DP_GWCKE_SYNC            IPU_MEMORY_OFFSET+0x0040000,0x00000008
#define IPU_DP_COM_CONF_SYNC__DP_GWAM_SYNC             IPU_MEMORY_OFFSET+0x0040000,0x00000004
#define IPU_DP_COM_CONF_SYNC__DP_GWSEL_SYNC            IPU_MEMORY_OFFSET+0x0040000,0x00000002
#define IPU_DP_COM_CONF_SYNC__DP_FG_EN_SYNC            IPU_MEMORY_OFFSET+0x0040000,0x00000001

#define IPU_DP_GRAPH_WIND_CTRL_SYNC__ADDR          IPU_MEMORY_OFFSET+0x0040004
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__EMPTY         IPU_MEMORY_OFFSET+0x0040004,0x00000000
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__FULL          IPU_MEMORY_OFFSET+0x0040004,0xffffffff
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__DP_GWAV_SYNC  IPU_MEMORY_OFFSET+0x0040004,0xFF000000
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKR_SYNC IPU_MEMORY_OFFSET+0x0040004,0x00FF0000
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKG_SYNC IPU_MEMORY_OFFSET+0x0040004,0x0000FF00
#define IPU_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKB_SYNC IPU_MEMORY_OFFSET+0x0040004,0x000000FF

#define IPU_DP_FG_POS_SYNC__ADDR         IPU_MEMORY_OFFSET+0x0040008
#define IPU_DP_FG_POS_SYNC__EMPTY        IPU_MEMORY_OFFSET+0x0040008,0x00000000
#define IPU_DP_FG_POS_SYNC__FULL         IPU_MEMORY_OFFSET+0x0040008,0xffffffff
#define IPU_DP_FG_POS_SYNC__DP_FGXP_SYNC IPU_MEMORY_OFFSET+0x0040008,0x07FF0000
#define IPU_DP_FG_POS_SYNC__DP_FGYP_SYNC IPU_MEMORY_OFFSET+0x0040008,0x000007FF

#define IPU_DP_CUR_POS_SYNC__ADDR        IPU_MEMORY_OFFSET+0x004000C
#define IPU_DP_CUR_POS_SYNC__EMPTY       IPU_MEMORY_OFFSET+0x004000C,0x00000000
#define IPU_DP_CUR_POS_SYNC__FULL        IPU_MEMORY_OFFSET+0x004000C,0xffffffff
#define IPU_DP_CUR_POS_SYNC__DP_CXW_SYNC IPU_MEMORY_OFFSET+0x004000C,0xF8000000
#define IPU_DP_CUR_POS_SYNC__DP_CXP_SYNC IPU_MEMORY_OFFSET+0x004000C,0x07FF0000
#define IPU_DP_CUR_POS_SYNC__DP_CYH_SYNC IPU_MEMORY_OFFSET+0x004000C,0x0000F800
#define IPU_DP_CUR_POS_SYNC__DP_CYP_SYNC IPU_MEMORY_OFFSET+0x004000C,0x000007FF

#define IPU_DP_CUR_MAP_SYNC__ADDR              IPU_MEMORY_OFFSET+0x0040010
#define IPU_DP_CUR_MAP_SYNC__EMPTY             IPU_MEMORY_OFFSET+0x0040010,0x00000000
#define IPU_DP_CUR_MAP_SYNC__FULL              IPU_MEMORY_OFFSET+0x0040010,0xffffffff
#define IPU_DP_CUR_MAP_SYNC__DP_CUR_COL_R_SYNC IPU_MEMORY_OFFSET+0x0040010,0x00FF0000
#define IPU_DP_CUR_MAP_SYNC__DP_CUR_COL_G_SYNC IPU_MEMORY_OFFSET+0x0040010,0x0000FF00
#define IPU_DP_CUR_MAP_SYNC__DP_CUR_COL_B_SYNC IPU_MEMORY_OFFSET+0x0040010,0x000000FF

#define IPU_DP_GAMMA_C_SYNC_0__ADDR              IPU_MEMORY_OFFSET+0x0040014
#define IPU_DP_GAMMA_C_SYNC_0__EMPTY             IPU_MEMORY_OFFSET+0x0040014,0x00000000
#define IPU_DP_GAMMA_C_SYNC_0__FULL              IPU_MEMORY_OFFSET+0x0040014,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_1 IPU_MEMORY_OFFSET+0x0040014,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_0 IPU_MEMORY_OFFSET+0x0040014,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_1__ADDR              IPU_MEMORY_OFFSET+0x0040018
#define IPU_DP_GAMMA_C_SYNC_1__EMPTY             IPU_MEMORY_OFFSET+0x0040018,0x00000000
#define IPU_DP_GAMMA_C_SYNC_1__FULL              IPU_MEMORY_OFFSET+0x0040018,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_3 IPU_MEMORY_OFFSET+0x0040018,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_2 IPU_MEMORY_OFFSET+0x0040018,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_2__ADDR              IPU_MEMORY_OFFSET+0x004001C
#define IPU_DP_GAMMA_C_SYNC_2__EMPTY             IPU_MEMORY_OFFSET+0x004001C,0x00000000
#define IPU_DP_GAMMA_C_SYNC_2__FULL              IPU_MEMORY_OFFSET+0x004001C,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_5 IPU_MEMORY_OFFSET+0x004001C,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_4 IPU_MEMORY_OFFSET+0x004001C,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_3__ADDR              IPU_MEMORY_OFFSET+0x0040020
#define IPU_DP_GAMMA_C_SYNC_3__EMPTY             IPU_MEMORY_OFFSET+0x0040020,0x00000000
#define IPU_DP_GAMMA_C_SYNC_3__FULL              IPU_MEMORY_OFFSET+0x0040020,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_7 IPU_MEMORY_OFFSET+0x0040020,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_6 IPU_MEMORY_OFFSET+0x0040020,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_4__ADDR              IPU_MEMORY_OFFSET+0x0040024
#define IPU_DP_GAMMA_C_SYNC_4__EMPTY             IPU_MEMORY_OFFSET+0x0040024,0x00000000
#define IPU_DP_GAMMA_C_SYNC_4__FULL              IPU_MEMORY_OFFSET+0x0040024,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_9 IPU_MEMORY_OFFSET+0x0040024,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_8 IPU_MEMORY_OFFSET+0x0040024,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_5__ADDR               IPU_MEMORY_OFFSET+0x0040028
#define IPU_DP_GAMMA_C_SYNC_5__EMPTY              IPU_MEMORY_OFFSET+0x0040028,0x00000000
#define IPU_DP_GAMMA_C_SYNC_5__FULL               IPU_MEMORY_OFFSET+0x0040028,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_11 IPU_MEMORY_OFFSET+0x0040028,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_10 IPU_MEMORY_OFFSET+0x0040028,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_6__ADDR               IPU_MEMORY_OFFSET+0x004002C
#define IPU_DP_GAMMA_C_SYNC_6__EMPTY              IPU_MEMORY_OFFSET+0x004002C,0x00000000
#define IPU_DP_GAMMA_C_SYNC_6__FULL               IPU_MEMORY_OFFSET+0x004002C,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_13 IPU_MEMORY_OFFSET+0x004002C,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_12 IPU_MEMORY_OFFSET+0x004002C,0x000001FF

#define IPU_DP_GAMMA_C_SYNC_7__ADDR               IPU_MEMORY_OFFSET+0x0040030
#define IPU_DP_GAMMA_C_SYNC_7__EMPTY              IPU_MEMORY_OFFSET+0x0040030,0x00000000
#define IPU_DP_GAMMA_C_SYNC_7__FULL               IPU_MEMORY_OFFSET+0x0040030,0xffffffff
#define IPU_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_15 IPU_MEMORY_OFFSET+0x0040030,0x01FF0000
#define IPU_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_14 IPU_MEMORY_OFFSET+0x0040030,0x000001FF

#define IPU_DP_GAMMA_S_SYNC_0__ADDR              IPU_MEMORY_OFFSET+0x0040034
#define IPU_DP_GAMMA_S_SYNC_0__EMPTY             IPU_MEMORY_OFFSET+0x0040034,0x00000000
#define IPU_DP_GAMMA_S_SYNC_0__FULL              IPU_MEMORY_OFFSET+0x0040034,0xffffffff
#define IPU_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_3 IPU_MEMORY_OFFSET+0x0040034,0xFF000000
#define IPU_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_2 IPU_MEMORY_OFFSET+0x0040034,0x00FF0000
#define IPU_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_1 IPU_MEMORY_OFFSET+0x0040034,0x0000FF00
#define IPU_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_0 IPU_MEMORY_OFFSET+0x0040034,0x000000FF

#define IPU_DP_GAMMA_S_SYNC_1__ADDR              IPU_MEMORY_OFFSET+0x0040038
#define IPU_DP_GAMMA_S_SYNC_1__EMPTY             IPU_MEMORY_OFFSET+0x0040038,0x00000000
#define IPU_DP_GAMMA_S_SYNC_1__FULL              IPU_MEMORY_OFFSET+0x0040038,0xffffffff
#define IPU_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_7 IPU_MEMORY_OFFSET+0x0040038,0xFF000000
#define IPU_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_6 IPU_MEMORY_OFFSET+0x0040038,0x00FF0000
#define IPU_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_5 IPU_MEMORY_OFFSET+0x0040038,0x0000FF00
#define IPU_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_4 IPU_MEMORY_OFFSET+0x0040038,0x000000FF

#define IPU_DP_GAMMA_S_SYNC_2__ADDR               IPU_MEMORY_OFFSET+0x004003C
#define IPU_DP_GAMMA_S_SYNC_2__EMPTY              IPU_MEMORY_OFFSET+0x004003C,0x00000000
#define IPU_DP_GAMMA_S_SYNC_2__FULL               IPU_MEMORY_OFFSET+0x004003C,0xffffffff
#define IPU_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_11 IPU_MEMORY_OFFSET+0x004003C,0xFF000000
#define IPU_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_10 IPU_MEMORY_OFFSET+0x004003C,0x00FF0000
#define IPU_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_9  IPU_MEMORY_OFFSET+0x004003C,0x0000FF00
#define IPU_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_8  IPU_MEMORY_OFFSET+0x004003C,0x000000FF

#define IPU_DP_GAMMA_S_SYNC_3__ADDR               IPU_MEMORY_OFFSET+0x0040040
#define IPU_DP_GAMMA_S_SYNC_3__EMPTY              IPU_MEMORY_OFFSET+0x0040040,0x00000000
#define IPU_DP_GAMMA_S_SYNC_3__FULL               IPU_MEMORY_OFFSET+0x0040040,0xffffffff
#define IPU_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_15 IPU_MEMORY_OFFSET+0x0040040,0xFF000000
#define IPU_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_14 IPU_MEMORY_OFFSET+0x0040040,0x00FF0000
#define IPU_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_13 IPU_MEMORY_OFFSET+0x0040040,0x0000FF00
#define IPU_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_12 IPU_MEMORY_OFFSET+0x0040040,0x000000FF

#define IPU_DP_CSCA_SYNC_0__ADDR            IPU_MEMORY_OFFSET+0x0040044
#define IPU_DP_CSCA_SYNC_0__EMPTY           IPU_MEMORY_OFFSET+0x0040044,0x00000000
#define IPU_DP_CSCA_SYNC_0__FULL            IPU_MEMORY_OFFSET+0x0040044,0xffffffff
#define IPU_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_1 IPU_MEMORY_OFFSET+0x0040044,0x03FF0000
#define IPU_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_0 IPU_MEMORY_OFFSET+0x0040044,0x000003FF

#define IPU_DP_CSCA_SYNC_1__ADDR            IPU_MEMORY_OFFSET+0x0040048
#define IPU_DP_CSCA_SYNC_1__EMPTY           IPU_MEMORY_OFFSET+0x0040048,0x00000000
#define IPU_DP_CSCA_SYNC_1__FULL            IPU_MEMORY_OFFSET+0x0040048,0xffffffff
#define IPU_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_3 IPU_MEMORY_OFFSET+0x0040048,0x03FF0000
#define IPU_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_2 IPU_MEMORY_OFFSET+0x0040048,0x000003FF

#define IPU_DP_CSCA_SYNC_2__ADDR            IPU_MEMORY_OFFSET+0x004004C
#define IPU_DP_CSCA_SYNC_2__EMPTY           IPU_MEMORY_OFFSET+0x004004C,0x00000000
#define IPU_DP_CSCA_SYNC_2__FULL            IPU_MEMORY_OFFSET+0x004004C,0xffffffff
#define IPU_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_5 IPU_MEMORY_OFFSET+0x004004C,0x03FF0000
#define IPU_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_4 IPU_MEMORY_OFFSET+0x004004C,0x000003FF

#define IPU_DP_CSCA_SYNC_3__ADDR            IPU_MEMORY_OFFSET+0x0040050
#define IPU_DP_CSCA_SYNC_3__EMPTY           IPU_MEMORY_OFFSET+0x0040050,0x00000000
#define IPU_DP_CSCA_SYNC_3__FULL            IPU_MEMORY_OFFSET+0x0040050,0xffffffff
#define IPU_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_7 IPU_MEMORY_OFFSET+0x0040050,0x03FF0000
#define IPU_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_6 IPU_MEMORY_OFFSET+0x0040050,0x000003FF

#define IPU_DP_CSC_SYNC_0__ADDR           IPU_MEMORY_OFFSET+0x0040054
#define IPU_DP_CSC_SYNC_0__EMPTY          IPU_MEMORY_OFFSET+0x0040054,0x00000000
#define IPU_DP_CSC_SYNC_0__FULL           IPU_MEMORY_OFFSET+0x0040054,0xffffffff
#define IPU_DP_CSC_SYNC_0__DP_CSC_S0_SYNC IPU_MEMORY_OFFSET+0x0040054,0xC0000000
#define IPU_DP_CSC_SYNC_0__DP_CSC_B0_SYNC IPU_MEMORY_OFFSET+0x0040054,0x3FFF0000
#define IPU_DP_CSC_SYNC_0__DP_CSC_A8_SYNC IPU_MEMORY_OFFSET+0x0040054,0x000003FF

#define IPU_DP_CSC_SYNC_1__ADDR           IPU_MEMORY_OFFSET+0x0040058
#define IPU_DP_CSC_SYNC_1__EMPTY          IPU_MEMORY_OFFSET+0x0040058,0x00000000
#define IPU_DP_CSC_SYNC_1__FULL           IPU_MEMORY_OFFSET+0x0040058,0xffffffff
#define IPU_DP_CSC_SYNC_1__DP_CSC_S2_SYNC IPU_MEMORY_OFFSET+0x0040058,0xC0000000
#define IPU_DP_CSC_SYNC_1__DP_CSC_B2_SYNC IPU_MEMORY_OFFSET+0x0040058,0x3FFF0000
#define IPU_DP_CSC_SYNC_1__DP_CSC_S1_SYNC IPU_MEMORY_OFFSET+0x0040058,0x0000C000
#define IPU_DP_CSC_SYNC_1__DP_CSC_B1_SYNC IPU_MEMORY_OFFSET+0x0040058,0x00003FFF

#define IPU_DP_CUR_POS_ALT__ADDR            IPU_MEMORY_OFFSET+0x004005C
#define IPU_DP_CUR_POS_ALT__EMPTY           IPU_MEMORY_OFFSET+0x004005C,0x00000000
#define IPU_DP_CUR_POS_ALT__FULL            IPU_MEMORY_OFFSET+0x004005C,0xffffffff
#define IPU_DP_CUR_POS_ALT__DP_CXW_SYNC_ALT IPU_MEMORY_OFFSET+0x004005C,0xF8000000
#define IPU_DP_CUR_POS_ALT__DP_CXP_SYNC_ALT IPU_MEMORY_OFFSET+0x004005C,0x07FF0000
#define IPU_DP_CUR_POS_ALT__DP_CYH_SYNC_ALT IPU_MEMORY_OFFSET+0x004005C,0x0000F800
#define IPU_DP_CUR_POS_ALT__DP_CYP_SYNC_ALT IPU_MEMORY_OFFSET+0x004005C,0x000007FF

#define IPU_DP_COM_CONF_ASYNC0__ADDR                       IPU_MEMORY_OFFSET+0x0040060
#define IPU_DP_COM_CONF_ASYNC0__EMPTY                      IPU_MEMORY_OFFSET+0x0040060,0x00000000
#define IPU_DP_COM_CONF_ASYNC0__FULL                       IPU_MEMORY_OFFSET+0x0040060,0xffffffff
#define IPU_DP_COM_CONF_ASYNC0__DP_GAMMA_YUV_EN_ASYNC0     IPU_MEMORY_OFFSET+0x0040060,0x00002000
#define IPU_DP_COM_CONF_ASYNC0__DP_GAMMA_EN_ASYNC0         IPU_MEMORY_OFFSET+0x0040060,0x00001000
#define IPU_DP_COM_CONF_ASYNC0__DP_CSC_YUV_SAT_MODE_ASYNC0 IPU_MEMORY_OFFSET+0x0040060,0x00000800
#define IPU_DP_COM_CONF_ASYNC0__DP_CSC_GAMUT_SAT_EN_ASYNC0 IPU_MEMORY_OFFSET+0x0040060,0x00000400
#define IPU_DP_COM_CONF_ASYNC0__DP_CSC_DEF_ASYNC0          IPU_MEMORY_OFFSET+0x0040060,0x00000300
#define IPU_DP_COM_CONF_ASYNC0__DP_COC_ASYNC0              IPU_MEMORY_OFFSET+0x0040060,0x00000070
#define IPU_DP_COM_CONF_ASYNC0__DP_GWCKE_ASYNC0            IPU_MEMORY_OFFSET+0x0040060,0x00000008
#define IPU_DP_COM_CONF_ASYNC0__DP_GWAM_ASYNC0             IPU_MEMORY_OFFSET+0x0040060,0x00000004
#define IPU_DP_COM_CONF_ASYNC0__DP_GWSEL_ASYNC0            IPU_MEMORY_OFFSET+0x0040060,0x00000002

#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__ADDR            IPU_MEMORY_OFFSET+0x0040064
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__EMPTY           IPU_MEMORY_OFFSET+0x0040064,0x00000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__FULL            IPU_MEMORY_OFFSET+0x0040064,0xffffffff
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWAV_ASYNC0  IPU_MEMORY_OFFSET+0x0040064,0xFF000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKR_ASYNC0 IPU_MEMORY_OFFSET+0x0040064,0x00FF0000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKG_ASYNC0 IPU_MEMORY_OFFSET+0x0040064,0x0000FF00
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKB_ASYNC0 IPU_MEMORY_OFFSET+0x0040064,0x000000FF

#define IPU_DP_FG_POS_ASYNC0__ADDR           IPU_MEMORY_OFFSET+0x0040068
#define IPU_DP_FG_POS_ASYNC0__EMPTY          IPU_MEMORY_OFFSET+0x0040068,0x00000000
#define IPU_DP_FG_POS_ASYNC0__FULL           IPU_MEMORY_OFFSET+0x0040068,0xffffffff
#define IPU_DP_FG_POS_ASYNC0__DP_FGXP_ASYNC0 IPU_MEMORY_OFFSET+0x0040068,0x07FF0000
#define IPU_DP_FG_POS_ASYNC0__DP_FGYP_ASYNC0 IPU_MEMORY_OFFSET+0x0040068,0x000007FF

#define IPU_DP_CUR_POS_ASYNC0__ADDR          IPU_MEMORY_OFFSET+0x004006C
#define IPU_DP_CUR_POS_ASYNC0__EMPTY         IPU_MEMORY_OFFSET+0x004006C,0x00000000
#define IPU_DP_CUR_POS_ASYNC0__FULL          IPU_MEMORY_OFFSET+0x004006C,0xffffffff
#define IPU_DP_CUR_POS_ASYNC0__DP_CXW_ASYNC0 IPU_MEMORY_OFFSET+0x004006C,0xF8000000
#define IPU_DP_CUR_POS_ASYNC0__DP_CXP_ASYNC0 IPU_MEMORY_OFFSET+0x004006C,0x07FF0000
#define IPU_DP_CUR_POS_ASYNC0__DP_CYH_ASYNC0 IPU_MEMORY_OFFSET+0x004006C,0x0000F800
#define IPU_DP_CUR_POS_ASYNC0__DP_CYP_ASYNC0 IPU_MEMORY_OFFSET+0x004006C,0x000007FF

#define IPU_DP_CUR_MAP_ASYNC0__ADDR             IPU_MEMORY_OFFSET+0x0040070
#define IPU_DP_CUR_MAP_ASYNC0__EMPTY            IPU_MEMORY_OFFSET+0x0040070,0x00000000
#define IPU_DP_CUR_MAP_ASYNC0__FULL             IPU_MEMORY_OFFSET+0x0040070,0xffffffff
#define IPU_DP_CUR_MAP_ASYNC0__CUR_COL_R_ASYNC0 IPU_MEMORY_OFFSET+0x0040070,0x00FF0000
#define IPU_DP_CUR_MAP_ASYNC0__CUR_COL_G_ASYNC0 IPU_MEMORY_OFFSET+0x0040070,0x0000FF00
#define IPU_DP_CUR_MAP_ASYNC0__CUR_COL_B_ASYNC0 IPU_MEMORY_OFFSET+0x0040070,0x000000FF

#define IPU_DP_GAMMA_C_ASYNC0_0__ADDR                IPU_MEMORY_OFFSET+0x0040074
#define IPU_DP_GAMMA_C_ASYNC0_0__EMPTY               IPU_MEMORY_OFFSET+0x0040074,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_0__FULL                IPU_MEMORY_OFFSET+0x0040074,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_1 IPU_MEMORY_OFFSET+0x0040074,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_0 IPU_MEMORY_OFFSET+0x0040074,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_1__ADDR                IPU_MEMORY_OFFSET+0x0040078
#define IPU_DP_GAMMA_C_ASYNC0_1__EMPTY               IPU_MEMORY_OFFSET+0x0040078,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_1__FULL                IPU_MEMORY_OFFSET+0x0040078,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_3 IPU_MEMORY_OFFSET+0x0040078,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_2 IPU_MEMORY_OFFSET+0x0040078,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_2__ADDR                IPU_MEMORY_OFFSET+0x004007C
#define IPU_DP_GAMMA_C_ASYNC0_2__EMPTY               IPU_MEMORY_OFFSET+0x004007C,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_2__FULL                IPU_MEMORY_OFFSET+0x004007C,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_5 IPU_MEMORY_OFFSET+0x004007C,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_4 IPU_MEMORY_OFFSET+0x004007C,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_3__ADDR                IPU_MEMORY_OFFSET+0x0040080
#define IPU_DP_GAMMA_C_ASYNC0_3__EMPTY               IPU_MEMORY_OFFSET+0x0040080,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_3__FULL                IPU_MEMORY_OFFSET+0x0040080,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_7 IPU_MEMORY_OFFSET+0x0040080,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_6 IPU_MEMORY_OFFSET+0x0040080,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_4__ADDR                IPU_MEMORY_OFFSET+0x0040084
#define IPU_DP_GAMMA_C_ASYNC0_4__EMPTY               IPU_MEMORY_OFFSET+0x0040084,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_4__FULL                IPU_MEMORY_OFFSET+0x0040084,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_9 IPU_MEMORY_OFFSET+0x0040084,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_8 IPU_MEMORY_OFFSET+0x0040084,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_5__ADDR                 IPU_MEMORY_OFFSET+0x0040088
#define IPU_DP_GAMMA_C_ASYNC0_5__EMPTY                IPU_MEMORY_OFFSET+0x0040088,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_5__FULL                 IPU_MEMORY_OFFSET+0x0040088,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_11 IPU_MEMORY_OFFSET+0x0040088,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_10 IPU_MEMORY_OFFSET+0x0040088,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_6__ADDR                 IPU_MEMORY_OFFSET+0x004008C
#define IPU_DP_GAMMA_C_ASYNC0_6__EMPTY                IPU_MEMORY_OFFSET+0x004008C,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_6__FULL                 IPU_MEMORY_OFFSET+0x004008C,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_13 IPU_MEMORY_OFFSET+0x004008C,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_12 IPU_MEMORY_OFFSET+0x004008C,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC0_7__ADDR                 IPU_MEMORY_OFFSET+0x0040090
#define IPU_DP_GAMMA_C_ASYNC0_7__EMPTY                IPU_MEMORY_OFFSET+0x0040090,0x00000000
#define IPU_DP_GAMMA_C_ASYNC0_7__FULL                 IPU_MEMORY_OFFSET+0x0040090,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_15 IPU_MEMORY_OFFSET+0x0040090,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_14 IPU_MEMORY_OFFSET+0x0040090,0x000001FF

#define IPU_DP_GAMMA_S_ASYNC0_0__ADDR                IPU_MEMORY_OFFSET+0x0040094
#define IPU_DP_GAMMA_S_ASYNC0_0__EMPTY               IPU_MEMORY_OFFSET+0x0040094,0x00000000
#define IPU_DP_GAMMA_S_ASYNC0_0__FULL                IPU_MEMORY_OFFSET+0x0040094,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_3 IPU_MEMORY_OFFSET+0x0040094,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_2 IPU_MEMORY_OFFSET+0x0040094,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_1 IPU_MEMORY_OFFSET+0x0040094,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_0 IPU_MEMORY_OFFSET+0x0040094,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC0_1__ADDR                IPU_MEMORY_OFFSET+0x0040098
#define IPU_DP_GAMMA_S_ASYNC0_1__EMPTY               IPU_MEMORY_OFFSET+0x0040098,0x00000000
#define IPU_DP_GAMMA_S_ASYNC0_1__FULL                IPU_MEMORY_OFFSET+0x0040098,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_7 IPU_MEMORY_OFFSET+0x0040098,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_6 IPU_MEMORY_OFFSET+0x0040098,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_5 IPU_MEMORY_OFFSET+0x0040098,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_4 IPU_MEMORY_OFFSET+0x0040098,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC0_2__ADDR                 IPU_MEMORY_OFFSET+0x004009C
#define IPU_DP_GAMMA_S_ASYNC0_2__EMPTY                IPU_MEMORY_OFFSET+0x004009C,0x00000000
#define IPU_DP_GAMMA_S_ASYNC0_2__FULL                 IPU_MEMORY_OFFSET+0x004009C,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_11 IPU_MEMORY_OFFSET+0x004009C,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_10 IPU_MEMORY_OFFSET+0x004009C,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_9  IPU_MEMORY_OFFSET+0x004009C,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_8  IPU_MEMORY_OFFSET+0x004009C,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC0_3__ADDR                 IPU_MEMORY_OFFSET+0x00400A0
#define IPU_DP_GAMMA_S_ASYNC0_3__EMPTY                IPU_MEMORY_OFFSET+0x00400A0,0x00000000
#define IPU_DP_GAMMA_S_ASYNC0_3__FULL                 IPU_MEMORY_OFFSET+0x00400A0,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_15 IPU_MEMORY_OFFSET+0x00400A0,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_14 IPU_MEMORY_OFFSET+0x00400A0,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_13 IPU_MEMORY_OFFSET+0x00400A0,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_12 IPU_MEMORY_OFFSET+0x00400A0,0x000000FF

#define IPU_DP_CSCA_ASYNC0_0__ADDR              IPU_MEMORY_OFFSET+0x00400A4
#define IPU_DP_CSCA_ASYNC0_0__EMPTY             IPU_MEMORY_OFFSET+0x00400A4,0x00000000
#define IPU_DP_CSCA_ASYNC0_0__FULL              IPU_MEMORY_OFFSET+0x00400A4,0xffffffff
#define IPU_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_1 IPU_MEMORY_OFFSET+0x00400A4,0x03FF0000
#define IPU_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_0 IPU_MEMORY_OFFSET+0x00400A4,0x000003FF

#define IPU_DP_CSCA_ASYNC0_1__ADDR              IPU_MEMORY_OFFSET+0x00400A8
#define IPU_DP_CSCA_ASYNC0_1__EMPTY             IPU_MEMORY_OFFSET+0x00400A8,0x00000000
#define IPU_DP_CSCA_ASYNC0_1__FULL              IPU_MEMORY_OFFSET+0x00400A8,0xffffffff
#define IPU_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_3 IPU_MEMORY_OFFSET+0x00400A8,0x03FF0000
#define IPU_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_2 IPU_MEMORY_OFFSET+0x00400A8,0x000003FF

#define IPU_DP_CSCA_ASYNC0_2__ADDR              IPU_MEMORY_OFFSET+0x00400AC
#define IPU_DP_CSCA_ASYNC0_2__EMPTY             IPU_MEMORY_OFFSET+0x00400AC,0x00000000
#define IPU_DP_CSCA_ASYNC0_2__FULL              IPU_MEMORY_OFFSET+0x00400AC,0xffffffff
#define IPU_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_5 IPU_MEMORY_OFFSET+0x00400AC,0x03FF0000
#define IPU_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_4 IPU_MEMORY_OFFSET+0x00400AC,0x000003FF

#define IPU_DP_CSCA_ASYNC0_3__ADDR              IPU_MEMORY_OFFSET+0x00400B0
#define IPU_DP_CSCA_ASYNC0_3__EMPTY             IPU_MEMORY_OFFSET+0x00400B0,0x00000000
#define IPU_DP_CSCA_ASYNC0_3__FULL              IPU_MEMORY_OFFSET+0x00400B0,0xffffffff
#define IPU_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_7 IPU_MEMORY_OFFSET+0x00400B0,0x03FF0000
#define IPU_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_6 IPU_MEMORY_OFFSET+0x00400B0,0x000003FF

#define IPU_DP_CSC_ASYNC0_0__ADDR             IPU_MEMORY_OFFSET+0x00400B4
#define IPU_DP_CSC_ASYNC0_0__EMPTY            IPU_MEMORY_OFFSET+0x00400B4,0x00000000
#define IPU_DP_CSC_ASYNC0_0__FULL             IPU_MEMORY_OFFSET+0x00400B4,0xffffffff
#define IPU_DP_CSC_ASYNC0_0__DP_CSC_S0_ASYNC0 IPU_MEMORY_OFFSET+0x00400B4,0xC0000000
#define IPU_DP_CSC_ASYNC0_0__DP_CSC_B0_ASYNC0 IPU_MEMORY_OFFSET+0x00400B4,0x3FFF0000
#define IPU_DP_CSC_ASYNC0_0__DP_CSC_A8_ASYNC0 IPU_MEMORY_OFFSET+0x00400B4,0x000003FF

#define IPU_DP_CSC_ASYNC0_1__ADDR             IPU_MEMORY_OFFSET+0x00400B8
#define IPU_DP_CSC_ASYNC0_1__EMPTY            IPU_MEMORY_OFFSET+0x00400B8,0x00000000
#define IPU_DP_CSC_ASYNC0_1__FULL             IPU_MEMORY_OFFSET+0x00400B8,0xffffffff
#define IPU_DP_CSC_ASYNC0_1__DP_CSC_S2_ASYNC0 IPU_MEMORY_OFFSET+0x00400B8,0xC0000000
#define IPU_DP_CSC_ASYNC0_1__DP_CSC_B2_ASYNC0 IPU_MEMORY_OFFSET+0x00400B8,0x3FFF0000
#define IPU_DP_CSC_ASYNC0_1__DP_CSC_S1_ASYNC0 IPU_MEMORY_OFFSET+0x00400B8,0x0000C000
#define IPU_DP_CSC_ASYNC0_1__DP_CSC_B1_ASYNC0 IPU_MEMORY_OFFSET+0x00400B8,0x00003FFF

#define IPU_DP_COM_CONF_ASYNC1__ADDR                       IPU_MEMORY_OFFSET+0x00400BC
#define IPU_DP_COM_CONF_ASYNC1__EMPTY                      IPU_MEMORY_OFFSET+0x00400BC,0x00000000
#define IPU_DP_COM_CONF_ASYNC1__FULL                       IPU_MEMORY_OFFSET+0x00400BC,0xffffffff
#define IPU_DP_COM_CONF_ASYNC1__DP_GAMMA_YUV_EN_ASYNC1     IPU_MEMORY_OFFSET+0x00400BC,0x00002000
#define IPU_DP_COM_CONF_ASYNC1__DP_GAMMA_EN_ASYNC1         IPU_MEMORY_OFFSET+0x00400BC,0x00001000
#define IPU_DP_COM_CONF_ASYNC1__DP_CSC_YUV_SAT_MODE_ASYNC1 IPU_MEMORY_OFFSET+0x00400BC,0x00000800
#define IPU_DP_COM_CONF_ASYNC1__DP_CSC_GAMUT_SAT_EN_ASYNC1 IPU_MEMORY_OFFSET+0x00400BC,0x00000400
#define IPU_DP_COM_CONF_ASYNC1__DP_CSC_DEF_ASYNC1          IPU_MEMORY_OFFSET+0x00400BC,0x00000300
#define IPU_DP_COM_CONF_ASYNC1__DP_COC_ASYNC1              IPU_MEMORY_OFFSET+0x00400BC,0x00000070
#define IPU_DP_COM_CONF_ASYNC1__DP_GWCKE_ASYNC1            IPU_MEMORY_OFFSET+0x00400BC,0x00000008
#define IPU_DP_COM_CONF_ASYNC1__DP_GWAM_ASYNC1             IPU_MEMORY_OFFSET+0x00400BC,0x00000004
#define IPU_DP_COM_CONF_ASYNC1__DP_GWSEL_ASYNC1            IPU_MEMORY_OFFSET+0x00400BC,0x00000002

#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__ADDR            IPU_MEMORY_OFFSET+0x00400C0
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__EMPTY           IPU_MEMORY_OFFSET+0x00400C0,0x00000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__FULL            IPU_MEMORY_OFFSET+0x00400C0,0xffffffff
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWAV_ASYNC1  IPU_MEMORY_OFFSET+0x00400C0,0xFF000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKR_ASYNC1 IPU_MEMORY_OFFSET+0x00400C0,0x00FF0000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKG_ASYNC1 IPU_MEMORY_OFFSET+0x00400C0,0x0000FF00
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKB_ASYNC1 IPU_MEMORY_OFFSET+0x00400C0,0x000000FF

#define IPU_DP_FG_POS_ASYNC1__ADDR           IPU_MEMORY_OFFSET+0x00400C4
#define IPU_DP_FG_POS_ASYNC1__EMPTY          IPU_MEMORY_OFFSET+0x00400C4,0x00000000
#define IPU_DP_FG_POS_ASYNC1__FULL           IPU_MEMORY_OFFSET+0x00400C4,0xffffffff
#define IPU_DP_FG_POS_ASYNC1__DP_FGXP_ASYNC1 IPU_MEMORY_OFFSET+0x00400C4,0x07FF0000
#define IPU_DP_FG_POS_ASYNC1__DP_FGYP_ASYNC1 IPU_MEMORY_OFFSET+0x00400C4,0x000007FF

#define IPU_DP_CUR_POS_ASYNC1__ADDR          IPU_MEMORY_OFFSET+0x00400C8
#define IPU_DP_CUR_POS_ASYNC1__EMPTY         IPU_MEMORY_OFFSET+0x00400C8,0x00000000
#define IPU_DP_CUR_POS_ASYNC1__FULL          IPU_MEMORY_OFFSET+0x00400C8,0xffffffff
#define IPU_DP_CUR_POS_ASYNC1__DP_CXW_ASYNC1 IPU_MEMORY_OFFSET+0x00400C8,0xF8000000
#define IPU_DP_CUR_POS_ASYNC1__DP_CXP_ASYNC1 IPU_MEMORY_OFFSET+0x00400C8,0x07FF0000
#define IPU_DP_CUR_POS_ASYNC1__DP_CYH_ASYNC1 IPU_MEMORY_OFFSET+0x00400C8,0x0000F800
#define IPU_DP_CUR_POS_ASYNC1__DP_CYP_ASYNC1 IPU_MEMORY_OFFSET+0x00400C8,0x000007FF

#define IPU_DP_CUR_MAP_ASYNC1__ADDR             IPU_MEMORY_OFFSET+0x00400CC
#define IPU_DP_CUR_MAP_ASYNC1__EMPTY            IPU_MEMORY_OFFSET+0x00400CC,0x00000000
#define IPU_DP_CUR_MAP_ASYNC1__FULL             IPU_MEMORY_OFFSET+0x00400CC,0xffffffff
#define IPU_DP_CUR_MAP_ASYNC1__CUR_COL_R_ASYNC1 IPU_MEMORY_OFFSET+0x00400CC,0x00FF0000
#define IPU_DP_CUR_MAP_ASYNC1__CUR_COL_G_ASYNC1 IPU_MEMORY_OFFSET+0x00400CC,0x0000FF00
#define IPU_DP_CUR_MAP_ASYNC1__CUR_COL_B_ASYNC1 IPU_MEMORY_OFFSET+0x00400CC,0x000000FF

#define IPU_DP_GAMMA_C_ASYNC1_0__ADDR                IPU_MEMORY_OFFSET+0x00400D0
#define IPU_DP_GAMMA_C_ASYNC1_0__EMPTY               IPU_MEMORY_OFFSET+0x00400D0,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_0__FULL                IPU_MEMORY_OFFSET+0x00400D0,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_1 IPU_MEMORY_OFFSET+0x00400D0,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_0 IPU_MEMORY_OFFSET+0x00400D0,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_1__ADDR                IPU_MEMORY_OFFSET+0x00400D4
#define IPU_DP_GAMMA_C_ASYNC1_1__EMPTY               IPU_MEMORY_OFFSET+0x00400D4,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_1__FULL                IPU_MEMORY_OFFSET+0x00400D4,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_3 IPU_MEMORY_OFFSET+0x00400D4,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_2 IPU_MEMORY_OFFSET+0x00400D4,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_2__ADDR                IPU_MEMORY_OFFSET+0x00400D8
#define IPU_DP_GAMMA_C_ASYNC1_2__EMPTY               IPU_MEMORY_OFFSET+0x00400D8,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_2__FULL                IPU_MEMORY_OFFSET+0x00400D8,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_5 IPU_MEMORY_OFFSET+0x00400D8,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_4 IPU_MEMORY_OFFSET+0x00400D8,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_3__ADDR                IPU_MEMORY_OFFSET+0x00400DC
#define IPU_DP_GAMMA_C_ASYNC1_3__EMPTY               IPU_MEMORY_OFFSET+0x00400DC,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_3__FULL                IPU_MEMORY_OFFSET+0x00400DC,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_7 IPU_MEMORY_OFFSET+0x00400DC,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_6 IPU_MEMORY_OFFSET+0x00400DC,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_4__ADDR                IPU_MEMORY_OFFSET+0x00400E0
#define IPU_DP_GAMMA_C_ASYNC1_4__EMPTY               IPU_MEMORY_OFFSET+0x00400E0,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_4__FULL                IPU_MEMORY_OFFSET+0x00400E0,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_9 IPU_MEMORY_OFFSET+0x00400E0,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_8 IPU_MEMORY_OFFSET+0x00400E0,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_5__ADDR                 IPU_MEMORY_OFFSET+0x00400E4
#define IPU_DP_GAMMA_C_ASYNC1_5__EMPTY                IPU_MEMORY_OFFSET+0x00400E4,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_5__FULL                 IPU_MEMORY_OFFSET+0x00400E4,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_11 IPU_MEMORY_OFFSET+0x00400E4,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_10 IPU_MEMORY_OFFSET+0x00400E4,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_6__ADDR                 IPU_MEMORY_OFFSET+0x00400E8
#define IPU_DP_GAMMA_C_ASYNC1_6__EMPTY                IPU_MEMORY_OFFSET+0x00400E8,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_6__FULL                 IPU_MEMORY_OFFSET+0x00400E8,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_13 IPU_MEMORY_OFFSET+0x00400E8,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_12 IPU_MEMORY_OFFSET+0x00400E8,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC1_7__ADDR                 IPU_MEMORY_OFFSET+0x00400EC
#define IPU_DP_GAMMA_C_ASYNC1_7__EMPTY                IPU_MEMORY_OFFSET+0x00400EC,0x00000000
#define IPU_DP_GAMMA_C_ASYNC1_7__FULL                 IPU_MEMORY_OFFSET+0x00400EC,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_15 IPU_MEMORY_OFFSET+0x00400EC,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_14 IPU_MEMORY_OFFSET+0x00400EC,0x000001FF

#define IPU_DP_GAMMA_S_ASYNC1_0__ADDR                IPU_MEMORY_OFFSET+0x00400F0
#define IPU_DP_GAMMA_S_ASYNC1_0__EMPTY               IPU_MEMORY_OFFSET+0x00400F0,0x00000000
#define IPU_DP_GAMMA_S_ASYNC1_0__FULL                IPU_MEMORY_OFFSET+0x00400F0,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_3 IPU_MEMORY_OFFSET+0x00400F0,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_2 IPU_MEMORY_OFFSET+0x00400F0,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_1 IPU_MEMORY_OFFSET+0x00400F0,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_0 IPU_MEMORY_OFFSET+0x00400F0,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC1_1__ADDR                IPU_MEMORY_OFFSET+0x00400F4
#define IPU_DP_GAMMA_S_ASYNC1_1__EMPTY               IPU_MEMORY_OFFSET+0x00400F4,0x00000000
#define IPU_DP_GAMMA_S_ASYNC1_1__FULL                IPU_MEMORY_OFFSET+0x00400F4,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_7 IPU_MEMORY_OFFSET+0x00400F4,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_6 IPU_MEMORY_OFFSET+0x00400F4,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_5 IPU_MEMORY_OFFSET+0x00400F4,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_4 IPU_MEMORY_OFFSET+0x00400F4,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC1_2__ADDR                 IPU_MEMORY_OFFSET+0x00400F8
#define IPU_DP_GAMMA_S_ASYNC1_2__EMPTY                IPU_MEMORY_OFFSET+0x00400F8,0x00000000
#define IPU_DP_GAMMA_S_ASYNC1_2__FULL                 IPU_MEMORY_OFFSET+0x00400F8,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_11 IPU_MEMORY_OFFSET+0x00400F8,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_10 IPU_MEMORY_OFFSET+0x00400F8,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_9  IPU_MEMORY_OFFSET+0x00400F8,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_8  IPU_MEMORY_OFFSET+0x00400F8,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC1_3__ADDR                 IPU_MEMORY_OFFSET+0x00400FC
#define IPU_DP_GAMMA_S_ASYNC1_3__EMPTY                IPU_MEMORY_OFFSET+0x00400FC,0x00000000
#define IPU_DP_GAMMA_S_ASYNC1_3__FULL                 IPU_MEMORY_OFFSET+0x00400FC,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_15 IPU_MEMORY_OFFSET+0x00400FC,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_14 IPU_MEMORY_OFFSET+0x00400FC,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_13 IPU_MEMORY_OFFSET+0x00400FC,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_12 IPU_MEMORY_OFFSET+0x00400FC,0x000000FF

#define IPU_DP_CSCA_ASYNC1_0__ADDR              IPU_MEMORY_OFFSET+0x0040100
#define IPU_DP_CSCA_ASYNC1_0__EMPTY             IPU_MEMORY_OFFSET+0x0040100,0x00000000
#define IPU_DP_CSCA_ASYNC1_0__FULL              IPU_MEMORY_OFFSET+0x0040100,0xffffffff
#define IPU_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_1 IPU_MEMORY_OFFSET+0x0040100,0x03FF0000
#define IPU_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_0 IPU_MEMORY_OFFSET+0x0040100,0x000003FF

#define IPU_DP_CSCA_ASYNC1_1__ADDR              IPU_MEMORY_OFFSET+0x0040104
#define IPU_DP_CSCA_ASYNC1_1__EMPTY             IPU_MEMORY_OFFSET+0x0040104,0x00000000
#define IPU_DP_CSCA_ASYNC1_1__FULL              IPU_MEMORY_OFFSET+0x0040104,0xffffffff
#define IPU_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_3 IPU_MEMORY_OFFSET+0x0040104,0x03FF0000
#define IPU_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_2 IPU_MEMORY_OFFSET+0x0040104,0x000003FF

#define IPU_DP_CSCA_ASYNC1_2__ADDR              IPU_MEMORY_OFFSET+0x0040108
#define IPU_DP_CSCA_ASYNC1_2__EMPTY             IPU_MEMORY_OFFSET+0x0040108,0x00000000
#define IPU_DP_CSCA_ASYNC1_2__FULL              IPU_MEMORY_OFFSET+0x0040108,0xffffffff
#define IPU_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_5 IPU_MEMORY_OFFSET+0x0040108,0x03FF0000
#define IPU_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_4 IPU_MEMORY_OFFSET+0x0040108,0x000003FF

#define IPU_DP_CSCA_ASYNC1_3__ADDR              IPU_MEMORY_OFFSET+0x004010C
#define IPU_DP_CSCA_ASYNC1_3__EMPTY             IPU_MEMORY_OFFSET+0x004010C,0x00000000
#define IPU_DP_CSCA_ASYNC1_3__FULL              IPU_MEMORY_OFFSET+0x004010C,0xffffffff
#define IPU_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_7 IPU_MEMORY_OFFSET+0x004010C,0x03FF0000
#define IPU_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_6 IPU_MEMORY_OFFSET+0x004010C,0x000003FF

#define IPU_DP_CSC_ASYNC1_0__ADDR             IPU_MEMORY_OFFSET+0x0040110
#define IPU_DP_CSC_ASYNC1_0__EMPTY            IPU_MEMORY_OFFSET+0x0040110,0x00000000
#define IPU_DP_CSC_ASYNC1_0__FULL             IPU_MEMORY_OFFSET+0x0040110,0xffffffff
#define IPU_DP_CSC_ASYNC1_0__DP_CSC_S0_ASYNC1 IPU_MEMORY_OFFSET+0x0040110,0xC0000000
#define IPU_DP_CSC_ASYNC1_0__DP_CSC_B0_ASYNC1 IPU_MEMORY_OFFSET+0x0040110,0x3FFF0000
#define IPU_DP_CSC_ASYNC1_0__DP_CSC_A8_ASYNC1 IPU_MEMORY_OFFSET+0x0040110,0x000003FF

#define IPU_DP_CSC_ASYNC1_1__ADDR             IPU_MEMORY_OFFSET+0x0040114
#define IPU_DP_CSC_ASYNC1_1__EMPTY            IPU_MEMORY_OFFSET+0x0040114,0x00000000
#define IPU_DP_CSC_ASYNC1_1__FULL             IPU_MEMORY_OFFSET+0x0040114,0xffffffff
#define IPU_DP_CSC_ASYNC1_1__DP_CSC_S2_ASYNC1 IPU_MEMORY_OFFSET+0x0040114,0xC0000000
#define IPU_DP_CSC_ASYNC1_1__DP_CSC_B2_ASYNC1 IPU_MEMORY_OFFSET+0x0040114,0x3FFF0000
#define IPU_DP_CSC_ASYNC1_1__DP_CSC_S1_ASYNC1 IPU_MEMORY_OFFSET+0x0040114,0x0000C000
#define IPU_DP_CSC_ASYNC1_1__DP_CSC_B1_ASYNC1 IPU_MEMORY_OFFSET+0x0040114,0x00003FFF

#define IPU_DP_DEBUG_CNT__ADDR              IPU_REGISTERS_OFFSET+0x000180BC
#define IPU_DP_DEBUG_CNT__EMPTY             IPU_REGISTERS_OFFSET+0x000180BC,0x00000000
#define IPU_DP_DEBUG_CNT__FULL              IPU_REGISTERS_OFFSET+0x000180BC,0xffffffff
#define IPU_DP_DEBUG_CNT__BRAKE_CNT_1       IPU_REGISTERS_OFFSET+0x000180BC,0x000000E0
#define IPU_DP_DEBUG_CNT__BRAKE_STATUS_EN_1 IPU_REGISTERS_OFFSET+0x000180BC,0x00000010
#define IPU_DP_DEBUG_CNT__BRAKE_CNT_0       IPU_REGISTERS_OFFSET+0x000180BC,0x0000000E
#define IPU_DP_DEBUG_CNT__BRAKE_STATUS_EN_0 IPU_REGISTERS_OFFSET+0x000180BC,0x00000001

#define IPU_DP_DEBUG_STAT__ADDR            IPU_REGISTERS_OFFSET+0x000180C0
#define IPU_DP_DEBUG_STAT__EMPTY           IPU_REGISTERS_OFFSET+0x000180C0,0x00000000
#define IPU_DP_DEBUG_STAT__FULL            IPU_REGISTERS_OFFSET+0x000180C0,0xffffffff
#define IPU_DP_DEBUG_STAT__CYP_EN_OLD_1    IPU_REGISTERS_OFFSET+0x000180C0,0x20000000
#define IPU_DP_DEBUG_STAT__COMBYP_EN_OLD_1 IPU_REGISTERS_OFFSET+0x000180C0,0x10000000
#define IPU_DP_DEBUG_STAT__FG_ACTIVE_1     IPU_REGISTERS_OFFSET+0x000180C0,0x08000000
#define IPU_DP_DEBUG_STAT__V_CNT_OLD_1     IPU_REGISTERS_OFFSET+0x000180C0,0x07FF0000
#define IPU_DP_DEBUG_STAT__CYP_EN_OLD_0    IPU_REGISTERS_OFFSET+0x000180C0,0x00002000
#define IPU_DP_DEBUG_STAT__COMBYP_EN_OLD_0 IPU_REGISTERS_OFFSET+0x000180C0,0x00001000
#define IPU_DP_DEBUG_STAT__FG_ACTIVE_0     IPU_REGISTERS_OFFSET+0x000180C0,0x00000800
#define IPU_DP_DEBUG_STAT__V_CNT_OLD_0     IPU_REGISTERS_OFFSET+0x000180C0,0x000007FF

#define IPU_IC_CONF__ADDR            IPU_REGISTERS_OFFSET+0x00020000
#define IPU_IC_CONF__EMPTY           IPU_REGISTERS_OFFSET+0x00020000,0x00000000
#define IPU_IC_CONF__FULL            IPU_REGISTERS_OFFSET+0x00020000,0xffffffff
#define IPU_IC_CONF__CSI_MEM_WR_EN   IPU_REGISTERS_OFFSET+0x00020000,0x80000000
#define IPU_IC_CONF__RWS_EN          IPU_REGISTERS_OFFSET+0x00020000,0x40000000
#define IPU_IC_CONF__IC_KEY_COLOR_EN IPU_REGISTERS_OFFSET+0x00020000,0x20000000
#define IPU_IC_CONF__IC_GLB_LOC_A    IPU_REGISTERS_OFFSET+0x00020000,0x10000000
#define IPU_IC_CONF__PP_ROT_EN       IPU_REGISTERS_OFFSET+0x00020000,0x00100000
#define IPU_IC_CONF__PP_CMB          IPU_REGISTERS_OFFSET+0x00020000,0x00080000
#define IPU_IC_CONF__PP_CSC2         IPU_REGISTERS_OFFSET+0x00020000,0x00040000
#define IPU_IC_CONF__PP_CSC1         IPU_REGISTERS_OFFSET+0x00020000,0x00020000
#define IPU_IC_CONF__PP_EN           IPU_REGISTERS_OFFSET+0x00020000,0x00010000
#define IPU_IC_CONF__PRPVF_ROT_EN    IPU_REGISTERS_OFFSET+0x00020000,0x00001000
#define IPU_IC_CONF__PRPVF_CMB       IPU_REGISTERS_OFFSET+0x00020000,0x00000800
#define IPU_IC_CONF__PRPVF_CSC2      IPU_REGISTERS_OFFSET+0x00020000,0x00000400
#define IPU_IC_CONF__PRPVF_CSC1      IPU_REGISTERS_OFFSET+0x00020000,0x00000200
#define IPU_IC_CONF__PRPVF_EN        IPU_REGISTERS_OFFSET+0x00020000,0x00000100
#define IPU_IC_CONF__PRPENC_ROT_EN   IPU_REGISTERS_OFFSET+0x00020000,0x00000004
#define IPU_IC_CONF__PRPENC_CSC1     IPU_REGISTERS_OFFSET+0x00020000,0x00000002
#define IPU_IC_CONF__PRPENC_EN       IPU_REGISTERS_OFFSET+0x00020000,0x00000001

#define IPU_IC_PRP_ENC_RSC__ADDR          IPU_REGISTERS_OFFSET+0x00020004
#define IPU_IC_PRP_ENC_RSC__EMPTY         IPU_REGISTERS_OFFSET+0x00020004,0x00000000
#define IPU_IC_PRP_ENC_RSC__FULL          IPU_REGISTERS_OFFSET+0x00020004,0xffffffff
#define IPU_IC_PRP_ENC_RSC__PRPENC_DS_R_V IPU_REGISTERS_OFFSET+0x00020004,0xC0000000
#define IPU_IC_PRP_ENC_RSC__PRPENC_RS_R_V IPU_REGISTERS_OFFSET+0x00020004,0x3FFF0000
#define IPU_IC_PRP_ENC_RSC__PRPENC_DS_R_H IPU_REGISTERS_OFFSET+0x00020004,0x0000C000
#define IPU_IC_PRP_ENC_RSC__PRPENC_RS_R_H IPU_REGISTERS_OFFSET+0x00020004,0x00003FFF

#define IPU_IC_PRP_VF_RSC__ADDR         IPU_REGISTERS_OFFSET+0x00020008
#define IPU_IC_PRP_VF_RSC__EMPTY        IPU_REGISTERS_OFFSET+0x00020008,0x00000000
#define IPU_IC_PRP_VF_RSC__FULL         IPU_REGISTERS_OFFSET+0x00020008,0xffffffff
#define IPU_IC_PRP_VF_RSC__PRPVF_DS_R_V IPU_REGISTERS_OFFSET+0x00020008,0xC0000000
#define IPU_IC_PRP_VF_RSC__PRPVF_RS_R_V IPU_REGISTERS_OFFSET+0x00020008,0x3FFF0000
#define IPU_IC_PRP_VF_RSC__PRPVF_DS_R_H IPU_REGISTERS_OFFSET+0x00020008,0x0000C000
#define IPU_IC_PRP_VF_RSC__PRPVF_RS_R_H IPU_REGISTERS_OFFSET+0x00020008,0x00003FFF

#define IPU_IC_PP_RSC__ADDR      IPU_REGISTERS_OFFSET+0x0002000C
#define IPU_IC_PP_RSC__EMPTY     IPU_REGISTERS_OFFSET+0x0002000C,0x00000000
#define IPU_IC_PP_RSC__FULL      IPU_REGISTERS_OFFSET+0x0002000C,0xffffffff
#define IPU_IC_PP_RSC__PP_DS_R_V IPU_REGISTERS_OFFSET+0x0002000C,0xC0000000
#define IPU_IC_PP_RSC__PP_RS_R_V IPU_REGISTERS_OFFSET+0x0002000C,0x3FFF0000
#define IPU_IC_PP_RSC__PP_DS_R_H IPU_REGISTERS_OFFSET+0x0002000C,0x0000C000
#define IPU_IC_PP_RSC__PP_RS_R_H IPU_REGISTERS_OFFSET+0x0002000C,0x00003FFF

#define IPU_IC_CMBP_1__ADDR             IPU_REGISTERS_OFFSET+0x00020010
#define IPU_IC_CMBP_1__EMPTY            IPU_REGISTERS_OFFSET+0x00020010,0x00000000
#define IPU_IC_CMBP_1__FULL             IPU_REGISTERS_OFFSET+0x00020010,0xffffffff
#define IPU_IC_CMBP_1__IC_PP_ALPHA_V    IPU_REGISTERS_OFFSET+0x00020010,0x0000FF00
#define IPU_IC_CMBP_1__IC_PRPVF_ALPHA_V IPU_REGISTERS_OFFSET+0x00020010,0x000000FF

#define IPU_IC_CMBP_2__ADDR           IPU_REGISTERS_OFFSET+0x00020014
#define IPU_IC_CMBP_2__EMPTY          IPU_REGISTERS_OFFSET+0x00020014,0x00000000
#define IPU_IC_CMBP_2__FULL           IPU_REGISTERS_OFFSET+0x00020014,0xffffffff
#define IPU_IC_CMBP_2__IC_KEY_COLOR_R IPU_REGISTERS_OFFSET+0x00020014,0x00FF0000
#define IPU_IC_CMBP_2__IC_KEY_COLOR_G IPU_REGISTERS_OFFSET+0x00020014,0x0000FF00
#define IPU_IC_CMBP_2__IC_KEY_COLOR_B IPU_REGISTERS_OFFSET+0x00020014,0x000000FF

#define IPU_IC_IDMAC_1__ADDR             IPU_REGISTERS_OFFSET+0x00020018
#define IPU_IC_IDMAC_1__EMPTY            IPU_REGISTERS_OFFSET+0x00020018,0x00000000
#define IPU_IC_IDMAC_1__FULL             IPU_REGISTERS_OFFSET+0x00020018,0xffffffff
#define IPU_IC_IDMAC_1__ALT_CB7_BURST_16 IPU_REGISTERS_OFFSET+0x00020018,0x02000000
#define IPU_IC_IDMAC_1__ALT_CB6_BURST_16 IPU_REGISTERS_OFFSET+0x00020018,0x01000000
#define IPU_IC_IDMAC_1__T3_FLIP_RS       IPU_REGISTERS_OFFSET+0x00020018,0x00400000
#define IPU_IC_IDMAC_1__T2_FLIP_RS       IPU_REGISTERS_OFFSET+0x00020018,0x00200000
#define IPU_IC_IDMAC_1__T1_FLIP_RS       IPU_REGISTERS_OFFSET+0x00020018,0x00100000
#define IPU_IC_IDMAC_1__T3_FLIP_UD       IPU_REGISTERS_OFFSET+0x00020018,0x00080000
#define IPU_IC_IDMAC_1__T3_FLIP_LR       IPU_REGISTERS_OFFSET+0x00020018,0x00040000
#define IPU_IC_IDMAC_1__T3_ROT           IPU_REGISTERS_OFFSET+0x00020018,0x00020000
#define IPU_IC_IDMAC_1__T2_FLIP_UD       IPU_REGISTERS_OFFSET+0x00020018,0x00010000
#define IPU_IC_IDMAC_1__T2_FLIP_LR       IPU_REGISTERS_OFFSET+0x00020018,0x00008000
#define IPU_IC_IDMAC_1__T2_ROT           IPU_REGISTERS_OFFSET+0x00020018,0x00004000
#define IPU_IC_IDMAC_1__T1_FLIP_UD       IPU_REGISTERS_OFFSET+0x00020018,0x00002000
#define IPU_IC_IDMAC_1__T1_FLIP_LR       IPU_REGISTERS_OFFSET+0x00020018,0x00001000
#define IPU_IC_IDMAC_1__T1_ROT           IPU_REGISTERS_OFFSET+0x00020018,0x00000800
#define IPU_IC_IDMAC_1__CB7_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000080
#define IPU_IC_IDMAC_1__CB6_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000040
#define IPU_IC_IDMAC_1__CB5_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000020
#define IPU_IC_IDMAC_1__CB4_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000010
#define IPU_IC_IDMAC_1__CB3_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000008
#define IPU_IC_IDMAC_1__CB2_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000004
#define IPU_IC_IDMAC_1__CB1_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000002
#define IPU_IC_IDMAC_1__CB0_BURST_16     IPU_REGISTERS_OFFSET+0x00020018,0x00000001

#define IPU_IC_IDMAC_2__ADDR         IPU_REGISTERS_OFFSET+0x0002001C
#define IPU_IC_IDMAC_2__EMPTY        IPU_REGISTERS_OFFSET+0x0002001C,0x00000000
#define IPU_IC_IDMAC_2__FULL         IPU_REGISTERS_OFFSET+0x0002001C,0xffffffff
#define IPU_IC_IDMAC_2__T3_FR_HEIGHT IPU_REGISTERS_OFFSET+0x0002001C,0x3FF00000
#define IPU_IC_IDMAC_2__T2_FR_HEIGHT IPU_REGISTERS_OFFSET+0x0002001C,0x000FFC00
#define IPU_IC_IDMAC_2__T1_FR_HEIGHT IPU_REGISTERS_OFFSET+0x0002001C,0x000003FF

#define IPU_IC_IDMAC_3__ADDR        IPU_REGISTERS_OFFSET+0x00020020
#define IPU_IC_IDMAC_3__EMPTY       IPU_REGISTERS_OFFSET+0x00020020,0x00000000
#define IPU_IC_IDMAC_3__FULL        IPU_REGISTERS_OFFSET+0x00020020,0xffffffff
#define IPU_IC_IDMAC_3__T3_FR_WIDTH IPU_REGISTERS_OFFSET+0x00020020,0x3FF00000
#define IPU_IC_IDMAC_3__T2_FR_WIDTH IPU_REGISTERS_OFFSET+0x00020020,0x000FFC00
#define IPU_IC_IDMAC_3__T1_FR_WIDTH IPU_REGISTERS_OFFSET+0x00020020,0x000003FF

#define IPU_IC_IDMAC_4__ADDR                 IPU_REGISTERS_OFFSET+0x00020024
#define IPU_IC_IDMAC_4__EMPTY                IPU_REGISTERS_OFFSET+0x00020024,0x00000000
#define IPU_IC_IDMAC_4__FULL                 IPU_REGISTERS_OFFSET+0x00020024,0xffffffff
#define IPU_IC_IDMAC_4__RM_BRDG_MAX_RQ       IPU_REGISTERS_OFFSET+0x00020024,0x0000F000
#define IPU_IC_IDMAC_4__IBM_BRDG_MAX_RQ      IPU_REGISTERS_OFFSET+0x00020024,0x00000F00
#define IPU_IC_IDMAC_4__MPM_DMFC_BRDG_MAX_RQ IPU_REGISTERS_OFFSET+0x00020024,0x000000F0
#define IPU_IC_IDMAC_4__MPM_RW_BRDG_MAX_RQ   IPU_REGISTERS_OFFSET+0x00020024,0x0000000F

#define IPU_CSI0_SENS_CONF__ADDR                  IPU_REGISTERS_OFFSET+0x00030000
#define IPU_CSI0_SENS_CONF__EMPTY                 IPU_REGISTERS_OFFSET+0x00030000,0x00000000
#define IPU_CSI0_SENS_CONF__FULL                  IPU_REGISTERS_OFFSET+0x00030000,0xffffffff
#define IPU_CSI0_SENS_CONF__CSI0_DATA_EN_POL      IPU_REGISTERS_OFFSET+0x00030000,0x80000000
#define IPU_CSI0_SENS_CONF__CSI0_FORCE_EOF        IPU_REGISTERS_OFFSET+0x00030000,0x20000000
#define IPU_CSI0_SENS_CONF__CSI0_JPEG_MODE        IPU_REGISTERS_OFFSET+0x00030000,0x10000000
#define IPU_CSI0_SENS_CONF__CSI0_JPEG8_EN         IPU_REGISTERS_OFFSET+0x00030000,0x08000000
#define IPU_CSI0_SENS_CONF__CSI0_DATA_DEST        IPU_REGISTERS_OFFSET+0x00030000,0x07000000
#define IPU_CSI0_SENS_CONF__CSI0_DIV_RATIO        IPU_REGISTERS_OFFSET+0x00030000,0x00FF0000
#define IPU_CSI0_SENS_CONF__CSI0_EXT_VSYNC        IPU_REGISTERS_OFFSET+0x00030000,0x00008000
#define IPU_CSI0_SENS_CONF__CSI0_DATA_WIDTH       IPU_REGISTERS_OFFSET+0x00030000,0x00007800
#define IPU_CSI0_SENS_CONF__CSI0_SENS_DATA_FORMAT IPU_REGISTERS_OFFSET+0x00030000,0x00000700
#define IPU_CSI0_SENS_CONF__CSI0_PACK_TIGHT       IPU_REGISTERS_OFFSET+0x00030000,0x00000080
#define IPU_CSI0_SENS_CONF__CSI0_SENS_PRTCL       IPU_REGISTERS_OFFSET+0x00030000,0x00000070
#define IPU_CSI0_SENS_CONF__CSI0_SENS_PIX_CLK_POL IPU_REGISTERS_OFFSET+0x00030000,0x00000008
#define IPU_CSI0_SENS_CONF__CSI0_DATA_POL         IPU_REGISTERS_OFFSET+0x00030000,0x00000004
#define IPU_CSI0_SENS_CONF__CSI0_HSYNC_POL        IPU_REGISTERS_OFFSET+0x00030000,0x00000002
#define IPU_CSI0_SENS_CONF__CSI0_VSYNC_POL        IPU_REGISTERS_OFFSET+0x00030000,0x00000001

#define IPU_CSI0_SENS_FRM_SIZE__ADDR                 IPU_REGISTERS_OFFSET+0x00030004
#define IPU_CSI0_SENS_FRM_SIZE__EMPTY                IPU_REGISTERS_OFFSET+0x00030004,0x00000000
#define IPU_CSI0_SENS_FRM_SIZE__FULL                 IPU_REGISTERS_OFFSET+0x00030004,0xffffffff
#define IPU_CSI0_SENS_FRM_SIZE__CSI0_SENS_FRM_HEIGHT IPU_REGISTERS_OFFSET+0x00030004,0x0FFF0000
#define IPU_CSI0_SENS_FRM_SIZE__CSI0_SENS_FRM_WIDTH  IPU_REGISTERS_OFFSET+0x00030004,0x00001FFF

#define IPU_CSI0_ACT_FRM_SIZE__ADDR                IPU_REGISTERS_OFFSET+0x00030008
#define IPU_CSI0_ACT_FRM_SIZE__EMPTY               IPU_REGISTERS_OFFSET+0x00030008,0x00000000
#define IPU_CSI0_ACT_FRM_SIZE__FULL                IPU_REGISTERS_OFFSET+0x00030008,0xffffffff
#define IPU_CSI0_ACT_FRM_SIZE__CSI0_ACT_FRM_HEIGHT IPU_REGISTERS_OFFSET+0x00030008,0x0FFF0000
#define IPU_CSI0_ACT_FRM_SIZE__CSI0_ACT_FRM_WIDTH  IPU_REGISTERS_OFFSET+0x00030008,0x00001FFF

#define IPU_CSI0_OUT_FRM_CTRL__ADDR           IPU_REGISTERS_OFFSET+0x0003000C
#define IPU_CSI0_OUT_FRM_CTRL__EMPTY          IPU_REGISTERS_OFFSET+0x0003000C,0x00000000
#define IPU_CSI0_OUT_FRM_CTRL__FULL           IPU_REGISTERS_OFFSET+0x0003000C,0xffffffff
#define IPU_CSI0_OUT_FRM_CTRL__CSI0_HORZ_DWNS IPU_REGISTERS_OFFSET+0x0003000C,0x80000000
#define IPU_CSI0_OUT_FRM_CTRL__CSI0_VERT_DWNS IPU_REGISTERS_OFFSET+0x0003000C,0x40000000
#define IPU_CSI0_OUT_FRM_CTRL__CSI0_HSC       IPU_REGISTERS_OFFSET+0x0003000C,0x1FFF0000
#define IPU_CSI0_OUT_FRM_CTRL__CSI0_VSC       IPU_REGISTERS_OFFSET+0x0003000C,0x00000FFF

#define IPU_CSI0_TST_CTRL__ADDR               IPU_REGISTERS_OFFSET+0x00030010
#define IPU_CSI0_TST_CTRL__EMPTY              IPU_REGISTERS_OFFSET+0x00030010,0x00000000
#define IPU_CSI0_TST_CTRL__FULL               IPU_REGISTERS_OFFSET+0x00030010,0xffffffff
#define IPU_CSI0_TST_CTRL__CSI0_TEST_GEN_MODE IPU_REGISTERS_OFFSET+0x00030010,0x01000000
#define IPU_CSI0_TST_CTRL__CSI0_PG_B_VALUE    IPU_REGISTERS_OFFSET+0x00030010,0x00FF0000
#define IPU_CSI0_TST_CTRL__CSI0_PG_G_VALUE    IPU_REGISTERS_OFFSET+0x00030010,0x0000FF00
#define IPU_CSI0_TST_CTRL__CSI0_PG_R_VALUE    IPU_REGISTERS_OFFSET+0x00030010,0x000000FF

#define IPU_CSI0_CCIR_CODE_1__ADDR                    IPU_REGISTERS_OFFSET+0x00030014
#define IPU_CSI0_CCIR_CODE_1__EMPTY                   IPU_REGISTERS_OFFSET+0x00030014,0x00000000
#define IPU_CSI0_CCIR_CODE_1__FULL                    IPU_REGISTERS_OFFSET+0x00030014,0xffffffff
#define IPU_CSI0_CCIR_CODE_1__CSI0_CCIR_ERR_DET_EN    IPU_REGISTERS_OFFSET+0x00030014,0x01000000
#define IPU_CSI0_CCIR_CODE_1__CSI0_STRT_FLD0_ACTV     IPU_REGISTERS_OFFSET+0x00030014,0x00380000
#define IPU_CSI0_CCIR_CODE_1__CSI0_END_FLD0_ACTV      IPU_REGISTERS_OFFSET+0x00030014,0x00070000
#define IPU_CSI0_CCIR_CODE_1__CSI0_STRT_FLD0_BLNK_2ND IPU_REGISTERS_OFFSET+0x00030014,0x00000E00
#define IPU_CSI0_CCIR_CODE_1__CSI0_END_FLD0_BLNK_2ND  IPU_REGISTERS_OFFSET+0x00030014,0x000001C0
#define IPU_CSI0_CCIR_CODE_1__CSI0_STRT_FLD0_BLNK_1ST IPU_REGISTERS_OFFSET+0x00030014,0x00000038
#define IPU_CSI0_CCIR_CODE_1__CSI0_END_FLD0_BLNK_1ST  IPU_REGISTERS_OFFSET+0x00030014,0x00000007

#define IPU_CSI0_CCIR_CODE_2__ADDR                    IPU_REGISTERS_OFFSET+0x00030018
#define IPU_CSI0_CCIR_CODE_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00030018,0x00000000
#define IPU_CSI0_CCIR_CODE_2__FULL                    IPU_REGISTERS_OFFSET+0x00030018,0xffffffff
#define IPU_CSI0_CCIR_CODE_2__CSI0_STRT_FLD1_ACTV     IPU_REGISTERS_OFFSET+0x00030018,0x00380000
#define IPU_CSI0_CCIR_CODE_2__CSI0_END_FLD1_ACTV      IPU_REGISTERS_OFFSET+0x00030018,0x00070000
#define IPU_CSI0_CCIR_CODE_2__CSI0_STRT_FLD1_BLNK_2ND IPU_REGISTERS_OFFSET+0x00030018,0x00000E00
#define IPU_CSI0_CCIR_CODE_2__CSI0_END_FLD1_BLNK_2ND  IPU_REGISTERS_OFFSET+0x00030018,0x000001C0
#define IPU_CSI0_CCIR_CODE_2__CSI0_STRT_FLD1_BLNK_1ST IPU_REGISTERS_OFFSET+0x00030018,0x00000038
#define IPU_CSI0_CCIR_CODE_2__CSI0_END_FLD1_BLNK_1ST  IPU_REGISTERS_OFFSET+0x00030018,0x00000007

#define IPU_CSI0_CCIR_CODE_3__ADDR             IPU_REGISTERS_OFFSET+0x0003001C
#define IPU_CSI0_CCIR_CODE_3__EMPTY            IPU_REGISTERS_OFFSET+0x0003001C,0x00000000
#define IPU_CSI0_CCIR_CODE_3__FULL             IPU_REGISTERS_OFFSET+0x0003001C,0xffffffff
#define IPU_CSI0_CCIR_CODE_3__CSI0_CCIR_PRECOM IPU_REGISTERS_OFFSET+0x0003001C,0x3FFFFFFF

#define IPU_CSI0_DI__ADDR          IPU_REGISTERS_OFFSET+0x00030020
#define IPU_CSI0_DI__EMPTY         IPU_REGISTERS_OFFSET+0x00030020,0x00000000
#define IPU_CSI0_DI__FULL          IPU_REGISTERS_OFFSET+0x00030020,0xffffffff
#define IPU_CSI0_DI__CSI0_MIPI_DI3 IPU_REGISTERS_OFFSET+0x00030020,0xFF000000
#define IPU_CSI0_DI__CSI0_MIPI_DI2 IPU_REGISTERS_OFFSET+0x00030020,0x00FF0000
#define IPU_CSI0_DI__CSI0_MIPI_DI1 IPU_REGISTERS_OFFSET+0x00030020,0x0000FF00
#define IPU_CSI0_DI__CSI0_MIPI_DI0 IPU_REGISTERS_OFFSET+0x00030020,0x000000FF

#define IPU_CSI0_SKIP__ADDR                     IPU_REGISTERS_OFFSET+0x00030024
#define IPU_CSI0_SKIP__EMPTY                    IPU_REGISTERS_OFFSET+0x00030024,0x00000000
#define IPU_CSI0_SKIP__FULL                     IPU_REGISTERS_OFFSET+0x00030024,0xffffffff
#define IPU_CSI0_SKIP__CSI0_SKIP_ISP            IPU_REGISTERS_OFFSET+0x00030024,0x00F80000
#define IPU_CSI0_SKIP__CSI0_MAX_RATIO_SKIP_ISP  IPU_REGISTERS_OFFSET+0x00030024,0x00070000
#define IPU_CSI0_SKIP__CSI0_ID_2_SKIP           IPU_REGISTERS_OFFSET+0x00030024,0x00000300
#define IPU_CSI0_SKIP__CSI0_SKIP_SMFC           IPU_REGISTERS_OFFSET+0x00030024,0x000000F8
#define IPU_CSI0_SKIP__CSI0_MAX_RATIO_SKIP_SMFC IPU_REGISTERS_OFFSET+0x00030024,0x00000007

#define IPU_CSI0_CPD_CTRL__ADDR               IPU_REGISTERS_OFFSET+0x00030028
#define IPU_CSI0_CPD_CTRL__EMPTY              IPU_REGISTERS_OFFSET+0x00030028,0x00000000
#define IPU_CSI0_CPD_CTRL__FULL               IPU_REGISTERS_OFFSET+0x00030028,0xffffffff
#define IPU_CSI0_CPD_CTRL__CSI0_CPD           IPU_REGISTERS_OFFSET+0x00030028,0x0000001C
#define IPU_CSI0_CPD_CTRL__CSI0_RED_ROW_BEGIN IPU_REGISTERS_OFFSET+0x00030028,0x00000002
#define IPU_CSI0_CPD_CTRL__CSI0_GREEN_P_BEGIN IPU_REGISTERS_OFFSET+0x00030028,0x00000001

#define IPU_CSI0_CPD_RC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003002C
#define IPU_CSI0_CPD_RC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003002C,0x00000000
#define IPU_CSI0_CPD_RC_0__FULL          IPU_REGISTERS_OFFSET+0x0003002C,0xffffffff
#define IPU_CSI0_CPD_RC_0__CSI0_CPD_RC_1 IPU_REGISTERS_OFFSET+0x0003002C,0x01FF0000
#define IPU_CSI0_CPD_RC_0__CSI0_CPD_RC_0 IPU_REGISTERS_OFFSET+0x0003002C,0x000001FF

#define IPU_CSI0_CPD_RC_1__ADDR          IPU_REGISTERS_OFFSET+0x00030030
#define IPU_CSI0_CPD_RC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00030030,0x00000000
#define IPU_CSI0_CPD_RC_1__FULL          IPU_REGISTERS_OFFSET+0x00030030,0xffffffff
#define IPU_CSI0_CPD_RC_1__CSI0_CPD_RC_3 IPU_REGISTERS_OFFSET+0x00030030,0x01FF0000
#define IPU_CSI0_CPD_RC_1__CSI0_CPD_RC_2 IPU_REGISTERS_OFFSET+0x00030030,0x000001FF

#define IPU_CSI0_CPD_RC_2__ADDR          IPU_REGISTERS_OFFSET+0x00030034
#define IPU_CSI0_CPD_RC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00030034,0x00000000
#define IPU_CSI0_CPD_RC_2__FULL          IPU_REGISTERS_OFFSET+0x00030034,0xffffffff
#define IPU_CSI0_CPD_RC_2__CSI0_CPD_RC_5 IPU_REGISTERS_OFFSET+0x00030034,0x01FF0000
#define IPU_CSI0_CPD_RC_2__CSI0_CPD_RC_4 IPU_REGISTERS_OFFSET+0x00030034,0x000001FF

#define IPU_CSI0_CPD_RC_3__ADDR          IPU_REGISTERS_OFFSET+0x00030038
#define IPU_CSI0_CPD_RC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00030038,0x00000000
#define IPU_CSI0_CPD_RC_3__FULL          IPU_REGISTERS_OFFSET+0x00030038,0xffffffff
#define IPU_CSI0_CPD_RC_3__CSI0_CPD_RC_7 IPU_REGISTERS_OFFSET+0x00030038,0x01FF0000
#define IPU_CSI0_CPD_RC_3__CSI0_CPD_RC_6 IPU_REGISTERS_OFFSET+0x00030038,0x000001FF

#define IPU_CSI0_CPD_RC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003003C
#define IPU_CSI0_CPD_RC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003003C,0x00000000
#define IPU_CSI0_CPD_RC_4__FULL          IPU_REGISTERS_OFFSET+0x0003003C,0xffffffff
#define IPU_CSI0_CPD_RC_4__CSI0_CPD_RC_9 IPU_REGISTERS_OFFSET+0x0003003C,0x01FF0000
#define IPU_CSI0_CPD_RC_4__CSI0_CPD_RC_8 IPU_REGISTERS_OFFSET+0x0003003C,0x000001FF

#define IPU_CSI0_CPD_RC_5__ADDR           IPU_REGISTERS_OFFSET+0x00030040
#define IPU_CSI0_CPD_RC_5__EMPTY          IPU_REGISTERS_OFFSET+0x00030040,0x00000000
#define IPU_CSI0_CPD_RC_5__FULL           IPU_REGISTERS_OFFSET+0x00030040,0xffffffff
#define IPU_CSI0_CPD_RC_5__CSI0_CPD_RC_11 IPU_REGISTERS_OFFSET+0x00030040,0x01FF0000
#define IPU_CSI0_CPD_RC_5__CSI0_CPD_RC_10 IPU_REGISTERS_OFFSET+0x00030040,0x000001FF

#define IPU_CSI0_CPD_RC_6__ADDR           IPU_REGISTERS_OFFSET+0x00030044
#define IPU_CSI0_CPD_RC_6__EMPTY          IPU_REGISTERS_OFFSET+0x00030044,0x00000000
#define IPU_CSI0_CPD_RC_6__FULL           IPU_REGISTERS_OFFSET+0x00030044,0xffffffff
#define IPU_CSI0_CPD_RC_6__CSI0_CPD_RC_13 IPU_REGISTERS_OFFSET+0x00030044,0x01FF0000
#define IPU_CSI0_CPD_RC_6__CSI0_CPD_RC_12 IPU_REGISTERS_OFFSET+0x00030044,0x000001FF

#define IPU_CSI0_CPD_RC_7__ADDR           IPU_REGISTERS_OFFSET+0x00030048
#define IPU_CSI0_CPD_RC_7__EMPTY          IPU_REGISTERS_OFFSET+0x00030048,0x00000000
#define IPU_CSI0_CPD_RC_7__FULL           IPU_REGISTERS_OFFSET+0x00030048,0xffffffff
#define IPU_CSI0_CPD_RC_7__CSI0_CPD_RC_15 IPU_REGISTERS_OFFSET+0x00030048,0x01FF0000
#define IPU_CSI0_CPD_RC_7__CSI0_CPD_RC_14 IPU_REGISTERS_OFFSET+0x00030048,0x000001FF

#define IPU_CSI0_CPD_RS_0__ADDR         IPU_REGISTERS_OFFSET+0x0003004C
#define IPU_CSI0_CPD_RS_0__EMPTY        IPU_REGISTERS_OFFSET+0x0003004C,0x00000000
#define IPU_CSI0_CPD_RS_0__FULL         IPU_REGISTERS_OFFSET+0x0003004C,0xffffffff
#define IPU_CSI0_CPD_RS_0__CSI0_CPD_RS3 IPU_REGISTERS_OFFSET+0x0003004C,0xFF000000
#define IPU_CSI0_CPD_RS_0__CSI0_CPD_RS2 IPU_REGISTERS_OFFSET+0x0003004C,0x00FF0000
#define IPU_CSI0_CPD_RS_0__CSI0_CPD_RS1 IPU_REGISTERS_OFFSET+0x0003004C,0x0000FF00
#define IPU_CSI0_CPD_RS_0__CSI0_CPD_RS0 IPU_REGISTERS_OFFSET+0x0003004C,0x000000FF

#define IPU_CSI0_CPD_RS_1__ADDR         IPU_REGISTERS_OFFSET+0x00030050
#define IPU_CSI0_CPD_RS_1__EMPTY        IPU_REGISTERS_OFFSET+0x00030050,0x00000000
#define IPU_CSI0_CPD_RS_1__FULL         IPU_REGISTERS_OFFSET+0x00030050,0xffffffff
#define IPU_CSI0_CPD_RS_1__CSI0_CPD_RS7 IPU_REGISTERS_OFFSET+0x00030050,0xFF000000
#define IPU_CSI0_CPD_RS_1__CSI0_CPD_RS6 IPU_REGISTERS_OFFSET+0x00030050,0x00FF0000
#define IPU_CSI0_CPD_RS_1__CSI0_CPD_RS5 IPU_REGISTERS_OFFSET+0x00030050,0x0000FF00
#define IPU_CSI0_CPD_RS_1__CSI0_CPD_RS4 IPU_REGISTERS_OFFSET+0x00030050,0x000000FF

#define IPU_CSI0_CPD_RS_2__ADDR          IPU_REGISTERS_OFFSET+0x00030054
#define IPU_CSI0_CPD_RS_2__EMPTY         IPU_REGISTERS_OFFSET+0x00030054,0x00000000
#define IPU_CSI0_CPD_RS_2__FULL          IPU_REGISTERS_OFFSET+0x00030054,0xffffffff
#define IPU_CSI0_CPD_RS_2__CSI0_CPD_RS11 IPU_REGISTERS_OFFSET+0x00030054,0xFF000000
#define IPU_CSI0_CPD_RS_2__CSI0_CPD_RS10 IPU_REGISTERS_OFFSET+0x00030054,0x00FF0000
#define IPU_CSI0_CPD_RS_2__CSI0_CPD_RS9  IPU_REGISTERS_OFFSET+0x00030054,0x0000FF00
#define IPU_CSI0_CPD_RS_2__CSI0_CPD_RS8  IPU_REGISTERS_OFFSET+0x00030054,0x000000FF

#define IPU_CSI0_CPD_RS_3__ADDR          IPU_REGISTERS_OFFSET+0x00030058
#define IPU_CSI0_CPD_RS_3__EMPTY         IPU_REGISTERS_OFFSET+0x00030058,0x00000000
#define IPU_CSI0_CPD_RS_3__FULL          IPU_REGISTERS_OFFSET+0x00030058,0xffffffff
#define IPU_CSI0_CPD_RS_3__CSI0_CPD_RS15 IPU_REGISTERS_OFFSET+0x00030058,0xFF000000
#define IPU_CSI0_CPD_RS_3__CSI0_CPD_RS14 IPU_REGISTERS_OFFSET+0x00030058,0x00FF0000
#define IPU_CSI0_CPD_RS_3__CSI0_CPD_RS13 IPU_REGISTERS_OFFSET+0x00030058,0x0000FF00
#define IPU_CSI0_CPD_RS_3__CSI0_CPD_RS12 IPU_REGISTERS_OFFSET+0x00030058,0x000000FF

#define IPU_CSI0_CPD_GRC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003005C
#define IPU_CSI0_CPD_GRC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003005C,0x00000000
#define IPU_CSI0_CPD_GRC_0__FULL          IPU_REGISTERS_OFFSET+0x0003005C,0xffffffff
#define IPU_CSI0_CPD_GRC_0__CSI0_CPD_GRC1 IPU_REGISTERS_OFFSET+0x0003005C,0x01FF0000
#define IPU_CSI0_CPD_GRC_0__CSI0_CPD_GRC0 IPU_REGISTERS_OFFSET+0x0003005C,0x000001FF

#define IPU_CSI0_CPD_GRC_1__ADDR          IPU_REGISTERS_OFFSET+0x00030060
#define IPU_CSI0_CPD_GRC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00030060,0x00000000
#define IPU_CSI0_CPD_GRC_1__FULL          IPU_REGISTERS_OFFSET+0x00030060,0xffffffff
#define IPU_CSI0_CPD_GRC_1__CSI0_CPD_GRC3 IPU_REGISTERS_OFFSET+0x00030060,0x01FF0000
#define IPU_CSI0_CPD_GRC_1__CSI0_CPD_GRC2 IPU_REGISTERS_OFFSET+0x00030060,0x000001FF

#define IPU_CSI0_CPD_GRC_2__ADDR          IPU_REGISTERS_OFFSET+0x00030064
#define IPU_CSI0_CPD_GRC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00030064,0x00000000
#define IPU_CSI0_CPD_GRC_2__FULL          IPU_REGISTERS_OFFSET+0x00030064,0xffffffff
#define IPU_CSI0_CPD_GRC_2__CSI0_CPD_GRC5 IPU_REGISTERS_OFFSET+0x00030064,0x01FF0000
#define IPU_CSI0_CPD_GRC_2__CSI0_CPD_GRC4 IPU_REGISTERS_OFFSET+0x00030064,0x000001FF

#define IPU_CSI0_CPD_GRC_3__ADDR          IPU_REGISTERS_OFFSET+0x00030068
#define IPU_CSI0_CPD_GRC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00030068,0x00000000
#define IPU_CSI0_CPD_GRC_3__FULL          IPU_REGISTERS_OFFSET+0x00030068,0xffffffff
#define IPU_CSI0_CPD_GRC_3__CSI0_CPD_GRC7 IPU_REGISTERS_OFFSET+0x00030068,0x01FF0000
#define IPU_CSI0_CPD_GRC_3__CSI0_CPD_GRC6 IPU_REGISTERS_OFFSET+0x00030068,0x000001FF

#define IPU_CSI0_CPD_GRC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003006C
#define IPU_CSI0_CPD_GRC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003006C,0x00000000
#define IPU_CSI0_CPD_GRC_4__FULL          IPU_REGISTERS_OFFSET+0x0003006C,0xffffffff
#define IPU_CSI0_CPD_GRC_4__CSI0_CPD_GRC9 IPU_REGISTERS_OFFSET+0x0003006C,0x01FF0000
#define IPU_CSI0_CPD_GRC_4__CSI0_CPD_GRC8 IPU_REGISTERS_OFFSET+0x0003006C,0x000001FF

#define IPU_CSI0_CPD_GRC_5__ADDR           IPU_REGISTERS_OFFSET+0x00030070
#define IPU_CSI0_CPD_GRC_5__EMPTY          IPU_REGISTERS_OFFSET+0x00030070,0x00000000
#define IPU_CSI0_CPD_GRC_5__FULL           IPU_REGISTERS_OFFSET+0x00030070,0xffffffff
#define IPU_CSI0_CPD_GRC_5__CSI0_CPD_GRC11 IPU_REGISTERS_OFFSET+0x00030070,0x01FF0000
#define IPU_CSI0_CPD_GRC_5__CSI0_CPD_GRC10 IPU_REGISTERS_OFFSET+0x00030070,0x000001FF

#define IPU_CSI0_CPD_GRC_6__ADDR           IPU_REGISTERS_OFFSET+0x00030074
#define IPU_CSI0_CPD_GRC_6__EMPTY          IPU_REGISTERS_OFFSET+0x00030074,0x00000000
#define IPU_CSI0_CPD_GRC_6__FULL           IPU_REGISTERS_OFFSET+0x00030074,0xffffffff
#define IPU_CSI0_CPD_GRC_6__CSI0_CPD_GRC13 IPU_REGISTERS_OFFSET+0x00030074,0x01FF0000
#define IPU_CSI0_CPD_GRC_6__CSI0_CPD_GRC12 IPU_REGISTERS_OFFSET+0x00030074,0x000001FF

#define IPU_CSI0_CPD_GRC_7__ADDR           IPU_REGISTERS_OFFSET+0x00030078
#define IPU_CSI0_CPD_GRC_7__EMPTY          IPU_REGISTERS_OFFSET+0x00030078,0x00000000
#define IPU_CSI0_CPD_GRC_7__FULL           IPU_REGISTERS_OFFSET+0x00030078,0xffffffff
#define IPU_CSI0_CPD_GRC_7__CSI0_CPD_GRC15 IPU_REGISTERS_OFFSET+0x00030078,0x01FF0000
#define IPU_CSI0_CPD_GRC_7__CSI0_CPD_GRC14 IPU_REGISTERS_OFFSET+0x00030078,0x000001FF

#define IPU_CSI0_CPD_GRS_0__ADDR          IPU_REGISTERS_OFFSET+0x0003007C
#define IPU_CSI0_CPD_GRS_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003007C,0x00000000
#define IPU_CSI0_CPD_GRS_0__FULL          IPU_REGISTERS_OFFSET+0x0003007C,0xffffffff
#define IPU_CSI0_CPD_GRS_0__CSI0_CPD_GRS3 IPU_REGISTERS_OFFSET+0x0003007C,0xFF000000
#define IPU_CSI0_CPD_GRS_0__CSI0_CPD_GRS2 IPU_REGISTERS_OFFSET+0x0003007C,0x00FF0000
#define IPU_CSI0_CPD_GRS_0__CSI0_CPD_GRS1 IPU_REGISTERS_OFFSET+0x0003007C,0x0000FF00
#define IPU_CSI0_CPD_GRS_0__CSI0_CPD_GRS0 IPU_REGISTERS_OFFSET+0x0003007C,0x000000FF

#define IPU_CSI0_CPD_GRS_1__ADDR          IPU_REGISTERS_OFFSET+0x00030080
#define IPU_CSI0_CPD_GRS_1__EMPTY         IPU_REGISTERS_OFFSET+0x00030080,0x00000000
#define IPU_CSI0_CPD_GRS_1__FULL          IPU_REGISTERS_OFFSET+0x00030080,0xffffffff
#define IPU_CSI0_CPD_GRS_1__CSI0_CPD_GRS7 IPU_REGISTERS_OFFSET+0x00030080,0xFF000000
#define IPU_CSI0_CPD_GRS_1__CSI0_CPD_GRS6 IPU_REGISTERS_OFFSET+0x00030080,0x00FF0000
#define IPU_CSI0_CPD_GRS_1__CSI0_CPD_GRS5 IPU_REGISTERS_OFFSET+0x00030080,0x0000FF00
#define IPU_CSI0_CPD_GRS_1__CSI0_CPD_GRS4 IPU_REGISTERS_OFFSET+0x00030080,0x000000FF

#define IPU_CSI0_CPD_GRS_2__ADDR           IPU_REGISTERS_OFFSET+0x00030084
#define IPU_CSI0_CPD_GRS_2__EMPTY          IPU_REGISTERS_OFFSET+0x00030084,0x00000000
#define IPU_CSI0_CPD_GRS_2__FULL           IPU_REGISTERS_OFFSET+0x00030084,0xffffffff
#define IPU_CSI0_CPD_GRS_2__CSI0_CPD_GRS11 IPU_REGISTERS_OFFSET+0x00030084,0xFF000000
#define IPU_CSI0_CPD_GRS_2__CSI0_CPD_GRS10 IPU_REGISTERS_OFFSET+0x00030084,0x00FF0000
#define IPU_CSI0_CPD_GRS_2__CSI0_CPD_GRS9  IPU_REGISTERS_OFFSET+0x00030084,0x0000FF00
#define IPU_CSI0_CPD_GRS_2__CSI0_CPD_GRS8  IPU_REGISTERS_OFFSET+0x00030084,0x000000FF

#define IPU_CSI0_CPD_GRS_3__ADDR           IPU_REGISTERS_OFFSET+0x00030088
#define IPU_CSI0_CPD_GRS_3__EMPTY          IPU_REGISTERS_OFFSET+0x00030088,0x00000000
#define IPU_CSI0_CPD_GRS_3__FULL           IPU_REGISTERS_OFFSET+0x00030088,0xffffffff
#define IPU_CSI0_CPD_GRS_3__CSI0_CPD_GRS15 IPU_REGISTERS_OFFSET+0x00030088,0xFF000000
#define IPU_CSI0_CPD_GRS_3__CSI0_CPD_GRS14 IPU_REGISTERS_OFFSET+0x00030088,0x00FF0000
#define IPU_CSI0_CPD_GRS_3__CSI0_CPD_GRS13 IPU_REGISTERS_OFFSET+0x00030088,0x0000FF00
#define IPU_CSI0_CPD_GRS_3__CSI0_CPD_GRS12 IPU_REGISTERS_OFFSET+0x00030088,0x000000FF

#define IPU_CSI0_CPD_GBC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003008C
#define IPU_CSI0_CPD_GBC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003008C,0x00000000
#define IPU_CSI0_CPD_GBC_0__FULL          IPU_REGISTERS_OFFSET+0x0003008C,0xffffffff
#define IPU_CSI0_CPD_GBC_0__CSI0_CPD_GBC1 IPU_REGISTERS_OFFSET+0x0003008C,0x01FF0000
#define IPU_CSI0_CPD_GBC_0__CSI0_CPD_GBC0 IPU_REGISTERS_OFFSET+0x0003008C,0x000001FF

#define IPU_CSI0_CPD_GBC_1__ADDR          IPU_REGISTERS_OFFSET+0x00030090
#define IPU_CSI0_CPD_GBC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00030090,0x00000000
#define IPU_CSI0_CPD_GBC_1__FULL          IPU_REGISTERS_OFFSET+0x00030090,0xffffffff
#define IPU_CSI0_CPD_GBC_1__CSI0_CPD_GBC3 IPU_REGISTERS_OFFSET+0x00030090,0x01FF0000
#define IPU_CSI0_CPD_GBC_1__CSI0_CPD_GBC2 IPU_REGISTERS_OFFSET+0x00030090,0x000001FF

#define IPU_CSI0_CPD_GBC_2__ADDR          IPU_REGISTERS_OFFSET+0x00030094
#define IPU_CSI0_CPD_GBC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00030094,0x00000000
#define IPU_CSI0_CPD_GBC_2__FULL          IPU_REGISTERS_OFFSET+0x00030094,0xffffffff
#define IPU_CSI0_CPD_GBC_2__CSI0_CPD_GBC5 IPU_REGISTERS_OFFSET+0x00030094,0x01FF0000
#define IPU_CSI0_CPD_GBC_2__CSI0_CPD_GBC4 IPU_REGISTERS_OFFSET+0x00030094,0x000001FF

#define IPU_CSI0_CPD_GBC_3__ADDR          IPU_REGISTERS_OFFSET+0x00030098
#define IPU_CSI0_CPD_GBC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00030098,0x00000000
#define IPU_CSI0_CPD_GBC_3__FULL          IPU_REGISTERS_OFFSET+0x00030098,0xffffffff
#define IPU_CSI0_CPD_GBC_3__CSI0_CPD_GBC7 IPU_REGISTERS_OFFSET+0x00030098,0x01FF0000
#define IPU_CSI0_CPD_GBC_3__CSI0_CPD_GBC6 IPU_REGISTERS_OFFSET+0x00030098,0x000001FF

#define IPU_CSI0_CPD_GBC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003009C
#define IPU_CSI0_CPD_GBC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003009C,0x00000000
#define IPU_CSI0_CPD_GBC_4__FULL          IPU_REGISTERS_OFFSET+0x0003009C,0xffffffff
#define IPU_CSI0_CPD_GBC_4__CSI0_CPD_GBC9 IPU_REGISTERS_OFFSET+0x0003009C,0x01FF0000
#define IPU_CSI0_CPD_GBC_4__CSI0_CPD_GBC8 IPU_REGISTERS_OFFSET+0x0003009C,0x000001FF

#define IPU_CSI0_CPD_GBC_5__ADDR           IPU_REGISTERS_OFFSET+0x000300A0
#define IPU_CSI0_CPD_GBC_5__EMPTY          IPU_REGISTERS_OFFSET+0x000300A0,0x00000000
#define IPU_CSI0_CPD_GBC_5__FULL           IPU_REGISTERS_OFFSET+0x000300A0,0xffffffff
#define IPU_CSI0_CPD_GBC_5__CSI0_CPD_GBC11 IPU_REGISTERS_OFFSET+0x000300A0,0x01FF0000
#define IPU_CSI0_CPD_GBC_5__CSI0_CPD_GBC10 IPU_REGISTERS_OFFSET+0x000300A0,0x000001FF

#define IPU_CSI0_CPD_GBC_6__ADDR           IPU_REGISTERS_OFFSET+0x000300A4
#define IPU_CSI0_CPD_GBC_6__EMPTY          IPU_REGISTERS_OFFSET+0x000300A4,0x00000000
#define IPU_CSI0_CPD_GBC_6__FULL           IPU_REGISTERS_OFFSET+0x000300A4,0xffffffff
#define IPU_CSI0_CPD_GBC_6__CSI0_CPD_GBC13 IPU_REGISTERS_OFFSET+0x000300A4,0x01FF0000
#define IPU_CSI0_CPD_GBC_6__CSI0_CPD_GBC12 IPU_REGISTERS_OFFSET+0x000300A4,0x000001FF

#define IPU_CSI0_CPD_GBC_7__ADDR           IPU_REGISTERS_OFFSET+0x000300A8
#define IPU_CSI0_CPD_GBC_7__EMPTY          IPU_REGISTERS_OFFSET+0x000300A8,0x00000000
#define IPU_CSI0_CPD_GBC_7__FULL           IPU_REGISTERS_OFFSET+0x000300A8,0xffffffff
#define IPU_CSI0_CPD_GBC_7__CSI0_CPD_GBC15 IPU_REGISTERS_OFFSET+0x000300A8,0x01FF0000
#define IPU_CSI0_CPD_GBC_7__CSI0_CPD_GBC14 IPU_REGISTERS_OFFSET+0x000300A8,0x000001FF

#define IPU_CSI0_CPD_GBS_0__ADDR          IPU_REGISTERS_OFFSET+0x000300AC
#define IPU_CSI0_CPD_GBS_0__EMPTY         IPU_REGISTERS_OFFSET+0x000300AC,0x00000000
#define IPU_CSI0_CPD_GBS_0__FULL          IPU_REGISTERS_OFFSET+0x000300AC,0xffffffff
#define IPU_CSI0_CPD_GBS_0__CSI0_CPD_GBS3 IPU_REGISTERS_OFFSET+0x000300AC,0xFF000000
#define IPU_CSI0_CPD_GBS_0__CSI0_CPD_GBS2 IPU_REGISTERS_OFFSET+0x000300AC,0x00FF0000
#define IPU_CSI0_CPD_GBS_0__CSI0_CPD_GBS1 IPU_REGISTERS_OFFSET+0x000300AC,0x0000FF00
#define IPU_CSI0_CPD_GBS_0__CSI0_CPD_GBS0 IPU_REGISTERS_OFFSET+0x000300AC,0x000000FF

#define IPU_CSI0_CPD_GBS_1__ADDR          IPU_REGISTERS_OFFSET+0x000300B0
#define IPU_CSI0_CPD_GBS_1__EMPTY         IPU_REGISTERS_OFFSET+0x000300B0,0x00000000
#define IPU_CSI0_CPD_GBS_1__FULL          IPU_REGISTERS_OFFSET+0x000300B0,0xffffffff
#define IPU_CSI0_CPD_GBS_1__CSI0_CPD_GBS7 IPU_REGISTERS_OFFSET+0x000300B0,0xFF000000
#define IPU_CSI0_CPD_GBS_1__CSI0_CPD_GBS6 IPU_REGISTERS_OFFSET+0x000300B0,0x00FF0000
#define IPU_CSI0_CPD_GBS_1__CSI0_CPD_GBS5 IPU_REGISTERS_OFFSET+0x000300B0,0x0000FF00
#define IPU_CSI0_CPD_GBS_1__CSI0_CPD_GBS4 IPU_REGISTERS_OFFSET+0x000300B0,0x000000FF

#define IPU_CSI0_CPD_GBS_2__ADDR           IPU_REGISTERS_OFFSET+0x000300B4
#define IPU_CSI0_CPD_GBS_2__EMPTY          IPU_REGISTERS_OFFSET+0x000300B4,0x00000000
#define IPU_CSI0_CPD_GBS_2__FULL           IPU_REGISTERS_OFFSET+0x000300B4,0xffffffff
#define IPU_CSI0_CPD_GBS_2__CSI0_CPD_GBS11 IPU_REGISTERS_OFFSET+0x000300B4,0xFF000000
#define IPU_CSI0_CPD_GBS_2__CSI0_CPD_GBS10 IPU_REGISTERS_OFFSET+0x000300B4,0x00FF0000
#define IPU_CSI0_CPD_GBS_2__CSI0_CPD_GBS9  IPU_REGISTERS_OFFSET+0x000300B4,0x0000FF00
#define IPU_CSI0_CPD_GBS_2__CSI0_CPD_GBS8  IPU_REGISTERS_OFFSET+0x000300B4,0x000000FF

#define IPU_CSI0_CPD_GBS_3__ADDR           IPU_REGISTERS_OFFSET+0x000300B8
#define IPU_CSI0_CPD_GBS_3__EMPTY          IPU_REGISTERS_OFFSET+0x000300B8,0x00000000
#define IPU_CSI0_CPD_GBS_3__FULL           IPU_REGISTERS_OFFSET+0x000300B8,0xffffffff
#define IPU_CSI0_CPD_GBS_3__CSI0_CPD_GBS15 IPU_REGISTERS_OFFSET+0x000300B8,0xFF000000
#define IPU_CSI0_CPD_GBS_3__CSI0_CPD_GBS14 IPU_REGISTERS_OFFSET+0x000300B8,0x00FF0000
#define IPU_CSI0_CPD_GBS_3__CSI0_CPD_GBS13 IPU_REGISTERS_OFFSET+0x000300B8,0x0000FF00
#define IPU_CSI0_CPD_GBS_3__CSI0_CPD_GBS12 IPU_REGISTERS_OFFSET+0x000300B8,0x000000FF

#define IPU_CSI0_CPD_BC_0__ADDR         IPU_REGISTERS_OFFSET+0x000300BC
#define IPU_CSI0_CPD_BC_0__EMPTY        IPU_REGISTERS_OFFSET+0x000300BC,0x00000000
#define IPU_CSI0_CPD_BC_0__FULL         IPU_REGISTERS_OFFSET+0x000300BC,0xffffffff
#define IPU_CSI0_CPD_BC_0__CSI0_CPD_BC1 IPU_REGISTERS_OFFSET+0x000300BC,0x01FF0000
#define IPU_CSI0_CPD_BC_0__CSI0_CPD_BC0 IPU_REGISTERS_OFFSET+0x000300BC,0x000001FF

#define IPU_CSI0_CPD_BC_1__ADDR         IPU_REGISTERS_OFFSET+0x000300C0
#define IPU_CSI0_CPD_BC_1__EMPTY        IPU_REGISTERS_OFFSET+0x000300C0,0x00000000
#define IPU_CSI0_CPD_BC_1__FULL         IPU_REGISTERS_OFFSET+0x000300C0,0xffffffff
#define IPU_CSI0_CPD_BC_1__CSI0_CPD_BC3 IPU_REGISTERS_OFFSET+0x000300C0,0x01FF0000
#define IPU_CSI0_CPD_BC_1__CSI0_CPD_BC2 IPU_REGISTERS_OFFSET+0x000300C0,0x000001FF

#define IPU_CSI0_CPD_BC_2__ADDR         IPU_REGISTERS_OFFSET+0x000300C4
#define IPU_CSI0_CPD_BC_2__EMPTY        IPU_REGISTERS_OFFSET+0x000300C4,0x00000000
#define IPU_CSI0_CPD_BC_2__FULL         IPU_REGISTERS_OFFSET+0x000300C4,0xffffffff
#define IPU_CSI0_CPD_BC_2__CSI0_CPD_BC5 IPU_REGISTERS_OFFSET+0x000300C4,0x01FF0000
#define IPU_CSI0_CPD_BC_2__CSI0_CPD_BC4 IPU_REGISTERS_OFFSET+0x000300C4,0x000001FF

#define IPU_CSI0_CPD_BC_3__ADDR         IPU_REGISTERS_OFFSET+0x000300C8
#define IPU_CSI0_CPD_BC_3__EMPTY        IPU_REGISTERS_OFFSET+0x000300C8,0x00000000
#define IPU_CSI0_CPD_BC_3__FULL         IPU_REGISTERS_OFFSET+0x000300C8,0xffffffff
#define IPU_CSI0_CPD_BC_3__CSI0_CPD_BC7 IPU_REGISTERS_OFFSET+0x000300C8,0x01FF0000
#define IPU_CSI0_CPD_BC_3__CSI0_CPD_BC6 IPU_REGISTERS_OFFSET+0x000300C8,0x000001FF

#define IPU_CSI0_CPD_BC_4__ADDR         IPU_REGISTERS_OFFSET+0x000300CC
#define IPU_CSI0_CPD_BC_4__EMPTY        IPU_REGISTERS_OFFSET+0x000300CC,0x00000000
#define IPU_CSI0_CPD_BC_4__FULL         IPU_REGISTERS_OFFSET+0x000300CC,0xffffffff
#define IPU_CSI0_CPD_BC_4__CSI0_CPD_BC9 IPU_REGISTERS_OFFSET+0x000300CC,0x01FF0000
#define IPU_CSI0_CPD_BC_4__CSI0_CPD_BC8 IPU_REGISTERS_OFFSET+0x000300CC,0x000001FF

#define IPU_CSI0_CPD_BC_5__ADDR          IPU_REGISTERS_OFFSET+0x000300D0
#define IPU_CSI0_CPD_BC_5__EMPTY         IPU_REGISTERS_OFFSET+0x000300D0,0x00000000
#define IPU_CSI0_CPD_BC_5__FULL          IPU_REGISTERS_OFFSET+0x000300D0,0xffffffff
#define IPU_CSI0_CPD_BC_5__CSI0_CPD_BC11 IPU_REGISTERS_OFFSET+0x000300D0,0x01FF0000
#define IPU_CSI0_CPD_BC_5__CSI0_CPD_BC10 IPU_REGISTERS_OFFSET+0x000300D0,0x000001FF

#define IPU_CSI0_CPD_BC_6__ADDR          IPU_REGISTERS_OFFSET+0x000300D4
#define IPU_CSI0_CPD_BC_6__EMPTY         IPU_REGISTERS_OFFSET+0x000300D4,0x00000000
#define IPU_CSI0_CPD_BC_6__FULL          IPU_REGISTERS_OFFSET+0x000300D4,0xffffffff
#define IPU_CSI0_CPD_BC_6__CSI0_CPD_BC13 IPU_REGISTERS_OFFSET+0x000300D4,0x01FF0000
#define IPU_CSI0_CPD_BC_6__CSI0_CPD_BC12 IPU_REGISTERS_OFFSET+0x000300D4,0x000001FF

#define IPU_CSI0_CPD_BC_7__ADDR          IPU_REGISTERS_OFFSET+0x000300D8
#define IPU_CSI0_CPD_BC_7__EMPTY         IPU_REGISTERS_OFFSET+0x000300D8,0x00000000
#define IPU_CSI0_CPD_BC_7__FULL          IPU_REGISTERS_OFFSET+0x000300D8,0xffffffff
#define IPU_CSI0_CPD_BC_7__CSI0_CPD_BC15 IPU_REGISTERS_OFFSET+0x000300D8,0x01FF0000
#define IPU_CSI0_CPD_BC_7__CSI0_CPD_BC14 IPU_REGISTERS_OFFSET+0x000300D8,0x000001FF

#define IPU_CSI0_CPD_BS_0__ADDR         IPU_REGISTERS_OFFSET+0x000300DC
#define IPU_CSI0_CPD_BS_0__EMPTY        IPU_REGISTERS_OFFSET+0x000300DC,0x00000000
#define IPU_CSI0_CPD_BS_0__FULL         IPU_REGISTERS_OFFSET+0x000300DC,0xffffffff
#define IPU_CSI0_CPD_BS_0__CSI0_CPD_BS3 IPU_REGISTERS_OFFSET+0x000300DC,0xFF000000
#define IPU_CSI0_CPD_BS_0__CSI0_CPD_BS2 IPU_REGISTERS_OFFSET+0x000300DC,0x00FF0000
#define IPU_CSI0_CPD_BS_0__CSI0_CPD_BS1 IPU_REGISTERS_OFFSET+0x000300DC,0x0000FF00
#define IPU_CSI0_CPD_BS_0__CSI0_CPD_BS0 IPU_REGISTERS_OFFSET+0x000300DC,0x000000FF

#define IPU_CSI0_CPD_BS_1__ADDR         IPU_REGISTERS_OFFSET+0x000300E0
#define IPU_CSI0_CPD_BS_1__EMPTY        IPU_REGISTERS_OFFSET+0x000300E0,0x00000000
#define IPU_CSI0_CPD_BS_1__FULL         IPU_REGISTERS_OFFSET+0x000300E0,0xffffffff
#define IPU_CSI0_CPD_BS_1__CSI0_CPD_BS7 IPU_REGISTERS_OFFSET+0x000300E0,0xFF000000
#define IPU_CSI0_CPD_BS_1__CSI0_CPD_BS6 IPU_REGISTERS_OFFSET+0x000300E0,0x00FF0000
#define IPU_CSI0_CPD_BS_1__CSI0_CPD_BS5 IPU_REGISTERS_OFFSET+0x000300E0,0x0000FF00
#define IPU_CSI0_CPD_BS_1__CSI0_CPD_BS4 IPU_REGISTERS_OFFSET+0x000300E0,0x000000FF

#define IPU_CSI0_CPD_BS_2__ADDR          IPU_REGISTERS_OFFSET+0x000300E4
#define IPU_CSI0_CPD_BS_2__EMPTY         IPU_REGISTERS_OFFSET+0x000300E4,0x00000000
#define IPU_CSI0_CPD_BS_2__FULL          IPU_REGISTERS_OFFSET+0x000300E4,0xffffffff
#define IPU_CSI0_CPD_BS_2__CSI0_CPD_BS11 IPU_REGISTERS_OFFSET+0x000300E4,0xFF000000
#define IPU_CSI0_CPD_BS_2__CSI0_CPD_BS10 IPU_REGISTERS_OFFSET+0x000300E4,0x00FF0000
#define IPU_CSI0_CPD_BS_2__CSI0_CPD_BS9  IPU_REGISTERS_OFFSET+0x000300E4,0x0000FF00
#define IPU_CSI0_CPD_BS_2__CSI0_CPD_BS8  IPU_REGISTERS_OFFSET+0x000300E4,0x000000FF

#define IPU_CSI0_CPD_BS_3__ADDR          IPU_REGISTERS_OFFSET+0x000300E8
#define IPU_CSI0_CPD_BS_3__EMPTY         IPU_REGISTERS_OFFSET+0x000300E8,0x00000000
#define IPU_CSI0_CPD_BS_3__FULL          IPU_REGISTERS_OFFSET+0x000300E8,0xffffffff
#define IPU_CSI0_CPD_BS_3__CSI0_CPD_BS15 IPU_REGISTERS_OFFSET+0x000300E8,0xFF000000
#define IPU_CSI0_CPD_BS_3__CSI0_CPD_BS14 IPU_REGISTERS_OFFSET+0x000300E8,0x00FF0000
#define IPU_CSI0_CPD_BS_3__CSI0_CPD_BS13 IPU_REGISTERS_OFFSET+0x000300E8,0x0000FF00
#define IPU_CSI0_CPD_BS_3__CSI0_CPD_BS12 IPU_REGISTERS_OFFSET+0x000300E8,0x000000FF

#define IPU_CSI0_CPD_OFFSET1__ADDR               IPU_REGISTERS_OFFSET+0x000300EC
#define IPU_CSI0_CPD_OFFSET1__EMPTY              IPU_REGISTERS_OFFSET+0x000300EC,0x00000000
#define IPU_CSI0_CPD_OFFSET1__FULL               IPU_REGISTERS_OFFSET+0x000300EC,0xffffffff
#define IPU_CSI0_CPD_OFFSET1__CSI0_CPD_B_OFFSET  IPU_REGISTERS_OFFSET+0x000300EC,0x3FF00000
#define IPU_CSI0_CPD_OFFSET1__CSI0_CPD_GB_OFFSET IPU_REGISTERS_OFFSET+0x000300EC,0x000FFC00
#define IPU_CSI0_CPD_OFFSET1__CSI0_CPD_GR_OFFSET IPU_REGISTERS_OFFSET+0x000300EC,0x000003FF

#define IPU_CSI0_CPD_OFFSET2__ADDR              IPU_REGISTERS_OFFSET+0x000300F0
#define IPU_CSI0_CPD_OFFSET2__EMPTY             IPU_REGISTERS_OFFSET+0x000300F0,0x00000000
#define IPU_CSI0_CPD_OFFSET2__FULL              IPU_REGISTERS_OFFSET+0x000300F0,0xffffffff
#define IPU_CSI0_CPD_OFFSET2__CSI0_CPD_R_OFFSET IPU_REGISTERS_OFFSET+0x000300F0,0x000003FF

#define IPU_CSI1_SENS_CONF__ADDR                  IPU_REGISTERS_OFFSET+0x00038000
#define IPU_CSI1_SENS_CONF__EMPTY                 IPU_REGISTERS_OFFSET+0x00038000,0x00000000
#define IPU_CSI1_SENS_CONF__FULL                  IPU_REGISTERS_OFFSET+0x00038000,0xffffffff
#define IPU_CSI1_SENS_CONF__CSI1_DATA_EN_POL      IPU_REGISTERS_OFFSET+0x00038000,0x80000000
#define IPU_CSI1_SENS_CONF__CSI1_FORCE_EOF        IPU_REGISTERS_OFFSET+0x00038000,0x20000000
#define IPU_CSI1_SENS_CONF__CSI1_JPEG_MODE        IPU_REGISTERS_OFFSET+0x00038000,0x10000000
#define IPU_CSI1_SENS_CONF__CSI1_JPEG8_EN         IPU_REGISTERS_OFFSET+0x00038000,0x08000000
#define IPU_CSI1_SENS_CONF__CSI1_DATA_DEST        IPU_REGISTERS_OFFSET+0x00038000,0x07000000
#define IPU_CSI1_SENS_CONF__CSI1_DIV_RATIO        IPU_REGISTERS_OFFSET+0x00038000,0x00FF0000
#define IPU_CSI1_SENS_CONF__CSI1_EXT_VSYNC        IPU_REGISTERS_OFFSET+0x00038000,0x00008000
#define IPU_CSI1_SENS_CONF__CSI1_DATA_WIDTH       IPU_REGISTERS_OFFSET+0x00038000,0x00007800
#define IPU_CSI1_SENS_CONF__CSI1_SENS_DATA_FORMAT IPU_REGISTERS_OFFSET+0x00038000,0x00000700
#define IPU_CSI1_SENS_CONF__CSI1_PACK_TIGHT       IPU_REGISTERS_OFFSET+0x00038000,0x00000080
#define IPU_CSI1_SENS_CONF__CSI1_SENS_PRTCL       IPU_REGISTERS_OFFSET+0x00038000,0x00000070
#define IPU_CSI1_SENS_CONF__CSI1_SENS_PIX_CLK_POL IPU_REGISTERS_OFFSET+0x00038000,0x00000008
#define IPU_CSI1_SENS_CONF__CSI1_DATA_POL         IPU_REGISTERS_OFFSET+0x00038000,0x00000004
#define IPU_CSI1_SENS_CONF__CSI1_HSYNC_POL        IPU_REGISTERS_OFFSET+0x00038000,0x00000002
#define IPU_CSI1_SENS_CONF__CSI1_VSYNC_POL        IPU_REGISTERS_OFFSET+0x00038000,0x00000001

#define IPU_CSI1_SENS_FRM_SIZE__ADDR                 IPU_REGISTERS_OFFSET+0x00038004
#define IPU_CSI1_SENS_FRM_SIZE__EMPTY                IPU_REGISTERS_OFFSET+0x00038004,0x00000000
#define IPU_CSI1_SENS_FRM_SIZE__FULL                 IPU_REGISTERS_OFFSET+0x00038004,0xffffffff
#define IPU_CSI1_SENS_FRM_SIZE__CSI1_SENS_FRM_HEIGHT IPU_REGISTERS_OFFSET+0x00038004,0x0FFF0000
#define IPU_CSI1_SENS_FRM_SIZE__CSI1_SENS_FRM_WIDTH  IPU_REGISTERS_OFFSET+0x00038004,0x00001FFF

#define IPU_CSI1_ACT_FRM_SIZE__ADDR                IPU_REGISTERS_OFFSET+0x00038008
#define IPU_CSI1_ACT_FRM_SIZE__EMPTY               IPU_REGISTERS_OFFSET+0x00038008,0x00000000
#define IPU_CSI1_ACT_FRM_SIZE__FULL                IPU_REGISTERS_OFFSET+0x00038008,0xffffffff
#define IPU_CSI1_ACT_FRM_SIZE__CSI1_ACT_FRM_HEIGHT IPU_REGISTERS_OFFSET+0x00038008,0x0FFF0000
#define IPU_CSI1_ACT_FRM_SIZE__CSI1_ACT_FRM_WIDTH  IPU_REGISTERS_OFFSET+0x00038008,0x00001FFF

#define IPU_CSI1_OUT_FRM_CTRL__ADDR           IPU_REGISTERS_OFFSET+0x0003800C
#define IPU_CSI1_OUT_FRM_CTRL__EMPTY          IPU_REGISTERS_OFFSET+0x0003800C,0x00000000
#define IPU_CSI1_OUT_FRM_CTRL__FULL           IPU_REGISTERS_OFFSET+0x0003800C,0xffffffff
#define IPU_CSI1_OUT_FRM_CTRL__CSI1_HORZ_DWNS IPU_REGISTERS_OFFSET+0x0003800C,0x80000000
#define IPU_CSI1_OUT_FRM_CTRL__CSI1_VERT_DWNS IPU_REGISTERS_OFFSET+0x0003800C,0x40000000
#define IPU_CSI1_OUT_FRM_CTRL__CSI1_HSC       IPU_REGISTERS_OFFSET+0x0003800C,0x1FFF0000
#define IPU_CSI1_OUT_FRM_CTRL__CSI1_VSC       IPU_REGISTERS_OFFSET+0x0003800C,0x00000FFF

#define IPU_CSI1_TST_CTRL__ADDR               IPU_REGISTERS_OFFSET+0x00038010
#define IPU_CSI1_TST_CTRL__EMPTY              IPU_REGISTERS_OFFSET+0x00038010,0x00000000
#define IPU_CSI1_TST_CTRL__FULL               IPU_REGISTERS_OFFSET+0x00038010,0xffffffff
#define IPU_CSI1_TST_CTRL__CSI1_TEST_GEN_MODE IPU_REGISTERS_OFFSET+0x00038010,0x01000000
#define IPU_CSI1_TST_CTRL__CSI1_PG_B_VALUE    IPU_REGISTERS_OFFSET+0x00038010,0x00FF0000
#define IPU_CSI1_TST_CTRL__CSI1_PG_G_VALUE    IPU_REGISTERS_OFFSET+0x00038010,0x0000FF00
#define IPU_CSI1_TST_CTRL__CSI1_PG_R_VALUE    IPU_REGISTERS_OFFSET+0x00038010,0x000000FF

#define IPU_CSI1_CCIR_CODE_1__ADDR                    IPU_REGISTERS_OFFSET+0x00038014
#define IPU_CSI1_CCIR_CODE_1__EMPTY                   IPU_REGISTERS_OFFSET+0x00038014,0x00000000
#define IPU_CSI1_CCIR_CODE_1__FULL                    IPU_REGISTERS_OFFSET+0x00038014,0xffffffff
#define IPU_CSI1_CCIR_CODE_1__CSI1_CCIR_ERR_DET_EN    IPU_REGISTERS_OFFSET+0x00038014,0x01000000
#define IPU_CSI1_CCIR_CODE_1__CSI1_STRT_FLD0_ACTV     IPU_REGISTERS_OFFSET+0x00038014,0x00380000
#define IPU_CSI1_CCIR_CODE_1__CSI1_END_FLD0_ACTV      IPU_REGISTERS_OFFSET+0x00038014,0x00070000
#define IPU_CSI1_CCIR_CODE_1__CSI1_STRT_FLD0_BLNK_2ND IPU_REGISTERS_OFFSET+0x00038014,0x00000E00
#define IPU_CSI1_CCIR_CODE_1__CSI1_END_FLD0_BLNK_2ND  IPU_REGISTERS_OFFSET+0x00038014,0x000001C0
#define IPU_CSI1_CCIR_CODE_1__CSI1_STRT_FLD0_BLNK_1ST IPU_REGISTERS_OFFSET+0x00038014,0x00000038
#define IPU_CSI1_CCIR_CODE_1__CSI1_END_FLD0_BLNK_1ST  IPU_REGISTERS_OFFSET+0x00038014,0x00000007

#define IPU_CSI1_CCIR_CODE_2__ADDR                    IPU_REGISTERS_OFFSET+0x00038018
#define IPU_CSI1_CCIR_CODE_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00038018,0x00000000
#define IPU_CSI1_CCIR_CODE_2__FULL                    IPU_REGISTERS_OFFSET+0x00038018,0xffffffff
#define IPU_CSI1_CCIR_CODE_2__CSI1_STRT_FLD1_ACTV     IPU_REGISTERS_OFFSET+0x00038018,0x00380000
#define IPU_CSI1_CCIR_CODE_2__CSI1_END_FLD1_ACTV      IPU_REGISTERS_OFFSET+0x00038018,0x00070000
#define IPU_CSI1_CCIR_CODE_2__CSI1_STRT_FLD1_BLNK_2ND IPU_REGISTERS_OFFSET+0x00038018,0x00000E00
#define IPU_CSI1_CCIR_CODE_2__CSI1_END_FLD1_BLNK_2ND  IPU_REGISTERS_OFFSET+0x00038018,0x000001C0
#define IPU_CSI1_CCIR_CODE_2__CSI1_STRT_FLD1_BLNK_1ST IPU_REGISTERS_OFFSET+0x00038018,0x00000038
#define IPU_CSI1_CCIR_CODE_2__CSI1_END_FLD1_BLNK_1ST  IPU_REGISTERS_OFFSET+0x00038018,0x00000007

#define IPU_CSI1_CCIR_CODE_3__ADDR             IPU_REGISTERS_OFFSET+0x0003801C
#define IPU_CSI1_CCIR_CODE_3__EMPTY            IPU_REGISTERS_OFFSET+0x0003801C,0x00000000
#define IPU_CSI1_CCIR_CODE_3__FULL             IPU_REGISTERS_OFFSET+0x0003801C,0xffffffff
#define IPU_CSI1_CCIR_CODE_3__CSI1_CCIR_PRECOM IPU_REGISTERS_OFFSET+0x0003801C,0x3FFFFFFF

#define IPU_CSI1_DI__ADDR          IPU_REGISTERS_OFFSET+0x00038020
#define IPU_CSI1_DI__EMPTY         IPU_REGISTERS_OFFSET+0x00038020,0x00000000
#define IPU_CSI1_DI__FULL          IPU_REGISTERS_OFFSET+0x00038020,0xffffffff
#define IPU_CSI1_DI__CSI1_MIPI_DI3 IPU_REGISTERS_OFFSET+0x00038020,0xFF000000
#define IPU_CSI1_DI__CSI1_MIPI_DI2 IPU_REGISTERS_OFFSET+0x00038020,0x00FF0000
#define IPU_CSI1_DI__CSI1_MIPI_DI1 IPU_REGISTERS_OFFSET+0x00038020,0x0000FF00
#define IPU_CSI1_DI__CSI1_MIPI_DI0 IPU_REGISTERS_OFFSET+0x00038020,0x000000FF

#define IPU_CSI1_SKIP__ADDR                     IPU_REGISTERS_OFFSET+0x00038024
#define IPU_CSI1_SKIP__EMPTY                    IPU_REGISTERS_OFFSET+0x00038024,0x00000000
#define IPU_CSI1_SKIP__FULL                     IPU_REGISTERS_OFFSET+0x00038024,0xffffffff
#define IPU_CSI1_SKIP__CSI1_SKIP_ISP            IPU_REGISTERS_OFFSET+0x00038024,0x00F80000
#define IPU_CSI1_SKIP__CSI1_MAX_RATIO_SKIP_ISP  IPU_REGISTERS_OFFSET+0x00038024,0x00070000
#define IPU_CSI1_SKIP__CSI1_ID_2_SKIP           IPU_REGISTERS_OFFSET+0x00038024,0x00000300
#define IPU_CSI1_SKIP__CSI1_SKIP_SMFC           IPU_REGISTERS_OFFSET+0x00038024,0x000000F8
#define IPU_CSI1_SKIP__CSI1_MAX_RATIO_SKIP_SMFC IPU_REGISTERS_OFFSET+0x00038024,0x00000007

#define IPU_CSI1_CPD_CTRL__ADDR               IPU_REGISTERS_OFFSET+0x00038028
#define IPU_CSI1_CPD_CTRL__EMPTY              IPU_REGISTERS_OFFSET+0x00038028,0x00000000
#define IPU_CSI1_CPD_CTRL__FULL               IPU_REGISTERS_OFFSET+0x00038028,0xffffffff
#define IPU_CSI1_CPD_CTRL__CSI1_CPD           IPU_REGISTERS_OFFSET+0x00038028,0x0000001C
#define IPU_CSI1_CPD_CTRL__CSI1_RED_ROW_BEGIN IPU_REGISTERS_OFFSET+0x00038028,0x00000002
#define IPU_CSI1_CPD_CTRL__CSI1_GREEN_P_BEGIN IPU_REGISTERS_OFFSET+0x00038028,0x00000001

#define IPU_CSI1_CPD_RC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003802C
#define IPU_CSI1_CPD_RC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003802C,0x00000000
#define IPU_CSI1_CPD_RC_0__FULL          IPU_REGISTERS_OFFSET+0x0003802C,0xffffffff
#define IPU_CSI1_CPD_RC_0__CSI1_CPD_RC_1 IPU_REGISTERS_OFFSET+0x0003802C,0x01FF0000
#define IPU_CSI1_CPD_RC_0__CSI1_CPD_RC_0 IPU_REGISTERS_OFFSET+0x0003802C,0x000001FF

#define IPU_CSI1_CPD_RC_1__ADDR          IPU_REGISTERS_OFFSET+0x00038030
#define IPU_CSI1_CPD_RC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00038030,0x00000000
#define IPU_CSI1_CPD_RC_1__FULL          IPU_REGISTERS_OFFSET+0x00038030,0xffffffff
#define IPU_CSI1_CPD_RC_1__CSI1_CPD_RC_3 IPU_REGISTERS_OFFSET+0x00038030,0x01FF0000
#define IPU_CSI1_CPD_RC_1__CSI1_CPD_RC_2 IPU_REGISTERS_OFFSET+0x00038030,0x000001FF

#define IPU_CSI1_CPD_RC_2__ADDR          IPU_REGISTERS_OFFSET+0x00038034
#define IPU_CSI1_CPD_RC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00038034,0x00000000
#define IPU_CSI1_CPD_RC_2__FULL          IPU_REGISTERS_OFFSET+0x00038034,0xffffffff
#define IPU_CSI1_CPD_RC_2__CSI1_CPD_RC_5 IPU_REGISTERS_OFFSET+0x00038034,0x01FF0000
#define IPU_CSI1_CPD_RC_2__CSI1_CPD_RC_4 IPU_REGISTERS_OFFSET+0x00038034,0x000001FF

#define IPU_CSI1_CPD_RC_3__ADDR          IPU_REGISTERS_OFFSET+0x00038038
#define IPU_CSI1_CPD_RC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00038038,0x00000000
#define IPU_CSI1_CPD_RC_3__FULL          IPU_REGISTERS_OFFSET+0x00038038,0xffffffff
#define IPU_CSI1_CPD_RC_3__CSI1_CPD_RC_7 IPU_REGISTERS_OFFSET+0x00038038,0x01FF0000
#define IPU_CSI1_CPD_RC_3__CSI1_CPD_RC_6 IPU_REGISTERS_OFFSET+0x00038038,0x000001FF

#define IPU_CSI1_CPD_RC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003803C
#define IPU_CSI1_CPD_RC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003803C,0x00000000
#define IPU_CSI1_CPD_RC_4__FULL          IPU_REGISTERS_OFFSET+0x0003803C,0xffffffff
#define IPU_CSI1_CPD_RC_4__CSI1_CPD_RC_9 IPU_REGISTERS_OFFSET+0x0003803C,0x01FF0000
#define IPU_CSI1_CPD_RC_4__CSI1_CPD_RC_8 IPU_REGISTERS_OFFSET+0x0003803C,0x000001FF

#define IPU_CSI1_CPD_RC_5__ADDR           IPU_REGISTERS_OFFSET+0x00038040
#define IPU_CSI1_CPD_RC_5__EMPTY          IPU_REGISTERS_OFFSET+0x00038040,0x00000000
#define IPU_CSI1_CPD_RC_5__FULL           IPU_REGISTERS_OFFSET+0x00038040,0xffffffff
#define IPU_CSI1_CPD_RC_5__CSI1_CPD_RC_11 IPU_REGISTERS_OFFSET+0x00038040,0x01FF0000
#define IPU_CSI1_CPD_RC_5__CSI1_CPD_RC_10 IPU_REGISTERS_OFFSET+0x00038040,0x000001FF

#define IPU_CSI1_CPD_RC_6__ADDR           IPU_REGISTERS_OFFSET+0x00038044
#define IPU_CSI1_CPD_RC_6__EMPTY          IPU_REGISTERS_OFFSET+0x00038044,0x00000000
#define IPU_CSI1_CPD_RC_6__FULL           IPU_REGISTERS_OFFSET+0x00038044,0xffffffff
#define IPU_CSI1_CPD_RC_6__CSI1_CPD_RC_13 IPU_REGISTERS_OFFSET+0x00038044,0x01FF0000
#define IPU_CSI1_CPD_RC_6__CSI1_CPD_RC_12 IPU_REGISTERS_OFFSET+0x00038044,0x000001FF

#define IPU_CSI1_CPD_RC_7__ADDR           IPU_REGISTERS_OFFSET+0x00038048
#define IPU_CSI1_CPD_RC_7__EMPTY          IPU_REGISTERS_OFFSET+0x00038048,0x00000000
#define IPU_CSI1_CPD_RC_7__FULL           IPU_REGISTERS_OFFSET+0x00038048,0xffffffff
#define IPU_CSI1_CPD_RC_7__CSI1_CPD_RC_15 IPU_REGISTERS_OFFSET+0x00038048,0x01FF0000
#define IPU_CSI1_CPD_RC_7__CSI1_CPD_RC_14 IPU_REGISTERS_OFFSET+0x00038048,0x000001FF

#define IPU_CSI1_CPD_RS_0__ADDR         IPU_REGISTERS_OFFSET+0x0003804C
#define IPU_CSI1_CPD_RS_0__EMPTY        IPU_REGISTERS_OFFSET+0x0003804C,0x00000000
#define IPU_CSI1_CPD_RS_0__FULL         IPU_REGISTERS_OFFSET+0x0003804C,0xffffffff
#define IPU_CSI1_CPD_RS_0__CSI1_CPD_RS3 IPU_REGISTERS_OFFSET+0x0003804C,0xFF000000
#define IPU_CSI1_CPD_RS_0__CSI1_CPD_RS2 IPU_REGISTERS_OFFSET+0x0003804C,0x00FF0000
#define IPU_CSI1_CPD_RS_0__CSI1_CPD_RS1 IPU_REGISTERS_OFFSET+0x0003804C,0x0000FF00
#define IPU_CSI1_CPD_RS_0__CSI1_CPD_RS0 IPU_REGISTERS_OFFSET+0x0003804C,0x000000FF

#define IPU_CSI1_CPD_RS_1__ADDR         IPU_REGISTERS_OFFSET+0x00038050
#define IPU_CSI1_CPD_RS_1__EMPTY        IPU_REGISTERS_OFFSET+0x00038050,0x00000000
#define IPU_CSI1_CPD_RS_1__FULL         IPU_REGISTERS_OFFSET+0x00038050,0xffffffff
#define IPU_CSI1_CPD_RS_1__CSI1_CPD_RS7 IPU_REGISTERS_OFFSET+0x00038050,0xFF000000
#define IPU_CSI1_CPD_RS_1__CSI1_CPD_RS6 IPU_REGISTERS_OFFSET+0x00038050,0x00FF0000
#define IPU_CSI1_CPD_RS_1__CSI1_CPD_RS5 IPU_REGISTERS_OFFSET+0x00038050,0x0000FF00
#define IPU_CSI1_CPD_RS_1__CSI1_CPD_RS4 IPU_REGISTERS_OFFSET+0x00038050,0x000000FF

#define IPU_CSI1_CPD_RS_2__ADDR          IPU_REGISTERS_OFFSET+0x00038054
#define IPU_CSI1_CPD_RS_2__EMPTY         IPU_REGISTERS_OFFSET+0x00038054,0x00000000
#define IPU_CSI1_CPD_RS_2__FULL          IPU_REGISTERS_OFFSET+0x00038054,0xffffffff
#define IPU_CSI1_CPD_RS_2__CSI1_CPD_RS11 IPU_REGISTERS_OFFSET+0x00038054,0xFF000000
#define IPU_CSI1_CPD_RS_2__CSI1_CPD_RS10 IPU_REGISTERS_OFFSET+0x00038054,0x00FF0000
#define IPU_CSI1_CPD_RS_2__CSI1_CPD_RS9  IPU_REGISTERS_OFFSET+0x00038054,0x0000FF00
#define IPU_CSI1_CPD_RS_2__CSI1_CPD_RS8  IPU_REGISTERS_OFFSET+0x00038054,0x000000FF

#define IPU_CSI1_CPD_RS_3__ADDR          IPU_REGISTERS_OFFSET+0x00038058
#define IPU_CSI1_CPD_RS_3__EMPTY         IPU_REGISTERS_OFFSET+0x00038058,0x00000000
#define IPU_CSI1_CPD_RS_3__FULL          IPU_REGISTERS_OFFSET+0x00038058,0xffffffff
#define IPU_CSI1_CPD_RS_3__CSI1_CPD_RS15 IPU_REGISTERS_OFFSET+0x00038058,0xFF000000
#define IPU_CSI1_CPD_RS_3__CSI1_CPD_RS14 IPU_REGISTERS_OFFSET+0x00038058,0x00FF0000
#define IPU_CSI1_CPD_RS_3__CSI1_CPD_RS13 IPU_REGISTERS_OFFSET+0x00038058,0x0000FF00
#define IPU_CSI1_CPD_RS_3__CSI1_CPD_RS12 IPU_REGISTERS_OFFSET+0x00038058,0x000000FF

#define IPU_CSI1_CPD_GRC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003805C
#define IPU_CSI1_CPD_GRC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003805C,0x00000000
#define IPU_CSI1_CPD_GRC_0__FULL          IPU_REGISTERS_OFFSET+0x0003805C,0xffffffff
#define IPU_CSI1_CPD_GRC_0__CSI1_CPD_GRC1 IPU_REGISTERS_OFFSET+0x0003805C,0x01FF0000
#define IPU_CSI1_CPD_GRC_0__CSI1_CPD_GRC0 IPU_REGISTERS_OFFSET+0x0003805C,0x000001FF

#define IPU_CSI1_CPD_GRC_1__ADDR          IPU_REGISTERS_OFFSET+0x00038060
#define IPU_CSI1_CPD_GRC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00038060,0x00000000
#define IPU_CSI1_CPD_GRC_1__FULL          IPU_REGISTERS_OFFSET+0x00038060,0xffffffff
#define IPU_CSI1_CPD_GRC_1__CSI1_CPD_GRC3 IPU_REGISTERS_OFFSET+0x00038060,0x01FF0000
#define IPU_CSI1_CPD_GRC_1__CSI1_CPD_GRC2 IPU_REGISTERS_OFFSET+0x00038060,0x000001FF

#define IPU_CSI1_CPD_GRC_2__ADDR          IPU_REGISTERS_OFFSET+0x00038064
#define IPU_CSI1_CPD_GRC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00038064,0x00000000
#define IPU_CSI1_CPD_GRC_2__FULL          IPU_REGISTERS_OFFSET+0x00038064,0xffffffff
#define IPU_CSI1_CPD_GRC_2__CSI1_CPD_GRC5 IPU_REGISTERS_OFFSET+0x00038064,0x01FF0000
#define IPU_CSI1_CPD_GRC_2__CSI1_CPD_GRC4 IPU_REGISTERS_OFFSET+0x00038064,0x000001FF

#define IPU_CSI1_CPD_GRC_3__ADDR          IPU_REGISTERS_OFFSET+0x00038068
#define IPU_CSI1_CPD_GRC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00038068,0x00000000
#define IPU_CSI1_CPD_GRC_3__FULL          IPU_REGISTERS_OFFSET+0x00038068,0xffffffff
#define IPU_CSI1_CPD_GRC_3__CSI1_CPD_GRC7 IPU_REGISTERS_OFFSET+0x00038068,0x01FF0000
#define IPU_CSI1_CPD_GRC_3__CSI1_CPD_GRC6 IPU_REGISTERS_OFFSET+0x00038068,0x000001FF

#define IPU_CSI1_CPD_GRC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003806C
#define IPU_CSI1_CPD_GRC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003806C,0x00000000
#define IPU_CSI1_CPD_GRC_4__FULL          IPU_REGISTERS_OFFSET+0x0003806C,0xffffffff
#define IPU_CSI1_CPD_GRC_4__CSI1_CPD_GRC9 IPU_REGISTERS_OFFSET+0x0003806C,0x01FF0000
#define IPU_CSI1_CPD_GRC_4__CSI1_CPD_GRC8 IPU_REGISTERS_OFFSET+0x0003806C,0x000001FF

#define IPU_CSI1_CPD_GRC_5__ADDR           IPU_REGISTERS_OFFSET+0x00038070
#define IPU_CSI1_CPD_GRC_5__EMPTY          IPU_REGISTERS_OFFSET+0x00038070,0x00000000
#define IPU_CSI1_CPD_GRC_5__FULL           IPU_REGISTERS_OFFSET+0x00038070,0xffffffff
#define IPU_CSI1_CPD_GRC_5__CSI1_CPD_GRC11 IPU_REGISTERS_OFFSET+0x00038070,0x01FF0000
#define IPU_CSI1_CPD_GRC_5__CSI1_CPD_GRC10 IPU_REGISTERS_OFFSET+0x00038070,0x000001FF

#define IPU_CSI1_CPD_GRC_6__ADDR           IPU_REGISTERS_OFFSET+0x00038074
#define IPU_CSI1_CPD_GRC_6__EMPTY          IPU_REGISTERS_OFFSET+0x00038074,0x00000000
#define IPU_CSI1_CPD_GRC_6__FULL           IPU_REGISTERS_OFFSET+0x00038074,0xffffffff
#define IPU_CSI1_CPD_GRC_6__CSI1_CPD_GRC13 IPU_REGISTERS_OFFSET+0x00038074,0x01FF0000
#define IPU_CSI1_CPD_GRC_6__CSI1_CPD_GRC12 IPU_REGISTERS_OFFSET+0x00038074,0x000001FF

#define IPU_CSI1_CPD_GRC_7__ADDR           IPU_REGISTERS_OFFSET+0x00038078
#define IPU_CSI1_CPD_GRC_7__EMPTY          IPU_REGISTERS_OFFSET+0x00038078,0x00000000
#define IPU_CSI1_CPD_GRC_7__FULL           IPU_REGISTERS_OFFSET+0x00038078,0xffffffff
#define IPU_CSI1_CPD_GRC_7__CSI1_CPD_GRC15 IPU_REGISTERS_OFFSET+0x00038078,0x01FF0000
#define IPU_CSI1_CPD_GRC_7__CSI1_CPD_GRC14 IPU_REGISTERS_OFFSET+0x00038078,0x000001FF

#define IPU_CSI1_CPD_GRS_0__ADDR          IPU_REGISTERS_OFFSET+0x0003807C
#define IPU_CSI1_CPD_GRS_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003807C,0x00000000
#define IPU_CSI1_CPD_GRS_0__FULL          IPU_REGISTERS_OFFSET+0x0003807C,0xffffffff
#define IPU_CSI1_CPD_GRS_0__CSI1_CPD_GRS3 IPU_REGISTERS_OFFSET+0x0003807C,0xFF000000
#define IPU_CSI1_CPD_GRS_0__CSI1_CPD_GRS2 IPU_REGISTERS_OFFSET+0x0003807C,0x00FF0000
#define IPU_CSI1_CPD_GRS_0__CSI1_CPD_GRS1 IPU_REGISTERS_OFFSET+0x0003807C,0x0000FF00
#define IPU_CSI1_CPD_GRS_0__CSI1_CPD_GRS0 IPU_REGISTERS_OFFSET+0x0003807C,0x000000FF

#define IPU_CSI1_CPD_GRS_1__ADDR          IPU_REGISTERS_OFFSET+0x00038080
#define IPU_CSI1_CPD_GRS_1__EMPTY         IPU_REGISTERS_OFFSET+0x00038080,0x00000000
#define IPU_CSI1_CPD_GRS_1__FULL          IPU_REGISTERS_OFFSET+0x00038080,0xffffffff
#define IPU_CSI1_CPD_GRS_1__CSI1_CPD_GRS7 IPU_REGISTERS_OFFSET+0x00038080,0xFF000000
#define IPU_CSI1_CPD_GRS_1__CSI1_CPD_GRS6 IPU_REGISTERS_OFFSET+0x00038080,0x00FF0000
#define IPU_CSI1_CPD_GRS_1__CSI1_CPD_GRS5 IPU_REGISTERS_OFFSET+0x00038080,0x0000FF00
#define IPU_CSI1_CPD_GRS_1__CSI1_CPD_GRS4 IPU_REGISTERS_OFFSET+0x00038080,0x000000FF

#define IPU_CSI1_CPD_GRS_2__ADDR           IPU_REGISTERS_OFFSET+0x00038084
#define IPU_CSI1_CPD_GRS_2__EMPTY          IPU_REGISTERS_OFFSET+0x00038084,0x00000000
#define IPU_CSI1_CPD_GRS_2__FULL           IPU_REGISTERS_OFFSET+0x00038084,0xffffffff
#define IPU_CSI1_CPD_GRS_2__CSI1_CPD_GRS11 IPU_REGISTERS_OFFSET+0x00038084,0xFF000000
#define IPU_CSI1_CPD_GRS_2__CSI1_CPD_GRS10 IPU_REGISTERS_OFFSET+0x00038084,0x00FF0000
#define IPU_CSI1_CPD_GRS_2__CSI1_CPD_GRS9  IPU_REGISTERS_OFFSET+0x00038084,0x0000FF00
#define IPU_CSI1_CPD_GRS_2__CSI1_CPD_GRS8  IPU_REGISTERS_OFFSET+0x00038084,0x000000FF

#define IPU_CSI1_CPD_GRS_3__ADDR           IPU_REGISTERS_OFFSET+0x00038088
#define IPU_CSI1_CPD_GRS_3__EMPTY          IPU_REGISTERS_OFFSET+0x00038088,0x00000000
#define IPU_CSI1_CPD_GRS_3__FULL           IPU_REGISTERS_OFFSET+0x00038088,0xffffffff
#define IPU_CSI1_CPD_GRS_3__CSI1_CPD_GRS15 IPU_REGISTERS_OFFSET+0x00038088,0xFF000000
#define IPU_CSI1_CPD_GRS_3__CSI1_CPD_GRS14 IPU_REGISTERS_OFFSET+0x00038088,0x00FF0000
#define IPU_CSI1_CPD_GRS_3__CSI1_CPD_GRS13 IPU_REGISTERS_OFFSET+0x00038088,0x0000FF00
#define IPU_CSI1_CPD_GRS_3__CSI1_CPD_GRS12 IPU_REGISTERS_OFFSET+0x00038088,0x000000FF

#define IPU_CSI1_CPD_GBC_0__ADDR          IPU_REGISTERS_OFFSET+0x0003808C
#define IPU_CSI1_CPD_GBC_0__EMPTY         IPU_REGISTERS_OFFSET+0x0003808C,0x00000000
#define IPU_CSI1_CPD_GBC_0__FULL          IPU_REGISTERS_OFFSET+0x0003808C,0xffffffff
#define IPU_CSI1_CPD_GBC_0__CSI1_CPD_GBC1 IPU_REGISTERS_OFFSET+0x0003808C,0x01FF0000
#define IPU_CSI1_CPD_GBC_0__CSI1_CPD_GBC0 IPU_REGISTERS_OFFSET+0x0003808C,0x000001FF

#define IPU_CSI1_CPD_GBC_1__ADDR          IPU_REGISTERS_OFFSET+0x00038090
#define IPU_CSI1_CPD_GBC_1__EMPTY         IPU_REGISTERS_OFFSET+0x00038090,0x00000000
#define IPU_CSI1_CPD_GBC_1__FULL          IPU_REGISTERS_OFFSET+0x00038090,0xffffffff
#define IPU_CSI1_CPD_GBC_1__CSI1_CPD_GBC3 IPU_REGISTERS_OFFSET+0x00038090,0x01FF0000
#define IPU_CSI1_CPD_GBC_1__CSI1_CPD_GBC2 IPU_REGISTERS_OFFSET+0x00038090,0x000001FF

#define IPU_CSI1_CPD_GBC_2__ADDR          IPU_REGISTERS_OFFSET+0x00038094
#define IPU_CSI1_CPD_GBC_2__EMPTY         IPU_REGISTERS_OFFSET+0x00038094,0x00000000
#define IPU_CSI1_CPD_GBC_2__FULL          IPU_REGISTERS_OFFSET+0x00038094,0xffffffff
#define IPU_CSI1_CPD_GBC_2__CSI1_CPD_GBC5 IPU_REGISTERS_OFFSET+0x00038094,0x01FF0000
#define IPU_CSI1_CPD_GBC_2__CSI1_CPD_GBC4 IPU_REGISTERS_OFFSET+0x00038094,0x000001FF

#define IPU_CSI1_CPD_GBC_3__ADDR          IPU_REGISTERS_OFFSET+0x00038098
#define IPU_CSI1_CPD_GBC_3__EMPTY         IPU_REGISTERS_OFFSET+0x00038098,0x00000000
#define IPU_CSI1_CPD_GBC_3__FULL          IPU_REGISTERS_OFFSET+0x00038098,0xffffffff
#define IPU_CSI1_CPD_GBC_3__CSI1_CPD_GBC7 IPU_REGISTERS_OFFSET+0x00038098,0x01FF0000
#define IPU_CSI1_CPD_GBC_3__CSI1_CPD_GBC6 IPU_REGISTERS_OFFSET+0x00038098,0x000001FF

#define IPU_CSI1_CPD_GBC_4__ADDR          IPU_REGISTERS_OFFSET+0x0003809C
#define IPU_CSI1_CPD_GBC_4__EMPTY         IPU_REGISTERS_OFFSET+0x0003809C,0x00000000
#define IPU_CSI1_CPD_GBC_4__FULL          IPU_REGISTERS_OFFSET+0x0003809C,0xffffffff
#define IPU_CSI1_CPD_GBC_4__CSI1_CPD_GBC9 IPU_REGISTERS_OFFSET+0x0003809C,0x01FF0000
#define IPU_CSI1_CPD_GBC_4__CSI1_CPD_GBC8 IPU_REGISTERS_OFFSET+0x0003809C,0x000001FF

#define IPU_CSI1_CPD_GBC_5__ADDR           IPU_REGISTERS_OFFSET+0x000380A0
#define IPU_CSI1_CPD_GBC_5__EMPTY          IPU_REGISTERS_OFFSET+0x000380A0,0x00000000
#define IPU_CSI1_CPD_GBC_5__FULL           IPU_REGISTERS_OFFSET+0x000380A0,0xffffffff
#define IPU_CSI1_CPD_GBC_5__CSI1_CPD_GBC11 IPU_REGISTERS_OFFSET+0x000380A0,0x01FF0000
#define IPU_CSI1_CPD_GBC_5__CSI1_CPD_GBC10 IPU_REGISTERS_OFFSET+0x000380A0,0x000001FF

#define IPU_CSI1_CPD_GBC_6__ADDR           IPU_REGISTERS_OFFSET+0x000380A4
#define IPU_CSI1_CPD_GBC_6__EMPTY          IPU_REGISTERS_OFFSET+0x000380A4,0x00000000
#define IPU_CSI1_CPD_GBC_6__FULL           IPU_REGISTERS_OFFSET+0x000380A4,0xffffffff
#define IPU_CSI1_CPD_GBC_6__CSI1_CPD_GBC13 IPU_REGISTERS_OFFSET+0x000380A4,0x01FF0000
#define IPU_CSI1_CPD_GBC_6__CSI1_CPD_GBC12 IPU_REGISTERS_OFFSET+0x000380A4,0x000001FF

#define IPU_CSI1_CPD_GBC_7__ADDR           IPU_REGISTERS_OFFSET+0x000380A8
#define IPU_CSI1_CPD_GBC_7__EMPTY          IPU_REGISTERS_OFFSET+0x000380A8,0x00000000
#define IPU_CSI1_CPD_GBC_7__FULL           IPU_REGISTERS_OFFSET+0x000380A8,0xffffffff
#define IPU_CSI1_CPD_GBC_7__CSI1_CPD_GBC15 IPU_REGISTERS_OFFSET+0x000380A8,0x01FF0000
#define IPU_CSI1_CPD_GBC_7__CSI1_CPD_GBC14 IPU_REGISTERS_OFFSET+0x000380A8,0x000001FF

#define IPU_CSI1_CPD_GBS_0__ADDR          IPU_REGISTERS_OFFSET+0x000380AC
#define IPU_CSI1_CPD_GBS_0__EMPTY         IPU_REGISTERS_OFFSET+0x000380AC,0x00000000
#define IPU_CSI1_CPD_GBS_0__FULL          IPU_REGISTERS_OFFSET+0x000380AC,0xffffffff
#define IPU_CSI1_CPD_GBS_0__CSI1_CPD_GBS3 IPU_REGISTERS_OFFSET+0x000380AC,0xFF000000
#define IPU_CSI1_CPD_GBS_0__CSI1_CPD_GBS2 IPU_REGISTERS_OFFSET+0x000380AC,0x00FF0000
#define IPU_CSI1_CPD_GBS_0__CSI1_CPD_GBS1 IPU_REGISTERS_OFFSET+0x000380AC,0x0000FF00
#define IPU_CSI1_CPD_GBS_0__CSI1_CPD_GBS0 IPU_REGISTERS_OFFSET+0x000380AC,0x000000FF

#define IPU_CSI1_CPD_GBS_1__ADDR          IPU_REGISTERS_OFFSET+0x000380B0
#define IPU_CSI1_CPD_GBS_1__EMPTY         IPU_REGISTERS_OFFSET+0x000380B0,0x00000000
#define IPU_CSI1_CPD_GBS_1__FULL          IPU_REGISTERS_OFFSET+0x000380B0,0xffffffff
#define IPU_CSI1_CPD_GBS_1__CSI1_CPD_GBS7 IPU_REGISTERS_OFFSET+0x000380B0,0xFF000000
#define IPU_CSI1_CPD_GBS_1__CSI1_CPD_GBS6 IPU_REGISTERS_OFFSET+0x000380B0,0x00FF0000
#define IPU_CSI1_CPD_GBS_1__CSI1_CPD_GBS5 IPU_REGISTERS_OFFSET+0x000380B0,0x0000FF00
#define IPU_CSI1_CPD_GBS_1__CSI1_CPD_GBS4 IPU_REGISTERS_OFFSET+0x000380B0,0x000000FF

#define IPU_CSI1_CPD_GBS_2__ADDR           IPU_REGISTERS_OFFSET+0x000380B4
#define IPU_CSI1_CPD_GBS_2__EMPTY          IPU_REGISTERS_OFFSET+0x000380B4,0x00000000
#define IPU_CSI1_CPD_GBS_2__FULL           IPU_REGISTERS_OFFSET+0x000380B4,0xffffffff
#define IPU_CSI1_CPD_GBS_2__CSI1_CPD_GBS11 IPU_REGISTERS_OFFSET+0x000380B4,0xFF000000
#define IPU_CSI1_CPD_GBS_2__CSI1_CPD_GBS10 IPU_REGISTERS_OFFSET+0x000380B4,0x00FF0000
#define IPU_CSI1_CPD_GBS_2__CSI1_CPD_GBS9  IPU_REGISTERS_OFFSET+0x000380B4,0x0000FF00
#define IPU_CSI1_CPD_GBS_2__CSI1_CPD_GBS8  IPU_REGISTERS_OFFSET+0x000380B4,0x000000FF

#define IPU_CSI1_CPD_GBS_3__ADDR           IPU_REGISTERS_OFFSET+0x000380B8
#define IPU_CSI1_CPD_GBS_3__EMPTY          IPU_REGISTERS_OFFSET+0x000380B8,0x00000000
#define IPU_CSI1_CPD_GBS_3__FULL           IPU_REGISTERS_OFFSET+0x000380B8,0xffffffff
#define IPU_CSI1_CPD_GBS_3__CSI1_CPD_GBS15 IPU_REGISTERS_OFFSET+0x000380B8,0xFF000000
#define IPU_CSI1_CPD_GBS_3__CSI1_CPD_GBS14 IPU_REGISTERS_OFFSET+0x000380B8,0x00FF0000
#define IPU_CSI1_CPD_GBS_3__CSI1_CPD_GBS13 IPU_REGISTERS_OFFSET+0x000380B8,0x0000FF00
#define IPU_CSI1_CPD_GBS_3__CSI1_CPD_GBS12 IPU_REGISTERS_OFFSET+0x000380B8,0x000000FF

#define IPU_CSI1_CPD_BC_0__ADDR         IPU_REGISTERS_OFFSET+0x000380BC
#define IPU_CSI1_CPD_BC_0__EMPTY        IPU_REGISTERS_OFFSET+0x000380BC,0x00000000
#define IPU_CSI1_CPD_BC_0__FULL         IPU_REGISTERS_OFFSET+0x000380BC,0xffffffff
#define IPU_CSI1_CPD_BC_0__CSI1_CPD_BC1 IPU_REGISTERS_OFFSET+0x000380BC,0x01FF0000
#define IPU_CSI1_CPD_BC_0__CSI1_CPD_BC0 IPU_REGISTERS_OFFSET+0x000380BC,0x000001FF

#define IPU_CSI1_CPD_BC_1__ADDR         IPU_REGISTERS_OFFSET+0x000380C0
#define IPU_CSI1_CPD_BC_1__EMPTY        IPU_REGISTERS_OFFSET+0x000380C0,0x00000000
#define IPU_CSI1_CPD_BC_1__FULL         IPU_REGISTERS_OFFSET+0x000380C0,0xffffffff
#define IPU_CSI1_CPD_BC_1__CSI1_CPD_BC3 IPU_REGISTERS_OFFSET+0x000380C0,0x01FF0000
#define IPU_CSI1_CPD_BC_1__CSI1_CPD_BC2 IPU_REGISTERS_OFFSET+0x000380C0,0x000001FF

#define IPU_CSI1_CPD_BC_2__ADDR         IPU_REGISTERS_OFFSET+0x000380C4
#define IPU_CSI1_CPD_BC_2__EMPTY        IPU_REGISTERS_OFFSET+0x000380C4,0x00000000
#define IPU_CSI1_CPD_BC_2__FULL         IPU_REGISTERS_OFFSET+0x000380C4,0xffffffff
#define IPU_CSI1_CPD_BC_2__CSI1_CPD_BC5 IPU_REGISTERS_OFFSET+0x000380C4,0x01FF0000
#define IPU_CSI1_CPD_BC_2__CSI1_CPD_BC4 IPU_REGISTERS_OFFSET+0x000380C4,0x000001FF

#define IPU_CSI1_CPD_BC_3__ADDR         IPU_REGISTERS_OFFSET+0x000380C8
#define IPU_CSI1_CPD_BC_3__EMPTY        IPU_REGISTERS_OFFSET+0x000380C8,0x00000000
#define IPU_CSI1_CPD_BC_3__FULL         IPU_REGISTERS_OFFSET+0x000380C8,0xffffffff
#define IPU_CSI1_CPD_BC_3__CSI1_CPD_BC7 IPU_REGISTERS_OFFSET+0x000380C8,0x01FF0000
#define IPU_CSI1_CPD_BC_3__CSI1_CPD_BC6 IPU_REGISTERS_OFFSET+0x000380C8,0x000001FF

#define IPU_CSI1_CPD_BC_4__ADDR         IPU_REGISTERS_OFFSET+0x000380CC
#define IPU_CSI1_CPD_BC_4__EMPTY        IPU_REGISTERS_OFFSET+0x000380CC,0x00000000
#define IPU_CSI1_CPD_BC_4__FULL         IPU_REGISTERS_OFFSET+0x000380CC,0xffffffff
#define IPU_CSI1_CPD_BC_4__CSI1_CPD_BC9 IPU_REGISTERS_OFFSET+0x000380CC,0x01FF0000
#define IPU_CSI1_CPD_BC_4__CSI1_CPD_BC8 IPU_REGISTERS_OFFSET+0x000380CC,0x000001FF

#define IPU_CSI1_CPD_BC_5__ADDR          IPU_REGISTERS_OFFSET+0x000380D0
#define IPU_CSI1_CPD_BC_5__EMPTY         IPU_REGISTERS_OFFSET+0x000380D0,0x00000000
#define IPU_CSI1_CPD_BC_5__FULL          IPU_REGISTERS_OFFSET+0x000380D0,0xffffffff
#define IPU_CSI1_CPD_BC_5__CSI1_CPD_BC11 IPU_REGISTERS_OFFSET+0x000380D0,0x01FF0000
#define IPU_CSI1_CPD_BC_5__CSI1_CPD_BC10 IPU_REGISTERS_OFFSET+0x000380D0,0x000001FF

#define IPU_CSI1_CPD_BC_6__ADDR          IPU_REGISTERS_OFFSET+0x000380D4
#define IPU_CSI1_CPD_BC_6__EMPTY         IPU_REGISTERS_OFFSET+0x000380D4,0x00000000
#define IPU_CSI1_CPD_BC_6__FULL          IPU_REGISTERS_OFFSET+0x000380D4,0xffffffff
#define IPU_CSI1_CPD_BC_6__CSI1_CPD_BC13 IPU_REGISTERS_OFFSET+0x000380D4,0x01FF0000
#define IPU_CSI1_CPD_BC_6__CSI1_CPD_BC12 IPU_REGISTERS_OFFSET+0x000380D4,0x000001FF

#define IPU_CSI1_CPD_BC_7__ADDR          IPU_REGISTERS_OFFSET+0x000380D8
#define IPU_CSI1_CPD_BC_7__EMPTY         IPU_REGISTERS_OFFSET+0x000380D8,0x00000000
#define IPU_CSI1_CPD_BC_7__FULL          IPU_REGISTERS_OFFSET+0x000380D8,0xffffffff
#define IPU_CSI1_CPD_BC_7__CSI1_CPD_BC15 IPU_REGISTERS_OFFSET+0x000380D8,0x01FF0000
#define IPU_CSI1_CPD_BC_7__CSI1_CPD_BC14 IPU_REGISTERS_OFFSET+0x000380D8,0x000001FF

#define IPU_CSI1_CPD_BS_0__ADDR         IPU_REGISTERS_OFFSET+0x000380DC
#define IPU_CSI1_CPD_BS_0__EMPTY        IPU_REGISTERS_OFFSET+0x000380DC,0x00000000
#define IPU_CSI1_CPD_BS_0__FULL         IPU_REGISTERS_OFFSET+0x000380DC,0xffffffff
#define IPU_CSI1_CPD_BS_0__CSI1_CPD_BS3 IPU_REGISTERS_OFFSET+0x000380DC,0xFF000000
#define IPU_CSI1_CPD_BS_0__CSI1_CPD_BS2 IPU_REGISTERS_OFFSET+0x000380DC,0x00FF0000
#define IPU_CSI1_CPD_BS_0__CSI1_CPD_BS1 IPU_REGISTERS_OFFSET+0x000380DC,0x0000FF00
#define IPU_CSI1_CPD_BS_0__CSI1_CPD_BS0 IPU_REGISTERS_OFFSET+0x000380DC,0x000000FF

#define IPU_CSI1_CPD_BS_1__ADDR         IPU_REGISTERS_OFFSET+0x000380E0
#define IPU_CSI1_CPD_BS_1__EMPTY        IPU_REGISTERS_OFFSET+0x000380E0,0x00000000
#define IPU_CSI1_CPD_BS_1__FULL         IPU_REGISTERS_OFFSET+0x000380E0,0xffffffff
#define IPU_CSI1_CPD_BS_1__CSI1_CPD_BS7 IPU_REGISTERS_OFFSET+0x000380E0,0xFF000000
#define IPU_CSI1_CPD_BS_1__CSI1_CPD_BS6 IPU_REGISTERS_OFFSET+0x000380E0,0x00FF0000
#define IPU_CSI1_CPD_BS_1__CSI1_CPD_BS5 IPU_REGISTERS_OFFSET+0x000380E0,0x0000FF00
#define IPU_CSI1_CPD_BS_1__CSI1_CPD_BS4 IPU_REGISTERS_OFFSET+0x000380E0,0x000000FF

#define IPU_CSI1_CPD_BS_2__ADDR          IPU_REGISTERS_OFFSET+0x000380E4
#define IPU_CSI1_CPD_BS_2__EMPTY         IPU_REGISTERS_OFFSET+0x000380E4,0x00000000
#define IPU_CSI1_CPD_BS_2__FULL          IPU_REGISTERS_OFFSET+0x000380E4,0xffffffff
#define IPU_CSI1_CPD_BS_2__CSI1_CPD_BS11 IPU_REGISTERS_OFFSET+0x000380E4,0xFF000000
#define IPU_CSI1_CPD_BS_2__CSI1_CPD_BS10 IPU_REGISTERS_OFFSET+0x000380E4,0x00FF0000
#define IPU_CSI1_CPD_BS_2__CSI1_CPD_BS9  IPU_REGISTERS_OFFSET+0x000380E4,0x0000FF00
#define IPU_CSI1_CPD_BS_2__CSI1_CPD_BS8  IPU_REGISTERS_OFFSET+0x000380E4,0x000000FF

#define IPU_CSI1_CPD_BS_3__ADDR          IPU_REGISTERS_OFFSET+0x000380E8
#define IPU_CSI1_CPD_BS_3__EMPTY         IPU_REGISTERS_OFFSET+0x000380E8,0x00000000
#define IPU_CSI1_CPD_BS_3__FULL          IPU_REGISTERS_OFFSET+0x000380E8,0xffffffff
#define IPU_CSI1_CPD_BS_3__CSI1_CPD_BS15 IPU_REGISTERS_OFFSET+0x000380E8,0xFF000000
#define IPU_CSI1_CPD_BS_3__CSI1_CPD_BS14 IPU_REGISTERS_OFFSET+0x000380E8,0x00FF0000
#define IPU_CSI1_CPD_BS_3__CSI1_CPD_BS13 IPU_REGISTERS_OFFSET+0x000380E8,0x0000FF00
#define IPU_CSI1_CPD_BS_3__CSI1_CPD_BS12 IPU_REGISTERS_OFFSET+0x000380E8,0x000000FF

#define IPU_CSI1_CPD_OFFSET1__ADDR               IPU_REGISTERS_OFFSET+0x000380EC
#define IPU_CSI1_CPD_OFFSET1__EMPTY              IPU_REGISTERS_OFFSET+0x000380EC,0x00000000
#define IPU_CSI1_CPD_OFFSET1__FULL               IPU_REGISTERS_OFFSET+0x000380EC,0xffffffff
#define IPU_CSI1_CPD_OFFSET1__CSI1_CPD_B_OFFSET  IPU_REGISTERS_OFFSET+0x000380EC,0x3FF00000
#define IPU_CSI1_CPD_OFFSET1__CSI1_CPD_GB_OFFSET IPU_REGISTERS_OFFSET+0x000380EC,0x000FFC00
#define IPU_CSI1_CPD_OFFSET1__CSI1_CPD_GR_OFFSET IPU_REGISTERS_OFFSET+0x000380EC,0x000003FF

#define IPU_CSI1_CPD_OFFSET2__ADDR              IPU_REGISTERS_OFFSET+0x000380F0
#define IPU_CSI1_CPD_OFFSET2__EMPTY             IPU_REGISTERS_OFFSET+0x000380F0,0x00000000
#define IPU_CSI1_CPD_OFFSET2__FULL              IPU_REGISTERS_OFFSET+0x000380F0,0xffffffff
#define IPU_CSI1_CPD_OFFSET2__CSI1_CPD_R_OFFSET IPU_REGISTERS_OFFSET+0x000380F0,0x000003FF

#define IPU_DI0_GENERAL__ADDR                  IPU_REGISTERS_OFFSET+0x00040000
#define IPU_DI0_GENERAL__EMPTY                 IPU_REGISTERS_OFFSET+0x00040000,0x00000000
#define IPU_DI0_GENERAL__FULL                  IPU_REGISTERS_OFFSET+0x00040000,0xffffffff
#define IPU_DI0_GENERAL__DI0_PIN8_PIN15_SEL    IPU_REGISTERS_OFFSET+0x00040000,0x80000000
#define IPU_DI0_GENERAL__DI0_DISP_Y_SEL        IPU_REGISTERS_OFFSET+0x00040000,0x70000000
#define IPU_DI0_GENERAL__DI0_CLOCK_STOP_MODE   IPU_REGISTERS_OFFSET+0x00040000,0x0F000000
#define IPU_DI0_GENERAL__DI0_DISP_CLOCK_INIT   IPU_REGISTERS_OFFSET+0x00040000,0x00800000
#define IPU_DI0_GENERAL__DI0_MASK_SEL          IPU_REGISTERS_OFFSET+0x00040000,0x00400000
#define IPU_DI0_GENERAL__DI0_VSYNC_EXT         IPU_REGISTERS_OFFSET+0x00040000,0x00200000
#define IPU_DI0_GENERAL__DI0_CLK_EXT           IPU_REGISTERS_OFFSET+0x00040000,0x00100000
#define IPU_DI0_GENERAL__DI0_WATCHDOG_MODE     IPU_REGISTERS_OFFSET+0x00040000,0x000C0000
#define IPU_DI0_GENERAL__DI0_POLARITY_DISP_CLK IPU_REGISTERS_OFFSET+0x00040000,0x00020000
#define IPU_DI0_GENERAL__DI0_SYNC_COUNT_SEL    IPU_REGISTERS_OFFSET+0x00040000,0x0000F000
#define IPU_DI0_GENERAL__DI0_ERR_TREATMENT     IPU_REGISTERS_OFFSET+0x00040000,0x00000800
#define IPU_DI0_GENERAL__DI0_ERM_VSYNC_SEL     IPU_REGISTERS_OFFSET+0x00040000,0x00000400
#define IPU_DI0_GENERAL__DI0_POLARITY_CS1      IPU_REGISTERS_OFFSET+0x00040000,0x00000200
#define IPU_DI0_GENERAL__DI0_POLARITY_CS0      IPU_REGISTERS_OFFSET+0x00040000,0x00000100
#define IPU_DI0_GENERAL__DI0_POLARITY_8        IPU_REGISTERS_OFFSET+0x00040000,0x00000080
#define IPU_DI0_GENERAL__DI0_POLARITY_7        IPU_REGISTERS_OFFSET+0x00040000,0x00000040
#define IPU_DI0_GENERAL__DI0_POLARITY_6        IPU_REGISTERS_OFFSET+0x00040000,0x00000020
#define IPU_DI0_GENERAL__DI0_POLARITY_5        IPU_REGISTERS_OFFSET+0x00040000,0x00000010
#define IPU_DI0_GENERAL__DI0_POLARITY_4        IPU_REGISTERS_OFFSET+0x00040000,0x00000008
#define IPU_DI0_GENERAL__DI0_POLARITY_3        IPU_REGISTERS_OFFSET+0x00040000,0x00000004
#define IPU_DI0_GENERAL__DI0_POLARITY_2        IPU_REGISTERS_OFFSET+0x00040000,0x00000002
#define IPU_DI0_GENERAL__DI0_POLARITY_1        IPU_REGISTERS_OFFSET+0x00040000,0x00000001

#define IPU_DI0_BS_CLKGEN0__ADDR                IPU_REGISTERS_OFFSET+0x00040004
#define IPU_DI0_BS_CLKGEN0__EMPTY               IPU_REGISTERS_OFFSET+0x00040004,0x00000000
#define IPU_DI0_BS_CLKGEN0__FULL                IPU_REGISTERS_OFFSET+0x00040004,0xffffffff
#define IPU_DI0_BS_CLKGEN0__DI0_DISP_CLK_OFFSET IPU_REGISTERS_OFFSET+0x00040004,0x01FF0000
#define IPU_DI0_BS_CLKGEN0__DI0_DISP_CLK_PERIOD IPU_REGISTERS_OFFSET+0x00040004,0x00000FFF

#define IPU_DI0_BS_CLKGEN1__ADDR              IPU_REGISTERS_OFFSET+0x00040008
#define IPU_DI0_BS_CLKGEN1__EMPTY             IPU_REGISTERS_OFFSET+0x00040008,0x00000000
#define IPU_DI0_BS_CLKGEN1__FULL              IPU_REGISTERS_OFFSET+0x00040008,0xffffffff
#define IPU_DI0_BS_CLKGEN1__DI0_DISP_CLK_DOWN IPU_REGISTERS_OFFSET+0x00040008,0x01FF0000
#define IPU_DI0_BS_CLKGEN1__DI0_DISP_CLK_UP   IPU_REGISTERS_OFFSET+0x00040008,0x000001FF

#define DI_SWGEN0_ADDR(di, pointer) 							(IPU_DI0_GENERAL__ADDR + \
																							di *0x8000 + \
																							(pointer-1) * 0x4 + 0x000C)
#define DI_SWGEN0_EMPTY(di, pointer) 						DI_SWGEN0_ADDR(di, pointer), 0x00000000
#define DI_SWGEN0_FULL(di, pointer) 							DI_SWGEN0_ADDR(di, pointer), 0xFFFFFFFF

#define DI_SWGEN0_RUN_VALUE_M1(di, pointer) 		DI_SWGEN0_ADDR(di, pointer), 0x7FF80000
#define DI_SWGEN0_RUN_RESOL(di, pointer) 				DI_SWGEN0_ADDR(di, pointer), 0x00070000
#define DI_SWGEN0_OFFSET_VALUE(di, pointer) 			DI_SWGEN0_ADDR(di, pointer), 0x00007FF8
#define DI_SWGEN0_OFFSET_RESOL(di, pointer) 			DI_SWGEN0_ADDR(di, pointer), 0x00000007

#define DI_SWGEN1_ADDR(di, pointer) 							(IPU_DI0_GENERAL__ADDR + \
																							di *0x8000 + \
																							(pointer-1) * 0x4 + 0x0030)
#define DI_SWGEN1_EMPTY(di, pointer) 						DI_SWGEN1_ADDR(di, pointer), 0x00000000
#define DI_SWGEN1_FULL(di, pointer) 							DI_SWGEN1_ADDR(di, pointer), 0xFFFFFFFF

#define DI_SWGEN1_CNT_POL_GEN_EN(di, pointer) 	DI_SWGEN1_ADDR(di, pointer), 0x60000000
#define DI_SWGEN1_CNT_AUTOLOAD(di, pointer)		DI_SWGEN1_ADDR(di, pointer), 0x10000000
#define DI_SWGEN1_CNT_CLR_SEL(di, pointer) 			DI_SWGEN1_ADDR(di, pointer), 0x0E000000
#define DI_SWGEN1_CNT_DOW(di, pointer) 					DI_SWGEN1_ADDR(di, pointer), 0x01FF0000
#define DI_SWGEN1_CNT_POL_TRIG_SEL(di, pointer) DI_SWGEN1_ADDR(di, pointer), 0x00007000
#define DI_SWGEN1_CNT_POL_CLR_SEL(di, pointer)	DI_SWGEN1_ADDR(di, pointer), 0x00000E00
#define DI_SWGEN1_CNT_CNT_UP(di, pointer) 				DI_SWGEN1_ADDR(di, pointer), 0x000001FF

#define IPU_DI0_SW_GEN0_1__ADDR                    IPU_REGISTERS_OFFSET+0x0004000C
#define IPU_DI0_SW_GEN0_1__EMPTY                   IPU_REGISTERS_OFFSET+0x0004000C,0x00000000
#define IPU_DI0_SW_GEN0_1__FULL                    IPU_REGISTERS_OFFSET+0x0004000C,0xffffffff
#define IPU_DI0_SW_GEN0_1__DI0_RUN_VALUE_M1_1      IPU_REGISTERS_OFFSET+0x0004000C,0x7FF80000
#define IPU_DI0_SW_GEN0_1__DI0_RUN_RESOLUTION_1    IPU_REGISTERS_OFFSET+0x0004000C,0x00070000
#define IPU_DI0_SW_GEN0_1__DI0_OFFSET_VALUE_1      IPU_REGISTERS_OFFSET+0x0004000C,0x00007FF8
#define IPU_DI0_SW_GEN0_1__DI0_OFFSET_RESOLUTION_1 IPU_REGISTERS_OFFSET+0x0004000C,0x00000007

#define IPU_DI0_SW_GEN0_2__ADDR                    IPU_REGISTERS_OFFSET+0x00040010
#define IPU_DI0_SW_GEN0_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00040010,0x00000000
#define IPU_DI0_SW_GEN0_2__FULL                    IPU_REGISTERS_OFFSET+0x00040010,0xffffffff
#define IPU_DI0_SW_GEN0_2__DI0_RUN_VALUE_M1_2      IPU_REGISTERS_OFFSET+0x00040010,0x7FF80000
#define IPU_DI0_SW_GEN0_2__DI0_RUN_RESOLUTION_2    IPU_REGISTERS_OFFSET+0x00040010,0x00070000
#define IPU_DI0_SW_GEN0_2__DI0_OFFSET_VALUE_2      IPU_REGISTERS_OFFSET+0x00040010,0x00007FF8
#define IPU_DI0_SW_GEN0_2__DI0_OFFSET_RESOLUTION_2 IPU_REGISTERS_OFFSET+0x00040010,0x00000007

#define IPU_DI0_SW_GEN0_3__ADDR                    IPU_REGISTERS_OFFSET+0x00040014
#define IPU_DI0_SW_GEN0_3__EMPTY                   IPU_REGISTERS_OFFSET+0x00040014,0x00000000
#define IPU_DI0_SW_GEN0_3__FULL                    IPU_REGISTERS_OFFSET+0x00040014,0xffffffff
#define IPU_DI0_SW_GEN0_3__DI0_RUN_VALUE_M1_3      IPU_REGISTERS_OFFSET+0x00040014,0x7FF80000
#define IPU_DI0_SW_GEN0_3__DI0_RUN_RESOLUTION_3    IPU_REGISTERS_OFFSET+0x00040014,0x00070000
#define IPU_DI0_SW_GEN0_3__DI0_OFFSET_VALUE_3      IPU_REGISTERS_OFFSET+0x00040014,0x00007FF8
#define IPU_DI0_SW_GEN0_3__DI0_OFFSET_RESOLUTION_3 IPU_REGISTERS_OFFSET+0x00040014,0x00000007

#define IPU_DI0_SW_GEN0_4__ADDR                    IPU_REGISTERS_OFFSET+0x00040018
#define IPU_DI0_SW_GEN0_4__EMPTY                   IPU_REGISTERS_OFFSET+0x00040018,0x00000000
#define IPU_DI0_SW_GEN0_4__FULL                    IPU_REGISTERS_OFFSET+0x00040018,0xffffffff
#define IPU_DI0_SW_GEN0_4__DI0_RUN_VALUE_M1_4      IPU_REGISTERS_OFFSET+0x00040018,0x7FF80000
#define IPU_DI0_SW_GEN0_4__DI0_RUN_RESOLUTION_4    IPU_REGISTERS_OFFSET+0x00040018,0x00070000
#define IPU_DI0_SW_GEN0_4__DI0_OFFSET_VALUE_4      IPU_REGISTERS_OFFSET+0x00040018,0x00007FF8
#define IPU_DI0_SW_GEN0_4__DI0_OFFSET_RESOLUTION_4 IPU_REGISTERS_OFFSET+0x00040018,0x00000007

#define IPU_DI0_SW_GEN0_5__ADDR                    IPU_REGISTERS_OFFSET+0x0004001C
#define IPU_DI0_SW_GEN0_5__EMPTY                   IPU_REGISTERS_OFFSET+0x0004001C,0x00000000
#define IPU_DI0_SW_GEN0_5__FULL                    IPU_REGISTERS_OFFSET+0x0004001C,0xffffffff
#define IPU_DI0_SW_GEN0_5__DI0_RUN_VALUE_M1_5      IPU_REGISTERS_OFFSET+0x0004001C,0x7FF80000
#define IPU_DI0_SW_GEN0_5__DI0_RUN_RESOLUTION_5    IPU_REGISTERS_OFFSET+0x0004001C,0x00070000
#define IPU_DI0_SW_GEN0_5__DI0_OFFSET_VALUE_5      IPU_REGISTERS_OFFSET+0x0004001C,0x00007FF8
#define IPU_DI0_SW_GEN0_5__DI0_OFFSET_RESOLUTION_5 IPU_REGISTERS_OFFSET+0x0004001C,0x00000007

#define IPU_DI0_SW_GEN0_6__ADDR                    IPU_REGISTERS_OFFSET+0x00040020
#define IPU_DI0_SW_GEN0_6__EMPTY                   IPU_REGISTERS_OFFSET+0x00040020,0x00000000
#define IPU_DI0_SW_GEN0_6__FULL                    IPU_REGISTERS_OFFSET+0x00040020,0xffffffff
#define IPU_DI0_SW_GEN0_6__DI0_RUN_VALUE_M1_6      IPU_REGISTERS_OFFSET+0x00040020,0x7FF80000
#define IPU_DI0_SW_GEN0_6__DI0_RUN_RESOLUTION_6    IPU_REGISTERS_OFFSET+0x00040020,0x00070000
#define IPU_DI0_SW_GEN0_6__DI0_OFFSET_VALUE_6      IPU_REGISTERS_OFFSET+0x00040020,0x00007FF8
#define IPU_DI0_SW_GEN0_6__DI0_OFFSET_RESOLUTION_6 IPU_REGISTERS_OFFSET+0x00040020,0x00000007

#define IPU_DI0_SW_GEN0_7__ADDR                    IPU_REGISTERS_OFFSET+0x00040024
#define IPU_DI0_SW_GEN0_7__EMPTY                   IPU_REGISTERS_OFFSET+0x00040024,0x00000000
#define IPU_DI0_SW_GEN0_7__FULL                    IPU_REGISTERS_OFFSET+0x00040024,0xffffffff
#define IPU_DI0_SW_GEN0_7__DI0_RUN_VALUE_M1_7      IPU_REGISTERS_OFFSET+0x00040024,0x7FF80000
#define IPU_DI0_SW_GEN0_7__DI0_RUN_RESOLUTION_7    IPU_REGISTERS_OFFSET+0x00040024,0x00070000
#define IPU_DI0_SW_GEN0_7__DI0_OFFSET_VALUE_7      IPU_REGISTERS_OFFSET+0x00040024,0x00007FF8
#define IPU_DI0_SW_GEN0_7__DI0_OFFSET_RESOLUTION_7 IPU_REGISTERS_OFFSET+0x00040024,0x00000007

#define IPU_DI0_SW_GEN0_8__ADDR                    IPU_REGISTERS_OFFSET+0x00040028
#define IPU_DI0_SW_GEN0_8__EMPTY                   IPU_REGISTERS_OFFSET+0x00040028,0x00000000
#define IPU_DI0_SW_GEN0_8__FULL                    IPU_REGISTERS_OFFSET+0x00040028,0xffffffff
#define IPU_DI0_SW_GEN0_8__DI0_RUN_VALUE_M1_8      IPU_REGISTERS_OFFSET+0x00040028,0x7FF80000
#define IPU_DI0_SW_GEN0_8__DI0_RUN_RESOLUTION_8    IPU_REGISTERS_OFFSET+0x00040028,0x00070000
#define IPU_DI0_SW_GEN0_8__DI0_OFFSET_VALUE_8      IPU_REGISTERS_OFFSET+0x00040028,0x00007FF8
#define IPU_DI0_SW_GEN0_8__DI0_OFFSET_RESOLUTION_8 IPU_REGISTERS_OFFSET+0x00040028,0x00000007

#define IPU_DI0_SW_GEN0_9__ADDR                    IPU_REGISTERS_OFFSET+0x0004002C
#define IPU_DI0_SW_GEN0_9__EMPTY                   IPU_REGISTERS_OFFSET+0x0004002C,0x00000000
#define IPU_DI0_SW_GEN0_9__FULL                    IPU_REGISTERS_OFFSET+0x0004002C,0xffffffff
#define IPU_DI0_SW_GEN0_9__DI0_RUN_VALUE_M1_9      IPU_REGISTERS_OFFSET+0x0004002C,0x7FF80000
#define IPU_DI0_SW_GEN0_9__DI0_RUN_RESOLUTION_9    IPU_REGISTERS_OFFSET+0x0004002C,0x00070000
#define IPU_DI0_SW_GEN0_9__DI0_OFFSET_VALUE_9      IPU_REGISTERS_OFFSET+0x0004002C,0x00007FF8
#define IPU_DI0_SW_GEN0_9__DI0_OFFSET_RESOLUTION_9 IPU_REGISTERS_OFFSET+0x0004002C,0x00000007

#define IPU_DI0_SW_GEN1_1__ADDR                           IPU_REGISTERS_OFFSET+0x00040030
#define IPU_DI0_SW_GEN1_1__EMPTY                          IPU_REGISTERS_OFFSET+0x00040030,0x00000000
#define IPU_DI0_SW_GEN1_1__FULL                           IPU_REGISTERS_OFFSET+0x00040030,0xffffffff
#define IPU_DI0_SW_GEN1_1__DI0_CNT_POLARITY_GEN_EN_1      IPU_REGISTERS_OFFSET+0x00040030,0x60000000
#define IPU_DI0_SW_GEN1_1__DI0_CNT_AUTO_RELOAD_1          IPU_REGISTERS_OFFSET+0x00040030,0x10000000
#define IPU_DI0_SW_GEN1_1__DI0_CNT_CLR_SEL_1              IPU_REGISTERS_OFFSET+0x00040030,0x0E000000
#define IPU_DI0_SW_GEN1_1__DI0_CNT_DOWN_1                 IPU_REGISTERS_OFFSET+0x00040030,0x01FF0000
#define IPU_DI0_SW_GEN1_1__DI0_CNT_POLARITY_TRIGGER_SEL_1 IPU_REGISTERS_OFFSET+0x00040030,0x00007000
#define IPU_DI0_SW_GEN1_1__DI0_CNT_POLARITY_CLR_SEL_1     IPU_REGISTERS_OFFSET+0x00040030,0x00000E00
#define IPU_DI0_SW_GEN1_1__DI0_CNT_UP_1                   IPU_REGISTERS_OFFSET+0x00040030,0x000001FF

#define IPU_DI0_SW_GEN1_2__ADDR                           IPU_REGISTERS_OFFSET+0x00040034
#define IPU_DI0_SW_GEN1_2__EMPTY                          IPU_REGISTERS_OFFSET+0x00040034,0x00000000
#define IPU_DI0_SW_GEN1_2__FULL                           IPU_REGISTERS_OFFSET+0x00040034,0xffffffff
#define IPU_DI0_SW_GEN1_2__DI0_CNT_POLARITY_GEN_EN_2      IPU_REGISTERS_OFFSET+0x00040034,0x60000000
#define IPU_DI0_SW_GEN1_2__DI0_CNT_AUTO_RELOAD_2          IPU_REGISTERS_OFFSET+0x00040034,0x10000000
#define IPU_DI0_SW_GEN1_2__DI0_CNT_CLR_SEL_2              IPU_REGISTERS_OFFSET+0x00040034,0x0E000000
#define IPU_DI0_SW_GEN1_2__DI0_CNT_DOWN_2                 IPU_REGISTERS_OFFSET+0x00040034,0x01FF0000
#define IPU_DI0_SW_GEN1_2__DI0_CNT_POLARITY_TRIGGER_SEL_2 IPU_REGISTERS_OFFSET+0x00040034,0x00007000
#define IPU_DI0_SW_GEN1_2__DI0_CNT_POLARITY_CLR_SEL_2     IPU_REGISTERS_OFFSET+0x00040034,0x00000E00
#define IPU_DI0_SW_GEN1_2__DI0_CNT_UP_2                   IPU_REGISTERS_OFFSET+0x00040034,0x000001FF

#define IPU_DI0_SW_GEN1_3__ADDR                           IPU_REGISTERS_OFFSET+0x00040038
#define IPU_DI0_SW_GEN1_3__EMPTY                          IPU_REGISTERS_OFFSET+0x00040038,0x00000000
#define IPU_DI0_SW_GEN1_3__FULL                           IPU_REGISTERS_OFFSET+0x00040038,0xffffffff
#define IPU_DI0_SW_GEN1_3__DI0_CNT_POLARITY_GEN_EN_3      IPU_REGISTERS_OFFSET+0x00040038,0x60000000
#define IPU_DI0_SW_GEN1_3__DI0_CNT_AUTO_RELOAD_3          IPU_REGISTERS_OFFSET+0x00040038,0x10000000
#define IPU_DI0_SW_GEN1_3__DI0_CNT_CLR_SEL_3              IPU_REGISTERS_OFFSET+0x00040038,0x0E000000
#define IPU_DI0_SW_GEN1_3__DI0_CNT_DOWN_3                 IPU_REGISTERS_OFFSET+0x00040038,0x01FF0000
#define IPU_DI0_SW_GEN1_3__DI0_CNT_POLARITY_TRIGGER_SEL_3 IPU_REGISTERS_OFFSET+0x00040038,0x00007000
#define IPU_DI0_SW_GEN1_3__DI0_CNT_POLARITY_CLR_SEL_3     IPU_REGISTERS_OFFSET+0x00040038,0x00000E00
#define IPU_DI0_SW_GEN1_3__DI0_CNT_UP_3                   IPU_REGISTERS_OFFSET+0x00040038,0x000001FF

#define IPU_DI0_SW_GEN1_4__ADDR                           IPU_REGISTERS_OFFSET+0x0004003C
#define IPU_DI0_SW_GEN1_4__EMPTY                          IPU_REGISTERS_OFFSET+0x0004003C,0x00000000
#define IPU_DI0_SW_GEN1_4__FULL                           IPU_REGISTERS_OFFSET+0x0004003C,0xffffffff
#define IPU_DI0_SW_GEN1_4__DI0_CNT_POLARITY_GEN_EN_4      IPU_REGISTERS_OFFSET+0x0004003C,0x60000000
#define IPU_DI0_SW_GEN1_4__DI0_CNT_AUTO_RELOAD_4          IPU_REGISTERS_OFFSET+0x0004003C,0x10000000
#define IPU_DI0_SW_GEN1_4__DI0_CNT_CLR_SEL_4              IPU_REGISTERS_OFFSET+0x0004003C,0x0E000000
#define IPU_DI0_SW_GEN1_4__DI0_CNT_DOWN_4                 IPU_REGISTERS_OFFSET+0x0004003C,0x01FF0000
#define IPU_DI0_SW_GEN1_4__DI0_CNT_POLARITY_TRIGGER_SEL_4 IPU_REGISTERS_OFFSET+0x0004003C,0x00007000
#define IPU_DI0_SW_GEN1_4__DI0_CNT_POLARITY_CLR_SEL_4     IPU_REGISTERS_OFFSET+0x0004003C,0x00000E00
#define IPU_DI0_SW_GEN1_4__DI0_CNT_UP_4                   IPU_REGISTERS_OFFSET+0x0004003C,0x000001FF

#define IPU_DI0_SW_GEN1_5__ADDR                           IPU_REGISTERS_OFFSET+0x00040040
#define IPU_DI0_SW_GEN1_5__EMPTY                          IPU_REGISTERS_OFFSET+0x00040040,0x00000000
#define IPU_DI0_SW_GEN1_5__FULL                           IPU_REGISTERS_OFFSET+0x00040040,0xffffffff
#define IPU_DI0_SW_GEN1_5__DI0_CNT_POLARITY_GEN_EN_5      IPU_REGISTERS_OFFSET+0x00040040,0x60000000
#define IPU_DI0_SW_GEN1_5__DI0_CNT_AUTO_RELOAD_5          IPU_REGISTERS_OFFSET+0x00040040,0x10000000
#define IPU_DI0_SW_GEN1_5__DI0_CNT_CLR_SEL_5              IPU_REGISTERS_OFFSET+0x00040040,0x0E000000
#define IPU_DI0_SW_GEN1_5__DI0_CNT_DOWN_5                 IPU_REGISTERS_OFFSET+0x00040040,0x01FF0000
#define IPU_DI0_SW_GEN1_5__DI0_CNT_POLARITY_TRIGGER_SEL_5 IPU_REGISTERS_OFFSET+0x00040040,0x00007000
#define IPU_DI0_SW_GEN1_5__DI0_CNT_POLARITY_CLR_SEL_5     IPU_REGISTERS_OFFSET+0x00040040,0x00000E00
#define IPU_DI0_SW_GEN1_5__DI0_CNT_UP_5                   IPU_REGISTERS_OFFSET+0x00040040,0x000001FF

#define IPU_DI0_SW_GEN1_6__ADDR                           IPU_REGISTERS_OFFSET+0x00040044
#define IPU_DI0_SW_GEN1_6__EMPTY                          IPU_REGISTERS_OFFSET+0x00040044,0x00000000
#define IPU_DI0_SW_GEN1_6__FULL                           IPU_REGISTERS_OFFSET+0x00040044,0xffffffff
#define IPU_DI0_SW_GEN1_6__DI0_CNT_POLARITY_GEN_EN_6      IPU_REGISTERS_OFFSET+0x00040044,0x60000000
#define IPU_DI0_SW_GEN1_6__DI0_CNT_AUTO_RELOAD_6          IPU_REGISTERS_OFFSET+0x00040044,0x10000000
#define IPU_DI0_SW_GEN1_6__DI0_CNT_CLR_SEL_6              IPU_REGISTERS_OFFSET+0x00040044,0x0E000000
#define IPU_DI0_SW_GEN1_6__DI0_CNT_DOWN_6                 IPU_REGISTERS_OFFSET+0x00040044,0x01FF0000
#define IPU_DI0_SW_GEN1_6__DI0_CNT_POLARITY_TRIGGER_SEL_6 IPU_REGISTERS_OFFSET+0x00040044,0x00007000
#define IPU_DI0_SW_GEN1_6__DI0_CNT_POLARITY_CLR_SEL_6     IPU_REGISTERS_OFFSET+0x00040044,0x00000E00
#define IPU_DI0_SW_GEN1_6__DI0_CNT_UP_6                   IPU_REGISTERS_OFFSET+0x00040044,0x000001FF

#define IPU_DI0_SW_GEN1_7__ADDR                           IPU_REGISTERS_OFFSET+0x00040048
#define IPU_DI0_SW_GEN1_7__EMPTY                          IPU_REGISTERS_OFFSET+0x00040048,0x00000000
#define IPU_DI0_SW_GEN1_7__FULL                           IPU_REGISTERS_OFFSET+0x00040048,0xffffffff
#define IPU_DI0_SW_GEN1_7__DI0_CNT_POLARITY_GEN_EN_7      IPU_REGISTERS_OFFSET+0x00040048,0x60000000
#define IPU_DI0_SW_GEN1_7__DI0_CNT_AUTO_RELOAD_7          IPU_REGISTERS_OFFSET+0x00040048,0x10000000
#define IPU_DI0_SW_GEN1_7__DI0_CNT_CLR_SEL_7              IPU_REGISTERS_OFFSET+0x00040048,0x0E000000
#define IPU_DI0_SW_GEN1_7__DI0_CNT_DOWN_7                 IPU_REGISTERS_OFFSET+0x00040048,0x01FF0000
#define IPU_DI0_SW_GEN1_7__DI0_CNT_POLARITY_TRIGGER_SEL_7 IPU_REGISTERS_OFFSET+0x00040048,0x00007000
#define IPU_DI0_SW_GEN1_7__DI0_CNT_POLARITY_CLR_SEL_7     IPU_REGISTERS_OFFSET+0x00040048,0x00000E00
#define IPU_DI0_SW_GEN1_7__DI0_CNT_UP_7                   IPU_REGISTERS_OFFSET+0x00040048,0x000001FF

#define IPU_DI0_SW_GEN1_8__ADDR                           IPU_REGISTERS_OFFSET+0x0004004C
#define IPU_DI0_SW_GEN1_8__EMPTY                          IPU_REGISTERS_OFFSET+0x0004004C,0x00000000
#define IPU_DI0_SW_GEN1_8__FULL                           IPU_REGISTERS_OFFSET+0x0004004C,0xffffffff
#define IPU_DI0_SW_GEN1_8__DI0_CNT_POLARITY_GEN_EN_8      IPU_REGISTERS_OFFSET+0x0004004C,0x60000000
#define IPU_DI0_SW_GEN1_8__DI0_CNT_AUTO_RELOAD_8          IPU_REGISTERS_OFFSET+0x0004004C,0x10000000
#define IPU_DI0_SW_GEN1_8__DI0_CNT_CLR_SEL_8              IPU_REGISTERS_OFFSET+0x0004004C,0x0E000000
#define IPU_DI0_SW_GEN1_8__DI0_CNT_DOWN_8                 IPU_REGISTERS_OFFSET+0x0004004C,0x01FF0000
#define IPU_DI0_SW_GEN1_8__DI0_CNT_POLARITY_TRIGGER_SEL_8 IPU_REGISTERS_OFFSET+0x0004004C,0x00007000
#define IPU_DI0_SW_GEN1_8__DI0_CNT_POLARITY_CLR_SEL_8     IPU_REGISTERS_OFFSET+0x0004004C,0x00000E00
#define IPU_DI0_SW_GEN1_8__DI0_CNT_UP_8                   IPU_REGISTERS_OFFSET+0x0004004C,0x000001FF

#define IPU_DI0_SW_GEN1_9__ADDR                  IPU_REGISTERS_OFFSET+0x00040050
#define IPU_DI0_SW_GEN1_9__EMPTY                 IPU_REGISTERS_OFFSET+0x00040050,0x00000000
#define IPU_DI0_SW_GEN1_9__FULL                  IPU_REGISTERS_OFFSET+0x00040050,0xffffffff
#define IPU_DI0_SW_GEN1_9__DI0_GENTIME_SEL_9     IPU_REGISTERS_OFFSET+0x00040050,0xE0000000
#define IPU_DI0_SW_GEN1_9__DI0_CNT_AUTO_RELOAD_9 IPU_REGISTERS_OFFSET+0x00040050,0x10000000
#define IPU_DI0_SW_GEN1_9__DI0_CNT_CLR_SEL_9     IPU_REGISTERS_OFFSET+0x00040050,0x0E000000
#define IPU_DI0_SW_GEN1_9__DI0_CNT_DOWN_9        IPU_REGISTERS_OFFSET+0x00040050,0x01FF0000
#define IPU_DI0_SW_GEN1_9__DI0_TAG_SEL_9         IPU_REGISTERS_OFFSET+0x00040050,0x00008000
#define IPU_DI0_SW_GEN1_9__DI0_CNT_UP_9          IPU_REGISTERS_OFFSET+0x00040050,0x000001FF

#define IPU_DI0_SYNC_AS_GEN__ADDR              IPU_REGISTERS_OFFSET+0x00040054
#define IPU_DI0_SYNC_AS_GEN__EMPTY             IPU_REGISTERS_OFFSET+0x00040054,0x00000000
#define IPU_DI0_SYNC_AS_GEN__FULL              IPU_REGISTERS_OFFSET+0x00040054,0xffffffff
#define IPU_DI0_SYNC_AS_GEN__DI0_SYNC_START_EN IPU_REGISTERS_OFFSET+0x00040054,0x10000000
#define IPU_DI0_SYNC_AS_GEN__DI0_VSYNC_SEL     IPU_REGISTERS_OFFSET+0x00040054,0x0000E000
#define IPU_DI0_SYNC_AS_GEN__DI0_SYNC_START    IPU_REGISTERS_OFFSET+0x00040054,0x00000FFF

#define IPU_DI0_DW_GEN_0__ADDR                  IPU_REGISTERS_OFFSET+0x00040058
#define IPU_DI0_DW_GEN_0__EMPTY                 IPU_REGISTERS_OFFSET+0x00040058,0x00000000
#define IPU_DI0_DW_GEN_0__FULL                  IPU_REGISTERS_OFFSET+0x00040058,0xffffffff
#define IPU_DI0_DW_GEN_0__DI0_ACCESS_SIZE_0     IPU_REGISTERS_OFFSET+0x00040058,0xFF000000
#define IPU_DI0_DW_GEN_0__DI0_COMPONNENT_SIZE_0 IPU_REGISTERS_OFFSET+0x00040058,0x00FF0000
#define IPU_DI0_DW_GEN_0__DI0_CST_0             IPU_REGISTERS_OFFSET+0x00040058,0x0000C000
#define IPU_DI0_DW_GEN_0__DI0_PT_6_0            IPU_REGISTERS_OFFSET+0x00040058,0x00003000
#define IPU_DI0_DW_GEN_0__DI0_PT_5_0            IPU_REGISTERS_OFFSET+0x00040058,0x00000C00
#define IPU_DI0_DW_GEN_0__DI0_PT_4_0            IPU_REGISTERS_OFFSET+0x00040058,0x00000300
#define IPU_DI0_DW_GEN_0__DI0_PT_3_0            IPU_REGISTERS_OFFSET+0x00040058,0x000000C0
#define IPU_DI0_DW_GEN_0__DI0_PT_2_0            IPU_REGISTERS_OFFSET+0x00040058,0x00000030
#define IPU_DI0_DW_GEN_0__DI0_PT_1_0            IPU_REGISTERS_OFFSET+0x00040058,0x0000000C
#define IPU_DI0_DW_GEN_0__DI0_PT_0_0            IPU_REGISTERS_OFFSET+0x00040058,0x00000003

#define IPU_DI0_DW_GEN_1__ADDR                  IPU_REGISTERS_OFFSET+0x0004005C
#define IPU_DI0_DW_GEN_1__EMPTY                 IPU_REGISTERS_OFFSET+0x0004005C,0x00000000
#define IPU_DI0_DW_GEN_1__FULL                  IPU_REGISTERS_OFFSET+0x0004005C,0xffffffff
#define IPU_DI0_DW_GEN_1__DI0_ACCESS_SIZE_1     IPU_REGISTERS_OFFSET+0x0004005C,0xFF000000
#define IPU_DI0_DW_GEN_1__DI0_COMPONNENT_SIZE_1 IPU_REGISTERS_OFFSET+0x0004005C,0x00FF0000
#define IPU_DI0_DW_GEN_1__DI0_CST_1             IPU_REGISTERS_OFFSET+0x0004005C,0x0000C000
#define IPU_DI0_DW_GEN_1__DI0_PT_6_1            IPU_REGISTERS_OFFSET+0x0004005C,0x00003000
#define IPU_DI0_DW_GEN_1__DI0_PT_5_1            IPU_REGISTERS_OFFSET+0x0004005C,0x00000C00
#define IPU_DI0_DW_GEN_1__DI0_PT_4_1            IPU_REGISTERS_OFFSET+0x0004005C,0x00000300
#define IPU_DI0_DW_GEN_1__DI0_PT_3_1            IPU_REGISTERS_OFFSET+0x0004005C,0x000000C0
#define IPU_DI0_DW_GEN_1__DI0_PT_2_1            IPU_REGISTERS_OFFSET+0x0004005C,0x00000030
#define IPU_DI0_DW_GEN_1__DI0_PT_1_1            IPU_REGISTERS_OFFSET+0x0004005C,0x0000000C
#define IPU_DI0_DW_GEN_1__DI0_PT_0_1            IPU_REGISTERS_OFFSET+0x0004005C,0x00000003

#define IPU_DI0_DW_GEN_2__ADDR                  IPU_REGISTERS_OFFSET+0x00040060
#define IPU_DI0_DW_GEN_2__EMPTY                 IPU_REGISTERS_OFFSET+0x00040060,0x00000000
#define IPU_DI0_DW_GEN_2__FULL                  IPU_REGISTERS_OFFSET+0x00040060,0xffffffff
#define IPU_DI0_DW_GEN_2__DI0_ACCESS_SIZE_2     IPU_REGISTERS_OFFSET+0x00040060,0xFF000000
#define IPU_DI0_DW_GEN_2__DI0_COMPONNENT_SIZE_2 IPU_REGISTERS_OFFSET+0x00040060,0x00FF0000
#define IPU_DI0_DW_GEN_2__DI0_CST_2             IPU_REGISTERS_OFFSET+0x00040060,0x0000C000
#define IPU_DI0_DW_GEN_2__DI0_PT_6_2            IPU_REGISTERS_OFFSET+0x00040060,0x00003000
#define IPU_DI0_DW_GEN_2__DI0_PT_5_2            IPU_REGISTERS_OFFSET+0x00040060,0x00000C00
#define IPU_DI0_DW_GEN_2__DI0_PT_4_2            IPU_REGISTERS_OFFSET+0x00040060,0x00000300
#define IPU_DI0_DW_GEN_2__DI0_PT_3_2            IPU_REGISTERS_OFFSET+0x00040060,0x000000C0
#define IPU_DI0_DW_GEN_2__DI0_PT_2_2            IPU_REGISTERS_OFFSET+0x00040060,0x00000030
#define IPU_DI0_DW_GEN_2__DI0_PT_1_2            IPU_REGISTERS_OFFSET+0x00040060,0x0000000C
#define IPU_DI0_DW_GEN_2__DI0_PT_0_2            IPU_REGISTERS_OFFSET+0x00040060,0x00000003

#define IPU_DI0_DW_GEN_3__ADDR                  IPU_REGISTERS_OFFSET+0x00040064
#define IPU_DI0_DW_GEN_3__EMPTY                 IPU_REGISTERS_OFFSET+0x00040064,0x00000000
#define IPU_DI0_DW_GEN_3__FULL                  IPU_REGISTERS_OFFSET+0x00040064,0xffffffff
#define IPU_DI0_DW_GEN_3__DI0_ACCESS_SIZE_3     IPU_REGISTERS_OFFSET+0x00040064,0xFF000000
#define IPU_DI0_DW_GEN_3__DI0_COMPONNENT_SIZE_3 IPU_REGISTERS_OFFSET+0x00040064,0x00FF0000
#define IPU_DI0_DW_GEN_3__DI0_CST_3             IPU_REGISTERS_OFFSET+0x00040064,0x0000C000
#define IPU_DI0_DW_GEN_3__DI0_PT_6_3            IPU_REGISTERS_OFFSET+0x00040064,0x00003000
#define IPU_DI0_DW_GEN_3__DI0_PT_5_3            IPU_REGISTERS_OFFSET+0x00040064,0x00000C00
#define IPU_DI0_DW_GEN_3__DI0_PT_4_3            IPU_REGISTERS_OFFSET+0x00040064,0x00000300
#define IPU_DI0_DW_GEN_3__DI0_PT_3_3            IPU_REGISTERS_OFFSET+0x00040064,0x000000C0
#define IPU_DI0_DW_GEN_3__DI0_PT_2_3            IPU_REGISTERS_OFFSET+0x00040064,0x00000030
#define IPU_DI0_DW_GEN_3__DI0_PT_1_3            IPU_REGISTERS_OFFSET+0x00040064,0x0000000C
#define IPU_DI0_DW_GEN_3__DI0_PT_0_3            IPU_REGISTERS_OFFSET+0x00040064,0x00000003

#define IPU_DI0_DW_GEN_4__ADDR                  IPU_REGISTERS_OFFSET+0x00040068
#define IPU_DI0_DW_GEN_4__EMPTY                 IPU_REGISTERS_OFFSET+0x00040068,0x00000000
#define IPU_DI0_DW_GEN_4__FULL                  IPU_REGISTERS_OFFSET+0x00040068,0xffffffff
#define IPU_DI0_DW_GEN_4__DI0_ACCESS_SIZE_4     IPU_REGISTERS_OFFSET+0x00040068,0xFF000000
#define IPU_DI0_DW_GEN_4__DI0_COMPONNENT_SIZE_4 IPU_REGISTERS_OFFSET+0x00040068,0x00FF0000
#define IPU_DI0_DW_GEN_4__DI0_CST_4             IPU_REGISTERS_OFFSET+0x00040068,0x0000C000
#define IPU_DI0_DW_GEN_4__DI0_PT_6_4            IPU_REGISTERS_OFFSET+0x00040068,0x00003000
#define IPU_DI0_DW_GEN_4__DI0_PT_5_4            IPU_REGISTERS_OFFSET+0x00040068,0x00000C00
#define IPU_DI0_DW_GEN_4__DI0_PT_4_4            IPU_REGISTERS_OFFSET+0x00040068,0x00000300
#define IPU_DI0_DW_GEN_4__DI0_PT_3_4            IPU_REGISTERS_OFFSET+0x00040068,0x000000C0
#define IPU_DI0_DW_GEN_4__DI0_PT_2_4            IPU_REGISTERS_OFFSET+0x00040068,0x00000030
#define IPU_DI0_DW_GEN_4__DI0_PT_1_4            IPU_REGISTERS_OFFSET+0x00040068,0x0000000C
#define IPU_DI0_DW_GEN_4__DI0_PT_0_4            IPU_REGISTERS_OFFSET+0x00040068,0x00000003

#define IPU_DI0_DW_GEN_5__ADDR                  IPU_REGISTERS_OFFSET+0x0004006C
#define IPU_DI0_DW_GEN_5__EMPTY                 IPU_REGISTERS_OFFSET+0x0004006C,0x00000000
#define IPU_DI0_DW_GEN_5__FULL                  IPU_REGISTERS_OFFSET+0x0004006C,0xffffffff
#define IPU_DI0_DW_GEN_5__DI0_ACCESS_SIZE_5     IPU_REGISTERS_OFFSET+0x0004006C,0xFF000000
#define IPU_DI0_DW_GEN_5__DI0_COMPONNENT_SIZE_5 IPU_REGISTERS_OFFSET+0x0004006C,0x00FF0000
#define IPU_DI0_DW_GEN_5__DI0_CST_5             IPU_REGISTERS_OFFSET+0x0004006C,0x0000C000
#define IPU_DI0_DW_GEN_5__DI0_PT_6_5            IPU_REGISTERS_OFFSET+0x0004006C,0x00003000
#define IPU_DI0_DW_GEN_5__DI0_PT_5_5            IPU_REGISTERS_OFFSET+0x0004006C,0x00000C00
#define IPU_DI0_DW_GEN_5__DI0_PT_4_5            IPU_REGISTERS_OFFSET+0x0004006C,0x00000300
#define IPU_DI0_DW_GEN_5__DI0_PT_3_5            IPU_REGISTERS_OFFSET+0x0004006C,0x000000C0
#define IPU_DI0_DW_GEN_5__DI0_PT_2_5            IPU_REGISTERS_OFFSET+0x0004006C,0x00000030
#define IPU_DI0_DW_GEN_5__DI0_PT_1_5            IPU_REGISTERS_OFFSET+0x0004006C,0x0000000C
#define IPU_DI0_DW_GEN_5__DI0_PT_0_5            IPU_REGISTERS_OFFSET+0x0004006C,0x00000003

#define IPU_DI0_DW_GEN_6__ADDR                  IPU_REGISTERS_OFFSET+0x00040070
#define IPU_DI0_DW_GEN_6__EMPTY                 IPU_REGISTERS_OFFSET+0x00040070,0x00000000
#define IPU_DI0_DW_GEN_6__FULL                  IPU_REGISTERS_OFFSET+0x00040070,0xffffffff
#define IPU_DI0_DW_GEN_6__DI0_ACCESS_SIZE_6     IPU_REGISTERS_OFFSET+0x00040070,0xFF000000
#define IPU_DI0_DW_GEN_6__DI0_COMPONNENT_SIZE_6 IPU_REGISTERS_OFFSET+0x00040070,0x00FF0000
#define IPU_DI0_DW_GEN_6__DI0_CST_6             IPU_REGISTERS_OFFSET+0x00040070,0x0000C000
#define IPU_DI0_DW_GEN_6__DI0_PT_6_6            IPU_REGISTERS_OFFSET+0x00040070,0x00003000
#define IPU_DI0_DW_GEN_6__DI0_PT_5_6            IPU_REGISTERS_OFFSET+0x00040070,0x00000C00
#define IPU_DI0_DW_GEN_6__DI0_PT_4_6            IPU_REGISTERS_OFFSET+0x00040070,0x00000300
#define IPU_DI0_DW_GEN_6__DI0_PT_3_6            IPU_REGISTERS_OFFSET+0x00040070,0x000000C0
#define IPU_DI0_DW_GEN_6__DI0_PT_2_6            IPU_REGISTERS_OFFSET+0x00040070,0x00000030
#define IPU_DI0_DW_GEN_6__DI0_PT_1_6            IPU_REGISTERS_OFFSET+0x00040070,0x0000000C
#define IPU_DI0_DW_GEN_6__DI0_PT_0_6            IPU_REGISTERS_OFFSET+0x00040070,0x00000003

#define IPU_DI0_DW_GEN_7__ADDR                  IPU_REGISTERS_OFFSET+0x00040074
#define IPU_DI0_DW_GEN_7__EMPTY                 IPU_REGISTERS_OFFSET+0x00040074,0x00000000
#define IPU_DI0_DW_GEN_7__FULL                  IPU_REGISTERS_OFFSET+0x00040074,0xffffffff
#define IPU_DI0_DW_GEN_7__DI0_ACCESS_SIZE_7     IPU_REGISTERS_OFFSET+0x00040074,0xFF000000
#define IPU_DI0_DW_GEN_7__DI0_COMPONNENT_SIZE_7 IPU_REGISTERS_OFFSET+0x00040074,0x00FF0000
#define IPU_DI0_DW_GEN_7__DI0_CST_7             IPU_REGISTERS_OFFSET+0x00040074,0x0000C000
#define IPU_DI0_DW_GEN_7__DI0_PT_6_7            IPU_REGISTERS_OFFSET+0x00040074,0x00003000
#define IPU_DI0_DW_GEN_7__DI0_PT_5_7            IPU_REGISTERS_OFFSET+0x00040074,0x00000C00
#define IPU_DI0_DW_GEN_7__DI0_PT_4_7            IPU_REGISTERS_OFFSET+0x00040074,0x00000300
#define IPU_DI0_DW_GEN_7__DI0_PT_3_7            IPU_REGISTERS_OFFSET+0x00040074,0x000000C0
#define IPU_DI0_DW_GEN_7__DI0_PT_2_7            IPU_REGISTERS_OFFSET+0x00040074,0x00000030
#define IPU_DI0_DW_GEN_7__DI0_PT_1_7            IPU_REGISTERS_OFFSET+0x00040074,0x0000000C
#define IPU_DI0_DW_GEN_7__DI0_PT_0_7            IPU_REGISTERS_OFFSET+0x00040074,0x00000003

#define IPU_DI0_DW_GEN_8__ADDR                  IPU_REGISTERS_OFFSET+0x00040078
#define IPU_DI0_DW_GEN_8__EMPTY                 IPU_REGISTERS_OFFSET+0x00040078,0x00000000
#define IPU_DI0_DW_GEN_8__FULL                  IPU_REGISTERS_OFFSET+0x00040078,0xffffffff
#define IPU_DI0_DW_GEN_8__DI0_ACCESS_SIZE_8     IPU_REGISTERS_OFFSET+0x00040078,0xFF000000
#define IPU_DI0_DW_GEN_8__DI0_COMPONNENT_SIZE_8 IPU_REGISTERS_OFFSET+0x00040078,0x00FF0000
#define IPU_DI0_DW_GEN_8__DI0_CST_8             IPU_REGISTERS_OFFSET+0x00040078,0x0000C000
#define IPU_DI0_DW_GEN_8__DI0_PT_6_8            IPU_REGISTERS_OFFSET+0x00040078,0x00003000
#define IPU_DI0_DW_GEN_8__DI0_PT_5_8            IPU_REGISTERS_OFFSET+0x00040078,0x00000C00
#define IPU_DI0_DW_GEN_8__DI0_PT_4_8            IPU_REGISTERS_OFFSET+0x00040078,0x00000300
#define IPU_DI0_DW_GEN_8__DI0_PT_3_8            IPU_REGISTERS_OFFSET+0x00040078,0x000000C0
#define IPU_DI0_DW_GEN_8__DI0_PT_2_8            IPU_REGISTERS_OFFSET+0x00040078,0x00000030
#define IPU_DI0_DW_GEN_8__DI0_PT_1_8            IPU_REGISTERS_OFFSET+0x00040078,0x0000000C
#define IPU_DI0_DW_GEN_8__DI0_PT_0_8            IPU_REGISTERS_OFFSET+0x00040078,0x00000003

#define IPU_DI0_DW_GEN_9__ADDR                  IPU_REGISTERS_OFFSET+0x0004007C
#define IPU_DI0_DW_GEN_9__EMPTY                 IPU_REGISTERS_OFFSET+0x0004007C,0x00000000
#define IPU_DI0_DW_GEN_9__FULL                  IPU_REGISTERS_OFFSET+0x0004007C,0xffffffff
#define IPU_DI0_DW_GEN_9__DI0_ACCESS_SIZE_9     IPU_REGISTERS_OFFSET+0x0004007C,0xFF000000
#define IPU_DI0_DW_GEN_9__DI0_COMPONNENT_SIZE_9 IPU_REGISTERS_OFFSET+0x0004007C,0x00FF0000
#define IPU_DI0_DW_GEN_9__DI0_CST_9             IPU_REGISTERS_OFFSET+0x0004007C,0x0000C000
#define IPU_DI0_DW_GEN_9__DI0_PT_6_9            IPU_REGISTERS_OFFSET+0x0004007C,0x00003000
#define IPU_DI0_DW_GEN_9__DI0_PT_5_9            IPU_REGISTERS_OFFSET+0x0004007C,0x00000C00
#define IPU_DI0_DW_GEN_9__DI0_PT_4_9            IPU_REGISTERS_OFFSET+0x0004007C,0x00000300
#define IPU_DI0_DW_GEN_9__DI0_PT_3_9            IPU_REGISTERS_OFFSET+0x0004007C,0x000000C0
#define IPU_DI0_DW_GEN_9__DI0_PT_2_9            IPU_REGISTERS_OFFSET+0x0004007C,0x00000030
#define IPU_DI0_DW_GEN_9__DI0_PT_1_9            IPU_REGISTERS_OFFSET+0x0004007C,0x0000000C
#define IPU_DI0_DW_GEN_9__DI0_PT_0_9            IPU_REGISTERS_OFFSET+0x0004007C,0x00000003

#define IPU_DI0_DW_GEN_10__ADDR                   IPU_REGISTERS_OFFSET+0x00040080
#define IPU_DI0_DW_GEN_10__EMPTY                  IPU_REGISTERS_OFFSET+0x00040080,0x00000000
#define IPU_DI0_DW_GEN_10__FULL                   IPU_REGISTERS_OFFSET+0x00040080,0xffffffff
#define IPU_DI0_DW_GEN_10__DI0_ACCESS_SIZE_10     IPU_REGISTERS_OFFSET+0x00040080,0xFF000000
#define IPU_DI0_DW_GEN_10__DI0_COMPONNENT_SIZE_10 IPU_REGISTERS_OFFSET+0x00040080,0x00FF0000
#define IPU_DI0_DW_GEN_10__DI0_CST_10             IPU_REGISTERS_OFFSET+0x00040080,0x0000C000
#define IPU_DI0_DW_GEN_10__DI0_PT_6_10            IPU_REGISTERS_OFFSET+0x00040080,0x00003000
#define IPU_DI0_DW_GEN_10__DI0_PT_5_10            IPU_REGISTERS_OFFSET+0x00040080,0x00000C00
#define IPU_DI0_DW_GEN_10__DI0_PT_4_10            IPU_REGISTERS_OFFSET+0x00040080,0x00000300
#define IPU_DI0_DW_GEN_10__DI0_PT_3_10            IPU_REGISTERS_OFFSET+0x00040080,0x000000C0
#define IPU_DI0_DW_GEN_10__DI0_PT_2_10            IPU_REGISTERS_OFFSET+0x00040080,0x00000030
#define IPU_DI0_DW_GEN_10__DI0_PT_1_10            IPU_REGISTERS_OFFSET+0x00040080,0x0000000C
#define IPU_DI0_DW_GEN_10__DI0_PT_0_10            IPU_REGISTERS_OFFSET+0x00040080,0x00000003

#define IPU_DI0_DW_GEN_11__ADDR                   IPU_REGISTERS_OFFSET+0x00040084
#define IPU_DI0_DW_GEN_11__EMPTY                  IPU_REGISTERS_OFFSET+0x00040084,0x00000000
#define IPU_DI0_DW_GEN_11__FULL                   IPU_REGISTERS_OFFSET+0x00040084,0xffffffff
#define IPU_DI0_DW_GEN_11__DI0_ACCESS_SIZE_11     IPU_REGISTERS_OFFSET+0x00040084,0xFF000000
#define IPU_DI0_DW_GEN_11__DI0_COMPONNENT_SIZE_11 IPU_REGISTERS_OFFSET+0x00040084,0x00FF0000
#define IPU_DI0_DW_GEN_11__DI0_CST_11             IPU_REGISTERS_OFFSET+0x00040084,0x0000C000
#define IPU_DI0_DW_GEN_11__DI0_PT_6_11            IPU_REGISTERS_OFFSET+0x00040084,0x00003000
#define IPU_DI0_DW_GEN_11__DI0_PT_5_11            IPU_REGISTERS_OFFSET+0x00040084,0x00000C00
#define IPU_DI0_DW_GEN_11__DI0_PT_4_11            IPU_REGISTERS_OFFSET+0x00040084,0x00000300
#define IPU_DI0_DW_GEN_11__DI0_PT_3_11            IPU_REGISTERS_OFFSET+0x00040084,0x000000C0
#define IPU_DI0_DW_GEN_11__DI0_PT_2_11            IPU_REGISTERS_OFFSET+0x00040084,0x00000030
#define IPU_DI0_DW_GEN_11__DI0_PT_1_11            IPU_REGISTERS_OFFSET+0x00040084,0x0000000C
#define IPU_DI0_DW_GEN_11__DI0_PT_0_11            IPU_REGISTERS_OFFSET+0x00040084,0x00000003

#define IPU_DI_DW_OFFSET 								0x0088
#define DI_WAVESET_ADDR(di, pointer, set)  		(IPU_DI0_GENERAL__ADDR + \
																				di*0x8000 + IPU_DI_DW_OFFSET + \
																				pointer*0x4 + set * 0x30)
#define DI_WAVESET_UP(di, pointer, set) 			DI_WAVESET_ADDR(di, pointer, set), 0x000001FF
#define DI_WAVESET_DOWN(di, pointer, set) 	DI_WAVESET_ADDR(di, pointer, set), 0x01FF0000

#define IPU_DI_STEP_RPT_OFFSET 					0x0148
#define DI_STEP_RPT_ADDR(di, pointer)  			(IPU_DI0_GENERAL__ADDR + \
																				di*0x8000 + IPU_DI_STEP_RPT_OFFSET + \
																				((pointer-1) / 2)*0x4 )
#define DI_STEP_RPT(di, pointer) 						DI_STEP_RPT_ADDR(di, pointer), 0x0FFF<<((pointer-1)%2)*16

#define IPU_DI0_DW_SET0_0__ADDR                 IPU_REGISTERS_OFFSET+0x00040088
#define IPU_DI0_DW_SET0_0__EMPTY                IPU_REGISTERS_OFFSET+0x00040088,0x00000000
#define IPU_DI0_DW_SET0_0__FULL                 IPU_REGISTERS_OFFSET+0x00040088,0xffffffff
#define IPU_DI0_DW_SET0_0__DI0_DATA_CNT_DOWN0_0 IPU_REGISTERS_OFFSET+0x00040088,0x01FF0000
#define IPU_DI0_DW_SET0_0__DI0_DATA_CNT_UP0_0   IPU_REGISTERS_OFFSET+0x00040088,0x000001FF

#define IPU_DI0_DW_SET0_1__ADDR                 IPU_REGISTERS_OFFSET+0x0004008C
#define IPU_DI0_DW_SET0_1__EMPTY                IPU_REGISTERS_OFFSET+0x0004008C,0x00000000
#define IPU_DI0_DW_SET0_1__FULL                 IPU_REGISTERS_OFFSET+0x0004008C,0xffffffff
#define IPU_DI0_DW_SET0_1__DI0_DATA_CNT_DOWN0_1 IPU_REGISTERS_OFFSET+0x0004008C,0x01FF0000
#define IPU_DI0_DW_SET0_1__DI0_DATA_CNT_UP0_1   IPU_REGISTERS_OFFSET+0x0004008C,0x000001FF

#define IPU_DI0_DW_SET0_2__ADDR                 IPU_REGISTERS_OFFSET+0x00040090
#define IPU_DI0_DW_SET0_2__EMPTY                IPU_REGISTERS_OFFSET+0x00040090,0x00000000
#define IPU_DI0_DW_SET0_2__FULL                 IPU_REGISTERS_OFFSET+0x00040090,0xffffffff
#define IPU_DI0_DW_SET0_2__DI0_DATA_CNT_DOWN0_2 IPU_REGISTERS_OFFSET+0x00040090,0x01FF0000
#define IPU_DI0_DW_SET0_2__DI0_DATA_CNT_UP0_2   IPU_REGISTERS_OFFSET+0x00040090,0x000001FF

#define IPU_DI0_DW_SET0_3__ADDR                 IPU_REGISTERS_OFFSET+0x00040094
#define IPU_DI0_DW_SET0_3__EMPTY                IPU_REGISTERS_OFFSET+0x00040094,0x00000000
#define IPU_DI0_DW_SET0_3__FULL                 IPU_REGISTERS_OFFSET+0x00040094,0xffffffff
#define IPU_DI0_DW_SET0_3__DI0_DATA_CNT_DOWN0_3 IPU_REGISTERS_OFFSET+0x00040094,0x01FF0000
#define IPU_DI0_DW_SET0_3__DI0_DATA_CNT_UP0_3   IPU_REGISTERS_OFFSET+0x00040094,0x000001FF

#define IPU_DI0_DW_SET0_4__ADDR                 IPU_REGISTERS_OFFSET+0x00040098
#define IPU_DI0_DW_SET0_4__EMPTY                IPU_REGISTERS_OFFSET+0x00040098,0x00000000
#define IPU_DI0_DW_SET0_4__FULL                 IPU_REGISTERS_OFFSET+0x00040098,0xffffffff
#define IPU_DI0_DW_SET0_4__DI0_DATA_CNT_DOWN0_4 IPU_REGISTERS_OFFSET+0x00040098,0x01FF0000
#define IPU_DI0_DW_SET0_4__DI0_DATA_CNT_UP0_4   IPU_REGISTERS_OFFSET+0x00040098,0x000001FF

#define IPU_DI0_DW_SET0_5__ADDR                 IPU_REGISTERS_OFFSET+0x0004009C
#define IPU_DI0_DW_SET0_5__EMPTY                IPU_REGISTERS_OFFSET+0x0004009C,0x00000000
#define IPU_DI0_DW_SET0_5__FULL                 IPU_REGISTERS_OFFSET+0x0004009C,0xffffffff
#define IPU_DI0_DW_SET0_5__DI0_DATA_CNT_DOWN0_5 IPU_REGISTERS_OFFSET+0x0004009C,0x01FF0000
#define IPU_DI0_DW_SET0_5__DI0_DATA_CNT_UP0_5   IPU_REGISTERS_OFFSET+0x0004009C,0x000001FF

#define IPU_DI0_DW_SET0_6__ADDR                 IPU_REGISTERS_OFFSET+0x000400A0
#define IPU_DI0_DW_SET0_6__EMPTY                IPU_REGISTERS_OFFSET+0x000400A0,0x00000000
#define IPU_DI0_DW_SET0_6__FULL                 IPU_REGISTERS_OFFSET+0x000400A0,0xffffffff
#define IPU_DI0_DW_SET0_6__DI0_DATA_CNT_DOWN0_6 IPU_REGISTERS_OFFSET+0x000400A0,0x01FF0000
#define IPU_DI0_DW_SET0_6__DI0_DATA_CNT_UP0_6   IPU_REGISTERS_OFFSET+0x000400A0,0x000001FF

#define IPU_DI0_DW_SET0_7__ADDR                 IPU_REGISTERS_OFFSET+0x000400A4
#define IPU_DI0_DW_SET0_7__EMPTY                IPU_REGISTERS_OFFSET+0x000400A4,0x00000000
#define IPU_DI0_DW_SET0_7__FULL                 IPU_REGISTERS_OFFSET+0x000400A4,0xffffffff
#define IPU_DI0_DW_SET0_7__DI0_DATA_CNT_DOWN0_7 IPU_REGISTERS_OFFSET+0x000400A4,0x01FF0000
#define IPU_DI0_DW_SET0_7__DI0_DATA_CNT_UP0_7   IPU_REGISTERS_OFFSET+0x000400A4,0x000001FF

#define IPU_DI0_DW_SET0_8__ADDR                 IPU_REGISTERS_OFFSET+0x000400A8
#define IPU_DI0_DW_SET0_8__EMPTY                IPU_REGISTERS_OFFSET+0x000400A8,0x00000000
#define IPU_DI0_DW_SET0_8__FULL                 IPU_REGISTERS_OFFSET+0x000400A8,0xffffffff
#define IPU_DI0_DW_SET0_8__DI0_DATA_CNT_DOWN0_8 IPU_REGISTERS_OFFSET+0x000400A8,0x01FF0000
#define IPU_DI0_DW_SET0_8__DI0_DATA_CNT_UP0_8   IPU_REGISTERS_OFFSET+0x000400A8,0x000001FF

#define IPU_DI0_DW_SET0_9__ADDR                 IPU_REGISTERS_OFFSET+0x000400AC
#define IPU_DI0_DW_SET0_9__EMPTY                IPU_REGISTERS_OFFSET+0x000400AC,0x00000000
#define IPU_DI0_DW_SET0_9__FULL                 IPU_REGISTERS_OFFSET+0x000400AC,0xffffffff
#define IPU_DI0_DW_SET0_9__DI0_DATA_CNT_DOWN0_9 IPU_REGISTERS_OFFSET+0x000400AC,0x01FF0000
#define IPU_DI0_DW_SET0_9__DI0_DATA_CNT_UP0_9   IPU_REGISTERS_OFFSET+0x000400AC,0x000001FF

#define IPU_DI0_DW_SET0_10__ADDR                  IPU_REGISTERS_OFFSET+0x000400B0
#define IPU_DI0_DW_SET0_10__EMPTY                 IPU_REGISTERS_OFFSET+0x000400B0,0x00000000
#define IPU_DI0_DW_SET0_10__FULL                  IPU_REGISTERS_OFFSET+0x000400B0,0xffffffff
#define IPU_DI0_DW_SET0_10__DI0_DATA_CNT_DOWN0_10 IPU_REGISTERS_OFFSET+0x000400B0,0x01FF0000
#define IPU_DI0_DW_SET0_10__DI0_DATA_CNT_UP0_10   IPU_REGISTERS_OFFSET+0x000400B0,0x000001FF

#define IPU_DI0_DW_SET0_11__ADDR                  IPU_REGISTERS_OFFSET+0x000400B4
#define IPU_DI0_DW_SET0_11__EMPTY                 IPU_REGISTERS_OFFSET+0x000400B4,0x00000000
#define IPU_DI0_DW_SET0_11__FULL                  IPU_REGISTERS_OFFSET+0x000400B4,0xffffffff
#define IPU_DI0_DW_SET0_11__DI0_DATA_CNT_DOWN0_11 IPU_REGISTERS_OFFSET+0x000400B4,0x01FF0000
#define IPU_DI0_DW_SET0_11__DI0_DATA_CNT_UP0_11   IPU_REGISTERS_OFFSET+0x000400B4,0x000001FF

#define IPU_DI0_DW_SET1_0__ADDR                 IPU_REGISTERS_OFFSET+0x000400B8
#define IPU_DI0_DW_SET1_0__EMPTY                IPU_REGISTERS_OFFSET+0x000400B8,0x00000000
#define IPU_DI0_DW_SET1_0__FULL                 IPU_REGISTERS_OFFSET+0x000400B8,0xffffffff
#define IPU_DI0_DW_SET1_0__DI0_DATA_CNT_DOWN1_0 IPU_REGISTERS_OFFSET+0x000400B8,0x01FF0000
#define IPU_DI0_DW_SET1_0__DI0_DATA_CNT_UP1_0   IPU_REGISTERS_OFFSET+0x000400B8,0x000001FF

#define IPU_DI0_DW_SET1_1__ADDR                 IPU_REGISTERS_OFFSET+0x000400BC
#define IPU_DI0_DW_SET1_1__EMPTY                IPU_REGISTERS_OFFSET+0x000400BC,0x00000000
#define IPU_DI0_DW_SET1_1__FULL                 IPU_REGISTERS_OFFSET+0x000400BC,0xffffffff
#define IPU_DI0_DW_SET1_1__DI0_DATA_CNT_DOWN1_1 IPU_REGISTERS_OFFSET+0x000400BC,0x01FF0000
#define IPU_DI0_DW_SET1_1__DI0_DATA_CNT_UP1_1   IPU_REGISTERS_OFFSET+0x000400BC,0x000001FF

#define IPU_DI0_DW_SET1_2__ADDR                 IPU_REGISTERS_OFFSET+0x000400C0
#define IPU_DI0_DW_SET1_2__EMPTY                IPU_REGISTERS_OFFSET+0x000400C0,0x00000000
#define IPU_DI0_DW_SET1_2__FULL                 IPU_REGISTERS_OFFSET+0x000400C0,0xffffffff
#define IPU_DI0_DW_SET1_2__DI0_DATA_CNT_DOWN1_2 IPU_REGISTERS_OFFSET+0x000400C0,0x01FF0000
#define IPU_DI0_DW_SET1_2__DI0_DATA_CNT_UP1_2   IPU_REGISTERS_OFFSET+0x000400C0,0x000001FF

#define IPU_DI0_DW_SET1_3__ADDR                 IPU_REGISTERS_OFFSET+0x000400C4
#define IPU_DI0_DW_SET1_3__EMPTY                IPU_REGISTERS_OFFSET+0x000400C4,0x00000000
#define IPU_DI0_DW_SET1_3__FULL                 IPU_REGISTERS_OFFSET+0x000400C4,0xffffffff
#define IPU_DI0_DW_SET1_3__DI0_DATA_CNT_DOWN1_3 IPU_REGISTERS_OFFSET+0x000400C4,0x01FF0000
#define IPU_DI0_DW_SET1_3__DI0_DATA_CNT_UP1_3   IPU_REGISTERS_OFFSET+0x000400C4,0x000001FF

#define IPU_DI0_DW_SET1_4__ADDR                 IPU_REGISTERS_OFFSET+0x000400C8
#define IPU_DI0_DW_SET1_4__EMPTY                IPU_REGISTERS_OFFSET+0x000400C8,0x00000000
#define IPU_DI0_DW_SET1_4__FULL                 IPU_REGISTERS_OFFSET+0x000400C8,0xffffffff
#define IPU_DI0_DW_SET1_4__DI0_DATA_CNT_DOWN1_4 IPU_REGISTERS_OFFSET+0x000400C8,0x01FF0000
#define IPU_DI0_DW_SET1_4__DI0_DATA_CNT_UP1_4   IPU_REGISTERS_OFFSET+0x000400C8,0x000001FF

#define IPU_DI0_DW_SET1_5__ADDR                 IPU_REGISTERS_OFFSET+0x000400CC
#define IPU_DI0_DW_SET1_5__EMPTY                IPU_REGISTERS_OFFSET+0x000400CC,0x00000000
#define IPU_DI0_DW_SET1_5__FULL                 IPU_REGISTERS_OFFSET+0x000400CC,0xffffffff
#define IPU_DI0_DW_SET1_5__DI0_DATA_CNT_DOWN1_5 IPU_REGISTERS_OFFSET+0x000400CC,0x01FF0000
#define IPU_DI0_DW_SET1_5__DI0_DATA_CNT_UP1_5   IPU_REGISTERS_OFFSET+0x000400CC,0x000001FF

#define IPU_DI0_DW_SET1_6__ADDR                 IPU_REGISTERS_OFFSET+0x000400D0
#define IPU_DI0_DW_SET1_6__EMPTY                IPU_REGISTERS_OFFSET+0x000400D0,0x00000000
#define IPU_DI0_DW_SET1_6__FULL                 IPU_REGISTERS_OFFSET+0x000400D0,0xffffffff
#define IPU_DI0_DW_SET1_6__DI0_DATA_CNT_DOWN1_6 IPU_REGISTERS_OFFSET+0x000400D0,0x01FF0000
#define IPU_DI0_DW_SET1_6__DI0_DATA_CNT_UP1_6   IPU_REGISTERS_OFFSET+0x000400D0,0x000001FF

#define IPU_DI0_DW_SET1_7__ADDR                 IPU_REGISTERS_OFFSET+0x000400D4
#define IPU_DI0_DW_SET1_7__EMPTY                IPU_REGISTERS_OFFSET+0x000400D4,0x00000000
#define IPU_DI0_DW_SET1_7__FULL                 IPU_REGISTERS_OFFSET+0x000400D4,0xffffffff
#define IPU_DI0_DW_SET1_7__DI0_DATA_CNT_DOWN1_7 IPU_REGISTERS_OFFSET+0x000400D4,0x01FF0000
#define IPU_DI0_DW_SET1_7__DI0_DATA_CNT_UP1_7   IPU_REGISTERS_OFFSET+0x000400D4,0x000001FF

#define IPU_DI0_DW_SET1_8__ADDR                 IPU_REGISTERS_OFFSET+0x000400D8
#define IPU_DI0_DW_SET1_8__EMPTY                IPU_REGISTERS_OFFSET+0x000400D8,0x00000000
#define IPU_DI0_DW_SET1_8__FULL                 IPU_REGISTERS_OFFSET+0x000400D8,0xffffffff
#define IPU_DI0_DW_SET1_8__DI0_DATA_CNT_DOWN1_8 IPU_REGISTERS_OFFSET+0x000400D8,0x01FF0000
#define IPU_DI0_DW_SET1_8__DI0_DATA_CNT_UP1_8   IPU_REGISTERS_OFFSET+0x000400D8,0x000001FF

#define IPU_DI0_DW_SET1_9__ADDR                 IPU_REGISTERS_OFFSET+0x000400DC
#define IPU_DI0_DW_SET1_9__EMPTY                IPU_REGISTERS_OFFSET+0x000400DC,0x00000000
#define IPU_DI0_DW_SET1_9__FULL                 IPU_REGISTERS_OFFSET+0x000400DC,0xffffffff
#define IPU_DI0_DW_SET1_9__DI0_DATA_CNT_DOWN1_9 IPU_REGISTERS_OFFSET+0x000400DC,0x01FF0000
#define IPU_DI0_DW_SET1_9__DI0_DATA_CNT_UP1_9   IPU_REGISTERS_OFFSET+0x000400DC,0x000001FF

#define IPU_DI0_DW_SET1_10__ADDR                  IPU_REGISTERS_OFFSET+0x000400E0
#define IPU_DI0_DW_SET1_10__EMPTY                 IPU_REGISTERS_OFFSET+0x000400E0,0x00000000
#define IPU_DI0_DW_SET1_10__FULL                  IPU_REGISTERS_OFFSET+0x000400E0,0xffffffff
#define IPU_DI0_DW_SET1_10__DI0_DATA_CNT_DOWN1_10 IPU_REGISTERS_OFFSET+0x000400E0,0x01FF0000
#define IPU_DI0_DW_SET1_10__DI0_DATA_CNT_UP1_10   IPU_REGISTERS_OFFSET+0x000400E0,0x000001FF

#define IPU_DI0_DW_SET1_11__ADDR                  IPU_REGISTERS_OFFSET+0x000400E4
#define IPU_DI0_DW_SET1_11__EMPTY                 IPU_REGISTERS_OFFSET+0x000400E4,0x00000000
#define IPU_DI0_DW_SET1_11__FULL                  IPU_REGISTERS_OFFSET+0x000400E4,0xffffffff
#define IPU_DI0_DW_SET1_11__DI0_DATA_CNT_DOWN1_11 IPU_REGISTERS_OFFSET+0x000400E4,0x01FF0000
#define IPU_DI0_DW_SET1_11__DI0_DATA_CNT_UP1_11   IPU_REGISTERS_OFFSET+0x000400E4,0x000001FF

#define IPU_DI0_DW_SET2_0__ADDR                 IPU_REGISTERS_OFFSET+0x000400E8
#define IPU_DI0_DW_SET2_0__EMPTY                IPU_REGISTERS_OFFSET+0x000400E8,0x00000000
#define IPU_DI0_DW_SET2_0__FULL                 IPU_REGISTERS_OFFSET+0x000400E8,0xffffffff
#define IPU_DI0_DW_SET2_0__DI0_DATA_CNT_DOWN2_0 IPU_REGISTERS_OFFSET+0x000400E8,0x01FF0000
#define IPU_DI0_DW_SET2_0__DI0_DATA_CNT_UP2_0   IPU_REGISTERS_OFFSET+0x000400E8,0x000001FF

#define IPU_DI0_DW_SET2_1__ADDR                 IPU_REGISTERS_OFFSET+0x000400EC
#define IPU_DI0_DW_SET2_1__EMPTY                IPU_REGISTERS_OFFSET+0x000400EC,0x00000000
#define IPU_DI0_DW_SET2_1__FULL                 IPU_REGISTERS_OFFSET+0x000400EC,0xffffffff
#define IPU_DI0_DW_SET2_1__DI0_DATA_CNT_DOWN2_1 IPU_REGISTERS_OFFSET+0x000400EC,0x01FF0000
#define IPU_DI0_DW_SET2_1__DI0_DATA_CNT_UP2_1   IPU_REGISTERS_OFFSET+0x000400EC,0x000001FF

#define IPU_DI0_DW_SET2_2__ADDR                 IPU_REGISTERS_OFFSET+0x000400F0
#define IPU_DI0_DW_SET2_2__EMPTY                IPU_REGISTERS_OFFSET+0x000400F0,0x00000000
#define IPU_DI0_DW_SET2_2__FULL                 IPU_REGISTERS_OFFSET+0x000400F0,0xffffffff
#define IPU_DI0_DW_SET2_2__DI0_DATA_CNT_DOWN2_2 IPU_REGISTERS_OFFSET+0x000400F0,0x01FF0000
#define IPU_DI0_DW_SET2_2__DI0_DATA_CNT_UP2_2   IPU_REGISTERS_OFFSET+0x000400F0,0x000001FF

#define IPU_DI0_DW_SET2_3__ADDR                 IPU_REGISTERS_OFFSET+0x000400F4
#define IPU_DI0_DW_SET2_3__EMPTY                IPU_REGISTERS_OFFSET+0x000400F4,0x00000000
#define IPU_DI0_DW_SET2_3__FULL                 IPU_REGISTERS_OFFSET+0x000400F4,0xffffffff
#define IPU_DI0_DW_SET2_3__DI0_DATA_CNT_DOWN2_3 IPU_REGISTERS_OFFSET+0x000400F4,0x01FF0000
#define IPU_DI0_DW_SET2_3__DI0_DATA_CNT_UP2_3   IPU_REGISTERS_OFFSET+0x000400F4,0x000001FF

#define IPU_DI0_DW_SET2_4__ADDR                 IPU_REGISTERS_OFFSET+0x000400F8
#define IPU_DI0_DW_SET2_4__EMPTY                IPU_REGISTERS_OFFSET+0x000400F8,0x00000000
#define IPU_DI0_DW_SET2_4__FULL                 IPU_REGISTERS_OFFSET+0x000400F8,0xffffffff
#define IPU_DI0_DW_SET2_4__DI0_DATA_CNT_DOWN2_4 IPU_REGISTERS_OFFSET+0x000400F8,0x01FF0000
#define IPU_DI0_DW_SET2_4__DI0_DATA_CNT_UP2_4   IPU_REGISTERS_OFFSET+0x000400F8,0x000001FF

#define IPU_DI0_DW_SET2_5__ADDR                 IPU_REGISTERS_OFFSET+0x000400FC
#define IPU_DI0_DW_SET2_5__EMPTY                IPU_REGISTERS_OFFSET+0x000400FC,0x00000000
#define IPU_DI0_DW_SET2_5__FULL                 IPU_REGISTERS_OFFSET+0x000400FC,0xffffffff
#define IPU_DI0_DW_SET2_5__DI0_DATA_CNT_DOWN2_5 IPU_REGISTERS_OFFSET+0x000400FC,0x01FF0000
#define IPU_DI0_DW_SET2_5__DI0_DATA_CNT_UP2_5   IPU_REGISTERS_OFFSET+0x000400FC,0x000001FF

#define IPU_DI0_DW_SET2_6__ADDR                 IPU_REGISTERS_OFFSET+0x00040100
#define IPU_DI0_DW_SET2_6__EMPTY                IPU_REGISTERS_OFFSET+0x00040100,0x00000000
#define IPU_DI0_DW_SET2_6__FULL                 IPU_REGISTERS_OFFSET+0x00040100,0xffffffff
#define IPU_DI0_DW_SET2_6__DI0_DATA_CNT_DOWN2_6 IPU_REGISTERS_OFFSET+0x00040100,0x01FF0000
#define IPU_DI0_DW_SET2_6__DI0_DATA_CNT_UP2_6   IPU_REGISTERS_OFFSET+0x00040100,0x000001FF

#define IPU_DI0_DW_SET2_7__ADDR                 IPU_REGISTERS_OFFSET+0x00040104
#define IPU_DI0_DW_SET2_7__EMPTY                IPU_REGISTERS_OFFSET+0x00040104,0x00000000
#define IPU_DI0_DW_SET2_7__FULL                 IPU_REGISTERS_OFFSET+0x00040104,0xffffffff
#define IPU_DI0_DW_SET2_7__DI0_DATA_CNT_DOWN2_7 IPU_REGISTERS_OFFSET+0x00040104,0x01FF0000
#define IPU_DI0_DW_SET2_7__DI0_DATA_CNT_UP2_7   IPU_REGISTERS_OFFSET+0x00040104,0x000001FF

#define IPU_DI0_DW_SET2_8__ADDR                 IPU_REGISTERS_OFFSET+0x00040108
#define IPU_DI0_DW_SET2_8__EMPTY                IPU_REGISTERS_OFFSET+0x00040108,0x00000000
#define IPU_DI0_DW_SET2_8__FULL                 IPU_REGISTERS_OFFSET+0x00040108,0xffffffff
#define IPU_DI0_DW_SET2_8__DI0_DATA_CNT_DOWN2_8 IPU_REGISTERS_OFFSET+0x00040108,0x01FF0000
#define IPU_DI0_DW_SET2_8__DI0_DATA_CNT_UP2_8   IPU_REGISTERS_OFFSET+0x00040108,0x000001FF

#define IPU_DI0_DW_SET2_9__ADDR                 IPU_REGISTERS_OFFSET+0x0004010C
#define IPU_DI0_DW_SET2_9__EMPTY                IPU_REGISTERS_OFFSET+0x0004010C,0x00000000
#define IPU_DI0_DW_SET2_9__FULL                 IPU_REGISTERS_OFFSET+0x0004010C,0xffffffff
#define IPU_DI0_DW_SET2_9__DI0_DATA_CNT_DOWN2_9 IPU_REGISTERS_OFFSET+0x0004010C,0x01FF0000
#define IPU_DI0_DW_SET2_9__DI0_DATA_CNT_UP2_9   IPU_REGISTERS_OFFSET+0x0004010C,0x000001FF

#define IPU_DI0_DW_SET2_10__ADDR                  IPU_REGISTERS_OFFSET+0x00040110
#define IPU_DI0_DW_SET2_10__EMPTY                 IPU_REGISTERS_OFFSET+0x00040110,0x00000000
#define IPU_DI0_DW_SET2_10__FULL                  IPU_REGISTERS_OFFSET+0x00040110,0xffffffff
#define IPU_DI0_DW_SET2_10__DI0_DATA_CNT_DOWN2_10 IPU_REGISTERS_OFFSET+0x00040110,0x01FF0000
#define IPU_DI0_DW_SET2_10__DI0_DATA_CNT_UP2_10   IPU_REGISTERS_OFFSET+0x00040110,0x000001FF

#define IPU_DI0_DW_SET2_11__ADDR                  IPU_REGISTERS_OFFSET+0x00040114
#define IPU_DI0_DW_SET2_11__EMPTY                 IPU_REGISTERS_OFFSET+0x00040114,0x00000000
#define IPU_DI0_DW_SET2_11__FULL                  IPU_REGISTERS_OFFSET+0x00040114,0xffffffff
#define IPU_DI0_DW_SET2_11__DI0_DATA_CNT_DOWN2_11 IPU_REGISTERS_OFFSET+0x00040114,0x01FF0000
#define IPU_DI0_DW_SET2_11__DI0_DATA_CNT_UP2_11   IPU_REGISTERS_OFFSET+0x00040114,0x000001FF

#define IPU_DI0_DW_SET3_0__ADDR                 IPU_REGISTERS_OFFSET+0x00040118
#define IPU_DI0_DW_SET3_0__EMPTY                IPU_REGISTERS_OFFSET+0x00040118,0x00000000
#define IPU_DI0_DW_SET3_0__FULL                 IPU_REGISTERS_OFFSET+0x00040118,0xffffffff
#define IPU_DI0_DW_SET3_0__DI0_DATA_CNT_DOWN3_0 IPU_REGISTERS_OFFSET+0x00040118,0x01FF0000
#define IPU_DI0_DW_SET3_0__DI0_DATA_CNT_UP3_0   IPU_REGISTERS_OFFSET+0x00040118,0x000001FF

#define IPU_DI0_DW_SET3_1__ADDR                 IPU_REGISTERS_OFFSET+0x0004011C
#define IPU_DI0_DW_SET3_1__EMPTY                IPU_REGISTERS_OFFSET+0x0004011C,0x00000000
#define IPU_DI0_DW_SET3_1__FULL                 IPU_REGISTERS_OFFSET+0x0004011C,0xffffffff
#define IPU_DI0_DW_SET3_1__DI0_DATA_CNT_DOWN3_1 IPU_REGISTERS_OFFSET+0x0004011C,0x01FF0000
#define IPU_DI0_DW_SET3_1__DI0_DATA_CNT_UP3_1   IPU_REGISTERS_OFFSET+0x0004011C,0x000001FF

#define IPU_DI0_DW_SET3_2__ADDR                 IPU_REGISTERS_OFFSET+0x00040120
#define IPU_DI0_DW_SET3_2__EMPTY                IPU_REGISTERS_OFFSET+0x00040120,0x00000000
#define IPU_DI0_DW_SET3_2__FULL                 IPU_REGISTERS_OFFSET+0x00040120,0xffffffff
#define IPU_DI0_DW_SET3_2__DI0_DATA_CNT_DOWN3_2 IPU_REGISTERS_OFFSET+0x00040120,0x01FF0000
#define IPU_DI0_DW_SET3_2__DI0_DATA_CNT_UP3_2   IPU_REGISTERS_OFFSET+0x00040120,0x000001FF

#define IPU_DI0_DW_SET3_3__ADDR                 IPU_REGISTERS_OFFSET+0x00040124
#define IPU_DI0_DW_SET3_3__EMPTY                IPU_REGISTERS_OFFSET+0x00040124,0x00000000
#define IPU_DI0_DW_SET3_3__FULL                 IPU_REGISTERS_OFFSET+0x00040124,0xffffffff
#define IPU_DI0_DW_SET3_3__DI0_DATA_CNT_DOWN3_3 IPU_REGISTERS_OFFSET+0x00040124,0x01FF0000
#define IPU_DI0_DW_SET3_3__DI0_DATA_CNT_UP3_3   IPU_REGISTERS_OFFSET+0x00040124,0x000001FF

#define IPU_DI0_DW_SET3_4__ADDR                 IPU_REGISTERS_OFFSET+0x00040128
#define IPU_DI0_DW_SET3_4__EMPTY                IPU_REGISTERS_OFFSET+0x00040128,0x00000000
#define IPU_DI0_DW_SET3_4__FULL                 IPU_REGISTERS_OFFSET+0x00040128,0xffffffff
#define IPU_DI0_DW_SET3_4__DI0_DATA_CNT_DOWN3_4 IPU_REGISTERS_OFFSET+0x00040128,0x01FF0000
#define IPU_DI0_DW_SET3_4__DI0_DATA_CNT_UP3_4   IPU_REGISTERS_OFFSET+0x00040128,0x000001FF

#define IPU_DI0_DW_SET3_5__ADDR                 IPU_REGISTERS_OFFSET+0x0004012C
#define IPU_DI0_DW_SET3_5__EMPTY                IPU_REGISTERS_OFFSET+0x0004012C,0x00000000
#define IPU_DI0_DW_SET3_5__FULL                 IPU_REGISTERS_OFFSET+0x0004012C,0xffffffff
#define IPU_DI0_DW_SET3_5__DI0_DATA_CNT_DOWN3_5 IPU_REGISTERS_OFFSET+0x0004012C,0x01FF0000
#define IPU_DI0_DW_SET3_5__DI0_DATA_CNT_UP3_5   IPU_REGISTERS_OFFSET+0x0004012C,0x000001FF

#define IPU_DI0_DW_SET3_6__ADDR                 IPU_REGISTERS_OFFSET+0x00040130
#define IPU_DI0_DW_SET3_6__EMPTY                IPU_REGISTERS_OFFSET+0x00040130,0x00000000
#define IPU_DI0_DW_SET3_6__FULL                 IPU_REGISTERS_OFFSET+0x00040130,0xffffffff
#define IPU_DI0_DW_SET3_6__DI0_DATA_CNT_DOWN3_6 IPU_REGISTERS_OFFSET+0x00040130,0x01FF0000
#define IPU_DI0_DW_SET3_6__DI0_DATA_CNT_UP3_6   IPU_REGISTERS_OFFSET+0x00040130,0x000001FF

#define IPU_DI0_DW_SET3_7__ADDR                 IPU_REGISTERS_OFFSET+0x00040134
#define IPU_DI0_DW_SET3_7__EMPTY                IPU_REGISTERS_OFFSET+0x00040134,0x00000000
#define IPU_DI0_DW_SET3_7__FULL                 IPU_REGISTERS_OFFSET+0x00040134,0xffffffff
#define IPU_DI0_DW_SET3_7__DI0_DATA_CNT_DOWN3_7 IPU_REGISTERS_OFFSET+0x00040134,0x01FF0000
#define IPU_DI0_DW_SET3_7__DI0_DATA_CNT_UP3_7   IPU_REGISTERS_OFFSET+0x00040134,0x000001FF

#define IPU_DI0_DW_SET3_8__ADDR                 IPU_REGISTERS_OFFSET+0x00040138
#define IPU_DI0_DW_SET3_8__EMPTY                IPU_REGISTERS_OFFSET+0x00040138,0x00000000
#define IPU_DI0_DW_SET3_8__FULL                 IPU_REGISTERS_OFFSET+0x00040138,0xffffffff
#define IPU_DI0_DW_SET3_8__DI0_DATA_CNT_DOWN3_8 IPU_REGISTERS_OFFSET+0x00040138,0x01FF0000
#define IPU_DI0_DW_SET3_8__DI0_DATA_CNT_UP3_8   IPU_REGISTERS_OFFSET+0x00040138,0x000001FF

#define IPU_DI0_DW_SET3_9__ADDR                 IPU_REGISTERS_OFFSET+0x0004013C
#define IPU_DI0_DW_SET3_9__EMPTY                IPU_REGISTERS_OFFSET+0x0004013C,0x00000000
#define IPU_DI0_DW_SET3_9__FULL                 IPU_REGISTERS_OFFSET+0x0004013C,0xffffffff
#define IPU_DI0_DW_SET3_9__DI0_DATA_CNT_DOWN3_9 IPU_REGISTERS_OFFSET+0x0004013C,0x01FF0000
#define IPU_DI0_DW_SET3_9__DI0_DATA_CNT_UP3_9   IPU_REGISTERS_OFFSET+0x0004013C,0x000001FF

#define IPU_DI0_DW_SET3_10__ADDR                  IPU_REGISTERS_OFFSET+0x00040140
#define IPU_DI0_DW_SET3_10__EMPTY                 IPU_REGISTERS_OFFSET+0x00040140,0x00000000
#define IPU_DI0_DW_SET3_10__FULL                  IPU_REGISTERS_OFFSET+0x00040140,0xffffffff
#define IPU_DI0_DW_SET3_10__DI0_DATA_CNT_DOWN3_10 IPU_REGISTERS_OFFSET+0x00040140,0x01FF0000
#define IPU_DI0_DW_SET3_10__DI0_DATA_CNT_UP3_10   IPU_REGISTERS_OFFSET+0x00040140,0x000001FF

#define IPU_DI0_DW_SET3_11__ADDR                  IPU_REGISTERS_OFFSET+0x00040144
#define IPU_DI0_DW_SET3_11__EMPTY                 IPU_REGISTERS_OFFSET+0x00040144,0x00000000
#define IPU_DI0_DW_SET3_11__FULL                  IPU_REGISTERS_OFFSET+0x00040144,0xffffffff
#define IPU_DI0_DW_SET3_11__DI0_DATA_CNT_DOWN3_11 IPU_REGISTERS_OFFSET+0x00040144,0x01FF0000
#define IPU_DI0_DW_SET3_11__DI0_DATA_CNT_UP3_11   IPU_REGISTERS_OFFSET+0x00040144,0x000001FF

#define IPU_DI0_STP_REP_1__ADDR              IPU_REGISTERS_OFFSET+0x00040148
#define IPU_DI0_STP_REP_1__EMPTY             IPU_REGISTERS_OFFSET+0x00040148,0x00000000
#define IPU_DI0_STP_REP_1__FULL              IPU_REGISTERS_OFFSET+0x00040148,0xffffffff
#define IPU_DI0_STP_REP_1__DI0_STEP_REPEAT_2 IPU_REGISTERS_OFFSET+0x00040148,0x0FFF0000
#define IPU_DI0_STP_REP_1__DI0_STEP_REPEAT_1 IPU_REGISTERS_OFFSET+0x00040148,0x00000FFF

#define IPU_DI0_STP_REP_2__ADDR              IPU_REGISTERS_OFFSET+0x0004014C
#define IPU_DI0_STP_REP_2__EMPTY             IPU_REGISTERS_OFFSET+0x0004014C,0x00000000
#define IPU_DI0_STP_REP_2__FULL              IPU_REGISTERS_OFFSET+0x0004014C,0xffffffff
#define IPU_DI0_STP_REP_2__DI0_STEP_REPEAT_4 IPU_REGISTERS_OFFSET+0x0004014C,0x0FFF0000
#define IPU_DI0_STP_REP_2__DI0_STEP_REPEAT_3 IPU_REGISTERS_OFFSET+0x0004014C,0x00000FFF

#define IPU_DI0_STP_REP_3__ADDR              IPU_REGISTERS_OFFSET+0x00040150
#define IPU_DI0_STP_REP_3__EMPTY             IPU_REGISTERS_OFFSET+0x00040150,0x00000000
#define IPU_DI0_STP_REP_3__FULL              IPU_REGISTERS_OFFSET+0x00040150,0xffffffff
#define IPU_DI0_STP_REP_3__DI0_STEP_REPEAT_6 IPU_REGISTERS_OFFSET+0x00040150,0x0FFF0000
#define IPU_DI0_STP_REP_3__DI0_STEP_REPEAT_5 IPU_REGISTERS_OFFSET+0x00040150,0x00000FFF

#define IPU_DI0_STP_REP_4__ADDR              IPU_REGISTERS_OFFSET+0x00040154
#define IPU_DI0_STP_REP_4__EMPTY             IPU_REGISTERS_OFFSET+0x00040154,0x00000000
#define IPU_DI0_STP_REP_4__FULL              IPU_REGISTERS_OFFSET+0x00040154,0xffffffff
#define IPU_DI0_STP_REP_4__DI0_STEP_REPEAT_8 IPU_REGISTERS_OFFSET+0x00040154,0x0FFF0000
#define IPU_DI0_STP_REP_4__DI0_STEP_REPEAT_7 IPU_REGISTERS_OFFSET+0x00040154,0x00000FFF

#define IPU_DI0_STP_REP_9__ADDR              IPU_REGISTERS_OFFSET+0x00040158
#define IPU_DI0_STP_REP_9__EMPTY             IPU_REGISTERS_OFFSET+0x00040158,0x00000000
#define IPU_DI0_STP_REP_9__FULL              IPU_REGISTERS_OFFSET+0x00040158,0xffffffff
#define IPU_DI0_STP_REP_9__DI0_STEP_REPEAT_9 IPU_REGISTERS_OFFSET+0x00040158,0x00000FFF

#define IPU_DI0_SER_CONF__ADDR                       IPU_REGISTERS_OFFSET+0x0004015C
#define IPU_DI0_SER_CONF__EMPTY                      IPU_REGISTERS_OFFSET+0x0004015C,0x00000000
#define IPU_DI0_SER_CONF__FULL                       IPU_REGISTERS_OFFSET+0x0004015C,0xffffffff
#define IPU_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_R_1 IPU_REGISTERS_OFFSET+0x0004015C,0xF0000000
#define IPU_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_R_0 IPU_REGISTERS_OFFSET+0x0004015C,0x0F000000
#define IPU_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_W_1 IPU_REGISTERS_OFFSET+0x0004015C,0x00F00000
#define IPU_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_W_0 IPU_REGISTERS_OFFSET+0x0004015C,0x000F0000
#define IPU_DI0_SER_CONF__DI0_SERIAL_LATCH           IPU_REGISTERS_OFFSET+0x0004015C,0x0000FF00
#define IPU_DI0_SER_CONF__DI0_LLA_SER_ACCESS         IPU_REGISTERS_OFFSET+0x0004015C,0x00000020
#define IPU_DI0_SER_CONF__DI0_SER_CLK_POLARITY       IPU_REGISTERS_OFFSET+0x0004015C,0x00000010
#define IPU_DI0_SER_CONF__DI0_SERIAL_DATA_POLARITY   IPU_REGISTERS_OFFSET+0x0004015C,0x00000008
#define IPU_DI0_SER_CONF__DI0_SERIAL_RS_POLARITY     IPU_REGISTERS_OFFSET+0x0004015C,0x00000004
#define IPU_DI0_SER_CONF__DI0_SERIAL_CS_POLARITY     IPU_REGISTERS_OFFSET+0x0004015C,0x00000002
#define IPU_DI0_SER_CONF__DI0_WAIT4SERIAL            IPU_REGISTERS_OFFSET+0x0004015C,0x00000001

#define IPU_DI0_SSC__ADDR              IPU_REGISTERS_OFFSET+0x00040160
#define IPU_DI0_SSC__EMPTY             IPU_REGISTERS_OFFSET+0x00040160,0x00000000
#define IPU_DI0_SSC__FULL              IPU_REGISTERS_OFFSET+0x00040160,0xffffffff
#define IPU_DI0_SSC__DI0_PIN17_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00800000
#define IPU_DI0_SSC__DI0_PIN16_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00400000
#define IPU_DI0_SSC__DI0_PIN15_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00200000
#define IPU_DI0_SSC__DI0_PIN14_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00100000
#define IPU_DI0_SSC__DI0_PIN13_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00080000
#define IPU_DI0_SSC__DI0_PIN12_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00040000
#define IPU_DI0_SSC__DI0_PIN11_ERM     IPU_REGISTERS_OFFSET+0x00040160,0x00020000
#define IPU_DI0_SSC__DI0_CS_ERM        IPU_REGISTERS_OFFSET+0x00040160,0x00010000
#define IPU_DI0_SSC__DI0_WAIT_ON       IPU_REGISTERS_OFFSET+0x00040160,0x00000020
#define IPU_DI0_SSC__DI0_BYTE_EN_RD_IN IPU_REGISTERS_OFFSET+0x00040160,0x00000008
#define IPU_DI0_SSC__DI0_BYTE_EN_PNTR  IPU_REGISTERS_OFFSET+0x00040160,0x00000007

#define IPU_DI0_POL__ADDR                     IPU_REGISTERS_OFFSET+0x00040164
#define IPU_DI0_POL__EMPTY                    IPU_REGISTERS_OFFSET+0x00040164,0x00000000
#define IPU_DI0_POL__FULL                     IPU_REGISTERS_OFFSET+0x00040164,0xffffffff
#define IPU_DI0_POL__DI0_WAIT_POLARITY        IPU_REGISTERS_OFFSET+0x00040164,0x04000000
#define IPU_DI0_POL__DI0_CS1_BYTE_EN_POLARITY IPU_REGISTERS_OFFSET+0x00040164,0x02000000
#define IPU_DI0_POL__DI0_CS0_BYTE_EN_POLARITY IPU_REGISTERS_OFFSET+0x00040164,0x01000000
#define IPU_DI0_POL__DI0_CS1_DATA_POLARITY    IPU_REGISTERS_OFFSET+0x00040164,0x00800000
#define IPU_DI0_POL__DI0_CS1_POLARITY_17      IPU_REGISTERS_OFFSET+0x00040164,0x00400000
#define IPU_DI0_POL__DI0_CS1_POLARITY_16      IPU_REGISTERS_OFFSET+0x00040164,0x00200000
#define IPU_DI0_POL__DI0_CS1_POLARITY_15      IPU_REGISTERS_OFFSET+0x00040164,0x00100000
#define IPU_DI0_POL__DI0_CS1_POLARITY_14      IPU_REGISTERS_OFFSET+0x00040164,0x00080000
#define IPU_DI0_POL__DI0_CS1_POLARITY_13      IPU_REGISTERS_OFFSET+0x00040164,0x00040000
#define IPU_DI0_POL__DI0_CS1_POLARITY_12      IPU_REGISTERS_OFFSET+0x00040164,0x00020000
#define IPU_DI0_POL__DI0_CS1_POLARITY_11      IPU_REGISTERS_OFFSET+0x00040164,0x00010000
#define IPU_DI0_POL__DI0_CS0_DATA_POLARITY    IPU_REGISTERS_OFFSET+0x00040164,0x00008000
#define IPU_DI0_POL__DI0_CS0_POLARITY_17      IPU_REGISTERS_OFFSET+0x00040164,0x00004000
#define IPU_DI0_POL__DI0_CS0_POLARITY_16      IPU_REGISTERS_OFFSET+0x00040164,0x00002000
#define IPU_DI0_POL__DI0_CS0_POLARITY_15      IPU_REGISTERS_OFFSET+0x00040164,0x00001000
#define IPU_DI0_POL__DI0_CS0_POLARITY_14      IPU_REGISTERS_OFFSET+0x00040164,0x00000800
#define IPU_DI0_POL__DI0_CS0_POLARITY_13      IPU_REGISTERS_OFFSET+0x00040164,0x00000400
#define IPU_DI0_POL__DI0_CS0_POLARITY_12      IPU_REGISTERS_OFFSET+0x00040164,0x00000200
#define IPU_DI0_POL__DI0_CS0_POLARITY_11      IPU_REGISTERS_OFFSET+0x00040164,0x00000100
#define IPU_DI0_POL__DI0_DRDY_DATA_POLARITY   IPU_REGISTERS_OFFSET+0x00040164,0x00000080
#define IPU_DI0_POL__DI0_DRDY_POLARITY_17     IPU_REGISTERS_OFFSET+0x00040164,0x00000040
#define IPU_DI0_POL__DI0_DRDY_POLARITY_16     IPU_REGISTERS_OFFSET+0x00040164,0x00000020
#define IPU_DI0_POL__DI0_DRDY_POLARITY_15     IPU_REGISTERS_OFFSET+0x00040164,0x00000010
#define IPU_DI0_POL__DI0_DRDY_POLARITY_14     IPU_REGISTERS_OFFSET+0x00040164,0x00000008
#define IPU_DI0_POL__DI0_DRDY_POLARITY_13     IPU_REGISTERS_OFFSET+0x00040164,0x00000004
#define IPU_DI0_POL__DI0_DRDY_POLARITY_12     IPU_REGISTERS_OFFSET+0x00040164,0x00000002
#define IPU_DI0_POL__DI0_DRDY_POLARITY_11     IPU_REGISTERS_OFFSET+0x00040164,0x00000001

#define IPU_DI0_AW0__ADDR              IPU_REGISTERS_OFFSET+0x00040168
#define IPU_DI0_AW0__EMPTY             IPU_REGISTERS_OFFSET+0x00040168,0x00000000
#define IPU_DI0_AW0__FULL              IPU_REGISTERS_OFFSET+0x00040168,0xffffffff
#define IPU_DI0_AW0__DI0_AW_TRIG_SEL   IPU_REGISTERS_OFFSET+0x00040168,0xF0000000
#define IPU_DI0_AW0__DI0_AW_HEND       IPU_REGISTERS_OFFSET+0x00040168,0x0FFF0000
#define IPU_DI0_AW0__DI0_AW_HCOUNT_SEL IPU_REGISTERS_OFFSET+0x00040168,0x0000F000
#define IPU_DI0_AW0__DI0_AW_HSTART     IPU_REGISTERS_OFFSET+0x00040168,0x00000FFF

#define IPU_DI0_AW1__ADDR              IPU_REGISTERS_OFFSET+0x0004016C
#define IPU_DI0_AW1__EMPTY             IPU_REGISTERS_OFFSET+0x0004016C,0x00000000
#define IPU_DI0_AW1__FULL              IPU_REGISTERS_OFFSET+0x0004016C,0xffffffff
#define IPU_DI0_AW1__DI0_AW_VEND       IPU_REGISTERS_OFFSET+0x0004016C,0x0FFF0000
#define IPU_DI0_AW1__DI0_AW_VCOUNT_SEL IPU_REGISTERS_OFFSET+0x0004016C,0x0000F000
#define IPU_DI0_AW1__DI0_AW_VSTART     IPU_REGISTERS_OFFSET+0x0004016C,0x00000FFF

#define IPU_DI0_SCR_CONF__ADDR              IPU_REGISTERS_OFFSET+0x00040170
#define IPU_DI0_SCR_CONF__EMPTY             IPU_REGISTERS_OFFSET+0x00040170,0x00000000
#define IPU_DI0_SCR_CONF__FULL              IPU_REGISTERS_OFFSET+0x00040170,0xffffffff
#define IPU_DI0_SCR_CONF__DI0_SCREEN_HEIGHT IPU_REGISTERS_OFFSET+0x00040170,0x00000FFF

#define IPU_DI0_STAT__ADDR                IPU_REGISTERS_OFFSET+0x00040174
#define IPU_DI0_STAT__EMPTY               IPU_REGISTERS_OFFSET+0x00040174,0x00000000
#define IPU_DI0_STAT__FULL                IPU_REGISTERS_OFFSET+0x00040174,0xffffffff
#define IPU_DI0_STAT__DI0_CNTR_FIFO_FULL  IPU_REGISTERS_OFFSET+0x00040174,0x00000008
#define IPU_DI0_STAT__DI0_CNTR_FIFO_EMPTY IPU_REGISTERS_OFFSET+0x00040174,0x00000004
#define IPU_DI0_STAT__DI0_READ_FIFO_FULL  IPU_REGISTERS_OFFSET+0x00040174,0x00000002
#define IPU_DI0_STAT__DI0_READ_FIFO_EMPTY IPU_REGISTERS_OFFSET+0x00040174,0x00000001

#define IPU_DI1_GENERAL__ADDR                  IPU_REGISTERS_OFFSET+0x00048000
#define IPU_DI1_GENERAL__EMPTY                 IPU_REGISTERS_OFFSET+0x00048000,0x00000000
#define IPU_DI1_GENERAL__FULL                  IPU_REGISTERS_OFFSET+0x00048000,0xffffffff
#define IPU_DI1_GENERAL__DI1_PIN8_PIN15_SEL    IPU_REGISTERS_OFFSET+0x00048000,0x80000000
#define IPU_DI1_GENERAL__DI1_DISP_Y_SEL        IPU_REGISTERS_OFFSET+0x00048000,0x70000000
#define IPU_DI1_GENERAL__DI1_CLOCK_STOP_MODE   IPU_REGISTERS_OFFSET+0x00048000,0x0F000000
#define IPU_DI1_GENERAL__DI1_DISP_CLOCK_INIT   IPU_REGISTERS_OFFSET+0x00048000,0x00800000
#define IPU_DI1_GENERAL__DI1_MASK_SEL          IPU_REGISTERS_OFFSET+0x00048000,0x00400000
#define IPU_DI1_GENERAL__DI1_VSYNC_EXT         IPU_REGISTERS_OFFSET+0x00048000,0x00200000
#define IPU_DI1_GENERAL__DI1_CLK_EXT           IPU_REGISTERS_OFFSET+0x00048000,0x00100000
#define IPU_DI1_GENERAL__DI1_WATCHDOG_MODE     IPU_REGISTERS_OFFSET+0x00048000,0x000C0000
#define IPU_DI1_GENERAL__DI1_POLARITY_DISP_CLK IPU_REGISTERS_OFFSET+0x00048000,0x00020000
#define IPU_DI1_GENERAL__DI1_SYNC_COUNT_SEL    IPU_REGISTERS_OFFSET+0x00048000,0x0000F000
#define IPU_DI1_GENERAL__DI1_ERR_TREATMENT     IPU_REGISTERS_OFFSET+0x00048000,0x00000800
#define IPU_DI1_GENERAL__DI1_ERM_VSYNC_SEL     IPU_REGISTERS_OFFSET+0x00048000,0x00000400
#define IPU_DI1_GENERAL__DI1_POLARITY_CS1      IPU_REGISTERS_OFFSET+0x00048000,0x00000200
#define IPU_DI1_GENERAL__DI1_POLARITY_CS0      IPU_REGISTERS_OFFSET+0x00048000,0x00000100
#define IPU_DI1_GENERAL__DI1_POLARITY_8        IPU_REGISTERS_OFFSET+0x00048000,0x00000080
#define IPU_DI1_GENERAL__DI1_POLARITY_7        IPU_REGISTERS_OFFSET+0x00048000,0x00000040
#define IPU_DI1_GENERAL__DI1_POLARITY_6        IPU_REGISTERS_OFFSET+0x00048000,0x00000020
#define IPU_DI1_GENERAL__DI1_POLARITY_5        IPU_REGISTERS_OFFSET+0x00048000,0x00000010
#define IPU_DI1_GENERAL__DI1_POLARITY_4        IPU_REGISTERS_OFFSET+0x00048000,0x00000008
#define IPU_DI1_GENERAL__DI1_POLARITY_3        IPU_REGISTERS_OFFSET+0x00048000,0x00000004
#define IPU_DI1_GENERAL__DI1_POLARITY_2        IPU_REGISTERS_OFFSET+0x00048000,0x00000002
#define IPU_DI1_GENERAL__DI1_POLARITY_1        IPU_REGISTERS_OFFSET+0x00048000,0x00000001

#define IPU_DI1_BS_CLKGEN0__ADDR                IPU_REGISTERS_OFFSET+0x00048004
#define IPU_DI1_BS_CLKGEN0__EMPTY               IPU_REGISTERS_OFFSET+0x00048004,0x00000000
#define IPU_DI1_BS_CLKGEN0__FULL                IPU_REGISTERS_OFFSET+0x00048004,0xffffffff
#define IPU_DI1_BS_CLKGEN0__DI1_DISP_CLK_OFFSET IPU_REGISTERS_OFFSET+0x00048004,0x01FF0000
#define IPU_DI1_BS_CLKGEN0__DI1_DISP_CLK_PERIOD IPU_REGISTERS_OFFSET+0x00048004,0x00000FFF

#define IPU_DI1_BS_CLKGEN1__ADDR              IPU_REGISTERS_OFFSET+0x00048008
#define IPU_DI1_BS_CLKGEN1__EMPTY             IPU_REGISTERS_OFFSET+0x00048008,0x00000000
#define IPU_DI1_BS_CLKGEN1__FULL              IPU_REGISTERS_OFFSET+0x00048008,0xffffffff
#define IPU_DI1_BS_CLKGEN1__DI1_DISP_CLK_DOWN IPU_REGISTERS_OFFSET+0x00048008,0x01FF0000
#define IPU_DI1_BS_CLKGEN1__DI1_DISP_CLK_UP   IPU_REGISTERS_OFFSET+0x00048008,0x000001FF

#define IPU_DI1_SW_GEN0_1__ADDR                    IPU_REGISTERS_OFFSET+0x0004800C
#define IPU_DI1_SW_GEN0_1__EMPTY                   IPU_REGISTERS_OFFSET+0x0004800C,0x00000000
#define IPU_DI1_SW_GEN0_1__FULL                    IPU_REGISTERS_OFFSET+0x0004800C,0xffffffff
#define IPU_DI1_SW_GEN0_1__DI1_RUN_VALUE_M1_1      IPU_REGISTERS_OFFSET+0x0004800C,0x7FF80000
#define IPU_DI1_SW_GEN0_1__DI1_RUN_RESOLUTION_1    IPU_REGISTERS_OFFSET+0x0004800C,0x00070000
#define IPU_DI1_SW_GEN0_1__DI1_OFFSET_VALUE_1      IPU_REGISTERS_OFFSET+0x0004800C,0x00007FF8
#define IPU_DI1_SW_GEN0_1__DI1_OFFSET_RESOLUTION_1 IPU_REGISTERS_OFFSET+0x0004800C,0x00000007

#define IPU_DI1_SW_GEN0_2__ADDR                    IPU_REGISTERS_OFFSET+0x00048010
#define IPU_DI1_SW_GEN0_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00048010,0x00000000
#define IPU_DI1_SW_GEN0_2__FULL                    IPU_REGISTERS_OFFSET+0x00048010,0xffffffff
#define IPU_DI1_SW_GEN0_2__DI1_RUN_VALUE_M1_2      IPU_REGISTERS_OFFSET+0x00048010,0x7FF80000
#define IPU_DI1_SW_GEN0_2__DI1_RUN_RESOLUTION_2    IPU_REGISTERS_OFFSET+0x00048010,0x00070000
#define IPU_DI1_SW_GEN0_2__DI1_OFFSET_VALUE_2      IPU_REGISTERS_OFFSET+0x00048010,0x00007FF8
#define IPU_DI1_SW_GEN0_2__DI1_OFFSET_RESOLUTION_2 IPU_REGISTERS_OFFSET+0x00048010,0x00000007

#define IPU_DI1_SW_GEN0_3__ADDR                    IPU_REGISTERS_OFFSET+0x00048014
#define IPU_DI1_SW_GEN0_3__EMPTY                   IPU_REGISTERS_OFFSET+0x00048014,0x00000000
#define IPU_DI1_SW_GEN0_3__FULL                    IPU_REGISTERS_OFFSET+0x00048014,0xffffffff
#define IPU_DI1_SW_GEN0_3__DI1_RUN_VALUE_M1_3      IPU_REGISTERS_OFFSET+0x00048014,0x7FF80000
#define IPU_DI1_SW_GEN0_3__DI1_RUN_RESOLUTION_3    IPU_REGISTERS_OFFSET+0x00048014,0x00070000
#define IPU_DI1_SW_GEN0_3__DI1_OFFSET_VALUE_3      IPU_REGISTERS_OFFSET+0x00048014,0x00007FF8
#define IPU_DI1_SW_GEN0_3__DI1_OFFSET_RESOLUTION_3 IPU_REGISTERS_OFFSET+0x00048014,0x00000007

#define IPU_DI1_SW_GEN0_4__ADDR                    IPU_REGISTERS_OFFSET+0x00048018
#define IPU_DI1_SW_GEN0_4__EMPTY                   IPU_REGISTERS_OFFSET+0x00048018,0x00000000
#define IPU_DI1_SW_GEN0_4__FULL                    IPU_REGISTERS_OFFSET+0x00048018,0xffffffff
#define IPU_DI1_SW_GEN0_4__DI1_RUN_VALUE_M1_4      IPU_REGISTERS_OFFSET+0x00048018,0x7FF80000
#define IPU_DI1_SW_GEN0_4__DI1_RUN_RESOLUTION_4    IPU_REGISTERS_OFFSET+0x00048018,0x00070000
#define IPU_DI1_SW_GEN0_4__DI1_OFFSET_VALUE_4      IPU_REGISTERS_OFFSET+0x00048018,0x00007FF8
#define IPU_DI1_SW_GEN0_4__DI1_OFFSET_RESOLUTION_4 IPU_REGISTERS_OFFSET+0x00048018,0x00000007

#define IPU_DI1_SW_GEN0_5__ADDR                    IPU_REGISTERS_OFFSET+0x0004801C
#define IPU_DI1_SW_GEN0_5__EMPTY                   IPU_REGISTERS_OFFSET+0x0004801C,0x00000000
#define IPU_DI1_SW_GEN0_5__FULL                    IPU_REGISTERS_OFFSET+0x0004801C,0xffffffff
#define IPU_DI1_SW_GEN0_5__DI1_RUN_VALUE_M1_5      IPU_REGISTERS_OFFSET+0x0004801C,0x7FF80000
#define IPU_DI1_SW_GEN0_5__DI1_RUN_RESOLUTION_5    IPU_REGISTERS_OFFSET+0x0004801C,0x00070000
#define IPU_DI1_SW_GEN0_5__DI1_OFFSET_VALUE_5      IPU_REGISTERS_OFFSET+0x0004801C,0x00007FF8
#define IPU_DI1_SW_GEN0_5__DI1_OFFSET_RESOLUTION_5 IPU_REGISTERS_OFFSET+0x0004801C,0x00000007

#define IPU_DI1_SW_GEN0_6__ADDR                    IPU_REGISTERS_OFFSET+0x00048020
#define IPU_DI1_SW_GEN0_6__EMPTY                   IPU_REGISTERS_OFFSET+0x00048020,0x00000000
#define IPU_DI1_SW_GEN0_6__FULL                    IPU_REGISTERS_OFFSET+0x00048020,0xffffffff
#define IPU_DI1_SW_GEN0_6__DI1_RUN_VALUE_M1_6      IPU_REGISTERS_OFFSET+0x00048020,0x7FF80000
#define IPU_DI1_SW_GEN0_6__DI1_RUN_RESOLUTION_6    IPU_REGISTERS_OFFSET+0x00048020,0x00070000
#define IPU_DI1_SW_GEN0_6__DI1_OFFSET_VALUE_6      IPU_REGISTERS_OFFSET+0x00048020,0x00007FF8
#define IPU_DI1_SW_GEN0_6__DI1_OFFSET_RESOLUTION_6 IPU_REGISTERS_OFFSET+0x00048020,0x00000007

#define IPU_DI1_SW_GEN0_7__ADDR                    IPU_REGISTERS_OFFSET+0x00048024
#define IPU_DI1_SW_GEN0_7__EMPTY                   IPU_REGISTERS_OFFSET+0x00048024,0x00000000
#define IPU_DI1_SW_GEN0_7__FULL                    IPU_REGISTERS_OFFSET+0x00048024,0xffffffff
#define IPU_DI1_SW_GEN0_7__DI1_RUN_VALUE_M1_7      IPU_REGISTERS_OFFSET+0x00048024,0x7FF80000
#define IPU_DI1_SW_GEN0_7__DI1_RUN_RESOLUTION_7    IPU_REGISTERS_OFFSET+0x00048024,0x00070000
#define IPU_DI1_SW_GEN0_7__DI1_OFFSET_VALUE_7      IPU_REGISTERS_OFFSET+0x00048024,0x00007FF8
#define IPU_DI1_SW_GEN0_7__DI1_OFFSET_RESOLUTION_7 IPU_REGISTERS_OFFSET+0x00048024,0x00000007

#define IPU_DI1_SW_GEN0_8__ADDR                    IPU_REGISTERS_OFFSET+0x00048028
#define IPU_DI1_SW_GEN0_8__EMPTY                   IPU_REGISTERS_OFFSET+0x00048028,0x00000000
#define IPU_DI1_SW_GEN0_8__FULL                    IPU_REGISTERS_OFFSET+0x00048028,0xffffffff
#define IPU_DI1_SW_GEN0_8__DI1_RUN_VALUE_M1_8      IPU_REGISTERS_OFFSET+0x00048028,0x7FF80000
#define IPU_DI1_SW_GEN0_8__DI1_RUN_RESOLUTION_8    IPU_REGISTERS_OFFSET+0x00048028,0x00070000
#define IPU_DI1_SW_GEN0_8__DI1_OFFSET_VALUE_8      IPU_REGISTERS_OFFSET+0x00048028,0x00007FF8
#define IPU_DI1_SW_GEN0_8__DI1_OFFSET_RESOLUTION_8 IPU_REGISTERS_OFFSET+0x00048028,0x00000007

#define IPU_DI1_SW_GEN0_9__ADDR                    IPU_REGISTERS_OFFSET+0x0004802C
#define IPU_DI1_SW_GEN0_9__EMPTY                   IPU_REGISTERS_OFFSET+0x0004802C,0x00000000
#define IPU_DI1_SW_GEN0_9__FULL                    IPU_REGISTERS_OFFSET+0x0004802C,0xffffffff
#define IPU_DI1_SW_GEN0_9__DI1_RUN_VALUE_M1_9      IPU_REGISTERS_OFFSET+0x0004802C,0x7FF80000
#define IPU_DI1_SW_GEN0_9__DI1_RUN_RESOLUTION_9    IPU_REGISTERS_OFFSET+0x0004802C,0x00070000
#define IPU_DI1_SW_GEN0_9__DI1_OFFSET_VALUE_9      IPU_REGISTERS_OFFSET+0x0004802C,0x00007FF8
#define IPU_DI1_SW_GEN0_9__DI1_OFFSET_RESOLUTION_9 IPU_REGISTERS_OFFSET+0x0004802C,0x00000007

#define IPU_DI1_SW_GEN1_1__ADDR                           IPU_REGISTERS_OFFSET+0x00048030
#define IPU_DI1_SW_GEN1_1__EMPTY                          IPU_REGISTERS_OFFSET+0x00048030,0x00000000
#define IPU_DI1_SW_GEN1_1__FULL                           IPU_REGISTERS_OFFSET+0x00048030,0xffffffff
#define IPU_DI1_SW_GEN1_1__DI1_CNT_POLARITY_GEN_EN_1      IPU_REGISTERS_OFFSET+0x00048030,0x60000000
#define IPU_DI1_SW_GEN1_1__DI1_CNT_AUTO_RELOAD_1          IPU_REGISTERS_OFFSET+0x00048030,0x10000000
#define IPU_DI1_SW_GEN1_1__DI1_CNT_CLR_SEL_1              IPU_REGISTERS_OFFSET+0x00048030,0x0E000000
#define IPU_DI1_SW_GEN1_1__DI1_CNT_DOWN_1                 IPU_REGISTERS_OFFSET+0x00048030,0x01FF0000
#define IPU_DI1_SW_GEN1_1__DI1_CNT_POLARITY_TRIGGER_SEL_1 IPU_REGISTERS_OFFSET+0x00048030,0x00007000
#define IPU_DI1_SW_GEN1_1__DI1_CNT_POLARITY_CLR_SEL_1     IPU_REGISTERS_OFFSET+0x00048030,0x00000E00
#define IPU_DI1_SW_GEN1_1__DI1_CNT_UP_1                   IPU_REGISTERS_OFFSET+0x00048030,0x000001FF

#define IPU_DI1_SW_GEN1_2__ADDR                           IPU_REGISTERS_OFFSET+0x00048034
#define IPU_DI1_SW_GEN1_2__EMPTY                          IPU_REGISTERS_OFFSET+0x00048034,0x00000000
#define IPU_DI1_SW_GEN1_2__FULL                           IPU_REGISTERS_OFFSET+0x00048034,0xffffffff
#define IPU_DI1_SW_GEN1_2__DI1_CNT_POLARITY_GEN_EN_2      IPU_REGISTERS_OFFSET+0x00048034,0x60000000
#define IPU_DI1_SW_GEN1_2__DI1_CNT_AUTO_RELOAD_2          IPU_REGISTERS_OFFSET+0x00048034,0x10000000
#define IPU_DI1_SW_GEN1_2__DI1_CNT_CLR_SEL_2              IPU_REGISTERS_OFFSET+0x00048034,0x0E000000
#define IPU_DI1_SW_GEN1_2__DI1_CNT_DOWN_2                 IPU_REGISTERS_OFFSET+0x00048034,0x01FF0000
#define IPU_DI1_SW_GEN1_2__DI1_CNT_POLARITY_TRIGGER_SEL_2 IPU_REGISTERS_OFFSET+0x00048034,0x00007000
#define IPU_DI1_SW_GEN1_2__DI1_CNT_POLARITY_CLR_SEL_2     IPU_REGISTERS_OFFSET+0x00048034,0x00000E00
#define IPU_DI1_SW_GEN1_2__DI1_CNT_UP_2                   IPU_REGISTERS_OFFSET+0x00048034,0x000001FF

#define IPU_DI1_SW_GEN1_3__ADDR                           IPU_REGISTERS_OFFSET+0x00048038
#define IPU_DI1_SW_GEN1_3__EMPTY                          IPU_REGISTERS_OFFSET+0x00048038,0x00000000
#define IPU_DI1_SW_GEN1_3__FULL                           IPU_REGISTERS_OFFSET+0x00048038,0xffffffff
#define IPU_DI1_SW_GEN1_3__DI1_CNT_POLARITY_GEN_EN_3      IPU_REGISTERS_OFFSET+0x00048038,0x60000000
#define IPU_DI1_SW_GEN1_3__DI1_CNT_AUTO_RELOAD_3          IPU_REGISTERS_OFFSET+0x00048038,0x10000000
#define IPU_DI1_SW_GEN1_3__DI1_CNT_CLR_SEL_3              IPU_REGISTERS_OFFSET+0x00048038,0x0E000000
#define IPU_DI1_SW_GEN1_3__DI1_CNT_DOWN_3                 IPU_REGISTERS_OFFSET+0x00048038,0x01FF0000
#define IPU_DI1_SW_GEN1_3__DI1_CNT_POLARITY_TRIGGER_SEL_3 IPU_REGISTERS_OFFSET+0x00048038,0x00007000
#define IPU_DI1_SW_GEN1_3__DI1_CNT_POLARITY_CLR_SEL_3     IPU_REGISTERS_OFFSET+0x00048038,0x00000E00
#define IPU_DI1_SW_GEN1_3__DI1_CNT_UP_3                   IPU_REGISTERS_OFFSET+0x00048038,0x000001FF

#define IPU_DI1_SW_GEN1_4__ADDR                           IPU_REGISTERS_OFFSET+0x0004803C
#define IPU_DI1_SW_GEN1_4__EMPTY                          IPU_REGISTERS_OFFSET+0x0004803C,0x00000000
#define IPU_DI1_SW_GEN1_4__FULL                           IPU_REGISTERS_OFFSET+0x0004803C,0xffffffff
#define IPU_DI1_SW_GEN1_4__DI1_CNT_POLARITY_GEN_EN_4      IPU_REGISTERS_OFFSET+0x0004803C,0x60000000
#define IPU_DI1_SW_GEN1_4__DI1_CNT_AUTO_RELOAD_4          IPU_REGISTERS_OFFSET+0x0004803C,0x10000000
#define IPU_DI1_SW_GEN1_4__DI1_CNT_CLR_SEL_4              IPU_REGISTERS_OFFSET+0x0004803C,0x0E000000
#define IPU_DI1_SW_GEN1_4__DI1_CNT_DOWN_4                 IPU_REGISTERS_OFFSET+0x0004803C,0x01FF0000
#define IPU_DI1_SW_GEN1_4__DI1_CNT_POLARITY_TRIGGER_SEL_4 IPU_REGISTERS_OFFSET+0x0004803C,0x00007000
#define IPU_DI1_SW_GEN1_4__DI1_CNT_POLARITY_CLR_SEL_4     IPU_REGISTERS_OFFSET+0x0004803C,0x00000E00
#define IPU_DI1_SW_GEN1_4__DI1_CNT_UP_4                   IPU_REGISTERS_OFFSET+0x0004803C,0x000001FF

#define IPU_DI1_SW_GEN1_5__ADDR                           IPU_REGISTERS_OFFSET+0x00048040
#define IPU_DI1_SW_GEN1_5__EMPTY                          IPU_REGISTERS_OFFSET+0x00048040,0x00000000
#define IPU_DI1_SW_GEN1_5__FULL                           IPU_REGISTERS_OFFSET+0x00048040,0xffffffff
#define IPU_DI1_SW_GEN1_5__DI1_CNT_POLARITY_GEN_EN_5      IPU_REGISTERS_OFFSET+0x00048040,0x60000000
#define IPU_DI1_SW_GEN1_5__DI1_CNT_AUTO_RELOAD_5          IPU_REGISTERS_OFFSET+0x00048040,0x10000000
#define IPU_DI1_SW_GEN1_5__DI1_CNT_CLR_SEL_5              IPU_REGISTERS_OFFSET+0x00048040,0x0E000000
#define IPU_DI1_SW_GEN1_5__DI1_CNT_DOWN_5                 IPU_REGISTERS_OFFSET+0x00048040,0x01FF0000
#define IPU_DI1_SW_GEN1_5__DI1_CNT_POLARITY_TRIGGER_SEL_5 IPU_REGISTERS_OFFSET+0x00048040,0x00007000
#define IPU_DI1_SW_GEN1_5__DI1_CNT_POLARITY_CLR_SEL_5     IPU_REGISTERS_OFFSET+0x00048040,0x00000E00
#define IPU_DI1_SW_GEN1_5__DI1_CNT_UP_5                   IPU_REGISTERS_OFFSET+0x00048040,0x000001FF

#define IPU_DI1_SW_GEN1_6__ADDR                           IPU_REGISTERS_OFFSET+0x00048044
#define IPU_DI1_SW_GEN1_6__EMPTY                          IPU_REGISTERS_OFFSET+0x00048044,0x00000000
#define IPU_DI1_SW_GEN1_6__FULL                           IPU_REGISTERS_OFFSET+0x00048044,0xffffffff
#define IPU_DI1_SW_GEN1_6__DI1_CNT_POLARITY_GEN_EN_6      IPU_REGISTERS_OFFSET+0x00048044,0x60000000
#define IPU_DI1_SW_GEN1_6__DI1_CNT_AUTO_RELOAD_6          IPU_REGISTERS_OFFSET+0x00048044,0x10000000
#define IPU_DI1_SW_GEN1_6__DI1_CNT_CLR_SEL_6              IPU_REGISTERS_OFFSET+0x00048044,0x0E000000
#define IPU_DI1_SW_GEN1_6__DI1_CNT_DOWN_6                 IPU_REGISTERS_OFFSET+0x00048044,0x01FF0000
#define IPU_DI1_SW_GEN1_6__DI1_CNT_POLARITY_TRIGGER_SEL_6 IPU_REGISTERS_OFFSET+0x00048044,0x00007000
#define IPU_DI1_SW_GEN1_6__DI1_CNT_POLARITY_CLR_SEL_6     IPU_REGISTERS_OFFSET+0x00048044,0x00000E00
#define IPU_DI1_SW_GEN1_6__DI1_CNT_UP_6                   IPU_REGISTERS_OFFSET+0x00048044,0x000001FF

#define IPU_DI1_SW_GEN1_7__ADDR                           IPU_REGISTERS_OFFSET+0x00048048
#define IPU_DI1_SW_GEN1_7__EMPTY                          IPU_REGISTERS_OFFSET+0x00048048,0x00000000
#define IPU_DI1_SW_GEN1_7__FULL                           IPU_REGISTERS_OFFSET+0x00048048,0xffffffff
#define IPU_DI1_SW_GEN1_7__DI1_CNT_POLARITY_GEN_EN_7      IPU_REGISTERS_OFFSET+0x00048048,0x60000000
#define IPU_DI1_SW_GEN1_7__DI1_CNT_AUTO_RELOAD_7          IPU_REGISTERS_OFFSET+0x00048048,0x10000000
#define IPU_DI1_SW_GEN1_7__DI1_CNT_CLR_SEL_7              IPU_REGISTERS_OFFSET+0x00048048,0x0E000000
#define IPU_DI1_SW_GEN1_7__DI1_CNT_DOWN_7                 IPU_REGISTERS_OFFSET+0x00048048,0x01FF0000
#define IPU_DI1_SW_GEN1_7__DI1_CNT_POLARITY_TRIGGER_SEL_7 IPU_REGISTERS_OFFSET+0x00048048,0x00007000
#define IPU_DI1_SW_GEN1_7__DI1_CNT_POLARITY_CLR_SEL_7     IPU_REGISTERS_OFFSET+0x00048048,0x00000E00
#define IPU_DI1_SW_GEN1_7__DI1_CNT_UP_7                   IPU_REGISTERS_OFFSET+0x00048048,0x000001FF

#define IPU_DI1_SW_GEN1_8__ADDR                           IPU_REGISTERS_OFFSET+0x0004804C
#define IPU_DI1_SW_GEN1_8__EMPTY                          IPU_REGISTERS_OFFSET+0x0004804C,0x00000000
#define IPU_DI1_SW_GEN1_8__FULL                           IPU_REGISTERS_OFFSET+0x0004804C,0xffffffff
#define IPU_DI1_SW_GEN1_8__DI1_CNT_POLARITY_GEN_EN_8      IPU_REGISTERS_OFFSET+0x0004804C,0x60000000
#define IPU_DI1_SW_GEN1_8__DI1_CNT_AUTO_RELOAD_8          IPU_REGISTERS_OFFSET+0x0004804C,0x10000000
#define IPU_DI1_SW_GEN1_8__DI1_CNT_CLR_SEL_8              IPU_REGISTERS_OFFSET+0x0004804C,0x0E000000
#define IPU_DI1_SW_GEN1_8__DI1_CNT_DOWN_8                 IPU_REGISTERS_OFFSET+0x0004804C,0x01FF0000
#define IPU_DI1_SW_GEN1_8__DI1_CNT_POLARITY_TRIGGER_SEL_8 IPU_REGISTERS_OFFSET+0x0004804C,0x00007000
#define IPU_DI1_SW_GEN1_8__DI1_CNT_POLARITY_CLR_SEL_8     IPU_REGISTERS_OFFSET+0x0004804C,0x00000E00
#define IPU_DI1_SW_GEN1_8__DI1_CNT_UP_8                   IPU_REGISTERS_OFFSET+0x0004804C,0x000001FF

#define IPU_DI1_SW_GEN1_9__ADDR                  IPU_REGISTERS_OFFSET+0x00048050
#define IPU_DI1_SW_GEN1_9__EMPTY                 IPU_REGISTERS_OFFSET+0x00048050,0x00000000
#define IPU_DI1_SW_GEN1_9__FULL                  IPU_REGISTERS_OFFSET+0x00048050,0xffffffff
#define IPU_DI1_SW_GEN1_9__DI1_GENTIME_SEL_9     IPU_REGISTERS_OFFSET+0x00048050,0xE0000000
#define IPU_DI1_SW_GEN1_9__DI1_CNT_AUTO_RELOAD_9 IPU_REGISTERS_OFFSET+0x00048050,0x10000000
#define IPU_DI1_SW_GEN1_9__DI1_CNT_CLR_SEL_9     IPU_REGISTERS_OFFSET+0x00048050,0x0E000000
#define IPU_DI1_SW_GEN1_9__DI1_CNT_DOWN_9        IPU_REGISTERS_OFFSET+0x00048050,0x01FF0000
#define IPU_DI1_SW_GEN1_9__DI1_TAG_SEL_9         IPU_REGISTERS_OFFSET+0x00048050,0x00008000
#define IPU_DI1_SW_GEN1_9__DI1_CNT_UP_9          IPU_REGISTERS_OFFSET+0x00048050,0x000001FF

#define IPU_DI1_SYNC_AS_GEN__ADDR              IPU_REGISTERS_OFFSET+0x00048054
#define IPU_DI1_SYNC_AS_GEN__EMPTY             IPU_REGISTERS_OFFSET+0x00048054,0x00000000
#define IPU_DI1_SYNC_AS_GEN__FULL              IPU_REGISTERS_OFFSET+0x00048054,0xffffffff
#define IPU_DI1_SYNC_AS_GEN__DI1_SYNC_START_EN IPU_REGISTERS_OFFSET+0x00048054,0x10000000
#define IPU_DI1_SYNC_AS_GEN__DI1_VSYNC_SEL     IPU_REGISTERS_OFFSET+0x00048054,0x0000E000
#define IPU_DI1_SYNC_AS_GEN__DI1_SYNC_START    IPU_REGISTERS_OFFSET+0x00048054,0x00000FFF

#define IPU_DI1_DW_GEN_0__ADDR                  IPU_REGISTERS_OFFSET+0x00048058
#define IPU_DI1_DW_GEN_0__EMPTY                 IPU_REGISTERS_OFFSET+0x00048058,0x00000000
#define IPU_DI1_DW_GEN_0__FULL                  IPU_REGISTERS_OFFSET+0x00048058,0xffffffff
#define IPU_DI1_DW_GEN_0__DI1_ACCESS_SIZE_0     IPU_REGISTERS_OFFSET+0x00048058,0xFF000000
#define IPU_DI1_DW_GEN_0__DI1_COMPONNENT_SIZE_0 IPU_REGISTERS_OFFSET+0x00048058,0x00FF0000
#define IPU_DI1_DW_GEN_0__DI1_CST_0             IPU_REGISTERS_OFFSET+0x00048058,0x0000C000
#define IPU_DI1_DW_GEN_0__DI1_PT_6_0            IPU_REGISTERS_OFFSET+0x00048058,0x00003000
#define IPU_DI1_DW_GEN_0__DI1_PT_5_0            IPU_REGISTERS_OFFSET+0x00048058,0x00000C00
#define IPU_DI1_DW_GEN_0__DI1_PT_4_0            IPU_REGISTERS_OFFSET+0x00048058,0x00000300
#define IPU_DI1_DW_GEN_0__DI1_PT_3_0            IPU_REGISTERS_OFFSET+0x00048058,0x000000C0
#define IPU_DI1_DW_GEN_0__DI1_PT_2_0            IPU_REGISTERS_OFFSET+0x00048058,0x00000030
#define IPU_DI1_DW_GEN_0__DI1_PT_1_0            IPU_REGISTERS_OFFSET+0x00048058,0x0000000C
#define IPU_DI1_DW_GEN_0__DI1_PT_0_0            IPU_REGISTERS_OFFSET+0x00048058,0x00000003

#define IPU_DI1_DW_GEN_1__ADDR                  IPU_REGISTERS_OFFSET+0x0004805C
#define IPU_DI1_DW_GEN_1__EMPTY                 IPU_REGISTERS_OFFSET+0x0004805C,0x00000000
#define IPU_DI1_DW_GEN_1__FULL                  IPU_REGISTERS_OFFSET+0x0004805C,0xffffffff
#define IPU_DI1_DW_GEN_1__DI1_ACCESS_SIZE_1     IPU_REGISTERS_OFFSET+0x0004805C,0xFF000000
#define IPU_DI1_DW_GEN_1__DI1_COMPONNENT_SIZE_1 IPU_REGISTERS_OFFSET+0x0004805C,0x00FF0000
#define IPU_DI1_DW_GEN_1__DI1_CST_1             IPU_REGISTERS_OFFSET+0x0004805C,0x0000C000
#define IPU_DI1_DW_GEN_1__DI1_PT_6_1            IPU_REGISTERS_OFFSET+0x0004805C,0x00003000
#define IPU_DI1_DW_GEN_1__DI1_PT_5_1            IPU_REGISTERS_OFFSET+0x0004805C,0x00000C00
#define IPU_DI1_DW_GEN_1__DI1_PT_4_1            IPU_REGISTERS_OFFSET+0x0004805C,0x00000300
#define IPU_DI1_DW_GEN_1__DI1_PT_3_1            IPU_REGISTERS_OFFSET+0x0004805C,0x000000C0
#define IPU_DI1_DW_GEN_1__DI1_PT_2_1            IPU_REGISTERS_OFFSET+0x0004805C,0x00000030
#define IPU_DI1_DW_GEN_1__DI1_PT_1_1            IPU_REGISTERS_OFFSET+0x0004805C,0x0000000C
#define IPU_DI1_DW_GEN_1__DI1_PT_0_1            IPU_REGISTERS_OFFSET+0x0004805C,0x00000003

#define IPU_DI1_DW_GEN_2__ADDR                  IPU_REGISTERS_OFFSET+0x00048060
#define IPU_DI1_DW_GEN_2__EMPTY                 IPU_REGISTERS_OFFSET+0x00048060,0x00000000
#define IPU_DI1_DW_GEN_2__FULL                  IPU_REGISTERS_OFFSET+0x00048060,0xffffffff
#define IPU_DI1_DW_GEN_2__DI1_ACCESS_SIZE_2     IPU_REGISTERS_OFFSET+0x00048060,0xFF000000
#define IPU_DI1_DW_GEN_2__DI1_COMPONNENT_SIZE_2 IPU_REGISTERS_OFFSET+0x00048060,0x00FF0000
#define IPU_DI1_DW_GEN_2__DI1_CST_2             IPU_REGISTERS_OFFSET+0x00048060,0x0000C000
#define IPU_DI1_DW_GEN_2__DI1_PT_6_2            IPU_REGISTERS_OFFSET+0x00048060,0x00003000
#define IPU_DI1_DW_GEN_2__DI1_PT_5_2            IPU_REGISTERS_OFFSET+0x00048060,0x00000C00
#define IPU_DI1_DW_GEN_2__DI1_PT_4_2            IPU_REGISTERS_OFFSET+0x00048060,0x00000300
#define IPU_DI1_DW_GEN_2__DI1_PT_3_2            IPU_REGISTERS_OFFSET+0x00048060,0x000000C0
#define IPU_DI1_DW_GEN_2__DI1_PT_2_2            IPU_REGISTERS_OFFSET+0x00048060,0x00000030
#define IPU_DI1_DW_GEN_2__DI1_PT_1_2            IPU_REGISTERS_OFFSET+0x00048060,0x0000000C
#define IPU_DI1_DW_GEN_2__DI1_PT_0_2            IPU_REGISTERS_OFFSET+0x00048060,0x00000003

#define IPU_DI1_DW_GEN_3__ADDR                  IPU_REGISTERS_OFFSET+0x00048064
#define IPU_DI1_DW_GEN_3__EMPTY                 IPU_REGISTERS_OFFSET+0x00048064,0x00000000
#define IPU_DI1_DW_GEN_3__FULL                  IPU_REGISTERS_OFFSET+0x00048064,0xffffffff
#define IPU_DI1_DW_GEN_3__DI1_ACCESS_SIZE_3     IPU_REGISTERS_OFFSET+0x00048064,0xFF000000
#define IPU_DI1_DW_GEN_3__DI1_COMPONNENT_SIZE_3 IPU_REGISTERS_OFFSET+0x00048064,0x00FF0000
#define IPU_DI1_DW_GEN_3__DI1_CST_3             IPU_REGISTERS_OFFSET+0x00048064,0x0000C000
#define IPU_DI1_DW_GEN_3__DI1_PT_6_3            IPU_REGISTERS_OFFSET+0x00048064,0x00003000
#define IPU_DI1_DW_GEN_3__DI1_PT_5_3            IPU_REGISTERS_OFFSET+0x00048064,0x00000C00
#define IPU_DI1_DW_GEN_3__DI1_PT_4_3            IPU_REGISTERS_OFFSET+0x00048064,0x00000300
#define IPU_DI1_DW_GEN_3__DI1_PT_3_3            IPU_REGISTERS_OFFSET+0x00048064,0x000000C0
#define IPU_DI1_DW_GEN_3__DI1_PT_2_3            IPU_REGISTERS_OFFSET+0x00048064,0x00000030
#define IPU_DI1_DW_GEN_3__DI1_PT_1_3            IPU_REGISTERS_OFFSET+0x00048064,0x0000000C
#define IPU_DI1_DW_GEN_3__DI1_PT_0_3            IPU_REGISTERS_OFFSET+0x00048064,0x00000003

#define IPU_DI1_DW_GEN_4__ADDR                  IPU_REGISTERS_OFFSET+0x00048068
#define IPU_DI1_DW_GEN_4__EMPTY                 IPU_REGISTERS_OFFSET+0x00048068,0x00000000
#define IPU_DI1_DW_GEN_4__FULL                  IPU_REGISTERS_OFFSET+0x00048068,0xffffffff
#define IPU_DI1_DW_GEN_4__DI1_ACCESS_SIZE_4     IPU_REGISTERS_OFFSET+0x00048068,0xFF000000
#define IPU_DI1_DW_GEN_4__DI1_COMPONNENT_SIZE_4 IPU_REGISTERS_OFFSET+0x00048068,0x00FF0000
#define IPU_DI1_DW_GEN_4__DI1_CST_4             IPU_REGISTERS_OFFSET+0x00048068,0x0000C000
#define IPU_DI1_DW_GEN_4__DI1_PT_6_4            IPU_REGISTERS_OFFSET+0x00048068,0x00003000
#define IPU_DI1_DW_GEN_4__DI1_PT_5_4            IPU_REGISTERS_OFFSET+0x00048068,0x00000C00
#define IPU_DI1_DW_GEN_4__DI1_PT_4_4            IPU_REGISTERS_OFFSET+0x00048068,0x00000300
#define IPU_DI1_DW_GEN_4__DI1_PT_3_4            IPU_REGISTERS_OFFSET+0x00048068,0x000000C0
#define IPU_DI1_DW_GEN_4__DI1_PT_2_4            IPU_REGISTERS_OFFSET+0x00048068,0x00000030
#define IPU_DI1_DW_GEN_4__DI1_PT_1_4            IPU_REGISTERS_OFFSET+0x00048068,0x0000000C
#define IPU_DI1_DW_GEN_4__DI1_PT_0_4            IPU_REGISTERS_OFFSET+0x00048068,0x00000003

#define IPU_DI1_DW_GEN_5__ADDR                  IPU_REGISTERS_OFFSET+0x0004806C
#define IPU_DI1_DW_GEN_5__EMPTY                 IPU_REGISTERS_OFFSET+0x0004806C,0x00000000
#define IPU_DI1_DW_GEN_5__FULL                  IPU_REGISTERS_OFFSET+0x0004806C,0xffffffff
#define IPU_DI1_DW_GEN_5__DI1_ACCESS_SIZE_5     IPU_REGISTERS_OFFSET+0x0004806C,0xFF000000
#define IPU_DI1_DW_GEN_5__DI1_COMPONNENT_SIZE_5 IPU_REGISTERS_OFFSET+0x0004806C,0x00FF0000
#define IPU_DI1_DW_GEN_5__DI1_CST_5             IPU_REGISTERS_OFFSET+0x0004806C,0x0000C000
#define IPU_DI1_DW_GEN_5__DI1_PT_6_5            IPU_REGISTERS_OFFSET+0x0004806C,0x00003000
#define IPU_DI1_DW_GEN_5__DI1_PT_5_5            IPU_REGISTERS_OFFSET+0x0004806C,0x00000C00
#define IPU_DI1_DW_GEN_5__DI1_PT_4_5            IPU_REGISTERS_OFFSET+0x0004806C,0x00000300
#define IPU_DI1_DW_GEN_5__DI1_PT_3_5            IPU_REGISTERS_OFFSET+0x0004806C,0x000000C0
#define IPU_DI1_DW_GEN_5__DI1_PT_2_5            IPU_REGISTERS_OFFSET+0x0004806C,0x00000030
#define IPU_DI1_DW_GEN_5__DI1_PT_1_5            IPU_REGISTERS_OFFSET+0x0004806C,0x0000000C
#define IPU_DI1_DW_GEN_5__DI1_PT_0_5            IPU_REGISTERS_OFFSET+0x0004806C,0x00000003

#define IPU_DI1_DW_GEN_6__ADDR                  IPU_REGISTERS_OFFSET+0x00048070
#define IPU_DI1_DW_GEN_6__EMPTY                 IPU_REGISTERS_OFFSET+0x00048070,0x00000000
#define IPU_DI1_DW_GEN_6__FULL                  IPU_REGISTERS_OFFSET+0x00048070,0xffffffff
#define IPU_DI1_DW_GEN_6__DI1_ACCESS_SIZE_6     IPU_REGISTERS_OFFSET+0x00048070,0xFF000000
#define IPU_DI1_DW_GEN_6__DI1_COMPONNENT_SIZE_6 IPU_REGISTERS_OFFSET+0x00048070,0x00FF0000
#define IPU_DI1_DW_GEN_6__DI1_CST_6             IPU_REGISTERS_OFFSET+0x00048070,0x0000C000
#define IPU_DI1_DW_GEN_6__DI1_PT_6_6            IPU_REGISTERS_OFFSET+0x00048070,0x00003000
#define IPU_DI1_DW_GEN_6__DI1_PT_5_6            IPU_REGISTERS_OFFSET+0x00048070,0x00000C00
#define IPU_DI1_DW_GEN_6__DI1_PT_4_6            IPU_REGISTERS_OFFSET+0x00048070,0x00000300
#define IPU_DI1_DW_GEN_6__DI1_PT_3_6            IPU_REGISTERS_OFFSET+0x00048070,0x000000C0
#define IPU_DI1_DW_GEN_6__DI1_PT_2_6            IPU_REGISTERS_OFFSET+0x00048070,0x00000030
#define IPU_DI1_DW_GEN_6__DI1_PT_1_6            IPU_REGISTERS_OFFSET+0x00048070,0x0000000C
#define IPU_DI1_DW_GEN_6__DI1_PT_0_6            IPU_REGISTERS_OFFSET+0x00048070,0x00000003

#define IPU_DI1_DW_GEN_7__ADDR                  IPU_REGISTERS_OFFSET+0x00048074
#define IPU_DI1_DW_GEN_7__EMPTY                 IPU_REGISTERS_OFFSET+0x00048074,0x00000000
#define IPU_DI1_DW_GEN_7__FULL                  IPU_REGISTERS_OFFSET+0x00048074,0xffffffff
#define IPU_DI1_DW_GEN_7__DI1_ACCESS_SIZE_7     IPU_REGISTERS_OFFSET+0x00048074,0xFF000000
#define IPU_DI1_DW_GEN_7__DI1_COMPONNENT_SIZE_7 IPU_REGISTERS_OFFSET+0x00048074,0x00FF0000
#define IPU_DI1_DW_GEN_7__DI1_CST_7             IPU_REGISTERS_OFFSET+0x00048074,0x0000C000
#define IPU_DI1_DW_GEN_7__DI1_PT_6_7            IPU_REGISTERS_OFFSET+0x00048074,0x00003000
#define IPU_DI1_DW_GEN_7__DI1_PT_5_7            IPU_REGISTERS_OFFSET+0x00048074,0x00000C00
#define IPU_DI1_DW_GEN_7__DI1_PT_4_7            IPU_REGISTERS_OFFSET+0x00048074,0x00000300
#define IPU_DI1_DW_GEN_7__DI1_PT_3_7            IPU_REGISTERS_OFFSET+0x00048074,0x000000C0
#define IPU_DI1_DW_GEN_7__DI1_PT_2_7            IPU_REGISTERS_OFFSET+0x00048074,0x00000030
#define IPU_DI1_DW_GEN_7__DI1_PT_1_7            IPU_REGISTERS_OFFSET+0x00048074,0x0000000C
#define IPU_DI1_DW_GEN_7__DI1_PT_0_7            IPU_REGISTERS_OFFSET+0x00048074,0x00000003

#define IPU_DI1_DW_GEN_8__ADDR                  IPU_REGISTERS_OFFSET+0x00048078
#define IPU_DI1_DW_GEN_8__EMPTY                 IPU_REGISTERS_OFFSET+0x00048078,0x00000000
#define IPU_DI1_DW_GEN_8__FULL                  IPU_REGISTERS_OFFSET+0x00048078,0xffffffff
#define IPU_DI1_DW_GEN_8__DI1_ACCESS_SIZE_8     IPU_REGISTERS_OFFSET+0x00048078,0xFF000000
#define IPU_DI1_DW_GEN_8__DI1_COMPONNENT_SIZE_8 IPU_REGISTERS_OFFSET+0x00048078,0x00FF0000
#define IPU_DI1_DW_GEN_8__DI1_CST_8             IPU_REGISTERS_OFFSET+0x00048078,0x0000C000
#define IPU_DI1_DW_GEN_8__DI1_PT_6_8            IPU_REGISTERS_OFFSET+0x00048078,0x00003000
#define IPU_DI1_DW_GEN_8__DI1_PT_5_8            IPU_REGISTERS_OFFSET+0x00048078,0x00000C00
#define IPU_DI1_DW_GEN_8__DI1_PT_4_8            IPU_REGISTERS_OFFSET+0x00048078,0x00000300
#define IPU_DI1_DW_GEN_8__DI1_PT_3_8            IPU_REGISTERS_OFFSET+0x00048078,0x000000C0
#define IPU_DI1_DW_GEN_8__DI1_PT_2_8            IPU_REGISTERS_OFFSET+0x00048078,0x00000030
#define IPU_DI1_DW_GEN_8__DI1_PT_1_8            IPU_REGISTERS_OFFSET+0x00048078,0x0000000C
#define IPU_DI1_DW_GEN_8__DI1_PT_0_8            IPU_REGISTERS_OFFSET+0x00048078,0x00000003

#define IPU_DI1_DW_GEN_9__ADDR                  IPU_REGISTERS_OFFSET+0x0004807C
#define IPU_DI1_DW_GEN_9__EMPTY                 IPU_REGISTERS_OFFSET+0x0004807C,0x00000000
#define IPU_DI1_DW_GEN_9__FULL                  IPU_REGISTERS_OFFSET+0x0004807C,0xffffffff
#define IPU_DI1_DW_GEN_9__DI1_ACCESS_SIZE_9     IPU_REGISTERS_OFFSET+0x0004807C,0xFF000000
#define IPU_DI1_DW_GEN_9__DI1_COMPONNENT_SIZE_9 IPU_REGISTERS_OFFSET+0x0004807C,0x00FF0000
#define IPU_DI1_DW_GEN_9__DI1_CST_9             IPU_REGISTERS_OFFSET+0x0004807C,0x0000C000
#define IPU_DI1_DW_GEN_9__DI1_PT_6_9            IPU_REGISTERS_OFFSET+0x0004807C,0x00003000
#define IPU_DI1_DW_GEN_9__DI1_PT_5_9            IPU_REGISTERS_OFFSET+0x0004807C,0x00000C00
#define IPU_DI1_DW_GEN_9__DI1_PT_4_9            IPU_REGISTERS_OFFSET+0x0004807C,0x00000300
#define IPU_DI1_DW_GEN_9__DI1_PT_3_9            IPU_REGISTERS_OFFSET+0x0004807C,0x000000C0
#define IPU_DI1_DW_GEN_9__DI1_PT_2_9            IPU_REGISTERS_OFFSET+0x0004807C,0x00000030
#define IPU_DI1_DW_GEN_9__DI1_PT_1_9            IPU_REGISTERS_OFFSET+0x0004807C,0x0000000C
#define IPU_DI1_DW_GEN_9__DI1_PT_0_9            IPU_REGISTERS_OFFSET+0x0004807C,0x00000003

#define IPU_DI1_DW_GEN_10__ADDR                   IPU_REGISTERS_OFFSET+0x00048080
#define IPU_DI1_DW_GEN_10__EMPTY                  IPU_REGISTERS_OFFSET+0x00048080,0x00000000
#define IPU_DI1_DW_GEN_10__FULL                   IPU_REGISTERS_OFFSET+0x00048080,0xffffffff
#define IPU_DI1_DW_GEN_10__DI1_ACCESS_SIZE_10     IPU_REGISTERS_OFFSET+0x00048080,0xFF000000
#define IPU_DI1_DW_GEN_10__DI1_COMPONNENT_SIZE_10 IPU_REGISTERS_OFFSET+0x00048080,0x00FF0000
#define IPU_DI1_DW_GEN_10__DI1_CST_10             IPU_REGISTERS_OFFSET+0x00048080,0x0000C000
#define IPU_DI1_DW_GEN_10__DI1_PT_6_10            IPU_REGISTERS_OFFSET+0x00048080,0x00003000
#define IPU_DI1_DW_GEN_10__DI1_PT_5_10            IPU_REGISTERS_OFFSET+0x00048080,0x00000C00
#define IPU_DI1_DW_GEN_10__DI1_PT_4_10            IPU_REGISTERS_OFFSET+0x00048080,0x00000300
#define IPU_DI1_DW_GEN_10__DI1_PT_3_10            IPU_REGISTERS_OFFSET+0x00048080,0x000000C0
#define IPU_DI1_DW_GEN_10__DI1_PT_2_10            IPU_REGISTERS_OFFSET+0x00048080,0x00000030
#define IPU_DI1_DW_GEN_10__DI1_PT_1_10            IPU_REGISTERS_OFFSET+0x00048080,0x0000000C
#define IPU_DI1_DW_GEN_10__DI1_PT_0_10            IPU_REGISTERS_OFFSET+0x00048080,0x00000003

#define IPU_DI1_DW_GEN_11__ADDR                   IPU_REGISTERS_OFFSET+0x00048084
#define IPU_DI1_DW_GEN_11__EMPTY                  IPU_REGISTERS_OFFSET+0x00048084,0x00000000
#define IPU_DI1_DW_GEN_11__FULL                   IPU_REGISTERS_OFFSET+0x00048084,0xffffffff
#define IPU_DI1_DW_GEN_11__DI1_ACCESS_SIZE_11     IPU_REGISTERS_OFFSET+0x00048084,0xFF000000
#define IPU_DI1_DW_GEN_11__DI1_COMPONNENT_SIZE_11 IPU_REGISTERS_OFFSET+0x00048084,0x00FF0000
#define IPU_DI1_DW_GEN_11__DI1_CST_11             IPU_REGISTERS_OFFSET+0x00048084,0x0000C000
#define IPU_DI1_DW_GEN_11__DI1_PT_6_11            IPU_REGISTERS_OFFSET+0x00048084,0x00003000
#define IPU_DI1_DW_GEN_11__DI1_PT_5_11            IPU_REGISTERS_OFFSET+0x00048084,0x00000C00
#define IPU_DI1_DW_GEN_11__DI1_PT_4_11            IPU_REGISTERS_OFFSET+0x00048084,0x00000300
#define IPU_DI1_DW_GEN_11__DI1_PT_3_11            IPU_REGISTERS_OFFSET+0x00048084,0x000000C0
#define IPU_DI1_DW_GEN_11__DI1_PT_2_11            IPU_REGISTERS_OFFSET+0x00048084,0x00000030
#define IPU_DI1_DW_GEN_11__DI1_PT_1_11            IPU_REGISTERS_OFFSET+0x00048084,0x0000000C
#define IPU_DI1_DW_GEN_11__DI1_PT_0_11            IPU_REGISTERS_OFFSET+0x00048084,0x00000003

#define IPU_DI1_DW_SET0_0__ADDR                 IPU_REGISTERS_OFFSET+0x00048088
#define IPU_DI1_DW_SET0_0__EMPTY                IPU_REGISTERS_OFFSET+0x00048088,0x00000000
#define IPU_DI1_DW_SET0_0__FULL                 IPU_REGISTERS_OFFSET+0x00048088,0xffffffff
#define IPU_DI1_DW_SET0_0__DI1_DATA_CNT_DOWN0_0 IPU_REGISTERS_OFFSET+0x00048088,0x01FF0000
#define IPU_DI1_DW_SET0_0__DI1_DATA_CNT_UP0_0   IPU_REGISTERS_OFFSET+0x00048088,0x000001FF

#define IPU_DI1_DW_SET0_1__ADDR                 IPU_REGISTERS_OFFSET+0x0004808C
#define IPU_DI1_DW_SET0_1__EMPTY                IPU_REGISTERS_OFFSET+0x0004808C,0x00000000
#define IPU_DI1_DW_SET0_1__FULL                 IPU_REGISTERS_OFFSET+0x0004808C,0xffffffff
#define IPU_DI1_DW_SET0_1__DI1_DATA_CNT_DOWN0_1 IPU_REGISTERS_OFFSET+0x0004808C,0x01FF0000
#define IPU_DI1_DW_SET0_1__DI1_DATA_CNT_UP0_1   IPU_REGISTERS_OFFSET+0x0004808C,0x000001FF

#define IPU_DI1_DW_SET0_2__ADDR                 IPU_REGISTERS_OFFSET+0x00048090
#define IPU_DI1_DW_SET0_2__EMPTY                IPU_REGISTERS_OFFSET+0x00048090,0x00000000
#define IPU_DI1_DW_SET0_2__FULL                 IPU_REGISTERS_OFFSET+0x00048090,0xffffffff
#define IPU_DI1_DW_SET0_2__DI1_DATA_CNT_DOWN0_2 IPU_REGISTERS_OFFSET+0x00048090,0x01FF0000
#define IPU_DI1_DW_SET0_2__DI1_DATA_CNT_UP0_2   IPU_REGISTERS_OFFSET+0x00048090,0x000001FF

#define IPU_DI1_DW_SET0_3__ADDR                 IPU_REGISTERS_OFFSET+0x00048094
#define IPU_DI1_DW_SET0_3__EMPTY                IPU_REGISTERS_OFFSET+0x00048094,0x00000000
#define IPU_DI1_DW_SET0_3__FULL                 IPU_REGISTERS_OFFSET+0x00048094,0xffffffff
#define IPU_DI1_DW_SET0_3__DI1_DATA_CNT_DOWN0_3 IPU_REGISTERS_OFFSET+0x00048094,0x01FF0000
#define IPU_DI1_DW_SET0_3__DI1_DATA_CNT_UP0_3   IPU_REGISTERS_OFFSET+0x00048094,0x000001FF

#define IPU_DI1_DW_SET0_4__ADDR                 IPU_REGISTERS_OFFSET+0x00048098
#define IPU_DI1_DW_SET0_4__EMPTY                IPU_REGISTERS_OFFSET+0x00048098,0x00000000
#define IPU_DI1_DW_SET0_4__FULL                 IPU_REGISTERS_OFFSET+0x00048098,0xffffffff
#define IPU_DI1_DW_SET0_4__DI1_DATA_CNT_DOWN0_4 IPU_REGISTERS_OFFSET+0x00048098,0x01FF0000
#define IPU_DI1_DW_SET0_4__DI1_DATA_CNT_UP0_4   IPU_REGISTERS_OFFSET+0x00048098,0x000001FF

#define IPU_DI1_DW_SET0_5__ADDR                 IPU_REGISTERS_OFFSET+0x0004809C
#define IPU_DI1_DW_SET0_5__EMPTY                IPU_REGISTERS_OFFSET+0x0004809C,0x00000000
#define IPU_DI1_DW_SET0_5__FULL                 IPU_REGISTERS_OFFSET+0x0004809C,0xffffffff
#define IPU_DI1_DW_SET0_5__DI1_DATA_CNT_DOWN0_5 IPU_REGISTERS_OFFSET+0x0004809C,0x01FF0000
#define IPU_DI1_DW_SET0_5__DI1_DATA_CNT_UP0_5   IPU_REGISTERS_OFFSET+0x0004809C,0x000001FF

#define IPU_DI1_DW_SET0_6__ADDR                 IPU_REGISTERS_OFFSET+0x000480A0
#define IPU_DI1_DW_SET0_6__EMPTY                IPU_REGISTERS_OFFSET+0x000480A0,0x00000000
#define IPU_DI1_DW_SET0_6__FULL                 IPU_REGISTERS_OFFSET+0x000480A0,0xffffffff
#define IPU_DI1_DW_SET0_6__DI1_DATA_CNT_DOWN0_6 IPU_REGISTERS_OFFSET+0x000480A0,0x01FF0000
#define IPU_DI1_DW_SET0_6__DI1_DATA_CNT_UP0_6   IPU_REGISTERS_OFFSET+0x000480A0,0x000001FF

#define IPU_DI1_DW_SET0_7__ADDR                 IPU_REGISTERS_OFFSET+0x000480A4
#define IPU_DI1_DW_SET0_7__EMPTY                IPU_REGISTERS_OFFSET+0x000480A4,0x00000000
#define IPU_DI1_DW_SET0_7__FULL                 IPU_REGISTERS_OFFSET+0x000480A4,0xffffffff
#define IPU_DI1_DW_SET0_7__DI1_DATA_CNT_DOWN0_7 IPU_REGISTERS_OFFSET+0x000480A4,0x01FF0000
#define IPU_DI1_DW_SET0_7__DI1_DATA_CNT_UP0_7   IPU_REGISTERS_OFFSET+0x000480A4,0x000001FF

#define IPU_DI1_DW_SET0_8__ADDR                 IPU_REGISTERS_OFFSET+0x000480A8
#define IPU_DI1_DW_SET0_8__EMPTY                IPU_REGISTERS_OFFSET+0x000480A8,0x00000000
#define IPU_DI1_DW_SET0_8__FULL                 IPU_REGISTERS_OFFSET+0x000480A8,0xffffffff
#define IPU_DI1_DW_SET0_8__DI1_DATA_CNT_DOWN0_8 IPU_REGISTERS_OFFSET+0x000480A8,0x01FF0000
#define IPU_DI1_DW_SET0_8__DI1_DATA_CNT_UP0_8   IPU_REGISTERS_OFFSET+0x000480A8,0x000001FF

#define IPU_DI1_DW_SET0_9__ADDR                 IPU_REGISTERS_OFFSET+0x000480AC
#define IPU_DI1_DW_SET0_9__EMPTY                IPU_REGISTERS_OFFSET+0x000480AC,0x00000000
#define IPU_DI1_DW_SET0_9__FULL                 IPU_REGISTERS_OFFSET+0x000480AC,0xffffffff
#define IPU_DI1_DW_SET0_9__DI1_DATA_CNT_DOWN0_9 IPU_REGISTERS_OFFSET+0x000480AC,0x01FF0000
#define IPU_DI1_DW_SET0_9__DI1_DATA_CNT_UP0_9   IPU_REGISTERS_OFFSET+0x000480AC,0x000001FF

#define IPU_DI1_DW_SET0_10__ADDR                  IPU_REGISTERS_OFFSET+0x000480B0
#define IPU_DI1_DW_SET0_10__EMPTY                 IPU_REGISTERS_OFFSET+0x000480B0,0x00000000
#define IPU_DI1_DW_SET0_10__FULL                  IPU_REGISTERS_OFFSET+0x000480B0,0xffffffff
#define IPU_DI1_DW_SET0_10__DI1_DATA_CNT_DOWN0_10 IPU_REGISTERS_OFFSET+0x000480B0,0x01FF0000
#define IPU_DI1_DW_SET0_10__DI1_DATA_CNT_UP0_10   IPU_REGISTERS_OFFSET+0x000480B0,0x000001FF

#define IPU_DI1_DW_SET0_11__ADDR                  IPU_REGISTERS_OFFSET+0x000480B4
#define IPU_DI1_DW_SET0_11__EMPTY                 IPU_REGISTERS_OFFSET+0x000480B4,0x00000000
#define IPU_DI1_DW_SET0_11__FULL                  IPU_REGISTERS_OFFSET+0x000480B4,0xffffffff
#define IPU_DI1_DW_SET0_11__DI1_DATA_CNT_DOWN0_11 IPU_REGISTERS_OFFSET+0x000480B4,0x01FF0000
#define IPU_DI1_DW_SET0_11__DI1_DATA_CNT_UP0_11   IPU_REGISTERS_OFFSET+0x000480B4,0x000001FF

#define IPU_DI1_DW_SET1_0__ADDR                 IPU_REGISTERS_OFFSET+0x000480B8
#define IPU_DI1_DW_SET1_0__EMPTY                IPU_REGISTERS_OFFSET+0x000480B8,0x00000000
#define IPU_DI1_DW_SET1_0__FULL                 IPU_REGISTERS_OFFSET+0x000480B8,0xffffffff
#define IPU_DI1_DW_SET1_0__DI1_DATA_CNT_DOWN1_0 IPU_REGISTERS_OFFSET+0x000480B8,0x01FF0000
#define IPU_DI1_DW_SET1_0__DI1_DATA_CNT_UP1_0   IPU_REGISTERS_OFFSET+0x000480B8,0x000001FF

#define IPU_DI1_DW_SET1_1__ADDR                 IPU_REGISTERS_OFFSET+0x000480BC
#define IPU_DI1_DW_SET1_1__EMPTY                IPU_REGISTERS_OFFSET+0x000480BC,0x00000000
#define IPU_DI1_DW_SET1_1__FULL                 IPU_REGISTERS_OFFSET+0x000480BC,0xffffffff
#define IPU_DI1_DW_SET1_1__DI1_DATA_CNT_DOWN1_1 IPU_REGISTERS_OFFSET+0x000480BC,0x01FF0000
#define IPU_DI1_DW_SET1_1__DI1_DATA_CNT_UP1_1   IPU_REGISTERS_OFFSET+0x000480BC,0x000001FF

#define IPU_DI1_DW_SET1_2__ADDR                 IPU_REGISTERS_OFFSET+0x000480C0
#define IPU_DI1_DW_SET1_2__EMPTY                IPU_REGISTERS_OFFSET+0x000480C0,0x00000000
#define IPU_DI1_DW_SET1_2__FULL                 IPU_REGISTERS_OFFSET+0x000480C0,0xffffffff
#define IPU_DI1_DW_SET1_2__DI1_DATA_CNT_DOWN1_2 IPU_REGISTERS_OFFSET+0x000480C0,0x01FF0000
#define IPU_DI1_DW_SET1_2__DI1_DATA_CNT_UP1_2   IPU_REGISTERS_OFFSET+0x000480C0,0x000001FF

#define IPU_DI1_DW_SET1_3__ADDR                 IPU_REGISTERS_OFFSET+0x000480C4
#define IPU_DI1_DW_SET1_3__EMPTY                IPU_REGISTERS_OFFSET+0x000480C4,0x00000000
#define IPU_DI1_DW_SET1_3__FULL                 IPU_REGISTERS_OFFSET+0x000480C4,0xffffffff
#define IPU_DI1_DW_SET1_3__DI1_DATA_CNT_DOWN1_3 IPU_REGISTERS_OFFSET+0x000480C4,0x01FF0000
#define IPU_DI1_DW_SET1_3__DI1_DATA_CNT_UP1_3   IPU_REGISTERS_OFFSET+0x000480C4,0x000001FF

#define IPU_DI1_DW_SET1_4__ADDR                 IPU_REGISTERS_OFFSET+0x000480C8
#define IPU_DI1_DW_SET1_4__EMPTY                IPU_REGISTERS_OFFSET+0x000480C8,0x00000000
#define IPU_DI1_DW_SET1_4__FULL                 IPU_REGISTERS_OFFSET+0x000480C8,0xffffffff
#define IPU_DI1_DW_SET1_4__DI1_DATA_CNT_DOWN1_4 IPU_REGISTERS_OFFSET+0x000480C8,0x01FF0000
#define IPU_DI1_DW_SET1_4__DI1_DATA_CNT_UP1_4   IPU_REGISTERS_OFFSET+0x000480C8,0x000001FF

#define IPU_DI1_DW_SET1_5__ADDR                 IPU_REGISTERS_OFFSET+0x000480CC
#define IPU_DI1_DW_SET1_5__EMPTY                IPU_REGISTERS_OFFSET+0x000480CC,0x00000000
#define IPU_DI1_DW_SET1_5__FULL                 IPU_REGISTERS_OFFSET+0x000480CC,0xffffffff
#define IPU_DI1_DW_SET1_5__DI1_DATA_CNT_DOWN1_5 IPU_REGISTERS_OFFSET+0x000480CC,0x01FF0000
#define IPU_DI1_DW_SET1_5__DI1_DATA_CNT_UP1_5   IPU_REGISTERS_OFFSET+0x000480CC,0x000001FF

#define IPU_DI1_DW_SET1_6__ADDR                 IPU_REGISTERS_OFFSET+0x000480D0
#define IPU_DI1_DW_SET1_6__EMPTY                IPU_REGISTERS_OFFSET+0x000480D0,0x00000000
#define IPU_DI1_DW_SET1_6__FULL                 IPU_REGISTERS_OFFSET+0x000480D0,0xffffffff
#define IPU_DI1_DW_SET1_6__DI1_DATA_CNT_DOWN1_6 IPU_REGISTERS_OFFSET+0x000480D0,0x01FF0000
#define IPU_DI1_DW_SET1_6__DI1_DATA_CNT_UP1_6   IPU_REGISTERS_OFFSET+0x000480D0,0x000001FF

#define IPU_DI1_DW_SET1_7__ADDR                 IPU_REGISTERS_OFFSET+0x000480D4
#define IPU_DI1_DW_SET1_7__EMPTY                IPU_REGISTERS_OFFSET+0x000480D4,0x00000000
#define IPU_DI1_DW_SET1_7__FULL                 IPU_REGISTERS_OFFSET+0x000480D4,0xffffffff
#define IPU_DI1_DW_SET1_7__DI1_DATA_CNT_DOWN1_7 IPU_REGISTERS_OFFSET+0x000480D4,0x01FF0000
#define IPU_DI1_DW_SET1_7__DI1_DATA_CNT_UP1_7   IPU_REGISTERS_OFFSET+0x000480D4,0x000001FF

#define IPU_DI1_DW_SET1_8__ADDR                 IPU_REGISTERS_OFFSET+0x000480D8
#define IPU_DI1_DW_SET1_8__EMPTY                IPU_REGISTERS_OFFSET+0x000480D8,0x00000000
#define IPU_DI1_DW_SET1_8__FULL                 IPU_REGISTERS_OFFSET+0x000480D8,0xffffffff
#define IPU_DI1_DW_SET1_8__DI1_DATA_CNT_DOWN1_8 IPU_REGISTERS_OFFSET+0x000480D8,0x01FF0000
#define IPU_DI1_DW_SET1_8__DI1_DATA_CNT_UP1_8   IPU_REGISTERS_OFFSET+0x000480D8,0x000001FF

#define IPU_DI1_DW_SET1_9__ADDR                 IPU_REGISTERS_OFFSET+0x000480DC
#define IPU_DI1_DW_SET1_9__EMPTY                IPU_REGISTERS_OFFSET+0x000480DC,0x00000000
#define IPU_DI1_DW_SET1_9__FULL                 IPU_REGISTERS_OFFSET+0x000480DC,0xffffffff
#define IPU_DI1_DW_SET1_9__DI1_DATA_CNT_DOWN1_9 IPU_REGISTERS_OFFSET+0x000480DC,0x01FF0000
#define IPU_DI1_DW_SET1_9__DI1_DATA_CNT_UP1_9   IPU_REGISTERS_OFFSET+0x000480DC,0x000001FF

#define IPU_DI1_DW_SET1_10__ADDR                  IPU_REGISTERS_OFFSET+0x000480E0
#define IPU_DI1_DW_SET1_10__EMPTY                 IPU_REGISTERS_OFFSET+0x000480E0,0x00000000
#define IPU_DI1_DW_SET1_10__FULL                  IPU_REGISTERS_OFFSET+0x000480E0,0xffffffff
#define IPU_DI1_DW_SET1_10__DI1_DATA_CNT_DOWN1_10 IPU_REGISTERS_OFFSET+0x000480E0,0x01FF0000
#define IPU_DI1_DW_SET1_10__DI1_DATA_CNT_UP1_10   IPU_REGISTERS_OFFSET+0x000480E0,0x000001FF

#define IPU_DI1_DW_SET1_11__ADDR                  IPU_REGISTERS_OFFSET+0x000480E4
#define IPU_DI1_DW_SET1_11__EMPTY                 IPU_REGISTERS_OFFSET+0x000480E4,0x00000000
#define IPU_DI1_DW_SET1_11__FULL                  IPU_REGISTERS_OFFSET+0x000480E4,0xffffffff
#define IPU_DI1_DW_SET1_11__DI1_DATA_CNT_DOWN1_11 IPU_REGISTERS_OFFSET+0x000480E4,0x01FF0000
#define IPU_DI1_DW_SET1_11__DI1_DATA_CNT_UP1_11   IPU_REGISTERS_OFFSET+0x000480E4,0x000001FF

#define IPU_DI1_DW_SET2_0__ADDR                 IPU_REGISTERS_OFFSET+0x000480E8
#define IPU_DI1_DW_SET2_0__EMPTY                IPU_REGISTERS_OFFSET+0x000480E8,0x00000000
#define IPU_DI1_DW_SET2_0__FULL                 IPU_REGISTERS_OFFSET+0x000480E8,0xffffffff
#define IPU_DI1_DW_SET2_0__DI1_DATA_CNT_DOWN2_0 IPU_REGISTERS_OFFSET+0x000480E8,0x01FF0000
#define IPU_DI1_DW_SET2_0__DI1_DATA_CNT_UP2_0   IPU_REGISTERS_OFFSET+0x000480E8,0x000001FF

#define IPU_DI1_DW_SET2_1__ADDR                 IPU_REGISTERS_OFFSET+0x000480EC
#define IPU_DI1_DW_SET2_1__EMPTY                IPU_REGISTERS_OFFSET+0x000480EC,0x00000000
#define IPU_DI1_DW_SET2_1__FULL                 IPU_REGISTERS_OFFSET+0x000480EC,0xffffffff
#define IPU_DI1_DW_SET2_1__DI1_DATA_CNT_DOWN2_1 IPU_REGISTERS_OFFSET+0x000480EC,0x01FF0000
#define IPU_DI1_DW_SET2_1__DI1_DATA_CNT_UP2_1   IPU_REGISTERS_OFFSET+0x000480EC,0x000001FF

#define IPU_DI1_DW_SET2_2__ADDR                 IPU_REGISTERS_OFFSET+0x000480F0
#define IPU_DI1_DW_SET2_2__EMPTY                IPU_REGISTERS_OFFSET+0x000480F0,0x00000000
#define IPU_DI1_DW_SET2_2__FULL                 IPU_REGISTERS_OFFSET+0x000480F0,0xffffffff
#define IPU_DI1_DW_SET2_2__DI1_DATA_CNT_DOWN2_2 IPU_REGISTERS_OFFSET+0x000480F0,0x01FF0000
#define IPU_DI1_DW_SET2_2__DI1_DATA_CNT_UP2_2   IPU_REGISTERS_OFFSET+0x000480F0,0x000001FF

#define IPU_DI1_DW_SET2_3__ADDR                 IPU_REGISTERS_OFFSET+0x000480F4
#define IPU_DI1_DW_SET2_3__EMPTY                IPU_REGISTERS_OFFSET+0x000480F4,0x00000000
#define IPU_DI1_DW_SET2_3__FULL                 IPU_REGISTERS_OFFSET+0x000480F4,0xffffffff
#define IPU_DI1_DW_SET2_3__DI1_DATA_CNT_DOWN2_3 IPU_REGISTERS_OFFSET+0x000480F4,0x01FF0000
#define IPU_DI1_DW_SET2_3__DI1_DATA_CNT_UP2_3   IPU_REGISTERS_OFFSET+0x000480F4,0x000001FF

#define IPU_DI1_DW_SET2_4__ADDR                 IPU_REGISTERS_OFFSET+0x000480F8
#define IPU_DI1_DW_SET2_4__EMPTY                IPU_REGISTERS_OFFSET+0x000480F8,0x00000000
#define IPU_DI1_DW_SET2_4__FULL                 IPU_REGISTERS_OFFSET+0x000480F8,0xffffffff
#define IPU_DI1_DW_SET2_4__DI1_DATA_CNT_DOWN2_4 IPU_REGISTERS_OFFSET+0x000480F8,0x01FF0000
#define IPU_DI1_DW_SET2_4__DI1_DATA_CNT_UP2_4   IPU_REGISTERS_OFFSET+0x000480F8,0x000001FF

#define IPU_DI1_DW_SET2_5__ADDR                 IPU_REGISTERS_OFFSET+0x000480FC
#define IPU_DI1_DW_SET2_5__EMPTY                IPU_REGISTERS_OFFSET+0x000480FC,0x00000000
#define IPU_DI1_DW_SET2_5__FULL                 IPU_REGISTERS_OFFSET+0x000480FC,0xffffffff
#define IPU_DI1_DW_SET2_5__DI1_DATA_CNT_DOWN2_5 IPU_REGISTERS_OFFSET+0x000480FC,0x01FF0000
#define IPU_DI1_DW_SET2_5__DI1_DATA_CNT_UP2_5   IPU_REGISTERS_OFFSET+0x000480FC,0x000001FF

#define IPU_DI1_DW_SET2_6__ADDR                 IPU_REGISTERS_OFFSET+0x00048100
#define IPU_DI1_DW_SET2_6__EMPTY                IPU_REGISTERS_OFFSET+0x00048100,0x00000000
#define IPU_DI1_DW_SET2_6__FULL                 IPU_REGISTERS_OFFSET+0x00048100,0xffffffff
#define IPU_DI1_DW_SET2_6__DI1_DATA_CNT_DOWN2_6 IPU_REGISTERS_OFFSET+0x00048100,0x01FF0000
#define IPU_DI1_DW_SET2_6__DI1_DATA_CNT_UP2_6   IPU_REGISTERS_OFFSET+0x00048100,0x000001FF

#define IPU_DI1_DW_SET2_7__ADDR                 IPU_REGISTERS_OFFSET+0x00048104
#define IPU_DI1_DW_SET2_7__EMPTY                IPU_REGISTERS_OFFSET+0x00048104,0x00000000
#define IPU_DI1_DW_SET2_7__FULL                 IPU_REGISTERS_OFFSET+0x00048104,0xffffffff
#define IPU_DI1_DW_SET2_7__DI1_DATA_CNT_DOWN2_7 IPU_REGISTERS_OFFSET+0x00048104,0x01FF0000
#define IPU_DI1_DW_SET2_7__DI1_DATA_CNT_UP2_7   IPU_REGISTERS_OFFSET+0x00048104,0x000001FF

#define IPU_DI1_DW_SET2_8__ADDR                 IPU_REGISTERS_OFFSET+0x00048108
#define IPU_DI1_DW_SET2_8__EMPTY                IPU_REGISTERS_OFFSET+0x00048108,0x00000000
#define IPU_DI1_DW_SET2_8__FULL                 IPU_REGISTERS_OFFSET+0x00048108,0xffffffff
#define IPU_DI1_DW_SET2_8__DI1_DATA_CNT_DOWN2_8 IPU_REGISTERS_OFFSET+0x00048108,0x01FF0000
#define IPU_DI1_DW_SET2_8__DI1_DATA_CNT_UP2_8   IPU_REGISTERS_OFFSET+0x00048108,0x000001FF

#define IPU_DI1_DW_SET2_9__ADDR                 IPU_REGISTERS_OFFSET+0x0004810C
#define IPU_DI1_DW_SET2_9__EMPTY                IPU_REGISTERS_OFFSET+0x0004810C,0x00000000
#define IPU_DI1_DW_SET2_9__FULL                 IPU_REGISTERS_OFFSET+0x0004810C,0xffffffff
#define IPU_DI1_DW_SET2_9__DI1_DATA_CNT_DOWN2_9 IPU_REGISTERS_OFFSET+0x0004810C,0x01FF0000
#define IPU_DI1_DW_SET2_9__DI1_DATA_CNT_UP2_9   IPU_REGISTERS_OFFSET+0x0004810C,0x000001FF

#define IPU_DI1_DW_SET2_10__ADDR                  IPU_REGISTERS_OFFSET+0x00048110
#define IPU_DI1_DW_SET2_10__EMPTY                 IPU_REGISTERS_OFFSET+0x00048110,0x00000000
#define IPU_DI1_DW_SET2_10__FULL                  IPU_REGISTERS_OFFSET+0x00048110,0xffffffff
#define IPU_DI1_DW_SET2_10__DI1_DATA_CNT_DOWN2_10 IPU_REGISTERS_OFFSET+0x00048110,0x01FF0000
#define IPU_DI1_DW_SET2_10__DI1_DATA_CNT_UP2_10   IPU_REGISTERS_OFFSET+0x00048110,0x000001FF

#define IPU_DI1_DW_SET2_11__ADDR                  IPU_REGISTERS_OFFSET+0x00048114
#define IPU_DI1_DW_SET2_11__EMPTY                 IPU_REGISTERS_OFFSET+0x00048114,0x00000000
#define IPU_DI1_DW_SET2_11__FULL                  IPU_REGISTERS_OFFSET+0x00048114,0xffffffff
#define IPU_DI1_DW_SET2_11__DI1_DATA_CNT_DOWN2_11 IPU_REGISTERS_OFFSET+0x00048114,0x01FF0000
#define IPU_DI1_DW_SET2_11__DI1_DATA_CNT_UP2_11   IPU_REGISTERS_OFFSET+0x00048114,0x000001FF

#define IPU_DI1_DW_SET3_0__ADDR                 IPU_REGISTERS_OFFSET+0x00048118
#define IPU_DI1_DW_SET3_0__EMPTY                IPU_REGISTERS_OFFSET+0x00048118,0x00000000
#define IPU_DI1_DW_SET3_0__FULL                 IPU_REGISTERS_OFFSET+0x00048118,0xffffffff
#define IPU_DI1_DW_SET3_0__DI1_DATA_CNT_DOWN3_0 IPU_REGISTERS_OFFSET+0x00048118,0x01FF0000
#define IPU_DI1_DW_SET3_0__DI1_DATA_CNT_UP3_0   IPU_REGISTERS_OFFSET+0x00048118,0x000001FF

#define IPU_DI1_DW_SET3_1__ADDR                 IPU_REGISTERS_OFFSET+0x0004811C
#define IPU_DI1_DW_SET3_1__EMPTY                IPU_REGISTERS_OFFSET+0x0004811C,0x00000000
#define IPU_DI1_DW_SET3_1__FULL                 IPU_REGISTERS_OFFSET+0x0004811C,0xffffffff
#define IPU_DI1_DW_SET3_1__DI1_DATA_CNT_DOWN3_1 IPU_REGISTERS_OFFSET+0x0004811C,0x01FF0000
#define IPU_DI1_DW_SET3_1__DI1_DATA_CNT_UP3_1   IPU_REGISTERS_OFFSET+0x0004811C,0x000001FF

#define IPU_DI1_DW_SET3_2__ADDR                 IPU_REGISTERS_OFFSET+0x00048120
#define IPU_DI1_DW_SET3_2__EMPTY                IPU_REGISTERS_OFFSET+0x00048120,0x00000000
#define IPU_DI1_DW_SET3_2__FULL                 IPU_REGISTERS_OFFSET+0x00048120,0xffffffff
#define IPU_DI1_DW_SET3_2__DI1_DATA_CNT_DOWN3_2 IPU_REGISTERS_OFFSET+0x00048120,0x01FF0000
#define IPU_DI1_DW_SET3_2__DI1_DATA_CNT_UP3_2   IPU_REGISTERS_OFFSET+0x00048120,0x000001FF

#define IPU_DI1_DW_SET3_3__ADDR                 IPU_REGISTERS_OFFSET+0x00048124
#define IPU_DI1_DW_SET3_3__EMPTY                IPU_REGISTERS_OFFSET+0x00048124,0x00000000
#define IPU_DI1_DW_SET3_3__FULL                 IPU_REGISTERS_OFFSET+0x00048124,0xffffffff
#define IPU_DI1_DW_SET3_3__DI1_DATA_CNT_DOWN3_3 IPU_REGISTERS_OFFSET+0x00048124,0x01FF0000
#define IPU_DI1_DW_SET3_3__DI1_DATA_CNT_UP3_3   IPU_REGISTERS_OFFSET+0x00048124,0x000001FF

#define IPU_DI1_DW_SET3_4__ADDR                 IPU_REGISTERS_OFFSET+0x00048128
#define IPU_DI1_DW_SET3_4__EMPTY                IPU_REGISTERS_OFFSET+0x00048128,0x00000000
#define IPU_DI1_DW_SET3_4__FULL                 IPU_REGISTERS_OFFSET+0x00048128,0xffffffff
#define IPU_DI1_DW_SET3_4__DI1_DATA_CNT_DOWN3_4 IPU_REGISTERS_OFFSET+0x00048128,0x01FF0000
#define IPU_DI1_DW_SET3_4__DI1_DATA_CNT_UP3_4   IPU_REGISTERS_OFFSET+0x00048128,0x000001FF

#define IPU_DI1_DW_SET3_5__ADDR                 IPU_REGISTERS_OFFSET+0x0004812C
#define IPU_DI1_DW_SET3_5__EMPTY                IPU_REGISTERS_OFFSET+0x0004812C,0x00000000
#define IPU_DI1_DW_SET3_5__FULL                 IPU_REGISTERS_OFFSET+0x0004812C,0xffffffff
#define IPU_DI1_DW_SET3_5__DI1_DATA_CNT_DOWN3_5 IPU_REGISTERS_OFFSET+0x0004812C,0x01FF0000
#define IPU_DI1_DW_SET3_5__DI1_DATA_CNT_UP3_5   IPU_REGISTERS_OFFSET+0x0004812C,0x000001FF

#define IPU_DI1_DW_SET3_6__ADDR                 IPU_REGISTERS_OFFSET+0x00048130
#define IPU_DI1_DW_SET3_6__EMPTY                IPU_REGISTERS_OFFSET+0x00048130,0x00000000
#define IPU_DI1_DW_SET3_6__FULL                 IPU_REGISTERS_OFFSET+0x00048130,0xffffffff
#define IPU_DI1_DW_SET3_6__DI1_DATA_CNT_DOWN3_6 IPU_REGISTERS_OFFSET+0x00048130,0x01FF0000
#define IPU_DI1_DW_SET3_6__DI1_DATA_CNT_UP3_6   IPU_REGISTERS_OFFSET+0x00048130,0x000001FF

#define IPU_DI1_DW_SET3_7__ADDR                 IPU_REGISTERS_OFFSET+0x00048134
#define IPU_DI1_DW_SET3_7__EMPTY                IPU_REGISTERS_OFFSET+0x00048134,0x00000000
#define IPU_DI1_DW_SET3_7__FULL                 IPU_REGISTERS_OFFSET+0x00048134,0xffffffff
#define IPU_DI1_DW_SET3_7__DI1_DATA_CNT_DOWN3_7 IPU_REGISTERS_OFFSET+0x00048134,0x01FF0000
#define IPU_DI1_DW_SET3_7__DI1_DATA_CNT_UP3_7   IPU_REGISTERS_OFFSET+0x00048134,0x000001FF

#define IPU_DI1_DW_SET3_8__ADDR                 IPU_REGISTERS_OFFSET+0x00048138
#define IPU_DI1_DW_SET3_8__EMPTY                IPU_REGISTERS_OFFSET+0x00048138,0x00000000
#define IPU_DI1_DW_SET3_8__FULL                 IPU_REGISTERS_OFFSET+0x00048138,0xffffffff
#define IPU_DI1_DW_SET3_8__DI1_DATA_CNT_DOWN3_8 IPU_REGISTERS_OFFSET+0x00048138,0x01FF0000
#define IPU_DI1_DW_SET3_8__DI1_DATA_CNT_UP3_8   IPU_REGISTERS_OFFSET+0x00048138,0x000001FF

#define IPU_DI1_DW_SET3_9__ADDR                 IPU_REGISTERS_OFFSET+0x0004813C
#define IPU_DI1_DW_SET3_9__EMPTY                IPU_REGISTERS_OFFSET+0x0004813C,0x00000000
#define IPU_DI1_DW_SET3_9__FULL                 IPU_REGISTERS_OFFSET+0x0004813C,0xffffffff
#define IPU_DI1_DW_SET3_9__DI1_DATA_CNT_DOWN3_9 IPU_REGISTERS_OFFSET+0x0004813C,0x01FF0000
#define IPU_DI1_DW_SET3_9__DI1_DATA_CNT_UP3_9   IPU_REGISTERS_OFFSET+0x0004813C,0x000001FF

#define IPU_DI1_DW_SET3_10__ADDR                  IPU_REGISTERS_OFFSET+0x00048140
#define IPU_DI1_DW_SET3_10__EMPTY                 IPU_REGISTERS_OFFSET+0x00048140,0x00000000
#define IPU_DI1_DW_SET3_10__FULL                  IPU_REGISTERS_OFFSET+0x00048140,0xffffffff
#define IPU_DI1_DW_SET3_10__DI1_DATA_CNT_DOWN3_10 IPU_REGISTERS_OFFSET+0x00048140,0x01FF0000
#define IPU_DI1_DW_SET3_10__DI1_DATA_CNT_UP3_10   IPU_REGISTERS_OFFSET+0x00048140,0x000001FF

#define IPU_DI1_DW_SET3_11__ADDR                  IPU_REGISTERS_OFFSET+0x00048144
#define IPU_DI1_DW_SET3_11__EMPTY                 IPU_REGISTERS_OFFSET+0x00048144,0x00000000
#define IPU_DI1_DW_SET3_11__FULL                  IPU_REGISTERS_OFFSET+0x00048144,0xffffffff
#define IPU_DI1_DW_SET3_11__DI1_DATA_CNT_DOWN3_11 IPU_REGISTERS_OFFSET+0x00048144,0x01FF0000
#define IPU_DI1_DW_SET3_11__DI1_DATA_CNT_UP3_11   IPU_REGISTERS_OFFSET+0x00048144,0x000001FF

#define IPU_DI1_STP_REP_1__ADDR              IPU_REGISTERS_OFFSET+0x00048148
#define IPU_DI1_STP_REP_1__EMPTY             IPU_REGISTERS_OFFSET+0x00048148,0x00000000
#define IPU_DI1_STP_REP_1__FULL              IPU_REGISTERS_OFFSET+0x00048148,0xffffffff
#define IPU_DI1_STP_REP_1__DI1_STEP_REPEAT_2 IPU_REGISTERS_OFFSET+0x00048148,0x0FFF0000
#define IPU_DI1_STP_REP_1__DI1_STEP_REPEAT_1 IPU_REGISTERS_OFFSET+0x00048148,0x00000FFF

#define IPU_DI1_STP_REP_2__ADDR              IPU_REGISTERS_OFFSET+0x0004814C
#define IPU_DI1_STP_REP_2__EMPTY             IPU_REGISTERS_OFFSET+0x0004814C,0x00000000
#define IPU_DI1_STP_REP_2__FULL              IPU_REGISTERS_OFFSET+0x0004814C,0xffffffff
#define IPU_DI1_STP_REP_2__DI1_STEP_REPEAT_4 IPU_REGISTERS_OFFSET+0x0004814C,0x0FFF0000
#define IPU_DI1_STP_REP_2__DI1_STEP_REPEAT_3 IPU_REGISTERS_OFFSET+0x0004814C,0x00000FFF

#define IPU_DI1_STP_REP_3__ADDR              IPU_REGISTERS_OFFSET+0x00048150
#define IPU_DI1_STP_REP_3__EMPTY             IPU_REGISTERS_OFFSET+0x00048150,0x00000000
#define IPU_DI1_STP_REP_3__FULL              IPU_REGISTERS_OFFSET+0x00048150,0xffffffff
#define IPU_DI1_STP_REP_3__DI1_STEP_REPEAT_6 IPU_REGISTERS_OFFSET+0x00048150,0x0FFF0000
#define IPU_DI1_STP_REP_3__DI1_STEP_REPEAT_5 IPU_REGISTERS_OFFSET+0x00048150,0x00000FFF

#define IPU_DI1_STP_REP_4__ADDR              IPU_REGISTERS_OFFSET+0x00048154
#define IPU_DI1_STP_REP_4__EMPTY             IPU_REGISTERS_OFFSET+0x00048154,0x00000000
#define IPU_DI1_STP_REP_4__FULL              IPU_REGISTERS_OFFSET+0x00048154,0xffffffff
#define IPU_DI1_STP_REP_4__DI1_STEP_REPEAT_8 IPU_REGISTERS_OFFSET+0x00048154,0x0FFF0000
#define IPU_DI1_STP_REP_4__DI1_STEP_REPEAT_7 IPU_REGISTERS_OFFSET+0x00048154,0x00000FFF

#define IPU_DI1_STP_REP_9__ADDR              IPU_REGISTERS_OFFSET+0x00048158
#define IPU_DI1_STP_REP_9__EMPTY             IPU_REGISTERS_OFFSET+0x00048158,0x00000000
#define IPU_DI1_STP_REP_9__FULL              IPU_REGISTERS_OFFSET+0x00048158,0xffffffff
#define IPU_DI1_STP_REP_9__DI1_STEP_REPEAT_9 IPU_REGISTERS_OFFSET+0x00048158,0x00000FFF

#define IPU_DI1_SER_CONF__ADDR                       IPU_REGISTERS_OFFSET+0x0004815C
#define IPU_DI1_SER_CONF__EMPTY                      IPU_REGISTERS_OFFSET+0x0004815C,0x00000000
#define IPU_DI1_SER_CONF__FULL                       IPU_REGISTERS_OFFSET+0x0004815C,0xffffffff
#define IPU_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_R_1 IPU_REGISTERS_OFFSET+0x0004815C,0xF0000000
#define IPU_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_R_0 IPU_REGISTERS_OFFSET+0x0004815C,0x0F000000
#define IPU_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_W_1 IPU_REGISTERS_OFFSET+0x0004815C,0x00F00000
#define IPU_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_W_0 IPU_REGISTERS_OFFSET+0x0004815C,0x000F0000
#define IPU_DI1_SER_CONF__DI1_SERIAL_LATCH           IPU_REGISTERS_OFFSET+0x0004815C,0x0000FF00
#define IPU_DI1_SER_CONF__DI1_LLA_SER_ACCESS         IPU_REGISTERS_OFFSET+0x0004815C,0x00000020
#define IPU_DI1_SER_CONF__DI1_SER_CLK_POLARITY       IPU_REGISTERS_OFFSET+0x0004815C,0x00000010
#define IPU_DI1_SER_CONF__DI1_SERIAL_DATA_POLARITY   IPU_REGISTERS_OFFSET+0x0004815C,0x00000008
#define IPU_DI1_SER_CONF__DI1_SERIAL_RS_POLARITY     IPU_REGISTERS_OFFSET+0x0004815C,0x00000004
#define IPU_DI1_SER_CONF__DI1_SERIAL_CS_POLARITY     IPU_REGISTERS_OFFSET+0x0004815C,0x00000002
#define IPU_DI1_SER_CONF__DI1_WAIT4SERIAL            IPU_REGISTERS_OFFSET+0x0004815C,0x00000001

#define IPU_DI1_SSC__ADDR              IPU_REGISTERS_OFFSET+0x00048160
#define IPU_DI1_SSC__EMPTY             IPU_REGISTERS_OFFSET+0x00048160,0x00000000
#define IPU_DI1_SSC__FULL              IPU_REGISTERS_OFFSET+0x00048160,0xffffffff
#define IPU_DI1_SSC__DI1_PIN17_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00800000
#define IPU_DI1_SSC__DI1_PIN16_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00400000
#define IPU_DI1_SSC__DI1_PIN15_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00200000
#define IPU_DI1_SSC__DI1_PIN14_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00100000
#define IPU_DI1_SSC__DI1_PIN13_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00080000
#define IPU_DI1_SSC__DI1_PIN12_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00040000
#define IPU_DI1_SSC__DI1_PIN11_ERM     IPU_REGISTERS_OFFSET+0x00048160,0x00020000
#define IPU_DI1_SSC__DI1_CS_ERM        IPU_REGISTERS_OFFSET+0x00048160,0x00010000
#define IPU_DI1_SSC__DI1_WAIT_ON       IPU_REGISTERS_OFFSET+0x00048160,0x00000020
#define IPU_DI1_SSC__DI1_BYTE_EN_RD_IN IPU_REGISTERS_OFFSET+0x00048160,0x00000008
#define IPU_DI1_SSC__DI1_BYTE_EN_PNTR  IPU_REGISTERS_OFFSET+0x00048160,0x00000007

#define IPU_DI1_POL__ADDR                     IPU_REGISTERS_OFFSET+0x00048164
#define IPU_DI1_POL__EMPTY                    IPU_REGISTERS_OFFSET+0x00048164,0x00000000
#define IPU_DI1_POL__FULL                     IPU_REGISTERS_OFFSET+0x00048164,0xffffffff
#define IPU_DI1_POL__DI1_WAIT_POLARITY        IPU_REGISTERS_OFFSET+0x00048164,0x04000000
#define IPU_DI1_POL__DI1_CS1_BYTE_EN_POLARITY IPU_REGISTERS_OFFSET+0x00048164,0x02000000
#define IPU_DI1_POL__DI1_CS0_BYTE_EN_POLARITY IPU_REGISTERS_OFFSET+0x00048164,0x01000000
#define IPU_DI1_POL__DI1_CS1_DATA_POLARITY    IPU_REGISTERS_OFFSET+0x00048164,0x00800000
#define IPU_DI1_POL__DI1_CS1_POLARITY_17      IPU_REGISTERS_OFFSET+0x00048164,0x00400000
#define IPU_DI1_POL__DI1_CS1_POLARITY_16      IPU_REGISTERS_OFFSET+0x00048164,0x00200000
#define IPU_DI1_POL__DI1_CS1_POLARITY_15      IPU_REGISTERS_OFFSET+0x00048164,0x00100000
#define IPU_DI1_POL__DI1_CS1_POLARITY_14      IPU_REGISTERS_OFFSET+0x00048164,0x00080000
#define IPU_DI1_POL__DI1_CS1_POLARITY_13      IPU_REGISTERS_OFFSET+0x00048164,0x00040000
#define IPU_DI1_POL__DI1_CS1_POLARITY_12      IPU_REGISTERS_OFFSET+0x00048164,0x00020000
#define IPU_DI1_POL__DI1_CS1_POLARITY_11      IPU_REGISTERS_OFFSET+0x00048164,0x00010000
#define IPU_DI1_POL__DI1_CS0_DATA_POLARITY    IPU_REGISTERS_OFFSET+0x00048164,0x00008000
#define IPU_DI1_POL__DI1_CS0_POLARITY_17      IPU_REGISTERS_OFFSET+0x00048164,0x00004000
#define IPU_DI1_POL__DI1_CS0_POLARITY_16      IPU_REGISTERS_OFFSET+0x00048164,0x00002000
#define IPU_DI1_POL__DI1_CS0_POLARITY_15      IPU_REGISTERS_OFFSET+0x00048164,0x00001000
#define IPU_DI1_POL__DI1_CS0_POLARITY_14      IPU_REGISTERS_OFFSET+0x00048164,0x00000800
#define IPU_DI1_POL__DI1_CS0_POLARITY_13      IPU_REGISTERS_OFFSET+0x00048164,0x00000400
#define IPU_DI1_POL__DI1_CS0_POLARITY_12      IPU_REGISTERS_OFFSET+0x00048164,0x00000200
#define IPU_DI1_POL__DI1_CS0_POLARITY_11      IPU_REGISTERS_OFFSET+0x00048164,0x00000100
#define IPU_DI1_POL__DI1_DRDY_DATA_POLARITY   IPU_REGISTERS_OFFSET+0x00048164,0x00000080
#define IPU_DI1_POL__DI1_DRDY_POLARITY_17     IPU_REGISTERS_OFFSET+0x00048164,0x00000040
#define IPU_DI1_POL__DI1_DRDY_POLARITY_16     IPU_REGISTERS_OFFSET+0x00048164,0x00000020
#define IPU_DI1_POL__DI1_DRDY_POLARITY_15     IPU_REGISTERS_OFFSET+0x00048164,0x00000010
#define IPU_DI1_POL__DI1_DRDY_POLARITY_14     IPU_REGISTERS_OFFSET+0x00048164,0x00000008
#define IPU_DI1_POL__DI1_DRDY_POLARITY_13     IPU_REGISTERS_OFFSET+0x00048164,0x00000004
#define IPU_DI1_POL__DI1_DRDY_POLARITY_12     IPU_REGISTERS_OFFSET+0x00048164,0x00000002
#define IPU_DI1_POL__DI1_DRDY_POLARITY_11     IPU_REGISTERS_OFFSET+0x00048164,0x00000001

#define IPU_DI1_AW0__ADDR              IPU_REGISTERS_OFFSET+0x00048168
#define IPU_DI1_AW0__EMPTY             IPU_REGISTERS_OFFSET+0x00048168,0x00000000
#define IPU_DI1_AW0__FULL              IPU_REGISTERS_OFFSET+0x00048168,0xffffffff
#define IPU_DI1_AW0__DI1_AW_TRIG_SEL   IPU_REGISTERS_OFFSET+0x00048168,0xF0000000
#define IPU_DI1_AW0__DI1_AW_HEND       IPU_REGISTERS_OFFSET+0x00048168,0x0FFF0000
#define IPU_DI1_AW0__DI1_AW_HCOUNT_SEL IPU_REGISTERS_OFFSET+0x00048168,0x0000F000
#define IPU_DI1_AW0__DI1_AW_HSTART     IPU_REGISTERS_OFFSET+0x00048168,0x00000FFF

#define IPU_DI1_AW1__ADDR              IPU_REGISTERS_OFFSET+0x0004816C
#define IPU_DI1_AW1__EMPTY             IPU_REGISTERS_OFFSET+0x0004816C,0x00000000
#define IPU_DI1_AW1__FULL              IPU_REGISTERS_OFFSET+0x0004816C,0xffffffff
#define IPU_DI1_AW1__DI1_AW_VEND       IPU_REGISTERS_OFFSET+0x0004816C,0x0FFF0000
#define IPU_DI1_AW1__DI1_AW_VCOUNT_SEL IPU_REGISTERS_OFFSET+0x0004816C,0x0000F000
#define IPU_DI1_AW1__DI1_AW_VSTART     IPU_REGISTERS_OFFSET+0x0004816C,0x00000FFF

#define IPU_DI1_SCR_CONF__ADDR              IPU_REGISTERS_OFFSET+0x00048170
#define IPU_DI1_SCR_CONF__EMPTY             IPU_REGISTERS_OFFSET+0x00048170,0x00000000
#define IPU_DI1_SCR_CONF__FULL              IPU_REGISTERS_OFFSET+0x00048170,0xffffffff
#define IPU_DI1_SCR_CONF__DI1_SCREEN_HEIGHT IPU_REGISTERS_OFFSET+0x00048170,0x00000FFF

#define IPU_DI1_STAT__ADDR                IPU_REGISTERS_OFFSET+0x00048174
#define IPU_DI1_STAT__EMPTY               IPU_REGISTERS_OFFSET+0x00048174,0x00000000
#define IPU_DI1_STAT__FULL                IPU_REGISTERS_OFFSET+0x00048174,0xffffffff
#define IPU_DI1_STAT__DI1_CNTR_FIFO_FULL  IPU_REGISTERS_OFFSET+0x00048174,0x00000008
#define IPU_DI1_STAT__DI1_CNTR_FIFO_EMPTY IPU_REGISTERS_OFFSET+0x00048174,0x00000004
#define IPU_DI1_STAT__DI1_READ_FIFO_FULL  IPU_REGISTERS_OFFSET+0x00048174,0x00000002
#define IPU_DI1_STAT__DI1_READ_FIFO_EMPTY IPU_REGISTERS_OFFSET+0x00048174,0x00000001

#define IPU_SMFC_MAP__ADDR    IPU_REGISTERS_OFFSET+0x00050000
#define IPU_SMFC_MAP__EMPTY   IPU_REGISTERS_OFFSET+0x00050000,0x00000000
#define IPU_SMFC_MAP__FULL    IPU_REGISTERS_OFFSET+0x00050000,0xffffffff
#define IPU_SMFC_MAP__MAP_CH3 IPU_REGISTERS_OFFSET+0x00050000,0x00000E00
#define IPU_SMFC_MAP__MAP_CH2 IPU_REGISTERS_OFFSET+0x00050000,0x000001C0
#define IPU_SMFC_MAP__MAP_CH1 IPU_REGISTERS_OFFSET+0x00050000,0x00000038
#define IPU_SMFC_MAP__MAP_CH0 IPU_REGISTERS_OFFSET+0x00050000,0x00000007

#define IPU_SMFC_WMC__ADDR    IPU_REGISTERS_OFFSET+0x00050004
#define IPU_SMFC_WMC__EMPTY   IPU_REGISTERS_OFFSET+0x00050004,0x00000000
#define IPU_SMFC_WMC__FULL    IPU_REGISTERS_OFFSET+0x00050004,0xffffffff
#define IPU_SMFC_WMC__WM3_CLR IPU_REGISTERS_OFFSET+0x00050004,0x0E000000
#define IPU_SMFC_WMC__WM3_SET IPU_REGISTERS_OFFSET+0x00050004,0x01C00000
#define IPU_SMFC_WMC__WM2_CLR IPU_REGISTERS_OFFSET+0x00050004,0x00380000
#define IPU_SMFC_WMC__WM2_SET IPU_REGISTERS_OFFSET+0x00050004,0x00070000
#define IPU_SMFC_WMC__WM1_CLR IPU_REGISTERS_OFFSET+0x00050004,0x00000E00
#define IPU_SMFC_WMC__WM1_SET IPU_REGISTERS_OFFSET+0x00050004,0x000001C0
#define IPU_SMFC_WMC__WM0_CLR IPU_REGISTERS_OFFSET+0x00050004,0x00000038
#define IPU_SMFC_WMC__WM0_SET IPU_REGISTERS_OFFSET+0x00050004,0x00000007

#define IPU_SMFC_BS__ADDR        IPU_REGISTERS_OFFSET+0x00050008
#define IPU_SMFC_BS__EMPTY       IPU_REGISTERS_OFFSET+0x00050008,0x00000000
#define IPU_SMFC_BS__FULL        IPU_REGISTERS_OFFSET+0x00050008,0xffffffff
#define IPU_SMFC_BS__BURST3_SIZE IPU_REGISTERS_OFFSET+0x00050008,0x0000F000
#define IPU_SMFC_BS__BURST2_SIZE IPU_REGISTERS_OFFSET+0x00050008,0x00000F00
#define IPU_SMFC_BS__BURST1_SIZE IPU_REGISTERS_OFFSET+0x00050008,0x000000F0
#define IPU_SMFC_BS__BURST0_SIZE IPU_REGISTERS_OFFSET+0x00050008,0x0000000F

#define IPU_DC_READ_CH_CONF__ADDR                IPU_REGISTERS_OFFSET+0x00058000
#define IPU_DC_READ_CH_CONF__EMPTY               IPU_REGISTERS_OFFSET+0x00058000,0x00000000
#define IPU_DC_READ_CH_CONF__FULL                IPU_REGISTERS_OFFSET+0x00058000,0xffffffff
#define IPU_DC_READ_CH_CONF__TIME_OUT_VALUE      IPU_REGISTERS_OFFSET+0x00058000,0xFFFF0000
#define IPU_DC_READ_CH_CONF__CS_ID_3             IPU_REGISTERS_OFFSET+0x00058000,0x00000800
#define IPU_DC_READ_CH_CONF__CS_ID_2             IPU_REGISTERS_OFFSET+0x00058000,0x00000400
#define IPU_DC_READ_CH_CONF__CS_ID_1             IPU_REGISTERS_OFFSET+0x00058000,0x00000200
#define IPU_DC_READ_CH_CONF__CS_ID_0             IPU_REGISTERS_OFFSET+0x00058000,0x00000100
#define IPU_DC_READ_CH_CONF__CHAN_MASK_DEFAULT_0 IPU_REGISTERS_OFFSET+0x00058000,0x00000040
#define IPU_DC_READ_CH_CONF__W_SIZE_0            IPU_REGISTERS_OFFSET+0x00058000,0x00000030
#define IPU_DC_READ_CH_CONF__PROG_DISP_ID_0      IPU_REGISTERS_OFFSET+0x00058000,0x0000000C
#define IPU_DC_READ_CH_CONF__PROG_DI_ID_0        IPU_REGISTERS_OFFSET+0x00058000,0x00000002
#define IPU_DC_READ_CH_CONF__RD_CHANNEL_EN       IPU_REGISTERS_OFFSET+0x00058000,0x00000001

#define IPU_DC_READ_CH_ADDR__ADDR      IPU_REGISTERS_OFFSET+0x00058004
#define IPU_DC_READ_CH_ADDR__EMPTY     IPU_REGISTERS_OFFSET+0x00058004,0x00000000
#define IPU_DC_READ_CH_ADDR__FULL      IPU_REGISTERS_OFFSET+0x00058004,0xffffffff
#define IPU_DC_READ_CH_ADDR__ST_ADDR_0 IPU_REGISTERS_OFFSET+0x00058004,0x1FFFFFFF

#define IPU_DC_RL0_CH_0__ADDR                   IPU_REGISTERS_OFFSET+0x00058008
#define IPU_DC_RL0_CH_0__EMPTY                  IPU_REGISTERS_OFFSET+0x00058008,0x00000000
#define IPU_DC_RL0_CH_0__FULL                   IPU_REGISTERS_OFFSET+0x00058008,0xffffffff
#define IPU_DC_RL0_CH_0__COD_NL_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058008,0xFF000000
#define IPU_DC_RL0_CH_0__COD_NL_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058008,0x000F0000
#define IPU_DC_RL0_CH_0__COD_NF_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058008,0x0000FF00
#define IPU_DC_RL0_CH_0__COD_NF_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058008,0x0000000F

#define IPU_DC_RL1_CH_0__ADDR                       IPU_REGISTERS_OFFSET+0x0005800C
#define IPU_DC_RL1_CH_0__EMPTY                      IPU_REGISTERS_OFFSET+0x0005800C,0x00000000
#define IPU_DC_RL1_CH_0__FULL                       IPU_REGISTERS_OFFSET+0x0005800C,0xffffffff
#define IPU_DC_RL1_CH_0__COD_NFIELD_START_CHAN_0    IPU_REGISTERS_OFFSET+0x0005800C,0xFF000000
#define IPU_DC_RL1_CH_0__COD_NFIELD_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x0005800C,0x000F0000
#define IPU_DC_RL1_CH_0__COD_EOF_START_CHAN_0       IPU_REGISTERS_OFFSET+0x0005800C,0x0000FF00
#define IPU_DC_RL1_CH_0__COD_EOF_PRIORITY_CHAN_0    IPU_REGISTERS_OFFSET+0x0005800C,0x0000000F

#define IPU_DC_RL2_CH_0__ADDR                        IPU_REGISTERS_OFFSET+0x00058010
#define IPU_DC_RL2_CH_0__EMPTY                       IPU_REGISTERS_OFFSET+0x00058010,0x00000000
#define IPU_DC_RL2_CH_0__FULL                        IPU_REGISTERS_OFFSET+0x00058010,0xffffffff
#define IPU_DC_RL2_CH_0__COD_EOFIELD_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058010,0xFF000000
#define IPU_DC_RL2_CH_0__COD_EOFIELD_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058010,0x000F0000
#define IPU_DC_RL2_CH_0__COD_EOL_START_CHAN_0        IPU_REGISTERS_OFFSET+0x00058010,0x0000FF00
#define IPU_DC_RL2_CH_0__COD_EOL_PRIORITY_CHAN_0     IPU_REGISTERS_OFFSET+0x00058010,0x0000000F

#define IPU_DC_RL3_CH_0__ADDR                         IPU_REGISTERS_OFFSET+0x00058014
#define IPU_DC_RL3_CH_0__EMPTY                        IPU_REGISTERS_OFFSET+0x00058014,0x00000000
#define IPU_DC_RL3_CH_0__FULL                         IPU_REGISTERS_OFFSET+0x00058014,0xffffffff
#define IPU_DC_RL3_CH_0__COD_NEW_CHAN_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058014,0xFF000000
#define IPU_DC_RL3_CH_0__COD_NEW_CHAN_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058014,0x000F0000
#define IPU_DC_RL3_CH_0__COD_NEW_ADDR_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058014,0x0000FF00
#define IPU_DC_RL3_CH_0__COD_NEW_ADDR_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058014,0x0000000F

#define IPU_DC_RL4_CH_0__ADDR                         IPU_REGISTERS_OFFSET+0x00058018
#define IPU_DC_RL4_CH_0__EMPTY                        IPU_REGISTERS_OFFSET+0x00058018,0x00000000
#define IPU_DC_RL4_CH_0__FULL                         IPU_REGISTERS_OFFSET+0x00058018,0xffffffff
#define IPU_DC_RL4_CH_0__COD_NEW_DATA_START_CHAN_0    IPU_REGISTERS_OFFSET+0x00058018,0x0000FF00
#define IPU_DC_RL4_CH_0__COD_NEW_DATA_PRIORITY_CHAN_0 IPU_REGISTERS_OFFSET+0x00058018,0x0000000F

#define IPU_DC_WR_CH_CONF_1__ADDR                IPU_REGISTERS_OFFSET+0x0005801C
#define IPU_DC_WR_CH_CONF_1__EMPTY               IPU_REGISTERS_OFFSET+0x0005801C,0x00000000
#define IPU_DC_WR_CH_CONF_1__FULL                IPU_REGISTERS_OFFSET+0x0005801C,0xffffffff
#define IPU_DC_WR_CH_CONF_1__PROG_START_TIME_1   IPU_REGISTERS_OFFSET+0x0005801C,0x07FF0000
#define IPU_DC_WR_CH_CONF_1__FIELD_MODE_1        IPU_REGISTERS_OFFSET+0x0005801C,0x00000200
#define IPU_DC_WR_CH_CONF_1__CHAN_MASK_DEFAULT_1 IPU_REGISTERS_OFFSET+0x0005801C,0x00000100
#define IPU_DC_WR_CH_CONF_1__PROG_CHAN_TYP_1     IPU_REGISTERS_OFFSET+0x0005801C,0x000000E0
#define IPU_DC_WR_CH_CONF_1__PROG_DISP_ID_1      IPU_REGISTERS_OFFSET+0x0005801C,0x00000018
#define IPU_DC_WR_CH_CONF_1__PROG_DI_ID_1        IPU_REGISTERS_OFFSET+0x0005801C,0x00000004
#define IPU_DC_WR_CH_CONF_1__W_SIZE_1            IPU_REGISTERS_OFFSET+0x0005801C,0x00000003

#define IPU_DC_WR_CH_ADDR_1__ADDR      IPU_REGISTERS_OFFSET+0x00058020
#define IPU_DC_WR_CH_ADDR_1__EMPTY     IPU_REGISTERS_OFFSET+0x00058020,0x00000000
#define IPU_DC_WR_CH_ADDR_1__FULL      IPU_REGISTERS_OFFSET+0x00058020,0xffffffff
#define IPU_DC_WR_CH_ADDR_1__ST_ADDR_1 IPU_REGISTERS_OFFSET+0x00058020,0x1FFFFFFF

#define IPU_DC_RL0_CH_1__ADDR                   IPU_REGISTERS_OFFSET+0x00058024
#define IPU_DC_RL0_CH_1__EMPTY                  IPU_REGISTERS_OFFSET+0x00058024,0x00000000
#define IPU_DC_RL0_CH_1__FULL                   IPU_REGISTERS_OFFSET+0x00058024,0xffffffff
#define IPU_DC_RL0_CH_1__COD_NL_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058024,0xFF000000
#define IPU_DC_RL0_CH_1__COD_NL_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058024,0x000F0000
#define IPU_DC_RL0_CH_1__COD_NF_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058024,0x0000FF00
#define IPU_DC_RL0_CH_1__COD_NF_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058024,0x0000000F

#define IPU_DC_RL1_CH_1__ADDR                       IPU_REGISTERS_OFFSET+0x00058028
#define IPU_DC_RL1_CH_1__EMPTY                      IPU_REGISTERS_OFFSET+0x00058028,0x00000000
#define IPU_DC_RL1_CH_1__FULL                       IPU_REGISTERS_OFFSET+0x00058028,0xffffffff
#define IPU_DC_RL1_CH_1__COD_NFIELD_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058028,0xFF000000
#define IPU_DC_RL1_CH_1__COD_NFIELD_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058028,0x000F0000
#define IPU_DC_RL1_CH_1__COD_EOF_START_CHAN_1       IPU_REGISTERS_OFFSET+0x00058028,0x0000FF00
#define IPU_DC_RL1_CH_1__COD_EOF_PRIORITY_CHAN_1    IPU_REGISTERS_OFFSET+0x00058028,0x0000000F

#define IPU_DC_RL2_CH_1__ADDR                        IPU_REGISTERS_OFFSET+0x0005802C
#define IPU_DC_RL2_CH_1__EMPTY                       IPU_REGISTERS_OFFSET+0x0005802C,0x00000000
#define IPU_DC_RL2_CH_1__FULL                        IPU_REGISTERS_OFFSET+0x0005802C,0xffffffff
#define IPU_DC_RL2_CH_1__COD_EOFIELD_START_CHAN_1    IPU_REGISTERS_OFFSET+0x0005802C,0xFF000000
#define IPU_DC_RL2_CH_1__COD_EOFIELD_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x0005802C,0x000F0000
#define IPU_DC_RL2_CH_1__COD_EOL_START_CHAN_1        IPU_REGISTERS_OFFSET+0x0005802C,0x0000FF00
#define IPU_DC_RL2_CH_1__COD_EOL_PRIORITY_CHAN_1     IPU_REGISTERS_OFFSET+0x0005802C,0x0000000F

#define IPU_DC_RL3_CH_1__ADDR                         IPU_REGISTERS_OFFSET+0x00058030
#define IPU_DC_RL3_CH_1__EMPTY                        IPU_REGISTERS_OFFSET+0x00058030,0x00000000
#define IPU_DC_RL3_CH_1__FULL                         IPU_REGISTERS_OFFSET+0x00058030,0xffffffff
#define IPU_DC_RL3_CH_1__COD_NEW_CHAN_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058030,0xFF000000
#define IPU_DC_RL3_CH_1__COD_NEW_CHAN_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058030,0x000F0000
#define IPU_DC_RL3_CH_1__COD_NEW_ADDR_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058030,0x0000FF00
#define IPU_DC_RL3_CH_1__COD_NEW_ADDR_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058030,0x0000000F

#define IPU_DC_RL4_CH_1__ADDR                         IPU_REGISTERS_OFFSET+0x00058034
#define IPU_DC_RL4_CH_1__EMPTY                        IPU_REGISTERS_OFFSET+0x00058034,0x00000000
#define IPU_DC_RL4_CH_1__FULL                         IPU_REGISTERS_OFFSET+0x00058034,0xffffffff
#define IPU_DC_RL4_CH_1__COD_NEW_DATA_START_CHAN_1    IPU_REGISTERS_OFFSET+0x00058034,0x0000FF00
#define IPU_DC_RL4_CH_1__COD_NEW_DATA_PRIORITY_CHAN_1 IPU_REGISTERS_OFFSET+0x00058034,0x0000000F

#define IPU_DC_WR_CH_CONF_2__ADDR                IPU_REGISTERS_OFFSET+0x00058038
#define IPU_DC_WR_CH_CONF_2__EMPTY               IPU_REGISTERS_OFFSET+0x00058038,0x00000000
#define IPU_DC_WR_CH_CONF_2__FULL                IPU_REGISTERS_OFFSET+0x00058038,0xffffffff
#define IPU_DC_WR_CH_CONF_2__PROG_START_TIME_2   IPU_REGISTERS_OFFSET+0x00058038,0x07FF0000
#define IPU_DC_WR_CH_CONF_2__CHAN_MASK_DEFAULT_2 IPU_REGISTERS_OFFSET+0x00058038,0x00000100
#define IPU_DC_WR_CH_CONF_2__PROG_CHAN_TYP_2     IPU_REGISTERS_OFFSET+0x00058038,0x000000E0
#define IPU_DC_WR_CH_CONF_2__PROG_DISP_ID_2      IPU_REGISTERS_OFFSET+0x00058038,0x00000018
#define IPU_DC_WR_CH_CONF_2__PROG_DI_ID_2        IPU_REGISTERS_OFFSET+0x00058038,0x00000004
#define IPU_DC_WR_CH_CONF_2__W_SIZE_2            IPU_REGISTERS_OFFSET+0x00058038,0x00000003

#define IPU_DC_WR_CH_ADDR_2__ADDR      IPU_REGISTERS_OFFSET+0x0005803C
#define IPU_DC_WR_CH_ADDR_2__EMPTY     IPU_REGISTERS_OFFSET+0x0005803C,0x00000000
#define IPU_DC_WR_CH_ADDR_2__FULL      IPU_REGISTERS_OFFSET+0x0005803C,0xffffffff
#define IPU_DC_WR_CH_ADDR_2__ST_ADDR_2 IPU_REGISTERS_OFFSET+0x0005803C,0x1FFFFFFF

#define IPU_DC_RL0_CH_2__ADDR                   IPU_REGISTERS_OFFSET+0x00058040
#define IPU_DC_RL0_CH_2__EMPTY                  IPU_REGISTERS_OFFSET+0x00058040,0x00000000
#define IPU_DC_RL0_CH_2__FULL                   IPU_REGISTERS_OFFSET+0x00058040,0xffffffff
#define IPU_DC_RL0_CH_2__COD_NL_START_CHAN_2    IPU_REGISTERS_OFFSET+0x00058040,0xFF000000
#define IPU_DC_RL0_CH_2__COD_NL_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x00058040,0x000F0000
#define IPU_DC_RL0_CH_2__COD_NF_START_CHAN_2    IPU_REGISTERS_OFFSET+0x00058040,0x0000FF00
#define IPU_DC_RL0_CH_2__COD_NF_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x00058040,0x0000000F

#define IPU_DC_RL1_CH_2__ADDR                       IPU_REGISTERS_OFFSET+0x00058044
#define IPU_DC_RL1_CH_2__EMPTY                      IPU_REGISTERS_OFFSET+0x00058044,0x00000000
#define IPU_DC_RL1_CH_2__FULL                       IPU_REGISTERS_OFFSET+0x00058044,0xffffffff
#define IPU_DC_RL1_CH_2__COD_NFIELD_START_CHAN_2    IPU_REGISTERS_OFFSET+0x00058044,0xFF000000
#define IPU_DC_RL1_CH_2__COD_NFIELD_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x00058044,0x000F0000
#define IPU_DC_RL1_CH_2__COD_EOF_START_CHAN_2       IPU_REGISTERS_OFFSET+0x00058044,0x0000FF00
#define IPU_DC_RL1_CH_2__COD_EOF_PRIORITY_CHAN_2    IPU_REGISTERS_OFFSET+0x00058044,0x0000000F

#define IPU_DC_RL2_CH_2__ADDR                        IPU_REGISTERS_OFFSET+0x00058048
#define IPU_DC_RL2_CH_2__EMPTY                       IPU_REGISTERS_OFFSET+0x00058048,0x00000000
#define IPU_DC_RL2_CH_2__FULL                        IPU_REGISTERS_OFFSET+0x00058048,0xffffffff
#define IPU_DC_RL2_CH_2__COD_EOFIELD_START_CHAN_2    IPU_REGISTERS_OFFSET+0x00058048,0xFF000000
#define IPU_DC_RL2_CH_2__COD_EOFIELD_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x00058048,0x000F0000
#define IPU_DC_RL2_CH_2__COD_EOL_START_CHAN_2        IPU_REGISTERS_OFFSET+0x00058048,0x0000FF00
#define IPU_DC_RL2_CH_2__COD_EOL_PRIORITY_CHAN_2     IPU_REGISTERS_OFFSET+0x00058048,0x0000000F

#define IPU_DC_RL3_CH_2__ADDR                         IPU_REGISTERS_OFFSET+0x0005804C
#define IPU_DC_RL3_CH_2__EMPTY                        IPU_REGISTERS_OFFSET+0x0005804C,0x00000000
#define IPU_DC_RL3_CH_2__FULL                         IPU_REGISTERS_OFFSET+0x0005804C,0xffffffff
#define IPU_DC_RL3_CH_2__COD_NEW_CHAN_START_CHAN_2    IPU_REGISTERS_OFFSET+0x0005804C,0xFF000000
#define IPU_DC_RL3_CH_2__COD_NEW_CHAN_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x0005804C,0x000F0000
#define IPU_DC_RL3_CH_2__COD_NEW_ADDR_START_CHAN_2    IPU_REGISTERS_OFFSET+0x0005804C,0x0000FF00
#define IPU_DC_RL3_CH_2__COD_NEW_ADDR_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x0005804C,0x0000000F

#define IPU_DC_RL4_CH_2__ADDR                         IPU_REGISTERS_OFFSET+0x00058050
#define IPU_DC_RL4_CH_2__EMPTY                        IPU_REGISTERS_OFFSET+0x00058050,0x00000000
#define IPU_DC_RL4_CH_2__FULL                         IPU_REGISTERS_OFFSET+0x00058050,0xffffffff
#define IPU_DC_RL4_CH_2__COD_NEW_DATA_START_CHAN_2    IPU_REGISTERS_OFFSET+0x00058050,0x0000FF00
#define IPU_DC_RL4_CH_2__COD_NEW_DATA_PRIORITY_CHAN_2 IPU_REGISTERS_OFFSET+0x00058050,0x0000000F

#define IPU_DC_CMD_CH_CONF_3__ADDR                      IPU_REGISTERS_OFFSET+0x00058054
#define IPU_DC_CMD_CH_CONF_3__EMPTY                     IPU_REGISTERS_OFFSET+0x00058054,0x00000000
#define IPU_DC_CMD_CH_CONF_3__FULL                      IPU_REGISTERS_OFFSET+0x00058054,0xffffffff
#define IPU_DC_CMD_CH_CONF_3__COD_CMND_START_CHAN_RS1_3 IPU_REGISTERS_OFFSET+0x00058054,0xFF000000
#define IPU_DC_CMD_CH_CONF_3__COD_CMND_START_CHAN_RS0_3 IPU_REGISTERS_OFFSET+0x00058054,0x0000FF00
#define IPU_DC_CMD_CH_CONF_3__W_SIZE_3                  IPU_REGISTERS_OFFSET+0x00058054,0x00000003

#define IPU_DC_CMD_CH_CONF_4__ADDR                      IPU_REGISTERS_OFFSET+0x00058058
#define IPU_DC_CMD_CH_CONF_4__EMPTY                     IPU_REGISTERS_OFFSET+0x00058058,0x00000000
#define IPU_DC_CMD_CH_CONF_4__FULL                      IPU_REGISTERS_OFFSET+0x00058058,0xffffffff
#define IPU_DC_CMD_CH_CONF_4__COD_CMND_START_CHAN_RS1_4 IPU_REGISTERS_OFFSET+0x00058058,0xFF000000
#define IPU_DC_CMD_CH_CONF_4__COD_CMND_START_CHAN_RS0_4 IPU_REGISTERS_OFFSET+0x00058058,0x0000FF00
#define IPU_DC_CMD_CH_CONF_4__W_SIZE_4                  IPU_REGISTERS_OFFSET+0x00058058,0x00000003

#define IPU_DC_WR_CH_CONF_5__ADDR                IPU_REGISTERS_OFFSET+0x0005805C
#define IPU_DC_WR_CH_CONF_5__EMPTY               IPU_REGISTERS_OFFSET+0x0005805C,0x00000000
#define IPU_DC_WR_CH_CONF_5__FULL                IPU_REGISTERS_OFFSET+0x0005805C,0xffffffff
#define IPU_DC_WR_CH_CONF_5__PROG_START_TIME_5   IPU_REGISTERS_OFFSET+0x0005805C,0x07FF0000
#define IPU_DC_WR_CH_CONF_5__FIELD_MODE_5        IPU_REGISTERS_OFFSET+0x0005805C,0x00000200
#define IPU_DC_WR_CH_CONF_5__CHAN_MASK_DEFAULT_5 IPU_REGISTERS_OFFSET+0x0005805C,0x00000100
#define IPU_DC_WR_CH_CONF_5__PROG_CHAN_TYP_5     IPU_REGISTERS_OFFSET+0x0005805C,0x000000E0
#define IPU_DC_WR_CH_CONF_5__PROG_DISP_ID_5      IPU_REGISTERS_OFFSET+0x0005805C,0x00000018
#define IPU_DC_WR_CH_CONF_5__PROG_DI_ID_5        IPU_REGISTERS_OFFSET+0x0005805C,0x00000004
#define IPU_DC_WR_CH_CONF_5__W_SIZE_5            IPU_REGISTERS_OFFSET+0x0005805C,0x00000003

#define IPU_DC_WR_CH_ADDR_5__ADDR      IPU_REGISTERS_OFFSET+0x00058060
#define IPU_DC_WR_CH_ADDR_5__EMPTY     IPU_REGISTERS_OFFSET+0x00058060,0x00000000
#define IPU_DC_WR_CH_ADDR_5__FULL      IPU_REGISTERS_OFFSET+0x00058060,0xffffffff
#define IPU_DC_WR_CH_ADDR_5__ST_ADDR_5 IPU_REGISTERS_OFFSET+0x00058060,0x1FFFFFFF

#define IPU_DC_RL0_CH_5__ADDR                   IPU_REGISTERS_OFFSET+0x00058064
#define IPU_DC_RL0_CH_5__EMPTY                  IPU_REGISTERS_OFFSET+0x00058064,0x00000000
#define IPU_DC_RL0_CH_5__FULL                   IPU_REGISTERS_OFFSET+0x00058064,0xffffffff
#define IPU_DC_RL0_CH_5__COD_NL_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058064,0xFF000000
#define IPU_DC_RL0_CH_5__COD_NL_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058064,0x000F0000
#define IPU_DC_RL0_CH_5__COD_NF_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058064,0x0000FF00
#define IPU_DC_RL0_CH_5__COD_NF_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058064,0x0000000F

#define IPU_DC_RL1_CH_5__ADDR                       IPU_REGISTERS_OFFSET+0x00058068
#define IPU_DC_RL1_CH_5__EMPTY                      IPU_REGISTERS_OFFSET+0x00058068,0x00000000
#define IPU_DC_RL1_CH_5__FULL                       IPU_REGISTERS_OFFSET+0x00058068,0xffffffff
#define IPU_DC_RL1_CH_5__COD_NFIELD_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058068,0xFF000000
#define IPU_DC_RL1_CH_5__COD_NFIELD_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058068,0x000F0000
#define IPU_DC_RL1_CH_5__COD_EOF_START_CHAN_5       IPU_REGISTERS_OFFSET+0x00058068,0x0000FF00
#define IPU_DC_RL1_CH_5__COD_EOF_PRIORITY_CHAN_5    IPU_REGISTERS_OFFSET+0x00058068,0x0000000F

#define IPU_DC_RL2_CH_5__ADDR                        IPU_REGISTERS_OFFSET+0x0005806C
#define IPU_DC_RL2_CH_5__EMPTY                       IPU_REGISTERS_OFFSET+0x0005806C,0x00000000
#define IPU_DC_RL2_CH_5__FULL                        IPU_REGISTERS_OFFSET+0x0005806C,0xffffffff
#define IPU_DC_RL2_CH_5__COD_EOFIELD_START_CHAN_5    IPU_REGISTERS_OFFSET+0x0005806C,0xFF000000
#define IPU_DC_RL2_CH_5__COD_EOFIELD_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x0005806C,0x000F0000
#define IPU_DC_RL2_CH_5__COD_EOL_START_CHAN_5        IPU_REGISTERS_OFFSET+0x0005806C,0x0000FF00
#define IPU_DC_RL2_CH_5__COD_EOL_PRIORITY_CHAN_5     IPU_REGISTERS_OFFSET+0x0005806C,0x0000000F

#define IPU_DC_RL3_CH_5__ADDR                         IPU_REGISTERS_OFFSET+0x00058070
#define IPU_DC_RL3_CH_5__EMPTY                        IPU_REGISTERS_OFFSET+0x00058070,0x00000000
#define IPU_DC_RL3_CH_5__FULL                         IPU_REGISTERS_OFFSET+0x00058070,0xffffffff
#define IPU_DC_RL3_CH_5__COD_NEW_CHAN_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058070,0xFF000000
#define IPU_DC_RL3_CH_5__COD_NEW_CHAN_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058070,0x000F0000
#define IPU_DC_RL3_CH_5__COD_NEW_ADDR_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058070,0x0000FF00
#define IPU_DC_RL3_CH_5__COD_NEW_ADDR_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058070,0x0000000F

#define IPU_DC_RL4_CH_5__ADDR                         IPU_REGISTERS_OFFSET+0x00058074
#define IPU_DC_RL4_CH_5__EMPTY                        IPU_REGISTERS_OFFSET+0x00058074,0x00000000
#define IPU_DC_RL4_CH_5__FULL                         IPU_REGISTERS_OFFSET+0x00058074,0xffffffff
#define IPU_DC_RL4_CH_5__COD_NEW_DATA_START_CHAN_5    IPU_REGISTERS_OFFSET+0x00058074,0x0000FF00
#define IPU_DC_RL4_CH_5__COD_NEW_DATA_PRIORITY_CHAN_5 IPU_REGISTERS_OFFSET+0x00058074,0x0000000F

#define IPU_DC_WR_CH_CONF_6__ADDR                IPU_REGISTERS_OFFSET+0x00058078
#define IPU_DC_WR_CH_CONF_6__EMPTY               IPU_REGISTERS_OFFSET+0x00058078,0x00000000
#define IPU_DC_WR_CH_CONF_6__FULL                IPU_REGISTERS_OFFSET+0x00058078,0xffffffff
#define IPU_DC_WR_CH_CONF_6__PROG_START_TIME_6   IPU_REGISTERS_OFFSET+0x00058078,0x07FF0000
#define IPU_DC_WR_CH_CONF_6__CHAN_MASK_DEFAULT_6 IPU_REGISTERS_OFFSET+0x00058078,0x00000100
#define IPU_DC_WR_CH_CONF_6__PROG_CHAN_TYP_6     IPU_REGISTERS_OFFSET+0x00058078,0x000000E0
#define IPU_DC_WR_CH_CONF_6__PROG_DISP_ID_6      IPU_REGISTERS_OFFSET+0x00058078,0x00000018
#define IPU_DC_WR_CH_CONF_6__PROG_DI_ID_6        IPU_REGISTERS_OFFSET+0x00058078,0x00000004
#define IPU_DC_WR_CH_CONF_6__W_SIZE_6            IPU_REGISTERS_OFFSET+0x00058078,0x00000003

#define IPU_DC_WR_CH_ADDR_6__ADDR      IPU_REGISTERS_OFFSET+0x0005807C
#define IPU_DC_WR_CH_ADDR_6__EMPTY     IPU_REGISTERS_OFFSET+0x0005807C,0x00000000
#define IPU_DC_WR_CH_ADDR_6__FULL      IPU_REGISTERS_OFFSET+0x0005807C,0xffffffff
#define IPU_DC_WR_CH_ADDR_6__ST_ADDR_6 IPU_REGISTERS_OFFSET+0x0005807C,0x1FFFFFFF

#define IPU_DC_RL0_CH_6__ADDR                   IPU_REGISTERS_OFFSET+0x00058080
#define IPU_DC_RL0_CH_6__EMPTY                  IPU_REGISTERS_OFFSET+0x00058080,0x00000000
#define IPU_DC_RL0_CH_6__FULL                   IPU_REGISTERS_OFFSET+0x00058080,0xffffffff
#define IPU_DC_RL0_CH_6__COD_NL_START_CHAN_6    IPU_REGISTERS_OFFSET+0x00058080,0xFF000000
#define IPU_DC_RL0_CH_6__COD_NL_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x00058080,0x000F0000
#define IPU_DC_RL0_CH_6__COD_NF_START_CHAN_6    IPU_REGISTERS_OFFSET+0x00058080,0x0000FF00
#define IPU_DC_RL0_CH_6__COD_NF_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x00058080,0x0000000F

#define IPU_DC_RL1_CH_6__ADDR                       IPU_REGISTERS_OFFSET+0x00058084
#define IPU_DC_RL1_CH_6__EMPTY                      IPU_REGISTERS_OFFSET+0x00058084,0x00000000
#define IPU_DC_RL1_CH_6__FULL                       IPU_REGISTERS_OFFSET+0x00058084,0xffffffff
#define IPU_DC_RL1_CH_6__COD_NFIELD_START_CHAN_6    IPU_REGISTERS_OFFSET+0x00058084,0xFF000000
#define IPU_DC_RL1_CH_6__COD_NFIELD_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x00058084,0x000F0000
#define IPU_DC_RL1_CH_6__COD_EOF_START_CHAN_6       IPU_REGISTERS_OFFSET+0x00058084,0x0000FF00
#define IPU_DC_RL1_CH_6__COD_EOF_PRIORITY_CHAN_6    IPU_REGISTERS_OFFSET+0x00058084,0x0000000F

#define IPU_DC_RL2_CH_6__ADDR                        IPU_REGISTERS_OFFSET+0x00058088
#define IPU_DC_RL2_CH_6__EMPTY                       IPU_REGISTERS_OFFSET+0x00058088,0x00000000
#define IPU_DC_RL2_CH_6__FULL                        IPU_REGISTERS_OFFSET+0x00058088,0xffffffff
#define IPU_DC_RL2_CH_6__COD_EOFIELD_START_CHAN_6    IPU_REGISTERS_OFFSET+0x00058088,0xFF000000
#define IPU_DC_RL2_CH_6__COD_EOFIELD_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x00058088,0x000F0000
#define IPU_DC_RL2_CH_6__COD_EOL_START_CHAN_6        IPU_REGISTERS_OFFSET+0x00058088,0x0000FF00
#define IPU_DC_RL2_CH_6__COD_EOL_PRIORITY_CHAN_6     IPU_REGISTERS_OFFSET+0x00058088,0x0000000F

#define IPU_DC_RL3_CH_6__ADDR                         IPU_REGISTERS_OFFSET+0x0005808C
#define IPU_DC_RL3_CH_6__EMPTY                        IPU_REGISTERS_OFFSET+0x0005808C,0x00000000
#define IPU_DC_RL3_CH_6__FULL                         IPU_REGISTERS_OFFSET+0x0005808C,0xffffffff
#define IPU_DC_RL3_CH_6__COD_NEW_CHAN_START_CHAN_6    IPU_REGISTERS_OFFSET+0x0005808C,0xFF000000
#define IPU_DC_RL3_CH_6__COD_NEW_CHAN_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x0005808C,0x000F0000
#define IPU_DC_RL3_CH_6__COD_NEW_ADDR_START_CHAN_6    IPU_REGISTERS_OFFSET+0x0005808C,0x0000FF00
#define IPU_DC_RL3_CH_6__COD_NEW_ADDR_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x0005808C,0x0000000F

#define IPU_DC_RL4_CH_6__ADDR                         IPU_REGISTERS_OFFSET+0x00058090
#define IPU_DC_RL4_CH_6__EMPTY                        IPU_REGISTERS_OFFSET+0x00058090,0x00000000
#define IPU_DC_RL4_CH_6__FULL                         IPU_REGISTERS_OFFSET+0x00058090,0xffffffff
#define IPU_DC_RL4_CH_6__COD_NEW_DATA_START_CHAN_6    IPU_REGISTERS_OFFSET+0x00058090,0x0000FF00
#define IPU_DC_RL4_CH_6__COD_NEW_DATA_PRIORITY_CHAN_6 IPU_REGISTERS_OFFSET+0x00058090,0x0000000F

#define IPU_DC_WR_CH_CONF1_8__ADDR                IPU_REGISTERS_OFFSET+0x00058094
#define IPU_DC_WR_CH_CONF1_8__EMPTY               IPU_REGISTERS_OFFSET+0x00058094,0x00000000
#define IPU_DC_WR_CH_CONF1_8__FULL                IPU_REGISTERS_OFFSET+0x00058094,0xffffffff
#define IPU_DC_WR_CH_CONF1_8__MCU_DISP_ID_8       IPU_REGISTERS_OFFSET+0x00058094,0x00000018
#define IPU_DC_WR_CH_CONF1_8__CHAN_MASK_DEFAULT_8 IPU_REGISTERS_OFFSET+0x00058094,0x00000004
#define IPU_DC_WR_CH_CONF1_8__W_SIZE_8            IPU_REGISTERS_OFFSET+0x00058094,0x00000003

#define IPU_DC_WR_CH_CONF2_8__ADDR                IPU_REGISTERS_OFFSET+0x00058098
#define IPU_DC_WR_CH_CONF2_8__EMPTY               IPU_REGISTERS_OFFSET+0x00058098,0x00000000
#define IPU_DC_WR_CH_CONF2_8__FULL                IPU_REGISTERS_OFFSET+0x00058098,0xffffffff
#define IPU_DC_WR_CH_CONF2_8__NEW_ADDR_SPACE_SA_8 IPU_REGISTERS_OFFSET+0x00058098,0x1FFFFFFF

#define IPU_DC_RL1_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x0005809C
#define IPU_DC_RL1_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x0005809C,0x00000000
#define IPU_DC_RL1_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x0005809C,0xffffffff
#define IPU_DC_RL1_CH_8__COD_NEW_ADDR_START_CHAN_W_8_1 IPU_REGISTERS_OFFSET+0x0005809C,0xFF000000
#define IPU_DC_RL1_CH_8__COD_NEW_ADDR_START_CHAN_W_8_0 IPU_REGISTERS_OFFSET+0x0005809C,0x0000FF00
#define IPU_DC_RL1_CH_8__COD_NEW_ADDR_PRIORITY_CHAN_8  IPU_REGISTERS_OFFSET+0x0005809C,0x0000000F

#define IPU_DC_RL2_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x000580A0
#define IPU_DC_RL2_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x000580A0,0x00000000
#define IPU_DC_RL2_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x000580A0,0xffffffff
#define IPU_DC_RL2_CH_8__COD_NEW_CHAN_START_CHAN_W_8_1 IPU_REGISTERS_OFFSET+0x000580A0,0xFF000000
#define IPU_DC_RL2_CH_8__COD_NEW_CHAN_START_CHAN_W_8_0 IPU_REGISTERS_OFFSET+0x000580A0,0x0000FF00
#define IPU_DC_RL2_CH_8__COD_NEW_CHAN_PRIORITY_CHAN_8  IPU_REGISTERS_OFFSET+0x000580A0,0x0000000F

#define IPU_DC_RL3_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x000580A4
#define IPU_DC_RL3_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x000580A4,0x00000000
#define IPU_DC_RL3_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x000580A4,0xffffffff
#define IPU_DC_RL3_CH_8__COD_NEW_DATA_START_CHAN_W_8_1 IPU_REGISTERS_OFFSET+0x000580A4,0xFF000000
#define IPU_DC_RL3_CH_8__COD_NEW_DATA_START_CHAN_W_8_0 IPU_REGISTERS_OFFSET+0x000580A4,0x0000FF00
#define IPU_DC_RL3_CH_8__COD_NEW_DATA_PRIORITY_CHAN_8  IPU_REGISTERS_OFFSET+0x000580A4,0x0000000F

#define IPU_DC_RL4_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x000580A8
#define IPU_DC_RL4_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x000580A8,0x00000000
#define IPU_DC_RL4_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x000580A8,0xffffffff
#define IPU_DC_RL4_CH_8__COD_NEW_ADDR_START_CHAN_R_8_1 IPU_REGISTERS_OFFSET+0x000580A8,0xFF000000
#define IPU_DC_RL4_CH_8__COD_NEW_ADDR_START_CHAN_R_8_0 IPU_REGISTERS_OFFSET+0x000580A8,0x0000FF00

#define IPU_DC_RL5_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x000580AC
#define IPU_DC_RL5_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x000580AC,0x00000000
#define IPU_DC_RL5_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x000580AC,0xffffffff
#define IPU_DC_RL5_CH_8__COD_NEW_CHAN_START_CHAN_R_8_1 IPU_REGISTERS_OFFSET+0x000580AC,0xFF000000
#define IPU_DC_RL5_CH_8__COD_NEW_CHAN_START_CHAN_R_8_0 IPU_REGISTERS_OFFSET+0x000580AC,0x0000FF00

#define IPU_DC_RL6_CH_8__ADDR                          IPU_REGISTERS_OFFSET+0x000580B0
#define IPU_DC_RL6_CH_8__EMPTY                         IPU_REGISTERS_OFFSET+0x000580B0,0x00000000
#define IPU_DC_RL6_CH_8__FULL                          IPU_REGISTERS_OFFSET+0x000580B0,0xffffffff
#define IPU_DC_RL6_CH_8__COD_NEW_DATA_START_CHAN_R_8_1 IPU_REGISTERS_OFFSET+0x000580B0,0xFF000000
#define IPU_DC_RL6_CH_8__COD_NEW_DATA_START_CHAN_R_8_0 IPU_REGISTERS_OFFSET+0x000580B0,0x0000FF00

#define IPU_DC_WR_CH_CONF1_9__ADDR                IPU_REGISTERS_OFFSET+0x000580B4
#define IPU_DC_WR_CH_CONF1_9__EMPTY               IPU_REGISTERS_OFFSET+0x000580B4,0x00000000
#define IPU_DC_WR_CH_CONF1_9__FULL                IPU_REGISTERS_OFFSET+0x000580B4,0xffffffff
#define IPU_DC_WR_CH_CONF1_9__MCU_DISP_ID_9       IPU_REGISTERS_OFFSET+0x000580B4,0x00000018
#define IPU_DC_WR_CH_CONF1_9__CHAN_MASK_DEFAULT_9 IPU_REGISTERS_OFFSET+0x000580B4,0x00000004
#define IPU_DC_WR_CH_CONF1_9__W_SIZE_9            IPU_REGISTERS_OFFSET+0x000580B4,0x00000003

#define IPU_DC_WR_CH_CONF2_9__ADDR                IPU_REGISTERS_OFFSET+0x000580B8
#define IPU_DC_WR_CH_CONF2_9__EMPTY               IPU_REGISTERS_OFFSET+0x000580B8,0x00000000
#define IPU_DC_WR_CH_CONF2_9__FULL                IPU_REGISTERS_OFFSET+0x000580B8,0xffffffff
#define IPU_DC_WR_CH_CONF2_9__NEW_ADDR_SPACE_SA_9 IPU_REGISTERS_OFFSET+0x000580B8,0x1FFFFFFF

#define IPU_DC_RL1_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580BC
#define IPU_DC_RL1_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580BC,0x00000000
#define IPU_DC_RL1_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580BC,0xffffffff
#define IPU_DC_RL1_CH_9__COD_NEW_ADDR_START_CHAN_W_9_1 IPU_REGISTERS_OFFSET+0x000580BC,0xFF000000
#define IPU_DC_RL1_CH_9__COD_NEW_ADDR_START_CHAN_W_9_0 IPU_REGISTERS_OFFSET+0x000580BC,0x0000FF00
#define IPU_DC_RL1_CH_9__COD_NEW_ADDR_PRIORITY_CHAN_9  IPU_REGISTERS_OFFSET+0x000580BC,0x0000000F

#define IPU_DC_RL2_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580C0
#define IPU_DC_RL2_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580C0,0x00000000
#define IPU_DC_RL2_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580C0,0xffffffff
#define IPU_DC_RL2_CH_9__COD_NEW_CHAN_START_CHAN_W_9_1 IPU_REGISTERS_OFFSET+0x000580C0,0xFF000000
#define IPU_DC_RL2_CH_9__COD_NEW_CHAN_START_CHAN_W_9_0 IPU_REGISTERS_OFFSET+0x000580C0,0x0000FF00
#define IPU_DC_RL2_CH_9__COD_NEW_CHAN_PRIORITY_CHAN_9  IPU_REGISTERS_OFFSET+0x000580C0,0x0000000F

#define IPU_DC_RL3_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580C4
#define IPU_DC_RL3_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580C4,0x00000000
#define IPU_DC_RL3_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580C4,0xffffffff
#define IPU_DC_RL3_CH_9__COD_NEW_DATA_START_CHAN_W_9_1 IPU_REGISTERS_OFFSET+0x000580C4,0xFF000000
#define IPU_DC_RL3_CH_9__COD_NEW_DATA_START_CHAN_W_9_0 IPU_REGISTERS_OFFSET+0x000580C4,0x0000FF00
#define IPU_DC_RL3_CH_9__COD_NEW_DATA_PRIORITY_CHAN_9  IPU_REGISTERS_OFFSET+0x000580C4,0x0000000F

#define IPU_DC_RL4_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580C8
#define IPU_DC_RL4_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580C8,0x00000000
#define IPU_DC_RL4_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580C8,0xffffffff
#define IPU_DC_RL4_CH_9__COD_NEW_ADDR_START_CHAN_R_9_1 IPU_REGISTERS_OFFSET+0x000580C8,0xFF000000
#define IPU_DC_RL4_CH_9__COD_NEW_ADDR_START_CHAN_R_9_0 IPU_REGISTERS_OFFSET+0x000580C8,0x0000FF00

#define IPU_DC_RL5_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580CC
#define IPU_DC_RL5_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580CC,0x00000000
#define IPU_DC_RL5_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580CC,0xffffffff
#define IPU_DC_RL5_CH_9__COD_NEW_CHAN_START_CHAN_R_9_1 IPU_REGISTERS_OFFSET+0x000580CC,0xFF000000
#define IPU_DC_RL5_CH_9__COD_NEW_CHAN_START_CHAN_R_9_0 IPU_REGISTERS_OFFSET+0x000580CC,0x0000FF00

#define IPU_DC_RL6_CH_9__ADDR                          IPU_REGISTERS_OFFSET+0x000580D0
#define IPU_DC_RL6_CH_9__EMPTY                         IPU_REGISTERS_OFFSET+0x000580D0,0x00000000
#define IPU_DC_RL6_CH_9__FULL                          IPU_REGISTERS_OFFSET+0x000580D0,0xffffffff
#define IPU_DC_RL6_CH_9__COD_NEW_DATA_START_CHAN_R_9_1 IPU_REGISTERS_OFFSET+0x000580D0,0xFF000000
#define IPU_DC_RL6_CH_9__COD_NEW_DATA_START_CHAN_R_9_0 IPU_REGISTERS_OFFSET+0x000580D0,0x0000FF00

#define IPU_DC_GEN__ADDR            IPU_REGISTERS_OFFSET+0x000580D4
#define IPU_DC_GEN__EMPTY           IPU_REGISTERS_OFFSET+0x000580D4,0x00000000
#define IPU_DC_GEN__FULL            IPU_REGISTERS_OFFSET+0x000580D4,0xffffffff
#define IPU_DC_GEN__DC_BK_EN        IPU_REGISTERS_OFFSET+0x000580D4,0x01000000
#define IPU_DC_GEN__DC_BKDIV        IPU_REGISTERS_OFFSET+0x000580D4,0x00FF0000
#define IPU_DC_GEN__DC_CH5_TYPE     IPU_REGISTERS_OFFSET+0x000580D4,0x00000100
#define IPU_DC_GEN__SYNC_PRIORITY_1 IPU_REGISTERS_OFFSET+0x000580D4,0x00000080
#define IPU_DC_GEN__SYNC_PRIORITY_5 IPU_REGISTERS_OFFSET+0x000580D4,0x00000040
#define IPU_DC_GEN__MASK4CHAN_5     IPU_REGISTERS_OFFSET+0x000580D4,0x00000020
#define IPU_DC_GEN__MASK_EN         IPU_REGISTERS_OFFSET+0x000580D4,0x00000010
#define IPU_DC_GEN__SYNC_1_6        IPU_REGISTERS_OFFSET+0x000580D4,0x00000006

#define IPU_DC_DISP_CONF1_0__ADDR                IPU_REGISTERS_OFFSET+0x000580D8
#define IPU_DC_DISP_CONF1_0__EMPTY               IPU_REGISTERS_OFFSET+0x000580D8,0x00000000
#define IPU_DC_DISP_CONF1_0__FULL                IPU_REGISTERS_OFFSET+0x000580D8,0xffffffff
#define IPU_DC_DISP_CONF1_0__DISP_RD_VALUE_PTR_0 IPU_REGISTERS_OFFSET+0x000580D8,0x00000080
#define IPU_DC_DISP_CONF1_0__MCU_ACC_LB_MASK_0   IPU_REGISTERS_OFFSET+0x000580D8,0x00000040
#define IPU_DC_DISP_CONF1_0__ADDR_BE_L_INC_0     IPU_REGISTERS_OFFSET+0x000580D8,0x00000030
#define IPU_DC_DISP_CONF1_0__ADDR_INCREMENT_0    IPU_REGISTERS_OFFSET+0x000580D8,0x0000000C
#define IPU_DC_DISP_CONF1_0__DISP_TYP_0          IPU_REGISTERS_OFFSET+0x000580D8,0x00000003

#define IPU_DC_DISP_CONF1_1__ADDR                IPU_REGISTERS_OFFSET+0x000580DC
#define IPU_DC_DISP_CONF1_1__EMPTY               IPU_REGISTERS_OFFSET+0x000580DC,0x00000000
#define IPU_DC_DISP_CONF1_1__FULL                IPU_REGISTERS_OFFSET+0x000580DC,0xffffffff
#define IPU_DC_DISP_CONF1_1__DISP_RD_VALUE_PTR_1 IPU_REGISTERS_OFFSET+0x000580DC,0x00000080
#define IPU_DC_DISP_CONF1_1__MCU_ACC_LB_MASK_1   IPU_REGISTERS_OFFSET+0x000580DC,0x00000040
#define IPU_DC_DISP_CONF1_1__ADDR_BE_L_INC_1     IPU_REGISTERS_OFFSET+0x000580DC,0x00000030
#define IPU_DC_DISP_CONF1_1__ADDR_INCREMENT_1    IPU_REGISTERS_OFFSET+0x000580DC,0x0000000C
#define IPU_DC_DISP_CONF1_1__DISP_TYP_1          IPU_REGISTERS_OFFSET+0x000580DC,0x00000003

#define IPU_DC_DISP_CONF1_2__ADDR                IPU_REGISTERS_OFFSET+0x000580E0
#define IPU_DC_DISP_CONF1_2__EMPTY               IPU_REGISTERS_OFFSET+0x000580E0,0x00000000
#define IPU_DC_DISP_CONF1_2__FULL                IPU_REGISTERS_OFFSET+0x000580E0,0xffffffff
#define IPU_DC_DISP_CONF1_2__DISP_RD_VALUE_PTR_2 IPU_REGISTERS_OFFSET+0x000580E0,0x00000080
#define IPU_DC_DISP_CONF1_2__MCU_ACC_LB_MASK_2   IPU_REGISTERS_OFFSET+0x000580E0,0x00000040
#define IPU_DC_DISP_CONF1_2__ADDR_BE_L_INC_2     IPU_REGISTERS_OFFSET+0x000580E0,0x00000030
#define IPU_DC_DISP_CONF1_2__ADDR_INCREMENT_2    IPU_REGISTERS_OFFSET+0x000580E0,0x0000000C
#define IPU_DC_DISP_CONF1_2__DISP_TYP_2          IPU_REGISTERS_OFFSET+0x000580E0,0x00000003

#define IPU_DC_DISP_CONF1_3__ADDR                IPU_REGISTERS_OFFSET+0x000580E4
#define IPU_DC_DISP_CONF1_3__EMPTY               IPU_REGISTERS_OFFSET+0x000580E4,0x00000000
#define IPU_DC_DISP_CONF1_3__FULL                IPU_REGISTERS_OFFSET+0x000580E4,0xffffffff
#define IPU_DC_DISP_CONF1_3__DISP_RD_VALUE_PTR_3 IPU_REGISTERS_OFFSET+0x000580E4,0x00000080
#define IPU_DC_DISP_CONF1_3__MCU_ACC_LB_MASK_3   IPU_REGISTERS_OFFSET+0x000580E4,0x00000040
#define IPU_DC_DISP_CONF1_3__ADDR_BE_L_INC_3     IPU_REGISTERS_OFFSET+0x000580E4,0x00000030
#define IPU_DC_DISP_CONF1_3__ADDR_INCREMENT_3    IPU_REGISTERS_OFFSET+0x000580E4,0x0000000C
#define IPU_DC_DISP_CONF1_3__DISP_TYP_3          IPU_REGISTERS_OFFSET+0x000580E4,0x00000003

#define IPU_DC_DISP_CONF2_0__ADDR  IPU_REGISTERS_OFFSET+0x000580E8
#define IPU_DC_DISP_CONF2_0__EMPTY IPU_REGISTERS_OFFSET+0x000580E8,0x00000000
#define IPU_DC_DISP_CONF2_0__FULL  IPU_REGISTERS_OFFSET+0x000580E8,0xffffffff
#define IPU_DC_DISP_CONF2_0__SL_0  IPU_REGISTERS_OFFSET+0x000580E8,0x1FFFFFFF

#define IPU_DC_DISP_CONF2_1__ADDR  IPU_REGISTERS_OFFSET+0x000580EC
#define IPU_DC_DISP_CONF2_1__EMPTY IPU_REGISTERS_OFFSET+0x000580EC,0x00000000
#define IPU_DC_DISP_CONF2_1__FULL  IPU_REGISTERS_OFFSET+0x000580EC,0xffffffff
#define IPU_DC_DISP_CONF2_1__SL_1  IPU_REGISTERS_OFFSET+0x000580EC,0x1FFFFFFF

#define IPU_DC_DISP_CONF2_2__ADDR  IPU_REGISTERS_OFFSET+0x000580F0
#define IPU_DC_DISP_CONF2_2__EMPTY IPU_REGISTERS_OFFSET+0x000580F0,0x00000000
#define IPU_DC_DISP_CONF2_2__FULL  IPU_REGISTERS_OFFSET+0x000580F0,0xffffffff
#define IPU_DC_DISP_CONF2_2__SL_2  IPU_REGISTERS_OFFSET+0x000580F0,0x1FFFFFFF

#define IPU_DC_DISP_CONF2_3__ADDR  IPU_REGISTERS_OFFSET+0x000580F4
#define IPU_DC_DISP_CONF2_3__EMPTY IPU_REGISTERS_OFFSET+0x000580F4,0x00000000
#define IPU_DC_DISP_CONF2_3__FULL  IPU_REGISTERS_OFFSET+0x000580F4,0xffffffff
#define IPU_DC_DISP_CONF2_3__SL_3  IPU_REGISTERS_OFFSET+0x000580F4,0x1FFFFFFF

#define IPU_DC_DI0_CONF_1__ADDR                IPU_REGISTERS_OFFSET+0x000580F8
#define IPU_DC_DI0_CONF_1__EMPTY               IPU_REGISTERS_OFFSET+0x000580F8,0x00000000
#define IPU_DC_DI0_CONF_1__FULL                IPU_REGISTERS_OFFSET+0x000580F8,0xffffffff
#define IPU_DC_DI0_CONF_1__DI_READ_DATA_MASK_0 IPU_REGISTERS_OFFSET+0x000580F8,0xFFFFFFFF

#define IPU_DC_DI0_CONF_2__ADDR                     IPU_REGISTERS_OFFSET+0x000580FC
#define IPU_DC_DI0_CONF_2__EMPTY                    IPU_REGISTERS_OFFSET+0x000580FC,0x00000000
#define IPU_DC_DI0_CONF_2__FULL                     IPU_REGISTERS_OFFSET+0x000580FC,0xffffffff
#define IPU_DC_DI0_CONF_2__DI_READ_DATA_ACK_VALUE_0 IPU_REGISTERS_OFFSET+0x000580FC,0xFFFFFFFF

#define IPU_DC_DI1_CONF_1__ADDR                IPU_REGISTERS_OFFSET+0x00058100
#define IPU_DC_DI1_CONF_1__EMPTY               IPU_REGISTERS_OFFSET+0x00058100,0x00000000
#define IPU_DC_DI1_CONF_1__FULL                IPU_REGISTERS_OFFSET+0x00058100,0xffffffff
#define IPU_DC_DI1_CONF_1__DI_READ_DATA_MASK_1 IPU_REGISTERS_OFFSET+0x00058100,0xFFFFFFFF

#define IPU_DC_DI1_CONF_2__ADDR                     IPU_REGISTERS_OFFSET+0x00058104
#define IPU_DC_DI1_CONF_2__EMPTY                    IPU_REGISTERS_OFFSET+0x00058104,0x00000000
#define IPU_DC_DI1_CONF_2__FULL                     IPU_REGISTERS_OFFSET+0x00058104,0xffffffff
#define IPU_DC_DI1_CONF_2__DI_READ_DATA_ACK_VALUE_1 IPU_REGISTERS_OFFSET+0x00058104,0xFFFFFFFF

#define IPU_DC_MAP_CONF_0__ADDR                 IPU_REGISTERS_OFFSET+0x00058108
#define IPU_DC_MAP_CONF_0__EMPTY                IPU_REGISTERS_OFFSET+0x00058108,0x00000000
#define IPU_DC_MAP_CONF_0__FULL                 IPU_REGISTERS_OFFSET+0x00058108,0xffffffff
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE2_1 IPU_REGISTERS_OFFSET+0x00058108,0x7C000000
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE1_1 IPU_REGISTERS_OFFSET+0x00058108,0x03E00000
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE0_1 IPU_REGISTERS_OFFSET+0x00058108,0x001F0000
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE2_0 IPU_REGISTERS_OFFSET+0x00058108,0x00007C00
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE1_0 IPU_REGISTERS_OFFSET+0x00058108,0x000003E0
#define IPU_DC_MAP_CONF_0__MAPPING_PNTR_BYTE0_0 IPU_REGISTERS_OFFSET+0x00058108,0x0000001F

#define IPU_DC_MAP_CONF_1__ADDR                 IPU_REGISTERS_OFFSET+0x0005810C
#define IPU_DC_MAP_CONF_1__EMPTY                IPU_REGISTERS_OFFSET+0x0005810C,0x00000000
#define IPU_DC_MAP_CONF_1__FULL                 IPU_REGISTERS_OFFSET+0x0005810C,0xffffffff
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE2_3 IPU_REGISTERS_OFFSET+0x0005810C,0x7C000000
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE1_3 IPU_REGISTERS_OFFSET+0x0005810C,0x03E00000
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE0_3 IPU_REGISTERS_OFFSET+0x0005810C,0x001F0000
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE2_2 IPU_REGISTERS_OFFSET+0x0005810C,0x00007C00
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE1_2 IPU_REGISTERS_OFFSET+0x0005810C,0x000003E0
#define IPU_DC_MAP_CONF_1__MAPPING_PNTR_BYTE0_2 IPU_REGISTERS_OFFSET+0x0005810C,0x0000001F

#define IPU_DC_MAP_CONF_2__ADDR                 IPU_REGISTERS_OFFSET+0x00058110
#define IPU_DC_MAP_CONF_2__EMPTY                IPU_REGISTERS_OFFSET+0x00058110,0x00000000
#define IPU_DC_MAP_CONF_2__FULL                 IPU_REGISTERS_OFFSET+0x00058110,0xffffffff
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE2_5 IPU_REGISTERS_OFFSET+0x00058110,0x7C000000
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE1_5 IPU_REGISTERS_OFFSET+0x00058110,0x03E00000
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE0_5 IPU_REGISTERS_OFFSET+0x00058110,0x001F0000
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE2_4 IPU_REGISTERS_OFFSET+0x00058110,0x00007C00
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE1_4 IPU_REGISTERS_OFFSET+0x00058110,0x000003E0
#define IPU_DC_MAP_CONF_2__MAPPING_PNTR_BYTE0_4 IPU_REGISTERS_OFFSET+0x00058110,0x0000001F

#define IPU_DC_MAP_CONF_3__ADDR                 IPU_REGISTERS_OFFSET+0x00058114
#define IPU_DC_MAP_CONF_3__EMPTY                IPU_REGISTERS_OFFSET+0x00058114,0x00000000
#define IPU_DC_MAP_CONF_3__FULL                 IPU_REGISTERS_OFFSET+0x00058114,0xffffffff
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE2_7 IPU_REGISTERS_OFFSET+0x00058114,0x7C000000
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE1_7 IPU_REGISTERS_OFFSET+0x00058114,0x03E00000
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE0_7 IPU_REGISTERS_OFFSET+0x00058114,0x001F0000
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE2_6 IPU_REGISTERS_OFFSET+0x00058114,0x00007C00
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE1_6 IPU_REGISTERS_OFFSET+0x00058114,0x000003E0
#define IPU_DC_MAP_CONF_3__MAPPING_PNTR_BYTE0_6 IPU_REGISTERS_OFFSET+0x00058114,0x0000001F

#define IPU_DC_MAP_CONF_4__ADDR                 IPU_REGISTERS_OFFSET+0x00058118
#define IPU_DC_MAP_CONF_4__EMPTY                IPU_REGISTERS_OFFSET+0x00058118,0x00000000
#define IPU_DC_MAP_CONF_4__FULL                 IPU_REGISTERS_OFFSET+0x00058118,0xffffffff
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE2_9 IPU_REGISTERS_OFFSET+0x00058118,0x7C000000
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE1_9 IPU_REGISTERS_OFFSET+0x00058118,0x03E00000
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE0_9 IPU_REGISTERS_OFFSET+0x00058118,0x001F0000
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE2_8 IPU_REGISTERS_OFFSET+0x00058118,0x00007C00
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE1_8 IPU_REGISTERS_OFFSET+0x00058118,0x000003E0
#define IPU_DC_MAP_CONF_4__MAPPING_PNTR_BYTE0_8 IPU_REGISTERS_OFFSET+0x00058118,0x0000001F

#define IPU_DC_MAP_CONF_5__ADDR                  IPU_REGISTERS_OFFSET+0x0005811C
#define IPU_DC_MAP_CONF_5__EMPTY                 IPU_REGISTERS_OFFSET+0x0005811C,0x00000000
#define IPU_DC_MAP_CONF_5__FULL                  IPU_REGISTERS_OFFSET+0x0005811C,0xffffffff
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE2_11 IPU_REGISTERS_OFFSET+0x0005811C,0x7C000000
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE1_11 IPU_REGISTERS_OFFSET+0x0005811C,0x03E00000
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE0_11 IPU_REGISTERS_OFFSET+0x0005811C,0x001F0000
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE2_10 IPU_REGISTERS_OFFSET+0x0005811C,0x00007C00
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE1_10 IPU_REGISTERS_OFFSET+0x0005811C,0x000003E0
#define IPU_DC_MAP_CONF_5__MAPPING_PNTR_BYTE0_10 IPU_REGISTERS_OFFSET+0x0005811C,0x0000001F

#define IPU_DC_MAP_CONF_6__ADDR                  IPU_REGISTERS_OFFSET+0x00058120
#define IPU_DC_MAP_CONF_6__EMPTY                 IPU_REGISTERS_OFFSET+0x00058120,0x00000000
#define IPU_DC_MAP_CONF_6__FULL                  IPU_REGISTERS_OFFSET+0x00058120,0xffffffff
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE2_13 IPU_REGISTERS_OFFSET+0x00058120,0x7C000000
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE1_13 IPU_REGISTERS_OFFSET+0x00058120,0x03E00000
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE0_13 IPU_REGISTERS_OFFSET+0x00058120,0x001F0000
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE2_12 IPU_REGISTERS_OFFSET+0x00058120,0x00007C00
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE1_12 IPU_REGISTERS_OFFSET+0x00058120,0x000003E0
#define IPU_DC_MAP_CONF_6__MAPPING_PNTR_BYTE0_12 IPU_REGISTERS_OFFSET+0x00058120,0x0000001F

#define IPU_DC_MAP_CONF_7__ADDR                  IPU_REGISTERS_OFFSET+0x00058124
#define IPU_DC_MAP_CONF_7__EMPTY                 IPU_REGISTERS_OFFSET+0x00058124,0x00000000
#define IPU_DC_MAP_CONF_7__FULL                  IPU_REGISTERS_OFFSET+0x00058124,0xffffffff
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE2_15 IPU_REGISTERS_OFFSET+0x00058124,0x7C000000
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE1_15 IPU_REGISTERS_OFFSET+0x00058124,0x03E00000
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE0_15 IPU_REGISTERS_OFFSET+0x00058124,0x001F0000
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE2_14 IPU_REGISTERS_OFFSET+0x00058124,0x00007C00
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE1_14 IPU_REGISTERS_OFFSET+0x00058124,0x000003E0
#define IPU_DC_MAP_CONF_7__MAPPING_PNTR_BYTE0_14 IPU_REGISTERS_OFFSET+0x00058124,0x0000001F

#define IPU_DC_MAP_CONF_8__ADDR                  IPU_REGISTERS_OFFSET+0x00058128
#define IPU_DC_MAP_CONF_8__EMPTY                 IPU_REGISTERS_OFFSET+0x00058128,0x00000000
#define IPU_DC_MAP_CONF_8__FULL                  IPU_REGISTERS_OFFSET+0x00058128,0xffffffff
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE2_17 IPU_REGISTERS_OFFSET+0x00058128,0x7C000000
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE1_17 IPU_REGISTERS_OFFSET+0x00058128,0x03E00000
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE0_17 IPU_REGISTERS_OFFSET+0x00058128,0x001F0000
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE2_16 IPU_REGISTERS_OFFSET+0x00058128,0x00007C00
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE1_16 IPU_REGISTERS_OFFSET+0x00058128,0x000003E0
#define IPU_DC_MAP_CONF_8__MAPPING_PNTR_BYTE0_16 IPU_REGISTERS_OFFSET+0x00058128,0x0000001F

#define IPU_DC_MAP_CONF_9__ADDR                  IPU_REGISTERS_OFFSET+0x0005812C
#define IPU_DC_MAP_CONF_9__EMPTY                 IPU_REGISTERS_OFFSET+0x0005812C,0x00000000
#define IPU_DC_MAP_CONF_9__FULL                  IPU_REGISTERS_OFFSET+0x0005812C,0xffffffff
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE2_19 IPU_REGISTERS_OFFSET+0x0005812C,0x7C000000
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE1_19 IPU_REGISTERS_OFFSET+0x0005812C,0x03E00000
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE0_19 IPU_REGISTERS_OFFSET+0x0005812C,0x001F0000
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE2_18 IPU_REGISTERS_OFFSET+0x0005812C,0x00007C00
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE1_18 IPU_REGISTERS_OFFSET+0x0005812C,0x000003E0
#define IPU_DC_MAP_CONF_9__MAPPING_PNTR_BYTE0_18 IPU_REGISTERS_OFFSET+0x0005812C,0x0000001F

#define IPU_DC_MAP_CONF_10__ADDR                  IPU_REGISTERS_OFFSET+0x00058130
#define IPU_DC_MAP_CONF_10__EMPTY                 IPU_REGISTERS_OFFSET+0x00058130,0x00000000
#define IPU_DC_MAP_CONF_10__FULL                  IPU_REGISTERS_OFFSET+0x00058130,0xffffffff
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE2_21 IPU_REGISTERS_OFFSET+0x00058130,0x7C000000
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE1_21 IPU_REGISTERS_OFFSET+0x00058130,0x03E00000
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE0_21 IPU_REGISTERS_OFFSET+0x00058130,0x001F0000
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE2_20 IPU_REGISTERS_OFFSET+0x00058130,0x00007C00
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE1_20 IPU_REGISTERS_OFFSET+0x00058130,0x000003E0
#define IPU_DC_MAP_CONF_10__MAPPING_PNTR_BYTE0_20 IPU_REGISTERS_OFFSET+0x00058130,0x0000001F

#define IPU_DC_MAP_CONF_11__ADDR                  IPU_REGISTERS_OFFSET+0x00058134
#define IPU_DC_MAP_CONF_11__EMPTY                 IPU_REGISTERS_OFFSET+0x00058134,0x00000000
#define IPU_DC_MAP_CONF_11__FULL                  IPU_REGISTERS_OFFSET+0x00058134,0xffffffff
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE2_23 IPU_REGISTERS_OFFSET+0x00058134,0x7C000000
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE1_23 IPU_REGISTERS_OFFSET+0x00058134,0x03E00000
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE0_23 IPU_REGISTERS_OFFSET+0x00058134,0x001F0000
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE2_22 IPU_REGISTERS_OFFSET+0x00058134,0x00007C00
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE1_22 IPU_REGISTERS_OFFSET+0x00058134,0x000003E0
#define IPU_DC_MAP_CONF_11__MAPPING_PNTR_BYTE0_22 IPU_REGISTERS_OFFSET+0x00058134,0x0000001F

#define IPU_DC_MAP_CONF_12__ADDR                  IPU_REGISTERS_OFFSET+0x00058138
#define IPU_DC_MAP_CONF_12__EMPTY                 IPU_REGISTERS_OFFSET+0x00058138,0x00000000
#define IPU_DC_MAP_CONF_12__FULL                  IPU_REGISTERS_OFFSET+0x00058138,0xffffffff
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE2_25 IPU_REGISTERS_OFFSET+0x00058138,0x7C000000
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE1_25 IPU_REGISTERS_OFFSET+0x00058138,0x03E00000
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE0_25 IPU_REGISTERS_OFFSET+0x00058138,0x001F0000
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE2_24 IPU_REGISTERS_OFFSET+0x00058138,0x00007C00
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE1_24 IPU_REGISTERS_OFFSET+0x00058138,0x000003E0
#define IPU_DC_MAP_CONF_12__MAPPING_PNTR_BYTE0_24 IPU_REGISTERS_OFFSET+0x00058138,0x0000001F

#define IPU_DC_MAP_CONF_13__ADDR                  IPU_REGISTERS_OFFSET+0x0005813C
#define IPU_DC_MAP_CONF_13__EMPTY                 IPU_REGISTERS_OFFSET+0x0005813C,0x00000000
#define IPU_DC_MAP_CONF_13__FULL                  IPU_REGISTERS_OFFSET+0x0005813C,0xffffffff
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE2_27 IPU_REGISTERS_OFFSET+0x0005813C,0x7C000000
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE1_27 IPU_REGISTERS_OFFSET+0x0005813C,0x03E00000
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE0_27 IPU_REGISTERS_OFFSET+0x0005813C,0x001F0000
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE2_26 IPU_REGISTERS_OFFSET+0x0005813C,0x00007C00
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE1_26 IPU_REGISTERS_OFFSET+0x0005813C,0x000003E0
#define IPU_DC_MAP_CONF_13__MAPPING_PNTR_BYTE0_26 IPU_REGISTERS_OFFSET+0x0005813C,0x0000001F

#define IPU_DC_MAP_CONF_14__ADDR                  IPU_REGISTERS_OFFSET+0x00058140
#define IPU_DC_MAP_CONF_14__EMPTY                 IPU_REGISTERS_OFFSET+0x00058140,0x00000000
#define IPU_DC_MAP_CONF_14__FULL                  IPU_REGISTERS_OFFSET+0x00058140,0xffffffff
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE2_29 IPU_REGISTERS_OFFSET+0x00058140,0x7C000000
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE1_29 IPU_REGISTERS_OFFSET+0x00058140,0x03E00000
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE0_29 IPU_REGISTERS_OFFSET+0x00058140,0x001F0000
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE2_28 IPU_REGISTERS_OFFSET+0x00058140,0x00007C00
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE1_28 IPU_REGISTERS_OFFSET+0x00058140,0x000003E0
#define IPU_DC_MAP_CONF_14__MAPPING_PNTR_BYTE0_28 IPU_REGISTERS_OFFSET+0x00058140,0x0000001F

#define IPU_DC_MAP_CONF_15__ADDR        IPU_REGISTERS_OFFSET+0x00058144
#define IPU_DC_MAP_CONF_15__EMPTY       IPU_REGISTERS_OFFSET+0x00058144,0x00000000
#define IPU_DC_MAP_CONF_15__FULL        IPU_REGISTERS_OFFSET+0x00058144,0xffffffff
#define IPU_DC_MAP_CONF_15__MD_OFFSET_1 IPU_REGISTERS_OFFSET+0x00058144,0x1F000000
#define IPU_DC_MAP_CONF_15__MD_MASK_1   IPU_REGISTERS_OFFSET+0x00058144,0x00FF0000
#define IPU_DC_MAP_CONF_15__MD_OFFSET_0 IPU_REGISTERS_OFFSET+0x00058144,0x00001F00
#define IPU_DC_MAP_CONF_15__MD_MASK_0   IPU_REGISTERS_OFFSET+0x00058144,0x000000FF

#define IPU_DC_MAP_CONF_16__ADDR        IPU_REGISTERS_OFFSET+0x00058148
#define IPU_DC_MAP_CONF_16__EMPTY       IPU_REGISTERS_OFFSET+0x00058148,0x00000000
#define IPU_DC_MAP_CONF_16__FULL        IPU_REGISTERS_OFFSET+0x00058148,0xffffffff
#define IPU_DC_MAP_CONF_16__MD_OFFSET_3 IPU_REGISTERS_OFFSET+0x00058148,0x1F000000
#define IPU_DC_MAP_CONF_16__MD_MASK_3   IPU_REGISTERS_OFFSET+0x00058148,0x00FF0000
#define IPU_DC_MAP_CONF_16__MD_OFFSET_2 IPU_REGISTERS_OFFSET+0x00058148,0x00001F00
#define IPU_DC_MAP_CONF_16__MD_MASK_2   IPU_REGISTERS_OFFSET+0x00058148,0x000000FF

#define IPU_DC_MAP_CONF_17__ADDR        IPU_REGISTERS_OFFSET+0x0005814C
#define IPU_DC_MAP_CONF_17__EMPTY       IPU_REGISTERS_OFFSET+0x0005814C,0x00000000
#define IPU_DC_MAP_CONF_17__FULL        IPU_REGISTERS_OFFSET+0x0005814C,0xffffffff
#define IPU_DC_MAP_CONF_17__MD_OFFSET_5 IPU_REGISTERS_OFFSET+0x0005814C,0x1F000000
#define IPU_DC_MAP_CONF_17__MD_MASK_5   IPU_REGISTERS_OFFSET+0x0005814C,0x00FF0000
#define IPU_DC_MAP_CONF_17__MD_OFFSET_4 IPU_REGISTERS_OFFSET+0x0005814C,0x00001F00
#define IPU_DC_MAP_CONF_17__MD_MASK_4   IPU_REGISTERS_OFFSET+0x0005814C,0x000000FF

#define IPU_DC_MAP_CONF_18__ADDR        IPU_REGISTERS_OFFSET+0x00058150
#define IPU_DC_MAP_CONF_18__EMPTY       IPU_REGISTERS_OFFSET+0x00058150,0x00000000
#define IPU_DC_MAP_CONF_18__FULL        IPU_REGISTERS_OFFSET+0x00058150,0xffffffff
#define IPU_DC_MAP_CONF_18__MD_OFFSET_7 IPU_REGISTERS_OFFSET+0x00058150,0x1F000000
#define IPU_DC_MAP_CONF_18__MD_MASK_7   IPU_REGISTERS_OFFSET+0x00058150,0x00FF0000
#define IPU_DC_MAP_CONF_18__MD_OFFSET_6 IPU_REGISTERS_OFFSET+0x00058150,0x00001F00
#define IPU_DC_MAP_CONF_18__MD_MASK_6   IPU_REGISTERS_OFFSET+0x00058150,0x000000FF

#define IPU_DC_MAP_CONF_19__ADDR        IPU_REGISTERS_OFFSET+0x00058154
#define IPU_DC_MAP_CONF_19__EMPTY       IPU_REGISTERS_OFFSET+0x00058154,0x00000000
#define IPU_DC_MAP_CONF_19__FULL        IPU_REGISTERS_OFFSET+0x00058154,0xffffffff
#define IPU_DC_MAP_CONF_19__MD_OFFSET_9 IPU_REGISTERS_OFFSET+0x00058154,0x1F000000
#define IPU_DC_MAP_CONF_19__MD_MASK_9   IPU_REGISTERS_OFFSET+0x00058154,0x00FF0000
#define IPU_DC_MAP_CONF_19__MD_OFFSET_8 IPU_REGISTERS_OFFSET+0x00058154,0x00001F00
#define IPU_DC_MAP_CONF_19__MD_MASK_8   IPU_REGISTERS_OFFSET+0x00058154,0x000000FF

#define IPU_DC_MAP_CONF_20__ADDR         IPU_REGISTERS_OFFSET+0x00058158
#define IPU_DC_MAP_CONF_20__EMPTY        IPU_REGISTERS_OFFSET+0x00058158,0x00000000
#define IPU_DC_MAP_CONF_20__FULL         IPU_REGISTERS_OFFSET+0x00058158,0xffffffff
#define IPU_DC_MAP_CONF_20__MD_OFFSET_11 IPU_REGISTERS_OFFSET+0x00058158,0x1F000000
#define IPU_DC_MAP_CONF_20__MD_MASK_11   IPU_REGISTERS_OFFSET+0x00058158,0x00FF0000
#define IPU_DC_MAP_CONF_20__MD_OFFSET_10 IPU_REGISTERS_OFFSET+0x00058158,0x00001F00
#define IPU_DC_MAP_CONF_20__MD_MASK_10   IPU_REGISTERS_OFFSET+0x00058158,0x000000FF

#define IPU_DC_MAP_CONF_21__ADDR         IPU_REGISTERS_OFFSET+0x0005815C
#define IPU_DC_MAP_CONF_21__EMPTY        IPU_REGISTERS_OFFSET+0x0005815C,0x00000000
#define IPU_DC_MAP_CONF_21__FULL         IPU_REGISTERS_OFFSET+0x0005815C,0xffffffff
#define IPU_DC_MAP_CONF_21__MD_OFFSET_13 IPU_REGISTERS_OFFSET+0x0005815C,0x1F000000
#define IPU_DC_MAP_CONF_21__MD_MASK_13   IPU_REGISTERS_OFFSET+0x0005815C,0x00FF0000
#define IPU_DC_MAP_CONF_21__MD_OFFSET_12 IPU_REGISTERS_OFFSET+0x0005815C,0x00001F00
#define IPU_DC_MAP_CONF_21__MD_MASK_12   IPU_REGISTERS_OFFSET+0x0005815C,0x000000FF

#define IPU_DC_MAP_CONF_22__ADDR         IPU_REGISTERS_OFFSET+0x00058160
#define IPU_DC_MAP_CONF_22__EMPTY        IPU_REGISTERS_OFFSET+0x00058160,0x00000000
#define IPU_DC_MAP_CONF_22__FULL         IPU_REGISTERS_OFFSET+0x00058160,0xffffffff
#define IPU_DC_MAP_CONF_22__MD_OFFSET_15 IPU_REGISTERS_OFFSET+0x00058160,0x1F000000
#define IPU_DC_MAP_CONF_22__MD_MASK_15   IPU_REGISTERS_OFFSET+0x00058160,0x00FF0000
#define IPU_DC_MAP_CONF_22__MD_OFFSET_14 IPU_REGISTERS_OFFSET+0x00058160,0x00001F00
#define IPU_DC_MAP_CONF_22__MD_MASK_14   IPU_REGISTERS_OFFSET+0x00058160,0x000000FF

#define IPU_DC_MAP_CONF_23__ADDR         IPU_REGISTERS_OFFSET+0x00058164
#define IPU_DC_MAP_CONF_23__EMPTY        IPU_REGISTERS_OFFSET+0x00058164,0x00000000
#define IPU_DC_MAP_CONF_23__FULL         IPU_REGISTERS_OFFSET+0x00058164,0xffffffff
#define IPU_DC_MAP_CONF_23__MD_OFFSET_17 IPU_REGISTERS_OFFSET+0x00058164,0x1F000000
#define IPU_DC_MAP_CONF_23__MD_MASK_17   IPU_REGISTERS_OFFSET+0x00058164,0x00FF0000
#define IPU_DC_MAP_CONF_23__MD_OFFSET_16 IPU_REGISTERS_OFFSET+0x00058164,0x00001F00
#define IPU_DC_MAP_CONF_23__MD_MASK_16   IPU_REGISTERS_OFFSET+0x00058164,0x000000FF

#define IPU_DC_MAP_CONF_24__ADDR         IPU_REGISTERS_OFFSET+0x00058168
#define IPU_DC_MAP_CONF_24__EMPTY        IPU_REGISTERS_OFFSET+0x00058168,0x00000000
#define IPU_DC_MAP_CONF_24__FULL         IPU_REGISTERS_OFFSET+0x00058168,0xffffffff
#define IPU_DC_MAP_CONF_24__MD_OFFSET_19 IPU_REGISTERS_OFFSET+0x00058168,0x1F000000
#define IPU_DC_MAP_CONF_24__MD_MASK_19   IPU_REGISTERS_OFFSET+0x00058168,0x00FF0000
#define IPU_DC_MAP_CONF_24__MD_OFFSET_18 IPU_REGISTERS_OFFSET+0x00058168,0x00001F00
#define IPU_DC_MAP_CONF_24__MD_MASK_18   IPU_REGISTERS_OFFSET+0x00058168,0x000000FF

#define IPU_DC_MAP_CONF_25__ADDR         IPU_REGISTERS_OFFSET+0x0005816C
#define IPU_DC_MAP_CONF_25__EMPTY        IPU_REGISTERS_OFFSET+0x0005816C,0x00000000
#define IPU_DC_MAP_CONF_25__FULL         IPU_REGISTERS_OFFSET+0x0005816C,0xffffffff
#define IPU_DC_MAP_CONF_25__MD_OFFSET_21 IPU_REGISTERS_OFFSET+0x0005816C,0x1F000000
#define IPU_DC_MAP_CONF_25__MD_MASK_21   IPU_REGISTERS_OFFSET+0x0005816C,0x00FF0000
#define IPU_DC_MAP_CONF_25__MD_OFFSET_20 IPU_REGISTERS_OFFSET+0x0005816C,0x00001F00
#define IPU_DC_MAP_CONF_25__MD_MASK_20   IPU_REGISTERS_OFFSET+0x0005816C,0x000000FF

#define IPU_DC_MAP_CONF_26__ADDR         IPU_REGISTERS_OFFSET+0x00058170
#define IPU_DC_MAP_CONF_26__EMPTY        IPU_REGISTERS_OFFSET+0x00058170,0x00000000
#define IPU_DC_MAP_CONF_26__FULL         IPU_REGISTERS_OFFSET+0x00058170,0xffffffff
#define IPU_DC_MAP_CONF_26__MD_OFFSET_23 IPU_REGISTERS_OFFSET+0x00058170,0x1F000000
#define IPU_DC_MAP_CONF_26__MD_MASK_23   IPU_REGISTERS_OFFSET+0x00058170,0x00FF0000
#define IPU_DC_MAP_CONF_26__MD_OFFSET_22 IPU_REGISTERS_OFFSET+0x00058170,0x00001F00
#define IPU_DC_MAP_CONF_26__MD_MASK_22   IPU_REGISTERS_OFFSET+0x00058170,0x000000FF

#define IPU_DC_UGDE0_0__ADDR              IPU_REGISTERS_OFFSET+0x00058174
#define IPU_DC_UGDE0_0__EMPTY             IPU_REGISTERS_OFFSET+0x00058174,0x00000000
#define IPU_DC_UGDE0_0__FULL              IPU_REGISTERS_OFFSET+0x00058174,0xffffffff
#define IPU_DC_UGDE0_0__NF_NL_0           IPU_REGISTERS_OFFSET+0x00058174,0x18000000
#define IPU_DC_UGDE0_0__AUTORESTART_0     IPU_REGISTERS_OFFSET+0x00058174,0x04000000
#define IPU_DC_UGDE0_0__ODD_EN_0          IPU_REGISTERS_OFFSET+0x00058174,0x02000000
#define IPU_DC_UGDE0_0__COD_ODD_START_0   IPU_REGISTERS_OFFSET+0x00058174,0x00FF0000
#define IPU_DC_UGDE0_0__COD_EV_START_0    IPU_REGISTERS_OFFSET+0x00058174,0x0000FF00
#define IPU_DC_UGDE0_0__COD_EV_PRIORITY_0 IPU_REGISTERS_OFFSET+0x00058174,0x00000078
#define IPU_DC_UGDE0_0__ID_CODED_0        IPU_REGISTERS_OFFSET+0x00058174,0x00000007

#define IPU_DC_UGDE0_1__ADDR   IPU_REGISTERS_OFFSET+0x00058178
#define IPU_DC_UGDE0_1__EMPTY  IPU_REGISTERS_OFFSET+0x00058178,0x00000000
#define IPU_DC_UGDE0_1__FULL   IPU_REGISTERS_OFFSET+0x00058178,0xffffffff
#define IPU_DC_UGDE0_1__STEP_0 IPU_REGISTERS_OFFSET+0x00058178,0x1FFFFFFF

#define IPU_DC_UGDE0_2__ADDR        IPU_REGISTERS_OFFSET+0x0005817C
#define IPU_DC_UGDE0_2__EMPTY       IPU_REGISTERS_OFFSET+0x0005817C,0x00000000
#define IPU_DC_UGDE0_2__FULL        IPU_REGISTERS_OFFSET+0x0005817C,0xffffffff
#define IPU_DC_UGDE0_2__OFFSET_DT_0 IPU_REGISTERS_OFFSET+0x0005817C,0x1FFFFFFF

#define IPU_DC_UGDE0_3__ADDR          IPU_REGISTERS_OFFSET+0x00058180
#define IPU_DC_UGDE0_3__EMPTY         IPU_REGISTERS_OFFSET+0x00058180,0x00000000
#define IPU_DC_UGDE0_3__FULL          IPU_REGISTERS_OFFSET+0x00058180,0xffffffff
#define IPU_DC_UGDE0_3__STEP_REPEAT_0 IPU_REGISTERS_OFFSET+0x00058180,0x1FFFFFFF

#define IPU_DC_UGDE1_0__ADDR              IPU_REGISTERS_OFFSET+0x00058184
#define IPU_DC_UGDE1_0__EMPTY             IPU_REGISTERS_OFFSET+0x00058184,0x00000000
#define IPU_DC_UGDE1_0__FULL              IPU_REGISTERS_OFFSET+0x00058184,0xffffffff
#define IPU_DC_UGDE1_0__NF_NL_1           IPU_REGISTERS_OFFSET+0x00058184,0x18000000
#define IPU_DC_UGDE1_0__AUTORESTART_1     IPU_REGISTERS_OFFSET+0x00058184,0x04000000
#define IPU_DC_UGDE1_0__ODD_EN_1          IPU_REGISTERS_OFFSET+0x00058184,0x02000000
#define IPU_DC_UGDE1_0__COD_ODD_START_1   IPU_REGISTERS_OFFSET+0x00058184,0x00FF0000
#define IPU_DC_UGDE1_0__COD_EV_START_1    IPU_REGISTERS_OFFSET+0x00058184,0x00007F80
#define IPU_DC_UGDE1_0__COD_EV_PRIORITY_1 IPU_REGISTERS_OFFSET+0x00058184,0x00000078
#define IPU_DC_UGDE1_0__ID_CODED_1        IPU_REGISTERS_OFFSET+0x00058184,0x00000007

#define IPU_DC_UGDE1_1__ADDR   IPU_REGISTERS_OFFSET+0x00058188
#define IPU_DC_UGDE1_1__EMPTY  IPU_REGISTERS_OFFSET+0x00058188,0x00000000
#define IPU_DC_UGDE1_1__FULL   IPU_REGISTERS_OFFSET+0x00058188,0xffffffff
#define IPU_DC_UGDE1_1__STEP_1 IPU_REGISTERS_OFFSET+0x00058188,0x1FFFFFFF

#define IPU_DC_UGDE1_2__ADDR        IPU_REGISTERS_OFFSET+0x0005818C
#define IPU_DC_UGDE1_2__EMPTY       IPU_REGISTERS_OFFSET+0x0005818C,0x00000000
#define IPU_DC_UGDE1_2__FULL        IPU_REGISTERS_OFFSET+0x0005818C,0xffffffff
#define IPU_DC_UGDE1_2__OFFSET_DT_1 IPU_REGISTERS_OFFSET+0x0005818C,0x1FFFFFFF

#define IPU_DC_UGDE1_3__ADDR          IPU_REGISTERS_OFFSET+0x00058190
#define IPU_DC_UGDE1_3__EMPTY         IPU_REGISTERS_OFFSET+0x00058190,0x00000000
#define IPU_DC_UGDE1_3__FULL          IPU_REGISTERS_OFFSET+0x00058190,0xffffffff
#define IPU_DC_UGDE1_3__STEP_REPEAT_1 IPU_REGISTERS_OFFSET+0x00058190,0x1FFFFFFF

#define IPU_DC_UGDE2_0__ADDR              IPU_REGISTERS_OFFSET+0x00058194
#define IPU_DC_UGDE2_0__EMPTY             IPU_REGISTERS_OFFSET+0x00058194,0x00000000
#define IPU_DC_UGDE2_0__FULL              IPU_REGISTERS_OFFSET+0x00058194,0xffffffff
#define IPU_DC_UGDE2_0__NF_NL_2           IPU_REGISTERS_OFFSET+0x00058194,0x18000000
#define IPU_DC_UGDE2_0__AUTORESTART_2     IPU_REGISTERS_OFFSET+0x00058194,0x04000000
#define IPU_DC_UGDE2_0__ODD_EN_2          IPU_REGISTERS_OFFSET+0x00058194,0x02000000
#define IPU_DC_UGDE2_0__COD_ODD_START_2   IPU_REGISTERS_OFFSET+0x00058194,0x00FF0000
#define IPU_DC_UGDE2_0__COD_EV_START_2    IPU_REGISTERS_OFFSET+0x00058194,0x00007F80
#define IPU_DC_UGDE2_0__COD_EV_PRIORITY_2 IPU_REGISTERS_OFFSET+0x00058194,0x00000078
#define IPU_DC_UGDE2_0__ID_CODED_2        IPU_REGISTERS_OFFSET+0x00058194,0x00000007

#define IPU_DC_UGDE2_1__ADDR   IPU_REGISTERS_OFFSET+0x00058198
#define IPU_DC_UGDE2_1__EMPTY  IPU_REGISTERS_OFFSET+0x00058198,0x00000000
#define IPU_DC_UGDE2_1__FULL   IPU_REGISTERS_OFFSET+0x00058198,0xffffffff
#define IPU_DC_UGDE2_1__STEP_2 IPU_REGISTERS_OFFSET+0x00058198,0x1FFFFFFF

#define IPU_DC_UGDE2_2__ADDR        IPU_REGISTERS_OFFSET+0x0005819C
#define IPU_DC_UGDE2_2__EMPTY       IPU_REGISTERS_OFFSET+0x0005819C,0x00000000
#define IPU_DC_UGDE2_2__FULL        IPU_REGISTERS_OFFSET+0x0005819C,0xffffffff
#define IPU_DC_UGDE2_2__OFFSET_DT_2 IPU_REGISTERS_OFFSET+0x0005819C,0x1FFFFFFF

#define IPU_DC_UGDE2_3__ADDR          IPU_REGISTERS_OFFSET+0x000581A0
#define IPU_DC_UGDE2_3__EMPTY         IPU_REGISTERS_OFFSET+0x000581A0,0x00000000
#define IPU_DC_UGDE2_3__FULL          IPU_REGISTERS_OFFSET+0x000581A0,0xffffffff
#define IPU_DC_UGDE2_3__STEP_REPEAT_2 IPU_REGISTERS_OFFSET+0x000581A0,0x1FFFFFFF

#define IPU_DC_UGDE3_0__ADDR              IPU_REGISTERS_OFFSET+0x000581A4
#define IPU_DC_UGDE3_0__EMPTY             IPU_REGISTERS_OFFSET+0x000581A4,0x00000000
#define IPU_DC_UGDE3_0__FULL              IPU_REGISTERS_OFFSET+0x000581A4,0xffffffff
#define IPU_DC_UGDE3_0__NF_NL_3           IPU_REGISTERS_OFFSET+0x000581A4,0x18000000
#define IPU_DC_UGDE3_0__AUTORESTART_3     IPU_REGISTERS_OFFSET+0x000581A4,0x04000000
#define IPU_DC_UGDE3_0__ODD_EN_3          IPU_REGISTERS_OFFSET+0x000581A4,0x02000000
#define IPU_DC_UGDE3_0__COD_ODD_START_3   IPU_REGISTERS_OFFSET+0x000581A4,0x00FF0000
#define IPU_DC_UGDE3_0__COD_EV_START_3    IPU_REGISTERS_OFFSET+0x000581A4,0x00007F80
#define IPU_DC_UGDE3_0__COD_EV_PRIORITY_3 IPU_REGISTERS_OFFSET+0x000581A4,0x00000078
#define IPU_DC_UGDE3_0__ID_CODED_3        IPU_REGISTERS_OFFSET+0x000581A4,0x00000007

#define IPU_DC_UGDE3_1__ADDR   IPU_REGISTERS_OFFSET+0x000581A8
#define IPU_DC_UGDE3_1__EMPTY  IPU_REGISTERS_OFFSET+0x000581A8,0x00000000
#define IPU_DC_UGDE3_1__FULL   IPU_REGISTERS_OFFSET+0x000581A8,0xffffffff
#define IPU_DC_UGDE3_1__STEP_3 IPU_REGISTERS_OFFSET+0x000581A8,0x1FFFFFFF

#define IPU_DC_UGDE3_2__ADDR        IPU_REGISTERS_OFFSET+0x000581AC
#define IPU_DC_UGDE3_2__EMPTY       IPU_REGISTERS_OFFSET+0x000581AC,0x00000000
#define IPU_DC_UGDE3_2__FULL        IPU_REGISTERS_OFFSET+0x000581AC,0xffffffff
#define IPU_DC_UGDE3_2__OFFSET_DT_3 IPU_REGISTERS_OFFSET+0x000581AC,0x1FFFFFFF

#define IPU_DC_UGDE3_3__ADDR          IPU_REGISTERS_OFFSET+0x000581B0
#define IPU_DC_UGDE3_3__EMPTY         IPU_REGISTERS_OFFSET+0x000581B0,0x00000000
#define IPU_DC_UGDE3_3__FULL          IPU_REGISTERS_OFFSET+0x000581B0,0xffffffff
#define IPU_DC_UGDE3_3__STEP_REPEAT_3 IPU_REGISTERS_OFFSET+0x000581B0,0x1FFFFFFF

#define IPU_DC_LLA0__ADDR       IPU_REGISTERS_OFFSET+0x000581B4
#define IPU_DC_LLA0__EMPTY      IPU_REGISTERS_OFFSET+0x000581B4,0x00000000
#define IPU_DC_LLA0__FULL       IPU_REGISTERS_OFFSET+0x000581B4,0xffffffff
#define IPU_DC_LLA0__MCU_RS_3_0 IPU_REGISTERS_OFFSET+0x000581B4,0xFF000000
#define IPU_DC_LLA0__MCU_RS_2_0 IPU_REGISTERS_OFFSET+0x000581B4,0x00FF0000
#define IPU_DC_LLA0__MCU_RS_1_0 IPU_REGISTERS_OFFSET+0x000581B4,0x0000FF00
#define IPU_DC_LLA0__MCU_RS_0_0 IPU_REGISTERS_OFFSET+0x000581B4,0x000000FF

#define IPU_DC_LLA1__ADDR       IPU_REGISTERS_OFFSET+0x000581B8
#define IPU_DC_LLA1__EMPTY      IPU_REGISTERS_OFFSET+0x000581B8,0x00000000
#define IPU_DC_LLA1__FULL       IPU_REGISTERS_OFFSET+0x000581B8,0xffffffff
#define IPU_DC_LLA1__MCU_RS_3_1 IPU_REGISTERS_OFFSET+0x000581B8,0xFF000000
#define IPU_DC_LLA1__MCU_RS_2_1 IPU_REGISTERS_OFFSET+0x000581B8,0x00FF0000
#define IPU_DC_LLA1__MCU_RS_1_1 IPU_REGISTERS_OFFSET+0x000581B8,0x0000FF00
#define IPU_DC_LLA1__MCU_RS_0_1 IPU_REGISTERS_OFFSET+0x000581B8,0x000000FF

#define IPU_DC_R_LLA0__ADDR         IPU_REGISTERS_OFFSET+0x000581BC
#define IPU_DC_R_LLA0__EMPTY        IPU_REGISTERS_OFFSET+0x000581BC,0x00000000
#define IPU_DC_R_LLA0__FULL         IPU_REGISTERS_OFFSET+0x000581BC,0xffffffff
#define IPU_DC_R_LLA0__MCU_RS_R_3_0 IPU_REGISTERS_OFFSET+0x000581BC,0xFF000000
#define IPU_DC_R_LLA0__MCU_RS_R_2_0 IPU_REGISTERS_OFFSET+0x000581BC,0x00FF0000
#define IPU_DC_R_LLA0__MCU_RS_R_1_0 IPU_REGISTERS_OFFSET+0x000581BC,0x0000FF00
#define IPU_DC_R_LLA0__MCU_RS_R_0_0 IPU_REGISTERS_OFFSET+0x000581BC,0x000000FF

#define IPU_DC_R_LLA1__ADDR         IPU_REGISTERS_OFFSET+0x000581C0
#define IPU_DC_R_LLA1__EMPTY        IPU_REGISTERS_OFFSET+0x000581C0,0x00000000
#define IPU_DC_R_LLA1__FULL         IPU_REGISTERS_OFFSET+0x000581C0,0xffffffff
#define IPU_DC_R_LLA1__MCU_RS_R_3_1 IPU_REGISTERS_OFFSET+0x000581C0,0xFF000000
#define IPU_DC_R_LLA1__MCU_RS_R_2_1 IPU_REGISTERS_OFFSET+0x000581C0,0x00FF0000
#define IPU_DC_R_LLA1__MCU_RS_R_1_1 IPU_REGISTERS_OFFSET+0x000581C0,0x0000FF00
#define IPU_DC_R_LLA1__MCU_RS_R_0_1 IPU_REGISTERS_OFFSET+0x000581C0,0x000000FF

#define IPU_DC_WR_CH_ADDR_5_ALT__ADDR          IPU_REGISTERS_OFFSET+0x000581C4
#define IPU_DC_WR_CH_ADDR_5_ALT__EMPTY         IPU_REGISTERS_OFFSET+0x000581C4,0x00000000
#define IPU_DC_WR_CH_ADDR_5_ALT__FULL          IPU_REGISTERS_OFFSET+0x000581C4,0xffffffff
#define IPU_DC_WR_CH_ADDR_5_ALT__ST_ADDR_5_ALT IPU_REGISTERS_OFFSET+0x000581C4,0x1FFFFFFF

#define IPU_DC_STAT__ADDR                       IPU_REGISTERS_OFFSET+0x000581C8
#define IPU_DC_STAT__EMPTY                      IPU_REGISTERS_OFFSET+0x000581C8,0x00000000
#define IPU_DC_STAT__FULL                       IPU_REGISTERS_OFFSET+0x000581C8,0xffffffff
#define IPU_DC_STAT__DC_TRIPLE_BUF_DATA_EMPTY_1 IPU_REGISTERS_OFFSET+0x000581C8,0x00000080
#define IPU_DC_STAT__DC_TRIPLE_BUF_DATA_FULL_1  IPU_REGISTERS_OFFSET+0x000581C8,0x00000040
#define IPU_DC_STAT__DC_TRIPLE_BUF_CNT_EMPTY_1  IPU_REGISTERS_OFFSET+0x000581C8,0x00000020
#define IPU_DC_STAT__DC_TRIPLE_BUF_CNT_FULL_1   IPU_REGISTERS_OFFSET+0x000581C8,0x00000010
#define IPU_DC_STAT__DC_TRIPLE_BUF_DATA_EMPTY_0 IPU_REGISTERS_OFFSET+0x000581C8,0x00000008
#define IPU_DC_STAT__DC_TRIPLE_BUF_DATA_FULL_0  IPU_REGISTERS_OFFSET+0x000581C8,0x00000004
#define IPU_DC_STAT__DC_TRIPLE_BUF_CNT_EMPTY_0  IPU_REGISTERS_OFFSET+0x000581C8,0x00000002
#define IPU_DC_STAT__DC_TRIPLE_BUF_CNT_FULL_0   IPU_REGISTERS_OFFSET+0x000581C8,0x00000001

#define IPU_DMFC_RD_CHAN__ADDR              IPU_REGISTERS_OFFSET+0x00060000
#define IPU_DMFC_RD_CHAN__EMPTY             IPU_REGISTERS_OFFSET+0x00060000,0x00000000
#define IPU_DMFC_RD_CHAN__FULL              IPU_REGISTERS_OFFSET+0x00060000,0xffffffff
#define IPU_DMFC_RD_CHAN__DMFC_PPW_C        IPU_REGISTERS_OFFSET+0x00060000,0x03000000
#define IPU_DMFC_RD_CHAN__DMFC_WM_CLR_0     IPU_REGISTERS_OFFSET+0x00060000,0x00E00000
#define IPU_DMFC_RD_CHAN__DMFC_WM_SET_0     IPU_REGISTERS_OFFSET+0x00060000,0x001C0000
#define IPU_DMFC_RD_CHAN__DMFC_WM_EN_0      IPU_REGISTERS_OFFSET+0x00060000,0x00020000
#define IPU_DMFC_RD_CHAN__DMFC_BURST_SIZE_0 IPU_REGISTERS_OFFSET+0x00060000,0x000000C0

#define IPU_DMFC_WR_CHAN__ADDR               IPU_REGISTERS_OFFSET+0x00060004
#define IPU_DMFC_WR_CHAN__EMPTY              IPU_REGISTERS_OFFSET+0x00060004,0x00000000
#define IPU_DMFC_WR_CHAN__FULL               IPU_REGISTERS_OFFSET+0x00060004,0xffffffff
#define IPU_DMFC_WR_CHAN__DMFC_BURST_SIZE_2C IPU_REGISTERS_OFFSET+0x00060004,0xC0000000
#define IPU_DMFC_WR_CHAN__DMFC_FIFO_SIZE_2C  IPU_REGISTERS_OFFSET+0x00060004,0x38000000
#define IPU_DMFC_WR_CHAN__DMFC_ST_ADDR_2C    IPU_REGISTERS_OFFSET+0x00060004,0x07000000
#define IPU_DMFC_WR_CHAN__DMFC_BURST_SIZE_1C IPU_REGISTERS_OFFSET+0x00060004,0x00C00000
#define IPU_DMFC_WR_CHAN__DMFC_FIFO_SIZE_1C  IPU_REGISTERS_OFFSET+0x00060004,0x00380000
#define IPU_DMFC_WR_CHAN__DMFC_ST_ADDR_1C    IPU_REGISTERS_OFFSET+0x00060004,0x00070000
#define IPU_DMFC_WR_CHAN__DMFC_BURST_SIZE_2  IPU_REGISTERS_OFFSET+0x00060004,0x0000C000
#define IPU_DMFC_WR_CHAN__DMFC_FIFO_SIZE_2   IPU_REGISTERS_OFFSET+0x00060004,0x00003800
#define IPU_DMFC_WR_CHAN__DMFC_ST_ADDR_2     IPU_REGISTERS_OFFSET+0x00060004,0x00000700
#define IPU_DMFC_WR_CHAN__DMFC_BURST_SIZE_1  IPU_REGISTERS_OFFSET+0x00060004,0x000000C0
#define IPU_DMFC_WR_CHAN__DMFC_FIFO_SIZE_1   IPU_REGISTERS_OFFSET+0x00060004,0x00000038
#define IPU_DMFC_WR_CHAN__DMFC_ST_ADDR_1     IPU_REGISTERS_OFFSET+0x00060004,0x00000007

#define IPU_DMFC_WR_CHAN_DEF__ADDR           IPU_REGISTERS_OFFSET+0x00060008
#define IPU_DMFC_WR_CHAN_DEF__EMPTY          IPU_REGISTERS_OFFSET+0x00060008,0x00000000
#define IPU_DMFC_WR_CHAN_DEF__FULL           IPU_REGISTERS_OFFSET+0x00060008,0xffffffff
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_CLR_2C IPU_REGISTERS_OFFSET+0x00060008,0xE0000000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_SET_2C IPU_REGISTERS_OFFSET+0x00060008,0x1C000000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_EN_2C  IPU_REGISTERS_OFFSET+0x00060008,0x02000000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_CLR_1C IPU_REGISTERS_OFFSET+0x00060008,0x00E00000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_SET_1C IPU_REGISTERS_OFFSET+0x00060008,0x001C0000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_EN_1C  IPU_REGISTERS_OFFSET+0x00060008,0x00020000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_CLR_2  IPU_REGISTERS_OFFSET+0x00060008,0x0000E000
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_SET_2  IPU_REGISTERS_OFFSET+0x00060008,0x00001C00
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_EN_2   IPU_REGISTERS_OFFSET+0x00060008,0x00000200
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_CLR_1  IPU_REGISTERS_OFFSET+0x00060008,0x000000E0
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_SET_1  IPU_REGISTERS_OFFSET+0x00060008,0x0000001C
#define IPU_DMFC_WR_CHAN_DEF__DMFC_WM_EN_1   IPU_REGISTERS_OFFSET+0x00060008,0x00000002

#define IPU_DMFC_DP_CHAN__ADDR               IPU_REGISTERS_OFFSET+0x0006000C
#define IPU_DMFC_DP_CHAN__EMPTY              IPU_REGISTERS_OFFSET+0x0006000C,0x00000000
#define IPU_DMFC_DP_CHAN__FULL               IPU_REGISTERS_OFFSET+0x0006000C,0xffffffff
#define IPU_DMFC_DP_CHAN__DMFC_BURST_SIZE_6F IPU_REGISTERS_OFFSET+0x0006000C,0xC0000000
#define IPU_DMFC_DP_CHAN__DMFC_FIFO_SIZE_6F  IPU_REGISTERS_OFFSET+0x0006000C,0x38000000
#define IPU_DMFC_DP_CHAN__DMFC_ST_ADDR_6F    IPU_REGISTERS_OFFSET+0x0006000C,0x07000000
#define IPU_DMFC_DP_CHAN__DMFC_BURST_SIZE_6B IPU_REGISTERS_OFFSET+0x0006000C,0x00C00000
#define IPU_DMFC_DP_CHAN__DMFC_FIFO_SIZE_6B  IPU_REGISTERS_OFFSET+0x0006000C,0x00380000
#define IPU_DMFC_DP_CHAN__DMFC_ST_ADDR_6B    IPU_REGISTERS_OFFSET+0x0006000C,0x00070000
#define IPU_DMFC_DP_CHAN__DMFC_BURST_SIZE_5F IPU_REGISTERS_OFFSET+0x0006000C,0x0000C000
#define IPU_DMFC_DP_CHAN__DMFC_FIFO_SIZE_5F  IPU_REGISTERS_OFFSET+0x0006000C,0x00003800
#define IPU_DMFC_DP_CHAN__DMFC_ST_ADDR_5F    IPU_REGISTERS_OFFSET+0x0006000C,0x00000700
#define IPU_DMFC_DP_CHAN__DMFC_BURST_SIZE_5B IPU_REGISTERS_OFFSET+0x0006000C,0x000000C0
#define IPU_DMFC_DP_CHAN__DMFC_FIFO_SIZE_5B  IPU_REGISTERS_OFFSET+0x0006000C,0x00000038
#define IPU_DMFC_DP_CHAN__DMFC_ST_ADDR_5B    IPU_REGISTERS_OFFSET+0x0006000C,0x00000007

#define IPU_DMFC_DP_CHAN_DEF__ADDR           IPU_REGISTERS_OFFSET+0x00060010
#define IPU_DMFC_DP_CHAN_DEF__EMPTY          IPU_REGISTERS_OFFSET+0x00060010,0x00000000
#define IPU_DMFC_DP_CHAN_DEF__FULL           IPU_REGISTERS_OFFSET+0x00060010,0xffffffff
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_CLR_6F IPU_REGISTERS_OFFSET+0x00060010,0xE0000000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_SET_6F IPU_REGISTERS_OFFSET+0x00060010,0x1C000000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_EN_6F  IPU_REGISTERS_OFFSET+0x00060010,0x02000000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_CLR_6B IPU_REGISTERS_OFFSET+0x00060010,0x00E00000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_SET_6B IPU_REGISTERS_OFFSET+0x00060010,0x001C0000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_EN_6B  IPU_REGISTERS_OFFSET+0x00060010,0x00020000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_CLR_5F IPU_REGISTERS_OFFSET+0x00060010,0x0000E000
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_SET_5F IPU_REGISTERS_OFFSET+0x00060010,0x00001C00
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_EN_5F  IPU_REGISTERS_OFFSET+0x00060010,0x00000200
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_CLR_5B IPU_REGISTERS_OFFSET+0x00060010,0x000000E0
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_SET_5B IPU_REGISTERS_OFFSET+0x00060010,0x0000001C
#define IPU_DMFC_DP_CHAN_DEF__DMFC_WM_EN_5B  IPU_REGISTERS_OFFSET+0x00060010,0x00000002

#define IPU_DMFC_GENERAL1__ADDR              IPU_REGISTERS_OFFSET+0x00060014
#define IPU_DMFC_GENERAL1__EMPTY             IPU_REGISTERS_OFFSET+0x00060014,0x00000000
#define IPU_DMFC_GENERAL1__FULL              IPU_REGISTERS_OFFSET+0x00060014,0xffffffff
#define IPU_DMFC_GENERAL1__WAIT4EOT_9        IPU_REGISTERS_OFFSET+0x00060014,0x01000000
#define IPU_DMFC_GENERAL1__WAIT4EOT_6F       IPU_REGISTERS_OFFSET+0x00060014,0x00800000
#define IPU_DMFC_GENERAL1__WAIT4EOT_6B       IPU_REGISTERS_OFFSET+0x00060014,0x00400000
#define IPU_DMFC_GENERAL1__WAIT4EOT_5F       IPU_REGISTERS_OFFSET+0x00060014,0x00200000
#define IPU_DMFC_GENERAL1__WAIT4EOT_5B       IPU_REGISTERS_OFFSET+0x00060014,0x00100000
#define IPU_DMFC_GENERAL1__WAIT4EOT_4        IPU_REGISTERS_OFFSET+0x00060014,0x00080000
#define IPU_DMFC_GENERAL1__WAIT4EOT_3        IPU_REGISTERS_OFFSET+0x00060014,0x00040000
#define IPU_DMFC_GENERAL1__WAIT4EOT_2        IPU_REGISTERS_OFFSET+0x00060014,0x00020000
#define IPU_DMFC_GENERAL1__WAIT4EOT_1        IPU_REGISTERS_OFFSET+0x00060014,0x00010000
#define IPU_DMFC_GENERAL1__DMFC_WM_CLR_9     IPU_REGISTERS_OFFSET+0x00060014,0x0000E000
#define IPU_DMFC_GENERAL1__DMFC_WM_SET_9     IPU_REGISTERS_OFFSET+0x00060014,0x00001C00
#define IPU_DMFC_GENERAL1__DMFC_WM_EN_9      IPU_REGISTERS_OFFSET+0x00060014,0x00000200
#define IPU_DMFC_GENERAL1__DMFC_BURST_SIZE_9 IPU_REGISTERS_OFFSET+0x00060014,0x00000060
#define IPU_DMFC_GENERAL1__DMFC_DCDP_SYNC_PR IPU_REGISTERS_OFFSET+0x00060014,0x00000003

#define IPU_DMFC_GENERAL2__ADDR                 IPU_REGISTERS_OFFSET+0x00060018
#define IPU_DMFC_GENERAL2__EMPTY                IPU_REGISTERS_OFFSET+0x00060018,0x00000000
#define IPU_DMFC_GENERAL2__FULL                 IPU_REGISTERS_OFFSET+0x00060018,0xffffffff
#define IPU_DMFC_GENERAL2__DMFC_FRAME_HEIGHT_RD IPU_REGISTERS_OFFSET+0x00060018,0x1FFF0000
#define IPU_DMFC_GENERAL2__DMFC_FRAME_WIDTH_RD  IPU_REGISTERS_OFFSET+0x00060018,0x00001FFF

#define IPU_DMFC_IC_CTRL__ADDR                    IPU_REGISTERS_OFFSET+0x0006001C
#define IPU_DMFC_IC_CTRL__EMPTY                   IPU_REGISTERS_OFFSET+0x0006001C,0x00000000
#define IPU_DMFC_IC_CTRL__FULL                    IPU_REGISTERS_OFFSET+0x0006001C,0xffffffff
#define IPU_DMFC_IC_CTRL__DMFC_IC_FRAME_HEIGHT_RD IPU_REGISTERS_OFFSET+0x0006001C,0xFFF80000
#define IPU_DMFC_IC_CTRL__DMFC_IC_FRAME_WIDTH_RD  IPU_REGISTERS_OFFSET+0x0006001C,0x0007FFC0
#define IPU_DMFC_IC_CTRL__DMFC_IC_PPW_C           IPU_REGISTERS_OFFSET+0x0006001C,0x00000030
#define IPU_DMFC_IC_CTRL__DMFC_IC_IN_PORT         IPU_REGISTERS_OFFSET+0x0006001C,0x00000007

#define IPU_DMFC_WR_CHAN_ALT__ADDR                  IPU_REGISTERS_OFFSET+0x00060020
#define IPU_DMFC_WR_CHAN_ALT__EMPTY                 IPU_REGISTERS_OFFSET+0x00060020,0x00000000
#define IPU_DMFC_WR_CHAN_ALT__FULL                  IPU_REGISTERS_OFFSET+0x00060020,0xffffffff
#define IPU_DMFC_WR_CHAN_ALT__DMFC_BURST_SIZE_2_ALT IPU_REGISTERS_OFFSET+0x00060020,0x0000C000
#define IPU_DMFC_WR_CHAN_ALT__DMFC_FIFO_SIZE_2_ALT  IPU_REGISTERS_OFFSET+0x00060020,0x00003800
#define IPU_DMFC_WR_CHAN_ALT__DMFC_ST_ADDR_2_ALT    IPU_REGISTERS_OFFSET+0x00060020,0x00000700

#define IPU_DMFC_WR_CHAN_DEF_ALT__ADDR              IPU_REGISTERS_OFFSET+0x00060024
#define IPU_DMFC_WR_CHAN_DEF_ALT__EMPTY             IPU_REGISTERS_OFFSET+0x00060024,0x00000000
#define IPU_DMFC_WR_CHAN_DEF_ALT__FULL              IPU_REGISTERS_OFFSET+0x00060024,0xffffffff
#define IPU_DMFC_WR_CHAN_DEF_ALT__DMFC_WM_CLR_2_ALT IPU_REGISTERS_OFFSET+0x00060024,0x0000E000
#define IPU_DMFC_WR_CHAN_DEF_ALT__DMFC_WM_SET_2_ALT IPU_REGISTERS_OFFSET+0x00060024,0x00001C00
#define IPU_DMFC_WR_CHAN_DEF_ALT__DMFC_WM_EN_2_ALT  IPU_REGISTERS_OFFSET+0x00060024,0x00000200

#define IPU_DMFC_DP_CHAN_ALT__ADDR                   IPU_REGISTERS_OFFSET+0x00060028
#define IPU_DMFC_DP_CHAN_ALT__EMPTY                  IPU_REGISTERS_OFFSET+0x00060028,0x00000000
#define IPU_DMFC_DP_CHAN_ALT__FULL                   IPU_REGISTERS_OFFSET+0x00060028,0xffffffff
#define IPU_DMFC_DP_CHAN_ALT__DMFC_BURST_SIZE_6F_ALT IPU_REGISTERS_OFFSET+0x00060028,0xC0000000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_FIFO_SIZE_6F_ALT  IPU_REGISTERS_OFFSET+0x00060028,0x38000000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_ST_ADDR_6F_ALT    IPU_REGISTERS_OFFSET+0x00060028,0x07000000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_BURST_SIZE_6B_ALT IPU_REGISTERS_OFFSET+0x00060028,0x00C00000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_FIFO_SIZE_6B_ALT  IPU_REGISTERS_OFFSET+0x00060028,0x00380000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_ST_ADDR_6B_ALT    IPU_REGISTERS_OFFSET+0x00060028,0x00070000
#define IPU_DMFC_DP_CHAN_ALT__DMFC_BURST_SIZE_5B_ALT IPU_REGISTERS_OFFSET+0x00060028,0x000000C0
#define IPU_DMFC_DP_CHAN_ALT__DMFC_FIFO_SIZE_5B_ALT  IPU_REGISTERS_OFFSET+0x00060028,0x00000038
#define IPU_DMFC_DP_CHAN_ALT__DMFC_ST_ADDR_5B_ALT    IPU_REGISTERS_OFFSET+0x00060028,0x00000007

#define IPU_DMFC_DP_CHAN_DEF_ALT__ADDR               IPU_REGISTERS_OFFSET+0x0006002C
#define IPU_DMFC_DP_CHAN_DEF_ALT__EMPTY              IPU_REGISTERS_OFFSET+0x0006002C,0x00000000
#define IPU_DMFC_DP_CHAN_DEF_ALT__FULL               IPU_REGISTERS_OFFSET+0x0006002C,0xffffffff
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_CLR_6F_ALT IPU_REGISTERS_OFFSET+0x0006002C,0xE0000000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_SET_6F_ALT IPU_REGISTERS_OFFSET+0x0006002C,0x1C000000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_EN_6F_ALT  IPU_REGISTERS_OFFSET+0x0006002C,0x02000000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_CLR_6B_ALT IPU_REGISTERS_OFFSET+0x0006002C,0x00E00000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_SET_6B_ALT IPU_REGISTERS_OFFSET+0x0006002C,0x001C0000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_EN_6B_ALT  IPU_REGISTERS_OFFSET+0x0006002C,0x00020000
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_CLR_5B_ALT IPU_REGISTERS_OFFSET+0x0006002C,0x000000E0
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_SET_5B_ALT IPU_REGISTERS_OFFSET+0x0006002C,0x0000001C
#define IPU_DMFC_DP_CHAN_DEF_ALT__DMFC_WM_EN_5B_ALT  IPU_REGISTERS_OFFSET+0x0006002C,0x00000002

#define IPU_DMFC_GENERAL1_ALT__ADDR            IPU_REGISTERS_OFFSET+0x00060030
#define IPU_DMFC_GENERAL1_ALT__EMPTY           IPU_REGISTERS_OFFSET+0x00060030,0x00000000
#define IPU_DMFC_GENERAL1_ALT__FULL            IPU_REGISTERS_OFFSET+0x00060030,0xffffffff
#define IPU_DMFC_GENERAL1_ALT__WAIT4EOT_6F_ALT IPU_REGISTERS_OFFSET+0x00060030,0x00800000
#define IPU_DMFC_GENERAL1_ALT__WAIT4EOT_6B_ALT IPU_REGISTERS_OFFSET+0x00060030,0x00400000
#define IPU_DMFC_GENERAL1_ALT__WAIT4EOT_5B_ALT IPU_REGISTERS_OFFSET+0x00060030,0x00100000
#define IPU_DMFC_GENERAL1_ALT__WAIT4EOT_2_ALT  IPU_REGISTERS_OFFSET+0x00060030,0x00020000

#define IPU_DMFC_STAT__ADDR                 IPU_REGISTERS_OFFSET+0x00060034
#define IPU_DMFC_STAT__EMPTY                IPU_REGISTERS_OFFSET+0x00060034,0x00000000
#define IPU_DMFC_STAT__FULL                 IPU_REGISTERS_OFFSET+0x00060034,0xffffffff
#define IPU_DMFC_STAT__DMFC_IC_BUFFER_EMPTY IPU_REGISTERS_OFFSET+0x00060034,0x02000000
#define IPU_DMFC_STAT__DMFC_IC_BUFFER_FULL  IPU_REGISTERS_OFFSET+0x00060034,0x01000000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_11   IPU_REGISTERS_OFFSET+0x00060034,0x00800000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_10   IPU_REGISTERS_OFFSET+0x00060034,0x00400000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_9    IPU_REGISTERS_OFFSET+0x00060034,0x00200000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_8    IPU_REGISTERS_OFFSET+0x00060034,0x00100000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_7    IPU_REGISTERS_OFFSET+0x00060034,0x00080000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_6    IPU_REGISTERS_OFFSET+0x00060034,0x00040000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_5    IPU_REGISTERS_OFFSET+0x00060034,0x00020000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_4    IPU_REGISTERS_OFFSET+0x00060034,0x00010000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_3    IPU_REGISTERS_OFFSET+0x00060034,0x00008000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_2    IPU_REGISTERS_OFFSET+0x00060034,0x00004000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_1    IPU_REGISTERS_OFFSET+0x00060034,0x00002000
#define IPU_DMFC_STAT__DMFC_FIFO_EMPTY_0    IPU_REGISTERS_OFFSET+0x00060034,0x00001000
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_11    IPU_REGISTERS_OFFSET+0x00060034,0x00000800
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_10    IPU_REGISTERS_OFFSET+0x00060034,0x00000400
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_9     IPU_REGISTERS_OFFSET+0x00060034,0x00000200
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_8     IPU_REGISTERS_OFFSET+0x00060034,0x00000100
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_7     IPU_REGISTERS_OFFSET+0x00060034,0x00000080
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_6     IPU_REGISTERS_OFFSET+0x00060034,0x00000040
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_5     IPU_REGISTERS_OFFSET+0x00060034,0x00000020
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_4     IPU_REGISTERS_OFFSET+0x00060034,0x00000010
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_3     IPU_REGISTERS_OFFSET+0x00060034,0x00000008
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_2     IPU_REGISTERS_OFFSET+0x00060034,0x00000004
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_1     IPU_REGISTERS_OFFSET+0x00060034,0x00000002
#define IPU_DMFC_STAT__DMFC_FIFO_FULL_0     IPU_REGISTERS_OFFSET+0x00060034,0x00000001

#define IPU_VDI_FSIZE__ADDR        IPU_REGISTERS_OFFSET+0x00068000
#define IPU_VDI_FSIZE__EMPTY       IPU_REGISTERS_OFFSET+0x00068000,0x00000000
#define IPU_VDI_FSIZE__FULL        IPU_REGISTERS_OFFSET+0x00068000,0xffffffff
#define IPU_VDI_FSIZE__VDI_FHEIGHT IPU_REGISTERS_OFFSET+0x00068000,0x07FF0000
#define IPU_VDI_FSIZE__VDI_FWIDTH  IPU_REGISTERS_OFFSET+0x00068000,0x000007FF

#define IPU_VDI_C__ADDR               IPU_REGISTERS_OFFSET+0x00068004
#define IPU_VDI_C__EMPTY              IPU_REGISTERS_OFFSET+0x00068004,0x00000000
#define IPU_VDI_C__FULL               IPU_REGISTERS_OFFSET+0x00068004,0xffffffff
#define IPU_VDI_C__VDI_TOP_FIELD_AUTO IPU_REGISTERS_OFFSET+0x00068004,0x80000000
#define IPU_VDI_C__VDI_TOP_FIELD_MAN  IPU_REGISTERS_OFFSET+0x00068004,0x40000000
#define IPU_VDI_C__VDI_VWM3_CLR       IPU_REGISTERS_OFFSET+0x00068004,0x0E000000
#define IPU_VDI_C__VDI_VWM3_SET       IPU_REGISTERS_OFFSET+0x00068004,0x01C00000
#define IPU_VDI_C__VDI_VWM1_CLR       IPU_REGISTERS_OFFSET+0x00068004,0x00380000
#define IPU_VDI_C__VDI_VWM1_SET       IPU_REGISTERS_OFFSET+0x00068004,0x00070000
#define IPU_VDI_C__VDI_BURST_SIZE3    IPU_REGISTERS_OFFSET+0x00068004,0x0000F000
#define IPU_VDI_C__VDI_BURST_SIZE2    IPU_REGISTERS_OFFSET+0x00068004,0x00000F00
#define IPU_VDI_C__VDI_BURST_SIZE1    IPU_REGISTERS_OFFSET+0x00068004,0x000000F0
#define IPU_VDI_C__VDI_MOT_SEL        IPU_REGISTERS_OFFSET+0x00068004,0x0000000C
#define IPU_VDI_C__VDI_CH_422         IPU_REGISTERS_OFFSET+0x00068004,0x00000002

#define IPU_VDI_C2__ADDR             IPU_REGISTERS_OFFSET+0x00068008
#define IPU_VDI_C2__EMPTY            IPU_REGISTERS_OFFSET+0x00068008,0x00000000
#define IPU_VDI_C2__FULL             IPU_REGISTERS_OFFSET+0x00068008,0xffffffff
#define IPU_VDI_C2__VDI_PLANE_1_EN   IPU_REGISTERS_OFFSET+0x00068008,0x00000008
#define IPU_VDI_C2__VDI_GLB_A_EN     IPU_REGISTERS_OFFSET+0x00068008,0x00000004
#define IPU_VDI_C2__VDI_KEY_COLOR_EN IPU_REGISTERS_OFFSET+0x00068008,0x00000002
#define IPU_VDI_C2__VDI_CMB_EN       IPU_REGISTERS_OFFSET+0x00068008,0x00000001

#define IPU_VDI_CMBP_1__ADDR            IPU_REGISTERS_OFFSET+0x0006800C
#define IPU_VDI_CMBP_1__EMPTY           IPU_REGISTERS_OFFSET+0x0006800C,0x00000000
#define IPU_VDI_CMBP_1__FULL            IPU_REGISTERS_OFFSET+0x0006800C,0xffffffff
#define IPU_VDI_CMBP_1__VDI_ALPHA       IPU_REGISTERS_OFFSET+0x0006800C,0xFF000000
#define IPU_VDI_CMBP_1__VDI_KEY_COLOR_R IPU_REGISTERS_OFFSET+0x0006800C,0x00FF0000
#define IPU_VDI_CMBP_1__VDI_KEY_COLOR_G IPU_REGISTERS_OFFSET+0x0006800C,0x0000FF00
#define IPU_VDI_CMBP_1__VDI_KEY_COLOR_B IPU_REGISTERS_OFFSET+0x0006800C,0x000000FF

#define IPU_VDI_CMBP_2__ADDR           IPU_REGISTERS_OFFSET+0x00068010
#define IPU_VDI_CMBP_2__EMPTY          IPU_REGISTERS_OFFSET+0x00068010,0x00000000
#define IPU_VDI_CMBP_2__FULL           IPU_REGISTERS_OFFSET+0x00068010,0xffffffff
#define IPU_VDI_CMBP_2__VDI_BG_COLOR_R IPU_REGISTERS_OFFSET+0x00068010,0x00FF0000
#define IPU_VDI_CMBP_2__VDI_BG_COLOR_G IPU_REGISTERS_OFFSET+0x00068010,0x0000FF00
#define IPU_VDI_CMBP_2__VDI_BG_COLOR_B IPU_REGISTERS_OFFSET+0x00068010,0x000000FF

#define IPU_VDI_PS_1__ADDR         IPU_REGISTERS_OFFSET+0x00068014
#define IPU_VDI_PS_1__EMPTY        IPU_REGISTERS_OFFSET+0x00068014,0x00000000
#define IPU_VDI_PS_1__FULL         IPU_REGISTERS_OFFSET+0x00068014,0xffffffff
#define IPU_VDI_PS_1__VDI_FHEIGHT1 IPU_REGISTERS_OFFSET+0x00068014,0x07FF0000
#define IPU_VDI_PS_1__VDI_FWIDTH1  IPU_REGISTERS_OFFSET+0x00068014,0x000007FF

#define IPU_VDI_PS_2__ADDR            IPU_REGISTERS_OFFSET+0x00068018
#define IPU_VDI_PS_2__EMPTY           IPU_REGISTERS_OFFSET+0x00068018,0x00000000
#define IPU_VDI_PS_2__FULL            IPU_REGISTERS_OFFSET+0x00068018,0xffffffff
#define IPU_VDI_PS_2__VDI_OFFSET_VER1 IPU_REGISTERS_OFFSET+0x00068018,0x07FF0000
#define IPU_VDI_PS_2__VDI_OFFSET_HOR1 IPU_REGISTERS_OFFSET+0x00068018,0x000007FF

#define IPU_VDI_PS_3__ADDR         IPU_REGISTERS_OFFSET+0x0006801C
#define IPU_VDI_PS_3__EMPTY        IPU_REGISTERS_OFFSET+0x0006801C,0x00000000
#define IPU_VDI_PS_3__FULL         IPU_REGISTERS_OFFSET+0x0006801C,0xffffffff
#define IPU_VDI_PS_3__VDI_FHEIGHT3 IPU_REGISTERS_OFFSET+0x0006801C,0x07FF0000
#define IPU_VDI_PS_3__VDI_FWIDTH3  IPU_REGISTERS_OFFSET+0x0006801C,0x000007FF

#define IPU_VDI_PS_4__ADDR            IPU_REGISTERS_OFFSET+0x00068020
#define IPU_VDI_PS_4__EMPTY           IPU_REGISTERS_OFFSET+0x00068020,0x00000000
#define IPU_VDI_PS_4__FULL            IPU_REGISTERS_OFFSET+0x00068020,0xffffffff
#define IPU_VDI_PS_4__VDI_OFFSET_VER3 IPU_REGISTERS_OFFSET+0x00068020,0x07FF0000
#define IPU_VDI_PS_4__VDI_OFFSET_HOR3 IPU_REGISTERS_OFFSET+0x00068020,0x000007FF

#define IPU_DP_COM_CONF_ASYNC__ADDR                       IPU_REGISTERS_OFFSET+0x00018060
#define IPU_DP_COM_CONF_ASYNC__EMPTY                      IPU_REGISTERS_OFFSET+0x00018060,0x00000000
#define IPU_DP_COM_CONF_ASYNC__FULL                       IPU_REGISTERS_OFFSET+0x00018060,0xffffffff
#define IPU_DP_COM_CONF_ASYNC__DP_GAMMA_YUV_EN_ASYNC     IPU_REGISTERS_OFFSET+0x00018060,0x00002000
#define IPU_DP_COM_CONF_ASYNC__DP_GAMMA_EN_ASYNC         IPU_REGISTERS_OFFSET+0x00018060,0x00001000
#define IPU_DP_COM_CONF_ASYNC__DP_CSC_YUV_SAT_MODE_ASYNC IPU_REGISTERS_OFFSET+0x00018060,0x00000800
#define IPU_DP_COM_CONF_ASYNC__DP_CSC_GAMUT_SAT_EN_ASYNC IPU_REGISTERS_OFFSET+0x00018060,0x00000400
#define IPU_DP_COM_CONF_ASYNC__DP_CSC_DEF_ASYNC          IPU_REGISTERS_OFFSET+0x00018060,0x00000300
#define IPU_DP_COM_CONF_ASYNC__DP_COC_ASYNC              IPU_REGISTERS_OFFSET+0x00018060,0x00000070
#define IPU_DP_COM_CONF_ASYNC__DP_GWCKE_ASYNC            IPU_REGISTERS_OFFSET+0x00018060,0x00000008
#define IPU_DP_COM_CONF_ASYNC__DP_GWAM_ASYNC             IPU_REGISTERS_OFFSET+0x00018060,0x00000004
#define IPU_DP_COM_CONF_ASYNC__DP_GWSEL_ASYNC            IPU_REGISTERS_OFFSET+0x00018060,0x00000002

#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__ADDR            IPU_REGISTERS_OFFSET+0x00018064
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__EMPTY           IPU_REGISTERS_OFFSET+0x00018064,0x00000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__FULL            IPU_REGISTERS_OFFSET+0x00018064,0xffffffff
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__DP_GWAV_ASYNC  IPU_REGISTERS_OFFSET+0x00018064,0xFF000000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__DP_GWCKR_ASYNC IPU_REGISTERS_OFFSET+0x00018064,0x00FF0000
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__DP_GWCKG_ASYNC IPU_REGISTERS_OFFSET+0x00018064,0x0000FF00
#define IPU_DP_GRAPH_WIND_CTRL_ASYNC__DP_GWCKB_ASYNC IPU_REGISTERS_OFFSET+0x00018064,0x000000FF

#define IPU_DP_FG_POS_ASYNC__ADDR           IPU_REGISTERS_OFFSET+0x00018068
#define IPU_DP_FG_POS_ASYNC__EMPTY          IPU_REGISTERS_OFFSET+0x00018068,0x00000000
#define IPU_DP_FG_POS_ASYNC__FULL           IPU_REGISTERS_OFFSET+0x00018068,0xffffffff
#define IPU_DP_FG_POS_ASYNC__DP_FGXP_ASYNC IPU_REGISTERS_OFFSET+0x00018068,0x07FF0000
#define IPU_DP_FG_POS_ASYNC__DP_FGYP_ASYNC IPU_REGISTERS_OFFSET+0x00018068,0x000007FF

#define IPU_DP_CUR_POS_ASYNC__ADDR          IPU_REGISTERS_OFFSET+0x0001806C
#define IPU_DP_CUR_POS_ASYNC__EMPTY         IPU_REGISTERS_OFFSET+0x0001806C,0x00000000
#define IPU_DP_CUR_POS_ASYNC__FULL          IPU_REGISTERS_OFFSET+0x0001806C,0xffffffff
#define IPU_DP_CUR_POS_ASYNC__DP_CXW_ASYNC IPU_REGISTERS_OFFSET+0x0001806C,0xF8000000
#define IPU_DP_CUR_POS_ASYNC__DP_CXP_ASYNC IPU_REGISTERS_OFFSET+0x0001806C,0x07FF0000
#define IPU_DP_CUR_POS_ASYNC__DP_CYH_ASYNC IPU_REGISTERS_OFFSET+0x0001806C,0x0000F800
#define IPU_DP_CUR_POS_ASYNC__DP_CYP_ASYNC IPU_REGISTERS_OFFSET+0x0001806C,0x000007FF

#define IPU_DP_CUR_MAP_ASYNC__ADDR             IPU_REGISTERS_OFFSET+0x00018070
#define IPU_DP_CUR_MAP_ASYNC__EMPTY            IPU_REGISTERS_OFFSET+0x00018070,0x00000000
#define IPU_DP_CUR_MAP_ASYNC__FULL             IPU_REGISTERS_OFFSET+0x00018070,0xffffffff
#define IPU_DP_CUR_MAP_ASYNC__CUR_COL_R_ASYNC IPU_REGISTERS_OFFSET+0x00018070,0x00FF0000
#define IPU_DP_CUR_MAP_ASYNC__CUR_COL_G_ASYNC IPU_REGISTERS_OFFSET+0x00018070,0x0000FF00
#define IPU_DP_CUR_MAP_ASYNC__CUR_COL_B_ASYNC IPU_REGISTERS_OFFSET+0x00018070,0x000000FF

#define IPU_DP_GAMMA_C_ASYNC_0__ADDR                IPU_REGISTERS_OFFSET+0x00018074
#define IPU_DP_GAMMA_C_ASYNC_0__EMPTY               IPU_REGISTERS_OFFSET+0x00018074,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_0__FULL                IPU_REGISTERS_OFFSET+0x00018074,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_0__DP_GAMMA_C_ASYNC_1 IPU_REGISTERS_OFFSET+0x00018074,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_0__DP_GAMMA_C_ASYNC_0 IPU_REGISTERS_OFFSET+0x00018074,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_1__ADDR                IPU_REGISTERS_OFFSET+0x00018078
#define IPU_DP_GAMMA_C_ASYNC_1__EMPTY               IPU_REGISTERS_OFFSET+0x00018078,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_1__FULL                IPU_REGISTERS_OFFSET+0x00018078,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_1__DP_GAMMA_C_ASYNC_3 IPU_REGISTERS_OFFSET+0x00018078,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_1__DP_GAMMA_C_ASYNC_2 IPU_REGISTERS_OFFSET+0x00018078,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_2__ADDR                IPU_REGISTERS_OFFSET+0x0001807C
#define IPU_DP_GAMMA_C_ASYNC_2__EMPTY               IPU_REGISTERS_OFFSET+0x0001807C,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_2__FULL                IPU_REGISTERS_OFFSET+0x0001807C,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_2__DP_GAMMA_C_ASYNC_5 IPU_REGISTERS_OFFSET+0x0001807C,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_2__DP_GAMMA_C_ASYNC_4 IPU_REGISTERS_OFFSET+0x0001807C,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_3__ADDR                IPU_REGISTERS_OFFSET+0x00018080
#define IPU_DP_GAMMA_C_ASYNC_3__EMPTY               IPU_REGISTERS_OFFSET+0x00018080,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_3__FULL                IPU_REGISTERS_OFFSET+0x00018080,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_3__DP_GAMMA_C_ASYNC_7 IPU_REGISTERS_OFFSET+0x00018080,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_3__DP_GAMMA_C_ASYNC_6 IPU_REGISTERS_OFFSET+0x00018080,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_4__ADDR                IPU_REGISTERS_OFFSET+0x00018084
#define IPU_DP_GAMMA_C_ASYNC_4__EMPTY               IPU_REGISTERS_OFFSET+0x00018084,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_4__FULL                IPU_REGISTERS_OFFSET+0x00018084,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_4__DP_GAMMA_C_ASYNC_9 IPU_REGISTERS_OFFSET+0x00018084,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_4__DP_GAMMA_C_ASYNC_8 IPU_REGISTERS_OFFSET+0x00018084,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_5__ADDR                 IPU_REGISTERS_OFFSET+0x00018088
#define IPU_DP_GAMMA_C_ASYNC_5__EMPTY                IPU_REGISTERS_OFFSET+0x00018088,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_5__FULL                 IPU_REGISTERS_OFFSET+0x00018088,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_5__DP_GAMMA_C_ASYNC_11 IPU_REGISTERS_OFFSET+0x00018088,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_5__DP_GAMMA_C_ASYNC_10 IPU_REGISTERS_OFFSET+0x00018088,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_6__ADDR                 IPU_REGISTERS_OFFSET+0x0001808C
#define IPU_DP_GAMMA_C_ASYNC_6__EMPTY                IPU_REGISTERS_OFFSET+0x0001808C,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_6__FULL                 IPU_REGISTERS_OFFSET+0x0001808C,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_6__DP_GAMMA_C_ASYNC_13 IPU_REGISTERS_OFFSET+0x0001808C,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_6__DP_GAMMA_C_ASYNC_12 IPU_REGISTERS_OFFSET+0x0001808C,0x000001FF

#define IPU_DP_GAMMA_C_ASYNC_7__ADDR                 IPU_REGISTERS_OFFSET+0x00018090
#define IPU_DP_GAMMA_C_ASYNC_7__EMPTY                IPU_REGISTERS_OFFSET+0x00018090,0x00000000
#define IPU_DP_GAMMA_C_ASYNC_7__FULL                 IPU_REGISTERS_OFFSET+0x00018090,0xffffffff
#define IPU_DP_GAMMA_C_ASYNC_7__DP_GAMMA_C_ASYNC_15 IPU_REGISTERS_OFFSET+0x00018090,0x01FF0000
#define IPU_DP_GAMMA_C_ASYNC_7__DP_GAMMA_C_ASYNC_14 IPU_REGISTERS_OFFSET+0x00018090,0x000001FF

#define IPU_DP_GAMMA_S_ASYNC_0__ADDR                IPU_REGISTERS_OFFSET+0x00018094
#define IPU_DP_GAMMA_S_ASYNC_0__EMPTY               IPU_REGISTERS_OFFSET+0x00018094,0x00000000
#define IPU_DP_GAMMA_S_ASYNC_0__FULL                IPU_REGISTERS_OFFSET+0x00018094,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC_0__DP_GAMMA_S_ASYNC_3 IPU_REGISTERS_OFFSET+0x00018094,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC_0__DP_GAMMA_S_ASYNC_2 IPU_REGISTERS_OFFSET+0x00018094,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC_0__DP_GAMMA_S_ASYNC_1 IPU_REGISTERS_OFFSET+0x00018094,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC_0__DP_GAMMA_S_ASYNC_0 IPU_REGISTERS_OFFSET+0x00018094,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC_1__ADDR                IPU_REGISTERS_OFFSET+0x00018098
#define IPU_DP_GAMMA_S_ASYNC_1__EMPTY               IPU_REGISTERS_OFFSET+0x00018098,0x00000000
#define IPU_DP_GAMMA_S_ASYNC_1__FULL                IPU_REGISTERS_OFFSET+0x00018098,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC_1__DP_GAMMA_S_ASYNC_7 IPU_REGISTERS_OFFSET+0x00018098,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC_1__DP_GAMMA_S_ASYNC_6 IPU_REGISTERS_OFFSET+0x00018098,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC_1__DP_GAMMA_S_ASYNC_5 IPU_REGISTERS_OFFSET+0x00018098,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC_1__DP_GAMMA_S_ASYNC_4 IPU_REGISTERS_OFFSET+0x00018098,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC_2__ADDR                 IPU_REGISTERS_OFFSET+0x0001809C
#define IPU_DP_GAMMA_S_ASYNC_2__EMPTY                IPU_REGISTERS_OFFSET+0x0001809C,0x00000000
#define IPU_DP_GAMMA_S_ASYNC_2__FULL                 IPU_REGISTERS_OFFSET+0x0001809C,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC_2__DP_GAMMA_S_ASYNC_11 IPU_REGISTERS_OFFSET+0x0001809C,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC_2__DP_GAMMA_S_ASYNC_10 IPU_REGISTERS_OFFSET+0x0001809C,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC_2__DP_GAMMA_S_ASYNC_9  IPU_REGISTERS_OFFSET+0x0001809C,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC_2__DP_GAMMA_S_ASYNC_8  IPU_REGISTERS_OFFSET+0x0001809C,0x000000FF

#define IPU_DP_GAMMA_S_ASYNC_3__ADDR                 IPU_REGISTERS_OFFSET+0x000180A0
#define IPU_DP_GAMMA_S_ASYNC_3__EMPTY                IPU_REGISTERS_OFFSET+0x000180A0,0x00000000
#define IPU_DP_GAMMA_S_ASYNC_3__FULL                 IPU_REGISTERS_OFFSET+0x000180A0,0xffffffff
#define IPU_DP_GAMMA_S_ASYNC_3__DP_GAMMA_S_ASYNC_15 IPU_REGISTERS_OFFSET+0x000180A0,0xFF000000
#define IPU_DP_GAMMA_S_ASYNC_3__DP_GAMMA_S_ASYNC_14 IPU_REGISTERS_OFFSET+0x000180A0,0x00FF0000
#define IPU_DP_GAMMA_S_ASYNC_3__DP_GAMMA_S_ASYNC_13 IPU_REGISTERS_OFFSET+0x000180A0,0x0000FF00
#define IPU_DP_GAMMA_S_ASYNC_3__DP_GAMMA_S_ASYNC_12 IPU_REGISTERS_OFFSET+0x000180A0,0x000000FF

#define IPU_DP_CSCA_ASYNC_0__ADDR              IPU_REGISTERS_OFFSET+0x000180A4
#define IPU_DP_CSCA_ASYNC_0__EMPTY             IPU_REGISTERS_OFFSET+0x000180A4,0x00000000
#define IPU_DP_CSCA_ASYNC_0__FULL              IPU_REGISTERS_OFFSET+0x000180A4,0xffffffff
#define IPU_DP_CSCA_ASYNC_0__DP_CSC_A_ASYNC_1 IPU_REGISTERS_OFFSET+0x000180A4,0x03FF0000
#define IPU_DP_CSCA_ASYNC_0__DP_CSC_A_ASYNC_0 IPU_REGISTERS_OFFSET+0x000180A4,0x000003FF

#define IPU_DP_CSCA_ASYNC_1__ADDR              IPU_REGISTERS_OFFSET+0x000180A8
#define IPU_DP_CSCA_ASYNC_1__EMPTY             IPU_REGISTERS_OFFSET+0x000180A8,0x00000000
#define IPU_DP_CSCA_ASYNC_1__FULL              IPU_REGISTERS_OFFSET+0x000180A8,0xffffffff
#define IPU_DP_CSCA_ASYNC_1__DP_CSC_A_ASYNC_3 IPU_REGISTERS_OFFSET+0x000180A8,0x03FF0000
#define IPU_DP_CSCA_ASYNC_1__DP_CSC_A_ASYNC_2 IPU_REGISTERS_OFFSET+0x000180A8,0x000003FF

#define IPU_DP_CSCA_ASYNC_2__ADDR              IPU_REGISTERS_OFFSET+0x000180AC
#define IPU_DP_CSCA_ASYNC_2__EMPTY             IPU_REGISTERS_OFFSET+0x000180AC,0x00000000
#define IPU_DP_CSCA_ASYNC_2__FULL              IPU_REGISTERS_OFFSET+0x000180AC,0xffffffff
#define IPU_DP_CSCA_ASYNC_2__DP_CSC_A_ASYNC_5 IPU_REGISTERS_OFFSET+0x000180AC,0x03FF0000
#define IPU_DP_CSCA_ASYNC_2__DP_CSC_A_ASYNC_4 IPU_REGISTERS_OFFSET+0x000180AC,0x000003FF

#define IPU_DP_CSCA_ASYNC_3__ADDR              IPU_REGISTERS_OFFSET+0x000180B0
#define IPU_DP_CSCA_ASYNC_3__EMPTY             IPU_REGISTERS_OFFSET+0x000180B0,0x00000000
#define IPU_DP_CSCA_ASYNC_3__FULL              IPU_REGISTERS_OFFSET+0x000180B0,0xffffffff
#define IPU_DP_CSCA_ASYNC_3__DP_CSC_A_ASYNC_7 IPU_REGISTERS_OFFSET+0x000180B0,0x03FF0000
#define IPU_DP_CSCA_ASYNC_3__DP_CSC_A_ASYNC_6 IPU_REGISTERS_OFFSET+0x000180B0,0x000003FF

#define IPU_DP_CSC_ASYNC_0__ADDR             IPU_REGISTERS_OFFSET+0x000180B4
#define IPU_DP_CSC_ASYNC_0__EMPTY            IPU_REGISTERS_OFFSET+0x000180B4,0x00000000
#define IPU_DP_CSC_ASYNC_0__FULL             IPU_REGISTERS_OFFSET+0x000180B4,0xffffffff
#define IPU_DP_CSC_ASYNC_0__DP_CSC_S0_ASYNC IPU_REGISTERS_OFFSET+0x000180B4,0xC0000000
#define IPU_DP_CSC_ASYNC_0__DP_CSC_B0_ASYNC IPU_REGISTERS_OFFSET+0x000180B4,0x3FFF0000
#define IPU_DP_CSC_ASYNC_0__DP_CSC_A8_ASYNC IPU_REGISTERS_OFFSET+0x000180B4,0x000003FF

#define IPU_DP_CSC_ASYNC_1__ADDR             IPU_REGISTERS_OFFSET+0x000180B8
#define IPU_DP_CSC_ASYNC_1__EMPTY            IPU_REGISTERS_OFFSET+0x000180B8,0x00000000
#define IPU_DP_CSC_ASYNC_1__FULL             IPU_REGISTERS_OFFSET+0x000180B8,0xffffffff
#define IPU_DP_CSC_ASYNC_1__DP_CSC_S2_ASYNC IPU_REGISTERS_OFFSET+0x000180B8,0xC0000000
#define IPU_DP_CSC_ASYNC_1__DP_CSC_B2_ASYNC IPU_REGISTERS_OFFSET+0x000180B8,0x3FFF0000
#define IPU_DP_CSC_ASYNC_1__DP_CSC_S1_ASYNC IPU_REGISTERS_OFFSET+0x000180B8,0x0000C000
#define IPU_DP_CSC_ASYNC_1__DP_CSC_B1_ASYNC IPU_REGISTERS_OFFSET+0x000180B8,0x00003FFF

#define IPU_DI0_DW_GEN_0__ADDR                    IPU_REGISTERS_OFFSET+0x00040058
#define IPU_DI0_DW_GEN_0__EMPTY                   IPU_REGISTERS_OFFSET+0x00040058,0x00000000
#define IPU_DI0_DW_GEN_0__FULL                    IPU_REGISTERS_OFFSET+0x00040058,0xffffffff
#define IPU_DI0_DW_GEN_0__DI0_SERIAL_PERIOD_0     IPU_REGISTERS_OFFSET+0x00040058,0xFF000000
#define IPU_DI0_DW_GEN_0__DI0_START_PERIOD_0      IPU_REGISTERS_OFFSET+0x00040058,0x00FF0000
#define IPU_DI0_DW_GEN_0__DI0_CST_0               IPU_REGISTERS_OFFSET+0x00040058,0x0000C000
#define IPU_DI0_DW_GEN_0__DI0_SERIAL_VALID_BITS_0 IPU_REGISTERS_OFFSET+0x00040058,0x000001F0
#define IPU_DI0_DW_GEN_0__DI0_SERIAL_RS_0         IPU_REGISTERS_OFFSET+0x00040058,0x0000000C
#define IPU_DI0_DW_GEN_0__DI0_SERIAL_CLK_0        IPU_REGISTERS_OFFSET+0x00040058,0x00000003

#define IPU_DI0_DW_GEN_1__ADDR                    IPU_REGISTERS_OFFSET+0x0004005C
#define IPU_DI0_DW_GEN_1__EMPTY                   IPU_REGISTERS_OFFSET+0x0004005C,0x00000000
#define IPU_DI0_DW_GEN_1__FULL                    IPU_REGISTERS_OFFSET+0x0004005C,0xffffffff
#define IPU_DI0_DW_GEN_1__DI0_SERIAL_PERIOD_1     IPU_REGISTERS_OFFSET+0x0004005C,0xFF000000
#define IPU_DI0_DW_GEN_1__DI0_START_PERIOD_1      IPU_REGISTERS_OFFSET+0x0004005C,0x00FF0000
#define IPU_DI0_DW_GEN_1__DI0_CST_1               IPU_REGISTERS_OFFSET+0x0004005C,0x0000C000
#define IPU_DI0_DW_GEN_1__DI0_SERIAL_VALID_BITS_1 IPU_REGISTERS_OFFSET+0x0004005C,0x000001F0
#define IPU_DI0_DW_GEN_1__DI0_SERIAL_RS_1         IPU_REGISTERS_OFFSET+0x0004005C,0x0000000C
#define IPU_DI0_DW_GEN_1__DI0_SERIAL_CLK_1        IPU_REGISTERS_OFFSET+0x0004005C,0x00000003

#define IPU_DI0_DW_GEN_2__ADDR                    IPU_REGISTERS_OFFSET+0x00040060
#define IPU_DI0_DW_GEN_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00040060,0x00000000
#define IPU_DI0_DW_GEN_2__FULL                    IPU_REGISTERS_OFFSET+0x00040060,0xffffffff
#define IPU_DI0_DW_GEN_2__DI0_SERIAL_PERIOD_2     IPU_REGISTERS_OFFSET+0x00040060,0xFF000000
#define IPU_DI0_DW_GEN_2__DI0_START_PERIOD_2      IPU_REGISTERS_OFFSET+0x00040060,0x00FF0000
#define IPU_DI0_DW_GEN_2__DI0_CST_2               IPU_REGISTERS_OFFSET+0x00040060,0x0000C000
#define IPU_DI0_DW_GEN_2__DI0_SERIAL_VALID_BITS_2 IPU_REGISTERS_OFFSET+0x00040060,0x000001F0
#define IPU_DI0_DW_GEN_2__DI0_SERIAL_RS_2         IPU_REGISTERS_OFFSET+0x00040060,0x0000000C
#define IPU_DI0_DW_GEN_2__DI0_SERIAL_CLK_2        IPU_REGISTERS_OFFSET+0x00040060,0x00000003

#define IPU_DI0_DW_GEN_3__ADDR                    IPU_REGISTERS_OFFSET+0x00040064
#define IPU_DI0_DW_GEN_3__EMPTY                   IPU_REGISTERS_OFFSET+0x00040064,0x00000000
#define IPU_DI0_DW_GEN_3__FULL                    IPU_REGISTERS_OFFSET+0x00040064,0xffffffff
#define IPU_DI0_DW_GEN_3__DI0_SERIAL_PERIOD_3     IPU_REGISTERS_OFFSET+0x00040064,0xFF000000
#define IPU_DI0_DW_GEN_3__DI0_START_PERIOD_3      IPU_REGISTERS_OFFSET+0x00040064,0x00FF0000
#define IPU_DI0_DW_GEN_3__DI0_CST_3               IPU_REGISTERS_OFFSET+0x00040064,0x0000C000
#define IPU_DI0_DW_GEN_3__DI0_SERIAL_VALID_BITS_3 IPU_REGISTERS_OFFSET+0x00040064,0x000001F0
#define IPU_DI0_DW_GEN_3__DI0_SERIAL_RS_3         IPU_REGISTERS_OFFSET+0x00040064,0x0000000C
#define IPU_DI0_DW_GEN_3__DI0_SERIAL_CLK_3        IPU_REGISTERS_OFFSET+0x00040064,0x00000003

#define IPU_DI0_DW_GEN_4__ADDR                    IPU_REGISTERS_OFFSET+0x00040068
#define IPU_DI0_DW_GEN_4__EMPTY                   IPU_REGISTERS_OFFSET+0x00040068,0x00000000
#define IPU_DI0_DW_GEN_4__FULL                    IPU_REGISTERS_OFFSET+0x00040068,0xffffffff
#define IPU_DI0_DW_GEN_4__DI0_SERIAL_PERIOD_4     IPU_REGISTERS_OFFSET+0x00040068,0xFF000000
#define IPU_DI0_DW_GEN_4__DI0_START_PERIOD_4      IPU_REGISTERS_OFFSET+0x00040068,0x00FF0000
#define IPU_DI0_DW_GEN_4__DI0_CST_4               IPU_REGISTERS_OFFSET+0x00040068,0x0000C000
#define IPU_DI0_DW_GEN_4__DI0_SERIAL_VALID_BITS_4 IPU_REGISTERS_OFFSET+0x00040068,0x000001F0
#define IPU_DI0_DW_GEN_4__DI0_SERIAL_RS_4         IPU_REGISTERS_OFFSET+0x00040068,0x0000000C
#define IPU_DI0_DW_GEN_4__DI0_SERIAL_CLK_4        IPU_REGISTERS_OFFSET+0x00040068,0x00000003

#define IPU_DI0_DW_GEN_5__ADDR                    IPU_REGISTERS_OFFSET+0x0004006C
#define IPU_DI0_DW_GEN_5__EMPTY                   IPU_REGISTERS_OFFSET+0x0004006C,0x00000000
#define IPU_DI0_DW_GEN_5__FULL                    IPU_REGISTERS_OFFSET+0x0004006C,0xffffffff
#define IPU_DI0_DW_GEN_5__DI0_SERIAL_PERIOD_5     IPU_REGISTERS_OFFSET+0x0004006C,0xFF000000
#define IPU_DI0_DW_GEN_5__DI0_START_PERIOD_5      IPU_REGISTERS_OFFSET+0x0004006C,0x00FF0000
#define IPU_DI0_DW_GEN_5__DI0_CST_5               IPU_REGISTERS_OFFSET+0x0004006C,0x0000C000
#define IPU_DI0_DW_GEN_5__DI0_SERIAL_VALID_BITS_5 IPU_REGISTERS_OFFSET+0x0004006C,0x000001F0
#define IPU_DI0_DW_GEN_5__DI0_SERIAL_RS_5         IPU_REGISTERS_OFFSET+0x0004006C,0x0000000C
#define IPU_DI0_DW_GEN_5__DI0_SERIAL_CLK_5        IPU_REGISTERS_OFFSET+0x0004006C,0x00000003

#define IPU_DI0_DW_GEN_6__ADDR                    IPU_REGISTERS_OFFSET+0x00040070
#define IPU_DI0_DW_GEN_6__EMPTY                   IPU_REGISTERS_OFFSET+0x00040070,0x00000000
#define IPU_DI0_DW_GEN_6__FULL                    IPU_REGISTERS_OFFSET+0x00040070,0xffffffff
#define IPU_DI0_DW_GEN_6__DI0_SERIAL_PERIOD_6     IPU_REGISTERS_OFFSET+0x00040070,0xFF000000
#define IPU_DI0_DW_GEN_6__DI0_START_PERIOD_6      IPU_REGISTERS_OFFSET+0x00040070,0x00FF0000
#define IPU_DI0_DW_GEN_6__DI0_CST_6               IPU_REGISTERS_OFFSET+0x00040070,0x0000C000
#define IPU_DI0_DW_GEN_6__DI0_SERIAL_VALID_BITS_6 IPU_REGISTERS_OFFSET+0x00040070,0x000001F0
#define IPU_DI0_DW_GEN_6__DI0_SERIAL_RS_6         IPU_REGISTERS_OFFSET+0x00040070,0x0000000C
#define IPU_DI0_DW_GEN_6__DI0_SERIAL_CLK_6        IPU_REGISTERS_OFFSET+0x00040070,0x00000003

#define IPU_DI0_DW_GEN_7__ADDR                    IPU_REGISTERS_OFFSET+0x00040074
#define IPU_DI0_DW_GEN_7__EMPTY                   IPU_REGISTERS_OFFSET+0x00040074,0x00000000
#define IPU_DI0_DW_GEN_7__FULL                    IPU_REGISTERS_OFFSET+0x00040074,0xffffffff
#define IPU_DI0_DW_GEN_7__DI0_SERIAL_PERIOD_7     IPU_REGISTERS_OFFSET+0x00040074,0xFF000000
#define IPU_DI0_DW_GEN_7__DI0_START_PERIOD_7      IPU_REGISTERS_OFFSET+0x00040074,0x00FF0000
#define IPU_DI0_DW_GEN_7__DI0_CST_7               IPU_REGISTERS_OFFSET+0x00040074,0x0000C000
#define IPU_DI0_DW_GEN_7__DI0_SERIAL_VALID_BITS_7 IPU_REGISTERS_OFFSET+0x00040074,0x000001F0
#define IPU_DI0_DW_GEN_7__DI0_SERIAL_RS_7         IPU_REGISTERS_OFFSET+0x00040074,0x0000000C
#define IPU_DI0_DW_GEN_7__DI0_SERIAL_CLK_7        IPU_REGISTERS_OFFSET+0x00040074,0x00000003

#define IPU_DI0_DW_GEN_8__ADDR                    IPU_REGISTERS_OFFSET+0x00040078
#define IPU_DI0_DW_GEN_8__EMPTY                   IPU_REGISTERS_OFFSET+0x00040078,0x00000000
#define IPU_DI0_DW_GEN_8__FULL                    IPU_REGISTERS_OFFSET+0x00040078,0xffffffff
#define IPU_DI0_DW_GEN_8__DI0_SERIAL_PERIOD_8     IPU_REGISTERS_OFFSET+0x00040078,0xFF000000
#define IPU_DI0_DW_GEN_8__DI0_START_PERIOD_8      IPU_REGISTERS_OFFSET+0x00040078,0x00FF0000
#define IPU_DI0_DW_GEN_8__DI0_CST_8               IPU_REGISTERS_OFFSET+0x00040078,0x0000C000
#define IPU_DI0_DW_GEN_8__DI0_SERIAL_VALID_BITS_8 IPU_REGISTERS_OFFSET+0x00040078,0x000001F0
#define IPU_DI0_DW_GEN_8__DI0_SERIAL_RS_8         IPU_REGISTERS_OFFSET+0x00040078,0x0000000C
#define IPU_DI0_DW_GEN_8__DI0_SERIAL_CLK_8        IPU_REGISTERS_OFFSET+0x00040078,0x00000003

#define IPU_DI0_DW_GEN_9__ADDR                    IPU_REGISTERS_OFFSET+0x0004007C
#define IPU_DI0_DW_GEN_9__EMPTY                   IPU_REGISTERS_OFFSET+0x0004007C,0x00000000
#define IPU_DI0_DW_GEN_9__FULL                    IPU_REGISTERS_OFFSET+0x0004007C,0xffffffff
#define IPU_DI0_DW_GEN_9__DI0_SERIAL_PERIOD_9     IPU_REGISTERS_OFFSET+0x0004007C,0xFF000000
#define IPU_DI0_DW_GEN_9__DI0_START_PERIOD_9      IPU_REGISTERS_OFFSET+0x0004007C,0x00FF0000
#define IPU_DI0_DW_GEN_9__DI0_CST_9               IPU_REGISTERS_OFFSET+0x0004007C,0x0000C000
#define IPU_DI0_DW_GEN_9__DI0_SERIAL_VALID_BITS_9 IPU_REGISTERS_OFFSET+0x0004007C,0x000001F0
#define IPU_DI0_DW_GEN_9__DI0_SERIAL_RS_9         IPU_REGISTERS_OFFSET+0x0004007C,0x0000000C
#define IPU_DI0_DW_GEN_9__DI0_SERIAL_CLK_9        IPU_REGISTERS_OFFSET+0x0004007C,0x00000003

#define IPU_DI0_DW_GEN_10__ADDR                     IPU_REGISTERS_OFFSET+0x00040080
#define IPU_DI0_DW_GEN_10__EMPTY                    IPU_REGISTERS_OFFSET+0x00040080,0x00000000
#define IPU_DI0_DW_GEN_10__FULL                     IPU_REGISTERS_OFFSET+0x00040080,0xffffffff
#define IPU_DI0_DW_GEN_10__DI0_SERIAL_PERIOD_10     IPU_REGISTERS_OFFSET+0x00040080,0xFF000000
#define IPU_DI0_DW_GEN_10__DI0_START_PERIOD_10      IPU_REGISTERS_OFFSET+0x00040080,0x00FF0000
#define IPU_DI0_DW_GEN_10__DI0_CST_10               IPU_REGISTERS_OFFSET+0x00040080,0x0000C000
#define IPU_DI0_DW_GEN_10__DI0_SERIAL_VALID_BITS_10 IPU_REGISTERS_OFFSET+0x00040080,0x000001F0
#define IPU_DI0_DW_GEN_10__DI0_SERIAL_RS_10         IPU_REGISTERS_OFFSET+0x00040080,0x0000000C
#define IPU_DI0_DW_GEN_10__DI0_SERIAL_CLK_10        IPU_REGISTERS_OFFSET+0x00040080,0x00000003

#define IPU_DI0_DW_GEN_11__ADDR                     IPU_REGISTERS_OFFSET+0x00040084
#define IPU_DI0_DW_GEN_11__EMPTY                    IPU_REGISTERS_OFFSET+0x00040084,0x00000000
#define IPU_DI0_DW_GEN_11__FULL                     IPU_REGISTERS_OFFSET+0x00040084,0xffffffff
#define IPU_DI0_DW_GEN_11__DI0_SERIAL_PERIOD_11     IPU_REGISTERS_OFFSET+0x00040084,0xFF000000
#define IPU_DI0_DW_GEN_11__DI0_START_PERIOD_11      IPU_REGISTERS_OFFSET+0x00040084,0x00FF0000
#define IPU_DI0_DW_GEN_11__DI0_CST_11               IPU_REGISTERS_OFFSET+0x00040084,0x0000C000
#define IPU_DI0_DW_GEN_11__DI0_SERIAL_VALID_BITS_11 IPU_REGISTERS_OFFSET+0x00040084,0x000001F0
#define IPU_DI0_DW_GEN_11__DI0_SERIAL_RS_11         IPU_REGISTERS_OFFSET+0x00040084,0x0000000C
#define IPU_DI0_DW_GEN_11__DI0_SERIAL_CLK_11        IPU_REGISTERS_OFFSET+0x00040084,0x00000003

#define IPU_DI1_DW_GEN_0__ADDR                    IPU_REGISTERS_OFFSET+0x00048058
#define IPU_DI1_DW_GEN_0__EMPTY                   IPU_REGISTERS_OFFSET+0x00048058,0x00000000
#define IPU_DI1_DW_GEN_0__FULL                    IPU_REGISTERS_OFFSET+0x00048058,0xffffffff
#define IPU_DI1_DW_GEN_0__DI1_SERIAL_PERIOD_0     IPU_REGISTERS_OFFSET+0x00048058,0xFF000000
#define IPU_DI1_DW_GEN_0__DI1_START_PERIOD_0      IPU_REGISTERS_OFFSET+0x00048058,0x00FF0000
#define IPU_DI1_DW_GEN_0__DI1_CST_0               IPU_REGISTERS_OFFSET+0x00048058,0x0000C000
#define IPU_DI1_DW_GEN_0__DI1_SERIAL_VALID_BITS_0 IPU_REGISTERS_OFFSET+0x00048058,0x000001F0
#define IPU_DI1_DW_GEN_0__DI1_SERIAL_RS_0         IPU_REGISTERS_OFFSET+0x00048058,0x0000000C
#define IPU_DI1_DW_GEN_0__DI1_SERIAL_CLK_0        IPU_REGISTERS_OFFSET+0x00048058,0x00000003

#define IPU_DI1_DW_GEN_1__ADDR                    IPU_REGISTERS_OFFSET+0x0004805C
#define IPU_DI1_DW_GEN_1__EMPTY                   IPU_REGISTERS_OFFSET+0x0004805C,0x00000000
#define IPU_DI1_DW_GEN_1__FULL                    IPU_REGISTERS_OFFSET+0x0004805C,0xffffffff
#define IPU_DI1_DW_GEN_1__DI1_SERIAL_PERIOD_1     IPU_REGISTERS_OFFSET+0x0004805C,0xFF000000
#define IPU_DI1_DW_GEN_1__DI1_START_PERIOD_1      IPU_REGISTERS_OFFSET+0x0004805C,0x00FF0000
#define IPU_DI1_DW_GEN_1__DI1_CST_1               IPU_REGISTERS_OFFSET+0x0004805C,0x0000C000
#define IPU_DI1_DW_GEN_1__DI1_SERIAL_VALID_BITS_1 IPU_REGISTERS_OFFSET+0x0004805C,0x000001F0
#define IPU_DI1_DW_GEN_1__DI1_SERIAL_RS_1         IPU_REGISTERS_OFFSET+0x0004805C,0x0000000C
#define IPU_DI1_DW_GEN_1__DI1_SERIAL_CLK_1        IPU_REGISTERS_OFFSET+0x0004805C,0x00000003

#define IPU_DI1_DW_GEN_2__ADDR                    IPU_REGISTERS_OFFSET+0x00048060
#define IPU_DI1_DW_GEN_2__EMPTY                   IPU_REGISTERS_OFFSET+0x00048060,0x00000000
#define IPU_DI1_DW_GEN_2__FULL                    IPU_REGISTERS_OFFSET+0x00048060,0xffffffff
#define IPU_DI1_DW_GEN_2__DI1_SERIAL_PERIOD_2     IPU_REGISTERS_OFFSET+0x00048060,0xFF000000
#define IPU_DI1_DW_GEN_2__DI1_START_PERIOD_2      IPU_REGISTERS_OFFSET+0x00048060,0x00FF0000
#define IPU_DI1_DW_GEN_2__DI1_CST_2               IPU_REGISTERS_OFFSET+0x00048060,0x0000C000
#define IPU_DI1_DW_GEN_2__DI1_SERIAL_VALID_BITS_2 IPU_REGISTERS_OFFSET+0x00048060,0x000001F0
#define IPU_DI1_DW_GEN_2__DI1_SERIAL_RS_2         IPU_REGISTERS_OFFSET+0x00048060,0x0000000C
#define IPU_DI1_DW_GEN_2__DI1_SERIAL_CLK_2        IPU_REGISTERS_OFFSET+0x00048060,0x00000003

#define IPU_DI1_DW_GEN_3__ADDR                    IPU_REGISTERS_OFFSET+0x00048064
#define IPU_DI1_DW_GEN_3__EMPTY                   IPU_REGISTERS_OFFSET+0x00048064,0x00000000
#define IPU_DI1_DW_GEN_3__FULL                    IPU_REGISTERS_OFFSET+0x00048064,0xffffffff
#define IPU_DI1_DW_GEN_3__DI1_SERIAL_PERIOD_3     IPU_REGISTERS_OFFSET+0x00048064,0xFF000000
#define IPU_DI1_DW_GEN_3__DI1_START_PERIOD_3      IPU_REGISTERS_OFFSET+0x00048064,0x00FF0000
#define IPU_DI1_DW_GEN_3__DI1_CST_3               IPU_REGISTERS_OFFSET+0x00048064,0x0000C000
#define IPU_DI1_DW_GEN_3__DI1_SERIAL_VALID_BITS_3 IPU_REGISTERS_OFFSET+0x00048064,0x000001F0
#define IPU_DI1_DW_GEN_3__DI1_SERIAL_RS_3         IPU_REGISTERS_OFFSET+0x00048064,0x0000000C
#define IPU_DI1_DW_GEN_3__DI1_SERIAL_CLK_3        IPU_REGISTERS_OFFSET+0x00048064,0x00000003

#define IPU_DI1_DW_GEN_4__ADDR                    IPU_REGISTERS_OFFSET+0x00048068
#define IPU_DI1_DW_GEN_4__EMPTY                   IPU_REGISTERS_OFFSET+0x00048068,0x00000000
#define IPU_DI1_DW_GEN_4__FULL                    IPU_REGISTERS_OFFSET+0x00048068,0xffffffff
#define IPU_DI1_DW_GEN_4__DI1_SERIAL_PERIOD_4     IPU_REGISTERS_OFFSET+0x00048068,0xFF000000
#define IPU_DI1_DW_GEN_4__DI1_START_PERIOD_4      IPU_REGISTERS_OFFSET+0x00048068,0x00FF0000
#define IPU_DI1_DW_GEN_4__DI1_CST_4               IPU_REGISTERS_OFFSET+0x00048068,0x0000C000
#define IPU_DI1_DW_GEN_4__DI1_SERIAL_VALID_BITS_4 IPU_REGISTERS_OFFSET+0x00048068,0x000001F0
#define IPU_DI1_DW_GEN_4__DI1_SERIAL_RS_4         IPU_REGISTERS_OFFSET+0x00048068,0x0000000C
#define IPU_DI1_DW_GEN_4__DI1_SERIAL_CLK_4        IPU_REGISTERS_OFFSET+0x00048068,0x00000003

#define IPU_DI1_DW_GEN_5__ADDR                    IPU_REGISTERS_OFFSET+0x0004806C
#define IPU_DI1_DW_GEN_5__EMPTY                   IPU_REGISTERS_OFFSET+0x0004806C,0x00000000
#define IPU_DI1_DW_GEN_5__FULL                    IPU_REGISTERS_OFFSET+0x0004806C,0xffffffff
#define IPU_DI1_DW_GEN_5__DI1_SERIAL_PERIOD_5     IPU_REGISTERS_OFFSET+0x0004806C,0xFF000000
#define IPU_DI1_DW_GEN_5__DI1_START_PERIOD_5      IPU_REGISTERS_OFFSET+0x0004806C,0x00FF0000
#define IPU_DI1_DW_GEN_5__DI1_CST_5               IPU_REGISTERS_OFFSET+0x0004806C,0x0000C000
#define IPU_DI1_DW_GEN_5__DI1_SERIAL_VALID_BITS_5 IPU_REGISTERS_OFFSET+0x0004806C,0x000001F0
#define IPU_DI1_DW_GEN_5__DI1_SERIAL_RS_5         IPU_REGISTERS_OFFSET+0x0004806C,0x0000000C
#define IPU_DI1_DW_GEN_5__DI1_SERIAL_CLK_5        IPU_REGISTERS_OFFSET+0x0004806C,0x00000003

#define IPU_DI1_DW_GEN_6__ADDR                    IPU_REGISTERS_OFFSET+0x00048070
#define IPU_DI1_DW_GEN_6__EMPTY                   IPU_REGISTERS_OFFSET+0x00048070,0x00000000
#define IPU_DI1_DW_GEN_6__FULL                    IPU_REGISTERS_OFFSET+0x00048070,0xffffffff
#define IPU_DI1_DW_GEN_6__DI1_SERIAL_PERIOD_6     IPU_REGISTERS_OFFSET+0x00048070,0xFF000000
#define IPU_DI1_DW_GEN_6__DI1_START_PERIOD_6      IPU_REGISTERS_OFFSET+0x00048070,0x00FF0000
#define IPU_DI1_DW_GEN_6__DI1_CST_6               IPU_REGISTERS_OFFSET+0x00048070,0x0000C000
#define IPU_DI1_DW_GEN_6__DI1_SERIAL_VALID_BITS_6 IPU_REGISTERS_OFFSET+0x00048070,0x000001F0
#define IPU_DI1_DW_GEN_6__DI1_SERIAL_RS_6         IPU_REGISTERS_OFFSET+0x00048070,0x0000000C
#define IPU_DI1_DW_GEN_6__DI1_SERIAL_CLK_6        IPU_REGISTERS_OFFSET+0x00048070,0x00000003

#define IPU_DI1_DW_GEN_7__ADDR                    IPU_REGISTERS_OFFSET+0x00048074
#define IPU_DI1_DW_GEN_7__EMPTY                   IPU_REGISTERS_OFFSET+0x00048074,0x00000000
#define IPU_DI1_DW_GEN_7__FULL                    IPU_REGISTERS_OFFSET+0x00048074,0xffffffff
#define IPU_DI1_DW_GEN_7__DI1_SERIAL_PERIOD_7     IPU_REGISTERS_OFFSET+0x00048074,0xFF000000
#define IPU_DI1_DW_GEN_7__DI1_START_PERIOD_7      IPU_REGISTERS_OFFSET+0x00048074,0x00FF0000
#define IPU_DI1_DW_GEN_7__DI1_CST_7               IPU_REGISTERS_OFFSET+0x00048074,0x0000C000
#define IPU_DI1_DW_GEN_7__DI1_SERIAL_VALID_BITS_7 IPU_REGISTERS_OFFSET+0x00048074,0x000001F0
#define IPU_DI1_DW_GEN_7__DI1_SERIAL_RS_7         IPU_REGISTERS_OFFSET+0x00048074,0x0000000C
#define IPU_DI1_DW_GEN_7__DI1_SERIAL_CLK_7        IPU_REGISTERS_OFFSET+0x00048074,0x00000003

#define IPU_DI1_DW_GEN_8__ADDR                    IPU_REGISTERS_OFFSET+0x00048078
#define IPU_DI1_DW_GEN_8__EMPTY                   IPU_REGISTERS_OFFSET+0x00048078,0x00000000
#define IPU_DI1_DW_GEN_8__FULL                    IPU_REGISTERS_OFFSET+0x00048078,0xffffffff
#define IPU_DI1_DW_GEN_8__DI1_SERIAL_PERIOD_8     IPU_REGISTERS_OFFSET+0x00048078,0xFF000000
#define IPU_DI1_DW_GEN_8__DI1_START_PERIOD_8      IPU_REGISTERS_OFFSET+0x00048078,0x00FF0000
#define IPU_DI1_DW_GEN_8__DI1_CST_8               IPU_REGISTERS_OFFSET+0x00048078,0x0000C000
#define IPU_DI1_DW_GEN_8__DI1_SERIAL_VALID_BITS_8 IPU_REGISTERS_OFFSET+0x00048078,0x000001F0
#define IPU_DI1_DW_GEN_8__DI1_SERIAL_RS_8         IPU_REGISTERS_OFFSET+0x00048078,0x0000000C
#define IPU_DI1_DW_GEN_8__DI1_SERIAL_CLK_8        IPU_REGISTERS_OFFSET+0x00048078,0x00000003

#define IPU_DI1_DW_GEN_9__ADDR                    IPU_REGISTERS_OFFSET+0x0004807C
#define IPU_DI1_DW_GEN_9__EMPTY                   IPU_REGISTERS_OFFSET+0x0004807C,0x00000000
#define IPU_DI1_DW_GEN_9__FULL                    IPU_REGISTERS_OFFSET+0x0004807C,0xffffffff
#define IPU_DI1_DW_GEN_9__DI1_SERIAL_PERIOD_9     IPU_REGISTERS_OFFSET+0x0004807C,0xFF000000
#define IPU_DI1_DW_GEN_9__DI1_START_PERIOD_9      IPU_REGISTERS_OFFSET+0x0004807C,0x00FF0000
#define IPU_DI1_DW_GEN_9__DI1_CST_9               IPU_REGISTERS_OFFSET+0x0004807C,0x0000C000
#define IPU_DI1_DW_GEN_9__DI1_SERIAL_VALID_BITS_9 IPU_REGISTERS_OFFSET+0x0004807C,0x000001F0
#define IPU_DI1_DW_GEN_9__DI1_SERIAL_RS_9         IPU_REGISTERS_OFFSET+0x0004807C,0x0000000C
#define IPU_DI1_DW_GEN_9__DI1_SERIAL_CLK_9        IPU_REGISTERS_OFFSET+0x0004807C,0x00000003

#define IPU_DI1_DW_GEN_10__ADDR                     IPU_REGISTERS_OFFSET+0x00048080
#define IPU_DI1_DW_GEN_10__EMPTY                    IPU_REGISTERS_OFFSET+0x00048080,0x00000000
#define IPU_DI1_DW_GEN_10__FULL                     IPU_REGISTERS_OFFSET+0x00048080,0xffffffff
#define IPU_DI1_DW_GEN_10__DI1_SERIAL_PERIOD_10     IPU_REGISTERS_OFFSET+0x00048080,0xFF000000
#define IPU_DI1_DW_GEN_10__DI1_START_PERIOD_10      IPU_REGISTERS_OFFSET+0x00048080,0x00FF0000
#define IPU_DI1_DW_GEN_10__DI1_CST_10               IPU_REGISTERS_OFFSET+0x00048080,0x0000C000
#define IPU_DI1_DW_GEN_10__DI0_SERIAL_VALID_BITS_10 IPU_REGISTERS_OFFSET+0x00048080,0x000001F0
#define IPU_DI1_DW_GEN_10__DI1_SERIAL_RS_10         IPU_REGISTERS_OFFSET+0x00048080,0x0000000C
#define IPU_DI1_DW_GEN_10__DI1_SERIAL_CLK_10        IPU_REGISTERS_OFFSET+0x00048080,0x00000003

#define IPU_DI1_DW_GEN_11__ADDR                     IPU_REGISTERS_OFFSET+0x00048084
#define IPU_DI1_DW_GEN_11__EMPTY                    IPU_REGISTERS_OFFSET+0x00048084,0x00000000
#define IPU_DI1_DW_GEN_11__FULL                     IPU_REGISTERS_OFFSET+0x00048084,0xffffffff
#define IPU_DI1_DW_GEN_11__DI1_SERIAL_PERIOD_11     IPU_REGISTERS_OFFSET+0x00048084,0xFF000000
#define IPU_DI1_DW_GEN_11__DI1_START_PERIOD_11      IPU_REGISTERS_OFFSET+0x00048084,0x00FF0000
#define IPU_DI1_DW_GEN_11__DI1_CST_11               IPU_REGISTERS_OFFSET+0x00048084,0x0000C000
#define IPU_DI1_DW_GEN_11__DI0_SERIAL_VALID_BITS_11 IPU_REGISTERS_OFFSET+0x00048084,0x000001F0
#define IPU_DI1_DW_GEN_11__DI1_SERIAL_RS_11         IPU_REGISTERS_OFFSET+0x00048084,0x0000000C
#define IPU_DI1_DW_GEN_11__DI1_SERIAL_CLK_11        IPU_REGISTERS_OFFSET+0x00048084,0x00000003

#define CPMEM_WORD0_DATA0_INT__ADDR  IPU_MEMORY_OFFSET+0x0000000
#define CPMEM_WORD0_DATA0_INT__EMPTY IPU_MEMORY_OFFSET+0x0000000,0x00000000
#define CPMEM_WORD0_DATA0_INT__FULL  IPU_MEMORY_OFFSET+0x0000000,0xffffffff
#define CPMEM_WORD0_DATA0_INT__XB    IPU_MEMORY_OFFSET+0x0000000,0xFFF80000
#define CPMEM_WORD0_DATA0_INT__YV    IPU_MEMORY_OFFSET+0x0000000,0x0007FC00
#define CPMEM_WORD0_DATA0_INT__XV    IPU_MEMORY_OFFSET+0x0000000,0x000003FF

#define CPMEM_WORD0_DATA1_INT__ADDR   IPU_MEMORY_OFFSET+0x0000004
#define CPMEM_WORD0_DATA1_INT__EMPTY  IPU_MEMORY_OFFSET+0x0000004,0x00000000
#define CPMEM_WORD0_DATA1_INT__FULL   IPU_MEMORY_OFFSET+0x0000004,0xffffffff
#define CPMEM_WORD0_DATA1_INT__SY_LOW IPU_MEMORY_OFFSET+0x0000004,0xFC000000
#define CPMEM_WORD0_DATA1_INT__SX     IPU_MEMORY_OFFSET+0x0000004,0x03FFC000
#define CPMEM_WORD0_DATA1_INT__CF     IPU_MEMORY_OFFSET+0x0000004,0x00002000
#define CPMEM_WORD0_DATA1_INT__NSB_B  IPU_MEMORY_OFFSET+0x0000004,0x00001000
#define CPMEM_WORD0_DATA1_INT__YB     IPU_MEMORY_OFFSET+0x0000004,0x00000FFF

#define CPMEM_WORD0_DATA2_INT__ADDR    IPU_MEMORY_OFFSET+0x0000008
#define CPMEM_WORD0_DATA2_INT__EMPTY   IPU_MEMORY_OFFSET+0x0000008,0x00000000
#define CPMEM_WORD0_DATA2_INT__FULL    IPU_MEMORY_OFFSET+0x0000008,0xffffffff
#define CPMEM_WORD0_DATA2_INT__SM      IPU_MEMORY_OFFSET+0x0000008,0xFFC00000
#define CPMEM_WORD0_DATA2_INT__SDX     IPU_MEMORY_OFFSET+0x0000008,0x003F8000
#define CPMEM_WORD0_DATA2_INT__NS      IPU_MEMORY_OFFSET+0x0000008,0x00007FE0
#define CPMEM_WORD0_DATA2_INT__SY_HIGH IPU_MEMORY_OFFSET+0x0000008,0x0000001F

#define CPMEM_WORD0_DATA3_INT__ADDR    IPU_MEMORY_OFFSET+0x000000C
#define CPMEM_WORD0_DATA3_INT__EMPTY   IPU_MEMORY_OFFSET+0x000000C,0x00000000
#define CPMEM_WORD0_DATA3_INT__FULL    IPU_MEMORY_OFFSET+0x000000C,0xffffffff
#define CPMEM_WORD0_DATA3_INT__FW_LOW  IPU_MEMORY_OFFSET+0x000000C,0xE0000000
#define CPMEM_WORD0_DATA3_INT__CAE     IPU_MEMORY_OFFSET+0x000000C,0x10000000
#define CPMEM_WORD0_DATA3_INT__CAP     IPU_MEMORY_OFFSET+0x000000C,0x08000000
#define CPMEM_WORD0_DATA3_INT__THE     IPU_MEMORY_OFFSET+0x000000C,0x04000000
#define CPMEM_WORD0_DATA3_INT__VF      IPU_MEMORY_OFFSET+0x000000C,0x02000000
#define CPMEM_WORD0_DATA3_INT__HF      IPU_MEMORY_OFFSET+0x000000C,0x01000000
#define CPMEM_WORD0_DATA3_INT__ROT     IPU_MEMORY_OFFSET+0x000000C,0x00800000
#define CPMEM_WORD0_DATA3_INT__BM      IPU_MEMORY_OFFSET+0x000000C,0x00600000
#define CPMEM_WORD0_DATA3_INT__BNDM    IPU_MEMORY_OFFSET+0x000000C,0x001C0000
#define CPMEM_WORD0_DATA3_INT__SO      IPU_MEMORY_OFFSET+0x000000C,0x00020000
#define CPMEM_WORD0_DATA3_INT__DIM     IPU_MEMORY_OFFSET+0x000000C,0x00010000
#define CPMEM_WORD0_DATA3_INT__DEC_SEL IPU_MEMORY_OFFSET+0x000000C,0x0000C000
#define CPMEM_WORD0_DATA3_INT__BPP     IPU_MEMORY_OFFSET+0x000000C,0x00003800
#define CPMEM_WORD0_DATA3_INT__SDRY    IPU_MEMORY_OFFSET+0x000000C,0x00000400
#define CPMEM_WORD0_DATA3_INT__SDRX    IPU_MEMORY_OFFSET+0x000000C,0x00000200
#define CPMEM_WORD0_DATA3_INT__SDY     IPU_MEMORY_OFFSET+0x000000C,0x000001FC
#define CPMEM_WORD0_DATA3_INT__SCE     IPU_MEMORY_OFFSET+0x000000C,0x00000002
#define CPMEM_WORD0_DATA3_INT__SCC     IPU_MEMORY_OFFSET+0x000000C,0x00000001

#define CPMEM_WORD0_DATA4_INT__ADDR     IPU_MEMORY_OFFSET+0x0000010
#define CPMEM_WORD0_DATA4_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000010,0x00000000
#define CPMEM_WORD0_DATA4_INT__FULL     IPU_MEMORY_OFFSET+0x0000010,0xffffffff
#define CPMEM_WORD0_DATA4_INT__RESERVED IPU_MEMORY_OFFSET+0x0000010,0xFF800000
#define CPMEM_WORD0_DATA4_INT__EOLI     IPU_MEMORY_OFFSET+0x0000010,0x00400000
#define CPMEM_WORD0_DATA4_INT__FH       IPU_MEMORY_OFFSET+0x0000010,0x003FFC00
#define CPMEM_WORD0_DATA4_INT__FW_HIGH  IPU_MEMORY_OFFSET+0x0000010,0x000003FF

#define CPMEM_WORD0_DATA0_N_INT__ADDR  IPU_MEMORY_OFFSET+0x0000000
#define CPMEM_WORD0_DATA0_N_INT__EMPTY IPU_MEMORY_OFFSET+0x0000000,0x00000000
#define CPMEM_WORD0_DATA0_N_INT__FULL  IPU_MEMORY_OFFSET+0x0000000,0xffffffff
#define CPMEM_WORD0_DATA0_N_INT__XB    IPU_MEMORY_OFFSET+0x0000000,0xFFF80000
#define CPMEM_WORD0_DATA0_N_INT__YV    IPU_MEMORY_OFFSET+0x0000000,0x0007FC00
#define CPMEM_WORD0_DATA0_N_INT__XV    IPU_MEMORY_OFFSET+0x0000000,0x000003FF

#define CPMEM_WORD0_DATA1_N_INT__ADDR    IPU_MEMORY_OFFSET+0x0000004
#define CPMEM_WORD0_DATA1_N_INT__EMPTY   IPU_MEMORY_OFFSET+0x0000004,0x00000000
#define CPMEM_WORD0_DATA1_N_INT__FULL    IPU_MEMORY_OFFSET+0x0000004,0xffffffff
#define CPMEM_WORD0_DATA1_N_INT__UBO_LOW IPU_MEMORY_OFFSET+0x0000004,0xFFFFC000
#define CPMEM_WORD0_DATA1_N_INT__CF      IPU_MEMORY_OFFSET+0x0000004,0x00002000
#define CPMEM_WORD0_DATA1_N_INT__NSB_B   IPU_MEMORY_OFFSET+0x0000004,0x00001000
#define CPMEM_WORD0_DATA1_N_INT__YB      IPU_MEMORY_OFFSET+0x0000004,0x00000FFF

#define CPMEM_WORD0_DATA2_N_INT__ADDR     IPU_MEMORY_OFFSET+0x0000008
#define CPMEM_WORD0_DATA2_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000008,0x00000000
#define CPMEM_WORD0_DATA2_N_INT__FULL     IPU_MEMORY_OFFSET+0x0000008,0xffffffff
#define CPMEM_WORD0_DATA2_N_INT__RESERVED IPU_MEMORY_OFFSET+0x0000008,0x80000000
#define CPMEM_WORD0_DATA2_N_INT__RDRW     IPU_MEMORY_OFFSET+0x0000008,0x40000000
#define CPMEM_WORD0_DATA2_N_INT__IOX      IPU_MEMORY_OFFSET+0x0000008,0x3c000000
#define CPMEM_WORD0_DATA2_N_INT__VBO      IPU_MEMORY_OFFSET+0x0000008,0x03FFFFF0
#define CPMEM_WORD0_DATA2_N_INT__UBO_HIGH IPU_MEMORY_OFFSET+0x0000008,0x0000000F

#define CPMEM_WORD0_DATA3_N_INT__ADDR     IPU_MEMORY_OFFSET+0x000000C
#define CPMEM_WORD0_DATA3_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x000000C,0x00000000
#define CPMEM_WORD0_DATA3_N_INT__FULL     IPU_MEMORY_OFFSET+0x000000C,0xffffffff
#define CPMEM_WORD0_DATA3_N_INT__FW_LOW   IPU_MEMORY_OFFSET+0x000000C,0xE0000000
#define CPMEM_WORD0_DATA3_N_INT__CAE      IPU_MEMORY_OFFSET+0x000000C,0x10000000
#define CPMEM_WORD0_DATA3_N_INT__CAP      IPU_MEMORY_OFFSET+0x000000C,0x08000000
#define CPMEM_WORD0_DATA3_N_INT__THE      IPU_MEMORY_OFFSET+0x000000C,0x04000000
#define CPMEM_WORD0_DATA3_N_INT__VF       IPU_MEMORY_OFFSET+0x000000C,0x02000000
#define CPMEM_WORD0_DATA3_N_INT__HF       IPU_MEMORY_OFFSET+0x000000C,0x01000000
#define CPMEM_WORD0_DATA3_N_INT__ROT      IPU_MEMORY_OFFSET+0x000000C,0x00800000
#define CPMEM_WORD0_DATA3_N_INT__BM       IPU_MEMORY_OFFSET+0x000000C,0x00600000
#define CPMEM_WORD0_DATA3_N_INT__BNDM     IPU_MEMORY_OFFSET+0x000000C,0x001C0000
#define CPMEM_WORD0_DATA3_N_INT__SO       IPU_MEMORY_OFFSET+0x000000C,0x00020000
#define CPMEM_WORD0_DATA3_N_INT__RESERVED IPU_MEMORY_OFFSET+0x000000C,0x0001FFFF

#define CPMEM_WORD0_DATA4_N_INT__ADDR     IPU_MEMORY_OFFSET+0x0000010
#define CPMEM_WORD0_DATA4_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000010,0x00000000
#define CPMEM_WORD0_DATA4_N_INT__FULL     IPU_MEMORY_OFFSET+0x0000010,0xffffffff
#define CPMEM_WORD0_DATA4_N_INT__RESERVED IPU_MEMORY_OFFSET+0x0000010,0xFF800000
#define CPMEM_WORD0_DATA4_N_INT__EOLI     IPU_MEMORY_OFFSET+0x0000010,0x00400000
#define CPMEM_WORD0_DATA4_N_INT__FH       IPU_MEMORY_OFFSET+0x0000010,0x003FFC00
#define CPMEM_WORD0_DATA4_N_INT__FW_HIGH  IPU_MEMORY_OFFSET+0x0000010,0x000003FF

#define CPMEM_WORD1_DATA0_INT__ADDR     IPU_MEMORY_OFFSET+0x0000020
#define CPMEM_WORD1_DATA0_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000020,0x00000000
#define CPMEM_WORD1_DATA0_INT__FULL     IPU_MEMORY_OFFSET+0x0000020,0xffffffff
#define CPMEM_WORD1_DATA0_INT__EBA1_LOW IPU_MEMORY_OFFSET+0x0000020,0xE0000000
#define CPMEM_WORD1_DATA0_INT__EBA0     IPU_MEMORY_OFFSET+0x0000020,0x1FFFFFFF

#define CPMEM_WORD1_DATA1_INT__ADDR      IPU_MEMORY_OFFSET+0x0000024
#define CPMEM_WORD1_DATA1_INT__EMPTY     IPU_MEMORY_OFFSET+0x0000024,0x00000000
#define CPMEM_WORD1_DATA1_INT__FULL      IPU_MEMORY_OFFSET+0x0000024,0xffffffff
#define CPMEM_WORD1_DATA1_INT__ILO_LOW   IPU_MEMORY_OFFSET+0x0000024,0xFC000000
#define CPMEM_WORD1_DATA1_INT__EBA1_HIGH IPU_MEMORY_OFFSET+0x0000024,0x03FFFFFF

#define CPMEM_WORD1_DATA2_INT__ADDR     IPU_MEMORY_OFFSET+0x0000028
#define CPMEM_WORD1_DATA2_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000028,0x00000000
#define CPMEM_WORD1_DATA2_INT__FULL     IPU_MEMORY_OFFSET+0x0000028,0xffffffff
#define CPMEM_WORD1_DATA2_INT__TH_LOW   IPU_MEMORY_OFFSET+0x0000028,0x80000000
#define CPMEM_WORD1_DATA2_INT__ID       IPU_MEMORY_OFFSET+0x0000028,0x60000000
#define CPMEM_WORD1_DATA2_INT__ALBM     IPU_MEMORY_OFFSET+0x0000028,0x1C000000
#define CPMEM_WORD1_DATA2_INT__ALU      IPU_MEMORY_OFFSET+0x0000028,0x02000000
#define CPMEM_WORD1_DATA2_INT__PFS      IPU_MEMORY_OFFSET+0x0000028,0x01E00000
#define CPMEM_WORD1_DATA2_INT__NPB      IPU_MEMORY_OFFSET+0x0000028,0x001FC000
#define CPMEM_WORD1_DATA2_INT__ILO_HIGH IPU_MEMORY_OFFSET+0x0000028,0x00003FFF

#define CPMEM_WORD1_DATA3_INT__ADDR    IPU_MEMORY_OFFSET+0x000002C
#define CPMEM_WORD1_DATA3_INT__EMPTY   IPU_MEMORY_OFFSET+0x000002C,0x00000000
#define CPMEM_WORD1_DATA3_INT__FULL    IPU_MEMORY_OFFSET+0x000002C,0xffffffff
#define CPMEM_WORD1_DATA3_INT__WID3    IPU_MEMORY_OFFSET+0x000002C,0xE0000000
#define CPMEM_WORD1_DATA3_INT__WID2    IPU_MEMORY_OFFSET+0x000002C,0x1C000000
#define CPMEM_WORD1_DATA3_INT__WID1    IPU_MEMORY_OFFSET+0x000002C,0x03800000
#define CPMEM_WORD1_DATA3_INT__WID0    IPU_MEMORY_OFFSET+0x000002C,0x00700000
#define CPMEM_WORD1_DATA3_INT__SL      IPU_MEMORY_OFFSET+0x000002C,0x000FFFC0
#define CPMEM_WORD1_DATA3_INT__TH_HIGH IPU_MEMORY_OFFSET+0x000002C,0x0000003F

#define CPMEM_WORD1_DATA4_INT__ADDR     IPU_MEMORY_OFFSET+0x0000030
#define CPMEM_WORD1_DATA4_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000030,0x00000000
#define CPMEM_WORD1_DATA4_INT__FULL     IPU_MEMORY_OFFSET+0x0000030,0xffffffff
#define CPMEM_WORD1_DATA4_INT__RESERVED IPU_MEMORY_OFFSET+0x0000030,0xFF800000
#define CPMEM_WORD1_DATA4_INT__DEC_SEL2 IPU_MEMORY_OFFSET+0x0000030,0x00400000
#define CPMEM_WORD1_DATA4_INT__CRE      IPU_MEMORY_OFFSET+0x0000030,0x00200000
#define CPMEM_WORD1_DATA4_INT__SXYS     IPU_MEMORY_OFFSET+0x0000030,0x00100000
#define CPMEM_WORD1_DATA4_INT__OFS3     IPU_MEMORY_OFFSET+0x0000030,0x000F8000
#define CPMEM_WORD1_DATA4_INT__OFS2     IPU_MEMORY_OFFSET+0x0000030,0x00007C00
#define CPMEM_WORD1_DATA4_INT__OFS1     IPU_MEMORY_OFFSET+0x0000030,0x000003E0
#define CPMEM_WORD1_DATA4_INT__OFS0     IPU_MEMORY_OFFSET+0x0000030,0x0000001F

#define CPMEM_WORD1_DATA0_N_INT__ADDR     IPU_MEMORY_OFFSET+0x0000020
#define CPMEM_WORD1_DATA0_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000020,0x00000000
#define CPMEM_WORD1_DATA0_N_INT__FULL     IPU_MEMORY_OFFSET+0x0000020,0xffffffff
#define CPMEM_WORD1_DATA0_N_INT__EBA1_LOW IPU_MEMORY_OFFSET+0x0000020,0xE0000000
#define CPMEM_WORD1_DATA0_N_INT__EBA0     IPU_MEMORY_OFFSET+0x0000020,0x1FFFFFFF

#define CPMEM_WORD1_DATA1_N_INT__ADDR      IPU_MEMORY_OFFSET+0x0000024
#define CPMEM_WORD1_DATA1_N_INT__EMPTY     IPU_MEMORY_OFFSET+0x0000024,0x00000000
#define CPMEM_WORD1_DATA1_N_INT__FULL      IPU_MEMORY_OFFSET+0x0000024,0xffffffff
#define CPMEM_WORD1_DATA1_N_INT__ILO_LOW   IPU_MEMORY_OFFSET+0x0000024,0xFC000000
#define CPMEM_WORD1_DATA1_N_INT__EBA1_HIGH IPU_MEMORY_OFFSET+0x0000024,0x03FFFFFF

#define CPMEM_WORD1_DATA2_N_INT__ADDR     IPU_MEMORY_OFFSET+0x0000028
#define CPMEM_WORD1_DATA2_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x0000028,0x00000000
#define CPMEM_WORD1_DATA2_N_INT__FULL     IPU_MEMORY_OFFSET+0x0000028,0xffffffff
#define CPMEM_WORD1_DATA2_N_INT__TH_LOW   IPU_MEMORY_OFFSET+0x0000028,0x80000000
#define CPMEM_WORD1_DATA2_N_INT__ID       IPU_MEMORY_OFFSET+0x0000028,0x60000000
#define CPMEM_WORD1_DATA2_N_INT__ALBM     IPU_MEMORY_OFFSET+0x0000028,0x1C000000
#define CPMEM_WORD1_DATA2_N_INT__ALU      IPU_MEMORY_OFFSET+0x0000028,0x02000000
#define CPMEM_WORD1_DATA2_N_INT__PFS      IPU_MEMORY_OFFSET+0x0000028,0x01E00000
#define CPMEM_WORD1_DATA2_N_INT__NPB      IPU_MEMORY_OFFSET+0x0000028,0x001FC000
#define CPMEM_WORD1_DATA2_N_INT__ILO_HIGH IPU_MEMORY_OFFSET+0x0000028,0x00003FFF

#define CPMEM_WORD1_DATA3_N_INT__ADDR     IPU_MEMORY_OFFSET+0x000002C
#define CPMEM_WORD1_DATA3_N_INT__EMPTY    IPU_MEMORY_OFFSET+0x000002C,0x00000000
#define CPMEM_WORD1_DATA3_N_INT__FULL     IPU_MEMORY_OFFSET+0x000002C,0xffffffff
#define CPMEM_WORD1_DATA3_N_INT__SLY      IPU_MEMORY_OFFSET+0x000002C,0x000FFFC0
#define CPMEM_WORD1_DATA3_N_INT__WID3     IPU_MEMORY_OFFSET+0x000002C,0xE0000000
#define CPMEM_WORD1_DATA3_N_INT__TH_HIGH  IPU_MEMORY_OFFSET+0x000002C,0x0000003F

#define CPMEM_WORD1_DATA4_N_INT__ADDR      IPU_MEMORY_OFFSET+0x0000030
#define CPMEM_WORD1_DATA4_N_INT__EMPTY     IPU_MEMORY_OFFSET+0x0000030,0x00000000
#define CPMEM_WORD1_DATA4_N_INT__FULL      IPU_MEMORY_OFFSET+0x0000030,0xffffffff
#define CPMEM_WORD1_DATA4_N_INT__RESERVED  IPU_MEMORY_OFFSET+0x0000030,0xFFDFC000
#define CPMEM_WORD1_DATA4_N_INT__CRE       IPU_MEMORY_OFFSET+0x0000030,0x00200000
#define CPMEM_WORD1_DATA4_N_INT__SLUV      IPU_MEMORY_OFFSET+0x0000030,0x00003FFF

#define IC_INTERNAL_MEM_FW 0x400
#define TASK1_TMP_COEF IC_INTERNAL_MEM_FW
#define TASK1_CSC1_W0    TASK1_TMP_COEF+1
#define TASK1_CSC1_W1    TASK1_CSC1_W0+1
#define TASK1_CSC1_W2    TASK1_CSC1_W1+1

#define IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W0 << 3)
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__EMPTY  IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__FULL   IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__A0_LOW IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0xF8000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__C00    IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0x07FC0000
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__C11    IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0x0003FE00
#define IPU_IC_TPMEM_ENC_CSC1_WORD0__C22    IPU_IC_TPMEM_ENC_CSC1_WORD0__ADDR,0x000001FF

#define IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR     IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W0 << 3) + 4
#define IPU_IC_TPMEM_ENC_CSC1_WORD1__EMPTY    IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD1__FULL     IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD1__SAT_MODE IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR,0x00000400
#define IPU_IC_TPMEM_ENC_CSC1_WORD1__SCALE    IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR,0x00000300
#define IPU_IC_TPMEM_ENC_CSC1_WORD1__A0_HIGH  IPU_IC_TPMEM_ENC_CSC1_WORD1__ADDR,0x000000FF

#define IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W1 << 3)
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__EMPTY  IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__FULL   IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__A1_LOW IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0xF8000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__C01    IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0x07FC0000
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__C10    IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0x0003FE00
#define IPU_IC_TPMEM_ENC_CSC1_WORD2__C20    IPU_IC_TPMEM_ENC_CSC1_WORD2__ADDR,0x000001FF

#define IPU_IC_TPMEM_ENC_CSC1_WORD3__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W1 << 3) + 4
#define IPU_IC_TPMEM_ENC_CSC1_WORD3__EMPTY   IPU_IC_TPMEM_ENC_CSC1_WORD3__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD3__FULL    IPU_IC_TPMEM_ENC_CSC1_WORD3__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD3__A1_HIGH IPU_IC_TPMEM_ENC_CSC1_WORD3__ADDR,0x000000FF

#define IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W2 << 3)
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__EMPTY  IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__FULL   IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__A2_LOW IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0xF8000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__C02    IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0x07FC0000
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__C12    IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0x0003FE00
#define IPU_IC_TPMEM_ENC_CSC1_WORD4__C21    IPU_IC_TPMEM_ENC_CSC1_WORD4__ADDR,0x000001FF

#define IPU_IC_TPMEM_ENC_CSC1_WORD5__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK1_CSC1_W2 << 3) + 4
#define IPU_IC_TPMEM_ENC_CSC1_WORD5__EMPTY   IPU_IC_TPMEM_ENC_CSC1_WORD5__ADDR,0x00000000
#define IPU_IC_TPMEM_ENC_CSC1_WORD5__FULL    IPU_IC_TPMEM_ENC_CSC1_WORD5__ADDR,0xffffffff
#define IPU_IC_TPMEM_ENC_CSC1_WORD5__A2_HIGH IPU_IC_TPMEM_ENC_CSC1_WORD5__ADDR,0x000000FF

#define TASK2_TMP_COEF TASK1_CSC1_W2+IC_INTERNAL_MEM_FW+1
#define TASK2_CSC1_W0    TASK2_TMP_COEF+1
#define TASK2_CSC1_W1    TASK2_CSC1_W0+1
#define TASK2_CSC1_W2    TASK2_CSC1_W1+1
#define TASK2_CSC2_W0    TASK2_CSC1_W2+1
#define TASK2_CSC2_W1    TASK2_CSC2_W0+1
#define TASK2_CSC2_W2    TASK2_CSC2_W1+1

#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W0 << 3)
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__EMPTY  IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__FULL   IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__A0_LOW IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__C00    IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__C11    IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC1_WORD0__C22    IPU_IC_TPMEM_VIEW_CSC1_WORD0__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR     IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W0 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__EMPTY    IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__FULL     IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__SAT_MODE IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR,0x00000400
#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__SCALE    IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR,0x00000300
#define IPU_IC_TPMEM_VIEW_CSC1_WORD1__A0_HIGH  IPU_IC_TPMEM_VIEW_CSC1_WORD1__ADDR,0x000000FF

#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W1 << 3)
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__EMPTY  IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__FULL   IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__A1_LOW IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__C01    IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__C10    IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC1_WORD2__C20    IPU_IC_TPMEM_VIEW_CSC1_WORD2__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC1_WORD3__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W1 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC1_WORD3__EMPTY   IPU_IC_TPMEM_VIEW_CSC1_WORD3__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD3__FULL    IPU_IC_TPMEM_VIEW_CSC1_WORD3__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD3__A1_HIGH IPU_IC_TPMEM_VIEW_CSC1_WORD3__ADDR,0x000000FF

#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W2 << 3)
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__EMPTY  IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__FULL   IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__A2_LOW IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__C02    IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__C12    IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC1_WORD4__C21    IPU_IC_TPMEM_VIEW_CSC1_WORD4__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC1_WORD5__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC1_W2 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC1_WORD5__EMPTY   IPU_IC_TPMEM_VIEW_CSC1_WORD5__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC1_WORD5__FULL    IPU_IC_TPMEM_VIEW_CSC1_WORD5__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC1_WORD5__A2_HIGH IPU_IC_TPMEM_VIEW_CSC1_WORD5__ADDR,0x000000FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W0 << 3)
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__EMPTY  IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__FULL   IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__A0_LOW IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__C00    IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__C11    IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC2_WORD0__C22    IPU_IC_TPMEM_VIEW_CSC2_WORD0__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR     IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W0 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__EMPTY    IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__FULL     IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__SAT_MODE IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR,0x00000400
#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__SCALE    IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR,0x00000300
#define IPU_IC_TPMEM_VIEW_CSC2_WORD1__A0_HIGH  IPU_IC_TPMEM_VIEW_CSC2_WORD1__ADDR,0x000000FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W1 << 3)
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__EMPTY  IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__FULL   IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__A1_LOW IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__C01    IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__C10    IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC2_WORD2__C20    IPU_IC_TPMEM_VIEW_CSC2_WORD2__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD3__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W1 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC2_WORD3__EMPTY   IPU_IC_TPMEM_VIEW_CSC2_WORD3__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD3__FULL    IPU_IC_TPMEM_VIEW_CSC2_WORD3__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD3__A1_HIGH IPU_IC_TPMEM_VIEW_CSC2_WORD3__ADDR,0x000000FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W2 << 3)
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__EMPTY  IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__FULL   IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__A2_LOW IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0xF8000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__C02    IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0x07FC0000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__C12    IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0x0003FE00
#define IPU_IC_TPMEM_VIEW_CSC2_WORD4__C21    IPU_IC_TPMEM_VIEW_CSC2_WORD4__ADDR,0x000001FF

#define IPU_IC_TPMEM_VIEW_CSC2_WORD5__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK2_CSC2_W2 << 3) + 4
#define IPU_IC_TPMEM_VIEW_CSC2_WORD5__EMPTY   IPU_IC_TPMEM_VIEW_CSC2_WORD5__ADDR,0x00000000
#define IPU_IC_TPMEM_VIEW_CSC2_WORD5__FULL    IPU_IC_TPMEM_VIEW_CSC2_WORD5__ADDR,0xffffffff
#define IPU_IC_TPMEM_VIEW_CSC2_WORD5__A2_HIGH IPU_IC_TPMEM_VIEW_CSC2_WORD5__ADDR,0x000000FF

#define TASK3_TMP_COEF TASK2_CSC2_W2+IC_INTERNAL_MEM_FW+1
#define TASK3_CSC1_W0    TASK3_TMP_COEF+1
#define TASK3_CSC1_W1    TASK3_CSC1_W0+1
#define TASK3_CSC1_W2    TASK3_CSC1_W1+1
#define TASK3_CSC2_W0    TASK3_CSC1_W2+1
#define TASK3_CSC2_W1    TASK3_CSC2_W0+1
#define TASK3_CSC2_W2    TASK3_CSC2_W1+1

#define IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W0 << 3)
#define IPU_IC_TPMEM_POST_CSC1_WORD0__EMPTY  IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD0__FULL   IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD0__A0_LOW IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC1_WORD0__C00    IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC1_WORD0__C11    IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC1_WORD0__C22    IPU_IC_TPMEM_POST_CSC1_WORD0__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR     IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W0 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC1_WORD1__EMPTY    IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD1__FULL     IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD1__SAT_MODE IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR,0x00000400
#define IPU_IC_TPMEM_POST_CSC1_WORD1__SCALE    IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR,0x00000300
#define IPU_IC_TPMEM_POST_CSC1_WORD1__A0_HIGH  IPU_IC_TPMEM_POST_CSC1_WORD1__ADDR,0x000000FF

#define IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W1 << 3)
#define IPU_IC_TPMEM_POST_CSC1_WORD2__EMPTY  IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD2__FULL   IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD2__A1_LOW IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC1_WORD2__C01    IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC1_WORD2__C10    IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC1_WORD2__C20    IPU_IC_TPMEM_POST_CSC1_WORD2__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC1_WORD3__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W1 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC1_WORD3__EMPTY   IPU_IC_TPMEM_POST_CSC1_WORD3__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD3__FULL    IPU_IC_TPMEM_POST_CSC1_WORD3__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD3__A1_HIGH IPU_IC_TPMEM_POST_CSC1_WORD3__ADDR,0x000000FF

#define IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W2 << 3)
#define IPU_IC_TPMEM_POST_CSC1_WORD4__EMPTY  IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD4__FULL   IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD4__A2_LOW IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC1_WORD4__C02    IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC1_WORD4__C12    IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC1_WORD4__C21    IPU_IC_TPMEM_POST_CSC1_WORD4__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC1_WORD5__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC1_W2 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC1_WORD5__EMPTY   IPU_IC_TPMEM_POST_CSC1_WORD5__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC1_WORD5__FULL    IPU_IC_TPMEM_POST_CSC1_WORD5__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC1_WORD5__A2_HIGH IPU_IC_TPMEM_POST_CSC1_WORD5__ADDR,0x000000FF

#define IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W0 << 3)
#define IPU_IC_TPMEM_POST_CSC2_WORD0__EMPTY  IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD0__FULL   IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD0__A0_LOW IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC2_WORD0__C00    IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC2_WORD0__C11    IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC2_WORD0__C22    IPU_IC_TPMEM_POST_CSC2_WORD0__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR     IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W0 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC2_WORD1__EMPTY    IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD1__FULL     IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD1__SAT_MODE IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR,0x00000400
#define IPU_IC_TPMEM_POST_CSC2_WORD1__SCALE    IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR,0x00000300
#define IPU_IC_TPMEM_POST_CSC2_WORD1__A0_HIGH  IPU_IC_TPMEM_POST_CSC2_WORD1__ADDR,0x000000FF

#define IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W1 << 3)
#define IPU_IC_TPMEM_POST_CSC2_WORD2__EMPTY  IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD2__FULL   IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD2__A1_LOW IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC2_WORD2__C01    IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC2_WORD2__C10    IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC2_WORD2__C20    IPU_IC_TPMEM_POST_CSC2_WORD2__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC2_WORD3__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W1 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC2_WORD3__EMPTY   IPU_IC_TPMEM_POST_CSC2_WORD3__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD3__FULL    IPU_IC_TPMEM_POST_CSC2_WORD3__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD3__A1_HIGH IPU_IC_TPMEM_POST_CSC2_WORD3__ADDR,0x000000FF

#define IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR   IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W2 << 3)
#define IPU_IC_TPMEM_POST_CSC2_WORD4__EMPTY  IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD4__FULL   IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD4__A2_LOW IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0xF8000000
#define IPU_IC_TPMEM_POST_CSC2_WORD4__C02    IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0x07FC0000
#define IPU_IC_TPMEM_POST_CSC2_WORD4__C12    IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0x0003FE00
#define IPU_IC_TPMEM_POST_CSC2_WORD4__C21    IPU_IC_TPMEM_POST_CSC2_WORD4__ADDR,0x000001FF

#define IPU_IC_TPMEM_POST_CSC2_WORD5__ADDR    IPU_MEMORY_OFFSET+0x0060000 + (TASK3_CSC2_W2 << 3) + 4
#define IPU_IC_TPMEM_POST_CSC2_WORD5__EMPTY   IPU_IC_TPMEM_POST_CSC2_WORD5__ADDR,0x00000000
#define IPU_IC_TPMEM_POST_CSC2_WORD5__FULL    IPU_IC_TPMEM_POST_CSC2_WORD5__ADDR,0xffffffff
#define IPU_IC_TPMEM_POST_CSC2_WORD5__A2_HIGH IPU_IC_TPMEM_POST_CSC2_WORD5__ADDR,0x000000FF

#define SRM_DP_COM_CONF_SYNC__ADDR                              IPU_MEMORY_OFFSET+0x0040000
#define SRM_DP_COM_CONF_SYNC__EMPTY                             IPU_MEMORY_OFFSET+0x0040000,0x00000000
#define SRM_DP_COM_CONF_SYNC__FULL                              IPU_MEMORY_OFFSET+0x0040000,0xffffffff
#define SRM_DP_COM_CONF_SYNC__DP_GAMMA_YUV_EN_SYNC              IPU_MEMORY_OFFSET+0x0040000,0x00002000
#define SRM_DP_COM_CONF_SYNC__DP_GAMMA_EN_SYNC                  IPU_MEMORY_OFFSET+0x0040000,0x00001000
#define SRM_DP_COM_CONF_SYNC__DP_CSC_YUV_SAT_MODE_SYNC          IPU_MEMORY_OFFSET+0x0040000,0x00000800
#define SRM_DP_COM_CONF_SYNC__DP_CSC_GAMUT_SAT_EN_SYNC          IPU_MEMORY_OFFSET+0x0040000,0x00000400
#define SRM_DP_COM_CONF_SYNC__DP_CSC_DEF_SYNC                   IPU_MEMORY_OFFSET+0x0040000,0x00000300
#define SRM_DP_COM_CONF_SYNC__DP_COC_SYNC                       IPU_MEMORY_OFFSET+0x0040000,0x00000070
#define SRM_DP_COM_CONF_SYNC__DP_GWCKE_SYNC                     IPU_MEMORY_OFFSET+0x0040000,0x00000008
#define SRM_DP_COM_CONF_SYNC__DP_GWAM_SYNC                      IPU_MEMORY_OFFSET+0x0040000,0x00000004
#define SRM_DP_COM_CONF_SYNC__DP_GWSEL_SYNC                     IPU_MEMORY_OFFSET+0x0040000,0x00000002
#define SRM_DP_COM_CONF_SYNC__DP_FG_EN_SYNC                     IPU_MEMORY_OFFSET+0x0040000,0x00000001

#define SRM_DP_GRAPH_WIND_CTRL_SYNC__ADDR                       IPU_MEMORY_OFFSET+0x0040004
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__EMPTY                      IPU_MEMORY_OFFSET+0x0040004,0x00000000
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__FULL                       IPU_MEMORY_OFFSET+0x0040004,0xffffffff
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWAV_SYNC               IPU_MEMORY_OFFSET+0x0040004,0xFF000000
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKR_SYNC              IPU_MEMORY_OFFSET+0x0040004,0x00FF0000
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKG_SYNC              IPU_MEMORY_OFFSET+0x0040004,0x0000FF00
#define SRM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKB_SYNC              IPU_MEMORY_OFFSET+0x0040004,0x000000FF

#define SRM_DP_FG_POS_SYNC__ADDR                                IPU_MEMORY_OFFSET+0x0040008
#define SRM_DP_FG_POS_SYNC__EMPTY                               IPU_MEMORY_OFFSET+0x0040008,0x00000000
#define SRM_DP_FG_POS_SYNC__FULL                                IPU_MEMORY_OFFSET+0x0040008,0xffffffff
#define SRM_DP_FG_POS_SYNC__DP_FGXP_SYNC                        IPU_MEMORY_OFFSET+0x0040008,0x07FF0000
#define SRM_DP_FG_POS_SYNC__DP_FGYP_SYNC                        IPU_MEMORY_OFFSET+0x0040008,0x000007FF

#define SRM_DP_CUR_POS_SYNC__ADDR                               IPU_MEMORY_OFFSET+0x004000C
#define SRM_DP_CUR_POS_SYNC__EMPTY                              IPU_MEMORY_OFFSET+0x004000C,0x00000000
#define SRM_DP_CUR_POS_SYNC__FULL                               IPU_MEMORY_OFFSET+0x004000C,0xffffffff
#define SRM_DP_CUR_POS_SYNC__DP_CXW_SYNC                        IPU_MEMORY_OFFSET+0x004000C,0xF8000000
#define SRM_DP_CUR_POS_SYNC__DP_CXP_SYNC                        IPU_MEMORY_OFFSET+0x004000C,0x07FF0000
#define SRM_DP_CUR_POS_SYNC__DP_CYH_SYNC                        IPU_MEMORY_OFFSET+0x004000C,0x0000F800
#define SRM_DP_CUR_POS_SYNC__DP_CYP_SYNC                        IPU_MEMORY_OFFSET+0x004000C,0x000007FF

#define SRM_DP_CUR_MAP_SYNC__ADDR                               IPU_MEMORY_OFFSET+0x0040010
#define SRM_DP_CUR_MAP_SYNC__EMPTY                              IPU_MEMORY_OFFSET+0x0040010,0x00000000
#define SRM_DP_CUR_MAP_SYNC__FULL                               IPU_MEMORY_OFFSET+0x0040010,0xffffffff
#define SRM_DP_CUR_MAP_SYNC__DP_CUR_COL_R_SYNC                  IPU_MEMORY_OFFSET+0x0040010,0x00FF0000
#define SRM_DP_CUR_MAP_SYNC__DP_CUR_COL_G_SYNC                  IPU_MEMORY_OFFSET+0x0040010,0x0000FF00
#define SRM_DP_CUR_MAP_SYNC__DP_CUR_COL_B_SYNC                  IPU_MEMORY_OFFSET+0x0040010,0x000000FF

#define SRM_DP_GAMMA_C_SYNC_0__ADDR                             IPU_MEMORY_OFFSET+0x0040014
#define SRM_DP_GAMMA_C_SYNC_0__EMPTY                            IPU_MEMORY_OFFSET+0x0040014,0x00000000
#define SRM_DP_GAMMA_C_SYNC_0__FULL                             IPU_MEMORY_OFFSET+0x0040014,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_1                IPU_MEMORY_OFFSET+0x0040014,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_0                IPU_MEMORY_OFFSET+0x0040014,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_1__ADDR                             IPU_MEMORY_OFFSET+0x0040018
#define SRM_DP_GAMMA_C_SYNC_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040018,0x00000000
#define SRM_DP_GAMMA_C_SYNC_1__FULL                             IPU_MEMORY_OFFSET+0x0040018,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_3                IPU_MEMORY_OFFSET+0x0040018,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_2                IPU_MEMORY_OFFSET+0x0040018,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_2__ADDR                             IPU_MEMORY_OFFSET+0x004001C
#define SRM_DP_GAMMA_C_SYNC_2__EMPTY                            IPU_MEMORY_OFFSET+0x004001C,0x00000000
#define SRM_DP_GAMMA_C_SYNC_2__FULL                             IPU_MEMORY_OFFSET+0x004001C,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_5                IPU_MEMORY_OFFSET+0x004001C,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_4                IPU_MEMORY_OFFSET+0x004001C,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_3__ADDR                             IPU_MEMORY_OFFSET+0x0040020
#define SRM_DP_GAMMA_C_SYNC_3__EMPTY                            IPU_MEMORY_OFFSET+0x0040020,0x00000000
#define SRM_DP_GAMMA_C_SYNC_3__FULL                             IPU_MEMORY_OFFSET+0x0040020,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_7                IPU_MEMORY_OFFSET+0x0040020,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_6                IPU_MEMORY_OFFSET+0x0040020,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_4__ADDR                             IPU_MEMORY_OFFSET+0x0040024
#define SRM_DP_GAMMA_C_SYNC_4__EMPTY                            IPU_MEMORY_OFFSET+0x0040024,0x00000000
#define SRM_DP_GAMMA_C_SYNC_4__FULL                             IPU_MEMORY_OFFSET+0x0040024,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_9                IPU_MEMORY_OFFSET+0x0040024,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_8                IPU_MEMORY_OFFSET+0x0040024,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_5__ADDR                             IPU_MEMORY_OFFSET+0x0040028
#define SRM_DP_GAMMA_C_SYNC_5__EMPTY                            IPU_MEMORY_OFFSET+0x0040028,0x00000000
#define SRM_DP_GAMMA_C_SYNC_5__FULL                             IPU_MEMORY_OFFSET+0x0040028,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_11               IPU_MEMORY_OFFSET+0x0040028,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_10               IPU_MEMORY_OFFSET+0x0040028,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_6__ADDR                             IPU_MEMORY_OFFSET+0x004002C
#define SRM_DP_GAMMA_C_SYNC_6__EMPTY                            IPU_MEMORY_OFFSET+0x004002C,0x00000000
#define SRM_DP_GAMMA_C_SYNC_6__FULL                             IPU_MEMORY_OFFSET+0x004002C,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_13               IPU_MEMORY_OFFSET+0x004002C,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_12               IPU_MEMORY_OFFSET+0x004002C,0x000001FF

#define SRM_DP_GAMMA_C_SYNC_7__ADDR                             IPU_MEMORY_OFFSET+0x0040030
#define SRM_DP_GAMMA_C_SYNC_7__EMPTY                            IPU_MEMORY_OFFSET+0x0040030,0x00000000
#define SRM_DP_GAMMA_C_SYNC_7__FULL                             IPU_MEMORY_OFFSET+0x0040030,0xffffffff
#define SRM_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_15               IPU_MEMORY_OFFSET+0x0040030,0x01FF0000
#define SRM_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_14               IPU_MEMORY_OFFSET+0x0040030,0x000001FF

#define SRM_DP_GAMMA_S_SYNC_0__ADDR                             IPU_MEMORY_OFFSET+0x0040034
#define SRM_DP_GAMMA_S_SYNC_0__EMPTY                            IPU_MEMORY_OFFSET+0x0040034,0x00000000
#define SRM_DP_GAMMA_S_SYNC_0__FULL                             IPU_MEMORY_OFFSET+0x0040034,0xffffffff
#define SRM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_3                IPU_MEMORY_OFFSET+0x0040034,0xFF000000
#define SRM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_2                IPU_MEMORY_OFFSET+0x0040034,0x00FF0000
#define SRM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_1                IPU_MEMORY_OFFSET+0x0040034,0x0000FF00
#define SRM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_0                IPU_MEMORY_OFFSET+0x0040034,0x000000FF

#define SRM_DP_GAMMA_S_SYNC_1__ADDR                             IPU_MEMORY_OFFSET+0x0040038
#define SRM_DP_GAMMA_S_SYNC_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040038,0x00000000
#define SRM_DP_GAMMA_S_SYNC_1__FULL                             IPU_MEMORY_OFFSET+0x0040038,0xffffffff
#define SRM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_7                IPU_MEMORY_OFFSET+0x0040038,0xFF000000
#define SRM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_6                IPU_MEMORY_OFFSET+0x0040038,0x00FF0000
#define SRM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_5                IPU_MEMORY_OFFSET+0x0040038,0x0000FF00
#define SRM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_4                IPU_MEMORY_OFFSET+0x0040038,0x000000FF

#define SRM_DP_GAMMA_S_SYNC_2__ADDR                             IPU_MEMORY_OFFSET+0x004003C
#define SRM_DP_GAMMA_S_SYNC_2__EMPTY                            IPU_MEMORY_OFFSET+0x004003C,0x00000000
#define SRM_DP_GAMMA_S_SYNC_2__FULL                             IPU_MEMORY_OFFSET+0x004003C,0xffffffff
#define SRM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_11               IPU_MEMORY_OFFSET+0x004003C,0xFF000000
#define SRM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_10               IPU_MEMORY_OFFSET+0x004003C,0x00FF0000
#define SRM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_9                IPU_MEMORY_OFFSET+0x004003C,0x0000FF00
#define SRM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_8                IPU_MEMORY_OFFSET+0x004003C,0x000000FF

#define SRM_DP_GAMMA_S_SYNC_3__ADDR                             IPU_MEMORY_OFFSET+0x0040040
#define SRM_DP_GAMMA_S_SYNC_3__EMPTY                            IPU_MEMORY_OFFSET+0x0040040,0x00000000
#define SRM_DP_GAMMA_S_SYNC_3__FULL                             IPU_MEMORY_OFFSET+0x0040040,0xffffffff
#define SRM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_15               IPU_MEMORY_OFFSET+0x0040040,0xFF000000
#define SRM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_14               IPU_MEMORY_OFFSET+0x0040040,0x00FF0000
#define SRM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_13               IPU_MEMORY_OFFSET+0x0040040,0x0000FF00
#define SRM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_12               IPU_MEMORY_OFFSET+0x0040040,0x000000FF

#define SRM_DP_CSCA_SYNC_0__ADDR                                IPU_MEMORY_OFFSET+0x0040044
#define SRM_DP_CSCA_SYNC_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040044,0x00000000
#define SRM_DP_CSCA_SYNC_0__FULL                                IPU_MEMORY_OFFSET+0x0040044,0xffffffff
#define SRM_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_1                     IPU_MEMORY_OFFSET+0x0040044,0x03FF0000
#define SRM_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_0                     IPU_MEMORY_OFFSET+0x0040044,0x000003FF

#define SRM_DP_CSCA_SYNC_1__ADDR                                IPU_MEMORY_OFFSET+0x0040048
#define SRM_DP_CSCA_SYNC_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040048,0x00000000
#define SRM_DP_CSCA_SYNC_1__FULL                                IPU_MEMORY_OFFSET+0x0040048,0xffffffff
#define SRM_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_3                     IPU_MEMORY_OFFSET+0x0040048,0x03FF0000
#define SRM_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_2                     IPU_MEMORY_OFFSET+0x0040048,0x000003FF

#define SRM_DP_CSCA_SYNC_2__ADDR                                IPU_MEMORY_OFFSET+0x004004C
#define SRM_DP_CSCA_SYNC_2__EMPTY                               IPU_MEMORY_OFFSET+0x004004C,0x00000000
#define SRM_DP_CSCA_SYNC_2__FULL                                IPU_MEMORY_OFFSET+0x004004C,0xffffffff
#define SRM_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_5                     IPU_MEMORY_OFFSET+0x004004C,0x03FF0000
#define SRM_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_4                     IPU_MEMORY_OFFSET+0x004004C,0x000003FF

#define SRM_DP_CSCA_SYNC_3__ADDR                                IPU_MEMORY_OFFSET+0x0040050
#define SRM_DP_CSCA_SYNC_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040050,0x00000000
#define SRM_DP_CSCA_SYNC_3__FULL                                IPU_MEMORY_OFFSET+0x0040050,0xffffffff
#define SRM_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_7                     IPU_MEMORY_OFFSET+0x0040050,0x03FF0000
#define SRM_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_6                     IPU_MEMORY_OFFSET+0x0040050,0x000003FF

#define SRM_DP_CSC_SYNC_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040054
#define SRM_DP_CSC_SYNC_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040054,0x00000000
#define SRM_DP_CSC_SYNC_0__FULL                                 IPU_MEMORY_OFFSET+0x0040054,0xffffffff
#define SRM_DP_CSC_SYNC_0__DP_CSC_S0_SYNC                       IPU_MEMORY_OFFSET+0x0040054,0xC0000000
#define SRM_DP_CSC_SYNC_0__DP_CSC_B0_SYNC                       IPU_MEMORY_OFFSET+0x0040054,0x3FFF0000
#define SRM_DP_CSC_SYNC_0__DP_CSC_A8_SYNC                       IPU_MEMORY_OFFSET+0x0040054,0x000003FF

#define SRM_DP_CSC_SYNC_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040058
#define SRM_DP_CSC_SYNC_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040058,0x00000000
#define SRM_DP_CSC_SYNC_1__FULL                                 IPU_MEMORY_OFFSET+0x0040058,0xffffffff
#define SRM_DP_CSC_SYNC_1__DP_CSC_S2_SYNC                       IPU_MEMORY_OFFSET+0x0040058,0xC0000000
#define SRM_DP_CSC_SYNC_1__DP_CSC_B2_SYNC                       IPU_MEMORY_OFFSET+0x0040058,0x3FFF0000
#define SRM_DP_CSC_SYNC_1__DP_CSC_S1_SYNC                       IPU_MEMORY_OFFSET+0x0040058,0x0000C000
#define SRM_DP_CSC_SYNC_1__DP_CSC_B1_SYNC                       IPU_MEMORY_OFFSET+0x0040058,0x00003FFF

#define SRM_DP_CUR_POS_ALT__ADDR                                IPU_MEMORY_OFFSET+0x004005C
#define SRM_DP_CUR_POS_ALT__EMPTY                               IPU_MEMORY_OFFSET+0x004005C,0x00000000
#define SRM_DP_CUR_POS_ALT__FULL                                IPU_MEMORY_OFFSET+0x004005C,0xffffffff
#define SRM_DP_CUR_POS_ALT__DP_CXW_SYNC_ALT                     IPU_MEMORY_OFFSET+0x004005C,0xF8000000
#define SRM_DP_CUR_POS_ALT__DP_CXP_SYNC_ALT                     IPU_MEMORY_OFFSET+0x004005C,0x07FF0000
#define SRM_DP_CUR_POS_ALT__DP_CYH_SYNC_ALT                     IPU_MEMORY_OFFSET+0x004005C,0x0000F800
#define SRM_DP_CUR_POS_ALT__DP_CYP_SYNC_ALT                     IPU_MEMORY_OFFSET+0x004005C,0x000007FF

#define SRM_DP_COM_CONF_ASYNC0__ADDR                            IPU_MEMORY_OFFSET+0x0040060
#define SRM_DP_COM_CONF_ASYNC0__EMPTY                           IPU_MEMORY_OFFSET+0x0040060,0x00000000
#define SRM_DP_COM_CONF_ASYNC0__FULL                            IPU_MEMORY_OFFSET+0x0040060,0xffffffff
#define SRM_DP_COM_CONF_ASYNC0__DP_GAMMA_YUV_EN_ASYNC0          IPU_MEMORY_OFFSET+0x0040060,0x00002000
#define SRM_DP_COM_CONF_ASYNC0__DP_GAMMA_EN_ASYNC0              IPU_MEMORY_OFFSET+0x0040060,0x00001000
#define SRM_DP_COM_CONF_ASYNC0__DP_CSC_YUV_SAT_MODE_ASYNC0      IPU_MEMORY_OFFSET+0x0040060,0x00000800
#define SRM_DP_COM_CONF_ASYNC0__DP_CSC_GAMUT_SAT_EN_ASYNC0      IPU_MEMORY_OFFSET+0x0040060,0x00000400
#define SRM_DP_COM_CONF_ASYNC0__DP_CSC_DEF_ASYNC0               IPU_MEMORY_OFFSET+0x0040060,0x00000300
#define SRM_DP_COM_CONF_ASYNC0__DP_COC_ASYNC0                   IPU_MEMORY_OFFSET+0x0040060,0x00000070
#define SRM_DP_COM_CONF_ASYNC0__DP_GWCKE_ASYNC0                 IPU_MEMORY_OFFSET+0x0040060,0x00000008
#define SRM_DP_COM_CONF_ASYNC0__DP_GWAM_ASYNC0                  IPU_MEMORY_OFFSET+0x0040060,0x00000004
#define SRM_DP_COM_CONF_ASYNC0__DP_GWSEL_ASYNC0                 IPU_MEMORY_OFFSET+0x0040060,0x00000002

#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__ADDR                     IPU_MEMORY_OFFSET+0x0040064
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__EMPTY                    IPU_MEMORY_OFFSET+0x0040064,0x00000000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__FULL                     IPU_MEMORY_OFFSET+0x0040064,0xffffffff
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWAV_ASYNC0           IPU_MEMORY_OFFSET+0x0040064,0xFF000000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKR_ASYNC0          IPU_MEMORY_OFFSET+0x0040064,0x00FF0000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKG_ASYNC0          IPU_MEMORY_OFFSET+0x0040064,0x0000FF00
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKB_ASYNC0          IPU_MEMORY_OFFSET+0x0040064,0x000000FF

#define SRM_DP_FG_POS_ASYNC0__ADDR                              IPU_MEMORY_OFFSET+0x0040068
#define SRM_DP_FG_POS_ASYNC0__EMPTY                             IPU_MEMORY_OFFSET+0x0040068,0x00000000
#define SRM_DP_FG_POS_ASYNC0__FULL                              IPU_MEMORY_OFFSET+0x0040068,0xffffffff
#define SRM_DP_FG_POS_ASYNC0__DP_FGXP_ASYNC0                    IPU_MEMORY_OFFSET+0x0040068,0x07FF0000
#define SRM_DP_FG_POS_ASYNC0__DP_FGYP_ASYNC0                    IPU_MEMORY_OFFSET+0x0040068,0x000007FF

#define SRM_DP_CUR_POS_ASYNC0__ADDR                             IPU_MEMORY_OFFSET+0x004006C
#define SRM_DP_CUR_POS_ASYNC0__EMPTY                            IPU_MEMORY_OFFSET+0x004006C,0x00000000
#define SRM_DP_CUR_POS_ASYNC0__FULL                             IPU_MEMORY_OFFSET+0x004006C,0xffffffff
#define SRM_DP_CUR_POS_ASYNC0__DP_CXW_ASYNC0                    IPU_MEMORY_OFFSET+0x004006C,0xF8000000
#define SRM_DP_CUR_POS_ASYNC0__DP_CXP_ASYNC0                    IPU_MEMORY_OFFSET+0x004006C,0x07FF0000
#define SRM_DP_CUR_POS_ASYNC0__DP_CYH_ASYNC0                    IPU_MEMORY_OFFSET+0x004006C,0x0000F800
#define SRM_DP_CUR_POS_ASYNC0__DP_CYP_ASYNC0                    IPU_MEMORY_OFFSET+0x004006C,0x000007FF

#define SRM_DP_CUR_MAP_ASYNC0__ADDR                             IPU_MEMORY_OFFSET+0x0040070
#define SRM_DP_CUR_MAP_ASYNC0__EMPTY                            IPU_MEMORY_OFFSET+0x0040070,0x00000000
#define SRM_DP_CUR_MAP_ASYNC0__FULL                             IPU_MEMORY_OFFSET+0x0040070,0xffffffff
#define SRM_DP_CUR_MAP_ASYNC0__CUR_COL_R_ASYNC0                 IPU_MEMORY_OFFSET+0x0040070,0x00FF0000
#define SRM_DP_CUR_MAP_ASYNC0__CUR_COL_G_ASYNC0                 IPU_MEMORY_OFFSET+0x0040070,0x0000FF00
#define SRM_DP_CUR_MAP_ASYNC0__CUR_COL_B_ASYNC0                 IPU_MEMORY_OFFSET+0x0040070,0x000000FF

#define SRM_DP_GAMMA_C_ASYNC0_0__ADDR                           IPU_MEMORY_OFFSET+0x0040074
#define SRM_DP_GAMMA_C_ASYNC0_0__EMPTY                          IPU_MEMORY_OFFSET+0x0040074,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_0__FULL                           IPU_MEMORY_OFFSET+0x0040074,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_1            IPU_MEMORY_OFFSET+0x0040074,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_0            IPU_MEMORY_OFFSET+0x0040074,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_1__ADDR                           IPU_MEMORY_OFFSET+0x0040078
#define SRM_DP_GAMMA_C_ASYNC0_1__EMPTY                          IPU_MEMORY_OFFSET+0x0040078,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_1__FULL                           IPU_MEMORY_OFFSET+0x0040078,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_3            IPU_MEMORY_OFFSET+0x0040078,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_2            IPU_MEMORY_OFFSET+0x0040078,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_2__ADDR                           IPU_MEMORY_OFFSET+0x004007C
#define SRM_DP_GAMMA_C_ASYNC0_2__EMPTY                          IPU_MEMORY_OFFSET+0x004007C,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_2__FULL                           IPU_MEMORY_OFFSET+0x004007C,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_5            IPU_MEMORY_OFFSET+0x004007C,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_4            IPU_MEMORY_OFFSET+0x004007C,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_3__ADDR                           IPU_MEMORY_OFFSET+0x0040080
#define SRM_DP_GAMMA_C_ASYNC0_3__EMPTY                          IPU_MEMORY_OFFSET+0x0040080,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_3__FULL                           IPU_MEMORY_OFFSET+0x0040080,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_7            IPU_MEMORY_OFFSET+0x0040080,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_6            IPU_MEMORY_OFFSET+0x0040080,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_4__ADDR                           IPU_MEMORY_OFFSET+0x0040084
#define SRM_DP_GAMMA_C_ASYNC0_4__EMPTY                          IPU_MEMORY_OFFSET+0x0040084,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_4__FULL                           IPU_MEMORY_OFFSET+0x0040084,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_9            IPU_MEMORY_OFFSET+0x0040084,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_8            IPU_MEMORY_OFFSET+0x0040084,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_5__ADDR                           IPU_MEMORY_OFFSET+0x0040088
#define SRM_DP_GAMMA_C_ASYNC0_5__EMPTY                          IPU_MEMORY_OFFSET+0x0040088,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_5__FULL                           IPU_MEMORY_OFFSET+0x0040088,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_11           IPU_MEMORY_OFFSET+0x0040088,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_10           IPU_MEMORY_OFFSET+0x0040088,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_6__ADDR                           IPU_MEMORY_OFFSET+0x004008C
#define SRM_DP_GAMMA_C_ASYNC0_6__EMPTY                          IPU_MEMORY_OFFSET+0x004008C,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_6__FULL                           IPU_MEMORY_OFFSET+0x004008C,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_13           IPU_MEMORY_OFFSET+0x004008C,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_12           IPU_MEMORY_OFFSET+0x004008C,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC0_7__ADDR                           IPU_MEMORY_OFFSET+0x0040090
#define SRM_DP_GAMMA_C_ASYNC0_7__EMPTY                          IPU_MEMORY_OFFSET+0x0040090,0x00000000
#define SRM_DP_GAMMA_C_ASYNC0_7__FULL                           IPU_MEMORY_OFFSET+0x0040090,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_15           IPU_MEMORY_OFFSET+0x0040090,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_14           IPU_MEMORY_OFFSET+0x0040090,0x000001FF

#define SRM_DP_GAMMA_S_ASYNC0_0__ADDR                           IPU_MEMORY_OFFSET+0x0040094
#define SRM_DP_GAMMA_S_ASYNC0_0__EMPTY                          IPU_MEMORY_OFFSET+0x0040094,0x00000000
#define SRM_DP_GAMMA_S_ASYNC0_0__FULL                           IPU_MEMORY_OFFSET+0x0040094,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_3            IPU_MEMORY_OFFSET+0x0040094,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_2            IPU_MEMORY_OFFSET+0x0040094,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_1            IPU_MEMORY_OFFSET+0x0040094,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_0            IPU_MEMORY_OFFSET+0x0040094,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC0_1__ADDR                           IPU_MEMORY_OFFSET+0x0040098
#define SRM_DP_GAMMA_S_ASYNC0_1__EMPTY                          IPU_MEMORY_OFFSET+0x0040098,0x00000000
#define SRM_DP_GAMMA_S_ASYNC0_1__FULL                           IPU_MEMORY_OFFSET+0x0040098,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_7            IPU_MEMORY_OFFSET+0x0040098,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_6            IPU_MEMORY_OFFSET+0x0040098,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_5            IPU_MEMORY_OFFSET+0x0040098,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_4            IPU_MEMORY_OFFSET+0x0040098,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC0_2__ADDR                           IPU_MEMORY_OFFSET+0x004009C
#define SRM_DP_GAMMA_S_ASYNC0_2__EMPTY                          IPU_MEMORY_OFFSET+0x004009C,0x00000000
#define SRM_DP_GAMMA_S_ASYNC0_2__FULL                           IPU_MEMORY_OFFSET+0x004009C,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_11           IPU_MEMORY_OFFSET+0x004009C,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_10           IPU_MEMORY_OFFSET+0x004009C,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_9            IPU_MEMORY_OFFSET+0x004009C,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_8            IPU_MEMORY_OFFSET+0x004009C,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC0_3__ADDR                           IPU_MEMORY_OFFSET+0x00400A0
#define SRM_DP_GAMMA_S_ASYNC0_3__EMPTY                          IPU_MEMORY_OFFSET+0x00400A0,0x00000000
#define SRM_DP_GAMMA_S_ASYNC0_3__FULL                           IPU_MEMORY_OFFSET+0x00400A0,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_15           IPU_MEMORY_OFFSET+0x00400A0,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_14           IPU_MEMORY_OFFSET+0x00400A0,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_13           IPU_MEMORY_OFFSET+0x00400A0,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_12           IPU_MEMORY_OFFSET+0x00400A0,0x000000FF

#define SRM_DP_CSCA_ASYNC0_0__ADDR                              IPU_MEMORY_OFFSET+0x00400A4
#define SRM_DP_CSCA_ASYNC0_0__EMPTY                             IPU_MEMORY_OFFSET+0x00400A4,0x00000000
#define SRM_DP_CSCA_ASYNC0_0__FULL                              IPU_MEMORY_OFFSET+0x00400A4,0xffffffff
#define SRM_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_1                 IPU_MEMORY_OFFSET+0x00400A4,0x03FF0000
#define SRM_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_0                 IPU_MEMORY_OFFSET+0x00400A4,0x000003FF

#define SRM_DP_CSCA_ASYNC0_1__ADDR                              IPU_MEMORY_OFFSET+0x00400A8
#define SRM_DP_CSCA_ASYNC0_1__EMPTY                             IPU_MEMORY_OFFSET+0x00400A8,0x00000000
#define SRM_DP_CSCA_ASYNC0_1__FULL                              IPU_MEMORY_OFFSET+0x00400A8,0xffffffff
#define SRM_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_3                 IPU_MEMORY_OFFSET+0x00400A8,0x03FF0000
#define SRM_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_2                 IPU_MEMORY_OFFSET+0x00400A8,0x000003FF

#define SRM_DP_CSCA_ASYNC0_2__ADDR                              IPU_MEMORY_OFFSET+0x00400AC
#define SRM_DP_CSCA_ASYNC0_2__EMPTY                             IPU_MEMORY_OFFSET+0x00400AC,0x00000000
#define SRM_DP_CSCA_ASYNC0_2__FULL                              IPU_MEMORY_OFFSET+0x00400AC,0xffffffff
#define SRM_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_5                 IPU_MEMORY_OFFSET+0x00400AC,0x03FF0000
#define SRM_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_4                 IPU_MEMORY_OFFSET+0x00400AC,0x000003FF

#define SRM_DP_CSCA_ASYNC0_3__ADDR                              IPU_MEMORY_OFFSET+0x00400B0
#define SRM_DP_CSCA_ASYNC0_3__EMPTY                             IPU_MEMORY_OFFSET+0x00400B0,0x00000000
#define SRM_DP_CSCA_ASYNC0_3__FULL                              IPU_MEMORY_OFFSET+0x00400B0,0xffffffff
#define SRM_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_7                 IPU_MEMORY_OFFSET+0x00400B0,0x03FF0000
#define SRM_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_6                 IPU_MEMORY_OFFSET+0x00400B0,0x000003FF

#define SRM_DP_CSC_ASYNC0_0__ADDR                               IPU_MEMORY_OFFSET+0x00400B4
#define SRM_DP_CSC_ASYNC0_0__EMPTY                              IPU_MEMORY_OFFSET+0x00400B4,0x00000000
#define SRM_DP_CSC_ASYNC0_0__FULL                               IPU_MEMORY_OFFSET+0x00400B4,0xffffffff
#define SRM_DP_CSC_ASYNC0_0__DP_CSC_S0_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B4,0xC0000000
#define SRM_DP_CSC_ASYNC0_0__DP_CSC_B0_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B4,0x3FFF0000
#define SRM_DP_CSC_ASYNC0_0__DP_CSC_A8_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B4,0x000003FF

#define SRM_DP_CSC_ASYNC0_1__ADDR                               IPU_MEMORY_OFFSET+0x00400B8
#define SRM_DP_CSC_ASYNC0_1__EMPTY                              IPU_MEMORY_OFFSET+0x00400B8,0x00000000
#define SRM_DP_CSC_ASYNC0_1__FULL                               IPU_MEMORY_OFFSET+0x00400B8,0xffffffff
#define SRM_DP_CSC_ASYNC0_1__DP_CSC_S2_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B8,0xC0000000
#define SRM_DP_CSC_ASYNC0_1__DP_CSC_B2_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B8,0x3FFF0000
#define SRM_DP_CSC_ASYNC0_1__DP_CSC_S1_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B8,0x0000C000
#define SRM_DP_CSC_ASYNC0_1__DP_CSC_B1_ASYNC0                   IPU_MEMORY_OFFSET+0x00400B8,0x00003FFF

#define SRM_DP_COM_CONF_ASYNC1__ADDR                            IPU_MEMORY_OFFSET+0x00400BC
#define SRM_DP_COM_CONF_ASYNC1__EMPTY                           IPU_MEMORY_OFFSET+0x00400BC,0x00000000
#define SRM_DP_COM_CONF_ASYNC1__FULL                            IPU_MEMORY_OFFSET+0x00400BC,0xffffffff
#define SRM_DP_COM_CONF_ASYNC1__DP_GAMMA_YUV_EN_ASYNC1          IPU_MEMORY_OFFSET+0x00400BC,0x00002000
#define SRM_DP_COM_CONF_ASYNC1__DP_GAMMA_EN_ASYNC1              IPU_MEMORY_OFFSET+0x00400BC,0x00001000
#define SRM_DP_COM_CONF_ASYNC1__DP_CSC_YUV_SAT_MODE_ASYNC1      IPU_MEMORY_OFFSET+0x00400BC,0x00000800
#define SRM_DP_COM_CONF_ASYNC1__DP_CSC_GAMUT_SAT_EN_ASYNC1      IPU_MEMORY_OFFSET+0x00400BC,0x00000400
#define SRM_DP_COM_CONF_ASYNC1__DP_CSC_DEF_ASYNC1               IPU_MEMORY_OFFSET+0x00400BC,0x00000300
#define SRM_DP_COM_CONF_ASYNC1__DP_COC_ASYNC1                   IPU_MEMORY_OFFSET+0x00400BC,0x00000070
#define SRM_DP_COM_CONF_ASYNC1__DP_GWCKE_ASYNC1                 IPU_MEMORY_OFFSET+0x00400BC,0x00000008
#define SRM_DP_COM_CONF_ASYNC1__DP_GWAM_ASYNC1                  IPU_MEMORY_OFFSET+0x00400BC,0x00000004
#define SRM_DP_COM_CONF_ASYNC1__DP_GWSEL_ASYNC1                 IPU_MEMORY_OFFSET+0x00400BC,0x00000002

#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__ADDR                     IPU_MEMORY_OFFSET+0x00400C0
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__EMPTY                    IPU_MEMORY_OFFSET+0x00400C0,0x00000000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__FULL                     IPU_MEMORY_OFFSET+0x00400C0,0xffffffff
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWAV_ASYNC1           IPU_MEMORY_OFFSET+0x00400C0,0xFF000000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKR_ASYNC1          IPU_MEMORY_OFFSET+0x00400C0,0x00FF0000
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKG_ASYNC1          IPU_MEMORY_OFFSET+0x00400C0,0x0000FF00
#define SRM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKB_ASYNC1          IPU_MEMORY_OFFSET+0x00400C0,0x000000FF

#define SRM_DP_FG_POS_ASYNC1__ADDR                              IPU_MEMORY_OFFSET+0x00400C4
#define SRM_DP_FG_POS_ASYNC1__EMPTY                             IPU_MEMORY_OFFSET+0x00400C4,0x00000000
#define SRM_DP_FG_POS_ASYNC1__FULL                              IPU_MEMORY_OFFSET+0x00400C4,0xffffffff
#define SRM_DP_FG_POS_ASYNC1__DP_FGXP_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C4,0x07FF0000
#define SRM_DP_FG_POS_ASYNC1__DP_FGYP_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C4,0x000007FF

#define SRM_DP_CUR_POS_ASYNC1__ADDR                             IPU_MEMORY_OFFSET+0x00400C8
#define SRM_DP_CUR_POS_ASYNC1__EMPTY                            IPU_MEMORY_OFFSET+0x00400C8,0x00000000
#define SRM_DP_CUR_POS_ASYNC1__FULL                             IPU_MEMORY_OFFSET+0x00400C8,0xffffffff
#define SRM_DP_CUR_POS_ASYNC1__DP_CXW_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C8,0xF8000000
#define SRM_DP_CUR_POS_ASYNC1__DP_CXP_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C8,0x07FF0000
#define SRM_DP_CUR_POS_ASYNC1__DP_CYH_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C8,0x0000F800
#define SRM_DP_CUR_POS_ASYNC1__DP_CYP_ASYNC1                    IPU_MEMORY_OFFSET+0x00400C8,0x000007FF

#define SRM_DP_CUR_MAP_ASYNC1__ADDR                             IPU_MEMORY_OFFSET+0x00400CC
#define SRM_DP_CUR_MAP_ASYNC1__EMPTY                            IPU_MEMORY_OFFSET+0x00400CC,0x00000000
#define SRM_DP_CUR_MAP_ASYNC1__FULL                             IPU_MEMORY_OFFSET+0x00400CC,0xffffffff
#define SRM_DP_CUR_MAP_ASYNC1__CUR_COL_R_ASYNC1                 IPU_MEMORY_OFFSET+0x00400CC,0x00FF0000
#define SRM_DP_CUR_MAP_ASYNC1__CUR_COL_G_ASYNC1                 IPU_MEMORY_OFFSET+0x00400CC,0x0000FF00
#define SRM_DP_CUR_MAP_ASYNC1__CUR_COL_B_ASYNC1                 IPU_MEMORY_OFFSET+0x00400CC,0x000000FF

#define SRM_DP_GAMMA_C_ASYNC1_0__ADDR                           IPU_MEMORY_OFFSET+0x00400D0
#define SRM_DP_GAMMA_C_ASYNC1_0__EMPTY                          IPU_MEMORY_OFFSET+0x00400D0,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_0__FULL                           IPU_MEMORY_OFFSET+0x00400D0,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_1            IPU_MEMORY_OFFSET+0x00400D0,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_0            IPU_MEMORY_OFFSET+0x00400D0,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_1__ADDR                           IPU_MEMORY_OFFSET+0x00400D4
#define SRM_DP_GAMMA_C_ASYNC1_1__EMPTY                          IPU_MEMORY_OFFSET+0x00400D4,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_1__FULL                           IPU_MEMORY_OFFSET+0x00400D4,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_3            IPU_MEMORY_OFFSET+0x00400D4,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_2            IPU_MEMORY_OFFSET+0x00400D4,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_2__ADDR                           IPU_MEMORY_OFFSET+0x00400D8
#define SRM_DP_GAMMA_C_ASYNC1_2__EMPTY                          IPU_MEMORY_OFFSET+0x00400D8,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_2__FULL                           IPU_MEMORY_OFFSET+0x00400D8,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_5            IPU_MEMORY_OFFSET+0x00400D8,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_4            IPU_MEMORY_OFFSET+0x00400D8,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_3__ADDR                           IPU_MEMORY_OFFSET+0x00400DC
#define SRM_DP_GAMMA_C_ASYNC1_3__EMPTY                          IPU_MEMORY_OFFSET+0x00400DC,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_3__FULL                           IPU_MEMORY_OFFSET+0x00400DC,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_7            IPU_MEMORY_OFFSET+0x00400DC,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_6            IPU_MEMORY_OFFSET+0x00400DC,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_4__ADDR                           IPU_MEMORY_OFFSET+0x00400E0
#define SRM_DP_GAMMA_C_ASYNC1_4__EMPTY                          IPU_MEMORY_OFFSET+0x00400E0,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_4__FULL                           IPU_MEMORY_OFFSET+0x00400E0,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_9            IPU_MEMORY_OFFSET+0x00400E0,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_8            IPU_MEMORY_OFFSET+0x00400E0,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_5__ADDR                           IPU_MEMORY_OFFSET+0x00400E4
#define SRM_DP_GAMMA_C_ASYNC1_5__EMPTY                          IPU_MEMORY_OFFSET+0x00400E4,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_5__FULL                           IPU_MEMORY_OFFSET+0x00400E4,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_11           IPU_MEMORY_OFFSET+0x00400E4,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_10           IPU_MEMORY_OFFSET+0x00400E4,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_6__ADDR                           IPU_MEMORY_OFFSET+0x00400E8
#define SRM_DP_GAMMA_C_ASYNC1_6__EMPTY                          IPU_MEMORY_OFFSET+0x00400E8,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_6__FULL                           IPU_MEMORY_OFFSET+0x00400E8,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_13           IPU_MEMORY_OFFSET+0x00400E8,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_12           IPU_MEMORY_OFFSET+0x00400E8,0x000001FF

#define SRM_DP_GAMMA_C_ASYNC1_7__ADDR                           IPU_MEMORY_OFFSET+0x00400EC
#define SRM_DP_GAMMA_C_ASYNC1_7__EMPTY                          IPU_MEMORY_OFFSET+0x00400EC,0x00000000
#define SRM_DP_GAMMA_C_ASYNC1_7__FULL                           IPU_MEMORY_OFFSET+0x00400EC,0xffffffff
#define SRM_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_15           IPU_MEMORY_OFFSET+0x00400EC,0x01FF0000
#define SRM_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_14           IPU_MEMORY_OFFSET+0x00400EC,0x000001FF

#define SRM_DP_GAMMA_S_ASYNC1_0__ADDR                           IPU_MEMORY_OFFSET+0x00400F0
#define SRM_DP_GAMMA_S_ASYNC1_0__EMPTY                          IPU_MEMORY_OFFSET+0x00400F0,0x00000000
#define SRM_DP_GAMMA_S_ASYNC1_0__FULL                           IPU_MEMORY_OFFSET+0x00400F0,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_3            IPU_MEMORY_OFFSET+0x00400F0,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_2            IPU_MEMORY_OFFSET+0x00400F0,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_1            IPU_MEMORY_OFFSET+0x00400F0,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_0            IPU_MEMORY_OFFSET+0x00400F0,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC1_1__ADDR                           IPU_MEMORY_OFFSET+0x00400F4
#define SRM_DP_GAMMA_S_ASYNC1_1__EMPTY                          IPU_MEMORY_OFFSET+0x00400F4,0x00000000
#define SRM_DP_GAMMA_S_ASYNC1_1__FULL                           IPU_MEMORY_OFFSET+0x00400F4,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_7            IPU_MEMORY_OFFSET+0x00400F4,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_6            IPU_MEMORY_OFFSET+0x00400F4,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_5            IPU_MEMORY_OFFSET+0x00400F4,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_4            IPU_MEMORY_OFFSET+0x00400F4,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC1_2__ADDR                           IPU_MEMORY_OFFSET+0x00400F8
#define SRM_DP_GAMMA_S_ASYNC1_2__EMPTY                          IPU_MEMORY_OFFSET+0x00400F8,0x00000000
#define SRM_DP_GAMMA_S_ASYNC1_2__FULL                           IPU_MEMORY_OFFSET+0x00400F8,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_11           IPU_MEMORY_OFFSET+0x00400F8,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_10           IPU_MEMORY_OFFSET+0x00400F8,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_9            IPU_MEMORY_OFFSET+0x00400F8,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_8            IPU_MEMORY_OFFSET+0x00400F8,0x000000FF

#define SRM_DP_GAMMA_S_ASYNC1_3__ADDR                           IPU_MEMORY_OFFSET+0x00400FC
#define SRM_DP_GAMMA_S_ASYNC1_3__EMPTY                          IPU_MEMORY_OFFSET+0x00400FC,0x00000000
#define SRM_DP_GAMMA_S_ASYNC1_3__FULL                           IPU_MEMORY_OFFSET+0x00400FC,0xffffffff
#define SRM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_15           IPU_MEMORY_OFFSET+0x00400FC,0xFF000000
#define SRM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_14           IPU_MEMORY_OFFSET+0x00400FC,0x00FF0000
#define SRM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_13           IPU_MEMORY_OFFSET+0x00400FC,0x0000FF00
#define SRM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_12           IPU_MEMORY_OFFSET+0x00400FC,0x000000FF

#define SRM_DP_CSCA_ASYNC1_0__ADDR                              IPU_MEMORY_OFFSET+0x0040100
#define SRM_DP_CSCA_ASYNC1_0__EMPTY                             IPU_MEMORY_OFFSET+0x0040100,0x00000000
#define SRM_DP_CSCA_ASYNC1_0__FULL                              IPU_MEMORY_OFFSET+0x0040100,0xffffffff
#define SRM_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_1                 IPU_MEMORY_OFFSET+0x0040100,0x03FF0000
#define SRM_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_0                 IPU_MEMORY_OFFSET+0x0040100,0x000003FF

#define SRM_DP_CSCA_ASYNC1_1__ADDR                              IPU_MEMORY_OFFSET+0x0040104
#define SRM_DP_CSCA_ASYNC1_1__EMPTY                             IPU_MEMORY_OFFSET+0x0040104,0x00000000
#define SRM_DP_CSCA_ASYNC1_1__FULL                              IPU_MEMORY_OFFSET+0x0040104,0xffffffff
#define SRM_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_3                 IPU_MEMORY_OFFSET+0x0040104,0x03FF0000
#define SRM_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_2                 IPU_MEMORY_OFFSET+0x0040104,0x000003FF

#define SRM_DP_CSCA_ASYNC1_2__ADDR                              IPU_MEMORY_OFFSET+0x0040108
#define SRM_DP_CSCA_ASYNC1_2__EMPTY                             IPU_MEMORY_OFFSET+0x0040108,0x00000000
#define SRM_DP_CSCA_ASYNC1_2__FULL                              IPU_MEMORY_OFFSET+0x0040108,0xffffffff
#define SRM_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_5                 IPU_MEMORY_OFFSET+0x0040108,0x03FF0000
#define SRM_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_4                 IPU_MEMORY_OFFSET+0x0040108,0x000003FF

#define SRM_DP_CSCA_ASYNC1_3__ADDR                              IPU_MEMORY_OFFSET+0x004010C
#define SRM_DP_CSCA_ASYNC1_3__EMPTY                             IPU_MEMORY_OFFSET+0x004010C,0x00000000
#define SRM_DP_CSCA_ASYNC1_3__FULL                              IPU_MEMORY_OFFSET+0x004010C,0xffffffff
#define SRM_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_7                 IPU_MEMORY_OFFSET+0x004010C,0x03FF0000
#define SRM_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_6                 IPU_MEMORY_OFFSET+0x004010C,0x000003FF

#define SRM_DP_CSC_ASYNC1_0__ADDR                               IPU_MEMORY_OFFSET+0x0040110
#define SRM_DP_CSC_ASYNC1_0__EMPTY                              IPU_MEMORY_OFFSET+0x0040110,0x00000000
#define SRM_DP_CSC_ASYNC1_0__FULL                               IPU_MEMORY_OFFSET+0x0040110,0xffffffff
#define SRM_DP_CSC_ASYNC1_0__DP_CSC_S0_ASYNC1                   IPU_MEMORY_OFFSET+0x0040110,0xC0000000
#define SRM_DP_CSC_ASYNC1_0__DP_CSC_B0_ASYNC1                   IPU_MEMORY_OFFSET+0x0040110,0x3FFF0000
#define SRM_DP_CSC_ASYNC1_0__DP_CSC_A8_ASYNC1                   IPU_MEMORY_OFFSET+0x0040110,0x000003FF

#define SRM_DP_CSC_ASYNC1_1__ADDR                               IPU_MEMORY_OFFSET+0x0040114
#define SRM_DP_CSC_ASYNC1_1__EMPTY                              IPU_MEMORY_OFFSET+0x0040114,0x00000000
#define SRM_DP_CSC_ASYNC1_1__FULL                               IPU_MEMORY_OFFSET+0x0040114,0xffffffff
#define SRM_DP_CSC_ASYNC1_1__DP_CSC_S2_ASYNC1                   IPU_MEMORY_OFFSET+0x0040114,0xC0000000
#define SRM_DP_CSC_ASYNC1_1__DP_CSC_B2_ASYNC1                   IPU_MEMORY_OFFSET+0x0040114,0x3FFF0000
#define SRM_DP_CSC_ASYNC1_1__DP_CSC_S1_ASYNC1                   IPU_MEMORY_OFFSET+0x0040114,0x0000C000
#define SRM_DP_CSC_ASYNC1_1__DP_CSC_B1_ASYNC1                   IPU_MEMORY_OFFSET+0x0040114,0x00003FFF

#define SRM_CSI0_CPD_CTRL__ADDR                                 IPU_MEMORY_OFFSET+0x0040314
#define SRM_CSI0_CPD_CTRL__EMPTY                                IPU_MEMORY_OFFSET+0x0040314,0x00000000
#define SRM_CSI0_CPD_CTRL__FULL                                 IPU_MEMORY_OFFSET+0x0040314,0xffffffff
#define SRM_CSI0_CPD_CTRL__CSI0_CPD                             IPU_MEMORY_OFFSET+0x0040314,0x0000001C
#define SRM_CSI0_CPD_CTRL__CSI0_RED_ROW_BEGIN                   IPU_MEMORY_OFFSET+0x0040314,0x00000002
#define SRM_CSI0_CPD_CTRL__CSI0_GREEN_P_BEGIN                   IPU_MEMORY_OFFSET+0x0040314,0x00000001

#define SRM_CSI0_CPD_RC_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040318
#define SRM_CSI0_CPD_RC_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040318,0x00000000
#define SRM_CSI0_CPD_RC_0__FULL                                 IPU_MEMORY_OFFSET+0x0040318,0xffffffff
#define SRM_CSI0_CPD_RC_0__CSI0_CPD_RC_1                        IPU_MEMORY_OFFSET+0x0040318,0x01FF0000
#define SRM_CSI0_CPD_RC_0__CSI0_CPD_RC_0                        IPU_MEMORY_OFFSET+0x0040318,0x000001FF

#define SRM_CSI0_CPD_RC_1__ADDR                                 IPU_MEMORY_OFFSET+0x004031C
#define SRM_CSI0_CPD_RC_1__EMPTY                                IPU_MEMORY_OFFSET+0x004031C,0x00000000
#define SRM_CSI0_CPD_RC_1__FULL                                 IPU_MEMORY_OFFSET+0x004031C,0xffffffff
#define SRM_CSI0_CPD_RC_1__CSI0_CPD_RC_3                        IPU_MEMORY_OFFSET+0x004031C,0x01FF0000
#define SRM_CSI0_CPD_RC_1__CSI0_CPD_RC_2                        IPU_MEMORY_OFFSET+0x004031C,0x000001FF

#define SRM_CSI0_CPD_RC_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040320
#define SRM_CSI0_CPD_RC_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040320,0x00000000
#define SRM_CSI0_CPD_RC_2__FULL                                 IPU_MEMORY_OFFSET+0x0040320,0xffffffff
#define SRM_CSI0_CPD_RC_2__CSI0_CPD_RC_5                        IPU_MEMORY_OFFSET+0x0040320,0x01FF0000
#define SRM_CSI0_CPD_RC_2__CSI0_CPD_RC_4                        IPU_MEMORY_OFFSET+0x0040320,0x000001FF

#define SRM_CSI0_CPD_RC_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040324
#define SRM_CSI0_CPD_RC_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040324,0x00000000
#define SRM_CSI0_CPD_RC_3__FULL                                 IPU_MEMORY_OFFSET+0x0040324,0xffffffff
#define SRM_CSI0_CPD_RC_3__CSI0_CPD_RC_7                        IPU_MEMORY_OFFSET+0x0040324,0x01FF0000
#define SRM_CSI0_CPD_RC_3__CSI0_CPD_RC_6                        IPU_MEMORY_OFFSET+0x0040324,0x000001FF

#define SRM_CSI0_CPD_RC_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040328
#define SRM_CSI0_CPD_RC_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040328,0x00000000
#define SRM_CSI0_CPD_RC_4__FULL                                 IPU_MEMORY_OFFSET+0x0040328,0xffffffff
#define SRM_CSI0_CPD_RC_4__CSI0_CPD_RC_9                        IPU_MEMORY_OFFSET+0x0040328,0x01FF0000
#define SRM_CSI0_CPD_RC_4__CSI0_CPD_RC_8                        IPU_MEMORY_OFFSET+0x0040328,0x000001FF

#define SRM_CSI0_CPD_RC_5__ADDR                                 IPU_MEMORY_OFFSET+0x004032C
#define SRM_CSI0_CPD_RC_5__EMPTY                                IPU_MEMORY_OFFSET+0x004032C,0x00000000
#define SRM_CSI0_CPD_RC_5__FULL                                 IPU_MEMORY_OFFSET+0x004032C,0xffffffff
#define SRM_CSI0_CPD_RC_5__CSI0_CPD_RC_11                       IPU_MEMORY_OFFSET+0x004032C,0x01FF0000
#define SRM_CSI0_CPD_RC_5__CSI0_CPD_RC_10                       IPU_MEMORY_OFFSET+0x004032C,0x000001FF

#define SRM_CSI0_CPD_RC_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040330
#define SRM_CSI0_CPD_RC_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040330,0x00000000
#define SRM_CSI0_CPD_RC_6__FULL                                 IPU_MEMORY_OFFSET+0x0040330,0xffffffff
#define SRM_CSI0_CPD_RC_6__CSI0_CPD_RC_13                       IPU_MEMORY_OFFSET+0x0040330,0x01FF0000
#define SRM_CSI0_CPD_RC_6__CSI0_CPD_RC_12                       IPU_MEMORY_OFFSET+0x0040330,0x000001FF

#define SRM_CSI0_CPD_RC_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040334
#define SRM_CSI0_CPD_RC_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040334,0x00000000
#define SRM_CSI0_CPD_RC_7__FULL                                 IPU_MEMORY_OFFSET+0x0040334,0xffffffff
#define SRM_CSI0_CPD_RC_7__CSI0_CPD_RC_15                       IPU_MEMORY_OFFSET+0x0040334,0x01FF0000
#define SRM_CSI0_CPD_RC_7__CSI0_CPD_RC_14                       IPU_MEMORY_OFFSET+0x0040334,0x000001FF

#define SRM_CSI0_CPD_RS_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040338
#define SRM_CSI0_CPD_RS_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040338,0x00000000
#define SRM_CSI0_CPD_RS_0__FULL                                 IPU_MEMORY_OFFSET+0x0040338,0xffffffff
#define SRM_CSI0_CPD_RS_0__CSI0_CPD_RS3                         IPU_MEMORY_OFFSET+0x0040338,0xFF000000
#define SRM_CSI0_CPD_RS_0__CSI0_CPD_RS2                         IPU_MEMORY_OFFSET+0x0040338,0x00FF0000
#define SRM_CSI0_CPD_RS_0__CSI0_CPD_RS1                         IPU_MEMORY_OFFSET+0x0040338,0x0000FF00
#define SRM_CSI0_CPD_RS_0__CSI0_CPD_RS0                         IPU_MEMORY_OFFSET+0x0040338,0x000000FF

#define SRM_CSI0_CPD_RS_1__ADDR                                 IPU_MEMORY_OFFSET+0x004033C
#define SRM_CSI0_CPD_RS_1__EMPTY                                IPU_MEMORY_OFFSET+0x004033C,0x00000000
#define SRM_CSI0_CPD_RS_1__FULL                                 IPU_MEMORY_OFFSET+0x004033C,0xffffffff
#define SRM_CSI0_CPD_RS_1__CSI0_CPD_RS7                         IPU_MEMORY_OFFSET+0x004033C,0xFF000000
#define SRM_CSI0_CPD_RS_1__CSI0_CPD_RS6                         IPU_MEMORY_OFFSET+0x004033C,0x00FF0000
#define SRM_CSI0_CPD_RS_1__CSI0_CPD_RS5                         IPU_MEMORY_OFFSET+0x004033C,0x0000FF00
#define SRM_CSI0_CPD_RS_1__CSI0_CPD_RS4                         IPU_MEMORY_OFFSET+0x004033C,0x000000FF

#define SRM_CSI0_CPD_RS_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040340
#define SRM_CSI0_CPD_RS_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040340,0x00000000
#define SRM_CSI0_CPD_RS_2__FULL                                 IPU_MEMORY_OFFSET+0x0040340,0xffffffff
#define SRM_CSI0_CPD_RS_2__CSI0_CPD_RS11                        IPU_MEMORY_OFFSET+0x0040340,0xFF000000
#define SRM_CSI0_CPD_RS_2__CSI0_CPD_RS10                        IPU_MEMORY_OFFSET+0x0040340,0x00FF0000
#define SRM_CSI0_CPD_RS_2__CSI0_CPD_RS9                         IPU_MEMORY_OFFSET+0x0040340,0x0000FF00
#define SRM_CSI0_CPD_RS_2__CSI0_CPD_RS8                         IPU_MEMORY_OFFSET+0x0040340,0x000000FF

#define SRM_CSI0_CPD_RS_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040344
#define SRM_CSI0_CPD_RS_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040344,0x00000000
#define SRM_CSI0_CPD_RS_3__FULL                                 IPU_MEMORY_OFFSET+0x0040344,0xffffffff
#define SRM_CSI0_CPD_RS_3__CSI0_CPD_RS15                        IPU_MEMORY_OFFSET+0x0040344,0xFF000000
#define SRM_CSI0_CPD_RS_3__CSI0_CPD_RS14                        IPU_MEMORY_OFFSET+0x0040344,0x00FF0000
#define SRM_CSI0_CPD_RS_3__CSI0_CPD_RS13                        IPU_MEMORY_OFFSET+0x0040344,0x0000FF00
#define SRM_CSI0_CPD_RS_3__CSI0_CPD_RS12                        IPU_MEMORY_OFFSET+0x0040344,0x000000FF

#define SRM_CSI0_CPD_GRC_0__ADDR                                IPU_MEMORY_OFFSET+0x0040348
#define SRM_CSI0_CPD_GRC_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040348,0x00000000
#define SRM_CSI0_CPD_GRC_0__FULL                                IPU_MEMORY_OFFSET+0x0040348,0xffffffff
#define SRM_CSI0_CPD_GRC_0__CSI0_CPD_GRC1                       IPU_MEMORY_OFFSET+0x0040348,0x01FF0000
#define SRM_CSI0_CPD_GRC_0__CSI0_CPD_GRC0                       IPU_MEMORY_OFFSET+0x0040348,0x000001FF

#define SRM_CSI0_CPD_GRC_1__ADDR                                IPU_MEMORY_OFFSET+0x004034C
#define SRM_CSI0_CPD_GRC_1__EMPTY                               IPU_MEMORY_OFFSET+0x004034C,0x00000000
#define SRM_CSI0_CPD_GRC_1__FULL                                IPU_MEMORY_OFFSET+0x004034C,0xffffffff
#define SRM_CSI0_CPD_GRC_1__CSI0_CPD_GRC3                       IPU_MEMORY_OFFSET+0x004034C,0x01FF0000
#define SRM_CSI0_CPD_GRC_1__CSI0_CPD_GRC2                       IPU_MEMORY_OFFSET+0x004034C,0x000001FF

#define SRM_CSI0_CPD_GRC_2__ADDR                                IPU_MEMORY_OFFSET+0x0040350
#define SRM_CSI0_CPD_GRC_2__EMPTY                               IPU_MEMORY_OFFSET+0x0040350,0x00000000
#define SRM_CSI0_CPD_GRC_2__FULL                                IPU_MEMORY_OFFSET+0x0040350,0xffffffff
#define SRM_CSI0_CPD_GRC_2__CSI0_CPD_GRC5                       IPU_MEMORY_OFFSET+0x0040350,0x01FF0000
#define SRM_CSI0_CPD_GRC_2__CSI0_CPD_GRC4                       IPU_MEMORY_OFFSET+0x0040350,0x000001FF

#define SRM_CSI0_CPD_GRC_3__ADDR                                IPU_MEMORY_OFFSET+0x0040354
#define SRM_CSI0_CPD_GRC_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040354,0x00000000
#define SRM_CSI0_CPD_GRC_3__FULL                                IPU_MEMORY_OFFSET+0x0040354,0xffffffff
#define SRM_CSI0_CPD_GRC_3__CSI0_CPD_GRC7                       IPU_MEMORY_OFFSET+0x0040354,0x01FF0000
#define SRM_CSI0_CPD_GRC_3__CSI0_CPD_GRC6                       IPU_MEMORY_OFFSET+0x0040354,0x000001FF

#define SRM_CSI0_CPD_GRC_4__ADDR                                IPU_MEMORY_OFFSET+0x0040358
#define SRM_CSI0_CPD_GRC_4__EMPTY                               IPU_MEMORY_OFFSET+0x0040358,0x00000000
#define SRM_CSI0_CPD_GRC_4__FULL                                IPU_MEMORY_OFFSET+0x0040358,0xffffffff
#define SRM_CSI0_CPD_GRC_4__CSI0_CPD_GRC9                       IPU_MEMORY_OFFSET+0x0040358,0x01FF0000
#define SRM_CSI0_CPD_GRC_4__CSI0_CPD_GRC8                       IPU_MEMORY_OFFSET+0x0040358,0x000001FF

#define SRM_CSI0_CPD_GRC_5__ADDR                                IPU_MEMORY_OFFSET+0x004035C
#define SRM_CSI0_CPD_GRC_5__EMPTY                               IPU_MEMORY_OFFSET+0x004035C,0x00000000
#define SRM_CSI0_CPD_GRC_5__FULL                                IPU_MEMORY_OFFSET+0x004035C,0xffffffff
#define SRM_CSI0_CPD_GRC_5__CSI0_CPD_GRC11                      IPU_MEMORY_OFFSET+0x004035C,0x01FF0000
#define SRM_CSI0_CPD_GRC_5__CSI0_CPD_GRC10                      IPU_MEMORY_OFFSET+0x004035C,0x000001FF

#define SRM_CSI0_CPD_GRC_6__ADDR                                IPU_MEMORY_OFFSET+0x0040360
#define SRM_CSI0_CPD_GRC_6__EMPTY                               IPU_MEMORY_OFFSET+0x0040360,0x00000000
#define SRM_CSI0_CPD_GRC_6__FULL                                IPU_MEMORY_OFFSET+0x0040360,0xffffffff
#define SRM_CSI0_CPD_GRC_6__CSI0_CPD_GRC13                      IPU_MEMORY_OFFSET+0x0040360,0x01FF0000
#define SRM_CSI0_CPD_GRC_6__CSI0_CPD_GRC12                      IPU_MEMORY_OFFSET+0x0040360,0x000001FF

#define SRM_CSI0_CPD_GRC_7__ADDR                                IPU_MEMORY_OFFSET+0x0040364
#define SRM_CSI0_CPD_GRC_7__EMPTY                               IPU_MEMORY_OFFSET+0x0040364,0x00000000
#define SRM_CSI0_CPD_GRC_7__FULL                                IPU_MEMORY_OFFSET+0x0040364,0xffffffff
#define SRM_CSI0_CPD_GRC_7__CSI0_CPD_GRC15                      IPU_MEMORY_OFFSET+0x0040364,0x01FF0000
#define SRM_CSI0_CPD_GRC_7__CSI0_CPD_GRC14                      IPU_MEMORY_OFFSET+0x0040364,0x000001FF

#define SRM_CSI0_CPD_GRS_0__ADDR                                IPU_MEMORY_OFFSET+0x0040368
#define SRM_CSI0_CPD_GRS_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040368,0x00000000
#define SRM_CSI0_CPD_GRS_0__FULL                                IPU_MEMORY_OFFSET+0x0040368,0xffffffff
#define SRM_CSI0_CPD_GRS_0__CSI0_CPD_GRS3                       IPU_MEMORY_OFFSET+0x0040368,0xFF000000
#define SRM_CSI0_CPD_GRS_0__CSI0_CPD_GRS2                       IPU_MEMORY_OFFSET+0x0040368,0x00FF0000
#define SRM_CSI0_CPD_GRS_0__CSI0_CPD_GRS1                       IPU_MEMORY_OFFSET+0x0040368,0x0000FF00
#define SRM_CSI0_CPD_GRS_0__CSI0_CPD_GRS0                       IPU_MEMORY_OFFSET+0x0040368,0x000000FF

#define SRM_CSI0_CPD_GRS_1__ADDR                                IPU_MEMORY_OFFSET+0x004036C
#define SRM_CSI0_CPD_GRS_1__EMPTY                               IPU_MEMORY_OFFSET+0x004036C,0x00000000
#define SRM_CSI0_CPD_GRS_1__FULL                                IPU_MEMORY_OFFSET+0x004036C,0xffffffff
#define SRM_CSI0_CPD_GRS_1__CSI0_CPD_GRS7                       IPU_MEMORY_OFFSET+0x004036C,0xFF000000
#define SRM_CSI0_CPD_GRS_1__CSI0_CPD_GRS6                       IPU_MEMORY_OFFSET+0x004036C,0x00FF0000
#define SRM_CSI0_CPD_GRS_1__CSI0_CPD_GRS5                       IPU_MEMORY_OFFSET+0x004036C,0x0000FF00
#define SRM_CSI0_CPD_GRS_1__CSI0_CPD_GRS4                       IPU_MEMORY_OFFSET+0x004036C,0x000000FF

#define SRM_CSI0_CPD_GRS_2__ADDR                                IPU_MEMORY_OFFSET+0x0040370
#define SRM_CSI0_CPD_GRS_2__EMPTY                               IPU_MEMORY_OFFSET+0x0040370,0x00000000
#define SRM_CSI0_CPD_GRS_2__FULL                                IPU_MEMORY_OFFSET+0x0040370,0xffffffff
#define SRM_CSI0_CPD_GRS_2__CSI0_CPD_GRS11                      IPU_MEMORY_OFFSET+0x0040370,0xFF000000
#define SRM_CSI0_CPD_GRS_2__CSI0_CPD_GRS10                      IPU_MEMORY_OFFSET+0x0040370,0x00FF0000
#define SRM_CSI0_CPD_GRS_2__CSI0_CPD_GRS9                       IPU_MEMORY_OFFSET+0x0040370,0x0000FF00
#define SRM_CSI0_CPD_GRS_2__CSI0_CPD_GRS8                       IPU_MEMORY_OFFSET+0x0040370,0x000000FF

#define SRM_CSI0_CPD_GRS_3__ADDR                                IPU_MEMORY_OFFSET+0x0040374
#define SRM_CSI0_CPD_GRS_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040374,0x00000000
#define SRM_CSI0_CPD_GRS_3__FULL                                IPU_MEMORY_OFFSET+0x0040374,0xffffffff
#define SRM_CSI0_CPD_GRS_3__CSI0_CPD_GRS15                      IPU_MEMORY_OFFSET+0x0040374,0xFF000000
#define SRM_CSI0_CPD_GRS_3__CSI0_CPD_GRS14                      IPU_MEMORY_OFFSET+0x0040374,0x00FF0000
#define SRM_CSI0_CPD_GRS_3__CSI0_CPD_GRS13                      IPU_MEMORY_OFFSET+0x0040374,0x0000FF00
#define SRM_CSI0_CPD_GRS_3__CSI0_CPD_GRS12                      IPU_MEMORY_OFFSET+0x0040374,0x000000FF

#define SRM_CSI0_CPD_GBC_0__ADDR                                IPU_MEMORY_OFFSET+0x0040378
#define SRM_CSI0_CPD_GBC_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040378,0x00000000
#define SRM_CSI0_CPD_GBC_0__FULL                                IPU_MEMORY_OFFSET+0x0040378,0xffffffff
#define SRM_CSI0_CPD_GBC_0__CSI0_CPD_GBC1                       IPU_MEMORY_OFFSET+0x0040378,0x01FF0000
#define SRM_CSI0_CPD_GBC_0__CSI0_CPD_GBC0                       IPU_MEMORY_OFFSET+0x0040378,0x000001FF

#define SRM_CSI0_CPD_GBC_1__ADDR                                IPU_MEMORY_OFFSET+0x004037C
#define SRM_CSI0_CPD_GBC_1__EMPTY                               IPU_MEMORY_OFFSET+0x004037C,0x00000000
#define SRM_CSI0_CPD_GBC_1__FULL                                IPU_MEMORY_OFFSET+0x004037C,0xffffffff
#define SRM_CSI0_CPD_GBC_1__CSI0_CPD_GBC3                       IPU_MEMORY_OFFSET+0x004037C,0x01FF0000
#define SRM_CSI0_CPD_GBC_1__CSI0_CPD_GBC2                       IPU_MEMORY_OFFSET+0x004037C,0x000001FF

#define SRM_CSI0_CPD_GBC_2__ADDR                                IPU_MEMORY_OFFSET+0x0040380
#define SRM_CSI0_CPD_GBC_2__EMPTY                               IPU_MEMORY_OFFSET+0x0040380,0x00000000
#define SRM_CSI0_CPD_GBC_2__FULL                                IPU_MEMORY_OFFSET+0x0040380,0xffffffff
#define SRM_CSI0_CPD_GBC_2__CSI0_CPD_GBC5                       IPU_MEMORY_OFFSET+0x0040380,0x01FF0000
#define SRM_CSI0_CPD_GBC_2__CSI0_CPD_GBC4                       IPU_MEMORY_OFFSET+0x0040380,0x000001FF

#define SRM_CSI0_CPD_GBC_3__ADDR                                IPU_MEMORY_OFFSET+0x0040384
#define SRM_CSI0_CPD_GBC_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040384,0x00000000
#define SRM_CSI0_CPD_GBC_3__FULL                                IPU_MEMORY_OFFSET+0x0040384,0xffffffff
#define SRM_CSI0_CPD_GBC_3__CSI0_CPD_GBC7                       IPU_MEMORY_OFFSET+0x0040384,0x01FF0000
#define SRM_CSI0_CPD_GBC_3__CSI0_CPD_GBC6                       IPU_MEMORY_OFFSET+0x0040384,0x000001FF

#define SRM_CSI0_CPD_GBC_4__ADDR                                IPU_MEMORY_OFFSET+0x0040388
#define SRM_CSI0_CPD_GBC_4__EMPTY                               IPU_MEMORY_OFFSET+0x0040388,0x00000000
#define SRM_CSI0_CPD_GBC_4__FULL                                IPU_MEMORY_OFFSET+0x0040388,0xffffffff
#define SRM_CSI0_CPD_GBC_4__CSI0_CPD_GBC9                       IPU_MEMORY_OFFSET+0x0040388,0x01FF0000
#define SRM_CSI0_CPD_GBC_4__CSI0_CPD_GBC8                       IPU_MEMORY_OFFSET+0x0040388,0x000001FF

#define SRM_CSI0_CPD_GBC_5__ADDR                                IPU_MEMORY_OFFSET+0x004038C
#define SRM_CSI0_CPD_GBC_5__EMPTY                               IPU_MEMORY_OFFSET+0x004038C,0x00000000
#define SRM_CSI0_CPD_GBC_5__FULL                                IPU_MEMORY_OFFSET+0x004038C,0xffffffff
#define SRM_CSI0_CPD_GBC_5__CSI0_CPD_GBC11                      IPU_MEMORY_OFFSET+0x004038C,0x01FF0000
#define SRM_CSI0_CPD_GBC_5__CSI0_CPD_GBC10                      IPU_MEMORY_OFFSET+0x004038C,0x000001FF

#define SRM_CSI0_CPD_GBC_6__ADDR                                IPU_MEMORY_OFFSET+0x0040390
#define SRM_CSI0_CPD_GBC_6__EMPTY                               IPU_MEMORY_OFFSET+0x0040390,0x00000000
#define SRM_CSI0_CPD_GBC_6__FULL                                IPU_MEMORY_OFFSET+0x0040390,0xffffffff
#define SRM_CSI0_CPD_GBC_6__CSI0_CPD_GBC13                      IPU_MEMORY_OFFSET+0x0040390,0x01FF0000
#define SRM_CSI0_CPD_GBC_6__CSI0_CPD_GBC12                      IPU_MEMORY_OFFSET+0x0040390,0x000001FF

#define SRM_CSI0_CPD_GBC_7__ADDR                                IPU_MEMORY_OFFSET+0x0040394
#define SRM_CSI0_CPD_GBC_7__EMPTY                               IPU_MEMORY_OFFSET+0x0040394,0x00000000
#define SRM_CSI0_CPD_GBC_7__FULL                                IPU_MEMORY_OFFSET+0x0040394,0xffffffff
#define SRM_CSI0_CPD_GBC_7__CSI0_CPD_GBC15                      IPU_MEMORY_OFFSET+0x0040394,0x01FF0000
#define SRM_CSI0_CPD_GBC_7__CSI0_CPD_GBC14                      IPU_MEMORY_OFFSET+0x0040394,0x000001FF

#define SRM_CSI0_CPD_GBS_0__ADDR                                IPU_MEMORY_OFFSET+0x0040398
#define SRM_CSI0_CPD_GBS_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040398,0x00000000
#define SRM_CSI0_CPD_GBS_0__FULL                                IPU_MEMORY_OFFSET+0x0040398,0xffffffff
#define SRM_CSI0_CPD_GBS_0__CSI0_CPD_GBS3                       IPU_MEMORY_OFFSET+0x0040398,0xFF000000
#define SRM_CSI0_CPD_GBS_0__CSI0_CPD_GBS2                       IPU_MEMORY_OFFSET+0x0040398,0x00FF0000
#define SRM_CSI0_CPD_GBS_0__CSI0_CPD_GBS1                       IPU_MEMORY_OFFSET+0x0040398,0x0000FF00
#define SRM_CSI0_CPD_GBS_0__CSI0_CPD_GBS0                       IPU_MEMORY_OFFSET+0x0040398,0x000000FF

#define SRM_CSI0_CPD_GBS_1__ADDR                                IPU_MEMORY_OFFSET+0x004039C
#define SRM_CSI0_CPD_GBS_1__EMPTY                               IPU_MEMORY_OFFSET+0x004039C,0x00000000
#define SRM_CSI0_CPD_GBS_1__FULL                                IPU_MEMORY_OFFSET+0x004039C,0xffffffff
#define SRM_CSI0_CPD_GBS_1__CSI0_CPD_GBS7                       IPU_MEMORY_OFFSET+0x004039C,0xFF000000
#define SRM_CSI0_CPD_GBS_1__CSI0_CPD_GBS6                       IPU_MEMORY_OFFSET+0x004039C,0x00FF0000
#define SRM_CSI0_CPD_GBS_1__CSI0_CPD_GBS5                       IPU_MEMORY_OFFSET+0x004039C,0x0000FF00
#define SRM_CSI0_CPD_GBS_1__CSI0_CPD_GBS4                       IPU_MEMORY_OFFSET+0x004039C,0x000000FF

#define SRM_CSI0_CPD_GBS_2__ADDR                                IPU_MEMORY_OFFSET+0x00403A0
#define SRM_CSI0_CPD_GBS_2__EMPTY                               IPU_MEMORY_OFFSET+0x00403A0,0x00000000
#define SRM_CSI0_CPD_GBS_2__FULL                                IPU_MEMORY_OFFSET+0x00403A0,0xffffffff
#define SRM_CSI0_CPD_GBS_2__CSI0_CPD_GBS11                      IPU_MEMORY_OFFSET+0x00403A0,0xFF000000
#define SRM_CSI0_CPD_GBS_2__CSI0_CPD_GBS10                      IPU_MEMORY_OFFSET+0x00403A0,0x00FF0000
#define SRM_CSI0_CPD_GBS_2__CSI0_CPD_GBS9                       IPU_MEMORY_OFFSET+0x00403A0,0x0000FF00
#define SRM_CSI0_CPD_GBS_2__CSI0_CPD_GBS8                       IPU_MEMORY_OFFSET+0x00403A0,0x000000FF

#define SRM_CSI0_CPD_GBS_3__ADDR                                IPU_MEMORY_OFFSET+0x00403A4
#define SRM_CSI0_CPD_GBS_3__EMPTY                               IPU_MEMORY_OFFSET+0x00403A4,0x00000000
#define SRM_CSI0_CPD_GBS_3__FULL                                IPU_MEMORY_OFFSET+0x00403A4,0xffffffff
#define SRM_CSI0_CPD_GBS_3__CSI0_CPD_GBS15                      IPU_MEMORY_OFFSET+0x00403A4,0xFF000000
#define SRM_CSI0_CPD_GBS_3__CSI0_CPD_GBS14                      IPU_MEMORY_OFFSET+0x00403A4,0x00FF0000
#define SRM_CSI0_CPD_GBS_3__CSI0_CPD_GBS13                      IPU_MEMORY_OFFSET+0x00403A4,0x0000FF00
#define SRM_CSI0_CPD_GBS_3__CSI0_CPD_GBS12                      IPU_MEMORY_OFFSET+0x00403A4,0x000000FF

#define SRM_CSI0_CPD_BC_0__ADDR                                 IPU_MEMORY_OFFSET+0x00403A8
#define SRM_CSI0_CPD_BC_0__EMPTY                                IPU_MEMORY_OFFSET+0x00403A8,0x00000000
#define SRM_CSI0_CPD_BC_0__FULL                                 IPU_MEMORY_OFFSET+0x00403A8,0xffffffff
#define SRM_CSI0_CPD_BC_0__CSI0_CPD_BC1                         IPU_MEMORY_OFFSET+0x00403A8,0x01FF0000
#define SRM_CSI0_CPD_BC_0__CSI0_CPD_BC0                         IPU_MEMORY_OFFSET+0x00403A8,0x000001FF

#define SRM_CSI0_CPD_BC_1__ADDR                                 IPU_MEMORY_OFFSET+0x00403AC
#define SRM_CSI0_CPD_BC_1__EMPTY                                IPU_MEMORY_OFFSET+0x00403AC,0x00000000
#define SRM_CSI0_CPD_BC_1__FULL                                 IPU_MEMORY_OFFSET+0x00403AC,0xffffffff
#define SRM_CSI0_CPD_BC_1__CSI0_CPD_BC3                         IPU_MEMORY_OFFSET+0x00403AC,0x01FF0000
#define SRM_CSI0_CPD_BC_1__CSI0_CPD_BC2                         IPU_MEMORY_OFFSET+0x00403AC,0x000001FF

#define SRM_CSI0_CPD_BC_2__ADDR                                 IPU_MEMORY_OFFSET+0x00403B0
#define SRM_CSI0_CPD_BC_2__EMPTY                                IPU_MEMORY_OFFSET+0x00403B0,0x00000000
#define SRM_CSI0_CPD_BC_2__FULL                                 IPU_MEMORY_OFFSET+0x00403B0,0xffffffff
#define SRM_CSI0_CPD_BC_2__CSI0_CPD_BC5                         IPU_MEMORY_OFFSET+0x00403B0,0x01FF0000
#define SRM_CSI0_CPD_BC_2__CSI0_CPD_BC4                         IPU_MEMORY_OFFSET+0x00403B0,0x000001FF

#define SRM_CSI0_CPD_BC_3__ADDR                                 IPU_MEMORY_OFFSET+0x00403B4
#define SRM_CSI0_CPD_BC_3__EMPTY                                IPU_MEMORY_OFFSET+0x00403B4,0x00000000
#define SRM_CSI0_CPD_BC_3__FULL                                 IPU_MEMORY_OFFSET+0x00403B4,0xffffffff
#define SRM_CSI0_CPD_BC_3__CSI0_CPD_BC7                         IPU_MEMORY_OFFSET+0x00403B4,0x01FF0000
#define SRM_CSI0_CPD_BC_3__CSI0_CPD_BC6                         IPU_MEMORY_OFFSET+0x00403B4,0x000001FF

#define SRM_CSI0_CPD_BC_4__ADDR                                 IPU_MEMORY_OFFSET+0x00403B8
#define SRM_CSI0_CPD_BC_4__EMPTY                                IPU_MEMORY_OFFSET+0x00403B8,0x00000000
#define SRM_CSI0_CPD_BC_4__FULL                                 IPU_MEMORY_OFFSET+0x00403B8,0xffffffff
#define SRM_CSI0_CPD_BC_4__CSI0_CPD_BC9                         IPU_MEMORY_OFFSET+0x00403B8,0x01FF0000
#define SRM_CSI0_CPD_BC_4__CSI0_CPD_BC8                         IPU_MEMORY_OFFSET+0x00403B8,0x000001FF

#define SRM_CSI0_CPD_BC_5__ADDR                                 IPU_MEMORY_OFFSET+0x00403BC
#define SRM_CSI0_CPD_BC_5__EMPTY                                IPU_MEMORY_OFFSET+0x00403BC,0x00000000
#define SRM_CSI0_CPD_BC_5__FULL                                 IPU_MEMORY_OFFSET+0x00403BC,0xffffffff
#define SRM_CSI0_CPD_BC_5__CSI0_CPD_BC11                        IPU_MEMORY_OFFSET+0x00403BC,0x01FF0000
#define SRM_CSI0_CPD_BC_5__CSI0_CPD_BC10                        IPU_MEMORY_OFFSET+0x00403BC,0x000001FF

#define SRM_CSI0_CPD_BC_6__ADDR                                 IPU_MEMORY_OFFSET+0x00403C0
#define SRM_CSI0_CPD_BC_6__EMPTY                                IPU_MEMORY_OFFSET+0x00403C0,0x00000000
#define SRM_CSI0_CPD_BC_6__FULL                                 IPU_MEMORY_OFFSET+0x00403C0,0xffffffff
#define SRM_CSI0_CPD_BC_6__CSI0_CPD_BC13                        IPU_MEMORY_OFFSET+0x00403C0,0x01FF0000
#define SRM_CSI0_CPD_BC_6__CSI0_CPD_BC12                        IPU_MEMORY_OFFSET+0x00403C0,0x000001FF

#define SRM_CSI0_CPD_BC_7__ADDR                                 IPU_MEMORY_OFFSET+0x00403C4
#define SRM_CSI0_CPD_BC_7__EMPTY                                IPU_MEMORY_OFFSET+0x00403C4,0x00000000
#define SRM_CSI0_CPD_BC_7__FULL                                 IPU_MEMORY_OFFSET+0x00403C4,0xffffffff
#define SRM_CSI0_CPD_BC_7__CSI0_CPD_BC15                        IPU_MEMORY_OFFSET+0x00403C4,0x01FF0000
#define SRM_CSI0_CPD_BC_7__CSI0_CPD_BC14                        IPU_MEMORY_OFFSET+0x00403C4,0x000001FF

#define SRM_CSI0_CPD_BS_0__ADDR                                 IPU_MEMORY_OFFSET+0x00403C8
#define SRM_CSI0_CPD_BS_0__EMPTY                                IPU_MEMORY_OFFSET+0x00403C8,0x00000000
#define SRM_CSI0_CPD_BS_0__FULL                                 IPU_MEMORY_OFFSET+0x00403C8,0xffffffff
#define SRM_CSI0_CPD_BS_0__CSI0_CPD_BS3                         IPU_MEMORY_OFFSET+0x00403C8,0xFF000000
#define SRM_CSI0_CPD_BS_0__CSI0_CPD_BS2                         IPU_MEMORY_OFFSET+0x00403C8,0x00FF0000
#define SRM_CSI0_CPD_BS_0__CSI0_CPD_BS1                         IPU_MEMORY_OFFSET+0x00403C8,0x0000FF00
#define SRM_CSI0_CPD_BS_0__CSI0_CPD_BS0                         IPU_MEMORY_OFFSET+0x00403C8,0x000000FF

#define SRM_CSI0_CPD_BS_1__ADDR                                 IPU_MEMORY_OFFSET+0x00403CC
#define SRM_CSI0_CPD_BS_1__EMPTY                                IPU_MEMORY_OFFSET+0x00403CC,0x00000000
#define SRM_CSI0_CPD_BS_1__FULL                                 IPU_MEMORY_OFFSET+0x00403CC,0xffffffff
#define SRM_CSI0_CPD_BS_1__CSI0_CPD_BS7                         IPU_MEMORY_OFFSET+0x00403CC,0xFF000000
#define SRM_CSI0_CPD_BS_1__CSI0_CPD_BS6                         IPU_MEMORY_OFFSET+0x00403CC,0x00FF0000
#define SRM_CSI0_CPD_BS_1__CSI0_CPD_BS5                         IPU_MEMORY_OFFSET+0x00403CC,0x0000FF00
#define SRM_CSI0_CPD_BS_1__CSI0_CPD_BS4                         IPU_MEMORY_OFFSET+0x00403CC,0x000000FF

#define SRM_CSI0_CPD_BS_2__ADDR                                 IPU_MEMORY_OFFSET+0x00403D0
#define SRM_CSI0_CPD_BS_2__EMPTY                                IPU_MEMORY_OFFSET+0x00403D0,0x00000000
#define SRM_CSI0_CPD_BS_2__FULL                                 IPU_MEMORY_OFFSET+0x00403D0,0xffffffff
#define SRM_CSI0_CPD_BS_2__CSI0_CPD_BS11                        IPU_MEMORY_OFFSET+0x00403D0,0xFF000000
#define SRM_CSI0_CPD_BS_2__CSI0_CPD_BS10                        IPU_MEMORY_OFFSET+0x00403D0,0x00FF0000
#define SRM_CSI0_CPD_BS_2__CSI0_CPD_BS9                         IPU_MEMORY_OFFSET+0x00403D0,0x0000FF00
#define SRM_CSI0_CPD_BS_2__CSI0_CPD_BS8                         IPU_MEMORY_OFFSET+0x00403D0,0x000000FF

#define SRM_CSI0_CPD_BS_3__ADDR                                 IPU_MEMORY_OFFSET+0x00403D4
#define SRM_CSI0_CPD_BS_3__EMPTY                                IPU_MEMORY_OFFSET+0x00403D4,0x00000000
#define SRM_CSI0_CPD_BS_3__FULL                                 IPU_MEMORY_OFFSET+0x00403D4,0xffffffff
#define SRM_CSI0_CPD_BS_3__CSI0_CPD_BS15                        IPU_MEMORY_OFFSET+0x00403D4,0xFF000000
#define SRM_CSI0_CPD_BS_3__CSI0_CPD_BS14                        IPU_MEMORY_OFFSET+0x00403D4,0x00FF0000
#define SRM_CSI0_CPD_BS_3__CSI0_CPD_BS13                        IPU_MEMORY_OFFSET+0x00403D4,0x0000FF00
#define SRM_CSI0_CPD_BS_3__CSI0_CPD_BS12                        IPU_MEMORY_OFFSET+0x00403D4,0x000000FF

#define SRM_CSI0_CPD_OFFSET1__ADDR                              IPU_MEMORY_OFFSET+0x00403D8
#define SRM_CSI0_CPD_OFFSET1__EMPTY                             IPU_MEMORY_OFFSET+0x00403D8,0x00000000
#define SRM_CSI0_CPD_OFFSET1__FULL                              IPU_MEMORY_OFFSET+0x00403D8,0xffffffff
#define SRM_CSI0_CPD_OFFSET1__CSI0_CPD_B_OFFSET                 IPU_MEMORY_OFFSET+0x00403D8,0x3FF00000
#define SRM_CSI0_CPD_OFFSET1__CSI0_CPD_GB_OFFSET                IPU_MEMORY_OFFSET+0x00403D8,0x000FFC00
#define SRM_CSI0_CPD_OFFSET1__CSI0_CPD_GR_OFFSET                IPU_MEMORY_OFFSET+0x00403D8,0x000003FF

#define SRM_CSI0_CPD_OFFSET2__ADDR                              IPU_MEMORY_OFFSET+0x00403DC
#define SRM_CSI0_CPD_OFFSET2__EMPTY                             IPU_MEMORY_OFFSET+0x00403DC,0x00000000
#define SRM_CSI0_CPD_OFFSET2__FULL                              IPU_MEMORY_OFFSET+0x00403DC,0xffffffff
#define SRM_CSI0_CPD_OFFSET2__CSI0_CPD_R_OFFSET                 IPU_MEMORY_OFFSET+0x00403DC,0x000003FF

#define SRM_CSI1_CPD_CTRL__ADDR                                 IPU_MEMORY_OFFSET+0x00403E0
#define SRM_CSI1_CPD_CTRL__EMPTY                                IPU_MEMORY_OFFSET+0x00403E0,0x00000000
#define SRM_CSI1_CPD_CTRL__FULL                                 IPU_MEMORY_OFFSET+0x00403E0,0xffffffff
#define SRM_CSI1_CPD_CTRL__CSI1_CPD                             IPU_MEMORY_OFFSET+0x00403E0,0x0000001C
#define SRM_CSI1_CPD_CTRL__CSI1_RED_ROW_BEGIN                   IPU_MEMORY_OFFSET+0x00403E0,0x00000002
#define SRM_CSI1_CPD_CTRL__CSI1_GREEN_P_BEGIN                   IPU_MEMORY_OFFSET+0x00403E0,0x00000001

#define SRM_CSI1_CPD_RC_0__ADDR                                 IPU_MEMORY_OFFSET+0x00403E4
#define SRM_CSI1_CPD_RC_0__EMPTY                                IPU_MEMORY_OFFSET+0x00403E4,0x00000000
#define SRM_CSI1_CPD_RC_0__FULL                                 IPU_MEMORY_OFFSET+0x00403E4,0xffffffff
#define SRM_CSI1_CPD_RC_0__CSI1_CPD_RC_1                        IPU_MEMORY_OFFSET+0x00403E4,0x01FF0000
#define SRM_CSI1_CPD_RC_0__CSI1_CPD_RC_0                        IPU_MEMORY_OFFSET+0x00403E4,0x000001FF

#define SRM_CSI1_CPD_RC_1__ADDR                                 IPU_MEMORY_OFFSET+0x00403E8
#define SRM_CSI1_CPD_RC_1__EMPTY                                IPU_MEMORY_OFFSET+0x00403E8,0x00000000
#define SRM_CSI1_CPD_RC_1__FULL                                 IPU_MEMORY_OFFSET+0x00403E8,0xffffffff
#define SRM_CSI1_CPD_RC_1__CSI1_CPD_RC_3                        IPU_MEMORY_OFFSET+0x00403E8,0x01FF0000
#define SRM_CSI1_CPD_RC_1__CSI1_CPD_RC_2                        IPU_MEMORY_OFFSET+0x00403E8,0x000001FF

#define SRM_CSI1_CPD_RC_2__ADDR                                 IPU_MEMORY_OFFSET+0x00403EC
#define SRM_CSI1_CPD_RC_2__EMPTY                                IPU_MEMORY_OFFSET+0x00403EC,0x00000000
#define SRM_CSI1_CPD_RC_2__FULL                                 IPU_MEMORY_OFFSET+0x00403EC,0xffffffff
#define SRM_CSI1_CPD_RC_2__CSI1_CPD_RC_5                        IPU_MEMORY_OFFSET+0x00403EC,0x01FF0000
#define SRM_CSI1_CPD_RC_2__CSI1_CPD_RC_4                        IPU_MEMORY_OFFSET+0x00403EC,0x000001FF

#define SRM_CSI1_CPD_RC_3__ADDR                                 IPU_MEMORY_OFFSET+0x00403F0
#define SRM_CSI1_CPD_RC_3__EMPTY                                IPU_MEMORY_OFFSET+0x00403F0,0x00000000
#define SRM_CSI1_CPD_RC_3__FULL                                 IPU_MEMORY_OFFSET+0x00403F0,0xffffffff
#define SRM_CSI1_CPD_RC_3__CSI1_CPD_RC_7                        IPU_MEMORY_OFFSET+0x00403F0,0x01FF0000
#define SRM_CSI1_CPD_RC_3__CSI1_CPD_RC_6                        IPU_MEMORY_OFFSET+0x00403F0,0x000001FF

#define SRM_CSI1_CPD_RC_4__ADDR                                 IPU_MEMORY_OFFSET+0x00403F4
#define SRM_CSI1_CPD_RC_4__EMPTY                                IPU_MEMORY_OFFSET+0x00403F4,0x00000000
#define SRM_CSI1_CPD_RC_4__FULL                                 IPU_MEMORY_OFFSET+0x00403F4,0xffffffff
#define SRM_CSI1_CPD_RC_4__CSI1_CPD_RC_9                        IPU_MEMORY_OFFSET+0x00403F4,0x01FF0000
#define SRM_CSI1_CPD_RC_4__CSI1_CPD_RC_8                        IPU_MEMORY_OFFSET+0x00403F4,0x000001FF

#define SRM_CSI1_CPD_RC_5__ADDR                                 IPU_MEMORY_OFFSET+0x00403F8
#define SRM_CSI1_CPD_RC_5__EMPTY                                IPU_MEMORY_OFFSET+0x00403F8,0x00000000
#define SRM_CSI1_CPD_RC_5__FULL                                 IPU_MEMORY_OFFSET+0x00403F8,0xffffffff
#define SRM_CSI1_CPD_RC_5__CSI1_CPD_RC_11                       IPU_MEMORY_OFFSET+0x00403F8,0x01FF0000
#define SRM_CSI1_CPD_RC_5__CSI1_CPD_RC_10                       IPU_MEMORY_OFFSET+0x00403F8,0x000001FF

#define SRM_CSI1_CPD_RC_6__ADDR                                 IPU_MEMORY_OFFSET+0x00403FC
#define SRM_CSI1_CPD_RC_6__EMPTY                                IPU_MEMORY_OFFSET+0x00403FC,0x00000000
#define SRM_CSI1_CPD_RC_6__FULL                                 IPU_MEMORY_OFFSET+0x00403FC,0xffffffff
#define SRM_CSI1_CPD_RC_6__CSI1_CPD_RC_13                       IPU_MEMORY_OFFSET+0x00403FC,0x01FF0000
#define SRM_CSI1_CPD_RC_6__CSI1_CPD_RC_12                       IPU_MEMORY_OFFSET+0x00403FC,0x000001FF

#define SRM_CSI1_CPD_RC_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040400
#define SRM_CSI1_CPD_RC_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040400,0x00000000
#define SRM_CSI1_CPD_RC_7__FULL                                 IPU_MEMORY_OFFSET+0x0040400,0xffffffff
#define SRM_CSI1_CPD_RC_7__CSI1_CPD_RC_15                       IPU_MEMORY_OFFSET+0x0040400,0x01FF0000
#define SRM_CSI1_CPD_RC_7__CSI1_CPD_RC_14                       IPU_MEMORY_OFFSET+0x0040400,0x000001FF

#define SRM_CSI1_CPD_RS_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040404
#define SRM_CSI1_CPD_RS_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040404,0x00000000
#define SRM_CSI1_CPD_RS_0__FULL                                 IPU_MEMORY_OFFSET+0x0040404,0xffffffff
#define SRM_CSI1_CPD_RS_0__CSI1_CPD_RS3                         IPU_MEMORY_OFFSET+0x0040404,0xFF000000
#define SRM_CSI1_CPD_RS_0__CSI1_CPD_RS2                         IPU_MEMORY_OFFSET+0x0040404,0x00FF0000
#define SRM_CSI1_CPD_RS_0__CSI1_CPD_RS1                         IPU_MEMORY_OFFSET+0x0040404,0x0000FF00
#define SRM_CSI1_CPD_RS_0__CSI1_CPD_RS0                         IPU_MEMORY_OFFSET+0x0040404,0x000000FF

#define SRM_CSI1_CPD_RS_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040408
#define SRM_CSI1_CPD_RS_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040408,0x00000000
#define SRM_CSI1_CPD_RS_1__FULL                                 IPU_MEMORY_OFFSET+0x0040408,0xffffffff
#define SRM_CSI1_CPD_RS_1__CSI1_CPD_RS7                         IPU_MEMORY_OFFSET+0x0040408,0xFF000000
#define SRM_CSI1_CPD_RS_1__CSI1_CPD_RS6                         IPU_MEMORY_OFFSET+0x0040408,0x00FF0000
#define SRM_CSI1_CPD_RS_1__CSI1_CPD_RS5                         IPU_MEMORY_OFFSET+0x0040408,0x0000FF00
#define SRM_CSI1_CPD_RS_1__CSI1_CPD_RS4                         IPU_MEMORY_OFFSET+0x0040408,0x000000FF

#define SRM_CSI1_CPD_RS_2__ADDR                                 IPU_MEMORY_OFFSET+0x004040C
#define SRM_CSI1_CPD_RS_2__EMPTY                                IPU_MEMORY_OFFSET+0x004040C,0x00000000
#define SRM_CSI1_CPD_RS_2__FULL                                 IPU_MEMORY_OFFSET+0x004040C,0xffffffff
#define SRM_CSI1_CPD_RS_2__CSI1_CPD_RS11                        IPU_MEMORY_OFFSET+0x004040C,0xFF000000
#define SRM_CSI1_CPD_RS_2__CSI1_CPD_RS10                        IPU_MEMORY_OFFSET+0x004040C,0x00FF0000
#define SRM_CSI1_CPD_RS_2__CSI1_CPD_RS9                         IPU_MEMORY_OFFSET+0x004040C,0x0000FF00
#define SRM_CSI1_CPD_RS_2__CSI1_CPD_RS8                         IPU_MEMORY_OFFSET+0x004040C,0x000000FF

#define SRM_CSI1_CPD_RS_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040410
#define SRM_CSI1_CPD_RS_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040410,0x00000000
#define SRM_CSI1_CPD_RS_3__FULL                                 IPU_MEMORY_OFFSET+0x0040410,0xffffffff
#define SRM_CSI1_CPD_RS_3__CSI1_CPD_RS15                        IPU_MEMORY_OFFSET+0x0040410,0xFF000000
#define SRM_CSI1_CPD_RS_3__CSI1_CPD_RS14                        IPU_MEMORY_OFFSET+0x0040410,0x00FF0000
#define SRM_CSI1_CPD_RS_3__CSI1_CPD_RS13                        IPU_MEMORY_OFFSET+0x0040410,0x0000FF00
#define SRM_CSI1_CPD_RS_3__CSI1_CPD_RS12                        IPU_MEMORY_OFFSET+0x0040410,0x000000FF

#define SRM_CSI1_CPD_GRC_0__ADDR                                IPU_MEMORY_OFFSET+0x0040414
#define SRM_CSI1_CPD_GRC_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040414,0x00000000
#define SRM_CSI1_CPD_GRC_0__FULL                                IPU_MEMORY_OFFSET+0x0040414,0xffffffff
#define SRM_CSI1_CPD_GRC_0__CSI1_CPD_GRC1                       IPU_MEMORY_OFFSET+0x0040414,0x01FF0000
#define SRM_CSI1_CPD_GRC_0__CSI1_CPD_GRC0                       IPU_MEMORY_OFFSET+0x0040414,0x000001FF

#define SRM_CSI1_CPD_GRC_1__ADDR                                IPU_MEMORY_OFFSET+0x0040418
#define SRM_CSI1_CPD_GRC_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040418,0x00000000
#define SRM_CSI1_CPD_GRC_1__FULL                                IPU_MEMORY_OFFSET+0x0040418,0xffffffff
#define SRM_CSI1_CPD_GRC_1__CSI1_CPD_GRC3                       IPU_MEMORY_OFFSET+0x0040418,0x01FF0000
#define SRM_CSI1_CPD_GRC_1__CSI1_CPD_GRC2                       IPU_MEMORY_OFFSET+0x0040418,0x000001FF

#define SRM_CSI1_CPD_GRC_2__ADDR                                IPU_MEMORY_OFFSET+0x004041C
#define SRM_CSI1_CPD_GRC_2__EMPTY                               IPU_MEMORY_OFFSET+0x004041C,0x00000000
#define SRM_CSI1_CPD_GRC_2__FULL                                IPU_MEMORY_OFFSET+0x004041C,0xffffffff
#define SRM_CSI1_CPD_GRC_2__CSI1_CPD_GRC5                       IPU_MEMORY_OFFSET+0x004041C,0x01FF0000
#define SRM_CSI1_CPD_GRC_2__CSI1_CPD_GRC4                       IPU_MEMORY_OFFSET+0x004041C,0x000001FF

#define SRM_CSI1_CPD_GRC_3__ADDR                                IPU_MEMORY_OFFSET+0x0040420
#define SRM_CSI1_CPD_GRC_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040420,0x00000000
#define SRM_CSI1_CPD_GRC_3__FULL                                IPU_MEMORY_OFFSET+0x0040420,0xffffffff
#define SRM_CSI1_CPD_GRC_3__CSI1_CPD_GRC7                       IPU_MEMORY_OFFSET+0x0040420,0x01FF0000
#define SRM_CSI1_CPD_GRC_3__CSI1_CPD_GRC6                       IPU_MEMORY_OFFSET+0x0040420,0x000001FF

#define SRM_CSI1_CPD_GRC_4__ADDR                                IPU_MEMORY_OFFSET+0x0040424
#define SRM_CSI1_CPD_GRC_4__EMPTY                               IPU_MEMORY_OFFSET+0x0040424,0x00000000
#define SRM_CSI1_CPD_GRC_4__FULL                                IPU_MEMORY_OFFSET+0x0040424,0xffffffff
#define SRM_CSI1_CPD_GRC_4__CSI1_CPD_GRC9                       IPU_MEMORY_OFFSET+0x0040424,0x01FF0000
#define SRM_CSI1_CPD_GRC_4__CSI1_CPD_GRC8                       IPU_MEMORY_OFFSET+0x0040424,0x000001FF

#define SRM_CSI1_CPD_GRC_5__ADDR                                IPU_MEMORY_OFFSET+0x0040428
#define SRM_CSI1_CPD_GRC_5__EMPTY                               IPU_MEMORY_OFFSET+0x0040428,0x00000000
#define SRM_CSI1_CPD_GRC_5__FULL                                IPU_MEMORY_OFFSET+0x0040428,0xffffffff
#define SRM_CSI1_CPD_GRC_5__CSI1_CPD_GRC11                      IPU_MEMORY_OFFSET+0x0040428,0x01FF0000
#define SRM_CSI1_CPD_GRC_5__CSI1_CPD_GRC10                      IPU_MEMORY_OFFSET+0x0040428,0x000001FF

#define SRM_CSI1_CPD_GRC_6__ADDR                                IPU_MEMORY_OFFSET+0x004042C
#define SRM_CSI1_CPD_GRC_6__EMPTY                               IPU_MEMORY_OFFSET+0x004042C,0x00000000
#define SRM_CSI1_CPD_GRC_6__FULL                                IPU_MEMORY_OFFSET+0x004042C,0xffffffff
#define SRM_CSI1_CPD_GRC_6__CSI1_CPD_GRC13                      IPU_MEMORY_OFFSET+0x004042C,0x01FF0000
#define SRM_CSI1_CPD_GRC_6__CSI1_CPD_GRC12                      IPU_MEMORY_OFFSET+0x004042C,0x000001FF

#define SRM_CSI1_CPD_GRC_7__ADDR                                IPU_MEMORY_OFFSET+0x0040430
#define SRM_CSI1_CPD_GRC_7__EMPTY                               IPU_MEMORY_OFFSET+0x0040430,0x00000000
#define SRM_CSI1_CPD_GRC_7__FULL                                IPU_MEMORY_OFFSET+0x0040430,0xffffffff
#define SRM_CSI1_CPD_GRC_7__CSI1_CPD_GRC15                      IPU_MEMORY_OFFSET+0x0040430,0x01FF0000
#define SRM_CSI1_CPD_GRC_7__CSI1_CPD_GRC14                      IPU_MEMORY_OFFSET+0x0040430,0x000001FF

#define SRM_CSI1_CPD_GRS_0__ADDR                                IPU_MEMORY_OFFSET+0x0040434
#define SRM_CSI1_CPD_GRS_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040434,0x00000000
#define SRM_CSI1_CPD_GRS_0__FULL                                IPU_MEMORY_OFFSET+0x0040434,0xffffffff
#define SRM_CSI1_CPD_GRS_0__CSI1_CPD_GRS3                       IPU_MEMORY_OFFSET+0x0040434,0xFF000000
#define SRM_CSI1_CPD_GRS_0__CSI1_CPD_GRS2                       IPU_MEMORY_OFFSET+0x0040434,0x00FF0000
#define SRM_CSI1_CPD_GRS_0__CSI1_CPD_GRS1                       IPU_MEMORY_OFFSET+0x0040434,0x0000FF00
#define SRM_CSI1_CPD_GRS_0__CSI1_CPD_GRS0                       IPU_MEMORY_OFFSET+0x0040434,0x000000FF

#define SRM_CSI1_CPD_GRS_1__ADDR                                IPU_MEMORY_OFFSET+0x0040438
#define SRM_CSI1_CPD_GRS_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040438,0x00000000
#define SRM_CSI1_CPD_GRS_1__FULL                                IPU_MEMORY_OFFSET+0x0040438,0xffffffff
#define SRM_CSI1_CPD_GRS_1__CSI1_CPD_GRS7                       IPU_MEMORY_OFFSET+0x0040438,0xFF000000
#define SRM_CSI1_CPD_GRS_1__CSI1_CPD_GRS6                       IPU_MEMORY_OFFSET+0x0040438,0x00FF0000
#define SRM_CSI1_CPD_GRS_1__CSI1_CPD_GRS5                       IPU_MEMORY_OFFSET+0x0040438,0x0000FF00
#define SRM_CSI1_CPD_GRS_1__CSI1_CPD_GRS4                       IPU_MEMORY_OFFSET+0x0040438,0x000000FF

#define SRM_CSI1_CPD_GRS_2__ADDR                                IPU_MEMORY_OFFSET+0x004043C
#define SRM_CSI1_CPD_GRS_2__EMPTY                               IPU_MEMORY_OFFSET+0x004043C,0x00000000
#define SRM_CSI1_CPD_GRS_2__FULL                                IPU_MEMORY_OFFSET+0x004043C,0xffffffff
#define SRM_CSI1_CPD_GRS_2__CSI1_CPD_GRS11                      IPU_MEMORY_OFFSET+0x004043C,0xFF000000
#define SRM_CSI1_CPD_GRS_2__CSI1_CPD_GRS10                      IPU_MEMORY_OFFSET+0x004043C,0x00FF0000
#define SRM_CSI1_CPD_GRS_2__CSI1_CPD_GRS9                       IPU_MEMORY_OFFSET+0x004043C,0x0000FF00
#define SRM_CSI1_CPD_GRS_2__CSI1_CPD_GRS8                       IPU_MEMORY_OFFSET+0x004043C,0x000000FF

#define SRM_CSI1_CPD_GRS_3__ADDR                                IPU_MEMORY_OFFSET+0x0040440
#define SRM_CSI1_CPD_GRS_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040440,0x00000000
#define SRM_CSI1_CPD_GRS_3__FULL                                IPU_MEMORY_OFFSET+0x0040440,0xffffffff
#define SRM_CSI1_CPD_GRS_3__CSI1_CPD_GRS15                      IPU_MEMORY_OFFSET+0x0040440,0xFF000000
#define SRM_CSI1_CPD_GRS_3__CSI1_CPD_GRS14                      IPU_MEMORY_OFFSET+0x0040440,0x00FF0000
#define SRM_CSI1_CPD_GRS_3__CSI1_CPD_GRS13                      IPU_MEMORY_OFFSET+0x0040440,0x0000FF00
#define SRM_CSI1_CPD_GRS_3__CSI1_CPD_GRS12                      IPU_MEMORY_OFFSET+0x0040440,0x000000FF

#define SRM_CSI1_CPD_GBC_0__ADDR                                IPU_MEMORY_OFFSET+0x0040444
#define SRM_CSI1_CPD_GBC_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040444,0x00000000
#define SRM_CSI1_CPD_GBC_0__FULL                                IPU_MEMORY_OFFSET+0x0040444,0xffffffff
#define SRM_CSI1_CPD_GBC_0__CSI1_CPD_GBC1                       IPU_MEMORY_OFFSET+0x0040444,0x01FF0000
#define SRM_CSI1_CPD_GBC_0__CSI1_CPD_GBC0                       IPU_MEMORY_OFFSET+0x0040444,0x000001FF

#define SRM_CSI1_CPD_GBC_1__ADDR                                IPU_MEMORY_OFFSET+0x0040448
#define SRM_CSI1_CPD_GBC_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040448,0x00000000
#define SRM_CSI1_CPD_GBC_1__FULL                                IPU_MEMORY_OFFSET+0x0040448,0xffffffff
#define SRM_CSI1_CPD_GBC_1__CSI1_CPD_GBC3                       IPU_MEMORY_OFFSET+0x0040448,0x01FF0000
#define SRM_CSI1_CPD_GBC_1__CSI1_CPD_GBC2                       IPU_MEMORY_OFFSET+0x0040448,0x000001FF

#define SRM_CSI1_CPD_GBC_2__ADDR                                IPU_MEMORY_OFFSET+0x004044C
#define SRM_CSI1_CPD_GBC_2__EMPTY                               IPU_MEMORY_OFFSET+0x004044C,0x00000000
#define SRM_CSI1_CPD_GBC_2__FULL                                IPU_MEMORY_OFFSET+0x004044C,0xffffffff
#define SRM_CSI1_CPD_GBC_2__CSI1_CPD_GBC5                       IPU_MEMORY_OFFSET+0x004044C,0x01FF0000
#define SRM_CSI1_CPD_GBC_2__CSI1_CPD_GBC4                       IPU_MEMORY_OFFSET+0x004044C,0x000001FF

#define SRM_CSI1_CPD_GBC_3__ADDR                                IPU_MEMORY_OFFSET+0x0040450
#define SRM_CSI1_CPD_GBC_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040450,0x00000000
#define SRM_CSI1_CPD_GBC_3__FULL                                IPU_MEMORY_OFFSET+0x0040450,0xffffffff
#define SRM_CSI1_CPD_GBC_3__CSI1_CPD_GBC7                       IPU_MEMORY_OFFSET+0x0040450,0x01FF0000
#define SRM_CSI1_CPD_GBC_3__CSI1_CPD_GBC6                       IPU_MEMORY_OFFSET+0x0040450,0x000001FF

#define SRM_CSI1_CPD_GBC_4__ADDR                                IPU_MEMORY_OFFSET+0x0040454
#define SRM_CSI1_CPD_GBC_4__EMPTY                               IPU_MEMORY_OFFSET+0x0040454,0x00000000
#define SRM_CSI1_CPD_GBC_4__FULL                                IPU_MEMORY_OFFSET+0x0040454,0xffffffff
#define SRM_CSI1_CPD_GBC_4__CSI1_CPD_GBC9                       IPU_MEMORY_OFFSET+0x0040454,0x01FF0000
#define SRM_CSI1_CPD_GBC_4__CSI1_CPD_GBC8                       IPU_MEMORY_OFFSET+0x0040454,0x000001FF

#define SRM_CSI1_CPD_GBC_5__ADDR                                IPU_MEMORY_OFFSET+0x0040458
#define SRM_CSI1_CPD_GBC_5__EMPTY                               IPU_MEMORY_OFFSET+0x0040458,0x00000000
#define SRM_CSI1_CPD_GBC_5__FULL                                IPU_MEMORY_OFFSET+0x0040458,0xffffffff
#define SRM_CSI1_CPD_GBC_5__CSI1_CPD_GBC11                      IPU_MEMORY_OFFSET+0x0040458,0x01FF0000
#define SRM_CSI1_CPD_GBC_5__CSI1_CPD_GBC10                      IPU_MEMORY_OFFSET+0x0040458,0x000001FF

#define SRM_CSI1_CPD_GBC_6__ADDR                                IPU_MEMORY_OFFSET+0x004045C
#define SRM_CSI1_CPD_GBC_6__EMPTY                               IPU_MEMORY_OFFSET+0x004045C,0x00000000
#define SRM_CSI1_CPD_GBC_6__FULL                                IPU_MEMORY_OFFSET+0x004045C,0xffffffff
#define SRM_CSI1_CPD_GBC_6__CSI1_CPD_GBC13                      IPU_MEMORY_OFFSET+0x004045C,0x01FF0000
#define SRM_CSI1_CPD_GBC_6__CSI1_CPD_GBC12                      IPU_MEMORY_OFFSET+0x004045C,0x000001FF

#define SRM_CSI1_CPD_GBC_7__ADDR                                IPU_MEMORY_OFFSET+0x0040460
#define SRM_CSI1_CPD_GBC_7__EMPTY                               IPU_MEMORY_OFFSET+0x0040460,0x00000000
#define SRM_CSI1_CPD_GBC_7__FULL                                IPU_MEMORY_OFFSET+0x0040460,0xffffffff
#define SRM_CSI1_CPD_GBC_7__CSI1_CPD_GBC15                      IPU_MEMORY_OFFSET+0x0040460,0x01FF0000
#define SRM_CSI1_CPD_GBC_7__CSI1_CPD_GBC14                      IPU_MEMORY_OFFSET+0x0040460,0x000001FF

#define SRM_CSI1_CPD_GBS_0__ADDR                                IPU_MEMORY_OFFSET+0x0040464
#define SRM_CSI1_CPD_GBS_0__EMPTY                               IPU_MEMORY_OFFSET+0x0040464,0x00000000
#define SRM_CSI1_CPD_GBS_0__FULL                                IPU_MEMORY_OFFSET+0x0040464,0xffffffff
#define SRM_CSI1_CPD_GBS_0__CSI1_CPD_GBS3                       IPU_MEMORY_OFFSET+0x0040464,0xFF000000
#define SRM_CSI1_CPD_GBS_0__CSI1_CPD_GBS2                       IPU_MEMORY_OFFSET+0x0040464,0x00FF0000
#define SRM_CSI1_CPD_GBS_0__CSI1_CPD_GBS1                       IPU_MEMORY_OFFSET+0x0040464,0x0000FF00
#define SRM_CSI1_CPD_GBS_0__CSI1_CPD_GBS0                       IPU_MEMORY_OFFSET+0x0040464,0x000000FF

#define SRM_CSI1_CPD_GBS_1__ADDR                                IPU_MEMORY_OFFSET+0x0040468
#define SRM_CSI1_CPD_GBS_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040468,0x00000000
#define SRM_CSI1_CPD_GBS_1__FULL                                IPU_MEMORY_OFFSET+0x0040468,0xffffffff
#define SRM_CSI1_CPD_GBS_1__CSI1_CPD_GBS7                       IPU_MEMORY_OFFSET+0x0040468,0xFF000000
#define SRM_CSI1_CPD_GBS_1__CSI1_CPD_GBS6                       IPU_MEMORY_OFFSET+0x0040468,0x00FF0000
#define SRM_CSI1_CPD_GBS_1__CSI1_CPD_GBS5                       IPU_MEMORY_OFFSET+0x0040468,0x0000FF00
#define SRM_CSI1_CPD_GBS_1__CSI1_CPD_GBS4                       IPU_MEMORY_OFFSET+0x0040468,0x000000FF

#define SRM_CSI1_CPD_GBS_2__ADDR                                IPU_MEMORY_OFFSET+0x004046C
#define SRM_CSI1_CPD_GBS_2__EMPTY                               IPU_MEMORY_OFFSET+0x004046C,0x00000000
#define SRM_CSI1_CPD_GBS_2__FULL                                IPU_MEMORY_OFFSET+0x004046C,0xffffffff
#define SRM_CSI1_CPD_GBS_2__CSI1_CPD_GBS11                      IPU_MEMORY_OFFSET+0x004046C,0xFF000000
#define SRM_CSI1_CPD_GBS_2__CSI1_CPD_GBS10                      IPU_MEMORY_OFFSET+0x004046C,0x00FF0000
#define SRM_CSI1_CPD_GBS_2__CSI1_CPD_GBS9                       IPU_MEMORY_OFFSET+0x004046C,0x0000FF00
#define SRM_CSI1_CPD_GBS_2__CSI1_CPD_GBS8                       IPU_MEMORY_OFFSET+0x004046C,0x000000FF

#define SRM_CSI1_CPD_GBS_3__ADDR                                IPU_MEMORY_OFFSET+0x0040470
#define SRM_CSI1_CPD_GBS_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040470,0x00000000
#define SRM_CSI1_CPD_GBS_3__FULL                                IPU_MEMORY_OFFSET+0x0040470,0xffffffff
#define SRM_CSI1_CPD_GBS_3__CSI1_CPD_GBS15                      IPU_MEMORY_OFFSET+0x0040470,0xFF000000
#define SRM_CSI1_CPD_GBS_3__CSI1_CPD_GBS14                      IPU_MEMORY_OFFSET+0x0040470,0x00FF0000
#define SRM_CSI1_CPD_GBS_3__CSI1_CPD_GBS13                      IPU_MEMORY_OFFSET+0x0040470,0x0000FF00
#define SRM_CSI1_CPD_GBS_3__CSI1_CPD_GBS12                      IPU_MEMORY_OFFSET+0x0040470,0x000000FF

#define SRM_CSI1_CPD_BC_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040474
#define SRM_CSI1_CPD_BC_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040474,0x00000000
#define SRM_CSI1_CPD_BC_0__FULL                                 IPU_MEMORY_OFFSET+0x0040474,0xffffffff
#define SRM_CSI1_CPD_BC_0__CSI1_CPD_BC1                         IPU_MEMORY_OFFSET+0x0040474,0x01FF0000
#define SRM_CSI1_CPD_BC_0__CSI1_CPD_BC0                         IPU_MEMORY_OFFSET+0x0040474,0x000001FF

#define SRM_CSI1_CPD_BC_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040478
#define SRM_CSI1_CPD_BC_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040478,0x00000000
#define SRM_CSI1_CPD_BC_1__FULL                                 IPU_MEMORY_OFFSET+0x0040478,0xffffffff
#define SRM_CSI1_CPD_BC_1__CSI1_CPD_BC3                         IPU_MEMORY_OFFSET+0x0040478,0x01FF0000
#define SRM_CSI1_CPD_BC_1__CSI1_CPD_BC2                         IPU_MEMORY_OFFSET+0x0040478,0x000001FF

#define SRM_CSI1_CPD_BC_2__ADDR                                 IPU_MEMORY_OFFSET+0x004047C
#define SRM_CSI1_CPD_BC_2__EMPTY                                IPU_MEMORY_OFFSET+0x004047C,0x00000000
#define SRM_CSI1_CPD_BC_2__FULL                                 IPU_MEMORY_OFFSET+0x004047C,0xffffffff
#define SRM_CSI1_CPD_BC_2__CSI1_CPD_BC5                         IPU_MEMORY_OFFSET+0x004047C,0x01FF0000
#define SRM_CSI1_CPD_BC_2__CSI1_CPD_BC4                         IPU_MEMORY_OFFSET+0x004047C,0x000001FF

#define SRM_CSI1_CPD_BC_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040480
#define SRM_CSI1_CPD_BC_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040480,0x00000000
#define SRM_CSI1_CPD_BC_3__FULL                                 IPU_MEMORY_OFFSET+0x0040480,0xffffffff
#define SRM_CSI1_CPD_BC_3__CSI1_CPD_BC7                         IPU_MEMORY_OFFSET+0x0040480,0x01FF0000
#define SRM_CSI1_CPD_BC_3__CSI1_CPD_BC6                         IPU_MEMORY_OFFSET+0x0040480,0x000001FF

#define SRM_CSI1_CPD_BC_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040484
#define SRM_CSI1_CPD_BC_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040484,0x00000000
#define SRM_CSI1_CPD_BC_4__FULL                                 IPU_MEMORY_OFFSET+0x0040484,0xffffffff
#define SRM_CSI1_CPD_BC_4__CSI1_CPD_BC9                         IPU_MEMORY_OFFSET+0x0040484,0x01FF0000
#define SRM_CSI1_CPD_BC_4__CSI1_CPD_BC8                         IPU_MEMORY_OFFSET+0x0040484,0x000001FF

#define SRM_CSI1_CPD_BC_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040488
#define SRM_CSI1_CPD_BC_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040488,0x00000000
#define SRM_CSI1_CPD_BC_5__FULL                                 IPU_MEMORY_OFFSET+0x0040488,0xffffffff
#define SRM_CSI1_CPD_BC_5__CSI1_CPD_BC11                        IPU_MEMORY_OFFSET+0x0040488,0x01FF0000
#define SRM_CSI1_CPD_BC_5__CSI1_CPD_BC10                        IPU_MEMORY_OFFSET+0x0040488,0x000001FF

#define SRM_CSI1_CPD_BC_6__ADDR                                 IPU_MEMORY_OFFSET+0x004048C
#define SRM_CSI1_CPD_BC_6__EMPTY                                IPU_MEMORY_OFFSET+0x004048C,0x00000000
#define SRM_CSI1_CPD_BC_6__FULL                                 IPU_MEMORY_OFFSET+0x004048C,0xffffffff
#define SRM_CSI1_CPD_BC_6__CSI1_CPD_BC13                        IPU_MEMORY_OFFSET+0x004048C,0x01FF0000
#define SRM_CSI1_CPD_BC_6__CSI1_CPD_BC12                        IPU_MEMORY_OFFSET+0x004048C,0x000001FF

#define SRM_CSI1_CPD_BC_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040490
#define SRM_CSI1_CPD_BC_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040490,0x00000000
#define SRM_CSI1_CPD_BC_7__FULL                                 IPU_MEMORY_OFFSET+0x0040490,0xffffffff
#define SRM_CSI1_CPD_BC_7__CSI1_CPD_BC15                        IPU_MEMORY_OFFSET+0x0040490,0x01FF0000
#define SRM_CSI1_CPD_BC_7__CSI1_CPD_BC14                        IPU_MEMORY_OFFSET+0x0040490,0x000001FF

#define SRM_CSI1_CPD_BS_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040494
#define SRM_CSI1_CPD_BS_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040494,0x00000000
#define SRM_CSI1_CPD_BS_0__FULL                                 IPU_MEMORY_OFFSET+0x0040494,0xffffffff
#define SRM_CSI1_CPD_BS_0__CSI1_CPD_BS3                         IPU_MEMORY_OFFSET+0x0040494,0xFF000000
#define SRM_CSI1_CPD_BS_0__CSI1_CPD_BS2                         IPU_MEMORY_OFFSET+0x0040494,0x00FF0000
#define SRM_CSI1_CPD_BS_0__CSI1_CPD_BS1                         IPU_MEMORY_OFFSET+0x0040494,0x0000FF00
#define SRM_CSI1_CPD_BS_0__CSI1_CPD_BS0                         IPU_MEMORY_OFFSET+0x0040494,0x000000FF

#define SRM_CSI1_CPD_BS_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040498
#define SRM_CSI1_CPD_BS_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040498,0x00000000
#define SRM_CSI1_CPD_BS_1__FULL                                 IPU_MEMORY_OFFSET+0x0040498,0xffffffff
#define SRM_CSI1_CPD_BS_1__CSI1_CPD_BS7                         IPU_MEMORY_OFFSET+0x0040498,0xFF000000
#define SRM_CSI1_CPD_BS_1__CSI1_CPD_BS6                         IPU_MEMORY_OFFSET+0x0040498,0x00FF0000
#define SRM_CSI1_CPD_BS_1__CSI1_CPD_BS5                         IPU_MEMORY_OFFSET+0x0040498,0x0000FF00
#define SRM_CSI1_CPD_BS_1__CSI1_CPD_BS4                         IPU_MEMORY_OFFSET+0x0040498,0x000000FF

#define SRM_CSI1_CPD_BS_2__ADDR                                 IPU_MEMORY_OFFSET+0x004049C
#define SRM_CSI1_CPD_BS_2__EMPTY                                IPU_MEMORY_OFFSET+0x004049C,0x00000000
#define SRM_CSI1_CPD_BS_2__FULL                                 IPU_MEMORY_OFFSET+0x004049C,0xffffffff
#define SRM_CSI1_CPD_BS_2__CSI1_CPD_BS11                        IPU_MEMORY_OFFSET+0x004049C,0xFF000000
#define SRM_CSI1_CPD_BS_2__CSI1_CPD_BS10                        IPU_MEMORY_OFFSET+0x004049C,0x00FF0000
#define SRM_CSI1_CPD_BS_2__CSI1_CPD_BS9                         IPU_MEMORY_OFFSET+0x004049C,0x0000FF00
#define SRM_CSI1_CPD_BS_2__CSI1_CPD_BS8                         IPU_MEMORY_OFFSET+0x004049C,0x000000FF

#define SRM_CSI1_CPD_BS_3__ADDR                                 IPU_MEMORY_OFFSET+0x00404A0
#define SRM_CSI1_CPD_BS_3__EMPTY                                IPU_MEMORY_OFFSET+0x00404A0,0x00000000
#define SRM_CSI1_CPD_BS_3__FULL                                 IPU_MEMORY_OFFSET+0x00404A0,0xffffffff
#define SRM_CSI1_CPD_BS_3__CSI1_CPD_BS15                        IPU_MEMORY_OFFSET+0x00404A0,0xFF000000
#define SRM_CSI1_CPD_BS_3__CSI1_CPD_BS14                        IPU_MEMORY_OFFSET+0x00404A0,0x00FF0000
#define SRM_CSI1_CPD_BS_3__CSI1_CPD_BS13                        IPU_MEMORY_OFFSET+0x00404A0,0x0000FF00
#define SRM_CSI1_CPD_BS_3__CSI1_CPD_BS12                        IPU_MEMORY_OFFSET+0x00404A0,0x000000FF

#define SRM_CSI1_CPD_OFFSET1__ADDR                              IPU_MEMORY_OFFSET+0x00404A4
#define SRM_CSI1_CPD_OFFSET1__EMPTY                             IPU_MEMORY_OFFSET+0x00404A4,0x00000000
#define SRM_CSI1_CPD_OFFSET1__FULL                              IPU_MEMORY_OFFSET+0x00404A4,0xffffffff
#define SRM_CSI1_CPD_OFFSET1__CSI1_CPD_B_OFFSET                 IPU_MEMORY_OFFSET+0x00404A4,0x3FF00000
#define SRM_CSI1_CPD_OFFSET1__CSI1_CPD_GB_OFFSET                IPU_MEMORY_OFFSET+0x00404A4,0x000FFC00
#define SRM_CSI1_CPD_OFFSET1__CSI1_CPD_GR_OFFSET                IPU_MEMORY_OFFSET+0x00404A4,0x000003FF

#define SRM_CSI1_CPD_OFFSET2__ADDR                              IPU_MEMORY_OFFSET+0x00404A8
#define SRM_CSI1_CPD_OFFSET2__EMPTY                             IPU_MEMORY_OFFSET+0x00404A8,0x00000000
#define SRM_CSI1_CPD_OFFSET2__FULL                              IPU_MEMORY_OFFSET+0x00404A8,0xffffffff
#define SRM_CSI1_CPD_OFFSET2__CSI1_CPD_R_OFFSET                 IPU_MEMORY_OFFSET+0x00404A8,0x000003FF

#define SRM_DI0_GENERAL__ADDR                                   IPU_MEMORY_OFFSET+0x00404E4
#define SRM_DI0_GENERAL__EMPTY                                  IPU_MEMORY_OFFSET+0x00404E4,0x00000000
#define SRM_DI0_GENERAL__FULL                                   IPU_MEMORY_OFFSET+0x00404E4,0xffffffff
#define SRM_DI0_GENERAL__DI0_PIN8_PIN15_SEL                     IPU_MEMORY_OFFSET+0x00404E4,0x80000000
#define SRM_DI0_GENERAL__DI0_DISP_Y_SEL                         IPU_MEMORY_OFFSET+0x00404E4,0x70000000
#define SRM_DI0_GENERAL__DI0_CLOCK_STOP_MODE                    IPU_MEMORY_OFFSET+0x00404E4,0x0F000000
#define SRM_DI0_GENERAL__DI0_DISP_CLOCK_INIT                    IPU_MEMORY_OFFSET+0x00404E4,0x00800000
#define SRM_DI0_GENERAL__DI0_MASK_SEL                           IPU_MEMORY_OFFSET+0x00404E4,0x00400000
#define SRM_DI0_GENERAL__DI0_VSYNC_EXT                          IPU_MEMORY_OFFSET+0x00404E4,0x00200000
#define SRM_DI0_GENERAL__DI0_CLK_EXT                            IPU_MEMORY_OFFSET+0x00404E4,0x00100000
#define SRM_DI0_GENERAL__DI0_WATCHDOG_MODE                      IPU_MEMORY_OFFSET+0x00404E4,0x000C0000
#define SRM_DI0_GENERAL__DI0_POLARITY_DISP_CLK                  IPU_MEMORY_OFFSET+0x00404E4,0x00020000
#define SRM_DI0_GENERAL__DI0_SYNC_COUNT_SEL                     IPU_MEMORY_OFFSET+0x00404E4,0x0000F000
#define SRM_DI0_GENERAL__DI0_ERR_TREATMENT                      IPU_MEMORY_OFFSET+0x00404E4,0x00000800
#define SRM_DI0_GENERAL__DI0_ERM_VSYNC_SEL                      IPU_MEMORY_OFFSET+0x00404E4,0x00000400
#define SRM_DI0_GENERAL__DI0_POLARITY_CS1                       IPU_MEMORY_OFFSET+0x00404E4,0x00000200
#define SRM_DI0_GENERAL__DI0_POLARITY_CS0                       IPU_MEMORY_OFFSET+0x00404E4,0x00000100
#define SRM_DI0_GENERAL__DI0_POLARITY_8                         IPU_MEMORY_OFFSET+0x00404E4,0x00000080
#define SRM_DI0_GENERAL__DI0_POLARITY_7                         IPU_MEMORY_OFFSET+0x00404E4,0x00000040
#define SRM_DI0_GENERAL__DI0_POLARITY_6                         IPU_MEMORY_OFFSET+0x00404E4,0x00000020
#define SRM_DI0_GENERAL__DI0_POLARITY_5                         IPU_MEMORY_OFFSET+0x00404E4,0x00000010
#define SRM_DI0_GENERAL__DI0_POLARITY_4                         IPU_MEMORY_OFFSET+0x00404E4,0x00000008
#define SRM_DI0_GENERAL__DI0_POLARITY_3                         IPU_MEMORY_OFFSET+0x00404E4,0x00000004
#define SRM_DI0_GENERAL__DI0_POLARITY_2                         IPU_MEMORY_OFFSET+0x00404E4,0x00000002
#define SRM_DI0_GENERAL__DI0_POLARITY_1                         IPU_MEMORY_OFFSET+0x00404E4,0x00000001

#define SRM_DI0_BS_CLKGEN0__ADDR                                IPU_MEMORY_OFFSET+0x00404E8
#define SRM_DI0_BS_CLKGEN0__EMPTY                               IPU_MEMORY_OFFSET+0x00404E8,0x00000000
#define SRM_DI0_BS_CLKGEN0__FULL                                IPU_MEMORY_OFFSET+0x00404E8,0xffffffff
#define SRM_DI0_BS_CLKGEN0__DI0_DISP_CLK_OFFSET                 IPU_MEMORY_OFFSET+0x00404E8,0x01FF0000
#define SRM_DI0_BS_CLKGEN0__DI0_DISP_CLK_PERIOD                 IPU_MEMORY_OFFSET+0x00404E8,0x00000FFF

#define SRM_DI0_BS_CLKGEN1__ADDR                                IPU_MEMORY_OFFSET+0x00404EC
#define SRM_DI0_BS_CLKGEN1__EMPTY                               IPU_MEMORY_OFFSET+0x00404EC,0x00000000
#define SRM_DI0_BS_CLKGEN1__FULL                                IPU_MEMORY_OFFSET+0x00404EC,0xffffffff
#define SRM_DI0_BS_CLKGEN1__DI0_DISP_CLK_DOWN                   IPU_MEMORY_OFFSET+0x00404EC,0x01FF0000
#define SRM_DI0_BS_CLKGEN1__DI0_DISP_CLK_UP                     IPU_MEMORY_OFFSET+0x00404EC,0x000001FF

#define SRM_DI0_SW_GEN0_1__ADDR                                 IPU_MEMORY_OFFSET+0x00404F0
#define SRM_DI0_SW_GEN0_1__EMPTY                                IPU_MEMORY_OFFSET+0x00404F0,0x00000000
#define SRM_DI0_SW_GEN0_1__FULL                                 IPU_MEMORY_OFFSET+0x00404F0,0xffffffff
#define SRM_DI0_SW_GEN0_1__DI0_RUN_VALUE_M1_1                   IPU_MEMORY_OFFSET+0x00404F0,0x7FF80000
#define SRM_DI0_SW_GEN0_1__DI0_RUN_RESOLUTION_1                 IPU_MEMORY_OFFSET+0x00404F0,0x00070000
#define SRM_DI0_SW_GEN0_1__DI0_OFFSET_VALUE_1                   IPU_MEMORY_OFFSET+0x00404F0,0x00007FF8
#define SRM_DI0_SW_GEN0_1__DI0_OFFSET_RESOLUTION_1              IPU_MEMORY_OFFSET+0x00404F0,0x00000007

#define SRM_DI0_SW_GEN0_2__ADDR                                 IPU_MEMORY_OFFSET+0x00404F4
#define SRM_DI0_SW_GEN0_2__EMPTY                                IPU_MEMORY_OFFSET+0x00404F4,0x00000000
#define SRM_DI0_SW_GEN0_2__FULL                                 IPU_MEMORY_OFFSET+0x00404F4,0xffffffff
#define SRM_DI0_SW_GEN0_2__DI0_RUN_VALUE_M1_2                   IPU_MEMORY_OFFSET+0x00404F4,0x7FF80000
#define SRM_DI0_SW_GEN0_2__DI0_RUN_RESOLUTION_2                 IPU_MEMORY_OFFSET+0x00404F4,0x00070000
#define SRM_DI0_SW_GEN0_2__DI0_OFFSET_VALUE_2                   IPU_MEMORY_OFFSET+0x00404F4,0x00007FF8
#define SRM_DI0_SW_GEN0_2__DI0_OFFSET_RESOLUTION_2              IPU_MEMORY_OFFSET+0x00404F4,0x00000007

#define SRM_DI0_SW_GEN0_3__ADDR                                 IPU_MEMORY_OFFSET+0x00404F8
#define SRM_DI0_SW_GEN0_3__EMPTY                                IPU_MEMORY_OFFSET+0x00404F8,0x00000000
#define SRM_DI0_SW_GEN0_3__FULL                                 IPU_MEMORY_OFFSET+0x00404F8,0xffffffff
#define SRM_DI0_SW_GEN0_3__DI0_RUN_VALUE_M1_3                   IPU_MEMORY_OFFSET+0x00404F8,0x7FF80000
#define SRM_DI0_SW_GEN0_3__DI0_RUN_RESOLUTION_3                 IPU_MEMORY_OFFSET+0x00404F8,0x00070000
#define SRM_DI0_SW_GEN0_3__DI0_OFFSET_VALUE_3                   IPU_MEMORY_OFFSET+0x00404F8,0x00007FF8
#define SRM_DI0_SW_GEN0_3__DI0_OFFSET_RESOLUTION_3              IPU_MEMORY_OFFSET+0x00404F8,0x00000007

#define SRM_DI0_SW_GEN0_4__ADDR                                 IPU_MEMORY_OFFSET+0x00404FC
#define SRM_DI0_SW_GEN0_4__EMPTY                                IPU_MEMORY_OFFSET+0x00404FC,0x00000000
#define SRM_DI0_SW_GEN0_4__FULL                                 IPU_MEMORY_OFFSET+0x00404FC,0xffffffff
#define SRM_DI0_SW_GEN0_4__DI0_RUN_VALUE_M1_4                   IPU_MEMORY_OFFSET+0x00404FC,0x7FF80000
#define SRM_DI0_SW_GEN0_4__DI0_RUN_RESOLUTION_4                 IPU_MEMORY_OFFSET+0x00404FC,0x00070000
#define SRM_DI0_SW_GEN0_4__DI0_OFFSET_VALUE_4                   IPU_MEMORY_OFFSET+0x00404FC,0x00007FF8
#define SRM_DI0_SW_GEN0_4__DI0_OFFSET_RESOLUTION_4              IPU_MEMORY_OFFSET+0x00404FC,0x00000007

#define SRM_DI0_SW_GEN0_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040500
#define SRM_DI0_SW_GEN0_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040500,0x00000000
#define SRM_DI0_SW_GEN0_5__FULL                                 IPU_MEMORY_OFFSET+0x0040500,0xffffffff
#define SRM_DI0_SW_GEN0_5__DI0_RUN_VALUE_M1_5                   IPU_MEMORY_OFFSET+0x0040500,0x7FF80000
#define SRM_DI0_SW_GEN0_5__DI0_RUN_RESOLUTION_5                 IPU_MEMORY_OFFSET+0x0040500,0x00070000
#define SRM_DI0_SW_GEN0_5__DI0_OFFSET_VALUE_5                   IPU_MEMORY_OFFSET+0x0040500,0x00007FF8
#define SRM_DI0_SW_GEN0_5__DI0_OFFSET_RESOLUTION_5              IPU_MEMORY_OFFSET+0x0040500,0x00000007

#define SRM_DI0_SW_GEN0_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040504
#define SRM_DI0_SW_GEN0_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040504,0x00000000
#define SRM_DI0_SW_GEN0_6__FULL                                 IPU_MEMORY_OFFSET+0x0040504,0xffffffff
#define SRM_DI0_SW_GEN0_6__DI0_RUN_VALUE_M1_6                   IPU_MEMORY_OFFSET+0x0040504,0x7FF80000
#define SRM_DI0_SW_GEN0_6__DI0_RUN_RESOLUTION_6                 IPU_MEMORY_OFFSET+0x0040504,0x00070000
#define SRM_DI0_SW_GEN0_6__DI0_OFFSET_VALUE_6                   IPU_MEMORY_OFFSET+0x0040504,0x00007FF8
#define SRM_DI0_SW_GEN0_6__DI0_OFFSET_RESOLUTION_6              IPU_MEMORY_OFFSET+0x0040504,0x00000007

#define SRM_DI0_SW_GEN0_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040508
#define SRM_DI0_SW_GEN0_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040508,0x00000000
#define SRM_DI0_SW_GEN0_7__FULL                                 IPU_MEMORY_OFFSET+0x0040508,0xffffffff
#define SRM_DI0_SW_GEN0_7__DI0_RUN_VALUE_M1_7                   IPU_MEMORY_OFFSET+0x0040508,0x7FF80000
#define SRM_DI0_SW_GEN0_7__DI0_RUN_RESOLUTION_7                 IPU_MEMORY_OFFSET+0x0040508,0x00070000
#define SRM_DI0_SW_GEN0_7__DI0_OFFSET_VALUE_7                   IPU_MEMORY_OFFSET+0x0040508,0x00007FF8
#define SRM_DI0_SW_GEN0_7__DI0_OFFSET_RESOLUTION_7              IPU_MEMORY_OFFSET+0x0040508,0x00000007

#define SRM_DI0_SW_GEN0_8__ADDR                                 IPU_MEMORY_OFFSET+0x004050C
#define SRM_DI0_SW_GEN0_8__EMPTY                                IPU_MEMORY_OFFSET+0x004050C,0x00000000
#define SRM_DI0_SW_GEN0_8__FULL                                 IPU_MEMORY_OFFSET+0x004050C,0xffffffff
#define SRM_DI0_SW_GEN0_8__DI0_RUN_VALUE_M1_8                   IPU_MEMORY_OFFSET+0x004050C,0x7FF80000
#define SRM_DI0_SW_GEN0_8__DI0_RUN_RESOLUTION_8                 IPU_MEMORY_OFFSET+0x004050C,0x00070000
#define SRM_DI0_SW_GEN0_8__DI0_OFFSET_VALUE_8                   IPU_MEMORY_OFFSET+0x004050C,0x00007FF8
#define SRM_DI0_SW_GEN0_8__DI0_OFFSET_RESOLUTION_8              IPU_MEMORY_OFFSET+0x004050C,0x00000007

#define SRM_DI0_SW_GEN0_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040510
#define SRM_DI0_SW_GEN0_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040510,0x00000000
#define SRM_DI0_SW_GEN0_9__FULL                                 IPU_MEMORY_OFFSET+0x0040510,0xffffffff
#define SRM_DI0_SW_GEN0_9__DI0_RUN_VALUE_M1_9                   IPU_MEMORY_OFFSET+0x0040510,0x7FF80000
#define SRM_DI0_SW_GEN0_9__DI0_RUN_RESOLUTION_9                 IPU_MEMORY_OFFSET+0x0040510,0x00070000
#define SRM_DI0_SW_GEN0_9__DI0_OFFSET_VALUE_9                   IPU_MEMORY_OFFSET+0x0040510,0x00007FF8
#define SRM_DI0_SW_GEN0_9__DI0_OFFSET_RESOLUTION_9              IPU_MEMORY_OFFSET+0x0040510,0x00000007

#define SRM_DI0_SW_GEN1_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040514
#define SRM_DI0_SW_GEN1_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040514,0x00000000
#define SRM_DI0_SW_GEN1_1__FULL                                 IPU_MEMORY_OFFSET+0x0040514,0xffffffff
#define SRM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_GEN_EN_1            IPU_MEMORY_OFFSET+0x0040514,0x60000000
#define SRM_DI0_SW_GEN1_1__DI0_CNT_AUTO_RELOAD_1                IPU_MEMORY_OFFSET+0x0040514,0x10000000
#define SRM_DI0_SW_GEN1_1__DI0_CNT_CLR_SEL_1                    IPU_MEMORY_OFFSET+0x0040514,0x0E000000
#define SRM_DI0_SW_GEN1_1__DI0_CNT_DOWN_1                       IPU_MEMORY_OFFSET+0x0040514,0x01FF0000
#define SRM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_TRIGGER_SEL_1       IPU_MEMORY_OFFSET+0x0040514,0x00007000
#define SRM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_CLR_SEL_1           IPU_MEMORY_OFFSET+0x0040514,0x00000E00
#define SRM_DI0_SW_GEN1_1__DI0_CNT_UP_1                         IPU_MEMORY_OFFSET+0x0040514,0x000001FF

#define SRM_DI0_SW_GEN1_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040518
#define SRM_DI0_SW_GEN1_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040518,0x00000000
#define SRM_DI0_SW_GEN1_2__FULL                                 IPU_MEMORY_OFFSET+0x0040518,0xffffffff
#define SRM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_GEN_EN_2            IPU_MEMORY_OFFSET+0x0040518,0x60000000
#define SRM_DI0_SW_GEN1_2__DI0_CNT_AUTO_RELOAD_2                IPU_MEMORY_OFFSET+0x0040518,0x10000000
#define SRM_DI0_SW_GEN1_2__DI0_CNT_CLR_SEL_2                    IPU_MEMORY_OFFSET+0x0040518,0x0E000000
#define SRM_DI0_SW_GEN1_2__DI0_CNT_DOWN_2                       IPU_MEMORY_OFFSET+0x0040518,0x01FF0000
#define SRM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_TRIGGER_SEL_2       IPU_MEMORY_OFFSET+0x0040518,0x00007000
#define SRM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_CLR_SEL_2           IPU_MEMORY_OFFSET+0x0040518,0x00000E00
#define SRM_DI0_SW_GEN1_2__DI0_CNT_UP_2                         IPU_MEMORY_OFFSET+0x0040518,0x000001FF

#define SRM_DI0_SW_GEN1_3__ADDR                                 IPU_MEMORY_OFFSET+0x004051C
#define SRM_DI0_SW_GEN1_3__EMPTY                                IPU_MEMORY_OFFSET+0x004051C,0x00000000
#define SRM_DI0_SW_GEN1_3__FULL                                 IPU_MEMORY_OFFSET+0x004051C,0xffffffff
#define SRM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_GEN_EN_3            IPU_MEMORY_OFFSET+0x004051C,0x60000000
#define SRM_DI0_SW_GEN1_3__DI0_CNT_AUTO_RELOAD_3                IPU_MEMORY_OFFSET+0x004051C,0x10000000
#define SRM_DI0_SW_GEN1_3__DI0_CNT_CLR_SEL_3                    IPU_MEMORY_OFFSET+0x004051C,0x0E000000
#define SRM_DI0_SW_GEN1_3__DI0_CNT_DOWN_3                       IPU_MEMORY_OFFSET+0x004051C,0x01FF0000
#define SRM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_TRIGGER_SEL_3       IPU_MEMORY_OFFSET+0x004051C,0x00007000
#define SRM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_CLR_SEL_3           IPU_MEMORY_OFFSET+0x004051C,0x00000E00
#define SRM_DI0_SW_GEN1_3__DI0_CNT_UP_3                         IPU_MEMORY_OFFSET+0x004051C,0x000001FF

#define SRM_DI0_SW_GEN1_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040520
#define SRM_DI0_SW_GEN1_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040520,0x00000000
#define SRM_DI0_SW_GEN1_4__FULL                                 IPU_MEMORY_OFFSET+0x0040520,0xffffffff
#define SRM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_GEN_EN_4            IPU_MEMORY_OFFSET+0x0040520,0x60000000
#define SRM_DI0_SW_GEN1_4__DI0_CNT_AUTO_RELOAD_4                IPU_MEMORY_OFFSET+0x0040520,0x10000000
#define SRM_DI0_SW_GEN1_4__DI0_CNT_CLR_SEL_4                    IPU_MEMORY_OFFSET+0x0040520,0x0E000000
#define SRM_DI0_SW_GEN1_4__DI0_CNT_DOWN_4                       IPU_MEMORY_OFFSET+0x0040520,0x01FF0000
#define SRM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_TRIGGER_SEL_4       IPU_MEMORY_OFFSET+0x0040520,0x00007000
#define SRM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_CLR_SEL_4           IPU_MEMORY_OFFSET+0x0040520,0x00000E00
#define SRM_DI0_SW_GEN1_4__DI0_CNT_UP_4                         IPU_MEMORY_OFFSET+0x0040520,0x000001FF

#define SRM_DI0_SW_GEN1_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040524
#define SRM_DI0_SW_GEN1_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040524,0x00000000
#define SRM_DI0_SW_GEN1_5__FULL                                 IPU_MEMORY_OFFSET+0x0040524,0xffffffff
#define SRM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_GEN_EN_5            IPU_MEMORY_OFFSET+0x0040524,0x60000000
#define SRM_DI0_SW_GEN1_5__DI0_CNT_AUTO_RELOAD_5                IPU_MEMORY_OFFSET+0x0040524,0x10000000
#define SRM_DI0_SW_GEN1_5__DI0_CNT_CLR_SEL_5                    IPU_MEMORY_OFFSET+0x0040524,0x0E000000
#define SRM_DI0_SW_GEN1_5__DI0_CNT_DOWN_5                       IPU_MEMORY_OFFSET+0x0040524,0x01FF0000
#define SRM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_TRIGGER_SEL_5       IPU_MEMORY_OFFSET+0x0040524,0x00007000
#define SRM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_CLR_SEL_5           IPU_MEMORY_OFFSET+0x0040524,0x00000E00
#define SRM_DI0_SW_GEN1_5__DI0_CNT_UP_5                         IPU_MEMORY_OFFSET+0x0040524,0x000001FF

#define SRM_DI0_SW_GEN1_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040528
#define SRM_DI0_SW_GEN1_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040528,0x00000000
#define SRM_DI0_SW_GEN1_6__FULL                                 IPU_MEMORY_OFFSET+0x0040528,0xffffffff
#define SRM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_GEN_EN_6            IPU_MEMORY_OFFSET+0x0040528,0x60000000
#define SRM_DI0_SW_GEN1_6__DI0_CNT_AUTO_RELOAD_6                IPU_MEMORY_OFFSET+0x0040528,0x10000000
#define SRM_DI0_SW_GEN1_6__DI0_CNT_CLR_SEL_6                    IPU_MEMORY_OFFSET+0x0040528,0x0E000000
#define SRM_DI0_SW_GEN1_6__DI0_CNT_DOWN_6                       IPU_MEMORY_OFFSET+0x0040528,0x01FF0000
#define SRM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_TRIGGER_SEL_6       IPU_MEMORY_OFFSET+0x0040528,0x00007000
#define SRM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_CLR_SEL_6           IPU_MEMORY_OFFSET+0x0040528,0x00000E00
#define SRM_DI0_SW_GEN1_6__DI0_CNT_UP_6                         IPU_MEMORY_OFFSET+0x0040528,0x000001FF

#define SRM_DI0_SW_GEN1_7__ADDR                                 IPU_MEMORY_OFFSET+0x004052C
#define SRM_DI0_SW_GEN1_7__EMPTY                                IPU_MEMORY_OFFSET+0x004052C,0x00000000
#define SRM_DI0_SW_GEN1_7__FULL                                 IPU_MEMORY_OFFSET+0x004052C,0xffffffff
#define SRM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_GEN_EN_7            IPU_MEMORY_OFFSET+0x004052C,0x60000000
#define SRM_DI0_SW_GEN1_7__DI0_CNT_AUTO_RELOAD_7                IPU_MEMORY_OFFSET+0x004052C,0x10000000
#define SRM_DI0_SW_GEN1_7__DI0_CNT_CLR_SEL_7                    IPU_MEMORY_OFFSET+0x004052C,0x0E000000
#define SRM_DI0_SW_GEN1_7__DI0_CNT_DOWN_7                       IPU_MEMORY_OFFSET+0x004052C,0x01FF0000
#define SRM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_TRIGGER_SEL_7       IPU_MEMORY_OFFSET+0x004052C,0x00007000
#define SRM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_CLR_SEL_7           IPU_MEMORY_OFFSET+0x004052C,0x00000E00
#define SRM_DI0_SW_GEN1_7__DI0_CNT_UP_7                         IPU_MEMORY_OFFSET+0x004052C,0x000001FF

#define SRM_DI0_SW_GEN1_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040530
#define SRM_DI0_SW_GEN1_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040530,0x00000000
#define SRM_DI0_SW_GEN1_8__FULL                                 IPU_MEMORY_OFFSET+0x0040530,0xffffffff
#define SRM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_GEN_EN_8            IPU_MEMORY_OFFSET+0x0040530,0x60000000
#define SRM_DI0_SW_GEN1_8__DI0_CNT_AUTO_RELOAD_8                IPU_MEMORY_OFFSET+0x0040530,0x10000000
#define SRM_DI0_SW_GEN1_8__DI0_CNT_CLR_SEL_8                    IPU_MEMORY_OFFSET+0x0040530,0x0E000000
#define SRM_DI0_SW_GEN1_8__DI0_CNT_DOWN_8                       IPU_MEMORY_OFFSET+0x0040530,0x01FF0000
#define SRM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_TRIGGER_SEL_8       IPU_MEMORY_OFFSET+0x0040530,0x00007000
#define SRM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_CLR_SEL_8           IPU_MEMORY_OFFSET+0x0040530,0x00000E00
#define SRM_DI0_SW_GEN1_8__DI0_CNT_UP_8                         IPU_MEMORY_OFFSET+0x0040530,0x000001FF

#define SRM_DI0_SW_GEN1_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040534
#define SRM_DI0_SW_GEN1_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040534,0x00000000
#define SRM_DI0_SW_GEN1_9__FULL                                 IPU_MEMORY_OFFSET+0x0040534,0xffffffff
#define SRM_DI0_SW_GEN1_9__DI0_GENTIME_SEL_9                    IPU_MEMORY_OFFSET+0x0040534,0xE0000000
#define SRM_DI0_SW_GEN1_9__DI0_CNT_AUTO_RELOAD_9                IPU_MEMORY_OFFSET+0x0040534,0x10000000
#define SRM_DI0_SW_GEN1_9__DI0_CNT_CLR_SEL_9                    IPU_MEMORY_OFFSET+0x0040534,0x0E000000
#define SRM_DI0_SW_GEN1_9__DI0_CNT_DOWN_9                       IPU_MEMORY_OFFSET+0x0040534,0x01FF0000
#define SRM_DI0_SW_GEN1_9__DI0_TAG_SEL_9                        IPU_MEMORY_OFFSET+0x0040534,0x00008000
#define SRM_DI0_SW_GEN1_9__DI0_CNT_UP_9                         IPU_MEMORY_OFFSET+0x0040534,0x000001FF

#define SRM_DI0_SYNC_AS_GEN__ADDR                               IPU_MEMORY_OFFSET+0x0040538
#define SRM_DI0_SYNC_AS_GEN__EMPTY                              IPU_MEMORY_OFFSET+0x0040538,0x00000000
#define SRM_DI0_SYNC_AS_GEN__FULL                               IPU_MEMORY_OFFSET+0x0040538,0xffffffff
#define SRM_DI0_SYNC_AS_GEN__DI0_SYNC_START_EN                  IPU_MEMORY_OFFSET+0x0040538,0x10000000
#define SRM_DI0_SYNC_AS_GEN__DI0_VSYNC_SEL                      IPU_MEMORY_OFFSET+0x0040538,0x0000E000
#define SRM_DI0_SYNC_AS_GEN__DI0_SYNC_START                     IPU_MEMORY_OFFSET+0x0040538,0x00000FFF

#define SRM_DI0_DW_GEN_0__ADDR                                  IPU_MEMORY_OFFSET+0x004053C
#define SRM_DI0_DW_GEN_0__EMPTY                                 IPU_MEMORY_OFFSET+0x004053C,0x00000000
#define SRM_DI0_DW_GEN_0__FULL                                  IPU_MEMORY_OFFSET+0x004053C,0xffffffff
#define SRM_DI0_DW_GEN_0__DI0_ACCESS_SIZE_0                     IPU_MEMORY_OFFSET+0x004053C,0xFF000000
#define SRM_DI0_DW_GEN_0__DI0_COMPONNENT_SIZE_0                 IPU_MEMORY_OFFSET+0x004053C,0x00FF0000
#define SRM_DI0_DW_GEN_0__DI0_CST_0                             IPU_MEMORY_OFFSET+0x004053C,0x0000C000
#define SRM_DI0_DW_GEN_0__DI0_PT_6_0                            IPU_MEMORY_OFFSET+0x004053C,0x00003000
#define SRM_DI0_DW_GEN_0__DI0_PT_5_0                            IPU_MEMORY_OFFSET+0x004053C,0x00000C00
#define SRM_DI0_DW_GEN_0__DI0_PT_4_0                            IPU_MEMORY_OFFSET+0x004053C,0x00000300
#define SRM_DI0_DW_GEN_0__DI0_PT_3_0                            IPU_MEMORY_OFFSET+0x004053C,0x000000C0
#define SRM_DI0_DW_GEN_0__DI0_PT_2_0                            IPU_MEMORY_OFFSET+0x004053C,0x00000030
#define SRM_DI0_DW_GEN_0__DI0_PT_1_0                            IPU_MEMORY_OFFSET+0x004053C,0x0000000C
#define SRM_DI0_DW_GEN_0__DI0_PT_0_0                            IPU_MEMORY_OFFSET+0x004053C,0x00000003

#define SRM_DI0_DW_GEN_1__ADDR                                  IPU_MEMORY_OFFSET+0x0040540
#define SRM_DI0_DW_GEN_1__EMPTY                                 IPU_MEMORY_OFFSET+0x0040540,0x00000000
#define SRM_DI0_DW_GEN_1__FULL                                  IPU_MEMORY_OFFSET+0x0040540,0xffffffff
#define SRM_DI0_DW_GEN_1__DI0_ACCESS_SIZE_1                     IPU_MEMORY_OFFSET+0x0040540,0xFF000000
#define SRM_DI0_DW_GEN_1__DI0_COMPONNENT_SIZE_1                 IPU_MEMORY_OFFSET+0x0040540,0x00FF0000
#define SRM_DI0_DW_GEN_1__DI0_CST_1                             IPU_MEMORY_OFFSET+0x0040540,0x0000C000
#define SRM_DI0_DW_GEN_1__DI0_PT_6_1                            IPU_MEMORY_OFFSET+0x0040540,0x00003000
#define SRM_DI0_DW_GEN_1__DI0_PT_5_1                            IPU_MEMORY_OFFSET+0x0040540,0x00000C00
#define SRM_DI0_DW_GEN_1__DI0_PT_4_1                            IPU_MEMORY_OFFSET+0x0040540,0x00000300
#define SRM_DI0_DW_GEN_1__DI0_PT_3_1                            IPU_MEMORY_OFFSET+0x0040540,0x000000C0
#define SRM_DI0_DW_GEN_1__DI0_PT_2_1                            IPU_MEMORY_OFFSET+0x0040540,0x00000030
#define SRM_DI0_DW_GEN_1__DI0_PT_1_1                            IPU_MEMORY_OFFSET+0x0040540,0x0000000C
#define SRM_DI0_DW_GEN_1__DI0_PT_0_1                            IPU_MEMORY_OFFSET+0x0040540,0x00000003

#define SRM_DI0_DW_GEN_2__ADDR                                  IPU_MEMORY_OFFSET+0x0040544
#define SRM_DI0_DW_GEN_2__EMPTY                                 IPU_MEMORY_OFFSET+0x0040544,0x00000000
#define SRM_DI0_DW_GEN_2__FULL                                  IPU_MEMORY_OFFSET+0x0040544,0xffffffff
#define SRM_DI0_DW_GEN_2__DI0_ACCESS_SIZE_2                     IPU_MEMORY_OFFSET+0x0040544,0xFF000000
#define SRM_DI0_DW_GEN_2__DI0_COMPONNENT_SIZE_2                 IPU_MEMORY_OFFSET+0x0040544,0x00FF0000
#define SRM_DI0_DW_GEN_2__DI0_CST_2                             IPU_MEMORY_OFFSET+0x0040544,0x0000C000
#define SRM_DI0_DW_GEN_2__DI0_PT_6_2                            IPU_MEMORY_OFFSET+0x0040544,0x00003000
#define SRM_DI0_DW_GEN_2__DI0_PT_5_2                            IPU_MEMORY_OFFSET+0x0040544,0x00000C00
#define SRM_DI0_DW_GEN_2__DI0_PT_4_2                            IPU_MEMORY_OFFSET+0x0040544,0x00000300
#define SRM_DI0_DW_GEN_2__DI0_PT_3_2                            IPU_MEMORY_OFFSET+0x0040544,0x000000C0
#define SRM_DI0_DW_GEN_2__DI0_PT_2_2                            IPU_MEMORY_OFFSET+0x0040544,0x00000030
#define SRM_DI0_DW_GEN_2__DI0_PT_1_2                            IPU_MEMORY_OFFSET+0x0040544,0x0000000C
#define SRM_DI0_DW_GEN_2__DI0_PT_0_2                            IPU_MEMORY_OFFSET+0x0040544,0x00000003

#define SRM_DI0_DW_GEN_3__ADDR                                  IPU_MEMORY_OFFSET+0x0040548
#define SRM_DI0_DW_GEN_3__EMPTY                                 IPU_MEMORY_OFFSET+0x0040548,0x00000000
#define SRM_DI0_DW_GEN_3__FULL                                  IPU_MEMORY_OFFSET+0x0040548,0xffffffff
#define SRM_DI0_DW_GEN_3__DI0_ACCESS_SIZE_3                     IPU_MEMORY_OFFSET+0x0040548,0xFF000000
#define SRM_DI0_DW_GEN_3__DI0_COMPONNENT_SIZE_3                 IPU_MEMORY_OFFSET+0x0040548,0x00FF0000
#define SRM_DI0_DW_GEN_3__DI0_CST_3                             IPU_MEMORY_OFFSET+0x0040548,0x0000C000
#define SRM_DI0_DW_GEN_3__DI0_PT_6_3                            IPU_MEMORY_OFFSET+0x0040548,0x00003000
#define SRM_DI0_DW_GEN_3__DI0_PT_5_3                            IPU_MEMORY_OFFSET+0x0040548,0x00000C00
#define SRM_DI0_DW_GEN_3__DI0_PT_4_3                            IPU_MEMORY_OFFSET+0x0040548,0x00000300
#define SRM_DI0_DW_GEN_3__DI0_PT_3_3                            IPU_MEMORY_OFFSET+0x0040548,0x000000C0
#define SRM_DI0_DW_GEN_3__DI0_PT_2_3                            IPU_MEMORY_OFFSET+0x0040548,0x00000030
#define SRM_DI0_DW_GEN_3__DI0_PT_1_3                            IPU_MEMORY_OFFSET+0x0040548,0x0000000C
#define SRM_DI0_DW_GEN_3__DI0_PT_0_3                            IPU_MEMORY_OFFSET+0x0040548,0x00000003

#define SRM_DI0_DW_GEN_4__ADDR                                  IPU_MEMORY_OFFSET+0x004054C
#define SRM_DI0_DW_GEN_4__EMPTY                                 IPU_MEMORY_OFFSET+0x004054C,0x00000000
#define SRM_DI0_DW_GEN_4__FULL                                  IPU_MEMORY_OFFSET+0x004054C,0xffffffff
#define SRM_DI0_DW_GEN_4__DI0_ACCESS_SIZE_4                     IPU_MEMORY_OFFSET+0x004054C,0xFF000000
#define SRM_DI0_DW_GEN_4__DI0_COMPONNENT_SIZE_4                 IPU_MEMORY_OFFSET+0x004054C,0x00FF0000
#define SRM_DI0_DW_GEN_4__DI0_CST_4                             IPU_MEMORY_OFFSET+0x004054C,0x0000C000
#define SRM_DI0_DW_GEN_4__DI0_PT_6_4                            IPU_MEMORY_OFFSET+0x004054C,0x00003000
#define SRM_DI0_DW_GEN_4__DI0_PT_5_4                            IPU_MEMORY_OFFSET+0x004054C,0x00000C00
#define SRM_DI0_DW_GEN_4__DI0_PT_4_4                            IPU_MEMORY_OFFSET+0x004054C,0x00000300
#define SRM_DI0_DW_GEN_4__DI0_PT_3_4                            IPU_MEMORY_OFFSET+0x004054C,0x000000C0
#define SRM_DI0_DW_GEN_4__DI0_PT_2_4                            IPU_MEMORY_OFFSET+0x004054C,0x00000030
#define SRM_DI0_DW_GEN_4__DI0_PT_1_4                            IPU_MEMORY_OFFSET+0x004054C,0x0000000C
#define SRM_DI0_DW_GEN_4__DI0_PT_0_4                            IPU_MEMORY_OFFSET+0x004054C,0x00000003

#define SRM_DI0_DW_GEN_5__ADDR                                  IPU_MEMORY_OFFSET+0x0040550
#define SRM_DI0_DW_GEN_5__EMPTY                                 IPU_MEMORY_OFFSET+0x0040550,0x00000000
#define SRM_DI0_DW_GEN_5__FULL                                  IPU_MEMORY_OFFSET+0x0040550,0xffffffff
#define SRM_DI0_DW_GEN_5__DI0_ACCESS_SIZE_5                     IPU_MEMORY_OFFSET+0x0040550,0xFF000000
#define SRM_DI0_DW_GEN_5__DI0_COMPONNENT_SIZE_5                 IPU_MEMORY_OFFSET+0x0040550,0x00FF0000
#define SRM_DI0_DW_GEN_5__DI0_CST_5                             IPU_MEMORY_OFFSET+0x0040550,0x0000C000
#define SRM_DI0_DW_GEN_5__DI0_PT_6_5                            IPU_MEMORY_OFFSET+0x0040550,0x00003000
#define SRM_DI0_DW_GEN_5__DI0_PT_5_5                            IPU_MEMORY_OFFSET+0x0040550,0x00000C00
#define SRM_DI0_DW_GEN_5__DI0_PT_4_5                            IPU_MEMORY_OFFSET+0x0040550,0x00000300
#define SRM_DI0_DW_GEN_5__DI0_PT_3_5                            IPU_MEMORY_OFFSET+0x0040550,0x000000C0
#define SRM_DI0_DW_GEN_5__DI0_PT_2_5                            IPU_MEMORY_OFFSET+0x0040550,0x00000030
#define SRM_DI0_DW_GEN_5__DI0_PT_1_5                            IPU_MEMORY_OFFSET+0x0040550,0x0000000C
#define SRM_DI0_DW_GEN_5__DI0_PT_0_5                            IPU_MEMORY_OFFSET+0x0040550,0x00000003

#define SRM_DI0_DW_GEN_6__ADDR                                  IPU_MEMORY_OFFSET+0x0040554
#define SRM_DI0_DW_GEN_6__EMPTY                                 IPU_MEMORY_OFFSET+0x0040554,0x00000000
#define SRM_DI0_DW_GEN_6__FULL                                  IPU_MEMORY_OFFSET+0x0040554,0xffffffff
#define SRM_DI0_DW_GEN_6__DI0_ACCESS_SIZE_6                     IPU_MEMORY_OFFSET+0x0040554,0xFF000000
#define SRM_DI0_DW_GEN_6__DI0_COMPONNENT_SIZE_6                 IPU_MEMORY_OFFSET+0x0040554,0x00FF0000
#define SRM_DI0_DW_GEN_6__DI0_CST_6                             IPU_MEMORY_OFFSET+0x0040554,0x0000C000
#define SRM_DI0_DW_GEN_6__DI0_PT_6_6                            IPU_MEMORY_OFFSET+0x0040554,0x00003000
#define SRM_DI0_DW_GEN_6__DI0_PT_5_6                            IPU_MEMORY_OFFSET+0x0040554,0x00000C00
#define SRM_DI0_DW_GEN_6__DI0_PT_4_6                            IPU_MEMORY_OFFSET+0x0040554,0x00000300
#define SRM_DI0_DW_GEN_6__DI0_PT_3_6                            IPU_MEMORY_OFFSET+0x0040554,0x000000C0
#define SRM_DI0_DW_GEN_6__DI0_PT_2_6                            IPU_MEMORY_OFFSET+0x0040554,0x00000030
#define SRM_DI0_DW_GEN_6__DI0_PT_1_6                            IPU_MEMORY_OFFSET+0x0040554,0x0000000C
#define SRM_DI0_DW_GEN_6__DI0_PT_0_6                            IPU_MEMORY_OFFSET+0x0040554,0x00000003

#define SRM_DI0_DW_GEN_7__ADDR                                  IPU_MEMORY_OFFSET+0x0040558
#define SRM_DI0_DW_GEN_7__EMPTY                                 IPU_MEMORY_OFFSET+0x0040558,0x00000000
#define SRM_DI0_DW_GEN_7__FULL                                  IPU_MEMORY_OFFSET+0x0040558,0xffffffff
#define SRM_DI0_DW_GEN_7__DI0_ACCESS_SIZE_7                     IPU_MEMORY_OFFSET+0x0040558,0xFF000000
#define SRM_DI0_DW_GEN_7__DI0_COMPONNENT_SIZE_7                 IPU_MEMORY_OFFSET+0x0040558,0x00FF0000
#define SRM_DI0_DW_GEN_7__DI0_CST_7                             IPU_MEMORY_OFFSET+0x0040558,0x0000C000
#define SRM_DI0_DW_GEN_7__DI0_PT_6_7                            IPU_MEMORY_OFFSET+0x0040558,0x00003000
#define SRM_DI0_DW_GEN_7__DI0_PT_5_7                            IPU_MEMORY_OFFSET+0x0040558,0x00000C00
#define SRM_DI0_DW_GEN_7__DI0_PT_4_7                            IPU_MEMORY_OFFSET+0x0040558,0x00000300
#define SRM_DI0_DW_GEN_7__DI0_PT_3_7                            IPU_MEMORY_OFFSET+0x0040558,0x000000C0
#define SRM_DI0_DW_GEN_7__DI0_PT_2_7                            IPU_MEMORY_OFFSET+0x0040558,0x00000030
#define SRM_DI0_DW_GEN_7__DI0_PT_1_7                            IPU_MEMORY_OFFSET+0x0040558,0x0000000C
#define SRM_DI0_DW_GEN_7__DI0_PT_0_7                            IPU_MEMORY_OFFSET+0x0040558,0x00000003

#define SRM_DI0_DW_GEN_8__ADDR                                  IPU_MEMORY_OFFSET+0x004055C
#define SRM_DI0_DW_GEN_8__EMPTY                                 IPU_MEMORY_OFFSET+0x004055C,0x00000000
#define SRM_DI0_DW_GEN_8__FULL                                  IPU_MEMORY_OFFSET+0x004055C,0xffffffff
#define SRM_DI0_DW_GEN_8__DI0_ACCESS_SIZE_8                     IPU_MEMORY_OFFSET+0x004055C,0xFF000000
#define SRM_DI0_DW_GEN_8__DI0_COMPONNENT_SIZE_8                 IPU_MEMORY_OFFSET+0x004055C,0x00FF0000
#define SRM_DI0_DW_GEN_8__DI0_CST_8                             IPU_MEMORY_OFFSET+0x004055C,0x0000C000
#define SRM_DI0_DW_GEN_8__DI0_PT_6_8                            IPU_MEMORY_OFFSET+0x004055C,0x00003000
#define SRM_DI0_DW_GEN_8__DI0_PT_5_8                            IPU_MEMORY_OFFSET+0x004055C,0x00000C00
#define SRM_DI0_DW_GEN_8__DI0_PT_4_8                            IPU_MEMORY_OFFSET+0x004055C,0x00000300
#define SRM_DI0_DW_GEN_8__DI0_PT_3_8                            IPU_MEMORY_OFFSET+0x004055C,0x000000C0
#define SRM_DI0_DW_GEN_8__DI0_PT_2_8                            IPU_MEMORY_OFFSET+0x004055C,0x00000030
#define SRM_DI0_DW_GEN_8__DI0_PT_1_8                            IPU_MEMORY_OFFSET+0x004055C,0x0000000C
#define SRM_DI0_DW_GEN_8__DI0_PT_0_8                            IPU_MEMORY_OFFSET+0x004055C,0x00000003

#define SRM_DI0_DW_GEN_9__ADDR                                  IPU_MEMORY_OFFSET+0x0040560
#define SRM_DI0_DW_GEN_9__EMPTY                                 IPU_MEMORY_OFFSET+0x0040560,0x00000000
#define SRM_DI0_DW_GEN_9__FULL                                  IPU_MEMORY_OFFSET+0x0040560,0xffffffff
#define SRM_DI0_DW_GEN_9__DI0_ACCESS_SIZE_9                     IPU_MEMORY_OFFSET+0x0040560,0xFF000000
#define SRM_DI0_DW_GEN_9__DI0_COMPONNENT_SIZE_9                 IPU_MEMORY_OFFSET+0x0040560,0x00FF0000
#define SRM_DI0_DW_GEN_9__DI0_CST_9                             IPU_MEMORY_OFFSET+0x0040560,0x0000C000
#define SRM_DI0_DW_GEN_9__DI0_PT_6_9                            IPU_MEMORY_OFFSET+0x0040560,0x00003000
#define SRM_DI0_DW_GEN_9__DI0_PT_5_9                            IPU_MEMORY_OFFSET+0x0040560,0x00000C00
#define SRM_DI0_DW_GEN_9__DI0_PT_4_9                            IPU_MEMORY_OFFSET+0x0040560,0x00000300
#define SRM_DI0_DW_GEN_9__DI0_PT_3_9                            IPU_MEMORY_OFFSET+0x0040560,0x000000C0
#define SRM_DI0_DW_GEN_9__DI0_PT_2_9                            IPU_MEMORY_OFFSET+0x0040560,0x00000030
#define SRM_DI0_DW_GEN_9__DI0_PT_1_9                            IPU_MEMORY_OFFSET+0x0040560,0x0000000C
#define SRM_DI0_DW_GEN_9__DI0_PT_0_9                            IPU_MEMORY_OFFSET+0x0040560,0x00000003

#define SRM_DI0_DW_GEN_10__ADDR                                 IPU_MEMORY_OFFSET+0x0040564
#define SRM_DI0_DW_GEN_10__EMPTY                                IPU_MEMORY_OFFSET+0x0040564,0x00000000
#define SRM_DI0_DW_GEN_10__FULL                                 IPU_MEMORY_OFFSET+0x0040564,0xffffffff
#define SRM_DI0_DW_GEN_10__DI0_ACCESS_SIZE_10                   IPU_MEMORY_OFFSET+0x0040564,0xFF000000
#define SRM_DI0_DW_GEN_10__DI0_COMPONNENT_SIZE_10               IPU_MEMORY_OFFSET+0x0040564,0x00FF0000
#define SRM_DI0_DW_GEN_10__DI0_CST_10                           IPU_MEMORY_OFFSET+0x0040564,0x0000C000
#define SRM_DI0_DW_GEN_10__DI0_PT_6_10                          IPU_MEMORY_OFFSET+0x0040564,0x00003000
#define SRM_DI0_DW_GEN_10__DI0_PT_5_10                          IPU_MEMORY_OFFSET+0x0040564,0x00000C00
#define SRM_DI0_DW_GEN_10__DI0_PT_4_10                          IPU_MEMORY_OFFSET+0x0040564,0x00000300
#define SRM_DI0_DW_GEN_10__DI0_PT_3_10                          IPU_MEMORY_OFFSET+0x0040564,0x000000C0
#define SRM_DI0_DW_GEN_10__DI0_PT_2_10                          IPU_MEMORY_OFFSET+0x0040564,0x00000030
#define SRM_DI0_DW_GEN_10__DI0_PT_1_10                          IPU_MEMORY_OFFSET+0x0040564,0x0000000C
#define SRM_DI0_DW_GEN_10__DI0_PT_0_10                          IPU_MEMORY_OFFSET+0x0040564,0x00000003

#define SRM_DI0_DW_GEN_11__ADDR                                 IPU_MEMORY_OFFSET+0x0040568
#define SRM_DI0_DW_GEN_11__EMPTY                                IPU_MEMORY_OFFSET+0x0040568,0x00000000
#define SRM_DI0_DW_GEN_11__FULL                                 IPU_MEMORY_OFFSET+0x0040568,0xffffffff
#define SRM_DI0_DW_GEN_11__DI0_ACCESS_SIZE_11                   IPU_MEMORY_OFFSET+0x0040568,0xFF000000
#define SRM_DI0_DW_GEN_11__DI0_COMPONNENT_SIZE_11               IPU_MEMORY_OFFSET+0x0040568,0x00FF0000
#define SRM_DI0_DW_GEN_11__DI0_CST_11                           IPU_MEMORY_OFFSET+0x0040568,0x0000C000
#define SRM_DI0_DW_GEN_11__DI0_PT_6_11                          IPU_MEMORY_OFFSET+0x0040568,0x00003000
#define SRM_DI0_DW_GEN_11__DI0_PT_5_11                          IPU_MEMORY_OFFSET+0x0040568,0x00000C00
#define SRM_DI0_DW_GEN_11__DI0_PT_4_11                          IPU_MEMORY_OFFSET+0x0040568,0x00000300
#define SRM_DI0_DW_GEN_11__DI0_PT_3_11                          IPU_MEMORY_OFFSET+0x0040568,0x000000C0
#define SRM_DI0_DW_GEN_11__DI0_PT_2_11                          IPU_MEMORY_OFFSET+0x0040568,0x00000030
#define SRM_DI0_DW_GEN_11__DI0_PT_1_11                          IPU_MEMORY_OFFSET+0x0040568,0x0000000C
#define SRM_DI0_DW_GEN_11__DI0_PT_0_11                          IPU_MEMORY_OFFSET+0x0040568,0x00000003

#define SRM_DI0_DW_SET0_0__ADDR                                 IPU_MEMORY_OFFSET+0x004056C
#define SRM_DI0_DW_SET0_0__EMPTY                                IPU_MEMORY_OFFSET+0x004056C,0x00000000
#define SRM_DI0_DW_SET0_0__FULL                                 IPU_MEMORY_OFFSET+0x004056C,0xffffffff
#define SRM_DI0_DW_SET0_0__DI0_DATA_CNT_DOWN0_0                 IPU_MEMORY_OFFSET+0x004056C,0x01FF0000
#define SRM_DI0_DW_SET0_0__DI0_DATA_CNT_UP0_0                   IPU_MEMORY_OFFSET+0x004056C,0x000001FF

#define SRM_DI0_DW_SET0_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040570
#define SRM_DI0_DW_SET0_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040570,0x00000000
#define SRM_DI0_DW_SET0_1__FULL                                 IPU_MEMORY_OFFSET+0x0040570,0xffffffff
#define SRM_DI0_DW_SET0_1__DI0_DATA_CNT_DOWN0_1                 IPU_MEMORY_OFFSET+0x0040570,0x01FF0000
#define SRM_DI0_DW_SET0_1__DI0_DATA_CNT_UP0_1                   IPU_MEMORY_OFFSET+0x0040570,0x000001FF

#define SRM_DI0_DW_SET0_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040574
#define SRM_DI0_DW_SET0_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040574,0x00000000
#define SRM_DI0_DW_SET0_2__FULL                                 IPU_MEMORY_OFFSET+0x0040574,0xffffffff
#define SRM_DI0_DW_SET0_2__DI0_DATA_CNT_DOWN0_2                 IPU_MEMORY_OFFSET+0x0040574,0x01FF0000
#define SRM_DI0_DW_SET0_2__DI0_DATA_CNT_UP0_2                   IPU_MEMORY_OFFSET+0x0040574,0x000001FF

#define SRM_DI0_DW_SET0_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040578
#define SRM_DI0_DW_SET0_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040578,0x00000000
#define SRM_DI0_DW_SET0_3__FULL                                 IPU_MEMORY_OFFSET+0x0040578,0xffffffff
#define SRM_DI0_DW_SET0_3__DI0_DATA_CNT_DOWN0_3                 IPU_MEMORY_OFFSET+0x0040578,0x01FF0000
#define SRM_DI0_DW_SET0_3__DI0_DATA_CNT_UP0_3                   IPU_MEMORY_OFFSET+0x0040578,0x000001FF

#define SRM_DI0_DW_SET0_4__ADDR                                 IPU_MEMORY_OFFSET+0x004057C
#define SRM_DI0_DW_SET0_4__EMPTY                                IPU_MEMORY_OFFSET+0x004057C,0x00000000
#define SRM_DI0_DW_SET0_4__FULL                                 IPU_MEMORY_OFFSET+0x004057C,0xffffffff
#define SRM_DI0_DW_SET0_4__DI0_DATA_CNT_DOWN0_4                 IPU_MEMORY_OFFSET+0x004057C,0x01FF0000
#define SRM_DI0_DW_SET0_4__DI0_DATA_CNT_UP0_4                   IPU_MEMORY_OFFSET+0x004057C,0x000001FF

#define SRM_DI0_DW_SET0_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040580
#define SRM_DI0_DW_SET0_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040580,0x00000000
#define SRM_DI0_DW_SET0_5__FULL                                 IPU_MEMORY_OFFSET+0x0040580,0xffffffff
#define SRM_DI0_DW_SET0_5__DI0_DATA_CNT_DOWN0_5                 IPU_MEMORY_OFFSET+0x0040580,0x01FF0000
#define SRM_DI0_DW_SET0_5__DI0_DATA_CNT_UP0_5                   IPU_MEMORY_OFFSET+0x0040580,0x000001FF

#define SRM_DI0_DW_SET0_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040584
#define SRM_DI0_DW_SET0_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040584,0x00000000
#define SRM_DI0_DW_SET0_6__FULL                                 IPU_MEMORY_OFFSET+0x0040584,0xffffffff
#define SRM_DI0_DW_SET0_6__DI0_DATA_CNT_DOWN0_6                 IPU_MEMORY_OFFSET+0x0040584,0x01FF0000
#define SRM_DI0_DW_SET0_6__DI0_DATA_CNT_UP0_6                   IPU_MEMORY_OFFSET+0x0040584,0x000001FF

#define SRM_DI0_DW_SET0_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040588
#define SRM_DI0_DW_SET0_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040588,0x00000000
#define SRM_DI0_DW_SET0_7__FULL                                 IPU_MEMORY_OFFSET+0x0040588,0xffffffff
#define SRM_DI0_DW_SET0_7__DI0_DATA_CNT_DOWN0_7                 IPU_MEMORY_OFFSET+0x0040588,0x01FF0000
#define SRM_DI0_DW_SET0_7__DI0_DATA_CNT_UP0_7                   IPU_MEMORY_OFFSET+0x0040588,0x000001FF

#define SRM_DI0_DW_SET0_8__ADDR                                 IPU_MEMORY_OFFSET+0x004058C
#define SRM_DI0_DW_SET0_8__EMPTY                                IPU_MEMORY_OFFSET+0x004058C,0x00000000
#define SRM_DI0_DW_SET0_8__FULL                                 IPU_MEMORY_OFFSET+0x004058C,0xffffffff
#define SRM_DI0_DW_SET0_8__DI0_DATA_CNT_DOWN0_8                 IPU_MEMORY_OFFSET+0x004058C,0x01FF0000
#define SRM_DI0_DW_SET0_8__DI0_DATA_CNT_UP0_8                   IPU_MEMORY_OFFSET+0x004058C,0x000001FF

#define SRM_DI0_DW_SET0_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040590
#define SRM_DI0_DW_SET0_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040590,0x00000000
#define SRM_DI0_DW_SET0_9__FULL                                 IPU_MEMORY_OFFSET+0x0040590,0xffffffff
#define SRM_DI0_DW_SET0_9__DI0_DATA_CNT_DOWN0_9                 IPU_MEMORY_OFFSET+0x0040590,0x01FF0000
#define SRM_DI0_DW_SET0_9__DI0_DATA_CNT_UP0_9                   IPU_MEMORY_OFFSET+0x0040590,0x000001FF

#define SRM_DI0_DW_SET0_10__ADDR                                IPU_MEMORY_OFFSET+0x0040594
#define SRM_DI0_DW_SET0_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040594,0x00000000
#define SRM_DI0_DW_SET0_10__FULL                                IPU_MEMORY_OFFSET+0x0040594,0xffffffff
#define SRM_DI0_DW_SET0_10__DI0_DATA_CNT_DOWN0_10               IPU_MEMORY_OFFSET+0x0040594,0x01FF0000
#define SRM_DI0_DW_SET0_10__DI0_DATA_CNT_UP0_10                 IPU_MEMORY_OFFSET+0x0040594,0x000001FF

#define SRM_DI0_DW_SET0_11__ADDR                                IPU_MEMORY_OFFSET+0x0040598
#define SRM_DI0_DW_SET0_11__EMPTY                               IPU_MEMORY_OFFSET+0x0040598,0x00000000
#define SRM_DI0_DW_SET0_11__FULL                                IPU_MEMORY_OFFSET+0x0040598,0xffffffff
#define SRM_DI0_DW_SET0_11__DI0_DATA_CNT_DOWN0_11               IPU_MEMORY_OFFSET+0x0040598,0x01FF0000
#define SRM_DI0_DW_SET0_11__DI0_DATA_CNT_UP0_11                 IPU_MEMORY_OFFSET+0x0040598,0x000001FF

#define SRM_DI0_DW_SET1_0__ADDR                                 IPU_MEMORY_OFFSET+0x004059C
#define SRM_DI0_DW_SET1_0__EMPTY                                IPU_MEMORY_OFFSET+0x004059C,0x00000000
#define SRM_DI0_DW_SET1_0__FULL                                 IPU_MEMORY_OFFSET+0x004059C,0xffffffff
#define SRM_DI0_DW_SET1_0__DI0_DATA_CNT_DOWN1_0                 IPU_MEMORY_OFFSET+0x004059C,0x01FF0000
#define SRM_DI0_DW_SET1_0__DI0_DATA_CNT_UP1_0                   IPU_MEMORY_OFFSET+0x004059C,0x000001FF

#define SRM_DI0_DW_SET1_1__ADDR                                 IPU_MEMORY_OFFSET+0x00405A0
#define SRM_DI0_DW_SET1_1__EMPTY                                IPU_MEMORY_OFFSET+0x00405A0,0x00000000
#define SRM_DI0_DW_SET1_1__FULL                                 IPU_MEMORY_OFFSET+0x00405A0,0xffffffff
#define SRM_DI0_DW_SET1_1__DI0_DATA_CNT_DOWN1_1                 IPU_MEMORY_OFFSET+0x00405A0,0x01FF0000
#define SRM_DI0_DW_SET1_1__DI0_DATA_CNT_UP1_1                   IPU_MEMORY_OFFSET+0x00405A0,0x000001FF

#define SRM_DI0_DW_SET1_2__ADDR                                 IPU_MEMORY_OFFSET+0x00405A4
#define SRM_DI0_DW_SET1_2__EMPTY                                IPU_MEMORY_OFFSET+0x00405A4,0x00000000
#define SRM_DI0_DW_SET1_2__FULL                                 IPU_MEMORY_OFFSET+0x00405A4,0xffffffff
#define SRM_DI0_DW_SET1_2__DI0_DATA_CNT_DOWN1_2                 IPU_MEMORY_OFFSET+0x00405A4,0x01FF0000
#define SRM_DI0_DW_SET1_2__DI0_DATA_CNT_UP1_2                   IPU_MEMORY_OFFSET+0x00405A4,0x000001FF

#define SRM_DI0_DW_SET1_3__ADDR                                 IPU_MEMORY_OFFSET+0x00405A8
#define SRM_DI0_DW_SET1_3__EMPTY                                IPU_MEMORY_OFFSET+0x00405A8,0x00000000
#define SRM_DI0_DW_SET1_3__FULL                                 IPU_MEMORY_OFFSET+0x00405A8,0xffffffff
#define SRM_DI0_DW_SET1_3__DI0_DATA_CNT_DOWN1_3                 IPU_MEMORY_OFFSET+0x00405A8,0x01FF0000
#define SRM_DI0_DW_SET1_3__DI0_DATA_CNT_UP1_3                   IPU_MEMORY_OFFSET+0x00405A8,0x000001FF

#define SRM_DI0_DW_SET1_4__ADDR                                 IPU_MEMORY_OFFSET+0x00405AC
#define SRM_DI0_DW_SET1_4__EMPTY                                IPU_MEMORY_OFFSET+0x00405AC,0x00000000
#define SRM_DI0_DW_SET1_4__FULL                                 IPU_MEMORY_OFFSET+0x00405AC,0xffffffff
#define SRM_DI0_DW_SET1_4__DI0_DATA_CNT_DOWN1_4                 IPU_MEMORY_OFFSET+0x00405AC,0x01FF0000
#define SRM_DI0_DW_SET1_4__DI0_DATA_CNT_UP1_4                   IPU_MEMORY_OFFSET+0x00405AC,0x000001FF

#define SRM_DI0_DW_SET1_5__ADDR                                 IPU_MEMORY_OFFSET+0x00405B0
#define SRM_DI0_DW_SET1_5__EMPTY                                IPU_MEMORY_OFFSET+0x00405B0,0x00000000
#define SRM_DI0_DW_SET1_5__FULL                                 IPU_MEMORY_OFFSET+0x00405B0,0xffffffff
#define SRM_DI0_DW_SET1_5__DI0_DATA_CNT_DOWN1_5                 IPU_MEMORY_OFFSET+0x00405B0,0x01FF0000
#define SRM_DI0_DW_SET1_5__DI0_DATA_CNT_UP1_5                   IPU_MEMORY_OFFSET+0x00405B0,0x000001FF

#define SRM_DI0_DW_SET1_6__ADDR                                 IPU_MEMORY_OFFSET+0x00405B4
#define SRM_DI0_DW_SET1_6__EMPTY                                IPU_MEMORY_OFFSET+0x00405B4,0x00000000
#define SRM_DI0_DW_SET1_6__FULL                                 IPU_MEMORY_OFFSET+0x00405B4,0xffffffff
#define SRM_DI0_DW_SET1_6__DI0_DATA_CNT_DOWN1_6                 IPU_MEMORY_OFFSET+0x00405B4,0x01FF0000
#define SRM_DI0_DW_SET1_6__DI0_DATA_CNT_UP1_6                   IPU_MEMORY_OFFSET+0x00405B4,0x000001FF

#define SRM_DI0_DW_SET1_7__ADDR                                 IPU_MEMORY_OFFSET+0x00405B8
#define SRM_DI0_DW_SET1_7__EMPTY                                IPU_MEMORY_OFFSET+0x00405B8,0x00000000
#define SRM_DI0_DW_SET1_7__FULL                                 IPU_MEMORY_OFFSET+0x00405B8,0xffffffff
#define SRM_DI0_DW_SET1_7__DI0_DATA_CNT_DOWN1_7                 IPU_MEMORY_OFFSET+0x00405B8,0x01FF0000
#define SRM_DI0_DW_SET1_7__DI0_DATA_CNT_UP1_7                   IPU_MEMORY_OFFSET+0x00405B8,0x000001FF

#define SRM_DI0_DW_SET1_8__ADDR                                 IPU_MEMORY_OFFSET+0x00405BC
#define SRM_DI0_DW_SET1_8__EMPTY                                IPU_MEMORY_OFFSET+0x00405BC,0x00000000
#define SRM_DI0_DW_SET1_8__FULL                                 IPU_MEMORY_OFFSET+0x00405BC,0xffffffff
#define SRM_DI0_DW_SET1_8__DI0_DATA_CNT_DOWN1_8                 IPU_MEMORY_OFFSET+0x00405BC,0x01FF0000
#define SRM_DI0_DW_SET1_8__DI0_DATA_CNT_UP1_8                   IPU_MEMORY_OFFSET+0x00405BC,0x000001FF

#define SRM_DI0_DW_SET1_9__ADDR                                 IPU_MEMORY_OFFSET+0x00405C0
#define SRM_DI0_DW_SET1_9__EMPTY                                IPU_MEMORY_OFFSET+0x00405C0,0x00000000
#define SRM_DI0_DW_SET1_9__FULL                                 IPU_MEMORY_OFFSET+0x00405C0,0xffffffff
#define SRM_DI0_DW_SET1_9__DI0_DATA_CNT_DOWN1_9                 IPU_MEMORY_OFFSET+0x00405C0,0x01FF0000
#define SRM_DI0_DW_SET1_9__DI0_DATA_CNT_UP1_9                   IPU_MEMORY_OFFSET+0x00405C0,0x000001FF

#define SRM_DI0_DW_SET1_10__ADDR                                IPU_MEMORY_OFFSET+0x00405C4
#define SRM_DI0_DW_SET1_10__EMPTY                               IPU_MEMORY_OFFSET+0x00405C4,0x00000000
#define SRM_DI0_DW_SET1_10__FULL                                IPU_MEMORY_OFFSET+0x00405C4,0xffffffff
#define SRM_DI0_DW_SET1_10__DI0_DATA_CNT_DOWN1_10               IPU_MEMORY_OFFSET+0x00405C4,0x01FF0000
#define SRM_DI0_DW_SET1_10__DI0_DATA_CNT_UP1_10                 IPU_MEMORY_OFFSET+0x00405C4,0x000001FF

#define SRM_DI0_DW_SET1_11__ADDR                                IPU_MEMORY_OFFSET+0x00405C8
#define SRM_DI0_DW_SET1_11__EMPTY                               IPU_MEMORY_OFFSET+0x00405C8,0x00000000
#define SRM_DI0_DW_SET1_11__FULL                                IPU_MEMORY_OFFSET+0x00405C8,0xffffffff
#define SRM_DI0_DW_SET1_11__DI0_DATA_CNT_DOWN1_11               IPU_MEMORY_OFFSET+0x00405C8,0x01FF0000
#define SRM_DI0_DW_SET1_11__DI0_DATA_CNT_UP1_11                 IPU_MEMORY_OFFSET+0x00405C8,0x000001FF

#define SRM_DI0_DW_SET2_0__ADDR                                 IPU_MEMORY_OFFSET+0x00405CC
#define SRM_DI0_DW_SET2_0__EMPTY                                IPU_MEMORY_OFFSET+0x00405CC,0x00000000
#define SRM_DI0_DW_SET2_0__FULL                                 IPU_MEMORY_OFFSET+0x00405CC,0xffffffff
#define SRM_DI0_DW_SET2_0__DI0_DATA_CNT_DOWN2_0                 IPU_MEMORY_OFFSET+0x00405CC,0x01FF0000
#define SRM_DI0_DW_SET2_0__DI0_DATA_CNT_UP2_0                   IPU_MEMORY_OFFSET+0x00405CC,0x000001FF

#define SRM_DI0_DW_SET2_1__ADDR                                 IPU_MEMORY_OFFSET+0x00405D0
#define SRM_DI0_DW_SET2_1__EMPTY                                IPU_MEMORY_OFFSET+0x00405D0,0x00000000
#define SRM_DI0_DW_SET2_1__FULL                                 IPU_MEMORY_OFFSET+0x00405D0,0xffffffff
#define SRM_DI0_DW_SET2_1__DI0_DATA_CNT_DOWN2_1                 IPU_MEMORY_OFFSET+0x00405D0,0x01FF0000
#define SRM_DI0_DW_SET2_1__DI0_DATA_CNT_UP2_1                   IPU_MEMORY_OFFSET+0x00405D0,0x000001FF

#define SRM_DI0_DW_SET2_2__ADDR                                 IPU_MEMORY_OFFSET+0x00405D4
#define SRM_DI0_DW_SET2_2__EMPTY                                IPU_MEMORY_OFFSET+0x00405D4,0x00000000
#define SRM_DI0_DW_SET2_2__FULL                                 IPU_MEMORY_OFFSET+0x00405D4,0xffffffff
#define SRM_DI0_DW_SET2_2__DI0_DATA_CNT_DOWN2_2                 IPU_MEMORY_OFFSET+0x00405D4,0x01FF0000
#define SRM_DI0_DW_SET2_2__DI0_DATA_CNT_UP2_2                   IPU_MEMORY_OFFSET+0x00405D4,0x000001FF

#define SRM_DI0_DW_SET2_3__ADDR                                 IPU_MEMORY_OFFSET+0x00405D8
#define SRM_DI0_DW_SET2_3__EMPTY                                IPU_MEMORY_OFFSET+0x00405D8,0x00000000
#define SRM_DI0_DW_SET2_3__FULL                                 IPU_MEMORY_OFFSET+0x00405D8,0xffffffff
#define SRM_DI0_DW_SET2_3__DI0_DATA_CNT_DOWN2_3                 IPU_MEMORY_OFFSET+0x00405D8,0x01FF0000
#define SRM_DI0_DW_SET2_3__DI0_DATA_CNT_UP2_3                   IPU_MEMORY_OFFSET+0x00405D8,0x000001FF

#define SRM_DI0_DW_SET2_4__ADDR                                 IPU_MEMORY_OFFSET+0x00405DC
#define SRM_DI0_DW_SET2_4__EMPTY                                IPU_MEMORY_OFFSET+0x00405DC,0x00000000
#define SRM_DI0_DW_SET2_4__FULL                                 IPU_MEMORY_OFFSET+0x00405DC,0xffffffff
#define SRM_DI0_DW_SET2_4__DI0_DATA_CNT_DOWN2_4                 IPU_MEMORY_OFFSET+0x00405DC,0x01FF0000
#define SRM_DI0_DW_SET2_4__DI0_DATA_CNT_UP2_4                   IPU_MEMORY_OFFSET+0x00405DC,0x000001FF

#define SRM_DI0_DW_SET2_5__ADDR                                 IPU_MEMORY_OFFSET+0x00405E0
#define SRM_DI0_DW_SET2_5__EMPTY                                IPU_MEMORY_OFFSET+0x00405E0,0x00000000
#define SRM_DI0_DW_SET2_5__FULL                                 IPU_MEMORY_OFFSET+0x00405E0,0xffffffff
#define SRM_DI0_DW_SET2_5__DI0_DATA_CNT_DOWN2_5                 IPU_MEMORY_OFFSET+0x00405E0,0x01FF0000
#define SRM_DI0_DW_SET2_5__DI0_DATA_CNT_UP2_5                   IPU_MEMORY_OFFSET+0x00405E0,0x000001FF

#define SRM_DI0_DW_SET2_6__ADDR                                 IPU_MEMORY_OFFSET+0x00405E4
#define SRM_DI0_DW_SET2_6__EMPTY                                IPU_MEMORY_OFFSET+0x00405E4,0x00000000
#define SRM_DI0_DW_SET2_6__FULL                                 IPU_MEMORY_OFFSET+0x00405E4,0xffffffff
#define SRM_DI0_DW_SET2_6__DI0_DATA_CNT_DOWN2_6                 IPU_MEMORY_OFFSET+0x00405E4,0x01FF0000
#define SRM_DI0_DW_SET2_6__DI0_DATA_CNT_UP2_6                   IPU_MEMORY_OFFSET+0x00405E4,0x000001FF

#define SRM_DI0_DW_SET2_7__ADDR                                 IPU_MEMORY_OFFSET+0x00405E8
#define SRM_DI0_DW_SET2_7__EMPTY                                IPU_MEMORY_OFFSET+0x00405E8,0x00000000
#define SRM_DI0_DW_SET2_7__FULL                                 IPU_MEMORY_OFFSET+0x00405E8,0xffffffff
#define SRM_DI0_DW_SET2_7__DI0_DATA_CNT_DOWN2_7                 IPU_MEMORY_OFFSET+0x00405E8,0x01FF0000
#define SRM_DI0_DW_SET2_7__DI0_DATA_CNT_UP2_7                   IPU_MEMORY_OFFSET+0x00405E8,0x000001FF

#define SRM_DI0_DW_SET2_8__ADDR                                 IPU_MEMORY_OFFSET+0x00405EC
#define SRM_DI0_DW_SET2_8__EMPTY                                IPU_MEMORY_OFFSET+0x00405EC,0x00000000
#define SRM_DI0_DW_SET2_8__FULL                                 IPU_MEMORY_OFFSET+0x00405EC,0xffffffff
#define SRM_DI0_DW_SET2_8__DI0_DATA_CNT_DOWN2_8                 IPU_MEMORY_OFFSET+0x00405EC,0x01FF0000
#define SRM_DI0_DW_SET2_8__DI0_DATA_CNT_UP2_8                   IPU_MEMORY_OFFSET+0x00405EC,0x000001FF

#define SRM_DI0_DW_SET2_9__ADDR                                 IPU_MEMORY_OFFSET+0x00405F0
#define SRM_DI0_DW_SET2_9__EMPTY                                IPU_MEMORY_OFFSET+0x00405F0,0x00000000
#define SRM_DI0_DW_SET2_9__FULL                                 IPU_MEMORY_OFFSET+0x00405F0,0xffffffff
#define SRM_DI0_DW_SET2_9__DI0_DATA_CNT_DOWN2_9                 IPU_MEMORY_OFFSET+0x00405F0,0x01FF0000
#define SRM_DI0_DW_SET2_9__DI0_DATA_CNT_UP2_9                   IPU_MEMORY_OFFSET+0x00405F0,0x000001FF

#define SRM_DI0_DW_SET2_10__ADDR                                IPU_MEMORY_OFFSET+0x00405F4
#define SRM_DI0_DW_SET2_10__EMPTY                               IPU_MEMORY_OFFSET+0x00405F4,0x00000000
#define SRM_DI0_DW_SET2_10__FULL                                IPU_MEMORY_OFFSET+0x00405F4,0xffffffff
#define SRM_DI0_DW_SET2_10__DI0_DATA_CNT_DOWN2_10               IPU_MEMORY_OFFSET+0x00405F4,0x01FF0000
#define SRM_DI0_DW_SET2_10__DI0_DATA_CNT_UP2_10                 IPU_MEMORY_OFFSET+0x00405F4,0x000001FF

#define SRM_DI0_DW_SET2_11__ADDR                                IPU_MEMORY_OFFSET+0x00405F8
#define SRM_DI0_DW_SET2_11__EMPTY                               IPU_MEMORY_OFFSET+0x00405F8,0x00000000
#define SRM_DI0_DW_SET2_11__FULL                                IPU_MEMORY_OFFSET+0x00405F8,0xffffffff
#define SRM_DI0_DW_SET2_11__DI0_DATA_CNT_DOWN2_11               IPU_MEMORY_OFFSET+0x00405F8,0x01FF0000
#define SRM_DI0_DW_SET2_11__DI0_DATA_CNT_UP2_11                 IPU_MEMORY_OFFSET+0x00405F8,0x000001FF

#define SRM_DI0_DW_SET3_0__ADDR                                 IPU_MEMORY_OFFSET+0x00405FC
#define SRM_DI0_DW_SET3_0__EMPTY                                IPU_MEMORY_OFFSET+0x00405FC,0x00000000
#define SRM_DI0_DW_SET3_0__FULL                                 IPU_MEMORY_OFFSET+0x00405FC,0xffffffff
#define SRM_DI0_DW_SET3_0__DI0_DATA_CNT_DOWN3_0                 IPU_MEMORY_OFFSET+0x00405FC,0x01FF0000
#define SRM_DI0_DW_SET3_0__DI0_DATA_CNT_UP3_0                   IPU_MEMORY_OFFSET+0x00405FC,0x000001FF

#define SRM_DI0_DW_SET3_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040600
#define SRM_DI0_DW_SET3_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040600,0x00000000
#define SRM_DI0_DW_SET3_1__FULL                                 IPU_MEMORY_OFFSET+0x0040600,0xffffffff
#define SRM_DI0_DW_SET3_1__DI0_DATA_CNT_DOWN3_1                 IPU_MEMORY_OFFSET+0x0040600,0x01FF0000
#define SRM_DI0_DW_SET3_1__DI0_DATA_CNT_UP3_1                   IPU_MEMORY_OFFSET+0x0040600,0x000001FF

#define SRM_DI0_DW_SET3_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040604
#define SRM_DI0_DW_SET3_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040604,0x00000000
#define SRM_DI0_DW_SET3_2__FULL                                 IPU_MEMORY_OFFSET+0x0040604,0xffffffff
#define SRM_DI0_DW_SET3_2__DI0_DATA_CNT_DOWN3_2                 IPU_MEMORY_OFFSET+0x0040604,0x01FF0000
#define SRM_DI0_DW_SET3_2__DI0_DATA_CNT_UP3_2                   IPU_MEMORY_OFFSET+0x0040604,0x000001FF

#define SRM_DI0_DW_SET3_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040608
#define SRM_DI0_DW_SET3_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040608,0x00000000
#define SRM_DI0_DW_SET3_3__FULL                                 IPU_MEMORY_OFFSET+0x0040608,0xffffffff
#define SRM_DI0_DW_SET3_3__DI0_DATA_CNT_DOWN3_3                 IPU_MEMORY_OFFSET+0x0040608,0x01FF0000
#define SRM_DI0_DW_SET3_3__DI0_DATA_CNT_UP3_3                   IPU_MEMORY_OFFSET+0x0040608,0x000001FF

#define SRM_DI0_DW_SET3_4__ADDR                                 IPU_MEMORY_OFFSET+0x004060C
#define SRM_DI0_DW_SET3_4__EMPTY                                IPU_MEMORY_OFFSET+0x004060C,0x00000000
#define SRM_DI0_DW_SET3_4__FULL                                 IPU_MEMORY_OFFSET+0x004060C,0xffffffff
#define SRM_DI0_DW_SET3_4__DI0_DATA_CNT_DOWN3_4                 IPU_MEMORY_OFFSET+0x004060C,0x01FF0000
#define SRM_DI0_DW_SET3_4__DI0_DATA_CNT_UP3_4                   IPU_MEMORY_OFFSET+0x004060C,0x000001FF

#define SRM_DI0_DW_SET3_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040610
#define SRM_DI0_DW_SET3_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040610,0x00000000
#define SRM_DI0_DW_SET3_5__FULL                                 IPU_MEMORY_OFFSET+0x0040610,0xffffffff
#define SRM_DI0_DW_SET3_5__DI0_DATA_CNT_DOWN3_5                 IPU_MEMORY_OFFSET+0x0040610,0x01FF0000
#define SRM_DI0_DW_SET3_5__DI0_DATA_CNT_UP3_5                   IPU_MEMORY_OFFSET+0x0040610,0x000001FF

#define SRM_DI0_DW_SET3_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040614
#define SRM_DI0_DW_SET3_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040614,0x00000000
#define SRM_DI0_DW_SET3_6__FULL                                 IPU_MEMORY_OFFSET+0x0040614,0xffffffff
#define SRM_DI0_DW_SET3_6__DI0_DATA_CNT_DOWN3_6                 IPU_MEMORY_OFFSET+0x0040614,0x01FF0000
#define SRM_DI0_DW_SET3_6__DI0_DATA_CNT_UP3_6                   IPU_MEMORY_OFFSET+0x0040614,0x000001FF

#define SRM_DI0_DW_SET3_7__ADDR                                 IPU_MEMORY_OFFSET+0x0040618
#define SRM_DI0_DW_SET3_7__EMPTY                                IPU_MEMORY_OFFSET+0x0040618,0x00000000
#define SRM_DI0_DW_SET3_7__FULL                                 IPU_MEMORY_OFFSET+0x0040618,0xffffffff
#define SRM_DI0_DW_SET3_7__DI0_DATA_CNT_DOWN3_7                 IPU_MEMORY_OFFSET+0x0040618,0x01FF0000
#define SRM_DI0_DW_SET3_7__DI0_DATA_CNT_UP3_7                   IPU_MEMORY_OFFSET+0x0040618,0x000001FF

#define SRM_DI0_DW_SET3_8__ADDR                                 IPU_MEMORY_OFFSET+0x004061C
#define SRM_DI0_DW_SET3_8__EMPTY                                IPU_MEMORY_OFFSET+0x004061C,0x00000000
#define SRM_DI0_DW_SET3_8__FULL                                 IPU_MEMORY_OFFSET+0x004061C,0xffffffff
#define SRM_DI0_DW_SET3_8__DI0_DATA_CNT_DOWN3_8                 IPU_MEMORY_OFFSET+0x004061C,0x01FF0000
#define SRM_DI0_DW_SET3_8__DI0_DATA_CNT_UP3_8                   IPU_MEMORY_OFFSET+0x004061C,0x000001FF

#define SRM_DI0_DW_SET3_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040620
#define SRM_DI0_DW_SET3_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040620,0x00000000
#define SRM_DI0_DW_SET3_9__FULL                                 IPU_MEMORY_OFFSET+0x0040620,0xffffffff
#define SRM_DI0_DW_SET3_9__DI0_DATA_CNT_DOWN3_9                 IPU_MEMORY_OFFSET+0x0040620,0x01FF0000
#define SRM_DI0_DW_SET3_9__DI0_DATA_CNT_UP3_9                   IPU_MEMORY_OFFSET+0x0040620,0x000001FF

#define SRM_DI0_DW_SET3_10__ADDR                                IPU_MEMORY_OFFSET+0x0040624
#define SRM_DI0_DW_SET3_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040624,0x00000000
#define SRM_DI0_DW_SET3_10__FULL                                IPU_MEMORY_OFFSET+0x0040624,0xffffffff
#define SRM_DI0_DW_SET3_10__DI0_DATA_CNT_DOWN3_10               IPU_MEMORY_OFFSET+0x0040624,0x01FF0000
#define SRM_DI0_DW_SET3_10__DI0_DATA_CNT_UP3_10                 IPU_MEMORY_OFFSET+0x0040624,0x000001FF

#define SRM_DI0_DW_SET3_11__ADDR                                IPU_MEMORY_OFFSET+0x0040628
#define SRM_DI0_DW_SET3_11__EMPTY                               IPU_MEMORY_OFFSET+0x0040628,0x00000000
#define SRM_DI0_DW_SET3_11__FULL                                IPU_MEMORY_OFFSET+0x0040628,0xffffffff
#define SRM_DI0_DW_SET3_11__DI0_DATA_CNT_DOWN3_11               IPU_MEMORY_OFFSET+0x0040628,0x01FF0000
#define SRM_DI0_DW_SET3_11__DI0_DATA_CNT_UP3_11                 IPU_MEMORY_OFFSET+0x0040628,0x000001FF

#define SRM_DI0_STP_REP_1__ADDR                                 IPU_MEMORY_OFFSET+0x004062C
#define SRM_DI0_STP_REP_1__EMPTY                                IPU_MEMORY_OFFSET+0x004062C,0x00000000
#define SRM_DI0_STP_REP_1__FULL                                 IPU_MEMORY_OFFSET+0x004062C,0xffffffff
#define SRM_DI0_STP_REP_1__DI0_STEP_REPEAT_2                    IPU_MEMORY_OFFSET+0x004062C,0x0FFF0000
#define SRM_DI0_STP_REP_1__DI0_STEP_REPEAT_1                    IPU_MEMORY_OFFSET+0x004062C,0x00000FFF

#define SRM_DI0_STP_REP_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040630
#define SRM_DI0_STP_REP_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040630,0x00000000
#define SRM_DI0_STP_REP_2__FULL                                 IPU_MEMORY_OFFSET+0x0040630,0xffffffff
#define SRM_DI0_STP_REP_2__DI0_STEP_REPEAT_4                    IPU_MEMORY_OFFSET+0x0040630,0x0FFF0000
#define SRM_DI0_STP_REP_2__DI0_STEP_REPEAT_3                    IPU_MEMORY_OFFSET+0x0040630,0x00000FFF

#define SRM_DI0_STP_REP_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040634
#define SRM_DI0_STP_REP_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040634,0x00000000
#define SRM_DI0_STP_REP_3__FULL                                 IPU_MEMORY_OFFSET+0x0040634,0xffffffff
#define SRM_DI0_STP_REP_3__DI0_STEP_REPEAT_6                    IPU_MEMORY_OFFSET+0x0040634,0x0FFF0000
#define SRM_DI0_STP_REP_3__DI0_STEP_REPEAT_5                    IPU_MEMORY_OFFSET+0x0040634,0x00000FFF

#define SRM_DI0_STP_REP_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040638
#define SRM_DI0_STP_REP_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040638,0x00000000
#define SRM_DI0_STP_REP_4__FULL                                 IPU_MEMORY_OFFSET+0x0040638,0xffffffff
#define SRM_DI0_STP_REP_4__DI0_STEP_REPEAT_8                    IPU_MEMORY_OFFSET+0x0040638,0x0FFF0000
#define SRM_DI0_STP_REP_4__DI0_STEP_REPEAT_7                    IPU_MEMORY_OFFSET+0x0040638,0x00000FFF

#define SRM_DI0_STP_REP_9__ADDR                                 IPU_MEMORY_OFFSET+0x004063C
#define SRM_DI0_STP_REP_9__EMPTY                                IPU_MEMORY_OFFSET+0x004063C,0x00000000
#define SRM_DI0_STP_REP_9__FULL                                 IPU_MEMORY_OFFSET+0x004063C,0xffffffff
#define SRM_DI0_STP_REP_9__DI0_STEP_REPEAT_9                    IPU_MEMORY_OFFSET+0x004063C,0x00000FFF

#define SRM_DI0_SER_CONF__ADDR                                  IPU_MEMORY_OFFSET+0x0040640
#define SRM_DI0_SER_CONF__EMPTY                                 IPU_MEMORY_OFFSET+0x0040640,0x00000000
#define SRM_DI0_SER_CONF__FULL                                  IPU_MEMORY_OFFSET+0x0040640,0xffffffff
#define SRM_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_R_1            IPU_MEMORY_OFFSET+0x0040640,0xF0000000
#define SRM_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_R_0            IPU_MEMORY_OFFSET+0x0040640,0x0F000000
#define SRM_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_W_1            IPU_MEMORY_OFFSET+0x0040640,0x00F00000
#define SRM_DI0_SER_CONF__DI0_SERIAL_LLA_PNTR_RS_W_0            IPU_MEMORY_OFFSET+0x0040640,0x000F0000
#define SRM_DI0_SER_CONF__DI0_SERIAL_LATCH                      IPU_MEMORY_OFFSET+0x0040640,0x0000FF00
#define SRM_DI0_SER_CONF__DI0_LLA_SER_ACCESS                    IPU_MEMORY_OFFSET+0x0040640,0x00000020
#define SRM_DI0_SER_CONF__DI0_SER_CLK_POLARITY                  IPU_MEMORY_OFFSET+0x0040640,0x00000010
#define SRM_DI0_SER_CONF__DI0_SERIAL_DATA_POLARITY              IPU_MEMORY_OFFSET+0x0040640,0x00000008
#define SRM_DI0_SER_CONF__DI0_SERIAL_RS_POLARITY                IPU_MEMORY_OFFSET+0x0040640,0x00000004
#define SRM_DI0_SER_CONF__DI0_SERIAL_CS_POLARITY                IPU_MEMORY_OFFSET+0x0040640,0x00000002
#define SRM_DI0_SER_CONF__DI0_WAIT4SERIAL                       IPU_MEMORY_OFFSET+0x0040640,0x00000001

#define SRM_DI0_SSC__ADDR                                       IPU_MEMORY_OFFSET+0x0040644
#define SRM_DI0_SSC__EMPTY                                      IPU_MEMORY_OFFSET+0x0040644,0x00000000
#define SRM_DI0_SSC__FULL                                       IPU_MEMORY_OFFSET+0x0040644,0xffffffff
#define SRM_DI0_SSC__DI0_PIN17_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00800000
#define SRM_DI0_SSC__DI0_PIN16_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00400000
#define SRM_DI0_SSC__DI0_PIN15_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00200000
#define SRM_DI0_SSC__DI0_PIN14_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00100000
#define SRM_DI0_SSC__DI0_PIN13_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00080000
#define SRM_DI0_SSC__DI0_PIN12_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00040000
#define SRM_DI0_SSC__DI0_PIN11_ERM                              IPU_MEMORY_OFFSET+0x0040644,0x00020000
#define SRM_DI0_SSC__DI0_CS_ERM                                 IPU_MEMORY_OFFSET+0x0040644,0x00010000
#define SRM_DI0_SSC__DI0_WAIT_ON                                IPU_MEMORY_OFFSET+0x0040644,0x00000020
#define SRM_DI0_SSC__DI0_BYTE_EN_RD_IN                          IPU_MEMORY_OFFSET+0x0040644,0x00000008
#define SRM_DI0_SSC__DI0_BYTE_EN_PNTR                           IPU_MEMORY_OFFSET+0x0040644,0x00000007

#define SRM_DI0_POL__ADDR                                       IPU_MEMORY_OFFSET+0x0040648
#define SRM_DI0_POL__EMPTY                                      IPU_MEMORY_OFFSET+0x0040648,0x00000000
#define SRM_DI0_POL__FULL                                       IPU_MEMORY_OFFSET+0x0040648,0xffffffff
#define SRM_DI0_POL__DI0_WAIT_POLARITY                          IPU_MEMORY_OFFSET+0x0040648,0x04000000
#define SRM_DI0_POL__DI0_CS1_BYTE_EN_POLARITY                   IPU_MEMORY_OFFSET+0x0040648,0x02000000
#define SRM_DI0_POL__DI0_CS0_BYTE_EN_POLARITY                   IPU_MEMORY_OFFSET+0x0040648,0x01000000
#define SRM_DI0_POL__DI0_CS1_DATA_POLARITY                      IPU_MEMORY_OFFSET+0x0040648,0x00800000
#define SRM_DI0_POL__DI0_CS1_POLARITY_17                        IPU_MEMORY_OFFSET+0x0040648,0x00400000
#define SRM_DI0_POL__DI0_CS1_POLARITY_16                        IPU_MEMORY_OFFSET+0x0040648,0x00200000
#define SRM_DI0_POL__DI0_CS1_POLARITY_15                        IPU_MEMORY_OFFSET+0x0040648,0x00100000
#define SRM_DI0_POL__DI0_CS1_POLARITY_14                        IPU_MEMORY_OFFSET+0x0040648,0x00080000
#define SRM_DI0_POL__DI0_CS1_POLARITY_13                        IPU_MEMORY_OFFSET+0x0040648,0x00040000
#define SRM_DI0_POL__DI0_CS1_POLARITY_12                        IPU_MEMORY_OFFSET+0x0040648,0x00020000
#define SRM_DI0_POL__DI0_CS1_POLARITY_11                        IPU_MEMORY_OFFSET+0x0040648,0x00010000
#define SRM_DI0_POL__DI0_CS0_DATA_POLARITY                      IPU_MEMORY_OFFSET+0x0040648,0x00008000
#define SRM_DI0_POL__DI0_CS0_POLARITY_17                        IPU_MEMORY_OFFSET+0x0040648,0x00004000
#define SRM_DI0_POL__DI0_CS0_POLARITY_16                        IPU_MEMORY_OFFSET+0x0040648,0x00002000
#define SRM_DI0_POL__DI0_CS0_POLARITY_15                        IPU_MEMORY_OFFSET+0x0040648,0x00001000
#define SRM_DI0_POL__DI0_CS0_POLARITY_14                        IPU_MEMORY_OFFSET+0x0040648,0x00000800
#define SRM_DI0_POL__DI0_CS0_POLARITY_13                        IPU_MEMORY_OFFSET+0x0040648,0x00000400
#define SRM_DI0_POL__DI0_CS0_POLARITY_12                        IPU_MEMORY_OFFSET+0x0040648,0x00000200
#define SRM_DI0_POL__DI0_CS0_POLARITY_11                        IPU_MEMORY_OFFSET+0x0040648,0x00000100
#define SRM_DI0_POL__DI0_DRDY_DATA_POLARITY                     IPU_MEMORY_OFFSET+0x0040648,0x00000080
#define SRM_DI0_POL__DI0_DRDY_POLARITY_17                       IPU_MEMORY_OFFSET+0x0040648,0x00000040
#define SRM_DI0_POL__DI0_DRDY_POLARITY_16                       IPU_MEMORY_OFFSET+0x0040648,0x00000020
#define SRM_DI0_POL__DI0_DRDY_POLARITY_15                       IPU_MEMORY_OFFSET+0x0040648,0x00000010
#define SRM_DI0_POL__DI0_DRDY_POLARITY_14                       IPU_MEMORY_OFFSET+0x0040648,0x00000008
#define SRM_DI0_POL__DI0_DRDY_POLARITY_13                       IPU_MEMORY_OFFSET+0x0040648,0x00000004
#define SRM_DI0_POL__DI0_DRDY_POLARITY_12                       IPU_MEMORY_OFFSET+0x0040648,0x00000002
#define SRM_DI0_POL__DI0_DRDY_POLARITY_11                       IPU_MEMORY_OFFSET+0x0040648,0x00000001

#define SRM_DI0_AW0__ADDR                                       IPU_MEMORY_OFFSET+0x004064C
#define SRM_DI0_AW0__EMPTY                                      IPU_MEMORY_OFFSET+0x004064C,0x00000000
#define SRM_DI0_AW0__FULL                                       IPU_MEMORY_OFFSET+0x004064C,0xffffffff
#define SRM_DI0_AW0__DI0_AW_TRIG_SEL                            IPU_MEMORY_OFFSET+0x004064C,0xF0000000
#define SRM_DI0_AW0__DI0_AW_HEND                                IPU_MEMORY_OFFSET+0x004064C,0x0FFF0000
#define SRM_DI0_AW0__DI0_AW_HCOUNT_SEL                          IPU_MEMORY_OFFSET+0x004064C,0x0000F000
#define SRM_DI0_AW0__DI0_AW_HSTART                              IPU_MEMORY_OFFSET+0x004064C,0x00000FFF

#define SRM_DI0_AW1__ADDR                                       IPU_MEMORY_OFFSET+0x0040650
#define SRM_DI0_AW1__EMPTY                                      IPU_MEMORY_OFFSET+0x0040650,0x00000000
#define SRM_DI0_AW1__FULL                                       IPU_MEMORY_OFFSET+0x0040650,0xffffffff
#define SRM_DI0_AW1__DI0_AW_VEND                                IPU_MEMORY_OFFSET+0x0040650,0x0FFF0000
#define SRM_DI0_AW1__DI0_AW_VCOUNT_SEL                          IPU_MEMORY_OFFSET+0x0040650,0x0000F000
#define SRM_DI0_AW1__DI0_AW_VSTART                              IPU_MEMORY_OFFSET+0x0040650,0x00000FFF

#define SRM_DI0_SCR_CONF__ADDR                                  IPU_MEMORY_OFFSET+0x0040654
#define SRM_DI0_SCR_CONF__EMPTY                                 IPU_MEMORY_OFFSET+0x0040654,0x00000000
#define SRM_DI0_SCR_CONF__FULL                                  IPU_MEMORY_OFFSET+0x0040654,0xffffffff
#define SRM_DI0_SCR_CONF__DI0_SCREEN_HEIGHT                     IPU_MEMORY_OFFSET+0x0040654,0x00000FFF

#define SRM_DI1_GENERAL__ADDR                                   IPU_MEMORY_OFFSET+0x0040658
#define SRM_DI1_GENERAL__EMPTY                                  IPU_MEMORY_OFFSET+0x0040658,0x00000000
#define SRM_DI1_GENERAL__FULL                                   IPU_MEMORY_OFFSET+0x0040658,0xffffffff
#define SRM_DI1_GENERAL__DI1_PIN8_PIN15_SEL                     IPU_MEMORY_OFFSET+0x0040658,0x80000000
#define SRM_DI1_GENERAL__DI1_DISP_Y_SEL                         IPU_MEMORY_OFFSET+0x0040658,0x70000000
#define SRM_DI1_GENERAL__DI1_CLOCK_STOP_MODE                    IPU_MEMORY_OFFSET+0x0040658,0x0F000000
#define SRM_DI1_GENERAL__DI1_DISP_CLOCK_INIT                    IPU_MEMORY_OFFSET+0x0040658,0x00800000
#define SRM_DI1_GENERAL__DI1_MASK_SEL                           IPU_MEMORY_OFFSET+0x0040658,0x00400000
#define SRM_DI1_GENERAL__DI1_VSYNC_EXT                          IPU_MEMORY_OFFSET+0x0040658,0x00200000
#define SRM_DI1_GENERAL__DI1_CLK_EXT                            IPU_MEMORY_OFFSET+0x0040658,0x00100000
#define SRM_DI1_GENERAL__DI1_WATCHDOG_MODE                      IPU_MEMORY_OFFSET+0x0040658,0x000C0000
#define SRM_DI1_GENERAL__DI1_POLARITY_DISP_CLK                  IPU_MEMORY_OFFSET+0x0040658,0x00020000
#define SRM_DI1_GENERAL__DI1_SYNC_COUNT_SEL                     IPU_MEMORY_OFFSET+0x0040658,0x0000F000
#define SRM_DI1_GENERAL__DI1_ERR_TREATMENT                      IPU_MEMORY_OFFSET+0x0040658,0x00000800
#define SRM_DI1_GENERAL__DI1_ERM_VSYNC_SEL                      IPU_MEMORY_OFFSET+0x0040658,0x00000400
#define SRM_DI1_GENERAL__DI1_POLARITY_CS1                       IPU_MEMORY_OFFSET+0x0040658,0x00000200
#define SRM_DI1_GENERAL__DI1_POLARITY_CS0                       IPU_MEMORY_OFFSET+0x0040658,0x00000100
#define SRM_DI1_GENERAL__DI1_POLARITY_8                         IPU_MEMORY_OFFSET+0x0040658,0x00000080
#define SRM_DI1_GENERAL__DI1_POLARITY_7                         IPU_MEMORY_OFFSET+0x0040658,0x00000040
#define SRM_DI1_GENERAL__DI1_POLARITY_6                         IPU_MEMORY_OFFSET+0x0040658,0x00000020
#define SRM_DI1_GENERAL__DI1_POLARITY_5                         IPU_MEMORY_OFFSET+0x0040658,0x00000010
#define SRM_DI1_GENERAL__DI1_POLARITY_4                         IPU_MEMORY_OFFSET+0x0040658,0x00000008
#define SRM_DI1_GENERAL__DI1_POLARITY_3                         IPU_MEMORY_OFFSET+0x0040658,0x00000004
#define SRM_DI1_GENERAL__DI1_POLARITY_2                         IPU_MEMORY_OFFSET+0x0040658,0x00000002
#define SRM_DI1_GENERAL__DI1_POLARITY_1                         IPU_MEMORY_OFFSET+0x0040658,0x00000001

#define SRM_DI1_BS_CLKGEN0__ADDR                                IPU_MEMORY_OFFSET+0x004065C
#define SRM_DI1_BS_CLKGEN0__EMPTY                               IPU_MEMORY_OFFSET+0x004065C,0x00000000
#define SRM_DI1_BS_CLKGEN0__FULL                                IPU_MEMORY_OFFSET+0x004065C,0xffffffff
#define SRM_DI1_BS_CLKGEN0__DI1_DISP_CLK_OFFSET                 IPU_MEMORY_OFFSET+0x004065C,0x01FF0000
#define SRM_DI1_BS_CLKGEN0__DI1_DISP_CLK_PERIOD                 IPU_MEMORY_OFFSET+0x004065C,0x00000FFF

#define SRM_DI1_BS_CLKGEN1__ADDR                                IPU_MEMORY_OFFSET+0x0040660
#define SRM_DI1_BS_CLKGEN1__EMPTY                               IPU_MEMORY_OFFSET+0x0040660,0x00000000
#define SRM_DI1_BS_CLKGEN1__FULL                                IPU_MEMORY_OFFSET+0x0040660,0xffffffff
#define SRM_DI1_BS_CLKGEN1__DI1_DISP_CLK_DOWN                   IPU_MEMORY_OFFSET+0x0040660,0x01FF0000
#define SRM_DI1_BS_CLKGEN1__DI1_DISP_CLK_UP                     IPU_MEMORY_OFFSET+0x0040660,0x000001FF

#define SRM_DI1_SW_GEN0_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040664
#define SRM_DI1_SW_GEN0_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040664,0x00000000
#define SRM_DI1_SW_GEN0_1__FULL                                 IPU_MEMORY_OFFSET+0x0040664,0xffffffff
#define SRM_DI1_SW_GEN0_1__DI1_RUN_VALUE_M1_1                   IPU_MEMORY_OFFSET+0x0040664,0x7FF80000
#define SRM_DI1_SW_GEN0_1__DI1_RUN_RESOLUTION_1                 IPU_MEMORY_OFFSET+0x0040664,0x00070000
#define SRM_DI1_SW_GEN0_1__DI1_OFFSET_VALUE_1                   IPU_MEMORY_OFFSET+0x0040664,0x00007FF8
#define SRM_DI1_SW_GEN0_1__DI1_OFFSET_RESOLUTION_1              IPU_MEMORY_OFFSET+0x0040664,0x00000007

#define SRM_DI1_SW_GEN0_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040668
#define SRM_DI1_SW_GEN0_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040668,0x00000000
#define SRM_DI1_SW_GEN0_2__FULL                                 IPU_MEMORY_OFFSET+0x0040668,0xffffffff
#define SRM_DI1_SW_GEN0_2__DI1_RUN_VALUE_M1_2                   IPU_MEMORY_OFFSET+0x0040668,0x7FF80000
#define SRM_DI1_SW_GEN0_2__DI1_RUN_RESOLUTION_2                 IPU_MEMORY_OFFSET+0x0040668,0x00070000
#define SRM_DI1_SW_GEN0_2__DI1_OFFSET_VALUE_2                   IPU_MEMORY_OFFSET+0x0040668,0x00007FF8
#define SRM_DI1_SW_GEN0_2__DI1_OFFSET_RESOLUTION_2              IPU_MEMORY_OFFSET+0x0040668,0x00000007

#define SRM_DI1_SW_GEN0_3__ADDR                                 IPU_MEMORY_OFFSET+0x004066C
#define SRM_DI1_SW_GEN0_3__EMPTY                                IPU_MEMORY_OFFSET+0x004066C,0x00000000
#define SRM_DI1_SW_GEN0_3__FULL                                 IPU_MEMORY_OFFSET+0x004066C,0xffffffff
#define SRM_DI1_SW_GEN0_3__DI1_RUN_VALUE_M1_3                   IPU_MEMORY_OFFSET+0x004066C,0x7FF80000
#define SRM_DI1_SW_GEN0_3__DI1_RUN_RESOLUTION_3                 IPU_MEMORY_OFFSET+0x004066C,0x00070000
#define SRM_DI1_SW_GEN0_3__DI1_OFFSET_VALUE_3                   IPU_MEMORY_OFFSET+0x004066C,0x00007FF8
#define SRM_DI1_SW_GEN0_3__DI1_OFFSET_RESOLUTION_3              IPU_MEMORY_OFFSET+0x004066C,0x00000007

#define SRM_DI1_SW_GEN0_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040670
#define SRM_DI1_SW_GEN0_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040670,0x00000000
#define SRM_DI1_SW_GEN0_4__FULL                                 IPU_MEMORY_OFFSET+0x0040670,0xffffffff
#define SRM_DI1_SW_GEN0_4__DI1_RUN_VALUE_M1_4                   IPU_MEMORY_OFFSET+0x0040670,0x7FF80000
#define SRM_DI1_SW_GEN0_4__DI1_RUN_RESOLUTION_4                 IPU_MEMORY_OFFSET+0x0040670,0x00070000
#define SRM_DI1_SW_GEN0_4__DI1_OFFSET_VALUE_4                   IPU_MEMORY_OFFSET+0x0040670,0x00007FF8
#define SRM_DI1_SW_GEN0_4__DI1_OFFSET_RESOLUTION_4              IPU_MEMORY_OFFSET+0x0040670,0x00000007

#define SRM_DI1_SW_GEN0_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040674
#define SRM_DI1_SW_GEN0_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040674,0x00000000
#define SRM_DI1_SW_GEN0_5__FULL                                 IPU_MEMORY_OFFSET+0x0040674,0xffffffff
#define SRM_DI1_SW_GEN0_5__DI1_RUN_VALUE_M1_5                   IPU_MEMORY_OFFSET+0x0040674,0x7FF80000
#define SRM_DI1_SW_GEN0_5__DI1_RUN_RESOLUTION_5                 IPU_MEMORY_OFFSET+0x0040674,0x00070000
#define SRM_DI1_SW_GEN0_5__DI1_OFFSET_VALUE_5                   IPU_MEMORY_OFFSET+0x0040674,0x00007FF8
#define SRM_DI1_SW_GEN0_5__DI1_OFFSET_RESOLUTION_5              IPU_MEMORY_OFFSET+0x0040674,0x00000007

#define SRM_DI1_SW_GEN0_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040678
#define SRM_DI1_SW_GEN0_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040678,0x00000000
#define SRM_DI1_SW_GEN0_6__FULL                                 IPU_MEMORY_OFFSET+0x0040678,0xffffffff
#define SRM_DI1_SW_GEN0_6__DI1_RUN_VALUE_M1_6                   IPU_MEMORY_OFFSET+0x0040678,0x7FF80000
#define SRM_DI1_SW_GEN0_6__DI1_RUN_RESOLUTION_6                 IPU_MEMORY_OFFSET+0x0040678,0x00070000
#define SRM_DI1_SW_GEN0_6__DI1_OFFSET_VALUE_6                   IPU_MEMORY_OFFSET+0x0040678,0x00007FF8
#define SRM_DI1_SW_GEN0_6__DI1_OFFSET_RESOLUTION_6              IPU_MEMORY_OFFSET+0x0040678,0x00000007

#define SRM_DI1_SW_GEN0_7__ADDR                                 IPU_MEMORY_OFFSET+0x004067C
#define SRM_DI1_SW_GEN0_7__EMPTY                                IPU_MEMORY_OFFSET+0x004067C,0x00000000
#define SRM_DI1_SW_GEN0_7__FULL                                 IPU_MEMORY_OFFSET+0x004067C,0xffffffff
#define SRM_DI1_SW_GEN0_7__DI1_RUN_VALUE_M1_7                   IPU_MEMORY_OFFSET+0x004067C,0x7FF80000
#define SRM_DI1_SW_GEN0_7__DI1_RUN_RESOLUTION_7                 IPU_MEMORY_OFFSET+0x004067C,0x00070000
#define SRM_DI1_SW_GEN0_7__DI1_OFFSET_VALUE_7                   IPU_MEMORY_OFFSET+0x004067C,0x00007FF8
#define SRM_DI1_SW_GEN0_7__DI1_OFFSET_RESOLUTION_7              IPU_MEMORY_OFFSET+0x004067C,0x00000007

#define SRM_DI1_SW_GEN0_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040680
#define SRM_DI1_SW_GEN0_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040680,0x00000000
#define SRM_DI1_SW_GEN0_8__FULL                                 IPU_MEMORY_OFFSET+0x0040680,0xffffffff
#define SRM_DI1_SW_GEN0_8__DI1_RUN_VALUE_M1_8                   IPU_MEMORY_OFFSET+0x0040680,0x7FF80000
#define SRM_DI1_SW_GEN0_8__DI1_RUN_RESOLUTION_8                 IPU_MEMORY_OFFSET+0x0040680,0x00070000
#define SRM_DI1_SW_GEN0_8__DI1_OFFSET_VALUE_8                   IPU_MEMORY_OFFSET+0x0040680,0x00007FF8
#define SRM_DI1_SW_GEN0_8__DI1_OFFSET_RESOLUTION_8              IPU_MEMORY_OFFSET+0x0040680,0x00000007

#define SRM_DI1_SW_GEN0_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040684
#define SRM_DI1_SW_GEN0_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040684,0x00000000
#define SRM_DI1_SW_GEN0_9__FULL                                 IPU_MEMORY_OFFSET+0x0040684,0xffffffff
#define SRM_DI1_SW_GEN0_9__DI1_RUN_VALUE_M1_9                   IPU_MEMORY_OFFSET+0x0040684,0x7FF80000
#define SRM_DI1_SW_GEN0_9__DI1_RUN_RESOLUTION_9                 IPU_MEMORY_OFFSET+0x0040684,0x00070000
#define SRM_DI1_SW_GEN0_9__DI1_OFFSET_VALUE_9                   IPU_MEMORY_OFFSET+0x0040684,0x00007FF8
#define SRM_DI1_SW_GEN0_9__DI1_OFFSET_RESOLUTION_9              IPU_MEMORY_OFFSET+0x0040684,0x00000007

#define SRM_DI1_SW_GEN1_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040688
#define SRM_DI1_SW_GEN1_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040688,0x00000000
#define SRM_DI1_SW_GEN1_1__FULL                                 IPU_MEMORY_OFFSET+0x0040688,0xffffffff
#define SRM_DI1_SW_GEN1_1__DI1_CNT_POLARITY_GEN_EN_1            IPU_MEMORY_OFFSET+0x0040688,0x60000000
#define SRM_DI1_SW_GEN1_1__DI1_CNT_AUTO_RELOAD_1                IPU_MEMORY_OFFSET+0x0040688,0x10000000
#define SRM_DI1_SW_GEN1_1__DI1_CNT_CLR_SEL_1                    IPU_MEMORY_OFFSET+0x0040688,0x0E000000
#define SRM_DI1_SW_GEN1_1__DI1_CNT_DOWN_1                       IPU_MEMORY_OFFSET+0x0040688,0x01FF0000
#define SRM_DI1_SW_GEN1_1__DI1_CNT_POLARITY_TRIGGER_SEL_1       IPU_MEMORY_OFFSET+0x0040688,0x00007000
#define SRM_DI1_SW_GEN1_1__DI1_CNT_POLARITY_CLR_SEL_1           IPU_MEMORY_OFFSET+0x0040688,0x00000E00
#define SRM_DI1_SW_GEN1_1__DI1_CNT_UP_1                         IPU_MEMORY_OFFSET+0x0040688,0x000001FF

#define SRM_DI1_SW_GEN1_2__ADDR                                 IPU_MEMORY_OFFSET+0x004068C
#define SRM_DI1_SW_GEN1_2__EMPTY                                IPU_MEMORY_OFFSET+0x004068C,0x00000000
#define SRM_DI1_SW_GEN1_2__FULL                                 IPU_MEMORY_OFFSET+0x004068C,0xffffffff
#define SRM_DI1_SW_GEN1_2__DI1_CNT_POLARITY_GEN_EN_2            IPU_MEMORY_OFFSET+0x004068C,0x60000000
#define SRM_DI1_SW_GEN1_2__DI1_CNT_AUTO_RELOAD_2                IPU_MEMORY_OFFSET+0x004068C,0x10000000
#define SRM_DI1_SW_GEN1_2__DI1_CNT_CLR_SEL_2                    IPU_MEMORY_OFFSET+0x004068C,0x0E000000
#define SRM_DI1_SW_GEN1_2__DI1_CNT_DOWN_2                       IPU_MEMORY_OFFSET+0x004068C,0x01FF0000
#define SRM_DI1_SW_GEN1_2__DI1_CNT_POLARITY_TRIGGER_SEL_2       IPU_MEMORY_OFFSET+0x004068C,0x00007000
#define SRM_DI1_SW_GEN1_2__DI1_CNT_POLARITY_CLR_SEL_2           IPU_MEMORY_OFFSET+0x004068C,0x00000E00
#define SRM_DI1_SW_GEN1_2__DI1_CNT_UP_2                         IPU_MEMORY_OFFSET+0x004068C,0x000001FF

#define SRM_DI1_SW_GEN1_3__ADDR                                 IPU_MEMORY_OFFSET+0x0040690
#define SRM_DI1_SW_GEN1_3__EMPTY                                IPU_MEMORY_OFFSET+0x0040690,0x00000000
#define SRM_DI1_SW_GEN1_3__FULL                                 IPU_MEMORY_OFFSET+0x0040690,0xffffffff
#define SRM_DI1_SW_GEN1_3__DI1_CNT_POLARITY_GEN_EN_3            IPU_MEMORY_OFFSET+0x0040690,0x60000000
#define SRM_DI1_SW_GEN1_3__DI1_CNT_AUTO_RELOAD_3                IPU_MEMORY_OFFSET+0x0040690,0x10000000
#define SRM_DI1_SW_GEN1_3__DI1_CNT_CLR_SEL_3                    IPU_MEMORY_OFFSET+0x0040690,0x0E000000
#define SRM_DI1_SW_GEN1_3__DI1_CNT_DOWN_3                       IPU_MEMORY_OFFSET+0x0040690,0x01FF0000
#define SRM_DI1_SW_GEN1_3__DI1_CNT_POLARITY_TRIGGER_SEL_3       IPU_MEMORY_OFFSET+0x0040690,0x00007000
#define SRM_DI1_SW_GEN1_3__DI1_CNT_POLARITY_CLR_SEL_3           IPU_MEMORY_OFFSET+0x0040690,0x00000E00
#define SRM_DI1_SW_GEN1_3__DI1_CNT_UP_3                         IPU_MEMORY_OFFSET+0x0040690,0x000001FF

#define SRM_DI1_SW_GEN1_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040694
#define SRM_DI1_SW_GEN1_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040694,0x00000000
#define SRM_DI1_SW_GEN1_4__FULL                                 IPU_MEMORY_OFFSET+0x0040694,0xffffffff
#define SRM_DI1_SW_GEN1_4__DI1_CNT_POLARITY_GEN_EN_4            IPU_MEMORY_OFFSET+0x0040694,0x60000000
#define SRM_DI1_SW_GEN1_4__DI1_CNT_AUTO_RELOAD_4                IPU_MEMORY_OFFSET+0x0040694,0x10000000
#define SRM_DI1_SW_GEN1_4__DI1_CNT_CLR_SEL_4                    IPU_MEMORY_OFFSET+0x0040694,0x0E000000
#define SRM_DI1_SW_GEN1_4__DI1_CNT_DOWN_4                       IPU_MEMORY_OFFSET+0x0040694,0x01FF0000
#define SRM_DI1_SW_GEN1_4__DI1_CNT_POLARITY_TRIGGER_SEL_4       IPU_MEMORY_OFFSET+0x0040694,0x00007000
#define SRM_DI1_SW_GEN1_4__DI1_CNT_POLARITY_CLR_SEL_4           IPU_MEMORY_OFFSET+0x0040694,0x00000E00
#define SRM_DI1_SW_GEN1_4__DI1_CNT_UP_4                         IPU_MEMORY_OFFSET+0x0040694,0x000001FF

#define SRM_DI1_SW_GEN1_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040698
#define SRM_DI1_SW_GEN1_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040698,0x00000000
#define SRM_DI1_SW_GEN1_5__FULL                                 IPU_MEMORY_OFFSET+0x0040698,0xffffffff
#define SRM_DI1_SW_GEN1_5__DI1_CNT_POLARITY_GEN_EN_5            IPU_MEMORY_OFFSET+0x0040698,0x60000000
#define SRM_DI1_SW_GEN1_5__DI1_CNT_AUTO_RELOAD_5                IPU_MEMORY_OFFSET+0x0040698,0x10000000
#define SRM_DI1_SW_GEN1_5__DI1_CNT_CLR_SEL_5                    IPU_MEMORY_OFFSET+0x0040698,0x0E000000
#define SRM_DI1_SW_GEN1_5__DI1_CNT_DOWN_5                       IPU_MEMORY_OFFSET+0x0040698,0x01FF0000
#define SRM_DI1_SW_GEN1_5__DI1_CNT_POLARITY_TRIGGER_SEL_5       IPU_MEMORY_OFFSET+0x0040698,0x00007000
#define SRM_DI1_SW_GEN1_5__DI1_CNT_POLARITY_CLR_SEL_5           IPU_MEMORY_OFFSET+0x0040698,0x00000E00
#define SRM_DI1_SW_GEN1_5__DI1_CNT_UP_5                         IPU_MEMORY_OFFSET+0x0040698,0x000001FF

#define SRM_DI1_SW_GEN1_6__ADDR                                 IPU_MEMORY_OFFSET+0x004069C
#define SRM_DI1_SW_GEN1_6__EMPTY                                IPU_MEMORY_OFFSET+0x004069C,0x00000000
#define SRM_DI1_SW_GEN1_6__FULL                                 IPU_MEMORY_OFFSET+0x004069C,0xffffffff
#define SRM_DI1_SW_GEN1_6__DI1_CNT_POLARITY_GEN_EN_6            IPU_MEMORY_OFFSET+0x004069C,0x60000000
#define SRM_DI1_SW_GEN1_6__DI1_CNT_AUTO_RELOAD_6                IPU_MEMORY_OFFSET+0x004069C,0x10000000
#define SRM_DI1_SW_GEN1_6__DI1_CNT_CLR_SEL_6                    IPU_MEMORY_OFFSET+0x004069C,0x0E000000
#define SRM_DI1_SW_GEN1_6__DI1_CNT_DOWN_6                       IPU_MEMORY_OFFSET+0x004069C,0x01FF0000
#define SRM_DI1_SW_GEN1_6__DI1_CNT_POLARITY_TRIGGER_SEL_6       IPU_MEMORY_OFFSET+0x004069C,0x00007000
#define SRM_DI1_SW_GEN1_6__DI1_CNT_POLARITY_CLR_SEL_6           IPU_MEMORY_OFFSET+0x004069C,0x00000E00
#define SRM_DI1_SW_GEN1_6__DI1_CNT_UP_6                         IPU_MEMORY_OFFSET+0x004069C,0x000001FF

#define SRM_DI1_SW_GEN1_7__ADDR                                 IPU_MEMORY_OFFSET+0x00406A0
#define SRM_DI1_SW_GEN1_7__EMPTY                                IPU_MEMORY_OFFSET+0x00406A0,0x00000000
#define SRM_DI1_SW_GEN1_7__FULL                                 IPU_MEMORY_OFFSET+0x00406A0,0xffffffff
#define SRM_DI1_SW_GEN1_7__DI1_CNT_POLARITY_GEN_EN_7            IPU_MEMORY_OFFSET+0x00406A0,0x60000000
#define SRM_DI1_SW_GEN1_7__DI1_CNT_AUTO_RELOAD_7                IPU_MEMORY_OFFSET+0x00406A0,0x10000000
#define SRM_DI1_SW_GEN1_7__DI1_CNT_CLR_SEL_7                    IPU_MEMORY_OFFSET+0x00406A0,0x0E000000
#define SRM_DI1_SW_GEN1_7__DI1_CNT_DOWN_7                       IPU_MEMORY_OFFSET+0x00406A0,0x01FF0000
#define SRM_DI1_SW_GEN1_7__DI1_CNT_POLARITY_TRIGGER_SEL_7       IPU_MEMORY_OFFSET+0x00406A0,0x00007000
#define SRM_DI1_SW_GEN1_7__DI1_CNT_POLARITY_CLR_SEL_7           IPU_MEMORY_OFFSET+0x00406A0,0x00000E00
#define SRM_DI1_SW_GEN1_7__DI1_CNT_UP_7                         IPU_MEMORY_OFFSET+0x00406A0,0x000001FF

#define SRM_DI1_SW_GEN1_8__ADDR                                 IPU_MEMORY_OFFSET+0x00406A4
#define SRM_DI1_SW_GEN1_8__EMPTY                                IPU_MEMORY_OFFSET+0x00406A4,0x00000000
#define SRM_DI1_SW_GEN1_8__FULL                                 IPU_MEMORY_OFFSET+0x00406A4,0xffffffff
#define SRM_DI1_SW_GEN1_8__DI1_CNT_POLARITY_GEN_EN_8            IPU_MEMORY_OFFSET+0x00406A4,0x60000000
#define SRM_DI1_SW_GEN1_8__DI1_CNT_AUTO_RELOAD_8                IPU_MEMORY_OFFSET+0x00406A4,0x10000000
#define SRM_DI1_SW_GEN1_8__DI1_CNT_CLR_SEL_8                    IPU_MEMORY_OFFSET+0x00406A4,0x0E000000
#define SRM_DI1_SW_GEN1_8__DI1_CNT_DOWN_8                       IPU_MEMORY_OFFSET+0x00406A4,0x01FF0000
#define SRM_DI1_SW_GEN1_8__DI1_CNT_POLARITY_TRIGGER_SEL_8       IPU_MEMORY_OFFSET+0x00406A4,0x00007000
#define SRM_DI1_SW_GEN1_8__DI1_CNT_POLARITY_CLR_SEL_8           IPU_MEMORY_OFFSET+0x00406A4,0x00000E00
#define SRM_DI1_SW_GEN1_8__DI1_CNT_UP_8                         IPU_MEMORY_OFFSET+0x00406A4,0x000001FF

#define SRM_DI1_SW_GEN1_9__ADDR                                 IPU_MEMORY_OFFSET+0x00406A8
#define SRM_DI1_SW_GEN1_9__EMPTY                                IPU_MEMORY_OFFSET+0x00406A8,0x00000000
#define SRM_DI1_SW_GEN1_9__FULL                                 IPU_MEMORY_OFFSET+0x00406A8,0xffffffff
#define SRM_DI1_SW_GEN1_9__DI1_GENTIME_SEL_9                    IPU_MEMORY_OFFSET+0x00406A8,0xE0000000
#define SRM_DI1_SW_GEN1_9__DI1_CNT_AUTO_RELOAD_9                IPU_MEMORY_OFFSET+0x00406A8,0x10000000
#define SRM_DI1_SW_GEN1_9__DI1_CNT_CLR_SEL_9                    IPU_MEMORY_OFFSET+0x00406A8,0x0E000000
#define SRM_DI1_SW_GEN1_9__DI1_CNT_DOWN_9                       IPU_MEMORY_OFFSET+0x00406A8,0x01FF0000
#define SRM_DI1_SW_GEN1_9__DI1_TAG_SEL_9                        IPU_MEMORY_OFFSET+0x00406A8,0x00008000
#define SRM_DI1_SW_GEN1_9__DI1_CNT_UP_9                         IPU_MEMORY_OFFSET+0x00406A8,0x000001FF

#define SRM_DI1_SYNC_AS_GEN__ADDR                               IPU_MEMORY_OFFSET+0x00406AC
#define SRM_DI1_SYNC_AS_GEN__EMPTY                              IPU_MEMORY_OFFSET+0x00406AC,0x00000000
#define SRM_DI1_SYNC_AS_GEN__FULL                               IPU_MEMORY_OFFSET+0x00406AC,0xffffffff
#define SRM_DI1_SYNC_AS_GEN__DI1_SYNC_START_EN                  IPU_MEMORY_OFFSET+0x00406AC,0x10000000
#define SRM_DI1_SYNC_AS_GEN__DI1_VSYNC_SEL                      IPU_MEMORY_OFFSET+0x00406AC,0x0000E000
#define SRM_DI1_SYNC_AS_GEN__DI1_SYNC_START                     IPU_MEMORY_OFFSET+0x00406AC,0x00000FFF

#define SRM_DI1_DW_GEN_0__ADDR                                  IPU_MEMORY_OFFSET+0x00406B0
#define SRM_DI1_DW_GEN_0__EMPTY                                 IPU_MEMORY_OFFSET+0x00406B0,0x00000000
#define SRM_DI1_DW_GEN_0__FULL                                  IPU_MEMORY_OFFSET+0x00406B0,0xffffffff
#define SRM_DI1_DW_GEN_0__DI1_ACCESS_SIZE_0                     IPU_MEMORY_OFFSET+0x00406B0,0xFF000000
#define SRM_DI1_DW_GEN_0__DI1_COMPONNENT_SIZE_0                 IPU_MEMORY_OFFSET+0x00406B0,0x00FF0000
#define SRM_DI1_DW_GEN_0__DI1_CST_0                             IPU_MEMORY_OFFSET+0x00406B0,0x0000C000
#define SRM_DI1_DW_GEN_0__DI1_PT_6_0                            IPU_MEMORY_OFFSET+0x00406B0,0x00003000
#define SRM_DI1_DW_GEN_0__DI1_PT_5_0                            IPU_MEMORY_OFFSET+0x00406B0,0x00000C00
#define SRM_DI1_DW_GEN_0__DI1_PT_4_0                            IPU_MEMORY_OFFSET+0x00406B0,0x00000300
#define SRM_DI1_DW_GEN_0__DI1_PT_3_0                            IPU_MEMORY_OFFSET+0x00406B0,0x000000C0
#define SRM_DI1_DW_GEN_0__DI1_PT_2_0                            IPU_MEMORY_OFFSET+0x00406B0,0x00000030
#define SRM_DI1_DW_GEN_0__DI1_PT_1_0                            IPU_MEMORY_OFFSET+0x00406B0,0x0000000C
#define SRM_DI1_DW_GEN_0__DI1_PT_0_0                            IPU_MEMORY_OFFSET+0x00406B0,0x00000003

#define SRM_DI1_DW_GEN_1__ADDR                                  IPU_MEMORY_OFFSET+0x00406B4
#define SRM_DI1_DW_GEN_1__EMPTY                                 IPU_MEMORY_OFFSET+0x00406B4,0x00000000
#define SRM_DI1_DW_GEN_1__FULL                                  IPU_MEMORY_OFFSET+0x00406B4,0xffffffff
#define SRM_DI1_DW_GEN_1__DI1_ACCESS_SIZE_1                     IPU_MEMORY_OFFSET+0x00406B4,0xFF000000
#define SRM_DI1_DW_GEN_1__DI1_COMPONNENT_SIZE_1                 IPU_MEMORY_OFFSET+0x00406B4,0x00FF0000
#define SRM_DI1_DW_GEN_1__DI1_CST_1                             IPU_MEMORY_OFFSET+0x00406B4,0x0000C000
#define SRM_DI1_DW_GEN_1__DI1_PT_6_1                            IPU_MEMORY_OFFSET+0x00406B4,0x00003000
#define SRM_DI1_DW_GEN_1__DI1_PT_5_1                            IPU_MEMORY_OFFSET+0x00406B4,0x00000C00
#define SRM_DI1_DW_GEN_1__DI1_PT_4_1                            IPU_MEMORY_OFFSET+0x00406B4,0x00000300
#define SRM_DI1_DW_GEN_1__DI1_PT_3_1                            IPU_MEMORY_OFFSET+0x00406B4,0x000000C0
#define SRM_DI1_DW_GEN_1__DI1_PT_2_1                            IPU_MEMORY_OFFSET+0x00406B4,0x00000030
#define SRM_DI1_DW_GEN_1__DI1_PT_1_1                            IPU_MEMORY_OFFSET+0x00406B4,0x0000000C
#define SRM_DI1_DW_GEN_1__DI1_PT_0_1                            IPU_MEMORY_OFFSET+0x00406B4,0x00000003

#define SRM_DI1_DW_GEN_2__ADDR                                  IPU_MEMORY_OFFSET+0x00406B8
#define SRM_DI1_DW_GEN_2__EMPTY                                 IPU_MEMORY_OFFSET+0x00406B8,0x00000000
#define SRM_DI1_DW_GEN_2__FULL                                  IPU_MEMORY_OFFSET+0x00406B8,0xffffffff
#define SRM_DI1_DW_GEN_2__DI1_ACCESS_SIZE_2                     IPU_MEMORY_OFFSET+0x00406B8,0xFF000000
#define SRM_DI1_DW_GEN_2__DI1_COMPONNENT_SIZE_2                 IPU_MEMORY_OFFSET+0x00406B8,0x00FF0000
#define SRM_DI1_DW_GEN_2__DI1_CST_2                             IPU_MEMORY_OFFSET+0x00406B8,0x0000C000
#define SRM_DI1_DW_GEN_2__DI1_PT_6_2                            IPU_MEMORY_OFFSET+0x00406B8,0x00003000
#define SRM_DI1_DW_GEN_2__DI1_PT_5_2                            IPU_MEMORY_OFFSET+0x00406B8,0x00000C00
#define SRM_DI1_DW_GEN_2__DI1_PT_4_2                            IPU_MEMORY_OFFSET+0x00406B8,0x00000300
#define SRM_DI1_DW_GEN_2__DI1_PT_3_2                            IPU_MEMORY_OFFSET+0x00406B8,0x000000C0
#define SRM_DI1_DW_GEN_2__DI1_PT_2_2                            IPU_MEMORY_OFFSET+0x00406B8,0x00000030
#define SRM_DI1_DW_GEN_2__DI1_PT_1_2                            IPU_MEMORY_OFFSET+0x00406B8,0x0000000C
#define SRM_DI1_DW_GEN_2__DI1_PT_0_2                            IPU_MEMORY_OFFSET+0x00406B8,0x00000003

#define SRM_DI1_DW_GEN_3__ADDR                                  IPU_MEMORY_OFFSET+0x00406BC
#define SRM_DI1_DW_GEN_3__EMPTY                                 IPU_MEMORY_OFFSET+0x00406BC,0x00000000
#define SRM_DI1_DW_GEN_3__FULL                                  IPU_MEMORY_OFFSET+0x00406BC,0xffffffff
#define SRM_DI1_DW_GEN_3__DI1_ACCESS_SIZE_3                     IPU_MEMORY_OFFSET+0x00406BC,0xFF000000
#define SRM_DI1_DW_GEN_3__DI1_COMPONNENT_SIZE_3                 IPU_MEMORY_OFFSET+0x00406BC,0x00FF0000
#define SRM_DI1_DW_GEN_3__DI1_CST_3                             IPU_MEMORY_OFFSET+0x00406BC,0x0000C000
#define SRM_DI1_DW_GEN_3__DI1_PT_6_3                            IPU_MEMORY_OFFSET+0x00406BC,0x00003000
#define SRM_DI1_DW_GEN_3__DI1_PT_5_3                            IPU_MEMORY_OFFSET+0x00406BC,0x00000C00
#define SRM_DI1_DW_GEN_3__DI1_PT_4_3                            IPU_MEMORY_OFFSET+0x00406BC,0x00000300
#define SRM_DI1_DW_GEN_3__DI1_PT_3_3                            IPU_MEMORY_OFFSET+0x00406BC,0x000000C0
#define SRM_DI1_DW_GEN_3__DI1_PT_2_3                            IPU_MEMORY_OFFSET+0x00406BC,0x00000030
#define SRM_DI1_DW_GEN_3__DI1_PT_1_3                            IPU_MEMORY_OFFSET+0x00406BC,0x0000000C
#define SRM_DI1_DW_GEN_3__DI1_PT_0_3                            IPU_MEMORY_OFFSET+0x00406BC,0x00000003

#define SRM_DI1_DW_GEN_4__ADDR                                  IPU_MEMORY_OFFSET+0x00406C0
#define SRM_DI1_DW_GEN_4__EMPTY                                 IPU_MEMORY_OFFSET+0x00406C0,0x00000000
#define SRM_DI1_DW_GEN_4__FULL                                  IPU_MEMORY_OFFSET+0x00406C0,0xffffffff
#define SRM_DI1_DW_GEN_4__DI1_ACCESS_SIZE_4                     IPU_MEMORY_OFFSET+0x00406C0,0xFF000000
#define SRM_DI1_DW_GEN_4__DI1_COMPONNENT_SIZE_4                 IPU_MEMORY_OFFSET+0x00406C0,0x00FF0000
#define SRM_DI1_DW_GEN_4__DI1_CST_4                             IPU_MEMORY_OFFSET+0x00406C0,0x0000C000
#define SRM_DI1_DW_GEN_4__DI1_PT_6_4                            IPU_MEMORY_OFFSET+0x00406C0,0x00003000
#define SRM_DI1_DW_GEN_4__DI1_PT_5_4                            IPU_MEMORY_OFFSET+0x00406C0,0x00000C00
#define SRM_DI1_DW_GEN_4__DI1_PT_4_4                            IPU_MEMORY_OFFSET+0x00406C0,0x00000300
#define SRM_DI1_DW_GEN_4__DI1_PT_3_4                            IPU_MEMORY_OFFSET+0x00406C0,0x000000C0
#define SRM_DI1_DW_GEN_4__DI1_PT_2_4                            IPU_MEMORY_OFFSET+0x00406C0,0x00000030
#define SRM_DI1_DW_GEN_4__DI1_PT_1_4                            IPU_MEMORY_OFFSET+0x00406C0,0x0000000C
#define SRM_DI1_DW_GEN_4__DI1_PT_0_4                            IPU_MEMORY_OFFSET+0x00406C0,0x00000003

#define SRM_DI1_DW_GEN_5__ADDR                                  IPU_MEMORY_OFFSET+0x00406C4
#define SRM_DI1_DW_GEN_5__EMPTY                                 IPU_MEMORY_OFFSET+0x00406C4,0x00000000
#define SRM_DI1_DW_GEN_5__FULL                                  IPU_MEMORY_OFFSET+0x00406C4,0xffffffff
#define SRM_DI1_DW_GEN_5__DI1_ACCESS_SIZE_5                     IPU_MEMORY_OFFSET+0x00406C4,0xFF000000
#define SRM_DI1_DW_GEN_5__DI1_COMPONNENT_SIZE_5                 IPU_MEMORY_OFFSET+0x00406C4,0x00FF0000
#define SRM_DI1_DW_GEN_5__DI1_CST_5                             IPU_MEMORY_OFFSET+0x00406C4,0x0000C000
#define SRM_DI1_DW_GEN_5__DI1_PT_6_5                            IPU_MEMORY_OFFSET+0x00406C4,0x00003000
#define SRM_DI1_DW_GEN_5__DI1_PT_5_5                            IPU_MEMORY_OFFSET+0x00406C4,0x00000C00
#define SRM_DI1_DW_GEN_5__DI1_PT_4_5                            IPU_MEMORY_OFFSET+0x00406C4,0x00000300
#define SRM_DI1_DW_GEN_5__DI1_PT_3_5                            IPU_MEMORY_OFFSET+0x00406C4,0x000000C0
#define SRM_DI1_DW_GEN_5__DI1_PT_2_5                            IPU_MEMORY_OFFSET+0x00406C4,0x00000030
#define SRM_DI1_DW_GEN_5__DI1_PT_1_5                            IPU_MEMORY_OFFSET+0x00406C4,0x0000000C
#define SRM_DI1_DW_GEN_5__DI1_PT_0_5                            IPU_MEMORY_OFFSET+0x00406C4,0x00000003

#define SRM_DI1_DW_GEN_6__ADDR                                  IPU_MEMORY_OFFSET+0x00406C8
#define SRM_DI1_DW_GEN_6__EMPTY                                 IPU_MEMORY_OFFSET+0x00406C8,0x00000000
#define SRM_DI1_DW_GEN_6__FULL                                  IPU_MEMORY_OFFSET+0x00406C8,0xffffffff
#define SRM_DI1_DW_GEN_6__DI1_ACCESS_SIZE_6                     IPU_MEMORY_OFFSET+0x00406C8,0xFF000000
#define SRM_DI1_DW_GEN_6__DI1_COMPONNENT_SIZE_6                 IPU_MEMORY_OFFSET+0x00406C8,0x00FF0000
#define SRM_DI1_DW_GEN_6__DI1_CST_6                             IPU_MEMORY_OFFSET+0x00406C8,0x0000C000
#define SRM_DI1_DW_GEN_6__DI1_PT_6_6                            IPU_MEMORY_OFFSET+0x00406C8,0x00003000
#define SRM_DI1_DW_GEN_6__DI1_PT_5_6                            IPU_MEMORY_OFFSET+0x00406C8,0x00000C00
#define SRM_DI1_DW_GEN_6__DI1_PT_4_6                            IPU_MEMORY_OFFSET+0x00406C8,0x00000300
#define SRM_DI1_DW_GEN_6__DI1_PT_3_6                            IPU_MEMORY_OFFSET+0x00406C8,0x000000C0
#define SRM_DI1_DW_GEN_6__DI1_PT_2_6                            IPU_MEMORY_OFFSET+0x00406C8,0x00000030
#define SRM_DI1_DW_GEN_6__DI1_PT_1_6                            IPU_MEMORY_OFFSET+0x00406C8,0x0000000C
#define SRM_DI1_DW_GEN_6__DI1_PT_0_6                            IPU_MEMORY_OFFSET+0x00406C8,0x00000003

#define SRM_DI1_DW_GEN_7__ADDR                                  IPU_MEMORY_OFFSET+0x00406CC
#define SRM_DI1_DW_GEN_7__EMPTY                                 IPU_MEMORY_OFFSET+0x00406CC,0x00000000
#define SRM_DI1_DW_GEN_7__FULL                                  IPU_MEMORY_OFFSET+0x00406CC,0xffffffff
#define SRM_DI1_DW_GEN_7__DI1_ACCESS_SIZE_7                     IPU_MEMORY_OFFSET+0x00406CC,0xFF000000
#define SRM_DI1_DW_GEN_7__DI1_COMPONNENT_SIZE_7                 IPU_MEMORY_OFFSET+0x00406CC,0x00FF0000
#define SRM_DI1_DW_GEN_7__DI1_CST_7                             IPU_MEMORY_OFFSET+0x00406CC,0x0000C000
#define SRM_DI1_DW_GEN_7__DI1_PT_6_7                            IPU_MEMORY_OFFSET+0x00406CC,0x00003000
#define SRM_DI1_DW_GEN_7__DI1_PT_5_7                            IPU_MEMORY_OFFSET+0x00406CC,0x00000C00
#define SRM_DI1_DW_GEN_7__DI1_PT_4_7                            IPU_MEMORY_OFFSET+0x00406CC,0x00000300
#define SRM_DI1_DW_GEN_7__DI1_PT_3_7                            IPU_MEMORY_OFFSET+0x00406CC,0x000000C0
#define SRM_DI1_DW_GEN_7__DI1_PT_2_7                            IPU_MEMORY_OFFSET+0x00406CC,0x00000030
#define SRM_DI1_DW_GEN_7__DI1_PT_1_7                            IPU_MEMORY_OFFSET+0x00406CC,0x0000000C
#define SRM_DI1_DW_GEN_7__DI1_PT_0_7                            IPU_MEMORY_OFFSET+0x00406CC,0x00000003

#define SRM_DI1_DW_GEN_8__ADDR                                  IPU_MEMORY_OFFSET+0x00406D0
#define SRM_DI1_DW_GEN_8__EMPTY                                 IPU_MEMORY_OFFSET+0x00406D0,0x00000000
#define SRM_DI1_DW_GEN_8__FULL                                  IPU_MEMORY_OFFSET+0x00406D0,0xffffffff
#define SRM_DI1_DW_GEN_8__DI1_ACCESS_SIZE_8                     IPU_MEMORY_OFFSET+0x00406D0,0xFF000000
#define SRM_DI1_DW_GEN_8__DI1_COMPONNENT_SIZE_8                 IPU_MEMORY_OFFSET+0x00406D0,0x00FF0000
#define SRM_DI1_DW_GEN_8__DI1_CST_8                             IPU_MEMORY_OFFSET+0x00406D0,0x0000C000
#define SRM_DI1_DW_GEN_8__DI1_PT_6_8                            IPU_MEMORY_OFFSET+0x00406D0,0x00003000
#define SRM_DI1_DW_GEN_8__DI1_PT_5_8                            IPU_MEMORY_OFFSET+0x00406D0,0x00000C00
#define SRM_DI1_DW_GEN_8__DI1_PT_4_8                            IPU_MEMORY_OFFSET+0x00406D0,0x00000300
#define SRM_DI1_DW_GEN_8__DI1_PT_3_8                            IPU_MEMORY_OFFSET+0x00406D0,0x000000C0
#define SRM_DI1_DW_GEN_8__DI1_PT_2_8                            IPU_MEMORY_OFFSET+0x00406D0,0x00000030
#define SRM_DI1_DW_GEN_8__DI1_PT_1_8                            IPU_MEMORY_OFFSET+0x00406D0,0x0000000C
#define SRM_DI1_DW_GEN_8__DI1_PT_0_8                            IPU_MEMORY_OFFSET+0x00406D0,0x00000003

#define SRM_DI1_DW_GEN_9__ADDR                                  IPU_MEMORY_OFFSET+0x00406D4
#define SRM_DI1_DW_GEN_9__EMPTY                                 IPU_MEMORY_OFFSET+0x00406D4,0x00000000
#define SRM_DI1_DW_GEN_9__FULL                                  IPU_MEMORY_OFFSET+0x00406D4,0xffffffff
#define SRM_DI1_DW_GEN_9__DI1_ACCESS_SIZE_9                     IPU_MEMORY_OFFSET+0x00406D4,0xFF000000
#define SRM_DI1_DW_GEN_9__DI1_COMPONNENT_SIZE_9                 IPU_MEMORY_OFFSET+0x00406D4,0x00FF0000
#define SRM_DI1_DW_GEN_9__DI1_CST_9                             IPU_MEMORY_OFFSET+0x00406D4,0x0000C000
#define SRM_DI1_DW_GEN_9__DI1_PT_6_9                            IPU_MEMORY_OFFSET+0x00406D4,0x00003000
#define SRM_DI1_DW_GEN_9__DI1_PT_5_9                            IPU_MEMORY_OFFSET+0x00406D4,0x00000C00
#define SRM_DI1_DW_GEN_9__DI1_PT_4_9                            IPU_MEMORY_OFFSET+0x00406D4,0x00000300
#define SRM_DI1_DW_GEN_9__DI1_PT_3_9                            IPU_MEMORY_OFFSET+0x00406D4,0x000000C0
#define SRM_DI1_DW_GEN_9__DI1_PT_2_9                            IPU_MEMORY_OFFSET+0x00406D4,0x00000030
#define SRM_DI1_DW_GEN_9__DI1_PT_1_9                            IPU_MEMORY_OFFSET+0x00406D4,0x0000000C
#define SRM_DI1_DW_GEN_9__DI1_PT_0_9                            IPU_MEMORY_OFFSET+0x00406D4,0x00000003

#define SRM_DI1_DW_GEN_10__ADDR                                 IPU_MEMORY_OFFSET+0x00406D8
#define SRM_DI1_DW_GEN_10__EMPTY                                IPU_MEMORY_OFFSET+0x00406D8,0x00000000
#define SRM_DI1_DW_GEN_10__FULL                                 IPU_MEMORY_OFFSET+0x00406D8,0xffffffff
#define SRM_DI1_DW_GEN_10__DI1_ACCESS_SIZE_10                   IPU_MEMORY_OFFSET+0x00406D8,0xFF000000
#define SRM_DI1_DW_GEN_10__DI1_COMPONNENT_SIZE_10               IPU_MEMORY_OFFSET+0x00406D8,0x00FF0000
#define SRM_DI1_DW_GEN_10__DI1_CST_10                           IPU_MEMORY_OFFSET+0x00406D8,0x0000C000
#define SRM_DI1_DW_GEN_10__DI1_PT_6_10                          IPU_MEMORY_OFFSET+0x00406D8,0x00003000
#define SRM_DI1_DW_GEN_10__DI1_PT_5_10                          IPU_MEMORY_OFFSET+0x00406D8,0x00000C00
#define SRM_DI1_DW_GEN_10__DI1_PT_4_10                          IPU_MEMORY_OFFSET+0x00406D8,0x00000300
#define SRM_DI1_DW_GEN_10__DI1_PT_3_10                          IPU_MEMORY_OFFSET+0x00406D8,0x000000C0
#define SRM_DI1_DW_GEN_10__DI1_PT_2_10                          IPU_MEMORY_OFFSET+0x00406D8,0x00000030
#define SRM_DI1_DW_GEN_10__DI1_PT_1_10                          IPU_MEMORY_OFFSET+0x00406D8,0x0000000C
#define SRM_DI1_DW_GEN_10__DI1_PT_0_10                          IPU_MEMORY_OFFSET+0x00406D8,0x00000003

#define SRM_DI1_DW_GEN_11__ADDR                                 IPU_MEMORY_OFFSET+0x00406DC
#define SRM_DI1_DW_GEN_11__EMPTY                                IPU_MEMORY_OFFSET+0x00406DC,0x00000000
#define SRM_DI1_DW_GEN_11__FULL                                 IPU_MEMORY_OFFSET+0x00406DC,0xffffffff
#define SRM_DI1_DW_GEN_11__DI1_ACCESS_SIZE_11                   IPU_MEMORY_OFFSET+0x00406DC,0xFF000000
#define SRM_DI1_DW_GEN_11__DI1_COMPONNENT_SIZE_11               IPU_MEMORY_OFFSET+0x00406DC,0x00FF0000
#define SRM_DI1_DW_GEN_11__DI1_CST_11                           IPU_MEMORY_OFFSET+0x00406DC,0x0000C000
#define SRM_DI1_DW_GEN_11__DI1_PT_6_11                          IPU_MEMORY_OFFSET+0x00406DC,0x00003000
#define SRM_DI1_DW_GEN_11__DI1_PT_5_11                          IPU_MEMORY_OFFSET+0x00406DC,0x00000C00
#define SRM_DI1_DW_GEN_11__DI1_PT_4_11                          IPU_MEMORY_OFFSET+0x00406DC,0x00000300
#define SRM_DI1_DW_GEN_11__DI1_PT_3_11                          IPU_MEMORY_OFFSET+0x00406DC,0x000000C0
#define SRM_DI1_DW_GEN_11__DI1_PT_2_11                          IPU_MEMORY_OFFSET+0x00406DC,0x00000030
#define SRM_DI1_DW_GEN_11__DI1_PT_1_11                          IPU_MEMORY_OFFSET+0x00406DC,0x0000000C
#define SRM_DI1_DW_GEN_11__DI1_PT_0_11                          IPU_MEMORY_OFFSET+0x00406DC,0x00000003

#define SRM_DI1_DW_SET0_0__ADDR                                 IPU_MEMORY_OFFSET+0x00406E0
#define SRM_DI1_DW_SET0_0__EMPTY                                IPU_MEMORY_OFFSET+0x00406E0,0x00000000
#define SRM_DI1_DW_SET0_0__FULL                                 IPU_MEMORY_OFFSET+0x00406E0,0xffffffff
#define SRM_DI1_DW_SET0_0__DI1_DATA_CNT_DOWN0_0                 IPU_MEMORY_OFFSET+0x00406E0,0x01FF0000
#define SRM_DI1_DW_SET0_0__DI1_DATA_CNT_UP0_0                   IPU_MEMORY_OFFSET+0x00406E0,0x000001FF

#define SRM_DI1_DW_SET0_1__ADDR                                 IPU_MEMORY_OFFSET+0x00406E4
#define SRM_DI1_DW_SET0_1__EMPTY                                IPU_MEMORY_OFFSET+0x00406E4,0x00000000
#define SRM_DI1_DW_SET0_1__FULL                                 IPU_MEMORY_OFFSET+0x00406E4,0xffffffff
#define SRM_DI1_DW_SET0_1__DI1_DATA_CNT_DOWN0_1                 IPU_MEMORY_OFFSET+0x00406E4,0x01FF0000
#define SRM_DI1_DW_SET0_1__DI1_DATA_CNT_UP0_1                   IPU_MEMORY_OFFSET+0x00406E4,0x000001FF

#define SRM_DI1_DW_SET0_2__ADDR                                 IPU_MEMORY_OFFSET+0x00406E8
#define SRM_DI1_DW_SET0_2__EMPTY                                IPU_MEMORY_OFFSET+0x00406E8,0x00000000
#define SRM_DI1_DW_SET0_2__FULL                                 IPU_MEMORY_OFFSET+0x00406E8,0xffffffff
#define SRM_DI1_DW_SET0_2__DI1_DATA_CNT_DOWN0_2                 IPU_MEMORY_OFFSET+0x00406E8,0x01FF0000
#define SRM_DI1_DW_SET0_2__DI1_DATA_CNT_UP0_2                   IPU_MEMORY_OFFSET+0x00406E8,0x000001FF

#define SRM_DI1_DW_SET0_3__ADDR                                 IPU_MEMORY_OFFSET+0x00406EC
#define SRM_DI1_DW_SET0_3__EMPTY                                IPU_MEMORY_OFFSET+0x00406EC,0x00000000
#define SRM_DI1_DW_SET0_3__FULL                                 IPU_MEMORY_OFFSET+0x00406EC,0xffffffff
#define SRM_DI1_DW_SET0_3__DI1_DATA_CNT_DOWN0_3                 IPU_MEMORY_OFFSET+0x00406EC,0x01FF0000
#define SRM_DI1_DW_SET0_3__DI1_DATA_CNT_UP0_3                   IPU_MEMORY_OFFSET+0x00406EC,0x000001FF

#define SRM_DI1_DW_SET0_4__ADDR                                 IPU_MEMORY_OFFSET+0x00406F0
#define SRM_DI1_DW_SET0_4__EMPTY                                IPU_MEMORY_OFFSET+0x00406F0,0x00000000
#define SRM_DI1_DW_SET0_4__FULL                                 IPU_MEMORY_OFFSET+0x00406F0,0xffffffff
#define SRM_DI1_DW_SET0_4__DI1_DATA_CNT_DOWN0_4                 IPU_MEMORY_OFFSET+0x00406F0,0x01FF0000
#define SRM_DI1_DW_SET0_4__DI1_DATA_CNT_UP0_4                   IPU_MEMORY_OFFSET+0x00406F0,0x000001FF

#define SRM_DI1_DW_SET0_5__ADDR                                 IPU_MEMORY_OFFSET+0x00406F4
#define SRM_DI1_DW_SET0_5__EMPTY                                IPU_MEMORY_OFFSET+0x00406F4,0x00000000
#define SRM_DI1_DW_SET0_5__FULL                                 IPU_MEMORY_OFFSET+0x00406F4,0xffffffff
#define SRM_DI1_DW_SET0_5__DI1_DATA_CNT_DOWN0_5                 IPU_MEMORY_OFFSET+0x00406F4,0x01FF0000
#define SRM_DI1_DW_SET0_5__DI1_DATA_CNT_UP0_5                   IPU_MEMORY_OFFSET+0x00406F4,0x000001FF

#define SRM_DI1_DW_SET0_6__ADDR                                 IPU_MEMORY_OFFSET+0x00406F8
#define SRM_DI1_DW_SET0_6__EMPTY                                IPU_MEMORY_OFFSET+0x00406F8,0x00000000
#define SRM_DI1_DW_SET0_6__FULL                                 IPU_MEMORY_OFFSET+0x00406F8,0xffffffff
#define SRM_DI1_DW_SET0_6__DI1_DATA_CNT_DOWN0_6                 IPU_MEMORY_OFFSET+0x00406F8,0x01FF0000
#define SRM_DI1_DW_SET0_6__DI1_DATA_CNT_UP0_6                   IPU_MEMORY_OFFSET+0x00406F8,0x000001FF

#define SRM_DI1_DW_SET0_7__ADDR                                 IPU_MEMORY_OFFSET+0x00406FC
#define SRM_DI1_DW_SET0_7__EMPTY                                IPU_MEMORY_OFFSET+0x00406FC,0x00000000
#define SRM_DI1_DW_SET0_7__FULL                                 IPU_MEMORY_OFFSET+0x00406FC,0xffffffff
#define SRM_DI1_DW_SET0_7__DI1_DATA_CNT_DOWN0_7                 IPU_MEMORY_OFFSET+0x00406FC,0x01FF0000
#define SRM_DI1_DW_SET0_7__DI1_DATA_CNT_UP0_7                   IPU_MEMORY_OFFSET+0x00406FC,0x000001FF

#define SRM_DI1_DW_SET0_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040700
#define SRM_DI1_DW_SET0_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040700,0x00000000
#define SRM_DI1_DW_SET0_8__FULL                                 IPU_MEMORY_OFFSET+0x0040700,0xffffffff
#define SRM_DI1_DW_SET0_8__DI1_DATA_CNT_DOWN0_8                 IPU_MEMORY_OFFSET+0x0040700,0x01FF0000
#define SRM_DI1_DW_SET0_8__DI1_DATA_CNT_UP0_8                   IPU_MEMORY_OFFSET+0x0040700,0x000001FF

#define SRM_DI1_DW_SET0_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040704
#define SRM_DI1_DW_SET0_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040704,0x00000000
#define SRM_DI1_DW_SET0_9__FULL                                 IPU_MEMORY_OFFSET+0x0040704,0xffffffff
#define SRM_DI1_DW_SET0_9__DI1_DATA_CNT_DOWN0_9                 IPU_MEMORY_OFFSET+0x0040704,0x01FF0000
#define SRM_DI1_DW_SET0_9__DI1_DATA_CNT_UP0_9                   IPU_MEMORY_OFFSET+0x0040704,0x000001FF

#define SRM_DI1_DW_SET0_10__ADDR                                IPU_MEMORY_OFFSET+0x0040708
#define SRM_DI1_DW_SET0_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040708,0x00000000
#define SRM_DI1_DW_SET0_10__FULL                                IPU_MEMORY_OFFSET+0x0040708,0xffffffff
#define SRM_DI1_DW_SET0_10__DI1_DATA_CNT_DOWN0_10               IPU_MEMORY_OFFSET+0x0040708,0x01FF0000
#define SRM_DI1_DW_SET0_10__DI1_DATA_CNT_UP0_10                 IPU_MEMORY_OFFSET+0x0040708,0x000001FF

#define SRM_DI1_DW_SET0_11__ADDR                                IPU_MEMORY_OFFSET+0x004070C
#define SRM_DI1_DW_SET0_11__EMPTY                               IPU_MEMORY_OFFSET+0x004070C,0x00000000
#define SRM_DI1_DW_SET0_11__FULL                                IPU_MEMORY_OFFSET+0x004070C,0xffffffff
#define SRM_DI1_DW_SET0_11__DI1_DATA_CNT_DOWN0_11               IPU_MEMORY_OFFSET+0x004070C,0x01FF0000
#define SRM_DI1_DW_SET0_11__DI1_DATA_CNT_UP0_11                 IPU_MEMORY_OFFSET+0x004070C,0x000001FF

#define SRM_DI1_DW_SET1_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040710
#define SRM_DI1_DW_SET1_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040710,0x00000000
#define SRM_DI1_DW_SET1_0__FULL                                 IPU_MEMORY_OFFSET+0x0040710,0xffffffff
#define SRM_DI1_DW_SET1_0__DI1_DATA_CNT_DOWN1_0                 IPU_MEMORY_OFFSET+0x0040710,0x01FF0000
#define SRM_DI1_DW_SET1_0__DI1_DATA_CNT_UP1_0                   IPU_MEMORY_OFFSET+0x0040710,0x000001FF

#define SRM_DI1_DW_SET1_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040714
#define SRM_DI1_DW_SET1_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040714,0x00000000
#define SRM_DI1_DW_SET1_1__FULL                                 IPU_MEMORY_OFFSET+0x0040714,0xffffffff
#define SRM_DI1_DW_SET1_1__DI1_DATA_CNT_DOWN1_1                 IPU_MEMORY_OFFSET+0x0040714,0x01FF0000
#define SRM_DI1_DW_SET1_1__DI1_DATA_CNT_UP1_1                   IPU_MEMORY_OFFSET+0x0040714,0x000001FF

#define SRM_DI1_DW_SET1_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040718
#define SRM_DI1_DW_SET1_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040718,0x00000000
#define SRM_DI1_DW_SET1_2__FULL                                 IPU_MEMORY_OFFSET+0x0040718,0xffffffff
#define SRM_DI1_DW_SET1_2__DI1_DATA_CNT_DOWN1_2                 IPU_MEMORY_OFFSET+0x0040718,0x01FF0000
#define SRM_DI1_DW_SET1_2__DI1_DATA_CNT_UP1_2                   IPU_MEMORY_OFFSET+0x0040718,0x000001FF

#define SRM_DI1_DW_SET1_3__ADDR                                 IPU_MEMORY_OFFSET+0x004071C
#define SRM_DI1_DW_SET1_3__EMPTY                                IPU_MEMORY_OFFSET+0x004071C,0x00000000
#define SRM_DI1_DW_SET1_3__FULL                                 IPU_MEMORY_OFFSET+0x004071C,0xffffffff
#define SRM_DI1_DW_SET1_3__DI1_DATA_CNT_DOWN1_3                 IPU_MEMORY_OFFSET+0x004071C,0x01FF0000
#define SRM_DI1_DW_SET1_3__DI1_DATA_CNT_UP1_3                   IPU_MEMORY_OFFSET+0x004071C,0x000001FF

#define SRM_DI1_DW_SET1_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040720
#define SRM_DI1_DW_SET1_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040720,0x00000000
#define SRM_DI1_DW_SET1_4__FULL                                 IPU_MEMORY_OFFSET+0x0040720,0xffffffff
#define SRM_DI1_DW_SET1_4__DI1_DATA_CNT_DOWN1_4                 IPU_MEMORY_OFFSET+0x0040720,0x01FF0000
#define SRM_DI1_DW_SET1_4__DI1_DATA_CNT_UP1_4                   IPU_MEMORY_OFFSET+0x0040720,0x000001FF

#define SRM_DI1_DW_SET1_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040724
#define SRM_DI1_DW_SET1_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040724,0x00000000
#define SRM_DI1_DW_SET1_5__FULL                                 IPU_MEMORY_OFFSET+0x0040724,0xffffffff
#define SRM_DI1_DW_SET1_5__DI1_DATA_CNT_DOWN1_5                 IPU_MEMORY_OFFSET+0x0040724,0x01FF0000
#define SRM_DI1_DW_SET1_5__DI1_DATA_CNT_UP1_5                   IPU_MEMORY_OFFSET+0x0040724,0x000001FF

#define SRM_DI1_DW_SET1_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040728
#define SRM_DI1_DW_SET1_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040728,0x00000000
#define SRM_DI1_DW_SET1_6__FULL                                 IPU_MEMORY_OFFSET+0x0040728,0xffffffff
#define SRM_DI1_DW_SET1_6__DI1_DATA_CNT_DOWN1_6                 IPU_MEMORY_OFFSET+0x0040728,0x01FF0000
#define SRM_DI1_DW_SET1_6__DI1_DATA_CNT_UP1_6                   IPU_MEMORY_OFFSET+0x0040728,0x000001FF

#define SRM_DI1_DW_SET1_7__ADDR                                 IPU_MEMORY_OFFSET+0x004072C
#define SRM_DI1_DW_SET1_7__EMPTY                                IPU_MEMORY_OFFSET+0x004072C,0x00000000
#define SRM_DI1_DW_SET1_7__FULL                                 IPU_MEMORY_OFFSET+0x004072C,0xffffffff
#define SRM_DI1_DW_SET1_7__DI1_DATA_CNT_DOWN1_7                 IPU_MEMORY_OFFSET+0x004072C,0x01FF0000
#define SRM_DI1_DW_SET1_7__DI1_DATA_CNT_UP1_7                   IPU_MEMORY_OFFSET+0x004072C,0x000001FF

#define SRM_DI1_DW_SET1_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040730
#define SRM_DI1_DW_SET1_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040730,0x00000000
#define SRM_DI1_DW_SET1_8__FULL                                 IPU_MEMORY_OFFSET+0x0040730,0xffffffff
#define SRM_DI1_DW_SET1_8__DI1_DATA_CNT_DOWN1_8                 IPU_MEMORY_OFFSET+0x0040730,0x01FF0000
#define SRM_DI1_DW_SET1_8__DI1_DATA_CNT_UP1_8                   IPU_MEMORY_OFFSET+0x0040730,0x000001FF

#define SRM_DI1_DW_SET1_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040734
#define SRM_DI1_DW_SET1_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040734,0x00000000
#define SRM_DI1_DW_SET1_9__FULL                                 IPU_MEMORY_OFFSET+0x0040734,0xffffffff
#define SRM_DI1_DW_SET1_9__DI1_DATA_CNT_DOWN1_9                 IPU_MEMORY_OFFSET+0x0040734,0x01FF0000
#define SRM_DI1_DW_SET1_9__DI1_DATA_CNT_UP1_9                   IPU_MEMORY_OFFSET+0x0040734,0x000001FF

#define SRM_DI1_DW_SET1_10__ADDR                                IPU_MEMORY_OFFSET+0x0040738
#define SRM_DI1_DW_SET1_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040738,0x00000000
#define SRM_DI1_DW_SET1_10__FULL                                IPU_MEMORY_OFFSET+0x0040738,0xffffffff
#define SRM_DI1_DW_SET1_10__DI1_DATA_CNT_DOWN1_10               IPU_MEMORY_OFFSET+0x0040738,0x01FF0000
#define SRM_DI1_DW_SET1_10__DI1_DATA_CNT_UP1_10                 IPU_MEMORY_OFFSET+0x0040738,0x000001FF

#define SRM_DI1_DW_SET1_11__ADDR                                IPU_MEMORY_OFFSET+0x004073C
#define SRM_DI1_DW_SET1_11__EMPTY                               IPU_MEMORY_OFFSET+0x004073C,0x00000000
#define SRM_DI1_DW_SET1_11__FULL                                IPU_MEMORY_OFFSET+0x004073C,0xffffffff
#define SRM_DI1_DW_SET1_11__DI1_DATA_CNT_DOWN1_11               IPU_MEMORY_OFFSET+0x004073C,0x01FF0000
#define SRM_DI1_DW_SET1_11__DI1_DATA_CNT_UP1_11                 IPU_MEMORY_OFFSET+0x004073C,0x000001FF

#define SRM_DI1_DW_SET2_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040740
#define SRM_DI1_DW_SET2_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040740,0x00000000
#define SRM_DI1_DW_SET2_0__FULL                                 IPU_MEMORY_OFFSET+0x0040740,0xffffffff
#define SRM_DI1_DW_SET2_0__DI1_DATA_CNT_DOWN2_0                 IPU_MEMORY_OFFSET+0x0040740,0x01FF0000
#define SRM_DI1_DW_SET2_0__DI1_DATA_CNT_UP2_0                   IPU_MEMORY_OFFSET+0x0040740,0x000001FF

#define SRM_DI1_DW_SET2_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040744
#define SRM_DI1_DW_SET2_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040744,0x00000000
#define SRM_DI1_DW_SET2_1__FULL                                 IPU_MEMORY_OFFSET+0x0040744,0xffffffff
#define SRM_DI1_DW_SET2_1__DI1_DATA_CNT_DOWN2_1                 IPU_MEMORY_OFFSET+0x0040744,0x01FF0000
#define SRM_DI1_DW_SET2_1__DI1_DATA_CNT_UP2_1                   IPU_MEMORY_OFFSET+0x0040744,0x000001FF

#define SRM_DI1_DW_SET2_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040748
#define SRM_DI1_DW_SET2_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040748,0x00000000
#define SRM_DI1_DW_SET2_2__FULL                                 IPU_MEMORY_OFFSET+0x0040748,0xffffffff
#define SRM_DI1_DW_SET2_2__DI1_DATA_CNT_DOWN2_2                 IPU_MEMORY_OFFSET+0x0040748,0x01FF0000
#define SRM_DI1_DW_SET2_2__DI1_DATA_CNT_UP2_2                   IPU_MEMORY_OFFSET+0x0040748,0x000001FF

#define SRM_DI1_DW_SET2_3__ADDR                                 IPU_MEMORY_OFFSET+0x004074C
#define SRM_DI1_DW_SET2_3__EMPTY                                IPU_MEMORY_OFFSET+0x004074C,0x00000000
#define SRM_DI1_DW_SET2_3__FULL                                 IPU_MEMORY_OFFSET+0x004074C,0xffffffff
#define SRM_DI1_DW_SET2_3__DI1_DATA_CNT_DOWN2_3                 IPU_MEMORY_OFFSET+0x004074C,0x01FF0000
#define SRM_DI1_DW_SET2_3__DI1_DATA_CNT_UP2_3                   IPU_MEMORY_OFFSET+0x004074C,0x000001FF

#define SRM_DI1_DW_SET2_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040750
#define SRM_DI1_DW_SET2_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040750,0x00000000
#define SRM_DI1_DW_SET2_4__FULL                                 IPU_MEMORY_OFFSET+0x0040750,0xffffffff
#define SRM_DI1_DW_SET2_4__DI1_DATA_CNT_DOWN2_4                 IPU_MEMORY_OFFSET+0x0040750,0x01FF0000
#define SRM_DI1_DW_SET2_4__DI1_DATA_CNT_UP2_4                   IPU_MEMORY_OFFSET+0x0040750,0x000001FF

#define SRM_DI1_DW_SET2_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040754
#define SRM_DI1_DW_SET2_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040754,0x00000000
#define SRM_DI1_DW_SET2_5__FULL                                 IPU_MEMORY_OFFSET+0x0040754,0xffffffff
#define SRM_DI1_DW_SET2_5__DI1_DATA_CNT_DOWN2_5                 IPU_MEMORY_OFFSET+0x0040754,0x01FF0000
#define SRM_DI1_DW_SET2_5__DI1_DATA_CNT_UP2_5                   IPU_MEMORY_OFFSET+0x0040754,0x000001FF

#define SRM_DI1_DW_SET2_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040758
#define SRM_DI1_DW_SET2_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040758,0x00000000
#define SRM_DI1_DW_SET2_6__FULL                                 IPU_MEMORY_OFFSET+0x0040758,0xffffffff
#define SRM_DI1_DW_SET2_6__DI1_DATA_CNT_DOWN2_6                 IPU_MEMORY_OFFSET+0x0040758,0x01FF0000
#define SRM_DI1_DW_SET2_6__DI1_DATA_CNT_UP2_6                   IPU_MEMORY_OFFSET+0x0040758,0x000001FF

#define SRM_DI1_DW_SET2_7__ADDR                                 IPU_MEMORY_OFFSET+0x004075C
#define SRM_DI1_DW_SET2_7__EMPTY                                IPU_MEMORY_OFFSET+0x004075C,0x00000000
#define SRM_DI1_DW_SET2_7__FULL                                 IPU_MEMORY_OFFSET+0x004075C,0xffffffff
#define SRM_DI1_DW_SET2_7__DI1_DATA_CNT_DOWN2_7                 IPU_MEMORY_OFFSET+0x004075C,0x01FF0000
#define SRM_DI1_DW_SET2_7__DI1_DATA_CNT_UP2_7                   IPU_MEMORY_OFFSET+0x004075C,0x000001FF

#define SRM_DI1_DW_SET2_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040760
#define SRM_DI1_DW_SET2_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040760,0x00000000
#define SRM_DI1_DW_SET2_8__FULL                                 IPU_MEMORY_OFFSET+0x0040760,0xffffffff
#define SRM_DI1_DW_SET2_8__DI1_DATA_CNT_DOWN2_8                 IPU_MEMORY_OFFSET+0x0040760,0x01FF0000
#define SRM_DI1_DW_SET2_8__DI1_DATA_CNT_UP2_8                   IPU_MEMORY_OFFSET+0x0040760,0x000001FF

#define SRM_DI1_DW_SET2_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040764
#define SRM_DI1_DW_SET2_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040764,0x00000000
#define SRM_DI1_DW_SET2_9__FULL                                 IPU_MEMORY_OFFSET+0x0040764,0xffffffff
#define SRM_DI1_DW_SET2_9__DI1_DATA_CNT_DOWN2_9                 IPU_MEMORY_OFFSET+0x0040764,0x01FF0000
#define SRM_DI1_DW_SET2_9__DI1_DATA_CNT_UP2_9                   IPU_MEMORY_OFFSET+0x0040764,0x000001FF

#define SRM_DI1_DW_SET2_10__ADDR                                IPU_MEMORY_OFFSET+0x0040768
#define SRM_DI1_DW_SET2_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040768,0x00000000
#define SRM_DI1_DW_SET2_10__FULL                                IPU_MEMORY_OFFSET+0x0040768,0xffffffff
#define SRM_DI1_DW_SET2_10__DI1_DATA_CNT_DOWN2_10               IPU_MEMORY_OFFSET+0x0040768,0x01FF0000
#define SRM_DI1_DW_SET2_10__DI1_DATA_CNT_UP2_10                 IPU_MEMORY_OFFSET+0x0040768,0x000001FF

#define SRM_DI1_DW_SET2_11__ADDR                                IPU_MEMORY_OFFSET+0x004076C
#define SRM_DI1_DW_SET2_11__EMPTY                               IPU_MEMORY_OFFSET+0x004076C,0x00000000
#define SRM_DI1_DW_SET2_11__FULL                                IPU_MEMORY_OFFSET+0x004076C,0xffffffff
#define SRM_DI1_DW_SET2_11__DI1_DATA_CNT_DOWN2_11               IPU_MEMORY_OFFSET+0x004076C,0x01FF0000
#define SRM_DI1_DW_SET2_11__DI1_DATA_CNT_UP2_11                 IPU_MEMORY_OFFSET+0x004076C,0x000001FF

#define SRM_DI1_DW_SET3_0__ADDR                                 IPU_MEMORY_OFFSET+0x0040770
#define SRM_DI1_DW_SET3_0__EMPTY                                IPU_MEMORY_OFFSET+0x0040770,0x00000000
#define SRM_DI1_DW_SET3_0__FULL                                 IPU_MEMORY_OFFSET+0x0040770,0xffffffff
#define SRM_DI1_DW_SET3_0__DI1_DATA_CNT_DOWN3_0                 IPU_MEMORY_OFFSET+0x0040770,0x01FF0000
#define SRM_DI1_DW_SET3_0__DI1_DATA_CNT_UP3_0                   IPU_MEMORY_OFFSET+0x0040770,0x000001FF

#define SRM_DI1_DW_SET3_1__ADDR                                 IPU_MEMORY_OFFSET+0x0040774
#define SRM_DI1_DW_SET3_1__EMPTY                                IPU_MEMORY_OFFSET+0x0040774,0x00000000
#define SRM_DI1_DW_SET3_1__FULL                                 IPU_MEMORY_OFFSET+0x0040774,0xffffffff
#define SRM_DI1_DW_SET3_1__DI1_DATA_CNT_DOWN3_1                 IPU_MEMORY_OFFSET+0x0040774,0x01FF0000
#define SRM_DI1_DW_SET3_1__DI1_DATA_CNT_UP3_1                   IPU_MEMORY_OFFSET+0x0040774,0x000001FF

#define SRM_DI1_DW_SET3_2__ADDR                                 IPU_MEMORY_OFFSET+0x0040778
#define SRM_DI1_DW_SET3_2__EMPTY                                IPU_MEMORY_OFFSET+0x0040778,0x00000000
#define SRM_DI1_DW_SET3_2__FULL                                 IPU_MEMORY_OFFSET+0x0040778,0xffffffff
#define SRM_DI1_DW_SET3_2__DI1_DATA_CNT_DOWN3_2                 IPU_MEMORY_OFFSET+0x0040778,0x01FF0000
#define SRM_DI1_DW_SET3_2__DI1_DATA_CNT_UP3_2                   IPU_MEMORY_OFFSET+0x0040778,0x000001FF

#define SRM_DI1_DW_SET3_3__ADDR                                 IPU_MEMORY_OFFSET+0x004077C
#define SRM_DI1_DW_SET3_3__EMPTY                                IPU_MEMORY_OFFSET+0x004077C,0x00000000
#define SRM_DI1_DW_SET3_3__FULL                                 IPU_MEMORY_OFFSET+0x004077C,0xffffffff
#define SRM_DI1_DW_SET3_3__DI1_DATA_CNT_DOWN3_3                 IPU_MEMORY_OFFSET+0x004077C,0x01FF0000
#define SRM_DI1_DW_SET3_3__DI1_DATA_CNT_UP3_3                   IPU_MEMORY_OFFSET+0x004077C,0x000001FF

#define SRM_DI1_DW_SET3_4__ADDR                                 IPU_MEMORY_OFFSET+0x0040780
#define SRM_DI1_DW_SET3_4__EMPTY                                IPU_MEMORY_OFFSET+0x0040780,0x00000000
#define SRM_DI1_DW_SET3_4__FULL                                 IPU_MEMORY_OFFSET+0x0040780,0xffffffff
#define SRM_DI1_DW_SET3_4__DI1_DATA_CNT_DOWN3_4                 IPU_MEMORY_OFFSET+0x0040780,0x01FF0000
#define SRM_DI1_DW_SET3_4__DI1_DATA_CNT_UP3_4                   IPU_MEMORY_OFFSET+0x0040780,0x000001FF

#define SRM_DI1_DW_SET3_5__ADDR                                 IPU_MEMORY_OFFSET+0x0040784
#define SRM_DI1_DW_SET3_5__EMPTY                                IPU_MEMORY_OFFSET+0x0040784,0x00000000
#define SRM_DI1_DW_SET3_5__FULL                                 IPU_MEMORY_OFFSET+0x0040784,0xffffffff
#define SRM_DI1_DW_SET3_5__DI1_DATA_CNT_DOWN3_5                 IPU_MEMORY_OFFSET+0x0040784,0x01FF0000
#define SRM_DI1_DW_SET3_5__DI1_DATA_CNT_UP3_5                   IPU_MEMORY_OFFSET+0x0040784,0x000001FF

#define SRM_DI1_DW_SET3_6__ADDR                                 IPU_MEMORY_OFFSET+0x0040788
#define SRM_DI1_DW_SET3_6__EMPTY                                IPU_MEMORY_OFFSET+0x0040788,0x00000000
#define SRM_DI1_DW_SET3_6__FULL                                 IPU_MEMORY_OFFSET+0x0040788,0xffffffff
#define SRM_DI1_DW_SET3_6__DI1_DATA_CNT_DOWN3_6                 IPU_MEMORY_OFFSET+0x0040788,0x01FF0000
#define SRM_DI1_DW_SET3_6__DI1_DATA_CNT_UP3_6                   IPU_MEMORY_OFFSET+0x0040788,0x000001FF

#define SRM_DI1_DW_SET3_7__ADDR                                 IPU_MEMORY_OFFSET+0x004078C
#define SRM_DI1_DW_SET3_7__EMPTY                                IPU_MEMORY_OFFSET+0x004078C,0x00000000
#define SRM_DI1_DW_SET3_7__FULL                                 IPU_MEMORY_OFFSET+0x004078C,0xffffffff
#define SRM_DI1_DW_SET3_7__DI1_DATA_CNT_DOWN3_7                 IPU_MEMORY_OFFSET+0x004078C,0x01FF0000
#define SRM_DI1_DW_SET3_7__DI1_DATA_CNT_UP3_7                   IPU_MEMORY_OFFSET+0x004078C,0x000001FF

#define SRM_DI1_DW_SET3_8__ADDR                                 IPU_MEMORY_OFFSET+0x0040790
#define SRM_DI1_DW_SET3_8__EMPTY                                IPU_MEMORY_OFFSET+0x0040790,0x00000000
#define SRM_DI1_DW_SET3_8__FULL                                 IPU_MEMORY_OFFSET+0x0040790,0xffffffff
#define SRM_DI1_DW_SET3_8__DI1_DATA_CNT_DOWN3_8                 IPU_MEMORY_OFFSET+0x0040790,0x01FF0000
#define SRM_DI1_DW_SET3_8__DI1_DATA_CNT_UP3_8                   IPU_MEMORY_OFFSET+0x0040790,0x000001FF

#define SRM_DI1_DW_SET3_9__ADDR                                 IPU_MEMORY_OFFSET+0x0040794
#define SRM_DI1_DW_SET3_9__EMPTY                                IPU_MEMORY_OFFSET+0x0040794,0x00000000
#define SRM_DI1_DW_SET3_9__FULL                                 IPU_MEMORY_OFFSET+0x0040794,0xffffffff
#define SRM_DI1_DW_SET3_9__DI1_DATA_CNT_DOWN3_9                 IPU_MEMORY_OFFSET+0x0040794,0x01FF0000
#define SRM_DI1_DW_SET3_9__DI1_DATA_CNT_UP3_9                   IPU_MEMORY_OFFSET+0x0040794,0x000001FF

#define SRM_DI1_DW_SET3_10__ADDR                                IPU_MEMORY_OFFSET+0x0040798
#define SRM_DI1_DW_SET3_10__EMPTY                               IPU_MEMORY_OFFSET+0x0040798,0x00000000
#define SRM_DI1_DW_SET3_10__FULL                                IPU_MEMORY_OFFSET+0x0040798,0xffffffff
#define SRM_DI1_DW_SET3_10__DI1_DATA_CNT_DOWN3_10               IPU_MEMORY_OFFSET+0x0040798,0x01FF0000
#define SRM_DI1_DW_SET3_10__DI1_DATA_CNT_UP3_10                 IPU_MEMORY_OFFSET+0x0040798,0x000001FF

#define SRM_DI1_DW_SET3_11__ADDR                                IPU_MEMORY_OFFSET+0x004079C
#define SRM_DI1_DW_SET3_11__EMPTY                               IPU_MEMORY_OFFSET+0x004079C,0x00000000
#define SRM_DI1_DW_SET3_11__FULL                                IPU_MEMORY_OFFSET+0x004079C,0xffffffff
#define SRM_DI1_DW_SET3_11__DI1_DATA_CNT_DOWN3_11               IPU_MEMORY_OFFSET+0x004079C,0x01FF0000
#define SRM_DI1_DW_SET3_11__DI1_DATA_CNT_UP3_11                 IPU_MEMORY_OFFSET+0x004079C,0x000001FF

#define SRM_DI1_STP_REP_1__ADDR                                 IPU_MEMORY_OFFSET+0x00407A0
#define SRM_DI1_STP_REP_1__EMPTY                                IPU_MEMORY_OFFSET+0x00407A0,0x00000000
#define SRM_DI1_STP_REP_1__FULL                                 IPU_MEMORY_OFFSET+0x00407A0,0xffffffff
#define SRM_DI1_STP_REP_1__DI1_STEP_REPEAT_2                    IPU_MEMORY_OFFSET+0x00407A0,0x0FFF0000
#define SRM_DI1_STP_REP_1__DI1_STEP_REPEAT_1                    IPU_MEMORY_OFFSET+0x00407A0,0x00000FFF

#define SRM_DI1_STP_REP_2__ADDR                                 IPU_MEMORY_OFFSET+0x00407A4
#define SRM_DI1_STP_REP_2__EMPTY                                IPU_MEMORY_OFFSET+0x00407A4,0x00000000
#define SRM_DI1_STP_REP_2__FULL                                 IPU_MEMORY_OFFSET+0x00407A4,0xffffffff
#define SRM_DI1_STP_REP_2__DI1_STEP_REPEAT_4                    IPU_MEMORY_OFFSET+0x00407A4,0x0FFF0000
#define SRM_DI1_STP_REP_2__DI1_STEP_REPEAT_3                    IPU_MEMORY_OFFSET+0x00407A4,0x00000FFF

#define SRM_DI1_STP_REP_3__ADDR                                 IPU_MEMORY_OFFSET+0x00407A8
#define SRM_DI1_STP_REP_3__EMPTY                                IPU_MEMORY_OFFSET+0x00407A8,0x00000000
#define SRM_DI1_STP_REP_3__FULL                                 IPU_MEMORY_OFFSET+0x00407A8,0xffffffff
#define SRM_DI1_STP_REP_3__DI1_STEP_REPEAT_6                    IPU_MEMORY_OFFSET+0x00407A8,0x0FFF0000
#define SRM_DI1_STP_REP_3__DI1_STEP_REPEAT_5                    IPU_MEMORY_OFFSET+0x00407A8,0x00000FFF

#define SRM_DI1_STP_REP_4__ADDR                                 IPU_MEMORY_OFFSET+0x00407AC
#define SRM_DI1_STP_REP_4__EMPTY                                IPU_MEMORY_OFFSET+0x00407AC,0x00000000
#define SRM_DI1_STP_REP_4__FULL                                 IPU_MEMORY_OFFSET+0x00407AC,0xffffffff
#define SRM_DI1_STP_REP_4__DI1_STEP_REPEAT_8                    IPU_MEMORY_OFFSET+0x00407AC,0x0FFF0000
#define SRM_DI1_STP_REP_4__DI1_STEP_REPEAT_7                    IPU_MEMORY_OFFSET+0x00407AC,0x00000FFF

#define SRM_DI1_STP_REP_9__ADDR                                 IPU_MEMORY_OFFSET+0x00407B0
#define SRM_DI1_STP_REP_9__EMPTY                                IPU_MEMORY_OFFSET+0x00407B0,0x00000000
#define SRM_DI1_STP_REP_9__FULL                                 IPU_MEMORY_OFFSET+0x00407B0,0xffffffff
#define SRM_DI1_STP_REP_9__DI1_STEP_REPEAT_9                    IPU_MEMORY_OFFSET+0x00407B0,0x00000FFF

#define SRM_DI1_SER_CONF__ADDR                                  IPU_MEMORY_OFFSET+0x00407B4
#define SRM_DI1_SER_CONF__EMPTY                                 IPU_MEMORY_OFFSET+0x00407B4,0x00000000
#define SRM_DI1_SER_CONF__FULL                                  IPU_MEMORY_OFFSET+0x00407B4,0xffffffff
#define SRM_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_R_1            IPU_MEMORY_OFFSET+0x00407B4,0xF0000000
#define SRM_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_R_0            IPU_MEMORY_OFFSET+0x00407B4,0x0F000000
#define SRM_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_W_1            IPU_MEMORY_OFFSET+0x00407B4,0x00F00000
#define SRM_DI1_SER_CONF__DI1_SERIAL_LLA_PNTR_RS_W_0            IPU_MEMORY_OFFSET+0x00407B4,0x000F0000
#define SRM_DI1_SER_CONF__DI1_SERIAL_LATCH                      IPU_MEMORY_OFFSET+0x00407B4,0x0000FF00
#define SRM_DI1_SER_CONF__DI1_LLA_SER_ACCESS                    IPU_MEMORY_OFFSET+0x00407B4,0x00000020
#define SRM_DI1_SER_CONF__DI1_SER_CLK_POLARITY                  IPU_MEMORY_OFFSET+0x00407B4,0x00000010
#define SRM_DI1_SER_CONF__DI1_SERIAL_DATA_POLARITY              IPU_MEMORY_OFFSET+0x00407B4,0x00000008
#define SRM_DI1_SER_CONF__DI1_SERIAL_RS_POLARITY                IPU_MEMORY_OFFSET+0x00407B4,0x00000004
#define SRM_DI1_SER_CONF__DI1_SERIAL_CS_POLARITY                IPU_MEMORY_OFFSET+0x00407B4,0x00000002
#define SRM_DI1_SER_CONF__DI1_WAIT4SERIAL                       IPU_MEMORY_OFFSET+0x00407B4,0x00000001

#define SRM_DI1_SSC__ADDR                                       IPU_MEMORY_OFFSET+0x00407B8
#define SRM_DI1_SSC__EMPTY                                      IPU_MEMORY_OFFSET+0x00407B8,0x00000000
#define SRM_DI1_SSC__FULL                                       IPU_MEMORY_OFFSET+0x00407B8,0xffffffff
#define SRM_DI1_SSC__DI1_PIN17_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00800000
#define SRM_DI1_SSC__DI1_PIN16_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00400000
#define SRM_DI1_SSC__DI1_PIN15_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00200000
#define SRM_DI1_SSC__DI1_PIN14_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00100000
#define SRM_DI1_SSC__DI1_PIN13_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00080000
#define SRM_DI1_SSC__DI1_PIN12_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00040000
#define SRM_DI1_SSC__DI1_PIN11_ERM                              IPU_MEMORY_OFFSET+0x00407B8,0x00020000
#define SRM_DI1_SSC__DI1_CS_ERM                                 IPU_MEMORY_OFFSET+0x00407B8,0x00010000
#define SRM_DI1_SSC__DI1_WAIT_ON                                IPU_MEMORY_OFFSET+0x00407B8,0x00000020
#define SRM_DI1_SSC__DI1_BYTE_EN_RD_IN                          IPU_MEMORY_OFFSET+0x00407B8,0x00000008
#define SRM_DI1_SSC__DI1_BYTE_EN_PNTR                           IPU_MEMORY_OFFSET+0x00407B8,0x00000007

#define SRM_DI1_POL__ADDR                                       IPU_MEMORY_OFFSET+0x00407BC
#define SRM_DI1_POL__EMPTY                                      IPU_MEMORY_OFFSET+0x00407BC,0x00000000
#define SRM_DI1_POL__FULL                                       IPU_MEMORY_OFFSET+0x00407BC,0xffffffff
#define SRM_DI1_POL__DI1_WAIT_POLARITY                          IPU_MEMORY_OFFSET+0x00407BC,0x04000000
#define SRM_DI1_POL__DI1_CS1_BYTE_EN_POLARITY                   IPU_MEMORY_OFFSET+0x00407BC,0x02000000
#define SRM_DI1_POL__DI1_CS0_BYTE_EN_POLARITY                   IPU_MEMORY_OFFSET+0x00407BC,0x01000000
#define SRM_DI1_POL__DI1_CS1_DATA_POLARITY                      IPU_MEMORY_OFFSET+0x00407BC,0x00800000
#define SRM_DI1_POL__DI1_CS1_POLARITY_17                        IPU_MEMORY_OFFSET+0x00407BC,0x00400000
#define SRM_DI1_POL__DI1_CS1_POLARITY_16                        IPU_MEMORY_OFFSET+0x00407BC,0x00200000
#define SRM_DI1_POL__DI1_CS1_POLARITY_15                        IPU_MEMORY_OFFSET+0x00407BC,0x00100000
#define SRM_DI1_POL__DI1_CS1_POLARITY_14                        IPU_MEMORY_OFFSET+0x00407BC,0x00080000
#define SRM_DI1_POL__DI1_CS1_POLARITY_13                        IPU_MEMORY_OFFSET+0x00407BC,0x00040000
#define SRM_DI1_POL__DI1_CS1_POLARITY_12                        IPU_MEMORY_OFFSET+0x00407BC,0x00020000
#define SRM_DI1_POL__DI1_CS1_POLARITY_11                        IPU_MEMORY_OFFSET+0x00407BC,0x00010000
#define SRM_DI1_POL__DI1_CS0_DATA_POLARITY                      IPU_MEMORY_OFFSET+0x00407BC,0x00008000
#define SRM_DI1_POL__DI1_CS0_POLARITY_17                        IPU_MEMORY_OFFSET+0x00407BC,0x00004000
#define SRM_DI1_POL__DI1_CS0_POLARITY_16                        IPU_MEMORY_OFFSET+0x00407BC,0x00002000
#define SRM_DI1_POL__DI1_CS0_POLARITY_15                        IPU_MEMORY_OFFSET+0x00407BC,0x00001000
#define SRM_DI1_POL__DI1_CS0_POLARITY_14                        IPU_MEMORY_OFFSET+0x00407BC,0x00000800
#define SRM_DI1_POL__DI1_CS0_POLARITY_13                        IPU_MEMORY_OFFSET+0x00407BC,0x00000400
#define SRM_DI1_POL__DI1_CS0_POLARITY_12                        IPU_MEMORY_OFFSET+0x00407BC,0x00000200
#define SRM_DI1_POL__DI1_CS0_POLARITY_11                        IPU_MEMORY_OFFSET+0x00407BC,0x00000100
#define SRM_DI1_POL__DI1_DRDY_DATA_POLARITY                     IPU_MEMORY_OFFSET+0x00407BC,0x00000080
#define SRM_DI1_POL__DI1_DRDY_POLARITY_17                       IPU_MEMORY_OFFSET+0x00407BC,0x00000040
#define SRM_DI1_POL__DI1_DRDY_POLARITY_16                       IPU_MEMORY_OFFSET+0x00407BC,0x00000020
#define SRM_DI1_POL__DI1_DRDY_POLARITY_15                       IPU_MEMORY_OFFSET+0x00407BC,0x00000010
#define SRM_DI1_POL__DI1_DRDY_POLARITY_14                       IPU_MEMORY_OFFSET+0x00407BC,0x00000008
#define SRM_DI1_POL__DI1_DRDY_POLARITY_13                       IPU_MEMORY_OFFSET+0x00407BC,0x00000004
#define SRM_DI1_POL__DI1_DRDY_POLARITY_12                       IPU_MEMORY_OFFSET+0x00407BC,0x00000002
#define SRM_DI1_POL__DI1_DRDY_POLARITY_11                       IPU_MEMORY_OFFSET+0x00407BC,0x00000001

#define SRM_DI1_AW0__ADDR                                       IPU_MEMORY_OFFSET+0x00407C0
#define SRM_DI1_AW0__EMPTY                                      IPU_MEMORY_OFFSET+0x00407C0,0x00000000
#define SRM_DI1_AW0__FULL                                       IPU_MEMORY_OFFSET+0x00407C0,0xffffffff
#define SRM_DI1_AW0__DI1_AW_TRIG_SEL                            IPU_MEMORY_OFFSET+0x00407C0,0xF0000000
#define SRM_DI1_AW0__DI1_AW_HEND                                IPU_MEMORY_OFFSET+0x00407C0,0x0FFF0000
#define SRM_DI1_AW0__DI1_AW_HCOUNT_SEL                          IPU_MEMORY_OFFSET+0x00407C0,0x0000F000
#define SRM_DI1_AW0__DI1_AW_HSTART                              IPU_MEMORY_OFFSET+0x00407C0,0x00000FFF

#define SRM_DI1_AW1__ADDR                                       IPU_MEMORY_OFFSET+0x00407C4
#define SRM_DI1_AW1__EMPTY                                      IPU_MEMORY_OFFSET+0x00407C4,0x00000000
#define SRM_DI1_AW1__FULL                                       IPU_MEMORY_OFFSET+0x00407C4,0xffffffff
#define SRM_DI1_AW1__DI1_AW_VEND                                IPU_MEMORY_OFFSET+0x00407C4,0x0FFF0000
#define SRM_DI1_AW1__DI1_AW_VCOUNT_SEL                          IPU_MEMORY_OFFSET+0x00407C4,0x0000F000
#define SRM_DI1_AW1__DI1_AW_VSTART                              IPU_MEMORY_OFFSET+0x00407C4,0x00000FFF

#define SRM_DI1_SCR_CONF__ADDR                                  IPU_MEMORY_OFFSET+0x00407C8
#define SRM_DI1_SCR_CONF__EMPTY                                 IPU_MEMORY_OFFSET+0x00407C8,0x00000000
#define SRM_DI1_SCR_CONF__FULL                                  IPU_MEMORY_OFFSET+0x00407C8,0xffffffff
#define SRM_DI1_SCR_CONF__DI1_SCREEN_HEIGHT                     IPU_MEMORY_OFFSET+0x00407C8,0x00000FFF

#define SRM_DC_WR_CH_CONF_2__ADDR                               IPU_MEMORY_OFFSET+0x00404AC
#define SRM_DC_WR_CH_CONF_2__EMPTY                              IPU_MEMORY_OFFSET+0x00404AC,0x00000000
#define SRM_DC_WR_CH_CONF_2__FULL                               IPU_MEMORY_OFFSET+0x00404AC,0xffffffff
#define SRM_DC_WR_CH_CONF_2__PROG_START_TIME_2                  IPU_MEMORY_OFFSET+0x00404AC,0x07FF0000
#define SRM_DC_WR_CH_CONF_2__CHAN_MASK_DEFAULT_2                IPU_MEMORY_OFFSET+0x00404AC,0x00000100
#define SRM_DC_WR_CH_CONF_2__PROG_CHAN_TYP_2                    IPU_MEMORY_OFFSET+0x00404AC,0x000000E0
#define SRM_DC_WR_CH_CONF_2__PROG_DISP_ID_2                     IPU_MEMORY_OFFSET+0x00404AC,0x00000018
#define SRM_DC_WR_CH_CONF_2__PROG_DI_ID_2                       IPU_MEMORY_OFFSET+0x00404AC,0x00000004
#define SRM_DC_WR_CH_CONF_2__W_SIZE_2                           IPU_MEMORY_OFFSET+0x00404AC,0x00000003

#define SRM_DC_WR_CH_ADDR_2__ADDR                               IPU_MEMORY_OFFSET+0x00404B0
#define SRM_DC_WR_CH_ADDR_2__EMPTY                              IPU_MEMORY_OFFSET+0x00404B0,0x00000000
#define SRM_DC_WR_CH_ADDR_2__FULL                               IPU_MEMORY_OFFSET+0x00404B0,0xffffffff
#define SRM_DC_WR_CH_ADDR_2__ST_ADDR_2                          IPU_MEMORY_OFFSET+0x00404B0,0x1FFFFFFF

#define SRM_DC_RL0_CH_2__ADDR                                   IPU_MEMORY_OFFSET+0x00404B4
#define SRM_DC_RL0_CH_2__EMPTY                                  IPU_MEMORY_OFFSET+0x00404B4,0x00000000
#define SRM_DC_RL0_CH_2__FULL                                   IPU_MEMORY_OFFSET+0x00404B4,0xffffffff
#define SRM_DC_RL0_CH_2__COD_NL_START_CHAN_2                    IPU_MEMORY_OFFSET+0x00404B4,0xFF000000
#define SRM_DC_RL0_CH_2__COD_NL_PRIORITY_CHAN_2                 IPU_MEMORY_OFFSET+0x00404B4,0x000F0000
#define SRM_DC_RL0_CH_2__COD_NF_START_CHAN_2                    IPU_MEMORY_OFFSET+0x00404B4,0x0000FF00
#define SRM_DC_RL0_CH_2__COD_NF_PRIORITY_CHAN_2                 IPU_MEMORY_OFFSET+0x00404B4,0x0000000F

#define SRM_DC_RL1_CH_2__ADDR                                   IPU_MEMORY_OFFSET+0x00404B8
#define SRM_DC_RL1_CH_2__EMPTY                                  IPU_MEMORY_OFFSET+0x00404B8,0x00000000
#define SRM_DC_RL1_CH_2__FULL                                   IPU_MEMORY_OFFSET+0x00404B8,0xffffffff
#define SRM_DC_RL1_CH_2__COD_NFIELD_START_CHAN_2                IPU_MEMORY_OFFSET+0x00404B8,0xFF000000
#define SRM_DC_RL1_CH_2__COD_NFIELD_PRIORITY_CHAN_2             IPU_MEMORY_OFFSET+0x00404B8,0x000F0000
#define SRM_DC_RL1_CH_2__COD_EOF_START_CHAN_2                   IPU_MEMORY_OFFSET+0x00404B8,0x0000FF00
#define SRM_DC_RL1_CH_2__COD_EOF_PRIORITY_CHAN_2                IPU_MEMORY_OFFSET+0x00404B8,0x0000000F

#define SRM_DC_RL2_CH_2__ADDR                                   IPU_MEMORY_OFFSET+0x00404BC
#define SRM_DC_RL2_CH_2__EMPTY                                  IPU_MEMORY_OFFSET+0x00404BC,0x00000000
#define SRM_DC_RL2_CH_2__FULL                                   IPU_MEMORY_OFFSET+0x00404BC,0xffffffff
#define SRM_DC_RL2_CH_2__COD_EOFIELD_START_CHAN_2               IPU_MEMORY_OFFSET+0x00404BC,0xFF000000
#define SRM_DC_RL2_CH_2__COD_EOFIELD_PRIORITY_CHAN_2            IPU_MEMORY_OFFSET+0x00404BC,0x000F0000
#define SRM_DC_RL2_CH_2__COD_EOL_START_CHAN_2                   IPU_MEMORY_OFFSET+0x00404BC,0x0000FF00
#define SRM_DC_RL2_CH_2__COD_EOL_PRIORITY_CHAN_2                IPU_MEMORY_OFFSET+0x00404BC,0x0000000F

#define SRM_DC_RL3_CH_2__ADDR                                   IPU_MEMORY_OFFSET+0x00404C0
#define SRM_DC_RL3_CH_2__EMPTY                                  IPU_MEMORY_OFFSET+0x00404C0,0x00000000
#define SRM_DC_RL3_CH_2__FULL                                   IPU_MEMORY_OFFSET+0x00404C0,0xffffffff
#define SRM_DC_RL3_CH_2__COD_NEW_CHAN_START_CHAN_2              IPU_MEMORY_OFFSET+0x00404C0,0xFF000000
#define SRM_DC_RL3_CH_2__COD_NEW_CHAN_PRIORITY_CHAN_2           IPU_MEMORY_OFFSET+0x00404C0,0x000F0000
#define SRM_DC_RL3_CH_2__COD_NEW_ADDR_START_CHAN_2              IPU_MEMORY_OFFSET+0x00404C0,0x0000FF00
#define SRM_DC_RL3_CH_2__COD_NEW_ADDR_PRIORITY_CHAN_2           IPU_MEMORY_OFFSET+0x00404C0,0x0000000F

#define SRM_DC_RL4_CH_2__ADDR                                   IPU_MEMORY_OFFSET+0x00404C4
#define SRM_DC_RL4_CH_2__EMPTY                                  IPU_MEMORY_OFFSET+0x00404C4,0x00000000
#define SRM_DC_RL4_CH_2__FULL                                   IPU_MEMORY_OFFSET+0x00404C4,0xffffffff
#define SRM_DC_RL4_CH_2__COD_NEW_DATA_START_CHAN_2              IPU_MEMORY_OFFSET+0x00404C4,0x0000FF00
#define SRM_DC_RL4_CH_2__COD_NEW_DATA_PRIORITY_CHAN_2           IPU_MEMORY_OFFSET+0x00404C4,0x0000000F

#define SRM_DC_WR_CH_CONF_6__ADDR                               IPU_MEMORY_OFFSET+0x00404C8
#define SRM_DC_WR_CH_CONF_6__EMPTY                              IPU_MEMORY_OFFSET+0x00404C8,0x00000000
#define SRM_DC_WR_CH_CONF_6__FULL                               IPU_MEMORY_OFFSET+0x00404C8,0xffffffff
#define SRM_DC_WR_CH_CONF_6__PROG_START_TIME_6                  IPU_MEMORY_OFFSET+0x00404C8,0x07FF0000
#define SRM_DC_WR_CH_CONF_6__CHAN_MASK_DEFAULT_6                IPU_MEMORY_OFFSET+0x00404C8,0x00000100
#define SRM_DC_WR_CH_CONF_6__PROG_CHAN_TYP_6                    IPU_MEMORY_OFFSET+0x00404C8,0x000000E0
#define SRM_DC_WR_CH_CONF_6__PROG_DISP_ID_6                     IPU_MEMORY_OFFSET+0x00404C8,0x00000018
#define SRM_DC_WR_CH_CONF_6__PROG_DI_ID_6                       IPU_MEMORY_OFFSET+0x00404C8,0x00000004
#define SRM_DC_WR_CH_CONF_6__W_SIZE_6                           IPU_MEMORY_OFFSET+0x00404C8,0x00000003

#define SRM_DC_WR_CH_ADDR_6__ADDR                               IPU_MEMORY_OFFSET+0x00404CC
#define SRM_DC_WR_CH_ADDR_6__EMPTY                              IPU_MEMORY_OFFSET+0x00404CC,0x00000000
#define SRM_DC_WR_CH_ADDR_6__FULL                               IPU_MEMORY_OFFSET+0x00404CC,0xffffffff
#define SRM_DC_WR_CH_ADDR_6__ST_ADDR_6                          IPU_MEMORY_OFFSET+0x00404CC,0x1FFFFFFF

#define SRM_DC_RL0_CH_6__ADDR                                   IPU_MEMORY_OFFSET+0x00404D0
#define SRM_DC_RL0_CH_6__EMPTY                                  IPU_MEMORY_OFFSET+0x00404D0,0x00000000
#define SRM_DC_RL0_CH_6__FULL                                   IPU_MEMORY_OFFSET+0x00404D0,0xffffffff
#define SRM_DC_RL0_CH_6__COD_NL_START_CHAN_6                    IPU_MEMORY_OFFSET+0x00404D0,0xFF000000
#define SRM_DC_RL0_CH_6__COD_NL_PRIORITY_CHAN_6                 IPU_MEMORY_OFFSET+0x00404D0,0x000F0000
#define SRM_DC_RL0_CH_6__COD_NF_START_CHAN_6                    IPU_MEMORY_OFFSET+0x00404D0,0x0000FF00
#define SRM_DC_RL0_CH_6__COD_NF_PRIORITY_CHAN_6                 IPU_MEMORY_OFFSET+0x00404D0,0x0000000F

#define SRM_DC_RL1_CH_6__ADDR                                   IPU_MEMORY_OFFSET+0x00404D4
#define SRM_DC_RL1_CH_6__EMPTY                                  IPU_MEMORY_OFFSET+0x00404D4,0x00000000
#define SRM_DC_RL1_CH_6__FULL                                   IPU_MEMORY_OFFSET+0x00404D4,0xffffffff
#define SRM_DC_RL1_CH_6__COD_NFIELD_START_CHAN_6                IPU_MEMORY_OFFSET+0x00404D4,0xFF000000
#define SRM_DC_RL1_CH_6__COD_NFIELD_PRIORITY_CHAN_6             IPU_MEMORY_OFFSET+0x00404D4,0x000F0000
#define SRM_DC_RL1_CH_6__COD_EOF_START_CHAN_6                   IPU_MEMORY_OFFSET+0x00404D4,0x0000FF00
#define SRM_DC_RL1_CH_6__COD_EOF_PRIORITY_CHAN_6                IPU_MEMORY_OFFSET+0x00404D4,0x0000000F

#define SRM_DC_RL2_CH_6__ADDR                                   IPU_MEMORY_OFFSET+0x00404D8
#define SRM_DC_RL2_CH_6__EMPTY                                  IPU_MEMORY_OFFSET+0x00404D8,0x00000000
#define SRM_DC_RL2_CH_6__FULL                                   IPU_MEMORY_OFFSET+0x00404D8,0xffffffff
#define SRM_DC_RL2_CH_6__COD_EOFIELD_START_CHAN_6               IPU_MEMORY_OFFSET+0x00404D8,0xFF000000
#define SRM_DC_RL2_CH_6__COD_EOFIELD_PRIORITY_CHAN_6            IPU_MEMORY_OFFSET+0x00404D8,0x000F0000
#define SRM_DC_RL2_CH_6__COD_EOL_START_CHAN_6                   IPU_MEMORY_OFFSET+0x00404D8,0x0000FF00
#define SRM_DC_RL2_CH_6__COD_EOL_PRIORITY_CHAN_6                IPU_MEMORY_OFFSET+0x00404D8,0x0000000F

#define SRM_DC_RL3_CH_6__ADDR                                   IPU_MEMORY_OFFSET+0x00404DC
#define SRM_DC_RL3_CH_6__EMPTY                                  IPU_MEMORY_OFFSET+0x00404DC,0x00000000
#define SRM_DC_RL3_CH_6__FULL                                   IPU_MEMORY_OFFSET+0x00404DC,0xffffffff
#define SRM_DC_RL3_CH_6__COD_NEW_CHAN_START_CHAN_6              IPU_MEMORY_OFFSET+0x00404DC,0xFF000000
#define SRM_DC_RL3_CH_6__COD_NEW_CHAN_PRIORITY_CHAN_6           IPU_MEMORY_OFFSET+0x00404DC,0x000F0000
#define SRM_DC_RL3_CH_6__COD_NEW_ADDR_START_CHAN_6              IPU_MEMORY_OFFSET+0x00404DC,0x0000FF00
#define SRM_DC_RL3_CH_6__COD_NEW_ADDR_PRIORITY_CHAN_6           IPU_MEMORY_OFFSET+0x00404DC,0x0000000F

#define SRM_DC_RL4_CH_6__ADDR                                   IPU_MEMORY_OFFSET+0x00404E0
#define SRM_DC_RL4_CH_6__EMPTY                                  IPU_MEMORY_OFFSET+0x00404E0,0x00000000
#define SRM_DC_RL4_CH_6__FULL                                   IPU_MEMORY_OFFSET+0x00404E0,0xffffffff
#define SRM_DC_RL4_CH_6__COD_NEW_DATA_START_CHAN_6              IPU_MEMORY_OFFSET+0x00404E0,0x0000FF00
#define SRM_DC_RL4_CH_6__COD_NEW_DATA_PRIORITY_CHAN_6           IPU_MEMORY_OFFSET+0x00404E0,0x0000000F

#define IPU_MEM_DC_MICROCODE_BASE_ADDR IPU_MEMORY_OFFSET+0x0080000

#define LPM_MEM_IPU_CONF__ADDR                                  IPU_MEMORY_OFFSET+0x0040834
#define LPM_MEM_IPU_CONF__EMPTY                                 IPU_MEMORY_OFFSET+0x0040834,0x00000000
#define LPM_MEM_IPU_CONF__IDMAC_DISABLE                         IPU_MEMORY_OFFSET+0x0040834,0x00400000
#define LPM_MEM_IPU_CONF__IPU_DIAGBUS_ON                        IPU_MEMORY_OFFSET+0x0040834,0x00200000
#define LPM_MEM_IPU_CONF__IPU_DIAGBUS_MODE                      IPU_MEMORY_OFFSET+0x0040834,0x001F0000
#define LPM_MEM_IPU_CONF__VDI_EN                                IPU_MEMORY_OFFSET+0x0040834,0x00001000
#define LPM_MEM_IPU_CONF__SISG_EN                               IPU_MEMORY_OFFSET+0x0040834,0x00000800
#define LPM_MEM_IPU_CONF__DMFC_EN                               IPU_MEMORY_OFFSET+0x0040834,0x00000400
#define LPM_MEM_IPU_CONF__DC_EN                                 IPU_MEMORY_OFFSET+0x0040834,0x00000200
#define LPM_MEM_IPU_CONF__SMFC_EN                               IPU_MEMORY_OFFSET+0x0040834,0x00000100
#define LPM_MEM_IPU_CONF__DI1_EN                                IPU_MEMORY_OFFSET+0x0040834,0x00000080
#define LPM_MEM_IPU_CONF__DI0_EN                                IPU_MEMORY_OFFSET+0x0040834,0x00000040
#define LPM_MEM_IPU_CONF__FULL                                  IPU_MEMORY_OFFSET+0x0040834,0xffffffff
#define LPM_MEM_IPU_CONF__DP_EN                                 IPU_MEMORY_OFFSET+0x0040834,0x00000020
#define LPM_MEM_IPU_CONF__IRT_EN                                IPU_MEMORY_OFFSET+0x0040834,0x00000008
#define LPM_MEM_IPU_CONF__IC_EN                                 IPU_MEMORY_OFFSET+0x0040834,0x00000004
#define LPM_MEM_IPU_CONF__CSI1_EN                               IPU_MEMORY_OFFSET+0x0040834,0x00000002
#define LPM_MEM_IPU_CONF__CSI0_EN                               IPU_MEMORY_OFFSET+0x0040834,0x00000001
#define LPM_MEM_IPU_CONF__CSI_SEL                               IPU_MEMORY_OFFSET+0x0040834,0x80000000
#define LPM_MEM_IPU_CONF__IC_INPUT                              IPU_MEMORY_OFFSET+0x0040834,0x40000000
#define LPM_MEM_IPU_CONF__CSI1_DATA_SOURCE                      IPU_MEMORY_OFFSET+0x0040834,0x20000000
#define LPM_MEM_IPU_CONF__CSI0_DATA_SOURCE                      IPU_MEMORY_OFFSET+0x0040834,0x10000000
#define LPM_MEM_IPU_CONF__VDI_DMFC_SYNC                         IPU_MEMORY_OFFSET+0x0040834,0x08000000
#define LPM_MEM_IPU_CONF__IC_DMFC_SYNC                          IPU_MEMORY_OFFSET+0x0040834,0x04000000
#define LPM_MEM_IPU_CONF__IC_DMFC_SEL                           IPU_MEMORY_OFFSET+0x0040834,0x02000000

#define LPM_MEM_SISG_CTRL0__ADDR                                IPU_MEMORY_OFFSET+0x0040838
#define LPM_MEM_SISG_CTRL0__EMPTY                               IPU_MEMORY_OFFSET+0x0040838,0x00000000
#define LPM_MEM_SISG_CTRL0__FULL                                IPU_MEMORY_OFFSET+0x0040838,0xffffffff
#define LPM_MEM_SISG_CTRL0__EXT_ACTV                            IPU_MEMORY_OFFSET+0x0040838,0x40000000
#define LPM_MEM_SISG_CTRL0__MCU_ACTV_TRIG                       IPU_MEMORY_OFFSET+0x0040838,0x20000000
#define LPM_MEM_SISG_CTRL0__VAL_STOP_SISG_COUNTER               IPU_MEMORY_OFFSET+0x0040838,0x1FFFFFF0
#define LPM_MEM_SISG_CTRL0__NO_OF_VSYNC                         IPU_MEMORY_OFFSET+0x0040838,0x0000000E
#define LPM_MEM_SISG_CTRL0__VSYNC_RESET_COUNTER                 IPU_MEMORY_OFFSET+0x0040838,0x00000001

#define LPM_MEM_SISG_CTRL1__ADDR                                IPU_MEMORY_OFFSET+0x004083C
#define LPM_MEM_SISG_CTRL1__EMPTY                               IPU_MEMORY_OFFSET+0x004083C,0x00000000
#define LPM_MEM_SISG_CTRL1__FULL                                IPU_MEMORY_OFFSET+0x004083C,0xffffffff
#define LPM_MEM_SISG_CTRL1__SISG_OUT_POL                        IPU_MEMORY_OFFSET+0x004083C,0x00003F00
#define LPM_MEM_SISG_CTRL1__SISG_STROBE_CNT                     IPU_MEMORY_OFFSET+0x004083C,0x0000001F

#define LPM_MEM_SISG_SET_1__ADDR                                IPU_MEMORY_OFFSET+0x0040840
#define LPM_MEM_SISG_SET_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040840,0x00000000
#define LPM_MEM_SISG_SET_1__FULL                                IPU_MEMORY_OFFSET+0x0040840,0xffffffff
#define LPM_MEM_SISG_SET_1__SISG_SET_1                          IPU_MEMORY_OFFSET+0x0040840,0x01FFFFFF

#define LPM_MEM_SISG_SET_2__ADDR                                IPU_MEMORY_OFFSET+0x0040844
#define LPM_MEM_SISG_SET_2__EMPTY                               IPU_MEMORY_OFFSET+0x0040844,0x00000000
#define LPM_MEM_SISG_SET_2__FULL                                IPU_MEMORY_OFFSET+0x0040844,0xffffffff
#define LPM_MEM_SISG_SET_2__SISG_SET_2                          IPU_MEMORY_OFFSET+0x0040844,0x01FFFFFF

#define LPM_MEM_SISG_SET_3__ADDR                                IPU_MEMORY_OFFSET+0x0040848
#define LPM_MEM_SISG_SET_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040848,0x00000000
#define LPM_MEM_SISG_SET_3__FULL                                IPU_MEMORY_OFFSET+0x0040848,0xffffffff
#define LPM_MEM_SISG_SET_3__SISG_SET_3                          IPU_MEMORY_OFFSET+0x0040848,0x01FFFFFF

#define LPM_MEM_SISG_SET_4__ADDR                                IPU_MEMORY_OFFSET+0x004084C
#define LPM_MEM_SISG_SET_4__EMPTY                               IPU_MEMORY_OFFSET+0x004084C,0x00000000
#define LPM_MEM_SISG_SET_4__FULL                                IPU_MEMORY_OFFSET+0x004084C,0xffffffff
#define LPM_MEM_SISG_SET_4__SISG_SET_4                          IPU_MEMORY_OFFSET+0x004084C,0x01FFFFFF

#define LPM_MEM_SISG_SET_5__ADDR                                IPU_MEMORY_OFFSET+0x0040850
#define LPM_MEM_SISG_SET_5__EMPTY                               IPU_MEMORY_OFFSET+0x0040850,0x00000000
#define LPM_MEM_SISG_SET_5__FULL                                IPU_MEMORY_OFFSET+0x0040850,0xffffffff
#define LPM_MEM_SISG_SET_5__SISG_SET_5                          IPU_MEMORY_OFFSET+0x0040850,0x01FFFFFF

#define LPM_MEM_SISG_SET_6__ADDR                                IPU_MEMORY_OFFSET+0x0040854
#define LPM_MEM_SISG_SET_6__EMPTY                               IPU_MEMORY_OFFSET+0x0040854,0x00000000
#define LPM_MEM_SISG_SET_6__FULL                                IPU_MEMORY_OFFSET+0x0040854,0xffffffff
#define LPM_MEM_SISG_SET_6__SISG_SET_6                          IPU_MEMORY_OFFSET+0x0040854,0x01FFFFFF

#define LPM_MEM_SISG_CLR_1__ADDR                                IPU_MEMORY_OFFSET+0x0040858
#define LPM_MEM_SISG_CLR_1__EMPTY                               IPU_MEMORY_OFFSET+0x0040858,0x00000000
#define LPM_MEM_SISG_CLR_1__FULL                                IPU_MEMORY_OFFSET+0x0040858,0xffffffff
#define LPM_MEM_SISG_CLR_1__SISG_CLEAR_1                        IPU_MEMORY_OFFSET+0x0040858,0x01FFFFFF

#define LPM_MEM_SISG_CLR_2__ADDR                                IPU_MEMORY_OFFSET+0x004085C
#define LPM_MEM_SISG_CLR_2__EMPTY                               IPU_MEMORY_OFFSET+0x004085C,0x00000000
#define LPM_MEM_SISG_CLR_2__FULL                                IPU_MEMORY_OFFSET+0x004085C,0xffffffff
#define LPM_MEM_SISG_CLR_2__SISG_CLEAR_2                        IPU_MEMORY_OFFSET+0x004085C,0x01FFFFFF

#define LPM_MEM_SISG_CLR_3__ADDR                                IPU_MEMORY_OFFSET+0x0040860
#define LPM_MEM_SISG_CLR_3__EMPTY                               IPU_MEMORY_OFFSET+0x0040860,0x00000000
#define LPM_MEM_SISG_CLR_3__FULL                                IPU_MEMORY_OFFSET+0x0040860,0xffffffff
#define LPM_MEM_SISG_CLR_3__SISG_CLEAR_3                        IPU_MEMORY_OFFSET+0x0040860,0x01FFFFFF

#define LPM_MEM_SISG_CLR_4__ADDR                                IPU_MEMORY_OFFSET+0x0040864
#define LPM_MEM_SISG_CLR_4__EMPTY                               IPU_MEMORY_OFFSET+0x0040864,0x00000000
#define LPM_MEM_SISG_CLR_4__FULL                                IPU_MEMORY_OFFSET+0x0040864,0xffffffff
#define LPM_MEM_SISG_CLR_4__SISG_CLEAR_4                        IPU_MEMORY_OFFSET+0x0040864,0x01FFFFFF

#define LPM_MEM_SISG_CLR_5__ADDR                                IPU_MEMORY_OFFSET+0x0040868
#define LPM_MEM_SISG_CLR_5__EMPTY                               IPU_MEMORY_OFFSET+0x0040868,0x00000000
#define LPM_MEM_SISG_CLR_5__FULL                                IPU_MEMORY_OFFSET+0x0040868,0xffffffff
#define LPM_MEM_SISG_CLR_5__SISG_CLEAR_5                        IPU_MEMORY_OFFSET+0x0040868,0x01FFFFFF

#define LPM_MEM_SISG_CLR_6__ADDR                                IPU_MEMORY_OFFSET+0x004086C
#define LPM_MEM_SISG_CLR_6__EMPTY                               IPU_MEMORY_OFFSET+0x004086C,0x00000000
#define LPM_MEM_SISG_CLR_6__FULL                                IPU_MEMORY_OFFSET+0x004086C,0xffffffff
#define LPM_MEM_SISG_CLR_6__SISG_CLEAR_6                        IPU_MEMORY_OFFSET+0x004086C,0x01FFFFFF

#define LPM_MEM_IPU_INT_CTRL_1__ADDR                            IPU_MEMORY_OFFSET+0x0040870
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_19                 IPU_MEMORY_OFFSET+0x0040870,0x00080000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_18                 IPU_MEMORY_OFFSET+0x0040870,0x00040000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_17                 IPU_MEMORY_OFFSET+0x0040870,0x00020000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_15                 IPU_MEMORY_OFFSET+0x0040870,0x00008000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_14                 IPU_MEMORY_OFFSET+0x0040870,0x00004000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_13                 IPU_MEMORY_OFFSET+0x0040870,0x00002000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_12                 IPU_MEMORY_OFFSET+0x0040870,0x00001000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_11                 IPU_MEMORY_OFFSET+0x0040870,0x00000800
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_10                 IPU_MEMORY_OFFSET+0x0040870,0x00000400
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_9                  IPU_MEMORY_OFFSET+0x0040870,0x00000200
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_8                  IPU_MEMORY_OFFSET+0x0040870,0x00000100
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_5                  IPU_MEMORY_OFFSET+0x0040870,0x00000020
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_3                  IPU_MEMORY_OFFSET+0x0040870,0x00000008
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_2                  IPU_MEMORY_OFFSET+0x0040870,0x00000004
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_1                  IPU_MEMORY_OFFSET+0x0040870,0x00000002
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_0                  IPU_MEMORY_OFFSET+0x0040870,0x00000001
#define LPM_MEM_IPU_INT_CTRL_1__EMPTY                           IPU_MEMORY_OFFSET+0x0040870,0x00000000
#define LPM_MEM_IPU_INT_CTRL_1__FULL                            IPU_MEMORY_OFFSET+0x0040870,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_31                 IPU_MEMORY_OFFSET+0x0040870,0x80000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_29                 IPU_MEMORY_OFFSET+0x0040870,0x20000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_28                 IPU_MEMORY_OFFSET+0x0040870,0x10000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_27                 IPU_MEMORY_OFFSET+0x0040870,0x08000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_26                 IPU_MEMORY_OFFSET+0x0040870,0x04000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_25                 IPU_MEMORY_OFFSET+0x0040870,0x02000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_24                 IPU_MEMORY_OFFSET+0x0040870,0x01000000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_23                 IPU_MEMORY_OFFSET+0x0040870,0x00800000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_22                 IPU_MEMORY_OFFSET+0x0040870,0x00400000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_21                 IPU_MEMORY_OFFSET+0x0040870,0x00200000
#define LPM_MEM_IPU_INT_CTRL_1__IDMAC_EOF_EN_20                 IPU_MEMORY_OFFSET+0x0040870,0x00100000

#define LPM_MEM_IPU_INT_CTRL_2__ADDR                            IPU_MEMORY_OFFSET+0x0040874
#define LPM_MEM_IPU_INT_CTRL_2__EMPTY                           IPU_MEMORY_OFFSET+0x0040874,0x00000000
#define LPM_MEM_IPU_INT_CTRL_2__FULL                            IPU_MEMORY_OFFSET+0x0040874,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_52                 IPU_MEMORY_OFFSET+0x0040874,0x00100000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_51                 IPU_MEMORY_OFFSET+0x0040874,0x00080000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_50                 IPU_MEMORY_OFFSET+0x0040874,0x00040000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_49                 IPU_MEMORY_OFFSET+0x0040874,0x00020000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_48                 IPU_MEMORY_OFFSET+0x0040874,0x00010000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_47                 IPU_MEMORY_OFFSET+0x0040874,0x00008000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_46                 IPU_MEMORY_OFFSET+0x0040874,0x00004000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_45                 IPU_MEMORY_OFFSET+0x0040874,0x00002000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_44                 IPU_MEMORY_OFFSET+0x0040874,0x00001000
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_43                 IPU_MEMORY_OFFSET+0x0040874,0x00000800
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_42                 IPU_MEMORY_OFFSET+0x0040874,0x00000400
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_41                 IPU_MEMORY_OFFSET+0x0040874,0x00000200
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_40                 IPU_MEMORY_OFFSET+0x0040874,0x00000100
#define LPM_MEM_IPU_INT_CTRL_2__IDMAC_EOF_EN_33                 IPU_MEMORY_OFFSET+0x0040874,0x00000002

#define LPM_MEM_IPU_INT_CTRL_3__ADDR                            IPU_MEMORY_OFFSET+0x0040878
#define LPM_MEM_IPU_INT_CTRL_3__EMPTY                           IPU_MEMORY_OFFSET+0x0040878,0x00000000
#define LPM_MEM_IPU_INT_CTRL_3__FULL                            IPU_MEMORY_OFFSET+0x0040878,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_31               IPU_MEMORY_OFFSET+0x0040878,0x80000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_29               IPU_MEMORY_OFFSET+0x0040878,0x20000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_28               IPU_MEMORY_OFFSET+0x0040878,0x10000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_27               IPU_MEMORY_OFFSET+0x0040878,0x08000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_26               IPU_MEMORY_OFFSET+0x0040878,0x04000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_25               IPU_MEMORY_OFFSET+0x0040878,0x02000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_24               IPU_MEMORY_OFFSET+0x0040878,0x01000000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_23               IPU_MEMORY_OFFSET+0x0040878,0x00800000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_22               IPU_MEMORY_OFFSET+0x0040878,0x00400000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_21               IPU_MEMORY_OFFSET+0x0040878,0x00200000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_20               IPU_MEMORY_OFFSET+0x0040878,0x00100000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_19               IPU_MEMORY_OFFSET+0x0040878,0x00080000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_18               IPU_MEMORY_OFFSET+0x0040878,0x00040000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_17               IPU_MEMORY_OFFSET+0x0040878,0x00020000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_15               IPU_MEMORY_OFFSET+0x0040878,0x00008000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_14               IPU_MEMORY_OFFSET+0x0040878,0x00004000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_13               IPU_MEMORY_OFFSET+0x0040878,0x00002000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_12               IPU_MEMORY_OFFSET+0x0040878,0x00001000
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_11               IPU_MEMORY_OFFSET+0x0040878,0x00000800
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_10               IPU_MEMORY_OFFSET+0x0040878,0x00000400
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_9                IPU_MEMORY_OFFSET+0x0040878,0x00000200
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_8                IPU_MEMORY_OFFSET+0x0040878,0x00000100
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_5                IPU_MEMORY_OFFSET+0x0040878,0x00000020
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_3                IPU_MEMORY_OFFSET+0x0040878,0x00000008
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_2                IPU_MEMORY_OFFSET+0x0040878,0x00000004
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_1                IPU_MEMORY_OFFSET+0x0040878,0x00000002
#define LPM_MEM_IPU_INT_CTRL_3__IDMAC_NFACK_EN_0                IPU_MEMORY_OFFSET+0x0040878,0x00000001

#define LPM_MEM_IPU_INT_CTRL_4__ADDR                            IPU_MEMORY_OFFSET+0x004087C
#define LPM_MEM_IPU_INT_CTRL_4__EMPTY                           IPU_MEMORY_OFFSET+0x004087C,0x00000000
#define LPM_MEM_IPU_INT_CTRL_4__FULL                            IPU_MEMORY_OFFSET+0x004087C,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_52               IPU_MEMORY_OFFSET+0x004087C,0x00100000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_51               IPU_MEMORY_OFFSET+0x004087C,0x00080000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_50               IPU_MEMORY_OFFSET+0x004087C,0x00040000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_49               IPU_MEMORY_OFFSET+0x004087C,0x00020000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_48               IPU_MEMORY_OFFSET+0x004087C,0x00010000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_47               IPU_MEMORY_OFFSET+0x004087C,0x00008000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_46               IPU_MEMORY_OFFSET+0x004087C,0x00004000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_45               IPU_MEMORY_OFFSET+0x004087C,0x00002000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_44               IPU_MEMORY_OFFSET+0x004087C,0x00001000
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_43               IPU_MEMORY_OFFSET+0x004087C,0x00000800
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_42               IPU_MEMORY_OFFSET+0x004087C,0x00000400
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_41               IPU_MEMORY_OFFSET+0x004087C,0x00000200
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_40               IPU_MEMORY_OFFSET+0x004087C,0x00000100
#define LPM_MEM_IPU_INT_CTRL_4__IDMAC_NFACK_EN_33               IPU_MEMORY_OFFSET+0x004087C,0x00000002

#define LPM_MEM_IPU_INT_CTRL_5__ADDR                            IPU_MEMORY_OFFSET+0x0040880
#define LPM_MEM_IPU_INT_CTRL_5__EMPTY                           IPU_MEMORY_OFFSET+0x0040880,0x00000000
#define LPM_MEM_IPU_INT_CTRL_5__FULL                            IPU_MEMORY_OFFSET+0x0040880,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_31             IPU_MEMORY_OFFSET+0x0040880,0x80000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_29             IPU_MEMORY_OFFSET+0x0040880,0x20000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_28             IPU_MEMORY_OFFSET+0x0040880,0x10000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_27             IPU_MEMORY_OFFSET+0x0040880,0x08000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_26             IPU_MEMORY_OFFSET+0x0040880,0x04000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_25             IPU_MEMORY_OFFSET+0x0040880,0x02000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_24             IPU_MEMORY_OFFSET+0x0040880,0x01000000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_23             IPU_MEMORY_OFFSET+0x0040880,0x00800000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_22             IPU_MEMORY_OFFSET+0x0040880,0x00400000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_21             IPU_MEMORY_OFFSET+0x0040880,0x00200000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_20             IPU_MEMORY_OFFSET+0x0040880,0x00100000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_19             IPU_MEMORY_OFFSET+0x0040880,0x00080000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_18             IPU_MEMORY_OFFSET+0x0040880,0x00040000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_17             IPU_MEMORY_OFFSET+0x0040880,0x00020000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_15             IPU_MEMORY_OFFSET+0x0040880,0x00008000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_14             IPU_MEMORY_OFFSET+0x0040880,0x00004000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_13             IPU_MEMORY_OFFSET+0x0040880,0x00002000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_12             IPU_MEMORY_OFFSET+0x0040880,0x00001000
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_11             IPU_MEMORY_OFFSET+0x0040880,0x00000800
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_10             IPU_MEMORY_OFFSET+0x0040880,0x00000400
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_9              IPU_MEMORY_OFFSET+0x0040880,0x00000200
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_8              IPU_MEMORY_OFFSET+0x0040880,0x00000100
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_5              IPU_MEMORY_OFFSET+0x0040880,0x00000020
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_3              IPU_MEMORY_OFFSET+0x0040880,0x00000008
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_2              IPU_MEMORY_OFFSET+0x0040880,0x00000004
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_1              IPU_MEMORY_OFFSET+0x0040880,0x00000002
#define LPM_MEM_IPU_INT_CTRL_5__IDMAC_NFB4EOF_EN_0              IPU_MEMORY_OFFSET+0x0040880,0x00000001

#define LPM_MEM_IPU_INT_CTRL_6__ADDR                            IPU_MEMORY_OFFSET+0x0040884
#define LPM_MEM_IPU_INT_CTRL_6__EMPTY                           IPU_MEMORY_OFFSET+0x0040884,0x00000000
#define LPM_MEM_IPU_INT_CTRL_6__FULL                            IPU_MEMORY_OFFSET+0x0040884,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_52             IPU_MEMORY_OFFSET+0x0040884,0x00100000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_51             IPU_MEMORY_OFFSET+0x0040884,0x00080000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_50             IPU_MEMORY_OFFSET+0x0040884,0x00040000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_49             IPU_MEMORY_OFFSET+0x0040884,0x00020000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_48             IPU_MEMORY_OFFSET+0x0040884,0x00010000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_47             IPU_MEMORY_OFFSET+0x0040884,0x00008000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_46             IPU_MEMORY_OFFSET+0x0040884,0x00004000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_45             IPU_MEMORY_OFFSET+0x0040884,0x00002000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_44             IPU_MEMORY_OFFSET+0x0040884,0x00001000
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_43             IPU_MEMORY_OFFSET+0x0040884,0x00000800
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_42             IPU_MEMORY_OFFSET+0x0040884,0x00000400
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_41             IPU_MEMORY_OFFSET+0x0040884,0x00000200
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_40             IPU_MEMORY_OFFSET+0x0040884,0x00000100
#define LPM_MEM_IPU_INT_CTRL_6__IDMAC_NFB4EOF_EN_33             IPU_MEMORY_OFFSET+0x0040884,0x00000002

#define LPM_MEM_IPU_INT_CTRL_7__ADDR                            IPU_MEMORY_OFFSET+0x0040888
#define LPM_MEM_IPU_INT_CTRL_7__EMPTY                           IPU_MEMORY_OFFSET+0x0040888,0x00000000
#define LPM_MEM_IPU_INT_CTRL_7__FULL                            IPU_MEMORY_OFFSET+0x0040888,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_31                 IPU_MEMORY_OFFSET+0x0040888,0x80000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_29                 IPU_MEMORY_OFFSET+0x0040888,0x20000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_28                 IPU_MEMORY_OFFSET+0x0040888,0x10000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_27                 IPU_MEMORY_OFFSET+0x0040888,0x08000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_26                 IPU_MEMORY_OFFSET+0x0040888,0x04000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_25                 IPU_MEMORY_OFFSET+0x0040888,0x02000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_24                 IPU_MEMORY_OFFSET+0x0040888,0x01000000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_23                 IPU_MEMORY_OFFSET+0x0040888,0x00800000
#define LPM_MEM_IPU_INT_CTRL_7__IDMAC_EOS_EN_19                 IPU_MEMORY_OFFSET+0x0040888,0x00080000

#define LPM_MEM_IPU_INT_CTRL_8__ADDR                            IPU_MEMORY_OFFSET+0x004088C
#define LPM_MEM_IPU_INT_CTRL_8__EMPTY                           IPU_MEMORY_OFFSET+0x004088C,0x00000000
#define LPM_MEM_IPU_INT_CTRL_8__FULL                            IPU_MEMORY_OFFSET+0x004088C,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_52                 IPU_MEMORY_OFFSET+0x004088C,0x00100000
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_51                 IPU_MEMORY_OFFSET+0x004088C,0x00080000
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_44                 IPU_MEMORY_OFFSET+0x004088C,0x00001000
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_43                 IPU_MEMORY_OFFSET+0x004088C,0x00000800
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_42                 IPU_MEMORY_OFFSET+0x004088C,0x00000400
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_41                 IPU_MEMORY_OFFSET+0x004088C,0x00000200
#define LPM_MEM_IPU_INT_CTRL_8__IDMAC_EOS_EN_33                 IPU_MEMORY_OFFSET+0x004088C,0x00000002

#define LPM_MEM_IPU_INT_CTRL_9__ADDR                            IPU_MEMORY_OFFSET+0x0040890
#define LPM_MEM_IPU_INT_CTRL_9__EMPTY                           IPU_MEMORY_OFFSET+0x0040890,0x00000000
#define LPM_MEM_IPU_INT_CTRL_9__FULL                            IPU_MEMORY_OFFSET+0x0040890,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_9__CSI1_PUPE_EN                    IPU_MEMORY_OFFSET+0x0040890,0x80000000
#define LPM_MEM_IPU_INT_CTRL_9__CSI0_PUPE_EN                    IPU_MEMORY_OFFSET+0x0040890,0x40000000
#define LPM_MEM_IPU_INT_CTRL_9__IC_VF_BUF_OVF_EN                IPU_MEMORY_OFFSET+0x0040890,0x10000000
#define LPM_MEM_IPU_INT_CTRL_9__IC_ENC_BUF_OVF_EN               IPU_MEMORY_OFFSET+0x0040890,0x08000000
#define LPM_MEM_IPU_INT_CTRL_9__IC_BAYER_BUF_OVF_EN             IPU_MEMORY_OFFSET+0x0040890,0x04000000
#define LPM_MEM_IPU_INT_CTRL_9__VDI_FIFO1_OVF_EN                IPU_MEMORY_OFFSET+0x0040890,0x00000001

#define LPM_MEM_IPU_INT_CTRL_10__ADDR                           IPU_MEMORY_OFFSET+0x0040894
#define LPM_MEM_IPU_INT_CTRL_10__EMPTY                          IPU_MEMORY_OFFSET+0x0040894,0x00000000
#define LPM_MEM_IPU_INT_CTRL_10__FULL                           IPU_MEMORY_OFFSET+0x0040894,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_10__AXIR_ERR_EN                    IPU_MEMORY_OFFSET+0x0040894,0x40000000
#define LPM_MEM_IPU_INT_CTRL_10__AXIW_ERR_EN                    IPU_MEMORY_OFFSET+0x0040894,0x20000000
#define LPM_MEM_IPU_INT_CTRL_10__NON_PRIVILEGED_ACC_ERR_EN      IPU_MEMORY_OFFSET+0x0040894,0x10000000
#define LPM_MEM_IPU_INT_CTRL_10__IC_BAYER_FRM_LOST_ERR_EN       IPU_MEMORY_OFFSET+0x0040894,0x04000000
#define LPM_MEM_IPU_INT_CTRL_10__IC_ENC_FRM_LOST_ERR_EN         IPU_MEMORY_OFFSET+0x0040894,0x02000000
#define LPM_MEM_IPU_INT_CTRL_10__IC_VF_FRM_LOST_ERR_EN          IPU_MEMORY_OFFSET+0x0040894,0x01000000
#define LPM_MEM_IPU_INT_CTRL_10__DI1_TIME_OUT_ERR_EN            IPU_MEMORY_OFFSET+0x0040894,0x00400000
#define LPM_MEM_IPU_INT_CTRL_10__DI0_TIME_OUT_ERR_EN            IPU_MEMORY_OFFSET+0x0040894,0x00200000
#define LPM_MEM_IPU_INT_CTRL_10__DI1_SYNC_DISP_ERR_EN           IPU_MEMORY_OFFSET+0x0040894,0x00100000
#define LPM_MEM_IPU_INT_CTRL_10__DI0_SYNC_DISP_ERR_EN           IPU_MEMORY_OFFSET+0x0040894,0x00080000
#define LPM_MEM_IPU_INT_CTRL_10__DC_TEARING_ERR_6_EN            IPU_MEMORY_OFFSET+0x0040894,0x00040000
#define LPM_MEM_IPU_INT_CTRL_10__DC_TEARING_ERR_2_EN            IPU_MEMORY_OFFSET+0x0040894,0x00020000
#define LPM_MEM_IPU_INT_CTRL_10__DC_TEARING_ERR_1_EN            IPU_MEMORY_OFFSET+0x0040894,0x00010000
#define LPM_MEM_IPU_INT_CTRL_10__SMFC3_FRM_LOST_EN              IPU_MEMORY_OFFSET+0x0040894,0x00000008
#define LPM_MEM_IPU_INT_CTRL_10__SMFC2_FRM_LOST_EN              IPU_MEMORY_OFFSET+0x0040894,0x00000004
#define LPM_MEM_IPU_INT_CTRL_10__SMFC1_FRM_LOST_EN              IPU_MEMORY_OFFSET+0x0040894,0x00000002
#define LPM_MEM_IPU_INT_CTRL_10__SMFC0_FRM_LOST_EN              IPU_MEMORY_OFFSET+0x0040894,0x00000001

#define LPM_MEM_IPU_INT_CTRL_11__ADDR                           IPU_MEMORY_OFFSET+0x0040898
#define LPM_MEM_IPU_INT_CTRL_11__EMPTY                          IPU_MEMORY_OFFSET+0x0040898,0x00000000
#define LPM_MEM_IPU_INT_CTRL_11__FULL                           IPU_MEMORY_OFFSET+0x0040898,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_26              IPU_MEMORY_OFFSET+0x0040898,0x04000000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_25              IPU_MEMORY_OFFSET+0x0040898,0x02000000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_22              IPU_MEMORY_OFFSET+0x0040898,0x00400000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_21              IPU_MEMORY_OFFSET+0x0040898,0x00200000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_20              IPU_MEMORY_OFFSET+0x0040898,0x00100000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_12              IPU_MEMORY_OFFSET+0x0040898,0x00001000
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_11              IPU_MEMORY_OFFSET+0x0040898,0x00000800
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_10              IPU_MEMORY_OFFSET+0x0040898,0x00000400
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_9               IPU_MEMORY_OFFSET+0x0040898,0x00000200
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_8               IPU_MEMORY_OFFSET+0x0040898,0x00000100
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_5               IPU_MEMORY_OFFSET+0x0040898,0x00000020
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_3               IPU_MEMORY_OFFSET+0x0040898,0x00000008
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_2               IPU_MEMORY_OFFSET+0x0040898,0x00000004
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_1               IPU_MEMORY_OFFSET+0x0040898,0x00000002
#define LPM_MEM_IPU_INT_CTRL_11__IDMAC_EOBND_EN_0               IPU_MEMORY_OFFSET+0x0040898,0x00000001

#define LPM_MEM_IPU_INT_CTRL_12__ADDR                           IPU_MEMORY_OFFSET+0x004089C
#define LPM_MEM_IPU_INT_CTRL_12__EMPTY                          IPU_MEMORY_OFFSET+0x004089C,0x00000000
#define LPM_MEM_IPU_INT_CTRL_12__FULL                           IPU_MEMORY_OFFSET+0x004089C,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_50              IPU_MEMORY_OFFSET+0x004089C,0x00040000
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_49              IPU_MEMORY_OFFSET+0x004089C,0x00020000
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_48              IPU_MEMORY_OFFSET+0x004089C,0x00010000
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_47              IPU_MEMORY_OFFSET+0x004089C,0x00008000
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_46              IPU_MEMORY_OFFSET+0x004089C,0x00004000
#define LPM_MEM_IPU_INT_CTRL_12__IDMAC_EOBND_EN_45              IPU_MEMORY_OFFSET+0x004089C,0x00002000

#define LPM_MEM_IPU_INT_CTRL_13__ADDR                           IPU_MEMORY_OFFSET+0x00408A0
#define LPM_MEM_IPU_INT_CTRL_13__EMPTY                          IPU_MEMORY_OFFSET+0x00408A0,0x00000000
#define LPM_MEM_IPU_INT_CTRL_13__FULL                           IPU_MEMORY_OFFSET+0x00408A0,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_31                 IPU_MEMORY_OFFSET+0x00408A0,0x80000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_29                 IPU_MEMORY_OFFSET+0x00408A0,0x20000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_28                 IPU_MEMORY_OFFSET+0x00408A0,0x10000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_27                 IPU_MEMORY_OFFSET+0x00408A0,0x08000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_26                 IPU_MEMORY_OFFSET+0x00408A0,0x04000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_25                 IPU_MEMORY_OFFSET+0x00408A0,0x02000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_24                 IPU_MEMORY_OFFSET+0x00408A0,0x01000000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_23                 IPU_MEMORY_OFFSET+0x00408A0,0x00800000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_22                 IPU_MEMORY_OFFSET+0x00408A0,0x00400000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_21                 IPU_MEMORY_OFFSET+0x00408A0,0x00200000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_20                 IPU_MEMORY_OFFSET+0x00408A0,0x00100000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_19                 IPU_MEMORY_OFFSET+0x00408A0,0x00080000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_18                 IPU_MEMORY_OFFSET+0x00408A0,0x00040000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_17                 IPU_MEMORY_OFFSET+0x00408A0,0x00020000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_15                 IPU_MEMORY_OFFSET+0x00408A0,0x00008000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_14                 IPU_MEMORY_OFFSET+0x00408A0,0x00004000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_13                 IPU_MEMORY_OFFSET+0x00408A0,0x00002000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_12                 IPU_MEMORY_OFFSET+0x00408A0,0x00001000
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_11                 IPU_MEMORY_OFFSET+0x00408A0,0x00000800
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_10                 IPU_MEMORY_OFFSET+0x00408A0,0x00000400
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_9                  IPU_MEMORY_OFFSET+0x00408A0,0x00000200
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_8                  IPU_MEMORY_OFFSET+0x00408A0,0x00000100
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_5                  IPU_MEMORY_OFFSET+0x00408A0,0x00000020
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_3                  IPU_MEMORY_OFFSET+0x00408A0,0x00000008
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_2                  IPU_MEMORY_OFFSET+0x00408A0,0x00000004
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_1                  IPU_MEMORY_OFFSET+0x00408A0,0x00000002
#define LPM_MEM_IPU_INT_CTRL_13__IDMAC_TH_EN_0                  IPU_MEMORY_OFFSET+0x00408A0,0x00000001

#define LPM_MEM_IPU_INT_CTRL_14__ADDR                           IPU_MEMORY_OFFSET+0x00408A4
#define LPM_MEM_IPU_INT_CTRL_14__EMPTY                          IPU_MEMORY_OFFSET+0x00408A4,0x00000000
#define LPM_MEM_IPU_INT_CTRL_14__FULL                           IPU_MEMORY_OFFSET+0x00408A4,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_52                 IPU_MEMORY_OFFSET+0x00408A4,0x00100000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_51                 IPU_MEMORY_OFFSET+0x00408A4,0x00080000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_50                 IPU_MEMORY_OFFSET+0x00408A4,0x00040000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_49                 IPU_MEMORY_OFFSET+0x00408A4,0x00020000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_48                 IPU_MEMORY_OFFSET+0x00408A4,0x00010000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_47                 IPU_MEMORY_OFFSET+0x00408A4,0x00008000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_46                 IPU_MEMORY_OFFSET+0x00408A4,0x00004000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_45                 IPU_MEMORY_OFFSET+0x00408A4,0x00002000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_44                 IPU_MEMORY_OFFSET+0x00408A4,0x00001000
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_43                 IPU_MEMORY_OFFSET+0x00408A4,0x00000800
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_42                 IPU_MEMORY_OFFSET+0x00408A4,0x00000400
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_41                 IPU_MEMORY_OFFSET+0x00408A4,0x00000200
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_40                 IPU_MEMORY_OFFSET+0x00408A4,0x00000100
#define LPM_MEM_IPU_INT_CTRL_14__IDMAC_TH_EN_33                 IPU_MEMORY_OFFSET+0x00408A4,0x00000002

#define LPM_MEM_IPU_INT_CTRL_15__ADDR                           IPU_MEMORY_OFFSET+0x00408A8
#define LPM_MEM_IPU_INT_CTRL_15__EMPTY                          IPU_MEMORY_OFFSET+0x00408A8,0x00000000
#define LPM_MEM_IPU_INT_CTRL_15__FULL                           IPU_MEMORY_OFFSET+0x00408A8,0xffffffff
#define LPM_MEM_IPU_INT_CTRL_15__DI1_CNT_EN_PRE_8_EN            IPU_MEMORY_OFFSET+0x00408A8,0x80000000
#define LPM_MEM_IPU_INT_CTRL_15__DI1_CNT_EN_PRE_3_EN            IPU_MEMORY_OFFSET+0x00408A8,0x40000000
#define LPM_MEM_IPU_INT_CTRL_15__DI1_DISP_CLK_EN_PRE_EN         IPU_MEMORY_OFFSET+0x00408A8,0x20000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_10_EN           IPU_MEMORY_OFFSET+0x00408A8,0x10000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_9_EN            IPU_MEMORY_OFFSET+0x00408A8,0x08000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_8_EN            IPU_MEMORY_OFFSET+0x00408A8,0x04000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_7_EN            IPU_MEMORY_OFFSET+0x00408A8,0x02000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_6_EN            IPU_MEMORY_OFFSET+0x00408A8,0x01000000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_5_EN            IPU_MEMORY_OFFSET+0x00408A8,0x00800000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_4_EN            IPU_MEMORY_OFFSET+0x00408A8,0x00400000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_3_EN            IPU_MEMORY_OFFSET+0x00408A8,0x00200000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_2_EN            IPU_MEMORY_OFFSET+0x00408A8,0x00100000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_CNT_EN_PRE_1_EN            IPU_MEMORY_OFFSET+0x00408A8,0x00080000
#define LPM_MEM_IPU_INT_CTRL_15__DI0_DISP_CLK_EN_PRE_EN         IPU_MEMORY_OFFSET+0x00408A8,0x00040000
#define LPM_MEM_IPU_INT_CTRL_15__DC_ASYNC_STOP_EN               IPU_MEMORY_OFFSET+0x00408A8,0x00020000
#define LPM_MEM_IPU_INT_CTRL_15__DC_DP_START_EN                 IPU_MEMORY_OFFSET+0x00408A8,0x00010000
#define LPM_MEM_IPU_INT_CTRL_15__DI_VSYNC_PRE_1_EN              IPU_MEMORY_OFFSET+0x00408A8,0x00008000
#define LPM_MEM_IPU_INT_CTRL_15__DI_VSYNC_PRE_0_EN              IPU_MEMORY_OFFSET+0x00408A8,0x00004000
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_6_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00002000
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_4_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00001000
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_3_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00000800
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_2_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00000400
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_1_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00000200
#define LPM_MEM_IPU_INT_CTRL_15__DC_FC_0_EN                     IPU_MEMORY_OFFSET+0x00408A8,0x00000100
#define LPM_MEM_IPU_INT_CTRL_15__DP_ASF_BRAKE_EN                IPU_MEMORY_OFFSET+0x00408A8,0x00000080
#define LPM_MEM_IPU_INT_CTRL_15__DP_SF_BRAKE_EN                 IPU_MEMORY_OFFSET+0x00408A8,0x00000040
#define LPM_MEM_IPU_INT_CTRL_15__DP_ASF_END_EN                  IPU_MEMORY_OFFSET+0x00408A8,0x00000020
#define LPM_MEM_IPU_INT_CTRL_15__DP_ASF_START_EN                IPU_MEMORY_OFFSET+0x00408A8,0x00000010
#define LPM_MEM_IPU_INT_CTRL_15__DP_SF_END_EN                   IPU_MEMORY_OFFSET+0x00408A8,0x00000008
#define LPM_MEM_IPU_INT_CTRL_15__DP_SF_START_EN                 IPU_MEMORY_OFFSET+0x00408A8,0x00000004
#define LPM_MEM_IPU_INT_CTRL_15__IPU_SNOOPING2_INT_EN           IPU_MEMORY_OFFSET+0x00408A8,0x00000002
#define LPM_MEM_IPU_INT_CTRL_15__IPU_SNOOPING1_INT_EN           IPU_MEMORY_OFFSET+0x00408A8,0x00000001

#define LPM_MEM_IPU_SDMA_EVENT_1__ADDR                          IPU_MEMORY_OFFSET+0x00408AC
#define LPM_MEM_IPU_SDMA_EVENT_1__EMPTY                         IPU_MEMORY_OFFSET+0x00408AC,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_1__FULL                          IPU_MEMORY_OFFSET+0x00408AC,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_31          IPU_MEMORY_OFFSET+0x00408AC,0x80000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_29          IPU_MEMORY_OFFSET+0x00408AC,0x20000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_28          IPU_MEMORY_OFFSET+0x00408AC,0x10000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_27          IPU_MEMORY_OFFSET+0x00408AC,0x08000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_26          IPU_MEMORY_OFFSET+0x00408AC,0x04000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_25          IPU_MEMORY_OFFSET+0x00408AC,0x02000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_24          IPU_MEMORY_OFFSET+0x00408AC,0x01000000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_23          IPU_MEMORY_OFFSET+0x00408AC,0x00800000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_22          IPU_MEMORY_OFFSET+0x00408AC,0x00400000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_21          IPU_MEMORY_OFFSET+0x00408AC,0x00200000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_20          IPU_MEMORY_OFFSET+0x00408AC,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_19          IPU_MEMORY_OFFSET+0x00408AC,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_18          IPU_MEMORY_OFFSET+0x00408AC,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_17          IPU_MEMORY_OFFSET+0x00408AC,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_15          IPU_MEMORY_OFFSET+0x00408AC,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_14          IPU_MEMORY_OFFSET+0x00408AC,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_13          IPU_MEMORY_OFFSET+0x00408AC,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_12          IPU_MEMORY_OFFSET+0x00408AC,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_11          IPU_MEMORY_OFFSET+0x00408AC,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_10          IPU_MEMORY_OFFSET+0x00408AC,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_9           IPU_MEMORY_OFFSET+0x00408AC,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_8           IPU_MEMORY_OFFSET+0x00408AC,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_5           IPU_MEMORY_OFFSET+0x00408AC,0x00000020
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_3           IPU_MEMORY_OFFSET+0x00408AC,0x00000008
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_2           IPU_MEMORY_OFFSET+0x00408AC,0x00000004
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_1           IPU_MEMORY_OFFSET+0x00408AC,0x00000002
#define LPM_MEM_IPU_SDMA_EVENT_1__IDMAC_EOF_SDMA_EN_0           IPU_MEMORY_OFFSET+0x00408AC,0x00000001

#define LPM_MEM_IPU_SDMA_EVENT_2__ADDR                          IPU_MEMORY_OFFSET+0x00408B0
#define LPM_MEM_IPU_SDMA_EVENT_2__EMPTY                         IPU_MEMORY_OFFSET+0x00408B0,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_2__FULL                          IPU_MEMORY_OFFSET+0x00408B0,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_52          IPU_MEMORY_OFFSET+0x00408B0,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_51          IPU_MEMORY_OFFSET+0x00408B0,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_50          IPU_MEMORY_OFFSET+0x00408B0,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_49          IPU_MEMORY_OFFSET+0x00408B0,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_48          IPU_MEMORY_OFFSET+0x00408B0,0x00010000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_47          IPU_MEMORY_OFFSET+0x00408B0,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_46          IPU_MEMORY_OFFSET+0x00408B0,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_45          IPU_MEMORY_OFFSET+0x00408B0,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_44          IPU_MEMORY_OFFSET+0x00408B0,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_43          IPU_MEMORY_OFFSET+0x00408B0,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_42          IPU_MEMORY_OFFSET+0x00408B0,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_41          IPU_MEMORY_OFFSET+0x00408B0,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_40          IPU_MEMORY_OFFSET+0x00408B0,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_2__IDMAC_EOF_SDMA_EN_33          IPU_MEMORY_OFFSET+0x00408B0,0x00000002

#define LPM_MEM_IPU_SDMA_EVENT_3__ADDR                          IPU_MEMORY_OFFSET+0x00408B4
#define LPM_MEM_IPU_SDMA_EVENT_3__EMPTY                         IPU_MEMORY_OFFSET+0x00408B4,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_3__FULL                          IPU_MEMORY_OFFSET+0x00408B4,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_31        IPU_MEMORY_OFFSET+0x00408B4,0x80000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_29        IPU_MEMORY_OFFSET+0x00408B4,0x20000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_28        IPU_MEMORY_OFFSET+0x00408B4,0x10000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_27        IPU_MEMORY_OFFSET+0x00408B4,0x08000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_26        IPU_MEMORY_OFFSET+0x00408B4,0x04000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_25        IPU_MEMORY_OFFSET+0x00408B4,0x02000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_24        IPU_MEMORY_OFFSET+0x00408B4,0x01000000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_23        IPU_MEMORY_OFFSET+0x00408B4,0x00800000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_22        IPU_MEMORY_OFFSET+0x00408B4,0x00400000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_21        IPU_MEMORY_OFFSET+0x00408B4,0x00200000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_20        IPU_MEMORY_OFFSET+0x00408B4,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_19        IPU_MEMORY_OFFSET+0x00408B4,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_18        IPU_MEMORY_OFFSET+0x00408B4,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_17        IPU_MEMORY_OFFSET+0x00408B4,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_15        IPU_MEMORY_OFFSET+0x00408B4,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_14        IPU_MEMORY_OFFSET+0x00408B4,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_13        IPU_MEMORY_OFFSET+0x00408B4,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_12        IPU_MEMORY_OFFSET+0x00408B4,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_11        IPU_MEMORY_OFFSET+0x00408B4,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_10        IPU_MEMORY_OFFSET+0x00408B4,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_9         IPU_MEMORY_OFFSET+0x00408B4,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_8         IPU_MEMORY_OFFSET+0x00408B4,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_5         IPU_MEMORY_OFFSET+0x00408B4,0x00000020
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_3         IPU_MEMORY_OFFSET+0x00408B4,0x00000008
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_2         IPU_MEMORY_OFFSET+0x00408B4,0x00000004
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_1         IPU_MEMORY_OFFSET+0x00408B4,0x00000002
#define LPM_MEM_IPU_SDMA_EVENT_3__IDMAC_NFACK_SDMA_EN_0         IPU_MEMORY_OFFSET+0x00408B4,0x00000001

#define LPM_MEM_IPU_SDMA_EVENT_4__ADDR                          IPU_MEMORY_OFFSET+0x00408B8
#define LPM_MEM_IPU_SDMA_EVENT_4__EMPTY                         IPU_MEMORY_OFFSET+0x00408B8,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_4__FULL                          IPU_MEMORY_OFFSET+0x00408B8,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_52        IPU_MEMORY_OFFSET+0x00408B8,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_51        IPU_MEMORY_OFFSET+0x00408B8,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_50        IPU_MEMORY_OFFSET+0x00408B8,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_49        IPU_MEMORY_OFFSET+0x00408B8,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_48        IPU_MEMORY_OFFSET+0x00408B8,0x00010000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_47        IPU_MEMORY_OFFSET+0x00408B8,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_46        IPU_MEMORY_OFFSET+0x00408B8,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_45        IPU_MEMORY_OFFSET+0x00408B8,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_44        IPU_MEMORY_OFFSET+0x00408B8,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_43        IPU_MEMORY_OFFSET+0x00408B8,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_42        IPU_MEMORY_OFFSET+0x00408B8,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_41        IPU_MEMORY_OFFSET+0x00408B8,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_40        IPU_MEMORY_OFFSET+0x00408B8,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_4__IDMAC_NFACK_SDMA_EN_33        IPU_MEMORY_OFFSET+0x00408B8,0x00000002

#define LPM_MEM_IPU_SDMA_EVENT_7__ADDR                          IPU_MEMORY_OFFSET+0x00408BC
#define LPM_MEM_IPU_SDMA_EVENT_7__EMPTY                         IPU_MEMORY_OFFSET+0x00408BC,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_7__FULL                          IPU_MEMORY_OFFSET+0x00408BC,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_31          IPU_MEMORY_OFFSET+0x00408BC,0x80000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_29          IPU_MEMORY_OFFSET+0x00408BC,0x20000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_28          IPU_MEMORY_OFFSET+0x00408BC,0x10000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_27          IPU_MEMORY_OFFSET+0x00408BC,0x08000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_26          IPU_MEMORY_OFFSET+0x00408BC,0x04000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_25          IPU_MEMORY_OFFSET+0x00408BC,0x02000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_24          IPU_MEMORY_OFFSET+0x00408BC,0x01000000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_23          IPU_MEMORY_OFFSET+0x00408BC,0x00800000
#define LPM_MEM_IPU_SDMA_EVENT_7__IDMAC_EOS_SDMA_EN_19          IPU_MEMORY_OFFSET+0x00408BC,0x00080000

#define LPM_MEM_IPU_SDMA_EVENT_8__ADDR                          IPU_MEMORY_OFFSET+0x00408C0
#define LPM_MEM_IPU_SDMA_EVENT_8__EMPTY                         IPU_MEMORY_OFFSET+0x00408C0,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_8__FULL                          IPU_MEMORY_OFFSET+0x00408C0,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_52          IPU_MEMORY_OFFSET+0x00408C0,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_51          IPU_MEMORY_OFFSET+0x00408C0,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_44          IPU_MEMORY_OFFSET+0x00408C0,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_43          IPU_MEMORY_OFFSET+0x00408C0,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_42          IPU_MEMORY_OFFSET+0x00408C0,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_41          IPU_MEMORY_OFFSET+0x00408C0,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_8__IDMAC_EOS_SDMA_EN_32          IPU_MEMORY_OFFSET+0x00408C0,0x00000002

#define LPM_MEM_IPU_SDMA_EVENT_11__ADDR                         IPU_MEMORY_OFFSET+0x00408C4
#define LPM_MEM_IPU_SDMA_EVENT_11__EMPTY                        IPU_MEMORY_OFFSET+0x00408C4,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_11__FULL                         IPU_MEMORY_OFFSET+0x00408C4,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_26       IPU_MEMORY_OFFSET+0x00408C4,0x04000000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_25       IPU_MEMORY_OFFSET+0x00408C4,0x02000000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_22       IPU_MEMORY_OFFSET+0x00408C4,0x00400000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_21       IPU_MEMORY_OFFSET+0x00408C4,0x00200000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_20       IPU_MEMORY_OFFSET+0x00408C4,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_12       IPU_MEMORY_OFFSET+0x00408C4,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_11       IPU_MEMORY_OFFSET+0x00408C4,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_10       IPU_MEMORY_OFFSET+0x00408C4,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_9        IPU_MEMORY_OFFSET+0x00408C4,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_8        IPU_MEMORY_OFFSET+0x00408C4,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_5        IPU_MEMORY_OFFSET+0x00408C4,0x00000020
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_3        IPU_MEMORY_OFFSET+0x00408C4,0x00000008
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_2        IPU_MEMORY_OFFSET+0x00408C4,0x00000004
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_1        IPU_MEMORY_OFFSET+0x00408C4,0x00000002
#define LPM_MEM_IPU_SDMA_EVENT_11__IDMAC_EOBND_SDMA_EN_0        IPU_MEMORY_OFFSET+0x00408C4,0x00000001

#define LPM_MEM_IPU_SDMA_EVENT_12__ADDR                         IPU_MEMORY_OFFSET+0x00408C8
#define LPM_MEM_IPU_SDMA_EVENT_12__EMPTY                        IPU_MEMORY_OFFSET+0x00408C8,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_12__FULL                         IPU_MEMORY_OFFSET+0x00408C8,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_50       IPU_MEMORY_OFFSET+0x00408C8,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_49       IPU_MEMORY_OFFSET+0x00408C8,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_48       IPU_MEMORY_OFFSET+0x00408C8,0x00010000
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_47       IPU_MEMORY_OFFSET+0x00408C8,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_46       IPU_MEMORY_OFFSET+0x00408C8,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_12__IDMAC_EOBND_SDMA_EN_45       IPU_MEMORY_OFFSET+0x00408C8,0x00002000

#define LPM_MEM_IPU_SDMA_EVENT_13__ADDR                         IPU_MEMORY_OFFSET+0x00408CC
#define LPM_MEM_IPU_SDMA_EVENT_13__EMPTY                        IPU_MEMORY_OFFSET+0x00408CC,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_13__FULL                         IPU_MEMORY_OFFSET+0x00408CC,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_31          IPU_MEMORY_OFFSET+0x00408CC,0x80000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_29          IPU_MEMORY_OFFSET+0x00408CC,0x20000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_28          IPU_MEMORY_OFFSET+0x00408CC,0x10000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_27          IPU_MEMORY_OFFSET+0x00408CC,0x08000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_26          IPU_MEMORY_OFFSET+0x00408CC,0x04000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_25          IPU_MEMORY_OFFSET+0x00408CC,0x02000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_24          IPU_MEMORY_OFFSET+0x00408CC,0x01000000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_23          IPU_MEMORY_OFFSET+0x00408CC,0x00800000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_22          IPU_MEMORY_OFFSET+0x00408CC,0x00400000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_21          IPU_MEMORY_OFFSET+0x00408CC,0x00200000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_20          IPU_MEMORY_OFFSET+0x00408CC,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_19          IPU_MEMORY_OFFSET+0x00408CC,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_18          IPU_MEMORY_OFFSET+0x00408CC,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_17          IPU_MEMORY_OFFSET+0x00408CC,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_15          IPU_MEMORY_OFFSET+0x00408CC,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_14          IPU_MEMORY_OFFSET+0x00408CC,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_13          IPU_MEMORY_OFFSET+0x00408CC,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_12          IPU_MEMORY_OFFSET+0x00408CC,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_11          IPU_MEMORY_OFFSET+0x00408CC,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_10          IPU_MEMORY_OFFSET+0x00408CC,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_9           IPU_MEMORY_OFFSET+0x00408CC,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_8           IPU_MEMORY_OFFSET+0x00408CC,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_5           IPU_MEMORY_OFFSET+0x00408CC,0x00000020
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_3           IPU_MEMORY_OFFSET+0x00408CC,0x00000008
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_2           IPU_MEMORY_OFFSET+0x00408CC,0x00000004
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_1           IPU_MEMORY_OFFSET+0x00408CC,0x00000002
#define LPM_MEM_IPU_SDMA_EVENT_13__IDMAC_TH_SDMA_EN_0           IPU_MEMORY_OFFSET+0x00408CC,0x00000001

#define LPM_MEM_IPU_SDMA_EVENT_14__ADDR                         IPU_MEMORY_OFFSET+0x00408D0
#define LPM_MEM_IPU_SDMA_EVENT_14__EMPTY                        IPU_MEMORY_OFFSET+0x00408D0,0x00000000
#define LPM_MEM_IPU_SDMA_EVENT_14__FULL                         IPU_MEMORY_OFFSET+0x00408D0,0xffffffff
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_52          IPU_MEMORY_OFFSET+0x00408D0,0x00100000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_51          IPU_MEMORY_OFFSET+0x00408D0,0x00080000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_50          IPU_MEMORY_OFFSET+0x00408D0,0x00040000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_49          IPU_MEMORY_OFFSET+0x00408D0,0x00020000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_48          IPU_MEMORY_OFFSET+0x00408D0,0x00010000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_47          IPU_MEMORY_OFFSET+0x00408D0,0x00008000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_46          IPU_MEMORY_OFFSET+0x00408D0,0x00004000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_45          IPU_MEMORY_OFFSET+0x00408D0,0x00002000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_44          IPU_MEMORY_OFFSET+0x00408D0,0x00001000
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_43          IPU_MEMORY_OFFSET+0x00408D0,0x00000800
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_42          IPU_MEMORY_OFFSET+0x00408D0,0x00000400
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_41          IPU_MEMORY_OFFSET+0x00408D0,0x00000200
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_40          IPU_MEMORY_OFFSET+0x00408D0,0x00000100
#define LPM_MEM_IPU_SDMA_EVENT_14__IDMAC_TH_SDMA_EN_33          IPU_MEMORY_OFFSET+0x00408D0,0x00000002

#define LPM_MEM_IPU_SRM_PRI1__ADDR                              IPU_MEMORY_OFFSET+0x00408D4
#define LPM_MEM_IPU_SRM_PRI1__EMPTY                             IPU_MEMORY_OFFSET+0x00408D4,0x00000000
#define LPM_MEM_IPU_SRM_PRI1__FULL                              IPU_MEMORY_OFFSET+0x00408D4,0xffffffff
#define LPM_MEM_IPU_SRM_PRI1__CSI0_SRM_MODE                     IPU_MEMORY_OFFSET+0x00408D4,0x00001800
#define LPM_MEM_IPU_SRM_PRI1__CSI0_SRM_PRI                      IPU_MEMORY_OFFSET+0x00408D4,0x00000700
#define LPM_MEM_IPU_SRM_PRI1__CSI1_SRM_MODE                     IPU_MEMORY_OFFSET+0x00408D4,0x00000018
#define LPM_MEM_IPU_SRM_PRI1__CSI1_SRM_PRI                      IPU_MEMORY_OFFSET+0x00408D4,0x00000007

#define LPM_MEM_IPU_SRM_PRI2__ADDR                              IPU_MEMORY_OFFSET+0x00408D8
#define LPM_MEM_IPU_SRM_PRI2__EMPTY                             IPU_MEMORY_OFFSET+0x00408D8,0x00000000
#define LPM_MEM_IPU_SRM_PRI2__FULL                              IPU_MEMORY_OFFSET+0x00408D8,0xffffffff
#define LPM_MEM_IPU_SRM_PRI2__DI1_SRM_MODE                      IPU_MEMORY_OFFSET+0x00408D8,0x18000000
#define LPM_MEM_IPU_SRM_PRI2__DI1_SRM_PRI                       IPU_MEMORY_OFFSET+0x00408D8,0x07000000
#define LPM_MEM_IPU_SRM_PRI2__DI0_SRM_MODE                      IPU_MEMORY_OFFSET+0x00408D8,0x00180000
#define LPM_MEM_IPU_SRM_PRI2__DI0_SRM_PRI                       IPU_MEMORY_OFFSET+0x00408D8,0x00070000
#define LPM_MEM_IPU_SRM_PRI2__DC_6_SRM_MODE                     IPU_MEMORY_OFFSET+0x00408D8,0x0000C000
#define LPM_MEM_IPU_SRM_PRI2__DC_2_SRM_MODE                     IPU_MEMORY_OFFSET+0x00408D8,0x00003000
#define LPM_MEM_IPU_SRM_PRI2__DC_SRM_PRI                        IPU_MEMORY_OFFSET+0x00408D8,0x00000E00
#define LPM_MEM_IPU_SRM_PRI2__DP_A1_SRM_MODE                    IPU_MEMORY_OFFSET+0x00408D8,0x00000180
#define LPM_MEM_IPU_SRM_PRI2__DP_A0_SRM_MODE                    IPU_MEMORY_OFFSET+0x00408D8,0x00000060
#define LPM_MEM_IPU_SRM_PRI2__DP_S_SRM_MODE                     IPU_MEMORY_OFFSET+0x00408D8,0x00000018
#define LPM_MEM_IPU_SRM_PRI2__DP_SRM_PRI                        IPU_MEMORY_OFFSET+0x00408D8,0x00000007

#define LPM_MEM_IPU_FS_PROC_FLOW1__ADDR                         IPU_MEMORY_OFFSET+0x00408DC
#define LPM_MEM_IPU_FS_PROC_FLOW1__EMPTY                        IPU_MEMORY_OFFSET+0x00408DC,0x00000000
#define LPM_MEM_IPU_FS_PROC_FLOW1__FULL                         IPU_MEMORY_OFFSET+0x00408DC,0xffffffff
#define LPM_MEM_IPU_FS_PROC_FLOW1__VF_IN_VALID                  IPU_MEMORY_OFFSET+0x00408DC,0x80000000
#define LPM_MEM_IPU_FS_PROC_FLOW1__ENC_IN_VALID                 IPU_MEMORY_OFFSET+0x00408DC,0x40000000
#define LPM_MEM_IPU_FS_PROC_FLOW1__VDI_SRC_SEL                  IPU_MEMORY_OFFSET+0x00408DC,0x30000000
#define LPM_MEM_IPU_FS_PROC_FLOW1__PRP_SRC_SEL                  IPU_MEMORY_OFFSET+0x00408DC,0x0F000000
#define LPM_MEM_IPU_FS_PROC_FLOW1__VDI3_SRC_SEL                 IPU_MEMORY_OFFSET+0x00408DC,0x00C00000
#define LPM_MEM_IPU_FS_PROC_FLOW1__VDI1_SRC_SEL                 IPU_MEMORY_OFFSET+0x00408DC,0x00300000
#define LPM_MEM_IPU_FS_PROC_FLOW1__PP_ROT_SRC_SEL               IPU_MEMORY_OFFSET+0x00408DC,0x000F0000
#define LPM_MEM_IPU_FS_PROC_FLOW1__PP_SRC_SEL                   IPU_MEMORY_OFFSET+0x00408DC,0x0000F000
#define LPM_MEM_IPU_FS_PROC_FLOW1__PRPVF_ROT_SRC_SEL            IPU_MEMORY_OFFSET+0x00408DC,0x00000F00
#define LPM_MEM_IPU_FS_PROC_FLOW1__PRPENC_ROT_SRC_SEL           IPU_MEMORY_OFFSET+0x00408DC,0x0000000F

#define LPM_MEM_IPU_FS_PROC_FLOW2__ADDR                         IPU_MEMORY_OFFSET+0x00408E0
#define LPM_MEM_IPU_FS_PROC_FLOW2__EMPTY                        IPU_MEMORY_OFFSET+0x00408E0,0x00000000
#define LPM_MEM_IPU_FS_PROC_FLOW2__FULL                         IPU_MEMORY_OFFSET+0x00408E0,0xffffffff
#define LPM_MEM_IPU_FS_PROC_FLOW2__PRP_DEST_SEL                 IPU_MEMORY_OFFSET+0x00408E0,0x0F000000
#define LPM_MEM_IPU_FS_PROC_FLOW2__PRPENC_ROT_DEST_SEL          IPU_MEMORY_OFFSET+0x00408E0,0x00F00000
#define LPM_MEM_IPU_FS_PROC_FLOW2__PP_ROT_DEST_SEL              IPU_MEMORY_OFFSET+0x00408E0,0x000F0000
#define LPM_MEM_IPU_FS_PROC_FLOW2__PP_DEST_SEL                  IPU_MEMORY_OFFSET+0x00408E0,0x0000F000
#define LPM_MEM_IPU_FS_PROC_FLOW2__PRPVF_ROT_DEST_SEL           IPU_MEMORY_OFFSET+0x00408E0,0x00000F00
#define LPM_MEM_IPU_FS_PROC_FLOW2__PRPVF_DEST_SEL               IPU_MEMORY_OFFSET+0x00408E0,0x000000F0
#define LPM_MEM_IPU_FS_PROC_FLOW2__PRP_ENC_DEST_SEL             IPU_MEMORY_OFFSET+0x00408E0,0x0000000F

#define LPM_MEM_IPU_FS_PROC_FLOW3__ADDR                         IPU_MEMORY_OFFSET+0x00408E4
#define LPM_MEM_IPU_FS_PROC_FLOW3__EMPTY                        IPU_MEMORY_OFFSET+0x00408E4,0x00000000
#define LPM_MEM_IPU_FS_PROC_FLOW3__FULL                         IPU_MEMORY_OFFSET+0x00408E4,0xffffffff
#define LPM_MEM_IPU_FS_PROC_FLOW3__IPU_VPU_DEST_SEL             IPU_MEMORY_OFFSET+0x00408E4,0x03000000
#define LPM_MEM_IPU_FS_PROC_FLOW3__EXT_SRC2_DEST_SEL            IPU_MEMORY_OFFSET+0x00408E4,0x00C00000
#define LPM_MEM_IPU_FS_PROC_FLOW3__EXT_SRC1_DEST_SEL            IPU_MEMORY_OFFSET+0x00408E4,0x00300000
#define LPM_MEM_IPU_FS_PROC_FLOW3__VDOA_DEST_SEL                IPU_MEMORY_OFFSET+0x00408E4,0x00030000
#define LPM_MEM_IPU_FS_PROC_FLOW3__SMFC3_DEST_SEL               IPU_MEMORY_OFFSET+0x00408E4,0x00003800
#define LPM_MEM_IPU_FS_PROC_FLOW3__SMFC2_DEST_SEL               IPU_MEMORY_OFFSET+0x00408E4,0x00000780
#define LPM_MEM_IPU_FS_PROC_FLOW3__SMFC1_DEST_SEL               IPU_MEMORY_OFFSET+0x00408E4,0x00000070
#define LPM_MEM_IPU_FS_PROC_FLOW3__SMFC0_DEST_SEL               IPU_MEMORY_OFFSET+0x00408E4,0x0000000F

#define LPM_MEM_IPU_FS_DISP_FLOW1__ADDR                         IPU_MEMORY_OFFSET+0x00408E8
#define LPM_MEM_IPU_FS_DISP_FLOW1__EMPTY                        IPU_MEMORY_OFFSET+0x00408E8,0x00000000
#define LPM_MEM_IPU_FS_DISP_FLOW1__FULL                         IPU_MEMORY_OFFSET+0x00408E8,0xffffffff
#define LPM_MEM_IPU_FS_DISP_FLOW1__DC1_SRC_SEL                  IPU_MEMORY_OFFSET+0x00408E8,0x00F00000
#define LPM_MEM_IPU_FS_DISP_FLOW1__DC2_SRC_SEL                  IPU_MEMORY_OFFSET+0x00408E8,0x000F0000
#define LPM_MEM_IPU_FS_DISP_FLOW1__DP_ASYNC1_SRC_SEL            IPU_MEMORY_OFFSET+0x00408E8,0x0000F000
#define LPM_MEM_IPU_FS_DISP_FLOW1__DP_ASYNC0_SRC_SEL            IPU_MEMORY_OFFSET+0x00408E8,0x00000F00
#define LPM_MEM_IPU_FS_DISP_FLOW1__DP_SYNC1_SRC_SEL             IPU_MEMORY_OFFSET+0x00408E8,0x000000F0
#define LPM_MEM_IPU_FS_DISP_FLOW1__DP_SYNC0_SRC_SEL             IPU_MEMORY_OFFSET+0x00408E8,0x0000000F

#define LPM_MEM_IPU_FS_DISP_FLOW2__ADDR                         IPU_MEMORY_OFFSET+0x00408EC
#define LPM_MEM_IPU_FS_DISP_FLOW2__EMPTY                        IPU_MEMORY_OFFSET+0x00408EC,0x00000000
#define LPM_MEM_IPU_FS_DISP_FLOW2__FULL                         IPU_MEMORY_OFFSET+0x00408EC,0xffffffff
#define LPM_MEM_IPU_FS_DISP_FLOW2__DC2_ALT_SRC_SEL              IPU_MEMORY_OFFSET+0x00408EC,0x000F0000
#define LPM_MEM_IPU_FS_DISP_FLOW2__DP_ASYNC1_ALT_SRC_SEL        IPU_MEMORY_OFFSET+0x00408EC,0x000000F0
#define LPM_MEM_IPU_FS_DISP_FLOW2__DP_ASYNC0_ALT_SRC_SEL        IPU_MEMORY_OFFSET+0x00408EC,0x0000000F

#define LPM_MEM_IPU_SKIP__ADDR                                  IPU_MEMORY_OFFSET+0x00408F0
#define LPM_MEM_IPU_SKIP__EMPTY                                 IPU_MEMORY_OFFSET+0x00408F0,0x00000000
#define LPM_MEM_IPU_SKIP__FULL                                  IPU_MEMORY_OFFSET+0x00408F0,0xffffffff
#define LPM_MEM_IPU_SKIP__VDI_SKIP                              IPU_MEMORY_OFFSET+0x00408F0,0xFFF00000
#define LPM_MEM_IPU_SKIP__VDI_MAX_RATIO_SKIP                    IPU_MEMORY_OFFSET+0x00408F0,0x000F0000
#define LPM_MEM_IPU_SKIP__CSI_SKIP_IC_VF                        IPU_MEMORY_OFFSET+0x00408F0,0x0000F800
#define LPM_MEM_IPU_SKIP__CSI_MAX_RATIO_SKIP_IC_VF              IPU_MEMORY_OFFSET+0x00408F0,0x00000700
#define LPM_MEM_IPU_SKIP__CSI_SKIP_IC_ENC                       IPU_MEMORY_OFFSET+0x00408F0,0x000000F8
#define LPM_MEM_IPU_SKIP__CSI_MAX_RATIO_SKIP_IC_ENC             IPU_MEMORY_OFFSET+0x00408F0,0x00000007

#define LPM_MEM_IPU_DISP_ALT_CONF__ADDR                         IPU_MEMORY_OFFSET+0x00408F4
#define LPM_MEM_IPU_DISP_ALT_CONF__EMPTY                        IPU_MEMORY_OFFSET+0x00408F4,0x00000000
#define LPM_MEM_IPU_DISP_ALT_CONF__FULL                         IPU_MEMORY_OFFSET+0x00408F4,0xffffffff

#define LPM_MEM_IPU_DISP_GEN__ADDR                              IPU_MEMORY_OFFSET+0x00408F8
#define LPM_MEM_IPU_DISP_GEN__EMPTY                             IPU_MEMORY_OFFSET+0x00408F8,0x00000000
#define LPM_MEM_IPU_DISP_GEN__FULL                              IPU_MEMORY_OFFSET+0x00408F8,0xffffffff
#define LPM_MEM_IPU_DISP_GEN__DI1_COUNTER_RELEASE               IPU_MEMORY_OFFSET+0x00408F8,0x02000000
#define LPM_MEM_IPU_DISP_GEN__DI0_COUNTER_RELEASE               IPU_MEMORY_OFFSET+0x00408F8,0x01000000
#define LPM_MEM_IPU_DISP_GEN__CSI_VSYNC_DEST                    IPU_MEMORY_OFFSET+0x00408F8,0x00800000
#define LPM_MEM_IPU_DISP_GEN__MCU_MAX_BURST_STOP                IPU_MEMORY_OFFSET+0x00408F8,0x00400000
#define LPM_MEM_IPU_DISP_GEN__MCU_T                             IPU_MEMORY_OFFSET+0x00408F8,0x003C0000
#define LPM_MEM_IPU_DISP_GEN__MCU_DI_ID_9                       IPU_MEMORY_OFFSET+0x00408F8,0x00020000
#define LPM_MEM_IPU_DISP_GEN__MCU_DI_ID_8                       IPU_MEMORY_OFFSET+0x00408F8,0x00010000
#define LPM_MEM_IPU_DISP_GEN__DP_PIPE_CLR                       IPU_MEMORY_OFFSET+0x00408F8,0x00000040
#define LPM_MEM_IPU_DISP_GEN__DP_FG_EN_ASYNC1                   IPU_MEMORY_OFFSET+0x00408F8,0x00000020
#define LPM_MEM_IPU_DISP_GEN__DP_FG_EN_ASYNC0                   IPU_MEMORY_OFFSET+0x00408F8,0x00000010
#define LPM_MEM_IPU_DISP_GEN__DP_ASYNC_DOUBLE_FLOW              IPU_MEMORY_OFFSET+0x00408F8,0x00000008
#define LPM_MEM_IPU_DISP_GEN__DC2_DOUBLE_FLOW                   IPU_MEMORY_OFFSET+0x00408F8,0x00000004
#define LPM_MEM_IPU_DISP_GEN__DI1_DUAL_MODE                     IPU_MEMORY_OFFSET+0x00408F8,0x00000002
#define LPM_MEM_IPU_DISP_GEN__DI0_DUAL_MODE                     IPU_MEMORY_OFFSET+0x00408F8,0x00000001

#define LPM_MEM_IPU_DISP_ALT1__ADDR                             IPU_MEMORY_OFFSET+0x00408FC
#define LPM_MEM_IPU_DISP_ALT1__EMPTY                            IPU_MEMORY_OFFSET+0x00408FC,0x00000000
#define LPM_MEM_IPU_DISP_ALT1__FULL                             IPU_MEMORY_OFFSET+0x00408FC,0xffffffff
#define LPM_MEM_IPU_DISP_ALT1__SEL_ALT_0                        IPU_MEMORY_OFFSET+0x00408FC,0xF0000000
#define LPM_MEM_IPU_DISP_ALT1__STEP_REPEAT_ALT_0                IPU_MEMORY_OFFSET+0x00408FC,0x0FFF0000
#define LPM_MEM_IPU_DISP_ALT1__CNT_AUTO_RELOAD_ALT_0            IPU_MEMORY_OFFSET+0x00408FC,0x00008000
#define LPM_MEM_IPU_DISP_ALT1__CNT_CLR_SEL_ALT_0                IPU_MEMORY_OFFSET+0x00408FC,0x00007000
#define LPM_MEM_IPU_DISP_ALT1__RUN_VALUE_M1_ALT_0               IPU_MEMORY_OFFSET+0x00408FC,0x00000FFF

#define LPM_MEM_IPU_DISP_ALT2__ADDR                             IPU_MEMORY_OFFSET+0x0040900
#define LPM_MEM_IPU_DISP_ALT2__EMPTY                            IPU_MEMORY_OFFSET+0x0040900,0x00000000
#define LPM_MEM_IPU_DISP_ALT2__FULL                             IPU_MEMORY_OFFSET+0x0040900,0xffffffff
#define LPM_MEM_IPU_DISP_ALT2__RUN_RESOLUTION_ALT_0             IPU_MEMORY_OFFSET+0x0040900,0x00070000
#define LPM_MEM_IPU_DISP_ALT2__OFFSET_RESOLUTION_ALT_0          IPU_MEMORY_OFFSET+0x0040900,0x00007000
#define LPM_MEM_IPU_DISP_ALT2__OFFSET_VALUE_ALT_0               IPU_MEMORY_OFFSET+0x0040900,0x00000FFF

#define LPM_MEM_IPU_DISP_ALT3__ADDR                             IPU_MEMORY_OFFSET+0x0040904
#define LPM_MEM_IPU_DISP_ALT3__EMPTY                            IPU_MEMORY_OFFSET+0x0040904,0x00000000
#define LPM_MEM_IPU_DISP_ALT3__FULL                             IPU_MEMORY_OFFSET+0x0040904,0xffffffff
#define LPM_MEM_IPU_DISP_ALT3__SEL_ALT_1                        IPU_MEMORY_OFFSET+0x0040904,0xF0000000
#define LPM_MEM_IPU_DISP_ALT3__STEP_REPEAT_ALT_1                IPU_MEMORY_OFFSET+0x0040904,0x0FFF0000
#define LPM_MEM_IPU_DISP_ALT3__CNT_AUTO_RELOAD_ALT_1            IPU_MEMORY_OFFSET+0x0040904,0x00008000
#define LPM_MEM_IPU_DISP_ALT3__CNT_CLR_SEL_ALT_1                IPU_MEMORY_OFFSET+0x0040904,0x00007000
#define LPM_MEM_IPU_DISP_ALT3__RUN_VALUE_M1_ALT_1               IPU_MEMORY_OFFSET+0x0040904,0x00000FFF

#define LPM_MEM_IPU_DISP_ALT4__ADDR                             IPU_MEMORY_OFFSET+0x0040908
#define LPM_MEM_IPU_DISP_ALT4__EMPTY                            IPU_MEMORY_OFFSET+0x0040908,0x00000000
#define LPM_MEM_IPU_DISP_ALT4__FULL                             IPU_MEMORY_OFFSET+0x0040908,0xffffffff
#define LPM_MEM_IPU_DISP_ALT4__RUN_RESOLUTION_ALT_1             IPU_MEMORY_OFFSET+0x0040908,0x00070000
#define LPM_MEM_IPU_DISP_ALT4__OFFSET_RESOLUTION_ALT_1          IPU_MEMORY_OFFSET+0x0040908,0x00007000
#define LPM_MEM_IPU_DISP_ALT4__OFFSET_VALUE_ALT_1               IPU_MEMORY_OFFSET+0x0040908,0x00000FFF

#define LPM_MEM_IPU_SNOOP__ADDR                                 IPU_MEMORY_OFFSET+0x004090C
#define LPM_MEM_IPU_SNOOP__EMPTY                                IPU_MEMORY_OFFSET+0x004090C,0x00000000
#define LPM_MEM_IPU_SNOOP__FULL                                 IPU_MEMORY_OFFSET+0x004090C,0xffffffff
#define LPM_MEM_IPU_SNOOP__SNOOP2_SYNC_BYP                      IPU_MEMORY_OFFSET+0x004090C,0x00010000
#define LPM_MEM_IPU_SNOOP__AUTOREF_PER                          IPU_MEMORY_OFFSET+0x004090C,0x000003FF

#define LPM_MEM_IPU_MEM_RST__ADDR                               IPU_MEMORY_OFFSET+0x0040910
#define LPM_MEM_IPU_MEM_RST__EMPTY                              IPU_MEMORY_OFFSET+0x0040910,0x00000000
#define LPM_MEM_IPU_MEM_RST__FULL                               IPU_MEMORY_OFFSET+0x0040910,0xffffffff
#define LPM_MEM_IPU_MEM_RST__RST_MEM_START                      IPU_MEMORY_OFFSET+0x0040910,0x80000000
#define LPM_MEM_IPU_MEM_RST__RST_MEM_EN                         IPU_MEMORY_OFFSET+0x0040910,0x007FFFFF

#define LPM_MEM_IPU_PM__ADDR                                    IPU_MEMORY_OFFSET+0x0040914
#define LPM_MEM_IPU_PM__EMPTY                                   IPU_MEMORY_OFFSET+0x0040914,0x00000000
#define LPM_MEM_IPU_PM__FULL                                    IPU_MEMORY_OFFSET+0x0040914,0xffffffff
#define LPM_MEM_IPU_PM__LPSR_MODE                               IPU_MEMORY_OFFSET+0x0040914,0x80000000
#define LPM_MEM_IPU_PM__DI1_SRM_CLOCK_CHANGE_MODE               IPU_MEMORY_OFFSET+0x0040914,0x40000000
#define LPM_MEM_IPU_PM__DI1_CLK_PERIOD_1                        IPU_MEMORY_OFFSET+0x0040914,0x3F800000
#define LPM_MEM_IPU_PM__DI1_CLK_PERIOD_0                        IPU_MEMORY_OFFSET+0x0040914,0x007F0000
#define LPM_MEM_IPU_PM__CLOCK_MODE_STAT                         IPU_MEMORY_OFFSET+0x0040914,0x00008000
#define LPM_MEM_IPU_PM__DI0_SRM_CLOCK_CHANGE_MODE               IPU_MEMORY_OFFSET+0x0040914,0x00004000
#define LPM_MEM_IPU_PM__DI0_CLK_PERIOD_1                        IPU_MEMORY_OFFSET+0x0040914,0x00003F80
#define LPM_MEM_IPU_PM__DI0_CLK_PERIOD_0                        IPU_MEMORY_OFFSET+0x0040914,0x0000007F

#define LPM_MEM_IPU_GPR__ADDR                                   IPU_MEMORY_OFFSET+0x0040918
#define LPM_MEM_IPU_GPR__EMPTY                                  IPU_MEMORY_OFFSET+0x0040918,0x00000000
#define LPM_MEM_IPU_GPR__FULL                                   IPU_MEMORY_OFFSET+0x0040918,0xffffffff
#define LPM_MEM_IPU_GPR__IPU_CH_BUF1_RDY1_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x80000000
#define LPM_MEM_IPU_GPR__IPU_CH_BUF1_RDY0_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x40000000
#define LPM_MEM_IPU_GPR__IPU_CH_BUF0_RDY1_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x20000000
#define LPM_MEM_IPU_GPR__IPU_CH_BUF0_RDY0_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x10000000
#define LPM_MEM_IPU_GPR__IPU_ALT_CH_BUF1_RDY1_CLR               IPU_MEMORY_OFFSET+0x0040918,0x08000000
#define LPM_MEM_IPU_GPR__IPU_ALT_CH_BUF1_RDY0_CLR               IPU_MEMORY_OFFSET+0x0040918,0x04000000
#define LPM_MEM_IPU_GPR__IPU_ALT_CH_BUF0_RDY1_CLR               IPU_MEMORY_OFFSET+0x0040918,0x02000000
#define LPM_MEM_IPU_GPR__IPU_ALT_CH_BUF0_RDY0_CLR               IPU_MEMORY_OFFSET+0x0040918,0x01000000
#define LPM_MEM_IPU_GPR__IPU_DI1_CLK_CHANGE_ACK_DIS             IPU_MEMORY_OFFSET+0x0040918,0x00800000
#define LPM_MEM_IPU_GPR__IPU_DI0_CLK_CHANGE_ACK_DIS             IPU_MEMORY_OFFSET+0x0040918,0x00400000
#define LPM_MEM_IPU_GPR__IPU_CH_BUF2_RDY1_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x00200000
#define LPM_MEM_IPU_GPR__IPU_CH_BUF2_RDY0_CLR                   IPU_MEMORY_OFFSET+0x0040918,0x00100000
#define LPM_MEM_IPU_GPR__CM_VF_TSTAT_CLR                        IPU_MEMORY_OFFSET+0x0040918,0x00080000
#define LPM_MEM_IPU_GPR__IPU_GP18                               IPU_MEMORY_OFFSET+0x0040918,0x00040000
#define LPM_MEM_IPU_GPR__IPU_GP17                               IPU_MEMORY_OFFSET+0x0040918,0x00020000
#define LPM_MEM_IPU_GPR__IPU_GP16                               IPU_MEMORY_OFFSET+0x0040918,0x00010000
#define LPM_MEM_IPU_GPR__IPU_GP15                               IPU_MEMORY_OFFSET+0x0040918,0x00008000
#define LPM_MEM_IPU_GPR__IPU_GP14                               IPU_MEMORY_OFFSET+0x0040918,0x00004000
#define LPM_MEM_IPU_GPR__IPU_GP13                               IPU_MEMORY_OFFSET+0x0040918,0x00002000
#define LPM_MEM_IPU_GPR__IPU_GP12                               IPU_MEMORY_OFFSET+0x0040918,0x00001000
#define LPM_MEM_IPU_GPR__IPU_GP11                               IPU_MEMORY_OFFSET+0x0040918,0x00000800
#define LPM_MEM_IPU_GPR__IPU_GP10                               IPU_MEMORY_OFFSET+0x0040918,0x00000400
#define LPM_MEM_IPU_GPR__IPU_GP9                                IPU_MEMORY_OFFSET+0x0040918,0x00000200
#define LPM_MEM_IPU_GPR__IPU_GP8                                IPU_MEMORY_OFFSET+0x0040918,0x00000100
#define LPM_MEM_IPU_GPR__IPU_GP7                                IPU_MEMORY_OFFSET+0x0040918,0x00000080
#define LPM_MEM_IPU_GPR__IPU_GP6                                IPU_MEMORY_OFFSET+0x0040918,0x00000040
#define LPM_MEM_IPU_GPR__IPU_GP5                                IPU_MEMORY_OFFSET+0x0040918,0x00000020
#define LPM_MEM_IPU_GPR__IPU_GP4                                IPU_MEMORY_OFFSET+0x0040918,0x00000010
#define LPM_MEM_IPU_GPR__IPU_GP3                                IPU_MEMORY_OFFSET+0x0040918,0x00000008
#define LPM_MEM_IPU_GPR__IPU_GP2                                IPU_MEMORY_OFFSET+0x0040918,0x00000004
#define LPM_MEM_IPU_GPR__IPU_GP1                                IPU_MEMORY_OFFSET+0x0040918,0x00000002
#define LPM_MEM_IPU_GPR__IPU_GP0                                IPU_MEMORY_OFFSET+0x0040918,0x00000001

#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__ADDR                      IPU_MEMORY_OFFSET+0x0040984
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__EMPTY                     IPU_MEMORY_OFFSET+0x0040984,0x00000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__FULL                      IPU_MEMORY_OFFSET+0x0040984,0xffffffff
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_31     IPU_MEMORY_OFFSET+0x0040984,0x80000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_29     IPU_MEMORY_OFFSET+0x0040984,0x20000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_28     IPU_MEMORY_OFFSET+0x0040984,0x10000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_27     IPU_MEMORY_OFFSET+0x0040984,0x08000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_26     IPU_MEMORY_OFFSET+0x0040984,0x04000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_25     IPU_MEMORY_OFFSET+0x0040984,0x02000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_24     IPU_MEMORY_OFFSET+0x0040984,0x01000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_23     IPU_MEMORY_OFFSET+0x0040984,0x00800000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_22     IPU_MEMORY_OFFSET+0x0040984,0x00400000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_21     IPU_MEMORY_OFFSET+0x0040984,0x00200000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_20     IPU_MEMORY_OFFSET+0x0040984,0x00100000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_19     IPU_MEMORY_OFFSET+0x0040984,0x00080000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_18     IPU_MEMORY_OFFSET+0x0040984,0x00040000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_17     IPU_MEMORY_OFFSET+0x0040984,0x00020000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_15     IPU_MEMORY_OFFSET+0x0040984,0x00008000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_14     IPU_MEMORY_OFFSET+0x0040984,0x00004000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_13     IPU_MEMORY_OFFSET+0x0040984,0x00002000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_12     IPU_MEMORY_OFFSET+0x0040984,0x00001000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_11     IPU_MEMORY_OFFSET+0x0040984,0x00000800
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_10     IPU_MEMORY_OFFSET+0x0040984,0x00000400
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_9      IPU_MEMORY_OFFSET+0x0040984,0x00000200
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_8      IPU_MEMORY_OFFSET+0x0040984,0x00000100
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_5      IPU_MEMORY_OFFSET+0x0040984,0x00000020
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_3      IPU_MEMORY_OFFSET+0x0040984,0x00000008
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_2      IPU_MEMORY_OFFSET+0x0040984,0x00000004
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_1      IPU_MEMORY_OFFSET+0x0040984,0x00000002
#define LPM_MEM_IPU_CH_DB_MODE_SEL_0__DMA_CH_DB_MODE_SEL_0      IPU_MEMORY_OFFSET+0x0040984,0x00000001

#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__ADDR                      IPU_MEMORY_OFFSET+0x0040988
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__EMPTY                     IPU_MEMORY_OFFSET+0x0040988,0x00000000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__FULL                      IPU_MEMORY_OFFSET+0x0040988,0xffffffff
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_52     IPU_MEMORY_OFFSET+0x0040988,0x00100000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_51     IPU_MEMORY_OFFSET+0x0040988,0x00080000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_50     IPU_MEMORY_OFFSET+0x0040988,0x00040000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_49     IPU_MEMORY_OFFSET+0x0040988,0x00020000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_48     IPU_MEMORY_OFFSET+0x0040988,0x00010000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_47     IPU_MEMORY_OFFSET+0x0040988,0x00008000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_46     IPU_MEMORY_OFFSET+0x0040988,0x00004000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_45     IPU_MEMORY_OFFSET+0x0040988,0x00002000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_44     IPU_MEMORY_OFFSET+0x0040988,0x00001000
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_43     IPU_MEMORY_OFFSET+0x0040988,0x00000800
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_42     IPU_MEMORY_OFFSET+0x0040988,0x00000400
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_41     IPU_MEMORY_OFFSET+0x0040988,0x00000200
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_40     IPU_MEMORY_OFFSET+0x0040988,0x00000100
#define LPM_MEM_IPU_CH_DB_MODE_SEL_1__DMA_CH_DB_MODE_SEL_33     IPU_MEMORY_OFFSET+0x0040988,0x00000002

#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__ADDR                  IPU_MEMORY_OFFSET+0x004099C
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__EMPTY                 IPU_MEMORY_OFFSET+0x004099C,0x00000000
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__FULL                  IPU_MEMORY_OFFSET+0x004099C,0xffffffff
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_29 IPU_MEMORY_OFFSET+0x004099C,0x20000000
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_24 IPU_MEMORY_OFFSET+0x004099C,0x01000000
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_7 IPU_MEMORY_OFFSET+0x004099C,0x00000080
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_6 IPU_MEMORY_OFFSET+0x004099C,0x00000040
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_5 IPU_MEMORY_OFFSET+0x004099C,0x00000020
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_0__DMA_CH_ALT_DB_MODE_SEL_4 IPU_MEMORY_OFFSET+0x004099C,0x00000010

#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__ADDR                  IPU_MEMORY_OFFSET+0x00409A0
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__EMPTY                 IPU_MEMORY_OFFSET+0x00409A0,0x00000000
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__FULL                  IPU_MEMORY_OFFSET+0x00409A0,0xffffffff
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_52 IPU_MEMORY_OFFSET+0x00409A0,0x00100000
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_41 IPU_MEMORY_OFFSET+0x00409A0,0x00000200
#define LPM_MEM_IPU_ALT_CH_DB_MODE_SEL_1__DMA_CH_ALT_DB_MODE_SEL_33 IPU_MEMORY_OFFSET+0x00409A0,0x00000002

#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__ADDR                     IPU_MEMORY_OFFSET+0x00409AC
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__EMPTY                    IPU_MEMORY_OFFSET+0x00409AC,0x00000000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__FULL                     IPU_MEMORY_OFFSET+0x00409AC,0xffffffff
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_28   IPU_MEMORY_OFFSET+0x00409AC,0x10000000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_27   IPU_MEMORY_OFFSET+0x00409AC,0x08000000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_23   IPU_MEMORY_OFFSET+0x00409AC,0x00800000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_21   IPU_MEMORY_OFFSET+0x00409AC,0x00200000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_13   IPU_MEMORY_OFFSET+0x00409AC,0x00002000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_10   IPU_MEMORY_OFFSET+0x00409AC,0x00000400
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_9    IPU_MEMORY_OFFSET+0x00409AC,0x00000200
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_8    IPU_MEMORY_OFFSET+0x00409AC,0x00000100
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_2    IPU_MEMORY_OFFSET+0x00409AC,0x00000004
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_0__DMA_CH_TRB_MODE_SEL_0    IPU_MEMORY_OFFSET+0x00409AC,0x00000001

#define LPM_MEM_IPU_CH_TRB_MODE_SEL_1__ADDR                     IPU_MEMORY_OFFSET+0x00409B0
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_1__EMPTY                    IPU_MEMORY_OFFSET+0x00409B0,0x00000000
#define LPM_MEM_IPU_CH_TRB_MODE_SEL_1__FULL                     IPU_MEMORY_OFFSET+0x00409B0,0xffffffff

#define LPM_MEM_IDMAC_CONF__ADDR                                IPU_MEMORY_OFFSET+0x00407E4
#define LPM_MEM_IDMAC_CONF__EMPTY                               IPU_MEMORY_OFFSET+0x00407E4,0x00000000
#define LPM_MEM_IDMAC_CONF__FULL                                IPU_MEMORY_OFFSET+0x00407E4,0xffffffff
#define LPM_MEM_IDMAC_CONF__USED_BUFS_EN_R                      IPU_MEMORY_OFFSET+0x00407E4,0x02000000
#define LPM_MEM_IDMAC_CONF__USED_BUFS_MAX_R                     IPU_MEMORY_OFFSET+0x00407E4,0x01E00000
#define LPM_MEM_IDMAC_CONF__USED_BUFS_EN_W                      IPU_MEMORY_OFFSET+0x00407E4,0x00100000
#define LPM_MEM_IDMAC_CONF__USED_BUFS_MAX_W                     IPU_MEMORY_OFFSET+0x00407E4,0x000E0000
#define LPM_MEM_IDMAC_CONF__P_ENDIAN                            IPU_MEMORY_OFFSET+0x00407E4,0x00010000
#define LPM_MEM_IDMAC_CONF__RDI                                 IPU_MEMORY_OFFSET+0x00407E4,0x00000020
#define LPM_MEM_IDMAC_CONF__WIDPT                               IPU_MEMORY_OFFSET+0x00407E4,0x00000018
#define LPM_MEM_IDMAC_CONF__MAX_REQ_READ                        IPU_MEMORY_OFFSET+0x00407E4,0x00000007

#define LPM_MEM_IDMAC_CH_EN_1__ADDR                             IPU_MEMORY_OFFSET+0x00407E8
#define LPM_MEM_IDMAC_CH_EN_1__EMPTY                            IPU_MEMORY_OFFSET+0x00407E8,0x00000000
#define LPM_MEM_IDMAC_CH_EN_1__FULL                             IPU_MEMORY_OFFSET+0x00407E8,0xffffffff
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_31                   IPU_MEMORY_OFFSET+0x00407E8,0x80000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_29                   IPU_MEMORY_OFFSET+0x00407E8,0x20000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_28                   IPU_MEMORY_OFFSET+0x00407E8,0x10000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_27                   IPU_MEMORY_OFFSET+0x00407E8,0x08000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_26                   IPU_MEMORY_OFFSET+0x00407E8,0x04000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_25                   IPU_MEMORY_OFFSET+0x00407E8,0x02000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_24                   IPU_MEMORY_OFFSET+0x00407E8,0x01000000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_23                   IPU_MEMORY_OFFSET+0x00407E8,0x00800000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_22                   IPU_MEMORY_OFFSET+0x00407E8,0x00400000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_21                   IPU_MEMORY_OFFSET+0x00407E8,0x00200000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_20                   IPU_MEMORY_OFFSET+0x00407E8,0x00100000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_19                   IPU_MEMORY_OFFSET+0x00407E8,0x00080000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_18                   IPU_MEMORY_OFFSET+0x00407E8,0x00040000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_17                   IPU_MEMORY_OFFSET+0x00407E8,0x00020000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_15                   IPU_MEMORY_OFFSET+0x00407E8,0x00008000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_14                   IPU_MEMORY_OFFSET+0x00407E8,0x00004000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_13                   IPU_MEMORY_OFFSET+0x00407E8,0x00002000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_12                   IPU_MEMORY_OFFSET+0x00407E8,0x00001000
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_11                   IPU_MEMORY_OFFSET+0x00407E8,0x00000800
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_10                   IPU_MEMORY_OFFSET+0x00407E8,0x00000400
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_9                    IPU_MEMORY_OFFSET+0x00407E8,0x00000200
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_8                    IPU_MEMORY_OFFSET+0x00407E8,0x00000100
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_5                    IPU_MEMORY_OFFSET+0x00407E8,0x00000020
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_3                    IPU_MEMORY_OFFSET+0x00407E8,0x00000008
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_2                    IPU_MEMORY_OFFSET+0x00407E8,0x00000004
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_1                    IPU_MEMORY_OFFSET+0x00407E8,0x00000002
#define LPM_MEM_IDMAC_CH_EN_1__IDMAC_CH_EN_0                    IPU_MEMORY_OFFSET+0x00407E8,0x00000001

#define LPM_MEM_IDMAC_CH_EN_2__ADDR                             IPU_MEMORY_OFFSET+0x00407EC
#define LPM_MEM_IDMAC_CH_EN_2__EMPTY                            IPU_MEMORY_OFFSET+0x00407EC,0x00000000
#define LPM_MEM_IDMAC_CH_EN_2__FULL                             IPU_MEMORY_OFFSET+0x00407EC,0xffffffff
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_52                   IPU_MEMORY_OFFSET+0x00407EC,0x00100000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_51                   IPU_MEMORY_OFFSET+0x00407EC,0x00080000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_50                   IPU_MEMORY_OFFSET+0x00407EC,0x00040000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_49                   IPU_MEMORY_OFFSET+0x00407EC,0x00020000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_48                   IPU_MEMORY_OFFSET+0x00407EC,0x00010000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_47                   IPU_MEMORY_OFFSET+0x00407EC,0x00008000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_46                   IPU_MEMORY_OFFSET+0x00407EC,0x00004000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_45                   IPU_MEMORY_OFFSET+0x00407EC,0x00002000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_44                   IPU_MEMORY_OFFSET+0x00407EC,0x00001000
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_43                   IPU_MEMORY_OFFSET+0x00407EC,0x00000800
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_42                   IPU_MEMORY_OFFSET+0x00407EC,0x00000400
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_41                   IPU_MEMORY_OFFSET+0x00407EC,0x00000200
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_40                   IPU_MEMORY_OFFSET+0x00407EC,0x00000100
#define LPM_MEM_IDMAC_CH_EN_2__IDMAC_CH_EN_33                   IPU_MEMORY_OFFSET+0x00407EC,0x00000002

#define LPM_MEM_IDMAC_SEP_ALPHA__ADDR                           IPU_MEMORY_OFFSET+0x00407F0
#define LPM_MEM_IDMAC_SEP_ALPHA__EMPTY                          IPU_MEMORY_OFFSET+0x00407F0,0x00000000
#define LPM_MEM_IDMAC_SEP_ALPHA__FULL                           IPU_MEMORY_OFFSET+0x00407F0,0xffffffff
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_29                IPU_MEMORY_OFFSET+0x00407F0,0x20000000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_27                IPU_MEMORY_OFFSET+0x00407F0,0x08000000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_25                IPU_MEMORY_OFFSET+0x00407F0,0x02000000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_24                IPU_MEMORY_OFFSET+0x00407F0,0x01000000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_23                IPU_MEMORY_OFFSET+0x00407F0,0x00800000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_15                IPU_MEMORY_OFFSET+0x00407F0,0x00008000
#define LPM_MEM_IDMAC_SEP_ALPHA__IDMAC_SEP_AL_14                IPU_MEMORY_OFFSET+0x00407F0,0x00004000

#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__ADDR                       IPU_MEMORY_OFFSET+0x00407F4
#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__EMPTY                      IPU_MEMORY_OFFSET+0x00407F4,0x00000000
#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__FULL                       IPU_MEMORY_OFFSET+0x00407F4,0xffffffff
#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_29        IPU_MEMORY_OFFSET+0x00407F4,0x20000000
#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_24        IPU_MEMORY_OFFSET+0x00407F4,0x01000000
#define LPM_MEM_IDMAC_ALT_SEP_ALPHA__IDMAC_ALT_SEP_AL_23        IPU_MEMORY_OFFSET+0x00407F4,0x00800000

#define LPM_MEM_IDMAC_CH_PRI_1__ADDR                            IPU_MEMORY_OFFSET+0x00407F8
#define LPM_MEM_IDMAC_CH_PRI_1__EMPTY                           IPU_MEMORY_OFFSET+0x00407F8,0x00000000
#define LPM_MEM_IDMAC_CH_PRI_1__FULL                            IPU_MEMORY_OFFSET+0x00407F8,0xffffffff
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_29                 IPU_MEMORY_OFFSET+0x00407F8,0x20000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_28                 IPU_MEMORY_OFFSET+0x00407F8,0x10000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_27                 IPU_MEMORY_OFFSET+0x00407F8,0x08000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_26                 IPU_MEMORY_OFFSET+0x00407F8,0x04000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_25                 IPU_MEMORY_OFFSET+0x00407F8,0x02000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_24                 IPU_MEMORY_OFFSET+0x00407F8,0x01000000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_23                 IPU_MEMORY_OFFSET+0x00407F8,0x00800000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_22                 IPU_MEMORY_OFFSET+0x00407F8,0x00400000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_21                 IPU_MEMORY_OFFSET+0x00407F8,0x00200000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_20                 IPU_MEMORY_OFFSET+0x00407F8,0x00100000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_15                 IPU_MEMORY_OFFSET+0x00407F8,0x00008000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_14                 IPU_MEMORY_OFFSET+0x00407F8,0x00004000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_13                 IPU_MEMORY_OFFSET+0x00407F8,0x00002000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_12                 IPU_MEMORY_OFFSET+0x00407F8,0x00001000
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_11                 IPU_MEMORY_OFFSET+0x00407F8,0x00000800
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_10                 IPU_MEMORY_OFFSET+0x00407F8,0x00000400
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_9                  IPU_MEMORY_OFFSET+0x00407F8,0x00000200
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_8                  IPU_MEMORY_OFFSET+0x00407F8,0x00000100
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_5                  IPU_MEMORY_OFFSET+0x00407F8,0x00000020
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_3                  IPU_MEMORY_OFFSET+0x00407F8,0x00000008
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_2                  IPU_MEMORY_OFFSET+0x00407F8,0x00000004
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_1                  IPU_MEMORY_OFFSET+0x00407F8,0x00000002
#define LPM_MEM_IDMAC_CH_PRI_1__IDMAC_CH_PRI_0                  IPU_MEMORY_OFFSET+0x00407F8,0x00000001

#define LPM_MEM_IDMAC_CH_PRI_2__ADDR                            IPU_MEMORY_OFFSET+0x00407FC
#define LPM_MEM_IDMAC_CH_PRI_2__EMPTY                           IPU_MEMORY_OFFSET+0x00407FC,0x00000000
#define LPM_MEM_IDMAC_CH_PRI_2__FULL                            IPU_MEMORY_OFFSET+0x00407FC,0xffffffff
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_50                 IPU_MEMORY_OFFSET+0x00407FC,0x00040000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_49                 IPU_MEMORY_OFFSET+0x00407FC,0x00020000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_48                 IPU_MEMORY_OFFSET+0x00407FC,0x00010000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_47                 IPU_MEMORY_OFFSET+0x00407FC,0x00008000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_46                 IPU_MEMORY_OFFSET+0x00407FC,0x00004000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_45                 IPU_MEMORY_OFFSET+0x00407FC,0x00002000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_44                 IPU_MEMORY_OFFSET+0x00407FC,0x00001000
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_43                 IPU_MEMORY_OFFSET+0x00407FC,0x00000800
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_42                 IPU_MEMORY_OFFSET+0x00407FC,0x00000400
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_41                 IPU_MEMORY_OFFSET+0x00407FC,0x00000200
#define LPM_MEM_IDMAC_CH_PRI_2__IDMAC_CH_PRI_40                 IPU_MEMORY_OFFSET+0x00407FC,0x00000100

#define LPM_MEM_IDMAC_WM_EN_1__ADDR                             IPU_MEMORY_OFFSET+0x0040800
#define LPM_MEM_IDMAC_WM_EN_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040800,0x00000000
#define LPM_MEM_IDMAC_WM_EN_1__FULL                             IPU_MEMORY_OFFSET+0x0040800,0xffffffff
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_29                   IPU_MEMORY_OFFSET+0x0040800,0x20000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_28                   IPU_MEMORY_OFFSET+0x0040800,0x10000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_27                   IPU_MEMORY_OFFSET+0x0040800,0x08000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_26                   IPU_MEMORY_OFFSET+0x0040800,0x04000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_25                   IPU_MEMORY_OFFSET+0x0040800,0x02000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_24                   IPU_MEMORY_OFFSET+0x0040800,0x01000000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_23                   IPU_MEMORY_OFFSET+0x0040800,0x00800000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_14                   IPU_MEMORY_OFFSET+0x0040800,0x00004000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_13                   IPU_MEMORY_OFFSET+0x0040800,0x00002000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_12                   IPU_MEMORY_OFFSET+0x0040800,0x00001000
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_10                   IPU_MEMORY_OFFSET+0x0040800,0x00000400
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_8                    IPU_MEMORY_OFFSET+0x0040800,0x00000100
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_3                    IPU_MEMORY_OFFSET+0x0040800,0x00000008
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_2                    IPU_MEMORY_OFFSET+0x0040800,0x00000004
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_1                    IPU_MEMORY_OFFSET+0x0040800,0x00000002
#define LPM_MEM_IDMAC_WM_EN_1__IDMAC_WM_EN_0                    IPU_MEMORY_OFFSET+0x0040800,0x00000001

#define LPM_MEM_IDMAC_WM_EN_2__ADDR                             IPU_MEMORY_OFFSET+0x0040804
#define LPM_MEM_IDMAC_WM_EN_2__EMPTY                            IPU_MEMORY_OFFSET+0x0040804,0x00000000
#define LPM_MEM_IDMAC_WM_EN_2__FULL                             IPU_MEMORY_OFFSET+0x0040804,0xffffffff
#define LPM_MEM_IDMAC_WM_EN_2__IDMAC_WM_EN_44                   IPU_MEMORY_OFFSET+0x0040804,0x00001000
#define LPM_MEM_IDMAC_WM_EN_2__IDMAC_WM_EN_43                   IPU_MEMORY_OFFSET+0x0040804,0x00000800
#define LPM_MEM_IDMAC_WM_EN_2__IDMAC_WM_EN_42                   IPU_MEMORY_OFFSET+0x0040804,0x00000400
#define LPM_MEM_IDMAC_WM_EN_2__IDMAC_WM_EN_41                   IPU_MEMORY_OFFSET+0x0040804,0x00000200
#define LPM_MEM_IDMAC_WM_EN_2__IDMAC_WM_EN_40                   IPU_MEMORY_OFFSET+0x0040804,0x00000100

#define LPM_MEM_IDMAC_LOCK_EN_1__ADDR                           IPU_MEMORY_OFFSET+0x0040808
#define LPM_MEM_IDMAC_LOCK_EN_1__EMPTY                          IPU_MEMORY_OFFSET+0x0040808,0x00000000
#define LPM_MEM_IDMAC_LOCK_EN_1__FULL                           IPU_MEMORY_OFFSET+0x0040808,0xffffffff
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_28               IPU_MEMORY_OFFSET+0x0040808,0x00300000
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_27               IPU_MEMORY_OFFSET+0x0040808,0x000C0000
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_23               IPU_MEMORY_OFFSET+0x0040808,0x00030000
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_22               IPU_MEMORY_OFFSET+0x0040808,0x0000C000
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_21               IPU_MEMORY_OFFSET+0x0040808,0x00003000
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_20               IPU_MEMORY_OFFSET+0x0040808,0x00000C00
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_15               IPU_MEMORY_OFFSET+0x0040808,0x00000300
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_14               IPU_MEMORY_OFFSET+0x0040808,0x000000C0
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_12               IPU_MEMORY_OFFSET+0x0040808,0x00000030
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_11               IPU_MEMORY_OFFSET+0x0040808,0x0000000C
#define LPM_MEM_IDMAC_LOCK_EN_1__IDMAC_LOCK_EN_5                IPU_MEMORY_OFFSET+0x0040808,0x00000003

#define LPM_MEM_IDMAC_LOCK_EN_2__ADDR                           IPU_MEMORY_OFFSET+0x004080C
#define LPM_MEM_IDMAC_LOCK_EN_2__EMPTY                          IPU_MEMORY_OFFSET+0x004080C,0x00000000
#define LPM_MEM_IDMAC_LOCK_EN_2__FULL                           IPU_MEMORY_OFFSET+0x004080C,0xffffffff
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_50               IPU_MEMORY_OFFSET+0x004080C,0x00000C00
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_49               IPU_MEMORY_OFFSET+0x004080C,0x00000300
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_48               IPU_MEMORY_OFFSET+0x004080C,0x000000C0
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_47               IPU_MEMORY_OFFSET+0x004080C,0x00000030
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_46               IPU_MEMORY_OFFSET+0x004080C,0x0000000C
#define LPM_MEM_IDMAC_LOCK_EN_2__IDMAC_LOCK_EN_45               IPU_MEMORY_OFFSET+0x004080C,0x00000003

#define LPM_MEM_IDMAC_SUB_ADDR_0__ADDR                          IPU_MEMORY_OFFSET+0x0040810
#define LPM_MEM_IDMAC_SUB_ADDR_0__EMPTY                         IPU_MEMORY_OFFSET+0x0040810,0x00000000
#define LPM_MEM_IDMAC_SUB_ADDR_0__FULL                          IPU_MEMORY_OFFSET+0x0040810,0xffffffff
#define LPM_MEM_IDMAC_SUB_ADDR_0__IDMAC_SUB_ADDR_2              IPU_MEMORY_OFFSET+0x0040810,0x00007F00
#define LPM_MEM_IDMAC_SUB_ADDR_0__IDMAC_SUB_ADDR_0              IPU_MEMORY_OFFSET+0x0040810,0x0000007F

#define LPM_MEM_IDMAC_SUB_ADDR_1__ADDR                          IPU_MEMORY_OFFSET+0x0040814
#define LPM_MEM_IDMAC_SUB_ADDR_1__EMPTY                         IPU_MEMORY_OFFSET+0x0040814,0x00000000
#define LPM_MEM_IDMAC_SUB_ADDR_1__FULL                          IPU_MEMORY_OFFSET+0x0040814,0xffffffff
#define LPM_MEM_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_33             IPU_MEMORY_OFFSET+0x0040814,0x7F000000
#define LPM_MEM_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_29             IPU_MEMORY_OFFSET+0x0040814,0x007F0000
#define LPM_MEM_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_24             IPU_MEMORY_OFFSET+0x0040814,0x00007F00
#define LPM_MEM_IDMAC_SUB_ADDR_1__IDMAC_SUB_ADDR_23             IPU_MEMORY_OFFSET+0x0040814,0x0000007F

#define LPM_MEM_IDMAC_SUB_ADDR_2__ADDR                          IPU_MEMORY_OFFSET+0x0040818
#define LPM_MEM_IDMAC_SUB_ADDR_2__EMPTY                         IPU_MEMORY_OFFSET+0x0040818,0x00000000
#define LPM_MEM_IDMAC_SUB_ADDR_2__FULL                          IPU_MEMORY_OFFSET+0x0040818,0xffffffff
#define LPM_MEM_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_52             IPU_MEMORY_OFFSET+0x0040818,0x007F0000
#define LPM_MEM_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_51             IPU_MEMORY_OFFSET+0x0040818,0x00007F00
#define LPM_MEM_IDMAC_SUB_ADDR_2__IDMAC_SUB_ADDR_41             IPU_MEMORY_OFFSET+0x0040818,0x0000007F

#define LPM_MEM_IDMAC_SUB_ADDR_3__ADDR                          IPU_MEMORY_OFFSET+0x004081C
#define LPM_MEM_IDMAC_SUB_ADDR_3__EMPTY                         IPU_MEMORY_OFFSET+0x004081C,0x00000000
#define LPM_MEM_IDMAC_SUB_ADDR_3__FULL                          IPU_MEMORY_OFFSET+0x004081C,0xffffffff
#define LPM_MEM_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_27             IPU_MEMORY_OFFSET+0x004081C,0x7F000000
#define LPM_MEM_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_13             IPU_MEMORY_OFFSET+0x004081C,0x007F0000
#define LPM_MEM_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_10             IPU_MEMORY_OFFSET+0x004081C,0x00007F00
#define LPM_MEM_IDMAC_SUB_ADDR_3__IDMAC_SUB_ADDR_9              IPU_MEMORY_OFFSET+0x004081C,0x0000007F

#define LPM_MEM_IDMAC_SUB_ADDR_4__ADDR                          IPU_MEMORY_OFFSET+0x0040820
#define LPM_MEM_IDMAC_SUB_ADDR_4__EMPTY                         IPU_MEMORY_OFFSET+0x0040820,0x00000000
#define LPM_MEM_IDMAC_SUB_ADDR_4__FULL                          IPU_MEMORY_OFFSET+0x0040820,0xffffffff
#define LPM_MEM_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_21             IPU_MEMORY_OFFSET+0x0040820,0x007F0000
#define LPM_MEM_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_8              IPU_MEMORY_OFFSET+0x0040820,0x00007F00
#define LPM_MEM_IDMAC_SUB_ADDR_4__IDMAC_SUB_ADDR_28             IPU_MEMORY_OFFSET+0x0040820,0x0000007F

#define LPM_MEM_IDMAC_BNDM_EN_1__ADDR                           IPU_MEMORY_OFFSET+0x0040824
#define LPM_MEM_IDMAC_BNDM_EN_1__EMPTY                          IPU_MEMORY_OFFSET+0x0040824,0x00000000
#define LPM_MEM_IDMAC_BNDM_EN_1__FULL                           IPU_MEMORY_OFFSET+0x0040824,0xffffffff
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_26               IPU_MEMORY_OFFSET+0x0040824,0x04000000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_25               IPU_MEMORY_OFFSET+0x0040824,0x02000000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_22               IPU_MEMORY_OFFSET+0x0040824,0x00400000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_21               IPU_MEMORY_OFFSET+0x0040824,0x00200000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_20               IPU_MEMORY_OFFSET+0x0040824,0x00100000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_12               IPU_MEMORY_OFFSET+0x0040824,0x00001000
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_11               IPU_MEMORY_OFFSET+0x0040824,0x00000800
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_10               IPU_MEMORY_OFFSET+0x0040824,0x00000400
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_9                IPU_MEMORY_OFFSET+0x0040824,0x00000200
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_8                IPU_MEMORY_OFFSET+0x0040824,0x00000100
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_5                IPU_MEMORY_OFFSET+0x0040824,0x00000020
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_3                IPU_MEMORY_OFFSET+0x0040824,0x00000008
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_2                IPU_MEMORY_OFFSET+0x0040824,0x00000004
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_1                IPU_MEMORY_OFFSET+0x0040824,0x00000002
#define LPM_MEM_IDMAC_BNDM_EN_1__IDMAC_BNDM_EN_0                IPU_MEMORY_OFFSET+0x0040824,0x00000001

#define LPM_MEM_IDMAC_BNDM_EN_2__ADDR                           IPU_MEMORY_OFFSET+0x0040828
#define LPM_MEM_IDMAC_BNDM_EN_2__EMPTY                          IPU_MEMORY_OFFSET+0x0040828,0x00000000
#define LPM_MEM_IDMAC_BNDM_EN_2__FULL                           IPU_MEMORY_OFFSET+0x0040828,0xffffffff
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_50               IPU_MEMORY_OFFSET+0x0040828,0x00040000
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_49               IPU_MEMORY_OFFSET+0x0040828,0x00020000
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_48               IPU_MEMORY_OFFSET+0x0040828,0x00010000
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_47               IPU_MEMORY_OFFSET+0x0040828,0x00008000
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_46               IPU_MEMORY_OFFSET+0x0040828,0x00004000
#define LPM_MEM_IDMAC_BNDM_EN_2__IDMAC_BNDM_EN_45               IPU_MEMORY_OFFSET+0x0040828,0x00002000

#define LPM_MEM_IDMAC_SC_CORD__ADDR                             IPU_MEMORY_OFFSET+0x004082C
#define LPM_MEM_IDMAC_SC_CORD__EMPTY                            IPU_MEMORY_OFFSET+0x004082C,0x00000000
#define LPM_MEM_IDMAC_SC_CORD__FULL                             IPU_MEMORY_OFFSET+0x004082C,0xffffffff
#define LPM_MEM_IDMAC_SC_CORD__SX0                              IPU_MEMORY_OFFSET+0x004082C,0x0FFF0000
#define LPM_MEM_IDMAC_SC_CORD__SY0                              IPU_MEMORY_OFFSET+0x004082C,0x000007FF

#define LPM_MEM_IDMAC_SC_CORD1__ADDR                            IPU_MEMORY_OFFSET+0x0040830
#define LPM_MEM_IDMAC_SC_CORD1__EMPTY                           IPU_MEMORY_OFFSET+0x0040830,0x00000000
#define LPM_MEM_IDMAC_SC_CORD1__FULL                            IPU_MEMORY_OFFSET+0x0040830,0xffffffff
#define LPM_MEM_IDMAC_SC_CORD1__SX1                             IPU_MEMORY_OFFSET+0x0040830,0x0FFF0000
#define LPM_MEM_IDMAC_SC_CORD1__SY1                             IPU_MEMORY_OFFSET+0x0040830,0x000007FF

#define LPM_MEM_DP_COM_CONF_SYNC__ADDR                          IPU_MEMORY_OFFSET+0x0040000
#define LPM_MEM_DP_COM_CONF_SYNC__EMPTY                         IPU_MEMORY_OFFSET+0x0040000,0x00000000
#define LPM_MEM_DP_COM_CONF_SYNC__FULL                          IPU_MEMORY_OFFSET+0x0040000,0xffffffff
#define LPM_MEM_DP_COM_CONF_SYNC__DP_GAMMA_YUV_EN_SYNC          IPU_MEMORY_OFFSET+0x0040000,0x00002000
#define LPM_MEM_DP_COM_CONF_SYNC__DP_GAMMA_EN_SYNC              IPU_MEMORY_OFFSET+0x0040000,0x00001000
#define LPM_MEM_DP_COM_CONF_SYNC__DP_CSC_YUV_SAT_MODE_SYNC      IPU_MEMORY_OFFSET+0x0040000,0x00000800
#define LPM_MEM_DP_COM_CONF_SYNC__DP_CSC_GAMUT_SAT_EN_SYNC      IPU_MEMORY_OFFSET+0x0040000,0x00000400
#define LPM_MEM_DP_COM_CONF_SYNC__DP_CSC_DEF_SYNC               IPU_MEMORY_OFFSET+0x0040000,0x00000300
#define LPM_MEM_DP_COM_CONF_SYNC__DP_COC_SYNC                   IPU_MEMORY_OFFSET+0x0040000,0x00000070
#define LPM_MEM_DP_COM_CONF_SYNC__DP_GWCKE_SYNC                 IPU_MEMORY_OFFSET+0x0040000,0x00000008
#define LPM_MEM_DP_COM_CONF_SYNC__DP_GWAM_SYNC                  IPU_MEMORY_OFFSET+0x0040000,0x00000004
#define LPM_MEM_DP_COM_CONF_SYNC__DP_GWSEL_SYNC                 IPU_MEMORY_OFFSET+0x0040000,0x00000002
#define LPM_MEM_DP_COM_CONF_SYNC__DP_FG_EN_SYNC                 IPU_MEMORY_OFFSET+0x0040000,0x00000001

#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__ADDR                   IPU_MEMORY_OFFSET+0x0040004
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__EMPTY                  IPU_MEMORY_OFFSET+0x0040004,0x00000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__FULL                   IPU_MEMORY_OFFSET+0x0040004,0xffffffff
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWAV_SYNC           IPU_MEMORY_OFFSET+0x0040004,0xFF000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKR_SYNC          IPU_MEMORY_OFFSET+0x0040004,0x00FF0000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKG_SYNC          IPU_MEMORY_OFFSET+0x0040004,0x0000FF00
#define LPM_MEM_DP_GRAPH_WIND_CTRL_SYNC__DP_GWCKB_SYNC          IPU_MEMORY_OFFSET+0x0040004,0x000000FF

#define LPM_MEM_DP_FG_POS_SYNC__ADDR                            IPU_MEMORY_OFFSET+0x0040008
#define LPM_MEM_DP_FG_POS_SYNC__EMPTY                           IPU_MEMORY_OFFSET+0x0040008,0x00000000
#define LPM_MEM_DP_FG_POS_SYNC__FULL                            IPU_MEMORY_OFFSET+0x0040008,0xffffffff
#define LPM_MEM_DP_FG_POS_SYNC__DP_FGXP_SYNC                    IPU_MEMORY_OFFSET+0x0040008,0x07FF0000
#define LPM_MEM_DP_FG_POS_SYNC__DP_FGYP_SYNC                    IPU_MEMORY_OFFSET+0x0040008,0x000007FF

#define LPM_MEM_DP_CUR_POS_SYNC__ADDR                           IPU_MEMORY_OFFSET+0x004000C
#define LPM_MEM_DP_CUR_POS_SYNC__EMPTY                          IPU_MEMORY_OFFSET+0x004000C,0x00000000
#define LPM_MEM_DP_CUR_POS_SYNC__FULL                           IPU_MEMORY_OFFSET+0x004000C,0xffffffff
#define LPM_MEM_DP_CUR_POS_SYNC__DP_CXW_SYNC                    IPU_MEMORY_OFFSET+0x004000C,0xF8000000
#define LPM_MEM_DP_CUR_POS_SYNC__DP_CXP_SYNC                    IPU_MEMORY_OFFSET+0x004000C,0x07FF0000
#define LPM_MEM_DP_CUR_POS_SYNC__DP_CYH_SYNC                    IPU_MEMORY_OFFSET+0x004000C,0x0000F800
#define LPM_MEM_DP_CUR_POS_SYNC__DP_CYP_SYNC                    IPU_MEMORY_OFFSET+0x004000C,0x000007FF

#define LPM_MEM_DP_CUR_MAP_SYNC__ADDR                           IPU_MEMORY_OFFSET+0x0040010
#define LPM_MEM_DP_CUR_MAP_SYNC__EMPTY                          IPU_MEMORY_OFFSET+0x0040010,0x00000000
#define LPM_MEM_DP_CUR_MAP_SYNC__FULL                           IPU_MEMORY_OFFSET+0x0040010,0xffffffff
#define LPM_MEM_DP_CUR_MAP_SYNC__DP_CUR_COL_R_SYNC              IPU_MEMORY_OFFSET+0x0040010,0x00FF0000
#define LPM_MEM_DP_CUR_MAP_SYNC__DP_CUR_COL_G_SYNC              IPU_MEMORY_OFFSET+0x0040010,0x0000FF00
#define LPM_MEM_DP_CUR_MAP_SYNC__DP_CUR_COL_B_SYNC              IPU_MEMORY_OFFSET+0x0040010,0x000000FF

#define LPM_MEM_DP_GAMMA_C_SYNC_0__ADDR                         IPU_MEMORY_OFFSET+0x0040014
#define LPM_MEM_DP_GAMMA_C_SYNC_0__EMPTY                        IPU_MEMORY_OFFSET+0x0040014,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_0__FULL                         IPU_MEMORY_OFFSET+0x0040014,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_1            IPU_MEMORY_OFFSET+0x0040014,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_0__DP_GAMMA_C_SYNC_0            IPU_MEMORY_OFFSET+0x0040014,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_1__ADDR                         IPU_MEMORY_OFFSET+0x0040018
#define LPM_MEM_DP_GAMMA_C_SYNC_1__EMPTY                        IPU_MEMORY_OFFSET+0x0040018,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_1__FULL                         IPU_MEMORY_OFFSET+0x0040018,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_3            IPU_MEMORY_OFFSET+0x0040018,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_1__DP_GAMMA_C_SYNC_2            IPU_MEMORY_OFFSET+0x0040018,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_2__ADDR                         IPU_MEMORY_OFFSET+0x004001C
#define LPM_MEM_DP_GAMMA_C_SYNC_2__EMPTY                        IPU_MEMORY_OFFSET+0x004001C,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_2__FULL                         IPU_MEMORY_OFFSET+0x004001C,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_5            IPU_MEMORY_OFFSET+0x004001C,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_2__DP_GAMMA_C_SYNC_4            IPU_MEMORY_OFFSET+0x004001C,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_3__ADDR                         IPU_MEMORY_OFFSET+0x0040020
#define LPM_MEM_DP_GAMMA_C_SYNC_3__EMPTY                        IPU_MEMORY_OFFSET+0x0040020,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_3__FULL                         IPU_MEMORY_OFFSET+0x0040020,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_7            IPU_MEMORY_OFFSET+0x0040020,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_3__DP_GAMMA_C_SYNC_6            IPU_MEMORY_OFFSET+0x0040020,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_4__ADDR                         IPU_MEMORY_OFFSET+0x0040024
#define LPM_MEM_DP_GAMMA_C_SYNC_4__EMPTY                        IPU_MEMORY_OFFSET+0x0040024,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_4__FULL                         IPU_MEMORY_OFFSET+0x0040024,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_9            IPU_MEMORY_OFFSET+0x0040024,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_4__DP_GAMMA_C_SYNC_8            IPU_MEMORY_OFFSET+0x0040024,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_5__ADDR                         IPU_MEMORY_OFFSET+0x0040028
#define LPM_MEM_DP_GAMMA_C_SYNC_5__EMPTY                        IPU_MEMORY_OFFSET+0x0040028,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_5__FULL                         IPU_MEMORY_OFFSET+0x0040028,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_11           IPU_MEMORY_OFFSET+0x0040028,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_5__DP_GAMMA_C_SYNC_10           IPU_MEMORY_OFFSET+0x0040028,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_6__ADDR                         IPU_MEMORY_OFFSET+0x004002C
#define LPM_MEM_DP_GAMMA_C_SYNC_6__EMPTY                        IPU_MEMORY_OFFSET+0x004002C,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_6__FULL                         IPU_MEMORY_OFFSET+0x004002C,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_13           IPU_MEMORY_OFFSET+0x004002C,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_6__DP_GAMMA_C_SYNC_12           IPU_MEMORY_OFFSET+0x004002C,0x000001FF

#define LPM_MEM_DP_GAMMA_C_SYNC_7__ADDR                         IPU_MEMORY_OFFSET+0x0040030
#define LPM_MEM_DP_GAMMA_C_SYNC_7__EMPTY                        IPU_MEMORY_OFFSET+0x0040030,0x00000000
#define LPM_MEM_DP_GAMMA_C_SYNC_7__FULL                         IPU_MEMORY_OFFSET+0x0040030,0xffffffff
#define LPM_MEM_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_15           IPU_MEMORY_OFFSET+0x0040030,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_SYNC_7__DP_GAMMA_C_SYNC_14           IPU_MEMORY_OFFSET+0x0040030,0x000001FF

#define LPM_MEM_DP_GAMMA_S_SYNC_0__ADDR                         IPU_MEMORY_OFFSET+0x0040034
#define LPM_MEM_DP_GAMMA_S_SYNC_0__EMPTY                        IPU_MEMORY_OFFSET+0x0040034,0x00000000
#define LPM_MEM_DP_GAMMA_S_SYNC_0__FULL                         IPU_MEMORY_OFFSET+0x0040034,0xffffffff
#define LPM_MEM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_3            IPU_MEMORY_OFFSET+0x0040034,0xFF000000
#define LPM_MEM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_2            IPU_MEMORY_OFFSET+0x0040034,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_1            IPU_MEMORY_OFFSET+0x0040034,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_SYNC_0__DP_GAMMA_S_SYNC_0            IPU_MEMORY_OFFSET+0x0040034,0x000000FF

#define LPM_MEM_DP_GAMMA_S_SYNC_1__ADDR                         IPU_MEMORY_OFFSET+0x0040038
#define LPM_MEM_DP_GAMMA_S_SYNC_1__EMPTY                        IPU_MEMORY_OFFSET+0x0040038,0x00000000
#define LPM_MEM_DP_GAMMA_S_SYNC_1__FULL                         IPU_MEMORY_OFFSET+0x0040038,0xffffffff
#define LPM_MEM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_7            IPU_MEMORY_OFFSET+0x0040038,0xFF000000
#define LPM_MEM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_6            IPU_MEMORY_OFFSET+0x0040038,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_5            IPU_MEMORY_OFFSET+0x0040038,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_SYNC_1__DP_GAMMA_S_SYNC_4            IPU_MEMORY_OFFSET+0x0040038,0x000000FF

#define LPM_MEM_DP_GAMMA_S_SYNC_2__ADDR                         IPU_MEMORY_OFFSET+0x004003C
#define LPM_MEM_DP_GAMMA_S_SYNC_2__EMPTY                        IPU_MEMORY_OFFSET+0x004003C,0x00000000
#define LPM_MEM_DP_GAMMA_S_SYNC_2__FULL                         IPU_MEMORY_OFFSET+0x004003C,0xffffffff
#define LPM_MEM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_11           IPU_MEMORY_OFFSET+0x004003C,0xFF000000
#define LPM_MEM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_10           IPU_MEMORY_OFFSET+0x004003C,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_9            IPU_MEMORY_OFFSET+0x004003C,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_SYNC_2__DP_GAMMA_S_SYNC_8            IPU_MEMORY_OFFSET+0x004003C,0x000000FF

#define LPM_MEM_DP_GAMMA_S_SYNC_3__ADDR                         IPU_MEMORY_OFFSET+0x0040040
#define LPM_MEM_DP_GAMMA_S_SYNC_3__EMPTY                        IPU_MEMORY_OFFSET+0x0040040,0x00000000
#define LPM_MEM_DP_GAMMA_S_SYNC_3__FULL                         IPU_MEMORY_OFFSET+0x0040040,0xffffffff
#define LPM_MEM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_15           IPU_MEMORY_OFFSET+0x0040040,0xFF000000
#define LPM_MEM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_14           IPU_MEMORY_OFFSET+0x0040040,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_13           IPU_MEMORY_OFFSET+0x0040040,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_SYNC_3__DP_GAMMA_S_SYNC_12           IPU_MEMORY_OFFSET+0x0040040,0x000000FF

#define LPM_MEM_DP_CSCA_SYNC_0__ADDR                            IPU_MEMORY_OFFSET+0x0040044
#define LPM_MEM_DP_CSCA_SYNC_0__EMPTY                           IPU_MEMORY_OFFSET+0x0040044,0x00000000
#define LPM_MEM_DP_CSCA_SYNC_0__FULL                            IPU_MEMORY_OFFSET+0x0040044,0xffffffff
#define LPM_MEM_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_1                 IPU_MEMORY_OFFSET+0x0040044,0x03FF0000
#define LPM_MEM_DP_CSCA_SYNC_0__DP_CSC_A_SYNC_0                 IPU_MEMORY_OFFSET+0x0040044,0x000003FF

#define LPM_MEM_DP_CSCA_SYNC_1__ADDR                            IPU_MEMORY_OFFSET+0x0040048
#define LPM_MEM_DP_CSCA_SYNC_1__EMPTY                           IPU_MEMORY_OFFSET+0x0040048,0x00000000
#define LPM_MEM_DP_CSCA_SYNC_1__FULL                            IPU_MEMORY_OFFSET+0x0040048,0xffffffff
#define LPM_MEM_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_3                 IPU_MEMORY_OFFSET+0x0040048,0x03FF0000
#define LPM_MEM_DP_CSCA_SYNC_1__DP_CSC_A_SYNC_2                 IPU_MEMORY_OFFSET+0x0040048,0x000003FF

#define LPM_MEM_DP_CSCA_SYNC_2__ADDR                            IPU_MEMORY_OFFSET+0x004004C
#define LPM_MEM_DP_CSCA_SYNC_2__EMPTY                           IPU_MEMORY_OFFSET+0x004004C,0x00000000
#define LPM_MEM_DP_CSCA_SYNC_2__FULL                            IPU_MEMORY_OFFSET+0x004004C,0xffffffff
#define LPM_MEM_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_5                 IPU_MEMORY_OFFSET+0x004004C,0x03FF0000
#define LPM_MEM_DP_CSCA_SYNC_2__DP_CSC_A_SYNC_4                 IPU_MEMORY_OFFSET+0x004004C,0x000003FF

#define LPM_MEM_DP_CSCA_SYNC_3__ADDR                            IPU_MEMORY_OFFSET+0x0040050
#define LPM_MEM_DP_CSCA_SYNC_3__EMPTY                           IPU_MEMORY_OFFSET+0x0040050,0x00000000
#define LPM_MEM_DP_CSCA_SYNC_3__FULL                            IPU_MEMORY_OFFSET+0x0040050,0xffffffff
#define LPM_MEM_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_7                 IPU_MEMORY_OFFSET+0x0040050,0x03FF0000
#define LPM_MEM_DP_CSCA_SYNC_3__DP_CSC_A_SYNC_6                 IPU_MEMORY_OFFSET+0x0040050,0x000003FF

#define LPM_MEM_DP_CSC_SYNC_0__ADDR                             IPU_MEMORY_OFFSET+0x0040054
#define LPM_MEM_DP_CSC_SYNC_0__EMPTY                            IPU_MEMORY_OFFSET+0x0040054,0x00000000
#define LPM_MEM_DP_CSC_SYNC_0__FULL                             IPU_MEMORY_OFFSET+0x0040054,0xffffffff
#define LPM_MEM_DP_CSC_SYNC_0__DP_CSC_S0_SYNC                   IPU_MEMORY_OFFSET+0x0040054,0xC0000000
#define LPM_MEM_DP_CSC_SYNC_0__DP_CSC_B0_SYNC                   IPU_MEMORY_OFFSET+0x0040054,0x3FFF0000
#define LPM_MEM_DP_CSC_SYNC_0__DP_CSC_A8_SYNC                   IPU_MEMORY_OFFSET+0x0040054,0x000003FF

#define LPM_MEM_DP_CSC_SYNC_1__ADDR                             IPU_MEMORY_OFFSET+0x0040058
#define LPM_MEM_DP_CSC_SYNC_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040058,0x00000000
#define LPM_MEM_DP_CSC_SYNC_1__FULL                             IPU_MEMORY_OFFSET+0x0040058,0xffffffff
#define LPM_MEM_DP_CSC_SYNC_1__DP_CSC_S2_SYNC                   IPU_MEMORY_OFFSET+0x0040058,0xC0000000
#define LPM_MEM_DP_CSC_SYNC_1__DP_CSC_B2_SYNC                   IPU_MEMORY_OFFSET+0x0040058,0x3FFF0000
#define LPM_MEM_DP_CSC_SYNC_1__DP_CSC_S1_SYNC                   IPU_MEMORY_OFFSET+0x0040058,0x0000C000
#define LPM_MEM_DP_CSC_SYNC_1__DP_CSC_B1_SYNC                   IPU_MEMORY_OFFSET+0x0040058,0x00003FFF

#define LPM_MEM_DP_CUR_POS_ALT__ADDR                            IPU_MEMORY_OFFSET+0x004005C
#define LPM_MEM_DP_CUR_POS_ALT__EMPTY                           IPU_MEMORY_OFFSET+0x004005C,0x00000000
#define LPM_MEM_DP_CUR_POS_ALT__FULL                            IPU_MEMORY_OFFSET+0x004005C,0xffffffff
#define LPM_MEM_DP_CUR_POS_ALT__DP_CXW_SYNC_ALT                 IPU_MEMORY_OFFSET+0x004005C,0xF8000000
#define LPM_MEM_DP_CUR_POS_ALT__DP_CXP_SYNC_ALT                 IPU_MEMORY_OFFSET+0x004005C,0x07FF0000
#define LPM_MEM_DP_CUR_POS_ALT__DP_CYH_SYNC_ALT                 IPU_MEMORY_OFFSET+0x004005C,0x0000F800
#define LPM_MEM_DP_CUR_POS_ALT__DP_CYP_SYNC_ALT                 IPU_MEMORY_OFFSET+0x004005C,0x000007FF

#define LPM_MEM_DP_COM_CONF_ASYNC0__ADDR                        IPU_MEMORY_OFFSET+0x0040060
#define LPM_MEM_DP_COM_CONF_ASYNC0__EMPTY                       IPU_MEMORY_OFFSET+0x0040060,0x00000000
#define LPM_MEM_DP_COM_CONF_ASYNC0__FULL                        IPU_MEMORY_OFFSET+0x0040060,0xffffffff
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_GAMMA_YUV_EN_ASYNC0      IPU_MEMORY_OFFSET+0x0040060,0x00002000
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_GAMMA_EN_ASYNC0          IPU_MEMORY_OFFSET+0x0040060,0x00001000
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_CSC_YUV_SAT_MODE_ASYNC0  IPU_MEMORY_OFFSET+0x0040060,0x00000800
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_CSC_GAMUT_SAT_EN_ASYNC0  IPU_MEMORY_OFFSET+0x0040060,0x00000400
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_CSC_DEF_ASYNC0           IPU_MEMORY_OFFSET+0x0040060,0x00000300
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_COC_ASYNC0               IPU_MEMORY_OFFSET+0x0040060,0x00000070
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_GWCKE_ASYNC0             IPU_MEMORY_OFFSET+0x0040060,0x00000008
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_GWAM_ASYNC0              IPU_MEMORY_OFFSET+0x0040060,0x00000004
#define LPM_MEM_DP_COM_CONF_ASYNC0__DP_GWSEL_ASYNC0             IPU_MEMORY_OFFSET+0x0040060,0x00000002

#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__ADDR                 IPU_MEMORY_OFFSET+0x0040064
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__EMPTY                IPU_MEMORY_OFFSET+0x0040064,0x00000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__FULL                 IPU_MEMORY_OFFSET+0x0040064,0xffffffff
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWAV_ASYNC0       IPU_MEMORY_OFFSET+0x0040064,0xFF000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKR_ASYNC0      IPU_MEMORY_OFFSET+0x0040064,0x00FF0000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKG_ASYNC0      IPU_MEMORY_OFFSET+0x0040064,0x0000FF00
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC0__DP_GWCKB_ASYNC0      IPU_MEMORY_OFFSET+0x0040064,0x000000FF

#define LPM_MEM_DP_FG_POS_ASYNC0__ADDR                          IPU_MEMORY_OFFSET+0x0040068
#define LPM_MEM_DP_FG_POS_ASYNC0__EMPTY                         IPU_MEMORY_OFFSET+0x0040068,0x00000000
#define LPM_MEM_DP_FG_POS_ASYNC0__FULL                          IPU_MEMORY_OFFSET+0x0040068,0xffffffff
#define LPM_MEM_DP_FG_POS_ASYNC0__DP_FGXP_ASYNC0                IPU_MEMORY_OFFSET+0x0040068,0x07FF0000
#define LPM_MEM_DP_FG_POS_ASYNC0__DP_FGYP_ASYNC0                IPU_MEMORY_OFFSET+0x0040068,0x000007FF

#define LPM_MEM_DP_CUR_POS_ASYNC0__ADDR                         IPU_MEMORY_OFFSET+0x004006C
#define LPM_MEM_DP_CUR_POS_ASYNC0__EMPTY                        IPU_MEMORY_OFFSET+0x004006C,0x00000000
#define LPM_MEM_DP_CUR_POS_ASYNC0__FULL                         IPU_MEMORY_OFFSET+0x004006C,0xffffffff
#define LPM_MEM_DP_CUR_POS_ASYNC0__DP_CXW_ASYNC0                IPU_MEMORY_OFFSET+0x004006C,0xF8000000
#define LPM_MEM_DP_CUR_POS_ASYNC0__DP_CXP_ASYNC0                IPU_MEMORY_OFFSET+0x004006C,0x07FF0000
#define LPM_MEM_DP_CUR_POS_ASYNC0__DP_CYH_ASYNC0                IPU_MEMORY_OFFSET+0x004006C,0x0000F800
#define LPM_MEM_DP_CUR_POS_ASYNC0__DP_CYP_ASYNC0                IPU_MEMORY_OFFSET+0x004006C,0x000007FF

#define LPM_MEM_DP_CUR_MAP_ASYNC0__ADDR                         IPU_MEMORY_OFFSET+0x0040070
#define LPM_MEM_DP_CUR_MAP_ASYNC0__EMPTY                        IPU_MEMORY_OFFSET+0x0040070,0x00000000
#define LPM_MEM_DP_CUR_MAP_ASYNC0__FULL                         IPU_MEMORY_OFFSET+0x0040070,0xffffffff
#define LPM_MEM_DP_CUR_MAP_ASYNC0__CUR_COL_R_ASYNC0             IPU_MEMORY_OFFSET+0x0040070,0x00FF0000
#define LPM_MEM_DP_CUR_MAP_ASYNC0__CUR_COL_G_ASYNC0             IPU_MEMORY_OFFSET+0x0040070,0x0000FF00
#define LPM_MEM_DP_CUR_MAP_ASYNC0__CUR_COL_B_ASYNC0             IPU_MEMORY_OFFSET+0x0040070,0x000000FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_0__ADDR                       IPU_MEMORY_OFFSET+0x0040074
#define LPM_MEM_DP_GAMMA_C_ASYNC0_0__EMPTY                      IPU_MEMORY_OFFSET+0x0040074,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_0__FULL                       IPU_MEMORY_OFFSET+0x0040074,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_1        IPU_MEMORY_OFFSET+0x0040074,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_0__DP_GAMMA_C_ASYNC0_0        IPU_MEMORY_OFFSET+0x0040074,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_1__ADDR                       IPU_MEMORY_OFFSET+0x0040078
#define LPM_MEM_DP_GAMMA_C_ASYNC0_1__EMPTY                      IPU_MEMORY_OFFSET+0x0040078,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_1__FULL                       IPU_MEMORY_OFFSET+0x0040078,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_3        IPU_MEMORY_OFFSET+0x0040078,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_1__DP_GAMMA_C_ASYNC0_2        IPU_MEMORY_OFFSET+0x0040078,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_2__ADDR                       IPU_MEMORY_OFFSET+0x004007C
#define LPM_MEM_DP_GAMMA_C_ASYNC0_2__EMPTY                      IPU_MEMORY_OFFSET+0x004007C,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_2__FULL                       IPU_MEMORY_OFFSET+0x004007C,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_5        IPU_MEMORY_OFFSET+0x004007C,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_2__DP_GAMMA_C_ASYNC0_4        IPU_MEMORY_OFFSET+0x004007C,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_3__ADDR                       IPU_MEMORY_OFFSET+0x0040080
#define LPM_MEM_DP_GAMMA_C_ASYNC0_3__EMPTY                      IPU_MEMORY_OFFSET+0x0040080,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_3__FULL                       IPU_MEMORY_OFFSET+0x0040080,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_7        IPU_MEMORY_OFFSET+0x0040080,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_3__DP_GAMMA_C_ASYNC0_6        IPU_MEMORY_OFFSET+0x0040080,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_4__ADDR                       IPU_MEMORY_OFFSET+0x0040084
#define LPM_MEM_DP_GAMMA_C_ASYNC0_4__EMPTY                      IPU_MEMORY_OFFSET+0x0040084,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_4__FULL                       IPU_MEMORY_OFFSET+0x0040084,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_9        IPU_MEMORY_OFFSET+0x0040084,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_4__DP_GAMMA_C_ASYNC0_8        IPU_MEMORY_OFFSET+0x0040084,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_5__ADDR                       IPU_MEMORY_OFFSET+0x0040088
#define LPM_MEM_DP_GAMMA_C_ASYNC0_5__EMPTY                      IPU_MEMORY_OFFSET+0x0040088,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_5__FULL                       IPU_MEMORY_OFFSET+0x0040088,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_11       IPU_MEMORY_OFFSET+0x0040088,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_5__DP_GAMMA_C_ASYNC0_10       IPU_MEMORY_OFFSET+0x0040088,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_6__ADDR                       IPU_MEMORY_OFFSET+0x004008C
#define LPM_MEM_DP_GAMMA_C_ASYNC0_6__EMPTY                      IPU_MEMORY_OFFSET+0x004008C,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_6__FULL                       IPU_MEMORY_OFFSET+0x004008C,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_13       IPU_MEMORY_OFFSET+0x004008C,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_6__DP_GAMMA_C_ASYNC0_12       IPU_MEMORY_OFFSET+0x004008C,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC0_7__ADDR                       IPU_MEMORY_OFFSET+0x0040090
#define LPM_MEM_DP_GAMMA_C_ASYNC0_7__EMPTY                      IPU_MEMORY_OFFSET+0x0040090,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_7__FULL                       IPU_MEMORY_OFFSET+0x0040090,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_15       IPU_MEMORY_OFFSET+0x0040090,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC0_7__DP_GAMMA_C_ASYNC0_14       IPU_MEMORY_OFFSET+0x0040090,0x000001FF

#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__ADDR                       IPU_MEMORY_OFFSET+0x0040094
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__EMPTY                      IPU_MEMORY_OFFSET+0x0040094,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__FULL                       IPU_MEMORY_OFFSET+0x0040094,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_3        IPU_MEMORY_OFFSET+0x0040094,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_2        IPU_MEMORY_OFFSET+0x0040094,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_1        IPU_MEMORY_OFFSET+0x0040094,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC0_0__DP_GAMMA_S_ASYNC0_0        IPU_MEMORY_OFFSET+0x0040094,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__ADDR                       IPU_MEMORY_OFFSET+0x0040098
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__EMPTY                      IPU_MEMORY_OFFSET+0x0040098,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__FULL                       IPU_MEMORY_OFFSET+0x0040098,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_7        IPU_MEMORY_OFFSET+0x0040098,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_6        IPU_MEMORY_OFFSET+0x0040098,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_5        IPU_MEMORY_OFFSET+0x0040098,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC0_1__DP_GAMMA_S_ASYNC0_4        IPU_MEMORY_OFFSET+0x0040098,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__ADDR                       IPU_MEMORY_OFFSET+0x004009C
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__EMPTY                      IPU_MEMORY_OFFSET+0x004009C,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__FULL                       IPU_MEMORY_OFFSET+0x004009C,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_11       IPU_MEMORY_OFFSET+0x004009C,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_10       IPU_MEMORY_OFFSET+0x004009C,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_9        IPU_MEMORY_OFFSET+0x004009C,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC0_2__DP_GAMMA_S_ASYNC0_8        IPU_MEMORY_OFFSET+0x004009C,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__ADDR                       IPU_MEMORY_OFFSET+0x00400A0
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__EMPTY                      IPU_MEMORY_OFFSET+0x00400A0,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__FULL                       IPU_MEMORY_OFFSET+0x00400A0,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_15       IPU_MEMORY_OFFSET+0x00400A0,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_14       IPU_MEMORY_OFFSET+0x00400A0,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_13       IPU_MEMORY_OFFSET+0x00400A0,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC0_3__DP_GAMMA_S_ASYNC0_12       IPU_MEMORY_OFFSET+0x00400A0,0x000000FF

#define LPM_MEM_DP_CSCA_ASYNC0_0__ADDR                          IPU_MEMORY_OFFSET+0x00400A4
#define LPM_MEM_DP_CSCA_ASYNC0_0__EMPTY                         IPU_MEMORY_OFFSET+0x00400A4,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC0_0__FULL                          IPU_MEMORY_OFFSET+0x00400A4,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_1             IPU_MEMORY_OFFSET+0x00400A4,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC0_0__DP_CSC_A_ASYNC0_0             IPU_MEMORY_OFFSET+0x00400A4,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC0_1__ADDR                          IPU_MEMORY_OFFSET+0x00400A8
#define LPM_MEM_DP_CSCA_ASYNC0_1__EMPTY                         IPU_MEMORY_OFFSET+0x00400A8,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC0_1__FULL                          IPU_MEMORY_OFFSET+0x00400A8,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_3             IPU_MEMORY_OFFSET+0x00400A8,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC0_1__DP_CSC_A_ASYNC0_2             IPU_MEMORY_OFFSET+0x00400A8,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC0_2__ADDR                          IPU_MEMORY_OFFSET+0x00400AC
#define LPM_MEM_DP_CSCA_ASYNC0_2__EMPTY                         IPU_MEMORY_OFFSET+0x00400AC,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC0_2__FULL                          IPU_MEMORY_OFFSET+0x00400AC,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_5             IPU_MEMORY_OFFSET+0x00400AC,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC0_2__DP_CSC_A_ASYNC0_4             IPU_MEMORY_OFFSET+0x00400AC,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC0_3__ADDR                          IPU_MEMORY_OFFSET+0x00400B0
#define LPM_MEM_DP_CSCA_ASYNC0_3__EMPTY                         IPU_MEMORY_OFFSET+0x00400B0,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC0_3__FULL                          IPU_MEMORY_OFFSET+0x00400B0,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_7             IPU_MEMORY_OFFSET+0x00400B0,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC0_3__DP_CSC_A_ASYNC0_6             IPU_MEMORY_OFFSET+0x00400B0,0x000003FF

#define LPM_MEM_DP_CSC_ASYNC0_0__ADDR                           IPU_MEMORY_OFFSET+0x00400B4
#define LPM_MEM_DP_CSC_ASYNC0_0__EMPTY                          IPU_MEMORY_OFFSET+0x00400B4,0x00000000
#define LPM_MEM_DP_CSC_ASYNC0_0__FULL                           IPU_MEMORY_OFFSET+0x00400B4,0xffffffff
#define LPM_MEM_DP_CSC_ASYNC0_0__DP_CSC_S0_ASYNC0               IPU_MEMORY_OFFSET+0x00400B4,0xC0000000
#define LPM_MEM_DP_CSC_ASYNC0_0__DP_CSC_B0_ASYNC0               IPU_MEMORY_OFFSET+0x00400B4,0x3FFF0000
#define LPM_MEM_DP_CSC_ASYNC0_0__DP_CSC_A8_ASYNC0               IPU_MEMORY_OFFSET+0x00400B4,0x000003FF

#define LPM_MEM_DP_CSC_ASYNC0_1__ADDR                           IPU_MEMORY_OFFSET+0x00400B8
#define LPM_MEM_DP_CSC_ASYNC0_1__EMPTY                          IPU_MEMORY_OFFSET+0x00400B8,0x00000000
#define LPM_MEM_DP_CSC_ASYNC0_1__FULL                           IPU_MEMORY_OFFSET+0x00400B8,0xffffffff
#define LPM_MEM_DP_CSC_ASYNC0_1__DP_CSC_S2_ASYNC0               IPU_MEMORY_OFFSET+0x00400B8,0xC0000000
#define LPM_MEM_DP_CSC_ASYNC0_1__DP_CSC_B2_ASYNC0               IPU_MEMORY_OFFSET+0x00400B8,0x3FFF0000
#define LPM_MEM_DP_CSC_ASYNC0_1__DP_CSC_S1_ASYNC0               IPU_MEMORY_OFFSET+0x00400B8,0x0000C000
#define LPM_MEM_DP_CSC_ASYNC0_1__DP_CSC_B1_ASYNC0               IPU_MEMORY_OFFSET+0x00400B8,0x00003FFF

#define LPM_MEM_DP_COM_CONF_ASYNC1__ADDR                        IPU_MEMORY_OFFSET+0x00400BC
#define LPM_MEM_DP_COM_CONF_ASYNC1__EMPTY                       IPU_MEMORY_OFFSET+0x00400BC,0x00000000
#define LPM_MEM_DP_COM_CONF_ASYNC1__FULL                        IPU_MEMORY_OFFSET+0x00400BC,0xffffffff
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_GAMMA_YUV_EN_ASYNC1      IPU_MEMORY_OFFSET+0x00400BC,0x00002000
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_GAMMA_EN_ASYNC1          IPU_MEMORY_OFFSET+0x00400BC,0x00001000
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_CSC_YUV_SAT_MODE_ASYNC1  IPU_MEMORY_OFFSET+0x00400BC,0x00000800
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_CSC_GAMUT_SAT_EN_ASYNC1  IPU_MEMORY_OFFSET+0x00400BC,0x00000400
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_CSC_DEF_ASYNC1           IPU_MEMORY_OFFSET+0x00400BC,0x00000300
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_COC_ASYNC1               IPU_MEMORY_OFFSET+0x00400BC,0x00000070
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_GWCKE_ASYNC1             IPU_MEMORY_OFFSET+0x00400BC,0x00000008
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_GWAM_ASYNC1              IPU_MEMORY_OFFSET+0x00400BC,0x00000004
#define LPM_MEM_DP_COM_CONF_ASYNC1__DP_GWSEL_ASYNC1             IPU_MEMORY_OFFSET+0x00400BC,0x00000002

#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__ADDR                 IPU_MEMORY_OFFSET+0x00400C0
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__EMPTY                IPU_MEMORY_OFFSET+0x00400C0,0x00000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__FULL                 IPU_MEMORY_OFFSET+0x00400C0,0xffffffff
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWAV_ASYNC1       IPU_MEMORY_OFFSET+0x00400C0,0xFF000000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKR_ASYNC1      IPU_MEMORY_OFFSET+0x00400C0,0x00FF0000
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKG_ASYNC1      IPU_MEMORY_OFFSET+0x00400C0,0x0000FF00
#define LPM_MEM_DP_GRAPH_WIND_CTRL_ASYNC1__DP_GWCKB_ASYNC1      IPU_MEMORY_OFFSET+0x00400C0,0x000000FF

#define LPM_MEM_DP_FG_POS_ASYNC1__ADDR                          IPU_MEMORY_OFFSET+0x00400C4
#define LPM_MEM_DP_FG_POS_ASYNC1__EMPTY                         IPU_MEMORY_OFFSET+0x00400C4,0x00000000
#define LPM_MEM_DP_FG_POS_ASYNC1__FULL                          IPU_MEMORY_OFFSET+0x00400C4,0xffffffff
#define LPM_MEM_DP_FG_POS_ASYNC1__DP_FGXP_ASYNC1                IPU_MEMORY_OFFSET+0x00400C4,0x07FF0000
#define LPM_MEM_DP_FG_POS_ASYNC1__DP_FGYP_ASYNC1                IPU_MEMORY_OFFSET+0x00400C4,0x000007FF

#define LPM_MEM_DP_CUR_POS_ASYNC1__ADDR                         IPU_MEMORY_OFFSET+0x00400C8
#define LPM_MEM_DP_CUR_POS_ASYNC1__EMPTY                        IPU_MEMORY_OFFSET+0x00400C8,0x00000000
#define LPM_MEM_DP_CUR_POS_ASYNC1__FULL                         IPU_MEMORY_OFFSET+0x00400C8,0xffffffff
#define LPM_MEM_DP_CUR_POS_ASYNC1__DP_CXW_ASYNC1                IPU_MEMORY_OFFSET+0x00400C8,0xF8000000
#define LPM_MEM_DP_CUR_POS_ASYNC1__DP_CXP_ASYNC1                IPU_MEMORY_OFFSET+0x00400C8,0x07FF0000
#define LPM_MEM_DP_CUR_POS_ASYNC1__DP_CYH_ASYNC1                IPU_MEMORY_OFFSET+0x00400C8,0x0000F800
#define LPM_MEM_DP_CUR_POS_ASYNC1__DP_CYP_ASYNC1                IPU_MEMORY_OFFSET+0x00400C8,0x000007FF

#define LPM_MEM_DP_CUR_MAP_ASYNC1__ADDR                         IPU_MEMORY_OFFSET+0x00400CC
#define LPM_MEM_DP_CUR_MAP_ASYNC1__EMPTY                        IPU_MEMORY_OFFSET+0x00400CC,0x00000000
#define LPM_MEM_DP_CUR_MAP_ASYNC1__FULL                         IPU_MEMORY_OFFSET+0x00400CC,0xffffffff
#define LPM_MEM_DP_CUR_MAP_ASYNC1__CUR_COL_R_ASYNC1             IPU_MEMORY_OFFSET+0x00400CC,0x00FF0000
#define LPM_MEM_DP_CUR_MAP_ASYNC1__CUR_COL_G_ASYNC1             IPU_MEMORY_OFFSET+0x00400CC,0x0000FF00
#define LPM_MEM_DP_CUR_MAP_ASYNC1__CUR_COL_B_ASYNC1             IPU_MEMORY_OFFSET+0x00400CC,0x000000FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_0__ADDR                       IPU_MEMORY_OFFSET+0x00400D0
#define LPM_MEM_DP_GAMMA_C_ASYNC1_0__EMPTY                      IPU_MEMORY_OFFSET+0x00400D0,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_0__FULL                       IPU_MEMORY_OFFSET+0x00400D0,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_1        IPU_MEMORY_OFFSET+0x00400D0,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_0__DP_GAMMA_C_ASYNC1_0        IPU_MEMORY_OFFSET+0x00400D0,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_1__ADDR                       IPU_MEMORY_OFFSET+0x00400D4
#define LPM_MEM_DP_GAMMA_C_ASYNC1_1__EMPTY                      IPU_MEMORY_OFFSET+0x00400D4,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_1__FULL                       IPU_MEMORY_OFFSET+0x00400D4,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_3        IPU_MEMORY_OFFSET+0x00400D4,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_1__DP_GAMMA_C_ASYNC1_2        IPU_MEMORY_OFFSET+0x00400D4,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_2__ADDR                       IPU_MEMORY_OFFSET+0x00400D8
#define LPM_MEM_DP_GAMMA_C_ASYNC1_2__EMPTY                      IPU_MEMORY_OFFSET+0x00400D8,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_2__FULL                       IPU_MEMORY_OFFSET+0x00400D8,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_5        IPU_MEMORY_OFFSET+0x00400D8,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_2__DP_GAMMA_C_ASYNC1_4        IPU_MEMORY_OFFSET+0x00400D8,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_3__ADDR                       IPU_MEMORY_OFFSET+0x00400DC
#define LPM_MEM_DP_GAMMA_C_ASYNC1_3__EMPTY                      IPU_MEMORY_OFFSET+0x00400DC,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_3__FULL                       IPU_MEMORY_OFFSET+0x00400DC,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_7        IPU_MEMORY_OFFSET+0x00400DC,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_3__DP_GAMMA_C_ASYNC1_6        IPU_MEMORY_OFFSET+0x00400DC,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_4__ADDR                       IPU_MEMORY_OFFSET+0x00400E0
#define LPM_MEM_DP_GAMMA_C_ASYNC1_4__EMPTY                      IPU_MEMORY_OFFSET+0x00400E0,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_4__FULL                       IPU_MEMORY_OFFSET+0x00400E0,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_9        IPU_MEMORY_OFFSET+0x00400E0,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_4__DP_GAMMA_C_ASYNC1_8        IPU_MEMORY_OFFSET+0x00400E0,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_5__ADDR                       IPU_MEMORY_OFFSET+0x00400E4
#define LPM_MEM_DP_GAMMA_C_ASYNC1_5__EMPTY                      IPU_MEMORY_OFFSET+0x00400E4,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_5__FULL                       IPU_MEMORY_OFFSET+0x00400E4,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_11       IPU_MEMORY_OFFSET+0x00400E4,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_5__DP_GAMMA_C_ASYNC1_10       IPU_MEMORY_OFFSET+0x00400E4,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_6__ADDR                       IPU_MEMORY_OFFSET+0x00400E8
#define LPM_MEM_DP_GAMMA_C_ASYNC1_6__EMPTY                      IPU_MEMORY_OFFSET+0x00400E8,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_6__FULL                       IPU_MEMORY_OFFSET+0x00400E8,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_13       IPU_MEMORY_OFFSET+0x00400E8,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_6__DP_GAMMA_C_ASYNC1_12       IPU_MEMORY_OFFSET+0x00400E8,0x000001FF

#define LPM_MEM_DP_GAMMA_C_ASYNC1_7__ADDR                       IPU_MEMORY_OFFSET+0x00400EC
#define LPM_MEM_DP_GAMMA_C_ASYNC1_7__EMPTY                      IPU_MEMORY_OFFSET+0x00400EC,0x00000000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_7__FULL                       IPU_MEMORY_OFFSET+0x00400EC,0xffffffff
#define LPM_MEM_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_15       IPU_MEMORY_OFFSET+0x00400EC,0x01FF0000
#define LPM_MEM_DP_GAMMA_C_ASYNC1_7__DP_GAMMA_C_ASYNC1_14       IPU_MEMORY_OFFSET+0x00400EC,0x000001FF

#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__ADDR                       IPU_MEMORY_OFFSET+0x00400F0
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__EMPTY                      IPU_MEMORY_OFFSET+0x00400F0,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__FULL                       IPU_MEMORY_OFFSET+0x00400F0,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_3        IPU_MEMORY_OFFSET+0x00400F0,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_2        IPU_MEMORY_OFFSET+0x00400F0,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_1        IPU_MEMORY_OFFSET+0x00400F0,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC1_0__DP_GAMMA_S_ASYNC1_0        IPU_MEMORY_OFFSET+0x00400F0,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__ADDR                       IPU_MEMORY_OFFSET+0x00400F4
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__EMPTY                      IPU_MEMORY_OFFSET+0x00400F4,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__FULL                       IPU_MEMORY_OFFSET+0x00400F4,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_7        IPU_MEMORY_OFFSET+0x00400F4,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_6        IPU_MEMORY_OFFSET+0x00400F4,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_5        IPU_MEMORY_OFFSET+0x00400F4,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC1_1__DP_GAMMA_S_ASYNC1_4        IPU_MEMORY_OFFSET+0x00400F4,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__ADDR                       IPU_MEMORY_OFFSET+0x00400F8
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__EMPTY                      IPU_MEMORY_OFFSET+0x00400F8,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__FULL                       IPU_MEMORY_OFFSET+0x00400F8,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_11       IPU_MEMORY_OFFSET+0x00400F8,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_10       IPU_MEMORY_OFFSET+0x00400F8,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_9        IPU_MEMORY_OFFSET+0x00400F8,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC1_2__DP_GAMMA_S_ASYNC1_8        IPU_MEMORY_OFFSET+0x00400F8,0x000000FF

#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__ADDR                       IPU_MEMORY_OFFSET+0x00400FC
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__EMPTY                      IPU_MEMORY_OFFSET+0x00400FC,0x00000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__FULL                       IPU_MEMORY_OFFSET+0x00400FC,0xffffffff
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_15       IPU_MEMORY_OFFSET+0x00400FC,0xFF000000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_14       IPU_MEMORY_OFFSET+0x00400FC,0x00FF0000
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_13       IPU_MEMORY_OFFSET+0x00400FC,0x0000FF00
#define LPM_MEM_DP_GAMMA_S_ASYNC1_3__DP_GAMMA_S_ASYNC1_12       IPU_MEMORY_OFFSET+0x00400FC,0x000000FF

#define LPM_MEM_DP_CSCA_ASYNC1_0__ADDR                          IPU_MEMORY_OFFSET+0x0040100
#define LPM_MEM_DP_CSCA_ASYNC1_0__EMPTY                         IPU_MEMORY_OFFSET+0x0040100,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC1_0__FULL                          IPU_MEMORY_OFFSET+0x0040100,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_1             IPU_MEMORY_OFFSET+0x0040100,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC1_0__DP_CSC_A_ASYNC1_0             IPU_MEMORY_OFFSET+0x0040100,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC1_1__ADDR                          IPU_MEMORY_OFFSET+0x0040104
#define LPM_MEM_DP_CSCA_ASYNC1_1__EMPTY                         IPU_MEMORY_OFFSET+0x0040104,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC1_1__FULL                          IPU_MEMORY_OFFSET+0x0040104,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_3             IPU_MEMORY_OFFSET+0x0040104,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC1_1__DP_CSC_A_ASYNC1_2             IPU_MEMORY_OFFSET+0x0040104,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC1_2__ADDR                          IPU_MEMORY_OFFSET+0x0040108
#define LPM_MEM_DP_CSCA_ASYNC1_2__EMPTY                         IPU_MEMORY_OFFSET+0x0040108,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC1_2__FULL                          IPU_MEMORY_OFFSET+0x0040108,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_5             IPU_MEMORY_OFFSET+0x0040108,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC1_2__DP_CSC_A_ASYNC1_4             IPU_MEMORY_OFFSET+0x0040108,0x000003FF

#define LPM_MEM_DP_CSCA_ASYNC1_3__ADDR                          IPU_MEMORY_OFFSET+0x004010C
#define LPM_MEM_DP_CSCA_ASYNC1_3__EMPTY                         IPU_MEMORY_OFFSET+0x004010C,0x00000000
#define LPM_MEM_DP_CSCA_ASYNC1_3__FULL                          IPU_MEMORY_OFFSET+0x004010C,0xffffffff
#define LPM_MEM_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_7             IPU_MEMORY_OFFSET+0x004010C,0x03FF0000
#define LPM_MEM_DP_CSCA_ASYNC1_3__DP_CSC_A_ASYNC1_6             IPU_MEMORY_OFFSET+0x004010C,0x000003FF

#define LPM_MEM_DP_CSC_ASYNC1_0__ADDR                           IPU_MEMORY_OFFSET+0x0040110
#define LPM_MEM_DP_CSC_ASYNC1_0__EMPTY                          IPU_MEMORY_OFFSET+0x0040110,0x00000000
#define LPM_MEM_DP_CSC_ASYNC1_0__FULL                           IPU_MEMORY_OFFSET+0x0040110,0xffffffff
#define LPM_MEM_DP_CSC_ASYNC1_0__DP_CSC_S0_ASYNC1               IPU_MEMORY_OFFSET+0x0040110,0xC0000000
#define LPM_MEM_DP_CSC_ASYNC1_0__DP_CSC_B0_ASYNC1               IPU_MEMORY_OFFSET+0x0040110,0x3FFF0000
#define LPM_MEM_DP_CSC_ASYNC1_0__DP_CSC_A8_ASYNC1               IPU_MEMORY_OFFSET+0x0040110,0x000003FF

#define LPM_MEM_DP_CSC_ASYNC1_1__ADDR                           IPU_MEMORY_OFFSET+0x0040114
#define LPM_MEM_DP_CSC_ASYNC1_1__EMPTY                          IPU_MEMORY_OFFSET+0x0040114,0x00000000
#define LPM_MEM_DP_CSC_ASYNC1_1__FULL                           IPU_MEMORY_OFFSET+0x0040114,0xffffffff
#define LPM_MEM_DP_CSC_ASYNC1_1__DP_CSC_S2_ASYNC1               IPU_MEMORY_OFFSET+0x0040114,0xC0000000
#define LPM_MEM_DP_CSC_ASYNC1_1__DP_CSC_B2_ASYNC1               IPU_MEMORY_OFFSET+0x0040114,0x3FFF0000
#define LPM_MEM_DP_CSC_ASYNC1_1__DP_CSC_S1_ASYNC1               IPU_MEMORY_OFFSET+0x0040114,0x0000C000
#define LPM_MEM_DP_CSC_ASYNC1_1__DP_CSC_B1_ASYNC1               IPU_MEMORY_OFFSET+0x0040114,0x00003FFF

#define LPM_MEM_IC_CONF__ADDR                                   IPU_MEMORY_OFFSET+0x00409B4
#define LPM_MEM_IC_CONF__EMPTY                                  IPU_MEMORY_OFFSET+0x00409B4,0x00000000
#define LPM_MEM_IC_CONF__FULL                                   IPU_MEMORY_OFFSET+0x00409B4,0xffffffff
#define LPM_MEM_IC_CONF__CSI_MEM_WR_EN                          IPU_MEMORY_OFFSET+0x00409B4,0x80000000
#define LPM_MEM_IC_CONF__RWS_EN                                 IPU_MEMORY_OFFSET+0x00409B4,0x40000000
#define LPM_MEM_IC_CONF__IC_KEY_COLOR_EN                        IPU_MEMORY_OFFSET+0x00409B4,0x20000000
#define LPM_MEM_IC_CONF__IC_GLB_LOC_A                           IPU_MEMORY_OFFSET+0x00409B4,0x10000000
#define LPM_MEM_IC_CONF__PP_ROT_EN                              IPU_MEMORY_OFFSET+0x00409B4,0x00100000
#define LPM_MEM_IC_CONF__PP_CMB                                 IPU_MEMORY_OFFSET+0x00409B4,0x00080000
#define LPM_MEM_IC_CONF__PP_CSC2                                IPU_MEMORY_OFFSET+0x00409B4,0x00040000
#define LPM_MEM_IC_CONF__PP_CSC1                                IPU_MEMORY_OFFSET+0x00409B4,0x00020000
#define LPM_MEM_IC_CONF__PP_EN                                  IPU_MEMORY_OFFSET+0x00409B4,0x00010000
#define LPM_MEM_IC_CONF__PRPVF_ROT_EN                           IPU_MEMORY_OFFSET+0x00409B4,0x00001000
#define LPM_MEM_IC_CONF__PRPVF_CMB                              IPU_MEMORY_OFFSET+0x00409B4,0x00000800
#define LPM_MEM_IC_CONF__PRPVF_CSC2                             IPU_MEMORY_OFFSET+0x00409B4,0x00000400
#define LPM_MEM_IC_CONF__PRPVF_CSC1                             IPU_MEMORY_OFFSET+0x00409B4,0x00000200
#define LPM_MEM_IC_CONF__PRPVF_EN                               IPU_MEMORY_OFFSET+0x00409B4,0x00000100
#define LPM_MEM_IC_CONF__PRPENC_ROT_EN                          IPU_MEMORY_OFFSET+0x00409B4,0x00000004
#define LPM_MEM_IC_CONF__PRPENC_CSC1                            IPU_MEMORY_OFFSET+0x00409B4,0x00000002
#define LPM_MEM_IC_CONF__PRPENC_EN                              IPU_MEMORY_OFFSET+0x00409B4,0x00000001

#define LPM_MEM_IC_PRP_ENC_RSC__ADDR                            IPU_MEMORY_OFFSET+0x00409B8
#define LPM_MEM_IC_PRP_ENC_RSC__EMPTY                           IPU_MEMORY_OFFSET+0x00409B8,0x00000000
#define LPM_MEM_IC_PRP_ENC_RSC__FULL                            IPU_MEMORY_OFFSET+0x00409B8,0xffffffff
#define LPM_MEM_IC_PRP_ENC_RSC__PRPENC_DS_R_V                   IPU_MEMORY_OFFSET+0x00409B8,0xC0000000
#define LPM_MEM_IC_PRP_ENC_RSC__PRPENC_RS_R_V                   IPU_MEMORY_OFFSET+0x00409B8,0x3FFF0000
#define LPM_MEM_IC_PRP_ENC_RSC__PRPENC_DS_R_H                   IPU_MEMORY_OFFSET+0x00409B8,0x0000C000
#define LPM_MEM_IC_PRP_ENC_RSC__PRPENC_RS_R_H                   IPU_MEMORY_OFFSET+0x00409B8,0x00003FFF

#define LPM_MEM_IC_PRP_VF_RSC__ADDR                             IPU_MEMORY_OFFSET+0x00409BC
#define LPM_MEM_IC_PRP_VF_RSC__EMPTY                            IPU_MEMORY_OFFSET+0x00409BC,0x00000000
#define LPM_MEM_IC_PRP_VF_RSC__FULL                             IPU_MEMORY_OFFSET+0x00409BC,0xffffffff
#define LPM_MEM_IC_PRP_VF_RSC__PRPVF_DS_R_V                     IPU_MEMORY_OFFSET+0x00409BC,0xC0000000
#define LPM_MEM_IC_PRP_VF_RSC__PRPVF_RS_R_V                     IPU_MEMORY_OFFSET+0x00409BC,0x3FFF0000
#define LPM_MEM_IC_PRP_VF_RSC__PRPVF_DS_R_H                     IPU_MEMORY_OFFSET+0x00409BC,0x0000C000
#define LPM_MEM_IC_PRP_VF_RSC__PRPVF_RS_R_H                     IPU_MEMORY_OFFSET+0x00409BC,0x00003FFF

#define LPM_MEM_IC_PP_RSC__ADDR                                 IPU_MEMORY_OFFSET+0x00409C0
#define LPM_MEM_IC_PP_RSC__EMPTY                                IPU_MEMORY_OFFSET+0x00409C0,0x00000000
#define LPM_MEM_IC_PP_RSC__FULL                                 IPU_MEMORY_OFFSET+0x00409C0,0xffffffff
#define LPM_MEM_IC_PP_RSC__PP_DS_R_V                            IPU_MEMORY_OFFSET+0x00409C0,0xC0000000
#define LPM_MEM_IC_PP_RSC__PP_RS_R_V                            IPU_MEMORY_OFFSET+0x00409C0,0x3FFF0000
#define LPM_MEM_IC_PP_RSC__PP_DS_R_H                            IPU_MEMORY_OFFSET+0x00409C0,0x0000C000
#define LPM_MEM_IC_PP_RSC__PP_RS_R_H                            IPU_MEMORY_OFFSET+0x00409C0,0x00003FFF

#define LPM_MEM_IC_CMBP_1__ADDR                                 IPU_MEMORY_OFFSET+0x00409C4
#define LPM_MEM_IC_CMBP_1__EMPTY                                IPU_MEMORY_OFFSET+0x00409C4,0x00000000
#define LPM_MEM_IC_CMBP_1__FULL                                 IPU_MEMORY_OFFSET+0x00409C4,0xffffffff
#define LPM_MEM_IC_CMBP_1__IC_PP_ALPHA_V                        IPU_MEMORY_OFFSET+0x00409C4,0x0000FF00
#define LPM_MEM_IC_CMBP_1__IC_PRPVF_ALPHA_V                     IPU_MEMORY_OFFSET+0x00409C4,0x000000FF

#define LPM_MEM_IC_CMBP_2__ADDR                                 IPU_MEMORY_OFFSET+0x00409C8
#define LPM_MEM_IC_CMBP_2__EMPTY                                IPU_MEMORY_OFFSET+0x00409C8,0x00000000
#define LPM_MEM_IC_CMBP_2__FULL                                 IPU_MEMORY_OFFSET+0x00409C8,0xffffffff
#define LPM_MEM_IC_CMBP_2__IC_KEY_COLOR_R                       IPU_MEMORY_OFFSET+0x00409C8,0x00FF0000
#define LPM_MEM_IC_CMBP_2__IC_KEY_COLOR_G                       IPU_MEMORY_OFFSET+0x00409C8,0x0000FF00
#define LPM_MEM_IC_CMBP_2__IC_KEY_COLOR_B                       IPU_MEMORY_OFFSET+0x00409C8,0x000000FF

#define LPM_MEM_IC_IDMAC_1__ADDR                                IPU_MEMORY_OFFSET+0x00409CC
#define LPM_MEM_IC_IDMAC_1__EMPTY                               IPU_MEMORY_OFFSET+0x00409CC,0x00000000
#define LPM_MEM_IC_IDMAC_1__FULL                                IPU_MEMORY_OFFSET+0x00409CC,0xffffffff
#define LPM_MEM_IC_IDMAC_1__ALT_CB7_BURST_16                    IPU_MEMORY_OFFSET+0x00409CC,0x02000000
#define LPM_MEM_IC_IDMAC_1__ALT_CB6_BURST_16                    IPU_MEMORY_OFFSET+0x00409CC,0x01000000
#define LPM_MEM_IC_IDMAC_1__T3_FLIP_RS                          IPU_MEMORY_OFFSET+0x00409CC,0x00400000
#define LPM_MEM_IC_IDMAC_1__T2_FLIP_RS                          IPU_MEMORY_OFFSET+0x00409CC,0x00200000
#define LPM_MEM_IC_IDMAC_1__T1_FLIP_RS                          IPU_MEMORY_OFFSET+0x00409CC,0x00100000
#define LPM_MEM_IC_IDMAC_1__T3_FLIP_UD                          IPU_MEMORY_OFFSET+0x00409CC,0x00080000
#define LPM_MEM_IC_IDMAC_1__T3_FLIP_LR                          IPU_MEMORY_OFFSET+0x00409CC,0x00040000
#define LPM_MEM_IC_IDMAC_1__T3_ROT                              IPU_MEMORY_OFFSET+0x00409CC,0x00020000
#define LPM_MEM_IC_IDMAC_1__T2_FLIP_UD                          IPU_MEMORY_OFFSET+0x00409CC,0x00010000
#define LPM_MEM_IC_IDMAC_1__T2_FLIP_LR                          IPU_MEMORY_OFFSET+0x00409CC,0x00008000
#define LPM_MEM_IC_IDMAC_1__T2_ROT                              IPU_MEMORY_OFFSET+0x00409CC,0x00004000
#define LPM_MEM_IC_IDMAC_1__T1_FLIP_UD                          IPU_MEMORY_OFFSET+0x00409CC,0x00002000
#define LPM_MEM_IC_IDMAC_1__T1_FLIP_LR                          IPU_MEMORY_OFFSET+0x00409CC,0x00001000
#define LPM_MEM_IC_IDMAC_1__T1_ROT                              IPU_MEMORY_OFFSET+0x00409CC,0x00000800
#define LPM_MEM_IC_IDMAC_1__CB7_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000080
#define LPM_MEM_IC_IDMAC_1__CB6_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000040
#define LPM_MEM_IC_IDMAC_1__CB5_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000020
#define LPM_MEM_IC_IDMAC_1__CB4_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000010
#define LPM_MEM_IC_IDMAC_1__CB3_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000008
#define LPM_MEM_IC_IDMAC_1__CB2_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000004
#define LPM_MEM_IC_IDMAC_1__CB1_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000002
#define LPM_MEM_IC_IDMAC_1__CB0_BURST_16                        IPU_MEMORY_OFFSET+0x00409CC,0x00000001

#define LPM_MEM_IC_IDMAC_2__ADDR                                IPU_MEMORY_OFFSET+0x00409D0
#define LPM_MEM_IC_IDMAC_2__EMPTY                               IPU_MEMORY_OFFSET+0x00409D0,0x00000000
#define LPM_MEM_IC_IDMAC_2__FULL                                IPU_MEMORY_OFFSET+0x00409D0,0xffffffff
#define LPM_MEM_IC_IDMAC_2__T3_FR_HEIGHT                        IPU_MEMORY_OFFSET+0x00409D0,0x3FF00000
#define LPM_MEM_IC_IDMAC_2__T2_FR_HEIGHT                        IPU_MEMORY_OFFSET+0x00409D0,0x000FFC00
#define LPM_MEM_IC_IDMAC_2__T1_FR_HEIGHT                        IPU_MEMORY_OFFSET+0x00409D0,0x000003FF

#define LPM_MEM_IC_IDMAC_3__ADDR                                IPU_MEMORY_OFFSET+0x00409D4
#define LPM_MEM_IC_IDMAC_3__EMPTY                               IPU_MEMORY_OFFSET+0x00409D4,0x00000000
#define LPM_MEM_IC_IDMAC_3__FULL                                IPU_MEMORY_OFFSET+0x00409D4,0xffffffff
#define LPM_MEM_IC_IDMAC_3__T3_FR_WIDTH                         IPU_MEMORY_OFFSET+0x00409D4,0x3FF00000
#define LPM_MEM_IC_IDMAC_3__T2_FR_WIDTH                         IPU_MEMORY_OFFSET+0x00409D4,0x000FFC00
#define LPM_MEM_IC_IDMAC_3__T1_FR_WIDTH                         IPU_MEMORY_OFFSET+0x00409D4,0x000003FF

#define LPM_MEM_IC_IDMAC_4__ADDR                                IPU_MEMORY_OFFSET+0x00409D8
#define LPM_MEM_IC_IDMAC_4__EMPTY                               IPU_MEMORY_OFFSET+0x00409D8,0x00000000
#define LPM_MEM_IC_IDMAC_4__FULL                                IPU_MEMORY_OFFSET+0x00409D8,0xffffffff
#define LPM_MEM_IC_IDMAC_4__RM_BRDG_MAX_RQ                      IPU_MEMORY_OFFSET+0x00409D8,0x0000F000
#define LPM_MEM_IC_IDMAC_4__IBM_BRDG_MAX_RQ                     IPU_MEMORY_OFFSET+0x00409D8,0x00000F00
#define LPM_MEM_IC_IDMAC_4__MPM_DMFC_BRDG_MAX_RQ                IPU_MEMORY_OFFSET+0x00409D8,0x000000F0
#define LPM_MEM_IC_IDMAC_4__MPM_RW_BRDG_MAX_RQ                  IPU_MEMORY_OFFSET+0x00409D8,0x0000000F

#define LPM_MEM_DI0_GENERAL__ADDR                               IPU_MEMORY_OFFSET+0x0040314
#define LPM_MEM_DI0_GENERAL__EMPTY                              IPU_MEMORY_OFFSET+0x0040314,0x00000000
#define LPM_MEM_DI0_GENERAL__FULL                               IPU_MEMORY_OFFSET+0x0040314,0xffffffff
#define LPM_MEM_DI0_GENERAL__DI0_PIN8_PIN15_SEL                 IPU_MEMORY_OFFSET+0x0040314,0x80000000
#define LPM_MEM_DI0_GENERAL__DI0_DISP_Y_SEL                     IPU_MEMORY_OFFSET+0x0040314,0x70000000
#define LPM_MEM_DI0_GENERAL__DI0_CLOCK_STOP_MODE                IPU_MEMORY_OFFSET+0x0040314,0x0F000000
#define LPM_MEM_DI0_GENERAL__DI0_DISP_CLOCK_INIT                IPU_MEMORY_OFFSET+0x0040314,0x00800000
#define LPM_MEM_DI0_GENERAL__DI0_MASK_SEL                       IPU_MEMORY_OFFSET+0x0040314,0x00400000
#define LPM_MEM_DI0_GENERAL__DI0_VSYNC_EXT                      IPU_MEMORY_OFFSET+0x0040314,0x00200000
#define LPM_MEM_DI0_GENERAL__DI0_CLK_EXT                        IPU_MEMORY_OFFSET+0x0040314,0x00100000
#define LPM_MEM_DI0_GENERAL__DI0_WATCHDOG_MODE                  IPU_MEMORY_OFFSET+0x0040314,0x000C0000
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_DISP_CLK              IPU_MEMORY_OFFSET+0x0040314,0x00020000
#define LPM_MEM_DI0_GENERAL__DI0_SYNC_COUNT_SEL                 IPU_MEMORY_OFFSET+0x0040314,0x0000F000
#define LPM_MEM_DI0_GENERAL__DI0_ERR_TREATMENT                  IPU_MEMORY_OFFSET+0x0040314,0x00000800
#define LPM_MEM_DI0_GENERAL__DI0_ERM_VSYNC_SEL                  IPU_MEMORY_OFFSET+0x0040314,0x00000400
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_CS1                   IPU_MEMORY_OFFSET+0x0040314,0x00000200
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_CS0                   IPU_MEMORY_OFFSET+0x0040314,0x00000100
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_8                     IPU_MEMORY_OFFSET+0x0040314,0x00000080
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_7                     IPU_MEMORY_OFFSET+0x0040314,0x00000040
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_6                     IPU_MEMORY_OFFSET+0x0040314,0x00000020
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_5                     IPU_MEMORY_OFFSET+0x0040314,0x00000010
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_4                     IPU_MEMORY_OFFSET+0x0040314,0x00000008
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_3                     IPU_MEMORY_OFFSET+0x0040314,0x00000004
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_2                     IPU_MEMORY_OFFSET+0x0040314,0x00000002
#define LPM_MEM_DI0_GENERAL__DI0_POLARITY_1                     IPU_MEMORY_OFFSET+0x0040314,0x00000001

#define LPM_MEM_DI0_BS_CLKGEN0__ADDR                            IPU_MEMORY_OFFSET+0x0040318
#define LPM_MEM_DI0_BS_CLKGEN0__EMPTY                           IPU_MEMORY_OFFSET+0x0040318,0x00000000
#define LPM_MEM_DI0_BS_CLKGEN0__FULL                            IPU_MEMORY_OFFSET+0x0040318,0xffffffff
#define LPM_MEM_DI0_BS_CLKGEN0__DI0_DISP_CLK_OFFSET             IPU_MEMORY_OFFSET+0x0040318,0x01FF0000
#define LPM_MEM_DI0_BS_CLKGEN0__DI0_DISP_CLK_PERIOD             IPU_MEMORY_OFFSET+0x0040318,0x00000FFF

#define LPM_MEM_DI0_BS_CLKGEN1__ADDR                            IPU_MEMORY_OFFSET+0x004031C
#define LPM_MEM_DI0_BS_CLKGEN1__EMPTY                           IPU_MEMORY_OFFSET+0x004031C,0x00000000
#define LPM_MEM_DI0_BS_CLKGEN1__FULL                            IPU_MEMORY_OFFSET+0x004031C,0xffffffff
#define LPM_MEM_DI0_BS_CLKGEN1__DI0_DISP_CLK_DOWN               IPU_MEMORY_OFFSET+0x004031C,0x01FF0000
#define LPM_MEM_DI0_BS_CLKGEN1__DI0_DISP_CLK_UP                 IPU_MEMORY_OFFSET+0x004031C,0x000001FF

#define LPM_MEM_DI0_SW_GEN0_1__ADDR                             IPU_MEMORY_OFFSET+0x0040320
#define LPM_MEM_DI0_SW_GEN0_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040320,0x00000000
#define LPM_MEM_DI0_SW_GEN0_1__FULL                             IPU_MEMORY_OFFSET+0x0040320,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_1__DI0_RUN_VALUE_M1_1               IPU_MEMORY_OFFSET+0x0040320,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_1__DI0_RUN_RESOLUTION_1             IPU_MEMORY_OFFSET+0x0040320,0x00070000
#define LPM_MEM_DI0_SW_GEN0_1__DI0_OFFSET_VALUE_1               IPU_MEMORY_OFFSET+0x0040320,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_1__DI0_OFFSET_RESOLUTION_1          IPU_MEMORY_OFFSET+0x0040320,0x00000007

#define LPM_MEM_DI0_SW_GEN0_2__ADDR                             IPU_MEMORY_OFFSET+0x0040324
#define LPM_MEM_DI0_SW_GEN0_2__EMPTY                            IPU_MEMORY_OFFSET+0x0040324,0x00000000
#define LPM_MEM_DI0_SW_GEN0_2__FULL                             IPU_MEMORY_OFFSET+0x0040324,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_2__DI0_RUN_VALUE_M1_2               IPU_MEMORY_OFFSET+0x0040324,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_2__DI0_RUN_RESOLUTION_2             IPU_MEMORY_OFFSET+0x0040324,0x00070000
#define LPM_MEM_DI0_SW_GEN0_2__DI0_OFFSET_VALUE_2               IPU_MEMORY_OFFSET+0x0040324,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_2__DI0_OFFSET_RESOLUTION_2          IPU_MEMORY_OFFSET+0x0040324,0x00000007

#define LPM_MEM_DI0_SW_GEN0_3__ADDR                             IPU_MEMORY_OFFSET+0x0040328
#define LPM_MEM_DI0_SW_GEN0_3__EMPTY                            IPU_MEMORY_OFFSET+0x0040328,0x00000000
#define LPM_MEM_DI0_SW_GEN0_3__FULL                             IPU_MEMORY_OFFSET+0x0040328,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_3__DI0_RUN_VALUE_M1_3               IPU_MEMORY_OFFSET+0x0040328,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_3__DI0_RUN_RESOLUTION_3             IPU_MEMORY_OFFSET+0x0040328,0x00070000
#define LPM_MEM_DI0_SW_GEN0_3__DI0_OFFSET_VALUE_3               IPU_MEMORY_OFFSET+0x0040328,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_3__DI0_OFFSET_RESOLUTION_3          IPU_MEMORY_OFFSET+0x0040328,0x00000007

#define LPM_MEM_DI0_SW_GEN0_4__ADDR                             IPU_MEMORY_OFFSET+0x004032C
#define LPM_MEM_DI0_SW_GEN0_4__EMPTY                            IPU_MEMORY_OFFSET+0x004032C,0x00000000
#define LPM_MEM_DI0_SW_GEN0_4__FULL                             IPU_MEMORY_OFFSET+0x004032C,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_4__DI0_RUN_VALUE_M1_4               IPU_MEMORY_OFFSET+0x004032C,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_4__DI0_RUN_RESOLUTION_4             IPU_MEMORY_OFFSET+0x004032C,0x00070000
#define LPM_MEM_DI0_SW_GEN0_4__DI0_OFFSET_VALUE_4               IPU_MEMORY_OFFSET+0x004032C,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_4__DI0_OFFSET_RESOLUTION_4          IPU_MEMORY_OFFSET+0x004032C,0x00000007

#define LPM_MEM_DI0_SW_GEN0_5__ADDR                             IPU_MEMORY_OFFSET+0x0040330
#define LPM_MEM_DI0_SW_GEN0_5__EMPTY                            IPU_MEMORY_OFFSET+0x0040330,0x00000000
#define LPM_MEM_DI0_SW_GEN0_5__FULL                             IPU_MEMORY_OFFSET+0x0040330,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_5__DI0_RUN_VALUE_M1_5               IPU_MEMORY_OFFSET+0x0040330,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_5__DI0_RUN_RESOLUTION_5             IPU_MEMORY_OFFSET+0x0040330,0x00070000
#define LPM_MEM_DI0_SW_GEN0_5__DI0_OFFSET_VALUE_5               IPU_MEMORY_OFFSET+0x0040330,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_5__DI0_OFFSET_RESOLUTION_5          IPU_MEMORY_OFFSET+0x0040330,0x00000007

#define LPM_MEM_DI0_SW_GEN0_6__ADDR                             IPU_MEMORY_OFFSET+0x0040334
#define LPM_MEM_DI0_SW_GEN0_6__EMPTY                            IPU_MEMORY_OFFSET+0x0040334,0x00000000
#define LPM_MEM_DI0_SW_GEN0_6__FULL                             IPU_MEMORY_OFFSET+0x0040334,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_6__DI0_RUN_VALUE_M1_6               IPU_MEMORY_OFFSET+0x0040334,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_6__DI0_RUN_RESOLUTION_6             IPU_MEMORY_OFFSET+0x0040334,0x00070000
#define LPM_MEM_DI0_SW_GEN0_6__DI0_OFFSET_VALUE_6               IPU_MEMORY_OFFSET+0x0040334,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_6__DI0_OFFSET_RESOLUTION_6          IPU_MEMORY_OFFSET+0x0040334,0x00000007

#define LPM_MEM_DI0_SW_GEN0_7__ADDR                             IPU_MEMORY_OFFSET+0x0040338
#define LPM_MEM_DI0_SW_GEN0_7__EMPTY                            IPU_MEMORY_OFFSET+0x0040338,0x00000000
#define LPM_MEM_DI0_SW_GEN0_7__FULL                             IPU_MEMORY_OFFSET+0x0040338,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_7__DI0_RUN_VALUE_M1_7               IPU_MEMORY_OFFSET+0x0040338,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_7__DI0_RUN_RESOLUTION_7             IPU_MEMORY_OFFSET+0x0040338,0x00070000
#define LPM_MEM_DI0_SW_GEN0_7__DI0_OFFSET_VALUE_7               IPU_MEMORY_OFFSET+0x0040338,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_7__DI0_OFFSET_RESOLUTION_7          IPU_MEMORY_OFFSET+0x0040338,0x00000007

#define LPM_MEM_DI0_SW_GEN0_8__ADDR                             IPU_MEMORY_OFFSET+0x004033C
#define LPM_MEM_DI0_SW_GEN0_8__EMPTY                            IPU_MEMORY_OFFSET+0x004033C,0x00000000
#define LPM_MEM_DI0_SW_GEN0_8__FULL                             IPU_MEMORY_OFFSET+0x004033C,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_8__DI0_RUN_VALUE_M1_8               IPU_MEMORY_OFFSET+0x004033C,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_8__DI0_RUN_RESOLUTION_8             IPU_MEMORY_OFFSET+0x004033C,0x00070000
#define LPM_MEM_DI0_SW_GEN0_8__DI0_OFFSET_VALUE_8               IPU_MEMORY_OFFSET+0x004033C,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_8__DI0_OFFSET_RESOLUTION_8          IPU_MEMORY_OFFSET+0x004033C,0x00000007

#define LPM_MEM_DI0_SW_GEN0_9__ADDR                             IPU_MEMORY_OFFSET+0x0040340
#define LPM_MEM_DI0_SW_GEN0_9__EMPTY                            IPU_MEMORY_OFFSET+0x0040340,0x00000000
#define LPM_MEM_DI0_SW_GEN0_9__FULL                             IPU_MEMORY_OFFSET+0x0040340,0xffffffff
#define LPM_MEM_DI0_SW_GEN0_9__DI0_RUN_VALUE_M1_9               IPU_MEMORY_OFFSET+0x0040340,0x7FF80000
#define LPM_MEM_DI0_SW_GEN0_9__DI0_RUN_RESOLUTION_9             IPU_MEMORY_OFFSET+0x0040340,0x00070000
#define LPM_MEM_DI0_SW_GEN0_9__DI0_OFFSET_VALUE_9               IPU_MEMORY_OFFSET+0x0040340,0x00007FF8
#define LPM_MEM_DI0_SW_GEN0_9__DI0_OFFSET_RESOLUTION_9          IPU_MEMORY_OFFSET+0x0040340,0x00000007

#define LPM_MEM_DI0_SW_GEN1_1__ADDR                             IPU_MEMORY_OFFSET+0x0040344
#define LPM_MEM_DI0_SW_GEN1_1__EMPTY                            IPU_MEMORY_OFFSET+0x0040344,0x00000000
#define LPM_MEM_DI0_SW_GEN1_1__FULL                             IPU_MEMORY_OFFSET+0x0040344,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_GEN_EN_1        IPU_MEMORY_OFFSET+0x0040344,0x60000000
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_AUTO_RELOAD_1            IPU_MEMORY_OFFSET+0x0040344,0x10000000
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_CLR_SEL_1                IPU_MEMORY_OFFSET+0x0040344,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_DOWN_1                   IPU_MEMORY_OFFSET+0x0040344,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_TRIGGER_SEL_1   IPU_MEMORY_OFFSET+0x0040344,0x00007000
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_POLARITY_CLR_SEL_1       IPU_MEMORY_OFFSET+0x0040344,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_1__DI0_CNT_UP_1                     IPU_MEMORY_OFFSET+0x0040344,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_2__ADDR                             IPU_MEMORY_OFFSET+0x0040348
#define LPM_MEM_DI0_SW_GEN1_2__EMPTY                            IPU_MEMORY_OFFSET+0x0040348,0x00000000
#define LPM_MEM_DI0_SW_GEN1_2__FULL                             IPU_MEMORY_OFFSET+0x0040348,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_GEN_EN_2        IPU_MEMORY_OFFSET+0x0040348,0x60000000
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_AUTO_RELOAD_2            IPU_MEMORY_OFFSET+0x0040348,0x10000000
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_CLR_SEL_2                IPU_MEMORY_OFFSET+0x0040348,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_DOWN_2                   IPU_MEMORY_OFFSET+0x0040348,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_TRIGGER_SEL_2   IPU_MEMORY_OFFSET+0x0040348,0x00007000
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_POLARITY_CLR_SEL_2       IPU_MEMORY_OFFSET+0x0040348,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_2__DI0_CNT_UP_2                     IPU_MEMORY_OFFSET+0x0040348,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_3__ADDR                             IPU_MEMORY_OFFSET+0x004034C
#define LPM_MEM_DI0_SW_GEN1_3__EMPTY                            IPU_MEMORY_OFFSET+0x004034C,0x00000000
#define LPM_MEM_DI0_SW_GEN1_3__FULL                             IPU_MEMORY_OFFSET+0x004034C,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_GEN_EN_3        IPU_MEMORY_OFFSET+0x004034C,0x60000000
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_AUTO_RELOAD_3            IPU_MEMORY_OFFSET+0x004034C,0x10000000
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_CLR_SEL_3                IPU_MEMORY_OFFSET+0x004034C,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_DOWN_3                   IPU_MEMORY_OFFSET+0x004034C,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_TRIGGER_SEL_3   IPU_MEMORY_OFFSET+0x004034C,0x00007000
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_POLARITY_CLR_SEL_3       IPU_MEMORY_OFFSET+0x004034C,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_3__DI0_CNT_UP_3                     IPU_MEMORY_OFFSET+0x004034C,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_4__ADDR                             IPU_MEMORY_OFFSET+0x0040350
#define LPM_MEM_DI0_SW_GEN1_4__EMPTY                            IPU_MEMORY_OFFSET+0x0040350,0x00000000
#define LPM_MEM_DI0_SW_GEN1_4__FULL                             IPU_MEMORY_OFFSET+0x0040350,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_GEN_EN_4        IPU_MEMORY_OFFSET+0x0040350,0x60000000
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_AUTO_RELOAD_4            IPU_MEMORY_OFFSET+0x0040350,0x10000000
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_CLR_SEL_4                IPU_MEMORY_OFFSET+0x0040350,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_DOWN_4                   IPU_MEMORY_OFFSET+0x0040350,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_TRIGGER_SEL_4   IPU_MEMORY_OFFSET+0x0040350,0x00007000
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_POLARITY_CLR_SEL_4       IPU_MEMORY_OFFSET+0x0040350,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_4__DI0_CNT_UP_4                     IPU_MEMORY_OFFSET+0x0040350,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_5__ADDR                             IPU_MEMORY_OFFSET+0x0040354
#define LPM_MEM_DI0_SW_GEN1_5__EMPTY                            IPU_MEMORY_OFFSET+0x0040354,0x00000000
#define LPM_MEM_DI0_SW_GEN1_5__FULL                             IPU_MEMORY_OFFSET+0x0040354,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_GEN_EN_5        IPU_MEMORY_OFFSET+0x0040354,0x60000000
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_AUTO_RELOAD_5            IPU_MEMORY_OFFSET+0x0040354,0x10000000
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_CLR_SEL_5                IPU_MEMORY_OFFSET+0x0040354,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_DOWN_5                   IPU_MEMORY_OFFSET+0x0040354,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_TRIGGER_SEL_5   IPU_MEMORY_OFFSET+0x0040354,0x00007000
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_POLARITY_CLR_SEL_5       IPU_MEMORY_OFFSET+0x0040354,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_5__DI0_CNT_UP_5                     IPU_MEMORY_OFFSET+0x0040354,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_6__ADDR                             IPU_MEMORY_OFFSET+0x0040358
#define LPM_MEM_DI0_SW_GEN1_6__EMPTY                            IPU_MEMORY_OFFSET+0x0040358,0x00000000
#define LPM_MEM_DI0_SW_GEN1_6__FULL                             IPU_MEMORY_OFFSET+0x0040358,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_GEN_EN_6        IPU_MEMORY_OFFSET+0x0040358,0x60000000
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_AUTO_RELOAD_6            IPU_MEMORY_OFFSET+0x0040358,0x10000000
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_CLR_SEL_6                IPU_MEMORY_OFFSET+0x0040358,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_DOWN_6                   IPU_MEMORY_OFFSET+0x0040358,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_TRIGGER_SEL_6   IPU_MEMORY_OFFSET+0x0040358,0x00007000
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_POLARITY_CLR_SEL_6       IPU_MEMORY_OFFSET+0x0040358,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_6__DI0_CNT_UP_6                     IPU_MEMORY_OFFSET+0x0040358,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_7__ADDR                             IPU_MEMORY_OFFSET+0x004035C
#define LPM_MEM_DI0_SW_GEN1_7__EMPTY                            IPU_MEMORY_OFFSET+0x004035C,0x00000000
#define LPM_MEM_DI0_SW_GEN1_7__FULL                             IPU_MEMORY_OFFSET+0x004035C,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_GEN_EN_7        IPU_MEMORY_OFFSET+0x004035C,0x60000000
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_AUTO_RELOAD_7            IPU_MEMORY_OFFSET+0x004035C,0x10000000
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_CLR_SEL_7                IPU_MEMORY_OFFSET+0x004035C,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_DOWN_7                   IPU_MEMORY_OFFSET+0x004035C,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_TRIGGER_SEL_7   IPU_MEMORY_OFFSET+0x004035C,0x00007000
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_POLARITY_CLR_SEL_7       IPU_MEMORY_OFFSET+0x004035C,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_7__DI0_CNT_UP_7                     IPU_MEMORY_OFFSET+0x004035C,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_8__ADDR                             IPU_MEMORY_OFFSET+0x0040360
#define LPM_MEM_DI0_SW_GEN1_8__EMPTY                            IPU_MEMORY_OFFSET+0x0040360,0x00000000
#define LPM_MEM_DI0_SW_GEN1_8__FULL                             IPU_MEMORY_OFFSET+0x0040360,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_GEN_EN_8        IPU_MEMORY_OFFSET+0x0040360,0x60000000
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_AUTO_RELOAD_8            IPU_MEMORY_OFFSET+0x0040360,0x10000000
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_CLR_SEL_8                IPU_MEMORY_OFFSET+0x0040360,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_DOWN_8                   IPU_MEMORY_OFFSET+0x0040360,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_TRIGGER_SEL_8   IPU_MEMORY_OFFSET+0x0040360,0x00007000
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_POLARITY_CLR_SEL_8       IPU_MEMORY_OFFSET+0x0040360,0x00000E00
#define LPM_MEM_DI0_SW_GEN1_8__DI0_CNT_UP_8                     IPU_MEMORY_OFFSET+0x0040360,0x000001FF

#define LPM_MEM_DI0_SW_GEN1_9__ADDR                             IPU_MEMORY_OFFSET+0x0040364
#define LPM_MEM_DI0_SW_GEN1_9__EMPTY                            IPU_MEMORY_OFFSET+0x0040364,0x00000000
#define LPM_MEM_DI0_SW_GEN1_9__FULL                             IPU_MEMORY_OFFSET+0x0040364,0xffffffff
#define LPM_MEM_DI0_SW_GEN1_9__DI0_GENTIME_SEL_9                IPU_MEMORY_OFFSET+0x0040364,0xE0000000
#define LPM_MEM_DI0_SW_GEN1_9__DI0_CNT_AUTO_RELOAD_9            IPU_MEMORY_OFFSET+0x0040364,0x10000000
#define LPM_MEM_DI0_SW_GEN1_9__DI0_CNT_CLR_SEL_9                IPU_MEMORY_OFFSET+0x0040364,0x0E000000
#define LPM_MEM_DI0_SW_GEN1_9__DI0_CNT_DOWN_9                   IPU_MEMORY_OFFSET+0x0040364,0x01FF0000
#define LPM_MEM_DI0_SW_GEN1_9__DI0_TAG_SEL_9                    IPU_MEMORY_OFFSET+0x0040364,0x00008000
#define LPM_MEM_DI0_SW_GEN1_9__DI0_CNT_UP_9                     IPU_MEMORY_OFFSET+0x0040364,0x000001FF

#define LPM_MEM_DI0_SYNC_AS_GEN__ADDR                           IPU_MEMORY_OFFSET+0x0040368
#define LPM_MEM_DI0_SYNC_AS_GEN__EMPTY                          IPU_MEMORY_OFFSET+0x0040368,0x00000000
#define LPM_MEM_DI0_SYNC_AS_GEN__FULL                           IPU_MEMORY_OFFSET+0x0040368,0xffffffff
#define LPM_MEM_DI0_SYNC_AS_GEN__DI0_SYNC_START_EN              IPU_MEMORY_OFFSET+0x0040368,0x10000000
#define LPM_MEM_DI0_SYNC_AS_GEN__DI0_VSYNC_SEL                  IPU_MEMORY_OFFSET+0x0040368,0x0000E000
#define LPM_MEM_DI0_SYNC_AS_GEN__DI0_SYNC_START                 IPU_MEMORY_OFFSET+0x0040368,0x00000FFF

#define LPM_MEM_DI0_DW_GEN_0__ADDR                              IPU_MEMORY_OFFSET+0x004036C
#define LPM_MEM_DI0_DW_GEN_0__EMPTY                             IPU_MEMORY_OFFSET+0x004036C,0x00000000
#define LPM_MEM_DI0_DW_GEN_0__FULL                              IPU_MEMORY_OFFSET+0x004036C,0xffffffff
#define LPM_MEM_DI0_DW_GEN_0__DI0_ACCESS_SIZE_0                 IPU_MEMORY_OFFSET+0x004036C,0xFF000000
#define LPM_MEM_DI0_DW_GEN_0__DI0_COMPONNENT_SIZE_0             IPU_MEMORY_OFFSET+0x004036C,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_0__DI0_CST_0                         IPU_MEMORY_OFFSET+0x004036C,0x0000C000
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_6_0                        IPU_MEMORY_OFFSET+0x004036C,0x00003000
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_5_0                        IPU_MEMORY_OFFSET+0x004036C,0x00000C00
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_4_0                        IPU_MEMORY_OFFSET+0x004036C,0x00000300
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_3_0                        IPU_MEMORY_OFFSET+0x004036C,0x000000C0
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_2_0                        IPU_MEMORY_OFFSET+0x004036C,0x00000030
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_1_0                        IPU_MEMORY_OFFSET+0x004036C,0x0000000C
#define LPM_MEM_DI0_DW_GEN_0__DI0_PT_0_0                        IPU_MEMORY_OFFSET+0x004036C,0x00000003

#define LPM_MEM_DI0_DW_GEN_1__ADDR                              IPU_MEMORY_OFFSET+0x0040370
#define LPM_MEM_DI0_DW_GEN_1__EMPTY                             IPU_MEMORY_OFFSET+0x0040370,0x00000000
#define LPM_MEM_DI0_DW_GEN_1__FULL                              IPU_MEMORY_OFFSET+0x0040370,0xffffffff
#define LPM_MEM_DI0_DW_GEN_1__DI0_ACCESS_SIZE_1                 IPU_MEMORY_OFFSET+0x0040370,0xFF000000
#define LPM_MEM_DI0_DW_GEN_1__DI0_COMPONNENT_SIZE_1             IPU_MEMORY_OFFSET+0x0040370,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_1__DI0_CST_1                         IPU_MEMORY_OFFSET+0x0040370,0x0000C000
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_6_1                        IPU_MEMORY_OFFSET+0x0040370,0x00003000
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_5_1                        IPU_MEMORY_OFFSET+0x0040370,0x00000C00
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_4_1                        IPU_MEMORY_OFFSET+0x0040370,0x00000300
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_3_1                        IPU_MEMORY_OFFSET+0x0040370,0x000000C0
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_2_1                        IPU_MEMORY_OFFSET+0x0040370,0x00000030
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_1_1                        IPU_MEMORY_OFFSET+0x0040370,0x0000000C
#define LPM_MEM_DI0_DW_GEN_1__DI0_PT_0_1                        IPU_MEMORY_OFFSET+0x0040370,0x00000003

#define LPM_MEM_DI0_DW_GEN_2__ADDR                              IPU_MEMORY_OFFSET+0x0040374
#define LPM_MEM_DI0_DW_GEN_2__EMPTY                             IPU_MEMORY_OFFSET+0x0040374,0x00000000
#define LPM_MEM_DI0_DW_GEN_2__FULL                              IPU_MEMORY_OFFSET+0x0040374,0xffffffff
#define LPM_MEM_DI0_DW_GEN_2__DI0_ACCESS_SIZE_2                 IPU_MEMORY_OFFSET+0x0040374,0xFF000000
#define LPM_MEM_DI0_DW_GEN_2__DI0_COMPONNENT_SIZE_2             IPU_MEMORY_OFFSET+0x0040374,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_2__DI0_CST_2                         IPU_MEMORY_OFFSET+0x0040374,0x0000C000
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_6_2                        IPU_MEMORY_OFFSET+0x0040374,0x00003000
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_5_2                        IPU_MEMORY_OFFSET+0x0040374,0x00000C00
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_4_2                        IPU_MEMORY_OFFSET+0x0040374,0x00000300
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_3_2                        IPU_MEMORY_OFFSET+0x0040374,0x000000C0
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_2_2                        IPU_MEMORY_OFFSET+0x0040374,0x00000030
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_1_2                        IPU_MEMORY_OFFSET+0x0040374,0x0000000C
#define LPM_MEM_DI0_DW_GEN_2__DI0_PT_0_2                        IPU_MEMORY_OFFSET+0x0040374,0x00000003

#define LPM_MEM_DI0_DW_GEN_3__ADDR                              IPU_MEMORY_OFFSET+0x0040378
#define LPM_MEM_DI0_DW_GEN_3__EMPTY                             IPU_MEMORY_OFFSET+0x0040378,0x00000000
#define LPM_MEM_DI0_DW_GEN_3__FULL                              IPU_MEMORY_OFFSET+0x0040378,0xffffffff
#define LPM_MEM_DI0_DW_GEN_3__DI0_ACCESS_SIZE_3                 IPU_MEMORY_OFFSET+0x0040378,0xFF000000
#define LPM_MEM_DI0_DW_GEN_3__DI0_COMPONNENT_SIZE_3             IPU_MEMORY_OFFSET+0x0040378,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_3__DI0_CST_3                         IPU_MEMORY_OFFSET+0x0040378,0x0000C000
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_6_3                        IPU_MEMORY_OFFSET+0x0040378,0x00003000
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_5_3                        IPU_MEMORY_OFFSET+0x0040378,0x00000C00
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_4_3                        IPU_MEMORY_OFFSET+0x0040378,0x00000300
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_3_3                        IPU_MEMORY_OFFSET+0x0040378,0x000000C0
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_2_3                        IPU_MEMORY_OFFSET+0x0040378,0x00000030
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_1_3                        IPU_MEMORY_OFFSET+0x0040378,0x0000000C
#define LPM_MEM_DI0_DW_GEN_3__DI0_PT_0_3                        IPU_MEMORY_OFFSET+0x0040378,0x00000003

#define LPM_MEM_DI0_DW_GEN_4__ADDR                              IPU_MEMORY_OFFSET+0x004037C
#define LPM_MEM_DI0_DW_GEN_4__EMPTY                             IPU_MEMORY_OFFSET+0x004037C,0x00000000
#define LPM_MEM_DI0_DW_GEN_4__FULL                              IPU_MEMORY_OFFSET+0x004037C,0xffffffff
#define LPM_MEM_DI0_DW_GEN_4__DI0_ACCESS_SIZE_4                 IPU_MEMORY_OFFSET+0x004037C,0xFF000000
#define LPM_MEM_DI0_DW_GEN_4__DI0_COMPONNENT_SIZE_4             IPU_MEMORY_OFFSET+0x004037C,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_4__DI0_CST_4                         IPU_MEMORY_OFFSET+0x004037C,0x0000C000
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_6_4                        IPU_MEMORY_OFFSET+0x004037C,0x00003000
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_5_4                        IPU_MEMORY_OFFSET+0x004037C,0x00000C00
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_4_4                        IPU_MEMORY_OFFSET+0x004037C,0x00000300
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_3_4                        IPU_MEMORY_OFFSET+0x004037C,0x000000C0
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_2_4                        IPU_MEMORY_OFFSET+0x004037C,0x00000030
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_1_4                        IPU_MEMORY_OFFSET+0x004037C,0x0000000C
#define LPM_MEM_DI0_DW_GEN_4__DI0_PT_0_4                        IPU_MEMORY_OFFSET+0x004037C,0x00000003

#define LPM_MEM_DI0_DW_GEN_5__ADDR                              IPU_MEMORY_OFFSET+0x0040380
#define LPM_MEM_DI0_DW_GEN_5__EMPTY                             IPU_MEMORY_OFFSET+0x0040380,0x00000000
#define LPM_MEM_DI0_DW_GEN_5__FULL                              IPU_MEMORY_OFFSET+0x0040380,0xffffffff
#define LPM_MEM_DI0_DW_GEN_5__DI0_ACCESS_SIZE_5                 IPU_MEMORY_OFFSET+0x0040380,0xFF000000
#define LPM_MEM_DI0_DW_GEN_5__DI0_COMPONNENT_SIZE_5             IPU_MEMORY_OFFSET+0x0040380,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_5__DI0_CST_5                         IPU_MEMORY_OFFSET+0x0040380,0x0000C000
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_6_5                        IPU_MEMORY_OFFSET+0x0040380,0x00003000
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_5_5                        IPU_MEMORY_OFFSET+0x0040380,0x00000C00
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_4_5                        IPU_MEMORY_OFFSET+0x0040380,0x00000300
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_3_5                        IPU_MEMORY_OFFSET+0x0040380,0x000000C0
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_2_5                        IPU_MEMORY_OFFSET+0x0040380,0x00000030
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_1_5                        IPU_MEMORY_OFFSET+0x0040380,0x0000000C
#define LPM_MEM_DI0_DW_GEN_5__DI0_PT_0_5                        IPU_MEMORY_OFFSET+0x0040380,0x00000003

#define LPM_MEM_DI0_DW_GEN_6__ADDR                              IPU_MEMORY_OFFSET+0x0040384
#define LPM_MEM_DI0_DW_GEN_6__EMPTY                             IPU_MEMORY_OFFSET+0x0040384,0x00000000
#define LPM_MEM_DI0_DW_GEN_6__FULL                              IPU_MEMORY_OFFSET+0x0040384,0xffffffff
#define LPM_MEM_DI0_DW_GEN_6__DI0_ACCESS_SIZE_6                 IPU_MEMORY_OFFSET+0x0040384,0xFF000000
#define LPM_MEM_DI0_DW_GEN_6__DI0_COMPONNENT_SIZE_6             IPU_MEMORY_OFFSET+0x0040384,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_6__DI0_CST_6                         IPU_MEMORY_OFFSET+0x0040384,0x0000C000
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_6_6                        IPU_MEMORY_OFFSET+0x0040384,0x00003000
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_5_6                        IPU_MEMORY_OFFSET+0x0040384,0x00000C00
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_4_6                        IPU_MEMORY_OFFSET+0x0040384,0x00000300
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_3_6                        IPU_MEMORY_OFFSET+0x0040384,0x000000C0
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_2_6                        IPU_MEMORY_OFFSET+0x0040384,0x00000030
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_1_6                        IPU_MEMORY_OFFSET+0x0040384,0x0000000C
#define LPM_MEM_DI0_DW_GEN_6__DI0_PT_0_6                        IPU_MEMORY_OFFSET+0x0040384,0x00000003

#define LPM_MEM_DI0_DW_GEN_7__ADDR                              IPU_MEMORY_OFFSET+0x0040388
#define LPM_MEM_DI0_DW_GEN_7__EMPTY                             IPU_MEMORY_OFFSET+0x0040388,0x00000000
#define LPM_MEM_DI0_DW_GEN_7__FULL                              IPU_MEMORY_OFFSET+0x0040388,0xffffffff
#define LPM_MEM_DI0_DW_GEN_7__DI0_ACCESS_SIZE_7                 IPU_MEMORY_OFFSET+0x0040388,0xFF000000
#define LPM_MEM_DI0_DW_GEN_7__DI0_COMPONNENT_SIZE_7             IPU_MEMORY_OFFSET+0x0040388,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_7__DI0_CST_7                         IPU_MEMORY_OFFSET+0x0040388,0x0000C000
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_6_7                        IPU_MEMORY_OFFSET+0x0040388,0x00003000
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_5_7                        IPU_MEMORY_OFFSET+0x0040388,0x00000C00
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_4_7                        IPU_MEMORY_OFFSET+0x0040388,0x00000300
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_3_7                        IPU_MEMORY_OFFSET+0x0040388,0x000000C0
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_2_7                        IPU_MEMORY_OFFSET+0x0040388,0x00000030
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_1_7                        IPU_MEMORY_OFFSET+0x0040388,0x0000000C
#define LPM_MEM_DI0_DW_GEN_7__DI0_PT_0_7                        IPU_MEMORY_OFFSET+0x0040388,0x00000003

#define LPM_MEM_DI0_DW_GEN_8__ADDR                              IPU_MEMORY_OFFSET+0x004038C
#define LPM_MEM_DI0_DW_GEN_8__EMPTY                             IPU_MEMORY_OFFSET+0x004038C,0x00000000
#define LPM_MEM_DI0_DW_GEN_8__FULL                              IPU_MEMORY_OFFSET+0x004038C,0xffffffff
#define LPM_MEM_DI0_DW_GEN_8__DI0_ACCESS_SIZE_8                 IPU_MEMORY_OFFSET+0x004038C,0xFF000000
#define LPM_MEM_DI0_DW_GEN_8__DI0_COMPONNENT_SIZE_8             IPU_MEMORY_OFFSET+0x004038C,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_8__DI0_CST_8                         IPU_MEMORY_OFFSET+0x004038C,0x0000C000
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_6_8                        IPU_MEMORY_OFFSET+0x004038C,0x00003000
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_5_8                        IPU_MEMORY_OFFSET+0x004038C,0x00000C00
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_4_8                        IPU_MEMORY_OFFSET+0x004038C,0x00000300
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_3_8                        IPU_MEMORY_OFFSET+0x004038C,0x000000C0
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_2_8                        IPU_MEMORY_OFFSET+0x004038C,0x00000030
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_1_8                        IPU_MEMORY_OFFSET+0x004038C,0x0000000C
#define LPM_MEM_DI0_DW_GEN_8__DI0_PT_0_8                        IPU_MEMORY_OFFSET+0x004038C,0x00000003

#define LPM_MEM_DI0_DW_GEN_9__ADDR                              IPU_MEMORY_OFFSET+0x0040390
#define LPM_MEM_DI0_DW_GEN_9__EMPTY                             IPU_MEMORY_OFFSET+0x0040390,0x00000000
#define LPM_MEM_DI0_DW_GEN_9__FULL                              IPU_MEMORY_OFFSET+0x0040390,0xffffffff
#define LPM_MEM_DI0_DW_GEN_9__DI0_ACCESS_SIZE_9                 IPU_MEMORY_OFFSET+0x0040390,0xFF000000
#define LPM_MEM_DI0_DW_GEN_9__DI0_COMPONNENT_SIZE_9             IPU_MEMORY_OFFSET+0x0040390,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_9__DI0_CST_9                         IPU_MEMORY_OFFSET+0x0040390,0x0000C000
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_6_9                        IPU_MEMORY_OFFSET+0x0040390,0x00003000
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_5_9                        IPU_MEMORY_OFFSET+0x0040390,0x00000C00
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_4_9                        IPU_MEMORY_OFFSET+0x0040390,0x00000300
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_3_9                        IPU_MEMORY_OFFSET+0x0040390,0x000000C0
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_2_9                        IPU_MEMORY_OFFSET+0x0040390,0x00000030
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_1_9                        IPU_MEMORY_OFFSET+0x0040390,0x0000000C
#define LPM_MEM_DI0_DW_GEN_9__DI0_PT_0_9                        IPU_MEMORY_OFFSET+0x0040390,0x00000003

#define LPM_MEM_DI0_DW_GEN_10__ADDR                             IPU_MEMORY_OFFSET+0x0040394
#define LPM_MEM_DI0_DW_GEN_10__EMPTY                            IPU_MEMORY_OFFSET+0x0040394,0x00000000
#define LPM_MEM_DI0_DW_GEN_10__FULL                             IPU_MEMORY_OFFSET+0x0040394,0xffffffff
#define LPM_MEM_DI0_DW_GEN_10__DI0_ACCESS_SIZE_10               IPU_MEMORY_OFFSET+0x0040394,0xFF000000
#define LPM_MEM_DI0_DW_GEN_10__DI0_COMPONNENT_SIZE_10           IPU_MEMORY_OFFSET+0x0040394,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_10__DI0_CST_10                       IPU_MEMORY_OFFSET+0x0040394,0x0000C000
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_6_10                      IPU_MEMORY_OFFSET+0x0040394,0x00003000
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_5_10                      IPU_MEMORY_OFFSET+0x0040394,0x00000C00
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_4_10                      IPU_MEMORY_OFFSET+0x0040394,0x00000300
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_3_10                      IPU_MEMORY_OFFSET+0x0040394,0x000000C0
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_2_10                      IPU_MEMORY_OFFSET+0x0040394,0x00000030
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_1_10                      IPU_MEMORY_OFFSET+0x0040394,0x0000000C
#define LPM_MEM_DI0_DW_GEN_10__DI0_PT_0_10                      IPU_MEMORY_OFFSET+0x0040394,0x00000003

#define LPM_MEM_DI0_DW_GEN_11__ADDR                             IPU_MEMORY_OFFSET+0x0040398
#define LPM_MEM_DI0_DW_GEN_11__EMPTY                            IPU_MEMORY_OFFSET+0x0040398,0x00000000
#define LPM_MEM_DI0_DW_GEN_11__FULL                             IPU_MEMORY_OFFSET+0x0040398,0xffffffff
#define LPM_MEM_DI0_DW_GEN_11__DI0_ACCESS_SIZE_11               IPU_MEMORY_OFFSET+0x0040398,0xFF000000
#define LPM_MEM_DI0_DW_GEN_11__DI0_COMPONNENT_SIZE_11           IPU_MEMORY_OFFSET+0x0040398,0x00FF0000
#define LPM_MEM_DI0_DW_GEN_11__DI0_CST_11                       IPU_MEMORY_OFFSET+0x0040398,0x0000C000
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_6_11                      IPU_MEMORY_OFFSET+0x0040398,0x00003000
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_5_11                      IPU_MEMORY_OFFSET+0x0040398,0x00000C00
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_4_11                      IPU_MEMORY_OFFSET+0x0040398,0x00000300
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_3_11                      IPU_MEMORY_OFFSET+0x0040398,0x000000C0
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_2_11                      IPU_MEMORY_OFFSET+0x0040398,0x00000030
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_1_11                      IPU_MEMORY_OFFSET+0x0040398,0x0000000C
#define LPM_MEM_DI0_DW_GEN_11__DI0_PT_0_11                      IPU_MEMORY_OFFSET+0x0040398,0x00000003

#define LPM_MEM_DI0_DW_SET0_0__ADDR                             IPU_MEMORY_OFFSET+0x004039C
#define LPM_MEM_DI0_DW_SET0_0__EMPTY                            IPU_MEMORY_OFFSET+0x004039C,0x00000000
#define LPM_MEM_DI0_DW_SET0_0__FULL                             IPU_MEMORY_OFFSET+0x004039C,0xffffffff
#define LPM_MEM_DI0_DW_SET0_0__DI0_DATA_CNT_DOWN0_0             IPU_MEMORY_OFFSET+0x004039C,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_0__DI0_DATA_CNT_UP0_0               IPU_MEMORY_OFFSET+0x004039C,0x000001FF

#define LPM_MEM_DI0_DW_SET0_1__ADDR                             IPU_MEMORY_OFFSET+0x00403A0
#define LPM_MEM_DI0_DW_SET0_1__EMPTY                            IPU_MEMORY_OFFSET+0x00403A0,0x00000000
#define LPM_MEM_DI0_DW_SET0_1__FULL                             IPU_MEMORY_OFFSET+0x00403A0,0xffffffff
#define LPM_MEM_DI0_DW_SET0_1__DI0_DATA_CNT_DOWN0_1             IPU_MEMORY_OFFSET+0x00403A0,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_1__DI0_DATA_CNT_UP0_1               IPU_MEMORY_OFFSET+0x00403A0,0x000001FF

#define LPM_MEM_DI0_DW_SET0_2__ADDR                             IPU_MEMORY_OFFSET+0x00403A4
#define LPM_MEM_DI0_DW_SET0_2__EMPTY                            IPU_MEMORY_OFFSET+0x00403A4,0x00000000
#define LPM_MEM_DI0_DW_SET0_2__FULL                             IPU_MEMORY_OFFSET+0x00403A4,0xffffffff
#define LPM_MEM_DI0_DW_SET0_2__DI0_DATA_CNT_DOWN0_2             IPU_MEMORY_OFFSET+0x00403A4,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_2__DI0_DATA_CNT_UP0_2               IPU_MEMORY_OFFSET+0x00403A4,0x000001FF

#define LPM_MEM_DI0_DW_SET0_3__ADDR                             IPU_MEMORY_OFFSET+0x00403A8
#define LPM_MEM_DI0_DW_SET0_3__EMPTY                            IPU_MEMORY_OFFSET+0x00403A8,0x00000000
#define LPM_MEM_DI0_DW_SET0_3__FULL                             IPU_MEMORY_OFFSET+0x00403A8,0xffffffff
#define LPM_MEM_DI0_DW_SET0_3__DI0_DATA_CNT_DOWN0_3             IPU_MEMORY_OFFSET+0x00403A8,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_3__DI0_DATA_CNT_UP0_3               IPU_MEMORY_OFFSET+0x00403A8,0x000001FF

#define LPM_MEM_DI0_DW_SET0_4__ADDR                             IPU_MEMORY_OFFSET+0x00403AC
#define LPM_MEM_DI0_DW_SET0_4__EMPTY                            IPU_MEMORY_OFFSET+0x00403AC,0x00000000
#define LPM_MEM_DI0_DW_SET0_4__FULL                             IPU_MEMORY_OFFSET+0x00403AC,0xffffffff
#define LPM_MEM_DI0_DW_SET0_4__DI0_DATA_CNT_DOWN0_4             IPU_MEMORY_OFFSET+0x00403AC,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_4__DI0_DATA_CNT_UP0_4               IPU_MEMORY_OFFSET+0x00403AC,0x000001FF

#define LPM_MEM_DI0_DW_SET0_5__ADDR                             IPU_MEMORY_OFFSET+0x00403B0
#define LPM_MEM_DI0_DW_SET0_5__EMPTY                            IPU_MEMORY_OFFSET+0x00403B0,0x00000000
#define LPM_MEM_DI0_DW_SET0_5__FULL                             IPU_MEMORY_OFFSET+0x00403B0,0xffffffff
#define LPM_MEM_DI0_DW_SET0_5__DI0_DATA_CNT_DOWN0_5             IPU_MEMORY_OFFSET+0x00403B0,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_5__DI0_DATA_CNT_UP0_5               IPU_MEMORY_OFFSET+0x00403B0,0x000001FF

#define LPM_MEM_DI0_DW_SET0_6__ADDR                             IPU_MEMORY_OFFSET+0x00403B4
#define LPM_MEM_DI0_DW_SET0_6__EMPTY                            IPU_MEMORY_OFFSET+0x00403B4,0x00000000
#define LPM_MEM_DI0_DW_SET0_6__FULL                             IPU_MEMORY_OFFSET+0x00403B4,0xffffffff
#define LPM_MEM_DI0_DW_SET0_6__DI0_DATA_CNT_DOWN0_6             IPU_MEMORY_OFFSET+0x00403B4,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_6__DI0_DATA_CNT_UP0_6               IPU_MEMORY_OFFSET+0x00403B4,0x000001FF

#define LPM_MEM_DI0_DW_SET0_7__ADDR                             IPU_MEMORY_OFFSET+0x00403B8
#define LPM_MEM_DI0_DW_SET0_7__EMPTY                            IPU_MEMORY_OFFSET+0x00403B8,0x00000000
#define LPM_MEM_DI0_DW_SET0_7__FULL                             IPU_MEMORY_OFFSET+0x00403B8,0xffffffff
#define LPM_MEM_DI0_DW_SET0_7__DI0_DATA_CNT_DOWN0_7             IPU_MEMORY_OFFSET+0x00403B8,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_7__DI0_DATA_CNT_UP0_7               IPU_MEMORY_OFFSET+0x00403B8,0x000001FF

#define LPM_MEM_DI0_DW_SET0_8__ADDR                             IPU_MEMORY_OFFSET+0x00403BC
#define LPM_MEM_DI0_DW_SET0_8__EMPTY                            IPU_MEMORY_OFFSET+0x00403BC,0x00000000
#define LPM_MEM_DI0_DW_SET0_8__FULL                             IPU_MEMORY_OFFSET+0x00403BC,0xffffffff
#define LPM_MEM_DI0_DW_SET0_8__DI0_DATA_CNT_DOWN0_8             IPU_MEMORY_OFFSET+0x00403BC,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_8__DI0_DATA_CNT_UP0_8               IPU_MEMORY_OFFSET+0x00403BC,0x000001FF

#define LPM_MEM_DI0_DW_SET0_9__ADDR                             IPU_MEMORY_OFFSET+0x00403C0
#define LPM_MEM_DI0_DW_SET0_9__EMPTY                            IPU_MEMORY_OFFSET+0x00403C0,0x00000000
#define LPM_MEM_DI0_DW_SET0_9__FULL                             IPU_MEMORY_OFFSET+0x00403C0,0xffffffff
#define LPM_MEM_DI0_DW_SET0_9__DI0_DATA_CNT_DOWN0_9             IPU_MEMORY_OFFSET+0x00403C0,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_9__DI0_DATA_CNT_UP0_9               IPU_MEMORY_OFFSET+0x00403C0,0x000001FF

#define LPM_MEM_DI0_DW_SET0_10__ADDR                            IPU_MEMORY_OFFSET+0x00403C4
#define LPM_MEM_DI0_DW_SET0_10__EMPTY                           IPU_MEMORY_OFFSET+0x00403C4,0x00000000
#define LPM_MEM_DI0_DW_SET0_10__FULL                            IPU_MEMORY_OFFSET+0x00403C4,0xffffffff
#define LPM_MEM_DI0_DW_SET0_10__DI0_DATA_CNT_DOWN0_10           IPU_MEMORY_OFFSET+0x00403C4,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_10__DI0_DATA_CNT_UP0_10             IPU_MEMORY_OFFSET+0x00403C4,0x000001FF

#define LPM_MEM_DI0_DW_SET0_11__ADDR                            IPU_MEMORY_OFFSET+0x00403C8
#define LPM_MEM_DI0_DW_SET0_11__EMPTY                           IPU_MEMORY_OFFSET+0x00403C8,0x00000000
#define LPM_MEM_DI0_DW_SET0_11__FULL                            IPU_MEMORY_OFFSET+0x00403C8,0xffffffff
#define LPM_MEM_DI0_DW_SET0_11__DI0_DATA_CNT_DOWN0_11           IPU_MEMORY_OFFSET+0x00403C8,0x01FF0000
#define LPM_MEM_DI0_DW_SET0_11__DI0_DATA_CNT_UP0_11             IPU_MEMORY_OFFSET+0x00403C8,0x000001FF

#define LPM_MEM_DI0_DW_SET1_0__ADDR                             IPU_MEMORY_OFFSET+0x00403CC
#define LPM_MEM_DI0_DW_SET1_0__EMPTY                            IPU_MEMORY_OFFSET+0x00403CC,0x00000000
#define LPM_MEM_DI0_DW_SET1_0__FULL                             IPU_MEMORY_OFFSET+0x00403CC,0xffffffff
#define LPM_MEM_DI0_DW_SET1_0__DI0_DATA_CNT_DOWN1_0             IPU_MEMORY_OFFSET+0x00403CC,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_0__DI0_DATA_CNT_UP1_0               IPU_MEMORY_OFFSET+0x00403CC,0x000001FF

#define LPM_MEM_DI0_DW_SET1_1__ADDR                             IPU_MEMORY_OFFSET+0x00403D0
#define LPM_MEM_DI0_DW_SET1_1__EMPTY                            IPU_MEMORY_OFFSET+0x00403D0,0x00000000
#define LPM_MEM_DI0_DW_SET1_1__FULL                             IPU_MEMORY_OFFSET+0x00403D0,0xffffffff
#define LPM_MEM_DI0_DW_SET1_1__DI0_DATA_CNT_DOWN1_1             IPU_MEMORY_OFFSET+0x00403D0,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_1__DI0_DATA_CNT_UP1_1               IPU_MEMORY_OFFSET+0x00403D0,0x000001FF

#define LPM_MEM_DI0_DW_SET1_2__ADDR                             IPU_MEMORY_OFFSET+0x00403D4
#define LPM_MEM_DI0_DW_SET1_2__EMPTY                            IPU_MEMORY_OFFSET+0x00403D4,0x00000000
#define LPM_MEM_DI0_DW_SET1_2__FULL                             IPU_MEMORY_OFFSET+0x00403D4,0xffffffff
#define LPM_MEM_DI0_DW_SET1_2__DI0_DATA_CNT_DOWN1_2             IPU_MEMORY_OFFSET+0x00403D4,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_2__DI0_DATA_CNT_UP1_2               IPU_MEMORY_OFFSET+0x00403D4,0x000001FF

#define LPM_MEM_DI0_DW_SET1_3__ADDR                             IPU_MEMORY_OFFSET+0x00403D8
#define LPM_MEM_DI0_DW_SET1_3__EMPTY                            IPU_MEMORY_OFFSET+0x00403D8,0x00000000
#define LPM_MEM_DI0_DW_SET1_3__FULL                             IPU_MEMORY_OFFSET+0x00403D8,0xffffffff
#define LPM_MEM_DI0_DW_SET1_3__DI0_DATA_CNT_DOWN1_3             IPU_MEMORY_OFFSET+0x00403D8,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_3__DI0_DATA_CNT_UP1_3               IPU_MEMORY_OFFSET+0x00403D8,0x000001FF

#define LPM_MEM_DI0_DW_SET1_4__ADDR                             IPU_MEMORY_OFFSET+0x00403DC
#define LPM_MEM_DI0_DW_SET1_4__EMPTY                            IPU_MEMORY_OFFSET+0x00403DC,0x00000000
#define LPM_MEM_DI0_DW_SET1_4__FULL                             IPU_MEMORY_OFFSET+0x00403DC,0xffffffff
#define LPM_MEM_DI0_DW_SET1_4__DI0_DATA_CNT_DOWN1_4             IPU_MEMORY_OFFSET+0x00403DC,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_4__DI0_DATA_CNT_UP1_4               IPU_MEMORY_OFFSET+0x00403DC,0x000001FF

#define LPM_MEM_DI0_DW_SET1_5__ADDR                             IPU_MEMORY_OFFSET+0x00403E0
#define LPM_MEM_DI0_DW_SET1_5__EMPTY                            IPU_MEMORY_OFFSET+0x00403E0,0x00000000
#define LPM_MEM_DI0_DW_SET1_5__FULL                             IPU_MEMORY_OFFSET+0x00403E0,0xffffffff
#define LPM_MEM_DI0_DW_SET1_5__DI0_DATA_CNT_DOWN1_5             IPU_MEMORY_OFFSET+0x00403E0,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_5__DI0_DATA_CNT_UP1_5               IPU_MEMORY_OFFSET+0x00403E0,0x000001FF

#define LPM_MEM_DI0_DW_SET1_6__ADDR                             IPU_MEMORY_OFFSET+0x00403E4
#define LPM_MEM_DI0_DW_SET1_6__EMPTY                            IPU_MEMORY_OFFSET+0x00403E4,0x00000000
#define LPM_MEM_DI0_DW_SET1_6__FULL                             IPU_MEMORY_OFFSET+0x00403E4,0xffffffff
#define LPM_MEM_DI0_DW_SET1_6__DI0_DATA_CNT_DOWN1_6             IPU_MEMORY_OFFSET+0x00403E4,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_6__DI0_DATA_CNT_UP1_6               IPU_MEMORY_OFFSET+0x00403E4,0x000001FF

#define LPM_MEM_DI0_DW_SET1_7__ADDR                             IPU_MEMORY_OFFSET+0x00403E8
#define LPM_MEM_DI0_DW_SET1_7__EMPTY                            IPU_MEMORY_OFFSET+0x00403E8,0x00000000
#define LPM_MEM_DI0_DW_SET1_7__FULL                             IPU_MEMORY_OFFSET+0x00403E8,0xffffffff
#define LPM_MEM_DI0_DW_SET1_7__DI0_DATA_CNT_DOWN1_7             IPU_MEMORY_OFFSET+0x00403E8,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_7__DI0_DATA_CNT_UP1_7               IPU_MEMORY_OFFSET+0x00403E8,0x000001FF

#define LPM_MEM_DI0_DW_SET1_8__ADDR                             IPU_MEMORY_OFFSET+0x00403EC
#define LPM_MEM_DI0_DW_SET1_8__EMPTY                            IPU_MEMORY_OFFSET+0x00403EC,0x00000000
#define LPM_MEM_DI0_DW_SET1_8__FULL                             IPU_MEMORY_OFFSET+0x00403EC,0xffffffff
#define LPM_MEM_DI0_DW_SET1_8__DI0_DATA_CNT_DOWN1_8             IPU_MEMORY_OFFSET+0x00403EC,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_8__DI0_DATA_CNT_UP1_8               IPU_MEMORY_OFFSET+0x00403EC,0x000001FF

#define LPM_MEM_DI0_DW_SET1_9__ADDR                             IPU_MEMORY_OFFSET+0x00403F0
#define LPM_MEM_DI0_DW_SET1_9__EMPTY                            IPU_MEMORY_OFFSET+0x00403F0,0x00000000
#define LPM_MEM_DI0_DW_SET1_9__FULL                             IPU_MEMORY_OFFSET+0x00403F0,0xffffffff
#define LPM_MEM_DI0_DW_SET1_9__DI0_DATA_CNT_DOWN1_9             IPU_MEMORY_OFFSET+0x00403F0,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_9__DI0_DATA_CNT_UP1_9               IPU_MEMORY_OFFSET+0x00403F0,0x000001FF

#define LPM_MEM_DI0_DW_SET1_10__ADDR                            IPU_MEMORY_OFFSET+0x00403F4
#define LPM_MEM_DI0_DW_SET1_10__EMPTY                           IPU_MEMORY_OFFSET+0x00403F4,0x00000000
#define LPM_MEM_DI0_DW_SET1_10__FULL                            IPU_MEMORY_OFFSET+0x00403F4,0xffffffff
#define LPM_MEM_DI0_DW_SET1_10__DI0_DATA_CNT_DOWN1_10           IPU_MEMORY_OFFSET+0x00403F4,0x01FF0000
#define LPM_MEM_DI0_DW_SET1_10__DI0_DATA_CNT_UP1_10             IPU_MEMORY_OFFSET+0x00403F4,0x000001FF

#define LPM_MEM_DI0_DW_SET1_11__ADDR                            IPU_MEMORY_OFFSET+0x00403F8
#define LPM_MEM_DI0_DW_SET1_11__EMPTY                           IPU_MEMORY_OFFSET+0x00403F8,0x00000000
#define LPM_MEM_DI0_DW_SET1_11__FULL                            IPU_MEMORY_OFFSET+0x00403F8,0xffffffff
#define LPM_MEM_DI0_DW_SET1_11__DI0_DATA_CNT_DOWN1_11           IPU_MEMORY_OFFSET+0x00403F8,0x01FF000