/*
 * Copyright (c) 2011-2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SDMA_SCRIPT_CODE_H
#define SDMA_SCRIPT_CODE_H

/*!
* SDMA ROM scripts start addresses and sizes
*/

#define start_ADDR   0
#define start_SIZE   20

#define core_ADDR   80
#define core_SIZE   232

#define common_ADDR   312
#define common_SIZE   330

#define ap_2_ap_ADDR   642
#define ap_2_ap_SIZE   41

#define app_2_mcu_ADDR   683
#define app_2_mcu_SIZE   64

#define mcu_2_app_ADDR   747
#define mcu_2_app_SIZE   70

#define uart_2_mcu_ADDR   817
#define uart_2_mcu_SIZE   74

#define shp_2_mcu_ADDR   891
#define shp_2_mcu_SIZE   69

#define mcu_2_shp_ADDR   960
#define mcu_2_shp_SIZE   72

#define uartsh_2_mcu_ADDR   1032
#define uartsh_2_mcu_SIZE   68

#define spdif_2_mcu_ADDR   1100
#define spdif_2_mcu_SIZE   34

#define mcu_2_spdif_ADDR   1134
#define mcu_2_spdif_SIZE   59

#define loop_DMAs_routines_ADDR   1193
#define loop_DMAs_routines_SIZE   227

#define test_ADDR   1420
#define test_SIZE   63

#define signature_ADDR   1023
#define signature_SIZE   1

/*!
* SDMA RAM scripts start addresses and sizes
*/

#define dtcp__mcu_ADDR   6144
#define dtcp__mcu_SIZE   132

#define mcu_2_ssiapp_ADDR   6276
#define mcu_2_ssiapp_SIZE   98

#define mcu_2_ssish_ADDR   6374
#define mcu_2_ssish_SIZE   89

#define p_2_p_ADDR   6463
#define p_2_p_SIZE   254

#define ssiapp_2_mcu_ADDR   6717
#define ssiapp_2_mcu_SIZE   93

#define ssish_2_mcu_ADDR   6810
#define ssish_2_mcu_SIZE   84

/*!
* SDMA RAM image start address and size
*/

#define RAM_CODE_START_ADDR     6144
#define RAM_CODE_SIZE           750

/*!
* Buffer that holds the SDMA RAM image
*/

static const uint16_t sdma_code[] = {
    0x0d70, 0x0511, 0x5515, 0x5acd, 0x5ffd, 0x0b01, 0x0666, 0x7c01,
    0x0317, 0x0667, 0x7c02, 0x0317, 0x0317, 0x0668, 0x7c04, 0x0317,
    0x0317, 0x0317, 0x0317, 0x5bc5, 0x078d, 0xc13c, 0x7d63, 0xc14e,
    0x7c61, 0x1d08, 0x5ad7, 0x5bdf, 0x5ce7, 0x5def, 0x5ef7, 0x0388,
    0x0e70, 0x0611, 0x0aff, 0x0211, 0x1aff, 0x02bc, 0x0c80, 0x02d4,
    0x7c01, 0x048a, 0x02a4, 0x552e, 0x05b9, 0x4d00, 0x7c05, 0x55fe,
    0x05bb, 0x4d00, 0x7c01, 0x982b, 0x55ff, 0x50e7, 0x0078, 0x7c01,
    0x1d08, 0x6d21, 0x55f7, 0x6d05, 0x1d08, 0x5df7, 0xd87d, 0x7f1f,
    0x0808, 0x6818, 0x7c1c, 0x6d28, 0x7f1a, 0x2408, 0x7c02, 0x4a00,
    0x7d1b, 0x55ff, 0x50e7, 0x0078, 0x7d01, 0x1d08, 0x6d05, 0x55ef,
    0x6d01, 0x1d08, 0x5def, 0x0808, 0x6818, 0x7c09, 0x6d28, 0x7f07,
    0x4c00, 0x7cd1, 0x0000, 0x9826, 0x5bdf, 0x5ce7, 0x0388, 0x0007,
    0x680c, 0x54e7, 0x0454, 0x5ce7, 0x008b, 0x52d7, 0x53df, 0x54e7,
    0xc159, 0x7c10, 0xc14e, 0x7c0e, 0x5bdf, 0x52ff, 0x0378, 0x7d01,
    0x1a08, 0x6d01, 0x6a05, 0x0808, 0x6818, 0x7ce6, 0x6a28, 0x7fe4,
    0x52d7, 0x9819, 0xd87d, 0x0000, 0x9815, 0x55cf, 0x6dd2, 0x55c7,
    0x6dc8, 0x6dde, 0x0201, 0x0006, 0xc1e3, 0x57db, 0x5fe3, 0x57e3,
    0x52f3, 0x6a01, 0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0, 0x5deb,
    0x0478, 0x7d03, 0x0479, 0x7d2c, 0x7c36, 0x0479, 0x7c1f, 0x56ee,
    0x0f00, 0x0660, 0x7d05, 0x6509, 0x7e43, 0x620a, 0x7e41, 0x98a4,
    0x620a, 0x7e3e, 0x6509, 0x7e3c, 0x0512, 0x0512, 0x02ad, 0x0760,
    0x7d03, 0x55fb, 0x6dd3, 0x98af, 0x55fb, 0x1d04, 0x6dd3, 0x6ac8,
    0x7f2f, 0x1f01, 0x2003, 0x4800, 0x7ce4, 0x98d7, 0x55fb, 0x6dd7,
    0x0015, 0x7805, 0x6209, 0x6ac8, 0x6209, 0x6ac8, 0x6dd7, 0x98d6,
    0x55fb, 0x6dd7, 0x0015, 0x0015, 0x7805, 0x620a, 0x6ac8, 0x620a,
    0x6ac8, 0x6dd7, 0x98d6, 0x55fb, 0x6dd7, 0x0015, 0x0015, 0x0015,
    0x7805, 0x620b, 0x6ac8, 0x620b, 0x6ac8, 0x6dd7, 0x7c09, 0x6ddf,
    0x7f07, 0x0000, 0x55eb, 0x4d00, 0x7d07, 0xc1fa, 0x57e3, 0x988a,
    0x0007, 0x68cc, 0x680c, 0xc213, 0xc20a, 0x9887, 0xc1d9, 0xc1e3,
    0x57db, 0x5fe3, 0x57e3, 0x52f3, 0x6a21, 0x008f, 0x00d5, 0x7d01,
    0x008d, 0x05a0, 0x5deb, 0x56fb, 0x0478, 0x7d03, 0x0479, 0x7d2a,
    0x7c31, 0x0479, 0x7c20, 0x0b70, 0x0311, 0x53eb, 0x0f00, 0x0360,
    0x7d05, 0x6509, 0x7e37, 0x620a, 0x7e35, 0x990a, 0x620a, 0x7e32,
    0x6509, 0x7e30, 0x0512, 0x0512, 0x02ad, 0x0760, 0x7c02, 0x5a06,
    0x9912, 0x5a26, 0x7f27, 0x1f01, 0x2003, 0x4800, 0x7ce8, 0x0b70,
    0x0311, 0x5313, 0x9933, 0x0015, 0x7804, 0x6209, 0x5a06, 0x6209,
    0x5a26, 0x9932, 0x0015, 0x0015, 0x7804, 0x620a, 0x5a06, 0x620a,
    0x5a26, 0x9932, 0x0015, 0x0015, 0x0015, 0x7804, 0x620b, 0x5a06,
    0x620b, 0x5a26, 0x7c07, 0x0000, 0x55eb, 0x4d00, 0x7d06, 0xc1fa,
    0x57e3, 0x98ed, 0x0007, 0x680c, 0xc213, 0xc20a, 0x98ea, 0x0b70,
    0x0311, 0x5313, 0x076c, 0x7c01, 0xc1d9, 0x5efb, 0x068a, 0x076b,
    0x7c01, 0xc1d9, 0x5ef3, 0x59db, 0x58d3, 0x018f, 0x0110, 0x390f,
    0x008b, 0xc13c, 0x7d2b, 0x5ac0, 0x5bc8, 0xc14e, 0x7c27, 0x0388,
    0x0689, 0x5ce3, 0x0dff, 0x0511, 0x1dff, 0x05bc, 0x073e, 0x4d00,
    0x7d18, 0x0870, 0x0011, 0x077e, 0x7d09, 0x077d, 0x7d02, 0x5228,
    0x996a, 0x52f8, 0x54db, 0x02bc, 0x02cc, 0x7c09, 0x077c, 0x7d02,
    0x5228, 0x9973, 0x52f8, 0x54d3, 0x02bc, 0x02cc, 0x7d09, 0x0400,
    0x9961, 0x008b, 0x52c0, 0x53c8, 0xc159, 0x7dd6, 0x0200, 0x9951,
    0x08ff, 0x00bf, 0x077f, 0x7d15, 0x0488, 0x00d5, 0x7d01, 0x008d,
    0x05a0, 0x5deb, 0x028f, 0x0212, 0x0212, 0x3aff, 0x05da, 0x7c02,
    0x073e, 0x999c, 0x02a4, 0x02dd, 0x7d02, 0x073e, 0x999c, 0x075e,
    0x999c, 0x55eb, 0x0598, 0x5deb, 0x52f3, 0x54fb, 0x076a, 0x7d26,
    0x076c, 0x7d01, 0x99d9, 0x076b, 0x7c57, 0x0769, 0x7d04, 0x0768,
    0x7d02, 0x0e01, 0x99b3, 0x5893, 0x00d6, 0x7d01, 0x008e, 0x5593,
    0x05a0, 0x5d93, 0x06a0, 0x7802, 0x5502, 0x5d04, 0x7c1d, 0x4e00,
    0x7c08, 0x0769, 0x7d03, 0x5502, 0x7e17, 0x99c0, 0x5d04, 0x7f14,
    0x0689, 0x5093, 0x4800, 0x7d01, 0x99ab, 0x9a24, 0x0015, 0x7806,
    0x5502, 0x5d04, 0x074f, 0x5502, 0x5d24, 0x072f, 0x7c01, 0x9a24,
    0x0017, 0x076f, 0x7c01, 0x2001, 0x5593, 0x009d, 0x0007, 0xda2b,
    0x9979, 0x6cd3, 0x0769, 0x7d04, 0x0768, 0x7d02, 0x0e01, 0x99e8,
    0x5893, 0x00d6, 0x7d01, 0x008e, 0x5593, 0x05a0, 0x5d93, 0x06a0,
    0x7802, 0x5502, 0x6dc8, 0x7c0f, 0x4e00, 0x7c08, 0x0769, 0x7d03,
    0x5502, 0x7e09, 0x99f5, 0x6dc8, 0x7f06, 0x0689, 0x5093, 0x4800,
    0x7d01, 0x99e0, 0x9a24, 0x9a1e, 0x6ac3, 0x0769, 0x7d04, 0x0768,
    0x7d02, 0x0e01, 0x9a0b, 0x5893, 0x00d6, 0x7d01, 0x008e, 0x5593,
    0x05a0, 0x5d93, 0x06a0, 0x7802, 0x65c8, 0x5d04, 0x7c0f, 0x4e00,
    0x7c08, 0x0769, 0x7d03, 0x65c8, 0x7e09, 0x9a18, 0x5d04, 0x7f06,
    0x0689, 0x5093, 0x4800, 0x7d01, 0x9a03, 0x9a24, 0x5593, 0x009d,
    0x0007, 0x6cff, 0xda2b, 0x9979, 0x0000, 0x54e3, 0x55eb, 0x4d00,
    0x7c01, 0x9979, 0x9961, 0x54e3, 0x55eb, 0x0aff, 0x0211, 0x1aff,
    0x077f, 0x7c02, 0x05a0, 0x9a38, 0x009d, 0x058c, 0x05ba, 0x05a0,
    0x0210, 0x04ba, 0x04ad, 0x0454, 0x0006, 0xc1e3, 0x57db, 0x52fb,
    0x6ac3, 0x52f3, 0x6a05, 0x008f, 0x00d5, 0x7d01, 0x008d, 0x05a0,
    0x5deb, 0x0478, 0x7d03, 0x0479, 0x7d2b, 0x7c1e, 0x0479, 0x7c33,
    0x56ee, 0x0f00, 0x55fb, 0x0760, 0x7d02, 0x6dc3, 0x9a59, 0x1d04,
    0x6dc3, 0x62c8, 0x7e3b, 0x0660, 0x7d02, 0x0210, 0x0212, 0x6a09,
    0x7f35, 0x0212, 0x6a09, 0x7f32, 0x0212, 0x6a09, 0x7f2f, 0x1f01,
    0x2003, 0x4800, 0x7ce7, 0x9a8d, 0x55fb, 0x6dc7, 0x0015, 0x0015,
    0x0015, 0x7805, 0x62c8, 0x6a0b, 0x62c8, 0x6a0b, 0x6dc7, 0x9a8c,
    0x55fb, 0x6dc7, 0x0015, 0x0015, 0x7805, 0x62c8, 0x6a0a, 0x62c8,
    0x6a0a, 0x6dc7, 0x9a8c, 0x55fb, 0x6dc7, 0x0015, 0x7805, 0x62c8,
    0x6a09, 0x62c8, 0x6a09, 0x6dc7, 0x7c09, 0x6a28, 0x7f07, 0x0000,
    0x55eb, 0x4d00, 0x7d05, 0xc1fa, 0x57db, 0x9a43, 0xc277, 0x0454,
    0xc20a, 0x9a3e, 0xc1d9, 0xc1e3, 0x57db, 0x52f3, 0x6a05, 0x008f,
    0x00d5, 0x7d01, 0x008d, 0x05a0, 0x56fb, 0x0478, 0x7d03, 0x0479,
    0x7d29, 0x7c1f, 0x0479, 0x7c2e, 0x5de3, 0x0d70, 0x0511, 0x55ed,
    0x0f00, 0x0760, 0x7d02, 0x5206, 0x9ab6, 0x5226, 0x7e33, 0x0560,
    0x7d02, 0x0210, 0x0212, 0x6a09, 0x7f2d, 0x0212, 0x6a09, 0x7f2a,
    0x0212, 0x6a09, 0x7f27, 0x1f01, 0x2003, 0x4800, 0x7cea, 0x55e3,
    0x9ae1, 0x0015, 0x0015, 0x0015, 0x7804, 0x5206, 0x6a0b, 0x5226,
    0x6a0b, 0x9ae0, 0x0015, 0x0015, 0x7804, 0x5206, 0x6a0a, 0x5226,
    0x6a0a, 0x9ae0, 0x0015, 0x7804, 0x5206, 0x6a09, 0x5226, 0x6a09,
    0x7c09, 0x6a28, 0x7f07, 0x0000, 0x57db, 0x4d00, 0x7d05, 0xc1fa,
    0x57db, 0x9a9f, 0xc277, 0x0454, 0xc20a, 0x9a9c
};
#endif
