/*
 * Copyright (c) 2011-2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * @file init_dma_data.c
 * @brief Init DMA data.
 *
 * @ingroup diag_hdmi
 */

//#include <stdio.h>
//#include <string.h>
//#include <stdlib.h>
//#include <stdint.h>
//#include <stdbool.h>
//#include "common.h"
#include "sdk.h"

/*binary data for a small audio sample.*/

const unsigned char gAudio_sample[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85, 0x83, 0x85,
    0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0x93, 0x95, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE, 0xCD, 0xAE,
    0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x05, 0xCF, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3, 0x75, 0xF3,
    0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C, 0x56, 0x3C,
    0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0x82, 0x5A, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70, 0xE2, 0x70,
    0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x8A, 0x7D, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F, 0x62, 0x7F,
    0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0x41, 0x76, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62, 0xF2, 0x62,
    0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x1C, 0x47, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25, 0x28, 0x25,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A, 0x7D, 0x7A,
    0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x6D, 0x6A, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51, 0x33, 0x51,
    0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0xFB, 0x30, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C, 0x8B, 0x0C,
    0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0x08, 0xE7, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3, 0xAA, 0xC3,
    0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x7E, 0xA5, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F, 0x1E, 0x8F,
    0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x76, 0x82, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80, 0x9E, 0x80,
    0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0xBF, 0x89, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D, 0x0E, 0x9D,
    0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xE4, 0xB8, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA, 0xD8, 0xDA,
};

typedef union {
    uint64_t U;
    struct {
        unsigned comsumer:1;
        unsigned linear_pcm:1;
        unsigned copyright:1;
        unsigned pre_emphasis:3;
        unsigned mode:2;

        unsigned category_code:8;

        unsigned source:4;
        unsigned channel:4;

        unsigned sample_freq:4;
        unsigned clock_acc:2;
        unsigned reserved0:2;

        unsigned word_length:4;
        unsigned org_sample_freq:4;

        unsigned cgms_a:2;
        unsigned reserved1:6;
        unsigned reserved2:8;
        unsigned reserved3:8;
    } B;
} hdmi_audio_header_t;

typedef union {
    uint32_t U;
    struct {
        unsigned data:24;
        unsigned v:1;
        unsigned u:1;
        unsigned c:1;
        unsigned p:1;
        unsigned b:1;
    } B;
} hdmi_audio_dma_data_t;

int init_dma_data(int sample_rate, int ch)
{
    //static FILE *fpPCM;
    //int fs;
    int frame_idx, subframe_idx, addr_cur;
    int i;
    int data_ptr;
    //int len=sizeof(gAudio_sample)/sizeof(unsigned char);

    hdmi_audio_header_t hdmi_audio_header;
    hdmi_audio_dma_data_t hdmi_audio_dma_data;
    uint16_t pcm_data;

    // sample_16bit_32k_4ch.pcm from file hdmi_audio_sample.c
    // with data (unsigned char*) array:  gAudio_sample[] 

    hdmi_audio_header.U = 0;
    hdmi_audio_header.B.comsumer = 0;   // Consumer use
    hdmi_audio_header.B.linear_pcm = 0; // linear
    hdmi_audio_header.B.copyright = 1;  // Software for which no copyright is asserted
    hdmi_audio_header.B.pre_emphasis = 0;   // 2 audio channels without pre-emphasis
    hdmi_audio_header.B.mode = 0;   // Mode 0

    hdmi_audio_header.B.category_code = 0;

    hdmi_audio_header.B.source = 0;
    hdmi_audio_header.B.channel = 0;

    hdmi_audio_header.B.sample_freq = 0;
    hdmi_audio_header.B.clock_acc = 0;  // Level II

    hdmi_audio_header.B.word_length = 0x02; // 16 bit
    hdmi_audio_header.B.org_sample_freq = 0;

    hdmi_audio_header.B.cgms_a = 0; // Copying is permitted without restriction

    switch (ch) {
    case 2:
        hdmi_audio_header.B.source = 2;
        break;
    case 4:
        hdmi_audio_header.B.source = 4;
        break;
    case 6:
        hdmi_audio_header.B.source = 6;
        break;
    case 8:
        hdmi_audio_header.B.source = 8;
        break;
    default:
        printf("channel infomation error");
        break;
    }
    switch (sample_rate) {
    case 32000:
        hdmi_audio_header.B.sample_freq = 0x03;
        hdmi_audio_header.B.org_sample_freq = 0x0C;
        break;
    case 44100:
        hdmi_audio_header.B.sample_freq = 0x00;
        hdmi_audio_header.B.org_sample_freq = 0x0F;
        break;
    case 48000:
        hdmi_audio_header.B.sample_freq = 0x02;
        hdmi_audio_header.B.org_sample_freq = 0x0D;
        break;
    case 96000:
        hdmi_audio_header.B.sample_freq = 0x0A;
        hdmi_audio_header.B.org_sample_freq = 0x05;
        break;
    case 192000:
        hdmi_audio_header.B.sample_freq = 0x0E;
        hdmi_audio_header.B.org_sample_freq = 0x01;
        break;
    default:
        printf("sample rate infomation error");
        break;
    }

    frame_idx = 0;
    //0x4000
    addr_cur = HDMI_AUDIO_BUF_START;
    data_ptr = 0;
    while (addr_cur != HDMI_AUDIO_BUF_END) {
        for (subframe_idx = 1; subframe_idx <= ch; subframe_idx++) {
            hdmi_audio_dma_data.U = 0;
            //fread(&pcm_data,2,1,fpPCM);
            pcm_data = 0;
            pcm_data = (uint16_t) ((gAudio_sample[data_ptr + 1] << 8) | gAudio_sample[data_ptr]);
            data_ptr += 2;

            hdmi_audio_dma_data.U = 0;
            hdmi_audio_header.B.channel = subframe_idx;
            // fill b
            hdmi_audio_dma_data.B.b = (frame_idx == 0) ? 1 : 0;
            // fill c
            if (frame_idx < 42)
                hdmi_audio_dma_data.B.c = (hdmi_audio_header.U >> frame_idx) & 0x1;
            else
                hdmi_audio_dma_data.B.c = 0;
            // fill p
            for (i = 0; i < 16; i++)
                hdmi_audio_dma_data.B.p ^= (pcm_data >> i) & 0x01;
            //hdmi_audio_dma_data.B.p ^= hdmi_audio_dma_data.B.b;
            hdmi_audio_dma_data.B.p ^= hdmi_audio_dma_data.B.c;
            hdmi_audio_dma_data.B.p ^= hdmi_audio_dma_data.B.u;
            hdmi_audio_dma_data.B.p ^= hdmi_audio_dma_data.B.v;
            // fill data
            hdmi_audio_dma_data.B.data = pcm_data << 8;
            writel(hdmi_audio_dma_data.U, addr_cur);    //mem32_write(addr_cur, hdmi_audio_dma_data.U);
            addr_cur += 4;
        }
        frame_idx++;
        if (frame_idx == 192)
            frame_idx = 0;
    }
    return 0;
}
