/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*!
 * @file camera_profile.c
 * @brief common registers of camera.
 * @ingroup diag_camera
 */

#include "camera/camera_def.h"

reg_param_t g_ov3640_sensor_detection[] = {
    {0x300a, 0x36, 0, 0, 0}
    ,
    {0x300b, 0x4C, 0, 0, 0}
    ,
};

reg_param_t g_ov5640_sensor_detection[] = {
    {0x300a, 0x56, 0, 0, 0}
    ,
    {0x300b, 0x40, 0, 0, 0}
    ,
};

reg_param_t g_ov5642_sensor_detection[] = {
    {0x300a, 0x56, 0, 0, 0}
    ,
    {0x300b, 0x42, 0, 0, 0}
    ,
};

reg_param_t g_mt9p111_sensor_detection[] = {
    {0x0010, 0x0028, 1, 0, 0}
    ,
};

reg_param_t g_ov3640_mode_vga_640_480_30fps[] = {
    {0x3012, 0x80, 0, 0, 0}
    ,
    {0x304d, 0x45, 0, 0, 0}
    ,
    {0x30a7, 0x5e, 0, 0, 0}
    ,
    {0x3087, 0x16, 0, 0, 0}
    ,
    {0x309c, 0x1a, 0, 0, 0}
    ,
    {0x30a2, 0xe4, 0, 0, 0}
    ,
    {0x30aa, 0x42, 0, 0, 0}
    ,
    {0x30b0, 0xff, 0, 0, 0}
    ,
    {0x30b1, 0xff, 0, 0, 0}
    ,
    {0x30b2, 0x10, 0, 0, 0}
    ,
    {0x300e, 0x32, 0, 0, 0}
    ,
    {0x300f, 0x21, 0, 0, 0}
    ,
    {0x3010, 0x20, 0, 0, 0}
    ,
    {0x3011, 0x01, 0, 0, 0}
    ,
    {0x304c, 0x82, 0, 0, 0}
    ,
    {0x30d7, 0x10, 0, 0, 0}
    ,
    {0x30d9, 0x0d, 0, 0, 0}
    ,
    {0x30db, 0x08, 0, 0, 0}
    ,
    {0x3016, 0x82, 0, 0, 0}
    ,
    {0x3018, 0x38, 0, 0, 0}
    ,
    {0x3019, 0x30, 0, 0, 0}
    ,
    {0x301a, 0x61, 0, 0, 0}
    ,
    {0x307d, 0x00, 0, 0, 0}
    ,
    {0x3087, 0x02, 0, 0, 0}
    ,
    {0x3082, 0x20, 0, 0, 0}
    ,
    {0x3015, 0x12, 0, 0, 0}
    ,
    {0x3014, 0x0c, 0, 0, 0}
    ,
    {0x3013, 0xf7, 0, 0, 0}
    ,
    {0x303c, 0x08, 0, 0, 0}
    ,
    {0x303d, 0x18, 0, 0, 0}
    ,
    {0x303e, 0x06, 0, 0, 0}
    ,
    {0x303f, 0x0c, 0, 0, 0}
    ,
    {0x3030, 0x62, 0, 0, 0}
    ,
    {0x3031, 0x26, 0, 0, 0}
    ,
    {0x3032, 0xe6, 0, 0, 0}
    ,
    {0x3033, 0x6e, 0, 0, 0}
    ,
    {0x3034, 0xea, 0, 0, 0}
    ,
    {0x3035, 0xae, 0, 0, 0}
    ,
    {0x3036, 0xa6, 0, 0, 0}
    ,
    {0x3037, 0x6a, 0, 0, 0}
    ,
    {0x3104, 0x02, 0, 0, 0}
    ,
    {0x3105, 0xfd, 0, 0, 0}
    ,
    {0x3106, 0x00, 0, 0, 0}
    ,
    {0x3107, 0xff, 0, 0, 0}
    ,
    {0x3300, 0x12, 0, 0, 0}
    ,
    {0x3301, 0xde, 0, 0, 0}
    ,
    {0x3302, 0xcf, 0, 0, 0}
    ,
    {0x3312, 0x26, 0, 0, 0}
    ,
    {0x3314, 0x42, 0, 0, 0}
    ,
    {0x3313, 0x2b, 0, 0, 0}
    ,
    {0x3315, 0x42, 0, 0, 0}
    ,
    {0x3310, 0xd0, 0, 0, 0}
    ,
    {0x3311, 0xbd, 0, 0, 0}
    ,
    {0x330c, 0x18, 0, 0, 0}
    ,
    {0x330d, 0x18, 0, 0, 0}
    ,
    {0x330e, 0x56, 0, 0, 0}
    ,
    {0x330f, 0x5c, 0, 0, 0}
    ,
    {0x330b, 0x1c, 0, 0, 0}
    ,
    {0x3306, 0x5c, 0, 0, 0}
    ,
    {0x3307, 0x11, 0, 0, 0}
    ,
    {0x336a, 0x52, 0, 0, 0}
    ,
    {0x3370, 0x46, 0, 0, 0}
    ,
    {0x3376, 0x38, 0, 0, 0}
    ,
    {0x3300, 0x13, 0, 0, 0}
    ,
    {0x30b8, 0x20, 0, 0, 0}
    ,
    {0x30b9, 0x17, 0, 0, 0}
    ,
    {0x30ba, 0x04, 0, 0, 0}
    ,
    {0x30bb, 0x08, 0, 0, 0}
    ,
    {0x3100, 0x02, 0, 0, 0}
    ,
    {0x3301, 0x10, 0, 0, 0}
    ,
    {0x3304, 0x00, 0, 0, 0}
    ,
    {0x3400, 0x00, 0, 0, 0}
    ,
    {0x3404, 0x00, 0, 0, 0}
    ,
    {0x3600, 0xc0, 0, 0, 0}
    ,
    {0x308d, 0x04, 0, 0, 0}
    ,
    {0x3086, 0x03, 0, 0, 0}
    ,
    {0x3086, 0x00, 0, 0, 0}
    ,
    {0x3012, 0x10, 0, 0, 0}
    ,
    {0x3023, 0x06, 0, 0, 0}
    ,
    {0x3026, 0x03, 0, 0, 0}
    ,
    {0x3027, 0x04, 0, 0, 0}
    ,
    {0x302a, 0x03, 0, 0, 0}
    ,
    {0x302b, 0x10, 0, 0, 0}
    ,
    {0x3075, 0x24, 0, 0, 0}
    ,
    {0x300d, 0x01, 0, 0, 0}
    ,
    {0x30d7, 0x80, 0, 0, 0}
    ,
    {0x3069, 0x00, 0, 0, 0}
    ,
    {0x303e, 0x00, 0, 0, 0}
    ,
    {0x303f, 0xc0, 0, 0, 0}
    ,
    {0x3302, 0x20, 0, 0, 0}
    ,
    {0x335f, 0x34, 0, 0, 0}
    ,
    {0x3360, 0x0c, 0, 0, 0}
    ,
    {0x3361, 0x04, 0, 0, 0}
    ,
    {0x3362, 0x12, 0, 0, 0}
    ,
    {0x3363, 0x88, 0, 0, 0}
    ,
    {0x3364, 0xe4, 0, 0, 0}
    ,
    {0x3403, 0x42, 0, 0, 0}
    ,
    {0x3088, 0x02, 0, 0, 0}
    ,
    {0x3089, 0x80, 0, 0, 0}
    ,
    {0x308a, 0x01, 0, 0, 0}
    ,
    {0x308b, 0xe0, 0, 0, 0}
    ,
    {0x3362, 0x12, 0, 0, 0}
    ,
    {0x3363, 0x88, 0, 0, 0}
    ,
    {0x3364, 0xe4, 0, 0, 0}
    ,
    {0x3403, 0x42, 0, 0, 0}
    ,
    {0x3088, 0x02, 0, 0, 0}
    ,
    {0x3089, 0x80, 0, 0, 0}
    ,
    {0x308a, 0x01, 0, 0, 0}
    ,
    {0x308b, 0xe0, 0, 0, 0}
    ,
    {0x300e, 0x37, 0, 0, 0}
    ,
    {0x300f, 0xe1, 0, 0, 0}
    ,
    {0x3010, 0x22, 0, 0, 0}
    ,
    {0x3011, 0x01, 0, 0, 0}
    ,
    {0x304c, 0x84, 0, 0, 0}
    ,
    {0x3014, 0x04, 0, 0, 0}
    ,
    {0x3015, 0x02, 0, 0, 0}
    ,
    {0x302e, 0x00, 0, 0, 0}
    ,
    {0x302d, 0x00, 0, 0, 0}
};

reg_param_t g_ov5640_mode_vga_640_480_30fps[] = {
    {0x3103, 0x11, 0, 0, 0}
    ,
    {0x3008, 0x82, 0, 0, 0}
    ,
    {0x3008, 0x42, 0, 0, 0}
    ,
    {0x3103, 0x03, 0, 0, 0}
    ,
    {0x3017, 0xff, 0, 0, 0}
    ,
    {0x3018, 0xff, 0, 0, 0}
    ,
    {0x3034, 0x1a, 0, 0, 0}
    ,
    {0x3035, 0x11, 0, 0, 0}
    ,
    {0x3036, 0x46, 0, 0, 0}
    ,
    {0x3037, 0x13, 0, 0, 0}
    ,
    {0x3108, 0x01, 0, 0, 0}
    ,
    {0x3630, 0x2e, 0, 0, 0}
    ,
    {0x3632, 0xe2, 0, 0, 0}
    ,
    {0x3633, 0x23, 0, 0, 0}
    ,
    {0x3621, 0xe0, 0, 0, 0}
    ,
    {0x3704, 0xa0, 0, 0, 0}
    ,
    {0x3703, 0x5a, 0, 0, 0}
    ,
    {0x3715, 0x78, 0, 0, 0}
    ,
    {0x3717, 0x01, 0, 0, 0}
    ,
    {0x370b, 0x60, 0, 0, 0}
    ,
    {0x3705, 0x1a, 0, 0, 0}
    ,
    {0x3905, 0x02, 0, 0, 0}
    ,
    {0x3906, 0x10, 0, 0, 0}
    ,
    {0x3901, 0x0a, 0, 0, 0}
    ,
    {0x3731, 0x12, 0, 0, 0}
    ,
    {0x3600, 0x08, 0, 0, 0}
    ,
    {0x3601, 0x33, 0, 0, 0}
    ,
    {0x302d, 0x60, 0, 0, 0}
    ,
    {0x3620, 0x52, 0, 0, 0}
    ,
    {0x371b, 0x20, 0, 0, 0}
    ,
    {0x471c, 0x50, 0, 0, 0}
    ,
    {0x3a18, 0x00, 0, 0, 0}
    ,
    {0x3a19, 0xf8, 0, 0, 0}
    ,
    {0x3635, 0x1c, 0, 0, 0}
    ,
    {0x3634, 0x40, 0, 0, 0}
    ,
    {0x3622, 0x01, 0, 0, 0}
    ,
    {0x3c01, 0x34, 0, 0, 0}
    ,
    {0x3c04, 0x28, 0, 0, 0}
    ,
    {0x3c05, 0x98, 0, 0, 0}
    ,
    {0x3c06, 0x00, 0, 0, 0}
    ,
    {0x3c07, 0x08, 0, 0, 0}
    ,
    {0x3c08, 0x00, 0, 0, 0}
    ,
    {0x3c09, 0x1c, 0, 0, 0}
    ,
    {0x3c0a, 0x9c, 0, 0, 0}
    ,
    {0x3c0b, 0x40, 0, 0, 0}
    ,
    {0x3820, 0x41, 0, 0, 0}
    ,
    {0x3821, 0x07, 0, 0, 0}
    ,
    {0x3814, 0x31, 0, 0, 0}
    ,
    {0x3815, 0x31, 0, 0, 0}
    ,
    {0x3800, 0x00, 0, 0, 0}
    ,
    {0x3801, 0x00, 0, 0, 0}
    ,
    {0x3802, 0x00, 0, 0, 0}
    ,
    {0x3803, 0x04, 0, 0, 0}
    ,
    {0x3804, 0x0a, 0, 0, 0}
    ,
    {0x3805, 0x3f, 0, 0, 0}
    ,
    {0x3806, 0x07, 0, 0, 0}
    ,
    {0x3807, 0x9b, 0, 0, 0}
    ,
    {0x3808, 0x02, 0, 0, 0}
    ,
    {0x3809, 0x80, 0, 0, 0}
    ,
    {0x380a, 0x01, 0, 0, 0}
    ,
    {0x380b, 0xe0, 0, 0, 0}
    ,
    {0x380c, 0x07, 0, 0, 0}
    ,
    {0x380d, 0x68, 0, 0, 0}
    ,
    {0x380e, 0x03, 0, 0, 0}
    ,
    {0x380f, 0xd8, 0, 0, 0}
    ,
    {0x3810, 0x00, 0, 0, 0}
    ,
    {0x3811, 0x10, 0, 0, 0}
    ,
    {0x3812, 0x00, 0, 0, 0}
    ,
    {0x3813, 0x06, 0, 0, 0}
    ,
    {0x3618, 0x00, 0, 0, 0}
    ,
    {0x3612, 0x29, 0, 0, 0}
    ,
    {0x3708, 0x62, 0, 0, 0}
    ,
    {0x3709, 0x52, 0, 0, 0}
    ,
    {0x370c, 0x03, 0, 0, 0}
    ,
    {0x3a02, 0x03, 0, 0, 0}
    ,
    {0x3a03, 0xd8, 0, 0, 0}
    ,
    {0x3a08, 0x01, 0, 0, 0}
    ,
    {0x3a09, 0x27, 0, 0, 0}
    ,
    {0x3a0a, 0x00, 0, 0, 0}
    ,
    {0x3a0b, 0xf6, 0, 0, 0}
    ,
    {0x3a0e, 0x03, 0, 0, 0}
    ,
    {0x3a0d, 0x04, 0, 0, 0}
    ,
    {0x3a14, 0x03, 0, 0, 0}
    ,
    {0x3a15, 0xd8, 0, 0, 0}
    ,
    {0x4001, 0x02, 0, 0, 0}
    ,
    {0x4004, 0x02, 0, 0, 0}
    ,
    {0x3000, 0x00, 0, 0, 0}
    ,
    {0x3002, 0x1c, 0, 0, 0}
    ,
    {0x3004, 0xff, 0, 0, 0}
    ,
    {0x3006, 0xc3, 0, 0, 0}
    ,
    {0x300e, 0x58, 0, 0, 0}
    ,
    {0x302e, 0x00, 0, 0, 0}
    ,
    {0x4300, 0x30, 0, 0, 0}
    ,
    {0x501f, 0x00, 0, 0, 0}
    ,
    {0x4713, 0x03, 0, 0, 0}
    ,
    {0x4407, 0x04, 0, 0, 0}
    ,
    {0x460b, 0x35, 0, 0, 0}
    ,
    {0x460c, 0x22, 0, 0, 0}
    ,
    {0x3824, 0x02, 0, 0, 0}
    ,
    {0x5000, 0xa7, 0, 0, 0}
    ,
    {0x5001, 0xa3, 0, 0, 0}
    ,
    {0x5180, 0xff, 0, 0, 0}
    ,
    {0x5181, 0xf2, 0, 0, 0}
    ,
    {0x5182, 0x00, 0, 0, 0}
    ,
    {0x5183, 0x14, 0, 0, 0}
    ,
    {0x5184, 0x25, 0, 0, 0}
    ,
    {0x5185, 0x24, 0, 0, 0}
    ,
    {0x5186, 0x09, 0, 0, 0}
    ,
    {0x5187, 0x09, 0, 0, 0}
    ,
    {0x5188, 0x09, 0, 0, 0}
    ,
    {0x5189, 0x75, 0, 0, 0}
    ,
    {0x518a, 0x54, 0, 0, 0}
    ,
    {0x518b, 0xe0, 0, 0, 0}
    ,
    {0x518c, 0xb2, 0, 0, 0}
    ,
    {0x518d, 0x42, 0, 0, 0}
    ,
    {0x518e, 0x3d, 0, 0, 0}
    ,
    {0x518f, 0x56, 0, 0, 0}
    ,
    {0x5190, 0x46, 0, 0, 0}
    ,
    {0x5191, 0xf8, 0, 0, 0}
    ,
    {0x5192, 0x04, 0, 0, 0}
    ,
    {0x5193, 0x70, 0, 0, 0}
    ,
    {0x5194, 0xf0, 0, 0, 0}
    ,
    {0x5195, 0xf0, 0, 0, 0}
    ,
    {0x5196, 0x03, 0, 0, 0}
    ,
    {0x5197, 0x01, 0, 0, 0}
    ,
    {0x5198, 0x04, 0, 0, 0}
    ,
    {0x5199, 0x12, 0, 0, 0}
    ,
    {0x519a, 0x04, 0, 0, 0}
    ,
    {0x519b, 0x00, 0, 0, 0}
    ,
    {0x519c, 0x06, 0, 0, 0}
    ,
    {0x519d, 0x82, 0, 0, 0}
    ,
    {0x519e, 0x38, 0, 0, 0}
    ,
    {0x5381, 0x1c, 0, 0, 0}
    ,
    {0x5382, 0x5a, 0, 0, 0}
    ,
    {0x5383, 0x06, 0, 0, 0}
    ,
    {0x5384, 0x0a, 0, 0, 0}
    ,
    {0x5385, 0x7e, 0, 0, 0}
    ,
    {0x5386, 0x88, 0, 0, 0}
    ,
    {0x5387, 0x7c, 0, 0, 0}
    ,
    {0x5388, 0x6c, 0, 0, 0}
    ,
    {0x5389, 0x10, 0, 0, 0}
    ,
    {0x538a, 0x01, 0, 0, 0}
    ,
    {0x538b, 0x98, 0, 0, 0}
    ,
    {0x5300, 0x08, 0, 0, 0}
    ,
    {0x5301, 0x30, 0, 0, 0}
    ,
    {0x5302, 0x10, 0, 0, 0}
    ,
    {0x5303, 0x00, 0, 0, 0}
    ,
    {0x5304, 0x08, 0, 0, 0}
    ,
    {0x5305, 0x30, 0, 0, 0}
    ,
    {0x5306, 0x08, 0, 0, 0}
    ,
    {0x5307, 0x16, 0, 0, 0}
    ,
    {0x5309, 0x08, 0, 0, 0}
    ,
    {0x530a, 0x30, 0, 0, 0}
    ,
    {0x530b, 0x04, 0, 0, 0}
    ,
    {0x530c, 0x06, 0, 0, 0}
    ,
    {0x5480, 0x01, 0, 0, 0}
    ,
    {0x5481, 0x08, 0, 0, 0}
    ,
    {0x5482, 0x14, 0, 0, 0}
    ,
    {0x5483, 0x28, 0, 0, 0}
    ,
    {0x5484, 0x51, 0, 0, 0}
    ,
    {0x5485, 0x65, 0, 0, 0}
    ,
    {0x5486, 0x71, 0, 0, 0}
    ,
    {0x5487, 0x7d, 0, 0, 0}
    ,
    {0x5488, 0x87, 0, 0, 0}
    ,
    {0x5489, 0x91, 0, 0, 0}
    ,
    {0x548a, 0x9a, 0, 0, 0}
    ,
    {0x548b, 0xaa, 0, 0, 0}
    ,
    {0x548c, 0xb8, 0, 0, 0}
    ,
    {0x548d, 0xcd, 0, 0, 0}
    ,
    {0x548e, 0xdd, 0, 0, 0}
    ,
    {0x548f, 0xea, 0, 0, 0}
    ,
    {0x5490, 0x1d, 0, 0, 0}
    ,
    {0x5580, 0x02, 0, 0, 0}
    ,
    {0x5583, 0x40, 0, 0, 0}
    ,
    {0x5584, 0x10, 0, 0, 0}
    ,
    {0x5589, 0x10, 0, 0, 0}
    ,
    {0x558a, 0x00, 0, 0, 0}
    ,
    {0x558b, 0xf8, 0, 0, 0}
    ,
    {0x5800, 0x23, 0, 0, 0}
    ,
    {0x5801, 0x15, 0, 0, 0}
    ,
    {0x5802, 0x10, 0, 0, 0}
    ,
    {0x5803, 0x10, 0, 0, 0}
    ,
    {0x5804, 0x15, 0, 0, 0}
    ,
    {0x5805, 0x23, 0, 0, 0}
    ,
    {0x5806, 0x0c, 0, 0, 0}
    ,
    {0x5807, 0x08, 0, 0, 0}
    ,
    {0x5808, 0x05, 0, 0, 0}
    ,
    {0x5809, 0x05, 0, 0, 0}
    ,
    {0x580a, 0x08, 0, 0, 0}
    ,
    {0x580b, 0x0c, 0, 0, 0}
    ,
    {0x580c, 0x07, 0, 0, 0}
    ,
    {0x580d, 0x03, 0, 0, 0}
    ,
    {0x580e, 0x00, 0, 0, 0}
    ,
    {0x580f, 0x00, 0, 0, 0}
    ,
    {0x5810, 0x03, 0, 0, 0}
    ,
    {0x5811, 0x07, 0, 0, 0}
    ,
    {0x5812, 0x07, 0, 0, 0}
    ,
    {0x5813, 0x03, 0, 0, 0}
    ,
    {0x5814, 0x00, 0, 0, 0}
    ,
    {0x5815, 0x00, 0, 0, 0}
    ,
    {0x5816, 0x03, 0, 0, 0}
    ,
    {0x5817, 0x07, 0, 0, 0}
    ,
    {0x5818, 0x0b, 0, 0, 0}
    ,
    {0x5819, 0x08, 0, 0, 0}
    ,
    {0x581a, 0x05, 0, 0, 0}
    ,
    {0x581b, 0x05, 0, 0, 0}
    ,
    {0x581c, 0x07, 0, 0, 0}
    ,
    {0x581d, 0x0b, 0, 0, 0}
    ,
    {0x581e, 0x2a, 0, 0, 0}
    ,
    {0x581f, 0x16, 0, 0, 0}
    ,
    {0x5820, 0x11, 0, 0, 0}
    ,
    {0x5821, 0x11, 0, 0, 0}
    ,
    {0x5822, 0x15, 0, 0, 0}
    ,
    {0x5823, 0x29, 0, 0, 0}
    ,
    {0x5824, 0xbf, 0, 0, 0}
    ,
    {0x5825, 0xaf, 0, 0, 0}
    ,
    {0x5826, 0x9f, 0, 0, 0}
    ,
    {0x5827, 0xaf, 0, 0, 0}
    ,
    {0x5828, 0xdf, 0, 0, 0}
    ,
    {0x5829, 0x6f, 0, 0, 0}
    ,
    {0x582a, 0x8e, 0, 0, 0}
    ,
    {0x582b, 0xab, 0, 0, 0}
    ,
    {0x582c, 0x9e, 0, 0, 0}
    ,
    {0x582d, 0x7f, 0, 0, 0}
    ,
    {0x582e, 0x4f, 0, 0, 0}
    ,
    {0x582f, 0x89, 0, 0, 0}
    ,
    {0x5830, 0x86, 0, 0, 0}
    ,
    {0x5831, 0x98, 0, 0, 0}
    ,
    {0x5832, 0x6f, 0, 0, 0}
    ,
    {0x5833, 0x4f, 0, 0, 0}
    ,
    {0x5834, 0x6e, 0, 0, 0}
    ,
    {0x5835, 0x7b, 0, 0, 0}
    ,
    {0x5836, 0x7e, 0, 0, 0}
    ,
    {0x5837, 0x6f, 0, 0, 0}
    ,
    {0x5838, 0xde, 0, 0, 0}
    ,
    {0x5839, 0xbf, 0, 0, 0}
    ,
    {0x583a, 0x9f, 0, 0, 0}
    ,
    {0x583b, 0xbf, 0, 0, 0}
    ,
    {0x583c, 0xec, 0, 0, 0}
    ,
    {0x5025, 0x00, 0, 0, 0}
    ,
    {0x3a0f, 0x30, 0, 0, 0}
    ,
    {0x3a10, 0x28, 0, 0, 0}
    ,
    {0x3a1b, 0x30, 0, 0, 0}
    ,
    {0x3a1e, 0x26, 0, 0, 0}
    ,
    {0x3a11, 0x60, 0, 0, 0}
    ,
    {0x3a1f, 0x14, 0, 0, 0}
    ,
    {0x3008, 0x02, 0, 0, 0}
    ,
    {0x3035, 0x11, 0, 0, 0}
};

reg_param_t g_ov5642_mode_vga_640_480_30fps[] = {
    {0x3103, 0x93, 0, 0, 0}
    ,
    {0x3008, 0x82, 0, 0, 0}
    ,
    {0x3017, 0x7f, 0, 0, 0}
    ,
    {0x3018, 0xfc, 0, 0, 0}
    ,
    {0x3615, 0xf0, 0, 0, 0}
    ,
    {0x3000, 0x00, 0, 0, 0}
    ,
    {0x3001, 0x00, 0, 0, 0}
    ,
    {0x3002, 0x5c, 0, 0, 0}
    ,
    {0x3003, 0x00, 0, 0, 0}
    ,
    {0x3004, 0xff, 0, 0, 0}
    ,
    {0x3005, 0xff, 0, 0, 0}
    ,
    {0x3006, 0x43, 0, 0, 0}
    ,
    {0x3007, 0x37, 0, 0, 0}
    ,
    {0x3011, 0x09, 0, 0, 0}
    ,
    {0x3012, 0x02, 0, 0, 0}
    ,
    {0x3010, 0x00, 0, 0, 0}
    ,
    {0x460c, 0x20, 0, 0, 0}
    ,
    {0x3815, 0x04, 0, 0, 0}
    ,
    {0x370c, 0xa0, 0, 0, 0}
    ,
    {0x3602, 0xfc, 0, 0, 0}
    ,
    {0x3612, 0xff, 0, 0, 0}
    ,
    {0x3634, 0xc0, 0, 0, 0}
    ,
    {0x3613, 0x00, 0, 0, 0}
    ,
    {0x3605, 0x7c, 0, 0, 0}
    ,
    {0x3621, 0x09, 0, 0, 0}
    ,
    {0x3622, 0x60, 0, 0, 0}
    ,
    {0x3604, 0x40, 0, 0, 0}
    ,
    {0x3603, 0xa7, 0, 0, 0}
    ,
    {0x3603, 0x27, 0, 0, 0}
    ,
    {0x4000, 0x21, 0, 0, 0}
    ,
    {0x401d, 0x22, 0, 0, 0}
    ,
    {0x3600, 0x54, 0, 0, 0}
    ,
    {0x3605, 0x04, 0, 0, 0}
    ,
    {0x3606, 0x3f, 0, 0, 0}
    ,
    {0x3c01, 0x80, 0, 0, 0}
    ,
    {0x5000, 0x4f, 0, 0, 0}
    ,
    {0x5020, 0x04, 0, 0, 0}
    ,
    {0x5181, 0x79, 0, 0, 0}
    ,
    {0x5182, 0x00, 0, 0, 0}
    ,
    {0x5185, 0x22, 0, 0, 0}
    ,
    {0x5197, 0x01, 0, 0, 0}
    ,
    {0x5001, 0xff, 0, 0, 0}
    ,
    {0x5500, 0x0a, 0, 0, 0}
    ,
    {0x5504, 0x00, 0, 0, 0}
    ,
    {0x5505, 0x7f, 0, 0, 0}
    ,
    {0x5080, 0x08, 0, 0, 0}
    ,
    {0x300e, 0x18, 0, 0, 0}
    ,
    {0x4610, 0x00, 0, 0, 0}
    ,
    {0x471d, 0x05, 0, 0, 0}
    ,
    {0x4708, 0x06, 0, 0, 0}
    ,
    {0x3808, 0x02, 0, 0, 0}
    ,
    {0x3809, 0x80, 0, 0, 0}
    ,
    {0x380a, 0x01, 0, 0, 0}
    ,
    {0x380b, 0xe0, 0, 0, 0}
    ,
    {0x380e, 0x07, 0, 0, 0}
    ,
    {0x380f, 0xd0, 0, 0, 0}
    ,
    {0x501f, 0x00, 0, 0, 0}
    ,
    {0x5000, 0x4f, 0, 0, 0}
    ,
    {0x4300, 0x30, 0, 0, 0}
    ,
    {0x3503, 0x07, 0, 0, 0}
    ,
    {0x3501, 0x73, 0, 0, 0}
    ,
    {0x3502, 0x80, 0, 0, 0}
    ,
    {0x350b, 0x00, 0, 0, 0}
    ,
    {0x3503, 0x07, 0, 0, 0}
    ,
    {0x3824, 0x11, 0, 0, 0}
    ,
    {0x3825, 0xb0, 0, 0, 0}
    ,
    {0x3501, 0x1e, 0, 0, 0}
    ,
    {0x3502, 0x80, 0, 0, 0}
    ,
    {0x350b, 0x7f, 0, 0, 0}
    ,
    {0x380c, 0x07, 0, 0, 0}
    ,
    {0x380d, 0x2a, 0, 0, 0}
    ,
    {0x380e, 0x03, 0, 0, 0}
    ,
    {0x380f, 0xe8, 0, 0, 0}
    ,
    {0x3a0d, 0x04, 0, 0, 0}
    ,
    {0x3a0e, 0x03, 0, 0, 0}
    ,
    {0x3818, 0xc1, 0, 0, 0}
    ,
    {0x3705, 0xdb, 0, 0, 0}
    ,
    {0x370a, 0x81, 0, 0, 0}
    ,
    {0x3801, 0x80, 0, 0, 0}
    ,
    {0x3621, 0xc7, 0, 0, 0}
    ,
    {0x3801, 0x50, 0, 0, 0}
    ,
    {0x3803, 0x08, 0, 0, 0}
    ,
    {0x3827, 0x08, 0, 0, 0}
    ,
    {0x3810, 0x80, 0, 0, 0}
    ,
    {0x3804, 0x05, 0, 0, 0}
    ,
    {0x3805, 0x00, 0, 0, 0}
    ,
    {0x5682, 0x05, 0, 0, 0}
    ,
    {0x5683, 0x00, 0, 0, 0}
    ,
    {0x3806, 0x03, 0, 0, 0}
    ,
    {0x3807, 0xc0, 0, 0, 0}
    ,
    {0x5686, 0x03, 0, 0, 0}
    ,
    {0x5687, 0xbc, 0, 0, 0}
    ,
    {0x3a00, 0x78, 0, 0, 0}
    ,
    {0x3a1a, 0x05, 0, 0, 0}
    ,
    {0x3a13, 0x30, 0, 0, 0}
    ,
    {0x3a18, 0x00, 0, 0, 0}
    ,
    {0x3a19, 0x7c, 0, 0, 0}
    ,
    {0x3a08, 0x12, 0, 0, 0}
    ,
    {0x3a09, 0xc0, 0, 0, 0}
    ,
    {0x3a0a, 0x0f, 0, 0, 0}
    ,
    {0x3a0b, 0xa0, 0, 0, 0}
    ,
    {0x350c, 0x07, 0, 0, 0}
    ,
    {0x350d, 0xd0, 0, 0, 0}
    ,
    {0x3500, 0x00, 0, 0, 0}
    ,
    {0x3501, 0x00, 0, 0, 0}
    ,
    {0x3502, 0x00, 0, 0, 0}
    ,
    {0x350a, 0x00, 0, 0, 0}
    ,
    {0x350b, 0x00, 0, 0, 0}
    ,
    {0x3503, 0x00, 0, 0, 0}
    ,
    {0x528a, 0x02, 0, 0, 0}
    ,
    {0x528b, 0x04, 0, 0, 0}
    ,
    {0x528c, 0x08, 0, 0, 0}
    ,
    {0x528d, 0x08, 0, 0, 0}
    ,
    {0x528e, 0x08, 0, 0, 0}
    ,
    {0x528f, 0x10, 0, 0, 0}
    ,
    {0x5290, 0x10, 0, 0, 0}
    ,
    {0x5292, 0x00, 0, 0, 0}
    ,
    {0x5293, 0x02, 0, 0, 0}
    ,
    {0x5294, 0x00, 0, 0, 0}
    ,
    {0x5295, 0x02, 0, 0, 0}
    ,
    {0x5296, 0x00, 0, 0, 0}
    ,
    {0x5297, 0x02, 0, 0, 0}
    ,
    {0x5298, 0x00, 0, 0, 0}
    ,
    {0x5299, 0x02, 0, 0, 0}
    ,
    {0x529a, 0x00, 0, 0, 0}
    ,
    {0x529b, 0x02, 0, 0, 0}
    ,
    {0x529c, 0x00, 0, 0, 0}
    ,
    {0x529d, 0x02, 0, 0, 0}
    ,
    {0x529e, 0x00, 0, 0, 0}
    ,
    {0x529f, 0x02, 0, 0, 0}
    ,
    {0x3a0f, 0x3c, 0, 0, 0}
    ,
    {0x3a10, 0x30, 0, 0, 0}
    ,
    {0x3a1b, 0x3c, 0, 0, 0}
    ,
    {0x3a1e, 0x30, 0, 0, 0}
    ,
    {0x3a11, 0x70, 0, 0, 0}
    ,
    {0x3a1f, 0x10, 0, 0, 0}
    ,
    {0x3030, 0x2b, 0, 0, 0}
    ,
    {0x3a02, 0x00, 0, 0, 0}
    ,
    {0x3a03, 0x7d, 0, 0, 0}
    ,
    {0x3a04, 0x00, 0, 0, 0}
    ,
    {0x3a14, 0x00, 0, 0, 0}
    ,
    {0x3a15, 0x7d, 0, 0, 0}
    ,
    {0x3a16, 0x00, 0, 0, 0}
    ,
    {0x3a00, 0x78, 0, 0, 0}
    ,
    {0x3a08, 0x12, 0, 0, 0}
    ,
    {0x3a09, 0xc0, 0, 0, 0}
    ,
    {0x3a0a, 0x0f, 0, 0, 0}
    ,
    {0x3a0b, 0xa0, 0, 0, 0}
    ,
    {0x3a0d, 0x04, 0, 0, 0}
    ,
    {0x3a0e, 0x03, 0, 0, 0}
    ,
    {0x5193, 0x70, 0, 0, 0}
    ,
    {0x589b, 0x04, 0, 0, 0}
    ,
    {0x589a, 0xc5, 0, 0, 0}
    ,
    {0x401e, 0x20, 0, 0, 0}
    ,
    {0x4001, 0x42, 0, 0, 0}
    ,
    {0x401c, 0x04, 0, 0, 0}
    ,
    {0x528a, 0x01, 0, 0, 0}
    ,
    {0x528b, 0x04, 0, 0, 0}
    ,
    {0x528c, 0x08, 0, 0, 0}
    ,
    {0x528d, 0x10, 0, 0, 0}
    ,
    {0x528e, 0x20, 0, 0, 0}
    ,
    {0x528f, 0x28, 0, 0, 0}
    ,
    {0x5290, 0x30, 0, 0, 0}
    ,
    {0x5292, 0x00, 0, 0, 0}
    ,
    {0x5293, 0x01, 0, 0, 0}
    ,
    {0x5294, 0x00, 0, 0, 0}
    ,
    {0x5295, 0x04, 0, 0, 0}
    ,
    {0x5296, 0x00, 0, 0, 0}
    ,
    {0x5297, 0x08, 0, 0, 0}
    ,
    {0x5298, 0x00, 0, 0, 0}
    ,
    {0x5299, 0x10, 0, 0, 0}
    ,
    {0x529a, 0x00, 0, 0, 0}
    ,
    {0x529b, 0x20, 0, 0, 0}
    ,
    {0x529c, 0x00, 0, 0, 0}
    ,
    {0x529d, 0x28, 0, 0, 0}
    ,
    {0x529e, 0x00, 0, 0, 0}
    ,
    {0x529f, 0x30, 0, 0, 0}
    ,
    {0x5282, 0x00, 0, 0, 0}
    ,
    {0x5300, 0x00, 0, 0, 0}
    ,
    {0x5301, 0x20, 0, 0, 0}
    ,
    {0x5302, 0x00, 0, 0, 0}
    ,
    {0x5303, 0x7c, 0, 0, 0}
    ,
    {0x530c, 0x00, 0, 0, 0}
    ,
    {0x530d, 0x0c, 0, 0, 0}
    ,
    {0x530e, 0x20, 0, 0, 0}
    ,
    {0x530f, 0x80, 0, 0, 0}
    ,
    {0x5310, 0x20, 0, 0, 0}
    ,
    {0x5311, 0x80, 0, 0, 0}
    ,
    {0x5308, 0x20, 0, 0, 0}
    ,
    {0x5309, 0x40, 0, 0, 0}
    ,
    {0x5304, 0x00, 0, 0, 0}
    ,
    {0x5305, 0x30, 0, 0, 0}
    ,
    {0x5306, 0x00, 0, 0, 0}
    ,
    {0x5307, 0x80, 0, 0, 0}
    ,
    {0x5314, 0x08, 0, 0, 0}
    ,
    {0x5315, 0x20, 0, 0, 0}
    ,
    {0x5319, 0x30, 0, 0, 0}
    ,
    {0x5316, 0x10, 0, 0, 0}
    ,
    {0x5317, 0x00, 0, 0, 0}
    ,
    {0x5318, 0x02, 0, 0, 0}
    ,
    {0x5380, 0x01, 0, 0, 0}
    ,
    {0x5381, 0x00, 0, 0, 0}
    ,
    {0x5382, 0x00, 0, 0, 0}
    ,
    {0x5383, 0x4e, 0, 0, 0}
    ,
    {0x5384, 0x00, 0, 0, 0}
    ,
    {0x5385, 0x0f, 0, 0, 0}
    ,
    {0x5386, 0x00, 0, 0, 0}
    ,
    {0x5387, 0x00, 0, 0, 0}
    ,
    {0x5388, 0x01, 0, 0, 0}
    ,
    {0x5389, 0x15, 0, 0, 0}
    ,
    {0x538a, 0x00, 0, 0, 0}
    ,
    {0x538b, 0x31, 0, 0, 0}
    ,
    {0x538c, 0x00, 0, 0, 0}
    ,
    {0x538d, 0x00, 0, 0, 0}
    ,
    {0x538e, 0x00, 0, 0, 0}
    ,
    {0x538f, 0x0f, 0, 0, 0}
    ,
    {0x5390, 0x00, 0, 0, 0}
    ,
    {0x5391, 0xab, 0, 0, 0}
    ,
    {0x5392, 0x00, 0, 0, 0}
    ,
    {0x5393, 0xa2, 0, 0, 0}
    ,
    {0x5394, 0x08, 0, 0, 0}
    ,
    {0x5480, 0x14, 0, 0, 0}
    ,
    {0x5481, 0x21, 0, 0, 0}
    ,
    {0x5482, 0x36, 0, 0, 0}
    ,
    {0x5483, 0x57, 0, 0, 0}
    ,
    {0x5484, 0x65, 0, 0, 0}
    ,
    {0x5485, 0x71, 0, 0, 0}
    ,
    {0x5486, 0x7d, 0, 0, 0}
    ,
    {0x5487, 0x87, 0, 0, 0}
    ,
    {0x5488, 0x91, 0, 0, 0}
    ,
    {0x5489, 0x9a, 0, 0, 0}
    ,
    {0x548a, 0xaa, 0, 0, 0}
    ,
    {0x548b, 0xb8, 0, 0, 0}
    ,
    {0x548c, 0xcd, 0, 0, 0}
    ,
    {0x548d, 0xdd, 0, 0, 0}
    ,
    {0x548e, 0xea, 0, 0, 0}
    ,
    {0x548f, 0x1d, 0, 0, 0}
    ,
    {0x5490, 0x05, 0, 0, 0}
    ,
    {0x5491, 0x00, 0, 0, 0}
    ,
    {0x5492, 0x04, 0, 0, 0}
    ,
    {0x5493, 0x20, 0, 0, 0}
    ,
    {0x5494, 0x03, 0, 0, 0}
    ,
    {0x5495, 0x60, 0, 0, 0}
    ,
    {0x5496, 0x02, 0, 0, 0}
    ,
    {0x5497, 0xb8, 0, 0, 0}
    ,
    {0x5498, 0x02, 0, 0, 0}
    ,
    {0x5499, 0x86, 0, 0, 0}
    ,
    {0x549a, 0x02, 0, 0, 0}
    ,
    {0x549b, 0x5b, 0, 0, 0}
    ,
    {0x549c, 0x02, 0, 0, 0}
    ,
    {0x549d, 0x3b, 0, 0, 0}
    ,
    {0x549e, 0x02, 0, 0, 0}
    ,
    {0x549f, 0x1c, 0, 0, 0}
    ,
    {0x54a0, 0x02, 0, 0, 0}
    ,
    {0x54a1, 0x04, 0, 0, 0}
    ,
    {0x54a2, 0x01, 0, 0, 0}
    ,
    {0x54a3, 0xed, 0, 0, 0}
    ,
    {0x54a4, 0x01, 0, 0, 0}
    ,
    {0x54a5, 0xc5, 0, 0, 0}
    ,
    {0x54a6, 0x01, 0, 0, 0}
    ,
    {0x54a7, 0xa5, 0, 0, 0}
    ,
    {0x54a8, 0x01, 0, 0, 0}
    ,
    {0x54a9, 0x6c, 0, 0, 0}
    ,
    {0x54aa, 0x01, 0, 0, 0}
    ,
    {0x54ab, 0x41, 0, 0, 0}
    ,
    {0x54ac, 0x01, 0, 0, 0}
    ,
    {0x54ad, 0x20, 0, 0, 0}
    ,
    {0x54ae, 0x00, 0, 0, 0}
    ,
    {0x54af, 0x16, 0, 0, 0}
    ,
    {0x54b0, 0x01, 0, 0, 0}
    ,
    {0x54b1, 0x20, 0, 0, 0}
    ,
    {0x54b2, 0x00, 0, 0, 0}
    ,
    {0x54b3, 0x10, 0, 0, 0}
    ,
    {0x54b4, 0x00, 0, 0, 0}
    ,
    {0x54b5, 0xf0, 0, 0, 0}
    ,
    {0x54b6, 0x00, 0, 0, 0}
    ,
    {0x54b7, 0xdf, 0, 0, 0}
    ,
    {0x5402, 0x3f, 0, 0, 0}
    ,
    {0x5403, 0x00, 0, 0, 0}
    ,
    {0x3406, 0x00, 0, 0, 0}
    ,
    {0x5180, 0xff, 0, 0, 0}
    ,
    {0x5181, 0x52, 0, 0, 0}
    ,
    {0x5182, 0x11, 0, 0, 0}
    ,
    {0x5183, 0x14, 0, 0, 0}
    ,
    {0x5184, 0x25, 0, 0, 0}
    ,
    {0x5185, 0x24, 0, 0, 0}
    ,
    {0x5186, 0x06, 0, 0, 0}
    ,
    {0x5187, 0x08, 0, 0, 0}
    ,
    {0x5188, 0x08, 0, 0, 0}
    ,
    {0x5189, 0x7c, 0, 0, 0}
    ,
    {0x518a, 0x60, 0, 0, 0}
    ,
    {0x518b, 0xb2, 0, 0, 0}
    ,
    {0x518c, 0xb2, 0, 0, 0}
    ,
    {0x518d, 0x44, 0, 0, 0}
    ,
    {0x518e, 0x3d, 0, 0, 0}
    ,
    {0x518f, 0x58, 0, 0, 0}
    ,
    {0x5190, 0x46, 0, 0, 0}
    ,
    {0x5191, 0xf8, 0, 0, 0}
    ,
    {0x5192, 0x04, 0, 0, 0}
    ,
    {0x5193, 0x70, 0, 0, 0}
    ,
    {0x5194, 0xf0, 0, 0, 0}
    ,
    {0x5195, 0xf0, 0, 0, 0}
    ,
    {0x5196, 0x03, 0, 0, 0}
    ,
    {0x5197, 0x01, 0, 0, 0}
    ,
    {0x5198, 0x04, 0, 0, 0}
    ,
    {0x5199, 0x12, 0, 0, 0}
    ,
    {0x519a, 0x04, 0, 0, 0}
    ,
    {0x519b, 0x00, 0, 0, 0}
    ,
    {0x519c, 0x06, 0, 0, 0}
    ,
    {0x519d, 0x82, 0, 0, 0}
    ,
    {0x519e, 0x00, 0, 0, 0}
    ,
    {0x5025, 0x80, 0, 0, 0}
    ,
    {0x3a0f, 0x38, 0, 0, 0}
    ,
    {0x3a10, 0x30, 0, 0, 0}
    ,
    {0x3a1b, 0x3a, 0, 0, 0}
    ,
    {0x3a1e, 0x2e, 0, 0, 0}
    ,
    {0x3a11, 0x60, 0, 0, 0}
    ,
    {0x3a1f, 0x10, 0, 0, 0}
    ,
    {0x5688, 0xa6, 0, 0, 0}
    ,
    {0x5689, 0x6a, 0, 0, 0}
    ,
    {0x568a, 0xea, 0, 0, 0}
    ,
    {0x568b, 0xae, 0, 0, 0}
    ,
    {0x568c, 0xa6, 0, 0, 0}
    ,
    {0x568d, 0x6a, 0, 0, 0}
    ,
    {0x568e, 0x62, 0, 0, 0}
    ,
    {0x568f, 0x26, 0, 0, 0}
    ,
    {0x5583, 0x40, 0, 0, 0}
    ,
    {0x5584, 0x40, 0, 0, 0}
    ,
    {0x5580, 0x02, 0, 0, 0}
    ,
    {0x5000, 0xcf, 0, 0, 0}
    ,
    {0x5800, 0x27, 0, 0, 0}
    ,
    {0x5801, 0x19, 0, 0, 0}
    ,
    {0x5802, 0x12, 0, 0, 0}
    ,
    {0x5803, 0x0f, 0, 0, 0}
    ,
    {0x5804, 0x10, 0, 0, 0}
    ,
    {0x5805, 0x15, 0, 0, 0}
    ,
    {0x5806, 0x1e, 0, 0, 0}
    ,
    {0x5807, 0x2f, 0, 0, 0}
    ,
    {0x5808, 0x15, 0, 0, 0}
    ,
    {0x5809, 0x0d, 0, 0, 0}
    ,
    {0x580a, 0x0a, 0, 0, 0}
    ,
    {0x580b, 0x09, 0, 0, 0}
    ,
    {0x580c, 0x0a, 0, 0, 0}
    ,
    {0x580d, 0x0c, 0, 0, 0}
    ,
    {0x580e, 0x12, 0, 0, 0}
    ,
    {0x580f, 0x19, 0, 0, 0}
    ,
    {0x5810, 0x0b, 0, 0, 0}
    ,
    {0x5811, 0x07, 0, 0, 0}
    ,
    {0x5812, 0x04, 0, 0, 0}
    ,
    {0x5813, 0x03, 0, 0, 0}
    ,
    {0x5814, 0x03, 0, 0, 0}
    ,
    {0x5815, 0x06, 0, 0, 0}
    ,
    {0x5816, 0x0a, 0, 0, 0}
    ,
    {0x5817, 0x0f, 0, 0, 0}
    ,
    {0x5818, 0x0a, 0, 0, 0}
    ,
    {0x5819, 0x05, 0, 0, 0}
    ,
    {0x581a, 0x01, 0, 0, 0}
    ,
    {0x581b, 0x00, 0, 0, 0}
    ,
    {0x581c, 0x00, 0, 0, 0}
    ,
    {0x581d, 0x03, 0, 0, 0}
    ,
    {0x581e, 0x08, 0, 0, 0}
    ,
    {0x581f, 0x0c, 0, 0, 0}
    ,
    {0x5820, 0x0a, 0, 0, 0}
    ,
    {0x5821, 0x05, 0, 0, 0}
    ,
    {0x5822, 0x01, 0, 0, 0}
    ,
    {0x5823, 0x00, 0, 0, 0}
    ,
    {0x5824, 0x00, 0, 0, 0}
    ,
    {0x5825, 0x03, 0, 0, 0}
    ,
    {0x5826, 0x08, 0, 0, 0}
    ,
    {0x5827, 0x0c, 0, 0, 0}
    ,
    {0x5828, 0x0e, 0, 0, 0}
    ,
    {0x5829, 0x08, 0, 0, 0}
    ,
    {0x582a, 0x06, 0, 0, 0}
    ,
    {0x582b, 0x04, 0, 0, 0}
    ,
    {0x582c, 0x05, 0, 0, 0}
    ,
    {0x582d, 0x07, 0, 0, 0}
    ,
    {0x582e, 0x0b, 0, 0, 0}
    ,
    {0x582f, 0x12, 0, 0, 0}
    ,
    {0x5830, 0x18, 0, 0, 0}
    ,
    {0x5831, 0x10, 0, 0, 0}
    ,
    {0x5832, 0x0c, 0, 0, 0}
    ,
    {0x5833, 0x0a, 0, 0, 0}
    ,
    {0x5834, 0x0b, 0, 0, 0}
    ,
    {0x5835, 0x0e, 0, 0, 0}
    ,
    {0x5836, 0x15, 0, 0, 0}
    ,
    {0x5837, 0x19, 0, 0, 0}
    ,
    {0x5838, 0x32, 0, 0, 0}
    ,
    {0x5839, 0x1f, 0, 0, 0}
    ,
    {0x583a, 0x18, 0, 0, 0}
    ,
    {0x583b, 0x16, 0, 0, 0}
    ,
    {0x583c, 0x17, 0, 0, 0}
    ,
    {0x583d, 0x1e, 0, 0, 0}
    ,
    {0x583e, 0x26, 0, 0, 0}
    ,
    {0x583f, 0x53, 0, 0, 0}
    ,
    {0x5840, 0x10, 0, 0, 0}
    ,
    {0x5841, 0x0f, 0, 0, 0}
    ,
    {0x5842, 0x0d, 0, 0, 0}
    ,
    {0x5843, 0x0c, 0, 0, 0}
    ,
    {0x5844, 0x0e, 0, 0, 0}
    ,
    {0x5845, 0x09, 0, 0, 0}
    ,
    {0x5846, 0x11, 0, 0, 0}
    ,
    {0x5847, 0x10, 0, 0, 0}
    ,
    {0x5848, 0x10, 0, 0, 0}
    ,
    {0x5849, 0x10, 0, 0, 0}
    ,
    {0x584a, 0x10, 0, 0, 0}
    ,
    {0x584b, 0x0e, 0, 0, 0}
    ,
    {0x584c, 0x10, 0, 0, 0}
    ,
    {0x584d, 0x10, 0, 0, 0}
    ,
    {0x584e, 0x11, 0, 0, 0}
    ,
    {0x584f, 0x10, 0, 0, 0}
    ,
    {0x5850, 0x0f, 0, 0, 0}
    ,
    {0x5851, 0x0c, 0, 0, 0}
    ,
    {0x5852, 0x0f, 0, 0, 0}
    ,
    {0x5853, 0x10, 0, 0, 0}
    ,
    {0x5854, 0x10, 0, 0, 0}
    ,
    {0x5855, 0x0f, 0, 0, 0}
    ,
    {0x5856, 0x0e, 0, 0, 0}
    ,
    {0x5857, 0x0b, 0, 0, 0}
    ,
    {0x5858, 0x10, 0, 0, 0}
    ,
    {0x5859, 0x0d, 0, 0, 0}
    ,
    {0x585a, 0x0d, 0, 0, 0}
    ,
    {0x585b, 0x0c, 0, 0, 0}
    ,
    {0x585c, 0x0c, 0, 0, 0}
    ,
    {0x585d, 0x0c, 0, 0, 0}
    ,
    {0x585e, 0x0b, 0, 0, 0}
    ,
    {0x585f, 0x0c, 0, 0, 0}
    ,
    {0x5860, 0x0c, 0, 0, 0}
    ,
    {0x5861, 0x0c, 0, 0, 0}
    ,
    {0x5862, 0x0d, 0, 0, 0}
    ,
    {0x5863, 0x08, 0, 0, 0}
    ,
    {0x5864, 0x11, 0, 0, 0}
    ,
    {0x5865, 0x18, 0, 0, 0}
    ,
    {0x5866, 0x18, 0, 0, 0}
    ,
    {0x5867, 0x19, 0, 0, 0}
    ,
    {0x5868, 0x17, 0, 0, 0}
    ,
    {0x5869, 0x19, 0, 0, 0}
    ,
    {0x586a, 0x16, 0, 0, 0}
    ,
    {0x586b, 0x13, 0, 0, 0}
    ,
    {0x586c, 0x13, 0, 0, 0}
    ,
    {0x586d, 0x12, 0, 0, 0}
    ,
    {0x586e, 0x13, 0, 0, 0}
    ,
    {0x586f, 0x16, 0, 0, 0}
    ,
    {0x5870, 0x14, 0, 0, 0}
    ,
    {0x5871, 0x12, 0, 0, 0}
    ,
    {0x5872, 0x10, 0, 0, 0}
    ,
    {0x5873, 0x11, 0, 0, 0}
    ,
    {0x5874, 0x11, 0, 0, 0}
    ,
    {0x5875, 0x16, 0, 0, 0}
    ,
    {0x5876, 0x14, 0, 0, 0}
    ,
    {0x5877, 0x11, 0, 0, 0}
    ,
    {0x5878, 0x10, 0, 0, 0}
    ,
    {0x5879, 0x0f, 0, 0, 0}
    ,
    {0x587a, 0x10, 0, 0, 0}
    ,
    {0x587b, 0x14, 0, 0, 0}
    ,
    {0x587c, 0x13, 0, 0, 0}
    ,
    {0x587d, 0x12, 0, 0, 0}
    ,
    {0x587e, 0x11, 0, 0, 0}
    ,
    {0x587f, 0x11, 0, 0, 0}
    ,
    {0x5880, 0x12, 0, 0, 0}
    ,
    {0x5881, 0x15, 0, 0, 0}
    ,
    {0x5882, 0x14, 0, 0, 0}
    ,
    {0x5883, 0x15, 0, 0, 0}
    ,
    {0x5884, 0x15, 0, 0, 0}
    ,
    {0x5885, 0x15, 0, 0, 0}
    ,
    {0x5886, 0x13, 0, 0, 0}
    ,
    {0x5887, 0x17, 0, 0, 0}
    ,
    {0x3710, 0x10, 0, 0, 0}
    ,
    {0x3632, 0x51, 0, 0, 0}
    ,
    {0x3702, 0x10, 0, 0, 0}
    ,
    {0x3703, 0xb2, 0, 0, 0}
    ,
    {0x3704, 0x18, 0, 0, 0}
    ,
    {0x370b, 0x40, 0, 0, 0}
    ,
    {0x370d, 0x03, 0, 0, 0}
    ,
    {0x3631, 0x01, 0, 0, 0}
    ,
    {0x3632, 0x52, 0, 0, 0}
    ,
    {0x3606, 0x24, 0, 0, 0}
    ,
    {0x3620, 0x96, 0, 0, 0}
    ,
    {0x5785, 0x07, 0, 0, 0}
    ,
    {0x3a13, 0x30, 0, 0, 0}
    ,
    {0x3600, 0x52, 0, 0, 0}
    ,
    {0x3604, 0x48, 0, 0, 0}
    ,
    {0x3606, 0x1b, 0, 0, 0}
    ,
    {0x370d, 0x0b, 0, 0, 0}
    ,
    {0x370f, 0xc0, 0, 0, 0}
    ,
    {0x3709, 0x01, 0, 0, 0}
    ,
    {0x3823, 0x00, 0, 0, 0}
    ,
    {0x5007, 0x00, 0, 0, 0}
    ,
    {0x5009, 0x00, 0, 0, 0}
    ,
    {0x5011, 0x00, 0, 0, 0}
    ,
    {0x5013, 0x00, 0, 0, 0}
    ,
    {0x519e, 0x00, 0, 0, 0}
    ,
    {0x5086, 0x00, 0, 0, 0}
    ,
    {0x5087, 0x00, 0, 0, 0}
    ,
    {0x5088, 0x00, 0, 0, 0}
    ,
    {0x5089, 0x00, 0, 0, 0}
    ,
    {0x302b, 0x00, 0, 0, 0}
    ,
    {0x3621, 0x87, 0, 0, 0}
    ,
    {0x3a00, 0x78, 0, 0, 0}
};

reg_param_t g_ov5642_af_firmware[] = {
    {0x3000, 0x20, 0, 0, 0}
    ,
    {0x8000, 0x02, 0, 0, 0}
    ,
    {0x8001, 0x00, 0, 0, 0}
    ,
    {0x8002, 0x06, 0, 0, 0}
    ,
    {0x8003, 0x02, 0, 0, 0}
    ,
    {0x8004, 0x0b, 0, 0, 0}
    ,
    {0x8005, 0x7f, 0, 0, 0}
    ,
    {0x8006, 0x78, 0, 0, 0}
    ,
    {0x8007, 0x7f, 0, 0, 0}
    ,
    {0x8008, 0xe4, 0, 0, 0}
    ,
    {0x8009, 0xf6, 0, 0, 0}
    ,
    {0x800a, 0xd8, 0, 0, 0}
    ,
    {0x800b, 0xfd, 0, 0, 0}
    ,
    {0x800c, 0x75, 0, 0, 0}
    ,
    {0x800d, 0x81, 0, 0, 0}
    ,
    {0x800e, 0x7e, 0, 0, 0}
    ,
    {0x800f, 0x02, 0, 0, 0}
    ,
    {0x8010, 0x13, 0, 0, 0}
    ,
    {0x8011, 0xc4, 0, 0, 0}
    ,
    {0x8012, 0x00, 0, 0, 0}
    ,
    {0x8013, 0x02, 0, 0, 0}
    ,
    {0x8014, 0x14, 0, 0, 0}
    ,
    {0x8015, 0x6b, 0, 0, 0}
    ,
    {0x8016, 0xe0, 0, 0, 0}
    ,
    {0x8017, 0xf5, 0, 0, 0}
    ,
    {0x8018, 0x72, 0, 0, 0}
    ,
    {0x8019, 0xa3, 0, 0, 0}
    ,
    {0x801a, 0xe0, 0, 0, 0}
    ,
    {0x801b, 0xf5, 0, 0, 0}
    ,
    {0x801c, 0x73, 0, 0, 0}
    ,
    {0x801d, 0xae, 0, 0, 0}
    ,
    {0x801e, 0x6a, 0, 0, 0}
    ,
    {0x801f, 0xe4, 0, 0, 0}
    ,
    {0x8020, 0x85, 0, 0, 0}
    ,
    {0x8021, 0x6b, 0, 0, 0}
    ,
    {0x8022, 0x55, 0, 0, 0}
    ,
    {0x8023, 0x8e, 0, 0, 0}
    ,
    {0x8024, 0x54, 0, 0, 0}
    ,
    {0x8025, 0xf5, 0, 0, 0}
    ,
    {0x8026, 0x53, 0, 0, 0}
    ,
    {0x8027, 0xf5, 0, 0, 0}
    ,
    {0x8028, 0x52, 0, 0, 0}
    ,
    {0x8029, 0xab, 0, 0, 0}
    ,
    {0x802a, 0x55, 0, 0, 0}
    ,
    {0x802b, 0xaa, 0, 0, 0}
    ,
    {0x802c, 0x54, 0, 0, 0}
    ,
    {0x802d, 0xa9, 0, 0, 0}
    ,
    {0x802e, 0x53, 0, 0, 0}
    ,
    {0x802f, 0xa8, 0, 0, 0}
    ,
    {0x8030, 0x52, 0, 0, 0}
    ,
    {0x8031, 0xaf, 0, 0, 0}
    ,
    {0x8032, 0x2c, 0, 0, 0}
    ,
    {0x8033, 0xfc, 0, 0, 0}
    ,
    {0x8034, 0xfd, 0, 0, 0}
    ,
    {0x8035, 0xfe, 0, 0, 0}
    ,
    {0x8036, 0x12, 0, 0, 0}
    ,
    {0x8037, 0x08, 0, 0, 0}
    ,
    {0x8038, 0xae, 0, 0, 0}
    ,
    {0x8039, 0x8f, 0, 0, 0}
    ,
    {0x803a, 0x55, 0, 0, 0}
    ,
    {0x803b, 0x8e, 0, 0, 0}
    ,
    {0x803c, 0x54, 0, 0, 0}
    ,
    {0x803d, 0x8d, 0, 0, 0}
    ,
    {0x803e, 0x53, 0, 0, 0}
    ,
    {0x803f, 0x8c, 0, 0, 0}
    ,
    {0x8040, 0x52, 0, 0, 0}
    ,
    {0x8041, 0xaf, 0, 0, 0}
    ,
    {0x8042, 0x55, 0, 0, 0}
    ,
    {0x8043, 0xae, 0, 0, 0}
    ,
    {0x8044, 0x54, 0, 0, 0}
    ,
    {0x8045, 0xad, 0, 0, 0}
    ,
    {0x8046, 0x53, 0, 0, 0}
    ,
    {0x8047, 0xac, 0, 0, 0}
    ,
    {0x8048, 0x52, 0, 0, 0}
    ,
    {0x8049, 0x8f, 0, 0, 0}
    ,
    {0x804a, 0x2b, 0, 0, 0}
    ,
    {0x804b, 0x8e, 0, 0, 0}
    ,
    {0x804c, 0x2a, 0, 0, 0}
    ,
    {0x804d, 0x8d, 0, 0, 0}
    ,
    {0x804e, 0x29, 0, 0, 0}
    ,
    {0x804f, 0x8c, 0, 0, 0}
    ,
    {0x8050, 0x28, 0, 0, 0}
    ,
    {0x8051, 0xae, 0, 0, 0}
    ,
    {0x8052, 0x6c, 0, 0, 0}
    ,
    {0x8053, 0xe4, 0, 0, 0}
    ,
    {0x8054, 0x85, 0, 0, 0}
    ,
    {0x8055, 0x6d, 0, 0, 0}
    ,
    {0x8056, 0x55, 0, 0, 0}
    ,
    {0x8057, 0x8e, 0, 0, 0}
    ,
    {0x8058, 0x54, 0, 0, 0}
    ,
    {0x8059, 0xf5, 0, 0, 0}
    ,
    {0x805a, 0x53, 0, 0, 0}
    ,
    {0x805b, 0xf5, 0, 0, 0}
    ,
    {0x805c, 0x52, 0, 0, 0}
    ,
    {0x805d, 0xab, 0, 0, 0}
    ,
    {0x805e, 0x55, 0, 0, 0}
    ,
    {0x805f, 0xaa, 0, 0, 0}
    ,
    {0x8060, 0x54, 0, 0, 0}
    ,
    {0x8061, 0xa9, 0, 0, 0}
    ,
    {0x8062, 0x53, 0, 0, 0}
    ,
    {0x8063, 0xa8, 0, 0, 0}
    ,
    {0x8064, 0x52, 0, 0, 0}
    ,
    {0x8065, 0xaf, 0, 0, 0}
    ,
    {0x8066, 0x2d, 0, 0, 0}
    ,
    {0x8067, 0xfc, 0, 0, 0}
    ,
    {0x8068, 0xfd, 0, 0, 0}
    ,
    {0x8069, 0xfe, 0, 0, 0}
    ,
    {0x806a, 0x12, 0, 0, 0}
    ,
    {0x806b, 0x08, 0, 0, 0}
    ,
    {0x806c, 0xae, 0, 0, 0}
    ,
    {0x806d, 0x8f, 0, 0, 0}
    ,
    {0x806e, 0x55, 0, 0, 0}
    ,
    {0x806f, 0x8e, 0, 0, 0}
    ,
    {0x8070, 0x54, 0, 0, 0}
    ,
    {0x8071, 0x8d, 0, 0, 0}
    ,
    {0x8072, 0x53, 0, 0, 0}
    ,
    {0x8073, 0x8c, 0, 0, 0}
    ,
    {0x8074, 0x52, 0, 0, 0}
    ,
    {0x8075, 0xe5, 0, 0, 0}
    ,
    {0x8076, 0x2b, 0, 0, 0}
    ,
    {0x8077, 0x25, 0, 0, 0}
    ,
    {0x8078, 0x55, 0, 0, 0}
    ,
    {0x8079, 0xf5, 0, 0, 0}
    ,
    {0x807a, 0x2b, 0, 0, 0}
    ,
    {0x807b, 0xe5, 0, 0, 0}
    ,
    {0x807c, 0x2a, 0, 0, 0}
    ,
    {0x807d, 0x35, 0, 0, 0}
    ,
    {0x807e, 0x54, 0, 0, 0}
    ,
    {0x807f, 0xf5, 0, 0, 0}
    ,
    {0x8080, 0x2a, 0, 0, 0}
    ,
    {0x8081, 0xe5, 0, 0, 0}
    ,
    {0x8082, 0x29, 0, 0, 0}
    ,
    {0x8083, 0x35, 0, 0, 0}
    ,
    {0x8084, 0x53, 0, 0, 0}
    ,
    {0x8085, 0xf5, 0, 0, 0}
    ,
    {0x8086, 0x29, 0, 0, 0}
    ,
    {0x8087, 0xe5, 0, 0, 0}
    ,
    {0x8088, 0x28, 0, 0, 0}
    ,
    {0x8089, 0x35, 0, 0, 0}
    ,
    {0x808a, 0x52, 0, 0, 0}
    ,
    {0x808b, 0xf5, 0, 0, 0}
    ,
    {0x808c, 0x28, 0, 0, 0}
    ,
    {0x808d, 0xae, 0, 0, 0}
    ,
    {0x808e, 0x6e, 0, 0, 0}
    ,
    {0x808f, 0xe4, 0, 0, 0}
    ,
    {0x8090, 0x85, 0, 0, 0}
    ,
    {0x8091, 0x6f, 0, 0, 0}
    ,
    {0x8092, 0x55, 0, 0, 0}
    ,
    {0x8093, 0x8e, 0, 0, 0}
    ,
    {0x8094, 0x54, 0, 0, 0}
    ,
    {0x8095, 0xf5, 0, 0, 0}
    ,
    {0x8096, 0x53, 0, 0, 0}
    ,
    {0x8097, 0xf5, 0, 0, 0}
    ,
    {0x8098, 0x52, 0, 0, 0}
    ,
    {0x8099, 0xab, 0, 0, 0}
    ,
    {0x809a, 0x55, 0, 0, 0}
    ,
    {0x809b, 0xaa, 0, 0, 0}
    ,
    {0x809c, 0x54, 0, 0, 0}
    ,
    {0x809d, 0xa9, 0, 0, 0}
    ,
    {0x809e, 0x53, 0, 0, 0}
    ,
    {0x809f, 0xa8, 0, 0, 0}
    ,
    {0x80a0, 0x52, 0, 0, 0}
    ,
    {0x80a1, 0xaf, 0, 0, 0}
    ,
    {0x80a2, 0x2e, 0, 0, 0}
    ,
    {0x80a3, 0xfc, 0, 0, 0}
    ,
    {0x80a4, 0xfd, 0, 0, 0}
    ,
    {0x80a5, 0xfe, 0, 0, 0}
    ,
    {0x80a6, 0x12, 0, 0, 0}
    ,
    {0x80a7, 0x08, 0, 0, 0}
    ,
    {0x80a8, 0xae, 0, 0, 0}
    ,
    {0x80a9, 0x8f, 0, 0, 0}
    ,
    {0x80aa, 0x55, 0, 0, 0}
    ,
    {0x80ab, 0x8e, 0, 0, 0}
    ,
    {0x80ac, 0x54, 0, 0, 0}
    ,
    {0x80ad, 0x8d, 0, 0, 0}
    ,
    {0x80ae, 0x53, 0, 0, 0}
    ,
    {0x80af, 0x8c, 0, 0, 0}
    ,
    {0x80b0, 0x52, 0, 0, 0}
    ,
    {0x80b1, 0xe5, 0, 0, 0}
    ,
    {0x80b2, 0x2b, 0, 0, 0}
    ,
    {0x80b3, 0x25, 0, 0, 0}
    ,
    {0x80b4, 0x55, 0, 0, 0}
    ,
    {0x80b5, 0xf5, 0, 0, 0}
    ,
    {0x80b6, 0x2b, 0, 0, 0}
    ,
    {0x80b7, 0xe5, 0, 0, 0}
    ,
    {0x80b8, 0x2a, 0, 0, 0}
    ,
    {0x80b9, 0x35, 0, 0, 0}
    ,
    {0x80ba, 0x54, 0, 0, 0}
    ,
    {0x80bb, 0xf5, 0, 0, 0}
    ,
    {0x80bc, 0x2a, 0, 0, 0}
    ,
    {0x80bd, 0xe5, 0, 0, 0}
    ,
    {0x80be, 0x29, 0, 0, 0}
    ,
    {0x80bf, 0x35, 0, 0, 0}
    ,
    {0x80c0, 0x53, 0, 0, 0}
    ,
    {0x80c1, 0xf5, 0, 0, 0}
    ,
    {0x80c2, 0x29, 0, 0, 0}
    ,
    {0x80c3, 0xe5, 0, 0, 0}
    ,
    {0x80c4, 0x28, 0, 0, 0}
    ,
    {0x80c5, 0x35, 0, 0, 0}
    ,
    {0x80c6, 0x52, 0, 0, 0}
    ,
    {0x80c7, 0xf5, 0, 0, 0}
    ,
    {0x80c8, 0x28, 0, 0, 0}
    ,
    {0x80c9, 0xae, 0, 0, 0}
    ,
    {0x80ca, 0x70, 0, 0, 0}
    ,
    {0x80cb, 0xe4, 0, 0, 0}
    ,
    {0x80cc, 0x85, 0, 0, 0}
    ,
    {0x80cd, 0x71, 0, 0, 0}
    ,
    {0x80ce, 0x55, 0, 0, 0}
    ,
    {0x80cf, 0x8e, 0, 0, 0}
    ,
    {0x80d0, 0x54, 0, 0, 0}
    ,
    {0x80d1, 0xf5, 0, 0, 0}
    ,
    {0x80d2, 0x53, 0, 0, 0}
    ,
    {0x80d3, 0xf5, 0, 0, 0}
    ,
    {0x80d4, 0x52, 0, 0, 0}
    ,
    {0x80d5, 0xab, 0, 0, 0}
    ,
    {0x80d6, 0x55, 0, 0, 0}
    ,
    {0x80d7, 0xaa, 0, 0, 0}
    ,
    {0x80d8, 0x54, 0, 0, 0}
    ,
    {0x80d9, 0xa9, 0, 0, 0}
    ,
    {0x80da, 0x53, 0, 0, 0}
    ,
    {0x80db, 0xa8, 0, 0, 0}
    ,
    {0x80dc, 0x52, 0, 0, 0}
    ,
    {0x80dd, 0xaf, 0, 0, 0}
    ,
    {0x80de, 0x2f, 0, 0, 0}
    ,
    {0x80df, 0xfc, 0, 0, 0}
    ,
    {0x80e0, 0xfd, 0, 0, 0}
    ,
    {0x80e1, 0xfe, 0, 0, 0}
    ,
    {0x80e2, 0x12, 0, 0, 0}
    ,
    {0x80e3, 0x08, 0, 0, 0}
    ,
    {0x80e4, 0xae, 0, 0, 0}
    ,
    {0x80e5, 0x8f, 0, 0, 0}
    ,
    {0x80e6, 0x55, 0, 0, 0}
    ,
    {0x80e7, 0x8e, 0, 0, 0}
    ,
    {0x80e8, 0x54, 0, 0, 0}
    ,
    {0x80e9, 0x8d, 0, 0, 0}
    ,
    {0x80ea, 0x53, 0, 0, 0}
    ,
    {0x80eb, 0x8c, 0, 0, 0}
    ,
    {0x80ec, 0x52, 0, 0, 0}
    ,
    {0x80ed, 0xe5, 0, 0, 0}
    ,
    {0x80ee, 0x2b, 0, 0, 0}
    ,
    {0x80ef, 0x25, 0, 0, 0}
    ,
    {0x80f0, 0x55, 0, 0, 0}
    ,
    {0x80f1, 0xf5, 0, 0, 0}
    ,
    {0x80f2, 0x2b, 0, 0, 0}
    ,
    {0x80f3, 0xe5, 0, 0, 0}
    ,
    {0x80f4, 0x2a, 0, 0, 0}
    ,
    {0x80f5, 0x35, 0, 0, 0}
    ,
    {0x80f6, 0x54, 0, 0, 0}
    ,
    {0x80f7, 0xf5, 0, 0, 0}
    ,
    {0x80f8, 0x2a, 0, 0, 0}
    ,
    {0x80f9, 0xe5, 0, 0, 0}
    ,
    {0x80fa, 0x29, 0, 0, 0}
    ,
    {0x80fb, 0x35, 0, 0, 0}
    ,
    {0x80fc, 0x53, 0, 0, 0}
    ,
    {0x80fd, 0xf5, 0, 0, 0}
    ,
    {0x80fe, 0x29, 0, 0, 0}
    ,
    {0x80ff, 0xe5, 0, 0, 0}
    ,
    {0x8100, 0x28, 0, 0, 0}
    ,
    {0x8101, 0x35, 0, 0, 0}
    ,
    {0x8102, 0x52, 0, 0, 0}
    ,
    {0x8103, 0xf5, 0, 0, 0}
    ,
    {0x8104, 0x28, 0, 0, 0}
    ,
    {0x8105, 0xae, 0, 0, 0}
    ,
    {0x8106, 0x72, 0, 0, 0}
    ,
    {0x8107, 0xe4, 0, 0, 0}
    ,
    {0x8108, 0x85, 0, 0, 0}
    ,
    {0x8109, 0x73, 0, 0, 0}
    ,
    {0x810a, 0x55, 0, 0, 0}
    ,
    {0x810b, 0x8e, 0, 0, 0}
    ,
    {0x810c, 0x54, 0, 0, 0}
    ,
    {0x810d, 0xf5, 0, 0, 0}
    ,
    {0x810e, 0x53, 0, 0, 0}
    ,
    {0x810f, 0xf5, 0, 0, 0}
    ,
    {0x8110, 0x52, 0, 0, 0}
    ,
    {0x8111, 0xab, 0, 0, 0}
    ,
    {0x8112, 0x55, 0, 0, 0}
    ,
    {0x8113, 0xaa, 0, 0, 0}
    ,
    {0x8114, 0x54, 0, 0, 0}
    ,
    {0x8115, 0xa9, 0, 0, 0}
    ,
    {0x8116, 0x53, 0, 0, 0}
    ,
    {0x8117, 0xa8, 0, 0, 0}
    ,
    {0x8118, 0x52, 0, 0, 0}
    ,
    {0x8119, 0xaf, 0, 0, 0}
    ,
    {0x811a, 0x30, 0, 0, 0}
    ,
    {0x811b, 0xfc, 0, 0, 0}
    ,
    {0x811c, 0xfd, 0, 0, 0}
    ,
    {0x811d, 0xfe, 0, 0, 0}
    ,
    {0x811e, 0x12, 0, 0, 0}
    ,
    {0x811f, 0x08, 0, 0, 0}
    ,
    {0x8120, 0xae, 0, 0, 0}
    ,
    {0x8121, 0x8f, 0, 0, 0}
    ,
    {0x8122, 0x55, 0, 0, 0}
    ,
    {0x8123, 0x8e, 0, 0, 0}
    ,
    {0x8124, 0x54, 0, 0, 0}
    ,
    {0x8125, 0x8d, 0, 0, 0}
    ,
    {0x8126, 0x53, 0, 0, 0}
    ,
    {0x8127, 0x8c, 0, 0, 0}
    ,
    {0x8128, 0x52, 0, 0, 0}
    ,
    {0x8129, 0xe5, 0, 0, 0}
    ,
    {0x812a, 0x2b, 0, 0, 0}
    ,
    {0x812b, 0x25, 0, 0, 0}
    ,
    {0x812c, 0x55, 0, 0, 0}
    ,
    {0x812d, 0xf5, 0, 0, 0}
    ,
    {0x812e, 0x2b, 0, 0, 0}
    ,
    {0x812f, 0xe5, 0, 0, 0}
    ,
    {0x8130, 0x2a, 0, 0, 0}
    ,
    {0x8131, 0x35, 0, 0, 0}
    ,
    {0x8132, 0x54, 0, 0, 0}
    ,
    {0x8133, 0xf5, 0, 0, 0}
    ,
    {0x8134, 0x2a, 0, 0, 0}
    ,
    {0x8135, 0xe5, 0, 0, 0}
    ,
    {0x8136, 0x29, 0, 0, 0}
    ,
    {0x8137, 0x35, 0, 0, 0}
    ,
    {0x8138, 0x53, 0, 0, 0}
    ,
    {0x8139, 0xf5, 0, 0, 0}
    ,
    {0x813a, 0x29, 0, 0, 0}
    ,
    {0x813b, 0xe5, 0, 0, 0}
    ,
    {0x813c, 0x28, 0, 0, 0}
    ,
    {0x813d, 0x35, 0, 0, 0}
    ,
    {0x813e, 0x52, 0, 0, 0}
    ,
    {0x813f, 0xf5, 0, 0, 0}
    ,
    {0x8140, 0x28, 0, 0, 0}
    ,
    {0x8141, 0x22, 0, 0, 0}
    ,
    {0x8142, 0xab, 0, 0, 0}
    ,
    {0x8143, 0x0d, 0, 0, 0}
    ,
    {0x8144, 0xaa, 0, 0, 0}
    ,
    {0x8145, 0x0c, 0, 0, 0}
    ,
    {0x8146, 0xa9, 0, 0, 0}
    ,
    {0x8147, 0x0b, 0, 0, 0}
    ,
    {0x8148, 0xa8, 0, 0, 0}
    ,
    {0x8149, 0x0a, 0, 0, 0}
    ,
    {0x814a, 0xfc, 0, 0, 0}
    ,
    {0x814b, 0xfd, 0, 0, 0}
    ,
    {0x814c, 0xfe, 0, 0, 0}
    ,
    {0x814d, 0x12, 0, 0, 0}
    ,
    {0x814e, 0x08, 0, 0, 0}
    ,
    {0x814f, 0xae, 0, 0, 0}
    ,
    {0x8150, 0x8f, 0, 0, 0}
    ,
    {0x8151, 0x0d, 0, 0, 0}
    ,
    {0x8152, 0x8e, 0, 0, 0}
    ,
    {0x8153, 0x0c, 0, 0, 0}
    ,
    {0x8154, 0x8d, 0, 0, 0}
    ,
    {0x8155, 0x0b, 0, 0, 0}
    ,
    {0x8156, 0x8c, 0, 0, 0}
    ,
    {0x8157, 0x0a, 0, 0, 0}
    ,
    {0x8158, 0x7b, 0, 0, 0}
    ,
    {0x8159, 0x40, 0, 0, 0}
    ,
    {0x815a, 0xe4, 0, 0, 0}
    ,
    {0x815b, 0xfa, 0, 0, 0}
    ,
    {0x815c, 0xf9, 0, 0, 0}
    ,
    {0x815d, 0xf8, 0, 0, 0}
    ,
    {0x815e, 0x12, 0, 0, 0}
    ,
    {0x815f, 0x09, 0, 0, 0}
    ,
    {0x8160, 0x39, 0, 0, 0}
    ,
    {0x8161, 0x8f, 0, 0, 0}
    ,
    {0x8162, 0x0d, 0, 0, 0}
    ,
    {0x8163, 0x8e, 0, 0, 0}
    ,
    {0x8164, 0x0c, 0, 0, 0}
    ,
    {0x8165, 0x8d, 0, 0, 0}
    ,
    {0x8166, 0x0b, 0, 0, 0}
    ,
    {0x8167, 0x8c, 0, 0, 0}
    ,
    {0x8168, 0x0a, 0, 0, 0}
    ,
    {0x8169, 0x22, 0, 0, 0}
    ,
    {0x816a, 0xab, 0, 0, 0}
    ,
    {0x816b, 0x0d, 0, 0, 0}
    ,
    {0x816c, 0xaa, 0, 0, 0}
    ,
    {0x816d, 0x0c, 0, 0, 0}
    ,
    {0x816e, 0xa9, 0, 0, 0}
    ,
    {0x816f, 0x0b, 0, 0, 0}
    ,
    {0x8170, 0xa8, 0, 0, 0}
    ,
    {0x8171, 0x0a, 0, 0, 0}
    ,
    {0x8172, 0xfc, 0, 0, 0}
    ,
    {0x8173, 0xfd, 0, 0, 0}
    ,
    {0x8174, 0x12, 0, 0, 0}
    ,
    {0x8175, 0x08, 0, 0, 0}
    ,
    {0x8176, 0xae, 0, 0, 0}
    ,
    {0x8177, 0x8f, 0, 0, 0}
    ,
    {0x8178, 0x0d, 0, 0, 0}
    ,
    {0x8179, 0x8e, 0, 0, 0}
    ,
    {0x817a, 0x0c, 0, 0, 0}
    ,
    {0x817b, 0x8d, 0, 0, 0}
    ,
    {0x817c, 0x0b, 0, 0, 0}
    ,
    {0x817d, 0x8c, 0, 0, 0}
    ,
    {0x817e, 0x0a, 0, 0, 0}
    ,
    {0x817f, 0x7b, 0, 0, 0}
    ,
    {0x8180, 0x40, 0, 0, 0}
    ,
    {0x8181, 0xe4, 0, 0, 0}
    ,
    {0x8182, 0xfa, 0, 0, 0}
    ,
    {0x8183, 0xf9, 0, 0, 0}
    ,
    {0x8184, 0xf8, 0, 0, 0}
    ,
    {0x8185, 0x12, 0, 0, 0}
    ,
    {0x8186, 0x09, 0, 0, 0}
    ,
    {0x8187, 0x39, 0, 0, 0}
    ,
    {0x8188, 0x8f, 0, 0, 0}
    ,
    {0x8189, 0x0d, 0, 0, 0}
    ,
    {0x818a, 0x8e, 0, 0, 0}
    ,
    {0x818b, 0x0c, 0, 0, 0}
    ,
    {0x818c, 0x8d, 0, 0, 0}
    ,
    {0x818d, 0x0b, 0, 0, 0}
    ,
    {0x818e, 0x8c, 0, 0, 0}
    ,
    {0x818f, 0x0a, 0, 0, 0}
    ,
    {0x8190, 0x22, 0, 0, 0}
    ,
    {0x8191, 0xd2, 0, 0, 0}
    ,
    {0x8192, 0x29, 0, 0, 0}
    ,
    {0x8193, 0x90, 0, 0, 0}
    ,
    {0x8194, 0x30, 0, 0, 0}
    ,
    {0x8195, 0x1b, 0, 0, 0}
    ,
    {0x8196, 0xe5, 0, 0, 0}
    ,
    {0x8197, 0x25, 0, 0, 0}
    ,
    {0x8198, 0xf0, 0, 0, 0}
    ,
    {0x8199, 0x22, 0, 0, 0}
    ,
    {0x819a, 0xfe, 0, 0, 0}
    ,
    {0x819b, 0xe4, 0, 0, 0}
    ,
    {0x819c, 0xfc, 0, 0, 0}
    ,
    {0x819d, 0xfd, 0, 0, 0}
    ,
    {0x819e, 0xe5, 0, 0, 0}
    ,
    {0x819f, 0x3f, 0, 0, 0}
    ,
    {0x81a0, 0x2f, 0, 0, 0}
    ,
    {0x81a1, 0xf5, 0, 0, 0}
    ,
    {0x81a2, 0x3f, 0, 0, 0}
    ,
    {0x81a3, 0xe5, 0, 0, 0}
    ,
    {0x81a4, 0x3e, 0, 0, 0}
    ,
    {0x81a5, 0x3e, 0, 0, 0}
    ,
    {0x81a6, 0xf5, 0, 0, 0}
    ,
    {0x81a7, 0x3e, 0, 0, 0}
    ,
    {0x81a8, 0xed, 0, 0, 0}
    ,
    {0x81a9, 0x35, 0, 0, 0}
    ,
    {0x81aa, 0x3d, 0, 0, 0}
    ,
    {0x81ab, 0xf5, 0, 0, 0}
    ,
    {0x81ac, 0x3d, 0, 0, 0}
    ,
    {0x81ad, 0xec, 0, 0, 0}
    ,
    {0x81ae, 0x35, 0, 0, 0}
    ,
    {0x81af, 0x3c, 0, 0, 0}
    ,
    {0x81b0, 0xf5, 0, 0, 0}
    ,
    {0x81b1, 0x3c, 0, 0, 0}
    ,
    {0x81b2, 0xaf, 0, 0, 0}
    ,
    {0x81b3, 0x3f, 0, 0, 0}
    ,
    {0x81b4, 0xae, 0, 0, 0}
    ,
    {0x81b5, 0x3e, 0, 0, 0}
    ,
    {0x81b6, 0xfc, 0, 0, 0}
    ,
    {0x81b7, 0xad, 0, 0, 0}
    ,
    {0x81b8, 0x3d, 0, 0, 0}
    ,
    {0x81b9, 0x78, 0, 0, 0}
    ,
    {0x81ba, 0x08, 0, 0, 0}
    ,
    {0x81bb, 0x12, 0, 0, 0}
    ,
    {0x81bc, 0x09, 0, 0, 0}
    ,
    {0x81bd, 0xde, 0, 0, 0}
    ,
    {0x81be, 0x8f, 0, 0, 0}
    ,
    {0x81bf, 0x3f, 0, 0, 0}
    ,
    {0x81c0, 0x8e, 0, 0, 0}
    ,
    {0x81c1, 0x3e, 0, 0, 0}
    ,
    {0x81c2, 0x8d, 0, 0, 0}
    ,
    {0x81c3, 0x3d, 0, 0, 0}
    ,
    {0x81c4, 0x8c, 0, 0, 0}
    ,
    {0x81c5, 0x3c, 0, 0, 0}
    ,
    {0x81c6, 0x22, 0, 0, 0}
    ,
    {0x81c7, 0xe5, 0, 0, 0}
    ,
    {0x81c8, 0x0b, 0, 0, 0}
    ,
    {0x81c9, 0x24, 0, 0, 0}
    ,
    {0x81ca, 0x01, 0, 0, 0}
    ,
    {0x81cb, 0xff, 0, 0, 0}
    ,
    {0x81cc, 0xe4, 0, 0, 0}
    ,
    {0x81cd, 0x33, 0, 0, 0}
    ,
    {0x81ce, 0xfe, 0, 0, 0}
    ,
    {0x81cf, 0x22, 0, 0, 0}
    ,
    {0x81d0, 0xaf, 0, 0, 0}
    ,
    {0x81d1, 0x2b, 0, 0, 0}
    ,
    {0x81d2, 0xae, 0, 0, 0}
    ,
    {0x81d3, 0x2a, 0, 0, 0}
    ,
    {0x81d4, 0xad, 0, 0, 0}
    ,
    {0x81d5, 0x29, 0, 0, 0}
    ,
    {0x81d6, 0xac, 0, 0, 0}
    ,
    {0x81d7, 0x28, 0, 0, 0}
    ,
    {0x81d8, 0x78, 0, 0, 0}
    ,
    {0x81d9, 0x06, 0, 0, 0}
    ,
    {0x81da, 0x12, 0, 0, 0}
    ,
    {0x81db, 0x09, 0, 0, 0}
    ,
    {0x81dc, 0xcb, 0, 0, 0}
    ,
    {0x81dd, 0x8f, 0, 0, 0}
    ,
    {0x81de, 0x2b, 0, 0, 0}
    ,
    {0x81df, 0x8e, 0, 0, 0}
    ,
    {0x81e0, 0x2a, 0, 0, 0}
    ,
    {0x81e1, 0x8d, 0, 0, 0}
    ,
    {0x81e2, 0x29, 0, 0, 0}
    ,
    {0x81e3, 0x8c, 0, 0, 0}
    ,
    {0x81e4, 0x28, 0, 0, 0}
    ,
    {0x81e5, 0xd3, 0, 0, 0}
    ,
    {0x81e6, 0xe5, 0, 0, 0}
    ,
    {0x81e7, 0x29, 0, 0, 0}
    ,
    {0x81e8, 0x94, 0, 0, 0}
    ,
    {0x81e9, 0x00, 0, 0, 0}
    ,
    {0x81ea, 0xe5, 0, 0, 0}
    ,
    {0x81eb, 0x28, 0, 0, 0}
    ,
    {0x81ec, 0x94, 0, 0, 0}
    ,
    {0x81ed, 0x00, 0, 0, 0}
    ,
    {0x81ee, 0x22, 0, 0, 0}
    ,
    {0x81ef, 0xe0, 0, 0, 0}
    ,
    {0x81f0, 0x44, 0, 0, 0}
    ,
    {0x81f1, 0x01, 0, 0, 0}
    ,
    {0x81f2, 0xf0, 0, 0, 0}
    ,
    {0x81f3, 0xe0, 0, 0, 0}
    ,
    {0x81f4, 0x44, 0, 0, 0}
    ,
    {0x81f5, 0x02, 0, 0, 0}
    ,
    {0x81f6, 0xf0, 0, 0, 0}
    ,
    {0x81f7, 0xe0, 0, 0, 0}
    ,
    {0x81f8, 0x44, 0, 0, 0}
    ,
    {0x81f9, 0x04, 0, 0, 0}
    ,
    {0x81fa, 0xf0, 0, 0, 0}
    ,
    {0x81fb, 0x22, 0, 0, 0}
    ,
    {0x81fc, 0xd2, 0, 0, 0}
    ,
    {0x81fd, 0x09, 0, 0, 0}
    ,
    {0x81fe, 0x90, 0, 0, 0}
    ,
    {0x81ff, 0x30, 0, 0, 0}
    ,
    {0x8200, 0x18, 0, 0, 0}
    ,
    {0x8201, 0xe5, 0, 0, 0}
    ,
    {0x8202, 0x21, 0, 0, 0}
    ,
    {0x8203, 0xf0, 0, 0, 0}
    ,
    {0x8204, 0x22, 0, 0, 0}
    ,
    {0x8205, 0xe4, 0, 0, 0}
    ,
    {0x8206, 0x85, 0, 0, 0}
    ,
    {0x8207, 0x11, 0, 0, 0}
    ,
    {0x8208, 0x0d, 0, 0, 0}
    ,
    {0x8209, 0x85, 0, 0, 0}
    ,
    {0x820a, 0x10, 0, 0, 0}
    ,
    {0x820b, 0x0c, 0, 0, 0}
    ,
    {0x820c, 0xf5, 0, 0, 0}
    ,
    {0x820d, 0x0b, 0, 0, 0}
    ,
    {0x820e, 0xf5, 0, 0, 0}
    ,
    {0x820f, 0x0a, 0, 0, 0}
    ,
    {0x8210, 0xab, 0, 0, 0}
    ,
    {0x8211, 0x0d, 0, 0, 0}
    ,
    {0x8212, 0xaa, 0, 0, 0}
    ,
    {0x8213, 0x0c, 0, 0, 0}
    ,
    {0x8214, 0xa9, 0, 0, 0}
    ,
    {0x8215, 0x0b, 0, 0, 0}
    ,
    {0x8216, 0xa8, 0, 0, 0}
    ,
    {0x8217, 0x0a, 0, 0, 0}
    ,
    {0x8218, 0x22, 0, 0, 0}
    ,
    {0x8219, 0xe4, 0, 0, 0}
    ,
    {0x821a, 0x85, 0, 0, 0}
    ,
    {0x821b, 0x11, 0, 0, 0}
    ,
    {0x821c, 0x0d, 0, 0, 0}
    ,
    {0x821d, 0x85, 0, 0, 0}
    ,
    {0x821e, 0x10, 0, 0, 0}
    ,
    {0x821f, 0x0c, 0, 0, 0}
    ,
    {0x8220, 0xf5, 0, 0, 0}
    ,
    {0x8221, 0x0b, 0, 0, 0}
    ,
    {0x8222, 0xf5, 0, 0, 0}
    ,
    {0x8223, 0x0a, 0, 0, 0}
    ,
    {0x8224, 0xab, 0, 0, 0}
    ,
    {0x8225, 0x0d, 0, 0, 0}
    ,
    {0x8226, 0xaa, 0, 0, 0}
    ,
    {0x8227, 0x0c, 0, 0, 0}
    ,
    {0x8228, 0xa9, 0, 0, 0}
    ,
    {0x8229, 0x0b, 0, 0, 0}
    ,
    {0x822a, 0xa8, 0, 0, 0}
    ,
    {0x822b, 0x0a, 0, 0, 0}
    ,
    {0x822c, 0x22, 0, 0, 0}
    ,
    {0x822d, 0x75, 0, 0, 0}
    ,
    {0x822e, 0xf0, 0, 0, 0}
    ,
    {0x822f, 0x02, 0, 0, 0}
    ,
    {0x8230, 0x12, 0, 0, 0}
    ,
    {0x8231, 0x0a, 0, 0, 0}
    ,
    {0x8232, 0x01, 0, 0, 0}
    ,
    {0x8233, 0xe4, 0, 0, 0}
    ,
    {0x8234, 0x93, 0, 0, 0}
    ,
    {0x8235, 0xfe, 0, 0, 0}
    ,
    {0x8236, 0x74, 0, 0, 0}
    ,
    {0x8237, 0x01, 0, 0, 0}
    ,
    {0x8238, 0x93, 0, 0, 0}
    ,
    {0x8239, 0xff, 0, 0, 0}
    ,
    {0x823a, 0x22, 0, 0, 0}
    ,
    {0x823b, 0x90, 0, 0, 0}
    ,
    {0x823c, 0x30, 0, 0, 0}
    ,
    {0x823d, 0x42, 0, 0, 0}
    ,
    {0x823e, 0xe0, 0, 0, 0}
    ,
    {0x823f, 0xf5, 0, 0, 0}
    ,
    {0x8240, 0x22, 0, 0, 0}
    ,
    {0x8241, 0x75, 0, 0, 0}
    ,
    {0x8242, 0x51, 0, 0, 0}
    ,
    {0x8243, 0x0a, 0, 0, 0}
    ,
    {0x8244, 0x22, 0, 0, 0}
    ,
    {0x8245, 0x85, 0, 0, 0}
    ,
    {0x8246, 0x49, 0, 0, 0}
    ,
    {0x8247, 0x82, 0, 0, 0}
    ,
    {0x8248, 0x85, 0, 0, 0}
    ,
    {0x8249, 0x48, 0, 0, 0}
    ,
    {0x824a, 0x83, 0, 0, 0}
    ,
    {0x824b, 0x22, 0, 0, 0}
    ,
    {0x824c, 0xf5, 0, 0, 0}
    ,
    {0x824d, 0x82, 0, 0, 0}
    ,
    {0x824e, 0xe4, 0, 0, 0}
    ,
    {0x824f, 0x3a, 0, 0, 0}
    ,
    {0x8250, 0xf5, 0, 0, 0}
    ,
    {0x8251, 0x83, 0, 0, 0}
    ,
    {0x8252, 0x02, 0, 0, 0}
    ,
    {0x8253, 0x09, 0, 0, 0}
    ,
    {0x8254, 0xf1, 0, 0, 0}
    ,
    {0x8255, 0x8f, 0, 0, 0}
    ,
    {0x8256, 0x0a, 0, 0, 0}
    ,
    {0x8257, 0x74, 0, 0, 0}
    ,
    {0x8258, 0x4a, 0, 0, 0}
    ,
    {0x8259, 0x2f, 0, 0, 0}
    ,
    {0x825a, 0xf8, 0, 0, 0}
    ,
    {0x825b, 0xe6, 0, 0, 0}
    ,
    {0x825c, 0x22, 0, 0, 0}
    ,
    {0x825d, 0x90, 0, 0, 0}
    ,
    {0x825e, 0x50, 0, 0, 0}
    ,
    {0x825f, 0x34, 0, 0, 0}
    ,
    {0x8260, 0x74, 0, 0, 0}
    ,
    {0x8261, 0x80, 0, 0, 0}
    ,
    {0x8262, 0xf0, 0, 0, 0}
    ,
    {0x8263, 0xa3, 0, 0, 0}
    ,
    {0x8264, 0x74, 0, 0, 0}
    ,
    {0x8265, 0x2a, 0, 0, 0}
    ,
    {0x8266, 0xf0, 0, 0, 0}
    ,
    {0x8267, 0xa3, 0, 0, 0}
    ,
    {0x8268, 0x74, 0, 0, 0}
    ,
    {0x8269, 0x14, 0, 0, 0}
    ,
    {0x826a, 0xf0, 0, 0, 0}
    ,
    {0x826b, 0x22, 0, 0, 0}
    ,
    {0x826c, 0xc2, 0, 0, 0}
    ,
    {0x826d, 0x07, 0, 0, 0}
    ,
    {0x826e, 0xc2, 0, 0, 0}
    ,
    {0x826f, 0x06, 0, 0, 0}
    ,
    {0x8270, 0xc2, 0, 0, 0}
    ,
    {0x8271, 0x02, 0, 0, 0}
    ,
    {0x8272, 0xc2, 0, 0, 0}
    ,
    {0x8273, 0x01, 0, 0, 0}
    ,
    {0x8274, 0xc2, 0, 0, 0}
    ,
    {0x8275, 0x00, 0, 0, 0}
    ,
    {0x8276, 0xc2, 0, 0, 0}
    ,
    {0x8277, 0x03, 0, 0, 0}
    ,
    {0x8278, 0xd2, 0, 0, 0}
    ,
    {0x8279, 0x04, 0, 0, 0}
    ,
    {0x827a, 0x22, 0, 0, 0}
    ,
    {0x827b, 0xe5, 0, 0, 0}
    ,
    {0x827c, 0x79, 0, 0, 0}
    ,
    {0x827d, 0x25, 0, 0, 0}
    ,
    {0x827e, 0xe0, 0, 0, 0}
    ,
    {0x827f, 0x25, 0, 0, 0}
    ,
    {0x8280, 0xe0, 0, 0, 0}
    ,
    {0x8281, 0x22, 0, 0, 0}
    ,
    {0x8282, 0xa3, 0, 0, 0}
    ,
    {0x8283, 0xf0, 0, 0, 0}
    ,
    {0x8284, 0xe5, 0, 0, 0}
    ,
    {0x8285, 0x18, 0, 0, 0}
    ,
    {0x8286, 0x54, 0, 0, 0}
    ,
    {0x8287, 0x07, 0, 0, 0}
    ,
    {0x8288, 0xa3, 0, 0, 0}
    ,
    {0x8289, 0xf0, 0, 0, 0}
    ,
    {0x828a, 0xe5, 0, 0, 0}
    ,
    {0x828b, 0x19, 0, 0, 0}
    ,
    {0x828c, 0xa3, 0, 0, 0}
    ,
    {0x828d, 0xf0, 0, 0, 0}
    ,
    {0x828e, 0x22, 0, 0, 0}
    ,
    {0x828f, 0xe5, 0, 0, 0}
    ,
    {0x8290, 0x16, 0, 0, 0}
    ,
    {0x8291, 0x25, 0, 0, 0}
    ,
    {0x8292, 0xe0, 0, 0, 0}
    ,
    {0x8293, 0x25, 0, 0, 0}
    ,
    {0x8294, 0xe0, 0, 0, 0}
    ,
    {0x8295, 0x22, 0, 0, 0}
    ,
    {0x8296, 0xe4, 0, 0, 0}
    ,
    {0x8297, 0x85, 0, 0, 0}
    ,
    {0x8298, 0x0f, 0, 0, 0}
    ,
    {0x8299, 0x0d, 0, 0, 0}
    ,
    {0x829a, 0x85, 0, 0, 0}
    ,
    {0x829b, 0x0e, 0, 0, 0}
    ,
    {0x829c, 0x0c, 0, 0, 0}
    ,
    {0x829d, 0xf5, 0, 0, 0}
    ,
    {0x829e, 0x0b, 0, 0, 0}
    ,
    {0x829f, 0xf5, 0, 0, 0}
    ,
    {0x82a0, 0x0a, 0, 0, 0}
    ,
    {0x82a1, 0x22, 0, 0, 0}
    ,
    {0x82a2, 0xe4, 0, 0, 0}
    ,
    {0x82a3, 0x85, 0, 0, 0}
    ,
    {0x82a4, 0x0f, 0, 0, 0}
    ,
    {0x82a5, 0x0d, 0, 0, 0}
    ,
    {0x82a6, 0x85, 0, 0, 0}
    ,
    {0x82a7, 0x0e, 0, 0, 0}
    ,
    {0x82a8, 0x0c, 0, 0, 0}
    ,
    {0x82a9, 0xf5, 0, 0, 0}
    ,
    {0x82aa, 0x0b, 0, 0, 0}
    ,
    {0x82ab, 0xf5, 0, 0, 0}
    ,
    {0x82ac, 0x0a, 0, 0, 0}
    ,
    {0x82ad, 0x22, 0, 0, 0}
    ,
    {0x82ae, 0x90, 0, 0, 0}
    ,
    {0x82af, 0x12, 0, 0, 0}
    ,
    {0x82b0, 0x3a, 0, 0, 0}
    ,
    {0x82b1, 0xe4, 0, 0, 0}
    ,
    {0x82b2, 0x93, 0, 0, 0}
    ,
    {0x82b3, 0xff, 0, 0, 0}
    ,
    {0x82b4, 0x90, 0, 0, 0}
    ,
    {0x82b5, 0x30, 0, 0, 0}
    ,
    {0x82b6, 0x0a, 0, 0, 0}
    ,
    {0x82b7, 0xe0, 0, 0, 0}
    ,
    {0x82b8, 0x22, 0, 0, 0}
    ,
    {0x82b9, 0xc2, 0, 0, 0}
    ,
    {0x82ba, 0x02, 0, 0, 0}
    ,
    {0x82bb, 0xc2, 0, 0, 0}
    ,
    {0x82bc, 0x01, 0, 0, 0}
    ,
    {0x82bd, 0xd2, 0, 0, 0}
    ,
    {0x82be, 0x00, 0, 0, 0}
    ,
    {0x82bf, 0xc2, 0, 0, 0}
    ,
    {0x82c0, 0x03, 0, 0, 0}
    ,
    {0x82c1, 0xc2, 0, 0, 0}
    ,
    {0x82c2, 0x04, 0, 0, 0}
    ,
    {0x82c3, 0x22, 0, 0, 0}
    ,
    {0x82c4, 0xd2, 0, 0, 0}
    ,
    {0x82c5, 0x02, 0, 0, 0}
    ,
    {0x82c6, 0xd2, 0, 0, 0}
    ,
    {0x82c7, 0x01, 0, 0, 0}
    ,
    {0x82c8, 0xc2, 0, 0, 0}
    ,
    {0x82c9, 0x00, 0, 0, 0}
    ,
    {0x82ca, 0x22, 0, 0, 0}
    ,
    {0x82cb, 0x74, 0, 0, 0}
    ,
    {0x82cc, 0x4a, 0, 0, 0}
    ,
    {0x82cd, 0x25, 0, 0, 0}
    ,
    {0x82ce, 0x0a, 0, 0, 0}
    ,
    {0x82cf, 0xf8, 0, 0, 0}
    ,
    {0x82d0, 0xe6, 0, 0, 0}
    ,
    {0x82d1, 0x22, 0, 0, 0}
    ,
    {0x82d2, 0x30, 0, 0, 0}
    ,
    {0x82d3, 0x18, 0, 0, 0}
    ,
    {0x82d4, 0x4d, 0, 0, 0}
    ,
    {0x82d5, 0x20, 0, 0, 0}
    ,
    {0x82d6, 0x19, 0, 0, 0}
    ,
    {0x82d7, 0x4a, 0, 0, 0}
    ,
    {0x82d8, 0x75, 0, 0, 0}
    ,
    {0x82d9, 0x0a, 0, 0, 0}
    ,
    {0x82da, 0x02, 0, 0, 0}
    ,
    {0x82db, 0x12, 0, 0, 0}
    ,
    {0x82dc, 0x02, 0, 0, 0}
    ,
    {0x82dd, 0xcb, 0, 0, 0}
    ,
    {0x82de, 0xff, 0, 0, 0}
    ,
    {0x82df, 0xe5, 0, 0, 0}
    ,
    {0x82e0, 0x4a, 0, 0, 0}
    ,
    {0x82e1, 0xd3, 0, 0, 0}
    ,
    {0x82e2, 0x9f, 0, 0, 0}
    ,
    {0x82e3, 0x40, 0, 0, 0}
    ,
    {0x82e4, 0x04, 0, 0, 0}
    ,
    {0x82e5, 0x7f, 0, 0, 0}
    ,
    {0x82e6, 0x00, 0, 0, 0}
    ,
    {0x82e7, 0x80, 0, 0, 0}
    ,
    {0x82e8, 0x02, 0, 0, 0}
    ,
    {0x82e9, 0xaf, 0, 0, 0}
    ,
    {0x82ea, 0x0a, 0, 0, 0}
    ,
    {0x82eb, 0x12, 0, 0, 0}
    ,
    {0x82ec, 0x02, 0, 0, 0}
    ,
    {0x82ed, 0x55, 0, 0, 0}
    ,
    {0x82ee, 0xff, 0, 0, 0}
    ,
    {0x82ef, 0xe5, 0, 0, 0}
    ,
    {0x82f0, 0x4b, 0, 0, 0}
    ,
    {0x82f1, 0xd3, 0, 0, 0}
    ,
    {0x82f2, 0x9f, 0, 0, 0}
    ,
    {0x82f3, 0x40, 0, 0, 0}
    ,
    {0x82f4, 0x04, 0, 0, 0}
    ,
    {0x82f5, 0x7f, 0, 0, 0}
    ,
    {0x82f6, 0x01, 0, 0, 0}
    ,
    {0x82f7, 0x80, 0, 0, 0}
    ,
    {0x82f8, 0x02, 0, 0, 0}
    ,
    {0x82f9, 0xaf, 0, 0, 0}
    ,
    {0x82fa, 0x0a, 0, 0, 0}
    ,
    {0x82fb, 0x12, 0, 0, 0}
    ,
    {0x82fc, 0x02, 0, 0, 0}
    ,
    {0x82fd, 0x55, 0, 0, 0}
    ,
    {0x82fe, 0xff, 0, 0, 0}
    ,
    {0x82ff, 0xe5, 0, 0, 0}
    ,
    {0x8300, 0x4d, 0, 0, 0}
    ,
    {0x8301, 0xd3, 0, 0, 0}
    ,
    {0x8302, 0x9f, 0, 0, 0}
    ,
    {0x8303, 0x40, 0, 0, 0}
    ,
    {0x8304, 0x04, 0, 0, 0}
    ,
    {0x8305, 0x7f, 0, 0, 0}
    ,
    {0x8306, 0x03, 0, 0, 0}
    ,
    {0x8307, 0x80, 0, 0, 0}
    ,
    {0x8308, 0x02, 0, 0, 0}
    ,
    {0x8309, 0xaf, 0, 0, 0}
    ,
    {0x830a, 0x0a, 0, 0, 0}
    ,
    {0x830b, 0x12, 0, 0, 0}
    ,
    {0x830c, 0x02, 0, 0, 0}
    ,
    {0x830d, 0x55, 0, 0, 0}
    ,
    {0x830e, 0xff, 0, 0, 0}
    ,
    {0x830f, 0xe5, 0, 0, 0}
    ,
    {0x8310, 0x4e, 0, 0, 0}
    ,
    {0x8311, 0xd3, 0, 0, 0}
    ,
    {0x8312, 0x9f, 0, 0, 0}
    ,
    {0x8313, 0x40, 0, 0, 0}
    ,
    {0x8314, 0x04, 0, 0, 0}
    ,
    {0x8315, 0x7f, 0, 0, 0}
    ,
    {0x8316, 0x04, 0, 0, 0}
    ,
    {0x8317, 0x80, 0, 0, 0}
    ,
    {0x8318, 0x02, 0, 0, 0}
    ,
    {0x8319, 0xaf, 0, 0, 0}
    ,
    {0x831a, 0x0a, 0, 0, 0}
    ,
    {0x831b, 0x12, 0, 0, 0}
    ,
    {0x831c, 0x02, 0, 0, 0}
    ,
    {0x831d, 0x55, 0, 0, 0}
    ,
    {0x831e, 0xf5, 0, 0, 0}
    ,
    {0x831f, 0x0b, 0, 0, 0}
    ,
    {0x8320, 0x80, 0, 0, 0}
    ,
    {0x8321, 0x06, 0, 0, 0}
    ,
    {0x8322, 0x85, 0, 0, 0}
    ,
    {0x8323, 0x79, 0, 0, 0}
    ,
    {0x8324, 0x0a, 0, 0, 0}
    ,
    {0x8325, 0x85, 0, 0, 0}
    ,
    {0x8326, 0x4f, 0, 0, 0}
    ,
    {0x8327, 0x0b, 0, 0, 0}
    ,
    {0x8328, 0x7f, 0, 0, 0}
    ,
    {0x8329, 0x01, 0, 0, 0}
    ,
    {0x832a, 0xe4, 0, 0, 0}
    ,
    {0x832b, 0xfe, 0, 0, 0}
    ,
    {0x832c, 0x12, 0, 0, 0}
    ,
    {0x832d, 0x02, 0, 0, 0}
    ,
    {0x832e, 0xcb, 0, 0, 0}
    ,
    {0x832f, 0xfd, 0, 0, 0}
    ,
    {0x8330, 0xe5, 0, 0, 0}
    ,
    {0x8331, 0x0b, 0, 0, 0}
    ,
    {0x8332, 0xc3, 0, 0, 0}
    ,
    {0x8333, 0x9d, 0, 0, 0}
    ,
    {0x8334, 0x50, 0, 0, 0}
    ,
    {0x8335, 0x04, 0, 0, 0}
    ,
    {0x8336, 0x7d, 0, 0, 0}
    ,
    {0x8337, 0x01, 0, 0, 0}
    ,
    {0x8338, 0x80, 0, 0, 0}
    ,
    {0x8339, 0x02, 0, 0, 0}
    ,
    {0x833a, 0x7d, 0, 0, 0}
    ,
    {0x833b, 0xff, 0, 0, 0}
    ,
    {0x833c, 0xac, 0, 0, 0}
    ,
    {0x833d, 0x0b, 0, 0, 0}
    ,
    {0x833e, 0xe5, 0, 0, 0}
    ,
    {0x833f, 0x4e, 0, 0, 0}
    ,
    {0x8340, 0xb5, 0, 0, 0}
    ,
    {0x8341, 0x0b, 0, 0, 0}
    ,
    {0x8342, 0x03, 0, 0, 0}
    ,
    {0x8343, 0xd3, 0, 0, 0}
    ,
    {0x8344, 0x80, 0, 0, 0}
    ,
    {0x8345, 0x01, 0, 0, 0}
    ,
    {0x8346, 0xc3, 0, 0, 0}
    ,
    {0x8347, 0x92, 0, 0, 0}
    ,
    {0x8348, 0x1f, 0, 0, 0}
    ,
    {0x8349, 0xe5, 0, 0, 0}
    ,
    {0x834a, 0x4d, 0, 0, 0}
    ,
    {0x834b, 0xb5, 0, 0, 0}
    ,
    {0x834c, 0x0b, 0, 0, 0}
    ,
    {0x834d, 0x03, 0, 0, 0}
    ,
    {0x834e, 0xd3, 0, 0, 0}
    ,
    {0x834f, 0x80, 0, 0, 0}
    ,
    {0x8350, 0x01, 0, 0, 0}
    ,
    {0x8351, 0xc3, 0, 0, 0}
    ,
    {0x8352, 0x92, 0, 0, 0}
    ,
    {0x8353, 0x1e, 0, 0, 0}
    ,
    {0x8354, 0xe5, 0, 0, 0}
    ,
    {0x8355, 0x4c, 0, 0, 0}
    ,
    {0x8356, 0xb5, 0, 0, 0}
    ,
    {0x8357, 0x0b, 0, 0, 0}
    ,
    {0x8358, 0x03, 0, 0, 0}
    ,
    {0x8359, 0xd3, 0, 0, 0}
    ,
    {0x835a, 0x80, 0, 0, 0}
    ,
    {0x835b, 0x01, 0, 0, 0}
    ,
    {0x835c, 0xc3, 0, 0, 0}
    ,
    {0x835d, 0x92, 0, 0, 0}
    ,
    {0x835e, 0x1d, 0, 0, 0}
    ,
    {0x835f, 0xe5, 0, 0, 0}
    ,
    {0x8360, 0x4b, 0, 0, 0}
    ,
    {0x8361, 0xb5, 0, 0, 0}
    ,
    {0x8362, 0x0b, 0, 0, 0}
    ,
    {0x8363, 0x03, 0, 0, 0}
    ,
    {0x8364, 0xd3, 0, 0, 0}
    ,
    {0x8365, 0x80, 0, 0, 0}
    ,
    {0x8366, 0x01, 0, 0, 0}
    ,
    {0x8367, 0xc3, 0, 0, 0}
    ,
    {0x8368, 0x92, 0, 0, 0}
    ,
    {0x8369, 0x1c, 0, 0, 0}
    ,
    {0x836a, 0xe5, 0, 0, 0}
    ,
    {0x836b, 0x4a, 0, 0, 0}
    ,
    {0x836c, 0xb5, 0, 0, 0}
    ,
    {0x836d, 0x0b, 0, 0, 0}
    ,
    {0x836e, 0x03, 0, 0, 0}
    ,
    {0x836f, 0xd3, 0, 0, 0}
    ,
    {0x8370, 0x80, 0, 0, 0}
    ,
    {0x8371, 0x01, 0, 0, 0}
    ,
    {0x8372, 0xc3, 0, 0, 0}
    ,
    {0x8373, 0x92, 0, 0, 0}
    ,
    {0x8374, 0x1b, 0, 0, 0}
    ,
    {0x8375, 0xe5, 0, 0, 0}
    ,
    {0x8376, 0x30, 0, 0, 0}
    ,
    {0x8377, 0xd3, 0, 0, 0}
    ,
    {0x8378, 0x94, 0, 0, 0}
    ,
    {0x8379, 0x00, 0, 0, 0}
    ,
    {0x837a, 0x40, 0, 0, 0}
    ,
    {0x837b, 0x04, 0, 0, 0}
    ,
    {0x837c, 0xa2, 0, 0, 0}
    ,
    {0x837d, 0x1f, 0, 0, 0}
    ,
    {0x837e, 0x80, 0, 0, 0}
    ,
    {0x837f, 0x01, 0, 0, 0}
    ,
    {0x8380, 0xc3, 0, 0, 0}
    ,
    {0x8381, 0x92, 0, 0, 0}
    ,
    {0x8382, 0x1f, 0, 0, 0}
    ,
    {0x8383, 0xe5, 0, 0, 0}
    ,
    {0x8384, 0x2f, 0, 0, 0}
    ,
    {0x8385, 0xd3, 0, 0, 0}
    ,
    {0x8386, 0x94, 0, 0, 0}
    ,
    {0x8387, 0x00, 0, 0, 0}
    ,
    {0x8388, 0x40, 0, 0, 0}
    ,
    {0x8389, 0x04, 0, 0, 0}
    ,
    {0x838a, 0xa2, 0, 0, 0}
    ,
    {0x838b, 0x1e, 0, 0, 0}
    ,
    {0x838c, 0x80, 0, 0, 0}
    ,
    {0x838d, 0x01, 0, 0, 0}
    ,
    {0x838e, 0xc3, 0, 0, 0}
    ,
    {0x838f, 0x92, 0, 0, 0}
    ,
    {0x8390, 0x1e, 0, 0, 0}
    ,
    {0x8391, 0xe5, 0, 0, 0}
    ,
    {0x8392, 0x2e, 0, 0, 0}
    ,
    {0x8393, 0xd3, 0, 0, 0}
    ,
    {0x8394, 0x94, 0, 0, 0}
    ,
    {0x8395, 0x00, 0, 0, 0}
    ,
    {0x8396, 0x40, 0, 0, 0}
    ,
    {0x8397, 0x04, 0, 0, 0}
    ,
    {0x8398, 0xa2, 0, 0, 0}
    ,
    {0x8399, 0x1d, 0, 0, 0}
    ,
    {0x839a, 0x80, 0, 0, 0}
    ,
    {0x839b, 0x01, 0, 0, 0}
    ,
    {0x839c, 0xc3, 0, 0, 0}
    ,
    {0x839d, 0x92, 0, 0, 0}
    ,
    {0x839e, 0x1d, 0, 0, 0}
    ,
    {0x839f, 0xe5, 0, 0, 0}
    ,
    {0x83a0, 0x2d, 0, 0, 0}
    ,
    {0x83a1, 0xd3, 0, 0, 0}
    ,
    {0x83a2, 0x94, 0, 0, 0}
    ,
    {0x83a3, 0x00, 0, 0, 0}
    ,
    {0x83a4, 0x40, 0, 0, 0}
    ,
    {0x83a5, 0x04, 0, 0, 0}
    ,
    {0x83a6, 0xa2, 0, 0, 0}
    ,
    {0x83a7, 0x1c, 0, 0, 0}
    ,
    {0x83a8, 0x80, 0, 0, 0}
    ,
    {0x83a9, 0x01, 0, 0, 0}
    ,
    {0x83aa, 0xc3, 0, 0, 0}
    ,
    {0x83ab, 0x92, 0, 0, 0}
    ,
    {0x83ac, 0x1c, 0, 0, 0}
    ,
    {0x83ad, 0xe5, 0, 0, 0}
    ,
    {0x83ae, 0x2c, 0, 0, 0}
    ,
    {0x83af, 0xd3, 0, 0, 0}
    ,
    {0x83b0, 0x94, 0, 0, 0}
    ,
    {0x83b1, 0x00, 0, 0, 0}
    ,
    {0x83b2, 0x40, 0, 0, 0}
    ,
    {0x83b3, 0x04, 0, 0, 0}
    ,
    {0x83b4, 0xa2, 0, 0, 0}
    ,
    {0x83b5, 0x1b, 0, 0, 0}
    ,
    {0x83b6, 0x80, 0, 0, 0}
    ,
    {0x83b7, 0x01, 0, 0, 0}
    ,
    {0x83b8, 0xc3, 0, 0, 0}
    ,
    {0x83b9, 0x92, 0, 0, 0}
    ,
    {0x83ba, 0x1b, 0, 0, 0}
    ,
    {0x83bb, 0xe5, 0, 0, 0}
    ,
    {0x83bc, 0x23, 0, 0, 0}
    ,
    {0x83bd, 0x54, 0, 0, 0}
    ,
    {0x83be, 0xf8, 0, 0, 0}
    ,
    {0x83bf, 0x70, 0, 0, 0}
    ,
    {0x83c0, 0x5b, 0, 0, 0}
    ,
    {0x83c1, 0xbf, 0, 0, 0}
    ,
    {0x83c2, 0x01, 0, 0, 0}
    ,
    {0x83c3, 0x08, 0, 0, 0}
    ,
    {0x83c4, 0xed, 0, 0, 0}
    ,
    {0x83c5, 0xf4, 0, 0, 0}
    ,
    {0x83c6, 0x04, 0, 0, 0}
    ,
    {0x83c7, 0xfd, 0, 0, 0}
    ,
    {0x83c8, 0x7f, 0, 0, 0}
    ,
    {0x83c9, 0x02, 0, 0, 0}
    ,
    {0x83ca, 0x80, 0, 0, 0}
    ,
    {0x83cb, 0x06, 0, 0, 0}
    ,
    {0x83cc, 0xbf, 0, 0, 0}
    ,
    {0x83cd, 0x02, 0, 0, 0}
    ,
    {0x83ce, 0x02, 0, 0, 0}
    ,
    {0x83cf, 0x7f, 0, 0, 0}
    ,
    {0x83d0, 0x01, 0, 0, 0}
    ,
    {0x83d1, 0x0e, 0, 0, 0}
    ,
    {0x83d2, 0xd3, 0, 0, 0}
    ,
    {0x83d3, 0xed, 0, 0, 0}
    ,
    {0x83d4, 0x64, 0, 0, 0}
    ,
    {0x83d5, 0x80, 0, 0, 0}
    ,
    {0x83d6, 0x94, 0, 0, 0}
    ,
    {0x83d7, 0x80, 0, 0, 0}
    ,
    {0x83d8, 0x40, 0, 0, 0}
    ,
    {0x83d9, 0x18, 0, 0, 0}
    ,
    {0x83da, 0xec, 0, 0, 0}
    ,
    {0x83db, 0x2e, 0, 0, 0}
    ,
    {0x83dc, 0xf5, 0, 0, 0}
    ,
    {0x83dd, 0x0b, 0, 0, 0}
    ,
    {0x83de, 0xd3, 0, 0, 0}
    ,
    {0x83df, 0x95, 0, 0, 0}
    ,
    {0x83e0, 0x7c, 0, 0, 0}
    ,
    {0x83e1, 0x40, 0, 0, 0}
    ,
    {0x83e2, 0x2c, 0, 0, 0}
    ,
    {0x83e3, 0x7d, 0, 0, 0}
    ,
    {0x83e4, 0xff, 0, 0, 0}
    ,
    {0x83e5, 0xef, 0, 0, 0}
    ,
    {0x83e6, 0x60, 0, 0, 0}
    ,
    {0x83e7, 0x04, 0, 0, 0}
    ,
    {0x83e8, 0x7b, 0, 0, 0}
    ,
    {0x83e9, 0x00, 0, 0, 0}
    ,
    {0x83ea, 0x80, 0, 0, 0}
    ,
    {0x83eb, 0x02, 0, 0, 0}
    ,
    {0x83ec, 0x7b, 0, 0, 0}
    ,
    {0x83ed, 0x03, 0, 0, 0}
    ,
    {0x83ee, 0xaf, 0, 0, 0}
    ,
    {0x83ef, 0x03, 0, 0, 0}
    ,
    {0x83f0, 0x80, 0, 0, 0}
    ,
    {0x83f1, 0x18, 0, 0, 0}
    ,
    {0x83f2, 0xec, 0, 0, 0}
    ,
    {0x83f3, 0xc3, 0, 0, 0}
    ,
    {0x83f4, 0x9e, 0, 0, 0}
    ,
    {0x83f5, 0x50, 0, 0, 0}
    ,
    {0x83f6, 0x13, 0, 0, 0}
    ,
    {0x83f7, 0x7d, 0, 0, 0}
    ,
    {0x83f8, 0x01, 0, 0, 0}
    ,
    {0x83f9, 0xef, 0, 0, 0}
    ,
    {0x83fa, 0x60, 0, 0, 0}
    ,
    {0x83fb, 0x04, 0, 0, 0}
    ,
    {0x83fc, 0x7b, 0, 0, 0}
    ,
    {0x83fd, 0x00, 0, 0, 0}
    ,
    {0x83fe, 0x80, 0, 0, 0}
    ,
    {0x83ff, 0x02, 0, 0, 0}
    ,
    {0x8400, 0x7b, 0, 0, 0}
    ,
    {0x8401, 0x03, 0, 0, 0}
    ,
    {0x8402, 0xaf, 0, 0, 0}
    ,
    {0x8403, 0x03, 0, 0, 0}
    ,
    {0x8404, 0xec, 0, 0, 0}
    ,
    {0x8405, 0x2e, 0, 0, 0}
    ,
    {0x8406, 0xf5, 0, 0, 0}
    ,
    {0x8407, 0x0b, 0, 0, 0}
    ,
    {0x8408, 0x80, 0, 0, 0}
    ,
    {0x8409, 0x05, 0, 0, 0}
    ,
    {0x840a, 0xc3, 0, 0, 0}
    ,
    {0x840b, 0xec, 0, 0, 0}
    ,
    {0x840c, 0x9e, 0, 0, 0}
    ,
    {0x840d, 0xf5, 0, 0, 0}
    ,
    {0x840e, 0x0b, 0, 0, 0}
    ,
    {0x840f, 0xef, 0, 0, 0}
    ,
    {0x8410, 0x64, 0, 0, 0}
    ,
    {0x8411, 0x03, 0, 0, 0}
    ,
    {0x8412, 0x60, 0, 0, 0}
    ,
    {0x8413, 0x03, 0, 0, 0}
    ,
    {0x8414, 0x02, 0, 0, 0}
    ,
    {0x8415, 0x03, 0, 0, 0}
    ,
    {0x8416, 0x3e, 0, 0, 0}
    ,
    {0x8417, 0x12, 0, 0, 0}
    ,
    {0x8418, 0x02, 0, 0, 0}
    ,
    {0x8419, 0xcb, 0, 0, 0}
    ,
    {0x841a, 0xf5, 0, 0, 0}
    ,
    {0x841b, 0x0b, 0, 0, 0}
    ,
    {0x841c, 0x12, 0, 0, 0}
    ,
    {0x841d, 0x01, 0, 0, 0}
    ,
    {0x841e, 0xc7, 0, 0, 0}
    ,
    {0x841f, 0xe5, 0, 0, 0}
    ,
    {0x8420, 0x4e, 0, 0, 0}
    ,
    {0x8421, 0xb5, 0, 0, 0}
    ,
    {0x8422, 0x07, 0, 0, 0}
    ,
    {0x8423, 0x07, 0, 0, 0}
    ,
    {0x8424, 0xe4, 0, 0, 0}
    ,
    {0x8425, 0xb5, 0, 0, 0}
    ,
    {0x8426, 0x06, 0, 0, 0}
    ,
    {0x8427, 0x03, 0, 0, 0}
    ,
    {0x8428, 0xd3, 0, 0, 0}
    ,
    {0x8429, 0x80, 0, 0, 0}
    ,
    {0x842a, 0x02, 0, 0, 0}
    ,
    {0x842b, 0xa2, 0, 0, 0}
    ,
    {0x842c, 0x1f, 0, 0, 0}
    ,
    {0x842d, 0x92, 0, 0, 0}
    ,
    {0x842e, 0x1f, 0, 0, 0}
    ,
    {0x842f, 0xe5, 0, 0, 0}
    ,
    {0x8430, 0x4d, 0, 0, 0}
    ,
    {0x8431, 0xb5, 0, 0, 0}
    ,
    {0x8432, 0x07, 0, 0, 0}
    ,
    {0x8433, 0x07, 0, 0, 0}
    ,
    {0x8434, 0xe4, 0, 0, 0}
    ,
    {0x8435, 0xb5, 0, 0, 0}
    ,
    {0x8436, 0x06, 0, 0, 0}
    ,
    {0x8437, 0x03, 0, 0, 0}
    ,
    {0x8438, 0xd3, 0, 0, 0}
    ,
    {0x8439, 0x80, 0, 0, 0}
    ,
    {0x843a, 0x02, 0, 0, 0}
    ,
    {0x843b, 0xa2, 0, 0, 0}
    ,
    {0x843c, 0x1e, 0, 0, 0}
    ,
    {0x843d, 0x92, 0, 0, 0}
    ,
    {0x843e, 0x1e, 0, 0, 0}
    ,
    {0x843f, 0x12, 0, 0, 0}
    ,
    {0x8440, 0x01, 0, 0, 0}
    ,
    {0x8441, 0xc7, 0, 0, 0}
    ,
    {0x8442, 0xe5, 0, 0, 0}
    ,
    {0x8443, 0x4c, 0, 0, 0}
    ,
    {0x8444, 0xb5, 0, 0, 0}
    ,
    {0x8445, 0x07, 0, 0, 0}
    ,
    {0x8446, 0x07, 0, 0, 0}
    ,
    {0x8447, 0xe4, 0, 0, 0}
    ,
    {0x8448, 0xb5, 0, 0, 0}
    ,
    {0x8449, 0x06, 0, 0, 0}
    ,
    {0x844a, 0x03, 0, 0, 0}
    ,
    {0x844b, 0xd3, 0, 0, 0}
    ,
    {0x844c, 0x80, 0, 0, 0}
    ,
    {0x844d, 0x02, 0, 0, 0}
    ,
    {0x844e, 0xa2, 0, 0, 0}
    ,
    {0x844f, 0x1d, 0, 0, 0}
    ,
    {0x8450, 0x92, 0, 0, 0}
    ,
    {0x8451, 0x1d, 0, 0, 0}
    ,
    {0x8452, 0xe5, 0, 0, 0}
    ,
    {0x8453, 0x4b, 0, 0, 0}
    ,
    {0x8454, 0xb5, 0, 0, 0}
    ,
    {0x8455, 0x07, 0, 0, 0}
    ,
    {0x8456, 0x07, 0, 0, 0}
    ,
    {0x8457, 0xe4, 0, 0, 0}
    ,
    {0x8458, 0xb5, 0, 0, 0}
    ,
    {0x8459, 0x06, 0, 0, 0}
    ,
    {0x845a, 0x03, 0, 0, 0}
    ,
    {0x845b, 0xd3, 0, 0, 0}
    ,
    {0x845c, 0x80, 0, 0, 0}
    ,
    {0x845d, 0x02, 0, 0, 0}
    ,
    {0x845e, 0xa2, 0, 0, 0}
    ,
    {0x845f, 0x1c, 0, 0, 0}
    ,
    {0x8460, 0x92, 0, 0, 0}
    ,
    {0x8461, 0x1c, 0, 0, 0}
    ,
    {0x8462, 0x12, 0, 0, 0}
    ,
    {0x8463, 0x01, 0, 0, 0}
    ,
    {0x8464, 0xc7, 0, 0, 0}
    ,
    {0x8465, 0xe5, 0, 0, 0}
    ,
    {0x8466, 0x4a, 0, 0, 0}
    ,
    {0x8467, 0xb5, 0, 0, 0}
    ,
    {0x8468, 0x07, 0, 0, 0}
    ,
    {0x8469, 0x07, 0, 0, 0}
    ,
    {0x846a, 0xe4, 0, 0, 0}
    ,
    {0x846b, 0xb5, 0, 0, 0}
    ,
    {0x846c, 0x06, 0, 0, 0}
    ,
    {0x846d, 0x03, 0, 0, 0}
    ,
    {0x846e, 0xd3, 0, 0, 0}
    ,
    {0x846f, 0x80, 0, 0, 0}
    ,
    {0x8470, 0x02, 0, 0, 0}
    ,
    {0x8471, 0xa2, 0, 0, 0}
    ,
    {0x8472, 0x1b, 0, 0, 0}
    ,
    {0x8473, 0x92, 0, 0, 0}
    ,
    {0x8474, 0x1b, 0, 0, 0}
    ,
    {0x8475, 0xe5, 0, 0, 0}
    ,
    {0x8476, 0x4e, 0, 0, 0}
    ,
    {0x8477, 0x12, 0, 0, 0}
    ,
    {0x8478, 0x01, 0, 0, 0}
    ,
    {0x8479, 0xc9, 0, 0, 0}
    ,
    {0x847a, 0xad, 0, 0, 0}
    ,
    {0x847b, 0x0b, 0, 0, 0}
    ,
    {0x847c, 0x7c, 0, 0, 0}
    ,
    {0x847d, 0x00, 0, 0, 0}
    ,
    {0x847e, 0xef, 0, 0, 0}
    ,
    {0x847f, 0xb5, 0, 0, 0}
    ,
    {0x8480, 0x05, 0, 0, 0}
    ,
    {0x8481, 0x07, 0, 0, 0}
    ,
    {0x8482, 0xec, 0, 0, 0}
    ,
    {0x8483, 0xb5, 0, 0, 0}
    ,
    {0x8484, 0x06, 0, 0, 0}
    ,
    {0x8485, 0x03, 0, 0, 0}
    ,
    {0x8486, 0xd3, 0, 0, 0}
    ,
    {0x8487, 0x80, 0, 0, 0}
    ,
    {0x8488, 0x02, 0, 0, 0}
    ,
    {0x8489, 0xa2, 0, 0, 0}
    ,
    {0x848a, 0x1f, 0, 0, 0}
    ,
    {0x848b, 0x92, 0, 0, 0}
    ,
    {0x848c, 0x1f, 0, 0, 0}
    ,
    {0x848d, 0xe5, 0, 0, 0}
    ,
    {0x848e, 0x4d, 0, 0, 0}
    ,
    {0x848f, 0x12, 0, 0, 0}
    ,
    {0x8490, 0x01, 0, 0, 0}
    ,
    {0x8491, 0xc9, 0, 0, 0}
    ,
    {0x8492, 0xef, 0, 0, 0}
    ,
    {0x8493, 0xb5, 0, 0, 0}
    ,
    {0x8494, 0x05, 0, 0, 0}
    ,
    {0x8495, 0x07, 0, 0, 0}
    ,
    {0x8496, 0xee, 0, 0, 0}
    ,
    {0x8497, 0xb5, 0, 0, 0}
    ,
    {0x8498, 0x04, 0, 0, 0}
    ,
    {0x8499, 0x03, 0, 0, 0}
    ,
    {0x849a, 0xd3, 0, 0, 0}
    ,
    {0x849b, 0x80, 0, 0, 0}
    ,
    {0x849c, 0x02, 0, 0, 0}
    ,
    {0x849d, 0xa2, 0, 0, 0}
    ,
    {0x849e, 0x1e, 0, 0, 0}
    ,
    {0x849f, 0x92, 0, 0, 0}
    ,
    {0x84a0, 0x1e, 0, 0, 0}
    ,
    {0x84a1, 0xe5, 0, 0, 0}
    ,
    {0x84a2, 0x4c, 0, 0, 0}
    ,
    {0x84a3, 0x12, 0, 0, 0}
    ,
    {0x84a4, 0x01, 0, 0, 0}
    ,
    {0x84a5, 0xc9, 0, 0, 0}
    ,
    {0x84a6, 0xad, 0, 0, 0}
    ,
    {0x84a7, 0x0b, 0, 0, 0}
    ,
    {0x84a8, 0x7c, 0, 0, 0}
    ,
    {0x84a9, 0x00, 0, 0, 0}
    ,
    {0x84aa, 0xef, 0, 0, 0}
    ,
    {0x84ab, 0xb5, 0, 0, 0}
    ,
    {0x84ac, 0x05, 0, 0, 0}
    ,
    {0x84ad, 0x07, 0, 0, 0}
    ,
    {0x84ae, 0xec, 0, 0, 0}
    ,
    {0x84af, 0xb5, 0, 0, 0}
    ,
    {0x84b0, 0x06, 0, 0, 0}
    ,
    {0x84b1, 0x03, 0, 0, 0}
    ,
    {0x84b2, 0xd3, 0, 0, 0}
    ,
    {0x84b3, 0x80, 0, 0, 0}
    ,
    {0x84b4, 0x02, 0, 0, 0}
    ,
    {0x84b5, 0xa2, 0, 0, 0}
    ,
    {0x84b6, 0x1d, 0, 0, 0}
    ,
    {0x84b7, 0x92, 0, 0, 0}
    ,
    {0x84b8, 0x1d, 0, 0, 0}
    ,
    {0x84b9, 0xe5, 0, 0, 0}
    ,
    {0x84ba, 0x4b, 0, 0, 0}
    ,
    {0x84bb, 0x12, 0, 0, 0}
    ,
    {0x84bc, 0x01, 0, 0, 0}
    ,
    {0x84bd, 0xc9, 0, 0, 0}
    ,
    {0x84be, 0xef, 0, 0, 0}
    ,
    {0x84bf, 0xb5, 0, 0, 0}
    ,
    {0x84c0, 0x05, 0, 0, 0}
    ,
    {0x84c1, 0x07, 0, 0, 0}
    ,
    {0x84c2, 0xee, 0, 0, 0}
    ,
    {0x84c3, 0xb5, 0, 0, 0}
    ,
    {0x84c4, 0x04, 0, 0, 0}
    ,
    {0x84c5, 0x03, 0, 0, 0}
    ,
    {0x84c6, 0xd3, 0, 0, 0}
    ,
    {0x84c7, 0x80, 0, 0, 0}
    ,
    {0x84c8, 0x02, 0, 0, 0}
    ,
    {0x84c9, 0xa2, 0, 0, 0}
    ,
    {0x84ca, 0x1c, 0, 0, 0}
    ,
    {0x84cb, 0x92, 0, 0, 0}
    ,
    {0x84cc, 0x1c, 0, 0, 0}
    ,
    {0x84cd, 0xe5, 0, 0, 0}
    ,
    {0x84ce, 0x4a, 0, 0, 0}
    ,
    {0x84cf, 0x12, 0, 0, 0}
    ,
    {0x84d0, 0x01, 0, 0, 0}
    ,
    {0x84d1, 0xc9, 0, 0, 0}
    ,
    {0x84d2, 0x7c, 0, 0, 0}
    ,
    {0x84d3, 0x00, 0, 0, 0}
    ,
    {0x84d4, 0xef, 0, 0, 0}
    ,
    {0x84d5, 0xb5, 0, 0, 0}
    ,
    {0x84d6, 0x0b, 0, 0, 0}
    ,
    {0x84d7, 0x07, 0, 0, 0}
    ,
    {0x84d8, 0xec, 0, 0, 0}
    ,
    {0x84d9, 0xb5, 0, 0, 0}
    ,
    {0x84da, 0x06, 0, 0, 0}
    ,
    {0x84db, 0x03, 0, 0, 0}
    ,
    {0x84dc, 0xd3, 0, 0, 0}
    ,
    {0x84dd, 0x80, 0, 0, 0}
    ,
    {0x84de, 0x02, 0, 0, 0}
    ,
    {0x84df, 0xa2, 0, 0, 0}
    ,
    {0x84e0, 0x1b, 0, 0, 0}
    ,
    {0x84e1, 0x92, 0, 0, 0}
    ,
    {0x84e2, 0x1b, 0, 0, 0}
    ,
    {0x84e3, 0xe5, 0, 0, 0}
    ,
    {0x84e4, 0x30, 0, 0, 0}
    ,
    {0x84e5, 0xd3, 0, 0, 0}
    ,
    {0x84e6, 0x94, 0, 0, 0}
    ,
    {0x84e7, 0x00, 0, 0, 0}
    ,
    {0x84e8, 0x40, 0, 0, 0}
    ,
    {0x84e9, 0x04, 0, 0, 0}
    ,
    {0x84ea, 0xa2, 0, 0, 0}
    ,
    {0x84eb, 0x1f, 0, 0, 0}
    ,
    {0x84ec, 0x80, 0, 0, 0}
    ,
    {0x84ed, 0x01, 0, 0, 0}
    ,
    {0x84ee, 0xc3, 0, 0, 0}
    ,
    {0x84ef, 0x92, 0, 0, 0}
    ,
    {0x84f0, 0x1f, 0, 0, 0}
    ,
    {0x84f1, 0xe5, 0, 0, 0}
    ,
    {0x84f2, 0x2f, 0, 0, 0}
    ,
    {0x84f3, 0xd3, 0, 0, 0}
    ,
    {0x84f4, 0x94, 0, 0, 0}
    ,
    {0x84f5, 0x00, 0, 0, 0}
    ,
    {0x84f6, 0x40, 0, 0, 0}
    ,
    {0x84f7, 0x04, 0, 0, 0}
    ,
    {0x84f8, 0xa2, 0, 0, 0}
    ,
    {0x84f9, 0x1e, 0, 0, 0}
    ,
    {0x84fa, 0x80, 0, 0, 0}
    ,
    {0x84fb, 0x01, 0, 0, 0}
    ,
    {0x84fc, 0xc3, 0, 0, 0}
    ,
    {0x84fd, 0x92, 0, 0, 0}
    ,
    {0x84fe, 0x1e, 0, 0, 0}
    ,
    {0x84ff, 0xe5, 0, 0, 0}
    ,
    {0x8500, 0x2e, 0, 0, 0}
    ,
    {0x8501, 0xd3, 0, 0, 0}
    ,
    {0x8502, 0x94, 0, 0, 0}
    ,
    {0x8503, 0x00, 0, 0, 0}
    ,
    {0x8504, 0x40, 0, 0, 0}
    ,
    {0x8505, 0x04, 0, 0, 0}
    ,
    {0x8506, 0xa2, 0, 0, 0}
    ,
    {0x8507, 0x1d, 0, 0, 0}
    ,
    {0x8508, 0x80, 0, 0, 0}
    ,
    {0x8509, 0x01, 0, 0, 0}
    ,
    {0x850a, 0xc3, 0, 0, 0}
    ,
    {0x850b, 0x92, 0, 0, 0}
    ,
    {0x850c, 0x1d, 0, 0, 0}
    ,
    {0x850d, 0xe5, 0, 0, 0}
    ,
    {0x850e, 0x2d, 0, 0, 0}
    ,
    {0x850f, 0xd3, 0, 0, 0}
    ,
    {0x8510, 0x94, 0, 0, 0}
    ,
    {0x8511, 0x00, 0, 0, 0}
    ,
    {0x8512, 0x40, 0, 0, 0}
    ,
    {0x8513, 0x04, 0, 0, 0}
    ,
    {0x8514, 0xa2, 0, 0, 0}
    ,
    {0x8515, 0x1c, 0, 0, 0}
    ,
    {0x8516, 0x80, 0, 0, 0}
    ,
    {0x8517, 0x01, 0, 0, 0}
    ,
    {0x8518, 0xc3, 0, 0, 0}
    ,
    {0x8519, 0x92, 0, 0, 0}
    ,
    {0x851a, 0x1c, 0, 0, 0}
    ,
    {0x851b, 0xe5, 0, 0, 0}
    ,
    {0x851c, 0x2c, 0, 0, 0}
    ,
    {0x851d, 0xd3, 0, 0, 0}
    ,
    {0x851e, 0x94, 0, 0, 0}
    ,
    {0x851f, 0x00, 0, 0, 0}
    ,
    {0x8520, 0x40, 0, 0, 0}
    ,
    {0x8521, 0x04, 0, 0, 0}
    ,
    {0x8522, 0xa2, 0, 0, 0}
    ,
    {0x8523, 0x1b, 0, 0, 0}
    ,
    {0x8524, 0x80, 0, 0, 0}
    ,
    {0x8525, 0x01, 0, 0, 0}
    ,
    {0x8526, 0xc3, 0, 0, 0}
    ,
    {0x8527, 0x92, 0, 0, 0}
    ,
    {0x8528, 0x1b, 0, 0, 0}
    ,
    {0x8529, 0x85, 0, 0, 0}
    ,
    {0x852a, 0x0a, 0, 0, 0}
    ,
    {0x852b, 0x79, 0, 0, 0}
    ,
    {0x852c, 0xd2, 0, 0, 0}
    ,
    {0x852d, 0x3a, 0, 0, 0}
    ,
    {0x852e, 0xe5, 0, 0, 0}
    ,
    {0x852f, 0x7d, 0, 0, 0}
    ,
    {0x8530, 0xb5, 0, 0, 0}
    ,
    {0x8531, 0x0b, 0, 0, 0}
    ,
    {0x8532, 0x03, 0, 0, 0}
    ,
    {0x8533, 0x02, 0, 0, 0}
    ,
    {0x8534, 0x16, 0, 0, 0}
    ,
    {0x8535, 0x59, 0, 0, 0}
    ,
    {0x8536, 0x85, 0, 0, 0}
    ,
    {0x8537, 0x0b, 0, 0, 0}
    ,
    {0x8538, 0x0c, 0, 0, 0}
    ,
    {0x8539, 0x12, 0, 0, 0}
    ,
    {0x853a, 0x13, 0, 0, 0}
    ,
    {0x853b, 0x6b, 0, 0, 0}
    ,
    {0x853c, 0xd2, 0, 0, 0}
    ,
    {0x853d, 0x02, 0, 0, 0}
    ,
    {0x853e, 0xc2, 0, 0, 0}
    ,
    {0x853f, 0x01, 0, 0, 0}
    ,
    {0x8540, 0xd2, 0, 0, 0}
    ,
    {0x8541, 0x00, 0, 0, 0}
    ,
    {0x8542, 0x75, 0, 0, 0}
    ,
    {0x8543, 0x31, 0, 0, 0}
    ,
    {0x8544, 0x03, 0, 0, 0}
    ,
    {0x8545, 0x22, 0, 0, 0}
    ,
    {0x8546, 0xe5, 0, 0, 0}
    ,
    {0x8547, 0x7e, 0, 0, 0}
    ,
    {0x8548, 0x24, 0, 0, 0}
    ,
    {0x8549, 0xfe, 0, 0, 0}
    ,
    {0x854a, 0x60, 0, 0, 0}
    ,
    {0x854b, 0x27, 0, 0, 0}
    ,
    {0x854c, 0x14, 0, 0, 0}
    ,
    {0x854d, 0x60, 0, 0, 0}
    ,
    {0x854e, 0x31, 0, 0, 0}
    ,
    {0x854f, 0x24, 0, 0, 0}
    ,
    {0x8550, 0xf8, 0, 0, 0}
    ,
    {0x8551, 0x60, 0, 0, 0}
    ,
    {0x8552, 0x3a, 0, 0, 0}
    ,
    {0x8553, 0x14, 0, 0, 0}
    ,
    {0x8554, 0x60, 0, 0, 0}
    ,
    {0x8555, 0x4b, 0, 0, 0}
    ,
    {0x8556, 0x14, 0, 0, 0}
    ,
    {0x8557, 0x60, 0, 0, 0}
    ,
    {0x8558, 0x59, 0, 0, 0}
    ,
    {0x8559, 0x14, 0, 0, 0}
    ,
    {0x855a, 0x60, 0, 0, 0}
    ,
    {0x855b, 0x6a, 0, 0, 0}
    ,
    {0x855c, 0x24, 0, 0, 0}
    ,
    {0x855d, 0xfd, 0, 0, 0}
    ,
    {0x855e, 0x70, 0, 0, 0}
    ,
    {0x855f, 0x03, 0, 0, 0}
    ,
    {0x8560, 0x02, 0, 0, 0}
    ,
    {0x8561, 0x05, 0, 0, 0}
    ,
    {0x8562, 0xf8, 0, 0, 0}
    ,
    {0x8563, 0x24, 0, 0, 0}
    ,
    {0x8564, 0x10, 0, 0, 0}
    ,
    {0x8565, 0x60, 0, 0, 0}
    ,
    {0x8566, 0x03, 0, 0, 0}
    ,
    {0x8567, 0x02, 0, 0, 0}
    ,
    {0x8568, 0x06, 0, 0, 0}
    ,
    {0x8569, 0xf3, 0, 0, 0}
    ,
    {0x856a, 0xe4, 0, 0, 0}
    ,
    {0x856b, 0xf5, 0, 0, 0}
    ,
    {0x856c, 0x0a, 0, 0, 0}
    ,
    {0x856d, 0x12, 0, 0, 0}
    ,
    {0x856e, 0x12, 0, 0, 0}
    ,
    {0x856f, 0xa3, 0, 0, 0}
    ,
    {0x8570, 0x02, 0, 0, 0}
    ,
    {0x8571, 0x06, 0, 0, 0}
    ,
    {0x8572, 0xdc, 0, 0, 0}
    ,
    {0x8573, 0x75, 0, 0, 0}
    ,
    {0x8574, 0x0a, 0, 0, 0}
    ,
    {0x8575, 0x01, 0, 0, 0}
    ,
    {0x8576, 0x12, 0, 0, 0}
    ,
    {0x8577, 0x06, 0, 0, 0}
    ,
    {0x8578, 0xf4, 0, 0, 0}
    ,
    {0x8579, 0xc2, 0, 0, 0}
    ,
    {0x857a, 0x3d, 0, 0, 0}
    ,
    {0x857b, 0xd2, 0, 0, 0}
    ,
    {0x857c, 0x3c, 0, 0, 0}
    ,
    {0x857d, 0x02, 0, 0, 0}
    ,
    {0x857e, 0x06, 0, 0, 0}
    ,
    {0x857f, 0xed, 0, 0, 0}
    ,
    {0x8580, 0x75, 0, 0, 0}
    ,
    {0x8581, 0x0a, 0, 0, 0}
    ,
    {0x8582, 0x02, 0, 0, 0}
    ,
    {0x8583, 0x12, 0, 0, 0}
    ,
    {0x8584, 0x06, 0, 0, 0}
    ,
    {0x8585, 0xf4, 0, 0, 0}
    ,
    {0x8586, 0xd2, 0, 0, 0}
    ,
    {0x8587, 0x3d, 0, 0, 0}
    ,
    {0x8588, 0xc2, 0, 0, 0}
    ,
    {0x8589, 0x3c, 0, 0, 0}
    ,
    {0x858a, 0x02, 0, 0, 0}
    ,
    {0x858b, 0x06, 0, 0, 0}
    ,
    {0x858c, 0xed, 0, 0, 0}
    ,
    {0x858d, 0x30, 0, 0, 0}
    ,
    {0x858e, 0x36, 0, 0, 0}
    ,
    {0x858f, 0x0c, 0, 0, 0}
    ,
    {0x8590, 0x20, 0, 0, 0}
    ,
    {0x8591, 0x3d, 0, 0, 0}
    ,
    {0x8592, 0x03, 0, 0, 0}
    ,
    {0x8593, 0x30, 0, 0, 0}
    ,
    {0x8594, 0x3c, 0, 0, 0}
    ,
    {0x8595, 0x06, 0, 0, 0}
    ,
    {0x8596, 0xe4, 0, 0, 0}
    ,
    {0x8597, 0xf5, 0, 0, 0}
    ,
    {0x8598, 0x0a, 0, 0, 0}
    ,
    {0x8599, 0x12, 0, 0, 0}
    ,
    {0x859a, 0x14, 0, 0, 0}
    ,
    {0x859b, 0x1c, 0, 0, 0}
    ,
    {0x859c, 0xd2, 0, 0, 0}
    ,
    {0x859d, 0x18, 0, 0, 0}
    ,
    {0x859e, 0xc2, 0, 0, 0}
    ,
    {0x859f, 0x19, 0, 0, 0}
    ,
    {0x85a0, 0x22, 0, 0, 0}
    ,
    {0x85a1, 0x30, 0, 0, 0}
    ,
    {0x85a2, 0x36, 0, 0, 0}
    ,
    {0x85a3, 0x09, 0, 0, 0}
    ,
    {0x85a4, 0x20, 0, 0, 0}
    ,
    {0x85a5, 0x3d, 0, 0, 0}
    ,
    {0x85a6, 0x03, 0, 0, 0}
    ,
    {0x85a7, 0x30, 0, 0, 0}
    ,
    {0x85a8, 0x3c, 0, 0, 0}
    ,
    {0x85a9, 0x03, 0, 0, 0}
    ,
    {0x85aa, 0x12, 0, 0, 0}
    ,
    {0x85ab, 0x07, 0, 0, 0}
    ,
    {0x85ac, 0x05, 0, 0, 0}
    ,
    {0x85ad, 0xd2, 0, 0, 0}
    ,
    {0x85ae, 0x18, 0, 0, 0}
    ,
    {0x85af, 0xd2, 0, 0, 0}
    ,
    {0x85b0, 0x19, 0, 0, 0}
    ,
    {0x85b1, 0x22, 0, 0, 0}
    ,
    {0x85b2, 0x30, 0, 0, 0}
    ,
    {0x85b3, 0x36, 0, 0, 0}
    ,
    {0x85b4, 0x0c, 0, 0, 0}
    ,
    {0x85b5, 0x20, 0, 0, 0}
    ,
    {0x85b6, 0x3d, 0, 0, 0}
    ,
    {0x85b7, 0x03, 0, 0, 0}
    ,
    {0x85b8, 0x30, 0, 0, 0}
    ,
    {0x85b9, 0x3c, 0, 0, 0}
    ,
    {0x85ba, 0x06, 0, 0, 0}
    ,
    {0x85bb, 0x75, 0, 0, 0}
    ,
    {0x85bc, 0x0a, 0, 0, 0}
    ,
    {0x85bd, 0x02, 0, 0, 0}
    ,
    {0x85be, 0x12, 0, 0, 0}
    ,
    {0x85bf, 0x14, 0, 0, 0}
    ,
    {0x85c0, 0x1c, 0, 0, 0}
    ,
    {0x85c1, 0xc2, 0, 0, 0}
    ,
    {0x85c2, 0x18, 0, 0, 0}
    ,
    {0x85c3, 0xd2, 0, 0, 0}
    ,
    {0x85c4, 0x19, 0, 0, 0}
    ,
    {0x85c5, 0x22, 0, 0, 0}
    ,
    {0x85c6, 0x20, 0, 0, 0}
    ,
    {0x85c7, 0x3d, 0, 0, 0}
    ,
    {0x85c8, 0x06, 0, 0, 0}
    ,
    {0x85c9, 0x20, 0, 0, 0}
    ,
    {0x85ca, 0x3c, 0, 0, 0}
    ,
    {0x85cb, 0x03, 0, 0, 0}
    ,
    {0x85cc, 0x02, 0, 0, 0}
    ,
    {0x85cd, 0x06, 0, 0, 0}
    ,
    {0x85ce, 0xf3, 0, 0, 0}
    ,
    {0x85cf, 0xe5, 0, 0, 0}
    ,
    {0x85d0, 0x79, 0, 0, 0}
    ,
    {0x85d1, 0xd3, 0, 0, 0}
    ,
    {0x85d2, 0x94, 0, 0, 0}
    ,
    {0x85d3, 0x03, 0, 0, 0}
    ,
    {0x85d4, 0x40, 0, 0, 0}
    ,
    {0x85d5, 0x04, 0, 0, 0}
    ,
    {0x85d6, 0x7f, 0, 0, 0}
    ,
    {0x85d7, 0x00, 0, 0, 0}
    ,
    {0x85d8, 0x80, 0, 0, 0}
    ,
    {0x85d9, 0x04, 0, 0, 0}
    ,
    {0x85da, 0xe5, 0, 0, 0}
    ,
    {0x85db, 0x79, 0, 0, 0}
    ,
    {0x85dc, 0x04, 0, 0, 0}
    ,
    {0x85dd, 0xff, 0, 0, 0}
    ,
    {0x85de, 0x8f, 0, 0, 0}
    ,
    {0x85df, 0x79, 0, 0, 0}
    ,
    {0x85e0, 0x30, 0, 0, 0}
    ,
    {0x85e1, 0x18, 0, 0, 0}
    ,
    {0x85e2, 0x06, 0, 0, 0}
    ,
    {0x85e3, 0x30, 0, 0, 0}
    ,
    {0x85e4, 0x19, 0, 0, 0}
    ,
    {0x85e5, 0x03, 0, 0, 0}
    ,
    {0x85e6, 0x12, 0, 0, 0}
    ,
    {0x85e7, 0x07, 0, 0, 0}
    ,
    {0x85e8, 0x05, 0, 0, 0}
    ,
    {0x85e9, 0x20, 0, 0, 0}
    ,
    {0x85ea, 0x18, 0, 0, 0}
    ,
    {0x85eb, 0x09, 0, 0, 0}
    ,
    {0x85ec, 0x30, 0, 0, 0}
    ,
    {0x85ed, 0x19, 0, 0, 0}
    ,
    {0x85ee, 0x06, 0, 0, 0}
    ,
    {0x85ef, 0x75, 0, 0, 0}
    ,
    {0x85f0, 0x0a, 0, 0, 0}
    ,
    {0x85f1, 0x02, 0, 0, 0}
    ,
    {0x85f2, 0x12, 0, 0, 0}
    ,
    {0x85f3, 0x14, 0, 0, 0}
    ,
    {0x85f4, 0x1c, 0, 0, 0}
    ,
    {0x85f5, 0xd2, 0, 0, 0}
    ,
    {0x85f6, 0x3a, 0, 0, 0}
    ,
    {0x85f7, 0x22, 0, 0, 0}
    ,
    {0x85f8, 0xe5, 0, 0, 0}
    ,
    {0x85f9, 0x68, 0, 0, 0}
    ,
    {0x85fa, 0xd3, 0, 0, 0}
    ,
    {0x85fb, 0x94, 0, 0, 0}
    ,
    {0x85fc, 0x38, 0, 0, 0}
    ,
    {0x85fd, 0x40, 0, 0, 0}
    ,
    {0x85fe, 0x04, 0, 0, 0}
    ,
    {0x85ff, 0x7f, 0, 0, 0}
    ,
    {0x8600, 0x34, 0, 0, 0}
    ,
    {0x8601, 0x80, 0, 0, 0}
    ,
    {0x8602, 0x02, 0, 0, 0}
    ,
    {0x8603, 0xaf, 0, 0, 0}
    ,
    {0x8604, 0x68, 0, 0, 0}
    ,
    {0x8605, 0x8f, 0, 0, 0}
    ,
    {0x8606, 0x68, 0, 0, 0}
    ,
    {0x8607, 0xe5, 0, 0, 0}
    ,
    {0x8608, 0x68, 0, 0, 0}
    ,
    {0x8609, 0xc3, 0, 0, 0}
    ,
    {0x860a, 0x94, 0, 0, 0}
    ,
    {0x860b, 0x08, 0, 0, 0}
    ,
    {0x860c, 0x50, 0, 0, 0}
    ,
    {0x860d, 0x04, 0, 0, 0}
    ,
    {0x860e, 0x7f, 0, 0, 0}
    ,
    {0x860f, 0x08, 0, 0, 0}
    ,
    {0x8610, 0x80, 0, 0, 0}
    ,
    {0x8611, 0x02, 0, 0, 0}
    ,
    {0x8612, 0xaf, 0, 0, 0}
    ,
    {0x8613, 0x68, 0, 0, 0}
    ,
    {0x8614, 0x8f, 0, 0, 0}
    ,
    {0x8615, 0x68, 0, 0, 0}
    ,
    {0x8616, 0xe5, 0, 0, 0}
    ,
    {0x8617, 0x69, 0, 0, 0}
    ,
    {0x8618, 0xd3, 0, 0, 0}
    ,
    {0x8619, 0x94, 0, 0, 0}
    ,
    {0x861a, 0x2a, 0, 0, 0}
    ,
    {0x861b, 0x40, 0, 0, 0}
    ,
    {0x861c, 0x04, 0, 0, 0}
    ,
    {0x861d, 0x7f, 0, 0, 0}
    ,
    {0x861e, 0x2a, 0, 0, 0}
    ,
    {0x861f, 0x80, 0, 0, 0}
    ,
    {0x8620, 0x02, 0, 0, 0}
    ,
    {0x8621, 0xaf, 0, 0, 0}
    ,
    {0x8622, 0x69, 0, 0, 0}
    ,
    {0x8623, 0x8f, 0, 0, 0}
    ,
    {0x8624, 0x69, 0, 0, 0}
    ,
    {0x8625, 0xe5, 0, 0, 0}
    ,
    {0x8626, 0x69, 0, 0, 0}
    ,
    {0x8627, 0xc3, 0, 0, 0}
    ,
    {0x8628, 0x94, 0, 0, 0}
    ,
    {0x8629, 0x06, 0, 0, 0}
    ,
    {0x862a, 0x50, 0, 0, 0}
    ,
    {0x862b, 0x04, 0, 0, 0}
    ,
    {0x862c, 0x7f, 0, 0, 0}
    ,
    {0x862d, 0x06, 0, 0, 0}
    ,
    {0x862e, 0x80, 0, 0, 0}
    ,
    {0x862f, 0x02, 0, 0, 0}
    ,
    {0x8630, 0xaf, 0, 0, 0}
    ,
    {0x8631, 0x69, 0, 0, 0}
    ,
    {0x8632, 0x8f, 0, 0, 0}
    ,
    {0x8633, 0x69, 0, 0, 0}
    ,
    {0x8634, 0xaf, 0, 0, 0}
    ,
    {0x8635, 0x68, 0, 0, 0}
    ,
    {0x8636, 0xef, 0, 0, 0}
    ,
    {0x8637, 0x24, 0, 0, 0}
    ,
    {0x8638, 0xf8, 0, 0, 0}
    ,
    {0x8639, 0xff, 0, 0, 0}
    ,
    {0x863a, 0xe4, 0, 0, 0}
    ,
    {0x863b, 0x34, 0, 0, 0}
    ,
    {0x863c, 0xff, 0, 0, 0}
    ,
    {0x863d, 0xfe, 0, 0, 0}
    ,
    {0x863e, 0xe4, 0, 0, 0}
    ,
    {0x863f, 0x8f, 0, 0, 0}
    ,
    {0x8640, 0x3f, 0, 0, 0}
    ,
    {0x8641, 0x8e, 0, 0, 0}
    ,
    {0x8642, 0x3e, 0, 0, 0}
    ,
    {0x8643, 0xf5, 0, 0, 0}
    ,
    {0x8644, 0x3d, 0, 0, 0}
    ,
    {0x8645, 0xf5, 0, 0, 0}
    ,
    {0x8646, 0x3c, 0, 0, 0}
    ,
    {0x8647, 0xac, 0, 0, 0}
    ,
    {0x8648, 0x3c, 0, 0, 0}
    ,
    {0x8649, 0x12, 0, 0, 0}
    ,
    {0x864a, 0x01, 0, 0, 0}
    ,
    {0x864b, 0xb7, 0, 0, 0}
    ,
    {0x864c, 0xaf, 0, 0, 0}
    ,
    {0x864d, 0x69, 0, 0, 0}
    ,
    {0x864e, 0xef, 0, 0, 0}
    ,
    {0x864f, 0x24, 0, 0, 0}
    ,
    {0x8650, 0xfa, 0, 0, 0}
    ,
    {0x8651, 0xff, 0, 0, 0}
    ,
    {0x8652, 0xe4, 0, 0, 0}
    ,
    {0x8653, 0x34, 0, 0, 0}
    ,
    {0x8654, 0xff, 0, 0, 0}
    ,
    {0x8655, 0x12, 0, 0, 0}
    ,
    {0x8656, 0x01, 0, 0, 0}
    ,
    {0x8657, 0x9a, 0, 0, 0}
    ,
    {0x8658, 0xaf, 0, 0, 0}
    ,
    {0x8659, 0x68, 0, 0, 0}
    ,
    {0x865a, 0xef, 0, 0, 0}
    ,
    {0x865b, 0x24, 0, 0, 0}
    ,
    {0x865c, 0x08, 0, 0, 0}
    ,
    {0x865d, 0xff, 0, 0, 0}
    ,
    {0x865e, 0xe4, 0, 0, 0}
    ,
    {0x865f, 0x33, 0, 0, 0}
    ,
    {0x8660, 0x12, 0, 0, 0}
    ,
    {0x8661, 0x01, 0, 0, 0}
    ,
    {0x8662, 0x9a, 0, 0, 0}
    ,
    {0x8663, 0xaf, 0, 0, 0}
    ,
    {0x8664, 0x69, 0, 0, 0}
    ,
    {0x8665, 0xef, 0, 0, 0}
    ,
    {0x8666, 0x24, 0, 0, 0}
    ,
    {0x8667, 0x06, 0, 0, 0}
    ,
    {0x8668, 0xff, 0, 0, 0}
    ,
    {0x8669, 0xe4, 0, 0, 0}
    ,
    {0x866a, 0x33, 0, 0, 0}
    ,
    {0x866b, 0xfe, 0, 0, 0}
    ,
    {0x866c, 0xe4, 0, 0, 0}
    ,
    {0x866d, 0xfc, 0, 0, 0}
    ,
    {0x866e, 0xfd, 0, 0, 0}
    ,
    {0x866f, 0xe5, 0, 0, 0}
    ,
    {0x8670, 0x3f, 0, 0, 0}
    ,
    {0x8671, 0x2f, 0, 0, 0}
    ,
    {0x8672, 0xf5, 0, 0, 0}
    ,
    {0x8673, 0x3f, 0, 0, 0}
    ,
    {0x8674, 0xe5, 0, 0, 0}
    ,
    {0x8675, 0x3e, 0, 0, 0}
    ,
    {0x8676, 0x3e, 0, 0, 0}
    ,
    {0x8677, 0xf5, 0, 0, 0}
    ,
    {0x8678, 0x3e, 0, 0, 0}
    ,
    {0x8679, 0xed, 0, 0, 0}
    ,
    {0x867a, 0x35, 0, 0, 0}
    ,
    {0x867b, 0x3d, 0, 0, 0}
    ,
    {0x867c, 0xf5, 0, 0, 0}
    ,
    {0x867d, 0x3d, 0, 0, 0}
    ,
    {0x867e, 0xec, 0, 0, 0}
    ,
    {0x867f, 0x35, 0, 0, 0}
    ,
    {0x8680, 0x3c, 0, 0, 0}
    ,
    {0x8681, 0xf5, 0, 0, 0}
    ,
    {0x8682, 0x3c, 0, 0, 0}
    ,
    {0x8683, 0xe4, 0, 0, 0}
    ,
    {0x8684, 0x25, 0, 0, 0}
    ,
    {0x8685, 0x3f, 0, 0, 0}
    ,
    {0x8686, 0xf5, 0, 0, 0}
    ,
    {0x8687, 0x37, 0, 0, 0}
    ,
    {0x8688, 0xe4, 0, 0, 0}
    ,
    {0x8689, 0x35, 0, 0, 0}
    ,
    {0x868a, 0x3e, 0, 0, 0}
    ,
    {0x868b, 0xf5, 0, 0, 0}
    ,
    {0x868c, 0x36, 0, 0, 0}
    ,
    {0x868d, 0xe4, 0, 0, 0}
    ,
    {0x868e, 0x35, 0, 0, 0}
    ,
    {0x868f, 0x3d, 0, 0, 0}
    ,
    {0x8690, 0xf5, 0, 0, 0}
    ,
    {0x8691, 0x35, 0, 0, 0}
    ,
    {0x8692, 0xe5, 0, 0, 0}
    ,
    {0x8693, 0x3c, 0, 0, 0}
    ,
    {0x8694, 0x34, 0, 0, 0}
    ,
    {0x8695, 0x08, 0, 0, 0}
    ,
    {0x8696, 0xf5, 0, 0, 0}
    ,
    {0x8697, 0x34, 0, 0, 0}
    ,
    {0x8698, 0xe4, 0, 0, 0}
    ,
    {0x8699, 0x25, 0, 0, 0}
    ,
    {0x869a, 0x3f, 0, 0, 0}
    ,
    {0x869b, 0xf5, 0, 0, 0}
    ,
    {0x869c, 0x3b, 0, 0, 0}
    ,
    {0x869d, 0xe4, 0, 0, 0}
    ,
    {0x869e, 0x35, 0, 0, 0}
    ,
    {0x869f, 0x3e, 0, 0, 0}
    ,
    {0x86a0, 0xf5, 0, 0, 0}
    ,
    {0x86a1, 0x3a, 0, 0, 0}
    ,
    {0x86a2, 0xe5, 0, 0, 0}
    ,
    {0x86a3, 0x3d, 0, 0, 0}
    ,
    {0x86a4, 0x34, 0, 0, 0}
    ,
    {0x86a5, 0x06, 0, 0, 0}
    ,
    {0x86a6, 0xf5, 0, 0, 0}
    ,
    {0x86a7, 0x39, 0, 0, 0}
    ,
    {0x86a8, 0xe4, 0, 0, 0}
    ,
    {0x86a9, 0x35, 0, 0, 0}
    ,
    {0x86aa, 0x3c, 0, 0, 0}
    ,
    {0x86ab, 0xf5, 0, 0, 0}
    ,
    {0x86ac, 0x38, 0, 0, 0}
    ,
    {0x86ad, 0xe5, 0, 0, 0}
    ,
    {0x86ae, 0x3f, 0, 0, 0}
    ,
    {0x86af, 0x24, 0, 0, 0}
    ,
    {0x86b0, 0xfa, 0, 0, 0}
    ,
    {0x86b1, 0xf5, 0, 0, 0}
    ,
    {0x86b2, 0x43, 0, 0, 0}
    ,
    {0x86b3, 0xe5, 0, 0, 0}
    ,
    {0x86b4, 0x3e, 0, 0, 0}
    ,
    {0x86b5, 0x34, 0, 0, 0}
    ,
    {0x86b6, 0xff, 0, 0, 0}
    ,
    {0x86b7, 0xf5, 0, 0, 0}
    ,
    {0x86b8, 0x42, 0, 0, 0}
    ,
    {0x86b9, 0xe5, 0, 0, 0}
    ,
    {0x86ba, 0x3d, 0, 0, 0}
    ,
    {0x86bb, 0x34, 0, 0, 0}
    ,
    {0x86bc, 0xff, 0, 0, 0}
    ,
    {0x86bd, 0xf5, 0, 0, 0}
    ,
    {0x86be, 0x41, 0, 0, 0}
    ,
    {0x86bf, 0xe5, 0, 0, 0}
    ,
    {0x86c0, 0x3c, 0, 0, 0}
    ,
    {0x86c1, 0x34, 0, 0, 0}
    ,
    {0x86c2, 0xff, 0, 0, 0}
    ,
    {0x86c3, 0xf5, 0, 0, 0}
    ,
    {0x86c4, 0x40, 0, 0, 0}
    ,
    {0x86c5, 0xe4, 0, 0, 0}
    ,
    {0x86c6, 0x25, 0, 0, 0}
    ,
    {0x86c7, 0x3f, 0, 0, 0}
    ,
    {0x86c8, 0xf5, 0, 0, 0}
    ,
    {0x86c9, 0x47, 0, 0, 0}
    ,
    {0x86ca, 0xe5, 0, 0, 0}
    ,
    {0x86cb, 0x3e, 0, 0, 0}
    ,
    {0x86cc, 0x34, 0, 0, 0}
    ,
    {0x86cd, 0xf8, 0, 0, 0}
    ,
    {0x86ce, 0xf5, 0, 0, 0}
    ,
    {0x86cf, 0x46, 0, 0, 0}
    ,
    {0x86d0, 0xe5, 0, 0, 0}
    ,
    {0x86d1, 0x3d, 0, 0, 0}
    ,
    {0x86d2, 0x34, 0, 0, 0}
    ,
    {0x86d3, 0xff, 0, 0, 0}
    ,
    {0x86d4, 0xf5, 0, 0, 0}
    ,
    {0x86d5, 0x45, 0, 0, 0}
    ,
    {0x86d6, 0xe5, 0, 0, 0}
    ,
    {0x86d7, 0x3c, 0, 0, 0}
    ,
    {0x86d8, 0x34, 0, 0, 0}
    ,
    {0x86d9, 0xff, 0, 0, 0}
    ,
    {0x86da, 0xf5, 0, 0, 0}
    ,
    {0x86db, 0x44, 0, 0, 0}
    ,
    {0x86dc, 0x75, 0, 0, 0}
    ,
    {0x86dd, 0x79, 0, 0, 0}
    ,
    {0x86de, 0x02, 0, 0, 0}
    ,
    {0x86df, 0x75, 0, 0, 0}
    ,
    {0x86e0, 0x0a, 0, 0, 0}
    ,
    {0x86e1, 0x01, 0, 0, 0}
    ,
    {0x86e2, 0x12, 0, 0, 0}
    ,
    {0x86e3, 0x14, 0, 0, 0}
    ,
    {0x86e4, 0x1c, 0, 0, 0}
    ,
    {0x86e5, 0xd2, 0, 0, 0}
    ,
    {0x86e6, 0x18, 0, 0, 0}
    ,
    {0x86e7, 0xd2, 0, 0, 0}
    ,
    {0x86e8, 0x19, 0, 0, 0}
    ,
    {0x86e9, 0xc2, 0, 0, 0}
    ,
    {0x86ea, 0x3d, 0, 0, 0}
    ,
    {0x86eb, 0xc2, 0, 0, 0}
    ,
    {0x86ec, 0x3c, 0, 0, 0}
    ,
    {0x86ed, 0xd2, 0, 0, 0}
    ,
    {0x86ee, 0x1a, 0, 0, 0}
    ,
    {0x86ef, 0xd2, 0, 0, 0}
    ,
    {0x86f0, 0x36, 0, 0, 0}
    ,
    {0x86f1, 0xd2, 0, 0, 0}
    ,
    {0x86f2, 0x30, 0, 0, 0}
    ,
    {0x86f3, 0x22, 0, 0, 0}
    ,
    {0x86f4, 0x12, 0, 0, 0}
    ,
    {0x86f5, 0x12, 0, 0, 0}
    ,
    {0x86f6, 0xa3, 0, 0, 0}
    ,
    {0x86f7, 0x75, 0, 0, 0}
    ,
    {0x86f8, 0x79, 0, 0, 0}
    ,
    {0x86f9, 0x02, 0, 0, 0}
    ,
    {0x86fa, 0xe4, 0, 0, 0}
    ,
    {0x86fb, 0xf5, 0, 0, 0}
    ,
    {0x86fc, 0x0a, 0, 0, 0}
    ,
    {0x86fd, 0x12, 0, 0, 0}
    ,
    {0x86fe, 0x14, 0, 0, 0}
    ,
    {0x86ff, 0x1c, 0, 0, 0}
    ,
    {0x8700, 0xd2, 0, 0, 0}
    ,
    {0x8701, 0x18, 0, 0, 0}
    ,
    {0x8702, 0xc2, 0, 0, 0}
    ,
    {0x8703, 0x19, 0, 0, 0}
    ,
    {0x8704, 0x22, 0, 0, 0}
    ,
    {0x8705, 0x75, 0, 0, 0}
    ,
    {0x8706, 0x0a, 0, 0, 0}
    ,
    {0x8707, 0x01, 0, 0, 0}
    ,
    {0x8708, 0x12, 0, 0, 0}
    ,
    {0x8709, 0x14, 0, 0, 0}
    ,
    {0x870a, 0x1c, 0, 0, 0}
    ,
    {0x870b, 0x22, 0, 0, 0}
    ,
    {0x870c, 0x90, 0, 0, 0}
    ,
    {0x870d, 0x38, 0, 0, 0}
    ,
    {0x870e, 0x04, 0, 0, 0}
    ,
    {0x870f, 0xe0, 0, 0, 0}
    ,
    {0x8710, 0xfe, 0, 0, 0}
    ,
    {0x8711, 0xa3, 0, 0, 0}
    ,
    {0x8712, 0xe0, 0, 0, 0}
    ,
    {0x8713, 0xfd, 0, 0, 0}
    ,
    {0x8714, 0xed, 0, 0, 0}
    ,
    {0x8715, 0xff, 0, 0, 0}
    ,
    {0x8716, 0xee, 0, 0, 0}
    ,
    {0x8717, 0x54, 0, 0, 0}
    ,
    {0x8718, 0x0f, 0, 0, 0}
    ,
    {0x8719, 0xf5, 0, 0, 0}
    ,
    {0x871a, 0x0e, 0, 0, 0}
    ,
    {0x871b, 0x8f, 0, 0, 0}
    ,
    {0x871c, 0x0f, 0, 0, 0}
    ,
    {0x871d, 0xa3, 0, 0, 0}
    ,
    {0x871e, 0xe0, 0, 0, 0}
    ,
    {0x871f, 0xfe, 0, 0, 0}
    ,
    {0x8720, 0xa3, 0, 0, 0}
    ,
    {0x8721, 0xe0, 0, 0, 0}
    ,
    {0x8722, 0xfd, 0, 0, 0}
    ,
    {0x8723, 0xed, 0, 0, 0}
    ,
    {0x8724, 0xff, 0, 0, 0}
    ,
    {0x8725, 0xee, 0, 0, 0}
    ,
    {0x8726, 0x54, 0, 0, 0}
    ,
    {0x8727, 0x07, 0, 0, 0}
    ,
    {0x8728, 0xf5, 0, 0, 0}
    ,
    {0x8729, 0x10, 0, 0, 0}
    ,
    {0x872a, 0x8f, 0, 0, 0}
    ,
    {0x872b, 0x11, 0, 0, 0}
    ,
    {0x872c, 0xe5, 0, 0, 0}
    ,
    {0x872d, 0x0e, 0, 0, 0}
    ,
    {0x872e, 0xc4, 0, 0, 0}
    ,
    {0x872f, 0xf8, 0, 0, 0}
    ,
    {0x8730, 0x54, 0, 0, 0}
    ,
    {0x8731, 0xf0, 0, 0, 0}
    ,
    {0x8732, 0xc8, 0, 0, 0}
    ,
    {0x8733, 0x68, 0, 0, 0}
    ,
    {0x8734, 0xf5, 0, 0, 0}
    ,
    {0x8735, 0x0e, 0, 0, 0}
    ,
    {0x8736, 0xe5, 0, 0, 0}
    ,
    {0x8737, 0x0f, 0, 0, 0}
    ,
    {0x8738, 0xc4, 0, 0, 0}
    ,
    {0x8739, 0x54, 0, 0, 0}
    ,
    {0x873a, 0x0f, 0, 0, 0}
    ,
    {0x873b, 0x48, 0, 0, 0}
    ,
    {0x873c, 0xf5, 0, 0, 0}
    ,
    {0x873d, 0x0f, 0, 0, 0}
    ,
    {0x873e, 0xe5, 0, 0, 0}
    ,
    {0x873f, 0x10, 0, 0, 0}
    ,
    {0x8740, 0xc4, 0, 0, 0}
    ,
    {0x8741, 0xf8, 0, 0, 0}
    ,
    {0x8742, 0x54, 0, 0, 0}
    ,
    {0x8743, 0xf0, 0, 0, 0}
    ,
    {0x8744, 0xc8, 0, 0, 0}
    ,
    {0x8745, 0x68, 0, 0, 0}
    ,
    {0x8746, 0xf5, 0, 0, 0}
    ,
    {0x8747, 0x10, 0, 0, 0}
    ,
    {0x8748, 0xe5, 0, 0, 0}
    ,
    {0x8749, 0x11, 0, 0, 0}
    ,
    {0x874a, 0xc4, 0, 0, 0}
    ,
    {0x874b, 0x54, 0, 0, 0}
    ,
    {0x874c, 0x0f, 0, 0, 0}
    ,
    {0x874d, 0x48, 0, 0, 0}
    ,
    {0x874e, 0xf5, 0, 0, 0}
    ,
    {0x874f, 0x11, 0, 0, 0}
    ,
    {0x8750, 0xe4, 0, 0, 0}
    ,
    {0x8751, 0xf5, 0, 0, 0}
    ,
    {0x8752, 0x17, 0, 0, 0}
    ,
    {0x8753, 0x75, 0, 0, 0}
    ,
    {0x8754, 0x16, 0, 0, 0}
    ,
    {0x8755, 0x04, 0, 0, 0}
    ,
    {0x8756, 0x12, 0, 0, 0}
    ,
    {0x8757, 0x02, 0, 0, 0}
    ,
    {0x8758, 0x8f, 0, 0, 0}
    ,
    {0x8759, 0x24, 0, 0, 0}
    ,
    {0x875a, 0x34, 0, 0, 0}
    ,
    {0x875b, 0xf8, 0, 0, 0}
    ,
    {0x875c, 0xe6, 0, 0, 0}
    ,
    {0x875d, 0xf5, 0, 0, 0}
    ,
    {0x875e, 0x12, 0, 0, 0}
    ,
    {0x875f, 0x12, 0, 0, 0}
    ,
    {0x8760, 0x02, 0, 0, 0}
    ,
    {0x8761, 0x8f, 0, 0, 0}
    ,
    {0x8762, 0x24, 0, 0, 0}
    ,
    {0x8763, 0x35, 0, 0, 0}
    ,
    {0x8764, 0xf8, 0, 0, 0}
    ,
    {0x8765, 0xe6, 0, 0, 0}
    ,
    {0x8766, 0xf5, 0, 0, 0}
    ,
    {0x8767, 0x14, 0, 0, 0}
    ,
    {0x8768, 0x12, 0, 0, 0}
    ,
    {0x8769, 0x02, 0, 0, 0}
    ,
    {0x876a, 0x8f, 0, 0, 0}
    ,
    {0x876b, 0x24, 0, 0, 0}
    ,
    {0x876c, 0x36, 0, 0, 0}
    ,
    {0x876d, 0xf8, 0, 0, 0}
    ,
    {0x876e, 0xe6, 0, 0, 0}
    ,
    {0x876f, 0xf5, 0, 0, 0}
    ,
    {0x8770, 0x13, 0, 0, 0}
    ,
    {0x8771, 0x12, 0, 0, 0}
    ,
    {0x8772, 0x02, 0, 0, 0}
    ,
    {0x8773, 0x8f, 0, 0, 0}
    ,
    {0x8774, 0x24, 0, 0, 0}
    ,
    {0x8775, 0x37, 0, 0, 0}
    ,
    {0x8776, 0xf8, 0, 0, 0}
    ,
    {0x8777, 0xe6, 0, 0, 0}
    ,
    {0x8778, 0xf5, 0, 0, 0}
    ,
    {0x8779, 0x15, 0, 0, 0}
    ,
    {0x877a, 0x12, 0, 0, 0}
    ,
    {0x877b, 0x02, 0, 0, 0}
    ,
    {0x877c, 0xa2, 0, 0, 0}
    ,
    {0x877d, 0xaf, 0, 0, 0}
    ,
    {0x877e, 0x12, 0, 0, 0}
    ,
    {0x877f, 0x12, 0, 0, 0}
    ,
    {0x8780, 0x01, 0, 0, 0}
    ,
    {0x8781, 0x42, 0, 0, 0}
    ,
    {0x8782, 0x8f, 0, 0, 0}
    ,
    {0x8783, 0x12, 0, 0, 0}
    ,
    {0x8784, 0x12, 0, 0, 0}
    ,
    {0x8785, 0x02, 0, 0, 0}
    ,
    {0x8786, 0xa2, 0, 0, 0}
    ,
    {0x8787, 0xaf, 0, 0, 0}
    ,
    {0x8788, 0x13, 0, 0, 0}
    ,
    {0x8789, 0x12, 0, 0, 0}
    ,
    {0x878a, 0x01, 0, 0, 0}
    ,
    {0x878b, 0x42, 0, 0, 0}
    ,
    {0x878c, 0x8f, 0, 0, 0}
    ,
    {0x878d, 0x13, 0, 0, 0}
    ,
    {0x878e, 0x12, 0, 0, 0}
    ,
    {0x878f, 0x02, 0, 0, 0}
    ,
    {0x8790, 0x19, 0, 0, 0}
    ,
    {0x8791, 0xaf, 0, 0, 0}
    ,
    {0x8792, 0x14, 0, 0, 0}
    ,
    {0x8793, 0xfc, 0, 0, 0}
    ,
    {0x8794, 0xfd, 0, 0, 0}
    ,
    {0x8795, 0xfe, 0, 0, 0}
    ,
    {0x8796, 0x12, 0, 0, 0}
    ,
    {0x8797, 0x08, 0, 0, 0}
    ,
    {0x8798, 0xae, 0, 0, 0}
    ,
    {0x8799, 0x12, 0, 0, 0}
    ,
    {0x879a, 0x01, 0, 0, 0}
    ,
    {0x879b, 0x61, 0, 0, 0}
    ,
    {0x879c, 0x7b, 0, 0, 0}
    ,
    {0x879d, 0x30, 0, 0, 0}
    ,
    {0x879e, 0x12, 0, 0, 0}
    ,
    {0x879f, 0x01, 0, 0, 0}
    ,
    {0x87a0, 0x5a, 0, 0, 0}
    ,
    {0x87a1, 0x8f, 0, 0, 0}
    ,
    {0x87a2, 0x14, 0, 0, 0}
    ,
    {0x87a3, 0x12, 0, 0, 0}
    ,
    {0x87a4, 0x02, 0, 0, 0}
    ,
    {0x87a5, 0x19, 0, 0, 0}
    ,
    {0x87a6, 0xaf, 0, 0, 0}
    ,
    {0x87a7, 0x15, 0, 0, 0}
    ,
    {0x87a8, 0xfc, 0, 0, 0}
    ,
    {0x87a9, 0xfd, 0, 0, 0}
    ,
    {0x87aa, 0xfe, 0, 0, 0}
    ,
    {0x87ab, 0x12, 0, 0, 0}
    ,
    {0x87ac, 0x08, 0, 0, 0}
    ,
    {0x87ad, 0xae, 0, 0, 0}
    ,
    {0x87ae, 0x12, 0, 0, 0}
    ,
    {0x87af, 0x01, 0, 0, 0}
    ,
    {0x87b0, 0x61, 0, 0, 0}
    ,
    {0x87b1, 0xe4, 0, 0, 0}
    ,
    {0x87b2, 0x7b, 0, 0, 0}
    ,
    {0x87b3, 0x30, 0, 0, 0}
    ,
    {0x87b4, 0x12, 0, 0, 0}
    ,
    {0x87b5, 0x01, 0, 0, 0}
    ,
    {0x87b6, 0x5b, 0, 0, 0}
    ,
    {0x87b7, 0x8f, 0, 0, 0}
    ,
    {0x87b8, 0x15, 0, 0, 0}
    ,
    {0x87b9, 0xc3, 0, 0, 0}
    ,
    {0x87ba, 0xe5, 0, 0, 0}
    ,
    {0x87bb, 0x13, 0, 0, 0}
    ,
    {0x87bc, 0x95, 0, 0, 0}
    ,
    {0x87bd, 0x12, 0, 0, 0}
    ,
    {0x87be, 0xff, 0, 0, 0}
    ,
    {0x87bf, 0x0f, 0, 0, 0}
    ,
    {0x87c0, 0xef, 0, 0, 0}
    ,
    {0x87c1, 0xc3, 0, 0, 0}
    ,
    {0x87c2, 0x13, 0, 0, 0}
    ,
    {0x87c3, 0xff, 0, 0, 0}
    ,
    {0x87c4, 0xc3, 0, 0, 0}
    ,
    {0x87c5, 0x94, 0, 0, 0}
    ,
    {0x87c6, 0x04, 0, 0, 0}
    ,
    {0x87c7, 0x50, 0, 0, 0}
    ,
    {0x87c8, 0x27, 0, 0, 0}
    ,
    {0x87c9, 0xe5, 0, 0, 0}
    ,
    {0x87ca, 0x12, 0, 0, 0}
    ,
    {0x87cb, 0x9f, 0, 0, 0}
    ,
    {0x87cc, 0x40, 0, 0, 0}
    ,
    {0x87cd, 0x06, 0, 0, 0}
    ,
    {0x87ce, 0xe5, 0, 0, 0}
    ,
    {0x87cf, 0x12, 0, 0, 0}
    ,
    {0x87d0, 0x9f, 0, 0, 0}
    ,
    {0x87d1, 0xfe, 0, 0, 0}
    ,
    {0x87d2, 0x80, 0, 0, 0}
    ,
    {0x87d3, 0x02, 0, 0, 0}
    ,
    {0x87d4, 0x7e, 0, 0, 0}
    ,
    {0x87d5, 0x00, 0, 0, 0}
    ,
    {0x87d6, 0x8e, 0, 0, 0}
    ,
    {0x87d7, 0x12, 0, 0, 0}
    ,
    {0x87d8, 0xef, 0, 0, 0}
    ,
    {0x87d9, 0xfd, 0, 0, 0}
    ,
    {0x87da, 0xe5, 0, 0, 0}
    ,
    {0x87db, 0x13, 0, 0, 0}
    ,
    {0x87dc, 0x2d, 0, 0, 0}
    ,
    {0x87dd, 0xfd, 0, 0, 0}
    ,
    {0x87de, 0xe4, 0, 0, 0}
    ,
    {0x87df, 0x33, 0, 0, 0}
    ,
    {0x87e0, 0xfc, 0, 0, 0}
    ,
    {0x87e1, 0xc3, 0, 0, 0}
    ,
    {0x87e2, 0xed, 0, 0, 0}
    ,
    {0x87e3, 0x95, 0, 0, 0}
    ,
    {0x87e4, 0x0f, 0, 0, 0}
    ,
    {0x87e5, 0xec, 0, 0, 0}
    ,
    {0x87e6, 0x95, 0, 0, 0}
    ,
    {0x87e7, 0x0e, 0, 0, 0}
    ,
    {0x87e8, 0x50, 0, 0, 0}
    ,
    {0x87e9, 0x02, 0, 0, 0}
    ,
    {0x87ea, 0x80, 0, 0, 0}
    ,
    {0x87eb, 0x02, 0, 0, 0}
    ,
    {0x87ec, 0xad, 0, 0, 0}
    ,
    {0x87ed, 0x0f, 0, 0, 0}
    ,
    {0x87ee, 0x8d, 0, 0, 0}
    ,
    {0x87ef, 0x13, 0, 0, 0}
    ,
    {0x87f0, 0xc3, 0, 0, 0}
    ,
    {0x87f1, 0xe5, 0, 0, 0}
    ,
    {0x87f2, 0x15, 0, 0, 0}
    ,
    {0x87f3, 0x95, 0, 0, 0}
    ,
    {0x87f4, 0x14, 0, 0, 0}
    ,
    {0x87f5, 0xff, 0, 0, 0}
    ,
    {0x87f6, 0xc3, 0, 0, 0}
    ,
    {0x87f7, 0x94, 0, 0, 0}
    ,
    {0x87f8, 0x04, 0, 0, 0}
    ,
    {0x87f9, 0x50, 0, 0, 0}
    ,
    {0x87fa, 0x29, 0, 0, 0}
    ,
    {0x87fb, 0xe5, 0, 0, 0}
    ,
    {0x87fc, 0x14, 0, 0, 0}
    ,
    {0x87fd, 0x9f, 0, 0, 0}
    ,
    {0x87fe, 0x40, 0, 0, 0}
    ,
    {0x87ff, 0x06, 0, 0, 0}
    ,
    {0x8800, 0xe5, 0, 0, 0}
    ,
    {0x8801, 0x14, 0, 0, 0}
    ,
    {0x8802, 0x9f, 0, 0, 0}
    ,
    {0x8803, 0xfe, 0, 0, 0}
    ,
    {0x8804, 0x80, 0, 0, 0}
    ,
    {0x8805, 0x02, 0, 0, 0}
    ,
    {0x8806, 0x7e, 0, 0, 0}
    ,
    {0x8807, 0x00, 0, 0, 0}
    ,
    {0x8808, 0x8e, 0, 0, 0}
    ,
    {0x8809, 0x14, 0, 0, 0}
    ,
    {0x880a, 0xef, 0, 0, 0}
    ,
    {0x880b, 0xfd, 0, 0, 0}
    ,
    {0x880c, 0xe5, 0, 0, 0}
    ,
    {0x880d, 0x15, 0, 0, 0}
    ,
    {0x880e, 0x2d, 0, 0, 0}
    ,
    {0x880f, 0xfd, 0, 0, 0}
    ,
    {0x8810, 0xe4, 0, 0, 0}
    ,
    {0x8811, 0x33, 0, 0, 0}
    ,
    {0x8812, 0xfc, 0, 0, 0}
    ,
    {0x8813, 0xc3, 0, 0, 0}
    ,
    {0x8814, 0xed, 0, 0, 0}
    ,
    {0x8815, 0x95, 0, 0, 0}
    ,
    {0x8816, 0x11, 0, 0, 0}
    ,
    {0x8817, 0xec, 0, 0, 0}
    ,
    {0x8818, 0x95, 0, 0, 0}
    ,
    {0x8819, 0x10, 0, 0, 0}
    ,
    {0x881a, 0x50, 0, 0, 0}
    ,
    {0x881b, 0x04, 0, 0, 0}
    ,
    {0x881c, 0xaf, 0, 0, 0}
    ,
    {0x881d, 0x05, 0, 0, 0}
    ,
    {0x881e, 0x80, 0, 0, 0}
    ,
    {0x881f, 0x02, 0, 0, 0}
    ,
    {0x8820, 0xaf, 0, 0, 0}
    ,
    {0x8821, 0x11, 0, 0, 0}
    ,
    {0x8822, 0x8f, 0, 0, 0}
    ,
    {0x8823, 0x15, 0, 0, 0}
    ,
    {0x8824, 0xe5, 0, 0, 0}
    ,
    {0x8825, 0x15, 0, 0, 0}
    ,
    {0x8826, 0xd3, 0, 0, 0}
    ,
    {0x8827, 0x95, 0, 0, 0}
    ,
    {0x8828, 0x17, 0, 0, 0}
    ,
    {0x8829, 0x40, 0, 0, 0}
    ,
    {0x882a, 0x04, 0, 0, 0}
    ,
    {0x882b, 0xaf, 0, 0, 0}
    ,
    {0x882c, 0x15, 0, 0, 0}
    ,
    {0x882d, 0x80, 0, 0, 0}
    ,
    {0x882e, 0x02, 0, 0, 0}
    ,
    {0x882f, 0xaf, 0, 0, 0}
    ,
    {0x8830, 0x17, 0, 0, 0}
    ,
    {0x8831, 0x8f, 0, 0, 0}
    ,
    {0x8832, 0x17, 0, 0, 0}
    ,
    {0x8833, 0xd3, 0, 0, 0}
    ,
    {0x8834, 0xe5, 0, 0, 0}
    ,
    {0x8835, 0x16, 0, 0, 0}
    ,
    {0x8836, 0x64, 0, 0, 0}
    ,
    {0x8837, 0x80, 0, 0, 0}
    ,
    {0x8838, 0x94, 0, 0, 0}
    ,
    {0x8839, 0x80, 0, 0, 0}
    ,
    {0x883a, 0x40, 0, 0, 0}
    ,
    {0x883b, 0x04, 0, 0, 0}
    ,
    {0x883c, 0xaf, 0, 0, 0}
    ,
    {0x883d, 0x15, 0, 0, 0}
    ,
    {0x883e, 0x80, 0, 0, 0}
    ,
    {0x883f, 0x02, 0, 0, 0}
    ,
    {0x8840, 0xaf, 0, 0, 0}
    ,
    {0x8841, 0x17, 0, 0, 0}
    ,
    {0x8842, 0x8f, 0, 0, 0}
    ,
    {0x8843, 0x15, 0, 0, 0}
    ,
    {0x8844, 0xe5, 0, 0, 0}
    ,
    {0x8845, 0x16, 0, 0, 0}
    ,
    {0x8846, 0xfd, 0, 0, 0}
    ,
    {0x8847, 0x33, 0, 0, 0}
    ,
    {0x8848, 0x95, 0, 0, 0}
    ,
    {0x8849, 0xe0, 0, 0, 0}
    ,
    {0x884a, 0xfc, 0, 0, 0}
    ,
    {0x884b, 0xed, 0, 0, 0}
    ,
    {0x884c, 0xae, 0, 0, 0}
    ,
    {0x884d, 0x04, 0, 0, 0}
    ,
    {0x884e, 0x78, 0, 0, 0}
    ,
    {0x884f, 0x02, 0, 0, 0}
    ,
    {0x8850, 0xc3, 0, 0, 0}
    ,
    {0x8851, 0x33, 0, 0, 0}
    ,
    {0x8852, 0xce, 0, 0, 0}
    ,
    {0x8853, 0x33, 0, 0, 0}
    ,
    {0x8854, 0xce, 0, 0, 0}
    ,
    {0x8855, 0xd8, 0, 0, 0}
    ,
    {0x8856, 0xf9, 0, 0, 0}
    ,
    {0x8857, 0xff, 0, 0, 0}
    ,
    {0x8858, 0x24, 0, 0, 0}
    ,
    {0x8859, 0x01, 0, 0, 0}
    ,
    {0x885a, 0xfb, 0, 0, 0}
    ,
    {0x885b, 0xee, 0, 0, 0}
    ,
    {0x885c, 0x34, 0, 0, 0}
    ,
    {0x885d, 0x60, 0, 0, 0}
    ,
    {0x885e, 0x8b, 0, 0, 0}
    ,
    {0x885f, 0x82, 0, 0, 0}
    ,
    {0x8860, 0xf5, 0, 0, 0}
    ,
    {0x8861, 0x83, 0, 0, 0}
    ,
    {0x8862, 0xe5, 0, 0, 0}
    ,
    {0x8863, 0x12, 0, 0, 0}
    ,
    {0x8864, 0xf0, 0, 0, 0}
    ,
    {0x8865, 0xef, 0, 0, 0}
    ,
    {0x8866, 0x24, 0, 0, 0}
    ,
    {0x8867, 0x02, 0, 0, 0}
    ,
    {0x8868, 0xff, 0, 0, 0}
    ,
    {0x8869, 0xee, 0, 0, 0}
    ,
    {0x886a, 0x34, 0, 0, 0}
    ,
    {0x886b, 0x60, 0, 0, 0}
    ,
    {0x886c, 0x8f, 0, 0, 0}
    ,
    {0x886d, 0x82, 0, 0, 0}
    ,
    {0x886e, 0xf5, 0, 0, 0}
    ,
    {0x886f, 0x83, 0, 0, 0}
    ,
    {0x8870, 0xe5, 0, 0, 0}
    ,
    {0x8871, 0x14, 0, 0, 0}
    ,
    {0x8872, 0xf0, 0, 0, 0}
    ,
    {0x8873, 0xed, 0, 0, 0}
    ,
    {0x8874, 0xae, 0, 0, 0}
    ,
    {0x8875, 0x04, 0, 0, 0}
    ,
    {0x8876, 0x78, 0, 0, 0}
    ,
    {0x8877, 0x02, 0, 0, 0}
    ,
    {0x8878, 0xc3, 0, 0, 0}
    ,
    {0x8879, 0x33, 0, 0, 0}
    ,
    {0x887a, 0xce, 0, 0, 0}
    ,
    {0x887b, 0x33, 0, 0, 0}
    ,
    {0x887c, 0xce, 0, 0, 0}
    ,
    {0x887d, 0xd8, 0, 0, 0}
    ,
    {0x887e, 0xf9, 0, 0, 0}
    ,
    {0x887f, 0xff, 0, 0, 0}
    ,
    {0x8880, 0x24, 0, 0, 0}
    ,
    {0x8881, 0x03, 0, 0, 0}
    ,
    {0x8882, 0xfd, 0, 0, 0}
    ,
    {0x8883, 0xee, 0, 0, 0}
    ,
    {0x8884, 0x34, 0, 0, 0}
    ,
    {0x8885, 0x60, 0, 0, 0}
    ,
    {0x8886, 0x8d, 0, 0, 0}
    ,
    {0x8887, 0x82, 0, 0, 0}
    ,
    {0x8888, 0xf5, 0, 0, 0}
    ,
    {0x8889, 0x83, 0, 0, 0}
    ,
    {0x888a, 0xe5, 0, 0, 0}
    ,
    {0x888b, 0x13, 0, 0, 0}
    ,
    {0x888c, 0xf0, 0, 0, 0}
    ,
    {0x888d, 0xef, 0, 0, 0}
    ,
    {0x888e, 0x24, 0, 0, 0}
    ,
    {0x888f, 0x04, 0, 0, 0}
    ,
    {0x8890, 0xff, 0, 0, 0}
    ,
    {0x8891, 0xee, 0, 0, 0}
    ,
    {0x8892, 0x34, 0, 0, 0}
    ,
    {0x8893, 0x60, 0, 0, 0}
    ,
    {0x8894, 0x8f, 0, 0, 0}
    ,
    {0x8895, 0x82, 0, 0, 0}
    ,
    {0x8896, 0xf5, 0, 0, 0}
    ,
    {0x8897, 0x83, 0, 0, 0}
    ,
    {0x8898, 0xe5, 0, 0, 0}
    ,
    {0x8899, 0x15, 0, 0, 0}
    ,
    {0x889a, 0xf0, 0, 0, 0}
    ,
    {0x889b, 0x15, 0, 0, 0}
    ,
    {0x889c, 0x16, 0, 0, 0}
    ,
    {0x889d, 0xc3, 0, 0, 0}
    ,
    {0x889e, 0xe5, 0, 0, 0}
    ,
    {0x889f, 0x16, 0, 0, 0}
    ,
    {0x88a0, 0x64, 0, 0, 0}
    ,
    {0x88a1, 0x80, 0, 0, 0}
    ,
    {0x88a2, 0x94, 0, 0, 0}
    ,
    {0x88a3, 0x80, 0, 0, 0}
    ,
    {0x88a4, 0x40, 0, 0, 0}
    ,
    {0x88a5, 0x03, 0, 0, 0}
    ,
    {0x88a6, 0x02, 0, 0, 0}
    ,
    {0x88a7, 0x07, 0, 0, 0}
    ,
    {0x88a8, 0x56, 0, 0, 0}
    ,
    {0x88a9, 0xd2, 0, 0, 0}
    ,
    {0x88aa, 0x3a, 0, 0, 0}
    ,
    {0x88ab, 0xc2, 0, 0, 0}
    ,
    {0x88ac, 0x30, 0, 0, 0}
    ,
    {0x88ad, 0x22, 0, 0, 0}
    ,
    {0x88ae, 0xe8, 0, 0, 0}
    ,
    {0x88af, 0x8f, 0, 0, 0}
    ,
    {0x88b0, 0xf0, 0, 0, 0}
    ,
    {0x88b1, 0xa4, 0, 0, 0}
    ,
    {0x88b2, 0xcc, 0, 0, 0}
    ,
    {0x88b3, 0x8b, 0, 0, 0}
    ,
    {0x88b4, 0xf0, 0, 0, 0}
    ,
    {0x88b5, 0xa4, 0, 0, 0}
    ,
    {0x88b6, 0x2c, 0, 0, 0}
    ,
    {0x88b7, 0xfc, 0, 0, 0}
    ,
    {0x88b8, 0xe9, 0, 0, 0}
    ,
    {0x88b9, 0x8e, 0, 0, 0}
    ,
    {0x88ba, 0xf0, 0, 0, 0}
    ,
    {0x88bb, 0xa4, 0, 0, 0}
    ,
    {0x88bc, 0x2c, 0, 0, 0}
    ,
    {0x88bd, 0xfc, 0, 0, 0}
    ,
    {0x88be, 0x8a, 0, 0, 0}
    ,
    {0x88bf, 0xf0, 0, 0, 0}
    ,
    {0x88c0, 0xed, 0, 0, 0}
    ,
    {0x88c1, 0xa4, 0, 0, 0}
    ,
    {0x88c2, 0x2c, 0, 0, 0}
    ,
    {0x88c3, 0xfc, 0, 0, 0}
    ,
    {0x88c4, 0xea, 0, 0, 0}
    ,
    {0x88c5, 0x8e, 0, 0, 0}
    ,
    {0x88c6, 0xf0, 0, 0, 0}
    ,
    {0x88c7, 0xa4, 0, 0, 0}
    ,
    {0x88c8, 0xcd, 0, 0, 0}
    ,
    {0x88c9, 0xa8, 0, 0, 0}
    ,
    {0x88ca, 0xf0, 0, 0, 0}
    ,
    {0x88cb, 0x8b, 0, 0, 0}
    ,
    {0x88cc, 0xf0, 0, 0, 0}
    ,
    {0x88cd, 0xa4, 0, 0, 0}
    ,
    {0x88ce, 0x2d, 0, 0, 0}
    ,
    {0x88cf, 0xcc, 0, 0, 0}
    ,
    {0x88d0, 0x38, 0, 0, 0}
    ,
    {0x88d1, 0x25, 0, 0, 0}
    ,
    {0x88d2, 0xf0, 0, 0, 0}
    ,
    {0x88d3, 0xfd, 0, 0, 0}
    ,
    {0x88d4, 0xe9, 0, 0, 0}
    ,
    {0x88d5, 0x8f, 0, 0, 0}
    ,
    {0x88d6, 0xf0, 0, 0, 0}
    ,
    {0x88d7, 0xa4, 0, 0, 0}
    ,
    {0x88d8, 0x2c, 0, 0, 0}
    ,
    {0x88d9, 0xcd, 0, 0, 0}
    ,
    {0x88da, 0x35, 0, 0, 0}
    ,
    {0x88db, 0xf0, 0, 0, 0}
    ,
    {0x88dc, 0xfc, 0, 0, 0}
    ,
    {0x88dd, 0xeb, 0, 0, 0}
    ,
    {0x88de, 0x8e, 0, 0, 0}
    ,
    {0x88df, 0xf0, 0, 0, 0}
    ,
    {0x88e0, 0xa4, 0, 0, 0}
    ,
    {0x88e1, 0xfe, 0, 0, 0}
    ,
    {0x88e2, 0xa9, 0, 0, 0}
    ,
    {0x88e3, 0xf0, 0, 0, 0}
    ,
    {0x88e4, 0xeb, 0, 0, 0}
    ,
    {0x88e5, 0x8f, 0, 0, 0}
    ,
    {0x88e6, 0xf0, 0, 0, 0}
    ,
    {0x88e7, 0xa4, 0, 0, 0}
    ,
    {0x88e8, 0xcf, 0, 0, 0}
    ,
    {0x88e9, 0xc5, 0, 0, 0}
    ,
    {0x88ea, 0xf0, 0, 0, 0}
    ,
    {0x88eb, 0x2e, 0, 0, 0}
    ,
    {0x88ec, 0xcd, 0, 0, 0}
    ,
    {0x88ed, 0x39, 0, 0, 0}
    ,
    {0x88ee, 0xfe, 0, 0, 0}
    ,
    {0x88ef, 0xe4, 0, 0, 0}
    ,
    {0x88f0, 0x3c, 0, 0, 0}
    ,
    {0x88f1, 0xfc, 0, 0, 0}
    ,
    {0x88f2, 0xea, 0, 0, 0}
    ,
    {0x88f3, 0xa4, 0, 0, 0}
    ,
    {0x88f4, 0x2d, 0, 0, 0}
    ,
    {0x88f5, 0xce, 0, 0, 0}
    ,
    {0x88f6, 0x35, 0, 0, 0}
    ,
    {0x88f7, 0xf0, 0, 0, 0}
    ,
    {0x88f8, 0xfd, 0, 0, 0}
    ,
    {0x88f9, 0xe4, 0, 0, 0}
    ,
    {0x88fa, 0x3c, 0, 0, 0}
    ,
    {0x88fb, 0xfc, 0, 0, 0}
    ,
    {0x88fc, 0x22, 0, 0, 0}
    ,
    {0x88fd, 0x75, 0, 0, 0}
    ,
    {0x88fe, 0xf0, 0, 0, 0}
    ,
    {0x88ff, 0x08, 0, 0, 0}
    ,
    {0x8900, 0x75, 0, 0, 0}
    ,
    {0x8901, 0x82, 0, 0, 0}
    ,
    {0x8902, 0x00, 0, 0, 0}
    ,
    {0x8903, 0xef, 0, 0, 0}
    ,
    {0x8904, 0x2f, 0, 0, 0}
    ,
    {0x8905, 0xff, 0, 0, 0}
    ,
    {0x8906, 0xee, 0, 0, 0}
    ,
    {0x8907, 0x33, 0, 0, 0}
    ,
    {0x8908, 0xfe, 0, 0, 0}
    ,
    {0x8909, 0xcd, 0, 0, 0}
    ,
    {0x890a, 0x33, 0, 0, 0}
    ,
    {0x890b, 0xcd, 0, 0, 0}
    ,
    {0x890c, 0xcc, 0, 0, 0}
    ,
    {0x890d, 0x33, 0, 0, 0}
    ,
    {0x890e, 0xcc, 0, 0, 0}
    ,
    {0x890f, 0xc5, 0, 0, 0}
    ,
    {0x8910, 0x82, 0, 0, 0}
    ,
    {0x8911, 0x33, 0, 0, 0}
    ,
    {0x8912, 0xc5, 0, 0, 0}
    ,
    {0x8913, 0x82, 0, 0, 0}
    ,
    {0x8914, 0x9b, 0, 0, 0}
    ,
    {0x8915, 0xed, 0, 0, 0}
    ,
    {0x8916, 0x9a, 0, 0, 0}
    ,
    {0x8917, 0xec, 0, 0, 0}
    ,
    {0x8918, 0x99, 0, 0, 0}
    ,
    {0x8919, 0xe5, 0, 0, 0}
    ,
    {0x891a, 0x82, 0, 0, 0}
    ,
    {0x891b, 0x98, 0, 0, 0}
    ,
    {0x891c, 0x40, 0, 0, 0}
    ,
    {0x891d, 0x0c, 0, 0, 0}
    ,
    {0x891e, 0xf5, 0, 0, 0}
    ,
    {0x891f, 0x82, 0, 0, 0}
    ,
    {0x8920, 0xee, 0, 0, 0}
    ,
    {0x8921, 0x9b, 0, 0, 0}
    ,
    {0x8922, 0xfe, 0, 0, 0}
    ,
    {0x8923, 0xed, 0, 0, 0}
    ,
    {0x8924, 0x9a, 0, 0, 0}
    ,
    {0x8925, 0xfd, 0, 0, 0}
    ,
    {0x8926, 0xec, 0, 0, 0}
    ,
    {0x8927, 0x99, 0, 0, 0}
    ,
    {0x8928, 0xfc, 0, 0, 0}
    ,
    {0x8929, 0x0f, 0, 0, 0}
    ,
    {0x892a, 0xd5, 0, 0, 0}
    ,
    {0x892b, 0xf0, 0, 0, 0}
    ,
    {0x892c, 0xd6, 0, 0, 0}
    ,
    {0x892d, 0xe4, 0, 0, 0}
    ,
    {0x892e, 0xce, 0, 0, 0}
    ,
    {0x892f, 0xfb, 0, 0, 0}
    ,
    {0x8930, 0xe4, 0, 0, 0}
    ,
    {0x8931, 0xcd, 0, 0, 0}
    ,
    {0x8932, 0xfa, 0, 0, 0}
    ,
    {0x8933, 0xe4, 0, 0, 0}
    ,
    {0x8934, 0xcc, 0, 0, 0}
    ,
    {0x8935, 0xf9, 0, 0, 0}
    ,
    {0x8936, 0xa8, 0, 0, 0}
    ,
    {0x8937, 0x82, 0, 0, 0}
    ,
    {0x8938, 0x22, 0, 0, 0}
    ,
    {0x8939, 0xb8, 0, 0, 0}
    ,
    {0x893a, 0x00, 0, 0, 0}
    ,
    {0x893b, 0xc1, 0, 0, 0}
    ,
    {0x893c, 0xb9, 0, 0, 0}
    ,
    {0x893d, 0x00, 0, 0, 0}
    ,
    {0x893e, 0x59, 0, 0, 0}
    ,
    {0x893f, 0xba, 0, 0, 0}
    ,
    {0x8940, 0x00, 0, 0, 0}
    ,
    {0x8941, 0x2d, 0, 0, 0}
    ,
    {0x8942, 0xec, 0, 0, 0}
    ,
    {0x8943, 0x8b, 0, 0, 0}
    ,
    {0x8944, 0xf0, 0, 0, 0}
    ,
    {0x8945, 0x84, 0, 0, 0}
    ,
    {0x8946, 0xcf, 0, 0, 0}
    ,
    {0x8947, 0xce, 0, 0, 0}
    ,
    {0x8948, 0xcd, 0, 0, 0}
    ,
    {0x8949, 0xfc, 0, 0, 0}
    ,
    {0x894a, 0xe5, 0, 0, 0}
    ,
    {0x894b, 0xf0, 0, 0, 0}
    ,
    {0x894c, 0xcb, 0, 0, 0}
    ,
    {0x894d, 0xf9, 0, 0, 0}
    ,
    {0x894e, 0x78, 0, 0, 0}
    ,
    {0x894f, 0x18, 0, 0, 0}
    ,
    {0x8950, 0xef, 0, 0, 0}
    ,
    {0x8951, 0x2f, 0, 0, 0}
    ,
    {0x8952, 0xff, 0, 0, 0}
    ,
    {0x8953, 0xee, 0, 0, 0}
    ,
    {0x8954, 0x33, 0, 0, 0}
    ,
    {0x8955, 0xfe, 0, 0, 0}
    ,
    {0x8956, 0xed, 0, 0, 0}
    ,
    {0x8957, 0x33, 0, 0, 0}
    ,
    {0x8958, 0xfd, 0, 0, 0}
    ,
    {0x8959, 0xec, 0, 0, 0}
    ,
    {0x895a, 0x33, 0, 0, 0}
    ,
    {0x895b, 0xfc, 0, 0, 0}
    ,
    {0x895c, 0xeb, 0, 0, 0}
    ,
    {0x895d, 0x33, 0, 0, 0}
    ,
    {0x895e, 0xfb, 0, 0, 0}
    ,
    {0x895f, 0x10, 0, 0, 0}
    ,
    {0x8960, 0xd7, 0, 0, 0}
    ,
    {0x8961, 0x03, 0, 0, 0}
    ,
    {0x8962, 0x99, 0, 0, 0}
    ,
    {0x8963, 0x40, 0, 0, 0}
    ,
    {0x8964, 0x04, 0, 0, 0}
    ,
    {0x8965, 0xeb, 0, 0, 0}
    ,
    {0x8966, 0x99, 0, 0, 0}
    ,
    {0x8967, 0xfb, 0, 0, 0}
    ,
    {0x8968, 0x0f, 0, 0, 0}
    ,
    {0x8969, 0xd8, 0, 0, 0}
    ,
    {0x896a, 0xe5, 0, 0, 0}
    ,
    {0x896b, 0xe4, 0, 0, 0}
    ,
    {0x896c, 0xf9, 0, 0, 0}
    ,
    {0x896d, 0xfa, 0, 0, 0}
    ,
    {0x896e, 0x22, 0, 0, 0}
    ,
    {0x896f, 0x78, 0, 0, 0}
    ,
    {0x8970, 0x18, 0, 0, 0}
    ,
    {0x8971, 0xef, 0, 0, 0}
    ,
    {0x8972, 0x2f, 0, 0, 0}
    ,
    {0x8973, 0xff, 0, 0, 0}
    ,
    {0x8974, 0xee, 0, 0, 0}
    ,
    {0x8975, 0x33, 0, 0, 0}
    ,
    {0x8976, 0xfe, 0, 0, 0}
    ,
    {0x8977, 0xed, 0, 0, 0}
    ,
    {0x8978, 0x33, 0, 0, 0}
    ,
    {0x8979, 0xfd, 0, 0, 0}
    ,
    {0x897a, 0xec, 0, 0, 0}
    ,
    {0x897b, 0x33, 0, 0, 0}
    ,
    {0x897c, 0xfc, 0, 0, 0}
    ,
    {0x897d, 0xc9, 0, 0, 0}
    ,
    {0x897e, 0x33, 0, 0, 0}
    ,
    {0x897f, 0xc9, 0, 0, 0}
    ,
    {0x8980, 0x10, 0, 0, 0}
    ,
    {0x8981, 0xd7, 0, 0, 0}
    ,
    {0x8982, 0x05, 0, 0, 0}
    ,
    {0x8983, 0x9b, 0, 0, 0}
    ,
    {0x8984, 0xe9, 0, 0, 0}
    ,
    {0x8985, 0x9a, 0, 0, 0}
    ,
    {0x8986, 0x40, 0, 0, 0}
    ,
    {0x8987, 0x07, 0, 0, 0}
    ,
    {0x8988, 0xec, 0, 0, 0}
    ,
    {0x8989, 0x9b, 0, 0, 0}
    ,
    {0x898a, 0xfc, 0, 0, 0}
    ,
    {0x898b, 0xe9, 0, 0, 0}
    ,
    {0x898c, 0x9a, 0, 0, 0}
    ,
    {0x898d, 0xf9, 0, 0, 0}
    ,
    {0x898e, 0x0f, 0, 0, 0}
    ,
    {0x898f, 0xd8, 0, 0, 0}
    ,
    {0x8990, 0xe0, 0, 0, 0}
    ,
    {0x8991, 0xe4, 0, 0, 0}
    ,
    {0x8992, 0xc9, 0, 0, 0}
    ,
    {0x8993, 0xfa, 0, 0, 0}
    ,
    {0x8994, 0xe4, 0, 0, 0}
    ,
    {0x8995, 0xcc, 0, 0, 0}
    ,
    {0x8996, 0xfb, 0, 0, 0}
    ,
    {0x8997, 0x22, 0, 0, 0}
    ,
    {0x8998, 0x75, 0, 0, 0}
    ,
    {0x8999, 0xf0, 0, 0, 0}
    ,
    {0x899a, 0x10, 0, 0, 0}
    ,
    {0x899b, 0xef, 0, 0, 0}
    ,
    {0x899c, 0x2f, 0, 0, 0}
    ,
    {0x899d, 0xff, 0, 0, 0}
    ,
    {0x899e, 0xee, 0, 0, 0}
    ,
    {0x899f, 0x33, 0, 0, 0}
    ,
    {0x89a0, 0xfe, 0, 0, 0}
    ,
    {0x89a1, 0xed, 0, 0, 0}
    ,
    {0x89a2, 0x33, 0, 0, 0}
    ,
    {0x89a3, 0xfd, 0, 0, 0}
    ,
    {0x89a4, 0xcc, 0, 0, 0}
    ,
    {0x89a5, 0x33, 0, 0, 0}
    ,
    {0x89a6, 0xcc, 0, 0, 0}
    ,
    {0x89a7, 0xc8, 0, 0, 0}
    ,
    {0x89a8, 0x33, 0, 0, 0}
    ,
    {0x89a9, 0xc8, 0, 0, 0}
    ,
    {0x89aa, 0x10, 0, 0, 0}
    ,
    {0x89ab, 0xd7, 0, 0, 0}
    ,
    {0x89ac, 0x07, 0, 0, 0}
    ,
    {0x89ad, 0x9b, 0, 0, 0}
    ,
    {0x89ae, 0xec, 0, 0, 0}
    ,
    {0x89af, 0x9a, 0, 0, 0}
    ,
    {0x89b0, 0xe8, 0, 0, 0}
    ,
    {0x89b1, 0x99, 0, 0, 0}
    ,
    {0x89b2, 0x40, 0, 0, 0}
    ,
    {0x89b3, 0x0a, 0, 0, 0}
    ,
    {0x89b4, 0xed, 0, 0, 0}
    ,
    {0x89b5, 0x9b, 0, 0, 0}
    ,
    {0x89b6, 0xfd, 0, 0, 0}
    ,
    {0x89b7, 0xec, 0, 0, 0}
    ,
    {0x89b8, 0x9a, 0, 0, 0}
    ,
    {0x89b9, 0xfc, 0, 0, 0}
    ,
    {0x89ba, 0xe8, 0, 0, 0}
    ,
    {0x89bb, 0x99, 0, 0, 0}
    ,
    {0x89bc, 0xf8, 0, 0, 0}
    ,
    {0x89bd, 0x0f, 0, 0, 0}
    ,
    {0x89be, 0xd5, 0, 0, 0}
    ,
    {0x89bf, 0xf0, 0, 0, 0}
    ,
    {0x89c0, 0xda, 0, 0, 0}
    ,
    {0x89c1, 0xe4, 0, 0, 0}
    ,
    {0x89c2, 0xcd, 0, 0, 0}
    ,
    {0x89c3, 0xfb, 0, 0, 0}
    ,
    {0x89c4, 0xe4, 0, 0, 0}
    ,
    {0x89c5, 0xcc, 0, 0, 0}
    ,
    {0x89c6, 0xfa, 0, 0, 0}
    ,
    {0x89c7, 0xe4, 0, 0, 0}
    ,
    {0x89c8, 0xc8, 0, 0, 0}
    ,
    {0x89c9, 0xf9, 0, 0, 0}
    ,
    {0x89ca, 0x22, 0, 0, 0}
    ,
    {0x89cb, 0xe8, 0, 0, 0}
    ,
    {0x89cc, 0x60, 0, 0, 0}
    ,
    {0x89cd, 0x0f, 0, 0, 0}
    ,
    {0x89ce, 0xec, 0, 0, 0}
    ,
    {0x89cf, 0xc3, 0, 0, 0}
    ,
    {0x89d0, 0x13, 0, 0, 0}
    ,
    {0x89d1, 0xfc, 0, 0, 0}
    ,
    {0x89d2, 0xed, 0, 0, 0}
    ,
    {0x89d3, 0x13, 0, 0, 0}
    ,
    {0x89d4, 0xfd, 0, 0, 0}
    ,
    {0x89d5, 0xee, 0, 0, 0}
    ,
    {0x89d6, 0x13, 0, 0, 0}
    ,
    {0x89d7, 0xfe, 0, 0, 0}
    ,
    {0x89d8, 0xef, 0, 0, 0}
    ,
    {0x89d9, 0x13, 0, 0, 0}
    ,
    {0x89da, 0xff, 0, 0, 0}
    ,
    {0x89db, 0xd8, 0, 0, 0}
    ,
    {0x89dc, 0xf1, 0, 0, 0}
    ,
    {0x89dd, 0x22, 0, 0, 0}
    ,
    {0x89de, 0xe8, 0, 0, 0}
    ,
    {0x89df, 0x60, 0, 0, 0}
    ,
    {0x89e0, 0x0f, 0, 0, 0}
    ,
    {0x89e1, 0xef, 0, 0, 0}
    ,
    {0x89e2, 0xc3, 0, 0, 0}
    ,
    {0x89e3, 0x33, 0, 0, 0}
    ,
    {0x89e4, 0xff, 0, 0, 0}
    ,
    {0x89e5, 0xee, 0, 0, 0}
    ,
    {0x89e6, 0x33, 0, 0, 0}
    ,
    {0x89e7, 0xfe, 0, 0, 0}
    ,
    {0x89e8, 0xed, 0, 0, 0}
    ,
    {0x89e9, 0x33, 0, 0, 0}
    ,
    {0x89ea, 0xfd, 0, 0, 0}
    ,
    {0x89eb, 0xec, 0, 0, 0}
    ,
    {0x89ec, 0x33, 0, 0, 0}
    ,
    {0x89ed, 0xfc, 0, 0, 0}
    ,
    {0x89ee, 0xd8, 0, 0, 0}
    ,
    {0x89ef, 0xf1, 0, 0, 0}
    ,
    {0x89f0, 0x22, 0, 0, 0}
    ,
    {0x89f1, 0xe4, 0, 0, 0}
    ,
    {0x89f2, 0x93, 0, 0, 0}
    ,
    {0x89f3, 0xfc, 0, 0, 0}
    ,
    {0x89f4, 0x74, 0, 0, 0}
    ,
    {0x89f5, 0x01, 0, 0, 0}
    ,
    {0x89f6, 0x93, 0, 0, 0}
    ,
    {0x89f7, 0xfd, 0, 0, 0}
    ,
    {0x89f8, 0x74, 0, 0, 0}
    ,
    {0x89f9, 0x02, 0, 0, 0}
    ,
    {0x89fa, 0x93, 0, 0, 0}
    ,
    {0x89fb, 0xfe, 0, 0, 0}
    ,
    {0x89fc, 0x74, 0, 0, 0}
    ,
    {0x89fd, 0x03, 0, 0, 0}
    ,
    {0x89fe, 0x93, 0, 0, 0}
    ,
    {0x89ff, 0xff, 0, 0, 0}
    ,
    {0x8a00, 0x22, 0, 0, 0}
    ,
    {0x8a01, 0xa4, 0, 0, 0}
    ,
    {0x8a02, 0x25, 0, 0, 0}
    ,
    {0x8a03, 0x82, 0, 0, 0}
    ,
    {0x8a04, 0xf5, 0, 0, 0}
    ,
    {0x8a05, 0x82, 0, 0, 0}
    ,
    {0x8a06, 0xe5, 0, 0, 0}
    ,
    {0x8a07, 0xf0, 0, 0, 0}
    ,
    {0x8a08, 0x35, 0, 0, 0}
    ,
    {0x8a09, 0x83, 0, 0, 0}
    ,
    {0x8a0a, 0xf5, 0, 0, 0}
    ,
    {0x8a0b, 0x83, 0, 0, 0}
    ,
    {0x8a0c, 0x22, 0, 0, 0}
    ,
    {0x8a0d, 0xd0, 0, 0, 0}
    ,
    {0x8a0e, 0x83, 0, 0, 0}
    ,
    {0x8a0f, 0xd0, 0, 0, 0}
    ,
    {0x8a10, 0x82, 0, 0, 0}
    ,
    {0x8a11, 0xf8, 0, 0, 0}
    ,
    {0x8a12, 0xe4, 0, 0, 0}
    ,
    {0x8a13, 0x93, 0, 0, 0}
    ,
    {0x8a14, 0x70, 0, 0, 0}
    ,
    {0x8a15, 0x12, 0, 0, 0}
    ,
    {0x8a16, 0x74, 0, 0, 0}
    ,
    {0x8a17, 0x01, 0, 0, 0}
    ,
    {0x8a18, 0x93, 0, 0, 0}
    ,
    {0x8a19, 0x70, 0, 0, 0}
    ,
    {0x8a1a, 0x0d, 0, 0, 0}
    ,
    {0x8a1b, 0xa3, 0, 0, 0}
    ,
    {0x8a1c, 0xa3, 0, 0, 0}
    ,
    {0x8a1d, 0x93, 0, 0, 0}
    ,
    {0x8a1e, 0xf8, 0, 0, 0}
    ,
    {0x8a1f, 0x74, 0, 0, 0}
    ,
    {0x8a20, 0x01, 0, 0, 0}
    ,
    {0x8a21, 0x93, 0, 0, 0}
    ,
    {0x8a22, 0xf5, 0, 0, 0}
    ,
    {0x8a23, 0x82, 0, 0, 0}
    ,
    {0x8a24, 0x88, 0, 0, 0}
    ,
    {0x8a25, 0x83, 0, 0, 0}
    ,
    {0x8a26, 0xe4, 0, 0, 0}
    ,
    {0x8a27, 0x73, 0, 0, 0}
    ,
    {0x8a28, 0x74, 0, 0, 0}
    ,
    {0x8a29, 0x02, 0, 0, 0}
    ,
    {0x8a2a, 0x93, 0, 0, 0}
    ,
    {0x8a2b, 0x68, 0, 0, 0}
    ,
    {0x8a2c, 0x60, 0, 0, 0}
    ,
    {0x8a2d, 0xef, 0, 0, 0}
    ,
    {0x8a2e, 0xa3, 0, 0, 0}
    ,
    {0x8a2f, 0xa3, 0, 0, 0}
    ,
    {0x8a30, 0xa3, 0, 0, 0}
    ,
    {0x8a31, 0x80, 0, 0, 0}
    ,
    {0x8a32, 0xdf, 0, 0, 0}
    ,
    {0x8a33, 0x75, 0, 0, 0}
    ,
    {0x8a34, 0x0f, 0, 0, 0}
    ,
    {0x8a35, 0x0a, 0, 0, 0}
    ,
    {0x8a36, 0xa2, 0, 0, 0}
    ,
    {0x8a37, 0xaf, 0, 0, 0}
    ,
    {0x8a38, 0x92, 0, 0, 0}
    ,
    {0x8a39, 0x32, 0, 0, 0}
    ,
    {0x8a3a, 0xc2, 0, 0, 0}
    ,
    {0x8a3b, 0xaf, 0, 0, 0}
    ,
    {0x8a3c, 0xc2, 0, 0, 0}
    ,
    {0x8a3d, 0x33, 0, 0, 0}
    ,
    {0x8a3e, 0x12, 0, 0, 0}
    ,
    {0x8a3f, 0x01, 0, 0, 0}
    ,
    {0x8a40, 0x91, 0, 0, 0}
    ,
    {0x8a41, 0x12, 0, 0, 0}
    ,
    {0x8a42, 0x01, 0, 0, 0}
    ,
    {0x8a43, 0xfc, 0, 0, 0}
    ,
    {0x8a44, 0x12, 0, 0, 0}
    ,
    {0x8a45, 0x01, 0, 0, 0}
    ,
    {0x8a46, 0x91, 0, 0, 0}
    ,
    {0x8a47, 0x75, 0, 0, 0}
    ,
    {0x8a48, 0x51, 0, 0, 0}
    ,
    {0x8a49, 0x05, 0, 0, 0}
    ,
    {0x8a4a, 0xaf, 0, 0, 0}
    ,
    {0x8a4b, 0x51, 0, 0, 0}
    ,
    {0x8a4c, 0x15, 0, 0, 0}
    ,
    {0x8a4d, 0x51, 0, 0, 0}
    ,
    {0x8a4e, 0xef, 0, 0, 0}
    ,
    {0x8a4f, 0x70, 0, 0, 0}
    ,
    {0x8a50, 0xf9, 0, 0, 0}
    ,
    {0x8a51, 0xd2, 0, 0, 0}
    ,
    {0x8a52, 0x28, 0, 0, 0}
    ,
    {0x8a53, 0x12, 0, 0, 0}
    ,
    {0x8a54, 0x01, 0, 0, 0}
    ,
    {0x8a55, 0x93, 0, 0, 0}
    ,
    {0x8a56, 0x75, 0, 0, 0}
    ,
    {0x8a57, 0x51, 0, 0, 0}
    ,
    {0x8a58, 0x0a, 0, 0, 0}
    ,
    {0x8a59, 0xaf, 0, 0, 0}
    ,
    {0x8a5a, 0x51, 0, 0, 0}
    ,
    {0x8a5b, 0x15, 0, 0, 0}
    ,
    {0x8a5c, 0x51, 0, 0, 0}
    ,
    {0x8a5d, 0xef, 0, 0, 0}
    ,
    {0x8a5e, 0x70, 0, 0, 0}
    ,
    {0x8a5f, 0xf9, 0, 0, 0}
    ,
    {0x8a60, 0xc2, 0, 0, 0}
    ,
    {0x8a61, 0x29, 0, 0, 0}
    ,
    {0x8a62, 0x12, 0, 0, 0}
    ,
    {0x8a63, 0x01, 0, 0, 0}
    ,
    {0x8a64, 0x93, 0, 0, 0}
    ,
    {0x8a65, 0x75, 0, 0, 0}
    ,
    {0x8a66, 0x51, 0, 0, 0}
    ,
    {0x8a67, 0x05, 0, 0, 0}
    ,
    {0x8a68, 0xaf, 0, 0, 0}
    ,
    {0x8a69, 0x51, 0, 0, 0}
    ,
    {0x8a6a, 0x15, 0, 0, 0}
    ,
    {0x8a6b, 0x51, 0, 0, 0}
    ,
    {0x8a6c, 0xef, 0, 0, 0}
    ,
    {0x8a6d, 0x70, 0, 0, 0}
    ,
    {0x8a6e, 0xf9, 0, 0, 0}
    ,
    {0x8a6f, 0xc2, 0, 0, 0}
    ,
    {0x8a70, 0x28, 0, 0, 0}
    ,
    {0x8a71, 0x12, 0, 0, 0}
    ,
    {0x8a72, 0x01, 0, 0, 0}
    ,
    {0x8a73, 0x93, 0, 0, 0}
    ,
    {0x8a74, 0x75, 0, 0, 0}
    ,
    {0x8a75, 0x51, 0, 0, 0}
    ,
    {0x8a76, 0x05, 0, 0, 0}
    ,
    {0x8a77, 0xaf, 0, 0, 0}
    ,
    {0x8a78, 0x51, 0, 0, 0}
    ,
    {0x8a79, 0x15, 0, 0, 0}
    ,
    {0x8a7a, 0x51, 0, 0, 0}
    ,
    {0x8a7b, 0xef, 0, 0, 0}
    ,
    {0x8a7c, 0x70, 0, 0, 0}
    ,
    {0x8a7d, 0xf9, 0, 0, 0}
    ,
    {0x8a7e, 0x75, 0, 0, 0}
    ,
    {0x8a7f, 0x10, 0, 0, 0}
    ,
    {0x8a80, 0x18, 0, 0, 0}
    ,
    {0x8a81, 0x12, 0, 0, 0}
    ,
    {0x8a82, 0x0b, 0, 0, 0}
    ,
    {0x8a83, 0x73, 0, 0, 0}
    ,
    {0x8a84, 0x75, 0, 0, 0}
    ,
    {0x8a85, 0x51, 0, 0, 0}
    ,
    {0x8a86, 0x0a, 0, 0, 0}
    ,
    {0x8a87, 0xaf, 0, 0, 0}
    ,
    {0x8a88, 0x51, 0, 0, 0}
    ,
    {0x8a89, 0x15, 0, 0, 0}
    ,
    {0x8a8a, 0x51, 0, 0, 0}
    ,
    {0x8a8b, 0xef, 0, 0, 0}
    ,
    {0x8a8c, 0x70, 0, 0, 0}
    ,
    {0x8a8d, 0xf9, 0, 0, 0}
    ,
    {0x8a8e, 0xd2, 0, 0, 0}
    ,
    {0x8a8f, 0x28, 0, 0, 0}
    ,
    {0x8a90, 0x12, 0, 0, 0}
    ,
    {0x8a91, 0x01, 0, 0, 0}
    ,
    {0x8a92, 0x93, 0, 0, 0}
    ,
    {0x8a93, 0x12, 0, 0, 0}
    ,
    {0x8a94, 0x02, 0, 0, 0}
    ,
    {0x8a95, 0x3b, 0, 0, 0}
    ,
    {0x8a96, 0xaf, 0, 0, 0}
    ,
    {0x8a97, 0x51, 0, 0, 0}
    ,
    {0x8a98, 0x15, 0, 0, 0}
    ,
    {0x8a99, 0x51, 0, 0, 0}
    ,
    {0x8a9a, 0xef, 0, 0, 0}
    ,
    {0x8a9b, 0x70, 0, 0, 0}
    ,
    {0x8a9c, 0xf9, 0, 0, 0}
    ,
    {0x8a9d, 0xc2, 0, 0, 0}
    ,
    {0x8a9e, 0x28, 0, 0, 0}
    ,
    {0x8a9f, 0x12, 0, 0, 0}
    ,
    {0x8aa0, 0x01, 0, 0, 0}
    ,
    {0x8aa1, 0x93, 0, 0, 0}
    ,
    {0x8aa2, 0x75, 0, 0, 0}
    ,
    {0x8aa3, 0x51, 0, 0, 0}
    ,
    {0x8aa4, 0x0a, 0, 0, 0}
    ,
    {0x8aa5, 0xaf, 0, 0, 0}
    ,
    {0x8aa6, 0x51, 0, 0, 0}
    ,
    {0x8aa7, 0x15, 0, 0, 0}
    ,
    {0x8aa8, 0x51, 0, 0, 0}
    ,
    {0x8aa9, 0xef, 0, 0, 0}
    ,
    {0x8aaa, 0x70, 0, 0, 0}
    ,
    {0x8aab, 0xf9, 0, 0, 0}
    ,
    {0x8aac, 0x30, 0, 0, 0}
    ,
    {0x8aad, 0x11, 0, 0, 0}
    ,
    {0x8aae, 0x03, 0, 0, 0}
    ,
    {0x8aaf, 0x02, 0, 0, 0}
    ,
    {0x8ab0, 0x0b, 0, 0, 0}
    ,
    {0x8ab1, 0x2a, 0, 0, 0}
    ,
    {0x8ab2, 0x12, 0, 0, 0}
    ,
    {0x8ab3, 0x01, 0, 0, 0}
    ,
    {0x8ab4, 0x91, 0, 0, 0}
    ,
    {0x8ab5, 0x12, 0, 0, 0}
    ,
    {0x8ab6, 0x01, 0, 0, 0}
    ,
    {0x8ab7, 0xfc, 0, 0, 0}
    ,
    {0x8ab8, 0xe5, 0, 0, 0}
    ,
    {0x8ab9, 0x0d, 0, 0, 0}
    ,
    {0x8aba, 0xf5, 0, 0, 0}
    ,
    {0x8abb, 0x10, 0, 0, 0}
    ,
    {0x8abc, 0x12, 0, 0, 0}
    ,
    {0x8abd, 0x0b, 0, 0, 0}
    ,
    {0x8abe, 0x73, 0, 0, 0}
    ,
    {0x8abf, 0x75, 0, 0, 0}
    ,
    {0x8ac0, 0x51, 0, 0, 0}
    ,
    {0x8ac1, 0x0a, 0, 0, 0}
    ,
    {0x8ac2, 0xaf, 0, 0, 0}
    ,
    {0x8ac3, 0x51, 0, 0, 0}
    ,
    {0x8ac4, 0x15, 0, 0, 0}
    ,
    {0x8ac5, 0x51, 0, 0, 0}
    ,
    {0x8ac6, 0xef, 0, 0, 0}
    ,
    {0x8ac7, 0x70, 0, 0, 0}
    ,
    {0x8ac8, 0xf9, 0, 0, 0}
    ,
    {0x8ac9, 0xd2, 0, 0, 0}
    ,
    {0x8aca, 0x28, 0, 0, 0}
    ,
    {0x8acb, 0x12, 0, 0, 0}
    ,
    {0x8acc, 0x01, 0, 0, 0}
    ,
    {0x8acd, 0x93, 0, 0, 0}
    ,
    {0x8ace, 0x12, 0, 0, 0}
    ,
    {0x8acf, 0x02, 0, 0, 0}
    ,
    {0x8ad0, 0x3b, 0, 0, 0}
    ,
    {0x8ad1, 0xaf, 0, 0, 0}
    ,
    {0x8ad2, 0x51, 0, 0, 0}
    ,
    {0x8ad3, 0x15, 0, 0, 0}
    ,
    {0x8ad4, 0x51, 0, 0, 0}
    ,
    {0x8ad5, 0xef, 0, 0, 0}
    ,
    {0x8ad6, 0x70, 0, 0, 0}
    ,
    {0x8ad7, 0xf9, 0, 0, 0}
    ,
    {0x8ad8, 0xc2, 0, 0, 0}
    ,
    {0x8ad9, 0x28, 0, 0, 0}
    ,
    {0x8ada, 0x12, 0, 0, 0}
    ,
    {0x8adb, 0x01, 0, 0, 0}
    ,
    {0x8adc, 0x93, 0, 0, 0}
    ,
    {0x8add, 0x75, 0, 0, 0}
    ,
    {0x8ade, 0x51, 0, 0, 0}
    ,
    {0x8adf, 0x0a, 0, 0, 0}
    ,
    {0x8ae0, 0xaf, 0, 0, 0}
    ,
    {0x8ae1, 0x51, 0, 0, 0}
    ,
    {0x8ae2, 0x15, 0, 0, 0}
    ,
    {0x8ae3, 0x51, 0, 0, 0}
    ,
    {0x8ae4, 0xef, 0, 0, 0}
    ,
    {0x8ae5, 0x70, 0, 0, 0}
    ,
    {0x8ae6, 0xf9, 0, 0, 0}
    ,
    {0x8ae7, 0x30, 0, 0, 0}
    ,
    {0x8ae8, 0x11, 0, 0, 0}
    ,
    {0x8ae9, 0x04, 0, 0, 0}
    ,
    {0x8aea, 0x15, 0, 0, 0}
    ,
    {0x8aeb, 0x0f, 0, 0, 0}
    ,
    {0x8aec, 0x80, 0, 0, 0}
    ,
    {0x8aed, 0x45, 0, 0, 0}
    ,
    {0x8aee, 0x12, 0, 0, 0}
    ,
    {0x8aef, 0x01, 0, 0, 0}
    ,
    {0x8af0, 0x91, 0, 0, 0}
    ,
    {0x8af1, 0x12, 0, 0, 0}
    ,
    {0x8af2, 0x01, 0, 0, 0}
    ,
    {0x8af3, 0xfc, 0, 0, 0}
    ,
    {0x8af4, 0x85, 0, 0, 0}
    ,
    {0x8af5, 0x0e, 0, 0, 0}
    ,
    {0x8af6, 0x10, 0, 0, 0}
    ,
    {0x8af7, 0x12, 0, 0, 0}
    ,
    {0x8af8, 0x14, 0, 0, 0}
    ,
    {0x8af9, 0xb5, 0, 0, 0}
    ,
    {0x8afa, 0xc2, 0, 0, 0}
    ,
    {0x8afb, 0x09, 0, 0, 0}
    ,
    {0x8afc, 0x12, 0, 0, 0}
    ,
    {0x8afd, 0x01, 0, 0, 0}
    ,
    {0x8afe, 0xfe, 0, 0, 0}
    ,
    {0x8aff, 0x75, 0, 0, 0}
    ,
    {0x8b00, 0x51, 0, 0, 0}
    ,
    {0x8b01, 0x0a, 0, 0, 0}
    ,
    {0x8b02, 0xaf, 0, 0, 0}
    ,
    {0x8b03, 0x51, 0, 0, 0}
    ,
    {0x8b04, 0x15, 0, 0, 0}
    ,
    {0x8b05, 0x51, 0, 0, 0}
    ,
    {0x8b06, 0xef, 0, 0, 0}
    ,
    {0x8b07, 0x70, 0, 0, 0}
    ,
    {0x8b08, 0xf9, 0, 0, 0}
    ,
    {0x8b09, 0xd2, 0, 0, 0}
    ,
    {0x8b0a, 0x28, 0, 0, 0}
    ,
    {0x8b0b, 0x12, 0, 0, 0}
    ,
    {0x8b0c, 0x01, 0, 0, 0}
    ,
    {0x8b0d, 0x93, 0, 0, 0}
    ,
    {0x8b0e, 0x12, 0, 0, 0}
    ,
    {0x8b0f, 0x02, 0, 0, 0}
    ,
    {0x8b10, 0x3b, 0, 0, 0}
    ,
    {0x8b11, 0xaf, 0, 0, 0}
    ,
    {0x8b12, 0x51, 0, 0, 0}
    ,
    {0x8b13, 0x15, 0, 0, 0}
    ,
    {0x8b14, 0x51, 0, 0, 0}
    ,
    {0x8b15, 0xef, 0, 0, 0}
    ,
    {0x8b16, 0x70, 0, 0, 0}
    ,
    {0x8b17, 0xf9, 0, 0, 0}
    ,
    {0x8b18, 0xc2, 0, 0, 0}
    ,
    {0x8b19, 0x28, 0, 0, 0}
    ,
    {0x8b1a, 0x12, 0, 0, 0}
    ,
    {0x8b1b, 0x01, 0, 0, 0}
    ,
    {0x8b1c, 0x93, 0, 0, 0}
    ,
    {0x8b1d, 0x75, 0, 0, 0}
    ,
    {0x8b1e, 0x51, 0, 0, 0}
    ,
    {0x8b1f, 0x0a, 0, 0, 0}
    ,
    {0x8b20, 0xaf, 0, 0, 0}
    ,
    {0x8b21, 0x51, 0, 0, 0}
    ,
    {0x8b22, 0x15, 0, 0, 0}
    ,
    {0x8b23, 0x51, 0, 0, 0}
    ,
    {0x8b24, 0xef, 0, 0, 0}
    ,
    {0x8b25, 0x70, 0, 0, 0}
    ,
    {0x8b26, 0xf9, 0, 0, 0}
    ,
    {0x8b27, 0x30, 0, 0, 0}
    ,
    {0x8b28, 0x11, 0, 0, 0}
    ,
    {0x8b29, 0x06, 0, 0, 0}
    ,
    {0x8b2a, 0x15, 0, 0, 0}
    ,
    {0x8b2b, 0x0f, 0, 0, 0}
    ,
    {0x8b2c, 0xd2, 0, 0, 0}
    ,
    {0x8b2d, 0x33, 0, 0, 0}
    ,
    {0x8b2e, 0x80, 0, 0, 0}
    ,
    {0x8b2f, 0x03, 0, 0, 0}
    ,
    {0x8b30, 0xe4, 0, 0, 0}
    ,
    {0x8b31, 0xf5, 0, 0, 0}
    ,
    {0x8b32, 0x0f, 0, 0, 0}
    ,
    {0x8b33, 0x12, 0, 0, 0}
    ,
    {0x8b34, 0x01, 0, 0, 0}
    ,
    {0x8b35, 0x91, 0, 0, 0}
    ,
    {0x8b36, 0x12, 0, 0, 0}
    ,
    {0x8b37, 0x01, 0, 0, 0}
    ,
    {0x8b38, 0xfc, 0, 0, 0}
    ,
    {0x8b39, 0xc2, 0, 0, 0}
    ,
    {0x8b3a, 0x29, 0, 0, 0}
    ,
    {0x8b3b, 0x12, 0, 0, 0}
    ,
    {0x8b3c, 0x01, 0, 0, 0}
    ,
    {0x8b3d, 0x93, 0, 0, 0}
    ,
    {0x8b3e, 0x75, 0, 0, 0}
    ,
    {0x8b3f, 0x51, 0, 0, 0}
    ,
    {0x8b40, 0x05, 0, 0, 0}
    ,
    {0x8b41, 0xaf, 0, 0, 0}
    ,
    {0x8b42, 0x51, 0, 0, 0}
    ,
    {0x8b43, 0x15, 0, 0, 0}
    ,
    {0x8b44, 0x51, 0, 0, 0}
    ,
    {0x8b45, 0xef, 0, 0, 0}
    ,
    {0x8b46, 0x70, 0, 0, 0}
    ,
    {0x8b47, 0xf9, 0, 0, 0}
    ,
    {0x8b48, 0xd2, 0, 0, 0}
    ,
    {0x8b49, 0x28, 0, 0, 0}
    ,
    {0x8b4a, 0x12, 0, 0, 0}
    ,
    {0x8b4b, 0x01, 0, 0, 0}
    ,
    {0x8b4c, 0x93, 0, 0, 0}
    ,
    {0x8b4d, 0x75, 0, 0, 0}
    ,
    {0x8b4e, 0x51, 0, 0, 0}
    ,
    {0x8b4f, 0x05, 0, 0, 0}
    ,
    {0x8b50, 0xaf, 0, 0, 0}
    ,
    {0x8b51, 0x51, 0, 0, 0}
    ,
    {0x8b52, 0x15, 0, 0, 0}
    ,
    {0x8b53, 0x51, 0, 0, 0}
    ,
    {0x8b54, 0xef, 0, 0, 0}
    ,
    {0x8b55, 0x70, 0, 0, 0}
    ,
    {0x8b56, 0xf9, 0, 0, 0}
    ,
    {0x8b57, 0x12, 0, 0, 0}
    ,
    {0x8b58, 0x01, 0, 0, 0}
    ,
    {0x8b59, 0x91, 0, 0, 0}
    ,
    {0x8b5a, 0x75, 0, 0, 0}
    ,
    {0x8b5b, 0x51, 0, 0, 0}
    ,
    {0x8b5c, 0x05, 0, 0, 0}
    ,
    {0x8b5d, 0xaf, 0, 0, 0}
    ,
    {0x8b5e, 0x51, 0, 0, 0}
    ,
    {0x8b5f, 0x15, 0, 0, 0}
    ,
    {0x8b60, 0x51, 0, 0, 0}
    ,
    {0x8b61, 0xef, 0, 0, 0}
    ,
    {0x8b62, 0x70, 0, 0, 0}
    ,
    {0x8b63, 0xf9, 0, 0, 0}
    ,
    {0x8b64, 0xa2, 0, 0, 0}
    ,
    {0x8b65, 0x32, 0, 0, 0}
    ,
    {0x8b66, 0x92, 0, 0, 0}
    ,
    {0x8b67, 0xaf, 0, 0, 0}
    ,
    {0x8b68, 0xe5, 0, 0, 0}
    ,
    {0x8b69, 0x0f, 0, 0, 0}
    ,
    {0x8b6a, 0xd3, 0, 0, 0}
    ,
    {0x8b6b, 0x94, 0, 0, 0}
    ,
    {0x8b6c, 0x00, 0, 0, 0}
    ,
    {0x8b6d, 0x40, 0, 0, 0}
    ,
    {0x8b6e, 0x03, 0, 0, 0}
    ,
    {0x8b6f, 0x02, 0, 0, 0}
    ,
    {0x8b70, 0x0a, 0, 0, 0}
    ,
    {0x8b71, 0x3a, 0, 0, 0}
    ,
    {0x8b72, 0x22, 0, 0, 0}
    ,
    {0x8b73, 0x12, 0, 0, 0}
    ,
    {0x8b74, 0x14, 0, 0, 0}
    ,
    {0x8b75, 0xb5, 0, 0, 0}
    ,
    {0x8b76, 0xc2, 0, 0, 0}
    ,
    {0x8b77, 0x09, 0, 0, 0}
    ,
    {0x8b78, 0x90, 0, 0, 0}
    ,
    {0x8b79, 0x30, 0, 0, 0}
    ,
    {0x8b7a, 0x18, 0, 0, 0}
    ,
    {0x8b7b, 0xe5, 0, 0, 0}
    ,
    {0x8b7c, 0x21, 0, 0, 0}
    ,
    {0x8b7d, 0xf0, 0, 0, 0}
    ,
    {0x8b7e, 0x22, 0, 0, 0}
    ,
    {0x8b7f, 0xc0, 0, 0, 0}
    ,
    {0x8b80, 0xe0, 0, 0, 0}
    ,
    {0x8b81, 0xc0, 0, 0, 0}
    ,
    {0x8b82, 0xf0, 0, 0, 0}
    ,
    {0x8b83, 0xc0, 0, 0, 0}
    ,
    {0x8b84, 0x83, 0, 0, 0}
    ,
    {0x8b85, 0xc0, 0, 0, 0}
    ,
    {0x8b86, 0x82, 0, 0, 0}
    ,
    {0x8b87, 0xc0, 0, 0, 0}
    ,
    {0x8b88, 0xd0, 0, 0, 0}
    ,
    {0x8b89, 0x75, 0, 0, 0}
    ,
    {0x8b8a, 0xd0, 0, 0, 0}
    ,
    {0x8b8b, 0x00, 0, 0, 0}
    ,
    {0x8b8c, 0xc0, 0, 0, 0}
    ,
    {0x8b8d, 0x00, 0, 0, 0}
    ,
    {0x8b8e, 0xc0, 0, 0, 0}
    ,
    {0x8b8f, 0x01, 0, 0, 0}
    ,
    {0x8b90, 0xc0, 0, 0, 0}
    ,
    {0x8b91, 0x02, 0, 0, 0}
    ,
    {0x8b92, 0xc0, 0, 0, 0}
    ,
    {0x8b93, 0x03, 0, 0, 0}
    ,
    {0x8b94, 0xc0, 0, 0, 0}
    ,
    {0x8b95, 0x04, 0, 0, 0}
    ,
    {0x8b96, 0xc0, 0, 0, 0}
    ,
    {0x8b97, 0x05, 0, 0, 0}
    ,
    {0x8b98, 0xc0, 0, 0, 0}
    ,
    {0x8b99, 0x06, 0, 0, 0}
    ,
    {0x8b9a, 0xc0, 0, 0, 0}
    ,
    {0x8b9b, 0x07, 0, 0, 0}
    ,
    {0x8b9c, 0x90, 0, 0, 0}
    ,
    {0x8b9d, 0x3f, 0, 0, 0}
    ,
    {0x8b9e, 0x0c, 0, 0, 0}
    ,
    {0x8b9f, 0xe0, 0, 0, 0}
    ,
    {0x8ba0, 0xf5, 0, 0, 0}
    ,
    {0x8ba1, 0x08, 0, 0, 0}
    ,
    {0x8ba2, 0xe5, 0, 0, 0}
    ,
    {0x8ba3, 0x08, 0, 0, 0}
    ,
    {0x8ba4, 0x20, 0, 0, 0}
    ,
    {0x8ba5, 0xe3, 0, 0, 0}
    ,
    {0x8ba6, 0x03, 0, 0, 0}
    ,
    {0x8ba7, 0x02, 0, 0, 0}
    ,
    {0x8ba8, 0x0c, 0, 0, 0}
    ,
    {0x8ba9, 0x30, 0, 0, 0}
    ,
    {0x8baa, 0x30, 0, 0, 0}
    ,
    {0x8bab, 0x35, 0, 0, 0}
    ,
    {0x8bac, 0x03, 0, 0, 0}
    ,
    {0x8bad, 0x02, 0, 0, 0}
    ,
    {0x8bae, 0x0c, 0, 0, 0}
    ,
    {0x8baf, 0x30, 0, 0, 0}
    ,
    {0x8bb0, 0x90, 0, 0, 0}
    ,
    {0x8bb1, 0x60, 0, 0, 0}
    ,
    {0x8bb2, 0x16, 0, 0, 0}
    ,
    {0x8bb3, 0xe0, 0, 0, 0}
    ,
    {0x8bb4, 0xf5, 0, 0, 0}
    ,
    {0x8bb5, 0x6a, 0, 0, 0}
    ,
    {0x8bb6, 0xa3, 0, 0, 0}
    ,
    {0x8bb7, 0xe0, 0, 0, 0}
    ,
    {0x8bb8, 0xf5, 0, 0, 0}
    ,
    {0x8bb9, 0x6b, 0, 0, 0}
    ,
    {0x8bba, 0x90, 0, 0, 0}
    ,
    {0x8bbb, 0x60, 0, 0, 0}
    ,
    {0x8bbc, 0x1e, 0, 0, 0}
    ,
    {0x8bbd, 0xe0, 0, 0, 0}
    ,
    {0x8bbe, 0xf5, 0, 0, 0}
    ,
    {0x8bbf, 0x6c, 0, 0, 0}
    ,
    {0x8bc0, 0xa3, 0, 0, 0}
    ,
    {0x8bc1, 0xe0, 0, 0, 0}
    ,
    {0x8bc2, 0xf5, 0, 0, 0}
    ,
    {0x8bc3, 0x6d, 0, 0, 0}
    ,
    {0x8bc4, 0x90, 0, 0, 0}
    ,
    {0x8bc5, 0x60, 0, 0, 0}
    ,
    {0x8bc6, 0x26, 0, 0, 0}
    ,
    {0x8bc7, 0xe0, 0, 0, 0}
    ,
    {0x8bc8, 0xf5, 0, 0, 0}
    ,
    {0x8bc9, 0x6e, 0, 0, 0}
    ,
    {0x8bca, 0xa3, 0, 0, 0}
    ,
    {0x8bcb, 0xe0, 0, 0, 0}
    ,
    {0x8bcc, 0xf5, 0, 0, 0}
    ,
    {0x8bcd, 0x6f, 0, 0, 0}
    ,
    {0x8bce, 0x90, 0, 0, 0}
    ,
    {0x8bcf, 0x60, 0, 0, 0}
    ,
    {0x8bd0, 0x2e, 0, 0, 0}
    ,
    {0x8bd1, 0xe0, 0, 0, 0}
    ,
    {0x8bd2, 0xf5, 0, 0, 0}
    ,
    {0x8bd3, 0x70, 0, 0, 0}
    ,
    {0x8bd4, 0xa3, 0, 0, 0}
    ,
    {0x8bd5, 0xe0, 0, 0, 0}
    ,
    {0x8bd6, 0xf5, 0, 0, 0}
    ,
    {0x8bd7, 0x71, 0, 0, 0}
    ,
    {0x8bd8, 0x90, 0, 0, 0}
    ,
    {0x8bd9, 0x60, 0, 0, 0}
    ,
    {0x8bda, 0x36, 0, 0, 0}
    ,
    {0x8bdb, 0x12, 0, 0, 0}
    ,
    {0x8bdc, 0x00, 0, 0, 0}
    ,
    {0x8bdd, 0x16, 0, 0, 0}
    ,
    {0x8bde, 0x12, 0, 0, 0}
    ,
    {0x8bdf, 0x01, 0, 0, 0}
    ,
    {0x8be0, 0xd0, 0, 0, 0}
    ,
    {0x8be1, 0x40, 0, 0, 0}
    ,
    {0x8be2, 0x06, 0, 0, 0}
    ,
    {0x8be3, 0x75, 0, 0, 0}
    ,
    {0x8be4, 0x2a, 0, 0, 0}
    ,
    {0x8be5, 0xff, 0, 0, 0}
    ,
    {0x8be6, 0x75, 0, 0, 0}
    ,
    {0x8be7, 0x2b, 0, 0, 0}
    ,
    {0x8be8, 0xff, 0, 0, 0}
    ,
    {0x8be9, 0x85, 0, 0, 0}
    ,
    {0x8bea, 0x2a, 0, 0, 0}
    ,
    {0x8beb, 0x74, 0, 0, 0}
    ,
    {0x8bec, 0x85, 0, 0, 0}
    ,
    {0x8bed, 0x2b, 0, 0, 0}
    ,
    {0x8bee, 0x75, 0, 0, 0}
    ,
    {0x8bef, 0x90, 0, 0, 0}
    ,
    {0x8bf0, 0x60, 0, 0, 0}
    ,
    {0x8bf1, 0x1a, 0, 0, 0}
    ,
    {0x8bf2, 0xe0, 0, 0, 0}
    ,
    {0x8bf3, 0xf5, 0, 0, 0}
    ,
    {0x8bf4, 0x6a, 0, 0, 0}
    ,
    {0x8bf5, 0xa3, 0, 0, 0}
    ,
    {0x8bf6, 0xe0, 0, 0, 0}
    ,
    {0x8bf7, 0xf5, 0, 0, 0}
    ,
    {0x8bf8, 0x6b, 0, 0, 0}
    ,
    {0x8bf9, 0x90, 0, 0, 0}
    ,
    {0x8bfa, 0x60, 0, 0, 0}
    ,
    {0x8bfb, 0x22, 0, 0, 0}
    ,
    {0x8bfc, 0xe0, 0, 0, 0}
    ,
    {0x8bfd, 0xf5, 0, 0, 0}
    ,
    {0x8bfe, 0x6c, 0, 0, 0}
    ,
    {0x8bff, 0xa3, 0, 0, 0}
    ,
    {0x8c00, 0xe0, 0, 0, 0}
    ,
    {0x8c01, 0xf5, 0, 0, 0}
    ,
    {0x8c02, 0x6d, 0, 0, 0}
    ,
    {0x8c03, 0x90, 0, 0, 0}
    ,
    {0x8c04, 0x60, 0, 0, 0}
    ,
    {0x8c05, 0x2a, 0, 0, 0}
    ,
    {0x8c06, 0xe0, 0, 0, 0}
    ,
    {0x8c07, 0xf5, 0, 0, 0}
    ,
    {0x8c08, 0x6e, 0, 0, 0}
    ,
    {0x8c09, 0xa3, 0, 0, 0}
    ,
    {0x8c0a, 0xe0, 0, 0, 0}
    ,
    {0x8c0b, 0xf5, 0, 0, 0}
    ,
    {0x8c0c, 0x6f, 0, 0, 0}
    ,
    {0x8c0d, 0x90, 0, 0, 0}
    ,
    {0x8c0e, 0x60, 0, 0, 0}
    ,
    {0x8c0f, 0x32, 0, 0, 0}
    ,
    {0x8c10, 0xe0, 0, 0, 0}
    ,
    {0x8c11, 0xf5, 0, 0, 0}
    ,
    {0x8c12, 0x70, 0, 0, 0}
    ,
    {0x8c13, 0xa3, 0, 0, 0}
    ,
    {0x8c14, 0xe0, 0, 0, 0}
    ,
    {0x8c15, 0xf5, 0, 0, 0}
    ,
    {0x8c16, 0x71, 0, 0, 0}
    ,
    {0x8c17, 0x90, 0, 0, 0}
    ,
    {0x8c18, 0x60, 0, 0, 0}
    ,
    {0x8c19, 0x3a, 0, 0, 0}
    ,
    {0x8c1a, 0x12, 0, 0, 0}
    ,
    {0x8c1b, 0x00, 0, 0, 0}
    ,
    {0x8c1c, 0x16, 0, 0, 0}
    ,
    {0x8c1d, 0x12, 0, 0, 0}
    ,
    {0x8c1e, 0x01, 0, 0, 0}
    ,
    {0x8c1f, 0xd0, 0, 0, 0}
    ,
    {0x8c20, 0x40, 0, 0, 0}
    ,
    {0x8c21, 0x06, 0, 0, 0}
    ,
    {0x8c22, 0x75, 0, 0, 0}
    ,
    {0x8c23, 0x2a, 0, 0, 0}
    ,
    {0x8c24, 0xff, 0, 0, 0}
    ,
    {0x8c25, 0x75, 0, 0, 0}
    ,
    {0x8c26, 0x2b, 0, 0, 0}
    ,
    {0x8c27, 0xff, 0, 0, 0}
    ,
    {0x8c28, 0x85, 0, 0, 0}
    ,
    {0x8c29, 0x2a, 0, 0, 0}
    ,
    {0x8c2a, 0x76, 0, 0, 0}
    ,
    {0x8c2b, 0x85, 0, 0, 0}
    ,
    {0x8c2c, 0x2b, 0, 0, 0}
    ,
    {0x8c2d, 0x77, 0, 0, 0}
    ,
    {0x8c2e, 0xd2, 0, 0, 0}
    ,
    {0x8c2f, 0x3e, 0, 0, 0}
    ,
    {0x8c30, 0xe5, 0, 0, 0}
    ,
    {0x8c31, 0x08, 0, 0, 0}
    ,
    {0x8c32, 0x30, 0, 0, 0}
    ,
    {0x8c33, 0xe5, 0, 0, 0}
    ,
    {0x8c34, 0x55, 0, 0, 0}
    ,
    {0x8c35, 0x90, 0, 0, 0}
    ,
    {0x8c36, 0x56, 0, 0, 0}
    ,
    {0x8c37, 0x90, 0, 0, 0}
    ,
    {0x8c38, 0xe0, 0, 0, 0}
    ,
    {0x8c39, 0xf5, 0, 0, 0}
    ,
    {0x8c3a, 0x55, 0, 0, 0}
    ,
    {0x8c3b, 0xe5, 0, 0, 0}
    ,
    {0x8c3c, 0x7b, 0, 0, 0}
    ,
    {0x8c3d, 0x12, 0, 0, 0}
    ,
    {0x8c3e, 0x01, 0, 0, 0}
    ,
    {0x8c3f, 0xc9, 0, 0, 0}
    ,
    {0x8c40, 0xad, 0, 0, 0}
    ,
    {0x8c41, 0x55, 0, 0, 0}
    ,
    {0x8c42, 0xc3, 0, 0, 0}
    ,
    {0x8c43, 0xef, 0, 0, 0}
    ,
    {0x8c44, 0x9d, 0, 0, 0}
    ,
    {0x8c45, 0x74, 0, 0, 0}
    ,
    {0x8c46, 0x80, 0, 0, 0}
    ,
    {0x8c47, 0xf8, 0, 0, 0}
    ,
    {0x8c48, 0x6e, 0, 0, 0}
    ,
    {0x8c49, 0x98, 0, 0, 0}
    ,
    {0x8c4a, 0x50, 0, 0, 0}
    ,
    {0x8c4b, 0x02, 0, 0, 0}
    ,
    {0x8c4c, 0x80, 0, 0, 0}
    ,
    {0x8c4d, 0x01, 0, 0, 0}
    ,
    {0x8c4e, 0xc3, 0, 0, 0}
    ,
    {0x8c4f, 0x92, 0, 0, 0}
    ,
    {0x8c50, 0x27, 0, 0, 0}
    ,
    {0x8c51, 0xaf, 0, 0, 0}
    ,
    {0x8c52, 0x55, 0, 0, 0}
    ,
    {0x8c53, 0xef, 0, 0, 0}
    ,
    {0x8c54, 0x24, 0, 0, 0}
    ,
    {0x8c55, 0x01, 0, 0, 0}
    ,
    {0x8c56, 0xff, 0, 0, 0}
    ,
    {0x8c57, 0xe4, 0, 0, 0}
    ,
    {0x8c58, 0x33, 0, 0, 0}
    ,
    {0x8c59, 0xfe, 0, 0, 0}
    ,
    {0x8c5a, 0xc3, 0, 0, 0}
    ,
    {0x8c5b, 0xef, 0, 0, 0}
    ,
    {0x8c5c, 0x95, 0, 0, 0}
    ,
    {0x8c5d, 0x7b, 0, 0, 0}
    ,
    {0x8c5e, 0x74, 0, 0, 0}
    ,
    {0x8c5f, 0x80, 0, 0, 0}
    ,
    {0x8c60, 0xf8, 0, 0, 0}
    ,
    {0x8c61, 0x6e, 0, 0, 0}
    ,
    {0x8c62, 0x98, 0, 0, 0}
    ,
    {0x8c63, 0x50, 0, 0, 0}
    ,
    {0x8c64, 0x02, 0, 0, 0}
    ,
    {0x8c65, 0x80, 0, 0, 0}
    ,
    {0x8c66, 0x02, 0, 0, 0}
    ,
    {0x8c67, 0xa2, 0, 0, 0}
    ,
    {0x8c68, 0x27, 0, 0, 0}
    ,
    {0x8c69, 0x92, 0, 0, 0}
    ,
    {0x8c6a, 0x27, 0, 0, 0}
    ,
    {0x8c6b, 0x30, 0, 0, 0}
    ,
    {0x8c6c, 0x27, 0, 0, 0}
    ,
    {0x8c6d, 0x04, 0, 0, 0}
    ,
    {0x8c6e, 0xaf, 0, 0, 0}
    ,
    {0x8c6f, 0x55, 0, 0, 0}
    ,
    {0x8c70, 0x80, 0, 0, 0}
    ,
    {0x8c71, 0x02, 0, 0, 0}
    ,
    {0x8c72, 0xaf, 0, 0, 0}
    ,
    {0x8c73, 0x7b, 0, 0, 0}
    ,
    {0x8c74, 0x8f, 0, 0, 0}
    ,
    {0x8c75, 0x7b, 0, 0, 0}
    ,
    {0x8c76, 0x30, 0, 0, 0}
    ,
    {0x8c77, 0x37, 0, 0, 0}
    ,
    {0x8c78, 0x11, 0, 0, 0}
    ,
    {0x8c79, 0x90, 0, 0, 0}
    ,
    {0x8c7a, 0x50, 0, 0, 0}
    ,
    {0x8c7b, 0x03, 0, 0, 0}
    ,
    {0x8c7c, 0xe0, 0, 0, 0}
    ,
    {0x8c7d, 0x30, 0, 0, 0}
    ,
    {0x8c7e, 0x39, 0, 0, 0}
    ,
    {0x8c7f, 0x05, 0, 0, 0}
    ,
    {0x8c80, 0x44, 0, 0, 0}
    ,
    {0x8c81, 0x02, 0, 0, 0}
    ,
    {0x8c82, 0xf0, 0, 0, 0}
    ,
    {0x8c83, 0x80, 0, 0, 0}
    ,
    {0x8c84, 0x03, 0, 0, 0}
    ,
    {0x8c85, 0x54, 0, 0, 0}
    ,
    {0x8c86, 0xfd, 0, 0, 0}
    ,
    {0x8c87, 0xf0, 0, 0, 0}
    ,
    {0x8c88, 0xc2, 0, 0, 0}
    ,
    {0x8c89, 0x37, 0, 0, 0}
    ,
    {0x8c8a, 0xe5, 0, 0, 0}
    ,
    {0x8c8b, 0x08, 0, 0, 0}
    ,
    {0x8c8c, 0x30, 0, 0, 0}
    ,
    {0x8c8d, 0xe1, 0, 0, 0}
    ,
    {0x8c8e, 0x08, 0, 0, 0}
    ,
    {0x8c8f, 0x90, 0, 0, 0}
    ,
    {0x8c90, 0x30, 0, 0, 0}
    ,
    {0x8c91, 0x24, 0, 0, 0}
    ,
    {0x8c92, 0xe0, 0, 0, 0}
    ,
    {0x8c93, 0xf5, 0, 0, 0}
    ,
    {0x8c94, 0x33, 0, 0, 0}
    ,
    {0x8c95, 0xe4, 0, 0, 0}
    ,
    {0x8c96, 0xf0, 0, 0, 0}
    ,
    {0x8c97, 0x90, 0, 0, 0}
    ,
    {0x8c98, 0x3f, 0, 0, 0}
    ,
    {0x8c99, 0x0c, 0, 0, 0}
    ,
    {0x8c9a, 0xe5, 0, 0, 0}
    ,
    {0x8c9b, 0x08, 0, 0, 0}
    ,
    {0x8c9c, 0xf0, 0, 0, 0}
    ,
    {0x8c9d, 0xd0, 0, 0, 0}
    ,
    {0x8c9e, 0x07, 0, 0, 0}
    ,
    {0x8c9f, 0xd0, 0, 0, 0}
    ,
    {0x8ca0, 0x06, 0, 0, 0}
    ,
    {0x8ca1, 0xd0, 0, 0, 0}
    ,
    {0x8ca2, 0x05, 0, 0, 0}
    ,
    {0x8ca3, 0xd0, 0, 0, 0}
    ,
    {0x8ca4, 0x04, 0, 0, 0}
    ,
    {0x8ca5, 0xd0, 0, 0, 0}
    ,
    {0x8ca6, 0x03, 0, 0, 0}
    ,
    {0x8ca7, 0xd0, 0, 0, 0}
    ,
    {0x8ca8, 0x02, 0, 0, 0}
    ,
    {0x8ca9, 0xd0, 0, 0, 0}
    ,
    {0x8caa, 0x01, 0, 0, 0}
    ,
    {0x8cab, 0xd0, 0, 0, 0}
    ,
    {0x8cac, 0x00, 0, 0, 0}
    ,
    {0x8cad, 0xd0, 0, 0, 0}
    ,
    {0x8cae, 0xd0, 0, 0, 0}
    ,
    {0x8caf, 0xd0, 0, 0, 0}
    ,
    {0x8cb0, 0x82, 0, 0, 0}
    ,
    {0x8cb1, 0xd0, 0, 0, 0}
    ,
    {0x8cb2, 0x83, 0, 0, 0}
    ,
    {0x8cb3, 0xd0, 0, 0, 0}
    ,
    {0x8cb4, 0xf0, 0, 0, 0}
    ,
    {0x8cb5, 0xd0, 0, 0, 0}
    ,
    {0x8cb6, 0xe0, 0, 0, 0}
    ,
    {0x8cb7, 0x32, 0, 0, 0}
    ,
    {0x8cb8, 0xe5, 0, 0, 0}
    ,
    {0x8cb9, 0x79, 0, 0, 0}
    ,
    {0x8cba, 0xd3, 0, 0, 0}
    ,
    {0x8cbb, 0x94, 0, 0, 0}
    ,
    {0x8cbc, 0x04, 0, 0, 0}
    ,
    {0x8cbd, 0x40, 0, 0, 0}
    ,
    {0x8cbe, 0x03, 0, 0, 0}
    ,
    {0x8cbf, 0x02, 0, 0, 0}
    ,
    {0x8cc0, 0x0d, 0, 0, 0}
    ,
    {0x8cc1, 0xe5, 0, 0, 0}
    ,
    {0x8cc2, 0x90, 0, 0, 0}
    ,
    {0x8cc3, 0x38, 0, 0, 0}
    ,
    {0x8cc4, 0x08, 0, 0, 0}
    ,
    {0x8cc5, 0xe0, 0, 0, 0}
    ,
    {0x8cc6, 0xfe, 0, 0, 0}
    ,
    {0x8cc7, 0xa3, 0, 0, 0}
    ,
    {0x8cc8, 0xe0, 0, 0, 0}
    ,
    {0x8cc9, 0xfd, 0, 0, 0}
    ,
    {0x8cca, 0xee, 0, 0, 0}
    ,
    {0x8ccb, 0xf5, 0, 0, 0}
    ,
    {0x8ccc, 0x0e, 0, 0, 0}
    ,
    {0x8ccd, 0xed, 0, 0, 0}
    ,
    {0x8cce, 0xf5, 0, 0, 0}
    ,
    {0x8ccf, 0x0f, 0, 0, 0}
    ,
    {0x8cd0, 0xa3, 0, 0, 0}
    ,
    {0x8cd1, 0xe0, 0, 0, 0}
    ,
    {0x8cd2, 0xfe, 0, 0, 0}
    ,
    {0x8cd3, 0xa3, 0, 0, 0}
    ,
    {0x8cd4, 0xe0, 0, 0, 0}
    ,
    {0x8cd5, 0xfd, 0, 0, 0}
    ,
    {0x8cd6, 0xee, 0, 0, 0}
    ,
    {0x8cd7, 0xf5, 0, 0, 0}
    ,
    {0x8cd8, 0x10, 0, 0, 0}
    ,
    {0x8cd9, 0xed, 0, 0, 0}
    ,
    {0x8cda, 0xf5, 0, 0, 0}
    ,
    {0x8cdb, 0x11, 0, 0, 0}
    ,
    {0x8cdc, 0x12, 0, 0, 0}
    ,
    {0x8cdd, 0x02, 0, 0, 0}
    ,
    {0x8cde, 0x7b, 0, 0, 0}
    ,
    {0x8cdf, 0x24, 0, 0, 0}
    ,
    {0x8ce0, 0x34, 0, 0, 0}
    ,
    {0x8ce1, 0xf8, 0, 0, 0}
    ,
    {0x8ce2, 0xe6, 0, 0, 0}
    ,
    {0x8ce3, 0x75, 0, 0, 0}
    ,
    {0x8ce4, 0x12, 0, 0, 0}
    ,
    {0x8ce5, 0x00, 0, 0, 0}
    ,
    {0x8ce6, 0xf5, 0, 0, 0}
    ,
    {0x8ce7, 0x13, 0, 0, 0}
    ,
    {0x8ce8, 0x12, 0, 0, 0}
    ,
    {0x8ce9, 0x02, 0, 0, 0}
    ,
    {0x8cea, 0x7b, 0, 0, 0}
    ,
    {0x8ceb, 0x24, 0, 0, 0}
    ,
    {0x8cec, 0x35, 0, 0, 0}
    ,
    {0x8ced, 0xf8, 0, 0, 0}
    ,
    {0x8cee, 0xe6, 0, 0, 0}
    ,
    {0x8cef, 0x75, 0, 0, 0}
    ,
    {0x8cf0, 0x16, 0, 0, 0}
    ,
    {0x8cf1, 0x00, 0, 0, 0}
    ,
    {0x8cf2, 0xf5, 0, 0, 0}
    ,
    {0x8cf3, 0x17, 0, 0, 0}
    ,
    {0x8cf4, 0x12, 0, 0, 0}
    ,
    {0x8cf5, 0x02, 0, 0, 0}
    ,
    {0x8cf6, 0x7b, 0, 0, 0}
    ,
    {0x8cf7, 0x24, 0, 0, 0}
    ,
    {0x8cf8, 0x36, 0, 0, 0}
    ,
    {0x8cf9, 0xf8, 0, 0, 0}
    ,
    {0x8cfa, 0xe6, 0, 0, 0}
    ,
    {0x8cfb, 0x75, 0, 0, 0}
    ,
    {0x8cfc, 0x14, 0, 0, 0}
    ,
    {0x8cfd, 0x00, 0, 0, 0}
    ,
    {0x8cfe, 0xf5, 0, 0, 0}
    ,
    {0x8cff, 0x15, 0, 0, 0}
    ,
    {0x8d00, 0x12, 0, 0, 0}
    ,
    {0x8d01, 0x02, 0, 0, 0}
    ,
    {0x8d02, 0x7b, 0, 0, 0}
    ,
    {0x8d03, 0x24, 0, 0, 0}
    ,
    {0x8d04, 0x37, 0, 0, 0}
    ,
    {0x8d05, 0xf8, 0, 0, 0}
    ,
    {0x8d06, 0xe6, 0, 0, 0}
    ,
    {0x8d07, 0x75, 0, 0, 0}
    ,
    {0x8d08, 0x18, 0, 0, 0}
    ,
    {0x8d09, 0x00, 0, 0, 0}
    ,
    {0x8d0a, 0xf5, 0, 0, 0}
    ,
    {0x8d0b, 0x19, 0, 0, 0}
    ,
    {0x8d0c, 0x12, 0, 0, 0}
    ,
    {0x8d0d, 0x02, 0, 0, 0}
    ,
    {0x8d0e, 0x96, 0, 0, 0}
    ,
    {0x8d0f, 0xae, 0, 0, 0}
    ,
    {0x8d10, 0x12, 0, 0, 0}
    ,
    {0x8d11, 0xaf, 0, 0, 0}
    ,
    {0x8d12, 0x13, 0, 0, 0}
    ,
    {0x8d13, 0x12, 0, 0, 0}
    ,
    {0x8d14, 0x01, 0, 0, 0}
    ,
    {0x8d15, 0x6a, 0, 0, 0}
    ,
    {0x8d16, 0x8e, 0, 0, 0}
    ,
    {0x8d17, 0x12, 0, 0, 0}
    ,
    {0x8d18, 0x8f, 0, 0, 0}
    ,
    {0x8d19, 0x13, 0, 0, 0}
    ,
    {0x8d1a, 0x12, 0, 0, 0}
    ,
    {0x8d1b, 0x02, 0, 0, 0}
    ,
    {0x8d1c, 0x96, 0, 0, 0}
    ,
    {0x8d1d, 0xae, 0, 0, 0}
    ,
    {0x8d1e, 0x14, 0, 0, 0}
    ,
    {0x8d1f, 0xaf, 0, 0, 0}
    ,
    {0x8d20, 0x15, 0, 0, 0}
    ,
    {0x8d21, 0x12, 0, 0, 0}
    ,
    {0x8d22, 0x01, 0, 0, 0}
    ,
    {0x8d23, 0x6a, 0, 0, 0}
    ,
    {0x8d24, 0x8e, 0, 0, 0}
    ,
    {0x8d25, 0x14, 0, 0, 0}
    ,
    {0x8d26, 0x8f, 0, 0, 0}
    ,
    {0x8d27, 0x15, 0, 0, 0}
    ,
    {0x8d28, 0x12, 0, 0, 0}
    ,
    {0x8d29, 0x02, 0, 0, 0}
    ,
    {0x8d2a, 0x05, 0, 0, 0}
    ,
    {0x8d2b, 0xae, 0, 0, 0}
    ,
    {0x8d2c, 0x16, 0, 0, 0}
    ,
    {0x8d2d, 0xaf, 0, 0, 0}
    ,
    {0x8d2e, 0x17, 0, 0, 0}
    ,
    {0x8d2f, 0xfc, 0, 0, 0}
    ,
    {0x8d30, 0xfd, 0, 0, 0}
    ,
    {0x8d31, 0x12, 0, 0, 0}
    ,
    {0x8d32, 0x08, 0, 0, 0}
    ,
    {0x8d33, 0xae, 0, 0, 0}
    ,
    {0x8d34, 0x12, 0, 0, 0}
    ,
    {0x8d35, 0x01, 0, 0, 0}
    ,
    {0x8d36, 0x88, 0, 0, 0}
    ,
    {0x8d37, 0x7b, 0, 0, 0}
    ,
    {0x8d38, 0x30, 0, 0, 0}
    ,
    {0x8d39, 0x12, 0, 0, 0}
    ,
    {0x8d3a, 0x01, 0, 0, 0}
    ,
    {0x8d3b, 0x81, 0, 0, 0}
    ,
    {0x8d3c, 0x8e, 0, 0, 0}
    ,
    {0x8d3d, 0x16, 0, 0, 0}
    ,
    {0x8d3e, 0x8f, 0, 0, 0}
    ,
    {0x8d3f, 0x17, 0, 0, 0}
    ,
    {0x8d40, 0x12, 0, 0, 0}
    ,
    {0x8d41, 0x02, 0, 0, 0}
    ,
    {0x8d42, 0x05, 0, 0, 0}
    ,
    {0x8d43, 0xae, 0, 0, 0}
    ,
    {0x8d44, 0x18, 0, 0, 0}
    ,
    {0x8d45, 0xaf, 0, 0, 0}
    ,
    {0x8d46, 0x19, 0, 0, 0}
    ,
    {0x8d47, 0xfc, 0, 0, 0}
    ,
    {0x8d48, 0xfd, 0, 0, 0}
    ,
    {0x8d49, 0x12, 0, 0, 0}
    ,
    {0x8d4a, 0x08, 0, 0, 0}
    ,
    {0x8d4b, 0xae, 0, 0, 0}
    ,
    {0x8d4c, 0x12, 0, 0, 0}
    ,
    {0x8d4d, 0x01, 0, 0, 0}
    ,
    {0x8d4e, 0x88, 0, 0, 0}
    ,
    {0x8d4f, 0xe4, 0, 0, 0}
    ,
    {0x8d50, 0x7b, 0, 0, 0}
    ,
    {0x8d51, 0x30, 0, 0, 0}
    ,
    {0x8d52, 0x12, 0, 0, 0}
    ,
    {0x8d53, 0x01, 0, 0, 0}
    ,
    {0x8d54, 0x82, 0, 0, 0}
    ,
    {0x8d55, 0x8e, 0, 0, 0}
    ,
    {0x8d56, 0x18, 0, 0, 0}
    ,
    {0x8d57, 0x8f, 0, 0, 0}
    ,
    {0x8d58, 0x19, 0, 0, 0}
    ,
    {0x8d59, 0xe5, 0, 0, 0}
    ,
    {0x8d5a, 0x12, 0, 0, 0}
    ,
    {0x8d5b, 0x54, 0, 0, 0}
    ,
    {0x8d5c, 0x0f, 0, 0, 0}
    ,
    {0x8d5d, 0x90, 0, 0, 0}
    ,
    {0x8d5e, 0x50, 0, 0, 0}
    ,
    {0x8d5f, 0x28, 0, 0, 0}
    ,
    {0x8d60, 0xf0, 0, 0, 0}
    ,
    {0x8d61, 0xe5, 0, 0, 0}
    ,
    {0x8d62, 0x13, 0, 0, 0}
    ,
    {0x8d63, 0xa3, 0, 0, 0}
    ,
    {0x8d64, 0xf0, 0, 0, 0}
    ,
    {0x8d65, 0xe5, 0, 0, 0}
    ,
    {0x8d66, 0x14, 0, 0, 0}
    ,
    {0x8d67, 0x54, 0, 0, 0}
    ,
    {0x8d68, 0x0f, 0, 0, 0}
    ,
    {0x8d69, 0xa3, 0, 0, 0}
    ,
    {0x8d6a, 0xf0, 0, 0, 0}
    ,
    {0x8d6b, 0xe5, 0, 0, 0}
    ,
    {0x8d6c, 0x15, 0, 0, 0}
    ,
    {0x8d6d, 0xa3, 0, 0, 0}
    ,
    {0x8d6e, 0xf0, 0, 0, 0}
    ,
    {0x8d6f, 0xe5, 0, 0, 0}
    ,
    {0x8d70, 0x16, 0, 0, 0}
    ,
    {0x8d71, 0x54, 0, 0, 0}
    ,
    {0x8d72, 0x07, 0, 0, 0}
    ,
    {0x8d73, 0xa3, 0, 0, 0}
    ,
    {0x8d74, 0xf0, 0, 0, 0}
    ,
    {0x8d75, 0xe5, 0, 0, 0}
    ,
    {0x8d76, 0x17, 0, 0, 0}
    ,
    {0x8d77, 0x12, 0, 0, 0}
    ,
    {0x8d78, 0x02, 0, 0, 0}
    ,
    {0x8d79, 0x82, 0, 0, 0}
    ,
    {0x8d7a, 0xc3, 0, 0, 0}
    ,
    {0x8d7b, 0xe5, 0, 0, 0}
    ,
    {0x8d7c, 0x15, 0, 0, 0}
    ,
    {0x8d7d, 0x95, 0, 0, 0}
    ,
    {0x8d7e, 0x13, 0, 0, 0}
    ,
    {0x8d7f, 0xf5, 0, 0, 0}
    ,
    {0x8d80, 0x13, 0, 0, 0}
    ,
    {0x8d81, 0xe5, 0, 0, 0}
    ,
    {0x8d82, 0x14, 0, 0, 0}
    ,
    {0x8d83, 0x95, 0, 0, 0}
    ,
    {0x8d84, 0x12, 0, 0, 0}
    ,
    {0x8d85, 0xf5, 0, 0, 0}
    ,
    {0x8d86, 0x12, 0, 0, 0}
    ,
    {0x8d87, 0xc3, 0, 0, 0}
    ,
    {0x8d88, 0xe5, 0, 0, 0}
    ,
    {0x8d89, 0x19, 0, 0, 0}
    ,
    {0x8d8a, 0x95, 0, 0, 0}
    ,
    {0x8d8b, 0x17, 0, 0, 0}
    ,
    {0x8d8c, 0xf5, 0, 0, 0}
    ,
    {0x8d8d, 0x17, 0, 0, 0}
    ,
    {0x8d8e, 0xe5, 0, 0, 0}
    ,
    {0x8d8f, 0x18, 0, 0, 0}
    ,
    {0x8d90, 0x95, 0, 0, 0}
    ,
    {0x8d91, 0x16, 0, 0, 0}
    ,
    {0x8d92, 0xf5, 0, 0, 0}
    ,
    {0x8d93, 0x16, 0, 0, 0}
    ,
    {0x8d94, 0xd3, 0, 0, 0}
    ,
    {0x8d95, 0xe5, 0, 0, 0}
    ,
    {0x8d96, 0x13, 0, 0, 0}
    ,
    {0x8d97, 0x95, 0, 0, 0}
    ,
    {0x8d98, 0x17, 0, 0, 0}
    ,
    {0x8d99, 0xe5, 0, 0, 0}
    ,
    {0x8d9a, 0x12, 0, 0, 0}
    ,
    {0x8d9b, 0x95, 0, 0, 0}
    ,
    {0x8d9c, 0x16, 0, 0, 0}
    ,
    {0x8d9d, 0x40, 0, 0, 0}
    ,
    {0x8d9e, 0x06, 0, 0, 0}
    ,
    {0x8d9f, 0xae, 0, 0, 0}
    ,
    {0x8da0, 0x16, 0, 0, 0}
    ,
    {0x8da1, 0xaf, 0, 0, 0}
    ,
    {0x8da2, 0x17, 0, 0, 0}
    ,
    {0x8da3, 0x80, 0, 0, 0}
    ,
    {0x8da4, 0x04, 0, 0, 0}
    ,
    {0x8da5, 0xae, 0, 0, 0}
    ,
    {0x8da6, 0x12, 0, 0, 0}
    ,
    {0x8da7, 0xaf, 0, 0, 0}
    ,
    {0x8da8, 0x13, 0, 0, 0}
    ,
    {0x8da9, 0x8e, 0, 0, 0}
    ,
    {0x8daa, 0x12, 0, 0, 0}
    ,
    {0x8dab, 0x8f, 0, 0, 0}
    ,
    {0x8dac, 0x13, 0, 0, 0}
    ,
    {0x8dad, 0x90, 0, 0, 0}
    ,
    {0x8dae, 0x12, 0, 0, 0}
    ,
    {0x8daf, 0x57, 0, 0, 0}
    ,
    {0x8db0, 0xe4, 0, 0, 0}
    ,
    {0x8db1, 0x93, 0, 0, 0}
    ,
    {0x8db2, 0xff, 0, 0, 0}
    ,
    {0x8db3, 0xe5, 0, 0, 0}
    ,
    {0x8db4, 0x13, 0, 0, 0}
    ,
    {0x8db5, 0xa8, 0, 0, 0}
    ,
    {0x8db6, 0x07, 0, 0, 0}
    ,
    {0x8db7, 0x08, 0, 0, 0}
    ,
    {0x8db8, 0x80, 0, 0, 0}
    ,
    {0x8db9, 0x05, 0, 0, 0}
    ,
    {0x8dba, 0xce, 0, 0, 0}
    ,
    {0x8dbb, 0xc3, 0, 0, 0}
    ,
    {0x8dbc, 0x13, 0, 0, 0}
    ,
    {0x8dbd, 0xce, 0, 0, 0}
    ,
    {0x8dbe, 0x13, 0, 0, 0}
    ,
    {0x8dbf, 0xd8, 0, 0, 0}
    ,
    {0x8dc0, 0xf9, 0, 0, 0}
    ,
    {0x8dc1, 0xf5, 0, 0, 0}
    ,
    {0x8dc2, 0x15, 0, 0, 0}
    ,
    {0x8dc3, 0x8e, 0, 0, 0}
    ,
    {0x8dc4, 0x14, 0, 0, 0}
    ,
    {0x8dc5, 0xe5, 0, 0, 0}
    ,
    {0x8dc6, 0x13, 0, 0, 0}
    ,
    {0x8dc7, 0xae, 0, 0, 0}
    ,
    {0x8dc8, 0x12, 0, 0, 0}
    ,
    {0x8dc9, 0x78, 0, 0, 0}
    ,
    {0x8dca, 0x03, 0, 0, 0}
    ,
    {0x8dcb, 0xce, 0, 0, 0}
    ,
    {0x8dcc, 0xc3, 0, 0, 0}
    ,
    {0x8dcd, 0x13, 0, 0, 0}
    ,
    {0x8dce, 0xce, 0, 0, 0}
    ,
    {0x8dcf, 0x13, 0, 0, 0}
    ,
    {0x8dd0, 0xd8, 0, 0, 0}
    ,
    {0x8dd1, 0xf9, 0, 0, 0}
    ,
    {0x8dd2, 0xf5, 0, 0, 0}
    ,
    {0x8dd3, 0x19, 0, 0, 0}
    ,
    {0x8dd4, 0x8e, 0, 0, 0}
    ,
    {0x8dd5, 0x18, 0, 0, 0}
    ,
    {0x8dd6, 0xe5, 0, 0, 0}
    ,
    {0x8dd7, 0x14, 0, 0, 0}
    ,
    {0x8dd8, 0x54, 0, 0, 0}
    ,
    {0x8dd9, 0x0f, 0, 0, 0}
    ,
    {0x8dda, 0x90, 0, 0, 0}
    ,
    {0x8ddb, 0x50, 0, 0, 0}
    ,
    {0x8ddc, 0x30, 0, 0, 0}
    ,
    {0x8ddd, 0xf0, 0, 0, 0}
    ,
    {0x8dde, 0xe5, 0, 0, 0}
    ,
    {0x8ddf, 0x15, 0, 0, 0}
    ,
    {0x8de0, 0x12, 0, 0, 0}
    ,
    {0x8de1, 0x02, 0, 0, 0}
    ,
    {0x8de2, 0x82, 0, 0, 0}
    ,
    {0x8de3, 0xc2, 0, 0, 0}
    ,
    {0x8de4, 0x3a, 0, 0, 0}
    ,
    {0x8de5, 0x22, 0, 0, 0}
    ,
    {0x8de6, 0x30, 0, 0, 0}
    ,
    {0x8de7, 0x04, 0, 0, 0}
    ,
    {0x8de8, 0x03, 0, 0, 0}
    ,
    {0x8de9, 0x02, 0, 0, 0}
    ,
    {0x8dea, 0x0e, 0, 0, 0}
    ,
    {0x8deb, 0xfc, 0, 0, 0}
    ,
    {0x8dec, 0xd2, 0, 0, 0}
    ,
    {0x8ded, 0x04, 0, 0, 0}
    ,
    {0x8dee, 0xe5, 0, 0, 0}
    ,
    {0x8def, 0x7e, 0, 0, 0}
    ,
    {0x8df0, 0xb4, 0, 0, 0}
    ,
    {0x8df1, 0x01, 0, 0, 0}
    ,
    {0x8df2, 0x06, 0, 0, 0}
    ,
    {0x8df3, 0x12, 0, 0, 0}
    ,
    {0x8df4, 0x16, 0, 0, 0}
    ,
    {0x8df5, 0x6d, 0, 0, 0}
    ,
    {0x8df6, 0x02, 0, 0, 0}
    ,
    {0x8df7, 0x0e, 0, 0, 0}
    ,
    {0x8df8, 0xf5, 0, 0, 0}
    ,
    {0x8df9, 0xe5, 0, 0, 0}
    ,
    {0x8dfa, 0x7e, 0, 0, 0}
    ,
    {0x8dfb, 0xb4, 0, 0, 0}
    ,
    {0x8dfc, 0x02, 0, 0, 0}
    ,
    {0x8dfd, 0x06, 0, 0, 0}
    ,
    {0x8dfe, 0x12, 0, 0, 0}
    ,
    {0x8dff, 0x16, 0, 0, 0}
    ,
    {0x8e00, 0x7e, 0, 0, 0}
    ,
    {0x8e01, 0x02, 0, 0, 0}
    ,
    {0x8e02, 0x0e, 0, 0, 0}
    ,
    {0x8e03, 0xf5, 0, 0, 0}
    ,
    {0x8e04, 0xe5, 0, 0, 0}
    ,
    {0x8e05, 0x7e, 0, 0, 0}
    ,
    {0x8e06, 0xb4, 0, 0, 0}
    ,
    {0x8e07, 0x03, 0, 0, 0}
    ,
    {0x8e08, 0x05, 0, 0, 0}
    ,
    {0x8e09, 0xe4, 0, 0, 0}
    ,
    {0x8e0a, 0xf5, 0, 0, 0}
    ,
    {0x8e0b, 0x0c, 0, 0, 0}
    ,
    {0x8e0c, 0x80, 0, 0, 0}
    ,
    {0x8e0d, 0x08, 0, 0, 0}
    ,
    {0x8e0e, 0xe5, 0, 0, 0}
    ,
    {0x8e0f, 0x7e, 0, 0, 0}
    ,
    {0x8e10, 0xb4, 0, 0, 0}
    ,
    {0x8e11, 0x04, 0, 0, 0}
    ,
    {0x8e12, 0x09, 0, 0, 0}
    ,
    {0x8e13, 0x85, 0, 0, 0}
    ,
    {0x8e14, 0x7c, 0, 0, 0}
    ,
    {0x8e15, 0x0c, 0, 0, 0}
    ,
    {0x8e16, 0x12, 0, 0, 0}
    ,
    {0x8e17, 0x13, 0, 0, 0}
    ,
    {0x8e18, 0x6b, 0, 0, 0}
    ,
    {0x8e19, 0x02, 0, 0, 0}
    ,
    {0x8e1a, 0x0e, 0, 0, 0}
    ,
    {0x8e1b, 0xf5, 0, 0, 0}
    ,
    {0x8e1c, 0xe5, 0, 0, 0}
    ,
    {0x8e1d, 0x7e, 0, 0, 0}
    ,
    {0x8e1e, 0x64, 0, 0, 0}
    ,
    {0x8e1f, 0x10, 0, 0, 0}
    ,
    {0x8e20, 0x60, 0, 0, 0}
    ,
    {0x8e21, 0x03, 0, 0, 0}
    ,
    {0x8e22, 0x02, 0, 0, 0}
    ,
    {0x8e23, 0x0e, 0, 0, 0}
    ,
    {0x8e24, 0xf5, 0, 0, 0}
    ,
    {0x8e25, 0xf5, 0, 0, 0}
    ,
    {0x8e26, 0x66, 0, 0, 0}
    ,
    {0x8e27, 0xf5, 0, 0, 0}
    ,
    {0x8e28, 0x67, 0, 0, 0}
    ,
    {0x8e29, 0xf5, 0, 0, 0}
    ,
    {0x8e2a, 0x68, 0, 0, 0}
    ,
    {0x8e2b, 0xab, 0, 0, 0}
    ,
    {0x8e2c, 0x69, 0, 0, 0}
    ,
    {0x8e2d, 0xaa, 0, 0, 0}
    ,
    {0x8e2e, 0x68, 0, 0, 0}
    ,
    {0x8e2f, 0xa9, 0, 0, 0}
    ,
    {0x8e30, 0x67, 0, 0, 0}
    ,
    {0x8e31, 0xa8, 0, 0, 0}
    ,
    {0x8e32, 0x66, 0, 0, 0}
    ,
    {0x8e33, 0x12, 0, 0, 0}
    ,
    {0x8e34, 0x02, 0, 0, 0}
    ,
    {0x8e35, 0x45, 0, 0, 0}
    ,
    {0x8e36, 0xe5, 0, 0, 0}
    ,
    {0x8e37, 0x7c, 0, 0, 0}
    ,
    {0x8e38, 0x12, 0, 0, 0}
    ,
    {0x8e39, 0x02, 0, 0, 0}
    ,
    {0x8e3a, 0x2d, 0, 0, 0}
    ,
    {0x8e3b, 0x12, 0, 0, 0}
    ,
    {0x8e3c, 0x02, 0, 0, 0}
    ,
    {0x8e3d, 0x45, 0, 0, 0}
    ,
    {0x8e3e, 0xe4, 0, 0, 0}
    ,
    {0x8e3f, 0x93, 0, 0, 0}
    ,
    {0x8e40, 0xfc, 0, 0, 0}
    ,
    {0x8e41, 0x74, 0, 0, 0}
    ,
    {0x8e42, 0x01, 0, 0, 0}
    ,
    {0x8e43, 0x93, 0, 0, 0}
    ,
    {0x8e44, 0xfd, 0, 0, 0}
    ,
    {0x8e45, 0xc3, 0, 0, 0}
    ,
    {0x8e46, 0xef, 0, 0, 0}
    ,
    {0x8e47, 0x9d, 0, 0, 0}
    ,
    {0x8e48, 0xff, 0, 0, 0}
    ,
    {0x8e49, 0xee, 0, 0, 0}
    ,
    {0x8e4a, 0x9c, 0, 0, 0}
    ,
    {0x8e4b, 0xfe, 0, 0, 0}
    ,
    {0x8e4c, 0xe4, 0, 0, 0}
    ,
    {0x8e4d, 0xfc, 0, 0, 0}
    ,
    {0x8e4e, 0xfd, 0, 0, 0}
    ,
    {0x8e4f, 0x12, 0, 0, 0}
    ,
    {0x8e50, 0x08, 0, 0, 0}
    ,
    {0x8e51, 0xae, 0, 0, 0}
    ,
    {0x8e52, 0x8f, 0, 0, 0}
    ,
    {0x8e53, 0x69, 0, 0, 0}
    ,
    {0x8e54, 0x8e, 0, 0, 0}
    ,
    {0x8e55, 0x68, 0, 0, 0}
    ,
    {0x8e56, 0x8d, 0, 0, 0}
    ,
    {0x8e57, 0x67, 0, 0, 0}
    ,
    {0x8e58, 0x8c, 0, 0, 0}
    ,
    {0x8e59, 0x66, 0, 0, 0}
    ,
    {0x8e5a, 0xaf, 0, 0, 0}
    ,
    {0x8e5b, 0x69, 0, 0, 0}
    ,
    {0x8e5c, 0xae, 0, 0, 0}
    ,
    {0x8e5d, 0x68, 0, 0, 0}
    ,
    {0x8e5e, 0xad, 0, 0, 0}
    ,
    {0x8e5f, 0x67, 0, 0, 0}
    ,
    {0x8e60, 0xac, 0, 0, 0}
    ,
    {0x8e61, 0x66, 0, 0, 0}
    ,
    {0x8e62, 0xe4, 0, 0, 0}
    ,
    {0x8e63, 0x7b, 0, 0, 0}
    ,
    {0x8e64, 0xff, 0, 0, 0}
    ,
    {0x8e65, 0xfa, 0, 0, 0}
    ,
    {0x8e66, 0xf9, 0, 0, 0}
    ,
    {0x8e67, 0xf8, 0, 0, 0}
    ,
    {0x8e68, 0x12, 0, 0, 0}
    ,
    {0x8e69, 0x09, 0, 0, 0}
    ,
    {0x8e6a, 0x39, 0, 0, 0}
    ,
    {0x8e6b, 0x8f, 0, 0, 0}
    ,
    {0x8e6c, 0x69, 0, 0, 0}
    ,
    {0x8e6d, 0x8e, 0, 0, 0}
    ,
    {0x8e6e, 0x68, 0, 0, 0}
    ,
    {0x8e6f, 0x8d, 0, 0, 0}
    ,
    {0x8e70, 0x67, 0, 0, 0}
    ,
    {0x8e71, 0x8c, 0, 0, 0}
    ,
    {0x8e72, 0x66, 0, 0, 0}
    ,
    {0x8e73, 0x12, 0, 0, 0}
    ,
    {0x8e74, 0x02, 0, 0, 0}
    ,
    {0x8e75, 0x45, 0, 0, 0}
    ,
    {0x8e76, 0x12, 0, 0, 0}
    ,
    {0x8e77, 0x02, 0, 0, 0}
    ,
    {0x8e78, 0x33, 0, 0, 0}
    ,
    {0x8e79, 0xe4, 0, 0, 0}
    ,
    {0x8e7a, 0xfc, 0, 0, 0}
    ,
    {0x8e7b, 0xfd, 0, 0, 0}
    ,
    {0x8e7c, 0xe5, 0, 0, 0}
    ,
    {0x8e7d, 0x69, 0, 0, 0}
    ,
    {0x8e7e, 0x2f, 0, 0, 0}
    ,
    {0x8e7f, 0xf5, 0, 0, 0}
    ,
    {0x8e80, 0x69, 0, 0, 0}
    ,
    {0x8e81, 0xe5, 0, 0, 0}
    ,
    {0x8e82, 0x68, 0, 0, 0}
    ,
    {0x8e83, 0x3e, 0, 0, 0}
    ,
    {0x8e84, 0xf5, 0, 0, 0}
    ,
    {0x8e85, 0x68, 0, 0, 0}
    ,
    {0x8e86, 0xed, 0, 0, 0}
    ,
    {0x8e87, 0x35, 0, 0, 0}
    ,
    {0x8e88, 0x67, 0, 0, 0}
    ,
    {0x8e89, 0xf5, 0, 0, 0}
    ,
    {0x8e8a, 0x67, 0, 0, 0}
    ,
    {0x8e8b, 0xec, 0, 0, 0}
    ,
    {0x8e8c, 0x35, 0, 0, 0}
    ,
    {0x8e8d, 0x66, 0, 0, 0}
    ,
    {0x8e8e, 0xf5, 0, 0, 0}
    ,
    {0x8e8f, 0x66, 0, 0, 0}
    ,
    {0x8e90, 0xd3, 0, 0, 0}
    ,
    {0x8e91, 0xe5, 0, 0, 0}
    ,
    {0x8e92, 0x69, 0, 0, 0}
    ,
    {0x8e93, 0x94, 0, 0, 0}
    ,
    {0x8e94, 0xff, 0, 0, 0}
    ,
    {0x8e95, 0xe5, 0, 0, 0}
    ,
    {0x8e96, 0x68, 0, 0, 0}
    ,
    {0x8e97, 0x94, 0, 0, 0}
    ,
    {0x8e98, 0x03, 0, 0, 0}
    ,
    {0x8e99, 0x40, 0, 0, 0}
    ,
    {0x8e9a, 0x06, 0, 0, 0}
    ,
    {0x8e9b, 0x7e, 0, 0, 0}
    ,
    {0x8e9c, 0x03, 0, 0, 0}
    ,
    {0x8e9d, 0x7f, 0, 0, 0}
    ,
    {0x8e9e, 0xff, 0, 0, 0}
    ,
    {0x8e9f, 0x80, 0, 0, 0}
    ,
    {0x8ea0, 0x04, 0, 0, 0}
    ,
    {0x8ea1, 0xae, 0, 0, 0}
    ,
    {0x8ea2, 0x68, 0, 0, 0}
    ,
    {0x8ea3, 0xaf, 0, 0, 0}
    ,
    {0x8ea4, 0x69, 0, 0, 0}
    ,
    {0x8ea5, 0x8e, 0, 0, 0}
    ,
    {0x8ea6, 0x68, 0, 0, 0}
    ,
    {0x8ea7, 0x8f, 0, 0, 0}
    ,
    {0x8ea8, 0x69, 0, 0, 0}
    ,
    {0x8ea9, 0x85, 0, 0, 0}
    ,
    {0x8eaa, 0x68, 0, 0, 0}
    ,
    {0x8eab, 0x64, 0, 0, 0}
    ,
    {0x8eac, 0x85, 0, 0, 0}
    ,
    {0x8ead, 0x69, 0, 0, 0}
    ,
    {0x8eae, 0x65, 0, 0, 0}
    ,
    {0x8eaf, 0xe5, 0, 0, 0}
    ,
    {0x8eb0, 0x69, 0, 0, 0}
    ,
    {0x8eb1, 0xc4, 0, 0, 0}
    ,
    {0x8eb2, 0xf8, 0, 0, 0}
    ,
    {0x8eb3, 0x54, 0, 0, 0}
    ,
    {0x8eb4, 0x0f, 0, 0, 0}
    ,
    {0x8eb5, 0xc8, 0, 0, 0}
    ,
    {0x8eb6, 0x68, 0, 0, 0}
    ,
    {0x8eb7, 0xf5, 0, 0, 0}
    ,
    {0x8eb8, 0x69, 0, 0, 0}
    ,
    {0x8eb9, 0xe5, 0, 0, 0}
    ,
    {0x8eba, 0x68, 0, 0, 0}
    ,
    {0x8ebb, 0xc4, 0, 0, 0}
    ,
    {0x8ebc, 0x54, 0, 0, 0}
    ,
    {0x8ebd, 0xf0, 0, 0, 0}
    ,
    {0x8ebe, 0x48, 0, 0, 0}
    ,
    {0x8ebf, 0xf5, 0, 0, 0}
    ,
    {0x8ec0, 0x68, 0, 0, 0}
    ,
    {0x8ec1, 0x85, 0, 0, 0}
    ,
    {0x8ec2, 0x68, 0, 0, 0}
    ,
    {0x8ec3, 0x0d, 0, 0, 0}
    ,
    {0x8ec4, 0x85, 0, 0, 0}
    ,
    {0x8ec5, 0x69, 0, 0, 0}
    ,
    {0x8ec6, 0x0e, 0, 0, 0}
    ,
    {0x8ec7, 0x12, 0, 0, 0}
    ,
    {0x8ec8, 0x0a, 0, 0, 0}
    ,
    {0x8ec9, 0x33, 0, 0, 0}
    ,
    {0x8eca, 0xe4, 0, 0, 0}
    ,
    {0x8ecb, 0xf5, 0, 0, 0}
    ,
    {0x8ecc, 0x67, 0, 0, 0}
    ,
    {0x8ecd, 0xf5, 0, 0, 0}
    ,
    {0x8ece, 0x67, 0, 0, 0}
    ,
    {0x8ecf, 0xe5, 0, 0, 0}
    ,
    {0x8ed0, 0x67, 0, 0, 0}
    ,
    {0x8ed1, 0xd3, 0, 0, 0}
    ,
    {0x8ed2, 0x95, 0, 0, 0}
    ,
    {0x8ed3, 0x7c, 0, 0, 0}
    ,
    {0x8ed4, 0x50, 0, 0, 0}
    ,
    {0x8ed5, 0x1c, 0, 0, 0}
    ,
    {0x8ed6, 0x12, 0, 0, 0}
    ,
    {0x8ed7, 0x02, 0, 0, 0}
    ,
    {0x8ed8, 0x45, 0, 0, 0}
    ,
    {0x8ed9, 0xaf, 0, 0, 0}
    ,
    {0x8eda, 0x67, 0, 0, 0}
    ,
    {0x8edb, 0x75, 0, 0, 0}
    ,
    {0x8edc, 0xf0, 0, 0, 0}
    ,
    {0x8edd, 0x02, 0, 0, 0}
    ,
    {0x8ede, 0xef, 0, 0, 0}
    ,
    {0x8edf, 0x12, 0, 0, 0}
    ,
    {0x8ee0, 0x0a, 0, 0, 0}
    ,
    {0x8ee1, 0x01, 0, 0, 0}
    ,
    {0x8ee2, 0xc3, 0, 0, 0}
    ,
    {0x8ee3, 0x74, 0, 0, 0}
    ,
    {0x8ee4, 0x01, 0, 0, 0}
    ,
    {0x8ee5, 0x93, 0, 0, 0}
    ,
    {0x8ee6, 0x95, 0, 0, 0}
    ,
    {0x8ee7, 0x69, 0, 0, 0}
    ,
    {0x8ee8, 0xe4, 0, 0, 0}
    ,
    {0x8ee9, 0x93, 0, 0, 0}
    ,
    {0x8eea, 0x95, 0, 0, 0}
    ,
    {0x8eeb, 0x68, 0, 0, 0}
    ,
    {0x8eec, 0x50, 0, 0, 0}
    ,
    {0x8eed, 0x04, 0, 0, 0}
    ,
    {0x8eee, 0x05, 0, 0, 0}
    ,
    {0x8eef, 0x67, 0, 0, 0}
    ,
    {0x8ef0, 0x80, 0, 0, 0}
    ,
    {0x8ef1, 0xdd, 0, 0, 0}
    ,
    {0x8ef2, 0x85, 0, 0, 0}
    ,
    {0x8ef3, 0x67, 0, 0, 0}
    ,
    {0x8ef4, 0x7d, 0, 0, 0}
    ,
    {0x8ef5, 0x90, 0, 0, 0}
    ,
    {0x8ef6, 0x30, 0, 0, 0}
    ,
    {0x8ef7, 0x25, 0, 0, 0}
    ,
    {0x8ef8, 0xe4, 0, 0, 0}
    ,
    {0x8ef9, 0xf0, 0, 0, 0}
    ,
    {0x8efa, 0xd2, 0, 0, 0}
    ,
    {0x8efb, 0x34, 0, 0, 0}
    ,
    {0x8efc, 0x22, 0, 0, 0}
    ,
    {0x8efd, 0xe5, 0, 0, 0}
    ,
    {0x8efe, 0x33, 0, 0, 0}
    ,
    {0x8eff, 0x70, 0, 0, 0}
    ,
    {0x8f00, 0x03, 0, 0, 0}
    ,
    {0x8f01, 0x02, 0, 0, 0}
    ,
    {0x8f02, 0x0f, 0, 0, 0}
    ,
    {0x8f03, 0xfa, 0, 0, 0}
    ,
    {0x8f04, 0xc2, 0, 0, 0}
    ,
    {0x8f05, 0xaf, 0, 0, 0}
    ,
    {0x8f06, 0xaf, 0, 0, 0}
    ,
    {0x8f07, 0x33, 0, 0, 0}
    ,
    {0x8f08, 0xe4, 0, 0, 0}
    ,
    {0x8f09, 0xf5, 0, 0, 0}
    ,
    {0x8f0a, 0x33, 0, 0, 0}
    ,
    {0x8f0b, 0xd2, 0, 0, 0}
    ,
    {0x8f0c, 0xaf, 0, 0, 0}
    ,
    {0x8f0d, 0x90, 0, 0, 0}
    ,
    {0x8f0e, 0x30, 0, 0, 0}
    ,
    {0x8f0f, 0x25, 0, 0, 0}
    ,
    {0x8f10, 0xe0, 0, 0, 0}
    ,
    {0x8f11, 0xf5, 0, 0, 0}
    ,
    {0x8f12, 0x7e, 0, 0, 0}
    ,
    {0x8f13, 0x90, 0, 0, 0}
    ,
    {0x8f14, 0x50, 0, 0, 0}
    ,
    {0x8f15, 0x82, 0, 0, 0}
    ,
    {0x8f16, 0xe0, 0, 0, 0}
    ,
    {0x8f17, 0xf5, 0, 0, 0}
    ,
    {0x8f18, 0x66, 0, 0, 0}
    ,
    {0x8f19, 0xa3, 0, 0, 0}
    ,
    {0x8f1a, 0xe0, 0, 0, 0}
    ,
    {0x8f1b, 0xf5, 0, 0, 0}
    ,
    {0x8f1c, 0x67, 0, 0, 0}
    ,
    {0x8f1d, 0xa3, 0, 0, 0}
    ,
    {0x8f1e, 0xe0, 0, 0, 0}
    ,
    {0x8f1f, 0xf5, 0, 0, 0}
    ,
    {0x8f20, 0x68, 0, 0, 0}
    ,
    {0x8f21, 0xa3, 0, 0, 0}
    ,
    {0x8f22, 0xe0, 0, 0, 0}
    ,
    {0x8f23, 0xf5, 0, 0, 0}
    ,
    {0x8f24, 0x69, 0, 0, 0}
    ,
    {0x8f25, 0xef, 0, 0, 0}
    ,
    {0x8f26, 0x12, 0, 0, 0}
    ,
    {0x8f27, 0x0a, 0, 0, 0}
    ,
    {0x8f28, 0x0d, 0, 0, 0}
    ,
    {0x8f29, 0x0f, 0, 0, 0}
    ,
    {0x8f2a, 0x4e, 0, 0, 0}
    ,
    {0x8f2b, 0x01, 0, 0, 0}
    ,
    {0x8f2c, 0x0f, 0, 0, 0}
    ,
    {0x8f2d, 0x58, 0, 0, 0}
    ,
    {0x8f2e, 0x02, 0, 0, 0}
    ,
    {0x8f2f, 0x0f, 0, 0, 0}
    ,
    {0x8f30, 0x62, 0, 0, 0}
    ,
    {0x8f31, 0x03, 0, 0, 0}
    ,
    {0x8f32, 0x0f, 0, 0, 0}
    ,
    {0x8f33, 0x77, 0, 0, 0}
    ,
    {0x8f34, 0x05, 0, 0, 0}
    ,
    {0x8f35, 0x0f, 0, 0, 0}
    ,
    {0x8f36, 0x9a, 0, 0, 0}
    ,
    {0x8f37, 0x06, 0, 0, 0}
    ,
    {0x8f38, 0x0f, 0, 0, 0}
    ,
    {0x8f39, 0x88, 0, 0, 0}
    ,
    {0x8f3a, 0x08, 0, 0, 0}
    ,
    {0x8f3b, 0x0f, 0, 0, 0}
    ,
    {0x8f3c, 0xad, 0, 0, 0}
    ,
    {0x8f3d, 0x10, 0, 0, 0}
    ,
    {0x8f3e, 0x0f, 0, 0, 0}
    ,
    {0x8f3f, 0xc1, 0, 0, 0}
    ,
    {0x8f40, 0x12, 0, 0, 0}
    ,
    {0x8f41, 0x0f, 0, 0, 0}
    ,
    {0x8f42, 0xc6, 0, 0, 0}
    ,
    {0x8f43, 0x20, 0, 0, 0}
    ,
    {0x8f44, 0x0f, 0, 0, 0}
    ,
    {0x8f45, 0xd4, 0, 0, 0}
    ,
    {0x8f46, 0x30, 0, 0, 0}
    ,
    {0x8f47, 0x0f, 0, 0, 0}
    ,
    {0x8f48, 0xdf, 0, 0, 0}
    ,
    {0x8f49, 0x50, 0, 0, 0}
    ,
    {0x8f4a, 0x00, 0, 0, 0}
    ,
    {0x8f4b, 0x00, 0, 0, 0}
    ,
    {0x8f4c, 0x0f, 0, 0, 0}
    ,
    {0x8f4d, 0xec, 0, 0, 0}
    ,
    {0x8f4e, 0x20, 0, 0, 0}
    ,
    {0x8f4f, 0x37, 0, 0, 0}
    ,
    {0x8f50, 0xfd, 0, 0, 0}
    ,
    {0x8f51, 0xd2, 0, 0, 0}
    ,
    {0x8f52, 0x39, 0, 0, 0}
    ,
    {0x8f53, 0xd2, 0, 0, 0}
    ,
    {0x8f54, 0x37, 0, 0, 0}
    ,
    {0x8f55, 0x02, 0, 0, 0}
    ,
    {0x8f56, 0x0f, 0, 0, 0}
    ,
    {0x8f57, 0xec, 0, 0, 0}
    ,
    {0x8f58, 0x20, 0, 0, 0}
    ,
    {0x8f59, 0x37, 0, 0, 0}
    ,
    {0x8f5a, 0xfd, 0, 0, 0}
    ,
    {0x8f5b, 0xc2, 0, 0, 0}
    ,
    {0x8f5c, 0x39, 0, 0, 0}
    ,
    {0x8f5d, 0xd2, 0, 0, 0}
    ,
    {0x8f5e, 0x37, 0, 0, 0}
    ,
    {0x8f5f, 0x02, 0, 0, 0}
    ,
    {0x8f60, 0x0f, 0, 0, 0}
    ,
    {0x8f61, 0xec, 0, 0, 0}
    ,
    {0x8f62, 0x20, 0, 0, 0}
    ,
    {0x8f63, 0x05, 0, 0, 0}
    ,
    {0x8f64, 0x03, 0, 0, 0}
    ,
    {0x8f65, 0x02, 0, 0, 0}
    ,
    {0x8f66, 0x0f, 0, 0, 0}
    ,
    {0x8f67, 0xec, 0, 0, 0}
    ,
    {0x8f68, 0x30, 0, 0, 0}
    ,
    {0x8f69, 0x00, 0, 0, 0}
    ,
    {0x8f6a, 0x03, 0, 0, 0}
    ,
    {0x8f6b, 0x02, 0, 0, 0}
    ,
    {0x8f6c, 0x0f, 0, 0, 0}
    ,
    {0x8f6d, 0xec, 0, 0, 0}
    ,
    {0x8f6e, 0xd2, 0, 0, 0}
    ,
    {0x8f6f, 0x07, 0, 0, 0}
    ,
    {0x8f70, 0xc2, 0, 0, 0}
    ,
    {0x8f71, 0x06, 0, 0, 0}
    ,
    {0x8f72, 0x12, 0, 0, 0}
    ,
    {0x8f73, 0x02, 0, 0, 0}
    ,
    {0x8f74, 0xb9, 0, 0, 0}
    ,
    {0x8f75, 0x80, 0, 0, 0}
    ,
    {0x8f76, 0x1d, 0, 0, 0}
    ,
    {0x8f77, 0x30, 0, 0, 0}
    ,
    {0x8f78, 0x05, 0, 0, 0}
    ,
    {0x8f79, 0x72, 0, 0, 0}
    ,
    {0x8f7a, 0x20, 0, 0, 0}
    ,
    {0x8f7b, 0x00, 0, 0, 0}
    ,
    {0x8f7c, 0x6f, 0, 0, 0}
    ,
    {0x8f7d, 0xc2, 0, 0, 0}
    ,
    {0x8f7e, 0x07, 0, 0, 0}
    ,
    {0x8f7f, 0xd2, 0, 0, 0}
    ,
    {0x8f80, 0x06, 0, 0, 0}
    ,
    {0x8f81, 0x12, 0, 0, 0}
    ,
    {0x8f82, 0x02, 0, 0, 0}
    ,
    {0x8f83, 0xc4, 0, 0, 0}
    ,
    {0x8f84, 0xc2, 0, 0, 0}
    ,
    {0x8f85, 0x04, 0, 0, 0}
    ,
    {0x8f86, 0x80, 0, 0, 0}
    ,
    {0x8f87, 0x64, 0, 0, 0}
    ,
    {0x8f88, 0x12, 0, 0, 0}
    ,
    {0x8f89, 0x02, 0, 0, 0}
    ,
    {0x8f8a, 0x6c, 0, 0, 0}
    ,
    {0x8f8b, 0x30, 0, 0, 0}
    ,
    {0x8f8c, 0x05, 0, 0, 0}
    ,
    {0x8f8d, 0x06, 0, 0, 0}
    ,
    {0x8f8e, 0xe4, 0, 0, 0}
    ,
    {0x8f8f, 0xf5, 0, 0, 0}
    ,
    {0x8f90, 0x0c, 0, 0, 0}
    ,
    {0x8f91, 0x12, 0, 0, 0}
    ,
    {0x8f92, 0x13, 0, 0, 0}
    ,
    {0x8f93, 0x6b, 0, 0, 0}
    ,
    {0x8f94, 0xc2, 0, 0, 0}
    ,
    {0x8f95, 0x31, 0, 0, 0}
    ,
    {0x8f96, 0xd2, 0, 0, 0}
    ,
    {0x8f97, 0x34, 0, 0, 0}
    ,
    {0x8f98, 0x80, 0, 0, 0}
    ,
    {0x8f99, 0x52, 0, 0, 0}
    ,
    {0x8f9a, 0x30, 0, 0, 0}
    ,
    {0x8f9b, 0x07, 0, 0, 0}
    ,
    {0x8f9c, 0x0a, 0, 0, 0}
    ,
    {0x8f9d, 0x30, 0, 0, 0}
    ,
    {0x8f9e, 0x06, 0, 0, 0}
    ,
    {0x8f9f, 0x07, 0, 0, 0}
    ,
    {0x8fa0, 0x12, 0, 0, 0}
    ,
    {0x8fa1, 0x02, 0, 0, 0}
    ,
    {0x8fa2, 0xb9, 0, 0, 0}
    ,
    {0x8fa3, 0xd2, 0, 0, 0}
    ,
    {0x8fa4, 0x31, 0, 0, 0}
    ,
    {0x8fa5, 0x80, 0, 0, 0}
    ,
    {0x8fa6, 0x45, 0, 0, 0}
    ,
    {0x8fa7, 0xd2, 0, 0, 0}
    ,
    {0x8fa8, 0x31, 0, 0, 0}
    ,
    {0x8fa9, 0xd2, 0, 0, 0}
    ,
    {0x8faa, 0x34, 0, 0, 0}
    ,
    {0x8fab, 0x80, 0, 0, 0}
    ,
    {0x8fac, 0x3f, 0, 0, 0}
    ,
    {0x8fad, 0x20, 0, 0, 0}
    ,
    {0x8fae, 0x07, 0, 0, 0}
    ,
    {0x8faf, 0x03, 0, 0, 0}
    ,
    {0x8fb0, 0x30, 0, 0, 0}
    ,
    {0x8fb1, 0x06, 0, 0, 0}
    ,
    {0x8fb2, 0x09, 0, 0, 0}
    ,
    {0x8fb3, 0xe5, 0, 0, 0}
    ,
    {0x8fb4, 0x7e, 0, 0, 0}
    ,
    {0x8fb5, 0x64, 0, 0, 0}
    ,
    {0x8fb6, 0x0e, 0, 0, 0}
    ,
    {0x8fb7, 0x70, 0, 0, 0}
    ,
    {0x8fb8, 0x33, 0, 0, 0}
    ,
    {0x8fb9, 0x20, 0, 0, 0}
    ,
    {0x8fba, 0x00, 0, 0, 0}
    ,
    {0x8fbb, 0x30, 0, 0, 0}
    ,
    {0x8fbc, 0x12, 0, 0, 0}
    ,
    {0x8fbd, 0x05, 0, 0, 0}
    ,
    {0x8fbe, 0x46, 0, 0, 0}
    ,
    {0x8fbf, 0x80, 0, 0, 0}
    ,
    {0x8fc0, 0x2b, 0, 0, 0}
    ,
    {0x8fc1, 0x12, 0, 0, 0}
    ,
    {0x8fc2, 0x07, 0, 0, 0}
    ,
    {0x8fc3, 0x0c, 0, 0, 0}
    ,
    {0x8fc4, 0x80, 0, 0, 0}
    ,
    {0x8fc5, 0x26, 0, 0, 0}
    ,
    {0x8fc6, 0x30, 0, 0, 0}
    ,
    {0x8fc7, 0x05, 0, 0, 0}
    ,
    {0x8fc8, 0x23, 0, 0, 0}
    ,
    {0x8fc9, 0x20, 0, 0, 0}
    ,
    {0x8fca, 0x07, 0, 0, 0}
    ,
    {0x8fcb, 0x20, 0, 0, 0}
    ,
    {0x8fcc, 0x20, 0, 0, 0}
    ,
    {0x8fcd, 0x06, 0, 0, 0}
    ,
    {0x8fce, 0x1d, 0, 0, 0}
    ,
    {0x8fcf, 0x12, 0, 0, 0}
    ,
    {0x8fd0, 0x16, 0, 0, 0}
    ,
    {0x8fd1, 0x8d, 0, 0, 0}
    ,
    {0x8fd2, 0x80, 0, 0, 0}
    ,
    {0x8fd3, 0x18, 0, 0, 0}
    ,
    {0x8fd4, 0x20, 0, 0, 0}
    ,
    {0x8fd5, 0x07, 0, 0, 0}
    ,
    {0x8fd6, 0x15, 0, 0, 0}
    ,
    {0x8fd7, 0x20, 0, 0, 0}
    ,
    {0x8fd8, 0x06, 0, 0, 0}
    ,
    {0x8fd9, 0x12, 0, 0, 0}
    ,
    {0x8fda, 0x12, 0, 0, 0}
    ,
    {0x8fdb, 0x16, 0, 0, 0}
    ,
    {0x8fdc, 0x9c, 0, 0, 0}
    ,
    {0x8fdd, 0x80, 0, 0, 0}
    ,
    {0x8fde, 0x0d, 0, 0, 0}
    ,
    {0x8fdf, 0x90, 0, 0, 0}
    ,
    {0x8fe0, 0x50, 0, 0, 0}
    ,
    {0x8fe1, 0x82, 0, 0, 0}
    ,
    {0x8fe2, 0x30, 0, 0, 0}
    ,
    {0x8fe3, 0x33, 0, 0, 0}
    ,
    {0x8fe4, 0x05, 0, 0, 0}
    ,
    {0x8fe5, 0x74, 0, 0, 0}
    ,
    {0x8fe6, 0x55, 0, 0, 0}
    ,
    {0x8fe7, 0xf0, 0, 0, 0}
    ,
    {0x8fe8, 0x80, 0, 0, 0}
    ,
    {0x8fe9, 0x02, 0, 0, 0}
    ,
    {0x8fea, 0xe4, 0, 0, 0}
    ,
    {0x8feb, 0xf0, 0, 0, 0}
    ,
    {0x8fec, 0x20, 0, 0, 0}
    ,
    {0x8fed, 0x07, 0, 0, 0}
    ,
    {0x8fee, 0x06, 0, 0, 0}
    ,
    {0x8fef, 0x30, 0, 0, 0}
    ,
    {0x8ff0, 0x06, 0, 0, 0}
    ,
    {0x8ff1, 0x03, 0, 0, 0}
    ,
    {0x8ff2, 0x30, 0, 0, 0}
    ,
    {0x8ff3, 0x04, 0, 0, 0}
    ,
    {0x8ff4, 0x05, 0, 0, 0}
    ,
    {0x8ff5, 0x90, 0, 0, 0}
    ,
    {0x8ff6, 0x30, 0, 0, 0}
    ,
    {0x8ff7, 0x25, 0, 0, 0}
    ,
    {0x8ff8, 0xe4, 0, 0, 0}
    ,
    {0x8ff9, 0xf0, 0, 0, 0}
    ,
    {0x8ffa, 0x22, 0, 0, 0}
    ,
    {0x8ffb, 0x12, 0, 0, 0}
    ,
    {0x8ffc, 0x02, 0, 0, 0}
    ,
    {0x8ffd, 0xae, 0, 0, 0}
    ,
    {0x8ffe, 0xb5, 0, 0, 0}
    ,
    {0x8fff, 0x07, 0, 0, 0}
    ,
    {0x9000, 0x03, 0, 0, 0}
    ,
    {0x9001, 0xd3, 0, 0, 0}
    ,
    {0x9002, 0x80, 0, 0, 0}
    ,
    {0x9003, 0x01, 0, 0, 0}
    ,
    {0x9004, 0xc3, 0, 0, 0}
    ,
    {0x9005, 0x40, 0, 0, 0}
    ,
    {0x9006, 0x03, 0, 0, 0}
    ,
    {0x9007, 0x02, 0, 0, 0}
    ,
    {0x9008, 0x10, 0, 0, 0}
    ,
    {0x9009, 0x9a, 0, 0, 0}
    ,
    {0x900a, 0x90, 0, 0, 0}
    ,
    {0x900b, 0x30, 0, 0, 0}
    ,
    {0x900c, 0x04, 0, 0, 0}
    ,
    {0x900d, 0xe0, 0, 0, 0}
    ,
    {0x900e, 0x44, 0, 0, 0}
    ,
    {0x900f, 0x20, 0, 0, 0}
    ,
    {0x9010, 0xf0, 0, 0, 0}
    ,
    {0x9011, 0xa3, 0, 0, 0}
    ,
    {0x9012, 0xe0, 0, 0, 0}
    ,
    {0x9013, 0x44, 0, 0, 0}
    ,
    {0x9014, 0x40, 0, 0, 0}
    ,
    {0x9015, 0xf0, 0, 0, 0}
    ,
    {0x9016, 0x90, 0, 0, 0}
    ,
    {0x9017, 0x50, 0, 0, 0}
    ,
    {0x9018, 0x25, 0, 0, 0}
    ,
    {0x9019, 0xe0, 0, 0, 0}
    ,
    {0x901a, 0x44, 0, 0, 0}
    ,
    {0x901b, 0x04, 0, 0, 0}
    ,
    {0x901c, 0xf0, 0, 0, 0}
    ,
    {0x901d, 0x90, 0, 0, 0}
    ,
    {0x901e, 0x50, 0, 0, 0}
    ,
    {0x901f, 0x03, 0, 0, 0}
    ,
    {0x9020, 0xe0, 0, 0, 0}
    ,
    {0x9021, 0x54, 0, 0, 0}
    ,
    {0x9022, 0xfd, 0, 0, 0}
    ,
    {0x9023, 0xf0, 0, 0, 0}
    ,
    {0x9024, 0x90, 0, 0, 0}
    ,
    {0x9025, 0x50, 0, 0, 0}
    ,
    {0x9026, 0x27, 0, 0, 0}
    ,
    {0x9027, 0xe0, 0, 0, 0}
    ,
    {0x9028, 0x44, 0, 0, 0}
    ,
    {0x9029, 0x01, 0, 0, 0}
    ,
    {0x902a, 0xf0, 0, 0, 0}
    ,
    {0x902b, 0x90, 0, 0, 0}
    ,
    {0x902c, 0x50, 0, 0, 0}
    ,
    {0x902d, 0x31, 0, 0, 0}
    ,
    {0x902e, 0xe4, 0, 0, 0}
    ,
    {0x902f, 0xf0, 0, 0, 0}
    ,
    {0x9030, 0x90, 0, 0, 0}
    ,
    {0x9031, 0x50, 0, 0, 0}
    ,
    {0x9032, 0x33, 0, 0, 0}
    ,
    {0x9033, 0xf0, 0, 0, 0}
    ,
    {0x9034, 0x90, 0, 0, 0}
    ,
    {0x9035, 0x30, 0, 0, 0}
    ,
    {0x9036, 0x1e, 0, 0, 0}
    ,
    {0x9037, 0x12, 0, 0, 0}
    ,
    {0x9038, 0x01, 0, 0, 0}
    ,
    {0x9039, 0xef, 0, 0, 0}
    ,
    {0x903a, 0x90, 0, 0, 0}
    ,
    {0x903b, 0x30, 0, 0, 0}
    ,
    {0x903c, 0x18, 0, 0, 0}
    ,
    {0x903d, 0x12, 0, 0, 0}
    ,
    {0x903e, 0x01, 0, 0, 0}
    ,
    {0x903f, 0xef, 0, 0, 0}
    ,
    {0x9040, 0x90, 0, 0, 0}
    ,
    {0x9041, 0x30, 0, 0, 0}
    ,
    {0x9042, 0x1b, 0, 0, 0}
    ,
    {0x9043, 0x12, 0, 0, 0}
    ,
    {0x9044, 0x01, 0, 0, 0}
    ,
    {0x9045, 0xef, 0, 0, 0}
    ,
    {0x9046, 0xe0, 0, 0, 0}
    ,
    {0x9047, 0xf5, 0, 0, 0}
    ,
    {0x9048, 0x25, 0, 0, 0}
    ,
    {0x9049, 0x90, 0, 0, 0}
    ,
    {0x904a, 0x30, 0, 0, 0}
    ,
    {0x904b, 0x18, 0, 0, 0}
    ,
    {0x904c, 0xe0, 0, 0, 0}
    ,
    {0x904d, 0xf5, 0, 0, 0}
    ,
    {0x904e, 0x21, 0, 0, 0}
    ,
    {0x904f, 0x90, 0, 0, 0}
    ,
    {0x9050, 0x60, 0, 0, 0}
    ,
    {0x9051, 0x00, 0, 0, 0}
    ,
    {0x9052, 0x74, 0, 0, 0}
    ,
    {0x9053, 0xf5, 0, 0, 0}
    ,
    {0x9054, 0xf0, 0, 0, 0}
    ,
    {0x9055, 0x90, 0, 0, 0}
    ,
    {0x9056, 0x3f, 0, 0, 0}
    ,
    {0x9057, 0x01, 0, 0, 0}
    ,
    {0x9058, 0xe4, 0, 0, 0}
    ,
    {0x9059, 0xf0, 0, 0, 0}
    ,
    {0x905a, 0xa3, 0, 0, 0}
    ,
    {0x905b, 0xf0, 0, 0, 0}
    ,
    {0x905c, 0x90, 0, 0, 0}
    ,
    {0x905d, 0x3f, 0, 0, 0}
    ,
    {0x905e, 0x01, 0, 0, 0}
    ,
    {0x905f, 0xe0, 0, 0, 0}
    ,
    {0x9060, 0x44, 0, 0, 0}
    ,
    {0x9061, 0x08, 0, 0, 0}
    ,
    {0x9062, 0xf0, 0, 0, 0}
    ,
    {0x9063, 0xe0, 0, 0, 0}
    ,
    {0x9064, 0x44, 0, 0, 0}
    ,
    {0x9065, 0x20, 0, 0, 0}
    ,
    {0x9066, 0xf0, 0, 0, 0}
    ,
    {0x9067, 0x90, 0, 0, 0}
    ,
    {0x9068, 0x3f, 0, 0, 0}
    ,
    {0x9069, 0x05, 0, 0, 0}
    ,
    {0x906a, 0x74, 0, 0, 0}
    ,
    {0x906b, 0x30, 0, 0, 0}
    ,
    {0x906c, 0xf0, 0, 0, 0}
    ,
    {0x906d, 0xa3, 0, 0, 0}
    ,
    {0x906e, 0x74, 0, 0, 0}
    ,
    {0x906f, 0x24, 0, 0, 0}
    ,
    {0x9070, 0xf0, 0, 0, 0}
    ,
    {0x9071, 0x90, 0, 0, 0}
    ,
    {0x9072, 0x3f, 0, 0, 0}
    ,
    {0x9073, 0x0b, 0, 0, 0}
    ,
    {0x9074, 0xe0, 0, 0, 0}
    ,
    {0x9075, 0x44, 0, 0, 0}
    ,
    {0x9076, 0x0f, 0, 0, 0}
    ,
    {0x9077, 0xf0, 0, 0, 0}
    ,
    {0x9078, 0x90, 0, 0, 0}
    ,
    {0x9079, 0x3f, 0, 0, 0}
    ,
    {0x907a, 0x01, 0, 0, 0}
    ,
    {0x907b, 0xe0, 0, 0, 0}
    ,
    {0x907c, 0x44, 0, 0, 0}
    ,
    {0x907d, 0x02, 0, 0, 0}
    ,
    {0x907e, 0xf0, 0, 0, 0}
    ,
    {0x907f, 0xc2, 0, 0, 0}
    ,
    {0x9080, 0x8c, 0, 0, 0}
    ,
    {0x9081, 0x75, 0, 0, 0}
    ,
    {0x9082, 0x89, 0, 0, 0}
    ,
    {0x9083, 0x03, 0, 0, 0}
    ,
    {0x9084, 0x75, 0, 0, 0}
    ,
    {0x9085, 0xa8, 0, 0, 0}
    ,
    {0x9086, 0x07, 0, 0, 0}
    ,
    {0x9087, 0x75, 0, 0, 0}
    ,
    {0x9088, 0xb8, 0, 0, 0}
    ,
    {0x9089, 0x04, 0, 0, 0}
    ,
    {0x908a, 0xe4, 0, 0, 0}
    ,
    {0x908b, 0xf5, 0, 0, 0}
    ,
    {0x908c, 0xd8, 0, 0, 0}
    ,
    {0x908d, 0xf5, 0, 0, 0}
    ,
    {0x908e, 0xe8, 0, 0, 0}
    ,
    {0x908f, 0x90, 0, 0, 0}
    ,
    {0x9090, 0x30, 0, 0, 0}
    ,
    {0x9091, 0x01, 0, 0, 0}
    ,
    {0x9092, 0xe0, 0, 0, 0}
    ,
    {0x9093, 0x44, 0, 0, 0}
    ,
    {0x9094, 0x40, 0, 0, 0}
    ,
    {0x9095, 0xf0, 0, 0, 0}
    ,
    {0x9096, 0xe0, 0, 0, 0}
    ,
    {0x9097, 0x54, 0, 0, 0}
    ,
    {0x9098, 0xbf, 0, 0, 0}
    ,
    {0x9099, 0xf0, 0, 0, 0}
    ,
    {0x909a, 0x22, 0, 0, 0}
    ,
    {0x909b, 0xc2, 0, 0, 0}
    ,
    {0x909c, 0x34, 0, 0, 0}
    ,
    {0x909d, 0x20, 0, 0, 0}
    ,
    {0x909e, 0x05, 0, 0, 0}
    ,
    {0x909f, 0x06, 0, 0, 0}
    ,
    {0x90a0, 0x75, 0, 0, 0}
    ,
    {0x90a1, 0x0a, 0, 0, 0}
    ,
    {0x90a2, 0xee, 0, 0, 0}
    ,
    {0x90a3, 0x02, 0, 0, 0}
    ,
    {0x90a4, 0x11, 0, 0, 0}
    ,
    {0x90a5, 0x1c, 0, 0, 0}
    ,
    {0x90a6, 0x20, 0, 0, 0}
    ,
    {0x90a7, 0x07, 0, 0, 0}
    ,
    {0x90a8, 0x12, 0, 0, 0}
    ,
    {0x90a9, 0x20, 0, 0, 0}
    ,
    {0x90aa, 0x06, 0, 0, 0}
    ,
    {0x90ab, 0x0f, 0, 0, 0}
    ,
    {0x90ac, 0xe4, 0, 0, 0}
    ,
    {0x90ad, 0xf5, 0, 0, 0}
    ,
    {0x90ae, 0x0a, 0, 0, 0}
    ,
    {0x90af, 0x30, 0, 0, 0}
    ,
    {0x90b0, 0x39, 0, 0, 0}
    ,
    {0x90b1, 0x6a, 0, 0, 0}
    ,
    {0x90b2, 0x20, 0, 0, 0}
    ,
    {0x90b3, 0x37, 0, 0, 0}
    ,
    {0x90b4, 0xfd, 0, 0, 0}
    ,
    {0x90b5, 0xc2, 0, 0, 0}
    ,
    {0x90b6, 0x39, 0, 0, 0}
    ,
    {0x90b7, 0xd2, 0, 0, 0}
    ,
    {0x90b8, 0x37, 0, 0, 0}
    ,
    {0x90b9, 0x80, 0, 0, 0}
    ,
    {0x90ba, 0x61, 0, 0, 0}
    ,
    {0x90bb, 0x20, 0, 0, 0}
    ,
    {0x90bc, 0x07, 0, 0, 0}
    ,
    {0x90bd, 0x08, 0, 0, 0}
    ,
    {0x90be, 0x30, 0, 0, 0}
    ,
    {0x90bf, 0x06, 0, 0, 0}
    ,
    {0x90c0, 0x05, 0, 0, 0}
    ,
    {0x90c1, 0x75, 0, 0, 0}
    ,
    {0x90c2, 0x0a, 0, 0, 0}
    ,
    {0x90c3, 0x20, 0, 0, 0}
    ,
    {0x90c4, 0x80, 0, 0, 0}
    ,
    {0x90c5, 0x56, 0, 0, 0}
    ,
    {0x90c6, 0x30, 0, 0, 0}
    ,
    {0x90c7, 0x00, 0, 0, 0}
    ,
    {0x90c8, 0x22, 0, 0, 0}
    ,
    {0x90c9, 0x75, 0, 0, 0}
    ,
    {0x90ca, 0x0a, 0, 0, 0}
    ,
    {0x90cb, 0x01, 0, 0, 0}
    ,
    {0x90cc, 0x30, 0, 0, 0}
    ,
    {0x90cd, 0x39, 0, 0, 0}
    ,
    {0x90ce, 0x07, 0, 0, 0}
    ,
    {0x90cf, 0x20, 0, 0, 0}
    ,
    {0x90d0, 0x37, 0, 0, 0}
    ,
    {0x90d1, 0xfd, 0, 0, 0}
    ,
    {0x90d2, 0xc2, 0, 0, 0}
    ,
    {0x90d3, 0x39, 0, 0, 0}
    ,
    {0x90d4, 0xd2, 0, 0, 0}
    ,
    {0x90d5, 0x37, 0, 0, 0}
    ,
    {0x90d6, 0x90, 0, 0, 0}
    ,
    {0x90d7, 0x50, 0, 0, 0}
    ,
    {0x90d8, 0x34, 0, 0, 0}
    ,
    {0x90d9, 0x74, 0, 0, 0}
    ,
    {0x90da, 0xff, 0, 0, 0}
    ,
    {0x90db, 0xf0, 0, 0, 0}
    ,
    {0x90dc, 0xa3, 0, 0, 0}
    ,
    {0x90dd, 0x74, 0, 0, 0}
    ,
    {0x90de, 0x80, 0, 0, 0}
    ,
    {0x90df, 0xf0, 0, 0, 0}
    ,
    {0x90e0, 0xa3, 0, 0, 0}
    ,
    {0x90e1, 0xf0, 0, 0, 0}
    ,
    {0x90e2, 0x20, 0, 0, 0}
    ,
    {0x90e3, 0x37, 0, 0, 0}
    ,
    {0x90e4, 0xfd, 0, 0, 0}
    ,
    {0x90e5, 0xd2, 0, 0, 0}
    ,
    {0x90e6, 0x39, 0, 0, 0}
    ,
    {0x90e7, 0xd2, 0, 0, 0}
    ,
    {0x90e8, 0x37, 0, 0, 0}
    ,
    {0x90e9, 0x80, 0, 0, 0}
    ,
    {0x90ea, 0x31, 0, 0, 0}
    ,
    {0x90eb, 0xe5, 0, 0, 0}
    ,
    {0x90ec, 0x20, 0, 0, 0}
    ,
    {0x90ed, 0x54, 0, 0, 0}
    ,
    {0x90ee, 0x07, 0, 0, 0}
    ,
    {0x90ef, 0x64, 0, 0, 0}
    ,
    {0x90f0, 0x06, 0, 0, 0}
    ,
    {0x90f1, 0x70, 0, 0, 0}
    ,
    {0x90f2, 0x26, 0, 0, 0}
    ,
    {0x90f3, 0x20, 0, 0, 0}
    ,
    {0x90f4, 0x37, 0, 0, 0}
    ,
    {0x90f5, 0xfd, 0, 0, 0}
    ,
    {0x90f6, 0xc2, 0, 0, 0}
    ,
    {0x90f7, 0x39, 0, 0, 0}
    ,
    {0x90f8, 0xd2, 0, 0, 0}
    ,
    {0x90f9, 0x37, 0, 0, 0}
    ,
    {0x90fa, 0x30, 0, 0, 0}
    ,
    {0x90fb, 0x31, 0, 0, 0}
    ,
    {0x90fc, 0x05, 0, 0, 0}
    ,
    {0x90fd, 0x30, 0, 0, 0}
    ,
    {0x90fe, 0x37, 0, 0, 0}
    ,
    {0x90ff, 0x0c, 0, 0, 0}
    ,
    {0x9100, 0x80, 0, 0, 0}
    ,
    {0x9101, 0xfb, 0, 0, 0}
    ,
    {0x9102, 0x12, 0, 0, 0}
    ,
    {0x9103, 0x02, 0, 0, 0}
    ,
    {0x9104, 0x5d, 0, 0, 0}
    ,
    {0x9105, 0x20, 0, 0, 0}
    ,
    {0x9106, 0x37, 0, 0, 0}
    ,
    {0x9107, 0xfd, 0, 0, 0}
    ,
    {0x9108, 0xd2, 0, 0, 0}
    ,
    {0x9109, 0x39, 0, 0, 0}
    ,
    {0x910a, 0xd2, 0, 0, 0}
    ,
    {0x910b, 0x37, 0, 0, 0}
    ,
    {0x910c, 0x30, 0, 0, 0}
    ,
    {0x910d, 0x31, 0, 0, 0}
    ,
    {0x910e, 0x04, 0, 0, 0}
    ,
    {0x910f, 0x7f, 0, 0, 0}
    ,
    {0x9110, 0x12, 0, 0, 0}
    ,
    {0x9111, 0x80, 0, 0, 0}
    ,
    {0x9112, 0x02, 0, 0, 0}
    ,
    {0x9113, 0x7f, 0, 0, 0}
    ,
    {0x9114, 0x02, 0, 0, 0}
    ,
    {0x9115, 0x8f, 0, 0, 0}
    ,
    {0x9116, 0x0a, 0, 0, 0}
    ,
    {0x9117, 0x80, 0, 0, 0}
    ,
    {0x9118, 0x03, 0, 0, 0}
    ,
    {0x9119, 0x75, 0, 0, 0}
    ,
    {0x911a, 0x0a, 0, 0, 0}
    ,
    {0x911b, 0xfe, 0, 0, 0}
    ,
    {0x911c, 0x90, 0, 0, 0}
    ,
    {0x911d, 0x30, 0, 0, 0}
    ,
    {0x911e, 0x27, 0, 0, 0}
    ,
    {0x911f, 0xe5, 0, 0, 0}
    ,
    {0x9120, 0x0a, 0, 0, 0}
    ,
    {0x9121, 0xf0, 0, 0, 0}
    ,
    {0x9122, 0xe5, 0, 0, 0}
    ,
    {0x9123, 0x23, 0, 0, 0}
    ,
    {0x9124, 0x54, 0, 0, 0}
    ,
    {0x9125, 0xf8, 0, 0, 0}
    ,
    {0x9126, 0xf5, 0, 0, 0}
    ,
    {0x9127, 0x0a, 0, 0, 0}
    ,
    {0x9128, 0xe5, 0, 0, 0}
    ,
    {0x9129, 0x79, 0, 0, 0}
    ,
    {0x912a, 0x25, 0, 0, 0}
    ,
    {0x912b, 0x0a, 0, 0, 0}
    ,
    {0x912c, 0xf5, 0, 0, 0}
    ,
    {0x912d, 0x0a, 0, 0, 0}
    ,
    {0x912e, 0x90, 0, 0, 0}
    ,
    {0x912f, 0x30, 0, 0, 0}
    ,
    {0x9130, 0x26, 0, 0, 0}
    ,
    {0x9131, 0xe5, 0, 0, 0}
    ,
    {0x9132, 0x0a, 0, 0, 0}
    ,
    {0x9133, 0xf0, 0, 0, 0}
    ,
    {0x9134, 0x22, 0, 0, 0}
    ,
    {0x9135, 0x30, 0, 0, 0}
    ,
    {0x9136, 0x3f, 0, 0, 0}
    ,
    {0x9137, 0x09, 0, 0, 0}
    ,
    {0x9138, 0x30, 0, 0, 0}
    ,
    {0x9139, 0x20, 0, 0, 0}
    ,
    {0x913a, 0x06, 0, 0, 0}
    ,
    {0x913b, 0xae, 0, 0, 0}
    ,
    {0x913c, 0x56, 0, 0, 0}
    ,
    {0x913d, 0xaf, 0, 0, 0}
    ,
    {0x913e, 0x57, 0, 0, 0}
    ,
    {0x913f, 0x80, 0, 0, 0}
    ,
    {0x9140, 0x04, 0, 0, 0}
    ,
    {0x9141, 0xae, 0, 0, 0}
    ,
    {0x9142, 0x6a, 0, 0, 0}
    ,
    {0x9143, 0xaf, 0, 0, 0}
    ,
    {0x9144, 0x6b, 0, 0, 0}
    ,
    {0x9145, 0x8e, 0, 0, 0}
    ,
    {0x9146, 0x56, 0, 0, 0}
    ,
    {0x9147, 0x8f, 0, 0, 0}
    ,
    {0x9148, 0x57, 0, 0, 0}
    ,
    {0x9149, 0x30, 0, 0, 0}
    ,
    {0x914a, 0x3f, 0, 0, 0}
    ,
    {0x914b, 0x09, 0, 0, 0}
    ,
    {0x914c, 0x30, 0, 0, 0}
    ,
    {0x914d, 0x21, 0, 0, 0}
    ,
    {0x914e, 0x06, 0, 0, 0}
    ,
    {0x914f, 0xae, 0, 0, 0}
    ,
    {0x9150, 0x58, 0, 0, 0}
    ,
    {0x9151, 0xaf, 0, 0, 0}
    ,
    {0x9152, 0x59, 0, 0, 0}
    ,
    {0x9153, 0x80, 0, 0, 0}
    ,
    {0x9154, 0x04, 0, 0, 0}
    ,
    {0x9155, 0xae, 0, 0, 0}
    ,
    {0x9156, 0x6c, 0, 0, 0}
    ,
    {0x9157, 0xaf, 0, 0, 0}
    ,
    {0x9158, 0x6d, 0, 0, 0}
    ,
    {0x9159, 0x8e, 0, 0, 0}
    ,
    {0x915a, 0x58, 0, 0, 0}
    ,
    {0x915b, 0x8f, 0, 0, 0}
    ,
    {0x915c, 0x59, 0, 0, 0}
    ,
    {0x915d, 0x30, 0, 0, 0}
    ,
    {0x915e, 0x3f, 0, 0, 0}
    ,
    {0x915f, 0x09, 0, 0, 0}
    ,
    {0x9160, 0x30, 0, 0, 0}
    ,
    {0x9161, 0x22, 0, 0, 0}
    ,
    {0x9162, 0x06, 0, 0, 0}
    ,
    {0x9163, 0xae, 0, 0, 0}
    ,
    {0x9164, 0x5a, 0, 0, 0}
    ,
    {0x9165, 0xaf, 0, 0, 0}
    ,
    {0x9166, 0x5b, 0, 0, 0}
    ,
    {0x9167, 0x80, 0, 0, 0}
    ,
    {0x9168, 0x04, 0, 0, 0}
    ,
    {0x9169, 0xae, 0, 0, 0}
    ,
    {0x916a, 0x6e, 0, 0, 0}
    ,
    {0x916b, 0xaf, 0, 0, 0}
    ,
    {0x916c, 0x6f, 0, 0, 0}
    ,
    {0x916d, 0x8e, 0, 0, 0}
    ,
    {0x916e, 0x5a, 0, 0, 0}
    ,
    {0x916f, 0x8f, 0, 0, 0}
    ,
    {0x9170, 0x5b, 0, 0, 0}
    ,
    {0x9171, 0x30, 0, 0, 0}
    ,
    {0x9172, 0x3f, 0, 0, 0}
    ,
    {0x9173, 0x09, 0, 0, 0}
    ,
    {0x9174, 0x30, 0, 0, 0}
    ,
    {0x9175, 0x23, 0, 0, 0}
    ,
    {0x9176, 0x06, 0, 0, 0}
    ,
    {0x9177, 0xae, 0, 0, 0}
    ,
    {0x9178, 0x5c, 0, 0, 0}
    ,
    {0x9179, 0xaf, 0, 0, 0}
    ,
    {0x917a, 0x5d, 0, 0, 0}
    ,
    {0x917b, 0x80, 0, 0, 0}
    ,
    {0x917c, 0x04, 0, 0, 0}
    ,
    {0x917d, 0xae, 0, 0, 0}
    ,
    {0x917e, 0x70, 0, 0, 0}
    ,
    {0x917f, 0xaf, 0, 0, 0}
    ,
    {0x9180, 0x71, 0, 0, 0}
    ,
    {0x9181, 0x8e, 0, 0, 0}
    ,
    {0x9182, 0x5c, 0, 0, 0}
    ,
    {0x9183, 0x8f, 0, 0, 0}
    ,
    {0x9184, 0x5d, 0, 0, 0}
    ,
    {0x9185, 0x30, 0, 0, 0}
    ,
    {0x9186, 0x3f, 0, 0, 0}
    ,
    {0x9187, 0x09, 0, 0, 0}
    ,
    {0x9188, 0x30, 0, 0, 0}
    ,
    {0x9189, 0x24, 0, 0, 0}
    ,
    {0x918a, 0x06, 0, 0, 0}
    ,
    {0x918b, 0xae, 0, 0, 0}
    ,
    {0x918c, 0x5e, 0, 0, 0}
    ,
    {0x918d, 0xaf, 0, 0, 0}
    ,
    {0x918e, 0x5f, 0, 0, 0}
    ,
    {0x918f, 0x80, 0, 0, 0}
    ,
    {0x9190, 0x04, 0, 0, 0}
    ,
    {0x9191, 0xae, 0, 0, 0}
    ,
    {0x9192, 0x72, 0, 0, 0}
    ,
    {0x9193, 0xaf, 0, 0, 0}
    ,
    {0x9194, 0x73, 0, 0, 0}
    ,
    {0x9195, 0x8e, 0, 0, 0}
    ,
    {0x9196, 0x5e, 0, 0, 0}
    ,
    {0x9197, 0x8f, 0, 0, 0}
    ,
    {0x9198, 0x5f, 0, 0, 0}
    ,
    {0x9199, 0x30, 0, 0, 0}
    ,
    {0x919a, 0x3f, 0, 0, 0}
    ,
    {0x919b, 0x09, 0, 0, 0}
    ,
    {0x919c, 0x30, 0, 0, 0}
    ,
    {0x919d, 0x25, 0, 0, 0}
    ,
    {0x919e, 0x06, 0, 0, 0}
    ,
    {0x919f, 0xae, 0, 0, 0}
    ,
    {0x91a0, 0x60, 0, 0, 0}
    ,
    {0x91a1, 0xaf, 0, 0, 0}
    ,
    {0x91a2, 0x61, 0, 0, 0}
    ,
    {0x91a3, 0x80, 0, 0, 0}
    ,
    {0x91a4, 0x04, 0, 0, 0}
    ,
    {0x91a5, 0xae, 0, 0, 0}
    ,
    {0x91a6, 0x74, 0, 0, 0}
    ,
    {0x91a7, 0xaf, 0, 0, 0}
    ,
    {0x91a8, 0x75, 0, 0, 0}
    ,
    {0x91a9, 0x8e, 0, 0, 0}
    ,
    {0x91aa, 0x60, 0, 0, 0}
    ,
    {0x91ab, 0x8f, 0, 0, 0}
    ,
    {0x91ac, 0x61, 0, 0, 0}
    ,
    {0x91ad, 0x30, 0, 0, 0}
    ,
    {0x91ae, 0x3f, 0, 0, 0}
    ,
    {0x91af, 0x09, 0, 0, 0}
    ,
    {0x91b0, 0x30, 0, 0, 0}
    ,
    {0x91b1, 0x26, 0, 0, 0}
    ,
    {0x91b2, 0x06, 0, 0, 0}
    ,
    {0x91b3, 0xae, 0, 0, 0}
    ,
    {0x91b4, 0x62, 0, 0, 0}
    ,
    {0x91b5, 0xaf, 0, 0, 0}
    ,
    {0x91b6, 0x63, 0, 0, 0}
    ,
    {0x91b7, 0x80, 0, 0, 0}
    ,
    {0x91b8, 0x04, 0, 0, 0}
    ,
    {0x91b9, 0xae, 0, 0, 0}
    ,
    {0x91ba, 0x76, 0, 0, 0}
    ,
    {0x91bb, 0xaf, 0, 0, 0}
    ,
    {0x91bc, 0x77, 0, 0, 0}
    ,
    {0x91bd, 0x8e, 0, 0, 0}
    ,
    {0x91be, 0x62, 0, 0, 0}
    ,
    {0x91bf, 0x8f, 0, 0, 0}
    ,
    {0x91c0, 0x63, 0, 0, 0}
    ,
    {0x91c1, 0x22, 0, 0, 0}
    ,
    {0x91c2, 0xd3, 0, 0, 0}
    ,
    {0x91c3, 0xe5, 0, 0, 0}
    ,
    {0x91c4, 0x57, 0, 0, 0}
    ,
    {0x91c5, 0x95, 0, 0, 0}
    ,
    {0x91c6, 0x6b, 0, 0, 0}
    ,
    {0x91c7, 0xe5, 0, 0, 0}
    ,
    {0x91c8, 0x56, 0, 0, 0}
    ,
    {0x91c9, 0x95, 0, 0, 0}
    ,
    {0x91ca, 0x6a, 0, 0, 0}
    ,
    {0x91cb, 0x40, 0, 0, 0}
    ,
    {0x91cc, 0x03, 0, 0, 0}
    ,
    {0x91cd, 0xd3, 0, 0, 0}
    ,
    {0x91ce, 0x80, 0, 0, 0}
    ,
    {0x91cf, 0x01, 0, 0, 0}
    ,
    {0x91d0, 0xc3, 0, 0, 0}
    ,
    {0x91d1, 0x92, 0, 0, 0}
    ,
    {0x91d2, 0x20, 0, 0, 0}
    ,
    {0x91d3, 0xd3, 0, 0, 0}
    ,
    {0x91d4, 0xe5, 0, 0, 0}
    ,
    {0x91d5, 0x59, 0, 0, 0}
    ,
    {0x91d6, 0x95, 0, 0, 0}
    ,
    {0x91d7, 0x6d, 0, 0, 0}
    ,
    {0x91d8, 0xe5, 0, 0, 0}
    ,
    {0x91d9, 0x58, 0, 0, 0}
    ,
    {0x91da, 0x95, 0, 0, 0}
    ,
    {0x91db, 0x6c, 0, 0, 0}
    ,
    {0x91dc, 0x40, 0, 0, 0}
    ,
    {0x91dd, 0x03, 0, 0, 0}
    ,
    {0x91de, 0xd3, 0, 0, 0}
    ,
    {0x91df, 0x80, 0, 0, 0}
    ,
    {0x91e0, 0x01, 0, 0, 0}
    ,
    {0x91e1, 0xc3, 0, 0, 0}
    ,
    {0x91e2, 0x92, 0, 0, 0}
    ,
    {0x91e3, 0x21, 0, 0, 0}
    ,
    {0x91e4, 0xd3, 0, 0, 0}
    ,
    {0x91e5, 0xe5, 0, 0, 0}
    ,
    {0x91e6, 0x5b, 0, 0, 0}
    ,
    {0x91e7, 0x95, 0, 0, 0}
    ,
    {0x91e8, 0x6f, 0, 0, 0}
    ,
    {0x91e9, 0xe5, 0, 0, 0}
    ,
    {0x91ea, 0x5a, 0, 0, 0}
    ,
    {0x91eb, 0x95, 0, 0, 0}
    ,
    {0x91ec, 0x6e, 0, 0, 0}
    ,
    {0x91ed, 0x40, 0, 0, 0}
    ,
    {0x91ee, 0x03, 0, 0, 0}
    ,
    {0x91ef, 0xd3, 0, 0, 0}
    ,
    {0x91f0, 0x80, 0, 0, 0}
    ,
    {0x91f1, 0x01, 0, 0, 0}
    ,
    {0x91f2, 0xc3, 0, 0, 0}
    ,
    {0x91f3, 0x92, 0, 0, 0}
    ,
    {0x91f4, 0x22, 0, 0, 0}
    ,
    {0x91f5, 0xd3, 0, 0, 0}
    ,
    {0x91f6, 0xe5, 0, 0, 0}
    ,
    {0x91f7, 0x5d, 0, 0, 0}
    ,
    {0x91f8, 0x95, 0, 0, 0}
    ,
    {0x91f9, 0x71, 0, 0, 0}
    ,
    {0x91fa, 0xe5, 0, 0, 0}
    ,
    {0x91fb, 0x5c, 0, 0, 0}
    ,
    {0x91fc, 0x95, 0, 0, 0}
    ,
    {0x91fd, 0x70, 0, 0, 0}
    ,
    {0x91fe, 0x40, 0, 0, 0}
    ,
    {0x91ff, 0x03, 0, 0, 0}
    ,
    {0x9200, 0xd3, 0, 0, 0}
    ,
    {0x9201, 0x80, 0, 0, 0}
    ,
    {0x9202, 0x01, 0, 0, 0}
    ,
    {0x9203, 0xc3, 0, 0, 0}
    ,
    {0x9204, 0x92, 0, 0, 0}
    ,
    {0x9205, 0x23, 0, 0, 0}
    ,
    {0x9206, 0xd3, 0, 0, 0}
    ,
    {0x9207, 0xe5, 0, 0, 0}
    ,
    {0x9208, 0x5f, 0, 0, 0}
    ,
    {0x9209, 0x95, 0, 0, 0}
    ,
    {0x920a, 0x73, 0, 0, 0}
    ,
    {0x920b, 0xe5, 0, 0, 0}
    ,
    {0x920c, 0x5e, 0, 0, 0}
    ,
    {0x920d, 0x95, 0, 0, 0}
    ,
    {0x920e, 0x72, 0, 0, 0}
    ,
    {0x920f, 0x40, 0, 0, 0}
    ,
    {0x9210, 0x03, 0, 0, 0}
    ,
    {0x9211, 0xd3, 0, 0, 0}
    ,
    {0x9212, 0x80, 0, 0, 0}
    ,
    {0x9213, 0x01, 0, 0, 0}
    ,
    {0x9214, 0xc3, 0, 0, 0}
    ,
    {0x9215, 0x92, 0, 0, 0}
    ,
    {0x9216, 0x24, 0, 0, 0}
    ,
    {0x9217, 0xd3, 0, 0, 0}
    ,
    {0x9218, 0xe5, 0, 0, 0}
    ,
    {0x9219, 0x61, 0, 0, 0}
    ,
    {0x921a, 0x95, 0, 0, 0}
    ,
    {0x921b, 0x75, 0, 0, 0}
    ,
    {0x921c, 0xe5, 0, 0, 0}
    ,
    {0x921d, 0x60, 0, 0, 0}
    ,
    {0x921e, 0x95, 0, 0, 0}
    ,
    {0x921f, 0x74, 0, 0, 0}
    ,
    {0x9220, 0x40, 0, 0, 0}
    ,
    {0x9221, 0x03, 0, 0, 0}
    ,
    {0x9222, 0xd3, 0, 0, 0}
    ,
    {0x9223, 0x80, 0, 0, 0}
    ,
    {0x9224, 0x01, 0, 0, 0}
    ,
    {0x9225, 0xc3, 0, 0, 0}
    ,
    {0x9226, 0x92, 0, 0, 0}
    ,
    {0x9227, 0x25, 0, 0, 0}
    ,
    {0x9228, 0xd3, 0, 0, 0}
    ,
    {0x9229, 0xe5, 0, 0, 0}
    ,
    {0x922a, 0x63, 0, 0, 0}
    ,
    {0x922b, 0x95, 0, 0, 0}
    ,
    {0x922c, 0x77, 0, 0, 0}
    ,
    {0x922d, 0xe5, 0, 0, 0}
    ,
    {0x922e, 0x62, 0, 0, 0}
    ,
    {0x922f, 0x95, 0, 0, 0}
    ,
    {0x9230, 0x76, 0, 0, 0}
    ,
    {0x9231, 0x40, 0, 0, 0}
    ,
    {0x9232, 0x03, 0, 0, 0}
    ,
    {0x9233, 0xd3, 0, 0, 0}
    ,
    {0x9234, 0x80, 0, 0, 0}
    ,
    {0x9235, 0x01, 0, 0, 0}
    ,
    {0x9236, 0xc3, 0, 0, 0}
    ,
    {0x9237, 0x92, 0, 0, 0}
    ,
    {0x9238, 0x26, 0, 0, 0}
    ,
    {0x9239, 0x22, 0, 0, 0}
    ,
    {0x923a, 0x56, 0, 0, 0}
    ,
    {0x923b, 0x0c, 0, 0, 0}
    ,
    {0x923c, 0x04, 0, 0, 0}
    ,
    {0x923d, 0x00, 0, 0, 0}
    ,
    {0x923e, 0x00, 0, 0, 0}
    ,
    {0x923f, 0x00, 0, 0, 0}
    ,
    {0x9240, 0xc8, 0, 0, 0}
    ,
    {0x9241, 0x01, 0, 0, 0}
    ,
    {0x9242, 0x2c, 0, 0, 0}
    ,
    {0x9243, 0x01, 0, 0, 0}
    ,
    {0x9244, 0x5e, 0, 0, 0}
    ,
    {0x9245, 0x01, 0, 0, 0}
    ,
    {0x9246, 0x8b, 0, 0, 0}
    ,
    {0x9247, 0x01, 0, 0, 0}
    ,
    {0x9248, 0xb8, 0, 0, 0}
    ,
    {0x9249, 0x01, 0, 0, 0}
    ,
    {0x924a, 0xe5, 0, 0, 0}
    ,
    {0x924b, 0x02, 0, 0, 0}
    ,
    {0x924c, 0x12, 0, 0, 0}
    ,
    {0x924d, 0x02, 0, 0, 0}
    ,
    {0x924e, 0x3f, 0, 0, 0}
    ,
    {0x924f, 0x02, 0, 0, 0}
    ,
    {0x9250, 0x6c, 0, 0, 0}
    ,
    {0x9251, 0x02, 0, 0, 0}
    ,
    {0x9252, 0x99, 0, 0, 0}
    ,
    {0x9253, 0x02, 0, 0, 0}
    ,
    {0x9254, 0xc6, 0, 0, 0}
    ,
    {0x9255, 0x02, 0, 0, 0}
    ,
    {0x9256, 0xf3, 0, 0, 0}
    ,
    {0x9257, 0x07, 0, 0, 0}
    ,
    {0x9258, 0x20, 0, 0, 0}
    ,
    {0x9259, 0x12, 0, 0, 0}
    ,
    {0x925a, 0x28, 0, 0, 0}
    ,
    {0x925b, 0x1e, 0, 0, 0}
    ,
    {0x925c, 0x18, 0, 0, 0}
    ,
    {0x925d, 0x18, 0, 0, 0}
    ,
    {0x925e, 0x28, 0, 0, 0}
    ,
    {0x925f, 0x1e, 0, 0, 0}
    ,
    {0x9260, 0x18, 0, 0, 0}
    ,
    {0x9261, 0x12, 0, 0, 0}
    ,
    {0x9262, 0x28, 0, 0, 0}
    ,
    {0x9263, 0x1e, 0, 0, 0}
    ,
    {0x9264, 0x18, 0, 0, 0}
    ,
    {0x9265, 0x12, 0, 0, 0}
    ,
    {0x9266, 0x28, 0, 0, 0}
    ,
    {0x9267, 0x18, 0, 0, 0}
    ,
    {0x9268, 0x18, 0, 0, 0}
    ,
    {0x9269, 0x12, 0, 0, 0}
    ,
    {0x926a, 0x20, 0, 0, 0}
    ,
    {0x926b, 0x18, 0, 0, 0}
    ,
    {0x926c, 0x28, 0, 0, 0}
    ,
    {0x926d, 0x1c, 0, 0, 0}
    ,
    {0x926e, 0x30, 0, 0, 0}
    ,
    {0x926f, 0x24, 0, 0, 0}
    ,
    {0x9270, 0x10, 0, 0, 0}
    ,
    {0x9271, 0x1c, 0, 0, 0}
    ,
    {0x9272, 0x18, 0, 0, 0}
    ,
    {0x9273, 0x24, 0, 0, 0}
    ,
    {0x9274, 0x1c, 0, 0, 0}
    ,
    {0x9275, 0x14, 0, 0, 0}
    ,
    {0x9276, 0x24, 0, 0, 0}
    ,
    {0x9277, 0x1c, 0, 0, 0}
    ,
    {0x9278, 0x28, 0, 0, 0}
    ,
    {0x9279, 0x0c, 0, 0, 0}
    ,
    {0x927a, 0x30, 0, 0, 0}
    ,
    {0x927b, 0x14, 0, 0, 0}
    ,
    {0x927c, 0x10, 0, 0, 0}
    ,
    {0x927d, 0x0c, 0, 0, 0}
    ,
    {0x927e, 0x18, 0, 0, 0}
    ,
    {0x927f, 0x14, 0, 0, 0}
    ,
    {0x9280, 0x1c, 0, 0, 0}
    ,
    {0x9281, 0x20, 0, 0, 0}
    ,
    {0x9282, 0x24, 0, 0, 0}
    ,
    {0x9283, 0x28, 0, 0, 0}
    ,
    {0x9284, 0x0c, 0, 0, 0}
    ,
    {0x9285, 0x14, 0, 0, 0}
    ,
    {0x9286, 0x14, 0, 0, 0}
    ,
    {0x9287, 0x1c, 0, 0, 0}
    ,
    {0x9288, 0x1c, 0, 0, 0}
    ,
    {0x9289, 0x14, 0, 0, 0}
    ,
    {0x928a, 0x24, 0, 0, 0}
    ,
    {0x928b, 0x1c, 0, 0, 0}
    ,
    {0x928c, 0x2c, 0, 0, 0}
    ,
    {0x928d, 0x14, 0, 0, 0}
    ,
    {0x928e, 0x34, 0, 0, 0}
    ,
    {0x928f, 0x1c, 0, 0, 0}
    ,
    {0x9290, 0x1c, 0, 0, 0}
    ,
    {0x9291, 0x08, 0, 0, 0}
    ,
    {0x9292, 0x24, 0, 0, 0}
    ,
    {0x9293, 0x10, 0, 0, 0}
    ,
    {0x9294, 0x19, 0, 0, 0}
    ,
    {0x9295, 0x19, 0, 0, 0}
    ,
    {0x9296, 0x1c, 0, 0, 0}
    ,
    {0x9297, 0x19, 0, 0, 0}
    ,
    {0x9298, 0x19, 0, 0, 0}
    ,
    {0x9299, 0x10, 0, 0, 0}
    ,
    {0x929a, 0x10, 0, 0, 0}
    ,
    {0x929b, 0x10, 0, 0, 0}
    ,
    {0x929c, 0x10, 0, 0, 0}
    ,
    {0x929d, 0x10, 0, 0, 0}
    ,
    {0x929e, 0x00, 0, 0, 0}
    ,
    {0x929f, 0x00, 0, 0, 0}
    ,
    {0x92a0, 0x00, 0, 0, 0}
    ,
    {0x92a1, 0x00, 0, 0, 0}
    ,
    {0x92a2, 0x00, 0, 0, 0}
    ,
    {0x92a3, 0xe5, 0, 0, 0}
    ,
    {0x92a4, 0x0a, 0, 0, 0}
    ,
    {0x92a5, 0x70, 0, 0, 0}
    ,
    {0x92a6, 0x04, 0, 0, 0}
    ,
    {0x92a7, 0x7a, 0, 0, 0}
    ,
    {0x92a8, 0x12, 0, 0, 0}
    ,
    {0x92a9, 0x7b, 0, 0, 0}
    ,
    {0x92aa, 0x58, 0, 0, 0}
    ,
    {0x92ab, 0xe5, 0, 0, 0}
    ,
    {0x92ac, 0x0a, 0, 0, 0}
    ,
    {0x92ad, 0xb4, 0, 0, 0}
    ,
    {0x92ae, 0x01, 0, 0, 0}
    ,
    {0x92af, 0x04, 0, 0, 0}
    ,
    {0x92b0, 0x7a, 0, 0, 0}
    ,
    {0x92b1, 0x12, 0, 0, 0}
    ,
    {0x92b2, 0x7b, 0, 0, 0}
    ,
    {0x92b3, 0x6c, 0, 0, 0}
    ,
    {0x92b4, 0xe5, 0, 0, 0}
    ,
    {0x92b5, 0x0a, 0, 0, 0}
    ,
    {0x92b6, 0xb4, 0, 0, 0}
    ,
    {0x92b7, 0x02, 0, 0, 0}
    ,
    {0x92b8, 0x04, 0, 0, 0}
    ,
    {0x92b9, 0x7a, 0, 0, 0}
    ,
    {0x92ba, 0x12, 0, 0, 0}
    ,
    {0x92bb, 0x7b, 0, 0, 0}
    ,
    {0x92bc, 0x80, 0, 0, 0}
    ,
    {0x92bd, 0x8b, 0, 0, 0}
    ,
    {0x92be, 0x82, 0, 0, 0}
    ,
    {0x92bf, 0x8a, 0, 0, 0}
    ,
    {0x92c0, 0x83, 0, 0, 0}
    ,
    {0x92c1, 0x12, 0, 0, 0}
    ,
    {0x92c2, 0x09, 0, 0, 0}
    ,
    {0x92c3, 0xf1, 0, 0, 0}
    ,
    {0x92c4, 0x8f, 0, 0, 0}
    ,
    {0x92c5, 0x37, 0, 0, 0}
    ,
    {0x92c6, 0x8e, 0, 0, 0}
    ,
    {0x92c7, 0x36, 0, 0, 0}
    ,
    {0x92c8, 0x8d, 0, 0, 0}
    ,
    {0x92c9, 0x35, 0, 0, 0}
    ,
    {0x92ca, 0x8c, 0, 0, 0}
    ,
    {0x92cb, 0x34, 0, 0, 0}
    ,
    {0x92cc, 0xe5, 0, 0, 0}
    ,
    {0x92cd, 0x82, 0, 0, 0}
    ,
    {0x92ce, 0x24, 0, 0, 0}
    ,
    {0x92cf, 0x04, 0, 0, 0}
    ,
    {0x92d0, 0xf5, 0, 0, 0}
    ,
    {0x92d1, 0x82, 0, 0, 0}
    ,
    {0x92d2, 0xe4, 0, 0, 0}
    ,
    {0x92d3, 0x35, 0, 0, 0}
    ,
    {0x92d4, 0x83, 0, 0, 0}
    ,
    {0x92d5, 0xf5, 0, 0, 0}
    ,
    {0x92d6, 0x83, 0, 0, 0}
    ,
    {0x92d7, 0x12, 0, 0, 0}
    ,
    {0x92d8, 0x09, 0, 0, 0}
    ,
    {0x92d9, 0xf1, 0, 0, 0}
    ,
    {0x92da, 0x8f, 0, 0, 0}
    ,
    {0x92db, 0x3b, 0, 0, 0}
    ,
    {0x92dc, 0x8e, 0, 0, 0}
    ,
    {0x92dd, 0x3a, 0, 0, 0}
    ,
    {0x92de, 0x8d, 0, 0, 0}
    ,
    {0x92df, 0x39, 0, 0, 0}
    ,
    {0x92e0, 0x8c, 0, 0, 0}
    ,
    {0x92e1, 0x38, 0, 0, 0}
    ,
    {0x92e2, 0xeb, 0, 0, 0}
    ,
    {0x92e3, 0x24, 0, 0, 0}
    ,
    {0x92e4, 0x08, 0, 0, 0}
    ,
    {0x92e5, 0x12, 0, 0, 0}
    ,
    {0x92e6, 0x02, 0, 0, 0}
    ,
    {0x92e7, 0x4c, 0, 0, 0}
    ,
    {0x92e8, 0x12, 0, 0, 0}
    ,
    {0x92e9, 0x01, 0, 0, 0}
    ,
    {0x92ea, 0xbe, 0, 0, 0}
    ,
    {0x92eb, 0xeb, 0, 0, 0}
    ,
    {0x92ec, 0x24, 0, 0, 0}
    ,
    {0x92ed, 0x0c, 0, 0, 0}
    ,
    {0x92ee, 0x12, 0, 0, 0}
    ,
    {0x92ef, 0x02, 0, 0, 0}
    ,
    {0x92f0, 0x4c, 0, 0, 0}
    ,
    {0x92f1, 0x8f, 0, 0, 0}
    ,
    {0x92f2, 0x43, 0, 0, 0}
    ,
    {0x92f3, 0x8e, 0, 0, 0}
    ,
    {0x92f4, 0x42, 0, 0, 0}
    ,
    {0x92f5, 0x8d, 0, 0, 0}
    ,
    {0x92f6, 0x41, 0, 0, 0}
    ,
    {0x92f7, 0x8c, 0, 0, 0}
    ,
    {0x92f8, 0x40, 0, 0, 0}
    ,
    {0x92f9, 0xeb, 0, 0, 0}
    ,
    {0x92fa, 0x24, 0, 0, 0}
    ,
    {0x92fb, 0x10, 0, 0, 0}
    ,
    {0x92fc, 0x12, 0, 0, 0}
    ,
    {0x92fd, 0x02, 0, 0, 0}
    ,
    {0x92fe, 0x4c, 0, 0, 0}
    ,
    {0x92ff, 0x8f, 0, 0, 0}
    ,
    {0x9300, 0x47, 0, 0, 0}
    ,
    {0x9301, 0x8e, 0, 0, 0}
    ,
    {0x9302, 0x46, 0, 0, 0}
    ,
    {0x9303, 0x8d, 0, 0, 0}
    ,
    {0x9304, 0x45, 0, 0, 0}
    ,
    {0x9305, 0x8c, 0, 0, 0}
    ,
    {0x9306, 0x44, 0, 0, 0}
    ,
    {0x9307, 0x22, 0, 0, 0}
    ,
    {0x9308, 0x30, 0, 0, 0}
    ,
    {0x9309, 0x3f, 0, 0, 0}
    ,
    {0x930a, 0x07, 0, 0, 0}
    ,
    {0x930b, 0x30, 0, 0, 0}
    ,
    {0x930c, 0x20, 0, 0, 0}
    ,
    {0x930d, 0x04, 0, 0, 0}
    ,
    {0x930e, 0xaf, 0, 0, 0}
    ,
    {0x930f, 0x4a, 0, 0, 0}
    ,
    {0x9310, 0x80, 0, 0, 0}
    ,
    {0x9311, 0x02, 0, 0, 0}
    ,
    {0x9312, 0xaf, 0, 0, 0}
    ,
    {0x9313, 0x7d, 0, 0, 0}
    ,
    {0x9314, 0x8f, 0, 0, 0}
    ,
    {0x9315, 0x4a, 0, 0, 0}
    ,
    {0x9316, 0x30, 0, 0, 0}
    ,
    {0x9317, 0x3f, 0, 0, 0}
    ,
    {0x9318, 0x07, 0, 0, 0}
    ,
    {0x9319, 0x30, 0, 0, 0}
    ,
    {0x931a, 0x21, 0, 0, 0}
    ,
    {0x931b, 0x04, 0, 0, 0}
    ,
    {0x931c, 0xaf, 0, 0, 0}
    ,
    {0x931d, 0x4b, 0, 0, 0}
    ,
    {0x931e, 0x80, 0, 0, 0}
    ,
    {0x931f, 0x02, 0, 0, 0}
    ,
    {0x9320, 0xaf, 0, 0, 0}
    ,
    {0x9321, 0x7d, 0, 0, 0}
    ,
    {0x9322, 0x8f, 0, 0, 0}
    ,
    {0x9323, 0x4b, 0, 0, 0}
    ,
    {0x9324, 0x30, 0, 0, 0}
    ,
    {0x9325, 0x3f, 0, 0, 0}
    ,
    {0x9326, 0x07, 0, 0, 0}
    ,
    {0x9327, 0x30, 0, 0, 0}
    ,
    {0x9328, 0x22, 0, 0, 0}
    ,
    {0x9329, 0x04, 0, 0, 0}
    ,
    {0x932a, 0xaf, 0, 0, 0}
    ,
    {0x932b, 0x4c, 0, 0, 0}
    ,
    {0x932c, 0x80, 0, 0, 0}
    ,
    {0x932d, 0x02, 0, 0, 0}
    ,
    {0x932e, 0xaf, 0, 0, 0}
    ,
    {0x932f, 0x7d, 0, 0, 0}
    ,
    {0x9330, 0x8f, 0, 0, 0}
    ,
    {0x9331, 0x4c, 0, 0, 0}
    ,
    {0x9332, 0x30, 0, 0, 0}
    ,
    {0x9333, 0x3f, 0, 0, 0}
    ,
    {0x9334, 0x07, 0, 0, 0}
    ,
    {0x9335, 0x30, 0, 0, 0}
    ,
    {0x9336, 0x23, 0, 0, 0}
    ,
    {0x9337, 0x04, 0, 0, 0}
    ,
    {0x9338, 0xaf, 0, 0, 0}
    ,
    {0x9339, 0x4d, 0, 0, 0}
    ,
    {0x933a, 0x80, 0, 0, 0}
    ,
    {0x933b, 0x02, 0, 0, 0}
    ,
    {0x933c, 0xaf, 0, 0, 0}
    ,
    {0x933d, 0x7d, 0, 0, 0}
    ,
    {0x933e, 0x8f, 0, 0, 0}
    ,
    {0x933f, 0x4d, 0, 0, 0}
    ,
    {0x9340, 0x30, 0, 0, 0}
    ,
    {0x9341, 0x3f, 0, 0, 0}
    ,
    {0x9342, 0x07, 0, 0, 0}
    ,
    {0x9343, 0x30, 0, 0, 0}
    ,
    {0x9344, 0x24, 0, 0, 0}
    ,
    {0x9345, 0x04, 0, 0, 0}
    ,
    {0x9346, 0xaf, 0, 0, 0}
    ,
    {0x9347, 0x4e, 0, 0, 0}
    ,
    {0x9348, 0x80, 0, 0, 0}
    ,
    {0x9349, 0x02, 0, 0, 0}
    ,
    {0x934a, 0xaf, 0, 0, 0}
    ,
    {0x934b, 0x7d, 0, 0, 0}
    ,
    {0x934c, 0x8f, 0, 0, 0}
    ,
    {0x934d, 0x4e, 0, 0, 0}
    ,
    {0x934e, 0x30, 0, 0, 0}
    ,
    {0x934f, 0x3f, 0, 0, 0}
    ,
    {0x9350, 0x07, 0, 0, 0}
    ,
    {0x9351, 0x30, 0, 0, 0}
    ,
    {0x9352, 0x25, 0, 0, 0}
    ,
    {0x9353, 0x04, 0, 0, 0}
    ,
    {0x9354, 0xaf, 0, 0, 0}
    ,
    {0x9355, 0x4f, 0, 0, 0}
    ,
    {0x9356, 0x80, 0, 0, 0}
    ,
    {0x9357, 0x02, 0, 0, 0}
    ,
    {0x9358, 0xaf, 0, 0, 0}
    ,
    {0x9359, 0x7d, 0, 0, 0}
    ,
    {0x935a, 0x8f, 0, 0, 0}
    ,
    {0x935b, 0x4f, 0, 0, 0}
    ,
    {0x935c, 0x30, 0, 0, 0}
    ,
    {0x935d, 0x3f, 0, 0, 0}
    ,
    {0x935e, 0x07, 0, 0, 0}
    ,
    {0x935f, 0x30, 0, 0, 0}
    ,
    {0x9360, 0x26, 0, 0, 0}
    ,
    {0x9361, 0x04, 0, 0, 0}
    ,
    {0x9362, 0xaf, 0, 0, 0}
    ,
    {0x9363, 0x50, 0, 0, 0}
    ,
    {0x9364, 0x80, 0, 0, 0}
    ,
    {0x9365, 0x02, 0, 0, 0}
    ,
    {0x9366, 0xaf, 0, 0, 0}
    ,
    {0x9367, 0x7d, 0, 0, 0}
    ,
    {0x9368, 0x8f, 0, 0, 0}
    ,
    {0x9369, 0x50, 0, 0, 0}
    ,
    {0x936a, 0x22, 0, 0, 0}
    ,
    {0x936b, 0xe5, 0, 0, 0}
    ,
    {0x936c, 0x0c, 0, 0, 0}
    ,
    {0x936d, 0xd3, 0, 0, 0}
    ,
    {0x936e, 0x95, 0, 0, 0}
    ,
    {0x936f, 0x7c, 0, 0, 0}
    ,
    {0x9370, 0x40, 0, 0, 0}
    ,
    {0x9371, 0x01, 0, 0, 0}
    ,
    {0x9372, 0x22, 0, 0, 0}
    ,
    {0x9373, 0x12, 0, 0, 0}
    ,
    {0x9374, 0x02, 0, 0, 0}
    ,
    {0x9375, 0x45, 0, 0, 0}
    ,
    {0x9376, 0xe5, 0, 0, 0}
    ,
    {0x9377, 0x0c, 0, 0, 0}
    ,
    {0x9378, 0x12, 0, 0, 0}
    ,
    {0x9379, 0x02, 0, 0, 0}
    ,
    {0x937a, 0x2d, 0, 0, 0}
    ,
    {0x937b, 0x4e, 0, 0, 0}
    ,
    {0x937c, 0x60, 0, 0, 0}
    ,
    {0x937d, 0x21, 0, 0, 0}
    ,
    {0x937e, 0x8e, 0, 0, 0}
    ,
    {0x937f, 0x64, 0, 0, 0}
    ,
    {0x9380, 0x8f, 0, 0, 0}
    ,
    {0x9381, 0x65, 0, 0, 0}
    ,
    {0x9382, 0xef, 0, 0, 0}
    ,
    {0x9383, 0xc4, 0, 0, 0}
    ,
    {0x9384, 0xf8, 0, 0, 0}
    ,
    {0x9385, 0x54, 0, 0, 0}
    ,
    {0x9386, 0x0f, 0, 0, 0}
    ,
    {0x9387, 0xc8, 0, 0, 0}
    ,
    {0x9388, 0x68, 0, 0, 0}
    ,
    {0x9389, 0xff, 0, 0, 0}
    ,
    {0x938a, 0xee, 0, 0, 0}
    ,
    {0x938b, 0xc4, 0, 0, 0}
    ,
    {0x938c, 0x54, 0, 0, 0}
    ,
    {0x938d, 0xf0, 0, 0, 0}
    ,
    {0x938e, 0x48, 0, 0, 0}
    ,
    {0x938f, 0xfe, 0, 0, 0}
    ,
    {0x9390, 0x43, 0, 0, 0}
    ,
    {0x9391, 0x07, 0, 0, 0}
    ,
    {0x9392, 0x0d, 0, 0, 0}
    ,
    {0x9393, 0x8e, 0, 0, 0}
    ,
    {0x9394, 0x0d, 0, 0, 0}
    ,
    {0x9395, 0x8f, 0, 0, 0}
    ,
    {0x9396, 0x0e, 0, 0, 0}
    ,
    {0x9397, 0x12, 0, 0, 0}
    ,
    {0x9398, 0x0a, 0, 0, 0}
    ,
    {0x9399, 0x33, 0, 0, 0}
    ,
    {0x939a, 0x30, 0, 0, 0}
    ,
    {0x939b, 0x33, 0, 0, 0}
    ,
    {0x939c, 0x22, 0, 0, 0}
    ,
    {0x939d, 0xc3, 0, 0, 0}
    ,
    {0x939e, 0x22, 0, 0, 0}
    ,
    {0x939f, 0x75, 0, 0, 0}
    ,
    {0x93a0, 0x0d, 0, 0, 0}
    ,
    {0x93a1, 0x00, 0, 0, 0}
    ,
    {0x93a2, 0x75, 0, 0, 0}
    ,
    {0x93a3, 0x0e, 0, 0, 0}
    ,
    {0x93a4, 0x0d, 0, 0, 0}
    ,
    {0x93a5, 0x12, 0, 0, 0}
    ,
    {0x93a6, 0x0a, 0, 0, 0}
    ,
    {0x93a7, 0x33, 0, 0, 0}
    ,
    {0x93a8, 0x30, 0, 0, 0}
    ,
    {0x93a9, 0x33, 0, 0, 0}
    ,
    {0x93aa, 0x02, 0, 0, 0}
    ,
    {0x93ab, 0xc3, 0, 0, 0}
    ,
    {0x93ac, 0x22, 0, 0, 0}
    ,
    {0x93ad, 0x75, 0, 0, 0}
    ,
    {0x93ae, 0x0d, 0, 0, 0}
    ,
    {0x93af, 0x00, 0, 0, 0}
    ,
    {0x93b0, 0x75, 0, 0, 0}
    ,
    {0x93b1, 0x0e, 0, 0, 0}
    ,
    {0x93b2, 0x64, 0, 0, 0}
    ,
    {0x93b3, 0x12, 0, 0, 0}
    ,
    {0x93b4, 0x16, 0, 0, 0}
    ,
    {0x93b5, 0x0e, 0, 0, 0}
    ,
    {0x93b6, 0x75, 0, 0, 0}
    ,
    {0x93b7, 0x0d, 0, 0, 0}
    ,
    {0x93b8, 0x80, 0, 0, 0}
    ,
    {0x93b9, 0x75, 0, 0, 0}
    ,
    {0x93ba, 0x0e, 0, 0, 0}
    ,
    {0x93bb, 0x00, 0, 0, 0}
    ,
    {0x93bc, 0x12, 0, 0, 0}
    ,
    {0x93bd, 0x0a, 0, 0, 0}
    ,
    {0x93be, 0x33, 0, 0, 0}
    ,
    {0x93bf, 0x85, 0, 0, 0}
    ,
    {0x93c0, 0x0c, 0, 0, 0}
    ,
    {0x93c1, 0x7d, 0, 0, 0}
    ,
    {0x93c2, 0xd3, 0, 0, 0}
    ,
    {0x93c3, 0x22, 0, 0, 0}
    ,
    {0x93c4, 0xc2, 0, 0, 0}
    ,
    {0x93c5, 0xaf, 0, 0, 0}
    ,
    {0x93c6, 0x90, 0, 0, 0}
    ,
    {0x93c7, 0x30, 0, 0, 0}
    ,
    {0x93c8, 0x27, 0, 0, 0}
    ,
    {0x93c9, 0x74, 0, 0, 0}
    ,
    {0x93ca, 0xfa, 0, 0, 0}
    ,
    {0x93cb, 0xf0, 0, 0, 0}
    ,
    {0x93cc, 0x12, 0, 0, 0}
    ,
    {0x93cd, 0x0f, 0, 0, 0}
    ,
    {0x93ce, 0xfb, 0, 0, 0}
    ,
    {0x93cf, 0x12, 0, 0, 0}
    ,
    {0x93d0, 0x15, 0, 0, 0}
    ,
    {0x93d1, 0xc5, 0, 0, 0}
    ,
    {0x93d2, 0xe4, 0, 0, 0}
    ,
    {0x93d3, 0xf5, 0, 0, 0}
    ,
    {0x93d4, 0x33, 0, 0, 0}
    ,
    {0x93d5, 0xd2, 0, 0, 0}
    ,
    {0x93d6, 0xaf, 0, 0, 0}
    ,
    {0x93d7, 0x12, 0, 0, 0}
    ,
    {0x93d8, 0x0e, 0, 0, 0}
    ,
    {0x93d9, 0xfd, 0, 0, 0}
    ,
    {0x93da, 0x30, 0, 0, 0}
    ,
    {0x93db, 0x30, 0, 0, 0}
    ,
    {0x93dc, 0x03, 0, 0, 0}
    ,
    {0x93dd, 0x12, 0, 0, 0}
    ,
    {0x93de, 0x07, 0, 0, 0}
    ,
    {0x93df, 0x0c, 0, 0, 0}
    ,
    {0x93e0, 0x30, 0, 0, 0}
    ,
    {0x93e1, 0x3a, 0, 0, 0}
    ,
    {0x93e2, 0x17, 0, 0, 0}
    ,
    {0x93e3, 0x30, 0, 0, 0}
    ,
    {0x93e4, 0x39, 0, 0, 0}
    ,
    {0x93e5, 0x07, 0, 0, 0}
    ,
    {0x93e6, 0x20, 0, 0, 0}
    ,
    {0x93e7, 0x37, 0, 0, 0}
    ,
    {0x93e8, 0xfd, 0, 0, 0}
    ,
    {0x93e9, 0xc2, 0, 0, 0}
    ,
    {0x93ea, 0x39, 0, 0, 0}
    ,
    {0x93eb, 0xd2, 0, 0, 0}
    ,
    {0x93ec, 0x37, 0, 0, 0}
    ,
    {0x93ed, 0x12, 0, 0, 0}
    ,
    {0x93ee, 0x0c, 0, 0, 0}
    ,
    {0x93ef, 0xb8, 0, 0, 0}
    ,
    {0x93f0, 0x30, 0, 0, 0}
    ,
    {0x93f1, 0x39, 0, 0, 0}
    ,
    {0x93f2, 0x07, 0, 0, 0}
    ,
    {0x93f3, 0x20, 0, 0, 0}
    ,
    {0x93f4, 0x37, 0, 0, 0}
    ,
    {0x93f5, 0xfd, 0, 0, 0}
    ,
    {0x93f6, 0xd2, 0, 0, 0}
    ,
    {0x93f7, 0x39, 0, 0, 0}
    ,
    {0x93f8, 0xd2, 0, 0, 0}
    ,
    {0x93f9, 0x37, 0, 0, 0}
    ,
    {0x93fa, 0x30, 0, 0, 0}
    ,
    {0x93fb, 0x34, 0, 0, 0}
    ,
    {0x93fc, 0x03, 0, 0, 0}
    ,
    {0x93fd, 0x12, 0, 0, 0}
    ,
    {0x93fe, 0x10, 0, 0, 0}
    ,
    {0x93ff, 0x9b, 0, 0, 0}
    ,
    {0x9400, 0x30, 0, 0, 0}
    ,
    {0x9401, 0x3e, 0, 0, 0}
    ,
    {0x9402, 0xd4, 0, 0, 0}
    ,
    {0x9403, 0xc2, 0, 0, 0}
    ,
    {0x9404, 0x3e, 0, 0, 0}
    ,
    {0x9405, 0xd2, 0, 0, 0}
    ,
    {0x9406, 0x35, 0, 0, 0}
    ,
    {0x9407, 0x30, 0, 0, 0}
    ,
    {0x9408, 0x00, 0, 0, 0}
    ,
    {0x9409, 0x05, 0, 0, 0}
    ,
    {0x940a, 0x12, 0, 0, 0}
    ,
    {0x940b, 0x15, 0, 0, 0}
    ,
    {0x940c, 0x98, 0, 0, 0}
    ,
    {0x940d, 0x80, 0, 0, 0}
    ,
    {0x940e, 0x09, 0, 0, 0}
    ,
    {0x940f, 0x20, 0, 0, 0}
    ,
    {0x9410, 0x07, 0, 0, 0}
    ,
    {0x9411, 0x06, 0, 0, 0}
    ,
    {0x9412, 0x30, 0, 0, 0}
    ,
    {0x9413, 0x06, 0, 0, 0}
    ,
    {0x9414, 0x03, 0, 0, 0}
    ,
    {0x9415, 0x12, 0, 0, 0}
    ,
    {0x9416, 0x0d, 0, 0, 0}
    ,
    {0x9417, 0xe6, 0, 0, 0}
    ,
    {0x9418, 0xc2, 0, 0, 0}
    ,
    {0x9419, 0x35, 0, 0, 0}
    ,
    {0x941a, 0x80, 0, 0, 0}
    ,
    {0x941b, 0xbb, 0, 0, 0}
    ,
    {0x941c, 0xe5, 0, 0, 0}
    ,
    {0x941d, 0x0a, 0, 0, 0}
    ,
    {0x941e, 0x70, 0, 0, 0}
    ,
    {0x941f, 0x04, 0, 0, 0}
    ,
    {0x9420, 0x7e, 0, 0, 0}
    ,
    {0x9421, 0x12, 0, 0, 0}
    ,
    {0x9422, 0x7f, 0, 0, 0}
    ,
    {0x9423, 0x94, 0, 0, 0}
    ,
    {0x9424, 0xe5, 0, 0, 0}
    ,
    {0x9425, 0x0a, 0, 0, 0}
    ,
    {0x9426, 0xb4, 0, 0, 0}
    ,
    {0x9427, 0x01, 0, 0, 0}
    ,
    {0x9428, 0x04, 0, 0, 0}
    ,
    {0x9429, 0x7e, 0, 0, 0}
    ,
    {0x942a, 0x12, 0, 0, 0}
    ,
    {0x942b, 0x7f, 0, 0, 0}
    ,
    {0x942c, 0x99, 0, 0, 0}
    ,
    {0x942d, 0xe5, 0, 0, 0}
    ,
    {0x942e, 0x0a, 0, 0, 0}
    ,
    {0x942f, 0xb4, 0, 0, 0}
    ,
    {0x9430, 0x02, 0, 0, 0}
    ,
    {0x9431, 0x04, 0, 0, 0}
    ,
    {0x9432, 0x7e, 0, 0, 0}
    ,
    {0x9433, 0x12, 0, 0, 0}
    ,
    {0x9434, 0x7f, 0, 0, 0}
    ,
    {0x9435, 0x9e, 0, 0, 0}
    ,
    {0x9436, 0x8f, 0, 0, 0}
    ,
    {0x9437, 0x82, 0, 0, 0}
    ,
    {0x9438, 0x8e, 0, 0, 0}
    ,
    {0x9439, 0x83, 0, 0, 0}
    ,
    {0x943a, 0xe4, 0, 0, 0}
    ,
    {0x943b, 0x93, 0, 0, 0}
    ,
    {0x943c, 0xf5, 0, 0, 0}
    ,
    {0x943d, 0x2c, 0, 0, 0}
    ,
    {0x943e, 0x74, 0, 0, 0}
    ,
    {0x943f, 0x01, 0, 0, 0}
    ,
    {0x9440, 0x93, 0, 0, 0}
    ,
    {0x9441, 0xf5, 0, 0, 0}
    ,
    {0x9442, 0x2d, 0, 0, 0}
    ,
    {0x9443, 0x74, 0, 0, 0}
    ,
    {0x9444, 0x02, 0, 0, 0}
    ,
    {0x9445, 0x93, 0, 0, 0}
    ,
    {0x9446, 0xf5, 0, 0, 0}
    ,
    {0x9447, 0x2e, 0, 0, 0}
    ,
    {0x9448, 0x74, 0, 0, 0}
    ,
    {0x9449, 0x03, 0, 0, 0}
    ,
    {0x944a, 0x93, 0, 0, 0}
    ,
    {0x944b, 0xf5, 0, 0, 0}
    ,
    {0x944c, 0x2f, 0, 0, 0}
    ,
    {0x944d, 0x74, 0, 0, 0}
    ,
    {0x944e, 0x04, 0, 0, 0}
    ,
    {0x944f, 0x93, 0, 0, 0}
    ,
    {0x9450, 0xf5, 0, 0, 0}
    ,
    {0x9451, 0x30, 0, 0, 0}
    ,
    {0x9452, 0xe5, 0, 0, 0}
    ,
    {0x9453, 0x0a, 0, 0, 0}
    ,
    {0x9454, 0xb4, 0, 0, 0}
    ,
    {0x9455, 0x01, 0, 0, 0}
    ,
    {0x9456, 0x07, 0, 0, 0}
    ,
    {0x9457, 0x74, 0, 0, 0}
    ,
    {0x9458, 0x2c, 0, 0, 0}
    ,
    {0x9459, 0x25, 0, 0, 0}
    ,
    {0x945a, 0x79, 0, 0, 0}
    ,
    {0x945b, 0xf8, 0, 0, 0}
    ,
    {0x945c, 0x76, 0, 0, 0}
    ,
    {0x945d, 0x40, 0, 0, 0}
    ,
    {0x945e, 0xe5, 0, 0, 0}
    ,
    {0x945f, 0x0a, 0, 0, 0}
    ,
    {0x9460, 0xb4, 0, 0, 0}
    ,
    {0x9461, 0x02, 0, 0, 0}
    ,
    {0x9462, 0x07, 0, 0, 0}
    ,
    {0x9463, 0x74, 0, 0, 0}
    ,
    {0x9464, 0x2c, 0, 0, 0}
    ,
    {0x9465, 0x25, 0, 0, 0}
    ,
    {0x9466, 0x79, 0, 0, 0}
    ,
    {0x9467, 0xf8, 0, 0, 0}
    ,
    {0x9468, 0x76, 0, 0, 0}
    ,
    {0x9469, 0x80, 0, 0, 0}
    ,
    {0x946a, 0x22, 0, 0, 0}
    ,
    {0x946b, 0xc0, 0, 0, 0}
    ,
    {0x946c, 0xe0, 0, 0, 0}
    ,
    {0x946d, 0xc0, 0, 0, 0}
    ,
    {0x946e, 0x83, 0, 0, 0}
    ,
    {0x946f, 0xc0, 0, 0, 0}
    ,
    {0x9470, 0x82, 0, 0, 0}
    ,
    {0x9471, 0xc0, 0, 0, 0}
    ,
    {0x9472, 0xd0, 0, 0, 0}
    ,
    {0x9473, 0x90, 0, 0, 0}
    ,
    {0x9474, 0x3f, 0, 0, 0}
    ,
    {0x9475, 0x0d, 0, 0, 0}
    ,
    {0x9476, 0xe0, 0, 0, 0}
    ,
    {0x9477, 0xf5, 0, 0, 0}
    ,
    {0x9478, 0x09, 0, 0, 0}
    ,
    {0x9479, 0xe5, 0, 0, 0}
    ,
    {0x947a, 0x09, 0, 0, 0}
    ,
    {0x947b, 0x30, 0, 0, 0}
    ,
    {0x947c, 0xe0, 0, 0, 0}
    ,
    {0x947d, 0x2e, 0, 0, 0}
    ,
    {0x947e, 0xe5, 0, 0, 0}
    ,
    {0x947f, 0x7a, 0, 0, 0}
    ,
    {0x9480, 0xb4, 0, 0, 0}
    ,
    {0x9481, 0x01, 0, 0, 0}
    ,
    {0x9482, 0x09, 0, 0, 0}
    ,
    {0x9483, 0x90, 0, 0, 0}
    ,
    {0x9484, 0x3a, 0, 0, 0}
    ,
    {0x9485, 0x00, 0, 0, 0}
    ,
    {0x9486, 0xe0, 0, 0, 0}
    ,
    {0x9487, 0xf5, 0, 0, 0}
    ,
    {0x9488, 0x78, 0, 0, 0}
    ,
    {0x9489, 0x44, 0, 0, 0}
    ,
    {0x948a, 0x01, 0, 0, 0}
    ,
    {0x948b, 0xf0, 0, 0, 0}
    ,
    {0x948c, 0xe5, 0, 0, 0}
    ,
    {0x948d, 0x7a, 0, 0, 0}
    ,
    {0x948e, 0xb4, 0, 0, 0}
    ,
    {0x948f, 0x03, 0, 0, 0}
    ,
    {0x9490, 0x09, 0, 0, 0}
    ,
    {0x9491, 0x90, 0, 0, 0}
    ,
    {0x9492, 0x3a, 0, 0, 0}
    ,
    {0x9493, 0x00, 0, 0, 0}
    ,
    {0x9494, 0xe0, 0, 0, 0}
    ,
    {0x9495, 0xf5, 0, 0, 0}
    ,
    {0x9496, 0x78, 0, 0, 0}
    ,
    {0x9497, 0x54, 0, 0, 0}
    ,
    {0x9498, 0xfe, 0, 0, 0}
    ,
    {0x9499, 0xf0, 0, 0, 0}
    ,
    {0x949a, 0xe5, 0, 0, 0}
    ,
    {0x949b, 0x7a, 0, 0, 0}
    ,
    {0x949c, 0xb4, 0, 0, 0}
    ,
    {0x949d, 0x03, 0, 0, 0}
    ,
    {0x949e, 0x05, 0, 0, 0}
    ,
    {0x949f, 0x75, 0, 0, 0}
    ,
    {0x94a0, 0x7a, 0, 0, 0}
    ,
    {0x94a1, 0x00, 0, 0, 0}
    ,
    {0x94a2, 0x80, 0, 0, 0}
    ,
    {0x94a3, 0x02, 0, 0, 0}
    ,
    {0x94a4, 0x05, 0, 0, 0}
    ,
    {0x94a5, 0x7a, 0, 0, 0}
    ,
    {0x94a6, 0x90, 0, 0, 0}
    ,
    {0x94a7, 0x3f, 0, 0, 0}
    ,
    {0x94a8, 0x0d, 0, 0, 0}
    ,
    {0x94a9, 0x74, 0, 0, 0}
    ,
    {0x94aa, 0x01, 0, 0, 0}
    ,
    {0x94ab, 0xf0, 0, 0, 0}
    ,
    {0x94ac, 0xd0, 0, 0, 0}
    ,
    {0x94ad, 0xd0, 0, 0, 0}
    ,
    {0x94ae, 0xd0, 0, 0, 0}
    ,
    {0x94af, 0x82, 0, 0, 0}
    ,
    {0x94b0, 0xd0, 0, 0, 0}
    ,
    {0x94b1, 0x83, 0, 0, 0}
    ,
    {0x94b2, 0xd0, 0, 0, 0}
    ,
    {0x94b3, 0xe0, 0, 0, 0}
    ,
    {0x94b4, 0x32, 0, 0, 0}
    ,
    {0x94b5, 0x85, 0, 0, 0}
    ,
    {0x94b6, 0x10, 0, 0, 0}
    ,
    {0x94b7, 0x11, 0, 0, 0}
    ,
    {0x94b8, 0x7f, 0, 0, 0}
    ,
    {0x94b9, 0x08, 0, 0, 0}
    ,
    {0x94ba, 0xe5, 0, 0, 0}
    ,
    {0x94bb, 0x11, 0, 0, 0}
    ,
    {0x94bc, 0x30, 0, 0, 0}
    ,
    {0x94bd, 0xe7, 0, 0, 0}
    ,
    {0x94be, 0x04, 0, 0, 0}
    ,
    {0x94bf, 0xd2, 0, 0, 0}
    ,
    {0x94c0, 0x29, 0, 0, 0}
    ,
    {0x94c1, 0x80, 0, 0, 0}
    ,
    {0x94c2, 0x02, 0, 0, 0}
    ,
    {0x94c3, 0xc2, 0, 0, 0}
    ,
    {0x94c4, 0x29, 0, 0, 0}
    ,
    {0x94c5, 0x12, 0, 0, 0}
    ,
    {0x94c6, 0x01, 0, 0, 0}
    ,
    {0x94c7, 0x93, 0, 0, 0}
    ,
    {0x94c8, 0x75, 0, 0, 0}
    ,
    {0x94c9, 0x51, 0, 0, 0}
    ,
    {0x94ca, 0x0a, 0, 0, 0}
    ,
    {0x94cb, 0xae, 0, 0, 0}
    ,
    {0x94cc, 0x51, 0, 0, 0}
    ,
    {0x94cd, 0x15, 0, 0, 0}
    ,
    {0x94ce, 0x51, 0, 0, 0}
    ,
    {0x94cf, 0xee, 0, 0, 0}
    ,
    {0x94d0, 0x70, 0, 0, 0}
    ,
    {0x94d1, 0xf9, 0, 0, 0}
    ,
    {0x94d2, 0xe5, 0, 0, 0}
    ,
    {0x94d3, 0x11, 0, 0, 0}
    ,
    {0x94d4, 0x25, 0, 0, 0}
    ,
    {0x94d5, 0xe0, 0, 0, 0}
    ,
    {0x94d6, 0xf5, 0, 0, 0}
    ,
    {0x94d7, 0x11, 0, 0, 0}
    ,
    {0x94d8, 0xd2, 0, 0, 0}
    ,
    {0x94d9, 0x28, 0, 0, 0}
    ,
    {0x94da, 0x12, 0, 0, 0}
    ,
    {0x94db, 0x01, 0, 0, 0}
    ,
    {0x94dc, 0x93, 0, 0, 0}
    ,
    {0x94dd, 0x75, 0, 0, 0}
    ,
    {0x94de, 0x51, 0, 0, 0}
    ,
    {0x94df, 0x0a, 0, 0, 0}
    ,
    {0x94e0, 0xae, 0, 0, 0}
    ,
    {0x94e1, 0x51, 0, 0, 0}
    ,
    {0x94e2, 0x15, 0, 0, 0}
    ,
    {0x94e3, 0x51, 0, 0, 0}
    ,
    {0x94e4, 0xee, 0, 0, 0}
    ,
    {0x94e5, 0x70, 0, 0, 0}
    ,
    {0x94e6, 0xf9, 0, 0, 0}
    ,
    {0x94e7, 0xc2, 0, 0, 0}
    ,
    {0x94e8, 0x28, 0, 0, 0}
    ,
    {0x94e9, 0x12, 0, 0, 0}
    ,
    {0x94ea, 0x01, 0, 0, 0}
    ,
    {0x94eb, 0x93, 0, 0, 0}
    ,
    {0x94ec, 0x75, 0, 0, 0}
    ,
    {0x94ed, 0x51, 0, 0, 0}
    ,
    {0x94ee, 0x05, 0, 0, 0}
    ,
    {0x94ef, 0xae, 0, 0, 0}
    ,
    {0x94f0, 0x51, 0, 0, 0}
    ,
    {0x94f1, 0x15, 0, 0, 0}
    ,
    {0x94f2, 0x51, 0, 0, 0}
    ,
    {0x94f3, 0xee, 0, 0, 0}
    ,
    {0x94f4, 0x70, 0, 0, 0}
    ,
    {0x94f5, 0xf9, 0, 0, 0}
    ,
    {0x94f6, 0xdf, 0, 0, 0}
    ,
    {0x94f7, 0xc2, 0, 0, 0}
    ,
    {0x94f8, 0x22, 0, 0, 0}
    ,
    {0x94f9, 0x90, 0, 0, 0}
    ,
    {0x94fa, 0x50, 0, 0, 0}
    ,
    {0x94fb, 0x27, 0, 0, 0}
    ,
    {0x94fc, 0xe0, 0, 0, 0}
    ,
    {0x94fd, 0x44, 0, 0, 0}
    ,
    {0x94fe, 0x01, 0, 0, 0}
    ,
    {0x94ff, 0xf0, 0, 0, 0}
    ,
    {0x9500, 0x12, 0, 0, 0}
    ,
    {0x9501, 0x02, 0, 0, 0}
    ,
    {0x9502, 0x5d, 0, 0, 0}
    ,
    {0x9503, 0x90, 0, 0, 0}
    ,
    {0x9504, 0x50, 0, 0, 0}
    ,
    {0x9505, 0x30, 0, 0, 0}
    ,
    {0x9506, 0xe4, 0, 0, 0}
    ,
    {0x9507, 0xf0, 0, 0, 0}
    ,
    {0x9508, 0xa3, 0, 0, 0}
    ,
    {0x9509, 0x74, 0, 0, 0}
    ,
    {0x950a, 0x02, 0, 0, 0}
    ,
    {0x950b, 0xf0, 0, 0, 0}
    ,
    {0x950c, 0xa3, 0, 0, 0}
    ,
    {0x950d, 0xe4, 0, 0, 0}
    ,
    {0x950e, 0xf0, 0, 0, 0}
    ,
    {0x950f, 0xa3, 0, 0, 0}
    ,
    {0x9510, 0x74, 0, 0, 0}
    ,
    {0x9511, 0x80, 0, 0, 0}
    ,
    {0x9512, 0xf0, 0, 0, 0}
    ,
    {0x9513, 0xe4, 0, 0, 0}
    ,
    {0x9514, 0xf5, 0, 0, 0}
    ,
    {0x9515, 0x0a, 0, 0, 0}
    ,
    {0x9516, 0x12, 0, 0, 0}
    ,
    {0x9517, 0x12, 0, 0, 0}
    ,
    {0x9518, 0xa3, 0, 0, 0}
    ,
    {0x9519, 0x75, 0, 0, 0}
    ,
    {0x951a, 0x79, 0, 0, 0}
    ,
    {0x951b, 0x02, 0, 0, 0}
    ,
    {0x951c, 0x75, 0, 0, 0}
    ,
    {0x951d, 0x0a, 0, 0, 0}
    ,
    {0x951e, 0x01, 0, 0, 0}
    ,
    {0x951f, 0x12, 0, 0, 0}
    ,
    {0x9520, 0x14, 0, 0, 0}
    ,
    {0x9521, 0x1c, 0, 0, 0}
    ,
    {0x9522, 0xd2, 0, 0, 0}
    ,
    {0x9523, 0x18, 0, 0, 0}
    ,
    {0x9524, 0xd2, 0, 0, 0}
    ,
    {0x9525, 0x19, 0, 0, 0}
    ,
    {0x9526, 0xc2, 0, 0, 0}
    ,
    {0x9527, 0x3d, 0, 0, 0}
    ,
    {0x9528, 0xc2, 0, 0, 0}
    ,
    {0x9529, 0x3c, 0, 0, 0}
    ,
    {0x952a, 0xd2, 0, 0, 0}
    ,
    {0x952b, 0x1a, 0, 0, 0}
    ,
    {0x952c, 0xd2, 0, 0, 0}
    ,
    {0x952d, 0x36, 0, 0, 0}
    ,
    {0x952e, 0xd2, 0, 0, 0}
    ,
    {0x952f, 0x30, 0, 0, 0}
    ,
    {0x9530, 0xc2, 0, 0, 0}
    ,
    {0x9531, 0x35, 0, 0, 0}
    ,
    {0x9532, 0xc2, 0, 0, 0}
    ,
    {0x9533, 0x3e, 0, 0, 0}
    ,
    {0x9534, 0x22, 0, 0, 0}
    ,
    {0x9535, 0x12, 0, 0, 0}
    ,
    {0x9536, 0x11, 0, 0, 0}
    ,
    {0x9537, 0xc2, 0, 0, 0}
    ,
    {0x9538, 0xd2, 0, 0, 0}
    ,
    {0x9539, 0x3f, 0, 0, 0}
    ,
    {0x953a, 0x12, 0, 0, 0}
    ,
    {0x953b, 0x11, 0, 0, 0}
    ,
    {0x953c, 0x35, 0, 0, 0}
    ,
    {0x953d, 0xd2, 0, 0, 0}
    ,
    {0x953e, 0x3f, 0, 0, 0}
    ,
    {0x953f, 0x12, 0, 0, 0}
    ,
    {0x9540, 0x13, 0, 0, 0}
    ,
    {0x9541, 0x08, 0, 0, 0}
    ,
    {0x9542, 0xe5, 0, 0, 0}
    ,
    {0x9543, 0x7c, 0, 0, 0}
    ,
    {0x9544, 0xd3, 0, 0, 0}
    ,
    {0x9545, 0x95, 0, 0, 0}
    ,
    {0x9546, 0x7d, 0, 0, 0}
    ,
    {0x9547, 0x40, 0, 0, 0}
    ,
    {0x9548, 0x03, 0, 0, 0}
    ,
    {0x9549, 0xd3, 0, 0, 0}
    ,
    {0x954a, 0x80, 0, 0, 0}
    ,
    {0x954b, 0x01, 0, 0, 0}
    ,
    {0x954c, 0xc3, 0, 0, 0}
    ,
    {0x954d, 0x50, 0, 0, 0}
    ,
    {0x954e, 0x14, 0, 0, 0}
    ,
    {0x954f, 0x20, 0, 0, 0}
    ,
    {0x9550, 0x38, 0, 0, 0}
    ,
    {0x9551, 0x0e, 0, 0, 0}
    ,
    {0x9552, 0xe5, 0, 0, 0}
    ,
    {0x9553, 0x24, 0, 0, 0}
    ,
    {0x9554, 0x54, 0, 0, 0}
    ,
    {0x9555, 0x1f, 0, 0, 0}
    ,
    {0x9556, 0xff, 0, 0, 0}
    ,
    {0x9557, 0xbf, 0, 0, 0}
    ,
    {0x9558, 0x1f, 0, 0, 0}
    ,
    {0x9559, 0x06, 0, 0, 0}
    ,
    {0x955a, 0x30, 0, 0, 0}
    ,
    {0x955b, 0x25, 0, 0, 0}
    ,
    {0x955c, 0x03, 0, 0, 0}
    ,
    {0x955d, 0x20, 0, 0, 0}
    ,
    {0x955e, 0x26, 0, 0, 0}
    ,
    {0x955f, 0x03, 0, 0, 0}
    ,
    {0x9560, 0x02, 0, 0, 0}
    ,
    {0x9561, 0x16, 0, 0, 0}
    ,
    {0x9562, 0x6d, 0, 0, 0}
    ,
    {0x9563, 0x12, 0, 0, 0}
    ,
    {0x9564, 0x02, 0, 0, 0}
    ,
    {0x9565, 0xd2, 0, 0, 0}
    ,
    {0x9566, 0x22, 0, 0, 0}
    ,
    {0x9567, 0xe5, 0, 0, 0}
    ,
    {0x9568, 0x7d, 0, 0, 0}
    ,
    {0x9569, 0x70, 0, 0, 0}
    ,
    {0x956a, 0x19, 0, 0, 0}
    ,
    {0x956b, 0x12, 0, 0, 0}
    ,
    {0x956c, 0x16, 0, 0, 0}
    ,
    {0x956d, 0x45, 0, 0, 0}
    ,
    {0x956e, 0xc2, 0, 0, 0}
    ,
    {0x956f, 0x3f, 0, 0, 0}
    ,
    {0x9570, 0x12, 0, 0, 0}
    ,
    {0x9571, 0x11, 0, 0, 0}
    ,
    {0x9572, 0x35, 0, 0, 0}
    ,
    {0x9573, 0xc2, 0, 0, 0}
    ,
    {0x9574, 0x3f, 0, 0, 0}
    ,
    {0x9575, 0x12, 0, 0, 0}
    ,
    {0x9576, 0x13, 0, 0, 0}
    ,
    {0x9577, 0x08, 0, 0, 0}
    ,
    {0x9578, 0xc2, 0, 0, 0}
    ,
    {0x9579, 0x03, 0, 0, 0}
    ,
    {0x957a, 0x12, 0, 0, 0}
    ,
    {0x957b, 0x16, 0, 0, 0}
    ,
    {0x957c, 0x6d, 0, 0, 0}
    ,
    {0x957d, 0xd2, 0, 0, 0}
    ,
    {0x957e, 0x02, 0, 0, 0}
    ,
    {0x957f, 0xd2, 0, 0, 0}
    ,
    {0x9580, 0x01, 0, 0, 0}
    ,
    {0x9581, 0xd2, 0, 0, 0}
    ,
    {0x9582, 0x00, 0, 0, 0}
    ,
    {0x9583, 0x22, 0, 0, 0}
    ,
    {0x9584, 0x30, 0, 0, 0}
    ,
    {0x9585, 0x03, 0, 0, 0}
    ,
    {0x9586, 0x08, 0, 0, 0}
    ,
    {0x9587, 0xc2, 0, 0, 0}
    ,
    {0x9588, 0x03, 0, 0, 0}
    ,
    {0x9589, 0xc2, 0, 0, 0}
    ,
    {0x958a, 0x04, 0, 0, 0}
    ,
    {0x958b, 0x12, 0, 0, 0}
    ,
    {0x958c, 0x02, 0, 0, 0}
    ,
    {0x958d, 0xc4, 0, 0, 0}
    ,
    {0x958e, 0x22, 0, 0, 0}
    ,
    {0x958f, 0xe4, 0, 0, 0}
    ,
    {0x9590, 0xf5, 0, 0, 0}
    ,
    {0x9591, 0x0c, 0, 0, 0}
    ,
    {0x9592, 0x12, 0, 0, 0}
    ,
    {0x9593, 0x13, 0, 0, 0}
    ,
    {0x9594, 0x6b, 0, 0, 0}
    ,
    {0x9595, 0xd2, 0, 0, 0}
    ,
    {0x9596, 0x03, 0, 0, 0}
    ,
    {0x9597, 0x22, 0, 0, 0}
    ,
    {0x9598, 0xe5, 0, 0, 0}
    ,
    {0x9599, 0x20, 0, 0, 0}
    ,
    {0x959a, 0x54, 0, 0, 0}
    ,
    {0x959b, 0x07, 0, 0, 0}
    ,
    {0x959c, 0xff, 0, 0, 0}
    ,
    {0x959d, 0xbf, 0, 0, 0}
    ,
    {0x959e, 0x01, 0, 0, 0}
    ,
    {0x959f, 0x03, 0, 0, 0}
    ,
    {0x95a0, 0x02, 0, 0, 0}
    ,
    {0x95a1, 0x15, 0, 0, 0}
    ,
    {0x95a2, 0x67, 0, 0, 0}
    ,
    {0x95a3, 0xe5, 0, 0, 0}
    ,
    {0x95a4, 0x20, 0, 0, 0}
    ,
    {0x95a5, 0x54, 0, 0, 0}
    ,
    {0x95a6, 0x07, 0, 0, 0}
    ,
    {0x95a7, 0xff, 0, 0, 0}
    ,
    {0x95a8, 0xbf, 0, 0, 0}
    ,
    {0x95a9, 0x07, 0, 0, 0}
    ,
    {0x95aa, 0x03, 0, 0, 0}
    ,
    {0x95ab, 0x02, 0, 0, 0}
    ,
    {0x95ac, 0x15, 0, 0, 0}
    ,
    {0x95ad, 0xeb, 0, 0, 0}
    ,
    {0x95ae, 0xe5, 0, 0, 0}
    ,
    {0x95af, 0x20, 0, 0, 0}
    ,
    {0x95b0, 0x54, 0, 0, 0}
    ,
    {0x95b1, 0x07, 0, 0, 0}
    ,
    {0x95b2, 0xff, 0, 0, 0}
    ,
    {0x95b3, 0xbf, 0, 0, 0}
    ,
    {0x95b4, 0x03, 0, 0, 0}
    ,
    {0x95b5, 0x03, 0, 0, 0}
    ,
    {0x95b6, 0x02, 0, 0, 0}
    ,
    {0x95b7, 0x15, 0, 0, 0}
    ,
    {0x95b8, 0x35, 0, 0, 0}
    ,
    {0x95b9, 0xe5, 0, 0, 0}
    ,
    {0x95ba, 0x20, 0, 0, 0}
    ,
    {0x95bb, 0x54, 0, 0, 0}
    ,
    {0x95bc, 0x07, 0, 0, 0}
    ,
    {0x95bd, 0xff, 0, 0, 0}
    ,
    {0x95be, 0xbf, 0, 0, 0}
    ,
    {0x95bf, 0x05, 0, 0, 0}
    ,
    {0x95c0, 0x03, 0, 0, 0}
    ,
    {0x95c1, 0x12, 0, 0, 0}
    ,
    {0x95c2, 0x16, 0, 0, 0}
    ,
    {0x95c3, 0xab, 0, 0, 0}
    ,
    {0x95c4, 0x22, 0, 0, 0}
    ,
    {0x95c5, 0x12, 0, 0, 0}
    ,
    {0x95c6, 0x14, 0, 0, 0}
    ,
    {0x95c7, 0xf9, 0, 0, 0}
    ,
    {0x95c8, 0x12, 0, 0, 0}
    ,
    {0x95c9, 0x16, 0, 0, 0}
    ,
    {0x95ca, 0xb9, 0, 0, 0}
    ,
    {0x95cb, 0x50, 0, 0, 0}
    ,
    {0x95cc, 0x04, 0, 0, 0}
    ,
    {0x95cd, 0xd2, 0, 0, 0}
    ,
    {0x95ce, 0x05, 0, 0, 0}
    ,
    {0x95cf, 0x80, 0, 0, 0}
    ,
    {0x95d0, 0x02, 0, 0, 0}
    ,
    {0x95d1, 0xc2, 0, 0, 0}
    ,
    {0x95d2, 0x05, 0, 0, 0}
    ,
    {0x95d3, 0x12, 0, 0, 0}
    ,
    {0x95d4, 0x02, 0, 0, 0}
    ,
    {0x95d5, 0x6c, 0, 0, 0}
    ,
    {0x95d6, 0xc2, 0, 0, 0}
    ,
    {0x95d7, 0x38, 0, 0, 0}
    ,
    {0x95d8, 0xc2, 0, 0, 0}
    ,
    {0x95d9, 0x31, 0, 0, 0}
    ,
    {0x95da, 0xd2, 0, 0, 0}
    ,
    {0x95db, 0x34, 0, 0, 0}
    ,
    {0x95dc, 0x12, 0, 0, 0}
    ,
    {0x95dd, 0x02, 0, 0, 0}
    ,
    {0x95de, 0xae, 0, 0, 0}
    ,
    {0x95df, 0xb5, 0, 0, 0}
    ,
    {0x95e0, 0x07, 0, 0, 0}
    ,
    {0x95e1, 0x03, 0, 0, 0}
    ,
    {0x95e2, 0xd3, 0, 0, 0}
    ,
    {0x95e3, 0x80, 0, 0, 0}
    ,
    {0x95e4, 0x01, 0, 0, 0}
    ,
    {0x95e5, 0xc3, 0, 0, 0}
    ,
    {0x95e6, 0x40, 0, 0, 0}
    ,
    {0x95e7, 0x02, 0, 0, 0}
    ,
    {0x95e8, 0xc2, 0, 0, 0}
    ,
    {0x95e9, 0x05, 0, 0, 0}
    ,
    {0x95ea, 0x22, 0, 0, 0}
    ,
    {0x95eb, 0x12, 0, 0, 0}
    ,
    {0x95ec, 0x11, 0, 0, 0}
    ,
    {0x95ed, 0xc2, 0, 0, 0}
    ,
    {0x95ee, 0xd2, 0, 0, 0}
    ,
    {0x95ef, 0x3f, 0, 0, 0}
    ,
    {0x95f0, 0x12, 0, 0, 0}
    ,
    {0x95f1, 0x11, 0, 0, 0}
    ,
    {0x95f2, 0x35, 0, 0, 0}
    ,
    {0x95f3, 0xd2, 0, 0, 0}
    ,
    {0x95f4, 0x3f, 0, 0, 0}
    ,
    {0x95f5, 0x12, 0, 0, 0}
    ,
    {0x95f6, 0x13, 0, 0, 0}
    ,
    {0x95f7, 0x08, 0, 0, 0}
    ,
    {0x95f8, 0x12, 0, 0, 0}
    ,
    {0x95f9, 0x16, 0, 0, 0}
    ,
    {0x95fa, 0x6d, 0, 0, 0}
    ,
    {0x95fb, 0xe5, 0, 0, 0}
    ,
    {0x95fc, 0x32, 0, 0, 0}
    ,
    {0x95fd, 0xd3, 0, 0, 0}
    ,
    {0x95fe, 0x95, 0, 0, 0}
    ,
    {0x95ff, 0x7d, 0, 0, 0}
    ,
    {0x9600, 0x40, 0, 0, 0}
    ,
    {0x9601, 0x05, 0, 0, 0}
    ,
    {0x9602, 0xe4, 0, 0, 0}
    ,
    {0x9603, 0x95, 0, 0, 0}
    ,
    {0x9604, 0x7d, 0, 0, 0}
    ,
    {0x9605, 0x40, 0, 0, 0}
    ,
    {0x9606, 0x06, 0, 0, 0}
    ,
    {0x9607, 0xc2, 0, 0, 0}
    ,
    {0x9608, 0x02, 0, 0, 0}
    ,
    {0x9609, 0xd2, 0, 0, 0}
    ,
    {0x960a, 0x01, 0, 0, 0}
    ,
    {0x960b, 0xd2, 0, 0, 0}
    ,
    {0x960c, 0x00, 0, 0, 0}
    ,
    {0x960d, 0x22, 0, 0, 0}
    ,
    {0x960e, 0xe4, 0, 0, 0}
    ,
    {0x960f, 0xff, 0, 0, 0}
    ,
    {0x9610, 0xfe, 0, 0, 0}
    ,
    {0x9611, 0xc3, 0, 0, 0}
    ,
    {0x9612, 0xef, 0, 0, 0}
    ,
    {0x9613, 0x95, 0, 0, 0}
    ,
    {0x9614, 0x0e, 0, 0, 0}
    ,
    {0x9615, 0xee, 0, 0, 0}
    ,
    {0x9616, 0x95, 0, 0, 0}
    ,
    {0x9617, 0x0d, 0, 0, 0}
    ,
    {0x9618, 0x50, 0, 0, 0}
    ,
    {0x9619, 0x15, 0, 0, 0}
    ,
    {0x961a, 0x7d, 0, 0, 0}
    ,
    {0x961b, 0x8a, 0, 0, 0}
    ,
    {0x961c, 0x7c, 0, 0, 0}
    ,
    {0x961d, 0x02, 0, 0, 0}
    ,
    {0x961e, 0xed, 0, 0, 0}
    ,
    {0x961f, 0x1d, 0, 0, 0}
    ,
    {0x9620, 0xaa, 0, 0, 0}
    ,
    {0x9621, 0x04, 0, 0, 0}
    ,
    {0x9622, 0x70, 0, 0, 0}
    ,
    {0x9623, 0x01, 0, 0, 0}
    ,
    {0x9624, 0x1c, 0, 0, 0}
    ,
    {0x9625, 0x4a, 0, 0, 0}
    ,
    {0x9626, 0x70, 0, 0, 0}
    ,
    {0x9627, 0xf6, 0, 0, 0}
    ,
    {0x9628, 0x0f, 0, 0, 0}
    ,
    {0x9629, 0xbf, 0, 0, 0}
    ,
    {0x962a, 0x00, 0, 0, 0}
    ,
    {0x962b, 0x01, 0, 0, 0}
    ,
    {0x962c, 0x0e, 0, 0, 0}
    ,
    {0x962d, 0x80, 0, 0, 0}
    ,
    {0x962e, 0xe2, 0, 0, 0}
    ,
    {0x962f, 0x22, 0, 0, 0}
    ,
    {0x9630, 0x75, 0, 0, 0}
    ,
    {0x9631, 0x48, 0, 0, 0}
    ,
    {0x9632, 0x12, 0, 0, 0}
    ,
    {0x9633, 0x75, 0, 0, 0}
    ,
    {0x9634, 0x49, 0, 0, 0}
    ,
    {0x9635, 0x3d, 0, 0, 0}
    ,
    {0x9636, 0x90, 0, 0, 0}
    ,
    {0x9637, 0x12, 0, 0, 0}
    ,
    {0x9638, 0x3b, 0, 0, 0}
    ,
    {0x9639, 0xe4, 0, 0, 0}
    ,
    {0x963a, 0x93, 0, 0, 0}
    ,
    {0x963b, 0xf5, 0, 0, 0}
    ,
    {0x963c, 0x7c, 0, 0, 0}
    ,
    {0x963d, 0xa3, 0, 0, 0}
    ,
    {0x963e, 0xe4, 0, 0, 0}
    ,
    {0x963f, 0x93, 0, 0, 0}
    ,
    {0x9640, 0xf5, 0, 0, 0}
    ,
    {0x9641, 0x32, 0, 0, 0}
    ,
    {0x9642, 0xc2, 0, 0, 0}
    ,
    {0x9643, 0x3b, 0, 0, 0}
    ,
    {0x9644, 0x22, 0, 0, 0}
    ,
    {0x9645, 0xe4, 0, 0, 0}
    ,
    {0x9646, 0xff, 0, 0, 0}
    ,
    {0x9647, 0xef, 0, 0, 0}
    ,
    {0x9648, 0x25, 0, 0, 0}
    ,
    {0x9649, 0xe0, 0, 0, 0}
    ,
    {0x964a, 0x24, 0, 0, 0}
    ,
    {0x964b, 0x56, 0, 0, 0}
    ,
    {0x964c, 0xf8, 0, 0, 0}
    ,
    {0x964d, 0xe4, 0, 0, 0}
    ,
    {0x964e, 0xf6, 0, 0, 0}
    ,
    {0x964f, 0x08, 0, 0, 0}
    ,
    {0x9650, 0xf6, 0, 0, 0}
    ,
    {0x9651, 0x0f, 0, 0, 0}
    ,
    {0x9652, 0xbf, 0, 0, 0}
    ,
    {0x9653, 0x07, 0, 0, 0}
    ,
    {0x9654, 0xf2, 0, 0, 0}
    ,
    {0x9655, 0x53, 0, 0, 0}
    ,
    {0x9656, 0x24, 0, 0, 0}
    ,
    {0x9657, 0x80, 0, 0, 0}
    ,
    {0x9658, 0x22, 0, 0, 0}
    ,
    {0x9659, 0xc2, 0, 0, 0}
    ,
    {0x965a, 0x03, 0, 0, 0}
    ,
    {0x965b, 0xd2, 0, 0, 0}
    ,
    {0x965c, 0x04, 0, 0, 0}
    ,
    {0x965d, 0x12, 0, 0, 0}
    ,
    {0x965e, 0x02, 0, 0, 0}
    ,
    {0x965f, 0xc4, 0, 0, 0}
    ,
    {0x9660, 0xc2, 0, 0, 0}
    ,
    {0x9661, 0x3f, 0, 0, 0}
    ,
    {0x9662, 0x12, 0, 0, 0}
    ,
    {0x9663, 0x11, 0, 0, 0}
    ,
    {0x9664, 0x35, 0, 0, 0}
    ,
    {0x9665, 0xc2, 0, 0, 0}
    ,
    {0x9666, 0x3f, 0, 0, 0}
    ,
    {0x9667, 0x12, 0, 0, 0}
    ,
    {0x9668, 0x13, 0, 0, 0}
    ,
    {0x9669, 0x08, 0, 0, 0}
    ,
    {0x966a, 0xd2, 0, 0, 0}
    ,
    {0x966b, 0x34, 0, 0, 0}
    ,
    {0x966c, 0x22, 0, 0, 0}
    ,
    {0x966d, 0xe5, 0, 0, 0}
    ,
    {0x966e, 0x7d, 0, 0, 0}
    ,
    {0x966f, 0xc3, 0, 0, 0}
    ,
    {0x9670, 0x95, 0, 0, 0}
    ,
    {0x9671, 0x7c, 0, 0, 0}
    ,
    {0x9672, 0x40, 0, 0, 0}
    ,
    {0x9673, 0x01, 0, 0, 0}
    ,
    {0x9674, 0x22, 0, 0, 0}
    ,
    {0x9675, 0xe5, 0, 0, 0}
    ,
    {0x9676, 0x7d, 0, 0, 0}
    ,
    {0x9677, 0x04, 0, 0, 0}
    ,
    {0x9678, 0xf5, 0, 0, 0}
    ,
    {0x9679, 0x0c, 0, 0, 0}
    ,
    {0x967a, 0x12, 0, 0, 0}
    ,
    {0x967b, 0x13, 0, 0, 0}
    ,
    {0x967c, 0x6b, 0, 0, 0}
    ,
    {0x967d, 0x22, 0, 0, 0}
    ,
    {0x967e, 0xe5, 0, 0, 0}
    ,
    {0x967f, 0x7d, 0, 0, 0}
    ,
    {0x9680, 0x70, 0, 0, 0}
    ,
    {0x9681, 0x02, 0, 0, 0}
    ,
    {0x9682, 0xc3, 0, 0, 0}
    ,
    {0x9683, 0x22, 0, 0, 0}
    ,
    {0x9684, 0xe5, 0, 0, 0}
    ,
    {0x9685, 0x7d, 0, 0, 0}
    ,
    {0x9686, 0x14, 0, 0, 0}
    ,
    {0x9687, 0xf5, 0, 0, 0}
    ,
    {0x9688, 0x0c, 0, 0, 0}
    ,
    {0x9689, 0x12, 0, 0, 0}
    ,
    {0x968a, 0x13, 0, 0, 0}
    ,
    {0x968b, 0x6b, 0, 0, 0}
    ,
    {0x968c, 0x22, 0, 0, 0}
    ,
    {0x968d, 0xe5, 0, 0, 0}
    ,
    {0x968e, 0x7e, 0, 0, 0}
    ,
    {0x968f, 0xb4, 0, 0, 0}
    ,
    {0x9690, 0x01, 0, 0, 0}
    ,
    {0x9691, 0x09, 0, 0, 0}
    ,
    {0x9692, 0x12, 0, 0, 0}
    ,
    {0x9693, 0x16, 0, 0, 0}
    ,
    {0x9694, 0x30, 0, 0, 0}
    ,
    {0x9695, 0xe4, 0, 0, 0}
    ,
    {0x9696, 0xf5, 0, 0, 0}
    ,
    {0x9697, 0x0c, 0, 0, 0}
    ,
    {0x9698, 0x12, 0, 0, 0}
    ,
    {0x9699, 0x13, 0, 0, 0}
    ,
    {0x969a, 0x6b, 0, 0, 0}
    ,
    {0x969b, 0x22, 0, 0, 0}
    ,
    {0x969c, 0xe5, 0, 0, 0}
    ,
    {0x969d, 0x7e, 0, 0, 0}
    ,
    {0x969e, 0x24, 0, 0, 0}
    ,
    {0x969f, 0xfe, 0, 0, 0}
    ,
    {0x96a0, 0x60, 0, 0, 0}
    ,
    {0x96a1, 0x06, 0, 0, 0}
    ,
    {0x96a2, 0x04, 0, 0, 0}
    ,
    {0x96a3, 0x70, 0, 0, 0}
    ,
    {0x96a4, 0x05, 0, 0, 0}
    ,
    {0x96a5, 0xd2, 0, 0, 0}
    ,
    {0x96a6, 0x38, 0, 0, 0}
    ,
    {0x96a7, 0x22, 0, 0, 0}
    ,
    {0x96a8, 0xc2, 0, 0, 0}
    ,
    {0x96a9, 0x38, 0, 0, 0}
    ,
    {0x96aa, 0x22, 0, 0, 0}
    ,
    {0x96ab, 0xe5, 0, 0, 0}
    ,
    {0x96ac, 0x31, 0, 0, 0}
    ,
    {0x96ad, 0xd3, 0, 0, 0}
    ,
    {0x96ae, 0x94, 0, 0, 0}
    ,
    {0x96af, 0x00, 0, 0, 0}
    ,
    {0x96b0, 0x40, 0, 0, 0}
    ,
    {0x96b1, 0x03, 0, 0, 0}
    ,
    {0x96b2, 0x15, 0, 0, 0}
    ,
    {0x96b3, 0x31, 0, 0, 0}
    ,
    {0x96b4, 0x22, 0, 0, 0}
    ,
    {0x96b5, 0x12, 0, 0, 0}
    ,
    {0x96b6, 0x16, 0, 0, 0}
    ,
    {0x96b7, 0x59, 0, 0, 0}
    ,
    {0x96b8, 0x22, 0, 0, 0}
    ,
    {0x96b9, 0x12, 0, 0, 0}
    ,
    {0x96ba, 0x16, 0, 0, 0}
    ,
    {0x96bb, 0x30, 0, 0, 0}
    ,
    {0x96bc, 0xe4, 0, 0, 0}
    ,
    {0x96bd, 0xf5, 0, 0, 0}
    ,
    {0x96be, 0x0c, 0, 0, 0}
    ,
    {0x96bf, 0x12, 0, 0, 0}
    ,
    {0x96c0, 0x13, 0, 0, 0}
    ,
    {0x96c1, 0x6b, 0, 0, 0}
    ,
    {0x96c2, 0x22, 0, 0, 0}
    ,
    {0x3024, 0x00, 0, 0, 0}
    ,
    {0x3025, 0x00, 0, 0, 0}
    ,
    {0x5082, 0x00, 0, 0, 0}
    ,
    {0x5083, 0x00, 0, 0, 0}
    ,
    {0x5084, 0x00, 0, 0, 0}
    ,
    {0x5085, 0x00, 0, 0, 0}
    ,
    {0x3026, 0x00, 0, 0, 0}
    ,
    {0x3027, 0xFF, 0, 0, 0}
    ,
    {0x3000, 0x00, 0, 0, 0}
};

reg_param_t g_ov5642_af_trigger[] = {
    {0x3024, 0x03, 0, 500, 0}
    ,
    {0x5003, 0xa8, 0, 0, 0}
};

reg_param_t g_ov5642_af_ready[] = {
    {0x3027, 0x12, 0, 0, 0}
    ,
};

/*
reg_param_t g_ov5642_strobe_on[] = {
    {0x3004, 0xff, 0, 0, 0},
    {0x3016, 0x02, 0, 0, 0},
    {0x3B00, 0x8C, 0, 0, 0},
};
*/

reg_param_t g_mt9p111_mode_vga_640_480_30fps[] = {
    //Step2-PLL_Timing
    {0x0010, 0x0320, 1, 0, 1}
    ,                           //PLL Dividers = 800
    {0x0012, 0x0070, 1, 0, 0}
    ,                           //PLL P Dividers = 112
    {0x0014, 0x2025, 1, 0, 0}
    ,                           //PLL Control: TEST_BYPASS off = 8229
    {0x001E, 0x0777, 1, 0, 0}
    ,                           //Pad Slew Pad Config = 1911
    {0x0022, 0x01E0, 1, 0, 0}
    ,                           //VDD_DIS counter delay
    {0x002A, 0x7B46, 1, 0, 0}
    ,                           //PLL P Dividers 4-5-6 = 31558
    {0x002C, 0x0000, 1, 0, 0}
    ,                           //PLL P Dividers 7 = 0
    {0x002E, 0x0000, 1, 0, 0}
    ,                           //Sensor Clock Divider = 0
    {0x0018, 0x4008, 1, 10, 0}
    ,                           //Standby Control and Status: Out of standby
    {0x30D4, 0x9080, 1, 0, 0}
    ,                           //Disable Double Samplings
    {0x98E, 0x1000, 1, 0, 0}
    ,
    {0xC86C, 0x0518, 1, 0, 0}
    ,                           //Output Width (A) = 1304
    {0xC86E, 0x03D4, 1, 0, 0}
    ,                           //Output Height (A) = 980
    {0xC83A, 0x000C, 1, 0, 0}
    ,                           //Row Start (A) = 12
    {0xC83C, 0x0018, 1, 0, 0}
    ,                           //Column Start (A) = 24
    {0xC83E, 0x07B1, 1, 0, 0}
    ,                           //Row End (A) = 1969
    {0xC840, 0x0A45, 1, 0, 0}
    ,                           //Column End (A) = 2629
    {0xC842, 0x0001, 1, 0, 0}
    ,                           //Row Speed (A) = 1
    {0xC844, 0x0103, 1, 0, 0}
    ,                           //Core Skip X (A) = 259
    {0xC846, 0x0103, 1, 0, 0}
    ,                           //Core Skip Y (A) = 259
    {0xC848, 0x0103, 1, 0, 0}
    ,                           //Pipe Skip X (A) = 259
    {0xC84A, 0x0103, 1, 0, 0}
    ,                           //Pipe Skip Y (A) = 259
    {0xC84C, 0x00F6, 1, 0, 0}
    ,                           //Power Mode (A) = 246
    {0xC84E, 0x0001, 1, 0, 0}
    ,                           //Bin Mode (A) = 1
    {0xC850, 0x00, 0, 0, 0}
    ,                           //Orientation (A) = 0
    {0xC851, 0x00, 0, 0, 0}
    ,                           //Pixel Order (A) = 0
    {0xC852, 0x019C, 1, 0, 0}
    ,                           //Fine Correction (A) = 412
    {0xC854, 0x0732, 1, 0, 0}
    ,                           //Fine IT Min (A) = 1842
    {0xC856, 0x048E, 1, 0, 0}
    ,                           //Fine IT Max Margin (A) = 1166
    {0xC858, 0x0002, 1, 0, 0}
    ,                           //Coarse IT Min (A) = 2
    {0xC85A, 0x0001, 1, 0, 0}
    ,                           //Coarse IT Max Margin (A) = 1
    {0xC85C, 0x0423, 1, 0, 0}
    ,                           //Min Frame Lines (A) = 1059
    {0xC85E, 0xFFFF, 1, 0, 0}
    ,                           //Max Frame Lines (A) = 65535
    {0xC860, 0x0423, 1, 0, 0}
    ,                           //Base Frame Lines (A) = 1059
    {0xC862, 0x0EB7, 1, 0, 0}
    ,                           //Min Line Length (A) = 3767
    {0xC864, 0xFFFE, 1, 0, 0}
    ,                           //Max Line Length (A) = 65534
    {0xC866, 0x7B46, 1, 0, 0}
    ,                           //P456 Divider (A) = 31558
    {0xC868, 0x0423, 1, 0, 0}
    ,                           //Frame Lines (A) = 1059
    {0xC86A, 0x0EB7, 1, 0, 0}
    ,                           //Line Length (A) = 3767
    {0xC870, 0x0014, 1, 0, 0}
    ,                           //RX FIFO Watermark (A) = 20
    {0xC8AA, 0x0280, 1, 0, 0}
    ,                           //Output_0 Image Width = 640
    {0xC8AC, 0x01E0, 1, 0, 0}
    ,                           //Output_0 Image Height = 480
    {0xC8AE, 0x0001, 1, 0, 0}
    ,                           //Output_0 Image Format = 1
    {0xC8B0, 0x0002, 1, 0, 0}
    ,                           //Output_0 Format Order = 0
    {0xC8B8, 0x0004, 1, 0, 0}
    ,                           //Output_0 JPEG control = 4
    {0xC8A4, 0x0A28, 1, 0, 0}
    ,                           //Output Width (B) = 2600
    {0xC8A6, 0x07A0, 1, 0, 0}
    ,                           //Output Height (B) = 1952
    {0xC872, 0x0010, 1, 0, 0}
    ,                           //Row Start (B) = 16
    {0xC874, 0x001C, 1, 0, 0}
    ,                           //Column Start (B) = 28
    {0xC876, 0x07AF, 1, 0, 0}
    ,                           //Row End (B) = 1967
    {0xC878, 0x0A43, 1, 0, 0}
    ,                           //Column End (B) = 2627
    {0xC87A, 0x0001, 1, 0, 0}
    ,                           //Row Speed (B) = 1
    {0xC87C, 0x0101, 1, 0, 0}
    ,                           //Core Skip X (B) = 257
    {0xC87E, 0x0101, 1, 0, 0}
    ,                           //Core Skip Y (B) = 257
    {0xC880, 0x0101, 1, 0, 0}
    ,                           //Pipe Skip X (B) = 257
    {0xC882, 0x0101, 1, 0, 0}
    ,                           //Pipe Skip Y (B) = 257
    {0xC884, 0x00F2, 1, 0, 0}
    ,                           //Power Mode (B) = 242
    {0xC886, 0x0000, 1, 0, 0}
    ,                           //Bin Mode (B) = 0
    {0xC888, 0x00, 0, 0, 0}
    ,                           //Orientation (B) = 0
    {0xC889, 0x00, 0, 0, 0}
    ,                           //Pixel Order (B) = 0
    {0xC88A, 0x009C, 1, 0, 0}
    ,                           //Fine Correction (B) = 156
    {0xC88C, 0x034A, 1, 0, 0}
    ,                           //Fine IT Min (B) = 842
    {0xC88E, 0x02A6, 1, 0, 0}
    ,                           //Fine IT Max Margin (B) = 678
    {0xC890, 0x0002, 1, 0, 0}
    ,                           //Coarse IT Min (B) = 2
    {0xC892, 0x0001, 1, 0, 0}
    ,                           //Coarse IT Max Margin (B) = 1
    {0xC894, 0x07EF, 1, 0, 0}
    ,                           //Min Frame Lines (B) = 2031
    {0xC896, 0xFFFF, 1, 0, 0}
    ,                           //Max Frame Lines (B) = 65535
    {0xC898, 0x07EF, 1, 0, 0}
    ,                           //Base Frame Lines (B) = 2031
    {0xC89A, 0x37C4, 1, 0, 0}
    ,                           //Min Line Length (B) = 14276
    {0xC89C, 0xFFFE, 1, 0, 0}
    ,                           //Max Line Length (B) = 65534
    {0xC89E, 0x7B46, 1, 0, 0}
    ,                           //P456 Divider (B) = 31558
    {0xC8A0, 0x07EF, 1, 0, 0}
    ,                           //Frame Lines (B) = 2031
    {0xC8A2, 0x37C4, 1, 0, 0}
    ,                           //Line Length (B) = 14276
    {0xC8A8, 0x0014, 1, 0, 0}
    ,                           //RX FIFO Watermark (B) = 20
    {0xC8C0, 0x0A20, 1, 0, 0}
    ,                           //Output_1 Image Width = 2592
    {0xC8C2, 0x0798, 1, 0, 0}
    ,                           //Output_1 Image Height = 1944
    {0xC8C4, 0x0001, 1, 0, 0}
    ,                           //Output_1 Image Format = 1
    {0xC8C6, 0x0000, 1, 0, 0}
    ,                           //Output_1 Format Order = 0
    {0xC8CE, 0x0004, 1, 0, 0}
    ,                           //Output_1 JPEG control = 4
    {0xA010, 0x0119, 1, 0, 0}
    ,                           //fd_min_expected50hz_flicker_period = 281
    {0xA012, 0x012D, 1, 0, 0}
    ,                           //fd_max_expected50hz_flicker_period = 301
    {0xA014, 0x00E9, 1, 0, 0}
    ,                           //fd_min_expected60hz_flicker_period = 233
    {0xA016, 0x00FD, 1, 0, 0}
    ,                           //fd_max_expected60hz_flicker_period = 253
    {0xA018, 0x0123, 1, 0, 0}
    ,                           //fd_expected50hz_flicker_period (A) = 291
    {0xA01A, 0x004D, 1, 0, 0}
    ,                           //fd_expected50hz_flicker_period (B) = 77
    {0xA01C, 0x00F3, 1, 0, 0}
    ,                           //fd_expected60hz_flicker_period (A) = 243
    {0xA01E, 0x0040, 1, 0, 0}
    ,                           //fd_expected60hz_flicker_period (B) = 64
    {0xDC0A, 0x06, 0, 0, 0}
    ,                           //Scaler Allow Zoom Ratio = 6
    {0xDC1C, 0x2710, 1, 0, 0}
    ,                           //System Zoom Ratio = 10000
    {0xE004, 0x0F00, 1, 50, 0}
    ,                           //I2C Master Clock Divider = 3840

    //Step3-Recommended
    //  k28a_rev03_patch01_basic_REV5
    {0x0982, 0x0000, 1, 0, 0}
    ,                           // ACCESS_CTL_STAT
    {0x098A, 0x0000, 1, 0, 0}
    ,                           // PHYSICAL_ADDRESS_ACCESS
    {0x886C, 0xC0F1, 1, 0, 0}
    ,
    {0x886E, 0xC5E1, 1, 0, 0}
    ,
    {0x8870, 0x246A, 1, 0, 0}
    ,
    {0x8872, 0x1280, 1, 0, 0}
    ,
    {0x8874, 0xC4E1, 1, 0, 0}
    ,
    {0x8876, 0xD20F, 1, 0, 0}
    ,
    {0x8878, 0x2069, 1, 0, 0}
    ,
    {0x887A, 0x0000, 1, 0, 0}
    ,
    {0x887C, 0x6A62, 1, 0, 0}
    ,
    {0x887E, 0x1303, 1, 0, 0}
    ,
    {0x8880, 0x0084, 1, 0, 0}
    ,
    {0x8882, 0x1734, 1, 0, 0}
    ,
    {0x8884, 0x7005, 1, 0, 0}
    ,
    {0x8886, 0xD801, 1, 0, 0}
    ,
    {0x8888, 0x8A41, 1, 0, 0}
    ,
    {0x888A, 0xD900, 1, 0, 0}
    ,
    {0x888C, 0x0D5A, 1, 0, 0}
    ,
    {0x888E, 0x0664, 1, 0, 0}
    ,
    {0x8890, 0x8B61, 1, 0, 0}
    ,
    {0x8892, 0xE80B, 1, 0, 0}
    ,
    {0x8894, 0x000D, 1, 0, 0}
    ,
    {0x8896, 0x0020, 1, 0, 0}
    ,
    {0x8898, 0xD508, 1, 0, 0}
    ,
    {0x889A, 0x1504, 1, 0, 0}
    ,
    {0x889C, 0x1400, 1, 0, 0}
    ,
    {0x889E, 0x7840, 1, 0, 0}
    ,
    {0x88A0, 0xD007, 1, 0, 0}
    ,
    {0x88A2, 0x0DFB, 1, 0, 0}
    ,
    {0x88A4, 0x9004, 1, 0, 0}
    ,
    {0x88A6, 0xC4C1, 1, 0, 0}
    ,
    {0x88A8, 0x2029, 1, 0, 0}
    ,
    {0x88AA, 0x0300, 1, 0, 0}
    ,
    {0x88AC, 0x0219, 1, 0, 0}
    ,
    {0x88AE, 0x06C4, 1, 0, 0}
    ,
    {0x88B0, 0xFF80, 1, 0, 0}
    ,
    {0x88B2, 0x08C4, 1, 0, 0}
    ,
    {0x88B4, 0xFF80, 1, 0, 0}
    ,
    {0x88B6, 0x086C, 1, 0, 0}
    ,
    {0x88B8, 0xFF80, 1, 0, 0}
    ,
    {0x88BA, 0x08C0, 1, 0, 0}
    ,
    {0x88BC, 0xFF80, 1, 0, 0}
    ,
    {0x88BE, 0x08C4, 1, 0, 0}
    ,
    {0x88C0, 0xFF80, 1, 0, 0}
    ,
    {0x88C2, 0x0ACC, 1, 0, 0}
    ,
    {0x88C4, 0x0009, 1, 0, 0}
    ,
    {0x88C6, 0x0003, 1, 0, 0}
    ,
    {0x88C8, 0x0000, 1, 0, 0}
    ,
    {0x88CA, 0x0000, 1, 0, 0}
    ,
    {0x88CC, 0xC0F1, 1, 0, 0}
    ,
    {0x88CE, 0xC5E1, 1, 0, 0}
    ,
    {0x88D0, 0xD585, 1, 0, 0}
    ,
    {0x88D2, 0x8D00, 1, 0, 0}
    ,
    {0x88D4, 0xB8E7, 1, 0, 0}
    ,
    {0x88D6, 0x20D1, 1, 0, 0}
    ,
    {0x88D8, 0x81A2, 1, 0, 0}
    ,
    {0x88DA, 0xF20A, 1, 0, 0}
    ,
    {0x88DC, 0xD083, 1, 0, 0}
    ,
    {0x88DE, 0x8000, 1, 0, 0}
    ,
    {0x88E0, 0x8023, 1, 0, 0}
    ,
    {0x88E2, 0x7960, 1, 0, 0}
    ,
    {0x88E4, 0xD801, 1, 0, 0}
    ,
    {0x88E6, 0x8D00, 1, 0, 0}
    ,
    {0x88E8, 0xB8A7, 1, 0, 0}
    ,
    {0x88EA, 0xAD00, 1, 0, 0}
    ,
    {0x88EC, 0x1528, 1, 0, 0}
    ,
    {0x88EE, 0x1080, 1, 0, 0}
    ,
    {0x88F0, 0x0817, 1, 0, 0}
    ,
    {0x88F2, 0x01DE, 1, 0, 0}
    ,
    {0x88F4, 0xB8A7, 1, 0, 0}
    ,
    {0x88F6, 0x1D28, 1, 0, 0}
    ,
    {0x88F8, 0x1002, 1, 0, 0}
    ,
    {0x88FA, 0xD07C, 1, 0, 0}
    ,
    {0x88FC, 0x8000, 1, 0, 0}
    ,
    {0x88FE, 0x8023, 1, 0, 0}
    ,
    {0x8900, 0x7960, 1, 0, 0}
    ,
    {0x8902, 0x1528, 1, 0, 0}
    ,
    {0x8904, 0x1080, 1, 0, 0}
    ,
    {0x8906, 0x01C1, 1, 0, 0}
    ,
    {0x8908, 0x06C4, 1, 0, 0}
    ,
    {0x890A, 0x78E0, 1, 0, 0}
    ,
    {0x890C, 0xC0F1, 1, 0, 0}
    ,
    {0x890E, 0x093A, 1, 0, 0}
    ,
    {0x8910, 0x06C4, 1, 0, 0}
    ,
    {0x8912, 0xD577, 1, 0, 0}
    ,
    {0x8914, 0x2540, 1, 0, 0}
    ,
    {0x8916, 0x1610, 1, 0, 0}
    ,
    {0x8918, 0x8D32, 1, 0, 0}
    ,
    {0x891A, 0x2540, 1, 0, 0}
    ,
    {0x891C, 0x15D1, 1, 0, 0}
    ,
    {0x891E, 0x8D45, 1, 0, 0}
    ,
    {0x8920, 0x2132, 1, 0, 0}
    ,
    {0x8922, 0x204F, 1, 0, 0}
    ,
    {0x8924, 0x8D24, 1, 0, 0}
    ,
    {0x8926, 0xB908, 1, 0, 0}
    ,
    {0x8928, 0x70F1, 1, 0, 0}
    ,
    {0x892A, 0x7945, 1, 0, 0}
    ,
    {0x892C, 0x27CA, 1, 0, 0}
    ,
    {0x892E, 0x100C, 1, 0, 0}
    ,
    {0x8930, 0xF6C4, 1, 0, 0}
    ,
    {0x8932, 0x0909, 1, 0, 0}
    ,
    {0x8934, 0x0051, 1, 0, 0}
    ,
    {0x8936, 0xADE7, 1, 0, 0}
    ,
    {0x8938, 0xD66B, 1, 0, 0}
    ,
    {0x893A, 0x0959, 1, 0, 0}
    ,
    {0x893C, 0x0411, 1, 0, 0}
    ,
    {0x893E, 0x8D06, 1, 0, 0}
    ,
    {0x8940, 0x0827, 1, 0, 0}
    ,
    {0x8942, 0x0051, 1, 0, 0}
    ,
    {0x8944, 0x095A, 1, 0, 0}
    ,
    {0x8946, 0x0000, 1, 0, 0}
    ,
    {0x8948, 0x790F, 1, 0, 0}
    ,
    {0x894A, 0xAE09, 1, 0, 0}
    ,
    {0x894C, 0x8E04, 1, 0, 0}
    ,
    {0x894E, 0x0F0F, 1, 0, 0}
    ,
    {0x8950, 0x1003, 1, 0, 0}
    ,
    {0x8952, 0x0917, 1, 0, 0}
    ,
    {0x8954, 0x0052, 1, 0, 0}
    ,
    {0x8956, 0xB961, 1, 0, 0}
    ,
    {0x8958, 0xF006, 1, 0, 0}
    ,
    {0x895A, 0x8D12, 1, 0, 0}
    ,
    {0x895C, 0xB862, 1, 0, 0}
    ,
    {0x895E, 0x090B, 1, 0, 0}
    ,
    {0x8960, 0x0003, 1, 0, 0}
    ,
    {0x8962, 0xE101, 1, 0, 0}
    ,
    {0x8964, 0xAE29, 1, 0, 0}
    ,
    {0x8966, 0x8E04, 1, 0, 0}
    ,
    {0x8968, 0x0F0D, 1, 0, 0}
    ,
    {0x896A, 0x1003, 1, 0, 0}
    ,
    {0x896C, 0x8E09, 1, 0, 0}
    ,
    {0x896E, 0x0821, 1, 0, 0}
    ,
    {0x8970, 0x0052, 1, 0, 0}
    ,
    {0x8972, 0xF007, 1, 0, 0}
    ,
    {0x8974, 0x8D12, 1, 0, 0}
    ,
    {0x8976, 0x2132, 1, 0, 0}
    ,
    {0x8978, 0x2001, 1, 0, 0}
    ,
    {0x897A, 0x0F0D, 1, 0, 0}
    ,
    {0x897C, 0x1042, 1, 0, 0}
    ,
    {0x897E, 0xB861, 1, 0, 0}
    ,
    {0x8980, 0x780F, 1, 0, 0}
    ,
    {0x8982, 0xF005, 1, 0, 0}
    ,
    {0x8984, 0x8E09, 1, 0, 0}
    ,
    {0x8986, 0xE001, 1, 0, 0}
    ,
    {0x8988, 0x780F, 1, 0, 0}
    ,
    {0x898A, 0xAE09, 1, 0, 0}
    ,
    {0x898C, 0x2032, 1, 0, 0}
    ,
    {0x898E, 0x200F, 1, 0, 0}
    ,
    {0x8990, 0x8E04, 1, 0, 0}
    ,
    {0x8992, 0x0F49, 1, 0, 0}
    ,
    {0x8994, 0x1000, 1, 0, 0}
    ,
    {0x8996, 0x274F, 1, 0, 0}
    ,
    {0x8998, 0x13C1, 1, 0, 0}
    ,
    {0x899A, 0x2941, 1, 0, 0}
    ,
    {0x899C, 0x0200, 1, 0, 0}
    ,
    {0x899E, 0x1E26, 1, 0, 0}
    ,
    {0x89A0, 0x1002, 1, 0, 0}
    ,
    {0x89A2, 0x1620, 1, 0, 0}
    ,
    {0x89A4, 0x1080, 1, 0, 0}
    ,
    {0x89A6, 0x1E27, 1, 0, 0}
    ,
    {0x89A8, 0x1042, 1, 0, 0}
    ,
    {0x89AA, 0x1621, 1, 0, 0}
    ,
    {0x89AC, 0x1081, 1, 0, 0}
    ,
    {0x89AE, 0xB808, 1, 0, 0}
    ,
    {0x89B0, 0x7825, 1, 0, 0}
    ,
    {0x89B2, 0x1622, 1, 0, 0}
    ,
    {0x89B4, 0x1081, 1, 0, 0}
    ,
    {0x89B6, 0xB808, 1, 0, 0}
    ,
    {0x89B8, 0x7825, 1, 0, 0}
    ,
    {0x89BA, 0x1623, 1, 0, 0}
    ,
    {0x89BC, 0x1081, 1, 0, 0}
    ,
    {0x89BE, 0xB808, 1, 0, 0}
    ,
    {0x89C0, 0x7825, 1, 0, 0}
    ,
    {0x89C2, 0x8022, 1, 0, 0}
    ,
    {0x89C4, 0x7960, 1, 0, 0}
    ,
    {0x89C6, 0xD801, 1, 0, 0}
    ,
    {0x89C8, 0x8E21, 1, 0, 0}
    ,
    {0x89CA, 0xE805, 1, 0, 0}
    ,
    {0x89CC, 0xB980, 1, 0, 0}
    ,
    {0x89CE, 0xAE21, 1, 0, 0}
    ,
    {0x89D0, 0xF032, 1, 0, 0}
    ,
    {0x89D2, 0xB9A0, 1, 0, 0}
    ,
    {0x89D4, 0xB981, 1, 0, 0}
    ,
    {0x89D6, 0xAE21, 1, 0, 0}
    ,
    {0x89D8, 0x0D36, 1, 0, 0}
    ,
    {0x89DA, 0xFFE3, 1, 0, 0}
    ,
    {0x89DC, 0x70E9, 1, 0, 0}
    ,
    {0x89DE, 0x8D04, 1, 0, 0}
    ,
    {0x89E0, 0x8D25, 1, 0, 0}
    ,
    {0x89E2, 0xB808, 1, 0, 0}
    ,
    {0x89E4, 0x7825, 1, 0, 0}
    ,
    {0x89E6, 0x8D72, 1, 0, 0}
    ,
    {0x89E8, 0x081D, 1, 0, 0}
    ,
    {0x89EA, 0x0411, 1, 0, 0}
    ,
    {0x89EC, 0x8E49, 1, 0, 0}
    ,
    {0x89EE, 0x8E24, 1, 0, 0}
    ,
    {0x89F0, 0x8E05, 1, 0, 0}
    ,
    {0x89F2, 0x627A, 1, 0, 0}
    ,
    {0x89F4, 0x080B, 1, 0, 0}
    ,
    {0x89F6, 0x0063, 1, 0, 0}
    ,
    {0x89F8, 0x655D, 1, 0, 0}
    ,
    {0x89FA, 0x8D18, 1, 0, 0}
    ,
    {0x89FC, 0xF01B, 1, 0, 0}
    ,
    {0x89FE, 0x8D19, 1, 0, 0}
    ,
    {0x8A00, 0x781C, 1, 0, 0}
    ,
    {0x8A02, 0xF019, 1, 0, 0}
    ,
    {0x8A04, 0x8D26, 1, 0, 0}
    ,
    {0x8A06, 0x091D, 1, 0, 0}
    ,
    {0x8A08, 0x0050, 1, 0, 0}
    ,
    {0x8A0A, 0x0B19, 1, 0, 0}
    ,
    {0x8A0C, 0x0042, 1, 0, 0}
    ,
    {0x8A0E, 0x8E00, 1, 0, 0}
    ,
    {0x8A10, 0x0811, 1, 0, 0}
    ,
    {0x8A12, 0x01DF, 1, 0, 0}
    ,
    {0x8A14, 0x8D00, 1, 0, 0}
    ,
    {0x8A16, 0x8D41, 1, 0, 0}
    ,
    {0x8A18, 0xB808, 1, 0, 0}
    ,
    {0x8A1A, 0x7845, 1, 0, 0}
    ,
    {0x8A1C, 0x080B, 1, 0, 0}
    ,
    {0x8A1E, 0x019E, 1, 0, 0}
    ,
    {0x8A20, 0x2032, 1, 0, 0}
    ,
    {0x8A22, 0x20C0, 1, 0, 0}
    ,
    {0x8A24, 0xF007, 1, 0, 0}
    ,
    {0x8A26, 0xBB61, 1, 0, 0}
    ,
    {0x8A28, 0x8D11, 1, 0, 0}
    ,
    {0x8A2A, 0x6179, 1, 0, 0}
    ,
    {0x8A2C, 0x6038, 1, 0, 0}
    ,
    {0x8A2E, 0x2032, 1, 0, 0}
    ,
    {0x8A30, 0x2000, 1, 0, 0}
    ,
    {0x8A32, 0xAE1F, 1, 0, 0}
    ,
    {0x8A34, 0x0071, 1, 0, 0}
    ,
    {0x8A36, 0x06C4, 1, 0, 0}
    ,
    {0x8A38, 0xD22B, 1, 0, 0}
    ,
    {0x8A3A, 0x8A01, 1, 0, 0}
    ,
    {0x8A3C, 0x080F, 1, 0, 0}
    ,
    {0x8A3E, 0x005E, 1, 0, 0}
    ,
    {0x8A40, 0x8A3F, 1, 0, 0}
    ,
    {0x8A42, 0xE905, 1, 0, 0}
    ,
    {0x8A44, 0xB961, 1, 0, 0}
    ,
    {0x8A46, 0xAA3F, 1, 0, 0}
    ,
    {0x8A48, 0xF005, 1, 0, 0}
    ,
    {0x8A4A, 0x2050, 1, 0, 0}
    ,
    {0x8A4C, 0x0041, 1, 0, 0}
    ,
    {0x8A4E, 0x782F, 1, 0, 0}
    ,
    {0x8A50, 0xAA21, 1, 0, 0}
    ,
    {0x8A52, 0x7EE0, 1, 0, 0}
    ,
    {0x8A54, 0xB861, 1, 0, 0}
    ,
    {0x8A56, 0x0845, 1, 0, 0}
    ,
    {0x8A58, 0x0175, 1, 0, 0}
    ,
    {0x8A5A, 0xC0F1, 1, 0, 0}
    ,
    {0x8A5C, 0x2740, 1, 0, 0}
    ,
    {0x8A5E, 0x7301, 1, 0, 0}
    ,
    {0x8A60, 0x2133, 1, 0, 0}
    ,
    {0x8A62, 0x0000, 1, 0, 0}
    ,
    {0x8A64, 0x7914, 1, 0, 0}
    ,
    {0x8A66, 0x7900, 1, 0, 0}
    ,
    {0x8A68, 0x0313, 1, 0, 0}
    ,
    {0x8A6A, 0x0313, 1, 0, 0}
    ,
    {0x8A6C, 0x0300, 1, 0, 0}
    ,
    {0x8A6E, 0xD11E, 1, 0, 0}
    ,
    {0x8A70, 0x1124, 1, 0, 0}
    ,
    {0x8A72, 0x0080, 1, 0, 0}
    ,
    {0x8A74, 0xE884, 1, 0, 0}
    ,
    {0x8A76, 0xD818, 1, 0, 0}
    ,
    {0x8A78, 0x1924, 1, 0, 0}
    ,
    {0x8A7A, 0x0002, 1, 0, 0}
    ,
    {0x8A7C, 0x8906, 1, 0, 0}
    ,
    {0x8A7E, 0xE885, 1, 0, 0}
    ,
    {0x8A80, 0xD01C, 1, 0, 0}
    ,
    {0x8A82, 0x8818, 1, 0, 0}
    ,
    {0x8A84, 0xA906, 1, 0, 0}
    ,
    {0x8A86, 0xD119, 1, 0, 0}
    ,
    {0x8A88, 0x8120, 1, 0, 0}
    ,
    {0x8A8A, 0x8121, 1, 0, 0}
    ,
    {0x8A8C, 0xF005, 1, 0, 0}
    ,
    {0x8A8E, 0xD017, 1, 0, 0}
    ,
    {0x8A90, 0x8000, 1, 0, 0}
    ,
    {0x8A92, 0x8021, 1, 0, 0}
    ,
    {0x8A94, 0xD800, 1, 0, 0}
    ,
    {0x8A96, 0x7940, 1, 0, 0}
    ,
    {0x8A98, 0xC0D1, 1, 0, 0}
    ,
    {0x8A9A, 0x7EE0, 1, 0, 0}
    ,
    {0x8A9C, 0xC5E1, 1, 0, 0}
    ,
    {0x8A9E, 0xC6E1, 1, 0, 0}
    ,
    {0x8AA0, 0xD800, 1, 0, 0}
    ,
    {0x8AA2, 0xD313, 1, 0, 0}
    ,
    {0x8AA4, 0x2340, 1, 0, 0}
    ,
    {0x8AA6, 0x060E, 1, 0, 0}
    ,
    {0x8AA8, 0xF003, 1, 0, 0}
    ,
    {0x8AAA, 0xE001, 1, 0, 0}
    ,
    {0x8AAC, 0x780F, 1, 0, 0}
    ,
    {0x8AAE, 0x8B32, 1, 0, 0}
    ,
    {0x8AB0, 0x080F, 1, 0, 0}
    ,
    {0x8AB2, 0x0043, 1, 0, 0}
    ,
    {0x8AB4, 0xD20C, 1, 0, 0}
    ,
    {0x8AB6, 0x8A44, 1, 0, 0}
    ,
    {0x8AB8, 0x660D, 1, 0, 0}
    ,
    {0x8ABA, 0x0DF3, 1, 0, 0}
    ,
    {0x8ABC, 0x9082, 1, 0, 0}
    ,
    {0x8ABE, 0x080B, 1, 0, 0}
    ,
    {0x8AC0, 0x0041, 1, 0, 0}
    ,
    {0x8AC2, 0x6909, 1, 0, 0}
    ,
    {0x8AC4, 0x780F, 1, 0, 0}
    ,
    {0x8AC6, 0xC6C1, 1, 0, 0}
    ,
    {0x8AC8, 0x7FE0, 1, 0, 0}
    ,
    {0x8ACA, 0xC5C1, 1, 0, 0}
    ,
    {0x8ACC, 0xD00A, 1, 0, 0}
    ,
    {0x8ACE, 0xD10B, 1, 0, 0}
    ,
    {0x8AD0, 0xA100, 1, 0, 0}
    ,
    {0x8AD2, 0xD00B, 1, 0, 0}
    ,
    {0x8AD4, 0xA101, 1, 0, 0}
    ,
    {0x8AD6, 0xD00B, 1, 0, 0}
    ,
    {0x8AD8, 0xA102, 1, 0, 0}
    ,
    {0x8ADA, 0xD00B, 1, 0, 0}
    ,
    {0x8ADC, 0xA103, 1, 0, 0}
    ,
    {0x8ADE, 0xD003, 1, 0, 0}
    ,
    {0x8AE0, 0x7FE0, 1, 0, 0}
    ,
    {0x8AE2, 0xA020, 1, 0, 0}
    ,
    {0x8AE4, 0xFF80, 1, 0, 0}
    ,
    {0x8AE6, 0x0158, 1, 0, 0}
    ,
    {0x8AE8, 0x8000, 1, 0, 0}
    ,
    {0x8AEA, 0x0008, 1, 0, 0}
    ,
    {0x8AEC, 0xFF80, 1, 0, 0}
    ,
    {0x8AEE, 0x0290, 1, 0, 0}
    ,
    {0x8AF0, 0xFF80, 1, 0, 0}
    ,
    {0x8AF2, 0x02C8, 1, 0, 0}
    ,
    {0x8AF4, 0xFF80, 1, 0, 0}
    ,
    {0x8AF6, 0x08CC, 1, 0, 0}
    ,
    {0x8AF8, 0xFF80, 1, 0, 0}
    ,
    {0x8AFA, 0x0B4C, 1, 0, 0}
    ,
    {0x8AFC, 0xFF80, 1, 0, 0}
    ,
    {0x8AFE, 0x090C, 1, 0, 0}
    ,
    {0x8B00, 0xFF80, 1, 0, 0}
    ,
    {0x8B02, 0x0A38, 1, 0, 0}
    ,
    {0x8B04, 0xFF80, 1, 0, 0}
    ,
    {0x8B06, 0x0A54, 1, 0, 0}
    ,
    {0x8B08, 0xE280, 1, 0, 0}
    ,
    {0x8B0A, 0x24CA, 1, 0, 0}
    ,
    {0x8B0C, 0x7082, 1, 0, 0}
    ,
    {0x8B0E, 0x78E0, 1, 0, 0}
    ,
    {0x8B10, 0x20E8, 1, 0, 0}
    ,
    {0x8B12, 0x01A2, 1, 0, 0}
    ,
    {0x8B14, 0x1002, 1, 0, 0}
    ,
    {0x8B16, 0x0D02, 1, 0, 0}
    ,
    {0x8B18, 0x1902, 1, 0, 0}
    ,
    {0x8B1A, 0x0094, 1, 0, 0}
    ,
    {0x8B1C, 0x7FE0, 1, 0, 0}
    ,
    {0x8B1E, 0x7028, 1, 0, 0}
    ,
    {0x8B20, 0x7308, 1, 0, 0}
    ,
    {0x8B22, 0x1000, 1, 0, 0}
    ,
    {0x8B24, 0x0900, 1, 0, 0}
    ,
    {0x8B26, 0x7904, 1, 0, 0}
    ,
    {0x8B28, 0x7947, 1, 0, 0}
    ,
    {0x8B2A, 0x1B00, 1, 0, 0}
    ,
    {0x8B2C, 0x0064, 1, 0, 0}
    ,
    {0x8B2E, 0x7EE0, 1, 0, 0}
    ,
    {0x8B30, 0xE280, 1, 0, 0}
    ,
    {0x8B32, 0x24CA, 1, 0, 0}
    ,
    {0x8B34, 0x7082, 1, 0, 0}
    ,
    {0x8B36, 0x78E0, 1, 0, 0}
    ,
    {0x8B38, 0x20E8, 1, 0, 0}
    ,
    {0x8B3A, 0x01A2, 1, 0, 0}
    ,
    {0x8B3C, 0x1102, 1, 0, 0}
    ,
    {0x8B3E, 0x0502, 1, 0, 0}
    ,
    {0x8B40, 0x1802, 1, 0, 0}
    ,
    {0x8B42, 0x00B4, 1, 0, 0}
    ,
    {0x8B44, 0x7FE0, 1, 0, 0}
    ,
    {0x8B46, 0x7028, 1, 0, 0}
    ,
    {0x8B48, 0x0000, 1, 0, 0}
    ,
    {0x8B4A, 0x0000, 1, 0, 0}
    ,
    {0x098E, 0x0016, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [MON_ADDRESS_LO]
    {0x8016, 0x086C, 1, 0, 0}
    ,                           // MON_ADDRESS_LO
    {0x8002, 0x0001, 1, 250, 0}
    ,                           // MON_CMD

    {0x30D4, 0x9080, 1, 0, 0}
    ,                           // COLUMN_CORRECTION
    {0x316E, 0xCAFF, 1, 0, 0}
    ,                           // DAC_ECL
    {0x305E, 0x10A0, 1, 0, 0}
    ,                           // GLOBAL_GAIN
    {0x3E00, 0x0010, 1, 0, 0}
    ,                           // SAMP_CONTROL
    {0x3E02, 0xED02, 1, 0, 0}
    ,                           // SAMP_ADDR_EN
    {0x3E04, 0xC88C, 1, 0, 0}
    ,                           // SAMP_RD1_SIG
    {0x3E06, 0xC88C, 1, 0, 0}
    ,                           // SAMP_RD1_SIG_BOOST
    {0x3E08, 0x700A, 1, 0, 0}
    ,                           // SAMP_RD1_RST
    {0x3E0A, 0x701E, 1, 0, 0}
    ,                           // SAMP_RD1_RST_BOOST
    {0x3E0C, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST1_EN
    {0x3E0E, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST1_BOOST
    {0x3E10, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST1_CLOOP_SH
    {0x3E12, 0x0000, 1, 0, 0}
    ,                           // SAMP_RST_BOOST_SEQ
    {0x3E14, 0xC78C, 1, 0, 0}
    ,                           // SAMP_SAMP1_SIG
    {0x3E16, 0x6E06, 1, 0, 0}
    ,                           // SAMP_SAMP1_RST
    {0x3E18, 0xA58C, 1, 0, 0}
    ,                           // SAMP_TX_EN
    {0x3E1A, 0xA58E, 1, 0, 0}
    ,                           // SAMP_TX_BOOST
    {0x3E1C, 0xA58E, 1, 0, 0}
    ,                           // SAMP_TX_CLOOP_SH
    {0x3E1E, 0xC0D0, 1, 0, 0}
    ,                           // SAMP_TX_BOOST_SEQ
    {0x3E20, 0xEB00, 1, 0, 0}
    ,                           // SAMP_VLN_EN
    {0x3E22, 0x00FF, 1, 0, 0}
    ,                           // SAMP_VLN_HOLD
    {0x3E24, 0xEB02, 1, 0, 0}
    ,                           // SAMP_VCL_EN
    {0x3E26, 0xEA02, 1, 0, 0}
    ,                           // SAMP_COLCLAMP
    {0x3E28, 0xEB0A, 1, 0, 0}
    ,                           // SAMP_SH_VCL
    {0x3E2A, 0xEC01, 1, 0, 0}
    ,                           // SAMP_SH_VREF
    {0x3E2C, 0xEB01, 1, 0, 0}
    ,                           // SAMP_SH_VBST
    {0x3E2E, 0x00FF, 1, 0, 0}
    ,                           // SAMP_SPARE
    {0x3E30, 0x00F3, 1, 0, 0}
    ,                           // SAMP_READOUT
    {0x3E32, 0x3DFA, 1, 0, 0}
    ,                           // SAMP_RESET_DONE
    {0x3E34, 0x00FF, 1, 0, 0}
    ,                           // SAMP_VLN_CLAMP
    {0x3E36, 0x00F3, 1, 0, 0}
    ,                           // SAMP_ASC_INT
    {0x3E38, 0x0000, 1, 0, 0}
    ,                           // SAMP_RS_CLOOP_SH_R
    {0x3E3A, 0xF802, 1, 0, 0}
    ,                           // SAMP_RS_CLOOP_SH
    {0x3E3C, 0x0FFF, 1, 0, 0}
    ,                           // SAMP_RS_BOOST_SEQ
    {0x3E3E, 0xEA10, 1, 0, 0}
    ,                           // SAMP_TXLO_GND
    {0x3E40, 0xEB05, 1, 0, 0}
    ,                           // SAMP_VLN_PER_COL
    {0x3E42, 0xE5C8, 1, 0, 0}
    ,                           // SAMP_RD2_SIG
    {0x3E44, 0xE5C8, 1, 0, 0}
    ,                           // SAMP_RD2_SIG_BOOST
    {0x3E46, 0x8C70, 1, 0, 0}
    ,                           // SAMP_RD2_RST
    {0x3E48, 0x8C71, 1, 0, 0}
    ,                           // SAMP_RD2_RST_BOOST
    {0x3E4A, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST2_EN
    {0x3E4C, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST2_BOOST
    {0x3E4E, 0x00FF, 1, 0, 0}
    ,                           // SAMP_RST2_CLOOP_SH
    {0x3E50, 0xE38D, 1, 0, 0}
    ,                           // SAMP_SAMP2_SIG
    {0x3E52, 0x8B0A, 1, 0, 0}
    ,                           // SAMP_SAMP2_RST
    {0x3E58, 0xEB0A, 1, 0, 0}
    ,                           // SAMP_PIX_CLAMP_EN
    {0x3E5C, 0x0A00, 1, 0, 0}
    ,                           // SAMP_PIX_PULLUP_EN
    {0x3E5E, 0x00FF, 1, 0, 0}
    ,                           // SAMP_PIX_PULLDOWN_EN_R
    {0x3E60, 0x00FF, 1, 0, 0}
    ,                           // SAMP_PIX_PULLDOWN_EN_S
    {0x3E90, 0x3C01, 1, 0, 0}
    ,                           // RST_ADDR_EN
    {0x3E92, 0x00FF, 1, 0, 0}
    ,                           // RST_RST_EN
    {0x3E94, 0x00FF, 1, 0, 0}
    ,                           // RST_RST_BOOST
    {0x3E96, 0x3C00, 1, 0, 0}
    ,                           // RST_TX_EN
    {0x3E98, 0x3C00, 1, 0, 0}
    ,                           // RST_TX_BOOST
    {0x3E9A, 0x3C00, 1, 0, 0}
    ,                           // RST_TX_CLOOP_SH
    {0x3E9C, 0xC0E0, 1, 0, 0}
    ,                           // RST_TX_BOOST_SEQ
    {0x3E9E, 0x00FF, 1, 0, 0}
    ,                           // RST_RST_CLOOP_SH
    {0x3EA0, 0x0000, 1, 0, 0}
    ,                           // RST_RST_BOOST_SEQ
    {0x3EA6, 0x3C00, 1, 0, 0}
    ,                           // RST_PIX_PULLUP_EN
    {0x3ED8, 0x3057, 1, 0, 0}
    ,                           // DAC_LD_12_13
    {0x316C, 0xB44F, 1, 0, 0}
    ,                           // DAC_TXLO
    {0x316E, 0xCAFF, 1, 0, 0}
    ,                           // DAC_ECL
    {0x3ED2, 0xEA0A, 1, 0, 0}
    ,                           // DAC_LD_6_7
    {0x3ED4, 0x00A3, 1, 0, 0}
    ,                           // DAC_LD_8_9
    {0x3EDC, 0x6020, 1, 0, 0}
    ,                           // DAC_LD_16_17
    {0x3EE6, 0xA541, 1, 0, 0}
    ,                           // DAC_LD_26_27
    {0x31E0, 0x0000, 1, 0, 0}
    ,                           // PIX_DEF_ID
    {0x3ED0, 0x2409, 1, 0, 0}
    ,                           // DAC_LD_4_5
    {0x3EDE, 0x0A49, 1, 0, 0}
    ,                           // DAC_LD_18_19
    {0x3EE0, 0x4910, 1, 0, 0}
    ,                           // DAC_LD_20_21
    {0x3EE2, 0x09D2, 1, 0, 0}
    ,                           // DAC_LD_22_23
    {0x30B6, 0x0006, 1, 0, 0}
    ,                           // AUTOLR_CONTROL
//  {0x098E, 0x8404, 1, 0, 0},  // LOGICAL_ADDRESS_ACCESS [SEQ_CMD]
    {0x8404, 0x06, 0, 100, 0}
    ,                           // SEQ_CMD
    {0x337C, 0x0006, 1, 0, 0}
    ,                           // YUV_YCBCR_CONTROL

    //Step4-PGA //Lens shading correction
    {0x3640, 0x03D0, 1, 0, 0}
    ,
    {0x3642, 0x00CD, 1, 0, 0}
    ,
    {0x3644, 0x37F1, 1, 0, 0}
    ,
    {0x3646, 0x75ED, 1, 0, 0}
    ,
    {0x3648, 0x9FD1, 1, 0, 0}
    ,
    {0x364A, 0x0590, 1, 0, 0}
    ,
    {0x364C, 0x9B0E, 1, 0, 0}
    ,
    {0x364E, 0x4130, 1, 0, 0}
    ,
    {0x3650, 0x41CF, 1, 0, 0}
    ,
    {0x3652, 0xCB30, 1, 0, 0}
    ,
    {0x3654, 0x03F0, 1, 0, 0}
    ,
    {0x3656, 0x3F0C, 1, 0, 0}
    ,
    {0x3658, 0x6CF0, 1, 0, 0}
    ,
    {0x365A, 0x750C, 1, 0, 0}
    ,
    {0x365C, 0xD390, 1, 0, 0}
    ,
    {0x365E, 0x0310, 1, 0, 0}
    ,
    {0x3660, 0xB94E, 1, 0, 0}
    ,
    {0x3662, 0x24D1, 1, 0, 0}
    ,
    {0x3664, 0x29AF, 1, 0, 0}
    ,
    {0x3666, 0x9831, 1, 0, 0}
    ,
    {0x3680, 0x3DCD, 1, 0, 0}
    ,
    {0x3682, 0x8BF0, 1, 0, 0}
    ,
    {0x3684, 0x8D0D, 1, 0, 0}
    ,
    {0x3686, 0x0731, 1, 0, 0}
    ,
    {0x3688, 0x5F10, 1, 0, 0}
    ,
    {0x368A, 0x108F, 1, 0, 0}
    ,
    {0x368C, 0xC40F, 1, 0, 0}
    ,
    {0x368E, 0x9B4F, 1, 0, 0}
    ,
    {0x3690, 0x59B0, 1, 0, 0}
    ,
    {0x3692, 0x30AF, 1, 0, 0}
    ,
    {0x3694, 0x1DEC, 1, 0, 0}
    ,
    {0x3696, 0xCA2E, 1, 0, 0}
    ,
    {0x3698, 0x056F, 1, 0, 0}
    ,
    {0x369A, 0x5BEF, 1, 0, 0}
    ,
    {0x369C, 0x5CAB, 1, 0, 0}
    ,
    {0x369E, 0x23AD, 1, 0, 0}
    ,
    {0x36A0, 0x9890, 1, 0, 0}
    ,
    {0x36A2, 0x074F, 1, 0, 0}
    ,
    {0x36A4, 0x0E91, 1, 0, 0}
    ,
    {0x36A6, 0x75ED, 1, 0, 0}
    ,
    {0x36C0, 0x6231, 1, 0, 0}
    ,
    {0x36C2, 0xF42F, 1, 0, 0}
    ,
    {0x36C4, 0xFE30, 1, 0, 0}
    ,
    {0x36C6, 0x4832, 1, 0, 0}
    ,
    {0x36C8, 0xDD53, 1, 0, 0}
    ,
    {0x36CA, 0x39D1, 1, 0, 0}
    ,
    {0x36CC, 0xE470, 1, 0, 0}
    ,
    {0x36CE, 0x8532, 1, 0, 0}
    ,
    {0x36D0, 0x3A72, 1, 0, 0}
    ,
    {0x36D2, 0xC991, 1, 0, 0}
    ,
    {0x36D4, 0x41B1, 1, 0, 0}
    ,
    {0x36D6, 0x458D, 1, 0, 0}
    ,
    {0x36D8, 0x5FCE, 1, 0, 0}
    ,
    {0x36DA, 0x7951, 1, 0, 0}
    ,
    {0x36DC, 0xF533, 1, 0, 0}
    ,
    {0x36DE, 0x7411, 1, 0, 0}
    ,
    {0x36E0, 0x99B1, 1, 0, 0}
    ,
    {0x36E2, 0xD150, 1, 0, 0}
    ,
    {0x36E4, 0x0B73, 1, 0, 0}
    ,
    {0x36E6, 0xE913, 1, 0, 0}
    ,
    {0x3700, 0x3B30, 1, 0, 0}
    ,
    {0x3702, 0x1311, 1, 0, 0}
    ,
    {0x3704, 0x2450, 1, 0, 0}
    ,
    {0x3706, 0xDDD1, 1, 0, 0}
    ,
    {0x3708, 0x88D1, 1, 0, 0}
    ,
    {0x370A, 0x06F0, 1, 0, 0}
    ,
    {0x370C, 0x59F0, 1, 0, 0}
    ,
    {0x370E, 0xE6CF, 1, 0, 0}
    ,
    {0x3710, 0xD7D1, 1, 0, 0}
    ,
    {0x3712, 0x7B92, 1, 0, 0}
    ,
    {0x3714, 0x580E, 1, 0, 0}
    ,
    {0x3716, 0x6A2F, 1, 0, 0}
    ,
    {0x3718, 0x38D1, 1, 0, 0}
    ,
    {0x371A, 0x7D6D, 1, 0, 0}
    ,
    {0x371C, 0xB991, 1, 0, 0}
    ,
    {0x371E, 0x7D8F, 1, 0, 0}
    ,
    {0x3720, 0x19B0, 1, 0, 0}
    ,
    {0x3722, 0x2330, 1, 0, 0}
    ,
    {0x3724, 0xC88F, 1, 0, 0}
    ,
    {0x3726, 0xA58F, 1, 0, 0}
    ,
    {0x3740, 0xCB51, 1, 0, 0}
    ,
    {0x3742, 0x1813, 1, 0, 0}
    ,
    {0x3744, 0xFB74, 1, 0, 0}
    ,
    {0x3746, 0x9DF5, 1, 0, 0}
    ,
    {0x3748, 0x5C16, 1, 0, 0}
    ,
    {0x374A, 0xFB71, 1, 0, 0}
    ,
    {0x374C, 0x2BF3, 1, 0, 0}
    ,
    {0x374E, 0xBBF3, 1, 0, 0}
    ,
    {0x3750, 0x9235, 1, 0, 0}
    ,
    {0x3752, 0x1A36, 1, 0, 0}
    ,
    {0x3754, 0xA6F1, 1, 0, 0}
    ,
    {0x3756, 0x58F2, 1, 0, 0}
    ,
    {0x3758, 0xFA74, 1, 0, 0}
    ,
    {0x375A, 0x80B5, 1, 0, 0}
    ,
    {0x375C, 0x5136, 1, 0, 0}
    ,
    {0x375E, 0xDC71, 1, 0, 0}
    ,
    {0x3760, 0x4E53, 1, 0, 0}
    ,
    {0x3762, 0x8475, 1, 0, 0}
    ,
    {0x3764, 0xAF55, 1, 0, 0}
    ,
    {0x3766, 0x64D6, 1, 0, 0}
    ,
    {0x3782, 0x03B4, 1, 0, 0}
    ,
    {0x3784, 0x051C, 1, 0, 0}
    ,                           // CENTER_COLUMN
    {0x3210, 0x49B8, 1, 1, 0}
    ,                           // COLOR_PIPELINE_CONTROL

    //Step5-AWB_CCM
    {0x098E, 0xAC01, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [AWB_MODE]
    {0xAC01, 0xAB, 0, 0, 0}
    ,                           // AWB_MODE
    {0xAC46, 0x0221, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_0
    {0xAC48, 0xFEAE, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_1
    {0xAC4A, 0x0032, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_2
    {0xAC4C, 0xFFC5, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_3
    {0xAC4E, 0x0154, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_4
    {0xAC50, 0xFFE7, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_5
    {0xAC52, 0xFFB1, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_6
    {0xAC54, 0xFEC5, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_7
    {0xAC56, 0x028A, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_8
    {0xAC58, 0x0130, 1, 0, 0}
    ,                           // AWB_LEFT_CCM_R2BRATIO
    {0xAC5C, 0x01CD, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_0
    {0xAC5E, 0xFF63, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_1
    {0xAC60, 0xFFD0, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_2
    {0xAC62, 0xFFCD, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_3
    {0xAC64, 0x013B, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_4
    {0xAC66, 0xFFF8, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_5
    {0xAC68, 0xFFFB, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_6
    {0xAC6A, 0xFF78, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_7
    {0xAC6C, 0x018D, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_8
    {0xAC6E, 0x0055, 1, 0, 0}
    ,                           // AWB_RIGHT_CCM_R2BRATIO
    {0xB842, 0x0037, 1, 0, 0}
    ,                           // STAT_AWB_GRAY_CHECKER_OFFSET_X
    {0xB844, 0x0044, 1, 0, 0}
    ,                           // STAT_AWB_GRAY_CHECKER_OFFSET_Y
    {0x3240, 0x0024, 1, 0, 0}
    ,                           // AWB_XY_SCALE
    {0x3240, 0x0024, 1, 0, 0}
    ,                           // AWB_XY_SCALE
    {0x3242, 0x0000, 1, 0, 0}
    ,                           // AWB_WEIGHT_R0
    {0x3244, 0x0000, 1, 0, 0}
    ,                           // AWB_WEIGHT_R1
    {0x3246, 0x0000, 1, 0, 0}
    ,                           // AWB_WEIGHT_R2
    {0x3248, 0x7F00, 1, 0, 0}
    ,                           // AWB_WEIGHT_R3
    {0x324A, 0xA500, 1, 0, 0}
    ,                           // AWB_WEIGHT_R4
    {0x324C, 0x1540, 1, 0, 0}
    ,                           // AWB_WEIGHT_R5
    {0x324E, 0x01AC, 1, 0, 0}
    ,                           // AWB_WEIGHT_R6
    {0x3250, 0x003E, 1, 0, 0}
    ,                           // AWB_WEIGHT_R7
    {0x8404, 0x06, 0, 100, 0}
    ,                           // SEQ_CMD
    {0xAC3C, 0x2E, 0, 0, 0}
    ,                           // AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO
    {0xAC3D, 0x84, 0, 0, 0}
    ,                           // AWB_MAX_ACCEPTED_PRE_AWB_R2G_RATIO
    {0xAC3E, 0x11, 0, 0, 0}
    ,                           // AWB_MIN_ACCEPTED_PRE_AWB_B2G_RATIO
    {0xAC3F, 0x63, 0, 0, 0}
    ,                           // AWB_MAX_ACCEPTED_PRE_AWB_B2G_RATIO
    {0xACB0, 0x2B, 0, 0, 0}
    ,                           // AWB_RG_MIN
    {0xACB1, 0x84, 0, 0, 0}
    ,                           // AWB_RG_MAX
    {0xACB4, 0x11, 0, 0, 0}
    ,                           // AWB_BG_MIN
    {0xACB5, 0x63, 0, 0, 0}
    ,                           // AWB_BG_MAX

    //Step6-CPIPE_Calibration
//  {0x098E, 0xD80F, 1, 0, 0},  // LOGICAL_ADDRESS_ACCESS [JPEG_QSCALE_0]
    {0xD80F, 0x04, 0, 0, 0}
    ,                           // JPEG_QSCALE_0
    {0xD810, 0x08, 0, 0, 0}
    ,                           // JPEG_QSCALE_1
    {0xC8D2, 0x04, 0, 0, 0}
    ,                           // CAM_OUTPUT_1_JPEG_QSCALE_0
    {0xC8D3, 0x08, 0, 0, 0}
    ,                           // CAM_OUTPUT_1_JPEG_QSCALE_1
    {0xC8BC, 0x04, 0, 0, 0}
    ,                           // CAM_OUTPUT_0_JPEG_QSCALE_0
    {0xC8BD, 0x08, 0, 0, 0}
    ,                           // CAM_OUTPUT_0_JPEG_QSCALE_1
    {0x301A, 0x10F4, 1, 0, 0}
    ,                           // RESET_REGISTER
    {0x301E, 0x0000, 1, 0, 0}
    ,                           // DATA_PEDESTAL
    {0x301A, 0x10FC, 1, 0, 0}
    ,                           // RESET_REGISTER
    {0xDC33, 0x00, 0, 0, 0}
    ,                           // SYS_FIRST_BLACK_LEVEL
    {0xDC35, 0x04, 0, 0, 0}
    ,                           // SYS_UV_COLOR_BOOST
    {0x326E, 0x0006, 1, 0, 0}
    ,                           // LOW_PASS_YUV_FILTER
    {0xDC37, 0x62, 0, 0, 0}
    ,                           // SYS_BRIGHT_COLORKILL
    {0x35A4, 0x0596, 1, 0, 0}
    ,                           // BRIGHT_COLOR_KILL_CONTROLS
    {0x35A2, 0x0094, 1, 0, 0}
    ,                           // DARK_COLOR_KILL_CONTROLS
    {0xDC36, 0x23, 0, 0, 0}
    ,                           // SYS_DARK_COLOR_KILL
    {0x8404, 0x06, 0, 300, 0}
    ,                           // SEQ_CMD
    {0xBC18, 0x00, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_0
    {0xBC19, 0x11, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_1
    {0xBC1A, 0x23, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_2
    {0xBC1B, 0x3F, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_3
    {0xBC1C, 0x67, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_4
    {0xBC1D, 0x85, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_5
    {0xBC1E, 0x9B, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_6
    {0xBC1F, 0xAD, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_7
    {0xBC20, 0xBB, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_8
    {0xBC21, 0xC7, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_9
    {0xBC22, 0xD1, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_10
    {0xBC23, 0xDA, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_11
    {0xBC24, 0xE1, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_12
    {0xBC25, 0xE8, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_13
    {0xBC26, 0xEE, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_14
    {0xBC27, 0xF3, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_15
    {0xBC28, 0xF7, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_16
    {0xBC29, 0xFB, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_17
    {0xBC2A, 0xFF, 0, 0, 0}
    ,                           // LL_GAMMA_CONTRAST_CURVE_18
    {0xBC2B, 0x00, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_0
    {0xBC2C, 0x11, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_1
    {0xBC2D, 0x23, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_2
    {0xBC2E, 0x3F, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_3
    {0xBC2F, 0x67, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_4
    {0xBC30, 0x85, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_5
    {0xBC31, 0x9B, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_6
    {0xBC32, 0xAD, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_7
    {0xBC33, 0xBB, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_8
    {0xBC34, 0xC7, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_9
    {0xBC35, 0xD1, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_10
    {0xBC36, 0xDA, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_11
    {0xBC37, 0xE1, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_12
    {0xBC38, 0xE8, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_13
    {0xBC39, 0xEE, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_14
    {0xBC3A, 0xF3, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_15
    {0xBC3B, 0xF7, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_16
    {0xBC3C, 0xFB, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_17
    {0xBC3D, 0xFF, 0, 0, 0}
    ,                           // LL_GAMMA_NEUTRAL_CURVE_18
    {0xBC3E, 0x00, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_0
    {0xBC3F, 0x18, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_1
    {0xBC40, 0x25, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_2
    {0xBC41, 0x3A, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_3
    {0xBC42, 0x59, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_4
    {0xBC43, 0x70, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_5
    {0xBC44, 0x81, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_6
    {0xBC45, 0x90, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_7
    {0xBC46, 0x9E, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_8
    {0xBC47, 0xAB, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_9
    {0xBC48, 0xB6, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_10
    {0xBC49, 0xC1, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_11
    {0xBC4A, 0xCB, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_12
    {0xBC4B, 0xD5, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_13
    {0xBC4C, 0xDE, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_14
    {0xBC4D, 0xE7, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_15
    {0xBC4E, 0xEF, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_16
    {0xBC4F, 0xF7, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_17
    {0xBC50, 0xFF, 0, 0, 0}
    ,                           // LL_GAMMA_NR_CURVE_18
    {0x8404, 0x06, 0, 100, 0}
    ,                           // SEQ_CMD
    {0xB801, 0xE0, 0, 0, 0}
    ,                           // STAT_MODE
    {0xB862, 0x04, 0, 0, 0}
    ,                           // STAT_BMTRACKING_SPEED
    {0xB829, 0x02, 0, 0, 0}
    ,                           // STAT_LL_BRIGHTNESS_METRIC_DIVISOR
    {0xB863, 0x02, 0, 0, 0}
    ,                           // STAT_BM_MUL
    {0xB827, 0x0F, 0, 0, 0}
    ,                           // STAT_AE_EV_SHIFT
    {0xA409, 0x37, 0, 0, 0}
    ,                           // AE_RULE_BASE_TARGET
    {0xBC52, 0x00C8, 1, 0, 0}
    ,                           // LL_START_BRIGHTNESS_METRIC
    {0xBC54, 0x0A28, 1, 0, 0}
    ,                           // LL_END_BRIGHTNESS_METRIC
    {0xBC58, 0x00C8, 1, 0, 0}
    ,                           // LL_START_GAIN_METRIC
    {0xBC5A, 0x12C0, 1, 0, 0}
    ,                           // LL_END_GAIN_METRIC
    {0xBC5E, 0x00FA, 1, 0, 0}
    ,                           // LL_START_APERTURE_GAIN_BM
    {0xBC60, 0x0258, 1, 0, 0}
    ,                           // LL_END_APERTURE_GAIN_BM
    {0xBC66, 0x00FA, 1, 0, 0}
    ,                           // LL_START_APERTURE_GM
    {0xBC68, 0x0258, 1, 0, 0}
    ,                           // LL_END_APERTURE_GM
    {0xBC86, 0x00C8, 1, 0, 0}
    ,                           // LL_START_FFNR_GM
    {0xBC88, 0x0640, 1, 0, 0}
    ,                           // LL_END_FFNR_GM
    {0xBCBC, 0x0040, 1, 0, 0}
    ,                           // LL_SFFB_START_GAIN
    {0xBCBE, 0x01FC, 1, 0, 0}
    ,                           // LL_SFFB_END_GAIN
    {0xBCCC, 0x00C8, 1, 0, 0}
    ,                           // LL_SFFB_START_MAX_GM
    {0xBCCE, 0x0640, 1, 0, 0}
    ,                           // LL_SFFB_END_MAX_GM
    {0xBC90, 0x00C8, 1, 0, 0}
    ,                           // LL_START_GRB_GM
    {0xBC92, 0x0640, 1, 0, 0}
    ,                           // LL_END_GRB_GM
    {0xBC0E, 0x0001, 1, 0, 0}
    ,                           // LL_GAMMA_CURVE_ADJ_START_POS
    {0xBC10, 0x0002, 1, 0, 0}
    ,                           // LL_GAMMA_CURVE_ADJ_MID_POS
    {0xBC12, 0x02BC, 1, 0, 0}
    ,                           // LL_GAMMA_CURVE_ADJ_END_POS
    {0xBCAA, 0x044C, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_START_POS
    {0xBCAC, 0x00AF, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_MID_POS
    {0xBCAE, 0x0009, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_END_POS
    {0xBCD8, 0x00C8, 1, 0, 0}
    ,                           // LL_PCR_START_BM
    {0xBCDA, 0x0A28, 1, 0, 0}
    ,                           // LL_PCR_END_BM
    {0x3380, 0x0504, 1, 0, 0}
    ,                           // KERNEL_CONFIG
    {0xBC94, 0x0C, 0, 0, 0}
    ,                           // LL_GB_START_THRESHOLD_0
    {0xBC95, 0x08, 0, 0, 0}
    ,                           // LL_GB_START_THRESHOLD_1
    {0xBC9C, 0x3C, 0, 0, 0}
    ,                           // LL_GB_END_THRESHOLD_0
    {0xBC9D, 0x28, 0, 0, 0}
    ,                           // LL_GB_END_THRESHOLD_1
    {0x33B0, 0x2A16, 1, 0, 0}
    ,                           // FFNR_ALPHA_BETA
    {0xBC8A, 0x02, 0, 0, 0}
    ,                           // LL_START_FF_MIX_THRESH_Y
    {0xBC8B, 0x0F, 0, 0, 0}
    ,                           // LL_END_FF_MIX_THRESH_Y
    {0xBC8C, 0xFF, 0, 0, 0}
    ,                           // LL_START_FF_MIX_THRESH_YGAIN
    {0xBC8D, 0xFF, 0, 0, 0}
    ,                           // LL_END_FF_MIX_THRESH_YGAIN
    {0xBC8E, 0xFF, 0, 0, 0}
    ,                           // LL_START_FF_MIX_THRESH_GAIN
    {0xBC8F, 0x00, 0, 0, 0}
    ,                           // LL_END_FF_MIX_THRESH_GAIN
    {0xBCB2, 0x20, 0, 0, 0}
    ,                           // LL_CDC_DARK_CLUS_SLOPE
    {0xBCB3, 0x3A, 0, 0, 0}
    ,                           // LL_CDC_DARK_CLUS_SATUR
    {0xBCB4, 0x39, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_LO_LIGHT_SLOPE
    {0xBCB7, 0x39, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_LO_LIGHT_SATUR
    {0xBCB5, 0x20, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_MID_LIGHT_SLOPE
    {0xBCB8, 0x3A, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_MID_LIGHT_SATUR
    {0xBCB6, 0x80, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_HI_LIGHT_SLOPE
    {0xBCB9, 0x24, 0, 0, 0}
    ,                           // LL_CDC_BRIGHT_CLUS_HI_LIGHT_SATUR
    {0xBCAA, 0x03E8, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_START_POS
    {0xBCAC, 0x012C, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_MID_POS
    {0xBCAE, 0x0009, 1, 0, 0}
    ,                           // LL_CDC_THR_ADJ_END_POS
    {0x33BA, 0x0084, 1, 0, 0}
    ,                           // APEDGE_CONTROL
    {0x33BE, 0x0000, 1, 0, 0}
    ,                           // UA_KNEE_L
    {0x33C2, 0x8800, 1, 0, 0}
    ,                           // UA_WEIGHTS
    {0xBC5E, 0x0154, 1, 0, 0}
    ,                           // LL_START_APERTURE_GAIN_BM
    {0xBC60, 0x0640, 1, 0, 0}
    ,                           // LL_END_APERTURE_GAIN_BM
    {0xBC62, 0x0E, 0, 0, 0}
    ,                           // LL_START_APERTURE_KPGAIN
    {0xBC63, 0x14, 0, 0, 0}
    ,                           // LL_END_APERTURE_KPGAIN
    {0xBC64, 0x0E, 0, 0, 0}
    ,                           // LL_START_APERTURE_KNGAIN
    {0xBC65, 0x14, 0, 0, 0}
    ,                           // LL_END_APERTURE_KNGAIN
    {0xBCE2, 0x0A, 0, 0, 0}
    ,                           // LL_START_POS_KNEE
    {0xBCE3, 0x2B, 0, 0, 0}
    ,                           // LL_END_POS_KNEE
    {0xBCE4, 0x0A, 0, 0, 0}
    ,                           // LL_START_NEG_KNEE
    {0xBCE5, 0x2B, 0, 0, 0}
    ,                           // LL_END_NEG_KNEE
    {0x3210, 0x49B8, 1, 0, 0}
    ,                           // COLOR_PIPELINE_CONTROL
    {0xBCC0, 0x1F, 0, 0, 0}
    ,                           // LL_SFFB_RAMP_START
    {0xBCC1, 0x03, 0, 0, 0}
    ,                           // LL_SFFB_RAMP_STOP
    {0xBCC2, 0x2C, 0, 0, 0}
    ,                           // LL_SFFB_SLOPE_START
    {0xBCC3, 0x10, 0, 0, 0}
    ,                           // LL_SFFB_SLOPE_STOP
    {0xBCC4, 0x07, 0, 0, 0}
    ,                           // LL_SFFB_THSTART
    {0xBCC5, 0x0B, 0, 0, 0}
    ,                           // LL_SFFB_THSTOP
    {0xBCBA, 0x0009, 1, 0, 0}
    ,                           // LL_SFFB_CONFIG
    {0x8404, 0x06, 0, 100, 0}
    ,                           // SEQ_CMD

    //Step7-CPIPE_Preference
//  {0x098E, 0x3C14 ,1, 0, 0},  // LOGICAL_ADDRESS_ACCESS [LL_GAMMA_FADE_TO_BLACK_START_POS]
    {0xBC14, 0xFFFE, 1, 0, 0}
    ,                           // LL_GAMMA_FADE_TO_BLACK_START_POS
    {0xBC16, 0xFFFE, 1, 0, 0}
    ,                           // LL_GAMMA_FADE_TO_BLACK_END_POS
    {0xBC66, 0x0154, 1, 0, 0}
    ,                           // LL_START_APERTURE_GM
    {0xBC68, 0x07D0, 1, 0, 0}
    ,                           // LL_END_APERTURE_GM
    {0xBC6A, 0x04, 0, 0, 0}
    ,                           // LL_START_APERTURE_INTEGER_GAIN
    {0xBC6B, 0x00, 0, 0, 0}
    ,                           // LL_END_APERTURE_INTEGER_GAIN
    {0xBC6C, 0x00, 0, 0, 0}
    ,                           // LL_START_APERTURE_EXP_GAIN
    {0xBC6D, 0x00, 0, 0, 0}
    ,                           // LL_END_APERTURE_EXP_GAIN
    {0xA81C, 0x0040, 1, 0, 0}
    ,                           // AE_TRACK_MIN_AGAIN
    {0xA820, 0x01FC, 1, 0, 0}
    ,                           // AE_TRACK_MAX_AGAIN
    {0xA822, 0x0080, 1, 0, 0}
    ,                           // AE_TRACK_MIN_DGAIN
    {0xA824, 0x0100, 1, 0, 0}
    ,                           // AE_TRACK_MAX_DGAIN
    {0xBC56, 0x64, 0, 0, 0}
    ,                           // LL_START_CCM_SATURATION
    {0xBC57, 0x1E, 0, 0, 0}
    ,                           // LL_END_CCM_SATURATION
    {0xBCDE, 0x03, 0, 0, 0}
    ,                           // LL_START_SYS_THRESHOLD
    {0xBCDF, 0x50, 0, 0, 0}
    ,                           // LL_STOP_SYS_THRESHOLD
    {0xBCE0, 0x08, 0, 0, 0}
    ,                           // LL_START_SYS_GAIN
    {0xBCE1, 0x03, 0, 0, 0}
    ,                           // LL_STOP_SYS_GAIN
    {0xBCD0, 0x000A, 1, 0, 0}
    ,                           // LL_SFFB_SOBEL_FLAT_START
    {0xBCD2, 0x00FE, 1, 0, 0}
    ,                           // LL_SFFB_SOBEL_FLAT_STOP
    {0xBCD4, 0x001E, 1, 0, 0}
    ,                           // LL_SFFB_SOBEL_SHARP_START
    {0xBCD6, 0x00FF, 1, 0, 0}
    ,                           // LL_SFFB_SOBEL_SHARP_STOP
    {0xBCC6, 0x00, 0, 0, 0}
    ,                           // LL_SFFB_SHARPENING_START
    {0xBCC7, 0x00, 0, 0, 0}
    ,                           // LL_SFFB_SHARPENING_STOP
    {0xBCC8, 0x20, 0, 0, 0}
    ,                           // LL_SFFB_FLATNESS_START
    {0xBCC9, 0x40, 0, 0, 0}
    ,                           // LL_SFFB_FLATNESS_STOP
    {0xBCCA, 0x04, 0, 0, 0}
    ,                           // LL_SFFB_TRANSITION_START
    {0xBCCB, 0x00, 0, 0, 0}
    ,                           // LL_SFFB_TRANSITION_STOP
    {0xBCE6, 0x03, 0, 0, 0}
    ,                           // LL_SFFB_ZERO_ENABLE
    {0xBCE6, 0x03, 0, 0, 0}
    ,                           // LL_SFFB_ZERO_ENABLE
    {0xA410, 0x04, 0, 0, 0}
    ,                           // AE_RULE_TARGET_AE_6
    {0xA411, 0x06, 0, 0, 0}
    ,                           // AE_RULE_TARGET_AE_7
    {0x8404, 0x06, 0, 100, 0}
    ,                           // SEQ_CMD

    //Step8-Features
//  {0x098E, 0xC8BC, 1, 0, 0}, // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_0_JPEG_QSCALE_0]
    {0xC8BC, 0x04, 0, 0, 0}
    ,                           // CAM_OUTPUT_0_JPEG_QSCALE_0
    {0xC8BD, 0x0A, 0, 0, 0}
    ,                           // CAM_OUTPUT_0_JPEG_QSCALE_1
    {0xC8D2, 0x04, 0, 0, 0}
    ,                           // CAM_OUTPUT_1_JPEG_QSCALE_0
    {0xC8D3, 0x0A, 0, 0, 0}
    ,                           // CAM_OUTPUT_1_JPEG_QSCALE_1
    {0xDC3A, 0x23, 0, 0, 0}
    ,                           // SYS_SEPIA_CR
    {0xDC3B, 0xB2, 0, 0, 0}
    ,                           // SYS_SEPIA_CB

    {0x0018, 0x2008, 1, 200, 0}
    ,                           // STANDBY_CONTROL_AND_STATUS

// Frame rate control
    {0xA818, 0x0795, 1, 0, 0}
    ,                           // AE_TRACK_TARGET_INT_TIME_ROWS
    {0xA81A, 0x0795, 1, 0, 0}
    ,                           // AE_TRACK_MAX_INT_TIME_ROWS

//50HZ
//  {0x098E, 0x8417 , 1, 0, 0}, // LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_1_FD]
//  {0x8417, 0x01   , 0, 0, 0},// SEQ_STATE_CFG_1_FD                           //VAR8=1
//  {0xA004, 0x32   , 0, 0, 0},// FD_EXPECTED_FLICKER_SOURCE_FREQUENCY         //VAR8=8

// Set the AE target
    {0xA409, 0x37, 0, 0, 0}
    ,                           // AE_RULE_BASE_TARGET

// Set the saturation
    {0x098E, 0xBC56, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS
    {0xBC56, 0xA0, 0, 0, 0}
    ,                           // LL_START_CCM_SATURATION
    {0xBC57, 0x32, 0, 0, 0}
    ,                           // LL_END_CCM_SATURATION
    {0x8404, 0x06, 0, 0, 0}
    ,                           //Refresh Sequencer Mode = 6

    //Preview
    {0x098E, 0x843C, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
    {0x843C, 0x01, 0, 0, 0}
    ,                           // SEQ_STATE_CFG_5_MAX_FRAME_CNT
    {0x8404, 0x01, 0, 0, 0}
    ,                           // SEQ_CMD
    {0x0016, 0x0447, 1, 0, 0}
    ,                           // CLOCKS_CONTROL
};

reg_param_t g_mt9p111_af_firmware[] = {
    {0x098E, 0xE001, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [IO_MODE]
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0084, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x0002, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0001, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00EB, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0010, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00A0, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0011, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x0065, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x000E, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x0070, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x000A, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00B4, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x000B, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x001F, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x000C, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x005E, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x000D, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x002F, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0002, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00A2, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0003, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00E5, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0005, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00C1, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0006, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00C1, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0000, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x00B6, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xE001, 0x00, 0, 0, 0}
    ,                           // IO_MODE
    {0xE007, 0x18, 0, 0, 0}
    ,                           // IO_I2C_DEVICE_ADDRESS
    {0xE008, 0x0001, 1, 0, 0}
    ,                           // IO_I2C_REGISTER
    {0xE00A, 0x006B, 1, 0, 0}
    ,                           // IO_I2C_WRITEDATA
    {0xE002, 0x0001, 1, 100, 0}
    ,                           // IO_ALGO
//  POLL  IO_ALGO::IO_DO_WRITE_I2C =>  0x01
    {0xB018, 0x01, 0, 0, 0}
    ,                           // AF_FS_POS_0
    {0xB019, 0x05, 0, 0, 0}
    ,                           // AF_FS_POS_1
    {0xB01A, 0x09, 0, 0, 0}
    ,                           // AF_FS_POS_2
    {0xB01B, 0x0D, 0, 0, 0}
    ,                           // AF_FS_POS_3
    {0xB01C, 0x11, 0, 0, 0}
    ,                           // AF_FS_POS_4
    {0xB01D, 0x15, 0, 0, 0}
    ,                           // AF_FS_POS_5
    {0xB01E, 0x1A, 0, 0, 0}
    ,                           // AF_FS_POS_6
    {0xB01F, 0x1F, 0, 0, 0}
    ,                           // AF_FS_POS_7
    {0xB020, 0x24, 0, 0, 0}
    ,                           // AF_FS_POS_8
    {0xB021, 0x29, 0, 0, 0}
    ,                           // AF_FS_POS_9
    {0xB012, 0x0A, 0, 0, 0}
    ,                           // AF_FS_NUM_STEPS
    {0xB022, 0x0E, 0, 0, 0}
    ,                           // AF_FS_POS_10
    {0xB023, 0x04, 0, 0, 0}
    ,                           // AF_FS_POS_11
    {0xB024, 0x04, 0, 0, 0}
    ,                           // AF_FS_POS_12
    {0xB025, 0x07, 0, 0, 0}
    ,                           // AF_FS_POS_13
    {0xB026, 0x07, 0, 0, 0}
    ,                           // AF_FS_POS_14
    {0xB027, 0x0A, 0, 0, 0}
    ,                           // AF_FS_POS_15
    {0xB028, 0x0A, 0, 0, 0}
    ,                           // AF_FS_POS_16
    {0xB029, 0x0E, 0, 0, 0}
    ,                           // AF_FS_POS_17
    {0xB02A, 0x0E, 0, 0, 0}
    ,                           // AF_FS_POS_18
    {0xB02B, 0x0E, 0, 0, 0}
    ,                           // AF_FS_POS_19
    {0xB02C, 0x05, 0, 0, 0}
    ,                           // AF_HC_STEP
    {0xB050, 0x01, 0, 0, 0}
    ,                           // AF_HYPER_FOCAL_POINT
    {0xC40E, 0x0000, 1, 0, 0}
    ,                           // AFM_CUST_CTRL
    {0xC409, 0x00, 0, 0, 0}
    ,                           // AFM_BACKLASH
    {0xB854, 0x55, 0, 0, 0}
    ,                           // STAT_SM_WINDOW_POS_X
    {0xB855, 0x5B, 0, 0, 0}
    ,                           // STAT_SM_WINDOW_POS_Y
    {0xB856, 0x58, 0, 0, 0}
    ,                           // STAT_SM_WINDOW_SIZE_X
    {0xB857, 0x4F, 0, 0, 0}
    ,                           // STAT_SM_WINDOW_SIZE_Y
    {0xB002, 0x0000, 1, 0, 0}
    ,                           // AF_MODE
    {0xC400, 0xC0, 0, 0, 0}
    ,                           // AFM_ALGO

    {0x8404, 0x05, 0, 200, 0}
    ,                           //Refresh Sequencer Mode = 6

// Full Scan
    {0x098E, 0x8419, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_1_AF]
    {0x8419, 0x05, 0, 300, 0}
    ,                           // SEQ_STATE_CFG_1_AF

    {0x8404, 0x06, 0, 0, 0}
    ,                           //Refresh Sequencer Mode = 6

    {0x8016, 0x086C, 1, 0, 0}
    ,                           // MON_ADDRESS_LO //william chen

    //Preview
    {0x098E, 0x843C, 1, 0, 0}
    ,                           // LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
    {0x843C, 0x01, 0, 0, 0}
    ,                           // SEQ_STATE_CFG_5_MAX_FRAME_CNT
    {0x8404, 0x01, 0, 0, 0}
    ,                           // SEQ_CMD
    {0x0016, 0x0447, 1, 0, 0}
    ,                           // CLOCKS_CONTROL
};

reg_param_t g_mt9p111_af_trigger[] = {
    {0x098E, 0x8419, 1, 0, 0}
    ,
    {0x8419, 0x03, 0, 500, 0}
    ,
    {0x8404, 0x06, 0, 500, 0}
};

reg_param_t g_mt9p111_af_ready[] = {
    {0xB000, 0x0000, 1, 0, 1}
    ,
};

camera_mode_t g_camera_modes[CAMERA_MODE_NUM] = {
    {g_ov3640_mode_vga_640_480_30fps, ARRAY_SIZE(g_ov3640_mode_vga_640_480_30fps)}
    ,
    {g_ov5640_mode_vga_640_480_30fps, ARRAY_SIZE(g_ov5640_mode_vga_640_480_30fps)}
    ,
    {g_ov5642_mode_vga_640_480_30fps, ARRAY_SIZE(g_ov5642_mode_vga_640_480_30fps)}
    ,
    {g_mt9p111_mode_vga_640_480_30fps, ARRAY_SIZE(g_mt9p111_mode_vga_640_480_30fps)}
    ,
};

camera_profile_t g_camera_profiles[SENSOR_NUM] = {
    {"OV3640",
     0x5F, 0x4C, 0x45,          //2.75v, 1.8v, 1.5v
     0x78,
     g_ov3640_sensor_detection,
     ARRAY_SIZE(g_ov3640_sensor_detection),
     OV3640_MODE_VGA_640_480_30FPS,
     g_camera_modes,
     0,
     (reg_param_t *) 0,
     0,
     (reg_param_t *) 0,
     0,
     (reg_param_t *) 0,
     0}
    , {
       "OV5640",
       0x5F, 0x4C, 0x45,        //2.75v, 1.8v, 1.5v
       0x78,
       g_ov5640_sensor_detection,
       ARRAY_SIZE(g_ov5640_sensor_detection),
       OV5640_MODE_VGA_640_480_30FPS,
       g_camera_modes,
       0,
       (reg_param_t *) 0,
       0,
       (reg_param_t *) 0,
       0,
       (reg_param_t *) 0,
       0}
    , {
       "OV5642",
       0x5F, 0x4C, 0x45,        //2.75v, 1.8v, 1.5v
       0x78,
       g_ov5642_sensor_detection,
       ARRAY_SIZE(g_ov5642_sensor_detection),
       OV5642_MODE_VGA_640_480_30FPS,
       g_camera_modes,
       0,
       g_ov5642_af_firmware,
       ARRAY_SIZE(g_ov5642_af_firmware),
       g_ov5642_af_trigger,
       ARRAY_SIZE(g_ov5642_af_trigger),
       g_ov5642_af_ready,
       ARRAY_SIZE(g_ov5642_af_ready)
       }
    , {
       "Aptina5410",
       0x5F, 0x4C, 0x4C,        //2.75v, 1.8v, 1.8v
       0x78,
       g_mt9p111_sensor_detection,
       ARRAY_SIZE(g_mt9p111_sensor_detection),
       MT9P111_MODE_VGA_640_480_30FPS,
       g_camera_modes,
       1,
       g_mt9p111_af_firmware,
       ARRAY_SIZE(g_mt9p111_af_firmware),
       g_mt9p111_af_trigger,
       ARRAY_SIZE(g_mt9p111_af_trigger),
       g_mt9p111_af_ready,
       ARRAY_SIZE(g_mt9p111_af_ready)
       }
};
