/*
 * Copyright (c) 2011-2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _CS42888_H_
#define _CS42888_H_

#include "audio/audio.h"

/////////////Registers////////////////////
#define CS42888_REG_CHIP_ID_REV		0x01
#define CS42888_REG_PWR_CTRL		0x02
#define CS42888_REG_FUNC_MODE		0x03
#define CS42888_REG_INF_FMT		0x04
#define CS42888_REG_ADC_CTRL_DeEM	0x05
#define CS42888_REG_TRANS_CTRL		0x06
#define CS42888_REG_DAC_MUTE		0x07
#define CS42888_REG_AOUT1_VOL_CTRL	0x08
#define CS42888_REG_AOUT2_VOL_CTRL	0x09
#define CS42888_REG_AOUT3_VOL_CTRL	0x0A
#define CS42888_REG_AOUT4_VOL_CTRL	0x0B
#define CS42888_REG_AOUT5_VOL_CTRL	0x0C
#define CS42888_REG_AOUT6_VOL_CTRL	0x0D
#define CS42888_REG_AOUT7_VOL_CTRL	0x0E
#define CS42888_REG_AOUT8_VOL_CTRL	0x0F
#define CS42888_REG_DAC_INV		0x10
#define CS42888_REG_AIN1_VOL_CTRL	0x11
#define CS42888_REG_AIN2_VOL_CTRL	0x12
#define CS42888_REG_AIN3_VOL_CTRL	0x13
#define CS42888_REG_AIN4_VOL_CTRL	0x14
#define CS42888_REG_ADC_INV		0x17
#define CS42888_REG_STATUS_CTRL		0x18
#define CS42888_REG_STATUS		0x19
#define CS42888_REG_STATUS_MSK		0x1A
#define CS42888_REG_MUTEC_PIN_CTRL	0x1B
#define CS42888_REG_MUTEC_POL_SEL	0x1C
#define CS42888_REG_MUTE_ACTIVE		0x1D

/////////////Bits description/////////////////
#define CS42888_REG_PWR_CTRL_BITS_POWERDONE_ALL	0xFF
#define CS42888_REG_PWR_CTRL_BITS_POWER_ALL	0x00
#define CS42888_REG_PWR_CTRL_BIT_PDN_ADC2_EN	(0x01 << 6)
#define CS42888_REG_PWR_CTRL_BIT_PDN_ADC1_EN	(0x01 << 5)
#define CS42888_REG_PWR_CTRL_BIT_PDN_DAC4_EN	(0x01 << 4)
#define CS42888_REG_PWR_CTRL_BIT_PDN_DAC3_EN	(0x01 << 3)
#define CS42888_REG_PWR_CTRL_BIT_PDN_DAC2_EN	(0x01 << 2)
#define CS42888_REG_PWR_CTRL_BIT_PDN_DAC1_EN	(0x01 << 1)
#define CS42888_REG_PWR_CTRL_BIT_PDN_EN		(0x01 << 0)

#define CS42888_REG_INF_FMT_BIT_FREEZE		(0x01 << 7)
#define CS42888_REG_INF_FMT_BIT_AUX_DIF_LEFT	(0x00 << 6)
#define CS42888_REG_INF_FMT_BIT_AUX_DIF_I2S	(0x01 << 6)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_MSK	(0x07 << 3)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_MSK	(0x07 << 0)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_LEFT_24BIT		(0x00 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_I2S_24BIT		(0x01 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_RIGHT_24BIT		(0x02 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_RIGHT_16BIT		(0x03 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_ONELINE1_20BIT		(0x04 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_ONELINE2_16BIT		(0x05 << 3)
#define CS42888_REG_INF_FMT_BITS_DAC_DIF_TDM_24BIT		(0x06 << 3)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_LEFT_24BIT		(0x00 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_I2S_24BIT		(0x01 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_RIGHT_24BIT		(0x02 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_RIGHT_16BIT		(0x03 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_ONELINE1_20BIT		(0x04 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_ONELINE2_16BIT		(0x05 << 0)
#define CS42888_REG_INF_FMT_BITS_ADC_DIF_TDM_24BIT		(0x06 << 0)

#define CS42888_REG_DAC_MUTE_BITS_MUTE_ALL			0xFF
#define CS42888_REG_DAC_MUTE_BITS_UNMUTE_ALL			0x00

#define CS42888_REG_FUNC_MODE_BITS_DAC_FM_MASTER_4_50K		(0x00 << 6)
#define CS42888_REG_FUNC_MODE_BITS_DAC_FM_MASTER_50_100K	(0x01 << 6)
#define CS42888_REG_FUNC_MODE_BITS_DAC_FM_MASTER_100_200K	(0x02 << 6)
#define CS42888_REG_FUNC_MODE_BITS_DAC_FM_SLAVE_AUTO		(0x03 << 6)
#define CS42888_REG_FUNC_MODE_BITS_ADC_FM_MASTER_4_50K		(0x00 << 4)
#define CS42888_REG_FUNC_MODE_BITS_ADC_FM_MASTER_50_100K	(0x01 << 4)
#define CS42888_REG_FUNC_MODE_BITS_ADC_FM_MASTER_100_200K	(0x02 << 4)
#define CS42888_REG_FUNC_MODE_BITS_ADC_FM_SLAVE_AUTO		(0x03 << 4)
#define CS42888_REG_FUNC_MODE_BITS_ADC_MCLK_256FS		(0x00 << 1)
#define CS42888_REG_FUNC_MODE_BITS_ADC_MCLK_384FS		(0x01 << 1)
#define CS42888_REG_FUNC_MODE_BITS_ADC_MCLK_512FS		(0x02 << 1)
#define CS42888_REG_FUNC_MODE_BITS_ADC_MCLK_768FS		(0x03 << 1)
#define CS42888_REG_FUNC_MODE_BITS_ADC_MCLK_1024FS		(0x04 << 1)

#define CS42888_REG_TRANS_CTRL_BITS_ALL_AUTO_MUTE_DISABLE	0x00

#define CS42888_PWRUP_UNMUTE_DELAY_US 	100000

#endif
