/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: usdhc2_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for usdhc2 module.
void usdhc2_iomux_config(void)
{
    // Config usdhc2.SD2_CD_B to pad SD2_DATA7(Y22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_WR(0x000170B0);
    // HW_IOMUXC_USDHC2_CARD_DET_SELECT_INPUT_WR(0x00000002);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7(0x020E0278)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA7
    //     ALT1 (1) - Select instance: usdhc3 signal: SD3_DATA7
    //     ALT2 (2) - Select instance: uart2 signal: UART2_CTS_B
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA09
    //     ALT4 (4) - Select instance: usdhc2 signal: SD2_CD_B
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO00
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA7_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7(0x020E0580)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_PUS_V(47K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA7_SRE_V(SLOW));
    // Pad SD2_DATA7 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_USDHC2_CARD_DET_SELECT_INPUT(0x020E0830)
    //   DAISY [1:0] - MUX Mode Select Field Reset: ECSPI1_SS0_ALT4
    //                 Selecting Pads Involved in Daisy Chain.
    //     ECSPI1_SS0_ALT4 (0) - Select signal usdhc2 SD2_CD_B as input from pad ECSPI1_SS0(ALT4).
    //     EPDC_GDSP_ALT6 (1) - Select signal usdhc2 SD2_CD_B as input from pad EPDC_GDSP(ALT6).
    //     SD2_DATA7_ALT4 (2) - Select signal usdhc2 SD2_CD_B as input from pad SD2_DATA7(ALT4).
    HW_IOMUXC_USDHC2_CARD_DET_SELECT_INPUT_WR(
            BF_IOMUXC_USDHC2_CARD_DET_SELECT_INPUT_DAISY_V(SD2_DATA7_ALT4));

    // Config usdhc2.SD2_CLK to pad SD2_CLK(AC24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_CLK(0x020E0254)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_CLK
    //     ALT1 (1) - Select instance: audmux signal: AUD4_RXFS
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SCLK
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA00
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO05
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_CLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_CLK(0x020E055C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CLK_SRE_V(SLOW));

    // Config usdhc2.SD2_CMD to pad SD2_CMD(AB24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_CMD(0x020E0258)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_CMD
    //     ALT1 (1) - Select instance: audmux signal: AUD4_RXC
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SS0
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA01
    //     ALT4 (4) - Select instance: epit1 signal: EPIT1_OUT
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO04
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_CMD_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_CMD(0x020E0560)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_CMD_SRE_V(SLOW));

    // Config usdhc2.SD2_DATA0 to pad SD2_DATA0(AB22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0(0x020E025C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA0
    //     ALT1 (1) - Select instance: audmux signal: AUD4_RXD
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_MOSI
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA02
    //     ALT4 (4) - Select instance: uart5 signal: UART5_RTS_B
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO01
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0(0x020E0564)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA0_SRE_V(SLOW));

    // Config usdhc2.SD2_DATA1 to pad SD2_DATA1(AB23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1(0x020E0260)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA1
    //     ALT1 (1) - Select instance: audmux signal: AUD4_TXC
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_MISO
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA03
    //     ALT4 (4) - Select instance: uart5 signal: UART5_CTS_B
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO30
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1(0x020E0568)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA1_SRE_V(SLOW));

    // Config usdhc2.SD2_DATA2 to pad SD2_DATA2(AA22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2(0x020E0264)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA2
    //     ALT1 (1) - Select instance: audmux signal: AUD4_TXFS
    //     ALT2 (2) - Select instance: fec signal: FEC_COL
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA04
    //     ALT4 (4) - Select instance: uart5 signal: UART5_RX_DATA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO03
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA2_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2(0x020E056C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA2_SRE_V(SLOW));

    // Config usdhc2.SD2_DATA3 to pad SD2_DATA3(AA23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3(0x020E0268)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA3
    //     ALT1 (1) - Select instance: audmux signal: AUD4_TXD
    //     ALT2 (2) - Select instance: fec signal: FEC_RX_CLK
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA05
    //     ALT4 (4) - Select instance: uart5 signal: UART5_TX_DATA
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA3_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3(0x020E0570)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA3_SRE_V(SLOW));

    // Config usdhc2.SD2_RESET to pad SD2_RESET(Y23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_RESET(0x020E027C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_RESET
    //     ALT1 (1) - Select instance: fec signal: FEC_REF_OUT
    //     ALT2 (2) - Select instance: wdog2 signal: WDOG2_B
    //     ALT3 (3) - Select instance: spdif signal: SPDIF_OUT
    //     ALT4 (4) - Select instance: csi signal: CSI_MCLK
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO27
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_RESET_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_RESET(0x020E0584)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_RESET_SRE_V(SLOW));

    // Config usdhc2.SD2_WP to pad SD2_DATA6(Y21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_WR(0x000170B0);
    // HW_IOMUXC_USDHC2_WP_ON_SELECT_INPUT_WR(0x00000002);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6(0x020E0274)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usdhc2 signal: SD2_DATA6
    //     ALT1 (1) - Select instance: usdhc3 signal: SD3_DATA6
    //     ALT2 (2) - Select instance: uart2 signal: UART2_RTS_B
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA08
    //     ALT4 (4) - Select instance: usdhc2 signal: SD2_WP
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO29
    HW_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_SD2_DATA6_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6(0x020E057C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_PUS_V(47K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_SD2_DATA6_SRE_V(SLOW));
    // Pad SD2_DATA6 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_USDHC2_WP_ON_SELECT_INPUT(0x020E0834)
    //   DAISY [1:0] - MUX Mode Select Field Reset: ECSPI1_MISO_ALT4
    //                 Selecting Pads Involved in Daisy Chain.
    //     ECSPI1_MISO_ALT4 (0) - Select signal usdhc2 SD2_WP as input from pad ECSPI1_MISO(ALT4).
    //     EPDC_GDRL_ALT6 (1) - Select signal usdhc2 SD2_WP as input from pad EPDC_GDRL(ALT6).
    //     SD2_DATA6_ALT4 (2) - Select signal usdhc2 SD2_WP as input from pad SD2_DATA6(ALT4).
    HW_IOMUXC_USDHC2_WP_ON_SELECT_INPUT_WR(
            BF_IOMUXC_USDHC2_WP_ON_SELECT_INPUT_DAISY_V(SD2_DATA6_ALT4));
}
