/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: spdc_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for spdc module.
void spdc_iomux_config(void)
{
    // Config spdc.SPDC_CL to pad EPDC_SDCLK(B10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK(0x020E0110)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCLK_P
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT2 (2) - Select instance: i2c2 signal: I2C2_SCL
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA08
    //     ALT4 (4) - Select instance: spdc signal: SPDC_CL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO23
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK(0x020E0400)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_SRE_V(SLOW));

    // Config spdc.SPDC_DATA00 to pad EPDC_DATA00(A18)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00(0x020E0090)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA00
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_MOSI
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA24
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA00
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA00
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO07
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00(0x020E0380)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_SRE_V(SLOW));

    // Config spdc.SPDC_DATA01 to pad EPDC_DATA01(A17)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01(0x020E0094)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA01
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_MISO
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA25
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA01
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA01
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO08
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01(0x020E0384)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_SRE_V(SLOW));

    // Config spdc.SPDC_DATA02 to pad EPDC_DATA02(B17)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02(0x020E00B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA02
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS0
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA26
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA02
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA02
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO09
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02(0x020E03A0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_SRE_V(SLOW));

    // Config spdc.SPDC_DATA03 to pad EPDC_DATA03(A16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03(0x020E00B4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA03
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SCLK
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA27
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA03
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA03
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO10
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03(0x020E03A4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_SRE_V(SLOW));

    // Config spdc.SPDC_DATA04 to pad EPDC_DATA04(B16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04(0x020E00B8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA04
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS1
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA28
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA04
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA04
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO11
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04(0x020E03A8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_SRE_V(SLOW));

    // Config spdc.SPDC_DATA05 to pad EPDC_DATA05(A15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05(0x020E00BC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA05
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS2
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA29
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA05
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA05
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO12
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05(0x020E03AC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_SRE_V(SLOW));

    // Config spdc.SPDC_DATA06 to pad EPDC_DATA06(B15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06(0x020E00C0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA06
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS3
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA30
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA06
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA06
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO13
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06(0x020E03B0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_SRE_V(SLOW));

    // Config spdc.SPDC_DATA07 to pad EPDC_DATA07(C15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07(0x020E00C4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA07
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_RDY
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA31
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA07
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA07
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO14
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07(0x020E03B4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_SRE_V(SLOW));

    // Config spdc.SPDC_LD to pad EPDC_SDLE(B8)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE(0x020E0114)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDLE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_MISO
    //     ALT2 (2) - Select instance: i2c2 signal: I2C2_SDA
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA09
    //     ALT4 (4) - Select instance: spdc signal: SPDC_LD
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO24
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE(0x020E0404)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_SRE_V(SLOW));

    // Config spdc.SPDC_XDIOL to pad EPDC_SDOE(E7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE(0x020E0118)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDOE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS0
    //     ALT2 (2) - Select instance: spdc signal: SPDC_XDIOR
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA10
    //     ALT4 (4) - Select instance: spdc signal: SPDC_XDIOL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE(0x020E0408)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_SRE_V(SLOW));

    // Config spdc.SPDC_YCKL to pad EPDC_GDCLK(A12)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK(0x020E00D0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDCLK
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS2
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YCKR
    //     ALT3 (3) - Select instance: csi signal: CSI_PIXCLK
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YCKL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO31
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_RESET
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK(0x020E03C0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_SRE_V(SLOW));

    // Config spdc.SPDC_YDIODL to pad EPDC_GDSP(A11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP(0x020E00DC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDSP
    //     ALT1 (1) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YDIODR
    //     ALT3 (3) - Select instance: csi signal: CSI_VSYNC
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIODL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO02
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_CD_B
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP(0x020E03CC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_SRE_V(SLOW));

    // Config spdc.SPDC_YDIOUL to pad EPDC_GDRL(B12)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL(0x020E00D8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDRL
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_RDY
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YDIOUR
    //     ALT3 (3) - Select instance: csi signal: CSI_MCLK
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIOUL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO01
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL(0x020E03C8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_SRE_V(SLOW));

    // Config spdc.SPDC_YOEL to pad EPDC_GDOE(B13)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE(0x020E00D4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDOE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS3
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YOER
    //     ALT3 (3) - Select instance: csi signal: CSI_HSYNC
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YOEL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO00
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_VSELECT
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE(0x020E03C4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_SRE_V(SLOW));

    // Config spdc.SPDC_YOER to pad EPDC_SDCE1(A10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_WR(0x00000004);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1(0x020E0104)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCE1
    //     ALT1 (1) - Select instance: wdog2 signal: WDOG2_B
    //     ALT2 (2) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT3 (3) - Select instance: eim signal: EIM_LBA
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YOER
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_MUX_MODE_V(ALT4));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1(0x020E03F4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_SRE_V(SLOW));
}
