/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: mmdc_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for mmdc module.
void mmdc_iomux_config(void)
{
    // Config mmdc.DRAM_ADDR00 to pad DRAM_ADDR00(U4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00(0x020E02C0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR01 to pad DRAM_ADDR01(U5)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01(0x020E02C4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR02 to pad DRAM_ADDR02(T3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02(0x020E02E0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR03 to pad DRAM_ADDR03(T4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03(0x020E02E4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR04 to pad DRAM_ADDR04(N4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04(0x020E02E8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR05 to pad DRAM_ADDR05(M3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05(0x020E02EC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR06 to pad DRAM_ADDR06(M4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06(0x020E02F0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR07 to pad DRAM_ADDR07(H4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07(0x020E02F4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR08 to pad DRAM_ADDR08(J3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08(0x020E02F8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR09 to pad DRAM_ADDR09(J4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09(0x020E02FC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR10 to pad DRAM_ADDR10(J2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10(0x020E02C8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR11 to pad DRAM_ADDR11(T2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11(0x020E02CC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR12 to pad DRAM_ADDR12(U2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12(0x020E02D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR13 to pad DRAM_ADDR13(H5)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13(0x020E02D4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR14 to pad DRAM_ADDR14(R2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14(0x020E02D8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR15 to pad DRAM_ADDR15(K2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15(0x020E02DC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CAS to pad DRAM_CAS(P1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS(0x020E0300)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CS0 to pad DRAM_CS0(N2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0(0x020E0304)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CS1 to pad DRAM_CS1(L2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1(0x020E0308)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA00 to pad DRAM_DATA00(AC2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA01 to pad DRAM_DATA01(AC1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA02 to pad DRAM_DATA02(AB2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA03 to pad DRAM_DATA03(AB1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA04 to pad DRAM_DATA04(AA3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA05 to pad DRAM_DATA05(Y3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA06 to pad DRAM_DATA06(Y1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA07 to pad DRAM_DATA07(Y2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E05C4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA08 to pad DRAM_DATA08(E2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA09 to pad DRAM_DATA09(E1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA10 to pad DRAM_DATA10(E3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA11 to pad DRAM_DATA11(D3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA12 to pad DRAM_DATA12(C1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA13 to pad DRAM_DATA13(C2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA14 to pad DRAM_DATA14(B1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA15 to pad DRAM_DATA15(B2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E05CC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA16 to pad DRAM_DATA16(AD8)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA17 to pad DRAM_DATA17(AC7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA18 to pad DRAM_DATA18(AD6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA19 to pad DRAM_DATA19(AC6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA20 to pad DRAM_DATA20(AD5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA21 to pad DRAM_DATA21(AC5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA22 to pad DRAM_DATA22(AC4)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA23 to pad DRAM_DATA23(AD3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E05D4)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA24 to pad DRAM_DATA24(A3)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA25 to pad DRAM_DATA25(B4)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA26 to pad DRAM_DATA26(B5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA27 to pad DRAM_DATA27(A5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA28 to pad DRAM_DATA28(B6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA29 to pad DRAM_DATA29(A6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA30 to pad DRAM_DATA30(B7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA31 to pad DRAM_DATA31(A8)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E05C0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E05D8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DQM0 to pad DRAM_DQM0(V2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0(0x020E030C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM1 to pad DRAM_DQM1(G2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1(0x020E0310)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM2 to pad DRAM_DQM2(AB3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2(0x020E0314)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM3 to pad DRAM_DQM3(C3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3(0x020E0318)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ODT0 to pad DRAM_ODT0(Y4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_WR(0x00003030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0(0x020E033C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ODT1 to pad DRAM_ODT1(E4)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_WR(0x00003030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1(0x020E0340)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_RAS to pad DRAM_RAS(N1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS(0x020E031C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_RESET to pad DRAM_RESET(D6)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_WR(0x00083030);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET(0x020E0320)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DDR_SEL_V(LPDDR2) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DSE_V(40_OHM));

    // Config mmdc.DRAM_SDBA0 to pad DRAM_SDBA0(J1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0(0x020E0324)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDBA1 to pad DRAM_SDBA1(T1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1(0x020E0328)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E05AC)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDBA2 to pad DRAM_SDBA2(H1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_WR(0x0000B000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2(0x020E032C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCKE0 to pad DRAM_SDCKE0(P2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_WR(0x00003000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0(0x020E0330)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCKE1 to pad DRAM_SDCKE1(M2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_WR(0x00003000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1(0x020E0334)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCLK0_P to pad DRAM_SDCLK0_P(L1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P(0x020E0338)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS0_P to pad DRAM_SDQS0_P(W2)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P(0x020E0344)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E05B0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS1_P to pad DRAM_SDQS1_P(F1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P(0x020E0348)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E05B0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS2_P to pad DRAM_SDQS2_P(AC3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P(0x020E034C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E05B0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS3_P to pad DRAM_SDQS3_P(B3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P(0x020E0350)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E05B0)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDWE to pad DRAM_SDWE(U1)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE(0x020E0354)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED5 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     17_OHM (7) - 17 Ohm ODT
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E05B4)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E05B8)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E05C8)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E05D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
}
