/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: lcd_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for lcd module.
void lcd_iomux_config(void)
{
    // Config lcd.LCD_CLK to pad LCD_CLK(T22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_CLK(0x020E01AC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_CLK
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA4
    //     ALT2 (2) - Select instance: lcd signal: LCD_WR_RWN
    //     ALT3 (3) - Select instance: eim signal: EIM_RW
    //     ALT4 (4) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO15
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_CLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_CLK(0x020E04B4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_CLK_SRE_V(SLOW));

    // Config lcd.LCD_DATA00 to pad LCD_DATA00(Y24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA00_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00(0x020E01B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA00
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_MOSI
    //     ALT2 (2) - Select instance: usb signal: USB_OTG2_ID
    //     ALT3 (3) - Select instance: pwm1 signal: PWM1_OUT
    //     ALT4 (4) - Select instance: uart5 signal: UART5_DTR_B
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO20
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE00
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG00
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA00_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00(0x020E04B8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA00_SRE_V(SLOW));
    // Pad LCD_DATA00 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA00_SELECT_INPUT(0x020E0778)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL0_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL0_ALT2 (0) - Select signal lcd LCD_DATA00 as input from pad KEY_COL0(ALT2).
    //     LCD_DATA00_ALT0 (1) - Select signal lcd LCD_DATA00 as input from pad LCD_DATA00(ALT0).
    HW_IOMUXC_LCD_DATA00_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA00_SELECT_INPUT_DAISY_V(LCD_DATA00_ALT0));

    // Config lcd.LCD_DATA01 to pad LCD_DATA01(W23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA01_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01(0x020E01B4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA01
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_MISO
    //     ALT2 (2) - Select instance: usb signal: USB_OTG1_ID
    //     ALT3 (3) - Select instance: pwm2 signal: PWM2_OUT
    //     ALT4 (4) - Select instance: audmux signal: AUD4_RXFS
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO21
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE01
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG01
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA01_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01(0x020E04BC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA01_SRE_V(SLOW));
    // Pad LCD_DATA01 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA01_SELECT_INPUT(0x020E077C)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW0_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW0_ALT2 (0) - Select signal lcd LCD_DATA01 as input from pad KEY_ROW0(ALT2).
    //     LCD_DATA01_ALT0 (1) - Select signal lcd LCD_DATA01 as input from pad LCD_DATA01(ALT0).
    HW_IOMUXC_LCD_DATA01_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA01_SELECT_INPUT_DAISY_V(LCD_DATA01_ALT0));

    // Config lcd.LCD_DATA02 to pad LCD_DATA02(W24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA02_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02(0x020E01E0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA02
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_SS0
    //     ALT2 (2) - Select instance: epit2 signal: EPIT2_OUT
    //     ALT3 (3) - Select instance: pwm3 signal: PWM3_OUT
    //     ALT4 (4) - Select instance: audmux signal: AUD4_RXC
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO22
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE02
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG02
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA02_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02(0x020E04E8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA02_SRE_V(SLOW));
    // Pad LCD_DATA02 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA02_SELECT_INPUT(0x020E0780)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL1_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL1_ALT2 (0) - Select signal lcd LCD_DATA02 as input from pad KEY_COL1(ALT2).
    //     LCD_DATA02_ALT0 (1) - Select signal lcd LCD_DATA02 as input from pad LCD_DATA02(ALT0).
    HW_IOMUXC_LCD_DATA02_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA02_SELECT_INPUT_DAISY_V(LCD_DATA02_ALT0));

    // Config lcd.LCD_DATA03 to pad LCD_DATA03(V23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA03_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03(0x020E01F4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA03
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_SCLK
    //     ALT2 (2) - Select instance: uart5 signal: UART5_DSR_B
    //     ALT3 (3) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT4 (4) - Select instance: audmux signal: AUD4_RXD
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO23
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE03
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG03
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA03_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03(0x020E04FC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA03_SRE_V(SLOW));
    // Pad LCD_DATA03 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA03_SELECT_INPUT(0x020E0784)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW1_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW1_ALT2 (0) - Select signal lcd LCD_DATA03 as input from pad KEY_ROW1(ALT2).
    //     LCD_DATA03_ALT0 (1) - Select signal lcd LCD_DATA03 as input from pad LCD_DATA03(ALT0).
    HW_IOMUXC_LCD_DATA03_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA03_SELECT_INPUT_DAISY_V(LCD_DATA03_ALT0));

    // Config lcd.LCD_DATA04 to pad LCD_DATA04(V24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA04_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04(0x020E01F8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA04
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_SS1
    //     ALT2 (2) - Select instance: csi signal: CSI_VSYNC
    //     ALT3 (3) - Select instance: wdog2 signal: WDOG2_RESET_B_DEB
    //     ALT4 (4) - Select instance: audmux signal: AUD4_TXC
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO24
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE04
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG04
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA04_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04(0x020E0500)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA04_SRE_V(SLOW));
    // Pad LCD_DATA04 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA04_SELECT_INPUT(0x020E0788)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL2_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL2_ALT2 (0) - Select signal lcd LCD_DATA04 as input from pad KEY_COL2(ALT2).
    //     LCD_DATA04_ALT0 (1) - Select signal lcd LCD_DATA04 as input from pad LCD_DATA04(ALT0).
    HW_IOMUXC_LCD_DATA04_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA04_SELECT_INPUT_DAISY_V(LCD_DATA04_ALT0));

    // Config lcd.LCD_DATA05 to pad LCD_DATA05(U21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA05_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05(0x020E01FC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA05
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_SS2
    //     ALT2 (2) - Select instance: csi signal: CSI_HSYNC
    //     ALT3 (3) - Select instance: eim signal: EIM_CS3
    //     ALT4 (4) - Select instance: audmux signal: AUD4_TXFS
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO25
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE05
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG05
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA05_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05(0x020E0504)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA05_SRE_V(SLOW));
    // Pad LCD_DATA05 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA05_SELECT_INPUT(0x020E078C)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW2_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW2_ALT2 (0) - Select signal lcd LCD_DATA05 as input from pad KEY_ROW2(ALT2).
    //     LCD_DATA05_ALT0 (1) - Select signal lcd LCD_DATA05 as input from pad LCD_DATA05(ALT0).
    HW_IOMUXC_LCD_DATA05_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA05_SELECT_INPUT_DAISY_V(LCD_DATA05_ALT0));

    // Config lcd.LCD_DATA06 to pad LCD_DATA06(U23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA06_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06(0x020E0200)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA06
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_SS3
    //     ALT2 (2) - Select instance: csi signal: CSI_PIXCLK
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA00
    //     ALT4 (4) - Select instance: audmux signal: AUD4_TXD
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO26
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE06
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG06
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA06_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06(0x020E0508)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA06_SRE_V(SLOW));
    // Pad LCD_DATA06 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA06_SELECT_INPUT(0x020E0790)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL3_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL3_ALT2 (0) - Select signal lcd LCD_DATA06 as input from pad KEY_COL3(ALT2).
    //     LCD_DATA06_ALT0 (1) - Select signal lcd LCD_DATA06 as input from pad LCD_DATA06(ALT0).
    HW_IOMUXC_LCD_DATA06_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA06_SELECT_INPUT_DAISY_V(LCD_DATA06_ALT0));

    // Config lcd.LCD_DATA07 to pad LCD_DATA07(U24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA07_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07(0x020E0204)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA07
    //     ALT1 (1) - Select instance: ecspi1 signal: ECSPI1_RDY
    //     ALT2 (2) - Select instance: csi signal: CSI_MCLK
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA01
    //     ALT4 (4) - Select instance: audmux signal: AUDIO_CLK_OUT
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO27
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE07
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG07
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA07_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07(0x020E050C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA07_SRE_V(SLOW));
    // Pad LCD_DATA07 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA07_SELECT_INPUT(0x020E0794)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW3_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW3_ALT2 (0) - Select signal lcd LCD_DATA07 as input from pad KEY_ROW3(ALT2).
    //     LCD_DATA07_ALT0 (1) - Select signal lcd LCD_DATA07 as input from pad LCD_DATA07(ALT0).
    HW_IOMUXC_LCD_DATA07_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA07_SELECT_INPUT_DAISY_V(LCD_DATA07_ALT0));

    // Config lcd.LCD_DATA08 to pad LCD_DATA08(T23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA08_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08(0x020E0208)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA08
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL0
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA09
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA02
    //     ALT4 (4) - Select instance: ecspi2 signal: ECSPI2_SCLK
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO28
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE08
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG08
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA08_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08(0x020E0510)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA08_SRE_V(SLOW));
    // Pad LCD_DATA08 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA08_SELECT_INPUT(0x020E0798)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL4_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL4_ALT2 (0) - Select signal lcd LCD_DATA08 as input from pad KEY_COL4(ALT2).
    //     LCD_DATA08_ALT0 (1) - Select signal lcd LCD_DATA08 as input from pad LCD_DATA08(ALT0).
    HW_IOMUXC_LCD_DATA08_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA08_SELECT_INPUT_DAISY_V(LCD_DATA08_ALT0));

    // Config lcd.LCD_DATA09 to pad LCD_DATA09(T24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA09_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09(0x020E020C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA09
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW0
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA08
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA03
    //     ALT4 (4) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO29
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE09
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG09
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA09_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09(0x020E0514)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA09_SRE_V(SLOW));
    // Pad LCD_DATA09 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA09_SELECT_INPUT(0x020E079C)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW4_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW4_ALT2 (0) - Select signal lcd LCD_DATA09 as input from pad KEY_ROW4(ALT2).
    //     LCD_DATA09_ALT0 (1) - Select signal lcd LCD_DATA09 as input from pad LCD_DATA09(ALT0).
    HW_IOMUXC_LCD_DATA09_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA09_SELECT_INPUT_DAISY_V(LCD_DATA09_ALT0));

    // Config lcd.LCD_DATA10 to pad LCD_DATA10(R23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA10_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10(0x020E01B8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA10
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL1
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA07
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA04
    //     ALT4 (4) - Select instance: ecspi2 signal: ECSPI2_MISO
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO30
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE10
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG10
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA10_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10(0x020E04C0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA10_SRE_V(SLOW));
    // Pad LCD_DATA10 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA10_SELECT_INPUT(0x020E07A0)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL5_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL5_ALT2 (0) - Select signal lcd LCD_DATA10 as input from pad KEY_COL5(ALT2).
    //     LCD_DATA10_ALT0 (1) - Select signal lcd LCD_DATA10 as input from pad LCD_DATA10(ALT0).
    HW_IOMUXC_LCD_DATA10_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA10_SELECT_INPUT_DAISY_V(LCD_DATA10_ALT0));

    // Config lcd.LCD_DATA11 to pad LCD_DATA11(R24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA11_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11(0x020E01BC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA11
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW1
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA06
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA05
    //     ALT4 (4) - Select instance: ecspi2 signal: ECSPI2_SS1
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO31
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE11
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG11
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA11_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11(0x020E04C4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA11_SRE_V(SLOW));
    // Pad LCD_DATA11 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA11_SELECT_INPUT(0x020E07A4)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW5_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW5_ALT2 (0) - Select signal lcd LCD_DATA11 as input from pad KEY_ROW5(ALT2).
    //     LCD_DATA11_ALT0 (1) - Select signal lcd LCD_DATA11 as input from pad LCD_DATA11(ALT0).
    HW_IOMUXC_LCD_DATA11_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA11_SELECT_INPUT_DAISY_V(LCD_DATA11_ALT0));

    // Config lcd.LCD_DATA12 to pad LCD_DATA12(P23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA12_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12(0x020E01C0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA12
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL2
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA05
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA06
    //     ALT4 (4) - Select instance: uart5 signal: UART5_RTS_B
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO00
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE12
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG12
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA12_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12(0x020E04C8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA12_SRE_V(SLOW));
    // Pad LCD_DATA12 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA12_SELECT_INPUT(0x020E07A8)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL6_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL6_ALT2 (0) - Select signal lcd LCD_DATA12 as input from pad KEY_COL6(ALT2).
    //     LCD_DATA12_ALT0 (1) - Select signal lcd LCD_DATA12 as input from pad LCD_DATA12(ALT0).
    HW_IOMUXC_LCD_DATA12_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA12_SELECT_INPUT_DAISY_V(LCD_DATA12_ALT0));

    // Config lcd.LCD_DATA13 to pad LCD_DATA13(P24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA13_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13(0x020E01C4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA13
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW2
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA04
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA07
    //     ALT4 (4) - Select instance: uart5 signal: UART5_CTS_B
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO01
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE13
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG13
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA13_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13(0x020E04CC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA13_SRE_V(SLOW));
    // Pad LCD_DATA13 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA13_SELECT_INPUT(0x020E07AC)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW6_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW6_ALT2 (0) - Select signal lcd LCD_DATA13 as input from pad KEY_ROW6(ALT2).
    //     LCD_DATA13_ALT0 (1) - Select signal lcd LCD_DATA13 as input from pad LCD_DATA13(ALT0).
    HW_IOMUXC_LCD_DATA13_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA13_SELECT_INPUT_DAISY_V(LCD_DATA13_ALT0));

    // Config lcd.LCD_DATA14 to pad LCD_DATA14(N21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA14_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14(0x020E01C8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA14
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL3
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA03
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA08
    //     ALT4 (4) - Select instance: uart5 signal: UART5_RX_DATA
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO02
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE14
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG14
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA14_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14(0x020E04D0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA14_SRE_V(SLOW));
    // Pad LCD_DATA14 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA14_SELECT_INPUT(0x020E07B0)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL7_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL7_ALT2 (0) - Select signal lcd LCD_DATA14 as input from pad KEY_COL7(ALT2).
    //     LCD_DATA14_ALT0 (1) - Select signal lcd LCD_DATA14 as input from pad LCD_DATA14(ALT0).
    HW_IOMUXC_LCD_DATA14_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA14_SELECT_INPUT_DAISY_V(LCD_DATA14_ALT0));

    // Config lcd.LCD_DATA15 to pad LCD_DATA15(N23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA15_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15(0x020E01CC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA15
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW3
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA02
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA09
    //     ALT4 (4) - Select instance: uart5 signal: UART5_TX_DATA
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO03
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE15
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG15
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA15_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15(0x020E04D4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA15_SRE_V(SLOW));
    // Pad LCD_DATA15 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA15_SELECT_INPUT(0x020E07B4)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_ROW7_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_ROW7_ALT2 (0) - Select signal lcd LCD_DATA15 as input from pad KEY_ROW7(ALT2).
    //     LCD_DATA15_ALT0 (1) - Select signal lcd LCD_DATA15 as input from pad LCD_DATA15(ALT0).
    HW_IOMUXC_LCD_DATA15_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA15_SELECT_INPUT_DAISY_V(LCD_DATA15_ALT0));

    // Config lcd.LCD_DATA16 to pad LCD_DATA16(N24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA16_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16(0x020E01D0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA16
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL4
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA01
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA10
    //     ALT4 (4) - Select instance: i2c2 signal: I2C2_SCL
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO04
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE16
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG24
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA16_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16(0x020E04D8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA16_SRE_V(SLOW));
    // Pad LCD_DATA16 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA16_SELECT_INPUT(0x020E07B8)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_CTRL0_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_CTRL0_ALT2 (0) - Select signal lcd LCD_DATA16 as input from pad EPDC_PWR_CTRL0(ALT2).
    //     LCD_DATA16_ALT0 (1) - Select signal lcd LCD_DATA16 as input from pad LCD_DATA16(ALT0).
    HW_IOMUXC_LCD_DATA16_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA16_SELECT_INPUT_DAISY_V(LCD_DATA16_ALT0));

    // Config lcd.LCD_DATA17 to pad LCD_DATA17(M22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA17_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17(0x020E01D4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA17
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW4
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA00
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA11
    //     ALT4 (4) - Select instance: i2c2 signal: I2C2_SDA
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO05
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE17
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG25
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA17_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17(0x020E04DC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA17_SRE_V(SLOW));
    // Pad LCD_DATA17 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA17_SELECT_INPUT(0x020E07BC)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_CTRL1_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_CTRL1_ALT2 (0) - Select signal lcd LCD_DATA17 as input from pad EPDC_PWR_CTRL1(ALT2).
    //     LCD_DATA17_ALT0 (1) - Select signal lcd LCD_DATA17 as input from pad LCD_DATA17(ALT0).
    HW_IOMUXC_LCD_DATA17_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA17_SELECT_INPUT_DAISY_V(LCD_DATA17_ALT0));

    // Config lcd.LCD_DATA18 to pad LCD_DATA18(M23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA18_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18(0x020E01D8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA18
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL5
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA15
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA12
    //     ALT4 (4) - Select instance: gpt signal: GPT_CAPTURE1
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO06
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE18
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG26
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA18_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18(0x020E04E0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA18_SRE_V(SLOW));
    // Pad LCD_DATA18 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA18_SELECT_INPUT(0x020E07C0)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_CTRL2_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_CTRL2_ALT2 (0) - Select signal lcd LCD_DATA18 as input from pad EPDC_PWR_CTRL2(ALT2).
    //     LCD_DATA18_ALT0 (1) - Select signal lcd LCD_DATA18 as input from pad LCD_DATA18(ALT0).
    HW_IOMUXC_LCD_DATA18_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA18_SELECT_INPUT_DAISY_V(LCD_DATA18_ALT0));

    // Config lcd.LCD_DATA19 to pad LCD_DATA19(M24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA19_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19(0x020E01DC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA19
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW5
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA14
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA13
    //     ALT4 (4) - Select instance: gpt signal: GPT_CAPTURE2
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO07
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE19
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG27
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA19_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19(0x020E04E4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA19_SRE_V(SLOW));
    // Pad LCD_DATA19 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA19_SELECT_INPUT(0x020E07C4)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_CTRL3_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_CTRL3_ALT2 (0) - Select signal lcd LCD_DATA19 as input from pad EPDC_PWR_CTRL3(ALT2).
    //     LCD_DATA19_ALT0 (1) - Select signal lcd LCD_DATA19 as input from pad LCD_DATA19(ALT0).
    HW_IOMUXC_LCD_DATA19_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA19_SELECT_INPUT_DAISY_V(LCD_DATA19_ALT0));

    // Config lcd.LCD_DATA20 to pad LCD_DATA20(L23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA20_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20(0x020E01E4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA20
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL6
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA13
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA14
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE1
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO08
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE20
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG28
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA20_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20(0x020E04EC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA20_SRE_V(SLOW));
    // Pad LCD_DATA20 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA20_SELECT_INPUT(0x020E07C8)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_COM_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_COM_ALT2 (0) - Select signal lcd LCD_DATA20 as input from pad EPDC_PWR_COM(ALT2).
    //     LCD_DATA20_ALT0 (1) - Select signal lcd LCD_DATA20 as input from pad LCD_DATA20(ALT0).
    HW_IOMUXC_LCD_DATA20_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA20_SELECT_INPUT_DAISY_V(LCD_DATA20_ALT0));

    // Config lcd.LCD_DATA21 to pad LCD_DATA21(L24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA21_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21(0x020E01E8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA21
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW6
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA12
    //     ALT3 (3) - Select instance: eim signal: EIM_DATA15
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE2
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO09
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE21
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG29
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA21_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21(0x020E04F0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA21_SRE_V(SLOW));
    // Pad LCD_DATA21 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA21_SELECT_INPUT(0x020E07CC)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_IRQ_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_IRQ_ALT2 (0) - Select signal lcd LCD_DATA21 as input from pad EPDC_PWR_IRQ(ALT2).
    //     LCD_DATA21_ALT0 (1) - Select signal lcd LCD_DATA21 as input from pad LCD_DATA21(ALT0).
    HW_IOMUXC_LCD_DATA21_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA21_SELECT_INPUT_DAISY_V(LCD_DATA21_ALT0));

    // Config lcd.LCD_DATA22 to pad LCD_DATA22(K23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA22_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22(0x020E01EC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA22
    //     ALT1 (1) - Select instance: kpp signal: KEY_COL7
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA11
    //     ALT3 (3) - Select instance: eim signal: EIM_EB3
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE3
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO10
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE22
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG30
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA22_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22(0x020E04F4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA22_SRE_V(SLOW));
    // Pad LCD_DATA22 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA22_SELECT_INPUT(0x020E07D0)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_STAT_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_STAT_ALT2 (0) - Select signal lcd LCD_DATA22 as input from pad EPDC_PWR_STAT(ALT2).
    //     LCD_DATA22_ALT0 (1) - Select signal lcd LCD_DATA22 as input from pad LCD_DATA22(ALT0).
    HW_IOMUXC_LCD_DATA22_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA22_SELECT_INPUT_DAISY_V(LCD_DATA22_ALT0));

    // Config lcd.LCD_DATA23 to pad LCD_DATA23(K24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_WR(0x000110B0);
    // HW_IOMUXC_LCD_DATA23_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23(0x020E01F0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_DATA23
    //     ALT1 (1) - Select instance: kpp signal: KEY_ROW7
    //     ALT2 (2) - Select instance: csi signal: CSI_DATA10
    //     ALT3 (3) - Select instance: eim signal: EIM_EB2
    //     ALT4 (4) - Select instance: gpt signal: GPT_CLKIN
    //     ALT5 (5) - Select instance: gpio3 signal: GPIO3_IO11
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE23
    //     ALT7 (7) - Select instance: src signal: SRC_BOOT_CFG31
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_DATA23_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23(0x020E04F8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_DATA23_SRE_V(SLOW));
    // Pad LCD_DATA23 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_DATA23_SELECT_INPUT(0x020E07D4)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_PWR_WAKE_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_PWR_WAKE_ALT2 (0) - Select signal lcd LCD_DATA23 as input from pad EPDC_PWR_WAKE(ALT2).
    //     LCD_DATA23_ALT0 (1) - Select signal lcd LCD_DATA23 as input from pad LCD_DATA23(ALT0).
    HW_IOMUXC_LCD_DATA23_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_DATA23_SELECT_INPUT_DAISY_V(LCD_DATA23_ALT0));

    // Config lcd.LCD_ENABLE to pad LCD_ENABLE(J24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE(0x020E0210)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_ENABLE
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA5
    //     ALT2 (2) - Select instance: lcd signal: LCD_RD_E
    //     ALT3 (3) - Select instance: eim signal: EIM_OE
    //     ALT4 (4) - Select instance: uart2 signal: UART2_RX_DATA
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO16
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_ENABLE_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE(0x020E0518)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_ENABLE_SRE_V(SLOW));

    // Config lcd.LCD_HSYNC to pad LCD_HSYNC(H23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_WR(0x000110B0);
    // HW_IOMUXC_LCD_BUSY_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC(0x020E0214)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_HSYNC
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA6
    //     ALT2 (2) - Select instance: lcd signal: LCD_CS
    //     ALT3 (3) - Select instance: eim signal: EIM_CS0
    //     ALT4 (4) - Select instance: uart2 signal: UART2_TX_DATA
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO17
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE_CLK
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_HSYNC_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC(0x020E051C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_HSYNC_SRE_V(SLOW));
    // Pad LCD_HSYNC is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_LCD_BUSY_SELECT_INPUT(0x020E0774)
    //   DAISY [0] - MUX Mode Select Field Reset: LCD_HSYNC_ALT0
    //               Selecting Pads Involved in Daisy Chain.
    //     LCD_HSYNC_ALT0 (0) - Select signal lcd LCD_HSYNC as input from pad LCD_HSYNC(ALT0).
    //     LCD_RESET_ALT2 (1) - Select signal lcd LCD_BUSY as input from pad LCD_RESET(ALT2).
    HW_IOMUXC_LCD_BUSY_SELECT_INPUT_WR(
            BF_IOMUXC_LCD_BUSY_SELECT_INPUT_DAISY_V(LCD_HSYNC_ALT0));

    // Config lcd.LCD_RESET to pad LCD_RESET(H24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_RESET(0x020E0218)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_RESET
    //     ALT1 (1) - Select instance: eim signal: EIM_DTACK_B
    //     ALT2 (2) - Select instance: lcd signal: LCD_BUSY
    //     ALT3 (3) - Select instance: eim signal: EIM_WAIT
    //     ALT4 (4) - Select instance: uart2 signal: UART2_CTS_B
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO19
    //     ALT6 (6) - Select instance: ccm signal: CCM_PMIC_READY
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_RESET_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_RESET(0x020E0520)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_RESET_SRE_V(SLOW));

    // Config lcd.LCD_VSYNC to pad LCD_VSYNC(J23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC(0x020E021C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: lcd signal: LCD_VSYNC
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA7
    //     ALT2 (2) - Select instance: lcd signal: LCD_RS
    //     ALT3 (3) - Select instance: eim signal: EIM_CS1
    //     ALT4 (4) - Select instance: uart2 signal: UART2_RTS_B
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO18
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE_CTL
    HW_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_LCD_VSYNC_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC(0x020E0524)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_LCD_VSYNC_SRE_V(SLOW));
}
