/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: fec_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for fec module.
void fec_iomux_config(void)
{
    // Config fec.FEC_MDC to pad FEC_MDC(AA7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_MDC_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_MDC(0x020E012C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_MDC
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA4
    //     ALT2 (2) - Select instance: audmux signal: AUDIO_CLK_OUT
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_RESET
    //     ALT4 (4) - Select instance: usdhc3 signal: SD3_RESET
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO23
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE29
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_MDC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_MDC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_MDC_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_MDC(0x020E041C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDC_SRE_V(SLOW));

    // Config fec.FEC_MDIO to pad FEC_MDIO(AB7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_WR(0x000110B0);
    // HW_IOMUXC_FEC_FEC_MDI_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO(0x020E0130)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_MDIO
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_CLK
    //     ALT2 (2) - Select instance: audmux signal: AUD6_RXFS
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_SS0
    //     ALT4 (4) - Select instance: gpt signal: GPT_CAPTURE1
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO20
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE26
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_MDIO_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO(0x020E0420)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_MDIO_SRE_V(SLOW));
    // Pad FEC_MDIO is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_FEC_FEC_MDI_SELECT_INPUT(0x020E06F4)
    //   DAISY [1:0] - MUX Mode Select Field Reset: AUD_RXFS_ALT3
    //                 Selecting Pads Involved in Daisy Chain.
    //     AUD_RXFS_ALT3 (0) - Select signal fec FEC_MDIO as input from pad AUD_RXFS(ALT3).
    //     FEC_MDIO_ALT0 (1) - Select signal fec FEC_MDIO as input from pad FEC_MDIO(ALT0).
    //     SD1_CLK_ALT1 (2) - Select signal fec FEC_MDIO as input from pad SD1_CLK(ALT1).
    HW_IOMUXC_FEC_FEC_MDI_SELECT_INPUT_WR(
            BF_IOMUXC_FEC_FEC_MDI_SELECT_INPUT_DAISY_V(FEC_MDIO_ALT0));

    // Config fec.FEC_REF_OUT to pad FEC_REF_CLK(W10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK_WR(0x00000010);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK(0x020E0134)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_REF_OUT
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_RESET
    //     ALT2 (2) - Select instance: wdog1 signal: WDOG1_B
    //     ALT3 (3) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT4 (4) - Select instance: ccm signal: CCM_PMIC_READY
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO26
    //     ALT6 (6) - Select instance: spdif signal: SPDIF_EXT_CLK
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK_SION_V(ENABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_REF_CLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK(0x020E0424)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_REF_CLK_SRE_V(SLOW));

    // Config fec.FEC_RX_DATA0 to pad FEC_RX_DATA0(AA10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_WR(0x000110B0);
    // HW_IOMUXC_FEC_FEC_RX_DATA0_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0(0x020E013C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_RX_DATA0
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA5
    //     ALT2 (2) - Select instance: usb signal: USB_OTG1_ID
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_VSELECT
    //     ALT4 (4) - Select instance: usdhc3 signal: SD3_VSELECT
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO17
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE24
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0(0x020E042C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA0_SRE_V(SLOW));
    // Pad FEC_RX_DATA0 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_FEC_FEC_RX_DATA0_SELECT_INPUT(0x020E06F8)
    //   DAISY [1:0] - MUX Mode Select Field Reset: FEC_RX_DATA0_ALT0
    //                 Selecting Pads Involved in Daisy Chain.
    //     FEC_RX_DATA0_ALT0 (0) - Select signal fec FEC_RX_DATA0 as input from pad FEC_RX_DATA0(ALT0).
    //     I2C1_SCL_ALT3 (1) - Select signal fec FEC_RX_DATA0 as input from pad I2C1_SCL(ALT3).
    //     SD1_DATA5_ALT1 (2) - Select signal fec FEC_RX_DATA0 as input from pad SD1_DATA5(ALT1).
    HW_IOMUXC_FEC_FEC_RX_DATA0_SELECT_INPUT_WR(
            BF_IOMUXC_FEC_FEC_RX_DATA0_SELECT_INPUT_DAISY_V(FEC_RX_DATA0_ALT0));

    // Config fec.FEC_RX_DATA1 to pad FEC_RX_DATA1(AC10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_WR(0x000110B0);
    // HW_IOMUXC_FEC_FEC_RX_DATA1_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1(0x020E0140)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_RX_DATA1
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA2
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXFS
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_SS1
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE3
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO18
    //     ALT6 (6) - Select instance: fec signal: FEC_COL
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_DATA1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1(0x020E0430)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_DATA1_SRE_V(SLOW));
    // Pad FEC_RX_DATA1 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_FEC_FEC_RX_DATA1_SELECT_INPUT(0x020E06FC)
    //   DAISY [1:0] - MUX Mode Select Field Reset: AUD_TXFS_ALT3
    //                 Selecting Pads Involved in Daisy Chain.
    //     AUD_TXFS_ALT3 (0) - Select signal fec FEC_RX_DATA1 as input from pad AUD_TXFS(ALT3).
    //     FEC_RX_DATA1_ALT0 (1) - Select signal fec FEC_RX_DATA1 as input from pad FEC_RX_DATA1(ALT0).
    //     SD1_DATA2_ALT1 (2) - Select signal fec FEC_RX_DATA1 as input from pad SD1_DATA2(ALT1).
    HW_IOMUXC_FEC_FEC_RX_DATA1_SELECT_INPUT_WR(
            BF_IOMUXC_FEC_FEC_RX_DATA1_SELECT_INPUT_DAISY_V(FEC_RX_DATA1_ALT0));

    // Config fec.FEC_RX_DV to pad FEC_CRS_DV(AC9)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_WR(0x000110B0);
    // HW_IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV(0x020E0128)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_RX_DV
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA1
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXC
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_MISO
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE2
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO25
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE31
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_CRS_DV_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV(0x020E0418)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_CRS_DV_SRE_V(SLOW));
    // Pad FEC_CRS_DV is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT(0x020E0704)
    //   DAISY [1:0] - MUX Mode Select Field Reset: AUD_TXC_ALT3
    //                 Selecting Pads Involved in Daisy Chain.
    //     AUD_TXC_ALT3 (0) - Select signal fec FEC_RX_DV as input from pad AUD_TXC(ALT3).
    //     FEC_CRS_DV_ALT0 (1) - Select signal fec FEC_RX_DV as input from pad FEC_CRS_DV(ALT0).
    //     SD1_DATA1_ALT1 (2) - Select signal fec FEC_RX_DV as input from pad SD1_DATA1(ALT1).
    HW_IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT_WR(
            BF_IOMUXC_FEC_FEC_RX_DV_SELECT_INPUT_DAISY_V(FEC_CRS_DV_ALT0));

    // Config fec.FEC_TX_DATA0 to pad FEC_TX_DATA0(Y10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0(0x020E014C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_TX_DATA0
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA3
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXD
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_SS2
    //     ALT4 (4) - Select instance: gpt signal: GPT_CLKIN
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO24
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE30
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0(0x020E043C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA0_SRE_V(SLOW));

    // Config fec.FEC_TX_DATA1 to pad FEC_TX_DATA1(W11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1(0x020E0150)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_TX_DATA1
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA7
    //     ALT2 (2) - Select instance: spdif signal: SPDIF_OUT
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_CD_B
    //     ALT4 (4) - Select instance: usdhc3 signal: SD3_CD_B
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO16
    //     ALT6 (6) - Select instance: fec signal: FEC_RX_CLK
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_DATA1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1(0x020E0440)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_DATA1_SRE_V(SLOW));

    // Config fec.FEC_TX_EN to pad FEC_TX_EN(AD10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN(0x020E0148)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_TX_EN
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA6
    //     ALT2 (2) - Select instance: spdif signal: SPDIF_IN
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_WP
    //     ALT4 (4) - Select instance: usdhc3 signal: SD3_WP
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO22
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE28
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_EN_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN(0x020E0438)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_EN_SRE_V(SLOW));

    // Config fec.FEC_RESET_B to pad FEC_TX_CLK(AC8)
    // WAS Instance:gpio4 Signal:GPIO[21]
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK_WR(0x00000005);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK(0x020E0144)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_TX_CLK
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_CMD
    //     ALT2 (2) - Select instance: audmux signal: AUD6_RXC
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_SCLK
    //     ALT4 (4) - Select instance: gpt signal: GPT_CAPTURE2
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO21
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE27
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_TX_CLK_MUX_MODE_V(ALT5));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK(0x020E0434)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_TX_CLK_SRE_V(SLOW));

    // Config fec.GPIO4_IO19 to pad FEC_RX_ER(AD9)
    // Configure FEC_RX_ERR pad to gpio to avoid RX CRC error.This is the rework of hardware issue; WAS Instance:gpio4 Signal:GPIO[19]
    // HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER_WR(0x00000005);
    // HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER(0x020E0138)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: fec signal: FEC_RX_ER
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA0
    //     ALT2 (2) - Select instance: audmux signal: AUD6_RXD
    //     ALT3 (3) - Select instance: ecspi4 signal: ECSPI4_MOSI
    //     ALT4 (4) - Select instance: gpt signal: GPT_COMPARE1
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO19
    //     ALT6 (6) - Select instance: arm signal: ARM_TRACE25
    HW_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_FEC_RX_ER_MUX_MODE_V(ALT5));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER(0x020E0428)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_FEC_RX_ER_SRE_V(SLOW));
}
