/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: epdc_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for epdc module.
void epdc_iomux_config(void)
{
    // Config epdc.EPDC_DATA00 to pad EPDC_DATA00(A18)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00(0x020E0090)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA00
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_MOSI
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA24
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA00
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA00
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO07
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA00_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00(0x020E0380)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA00_SRE_V(SLOW));

    // Config epdc.EPDC_DATA01 to pad EPDC_DATA01(A17)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01(0x020E0094)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA01
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_MISO
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA25
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA01
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA01
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO08
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA01_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01(0x020E0384)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA01_SRE_V(SLOW));

    // Config epdc.EPDC_DATA02 to pad EPDC_DATA02(B17)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02(0x020E00B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA02
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS0
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA26
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA02
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA02
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO09
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA02_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02(0x020E03A0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA02_SRE_V(SLOW));

    // Config epdc.EPDC_DATA03 to pad EPDC_DATA03(A16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03(0x020E00B4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA03
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SCLK
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA27
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA03
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA03
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO10
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA03_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03(0x020E03A4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA03_SRE_V(SLOW));

    // Config epdc.EPDC_DATA04 to pad EPDC_DATA04(B16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04(0x020E00B8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA04
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS1
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA28
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA04
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA04
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO11
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA04_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04(0x020E03A8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA04_SRE_V(SLOW));

    // Config epdc.EPDC_DATA05 to pad EPDC_DATA05(A15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05(0x020E00BC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA05
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS2
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA29
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA05
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA05
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO12
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA05_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05(0x020E03AC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA05_SRE_V(SLOW));

    // Config epdc.EPDC_DATA06 to pad EPDC_DATA06(B15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06(0x020E00C0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA06
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_SS3
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA30
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA06
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA06
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO13
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA06_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06(0x020E03B0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA06_SRE_V(SLOW));

    // Config epdc.EPDC_DATA07 to pad EPDC_DATA07(C15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07(0x020E00C4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA07
    //     ALT1 (1) - Select instance: ecspi4 signal: ECSPI4_RDY
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA31
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA07
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA07
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO14
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA07_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07(0x020E03B4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA07_SRE_V(SLOW));

    // Config epdc.EPDC_DATA08 to pad EPDC_DATA08(D15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08(0x020E00C8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA08
    //     ALT1 (1) - Select instance: ecspi3 signal: ECSPI3_MOSI
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_CTRL0
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR16
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA08
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO15
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_RESET
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA08_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08(0x020E03B8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA08_SRE_V(SLOW));

    // Config epdc.EPDC_DATA09 to pad EPDC_DATA09(F15)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09(0x020E00CC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA09
    //     ALT1 (1) - Select instance: ecspi3 signal: ECSPI3_MISO
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_CTRL1
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR17
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA09
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO16
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_VSELECT
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA09_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09(0x020E03BC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA09_SRE_V(SLOW));

    // Config epdc.EPDC_DATA10 to pad EPDC_DATA10(G16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10(0x020E0098)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA10
    //     ALT1 (1) - Select instance: ecspi3 signal: ECSPI3_SS0
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_CTRL2
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR18
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA10
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO17
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA10_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10(0x020E0388)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA10_SRE_V(SLOW));

    // Config epdc.EPDC_DATA11 to pad EPDC_DATA11(F14)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11(0x020E009C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA11
    //     ALT1 (1) - Select instance: ecspi3 signal: ECSPI3_SCLK
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_CTRL3
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR19
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA11
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO18
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_CD_B
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA11_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11(0x020E038C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA11_SRE_V(SLOW));

    // Config epdc.EPDC_DATA12 to pad EPDC_DATA12(D14)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12(0x020E00A0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA12
    //     ALT1 (1) - Select instance: uart2 signal: UART2_RX_DATA
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_COM
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR20
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA12
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO19
    //     ALT6 (6) - Select instance: ecspi3 signal: ECSPI3_SS1
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA12_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12(0x020E0390)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA12_SRE_V(SLOW));

    // Config epdc.EPDC_DATA13 to pad EPDC_DATA13(B14)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13(0x020E00A4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA13
    //     ALT1 (1) - Select instance: uart2 signal: UART2_TX_DATA
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_IRQ
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR21
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA13
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO20
    //     ALT6 (6) - Select instance: ecspi3 signal: ECSPI3_SS2
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA13_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13(0x020E0394)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA13_SRE_V(SLOW));

    // Config epdc.EPDC_DATA14 to pad EPDC_DATA14(A14)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14(0x020E00A8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA14
    //     ALT1 (1) - Select instance: uart2 signal: UART2_RTS_B
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_STAT
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR22
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA14
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO21
    //     ALT6 (6) - Select instance: ecspi3 signal: ECSPI3_SS3
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA14_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14(0x020E0398)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA14_SRE_V(SLOW));

    // Config epdc.EPDC_DATA15 to pad EPDC_DATA15(A13)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15(0x020E00AC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_DATA15
    //     ALT1 (1) - Select instance: uart2 signal: UART2_CTS_B
    //     ALT2 (2) - Select instance: epdc signal: EPDC_PWR_WAKE
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR23
    //     ALT4 (4) - Select instance: spdc signal: SPDC_DATA15
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO22
    //     ALT6 (6) - Select instance: ecspi3 signal: ECSPI3_RDY
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_DATA15_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15(0x020E039C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_DATA15_SRE_V(SLOW));

    // Config epdc.EPDC_GDCLK to pad EPDC_GDCLK(A12)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK(0x020E00D0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDCLK
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS2
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YCKR
    //     ALT3 (3) - Select instance: csi signal: CSI_PIXCLK
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YCKL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO31
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_RESET
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDCLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK(0x020E03C0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDCLK_SRE_V(SLOW));

    // Config epdc.EPDC_GDOE to pad EPDC_GDOE(B13)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE(0x020E00D4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDOE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS3
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YOER
    //     ALT3 (3) - Select instance: csi signal: CSI_HSYNC
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YOEL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO00
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_VSELECT
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDOE_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE(0x020E03C4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDOE_SRE_V(SLOW));

    // Config epdc.EPDC_GDRL to pad EPDC_GDRL(B12)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL(0x020E00D8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDRL
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_RDY
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YDIOUR
    //     ALT3 (3) - Select instance: csi signal: CSI_MCLK
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIOUL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO01
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDRL_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL(0x020E03C8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDRL_SRE_V(SLOW));

    // Config epdc.EPDC_GDSP to pad EPDC_GDSP(A11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP(0x020E00DC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_GDSP
    //     ALT1 (1) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT2 (2) - Select instance: spdc signal: SPDC_YDIODR
    //     ALT3 (3) - Select instance: csi signal: CSI_VSYNC
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIODL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO02
    //     ALT6 (6) - Select instance: usdhc2 signal: SD2_CD_B
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_GDSP_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP(0x020E03CC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_GDSP_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_COM to pad EPDC_PWR_COM(B11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM(0x020E00E0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_COM
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA0
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA20
    //     ALT3 (3) - Select instance: eim signal: EIM_BCLK
    //     ALT4 (4) - Select instance: usb signal: USB_OTG1_ID
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO11
    //     ALT6 (6) - Select instance: usdhc3 signal: SD3_RESET
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_COM_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM(0x020E03D0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_COM_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_CTRL0 to pad EPDC_PWR_CTRL0(D11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0(0x020E00E4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_CTRL0
    //     ALT1 (1) - Select instance: audmux signal: AUD5_RXC
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA16
    //     ALT3 (3) - Select instance: eim signal: EIM_RW
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YCKL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO07
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_RESET
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0(0x020E03D4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL0_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_CTRL1 to pad EPDC_PWR_CTRL1(E11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1(0x020E00E8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_CTRL1
    //     ALT1 (1) - Select instance: audmux signal: AUD5_TXFS
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA17
    //     ALT3 (3) - Select instance: eim signal: EIM_OE
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YOEL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO08
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_VSELECT
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1(0x020E03D8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL1_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_CTRL2 to pad EPDC_PWR_CTRL2(F11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2(0x020E00EC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_CTRL2
    //     ALT1 (1) - Select instance: audmux signal: AUD5_TXD
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA18
    //     ALT3 (3) - Select instance: eim signal: EIM_CS0
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIOUL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO09
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL2_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2(0x020E03DC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL2_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_CTRL3 to pad EPDC_PWR_CTRL3(G12)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3(0x020E00F0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_CTRL3
    //     ALT1 (1) - Select instance: audmux signal: AUD5_TXC
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA19
    //     ALT3 (3) - Select instance: eim signal: EIM_CS1
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIODL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO10
    //     ALT6 (6) - Select instance: usdhc4 signal: SD4_CD_B
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_CTRL3_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3(0x020E03E0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_CTRL3_SRE_V(SLOW));

    // Config epdc.EPDC_PWR_IRQ to pad EPDC_PWR_IRQ(F10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_WR(0x000110B0);
    // HW_IOMUXC_EPDC_EPDC_PWR_IRQ_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ(0x020E00F4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_IRQ
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA1
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA21
    //     ALT3 (3) - Select instance: eim signal: EIM_ACLK_FREERUN
    //     ALT4 (4) - Select instance: usb signal: USB_OTG2_ID
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO12
    //     ALT6 (6) - Select instance: usdhc3 signal: SD3_VSELECT
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_IRQ_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ(0x020E03E4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_IRQ_SRE_V(SLOW));
    // Pad EPDC_PWR_IRQ is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_EPDC_EPDC_PWR_IRQ_SELECT_INPUT(0x020E06E8)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_DATA13_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_DATA13_ALT2 (0) - Select signal epdc EPDC_PWR_IRQ as input from pad EPDC_DATA13(ALT2).
    //     EPDC_PWR_IRQ_ALT0 (1) - Select signal epdc EPDC_PWR_IRQ as input from pad EPDC_PWR_IRQ(ALT0).
    HW_IOMUXC_EPDC_EPDC_PWR_IRQ_SELECT_INPUT_WR(
            BF_IOMUXC_EPDC_EPDC_PWR_IRQ_SELECT_INPUT_DAISY_V(EPDC_PWR_IRQ_ALT0));

    // Config epdc.EPDC_PWR_STAT to pad EPDC_PWR_STAT(E10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_WR(0x000110B0);
    // HW_IOMUXC_EPDC_EPDC_PWR_STAT_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT(0x020E00F8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_STAT
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA2
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA22
    //     ALT3 (3) - Select instance: eim signal: EIM_WAIT
    //     ALT4 (4) - Select instance: arm signal: ARM_EVENTI
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO13
    //     ALT6 (6) - Select instance: usdhc3 signal: SD3_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_STAT_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT(0x020E03E8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_STAT_SRE_V(SLOW));
    // Pad EPDC_PWR_STAT is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_EPDC_EPDC_PWR_STAT_SELECT_INPUT(0x020E06EC)
    //   DAISY [0] - MUX Mode Select Field Reset: EPDC_DATA14_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     EPDC_DATA14_ALT2 (0) - Select signal epdc EPDC_PWR_STAT as input from pad EPDC_DATA14(ALT2).
    //     EPDC_PWR_STAT_ALT0 (1) - Select signal epdc EPDC_PWR_STAT as input from pad EPDC_PWR_STAT(ALT0).
    HW_IOMUXC_EPDC_EPDC_PWR_STAT_SELECT_INPUT_WR(
            BF_IOMUXC_EPDC_EPDC_PWR_STAT_SELECT_INPUT_DAISY_V(EPDC_PWR_STAT_ALT0));

    // Config epdc.EPDC_PWR_WAKE to pad EPDC_PWR_WAKE(D10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE(0x020E00FC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_PWR_WAKE
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_DATA3
    //     ALT2 (2) - Select instance: lcd signal: LCD_DATA23
    //     ALT3 (3) - Select instance: eim signal: EIM_DTACK_B
    //     ALT4 (4) - Select instance: arm signal: ARM_EVENTO
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO14
    //     ALT6 (6) - Select instance: usdhc3 signal: SD3_CD_B
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_PWR_WAKE_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE(0x020E03EC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_PWR_WAKE_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE0 to pad EPDC_SDCE0(C11)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0(0x020E0100)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCE0
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS1
    //     ALT2 (2) - Select instance: pwm3 signal: PWM3_OUT
    //     ALT3 (3) - Select instance: eim signal: EIM_CS2
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YCKR
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO27
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0(0x020E03F0)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE0_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE1 to pad EPDC_SDCE1(A10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1(0x020E0104)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCE1
    //     ALT1 (1) - Select instance: wdog2 signal: WDOG2_B
    //     ALT2 (2) - Select instance: pwm4 signal: PWM4_OUT
    //     ALT3 (3) - Select instance: eim signal: EIM_LBA
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YOER
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1(0x020E03F4)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE1_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE2 to pad EPDC_SDCE2(B9)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2(0x020E0108)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCE2
    //     ALT1 (1) - Select instance: i2c3 signal: I2C3_SCL
    //     ALT2 (2) - Select instance: pwm1 signal: PWM1_OUT
    //     ALT3 (3) - Select instance: eim signal: EIM_EB0
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIOUR
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO29
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE2_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2(0x020E03F8)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE2_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE3 to pad EPDC_SDCE3(A9)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3(0x020E010C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCE3
    //     ALT1 (1) - Select instance: i2c3 signal: I2C3_SDA
    //     ALT2 (2) - Select instance: pwm2 signal: PWM2_OUT
    //     ALT3 (3) - Select instance: eim signal: EIM_EB1
    //     ALT4 (4) - Select instance: spdc signal: SPDC_YDIODR
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO30
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCE3_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3(0x020E03FC)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCE3_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE7 to pad EPDC_BDR0(C18)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0_WR(0x00000006);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0(0x020E0088)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_BDR0
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_CLK
    //     ALT2 (2) - Select instance: uart3 signal: UART3_RTS_B
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR26
    //     ALT4 (4) - Select instance: spdc signal: SPDC_RL
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO05
    //     ALT6 (6) - Select instance: epdc signal: EPDC_SDCE7
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR0_MUX_MODE_V(ALT6));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0(0x020E0378)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR0_SRE_V(SLOW));

    // Config epdc.EPDC_SDCE8 to pad EPDC_BDR1(B18)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1_WR(0x00000006);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1(0x020E008C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_BDR1
    //     ALT1 (1) - Select instance: usdhc4 signal: SD4_CMD
    //     ALT2 (2) - Select instance: uart3 signal: UART3_CTS_B
    //     ALT3 (3) - Select instance: eim signal: EIM_CRE
    //     ALT4 (4) - Select instance: spdc signal: SPDC_UD
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO06
    //     ALT6 (6) - Select instance: epdc signal: EPDC_SDCE8
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_BDR1_MUX_MODE_V(ALT6));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1(0x020E037C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_BDR1_SRE_V(SLOW));

    // Config epdc.EPDC_SDCLK_P to pad EPDC_SDCLK(B10)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK(0x020E0110)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDCLK_P
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT2 (2) - Select instance: i2c2 signal: I2C2_SCL
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA08
    //     ALT4 (4) - Select instance: spdc signal: SPDC_CL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO23
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDCLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK(0x020E0400)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDCLK_SRE_V(SLOW));

    // Config epdc.EPDC_SDLE to pad EPDC_SDLE(B8)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE(0x020E0114)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDLE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_MISO
    //     ALT2 (2) - Select instance: i2c2 signal: I2C2_SDA
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA09
    //     ALT4 (4) - Select instance: spdc signal: SPDC_LD
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO24
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDLE_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE(0x020E0404)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDLE_SRE_V(SLOW));

    // Config epdc.EPDC_SDOE to pad EPDC_SDOE(E7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE(0x020E0118)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDOE
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SS0
    //     ALT2 (2) - Select instance: spdc signal: SPDC_XDIOR
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA10
    //     ALT4 (4) - Select instance: spdc signal: SPDC_XDIOL
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDOE_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE(0x020E0408)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDOE_SRE_V(SLOW));

    // Config epdc.EPDC_SDSHR to pad EPDC_SDSHR(F7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR(0x020E011C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_SDSHR
    //     ALT1 (1) - Select instance: ecspi2 signal: ECSPI2_SCLK
    //     ALT2 (2) - Select instance: epdc signal: EPDC_SDCE4
    //     ALT3 (3) - Select instance: csi signal: CSI_DATA11
    //     ALT4 (4) - Select instance: spdc signal: SPDC_XDIOR
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO26
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_SDSHR_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR(0x020E040C)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_SDSHR_SRE_V(SLOW));

    // Config epdc.EPDC_VCOM0 to pad EPDC_VCOM0(C7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0(0x020E0120)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_VCOM0
    //     ALT1 (1) - Select instance: audmux signal: AUD5_RXFS
    //     ALT2 (2) - Select instance: uart3 signal: UART3_RX_DATA
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR24
    //     ALT4 (4) - Select instance: spdc signal: SPDC_VCOM0
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO03
    //     ALT6 (6) - Select instance: epdc signal: EPDC_SDCE5
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM0_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0(0x020E0410)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM0_SRE_V(SLOW));

    // Config epdc.EPDC_VCOM1 to pad EPDC_VCOM1(D7)
    // HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_WR(0x000110B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1(0x020E0124)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: epdc signal: EPDC_VCOM1
    //     ALT1 (1) - Select instance: audmux signal: AUD5_RXD
    //     ALT2 (2) - Select instance: uart3 signal: UART3_TX_DATA
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR25
    //     ALT4 (4) - Select instance: spdc signal: SPDC_VCOM1
    //     ALT5 (5) - Select instance: gpio2 signal: GPIO2_IO04
    //     ALT6 (6) - Select instance: epdc signal: EPDC_SDCE6
    HW_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_EPDC_VCOM1_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1(0x020E0414)
    //   LVE [22] - Low Voltage Enable Field Reset: DISABLED
    //     DISABLED (0) - High Voltage
    //     ENABLED (1) - Low Voltage
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_LVE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_EPDC_VCOM1_SRE_V(SLOW));
}
