/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: enet_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for enet module.
void enet_iomux_config(void)
{
    // Config enet.ENET_MDC to pad ENET_MDC(V20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_MDC(0x020E01E8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mlb signal: MLB_DATA
    //     ALT1 (1) - Select instance: enet signal: ENET_MDC
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX5_RX0
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT1_IN
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO31
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_MDC(0x020E05B8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_SRE_V(SLOW));

    // Config enet.ENET_MDIO to pad ENET_MDIO(V23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_WR(0x0001B0B0);
    // HW_IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO(0x020E01EC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_MDIO
    //     ALT2 (2) - Select instance: esai signal: ESAI_RX_CLK
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT1_OUT
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO22
    //     ALT6 (6) - Select instance: spdif signal: SPDIF_LOCK
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO(0x020E05BC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_SRE_V(SLOW));
    // Pad ENET_MDIO is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT(0x020E0810)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_MDIO_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_MDIO_ALT1 (0) - Select signal enet ENET_MDIO as input from pad ENET_MDIO(ALT1).
    //     KEY_COL1_ALT1 (1) - Select signal enet ENET_MDIO as input from pad KEY_COL1(ALT1).
    HW_IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_MDIO_SELECT_INPUT_DAISY_V(ENET_MDIO_ALT1));

    // Config enet.ENET_TX_CLK to pad ENET_REF_CLK(V22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK(0x020E01F0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_TX_CLK
    //     ALT2 (2) - Select instance: esai signal: ESAI_RX_FS
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO23
    //     ALT6 (6) - Select instance: spdif signal: SPDIF_SR_CLK
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_REF_CLK_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK(0x020E05C0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_REF_CLK_SRE_V(SLOW));

    // Config enet.RGMII_RD0 to pad RGMII_RD0(C24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0(0x020E02AC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_RX_READY
    //     ALT1 (1) - Select instance: enet signal: RGMII_RD0
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD0_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0(0x020E0694)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RD0 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT(0x020E0818)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_RX_DATA0_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_RX_DATA0_ALT1 (0) - Select signal enet ENET_RX_DATA0 as input from pad ENET_RX_DATA0(ALT1).
    //     RGMII_RD0_ALT1 (1) - Select signal enet RGMII_RD0 as input from pad RGMII_RD0(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_DATA0_SELECT_INPUT_DAISY_V(RGMII_RD0_ALT1));

    // Config enet.RGMII_RD1 to pad RGMII_RD1(B23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1(0x020E02B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_TX_FLAG
    //     ALT1 (1) - Select instance: enet signal: RGMII_RD1
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO27
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD1_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1(0x020E0698)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RD1 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT(0x020E081C)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_RX_DATA1_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_RX_DATA1_ALT1 (0) - Select signal enet ENET_RX_DATA1 as input from pad ENET_RX_DATA1(ALT1).
    //     RGMII_RD1_ALT1 (1) - Select signal enet RGMII_RD1 as input from pad RGMII_RD1(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_DATA1_SELECT_INPUT_DAISY_V(RGMII_RD1_ALT1));

    // Config enet.RGMII_RD2 to pad RGMII_RD2(B24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2(0x020E02B4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_TX_DATA
    //     ALT1 (1) - Select instance: enet signal: RGMII_RD2
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD2_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2(0x020E069C)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD2_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RD2 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT(0x020E0820)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL2_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL2_ALT1 (0) - Select signal enet ENET_RX_DATA2 as input from pad KEY_COL2(ALT1).
    //     RGMII_RD2_ALT1 (1) - Select signal enet RGMII_RD2 as input from pad RGMII_RD2(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_DATA2_SELECT_INPUT_DAISY_V(RGMII_RD2_ALT1));

    // Config enet.RGMII_RD3 to pad RGMII_RD3(D23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3(0x020E02B8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_TX_WAKE
    //     ALT1 (1) - Select instance: enet signal: RGMII_RD3
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO29
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RD3_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3(0x020E06A0)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RD3_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RD3 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT(0x020E0824)
    //   DAISY [0] - MUX Mode Select Field Reset: KEY_COL0_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     KEY_COL0_ALT1 (0) - Select signal enet ENET_RX_DATA3 as input from pad KEY_COL0(ALT1).
    //     RGMII_RD3_ALT1 (1) - Select signal enet RGMII_RD3 as input from pad RGMII_RD3(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_DATA3_SELECT_INPUT_DAISY_V(RGMII_RD3_ALT1));

    // Config enet.RGMII_RXC to pad RGMII_RXC(B25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_WR(0x00013030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC(0x020E02C0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usb signal: USB_H3_STROBE
    //     ALT1 (1) - Select instance: enet signal: RGMII_RXC
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO30
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RXC_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC(0x020E06A8)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RXC_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RXC is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT(0x020E0814)
    //   DAISY [0] - MUX Mode Select Field Reset: GPIO18_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     GPIO18_ALT1 (0) - Select signal enet ENET_RX_CLK as input from pad GPIO18(ALT1).
    //     RGMII_RXC_ALT1 (1) - Select signal enet RGMII_RXC as input from pad RGMII_RXC(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_CLK_SELECT_INPUT_DAISY_V(RGMII_RXC_ALT1));

    // Config enet.RGMII_RX_CTL to pad RGMII_RX_CTL(D22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_WR(0x00013030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(0x00000000);
    // HW_IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL(0x020E02BC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usb signal: USB_H3_DATA
    //     ALT1 (1) - Select instance: enet signal: RGMII_RX_CTL
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO24
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_RX_CTL_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL(0x020E06A4)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM register.
    //                Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM
    //                register.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_RX_CTL_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM(0x020E0788)
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    HW_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_RGMII_TERM_ODT_V(DISABLED));
    // Pad RGMII_RX_CTL is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT(0x020E0828)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_CRS_DV_ALT1
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_CRS_DV_ALT1 (0) - Select signal enet ENET_RX_EN as input from pad ENET_CRS_DV(ALT1).
    //     RGMII_RX_CTL_ALT1 (1) - Select signal enet RGMII_RX_CTL as input from pad RGMII_RX_CTL(ALT1).
    HW_IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT_WR(
            BF_IOMUXC_ENET_MAC0_RX_EN_SELECT_INPUT_DAISY_V(RGMII_RX_CTL_ALT1));

    // Config enet.RGMII_TD0 to pad RGMII_TD0(C22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0(0x020E02C4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_TX_READY
    //     ALT1 (1) - Select instance: enet signal: RGMII_TD0
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO20
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD0_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0(0x020E06AC)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_TD1 to pad RGMII_TD1(F20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1(0x020E02C8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_RX_FLAG
    //     ALT1 (1) - Select instance: enet signal: RGMII_TD1
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO21
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD1_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1(0x020E06B0)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_TD2 to pad RGMII_TD2(E21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2(0x020E02CC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_RX_DATA
    //     ALT1 (1) - Select instance: enet signal: RGMII_TD2
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO22
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD2_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2(0x020E06B4)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD2_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_TD3 to pad RGMII_TD3(A24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_WR(0x0001B030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3(0x020E02D0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mipi_hsi signal: HSI_RX_WAKE
    //     ALT1 (1) - Select instance: enet signal: RGMII_TD3
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO23
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TD3_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3(0x020E06B8)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TD3_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_TXC to pad RGMII_TXC(D21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_WR(0x00013030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC(0x020E02D8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usb signal: USB_H2_DATA
    //     ALT1 (1) - Select instance: enet signal: RGMII_TXC
    //     ALT2 (2) - Select instance: spdif signal: SPDIF_EXT_CLK
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO19
    //     ALT7 (7) - Select instance: xtalosc signal: XTALOSC_REF_CLK_24M
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TXC_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC(0x020E06C0)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: Read Only Field
    //                    The value of this field is fixed and cannot be changed.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TXC_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_TX_CTL to pad RGMII_TX_CTL(C23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL_WR(0x00000001);
    // HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_WR(0x00013030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(0x00080000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL(0x020E02D4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: usb signal: USB_H2_STROBE
    //     ALT1 (1) - Select instance: enet signal: RGMII_TX_CTL
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO26
    //     ALT7 (7) - Select instance: enet signal: ENET_REF_CLK
    HW_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_RGMII_TX_CTL_MUX_MODE_V(ALT1));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL(0x020E06BC)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: RESERVED0
    //                           NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //                           Note: The value of this field does not reflect the vaule of the
    //                           IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: Read Only Field
    //                    The value of this field is fixed and cannot be changed.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_RGMII_TX_CTL_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII(0x020E0768)
    //   DDR_SEL_RGMII [19:18] - DDR Select Field Reset: 1P2V_IO
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     1P2V_IO (2) - 1.2V I/O interfaces including USB HSIC and MIPI_HSI. Provides calibrated drive strengths for signals ranging from 1.0V up to 1.3V.
    //     1P5V_IO (3) - 1.5V I/O interfaces including ENET. Provides calibrated drive strengths for signals ranging from 1.3V to 2.5V.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_RGMII_DDR_SEL_RGMII_V(1P2V_IO));

    // Config enet.RGMII_NRST to pad ENET_CRS_DV(U21)
    // WAS Instance:gpio1 Signal:GPIO[25]
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_WR(0x00000005);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_WR(0x00000088);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV(0x020E01E4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_RX_EN
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX_CLK
    //     ALT3 (3) - Select instance: spdif signal: SPDIF_EXT_CLK
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_MUX_MODE_V(ALT5));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV(0x020E05B4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_DSE_V(240_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_SRE_V(SLOW));

    // Config enet.RGMII_INT to pad ENET_RX_DATA1(W22)
    // WAS Instance:gpio1 Signal:GPIO[26]
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_WR(0x00000005);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1(0x020E01FC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mlb signal: MLB_SIG
    //     ALT1 (1) - Select instance: enet signal: ENET_RX_DATA1
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX_FS
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT3_OUT
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO26
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_MUX_MODE_V(ALT5));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1(0x020E05CC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_SRE_V(SLOW));

    // Config enet.ETH_WOL_INT to pad ENET_TX_EN(V21)
    // WAS Instance:gpio1 Signal:GPIO[28]
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_WR(0x00000005);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN(0x020E0200)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [3:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_TX_EN
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX3_RX2
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO28
    //     ALT9 (9) - Select instance: i2c4 signal: I2C4_SCL
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_MUX_MODE_V(ALT5));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN(0x020E05D0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     RESERVED0 (0) - Reserved
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_SRE_V(SLOW));
}
