/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: mmdc_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for mmdc module.
void mmdc_iomux_config(void)
{
    // Config mmdc.DRAM_ADDR00 to pad DRAM_ADDR00(AC14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00(0x020E0424)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR00_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR01 to pad DRAM_ADDR01(AB14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01(0x020E0428)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR01_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR02 to pad DRAM_ADDR02(AA14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02(0x020E0444)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR02_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR03 to pad DRAM_ADDR03(Y14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03(0x020E0448)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR03_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR04 to pad DRAM_ADDR04(W14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04(0x020E044C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR04_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR05 to pad DRAM_ADDR05(AE13)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05(0x020E0450)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR05_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR06 to pad DRAM_ADDR06(AC13)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06(0x020E0454)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR06_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR07 to pad DRAM_ADDR07(Y13)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07(0x020E0458)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR07_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR08 to pad DRAM_ADDR08(AB13)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08(0x020E045C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR08_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR09 to pad DRAM_ADDR09(AE12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09(0x020E0460)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_PUE_V(KEEP) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR09_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR10 to pad DRAM_ADDR10(AA15)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10(0x020E042C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR10_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR11 to pad DRAM_ADDR11(AC12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11(0x020E0430)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR11_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR12 to pad DRAM_ADDR12(AD12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12(0x020E0434)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR12_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR13 to pad DRAM_ADDR13(AC17)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13(0x020E0438)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR13_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR14 to pad DRAM_ADDR14(AA12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14(0x020E043C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR14_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ADDR15 to pad DRAM_ADDR15(Y12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15(0x020E0440)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ADDR15_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CAS to pad DRAM_CAS(AE16)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS(0x020E0464)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CAS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CS0 to pad DRAM_CS0(Y16)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0(0x020E0468)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_CS1 to pad DRAM_CS1(AD17)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1(0x020E046C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_CS1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA00 to pad DRAM_DATA00(AD2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA01 to pad DRAM_DATA01(AE2)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA02 to pad DRAM_DATA02(AC4)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA03 to pad DRAM_DATA03(AA5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA04 to pad DRAM_DATA04(AC1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA05 to pad DRAM_DATA05(AD1)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA06 to pad DRAM_DATA06(AB4)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA07 to pad DRAM_DATA07(AE4)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B0DS(0x020E0764)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B0DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B0DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA08 to pad DRAM_DATA08(AD5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA09 to pad DRAM_DATA09(AE5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA10 to pad DRAM_DATA10(AA6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA11 to pad DRAM_DATA11(AE7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA12 to pad DRAM_DATA12(AB5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA13 to pad DRAM_DATA13(AC5)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA14 to pad DRAM_DATA14(AB6)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA15 to pad DRAM_DATA15(AC7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B1DS(0x020E0770)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B1DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B1DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA16 to pad DRAM_DATA16(AB7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA17 to pad DRAM_DATA17(AA8)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA18 to pad DRAM_DATA18(AB9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA19 to pad DRAM_DATA19(Y9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA20 to pad DRAM_DATA20(Y7)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA21 to pad DRAM_DATA21(Y8)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA22 to pad DRAM_DATA22(AC8)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA23 to pad DRAM_DATA23(AA9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B2DS(0x020E0778)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B2DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B2DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA24 to pad DRAM_DATA24(AE9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA25 to pad DRAM_DATA25(Y10)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA26 to pad DRAM_DATA26(AE11)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA27 to pad DRAM_DATA27(AB11)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA28 to pad DRAM_DATA28(AC9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA29 to pad DRAM_DATA29(AD9)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA30 to pad DRAM_DATA30(AD11)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA31 to pad DRAM_DATA31(AC11)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B3DS(0x020E077C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B3DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B3DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA32 to pad DRAM_DATA32(AA17)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA33 to pad DRAM_DATA33(AA18)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA34 to pad DRAM_DATA34(AC18)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA35 to pad DRAM_DATA35(AE19)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA36 to pad DRAM_DATA36(Y17)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA37 to pad DRAM_DATA37(Y18)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA38 to pad DRAM_DATA38(AB19)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA39 to pad DRAM_DATA39(AC19)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B4DS(0x020E0780)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B4DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B4DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA40 to pad DRAM_DATA40(Y19)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA41 to pad DRAM_DATA41(AB20)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA42 to pad DRAM_DATA42(AB21)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA43 to pad DRAM_DATA43(AD21)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA44 to pad DRAM_DATA44(Y20)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA45 to pad DRAM_DATA45(AA20)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA46 to pad DRAM_DATA46(AE21)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA47 to pad DRAM_DATA47(AC21)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B5DS(0x020E0784)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B5DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B5DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA48 to pad DRAM_DATA48(AC22)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA49 to pad DRAM_DATA49(AE22)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA50 to pad DRAM_DATA50(AE24)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA51 to pad DRAM_DATA51(AC24)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA52 to pad DRAM_DATA52(AB22)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA53 to pad DRAM_DATA53(AC23)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA54 to pad DRAM_DATA54(AD25)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA55 to pad DRAM_DATA55(AC25)
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(0x00000030);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B6DS(0x020E078C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B6DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B6DS_DSE_V(40_OHM));

    // Config mmdc.DRAM_DATA56 to pad DRAM_DATA56(AB25)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA57 to pad DRAM_DATA57(AA21)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA58 to pad DRAM_DATA58(Y25)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA59 to pad DRAM_DATA59(Y22)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA60 to pad DRAM_DATA60(AB23)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA61 to pad DRAM_DATA61(AA23)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA62 to pad DRAM_DATA62(Y23)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DATA63 to pad DRAM_DATA63(W25)
    // HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_B7DS(0x020E0748)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_B7DS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_B7DS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE(0x020E0760)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM0 to pad DRAM_DQM0(AC3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0(0x020E0470)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM1 to pad DRAM_DQM1(AC6)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1(0x020E0474)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM2 to pad DRAM_DQM2(AB8)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2(0x020E0478)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM2_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM3 to pad DRAM_DQM3(AE10)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3(0x020E047C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM3_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM4 to pad DRAM_DQM4(AB18)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4(0x020E0480)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM4_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM5 to pad DRAM_DQM5(AC20)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5(0x020E0484)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM5_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM6 to pad DRAM_DQM6(AD24)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6(0x020E0488)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM6_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_DQM7 to pad DRAM_DQM7(Y21)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7(0x020E048C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: Read Only Field
    //              The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_DQM7_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ODT0 to pad DRAM_ODT0(AC16)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_WR(0x00003030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0(0x020E04B4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT0_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_ODT1 to pad DRAM_ODT1(AB17)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_WR(0x00003030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1(0x020E04B8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_ODT1_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_RAS to pad DRAM_RAS(AB15)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS(0x020E0490)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RAS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_RESET to pad DRAM_RESET(Y6)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_WR(0x00083030);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET(0x020E0494)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DDR_SEL_V(LPDDR2) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_RESET_DSE_V(40_OHM));

    // Config mmdc.DRAM_SDBA0 to pad DRAM_SDBA0(AC15)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0(0x020E0498)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDBA1 to pad DRAM_SDBA1(Y15)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1(0x020E049C)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_ADDDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_ADDDS(0x020E074C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_ADDDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_ADDDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDBA2 to pad DRAM_SDBA2(AB12)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_WR(0x0000B000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2(0x020E04A0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDBA2_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCKE0 to pad DRAM_SDCKE0(Y11)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_WR(0x00003000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0(0x020E04A4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE0_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCKE1 to pad DRAM_SDCKE1(AA11)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_WR(0x00003000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1(0x020E04A8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCKE1_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCLK0_P to pad DRAM_SDCLK0_P(AD15)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P(0x020E04AC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK0_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDCLK1_P to pad DRAM_SDCLK1_P(AD14)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_WR(0x00008030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P(0x020E04B0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_ODT_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDCLK1_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS0_P to pad DRAM_SDQS0_P(AE3)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P(0x020E04BC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS0_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS1_P to pad DRAM_SDQS1_P(AD6)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P(0x020E04C0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS1_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS2_P to pad DRAM_SDQS2_P(AD8)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P(0x020E04C4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS2_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS3_P to pad DRAM_SDQS3_P(AC10)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P(0x020E04C8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS3_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS4_P to pad DRAM_SDQS4_P(AD18)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P(0x020E04CC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS4_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS5_P to pad DRAM_SDQS5_P(AD20)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P(0x020E04D0)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS5_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS6_P to pad DRAM_SDQS6_P(AD23)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P(0x020E04D4)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS6_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDQS7_P to pad DRAM_SDQS7_P(AA25)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_WR(0x00002030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P(0x020E04D8)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //                    NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL register.
    //                    Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL
    //                    register.
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRHYS
    //              register.
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PD
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //                NOTE: Read Only Field
    //                The value of this field is fixed and cannot be changed.
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_PUS_V(100K_OHM_PD) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_PKE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDQS7_P_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL(0x020E0750)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRMODE_CTL_DDR_INPUT_V(CMOS));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRHYS(0x020E075C)
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRHYS_HYS_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));

    // Config mmdc.DRAM_SDWE to pad DRAM_SDWE(AB16)
    // HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_WR(0x00008000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(0x00001000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(0x00002000);
    // HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(0x00000030);
    // HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(0x00080000);
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE(0x020E04DC)
    //   DDR_SEL [19:18] - DDR Select Field Reset: RESERVED0
    //                     NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE register.
    //                     Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE
    //                     register.
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    //   DDR_INPUT [17] - DDR / CMOS Input Mode Field Reset: CMOS
    //     CMOS (0) - CMOS input mode.
    //     DIFFERENTIAL (1) - Differential input mode.
    //   HYS [16] - Hysteresis Enable Field Reset: DISABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: KEEP
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPK
    //              register.
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: DISABLED
    //              NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE register.
    //              Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_DDRPKE
    //              register.
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODT [10:8] - On Die Termination Field Reset: DISABLED
    //     DISABLED (0) - Disabled
    //     120_OHM (1) - 120 Ohm ODT
    //     60_OHM (2) - 60 Ohm ODT
    //     40_OHM (3) - 40 Ohm ODT
    //     30_OHM (4) - 30 Ohm ODT
    //     RESERVED0 (5) - Reserved
    //     20_OHM (6) - 20 Ohm ODT
    //     RESERVED1 (7) - Reserved
    //   DSE [5:3] - Drive Strength Field Reset: HIZ
    //               NOTE: This field can be configured using the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS register.
    //               Note: The value of this field does not reflect the vaule of the IOMUXC_SW_PAD_CTL_GRP_IOMUXC_SW_PAD_CTL_GRP_CTLDS
    //               register.
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_DDR_INPUT_V(CMOS) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_HYS_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DRAM_SDWE_ODT_V(DISABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPKE(0x020E0754)
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPKE_PKE_V(ENABLED));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDRPK(0x020E0758)
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    HW_IOMUXC_SW_PAD_CTL_GRP_DDRPK_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDRPK_PUE_V(PULL));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_CTLDS(0x020E076C)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    HW_IOMUXC_SW_PAD_CTL_GRP_CTLDS_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_CTLDS_DSE_V(40_OHM));
    // Pad Group Control Register:
    // IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE(0x020E0774)
    //   DDR_SEL [19:18] - DDR Select Field Reset: LPDDR2
    //     RESERVED0 (0) - Reserved
    //     RESERVED1 (1) - Reserved
    //     LPDDR2 (2) - LPDDR2 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.2V)
    //     DDR3 (3) - DDR3 mode (240 Ohm driver unit calibration, 240, 120, 80, 60, 48, 40, 32 Ohm drive strengths at 1.5V)
    HW_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_WR(
            BF_IOMUXC_SW_PAD_CTL_GRP_DDR_TYPE_DDR_SEL_V(LPDDR2));
}
