/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: ipu1_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for ipu1 module.
void ipu1_iomux_config(void)
{
    // Config ipu1.IPU1_CSI0_DATA04 to pad CSI0_DATA04(N1)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04(0x020E0268)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA04
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA02
    //     ALT2 (2) - Select instance: ecspi1 signal: ECSPI1_SCLK
    //     ALT3 (3) - Select instance: kpp signal: KEY_COL5
    //     ALT4 (4) - Select instance: audmux signal: AUD3_TXC
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO22
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE01
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA04_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04(0x020E0638)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA04_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA05 to pad CSI0_DATA05(P2)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05(0x020E026C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA05
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA03
    //     ALT2 (2) - Select instance: ecspi1 signal: ECSPI1_MOSI
    //     ALT3 (3) - Select instance: kpp signal: KEY_ROW5
    //     ALT4 (4) - Select instance: audmux signal: AUD3_TXD
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO23
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE02
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA05_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05(0x020E063C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA05_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA06 to pad CSI0_DATA06(N4)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06(0x020E0270)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA06
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA04
    //     ALT2 (2) - Select instance: ecspi1 signal: ECSPI1_MISO
    //     ALT3 (3) - Select instance: kpp signal: KEY_COL6
    //     ALT4 (4) - Select instance: audmux signal: AUD3_TXFS
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO24
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE03
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA06_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06(0x020E0640)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA06_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA07 to pad CSI0_DATA07(N3)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07(0x020E0274)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA07
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA05
    //     ALT2 (2) - Select instance: ecspi1 signal: ECSPI1_SS0
    //     ALT3 (3) - Select instance: kpp signal: KEY_ROW6
    //     ALT4 (4) - Select instance: audmux signal: AUD3_RXD
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO25
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE04
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA07_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07(0x020E0644)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA07_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA08 to pad CSI0_DATA08(N6)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08(0x020E0278)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA08
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA06
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_SCLK
    //     ALT3 (3) - Select instance: kpp signal: KEY_COL7
    //     ALT4 (4) - Select instance: i2c1 signal: I2C1_SDA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO26
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE05
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA08_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08(0x020E0648)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA08_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA09 to pad CSI0_DATA09(N5)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09(0x020E027C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA09
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA07
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT3 (3) - Select instance: kpp signal: KEY_ROW7
    //     ALT4 (4) - Select instance: i2c1 signal: I2C1_SCL
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO27
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE06
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA09_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09(0x020E064C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA09_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA10 to pad CSI0_DATA10(M1)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10(0x020E0280)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA10
    //     ALT1 (1) - Select instance: audmux signal: AUD3_RXC
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_MISO
    //     ALT3 (3) - Select instance: uart1 signal: UART1_TX_DATA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO28
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE07
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA10_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10(0x020E0650)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA10_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA11 to pad CSI0_DATA11(M3)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11(0x020E0284)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA11
    //     ALT1 (1) - Select instance: audmux signal: AUD3_RXFS
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_SS0
    //     ALT3 (3) - Select instance: uart1 signal: UART1_RX_DATA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO29
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE08
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA11_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11(0x020E0654)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA11_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA12 to pad CSI0_DATA12(M2)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12(0x020E0288)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA12
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA08
    //     ALT3 (3) - Select instance: uart4 signal: UART4_TX_DATA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO30
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE09
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA12_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12(0x020E0658)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA12_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA13 to pad CSI0_DATA13(L1)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13(0x020E028C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA13
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA09
    //     ALT3 (3) - Select instance: uart4 signal: UART4_RX_DATA
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO31
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE10
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA13_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13(0x020E065C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA13_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA14 to pad CSI0_DATA14(M4)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14(0x020E0290)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA14
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA10
    //     ALT3 (3) - Select instance: uart5 signal: UART5_TX_DATA
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO00
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE11
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA14_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14(0x020E0660)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA14_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA15 to pad CSI0_DATA15(M5)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15(0x020E0294)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA15
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA11
    //     ALT3 (3) - Select instance: uart5 signal: UART5_RX_DATA
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO01
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE12
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA15_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15(0x020E0664)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA15_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA16 to pad CSI0_DATA16(L4)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16(0x020E0298)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA16
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA12
    //     ALT3 (3) - Select instance: uart4 signal: UART4_RTS_B
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO02
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE13
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA16_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16(0x020E0668)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA16_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA17 to pad CSI0_DATA17(L3)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17(0x020E029C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA17
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA13
    //     ALT3 (3) - Select instance: uart4 signal: UART4_CTS_B
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO03
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE14
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA17_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17(0x020E066C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA17_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA18 to pad CSI0_DATA18(M6)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18(0x020E02A0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA18
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA14
    //     ALT3 (3) - Select instance: uart5 signal: UART5_RTS_B
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO04
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE15
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA18_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18(0x020E0670)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA18_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_DATA19 to pad CSI0_DATA19(L6)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19(0x020E02A4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_DATA19
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA15
    //     ALT3 (3) - Select instance: uart5 signal: UART5_CTS_B
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO05
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_DATA19_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19(0x020E0674)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_DATA19_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_HSYNC to pad CSI0_HSYNC(P4)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC(0x020E025C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_HSYNC
    //     ALT3 (3) - Select instance: ccm signal: CCM_CLKO1
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO19
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE_CTL
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_HSYNC_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC(0x020E062C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_HSYNC_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_PIXCLK to pad CSI0_PIXCLK(P1)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK(0x020E0258)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_PIXCLK
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO18
    //     ALT7 (7) - Select instance: arm signal: ARM_EVENTO
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_PIXCLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK(0x020E0628)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_PIXCLK_SRE_V(SLOW));

    // Config ipu1.IPU1_CSI0_VSYNC to pad CSI0_VSYNC(N2)
    // HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC(0x020E0264)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_CSI0_VSYNC
    //     ALT1 (1) - Select instance: eim signal: EIM_DATA01
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO21
    //     ALT7 (7) - Select instance: arm signal: ARM_TRACE00
    HW_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_CSI0_VSYNC_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC(0x020E0634)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_CSI0_VSYNC_SRE_V(SLOW));

    // Config ipu1.IPU1_DI0_DISP_CLK to pad DI0_DISP_CLK(N19)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_WR(0x0001B060);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK(0x020E015C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_DISP_CLK
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_DISP_CLK
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO16
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_DISP_CLK_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK(0x020E0470)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_SPEED_V(50MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_DSE_V(60_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_DISP_CLK_SRE_V(SLOW));

    // Config ipu1.IPU1_DI0_PIN02 to pad DI0_PIN02(N25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02(0x020E0164)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN02
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN02
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXD
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO18
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02(0x020E0478)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_SRE_V(SLOW));

    // Config ipu1.IPU1_DI0_PIN03 to pad DI0_PIN03(N20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03(0x020E0168)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN03
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN03
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXFS
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO19
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03(0x020E047C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_SRE_V(SLOW));

    // Config ipu1.IPU1_DI0_PIN04 to pad DI0_PIN04(P25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04(0x020E016C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN04
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN04
    //     ALT2 (2) - Select instance: audmux signal: AUD6_RXD
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_WP
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO20
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04(0x020E0480)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_SRE_V(SLOW));

    // Config ipu1.IPU1_DI0_PIN15 to pad DI0_PIN15(N21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15(0x020E0160)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN15
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN15
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXC
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO17
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15(0x020E0474)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA00 to pad DISP0_DATA00(P24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00(0x020E0170)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA00
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA00
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SCLK
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO21
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA00_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00(0x020E0484)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA00_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA01 to pad DISP0_DATA01(P22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01(0x020E0174)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA01
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA01
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_MOSI
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO22
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA01_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01(0x020E0488)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA01_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA02 to pad DISP0_DATA02(P23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02(0x020E0178)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA02
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA02
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_MISO
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO23
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA02_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02(0x020E048C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA02_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA03 to pad DISP0_DATA03(P21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03(0x020E017C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA03
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA03
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SS0
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO24
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA03_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03(0x020E0490)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA03_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA04 to pad DISP0_DATA04(P20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04(0x020E0180)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA04
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA04
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SS1
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA04_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04(0x020E0494)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA04_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA05 to pad DISP0_DATA05(R25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05(0x020E0184)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA05
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA05
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SS2
    //     ALT3 (3) - Select instance: audmux signal: AUD6_RXFS
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO26
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA05_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05(0x020E0498)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA05_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA06 to pad DISP0_DATA06(R23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06(0x020E0188)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA06
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA06
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_SS3
    //     ALT3 (3) - Select instance: audmux signal: AUD6_RXC
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO27
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA06_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06(0x020E049C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA06_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA07 to pad DISP0_DATA07(R24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07(0x020E018C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA07
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA07
    //     ALT2 (2) - Select instance: ecspi3 signal: ECSPI3_RDY
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA07_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07(0x020E04A0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA07_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA08 to pad DISP0_DATA08(R22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08(0x020E0190)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA08
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA08
    //     ALT2 (2) - Select instance: pwm1 signal: PWM1_OUT
    //     ALT3 (3) - Select instance: wdog1 signal: WDOG1_B
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO29
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA08_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08(0x020E04A4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA08_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA09 to pad DISP0_DATA09(T25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09(0x020E0194)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA09
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA09
    //     ALT2 (2) - Select instance: pwm2 signal: PWM2_OUT
    //     ALT3 (3) - Select instance: wdog2 signal: WDOG2_B
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO30
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA09_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09(0x020E04A8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA09_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA10 to pad DISP0_DATA10(R21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10(0x020E0198)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA10
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA10
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO31
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA10_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10(0x020E04AC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA10_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA11 to pad DISP0_DATA11(T23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11(0x020E019C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA11
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA11
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO05
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA11_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11(0x020E04B0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA11_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA12 to pad DISP0_DATA12(T24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12(0x020E01A0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA12
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA12
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO06
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA12_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12(0x020E04B4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA12_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA13 to pad DISP0_DATA13(R20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13(0x020E01A4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA13
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA13
    //     ALT3 (3) - Select instance: audmux signal: AUD5_RXFS
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO07
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA13_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13(0x020E04B8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA13_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA14 to pad DISP0_DATA14(U25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14(0x020E01A8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA14
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA14
    //     ALT3 (3) - Select instance: audmux signal: AUD5_RXC
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO08
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA14_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14(0x020E04BC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA14_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA15 to pad DISP0_DATA15(T22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15(0x020E01AC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA15
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA15
    //     ALT2 (2) - Select instance: ecspi1 signal: ECSPI1_SS1
    //     ALT3 (3) - Select instance: ecspi2 signal: ECSPI2_SS1
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO09
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA15_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15(0x020E04C0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA15_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA16 to pad DISP0_DATA16(T21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16(0x020E01B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA16
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA16
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT3 (3) - Select instance: audmux signal: AUD5_TXC
    //     ALT4 (4) - Select instance: sdma signal: SDMA_EXT_EVENT0
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO10
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16(0x020E04C4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_SRE_V(SLOW));

    // Config ipu1.IPU1_DISP0_DATA17 to pad DISP0_DATA17(U24)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17(0x020E01B4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA17
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA17
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_MISO
    //     ALT3 (3) - Select instance: audmux signal: AUD5_TXD
    //     ALT4 (4) - Select instance: sdma signal: SDMA_EXT_EVENT1
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO11
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA17_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17(0x020E04C8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA17_SRE_V(SLOW));
}
