/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: esai_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for esai module.
void esai_iomux_config(void)
{
    // Config esai.ESAI_RX_CLK to pad ENET_MDIO(V23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_RX_CLK_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO(0x020E01D0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_MDIO
    //     ALT2 (2) - Select instance: esai signal: ESAI_RX_CLK
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT1_OUT
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO22
    //     ALT6 (6) - Select instance: spdif signal: SPDIF_LOCK
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDIO_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO(0x020E04E4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDIO_SRE_V(SLOW));
    // Pad ENET_MDIO is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_RX_CLK_SELECT_INPUT(0x020E086C)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_MDIO_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_MDIO_ALT2 (0) - Select signal esai ESAI_RX_CLK as input from pad ENET_MDIO(ALT2).
    //     GPIO01_ALT0 (1) - Select signal esai ESAI_RX_CLK as input from pad GPIO01(ALT0).
    HW_IOMUXC_ESAI_RX_CLK_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_RX_CLK_SELECT_INPUT_DAISY_V(ENET_MDIO_ALT2));

    // Config esai.ESAI_RX_FS to pad GPIO09(T2)
    // HW_IOMUXC_SW_MUX_CTL_PAD_GPIO09_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_GPIO09_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_RX_FS_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_GPIO09(0x020E0228)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: esai signal: ESAI_RX_FS
    //     ALT1 (1) - Select instance: wdog1 signal: WDOG1_B
    //     ALT2 (2) - Select instance: kpp signal: KEY_COL6
    //     ALT3 (3) - Select instance: ccm signal: CCM_REF_EN_B
    //     ALT4 (4) - Select instance: pwm1 signal: PWM1_OUT
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO09
    //     ALT6 (6) - Select instance: usdhc1 signal: SD1_WP
    HW_IOMUXC_SW_MUX_CTL_PAD_GPIO09_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO09_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO09_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_GPIO09(0x020E05F8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_GPIO09_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO09_SRE_V(SLOW));
    // Pad GPIO09 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_RX_FS_SELECT_INPUT(0x020E085C)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_REF_CLK_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_REF_CLK_ALT2 (0) - Select signal esai ESAI_RX_FS as input from pad ENET_REF_CLK(ALT2).
    //     GPIO09_ALT0 (1) - Select signal esai ESAI_RX_FS as input from pad GPIO09(ALT0).
    HW_IOMUXC_ESAI_RX_FS_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_RX_FS_SELECT_INPUT_DAISY_V(GPIO09_ALT0));

    // Config esai.ESAI_TX0 to pad GPIO17(R1)
    // HW_IOMUXC_SW_MUX_CTL_PAD_GPIO17_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_GPIO17_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO0_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_GPIO17(0x020E024C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: esai signal: ESAI_TX0
    //     ALT1 (1) - Select instance: enet signal: ENET_1588_EVENT3_IN
    //     ALT2 (2) - Select instance: ccm signal: CCM_PMIC_READY
    //     ALT3 (3) - Select instance: sdma signal: SDMA_EXT_EVENT0
    //     ALT4 (4) - Select instance: spdif signal: SPDIF_OUT
    //     ALT5 (5) - Select instance: gpio7 signal: GPIO7_IO12
    HW_IOMUXC_SW_MUX_CTL_PAD_GPIO17_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO17_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO17_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_GPIO17(0x020E061C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_GPIO17_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO17_SRE_V(SLOW));
    // Pad GPIO17 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO0_SELECT_INPUT(0x020E0874)
    //   DAISY [0] - MUX Mode Select Field Reset: GPIO17_ALT0
    //               Selecting Pads Involved in Daisy Chain.
    //     GPIO17_ALT0 (0) - Select signal esai ESAI_TX0 as input from pad GPIO17(ALT0).
    //     NAND_CS2_B_ALT2 (1) - Select signal esai ESAI_TX0 as input from pad NAND_CS2_B(ALT2).
    HW_IOMUXC_ESAI_SDO0_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO0_SELECT_INPUT_DAISY_V(GPIO17_ALT0));

    // Config esai.ESAI_TX1 to pad NAND_CS3_B(D16)
    // HW_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO1_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B(0x020E02F0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: gpmi signal: NAND_CE3_B
    //     ALT1 (1) - Select instance: ipu1 signal: IPU1_SISG1
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX1
    //     ALT3 (3) - Select instance: eim signal: EIM_ADDR26
    //     ALT5 (5) - Select instance: gpio6 signal: GPIO6_IO16
    //     ALT6 (6) - Select instance: ipu2 signal: IPU2_SISG1
    HW_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_NAND_CS3_B_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B(0x020E06D8)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_NAND_CS3_B_SRE_V(SLOW));
    // Pad NAND_CS3_B is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO1_SELECT_INPUT(0x020E0878)
    //   DAISY [0] - MUX Mode Select Field Reset: GPIO18_ALT0
    //               Selecting Pads Involved in Daisy Chain.
    //     GPIO18_ALT0 (0) - Select signal esai ESAI_TX1 as input from pad GPIO18(ALT0).
    //     NAND_CS3_B_ALT2 (1) - Select signal esai ESAI_TX1 as input from pad NAND_CS3_B(ALT2).
    HW_IOMUXC_ESAI_SDO1_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO1_SELECT_INPUT_DAISY_V(NAND_CS3_B_ALT2));

    // Config esai.ESAI_TX2_RX3 to pad GPIO05(R4)
    // HW_IOMUXC_SW_MUX_CTL_PAD_GPIO05_WR(0x00000000);
    // HW_IOMUXC_SW_PAD_CTL_PAD_GPIO05_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT_WR(0x00000001);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_GPIO05(0x020E023C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: esai signal: ESAI_TX2_RX3
    //     ALT2 (2) - Select instance: kpp signal: KEY_ROW7
    //     ALT3 (3) - Select instance: ccm signal: CCM_CLKO1
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO05
    //     ALT6 (6) - Select instance: i2c3 signal: I2C3_SCL
    //     ALT7 (7) - Select instance: arm signal: ARM_EVENTI
    HW_IOMUXC_SW_MUX_CTL_PAD_GPIO05_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO05_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_GPIO05_MUX_MODE_V(ALT0));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_GPIO05(0x020E060C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_GPIO05_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_GPIO05_SRE_V(SLOW));
    // Pad GPIO05 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT(0x020E087C)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_TX_DATA1_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_TX_DATA1_ALT2 (0) - Select signal esai ESAI_TX2_RX3 as input from pad ENET_TX_DATA1(ALT2).
    //     GPIO05_ALT0 (1) - Select signal esai ESAI_TX2_RX3 as input from pad GPIO05(ALT0).
    HW_IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO2_SDI3_SELECT_INPUT_DAISY_V(GPIO05_ALT0));

    // Config esai.ESAI_TX3_RX2 to pad ENET_TX_EN(V21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN(0x020E01E8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_TX_EN
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX3_RX2
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO28
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_EN_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN(0x020E04FC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_EN_SRE_V(SLOW));
    // Pad ENET_TX_EN is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT(0x020E0880)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_TX_EN_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_TX_EN_ALT2 (0) - Select signal esai ESAI_TX3_RX2 as input from pad ENET_TX_EN(ALT2).
    //     GPIO16_ALT0 (1) - Select signal esai ESAI_TX3_RX2 as input from pad GPIO16(ALT0).
    HW_IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO3_SDI2_SELECT_INPUT_DAISY_V(ENET_TX_EN_ALT2));

    // Config esai.ESAI_TX4_RX1 to pad ENET_TX_DATA0(U20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0(0x020E01F0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_TX_DATA0
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX4_RX1
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO30
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_TX_DATA0_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0(0x020E0504)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_TX_DATA0_SRE_V(SLOW));
    // Pad ENET_TX_DATA0 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT(0x020E0884)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_TX_DATA0_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_TX_DATA0_ALT2 (0) - Select signal esai ESAI_TX4_RX1 as input from pad ENET_TX_DATA0(ALT2).
    //     GPIO07_ALT0 (1) - Select signal esai ESAI_TX4_RX1 as input from pad GPIO07(ALT0).
    HW_IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO4_SDI1_SELECT_INPUT_DAISY_V(ENET_TX_DATA0_ALT2));

    // Config esai.ESAI_TX5_RX0 to pad ENET_MDC(V20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_MDC(0x020E01F4)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mlb signal: MLB_DATA
    //     ALT1 (1) - Select instance: enet signal: ENET_MDC
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX5_RX0
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT1_IN
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO31
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_MDC_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_MDC(0x020E0508)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_MDC_SRE_V(SLOW));
    // Pad ENET_MDC is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT(0x020E0888)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_MDC_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_MDC_ALT2 (0) - Select signal esai ESAI_TX5_RX0 as input from pad ENET_MDC(ALT2).
    //     GPIO08_ALT0 (1) - Select signal esai ESAI_TX5_RX0 as input from pad GPIO08(ALT0).
    HW_IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_SDO5_SDI0_SELECT_INPUT_DAISY_V(ENET_MDC_ALT2));

    // Config esai.ESAI_TX_CLK to pad ENET_CRS_DV(U21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_TX_CLK_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV(0x020E01DC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT1 (1) - Select instance: enet signal: ENET_RX_EN
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX_CLK
    //     ALT3 (3) - Select instance: spdif signal: SPDIF_EXT_CLK
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO25
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_CRS_DV_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV(0x020E04F0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //                 NOTE: Read Only Field
    //                 The value of this field is fixed and cannot be changed.
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_CRS_DV_SRE_V(SLOW));
    // Pad ENET_CRS_DV is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_TX_CLK_SELECT_INPUT(0x020E0870)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_CRS_DV_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_CRS_DV_ALT2 (0) - Select signal esai ESAI_TX_CLK as input from pad ENET_CRS_DV(ALT2).
    //     GPIO06_ALT0 (1) - Select signal esai ESAI_TX_CLK as input from pad GPIO06(ALT0).
    HW_IOMUXC_ESAI_TX_CLK_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_TX_CLK_SELECT_INPUT_DAISY_V(ENET_CRS_DV_ALT2));

    // Config esai.ESAI_TX_FS to pad ENET_RX_DATA1(W22)
    // HW_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_WR(0x0001B0B0);
    // HW_IOMUXC_ESAI_TX_FS_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1(0x020E01E0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: mlb signal: MLB_SIG
    //     ALT1 (1) - Select instance: enet signal: ENET_RX_DATA1
    //     ALT2 (2) - Select instance: esai signal: ESAI_TX_FS
    //     ALT4 (4) - Select instance: enet signal: ENET_1588_EVENT3_OUT
    //     ALT5 (5) - Select instance: gpio1 signal: GPIO1_IO26
    HW_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_ENET_RX_DATA1_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1(0x020E04F4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_ENET_RX_DATA1_SRE_V(SLOW));
    // Pad ENET_RX_DATA1 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_ESAI_TX_FS_SELECT_INPUT(0x020E0860)
    //   DAISY [0] - MUX Mode Select Field Reset: ENET_RX_DATA1_ALT2
    //               Selecting Pads Involved in Daisy Chain.
    //     ENET_RX_DATA1_ALT2 (0) - Select signal esai ESAI_TX_FS as input from pad ENET_RX_DATA1(ALT2).
    //     GPIO02_ALT0 (1) - Select signal esai ESAI_TX_FS as input from pad GPIO02(ALT0).
    HW_IOMUXC_ESAI_TX_FS_SELECT_INPUT_WR(
            BF_IOMUXC_ESAI_TX_FS_SELECT_INPUT_DAISY_V(ENET_RX_DATA1_ALT2));
}
