/*
 * Copyright (c) 2012, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// File: audmux_iomux_config.c

/* ------------------------------------------------------------------------------
 * <auto-generated>
 *     This code was generated by a tool.
 *     Runtime Version:3.4.0.0
 *
 *     Changes to this file may cause incorrect behavior and will be lost if
 *     the code is regenerated.
 * </auto-generated>
 * ------------------------------------------------------------------------------
*/

#include "iomux_config.h"
#include "registers/regsiomuxc.h"

// Function to configure IOMUXC for audmux module.
void audmux_iomux_config(void)
{
    // Config audmux.AUD5_RXD to pad DISP0_DATA19(U23)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19_WR(0x00000003);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_WR(0x0001B0B0);
    // HW_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19(0x020E01BC)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA19
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA19
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_SCLK
    //     ALT3 (3) - Select instance: audmux signal: AUD5_RXD
    //     ALT4 (4) - Select instance: audmux signal: AUD4_RXC
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO13
    //     ALT7 (7) - Select instance: eim signal: EIM_CS3
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA19_MUX_MODE_V(ALT3));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19(0x020E04D0)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA19_SRE_V(SLOW));
    // Pad DISP0_DATA19 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT(0x020E07CC)
    //   DAISY [0] - MUX Mode Select Field Reset: DISP0_DATA19_ALT3
    //               Selecting Pads Involved in Daisy Chain.
    //     DISP0_DATA19_ALT3 (0) - Select signal audmux AUD5_RXD as input from pad DISP0_DATA19(ALT3).
    //     KEY_ROW1_ALT2 (1) - Select signal audmux AUD5_RXD as input from pad KEY_ROW1(ALT2).
    HW_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT_WR(
            BF_IOMUXC_AUD5_INPUT_DA_AMX_SELECT_INPUT_DAISY_V(DISP0_DATA19_ALT3));

    // Config audmux.AUD5_TXC to pad DISP0_DATA16(T21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_WR(0x00000003);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_WR(0x0001B0B0);
    // HW_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16(0x020E01B0)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA16
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA16
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_MOSI
    //     ALT3 (3) - Select instance: audmux signal: AUD5_TXC
    //     ALT4 (4) - Select instance: sdma signal: SDMA_EXT_EVENT0
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO10
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA16_MUX_MODE_V(ALT3));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16(0x020E04C4)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA16_SRE_V(SLOW));
    // Pad DISP0_DATA16 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT(0x020E07DC)
    //   DAISY [0] - MUX Mode Select Field Reset: DISP0_DATA16_ALT3
    //               Selecting Pads Involved in Daisy Chain.
    //     DISP0_DATA16_ALT3 (0) - Select signal audmux AUD5_TXC as input from pad DISP0_DATA16(ALT3).
    //     KEY_COL0_ALT2 (1) - Select signal audmux AUD5_TXC as input from pad KEY_COL0(ALT2).
    HW_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT_WR(
            BF_IOMUXC_AUD5_INPUT_TXCLK_AMX_SELECT_INPUT_DAISY_V(DISP0_DATA16_ALT3));

    // Config audmux.AUD5_TXFS to pad DISP0_DATA18(V25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18_WR(0x00000003);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_WR(0x0001B0B0);
    // HW_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT_WR(0x00000000);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18(0x020E01B8)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DISP0_DATA18
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DISP0_DATA18
    //     ALT2 (2) - Select instance: ecspi2 signal: ECSPI2_SS0
    //     ALT3 (3) - Select instance: audmux signal: AUD5_TXFS
    //     ALT4 (4) - Select instance: audmux signal: AUD4_RXFS
    //     ALT5 (5) - Select instance: gpio5 signal: GPIO5_IO12
    //     ALT7 (7) - Select instance: eim signal: EIM_CS2
    HW_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DISP0_DATA18_MUX_MODE_V(ALT3));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18(0x020E04CC)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DISP0_DATA18_SRE_V(SLOW));
    // Pad DISP0_DATA18 is involved in Daisy Chain.
    // Input Select Register:
    // IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT(0x020E07E0)
    //   DAISY [0] - MUX Mode Select Field Reset: DISP0_DATA18_ALT3
    //               Selecting Pads Involved in Daisy Chain.
    //     DISP0_DATA18_ALT3 (0) - Select signal audmux AUD5_TXFS as input from pad DISP0_DATA18(ALT3).
    //     KEY_COL1_ALT2 (1) - Select signal audmux AUD5_TXFS as input from pad KEY_COL1(ALT2).
    HW_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT_WR(
            BF_IOMUXC_AUD5_INPUT_TXFS_AMX_SELECT_INPUT_DAISY_V(DISP0_DATA18_ALT3));

    // Config audmux.AUD6_RXD to pad DI0_PIN04(P25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04(0x020E016C)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN04
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN04
    //     ALT2 (2) - Select instance: audmux signal: AUD6_RXD
    //     ALT3 (3) - Select instance: usdhc1 signal: SD1_WP
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO20
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN04_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04(0x020E0480)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN04_SRE_V(SLOW));

    // Config audmux.AUD6_TXC to pad DI0_PIN15(N21)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15(0x020E0160)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN15
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN15
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXC
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO17
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN15_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15(0x020E0474)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN15_SRE_V(SLOW));

    // Config audmux.AUD6_TXD to pad DI0_PIN02(N25)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02(0x020E0164)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN02
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN02
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXD
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO18
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN02_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02(0x020E0478)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN02_SRE_V(SLOW));

    // Config audmux.AUD6_TXFS to pad DI0_PIN03(N20)
    // HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_WR(0x00000002);
    // HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_WR(0x0001B0B0);
    // Mux Register:
    // IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03(0x020E0168)
    //   SION [4] - Software Input On Field Reset: DISABLED
    //              Force the selected mux mode Input path no matter of MUX_MODE functionality.
    //     DISABLED (0) - Input Path is determined by functionality of the selected mux mode (regular).
    //     ENABLED (1) - Force input path of pad.
    //   MUX_MODE [2:0] - MUX Mode Select Field Reset: ALT5
    //                    Select iomux modes to be used for pad.
    //     ALT0 (0) - Select instance: ipu1 signal: IPU1_DI0_PIN03
    //     ALT1 (1) - Select instance: ipu2 signal: IPU2_DI0_PIN03
    //     ALT2 (2) - Select instance: audmux signal: AUD6_TXFS
    //     ALT5 (5) - Select instance: gpio4 signal: GPIO4_IO19
    HW_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_WR(
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_SION_V(DISABLED) | 
            BF_IOMUXC_SW_MUX_CTL_PAD_DI0_PIN03_MUX_MODE_V(ALT2));
    // Pad Control Register:
    // IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03(0x020E047C)
    //   HYS [16] - Hysteresis Enable Field Reset: ENABLED
    //     DISABLED (0) - CMOS input
    //     ENABLED (1) - Schmitt trigger input
    //   PUS [15:14] - Pull Up / Down Config. Field Reset: 100K_OHM_PU
    //     100K_OHM_PD (0) - 100K Ohm Pull Down
    //     47K_OHM_PU (1) - 47K Ohm Pull Up
    //     100K_OHM_PU (2) - 100K Ohm Pull Up
    //     22K_OHM_PU (3) - 22K Ohm Pull Up
    //   PUE [13] - Pull / Keep Select Field Reset: PULL
    //     KEEP (0) - Keeper Enabled
    //     PULL (1) - Pull Enabled
    //   PKE [12] - Pull / Keep Enable Field Reset: ENABLED
    //     DISABLED (0) - Pull/Keeper Disabled
    //     ENABLED (1) - Pull/Keeper Enabled
    //   ODE [11] - Open Drain Enable Field Reset: DISABLED
    //              Enables open drain of the pin.
    //     DISABLED (0) - Output is CMOS.
    //     ENABLED (1) - Output is Open Drain.
    //   SPEED [7:6] - Speed Field Reset: 100MHZ
    //     TBD (0) - TBD
    //     50MHZ (1) - Low (50 MHz)
    //     100MHZ (2) - Medium (100 MHz)
    //     200MHZ (3) - Maximum (200 MHz)
    //   DSE [5:3] - Drive Strength Field Reset: 40_OHM
    //     HIZ (0) - HI-Z
    //     240_OHM (1) - 240 Ohm
    //     120_OHM (2) - 120 Ohm
    //     80_OHM (3) - 80 Ohm
    //     60_OHM (4) - 60 Ohm
    //     48_OHM (5) - 48 Ohm
    //     40_OHM (6) - 40 Ohm
    //     34_OHM (7) - 34 Ohm
    //   SRE [0] - Slew Rate Field Reset: SLOW
    //             Slew rate control.
    //     SLOW (0) - Slow Slew Rate
    //     FAST (1) - Fast Slew Rate
    HW_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_WR(
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_HYS_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PUS_V(100K_OHM_PU) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PUE_V(PULL) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_PKE_V(ENABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_ODE_V(DISABLED) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_SPEED_V(100MHZ) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_DSE_V(40_OHM) | 
            BF_IOMUXC_SW_PAD_CTL_PAD_DI0_PIN03_SRE_V(SLOW));
}
