/*
 *  This file is part of FH8620 BSP for RT-Thread distribution.
 *
 *	Copyright (c) 2016 Shanghai Fullhan Microelectronics Co., Ltd. 
 *	All rights reserved
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *	Visit http://www.fullhan.com to get contact with Fullhan.
 *
 * Change Logs:
 * Date           Author       Notes
 */
 
#include "rtdef.h"
#include "iomux.h"
#include "rtconfig.h"


Iomux_Pad fh_iomux_cfg[] = {
		{
			.func_name = { "RESETN", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = -1,
		},
		{
			.func_name = { "TEST", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = -1,
		},
		{
			.func_name = { "CIS_CLK", "", "", "", },
			.reg_type  = 5,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_HSYNC", "GPIO20", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_VSYNC", "GPIO21", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_PCLK", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 0,
		},
		{
			.func_name = { "CIS_D0", "GPIO22", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D1", "GPIO23", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D2", "GPIO24", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D3", "GPIO25", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D4", "GPIO26", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D5", "GPIO27", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D6", "GPIO28", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D7", "GPIO29", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D8", "GPIO30", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D9", "GPIO31", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D10", "GPIO32", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_D11", "GPIO33", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_REF_CLK", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 3,
		},
		{
			.func_name = { "MAC_MDC", "GPIO34", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 0,
		},
		{
			.func_name = { "MAC_MDIO", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_COL", "GPIO35", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_CRS", "GPIO36", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_RXCK", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = -1,
		},
		{
			.func_name = { "MAC_RXD0", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = -1,
		},

		{
			.func_name = { "MAC_RXD1", "GPIO38", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_RXD2", "GPIO39", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_RXD3", "GPIO40", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_RXDV", "GPIO41", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_TXCK", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = -1,
		},
		{
			.func_name = { "MAC_TXD0", "GPIO42", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_TXD1", "GPIO43", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_TXD2", "GPIO44", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_TXD3", "GPIO45", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_TXEN", "GPIO46", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "MAC_RXER", "GPIO47", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO0", "ARC_JTAG_TCK", "GPIO0", "CIS_SSI0_CSN1", },
			.reg_type  = 21,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO1", "ARC_JTAG_TRSTN", "GPIO1", "CIS_SSI0_RXD", },
			.reg_type  = 21,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO2", "ARC_JTAG_TMS", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO3", "ARC_JTAG_TDI", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO4", "ARC_JTAG_TDO", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "JTAG_TCK", "GPIO5", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "JTAG_TRSTN", "GPIO6", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "JTAG_TMS", "GPIO7", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "JTAG_TDI", "GPIO8", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "JTAG_TDO", "GPIO9", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO10", "UART1_OUT", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO11", "UART1_IN", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO12", "PWM_OUT0", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO13", "PWM_OUT1", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "GPIO14", "PWM_OUT2", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "UART0_IN", "GPIO48", "UART0_IN", " I2S_WS", },
			.reg_type  = 21,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 1,
		},
		{
			.func_name = { "UART0_OUT", "GPIO49", "UART0_OUT", "I2S_CLK", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_SCL", "GPIO56", "CIS_SCL", "CIS_SSI0_CLK", },
			.reg_type  = 13,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "CIS_SDA", "GPIO57", "CIS_SDA", "CIS_SSI0_TXD", },
			.reg_type  = 13,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SCL1", "GPIO50", "SCL1", "I2S_DI", },
			.reg_type  = 21,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SDA1", "GPIO51", "I2S_DO", "", },
			.reg_type  = 21,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SSI0_CLK", "", "", "", },
			.reg_type  = 5,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SSI0_TXD", "", "", "", },
			.reg_type  = 5,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SSI0_CSN0", "GPIO54", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SSI0_CSN1", "GPIO55", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SSI0_RXD", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = -1,
		},
		{
			.func_name = { "SD0_CD", "GPIO52", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SD0_WP", "GPIO53", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SD0_CLK", "", "", "", },
			.reg_type  = 5,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD0_CMD_RSP", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD0_DATA0", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD0_DATA1", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 2,
		},
		{
			.func_name = { "SD0_DATA2", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD0_DATA3", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD1_CLK", "SSI1_CLK", "", "", },
			.reg_type  = 8,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_NONE,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SD1_CD", "GPIO_58", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SD1_WP", "GPIO_59", "", "", },
			.reg_type  = 20,
	        .func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
		{
			.func_name = { "SD1_DATA0", "SSI1_TXD", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD1_DATA1", "SSI1_CSN0", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD1_DATA2", "SSI1_CSN1", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD1_DATA3", "", "", "", },
			.reg_type  = 17,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "SD1_CMD_RSP", "SSI1_RXD", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = 3,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "CLK_SW0", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = -1,
		},
		{
			.func_name = { "CLK_SW1", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = -1,
		},
		{
			.func_name = { "CLK_SW2", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = -1,
		},
		{
			.func_name = { "CLK_SW3", "", "", "", },
			.reg_type  = 9,
			.func_sel  = 0,
			.pupd 	   = IOMUX_PUPD_UP,
			.drv_cur   = -1,
		},
		{
			.func_name = { "RESERVED", "", "", "", },
			.reg_type  = 20,
			.func_sel  = 0,
		},
		{
			.func_name = { "MAC_TXER", "GPIO37", "", "", },
			.reg_type  = 20,
			.func_sel  = 1,
			.pupd 	   = IOMUX_PUPD_DOWN,
			.drv_cur   = 1,
		},
};


const int fh_iomux_cfg_count = ARRAY_SIZE(fh_iomux_cfg);
