#ifndef SERIAL_REG_H
#define SERIAL_REG_H

/** @brief Base addresses of UART memory mapped registers                     */
#define UART0_BASE                  (0x44E09000)
#define UART1_BASE                  (0x48022000)
#define UART2_BASE                  (0x48024000)
#define UART3_BASE                  (0x481A6000)
#define UART4_BASE                  (0x481A8000)
#define UART5_BASE                  (0x481AA000)

/* UART registers */
#define UART_DLL(base)               (base + 0x0)
#define UART_RHR(base)               (base + 0x0)
#define UART_THR(base)               (base + 0x0)
#define UART_DLH(base)               (base + 0x4)
#define UART_IER(base)               (base + 0x4)
#define UART_EFR(base)               (base + 0x8)
#define UART_FCR(base)               (base + 0x8)
#define UART_IIR(base)               (base + 0x8)
#define UART_LCR(base)               (base + 0xC)
#define UART_MCR(base)               (base + 0x10)
#define UART_XON1_ADDR1(base)        (base + 0x10)
#define UART_LSR(base)               (base + 0x14)
#define UART_XON2_ADDR2(base)        (base + 0x14)
#define UART_MSR(base)               (base + 0x18)
#define UART_TCR(base)               (base + 0x18)
#define UART_XOFF1(base)             (base + 0x18)
#define UART_SPR(base)               (base + 0x1C)
#define UART_TLR(base)               (base + 0x1C)
#define UART_XOFF2(base)             (base + 0x1C)
#define UART_MDR1(base)              (base + 0x20)
#define UART_MDR2(base)              (base + 0x24)
#define UART_SFLSR(base)             (base + 0x28)
#define UART_TXFLL(base)             (base + 0x28)
#define UART_RESUME(base)            (base + 0x2C)
#define UART_TXFLH(base)             (base + 0x2C)
#define UART_RXFLL(base)             (base + 0x30)
#define UART_SFREGL(base)            (base + 0x30)
#define UART_RXFLH(base)             (base + 0x34)
#define UART_SFREGH(base)            (base + 0x34)
#define UART_BLR(base)               (base + 0x38)
#define UART_UASR(base)              (base + 0x38)
#define UART_ACREG(base)             (base + 0x3C)
#define UART_SCR(base)               (base + 0x40)
#define UART_SSR(base)               (base + 0x44)
#define UART_EBLR(base)              (base + 0x48)
#define UART_MVR(base)               (base + 0x50)
#define UART_SYSC(base)              (base + 0x54)
#define UART_SYSS(base)              (base + 0x58)
#define UART_WER(base)               (base + 0x5C)
#define UART_CFPS(base)              (base + 0x60)
#define UART_RXFIFO_LVL(base)        (base + 0x64)
#define UART_TXFIFO_LVL(base)        (base + 0x68)
#define UART_IER2(base)              (base + 0x6C)
#define UART_ISR2(base)              (base + 0x70)
#define UART_FREQ_SEL(base)          (base + 0x74)
#define UART_MDR3(base)              (base + 0x80)
#define UART_TX_DMA_THRESHOLD(base)  (base + 0x84)

#define UART_DLL_REG(base)               REG16(UART_DLL(base))
#define UART_RHR_REG(base)               REG16(UART_RHR(base))
#define UART_THR_REG(base)               REG16(UART_THR(base))
#define UART_DLH_REG(base)               REG16(UART_DLH(base))
#define UART_IER_REG(base)               REG16(UART_IER(base))
#define UART_EFR_REG(base)               REG16(UART_EFR(base))
#define UART_FCR_REG(base)               REG16(UART_FCR(base))
#define UART_IIR_REG(base)               REG16(UART_IIR(base))
#define UART_LCR_REG(base)               REG16(UART_LCR(base))
#define UART_MCR_REG(base)               REG16(UART_MCR(base))
#define UART_XON1_ADDR1_REG(base)        REG16(UART_XON1_ADDR1(base))
#define UART_LSR_REG(base)               REG16(UART_LSR(base))
#define UART_XON2_ADDR2_REG(base)        REG16(UART_XON2_ADDR2(base))
#define UART_MSR_REG(base)               REG16(UART_MSR(base))
#define UART_TCR_REG(base)               REG16(UART_TCR(base))
#define UART_XOFF1_REG(base)             REG16(UART_XOFF1(base))
#define UART_SPR_REG(base)               REG16(UART_SPR(base))
#define UART_TLR_REG(base)               REG16(UART_TLR(base))
#define UART_XOFF2_REG(base)             REG16(UART_XOFF2(base))
#define UART_MDR1_REG(base)              REG16(UART_MDR1(base))
#define UART_MDR2_REG(base)              REG16(UART_MDR2(base))
#define UART_SFLSR_REG(base)             REG16(UART_SFLSR(base))
#define UART_TXFLL_REG(base)             REG16(UART_TXFLL(base))
#define UART_RESUME_REG(base)            REG16(UART_RESUME(base))
#define UART_TXFLH_REG(base)             REG16(UART_TXFLH(base))
#define UART_RXFLL_REG(base)             REG16(UART_RXFLL(base))
#define UART_SFREGL_REG(base)            REG16(UART_SFREGL(base))
#define UART_RXFLH_REG(base)             REG16(UART_RXFLH(base))
#define UART_SFREGH_REG(base)            REG16(UART_SFREGH(base))
#define UART_BLR_REG(base)               REG16(UART_BLR(base))
#define UART_UASR_REG(base)              REG16(UART_UASR(base))
#define UART_ACREG_REG(base)             REG16(UART_ACREG(base))
#define UART_SCR_REG(base)               REG16(UART_SCR(base))
#define UART_SSR_REG(base)               REG16(UART_SSR(base))
#define UART_EBLR_REG(base)              REG16(UART_EBLR(base))
#define UART_MVR_REG(base)               REG16(UART_MVR(base))
#define UART_SYSC_REG(base)              REG16(UART_SYSC(base))
#define UART_SYSS_REG(base)              REG16(UART_SYSS(base))
#define UART_WER_REG(base)               REG16(UART_WER(base))
#define UART_CFPS_REG(base)              REG16(UART_CFPS(base))
#define UART_RXFIFO_LVL_REG(base)        REG16(UART_RXFIFO_LVL(base))
#define UART_TXFIFO_LVL_REG(base)        REG16(UART_TXFIFO_LVL(base))
#define UART_IER2_REG(base)              REG16(UART_IER2(base))
#define UART_ISR2_REG(base)              REG16(UART_ISR2(base))
#define UART_FREQ_SEL_REG(base)          REG16(UART_FREQ_SEL(base))
#define UART_MDR3_REG(base)              REG16(UART_MDR3(base))
#define UART_TX_DMA_THRESHOLD_REG(base)  REG16(UART_TX_DMA_THRESHOLD(base))

#endif /* end of include guard: SERIAL_REG_H */
