
;    This is the include file that defines all constants and types for
;    accessing the Disk device.

ifndef _NTDDDISK_H_
_NTDDDISK_H_ equ 1

IOCTL_DISK_BASE                 equ FILE_DEVICE_DISK
IOCTL_DISK_GET_DRIVE_GEOMETRY   equ CTL_CODE(IOCTL_DISK_BASE, 0000, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_GET_PARTITION_INFO   equ CTL_CODE(IOCTL_DISK_BASE, 0001, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_PARTITION_INFO   equ CTL_CODE(IOCTL_DISK_BASE, 0002, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_GET_DRIVE_LAYOUT     equ CTL_CODE(IOCTL_DISK_BASE, 0003, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_DRIVE_LAYOUT     equ CTL_CODE(IOCTL_DISK_BASE, 0004, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_VERIFY               equ CTL_CODE(IOCTL_DISK_BASE, 0005, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_FORMAT_TRACKS        equ CTL_CODE(IOCTL_DISK_BASE, 0006, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_REASSIGN_BLOCKS      equ CTL_CODE(IOCTL_DISK_BASE, 0007, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_PERFORMANCE          equ CTL_CODE(IOCTL_DISK_BASE, 0008, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_IS_WRITABLE          equ CTL_CODE(IOCTL_DISK_BASE, 0009, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_LOGGING              equ CTL_CODE(IOCTL_DISK_BASE, 000ah, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_FORMAT_TRACKS_EX     equ CTL_CODE(IOCTL_DISK_BASE, 000bh, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_HISTOGRAM_STRUCTURE  equ CTL_CODE(IOCTL_DISK_BASE, 000ch, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_HISTOGRAM_DATA       equ CTL_CODE(IOCTL_DISK_BASE, 000dh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_HISTOGRAM_RESET      equ CTL_CODE(IOCTL_DISK_BASE, 000eh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_REQUEST_STRUCTURE    equ CTL_CODE(IOCTL_DISK_BASE, 000fh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_REQUEST_DATA         equ CTL_CODE(IOCTL_DISK_BASE, 0010h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_PERFORMANCE_OFF      equ CTL_CODE(IOCTL_DISK_BASE, 0018h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_CONTROLLER_NUMBER    equ CTL_CODE(IOCTL_DISK_BASE, 0011h, METHOD_BUFFERED, FILE_ANY_ACCESS)

SMART_GET_VERSION               equ CTL_CODE(IOCTL_DISK_BASE, 0020h, METHOD_BUFFERED, FILE_READ_ACCESS)
SMART_SEND_DRIVE_COMMAND        equ CTL_CODE(IOCTL_DISK_BASE, 0021h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
SMART_RCV_DRIVE_DATA            equ CTL_CODE(IOCTL_DISK_BASE, 0022h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

IOCTL_DISK_GET_PARTITION_INFO_EX    equ CTL_CODE(IOCTL_DISK_BASE, 0012h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_SET_PARTITION_INFO_EX    equ CTL_CODE(IOCTL_DISK_BASE, 0013h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_GET_DRIVE_LAYOUT_EX      equ CTL_CODE(IOCTL_DISK_BASE, 0014h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_SET_DRIVE_LAYOUT_EX      equ CTL_CODE(IOCTL_DISK_BASE, 0015h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_CREATE_DISK              equ CTL_CODE(IOCTL_DISK_BASE, 0016h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_GET_LENGTH_INFO          equ CTL_CODE(IOCTL_DISK_BASE, 0017h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_GET_DRIVE_GEOMETRY_EX    equ CTL_CODE(IOCTL_DISK_BASE, 0028h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_UPDATE_DRIVE_SIZE        equ CTL_CODE(IOCTL_DISK_BASE, 0032h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_GROW_PARTITION           equ CTL_CODE(IOCTL_DISK_BASE, 0034h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

IOCTL_DISK_GET_CACHE_INFORMATION    equ CTL_CODE(IOCTL_DISK_BASE, 0035h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_CACHE_INFORMATION    equ CTL_CODE(IOCTL_DISK_BASE, 0036h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
; IOCTL_DISK_GET_WRITE_CACHE_STATE defined in header as OBSOLETE_DISK_GET_WRITE_CACHE_STATE
IOCTL_DISK_GET_WRITE_CACHE_STATE    equ CTL_CODE(IOCTL_DISK_BASE, 0037h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_DISK_DELETE_DRIVE_LAYOUT      equ CTL_CODE(IOCTL_DISK_BASE, 0040h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

IOCTL_DISK_UPDATE_PROPERTIES    equ CTL_CODE(IOCTL_DISK_BASE, 0050h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_FORMAT_DRIVE         equ CTL_CODE(IOCTL_DISK_BASE, 00f3h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_SENSE_DEVICE         equ CTL_CODE(IOCTL_DISK_BASE, 00f8h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_GET_CACHE_SETTING    equ CTL_CODE(IOCTL_DISK_BASE, 0038h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_CACHE_SETTING    equ CTL_CODE(IOCTL_DISK_BASE, 0039h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

IOCTL_DISK_COPY_DATA            equ CTL_CODE(IOCTL_DISK_BASE, 0019h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

IOCTL_DISK_INTERNAL_SET_VERIFY   equ CTL_CODE(IOCTL_DISK_BASE, 0100h, METHOD_NEITHER, FILE_ANY_ACCESS)
IOCTL_DISK_INTERNAL_CLEAR_VERIFY equ CTL_CODE(IOCTL_DISK_BASE, 0101h, METHOD_NEITHER, FILE_ANY_ACCESS)

IOCTL_DISK_INTERNAL_SET_NOTIFY   equ CTL_CODE(IOCTL_DISK_BASE, 0102h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_CHECK_VERIFY     equ CTL_CODE(IOCTL_DISK_BASE, 0200h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_MEDIA_REMOVAL    equ CTL_CODE(IOCTL_DISK_BASE, 0201h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_EJECT_MEDIA      equ CTL_CODE(IOCTL_DISK_BASE, 0202h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_LOAD_MEDIA       equ CTL_CODE(IOCTL_DISK_BASE, 0203h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_RESERVE          equ CTL_CODE(IOCTL_DISK_BASE, 0204h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_RELEASE          equ CTL_CODE(IOCTL_DISK_BASE, 0205h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_FIND_NEW_DEVICES equ CTL_CODE(IOCTL_DISK_BASE, 0206h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_GET_MEDIA_TYPES  equ CTL_CODE(IOCTL_DISK_BASE, 0300h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_DISK_SIMBAD           equ CTL_CODE(IOCTL_DISK_BASE, 0400h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

endif ; _NTDDDISK_H_
