
;    This module contains structures and definitions
;    associated with CDROM IOCTls.

ifndef _NTDDCDRM_
_NTDDCDRM_ equ 1

IOCTL_CDROM_BASE                  equ FILE_DEVICE_CD_ROM

IOCTL_CDROM_UNLOAD_DRIVER         equ CTL_CODE(IOCTL_CDROM_BASE, 0402h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_CDROM_READ_TOC              equ CTL_CODE(IOCTL_CDROM_BASE, 0000h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_SEEK_AUDIO_MSF        equ CTL_CODE(IOCTL_CDROM_BASE, 0001h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_STOP_AUDIO            equ CTL_CODE(IOCTL_CDROM_BASE, 0002h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_PAUSE_AUDIO           equ CTL_CODE(IOCTL_CDROM_BASE, 0003h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_RESUME_AUDIO          equ CTL_CODE(IOCTL_CDROM_BASE, 0004h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_GET_VOLUME            equ CTL_CODE(IOCTL_CDROM_BASE, 0005h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_PLAY_AUDIO_MSF        equ CTL_CODE(IOCTL_CDROM_BASE, 0006h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_SET_VOLUME            equ CTL_CODE(IOCTL_CDROM_BASE, 000Ah, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_READ_Q_CHANNEL        equ CTL_CODE(IOCTL_CDROM_BASE, 000Bh, METHOD_BUFFERED, FILE_READ_ACCESS)
; IOCTL_CDROM_GET_CONTROL is obsolete
IOCTL_CDROM_GET_CONTROL           equ CTL_CODE(IOCTL_CDROM_BASE, 000Dh, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_GET_LAST_SESSION      equ CTL_CODE(IOCTL_CDROM_BASE, 000Eh, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_RAW_READ              equ CTL_CODE(IOCTL_CDROM_BASE, 000Fh, METHOD_OUT_DIRECT, FILE_READ_ACCESS)
IOCTL_CDROM_DISK_TYPE             equ CTL_CODE(IOCTL_CDROM_BASE, 0010h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_CDROM_GET_DRIVE_GEOMETRY    equ CTL_CODE(IOCTL_CDROM_BASE, 0013h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_GET_DRIVE_GEOMETRY_EX equ CTL_CODE(IOCTL_CDROM_BASE, 0014h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_CDROM_READ_TOC_EX           equ CTL_CODE(IOCTL_CDROM_BASE, 0015h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_GET_CONFIGURATION     equ CTL_CODE(IOCTL_CDROM_BASE, 0016h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_CDROM_CHECK_VERIFY     equ CTL_CODE(IOCTL_CDROM_BASE, 0200h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_MEDIA_REMOVAL    equ CTL_CODE(IOCTL_CDROM_BASE, 0201h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_EJECT_MEDIA      equ CTL_CODE(IOCTL_CDROM_BASE, 0202h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_LOAD_MEDIA       equ CTL_CODE(IOCTL_CDROM_BASE, 0203h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_RESERVE          equ CTL_CODE(IOCTL_CDROM_BASE, 0204h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_RELEASE          equ CTL_CODE(IOCTL_CDROM_BASE, 0205h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CDROM_FIND_NEW_DEVICES equ CTL_CODE(IOCTL_CDROM_BASE, 0206h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_CDROM_SIMBAD           equ CTL_CODE(IOCTL_CDROM_BASE, 1003h, METHOD_BUFFERED, FILE_READ_ACCESS)

endif ; _NTDDCDRM_
