comment ^
Module Name:
    winioctl.inc

Abstract:
    This module defines the 32-Bit Windows Device I/O control codes.

Author:
    Four-F (four-f@mail.ru)

Last updated:
	05-July-2004
^

IFNDEF _WINIOCTL_
_WINIOCTL_ equ 1


IFNDEF _DEVIOCTL_
_DEVIOCTL_ equ 1

; Define the various device type values.  Note that values used by Microsoft
; Corporation are in the range 0-32767, and 32768-65535 are reserved for use
; by customers.

DEVICE_TYPE	typedef	DWORD

FILE_DEVICE_BEEP                equ 01h
FILE_DEVICE_CD_ROM              equ 02h
FILE_DEVICE_CD_ROM_FILE_SYSTEM  equ 03h
FILE_DEVICE_CONTROLLER          equ 04h
FILE_DEVICE_DATALINK            equ 05h
FILE_DEVICE_DFS                 equ 06h
FILE_DEVICE_DISK                equ 07h
FILE_DEVICE_DISK_FILE_SYSTEM    equ 08h
FILE_DEVICE_FILE_SYSTEM         equ 09h
FILE_DEVICE_INPORT_PORT         equ 0ah
FILE_DEVICE_KEYBOARD            equ 0bh
FILE_DEVICE_MAILSLOT            equ 0ch
FILE_DEVICE_MIDI_IN             equ 0dh
FILE_DEVICE_MIDI_OUT            equ 0eh
FILE_DEVICE_MOUSE               equ 0fh
FILE_DEVICE_MULTI_UNC_PROVIDER  equ 10h
FILE_DEVICE_NAMED_PIPE          equ 11h
FILE_DEVICE_NETWORK             equ 12h
FILE_DEVICE_NETWORK_BROWSER     equ 13h
FILE_DEVICE_NETWORK_FILE_SYSTEM equ 14h
FILE_DEVICE_NULL                equ 15h
FILE_DEVICE_PARALLEL_PORT       equ 16h
FILE_DEVICE_PHYSICAL_NETCARD    equ 17h
FILE_DEVICE_PRINTER             equ 18h
FILE_DEVICE_SCANNER             equ 19h
FILE_DEVICE_SERIAL_MOUSE_PORT   equ 1ah
FILE_DEVICE_SERIAL_PORT         equ 1bh
FILE_DEVICE_SCREEN              equ 1ch
FILE_DEVICE_SOUND               equ 1dh
FILE_DEVICE_STREAMS             equ 1eh
FILE_DEVICE_TAPE                equ 1fh
FILE_DEVICE_TAPE_FILE_SYSTEM    equ 20h
FILE_DEVICE_TRANSPORT           equ 21h
FILE_DEVICE_UNKNOWN             equ 22h
FILE_DEVICE_VIDEO               equ 23h
FILE_DEVICE_VIRTUAL_DISK        equ 24h
FILE_DEVICE_WAVE_IN             equ 25h
FILE_DEVICE_WAVE_OUT            equ 26h
FILE_DEVICE_8042_PORT           equ 27h
FILE_DEVICE_NETWORK_REDIRECTOR  equ 28h
FILE_DEVICE_BATTERY             equ 29h
FILE_DEVICE_BUS_EXTENDER        equ 2ah
FILE_DEVICE_MODEM               equ 2bh
FILE_DEVICE_VDM                 equ 2ch
FILE_DEVICE_MASS_STORAGE        equ 2dh
FILE_DEVICE_SMB                 equ 2eh
FILE_DEVICE_KS                  equ 2fh
FILE_DEVICE_CHANGER             equ 30h
FILE_DEVICE_SMARTCARD           equ 31h
FILE_DEVICE_ACPI                equ 32h
FILE_DEVICE_DVD                 equ 33h
FILE_DEVICE_FULLSCREEN_VIDEO    equ 34h
FILE_DEVICE_DFS_FILE_SYSTEM     equ 35h
FILE_DEVICE_DFS_VOLUME          equ 36h

; Macro definition for defining IOCTL and FSCTL function control codes.  Note
; that function codes 0-2047 are reserved for Microsoft Corporation, and
; 2048-4095 are reserved for customers.

IFNDEF CTL_CODE
CTL_CODE MACRO DeviceType:=<0>, Function:=<0>, Method:=<0>, Access:=<0>
	EXITM %(((DeviceType) SHL 16) OR ((Access) SHL 14) OR ((Function) SHL 2) OR (Method))
ENDM
ENDIF

; Define the method codes for how buffers are passed for I/O and FS controls

METHOD_BUFFERED                 equ 0
METHOD_IN_DIRECT                equ 1
METHOD_OUT_DIRECT               equ 2
METHOD_NEITHER                  equ 3

; Define the access check value for any access
;
; The FILE_READ_ACCESS and FILE_WRITE_ACCESS constants are also defined in
; ntioapi.h as FILE_READ_DATA and FILE_WRITE_DATA. The values for these
; constants *MUST* always be in sync.

FILE_ANY_ACCESS			equ 0
FILE_READ_ACCESS		equ 1	; file & pipe
FILE_WRITE_ACCESS		equ 2	; file & pipe

; end_ntddk end_wdm end_nthal end_ntifs

ENDIF ;/ _DEVIOCTL_


IFNDEF _NTDDSTOR_H_
_NTDDSTOR_H_ equ 1

; +
; IoControlCode values for storage devices
; -

IOCTL_STORAGE_BASE	equ FILE_DEVICE_MASS_STORAGE

; +
; The following device control codes are common for all class drivers.  They
; should be used in place of the older IOCTL_DISK, IOCTL_CDROM and IOCTL_TAPE
; common codes
; -

IOCTL_STORAGE_CHECK_VERIFY     equ CTL_CODE(IOCTL_STORAGE_BASE, 0200h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_MEDIA_REMOVAL    equ CTL_CODE(IOCTL_STORAGE_BASE, 0201h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_EJECT_MEDIA      equ CTL_CODE(IOCTL_STORAGE_BASE, 0202h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_LOAD_MEDIA       equ CTL_CODE(IOCTL_STORAGE_BASE, 0203h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_RESERVE          equ CTL_CODE(IOCTL_STORAGE_BASE, 0204h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_RELEASE          equ CTL_CODE(IOCTL_STORAGE_BASE, 0205h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_FIND_NEW_DEVICES equ CTL_CODE(IOCTL_STORAGE_BASE, 0206h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_STORAGE_GET_MEDIA_TYPES  equ CTL_CODE(IOCTL_STORAGE_BASE, 0300h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_STORAGE_GET_MEDIA_TYPES_EX equ CTL_CODE(IOCTL_STORAGE_BASE, 0301h, METHOD_BUFFERED, FILE_ANY_ACCESS)

IOCTL_STORAGE_RESET_BUS        equ CTL_CODE(IOCTL_STORAGE_BASE, 0400h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_STORAGE_RESET_DEVICE     equ CTL_CODE(IOCTL_STORAGE_BASE, 0401h, METHOD_BUFFERED, FILE_READ_ACCESS)

IOCTL_STORAGE_GET_DEVICE_NUMBER equ CTL_CODE(IOCTL_STORAGE_BASE, 0420h, METHOD_BUFFERED, FILE_ANY_ACCESS)

; +
; IOCTL_STORAGE_GET_DEVICE_NUMBER
;
; input - none
;
; output - STORAGE_DEVICE_NUMBER structure
;          The values in the STORAGE_DEVICE_NUMBER structure are guaranteed
;          to remain unchanged until the system is rebooted.  They are not
;          guaranteed to be persistant across boots.
; -

STORAGE_DEVICE_NUMBER STRUCT

	; The FILE_DEVICE_XXX type for this device.

	DeviceType			DWORD	?	; DEVICE_TYPE

	; The number of this device

	DeviceNumber		DWORD	?

	; If the device is partitionable, the partition number of the device.
	; Otherwise -1

	PartitionNumber		DWORD	?

STORAGE_DEVICE_NUMBER ENDS
PSTORAGE_DEVICE_NUMBER typedef PTR STORAGE_DEVICE_NUMBER

ENDIF ; _NTDDSTOR_H_

; +
; IoControlCode values for disk devices.
; -

IOCTL_DISK_BASE					equ FILE_DEVICE_DISK
IOCTL_DISK_GET_DRIVE_GEOMETRY	equ CTL_CODE(IOCTL_DISK_BASE, 0000h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_GET_PARTITION_INFO	equ CTL_CODE(IOCTL_DISK_BASE, 0001h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_PARTITION_INFO	equ CTL_CODE(IOCTL_DISK_BASE, 0002h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_GET_DRIVE_LAYOUT		equ CTL_CODE(IOCTL_DISK_BASE, 0003h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_SET_DRIVE_LAYOUT		equ CTL_CODE(IOCTL_DISK_BASE, 0004h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_VERIFY				equ CTL_CODE(IOCTL_DISK_BASE, 0005h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_FORMAT_TRACKS		equ CTL_CODE(IOCTL_DISK_BASE, 0006h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_REASSIGN_BLOCKS		equ CTL_CODE(IOCTL_DISK_BASE, 0007h, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_PERFORMANCE			equ CTL_CODE(IOCTL_DISK_BASE, 0008h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_IS_WRITABLE			equ CTL_CODE(IOCTL_DISK_BASE, 0009h, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_LOGGING				equ CTL_CODE(IOCTL_DISK_BASE, 000ah, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_FORMAT_TRACKS_EX		equ CTL_CODE(IOCTL_DISK_BASE, 000bh, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_DISK_HISTOGRAM_STRUCTURE	equ CTL_CODE(IOCTL_DISK_BASE, 000ch, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_HISTOGRAM_DATA		equ CTL_CODE(IOCTL_DISK_BASE, 000dh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_HISTOGRAM_RESET		equ CTL_CODE(IOCTL_DISK_BASE, 000eh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_REQUEST_STRUCTURE	equ CTL_CODE(IOCTL_DISK_BASE, 000fh, METHOD_BUFFERED, FILE_ANY_ACCESS)
IOCTL_DISK_REQUEST_DATA			equ CTL_CODE(IOCTL_DISK_BASE, 0010h, METHOD_BUFFERED, FILE_ANY_ACCESS)

;#if(_WIN32_WINNT >= 0x0400)
IOCTL_DISK_CONTROLLER_NUMBER    equ CTL_CODE(IOCTL_DISK_BASE, 0011h, METHOD_BUFFERED, FILE_ANY_ACCESS)

; IOCTL support for SMART drive fault prediction.

SMART_GET_VERSION               equ CTL_CODE(IOCTL_DISK_BASE, 0020h, METHOD_BUFFERED, FILE_READ_ACCESS)
SMART_SEND_DRIVE_COMMAND        equ CTL_CODE(IOCTL_DISK_BASE, 0021h, METHOD_BUFFERED, FILE_READ_ACCESS + FILE_WRITE_ACCESS)
SMART_RCV_DRIVE_DATA            equ CTL_CODE(IOCTL_DISK_BASE, 0022h, METHOD_BUFFERED, FILE_READ_ACCESS + FILE_WRITE_ACCESS)
;#endif /* _WIN32_WINNT >= 0x0400 */

; +
; The following device control codes are common for all class drivers.  The
; functions codes defined here must match all of the other class drivers.
;
; Warning: these codes will be replaced in the future by equivalent
; IOCTL_STORAGE codes
; -

IOCTL_DISK_CHECK_VERIFY     equ CTL_CODE(IOCTL_DISK_BASE, 0200h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_MEDIA_REMOVAL    equ CTL_CODE(IOCTL_DISK_BASE, 0201h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_EJECT_MEDIA      equ CTL_CODE(IOCTL_DISK_BASE, 0202h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_LOAD_MEDIA       equ CTL_CODE(IOCTL_DISK_BASE, 0203h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_RESERVE          equ CTL_CODE(IOCTL_DISK_BASE, 0204h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_RELEASE          equ CTL_CODE(IOCTL_DISK_BASE, 0205h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_FIND_NEW_DEVICES equ CTL_CODE(IOCTL_DISK_BASE, 0206h, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_DISK_GET_MEDIA_TYPES  equ CTL_CODE(IOCTL_DISK_BASE, 0300h, METHOD_BUFFERED, FILE_ANY_ACCESS)

; Define the partition types returnable by known disk drivers.

PARTITION_ENTRY_UNUSED          equ 00      ; Entry unused
PARTITION_FAT_12                equ 01      ; 12-bit FAT entries
PARTITION_XENIX_1               equ 02      ; Xenix
PARTITION_XENIX_2               equ 03      ; Xenix
PARTITION_FAT_16                equ 04      ; 16-bit FAT entries
PARTITION_EXTENDED              equ 05      ; Extended partition entry
PARTITION_HUGE                  equ 06      ; Huge partition MS-DOS V4
PARTITION_IFS                   equ 07      ; IFS Partition
PARTITION_FAT32                 equ 0Bh     ; FAT32
PARTITION_FAT32_XINT13          equ 0Ch     ; FAT32 using extended int13 services
PARTITION_XINT13                equ 0Eh     ; Win95 partition using extended int13 services
PARTITION_XINT13_EXTENDED       equ 0Fh     ; Same as type 5 but uses extended int13 services
PARTITION_PREP                  equ 41h     ; PowerPC Reference Platform (PReP) Boot Partition
PARTITION_LDM                   equ 42h     ; Logical Disk Manager partition
PARTITION_UNIX                  equ 63h     ; Unix

VALID_NTFT                      equ C0h		; NTFT uses high order bits

; The high bit of the partition type code indicates that a partition
; is part of an NTFT mirror or striped array.

PARTITION_NTFT                  equ 80h	; NTFT partition

; Define the media types supported by the driver.

;typedef enum _MEDIA_TYPE {
    Unknown        equ 0	; Format is unknown
    F5_1Pt2_512    equ 1	; 5.25", 1.2MB,  512 bytes/sector
    F3_1Pt44_512   equ 2	; 3.5",  1.44MB, 512 bytes/sector
    F3_2Pt88_512   equ 3	; 3.5",  2.88MB, 512 bytes/sector
    F3_20Pt8_512   equ 4	; 3.5",  20.8MB, 512 bytes/sector
    F3_720_512     equ 5	; 3.5",  720KB,  512 bytes/sector
    F5_360_512     equ 6	; 5.25", 360KB,  512 bytes/sector
    F5_320_512     equ 7	; 5.25", 320KB,  512 bytes/sector
    F5_320_1024    equ 8	; 5.25", 320KB,  1024 bytes/sector
    F5_180_512     equ 9	; 5.25", 180KB,  512 bytes/sector
    F5_160_512     equ 10	; 5.25", 160KB,  512 bytes/sector
    RemovableMedia equ 11	; Removable media other than floppy
    FixedMedia     equ 12	; Fixed hard disk media
    F3_120M_512    equ 13	; 3.5", 120M Floppy
    F3_640_512     equ 14	; 3.5" ,  640KB,  512 bytes/sector
    F5_640_512     equ 15	; 5.25",  640KB,  512 bytes/sector
    F5_720_512     equ 16	; 5.25",  720KB,  512 bytes/sector
    F3_1Pt2_512    equ 17	; 3.5" ,  1.2Mb,  512 bytes/sector
    F3_1Pt23_1024  equ 18	; 3.5" ,  1.23Mb, 1024 bytes/sector
    F5_1Pt23_1024  equ 19	; 5.25",  1.23MB, 1024 bytes/sector
    F3_128Mb_512   equ 20	; 3.5" MO 128Mb   512 bytes/sector
    F3_230Mb_512   equ 21	; 3.5" MO 230Mb   512 bytes/sector
    F8_256_128     equ 22	; 8",     256KB,  128 bytes/sector

; +
; The following structure is returned on an IOCTL_DISK_GET_DRIVE_GEOMETRY
; request and an array of them is returned on an IOCTL_DISK_GET_MEDIA_TYPES
; request.
; -

IFNDEF DISK_GEOMETRY	; because of winioctl
DISK_GEOMETRY STRUCT
	Cylinders			LARGE_INTEGER <>
	MediaType			SDWORD	?	; enum MEDIA_TYPE
	TracksPerCylinder	DWORD	?
	SectorsPerTrack		DWORD	?
	BytesPerSector		DWORD	?
DISK_GEOMETRY ENDS
PDISK_GEOMETRY	typedef PTR DISK_GEOMETRY
ENDIF

; +
; The following structure is returned on an IOCTL_DISK_GET_PARTITION_INFO
; and an IOCTL_DISK_GET_DRIVE_LAYOUT request.  It is also used in a request
; to change the drive layout, IOCTL_DISK_SET_DRIVE_LAYOUT.
; -

IFNDEF PARTITION_INFORMATION	; because of winioctl
PARTITION_INFORMATION STRUCT
	StartingOffset			LARGE_INTEGER	<>
	PartitionLength			LARGE_INTEGER	<>
	HiddenSectors			DWORD			?
	PartitionNumber			DWORD			?
	PartitionType			BYTE			?
	BootIndicator			BOOLEAN			?
	RecognizedPartition		BOOLEAN			?
	RewritePartition		BOOLEAN			?
							DWORD			?	; padding
PARTITION_INFORMATION ENDS
PPARTITION_INFORMATION typedef PTR PARTITION_INFORMATION
ENDIF

; +
; The following structure is used to change the partition type of a
; specified disk partition using an IOCTL_DISK_SET_PARTITION_INFO
; request.
; -

SET_PARTITION_INFORMATION STRUCT
	PartitionType	BYTE	?
SET_PARTITION_INFORMATION ENDS
PSET_PARTITION_INFORMATION typedef PTR SET_PARTITION_INFORMATION

; +
; The following structures is returned on an IOCTL_DISK_GET_DRIVE_LAYOUT
; request and given as input to an IOCTL_DISK_SET_DRIVE_LAYOUT request.
; -

DRIVE_LAYOUT_INFORMATION STRUCT
	PartitionCount	DWORD	?
	Signature		DWORD	?
	PartitionEntry	PARTITION_INFORMATION 1 dup(<>)
DRIVE_LAYOUT_INFORMATION ENDS
PDRIVE_LAYOUT_INFORMATION typedef PTR DRIVE_LAYOUT_INFORMATION

; +
; The following structure is passed in on an IOCTL_DISK_VERIFY request.
; The offset and length parameters are both given in bytes.
; -

VERIFY_INFORMATION STRUCT
	StartingOffset	LARGE_INTEGER	<>
	_Length			DWORD			?	; original field name Length
					DWORD			?	; padding
VERIFY_INFORMATION ENDS
PVERIFY_INFORMATION typedef PTR VERIFY_INFORMATION

; bDriverError values

SMART_NO_ERROR          equ 0       ; No error
SMART_IDE_ERROR         equ 1       ; Error from IDE controller
SMART_INVALID_FLAG      equ 2       ; Invalid command flag
SMART_INVALID_COMMAND   equ 3       ; Invalid command byte
SMART_INVALID_BUFFER    equ 4       ; Bad buffer (null, invalid addr..)
SMART_INVALID_DRIVE     equ 5       ; Drive number not valid
SMART_INVALID_IOCTL     equ 6       ; Invalid IOCTL
SMART_ERROR_NO_MEM      equ 7       ; Could not lock user's buffer
SMART_INVALID_REGISTER  equ 8       ; Some IDE Register not valid
SMART_NOT_SUPPORTED     equ 9       ; Invalid cmd flag set
SMART_NO_IDE_DEVICE     equ 10      ; Cmd issued to device not present
                                        ; although drive number is valid
READ_ATTRIBUTE_BUFFER_SIZE  equ 512
IDENTIFY_BUFFER_SIZE        equ 512
READ_THRESHOLD_BUFFER_SIZE  equ 512

; Feature register defines for SMART "sub commands"

READ_ATTRIBUTES         equ 0D0h
READ_THRESHOLDS         equ 0D1h
ENABLE_DISABLE_AUTOSAVE equ 0D2h
SAVE_ATTRIBUTE_VALUES   equ 0D3h
EXECUTE_OFFLINE_DIAGS   equ 0D4h
ENABLE_SMART            equ 0D8h
DISABLE_SMART           equ 0D9h
RETURN_SMART_STATUS     equ 0DAh
;#endif /* _WIN32_WINNT >= 0x0400 */


IOCTL_CHANGER_BASE                equ FILE_DEVICE_CHANGER

IOCTL_CHANGER_GET_PARAMETERS         equ CTL_CODE(IOCTL_CHANGER_BASE, 0000, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_GET_STATUS             equ CTL_CODE(IOCTL_CHANGER_BASE, 0001, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_GET_PRODUCT_DATA       equ CTL_CODE(IOCTL_CHANGER_BASE, 0002, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_SET_ACCESS             equ CTL_CODE(IOCTL_CHANGER_BASE, 0004, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_CHANGER_GET_ELEMENT_STATUS     equ CTL_CODE(IOCTL_CHANGER_BASE, 0005, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)
IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS  equ CTL_CODE(IOCTL_CHANGER_BASE, 0006, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_SET_POSITION           equ CTL_CODE(IOCTL_CHANGER_BASE, 0007, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_EXCHANGE_MEDIUM        equ CTL_CODE(IOCTL_CHANGER_BASE, 0008, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_MOVE_MEDIUM            equ CTL_CODE(IOCTL_CHANGER_BASE, 0009, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_REINITIALIZE_TRANSPORT equ CTL_CODE(IOCTL_CHANGER_BASE, 000Ah, METHOD_BUFFERED, FILE_READ_ACCESS)
IOCTL_CHANGER_QUERY_VOLUME_TAGS      equ CTL_CODE(IOCTL_CHANGER_BASE, 000Bh, METHOD_BUFFERED, FILE_READ_ACCESS or FILE_WRITE_ACCESS)

; Possible ActionCode values. See Features0 of CHANGER_GET_PARAMETERS for compatibility with
; the current device.

SEARCH_ALL         equ 0 ; Translate - search all defined volume tags.
SEARCH_PRIMARY     equ 1 ; Translate - search only primary volume tags.
SEARCH_ALTERNATE   equ 2 ; Translate - search only alternate volume tags.
SEARCH_ALL_NO_SEQ  equ 4 ; Translate - search all defined volume tags but ignore sequence numbers.
SEARCH_PRI_NO_SEQ  equ 5 ; Translate - search only primary volume tags but ignore sequence numbers.
SEARCH_ALT_NO_SEQ  equ 6 ; Translate - search only alternate volume tags but ignore sequence numbers.

ASSERT_PRIMARY     equ 8 ; Assert - as the primary volume tag - if tag now undefined.
ASSERT_ALTERNATE   equ 9 ; Assert - as the alternate volume tag - if tag now undefined.

REPLACE_PRIMARY    equ Ah ; Replace - the primary volume tag - current tag ignored.
REPLACE_ALTERANTE  equ Bh ; Replace - the alternate volume tag - current tag ignored.

UNDEFINE_PRIMARY   equ Ch ; Undefine - the primary volume tag - current tag ignored.
UNDEFINE_ALTERNATE equ Dh ; Undefine - the alternate volume tag - current tag ignored.

IOCTL_SERIAL_LSRMST_INSERT      equ CTL_CODE(FILE_DEVICE_SERIAL_PORT,31,METHOD_BUFFERED,FILE_ANY_ACCESS)

; The following values follow the escape designator in the
; data stream if the LSRMST_INSERT mode has been turned on.

SERIAL_LSRMST_ESCAPE		equ 00	; BYTE

; Following this value is the contents of the line status
; register, and then the character in the RX hardware when
; the line status register was encountered.

SERIAL_LSRMST_LSR_DATA		equ 01	; BYTE

; Following this value is the contents of the line status
; register.  No error character follows

SERIAL_LSRMST_LSR_NODATA	equ 02	; BYTE

; Following this value is the contents of the modem status
; register.

SERIAL_LSRMST_MST			equ 03	; BYTE

IFNDEF _FILESYSTEMFSCTL_
_FILESYSTEMFSCTL_ equ 1

; The following is a list of the native file system fsctls followed by
; additional network file system fsctls.  Some values have been
; decommissioned.

FSCTL_REQUEST_OPLOCK_LEVEL_1    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  0, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_REQUEST_OPLOCK_LEVEL_2    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  1, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_REQUEST_BATCH_OPLOCK      equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  2, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_OPLOCK_BREAK_ACKNOWLEDGE  equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  3, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_OPBATCH_ACK_CLOSE_PENDING equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  4, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_OPLOCK_BREAK_NOTIFY       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  5, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_LOCK_VOLUME               equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  6, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_UNLOCK_VOLUME             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  7, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_DISMOUNT_VOLUME           equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM,  8, METHOD_BUFFERED, FILE_ANY_ACCESS)
; decommissioned fsctl value                                              9
FSCTL_IS_VOLUME_MOUNTED         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_IS_PATHNAME_VALID         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS) ; PATHNAME_BUFFER,
FSCTL_MARK_VOLUME_DIRTY         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
; decommissioned fsctl value                                             13
FSCTL_QUERY_RETRIEVAL_POINTERS  equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_GET_COMPRESSION           equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_SET_COMPRESSION           equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 16, METHOD_BUFFERED, FILE_READ_DATA + FILE_WRITE_DATA)
; decommissioned fsctl value                                             17
; decommissioned fsctl value                                             18
FSCTL_MARK_AS_SYSTEM_HIVE       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_OPLOCK_BREAK_ACK_NO_2     equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_INVALIDATE_VOLUMES        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_QUERY_FAT_BPB             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , FSCTL_QUERY_FAT_BPB_BUFFER
FSCTL_REQUEST_FILTER_OPLOCK     equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_FILESYSTEM_GET_STATISTICS equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , FILESYSTEM_STATISTICS
;#if(_WIN32_WINNT >= 0x0400)
FSCTL_GET_NTFS_VOLUME_DATA      equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , NTFS_VOLUME_DATA_BUFFER
FSCTL_GET_NTFS_FILE_RECORD      equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS) ; NTFS_FILE_RECORD_INPUT_BUFFER, NTFS_FILE_RECORD_OUTPUT_BUFFER
FSCTL_GET_VOLUME_BITMAP         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS) ; STARTING_LCN_INPUT_BUFFER, VOLUME_BITMAP_BUFFER
FSCTL_GET_RETRIEVAL_POINTERS    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS) ; STARTING_VCN_INPUT_BUFFER, RETRIEVAL_POINTERS_BUFFER
FSCTL_MOVE_FILE                 equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_ANY_ACCESS) ; MOVE_FILE_DATA,
FSCTL_IS_VOLUME_DIRTY           equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_GET_HFS_INFORMATION       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 31, METHOD_BUFFERED, FILE_ANY_ACCESS)
FSCTL_ALLOW_EXTENDED_DASD_IO    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER,  FILE_ANY_ACCESS)
;#endif /* _WIN32_WINNT >= 0x0400 */

;#if(_WIN32_WINNT >= 0x0500)
FSCTL_READ_PROPERTY_DATA        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 33, METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_WRITE_PROPERTY_DATA       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 34, METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_FIND_FILES_BY_SID         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS)
; decommissioned fsctl value                                             36
FSCTL_DUMP_PROPERTY_DATA        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 37, METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_SET_OBJECT_ID             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_WRITE_DATA) ; FILE_OBJECTID_BUFFER
FSCTL_GET_OBJECT_ID             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , FILE_OBJECTID_BUFFER
FSCTL_DELETE_OBJECT_ID          equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_WRITE_DATA)
FSCTL_SET_REPARSE_POINT         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_WRITE_DATA) ; REPARSE_DATA_BUFFER,
FSCTL_GET_REPARSE_POINT         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , REPARSE_DATA_BUFFER
FSCTL_DELETE_REPARSE_POINT      equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_WRITE_DATA) ; REPARSE_DATA_BUFFER,
FSCTL_ENUM_USN_DATA             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 44,  METHOD_NEITHER, FILE_READ_DATA)  ; MFT_ENUM_DATA,
FSCTL_SECURITY_ID_CHECK         equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 45,  METHOD_NEITHER, FILE_READ_DATA)  ; BULK_SECURITY_TEST_DATA,
FSCTL_READ_USN_JOURNAL          equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 46,  METHOD_NEITHER, FILE_READ_DATA)  ; READ_USN_JOURNAL_DATA, USN
FSCTL_SET_OBJECT_ID_EXTENDED    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_WRITE_DATA)
FSCTL_CREATE_OR_GET_OBJECT_ID   equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS) ; , FILE_OBJECTID_BUFFER
FSCTL_SET_SPARSE                equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_WRITE_DATA)
FSCTL_SET_ZERO_DATA             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, FILE_WRITE_DATA) ; FILE_ZERO_DATA_INFORMATION,
FSCTL_QUERY_ALLOCATED_RANGES    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 51,  METHOD_NEITHER, FILE_READ_DATA)  ; FILE_ALLOCATED_RANGE_BUFFER, FILE_ALLOCATED_RANGE_BUFFER
FSCTL_ENABLE_UPGRADE            equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 52, METHOD_BUFFERED, FILE_WRITE_DATA)
FSCTL_SET_ENCRYPTION            equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 53, METHOD_BUFFERED, FILE_ANY_ACCESS) ; ENCRYPTION_BUFFER,
FSCTL_ENCRYPTION_FSCTL_IO       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 54,  METHOD_NEITHER, FILE_ANY_ACCESS)
FSCTL_WRITE_RAW_ENCRYPTED       equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 55,  METHOD_NEITHER, FILE_ANY_ACCESS) ; ENCRYPTED_DATA_INFO,
FSCTL_READ_RAW_ENCRYPTED        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 56,  METHOD_NEITHER, FILE_ANY_ACCESS) ; REQUEST_RAW_ENCRYPTED_DATA, ENCRYPTED_DATA_INFO
FSCTL_CREATE_USN_JOURNAL        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 57,  METHOD_NEITHER, FILE_READ_DATA)  ; CREATE_USN_JOUNRAL_DATA,
FSCTL_READ_FILE_USN_DATA        equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 58,  METHOD_NEITHER, FILE_READ_DATA)  ; Read the Usn Record for a file
FSCTL_WRITE_USN_CLOSE_RECORD    equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 59,  METHOD_NEITHER, FILE_READ_DATA)  ; Generate Close Usn Record
FSCTL_EXTEND_VOLUME             equ CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS)
;#endif /* _WIN32_WINNT >= 0x0500 */

ENDIF ; _FILESYSTEMFSCTL_

ENDIF ; _WINIOCTL_
