;-------------------------------------------------------------------------------
;  colibrary procedure Register
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\kernel32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_hHeap:DWORD
externdef   pResEnd:DWORD
externdef   Pos:DWORD
externdef   g_hModule:DWORD

.data
szREGISTRY              BYTE            "REGISTRY", 0

.code
;-------------------------------------------------------------------------------

Register PROC PUBLIC Install:DWORD
             
;-------------------------------------------------------------------------------
; internal lib function, used control registrar script registration 
;   and unregistration
;   
;
; EXAMPLE:
;   invoke Register, TRUE
;   invoke Register, FALSE
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL  szBuffer[MAX_PATH]:BYTE
    LOCAL  szHKey[1]:BYTE
    LOCAL  pRgsScript:DWORD
    LOCAL  pszToken:DWORD,    pszHKey:DWORD
    LOCAL  hKey:DWORD,        hres:DWORD

    ; init the szHKey string
    mov szHKey, NULL
    lea eax, szHKey
    mov pszHKey, eax
    ; get the registry script
    invoke FindResource,g_hModule, IDD_RGS_SCRIPT, ADDR szREGISTRY 
    mov hres, eax
    invoke SizeofResource, g_hModule, hres
    mov pResEnd, eax
    invoke LoadResource, g_hModule, hres
    invoke LockResource, eax
    mov pRgsScript, eax
    mov Pos, eax                ; pos is a global so GetNextToken may keep track
    add pResEnd, eax            ; pResEnd is too
nextToken:
    invoke GetNextToken
    mov pszToken, eax
    .WHILE eax
        ; check for equality to top level keys 
        ; we do major 'cheat' here to make small fast code
        ; check 4 byte strings as dwords
        ;  'cheat' == we don't check the length
         mov eax, [eax]
        .IF eax == "RCKH"      ; HKCR
            mov hKey, HKEY_CLASSES_ROOT
            jmp HaveTopKey
        .ENDIF
        .IF eax == "UCKH"      ; HKCU
            mov hKey, HKEY_CURRENT_USER
            jmp HaveTopKey
        .ENDIF
        .IF eax == "MLKH"      ; HKLM
            mov hKey, HKEY_LOCAL_MACHINE
            jmp HaveTopKey
        .ENDIF
        .IF eax == "CCKH"      ; HKCC
            mov hKey, HKEY_CURRENT_CONFIG
            jmp HaveTopKey
        .ENDIF
        .IF eax == "DDKH"      ; HKDD
            mov hKey, HKEY_DYN_DATA 
            jmp HaveTopKey
        .ENDIF
        and eax, 00FFFFFFH
        .IF eax == "UKH"      ; HKU
            mov hKey, HKEY_USERS
            jmp HaveTopKey
        .ENDIF
        invoke HeapFree, g_hHeap, NULL, pszToken
        ; we had a script error, no top key
        mov eax, S_FALSE
        jmp return
HaveTopKey:    
        invoke HeapFree, g_hHeap, NULL, pszToken
        invoke GetNextToken         ; need to "throw away" then next "{"
                                    ;  full version should CHECK we really
                                    ;  have a "{" here  :-)
        mov DWORD PTR szBuffer, "{"   
        invoke lstrcmp, ADDR szBuffer, pszToken
        .IF !eax
            ;we're all done here, clean up and go
            invoke HeapFree, g_hHeap, NULL, pszToken
            mov pszToken, NULL
            invoke SetSubKey, hKey, NULL, Install
        .ENDIF
        invoke GetNextToken
        mov pszToken, eax
    .ENDW
    xor eax, eax
return:
    ret
Register ENDP
;-------------------------------------------------------------------------------

end
