;-------------------------------------------------------------------------------
;  colibrary procedure NDAddRef
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

NDAddRef  PROC PUBLIC this_:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the non-delegated IUnknown::NDAddRef function
;
;  performs the AddRef function
;
; EXAMPLE:
;   coinvoke ppv, NDIUnknown, AddRef
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    mov ecx, this_                              ; get object
    mov ecx, (ObjectEntry PTR[ecx]).m_pBase     ; walk to base data
    inc (ObjectData PTR[ecx]).m_RefCount        
    mov eax, (ObjectData PTR[ecx]).m_RefCount   ; return the ref count
    ret
NDAddRef  ENDP
;-------------------------------------------------------------------------------

end
