;-------------------------------------------------------------------------------
;  colibrary procedure LockServer
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_ObjectCount:DWORD

.code
;-------------------------------------------------------------------------------

LockServer PROC PUBLIC this_:DWORD, bLockServer:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the IClassFactory::LockServer method
;
;  performs the LockServer method, preventing the dll server from
;  being unloaded by increacing the object count.
;
; EXAMPLE:
;   coinvoke ppv, IClassFactory, LockServer
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    .IF bLockServer == TRUE
        inc g_ObjectCount          ; increase the global lock count
                                   ;  doubles as lock count too
        coinvoke this_, IUnknown, AddRef
    .ELSE
        dec g_ObjectCount          ; decrease the global lock count
        coinvoke this_, IUnknown, Release
    .ENDIF
    mov eax, S_OK
    ret
LockServer ENDP
;-------------------------------------------------------------------------------

end
