;-------------------------------------------------------------------------------
;  colibrary procedure Invoke_ 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;  revised 1/8/01 to includelib oleaut32.lib
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

includelib \masm32\lib\oleaut32.lib     ; added 1/8/01

.code
;-------------------------------------------------------------------------------

Invoke_ PROC PUBLIC this_:DWORD,      dispIdMember:DWORD,   riid:DWORD,  
                    lcid:DWORD,       wFlags:WORD,          pDispParams:DWORD,    
                    pVarResult:DWORD, pExcepInfo:DWORD,     puArgErr:DWORD 
             
;-------------------------------------------------------------------------------
; implimentation of the IDispatch::Invoke function
;
;  performs a type library driven Invoke implementation
;
; EXAMPLE:
; (See MSDN and other sources for how to use Invoke)
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL pTInfo:DWORD
    
    invoke GetCachedTypeInfo, this_, lcid, ADDR pTInfo    
    ; we don't AddRef ppTInfo because we just "borrow it" for this routine
    ;  ie, we'd just be releasing it again after the following coinvoke
    .IF pTInfo
        ; we let ITypeInfo do the actual invoke for us. Neet, huh?
        invoke SetErrorInfo, NULL, NULL
        coinvoke pTInfo, ITypeInfo, Invoke, this_,  dispIdMember, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr
    .ELSE
        mov pTInfo, DISP_E_UNKNOWNLCID
    .ENDIF
    ret
Invoke_ ENDP
;-------------------------------------------------------------------------------

end
