;-------------------------------------------------------------------------------
;  colibrary procedure GuardedDeleteKey
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\advapi32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

GuardedDeleteKey PROC PUBLIC hKey:DWORD, pszSubKey:DWORD
             
;-------------------------------------------------------------------------------
; internal lib function, used to flush a registry nest
;
; EXAMPLE:
;   invoke GuardedDeleteKey, hKey, ADDR szSubKey
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL   szSubKeyName    [MAX_PATH+1]:TCHAR
    LOCAL   hSubkey         :DWORD  

    ; check to see if the key to be deleted still has subkey, 
    ; if not delete it, otherwise delete the subkey
    invoke RegOpenKey, hKey, pszSubKey, ADDR hSubkey
    .IF (eax != ERROR_SUCCESS) 
        mov eax, REGDB_E_INVALIDVALUE
        jmp return
    .ENDIF
KillNextSubkey:    
    ; check for a subkey
    invoke RegEnumKey, hSubkey, 0, ADDR szSubKeyName, MAX_PATH+1
    .IF (eax != ERROR_NO_MORE_ITEMS) ; IF SubKeys exist...
        ; delete the subkey thru recusion
        invoke GuardedDeleteKey, hSubkey, ADDR szSubKeyName
        jmp KillNextSubkey
    .ELSE
    .ENDIF
    ; no more Subkeys, delete the specfied hey.
    invoke RegCloseKey, hSubkey
    invoke RegDeleteKey, hKey,  pszSubKey
    .IF (eax == ERROR_SUCCESS) 
        xor eax, eax  ; mov eax, S_OK
    .ENDIF
return:
    ret
GuardedDeleteKey ENDP
;-------------------------------------------------------------------------------

end
