;-------------------------------------------------------------------------------
;  colibrary procedure GetTypeInfoCount 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

GetTypeInfoCount PROC PUBLIC this_:DWORD, pctinfo:DWORD

             
;-------------------------------------------------------------------------------
; implimentation of the IDispatch::GetTypeInfoCount function
;
;  performs a non-delegating Release function
;
; EXAMPLE:
; (See MSDN and other sources for how to use GetTypeInfoCount)
;
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    mov edx, this_                                  ; get object
    mov edx, (ObjectEntry PTR[edx]).m_pBase         ; walk to base data
    mov edx, (ObjectData PTR[edx]).m_pClassItem	    ; back to ClassMap.ClassItem
    mov eax, (ClassItem PTR[edx]).m_Flags          ; get object flags
    and eax, SUPPLY_TYPE_INFO                       ; see if we provide type info
    .IF eax
        mov eax, 1      ; we provide type info
    .ELSE
        mov eax, 0      ; we do not provide type info
    .ENDIF
    mov ecx, pctinfo
    mov [ecx], eax      ; set pctinfo flag
    xor eax, eax        ; return S_OK
    ret
GetTypeInfoCount    ENDP
;-------------------------------------------------------------------------------

end
