;-------------------------------------------------------------------------------
;  colibrary procedure GetTypeInfo 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

GetTypeInfo PROC PUBLIC this_:DWORD, iTypeInfo:DWORD, lcid:DWORD, ppTInfo:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the IDispatch::GetTypeInfo function
;
;  performs a type library driven GetTypeInfo implementation
;
; EXAMPLE:
; (See MSDN and other sources for how to use GetTypeInfo)
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    mov edx, this_
    mov edx, (ObjectEntry PTR[edx]).m_pBase
    .IF (iTypeInfo != 0)
        mov eax, DISP_E_BADINDEX
        jmp return
    .ENDIF
    ; check if we support the requested LCID
    invoke GetCachedTypeInfo, this_, lcid, ppTInfo
    mov ecx, ppTInfo
    mov ecx, [ecx]
    .IF ecx
        ; we got a lib to return, inc it's ref count
        coinvoke ecx, ITypeInfo, AddRef
    .ENDIF
return:
    ret
GetTypeInfo         ENDP
;-------------------------------------------------------------------------------

end
