;-------------------------------------------------------------------------------
;  colibrary procedure GetNextToken
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\kernel32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_hHeap:DWORD
externdef   Pos:DWORD
externdef   pResEnd:DWORD

.code
;-------------------------------------------------------------------------------

GetNextToken PROC PUBLIC
             
;-------------------------------------------------------------------------------
; internal lib function, used to parse the registrar script
;   
;
; EXAMPLE:
;   invoke GetNextToken
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL  pBuf:DWORD, pEnd:DWORD, cCount:DWORD

    mov edx, Pos
    mov pEnd, edx
    mov ecx, pResEnd
    ; skip past any "whitespace" (spaces, tabs, returns, and linefeeds
    ; single quotes too)
    mov al, BYTE PTR [edx]
white:
    .IF al == 13 || al == 10 || al ==09 || al == 32
        .IF pEnd == ecx
            xor eax, eax
            jmp return
        .ENDIF
        inc pEnd
        mov edx, pEnd
        mov al, BYTE PTR [edx]
        jmp white
    .ENDIF
    mov edx, pEnd
    mov Pos, edx
    ; check for a string litteral
    mov al, BYTE PTR [edx]
    .IF al != 39 
        ; we have a string literal here
        jmp nonwhite
    .ENDIF
    inc Pos
    inc edx
    mov al, BYTE PTR [edx]
strliteral:
    .IF al != 39
        .IF pEnd == ecx
            xor eax, eax
            jmp return
        .ENDIF
        inc pEnd
        mov edx, pEnd
        mov al, BYTE PTR [edx]
        jmp strliteral
    .ENDIF
    mov eax, pEnd
    mov cCount, eax
    mov eax, Pos
    sub cCount, eax
    inc pEnd
    jmp makeHeap
    ; now grab all text (characters not defined as above)
nonwhite:
    .IF al != 13 && al != 10 && al !=09 && al !=32
        .IF pEnd == ecx
            xor eax, eax
            jmp return
        .ENDIF
        inc pEnd
        mov edx, pEnd
        mov al, BYTE PTR [edx]
        jmp nonwhite
    .ENDIF
    mov eax, pEnd
    mov cCount, eax
    mov eax, Pos
    sub cCount, eax
makeHeap:
    ; now make a heap buffer
    inc cCount
    invoke HeapAlloc, g_hHeap, NULL, cCount 
    mov pBuf, eax
    ; and put our sting in the buffer
    invoke lstrcpyn, pBuf, Pos, cCount
    mov eax, pEnd
    mov Pos, eax
    ; ret pBuffer
    mov eax, pBuf
return:
    ret
GetNextToken ENDP
;-------------------------------------------------------------------------------

end
