;-------------------------------------------------------------------------------
;  colibrary procedure GetIDsOfNames 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc


.code
;-------------------------------------------------------------------------------

GetIDsOfNames PROC PUBLIC this_:DWORD,  rrid:DWORD, rgszNames:DWORD, 
                          cNames:DWORD, lcid:DWORD, rgDispID:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the IDispatch::GetIDsOfNames function
;
;  performs a type library driven GetIDsOfNames implementation
;
; EXAMPLE:
; (See MSDN and other sources for how to use GetIDsOfNames)
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL pTInfo:DWORD
    invoke GetCachedTypeInfo, this_, lcid, ADDR pTInfo    
    ; we don't AddRef ppTInfo because we just "borrow it" for this routine
    ;  ie, we'd just be releasing it again after the following coinvoke
    .IF pTInfo
        ; we got a lib to return, inc it's ref count
        coinvoke pTInfo, ITypeInfo, GetIDsOfNames, rgszNames, cNames, rgDispID
    .ELSE
        mov eax, DISP_E_UNKNOWNLCID
    .ENDIF
    ret
GetIDsOfNames       ENDP
;-------------------------------------------------------------------------------

end
