;-------------------------------------------------------------------------------
;  colibrary procedure DllUnregisterServer
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build) 
include     \masm32\include\oleaut32.inc
include     \masm32\include\kernel32.inc
include     \masm32\include\masm32.inc
include     \masm32\include\user32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_hHeap:DWORD
externdef   g_hModule:DWORD

.code
;-------------------------------------------------------------------------------

DllUnregisterServer PROC PUBLIC
             
;-------------------------------------------------------------------------------
; COM server dll main export
;   Unregisters a component from the registry
;   
;
; EXAMPLE:
;   invoke DllUnregisterServer
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL rCount:DWORD,         hres:DWORD;,         pResEnd:DWORD
    LOCAL psCount:DWORD,        psBuf:DWORD,        pwsBuf:DWORD
    LOCAL szTypeLib[20]:BYTE,   pti:DWORD,          pTLibAttr:DWORD 
    LOCAL m_MajorVer:DWORD,     m_MinorVer:DWORD 
    LOCAL m_lcid:DWORD,         m_syskind:DWORD

    invoke Register, FALSE
    ; make some strings
    invoke HeapAlloc, g_hHeap, NULL, ( MAX_PATH * 3 + 10)
    mov psBuf, eax
    add eax, MAX_PATH * 2
    mov pwsBuf, eax
    add eax, 10
    mov psCount, eax
    mov rCount, 1           ; init the resource number to #1
    invoke LoadString, g_hModule, IDS_TypeLib, ADDR szTypeLib, 20
NextTypeLib:
    ; loop to find the resource
    invoke FindResource,g_hModule, rCount, ADDR szTypeLib
    .IF !eax
        jmp return
    .ENDIF
    mov hres, eax
    invoke LoadResource, g_hModule, hres
    invoke LockResource, eax
    mov hres, eax
    mov eax, [eax]                  ; get 1st 4 characters of this resource
    .IF eax != 5446534DH            ; ew-check to assure is TypeLib resource
                                    ; 5446534DH = "TFSM", or "MSFT" backwards
        jmp return
    .ENDIF
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    mov eax, psCount
    mov ecx, 0000005CH
    mov [eax], ecx
    invoke lstrcat, psBuf, psCount  ; cat "\" onto FileName
    invoke dwtoa, rCount, psCount
    invoke lstrcat, psBuf, psCount  ; cat "\####" onto FileName, where ####
                                    ;  is the resource number in string form
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    .IF !eax
        mov eax, S_FALSE
        jmp return
    .ENDIF
    invoke LoadTypeLib, pwsBuf, ADDR pti
    .IF_FAILED
        mov eax, S_FALSE
        jmp return
    .ENDIF
    mov pTLibAttr, 0
    lea ecx, pTLibAttr
    coinvoke pti, ITypeLib, GetLibAttr, ecx
    .IF_FAILED
        coinvoke pti, ITypeLib, Release
        mov eax, S_FALSE
        jmp return
    .ENDIF
    mov ecx, pTLibAttr
    xor eax, eax
    mov ax, (TLIBATTR PTR [ecx]).wMajorVerNum
    mov m_MajorVer, eax
    mov ax, (TLIBATTR PTR [ecx]).wMinorVerNum 
    mov m_MinorVer, eax 
    mov eax, (TLIBATTR PTR [ecx]).lcid
    mov m_lcid, eax 
    mov eax, (TLIBATTR PTR [ecx]).syskind
    mov m_syskind, eax
    mov ecx, pTLibAttr
    invoke UnRegisterTypeLib, ecx, m_MajorVer, m_MinorVer, m_lcid, m_syskind
    coinvoke pti, ITypeLib, ReleaseTLibAttr, pTLibAttr
    coinvoke pti, IUnknown, Release
    ; now try for the next typelib
    inc rCount
    jmp NextTypeLib
    ; clean up our buffers
    invoke HeapFree, g_hHeap, NULL, psBuf   
return:     
    xor eax, eax
    ret
DllUnregisterServer ENDP
;-------------------------------------------------------------------------------

end
