;-------------------------------------------------------------------------------
;  colibrary procedure DllRegisterServer
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\kernel32.inc
include     \masm32\include\masm32.inc
include     \masm32\include\user32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_hHeap:DWORD
externdef   g_hModule:DWORD

.code
;-------------------------------------------------------------------------------

DllRegisterServer PROC PUBLIC
             
;-------------------------------------------------------------------------------
; COM server dll main export
;   Registers a component to the registry
;   
;
; EXAMPLE:
;   invoke DllRegisterServer
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL rCount:DWORD,         hres:DWORD;,         pResEnd:DWORD
    LOCAL psCount:DWORD,        psBuf:DWORD,        pwsBuf:DWORD
    LOCAL szTypeLib[20]:BYTE,   pti:DWORD

    ; install the registry script
    invoke Register, TRUE
    ; make some strings
    invoke HeapAlloc, g_hHeap, NULL, ( MAX_PATH * 3 + 10)
    mov psBuf, eax
    add eax, MAX_PATH * 2
    mov pwsBuf, eax
    add eax, 10
    mov psCount, eax
    mov rCount, 1           ; init the resource number to #1
    invoke LoadString, g_hModule, IDS_TypeLib, ADDR szTypeLib, 20
NextTypeLib:
    ; loop to find the resource
    invoke FindResource,g_hModule, rCount, ADDR szTypeLib
    .IF !eax
        jmp return
    .ENDIF
    mov hres, eax
    invoke LoadResource, g_hModule, hres
    invoke LockResource, eax
    mov hres, eax
    mov eax, [eax]      ; get 1st 4 characters of this resource
    .IF eax != 5446534DH   ; belt-and-suspenders check to assure is TypeLib res
        ; 5446534DH = "TFSM", or "MSFT backwards, check for typelib resource
        jmp return
    .ENDIF
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    mov eax, psCount
    mov WORD PTR [eax], 005CH       ; "\", 0 string
    invoke lstrcat, psBuf, psCount  ; cat "\" onto FileName
    invoke dwtoa, rCount, psCount     
    invoke lstrcat, psBuf, psCount  ; cat "\####" onto FileName, where ####
                                    ;  is the resource number in string form
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    .IF !eax
        mov eax, S_FALSE
        jmp return
    .ENDIF
    lea eax, pti
    invoke LoadTypeLib, pwsBuf, eax
    .IF (eax != ERROR_SUCCESS)
        mov eax, S_FALSE
        jmp return
    .ENDIF
    ; and register the type lib
    invoke GetModuleFileName, g_hModule, psBuf, MAX_PATH
    invoke MultiByteToWideChar, CP_ACP, 0, psBuf, -1, pwsBuf, MAX_PATH
    invoke RegisterTypeLib, pti, pwsBuf, NULL
    .IF (eax != ERROR_SUCCESS)
        mov eax, S_FALSE
        jmp return
    .ELSE
        ; release the type info pointer we got
        mov eax, pti
        mov eax, [eax]
        coinvoke pti, IUnknown, Release
    .ENDIF
    inc rCount
    jmp NextTypeLib
return:
    ; clean up our buffers
    invoke HeapFree, g_hHeap, NULL, psBuf        
    xor eax, eax    ;    mov eax, S_OK
    ret
DllRegisterServer ENDP
;-------------------------------------------------------------------------------

end
