;-------------------------------------------------------------------------------
;  colibrary procedure DeallocObject 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; revised 2/24/01 to remove redundant destructor call
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\ole32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_ObjectCount:DWORD

.code
;-------------------------------------------------------------------------------

DeallocObject PROC PUBLIC pObject:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the DeallocObject method
;
;  internal function to destroy COM objects
;
; EXAMPLE:
;   invoke DeallocObject, pObject
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    invoke CoTaskMemFree, pObject                   	; releace the object
    dec g_ObjectCount                                   ; adjust the global lock count
    ret
DeallocObject ENDP
;-------------------------------------------------------------------------------

end
