;-------------------------------------------------------------------------------
;  colibrary procedure CreateInstance
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

CFmembers   STRUCT  DWORD
    m_pClassItem   DWORD       NULL
CFmembers   ENDS

; declare the ClassFactory object structure
; this is only run-time instanced
ClassFactObject STRUCT  DWORD
    ObjectData0     ObjectData  { }     ; base values
    CFMembers       CFmembers   { }     ; info on the object to impliment
    ObjectEntry0    ObjectEntry { }     ; non-delegating Unknown
    ObjectEntry1    ObjectEntry { }     ; IClassFactory   
ClassFactObject ENDS

.LISTALL
.code
;-------------------------------------------------------------------------------

CreateInstance PROC PUBLIC this_:DWORD, pUnknownOuter:DWORD, iid:DWORD, ppv:DWORD
             
;-------------------------------------------------------------------------------
; implimentation of the IClassFactory::CreateInstance method
;
;  main COM object creation method
;
; EXAMPLE:
;   coinvoke CreateInstance this_, ADDR  UnknownOuter, ADDR iid, ADDR ppv
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL pCFBase:DWORD,  pCFClassItem:DWORD, pObj:DWORD
    LOCAL pBase:DWORD,    pClassItem:DWORD,   hr:DWORD

    mov edx, this_                                  ; get object
    mov edx, (ObjectEntry PTR [edx]).m_pBase        ; walk to base data
    mov pCFBase, edx
    ; get the custom data, p->ClassItem we can create
    mov ecx,(ClassFactObject PTR [edx]).CFMembers.m_pClassItem
    mov pClassItem, ecx
    mov eax, (ClassItem PTR [ecx]).m_Flags
    AND eax, DISPINTERFACE
    .IF (pUnknownOuter) && ( eax )
        ; this object doesn't support aggregation
        ; and we were asked to agg it, thats a bad thing
        mov eax, CLASS_E_NOAGGREGATION
        jmp return
    .ENDIF
    ; OK to create our object
    invoke AllocObject, ADDR pObj, pClassItem, pUnknownOuter, NULL
    coinvoke pObj, IUnknown, QueryInterface, iid, ppv
    mov hr, eax 
    coinvoke pObj, IUnknown, Release
    mov eax, hr
return:
    ret
CreateInstance ENDP
;-------------------------------------------------------------------------------

end
