;-------------------------------------------------------------------------------
;  colibrary procedure ComQIPtrAssign 
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
;  revised 1/10/01 to add S_OK retval
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

.code
;-------------------------------------------------------------------------------

ComQIPtrAssign PROC PUBLIC pp:DWORD, lp:DWORD, riid:DWORD

;-------------------------------------------------------------------------------
; COM 'smart' pointer assignment
; (we can't do smart pointers, but this routine is handy none the less)
;
; performes pp <== QueryInterface lp, riid
;
;  first releases any existing pointer in pp
;
; EXAMPLE:
; invoke ComQIPtrAssign, ADDR pointerB, ADDR pointerA
;
; Uses: eax, ecx, edx
;
;
;  NOTE: this is completely untested
;
;-------------------------------------------------------------------------------
LOCAL pTemp:DWORD
    mov ecx, pp
    mov eax, [ecx]
    mov pTemp, eax  ; pTemp = *pp
    mov eax, NULL
    mov [ecx], eax  ; *pp = NULL
    .IF lp
        coinvoke lp, IUnknown, QueryInterface, riid, pp
    .ENDIF
    .IF pTemp
        coinvoke pTemp, IUnknown, Release
    .ENDIF
    mov ecx, pp     ; pp
    mov eax, [ecx]  ; *pp
    xor eax, eax    ; return S_OK    
    ret
ComQIPtrAssign ENDP
;-------------------------------------------------------------------------------

end
