;-------------------------------------------------------------------------------
;  colibrary procedure AddReplacements
;
; -------------------------------------------------------
; This procedure was written by Ernest Murphy    9/27/00
;
; Copyright (c) 9/28/00  Ernest Murphy
; For educational use only. Any commercial re-use only by written license
;
; -------------------------------------------------------
.NOLIST
.386
.model flat, stdcall  ; 32 bit memory model
option casemap :none  ; case sensitive

include     mini_win.inc	; 'just enough' of windows.inc (speeds build)
include     \masm32\include\oleaut32.inc
include     \masm32\include\user32.inc
include     \masm32\include\kernel32.inc
include     \masm32\include\masm32.inc
include     \masm32\COM\include\oaidl.inc

include     colib.inc

externdef   g_hModule:DWORD
externdef   g_hHeap:DWORD


.code
;-------------------------------------------------------------------------------

AddReplacements PROC PUBLIC pszToken:DWORD
             
;-------------------------------------------------------------------------------
; internal lib function, used to replace the compile time 
;   symbols "%MODULE% with its runtime value
;
; EXAMPLE:
;   invoke AddReplacements, ADDR szToken
;
; Uses: eax, ecx, edx
;
;
;-------------------------------------------------------------------------------
    LOCAL  pszRetBuf:DWORD,            cNewLength:DWORD
    LOCAL  cLeft:DWORD,                cRight:DWORD
    LOCAL  cCount:DWORD,               pszToken2:DWORD
    LOCAL  szSpace:DWORD
    LOCAL  szBuffer[MAX_TOKEN]:BYTE,   szTemp[MAX_PATH]:BYTE


    lReplacement    EQU     8     ;(length of "%MODULE%")
    ; get %MODULE% string
    invoke LoadString, g_hModule, IDS_MODULE, ADDR szBuffer, MAX_PATH
    invoke lstrcmp, pszToken, ADDR szBuffer
    test eax, eax
    lea eax, [eax+1]
    jz testInStr
    pushad              ; push and pop all to work-around
    invoke InString, 1, pszToken, ADDR szBuffer  ; === has bug preserving regs
    mov cLeft,eax       ; (save the retval)
    popad               ; pop all for InString bug
    mov eax, cLeft      ; (restore the retval)  
testInStr:
    .IF eax > SDWORD PTR 0
        ; need to do a replacement
        ; initialize counts on the replaced string 
        dec eax                 ; start pos -1
        mov cLeft, eax          ; which is cLeft
        add eax, lReplacement   
        mov cRight, eax         ; count of last replaced char
        ; get our module name for the replacement
        invoke GetModuleFileName, g_hModule, ADDR szTemp, MAX_TOKEN
        mov cNewLength, eax     ; char count of FilePathName
        invoke lstrlen, pszToken
        mov cCount, eax         ; char count of complete Token
        sub eax, cRight         ; length - count to last replaced char
        mov cRight, eax
        mov eax, cNewLength
        add eax, cCount         ; count = complete Token + FilePathName
        sub eax, lReplacement   ; remove %MODULE% from the count
        inc eax                 ; and add place for terminating zero
        mov cNewLength, eax
        invoke HeapAlloc, g_hHeap, NULL, cNewLength
        mov pszRetBuf, eax
        xor ecx, ecx
        mov [eax], ecx            ;  null our new string
        .IF cLeft != 0
            invoke lstr, pszToken, pszRetBuf, cLeft
        .ENDIF
        invoke lstrcat, pszRetBuf, ADDR szTemp
        .IF cRight != 0
            mov szTemp, 0
            invoke rstr, pszToken, ADDR szTemp, cRight
            invoke lstrcat, pszRetBuf, ADDR szTemp
        .ENDIF
returnNew:
        mov eax, pszRetBuf
    .ELSE
        xor eax, eax
    .ENDIF
    ret
AddReplacements ENDP
;-------------------------------------------------------------------------------

end
