;-------------------------------------------------------------------------------
;
; bstrLib procedure PathFromPathName    PROTO :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; useage prototype:
;
;    invoke PathFromPathName, bstrSamplePath, addr bstrPath
;
; Description: extracts the path name from bstrSamplePath (a filepathname)
;   and returns it in *bstrPath
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
PathFromPathName    PROC PUBLIC bstrFileName:DWORD, pbstrPath:DWORD
    LOCAL dwLength:DWORD
    
    mov edx, bstrFileName
    mov ecx, edx
    .REPEAT
        mov ax, WORD PTR [edx] ; make mov ax after debug
        .IF ax == 92 ; "\" in unicode
            mov ecx, edx
        .ENDIF
        add edx, 2
    .UNTIL  ax == 0
    ; ecx now points to the last "\"        
    add ecx, 2                ; point to name
    sub ecx, bstrFileName
    ror ecx, 1                  ; convert bytes to chars
    mov dwLength, ecx
    ; now copy JUST the name
    invoke SysReAllocStringLen, pbstrPath, bstrFileName, dwLength
    xor eax, eax
    ret
PathFromPathName ENDP
;-------------------------------------------------------------------------------
end

