;-------------------------------------------------------------------------------
;
; bstrLib procedure NewPathToPathName    PROTO :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
;   useage prototype:
;
;    invoke NewPathToPathName, bstrMyNewPath, ADDR bstrFilePathName
;
; Description: replaces the path in *bstrFilePathName (a filepathname)
;   with that in bstrMyNewPath
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc
include     \masm32\include\ole32.inc
include     \masm32\include\kernel32.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
NewPathToPathName   PROC PUBLIC bstrNewPath:DWORD, pbstrFileName:DWORD
    LOCAL bstrOldName:DWORD, dwLength:DWORD, dwLengthPath:DWORD, pwzTemp:DWORD

    ; use previous function to get the current name
    mov bstrOldName, 0      ; NULL the null pointer
    mov ecx, pbstrFileName
    mov ecx, [ecx]
    invoke NameFromPathName, ecx, ADDR bstrOldName 
    ; compute total length of both strings
    invoke SysStringByteLen, bstrNewPath
    mov dwLengthPath, eax
    mov dwLength, eax
    invoke SysStringByteLen, bstrOldName
    add dwLength, eax
    add dwLength, 2        ; now have char count in dwLength (plus a spare)
    ; make a buffer to hold both strings cat-ed together
    invoke CoTaskMemAlloc, dwLength
    mov pwzTemp, eax
    ; copy path into this buffer
    invoke lstrcpyW, pwzTemp, bstrNewPath
    ; inspect the last char in the buffer (it needs to be '\')
    mov ecx, pwzTemp
    add ecx, dwLengthPath
    mov ax, WORD PTR [ecx]
    .IF ax != "\"       ; if not '\', we put that there
        mov eax, 92     ; 00000092 = '\', 0
        mov [ecx], eax
    .ENDIF
    ; cat filename to the well-formed path
    invoke lstrcatW, pwzTemp, bstrOldName
    ; make a bstr from the buffer in the return pointer
    invoke SysReAllocString, pbstrFileName, pwzTemp
    ; clean up the strings we made
    invoke SysFreeString, bstrOldName
    invoke CoTaskMemFree, pwzTemp
    ret
NewPathToPathName   ENDP
;-------------------------------------------------------------------------------


end

