;-------------------------------------------------------------------------------
;
; bstrLib procedure NewNameToPathName    PROTO :DWORD, :DWORD
;
; Copyright (c) 2/28/01  Ernest Murphy
;
; For educational use only. Any commercial re-use only by written license
;
; NewNameToPathName   PROTO :DWORD, :DWORD
;
;   useage prototype:
;
;    invoke NewNameToPathName, bstrMyNewFile, ADDR bstrFilePathName
;
; Description: replaces the file name in *bstrFilePathName (a filepathname)
;   with that in bstrMyNewFile
;
;-------------------------------------------------------------------------------
.NOLIST
.386
.model flat, stdcall
option casemap:none ; case sensitive
;-------------------------------------------------------------------------------

include     bstrLib.inc
include     \masm32\include\oleaut32.inc
include     \masm32\com\include\L.inc
include     \masm32\include\ole32.inc
include     \masm32\include\kernel32.inc

;-------------------------------------------------------------------------------
.LISTALL
.code
;-------------------------------------------------------------------------------
NewNameToPathName   PROC PUBLIC bstrNewName:DWORD, pbstrFileName:DWORD
    LOCAL bstrOldPath:DWORD, dwLength:DWORD, pwzTemp:DWORD

    ; use previous function to get the current path
    mov bstrOldPath, 0      ; NULL the null pointer
    mov ecx, pbstrFileName
    mov ecx, [ecx]
    invoke PathFromPathName, ecx, ADDR bstrOldPath 
    ; compute total length of both strings
    invoke SysStringByteLen, bstrNewName
    mov dwLength, eax
    invoke SysStringByteLen, bstrOldPath
    add dwLength, eax
    inc dwLength        ; now have char count in dwLength
    ; make a buffer to hold both strings cat-ed together
    invoke CoTaskMemAlloc, dwLength
    mov pwzTemp, eax
    ; cat together in this buffer
    invoke lstrcpyW, pwzTemp, bstrOldPath
    
    invoke lstrcatW, pwzTemp, bstrNewName
    ; make a bstr from the buffer in the return pointer
    invoke SysReAllocString, pbstrFileName, pwzTemp
    ; clean up the strings we made
    invoke SysFreeString, bstrOldPath
    invoke CoTaskMemFree, pwzTemp
    ret
NewNameToPathName   ENDP

;-------------------------------------------------------------------------------

end

